/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;

public class HighOther
extends HighVariable {
    private Address pcaddr;
    private HighSymbol symbol;

    public HighOther(HighFunction high) {
        super(high);
    }

    public HighOther(DataType type, Varnode vn, Varnode[] inst, Address pc, HighFunction func) {
        super(null, type, vn, inst, func);
        this.pcaddr = pc;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int attribId;
        long symref = 0L;
        this.offset = -1;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_OFFSET.id()) {
                this.offset = (int)decoder.readSignedInteger();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_SYMREF.id()) continue;
            symref = decoder.readUnsignedInteger();
        }
        this.decodeInstances(decoder);
        this.name = "UNNAMED";
        this.pcaddr = this.function.getPCAddress(this.represent);
        if (symref != 0L) {
            this.symbol = this.function.getLocalSymbolMap().getSymbol(symref);
            if (this.symbol != null && this.offset < 0) {
                this.name = this.symbol.getName();
            }
        }
    }
}

