/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;

public class MemReferenceImpl
implements Reference {
    private Address fromAddr;
    private Address toAddr;
    protected RefType refType;
    protected int opIndex;
    protected SourceType sourceType;
    protected long symbolID;
    protected boolean isPrimary;

    public MemReferenceImpl(Address fromAddr, Address toAddr, RefType refType, SourceType sourceType, int opIndex, boolean isPrimary) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.refType = refType;
        this.opIndex = opIndex;
        this.sourceType = sourceType;
        this.isPrimary = isPrimary;
        this.symbolID = -1L;
    }

    @Override
    public Address getFromAddress() {
        return this.fromAddr;
    }

    @Override
    public Address getToAddress() {
        return this.toAddr;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public long getSymbolID() {
        return this.symbolID;
    }

    @Override
    public RefType getReferenceType() {
        return this.refType;
    }

    @Override
    public int getOperandIndex() {
        return this.opIndex;
    }

    @Override
    public boolean isMnemonicReference() {
        return !this.isOperandReference();
    }

    @Override
    public boolean isOperandReference() {
        return this.opIndex >= 0;
    }

    @Override
    public int compareTo(Reference ref) {
        int result = this.fromAddr.compareTo(ref.getFromAddress());
        if (result == 0 && (result = this.opIndex - ref.getOperandIndex()) == 0) {
            return this.toAddr.compareTo(ref.getToAddress());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference ref = (Reference)obj;
        return this.isMemoryReference() && this.fromAddr.equals(ref.getFromAddress()) && this.toAddr.equals(ref.getToAddress()) && this.opIndex == ref.getOperandIndex() && this.symbolID == ref.getSymbolID() && this.isPrimary == ref.isPrimary() && this.sourceType == ref.getSource() && this.refType == ref.getReferenceType() && this.isShiftedReference() == ref.isShiftedReference() && this.isOffsetReference() == ref.isOffsetReference();
    }

    @Override
    public boolean isExternalReference() {
        return false;
    }

    @Override
    public boolean isOffsetReference() {
        return false;
    }

    @Override
    public boolean isShiftedReference() {
        return false;
    }

    @Override
    public boolean isEntryPointReference() {
        return false;
    }

    @Override
    public boolean isMemoryReference() {
        return true;
    }

    @Override
    public boolean isRegisterReference() {
        return false;
    }

    @Override
    public boolean isStackReference() {
        return false;
    }

    @Override
    public SourceType getSource() {
        return this.sourceType;
    }

    public void setSource(SourceType source) {
        this.sourceType = source;
    }
}

