/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredOutputStream
extends OutputStream {
    private static final int PROGRESS_INCREMENT = 32768;
    protected OutputStream out;
    private TaskMonitor monitor;
    private int smallCount = 0;
    private long count = 0L;

    public MonitoredOutputStream(OutputStream out, TaskMonitor monitor) {
        this.out = out;
        this.monitor = monitor;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.smallCount;
        if (this.smallCount >= 32768) {
            if (this.monitor.isCancelled()) {
                throw new IOCancelledException();
            }
            this.count += (long)this.smallCount;
            this.smallCount = 0;
            this.monitor.setProgress(this.count);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.smallCount += len;
        if (this.smallCount >= 32768) {
            if (this.monitor.isCancelled()) {
                throw new IOCancelledException();
            }
            this.count += (long)this.smallCount;
            this.smallCount = 0;
            this.monitor.setProgress(this.count);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }
}

