/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.action.AutoMapSpec;
import ghidra.debug.api.modules.MapProposal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;

public class BySectionAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "1_MAP_BY_SECTION";

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Auto-Map by Section";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.ICON_CONFIG;
    }

    public Collection<TraceEvent<?, ?>> getChangeTypes() {
        return List.of(TraceEvents.SECTION_ADDED);
    }

    public boolean objectHasType(TraceObjectValue value) {
        return value.getParent().queryInterface(TraceSection.class) != null;
    }

    public String getInfoForObjects(Trace trace, long snap) {
        return trace.getModuleManager().getAllSections().stream().filter(s -> s.isValid(snap)).map(s -> s.getName(snap) + ":" + String.valueOf(s.getStart(snap))).sorted().collect(Collectors.joining(","));
    }

    public List<Program> programs(ProgramManager programManager) {
        return Arrays.asList(programManager.getAllOpenPrograms());
    }

    public boolean performMapping(DebuggerStaticMappingService mappingService, Trace trace, long snap, List<Program> programs, TaskMonitor monitor) throws CancelledException {
        Map maps = mappingService.proposeSectionMaps(trace.getModuleManager().getLoadedModules(snap), snap, programs);
        Collection entries = MapProposal.flatten(maps.values());
        entries = MapProposal.removeOverlapping((Collection)entries);
        mappingService.addSectionMappings(entries, monitor, false);
        return !entries.isEmpty();
    }
}

