/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import db.Transaction;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GColor;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.data.AbstractSettingsDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegisterActionContext;
import ghidra.app.plugin.core.debug.gui.register.RegisterRow;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchActionContext;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesPlugin;
import ghidra.app.plugin.core.debug.gui.watch.DefaultWatchRow;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.DebuggerWatchesService;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.watch.WatchRow;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressCollectors;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdom.Element;

public class DebuggerWatchesProvider
extends ComponentProviderAdapter
implements DebuggerWatchesService {
    private static final String KEY_ROW_COUNT = "rowCount";
    private static final String PREFIX_ROW = "row";
    private static final Color COLOR_FOREGROUND_STALE = new GColor("color.debugger.plugin.resources.watch.stale");
    private static final Color COLOR_FOREGROUND_STALE_SEL = new GColor("color.debugger.plugin.resources.watch.stale.selected");
    private static final Color COLOR_FOREGROUND_CHANGED = new GColor("color.debugger.plugin.resources.watch.changed");
    private static final Color COLOR_FOREGROUND_CHANGED_SEL = new GColor("color.debugger.plugin.resources.watch.changed.selected");
    final DebuggerWatchesPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    SleighLanguage language;
    PcodeExecutor<DebuggerPcodeUtils.WatchValue> asyncWatchExecutor;
    PcodeExecutor<byte[]> prevValueExecutor;
    ExecutorService workQueue = Executors.newSingleThreadExecutor(new ThreadFactory(this){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Watch Evaluator");
        }
    });
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    protected DebuggerControlService controlService;
    @AutoServiceConsumed
    DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private final AddressSet changed = new AddressSet();
    private final AsyncDebouncer<Void> changeDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    private ForDepsListener forDepsListener = new ForDepsListener();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    protected final WatchTableModel watchTableModel;
    protected GhidraTable watchTable;
    protected GhidraTableFilterPanel<DefaultWatchRow> watchFilterPanel;
    ToggleDockingAction actionEnableEdits;
    DockingAction actionApplyDataType;
    DockingAction actionSelectRange;
    DockingAction actionSelectAllReads;
    DockingAction actionAdd;
    DockingAction actionRemove;
    DockingAction actionDataTypeSettings;
    DockingAction actionAddFromLocation;
    DockingAction actionAddFromRegister;
    private DebuggerWatchActionContext myActionContext;

    protected static void copySettings(Settings src, Settings dst, SettingsDefinition[] defs) {
        for (SettingsDefinition sd : defs) {
            sd.copySetting(src, dst);
        }
    }

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getPlatform(), b.getPlatform())) {
            return false;
        }
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerWatchesProvider(DebuggerWatchesPlugin plugin) {
        super(plugin.getTool(), "Watches", plugin.getName());
        this.plugin = plugin;
        this.watchTableModel = new WatchTableModel(this.tool);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_WATCHES);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_WATCHES);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.createActions();
        this.setVisible(true);
        this.contextChanged();
        this.changeDebouncer.addListener(__ -> this.doCheckDepsAndReevaluate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChanged(AddressRange toAdd) {
        AddressSet addressSet = this.changed;
        synchronized (addressSet) {
            this.changed.add(toAdd);
            this.changeDebouncer.contact(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressSetView clearChanged(boolean get) {
        AddressSet addressSet = this.changed;
        synchronized (addressSet) {
            AddressSet result = get ? new AddressSet((AddressSetView)this.changed) : null;
            this.changed.clear();
            return result;
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext != null) {
            return this.myActionContext;
        }
        return super.getActionContext(event);
    }

    protected void buildMainPanel() {
        this.watchTable = new GhidraTable((TableModel)((Object)this.watchTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.watchTable));
        this.watchFilterPanel = new GhidraTableFilterPanel((JTable)this.watchTable, (RowObjectTableModel)this.watchTableModel);
        this.mainPanel.add((Component)this.watchFilterPanel, "South");
        String namePrefix = "Watches";
        this.watchTable.setAccessibleNamePrefix(namePrefix);
        this.watchFilterPanel.setAccessibleNamePrefix(namePrefix);
        this.watchTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.contextChanged();
        });
        this.watchTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerWatchesProvider.this.navigateToSelectedWatch();
                }
            }
        });
        this.watchTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerWatchesProvider.this.navigateToSelectedWatch();
                }
            }
        });
        TableColumnModel columnModel = this.watchTable.getColumnModel();
        TableColumn addrCol = columnModel.getColumn(WatchTableColumns.ADDRESS.ordinal());
        addrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn valCol = columnModel.getColumn(WatchTableColumns.VALUE.ordinal());
        valCol.setCellRenderer((TableCellRenderer)((Object)new WatchValueCellRenderer()));
        TableColumn typeCol = columnModel.getColumn(WatchTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new WatchDataTypeEditor()));
    }

    public void contextChanged() {
        this.myActionContext = new DebuggerWatchActionContext(this, this.watchFilterPanel.getSelectedItems(), (Component)this.watchTable);
        super.contextChanged();
    }

    protected void navigateToSelectedWatch() {
        Object val;
        if (this.myActionContext == null) {
            return;
        }
        WatchRow row = this.myActionContext.getWatchRow();
        if (row == null) {
            return;
        }
        int modelCol = this.watchTable.convertColumnIndexToModel(this.watchTable.getSelectedColumn());
        Throwable error = row.getError();
        if (error != null) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Evaluation error", (Object)"Could not evaluate watch", (Throwable)error);
        } else if (modelCol == WatchTableColumns.ADDRESS.ordinal()) {
            Address address = row.getAddress();
            if (address != null) {
                this.navigateToAddress(address);
            }
        } else if (modelCol == WatchTableColumns.REPR.ordinal() && (val = row.getValueObject()) instanceof Address) {
            this.navigateToAddress((Address)val);
        }
    }

    protected void navigateToAddress(Address address) {
        if (this.listingService == null) {
            return;
        }
        if (address.isMemoryAddress()) {
            ProgramLocation loc = new ProgramLocation((Program)this.current.getView(), address);
            this.listingService.goTo(loc, true);
            return;
        }
    }

    protected void createActions() {
        this.actionEnableEdits = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.EnableEditsAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> {})).buildAndInstallLocal((ComponentProvider)this);
        this.actionApplyDataType = (DockingAction)DebuggerResources.ApplyDataTypeAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.selHasDataType((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedApplyDataType).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectRange = (DockingAction)DebuggerResources.SelectWatchRangeAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.listingService != null && this.selHasMemoryRanges((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedSelectRange).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectAllReads = (DockingAction)DebuggerResources.SelectWatchReadsAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.listingService != null && this.selHasMemoryReads((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedSelectReads).buildAndInstallLocal((ComponentProvider)this);
        this.actionAdd = (DockingAction)((ActionBuilder)DebuggerResources.AddAction.builder(this.plugin).onAction(this::activatedAdd)).buildAndInstallLocal((ComponentProvider)this);
        this.actionRemove = (DockingAction)DebuggerResources.RemoveAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> !ctx.getWatchRows().isEmpty()).onAction(this::activatedRemove).buildAndInstallLocal((ComponentProvider)this);
        this.actionDataTypeSettings = (DockingAction)WatchTypeSettings.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(this::selIsOneWithDataType).onAction(this::activatedDataTypeSettings).buildAndInstallLocal((ComponentProvider)this);
        this.actionAddFromLocation = (DockingAction)DebuggerResources.WatchAction.builder(this.plugin).withContext(ProgramLocationActionContext.class).enabledWhen(this::hasDynamicLocation).onAction(this::activatedAddFromLocation).buildAndInstall((Tool)this.tool);
        this.actionAddFromRegister = (DockingAction)DebuggerResources.WatchAction.builder(this.plugin).withContext(DebuggerRegisterActionContext.class).enabledWhen(this::hasValidWatchRegister).onAction(this::activatedAddFromRegister).buildAndInstall((Tool)this.tool);
    }

    protected boolean selHasDataType(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            Address address = row.getAddress();
            if (row.getDataType() == null || address == null || !address.isMemoryAddress() || row.getValueLength() == 0) continue;
            return true;
        }
        return false;
    }

    protected boolean selHasMemoryRanges(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            AddressRange rng = row.getRange();
            if (rng == null || !rng.getAddressSpace().isMemorySpace()) continue;
            return true;
        }
        return false;
    }

    protected boolean selHasMemoryReads(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            AddressSetView set = row.getReads();
            if (set == null) continue;
            for (AddressRange rng : set) {
                if (!rng.getAddressSpace().isMemorySpace()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean selIsOneWithDataType(DebuggerWatchActionContext ctx) {
        WatchRow row = ctx.getWatchRow();
        return row != null && row.getDataType() != null;
    }

    private void activatedApplyDataType(DebuggerWatchActionContext context) {
        if (this.current.getTrace() == null) {
            return;
        }
        ArrayList<CallSite> errs = new ArrayList<CallSite>();
        for (WatchRow row : context.getWatchRows()) {
            int size;
            Address address;
            DataType dataType = row.getDataType();
            if (dataType == null || (address = row.getAddress()) == null || !address.isMemoryAddress() || (size = row.getValueLength()) == 0) continue;
            Listing listing = this.current.getView().getListing();
            Data existing = listing.getDefinedDataAt(address);
            if (existing != null && existing.getDataType().isEquivalent(dataType)) {
                return;
            }
            Transaction tx = this.current.getTrace().openTransaction("Apply Watch Data Type");
            try {
                try {
                    listing.clearCodeUnits(row.getAddress(), row.getRange().getMaxAddress(), false);
                    Data data = listing.createData(address, dataType, size);
                    DebuggerWatchesProvider.copySettings(row.getSettings(), (Settings)data, dataType.getSettingsDefinitions());
                }
                catch (CodeUnitInsertionException e) {
                    errs.add((CallSite)((Object)(String.valueOf(address) + " " + String.valueOf(dataType) + "(" + size + "): " + e.getMessage())));
                }
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        if (!errs.isEmpty()) {
            StringBuffer msg = new StringBuffer("One or more types could not be applied:");
            for (String string : errs) {
                msg.append("\n    ");
                msg.append(string);
            }
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Apply Data Type", (Object)msg.toString());
        }
    }

    private void activatedSelectRange(DebuggerWatchActionContext context) {
        if (this.listingService == null) {
            return;
        }
        AddressSet sel = new AddressSet();
        for (WatchRow row : context.getWatchRows()) {
            AddressRange rng = row.getRange();
            if (rng == null) continue;
            sel.add(rng);
        }
        this.listingService.setCurrentSelection(new ProgramSelection((AddressSetView)sel));
    }

    private void activatedSelectReads(DebuggerWatchActionContext context) {
        if (this.listingService == null) {
            return;
        }
        AddressSet sel = new AddressSet();
        for (WatchRow row : context.getWatchRows()) {
            AddressSetView reads = row.getReads();
            if (reads == null) continue;
            sel.add(reads);
        }
        this.listingService.setCurrentSelection(new ProgramSelection((AddressSetView)sel));
    }

    private void activatedAdd(ActionContext ignored) {
        this.addWatch("");
    }

    private void activatedRemove(DebuggerWatchActionContext context) {
        this.watchTableModel.deleteWith(context.getWatchRows()::contains);
    }

    private void activatedDataTypeSettings(DebuggerWatchActionContext context) {
        WatchRow row = context.getWatchRow();
        if (row == null) {
            return;
        }
        DataType type = row.getDataType();
        if (type == null) {
            return;
        }
        this.tool.showDialog((DialogComponentProvider)new WatchDataSettingsDialog(row));
    }

    private ProgramLocation getDynamicLocation(ProgramLocation someLoc) {
        if (someLoc == null) {
            return null;
        }
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return null;
        }
        Program program = someLoc.getProgram();
        if (program == null) {
            return null;
        }
        if (program instanceof TraceProgramView) {
            return someLoc;
        }
        return this.mappingService.getDynamicLocationFromStatic(view, someLoc);
    }

    private AddressSetView getDynamicAddresses(Program program, AddressSetView set) {
        if (program instanceof TraceProgramView) {
            return set;
        }
        if (set == null) {
            return null;
        }
        return (AddressSetView)this.mappingService.getOpenMappedViews(program, set).entrySet().stream().filter(e -> ((TraceSpan)e.getKey()).getTrace() == this.current.getTrace()).filter(e -> ((TraceSpan)e.getKey()).getSpan().contains(this.current.getSnap())).flatMap(e -> ((Collection)e.getValue()).stream()).map(r -> r.getDestinationAddressRange()).collect(AddressCollectors.toAddressSet());
    }

    private boolean hasDynamicLocation(ProgramLocationActionContext context) {
        ProgramLocation dynLoc = this.getDynamicLocation(context.getLocation());
        return dynLoc != null;
    }

    private boolean tryForSelection(ProgramLocationActionContext context) {
        AddressSetView dynSel = this.getDynamicAddresses(context.getProgram(), (AddressSetView)context.getSelection());
        if (dynSel == null || dynSel.isEmpty()) {
            return false;
        }
        for (AddressRange rng : dynSel) {
            this.addWatch(TraceSleighUtils.generateExpressionForRange((Language)this.current.getTrace().getBaseLanguage(), (AddressRange)rng));
        }
        return true;
    }

    private boolean tryForDataInListing(ProgramLocationActionContext context) {
        if (!(context instanceof ListingActionContext)) {
            return false;
        }
        ListingActionContext lac = (ListingActionContext)context;
        CodeUnit cu = lac.getCodeUnit();
        if (cu == null) {
            return false;
        }
        AddressSet cuAs = new AddressSet();
        cuAs.add(cu.getMinAddress(), cu.getMaxAddress());
        AddressSetView dynCuAs = this.getDynamicAddresses(context.getProgram(), (AddressSetView)cuAs);
        if (dynCuAs.getNumAddressRanges() != 1) {
            return false;
        }
        AddressRange dynCuRng = dynCuAs.getFirstRange();
        if (dynCuRng.getLength() != (long)cu.getLength()) {
            return false;
        }
        DefaultWatchRow row = this.addWatch(TraceSleighUtils.generateExpressionForRange((Language)this.current.getTrace().getBaseLanguage(), (AddressRange)dynCuRng));
        if (cu instanceof Data) {
            Data data = (Data)cu;
            row.setDataType(data.getDataType());
        }
        return true;
    }

    private boolean trySingleAddress(ProgramLocationActionContext context) {
        ProgramLocation dynLoc = this.getDynamicLocation(context.getLocation());
        if (dynLoc == null) {
            return false;
        }
        this.addWatch(TraceSleighUtils.generateExpressionForRange((Language)this.current.getTrace().getBaseLanguage(), (AddressRange)new AddressRangeImpl(dynLoc.getAddress(), dynLoc.getAddress())));
        return true;
    }

    private void activatedAddFromLocation(ProgramLocationActionContext context) {
        if (this.tryForSelection(context)) {
            return;
        }
        if (this.tryForDataInListing(context)) {
            return;
        }
        this.trySingleAddress(context);
    }

    private boolean hasValidWatchRegister(DebuggerRegisterActionContext context) {
        RegisterRow row = context.getSelected();
        if (row == null) {
            return false;
        }
        return !row.getRegister().isProcessorContext();
    }

    private void activatedAddFromRegister(DebuggerRegisterActionContext context) {
        RegisterRow regRow = context.getSelected();
        if (regRow == null) {
            return;
        }
        Register reg = regRow.getRegister();
        if (reg.isProcessorContext()) {
            return;
        }
        DefaultWatchRow watchRow = this.addWatch(reg.getName());
        watchRow.setDataType(regRow.getDataType());
    }

    public DefaultWatchRow addWatch(String expression) {
        DefaultWatchRow row = new DefaultWatchRow(this, "");
        this.watchTableModel.add(row);
        row.setExpression(expression);
        return row;
    }

    public void removeWatch(WatchRow row) {
        this.watchTableModel.delete((DefaultWatchRow)row);
    }

    public synchronized List<WatchRow> getWatches() {
        return List.copyOf(this.watchTableModel.getModelData());
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.forDepsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.forDepsListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        for (DefaultWatchRow row : this.watchTableModel.getModelData()) {
            row.updateType();
        }
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        SleighLanguage slang;
        if (DebuggerWatchesProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.previous = this.current;
        this.current = coordinates;
        this.doSetTrace(this.current.getTrace());
        TracePlatform platform = this.current.getPlatform();
        Language lang = platform == null ? null : platform.getLanguage();
        this.language = lang instanceof SleighLanguage ? (slang = (SleighLanguage)lang) : null;
        try {
            this.asyncWatchExecutor = this.current.getPlatform() == null ? null : DebuggerPcodeUtils.buildWatchExecutor((ServiceProvider)this.tool, this.current);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Error constructing watch executor: " + String.valueOf(e)));
            this.asyncWatchExecutor = null;
        }
        try {
            this.prevValueExecutor = this.current.getPlatform() == null || this.previous.getPlatform() == null ? null : TraceSleighUtils.buildByteExecutor((TracePlatform)this.previous.getPlatform(), (long)this.previous.getViewSnap(), (TraceThread)this.previous.getThread(), (int)this.previous.getFrame());
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Error constructing previous-value executor: " + String.valueOf(e)));
            this.prevValueExecutor = null;
        }
        this.reevaluate();
    }

    public void traceClosed(Trace trace) {
        if (this.previous.getTrace() == trace) {
            this.previous = DebuggerCoordinates.NOWHERE;
            this.prevValueExecutor = null;
        }
    }

    protected void clearCachedState() {
        if (this.asyncWatchExecutor != null) {
            this.asyncWatchExecutor.getState().clear();
        }
        if (this.prevValueExecutor != null) {
            this.prevValueExecutor.getState().clear();
        }
    }

    public synchronized void doCheckDepsAndReevaluate() {
        AddressSetView changed = this.clearChanged(true);
        if (this.asyncWatchExecutor == null) {
            return;
        }
        ArrayList<DefaultWatchRow> toReevaluate = new ArrayList<DefaultWatchRow>();
        for (DefaultWatchRow row : this.watchTableModel.getModelData()) {
            AddressSetView reads = row.getReads();
            if (reads != null && !reads.intersects(changed)) continue;
            toReevaluate.add(row);
        }
        if (!toReevaluate.isEmpty()) {
            this.clearCachedState();
            for (DefaultWatchRow row : toReevaluate) {
                row.reevaluate();
            }
        }
    }

    public void reevaluate() {
        this.clearChanged(false);
        if (this.asyncWatchExecutor == null) {
            return;
        }
        this.clearCachedState();
        for (DefaultWatchRow row : this.watchTableModel.getModelData()) {
            row.reevaluate();
        }
    }

    public void writeConfigState(SaveState saveState) {
        List rows = List.copyOf(this.watchTableModel.getModelData());
        saveState.putInt(KEY_ROW_COUNT, rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            DefaultWatchRow row = (DefaultWatchRow)rows.get(i);
            String stateName = PREFIX_ROW + i;
            SaveState rowState = new SaveState();
            row.writeConfigState(rowState);
            saveState.putXmlElement(stateName, rowState.saveToXml());
        }
    }

    public void readConfigState(SaveState saveState) {
        int rowCount = saveState.getInt(KEY_ROW_COUNT, 0);
        ArrayList<DefaultWatchRow> rows = new ArrayList<DefaultWatchRow>();
        for (int i = 0; i < rowCount; ++i) {
            String stateName = PREFIX_ROW + i;
            Element rowElement = saveState.getXmlElement(stateName);
            if (rowElement == null) continue;
            DefaultWatchRow r = new DefaultWatchRow(this, "");
            SaveState rowState = new SaveState(rowElement);
            r.readConfigState(rowState);
            rows.add(r);
        }
        this.watchTableModel.clear();
        this.watchTableModel.addAll(rows);
    }

    public boolean isEditsEnabled() {
        return this.actionEnableEdits.isSelected();
    }

    public void goToTime(TraceSchedule time) {
        this.traceManager.activateTime(time);
    }

    public void waitEvaluate(int timeoutMs) {
        try {
            ((CompletableFuture)this.changeDebouncer.stable().thenRunAsync(() -> {}, this.workQueue)).get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    class ForDepsListener
    extends TraceDomainObjectListener {
        public ForDepsListener() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, this::objectRestored);
            this.listenFor((TraceEvent)TraceEvents.BYTES_CHANGED, this::bytesChanged);
            this.listenFor((TraceEvent)TraceEvents.BYTES_STATE_CHANGED, this::stateChanged);
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            for (AddressSpace space : DebuggerWatchesProvider.this.current.getTrace().getBaseAddressFactory().getAllAddressSpaces()) {
                if (!space.isRegisterSpace() && !space.isMemorySpace()) continue;
                DebuggerWatchesProvider.this.addChanged((AddressRange)new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress()));
            }
        }

        private void bytesChanged(AddressSpace space, TraceAddressSnapRange range) {
            if (space.isMemorySpace() || DebuggerWatchesProvider.this.current.isRegisterSpace(space)) {
                DebuggerWatchesProvider.this.addChanged(range.getRange());
            }
        }

        private void stateChanged(AddressSpace space, TraceAddressSnapRange range) {
            if (space.isMemorySpace() || DebuggerWatchesProvider.this.current.isRegisterSpace(space)) {
                DebuggerWatchesProvider.this.addChanged(range.getRange());
            }
        }
    }

    protected static class WatchTableModel
    extends DefaultEnumeratedColumnTableModel<WatchTableColumns, DefaultWatchRow> {
        public WatchTableModel(PluginTool tool) {
            super(tool, "Watches", WatchTableColumns.class);
        }
    }

    protected static enum WatchTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<WatchTableColumns, DefaultWatchRow>
    {
        EXPRESSION("Expression", String.class, WatchRow::getExpression, WatchRow::setExpression),
        COMMENT("Comment", String.class, WatchRow::getComment, WatchRow::setComment),
        ADDRESS("Address", Address.class, WatchRow::getAddress),
        SYMBOL("Symbol", Symbol.class, WatchRow::getSymbol),
        VALUE("Value", String.class, WatchRow::getRawValueString, WatchRow::setRawValueString, WatchRow::isRawValueEditable),
        TYPE("Type", DataType.class, WatchRow::getDataType, WatchRow::setDataType),
        REPR("Repr", String.class, WatchRow::getValueString, WatchRow::setValueString, WatchRow::isValueEditable),
        ERROR("Error", String.class, WatchRow::getErrorMessage);

        private final String header;
        private final Function<WatchRow, ?> getter;
        private final BiConsumer<WatchRow, Object> setter;
        private final Predicate<WatchRow> editable;
        private final Class<?> cls;

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter, BiConsumer<WatchRow, T> setter, Predicate<WatchRow> editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
        }

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter, BiConsumer<WatchRow, T> setter) {
            this(header, cls, getter, setter, null);
        }

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter) {
            this(header, cls, getter, null, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(DefaultWatchRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public void setValueOf(DefaultWatchRow row, Object value) {
            this.setter.accept(row, value);
        }

        public boolean isEditable(DefaultWatchRow row) {
            return this.setter != null && (this.editable == null || this.editable.test(row));
        }
    }

    class WatchValueCellRenderer
    extends AbstractGColumnRenderer<String> {
        WatchValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            WatchRow row = (WatchRow)data.getRowObject();
            if (!row.isKnown()) {
                if (data.isSelected()) {
                    this.setForeground(COLOR_FOREGROUND_STALE_SEL);
                } else {
                    this.setForeground(COLOR_FOREGROUND_STALE);
                }
            } else if (row.isChanged()) {
                if (data.isSelected()) {
                    this.setForeground(COLOR_FOREGROUND_CHANGED_SEL);
                } else {
                    this.setForeground(COLOR_FOREGROUND_CHANGED);
                }
            }
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    class WatchDataTypeEditor
    extends DataTypeTableCellEditor {
        public WatchDataTypeEditor() {
            super(DebuggerWatchesProvider.this.plugin.getTool());
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            if (DebuggerWatchesProvider.this.currentTrace == null) {
                return dataType;
            }
            try (Transaction tx = DebuggerWatchesProvider.this.currentTrace.openTransaction("Resolve DataType");){
                DataType dataType2 = DebuggerWatchesProvider.this.currentTrace.getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    static interface WatchTypeSettings {
        public static final String NAME = "Watch Type Settings";
        public static final String DESCRIPTION = "Set the watch's data type settings";
        public static final String HELP_ANCHOR = "type_settings";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected static class WatchDataSettingsDialog
    extends AbstractSettingsDialog {
        private final WatchRow row;

        public WatchDataSettingsDialog(WatchRow row) {
            super("Data Type Settings", row.getDataType().getSettingsDefinitions(), row.getSettings());
            this.row = row;
        }

        protected Settings getSettings() {
            return super.getSettings();
        }

        protected void okCallback() {
            super.okCallback();
        }

        protected String[] getSuggestedValues(StringSettingsDefinition settingsDefinition) {
            if (!settingsDefinition.supportsSuggestedValues()) {
                return null;
            }
            return settingsDefinition.getSuggestedValues(this.row.getSettings());
        }

        protected void applySettings() throws CancelledException {
            DebuggerWatchesProvider.copySettings(this.getSettings(), this.row.getSettings(), this.getSettingsDefinitions());
            this.row.settingsChanged();
        }
    }
}

