/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class TaintSourceBySymbolAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;
    private TaintState.MarkType mtype;

    public TaintSourceBySymbolAction(TaintPlugin plugin) {
        super("Mark Source (Symbol)");
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "TaintSourceSymbol"));
        this.setPopupMenuData(new MenuData(new String[]{"Taint", "Source (Symbol)"}, "Decompile"));
        this.plugin = plugin;
        this.mtype = TaintState.MarkType.SOURCE;
    }

    protected void mark(ClangToken token) {
        this.plugin.toggleIcon(this.mtype, token, true);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (this.plugin.getTaintState() == null) {
            return false;
        }
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return true;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return true;
        }
        return tokenAtCursor.isVariableRef();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        this.mark(context.getTokenAtCursor());
    }
}

