# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _zeromq_swig
else:
    import _zeromq_swig

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def high_res_timer_now() -> "gr::high_res_timer_type":
    r"""high_res_timer_now() -> gr::high_res_timer_type"""
    return _zeromq_swig.high_res_timer_now()

def high_res_timer_now_perfmon() -> "gr::high_res_timer_type":
    r"""high_res_timer_now_perfmon() -> gr::high_res_timer_type"""
    return _zeromq_swig.high_res_timer_now_perfmon()

def high_res_timer_tps() -> "gr::high_res_timer_type":
    r"""high_res_timer_tps() -> gr::high_res_timer_type"""
    return _zeromq_swig.high_res_timer_tps()

def high_res_timer_epoch() -> "gr::high_res_timer_type":
    r"""high_res_timer_epoch() -> gr::high_res_timer_type"""
    return _zeromq_swig.high_res_timer_epoch()
class pub_sink(object):
    r"""
    Sink the contents of a stream to a ZMQ PUB socket.

    This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming stream data to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::pub_sink.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether sink will serialize and pass tags over the link.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::pub_sink::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> pub_sink_sptr
        Sink the contents of a stream to a ZMQ PUB socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming stream data to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::pub_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.pub_sink_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pub_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pub_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_pub_sink

# Register pub_sink in _zeromq_swig:
_zeromq_swig.pub_sink_swigregister(pub_sink)
class pub_msg_sink(object):
    r"""
    Sink the contents of a msg port to a ZMQ PUB socket.

    This block acts a message port receiver and writes individual messages to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming messages to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::pub_msg_sink.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::pub_msg_sink::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=True) -> pub_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ PUB socket.

        This block acts a message port receiver and writes individual messages to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming messages to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::pub_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.pub_msg_sink_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pub_msg_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pub_msg_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_pub_msg_sink

# Register pub_msg_sink in _zeromq_swig:
_zeromq_swig.pub_msg_sink_swigregister(pub_msg_sink)
class push_sink(object):
    r"""
    Sink the contents of a stream to a ZMQ PUSH socket.

    This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUSH socket. A PUSH socket will round-robin send its messages to each connected ZMQ PULL socket, either another gr-zeromq source block or a regular, non-GNU Radio ZMQ socket.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::push_sink.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether sink will serialize and pass tags over the link.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::push_sink::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> push_sink_sptr
        Sink the contents of a stream to a ZMQ PUSH socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUSH socket. A PUSH socket will round-robin send its messages to each connected ZMQ PULL socket, either another gr-zeromq source block or a regular, non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::push_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.push_sink_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(push_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.push_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_push_sink

# Register push_sink in _zeromq_swig:
_zeromq_swig.push_sink_swigregister(push_sink)
class push_msg_sink(object):
    r"""
    Sink the contents of a msg port to a ZMQ PUSH socket.

    This block acts a message port receiver and writes individual messages to a ZMQ PUSH socket. The corresponding receiving ZMQ PULL socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::push_msg_sink.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::push_msg_sink::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=True) -> push_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ PUSH socket.

        This block acts a message port receiver and writes individual messages to a ZMQ PUSH socket. The corresponding receiving ZMQ PULL socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::push_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.push_msg_sink_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(push_msg_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.push_msg_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_push_msg_sink

# Register push_msg_sink in _zeromq_swig:
_zeromq_swig.push_msg_sink_swigregister(push_msg_sink)
class rep_sink(object):
    r"""
    Sink the contents of a stream to a ZMQ REP socket.

    This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ REP socket. A REP socket will only send its contents to an attached REQ socket when it requests items.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::rep_sink.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether sink will serialize and pass tags over the link.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::rep_sink::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> rep_sink_sptr
        Sink the contents of a stream to a ZMQ REP socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ REP socket. A REP socket will only send its contents to an attached REQ socket when it requests items.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::rep_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.rep_sink_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(rep_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.rep_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_rep_sink

# Register rep_sink in _zeromq_swig:
_zeromq_swig.rep_sink_swigregister(rep_sink)
class rep_msg_sink(object):
    r"""
    Sink the contents of a msg port to a ZMQ REP socket.

    This block acts a message port receiver and writes individual messages to a ZMQ REP socket. The corresponding receiving ZMQ REQ socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::rep_msg_sink.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::rep_msg_sink::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=True) -> rep_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ REP socket.

        This block acts a message port receiver and writes individual messages to a ZMQ REP socket. The corresponding receiving ZMQ REQ socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::rep_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.rep_msg_sink_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(rep_msg_sink self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.rep_msg_sink_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_rep_msg_sink

# Register rep_msg_sink in _zeromq_swig:
_zeromq_swig.rep_msg_sink_swigregister(rep_msg_sink)
class sub_source(object):
    r"""
    Receive messages on ZMQ SUB socket and source stream.

    This block will connect to a ZMQ PUB socket, then produce all incoming messages as streaming output.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::sub_source.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether source will look for and deserialize tags.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::sub_source::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> sub_source_sptr
        Receive messages on ZMQ SUB socket and source stream.

        This block will connect to a ZMQ PUB socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::sub_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.sub_source_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(sub_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.sub_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_sub_source

# Register sub_source in _zeromq_swig:
_zeromq_swig.sub_source_swigregister(sub_source)
class sub_msg_source(object):
    r"""
    Receive messages on ZMQ SUB socket and output async messages.

    This block will connect to a ZMQ PUB socket, then convert them to outgoing async messages

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::sub_msg_source.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::sub_msg_source::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=False) -> sub_msg_source_sptr
        Receive messages on ZMQ SUB socket and output async messages.

        This block will connect to a ZMQ PUB socket, then convert them to outgoing async messages

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::sub_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.sub_msg_source_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(sub_msg_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.sub_msg_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_sub_msg_source

# Register sub_msg_source in _zeromq_swig:
_zeromq_swig.sub_msg_source_swigregister(sub_msg_source)
class pull_source(object):
    r"""
    Receive messages on ZMQ PULL socket and source stream.

    This block will connect to a ZMQ PUSH socket, then produce all incoming messages as streaming output.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::pull_source.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether source will look for and deserialize tags.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::pull_source::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> pull_source_sptr
        Receive messages on ZMQ PULL socket and source stream.

        This block will connect to a ZMQ PUSH socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::pull_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.pull_source_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pull_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pull_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_pull_source

# Register pull_source in _zeromq_swig:
_zeromq_swig.pull_source_swigregister(pull_source)
class pull_msg_source(object):
    r"""
    Receive messages on ZMQ PULL socket and output async messages.

    This block will connect to a ZMQ PUSH socket, then convert received messages to outgoing async messages.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of gr::zeromq::pull_msg_source.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::pull_msg_source::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=False) -> pull_msg_source_sptr
        Receive messages on ZMQ PULL socket and output async messages.

        This block will connect to a ZMQ PUSH socket, then convert received messages to outgoing async messages.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::pull_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.pull_msg_source_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pull_msg_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pull_msg_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_pull_msg_source

# Register pull_msg_source in _zeromq_swig:
_zeromq_swig.pull_msg_source_swigregister(pull_msg_source)
class req_source(object):
    r"""
    Receive messages on ZMQ REQ socket and source stream.

    This block will connect to a ZMQ REP socket, then produce all incoming messages as streaming output.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::req_source.

    Args:
        itemsize : Size of a stream item in bytes.
        vlen : Vector length of the input items. Note that one vector is one item.
        address : ZMQ socket address specifier.
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
        pass_tags : Whether source will look for and deserialize tags.
        hwm : High Watermark to configure the socket to (-1 => zmq's default)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::req_source::sptr":
        r"""
        make(size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> req_source_sptr
        Receive messages on ZMQ REQ socket and source stream.

        This block will connect to a ZMQ REP socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::req_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.req_source_make(itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(req_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.req_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_req_source

# Register req_source in _zeromq_swig:
_zeromq_swig.req_source_swigregister(req_source)
class req_msg_source(object):
    r"""
    Receive messages on ZMQ REQ socket output async messages.

    This block will connect to a ZMQ REP socket, then resend all incoming messages as asynchronous messages.

    Constructor Specific Documentation:

    Return a shared_ptr to a new instance of zeromq::req_msg_source.

    Args:
        address : ZMQ socket address specifier
        timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
        bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::req_msg_source::sptr":
        r"""
        make(char * address, int timeout=100, bool bind=False) -> req_msg_source_sptr
        Receive messages on ZMQ REQ socket output async messages.

        This block will connect to a ZMQ REP socket, then resend all incoming messages as asynchronous messages.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::req_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.req_msg_source_make(address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(req_msg_source self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.req_msg_source_last_endpoint(self)
    __swig_destroy__ = _zeromq_swig.delete_req_msg_source

# Register req_msg_source in _zeromq_swig:
_zeromq_swig.req_msg_source_swigregister(req_msg_source)
class pub_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::pub_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pub_sink_sptr self) -> pub_sink_sptr
        __init__(pub_sink_sptr self, pub_sink p) -> pub_sink_sptr
        """
        _zeromq_swig.pub_sink_sptr_swiginit(self, _zeromq_swig.new_pub_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::pub_sink *":
        r"""__deref__(pub_sink_sptr self) -> pub_sink"""
        return _zeromq_swig.pub_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_pub_sink_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::pub_sink::sptr":
        r"""
        make(pub_sink_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> pub_sink_sptr
        Sink the contents of a stream to a ZMQ PUB socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming stream data to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::pub_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.pub_sink_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pub_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pub_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(pub_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.pub_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pub_sink_sptr self, int which, int delay)
        declare_sample_delay(pub_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.pub_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pub_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.pub_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pub_sink_sptr self, int multiple)"""
        return _zeromq_swig.pub_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pub_sink_sptr self) -> int"""
        return _zeromq_swig.pub_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pub_sink_sptr self) -> double"""
        return _zeromq_swig.pub_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pub_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.pub_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pub_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.pub_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pub_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pub_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pub_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.pub_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pub_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.pub_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pub_sink_sptr self, std::string level)"""
        return _zeromq_swig.pub_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pub_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pub_sink_sptr self) -> int"""
        return _zeromq_swig.pub_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pub_sink_sptr self, int m)"""
        return _zeromq_swig.pub_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pub_sink_sptr self)"""
        return _zeromq_swig.pub_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pub_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pub_sink_sptr self, int m)"""
        return _zeromq_swig.pub_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pub_sink_sptr self) -> int"""
        return _zeromq_swig.pub_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pub_sink_sptr self, int i) -> long"""
        return _zeromq_swig.pub_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pub_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(pub_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.pub_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pub_sink_sptr self, int i) -> long"""
        return _zeromq_swig.pub_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pub_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(pub_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.pub_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pub_sink_sptr self, int which) -> float
        pc_input_buffers_full(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pub_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pub_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pub_sink_sptr self, int which) -> float
        pc_output_buffers_full(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pub_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pub_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(pub_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pub_sink_sptr self) -> float"""
        return _zeromq_swig.pub_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pub_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.pub_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pub_sink_sptr self)"""
        return _zeromq_swig.pub_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pub_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.pub_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pub_sink_sptr self) -> int"""
        return _zeromq_swig.pub_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pub_sink_sptr self) -> int"""
        return _zeromq_swig.pub_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pub_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.pub_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pub_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pub_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pub_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pub_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pub_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pub_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pub_sink_sptr self) -> long"""
        return _zeromq_swig.pub_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pub_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.pub_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pub_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.pub_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pub_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pub_sink_sptr self, std::string name)"""
        return _zeromq_swig.pub_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pub_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.pub_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pub_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pub_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pub_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_sink_sptr_message_subscribers(self, which_port)

# Register pub_sink_sptr in _zeromq_swig:
_zeromq_swig.pub_sink_sptr_swigregister(pub_sink_sptr)

pub_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pub_sink = pub_sink.make;

class pub_msg_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::pub_msg_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pub_msg_sink_sptr self) -> pub_msg_sink_sptr
        __init__(pub_msg_sink_sptr self, pub_msg_sink p) -> pub_msg_sink_sptr
        """
        _zeromq_swig.pub_msg_sink_sptr_swiginit(self, _zeromq_swig.new_pub_msg_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::pub_msg_sink *":
        r"""__deref__(pub_msg_sink_sptr self) -> pub_msg_sink"""
        return _zeromq_swig.pub_msg_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_pub_msg_sink_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::pub_msg_sink::sptr":
        r"""
        make(pub_msg_sink_sptr self, char * address, int timeout=100, bool bind=True) -> pub_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ PUB socket.

        This block acts a message port receiver and writes individual messages to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming messages to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::pub_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.pub_msg_sink_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pub_msg_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pub_msg_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(pub_msg_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.pub_msg_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pub_msg_sink_sptr self, int which, int delay)
        declare_sample_delay(pub_msg_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.pub_msg_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pub_msg_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.pub_msg_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pub_msg_sink_sptr self, int multiple)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pub_msg_sink_sptr self) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pub_msg_sink_sptr self) -> double"""
        return _zeromq_swig.pub_msg_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pub_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.pub_msg_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pub_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.pub_msg_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pub_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_msg_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pub_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_msg_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pub_msg_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.pub_msg_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pub_msg_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.pub_msg_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pub_msg_sink_sptr self, std::string level)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pub_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_msg_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pub_msg_sink_sptr self) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pub_msg_sink_sptr self, int m)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pub_msg_sink_sptr self)"""
        return _zeromq_swig.pub_msg_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pub_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.pub_msg_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pub_msg_sink_sptr self, int m)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pub_msg_sink_sptr self) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pub_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.pub_msg_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pub_msg_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(pub_msg_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.pub_msg_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pub_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.pub_msg_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pub_msg_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(pub_msg_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.pub_msg_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pub_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pub_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pub_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pub_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pub_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pub_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(pub_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pub_msg_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pub_msg_sink_sptr self) -> float"""
        return _zeromq_swig.pub_msg_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pub_msg_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pub_msg_sink_sptr self)"""
        return _zeromq_swig.pub_msg_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pub_msg_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.pub_msg_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pub_msg_sink_sptr self) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pub_msg_sink_sptr self) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pub_msg_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.pub_msg_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pub_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_msg_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pub_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_msg_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pub_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pub_msg_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pub_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pub_msg_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pub_msg_sink_sptr self) -> long"""
        return _zeromq_swig.pub_msg_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pub_msg_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.pub_msg_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pub_msg_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.pub_msg_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pub_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.pub_msg_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pub_msg_sink_sptr self, std::string name)"""
        return _zeromq_swig.pub_msg_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pub_msg_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.pub_msg_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pub_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_msg_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pub_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_msg_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pub_msg_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.pub_msg_sink_sptr_message_subscribers(self, which_port)

# Register pub_msg_sink_sptr in _zeromq_swig:
_zeromq_swig.pub_msg_sink_sptr_swigregister(pub_msg_sink_sptr)

pub_msg_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pub_msg_sink = pub_msg_sink.make;

class push_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::push_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(push_sink_sptr self) -> push_sink_sptr
        __init__(push_sink_sptr self, push_sink p) -> push_sink_sptr
        """
        _zeromq_swig.push_sink_sptr_swiginit(self, _zeromq_swig.new_push_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::push_sink *":
        r"""__deref__(push_sink_sptr self) -> push_sink"""
        return _zeromq_swig.push_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_push_sink_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::push_sink::sptr":
        r"""
        make(push_sink_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> push_sink_sptr
        Sink the contents of a stream to a ZMQ PUSH socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUSH socket. A PUSH socket will round-robin send its messages to each connected ZMQ PULL socket, either another gr-zeromq source block or a regular, non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::push_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.push_sink_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(push_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.push_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(push_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.push_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(push_sink_sptr self, int which, int delay)
        declare_sample_delay(push_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.push_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(push_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.push_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(push_sink_sptr self, int multiple)"""
        return _zeromq_swig.push_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(push_sink_sptr self) -> int"""
        return _zeromq_swig.push_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(push_sink_sptr self) -> double"""
        return _zeromq_swig.push_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(push_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.push_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(push_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.push_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(push_sink_sptr self) -> bool"""
        return _zeromq_swig.push_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(push_sink_sptr self) -> bool"""
        return _zeromq_swig.push_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(push_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.push_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(push_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.push_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(push_sink_sptr self, std::string level)"""
        return _zeromq_swig.push_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(push_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(push_sink_sptr self) -> int"""
        return _zeromq_swig.push_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(push_sink_sptr self, int m)"""
        return _zeromq_swig.push_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(push_sink_sptr self)"""
        return _zeromq_swig.push_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(push_sink_sptr self) -> bool"""
        return _zeromq_swig.push_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(push_sink_sptr self, int m)"""
        return _zeromq_swig.push_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(push_sink_sptr self) -> int"""
        return _zeromq_swig.push_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(push_sink_sptr self, int i) -> long"""
        return _zeromq_swig.push_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(push_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(push_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.push_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(push_sink_sptr self, int i) -> long"""
        return _zeromq_swig.push_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(push_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(push_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.push_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(push_sink_sptr self, int which) -> float
        pc_input_buffers_full(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(push_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(push_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(push_sink_sptr self, int which) -> float
        pc_output_buffers_full(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(push_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(push_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(push_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(push_sink_sptr self) -> float"""
        return _zeromq_swig.push_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(push_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.push_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(push_sink_sptr self)"""
        return _zeromq_swig.push_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(push_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.push_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(push_sink_sptr self) -> int"""
        return _zeromq_swig.push_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(push_sink_sptr self) -> int"""
        return _zeromq_swig.push_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(push_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.push_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(push_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(push_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(push_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.push_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(push_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.push_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(push_sink_sptr self) -> long"""
        return _zeromq_swig.push_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(push_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.push_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(push_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.push_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(push_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(push_sink_sptr self, std::string name)"""
        return _zeromq_swig.push_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(push_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.push_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(push_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.push_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(push_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.push_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(push_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.push_sink_sptr_message_subscribers(self, which_port)

# Register push_sink_sptr in _zeromq_swig:
_zeromq_swig.push_sink_sptr_swigregister(push_sink_sptr)

push_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
push_sink = push_sink.make;

class push_msg_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::push_msg_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(push_msg_sink_sptr self) -> push_msg_sink_sptr
        __init__(push_msg_sink_sptr self, push_msg_sink p) -> push_msg_sink_sptr
        """
        _zeromq_swig.push_msg_sink_sptr_swiginit(self, _zeromq_swig.new_push_msg_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::push_msg_sink *":
        r"""__deref__(push_msg_sink_sptr self) -> push_msg_sink"""
        return _zeromq_swig.push_msg_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_push_msg_sink_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::push_msg_sink::sptr":
        r"""
        make(push_msg_sink_sptr self, char * address, int timeout=100, bool bind=True) -> push_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ PUSH socket.

        This block acts a message port receiver and writes individual messages to a ZMQ PUSH socket. The corresponding receiving ZMQ PULL socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::push_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.push_msg_sink_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(push_msg_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.push_msg_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(push_msg_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.push_msg_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(push_msg_sink_sptr self, int which, int delay)
        declare_sample_delay(push_msg_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.push_msg_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(push_msg_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.push_msg_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(push_msg_sink_sptr self, int multiple)"""
        return _zeromq_swig.push_msg_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(push_msg_sink_sptr self) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(push_msg_sink_sptr self) -> double"""
        return _zeromq_swig.push_msg_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(push_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.push_msg_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(push_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.push_msg_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(push_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.push_msg_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(push_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.push_msg_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(push_msg_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.push_msg_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(push_msg_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.push_msg_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(push_msg_sink_sptr self, std::string level)"""
        return _zeromq_swig.push_msg_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(push_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_msg_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(push_msg_sink_sptr self) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(push_msg_sink_sptr self, int m)"""
        return _zeromq_swig.push_msg_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(push_msg_sink_sptr self)"""
        return _zeromq_swig.push_msg_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(push_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.push_msg_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(push_msg_sink_sptr self, int m)"""
        return _zeromq_swig.push_msg_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(push_msg_sink_sptr self) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(push_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.push_msg_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(push_msg_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(push_msg_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.push_msg_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(push_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.push_msg_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(push_msg_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(push_msg_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.push_msg_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(push_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(push_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(push_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(push_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(push_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(push_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(push_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.push_msg_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(push_msg_sink_sptr self) -> float"""
        return _zeromq_swig.push_msg_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(push_msg_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.push_msg_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(push_msg_sink_sptr self)"""
        return _zeromq_swig.push_msg_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(push_msg_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.push_msg_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(push_msg_sink_sptr self) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(push_msg_sink_sptr self) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(push_msg_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.push_msg_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(push_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_msg_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(push_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_msg_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(push_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.push_msg_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(push_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.push_msg_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(push_msg_sink_sptr self) -> long"""
        return _zeromq_swig.push_msg_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(push_msg_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.push_msg_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(push_msg_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.push_msg_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(push_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.push_msg_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(push_msg_sink_sptr self, std::string name)"""
        return _zeromq_swig.push_msg_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(push_msg_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.push_msg_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(push_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.push_msg_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(push_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.push_msg_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(push_msg_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.push_msg_sink_sptr_message_subscribers(self, which_port)

# Register push_msg_sink_sptr in _zeromq_swig:
_zeromq_swig.push_msg_sink_sptr_swigregister(push_msg_sink_sptr)

push_msg_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
push_msg_sink = push_msg_sink.make;

class rep_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::rep_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rep_sink_sptr self) -> rep_sink_sptr
        __init__(rep_sink_sptr self, rep_sink p) -> rep_sink_sptr
        """
        _zeromq_swig.rep_sink_sptr_swiginit(self, _zeromq_swig.new_rep_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::rep_sink *":
        r"""__deref__(rep_sink_sptr self) -> rep_sink"""
        return _zeromq_swig.rep_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_rep_sink_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::rep_sink::sptr":
        r"""
        make(rep_sink_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> rep_sink_sptr
        Sink the contents of a stream to a ZMQ REP socket.

        This block acts a a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ REP socket. A REP socket will only send its contents to an attached REQ socket when it requests items.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::rep_sink.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether sink will serialize and pass tags over the link.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.rep_sink_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(rep_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.rep_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(rep_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.rep_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rep_sink_sptr self, int which, int delay)
        declare_sample_delay(rep_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.rep_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rep_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.rep_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rep_sink_sptr self, int multiple)"""
        return _zeromq_swig.rep_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rep_sink_sptr self) -> int"""
        return _zeromq_swig.rep_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rep_sink_sptr self) -> double"""
        return _zeromq_swig.rep_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rep_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.rep_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rep_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.rep_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rep_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rep_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rep_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.rep_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rep_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.rep_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rep_sink_sptr self, std::string level)"""
        return _zeromq_swig.rep_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rep_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rep_sink_sptr self) -> int"""
        return _zeromq_swig.rep_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rep_sink_sptr self, int m)"""
        return _zeromq_swig.rep_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rep_sink_sptr self)"""
        return _zeromq_swig.rep_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rep_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rep_sink_sptr self, int m)"""
        return _zeromq_swig.rep_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rep_sink_sptr self) -> int"""
        return _zeromq_swig.rep_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rep_sink_sptr self, int i) -> long"""
        return _zeromq_swig.rep_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rep_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(rep_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.rep_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rep_sink_sptr self, int i) -> long"""
        return _zeromq_swig.rep_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rep_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(rep_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.rep_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rep_sink_sptr self, int which) -> float
        pc_input_buffers_full(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rep_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rep_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rep_sink_sptr self, int which) -> float
        pc_output_buffers_full(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rep_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rep_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(rep_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(rep_sink_sptr self) -> float"""
        return _zeromq_swig.rep_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(rep_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.rep_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(rep_sink_sptr self)"""
        return _zeromq_swig.rep_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(rep_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.rep_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(rep_sink_sptr self) -> int"""
        return _zeromq_swig.rep_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(rep_sink_sptr self) -> int"""
        return _zeromq_swig.rep_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(rep_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.rep_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(rep_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(rep_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(rep_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.rep_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(rep_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.rep_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(rep_sink_sptr self) -> long"""
        return _zeromq_swig.rep_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(rep_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.rep_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(rep_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.rep_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(rep_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(rep_sink_sptr self, std::string name)"""
        return _zeromq_swig.rep_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(rep_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.rep_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(rep_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(rep_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(rep_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_sink_sptr_message_subscribers(self, which_port)

# Register rep_sink_sptr in _zeromq_swig:
_zeromq_swig.rep_sink_sptr_swigregister(rep_sink_sptr)

rep_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
rep_sink = rep_sink.make;

class rep_msg_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::rep_msg_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rep_msg_sink_sptr self) -> rep_msg_sink_sptr
        __init__(rep_msg_sink_sptr self, rep_msg_sink p) -> rep_msg_sink_sptr
        """
        _zeromq_swig.rep_msg_sink_sptr_swiginit(self, _zeromq_swig.new_rep_msg_sink_sptr(*args))

    def __deref__(self) -> "gr::zeromq::rep_msg_sink *":
        r"""__deref__(rep_msg_sink_sptr self) -> rep_msg_sink"""
        return _zeromq_swig.rep_msg_sink_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_rep_msg_sink_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=True) -> "gr::zeromq::rep_msg_sink::sptr":
        r"""
        make(rep_msg_sink_sptr self, char * address, int timeout=100, bool bind=True) -> rep_msg_sink_sptr
        Sink the contents of a msg port to a ZMQ REP socket.

        This block acts a message port receiver and writes individual messages to a ZMQ REP socket. The corresponding receiving ZMQ REQ socket can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::rep_msg_sink.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to bind
        """
        return _zeromq_swig.rep_msg_sink_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(rep_msg_sink_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.rep_msg_sink_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(rep_msg_sink_sptr self) -> unsigned int"""
        return _zeromq_swig.rep_msg_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rep_msg_sink_sptr self, int which, int delay)
        declare_sample_delay(rep_msg_sink_sptr self, unsigned int delay)
        """
        return _zeromq_swig.rep_msg_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rep_msg_sink_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.rep_msg_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rep_msg_sink_sptr self, int multiple)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rep_msg_sink_sptr self) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rep_msg_sink_sptr self) -> double"""
        return _zeromq_swig.rep_msg_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rep_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.rep_msg_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rep_msg_sink_sptr self) -> uint64_t"""
        return _zeromq_swig.rep_msg_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rep_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_msg_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rep_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_msg_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rep_msg_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.rep_msg_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rep_msg_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.rep_msg_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rep_msg_sink_sptr self, std::string level)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rep_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_msg_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rep_msg_sink_sptr self) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rep_msg_sink_sptr self, int m)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rep_msg_sink_sptr self)"""
        return _zeromq_swig.rep_msg_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rep_msg_sink_sptr self) -> bool"""
        return _zeromq_swig.rep_msg_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rep_msg_sink_sptr self, int m)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rep_msg_sink_sptr self) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rep_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.rep_msg_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rep_msg_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(rep_msg_sink_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.rep_msg_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rep_msg_sink_sptr self, int i) -> long"""
        return _zeromq_swig.rep_msg_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rep_msg_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(rep_msg_sink_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.rep_msg_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rep_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rep_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rep_msg_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rep_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rep_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rep_msg_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(rep_msg_sink_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.rep_msg_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(rep_msg_sink_sptr self) -> float"""
        return _zeromq_swig.rep_msg_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(rep_msg_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(rep_msg_sink_sptr self)"""
        return _zeromq_swig.rep_msg_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(rep_msg_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.rep_msg_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(rep_msg_sink_sptr self) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(rep_msg_sink_sptr self) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(rep_msg_sink_sptr self, int priority) -> int"""
        return _zeromq_swig.rep_msg_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(rep_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_msg_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(rep_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_msg_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(rep_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.rep_msg_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(rep_msg_sink_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.rep_msg_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(rep_msg_sink_sptr self) -> long"""
        return _zeromq_swig.rep_msg_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(rep_msg_sink_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.rep_msg_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(rep_msg_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.rep_msg_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(rep_msg_sink_sptr self) -> std::string"""
        return _zeromq_swig.rep_msg_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(rep_msg_sink_sptr self, std::string name)"""
        return _zeromq_swig.rep_msg_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(rep_msg_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.rep_msg_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(rep_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_msg_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(rep_msg_sink_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_msg_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(rep_msg_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.rep_msg_sink_sptr_message_subscribers(self, which_port)

# Register rep_msg_sink_sptr in _zeromq_swig:
_zeromq_swig.rep_msg_sink_sptr_swigregister(rep_msg_sink_sptr)

rep_msg_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
rep_msg_sink = rep_msg_sink.make;

class sub_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::sub_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(sub_source_sptr self) -> sub_source_sptr
        __init__(sub_source_sptr self, sub_source p) -> sub_source_sptr
        """
        _zeromq_swig.sub_source_sptr_swiginit(self, _zeromq_swig.new_sub_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::sub_source *":
        r"""__deref__(sub_source_sptr self) -> sub_source"""
        return _zeromq_swig.sub_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_sub_source_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::sub_source::sptr":
        r"""
        make(sub_source_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> sub_source_sptr
        Receive messages on ZMQ SUB socket and source stream.

        This block will connect to a ZMQ PUB socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::sub_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.sub_source_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(sub_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.sub_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(sub_source_sptr self) -> unsigned int"""
        return _zeromq_swig.sub_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(sub_source_sptr self, int which, int delay)
        declare_sample_delay(sub_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.sub_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(sub_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.sub_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(sub_source_sptr self, int multiple)"""
        return _zeromq_swig.sub_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(sub_source_sptr self) -> int"""
        return _zeromq_swig.sub_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(sub_source_sptr self) -> double"""
        return _zeromq_swig.sub_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(sub_source_sptr self) -> uint64_t"""
        return _zeromq_swig.sub_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(sub_source_sptr self) -> uint64_t"""
        return _zeromq_swig.sub_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(sub_source_sptr self) -> bool"""
        return _zeromq_swig.sub_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(sub_source_sptr self) -> bool"""
        return _zeromq_swig.sub_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(sub_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.sub_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(sub_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.sub_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(sub_source_sptr self, std::string level)"""
        return _zeromq_swig.sub_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(sub_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(sub_source_sptr self) -> int"""
        return _zeromq_swig.sub_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(sub_source_sptr self, int m)"""
        return _zeromq_swig.sub_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(sub_source_sptr self)"""
        return _zeromq_swig.sub_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(sub_source_sptr self) -> bool"""
        return _zeromq_swig.sub_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(sub_source_sptr self, int m)"""
        return _zeromq_swig.sub_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(sub_source_sptr self) -> int"""
        return _zeromq_swig.sub_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(sub_source_sptr self, int i) -> long"""
        return _zeromq_swig.sub_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(sub_source_sptr self, long max_output_buffer)
        set_max_output_buffer(sub_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.sub_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(sub_source_sptr self, int i) -> long"""
        return _zeromq_swig.sub_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(sub_source_sptr self, long min_output_buffer)
        set_min_output_buffer(sub_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.sub_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(sub_source_sptr self, int which) -> float
        pc_input_buffers_full(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(sub_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(sub_source_sptr self, int which) -> float
        pc_input_buffers_full_var(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(sub_source_sptr self, int which) -> float
        pc_output_buffers_full(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(sub_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(sub_source_sptr self, int which) -> float
        pc_output_buffers_full_var(sub_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(sub_source_sptr self) -> float"""
        return _zeromq_swig.sub_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(sub_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.sub_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(sub_source_sptr self)"""
        return _zeromq_swig.sub_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(sub_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.sub_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(sub_source_sptr self) -> int"""
        return _zeromq_swig.sub_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(sub_source_sptr self) -> int"""
        return _zeromq_swig.sub_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(sub_source_sptr self, int priority) -> int"""
        return _zeromq_swig.sub_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(sub_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(sub_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(sub_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.sub_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(sub_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.sub_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(sub_source_sptr self) -> long"""
        return _zeromq_swig.sub_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(sub_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.sub_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(sub_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.sub_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(sub_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(sub_source_sptr self, std::string name)"""
        return _zeromq_swig.sub_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(sub_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.sub_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(sub_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(sub_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(sub_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_source_sptr_message_subscribers(self, which_port)

# Register sub_source_sptr in _zeromq_swig:
_zeromq_swig.sub_source_sptr_swigregister(sub_source_sptr)

sub_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
sub_source = sub_source.make;

class sub_msg_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::sub_msg_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(sub_msg_source_sptr self) -> sub_msg_source_sptr
        __init__(sub_msg_source_sptr self, sub_msg_source p) -> sub_msg_source_sptr
        """
        _zeromq_swig.sub_msg_source_sptr_swiginit(self, _zeromq_swig.new_sub_msg_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::sub_msg_source *":
        r"""__deref__(sub_msg_source_sptr self) -> sub_msg_source"""
        return _zeromq_swig.sub_msg_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_sub_msg_source_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::sub_msg_source::sptr":
        r"""
        make(sub_msg_source_sptr self, char * address, int timeout=100, bool bind=False) -> sub_msg_source_sptr
        Receive messages on ZMQ SUB socket and output async messages.

        This block will connect to a ZMQ PUB socket, then convert them to outgoing async messages

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::sub_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.sub_msg_source_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(sub_msg_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.sub_msg_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(sub_msg_source_sptr self) -> unsigned int"""
        return _zeromq_swig.sub_msg_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(sub_msg_source_sptr self, int which, int delay)
        declare_sample_delay(sub_msg_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.sub_msg_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(sub_msg_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.sub_msg_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(sub_msg_source_sptr self, int multiple)"""
        return _zeromq_swig.sub_msg_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(sub_msg_source_sptr self) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(sub_msg_source_sptr self) -> double"""
        return _zeromq_swig.sub_msg_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(sub_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.sub_msg_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(sub_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.sub_msg_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(sub_msg_source_sptr self) -> bool"""
        return _zeromq_swig.sub_msg_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(sub_msg_source_sptr self) -> bool"""
        return _zeromq_swig.sub_msg_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(sub_msg_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.sub_msg_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(sub_msg_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.sub_msg_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(sub_msg_source_sptr self, std::string level)"""
        return _zeromq_swig.sub_msg_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(sub_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_msg_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(sub_msg_source_sptr self) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(sub_msg_source_sptr self, int m)"""
        return _zeromq_swig.sub_msg_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(sub_msg_source_sptr self)"""
        return _zeromq_swig.sub_msg_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(sub_msg_source_sptr self) -> bool"""
        return _zeromq_swig.sub_msg_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(sub_msg_source_sptr self, int m)"""
        return _zeromq_swig.sub_msg_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(sub_msg_source_sptr self) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(sub_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.sub_msg_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(sub_msg_source_sptr self, long max_output_buffer)
        set_max_output_buffer(sub_msg_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.sub_msg_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(sub_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.sub_msg_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(sub_msg_source_sptr self, long min_output_buffer)
        set_min_output_buffer(sub_msg_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.sub_msg_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(sub_msg_source_sptr self, int which) -> float
        pc_input_buffers_full(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(sub_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(sub_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_var(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(sub_msg_source_sptr self, int which) -> float
        pc_output_buffers_full(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(sub_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(sub_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_var(sub_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.sub_msg_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(sub_msg_source_sptr self) -> float"""
        return _zeromq_swig.sub_msg_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(sub_msg_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.sub_msg_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(sub_msg_source_sptr self)"""
        return _zeromq_swig.sub_msg_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(sub_msg_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.sub_msg_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(sub_msg_source_sptr self) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(sub_msg_source_sptr self) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(sub_msg_source_sptr self, int priority) -> int"""
        return _zeromq_swig.sub_msg_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(sub_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_msg_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(sub_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_msg_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(sub_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.sub_msg_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(sub_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.sub_msg_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(sub_msg_source_sptr self) -> long"""
        return _zeromq_swig.sub_msg_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(sub_msg_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.sub_msg_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(sub_msg_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.sub_msg_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(sub_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.sub_msg_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(sub_msg_source_sptr self, std::string name)"""
        return _zeromq_swig.sub_msg_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(sub_msg_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.sub_msg_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(sub_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_msg_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(sub_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_msg_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(sub_msg_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.sub_msg_source_sptr_message_subscribers(self, which_port)

# Register sub_msg_source_sptr in _zeromq_swig:
_zeromq_swig.sub_msg_source_sptr_swigregister(sub_msg_source_sptr)

sub_msg_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
sub_msg_source = sub_msg_source.make;

class pull_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::pull_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pull_source_sptr self) -> pull_source_sptr
        __init__(pull_source_sptr self, pull_source p) -> pull_source_sptr
        """
        _zeromq_swig.pull_source_sptr_swiginit(self, _zeromq_swig.new_pull_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::pull_source *":
        r"""__deref__(pull_source_sptr self) -> pull_source"""
        return _zeromq_swig.pull_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_pull_source_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::pull_source::sptr":
        r"""
        make(pull_source_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> pull_source_sptr
        Receive messages on ZMQ PULL socket and source stream.

        This block will connect to a ZMQ PUSH socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::pull_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.pull_source_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pull_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pull_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(pull_source_sptr self) -> unsigned int"""
        return _zeromq_swig.pull_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pull_source_sptr self, int which, int delay)
        declare_sample_delay(pull_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.pull_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pull_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.pull_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pull_source_sptr self, int multiple)"""
        return _zeromq_swig.pull_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pull_source_sptr self) -> int"""
        return _zeromq_swig.pull_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pull_source_sptr self) -> double"""
        return _zeromq_swig.pull_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pull_source_sptr self) -> uint64_t"""
        return _zeromq_swig.pull_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pull_source_sptr self) -> uint64_t"""
        return _zeromq_swig.pull_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pull_source_sptr self) -> bool"""
        return _zeromq_swig.pull_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pull_source_sptr self) -> bool"""
        return _zeromq_swig.pull_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pull_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.pull_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pull_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.pull_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pull_source_sptr self, std::string level)"""
        return _zeromq_swig.pull_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pull_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pull_source_sptr self) -> int"""
        return _zeromq_swig.pull_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pull_source_sptr self, int m)"""
        return _zeromq_swig.pull_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pull_source_sptr self)"""
        return _zeromq_swig.pull_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pull_source_sptr self) -> bool"""
        return _zeromq_swig.pull_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pull_source_sptr self, int m)"""
        return _zeromq_swig.pull_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pull_source_sptr self) -> int"""
        return _zeromq_swig.pull_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pull_source_sptr self, int i) -> long"""
        return _zeromq_swig.pull_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pull_source_sptr self, long max_output_buffer)
        set_max_output_buffer(pull_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.pull_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pull_source_sptr self, int i) -> long"""
        return _zeromq_swig.pull_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pull_source_sptr self, long min_output_buffer)
        set_min_output_buffer(pull_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.pull_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pull_source_sptr self, int which) -> float
        pc_input_buffers_full(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pull_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pull_source_sptr self, int which) -> float
        pc_input_buffers_full_var(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pull_source_sptr self, int which) -> float
        pc_output_buffers_full(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pull_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pull_source_sptr self, int which) -> float
        pc_output_buffers_full_var(pull_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pull_source_sptr self) -> float"""
        return _zeromq_swig.pull_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pull_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.pull_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pull_source_sptr self)"""
        return _zeromq_swig.pull_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pull_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.pull_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pull_source_sptr self) -> int"""
        return _zeromq_swig.pull_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pull_source_sptr self) -> int"""
        return _zeromq_swig.pull_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pull_source_sptr self, int priority) -> int"""
        return _zeromq_swig.pull_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pull_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pull_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pull_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pull_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pull_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pull_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pull_source_sptr self) -> long"""
        return _zeromq_swig.pull_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pull_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.pull_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pull_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.pull_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pull_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pull_source_sptr self, std::string name)"""
        return _zeromq_swig.pull_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pull_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.pull_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pull_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pull_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pull_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_source_sptr_message_subscribers(self, which_port)

# Register pull_source_sptr in _zeromq_swig:
_zeromq_swig.pull_source_sptr_swigregister(pull_source_sptr)

pull_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pull_source = pull_source.make;

class pull_msg_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::pull_msg_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pull_msg_source_sptr self) -> pull_msg_source_sptr
        __init__(pull_msg_source_sptr self, pull_msg_source p) -> pull_msg_source_sptr
        """
        _zeromq_swig.pull_msg_source_sptr_swiginit(self, _zeromq_swig.new_pull_msg_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::pull_msg_source *":
        r"""__deref__(pull_msg_source_sptr self) -> pull_msg_source"""
        return _zeromq_swig.pull_msg_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_pull_msg_source_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::pull_msg_source::sptr":
        r"""
        make(pull_msg_source_sptr self, char * address, int timeout=100, bool bind=False) -> pull_msg_source_sptr
        Receive messages on ZMQ PULL socket and output async messages.

        This block will connect to a ZMQ PUSH socket, then convert received messages to outgoing async messages.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of gr::zeromq::pull_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.pull_msg_source_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(pull_msg_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.pull_msg_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(pull_msg_source_sptr self) -> unsigned int"""
        return _zeromq_swig.pull_msg_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pull_msg_source_sptr self, int which, int delay)
        declare_sample_delay(pull_msg_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.pull_msg_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pull_msg_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.pull_msg_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pull_msg_source_sptr self, int multiple)"""
        return _zeromq_swig.pull_msg_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pull_msg_source_sptr self) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pull_msg_source_sptr self) -> double"""
        return _zeromq_swig.pull_msg_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pull_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.pull_msg_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pull_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.pull_msg_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pull_msg_source_sptr self) -> bool"""
        return _zeromq_swig.pull_msg_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pull_msg_source_sptr self) -> bool"""
        return _zeromq_swig.pull_msg_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pull_msg_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.pull_msg_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pull_msg_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.pull_msg_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pull_msg_source_sptr self, std::string level)"""
        return _zeromq_swig.pull_msg_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pull_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_msg_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pull_msg_source_sptr self) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pull_msg_source_sptr self, int m)"""
        return _zeromq_swig.pull_msg_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pull_msg_source_sptr self)"""
        return _zeromq_swig.pull_msg_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pull_msg_source_sptr self) -> bool"""
        return _zeromq_swig.pull_msg_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pull_msg_source_sptr self, int m)"""
        return _zeromq_swig.pull_msg_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pull_msg_source_sptr self) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pull_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.pull_msg_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pull_msg_source_sptr self, long max_output_buffer)
        set_max_output_buffer(pull_msg_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.pull_msg_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pull_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.pull_msg_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pull_msg_source_sptr self, long min_output_buffer)
        set_min_output_buffer(pull_msg_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.pull_msg_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pull_msg_source_sptr self, int which) -> float
        pc_input_buffers_full(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pull_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pull_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_var(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pull_msg_source_sptr self, int which) -> float
        pc_output_buffers_full(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pull_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pull_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_var(pull_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.pull_msg_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pull_msg_source_sptr self) -> float"""
        return _zeromq_swig.pull_msg_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pull_msg_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.pull_msg_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pull_msg_source_sptr self)"""
        return _zeromq_swig.pull_msg_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pull_msg_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.pull_msg_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pull_msg_source_sptr self) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pull_msg_source_sptr self) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pull_msg_source_sptr self, int priority) -> int"""
        return _zeromq_swig.pull_msg_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pull_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_msg_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pull_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_msg_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pull_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pull_msg_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pull_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.pull_msg_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pull_msg_source_sptr self) -> long"""
        return _zeromq_swig.pull_msg_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pull_msg_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.pull_msg_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pull_msg_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.pull_msg_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pull_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.pull_msg_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pull_msg_source_sptr self, std::string name)"""
        return _zeromq_swig.pull_msg_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pull_msg_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.pull_msg_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pull_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_msg_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pull_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_msg_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pull_msg_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.pull_msg_source_sptr_message_subscribers(self, which_port)

# Register pull_msg_source_sptr in _zeromq_swig:
_zeromq_swig.pull_msg_source_sptr_swigregister(pull_msg_source_sptr)

pull_msg_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pull_msg_source = pull_msg_source.make;

class req_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::req_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(req_source_sptr self) -> req_source_sptr
        __init__(req_source_sptr self, req_source p) -> req_source_sptr
        """
        _zeromq_swig.req_source_sptr_swiginit(self, _zeromq_swig.new_req_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::req_source *":
        r"""__deref__(req_source_sptr self) -> req_source"""
        return _zeromq_swig.req_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_req_source_sptr

    def make(self, itemsize: "size_t", vlen: "size_t", address: "char *", timeout: "int"=100, pass_tags: "bool"=False, hwm: "int"=-1) -> "gr::zeromq::req_source::sptr":
        r"""
        make(req_source_sptr self, size_t itemsize, size_t vlen, char * address, int timeout=100, bool pass_tags=False, int hwm=-1) -> req_source_sptr
        Receive messages on ZMQ REQ socket and source stream.

        This block will connect to a ZMQ REP socket, then produce all incoming messages as streaming output.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::req_source.

        Args:
            itemsize : Size of a stream item in bytes.
            vlen : Vector length of the input items. Note that one vector is one item.
            address : ZMQ socket address specifier.
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
            pass_tags : Whether source will look for and deserialize tags.
            hwm : High Watermark to configure the socket to (-1 => zmq's default)
        """
        return _zeromq_swig.req_source_sptr_make(self, itemsize, vlen, address, timeout, pass_tags, hwm)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(req_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.req_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(req_source_sptr self) -> unsigned int"""
        return _zeromq_swig.req_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(req_source_sptr self, int which, int delay)
        declare_sample_delay(req_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.req_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(req_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.req_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(req_source_sptr self, int multiple)"""
        return _zeromq_swig.req_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(req_source_sptr self) -> int"""
        return _zeromq_swig.req_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(req_source_sptr self) -> double"""
        return _zeromq_swig.req_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(req_source_sptr self) -> uint64_t"""
        return _zeromq_swig.req_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(req_source_sptr self) -> uint64_t"""
        return _zeromq_swig.req_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(req_source_sptr self) -> bool"""
        return _zeromq_swig.req_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(req_source_sptr self) -> bool"""
        return _zeromq_swig.req_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(req_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.req_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(req_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.req_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(req_source_sptr self, std::string level)"""
        return _zeromq_swig.req_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(req_source_sptr self) -> std::string"""
        return _zeromq_swig.req_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(req_source_sptr self) -> int"""
        return _zeromq_swig.req_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(req_source_sptr self, int m)"""
        return _zeromq_swig.req_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(req_source_sptr self)"""
        return _zeromq_swig.req_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(req_source_sptr self) -> bool"""
        return _zeromq_swig.req_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(req_source_sptr self, int m)"""
        return _zeromq_swig.req_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(req_source_sptr self) -> int"""
        return _zeromq_swig.req_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(req_source_sptr self, int i) -> long"""
        return _zeromq_swig.req_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(req_source_sptr self, long max_output_buffer)
        set_max_output_buffer(req_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.req_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(req_source_sptr self, int i) -> long"""
        return _zeromq_swig.req_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(req_source_sptr self, long min_output_buffer)
        set_min_output_buffer(req_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.req_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(req_source_sptr self, int which) -> float
        pc_input_buffers_full(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(req_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(req_source_sptr self, int which) -> float
        pc_input_buffers_full_var(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(req_source_sptr self, int which) -> float
        pc_output_buffers_full(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(req_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(req_source_sptr self, int which) -> float
        pc_output_buffers_full_var(req_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(req_source_sptr self) -> float"""
        return _zeromq_swig.req_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(req_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.req_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(req_source_sptr self)"""
        return _zeromq_swig.req_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(req_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.req_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(req_source_sptr self) -> int"""
        return _zeromq_swig.req_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(req_source_sptr self) -> int"""
        return _zeromq_swig.req_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(req_source_sptr self, int priority) -> int"""
        return _zeromq_swig.req_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(req_source_sptr self) -> std::string"""
        return _zeromq_swig.req_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(req_source_sptr self) -> std::string"""
        return _zeromq_swig.req_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(req_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.req_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(req_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.req_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(req_source_sptr self) -> long"""
        return _zeromq_swig.req_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(req_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.req_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(req_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.req_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(req_source_sptr self) -> std::string"""
        return _zeromq_swig.req_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(req_source_sptr self, std::string name)"""
        return _zeromq_swig.req_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(req_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.req_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(req_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.req_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(req_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.req_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(req_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.req_source_sptr_message_subscribers(self, which_port)

# Register req_source_sptr in _zeromq_swig:
_zeromq_swig.req_source_sptr_swigregister(req_source_sptr)

req_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
req_source = req_source.make;

class req_msg_source_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::zeromq::req_msg_source > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(req_msg_source_sptr self) -> req_msg_source_sptr
        __init__(req_msg_source_sptr self, req_msg_source p) -> req_msg_source_sptr
        """
        _zeromq_swig.req_msg_source_sptr_swiginit(self, _zeromq_swig.new_req_msg_source_sptr(*args))

    def __deref__(self) -> "gr::zeromq::req_msg_source *":
        r"""__deref__(req_msg_source_sptr self) -> req_msg_source"""
        return _zeromq_swig.req_msg_source_sptr___deref__(self)
    __swig_destroy__ = _zeromq_swig.delete_req_msg_source_sptr

    def make(self, address: "char *", timeout: "int"=100, bind: "bool"=False) -> "gr::zeromq::req_msg_source::sptr":
        r"""
        make(req_msg_source_sptr self, char * address, int timeout=100, bool bind=False) -> req_msg_source_sptr
        Receive messages on ZMQ REQ socket output async messages.

        This block will connect to a ZMQ REP socket, then resend all incoming messages as asynchronous messages.

        Constructor Specific Documentation:

        Return a shared_ptr to a new instance of zeromq::req_msg_source.

        Args:
            address : ZMQ socket address specifier
            timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
            bind : If true this block will bind to the address, otherwise it will connect; the default is to connect
        """
        return _zeromq_swig.req_msg_source_sptr_make(self, address, timeout, bind)

    def last_endpoint(self) -> "std::string":
        r"""
        last_endpoint(req_msg_source_sptr self) -> std::string
        Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.
        """
        return _zeromq_swig.req_msg_source_sptr_last_endpoint(self)

    def history(self) -> "unsigned int":
        r"""history(req_msg_source_sptr self) -> unsigned int"""
        return _zeromq_swig.req_msg_source_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(req_msg_source_sptr self, int which, int delay)
        declare_sample_delay(req_msg_source_sptr self, unsigned int delay)
        """
        return _zeromq_swig.req_msg_source_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(req_msg_source_sptr self, int which) -> unsigned int"""
        return _zeromq_swig.req_msg_source_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(req_msg_source_sptr self, int multiple)"""
        return _zeromq_swig.req_msg_source_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(req_msg_source_sptr self) -> int"""
        return _zeromq_swig.req_msg_source_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(req_msg_source_sptr self) -> double"""
        return _zeromq_swig.req_msg_source_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(req_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.req_msg_source_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(req_msg_source_sptr self) -> uint64_t"""
        return _zeromq_swig.req_msg_source_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(req_msg_source_sptr self) -> bool"""
        return _zeromq_swig.req_msg_source_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(req_msg_source_sptr self) -> bool"""
        return _zeromq_swig.req_msg_source_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(req_msg_source_sptr self, unsigned int which_input) -> uint64_t"""
        return _zeromq_swig.req_msg_source_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(req_msg_source_sptr self, unsigned int which_output) -> uint64_t"""
        return _zeromq_swig.req_msg_source_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(req_msg_source_sptr self, std::string level)"""
        return _zeromq_swig.req_msg_source_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(req_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.req_msg_source_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(req_msg_source_sptr self) -> int"""
        return _zeromq_swig.req_msg_source_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(req_msg_source_sptr self, int m)"""
        return _zeromq_swig.req_msg_source_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(req_msg_source_sptr self)"""
        return _zeromq_swig.req_msg_source_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(req_msg_source_sptr self) -> bool"""
        return _zeromq_swig.req_msg_source_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(req_msg_source_sptr self, int m)"""
        return _zeromq_swig.req_msg_source_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(req_msg_source_sptr self) -> int"""
        return _zeromq_swig.req_msg_source_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(req_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.req_msg_source_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(req_msg_source_sptr self, long max_output_buffer)
        set_max_output_buffer(req_msg_source_sptr self, int port, long max_output_buffer)
        """
        return _zeromq_swig.req_msg_source_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(req_msg_source_sptr self, int i) -> long"""
        return _zeromq_swig.req_msg_source_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(req_msg_source_sptr self, long min_output_buffer)
        set_min_output_buffer(req_msg_source_sptr self, int port, long min_output_buffer)
        """
        return _zeromq_swig.req_msg_source_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(req_msg_source_sptr self, int which) -> float
        pc_input_buffers_full(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(req_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_avg(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(req_msg_source_sptr self, int which) -> float
        pc_input_buffers_full_var(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(req_msg_source_sptr self, int which) -> float
        pc_output_buffers_full(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(req_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_avg(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(req_msg_source_sptr self, int which) -> float
        pc_output_buffers_full_var(req_msg_source_sptr self) -> pmt_vector_float
        """
        return _zeromq_swig.req_msg_source_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(req_msg_source_sptr self) -> float"""
        return _zeromq_swig.req_msg_source_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(req_msg_source_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _zeromq_swig.req_msg_source_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(req_msg_source_sptr self)"""
        return _zeromq_swig.req_msg_source_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(req_msg_source_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _zeromq_swig.req_msg_source_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(req_msg_source_sptr self) -> int"""
        return _zeromq_swig.req_msg_source_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(req_msg_source_sptr self) -> int"""
        return _zeromq_swig.req_msg_source_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(req_msg_source_sptr self, int priority) -> int"""
        return _zeromq_swig.req_msg_source_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(req_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.req_msg_source_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(req_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.req_msg_source_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(req_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.req_msg_source_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(req_msg_source_sptr self) -> io_signature_sptr"""
        return _zeromq_swig.req_msg_source_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(req_msg_source_sptr self) -> long"""
        return _zeromq_swig.req_msg_source_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(req_msg_source_sptr self) -> basic_block_sptr"""
        return _zeromq_swig.req_msg_source_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(req_msg_source_sptr self, int ninputs, int noutputs) -> bool"""
        return _zeromq_swig.req_msg_source_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(req_msg_source_sptr self) -> std::string"""
        return _zeromq_swig.req_msg_source_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(req_msg_source_sptr self, std::string name)"""
        return _zeromq_swig.req_msg_source_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(req_msg_source_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _zeromq_swig.req_msg_source_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(req_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.req_msg_source_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(req_msg_source_sptr self) -> swig_pmt_ptr"""
        return _zeromq_swig.req_msg_source_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(req_msg_source_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _zeromq_swig.req_msg_source_sptr_message_subscribers(self, which_port)

# Register req_msg_source_sptr in _zeromq_swig:
_zeromq_swig.req_msg_source_sptr_swigregister(req_msg_source_sptr)

req_msg_source_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
req_msg_source = req_msg_source.make;


