# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _filter_swig
else:
    import _filter_swig

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def high_res_timer_now() -> "gr::high_res_timer_type":
    r"""high_res_timer_now() -> gr::high_res_timer_type"""
    return _filter_swig.high_res_timer_now()

def high_res_timer_now_perfmon() -> "gr::high_res_timer_type":
    r"""high_res_timer_now_perfmon() -> gr::high_res_timer_type"""
    return _filter_swig.high_res_timer_now_perfmon()

def high_res_timer_tps() -> "gr::high_res_timer_type":
    r"""high_res_timer_tps() -> gr::high_res_timer_type"""
    return _filter_swig.high_res_timer_tps()

def high_res_timer_epoch() -> "gr::high_res_timer_type":
    r"""high_res_timer_epoch() -> gr::high_res_timer_type"""
    return _filter_swig.high_res_timer_epoch()
class firdes(object):
    r"""Finite Impulse Response (FIR) filter design functions."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    WIN_NONE = _filter_swig.firdes_WIN_NONE
    
    WIN_HAMMING = _filter_swig.firdes_WIN_HAMMING
    
    WIN_HANN = _filter_swig.firdes_WIN_HANN
    
    WIN_BLACKMAN = _filter_swig.firdes_WIN_BLACKMAN
    
    WIN_RECTANGULAR = _filter_swig.firdes_WIN_RECTANGULAR
    
    WIN_KAISER = _filter_swig.firdes_WIN_KAISER
    
    WIN_BLACKMAN_hARRIS = _filter_swig.firdes_WIN_BLACKMAN_hARRIS
    
    WIN_BLACKMAN_HARRIS = _filter_swig.firdes_WIN_BLACKMAN_HARRIS
    
    WIN_BARTLETT = _filter_swig.firdes_WIN_BARTLETT
    
    WIN_FLATTOP = _filter_swig.firdes_WIN_FLATTOP
    

    @staticmethod
    def window(type: "gr::filter::firdes::win_type", ntaps: "int", beta: "double") -> "std::vector< float,std::allocator< float > >":
        r"""window(gr::filter::firdes::win_type type, int ntaps, double beta) -> pmt_vector_float"""
        return _filter_swig.firdes_window(type, ntaps, beta)

    @staticmethod
    def low_pass(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        low_pass(double gain, double sampling_freq, double cutoff_freq, double transition_width, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a low-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. Window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_low_pass(*args, **kwargs)

    @staticmethod
    def low_pass_2(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        low_pass_2(double gain, double sampling_freq, double cutoff_freq, double transition_width, double attenuation_dB, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a low-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. The window type determines maximum attentuation and passband ripple.
        """
        return _filter_swig.firdes_low_pass_2(*args, **kwargs)

    @staticmethod
    def high_pass(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        high_pass(double gain, double sampling_freq, double cutoff_freq, double transition_width, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a high-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_high_pass(*args, **kwargs)

    @staticmethod
    def high_pass_2(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        high_pass_2(double gain, double sampling_freq, double cutoff_freq, double transition_width, double attenuation_dB, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a high-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. The window determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_high_pass_2(*args, **kwargs)

    @staticmethod
    def band_pass(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        band_pass(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a band-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_band_pass(*args, **kwargs)

    @staticmethod
    def band_pass_2(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        band_pass_2(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, double attenuation_dB, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a band-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps. More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_band_pass_2(*args, **kwargs)

    @staticmethod
    def complex_band_pass(*args, **kwargs) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        complex_band_pass(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_cfloat
        Use the "window method" to design a complex band-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_complex_band_pass(*args, **kwargs)

    @staticmethod
    def complex_band_pass_2(*args, **kwargs) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        complex_band_pass_2(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, double attenuation_dB, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_cfloat
        Use "window method" to design a complex band-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_complex_band_pass_2(*args, **kwargs)

    @staticmethod
    def band_reject(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        band_reject(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a band-reject FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. Window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_band_reject(*args, **kwargs)

    @staticmethod
    def band_reject_2(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        band_reject_2(double gain, double sampling_freq, double low_cutoff_freq, double high_cutoff_freq, double transition_width, double attenuation_dB, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> pmt_vector_float
        Use "window method" to design a band-reject FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.
        """
        return _filter_swig.firdes_band_reject_2(*args, **kwargs)

    @staticmethod
    def hilbert(*args, **kwargs) -> "std::vector< float,std::allocator< float > >":
        r"""
        hilbert(unsigned int ntaps=19, gr::filter::firdes::win_type windowtype=WIN_RECTANGULAR, double beta=6.76) -> pmt_vector_float
        design a Hilbert Transform Filter
        """
        return _filter_swig.firdes_hilbert(*args, **kwargs)

    @staticmethod
    def root_raised_cosine(gain: "double", sampling_freq: "double", symbol_rate: "double", alpha: "double", ntaps: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        root_raised_cosine(double gain, double sampling_freq, double symbol_rate, double alpha, int ntaps) -> pmt_vector_float
        design a Root Cosine FIR Filter (do we need a window?)
        """
        return _filter_swig.firdes_root_raised_cosine(gain, sampling_freq, symbol_rate, alpha, ntaps)

    @staticmethod
    def gaussian(gain: "double", spb: "double", bt: "double", ntaps: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        gaussian(double gain, double spb, double bt, int ntaps) -> pmt_vector_float
        design a Gaussian filter
        """
        return _filter_swig.firdes_gaussian(gain, spb, bt, ntaps)

    def __init__(self):
        r"""__init__(firdes self) -> firdes"""
        _filter_swig.firdes_swiginit(self, _filter_swig.new_firdes())
    __swig_destroy__ = _filter_swig.delete_firdes

# Register firdes in _filter_swig:
_filter_swig.firdes_swigregister(firdes)

def pm_remez(*args, **kwargs) -> "std::vector< double,std::allocator< double > >":
    r"""
    pm_remez(int order, pmt_vector_double bands, pmt_vector_double ampl, pmt_vector_double error_weight, std::string const filter_type="bandpass", int grid_density=16) -> pmt_vector_double
    Parks-McClellan FIR filter design using Remez algorithm.

    Calculates the optimal (in the Chebyshev/minimax sense) FIR filter inpulse response given a set of band edges, the desired response on those bands, and the weight given to the error in those bands.



    Frequency is in the range [0, 1], with 1 being the Nyquist frequency (Fs/2)
    """
    return _filter_swig.pm_remez(*args, **kwargs)
class dc_blocker_cc(object):
    r"""
    a computationally efficient controllable DC blocker

    This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


    The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


    The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


    The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


    The theory behind this block can be found in the paper:

    Constructor Specific Documentation:

    Make a DC blocker block.

    Args:
        D : (int) the length of the delay line
        long_form : (bool) whether to use long (true, default) or short form
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(D: "int", long_form: "bool") -> "gr::filter::dc_blocker_cc::sptr":
        r"""
        make(int D, bool long_form) -> dc_blocker_cc_sptr
        a computationally efficient controllable DC blocker

        This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


        The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


        The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


        The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


        The theory behind this block can be found in the paper:

        Constructor Specific Documentation:

        Make a DC blocker block.

        Args:
            D : (int) the length of the delay line
            long_form : (bool) whether to use long (true, default) or short form
        """
        return _filter_swig.dc_blocker_cc_make(D, long_form)

    def group_delay(self) -> "int":
        r"""group_delay(dc_blocker_cc self) -> int"""
        return _filter_swig.dc_blocker_cc_group_delay(self)
    __swig_destroy__ = _filter_swig.delete_dc_blocker_cc

# Register dc_blocker_cc in _filter_swig:
_filter_swig.dc_blocker_cc_swigregister(dc_blocker_cc)
class dc_blocker_ff(object):
    r"""
    a computationally efficient controllable DC blocker

    This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


    The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


    The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


    The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


    The theory behind this block can be found in the paper:

    Constructor Specific Documentation:

    Make a DC blocker block.

    Args:
        D : (int) the length of the delay line
        long_form : (bool) whether to use long (true, default) or short form
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(D: "int", long_form: "bool"=True) -> "gr::filter::dc_blocker_ff::sptr":
        r"""
        make(int D, bool long_form=True) -> dc_blocker_ff_sptr
        a computationally efficient controllable DC blocker

        This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


        The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


        The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


        The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


        The theory behind this block can be found in the paper:

        Constructor Specific Documentation:

        Make a DC blocker block.

        Args:
            D : (int) the length of the delay line
            long_form : (bool) whether to use long (true, default) or short form
        """
        return _filter_swig.dc_blocker_ff_make(D, long_form)

    def group_delay(self) -> "int":
        r"""group_delay(dc_blocker_ff self) -> int"""
        return _filter_swig.dc_blocker_ff_group_delay(self)
    __swig_destroy__ = _filter_swig.delete_dc_blocker_ff

# Register dc_blocker_ff in _filter_swig:
_filter_swig.dc_blocker_ff_swigregister(dc_blocker_ff)
class filter_delay_fc(object):
    r"""
    Filter-Delay Combination Block.

    The block takes one or two float stream and outputs a complex stream.


    If only one float stream is input, the real output is a delayed version of this input and the imaginary output is the filtered output.


    If two floats are connected to the input, then the real output is the delayed version of the first input, and the imaginary output is the filtered output.


    The delay in the real path accounts for the group delay introduced by the filter in the imaginary path. The filter taps needs to be calculated before initializing this block.

    Constructor Specific Documentation:

    Build a filter with delay block.

    Args:
        taps : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(taps: "pmt_vector_float") -> "gr::filter::filter_delay_fc::sptr":
        r"""
        make(pmt_vector_float taps) -> filter_delay_fc_sptr
        Filter-Delay Combination Block.

        The block takes one or two float stream and outputs a complex stream.


        If only one float stream is input, the real output is a delayed version of this input and the imaginary output is the filtered output.


        If two floats are connected to the input, then the real output is the delayed version of the first input, and the imaginary output is the filtered output.


        The delay in the real path accounts for the group delay introduced by the filter in the imaginary path. The filter taps needs to be calculated before initializing this block.

        Constructor Specific Documentation:

        Build a filter with delay block.

        Args:
            taps : 
        """
        return _filter_swig.filter_delay_fc_make(taps)
    __swig_destroy__ = _filter_swig.delete_filter_delay_fc

# Register filter_delay_fc in _filter_swig:
_filter_swig.filter_delay_fc_swigregister(filter_delay_fc)
class filterbank_vcvcf(object):
    r"""
    Filterbank with vector of gr_complex input, vector of gr_complex output and float taps.

    This block takes in complex vectors and outputs complex vectors of the same size. Vectors of length N, rather than N normal streams are used to reduce overhead.

    Constructor Specific Documentation:

    Build the filterbank.

    Args:
        taps : (vector of vector of floats/list of list of floats) Used to populate the filters.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(taps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &") -> "gr::filter::filterbank_vcvcf::sptr":
        r"""
        make(std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & taps) -> filterbank_vcvcf_sptr
        Filterbank with vector of gr_complex input, vector of gr_complex output and float taps.

        This block takes in complex vectors and outputs complex vectors of the same size. Vectors of length N, rather than N normal streams are used to reduce overhead.

        Constructor Specific Documentation:

        Build the filterbank.

        Args:
            taps : (vector of vector of floats/list of list of floats) Used to populate the filters.
        """
        return _filter_swig.filterbank_vcvcf_make(taps)

    def set_taps(self, taps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &") -> "void":
        r"""
        set_taps(filterbank_vcvcf self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.filterbank_vcvcf_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(filterbank_vcvcf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.filterbank_vcvcf_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(filterbank_vcvcf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.filterbank_vcvcf_taps(self)
    __swig_destroy__ = _filter_swig.delete_filterbank_vcvcf

# Register filterbank_vcvcf in _filter_swig:
_filter_swig.filterbank_vcvcf_swigregister(filterbank_vcvcf)
class fft_filter_ccc(object):
    r"""
    Fast FFT filter with gr_complex input, gr_complex output and gr_complex taps.

    This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


    The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


    This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

    Constructor Specific Documentation:

    Build an FFT filter blocks.

    Args:
        decimation : >= 1
        taps : complex filter taps
        nthreads : number of threads for the FFT to use
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat", nthreads: "int"=1) -> "gr::filter::fft_filter_ccc::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps, int nthreads=1) -> fft_filter_ccc_sptr
        Fast FFT filter with gr_complex input, gr_complex output and gr_complex taps.

        This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter blocks.

        Args:
            decimation : >= 1
            taps : complex filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_ccc_make(decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fft_filter_ccc self, pmt_vector_cfloat taps)"""
        return _filter_swig.fft_filter_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(fft_filter_ccc self) -> pmt_vector_cfloat"""
        return _filter_swig.fft_filter_ccc_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_ccc self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_ccc_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_ccc self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_ccc_nthreads(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_ccc

# Register fft_filter_ccc in _filter_swig:
_filter_swig.fft_filter_ccc_swigregister(fft_filter_ccc)
class fft_filter_ccf(object):
    r"""
    Fast FFT filter with gr_complex input, gr_complex output and float taps.

    This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


    The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


    This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

    Constructor Specific Documentation:

    Build an FFT filter blocks.

    Args:
        decimation : >= 1
        taps : complex filter taps
        nthreads : number of threads for the FFT to use
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float", nthreads: "int"=1) -> "gr::filter::fft_filter_ccf::sptr":
        r"""
        make(int decimation, pmt_vector_float taps, int nthreads=1) -> fft_filter_ccf_sptr
        Fast FFT filter with gr_complex input, gr_complex output and float taps.

        This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter blocks.

        Args:
            decimation : >= 1
            taps : complex filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_ccf_make(decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fft_filter_ccf self, pmt_vector_float taps)"""
        return _filter_swig.fft_filter_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fft_filter_ccf self) -> pmt_vector_float"""
        return _filter_swig.fft_filter_ccf_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_ccf self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_ccf_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_ccf self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_ccf_nthreads(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_ccf

# Register fft_filter_ccf in _filter_swig:
_filter_swig.fft_filter_ccf_swigregister(fft_filter_ccf)
class fft_filter_fff(object):
    r"""
    Fast FFT filter with float input, float output and float taps.

    This block implements a real-value decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


    The filter takes a set of real-valued taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


    This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

    Constructor Specific Documentation:

    Build an FFT filter block.

    Args:
        decimation : >= 1
        taps : float filter taps
        nthreads : number of threads for the FFT to use
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float", nthreads: "int"=1) -> "gr::filter::fft_filter_fff::sptr":
        r"""
        make(int decimation, pmt_vector_float taps, int nthreads=1) -> fft_filter_fff_sptr
        Fast FFT filter with float input, float output and float taps.

        This block implements a real-value decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of real-valued taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter block.

        Args:
            decimation : >= 1
            taps : float filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_fff_make(decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fft_filter_fff self, pmt_vector_float taps)"""
        return _filter_swig.fft_filter_fff_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fft_filter_fff self) -> pmt_vector_float"""
        return _filter_swig.fft_filter_fff_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_fff self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_fff_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_fff self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_fff_nthreads(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_fff

# Register fft_filter_fff in _filter_swig:
_filter_swig.fft_filter_fff_swigregister(fft_filter_fff)
class mmse_interpolator_cc(object):
    r"""
    Interpolating MMSE filter with complex input, complex output.

    Constructor Specific Documentation:

    Build the interpolating MMSE filter (complex input, complex output)

    Args:
        phase_shift : The phase shift of the output signal to the input
        interp_ratio : The interpolation ratio = input_rate / output_rate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(phase_shift: "float", interp_ratio: "float") -> "gr::filter::mmse_interpolator_cc::sptr":
        r"""
        make(float phase_shift, float interp_ratio) -> mmse_interpolator_cc_sptr
        Interpolating MMSE filter with complex input, complex output.

        Constructor Specific Documentation:

        Build the interpolating MMSE filter (complex input, complex output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            interp_ratio : The interpolation ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_interpolator_cc_make(phase_shift, interp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_interpolator_cc self) -> float"""
        return _filter_swig.mmse_interpolator_cc_mu(self)

    def interp_ratio(self) -> "float":
        r"""interp_ratio(mmse_interpolator_cc self) -> float"""
        return _filter_swig.mmse_interpolator_cc_interp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_interpolator_cc self, float mu)"""
        return _filter_swig.mmse_interpolator_cc_set_mu(self, mu)

    def set_interp_ratio(self, interp_ratio: "float") -> "void":
        r"""set_interp_ratio(mmse_interpolator_cc self, float interp_ratio)"""
        return _filter_swig.mmse_interpolator_cc_set_interp_ratio(self, interp_ratio)
    __swig_destroy__ = _filter_swig.delete_mmse_interpolator_cc

# Register mmse_interpolator_cc in _filter_swig:
_filter_swig.mmse_interpolator_cc_swigregister(mmse_interpolator_cc)
class mmse_interpolator_ff(object):
    r"""
    Interpolating MMSE filter with float input, float output.

    Constructor Specific Documentation:

    Build the interpolating MMSE filter (float input, float output)

    Args:
        phase_shift : The phase shift of the output signal to the input
        interp_ratio : The interpolation ratio = input_rate / output_rate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(phase_shift: "float", interp_ratio: "float") -> "gr::filter::mmse_interpolator_ff::sptr":
        r"""
        make(float phase_shift, float interp_ratio) -> mmse_interpolator_ff_sptr
        Interpolating MMSE filter with float input, float output.

        Constructor Specific Documentation:

        Build the interpolating MMSE filter (float input, float output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            interp_ratio : The interpolation ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_interpolator_ff_make(phase_shift, interp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_interpolator_ff self) -> float"""
        return _filter_swig.mmse_interpolator_ff_mu(self)

    def interp_ratio(self) -> "float":
        r"""interp_ratio(mmse_interpolator_ff self) -> float"""
        return _filter_swig.mmse_interpolator_ff_interp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_interpolator_ff self, float mu)"""
        return _filter_swig.mmse_interpolator_ff_set_mu(self, mu)

    def set_interp_ratio(self, interp_ratio: "float") -> "void":
        r"""set_interp_ratio(mmse_interpolator_ff self, float interp_ratio)"""
        return _filter_swig.mmse_interpolator_ff_set_interp_ratio(self, interp_ratio)
    __swig_destroy__ = _filter_swig.delete_mmse_interpolator_ff

# Register mmse_interpolator_ff in _filter_swig:
_filter_swig.mmse_interpolator_ff_swigregister(mmse_interpolator_ff)
class mmse_resampler_cc(object):
    r"""
    resampling MMSE filter with complex input, complex output

    The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

    Constructor Specific Documentation:

    Build the resampling MMSE filter (complex input, complex output)

    Args:
        phase_shift : The phase shift of the output signal to the input
        resamp_ratio : The resampling ratio = input_rate / output_rate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(phase_shift: "float", resamp_ratio: "float") -> "gr::filter::mmse_resampler_cc::sptr":
        r"""
        make(float phase_shift, float resamp_ratio) -> mmse_resampler_cc_sptr
        resampling MMSE filter with complex input, complex output

        The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

        Constructor Specific Documentation:

        Build the resampling MMSE filter (complex input, complex output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            resamp_ratio : The resampling ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_resampler_cc_make(phase_shift, resamp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_resampler_cc self) -> float"""
        return _filter_swig.mmse_resampler_cc_mu(self)

    def resamp_ratio(self) -> "float":
        r"""resamp_ratio(mmse_resampler_cc self) -> float"""
        return _filter_swig.mmse_resampler_cc_resamp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_resampler_cc self, float mu)"""
        return _filter_swig.mmse_resampler_cc_set_mu(self, mu)

    def set_resamp_ratio(self, resamp_ratio: "float") -> "void":
        r"""set_resamp_ratio(mmse_resampler_cc self, float resamp_ratio)"""
        return _filter_swig.mmse_resampler_cc_set_resamp_ratio(self, resamp_ratio)
    __swig_destroy__ = _filter_swig.delete_mmse_resampler_cc

# Register mmse_resampler_cc in _filter_swig:
_filter_swig.mmse_resampler_cc_swigregister(mmse_resampler_cc)
class mmse_resampler_ff(object):
    r"""
    Resampling MMSE filter with float input, float output.

    The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

    Constructor Specific Documentation:

    Build the resampling MMSE filter (float input, float output)

    Args:
        phase_shift : The phase shift of the output signal to the input
        resamp_ratio : The resampling ratio = input_rate / output_rate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(phase_shift: "float", resamp_ratio: "float") -> "gr::filter::mmse_resampler_ff::sptr":
        r"""
        make(float phase_shift, float resamp_ratio) -> mmse_resampler_ff_sptr
        Resampling MMSE filter with float input, float output.

        The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

        Constructor Specific Documentation:

        Build the resampling MMSE filter (float input, float output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            resamp_ratio : The resampling ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_resampler_ff_make(phase_shift, resamp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_resampler_ff self) -> float"""
        return _filter_swig.mmse_resampler_ff_mu(self)

    def resamp_ratio(self) -> "float":
        r"""resamp_ratio(mmse_resampler_ff self) -> float"""
        return _filter_swig.mmse_resampler_ff_resamp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_resampler_ff self, float mu)"""
        return _filter_swig.mmse_resampler_ff_set_mu(self, mu)

    def set_resamp_ratio(self, resamp_ratio: "float") -> "void":
        r"""set_resamp_ratio(mmse_resampler_ff self, float resamp_ratio)"""
        return _filter_swig.mmse_resampler_ff_set_resamp_ratio(self, resamp_ratio)
    __swig_destroy__ = _filter_swig.delete_mmse_resampler_ff

# Register mmse_resampler_ff in _filter_swig:
_filter_swig.mmse_resampler_ff_swigregister(mmse_resampler_ff)
class hilbert_fc(object):
    r"""
    Hilbert transformer.

    real output is input appropriately delayed. imaginary output is hilbert filtered (90 degree phase shift) version of input.

    Constructor Specific Documentation:

    Build a Hilbert transformer filter block.

    Args:
        ntaps : The number of taps for the filter.
        window : Window type (see firdes::win_type) to use.
        beta : Beta value for a Kaiser window.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::filter::hilbert_fc::sptr":
        r"""
        make(unsigned int ntaps, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> hilbert_fc_sptr
        Hilbert transformer.

        real output is input appropriately delayed. imaginary output is hilbert filtered (90 degree phase shift) version of input.

        Constructor Specific Documentation:

        Build a Hilbert transformer filter block.

        Args:
            ntaps : The number of taps for the filter.
            window : Window type (see firdes::win_type) to use.
            beta : Beta value for a Kaiser window.
        """
        return _filter_swig.hilbert_fc_make(*args, **kwargs)
    __swig_destroy__ = _filter_swig.delete_hilbert_fc

# Register hilbert_fc in _filter_swig:
_filter_swig.hilbert_fc_swigregister(hilbert_fc)
class iir_filter_ffd(object):
    r"""
    IIR filter with float input, float output and double taps.

    This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


     The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


    The input and output satisfy a difference equation of the form   



    y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



    with the corresponding rational system function   



    H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

    Constructor Specific Documentation:



    Args:
        fftaps : 
        fbtaps : 
        oldstyle : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ffd::sptr":
        r"""
        make(pmt_vector_double fftaps, pmt_vector_double fbtaps, bool oldstyle=True) -> iir_filter_ffd_sptr
        IIR filter with float input, float output and double taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ffd_make(fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double") -> "void":
        r"""set_taps(iir_filter_ffd self, pmt_vector_double fftaps, pmt_vector_double fbtaps)"""
        return _filter_swig.iir_filter_ffd_set_taps(self, fftaps, fbtaps)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ffd

# Register iir_filter_ffd in _filter_swig:
_filter_swig.iir_filter_ffd_swigregister(iir_filter_ffd)
class iir_filter_ccc(object):
    r"""
    IIR filter with complex input, complex output, and complex taps.

    This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


     The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


    The input and output satisfy a difference equation of the form   



    y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



    with the corresponding rational system function   



    H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

    Constructor Specific Documentation:



    Args:
        fftaps : 
        fbtaps : 
        oldstyle : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fftaps: "pmt_vector_cfloat", fbtaps: "pmt_vector_cfloat", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccc::sptr":
        r"""
        make(pmt_vector_cfloat fftaps, pmt_vector_cfloat fbtaps, bool oldstyle=True) -> iir_filter_ccc_sptr
        IIR filter with complex input, complex output, and complex taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccc_make(fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_cfloat", fbtaps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(iir_filter_ccc self, pmt_vector_cfloat fftaps, pmt_vector_cfloat fbtaps)"""
        return _filter_swig.iir_filter_ccc_set_taps(self, fftaps, fbtaps)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccc

# Register iir_filter_ccc in _filter_swig:
_filter_swig.iir_filter_ccc_swigregister(iir_filter_ccc)
class iir_filter_ccf(object):
    r"""
    IIR filter with complex input, complex output, and float taps.

    This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


     The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


    The input and output satisfy a difference equation of the form   



    y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



    with the corresponding rational system function   



    H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

    Constructor Specific Documentation:



    Args:
        fftaps : 
        fbtaps : 
        oldstyle : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fftaps: "pmt_vector_float", fbtaps: "pmt_vector_float", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccf::sptr":
        r"""
        make(pmt_vector_float fftaps, pmt_vector_float fbtaps, bool oldstyle=True) -> iir_filter_ccf_sptr
        IIR filter with complex input, complex output, and float taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccf_make(fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_float", fbtaps: "pmt_vector_float") -> "void":
        r"""set_taps(iir_filter_ccf self, pmt_vector_float fftaps, pmt_vector_float fbtaps)"""
        return _filter_swig.iir_filter_ccf_set_taps(self, fftaps, fbtaps)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccf

# Register iir_filter_ccf in _filter_swig:
_filter_swig.iir_filter_ccf_swigregister(iir_filter_ccf)
class iir_filter_ccd(object):
    r"""
    IIR filter with complex input, complex output, and double taps.

    This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


     The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


    The input and output satisfy a difference equation of the form   



    y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



    with the corresponding rational system function   



    H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

    Constructor Specific Documentation:



    Args:
        fftaps : 
        fbtaps : 
        oldstyle : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccd::sptr":
        r"""
        make(pmt_vector_double fftaps, pmt_vector_double fbtaps, bool oldstyle=True) -> iir_filter_ccd_sptr
        IIR filter with complex input, complex output, and double taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccd_make(fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double") -> "void":
        r"""set_taps(iir_filter_ccd self, pmt_vector_double fftaps, pmt_vector_double fbtaps)"""
        return _filter_swig.iir_filter_ccd_set_taps(self, fftaps, fbtaps)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccd

# Register iir_filter_ccd in _filter_swig:
_filter_swig.iir_filter_ccd_swigregister(iir_filter_ccd)
class iir_filter_ccz(object):
    r"""
    IIR filter with complex input, complex output, and complex (double) taps.

    This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


     The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


    The input and output satisfy a difference equation of the form   



    y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



    with the corresponding rational system function   



    H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

    Constructor Specific Documentation:



    Args:
        fftaps : 
        fbtaps : 
        oldstyle : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fftaps: "pmt_vector_cdouble", fbtaps: "pmt_vector_cdouble", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccz::sptr":
        r"""
        make(pmt_vector_cdouble fftaps, pmt_vector_cdouble fbtaps, bool oldstyle=True) -> iir_filter_ccz_sptr
        IIR filter with complex input, complex output, and complex (double) taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccz_make(fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_cdouble", fbtaps: "pmt_vector_cdouble") -> "void":
        r"""set_taps(iir_filter_ccz self, pmt_vector_cdouble fftaps, pmt_vector_cdouble fbtaps)"""
        return _filter_swig.iir_filter_ccz_set_taps(self, fftaps, fbtaps)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccz

# Register iir_filter_ccz in _filter_swig:
_filter_swig.iir_filter_ccz_swigregister(iir_filter_ccz)
class pfb_arb_resampler_ccf(object):
    r"""
    Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and float taps.

    This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccf to perform arbitrary resampling on the stream.


    Output sampling rate is  * input rate.

    Constructor Specific Documentation:

    Build the polyphase filterbank arbitrary resampler.

    Args:
        rate : (float) Specifies the resampling rate to use
        taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
        filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(rate: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_ccf::sptr":
        r"""
        make(float rate, pmt_vector_float taps, unsigned int filter_size=32) -> pfb_arb_resampler_ccf_sptr
        Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccf to perform arbitrary resampling on the stream.


        Output sampling rate is  * input rate.

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_ccf_make(rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_arb_resampler_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_arb_resampler_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_ccf_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_ccf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_ccf_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_ccf self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_ccf_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_ccf self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccf_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_ccf self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccf_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_ccf self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_ccf self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_ccf self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_ccf self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_ccf self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_ccf self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_ccf_phase_offset(self, freq, fs)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_ccf

# Register pfb_arb_resampler_ccf in _filter_swig:
_filter_swig.pfb_arb_resampler_ccf_swigregister(pfb_arb_resampler_ccf)
class pfb_arb_resampler_ccc(object):
    r"""
    Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and gr_complex taps.

    This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccc to perform arbitrary resampling on the stream.


    Output sampling rate is  * input rate.

    Constructor Specific Documentation:

    Build the polyphase filterbank arbitrary resampler.

    Args:
        rate : (float) Specifies the resampling rate to use
        taps : (vector/list of complex) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
        filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(rate: "float", taps: "pmt_vector_cfloat", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_ccc::sptr":
        r"""
        make(float rate, pmt_vector_cfloat taps, unsigned int filter_size=32) -> pfb_arb_resampler_ccc_sptr
        Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and gr_complex taps.

        This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccc to perform arbitrary resampling on the stream.


        Output sampling rate is  * input rate.

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of complex) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_ccc_make(rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        set_taps(pfb_arb_resampler_ccc self, pmt_vector_cfloat taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        taps(pfb_arb_resampler_ccc self) -> gr_vector_vector_complexf
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_ccc_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_ccc self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_ccc_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_ccc self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_ccc_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_ccc self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccc_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_ccc self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccc_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_ccc self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_ccc self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_ccc self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_ccc self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_ccc self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_ccc self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_ccc_phase_offset(self, freq, fs)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_ccc

# Register pfb_arb_resampler_ccc in _filter_swig:
_filter_swig.pfb_arb_resampler_ccc_swigregister(pfb_arb_resampler_ccc)
class pfb_arb_resampler_fff(object):
    r"""
    Polyphase filterbank arbitrary resampler with float input, float output and float taps.

    This block takes in a signal stream and performs arbitrary resampling. The resampling rate can be any real number . The resampling is done by constructing  filters where  is the interpolation rate. We then calculate  where .


    Using  and , we can perform rational resampling where  is a rational number close to the input rate  where we have  filters and we cycle through them as a polyphase filterbank with a stride of  so that .


    To get the arbitrary rate, we want to interpolate between two points. For each value out, we take an output from the current filter, , and the next filter  and then linearly interpolate between the two based on the real resampling rate we want.


    The linear interpolation only provides us with an approximation to the real sampling rate specified. The error is a quantization error between the two filters we used as our interpolation points. To this end, the number of filters, , used determines the quantization error; the larger , the smaller the noise. You can design for a specified noise floor by setting the filter size (parameters ). The size defaults to 32 filters, which is about as good as most implementations need.


    The trick with designing this filter is in how to specify the taps of the prototype filter. Like the PFB interpolator, the taps are specified using the interpolated filter rate. In this case, that rate is the input sample rate multiplied by the number of filters in the filterbank, which is also the interpolation rate. All other values should be relative to this rate.


    For example, for a 32-filter arbitrary resampler and using the GNU Radio's firdes utility to build the filter, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as the interpolation rate ().





    The theory behind this block can be found in Chapter 7.5 of the following book:

    Constructor Specific Documentation:

    Build the polyphase filterbank arbitrary resampler.

    Args:
        rate : (float) Specifies the resampling rate to use
        taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
        filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(rate: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_fff::sptr":
        r"""
        make(float rate, pmt_vector_float taps, unsigned int filter_size=32) -> pfb_arb_resampler_fff_sptr
        Polyphase filterbank arbitrary resampler with float input, float output and float taps.

        This block takes in a signal stream and performs arbitrary resampling. The resampling rate can be any real number . The resampling is done by constructing  filters where  is the interpolation rate. We then calculate  where .


        Using  and , we can perform rational resampling where  is a rational number close to the input rate  where we have  filters and we cycle through them as a polyphase filterbank with a stride of  so that .


        To get the arbitrary rate, we want to interpolate between two points. For each value out, we take an output from the current filter, , and the next filter  and then linearly interpolate between the two based on the real resampling rate we want.


        The linear interpolation only provides us with an approximation to the real sampling rate specified. The error is a quantization error between the two filters we used as our interpolation points. To this end, the number of filters, , used determines the quantization error; the larger , the smaller the noise. You can design for a specified noise floor by setting the filter size (parameters ). The size defaults to 32 filters, which is about as good as most implementations need.


        The trick with designing this filter is in how to specify the taps of the prototype filter. Like the PFB interpolator, the taps are specified using the interpolated filter rate. In this case, that rate is the input sample rate multiplied by the number of filters in the filterbank, which is also the interpolation rate. All other values should be relative to this rate.


        For example, for a 32-filter arbitrary resampler and using the GNU Radio's firdes utility to build the filter, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as the interpolation rate ().





        The theory behind this block can be found in Chapter 7.5 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_fff_make(rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_arb_resampler_fff self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_fff_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_arb_resampler_fff self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_fff_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_fff self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_fff_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_fff self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_fff_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_fff self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_fff_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_fff self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_fff_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_fff self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_fff self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_fff self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_fff self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_fff self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_fff self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_fff_phase_offset(self, freq, fs)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_fff

# Register pfb_arb_resampler_fff in _filter_swig:
_filter_swig.pfb_arb_resampler_fff_swigregister(pfb_arb_resampler_fff)
class pfb_channelizer_ccf(object):
    r"""
    Polyphase filterbank channelizer with gr_complex input, gr_complex output and float taps.

    This block takes in complex inputs and channelizes it to  channels of equal bandwidth. Each of the resulting channels is decimated to the new rate that is the input sampling rate  divided by the number of channels, .


    The PFB channelizer code takes the taps generated above and builds a set of filters. The set contains filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


    Each filter operates using the gr::blocks::fir_filter_XXX class of GNU Radio, which takes the input stream at  and performs the inner product calculation to  where  is the number of filter taps. To efficiently handle this in the GNU Radio structure, each filter input must come from its own input stream. So the channelizer must be provided with  streams where the input stream has been deinterleaved. This is most easily done using the gr::blocks::stream_to_streams block.


    The output is then produced as a vector, where index  in the vector is the next sample from the th channel. This is most easily handled by sending the output to a gr::blocks::vector_to_streams block to handle the conversion and passing  streams out.


    The input and output formatting is done using a hier_block2 called pfb_channelizer_ccf. This can take in a single stream and outputs  streams based on the behavior described above.


    The filter's taps should be based on the input sampling rate.


    For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





    The filter output can also be oversampled. The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.


    For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz. A rate of 6/5 = 1.2, so the output rate would be 1200 Hz.


    The theory behind this block can be found in Chapter 6 of the following book:





    When dealing with oversampling, the above book is still a good reference along with this paper:

    Constructor Specific Documentation:

    Build the polyphase filterbank decimator. 
    For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz.

    Args:
        numchans : (unsigned integer) Specifies the number of channels
        taps : (vector/list of floats) The prototype filter to populate the filterbank.
        oversample_rate : (float) The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(numchans: "unsigned int", taps: "pmt_vector_float", oversample_rate: "float") -> "gr::filter::pfb_channelizer_ccf::sptr":
        r"""
        make(unsigned int numchans, pmt_vector_float taps, float oversample_rate) -> pfb_channelizer_ccf_sptr
        Polyphase filterbank channelizer with gr_complex input, gr_complex output and float taps.

        This block takes in complex inputs and channelizes it to  channels of equal bandwidth. Each of the resulting channels is decimated to the new rate that is the input sampling rate  divided by the number of channels, .


        The PFB channelizer code takes the taps generated above and builds a set of filters. The set contains filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        Each filter operates using the gr::blocks::fir_filter_XXX class of GNU Radio, which takes the input stream at  and performs the inner product calculation to  where  is the number of filter taps. To efficiently handle this in the GNU Radio structure, each filter input must come from its own input stream. So the channelizer must be provided with  streams where the input stream has been deinterleaved. This is most easily done using the gr::blocks::stream_to_streams block.


        The output is then produced as a vector, where index  in the vector is the next sample from the th channel. This is most easily handled by sending the output to a gr::blocks::vector_to_streams block to handle the conversion and passing  streams out.


        The input and output formatting is done using a hier_block2 called pfb_channelizer_ccf. This can take in a single stream and outputs  streams based on the behavior described above.


        The filter's taps should be based on the input sampling rate.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





        The filter output can also be oversampled. The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.


        For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz. A rate of 6/5 = 1.2, so the output rate would be 1200 Hz.


        The theory behind this block can be found in Chapter 6 of the following book:





        When dealing with oversampling, the above book is still a good reference along with this paper:

        Constructor Specific Documentation:

        Build the polyphase filterbank decimator. 
        For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz.

        Args:
            numchans : (unsigned integer) Specifies the number of channels
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            oversample_rate : (float) The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.
        """
        return _filter_swig.pfb_channelizer_ccf_make(numchans, taps, oversample_rate)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_channelizer_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_channelizer_ccf_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_channelizer_ccf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_channelizer_ccf_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_channelizer_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_channelizer_ccf_taps(self)

    def set_channel_map(self, map: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""
        set_channel_map(pfb_channelizer_ccf self, std::vector< int,std::allocator< int > > const & map)
        Set the channel map. Channels are numbers as: 


        So output stream 0 comes from channel 0, etc. Setting a new channel map allows the user to specify which channel in frequency he/she wants to got to which output stream.


        The map should have the same number of elements as the number of output connections from the block. The minimum value of the map is 0 (for the 0th channel) and the maximum number is N-1 where N is the number of channels.


        We specify M as the number of output connections made where M <= N, so only M out of N channels are driven to an output stream. The number of items in the channel map should be at least M long. If there are more channels specified, any value in the map over M-1 will be ignored. If the size of the map is less than M the behavior is unknown (we don't wish to check every entry into the work function).


        This means that if the channelizer is splitting the signal up into N channels but only M channels are specified in the map (where M <= N), then M output streams must be connected and the map and the channel numbers used must be less than N-1. Output channel number can be reused, too. By default, the map is [0...M-1] with M = N.
        """
        return _filter_swig.pfb_channelizer_ccf_set_channel_map(self, map)

    def channel_map(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        channel_map(pfb_channelizer_ccf self) -> std::vector< int,std::allocator< int > >
        Gets the current channel map.
        """
        return _filter_swig.pfb_channelizer_ccf_channel_map(self)
    __swig_destroy__ = _filter_swig.delete_pfb_channelizer_ccf

# Register pfb_channelizer_ccf in _filter_swig:
_filter_swig.pfb_channelizer_ccf_swigregister(pfb_channelizer_ccf)
class pfb_decimator_ccf(object):
    r"""
    Polyphase filterbank bandpass decimator with gr_complex input, gr_complex output and float taps.

    This block takes in a signal stream and performs integer down- sampling (decimation) with a polyphase filterbank. The first input is the integer specifying how much to decimate by. The second input is a vector (Python list) of floating-point taps of the prototype filter. The third input specifies the channel to extract. By default, the zeroth channel is used, which is the baseband channel (first Nyquist zone).


    The  parameter specifies which channel to use since this class is capable of bandpass decimation. Given a complex input stream at a sampling rate of  and a decimation rate of , the input frequency domain is split into  channels that represent the Nyquist zones. Using the polyphase filterbank, we can select any one of these channels to decimate.


    The output signal will be the basebanded and decimated signal from that channel. This concept is very similar to the PFB channelizer (see gr::filter::pfb_channelizer_ccf) where only a single channel is extracted at a time.


    The filter's taps should be based on the sampling rate before decimation.


    For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





    The PFB decimator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


    The theory behind this block can be found in Chapter 6 of the following book:

    Constructor Specific Documentation:

    Build the polyphase filterbank decimator.

    Args:
        decim : (unsigned integer) Specifies the decimation rate to use
        taps : (vector/list of floats) The prototype filter to populate the filterbank.
        channel : (unsigned integer) Selects the channel to return [default=0].
        use_fft_rotator : (bool) Rotate channels using FFT method instead of exp(phi). For larger values of , the FFT method will perform better. Generally, this value of  is small (~5), but could be architecture-specific (Default: true).
        use_fft_filters : (bool) Use FFT filters (fast convolution) instead of FIR filters. FFT filters perform better for larger numbers of taps but is architecture-specific (Default: true).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decim: "unsigned int", taps: "pmt_vector_float", channel: "unsigned int", use_fft_rotator: "bool"=True, use_fft_filters: "bool"=True) -> "gr::filter::pfb_decimator_ccf::sptr":
        r"""
        make(unsigned int decim, pmt_vector_float taps, unsigned int channel, bool use_fft_rotator=True, bool use_fft_filters=True) -> pfb_decimator_ccf_sptr
        Polyphase filterbank bandpass decimator with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and performs integer down- sampling (decimation) with a polyphase filterbank. The first input is the integer specifying how much to decimate by. The second input is a vector (Python list) of floating-point taps of the prototype filter. The third input specifies the channel to extract. By default, the zeroth channel is used, which is the baseband channel (first Nyquist zone).


        The  parameter specifies which channel to use since this class is capable of bandpass decimation. Given a complex input stream at a sampling rate of  and a decimation rate of , the input frequency domain is split into  channels that represent the Nyquist zones. Using the polyphase filterbank, we can select any one of these channels to decimate.


        The output signal will be the basebanded and decimated signal from that channel. This concept is very similar to the PFB channelizer (see gr::filter::pfb_channelizer_ccf) where only a single channel is extracted at a time.


        The filter's taps should be based on the sampling rate before decimation.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





        The PFB decimator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        The theory behind this block can be found in Chapter 6 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank decimator.

        Args:
            decim : (unsigned integer) Specifies the decimation rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            channel : (unsigned integer) Selects the channel to return [default=0].
            use_fft_rotator : (bool) Rotate channels using FFT method instead of exp(phi). For larger values of , the FFT method will perform better. Generally, this value of  is small (~5), but could be architecture-specific (Default: true).
            use_fft_filters : (bool) Use FFT filters (fast convolution) instead of FIR filters. FFT filters perform better for larger numbers of taps but is architecture-specific (Default: true).
        """
        return _filter_swig.pfb_decimator_ccf_make(decim, taps, channel, use_fft_rotator, use_fft_filters)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_decimator_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_decimator_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_decimator_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_decimator_ccf_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_decimator_ccf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_decimator_ccf_print_taps(self)

    def set_channel(self, channel: "unsigned int const") -> "void":
        r"""set_channel(pfb_decimator_ccf self, unsigned int const channel)"""
        return _filter_swig.pfb_decimator_ccf_set_channel(self, channel)
    __swig_destroy__ = _filter_swig.delete_pfb_decimator_ccf

# Register pfb_decimator_ccf in _filter_swig:
_filter_swig.pfb_decimator_ccf_swigregister(pfb_decimator_ccf)
class pfb_interpolator_ccf(object):
    r"""
    Polyphase filterbank interpolator with gr_complex input, gr_complex output and float taps.

    This block takes in a signal stream and performs integer up- sampling (interpolation) with a polyphase filterbank. The first input is the integer specifying how much to interpolate by. The second input is a vector (Python list) of floating-point taps of the prototype filter.


    The filter's taps should be based on the interpolation rate specified. That is, the bandwidth specified is relative to the bandwidth after interpolation.


    For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, ATT, and the filter window function (a Blackman-harris window in this case). The first input is the gain, which is also specified as the interpolation rate so that the output levels are the same as the input (this creates an overall increase in power).





    The PFB interpolator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/interp) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


    The theory behind this block can be found in Chapter 7.1 of the following book:

    Constructor Specific Documentation:

    Build the polyphase filterbank interpolator.

    Args:
        interp : (unsigned integer) Specifies the interpolation rate to use
        taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the interpolated sampling rate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interp: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::pfb_interpolator_ccf::sptr":
        r"""
        make(unsigned int interp, pmt_vector_float taps) -> pfb_interpolator_ccf_sptr
        Polyphase filterbank interpolator with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and performs integer up- sampling (interpolation) with a polyphase filterbank. The first input is the integer specifying how much to interpolate by. The second input is a vector (Python list) of floating-point taps of the prototype filter.


        The filter's taps should be based on the interpolation rate specified. That is, the bandwidth specified is relative to the bandwidth after interpolation.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, ATT, and the filter window function (a Blackman-harris window in this case). The first input is the gain, which is also specified as the interpolation rate so that the output levels are the same as the input (this creates an overall increase in power).





        The PFB interpolator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/interp) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        The theory behind this block can be found in Chapter 7.1 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank interpolator.

        Args:
            interp : (unsigned integer) Specifies the interpolation rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the interpolated sampling rate.
        """
        return _filter_swig.pfb_interpolator_ccf_make(interp, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_interpolator_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_interpolator_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_interpolator_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_interpolator_ccf_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_interpolator_ccf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_interpolator_ccf_print_taps(self)
    __swig_destroy__ = _filter_swig.delete_pfb_interpolator_ccf

# Register pfb_interpolator_ccf in _filter_swig:
_filter_swig.pfb_interpolator_ccf_swigregister(pfb_interpolator_ccf)
class pfb_synthesizer_ccf(object):
    r"""
    Polyphase synthesis filterbank with gr_complex input, gr_complex output and float taps.

    The PFB synthesis filterbank combines multiple baseband signals into a single channelized signal. Each input stream is, essentially, modulated onto an output channel according the the channel mapping (see set_channel_map for details).


    Setting this filterbank up means selecting the number of output channels, the prototype filter, and whether to handle channels at 2x the sample rate (this is generally used only for reconstruction filtering).


    The number of channels sets the maximum number of channels to use, but not all input streams must be connected. For M total channels, we can connect inputs 0 to N where N < M-1. Because of the way GNU Radio handles stream connections, we must connect the channels consecutively, and so we must use the set_channel_map if the desired output channels are not the same as the the default mapping. This features gives us the flexibility to output to any given channel. Generally, we try to not use the channels at the edge of the spectrum to avoid issues with filtering and roll-off of the transmitter or receiver.


    When using the 2x sample rate mode, we specify the number of channels that will be used. However, the actual output signal will be twice this number of channels. This is mainly important to know when setting the channel map. For M channels, the channel mapping can specy from 0 to 2M-1 channels to output onto.


    For more details about this and the concepts of reconstruction filtering, see:

    Constructor Specific Documentation:

    Build the polyphase synthesis filterbank.

    Args:
        numchans : (unsigned integer) Specifies the number of channels
        taps : (vector/list of floats) The prototype filter to populate the filterbank.
        twox : (bool) use 2x oversampling or not (default is no)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(numchans: "unsigned int", taps: "pmt_vector_float", twox: "bool"=False) -> "gr::filter::pfb_synthesizer_ccf::sptr":
        r"""
        make(unsigned int numchans, pmt_vector_float taps, bool twox=False) -> pfb_synthesizer_ccf_sptr
        Polyphase synthesis filterbank with gr_complex input, gr_complex output and float taps.

        The PFB synthesis filterbank combines multiple baseband signals into a single channelized signal. Each input stream is, essentially, modulated onto an output channel according the the channel mapping (see set_channel_map for details).


        Setting this filterbank up means selecting the number of output channels, the prototype filter, and whether to handle channels at 2x the sample rate (this is generally used only for reconstruction filtering).


        The number of channels sets the maximum number of channels to use, but not all input streams must be connected. For M total channels, we can connect inputs 0 to N where N < M-1. Because of the way GNU Radio handles stream connections, we must connect the channels consecutively, and so we must use the set_channel_map if the desired output channels are not the same as the the default mapping. This features gives us the flexibility to output to any given channel. Generally, we try to not use the channels at the edge of the spectrum to avoid issues with filtering and roll-off of the transmitter or receiver.


        When using the 2x sample rate mode, we specify the number of channels that will be used. However, the actual output signal will be twice this number of channels. This is mainly important to know when setting the channel map. For M channels, the channel mapping can specy from 0 to 2M-1 channels to output onto.


        For more details about this and the concepts of reconstruction filtering, see:

        Constructor Specific Documentation:

        Build the polyphase synthesis filterbank.

        Args:
            numchans : (unsigned integer) Specifies the number of channels
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            twox : (bool) use 2x oversampling or not (default is no)
        """
        return _filter_swig.pfb_synthesizer_ccf_make(numchans, taps, twox)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_synthesizer_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_synthesizer_ccf_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_synthesizer_ccf self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_synthesizer_ccf_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_synthesizer_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_synthesizer_ccf_taps(self)

    def set_channel_map(self, map: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""
        set_channel_map(pfb_synthesizer_ccf self, std::vector< int,std::allocator< int > > const & map)
        Set the channel map. Channels are numbers as: 


        So input stream 0 goes to channel 0, etc. Setting a new channel map allows the user to specify where in frequency he/she wants the input stream to go. This is especially useful to avoid putting signals into the channels on the edge of the spectrum which can either wrap around (in the case of odd number of channels) and be affected by filter rolloff in the transmitter.


        The map must be at least the number of streams being sent to the block. Less and the algorithm will not have enough data to properly setup the buffers. Any more channels specified will be ignored.
        """
        return _filter_swig.pfb_synthesizer_ccf_set_channel_map(self, map)

    def channel_map(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        channel_map(pfb_synthesizer_ccf self) -> std::vector< int,std::allocator< int > >
        Gets the current channel map.
        """
        return _filter_swig.pfb_synthesizer_ccf_channel_map(self)
    __swig_destroy__ = _filter_swig.delete_pfb_synthesizer_ccf

# Register pfb_synthesizer_ccf in _filter_swig:
_filter_swig.pfb_synthesizer_ccf_swigregister(pfb_synthesizer_ccf)
class single_pole_iir_filter_cc(object):
    r"""
    single pole IIR filter with complex input, complex output

    The input and output satisfy a difference equation of the form 



    y[n] - (1-alpha) y[n-1] = alpha x[n]



    with the corresponding rational system function 



    H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



    Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

    Constructor Specific Documentation:



    Args:
        alpha : 
        vlen : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(alpha: "double", vlen: "unsigned int"=1) -> "gr::filter::single_pole_iir_filter_cc::sptr":
        r"""
        make(double alpha, unsigned int vlen=1) -> single_pole_iir_filter_cc_sptr
        single pole IIR filter with complex input, complex output

        The input and output satisfy a difference equation of the form 



        y[n] - (1-alpha) y[n-1] = alpha x[n]



        with the corresponding rational system function 



        H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



        Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

        Constructor Specific Documentation:



        Args:
            alpha : 
            vlen : 
        """
        return _filter_swig.single_pole_iir_filter_cc_make(alpha, vlen)

    def set_taps(self, alpha: "double") -> "void":
        r"""set_taps(single_pole_iir_filter_cc self, double alpha)"""
        return _filter_swig.single_pole_iir_filter_cc_set_taps(self, alpha)
    __swig_destroy__ = _filter_swig.delete_single_pole_iir_filter_cc

# Register single_pole_iir_filter_cc in _filter_swig:
_filter_swig.single_pole_iir_filter_cc_swigregister(single_pole_iir_filter_cc)
class single_pole_iir_filter_ff(object):
    r"""
    single pole IIR filter with float input, float output

    The input and output satisfy a difference equation of the form 



    y[n] - (1-alpha) y[n-1] = alpha x[n]



    with the corresponding rational system function 



    H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



    Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

    Constructor Specific Documentation:



    Args:
        alpha : 
        vlen : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(alpha: "double", vlen: "unsigned int"=1) -> "gr::filter::single_pole_iir_filter_ff::sptr":
        r"""
        make(double alpha, unsigned int vlen=1) -> single_pole_iir_filter_ff_sptr
        single pole IIR filter with float input, float output

        The input and output satisfy a difference equation of the form 



        y[n] - (1-alpha) y[n-1] = alpha x[n]



        with the corresponding rational system function 



        H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



        Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

        Constructor Specific Documentation:



        Args:
            alpha : 
            vlen : 
        """
        return _filter_swig.single_pole_iir_filter_ff_make(alpha, vlen)

    def set_taps(self, alpha: "double") -> "void":
        r"""set_taps(single_pole_iir_filter_ff self, double alpha)"""
        return _filter_swig.single_pole_iir_filter_ff_set_taps(self, alpha)
    __swig_destroy__ = _filter_swig.delete_single_pole_iir_filter_ff

# Register single_pole_iir_filter_ff in _filter_swig:
_filter_swig.single_pole_iir_filter_ff_swigregister(single_pole_iir_filter_ff)
class dc_blocker_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::dc_blocker_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(dc_blocker_cc_sptr self) -> dc_blocker_cc_sptr
        __init__(dc_blocker_cc_sptr self, dc_blocker_cc p) -> dc_blocker_cc_sptr
        """
        _filter_swig.dc_blocker_cc_sptr_swiginit(self, _filter_swig.new_dc_blocker_cc_sptr(*args))

    def __deref__(self) -> "gr::filter::dc_blocker_cc *":
        r"""__deref__(dc_blocker_cc_sptr self) -> dc_blocker_cc"""
        return _filter_swig.dc_blocker_cc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_dc_blocker_cc_sptr

    def make(self, D: "int", long_form: "bool") -> "gr::filter::dc_blocker_cc::sptr":
        r"""
        make(dc_blocker_cc_sptr self, int D, bool long_form) -> dc_blocker_cc_sptr
        a computationally efficient controllable DC blocker

        This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


        The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


        The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


        The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


        The theory behind this block can be found in the paper:

        Constructor Specific Documentation:

        Make a DC blocker block.

        Args:
            D : (int) the length of the delay line
            long_form : (bool) whether to use long (true, default) or short form
        """
        return _filter_swig.dc_blocker_cc_sptr_make(self, D, long_form)

    def group_delay(self) -> "int":
        r"""group_delay(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_group_delay(self)

    def history(self) -> "unsigned int":
        r"""history(dc_blocker_cc_sptr self) -> unsigned int"""
        return _filter_swig.dc_blocker_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(dc_blocker_cc_sptr self, int which, int delay)
        declare_sample_delay(dc_blocker_cc_sptr self, unsigned int delay)
        """
        return _filter_swig.dc_blocker_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(dc_blocker_cc_sptr self, int which) -> unsigned int"""
        return _filter_swig.dc_blocker_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(dc_blocker_cc_sptr self, int multiple)"""
        return _filter_swig.dc_blocker_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(dc_blocker_cc_sptr self) -> double"""
        return _filter_swig.dc_blocker_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(dc_blocker_cc_sptr self) -> uint64_t"""
        return _filter_swig.dc_blocker_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(dc_blocker_cc_sptr self) -> uint64_t"""
        return _filter_swig.dc_blocker_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(dc_blocker_cc_sptr self) -> bool"""
        return _filter_swig.dc_blocker_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(dc_blocker_cc_sptr self) -> bool"""
        return _filter_swig.dc_blocker_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(dc_blocker_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.dc_blocker_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(dc_blocker_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.dc_blocker_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(dc_blocker_cc_sptr self, std::string level)"""
        return _filter_swig.dc_blocker_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(dc_blocker_cc_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(dc_blocker_cc_sptr self, int m)"""
        return _filter_swig.dc_blocker_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(dc_blocker_cc_sptr self)"""
        return _filter_swig.dc_blocker_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(dc_blocker_cc_sptr self) -> bool"""
        return _filter_swig.dc_blocker_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(dc_blocker_cc_sptr self, int m)"""
        return _filter_swig.dc_blocker_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(dc_blocker_cc_sptr self, int i) -> long"""
        return _filter_swig.dc_blocker_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(dc_blocker_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(dc_blocker_cc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.dc_blocker_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(dc_blocker_cc_sptr self, int i) -> long"""
        return _filter_swig.dc_blocker_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(dc_blocker_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(dc_blocker_cc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.dc_blocker_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(dc_blocker_cc_sptr self, int which) -> float
        pc_input_buffers_full(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(dc_blocker_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(dc_blocker_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(dc_blocker_cc_sptr self, int which) -> float
        pc_output_buffers_full(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(dc_blocker_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(dc_blocker_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(dc_blocker_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(dc_blocker_cc_sptr self) -> float"""
        return _filter_swig.dc_blocker_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(dc_blocker_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.dc_blocker_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(dc_blocker_cc_sptr self)"""
        return _filter_swig.dc_blocker_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(dc_blocker_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.dc_blocker_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(dc_blocker_cc_sptr self) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(dc_blocker_cc_sptr self, int priority) -> int"""
        return _filter_swig.dc_blocker_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(dc_blocker_cc_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(dc_blocker_cc_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(dc_blocker_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.dc_blocker_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(dc_blocker_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.dc_blocker_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(dc_blocker_cc_sptr self) -> long"""
        return _filter_swig.dc_blocker_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(dc_blocker_cc_sptr self) -> basic_block_sptr"""
        return _filter_swig.dc_blocker_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(dc_blocker_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.dc_blocker_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(dc_blocker_cc_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(dc_blocker_cc_sptr self, std::string name)"""
        return _filter_swig.dc_blocker_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(dc_blocker_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.dc_blocker_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(dc_blocker_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(dc_blocker_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(dc_blocker_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_cc_sptr_message_subscribers(self, which_port)

# Register dc_blocker_cc_sptr in _filter_swig:
_filter_swig.dc_blocker_cc_sptr_swigregister(dc_blocker_cc_sptr)

dc_blocker_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
dc_blocker_cc = dc_blocker_cc.make;

class dc_blocker_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::dc_blocker_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(dc_blocker_ff_sptr self) -> dc_blocker_ff_sptr
        __init__(dc_blocker_ff_sptr self, dc_blocker_ff p) -> dc_blocker_ff_sptr
        """
        _filter_swig.dc_blocker_ff_sptr_swiginit(self, _filter_swig.new_dc_blocker_ff_sptr(*args))

    def __deref__(self) -> "gr::filter::dc_blocker_ff *":
        r"""__deref__(dc_blocker_ff_sptr self) -> dc_blocker_ff"""
        return _filter_swig.dc_blocker_ff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_dc_blocker_ff_sptr

    def make(self, D: "int", long_form: "bool"=True) -> "gr::filter::dc_blocker_ff::sptr":
        r"""
        make(dc_blocker_ff_sptr self, int D, bool long_form=True) -> dc_blocker_ff_sptr
        a computationally efficient controllable DC blocker

        This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


        The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


        The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


        The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


        The theory behind this block can be found in the paper:

        Constructor Specific Documentation:

        Make a DC blocker block.

        Args:
            D : (int) the length of the delay line
            long_form : (bool) whether to use long (true, default) or short form
        """
        return _filter_swig.dc_blocker_ff_sptr_make(self, D, long_form)

    def group_delay(self) -> "int":
        r"""group_delay(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_group_delay(self)

    def history(self) -> "unsigned int":
        r"""history(dc_blocker_ff_sptr self) -> unsigned int"""
        return _filter_swig.dc_blocker_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(dc_blocker_ff_sptr self, int which, int delay)
        declare_sample_delay(dc_blocker_ff_sptr self, unsigned int delay)
        """
        return _filter_swig.dc_blocker_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(dc_blocker_ff_sptr self, int which) -> unsigned int"""
        return _filter_swig.dc_blocker_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(dc_blocker_ff_sptr self, int multiple)"""
        return _filter_swig.dc_blocker_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(dc_blocker_ff_sptr self) -> double"""
        return _filter_swig.dc_blocker_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(dc_blocker_ff_sptr self) -> uint64_t"""
        return _filter_swig.dc_blocker_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(dc_blocker_ff_sptr self) -> uint64_t"""
        return _filter_swig.dc_blocker_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(dc_blocker_ff_sptr self) -> bool"""
        return _filter_swig.dc_blocker_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(dc_blocker_ff_sptr self) -> bool"""
        return _filter_swig.dc_blocker_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(dc_blocker_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.dc_blocker_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(dc_blocker_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.dc_blocker_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(dc_blocker_ff_sptr self, std::string level)"""
        return _filter_swig.dc_blocker_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(dc_blocker_ff_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(dc_blocker_ff_sptr self, int m)"""
        return _filter_swig.dc_blocker_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(dc_blocker_ff_sptr self)"""
        return _filter_swig.dc_blocker_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(dc_blocker_ff_sptr self) -> bool"""
        return _filter_swig.dc_blocker_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(dc_blocker_ff_sptr self, int m)"""
        return _filter_swig.dc_blocker_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(dc_blocker_ff_sptr self, int i) -> long"""
        return _filter_swig.dc_blocker_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(dc_blocker_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(dc_blocker_ff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.dc_blocker_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(dc_blocker_ff_sptr self, int i) -> long"""
        return _filter_swig.dc_blocker_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(dc_blocker_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(dc_blocker_ff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.dc_blocker_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(dc_blocker_ff_sptr self, int which) -> float
        pc_input_buffers_full(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(dc_blocker_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(dc_blocker_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(dc_blocker_ff_sptr self, int which) -> float
        pc_output_buffers_full(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(dc_blocker_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(dc_blocker_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(dc_blocker_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.dc_blocker_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(dc_blocker_ff_sptr self) -> float"""
        return _filter_swig.dc_blocker_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(dc_blocker_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.dc_blocker_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(dc_blocker_ff_sptr self)"""
        return _filter_swig.dc_blocker_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(dc_blocker_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.dc_blocker_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(dc_blocker_ff_sptr self) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(dc_blocker_ff_sptr self, int priority) -> int"""
        return _filter_swig.dc_blocker_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(dc_blocker_ff_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(dc_blocker_ff_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(dc_blocker_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.dc_blocker_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(dc_blocker_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.dc_blocker_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(dc_blocker_ff_sptr self) -> long"""
        return _filter_swig.dc_blocker_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(dc_blocker_ff_sptr self) -> basic_block_sptr"""
        return _filter_swig.dc_blocker_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(dc_blocker_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.dc_blocker_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(dc_blocker_ff_sptr self) -> std::string"""
        return _filter_swig.dc_blocker_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(dc_blocker_ff_sptr self, std::string name)"""
        return _filter_swig.dc_blocker_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(dc_blocker_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.dc_blocker_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(dc_blocker_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(dc_blocker_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(dc_blocker_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.dc_blocker_ff_sptr_message_subscribers(self, which_port)

# Register dc_blocker_ff_sptr in _filter_swig:
_filter_swig.dc_blocker_ff_sptr_swigregister(dc_blocker_ff_sptr)

dc_blocker_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
dc_blocker_ff = dc_blocker_ff.make;

class filter_delay_fc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::filter_delay_fc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(filter_delay_fc_sptr self) -> filter_delay_fc_sptr
        __init__(filter_delay_fc_sptr self, filter_delay_fc p) -> filter_delay_fc_sptr
        """
        _filter_swig.filter_delay_fc_sptr_swiginit(self, _filter_swig.new_filter_delay_fc_sptr(*args))

    def __deref__(self) -> "gr::filter::filter_delay_fc *":
        r"""__deref__(filter_delay_fc_sptr self) -> filter_delay_fc"""
        return _filter_swig.filter_delay_fc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_filter_delay_fc_sptr

    def make(self, taps: "pmt_vector_float") -> "gr::filter::filter_delay_fc::sptr":
        r"""
        make(filter_delay_fc_sptr self, pmt_vector_float taps) -> filter_delay_fc_sptr
        Filter-Delay Combination Block.

        The block takes one or two float stream and outputs a complex stream.


        If only one float stream is input, the real output is a delayed version of this input and the imaginary output is the filtered output.


        If two floats are connected to the input, then the real output is the delayed version of the first input, and the imaginary output is the filtered output.


        The delay in the real path accounts for the group delay introduced by the filter in the imaginary path. The filter taps needs to be calculated before initializing this block.

        Constructor Specific Documentation:

        Build a filter with delay block.

        Args:
            taps : 
        """
        return _filter_swig.filter_delay_fc_sptr_make(self, taps)

    def history(self) -> "unsigned int":
        r"""history(filter_delay_fc_sptr self) -> unsigned int"""
        return _filter_swig.filter_delay_fc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(filter_delay_fc_sptr self, int which, int delay)
        declare_sample_delay(filter_delay_fc_sptr self, unsigned int delay)
        """
        return _filter_swig.filter_delay_fc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(filter_delay_fc_sptr self, int which) -> unsigned int"""
        return _filter_swig.filter_delay_fc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(filter_delay_fc_sptr self, int multiple)"""
        return _filter_swig.filter_delay_fc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(filter_delay_fc_sptr self) -> int"""
        return _filter_swig.filter_delay_fc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(filter_delay_fc_sptr self) -> double"""
        return _filter_swig.filter_delay_fc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(filter_delay_fc_sptr self) -> uint64_t"""
        return _filter_swig.filter_delay_fc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(filter_delay_fc_sptr self) -> uint64_t"""
        return _filter_swig.filter_delay_fc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(filter_delay_fc_sptr self) -> bool"""
        return _filter_swig.filter_delay_fc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(filter_delay_fc_sptr self) -> bool"""
        return _filter_swig.filter_delay_fc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(filter_delay_fc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.filter_delay_fc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(filter_delay_fc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.filter_delay_fc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(filter_delay_fc_sptr self, std::string level)"""
        return _filter_swig.filter_delay_fc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(filter_delay_fc_sptr self) -> std::string"""
        return _filter_swig.filter_delay_fc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(filter_delay_fc_sptr self) -> int"""
        return _filter_swig.filter_delay_fc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(filter_delay_fc_sptr self, int m)"""
        return _filter_swig.filter_delay_fc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(filter_delay_fc_sptr self)"""
        return _filter_swig.filter_delay_fc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(filter_delay_fc_sptr self) -> bool"""
        return _filter_swig.filter_delay_fc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(filter_delay_fc_sptr self, int m)"""
        return _filter_swig.filter_delay_fc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(filter_delay_fc_sptr self) -> int"""
        return _filter_swig.filter_delay_fc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(filter_delay_fc_sptr self, int i) -> long"""
        return _filter_swig.filter_delay_fc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(filter_delay_fc_sptr self, long max_output_buffer)
        set_max_output_buffer(filter_delay_fc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.filter_delay_fc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(filter_delay_fc_sptr self, int i) -> long"""
        return _filter_swig.filter_delay_fc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(filter_delay_fc_sptr self, long min_output_buffer)
        set_min_output_buffer(filter_delay_fc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.filter_delay_fc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(filter_delay_fc_sptr self, int which) -> float
        pc_input_buffers_full(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(filter_delay_fc_sptr self, int which) -> float
        pc_input_buffers_full_avg(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(filter_delay_fc_sptr self, int which) -> float
        pc_input_buffers_full_var(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(filter_delay_fc_sptr self, int which) -> float
        pc_output_buffers_full(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(filter_delay_fc_sptr self, int which) -> float
        pc_output_buffers_full_avg(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(filter_delay_fc_sptr self, int which) -> float
        pc_output_buffers_full_var(filter_delay_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filter_delay_fc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(filter_delay_fc_sptr self) -> float"""
        return _filter_swig.filter_delay_fc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(filter_delay_fc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.filter_delay_fc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(filter_delay_fc_sptr self)"""
        return _filter_swig.filter_delay_fc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(filter_delay_fc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.filter_delay_fc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(filter_delay_fc_sptr self) -> int"""
        return _filter_swig.filter_delay_fc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(filter_delay_fc_sptr self) -> int"""
        return _filter_swig.filter_delay_fc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(filter_delay_fc_sptr self, int priority) -> int"""
        return _filter_swig.filter_delay_fc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(filter_delay_fc_sptr self) -> std::string"""
        return _filter_swig.filter_delay_fc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(filter_delay_fc_sptr self) -> std::string"""
        return _filter_swig.filter_delay_fc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(filter_delay_fc_sptr self) -> io_signature_sptr"""
        return _filter_swig.filter_delay_fc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(filter_delay_fc_sptr self) -> io_signature_sptr"""
        return _filter_swig.filter_delay_fc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(filter_delay_fc_sptr self) -> long"""
        return _filter_swig.filter_delay_fc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(filter_delay_fc_sptr self) -> basic_block_sptr"""
        return _filter_swig.filter_delay_fc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(filter_delay_fc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.filter_delay_fc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(filter_delay_fc_sptr self) -> std::string"""
        return _filter_swig.filter_delay_fc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(filter_delay_fc_sptr self, std::string name)"""
        return _filter_swig.filter_delay_fc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(filter_delay_fc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.filter_delay_fc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(filter_delay_fc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.filter_delay_fc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(filter_delay_fc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.filter_delay_fc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(filter_delay_fc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.filter_delay_fc_sptr_message_subscribers(self, which_port)

# Register filter_delay_fc_sptr in _filter_swig:
_filter_swig.filter_delay_fc_sptr_swigregister(filter_delay_fc_sptr)

filter_delay_fc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
filter_delay_fc = filter_delay_fc.make;

class filterbank_vcvcf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::filterbank_vcvcf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(filterbank_vcvcf_sptr self) -> filterbank_vcvcf_sptr
        __init__(filterbank_vcvcf_sptr self, filterbank_vcvcf p) -> filterbank_vcvcf_sptr
        """
        _filter_swig.filterbank_vcvcf_sptr_swiginit(self, _filter_swig.new_filterbank_vcvcf_sptr(*args))

    def __deref__(self) -> "gr::filter::filterbank_vcvcf *":
        r"""__deref__(filterbank_vcvcf_sptr self) -> filterbank_vcvcf"""
        return _filter_swig.filterbank_vcvcf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_filterbank_vcvcf_sptr

    def make(self, taps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &") -> "gr::filter::filterbank_vcvcf::sptr":
        r"""
        make(filterbank_vcvcf_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & taps) -> filterbank_vcvcf_sptr
        Filterbank with vector of gr_complex input, vector of gr_complex output and float taps.

        This block takes in complex vectors and outputs complex vectors of the same size. Vectors of length N, rather than N normal streams are used to reduce overhead.

        Constructor Specific Documentation:

        Build the filterbank.

        Args:
            taps : (vector of vector of floats/list of list of floats) Used to populate the filters.
        """
        return _filter_swig.filterbank_vcvcf_sptr_make(self, taps)

    def set_taps(self, taps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &") -> "void":
        r"""
        set_taps(filterbank_vcvcf_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.filterbank_vcvcf_sptr_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(filterbank_vcvcf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.filterbank_vcvcf_sptr_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(filterbank_vcvcf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.filterbank_vcvcf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(filterbank_vcvcf_sptr self) -> unsigned int"""
        return _filter_swig.filterbank_vcvcf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(filterbank_vcvcf_sptr self, int which, int delay)
        declare_sample_delay(filterbank_vcvcf_sptr self, unsigned int delay)
        """
        return _filter_swig.filterbank_vcvcf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(filterbank_vcvcf_sptr self, int which) -> unsigned int"""
        return _filter_swig.filterbank_vcvcf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(filterbank_vcvcf_sptr self, int multiple)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(filterbank_vcvcf_sptr self) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(filterbank_vcvcf_sptr self) -> double"""
        return _filter_swig.filterbank_vcvcf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(filterbank_vcvcf_sptr self) -> uint64_t"""
        return _filter_swig.filterbank_vcvcf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(filterbank_vcvcf_sptr self) -> uint64_t"""
        return _filter_swig.filterbank_vcvcf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(filterbank_vcvcf_sptr self) -> bool"""
        return _filter_swig.filterbank_vcvcf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(filterbank_vcvcf_sptr self) -> bool"""
        return _filter_swig.filterbank_vcvcf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(filterbank_vcvcf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.filterbank_vcvcf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(filterbank_vcvcf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.filterbank_vcvcf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(filterbank_vcvcf_sptr self, std::string level)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(filterbank_vcvcf_sptr self) -> std::string"""
        return _filter_swig.filterbank_vcvcf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(filterbank_vcvcf_sptr self) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(filterbank_vcvcf_sptr self, int m)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(filterbank_vcvcf_sptr self)"""
        return _filter_swig.filterbank_vcvcf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(filterbank_vcvcf_sptr self) -> bool"""
        return _filter_swig.filterbank_vcvcf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(filterbank_vcvcf_sptr self, int m)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(filterbank_vcvcf_sptr self) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(filterbank_vcvcf_sptr self, int i) -> long"""
        return _filter_swig.filterbank_vcvcf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(filterbank_vcvcf_sptr self, long max_output_buffer)
        set_max_output_buffer(filterbank_vcvcf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.filterbank_vcvcf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(filterbank_vcvcf_sptr self, int i) -> long"""
        return _filter_swig.filterbank_vcvcf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(filterbank_vcvcf_sptr self, long min_output_buffer)
        set_min_output_buffer(filterbank_vcvcf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.filterbank_vcvcf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(filterbank_vcvcf_sptr self, int which) -> float
        pc_input_buffers_full(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(filterbank_vcvcf_sptr self, int which) -> float
        pc_input_buffers_full_avg(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(filterbank_vcvcf_sptr self, int which) -> float
        pc_input_buffers_full_var(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(filterbank_vcvcf_sptr self, int which) -> float
        pc_output_buffers_full(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(filterbank_vcvcf_sptr self, int which) -> float
        pc_output_buffers_full_avg(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(filterbank_vcvcf_sptr self, int which) -> float
        pc_output_buffers_full_var(filterbank_vcvcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.filterbank_vcvcf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(filterbank_vcvcf_sptr self) -> float"""
        return _filter_swig.filterbank_vcvcf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(filterbank_vcvcf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(filterbank_vcvcf_sptr self)"""
        return _filter_swig.filterbank_vcvcf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(filterbank_vcvcf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.filterbank_vcvcf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(filterbank_vcvcf_sptr self) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(filterbank_vcvcf_sptr self) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(filterbank_vcvcf_sptr self, int priority) -> int"""
        return _filter_swig.filterbank_vcvcf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(filterbank_vcvcf_sptr self) -> std::string"""
        return _filter_swig.filterbank_vcvcf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(filterbank_vcvcf_sptr self) -> std::string"""
        return _filter_swig.filterbank_vcvcf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(filterbank_vcvcf_sptr self) -> io_signature_sptr"""
        return _filter_swig.filterbank_vcvcf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(filterbank_vcvcf_sptr self) -> io_signature_sptr"""
        return _filter_swig.filterbank_vcvcf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(filterbank_vcvcf_sptr self) -> long"""
        return _filter_swig.filterbank_vcvcf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(filterbank_vcvcf_sptr self) -> basic_block_sptr"""
        return _filter_swig.filterbank_vcvcf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(filterbank_vcvcf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.filterbank_vcvcf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(filterbank_vcvcf_sptr self) -> std::string"""
        return _filter_swig.filterbank_vcvcf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(filterbank_vcvcf_sptr self, std::string name)"""
        return _filter_swig.filterbank_vcvcf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(filterbank_vcvcf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.filterbank_vcvcf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(filterbank_vcvcf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.filterbank_vcvcf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(filterbank_vcvcf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.filterbank_vcvcf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(filterbank_vcvcf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.filterbank_vcvcf_sptr_message_subscribers(self, which_port)

# Register filterbank_vcvcf_sptr in _filter_swig:
_filter_swig.filterbank_vcvcf_sptr_swigregister(filterbank_vcvcf_sptr)

filterbank_vcvcf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
filterbank_vcvcf = filterbank_vcvcf.make;

class fir_filter_ccc(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps) -> fir_filter_ccc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_ccc_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_ccc self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_ccc self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_ccc_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_ccc

# Register fir_filter_ccc in _filter_swig:
_filter_swig.fir_filter_ccc_swigregister(fir_filter_ccc)
class fir_filter_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< gr_complex,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_ccc_sptr self) -> fir_filter_ccc_sptr
        __init__(fir_filter_ccc_sptr self, fir_filter_ccc p) -> fir_filter_ccc_sptr
        """
        _filter_swig.fir_filter_ccc_sptr_swiginit(self, _filter_swig.new_fir_filter_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< gr_complex,gr_complex,gr_complex > *":
        r"""__deref__(fir_filter_ccc_sptr self) -> fir_filter_ccc"""
        return _filter_swig.fir_filter_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_ccc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(fir_filter_ccc_sptr self, int decimation, pmt_vector_cfloat taps) -> fir_filter_ccc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_ccc_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_ccc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_ccc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_ccc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_ccc_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_ccc_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_ccc_sptr self, int multiple)"""
        return _filter_swig.fir_filter_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_ccc_sptr self) -> double"""
        return _filter_swig.fir_filter_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_ccc_sptr self, std::string level)"""
        return _filter_swig.fir_filter_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.fir_filter_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_ccc_sptr self)"""
        return _filter_swig.fir_filter_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.fir_filter_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.fir_filter_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_ccc_sptr self)"""
        return _filter_swig.fir_filter_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_ccc_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_ccc_sptr self) -> long"""
        return _filter_swig.fir_filter_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_ccc_sptr self, std::string name)"""
        return _filter_swig.fir_filter_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccc_sptr_message_subscribers(self, which_port)

# Register fir_filter_ccc_sptr in _filter_swig:
_filter_swig.fir_filter_ccc_sptr_swigregister(fir_filter_ccc_sptr)

fir_filter_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_ccc = fir_filter_ccc.make

class fir_filter_ccf(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps) -> fir_filter_ccf_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_ccf_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_ccf self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_ccf self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_ccf_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_ccf

# Register fir_filter_ccf in _filter_swig:
_filter_swig.fir_filter_ccf_swigregister(fir_filter_ccf)
class fir_filter_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< gr_complex,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_ccf_sptr self) -> fir_filter_ccf_sptr
        __init__(fir_filter_ccf_sptr self, fir_filter_ccf p) -> fir_filter_ccf_sptr
        """
        _filter_swig.fir_filter_ccf_sptr_swiginit(self, _filter_swig.new_fir_filter_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< gr_complex,gr_complex,float > *":
        r"""__deref__(fir_filter_ccf_sptr self) -> fir_filter_ccf"""
        return _filter_swig.fir_filter_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_ccf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(fir_filter_ccf_sptr self, int decimation, pmt_vector_float taps) -> fir_filter_ccf_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_ccf_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_ccf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_ccf_sptr self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_ccf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_ccf_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_ccf_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_ccf_sptr self, int multiple)"""
        return _filter_swig.fir_filter_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_ccf_sptr self) -> double"""
        return _filter_swig.fir_filter_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_ccf_sptr self, std::string level)"""
        return _filter_swig.fir_filter_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.fir_filter_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_ccf_sptr self)"""
        return _filter_swig.fir_filter_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fir_filter_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.fir_filter_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.fir_filter_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_ccf_sptr self)"""
        return _filter_swig.fir_filter_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_ccf_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_ccf_sptr self) -> long"""
        return _filter_swig.fir_filter_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_ccf_sptr self, std::string name)"""
        return _filter_swig.fir_filter_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_ccf_sptr_message_subscribers(self, which_port)

# Register fir_filter_ccf_sptr in _filter_swig:
_filter_swig.fir_filter_ccf_sptr_swigregister(fir_filter_ccf_sptr)

fir_filter_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_ccf = fir_filter_ccf.make

class fir_filter_fcc(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps) -> fir_filter_fcc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fcc_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_fcc self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_fcc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_fcc self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_fcc_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fcc

# Register fir_filter_fcc in _filter_swig:
_filter_swig.fir_filter_fcc_swigregister(fir_filter_fcc)
class fir_filter_fcc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< float,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_fcc_sptr self) -> fir_filter_fcc_sptr
        __init__(fir_filter_fcc_sptr self, fir_filter_fcc p) -> fir_filter_fcc_sptr
        """
        _filter_swig.fir_filter_fcc_sptr_swiginit(self, _filter_swig.new_fir_filter_fcc_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< float,gr_complex,gr_complex > *":
        r"""__deref__(fir_filter_fcc_sptr self) -> fir_filter_fcc"""
        return _filter_swig.fir_filter_fcc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fcc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(fir_filter_fcc_sptr self, int decimation, pmt_vector_cfloat taps) -> fir_filter_fcc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fcc_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_fcc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_fcc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_fcc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_fcc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_fcc_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_fcc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_fcc_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_fcc_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_fcc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_fcc_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_fcc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_fcc_sptr self, int multiple)"""
        return _filter_swig.fir_filter_fcc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_fcc_sptr self) -> double"""
        return _filter_swig.fir_filter_fcc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fcc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fcc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.fir_filter_fcc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.fir_filter_fcc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_fcc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_fcc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_fcc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_fcc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_fcc_sptr self, std::string level)"""
        return _filter_swig.fir_filter_fcc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fcc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.fir_filter_fcc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_fcc_sptr self)"""
        return _filter_swig.fir_filter_fcc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.fir_filter_fcc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.fir_filter_fcc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fcc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_fcc_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_fcc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_fcc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fcc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_fcc_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_fcc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_fcc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fcc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.fir_filter_fcc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_fcc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_fcc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_fcc_sptr self)"""
        return _filter_swig.fir_filter_fcc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_fcc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_fcc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_fcc_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_fcc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fcc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fcc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fcc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fcc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_fcc_sptr self) -> long"""
        return _filter_swig.fir_filter_fcc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_fcc_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_fcc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_fcc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_fcc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fcc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_fcc_sptr self, std::string name)"""
        return _filter_swig.fir_filter_fcc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_fcc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_fcc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fcc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fcc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_fcc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fcc_sptr_message_subscribers(self, which_port)

# Register fir_filter_fcc_sptr in _filter_swig:
_filter_swig.fir_filter_fcc_sptr_swigregister(fir_filter_fcc_sptr)

fir_filter_fcc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_fcc = fir_filter_fcc.make

class fir_filter_fff(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< float,float,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps) -> fir_filter_fff_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fff_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_fff self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_fff_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_fff self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_fff_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fff

# Register fir_filter_fff in _filter_swig:
_filter_swig.fir_filter_fff_swigregister(fir_filter_fff)
class fir_filter_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< float,float,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_fff_sptr self) -> fir_filter_fff_sptr
        __init__(fir_filter_fff_sptr self, fir_filter_fff p) -> fir_filter_fff_sptr
        """
        _filter_swig.fir_filter_fff_sptr_swiginit(self, _filter_swig.new_fir_filter_fff_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< float,float,float > *":
        r"""__deref__(fir_filter_fff_sptr self) -> fir_filter_fff"""
        return _filter_swig.fir_filter_fff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fff_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< float,float,float >::sptr":
        r"""
        make(fir_filter_fff_sptr self, int decimation, pmt_vector_float taps) -> fir_filter_fff_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fff_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_fff_sptr self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_fff_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_fff_sptr self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_fff_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_fff_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_fff_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_fff_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_fff_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_fff_sptr self, int multiple)"""
        return _filter_swig.fir_filter_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_fff_sptr self) -> int"""
        return _filter_swig.fir_filter_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_fff_sptr self) -> double"""
        return _filter_swig.fir_filter_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.fir_filter_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.fir_filter_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_fff_sptr self, std::string level)"""
        return _filter_swig.fir_filter_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_fff_sptr self) -> int"""
        return _filter_swig.fir_filter_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_fff_sptr self, int m)"""
        return _filter_swig.fir_filter_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_fff_sptr self)"""
        return _filter_swig.fir_filter_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.fir_filter_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_fff_sptr self, int m)"""
        return _filter_swig.fir_filter_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_fff_sptr self) -> int"""
        return _filter_swig.fir_filter_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_fff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_fff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_fff_sptr self) -> float"""
        return _filter_swig.fir_filter_fff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_fff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_fff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_fff_sptr self)"""
        return _filter_swig.fir_filter_fff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_fff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_fff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_fff_sptr self) -> int"""
        return _filter_swig.fir_filter_fff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_fff_sptr self) -> int"""
        return _filter_swig.fir_filter_fff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_fff_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_fff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_fff_sptr self) -> long"""
        return _filter_swig.fir_filter_fff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_fff_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_fff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_fff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_fff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_fff_sptr self, std::string name)"""
        return _filter_swig.fir_filter_fff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_fff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_fff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_fff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fff_sptr_message_subscribers(self, which_port)

# Register fir_filter_fff_sptr in _filter_swig:
_filter_swig.fir_filter_fff_sptr_swigregister(fir_filter_fff_sptr)

fir_filter_fff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_fff = fir_filter_fff.make

class fir_filter_fsf(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< float,short,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps) -> fir_filter_fsf_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fsf_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_fsf self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_fsf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_fsf self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_fsf_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fsf

# Register fir_filter_fsf in _filter_swig:
_filter_swig.fir_filter_fsf_swigregister(fir_filter_fsf)
class fir_filter_fsf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< float,std::int16_t,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_fsf_sptr self) -> fir_filter_fsf_sptr
        __init__(fir_filter_fsf_sptr self, fir_filter_fsf p) -> fir_filter_fsf_sptr
        """
        _filter_swig.fir_filter_fsf_sptr_swiginit(self, _filter_swig.new_fir_filter_fsf_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< float,std::int16_t,float > *":
        r"""__deref__(fir_filter_fsf_sptr self) -> fir_filter_fsf"""
        return _filter_swig.fir_filter_fsf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_fsf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float") -> "gr::filter::fir_filter_blk< float,short,float >::sptr":
        r"""
        make(fir_filter_fsf_sptr self, int decimation, pmt_vector_float taps) -> fir_filter_fsf_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_fsf_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fir_filter_fsf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.fir_filter_fsf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fir_filter_fsf_sptr self) -> pmt_vector_float"""
        return _filter_swig.fir_filter_fsf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_fsf_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_fsf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_fsf_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_fsf_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_fsf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_fsf_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_fsf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_fsf_sptr self, int multiple)"""
        return _filter_swig.fir_filter_fsf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_fsf_sptr self) -> double"""
        return _filter_swig.fir_filter_fsf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_fsf_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fsf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_fsf_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_fsf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.fir_filter_fsf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.fir_filter_fsf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_fsf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_fsf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_fsf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_fsf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_fsf_sptr self, std::string level)"""
        return _filter_swig.fir_filter_fsf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fsf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_fsf_sptr self, int m)"""
        return _filter_swig.fir_filter_fsf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_fsf_sptr self)"""
        return _filter_swig.fir_filter_fsf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.fir_filter_fsf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_fsf_sptr self, int m)"""
        return _filter_swig.fir_filter_fsf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_fsf_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fsf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_fsf_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_fsf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_fsf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_fsf_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_fsf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_fsf_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_fsf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_fsf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_fsf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.fir_filter_fsf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_fsf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_fsf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_fsf_sptr self)"""
        return _filter_swig.fir_filter_fsf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_fsf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_fsf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_fsf_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_fsf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fsf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fsf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_fsf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fsf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_fsf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_fsf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_fsf_sptr self) -> long"""
        return _filter_swig.fir_filter_fsf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_fsf_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_fsf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_fsf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_fsf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.fir_filter_fsf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_fsf_sptr self, std::string name)"""
        return _filter_swig.fir_filter_fsf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_fsf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_fsf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_fsf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fsf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_fsf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fsf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_fsf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_fsf_sptr_message_subscribers(self, which_port)

# Register fir_filter_fsf_sptr in _filter_swig:
_filter_swig.fir_filter_fsf_sptr_swigregister(fir_filter_fsf_sptr)

fir_filter_fsf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_fsf = fir_filter_fsf.make

class fir_filter_scc(object):
    r"""
    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps) -> fir_filter_scc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_scc_make(decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_scc self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_scc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_scc self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_scc_taps(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_scc

# Register fir_filter_scc in _filter_swig:
_filter_swig.fir_filter_scc_swigregister(fir_filter_scc)
class fir_filter_scc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fir_filter_blk< std::int16_t,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fir_filter_scc_sptr self) -> fir_filter_scc_sptr
        __init__(fir_filter_scc_sptr self, fir_filter_scc p) -> fir_filter_scc_sptr
        """
        _filter_swig.fir_filter_scc_sptr_swiginit(self, _filter_swig.new_fir_filter_scc_sptr(*args))

    def __deref__(self) -> "gr::filter::fir_filter_blk< std::int16_t,gr_complex,gr_complex > *":
        r"""__deref__(fir_filter_scc_sptr self) -> fir_filter_scc"""
        return _filter_swig.fir_filter_scc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fir_filter_scc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat") -> "gr::filter::fir_filter_blk< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(fir_filter_scc_sptr self, int decimation, pmt_vector_cfloat taps) -> fir_filter_scc_sptr
        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        The fir_filter_blk_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as down-samplers (or decimators) by specifying an integer value for .

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.fir_filter_scc_sptr_make(self, decimation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fir_filter_scc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.fir_filter_scc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(fir_filter_scc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.fir_filter_scc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(fir_filter_scc_sptr self) -> unsigned int"""
        return _filter_swig.fir_filter_scc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fir_filter_scc_sptr self, int which, int delay)
        declare_sample_delay(fir_filter_scc_sptr self, unsigned int delay)
        """
        return _filter_swig.fir_filter_scc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fir_filter_scc_sptr self, int which) -> unsigned int"""
        return _filter_swig.fir_filter_scc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fir_filter_scc_sptr self, int multiple)"""
        return _filter_swig.fir_filter_scc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fir_filter_scc_sptr self) -> int"""
        return _filter_swig.fir_filter_scc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fir_filter_scc_sptr self) -> double"""
        return _filter_swig.fir_filter_scc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_scc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.fir_filter_scc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.fir_filter_scc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.fir_filter_scc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fir_filter_scc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fir_filter_scc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fir_filter_scc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fir_filter_scc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fir_filter_scc_sptr self, std::string level)"""
        return _filter_swig.fir_filter_scc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_scc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fir_filter_scc_sptr self) -> int"""
        return _filter_swig.fir_filter_scc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fir_filter_scc_sptr self, int m)"""
        return _filter_swig.fir_filter_scc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fir_filter_scc_sptr self)"""
        return _filter_swig.fir_filter_scc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.fir_filter_scc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fir_filter_scc_sptr self, int m)"""
        return _filter_swig.fir_filter_scc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fir_filter_scc_sptr self) -> int"""
        return _filter_swig.fir_filter_scc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_scc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fir_filter_scc_sptr self, long max_output_buffer)
        set_max_output_buffer(fir_filter_scc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fir_filter_scc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.fir_filter_scc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fir_filter_scc_sptr self, long min_output_buffer)
        set_min_output_buffer(fir_filter_scc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fir_filter_scc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_avg(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_var(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_avg(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_var(fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fir_filter_scc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fir_filter_scc_sptr self) -> float"""
        return _filter_swig.fir_filter_scc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fir_filter_scc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fir_filter_scc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fir_filter_scc_sptr self)"""
        return _filter_swig.fir_filter_scc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fir_filter_scc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fir_filter_scc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fir_filter_scc_sptr self) -> int"""
        return _filter_swig.fir_filter_scc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fir_filter_scc_sptr self) -> int"""
        return _filter_swig.fir_filter_scc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fir_filter_scc_sptr self, int priority) -> int"""
        return _filter_swig.fir_filter_scc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_scc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_scc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_scc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fir_filter_scc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fir_filter_scc_sptr self) -> long"""
        return _filter_swig.fir_filter_scc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fir_filter_scc_sptr self) -> basic_block_sptr"""
        return _filter_swig.fir_filter_scc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fir_filter_scc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fir_filter_scc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.fir_filter_scc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fir_filter_scc_sptr self, std::string name)"""
        return _filter_swig.fir_filter_scc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fir_filter_scc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fir_filter_scc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_scc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_scc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fir_filter_scc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fir_filter_scc_sptr_message_subscribers(self, which_port)

# Register fir_filter_scc_sptr in _filter_swig:
_filter_swig.fir_filter_scc_sptr_swigregister(fir_filter_scc_sptr)

fir_filter_scc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fir_filter_scc = fir_filter_scc.make

class fft_filter_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fft_filter_ccc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fft_filter_ccc_sptr self) -> fft_filter_ccc_sptr
        __init__(fft_filter_ccc_sptr self, fft_filter_ccc p) -> fft_filter_ccc_sptr
        """
        _filter_swig.fft_filter_ccc_sptr_swiginit(self, _filter_swig.new_fft_filter_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::fft_filter_ccc *":
        r"""__deref__(fft_filter_ccc_sptr self) -> fft_filter_ccc"""
        return _filter_swig.fft_filter_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_ccc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat", nthreads: "int"=1) -> "gr::filter::fft_filter_ccc::sptr":
        r"""
        make(fft_filter_ccc_sptr self, int decimation, pmt_vector_cfloat taps, int nthreads=1) -> fft_filter_ccc_sptr
        Fast FFT filter with gr_complex input, gr_complex output and gr_complex taps.

        This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter blocks.

        Args:
            decimation : >= 1
            taps : complex filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_ccc_sptr_make(self, decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(fft_filter_ccc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.fft_filter_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(fft_filter_ccc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.fft_filter_ccc_sptr_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_ccc_sptr self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_ccc_sptr_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_ccc_sptr self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_ccc_sptr_nthreads(self)

    def history(self) -> "unsigned int":
        r"""history(fft_filter_ccc_sptr self) -> unsigned int"""
        return _filter_swig.fft_filter_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fft_filter_ccc_sptr self, int which, int delay)
        declare_sample_delay(fft_filter_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.fft_filter_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fft_filter_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.fft_filter_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fft_filter_ccc_sptr self, int multiple)"""
        return _filter_swig.fft_filter_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fft_filter_ccc_sptr self) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fft_filter_ccc_sptr self) -> double"""
        return _filter_swig.fft_filter_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fft_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fft_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fft_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fft_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fft_filter_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fft_filter_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fft_filter_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fft_filter_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fft_filter_ccc_sptr self, std::string level)"""
        return _filter_swig.fft_filter_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fft_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fft_filter_ccc_sptr self) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fft_filter_ccc_sptr self, int m)"""
        return _filter_swig.fft_filter_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fft_filter_ccc_sptr self)"""
        return _filter_swig.fft_filter_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fft_filter_ccc_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fft_filter_ccc_sptr self, int m)"""
        return _filter_swig.fft_filter_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fft_filter_ccc_sptr self) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fft_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fft_filter_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(fft_filter_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fft_filter_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fft_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fft_filter_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(fft_filter_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fft_filter_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fft_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fft_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fft_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fft_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fft_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fft_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(fft_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fft_filter_ccc_sptr self) -> float"""
        return _filter_swig.fft_filter_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fft_filter_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fft_filter_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fft_filter_ccc_sptr self)"""
        return _filter_swig.fft_filter_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fft_filter_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fft_filter_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fft_filter_ccc_sptr self) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fft_filter_ccc_sptr self) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fft_filter_ccc_sptr self, int priority) -> int"""
        return _filter_swig.fft_filter_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fft_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fft_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fft_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fft_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fft_filter_ccc_sptr self) -> long"""
        return _filter_swig.fft_filter_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fft_filter_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.fft_filter_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fft_filter_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fft_filter_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fft_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fft_filter_ccc_sptr self, std::string name)"""
        return _filter_swig.fft_filter_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fft_filter_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fft_filter_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fft_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fft_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fft_filter_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccc_sptr_message_subscribers(self, which_port)

# Register fft_filter_ccc_sptr in _filter_swig:
_filter_swig.fft_filter_ccc_sptr_swigregister(fft_filter_ccc_sptr)

fft_filter_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fft_filter_ccc = fft_filter_ccc.make;

class fft_filter_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fft_filter_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fft_filter_ccf_sptr self) -> fft_filter_ccf_sptr
        __init__(fft_filter_ccf_sptr self, fft_filter_ccf p) -> fft_filter_ccf_sptr
        """
        _filter_swig.fft_filter_ccf_sptr_swiginit(self, _filter_swig.new_fft_filter_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::fft_filter_ccf *":
        r"""__deref__(fft_filter_ccf_sptr self) -> fft_filter_ccf"""
        return _filter_swig.fft_filter_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_ccf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float", nthreads: "int"=1) -> "gr::filter::fft_filter_ccf::sptr":
        r"""
        make(fft_filter_ccf_sptr self, int decimation, pmt_vector_float taps, int nthreads=1) -> fft_filter_ccf_sptr
        Fast FFT filter with gr_complex input, gr_complex output and float taps.

        This block implements a complex decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of complex (or real) taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter blocks.

        Args:
            decimation : >= 1
            taps : complex filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_ccf_sptr_make(self, decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fft_filter_ccf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.fft_filter_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fft_filter_ccf_sptr self) -> pmt_vector_float"""
        return _filter_swig.fft_filter_ccf_sptr_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_ccf_sptr self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_ccf_sptr_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_ccf_sptr self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_ccf_sptr_nthreads(self)

    def history(self) -> "unsigned int":
        r"""history(fft_filter_ccf_sptr self) -> unsigned int"""
        return _filter_swig.fft_filter_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fft_filter_ccf_sptr self, int which, int delay)
        declare_sample_delay(fft_filter_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.fft_filter_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fft_filter_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.fft_filter_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fft_filter_ccf_sptr self, int multiple)"""
        return _filter_swig.fft_filter_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fft_filter_ccf_sptr self) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fft_filter_ccf_sptr self) -> double"""
        return _filter_swig.fft_filter_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fft_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fft_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fft_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fft_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fft_filter_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fft_filter_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fft_filter_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fft_filter_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fft_filter_ccf_sptr self, std::string level)"""
        return _filter_swig.fft_filter_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fft_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fft_filter_ccf_sptr self) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fft_filter_ccf_sptr self, int m)"""
        return _filter_swig.fft_filter_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fft_filter_ccf_sptr self)"""
        return _filter_swig.fft_filter_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fft_filter_ccf_sptr self) -> bool"""
        return _filter_swig.fft_filter_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fft_filter_ccf_sptr self, int m)"""
        return _filter_swig.fft_filter_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fft_filter_ccf_sptr self) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fft_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fft_filter_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(fft_filter_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fft_filter_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fft_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fft_filter_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(fft_filter_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fft_filter_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fft_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fft_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fft_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fft_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fft_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fft_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(fft_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fft_filter_ccf_sptr self) -> float"""
        return _filter_swig.fft_filter_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fft_filter_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fft_filter_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fft_filter_ccf_sptr self)"""
        return _filter_swig.fft_filter_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fft_filter_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fft_filter_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fft_filter_ccf_sptr self) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fft_filter_ccf_sptr self) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fft_filter_ccf_sptr self, int priority) -> int"""
        return _filter_swig.fft_filter_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fft_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fft_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fft_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fft_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fft_filter_ccf_sptr self) -> long"""
        return _filter_swig.fft_filter_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fft_filter_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.fft_filter_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fft_filter_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fft_filter_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fft_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.fft_filter_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fft_filter_ccf_sptr self, std::string name)"""
        return _filter_swig.fft_filter_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fft_filter_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fft_filter_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fft_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fft_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fft_filter_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_ccf_sptr_message_subscribers(self, which_port)

# Register fft_filter_ccf_sptr in _filter_swig:
_filter_swig.fft_filter_ccf_sptr_swigregister(fft_filter_ccf_sptr)

fft_filter_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fft_filter_ccf = fft_filter_ccf.make;

class fft_filter_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::fft_filter_fff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fft_filter_fff_sptr self) -> fft_filter_fff_sptr
        __init__(fft_filter_fff_sptr self, fft_filter_fff p) -> fft_filter_fff_sptr
        """
        _filter_swig.fft_filter_fff_sptr_swiginit(self, _filter_swig.new_fft_filter_fff_sptr(*args))

    def __deref__(self) -> "gr::filter::fft_filter_fff *":
        r"""__deref__(fft_filter_fff_sptr self) -> fft_filter_fff"""
        return _filter_swig.fft_filter_fff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_fft_filter_fff_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float", nthreads: "int"=1) -> "gr::filter::fft_filter_fff::sptr":
        r"""
        make(fft_filter_fff_sptr self, int decimation, pmt_vector_float taps, int nthreads=1) -> fft_filter_fff_sptr
        Fast FFT filter with float input, float output and float taps.

        This block implements a real-value decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


        The filter takes a set of real-valued taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


        This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

        Constructor Specific Documentation:

        Build an FFT filter block.

        Args:
            decimation : >= 1
            taps : float filter taps
            nthreads : number of threads for the FFT to use
        """
        return _filter_swig.fft_filter_fff_sptr_make(self, decimation, taps, nthreads)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(fft_filter_fff_sptr self, pmt_vector_float taps)"""
        return _filter_swig.fft_filter_fff_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(fft_filter_fff_sptr self) -> pmt_vector_float"""
        return _filter_swig.fft_filter_fff_sptr_taps(self)

    def set_nthreads(self, n: "int") -> "void":
        r"""
        set_nthreads(fft_filter_fff_sptr self, int n)
        Set number of threads to use.
        """
        return _filter_swig.fft_filter_fff_sptr_set_nthreads(self, n)

    def nthreads(self) -> "int":
        r"""
        nthreads(fft_filter_fff_sptr self) -> int
        Get number of threads being used.
        """
        return _filter_swig.fft_filter_fff_sptr_nthreads(self)

    def history(self) -> "unsigned int":
        r"""history(fft_filter_fff_sptr self) -> unsigned int"""
        return _filter_swig.fft_filter_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(fft_filter_fff_sptr self, int which, int delay)
        declare_sample_delay(fft_filter_fff_sptr self, unsigned int delay)
        """
        return _filter_swig.fft_filter_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(fft_filter_fff_sptr self, int which) -> unsigned int"""
        return _filter_swig.fft_filter_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(fft_filter_fff_sptr self, int multiple)"""
        return _filter_swig.fft_filter_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(fft_filter_fff_sptr self) -> int"""
        return _filter_swig.fft_filter_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(fft_filter_fff_sptr self) -> double"""
        return _filter_swig.fft_filter_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(fft_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(fft_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.fft_filter_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(fft_filter_fff_sptr self) -> bool"""
        return _filter_swig.fft_filter_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(fft_filter_fff_sptr self) -> bool"""
        return _filter_swig.fft_filter_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(fft_filter_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.fft_filter_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(fft_filter_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.fft_filter_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(fft_filter_fff_sptr self, std::string level)"""
        return _filter_swig.fft_filter_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(fft_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fft_filter_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(fft_filter_fff_sptr self) -> int"""
        return _filter_swig.fft_filter_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(fft_filter_fff_sptr self, int m)"""
        return _filter_swig.fft_filter_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(fft_filter_fff_sptr self)"""
        return _filter_swig.fft_filter_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(fft_filter_fff_sptr self) -> bool"""
        return _filter_swig.fft_filter_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(fft_filter_fff_sptr self, int m)"""
        return _filter_swig.fft_filter_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(fft_filter_fff_sptr self) -> int"""
        return _filter_swig.fft_filter_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(fft_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(fft_filter_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(fft_filter_fff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.fft_filter_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(fft_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.fft_filter_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(fft_filter_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(fft_filter_fff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.fft_filter_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(fft_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(fft_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(fft_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(fft_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(fft_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(fft_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(fft_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.fft_filter_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(fft_filter_fff_sptr self) -> float"""
        return _filter_swig.fft_filter_fff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(fft_filter_fff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.fft_filter_fff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(fft_filter_fff_sptr self)"""
        return _filter_swig.fft_filter_fff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(fft_filter_fff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.fft_filter_fff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(fft_filter_fff_sptr self) -> int"""
        return _filter_swig.fft_filter_fff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(fft_filter_fff_sptr self) -> int"""
        return _filter_swig.fft_filter_fff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(fft_filter_fff_sptr self, int priority) -> int"""
        return _filter_swig.fft_filter_fff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(fft_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fft_filter_fff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(fft_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fft_filter_fff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(fft_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_fff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(fft_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.fft_filter_fff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(fft_filter_fff_sptr self) -> long"""
        return _filter_swig.fft_filter_fff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(fft_filter_fff_sptr self) -> basic_block_sptr"""
        return _filter_swig.fft_filter_fff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(fft_filter_fff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.fft_filter_fff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(fft_filter_fff_sptr self) -> std::string"""
        return _filter_swig.fft_filter_fff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(fft_filter_fff_sptr self, std::string name)"""
        return _filter_swig.fft_filter_fff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(fft_filter_fff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.fft_filter_fff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(fft_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_fff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(fft_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_fff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(fft_filter_fff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.fft_filter_fff_sptr_message_subscribers(self, which_port)

# Register fft_filter_fff_sptr in _filter_swig:
_filter_swig.fft_filter_fff_sptr_swigregister(fft_filter_fff_sptr)

fft_filter_fff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
fft_filter_fff = fft_filter_fff.make;

class mmse_interpolator_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::mmse_interpolator_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(mmse_interpolator_cc_sptr self) -> mmse_interpolator_cc_sptr
        __init__(mmse_interpolator_cc_sptr self, mmse_interpolator_cc p) -> mmse_interpolator_cc_sptr
        """
        _filter_swig.mmse_interpolator_cc_sptr_swiginit(self, _filter_swig.new_mmse_interpolator_cc_sptr(*args))

    def __deref__(self) -> "gr::filter::mmse_interpolator_cc *":
        r"""__deref__(mmse_interpolator_cc_sptr self) -> mmse_interpolator_cc"""
        return _filter_swig.mmse_interpolator_cc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_mmse_interpolator_cc_sptr

    def make(self, phase_shift: "float", interp_ratio: "float") -> "gr::filter::mmse_interpolator_cc::sptr":
        r"""
        make(mmse_interpolator_cc_sptr self, float phase_shift, float interp_ratio) -> mmse_interpolator_cc_sptr
        Interpolating MMSE filter with complex input, complex output.

        Constructor Specific Documentation:

        Build the interpolating MMSE filter (complex input, complex output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            interp_ratio : The interpolation ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_interpolator_cc_sptr_make(self, phase_shift, interp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_mu(self)

    def interp_ratio(self) -> "float":
        r"""interp_ratio(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_interp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_interpolator_cc_sptr self, float mu)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_mu(self, mu)

    def set_interp_ratio(self, interp_ratio: "float") -> "void":
        r"""set_interp_ratio(mmse_interpolator_cc_sptr self, float interp_ratio)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_interp_ratio(self, interp_ratio)

    def history(self) -> "unsigned int":
        r"""history(mmse_interpolator_cc_sptr self) -> unsigned int"""
        return _filter_swig.mmse_interpolator_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(mmse_interpolator_cc_sptr self, int which, int delay)
        declare_sample_delay(mmse_interpolator_cc_sptr self, unsigned int delay)
        """
        return _filter_swig.mmse_interpolator_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(mmse_interpolator_cc_sptr self, int which) -> unsigned int"""
        return _filter_swig.mmse_interpolator_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(mmse_interpolator_cc_sptr self, int multiple)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(mmse_interpolator_cc_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(mmse_interpolator_cc_sptr self) -> double"""
        return _filter_swig.mmse_interpolator_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(mmse_interpolator_cc_sptr self) -> uint64_t"""
        return _filter_swig.mmse_interpolator_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(mmse_interpolator_cc_sptr self) -> uint64_t"""
        return _filter_swig.mmse_interpolator_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(mmse_interpolator_cc_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(mmse_interpolator_cc_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(mmse_interpolator_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.mmse_interpolator_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(mmse_interpolator_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.mmse_interpolator_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(mmse_interpolator_cc_sptr self, std::string level)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(mmse_interpolator_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(mmse_interpolator_cc_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(mmse_interpolator_cc_sptr self, int m)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(mmse_interpolator_cc_sptr self)"""
        return _filter_swig.mmse_interpolator_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(mmse_interpolator_cc_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(mmse_interpolator_cc_sptr self, int m)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(mmse_interpolator_cc_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(mmse_interpolator_cc_sptr self, int i) -> long"""
        return _filter_swig.mmse_interpolator_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(mmse_interpolator_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(mmse_interpolator_cc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.mmse_interpolator_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(mmse_interpolator_cc_sptr self, int i) -> long"""
        return _filter_swig.mmse_interpolator_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(mmse_interpolator_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(mmse_interpolator_cc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.mmse_interpolator_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(mmse_interpolator_cc_sptr self, int which) -> float
        pc_input_buffers_full(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(mmse_interpolator_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(mmse_interpolator_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(mmse_interpolator_cc_sptr self, int which) -> float
        pc_output_buffers_full(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(mmse_interpolator_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(mmse_interpolator_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(mmse_interpolator_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(mmse_interpolator_cc_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(mmse_interpolator_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(mmse_interpolator_cc_sptr self)"""
        return _filter_swig.mmse_interpolator_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(mmse_interpolator_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.mmse_interpolator_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(mmse_interpolator_cc_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(mmse_interpolator_cc_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(mmse_interpolator_cc_sptr self, int priority) -> int"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(mmse_interpolator_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(mmse_interpolator_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(mmse_interpolator_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(mmse_interpolator_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(mmse_interpolator_cc_sptr self) -> long"""
        return _filter_swig.mmse_interpolator_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(mmse_interpolator_cc_sptr self) -> basic_block_sptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(mmse_interpolator_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.mmse_interpolator_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(mmse_interpolator_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(mmse_interpolator_cc_sptr self, std::string name)"""
        return _filter_swig.mmse_interpolator_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(mmse_interpolator_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.mmse_interpolator_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(mmse_interpolator_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(mmse_interpolator_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(mmse_interpolator_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_cc_sptr_message_subscribers(self, which_port)

# Register mmse_interpolator_cc_sptr in _filter_swig:
_filter_swig.mmse_interpolator_cc_sptr_swigregister(mmse_interpolator_cc_sptr)

mmse_interpolator_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
mmse_interpolator_cc = mmse_interpolator_cc.make;

class mmse_interpolator_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::mmse_interpolator_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(mmse_interpolator_ff_sptr self) -> mmse_interpolator_ff_sptr
        __init__(mmse_interpolator_ff_sptr self, mmse_interpolator_ff p) -> mmse_interpolator_ff_sptr
        """
        _filter_swig.mmse_interpolator_ff_sptr_swiginit(self, _filter_swig.new_mmse_interpolator_ff_sptr(*args))

    def __deref__(self) -> "gr::filter::mmse_interpolator_ff *":
        r"""__deref__(mmse_interpolator_ff_sptr self) -> mmse_interpolator_ff"""
        return _filter_swig.mmse_interpolator_ff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_mmse_interpolator_ff_sptr

    def make(self, phase_shift: "float", interp_ratio: "float") -> "gr::filter::mmse_interpolator_ff::sptr":
        r"""
        make(mmse_interpolator_ff_sptr self, float phase_shift, float interp_ratio) -> mmse_interpolator_ff_sptr
        Interpolating MMSE filter with float input, float output.

        Constructor Specific Documentation:

        Build the interpolating MMSE filter (float input, float output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            interp_ratio : The interpolation ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_interpolator_ff_sptr_make(self, phase_shift, interp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_mu(self)

    def interp_ratio(self) -> "float":
        r"""interp_ratio(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_interp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_interpolator_ff_sptr self, float mu)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_mu(self, mu)

    def set_interp_ratio(self, interp_ratio: "float") -> "void":
        r"""set_interp_ratio(mmse_interpolator_ff_sptr self, float interp_ratio)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_interp_ratio(self, interp_ratio)

    def history(self) -> "unsigned int":
        r"""history(mmse_interpolator_ff_sptr self) -> unsigned int"""
        return _filter_swig.mmse_interpolator_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(mmse_interpolator_ff_sptr self, int which, int delay)
        declare_sample_delay(mmse_interpolator_ff_sptr self, unsigned int delay)
        """
        return _filter_swig.mmse_interpolator_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(mmse_interpolator_ff_sptr self, int which) -> unsigned int"""
        return _filter_swig.mmse_interpolator_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(mmse_interpolator_ff_sptr self, int multiple)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(mmse_interpolator_ff_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(mmse_interpolator_ff_sptr self) -> double"""
        return _filter_swig.mmse_interpolator_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(mmse_interpolator_ff_sptr self) -> uint64_t"""
        return _filter_swig.mmse_interpolator_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(mmse_interpolator_ff_sptr self) -> uint64_t"""
        return _filter_swig.mmse_interpolator_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(mmse_interpolator_ff_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(mmse_interpolator_ff_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(mmse_interpolator_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.mmse_interpolator_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(mmse_interpolator_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.mmse_interpolator_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(mmse_interpolator_ff_sptr self, std::string level)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(mmse_interpolator_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(mmse_interpolator_ff_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(mmse_interpolator_ff_sptr self, int m)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(mmse_interpolator_ff_sptr self)"""
        return _filter_swig.mmse_interpolator_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(mmse_interpolator_ff_sptr self) -> bool"""
        return _filter_swig.mmse_interpolator_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(mmse_interpolator_ff_sptr self, int m)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(mmse_interpolator_ff_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(mmse_interpolator_ff_sptr self, int i) -> long"""
        return _filter_swig.mmse_interpolator_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(mmse_interpolator_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(mmse_interpolator_ff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.mmse_interpolator_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(mmse_interpolator_ff_sptr self, int i) -> long"""
        return _filter_swig.mmse_interpolator_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(mmse_interpolator_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(mmse_interpolator_ff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.mmse_interpolator_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(mmse_interpolator_ff_sptr self, int which) -> float
        pc_input_buffers_full(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(mmse_interpolator_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(mmse_interpolator_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(mmse_interpolator_ff_sptr self, int which) -> float
        pc_output_buffers_full(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(mmse_interpolator_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(mmse_interpolator_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(mmse_interpolator_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_interpolator_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(mmse_interpolator_ff_sptr self) -> float"""
        return _filter_swig.mmse_interpolator_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(mmse_interpolator_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(mmse_interpolator_ff_sptr self)"""
        return _filter_swig.mmse_interpolator_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(mmse_interpolator_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.mmse_interpolator_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(mmse_interpolator_ff_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(mmse_interpolator_ff_sptr self) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(mmse_interpolator_ff_sptr self, int priority) -> int"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(mmse_interpolator_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(mmse_interpolator_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(mmse_interpolator_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(mmse_interpolator_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(mmse_interpolator_ff_sptr self) -> long"""
        return _filter_swig.mmse_interpolator_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(mmse_interpolator_ff_sptr self) -> basic_block_sptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(mmse_interpolator_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.mmse_interpolator_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(mmse_interpolator_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_interpolator_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(mmse_interpolator_ff_sptr self, std::string name)"""
        return _filter_swig.mmse_interpolator_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(mmse_interpolator_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.mmse_interpolator_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(mmse_interpolator_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(mmse_interpolator_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(mmse_interpolator_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.mmse_interpolator_ff_sptr_message_subscribers(self, which_port)

# Register mmse_interpolator_ff_sptr in _filter_swig:
_filter_swig.mmse_interpolator_ff_sptr_swigregister(mmse_interpolator_ff_sptr)

mmse_interpolator_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
mmse_interpolator_ff = mmse_interpolator_ff.make;

class mmse_resampler_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::mmse_resampler_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(mmse_resampler_cc_sptr self) -> mmse_resampler_cc_sptr
        __init__(mmse_resampler_cc_sptr self, mmse_resampler_cc p) -> mmse_resampler_cc_sptr
        """
        _filter_swig.mmse_resampler_cc_sptr_swiginit(self, _filter_swig.new_mmse_resampler_cc_sptr(*args))

    def __deref__(self) -> "gr::filter::mmse_resampler_cc *":
        r"""__deref__(mmse_resampler_cc_sptr self) -> mmse_resampler_cc"""
        return _filter_swig.mmse_resampler_cc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_mmse_resampler_cc_sptr

    def make(self, phase_shift: "float", resamp_ratio: "float") -> "gr::filter::mmse_resampler_cc::sptr":
        r"""
        make(mmse_resampler_cc_sptr self, float phase_shift, float resamp_ratio) -> mmse_resampler_cc_sptr
        resampling MMSE filter with complex input, complex output

        The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

        Constructor Specific Documentation:

        Build the resampling MMSE filter (complex input, complex output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            resamp_ratio : The resampling ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_resampler_cc_sptr_make(self, phase_shift, resamp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_mu(self)

    def resamp_ratio(self) -> "float":
        r"""resamp_ratio(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_resamp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_resampler_cc_sptr self, float mu)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_mu(self, mu)

    def set_resamp_ratio(self, resamp_ratio: "float") -> "void":
        r"""set_resamp_ratio(mmse_resampler_cc_sptr self, float resamp_ratio)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_resamp_ratio(self, resamp_ratio)

    def history(self) -> "unsigned int":
        r"""history(mmse_resampler_cc_sptr self) -> unsigned int"""
        return _filter_swig.mmse_resampler_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(mmse_resampler_cc_sptr self, int which, int delay)
        declare_sample_delay(mmse_resampler_cc_sptr self, unsigned int delay)
        """
        return _filter_swig.mmse_resampler_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(mmse_resampler_cc_sptr self, int which) -> unsigned int"""
        return _filter_swig.mmse_resampler_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(mmse_resampler_cc_sptr self, int multiple)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(mmse_resampler_cc_sptr self) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(mmse_resampler_cc_sptr self) -> double"""
        return _filter_swig.mmse_resampler_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(mmse_resampler_cc_sptr self) -> uint64_t"""
        return _filter_swig.mmse_resampler_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(mmse_resampler_cc_sptr self) -> uint64_t"""
        return _filter_swig.mmse_resampler_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(mmse_resampler_cc_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(mmse_resampler_cc_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(mmse_resampler_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.mmse_resampler_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(mmse_resampler_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.mmse_resampler_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(mmse_resampler_cc_sptr self, std::string level)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(mmse_resampler_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(mmse_resampler_cc_sptr self) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(mmse_resampler_cc_sptr self, int m)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(mmse_resampler_cc_sptr self)"""
        return _filter_swig.mmse_resampler_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(mmse_resampler_cc_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(mmse_resampler_cc_sptr self, int m)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(mmse_resampler_cc_sptr self) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(mmse_resampler_cc_sptr self, int i) -> long"""
        return _filter_swig.mmse_resampler_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(mmse_resampler_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(mmse_resampler_cc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.mmse_resampler_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(mmse_resampler_cc_sptr self, int i) -> long"""
        return _filter_swig.mmse_resampler_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(mmse_resampler_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(mmse_resampler_cc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.mmse_resampler_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(mmse_resampler_cc_sptr self, int which) -> float
        pc_input_buffers_full(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(mmse_resampler_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(mmse_resampler_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(mmse_resampler_cc_sptr self, int which) -> float
        pc_output_buffers_full(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(mmse_resampler_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(mmse_resampler_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(mmse_resampler_cc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(mmse_resampler_cc_sptr self) -> float"""
        return _filter_swig.mmse_resampler_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(mmse_resampler_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(mmse_resampler_cc_sptr self)"""
        return _filter_swig.mmse_resampler_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(mmse_resampler_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.mmse_resampler_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(mmse_resampler_cc_sptr self) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(mmse_resampler_cc_sptr self) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(mmse_resampler_cc_sptr self, int priority) -> int"""
        return _filter_swig.mmse_resampler_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(mmse_resampler_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(mmse_resampler_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(mmse_resampler_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_resampler_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(mmse_resampler_cc_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_resampler_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(mmse_resampler_cc_sptr self) -> long"""
        return _filter_swig.mmse_resampler_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(mmse_resampler_cc_sptr self) -> basic_block_sptr"""
        return _filter_swig.mmse_resampler_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(mmse_resampler_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.mmse_resampler_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(mmse_resampler_cc_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(mmse_resampler_cc_sptr self, std::string name)"""
        return _filter_swig.mmse_resampler_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(mmse_resampler_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.mmse_resampler_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(mmse_resampler_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(mmse_resampler_cc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(mmse_resampler_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_cc_sptr_message_subscribers(self, which_port)

# Register mmse_resampler_cc_sptr in _filter_swig:
_filter_swig.mmse_resampler_cc_sptr_swigregister(mmse_resampler_cc_sptr)

mmse_resampler_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
mmse_resampler_cc = mmse_resampler_cc.make;

class mmse_resampler_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::mmse_resampler_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(mmse_resampler_ff_sptr self) -> mmse_resampler_ff_sptr
        __init__(mmse_resampler_ff_sptr self, mmse_resampler_ff p) -> mmse_resampler_ff_sptr
        """
        _filter_swig.mmse_resampler_ff_sptr_swiginit(self, _filter_swig.new_mmse_resampler_ff_sptr(*args))

    def __deref__(self) -> "gr::filter::mmse_resampler_ff *":
        r"""__deref__(mmse_resampler_ff_sptr self) -> mmse_resampler_ff"""
        return _filter_swig.mmse_resampler_ff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_mmse_resampler_ff_sptr

    def make(self, phase_shift: "float", resamp_ratio: "float") -> "gr::filter::mmse_resampler_ff::sptr":
        r"""
        make(mmse_resampler_ff_sptr self, float phase_shift, float resamp_ratio) -> mmse_resampler_ff_sptr
        Resampling MMSE filter with float input, float output.

        The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings "resamp_ratio" and "mu" and values are pmt floats.

        Constructor Specific Documentation:

        Build the resampling MMSE filter (float input, float output)

        Args:
            phase_shift : The phase shift of the output signal to the input
            resamp_ratio : The resampling ratio = input_rate / output_rate.
        """
        return _filter_swig.mmse_resampler_ff_sptr_make(self, phase_shift, resamp_ratio)

    def mu(self) -> "float":
        r"""mu(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_mu(self)

    def resamp_ratio(self) -> "float":
        r"""resamp_ratio(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_resamp_ratio(self)

    def set_mu(self, mu: "float") -> "void":
        r"""set_mu(mmse_resampler_ff_sptr self, float mu)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_mu(self, mu)

    def set_resamp_ratio(self, resamp_ratio: "float") -> "void":
        r"""set_resamp_ratio(mmse_resampler_ff_sptr self, float resamp_ratio)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_resamp_ratio(self, resamp_ratio)

    def history(self) -> "unsigned int":
        r"""history(mmse_resampler_ff_sptr self) -> unsigned int"""
        return _filter_swig.mmse_resampler_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(mmse_resampler_ff_sptr self, int which, int delay)
        declare_sample_delay(mmse_resampler_ff_sptr self, unsigned int delay)
        """
        return _filter_swig.mmse_resampler_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(mmse_resampler_ff_sptr self, int which) -> unsigned int"""
        return _filter_swig.mmse_resampler_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(mmse_resampler_ff_sptr self, int multiple)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(mmse_resampler_ff_sptr self) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(mmse_resampler_ff_sptr self) -> double"""
        return _filter_swig.mmse_resampler_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(mmse_resampler_ff_sptr self) -> uint64_t"""
        return _filter_swig.mmse_resampler_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(mmse_resampler_ff_sptr self) -> uint64_t"""
        return _filter_swig.mmse_resampler_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(mmse_resampler_ff_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(mmse_resampler_ff_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(mmse_resampler_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.mmse_resampler_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(mmse_resampler_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.mmse_resampler_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(mmse_resampler_ff_sptr self, std::string level)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(mmse_resampler_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(mmse_resampler_ff_sptr self) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(mmse_resampler_ff_sptr self, int m)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(mmse_resampler_ff_sptr self)"""
        return _filter_swig.mmse_resampler_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(mmse_resampler_ff_sptr self) -> bool"""
        return _filter_swig.mmse_resampler_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(mmse_resampler_ff_sptr self, int m)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(mmse_resampler_ff_sptr self) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(mmse_resampler_ff_sptr self, int i) -> long"""
        return _filter_swig.mmse_resampler_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(mmse_resampler_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(mmse_resampler_ff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.mmse_resampler_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(mmse_resampler_ff_sptr self, int i) -> long"""
        return _filter_swig.mmse_resampler_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(mmse_resampler_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(mmse_resampler_ff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.mmse_resampler_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(mmse_resampler_ff_sptr self, int which) -> float
        pc_input_buffers_full(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(mmse_resampler_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(mmse_resampler_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(mmse_resampler_ff_sptr self, int which) -> float
        pc_output_buffers_full(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(mmse_resampler_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(mmse_resampler_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(mmse_resampler_ff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.mmse_resampler_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(mmse_resampler_ff_sptr self) -> float"""
        return _filter_swig.mmse_resampler_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(mmse_resampler_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(mmse_resampler_ff_sptr self)"""
        return _filter_swig.mmse_resampler_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(mmse_resampler_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.mmse_resampler_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(mmse_resampler_ff_sptr self) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(mmse_resampler_ff_sptr self) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(mmse_resampler_ff_sptr self, int priority) -> int"""
        return _filter_swig.mmse_resampler_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(mmse_resampler_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(mmse_resampler_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(mmse_resampler_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_resampler_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(mmse_resampler_ff_sptr self) -> io_signature_sptr"""
        return _filter_swig.mmse_resampler_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(mmse_resampler_ff_sptr self) -> long"""
        return _filter_swig.mmse_resampler_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(mmse_resampler_ff_sptr self) -> basic_block_sptr"""
        return _filter_swig.mmse_resampler_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(mmse_resampler_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.mmse_resampler_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(mmse_resampler_ff_sptr self) -> std::string"""
        return _filter_swig.mmse_resampler_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(mmse_resampler_ff_sptr self, std::string name)"""
        return _filter_swig.mmse_resampler_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(mmse_resampler_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.mmse_resampler_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(mmse_resampler_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(mmse_resampler_ff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(mmse_resampler_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.mmse_resampler_ff_sptr_message_subscribers(self, which_port)

# Register mmse_resampler_ff_sptr in _filter_swig:
_filter_swig.mmse_resampler_ff_sptr_swigregister(mmse_resampler_ff_sptr)

mmse_resampler_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
mmse_resampler_ff = mmse_resampler_ff.make;

class freq_xlating_fir_filter_ccc(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_ccc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_ccc self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_ccc self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccc_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_ccc self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_ccc self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_ccc_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_ccc

# Register freq_xlating_fir_filter_ccc in _filter_swig:
_filter_swig.freq_xlating_fir_filter_ccc_swigregister(freq_xlating_fir_filter_ccc)
class freq_xlating_fir_filter_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< gr_complex,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_ccc_sptr self) -> freq_xlating_fir_filter_ccc_sptr
        __init__(freq_xlating_fir_filter_ccc_sptr self, freq_xlating_fir_filter_ccc p) -> freq_xlating_fir_filter_ccc_sptr
        """
        _filter_swig.freq_xlating_fir_filter_ccc_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< gr_complex,gr_complex,gr_complex > *":
        r"""__deref__(freq_xlating_fir_filter_ccc_sptr self) -> freq_xlating_fir_filter_ccc"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_ccc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(freq_xlating_fir_filter_ccc_sptr self, int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_ccc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_ccc_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_ccc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_ccc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_ccc_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_ccc_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_ccc_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_ccc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_ccc_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_ccc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_ccc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_ccc_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_ccc_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_ccc_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccc_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_ccc_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_ccc_sptr_swigregister(freq_xlating_fir_filter_ccc_sptr)

freq_xlating_fir_filter_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_ccc = freq_xlating_fir_filter_ccc.make

class freq_xlating_fir_filter_ccf(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_ccf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_ccf self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_ccf self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccf_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_ccf self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_ccf self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_ccf

# Register freq_xlating_fir_filter_ccf in _filter_swig:
_filter_swig.freq_xlating_fir_filter_ccf_swigregister(freq_xlating_fir_filter_ccf)
class freq_xlating_fir_filter_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< gr_complex,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_ccf_sptr self) -> freq_xlating_fir_filter_ccf_sptr
        __init__(freq_xlating_fir_filter_ccf_sptr self, freq_xlating_fir_filter_ccf p) -> freq_xlating_fir_filter_ccf_sptr
        """
        _filter_swig.freq_xlating_fir_filter_ccf_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< gr_complex,gr_complex,float > *":
        r"""__deref__(freq_xlating_fir_filter_ccf_sptr self) -> freq_xlating_fir_filter_ccf"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_ccf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(freq_xlating_fir_filter_ccf_sptr self, int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_ccf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_ccf_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_ccf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_ccf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_ccf_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_ccf_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_ccf_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_ccf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_ccf_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_ccf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_ccf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_ccf_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_ccf_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_ccf_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_ccf_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_ccf_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_ccf_sptr_swigregister(freq_xlating_fir_filter_ccf_sptr)

freq_xlating_fir_filter_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_ccf = freq_xlating_fir_filter_ccf.make

class freq_xlating_fir_filter_fcc(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_fcc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_fcc self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_fcc self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcc_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_fcc self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_fcc self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_fcc_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_fcc

# Register freq_xlating_fir_filter_fcc in _filter_swig:
_filter_swig.freq_xlating_fir_filter_fcc_swigregister(freq_xlating_fir_filter_fcc)
class freq_xlating_fir_filter_fcc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< float,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_fcc_sptr self) -> freq_xlating_fir_filter_fcc_sptr
        __init__(freq_xlating_fir_filter_fcc_sptr self, freq_xlating_fir_filter_fcc p) -> freq_xlating_fir_filter_fcc_sptr
        """
        _filter_swig.freq_xlating_fir_filter_fcc_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_fcc_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< float,gr_complex,gr_complex > *":
        r"""__deref__(freq_xlating_fir_filter_fcc_sptr self) -> freq_xlating_fir_filter_fcc"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_fcc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(freq_xlating_fir_filter_fcc_sptr self, int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_fcc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_fcc_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_fcc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_fcc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_fcc_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_fcc_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_fcc_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_fcc_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_fcc_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_fcc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_fcc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_fcc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_fcc_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_fcc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_fcc_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_fcc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_fcc_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_fcc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_fcc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_fcc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_fcc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_fcc_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_fcc_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_fcc_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_fcc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_fcc_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_fcc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_fcc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcc_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_fcc_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_fcc_sptr_swigregister(freq_xlating_fir_filter_fcc_sptr)

freq_xlating_fir_filter_fcc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_fcc = freq_xlating_fir_filter_fcc.make

class freq_xlating_fir_filter_fcf(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< float,std::complex< float >,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_fcf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_fcf self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_fcf self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcf_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_fcf self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_fcf self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_fcf

# Register freq_xlating_fir_filter_fcf in _filter_swig:
_filter_swig.freq_xlating_fir_filter_fcf_swigregister(freq_xlating_fir_filter_fcf)
class freq_xlating_fir_filter_fcf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< float,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_fcf_sptr self) -> freq_xlating_fir_filter_fcf_sptr
        __init__(freq_xlating_fir_filter_fcf_sptr self, freq_xlating_fir_filter_fcf p) -> freq_xlating_fir_filter_fcf_sptr
        """
        _filter_swig.freq_xlating_fir_filter_fcf_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_fcf_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< float,gr_complex,float > *":
        r"""__deref__(freq_xlating_fir_filter_fcf_sptr self) -> freq_xlating_fir_filter_fcf"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_fcf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< float,std::complex< float >,float >::sptr":
        r"""
        make(freq_xlating_fir_filter_fcf_sptr self, int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_fcf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_fcf_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_fcf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_fcf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_fcf_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_fcf_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_fcf_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_fcf_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_fcf_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_fcf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_fcf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_fcf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_fcf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_fcf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_fcf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_fcf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_fcf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_fcf_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_fcf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_fcf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_fcf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_fcf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_fcf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_fcf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_fcf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_fcf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_fcf_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_fcf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_fcf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_fcf_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_fcf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_fcf_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_fcf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_fcf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_fcf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_fcf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_fcf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_fcf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_fcf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_fcf_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_fcf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_fcf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_fcf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_fcf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_fcf_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_fcf_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_fcf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_fcf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_fcf_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_fcf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_fcf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_fcf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_fcf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_fcf_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_fcf_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_fcf_sptr_swigregister(freq_xlating_fir_filter_fcf_sptr)

freq_xlating_fir_filter_fcf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_fcf = freq_xlating_fir_filter_fcf.make

class freq_xlating_fir_filter_scf(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< short,std::complex< float >,float >::sptr":
        r"""
        make(int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_scf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_scf_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_scf self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_scf_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_scf self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scf_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_scf self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_scf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_scf self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_scf_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_scf

# Register freq_xlating_fir_filter_scf in _filter_swig:
_filter_swig.freq_xlating_fir_filter_scf_swigregister(freq_xlating_fir_filter_scf)
class freq_xlating_fir_filter_scf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< std::int16_t,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_scf_sptr self) -> freq_xlating_fir_filter_scf_sptr
        __init__(freq_xlating_fir_filter_scf_sptr self, freq_xlating_fir_filter_scf p) -> freq_xlating_fir_filter_scf_sptr
        """
        _filter_swig.freq_xlating_fir_filter_scf_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_scf_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< std::int16_t,gr_complex,float > *":
        r"""__deref__(freq_xlating_fir_filter_scf_sptr self) -> freq_xlating_fir_filter_scf"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_scf_sptr

    def make(self, decimation: "int", taps: "pmt_vector_float", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< short,std::complex< float >,float >::sptr":
        r"""
        make(freq_xlating_fir_filter_scf_sptr self, int decimation, pmt_vector_float taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_scf_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_scf_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_scf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(freq_xlating_fir_filter_scf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_scf_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_scf_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_scf_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_scf_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_scf_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_scf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_scf_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_scf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_scf_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_scf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_scf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_scf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_scf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_scf_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_scf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_scf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_scf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_scf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_scf_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_scf_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_scf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_scf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_scf_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_scf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_scf_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_scf_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_scf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_scf_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_scf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_scf_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_scf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_scf_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_scf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_scf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_scf_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_scf_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_scf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_scf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_scf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_scf_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_scf_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_scf_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_scf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_scf_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_scf_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_scf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_scf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_scf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_scf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scf_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_scf_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_scf_sptr_swigregister(freq_xlating_fir_filter_scf_sptr)

freq_xlating_fir_filter_scf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_scf = freq_xlating_fir_filter_scf.make

class freq_xlating_fir_filter_scc(object):
    r"""
    FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

    This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
    selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


    Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

    Constructor Specific Documentation:

    FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

    Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

    Args:
        decimation : set the integer decimation rate
        taps : a vector/list of taps of type TAP_T
        center_freq : Center frequency of signal to down convert from (Hz)
        sampling_freq : Sampling rate of signal (in Hz)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_scc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_scc_make(decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_scc self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_scc_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_scc self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scc_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_scc self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_scc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_scc self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_scc_taps(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_scc

# Register freq_xlating_fir_filter_scc in _filter_swig:
_filter_swig.freq_xlating_fir_filter_scc_swigregister(freq_xlating_fir_filter_scc)
class freq_xlating_fir_filter_scc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::freq_xlating_fir_filter< std::int16_t,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(freq_xlating_fir_filter_scc_sptr self) -> freq_xlating_fir_filter_scc_sptr
        __init__(freq_xlating_fir_filter_scc_sptr self, freq_xlating_fir_filter_scc p) -> freq_xlating_fir_filter_scc_sptr
        """
        _filter_swig.freq_xlating_fir_filter_scc_sptr_swiginit(self, _filter_swig.new_freq_xlating_fir_filter_scc_sptr(*args))

    def __deref__(self) -> "gr::filter::freq_xlating_fir_filter< std::int16_t,gr_complex,gr_complex > *":
        r"""__deref__(freq_xlating_fir_filter_scc_sptr self) -> freq_xlating_fir_filter_scc"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_freq_xlating_fir_filter_scc_sptr

    def make(self, decimation: "int", taps: "pmt_vector_cfloat", center_freq: "double", sampling_freq: "double") -> "gr::filter::freq_xlating_fir_filter< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(freq_xlating_fir_filter_scc_sptr self, int decimation, pmt_vector_cfloat taps, double center_freq, double sampling_freq) -> freq_xlating_fir_filter_scc_sptr
        FIR filter combined with frequency translation with IN_T input, OUT_T output and TAP_T taps.

        This class efficiently combines a frequency translation (typically "down conversion") with a FIR filter (typically low-pass) and decimation. It is ideally suited for a "channel
        selection filter" and can be efficiently used to select and decimate a narrow band signal out of wide bandwidth input.


        Uses a single input array to produce a single output array. Additional inputs and/or outputs are ignored.

        Constructor Specific Documentation:

        FIR filter with IN_T input, OUT_T output, and TAP_T taps that also frequency translates a signal from .

        Construct a FIR filter with the given taps and a composite frequency translation that shifts center_freq down to zero Hz. The frequency translation logically comes before the filtering operation.

        Args:
            decimation : set the integer decimation rate
            taps : a vector/list of taps of type TAP_T
            center_freq : Center frequency of signal to down convert from (Hz)
            sampling_freq : Sampling rate of signal (in Hz)
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_make(self, decimation, taps, center_freq, sampling_freq)

    def set_center_freq(self, center_freq: "double") -> "void":
        r"""set_center_freq(freq_xlating_fir_filter_scc_sptr self, double center_freq)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_center_freq(self, center_freq)

    def center_freq(self) -> "double":
        r"""center_freq(freq_xlating_fir_filter_scc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_center_freq(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(freq_xlating_fir_filter_scc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(freq_xlating_fir_filter_scc_sptr self) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(freq_xlating_fir_filter_scc_sptr self, int which, int delay)
        declare_sample_delay(freq_xlating_fir_filter_scc_sptr self, unsigned int delay)
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(freq_xlating_fir_filter_scc_sptr self, int which) -> unsigned int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(freq_xlating_fir_filter_scc_sptr self, int multiple)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(freq_xlating_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(freq_xlating_fir_filter_scc_sptr self) -> double"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(freq_xlating_fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(freq_xlating_fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(freq_xlating_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(freq_xlating_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(freq_xlating_fir_filter_scc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(freq_xlating_fir_filter_scc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(freq_xlating_fir_filter_scc_sptr self, std::string level)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(freq_xlating_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(freq_xlating_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(freq_xlating_fir_filter_scc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(freq_xlating_fir_filter_scc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(freq_xlating_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(freq_xlating_fir_filter_scc_sptr self, int m)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(freq_xlating_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(freq_xlating_fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(freq_xlating_fir_filter_scc_sptr self, long max_output_buffer)
        set_max_output_buffer(freq_xlating_fir_filter_scc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(freq_xlating_fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(freq_xlating_fir_filter_scc_sptr self, long min_output_buffer)
        set_min_output_buffer(freq_xlating_fir_filter_scc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_avg(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_var(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_avg(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(freq_xlating_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_var(freq_xlating_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(freq_xlating_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(freq_xlating_fir_filter_scc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(freq_xlating_fir_filter_scc_sptr self)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(freq_xlating_fir_filter_scc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(freq_xlating_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(freq_xlating_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(freq_xlating_fir_filter_scc_sptr self, int priority) -> int"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(freq_xlating_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(freq_xlating_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(freq_xlating_fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(freq_xlating_fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(freq_xlating_fir_filter_scc_sptr self) -> long"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(freq_xlating_fir_filter_scc_sptr self) -> basic_block_sptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(freq_xlating_fir_filter_scc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(freq_xlating_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(freq_xlating_fir_filter_scc_sptr self, std::string name)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(freq_xlating_fir_filter_scc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(freq_xlating_fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(freq_xlating_fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(freq_xlating_fir_filter_scc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.freq_xlating_fir_filter_scc_sptr_message_subscribers(self, which_port)

# Register freq_xlating_fir_filter_scc_sptr in _filter_swig:
_filter_swig.freq_xlating_fir_filter_scc_sptr_swigregister(freq_xlating_fir_filter_scc_sptr)

freq_xlating_fir_filter_scc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
freq_xlating_fir_filter_scc = freq_xlating_fir_filter_scc.make

class hilbert_fc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::hilbert_fc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(hilbert_fc_sptr self) -> hilbert_fc_sptr
        __init__(hilbert_fc_sptr self, hilbert_fc p) -> hilbert_fc_sptr
        """
        _filter_swig.hilbert_fc_sptr_swiginit(self, _filter_swig.new_hilbert_fc_sptr(*args))

    def __deref__(self) -> "gr::filter::hilbert_fc *":
        r"""__deref__(hilbert_fc_sptr self) -> hilbert_fc"""
        return _filter_swig.hilbert_fc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_hilbert_fc_sptr

    def make(self, *args, **kwargs) -> "gr::filter::hilbert_fc::sptr":
        r"""
        make(hilbert_fc_sptr self, unsigned int ntaps, gr::filter::firdes::win_type window=WIN_HAMMING, double beta=6.76) -> hilbert_fc_sptr
        Hilbert transformer.

        real output is input appropriately delayed. imaginary output is hilbert filtered (90 degree phase shift) version of input.

        Constructor Specific Documentation:

        Build a Hilbert transformer filter block.

        Args:
            ntaps : The number of taps for the filter.
            window : Window type (see firdes::win_type) to use.
            beta : Beta value for a Kaiser window.
        """
        return _filter_swig.hilbert_fc_sptr_make(self, *args, **kwargs)

    def history(self) -> "unsigned int":
        r"""history(hilbert_fc_sptr self) -> unsigned int"""
        return _filter_swig.hilbert_fc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(hilbert_fc_sptr self, int which, int delay)
        declare_sample_delay(hilbert_fc_sptr self, unsigned int delay)
        """
        return _filter_swig.hilbert_fc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(hilbert_fc_sptr self, int which) -> unsigned int"""
        return _filter_swig.hilbert_fc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(hilbert_fc_sptr self, int multiple)"""
        return _filter_swig.hilbert_fc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(hilbert_fc_sptr self) -> int"""
        return _filter_swig.hilbert_fc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(hilbert_fc_sptr self) -> double"""
        return _filter_swig.hilbert_fc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(hilbert_fc_sptr self) -> uint64_t"""
        return _filter_swig.hilbert_fc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(hilbert_fc_sptr self) -> uint64_t"""
        return _filter_swig.hilbert_fc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(hilbert_fc_sptr self) -> bool"""
        return _filter_swig.hilbert_fc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(hilbert_fc_sptr self) -> bool"""
        return _filter_swig.hilbert_fc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(hilbert_fc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.hilbert_fc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(hilbert_fc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.hilbert_fc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(hilbert_fc_sptr self, std::string level)"""
        return _filter_swig.hilbert_fc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(hilbert_fc_sptr self) -> std::string"""
        return _filter_swig.hilbert_fc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(hilbert_fc_sptr self) -> int"""
        return _filter_swig.hilbert_fc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(hilbert_fc_sptr self, int m)"""
        return _filter_swig.hilbert_fc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(hilbert_fc_sptr self)"""
        return _filter_swig.hilbert_fc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(hilbert_fc_sptr self) -> bool"""
        return _filter_swig.hilbert_fc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(hilbert_fc_sptr self, int m)"""
        return _filter_swig.hilbert_fc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(hilbert_fc_sptr self) -> int"""
        return _filter_swig.hilbert_fc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(hilbert_fc_sptr self, int i) -> long"""
        return _filter_swig.hilbert_fc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(hilbert_fc_sptr self, long max_output_buffer)
        set_max_output_buffer(hilbert_fc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.hilbert_fc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(hilbert_fc_sptr self, int i) -> long"""
        return _filter_swig.hilbert_fc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(hilbert_fc_sptr self, long min_output_buffer)
        set_min_output_buffer(hilbert_fc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.hilbert_fc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(hilbert_fc_sptr self, int which) -> float
        pc_input_buffers_full(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(hilbert_fc_sptr self, int which) -> float
        pc_input_buffers_full_avg(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(hilbert_fc_sptr self, int which) -> float
        pc_input_buffers_full_var(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(hilbert_fc_sptr self, int which) -> float
        pc_output_buffers_full(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(hilbert_fc_sptr self, int which) -> float
        pc_output_buffers_full_avg(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(hilbert_fc_sptr self, int which) -> float
        pc_output_buffers_full_var(hilbert_fc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.hilbert_fc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(hilbert_fc_sptr self) -> float"""
        return _filter_swig.hilbert_fc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(hilbert_fc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.hilbert_fc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(hilbert_fc_sptr self)"""
        return _filter_swig.hilbert_fc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(hilbert_fc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.hilbert_fc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(hilbert_fc_sptr self) -> int"""
        return _filter_swig.hilbert_fc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(hilbert_fc_sptr self) -> int"""
        return _filter_swig.hilbert_fc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(hilbert_fc_sptr self, int priority) -> int"""
        return _filter_swig.hilbert_fc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(hilbert_fc_sptr self) -> std::string"""
        return _filter_swig.hilbert_fc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(hilbert_fc_sptr self) -> std::string"""
        return _filter_swig.hilbert_fc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(hilbert_fc_sptr self) -> io_signature_sptr"""
        return _filter_swig.hilbert_fc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(hilbert_fc_sptr self) -> io_signature_sptr"""
        return _filter_swig.hilbert_fc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(hilbert_fc_sptr self) -> long"""
        return _filter_swig.hilbert_fc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(hilbert_fc_sptr self) -> basic_block_sptr"""
        return _filter_swig.hilbert_fc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(hilbert_fc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.hilbert_fc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(hilbert_fc_sptr self) -> std::string"""
        return _filter_swig.hilbert_fc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(hilbert_fc_sptr self, std::string name)"""
        return _filter_swig.hilbert_fc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(hilbert_fc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.hilbert_fc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(hilbert_fc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.hilbert_fc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(hilbert_fc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.hilbert_fc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(hilbert_fc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.hilbert_fc_sptr_message_subscribers(self, which_port)

# Register hilbert_fc_sptr in _filter_swig:
_filter_swig.hilbert_fc_sptr_swigregister(hilbert_fc_sptr)

hilbert_fc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
hilbert_fc = hilbert_fc.make;

class iir_filter_ffd_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::iir_filter_ffd > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(iir_filter_ffd_sptr self) -> iir_filter_ffd_sptr
        __init__(iir_filter_ffd_sptr self, iir_filter_ffd p) -> iir_filter_ffd_sptr
        """
        _filter_swig.iir_filter_ffd_sptr_swiginit(self, _filter_swig.new_iir_filter_ffd_sptr(*args))

    def __deref__(self) -> "gr::filter::iir_filter_ffd *":
        r"""__deref__(iir_filter_ffd_sptr self) -> iir_filter_ffd"""
        return _filter_swig.iir_filter_ffd_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ffd_sptr

    def make(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ffd::sptr":
        r"""
        make(iir_filter_ffd_sptr self, pmt_vector_double fftaps, pmt_vector_double fbtaps, bool oldstyle=True) -> iir_filter_ffd_sptr
        IIR filter with float input, float output and double taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ffd_sptr_make(self, fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double") -> "void":
        r"""set_taps(iir_filter_ffd_sptr self, pmt_vector_double fftaps, pmt_vector_double fbtaps)"""
        return _filter_swig.iir_filter_ffd_sptr_set_taps(self, fftaps, fbtaps)

    def history(self) -> "unsigned int":
        r"""history(iir_filter_ffd_sptr self) -> unsigned int"""
        return _filter_swig.iir_filter_ffd_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(iir_filter_ffd_sptr self, int which, int delay)
        declare_sample_delay(iir_filter_ffd_sptr self, unsigned int delay)
        """
        return _filter_swig.iir_filter_ffd_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(iir_filter_ffd_sptr self, int which) -> unsigned int"""
        return _filter_swig.iir_filter_ffd_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(iir_filter_ffd_sptr self, int multiple)"""
        return _filter_swig.iir_filter_ffd_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(iir_filter_ffd_sptr self) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(iir_filter_ffd_sptr self) -> double"""
        return _filter_swig.iir_filter_ffd_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(iir_filter_ffd_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ffd_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(iir_filter_ffd_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ffd_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(iir_filter_ffd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ffd_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(iir_filter_ffd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ffd_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(iir_filter_ffd_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.iir_filter_ffd_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(iir_filter_ffd_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.iir_filter_ffd_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(iir_filter_ffd_sptr self, std::string level)"""
        return _filter_swig.iir_filter_ffd_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(iir_filter_ffd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ffd_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(iir_filter_ffd_sptr self) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(iir_filter_ffd_sptr self, int m)"""
        return _filter_swig.iir_filter_ffd_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(iir_filter_ffd_sptr self)"""
        return _filter_swig.iir_filter_ffd_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(iir_filter_ffd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ffd_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(iir_filter_ffd_sptr self, int m)"""
        return _filter_swig.iir_filter_ffd_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(iir_filter_ffd_sptr self) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(iir_filter_ffd_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ffd_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(iir_filter_ffd_sptr self, long max_output_buffer)
        set_max_output_buffer(iir_filter_ffd_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.iir_filter_ffd_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(iir_filter_ffd_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ffd_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(iir_filter_ffd_sptr self, long min_output_buffer)
        set_min_output_buffer(iir_filter_ffd_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.iir_filter_ffd_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(iir_filter_ffd_sptr self, int which) -> float
        pc_input_buffers_full(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(iir_filter_ffd_sptr self, int which) -> float
        pc_input_buffers_full_avg(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(iir_filter_ffd_sptr self, int which) -> float
        pc_input_buffers_full_var(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(iir_filter_ffd_sptr self, int which) -> float
        pc_output_buffers_full(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(iir_filter_ffd_sptr self, int which) -> float
        pc_output_buffers_full_avg(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(iir_filter_ffd_sptr self, int which) -> float
        pc_output_buffers_full_var(iir_filter_ffd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ffd_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(iir_filter_ffd_sptr self) -> float"""
        return _filter_swig.iir_filter_ffd_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(iir_filter_ffd_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.iir_filter_ffd_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(iir_filter_ffd_sptr self)"""
        return _filter_swig.iir_filter_ffd_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(iir_filter_ffd_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.iir_filter_ffd_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(iir_filter_ffd_sptr self) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(iir_filter_ffd_sptr self) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(iir_filter_ffd_sptr self, int priority) -> int"""
        return _filter_swig.iir_filter_ffd_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(iir_filter_ffd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ffd_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(iir_filter_ffd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ffd_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(iir_filter_ffd_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ffd_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(iir_filter_ffd_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ffd_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(iir_filter_ffd_sptr self) -> long"""
        return _filter_swig.iir_filter_ffd_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(iir_filter_ffd_sptr self) -> basic_block_sptr"""
        return _filter_swig.iir_filter_ffd_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(iir_filter_ffd_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.iir_filter_ffd_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(iir_filter_ffd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ffd_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(iir_filter_ffd_sptr self, std::string name)"""
        return _filter_swig.iir_filter_ffd_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(iir_filter_ffd_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.iir_filter_ffd_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(iir_filter_ffd_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ffd_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(iir_filter_ffd_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ffd_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(iir_filter_ffd_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ffd_sptr_message_subscribers(self, which_port)

# Register iir_filter_ffd_sptr in _filter_swig:
_filter_swig.iir_filter_ffd_sptr_swigregister(iir_filter_ffd_sptr)

iir_filter_ffd_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
iir_filter_ffd = iir_filter_ffd.make;

class iir_filter_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::iir_filter_ccc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(iir_filter_ccc_sptr self) -> iir_filter_ccc_sptr
        __init__(iir_filter_ccc_sptr self, iir_filter_ccc p) -> iir_filter_ccc_sptr
        """
        _filter_swig.iir_filter_ccc_sptr_swiginit(self, _filter_swig.new_iir_filter_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::iir_filter_ccc *":
        r"""__deref__(iir_filter_ccc_sptr self) -> iir_filter_ccc"""
        return _filter_swig.iir_filter_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccc_sptr

    def make(self, fftaps: "pmt_vector_cfloat", fbtaps: "pmt_vector_cfloat", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccc::sptr":
        r"""
        make(iir_filter_ccc_sptr self, pmt_vector_cfloat fftaps, pmt_vector_cfloat fbtaps, bool oldstyle=True) -> iir_filter_ccc_sptr
        IIR filter with complex input, complex output, and complex taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccc_sptr_make(self, fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_cfloat", fbtaps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(iir_filter_ccc_sptr self, pmt_vector_cfloat fftaps, pmt_vector_cfloat fbtaps)"""
        return _filter_swig.iir_filter_ccc_sptr_set_taps(self, fftaps, fbtaps)

    def history(self) -> "unsigned int":
        r"""history(iir_filter_ccc_sptr self) -> unsigned int"""
        return _filter_swig.iir_filter_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(iir_filter_ccc_sptr self, int which, int delay)
        declare_sample_delay(iir_filter_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.iir_filter_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(iir_filter_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.iir_filter_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(iir_filter_ccc_sptr self, int multiple)"""
        return _filter_swig.iir_filter_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(iir_filter_ccc_sptr self) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(iir_filter_ccc_sptr self) -> double"""
        return _filter_swig.iir_filter_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(iir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(iir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(iir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(iir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(iir_filter_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.iir_filter_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(iir_filter_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.iir_filter_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(iir_filter_ccc_sptr self, std::string level)"""
        return _filter_swig.iir_filter_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(iir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(iir_filter_ccc_sptr self) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(iir_filter_ccc_sptr self, int m)"""
        return _filter_swig.iir_filter_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(iir_filter_ccc_sptr self)"""
        return _filter_swig.iir_filter_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(iir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(iir_filter_ccc_sptr self, int m)"""
        return _filter_swig.iir_filter_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(iir_filter_ccc_sptr self) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(iir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(iir_filter_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(iir_filter_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.iir_filter_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(iir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(iir_filter_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(iir_filter_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.iir_filter_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(iir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(iir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(iir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(iir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(iir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(iir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(iir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(iir_filter_ccc_sptr self) -> float"""
        return _filter_swig.iir_filter_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(iir_filter_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.iir_filter_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(iir_filter_ccc_sptr self)"""
        return _filter_swig.iir_filter_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(iir_filter_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.iir_filter_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(iir_filter_ccc_sptr self) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(iir_filter_ccc_sptr self) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(iir_filter_ccc_sptr self, int priority) -> int"""
        return _filter_swig.iir_filter_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(iir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(iir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(iir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(iir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(iir_filter_ccc_sptr self) -> long"""
        return _filter_swig.iir_filter_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(iir_filter_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.iir_filter_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(iir_filter_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.iir_filter_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(iir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(iir_filter_ccc_sptr self, std::string name)"""
        return _filter_swig.iir_filter_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(iir_filter_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.iir_filter_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(iir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(iir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(iir_filter_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccc_sptr_message_subscribers(self, which_port)

# Register iir_filter_ccc_sptr in _filter_swig:
_filter_swig.iir_filter_ccc_sptr_swigregister(iir_filter_ccc_sptr)

iir_filter_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
iir_filter_ccc = iir_filter_ccc.make;

class iir_filter_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::iir_filter_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(iir_filter_ccf_sptr self) -> iir_filter_ccf_sptr
        __init__(iir_filter_ccf_sptr self, iir_filter_ccf p) -> iir_filter_ccf_sptr
        """
        _filter_swig.iir_filter_ccf_sptr_swiginit(self, _filter_swig.new_iir_filter_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::iir_filter_ccf *":
        r"""__deref__(iir_filter_ccf_sptr self) -> iir_filter_ccf"""
        return _filter_swig.iir_filter_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccf_sptr

    def make(self, fftaps: "pmt_vector_float", fbtaps: "pmt_vector_float", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccf::sptr":
        r"""
        make(iir_filter_ccf_sptr self, pmt_vector_float fftaps, pmt_vector_float fbtaps, bool oldstyle=True) -> iir_filter_ccf_sptr
        IIR filter with complex input, complex output, and float taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccf_sptr_make(self, fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_float", fbtaps: "pmt_vector_float") -> "void":
        r"""set_taps(iir_filter_ccf_sptr self, pmt_vector_float fftaps, pmt_vector_float fbtaps)"""
        return _filter_swig.iir_filter_ccf_sptr_set_taps(self, fftaps, fbtaps)

    def history(self) -> "unsigned int":
        r"""history(iir_filter_ccf_sptr self) -> unsigned int"""
        return _filter_swig.iir_filter_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(iir_filter_ccf_sptr self, int which, int delay)
        declare_sample_delay(iir_filter_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.iir_filter_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(iir_filter_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.iir_filter_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(iir_filter_ccf_sptr self, int multiple)"""
        return _filter_swig.iir_filter_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(iir_filter_ccf_sptr self) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(iir_filter_ccf_sptr self) -> double"""
        return _filter_swig.iir_filter_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(iir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(iir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(iir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(iir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(iir_filter_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.iir_filter_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(iir_filter_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.iir_filter_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(iir_filter_ccf_sptr self, std::string level)"""
        return _filter_swig.iir_filter_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(iir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(iir_filter_ccf_sptr self) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(iir_filter_ccf_sptr self, int m)"""
        return _filter_swig.iir_filter_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(iir_filter_ccf_sptr self)"""
        return _filter_swig.iir_filter_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(iir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(iir_filter_ccf_sptr self, int m)"""
        return _filter_swig.iir_filter_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(iir_filter_ccf_sptr self) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(iir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(iir_filter_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(iir_filter_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.iir_filter_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(iir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(iir_filter_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(iir_filter_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.iir_filter_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(iir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(iir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(iir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(iir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(iir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(iir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(iir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(iir_filter_ccf_sptr self) -> float"""
        return _filter_swig.iir_filter_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(iir_filter_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.iir_filter_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(iir_filter_ccf_sptr self)"""
        return _filter_swig.iir_filter_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(iir_filter_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.iir_filter_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(iir_filter_ccf_sptr self) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(iir_filter_ccf_sptr self) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(iir_filter_ccf_sptr self, int priority) -> int"""
        return _filter_swig.iir_filter_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(iir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(iir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(iir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(iir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(iir_filter_ccf_sptr self) -> long"""
        return _filter_swig.iir_filter_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(iir_filter_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.iir_filter_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(iir_filter_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.iir_filter_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(iir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(iir_filter_ccf_sptr self, std::string name)"""
        return _filter_swig.iir_filter_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(iir_filter_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.iir_filter_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(iir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(iir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(iir_filter_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccf_sptr_message_subscribers(self, which_port)

# Register iir_filter_ccf_sptr in _filter_swig:
_filter_swig.iir_filter_ccf_sptr_swigregister(iir_filter_ccf_sptr)

iir_filter_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
iir_filter_ccf = iir_filter_ccf.make;

class iir_filter_ccd_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::iir_filter_ccd > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(iir_filter_ccd_sptr self) -> iir_filter_ccd_sptr
        __init__(iir_filter_ccd_sptr self, iir_filter_ccd p) -> iir_filter_ccd_sptr
        """
        _filter_swig.iir_filter_ccd_sptr_swiginit(self, _filter_swig.new_iir_filter_ccd_sptr(*args))

    def __deref__(self) -> "gr::filter::iir_filter_ccd *":
        r"""__deref__(iir_filter_ccd_sptr self) -> iir_filter_ccd"""
        return _filter_swig.iir_filter_ccd_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccd_sptr

    def make(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccd::sptr":
        r"""
        make(iir_filter_ccd_sptr self, pmt_vector_double fftaps, pmt_vector_double fbtaps, bool oldstyle=True) -> iir_filter_ccd_sptr
        IIR filter with complex input, complex output, and double taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccd_sptr_make(self, fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_double", fbtaps: "pmt_vector_double") -> "void":
        r"""set_taps(iir_filter_ccd_sptr self, pmt_vector_double fftaps, pmt_vector_double fbtaps)"""
        return _filter_swig.iir_filter_ccd_sptr_set_taps(self, fftaps, fbtaps)

    def history(self) -> "unsigned int":
        r"""history(iir_filter_ccd_sptr self) -> unsigned int"""
        return _filter_swig.iir_filter_ccd_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(iir_filter_ccd_sptr self, int which, int delay)
        declare_sample_delay(iir_filter_ccd_sptr self, unsigned int delay)
        """
        return _filter_swig.iir_filter_ccd_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(iir_filter_ccd_sptr self, int which) -> unsigned int"""
        return _filter_swig.iir_filter_ccd_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(iir_filter_ccd_sptr self, int multiple)"""
        return _filter_swig.iir_filter_ccd_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(iir_filter_ccd_sptr self) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(iir_filter_ccd_sptr self) -> double"""
        return _filter_swig.iir_filter_ccd_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(iir_filter_ccd_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccd_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(iir_filter_ccd_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccd_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(iir_filter_ccd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccd_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(iir_filter_ccd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccd_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(iir_filter_ccd_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.iir_filter_ccd_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(iir_filter_ccd_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.iir_filter_ccd_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(iir_filter_ccd_sptr self, std::string level)"""
        return _filter_swig.iir_filter_ccd_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(iir_filter_ccd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccd_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(iir_filter_ccd_sptr self) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(iir_filter_ccd_sptr self, int m)"""
        return _filter_swig.iir_filter_ccd_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(iir_filter_ccd_sptr self)"""
        return _filter_swig.iir_filter_ccd_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(iir_filter_ccd_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccd_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(iir_filter_ccd_sptr self, int m)"""
        return _filter_swig.iir_filter_ccd_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(iir_filter_ccd_sptr self) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(iir_filter_ccd_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccd_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(iir_filter_ccd_sptr self, long max_output_buffer)
        set_max_output_buffer(iir_filter_ccd_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.iir_filter_ccd_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(iir_filter_ccd_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccd_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(iir_filter_ccd_sptr self, long min_output_buffer)
        set_min_output_buffer(iir_filter_ccd_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.iir_filter_ccd_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(iir_filter_ccd_sptr self, int which) -> float
        pc_input_buffers_full(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(iir_filter_ccd_sptr self, int which) -> float
        pc_input_buffers_full_avg(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(iir_filter_ccd_sptr self, int which) -> float
        pc_input_buffers_full_var(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(iir_filter_ccd_sptr self, int which) -> float
        pc_output_buffers_full(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(iir_filter_ccd_sptr self, int which) -> float
        pc_output_buffers_full_avg(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(iir_filter_ccd_sptr self, int which) -> float
        pc_output_buffers_full_var(iir_filter_ccd_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccd_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(iir_filter_ccd_sptr self) -> float"""
        return _filter_swig.iir_filter_ccd_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(iir_filter_ccd_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.iir_filter_ccd_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(iir_filter_ccd_sptr self)"""
        return _filter_swig.iir_filter_ccd_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(iir_filter_ccd_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.iir_filter_ccd_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(iir_filter_ccd_sptr self) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(iir_filter_ccd_sptr self) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(iir_filter_ccd_sptr self, int priority) -> int"""
        return _filter_swig.iir_filter_ccd_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(iir_filter_ccd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccd_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(iir_filter_ccd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccd_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(iir_filter_ccd_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccd_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(iir_filter_ccd_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccd_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(iir_filter_ccd_sptr self) -> long"""
        return _filter_swig.iir_filter_ccd_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(iir_filter_ccd_sptr self) -> basic_block_sptr"""
        return _filter_swig.iir_filter_ccd_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(iir_filter_ccd_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.iir_filter_ccd_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(iir_filter_ccd_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccd_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(iir_filter_ccd_sptr self, std::string name)"""
        return _filter_swig.iir_filter_ccd_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(iir_filter_ccd_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.iir_filter_ccd_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(iir_filter_ccd_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccd_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(iir_filter_ccd_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccd_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(iir_filter_ccd_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccd_sptr_message_subscribers(self, which_port)

# Register iir_filter_ccd_sptr in _filter_swig:
_filter_swig.iir_filter_ccd_sptr_swigregister(iir_filter_ccd_sptr)

iir_filter_ccd_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
iir_filter_ccd = iir_filter_ccd.make;

class iir_filter_ccz_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::iir_filter_ccz > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(iir_filter_ccz_sptr self) -> iir_filter_ccz_sptr
        __init__(iir_filter_ccz_sptr self, iir_filter_ccz p) -> iir_filter_ccz_sptr
        """
        _filter_swig.iir_filter_ccz_sptr_swiginit(self, _filter_swig.new_iir_filter_ccz_sptr(*args))

    def __deref__(self) -> "gr::filter::iir_filter_ccz *":
        r"""__deref__(iir_filter_ccz_sptr self) -> iir_filter_ccz"""
        return _filter_swig.iir_filter_ccz_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_iir_filter_ccz_sptr

    def make(self, fftaps: "pmt_vector_cdouble", fbtaps: "pmt_vector_cdouble", oldstyle: "bool"=True) -> "gr::filter::iir_filter_ccz::sptr":
        r"""
        make(iir_filter_ccz_sptr self, pmt_vector_cdouble fftaps, pmt_vector_cdouble fbtaps, bool oldstyle=True) -> iir_filter_ccz_sptr
        IIR filter with complex input, complex output, and complex (double) taps.

        This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


         The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


        The input and output satisfy a difference equation of the form   



        y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



        with the corresponding rational system function   



        H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

        Constructor Specific Documentation:



        Args:
            fftaps : 
            fbtaps : 
            oldstyle : 
        """
        return _filter_swig.iir_filter_ccz_sptr_make(self, fftaps, fbtaps, oldstyle)

    def set_taps(self, fftaps: "pmt_vector_cdouble", fbtaps: "pmt_vector_cdouble") -> "void":
        r"""set_taps(iir_filter_ccz_sptr self, pmt_vector_cdouble fftaps, pmt_vector_cdouble fbtaps)"""
        return _filter_swig.iir_filter_ccz_sptr_set_taps(self, fftaps, fbtaps)

    def history(self) -> "unsigned int":
        r"""history(iir_filter_ccz_sptr self) -> unsigned int"""
        return _filter_swig.iir_filter_ccz_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(iir_filter_ccz_sptr self, int which, int delay)
        declare_sample_delay(iir_filter_ccz_sptr self, unsigned int delay)
        """
        return _filter_swig.iir_filter_ccz_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(iir_filter_ccz_sptr self, int which) -> unsigned int"""
        return _filter_swig.iir_filter_ccz_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(iir_filter_ccz_sptr self, int multiple)"""
        return _filter_swig.iir_filter_ccz_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(iir_filter_ccz_sptr self) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(iir_filter_ccz_sptr self) -> double"""
        return _filter_swig.iir_filter_ccz_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(iir_filter_ccz_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccz_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(iir_filter_ccz_sptr self) -> uint64_t"""
        return _filter_swig.iir_filter_ccz_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(iir_filter_ccz_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccz_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(iir_filter_ccz_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccz_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(iir_filter_ccz_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.iir_filter_ccz_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(iir_filter_ccz_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.iir_filter_ccz_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(iir_filter_ccz_sptr self, std::string level)"""
        return _filter_swig.iir_filter_ccz_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(iir_filter_ccz_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccz_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(iir_filter_ccz_sptr self) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(iir_filter_ccz_sptr self, int m)"""
        return _filter_swig.iir_filter_ccz_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(iir_filter_ccz_sptr self)"""
        return _filter_swig.iir_filter_ccz_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(iir_filter_ccz_sptr self) -> bool"""
        return _filter_swig.iir_filter_ccz_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(iir_filter_ccz_sptr self, int m)"""
        return _filter_swig.iir_filter_ccz_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(iir_filter_ccz_sptr self) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(iir_filter_ccz_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccz_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(iir_filter_ccz_sptr self, long max_output_buffer)
        set_max_output_buffer(iir_filter_ccz_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.iir_filter_ccz_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(iir_filter_ccz_sptr self, int i) -> long"""
        return _filter_swig.iir_filter_ccz_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(iir_filter_ccz_sptr self, long min_output_buffer)
        set_min_output_buffer(iir_filter_ccz_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.iir_filter_ccz_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(iir_filter_ccz_sptr self, int which) -> float
        pc_input_buffers_full(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(iir_filter_ccz_sptr self, int which) -> float
        pc_input_buffers_full_avg(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(iir_filter_ccz_sptr self, int which) -> float
        pc_input_buffers_full_var(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(iir_filter_ccz_sptr self, int which) -> float
        pc_output_buffers_full(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(iir_filter_ccz_sptr self, int which) -> float
        pc_output_buffers_full_avg(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(iir_filter_ccz_sptr self, int which) -> float
        pc_output_buffers_full_var(iir_filter_ccz_sptr self) -> pmt_vector_float
        """
        return _filter_swig.iir_filter_ccz_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(iir_filter_ccz_sptr self) -> float"""
        return _filter_swig.iir_filter_ccz_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(iir_filter_ccz_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.iir_filter_ccz_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(iir_filter_ccz_sptr self)"""
        return _filter_swig.iir_filter_ccz_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(iir_filter_ccz_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.iir_filter_ccz_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(iir_filter_ccz_sptr self) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(iir_filter_ccz_sptr self) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(iir_filter_ccz_sptr self, int priority) -> int"""
        return _filter_swig.iir_filter_ccz_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(iir_filter_ccz_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccz_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(iir_filter_ccz_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccz_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(iir_filter_ccz_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccz_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(iir_filter_ccz_sptr self) -> io_signature_sptr"""
        return _filter_swig.iir_filter_ccz_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(iir_filter_ccz_sptr self) -> long"""
        return _filter_swig.iir_filter_ccz_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(iir_filter_ccz_sptr self) -> basic_block_sptr"""
        return _filter_swig.iir_filter_ccz_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(iir_filter_ccz_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.iir_filter_ccz_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(iir_filter_ccz_sptr self) -> std::string"""
        return _filter_swig.iir_filter_ccz_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(iir_filter_ccz_sptr self, std::string name)"""
        return _filter_swig.iir_filter_ccz_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(iir_filter_ccz_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.iir_filter_ccz_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(iir_filter_ccz_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccz_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(iir_filter_ccz_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccz_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(iir_filter_ccz_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.iir_filter_ccz_sptr_message_subscribers(self, which_port)

# Register iir_filter_ccz_sptr in _filter_swig:
_filter_swig.iir_filter_ccz_sptr_swigregister(iir_filter_ccz_sptr)

iir_filter_ccz_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
iir_filter_ccz = iir_filter_ccz.make;

class interp_fir_filter_ccc(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_ccc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_ccc_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_ccc self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_ccc self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_ccc_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_ccc

# Register interp_fir_filter_ccc in _filter_swig:
_filter_swig.interp_fir_filter_ccc_swigregister(interp_fir_filter_ccc)
class interp_fir_filter_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< gr_complex,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_ccc_sptr self) -> interp_fir_filter_ccc_sptr
        __init__(interp_fir_filter_ccc_sptr self, interp_fir_filter_ccc p) -> interp_fir_filter_ccc_sptr
        """
        _filter_swig.interp_fir_filter_ccc_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< gr_complex,gr_complex,gr_complex > *":
        r"""__deref__(interp_fir_filter_ccc_sptr self) -> interp_fir_filter_ccc"""
        return _filter_swig.interp_fir_filter_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_ccc_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(interp_fir_filter_ccc_sptr self, unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_ccc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_ccc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_ccc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_ccc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_ccc_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_ccc_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_ccc_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_ccc_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_ccc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_ccc_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_ccc_sptr self)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_ccc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_ccc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_ccc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_ccc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_ccc_sptr self)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_ccc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_ccc_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_ccc_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_ccc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_ccc_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccc_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_ccc_sptr in _filter_swig:
_filter_swig.interp_fir_filter_ccc_sptr_swigregister(interp_fir_filter_ccc_sptr)

interp_fir_filter_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_ccc = interp_fir_filter_ccc.make

class interp_fir_filter_ccf(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_ccf_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_ccf_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_ccf self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_ccf self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_ccf_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_ccf

# Register interp_fir_filter_ccf in _filter_swig:
_filter_swig.interp_fir_filter_ccf_swigregister(interp_fir_filter_ccf)
class interp_fir_filter_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< gr_complex,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_ccf_sptr self) -> interp_fir_filter_ccf_sptr
        __init__(interp_fir_filter_ccf_sptr self, interp_fir_filter_ccf p) -> interp_fir_filter_ccf_sptr
        """
        _filter_swig.interp_fir_filter_ccf_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< gr_complex,gr_complex,float > *":
        r"""__deref__(interp_fir_filter_ccf_sptr self) -> interp_fir_filter_ccf"""
        return _filter_swig.interp_fir_filter_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_ccf_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(interp_fir_filter_ccf_sptr self, unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_ccf_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_ccf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_ccf_sptr self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_ccf_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_ccf_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_ccf_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_ccf_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_ccf_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_ccf_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_ccf_sptr self)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_ccf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_ccf_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_ccf_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_ccf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_ccf_sptr self)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_ccf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_ccf_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_ccf_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_ccf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_ccf_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_ccf_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_ccf_sptr in _filter_swig:
_filter_swig.interp_fir_filter_ccf_sptr_swigregister(interp_fir_filter_ccf_sptr)

interp_fir_filter_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_ccf = interp_fir_filter_ccf.make

class interp_fir_filter_fcc(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_fcc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fcc_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_fcc self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_fcc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_fcc self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_fcc_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fcc

# Register interp_fir_filter_fcc in _filter_swig:
_filter_swig.interp_fir_filter_fcc_swigregister(interp_fir_filter_fcc)
class interp_fir_filter_fcc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< float,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_fcc_sptr self) -> interp_fir_filter_fcc_sptr
        __init__(interp_fir_filter_fcc_sptr self, interp_fir_filter_fcc p) -> interp_fir_filter_fcc_sptr
        """
        _filter_swig.interp_fir_filter_fcc_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_fcc_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< float,gr_complex,gr_complex > *":
        r"""__deref__(interp_fir_filter_fcc_sptr self) -> interp_fir_filter_fcc"""
        return _filter_swig.interp_fir_filter_fcc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fcc_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(interp_fir_filter_fcc_sptr self, unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_fcc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_fcc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_fcc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_fcc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_fcc_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_fcc_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_fcc_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_fcc_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_fcc_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_fcc_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_fcc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fcc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_fcc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fcc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fcc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fcc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_fcc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fcc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_fcc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fcc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_fcc_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fcc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_fcc_sptr self)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_fcc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fcc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_fcc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fcc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_fcc_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_fcc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_fcc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fcc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_fcc_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_fcc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_fcc_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_fcc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fcc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_fcc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_fcc_sptr self)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_fcc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_fcc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_fcc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_fcc_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fcc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fcc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_fcc_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_fcc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_fcc_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_fcc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_fcc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_fcc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fcc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_fcc_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_fcc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_fcc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_fcc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_fcc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fcc_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_fcc_sptr in _filter_swig:
_filter_swig.interp_fir_filter_fcc_sptr_swigregister(interp_fir_filter_fcc_sptr)

interp_fir_filter_fcc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_fcc = interp_fir_filter_fcc.make

class interp_fir_filter_fff(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< float,float,float >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_fff_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fff_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_fff self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_fff_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_fff self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_fff_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fff

# Register interp_fir_filter_fff in _filter_swig:
_filter_swig.interp_fir_filter_fff_swigregister(interp_fir_filter_fff)
class interp_fir_filter_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< float,float,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_fff_sptr self) -> interp_fir_filter_fff_sptr
        __init__(interp_fir_filter_fff_sptr self, interp_fir_filter_fff p) -> interp_fir_filter_fff_sptr
        """
        _filter_swig.interp_fir_filter_fff_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_fff_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< float,float,float > *":
        r"""__deref__(interp_fir_filter_fff_sptr self) -> interp_fir_filter_fff"""
        return _filter_swig.interp_fir_filter_fff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fff_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< float,float,float >::sptr":
        r"""
        make(interp_fir_filter_fff_sptr self, unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_fff_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fff_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_fff_sptr self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_fff_sptr self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_fff_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_fff_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_fff_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_fff_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_fff_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_fff_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_fff_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_fff_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_fff_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_fff_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_fff_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_fff_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_fff_sptr self)"""
        return _filter_swig.interp_fir_filter_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_fff_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_fff_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_fff_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_fff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_fff_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_fff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_fff_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_fff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_fff_sptr self)"""
        return _filter_swig.interp_fir_filter_fff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_fff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_fff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_fff_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_fff_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_fff_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_fff_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_fff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_fff_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_fff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_fff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_fff_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_fff_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_fff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_fff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_fff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_fff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fff_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_fff_sptr in _filter_swig:
_filter_swig.interp_fir_filter_fff_sptr_swigregister(interp_fir_filter_fff_sptr)

interp_fir_filter_fff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_fff = interp_fir_filter_fff.make

class interp_fir_filter_fsf(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< float,short,float >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_fsf_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fsf_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_fsf self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_fsf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_fsf self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_fsf_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fsf

# Register interp_fir_filter_fsf in _filter_swig:
_filter_swig.interp_fir_filter_fsf_swigregister(interp_fir_filter_fsf)
class interp_fir_filter_fsf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< float,std::int16_t,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_fsf_sptr self) -> interp_fir_filter_fsf_sptr
        __init__(interp_fir_filter_fsf_sptr self, interp_fir_filter_fsf p) -> interp_fir_filter_fsf_sptr
        """
        _filter_swig.interp_fir_filter_fsf_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_fsf_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< float,std::int16_t,float > *":
        r"""__deref__(interp_fir_filter_fsf_sptr self) -> interp_fir_filter_fsf"""
        return _filter_swig.interp_fir_filter_fsf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_fsf_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::interp_fir_filter< float,short,float >::sptr":
        r"""
        make(interp_fir_filter_fsf_sptr self, unsigned int interpolation, pmt_vector_float taps) -> interp_fir_filter_fsf_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(interp_fir_filter_fsf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(interp_fir_filter_fsf_sptr self) -> pmt_vector_float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_fsf_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_fsf_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_fsf_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_fsf_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_fsf_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_fsf_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_fsf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_fsf_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fsf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_fsf_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fsf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fsf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fsf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_fsf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fsf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_fsf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_fsf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_fsf_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fsf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_fsf_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_fsf_sptr self)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_fsf_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_fsf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_fsf_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_fsf_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fsf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_fsf_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_fsf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_fsf_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_fsf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_fsf_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_fsf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_fsf_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_fsf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_fsf_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_fsf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_fsf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_fsf_sptr self)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_fsf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_fsf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_fsf_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_fsf_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fsf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fsf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_fsf_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_fsf_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_fsf_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_fsf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_fsf_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_fsf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_fsf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_fsf_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_fsf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_fsf_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_fsf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_fsf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_fsf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_fsf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_fsf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_fsf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_fsf_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_fsf_sptr in _filter_swig:
_filter_swig.interp_fir_filter_fsf_sptr_swigregister(interp_fir_filter_fsf_sptr)

interp_fir_filter_fsf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_fsf = interp_fir_filter_fsf.make

class interp_fir_filter_scc(object):
    r"""
    Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

    The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





    The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


    These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

    Constructor Specific Documentation:

    Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

    Args:
        interpolation : set the integer interpolation rate
        taps : a vector/list of taps of type TAP_T
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_scc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_scc_make(interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_scc self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_scc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_scc self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_scc_taps(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_scc

# Register interp_fir_filter_scc in _filter_swig:
_filter_swig.interp_fir_filter_scc_swigregister(interp_fir_filter_scc)
class interp_fir_filter_scc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::interp_fir_filter< std::int16_t,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(interp_fir_filter_scc_sptr self) -> interp_fir_filter_scc_sptr
        __init__(interp_fir_filter_scc_sptr self, interp_fir_filter_scc p) -> interp_fir_filter_scc_sptr
        """
        _filter_swig.interp_fir_filter_scc_sptr_swiginit(self, _filter_swig.new_interp_fir_filter_scc_sptr(*args))

    def __deref__(self) -> "gr::filter::interp_fir_filter< std::int16_t,gr_complex,gr_complex > *":
        r"""__deref__(interp_fir_filter_scc_sptr self) -> interp_fir_filter_scc"""
        return _filter_swig.interp_fir_filter_scc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_interp_fir_filter_scc_sptr

    def make(self, interpolation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::interp_fir_filter< short,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(interp_fir_filter_scc_sptr self, unsigned int interpolation, pmt_vector_cfloat taps) -> interp_fir_filter_scc_sptr
        Interpolating FIR filter with IN_T input, OUT_T output and TAP_T taps.

        The fir_filter_XXX blocks create finite impulse response (FIR) filters that perform the convolution in the time domain:





        The taps are a C++ vector (or Python list) of values of the type specified by the third letter in the block's suffix. For this block, the value is of type TAP_T. Taps can be created using the firdes or optfir tools.


        These versions of the filter can also act as up-samplers (or interpolators) by specifying an integer value for .

        Constructor Specific Documentation:

        Interpolating FIR filter with IN_T input, OUT_T output, and TAP_T taps.

        Args:
            interpolation : set the integer interpolation rate
            taps : a vector/list of taps of type TAP_T
        """
        return _filter_swig.interp_fir_filter_scc_sptr_make(self, interpolation, taps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(interp_fir_filter_scc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(interp_fir_filter_scc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.interp_fir_filter_scc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(interp_fir_filter_scc_sptr self) -> unsigned int"""
        return _filter_swig.interp_fir_filter_scc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(interp_fir_filter_scc_sptr self, int which, int delay)
        declare_sample_delay(interp_fir_filter_scc_sptr self, unsigned int delay)
        """
        return _filter_swig.interp_fir_filter_scc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(interp_fir_filter_scc_sptr self, int which) -> unsigned int"""
        return _filter_swig.interp_fir_filter_scc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(interp_fir_filter_scc_sptr self, int multiple)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(interp_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(interp_fir_filter_scc_sptr self) -> double"""
        return _filter_swig.interp_fir_filter_scc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(interp_fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_scc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(interp_fir_filter_scc_sptr self) -> uint64_t"""
        return _filter_swig.interp_fir_filter_scc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(interp_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_scc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(interp_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_scc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(interp_fir_filter_scc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.interp_fir_filter_scc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(interp_fir_filter_scc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.interp_fir_filter_scc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(interp_fir_filter_scc_sptr self, std::string level)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(interp_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_scc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(interp_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(interp_fir_filter_scc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(interp_fir_filter_scc_sptr self)"""
        return _filter_swig.interp_fir_filter_scc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(interp_fir_filter_scc_sptr self) -> bool"""
        return _filter_swig.interp_fir_filter_scc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(interp_fir_filter_scc_sptr self, int m)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(interp_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(interp_fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_scc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(interp_fir_filter_scc_sptr self, long max_output_buffer)
        set_max_output_buffer(interp_fir_filter_scc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.interp_fir_filter_scc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(interp_fir_filter_scc_sptr self, int i) -> long"""
        return _filter_swig.interp_fir_filter_scc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(interp_fir_filter_scc_sptr self, long min_output_buffer)
        set_min_output_buffer(interp_fir_filter_scc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.interp_fir_filter_scc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(interp_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(interp_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_avg(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(interp_fir_filter_scc_sptr self, int which) -> float
        pc_input_buffers_full_var(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(interp_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(interp_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_avg(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(interp_fir_filter_scc_sptr self, int which) -> float
        pc_output_buffers_full_var(interp_fir_filter_scc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.interp_fir_filter_scc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(interp_fir_filter_scc_sptr self) -> float"""
        return _filter_swig.interp_fir_filter_scc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(interp_fir_filter_scc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(interp_fir_filter_scc_sptr self)"""
        return _filter_swig.interp_fir_filter_scc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(interp_fir_filter_scc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.interp_fir_filter_scc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(interp_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(interp_fir_filter_scc_sptr self) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(interp_fir_filter_scc_sptr self, int priority) -> int"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(interp_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_scc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(interp_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_scc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(interp_fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(interp_fir_filter_scc_sptr self) -> io_signature_sptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(interp_fir_filter_scc_sptr self) -> long"""
        return _filter_swig.interp_fir_filter_scc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(interp_fir_filter_scc_sptr self) -> basic_block_sptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(interp_fir_filter_scc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.interp_fir_filter_scc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(interp_fir_filter_scc_sptr self) -> std::string"""
        return _filter_swig.interp_fir_filter_scc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(interp_fir_filter_scc_sptr self, std::string name)"""
        return _filter_swig.interp_fir_filter_scc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(interp_fir_filter_scc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.interp_fir_filter_scc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(interp_fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(interp_fir_filter_scc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(interp_fir_filter_scc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.interp_fir_filter_scc_sptr_message_subscribers(self, which_port)

# Register interp_fir_filter_scc_sptr in _filter_swig:
_filter_swig.interp_fir_filter_scc_sptr_swigregister(interp_fir_filter_scc_sptr)

interp_fir_filter_scc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
interp_fir_filter_scc = interp_fir_filter_scc.make

class pfb_arb_resampler_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_arb_resampler_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_arb_resampler_ccf_sptr self) -> pfb_arb_resampler_ccf_sptr
        __init__(pfb_arb_resampler_ccf_sptr self, pfb_arb_resampler_ccf p) -> pfb_arb_resampler_ccf_sptr
        """
        _filter_swig.pfb_arb_resampler_ccf_sptr_swiginit(self, _filter_swig.new_pfb_arb_resampler_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_arb_resampler_ccf *":
        r"""__deref__(pfb_arb_resampler_ccf_sptr self) -> pfb_arb_resampler_ccf"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_ccf_sptr

    def make(self, rate: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_ccf::sptr":
        r"""
        make(pfb_arb_resampler_ccf_sptr self, float rate, pmt_vector_float taps, unsigned int filter_size=32) -> pfb_arb_resampler_ccf_sptr
        Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccf to perform arbitrary resampling on the stream.


        Output sampling rate is  * input rate.

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_make(self, rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_arb_resampler_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_arb_resampler_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_ccf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_ccf_sptr self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_ccf_sptr self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_ccf_sptr self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_ccf_sptr self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_ccf_sptr self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_ccf_sptr self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_ccf_sptr self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_ccf_sptr self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_ccf_sptr self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_phase_offset(self, freq, fs)

    def history(self) -> "unsigned int":
        r"""history(pfb_arb_resampler_ccf_sptr self) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_arb_resampler_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_arb_resampler_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_arb_resampler_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_arb_resampler_ccf_sptr self, int multiple)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_arb_resampler_ccf_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_arb_resampler_ccf_sptr self) -> double"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_arb_resampler_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_arb_resampler_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_arb_resampler_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_arb_resampler_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_arb_resampler_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_arb_resampler_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_arb_resampler_ccf_sptr self, std::string level)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_arb_resampler_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_arb_resampler_ccf_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_arb_resampler_ccf_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_arb_resampler_ccf_sptr self)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_arb_resampler_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_arb_resampler_ccf_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_arb_resampler_ccf_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_arb_resampler_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_arb_resampler_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_arb_resampler_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_arb_resampler_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_arb_resampler_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_arb_resampler_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_arb_resampler_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_arb_resampler_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_arb_resampler_ccf_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_arb_resampler_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_arb_resampler_ccf_sptr self)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_arb_resampler_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_arb_resampler_ccf_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_arb_resampler_ccf_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_arb_resampler_ccf_sptr self, int priority) -> int"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_arb_resampler_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_arb_resampler_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_arb_resampler_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_arb_resampler_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_arb_resampler_ccf_sptr self) -> long"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_arb_resampler_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_arb_resampler_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_arb_resampler_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_arb_resampler_ccf_sptr self, std::string name)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_arb_resampler_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_arb_resampler_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_arb_resampler_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_arb_resampler_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_arb_resampler_ccf_sptr in _filter_swig:
_filter_swig.pfb_arb_resampler_ccf_sptr_swigregister(pfb_arb_resampler_ccf_sptr)

pfb_arb_resampler_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_arb_resampler_ccf = pfb_arb_resampler_ccf.make;

class pfb_arb_resampler_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_arb_resampler_ccc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_arb_resampler_ccc_sptr self) -> pfb_arb_resampler_ccc_sptr
        __init__(pfb_arb_resampler_ccc_sptr self, pfb_arb_resampler_ccc p) -> pfb_arb_resampler_ccc_sptr
        """
        _filter_swig.pfb_arb_resampler_ccc_sptr_swiginit(self, _filter_swig.new_pfb_arb_resampler_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_arb_resampler_ccc *":
        r"""__deref__(pfb_arb_resampler_ccc_sptr self) -> pfb_arb_resampler_ccc"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_ccc_sptr

    def make(self, rate: "float", taps: "pmt_vector_cfloat", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_ccc::sptr":
        r"""
        make(pfb_arb_resampler_ccc_sptr self, float rate, pmt_vector_cfloat taps, unsigned int filter_size=32) -> pfb_arb_resampler_ccc_sptr
        Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and gr_complex taps.

        This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccc to perform arbitrary resampling on the stream.


        Output sampling rate is  * input rate.

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of complex) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_make(self, rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        set_taps(pfb_arb_resampler_ccc_sptr self, pmt_vector_cfloat taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        taps(pfb_arb_resampler_ccc_sptr self) -> gr_vector_vector_complexf
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_ccc_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_ccc_sptr self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_ccc_sptr self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_ccc_sptr self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_ccc_sptr self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_ccc_sptr self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_ccc_sptr self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_ccc_sptr self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_ccc_sptr self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_ccc_sptr self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_phase_offset(self, freq, fs)

    def history(self) -> "unsigned int":
        r"""history(pfb_arb_resampler_ccc_sptr self) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_arb_resampler_ccc_sptr self, int which, int delay)
        declare_sample_delay(pfb_arb_resampler_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_arb_resampler_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_arb_resampler_ccc_sptr self, int multiple)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_arb_resampler_ccc_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_arb_resampler_ccc_sptr self) -> double"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_arb_resampler_ccc_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_arb_resampler_ccc_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_arb_resampler_ccc_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_arb_resampler_ccc_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_arb_resampler_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_arb_resampler_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_arb_resampler_ccc_sptr self, std::string level)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_arb_resampler_ccc_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_arb_resampler_ccc_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_arb_resampler_ccc_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_arb_resampler_ccc_sptr self)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_arb_resampler_ccc_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_arb_resampler_ccc_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_arb_resampler_ccc_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_arb_resampler_ccc_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_arb_resampler_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_arb_resampler_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_arb_resampler_ccc_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_arb_resampler_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_arb_resampler_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_input_buffers_full(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_output_buffers_full(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_arb_resampler_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_arb_resampler_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_arb_resampler_ccc_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_arb_resampler_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_arb_resampler_ccc_sptr self)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_arb_resampler_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_arb_resampler_ccc_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_arb_resampler_ccc_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_arb_resampler_ccc_sptr self, int priority) -> int"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_arb_resampler_ccc_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_arb_resampler_ccc_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_arb_resampler_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_arb_resampler_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_arb_resampler_ccc_sptr self) -> long"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_arb_resampler_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_arb_resampler_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_arb_resampler_ccc_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_arb_resampler_ccc_sptr self, std::string name)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_arb_resampler_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_arb_resampler_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_arb_resampler_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_arb_resampler_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_ccc_sptr_message_subscribers(self, which_port)

# Register pfb_arb_resampler_ccc_sptr in _filter_swig:
_filter_swig.pfb_arb_resampler_ccc_sptr_swigregister(pfb_arb_resampler_ccc_sptr)

pfb_arb_resampler_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_arb_resampler_ccc = pfb_arb_resampler_ccc.make;

class pfb_arb_resampler_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_arb_resampler_fff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_arb_resampler_fff_sptr self) -> pfb_arb_resampler_fff_sptr
        __init__(pfb_arb_resampler_fff_sptr self, pfb_arb_resampler_fff p) -> pfb_arb_resampler_fff_sptr
        """
        _filter_swig.pfb_arb_resampler_fff_sptr_swiginit(self, _filter_swig.new_pfb_arb_resampler_fff_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_arb_resampler_fff *":
        r"""__deref__(pfb_arb_resampler_fff_sptr self) -> pfb_arb_resampler_fff"""
        return _filter_swig.pfb_arb_resampler_fff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_arb_resampler_fff_sptr

    def make(self, rate: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32) -> "gr::filter::pfb_arb_resampler_fff::sptr":
        r"""
        make(pfb_arb_resampler_fff_sptr self, float rate, pmt_vector_float taps, unsigned int filter_size=32) -> pfb_arb_resampler_fff_sptr
        Polyphase filterbank arbitrary resampler with float input, float output and float taps.

        This block takes in a signal stream and performs arbitrary resampling. The resampling rate can be any real number . The resampling is done by constructing  filters where  is the interpolation rate. We then calculate  where .


        Using  and , we can perform rational resampling where  is a rational number close to the input rate  where we have  filters and we cycle through them as a polyphase filterbank with a stride of  so that .


        To get the arbitrary rate, we want to interpolate between two points. For each value out, we take an output from the current filter, , and the next filter  and then linearly interpolate between the two based on the real resampling rate we want.


        The linear interpolation only provides us with an approximation to the real sampling rate specified. The error is a quantization error between the two filters we used as our interpolation points. To this end, the number of filters, , used determines the quantization error; the larger , the smaller the noise. You can design for a specified noise floor by setting the filter size (parameters ). The size defaults to 32 filters, which is about as good as most implementations need.


        The trick with designing this filter is in how to specify the taps of the prototype filter. Like the PFB interpolator, the taps are specified using the interpolated filter rate. In this case, that rate is the input sample rate multiplied by the number of filters in the filterbank, which is also the interpolation rate. All other values should be relative to this rate.


        For example, for a 32-filter arbitrary resampler and using the GNU Radio's firdes utility to build the filter, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as the interpolation rate ().





        The theory behind this block can be found in Chapter 7.5 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank arbitrary resampler.

        Args:
            rate : (float) Specifies the resampling rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
            filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_make(self, rate, taps, filter_size)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_arb_resampler_fff_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_arb_resampler_fff_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_arb_resampler_fff_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_print_taps(self)

    def set_rate(self, rate: "float") -> "void":
        r"""
        set_rate(pfb_arb_resampler_fff_sptr self, float rate)
        Sets the resampling rate of the block.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_rate(self, rate)

    def set_phase(self, ph: "float") -> "void":
        r"""
        set_phase(pfb_arb_resampler_fff_sptr self, float ph)
        Sets the current phase offset in radians (0 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_phase(self, ph)

    def phase(self) -> "float":
        r"""
        phase(pfb_arb_resampler_fff_sptr self) -> float
        Gets the current phase of the resampler in radians (2 to 2pi).
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_phase(self)

    def taps_per_filter(self) -> "unsigned int":
        r"""
        taps_per_filter(pfb_arb_resampler_fff_sptr self) -> unsigned int
        Gets the number of taps per filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_taps_per_filter(self)

    def interpolation_rate(self) -> "unsigned int":
        r"""
        interpolation_rate(pfb_arb_resampler_fff_sptr self) -> unsigned int
        Gets the interpolation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_interpolation_rate(self)

    def decimation_rate(self) -> "unsigned int":
        r"""
        decimation_rate(pfb_arb_resampler_fff_sptr self) -> unsigned int
        Gets the decimation rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_decimation_rate(self)

    def fractional_rate(self) -> "float":
        r"""
        fractional_rate(pfb_arb_resampler_fff_sptr self) -> float
        Gets the fractional rate of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_fractional_rate(self)

    def group_delay(self) -> "int":
        r"""
        group_delay(pfb_arb_resampler_fff_sptr self) -> int
        Get the group delay of the filter.
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_group_delay(self)

    def phase_offset(self, freq: "float", fs: "float") -> "float":
        r"""
        phase_offset(pfb_arb_resampler_fff_sptr self, float freq, float fs) -> float
        Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_phase_offset(self, freq, fs)

    def history(self) -> "unsigned int":
        r"""history(pfb_arb_resampler_fff_sptr self) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_arb_resampler_fff_sptr self, int which, int delay)
        declare_sample_delay(pfb_arb_resampler_fff_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_arb_resampler_fff_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_arb_resampler_fff_sptr self, int multiple)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_arb_resampler_fff_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_arb_resampler_fff_sptr self) -> double"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_arb_resampler_fff_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_arb_resampler_fff_sptr self) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_arb_resampler_fff_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_arb_resampler_fff_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_arb_resampler_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_arb_resampler_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_arb_resampler_fff_sptr self, std::string level)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_arb_resampler_fff_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_arb_resampler_fff_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_arb_resampler_fff_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_arb_resampler_fff_sptr self)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_arb_resampler_fff_sptr self) -> bool"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_arb_resampler_fff_sptr self, int m)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_arb_resampler_fff_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_arb_resampler_fff_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_arb_resampler_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_arb_resampler_fff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_arb_resampler_fff_sptr self, int i) -> long"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_arb_resampler_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_arb_resampler_fff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_input_buffers_full(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_output_buffers_full(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_arb_resampler_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_arb_resampler_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_arb_resampler_fff_sptr self) -> float"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_arb_resampler_fff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_arb_resampler_fff_sptr self)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_arb_resampler_fff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_arb_resampler_fff_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_arb_resampler_fff_sptr self) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_arb_resampler_fff_sptr self, int priority) -> int"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_arb_resampler_fff_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_arb_resampler_fff_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_arb_resampler_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_arb_resampler_fff_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_arb_resampler_fff_sptr self) -> long"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_arb_resampler_fff_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_arb_resampler_fff_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_arb_resampler_fff_sptr self) -> std::string"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_arb_resampler_fff_sptr self, std::string name)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_arb_resampler_fff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_arb_resampler_fff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_arb_resampler_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_arb_resampler_fff_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_arb_resampler_fff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_arb_resampler_fff_sptr_message_subscribers(self, which_port)

# Register pfb_arb_resampler_fff_sptr in _filter_swig:
_filter_swig.pfb_arb_resampler_fff_sptr_swigregister(pfb_arb_resampler_fff_sptr)

pfb_arb_resampler_fff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_arb_resampler_fff = pfb_arb_resampler_fff.make;

class pfb_channelizer_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_channelizer_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_channelizer_ccf_sptr self) -> pfb_channelizer_ccf_sptr
        __init__(pfb_channelizer_ccf_sptr self, pfb_channelizer_ccf p) -> pfb_channelizer_ccf_sptr
        """
        _filter_swig.pfb_channelizer_ccf_sptr_swiginit(self, _filter_swig.new_pfb_channelizer_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_channelizer_ccf *":
        r"""__deref__(pfb_channelizer_ccf_sptr self) -> pfb_channelizer_ccf"""
        return _filter_swig.pfb_channelizer_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_channelizer_ccf_sptr

    def make(self, numchans: "unsigned int", taps: "pmt_vector_float", oversample_rate: "float") -> "gr::filter::pfb_channelizer_ccf::sptr":
        r"""
        make(pfb_channelizer_ccf_sptr self, unsigned int numchans, pmt_vector_float taps, float oversample_rate) -> pfb_channelizer_ccf_sptr
        Polyphase filterbank channelizer with gr_complex input, gr_complex output and float taps.

        This block takes in complex inputs and channelizes it to  channels of equal bandwidth. Each of the resulting channels is decimated to the new rate that is the input sampling rate  divided by the number of channels, .


        The PFB channelizer code takes the taps generated above and builds a set of filters. The set contains filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        Each filter operates using the gr::blocks::fir_filter_XXX class of GNU Radio, which takes the input stream at  and performs the inner product calculation to  where  is the number of filter taps. To efficiently handle this in the GNU Radio structure, each filter input must come from its own input stream. So the channelizer must be provided with  streams where the input stream has been deinterleaved. This is most easily done using the gr::blocks::stream_to_streams block.


        The output is then produced as a vector, where index  in the vector is the next sample from the th channel. This is most easily handled by sending the output to a gr::blocks::vector_to_streams block to handle the conversion and passing  streams out.


        The input and output formatting is done using a hier_block2 called pfb_channelizer_ccf. This can take in a single stream and outputs  streams based on the behavior described above.


        The filter's taps should be based on the input sampling rate.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





        The filter output can also be oversampled. The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.


        For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz. A rate of 6/5 = 1.2, so the output rate would be 1200 Hz.


        The theory behind this block can be found in Chapter 6 of the following book:





        When dealing with oversampling, the above book is still a good reference along with this paper:

        Constructor Specific Documentation:

        Build the polyphase filterbank decimator. 
        For example, for 6 channels with fs = 6000 Hz, the normal rate is 6000/6 = 1000 Hz. Allowable oversampling rates are 6/6, 6/5, 6/4, 6/3, 6/2, and 6/1 where the output sample rate of a 6/1 oversample ratio is 6000 Hz, or 6 times the normal 1000 Hz.

        Args:
            numchans : (unsigned integer) Specifies the number of channels
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            oversample_rate : (float) The oversampling rate is the ratio of the the actual output sampling rate to the normal output sampling rate. It must be rationally related to the number of channels as N/i for i in [1,N], which gives an outputsample rate of [fs/N, fs] where fs is the input sample rate and N is the number of channels.
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_make(self, numchans, taps, oversample_rate)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_channelizer_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_channelizer_ccf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_channelizer_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_taps(self)

    def set_channel_map(self, map: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""
        set_channel_map(pfb_channelizer_ccf_sptr self, std::vector< int,std::allocator< int > > const & map)
        Set the channel map. Channels are numbers as: 


        So output stream 0 comes from channel 0, etc. Setting a new channel map allows the user to specify which channel in frequency he/she wants to got to which output stream.


        The map should have the same number of elements as the number of output connections from the block. The minimum value of the map is 0 (for the 0th channel) and the maximum number is N-1 where N is the number of channels.


        We specify M as the number of output connections made where M <= N, so only M out of N channels are driven to an output stream. The number of items in the channel map should be at least M long. If there are more channels specified, any value in the map over M-1 will be ignored. If the size of the map is less than M the behavior is unknown (we don't wish to check every entry into the work function).


        This means that if the channelizer is splitting the signal up into N channels but only M channels are specified in the map (where M <= N), then M output streams must be connected and the map and the channel numbers used must be less than N-1. Output channel number can be reused, too. By default, the map is [0...M-1] with M = N.
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_set_channel_map(self, map)

    def channel_map(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        channel_map(pfb_channelizer_ccf_sptr self) -> std::vector< int,std::allocator< int > >
        Gets the current channel map.
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_channel_map(self)

    def history(self) -> "unsigned int":
        r"""history(pfb_channelizer_ccf_sptr self) -> unsigned int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_channelizer_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_channelizer_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_channelizer_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_channelizer_ccf_sptr self, int multiple)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_channelizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_channelizer_ccf_sptr self) -> double"""
        return _filter_swig.pfb_channelizer_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_channelizer_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_channelizer_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_channelizer_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_channelizer_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_channelizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_channelizer_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_channelizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_channelizer_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_channelizer_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_channelizer_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_channelizer_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_channelizer_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_channelizer_ccf_sptr self, std::string level)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_channelizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_channelizer_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_channelizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_channelizer_ccf_sptr self, int m)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_channelizer_ccf_sptr self)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_channelizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_channelizer_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_channelizer_ccf_sptr self, int m)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_channelizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_channelizer_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_channelizer_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_channelizer_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_channelizer_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_channelizer_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_channelizer_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_channelizer_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_channelizer_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_channelizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_channelizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_channelizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_channelizer_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_channelizer_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_channelizer_ccf_sptr self)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_channelizer_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_channelizer_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_channelizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_channelizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_channelizer_ccf_sptr self, int priority) -> int"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_channelizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_channelizer_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_channelizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_channelizer_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_channelizer_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_channelizer_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_channelizer_ccf_sptr self) -> long"""
        return _filter_swig.pfb_channelizer_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_channelizer_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_channelizer_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_channelizer_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_channelizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_channelizer_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_channelizer_ccf_sptr self, std::string name)"""
        return _filter_swig.pfb_channelizer_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_channelizer_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_channelizer_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_channelizer_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_channelizer_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_channelizer_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_channelizer_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_channelizer_ccf_sptr in _filter_swig:
_filter_swig.pfb_channelizer_ccf_sptr_swigregister(pfb_channelizer_ccf_sptr)

pfb_channelizer_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_channelizer_ccf = pfb_channelizer_ccf.make;

class pfb_decimator_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_decimator_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_decimator_ccf_sptr self) -> pfb_decimator_ccf_sptr
        __init__(pfb_decimator_ccf_sptr self, pfb_decimator_ccf p) -> pfb_decimator_ccf_sptr
        """
        _filter_swig.pfb_decimator_ccf_sptr_swiginit(self, _filter_swig.new_pfb_decimator_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_decimator_ccf *":
        r"""__deref__(pfb_decimator_ccf_sptr self) -> pfb_decimator_ccf"""
        return _filter_swig.pfb_decimator_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_decimator_ccf_sptr

    def make(self, decim: "unsigned int", taps: "pmt_vector_float", channel: "unsigned int", use_fft_rotator: "bool"=True, use_fft_filters: "bool"=True) -> "gr::filter::pfb_decimator_ccf::sptr":
        r"""
        make(pfb_decimator_ccf_sptr self, unsigned int decim, pmt_vector_float taps, unsigned int channel, bool use_fft_rotator=True, bool use_fft_filters=True) -> pfb_decimator_ccf_sptr
        Polyphase filterbank bandpass decimator with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and performs integer down- sampling (decimation) with a polyphase filterbank. The first input is the integer specifying how much to decimate by. The second input is a vector (Python list) of floating-point taps of the prototype filter. The third input specifies the channel to extract. By default, the zeroth channel is used, which is the baseband channel (first Nyquist zone).


        The  parameter specifies which channel to use since this class is capable of bandpass decimation. Given a complex input stream at a sampling rate of  and a decimation rate of , the input frequency domain is split into  channels that represent the Nyquist zones. Using the polyphase filterbank, we can select any one of these channels to decimate.


        The output signal will be the basebanded and decimated signal from that channel. This concept is very similar to the PFB channelizer (see gr::filter::pfb_channelizer_ccf) where only a single channel is extracted at a time.


        The filter's taps should be based on the sampling rate before decimation.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





        The PFB decimator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        The theory behind this block can be found in Chapter 6 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank decimator.

        Args:
            decim : (unsigned integer) Specifies the decimation rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            channel : (unsigned integer) Selects the channel to return [default=0].
            use_fft_rotator : (bool) Rotate channels using FFT method instead of exp(phi). For larger values of , the FFT method will perform better. Generally, this value of  is small (~5), but could be architecture-specific (Default: true).
            use_fft_filters : (bool) Use FFT filters (fast convolution) instead of FIR filters. FFT filters perform better for larger numbers of taps but is architecture-specific (Default: true).
        """
        return _filter_swig.pfb_decimator_ccf_sptr_make(self, decim, taps, channel, use_fft_rotator, use_fft_filters)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_decimator_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_decimator_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_decimator_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_decimator_ccf_sptr_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_decimator_ccf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_decimator_ccf_sptr_print_taps(self)

    def set_channel(self, channel: "unsigned int const") -> "void":
        r"""set_channel(pfb_decimator_ccf_sptr self, unsigned int const channel)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_channel(self, channel)

    def history(self) -> "unsigned int":
        r"""history(pfb_decimator_ccf_sptr self) -> unsigned int"""
        return _filter_swig.pfb_decimator_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_decimator_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_decimator_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_decimator_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_decimator_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_decimator_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_decimator_ccf_sptr self, int multiple)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_decimator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_decimator_ccf_sptr self) -> double"""
        return _filter_swig.pfb_decimator_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_decimator_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_decimator_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_decimator_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_decimator_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_decimator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_decimator_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_decimator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_decimator_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_decimator_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_decimator_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_decimator_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_decimator_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_decimator_ccf_sptr self, std::string level)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_decimator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_decimator_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_decimator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_decimator_ccf_sptr self, int m)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_decimator_ccf_sptr self)"""
        return _filter_swig.pfb_decimator_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_decimator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_decimator_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_decimator_ccf_sptr self, int m)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_decimator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_decimator_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_decimator_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_decimator_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_decimator_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_decimator_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_decimator_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_decimator_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_decimator_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_decimator_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_decimator_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_decimator_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_decimator_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_decimator_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_decimator_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_decimator_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_decimator_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_decimator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_decimator_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_decimator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_decimator_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_decimator_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_decimator_ccf_sptr self)"""
        return _filter_swig.pfb_decimator_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_decimator_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_decimator_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_decimator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_decimator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_decimator_ccf_sptr self, int priority) -> int"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_decimator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_decimator_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_decimator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_decimator_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_decimator_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_decimator_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_decimator_ccf_sptr self) -> long"""
        return _filter_swig.pfb_decimator_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_decimator_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_decimator_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_decimator_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_decimator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_decimator_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_decimator_ccf_sptr self, std::string name)"""
        return _filter_swig.pfb_decimator_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_decimator_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_decimator_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_decimator_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_decimator_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_decimator_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_decimator_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_decimator_ccf_sptr in _filter_swig:
_filter_swig.pfb_decimator_ccf_sptr_swigregister(pfb_decimator_ccf_sptr)

pfb_decimator_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_decimator_ccf = pfb_decimator_ccf.make;

class pfb_interpolator_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_interpolator_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_interpolator_ccf_sptr self) -> pfb_interpolator_ccf_sptr
        __init__(pfb_interpolator_ccf_sptr self, pfb_interpolator_ccf p) -> pfb_interpolator_ccf_sptr
        """
        _filter_swig.pfb_interpolator_ccf_sptr_swiginit(self, _filter_swig.new_pfb_interpolator_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_interpolator_ccf *":
        r"""__deref__(pfb_interpolator_ccf_sptr self) -> pfb_interpolator_ccf"""
        return _filter_swig.pfb_interpolator_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_interpolator_ccf_sptr

    def make(self, interp: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::pfb_interpolator_ccf::sptr":
        r"""
        make(pfb_interpolator_ccf_sptr self, unsigned int interp, pmt_vector_float taps) -> pfb_interpolator_ccf_sptr
        Polyphase filterbank interpolator with gr_complex input, gr_complex output and float taps.

        This block takes in a signal stream and performs integer up- sampling (interpolation) with a polyphase filterbank. The first input is the integer specifying how much to interpolate by. The second input is a vector (Python list) of floating-point taps of the prototype filter.


        The filter's taps should be based on the interpolation rate specified. That is, the bandwidth specified is relative to the bandwidth after interpolation.


        For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, ATT, and the filter window function (a Blackman-harris window in this case). The first input is the gain, which is also specified as the interpolation rate so that the output levels are the same as the input (this creates an overall increase in power).





        The PFB interpolator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/interp) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


        The theory behind this block can be found in Chapter 7.1 of the following book:

        Constructor Specific Documentation:

        Build the polyphase filterbank interpolator.

        Args:
            interp : (unsigned integer) Specifies the interpolation rate to use
            taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the interpolated sampling rate.
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_make(self, interp, taps)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_interpolator_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_interpolator_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_taps(self)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_interpolator_ccf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_print_taps(self)

    def history(self) -> "unsigned int":
        r"""history(pfb_interpolator_ccf_sptr self) -> unsigned int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_interpolator_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_interpolator_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_interpolator_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_interpolator_ccf_sptr self, int multiple)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_interpolator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_interpolator_ccf_sptr self) -> double"""
        return _filter_swig.pfb_interpolator_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_interpolator_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_interpolator_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_interpolator_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_interpolator_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_interpolator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_interpolator_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_interpolator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_interpolator_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_interpolator_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_interpolator_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_interpolator_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_interpolator_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_interpolator_ccf_sptr self, std::string level)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_interpolator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_interpolator_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_interpolator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_interpolator_ccf_sptr self, int m)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_interpolator_ccf_sptr self)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_interpolator_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_interpolator_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_interpolator_ccf_sptr self, int m)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_interpolator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_interpolator_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_interpolator_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_interpolator_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_interpolator_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_interpolator_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_interpolator_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_interpolator_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_interpolator_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_interpolator_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_interpolator_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_interpolator_ccf_sptr self) -> float"""
        return _filter_swig.pfb_interpolator_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_interpolator_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_interpolator_ccf_sptr self)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_interpolator_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_interpolator_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_interpolator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_interpolator_ccf_sptr self) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_interpolator_ccf_sptr self, int priority) -> int"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_interpolator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_interpolator_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_interpolator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_interpolator_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_interpolator_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_interpolator_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_interpolator_ccf_sptr self) -> long"""
        return _filter_swig.pfb_interpolator_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_interpolator_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_interpolator_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_interpolator_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_interpolator_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_interpolator_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_interpolator_ccf_sptr self, std::string name)"""
        return _filter_swig.pfb_interpolator_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_interpolator_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_interpolator_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_interpolator_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_interpolator_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_interpolator_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_interpolator_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_interpolator_ccf_sptr in _filter_swig:
_filter_swig.pfb_interpolator_ccf_sptr_swigregister(pfb_interpolator_ccf_sptr)

pfb_interpolator_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_interpolator_ccf = pfb_interpolator_ccf.make;

class pfb_synthesizer_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::pfb_synthesizer_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_synthesizer_ccf_sptr self) -> pfb_synthesizer_ccf_sptr
        __init__(pfb_synthesizer_ccf_sptr self, pfb_synthesizer_ccf p) -> pfb_synthesizer_ccf_sptr
        """
        _filter_swig.pfb_synthesizer_ccf_sptr_swiginit(self, _filter_swig.new_pfb_synthesizer_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::pfb_synthesizer_ccf *":
        r"""__deref__(pfb_synthesizer_ccf_sptr self) -> pfb_synthesizer_ccf"""
        return _filter_swig.pfb_synthesizer_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_pfb_synthesizer_ccf_sptr

    def make(self, numchans: "unsigned int", taps: "pmt_vector_float", twox: "bool"=False) -> "gr::filter::pfb_synthesizer_ccf::sptr":
        r"""
        make(pfb_synthesizer_ccf_sptr self, unsigned int numchans, pmt_vector_float taps, bool twox=False) -> pfb_synthesizer_ccf_sptr
        Polyphase synthesis filterbank with gr_complex input, gr_complex output and float taps.

        The PFB synthesis filterbank combines multiple baseband signals into a single channelized signal. Each input stream is, essentially, modulated onto an output channel according the the channel mapping (see set_channel_map for details).


        Setting this filterbank up means selecting the number of output channels, the prototype filter, and whether to handle channels at 2x the sample rate (this is generally used only for reconstruction filtering).


        The number of channels sets the maximum number of channels to use, but not all input streams must be connected. For M total channels, we can connect inputs 0 to N where N < M-1. Because of the way GNU Radio handles stream connections, we must connect the channels consecutively, and so we must use the set_channel_map if the desired output channels are not the same as the the default mapping. This features gives us the flexibility to output to any given channel. Generally, we try to not use the channels at the edge of the spectrum to avoid issues with filtering and roll-off of the transmitter or receiver.


        When using the 2x sample rate mode, we specify the number of channels that will be used. However, the actual output signal will be twice this number of channels. This is mainly important to know when setting the channel map. For M channels, the channel mapping can specy from 0 to 2M-1 channels to output onto.


        For more details about this and the concepts of reconstruction filtering, see:

        Constructor Specific Documentation:

        Build the polyphase synthesis filterbank.

        Args:
            numchans : (unsigned integer) Specifies the number of channels
            taps : (vector/list of floats) The prototype filter to populate the filterbank.
            twox : (bool) use 2x oversampling or not (default is no)
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_make(self, numchans, taps, twox)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        set_taps(pfb_synthesizer_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_taps(self, taps)

    def print_taps(self) -> "void":
        r"""
        print_taps(pfb_synthesizer_ccf_sptr self)
        Print all of the filterbank taps to screen.
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_print_taps(self)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_synthesizer_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Return a vector<vector<>> of the filterbank taps
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_taps(self)

    def set_channel_map(self, map: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""
        set_channel_map(pfb_synthesizer_ccf_sptr self, std::vector< int,std::allocator< int > > const & map)
        Set the channel map. Channels are numbers as: 


        So input stream 0 goes to channel 0, etc. Setting a new channel map allows the user to specify where in frequency he/she wants the input stream to go. This is especially useful to avoid putting signals into the channels on the edge of the spectrum which can either wrap around (in the case of odd number of channels) and be affected by filter rolloff in the transmitter.


        The map must be at least the number of streams being sent to the block. Less and the algorithm will not have enough data to properly setup the buffers. Any more channels specified will be ignored.
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_channel_map(self, map)

    def channel_map(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        channel_map(pfb_synthesizer_ccf_sptr self) -> std::vector< int,std::allocator< int > >
        Gets the current channel map.
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_channel_map(self)

    def history(self) -> "unsigned int":
        r"""history(pfb_synthesizer_ccf_sptr self) -> unsigned int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_synthesizer_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_synthesizer_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_synthesizer_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_synthesizer_ccf_sptr self, int multiple)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_synthesizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_synthesizer_ccf_sptr self) -> double"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_synthesizer_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_synthesizer_ccf_sptr self) -> uint64_t"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_synthesizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_synthesizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_synthesizer_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_synthesizer_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_synthesizer_ccf_sptr self, std::string level)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_synthesizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_synthesizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_synthesizer_ccf_sptr self, int m)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_synthesizer_ccf_sptr self)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_synthesizer_ccf_sptr self) -> bool"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_synthesizer_ccf_sptr self, int m)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_synthesizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_synthesizer_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_synthesizer_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_synthesizer_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_synthesizer_ccf_sptr self, int i) -> long"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_synthesizer_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_synthesizer_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_synthesizer_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_synthesizer_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_synthesizer_ccf_sptr self) -> float"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_synthesizer_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_synthesizer_ccf_sptr self)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_synthesizer_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_synthesizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_synthesizer_ccf_sptr self) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_synthesizer_ccf_sptr self, int priority) -> int"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_synthesizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_synthesizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_synthesizer_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_synthesizer_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_synthesizer_ccf_sptr self) -> long"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_synthesizer_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_synthesizer_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_synthesizer_ccf_sptr self) -> std::string"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_synthesizer_ccf_sptr self, std::string name)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_synthesizer_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.pfb_synthesizer_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_synthesizer_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_synthesizer_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_synthesizer_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.pfb_synthesizer_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_synthesizer_ccf_sptr in _filter_swig:
_filter_swig.pfb_synthesizer_ccf_sptr_swigregister(pfb_synthesizer_ccf_sptr)

pfb_synthesizer_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_synthesizer_ccf = pfb_synthesizer_ccf.make;

class rational_resampler_base_ccc(object):
    r"""
    Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

    Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


    The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


    The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


    As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


    Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

    Constructor Specific Documentation:

    Make a rational resampling FIR filter.

    Args:
        interpolation : The integer interpolation rate of the filter
        decimation : The integer decimation rate of the filter
        taps : The filter taps to control images and aliases
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::rational_resampler_base< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(unsigned int interpolation, unsigned int decimation, pmt_vector_cfloat taps) -> rational_resampler_base_ccc_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_ccc_make(interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_ccc self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_ccc self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_decimation(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(rational_resampler_base_ccc self, pmt_vector_cfloat taps)"""
        return _filter_swig.rational_resampler_base_ccc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(rational_resampler_base_ccc self) -> pmt_vector_cfloat"""
        return _filter_swig.rational_resampler_base_ccc_taps(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_ccc

# Register rational_resampler_base_ccc in _filter_swig:
_filter_swig.rational_resampler_base_ccc_swigregister(rational_resampler_base_ccc)
class rational_resampler_base_ccc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::rational_resampler_base< gr_complex,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rational_resampler_base_ccc_sptr self) -> rational_resampler_base_ccc_sptr
        __init__(rational_resampler_base_ccc_sptr self, rational_resampler_base_ccc p) -> rational_resampler_base_ccc_sptr
        """
        _filter_swig.rational_resampler_base_ccc_sptr_swiginit(self, _filter_swig.new_rational_resampler_base_ccc_sptr(*args))

    def __deref__(self) -> "gr::filter::rational_resampler_base< gr_complex,gr_complex,gr_complex > *":
        r"""__deref__(rational_resampler_base_ccc_sptr self) -> rational_resampler_base_ccc"""
        return _filter_swig.rational_resampler_base_ccc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_ccc_sptr

    def make(self, interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::rational_resampler_base< std::complex< float >,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(rational_resampler_base_ccc_sptr self, unsigned int interpolation, unsigned int decimation, pmt_vector_cfloat taps) -> rational_resampler_base_ccc_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_make(self, interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_ccc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_ccc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_decimation(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(rational_resampler_base_ccc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(rational_resampler_base_ccc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.rational_resampler_base_ccc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(rational_resampler_base_ccc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rational_resampler_base_ccc_sptr self, int which, int delay)
        declare_sample_delay(rational_resampler_base_ccc_sptr self, unsigned int delay)
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rational_resampler_base_ccc_sptr self, int which) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rational_resampler_base_ccc_sptr self, int multiple)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rational_resampler_base_ccc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rational_resampler_base_ccc_sptr self) -> double"""
        return _filter_swig.rational_resampler_base_ccc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rational_resampler_base_ccc_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rational_resampler_base_ccc_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rational_resampler_base_ccc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rational_resampler_base_ccc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rational_resampler_base_ccc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rational_resampler_base_ccc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rational_resampler_base_ccc_sptr self, std::string level)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rational_resampler_base_ccc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rational_resampler_base_ccc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rational_resampler_base_ccc_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rational_resampler_base_ccc_sptr self)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rational_resampler_base_ccc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rational_resampler_base_ccc_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rational_resampler_base_ccc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rational_resampler_base_ccc_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_ccc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rational_resampler_base_ccc_sptr self, long max_output_buffer)
        set_max_output_buffer(rational_resampler_base_ccc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rational_resampler_base_ccc_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_ccc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rational_resampler_base_ccc_sptr self, long min_output_buffer)
        set_min_output_buffer(rational_resampler_base_ccc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_input_buffers_full(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_input_buffers_full_avg(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_input_buffers_full_var(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_output_buffers_full(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_output_buffers_full_avg(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rational_resampler_base_ccc_sptr self, int which) -> float
        pc_output_buffers_full_var(rational_resampler_base_ccc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(rational_resampler_base_ccc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(rational_resampler_base_ccc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(rational_resampler_base_ccc_sptr self)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(rational_resampler_base_ccc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.rational_resampler_base_ccc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(rational_resampler_base_ccc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(rational_resampler_base_ccc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(rational_resampler_base_ccc_sptr self, int priority) -> int"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(rational_resampler_base_ccc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(rational_resampler_base_ccc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(rational_resampler_base_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(rational_resampler_base_ccc_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(rational_resampler_base_ccc_sptr self) -> long"""
        return _filter_swig.rational_resampler_base_ccc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(rational_resampler_base_ccc_sptr self) -> basic_block_sptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(rational_resampler_base_ccc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.rational_resampler_base_ccc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(rational_resampler_base_ccc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(rational_resampler_base_ccc_sptr self, std::string name)"""
        return _filter_swig.rational_resampler_base_ccc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(rational_resampler_base_ccc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.rational_resampler_base_ccc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(rational_resampler_base_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(rational_resampler_base_ccc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(rational_resampler_base_ccc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccc_sptr_message_subscribers(self, which_port)

# Register rational_resampler_base_ccc_sptr in _filter_swig:
_filter_swig.rational_resampler_base_ccc_sptr_swigregister(rational_resampler_base_ccc_sptr)

rational_resampler_base_ccc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
rational_resampler_base_ccc = rational_resampler_base_ccc.make

class rational_resampler_base_ccf(object):
    r"""
    Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

    Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


    The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


    The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


    As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


    Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

    Constructor Specific Documentation:

    Make a rational resampling FIR filter.

    Args:
        interpolation : The integer interpolation rate of the filter
        decimation : The integer decimation rate of the filter
        taps : The filter taps to control images and aliases
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::rational_resampler_base< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(unsigned int interpolation, unsigned int decimation, pmt_vector_float taps) -> rational_resampler_base_ccf_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_ccf_make(interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_ccf self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_ccf self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_decimation(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(rational_resampler_base_ccf self, pmt_vector_float taps)"""
        return _filter_swig.rational_resampler_base_ccf_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(rational_resampler_base_ccf self) -> pmt_vector_float"""
        return _filter_swig.rational_resampler_base_ccf_taps(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_ccf

# Register rational_resampler_base_ccf in _filter_swig:
_filter_swig.rational_resampler_base_ccf_swigregister(rational_resampler_base_ccf)
class rational_resampler_base_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::rational_resampler_base< gr_complex,gr_complex,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rational_resampler_base_ccf_sptr self) -> rational_resampler_base_ccf_sptr
        __init__(rational_resampler_base_ccf_sptr self, rational_resampler_base_ccf p) -> rational_resampler_base_ccf_sptr
        """
        _filter_swig.rational_resampler_base_ccf_sptr_swiginit(self, _filter_swig.new_rational_resampler_base_ccf_sptr(*args))

    def __deref__(self) -> "gr::filter::rational_resampler_base< gr_complex,gr_complex,float > *":
        r"""__deref__(rational_resampler_base_ccf_sptr self) -> rational_resampler_base_ccf"""
        return _filter_swig.rational_resampler_base_ccf_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_ccf_sptr

    def make(self, interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::rational_resampler_base< std::complex< float >,std::complex< float >,float >::sptr":
        r"""
        make(rational_resampler_base_ccf_sptr self, unsigned int interpolation, unsigned int decimation, pmt_vector_float taps) -> rational_resampler_base_ccf_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_make(self, interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_ccf_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_ccf_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_decimation(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(rational_resampler_base_ccf_sptr self, pmt_vector_float taps)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(rational_resampler_base_ccf_sptr self) -> pmt_vector_float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(rational_resampler_base_ccf_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rational_resampler_base_ccf_sptr self, int which, int delay)
        declare_sample_delay(rational_resampler_base_ccf_sptr self, unsigned int delay)
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rational_resampler_base_ccf_sptr self, int which) -> unsigned int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rational_resampler_base_ccf_sptr self, int multiple)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rational_resampler_base_ccf_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rational_resampler_base_ccf_sptr self) -> double"""
        return _filter_swig.rational_resampler_base_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rational_resampler_base_ccf_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rational_resampler_base_ccf_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rational_resampler_base_ccf_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rational_resampler_base_ccf_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rational_resampler_base_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rational_resampler_base_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.rational_resampler_base_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rational_resampler_base_ccf_sptr self, std::string level)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rational_resampler_base_ccf_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rational_resampler_base_ccf_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rational_resampler_base_ccf_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rational_resampler_base_ccf_sptr self)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rational_resampler_base_ccf_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rational_resampler_base_ccf_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rational_resampler_base_ccf_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rational_resampler_base_ccf_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rational_resampler_base_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(rational_resampler_base_ccf_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rational_resampler_base_ccf_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rational_resampler_base_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(rational_resampler_base_ccf_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_input_buffers_full(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_output_buffers_full(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rational_resampler_base_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(rational_resampler_base_ccf_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(rational_resampler_base_ccf_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(rational_resampler_base_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(rational_resampler_base_ccf_sptr self)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(rational_resampler_base_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.rational_resampler_base_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(rational_resampler_base_ccf_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(rational_resampler_base_ccf_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(rational_resampler_base_ccf_sptr self, int priority) -> int"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(rational_resampler_base_ccf_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(rational_resampler_base_ccf_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(rational_resampler_base_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(rational_resampler_base_ccf_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(rational_resampler_base_ccf_sptr self) -> long"""
        return _filter_swig.rational_resampler_base_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(rational_resampler_base_ccf_sptr self) -> basic_block_sptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(rational_resampler_base_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.rational_resampler_base_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(rational_resampler_base_ccf_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(rational_resampler_base_ccf_sptr self, std::string name)"""
        return _filter_swig.rational_resampler_base_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(rational_resampler_base_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.rational_resampler_base_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(rational_resampler_base_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(rational_resampler_base_ccf_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(rational_resampler_base_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_ccf_sptr_message_subscribers(self, which_port)

# Register rational_resampler_base_ccf_sptr in _filter_swig:
_filter_swig.rational_resampler_base_ccf_sptr_swigregister(rational_resampler_base_ccf_sptr)

rational_resampler_base_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
rational_resampler_base_ccf = rational_resampler_base_ccf.make

class rational_resampler_base_fcc(object):
    r"""
    Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

    Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


    The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


    The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


    As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


    Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

    Constructor Specific Documentation:

    Make a rational resampling FIR filter.

    Args:
        interpolation : The integer interpolation rate of the filter
        decimation : The integer decimation rate of the filter
        taps : The filter taps to control images and aliases
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::rational_resampler_base< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(unsigned int interpolation, unsigned int decimation, pmt_vector_cfloat taps) -> rational_resampler_base_fcc_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_fcc_make(interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_fcc self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_fcc self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_decimation(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(rational_resampler_base_fcc self, pmt_vector_cfloat taps)"""
        return _filter_swig.rational_resampler_base_fcc_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(rational_resampler_base_fcc self) -> pmt_vector_cfloat"""
        return _filter_swig.rational_resampler_base_fcc_taps(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_fcc

# Register rational_resampler_base_fcc in _filter_swig:
_filter_swig.rational_resampler_base_fcc_swigregister(rational_resampler_base_fcc)
class rational_resampler_base_fcc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::rational_resampler_base< float,gr_complex,gr_complex > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rational_resampler_base_fcc_sptr self) -> rational_resampler_base_fcc_sptr
        __init__(rational_resampler_base_fcc_sptr self, rational_resampler_base_fcc p) -> rational_resampler_base_fcc_sptr
        """
        _filter_swig.rational_resampler_base_fcc_sptr_swiginit(self, _filter_swig.new_rational_resampler_base_fcc_sptr(*args))

    def __deref__(self) -> "gr::filter::rational_resampler_base< float,gr_complex,gr_complex > *":
        r"""__deref__(rational_resampler_base_fcc_sptr self) -> rational_resampler_base_fcc"""
        return _filter_swig.rational_resampler_base_fcc_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_fcc_sptr

    def make(self, interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_cfloat") -> "gr::filter::rational_resampler_base< float,std::complex< float >,std::complex< float > >::sptr":
        r"""
        make(rational_resampler_base_fcc_sptr self, unsigned int interpolation, unsigned int decimation, pmt_vector_cfloat taps) -> rational_resampler_base_fcc_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_make(self, interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_fcc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_fcc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_decimation(self)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(rational_resampler_base_fcc_sptr self, pmt_vector_cfloat taps)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< std::complex< float >,std::allocator< std::complex< float > > >":
        r"""taps(rational_resampler_base_fcc_sptr self) -> pmt_vector_cfloat"""
        return _filter_swig.rational_resampler_base_fcc_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(rational_resampler_base_fcc_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rational_resampler_base_fcc_sptr self, int which, int delay)
        declare_sample_delay(rational_resampler_base_fcc_sptr self, unsigned int delay)
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rational_resampler_base_fcc_sptr self, int which) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rational_resampler_base_fcc_sptr self, int multiple)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rational_resampler_base_fcc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rational_resampler_base_fcc_sptr self) -> double"""
        return _filter_swig.rational_resampler_base_fcc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rational_resampler_base_fcc_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fcc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rational_resampler_base_fcc_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fcc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rational_resampler_base_fcc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fcc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rational_resampler_base_fcc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fcc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rational_resampler_base_fcc_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fcc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rational_resampler_base_fcc_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fcc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rational_resampler_base_fcc_sptr self, std::string level)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rational_resampler_base_fcc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_fcc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rational_resampler_base_fcc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rational_resampler_base_fcc_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rational_resampler_base_fcc_sptr self)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rational_resampler_base_fcc_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fcc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rational_resampler_base_fcc_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rational_resampler_base_fcc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rational_resampler_base_fcc_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_fcc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rational_resampler_base_fcc_sptr self, long max_output_buffer)
        set_max_output_buffer(rational_resampler_base_fcc_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rational_resampler_base_fcc_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_fcc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rational_resampler_base_fcc_sptr self, long min_output_buffer)
        set_min_output_buffer(rational_resampler_base_fcc_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_input_buffers_full(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_input_buffers_full_avg(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_input_buffers_full_var(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_output_buffers_full(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_output_buffers_full_avg(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rational_resampler_base_fcc_sptr self, int which) -> float
        pc_output_buffers_full_var(rational_resampler_base_fcc_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(rational_resampler_base_fcc_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fcc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(rational_resampler_base_fcc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(rational_resampler_base_fcc_sptr self)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(rational_resampler_base_fcc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _filter_swig.rational_resampler_base_fcc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(rational_resampler_base_fcc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(rational_resampler_base_fcc_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(rational_resampler_base_fcc_sptr self, int priority) -> int"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(rational_resampler_base_fcc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_fcc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(rational_resampler_base_fcc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_fcc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(rational_resampler_base_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(rational_resampler_base_fcc_sptr self) -> io_signature_sptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(rational_resampler_base_fcc_sptr self) -> long"""
        return _filter_swig.rational_resampler_base_fcc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(rational_resampler_base_fcc_sptr self) -> basic_block_sptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(rational_resampler_base_fcc_sptr self, int ninputs, int noutputs) -> bool"""
        return _filter_swig.rational_resampler_base_fcc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(rational_resampler_base_fcc_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_fcc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(rational_resampler_base_fcc_sptr self, std::string name)"""
        return _filter_swig.rational_resampler_base_fcc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(rational_resampler_base_fcc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _filter_swig.rational_resampler_base_fcc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(rational_resampler_base_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(rational_resampler_base_fcc_sptr self) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(rational_resampler_base_fcc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _filter_swig.rational_resampler_base_fcc_sptr_message_subscribers(self, which_port)

# Register rational_resampler_base_fcc_sptr in _filter_swig:
_filter_swig.rational_resampler_base_fcc_sptr_swigregister(rational_resampler_base_fcc_sptr)

rational_resampler_base_fcc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
rational_resampler_base_fcc = rational_resampler_base_fcc.make

class rational_resampler_base_fff(object):
    r"""
    Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

    Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


    The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


    The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


    As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


    Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

    Constructor Specific Documentation:

    Make a rational resampling FIR filter.

    Args:
        interpolation : The integer interpolation rate of the filter
        decimation : The integer decimation rate of the filter
        taps : The filter taps to control images and aliases
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::rational_resampler_base< float,float,float >::sptr":
        r"""
        make(unsigned int interpolation, unsigned int decimation, pmt_vector_float taps) -> rational_resampler_base_fff_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_fff_make(interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_fff self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_fff self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_decimation(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(rational_resampler_base_fff self, pmt_vector_float taps)"""
        return _filter_swig.rational_resampler_base_fff_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(rational_resampler_base_fff self) -> pmt_vector_float"""
        return _filter_swig.rational_resampler_base_fff_taps(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_fff

# Register rational_resampler_base_fff in _filter_swig:
_filter_swig.rational_resampler_base_fff_swigregister(rational_resampler_base_fff)
class rational_resampler_base_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::filter::rational_resampler_base< float,float,float > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(rational_resampler_base_fff_sptr self) -> rational_resampler_base_fff_sptr
        __init__(rational_resampler_base_fff_sptr self, rational_resampler_base_fff p) -> rational_resampler_base_fff_sptr
        """
        _filter_swig.rational_resampler_base_fff_sptr_swiginit(self, _filter_swig.new_rational_resampler_base_fff_sptr(*args))

    def __deref__(self) -> "gr::filter::rational_resampler_base< float,float,float > *":
        r"""__deref__(rational_resampler_base_fff_sptr self) -> rational_resampler_base_fff"""
        return _filter_swig.rational_resampler_base_fff_sptr___deref__(self)
    __swig_destroy__ = _filter_swig.delete_rational_resampler_base_fff_sptr

    def make(self, interpolation: "unsigned int", decimation: "unsigned int", taps: "pmt_vector_float") -> "gr::filter::rational_resampler_base< float,float,float >::sptr":
        r"""
        make(rational_resampler_base_fff_sptr self, unsigned int interpolation, unsigned int decimation, pmt_vector_float taps) -> rational_resampler_base_fff_sptr
        Rational Resampling Polyphase FIR filter with IN_T input, OUT_T output and TAP_T taps.

        Make a rational resampling FIR filter. If the input signal is at rate fs, then the output signal will be at a rate of  * fs / .


        The interpolation and decimation rates should be kept as small as possible, and generally should be relatively prime to help reduce complexity in memory and computation.


        The set of  supplied to this filterbank should be designed around the resampling amount and must avoid aliasing (when interpolation/decimation < 1) and images (when interpolation/decimation > 1).


        As with any filter, the behavior of the filter taps (or coefficients) is determined by the highest sampling rate that the filter will ever see. In the case of a resampler that increases the sampling rate, the highest sampling rate observed is  since in the filterbank, the number of filter arms is equal to . When the resampler decreases the sampling rate (decimation > interpolation), then the highest rate is the input sample rate of the original signal. We must create a filter based around this value to reduce any aliasing that may occur from out-of-band signals.


        Another way to think about how to create the filter taps is that the filter is effectively applied after interpolation and before decimation. And yet another way to think of it is that the taps should be a LPF that is at least as narrow as the narrower of the required anti-image postfilter or anti-alias prefilter.

        Constructor Specific Documentation:

        Make a rational resampling FIR filter.

        Args:
            interpolation : The integer interpolation rate of the filter
            decimation : The integer decimation rate of the filter
            taps : The filter taps to control images and aliases
        """
        return _filter_swig.rational_resampler_base_fff_sptr_make(self, interpolation, decimation, taps)

    def interpolation(self) -> "unsigned int":
        r"""interpolation(rational_resampler_base_fff_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_sptr_interpolation(self)

    def decimation(self) -> "unsigned int":
        r"""decimation(rational_resampler_base_fff_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_sptr_decimation(self)

    def set_taps(self, taps: "pmt_vector_float") -> "void":
        r"""set_taps(rational_resampler_base_fff_sptr self, pmt_vector_float taps)"""
        return _filter_swig.rational_resampler_base_fff_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""taps(rational_resampler_base_fff_sptr self) -> pmt_vector_float"""
        return _filter_swig.rational_resampler_base_fff_sptr_taps(self)

    def history(self) -> "unsigned int":
        r"""history(rational_resampler_base_fff_sptr self) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(rational_resampler_base_fff_sptr self, int which, int delay)
        declare_sample_delay(rational_resampler_base_fff_sptr self, unsigned int delay)
        """
        return _filter_swig.rational_resampler_base_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(rational_resampler_base_fff_sptr self, int which) -> unsigned int"""
        return _filter_swig.rational_resampler_base_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(rational_resampler_base_fff_sptr self, int multiple)"""
        return _filter_swig.rational_resampler_base_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(rational_resampler_base_fff_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(rational_resampler_base_fff_sptr self) -> double"""
        return _filter_swig.rational_resampler_base_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(rational_resampler_base_fff_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(rational_resampler_base_fff_sptr self) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(rational_resampler_base_fff_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(rational_resampler_base_fff_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(rational_resampler_base_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(rational_resampler_base_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _filter_swig.rational_resampler_base_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(rational_resampler_base_fff_sptr self, std::string level)"""
        return _filter_swig.rational_resampler_base_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(rational_resampler_base_fff_sptr self) -> std::string"""
        return _filter_swig.rational_resampler_base_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(rational_resampler_base_fff_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(rational_resampler_base_fff_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(rational_resampler_base_fff_sptr self)"""
        return _filter_swig.rational_resampler_base_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(rational_resampler_base_fff_sptr self) -> bool"""
        return _filter_swig.rational_resampler_base_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(rational_resampler_base_fff_sptr self, int m)"""
        return _filter_swig.rational_resampler_base_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(rational_resampler_base_fff_sptr self) -> int"""
        return _filter_swig.rational_resampler_base_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(rational_resampler_base_fff_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(rational_resampler_base_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(rational_resampler_base_fff_sptr self, int port, long max_output_buffer)
        """
        return _filter_swig.rational_resampler_base_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(rational_resampler_base_fff_sptr self, int i) -> long"""
        return _filter_swig.rational_resampler_base_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(rational_resampler_base_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(rational_resampler_base_fff_sptr self, int port, long min_output_buffer)
        """
        return _filter_swig.rational_resampler_base_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(rational_resampler_base_fff_sptr self) -> float"""
        return _filter_swig.rational_resampler_base_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(rational_resampler_base_fff_sptr self, int which) -> float
        pc_input_buffers_full(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(rational_resampler_base_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(rational_resampler_base_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(rational_resampler_base_fff_sptr self, int which) -> float
        pc_output_buffers_full(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(rational_resampler_base_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(rational_resampler_base_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(rational_resampler_base_fff_sptr self) -> pmt_vector_float
        """
        return _filter_swig.rational_resampler_base_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(rational_resampler