/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMustUseReturnValueStatusComponentKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0006H\u0002\u001a!\u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u000eH\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"JAVA_LANG_VOID", "Lorg/jetbrains/kotlin/name/ClassId;", "isIgnorable", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isExcluded", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isSubjectToCheck", "ifMappedTypeCollection", "", "Lorg/jetbrains/kotlin/name/CallableId;", "nonIgnorableCollectionMethod", "Lkotlin/Function1;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n1#1,195:1\n161#1,34:196\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n148#1:196,34\n*E\n"})
public final class FirUnusedReturnValueCheckerKt {
    @NotNull
    private static final ClassId JAVA_LANG_VOID = ClassId.Companion.topLevel(new FqName("java.lang.Void"));

    private static final boolean isIgnorable(ConeKotlinType $this$isIgnorable) {
        ClassId classId = ConeTypeUtilsKt.getClassId($this$isIgnorable);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getNothing())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getUnit()) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable)) {
            return true;
        }
        return Intrinsics.areEqual((Object)classId2, (Object)JAVA_LANG_VOID) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable);
    }

    private static final boolean isExcluded(FirCallableSymbol<?> $this$isExcluded, FirSession session) {
        return FirMustUseReturnValueStatusComponentKt.getMustUseReturnValueStatusComponent(session).hasIgnorableLikeAnnotation($this$isExcluded.getResolvedAnnotationClassIds());
    }

    private static final boolean isSubjectToCheck(FirCallableSymbol<?> $this$isSubjectToCheck) {
        Object object = $this$isSubjectToCheck.getCallableId();
        if (Intrinsics.areEqual((Object)(object != null && (object = ((CallableId)object).getPackageName()) != null ? ((FqName)object).asString() : null), (Object)"kotlin")) {
            return !($this$isSubjectToCheck.getOrigin() instanceof FirDeclarationOrigin.Enhancement);
        }
        CallableId callableId = $this$isSubjectToCheck.getCallableId();
        if (callableId != null) {
            Object object2;
            CallableId $this$ifMappedTypeCollection$iv = callableId;
            boolean $i$f$ifMappedTypeCollection = false;
            String packageName$iv = $this$ifMappedTypeCollection$iv.getPackageName().asString();
            if ((Intrinsics.areEqual((Object)packageName$iv, (Object)"kotlin.collections") || Intrinsics.areEqual((Object)packageName$iv, (Object)"java.util")) && (object2 = $this$ifMappedTypeCollection$iv.getClassName()) != null && (object2 = ((FqName)object2).asString()) != null) {
                Object className$iv = object2;
                Object[] objectArray = new String[]{"Collection", "MutableCollection", "List", "MutableList", "ArrayList", "Set", "MutableSet", "HashSet", "LinkedHashSet", "Map", "MutableMap", "HashMap", "LinkedHashMap", "ArrayDeque"};
                if (SetsKt.setOf((Object[])objectArray).contains(className$iv)) {
                    objectArray = new String[]{"add", "addAll", "remove", "removeAt", "removeAll", "set", "put", "retainAll", "removeLast"};
                    boolean it = !SetsKt.setOf((Object[])objectArray).contains($this$ifMappedTypeCollection$iv.getCallableName().asString());
                    boolean bl = false;
                    return it;
                }
            }
        }
        if ($this$isSubjectToCheck instanceof FirEnumEntrySymbol) {
            return true;
        }
        return $this$isSubjectToCheck.getResolvedStatus().getHasMustUseReturnValue();
    }

    public static final /* synthetic */ boolean access$isIgnorable(ConeKotlinType $receiver) {
        return FirUnusedReturnValueCheckerKt.isIgnorable($receiver);
    }

    public static final /* synthetic */ boolean access$isSubjectToCheck(FirCallableSymbol $receiver) {
        return FirUnusedReturnValueCheckerKt.isSubjectToCheck($receiver);
    }

    public static final /* synthetic */ boolean access$isExcluded(FirCallableSymbol $receiver, FirSession session) {
        return FirUnusedReturnValueCheckerKt.isExcluded($receiver, session);
    }
}

