/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.Set;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.internal.Colorizer;
import org.kordamp.jarviz.core.model.Checksum;
import org.kordamp.jarviz.core.processors.ChecksumJarProcessor;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.util.StringUtils;

public class ChecksumCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ChecksumJarProcessor processor = new ChecksumJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<Set<Checksum>>> results = processor.getResult();
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Set<Checksum>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Set<Checksum>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Set<Checksum>> result) {
        configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
        result.getResult().forEach(checksum -> {
            String extension = StringUtils.padRight(checksum.getAlgorithm().extension(), 7);
            configuration.getOut().println(result.getJarFileName() + extension + " " + this.colorize(checksum.getOutcome()));
        });
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Set<Checksum>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Set<Checksum>> result : results) {
                this.buildReport(root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Node root, JarProcessor.JarFileResult<Set<Checksum>> result) {
        this.appendSubject(root, result.getJarPath(), "checksum", resultNode -> {
            Node checksums = resultNode.array(RB.$("report.key.checksums", new Object[0]));
            for (Checksum checksum : (Set)result.getResult()) {
                checksums.collapsable(RB.$("report.key.checksum", new Object[0])).node(RB.$("report.key.algorithm", new Object[0])).value(checksum.getAlgorithm().formatted()).end().node(RB.$("report.key.outcome", new Object[0])).value((Object)checksum.getOutcome()).end();
            }
        });
    }

    private String colorize(Checksum.Outcome outcome) {
        switch (outcome) {
            case SUCCESS: {
                return Colorizer.green(outcome.toString());
            }
            case FAILURE: {
                return Colorizer.red(outcome.toString());
            }
            case UNAVAILABLE: {
                return Colorizer.cyan(outcome.toString());
            }
        }
        return "";
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
    }
}

