/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.JarUtils;
import org.kordamp.jarviz.util.StringUtils;

public class ServicesShowJarProcessor
implements JarProcessor<Optional<Set<String>>> {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final JarFileResolver jarFileResolver;
    private Integer release;
    private String serviceName;

    public ServicesShowJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    public Integer getRelease() {
        return this.release;
    }

    public void setRelease(Integer release) {
        this.release = release;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Optional<Set<String>>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Optional<Set<String>>>> set = new TreeSet<JarProcessor.JarFileResult<Optional<Set<String>>>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<Optional<Set<String>>> processJarFile(JarFile jarFile) {
        JarProcessor.JarFileResult<Optional<Set<String>>> jarFileResult;
        block9: {
            TreeSet services = new TreeSet();
            boolean foundServices = false;
            String target = META_INF_SERVICES + this.serviceName;
            JarFile jarFile2 = jarFile;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.equals(target)) continue;
                    foundServices = true;
                    services.addAll(JarUtils.withJarEntry(jarFile, entry, inputStream -> new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).lines().filter(s -> StringUtils.isNotBlank(s) && !s.startsWith("#")).collect(Collectors.toSet())));
                    break;
                }
                jarFileResult = JarProcessor.JarFileResult.of(jarFile, foundServices ? Optional.of(Collections.unmodifiableSet(services)) : Optional.empty());
                if (jarFile2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile2 != null) {
                        try {
                            jarFile2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return JarProcessor.JarFileResult.of(jarFile, foundServices ? Optional.of(Collections.unmodifiableSet(services)) : Optional.empty());
                }
            }
            jarFile2.close();
        }
        return jarFileResult;
    }
}

