/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.resolvers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.jar.JarFile;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class PathBasedJarFileResolver
implements JarFileResolver {
    private final Path file;
    private JarFile jarFile;

    public PathBasedJarFileResolver(Path file) {
        this.file = file;
    }

    @Override
    public Set<JarFile> resolveJarFiles() {
        if (null != this.jarFile) {
            return Collections.singleton(this.jarFile);
        }
        if (Files.notExists(this.file, new LinkOption[0])) {
            throw new JarvizException(RB.$("ERROR_PATH_DOES_NOT_EXIST", this.file.toAbsolutePath()));
        }
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_A_FILE", this.file.toAbsolutePath()));
        }
        if (!Files.isReadable(this.file)) {
            throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_READABLE", this.file.toAbsolutePath()));
        }
        if (!this.file.getFileName().toString().endsWith(".jar")) {
            throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_JAR", this.file.toAbsolutePath()));
        }
        try {
            this.jarFile = new JarFile(this.file.toFile());
            return Collections.singleton(this.jarFile);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_OPENING_JAR", this.file.toAbsolutePath()));
        }
    }
}

