/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.model.BytecodeVersion;

public class JarUtils {
    public static Optional<Manifest> getManifest(JarFile jarFile) {
        try {
            return Optional.ofNullable(jarFile.getManifest());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static <T> T withJarEntry(JarFile jarFile, JarEntry entry, IOFunction<InputStream, T> consumer) throws IOException {
        try (InputStream is = jarFile.getInputStream(entry);){
            T t = consumer.apply(is);
            return t;
        }
    }

    public static BytecodeVersion readBytecodeVersion(JarFile jarFile, JarEntry entry) {
        try {
            return JarUtils.withJarEntry(jarFile, entry, inputStream -> {
                try (DataInputStream data = new DataInputStream((InputStream)inputStream);){
                    if (-889275714 != data.readInt()) {
                        throw new EOFException(jarFile.getName());
                    }
                    int minor = data.readUnsignedShort();
                    int major = data.readUnsignedShort();
                    BytecodeVersion bytecodeVersion = BytecodeVersion.of(major, minor);
                    return bytecodeVersion;
                }
            });
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_READING_JAR_ENTRY", entry.getName(), jarFile.getName()));
        }
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

