/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.JarAnalyzer;
import org.kordamp.jarviz.core.analyzers.ModuleNameJarPathAnalyzer;
import org.kordamp.jarviz.core.analyzers.QueryJarManifestAnalyzer;
import org.kordamp.jarviz.core.model.ModuleName;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.JarUtils;

public class ModuleNameJarProcessor
implements JarProcessor<ModuleName> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("-(\\d+(\\.|$))");
    private final JarFileResolver jarFileResolver;

    public ModuleNameJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<ModuleName>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<ModuleName>> set = new TreeSet<JarProcessor.JarFileResult<ModuleName>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    JarProcessor.JarFileResult<ModuleName> processJarFile(JarFile jarFile) {
        JarAnalyzer<Optional<String>> analyzer;
        Path jarPath = Paths.get(jarFile.getName(), new String[0]);
        String automaticModuleNameByFilename = this.deriveModuleNameFromFilename(jarPath.getFileName().toString());
        String automaticModuleNameByManifest = null;
        Optional<Manifest> manifest = JarUtils.getManifest(jarFile);
        if (manifest.isPresent()) {
            analyzer = new QueryJarManifestAnalyzer("Automatic-Module-Name");
            ((QueryJarManifestAnalyzer)analyzer).handle(jarFile, manifest.get());
            automaticModuleNameByManifest = ((Optional)((QueryJarManifestAnalyzer)analyzer).getResult()).orElse(null);
        }
        analyzer = new ModuleNameJarPathAnalyzer(automaticModuleNameByManifest, automaticModuleNameByFilename);
        ((ModuleNameJarPathAnalyzer)analyzer).handle(jarPath);
        return JarProcessor.JarFileResult.of(jarFile, ((ModuleNameJarPathAnalyzer)analyzer).getResult());
    }

    private String deriveModuleNameFromFilename(String filename) {
        String name = filename.substring(0, filename.length() - 4);
        Matcher matcher = VERSION_PATTERN.matcher(name);
        if (matcher.find()) {
            name = name.substring(0, matcher.start());
        }
        return name.replaceAll("[^A-Za-z0-9]", ".");
    }
}

