/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import org.kordamp.jarviz.reporting.Formatter;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.Report;
import org.kordamp.jarviz.util.StringUtils;

public class JsonFormatter
extends Formatter {
    public static final JsonFormatter INSTANCE = new JsonFormatter();
    private static final char OPEN_STRUCT = '{';
    private static final char CLOSE_STRUCT = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char QUOTES = '\"';
    private static final String COLON = ":";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final char COMMA = ',';

    private JsonFormatter() {
    }

    @Override
    public String write(Node node) {
        Report report = new Report().append('{').newLine();
        this.appendChildren(report, node);
        report.append('}').newLine();
        return report.toString();
    }

    @Override
    protected void append(Report report, Node node) {
        if (StringUtils.isBlank(node.getValue()) && node.getChildren().isEmpty()) {
            report.indent(this.indentationFor(node)).append(this.quote(node.getName()));
            return;
        }
        if (!node.isCollapsable()) {
            report.indent(this.indentationFor(node)).append(this.quote(node.getName())).append(COLON).append(" ");
        } else {
            report.indent(this.indentationFor(node));
        }
        if (StringUtils.isNotBlank(node.getValue())) {
            report.append(this.formatValue(node));
        } else if (!node.getChildren().isEmpty()) {
            report.append(node.isArray() ? (char)'[' : '{').newLine();
            this.appendChildren(report, node);
            report.indent(this.indentationFor(node)).append(node.isArray() ? (char)']' : '}');
        }
    }

    private void appendChildren(Report report, Node node) {
        int childCount = node.getChildren().size();
        for (int i = 0; i < childCount; ++i) {
            Node child = node.getChildren().get(i);
            this.append(report, child);
            if (childCount > 1 && i != childCount - 1) {
                report.append(',');
            }
            report.newLine();
        }
    }

    @Override
    protected String formatValue(Node node) {
        String value = node.getValue();
        if (!value.contains(System.lineSeparator())) {
            return this.formatValue(value);
        }
        StringBuilder b = new StringBuilder().append('[').append(System.lineSeparator());
        String[] lines = value.split("\\r");
        String indentation = "  ".repeat(this.indentationFor(node, 1));
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            b.append(indentation).append(this.quote(line));
            if (lines.length > 1 && i != lines.length - 1) {
                b.append(',');
            }
            b.append(System.lineSeparator());
        }
        return b.append("  ".repeat(this.indentationFor(node))).append(']').toString();
    }

    @Override
    protected String formatValue(String value) {
        if (this.isBoolean(value) || this.isNumber(value)) {
            return value;
        }
        return this.quote(value.trim());
    }

    private boolean isBoolean(String value) {
        return TRUE.equals(value) || FALSE.equals(value);
    }

    private boolean isNumber(String value) {
        return this.isDouble(value) || this.isLong(value);
    }

    private boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String quote(String value) {
        return "\"" + value.replaceAll("\"", "\\\\\"") + "\"";
    }
}

