/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.gitlab.api.GitlabAPI;
import org.jreleaser.sdk.gitlab.api.GlBranch;
import org.jreleaser.sdk.gitlab.api.GlFileUpload;
import org.jreleaser.sdk.gitlab.api.GlIssue;
import org.jreleaser.sdk.gitlab.api.GlLabel;
import org.jreleaser.sdk.gitlab.api.GlLink;
import org.jreleaser.sdk.gitlab.api.GlLinkRequest;
import org.jreleaser.sdk.gitlab.api.GlMilestone;
import org.jreleaser.sdk.gitlab.api.GlPackage;
import org.jreleaser.sdk.gitlab.api.GlProject;
import org.jreleaser.sdk.gitlab.api.GlRelease;
import org.jreleaser.sdk.gitlab.api.GlUser;
import org.jreleaser.sdk.gitlab.internal.Page;
import org.jreleaser.sdk.gitlab.internal.PaginatingDecoder;
import org.jreleaser.sdk.gitlab.internal.UrlEncoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

class Gitlab {
    static final String ENDPOINT = "https://gitlab.com/api/v4";
    private static final String API_V4 = "/api/v4";
    private static final String GRAPQL_DELETE_PAYLOAD = "{\n  \"query\": \"mutation {uploadDelete(input: { secret: \\\"{{secret}}\\\", filename: \\\"{{filename}}\\\", projectPath: \\\"{{projectPath}}\\\"}) { upload { id size path } errors }}\",\n  \"variables\": null\n}\n";
    private static final Pattern UPLOADS_PATTERN = Pattern.compile("(.*?)/uploads/(.*?)");
    private final Tika tika = new Tika();
    private final JReleaserContext context;
    private final GitlabAPI api;
    private final String apiHost;
    private final String graphQlEndpoint;
    private final int connectTimeout;
    private final int readTimeout;
    private GlUser user;
    private GlProject project;

    Gitlab(JReleaserContext context, String endpoint, String token, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        if (StringUtils.isBlank((String)endpoint)) {
            endpoint = ENDPOINT;
        }
        if (!endpoint.endsWith(API_V4)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V4;
        }
        this.apiHost = endpoint.substring(0, endpoint.length() - API_V4.length());
        this.graphQlEndpoint = endpoint.replace("v4", "graphql");
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.api = (GitlabAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", token)})).target(GitlabAPI.class, endpoint);
    }

    GlProject findProject(String projectName, String projectIdentifier) throws RestAPIException {
        return this.getProject(projectName, projectIdentifier);
    }

    List<Release> listReleases(String owner, String repoName, String projectIdentifier) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<Release> releases = new ArrayList<Release>();
        if (StringUtils.isBlank((String)projectIdentifier)) {
            GlProject project = this.getProject(repoName, projectIdentifier);
            projectIdentifier = project.getId().toString();
        }
        Page<List<GlRelease>> page = this.api.listReleases0(projectIdentifier);
        page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), this.apiHost + r.getTagPath(), r.getReleasedAt())).forEach(releases::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectReleases(page, releases);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return releases;
    }

    private void collectReleases(Page<List<GlRelease>> page, List<Release> releases) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listReleases1(next);
        page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), this.apiHost + r.getTagPath(), r.getReleasedAt())).forEach(releases::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectReleases(page, releases);
        }
    }

    List<String> listBranches(String owner, String repoName, String projectIdentifier) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<String> branches = new ArrayList<String>();
        if (StringUtils.isBlank((String)projectIdentifier)) {
            GlProject project = this.getProject(repoName, projectIdentifier);
            projectIdentifier = project.getId().toString();
        }
        Page<List<GlBranch>> page = this.api.listBranches0(projectIdentifier);
        page.getContent().stream().map(GlBranch::getName).forEach(branches::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectBranches(page, branches);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return branches;
    }

    private void collectBranches(Page<List<GlBranch>> page, List<String> branches) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listBranches1(next);
        page.getContent().stream().map(GlBranch::getName).forEach(branches::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectBranches(page, branches);
        }
    }

    Optional<GlMilestone> findMilestoneByName(String owner, String repo, Integer projectIdentifier, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(projectIdentifier, milestoneName, "active");
    }

    Optional<GlMilestone> findClosedMilestoneByName(String owner, String repo, Integer projectIdentifier, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup.closed", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(projectIdentifier, milestoneName, "closed");
    }

    private Optional<GlMilestone> findMilestone(Integer projectIdentifier, String milestoneName, String state) {
        try {
            List<GlMilestone> milestones = this.api.findMilestoneByTitle(projectIdentifier, (Map<String, Object>)CollectionUtils.map().e((Object)"title", (Object)milestoneName));
            if (null == milestones || milestones.isEmpty()) {
                return Optional.empty();
            }
            GlMilestone milestone = milestones.get(0);
            return state.equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    void closeMilestone(String owner, String repo, Integer projectIdentifier, GlMilestone milestone) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state_event", (Object)"close"), projectIdentifier, milestone.getId());
    }

    GlProject createProject(String owner, String repo) {
        this.context.getLogger().debug(RB.$((String)"git.project.create", (Object[])new Object[0]), new Object[]{owner, repo});
        return this.api.createProject(repo, "public");
    }

    GlUser getCurrentUser() throws RestAPIException {
        if (null == this.user) {
            this.context.getLogger().debug(RB.$((String)"git.fetch.current.user", (Object[])new Object[0]));
            this.user = this.api.getCurrentUser();
        }
        return this.user;
    }

    GlProject getProject(String projectName, String projectIdentifier) throws RestAPIException {
        if (null == this.project) {
            if (StringUtils.isNotBlank((String)projectIdentifier)) {
                this.context.getLogger().debug(RB.$((String)"git.fetch.gitlab.project_by_id", (Object[])new Object[0]), new Object[]{projectIdentifier});
                this.project = this.api.getProject(projectIdentifier.trim());
            } else {
                GlUser u = this.getCurrentUser();
                this.context.getLogger().debug(RB.$((String)"git.fetch.gitlab.project.by.user", (Object[])new Object[0]), new Object[]{projectName, u.getUsername(), u.getId()});
                List<GlProject> projects = this.api.getProject(u.getId(), (Map<String, Object>)CollectionUtils.map().e((Object)"search", (Object)projectName));
                if (null == projects || projects.isEmpty()) {
                    throw new RestAPIException(404, RB.$((String)"ERROR_project_not_exist", (Object[])new Object[]{projectName}));
                }
                this.project = projects.get(0);
            }
            this.context.getLogger().debug(RB.$((String)"git.gitlab.project.found", (Object[])new Object[0]), new Object[]{this.project.getNameWithNamespace(), this.project.getId()});
        }
        return this.project;
    }

    GlRelease findReleaseByTag(String owner, String repoName, String projectIdentifier, String tagName) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repoName, tagName});
        GlProject project = this.getProject(repoName, projectIdentifier);
        try {
            return this.api.getRelease(project.getId(), UrlEncoder.urlEncode(tagName));
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return null;
            }
            throw e;
        }
    }

    void deleteTag(String owner, String repoName, Integer projectIdentifier, String tagName) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        this.api.deleteTag(projectIdentifier, UrlEncoder.urlEncode(tagName));
    }

    void deletePackage(Integer projectIdentifier, Integer packageId) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"gitlab.delete.package", (Object[])new Object[0]), new Object[]{packageId, projectIdentifier});
        this.api.deletePackage(projectIdentifier, packageId);
    }

    void deleteRelease(String owner, String repoName, String projectIdentifier, String tagName) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.delete.release.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.deleteRelease(project.getId(), UrlEncoder.urlEncode(tagName));
    }

    void createRelease(String owner, String repoName, Integer projectIdentifier, GlRelease release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        this.api.createRelease(release, projectIdentifier);
    }

    void updateRelease(String owner, String repoName, String projectIdentifier, GlRelease release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.updateRelease(release, project.getId());
    }

    Collection<GlFileUpload> uploadAssets(String owner, String repoName, Integer projectIdentifier, Set<Asset> assets) throws IOException, RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.upload.assets", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<GlFileUpload> uploads = new ArrayList<GlFileUpload>();
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                GlFileUpload upload = this.api.uploadFile(projectIdentifier, this.toFormData(asset.getPath()));
                upload.setName(asset.getFilename());
                uploads.add(upload);
            }
            catch (IOException | RestAPIException e) {
                this.context.getLogger().error(" " + RB.$((String)"git.upload.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
        }
        return uploads;
    }

    void linkReleaseAssets(String owner, String repoName, GlRelease release, Integer projectIdentifier, Collection<GlFileUpload> uploads) throws RestAPIException {
        this.context.getLogger().info(RB.$((String)"git.upload.asset.links", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        for (GlFileUpload upload : uploads) {
            this.context.getLogger().info(" " + RB.$((String)"git.upload.asset.link", (Object[])new Object[0]), new Object[]{upload.getName()});
            try {
                this.api.linkAsset(upload.toLinkRequest(this.apiHost), projectIdentifier, release.getTagName());
            }
            catch (RestAPIException e) {
                this.context.getLogger().error(" " + RB.$((String)"git.upload.asset.link.failure", (Object[])new Object[0]), new Object[]{upload.getName()});
                throw e;
            }
        }
    }

    void linkAssets(String owner, String repoName, GlRelease release, Integer projectIdentifier, Collection<GlLinkRequest> links) throws RestAPIException {
        this.context.getLogger().info(RB.$((String)"git.upload.asset.links", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        for (GlLinkRequest link : links) {
            this.context.getLogger().info(" " + RB.$((String)"git.upload.asset.link", (Object[])new Object[0]), new Object[]{link.getName()});
            try {
                this.api.linkAsset(link, projectIdentifier, release.getTagName());
            }
            catch (RestAPIException e) {
                this.context.getLogger().error(" " + RB.$((String)"git.upload.asset.link.failure", (Object[])new Object[0]), new Object[]{link.getName()});
                throw e;
            }
        }
    }

    Optional<User> findUser(String email, String name) throws RestAPIException {
        GlUser user;
        this.context.getLogger().debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        List<GlUser> users = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"scope", "users", "search", email}));
        if (null != users && !users.isEmpty()) {
            GlUser user2 = users.get(0);
            return Optional.of(new User(user2.getUsername(), email, user2.getWebUrl()));
        }
        users = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"scope", "users", "search", name}));
        if (null != users && !users.isEmpty() && name.equals((user = users.get(0)).getName())) {
            return Optional.of(new User(user.getUsername(), email, user.getWebUrl()));
        }
        return Optional.empty();
    }

    GlLabel getOrCreateLabel(Integer projectIdentifier, String labelName, String labelColor, String description) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.label.fetch", (Object[])new Object[]{labelName}));
        List<GlLabel> labels = this.listLabels(projectIdentifier);
        Optional<GlLabel> label = labels.stream().filter(l -> l.getName().equals(labelName)).findFirst();
        if (label.isPresent()) {
            return label.get();
        }
        this.context.getLogger().debug(RB.$((String)"git.label.create", (Object[])new Object[]{labelName}));
        return this.api.createLabel(projectIdentifier, labelName, labelColor, description);
    }

    void addLabelToIssue(Integer projectIdentifier, GlIssue issue, GlLabel label) {
        this.context.getLogger().debug(RB.$((String)"git.issue.label", (Object[])new Object[]{label.getName(), issue.getIid()}));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        List list = (List)params.computeIfAbsent("labels", k -> new ArrayList());
        list.addAll(issue.getLabels());
        list.add(label.getName());
        this.api.updateIssue(params, projectIdentifier, issue.getIid());
    }

    void commentOnIssue(Integer projectIdentifier, GlIssue issue, String comment) {
        this.context.getLogger().debug(RB.$((String)"git.issue.comment", (Object[])new Object[]{issue.getIid()}));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("body", comment);
        this.api.commentIssue(params, projectIdentifier, issue.getIid());
    }

    void setMilestoneOnIssue(Integer projectIdentifier, GlIssue issue, GlMilestone milestone) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("milestone_id", milestone.getId());
        this.api.updateIssue(params, projectIdentifier, issue.getIid());
    }

    List<GlLabel> listLabels(Integer projectIdentifier) throws IOException {
        this.context.getLogger().debug(RB.$((String)"gitlab.list.labels", (Object[])new Object[0]), new Object[]{projectIdentifier});
        ArrayList<GlLabel> labels = new ArrayList<GlLabel>();
        Page<List<GlLabel>> page = this.api.listLabels0(projectIdentifier);
        labels.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectLabels(page, labels);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return labels;
    }

    private void collectLabels(Page<List<GlLabel>> page, List<GlLabel> labels) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listLabels1(next);
        labels.addAll((Collection<GlLabel>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectLabels(page, labels);
        }
    }

    List<GlIssue> listIssues(Integer projectIdentifier) throws IOException {
        this.context.getLogger().debug(RB.$((String)"gitlab.list.issues", (Object[])new Object[0]), new Object[]{projectIdentifier});
        ArrayList<GlIssue> issues = new ArrayList<GlIssue>();
        Page<List<GlIssue>> page = this.api.listIssues0(projectIdentifier);
        issues.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectIssues(page, issues);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return issues;
    }

    private void collectIssues(Page<List<GlIssue>> page, List<GlIssue> issues) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listIssues1(next);
        issues.addAll((Collection<GlIssue>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectIssues(page, issues);
        }
    }

    List<GlPackage> listPackages(Integer projectIdentifier, String packageType) throws IOException {
        this.context.getLogger().debug(RB.$((String)"gitlab.list.packages", (Object[])new Object[0]), new Object[]{projectIdentifier});
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("package_type", packageType);
        ArrayList<GlPackage> packages = new ArrayList<GlPackage>();
        Page<List<GlPackage>> page = this.api.listPackages0(projectIdentifier, params);
        packages.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectPackages(page, packages);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return packages;
    }

    private void collectPackages(Page<List<GlPackage>> page, List<GlPackage> packages) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listPackages1(next);
        packages.addAll((Collection<GlPackage>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectPackages(page, packages);
        }
    }

    Map<String, GlLink> listLinks(Integer projectIdentifier, String tagName) throws IOException {
        this.context.getLogger().debug(RB.$((String)"gitlab.list.links", (Object[])new Object[0]), new Object[]{tagName, projectIdentifier});
        ArrayList<GlLink> links = new ArrayList<GlLink>();
        Page<List<GlLink>> page = this.api.listLinks0(projectIdentifier, tagName);
        links.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectLinks(page, links);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return links.stream().collect(Collectors.toMap(GlLink::getName, Function.identity()));
    }

    private void collectLinks(Page<List<GlLink>> page, List<GlLink> links) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listLinks1(next);
        links.addAll((Collection<GlLink>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectLinks(page, links);
        }
    }

    void deleteLinkedAsset(String token, Integer projectIdentifier, String tagName, GlLink link) throws IOException {
        this.context.getLogger().info(" " + RB.$((String)"git.delete.asset", (Object[])new Object[0]), new Object[]{link.getName()});
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        this.context.getLogger().debug(RB.$((String)"gitlab.delete.file", (Object[])new Object[]{link.getName()}));
        try {
            TemplateContext props = new TemplateContext();
            props.set("filename", (Object)link.getName());
            String url = link.getUrl().substring(this.apiHost.length() + 1);
            url = url.substring(0, url.length() - link.getName().length() - 1);
            Matcher matcher = UPLOADS_PATTERN.matcher(url);
            if (!matcher.matches()) {
                throw new IOException(RB.$((String)"ERROR_gitlab_invalid_upload_link", (Object[])new Object[]{link.getUrl()}));
            }
            props.set("projectPath", (Object)matcher.group(1));
            props.set("secret", (Object)matcher.group(2));
            String payload = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)GRAPQL_DELETE_PAYLOAD, (TemplateContext)props);
            FormData data = ClientUtils.toFormData((String)"payload", (String)headers.computeIfAbsent("Content-Type", k -> "text/plain"), (String)payload);
            ClientUtils.postFile((JReleaserLogger)this.context.getLogger(), (String)this.graphQlEndpoint, (int)this.connectTimeout, (int)this.readTimeout, (FormData)data, headers);
        }
        catch (UploadException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        this.context.getLogger().debug(RB.$((String)"gitlab.delete.link", (Object[])new Object[]{link.getId(), link.getName()}));
        this.api.deleteLink(projectIdentifier, tagName, link.getId());
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

