/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.catalog;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.catalog.CatalogerSupport;
import org.jreleaser.engine.checksum.Checksum;
import org.jreleaser.engine.deploy.maven.ArtifactDeployers;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.catalog.SlsaCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.CatalogProcessingException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.model.spi.deploy.maven.MavenDeployer;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public final class Slsa {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";

    private Slsa() {
    }

    public static void catalog(JReleaserContext context) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("slsa");
        SlsaCataloger slsa = context.getModel().getCatalog().getSlsa();
        if (!slsa.isEnabled()) {
            context.getLogger().info(RB.$((String)"catalogers.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        try {
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.before((String)JReleaserCommand.CATALOG.toStep()), context, slsa);
            Slsa.attestation(context, slsa);
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.success((String)JReleaserCommand.CATALOG.toStep()), context, slsa);
        }
        catch (CatalogProcessingException e) {
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.failure((String)JReleaserCommand.CATALOG.toStep(), (Throwable)e), context, slsa);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
        }
    }

    private static void attestation(JReleaserContext context, SlsaCataloger slsa) throws CatalogProcessingException {
        LinkedHashSet<PathMatcher> includes = new LinkedHashSet<PathMatcher>();
        LinkedHashSet<PathMatcher> excludes = new LinkedHashSet<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (Iterator<Object> s : slsa.getIncludes()) {
            includes.add(fileSystem.getPathMatcher(Slsa.normalize((String)((Object)s))));
        }
        for (Iterator<Object> s : slsa.getExcludes()) {
            excludes.add(fileSystem.getPathMatcher(Slsa.normalize((String)((Object)s))));
        }
        if (includes.isEmpty()) {
            includes.add(fileSystem.getPathMatcher("glob:**/*"));
        }
        Attestation attestation = new Attestation(slsa.getResolvedAttestationName(context));
        context.getLogger().info(attestation.getName());
        if (slsa.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipSlsa") || artifact.isOptional(context) && !artifact.resolvedPathExists() && !Slsa.isIncluded(context, artifact, includes, excludes)) continue;
                Checksum.readHash(context, Algorithm.SHA_256, artifact);
                Slsa.addSubject(context, attestation, artifact);
            }
        }
        if (slsa.isArtifacts()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected()) continue;
                    artifact.getEffectivePath(context, distribution);
                    if (artifact.isOptional(context) && !artifact.resolvedPathExists() && !Slsa.isIncluded(context, artifact, includes, excludes)) continue;
                    Checksum.readHash(context, distribution, Algorithm.SHA_256, artifact);
                    Slsa.addSubject(context, attestation, artifact);
                }
            }
        }
        if (slsa.isDeployables()) {
            for (Deployable deployable : Slsa.collectDeployables(context)) {
                Artifact artifact;
                if (!deployable.isPom() && !deployable.isArtifact() || !Slsa.isIncluded(context, artifact = Artifact.of((Path)deployable.getLocalPath()), includes, excludes)) continue;
                Checksum.readHash(context, Algorithm.SHA_256, artifact);
                Slsa.addSubject(context, attestation, artifact);
            }
        }
        if (attestation.getSubjects().isEmpty()) {
            context.getLogger().info(RB.$((String)"catalog.no.artifacts", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        String newContent = null;
        try {
            Attestations attestations = new Attestations();
            attestations.getAttestations().add(attestation);
            ObjectMapper objectMapper = new ObjectMapper();
            newContent = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)attestations) + System.lineSeparator();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        Path attestationFile = context.getCatalogsDirectory().resolve(slsa.getType()).resolve(attestation.getName());
        try {
            String oldContent;
            if (Files.exists(attestationFile, new LinkOption[0]) && newContent.equals(oldContent = new String(Files.readAllBytes(attestationFile), StandardCharsets.UTF_8))) {
                context.getLogger().info(RB.$((String)"catalog.slsa.not.changed", (Object[])new Object[0]));
                context.getLogger().restorePrefix();
                context.getLogger().decreaseIndent();
                return;
            }
        }
        catch (IOException oldContent) {
            // empty catch block
        }
        try {
            if (StringUtils.isNotBlank((String)newContent)) {
                Files.createDirectories(attestationFile.getParent(), new FileAttribute[0]);
                Files.write(attestationFile, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            } else {
                Files.deleteIfExists(attestationFile);
            }
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{attestationFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    private static String normalize(String pattern) {
        if (pattern.startsWith(GLOB_PREFIX) || pattern.startsWith(REGEX_PREFIX)) {
            return pattern;
        }
        return GLOB_PREFIX + pattern;
    }

    private static boolean isIncluded(JReleaserContext context, Artifact artifact, Set<PathMatcher> includes, Set<PathMatcher> excludes) {
        Path path = artifact.getEffectivePath(context);
        return includes.stream().anyMatch(matcher -> matcher.matches(path)) && excludes.stream().noneMatch(matcher -> matcher.matches(path));
    }

    private static void addSubject(JReleaserContext context, Attestation attestation, Artifact artifact) {
        String artifactFileName = artifact.getEffectivePath(context).getFileName().toString();
        attestation.addSubject(artifactFileName, artifact.getHash(Algorithm.SHA_256));
        context.getLogger().debug("- " + artifactFileName);
    }

    private static Set<Deployable> collectDeployables(JReleaserContext context) {
        TreeSet<String> stagingRepositories = new TreeSet<String>();
        TreeSet<Deployable> deployables = new TreeSet<Deployable>();
        Maven maven = context.getModel().getDeploy().getMaven();
        if (!context.getIncludedDeployerTypes().isEmpty()) {
            for (String deployerType : context.getIncludedDeployerTypes()) {
                if (!JReleaserSupport.supportedMavenDeployers().contains(deployerType)) continue;
                Map deployers = maven.findMavenDeployersByType(deployerType);
                if (deployers.isEmpty()) {
                    return deployables;
                }
                if (!context.getIncludedDeployerNames().isEmpty()) {
                    for (String deployerName : context.getIncludedDeployerNames()) {
                        org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer2;
                        if (!deployers.containsKey(deployerName) || !(deployer2 = (org.jreleaser.model.internal.deploy.maven.MavenDeployer)deployers.get(deployerName)).isEnabled()) continue;
                        Slsa.handleDeployer(context, stagingRepositories, deployables, deployer2);
                    }
                    continue;
                }
                for (org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer3 : deployers.values()) {
                    Slsa.handleDeployer(context, stagingRepositories, deployables, deployer3);
                }
            }
        } else if (!context.getIncludedDeployerNames().isEmpty()) {
            for (String deployerName : context.getIncludedDeployerNames()) {
                maven.findAllActiveMavenDeployers().stream().filter(a -> deployerName.equals(a.getName())).forEach(deployer -> Slsa.handleDeployer(context, stagingRepositories, deployables, deployer));
            }
        } else {
            for (org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer4 : maven.findAllActiveMavenDeployers()) {
                if (context.getExcludedDeployerTypes().contains(deployer4.getType()) || context.getExcludedDeployerNames().contains(deployer4.getName())) continue;
                Slsa.handleDeployer(context, stagingRepositories, deployables, deployer4);
            }
        }
        return deployables;
    }

    private static void handleDeployer(JReleaserContext context, Set<String> stagingRepositories, Set<Deployable> deployables, org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer) {
        MavenDeployer artifactMavenDeployer = ArtifactDeployers.findMavenDeployer(context, deployer);
        for (String stagingRepository : deployer.getStagingRepositories()) {
            if (stagingRepositories.contains(stagingRepository)) continue;
            artifactMavenDeployer.collectDeployables(deployables, stagingRepository);
        }
    }

    private static class Attestation {
        private final String name;
        private final Set<Subject> subjects = new TreeSet<Subject>();

        private Attestation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Set<Subject> getSubjects() {
            return this.subjects;
        }

        public void addSubject(String name, String sha256) {
            this.subjects.add(new Subject(name, sha256));
        }
    }

    private static class Attestations {
        private final Set<Attestation> attestations = new LinkedHashSet<Attestation>();

        private Attestations() {
        }

        public Integer getVersion() {
            return 1;
        }

        public Set<Attestation> getAttestations() {
            return this.attestations;
        }
    }

    private static class Digest {
        private final String sha256;

        private Digest(String sha256) {
            this.sha256 = sha256;
        }

        public String getSha256() {
            return this.sha256;
        }
    }

    private static class Subject
    implements Comparable<Subject> {
        private final String name;
        private final Digest digest;

        private Subject(String name, String sha256) {
            this.name = name;
            this.digest = new Digest(sha256);
        }

        public String getName() {
            return this.name;
        }

        public Digest getDigest() {
            return this.digest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Subject subject = (Subject)o;
            return this.name.equals(subject.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @Override
        public int compareTo(Subject o) {
            if (null == o) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

