/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.templates;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.changelog.Changelog;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;

public class TemplateEvaluator {
    private TemplateEvaluator() {
    }

    public static Path generateTemplate(JReleaserContext context, Path templatePath, Path targetDirectory, boolean overwrite) throws JReleaserException {
        if (!Files.exists(templatePath, new LinkOption[0])) {
            throw TemplateEvaluator.fail(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"templatePath", templatePath}));
        }
        if (!Files.isRegularFile(templatePath, new LinkOption[0])) {
            throw TemplateEvaluator.fail(RB.$((String)"validation_is_not_a_file", (Object[])new Object[]{"templatePath", templatePath}));
        }
        try {
            context.getLogger().info(RB.$((String)"templates.create.directory", (Object[])new Object[0]), new Object[]{targetDirectory.toAbsolutePath()});
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            TemplateResource template = TemplateUtils.resolveTemplate((Path)templatePath);
            TemplateContext props = TemplateEvaluator.setupTemplateContext(context);
            String key = templatePath.getFileName().toString();
            Path targetTemplate = targetDirectory.resolve(TemplateUtils.trimTplExtension((String)key));
            if (template.isReader()) {
                context.getLogger().info(RB.$((String)"templates.evaluate", (Object[])new Object[0]), new Object[]{key});
                String content = MustacheUtils.applyTemplate((JReleaserLogger)context.getLogger(), (Reader)template.getReader(), (TemplateContext)props, (String)key);
                context.getLogger().info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{targetTemplate});
                TemplateEvaluator.writeFile(context.getLogger(), content, targetTemplate, overwrite);
            } else {
                context.getLogger().info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{targetTemplate});
                TemplateEvaluator.writeFile(context.getLogger(), IOUtils.toByteArray((InputStream)template.getInputStream()), targetTemplate, overwrite);
            }
        }
        catch (IOException e) {
            throw TemplateEvaluator.fail(e);
        }
        context.getLogger().info(RB.$((String)"templates.evaluate.single.done", (Object[])new Object[]{templatePath, targetDirectory}));
        return targetDirectory;
    }

    public static Path generateTemplates(JReleaserContext context, Path inputDirectory, Path targetDirectory, boolean overwrite) throws JReleaserException {
        if (!Files.exists(inputDirectory, new LinkOption[0])) {
            throw TemplateEvaluator.fail(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"inputDirectory", inputDirectory}));
        }
        if (!Files.isDirectory(inputDirectory, new LinkOption[0])) {
            throw TemplateEvaluator.fail(RB.$((String)"validation_is_not_a_directory", (Object[])new Object[]{"inputDirectory", inputDirectory}));
        }
        try {
            File inputDirectoryFile = inputDirectory.toFile();
            if (null == inputDirectoryFile.listFiles() || inputDirectoryFile.listFiles().length == 0) {
                throw TemplateEvaluator.fail(RB.$((String)"validation_directory_is_empty", (Object[])new Object[]{"inputDirectory", inputDirectory}));
            }
            context.getLogger().info(RB.$((String)"templates.create.directory", (Object[])new Object[0]), new Object[]{targetDirectory.toAbsolutePath()});
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            Map templates = TemplateUtils.resolveTemplates((Path)inputDirectory);
            TemplateContext props = TemplateEvaluator.setupTemplateContext(context);
            for (Map.Entry entry : templates.entrySet()) {
                String key = (String)entry.getKey();
                TemplateResource value = (TemplateResource)entry.getValue();
                Path targetTemplate = targetDirectory.resolve(TemplateUtils.trimTplExtension((String)key));
                if (value.isReader()) {
                    context.getLogger().info(RB.$((String)"templates.evaluate", (Object[])new Object[0]), new Object[]{key});
                    String content = MustacheUtils.applyTemplate((JReleaserLogger)context.getLogger(), (Reader)value.getReader(), (TemplateContext)props, (String)key);
                    context.getLogger().info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{targetTemplate});
                    TemplateEvaluator.writeFile(context.getLogger(), content, targetTemplate, overwrite);
                    continue;
                }
                context.getLogger().info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{targetTemplate});
                TemplateEvaluator.writeFile(context.getLogger(), IOUtils.toByteArray((InputStream)value.getInputStream()), targetTemplate, overwrite);
            }
        }
        catch (IOException e) {
            throw TemplateEvaluator.fail(e);
        }
        context.getLogger().info(RB.$((String)"templates.evaluate.multiple.done", (Object[])new Object[]{inputDirectory, targetDirectory}));
        return targetDirectory;
    }

    private static TemplateContext setupTemplateContext(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        if (context.getMode() == JReleaserContext.Mode.ANNOUNCE || context.getMode() == JReleaserContext.Mode.CHANGELOG || context.getMode() == JReleaserContext.Mode.CONFIG || context.getMode() == JReleaserContext.Mode.FULL) {
            String resolvedChangelog = Changelog.createChangelog(context);
            context.getChangelog().setResolvedChangelog(resolvedChangelog);
            props.set("changelogContent", (Object)MustacheUtils.passThrough((String)resolvedChangelog));
            props.set("changelogChanges", (Object)MustacheUtils.passThrough((String)context.getChangelog().getFormattedChanges()));
            props.set("changelogContributors", (Object)MustacheUtils.passThrough((String)context.getChangelog().getFormattedContributors()));
        }
        return props;
    }

    private static void writeFile(JReleaserLogger logger, String content, Path outputFile, boolean overwrite) {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(StandardCharsets.UTF_8), overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (FileAlreadyExistsException e) {
            logger.error(RB.$((String)"jreleaser.ERROR_file_exists", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
        }
        catch (IOException e) {
            throw TemplateEvaluator.fail(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), e);
        }
    }

    private static void writeFile(JReleaserLogger logger, byte[] content, Path outputFile, boolean overwrite) {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content, overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (FileAlreadyExistsException e) {
            logger.error(RB.$((String)"jreleaser.ERROR_file_exists", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
        }
        catch (IOException e) {
            throw TemplateEvaluator.fail(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), e);
        }
    }

    private static JReleaserException fail(String msg) throws JReleaserException {
        throw new JReleaserException(msg);
    }

    private static JReleaserException fail(String msg, Exception e) throws JReleaserException {
        throw new JReleaserException(msg, (Throwable)e);
    }

    private static JReleaserException fail(Exception e) throws JReleaserException {
        throw new JReleaserException(RB.$((String)"ERROR_unexpected_template_fail2", (Object[])new Object[0]), (Throwable)e);
    }
}

