/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class AppdataUtils {
    private AppdataUtils() {
    }

    public static void resolveIcons(JReleaserContext context, TemplatePackager<?> packager, Distribution distribution, TemplateContext props, List<Icon> icons) throws PackagerProcessingException {
        for (Icon icon : icons) {
            String iconUrl = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)icon.getUrl(), (TemplateContext)props);
            String iconExt = StringUtils.getFilenameExtension((String)iconUrl);
            Path iconPath = Paths.get(packager.getTemplateDirectory(), "icons", icon.getWidth() + "x" + icon.getHeight(), distribution.getExecutable().getName() + "." + iconExt);
            iconPath = context.getBasedir().resolve(iconPath);
            if (Files.exists(iconPath, new LinkOption[0])) continue;
            context.getLogger().debug("{} -> {}", new Object[]{iconUrl, context.relativizeToBasedir(iconPath)});
            try {
                FileUtils.copyURLToFile((URL)new URI(iconUrl).toURL(), (File)iconPath.toFile(), (int)20000, (int)60000);
            }
            catch (IOException | URISyntaxException e) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{iconUrl}), (Throwable)e);
            }
        }
    }

    public static boolean isReleaseIncluded(Set<String> skipReleases, String version) {
        if (null == skipReleases || skipReleases.isEmpty()) {
            return true;
        }
        if (skipReleases.contains(version)) {
            return false;
        }
        for (String regex : skipReleases) {
            Pattern p = Pattern.compile(regex);
            if (!p.matcher(version).matches()) continue;
            return false;
        }
        return true;
    }

    public static class Release {
        private final String url;
        private final String version;
        private final String date;

        private Release(String url, String version, String date) {
            this.url = url;
            this.version = version;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDate() {
            return this.date;
        }

        public static Release of(String url, String version, Date date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return new Release(url, version, format.format(date));
        }
    }
}

