/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.deploy.maven.Maven;

public final class Deploy
extends AbstractActivatable<Deploy>
implements Domain {
    private static final long serialVersionUID = 1065361758727406904L;
    private final Maven maven = new Maven();
    @JsonIgnore
    private final org.jreleaser.model.api.deploy.Deploy immutable = new org.jreleaser.model.api.deploy.Deploy(){
        private static final long serialVersionUID = 487506438939211307L;

        public org.jreleaser.model.api.deploy.maven.Maven getMaven() {
            return Deploy.this.maven.asImmutable();
        }

        public Active getActive() {
            return Deploy.this.getActive();
        }

        public boolean isEnabled() {
            return Deploy.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Deploy.this.asMap(full));
        }
    };

    public Deploy() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.deploy.Deploy asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Deploy source) {
        super.merge(source);
        this.setMaven(source.maven);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.maven.isSet();
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven.merge(maven);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("maven", this.maven.asMap(full));
        return map;
    }
}

