/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.common.TimeoutAware;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public interface Downloader<A extends org.jreleaser.model.api.download.Downloader>
extends Domain,
Activatable,
TimeoutAware,
ExtraProperties {
    public String getType();

    public String getName();

    public void setName(String var1);

    public List<Asset> getAssets();

    public void setAssets(List<Asset> var1);

    public void addAsset(Asset var1);

    public A asImmutable();

    public static class Asset
    extends AbstractModelObject<Asset>
    implements Domain {
        private static final long serialVersionUID = -2850050928704465633L;
        private final Unpack unpack = new Unpack();
        private String input;
        private String output;
        @JsonIgnore
        private final Downloader.Asset immutable = new Downloader.Asset(){
            private static final long serialVersionUID = 2845138939915499623L;

            public String getInput() {
                return input;
            }

            public String getOutput() {
                return output;
            }

            public Downloader.Unpack getUnpack() {
                return unpack.asImmutable();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Downloader.Asset asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Asset source) {
            this.input = this.merge(this.input, source.input);
            this.output = this.merge(this.output, source.output);
            this.setUnpack(source.unpack);
        }

        public String getResolvedInput(JReleaserContext context, Downloader<?> downloader) {
            TemplateContext p = context.getModel().props(context);
            p.setAll(downloader.resolvedExtraProperties());
            p.set("downloaderName", (Object)downloader.getName());
            return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.input, (TemplateContext)p);
        }

        public String getResolvedOutput(JReleaserContext context, Downloader<?> downloader, String artifactFile) {
            if (StringUtils.isBlank((String)this.output)) {
                return this.output;
            }
            TemplateContext p = context.getModel().props(context);
            p.setAll(downloader.resolvedExtraProperties());
            p.set("downloaderName", (Object)downloader.getName());
            p.set("artifactFile", (Object)artifactFile);
            return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.output, (TemplateContext)p);
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public Unpack getUnpack() {
            return this.unpack;
        }

        public void setUnpack(Unpack unpack) {
            this.unpack.merge(unpack);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("input", this.input);
            props.put("output", this.output);
            props.put("unpack", this.unpack.asMap(full));
            return props;
        }
    }

    public static class Unpack
    extends AbstractModelObject<Unpack>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = -5735907573642807009L;
        private Boolean enabled;
        private Boolean skipRootEntry;
        @JsonIgnore
        public final Downloader.Unpack immutable = new Downloader.Unpack(){
            private static final long serialVersionUID = -6271748744186223250L;

            public boolean isSkipRootEntry() {
                return this.isSkipRootEntry();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Downloader.Unpack asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Unpack source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.skipRootEntry = this.merge(this.skipRootEntry, source.skipRootEntry);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public boolean isSkipRootEntry() {
            return null != this.skipRootEntry && this.skipRootEntry != false;
        }

        public void setSkipRootEntry(Boolean skipRootEntry) {
            this.skipRootEntry = skipRootEntry;
        }

        public boolean isSkipRootEntrySet() {
            return null != this.skipRootEntry;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("skipRootEntry", this.isSkipRootEntry());
            return props;
        }
    }
}

