/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.model.internal.upload.WebUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public abstract class AbstractWebUploader<A extends org.jreleaser.model.api.upload.WebUploader, S extends AbstractWebUploader<A, S>>
extends AbstractUploader<A, S>
implements WebUploader<A> {
    private static final long serialVersionUID = 4426002573676915317L;
    private String uploadUrl;
    private String downloadUrl;

    protected AbstractWebUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.uploadUrl = this.merge(this.uploadUrl, ((AbstractWebUploader)source).getUploadUrl());
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractWebUploader)source).getDownloadUrl());
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, TemplateContext props, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.downloadUrl, (TemplateContext)p);
    }

    @Override
    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(context, artifact));
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.uploadUrl, (TemplateContext)p);
    }

    @Override
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("uploadUrl", this.uploadUrl);
        props.put("downloadUrl", this.downloadUrl);
    }
}

