/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"FileTest"})
public class RubyFileTest {
    public static RubyModule createFileTestModule(ThreadContext context) {
        return Define.defineModule(context, "FileTest").defineMethods(context, RubyFileTest.class);
    }

    @JRubyMethod(name={"blockdev?"}, module=true)
    public static IRubyObject blockdev_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isBlockDev());
    }

    @Deprecated(since="10.0")
    public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.blockdev_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"chardev?"}, module=true)
    public static IRubyObject chardev_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isCharDev());
    }

    @Deprecated(since="10.0")
    public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.chardev_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject directory_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject directory_p(Ruby ruby, IRubyObject filename2) {
        return RubyFileTest.directory_p(ruby.getCurrentContext(), filename2);
    }

    @JRubyMethod(name={"directory?"}, module=true)
    public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(context, filename2);
    }

    public static IRubyObject directory_p(ThreadContext context, IRubyObject filename2) {
        if (!(filename2 instanceof RubyIO) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, Access.ioClass(context), "to_io");
        }
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, module=true)
    public static IRubyObject executable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).canExecute());
    }

    @Deprecated(since="10.0")
    public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.executable_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"executable_real?"}, module=true)
    public static IRubyObject executable_real_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        if (context.runtime.getPosix().isNative()) {
            FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
            return Convert.asBoolean(context, stat2 != null && stat2.isExecutableReal());
        }
        return RubyFileTest.executable_p(context, recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.executable_real_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject exist_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.exist_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"exist?"}, module=true)
    public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return Convert.asBoolean(context, RubyFileTest.exist(context, RubyFile.get_path(context, filename2)));
    }

    static boolean exist(ThreadContext context, RubyString path2) {
        String pathStr = path2.decodeString();
        if (!Ruby.isSecurityRestricted() && JRubyFile.createResource(context.runtime, pathStr).exists()) {
            return true;
        }
        return RubyFileTest.existsOnClasspath(context, pathStr);
    }

    @Deprecated(since="10.0")
    public static RubyBoolean file_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.file_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"file?"}, module=true)
    public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).isFile());
    }

    @JRubyMethod(name={"grpowned?"}, module=true)
    public static IRubyObject grpowned_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        if (Platform.IS_WINDOWS) {
            return context.fals;
        }
        return Convert.asBoolean(context, stat2 != null && stat2.isGroupOwned());
    }

    @Deprecated(since="10.0")
    public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.grpowned_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"identical?"}, module=true)
    public static IRubyObject identical_p(ThreadContext context, IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
        FileResource file1 = RubyFile.fileResource(context, filename1);
        FileResource file2 = RubyFile.fileResource(context, filename2);
        if (!Platform.IS_WINDOWS && context.runtime.getPosix().isNative()) {
            FileStat stat1 = file1.stat();
            FileStat stat2 = file2.stat();
            return Convert.asBoolean(context, stat1 != null && stat2 != null && stat1.isIdentical(stat2));
        }
        if (file1.exists() && file2.exists()) {
            try {
                Path canon1 = new File(file1.absolutePath()).getCanonicalFile().toPath();
                Path canon2 = new File(file2.absolutePath()).getCanonicalFile().toPath();
                return Convert.asBoolean(context, Files.isSameFile(canon1, canon2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return context.fals;
    }

    @JRubyMethod(name={"owned?"}, module=true)
    public static IRubyObject owned_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isOwned());
    }

    @Deprecated
    public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.owned_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"pipe?"}, module=true)
    public static IRubyObject pipe_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isNamedPipe());
    }

    @Deprecated(since="10.0")
    public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.pipe_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject readable_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.readable_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, module=true)
    public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).canRead());
    }

    public static IRubyObject rowned_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isROwned());
    }

    @Deprecated(since="10.0")
    public static IRubyObject rowned_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.rowned_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"setgid?"}, module=true)
    public static IRubyObject setgid_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isSetgid());
    }

    @Deprecated(since="10.0")
    public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.setgid_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"setuid?"}, module=true)
    public static IRubyObject setuid_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isSetuid());
    }

    @Deprecated(since="10.0")
    public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.setuid_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated(since="10.0")
    public static IRubyObject size(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size"}, module=true)
    public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2;
        if (!(filename2 instanceof RubyFile) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, Access.ioClass(context), "to_io");
        }
        if ((stat2 = RubyFile.fileResource(context, filename2).stat()) == null) {
            RubyFileTest.noFileError(context, filename2);
        }
        return Convert.asFixnum(context, stat2.st_size());
    }

    @Deprecated
    public static IRubyObject size_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size?"}, module=true)
    public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2;
        if (!(filename2 instanceof RubyFile) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, Access.ioClass(context), "to_io");
        }
        if ((stat2 = RubyFile.fileResource(context, filename2).stat()) == null) {
            return context.nil;
        }
        long length2 = stat2.st_size();
        return length2 > 0L ? Convert.asFixnum(context, length2) : context.nil;
    }

    @JRubyMethod(name={"socket?"}, module=true)
    public static IRubyObject socket_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isSocket());
    }

    @Deprecated
    public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.socket_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"sticky?"}, module=true)
    public static IRubyObject sticky_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(context, filename2).stat();
        return Convert.asBoolean(context, stat2 != null && stat2.isSticky());
    }

    @Deprecated
    public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.sticky_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"symlink?"}, module=true)
    public static RubyBoolean symlink_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).isSymLink());
    }

    @Deprecated
    public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.symlink_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, module=true)
    public static RubyBoolean writable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return Convert.asBoolean(context, RubyFile.fileResource(context, filename2).canWrite());
    }

    @Deprecated
    public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.writable_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @Deprecated
    public static RubyBoolean zero_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.zero_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"empty?", "zero?"}, module=true)
    public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileResource resource = RubyFile.fileResource(context, filename2);
        if (resource.isNull()) {
            return Convert.asBoolean(context, true);
        }
        FileStat stat2 = resource.stat();
        if (stat2 == null) {
            return context.fals;
        }
        if (stat2.isDirectory()) {
            return Convert.asBoolean(context, Platform.IS_WINDOWS);
        }
        return Convert.asBoolean(context, stat2.st_size() == 0L);
    }

    @JRubyMethod(name={"world_readable?"}, module=true)
    public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getRubyFileStat(context, filename2);
        return stat2 == null ? context.nil : stat2.worldReadable(context);
    }

    @JRubyMethod(name={"world_writable?"}, module=true)
    public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getRubyFileStat(context, filename2);
        return stat2 == null ? context.nil : stat2.worldWritable(context);
    }

    private static RubyFileStat getRubyFileStat(ThreadContext context, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        RubyFileStat stat2 = null;
        if (!(filename2 instanceof RubyFile)) {
            RubyString path2 = RubyFile.get_path(context, filename2);
            FileResource file2 = JRubyFile.createResource(runtime2, path2.getUnicodeValue());
            if (file2.exists()) {
                stat2 = runtime2.newFileStat(file2.absolutePath(), false);
            }
        } else {
            stat2 = (RubyFileStat)((RubyFile)filename2).stat(context);
        }
        return stat2;
    }

    private static boolean existsOnClasspath(ThreadContext context, String path2) {
        if (path2.startsWith("classpath:/")) {
            InputStream is;
            path2 = path2.substring("classpath:/".length());
            ClassLoader classLoader = context.runtime.getJRubyClassLoader();
            if (classLoader == null && Ruby.isSecurityRestricted()) {
                classLoader = Access.instanceConfig(context).getLoader();
            }
            if ((is = ((ClassLoader)classLoader).getResourceAsStream(path2)) != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    private static void noFileError(ThreadContext context, IRubyObject filename2) {
        throw context.runtime.newErrnoENOENTError("No such file or directory - " + String.valueOf(filename2.convertToString()));
    }

    @Deprecated
    public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
        return RubyFileTest.identical_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename1, filename2);
    }

    public static class FileTestFileMethods {
        @JRubyMethod(name={"blockdev?"})
        public static IRubyObject blockdev_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.blockdev_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.blockdev_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"chardev?"})
        public static IRubyObject chardev_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.chardev_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.chardev_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"directory?"})
        public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.directory_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"executable?"})
        public static IRubyObject executable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.executable_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"executable_real?"})
        public static IRubyObject executable_real_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_real_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.executable_real_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"exist?"})
        public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.exist_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"file?"})
        public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.file_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"grpowned?"})
        public static IRubyObject grpowned_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.grpowned_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.grpowned_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"identical?"})
        public static IRubyObject identical_p(ThreadContext context, IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
            return RubyFileTest.identical_p(context, recv2, filename1, filename2);
        }

        @JRubyMethod(name={"owned?"})
        public static IRubyObject owned_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.owned_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.owned_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"pipe?"})
        public static IRubyObject pipe_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.pipe_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.pipe_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"readable?", "readable_real?"})
        public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.readable_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"setgid?"})
        public static IRubyObject setgid_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setgid_p(context, recv2, filename2);
        }

        @Deprecated(since="10.0")
        public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.setgid_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"setuid?"})
        public static IRubyObject setuid_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setuid_p(context, recv2, filename2);
        }

        @Deprecated(since="10.0")
        public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.setuid_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"size"})
        public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size(context, recv2, filename2);
        }

        @JRubyMethod(name={"size?"})
        public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"socket?"})
        public static IRubyObject socket_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.socket_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.socket_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"sticky?"})
        public static IRubyObject sticky_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.sticky_p(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.sticky_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"symlink?"})
        public static RubyBoolean symlink_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.symlink_p(context, recv2, filename2);
        }

        @Deprecated
        public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.symlink_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"writable?", "writable_real?"})
        public static RubyBoolean writable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.writable_p(context, recv2, filename2);
        }

        @Deprecated
        public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
            return FileTestFileMethods.writable_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename2);
        }

        @JRubyMethod(name={"empty?", "zero?"})
        public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.zero_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_readable?"})
        public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldReadable(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_writable?"})
        public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldWritable(context, recv2, filename2);
        }

        @Deprecated
        public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
            return RubyFileTest.identical_p(((RubyBasicObject)recv2).getCurrentContext(), recv2, filename1, filename2);
        }
    }
}

