/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.compiler.JITCounts;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;

public class JITClassGenerator {
    protected final String packageName;
    protected final String className;
    protected final String methodName;
    protected final String digestString;
    protected final JVMVisitor visitor;
    protected final String name;
    protected byte[] bytecode;
    protected long compileTime;
    public static final String CLASS_METHOD_DELIMITER = "$$";

    public JITClassGenerator(String className, String methodName, String key2, Ruby ruby, JVMVisitor visitor) {
        this.methodName = methodName;
        this.packageName = "rubyjit";
        this.visitor = visitor;
        this.digestString = Options.COMPILE_INVOKEDYNAMIC.load() != false ? key2 + Math.abs(ruby.hashCode()) : key2;
        this.className = this.packageName + "/" + className.replace('.', '/') + CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + "_" + this.digestString;
        this.name = this.className.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCounters(JITCounts counts, InterpreterContext ic) {
        counts.compiledCount.incrementAndGet();
        counts.compileTime.addAndGet(this.compileTime);
        counts.codeSize.addAndGet(this.bytecode.length);
        int insnCount = ic.getInstructions().length;
        counts.irSize.addAndGet(insnCount);
        counts.compileTimeAverage.set(counts.compileTime.get() / counts.compiledCount.get());
        counts.codeAverageSize.set(counts.codeSize.get() / counts.compiledCount.get());
        counts.irAverageSize.set(counts.irSize.get() / counts.compiledCount.get());
        JITCounts jITCounts = counts;
        synchronized (jITCounts) {
            long largest;
            while ((largest = counts.codeLargestSize.get()) < (long)this.bytecode.length && !counts.codeLargestSize.compareAndSet(largest, this.bytecode.length)) {
            }
            while ((largest = counts.irLargestSize.get()) < (long)insnCount && !counts.irLargestSize.compareAndSet(largest, insnCount)) {
            }
        }
    }

    public byte[] bytecode() {
        return this.bytecode;
    }

    public String name() {
        return this.name;
    }
}

