/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ProcMethod
extends DynamicMethod
implements PositionAware,
IRMethodArgs {
    private final RubyProc proc;

    public ProcMethod(RubyModule implementationClass, RubyProc proc2, Visibility visibility, String name2) {
        super(implementationClass, visibility, name2);
        this.proc = proc2;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        return this.proc.call(context, args2, self2, klazz, block);
    }

    @Override
    public DynamicMethod dup() {
        return new ProcMethod(this.getImplementationClass(), this.proc, this.getVisibility(), this.name);
    }

    public boolean isSame(DynamicMethod method2) {
        if (!(method2 instanceof ProcMethod)) {
            return false;
        }
        return ((ProcMethod)method2).proc == this.proc;
    }

    @Override
    @Deprecated
    public Arity getArity() {
        return this.getSignature().arity();
    }

    @Override
    public String getFile() {
        return this.proc.getBlock().getBody().getFile();
    }

    @Override
    public int getLine() {
        return this.proc.getBlock().getBody().getLine();
    }

    @Override
    public Signature getSignature() {
        return this.proc.getBlock().getBody().getSignature();
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.proc.getBlock().getBody().getArgumentDescriptors();
    }

    @Override
    public void setRuby2Keywords() {
        BlockBody body = this.proc.getBlock().getBody();
        if (body.isRubyBlock()) {
            ((IRBlockBody)body).getScope().setRuby2Keywords();
        }
    }

    public RubyProc getProc() {
        return this.proc;
    }
}

