/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public enum ArgumentType {
    key("key", false),
    keyreq("keyreq", false),
    keyrest("keyrest", false),
    block("block", false),
    opt("opt", false),
    rest("rest", false),
    req("req", false),
    anonreq("req", true),
    anonopt("opt", true),
    anonrest("rest", true),
    anonkeyrest("keyrest", true),
    nokey("nokey", true);

    public final String name;
    public final String typeId;
    public final boolean anonymous;

    private ArgumentType(String typeId, boolean anonymous) {
        this.typeId = typeId;
        this.anonymous = anonymous;
        this.name = this.toString();
    }

    public static ArgumentType valueOf(char prefix) {
        return switch (prefix) {
            case 'k' -> key;
            case 'K' -> keyreq;
            case 'e' -> keyrest;
            case 'b' -> block;
            case 'o' -> opt;
            case 'r' -> rest;
            case 'q' -> req;
            case 'l' -> nokey;
            case 'n' -> anonreq;
            case 'O' -> anonopt;
            case 'R' -> anonrest;
            case 'N' -> anonkeyrest;
            default -> null;
        };
    }

    static char prefixFrom(ArgumentType type2) {
        return switch (type2.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 'k';
            case 1 -> 'K';
            case 2 -> 'e';
            case 3 -> 'b';
            case 4 -> 'o';
            case 5 -> 'r';
            case 6 -> 'q';
            case 11 -> 'l';
            case 7 -> 'n';
            case 8 -> 'O';
            case 9 -> 'R';
            case 10 -> 'N';
        };
    }

    @Deprecated(since="10.0")
    public RubyArray toArrayForm(Ruby runtime2, RubySymbol name2) {
        return this.toArrayForm(runtime2.getCurrentContext(), name2);
    }

    public RubyArray toArrayForm(ThreadContext context, RubySymbol name2) {
        RubySymbol typeName = Convert.asSymbol(context, this.typeId);
        return this.anonymous ? Create.newArray(context, (IRubyObject)typeName) : Create.newArray(context, (IRubyObject)typeName, (IRubyObject)name2);
    }

    public ArgumentType anonymousForm() {
        switch (this.ordinal()) {
            case 4: {
                return anonopt;
            }
            case 6: {
                return anonreq;
            }
            case 5: {
                return anonrest;
            }
            case 2: {
                return anonkeyrest;
            }
        }
        return this;
    }
}

