# Contributing to killport

Thank you for considering a contribution to the killport project! We appreciate your help in making our project better. This document will guide you through the process of contributing to the killport project.

## Code of Conduct

Please read and follow our [Code of Conduct](CODE_OF_CONDUCT.md) to ensure a welcoming and inclusive environment for all contributors.

## Reporting Bugs or Requesting Features

- Before submitting a bug report or feature request, please check the existing [issues](https://github.com/jkfran/killport/issues) to avoid duplicates.
- If you find an existing issue that matches your problem or request, feel free to comment on it or add a reaction.
- If there is no existing issue, please create a new one with a clear description and steps to reproduce the bug or a detailed explanation of the requested feature.

## Contributing Code

1. Fork the repository on GitHub.
2. Clone your fork and create a new branch for your feature or bugfix.
   (use `git clone` and `git checkout -b your-feature-branch` commands)
3. Make your changes, following our coding guidelines.
4. Add tests for your changes and ensure all tests pass.
   (use `cargo test` command)
5. Commit your changes, following our commit message guidelines.
   (use `git commit -m "Your commit message"` command)
6. Push your changes to your fork.
   (use `git push origin your-feature-branch` command)
7. Create a pull request through the GitHub interface.

## Pull Request Process

1. Ensure that your pull request includes a clear and concise description of your changes.
2. Make sure your code adheres to our coding guidelines and passes all tests.
3. Be prepared for feedback from the maintainers and be open to making changes if needed.

We will review your pull request and provide feedback or merge your changes. Please be patient, as reviewing and testing changes can take time. We appreciate your contribution and will do our best to process it as quickly as possible.
