# -*- coding: utf-8 -*-
# This file is part of HSPlasma.
#
# HSPlasma is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# HSPlasma is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import annotations
from os import PathLike
import sys
from typing import *

KeyedT = TypeVar("KeyedT", bound=Union[hsKeyedObject, hsKeyedObjectStub])

A_CONTROL_MOUSE_X: int
A_CONTROL_MOUSE_Y: int
A_CONTROL_MOVE: int
A_CONTROL_TURN: int
B_CAMERA_DRIVE_SPEED_DOWN: int
B_CAMERA_DRIVE_SPEED_UP: int
B_CAMERA_MOVE_BACKWARD: int
B_CAMERA_MOVE_DOWN: int
B_CAMERA_MOVE_FAST: int
B_CAMERA_MOVE_FORWARD: int
B_CAMERA_MOVE_LEFT: int
B_CAMERA_MOVE_RIGHT: int
B_CAMERA_MOVE_UP: int
B_CAMERA_PAN_DOWN: int
B_CAMERA_PAN_LEFT: int
B_CAMERA_PAN_RIGHT: int
B_CAMERA_PAN_TO_CURSOR: int
B_CAMERA_PAN_UP: int
B_CAMERA_RECENTER: int
B_CAMERA_ROTATE_DOWN: int
B_CAMERA_ROTATE_LEFT: int
B_CAMERA_ROTATE_RIGHT: int
B_CAMERA_ROTATE_UP: int
B_CAMERA_ZOOM_IN: int
B_CAMERA_ZOOM_OUT: int
B_CONTROL_ACTION: int
B_CONTROL_ACTION_MOUSE: int
B_CONTROL_ALWAYS_RUN: int
B_CONTROL_CAMERA_WALK_PAN: int
B_CONTROL_CONSOLE_COMMAND: int
B_CONTROL_CONSUMABLE_JUMP: int
B_CONTROL_DIVE: int
B_CONTROL_DROP: int
B_CONTROL_EMOTE: int
B_CONTROL_ENABLE_OBJECT: int
B_CONTROL_EQUIP: int
B_CONTROL_EXIT_GUI_MODE: int
B_CONTROL_EXIT_MODE: int
B_CONTROL_IGNORE_AVATARS: int
B_CONTROL_JUMP: int
B_CONTROL_LADDER_INVERTED: int
B_CONTROL_MODIFIER_FAST: int
B_CONTROL_MODIFIER_STRAFE: int
B_CONTROL_MOVE_BACKWARD: int
B_CONTROL_MOVE_DOWN: int
B_CONTROL_MOVE_FORWARD: int
B_CONTROL_MOVE_UP: int
B_CONTROL_OPEN_BOOK: int
B_CONTROL_OPEN_KI: int
B_CONTROL_PICK: int
B_CONTROL_REMOVE_INV_OBJECT: int
B_CONTROL_ROTATE_DOWN: int
B_CONTROL_ROTATE_LEFT: int
B_CONTROL_ROTATE_RIGHT: int
B_CONTROL_ROTATE_UP: int
B_CONTROL_SCROLL_DOWN_LIST: int
B_CONTROL_SCROLL_UP_LIST: int
B_CONTROL_SET_EQUIPED_STATE: int
B_CONTROL_SET_INVENTORY_ACTIVE: int
B_CONTROL_SET_INVENTORY_DISACTIVE: int
B_CONTROL_STRAFE_LEFT: int
B_CONTROL_STRAFE_RIGHT: int
B_CONTROL_TOGGLE_PHYSICAL: int
B_CONTROL_TURN_TO: int
B_SET_CONSOLE_MODE: int
B_TOGGLE_DRIVE_MODE: int
KEY_0: int
KEY_1: int
KEY_2: int
KEY_3: int
KEY_4: int
KEY_5: int
KEY_6: int
KEY_7: int
KEY_8: int
KEY_9: int
KEY_A: int
KEY_ALT: int
KEY_B: int
KEY_BACKSLASH: int
KEY_BACKSPACE: int
KEY_C: int
KEY_CAPSLOCK: int
KEY_COMMA: int
KEY_CTRL: int
KEY_D: int
KEY_DASH: int
KEY_DELETE: int
KEY_DOWN: int
KEY_E: int
KEY_END: int
KEY_ENTER: int
KEY_EQUAL: int
KEY_ESCAPE: int
KEY_F: int
KEY_F1: int
KEY_F10: int
KEY_F11: int
KEY_F12: int
KEY_F2: int
KEY_F3: int
KEY_F4: int
KEY_F5: int
KEY_F6: int
KEY_F7: int
KEY_F8: int
KEY_F9: int
KEY_G: int
KEY_H: int
KEY_HOME: int
KEY_I: int
KEY_INSERT: int
KEY_J: int
KEY_K: int
KEY_L: int
KEY_LBRACKET: int
KEY_LEFT: int
KEY_M: int
KEY_N: int
KEY_NUMPAD0: int
KEY_NUMPAD1: int
KEY_NUMPAD2: int
KEY_NUMPAD3: int
KEY_NUMPAD4: int
KEY_NUMPAD5: int
KEY_NUMPAD6: int
KEY_NUMPAD7: int
KEY_NUMPAD8: int
KEY_NUMPAD9: int
KEY_NUMPAD_ADD: int
KEY_NUMPAD_DIVIDE: int
KEY_NUMPAD_MULTIPLY: int
KEY_NUMPAD_PERIOD: int
KEY_NUMPAD_SUBTRACT: int
KEY_O: int
KEY_P: int
KEY_PAGEDOWN: int
KEY_PAGEUP: int
KEY_PAUSE: int
KEY_PERIOD: int
KEY_PRINTSCREEN: int
KEY_Q: int
KEY_QUOTE: int
KEY_R: int
KEY_RBRACKET: int
KEY_RIGHT: int
KEY_S: int
KEY_SEMICOLON: int
KEY_SHIFT: int
KEY_SLASH: int
KEY_SPACE: int
KEY_T: int
KEY_TAB: int
KEY_TILDE: int
KEY_U: int
KEY_UNMAPPED: int
KEY_UP: int
KEY_V: int
KEY_W: int
KEY_X: int
KEY_Y: int
KEY_Z: int
S_CLEAR_LADDER_CONTROL: int
S_DECREASE_MIC_VOL: int
S_INCREASE_MIC_VOL: int
S_PUSH_TO_TALK: int
S_SEARCH_FOR_PICKABLE: int
S_SET_BASIC_MODE: int
S_SET_CONSOLE_HIDDEN: int
S_SET_CONSOLE_SINGLE: int
S_SET_CURSOR_ARROW: int
S_SET_CURSOR_DOWN: int
S_SET_CURSOR_HIDDEN: int
S_SET_CURSOR_LEFT: int
S_SET_CURSOR_POISED: int
S_SET_CURSOR_RIGHT: int
S_SET_CURSOR_UNHIDDEN: int
S_SET_CURSOR_UP: int
S_SET_CURSOR_UPWARD: int
S_SET_FIRST_PERSON_MODE: int
S_SET_FREELOOK: int
S_SET_LADDER_CONTROL: int
S_SET_THIRD_PERSON_MODE: int
S_SET_WALK_BACK_LB_MODE: int
S_SET_WALK_BACK_MODE: int
S_SET_WALK_MODE: int
fmCreate: int
fmRead: int
fmReadWrite: int
fmWrite: int
kBegin: int
kEnd: int
kEventEnd: int
kLoop: int
kReverse: int
kSingleFrameAdjust: int
kSingleFrameEval: int
kStart: int
kStop: int
kTime: int
pvEoa: int
pvHex: int
pvMoul: int
pvPots: int
pvPrime: int
pvUniversal: int
pvUnknown: int

def CleanFileName(filename: str, allowPathChars: bool = False) -> str: ...

class EAXReverbProperties:
    REVERB_PRESET_ALLEY: EAXReverbProperties = ...
    REVERB_PRESET_ARENA: EAXReverbProperties = ...
    REVERB_PRESET_AUDITORIUM: EAXReverbProperties = ...
    REVERB_PRESET_BATHROOM: EAXReverbProperties = ...
    REVERB_PRESET_CARPETTEDHALLWAY: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_ALCOVE: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_COURTYARD: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_CUPBOARD: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_HALL: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_LARGEROOM: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_LONGPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_MEDIUMROOM: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_SHORTPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_CASTLE_SMALLROOM: EAXReverbProperties = ...
    REVERB_PRESET_CAVE: EAXReverbProperties = ...
    REVERB_PRESET_CHAPEL: EAXReverbProperties = ...
    REVERB_PRESET_CITY: EAXReverbProperties = ...
    REVERB_PRESET_CITY_ABANDONED: EAXReverbProperties = ...
    REVERB_PRESET_CITY_LIBRARY: EAXReverbProperties = ...
    REVERB_PRESET_CITY_MUSEUM: EAXReverbProperties = ...
    REVERB_PRESET_CITY_STREETS: EAXReverbProperties = ...
    REVERB_PRESET_CITY_SUBWAY: EAXReverbProperties = ...
    REVERB_PRESET_CITY_UNDERPASS: EAXReverbProperties = ...
    REVERB_PRESET_CONCERTHALL: EAXReverbProperties = ...
    REVERB_PRESET_DIZZY: EAXReverbProperties = ...
    REVERB_PRESET_DOME_SAINTPAULS: EAXReverbProperties = ...
    REVERB_PRESET_DOME_TOMB: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_COMMENTATOR: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_EMPTYGRANDSTAND: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_FULLGRANDSTAND: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_INCAR_LUXURY: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_INCAR_RACER: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_INCAR_SPORTS: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_PITGARAGE: EAXReverbProperties = ...
    REVERB_PRESET_DRIVING_TUNNEL: EAXReverbProperties = ...
    REVERB_PRESET_DRUGGED: EAXReverbProperties = ...
    REVERB_PRESET_DUSTYROOM: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_ALCOVE: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_COURTYARD: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_CUPBOARD: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_HALL: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_LARGEROOM: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_LONGPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_MEDIUMROOM: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_SHORTPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_FACTORY_SMALLROOM: EAXReverbProperties = ...
    REVERB_PRESET_FOREST: EAXReverbProperties = ...
    REVERB_PRESET_GENERIC: EAXReverbProperties = ...
    REVERB_PRESET_HALLWAY: EAXReverbProperties = ...
    REVERB_PRESET_HANGAR: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_ALCOVE: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_COURTYARD: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_CUPBOARD: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_HALL: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_LARGEROOM: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_LONGPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_MEDIUMROOM: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_SHORTPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_ICEPALACE_SMALLROOM: EAXReverbProperties = ...
    REVERB_PRESET_LIVINGROOM: EAXReverbProperties = ...
    REVERB_PRESET_MOOD_HEAVEN: EAXReverbProperties = ...
    REVERB_PRESET_MOOD_HELL: EAXReverbProperties = ...
    REVERB_PRESET_MOOD_MEMORY: EAXReverbProperties = ...
    REVERB_PRESET_MOUNTAINS: EAXReverbProperties = ...
    REVERB_PRESET_OUTDOORS_BACKYARD: EAXReverbProperties = ...
    REVERB_PRESET_OUTDOORS_CREEK: EAXReverbProperties = ...
    REVERB_PRESET_OUTDOORS_DEEPCANYON: EAXReverbProperties = ...
    REVERB_PRESET_OUTDOORS_ROLLINGPLAINS: EAXReverbProperties = ...
    REVERB_PRESET_OUTDOORS_VALLEY: EAXReverbProperties = ...
    REVERB_PRESET_PADDEDCELL: EAXReverbProperties = ...
    REVERB_PRESET_PARKINGLOT: EAXReverbProperties = ...
    REVERB_PRESET_PIPE_LARGE: EAXReverbProperties = ...
    REVERB_PRESET_PIPE_LONGTHIN: EAXReverbProperties = ...
    REVERB_PRESET_PIPE_RESONANT: EAXReverbProperties = ...
    REVERB_PRESET_PIPE_SMALL: EAXReverbProperties = ...
    REVERB_PRESET_PLAIN: EAXReverbProperties = ...
    REVERB_PRESET_PREFAB_CARAVAN: EAXReverbProperties = ...
    REVERB_PRESET_PREFAB_OUTHOUSE: EAXReverbProperties = ...
    REVERB_PRESET_PREFAB_PRACTISEROOM: EAXReverbProperties = ...
    REVERB_PRESET_PREFAB_SCHOOLROOM: EAXReverbProperties = ...
    REVERB_PRESET_PREFAB_WORKSHOP: EAXReverbProperties = ...
    REVERB_PRESET_PSYCHOTIC: EAXReverbProperties = ...
    REVERB_PRESET_QUARRY: EAXReverbProperties = ...
    REVERB_PRESET_ROOM: EAXReverbProperties = ...
    REVERB_PRESET_SEWERPIPE: EAXReverbProperties = ...
    REVERB_PRESET_SMALLWATERROOM: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_ALCOVE: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_CUPBOARD: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_HALL: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_LARGEROOM: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_LONGPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_MEDIUMROOM: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_SHORTPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_SPACESTATION_SMALLROOM: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_EMPTYSTADIUM: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_FULLSTADIUM: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_GYMNASIUM: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_LARGESWIMMINGPOOL: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_SMALLSWIMMINGPOOL: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_SQUASHCOURT: EAXReverbProperties = ...
    REVERB_PRESET_SPORT_STADIUMTANNOY: EAXReverbProperties = ...
    REVERB_PRESET_STONECORRIDOR: EAXReverbProperties = ...
    REVERB_PRESET_STONEROOM: EAXReverbProperties = ...
    REVERB_PRESET_UNDERWATER: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_ALCOVE: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_COURTYARD: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_CUPBOARD: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_HALL: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_LARGEROOM: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_LONGPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_MEDIUMROOM: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_SHORTPASSAGE: EAXReverbProperties = ...
    REVERB_PRESET_WOODEN_SMALLROOM: EAXReverbProperties = ...
    airAbsorptionHF: float = ...
    decayHFRatio: float = ...
    decayLFRatio: float = ...
    decayTime: float = ...
    echoDepth: float = ...
    echoTime: float = ...
    environment: int = ...
    environmentDiffusion: float = ...
    environmentSize: float = ...
    flags: int = ...
    hfReference: float = ...
    kDefaultFlags: int = ...
    kFlagDecayHFLimit: int = ...
    kFlagDecayTimeScale: int = ...
    kFlagEchoTimeScale: int = ...
    kFlagModulationTimeScale: int = ...
    kFlagReflectionsDelayScale: int = ...
    kFlagReflectionsScale: int = ...
    kFlagReserved: int = ...
    kFlagReverbDelayScale: int = ...
    kFlagReverbScale: int = ...
    lfReference: float = ...
    modulationDepth: float = ...
    modulationTime: float = ...
    reflections: int = ...
    reflectionsDelay: float = ...
    reverb: int = ...
    reverbDelay: float = ...
    room: int = ...
    roomHF: int = ...
    roomLF: int = ...
    roomRolloffFactor: float = ...

class hsAffineParts:
    F: float = ...
    I: int = ...
    K: hsVector3 = ...
    Q: hsQuat = ...
    T: hsVector3 = ...
    U: hsQuat = ...

    def read(self, stream: hsStream) -> None: ...
    def reset(self) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class hsBitVector:
    def clear(self) -> None: ...
    def compact(self) -> None: ...
    def getName(self, index: int) -> str: ...
    def getValue(self, name: str) -> int: ...
    def isEmpty(self) -> bool: ...
    def read(self, stream: hsStream) -> None: ...
    def setName(self, index: int, name: str) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def __getitem__(self, index:  int) -> bool: ...
    def __setitem__(self, index: int, object: bool) -> None: ...

class hsBounds:
    type: int = ...

    def ClassName(self) -> str: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class hsBounds3(hsBounds):
    kCenterValid: int = ...
    kIsSphere: int = ...

    center: hsVector3 = ...
    maxs: hsVector3 = ...
    mins: hsVector3 = ...

class hsBounds3Ext(hsBounds3):
    kAxisAligned: int = ...
    kAxisOneZero: int = ...
    kAxisTwoZero: int = ...
    kAxisZeroZero: int = ...
    kDistsSet: int = ...
    kSphereSet: int = ...

    axis0: hsVector3 = ...
    axis1: hsVector3 = ...
    axis2: hsVector3 = ...
    corner: hsVector3 = ...
    dist0: Tuple[float, float] = ...
    dist1: Tuple[float, float] = ...
    dist2: Tuple[float, float] = ...
    flags: int = ...
    radius: float = ...

    def getAxis(self, axis: int) -> hsVector3: ...
    def getDist(self, axis: int) -> Tuple[float, float]: ...
    def setAxis(self, axis: int, value: hsVector3) -> None: ...
    def setDist(self, axis: int, value: Tuple[float, float]) -> None: ...

class hsBoundsOriented(hsBounds):
    center: hsVector3 = ...
    centerValid: int = ...
    planes: Sequence[hsPlane3] = ...

class hsColor32:
    alpha: int = ...
    blue: int = ...
    color: int = ...
    green: int = ...
    red: int = ...

    @overload
    def __init__(self, color: int = 0xFF000000) -> None: ...
    @overload
    def __init__(self, red: int = 0, green: int = 0, blue: int = 0, alpha: int = 255) -> None: ...

    def read32(self, stream: hsStream) -> None: ...
    def readRGB8(self, stream: hsStream) -> None: ...
    def readRGBA8(self, stream: hsStream) -> None: ...

    @overload
    def set(self, color: int = 0xFF000000) -> None: ...
    @overload
    def set(self, red: int = 0, green: int = 0, blue: int = 0, alpha: int = 255) -> None: ...

    def write32(self, stream: hsStream) -> None: ...
    def writeRGB8(self, stream: hsStream) -> None: ...
    def writeRGBA8(self, stream: hsStream) -> None: ...

class hsColorRGBA:
    kBlack: hsColorRGBA = ...
    kBlue: hsColorRGBA = ...
    kCyan: hsColorRGBA = ...
    kGray: hsColorRGBA = ...
    kGreen: hsColorRGBA = ...
    kMagenta: hsColorRGBA = ...
    kNone: hsColorRGBA = ...
    kRed: hsColorRGBA = ...
    kWhite: hsColorRGBA = ...
    kYellow: hsColorRGBA = ...

    alpha: int = ...
    blue: int = ...
    green: int = ...
    red: int = ...

    def __init__(self, red: float, green: float, blue: float, alpha: float = 1.0) -> None: ...
    def read(self, stream: hsStream) -> None: ...
    def readRGB(self, stream: hsStream) -> None: ...
    def set(self, red: float = 0.0, green: float = 0.0, blue: float = 0.0, alpha: float = 1.0) -> None: ...
    def setFrom(self, color: hsColorRGBA) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def writeRGB(self, stream: hsStream) -> None: ...

class hsCompressedQuatKey32(hsKeyFrame):
    kCompQuatNukeW: int = ...
    kCompQuatNukeX: int = ...
    kCompQuatNukeY: int = ...
    kCompQuatNukeZ: int = ...

    value: hsQuat = ...

    def setValue(self, quat: hsQuat, type: int) -> None: ...

class hsCompressedQuatKey64(hsKeyFrame):
    kCompQuatNukeW: int = ...
    kCompQuatNukeX: int = ...
    kCompQuatNukeY: int = ...
    kCompQuatNukeZ: int = ...

    value: hsQuat = ...

    def setValue(self, quat: hsQuat, type: int) -> None: ...

class hsFileStream(hsStream):
    def open(self, filename: Union[PathLike, str], mode: int) -> hsFileStream: ...
    def close(self) -> None: ...
    def __enter__(self) -> hsFileStream: ...
    def __exit__(self, type, value, traceback) -> None: ...

class hsG3DSMaxKeyFrame(hsKeyFrame):
    value: hsAffineParts = ...

class hsGMatState:
    kAllMiscFlags: int = ...
    kBlendAdd: int = ...
    kBlendAddColorTimesAlpha: int = ...
    kBlendAddSigned: int = ...
    kBlendAddSigned2X: int = ...
    kBlendAlpha: int = ...
    kBlendAlphaAdd: int = ...
    kBlendAlphaAlways: int = ...
    kBlendAlphaMult: int = ...
    kBlendAlphaTestHigh: int = ...
    kBlendAntiAlias: int = ...
    kBlendDetail: int = ...
    kBlendDot3: int = ...
    kBlendEnvBumpNext: int = ...
    kBlendInvertAlpha: int = ...
    kBlendInvertColor: int = ...
    kBlendInvertFinalAlpha: int = ...
    kBlendInvertFinalColor: int = ...
    kBlendInvertVtxAlpha: int = ...
    kBlendMADD: int = ...
    kBlendMask: int = ...
    kBlendMult: int = ...
    kBlendNoColor: int = ...
    kBlendNoTexAlpha: int = ...
    kBlendNoTexColor: int = ...
    kBlendNoVtxAlpha: int = ...
    kBlendRevSubtract: int = ...
    kBlendSubtract: int = ...
    kBlendTest: int = ...
    kClampTexture: int = ...
    kClampTextureU: int = ...
    kClampTextureV: int = ...
    kMiscAdjust: int = ...
    kMiscAdjustCylinder: int = ...
    kMiscAdjustPlane: int = ...
    kMiscAdjustSphere: int = ...
    kMiscBindMask: int = ...
    kMiscBindNext: int = ...
    kMiscBindSkip: int = ...
    kMiscBumpChans: int = ...
    kMiscBumpDu: int = ...
    kMiscBumpDv: int = ...
    kMiscBumpDw: int = ...
    kMiscBumpLayer: int = ...
    kMiscCam2Screen: int = ...
    kMiscDrawAsSplats: int = ...
    kMiscDrawMeshOutlines: int = ...
    kMiscLightMap: int = ...
    kMiscNoShadowAlpha: int = ...
    kMiscOrthoProjection: int = ...
    kMiscPerspProjection: int = ...
    kMiscProjection: int = ...
    kMiscRestartPassHere: int = ...
    kMiscTroubledLoner: int = ...
    kMiscTwoSided: int = ...
    kMiscUseReflectionXform: int = ...
    kMiscUseRefractionXform: int = ...
    kMiscWireFrame: int = ...
    kShadeBlack: int = ...
    kShadeEmissive: int = ...
    kShadeEnvironMap: int = ...
    kShadeIgnoreVtxIllum: int = ...
    kShadeInherit: int = ...
    kShadeNoFog: int = ...
    kShadeNoProjectors: int = ...
    kShadeNoShade: int = ...
    kShadeReallyNoFog: int = ...
    kShadeSoftShadow: int = ...
    kShadeSpecular: int = ...
    kShadeSpecularAlpha: int = ...
    kShadeSpecularColor: int = ...
    kShadeSpecularHighlight: int = ...
    kShadeVertColShade: int = ...
    kShadeVertexShade: int = ...
    kShadeWhite: int = ...
    kZClearZ: int = ...
    kZIncLayer: int = ...
    kZLODBias: int = ...
    kZMask: int = ...
    kZNoZRead: int = ...
    kZNoZWrite: int = ...

    ZFlags: int = ...
    blendFlags: int = ...
    clampFlags: int = ...
    miscFlags: int = ...
    shadeFlags: int = ...

class hsGMaterial(plSynchedObject):
    kCompAdjusted: int = ...
    kCompDecal: int = ...
    kCompDrawAsSplats: int = ...
    kCompDynamic: int = ...
    kCompEnvironMap: int = ...
    kCompIsEmissive: int = ...
    kCompIsLightMapped: int = ...
    kCompNeedsBlendChannel: int = ...
    kCompNoSoftShadow: int = ...
    kCompProjectOnto: int = ...
    kCompShaded: int = ...
    kCompSoftShadow: int = ...
    kCompSpecular: int = ...
    kCompTwoSided: int = ...

    compFlags: int = ...
    layers: Sequence[plKey[plLayerInterface]] = ...
    loadFlags: int = ...
    piggyBacks: Sequence[plKey[plLayerInterface]] = ...

    def addLayer(self, key: plKey[plLayerInterface]) -> None: ...
    def addPiggyBack(self, key: plKey[plLayerInterface]) -> None: ...
    def clearLayers(self) -> None: ...
    def clearPiggyBacks(self) -> None: ...
    def delLayer(self, idx: int) -> None: ...
    def delPiggyBack(self, idx: int) -> None: ...

class hsKeyFrame:
    k3dsMaxKeyFrame: int = ...
    kBezPoint3KeyFrame: int = ...
    kBezScalarKeyFrame: int = ...
    kBezScaleKeyFrame: int = ...
    kCompressedQuatKeyFrame32: int = ...
    kCompressedQuatKeyFrame64: int = ...
    kMatrix33KeyFrame: int = ...
    kMatrix44KeyFrame: int = ...
    kPoint3KeyFrame: int = ...
    kQuatKeyFrame: int = ...
    kScalarKeyFrame: int = ...
    kScaleKeyFrame: int = ...
    kUnknownKeyFrame: int = ...

    frame: int = ...
    frameTime: float = ...
    type: int = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class hsKeyedObject(plCreatable):
    # On Python 3.11 and later, this could be spelled as:
    # key: plKey[Self] = ...
    @property
    def key(self: KeyedT) -> plKey[KeyedT]: ...

    def __init__(self, name: str = "") -> None: ...
    def orderAfter(self, otherObj: hsKeyedObject) -> bool: ...

class hsKeyedObjectStub(plCreatable):
    stub: plCreatableStub = ...

    def __init__(self, name: str = "") -> None: ...

class hsMatrix33:
    mat: Tuple[Tuple[float, float, float],
               Tuple[float, float, float],
               Tuple[float, float, float]] = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def __getitem__(self, index: Tuple[int, int]) -> float: ...
    def __setitem__(self, index: Tuple[int, int], object: float) -> None: ...

class hsMatrix33Key(hsKeyFrame):
    value: hsMatrix33 = ...

class hsMatrix44:
    kRight: int = ...
    kUp: int = ...
    kView: int = ...

    glMat: Tuple[Tuple[float, float, float, float],
                 Tuple[float, float, float, float],
                 Tuple[float, float, float, float],
                 Tuple[float, float, float, float]] = ...
    mat: Tuple[Tuple[float, float, float, float],
               Tuple[float, float, float, float],
               Tuple[float, float, float, float],
               Tuple[float, float, float, float]] = ...

    @staticmethod
    def Identity() -> hsMatrix44: ...
    @staticmethod
    def RotateMat(axis: int, angle: float) -> hsMatrix44: ...
    @staticmethod
    def ScaleMat(vector: hsVector3) -> hsMatrix44: ...
    @staticmethod
    def TranslateMat(vector: hsVector3) -> hsMatrix44: ...

    def inverse(self) -> hsMatrix44: ...
    def isIdentity(self) -> bool: ...
    def multPoint(self, vector: hsVector3) -> hsVector3: ...
    def multVector(self, vector: hsVector3) -> hsVector3: ...
    def read(self, stream: hsStream) -> None: ...
    def rotate(self, axis: int, angle: float) -> None: ...
    def scale(self, vector: hsVector3) -> None: ...
    def setRotate(self, axis: int, angle: float) -> None: ...
    def setScale(self, vector: hsVector3) -> None: ...
    def setTranslate(self, vector: hsVector3) -> None: ...
    def translate(self, vector: hsVector3) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def __getitem__(self, index: Tuple[int, int]) -> float: ...
    def __mul__(self, other: hsMatrix44) -> hsMatrix44: ...
    def __setitem__(self, index: Tuple[int, int], object: float) -> None: ...

class hsMatrix44Key(hsKeyFrame):
    value: hsMatrix44 = ...

class hsPlane3:
    W: float = ...
    X: float = ...
    Y: float = ...
    Z: float = ...

    def __init__(self, x: float = 0.0, y: float = 0.0, z: float = 0.0, w: float = 0.0) -> None: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class hsPoint3Key(hsKeyFrame):
    inTan: hsVector3 = ...
    outTan: hsVector3 = ...
    value: hsVector3 = ...

class hsQuat:
    W: float = ...
    X: float = ...
    Y: float = ...
    Z: float = ...

    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def __init__(self, rad: float, axis: hsVector3) -> None: ...

    @staticmethod
    def Identity() -> hsQuat: ...
    def conjugate(self) -> hsQuat: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def __abs__(self) -> hsQuat: ...
    def __add__(self, other: hsQuat) -> hsQuat: ...
    def __bool__(self) -> bool: ...
    def __mul__(self, other: Union[float, hsQuat]) -> hsQuat: ...
    def __neg__(self) -> hsQuat: ...
    def __pos__(self) -> hsQuat: ...
    def __rmul__(self, other: float) -> hsQuat: ...
    def __sub__(self, other: hsQuat) -> hsQuat: ...

class hsQuatKey(hsKeyFrame):
    value: hsQuat = ...

class hsRAMStream(hsStream):
    buffer: bytes = ...

    def resize(self, newsize: int) -> None: ...

class hsScalarKey(hsKeyFrame):
    inTan: float = ...
    outTan: float = ...
    value: float = ...

class hsScaleKey(hsKeyFrame):
    inTan: hsVector3 = ...
    outTan: hsVector3 = ...
    value: Tuple[hsVector3, hsQuat] = ...

class hsStream:
    pos: int = ...
    size: int = ...
    version: int = ...

    def __init__(self, ver: int = pvUnknown) -> None: ...
    def eof(self) -> bool: ...
    def fastForward(self) -> None: ...
    def flush(self) -> None: ...
    def read(self, size: int) -> bytes: ...
    def readBool(self) -> bool: ...
    def readByte(self) -> int: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readSafeStr(self) -> str: ...
    def readSafeWStr(self) -> str: ...
    def readShort(self) -> int: ...
    def rewind(self) -> None: ...
    def seek(self, position: int) -> None: ...
    def skip(self, count: int) -> None: ...
    def write(self, data: bytes) -> None: ...
    def writeBool(self, value: bool) -> None: ...
    def writeByte(self, value: int) -> None: ...
    def writeDouble(self, value: float) -> None: ...
    def writeFloat(self, value: float) -> None: ...
    def writeFrom(self, stream: hsStream) -> None: ...
    def writeInt(self, value: int) -> None: ...
    def writeLine(self, value: str) -> None: ...
    def writeSafeStr(self, value: str) -> None: ...
    def writeSafeWStr(self, value: str) -> None: ...
    def writeShort(self, value: int) -> None: ...

class hsVector3:
    X: float = ...
    Y: float = ...
    Z: float = ...

    def __init__(self, x = 0.0, y = 0.0, z = 0.0) -> None: ...
    def crossP(self, vec: hsVector3) -> hsVector3: ...
    def dotP(self, vec: hsVector3) -> float: ...
    def magnitude(self) -> float: ...
    def normalize(self) -> hsVector3: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def __abs__(self) -> hsVector3: ...
    def __add__(self, other: hsVector3) -> hsVector3: ...
    def __bool__(self) -> bool: ...
    def __mul__(self, other: Union[float, hsVector3]) -> hsVector3: ...
    def __neg__(self) -> hsVector3: ...
    def __pos__(self) -> hsVector3: ...
    def __rmul__(self, other: float) -> hsVector3: ...
    def __sub__(self, other: hsVector3) -> hsVector3: ...

if sys.platform == "win32":
    class hsWindowsStream(hsStream):
        def open(self, filename: Union[PathLike, str], mode: int) -> hsWindowsStream: ...
        def close(self) -> None: ...
        def __enter__(self) -> hsWindowsStream: ...
        def __exit__(self, type, value, traceback) -> None: ...

class pfGUIButtonMod(pfGUIControlMod):
    kNotifyOnDown: int = ...
    kNotifyOnUp: int = ...
    kNotifyOnUpAndDown: int = ...
    kMouseDown: int = ...
    kMouseUp: int = ...
    kMouseOver: int = ...
    kMouseOff: int = ...

    animName: str = ...
    animationKeys: Sequence[plKey] = ...
    draggable: Optional[plKey[pfGUIDraggableMod]] = ...
    mouseOverAnimName: str = ...
    mouseOverKeys: Sequence[plKey] = ...
    notifyType: int = ...

    def addAnimationKey(self, key: plKey) -> None: ...
    def addMouseOverKey(self, key: plKey) -> None: ...
    def clearAnimationKeys(self) -> None: ...
    def clearMouseOverKeys(self) -> None: ...
    def delAnimationKey(self, idx: int) -> None: ...
    def delMouseOverKey(self, int: int) -> None: ...

class pfGUICheckBoxCtrl(pfGUIControlMod):
    kMouseDown: int = ...
    kMouseUp: int = ...
    kMouseOver: int = ...
    kMouseOff: int = ...

    animKeys: Sequence[plKey] = ...
    animName: str = ...
    checked: bool = ...

    def addAnimKey(self, key: plKey) -> None: ...
    def clearAnimKeys(self) -> None: ...
    def delAnimKey(self, idx: int) -> None: ...

class pfGUIClickMapCtrl(pfGUIControlMod):
    kReportDragging: int = ...
    kReportHovering: int = ...

class pfGUICloseDlgProc(pfGUICtrlProcWriteableObject):
    pass

class pfGUIColorScheme:
    kFontBold: int = ...
    kFontItalic: int = ...
    kFontShadowed: int = ...

    backColor: hsColorRGBA = ...
    fontFace: str = ...
    fontFlags: int = ...
    fontSize: int = ...
    foreColor: hsColorRGBA = ...
    selBackColor: hsColorRGBA = ...
    selForeColor: hsColorRGBA = ...
    transparent: bool = ...

class pfGUIConsoleCmdProc(pfGUICtrlProcWriteableObject):
    command: str = ...

class pfGUIControlMod(plSingleModifier):
    kBetterHitTesting: int = ...
    kHasProxy: int = ...
    kInheritProcFromDlg: int = ...
    kIntangible: int = ...
    kScaleTextWithResolution: int = ...
    kTakesSpecialKeys: int = ...
    kWantsInterest: int = ...
    kXparentBgnd: int = ...

    colorScheme: pfGUIColorScheme = ...
    dynTextLayer: Optional[plKey[plLayerInterface]] = ...
    dynTextMap: Optional[plKey[plDynamicTextMap]] = ...
    handler: Optional[pfGUICtrlProcWriteableObject] = ...
    proxy: Optional[plKey[plSceneObject]] = ...
    skin: Optional[plKey[pfGUISkin]] = ...
    soundIndices: Sequence[int] = ...
    tagID: int = ...
    visible: bool = ...

    def clearSoundIndices(self) -> None: ...

class pfGUICtrlProcObject:
    pass

class pfGUICtrlProcWriteableObject(pfGUICtrlProcObject):
    kCloseDlg: int = ...
    kConsoleCmd: int = ...
    kNull: int = ...
    kPythonScript: int = ...

    type: int = ...

    @staticmethod
    def Read(stream: hsStream) -> pfGUICtrlProcWriteableObject: ...
    @staticmethod
    def Write(stream: hsStream, proc: pfGUICtrlProcWriteableObject) -> None: ...

class pfGUIDialogMod(plSingleModifier):
    kModal: int = ...
    kDerivedFlagsStart: int = ...

    colorScheme: pfGUIColorScheme = ...
    controls: Sequence[plKey[pfGUIControlMod]] = ...
    name: str = ...
    procReceiver: Optional[plKey] = ...
    renderMod: Optional[plKey[plPostEffectMod]] = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    tagID: int = ...
    version: int = ...

    def addControl(self, control: plKey[pfGUIControlMod]) -> None: ...
    def clearControls(self) -> None: ...
    def delControl(self, idx: int) -> None: ...

class pfGUIDialogProc(pfGUICtrlProcObject):
    pass

class pfGUIDragBarCtrl(pfGUIControlMod):
    pass

class pfGUIDraggableMod(pfGUIControlMod):
    kAlwaysSnapBackToStart: int = ...
    kHideCursorWhileDragging: int = ...
    kReportDragging: int = ...

class pfGUIDynDisplayCtrl(pfGUIControlMod):
    layers: Sequence[plKey[plLayerInterface]] = ...
    materials: Sequence[plKey[hsGMaterial]] = ...
    textMaps: Sequence[plKey[plDynamicTextMap]] = ...

    def addLayer(self, layer: plKey[plLayerInterface]) -> None: ...
    def addMaterial(self, material: plKey[hsGMaterial]) -> None: ...
    def addTextMap(self, textMap: plKey[plDynamicTextMap]) -> None: ...
    def clearLayers(self) -> None: ...
    def clearMaterials(self) -> None: ...
    def clearTextMaps(self) -> None: ...
    def delLayer(self, idx: int) -> None: ...
    def delMaterial(self, idx: int) -> None: ...
    def delTextMap(self, idx: int) -> None: ...

class pfGUIEditBoxMod(pfGUIControlMod):
    ...

class pfGUIKnobCtrl(pfGUIValueCtrl):
    kLeftRightOrientation: int = ...
    kMapToAnimationRange: int = ...
    kMapToScreenRange: int = ...
    kReverseValues: int = ...
    kTriggerOnlyOnMouseUp: int = ...

    animEndPos: hsVector3 = ...
    animName: str = ...
    animStartPos: hsVector3 = ...
    animationKeys: Sequence[plKey] = ...

    def addAnimationKey(self, key: plKey) -> None: ...
    def clearAnimationKeys(self) -> None: ...
    def delAnimationKey(self, idx: int) -> None: ...

class pfGUIListBoxMod(pfGUIControlMod):
    kAllowMousePassThrough: int = ...
    kAllowMultipleElementsPerRow: int = ...
    kDisableKeyActions: int = ...
    kDisableSelection: int = ...
    kDragAndDropCapable: int = ...
    kForbidNoSelection: int = ...
    kGrowLeavesAndProcessOxygen: int = ...
    kHandsOffMultiSelect: int = ...
    kScrollLeftToRight: int = ...
    kSingleSelect: int = ...

    scrollCtrl: Optional[plKey[pfGUIValueCtrl]] = ...

class pfGUIMenuItem(pfGUIButtonMod):
    kDrawSubMenuArrow: int = ...
    kReportHovers: int = ...

class pfGUIMultiLineEditCtrl(pfGUIControlMod):
    scrollCtrl: Optional[plKey[pfGUIValueCtrl]] = ...

class pfGUIPopUpMenu(pfGUIDialogMod):
    kAlignDownLeft: int = ...
    kAlignDownRight: int = ...
    kAlignUpLeft: int = ...
    kAlignUpRight: int = ...
    kModalOutsideMenus: int = ...
    kOpenSubMenusOnHover: int = ...
    kScaleWithResolution: int = ...
    kStayOpenAfterClick: int = ...

    alignment: int = ...
    margin: int = ...
    originAnchor: Optional[plKey[plSceneObject]] = ...
    originContext: Optional[plKey[pfGUIDialogMod]] = ...
    skin: Optional[plKey[pfGUISkin]] = ...

class pfGUIProgressCtrl(pfGUIValueCtrl):
    kLeftRightOrientation: int = ...
    kMapToAnimationRange: int = ...
    kMapToScreenRange: int = ...
    kReverseValues: int = ...
    kTriggerOnlyOnMouseUp: int = ...
    kAnimateSound: int = ...

    animKeys: Sequence[plKey] = ...
    animName: str = ...

    def addAnimKey(self, key: plKey) -> None: ...
    def clearAnimKeys(self) -> None: ...
    def delAnimKey(self, idx: int) -> None: ...

class pfGUIPythonScriptProc(pfGUICtrlProcWriteableObject):
    ...

class pfGUIRadioGroupCtrl(pfGUIControlMod):
    kAllowNoSelection: int = ...

    controls: Sequence[plKey[pfGUICheckBoxCtrl]] = ...
    defaultValue: int = ...

    def addControl(self, key: plKey[pfGUICheckBoxCtrl]) -> None: ...
    def clearControls(self) -> None: ...
    def delControl(self, idx: int) -> None: ...

class pfGUISkin(hsKeyedObject):
    kBottomSpan: int = ...
    kLeftSpan: int = ...
    kLowerLeftCorner: int = ...
    kLowerRightCorner: int = ...
    kMiddleFill: int = ...
    kRightSpan: int = ...
    kSelectedFill: int = ...
    kSelectedSubMenuArrow: int = ...
    kSubMenuArrow: int = ...
    kTopSpan: int = ...
    kTreeButtonClosed: int = ...
    kTreeButtonOpen: int = ...
    kUpLeftCorner: int = ...
    kUpRightCorner: int = ...

    borderMargin: int = ...
    itemMargin: int = ...
    texture: Optional[plKey[plMipmap]] = ...

class pfGUITextBoxMod(pfGUIControlMod):
    kCenterJustify: int = ...
    kRightJustify: int = ...

    localizationPath: str = ...
    text: str = ...

class pfGUIUpDownPairMod(pfGUIValueCtrl):
    downControl: Optional[plKey[pfGUIButtonMod]] = ...
    upControl: Optional[plKey[pfGUIButtonMod]] = ...

class pfGUIValueCtrl(pfGUIControlMod):
    max: float = ...
    min: float = ...
    step: float = ...

class pfPrcHelper:
    kExcludeTextureData: int = ...
    kExcludeVertexData: int = ...
    kNone: int = ...

class pl2WayWinAudible(plWinAudible):
    ...

class plAGAnim(plSynchedObject):
    kBodyFull: int = ...
    kBodyLower: int = ...
    kBodyMax: int = ...
    kBodyUnknown: int = ...
    kBodyUpper: int = ...

    applicators: Sequence[plAGApplicator] = ...
    blend: float = ...
    end: float = ...
    name: str = ...
    start: float = ...

    def addApplicator(self, applicator: plAGApplicator) -> None: ...
    def clearApplicators(self) -> None: ...
    def delApplicator(self, idx: int) -> None: ...

class plAGAnimBink(plATCAnim):
    binkFilename: Union[PathLike, str] = ...
    sgtFilename: Union[PathLike, str] = ...
    subtitleId: str = ...

class plAGApplicator(plCreatable):
    channel: plAGChannel = ...
    channelName: str = ...
    enabled: bool = ...

class plAGChannel(plCreatable):
    name: str = ...

class plAGMasterMod(plSingleModifier):
    eoaKeys: Sequence[plKey] = ...
    groupName: str = ...
    isGroupMaster: bool = ...
    isGrouped: bool = ...
    msgForwarder: Optional[plKey[plMsgForwarder]] = ...
    privateAnims: Sequence[plKey[plAGAnim]] = ...

    def addEoaKey(self, key: plKey) -> None: ...
    def addPrivateAnim(self, anim: plKey[plAGAnim]) -> None: ...
    def clearEoaKeys(self) -> None: ...
    def clearPrivateAnims(self) -> None: ...
    def delEoaKey(self, idx: int) -> None: ...
    def delPrivateAnim(self, idx: int) -> None: ...

class plAGModifier(plModifier):
    autoApply: bool = ...
    channelName: str = ...
    enabled: bool = ...

class plANDConditionalObject(plConditionalObject):
    children: Sequence[plKey[plConditionalObject]] = ...

    def addChild(self, child: plKey[plConditionalObject]) -> None: ...
    def clearChildren(self) -> None: ...
    def delChild(self, idx: int) -> None: ...

class plATCAnim(plAGAnim):
    autoStart: bool = ...
    easeInLength: float = ...
    easeInMax: float = ...
    easeInMin: float = ...
    easeInType: int = ...
    easeOutLength: float = ...
    easeOutMax: float = ...
    easeOutMin: float = ...
    easeOutType: int = ...
    initial: float = ...
    loop: bool = ...
    loopEnd: float = ...
    loopStart: float = ...
    loops: Dict[str, Tuple[float, float]] = ...
    markers: Dict[str, float]  = ...
    stops: Sequence[float] = ...

    def clearLoops(self) -> None: ...
    def clearMarkers(self) -> None: ...
    def setLoop(self, key: str, begin: float, end: float) -> None: ...
    def setMarker(self, key: str, position: float) -> None: ...

class plATCChannel(plScalarChannel):
    ...

class plATCEaseCurve(plCreatable):
    beginWorldTime: float = ...
    length: float = ...
    maxLength: float = ...
    minLength: float = ...
    speed: float = ...
    startSpeed: float = ...

class plActivatorActivatorConditionalObject(plActivatorConditionalObject):
    ...

class plActivatorConditionalObject(plConditionalObject):
    activators: Sequence[plKey] = ...

    def addActivator(self, activator: plKey) -> None: ...
    def clearActivators(self) -> None: ...
    def delActivator(self, idx: int) -> None: ...

class plActivePrintShape(plPrintShape):
    decalMgrs: Sequence[plKey] = ...

    def addDecalMgr(self, key: plKey) -> None: ...
    def clearDecalMgrs(self) -> None: ...
    def delDecalMgr(self, idx: int) -> None: ...

class plAgeGlobalAnim(plAGAnim):
    globalVarName: str = ...

class plAgeInfo:
    kCommonPages: int = ...
    kFlagIsLocalOnly: int = ...
    kFlagIsVolatile: int = ...
    kFlagLoadIfSDLPresent: int = ...
    kFlagPreventAutoLoad: int = ...
    kNumCommonPages: int = ...
    kPageGlobal: int = ...
    kPageTextures: int = ...

    dayLength: float = ...
    lingerTime: int = ...
    maxCapacity: int = ...
    name: Union[PathLike, str] = ...
    releaseVersion: int = ...
    seqPrefix: int = ...
    startDateTime: int = ...

    def addPage(self, page: Tuple[str, int, int]) -> None: ...
    def getCommonPage(self, idx: int, version: int) -> Tuple[str, int, int]: ...
    def getCommonPageFilename(self, idx: int, version: int) -> str: ...
    def getCommonPageLoc(self, idx: int, version: int) -> plLocation: ...
    def getNumCommonPages(self, version: int) -> int: ...
    def getNumPages(self) -> int: ...
    def getPage(self, idx: int) -> Tuple[str, int, int]: ...
    def getPageFilename(self, idx: int, version: int) -> str: ...
    def getPageLoc(self, idx: int, version: int) -> plLocation: ...
    def readFromFile(self, filename: Union[PathLike, str]) -> None: ...
    def readFromStream(self, stream: hsStream) -> None: ...
    def setPage(self, idx: int, page: Tuple[str, int, int]) -> None: ...
    def writeToFile(self, filename: Union[PathLike, str]) -> None: ...
    def writeToStream(self, stream: hsStream) -> None: ...

class plAgeInfoStruct(plCreatable):
    ageFilename: str = ...
    ageInstanceGuid: str = ...
    ageInstanceName: str = ...

class plAgeLinkEffects:
    linkInAnimName: Optional[plKey] = ...

class plAgeLinkStruct(plCreatable):
    kBasicLink: int = ...
    kChildAgeBook: int = ...
    kOriginalBook: int = ...
    kOwnedBook: int = ...
    kSubAgeBook: int = ...
    kVisitBook: int = ...

    ageInfo: Optional[plAgeInfoStruct] = ...
    linkingRules: int = ...
    parentAgeFilename: str = ...
    spawnPoint: Optional[plSpawnPointInfo] = ...

class plAnimCmdMsg(plMessageWithCallbacks):
    kAddCallbacks: int = ...
    kContinue: int = ...
    kFastForward: int = ...
    kGoToBegin: int = ...
    kGoToEnd: int = ...
    kGoToLoopBegin: int = ...
    kGoToLoopEnd: int = ...
    kGoToPercent: int = ...
    kGoToTime: int = ...
    kIncrementBackward: int = ...
    kIncrementForward: int = ...
    kNumCmds: int = ...
    kPlayToPercentage: int = ...
    kPlayToTime: int = ...
    kRemoveCallbacks: int = ...
    kRunBackward: int = ...
    kRunForward: int = ...
    kSetBackwards: int = ...
    kSetBegin: int = ...
    kSetEnd: int = ...
    kSetForwards: int = ...
    kSetLoopBegin: int = ...
    kSetLoopEnd: int = ...
    kSetLooping: int = ...
    kSetSpeed: int = ...
    kStop: int = ...
    kToggleState: int = ...
    kUnSetLooping: int = ...

    animName: str = ...
    begin: float = ...
    end: float = ...
    loopBegin: float = ...
    loopEnd: float = ...
    loopName: str = ...
    speed: float = ...
    speedChangeRate: float = ...
    time: float = ...

    def getCmd(self, cmd: int) -> bool: ...
    def setCmd(self, cmd: int, value: bool) -> None: ...

class plAnimPath(plCreatable):
    kCalcPosOnly: int = ...
    kFarthest: int = ...
    kFavorBwdSearch: int = ...
    kFavorFwdSearch: int = ...
    kIncrement: int = ...
    kNone: int = ...
    kWrap: int = ...

    affineParts: hsAffineParts = ...
    controller: Optional[Union[plCompoundController, plTMController]] = ...
    flags: int = ...
    length: float = ...
    localToWorld: hsMatrix44 = ...
    minDistSq: float = ...
    worldToLocal: hsMatrix44 = ...

class plAnimStage(plCreatable):
    kAdvanceAuto: int = ...
    kAdvanceMax: int = ...
    kAdvanceNone: int = ...
    kAdvanceOnintKey: int = ...
    kAdvanceOnMove: int = ...
    kNotifyAdvance: int = ...
    kNotifyEnter: int = ...
    kNotifyLoop: int = ...
    kNotifyRegress: int = ...
    kPlayAuto: int = ...
    kPlayKey: int = ...
    kPlayMax: int = ...
    kPlayNone: int = ...

    advanceTo: Optional[int] = ...
    advanceType: int = ...
    animName: str = ...
    backType: int = ...
    forwardType: int = ...
    loops: int = ...
    notify: int = ...
    regressTo: Optional[int] = ...
    regressType: int = ...

class plAnimTimeConvert(plCreatable):
    kBackwards: int = ...
    kEasingIn: int = ...
    kFlagsMask: int = ...
    kForcedMove: int = ...
    kLoop: int = ...
    kNeedsReset: int = ...
    kNoCallbacks: int = ...
    kNone: int = ...
    kStopped: int = ...
    kWrap: int = ...

    begin: float = ...
    callbacks: Sequence[plEventCallbackMsg] = ...
    currentAnimTime: float = ...
    easeInCurve: Optional[plATCEaseCurve] = ...
    easeOutCurve: Optional[plATCEaseCurve] = ...
    end: float = ...
    flags: int = ...
    lastEvalWorldTime: float = ...
    loopBegin: float = ...
    loopEnd: float = ...
    speed: float = ...
    speedEaseCurve: Optional[plATCEaseCurve] = ...
    stopPoints: Sequence[float] = ...

    def addCallback(self, callback: plEventCallbackMsg) -> None: ...
    def clearCallbacks(self) -> None: ...
    def delCallback(self, idx: int) -> None: ...

class plAnimationEventConditionalObject(plConditionalObject):
    action: int = ...
    target: Optional[plKey] = ...

class plArmatureEffectStateMsg(plMessage):
    addSurface: bool = ...
    surface: int = ...

class plAudible(hsKeyedObject):
    ...

class plAudibleNull(plAudible):
    ...

class plAudioInterface(plObjInterface):
    audible: Optional[plKey[plAudible]] = ...

class plAvLadderMod(plSingleModifier):
    kBig: int = ...
    kFourFeet: int = ...
    kTwoFeet: int = ...

    enabled: bool = ...
    goingUp: bool = ...
    ladderView: hsVector3 = ...
    loops: int = ...
    type: int = ...

class plBitmap(hsKeyedObject):
    kAInten88: int = ...
    kAlphaBitFlag: int = ...
    kAlphaChannelFlag: int = ...
    kBumpEnvMap: int = ...
    kDXT1: int = ...
    kDXT3: int = ...
    kDXT5: int = ...
    kDXTError: int = ...
    kDirectSpace: int = ...
    kDirectXCompression: int = ...
    kDontThrowAwayImage: int = ...
    kForce32Bit: int = ...
    kForceNonCompressed: int = ...
    kForceOneMipLevel: int = ...
    kForceRewrite: int = ...
    kGraySpace: int = ...
    kHalfSize: int = ...
    kIndexSpace: int = ...
    kInten8: int = ...
    kIntensityMap: int = ...
    kIsOffscreen: int = ...
    kIsOrtho: int = ...
    kIsProjected: int = ...
    kIsTexture: int = ...
    kJPEGCompression: int = ...
    kNoMaxSize: int = ...
    kNoSpace: int = ...
    kPNGCompression: int = ...
    kRGB1555: int = ...
    kRGB4444: int = ...
    kRGB8888: int = ...
    kUncompressed: int = ...
    kUserOwnsBitmap: int = ...

    ARGBType: int = ...
    BPP: int = ...
    DXBlockSize: int = ...
    DXCompression: int = ...
    compressionType: int = ...
    flags: int = ...
    modTime: Tuple[int, int] = ...
    space: int = ...

    def setConfig(self, format: int) -> None: ...

class plBoundInterface(plObjInterface):
    kDisable: int = ...
    kNumProps: int = ...

    bounds: Optional[plConvexVolume] = ...

class plCameraBrain(hsKeyedObject):
    ...

class plCameraBrain1(plCameraBrain):
    kAnimateFOV: int = ...
    kBeginFalling: int = ...
    kCircleTarget: int = ...
    kCutPOA: int = ...
    kCutPOAOnce: int = ...
    kCutPOAWhilePan: int = ...
    kCutPos: int = ...
    kCutPosOnce: int = ...
    kCutPosWhilePan: int = ...
    kFalling: int = ...
    kFallingStopped: int = ...
    kFollowLocalAvatar: int = ...
    kIgnoreSubworldMovement: int = ...
    kIsTransitionCamera: int = ...
    kMaintainLOS: int = ...
    kNeverAnimateFOV: int = ...
    kNonPhys: int = ...
    kPanicVelocity: int = ...
    kRailComponent: int = ...
    kRunning: int = ...
    kSpeedUpWhenRunning: int = ...
    kSubject: int = ...
    kVerticalWhenFalling: int = ...
    kWorldspacePOA: int = ...
    kWorldspacePos: int = ...
    kZoomEnabled: int = ...

    acceleration: float = ...
    deceleration: float = ...
    panSpeed: float = ...
    poaAcceleration: float = ...
    poaDeceleration: float = ...
    poaOffset: hsVector3 = ...
    poaVelocity: float = ...
    rail: Optional[plKey[plRailCameraMod]] = ...
    subject: Optional[plKey[plSceneObject]] = ...
    velocity: float = ...
    xPanLimit: float = ...
    zPanLimit: float = ...
    zoomMax: float = ...
    zoomMin: float = ...
    zoomRate: float = ...

    def getEoAFlags(self, flag: int) -> bool: ...
    def getFlags(self, flag: int) -> bool: ...
    def setEoAFlags(self, flag: int, value: bool) -> None: ...
    def setFlags(self, flag: int, value: bool) -> None: ...

class plCameraBrain1_Avatar(plCameraBrain1):
    offset: hsVector3 = ...

class plCameraBrain1_Circle(plCameraBrain1_Fixed):
    kAbsoluteLag: int = ...
    kCircleLocalAvatar: int = ...
    kFarthest: int = ...
    kHasCenterObject: int = ...
    kLagged: int = ...
    kPOAObject: int = ...
    kTargetted: int = ...

    center: hsVector3 = ...
    centerObject: Optional[plKey[plSceneObject]] = ...
    cirPerSec: float = ...
    circleFlags: int = ...
    poaObject: Optional[plKey[plSceneObject]] = ...
    radius: float = ...

class plCameraBrain1_FirstPerson(plCameraBrain1_Avatar):
    ...

class plCameraBrain1_Fixed(plCameraBrain1):
    targetPoint: Optional[plKey[plCameraModifier]] = ...

class plCameraConfig:
    accel: float = ...
    decel: float = ...
    fovH: float = ...
    fovW: float = ...
    fpAccel: float = ...
    fpDecel: float = ...
    fpVel: float = ...
    offset: hsVector3 = ...
    vel: float = ...
    worldspace: bool = ...

class plCameraModifier(plSingleModifier):
    class CamTrans:
        accel: float = ...
        cutPOA: bool = ...
        cutPos: bool = ...
        decel: float = ...
        ignore: bool = ...
        poaAccel: float = ...
        poaDecl: float = ...
        poaVelocity: float = ...
        transTo: Optional[plKey[plCameraModifier]] = ...
        velocity: float = ...

    animated: bool = ...
    at: hsVector3 = ...
    brain: Optional[plKey[plCameraBrain]] = ...
    fovH: float = ...
    fovInstructions: Sequence[plCameraMsg] = ...
    fovW: float = ...
    # Yikes! This matches a builtin Python keyword. Better leave it out for now.
    #from: hsVector3 = ...
    messageQueue: Sequence[Tuple[plMessage, plKey]] = ...
    resetAnimOnPop: bool = ...
    startAnimOnPush: bool = ...
    stopAnimOnPop: bool = ...
    trans: Sequence[CamTrans] = ...

    def addFOVInstruction(self, msg: plCameraMsg) -> None: ...
    def addMessage(self, msg: plCameraMsg, sender: Optional[plKey] = None) -> None: ...
    def addTrans(self, trans: CamTrans) -> None: ...
    def clearFOVInstructions(self) -> None: ...
    def clearMessageQueue(self) -> None: ...
    def clearTrans(self) -> None: ...
    def delFOVInstruction(self, idx: int) -> None: ...
    def delMessage(self, idx: int) -> None: ...
    def delTrans(self, idx: int) -> None: ...

class plCameraMsg(plMessage):
    kAddFOVKeyFrame: Any = ...
    kCameraMod: Any = ...
    kChangeParams: Any = ...
    kCreateNewDefaultCam: Any = ...
    kCut: Any = ...
    kEntering: Any = ...
    kFollowLocalPlayer: Any = ...
    kNonPhysOff: Any = ...
    kNonPhysOn: Any = ...
    kNumCmds: Any = ...
    kPopt: Any = ...
    kPush: Any = ...
    kPythonOverridePop: Any = ...
    kPythonOverridePush: Any = ...
    kPythonOverridePushCut: Any = ...
    kPythonSetFirstPersonOverrideEnable: Any = ...
    kPythonUndoFirstPerson: Any = ...
    kRegionPopCamera: Any = ...
    kRegionPopPOA: Any = ...
    kRegionPushCamera: Any = ...
    kRegionPushPOA: Any = ...
    kResetOnEnter: Any = ...
    kResetOnExit: Any = ...
    kResetPanning: Any = ...
    kResponderSetThirdPerson: Any = ...
    kResponderTrigger: Any = ...
    kResponderUndoThirdPerson: Any = ...
    kSetAnimated: Any = ...
    kSetAsPrimary: Any = ...
    kSetFOV: Any = ...
    kSetSubject: Any = ...
    kStartZoomIn: Any = ...
    kStartZoomOut: Any = ...
    kStopZoom: Any = ...
    kTransitionTo: Any = ...
    kUpdateCameras: Any = ...
    kWorldspace: Any = ...

    activated: bool = ...
    config: plCameraConfig = ...
    newCam: Optional[plKey] = ...
    transTime: float = ...
    triggerer: Optional[plKey] = ...

    def getCmd(self, idx: int) -> bool: ...
    def setCmd(self, idx: int, value: bool = True) -> None: ...

class plCameraRegionDetector(plObjectInVolumeDetector):
    messages: Sequence[plCameraMsg] = ...

    def addMessage(self, msg: plCameraMsg) -> None: ...
    def clearMessages(self) -> None: ...
    def delMessage(self, idx: int) -> None: ...

class plClothingItem(hsKeyedObject):
    kClothingBaseFemale: int = ...
    kClothingBaseMale: int = ...
    kClothingBaseNoOptions: int = ...
    kLODHigh: int = ...
    kLODLow: int = ...
    kLODMedium: int = ...
    kLayerBase: int = ...
    kLayerMax: int = ...
    kLayerSkin: int = ...
    kLayerSkinBlend1: int = ...
    kLayerSkinBlend2: int = ...
    kLayerSkinBlend3: int = ...
    kLayerSkinBlend4: int = ...
    kLayerSkinBlend5: int = ...
    kLayerSkinBlend6: int = ...
    kLayerTint1: int = ...
    kLayerTint2: int = ...
    kNumLODLevels: int = ...
    kSetBackpack: int = ...
    kSetEye: int = ...
    kSetFace: int = ...
    kSetGlasses: int = ...
    kSetHand: int = ...
    kSetKI: int = ...
    kSetPants: int = ...
    kSetPlayerBook: int = ...
    kSetShirt: int = ...
    kSetShoe: int = ...
    kTypeAccessory: int = ...
    kTypeFace: int = ...
    kTypeHair: int = ...
    kTypeLeftFoot: int = ...
    kTypeLeftHand: int = ...
    kTypePants: int = ...
    kTypeRightFoot: int = ...
    kTypeRightHand: int = ...
    kTypeShirt: int = ...

    accessory: Optional[plKey[plClothingItem]] = ...
    customText: str = ...
    defaultTint1: hsColorRGBA = ...
    defaultTint2: hsColorRGBA = ...
    description: str = ...
    group: int = ...
    icon: Optional[plKey[plMipmap]] = ...
    itemName: str = ...
    numElements: int = ...
    sortOrder: int = ...
    tileset: int = ...
    type: int = ...

    def addElement(self, name: str) -> None: ...
    def clearElements(self) -> None: ...
    def delElement(self, idx: int) -> None: ...
    def getElementName(self, idx: int) -> str: ...
    def getElementTexture(self, element_idx: int, layer_idx: int) -> plKey[plMipmap]: ...
    def getMesh(self, lod: int) -> plKey[plSharedMesh]: ...
    def setElementName(self, idx: int, name: str) -> None: ...
    def setElementTexture(self, element_idx: int, layer_idx: int, texture: plKey[plMipmap]) -> None: ...
    def setMesh(self, lod: int, mesh: plKey[plSharedMesh]) -> None: ...

class plCluster:
    encoding: plSpanEncoding = ...
    group: Optional[plClusterGroup] = ...
    instances: Sequence[plSpanInstance] = ...

    def addInstance(self, instance: plSpanInstance) -> None: ...
    def clearInstances(self) -> None: ...
    def delInstance(self, idx: int) -> None: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plClusterGroup(hsKeyedObject):
    LOD: plLODDist = ...
    clusters: Sequence[plCluster] = ...
    drawable: Optional[plKey] = ...
    lights: Sequence[plKey[plLightInfo]] = ...
    material: Optional[plKey[hsGMaterial]] = ...
    regions: Sequence[plKey[plVisRegion]] = ...
    renderLevel: int = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    template: plSpanTemplate = ...

    def addCluster(self, cluster: plCluster) -> None: ...
    def addLight(self, light: plKey[plLightInfo]) -> None: ...
    def addRegion(self, region: plKey[plVisRegion]) -> None: ...
    def clearClusters(self) -> None: ...
    def clearLights(self) -> None: ...
    def clearRegions(self) -> None: ...
    def delCluster(self, idx: int) -> None: ...
    def delLight(self, idx: int) -> None: ...
    def delRegion(self, idx: int) -> None: ...

class plCollisionDetector(plDetectorModifier):
    kTypeint: int = ...
    kTypeBump: int = ...
    kTypeEnter: int = ...
    kTypeExit: int = ...
    kTypeUnEnter: int = ...
    kTypeUnExit: int = ...

    type: int = ...

class plCompoundController(plController):
    X: Optional[plController] = ...
    Y: Optional[plController] = ...
    Z: Optional[plController] = ...

    def convertToTMController(self) -> plTMController: ...

class plCompoundPosController(plPosController):
    X: Optional[plScalarController] = ...
    Y: Optional[plScalarController] = ...
    Z: Optional[plScalarController] = ...

class plCompoundRotController(plRotController):
    X: Optional[plScalarController] = ...
    Y: Optional[plScalarController]= ...
    Z: Optional[plScalarController] = ...

class plConditionalObject(hsKeyedObject):
    satisfied: bool = ...
    toggle: bool = ...

class plConstAccelEaseCurve(plATCEaseCurve):
    ...

class plControlEventConditionalObject(plConditionalObject):
    controlEvent: int = ...

class plController(plCreatable):
    ...

class plConvexIsect(plVolumeIsect):
    class SinglePlane:
        dist: float = ...
        norm: hsVector3 = ...
        pos: hsVector3 = ...
        worldDist: float = ...
        worldNorm: hsVector3 = ...

    planes: Sequence[SinglePlane] = ...

    @overload
    def addPlane(self, normal: hsVector3, position: hsVector3) -> None: ...
    @overload
    def addPlane(self, plane: SinglePlane) -> None: ...

    def transform(self, localToWorld: hsMatrix44, worldToLocal: hsMatrix44) -> None: ...

class plConvexVolume(plCreatable):
    localPlanes: Sequence[hsPlane3] = ...

class plCoordinateInterface(plObjInterface):
    kCanEverDelayTransform: int = ...
    kDelayedTransformEval: int = ...

    children: Sequence[plKey[plSceneObject]] = ...
    localToParent: hsMatrix44 = ...
    localToWorld: hsMatrix44 = ...
    parentToLocal: hsMatrix44 = ...
    worldToLocal: hsMatrix44 = ...

    def addChild(self, child: plKey[plSceneObject]) -> None: ...
    def clearChildren(self) -> None: ...
    def delChild(self, idx: int) -> None: ...

class plCreatable:
    def ClassIndex(self) -> int: ...
    def ClassIndexVer(self, ver: int) -> int: ...
    def ClassInstance(self, classId: int) -> bool: ...
    def ClassName(self) -> str: ...
    def isStub(self) -> bool: ...
    def read(self, stream: hsStream, mgr: plResManager) -> None: ...
    def toPrc(self, exclude: int = pfPrcHelper.kNone) -> str: ...
    def write(self, stream: hsStream, mgr: plResManager) -> None: ...

class plCreatableStub(plCreatable):
    def __init__(self, classId: int, length: int) -> None: ...
    def getData(self) -> bytes: ...
    def getLength(self) -> int: ...

class plCubicEnvironmap(plBitmap):
    backFace: plMipmap = ...
    bottomFace: plMipmap = ...
    frontFace: plMipmap = ...
    leftFace: plMipmap = ...
    rightFace: plMipmap = ...
    topFace: plMipmap = ...

class plCubicRenderTarget(plRenderTarget):
    kBackFace: int = ...
    kBottomFace: int = ...
    kFrontFace: int = ...
    kLeftFace: int = ...
    kRightFace: int = ...
    kTopFace: int = ...

    backFace: plRenderTarget = ...
    bottomFace: plRenderTarget = ...
    faces: Sequence[plRenderTarget] = ...
    frontFace: plRenderTarget = ...
    leftFace: plRenderTarget = ...
    rightFace: plRenderTarget = ...
    topFace: plRenderTarget = ...

class plCullPoly:
    kHole: int = ...
    kNone: int = ...
    kTwoSided: int = ...

    center: hsVector3 = ...
    dist: float = ...
    flags: int = ...
    norm: hsVector3 = ...
    radius: float = ...
    verts: Sequence[hsVector3] = ...

class plCursorChangeMsg(plMessage):
    kCursorArrow: int = ...
    kCursorClicked: int = ...
    kCursorDown: int = ...
    kCursorGrab: int = ...
    kCursorHidden: int = ...
    kCursorLeft: int = ...
    kCursorOpen: int = ...
    kCursorPoised: int = ...
    kCursorRight: int = ...
    kCursorUnClicked: int = ...
    kCursorUp: int = ...
    kNoChange: int = ...
    kNullCursor: int = ...

    priority: int = ...
    type: int = ...

class plDDSurface:
    DDPF_ALPHA: int = ...
    DDPF_ALPHAPIXELS: int = ...
    DDPF_ALPHAPREMULT: int = ...
    DDPF_BUMPDUDV: int = ...
    DDPF_BUMPLUMINANCE: int = ...
    DDPF_COMPRESSED: int = ...
    DDPF_FOURCC: int = ...
    DDPF_LUMINANCE: int = ...
    DDPF_PALETTEINDEXED1: int = ...
    DDPF_PALETTEINDEXED2: int = ...
    DDPF_PALETTEINDEXED4: int = ...
    DDPF_PALETTEINDEXED8: int = ...
    DDPF_PALETTEINDEXEDTO8: int = ...
    DDPF_RGB: int = ...
    DDPF_RGBTOYUV: int = ...
    DDPF_STENCILBUFFER: int = ...
    DDPF_YUV: int = ...
    DDPF_ZBUFFER: int = ...
    DDPF_ZPIXELS: int = ...
    DDSCAPS2_ADDITIONALPRIMARY: int = ...
    DDSCAPS2_CUBEMAP: int = ...
    DDSCAPS2_CUBEMAP_ALLFACES: int = ...
    DDSCAPS2_CUBEMAP_NEGATIVEX: int = ...
    DDSCAPS2_CUBEMAP_NEGATIVEY: int = ...
    DDSCAPS2_CUBEMAP_NEGATIVEZ: int = ...
    DDSCAPS2_CUBEMAP_POSITIVEX: int = ...
    DDSCAPS2_CUBEMAP_POSITIVEY: int = ...
    DDSCAPS2_CUBEMAP_POSITIVEZ: int = ...
    DDSCAPS2_D3DTEXTUREMANAGE: int = ...
    DDSCAPS2_DISCARDBACKBUFFER: int = ...
    DDSCAPS2_DONOTPERSIST: int = ...
    DDSCAPS2_ENABLEALPHACHANNEL: int = ...
    DDSCAPS2_EXTENDEDFORMATPRIMARY: int = ...
    DDSCAPS2_HARDWAREDEINTERLACE: int = ...
    DDSCAPS2_HINTALIASING: int = ...
    DDSCAPS2_HINTDYNAMIC: int = ...
    DDSCAPS2_HINTSTATIC: int = ...
    DDSCAPS2_MIPMAPSUBLEVEL: int = ...
    DDSCAPS2_NOTUSERLOCKABLE: int = ...
    DDSCAPS2_NPATCHES: int = ...
    DDSCAPS2_OPAQUE: int = ...
    DDSCAPS2_POINTS: int = ...
    DDSCAPS2_RESERVED1: int = ...
    DDSCAPS2_RESERVED2: int = ...
    DDSCAPS2_RESERVED3: int = ...
    DDSCAPS2_RTPATCHES: int = ...
    DDSCAPS2_STEREOSURFACELEFT: int = ...
    DDSCAPS2_TEXTUREMANAGE: int = ...
    DDSCAPS2_VOLUME: int = ...
    DDSCAPS3_AUTOGENMIPMAP: int = ...
    DDSCAPS3_CREATESHAREDRESOURCE: int = ...
    DDSCAPS3_DMAP: int = ...
    DDSCAPS3_LIGHTWEIGHTMIPMAP: int = ...
    DDSCAPS3_MULTISAMPLE_MASK: int = ...
    DDSCAPS3_MULTISAMPLE_QUALITY_MASK: int = ...
    DDSCAPS3_MULTISAMPLE_QUALITY_SHIFT: int = ...
    DDSCAPS3_OPENSHAREDRESOURCE: int = ...
    DDSCAPS3_READONLYRESOURCE: int = ...
    DDSCAPS3_RESERVED1: int = ...
    DDSCAPS3_RESERVED2: int = ...
    DDSCAPS_3DDEVICE: int = ...
    DDSCAPS_ALLOCONLOAD: int = ...
    DDSCAPS_ALPHA: int = ...
    DDSCAPS_BACKBUFFER: int = ...
    DDSCAPS_COMPLEX: int = ...
    DDSCAPS_FLIP: int = ...
    DDSCAPS_FRONTBUFFER: int = ...
    DDSCAPS_HWCODEC: int = ...
    DDSCAPS_LIVEVIDEO: int = ...
    DDSCAPS_LOCALVIDMEM: int = ...
    DDSCAPS_MIPMAP: int = ...
    DDSCAPS_MODEX: int = ...
    DDSCAPS_NONLOCALVIDMEM: int = ...
    DDSCAPS_OFFSCREENPLAIN: int = ...
    DDSCAPS_OPTIMIZED: int = ...
    DDSCAPS_OVERLAY: int = ...
    DDSCAPS_OWNDC: int = ...
    DDSCAPS_PALETTE: int = ...
    DDSCAPS_PRIMARYSURFACE: int = ...
    DDSCAPS_PRIMARYSURFACELEFT: int = ...
    DDSCAPS_RESERVED1: int = ...
    DDSCAPS_RESERVED2: int = ...
    DDSCAPS_STANDARDVGAMODE: int = ...
    DDSCAPS_SYSTEMMEMORY: int = ...
    DDSCAPS_TEXTURE: int = ...
    DDSCAPS_VIDEOMEMORY: int = ...
    DDSCAPS_VIDEOPORT: int = ...
    DDSCAPS_VISIBLE: int = ...
    DDSCAPS_WRITEONLY: int = ...
    DDSCAPS_ZBUFFER: int = ...
    DDSD_ALL: int = ...
    DDSD_ALPHABITDEPTH: int = ...
    DDSD_BACKBUFFERCOUNT: int = ...
    DDSD_CAPS: int = ...
    DDSD_CKDESTBLT: int = ...
    DDSD_CKDESTOVERLAY: int = ...
    DDSD_CKSRCBLT: int = ...
    DDSD_CKSRCOVERLAY: int = ...
    DDSD_DEPTH: int = ...
    DDSD_FVF: int = ...
    DDSD_HEIGHT: int = ...
    DDSD_LINEARSIZE: int = ...
    DDSD_LPSURFACE: int = ...
    DDSD_MIPMAPCOUNT: int = ...
    DDSD_PITCH: int = ...
    DDSD_PIXELFORMAT: int = ...
    DDSD_REFRESHRATE: int = ...
    DDSD_SRCVBHANDLE: int = ...
    DDSD_TEXTURESTAGE: int = ...
    DDSD_WIDTH: int = ...
    DDSD_ZBUFFERBITDEPTH: int = ...
    FOURCC_DXT1: int = ...
    FOURCC_DXT3: int = ...
    FOURCC_DXT5: int = ...

    alphaDepth: int = ...
    backBufferCount: int = ...
    caps: int = ...
    caps2: int = ...
    caps3: int = ...
    caps4: int = ...
    ckDestBlt: Sequence[Tuple[int, int]] = ...
    ckDestOverlay: Sequence[Tuple[int, int]] = ...
    ckSrcBlt: Sequence[Tuple[int, int]] = ...
    ckSrcOverlay: Sequence[Tuple[int, int]] = ...
    data: bytes = ...
    depth: int = ...
    flags: int = ...
    fvf: int = ...
    height: int = ...
    linearSize: int = ...
    mipmapCount: int = ...
    pf_BBitMask: int = ...
    pf_GBitMask: int = ...
    pf_RBitMask: int = ...
    pf_UBitMask: int = ...
    pf_VBitMask: int = ...
    pf_YBitMask: int = ...
    pf_ZBitMask: int = ...
    pf_alphaBitMask: int = ...
    pf_bitCount: int = ...
    pf_bitDepth: int = ...
    pf_bumpDuBitMask: int = ...
    pf_bumpDvBitMask: int = ...
    pf_bumpLuminanceBitMask: int = ...
    pf_colorZBitMask: int = ...
    pf_flags: int = ...
    pf_fourCC: int = ...
    pf_luminanceBitMask: int = ...
    pf_multiSampleCaps: Tuple[int, int] = ...
    pf_operations: int = ...
    pf_stencilBitDepth: int = ...
    pf_stencilBitMask: int = ...
    pitch: int = ...
    refreshRate: int = ...
    srcVBHandle: int = ...
    textureStage: int = ...
    width: int = ...
    zbufferBitDepth: int = ...

    def calcBufferSize(self, width: int, height: int) -> int: ...
    def calcNumLevels(self) -> int: ...
    def calcTotalBufferSize(self) -> int: ...
    def createMipmap(self, name: str = "") -> plMipmap: ...
    def read(self, stream: hsStream) -> None: ...
    def setFromMipmap(self, mipmap: plMipmap) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plDISpanIndex:
    kDontTransformSpans: int = ...
    kMatrixOnly: int = ...
    kNone: int = ...

    flags: int = ...
    indices: Sequence[int] = ...

class plDebug:
    kDLAll: int = ...
    kDLDebug: int = ...
    kDLError: int = ...
    kDLNone: int = ...
    kDLWarning: int = ...

    @staticmethod
    def Debug(msg: str) -> None: ...
    @staticmethod
    def Error(msg: str) -> None: ...
    @staticmethod
    def Init(level: int = kDLWarning, stream: Optional[hsStream] = None) -> None: ...
    @staticmethod
    def InitFile(level: int = kDLWarning, filename: str = "Plasma.log") -> None: ...
    @staticmethod
    def Warning(msg: str) -> None: ...

class plDetectorModifier(plSingleModifier):
    proxy: Optional[plKey] = ...
    receivers: Sequence[plKey] = ...
    remoteMod: Optional[plKey[plModifier]] = ...

    def addReceiver(self, receiver: plKey) -> None: ...
    def clearReceivers(self) -> None: ...
    def delReceiver(self, idx: int) -> None: ...

class plDirectShadowMaster(plShadowMaster):
    ...

class plDirectionalLightInfo(plLightInfo):
    ...

class plDistOpacityMod(plSingleModifier):
    farOpaq: float = ...
    farTrans: float = ...
    nearOpaq: float = ...
    nearTrans: float = ...

class plDrawInterface(plObjInterface):
    drawables: Sequence[Tuple[plKey[plDrawable], int]] = ...
    regions: Sequence[plKey[plVisRegion]] = ...

    def addDrawable(self, drawable: plKey[plDrawable]) -> None: ...
    def addRegion(self, region: plKey[plVisRegion]) -> None: ...
    def clearDrawables(self) -> None: ...
    def clearRegions(self) -> None: ...
    def delDrawable(self, idx: int) -> None: ...
    def delRegion(self, idx: int) -> None: ...

class plDrawable(hsKeyedObject):
    kAllProxies: int = ...
    kAllTypes: int = ...
    kAudibleProxy: int = ...
    kCameraProxy: int = ...
    kCoordinateProxy: int = ...
    kCritCharacter: int = ...
    kCritSortFaces: int = ...
    kCritSortSpans: int = ...
    kCritStatic: int = ...
    kEnviron: int = ...
    kGenericProxy: int = ...
    kLightProxy: int = ...
    kNonDrawable: int = ...
    kNormal: int = ...
    kOccSnapProxy: int = ...
    kOccluderProxy: int = ...
    kPhysicalProxy: int = ...
    kPropCharacter: int = ...
    kPropHasVisLOS: int = ...
    kPropNoDraw: int = ...
    kPropNoReSort: int = ...
    kPropPartialSort: int = ...
    kPropSortAsOne: int = ...
    kPropSortFaces: int = ...
    kPropSortSpans: int = ...
    kPropUNUSED: int = ...
    kPropVolatile: int = ...
    kSpanIDMask: int = ...
    kSpanTypeIcicle: int = ...
    kSpanTypeMask: int = ...
    kSpanTypeParticleSpan: int = ...
    kSubAllTypes: int = ...
    kSubEnviron: int = ...
    kSubNonDrawable: int = ...
    kSubNormal: int = ...

class plDrawableSpans(plDrawable):
    DIIndices: Sequence[plDISpanIndex] = ...
    boneToLocals: Sequence[hsMatrix44] = ...
    bufferGroups: Sequence[plGBufferGroup] = ...
    criteria: int = ...
    localBounds: hsBounds3Ext = ...
    localToBones: Sequence[hsMatrix44] = ...
    localToWorlds: Sequence[hsMatrix44] = ...
    materials: Sequence[plKey[hsGMaterial]] = ...
    maxWorldBounds: hsBounds3Ext = ...
    numTransforms: int = ...
    props: int = ...
    renderLevel: int = ...
    sceneNode: Optional[plSceneNode] = ...
    sourceSpans: Sequence[plGeometrySpan] = ...
    spaceTree: Optional[plSpaceTree] = ...
    spans: Sequence[plSpan] = ...
    worldBounds: hsBounds3Ext = ...
    worldToLocals: Sequence[hsMatrix44] = ...

    def BuildSpaceTree(self) -> None: ...
    def addCells(self, buffer: int, cells: Sequence[plGBufferCell]) -> None: ...
    def addDIIndex(self, index: plDISpanIndex) -> int: ...
    def addIcicle(self, icicle: plIcicle) -> int: ...
    def addIndices(self, buffer: int, indicies: Sequence[int]) -> None: ...
    def addMaterial(self, material: plKey[hsGMaterial]) -> None: ...
    def addSourceSpan(self, span: plGeometrySpan) -> int: ...
    def addTransform(self, localToWorld: hsMatrix44, worldToLocal: hsMatrix44, localToBone: hsMatrix44, boneToLocal: hsMatrix44) -> int: ...
    def addVerts(self, buffer: int, verts: Sequence[plGBufferVertex]) -> None: ...
    def buildDIIndex(self, spans: Sequence[plGeometrySpan]) -> int: ...
    def calcBounds(self) -> None: ...
    def clearDIIndices(self) -> None: ...
    def clearMaterials(self) -> None: ...
    def clearSourceSpans(self) -> None: ...
    def clearSpans(self) -> None: ...
    def clearTransforms(self) -> None: ...
    def composeGeometry(self, clearSpans: bool = True, calcBounds: bool = True) -> None: ...
    def createBufferGroup(self, format: int) -> int: ...
    def decomposeGeometry(self, clearColors: bool = True) -> None: ...
    def deleteBufferGroup(self, idx: int) -> None: ...
    def getCells(self, buf: int, idx: int) -> Sequence[plGBufferCell]: ...
    def getIndices(self, icicle: plIcicle) -> Sequence[int]: ...
    def getTransform(self, idx: int) -> Tuple[hsMatrix44, hsMatrix44, hsMatrix44, hsMatrix44]: ...
    def getVerts(self, icicle: plIcicle) -> Sequence[plGBufferVertex]: ...

class plDynaBulletMgr(plDynaDecalMgr):
    ...

class plDynaDecalMgr(plSynchedObject):
    decayStart: float = ...
    gridSizeU: float = ...
    gridSizeV: float = ...
    intensity: float = ...
    lifeSpan: float = ...
    matPreShade: Optional[plKey[hsGMaterial]] = ...
    matRTShade: Optional[plKey[hsGMaterial]] = ...
    maxNumIdx: int = ...
    maxNumVerts: int = ...
    notifies: Sequence[plKey] = ...
    partyObjects: Sequence[plKey[plSceneObject]] = ...
    partyTime: float = ...
    rampEnd: float = ...
    scale: hsVector3 = ...
    targets: Sequence[plKey[plSceneObject]] = ...
    waitOnEnable: int = ...
    wetLength: float = ...

    def addNotify(self, notify: plKey) -> None: ...
    def addPartyObject(self, party: plKey[plSceneObject]) -> None: ...
    def addTarget(self, target: plKey[plSceneObject]) -> None: ...
    def clearNotifies(self) -> None: ...
    def clearPartyObjects(self) -> None: ...
    def clearTargets(self) -> None: ...
    def delNotify(self, idx: int) -> None: ...
    def delPartyObject(self, idx: int) -> None: ...
    def delTarget(self, idx: int) -> None: ...

class plDynaFootMgr(plDynaDecalMgr):
    ...

class plDynaPuddleMgr(plDynaRippleMgr):
    ...

class plDynaRippleMgr(plDynaDecalMgr):
    finalUVW: hsVector3 = ...
    initUVW: hsVector3 = ...

class plDynaRippleVSMgr(plDynaRippleMgr):
    waveSet: Optional[plKey[plWaveSetBase]] = ...

class plDynaTorpedoMgr(plDynaRippleMgr):
    ...

class plDynaTorpedoVSMgr(plDynaTorpedoMgr):
    waveSet: Optional[plKey[plWaveSetBase]] = ...

class plDynaWakeMgr(plDynaRippleMgr):
    animPath: Optional[plAnimPath] = ...
    animWgt: float = ...
    defaultDir: hsVector3 = ...
    velWgt: float = ...

class plDynamicCamMap(plRenderTarget):
    camera: Optional[plKey[plCameraModifier]] = ...
    color: hsColorRGBA = ...
    disableTexture: Optional[plKey[plBitmap]]  = ...
    fogStart: float = ...
    hither: float = ...
    incCharacters: bool = ...
    matLayers: Sequence[plKey[plLayer]] = ...
    refreshRate: float = ...
    rootNode: Optional[plKey[plSceneObject]]  = ...
    targetNodes: Sequence[plKey[plSceneObject]] = ...
    visRegionNames: Sequence[str] = ...
    visRegions: Sequence[plKey[plVisRegion]] = ...
    yon: float = ...

    def addMatLayer(self, layer: plKey[plLayer]) -> None: ...
    def addTargetNode(self, target: plKey[plSceneObject]) -> None: ...
    def addVisRegion(self, region: plKey[plVisRegion]) -> None: ...
    def addVisRegionName(self, region: str) -> None: ...
    def clearMatLayers(self) -> None: ...
    def clearTargetNodes(self) -> None: ...
    def clearVisRegionNames(self) -> None: ...
    def clearVisRegions(self) -> None: ...
    def delMatLayer(self, idx: int) -> None: ...
    def delTargetNode(self, idx: int) -> None: ...
    def delVisRegion(self, idx: int) -> None: ...
    def delVisRegionName(self, idx: int) -> None: ...

class plDynamicEnvMap(plCubicRenderTarget):
    color: hsColorRGBA = ...
    fogStart: float = ...
    hither: float = ...
    incCharacters: bool = ...
    position: hsVector3 = ...
    refreshRate: float = ...
    rootNode: Optional[plKey[plSceneObject]]  = ...
    visRegionNames: Sequence[str] = ...
    visRegions: Sequence[plKey[plVisRegion]] = ...
    yon: float = ...

class plDynamicTextMap(plMipmap):
    hasAlpha: bool = ...
    initBuffer: Sequence[int] = ...
    visHeight: int = ...
    visWidth: int = ...

class plEaseController(plLeafController):
    ...

class plEAXListenerMod(plSingleModifier):
    listenerProps: EAXReverbProperties = ...
    softRegion: Optional[plKey[plSoftVolume]] = ...

class plEAXSourceSettings:
    airAbsorptionFactor: float = ...
    dopplerFactor: float = ...
    enable: bool = ...
    occlusionSoftValue: float = ...
    outsideVolHF: int = ...
    rolloffFactor: float = ...
    room: int = ...
    roomAuto: bool = ...
    roomHFAuto: bool = ...
    roomRolloffFactor: float = ...
    softEnds: plEAXSourceSoftSettings = ...
    softStarts: plEAXSourceSoftSettings = ...

class plEAXSourceSoftSettings:
    directRatio: float = ...
    lfRatio: float = ...
    occlusion: float = ...
    roomRatio: float = ...

    def reset(self) -> None: ...

class plEmoteAnim(plATCAnim):
    bodyUsage: int = ...
    fadeIn: float = ...
    fadeOut: float = ...

class plEnableMsg(plMessage):
    kAll: int = ...
    kAudible: int = ...
    kByType: int = ...
    kDisable: int = ...
    kDrawable: int = ...
    kEnable: int = ...
    kPhysical: int = ...

    def getCmd(self, cmd: int) -> bool: ...
    def getType(self, type: int) -> bool: ...
    def setCmd(self, cmd: int, value: bool) -> None: ...
    def setType(self, type: int, value: bool) -> None: ...

class plEncryptedStream(hsFileStream):
    kEncAES: int = ...
    kEncAuto: int = ...
    kEncDroid: int = ...
    kEncNone: int = ...
    kEncXtea: int = ...

    @staticmethod
    def IsFileEncrypted(filename: Union[PathLike, str]) -> bool: ...
    def getEncType(self) -> int: ...
    def open(self, source: Union[PathLike, str, hsStream], mode: int, encryption: int) -> plEncryptedStream: ... # type: ignore # This signature is indeed incompatible with the base class.
    def close(self) -> None: ...
    def setKey(self, key: Tuple[int, int, int, int]) -> None: ...
    def __enter__(self) -> plEncryptedStream: ...
    def __exit__(self, type, value, traceback) -> None: ...

class plEventCallbackMsg(plMessage):
    event: int = ...
    eventTime: float = ...
    index: int = ...
    repeats: int = ...
    user: int = ...

class plExcludeRegionModifier(plSingleModifier):
    kBlockCameras: int = ...

    safePoints: Sequence[plKey[plSceneObject]] = ...
    seek: bool = ...
    seekTime: float = ...

    def addSafePoint(self, key: plKey[plSceneObject]) -> None: ...
    def clearSafePoints(self) -> None: ...
    def delSafePoint(self, idx: int) -> None: ...

class plExcludeRegionMsg(plMessage):
    kClear: Any = ...
    kRelease: Any = ...

    cmd: int = ...
    synchFlags: int = ...

class plFacingConditionalObject(plConditionalObject):
    directional: bool = ...
    tolerance: float = ...

class plFactory:
    k2WayWinAudible: int = ...
    kAGAnim: int = ...
    kAGAnimBink: int = ...
    kAGApplicator: int = ...
    kAGChannel: int = ...
    kAGCmdMsg: int = ...
    kAGDetachCallbackMsg: int = ...
    kAGInstanceCallbackMsg: int = ...
    kAGMasterMod: int = ...
    kAGMasterSDLModifier: int = ...
    kAGModifier: int = ...
    kAIArrivedAtGoalMsg: int = ...
    kAIBrainCreatedMsg: int = ...
    kAIMsg: int = ...
    kANDConditionalObject: int = ...
    kATCAnim: int = ...
    kATCChannel: int = ...
    kATCEaseCurve: int = ...
    kAVIWriter: int = ...
    kAccountUpdateMsg: int = ...
    kActivatorActivatorConditionalObject: int = ...
    kActivatorConditionalObject: int = ...
    kActivatorMsg: int = ...
    kActivePrintShape: int = ...
    kAgeBeginLoadingMsg: int = ...
    kAgeGlobalAnim: int = ...
    kAgeInfoStruct: int = ...
    kAgeLinkStruct: int = ...
    kAgeLoaded2Msg: int = ...
    kAgeLoadedMsg: int = ...
    kAgeLoader: int = ...
    kAgeLoaderMsg: int = ...
    kAliasModifier: int = ...
    kAngularImpulseMsg: int = ...
    kAngularVelocityMsg: int = ...
    kAnimCmdMsg: int = ...
    kAnimEvalMsg: int = ...
    kAnimEventModifier: int = ...
    kAnimPath: int = ...
    kAnimStage: int = ...
    kAnimTimeConvert: int = ...
    kAnimTimeConvertSDLModifier: int = ...
    kAnimationEventConditionalObject: int = ...
    kArmatureBrain: int = ...
    kArmatureEffect: int = ...
    kArmatureEffectFootSound: int = ...
    kArmatureEffectMsg: int = ...
    kArmatureEffectStateMsg: int = ...
    kArmatureEffectsMgr: int = ...
    kArmatureLODMod: int = ...
    kArmatureMod: int = ...
    kArmatureModBase: int = ...
    kArmatureUpdateMsg: int = ...
    kAttachMsg: int = ...
    kAudible: int = ...
    kAudibleNull: int = ...
    kAudioInterface: int = ...
    kAudioSysMsg: int = ...
    kAudioSystem: int = ...
    kAutoProfile: int = ...
    kAutoWalkRegion: int = ...
    kAvAnimTask: int = ...
    kAvBlendedSeekTask: int = ...
    kAvBrain: int = ...
    kAvBrainAvatar: int = ...
    kAvBrainBlimp: int = ...
    kAvBrainClimb: int = ...
    kAvBrainCoop: int = ...
    kAvBrainCritter: int = ...
    kAvBrainDrive: int = ...
    kAvBrainFlight: int = ...
    kAvBrainFlightNPC: int = ...
    kAvBrainGeneric: int = ...
    kAvBrainGenericMsg: int = ...
    kAvBrainHuman: int = ...
    kAvBrainLadder: int = ...
    kAvBrainNPC: int = ...
    kAvBrainPath: int = ...
    kAvBrainPirahna: int = ...
    kAvBrainPuppet: int = ...
    kAvBrainQuab: int = ...
    kAvBrainRideAnimatedPhysical: int = ...
    kAvBrainSample: int = ...
    kAvBrainSwim: int = ...
    kAvBrainUser: int = ...
    kAvCoopMsg: int = ...
    kAvEnableMsg: int = ...
    kAvEnableTask: int = ...
    kAvLadderMod: int = ...
    kAvOneShotLinkTask: int = ...
    kAvOneShotMsg: int = ...
    kAvOneShotTask: int = ...
    kAvPopBrainMsg: int = ...
    kAvPushBrainMsg: int = ...
    kAvSeekMsg: int = ...
    kAvSeekTask: int = ...
    kAvTask: int = ...
    kAvTaskBrain: int = ...
    kAvTaskDumbSeek: int = ...
    kAvTaskMsg: int = ...
    kAvTaskOneShot: int = ...
    kAvTaskOrient: int = ...
    kAvTaskSeek: int = ...
    kAvTaskSeekDoneMsg: int = ...
    kAvTaskSmartSeek: int = ...
    kAvatarAnim: int = ...
    kAvatarAnimMgr: int = ...
    kAvatarBehaviorNotifyMsg: int = ...
    kAvatarFootMsg: int = ...
    kAvatarInputStateMsg: int = ...
    kAvatarMgr: int = ...
    kAvatarMod: int = ...
    kAvatarMsg: int = ...
    kAvatarOpacityCallbackMsg: int = ...
    kAvatarPhysicalSDLModifier: int = ...
    kAvatarPhysicsEnableCallbackMsg: int = ...
    kAvatarSDLModifier: int = ...
    kAvatarSetTypeMsg: int = ...
    kAvatarSpawnNotifyMsg: int = ...
    kAvatarStealthModeMsg: int = ...
    kAxisAnimModifier: int = ...
    kAxisEventMsg: int = ...
    kBackdoorMsg: int = ...
    kBitmap: int = ...
    kBlower: int = ...
    kBookData: int = ...
    kBoundInterface: int = ...
    kBoundsIsect: int = ...
    kBubbleShaderMod: int = ...
    kBulletMsg: int = ...
    kCCRBanLinkingMsg: int = ...
    kCCRCommunicationMsg: int = ...
    kCCRGameOperator: int = ...
    kCCRInvisibleMsg: int = ...
    kCCRMessage: int = ...
    kCCRMgr: int = ...
    kCCRPetitionMsg: int = ...
    kCCRSeniorSpecialist: int = ...
    kCCRShiftSupervisor: int = ...
    kCCRSilencePlayerMsg: int = ...
    kCCRSpecialist: int = ...
    kCameraBrain: int = ...
    kCameraBrain1: int = ...
    kCameraBrain1_Avatar: int = ...
    kCameraBrain1_Circle: int = ...
    kCameraBrain1_Drive: int = ...
    kCameraBrain1_FirstPerson: int = ...
    kCameraBrain1_Fixed: int = ...
    kCameraBrain1_POA: int = ...
    kCameraBrain1_POAFixed: int = ...
    kCameraBrainUru: int = ...
    kCameraBrainUru_Circle: int = ...
    kCameraBrainUru_Drive: int = ...
    kCameraBrainUru_FirstPerson: int = ...
    kCameraBrainUru_Fixed: int = ...
    kCameraBrainUru_Follow: int = ...
    kCameraBrain_Avatar: int = ...
    kCameraBrain_Default: int = ...
    kCameraBrain_Drive: int = ...
    kCameraBrain_Expert: int = ...
    kCameraBrain_FP: int = ...
    kCameraBrain_Fixed: int = ...
    kCameraBrain_FixedPan: int = ...
    kCameraBrain_Flight: int = ...
    kCameraBrain_Freelook: int = ...
    kCameraBrain_Ground: int = ...
    kCameraBrain_M5: int = ...
    kCameraBrain_Novice: int = ...
    kCameraBrain_NovicePlus: int = ...
    kCameraModifier: int = ...
    kCameraMsg: int = ...
    kCameraRegionDetector: int = ...
    kCameraTargetFadeMsg: int = ...
    kCaptureRenderMsg: int = ...
    kClient: int = ...
    kClientApp: int = ...
    kClientGuid: int = ...
    kClientMsg: int = ...
    kClientRefMsg: int = ...
    kClientSessionMgr: int = ...
    kClimbEventMsg: int = ...
    kClimbMsg: int = ...
    kClimbingWallMsg: int = ...
    kCloneSpawnModifier: int = ...
    kClothingBase: int = ...
    kClothingItem: int = ...
    kClothingMgr: int = ...
    kClothingMsg: int = ...
    kClothingOutfit: int = ...
    kClothingSDLModifier: int = ...
    kClothingUpdateBCMsg: int = ...
    kClusterGroup: int = ...
    kCmdIfaceModMsg: int = ...
    kCollideMsg: int = ...
    kCollisionDetector: int = ...
    kCollisionReactor: int = ...
    kCommonNeighborhoodsInitTask: int = ...
    kComplexIsect: int = ...
    kCompoundController: int = ...
    kCompoundPhysicalMesh: int = ...
    kCompoundPosController: int = ...
    kCompoundRotController: int = ...
    kCompoundTMModifier: int = ...
    kCondRefMsg: int = ...
    kConditionalObject: int = ...
    kConeIsect: int = ...
    kConnectedToVaultMsg: int = ...
    kConsole: int = ...
    kConsoleMsg: int = ...
    kConstAccelEaseCurve: int = ...
    kControlEventConditionalObject: int = ...
    kControlEventMsg: int = ...
    kController: int = ...
    kConvexIsect: int = ...
    kConvexVolume: int = ...
    kCoopCoordinator: int = ...
    kCoordinateInterface: int = ...
    kCorrectionMsg: int = ...
    kCreatableGenericValue: int = ...
    kCreatableListHelper: int = ...
    kCreatableStream: int = ...
    kCreatableUuid: int = ...
    kCrossfade: int = ...
    kCrossfadeMsg: int = ...
    kCubicEnvironmap: int = ...
    kCubicRenderTarget: int = ...
    kCubicRenderTargetModifier: int = ...
    kCursorChangeMsg: int = ...
    kCutter: int = ...
    kCylinderIsect: int = ...
    kDBGenericSQLDB: int = ...
    kDISpansMsg: int = ...
    kDX8Pipeline: int = ...
    kDX9Pipeline: int = ...
    kDXPipeline: int = ...
    kDampMsg: int = ...
    kDbEventLog: int = ...
    kDbInterface: int = ...
    kDbProxyInterface: int = ...
    kDebugKeyEventMsg: int = ...
    kDecalEnableMod: int = ...
    kDelayedTransformMsg: int = ...
    kDetectorModifier: int = ...
    kDeviceRecreateMsg: int = ...
    kDirectMusicSound: int = ...
    kDirectShadowMaster: int = ...
    kDirectionalLightInfo: int = ...
    kDispatch: int = ...
    kDispatchBase: int = ...
    kDistOpacityMod: int = ...
    kDniCoordinateInfo: int = ...
    kDrawInterface: int = ...
    kDrawable: int = ...
    kDrawableIce: int = ...
    kDrawableMesh: int = ...
    kDrawablePatchSet: int = ...
    kDrawableSpans: int = ...
    kDynaBulletMgr: int = ...
    kDynaDecalEnableMsg: int = ...
    kDynaDecalMgr: int = ...
    kDynaFootMgr: int = ...
    kDynaPuddleMgr: int = ...
    kDynaRippleMgr: int = ...
    kDynaRippleVSMgr: int = ...
    kDynaTorpedoMgr: int = ...
    kDynaTorpedoVSMgr: int = ...
    kDynaWakeMgr: int = ...
    kDynamicCamMap: int = ...
    kDynamicColorRGBA: int = ...
    kDynamicEnvMap: int = ...
    kDynamicEnvMapMsg: int = ...
    kDynamicMatrix33: int = ...
    kDynamicMatrix44: int = ...
    kDynamicScalar: int = ...
    kDynamicTextMap: int = ...
    kDynamicTextMsg: int = ...
    kDynamicValue: int = ...
    kEAXEffect: int = ...
    kEAXListenerMod: int = ...
    kEAXPitchShifter: int = ...
    kEAXReverbEffect: int = ...
    kEaseController: int = ...
    kEffect: int = ...
    kElementRefMsg: int = ...
    kElevatorModifier: int = ...
    kEmoteAnim: int = ...
    kEnableMsg: int = ...
    kEvalMsg: int = ...
    kEventCallbackInterceptMsg: int = ...
    kEventCallbackMsg: int = ...
    kEventCallbackSetupMsg: int = ...
    kEventGroupEnableMsg: int = ...
    kEventGroupMsg: int = ...
    kEventLog: int = ...
    kEventManager: int = ...
    kExcludeRegionModifier: int = ...
    kExcludeRegionMsg: int = ...
    kExcludeRegionSDLModifier: int = ...
    kFXMaterial: int = ...
    kFacingConditionalObject: int = ...
    kFadeOpacityLay: int = ...
    kFadeOpacityMod: int = ...
    kFakeOutMsg: int = ...
    kFilterCoordInterface: int = ...
    kFogControl: int = ...
    kFogEnvironment: int = ...
    kFollowMod: int = ...
    kFont: int = ...
    kFontCache: int = ...
    kForceMsg: int = ...
    kFreezeMsg: int = ...
    kGMaterial: int = ...
    kGRenderProcs: int = ...
    kGUIButtonMod: int = ...
    kGUICheckBoxCtrl: int = ...
    kGUIClickMapCtrl: int = ...
    kGUIControlMod: int = ...
    kGUICreditsCtrl: int = ...
    kGUIDialogMod: int = ...
    kGUIDragBarCtrl: int = ...
    kGUIDraggableMod: int = ...
    kGUIDynDisplayCtrl: int = ...
    kGUIEditBoxMod: int = ...
    kGUIKnobCtrl: int = ...
    kGUIListBoxMod: int = ...
    kGUIMenuItem: int = ...
    kGUIMultiLineEditCtrl: int = ...
    kGUINotifyMsg: int = ...
    kGUIPopUpMenu: int = ...
    kGUIProgressCtrl: int = ...
    kGUIRadioGroupCtrl: int = ...
    kGUISketchCtrl: int = ...
    kGUISkin: int = ...
    kGUITextBoxMod: int = ...
    kGUIUpDownPairMod: int = ...
    kGUIValueCtrl: int = ...
    kGameCli: int = ...
    kGameCliMsg: int = ...
    kGameGUIMgr: int = ...
    kGameGUIMsg: int = ...
    kGameMarkerModifier: int = ...
    kGameMgrMsg: int = ...
    kGenRefMsg: int = ...
    kGenericPhysical: int = ...
    kGmBlueSpiral: int = ...
    kGmClimbingWall: int = ...
    kGmHeek: int = ...
    kGmMarker: int = ...
    kGmTicTacToe: int = ...
    kGmVarSync: int = ...
    kGrassShaderMod: int = ...
    kGuidepathModifier: int = ...
    kHKSimulationSynchMsg: int = ...
    kHKSubWorld: int = ...
    kHardRegion: int = ...
    kHardRegionComplex: int = ...
    kHardRegionIntersect: int = ...
    kHardRegionInvert: int = ...
    kHardRegionPlanes: int = ...
    kHardRegionUnion: int = ...
    kHavokConstraintsMod: int = ...
    kHingeConstraintMod: int = ...
    kIKModifier: int = ...
    kIMouseBEventMsg: int = ...
    kIMouseXEventMsg: int = ...
    kIMouseYEventMsg: int = ...
    kIfaceFadeAvatarMsg: int = ...
    kImageLibMod: int = ...
    kImpulseMsg: int = ...
    kInitialAgeStateLoadedMsg: int = ...
    kInputEventMsg: int = ...
    kInputIfaceMgrMsg: int = ...
    kInputInterfaceMgr: int = ...
    kInputManager: int = ...
    kInstanceDrawInterface: int = ...
    kIntRefMsg: int = ...
    kInterestWellModifier: int = ...
    kInterestingModMsg: int = ...
    kInterestingModifier: int = ...
    kInterestingPing: int = ...
    kInterfaceInfoModifier: int = ...
    kIntersectionIsect: int = ...
    kInventoryMod: int = ...
    kInventoryMsg: int = ...
    kInventoryObjMod: int = ...
    kJournalBook: int = ...
    kKI: int = ...
    kKIMsg: int = ...
    kKeyEventMsg: int = ...
    kKeyPressConditionalObject: int = ...
    kKeyedObject: int = ...
    kLODMipmap: int = ...
    kLOSDispatch: int = ...
    kLOSHitMsg: int = ...
    kLOSRequestMsg: int = ...
    kLadderModifier: int = ...
    kLayRefMsg: int = ...
    kLayer: int = ...
    kLayerAVI: int = ...
    kLayerAnimation: int = ...
    kLayerAnimationBase: int = ...
    kLayerBink: int = ...
    kLayerDepth: int = ...
    kLayerInterface: int = ...
    kLayerLightBase: int = ...
    kLayerLinkAnimation: int = ...
    kLayerMovie: int = ...
    kLayerOr: int = ...
    kLayerProject: int = ...
    kLayerSDLAnimation: int = ...
    kLayerSDLModifier: int = ...
    kLayerShadowBase: int = ...
    kLayerTargetContainer: int = ...
    kLayerTransform: int = ...
    kLayerWrapper: int = ...
    kLeafController: int = ...
    kLightAmbientApplicator: int = ...
    kLightDiffuseApplicator: int = ...
    kLightInfo: int = ...
    kLightModifier: int = ...
    kLightRefMsg: int = ...
    kLightSpace: int = ...
    kLightSpecularApplicator: int = ...
    kLimitedDirLightInfo: int = ...
    kLineFollowMod: int = ...
    kLineFollowModBase: int = ...
    kLinearVelocityMsg: int = ...
    kLinkCallbackMsg: int = ...
    kLinkEffectBCMsg: int = ...
    kLinkEffectPrepBCMsg: int = ...
    kLinkEffectsDoneMsg: int = ...
    kLinkEffectsMgr: int = ...
    kLinkEffectsTriggerMsg: int = ...
    kLinkEffectsTriggerPrepMsg: int = ...
    kLinkInDoneMsg: int = ...
    kLinkOutUnloadMsg: int = ...
    kLinkToAgeMsg: int = ...
    kLinkingMgrMsg: int = ...
    kListener: int = ...
    kListenerMsg: int = ...
    kLoadAgeMsg: int = ...
    kLoadAvatarMsg: int = ...
    kLoadCloneMsg: int = ...
    kLocalPlayerInBoxConditionalObject: int = ...
    kLocalPlayerIntersectPlaneConditionalObject: int = ...
    kLogicModBase: int = ...
    kLogicModifier: int = ...
    kLogicTriggerMsg: int = ...
    kLtdDirModifier: int = ...
    kMaintainersMarkerModifier: int = ...
    kMarkerMgr: int = ...
    kMarkerMsg: int = ...
    kMatRefMsg: int = ...
    kMaterial: int = ...
    kMatrix33Controller: int = ...
    kMatrix44Controller: int = ...
    kMatrixBlend: int = ...
    kMatrixBorrowedChannel: int = ...
    kMatrixChannel: int = ...
    kMatrixChannelApplicator: int = ...
    kMatrixConstant: int = ...
    kMatrixControllerCacheChannel: int = ...
    kMatrixControllerChannel: int = ...
    kMatrixDelayedCorrectionApplicator: int = ...
    kMatrixDifferenceApp: int = ...
    kMatrixTimeScale: int = ...
    kMatrixUpdateMsg: int = ...
    kMemberUpdateMsg: int = ...
    kMeshRefMsg: int = ...
    kMessage: int = ...
    kMessageWithCallbacks: int = ...
    kMipmap: int = ...
    kMobileOccluder: int = ...
    kModifier: int = ...
    kModulator: int = ...
    kMorphDataSet: int = ...
    kMorphDelta: int = ...
    kMorphSequence: int = ...
    kMorphSequenceSDLMod: int = ...
    kMouseEventMsg: int = ...
    kMovableMod: int = ...
    kMovieEventMsg: int = ...
    kMovieMsg: int = ...
    kMsgForwarder: int = ...
    kMultiModMsg: int = ...
    kMultiModifier: int = ...
    kMultistageBehMod: int = ...
    kMultistageModMsg: int = ...
    kMySqlDB: int = ...
    kNCAgeJoinerMsg: int = ...
    kNPCSpawnMod: int = ...
    kNetApp: int = ...
    kNetAuthDatabase: int = ...
    kNetClientApp: int = ...
    kNetClientAuthTask: int = ...
    kNetClientCalibrateTask: int = ...
    kNetClientCommAuthTask: int = ...
    kNetClientCommCheckServerSilenceTask: int = ...
    kNetClientCommCreatePlayerTask: int = ...
    kNetClientCommCreatePublicAgeTask: int = ...
    kNetClientCommDeletePlayerTask: int = ...
    kNetClientCommFindAgeTask: int = ...
    kNetClientCommGetPlayerListTask: int = ...
    kNetClientCommGetPublicAgeListTask: int = ...
    kNetClientCommJoinAgeTask: int = ...
    kNetClientCommLeaveTask: int = ...
    kNetClientCommPingTask: int = ...
    kNetClientCommRegisterOwnedAge: int = ...
    kNetClientCommRegisterVisitAge: int = ...
    kNetClientCommRemovePublicAgeTask: int = ...
    kNetClientCommSendPeriodicAliveTask: int = ...
    kNetClientCommSetActivePlayerTask: int = ...
    kNetClientCommSetAgePublicTask: int = ...
    kNetClientCommSetTimeoutTask: int = ...
    kNetClientCommTask: int = ...
    kNetClientCommUnregisterOwnerAge: int = ...
    kNetClientCommUnregisterVisitAge: int = ...
    kNetClientConnectAgeVaultTask: int = ...
    kNetClientConnectPrepTask: int = ...
    kNetClientFindAgeTask: int = ...
    kNetClientFindDefaultAgeTask: int = ...
    kNetClientGetPlayerVaultTask: int = ...
    kNetClientJoinTask: int = ...
    kNetClientLeaveTask: int = ...
    kNetClientMember: int = ...
    kNetClientMgr: int = ...
    kNetClientMgrMsg: int = ...
    kNetClientSetActivePlayerTask: int = ...
    kNetClientTask: int = ...
    kNetCommActivePlayerMsg: int = ...
    kNetCommAuthConnectedMsg: int = ...
    kNetCommAuthMsg: int = ...
    kNetCommCreatePlayerMsg: int = ...
    kNetCommDeletePlayerMsg: int = ...
    kNetCommFileDownloadMsg: int = ...
    kNetCommFileListMsg: int = ...
    kNetCommLinkToAgeMsg: int = ...
    kNetCommPlayerListMsg: int = ...
    kNetCommPublicAgeListMsg: int = ...
    kNetCommPublicAgeMsg: int = ...
    kNetCommRegisterAgeMsg: int = ...
    kNetCoreStatsSummary: int = ...
    kNetGameMember: int = ...
    kNetGenericDatabase: int = ...
    kNetGenericServerTask: int = ...
    kNetLookupServerGetAgeInfoFromVaultTask: int = ...
    kNetMember: int = ...
    kNetMessage: int = ...
    kNetMsgAccountAuthenticated: int = ...
    kNetMsgActivePlayerSet: int = ...
    kNetMsgAlive: int = ...
    kNetMsgAuthenticateChallenge: int = ...
    kNetMsgAuthenticateHello: int = ...
    kNetMsgAuthenticateResponse: int = ...
    kNetMsgCreatableHelper: int = ...
    kNetMsgCreatePlayer: int = ...
    kNetMsgCreatePublicAge: int = ...
    kNetMsgDeletePlayer: int = ...
    kNetMsgFindAge: int = ...
    kNetMsgFindAgeReply: int = ...
    kNetMsgGameMessage: int = ...
    kNetMsgGameMessageDirected: int = ...
    kNetMsgGameStateRequest: int = ...
    kNetMsgGetPublicAgeList: int = ...
    kNetMsgGetSharedState: int = ...
    kNetMsgGroupOwner: int = ...
    kNetMsgInitialAgeStateSent: int = ...
    kNetMsgJoinAck: int = ...
    kNetMsgJoinReq: int = ...
    kNetMsgLeave: int = ...
    kNetMsgListenListUpdate: int = ...
    kNetMsgLoadClone: int = ...
    kNetMsgMemberInfoHelper: int = ...
    kNetMsgMemberListHelper: int = ...
    kNetMsgMemberUpdate: int = ...
    kNetMsgMembersList: int = ...
    kNetMsgMembersListReq: int = ...
    kNetMsgObjStateRequest: int = ...
    kNetMsgObject: int = ...
    kNetMsgObjectHelper: int = ...
    kNetMsgObjectListHelper: int = ...
    kNetMsgObjectUpdateFilter: int = ...
    kNetMsgOmnibus: int = ...
    kNetMsgPagingRoom: int = ...
    kNetMsgPing: int = ...
    kNetMsgPlayerCreated: int = ...
    kNetMsgPlayerPage: int = ...
    kNetMsgPublicAgeCreated: int = ...
    kNetMsgPublicAgeList: int = ...
    kNetMsgPublicAgeRemoved: int = ...
    kNetMsgPython: int = ...
    kNetMsgReceiversListHelper: int = ...
    kNetMsgRelevanceRegions: int = ...
    kNetMsgRemovePublicAge: int = ...
    kNetMsgRequestMyVaultPlayerList: int = ...
    kNetMsgRoomsList: int = ...
    kNetMsgRoutingInfo: int = ...
    kNetMsgSDLState: int = ...
    kNetMsgSDLStateBCast: int = ...
    kNetMsgServerToClient: int = ...
    kNetMsgSessionReset: int = ...
    kNetMsgSetMyActivePlayer: int = ...
    kNetMsgSetTimeout: int = ...
    kNetMsgSharedState: int = ...
    kNetMsgStream: int = ...
    kNetMsgStreamHelper: int = ...
    kNetMsgStreamableHelper: int = ...
    kNetMsgStreamedObject: int = ...
    kNetMsgTerminated: int = ...
    kNetMsgTestAndSet: int = ...
    kNetMsgVault: int = ...
    kNetMsgVaultPlayerList: int = ...
    kNetMsgVaultTask: int = ...
    kNetMsgVoice: int = ...
    kNetOwnershipMsg: int = ...
    kNetRoutableMsgOmnibus: int = ...
    kNetServerApp: int = ...
    kNetServerMember: int = ...
    kNetServerMsg: int = ...
    kNetServerMsgAccountPlayerList: int = ...
    kNetServerMsgAgentRecoveryData: int = ...
    kNetServerMsgAgentRecoveryRequest: int = ...
    kNetServerMsgAuthReply: int = ...
    kNetServerMsgAuthRequest: int = ...
    kNetServerMsgBackendRecoveryData: int = ...
    kNetServerMsgBackendRecoveryRequest: int = ...
    kNetServerMsgEnvelope: int = ...
    kNetServerMsgExitProcess: int = ...
    kNetServerMsgFindAuthServer: int = ...
    kNetServerMsgFindAuthServerReply: int = ...
    kNetServerMsgFindProcess: int = ...
    kNetServerMsgFindServerBase: int = ...
    kNetServerMsgFindServerReplyBase: int = ...
    kNetServerMsgFindVaultServer: int = ...
    kNetServerMsgFindVaultServerReply: int = ...
    kNetServerMsgFrontendRecoveryData: int = ...
    kNetServerMsgFrontendRecoveryRequest: int = ...
    kNetServerMsgHello: int = ...
    kNetServerMsgHelloReply: int = ...
    kNetServerMsgPendingMsgs: int = ...
    kNetServerMsgPing: int = ...
    kNetServerMsgPlsRoutableMsg: int = ...
    kNetServerMsgPlsUpdatePlayer: int = ...
    kNetServerMsgPlsUpdatePlayerReply: int = ...
    kNetServerMsgProcessFound: int = ...
    kNetServerMsgRegisterProcess: int = ...
    kNetServerMsgRegisterServer: int = ...
    kNetServerMsgRequestAccountPlayerList: int = ...
    kNetServerMsgRequestPendingMsgs: int = ...
    kNetServerMsgSaveGameState: int = ...
    kNetServerMsgServerRegistered: int = ...
    kNetServerMsgSessionReset: int = ...
    kNetServerMsgStartProcess: int = ...
    kNetServerMsgUnregisterProcess: int = ...
    kNetServerMsgUnregisterServer: int = ...
    kNetServerMsgVault: int = ...
    kNetServerMsgVaultCreatePlayer: int = ...
    kNetServerMsgVaultDeletePlayer: int = ...
    kNetServerMsgVaultGameState: int = ...
    kNetServerMsgVaultGameStateLoad: int = ...
    kNetServerMsgVaultGameStateSave: int = ...
    kNetServerMsgVaultGameStateSaved: int = ...
    kNetServerMsgVaultPlayerCreated: int = ...
    kNetServerMsgVaultRequestGameState: int = ...
    kNetServerMsgVaultTask: int = ...
    kNetServerMsgWithContext: int = ...
    kNetServerSessionInfo: int = ...
    kNetTransportMember: int = ...
    kNetVaultDatabase: int = ...
    kNetVaultServerInitializationTask: int = ...
    kNetVaultServerNode: int = ...
    kNetVoiceListMsg: int = ...
    kNodeChangeMsg: int = ...
    kNodeCleanupMsg: int = ...
    kNodeMgr: int = ...
    kNodeRefMsg: int = ...
    kNodeRegionModifier: int = ...
    kNodeRegionMsg: int = ...
    kNotifyMsg: int = ...
    kORConditionalObject: int = ...
    kObjInterface: int = ...
    kObjRefMsg: int = ...
    kObjectFlocker: int = ...
    kObjectInBoxConditionalObject: int = ...
    kObjectInVolumeAndFacingDetector: int = ...
    kObjectInVolumeDetector: int = ...
    kObjectIntersectPlaneConditionalObject: int = ...
    kOccluder: int = ...
    kOffsetForceMsg: int = ...
    kOffsetImpulseMsg: int = ...
    kOmniApplicator: int = ...
    kOmniCutoffApplicator: int = ...
    kOmniLightInfo: int = ...
    kOmniModifier: int = ...
    kOmniSqApplicator: int = ...
    kOneShotMod: int = ...
    kOneShotMsg: int = ...
    kOneTimeParticleGenerator: int = ...
    kPagingRegionModifier: int = ...
    kPanicLinkMsg: int = ...
    kPanicLinkRegion: int = ...
    kParallelIsect: int = ...
    kParticleAngleApplicator: int = ...
    kParticleApplicator: int = ...
    kParticleBulletEffect: int = ...
    kParticleBulletHitMsg: int = ...
    kParticleCollisionEffect: int = ...
    kParticleCollisionEffectBeat: int = ...
    kParticleCollisionEffectBounce: int = ...
    kParticleCollisionEffectDie: int = ...
    kParticleEffect: int = ...
    kParticleEmitter: int = ...
    kParticleFadeOutEffect: int = ...
    kParticleFadeVolumeEffect: int = ...
    kParticleFlockEffect: int = ...
    kParticleFlockMsg: int = ...
    kParticleFollowSystemEffect: int = ...
    kParticleGenerator: int = ...
    kParticleKillMsg: int = ...
    kParticleLifeMaxApplicator: int = ...
    kParticleLifeMinApplicator: int = ...
    kParticleLocalWind: int = ...
    kParticlePPSApplicator: int = ...
    kParticleSDLMod: int = ...
    kParticleScaleMaxApplicator: int = ...
    kParticleScaleMinApplicator: int = ...
    kParticleSystem: int = ...
    kParticleTransferMsg: int = ...
    kParticleUniformWind: int = ...
    kParticleUpdateMsg: int = ...
    kParticleVelMaxApplicator: int = ...
    kParticleVelMinApplicator: int = ...
    kParticleWindEffect: int = ...
    kPhysical: int = ...
    kPhysicalMesh: int = ...
    kPhysicalModifier: int = ...
    kPhysicalProperties: int = ...
    kPhysicalSDLModifier: int = ...
    kPhysicalSndGroup: int = ...
    kPickedConditionalObject: int = ...
    kPickedMsg: int = ...
    kPickingDetector: int = ...
    kPipeGeoMakeMsg: int = ...
    kPipeRTMakeMsg: int = ...
    kPipeResMakeMsg: int = ...
    kPipeTexMakeMsg: int = ...
    kPipeline: int = ...
    kPiranhaRegionModifier: int = ...
    kPiranhaRegionMsg: int = ...
    kPlayerBookMod: int = ...
    kPlayerInfo: int = ...
    kPlayerMsg: int = ...
    kPlayerPageMsg: int = ...
    kPoint3Controller: int = ...
    kPointBlend: int = ...
    kPointChannel: int = ...
    kPointChannelApplicator: int = ...
    kPointConstant: int = ...
    kPointControllerCacheChannel: int = ...
    kPointControllerChannel: int = ...
    kPointShadowMaster: int = ...
    kPointTimeScale: int = ...
    kPortalDrawable: int = ...
    kPortalPhysical: int = ...
    kPosController: int = ...
    kPostEffectMod: int = ...
    kPreResourceMsg: int = ...
    kPreloaderMsg: int = ...
    kPrintShape: int = ...
    kProxyDrawMsg: int = ...
    kPseudoLinkAnimCallbackMsg: int = ...
    kPseudoLinkAnimTriggerMsg: int = ...
    kPseudoLinkEffectMsg: int = ...
    kPuppetBrainMsg: int = ...
    kPythonFileMod: int = ...
    kPythonFileModConditionalObject: int = ...
    kPythonMod: int = ...
    kPythonMsg: int = ...
    kPythonNotifyMsg: int = ...
    kPythonSDLModifier: int = ...
    kQuatBlend: int = ...
    kQuatChannel: int = ...
    kQuatChannelApplicator: int = ...
    kQuatConstant: int = ...
    kQuatController: int = ...
    kQuatPointCombine: int = ...
    kQuatTimeScale: int = ...
    kRailCameraMod: int = ...
    kRandomCommandMod: int = ...
    kRandomSoundMod: int = ...
    kRandomTMModifier: int = ...
    kReceiver: int = ...
    kRefMsg: int = ...
    kRegionBase: int = ...
    kRelativeMatrixChannelApplicator: int = ...
    kRelevanceMgr: int = ...
    kRelevanceRegion: int = ...
    kRemoteAvatarInfoMsg: int = ...
    kRenderMsg: int = ...
    kRenderRequestAck: int = ...
    kRenderRequestMsg: int = ...
    kRenderTarget: int = ...
    kReplaceGeometryMsg: int = ...
    kResManagerHelper: int = ...
    kResMgrHelperMsg: int = ...
    kResponderEnableMsg: int = ...
    kResponderModifier: int = ...
    kResponderMsg: int = ...
    kResponderSDLModifier: int = ...
    kRideAnimatedPhysMsg: int = ...
    kRidingAnimatedPhysicalDetector: int = ...
    kRippleShapeMsg: int = ...
    kRoomLoadNotifyMsg: int = ...
    kRotController: int = ...
    kSDLAgeTimeElapsedVar: int = ...
    kSDLAgeTimeOfDayVar: int = ...
    kSDLArrayVar: int = ...
    kSDLBoolVar: int = ...
    kSDLBufferVar: int = ...
    kSDLByteVar: int = ...
    kSDLCharVar: int = ...
    kSDLDoubleVar: int = ...
    kSDLDynArrayBoolVar: int = ...
    kSDLDynArrayBufferVar: int = ...
    kSDLDynArrayByteVar: int = ...
    kSDLDynArrayCharVar: int = ...
    kSDLDynArrayDoubleVar: int = ...
    kSDLDynArrayFloatVar: int = ...
    kSDLDynArrayIntVar: int = ...
    kSDLDynArrayMatrix44Var: int = ...
    kSDLDynArrayPoint3Var: int = ...
    kSDLDynArrayQuaternionVar: int = ...
    kSDLDynArrayRGBAVar: int = ...
    kSDLDynArrayStringVar: int = ...
    kSDLDynArrayStructVar: int = ...
    kSDLDynArrayTimeVar: int = ...
    kSDLDynArrayUIntVar: int = ...
    kSDLDynArrayUoidVar: int = ...
    kSDLDynArrayVector3Var: int = ...
    kSDLFixedArrayBoolVar: int = ...
    kSDLFixedArrayBufferVar: int = ...
    kSDLFixedArrayByteVar: int = ...
    kSDLFixedArrayCharVar: int = ...
    kSDLFixedArrayDoubleVar: int = ...
    kSDLFixedArrayFloatVar: int = ...
    kSDLFixedArrayIntVar: int = ...
    kSDLFixedArrayMatrix44Var: int = ...
    kSDLFixedArrayPoint3Var: int = ...
    kSDLFixedArrayQuaternionVar: int = ...
    kSDLFixedArrayRGBAVar: int = ...
    kSDLFixedArrayStringVar: int = ...
    kSDLFixedArrayStructVar: int = ...
    kSDLFixedArrayTimeVar: int = ...
    kSDLFixedArrayUIntVar: int = ...
    kSDLFixedArrayUoidVar: int = ...
    kSDLFixedArrayVector3Var: int = ...
    kSDLFloatVar: int = ...
    kSDLGameTimeElapsedVar: int = ...
    kSDLIntVar: int = ...
    kSDLMatrix44Var: int = ...
    kSDLMetaDoubleVar: int = ...
    kSDLModifier: int = ...
    kSDLModifierMsg: int = ...
    kSDLNotificationMsg: int = ...
    kSDLPoint3Var: int = ...
    kSDLQuaternionVar: int = ...
    kSDLRGBAVar: int = ...
    kSDLStoreMsg: int = ...
    kSDLStringVar: int = ...
    kSDLStructVar: int = ...
    kSDLTimeVar: int = ...
    kSDLUIntVar: int = ...
    kSDLUoidVar: int = ...
    kSDLVar: int = ...
    kSDLVarChangeMsg: int = ...
    kSDLVarChangeNotifier: int = ...
    kSDLVector3Var: int = ...
    kSatisfiedMsg: int = ...
    kScalarBlend: int = ...
    kScalarChannel: int = ...
    kScalarChannelApplicator: int = ...
    kScalarConstant: int = ...
    kScalarController: int = ...
    kScalarControllerCacheChannel: int = ...
    kScalarControllerChannel: int = ...
    kScalarSDLChannel: int = ...
    kScalarTimeScale: int = ...
    kScaleController: int = ...
    kScaleValueController: int = ...
    kSceneNode: int = ...
    kSceneObject: int = ...
    kSecurePreloader: int = ...
    kSeekPointMod: int = ...
    kSelfDestructMsg: int = ...
    kServerGuid: int = ...
    kServerReplyMsg: int = ...
    kSetListenerMsg: int = ...
    kSetNetGroupIDMsg: int = ...
    kSfxAngleFade: int = ...
    kSfxDistFade: int = ...
    kSfxDistShade: int = ...
    kSfxGlobalShade: int = ...
    kSfxIntenseAlpha: int = ...
    kSfxObjDistFade: int = ...
    kSfxObjDistShade: int = ...
    kShader: int = ...
    kShadowCastMsg: int = ...
    kShadowCaster: int = ...
    kShadowMaster: int = ...
    kSharedMesh: int = ...
    kSharedMeshBCMsg: int = ...
    kSharedStateMsg: int = ...
    kShiftMassMsg: int = ...
    kSimInfluenceMsg: int = ...
    kSimStateMsg: int = ...
    kSimSuppressMsg: int = ...
    kSimpleModifier: int = ...
    kSimpleParticleGenerator: int = ...
    kSimplePhys: int = ...
    kSimplePhysicalMesh: int = ...
    kSimplePosController: int = ...
    kSimpleRegionSensor: int = ...
    kSimpleRotController: int = ...
    kSimpleScaleController: int = ...
    kSimpleTMModifier: int = ...
    kSimulationInterface: int = ...
    kSimulationMgr: int = ...
    kSimulationMsg: int = ...
    kSimulationSynchMsg: int = ...
    kSingleModMsg: int = ...
    kSingleModifier: int = ...
    kSittingModifier: int = ...
    kSoftVolume: int = ...
    kSoftVolumeComplex: int = ...
    kSoftVolumeIntersect: int = ...
    kSoftVolumeInvert: int = ...
    kSoftVolumeSimple: int = ...
    kSoftVolumeUnion: int = ...
    kSound: int = ...
    kSoundBuffer: int = ...
    kSoundMsg: int = ...
    kSoundSDLModifier: int = ...
    kSoundVolumeApplicator: int = ...
    kSpaceTree: int = ...
    kSpawnMod: int = ...
    kSpawnModMsg: int = ...
    kSpawnModifier: int = ...
    kSpawnRequestMsg: int = ...
    kSphereIsect: int = ...
    kSplineEaseCurve: int = ...
    kSpotInnerApplicator: int = ...
    kSpotLightInfo: int = ...
    kSpotModifier: int = ...
    kSpotOuterApplicator: int = ...
    kStateDataRecord: int = ...
    kStereizer: int = ...
    kStrongSpringConstraintMod: int = ...
    kSubWorldMsg: int = ...
    kSubtitleMgr: int = ...
    kSubtitleMsg: int = ...
    kSubworldRegionDetector: int = ...
    kSuperVNodeMgrInitTask: int = ...
    kSuspendEventMsg: int = ...
    kSwapSpansRefMsg: int = ...
    kSwimCircularCurrentRegion: int = ...
    kSwimDetector: int = ...
    kSwimMsg: int = ...
    kSwimRegionInterface: int = ...
    kSwimStraightCurrentRegion: int = ...
    kSynchEnableMsg: int = ...
    kSynchedObject: int = ...
    kSyslogEventLog: int = ...
    kTMController: int = ...
    kTimeMsg: int = ...
    kTimerCallbackManager: int = ...
    kTimerCallbackMsg: int = ...
    kTorqueMsg: int = ...
    kTransformMsg: int = ...
    kTransitionMgr: int = ...
    kTransitionMsg: int = ...
    kTreeShader: int = ...
    kTriggerMsg: int = ...
    kUNUSED_DynamicColorRGB: int = ...
    kUNUSED_DynamicMatrix33: int = ...
    kUNUSED_DynamicMatrix44: int = ...
    kUnionIsect: int = ...
    kVNodeInitTask: int = ...
    kVNodeMgrInitializationTask: int = ...
    kVaultAddNodeRefTask: int = ...
    kVaultAdminInitializationTask: int = ...
    kVaultAdminNode: int = ...
    kVaultAgeInfoInitializationTask: int = ...
    kVaultAgeInfoListNode: int = ...
    kVaultAgeInfoNode: int = ...
    kVaultAgeInitializationTask: int = ...
    kVaultAgeLinkNode: int = ...
    kVaultAgeNode: int = ...
    kVaultCCRInitializationTask: int = ...
    kVaultCCRNode: int = ...
    kVaultChronicleNode: int = ...
    kVaultConnectTask: int = ...
    kVaultDisconnectTask: int = ...
    kVaultFetchNodesTask: int = ...
    kVaultFindNodeTask: int = ...
    kVaultFolderNode: int = ...
    kVaultGameServerInitializationTask: int = ...
    kVaultGameServerNode: int = ...
    kVaultImageNode: int = ...
    kVaultMarkerListNode: int = ...
    kVaultMarkerNode: int = ...
    kVaultMgrNode: int = ...
    kVaultNegotiateManifestTask: int = ...
    kVaultNeighborhoodInitializationTask: int = ...
    kVaultNode: int = ...
    kVaultNodeRef: int = ...
    kVaultNotifyMsg: int = ...
    kVaultNotifyOperationCallbackTask: int = ...
    kVaultPlayerInfoListNode: int = ...
    kVaultPlayerInfoNode: int = ...
    kVaultPlayerInitializationTask: int = ...
    kVaultPlayerNode: int = ...
    kVaultRemoveNodeRefTask: int = ...
    kVaultSDLNode: int = ...
    kVaultSaveNodeTask: int = ...
    kVaultSendNodeTask: int = ...
    kVaultSystemNode: int = ...
    kVaultTask: int = ...
    kVaultTextNoteNode: int = ...
    kVehicleModifier: int = ...
    kViewFaceModifier: int = ...
    kVirtualCam1: int = ...
    kVirtualCamera: int = ...
    kVisMgr: int = ...
    kVisRegion: int = ...
    kVolActivatorConditionalObject: int = ...
    kVolumeIsect: int = ...
    kVolumeSensorConditionalObject: int = ...
    kVolumeSensorConditionalObjectNoArbitration: int = ...
    kWarpMsg: int = ...
    kWaveSet6: int = ...
    kWaveSet7: int = ...
    kWaveSetBase: int = ...
    kWheelConstraintMod: int = ...
    kWin32GroupedSound: int = ...
    kWin32LinkSound: int = ...
    kWin32Sound: int = ...
    kWin32StaticSound: int = ...
    kWin32StreamingSound: int = ...
    kWinAudible: int = ...
    kWindBoneMod: int = ...

    @staticmethod
    def ClassIndex(className: str) -> int: ...
    @staticmethod
    def ClassName(classIndex: int, version: int = pvUnknown) -> str: ...
    @staticmethod
    def ClassVersion(classIndex: int, version: int) -> int: ...

class plFadeOpacityMod(plSingleModifier):
    boundsCenter: bool = ...
    fadeDown: float = ...
    fadeUp: float = ...

class plFilterCoordInterface(plCoordinateInterface):
    kNoMove: int = ...
    kNoNothing: int = ...
    kNoRotation: int = ...
    kNoTransX: int = ...
    kNoTransY: int = ...
    kNoTransZ: int = ...

    filterMask: int = ...
    refParentLocalToWorld: hsMatrix44 = ...

class plFixedWaterState7:
    class WaveState:
        angleDev: float = ...
        ampOverLen: float = ...
        chop: float = ...
        maxLength: float = ...
        minLength: float = ...

    depthFalloff: hsVector3 = ...
    edgeOpacity: float = ...
    edgeRadius: float = ...
    envCenter: hsVector3 = ...
    envRadius: float = ...
    envRefresh: float = ...
    fingerLength: float = ...
    geoState: WaveState = ...
    maxAtten: hsVector3 = ...
    maxColor: hsColorRGBA = ...
    minAtten: hsVector3 = ...
    minColor: hsColorRGBA = ...
    period: float = ...
    rippleScale: float = ...
    shoreTint: hsColorRGBA = ...
    specVector: hsVector3 = ...
    specularTint: hsColorRGBA = ...
    texState: WaveState = ...
    waterHeight: float = ...
    waterOffset: hsVector3 = ...
    waterTint: hsColorRGBA = ...
    windDir: hsVector3 = ...
    wispiness: float = ...

class plFogEnvironment(hsKeyedObject):
    kExp2Fog: int = ...
    kExpFog: int = ...
    kLinearFog: int = ...
    kNoFog: int = ...

    color: hsColorRGBA = ...
    density: float = ...
    end: float = ...
    start: float = ...
    type: int = ...

class plFollowMod(plSingleModifier):
    kFollowCamera: int = ...
    kFollowListener: int = ...
    kFollowObject: int = ...
    kFollowPlayer: int = ...
    kFullTransform: int = ...
    kPosition: int = ...
    kPositionX: int = ...
    kPositionY: int = ...
    kPositionZ: int = ...
    kRotate: int = ...

    leader: Optional[plKey[plSceneObject]] = ...
    leaderType: int = ...
    mode: int = ...

class plFont(hsKeyedObject):
    class plCharacter:
        baseLine: int = ...
        height: int = ...
        leftKern: float = ...
        offset: int = ...
        rightKern: float = ...

    kFontBold: int = ...
    kFontItalic: int = ...

    BPP: int = ...
    bold: bool = ...
    characters: Sequence[plCharacter] = ...
    firstChar: int = ...
    flags: int = ...
    height: int = ...
    italic: bool = ...
    maxCharHeight: int = ...
    name: str = ...
    size: int = ...
    stride: int = ...
    width: int = ...

    def getGlyph(self, index: int) -> bytes: ...
    def readBitmap(self, stream: hsStream) -> None: ...
    def readP2F(self, stream: hsStream) -> None: ...
    def writeBitmap(self, stream: hsStream) -> None: ...
    def writeP2F(self, stream: hsStream) -> None: ...
    def __getitem__(self, index: int) -> plCharacter: ...
    def __len__(self) -> int: ...
    def __setitem__(self, index: int, object: plCharacter) -> None: ...

class plGBufferCell:
    colorStart: int = ...
    length: int = ...
    vtxStart: int = ...

class plGBufferGroup:
    kEncoded: int = ...
    kSkin1Weight: int = ...
    kSkin2Weights: int = ...
    kSkin3Weights: int = ...
    kSkinIndices: int = ...
    kSkinNoWeights: int = ...
    kSkinWeightMask: int = ...
    kUVCountMask: int = ...

    format: int = ...
    hasSkinIndices: bool = ...
    numUVs: int = ...
    skinWeights: int = ...
    stride: int = ...

    def __init__(self, format: int) -> None: ...
    def addCells(self, cells: Sequence[plGBufferCell]) -> None: ...
    def addIndices(self, indices: Sequence[int]) -> None: ...
    def addVertices(self, vertices: Sequence[plGBufferVertex]) -> None: ...
    def clearCells(self) -> None: ...
    def clearIndices(self) -> None: ...
    def clearVertices(self) -> None: ...
    def delCells(self, idx: int) -> None: ...
    def delIndices(self, idx: int) -> None: ...
    def delVertices(self, idx: int) -> None: ...
    def getCells(self, idx: int) -> Sequence[plGBufferCell]: ...
    def getIdxBufferCount(self, idx: int) -> int: ...
    def getIdxBufferStorage(self, idx: int) -> Sequence[int]: ...
    def getIndices(self, idx: int, start: int = 0, len: int = -1) -> Sequence[int]: ...
    def getNumIdxBuffers(self) -> int: ...
    def getNumVertBuffers(self) -> int: ...
    def getVertBufferSize(self, idx: int) -> int: ...
    def getVertBufferStorage(self, idx: int) -> bytes: ...
    def getVertices(self, idx: int, start: int = 0, len: int = -1) -> Sequence[plGBufferVertex]: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plGBufferTriangle:
    center: hsVector3 = ...
    index1: int = ...
    index2: int = ...
    index3: int = ...
    spanIndex: int = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plGBufferVertex:
    UVWs: Sequence[hsVector3] = ...
    color: int = ...
    normal: hsVector3 = ...
    pos: hsVector3 = ...
    skinIdx: int = ...
    skinWeights: Tuple[float, float, float] = ...

class plGenericPhysical(plPhysical):
    LOSDBs: int = ...
    TMDBuffer: bytes = ...
    boundsType: int = ...
    collideGroup: int = ...
    dimensions: hsVector3 = ...
    friction: float = ...
    indices: Sequence[int] = ...
    length: float = ...
    mass: float = ...
    memberGroup: int = ...
    object: Optional[plKey[plSceneObject]] = ...
    offset: hsVector3 = ...
    pos: hsVector3 = ...
    radius: float = ...
    reportGroup: int = ...
    restitution: float = ...
    rot: hsQuat = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    soundGroup: Optional[plKey[plPhysicalSndGroup]] = ...
    subWorld: Optional[plKey[Union[plHKSubWorld, plSceneObject]]] = ...
    verts: Sequence[hsVector3] = ...

    def calcBoxBounds(self, points: Sequence[hsVector3]) -> None: ...
    def calcSphereBounds(self, points: Sequence[hsVector3]) -> None: ...
    def getProperty(self, flag: int) -> bool: ...
    def setProperty(self, flag: int, value: bool) -> None: ...

class plGeometrySpan:
    class TempVertex:
        color: hsColor32 = ...
        indices: int = ...
        normal: hsVector3 = ...
        position: hsVector3 = ...
        uvs: Sequence[hsVector3] = ...
        weights: Tuple[float, float, float] = ...

    kDiffuseFoldedIn: int = ...
    kFirstInstance: int = ...
    kInstanced: int = ...
    kLiteMask: int = ...
    kLiteMaterial: int = ...
    kLiteVtxNonPreshaded: int = ...
    kLiteVtxPreshaded: int = ...
    kPartialSort: int = ...
    kPropForceShadow: int = ...
    kPropNoPreShade: int = ...
    kPropNoShadow: int = ...
    kPropNoShadowCast: int = ...
    kPropReverseSort: int = ...
    kPropRunTimeLight: int = ...
    kRequiresBlending: int = ...
    kSkin1Weight: int = ...
    kSkin2Weights: int = ...
    kSkin3Weights: int = ...
    kSkinIndices: int = ...
    kSkinNoWeights: int = ...
    kSkinWeightMask: int = ...
    kUVCountMask: int = ...
    kUserOwned: int = ...
    kVisLOS: int = ...
    kWaterHeight: int = ...

    baseMatrix: int = ...
    fogEnvironment: Optional[plKey[plFogEnvironment]] = ...
    format: int = ...
    indices: Sequence[int] = ...
    localBounds: hsBounds3Ext = ...
    localToWorld: hsMatrix44 = ...
    localUVWChans: int = ...
    material: Optional[plKey[hsGMaterial]]  = ...
    maxBoneIdx: int = ...
    maxDist: float = ...
    minDist: float = ...
    numIndices: int = ...
    numMatrices: int = ...
    numVertices: int = ...
    penBoneIdx: int = ...
    permaLights: Sequence[plKey[plLightInfo]] = ...
    permaProjs: Sequence[plKey[plLightInfo]] = ...
    props: int = ...
    vertices: Sequence[TempVertex] = ...
    waterHeight: float = ...
    worldBounds: hsBounds3Ext = ...
    worldToLocal: hsMatrix44 = ...

    def addPermaLight(self, light: plKey[plLightInfo]) -> None: ...
    def addPermaProj(self, light: plKey[plLightInfo]) -> None: ...
    def clearPermaLight(self) -> None: ...
    def clearPermaProj(self) -> None: ...
    def delPermaLight(self, idx: int) -> None: ...
    def delPermaProj(self, idx: int) -> None: ...

class plGrassShaderMod(plModifier):
    material: Optional[plKey[hsGMaterial]] = ...
    waves: Tuple[plGrassWave, plGrassWave, plGrassWave, plGrassWave]

class plGrassWave:
    dirX: float = ...
    dirY: float = ...
    dist: hsVector3 = ...
    speed: float = ...

class plHKSubWorld(plObjInterface):
    gravity: hsVector3 = ...

class plIcicle(plVertexSpan):
    IBufferIdx: int = ...
    ILength: int = ...
    IStartIdx: int = ...
    sortData: Sequence[plGBufferTriangle] = ...

class plImageLibMod(plSingleModifier):
    images: Sequence[plKey[plBitmap]] = ...

    def addImage(self, image: plKey[plBitmap]) -> None: ...
    def clearImages(self) -> None: ...
    def delImage(self, idx: int) -> None: ...

class plInterfaceInfoModifier(plSingleModifier):
    intfKeys: Sequence[plKey] = ...

    def addIntfKey(self, key: plKey) -> None: ...
    def clearIntfKeys(self) -> None: ...
    def delIntfKey(self, idx: int) -> None: ...

class plJPEG:
    @staticmethod
    def DecompressJPEG(stream: hsStream) -> plMipmap:
        ...

class plKey(Generic[KeyedT]):
    id: int = ...
    location: plLocation = ...
    mask: int = ...
    name: str = ...
    object: KeyedT = ...
    type: int = ...

    def exists(self) -> bool: ...
    def isLoaded(self) -> bool: ...
    def orderAfter(self, otherKey: plKey[KeyedT]) -> bool: ...
    def read(self, stream: hsStream) -> Any: ...
    def readUoid(self, stream: hsStream) -> Any: ...
    def write(self, stream: hsStream) -> Any: ...
    def writeUoid(self, stream: hsStream) -> Any: ...
    def __eq__(self, other: plKey) -> bool: ...
    def __ge__(self, other: plKey) -> bool: ...
    def __gt__(self, other: plKey) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: plKey) -> bool: ...
    def __lt__(self, other: plKey) -> bool: ...
    def __ne__(self, other: plKey) -> bool: ...

class plKeyPressConditionalObject(plConditionalObject):
    keyEvent: int = ...

class plLODDist:
    max: float = ...
    min: float = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plLadderModifier(plSingleModifier):
    bottomLogic: Optional[plKey] = ...
    bottomPos: Optional[plKey] = ...
    exitBottom: Optional[plKey] = ...
    exitTop: Optional[plKey] = ...
    mainLogic: Optional[plKey] = ...
    topLogic: Optional[plKey] = ...
    topPos: Optional[plKey] = ...

class plLayer(plLayerInterface):
    ...

class plLayerAVI(plLayerMovie):
    ...

class plLayerAnimation(plLayerAnimationBase):
    timeConvert: plAnimTimeConvert = ...

class plLayerAnimationBase(plLayerInterface):
    ambientCtl: Optional[plController] = ...
    opacityCtl: Optional[plController] = ...
    preshadeCtl: Optional[plController] = ...
    runtimeCtl: Optional[plController] = ...
    specularCtl: Optional[plController] = ...
    transformCtl: Optional[plController] = ...

class plLayerBink(plLayerMovie):
    ...

class plLayerDepth(plLayer):
    ...

class plLayerInterface(plSynchedObject):
    kAllDirty: int = ...
    kAmbientColor: int = ...
    kBumpEnvXfm: int = ...
    kLODBias: int = ...
    kOpacity: int = ...
    kPixelShader: int = ...
    kPreshadeColor: int = ...
    kRuntimeColor: int = ...
    kSpecularColor: int = ...
    kSpecularPower: int = ...
    kState: int = ...
    kTexture: int = ...
    kTransform: int = ...
    kUVWIdxMask: int = ...
    kUVWNormal: int = ...
    kUVWPassThru: int = ...
    kUVWPosition: int = ...
    kUVWReflect: int = ...
    kUVWSrc: int = ...
    kVertexShader: int = ...

    LODBias: float = ...
    UVWSrc: int = ...
    ambient: hsMatrix44 = ...
    bottomOfStack: plKey[plLayerInterface] = ...
    bumpEnvTransform: hsMatrix44 = ...
    opacity: float = ...
    pixelShader: Optional[plKey[plShader]] = ...
    preshade: hsColorRGBA = ...
    runtime: hsColorRGBA = ...
    specular: hsColorRGBA = ...
    specularPower: float = ...
    state: hsGMatState = ...
    texture: Optional[plKey[plBitmap]] = ...
    transform: hsMatrix44 = ...
    underLay: Optional[plKey[plLayerInterface]] = ...
    vertexShader: Optional[plKey[plShader]] = ...

class plLayerLinkAnimation(plLayerAnimation):
    leavingAge: bool = ...
    linkKey: Optional[plKey[plSceneObject]] = ...

class plLayerMovie(plLayerAnimation):
    movieName: Union[PathLike, str] = ...

class plLayerSDLAnimation(plLayerAnimationBase):
    varName: str = ...

class plLeafController(plController):
    easeControllers: Sequence[plEaseController] = ...
    keys: Tuple[Sequence[hsKeyFrame], int] = ...
    type: int = ...

    def CompactToLeafController(self) -> plLeafController: ...
    def ExpandToKeyController(self) -> plLeafController: ...
    def hasEaseControllers(self) -> bool: ...
    def hasKeys(self) -> bool: ...

class plLightAmbientApplicator(plAGApplicator):
    ...

class plLightDiffuseApplicator(plAGApplicator):
    ...

class plLightInfo(plObjInterface):
    kLPCastShadows: int = ...
    kLPForceProj: int = ...
    kLPHasIncludes: int = ...
    kLPHasSpecular: int = ...
    kLPIncludesChars: int = ...
    kLPMovable: int = ...
    kLPObsolete: int = ...
    kLPOverAll: int = ...
    kLPShadowLightGroup: int = ...
    kLPShadowOnly: int = ...

    ambient: hsColorRGBA = ...
    diffuse: hsColorRGBA = ...
    lightToLocal: hsMatrix44 = ...
    lightToWorld: hsMatrix44 = ...
    localToLight: hsMatrix44 = ...
    projection: Optional[plKey[plLayerInterface]] = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    softVolume: Optional[plKey[plSoftVolume]] = ...
    specular: hsColorRGBA = ...
    visRegions: Sequence[plKey[plVisRegion]] = ...
    worldToLight: hsMatrix44 = ...

    def addVisRegion(self, region: plKey[plVisRegion]) -> None: ...
    def clearVisRegions(self) -> None: ...

class plLightSpecularApplicator(plAGApplicator):
    ...

class plLimitedDirLightInfo(plDirectionalLightInfo):
    depth: float = ...
    height: float = ...
    width: float = ...

class plLineFollowMod(plMultiModifier):
    kFollowCamera: int = ...
    kFollowListener: int = ...
    kFollowLocalAvatar: int = ...
    kFollowObject: int = ...
    kForceToLine: int = ...
    kFullMatrix: int = ...
    kNone: int = ...
    kOffset: int = ...
    kOffsetAng: int = ...
    kOffsetClamp: int = ...
    kOffsetFeet: int = ...
    kSearchPopPos: int = ...
    kSpeedClamp: int = ...

    followFlags: int = ...
    followMode: int = ...
    offset: float = ...
    offsetClamp: float = ...
    path: Optional[plAnimPath] = ...
    pathParent: Optional[plKey[plSceneObject]] = ...
    refObj: Optional[plKey[plSceneObject]] = ...
    speedClamp: float = ...
    stereizers: Sequence[plKey[plStereizer]] = ...

    def addStereizer(self, stereizer: plKey[plStereizer]) -> None: ...
    def clearStereizers(self) -> None: ...
    def delStereizer(self, idx: int) -> None: ...

class plLinkToAgeMsg(plMessage):
    ageLink: plAgeLinkStruct = ...
    linkEffects: plAgeLinkEffects = ...

class plLocalPlayerInBoxConditionalObject(plConditionalObject):
    ...

class plLocalPlayerIntersectPlaneConditionalObject(plConditionalObject):
    ...

class plLocation:
    kBuiltIn: int = ...
    kItinerant: int = ...
    kLocalOnly: int = ...
    kReserved: int = ...
    kVolatile: int = ...

    flags: int = ...
    page: int = ...
    prefix: int = ...
    version: int = ...

    def __init__(self, version: int = pvUnknown) -> None: ...
    def invalidate(self) -> None: ...
    def isGlobal(self) -> bool: ...
    def isItinerant(self) -> bool: ...
    def isReserved(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def parse(self, locationId: int) -> None: ...
    def read(self, stream: hsStream) -> None: ...
    def setVirtual(self) -> None: ...
    def unparse(self) -> int: ...
    def write(self, stream: hsStream) -> None: ...
    def __eq__(self, other: plLocation) -> bool: ...
    def __ge__(self, other: plLocation) -> bool: ...
    def __gt__(self, other: plLocation) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: plLocation) -> bool: ...
    def __lt__(self, other: plLocation) -> bool: ...
    def __ne__(self, other: plLocation) -> bool: ...

class plLogicModBase(plSingleModifier):
    kLocalElement: int = ...
    kMultiTrigger: int = ...
    kOneShot: int = ...
    kRequestingTrigger: int = ...
    kReset: int = ...
    kTriggered: int = ...
    kTypeActivator: int = ...

    commands: Sequence[plMessage] = ...
    disabled: bool = ...
    notify: Optional[plNotifyMsg] = ...

    def addCommand(self, command: plMessage) -> None: ...
    def clearCommands(self) -> None: ...
    def delCommand(self, idx: int) -> None: ...
    def getLogicFlag(self, flag: int) -> bool: ...
    def setLogicFlag(self, flag: int, value: bool) -> None: ...

class plLogicModifier(plLogicModBase):
    conditions: Sequence[plKey[plConditionalObject]] = ...
    cursor: int = ...
    parent: Optional[plKey] = ...

    def addCondition(self, condition: plKey[plConditionalObject]) -> None: ...
    def clearConditions(self) -> None: ...
    def delCondition(self, idx: int) -> None: ...

class plMaintainersMarkerModifier(plMultiModifier):
    kBroken: int = ...
    kCalibrated: int = ...
    kRepaired: int = ...

    calibration: int = ...

class plMatrix33Controller(plLeafController):
    ...

class plMatrix44Controller(plLeafController):
    ...

class plMatrixBlend(plMatrixChannel):
    ...

class plMatrixChannel(plAGChannel):
    affine: hsAffineParts = ...

class plMatrixChannelApplicator(plAGApplicator):
    ...

class plMatrixConstant(plMatrixChannel):
    ...

class plMatrixControllerCacheChannel(plMatrixChannel):
    ...

class plMatrixControllerChannel(plMatrixChannel):
    controller: Optional[plController] = ...

class plMatrixDelayedCorrectionApplicator(plMatrixChannelApplicator):
    ...

class plMatrixDifferenceApp(plMatrixChannelApplicator):
    ...

class plMatrixTimeScale(plMatrixChannel):
    ...

class plMessage(plCreatable):
    kBCastByExactType: int = ...
    kBCastByType: int = ...
    kBCastNone: int = ...
    kCCRSendToAllPlayers: int = ...
    kClearAfterBCast: int = ...
    kLocalPropagate: int = ...
    kMsgWatch: int = ...
    kNetAllowInterAge: int = ...
    kNetCreatedRemotely: int = ...
    kNetForce: int = ...
    kNetNonDeterministic: int = ...
    kNetNonLocal: int = ...
    kNetPropagate: int = ...
    kNetSendUnreliable: int = ...
    kNetSent: int = ...
    kNetStartCascade: int = ...
    kNetUseRelevanceRegions: int = ...
    kPropagateToChildren: int = ...
    kPropagateToModifiers: int = ...

    BCastFlags: int = ...
    receivers: Sequence[plKey] = ...
    sender: Optional[plKey] = ...
    timeStamp: float = ...

    def addReceiver(self, receiver: plKey) -> None: ...
    def clearReceivers(self) -> None: ...
    def delReceiver(self, idx: int) -> None: ...

class plMessageWithCallbacks(plMessage):
    callbacks: Sequence[plMessage] = ...

    def addCallback(self, msg: plMessage) -> None: ...
    def clearCallbacks(self) -> None: ...
    def delCallback(self, idx: int) -> None: ...

class plMipmap(plBitmap):
    kBlockQualityNormal: int = ...
    kBlockQualityHigh: int = ...
    kBlockQualityUltra: int = ...

    height: int = ...
    imageData: bytes = ...
    jpegAlpha: bytes = ...
    jpegImage: bytes = ...
    numLevels: int = ...
    width: int = ...

    @overload
    def __init__(self, name: str, width: int, height: int, numLevels: int, compType: int, format: int, dxtLevel: int = plBitmap.kDXTError) -> None: ...
    @overload
    def __init__(self, name: str = "") -> None: ...

    def CompressImage(self, level: int, data: bytes, quality: int = kBlockQualityNormal) -> None: ...
    def CompressJPEG(self, quality: int = 70, force: bool = False) -> None: ...
    def DecompressImage(self, level: int) -> bytes: ...
    def extractAlphaData(self) -> bytes: ...
    def extractColorData(self) -> bytes: ...
    def getLevel(self, level: int) -> bytes: ...
    def getLevelHeight(self, level: int) -> int: ...
    def getLevelWidth(self, level: int) -> int: ...
    def isAlphaJPEG(self) -> bool: ...
    def isImageJPEG(self) -> bool: ...
    def readData(self, stream: hsStream) -> None: ...
    def setAlphaData(self, data: bytes) -> None: ...
    def setAlphaJPEG(self, data: bytes) -> None: ...
    def setColorData(self, data: bytes) -> None: ...
    def setImageJPEG(self, data: bytes) -> None: ...
    def setLevel(self, level: int, data: bytes) -> None: ...
    def setRawImage(self, data: bytes) -> None: ...
    def writeData(self, stream: hsStream) -> None: ...

class plMobileOccluder(plOccluder):
    localBounds: hsBounds3Ext = ...
    localToWorld: hsMatrix44 = ...
    worldToLocal: hsMatrix44 = ...

class plModifier(plSynchedObject):
    targets: Sequence[plKey[plSceneObject]] = ...

    def addTarget(self, key: plKey[plSceneObject]) -> None: ...
    def removeTarget(self, key: plKey[plSceneObject]) -> None: ...

class plMsgForwarder(hsKeyedObject):
    forwardKeys: Sequence[plKey] = ...

    def addForwardKey(self, key: plKey) -> None: ...
    def clearForwardKeys(self) -> None: ...
    def delForwardKey(self, idx: int) -> None: ...

class plMultiModifier(plModifier):
    def getFlag(self, flag: int) -> bool: ...
    def setFlag(self, flag: int, value: bool) -> None: ...

class plMultistageBehMod(plSingleModifier):
    freezePhys: bool = ...
    receivers: Sequence[plKey] = ...
    reverseFBControlsOnRelease: bool = ...
    smartSeek: bool = ...
    stages: Sequence[plAnimStage] = ...

    def addReceiver(self, receiver: plKey) -> None: ...
    def addStage(self, stage: plAnimStage) -> None: ...
    def clearReceivers(self) -> None: ...
    def clearStages(self) -> None: ...
    def delReceiver(self, idx: int) -> None: ...
    def delStage(self, idx: int) -> None: ...

class plNotifyMsg(plMessage):
    kActivator: int = ...
    kNotifySelf: int = ...
    kResponderChangeState: int = ...
    kResponderFF: int = ...
    kVarNotification: int = ...

    events: Sequence[proEventData] = ...
    id: int = ...
    state: float = ...
    type: int = ...

    def addEvent(self, event: proEventData) -> None: ...
    def clearEvents(self) -> None: ...
    def delEvent(self, idx: int) -> None: ...

class plORConditionalObject(plConditionalObject):
    children: Sequence[plKey[plConditionalObject]] = ...

    def addChild(self, child: plKey[plConditionalObject]) -> None: ...
    def clearChildren(self) -> None: ...
    def delChild(self, idx: int) -> None: ...

class plObjInterface(plSynchedObject):
    kDisable: Any = ...

    owner: Optional[plKey[plSceneObject]] = ...

    def getProperty(self, flag: int) -> bool: ...
    def setProperty(self, flag: int, value: bool) -> None: ...

class plObjectInBoxConditionalObject(plConditionalObject):
    ...

class plObjectInVolumeAndFacingDetector(plObjectInVolumeDetector):
    facingTolerance: float = ...
    needWalkingForward: bool = ...

class plObjectInVolumeDetector(plCollisionDetector):
    ...

class plObjectIntersectPlaneConditionalObject(plConditionalObject):
    ...

class plOccluder(plObjInterface):
    polys: Sequence[plCullPoly] = ...
    priority: float = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    visRegions: Sequence[plKey[plVisRegion]] = ...
    worldBounds: hsBounds = ...

    def addPoly(self, poly: plCullPoly) -> None: ...
    def addVisRegion(self, region: plKey[plVisRegion]) -> None: ...
    def clearPolys(self) -> None: ...
    def clearVisRegions(self) -> None: ...
    def delPoly(self, idx: int) -> None: ...
    def delVisRegion(self, idx: int) -> None: ...

class plOmniApplicator(plAGApplicator):
    ...

class plOmniCutoffApplicator(plAGApplicator):
    ...

class plOmniLightInfo(plLightInfo):
    attenConst: float = ...
    attenCutoff: float = ...
    attenLinear: float = ...
    attenQuadratic: float = ...

class plOmniSqApplicator(plAGApplicator):
    ...

class plOneShotMod(plMultiModifier):
    animName: str = ...
    drivable: bool = ...
    noSeek: bool = ...
    reversable: bool = ...
    seekDuration: float = ...
    smartSeek: bool = ...

class plOneShotMsg(plResponderMsg):
    callbacks: Sequence[Tuple[str, plKey, int]] = ...

    def addCallback(self, marker: str, key: plKey, user: int) -> None: ...
    def clearCallbacks(self) -> None: ...
    def delCallback(self, idx: int) -> None: ...

class plOneTimeParticleGenerator(plParticleGenerator):
    XSize: float = ...
    YSize: float = ...
    direction: Sequence[hsVector3] = ...
    partRadsPerSecRange: float = ...
    position: Sequence[hsVector3] = ...
    scaleMax: float = ...
    scaleMin: float = ...

class plPageInfo:
    kBasicChecksum: int = ...
    kChecksumMask: int = ...
    kOldDataChecksum: int = ...
    kOldIdxChecksum: int = ...
    kPartialPatchFile: int = ...
    kPatchFlags: int = ...
    kPatchHeaderOnly: int = ...

    age: str = ...
    chapter: str = ...
    flags: int = ...
    location: plLocation = ...
    page: str = ...
    releaseVersion: int = ...

    def getFilename(self, version: int) -> str: ...
    def isValid(self) -> bool: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...
    def writeSums(self, stream: hsStream) -> None: ...

class plPanicLinkRegion(plCollisionDetector):
    playLinkOutAnim: bool = ...


class plParticleAngleApplicator(plParticleApplicator):
    ...

class plParticleApplicator(plAGApplicator):
    ...

class plParticleCollisionEffect(plParticleEffect):
    sceneObj: Optional[plKey[plSceneObject]] = ...

class plParticleCollisionEffectBeat(plParticleCollisionEffect):
    ...

class plParticleCollisionEffectBounce(plParticleCollisionEffect):
    bounce: float = ...
    friction: float = ...

class plParticleCollisionEffectDie(plParticleCollisionEffect):
    ...

class plParticleEffect(hsKeyedObject):
    ...

class plParticleEmitter(plCreatable):
    kBorrowedGenerator: int = ...
    kMatIsEmissive: int = ...
    kNeedsUpdate: int = ...
    kNormalDynamicMask: int = ...
    kNormalFromCenter: int = ...
    kNormalNearestLight: int = ...
    kNormalPrecalcMask: int = ...
    kNormalUp: int = ...
    kNormalVelUpVel: int = ...
    kNormalViewFacing: int = ...
    kOnReserve: int = ...
    kOrientationMask: int = ...
    kOrientationUp: int = ...
    kOrientationVelocityBased: int = ...
    kOrientationVelocityFlow: int = ...
    kOrientationVelocityMask: int = ...
    kOrientationVelocityStretch: int = ...
    kOverrideLocalToWorld: int = ...

    color: hsColorRGBA = ...
    generator: Optional[plParticleGenerator] = ...
    maxParticles: int = ...
    miscFlags: int = ...
    spanIndex: int = ...

class plParticleFadeOutEffect(plParticleEffect):
    ignoreZ: float = ...
    length: float = ...

class plParticleFadeVolumeEffect(plParticleEffect):
    ignoreZ: float = ...
    length: float = ...

class plParticleFlockEffect(plParticleEffect):
    avgVelStr: float = ...
    dissenterTarget: hsVector3 = ...
    fullChaseDistSq: float = ...
    goalChaseStr: float = ...
    goalDistSq: float = ...
    goalOrbitStr: float = ...
    infAvgRadSq: float = ...
    infRepRadSq: float = ...
    maxChaseSpeed: float = ...
    maxOrbitSpeed: float = ...
    maxParticles: float = ...
    repDirStr: float = ...
    targetOffset: hsVector3 = ...

class plParticleFollowSystemEffect(plParticleEffect):
    ...

class plParticleGenerator(plCreatable):
    ...

class plParticleLifeMaxApplicator(plParticleApplicator):
    ...

class plParticleLifeMinApplicator(plParticleApplicator):
    ...

class plParticleLocalWind(plParticleWindEffect):
    scale: hsVector3 = ...
    speed: float = ...

class plParticlePPSApplicator(plParticleApplicator):
    ...

class plParticleScaleMaxApplicator(plParticleApplicator):
    ...

class plParticleScaleMinApplicator(plParticleApplicator):
    ...

class plParticleSpan(plIcicle):
    ...

class plParticleSystem(plModifier):
    kEffectConstraint: int = ...
    kEffectForce: int = ...
    kEffectMisc: int = ...
    kParticleSystemAlwaysUpdate: int = ...

    XTiles: int = ...
    YTiles: int = ...
    accel: hsVector3 = ...
    ambientCtl: Optional[plController] = ...
    constraints: Sequence[plKey[plParticleEffect]] = ...
    diffuseCtl: Optional[plController] = ...
    drag: float = ...
    effects: Sequence[plKey[plParticleEffect]] = ...
    forces: Sequence[plKey[plParticleEffect]] = ...
    heightCtl: Optional[plController] = ...
    material: Optional[plKey[hsGMaterial]] = ...
    maxEmitters: int = ...
    maxTotalParticles: int = ...
    numValidEmitters: int = ...
    opacityCtl: Optional[plController] = ...
    permaLights: Sequence[plKey[plLightInfo]] = ...
    preSim: float = ...
    widthCtl: Optional[plController] = ...
    windMult: float = ...

    def addConstraint(self, constraint: plKey[plParticleEffect]) -> None: ...
    def addEffect(self, effect: plKey[plParticleEffect]) -> None: ...
    def addEmitter(self, emitter: plParticleEmitter) -> None: ...
    def addForce(self, force: plKey[plParticleEffect]) -> None: ...
    def addPermaLight(self, light: plKey[plLightInfo]) -> None: ...
    def allocEmitters(self, count: int) -> None: ...
    def clearConstraints(self) -> None: ...
    def clearEffects(self) -> None: ...
    def clearEmitters(self) -> None: ...
    def clearForces(self) -> None: ...
    def clearPermaLights(self) -> None: ...
    def delConstraint(self, idx: int) -> None: ...
    def delEffect(self, idx: int) -> None: ...
    def delEmitter(self, idx: int) -> None: ...
    def delForce(self, idx: int) -> None: ...
    def delPermaLight(self, idx: int) -> None: ...
    def getEmitter(self, idx: int) -> Optional[plParticleEmitter]: ...
    def setEmitter(self, idx: int, emitter: plParticleEmitter) -> None: ...

class plParticleUniformWind(plParticleWindEffect):
    freqMax: float = ...
    freqMin: float = ...
    freqRate: float = ...

class plParticleVelMaxApplicator(plParticleApplicator):
    ...

class plParticleVelMinApplicator(plParticleApplicator):
    ...

class plParticleWindEffect(plParticleEffect):
    constancy: float = ...
    dir: hsVector3 = ...
    horizontal: bool = ...
    refDir: hsVector3 = ...
    strength: float = ...
    swirl: float = ...

class plPhysical(plSynchedObject):
    ...

class plPhysicalSndGroup(hsKeyedObject):
    kBone: int = ...
    kCone: int = ...
    kDirt: int = ...
    kGrass: int = ...
    kMetal: int = ...
    kNone: int = ...
    kRug: int = ...
    kStone: int = ...
    kUser1: int = ...
    kUser2: int = ...
    kUser3: int = ...
    kWater: int = ...
    kWood: int = ...

    group: int = ...
    impactSounds: Sequence[plKey] = ...
    slideSounds: Sequence[plKey] = ...

    def addImpactSound(self, sound: plKey) -> None: ...
    def addSlideSound(self, sound: plKey) -> None: ...
    def clearImpactSounds(self) -> None: ...
    def clearSlideSounds(self) -> None: ...
    def delImpactSound(self, idx: int) -> None: ...
    def delSlideSound(self, idx: int) -> None: ...

class plPickingDetector(plDetectorModifier):
    ...

class plPNG:
    @staticmethod
    def DecompressPNG(stream: hsStream) -> plMipmap:
        ...

class plPoint3Controller(plLeafController):
    ...

class plPointBlend(plPointChannel):
    ...

class plPointChannel(plAGChannel):
    ...

class plPointChannelApplicator(plAGApplicator):
    ...

class plPointConstant(plPointChannel):
    ...

class plPointControllerCacheChannel(plPointChannel):
    ...

class plPointControllerChannel(plPointChannel):
    controller: Optional[plController] = ...

class plPointShadowMaster(plShadowMaster):
    ...

class plPointTimeScale(plPointChannel):
    ...

class plPosController(plController):
    kCompound: int = ...
    kSimple: int = ...

    type: int = ...

class plPostEffectMod(plSingleModifier):
    defaultC2W: hsMatrix44 = ...
    defaultW2C: hsMatrix44 = ...
    fovX: float = ...
    fovY: float = ...
    hither: float = ...
    nodeKey: Optional[plKey[plSceneNode]] = ...
    yon: float = ...

class plPrintShape(plObjInterface):
    height: float = ...
    length: float = ...
    width: float = ...

class plPythonFileMod(plMultiModifier):
    filename: Union[PathLike, str] = ...
    parameters: Sequence[plPythonParameter] = ...
    receivers: Sequence[plKey] = ...

    def addParameter(self, parameter: plPythonParameter) -> None: ...
    def addReceiver(self, receiver: plKey) -> None: ...
    def clearParameters(self) -> None: ...
    def clearReceivers(self) -> None: ...

class plPythonParameter:
    kActivator: int = ...
    kAnimation: int = ...
    kAnimationName: int = ...
    kBehavior: int = ...
    kBlowerComponent: int = ...
    kBoolean: int = ...
    kClusterComponent: int = ...
    kDynamicText: int = ...
    kExcludeRegion: int = ...
    kFloat: int = ...
    kGUIDialog: int = ...
    kGUIPopUpMenu: int = ...
    kGUISkin: int = ...
    kGlobalSDLVar: int = ...
    kGrassShaderComponent: int = ...
    kInt: int = ...
    kMaterial: int = ...
    kMaterialAnimation: int = ...
    kNone: int = ...
    kResponder: int = ...
    kSceneObject: int = ...
    kSceneObjectList: int = ...
    kString: int = ...
    kSubtitle: int = ...
    kSwimCurrentInterface: int = ...
    kWaterComponent: int = ...

    id: int = ...
    value: Union[bool, int, float, plKey, None, str] = ...
    valueType: int = ...

    def read(self, stream: hsStream, mgr: plResManager) -> None: ...
    def write(self, stream: hsStream, mgr: plResManager) -> None: ...

class plQuatBlend(plQuatChannel):
    ...

class plQuatChannel(plAGChannel):
    result: hsQuat = ...

class plQuatChannelApplicator(plAGApplicator):
    ...

class plQuatConstant(plQuatChannel):
    ...

class plQuatController(plLeafController):
    ...

class plQuatPointCombine(plMatrixChannel):
    ...

class plQuatTimeScale(plQuatChannel):
    ...

class plRailCameraMod(plLineFollowMod):
    ...

class plRandomCommandMod(plSingleModifier):
    kCoverall: int = ...
    kDelayFromEnd: int = ...
    kNoRepeats: int = ...
    kNormal: int = ...
    kOneCmd: int = ...
    kOneCycle: int = ...
    kSequential: int = ...
    kStopped: int = ...

    maxDelay: float = ...
    minDelay: float = ...
    mode: int = ...
    state: int = ...

class plRandomSoundMod(plRandomCommandMod):
    groups: Sequence[plRandomSoundModGroup] = ...

    def addGroup(self, group: plRandomSoundModGroup) -> None: ...
    def clearGroups(self) -> None: ...
    def delGroup(self, idx: int) -> None: ...

class plRandomSoundModGroup:
    indices: Sequence[int] = ...

    def addIndex(self, index: int) -> None: ...
    def clearIndices(self) -> None: ...
    def delIndex(self, idx: int) -> None: ...

class plRelativeMatrixChannelApplicator(plAGApplicator):
    ...

class plRenderLevel:
    kAvatarRendMinorLevel: int = ...
    kBlendRendMajorLevel: int = ...
    kDefRendMajorLevel: int = ...
    kDefRendMinorLevel: int = ...
    kFBMajorLevel: int = ...
    kLateRendMajorLevel: int = ...
    kMajorShift: int = ...
    kMinorLevelMask: int = ...
    kOpaqueMajorLevel: int = ...
    kOpaqueMinorLevel: int = ...

class plRenderTarget(plBitmap):
    ZDepth: int = ...
    height: int = ...
    proportionalViewport: bool = ...
    stencilDepth: int = ...
    viewportBottom: Union[float, int] = ...
    viewportLeft: Union[float, int] = ...
    viewportRight: Union[float, int] = ...
    viewportTop: Union[float, int] = ...
    width: int = ...

class plResManager:
    preserveObjIDs: bool = ...

    def __init__(self, version: int = pvUnknown, preserveObjIDs: bool = False) -> None: ...
    def AddAge(self, age: plAgeInfo) -> None: ...
    def AddObject(self, location: plLocation, object: hsKeyedObject) -> None: ...
    def AddPage(self, page: plPageInfo) -> None: ...
    def ChangeLocation(self, locFrom: plLocation, locTo: plLocation) -> None: ...
    def DelAge(self, age: str) -> None: ...
    def DelObject(self, key: plKey) -> None: ...
    def DelPage(self, location: plLocation) -> None: ...
    def FindAge(self, age: str) -> plAgeInfo: ...
    def FindPage(self, location: plLocation) -> Optional[plPageInfo]: ...
    def ReadAge(self, filename: Union[PathLike, str], readPages: bool) -> plAgeInfo: ...
    def ReadCreatable(self, stream: hsStream) -> Optional[plCreatable]: ...
    def ReadCreatableStub(self, stream: hsStream) -> Optional[plCreatable]: ...
    @overload
    def ReadPage(self, filename: Union[PathLike, str], stub: bool = False) -> plPageInfo: ...
    @overload
    def ReadPage(self, prxStream: hsStream, prmStream: Optional[hsStream] = None, stub: bool = False) -> plPageInfo: ...
    def UnloadAge(self, age: str) -> None: ...
    def UnloadPage(self, location: plLocation) -> None: ...
    def WriteAge(self, filename: Union[PathLike, str], age: plAgeInfo) -> None: ...
    def WriteCreatable(self, stream: hsStream, obj: Optional[plCreatable]) -> None: ...
    def WritePage(self, stream: Union[PathLike, str, hsStream], page: plPageInfo) -> None: ...
    def countKeys(self, location: plLocation) -> int: ...
    def getKeys(self, location: plLocation, type: int, checkKeys: bool = False) -> Sequence[plKey]: ...
    def getLocations(self) -> Sequence[plLocation]: ...
    def getObject(self, key: plKey[KeyedT]) -> KeyedT: ...
    def getSceneNode(self, location: plLocation) -> Optional[plSceneNode]: ...
    def getTypes(self, location: plLocation) -> Sequence[int]: ...
    def getVer(self) -> int: ...
    def optimizeKeys(self, location: plLocation) -> None: ...
    def readKey(self, stream: hsStream) -> plKey: ...
    def readUoid(self, stream: hsStream) -> plKey: ...
    def setVer(self, version: int, force: bool = False) -> None: ...
    def writeKey(self, stream: hsStream, key: plKey) -> None: ...
    def writeUoid(self, stream: hsStream, key: plKey) -> None: ...

class plResponderEnableMsg(plMessage):
    enable: bool = ...

class plResponderModifier(plSingleModifier):
    kDetectTrigger: Any = ...
    kDetectUnTrigger: Any = ...
    kSkipFFSound: Any = ...

    curState: int = ...
    enabled: bool = ...
    flags: int = ...
    states: Sequence[plResponderModifier_State] = ...

    def addState(self, state: plResponderModifier_State) -> None: ...
    def clearStates(self) -> None: ...
    def delState(self, idx: int) -> None: ...

class plResponderModifier_Cmd:
    msg: Optional[plMessage]  = ...
    waitOn: int = ...

    def __init__(self, msg: Optional[plMessage] = None, waitOn: int = -1) -> None: ...

class plResponderModifier_State:
    commands: Sequence[plResponderModifier_Cmd] = ...
    numCallbacks: int = ...
    switchToState: int = ...
    waitToCmd: Dict[int, int] = ...

    def addCommand(self, msg: plMessage, waitOn: int) -> Any: ...
    def clearCommands(self) -> Any: ...
    def delCommand(self, idx: int) -> Any: ...

class plResponderMsg(plMessage):
    ...

class plRideAnimatedPhysMsg(plMessage):
    entering: bool = ...
    region: Optional[plKey] = ...

class plRidingAnimatedPhysicalDetector(plSimpleRegionSensor):
    ...

class plRotController(plController):
    kCompound: int = ...
    kSimple: int = ...
    type: int = ...

class plSDLMgr:
    descriptorNames: Sequence[str] = ...

    def clearDescriptors(self) -> None: ...
    def getDescriptor(self, name: str, version: int = -1) -> plStateDescriptor: ...
    def readDescriptors(self, stream: Union[PathLike, str, hsStream]) -> None: ...

class plScalarBlend(plScalarChannel):
    ...

class plScalarChannel(plAGChannel):
    result: float = ...

class plScalarChannelApplicator(plAGApplicator):
    ...

class plScalarConstant(plScalarChannel):
    ...

class plScalarController(plLeafController):
    ...

class plScalarControllerCacheChannel(plScalarChannel):
    ...

class plScalarControllerChannel(plScalarChannel):
    controller: Optional[plController] = ...

class plScalarSDLChannel(plScalarChannel):
    ...

class plScalarTimeScale(plScalarChannel):
    ...

class plScaleController(plController):
    kSimple: int = ...
    type: int = ...

class plScaleValueController(plLeafController):
    ...

class plSceneNode(hsKeyedObject):
    poolObjects: Sequence[plKey] = ...
    sceneObjects: Sequence[plKey[plSceneObject]] = ...

    def addPoolObject(self, key: plKey) -> None: ...
    def addPoolObjects(self, keys: Sequence[plKey]) -> None: ...
    def addSceneObject(self, key: plKey[plSceneObject]) -> None: ...
    def addSceneObjects(self, keys: Sequence[plKey[plSceneObject]]) -> None: ...
    def clear(self) -> None: ...
    def delPoolObject(self, idx: int) -> None: ...
    def delSceneObject(self, idx: int) -> None: ...

class plSceneObject(plSynchedObject):
    audio: Optional[plKey[plAudioInterface]] = ...
    coord: Optional[plKey[plCoordinateInterface]] = ...
    draw: Optional[plKey[plDrawInterface]] = ...
    interfaces: Sequence[plKey[plObjInterface]] = ...
    modifiers: Sequence[plKey[plModifier]] = ...
    sceneNode: Optional[plKey[plSceneNode]] = ...
    sim: Optional[plKey[plSimulationInterface]] = ...

    def addInterface(self, interface: plKey[plObjInterface]) -> None: ...
    def addModifier(self, modifier: plKey[plModifier]) -> None: ...
    def clearInterfaces(self) -> None: ...
    def clearModifiers(self) -> None: ...
    def delInterface(self, idx: int) -> None: ...
    def delModifier(self, idx: int) -> None: ...

class plSeekPointMod(plMultiModifier):
    name: str = ...

class plServerGuid:
    def __init__(self, guid: Optional[str] = None) -> None: ...
    def __eq__(self, other: plServerGuid) -> bool: ...
    def __ge__(self, other: plServerGuid) -> bool: ...
    def __getitem__(self, index: int) -> int: ...
    def __gt__(self, other: plServerGuid) -> bool: ...
    def __le__(self, other: plServerGuid) -> bool: ...
    def __len__(self) -> bool: ...
    def __lt__(self, other: plServerGuid) -> bool: ...
    def __ne__(self, other: plServerGuid) -> bool: ...
    def __setitem__(self, index: int, object: int) -> None: ...

class plShader(hsKeyedObject):
    kNumShaders: int = ...
    kUnregistered: int = ...
    ps_BiasNormals: int = ...
    ps_CaddAAdd: int = ...
    ps_CaddAMult: int = ...
    ps_CaddAbase: int = ...
    ps_CalphaAMult: int = ...
    ps_CalphaAadd: int = ...
    ps_CalphaAbase: int = ...
    ps_CbaseAbase: int = ...
    ps_CmultAAdd: int = ...
    ps_CmultAMult: int = ...
    ps_CmultAbase: int = ...
    ps_CompCosines: int = ...
    ps_GrassShader: int = ...
    ps_MoreCosines: int = ...
    ps_ShoreLeave6: int = ...
    ps_WaveDecEnv: int = ...
    ps_WaveFixed: int = ...
    ps_WaveGraph: int = ...
    ps_WaveGrid: int = ...
    ps_WaveRip: int = ...
    vs_BiasNormals: int = ...
    vs_CompCosines: int = ...
    vs_GrassShader: int = ...
    vs_ShoreLeave6: int = ...
    vs_ShoreLeave7: int = ...
    vs_WaveDec1Lay: int = ...
    vs_WaveDec1Lay_7: int = ...
    vs_WaveDec2Lay11: int = ...
    vs_WaveDec2Lay11_7: int = ...
    vs_WaveDec2Lay12: int = ...
    vs_WaveDec2Lay12_7: int = ...
    vs_WaveDecEnv: int = ...
    vs_WaveDecEnv_7: int = ...
    vs_WaveFixedFin6: int = ...
    vs_WaveFixedFin7: int = ...
    vs_WaveGraph2: int = ...
    vs_WaveGridFin: int = ...
    vs_WaveRip: int = ...
    vs_WaveRip7: int = ...

    constants: Sequence[plShaderConst] = ...
    id: int = ...
    input: int = ...
    output: int = ...

class plShaderConst:
    W: float = ...
    X: float = ...
    Y: float = ...
    Z: float = ...
    alpha: float = ...
    blue: float = ...
    green: float = ...
    red: float = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None: ...
    def read(self, stream: hsStream) -> Any: ...
    def write(self, stream: hsStream) -> Any: ...
    def __getitem__(self, index: int) -> float: ...
    def __setitem__(self, index: int, object: float) -> None: ...

class plShadowCaster(plMultiModifier):
    kLimitRes: int = ...
    kNone: int = ...
    kPerspective: int = ...
    kSelfShadow: int = ...

    attenScale: float = ...
    blurScale: float = ...
    boost: float = ...
    castFlags: int = ...
    maxOpacity: float = ...

class plShadowMaster(plObjInterface):
    kDisable: int = ...
    kNumProps: int = ...
    kSelfShadow: int = ...

    attenDist: float = ...
    maxDist: float = ...
    maxSize: int = ...
    minDist: float = ...
    minSize: int = ...
    power: float = ...

class plSharedMesh(hsKeyedObject):
    kDontSaveMorphState: int = ...
    kLayer0GlobalToMod: int = ...

    flags: int = ...
    morphSet: Optional[plKey] = ...
    spans: Sequence[plGeometrySpan] = ...

    def addSpan(self, span: plGeometrySpan) -> None: ...
    def clearSpans(self) -> None: ...
    def delSpan(self, idx: int) -> None: ...

class plSimDefs:
    kBoxBounds: int = ...
    kCylinderBounds: int = ...
    kExplicitBounds: int = ...
    kGroupAvatar: int = ...
    kGroupDetector: int = ...
    kGroupDynamic: int = ...
    kGroupLOSOnly: int = ...
    kGroupStatic: int = ...
    kHullBounds: int = ...
    kLOSDBAvatarWalkable: int = ...
    kLOSDBCameraBlockers: int = ...
    kLOSDBCustom: int = ...
    kLOSDBLocalAvatar: int = ...
    kLOSDBNone: int = ...
    kLOSDBShootableItems: int = ...
    kLOSDBSwimRegion: int = ...
    kLOSDBUIBlockers: int = ...
    kLOSDBUIItems: int = ...
    kProxyBounds: int = ...
    kSphereBounds: int = ...

class plSimSuppressMsg(plSimulationMsg):
    suppress: bool = ...

class plSimpleParticleGenerator(plParticleGenerator):
    XSize: float = ...
    YSize: float = ...
    angleRange: float = ...
    genLife: float = ...
    initPitch: Sequence[float] = ...
    initPos: Sequence[hsVector3] = ...
    initYaw: Sequence[float] = ...
    partLifeMax: float = ...
    partLifeMin: float = ...
    partMassRange: float = ...
    partRadsPerSecRange: float = ...
    particlesPerSecond: float = ...
    scaleMax: float = ...
    scaleMin: float = ...
    velMax: float = ...
    velMin: float = ...

class plSimplePosController(plPosController):
    position: Optional[plPoint3Controller] = ...

class plSimpleRegionSensor(plSingleModifier):
    enterMsg: Optional[plMessage] = ...
    exitMsg: Optional[plMessage] = ...

class plSimpleRotController(plRotController):
    rot: Optional[plQuatController] = ...

class plSimpleScaleController(plScaleController):
    value: Optional[plScaleValueController] = ...

class plSimulationInterface(plObjInterface):
    kAvAnimPushable: int = ...
    kCameraAvoidObject: int = ...
    kNoOwnershipChange: int = ...
    kNoSynchronize: int = ...
    kPassive: int = ...
    kPhysAnim: int = ...
    kPinned: int = ...
    kRotationForces: int = ...
    kStartInactive: int = ...
    kSuppressed: int = ...
    kUpright: int = ...
    kWarp: int = ...
    kWeightless: int = ...

    physical: Optional[plKey[plPhysical]] = ...

class plSimulationMsg(plMessage):
    ...

class plSingleModifier(plModifier):
    target: Optional[plKey[plSceneObject]] = ...

    def getFlag(self, flag: int) -> bool: ...
    def setFlag(self, flag: int, value: bool) -> None: ...

class plSittingModifier(plSingleModifier):
    kApproachFront: int = ...
    kApproachLeft: int = ...
    kApproachMask: int = ...
    kApproachRear: int = ...
    kApproachRight: int = ...
    kDisableForward: int = ...

    miscFlags: int = ...
    notifyKeys: Sequence[plKey] = ...

    def addNotifyKey(self, notify: plKey) -> None: ...
    def clearNotifyKeys(self) -> None: ...
    def delNotifyKey(self, idx: int) -> None: ...

class plSoftVolume(plObjInterface):
    kListenCheck: int = ...
    kListenDirty: int = ...
    kListenNone: int = ...
    kListenPosSet: int = ...
    kListenRegistered: int = ...

    insideStrength: float = ...
    listenState: int = ...
    outsideStrength: float = ...

class plSoftVolumeComplex(plSoftVolume):
    subVolumes: Sequence[plKey[plSoftVolume]] = ...

    def addSubVolume(self, subvolume: plKey[plSoftVolume]) -> None: ...
    def clearSubVolumes(self) -> None: ...
    def delSubVolume(self, idx: int) -> None: ...

class plSoftVolumeIntersect(plSoftVolumeComplex):
    ...

class plSoftVolumeInvert(plSoftVolumeComplex):
    ...

class plSoftVolumeSimple(plSoftVolume):
    softDist: float = ...
    volume: Optional[plVolumeIsect] = ...

class plSoftVolumeUnion(plSoftVolumeComplex):
    ...

class plSound(plSynchedObject):
    class plFadeParams:
        currTime: float = ...
        fadeSoftVol: bool = ...
        lengthInSecs: float = ...
        stopWhenDone: bool = ...
        type: int = ...
        volEnd: float = ...
        volStart: float = ...

    kAmbience: int = ...
    kBackgroundMusic: int = ...
    kGUISound: int = ...
    kNPCVoices: int = ...
    kPropAutoStart: int = ...
    kPropDisableLOD: int = ...
    kPropDontFade: int = ...
    kPropFullyDisabled: int = ...
    kPropIncidental: int = ...
    kPropIs3DSound: int = ...
    kPropLoadOnlyOnCall: int = ...
    kPropLocalOnly: int = ...
    kPropLooping: int = ...
    kSoundFX: int = ...

    currVolume: float = ...
    dataBuffer: Optional[plKey[plSoundBuffer]] = ...
    desiredVolume: float = ...
    eaxSettings: plEAXSourceSettings = ...
    fadeInParams: plFadeParams = ...
    fadeOutParams: plFadeParams = ...
    fadedVolume: float = ...
    innerCone: int = ...
    isPlaying: bool = ...
    maxFalloff: int = ...
    minFalloff: int = ...
    outerCone: int = ...
    outerVol: int = ...
    priority: int = ...
    properties: int = ...
    softOcclusionRegion: Optional[plKey[plSoftVolume]] = ...
    softRegion: Optional[plKey[plSoftVolume]] = ...
    subtitleId: str = ...
    time: float = ...
    type: int = ...

class plSoundBuffer(hsKeyedObject):
    kAlwaysExternal: int = ...
    kIsExternal: int = ...
    kOnlyLeftChannel: int = ...
    kOnlyRightChannel: int = ...
    kStreamCompressed: int = ...

    data: bytes = ...
    dataLength: int = ...
    fileName: Union[PathLike, str] = ...
    flags: int = ...
    header: plWAVHeader = ...

class plSoundMsg(plMessageWithCallbacks):
    kAddCallbacks: int = ...
    kClearTalkIcon: int = ...
    kExponential: int = ...
    kFastForwardPlay: int = ...
    kFastForwardToggle: int = ...
    kGetStatus: int = ...
    kGoToTime: int = ...
    kIsLocalOnly: int = ...
    kLinear: int = ...
    kLogarithmic: int = ...
    kNumCmds: int = ...
    kNumSounds: int = ...
    kPlay: int = ...
    kRemoveCallbacks: int = ...
    kSelectFromGroup: int = ...
    kSetBegin: int = ...
    kSetFadeIn: int = ...
    kSetFadeOut: int = ...
    kSetLooping: int = ...
    kSetTalkIcon: int = ...
    kSetVolume: int = ...
    kStatusReply: int = ...
    kStop: int = ...
    kToggleState: int = ...
    kUnSetLooping: int = ...

    begin: float = ...
    end: float = ...
    fadeType: float = ...
    index: int = ...
    loop: float = ...
    playing: bool = ...
    repeats: int = ...
    speed: float = ...
    time: float = ...
    volume: float = ...

    def getCmd(self, cmd: int) -> bool: ...
    def setCmd(self, cmd: int, value: bool = True) -> None: ...

class plSoundVolumeApplicator(plAGApplicator):
    index: int = ...

class plSpaceTree(plCreatable):
    def addLeaf(self, bounds: hsBounds3Ext) -> int: ...
    def addParent(self, bounds: hsBounds3Ext, leftChild: int, rightChild: int) -> int: ...
    def clear(self) -> None: ...
    def getNode(self, idx: int) -> plSpaceTreeNode: ...
    def getRoot(self) -> plSpaceTreeNode: ...

class plSpaceTreeNode:
    kDirty: int = ...
    kDisabled: int = ...
    kEmpty: int = ...
    kEnabledTemp: int = ...
    kIsLeaf: int = ...
    kNone: int = ...

    bounds: hsBounds3Ext = ...
    flags: int = ...
    parent: int = ...

    def getChildren(self) -> Tuple[int, int]: ...
    def getLeafIndex(self) -> int: ...
    def setChildren(self, left: int, right: int) -> None: ...
    def setLeafIndex(self, idx: int) -> None: ...

class plSpan:
    kIcicleSpan: int = ...
    kLiteMaterial: int = ...
    kLiteProjection: int = ...
    kLiteShadow: int = ...
    kLiteShadowErase: int = ...
    kLiteVtxNonPreshaded: int = ...
    kLiteVtxPreshaded: int = ...
    kNullSpan: int = ...
    kPartialSort: int = ...
    kParticleSet: int = ...
    kParticleSpan: int = ...
    kPropCharacter: int = ...
    kPropDisableNormal: int = ...
    kPropFacesSortable: int = ...
    kPropForceShadow: int = ...
    kPropHasPermaLights: int = ...
    kPropHasPermaProjs: int = ...
    kPropMatHasSpecular: int = ...
    kPropNoDraw: int = ...
    kPropNoShadow: int = ...
    kPropNoShadowCast: int = ...
    kPropProjAsVtx: int = ...
    kPropReverseSort: int = ...
    kPropRunTimeLight: int = ...
    kPropSkipProjection: int = ...
    kPropVolatile: int = ...
    kSpan: int = ...
    kVertexSpan: int = ...
    kVisLOS: int = ...
    kWaterHeight: int = ...

    baseMatrix: int = ...
    fog: Optional[plKey[plFogEnvironment]] = ...
    fogEnvironment: Optional[plKey[plFogEnvironment]] = ...
    localBounds: hsBounds3Ext = ...
    localToWorld: hsMatrix44 = ...
    localUVWChans: int = ...
    materialIdx: int = ...
    maxBoneIdx: int = ...
    maxDist: float = ...
    minDist: float = ...
    numMatrices: int = ...
    penBoneIdx: int = ...
    permaLights: Sequence[plKey[plLightInfo]] = ...
    permaProjs: Sequence[plKey[plLightInfo]] = ...
    props: int = ...
    subType: int = ...
    waterHeight: float = ...
    worldBounds: hsBounds3Ext = ...
    worldToLocal: hsMatrix44 = ...

    def ClassName(self) -> str: ...
    def addPermaLight(self, light: plKey[plLightInfo]) -> None: ...
    def addPermaProj(self, proj: plKey[plLightInfo]) -> None: ...
    def clearPermaLights(self) -> None: ...
    def clearPermaProjs(self) -> None: ...
    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plSpanEncoding:
    kColA8: int = ...
    kColAI88: int = ...
    kColARGB8888: int = ...
    kColI8: int = ...
    kColMask: int = ...
    kColNone: int = ...
    kColRGB888: int = ...
    kPos008: int = ...
    kPos101010: int = ...
    kPos161616: int = ...
    kPos888: int = ...
    kPosMask: int = ...
    kPosNone: int = ...

    code: int = ...
    posScale: float = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plSpanInstance:
    colors: Sequence[int] = ...
    localToWorld: hsMatrix44 = ...
    posDeltas: Sequence[hsVector3] = ...

    def read(self, stream: hsStream, encoding: plSpanEncoding, numVerts: int) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plSpanTemplate:
    format: int = ...
    indices: Sequence[int] = ...
    vertices: Sequence[plSpanTemplateVertex] = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plSpanTemplateVertex:
    UVWs: Sequence[hsVector3] = ...
    color1: int = ...
    color2: int = ...
    normal: hsVector3 = ...
    position: hsVector3 = ...
    weightIdx: int = ...
    weights: Tuple[float, float, float] = ...

class plSpawnModifier(plMultiModifier):
    ...

class plSpawnPointInfo:
    cameraStack: str = ...
    spawnPt: str = ...
    title: str = ...

class plSplineEaseCurve(plATCEaseCurve):
    splineCoef: Tuple[float, float, float, float] = ...

class plSpotInnerApplicator(plAGApplicator):
    ...

class plSpotLightInfo(plOmniLightInfo):
    falloff: float = ...
    spotInner: float = ...
    spotOuter: float = ...

class plSpotOuterApplicator(plAGApplicator):
    ...

class plStateDescriptor:
    name: str = ...
    valid: bool = ...
    variables: Sequence[plVarDescriptor] = ...
    version: int = ...

    def addVariable(self, variable: plVarDescriptor) -> None: ...
    def clearVariables(self) -> None: ...
    def delVariable(self, variable: Union[int, str]) -> None: ...
    def __getitem__(self, index: Union[int, str]) -> plVarDescriptor: ...
    def __len__(self) -> int: ...
    def __setitem__(self, index: Union[int, str], object: plVarDescriptor) -> None: ...

class plStereizer(plSingleModifier):
    kLeftChannel: int = ...
    kHasMaster: int = ...

    ambientDist: float = ...
    transition: float = ...
    sepDist: Tuple[float, float] = ...
    tanAng: float = ...
    initPos: hsVector3 = ...

class plSubWorldMsg(plSimulationMsg):
    worldKey: Optional[plKey] = ...

class plSubworldRegionDetector(plCollisionDetector):
    onExit: bool = ...
    subworld: Optional[plKey] = ...

class plSwimCircularCurrentRegion(plSwimRegionInterface):
    currentObj: Optional[plKey[plSceneObject]] = ...
    pullFarDistSq: float = ...
    pullFarVel: float = ...
    pullNearDistSq: float = ...
    pullNearVel: float = ...
    rotation: float = ...

class plSwimDetector(plSimpleRegionSensor):
    ...

class plSwimMsg(plMessage):
    isEntering: bool = ...
    swimRegion: Optional[plKey] = ...

class plSwimRegionInterface(plObjInterface):
    kDisable: int = ...

    downBuoyancy: float = ...
    maxUpwardVel: float = ...
    upBuoyancy: float = ...

class plSwimStraightCurrentRegion(plSwimRegionInterface):
    currentObj: Optional[plKey[plSceneObject]] = ...
    farDist: float = ...
    farVel: float = ...
    nearDist: float = ...
    nearVel: float = ...

class plSynchedObject(hsKeyedObject):
    kAllStateIsVolatile: int = ...
    kBCastToClients: int = ...
    kDontDirty: int = ...
    kDontPersistOnServer: int = ...
    kDontSynchGameMessages: int = ...
    kExcludeAllPersistentState: int = ...
    kExcludePersistentState: int = ...
    kForceFullSend: int = ...
    kHasConstantNetGroup: int = ...
    kHasVolatileState: int = ...
    kIsAvatarState: int = ...
    kLocalOnly: int = ...
    kNewState: int = ...
    kSendImmediately: int = ...
    kSendReliably: int = ...
    kSkipLocalOwnershipCheck: int = ...
    kUseRelevanceRegions: int = ...

    excludes: Sequence[str] = ...
    synchFlags: int = ...
    volatiles: Sequence[str] = ...

    def setExclude(self, state: str) -> None: ...
    def setVolatile(self, state: str) -> None: ...

class plTMController(plController):
    pos: Optional[plPosController] = ...
    rot: Optional[plRotController] = ...
    scale: Optional[plScaleController] = ...

    def convertToCompoundController(self) -> plCompoundController: ...

class plTimerCallbackMsg(plMessage):
    ID: int = ...
    time: float = ...

class plUnifiedTime:
    secs: float = ...

    def __init__(self, time: float = 0.0) -> None: ...

class plVarDescriptor:
    kAgeTimeElapsed: int = ...
    kAgeTimeOfDay: int = ...
    kBool: int = ...
    kBuffer: int = ...
    kByte: int = ...
    kChar: int = ...
    kCreatable: int = ...
    kDouble: int = ...
    kFloat: int = ...
    kGameTimeElapsed: int = ...
    kInt: int = ...
    kKey: int = ...
    kMatrix44: int = ...
    kNone: int = ...
    kPoint3: int = ...
    kQuaternion: int = ...
    kRGB: int = ...
    kRGB8: int = ...
    kRGBA: int = ...
    kRGBA8: int = ...
    kShort: int = ...
    kStateDescriptor: int = ...
    kString: int = ...
    kTime: int = ...
    kUint: int = ...
    kVector3: int = ...

    alwaysNew: bool = ...
    count: int = ...
    default: str = ...
    display: str = ...
    internal: bool = ...
    name: str = ...
    stateDesc: plStateDescriptor = ...
    stateDescType: str = ...
    type: int = ...
    valid: bool = ...
    variableLength: bool = ...

class plVault:
    kAgeDevicesFolder: int = ...
    kAgeGlobalSDLNode: int = ...
    kAgeInfoNode: int = ...
    kAgeInstanceSDLNode: int = ...
    kAgeJournalsFolder: int = ...
    kAgeMembersFolder: int = ...
    kAgeOwnersFolder: int = ...
    kAgeTypeJournalFolder: int = ...
    kAgesICanVisitFolder: int = ...
    kAgesIOwnFolder: int = ...
    kAllAgeGlobalSDLNodesFolder: int = ...
    kAllPlayersFolder: int = ...
    kAvatarClosetFolder: int = ...
    kAvatarOutfitFolder: int = ...
    kBuddyListFolder: int = ...
    kCCRPlayersFolder: int = ...
    kCanVisitFolder: int = ...
    kChildAgesFolder: int = ...
    kChronicleFolder: int = ...
    kDefaultPermissions: int = ...
    kDeviceInboxFolder: int = ...
    kGameScoresFolder: int = ...
    kGlobalInboxFolder: int = ...
    kGroupRead: int = ...
    kGroupWrite: int = ...
    kHoodMembersFolder: int = ...
    kInboxFolder: int = ...
    kIngoreListFolder: int = ...
    kJPEG: int = ...
    kLastStandardNode: int = ...
    kNodeAdmin: int = ...
    kNodeAge: int = ...
    kNodeAgeInfo: int = ...
    kNodeAgeInfoList: int = ...
    kNodeAgeLink: int = ...
    kNodeCCR: int = ...
    kNodeChronicle: int = ...
    kNodeFolder: int = ...
    kNodeGameServer: int = ...
    kNodeImage: int = ...
    kNodeInvalid: int = ...
    kNodeMarker: int = ...
    kNodeMarkerList: int = ...
    kNodeNumTypes: int = ...
    kNodePlayer: int = ...
    kNodePlayerInfo: int = ...
    kNodePlayerInfoList: int = ...
    kNodeSDL: int = ...
    kNodeSystem: int = ...
    kNodeTextNote: int = ...
    kNodeUNUSED: int = ...
    kNodeVNodeMgrHigh: int = ...
    kNodeVNodeMgrLow: int = ...
    kNodeVaultServer: int = ...
    kNone: int = ...
    kNoteCCRPetition: int = ...
    kNoteDevice: int = ...
    kNoteGeneric: int = ...
    kNoteInvite: int = ...
    kNoteUnVisit: int = ...
    kNoteVisit: int = ...
    kNumNoteTypes: int = ...
    kOtherRead: int = ...
    kOtherWrite: int = ...
    kOwnerRead: int = ...
    kOwnerWrite: int = ...
    kPNG: int = ...
    kPeopleIKnowAboutFolder: int = ...
    kPlayerInfoNode: int = ...
    kPlayerInviteFolder: int = ...
    kPublicAgesFolder: int = ...
    kSubAgesFolder: int = ...
    kSystemNode: int = ...
    kUserDefinedNode: int = ...
    kVaultMgrGlobalDataFolder: int = ...

class plVaultAdminNode(plVaultNode):
    ...

class plVaultAgeInfoListNode(plVaultFolderNode):
    ...

class plVaultAgeInfoNode(plVaultNode):
    ageCzarID: int = ...
    ageDescription: str = ...
    ageFilename: str = ...
    ageID: int = ...
    ageInfoFlags: int = ...
    ageInstanceGuid: plServerGuid = ...
    ageInstanceName: str = ...
    ageLanguage: int = ...
    ageSequenceNumber: int = ...
    isPublic: int = ...

class plVaultAgeLinkNode(plVaultNode):
    spawnPoints: str = ...
    unlocked: int = ...
    volatile: int = ...

class plVaultAgeNode(plVaultNode):
    ageInstanceGuid: plServerGuid = ...

class plVaultChronicleNode(plVaultNode):
    entryName: str = ...
    entryType: int = ...
    entryValue: str = ...

class plVaultFolderNode(plVaultNode):
    folderName: str = ...
    folderType: int = ...

class plVaultGameServerNode(plVaultNode):
    ageFilename: str = ...
    ageInstanceGuid: plServerGuid = ...

class plVaultImageNode(plVaultNode):
    imageData: bytes = ...
    imageTitle: str = ...
    imageType: int = ...

class plVaultMarkerListNode(plVaultNode):
    ageName: str = ...
    authorID: int = ...
    authorName: str = ...
    gameTitle: str = ...
    gameType: int = ...
    roundLength: int = ...

class plVaultMarkerNode(plVaultNode):
    ageName: str = ...
    hSpans: int = ...
    markerPosX: float = ...
    markerPosY: float = ...
    markerPosZ: float = ...
    markerText: str = ...
    torans: int = ...
    vSpans: int = ...

class plVaultNode:
    autoTime: plUnifiedTime = ...
    blob_1: bytes = ...
    blob_2: bytes = ...
    createAgeGuid: plServerGuid = ...
    createAgeName: str = ...
    createAgeTime: plUnifiedTime = ...
    creator: int = ...
    group: int = ...
    guid1: plServerGuid = ...
    guid2: plServerGuid = ...
    int32_1: int = ...
    int32_2: int = ...
    int32_3: int = ...
    int32_4: int = ...
    isValid: bool = ...
    istring64_1: str = ...
    istring64_2: str = ...
    modifyTime: plUnifiedTime = ...
    nodeID: int = ...
    nodeType: int = ...
    permissions: int = ...
    string64_1: str = ...
    string64_2: str = ...
    string64_3: str = ...
    string64_4: str = ...
    string64_5: str = ...
    string64_6: str = ...
    text_1: str = ...
    text_2: str = ...
    uint32_1: int = ...
    uint32_2: int = ...
    uint32_3: int = ...
    uint32_4: int = ...

    def delField(self, field: int) -> None: ...
    def hasField(self, field: int) -> bool: ...

class plVaultPlayerInfoListNode(plVaultFolderNode):
    ...

class plVaultPlayerInfoNode(plVaultNode):
    ageInstGuid: plServerGuid = ...
    ageInstName: str = ...
    online: int = ...
    playerID: int = ...
    playerName: str = ...

class plVaultPlayerNode(plVaultNode):
    accountUuid: str = ...
    avatarShape: str = ...
    disabled: int = ...
    explorer: int = ...
    onlineTime: int = ...
    playerName: str = ...

class plVaultSDLNode(plVaultNode):
    sdlData: bytes = ...
    sdlIdent: int = ...

class plVaultServerNode(plVaultNode):
    ...

class plVaultStore:
    firstNodeID: int = ...
    lastNodeID: int = ...

    @overload
    def Export(self, destination: Union[PathLike, str], encrypt: bool = True) -> None: ...
    @overload
    def Export(self, destination: hsStream) -> None: ...
    def Import(self, source: Union[PathLike, str, hsStream]) -> None: ...
    def addNode(self, node: plVaultNode) -> plVaultNode: ...
    def addRef(self, parent: int, child: int, saver: int = 0) -> None: ...
    def delRef(self, parent: int, child: int) -> None: ...
    def findParents(self, child: int) -> Sequence[plVaultNode]: ...
    def getChildren(self, parent: int) -> Sequence[plVaultNode]: ...
    def __delitem__(self, other: int) -> None: ...
    def __getitem__(self, index: int) -> plVaultNode: ...
    def __setitem__(self, index: int, object: plVaultNode) -> None: ...

class plVaultSystemNode(plVaultNode):
    ccrStatus: int = ...

class plVaultTextNoteNode(plVaultNode):
    noteContents: str = ...
    noteSubType: int = ...
    noteTitle: str = ...
    noteType: int = ...

class plVertexSpan(plSpan):
    VBufferIdx: int = ...
    VLength: int = ...
    VStartIdx: int = ...
    cellIdx: int = ...
    cellOffset: int = ...
    groupIdx: int = ...

class plViewFaceModifier(plSingleModifier):
    kFaceCam: int = ...
    kFaceList: int = ...
    kFaceObj: int = ...
    kFacePlay: int = ...
    kMaxBounds: int = ...
    kOffset: int = ...
    kOffsetLocal: int = ...
    kPivotFace: int = ...
    kPivotFavorY: int = ...
    kPivotTumple: int = ...
    kPivotY: int = ...
    kScale: int = ...

    faceObj: Optional[plKey[plSceneObject]] = ...
    localToParent: hsMatrix44 = ...
    maxBounds: hsBounds3Ext = ...
    offset: hsVector3 = ...
    parentToLocal: hsMatrix44 = ...
    scale: hsVector3 = ...

class plVisRegion(plObjInterface):
    kDisable: int = ...
    kDisableNormal: int = ...
    kIsNot: int = ...
    kReplaceNormal: int = ...

    region: Optional[plKey] = ...
    visMgr: Optional[plKey] = ...

class plVolActivatorConditionalObject(plActivatorConditionalObject):
    ...

class plVolumeIsect(plCreatable):
    ...

class plVolumeSensorConditionalObject(plConditionalObject):
    kTypeEnter: int = ...
    kTypeExit: int = ...

    first: bool = ...
    trigNum: int = ...
    type: int = ...

class plVolumeSensorConditionalObjectNoArbitration(plVolumeSensorConditionalObject):
    ...

class plWAVHeader:
    kPCMFormatTag: int = ...

    avgBytesPerSec: int = ...
    bitsPerSample: int = ...
    blockAlign: int = ...
    formatTag: int = ...
    numChannels: int = ...
    samplesPerSec: int = ...

    def read(self, stream: hsStream) -> None: ...
    def write(self, stream: hsStream) -> None: ...

class plWarpMsg(plMessage):
    kFlushTransform: int = ...
    kZeroVelocity: int = ...

    transform: hsMatrix44 = ...
    warpFlags: int = ...

class plWaveSet7(plWaveSetBase):
    kHasRefObject: int = ...
    kHasBuoys: int = ...

    buoys: Sequence[plKey[plSceneObject]] = ...
    decals: Sequence[plKey[plSceneObject]] = ...
    envMap: Optional[plKey[plDynamicEnvMap]] = ...
    maxLen: float = ...
    refObj: Optional[plKey[plSceneObject]] = ...
    shores: Sequence[plKey[plSceneObject]] = ...
    state: plFixedWaterState7 = ...

    def addBuoy(self, buoy: plKey[plSceneObject]) -> None: ...
    def addDecal(self, decal: plKey[plSceneObject]) -> None: ...
    def addShore(self, shore: plKey[plSceneObject]) -> None: ...
    def clearBuoys(self) -> None: ...
    def clearDecals(self) -> None: ...
    def clearShores(self) -> None: ...
    def delBuoy(self, idx: int) -> None: ...
    def delDecal(self, idx: int) -> None: ...
    def delShore(self, idx: int) -> None: ...

class plWaveSetBase(plMultiModifier):
    ...

class plWin32Sound(plSound):
    kLeftChannel: int = ...
    kRightChannel: int = ...

    channel: int = ...

class plWin32StaticSound(plWin32Sound):
    ...

class plWin32StreamingSound(plWin32Sound):
    ...

class plWinAudible(plAudible):
    sceneNode: Optional[plKey[plSceneNode]] = ...
    sounds: Sequence[plKey[plSound]] = ...

    def addSound(self, sound: plKey[plSound]) -> None: ...
    def clearSounds(self) -> None: ...
    def delSound(self, idx: int) -> None: ...

class proActivateEventData(proEventData):
    activate: bool = ...
    active: bool = ...

class proBookEventData(proEventData):
    event: int = ...
    linkID: int = ...

class proCallbackEventData(proEventData):
    callbackEventType: int = ...

class proClickDragEventData(proEventData):
    ...

class proClimbingBlockerHitEventData(proEventData):
    blocker: Optional[plKey] = ...

class proCollisionEventData(proEventData):
    enter: bool = ...
    hittee: Optional[plKey] = ...
    hitter: Optional[plKey] = ...

class proContainedEventData(proEventData):
    contained: Optional[plKey] = ...
    container: Optional[plKey] = ...
    entering: bool = ...

class proControlKeyEventData(proEventData):
    controlKey: int = ...
    down: bool = ...

class proCoopEventData(proEventData):
    id: int = ...
    serial: int = ...

class proEventData:
    kActivate: int = ...
    kAdvanceNextStage: int = ...
    kBeginningOfLoop: int = ...
    kBook: int = ...
    kCallback: int = ...
    kClickDrag: int = ...
    kClimbingBlockerHit: int = ...
    kCollision: int = ...
    kContained: int = ...
    kControlKey: int = ...
    kCoop: int = ...
    kEnterStage: int = ...
    kFacing: int = ...
    kKey: int = ...
    kMultiStage: int = ...
    kNone: int = ...
    kNothing: int = ...
    kNotta: int = ...
    kNumber: int = ...
    kOfferLinkBook: int = ...
    kPicked: int = ...
    kRegressPrevStage: int = ...
    kResponderState: int = ...
    kSpawned: int = ...
    kVariable: int = ...

    def EventType(self) -> int: ...
    def Read(self, stream: hsStream, mgr: plResManager) -> None: ...
    def write(self, stream: hsStream, mgr: plResManager) -> None: ...

class proFacingEventData(proEventData):
    dot: float = ...
    enabled: bool = ...
    facee: Optional[plKey]= ...
    facer: Optional[plKey] = ...

class proMultiStageEventData(proEventData):
    avatar: Optional[plKey] = ...
    event: int = ...
    stage: int = ...

class proOfferLinkBookEventData(proEventData):
    offeree: int = ...
    offerer: Optional[plKey] = ...
    targetAge: int = ...

class proPickedEventData(proEventData):
    enabled: bool = ...
    hitPoint: hsVector3 = ...
    picked: Optional[plKey] = ...
    picker: Optional[plKey] = ...

class proResponderStateEventData(proEventData):
    state: int = ...

class proSpawnedEventData(proEventData):
    spawnee: Optional[plKey] = ...
    spawner: Optional[plKey] = ...

class proVariableEventData(proEventData):
    dataType: int = ...
    key: Optional[plKey] = ...
    name: str = ...
    number: float = ...
