import { Event } from './Event.mjs';

// https://html.spec.whatwg.org/multipage/webappapis.html#errorevent
class ErrorEvent extends Event {
  constructor(type, eventInitDict) {
    super(type, eventInitDict);
    this.message = eventInitDict.message;
    this.filename = eventInitDict.filename;
    this.lineno = eventInitDict.lineno;
    this.colno = eventInitDict.colno;
    this.error = eventInitDict.error;
  }
}

export { ErrorEvent };
