'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const remoteReceived = require('./hooks/remote-received.cjs');
const node = require('./node.cjs');
const jsxRuntime = require('react/jsx-runtime');

/**
 * A component that can be used to render a tree of UI elements from a remote
 * environment.
 */
function RemoteRootRenderer(props) {
  const {
    receiver
  } = props;
  const {
    children
  } = remoteReceived.useRemoteReceived(receiver.root, receiver);
  return /*#__PURE__*/jsxRuntime.jsx(jsxRuntime.Fragment, {
    children: children.map(child => node.renderRemoteNode(child, props))
  });
}

exports.RemoteRootRenderer = RemoteRootRenderer;
