/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#define GEN_PASS_DECL_BUFFERHOISTINGPASS
#define GEN_PASS_DECL_BUFFERLOOPHOISTINGPASS
#define GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMSPASS
#define GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTSPASS
#define GEN_PASS_DECL_EMPTYTENSORELIMINATIONPASS
#define GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSORPASS
#define GEN_PASS_DECL_LOWERDEALLOCATIONSPASS
#define GEN_PASS_DECL_ONESHOTBUFFERIZEPASS
#define GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESSPASS
#define GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#define GEN_PASS_DECL_PROMOTEBUFFERSTOSTACKPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// BufferDeallocationSimplificationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
std::unique_ptr<::mlir::Pass> createBufferDeallocationSimplificationPass();
#undef GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#endif // GEN_PASS_DECL_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#ifdef GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATIONPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createBufferDeallocationSimplificationPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class BufferDeallocationSimplificationPassBase : public ::mlir::OperationPass<> {
public:
  using Base = BufferDeallocationSimplificationPassBase;

  BufferDeallocationSimplificationPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  BufferDeallocationSimplificationPassBase(const BufferDeallocationSimplificationPassBase &other) : ::mlir::OperationPass<>(other) {}
  BufferDeallocationSimplificationPassBase& operator=(const BufferDeallocationSimplificationPassBase &) = delete;
  BufferDeallocationSimplificationPassBase(BufferDeallocationSimplificationPassBase &&) = delete;
  BufferDeallocationSimplificationPassBase& operator=(BufferDeallocationSimplificationPassBase &&) = delete;
  ~BufferDeallocationSimplificationPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-deallocation-simplification");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-deallocation-simplification"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Optimizes `bufferization.dealloc` operation for more efficient codegen)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferDeallocationSimplificationPass");
  }
  ::llvm::StringRef getName() const override { return "BufferDeallocationSimplificationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferDeallocationSimplificationPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createBufferDeallocationSimplificationPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createBufferDeallocationSimplificationPass() {
  return impl::createBufferDeallocationSimplificationPass();
}
#undef GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#endif // GEN_PASS_DEF_BUFFERDEALLOCATIONSIMPLIFICATIONPASS

//===----------------------------------------------------------------------===//
// BufferHoistingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERHOISTINGPASS
std::unique_ptr<::mlir::Pass> createBufferHoistingPass();
#undef GEN_PASS_DECL_BUFFERHOISTINGPASS
#endif // GEN_PASS_DECL_BUFFERHOISTINGPASS
#ifdef GEN_PASS_DEF_BUFFERHOISTINGPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createBufferHoistingPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class BufferHoistingPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferHoistingPassBase;

  BufferHoistingPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferHoistingPassBase(const BufferHoistingPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferHoistingPassBase& operator=(const BufferHoistingPassBase &) = delete;
  BufferHoistingPassBase(BufferHoistingPassBase &&) = delete;
  BufferHoistingPassBase& operator=(BufferHoistingPassBase &&) = delete;
  ~BufferHoistingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-hoisting"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Optimizes placement of allocation operations by moving them into common dominators and out of nested regions)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferHoistingPass");
  }
  ::llvm::StringRef getName() const override { return "BufferHoistingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferHoistingPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createBufferHoistingPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createBufferHoistingPass() {
  return impl::createBufferHoistingPass();
}
#undef GEN_PASS_DEF_BUFFERHOISTINGPASS
#endif // GEN_PASS_DEF_BUFFERHOISTINGPASS

//===----------------------------------------------------------------------===//
// BufferLoopHoistingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERLOOPHOISTINGPASS
std::unique_ptr<::mlir::Pass> createBufferLoopHoistingPass();
#undef GEN_PASS_DECL_BUFFERLOOPHOISTINGPASS
#endif // GEN_PASS_DECL_BUFFERLOOPHOISTINGPASS
#ifdef GEN_PASS_DEF_BUFFERLOOPHOISTINGPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createBufferLoopHoistingPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class BufferLoopHoistingPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferLoopHoistingPassBase;

  BufferLoopHoistingPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferLoopHoistingPassBase(const BufferLoopHoistingPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  BufferLoopHoistingPassBase& operator=(const BufferLoopHoistingPassBase &) = delete;
  BufferLoopHoistingPassBase(BufferLoopHoistingPassBase &&) = delete;
  BufferLoopHoistingPassBase& operator=(BufferLoopHoistingPassBase &&) = delete;
  ~BufferLoopHoistingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-loop-hoisting");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-loop-hoisting"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Optimizes placement of allocation operations by moving them out of loop nests)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferLoopHoistingPass");
  }
  ::llvm::StringRef getName() const override { return "BufferLoopHoistingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferLoopHoistingPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createBufferLoopHoistingPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createBufferLoopHoistingPass() {
  return impl::createBufferLoopHoistingPass();
}
#undef GEN_PASS_DEF_BUFFERLOOPHOISTINGPASS
#endif // GEN_PASS_DEF_BUFFERLOOPHOISTINGPASS

//===----------------------------------------------------------------------===//
// BufferResultsToOutParamsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMSPASS
struct BufferResultsToOutParamsPassOptions {
  bool addResultAttribute = false;
  bool hoistStaticAllocs = false;
  bool hoistDynamicAllocs = false;
  bool modifyPublicFunctions = false;
};
std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass();
std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass(BufferResultsToOutParamsPassOptions options);
#undef GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMSPASS
#endif // GEN_PASS_DECL_BUFFERRESULTSTOOUTPARAMSPASS
#ifdef GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass(BufferResultsToOutParamsPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class BufferResultsToOutParamsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = BufferResultsToOutParamsPassBase;

  BufferResultsToOutParamsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferResultsToOutParamsPassBase(const BufferResultsToOutParamsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  BufferResultsToOutParamsPassBase& operator=(const BufferResultsToOutParamsPassBase &) = delete;
  BufferResultsToOutParamsPassBase(BufferResultsToOutParamsPassBase &&) = delete;
  BufferResultsToOutParamsPassBase& operator=(BufferResultsToOutParamsPassBase &&) = delete;
  ~BufferResultsToOutParamsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-results-to-out-params");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-results-to-out-params"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Converts memref-typed function results to out-params)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferResultsToOutParamsPass");
  }
  ::llvm::StringRef getName() const override { return "BufferResultsToOutParamsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferResultsToOutParamsPassBase<DerivedT>)

  BufferResultsToOutParamsPassBase(BufferResultsToOutParamsPassOptions options) : BufferResultsToOutParamsPassBase() {
    addResultAttribute = std::move(options.addResultAttribute);
    hoistStaticAllocs = std::move(options.hoistStaticAllocs);
    hoistDynamicAllocs = std::move(options.hoistDynamicAllocs);
    modifyPublicFunctions = std::move(options.modifyPublicFunctions);
  }
protected:
  ::mlir::Pass::Option<bool> addResultAttribute{*this, "add-result-attr", ::llvm::cl::desc(R"PO(Add the attribute 'bufferize.result' to all output parameters.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> hoistStaticAllocs{*this, "hoist-static-allocs", ::llvm::cl::desc(R"PO(Hoist static allocations to call sites.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> hoistDynamicAllocs{*this, "hoist-dynamic-allocs", ::llvm::cl::desc(R"PO(Hoist dynamic allocations to call sites.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> modifyPublicFunctions{*this, "modify-public-functions", ::llvm::cl::desc(R"PO(Modify function signatures of public functions.)PO"), ::llvm::cl::init(false)};
private:

  friend std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass(BufferResultsToOutParamsPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass() {
  return impl::createBufferResultsToOutParamsPass();
}

std::unique_ptr<::mlir::Pass> createBufferResultsToOutParamsPass(BufferResultsToOutParamsPassOptions options) {
  return impl::createBufferResultsToOutParamsPass(std::move(options));
}
#undef GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMSPASS
#endif // GEN_PASS_DEF_BUFFERRESULTSTOOUTPARAMSPASS

//===----------------------------------------------------------------------===//
// DropEquivalentBufferResultsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTSPASS
std::unique_ptr<::mlir::Pass> createDropEquivalentBufferResultsPass();
#undef GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTSPASS
#endif // GEN_PASS_DECL_DROPEQUIVALENTBUFFERRESULTSPASS
#ifdef GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createDropEquivalentBufferResultsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class DropEquivalentBufferResultsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = DropEquivalentBufferResultsPassBase;

  DropEquivalentBufferResultsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  DropEquivalentBufferResultsPassBase(const DropEquivalentBufferResultsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  DropEquivalentBufferResultsPassBase& operator=(const DropEquivalentBufferResultsPassBase &) = delete;
  DropEquivalentBufferResultsPassBase(DropEquivalentBufferResultsPassBase &&) = delete;
  DropEquivalentBufferResultsPassBase& operator=(DropEquivalentBufferResultsPassBase &&) = delete;
  ~DropEquivalentBufferResultsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("drop-equivalent-buffer-results");
  }
  ::llvm::StringRef getArgument() const override { return "drop-equivalent-buffer-results"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Remove MemRef return values that are equivalent to a bbArg)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DropEquivalentBufferResultsPass");
  }
  ::llvm::StringRef getName() const override { return "DropEquivalentBufferResultsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(DropEquivalentBufferResultsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createDropEquivalentBufferResultsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createDropEquivalentBufferResultsPass() {
  return impl::createDropEquivalentBufferResultsPass();
}
#undef GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTSPASS
#endif // GEN_PASS_DEF_DROPEQUIVALENTBUFFERRESULTSPASS

//===----------------------------------------------------------------------===//
// EmptyTensorEliminationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EMPTYTENSORELIMINATIONPASS
std::unique_ptr<::mlir::Pass> createEmptyTensorEliminationPass();
#undef GEN_PASS_DECL_EMPTYTENSORELIMINATIONPASS
#endif // GEN_PASS_DECL_EMPTYTENSORELIMINATIONPASS
#ifdef GEN_PASS_DEF_EMPTYTENSORELIMINATIONPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createEmptyTensorEliminationPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class EmptyTensorEliminationPassBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorEliminationPassBase;

  EmptyTensorEliminationPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorEliminationPassBase(const EmptyTensorEliminationPassBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorEliminationPassBase& operator=(const EmptyTensorEliminationPassBase &) = delete;
  EmptyTensorEliminationPassBase(EmptyTensorEliminationPassBase &&) = delete;
  EmptyTensorEliminationPassBase& operator=(EmptyTensorEliminationPassBase &&) = delete;
  ~EmptyTensorEliminationPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("eliminate-empty-tensors");
  }
  ::llvm::StringRef getArgument() const override { return "eliminate-empty-tensors"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Try to eliminate all tensor.empty ops.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorEliminationPass");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorEliminationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorEliminationPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createEmptyTensorEliminationPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createEmptyTensorEliminationPass() {
  return impl::createEmptyTensorEliminationPass();
}
#undef GEN_PASS_DEF_EMPTYTENSORELIMINATIONPASS
#endif // GEN_PASS_DEF_EMPTYTENSORELIMINATIONPASS

//===----------------------------------------------------------------------===//
// EmptyTensorToAllocTensorPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSORPASS
std::unique_ptr<::mlir::Pass> createEmptyTensorToAllocTensorPass();
#undef GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSORPASS
#endif // GEN_PASS_DECL_EMPTYTENSORTOALLOCTENSORPASS
#ifdef GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSORPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createEmptyTensorToAllocTensorPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class EmptyTensorToAllocTensorPassBase : public ::mlir::OperationPass<> {
public:
  using Base = EmptyTensorToAllocTensorPassBase;

  EmptyTensorToAllocTensorPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  EmptyTensorToAllocTensorPassBase(const EmptyTensorToAllocTensorPassBase &other) : ::mlir::OperationPass<>(other) {}
  EmptyTensorToAllocTensorPassBase& operator=(const EmptyTensorToAllocTensorPassBase &) = delete;
  EmptyTensorToAllocTensorPassBase(EmptyTensorToAllocTensorPassBase &&) = delete;
  EmptyTensorToAllocTensorPassBase& operator=(EmptyTensorToAllocTensorPassBase &&) = delete;
  ~EmptyTensorToAllocTensorPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("empty-tensor-to-alloc-tensor");
  }
  ::llvm::StringRef getArgument() const override { return "empty-tensor-to-alloc-tensor"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Replace all empty ops by alloc_tensor ops.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmptyTensorToAllocTensorPass");
  }
  ::llvm::StringRef getName() const override { return "EmptyTensorToAllocTensorPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmptyTensorToAllocTensorPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createEmptyTensorToAllocTensorPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createEmptyTensorToAllocTensorPass() {
  return impl::createEmptyTensorToAllocTensorPass();
}
#undef GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSORPASS
#endif // GEN_PASS_DEF_EMPTYTENSORTOALLOCTENSORPASS

//===----------------------------------------------------------------------===//
// LowerDeallocationsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_LOWERDEALLOCATIONSPASS
std::unique_ptr<::mlir::Pass> createLowerDeallocationsPass();
#undef GEN_PASS_DECL_LOWERDEALLOCATIONSPASS
#endif // GEN_PASS_DECL_LOWERDEALLOCATIONSPASS
#ifdef GEN_PASS_DEF_LOWERDEALLOCATIONSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createLowerDeallocationsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class LowerDeallocationsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = LowerDeallocationsPassBase;

  LowerDeallocationsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LowerDeallocationsPassBase(const LowerDeallocationsPassBase &other) : ::mlir::OperationPass<>(other) {}
  LowerDeallocationsPassBase& operator=(const LowerDeallocationsPassBase &) = delete;
  LowerDeallocationsPassBase(LowerDeallocationsPassBase &&) = delete;
  LowerDeallocationsPassBase& operator=(LowerDeallocationsPassBase &&) = delete;
  ~LowerDeallocationsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("bufferization-lower-deallocations");
  }
  ::llvm::StringRef getArgument() const override { return "bufferization-lower-deallocations"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Lowers `bufferization.dealloc` operations to `memref.dealloc`operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerDeallocationsPass");
  }
  ::llvm::StringRef getName() const override { return "LowerDeallocationsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<scf::SCFDialect>();
    registry.insert<func::FuncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LowerDeallocationsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createLowerDeallocationsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createLowerDeallocationsPass() {
  return impl::createLowerDeallocationsPass();
}
#undef GEN_PASS_DEF_LOWERDEALLOCATIONSPASS
#endif // GEN_PASS_DEF_LOWERDEALLOCATIONSPASS

//===----------------------------------------------------------------------===//
// OneShotBufferizePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ONESHOTBUFFERIZEPASS
struct OneShotBufferizePassOptions {
  bool allowReturnAllocsFromLoops = false;
  bool allowUnknownOps = false;
  unsigned analysisFuzzerSeed = 0;
  std::string analysisHeuristic = "bottom-up";
  bool bufferizeFunctionBoundaries = 0;
  bool checkParallelRegions = true;
  bool copyBeforeWrite = false;
  ::llvm::SmallVector<std::string> dialectFilter;
  bool dumpAliasSets = false;
  ::llvm::SmallVector<std::string> noAnalysisFuncFilter;
  LayoutMapOption functionBoundaryTypeConversion = LayoutMapOption::InferLayoutMap;
  bool mustInferMemorySpace = false;
  bool useEncodingForMemorySpace = false;
  bool testAnalysisOnly = false;
  bool printConflicts = false;
  LayoutMapOption unknownTypeConversion = LayoutMapOption::FullyDynamicLayoutMap;
  uint64_t bufferAlignment = 64;
};
std::unique_ptr<::mlir::Pass> createOneShotBufferizePass();
std::unique_ptr<::mlir::Pass> createOneShotBufferizePass(OneShotBufferizePassOptions options);
#undef GEN_PASS_DECL_ONESHOTBUFFERIZEPASS
#endif // GEN_PASS_DECL_ONESHOTBUFFERIZEPASS
#ifdef GEN_PASS_DEF_ONESHOTBUFFERIZEPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createOneShotBufferizePass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createOneShotBufferizePass(OneShotBufferizePassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class OneShotBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OneShotBufferizePassBase;

  OneShotBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OneShotBufferizePassBase(const OneShotBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  OneShotBufferizePassBase& operator=(const OneShotBufferizePassBase &) = delete;
  OneShotBufferizePassBase(OneShotBufferizePassBase &&) = delete;
  OneShotBufferizePassBase& operator=(OneShotBufferizePassBase &&) = delete;
  ~OneShotBufferizePassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("one-shot-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "one-shot-bufferize"; }

  ::llvm::StringRef getDescription() const override { return R"PD(One-Shot Bufferize)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OneShotBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "OneShotBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<bufferization::BufferizationDialect>();
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OneShotBufferizePassBase<DerivedT>)

  OneShotBufferizePassBase(OneShotBufferizePassOptions options) : OneShotBufferizePassBase() {
    allowReturnAllocsFromLoops = std::move(options.allowReturnAllocsFromLoops);
    allowUnknownOps = std::move(options.allowUnknownOps);
    analysisFuzzerSeed = std::move(options.analysisFuzzerSeed);
    analysisHeuristic = std::move(options.analysisHeuristic);
    bufferizeFunctionBoundaries = std::move(options.bufferizeFunctionBoundaries);
    checkParallelRegions = std::move(options.checkParallelRegions);
    copyBeforeWrite = std::move(options.copyBeforeWrite);
    dialectFilter = std::move(options.dialectFilter);
    dumpAliasSets = std::move(options.dumpAliasSets);
    noAnalysisFuncFilter = std::move(options.noAnalysisFuncFilter);
    functionBoundaryTypeConversion = std::move(options.functionBoundaryTypeConversion);
    mustInferMemorySpace = std::move(options.mustInferMemorySpace);
    useEncodingForMemorySpace = std::move(options.useEncodingForMemorySpace);
    testAnalysisOnly = std::move(options.testAnalysisOnly);
    printConflicts = std::move(options.printConflicts);
    unknownTypeConversion = std::move(options.unknownTypeConversion);
    bufferAlignment = std::move(options.bufferAlignment);
  }
protected:
  ::mlir::Pass::Option<bool> allowReturnAllocsFromLoops{*this, "allow-return-allocs-from-loops", ::llvm::cl::desc(R"PO(Allows returning/yielding new allocations from a loop.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> allowUnknownOps{*this, "allow-unknown-ops", ::llvm::cl::desc(R"PO(Allows unknown (not bufferizable) ops in the input IR.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<unsigned> analysisFuzzerSeed{*this, "analysis-fuzzer-seed", ::llvm::cl::desc(R"PO(Test only: Analyze ops in random order with a given seed (fuzzer))PO"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> analysisHeuristic{*this, "analysis-heuristic", ::llvm::cl::desc(R"PO(Heuristic that control the IR traversal during analysis)PO"), ::llvm::cl::init("bottom-up")};
  ::mlir::Pass::Option<bool> bufferizeFunctionBoundaries{*this, "bufferize-function-boundaries", ::llvm::cl::desc(R"PO(Bufferize function boundaries (experimental).)PO"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<bool> checkParallelRegions{*this, "check-parallel-regions", ::llvm::cl::desc(R"PO(Account for parallel regions in RaW analysis.)PO"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> copyBeforeWrite{*this, "copy-before-write", ::llvm::cl::desc(R"PO(Skip the analysis. Make a buffer copy on every write.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> dialectFilter{*this, "dialect-filter", ::llvm::cl::desc(R"PO(Restrict bufferization to ops from these dialects.)PO")};
  ::mlir::Pass::Option<bool> dumpAliasSets{*this, "dump-alias-sets", ::llvm::cl::desc(R"PO(Test only: Annotate tensor IR with alias sets)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::ListOption<std::string> noAnalysisFuncFilter{*this, "no-analysis-func-filter", ::llvm::cl::desc(R"PO(Skip analysis of functions with these symbol names.Set copyBeforeWrite to true when bufferizing them.)PO")};
  ::mlir::Pass::Option<LayoutMapOption> functionBoundaryTypeConversion{*this, "function-boundary-type-conversion", ::llvm::cl::desc(R"PO(Controls layout maps when bufferizing function signatures.)PO"), ::llvm::cl::init(LayoutMapOption::InferLayoutMap), 
  ::llvm::cl::values(
    clEnumValN(LayoutMapOption::InferLayoutMap, "infer-layout-map", ""),
    clEnumValN(LayoutMapOption::IdentityLayoutMap, "identity-layout-map", ""),
    clEnumValN(LayoutMapOption::FullyDynamicLayoutMap, "fully-dynamic-layout-map", "")
    )};
  ::mlir::Pass::Option<bool> mustInferMemorySpace{*this, "must-infer-memory-space", ::llvm::cl::desc(R"PO(The memory space of an memref types must always be inferred. If unset, a default memory space of 0 is used otherwise.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> useEncodingForMemorySpace{*this, "use-encoding-for-memory-space", ::llvm::cl::desc(R"PO(Use the Tensor encoding attribute for the memory space. Exclusive to the 'must-infer-memory-space' option)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> testAnalysisOnly{*this, "test-analysis-only", ::llvm::cl::desc(R"PO(Test only: Only run inplaceability analysis and annotate IR)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> printConflicts{*this, "print-conflicts", ::llvm::cl::desc(R"PO(Test only: Annotate IR with RaW conflicts. Requires test-analysis-only.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<LayoutMapOption> unknownTypeConversion{*this, "unknown-type-conversion", ::llvm::cl::desc(R"PO(Controls layout maps for non-inferrable memref types.)PO"), ::llvm::cl::init(LayoutMapOption::FullyDynamicLayoutMap), 
  ::llvm::cl::values(
    clEnumValN(LayoutMapOption::InferLayoutMap, "infer-layout-map", ""),
    clEnumValN(LayoutMapOption::IdentityLayoutMap, "identity-layout-map", ""),
    clEnumValN(LayoutMapOption::FullyDynamicLayoutMap, "fully-dynamic-layout-map", "")
    )};
  ::mlir::Pass::Option<uint64_t> bufferAlignment{*this, "buffer-alignment", ::llvm::cl::desc(R"PO(Sets the alignment of newly allocated buffers.)PO"), ::llvm::cl::init(64)};
  ::mlir::Pass::Statistic numBufferAlloc{this, "num-buffer-alloc", R"PS(Number of buffer allocations)PS"};
  ::mlir::Pass::Statistic numTensorInPlace{this, "num-tensor-in-place", R"PS(Number of in-place tensor OpOperands)PS"};
  ::mlir::Pass::Statistic numTensorOutOfPlace{this, "num-tensor-out-of-place", R"PS(Number of out-of-place tensor OpOperands)PS"};
private:

  friend std::unique_ptr<::mlir::Pass> createOneShotBufferizePass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createOneShotBufferizePass(OneShotBufferizePassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createOneShotBufferizePass() {
  return impl::createOneShotBufferizePass();
}

std::unique_ptr<::mlir::Pass> createOneShotBufferizePass(OneShotBufferizePassOptions options) {
  return impl::createOneShotBufferizePass(std::move(options));
}
#undef GEN_PASS_DEF_ONESHOTBUFFERIZEPASS
#endif // GEN_PASS_DEF_ONESHOTBUFFERIZEPASS

//===----------------------------------------------------------------------===//
// OptimizeAllocationLivenessPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESSPASS
std::unique_ptr<::mlir::Pass> createOptimizeAllocationLivenessPass();
#undef GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESSPASS
#endif // GEN_PASS_DECL_OPTIMIZEALLOCATIONLIVENESSPASS
#ifdef GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createOptimizeAllocationLivenessPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class OptimizeAllocationLivenessPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = OptimizeAllocationLivenessPassBase;

  OptimizeAllocationLivenessPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptimizeAllocationLivenessPassBase(const OptimizeAllocationLivenessPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  OptimizeAllocationLivenessPassBase& operator=(const OptimizeAllocationLivenessPassBase &) = delete;
  OptimizeAllocationLivenessPassBase(OptimizeAllocationLivenessPassBase &&) = delete;
  OptimizeAllocationLivenessPassBase& operator=(OptimizeAllocationLivenessPassBase &&) = delete;
  ~OptimizeAllocationLivenessPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("optimize-allocation-liveness");
  }
  ::llvm::StringRef getArgument() const override { return "optimize-allocation-liveness"; }

  ::llvm::StringRef getDescription() const override { return R"PD(This pass optimizes the liveness of temp allocations in the input function)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptimizeAllocationLivenessPass");
  }
  ::llvm::StringRef getName() const override { return "OptimizeAllocationLivenessPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptimizeAllocationLivenessPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createOptimizeAllocationLivenessPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createOptimizeAllocationLivenessPass() {
  return impl::createOptimizeAllocationLivenessPass();
}
#undef GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESSPASS
#endif // GEN_PASS_DEF_OPTIMIZEALLOCATIONLIVENESSPASS

//===----------------------------------------------------------------------===//
// OwnershipBasedBufferDeallocationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
struct OwnershipBasedBufferDeallocationPassOptions {
  bool privateFuncDynamicOwnership = false;
};
std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass();
std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass(OwnershipBasedBufferDeallocationPassOptions options);
#undef GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#endif // GEN_PASS_DECL_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#ifdef GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass(OwnershipBasedBufferDeallocationPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class OwnershipBasedBufferDeallocationPassBase : public ::mlir::OperationPass<> {
public:
  using Base = OwnershipBasedBufferDeallocationPassBase;

  OwnershipBasedBufferDeallocationPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  OwnershipBasedBufferDeallocationPassBase(const OwnershipBasedBufferDeallocationPassBase &other) : ::mlir::OperationPass<>(other) {}
  OwnershipBasedBufferDeallocationPassBase& operator=(const OwnershipBasedBufferDeallocationPassBase &) = delete;
  OwnershipBasedBufferDeallocationPassBase(OwnershipBasedBufferDeallocationPassBase &&) = delete;
  OwnershipBasedBufferDeallocationPassBase& operator=(OwnershipBasedBufferDeallocationPassBase &&) = delete;
  ~OwnershipBasedBufferDeallocationPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("ownership-based-buffer-deallocation");
  }
  ::llvm::StringRef getArgument() const override { return "ownership-based-buffer-deallocation"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Adds all required dealloc operations for all allocations in the input program)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OwnershipBasedBufferDeallocationPass");
  }
  ::llvm::StringRef getName() const override { return "OwnershipBasedBufferDeallocationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::bufferization::BufferizationDialect>();
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OwnershipBasedBufferDeallocationPassBase<DerivedT>)

  OwnershipBasedBufferDeallocationPassBase(OwnershipBasedBufferDeallocationPassOptions options) : OwnershipBasedBufferDeallocationPassBase() {
    privateFuncDynamicOwnership = std::move(options.privateFuncDynamicOwnership);
  }
protected:
  ::mlir::Pass::Option<bool> privateFuncDynamicOwnership{*this, "private-function-dynamic-ownership", ::llvm::cl::desc(R"PO(Allows to add additional arguments to private functions to dynamically pass ownership of memrefs to callees. This can enable earlier deallocations.)PO"), ::llvm::cl::init(false)};
private:

  friend std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass(OwnershipBasedBufferDeallocationPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass() {
  return impl::createOwnershipBasedBufferDeallocationPass();
}

std::unique_ptr<::mlir::Pass> createOwnershipBasedBufferDeallocationPass(OwnershipBasedBufferDeallocationPassOptions options) {
  return impl::createOwnershipBasedBufferDeallocationPass(std::move(options));
}
#undef GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#endif // GEN_PASS_DEF_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS

//===----------------------------------------------------------------------===//
// PromoteBuffersToStackPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_PROMOTEBUFFERSTOSTACKPASS
struct PromoteBuffersToStackPassOptions {
  unsigned maxAllocSizeInBytes = 1024;
  unsigned maxRankOfAllocatedMemRef = 1;
};
std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass();
std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass(PromoteBuffersToStackPassOptions options);
#undef GEN_PASS_DECL_PROMOTEBUFFERSTOSTACKPASS
#endif // GEN_PASS_DECL_PROMOTEBUFFERSTOSTACKPASS
#ifdef GEN_PASS_DEF_PROMOTEBUFFERSTOSTACKPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass(PromoteBuffersToStackPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class PromoteBuffersToStackPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = PromoteBuffersToStackPassBase;

  PromoteBuffersToStackPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PromoteBuffersToStackPassBase(const PromoteBuffersToStackPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}
  PromoteBuffersToStackPassBase& operator=(const PromoteBuffersToStackPassBase &) = delete;
  PromoteBuffersToStackPassBase(PromoteBuffersToStackPassBase &&) = delete;
  PromoteBuffersToStackPassBase& operator=(PromoteBuffersToStackPassBase &&) = delete;
  ~PromoteBuffersToStackPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("promote-buffers-to-stack");
  }
  ::llvm::StringRef getArgument() const override { return "promote-buffers-to-stack"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Promotes heap-based allocations to automatically managed stack-based allocations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PromoteBuffersToStackPass");
  }
  ::llvm::StringRef getName() const override { return "PromoteBuffersToStackPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PromoteBuffersToStackPassBase<DerivedT>)

  PromoteBuffersToStackPassBase(PromoteBuffersToStackPassOptions options) : PromoteBuffersToStackPassBase() {
    maxAllocSizeInBytes = std::move(options.maxAllocSizeInBytes);
    maxRankOfAllocatedMemRef = std::move(options.maxRankOfAllocatedMemRef);
  }
protected:
  ::mlir::Pass::Option<unsigned> maxAllocSizeInBytes{*this, "max-alloc-size-in-bytes", ::llvm::cl::desc(R"PO(Maximal size in bytes to promote allocations to stack.)PO"), ::llvm::cl::init(1024)};
  ::mlir::Pass::Option<unsigned> maxRankOfAllocatedMemRef{*this, "max-rank-of-allocated-memref", ::llvm::cl::desc(R"PO(Maximal memref rank to promote dynamic buffers.)PO"), ::llvm::cl::init(1)};
private:

  friend std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass(PromoteBuffersToStackPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass() {
  return impl::createPromoteBuffersToStackPass();
}

std::unique_ptr<::mlir::Pass> createPromoteBuffersToStackPass(PromoteBuffersToStackPassOptions options) {
  return impl::createPromoteBuffersToStackPass(std::move(options));
}
#undef GEN_PASS_DEF_PROMOTEBUFFERSTOSTACKPASS
#endif // GEN_PASS_DEF_PROMOTEBUFFERSTOSTACKPASS
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#define GEN_PASS_REGISTRATION_BUFFERHOISTINGPASS
#define GEN_PASS_REGISTRATION_BUFFERLOOPHOISTINGPASS
#define GEN_PASS_REGISTRATION_BUFFERRESULTSTOOUTPARAMSPASS
#define GEN_PASS_REGISTRATION_DROPEQUIVALENTBUFFERRESULTSPASS
#define GEN_PASS_REGISTRATION_EMPTYTENSORELIMINATIONPASS
#define GEN_PASS_REGISTRATION_EMPTYTENSORTOALLOCTENSORPASS
#define GEN_PASS_REGISTRATION_LOWERDEALLOCATIONSPASS
#define GEN_PASS_REGISTRATION_ONESHOTBUFFERIZEPASS
#define GEN_PASS_REGISTRATION_OPTIMIZEALLOCATIONLIVENESSPASS
#define GEN_PASS_REGISTRATION_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#define GEN_PASS_REGISTRATION_PROMOTEBUFFERSTOSTACKPASS
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferDeallocationSimplificationPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_BUFFERDEALLOCATIONSIMPLIFICATIONPASS

inline void registerBufferDeallocationSimplificationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferDeallocationSimplificationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferDeallocationSimplificationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferDeallocationSimplificationPass();
  });
}

#undef GEN_PASS_REGISTRATION_BUFFERDEALLOCATIONSIMPLIFICATIONPASS
#endif // GEN_PASS_REGISTRATION_BUFFERDEALLOCATIONSIMPLIFICATIONPASS

//===----------------------------------------------------------------------===//
// BufferHoistingPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_BUFFERHOISTINGPASS

inline void registerBufferHoistingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferHoistingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferHoistingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferHoistingPass();
  });
}

#undef GEN_PASS_REGISTRATION_BUFFERHOISTINGPASS
#endif // GEN_PASS_REGISTRATION_BUFFERHOISTINGPASS

//===----------------------------------------------------------------------===//
// BufferLoopHoistingPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_BUFFERLOOPHOISTINGPASS

inline void registerBufferLoopHoistingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferLoopHoistingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferLoopHoistingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferLoopHoistingPass();
  });
}

#undef GEN_PASS_REGISTRATION_BUFFERLOOPHOISTINGPASS
#endif // GEN_PASS_REGISTRATION_BUFFERLOOPHOISTINGPASS

//===----------------------------------------------------------------------===//
// BufferResultsToOutParamsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_BUFFERRESULTSTOOUTPARAMSPASS

inline void registerBufferResultsToOutParamsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferResultsToOutParamsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerBufferResultsToOutParamsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferResultsToOutParamsPass();
  });
}

#undef GEN_PASS_REGISTRATION_BUFFERRESULTSTOOUTPARAMSPASS
#endif // GEN_PASS_REGISTRATION_BUFFERRESULTSTOOUTPARAMSPASS

//===----------------------------------------------------------------------===//
// DropEquivalentBufferResultsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_DROPEQUIVALENTBUFFERRESULTSPASS

inline void registerDropEquivalentBufferResultsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createDropEquivalentBufferResultsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerDropEquivalentBufferResultsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createDropEquivalentBufferResultsPass();
  });
}

#undef GEN_PASS_REGISTRATION_DROPEQUIVALENTBUFFERRESULTSPASS
#endif // GEN_PASS_REGISTRATION_DROPEQUIVALENTBUFFERRESULTSPASS

//===----------------------------------------------------------------------===//
// EmptyTensorEliminationPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_EMPTYTENSORELIMINATIONPASS

inline void registerEmptyTensorEliminationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createEmptyTensorEliminationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerEmptyTensorEliminationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createEmptyTensorEliminationPass();
  });
}

#undef GEN_PASS_REGISTRATION_EMPTYTENSORELIMINATIONPASS
#endif // GEN_PASS_REGISTRATION_EMPTYTENSORELIMINATIONPASS

//===----------------------------------------------------------------------===//
// EmptyTensorToAllocTensorPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_EMPTYTENSORTOALLOCTENSORPASS

inline void registerEmptyTensorToAllocTensorPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createEmptyTensorToAllocTensorPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerEmptyTensorToAllocTensorPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createEmptyTensorToAllocTensorPass();
  });
}

#undef GEN_PASS_REGISTRATION_EMPTYTENSORTOALLOCTENSORPASS
#endif // GEN_PASS_REGISTRATION_EMPTYTENSORTOALLOCTENSORPASS

//===----------------------------------------------------------------------===//
// LowerDeallocationsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_LOWERDEALLOCATIONSPASS

inline void registerLowerDeallocationsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLowerDeallocationsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerLowerDeallocationsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLowerDeallocationsPass();
  });
}

#undef GEN_PASS_REGISTRATION_LOWERDEALLOCATIONSPASS
#endif // GEN_PASS_REGISTRATION_LOWERDEALLOCATIONSPASS

//===----------------------------------------------------------------------===//
// OneShotBufferizePass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ONESHOTBUFFERIZEPASS

inline void registerOneShotBufferizePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOneShotBufferizePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOneShotBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOneShotBufferizePass();
  });
}

#undef GEN_PASS_REGISTRATION_ONESHOTBUFFERIZEPASS
#endif // GEN_PASS_REGISTRATION_ONESHOTBUFFERIZEPASS

//===----------------------------------------------------------------------===//
// OptimizeAllocationLivenessPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_OPTIMIZEALLOCATIONLIVENESSPASS

inline void registerOptimizeAllocationLivenessPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOptimizeAllocationLivenessPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOptimizeAllocationLivenessPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOptimizeAllocationLivenessPass();
  });
}

#undef GEN_PASS_REGISTRATION_OPTIMIZEALLOCATIONLIVENESSPASS
#endif // GEN_PASS_REGISTRATION_OPTIMIZEALLOCATIONLIVENESSPASS

//===----------------------------------------------------------------------===//
// OwnershipBasedBufferDeallocationPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS

inline void registerOwnershipBasedBufferDeallocationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOwnershipBasedBufferDeallocationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOwnershipBasedBufferDeallocationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOwnershipBasedBufferDeallocationPass();
  });
}

#undef GEN_PASS_REGISTRATION_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS
#endif // GEN_PASS_REGISTRATION_OWNERSHIPBASEDBUFFERDEALLOCATIONPASS

//===----------------------------------------------------------------------===//
// PromoteBuffersToStackPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_PROMOTEBUFFERSTOSTACKPASS

inline void registerPromoteBuffersToStackPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createPromoteBuffersToStackPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerPromoteBuffersToStackPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createPromoteBuffersToStackPass();
  });
}

#undef GEN_PASS_REGISTRATION_PROMOTEBUFFERSTOSTACKPASS
#endif // GEN_PASS_REGISTRATION_PROMOTEBUFFERSTOSTACKPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// Bufferization Registration
//===----------------------------------------------------------------------===//

inline void registerBufferizationPasses() {
  registerBufferDeallocationSimplificationPass();
  registerBufferHoistingPass();
  registerBufferLoopHoistingPass();
  registerBufferResultsToOutParamsPass();
  registerDropEquivalentBufferResultsPass();
  registerEmptyTensorEliminationPass();
  registerEmptyTensorToAllocTensorPass();
  registerLowerDeallocationsPass();
  registerOneShotBufferizePass();
  registerOptimizeAllocationLivenessPass();
  registerOwnershipBasedBufferDeallocationPass();
  registerPromoteBuffersToStackPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_CLASSES
#error "GEN_PASS_CLASSES is deprecated; use per-pass macros"
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
