/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: NVVMOps.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::NVVM {

class AggrSmemSize;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// CTA Barrier Synchronization Op (Barrier ID 0)
/// The `nvvm.barrier0` operation is a convenience operation that performs barrier 
///     synchronization and communication within a CTA (Cooperative Thread Array) using 
///     barrier ID 0. It is functionally equivalent to `nvvm.barrier` or `nvvm.barrier id=0`. 
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-bar)
class Barrier0Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Thread that executes this op announces their arrival at the barrier with 
///     given id and continue their execution.
/// 
///     The default barrier id is 0 that is similar to `nvvm.barrier` Op. When 
///     `barrierId` is not present, the default barrier id is used. 
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-bar)
class BarrierArriveOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// CTA Barrier Synchronization Op
/// The `nvvm.barrier` operation performs barrier synchronization and communication 
///     within a CTA (Cooperative Thread Array). It causes executing threads to wait for 
///     all non-exited threads participating in the barrier to arrive.
/// 
///     The operation takes two optional operands:
/// 
///     - `barrierId`: Specifies a logical barrier resource with value 0 through 15. 
///       Each CTA instance has sixteen barriers numbered 0..15. Defaults to 0 if not specified.
///     - `numberOfThreads`: Specifies the number of threads participating in the barrier. 
///       When specified, the value must be a multiple of the warp size. If not specified, 
///       all threads in the CTA participate in the barrier.
///     - `reductionOp`: specifies the reduction operation (`popc`, `and`, `or`).
///     - `reductionPredicate`: specifies the predicate to be used with the
///       `reductionOp`. 
/// 
///     The barrier operation guarantees that when the barrier completes, prior memory 
///     accesses requested by participating threads are performed relative to all threads 
///     participating in the barrier. It also ensures that no new memory access is 
///     requested by participating threads before the barrier completes.
/// 
///     When a barrier completes, the waiting threads are restarted without delay, and 
///     the barrier is reinitialized so that it can be immediately reused.
/// 
///     This operation generates an aligned barrier, indicating that all threads in the CTA 
///     will execute the same barrier instruction. Behavior is undefined if all threads in the 
///     CTA do not reach this instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-bar)
class BarrierOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockDimXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockDimYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockDimZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockIdXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockIdYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockIdZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockInClusterIdXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockInClusterIdYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class BlockInClusterIdZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Breakpoint Op
/// Breakpoint suspends execution of the program for debugging.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#miscellaneous-instructions-brkpt)
class Breakpoint;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Bulk Store Op
/// Initializes a region of shared memory at the address given by `addr`.
///     The `size` operand specifies the number of bytes to initialize and must be 
///     a multiple of 8.
///     The `initVal` operand specifies the value to initialize the memory to. The 
///     only supported value is 0.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#data-movement-and-conversion-instructions-st-bulk)
class BulkStoreOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class Clock64Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClockOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Cluster Barrier Arrive Op
/// The `cluster.arrive` can be used by the threads within the cluster for synchronization and
///     communication. The `cluster.arrive` instruction marks the warps' arrival at the barrier
///     without causing the executing thread to wait for other participating threads.
/// 
///     The `aligned` attribute, when provided, generates the .aligned version of the PTX instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-barrier-cluster)
class ClusterArriveOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Cluster Barrier Relaxed Arrive Op
/// The `cluster.arrive` can be used by the threads within the cluster for synchronization and
///     communication. The `cluster.arrive` instruction marks the warps' arrival at the barrier
///     without causing the executing thread to wait for other participating threads.
/// 
///     The `aligned` attribute, when provided, generates the .aligned version of the PTX instruction.
///     The .relaxed qualifier on `cluster.arrive` specifies that there are no memory
///     ordering and visibility guarantees provided for the memory accesses performed prior to
///     `cluster.arrive`.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-barrier-cluster)
class ClusterArriveRelaxedOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDim;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimBlocksXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimBlocksYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimBlocksZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterDimZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterId;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterIdXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterIdYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ClusterIdZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Query the response of a clusterlaunchcontrol.try.cancel operation
/// `clusterlaunchcontrol.query.cancel` queries the response of a 
///     `clusterlaunchcontrol.try.cancel` operation specified by operand 
///     `try_cancel_response`.
/// 
///     Operand `query_type` specifies the type of query to perform and can be one 
///     of the following:
///     - `is_canceled` : Returns true if the try cancel request succeeded, 
///     and false otherwise.
///     - `get_first_cta_id_{x/y/z}` : Returns the x, y, or z coordinate of the 
///     first CTA in the canceled cluster. Behaviour is defined only if the try 
///     cancel request succeeded. 
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-clusterlaunchcontrol-query-cancel)
class ClusterLaunchControlQueryCancelOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Request atomically canceling the launch of a cluster that has not started running yet
/// `clusterlaunchcontrol.try.cancel` requests atomically canceling the launch 
///     of a cluster that has not started running yet. It asynchronously writes an 
///     opaque response to shared memory indicating whether the operation succeeded 
///     or failed.
/// 
///     Operand `smemAddress` specifies the naturally aligned address of the 
///     16-byte wide shared memory location where the request's response is written.
/// 
///     Operand `mbarrier` specifies the mbarrier object used to track the 
///     completion of the asynchronous operation.
/// 
///     If `multicast` is specified, the response is asynchronously written to the 
///     corresponding local shared memory location (specifed by `addr`) of each CTA 
///     in the requesting cluster.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-clusterlaunchcontrol-try-cancel)
class ClusterLaunchControlTryCancelOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Cluster Barrier Wait Op
/// The `cluster.wait` causes the executing thread to wait for all non-exited threads
///     of the cluster to perform `cluster.arrive`. The `aligned` attribute, when provided,
///     generates the .aligned version of the PTX instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-barrier-cluster)
class ClusterWaitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of bf16 inputs to f8x2
/// This Op converts the given bf16 inputs in a bf16x2 vector to the specified 
///     f8 type.
///     The result `dst` is represented as an i16 type or as a vector
///     of two i8 types.
///     If `dst` is returned as an i16 type, the converted values from `a`
///     are packed such that the value converted from the first element of `a`
///     is stored in the upper 8 bits of `dst` and the value converted from the
///     second element of `a` is stored in the lower 8 bits of `dst`.
///     If `dst` is returned as a vector type, each converted value is stored as an 
///     i8 element in the vector.
///     The `rnd` and `sat` attributes specify the rounding and saturation modes 
///     respectively.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertBF16x2ToF8x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert an f16x2 input to f8x2
/// This Op converts the given f16 inputs in an f16x2 vector to the specified 
///     f8 type.
///     The result `dst` is represented as an i16 type or as a vector
///     of two i8 types.
///     If `dst` is returned as an i16 type, the converted values from `a`
///     are packed such that the value converted from the first element of `a`
///     is stored in the upper 8 bits of `dst` and the value converted from the
///     second element of `a` is stored in the lower 8 bits of `dst`.
///     If `dst` is returned as a vector type, each converted value is stored as an 
///     i8 element in the vector.
///     The `relu` attribute, when set, lowers to the '.relu' variant of
///     the cvt instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF16x2ToF8x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert two F32 values to packed bf16x2.
/// Converts two F32 values to packed bf16x2 format with 
///     the specified rounding mode. The `src_hi` and `src_lo` parameters 
///     correspond to operands `a` and `b` in the PTX ISA, respectively.
///     
///     The `random_bits` parameter is required for stochastic rounding and 
///     provides the [random bits](https://docs.nvidia.com/cuda/parallel-thread-execution/#cvt-rs-rbits-layout-bf16) to be used for the conversion.
/// 
///     The `relu` attribute clamps negative results to 0.
/// 
///     The `sat` attribute determines saturation behavior.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x2ToBF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert two F32 values to packed f16x2.
/// Converts two F32 values to packed f16x2 format with 
///     the specified rounding mode. The `src_hi` and `src_lo` parameters 
///     correspond to operands `a` and `b` in the PTX ISA, respectively.
///     
///     The `random_bits` parameter is required for stochastic rounding and 
///     provides the [random bits](https://docs.nvidia.com/cuda/parallel-thread-execution/#cvt-rs-rbits-layout-f16) to be used for the conversion.
/// 
///     The `relu` attribute clamps negative results to 0.
/// 
///     The `sat` attribute determines saturation behavior.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x2ToF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of float inputs to f4x2
/// This Op converts each of the given float inputs to the specified fp4 type.
///     The result `dst` is returned as an i8 type where the converted values are 
///     packed such that the value converted from `a` is stored in the upper 4 bits 
///     of `dst` and the value converted from `b` is stored in the lower 4 bits of 
///     `dst`.
///     The `relu` attribute, when set, lowers to the '.relu' variant of
///     the cvt instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x2ToF4x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of float inputs to f6x2
/// This Op converts each of the given float inputs to the specified fp6 type.
///     The result `dst` is represented either as an i16 type or as a vector
///     of two i8 types.
///     If `dst` is returned as an i16 type, the converted values are packed such 
///     that the value converted from `a` is stored in the upper 8 bits of `dst` 
///     with 2 MSB bits padded with zeros and the value converted from `b` is 
///     stored in the lower 8 bits of `dst` with 2 MSB bits padded with zeros.
///     If `dst` is returned as a vector type, each converted value is stored as an 
///     i8 element in the vector.
///     The `relu` attribute, when set, lowers to the '.relu' variant of
///     the cvt instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x2ToF6x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of float inputs to f8x2
/// This Op converts each of the given float inputs to the specified fp8 type.
///     The result `dst` is represented as an i16 type or as a vector
///     of two i8 types.
///     If `dst` is returned as an i16 type, the converted values are packed such 
///     that the value converted from `a` is stored in the upper 8 bits of `dst` 
///     and the value converted from `b` is stored in the lower 8 bits of `dst`.
///     If `dst` is returned as a vector type, each converted value is stored as an 
///     i8 element in the vector.
///     The `rnd` and `sat` attributes specify the rounding and saturation modes respectively.
///     The `relu` attribute, when set, lowers to the '.relu' variant of
///     the cvt instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x2ToF8x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert vector<4xf32> to packed f4x4 with stochastic rounding (.rs) and satfinite
/// Converts a vector<4xf32> to packed f4x4 format using 
///     stochastic rounding (.rs) mode with SATFINITE saturation. Randomness is 
///     provided by the `rbits` parameter. The `dstTy` attribute specifies the 
///     target floating-point format. The `relu` attribute clamps negative results to 0.
///     
///     Note: These operations always use RS rounding mode and SATFINITE saturation mode.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x4ToF4x4Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert vector<4xf32> to packed f6x4 with stochastic rounding (.rs) and satfinite
/// Converts a vector<4xf32> to packed f6x4 format using 
///     stochastic rounding (.rs) mode with SATFINITE saturation. Randomness is 
///     provided by the `rbits` parameter. The `dstTy` attribute specifies the 
///     target floating-point format. The `relu` attribute clamps negative results to 0.
///     
///     Note: These operations always use RS rounding mode and SATFINITE saturation mode.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x4ToF6x4Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert vector<4xf32> to packed f8x4 with stochastic rounding (.rs) and satfinite
/// Converts a vector<4xf32> to packed f8x4 format using 
///     stochastic rounding (.rs) mode with SATFINITE saturation. Randomness is 
///     provided by the `rbits` parameter. The `dstTy` attribute specifies the 
///     target floating-point format. The `relu` attribute clamps negative results to 0.
///     
///     Note: These operations always use RS rounding mode and SATFINITE saturation mode.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF32x4ToF8x4Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of f4 inputs to f16x2
/// This Op converts the given f4 inputs in a packed i8 to f16.
/// 
///     The result `dst` is represented as a vector of f16 elements.
///     The `relu` attribute, when set, lowers to the '.relu' variant of 
///     the cvt instruction."
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF4x2ToF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of f6 inputs to f16x2
/// This Op converts the given f6 inputs in a i8x2 vector to f16.
/// 
///     The result `dst` is represented as a vector of f16 elements.
///     The `relu` attribute, when set, lowers to the '.relu' variant of 
///     the cvt instruction."
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF6x2ToF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of f8 inputs to bf16x2
/// This Op converts the given f8 inputs in a i8x2 vector to bf16.
/// 
///     The result `dst` is represented as a vector of bf16 elements.
///     
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF8x2ToBF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert a pair of f8 inputs to f16x2
/// This Op converts the given f8 inputs in a i8x2 vector to f16.
/// 
///     The result `dst` is represented as a vector of f16 elements.
///     The `relu` attribute, when set, lowers to the '.relu' variant of 
///     the cvt instruction."
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertF8x2ToF16x2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Convert the given float input to TF32
/// This Op converts the given f32 input to tf32.
///     The result `res` is represented as an i32 type.
///     The `relu` attribute, when set, lowers to the '.relu' variant of
///     the cvt instruction. The `rnd` and `sat` attributes specify the
///     the rounding and saturation modes respectively.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cvt)
class ConvertFloatToTF32Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// This Op commits all prior initiated but uncommitted cp.async.bulk
///     instructions into a cp.async.bulk-group.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk-commit-group)
class CpAsyncBulkCommitGroupOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Async bulk copy from global to Shared {cta or cluster} memory
/// Initiates an asynchronous copy operation from global memory to shared
///     memory or shared_cluster memory.
/// 
///     The `multicastMask` operand is optional and can be used only when the
///     destination is shared::cluster memory. When it is present, this Op copies
///     data from global memory to shared memory of multiple CTAs in the cluster.
///     Operand `multicastMask` specifies the destination CTAs in the cluster such
///     that each bit position in the 16-bit `multicastMask` operand corresponds to
///     the `nvvm.read.ptx.sreg.ctaid` of the destination CTA. 
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache
///     eviction policy that may be used during the memory access.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk)
class CpAsyncBulkGlobalToSharedClusterOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Async bulk prefetch from global memory to L2 cache
/// Initiates an asynchronous prefetch of data from the location
///     specified by `srcMem` to the L2 cache.
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache
///     eviction policy that may be used during the memory access.
/// 
///     Example:
///     ```mlir
///       nvvm.cp.async.bulk.prefetch %src, %size : !llvm.ptr<1>
/// 
///       // with l2_cache_hint
///       nvvm.cp.async.bulk.prefetch %src, %size l2_cache_hint = %ch : !llvm.ptr<1>
///     ```
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk-prefetch)
class CpAsyncBulkPrefetchOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Async bulk copy from Shared CTA memory to Global memory
/// Initiates an asynchronous copy operation from Shared CTA memory to
///     global memory. The 32-bit operand `size` specifies the amount of
///     memory to be copied, in terms of number of bytes. `size` must be a
///     multiple of 16. The `l2CacheHint` operand is optional, and it is used
///     to specify cache eviction policy that may be used during the memory
///     access. The `byteMask` operand is optional. The i-th bit in the 16-bit
///     wide `byteMask` specifies whether the i-th byte of each 16-byte wide
///     chunk of source data is copied to the destination. If the bit is set,
///     the byte is copied.
/// 
///     Example:
///     ```mlir
///       nvvm.cp.async.bulk.global.shared.cta %dst, %src, %size
///           : !llvm.ptr<1>, !llvm.ptr<3>
/// 
///       // with l2_cache_hint
///       nvvm.cp.async.bulk.global.shared.cta %dst, %src, %size l2_cache_hint = %ch
///           : !llvm.ptr<1>, !llvm.ptr<3>
/// 
///       // with byte_mask
///       nvvm.cp.async.bulk.global.shared.cta %dst, %src, %size byte_mask = %mask
///           : !llvm.ptr<1>, !llvm.ptr<3>
/// 
///       // with both l2_cache_hint and byte_mask
///       nvvm.cp.async.bulk.global.shared.cta %dst, %src, %size l2_cache_hint = %ch byte_mask = %mask
///           : !llvm.ptr<1>, !llvm.ptr<3>
///     ```
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk)
class CpAsyncBulkSharedCTAToGlobalOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Async bulk copy from Shared CTA memory to Shared cluster memory
/// Initiates an asynchronous copy operation from Shared CTA memory to Shared
///     cluster memory.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk)
class CpAsyncBulkSharedCTAToSharedClusterOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Initiates an asynchronous copy operation on the tensor data from global 
///     memory to shared::cluster (or) shared::cta memory. This Op supports all
///     the load modes specified in `TMALoadMode`.
/// 
///     The `multicastMask` operand is optional. When it is present, the Op copies
///     data from global memory to shared memory of multiple CTAs in the cluster.
///     Operand `multicastMask` specifies the destination CTAs in the cluster such 
///     that each bit position in the 16-bit `multicastMask` operand corresponds to
///     the `nvvm.read.ptx.sreg.ctaid` of the destination CTA.     
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache 
///     eviction policy that may be used during the memory access.
///     
///     When the `isCTAOnly` attribute is set to true, the destination is
///     shared::cta only. Hence, `multicastMask` and `CTAGroup` are not applicable
///     when `isCTAOnly` is true.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk-tensor)
class CpAsyncBulkTensorGlobalToSharedClusterOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Initiates an asynchronous prefetch operation on the tensor data from global
///     memory to L2 cache. This Op supports all the load modes specified in
///     `TMALoadMode`.
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache
///     eviction policy that may be used during the memory access.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk-prefetch-tensor)
class CpAsyncBulkTensorPrefetchOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Initiates an asynchronous reduction operation of tensor data in
///     global memory with tensor data in shared memory.
/// 
///     The `mode` attribute indicates whether the copy mode is tile or im2col.
///     The `redOp` attribute specifies the reduction operations applied.
///     The supported reduction operations are:
///     {add, min, max, inc, dec, and, or, xor}
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache
///     eviction policy that may be used during the memory access.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-reduce-async-bulk-tensor)
class CpAsyncBulkTensorReduceOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Initiates an asynchronous copy of the tensor data from shared::cta
///     memory to global memory. This Op supports all the store modes specified in
///     `TMAStoreMode`.
/// 
///     The `l2CacheHint` operand is optional, and it is used to specify cache
///     eviction policy that may be used during the memory access.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#data-movement-and-conversion-instructions-cp-async-bulk-tensor)
class CpAsyncBulkTensorSharedCTAToGlobalOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Op waits for completion of the most recent bulk async-groups.
/// 
///     The `$group` operand tells waiting has to be done until for $group or fewer
///     of the most recent bulk async-groups. If `$group` is 0, the op wait until 
///     all the most recent bulk async-groups have completed.
/// 
///     The `$read` indicates that the waiting has to be done until all the bulk 
///     async operations in the specified bulk async-group have completed reading 
///     from their source locations.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#data-movement-and-conversion-instructions-cp-async-bulk-wait-group)
class CpAsyncBulkWaitGroupOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class CpAsyncCommitGroupOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// NVVM Dialect Op for cp.async.mbarrier.arrive
/// The `cp.async.mbarrier.arrive` Op makes the *mbarrier object* track
///     all prior cp.async operations initiated by the executing thread.
///     The `addr` operand specifies the address of the *mbarrier object*
///     in generic or shared::cta address space. When it is generic, the
///     underlying memory should fall within the shared::cta space;
///     otherwise the behavior is undefined. The `noinc` attr impacts
///     how the mbarrier's state is updated.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-cp-async-mbarrier-arrive)
class CpAsyncMBarrierArriveOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class CpAsyncOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class CpAsyncWaitGroupOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Two-way 16-bit to 8-bit dot product-accumulate instruction
/// Performs a two-way 16-bit to 8-bit dot-product which is accumulated in a 
///     32-bit result.
///     Operand `a` is a vector of two 16-bit elements and operand `b` a vector 
///     of four 8-bit elements between which the dot product is computed.
/// 
///     The `a_type` and `b_type` attributes specify the type of the elements in `a`
///     and `b` respectively.
///     If `a_type` or `b_type` is `s`, then the elements in the corresponding 
///     vector are sign-extended to 32-bit before the dot product is computed.
///     If `a_type` or `b_type` is `u`, then the elements in the corresponding 
///     vector are zero-extended to 32-bit instead.
/// 
///     The `b_hi` boolean attribute specifies which two bytes of `b` are used for 
///     the dot product. If `b_hi` is true, then the dot product is computed 
///     between  `a` and elements at indices 2 and 3 of `b`. If `b_hi` is false, 
///     then the dot product is computed between `a` and elements at indices 0 and 
///     1 of `b`.
/// 
///     Operand `c` is a 32-bit integer to which the result is accumulated. It is
///     treated as holding a signed integer if any of `a_type` or `b_type` is 
///     signed.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#integer-arithmetic-instructions-dp2a)
class DotAccumulate2WayOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Four-way byte dot product-accumulate instruction
/// Performs a four-way byte dot-product which is accumulated in a 32-bit
///     result.
///     Operand `a` and `b` are vectors of 4 bytes between which the dot product is 
///     computed.
/// 
///     The `a_type` and `b_type` attributes specify the type of the elements in `a`
///     and `b` respectively.
///     If `a_type` or `b_type` is `signed`, then the elements in the corresponding 
///     vector are sign-extended to 32-bit before the dot product is computed.
///     If `a_type` or `b_type` is `unsigned`, then the elements in the 
///     corresponding vector are zero-extended to 32-bit instead.
/// 
///     Operand `c` is a 32-bit integer to which the result is accumulated. It is
///     treated as holding a signed integer if any of `a_type` or `b_type` is `s8`.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#integer-arithmetic-instructions-dp4a)
class DotAccumulate4WayOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class DynamicSmemSize;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Elect one leader thread
/// The `elect.sync` instruction elects one predicated active leader
///     thread from among a set of threads specified in the `membermask`.
///     When the `membermask` is not provided explicitly, a default value
///     of `0xFFFFFFFF` is used. The predicate result is set to `True` for
///     the leader thread, and `False` for all other threads.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-elect-sync)
class ElectSyncOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg0Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg10Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg11Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg12Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg13Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg14Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg15Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg16Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg17Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg18Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg19Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg1Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg20Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg21Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg22Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg23Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg24Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg25Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg26Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg27Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg28Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg29Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg2Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg30Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg31Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg3Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg4Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg5Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg6Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg7Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg8Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class EnvReg9Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Exit Op
/// Ends execution of a thread.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#control-flow-instructions-exit)
class Exit;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Fence operation that applies on the prior nvvm.mbarrier.init
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceMbarrierInitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Uni-directional proxy fence operation with acquire semantics
/// `fence.proxy.acquire` is a uni-directional fence used to establish ordering
///     between a prior memory access performed via the generic proxy and a
///     subsequent memory access performed via the tensormap proxy
/// 
///     The address operand `addr` and the operand `size` together specify the
///     memory range `[addr, addr+size)` on which the ordering guarantees on the
///     memory accesses across the proxies is to be provided. The only supported
///     value for the `size` operand is 128 and must be an immediate. Generic Addressing
///     is used unconditionally, and the address specified by the operand `addr` must
///     fall within the `.global` state space. Otherwise, the behavior is undefined
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceProxyAcquireOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Fence operation with proxy to establish an ordering between memory accesses
///     that may happen through different proxies.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceProxyOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Uni-directional proxy fence operation with release semantics
/// `fence.proxy.release` is a uni-directional fence used to establish ordering
///     between a prior memory access performed via the generic proxy and a
///     subsequent memory access performed via the tensormap proxy. `fence.proxy.release`
///     operation can form a release sequence that synchronizes with an acquire
///     sequence that contains the fence.proxy.acquire proxy fence operation
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceProxyReleaseOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Uni-directional proxy fence operation with sync_restrict
/// The `nvvm.fence.proxy.sync_restrict` Op used to establish
///     ordering between a prior memory access performed between proxies. Currently,
///     the ordering is only supported between async and generic proxies. `sync_restrict`
///     restricts `acquire` memory semantics to `shared_cluster` and `release` memory
///     semantics to `shared_cta` with cluster scope.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceProxySyncRestrictOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class FenceScClusterOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Uni-directional thread fence operation
/// The `nvvm.fence.sync_restrict` Op restricts the class of memory
///     operations for which the fence instruction provides the memory ordering guarantees.
///     `sync_restrict` restricts `acquire` memory semantics to `shared_cluster` and
///     `release` memory semantics to `shared_cta` with cluster scope.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-membar)
class FenceSyncRestrictOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GlobalTimerLoOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GlobalTimerOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GridDimXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GridDimYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GridDimZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class GridIdOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// If the $kind attribute is set to `wait`, it causes the 
///     executing thread to wait until all prerequisite grids in flight 
///     have completed and all the memory operations from the prerequisite grids 
///     are performed and made visible to the current grid.
/// 
///     When the $kind is launch_dependents, it signals that specific dependents 
///     the runtime system designated to react to this instruction can be scheduled 
///     as soon as all other CTAs in the grid issue the same instruction or have 
///     completed.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-griddepcontrol)
class GriddepcontrolOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Inline PTX Op
/// This op allows using PTX directly within the NVVM 
///     dialect, while greatly simplifying llvm.inline_asm generation. It 
///     automatically handles register size selection and sets the correct 
///     read/write access for each operand. The operation leverages the 
///     `BasicPtxBuilderInterface` to abstract away low-level details of 
///     PTX assembly formatting.
/// 
///     The `predicate` attribute is used to specify a predicate for the 
///     PTX instruction.
/// 
///     Example 1: Read-only Parameters
///     ```mlir
///     nvvm.inline_ptx "mbarrier.init.b64 [$0], $1;" (%barrier_gen, %count) : !llvm.ptr, i32
/// 
///     // Lowers to:
///     llvm.inline_asm has_side_effects asm_dialect = att 
///       "mbarrier.init.b64 [$0], $1;", "l,r" %arg0, %arg2 : (!llvm.ptr, i32) -> ()
///     ```
/// 
///     Example 2: Read-only and Write-only Parameters
///     ```mlir
///     %0 = nvvm.inline_ptx "ex2.approx.ftz.f32 $0, $1;" (%input) : f32 -> f32
/// 
///     // Lowers to:
///     %0 = llvm.inline_asm has_side_effects asm_dialect = att 
///       "ex2.approx.ftz.f32 $0, $1;", "=f,f" %arg0 : (f32) -> f32
///     ```
/// 
///     Example 3: Predicate Usage
///     ```mlir
///     nvvm.inline_ptx "mbarrier.init.b64 [$0], $1;" (%barrier_gen, %count), 
///       predicate = %pred : !llvm.ptr, i32, i1
/// 
///     // Lowers to:
///     llvm.inline_asm has_side_effects asm_dialect = att 
///       "@$2 mbarrier.init.b64 [$0], $1;", "l,r,b" %arg0, %arg2, %arg3 
///       : (!llvm.ptr, i32, i1) -> ()
///     ```
class InlinePtxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneIdOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneMaskEqOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneMaskGeOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneMaskGtOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneMaskLeOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class LaneMaskLtOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative matrix load
class LdMatrixOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier arrive_drop with expected transaction count
/// The `nvvm.mbarrier.arrive_drop.expect_tx` operation is similar to the
///     `nvvm.mbarrier.arrive.expect_tx` operation except that it performs an
///     `arrive_drop` operation instead of only an `arrive` operation.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive-drop)
class MBarrierArriveDropExpectTxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Arrive-Drop No-Complete Operation
/// The `nvvm.mbarrier.arrive_drop.nocomplete` operation decrements the expected
///     arrival count of the *mbarrier object* by the amount `count` and then performs
///     an arrive-on operation on the *mbarrier object* with the guarantee that it
///     will not cause the barrier to complete its current phase.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive-drop)
class MBarrierArriveDropNocompleteOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Arrive-Drop Operation
/// The `nvvm.mbarrier.arrive_drop` operation decrements the expected arrival
///     count of the *mbarrier object* by `count` and then performs an arrive-on
///     operation. When `count` is not specified, it defaults to 1. The decrement
///     of the expected arrival count applies to all the subsequent phases of the
///     *mbarrier object*. The remaining semantics are identical to those of the
///     `nvvm.mbarrier.arrive` operation.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive-drop)
class MBarrierArriveDropOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Arrive with Expected Transaction Count
/// The `nvvm.mbarrier.arrive.expect_tx` operation performs an expect-tx operation 
///     followed by an arrive-on operation on the *mbarrier object*. Uses the default 
///     `.release.cta` semantics. This release pattern establishes memory ordering for 
///     operations occurring in program order before this arrive instruction by making 
///     operations from the current thread visible to subsequent operations in other 
///     threads within the CTA. When other threads perform corresponding acquire operations 
///     (like 'mbarrier.test.wait'), they synchronize with this release pattern.
/// 
///     This operation first performs an expect-tx operation with the specified transaction
///     count, then performs an arrive-on operation with an implicit count of 1. The
///     expect-tx operation increases the expect-count of the *mbarrier object* by the
///     specified value (i.e. `txcount`), setting the current phase to expect and track
///     the completion of additional asynchronous transactions.
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. Uses generic 
///       addressing, but the address must still be in the shared memory space.
///     - `txcount`: An unsigned integer specifying the expected transaction count 
///       for the expect-tx operation. This represents the number of asynchronous transactions 
///       expected to complete before the barrier phase completes.
///     - `scope`: This specifies the set of threads that directly observe the memory
///       synchronizing effect of the `mbarrier.test.wait` operation.
///     - `relaxed`: When set to true, the `arrive` operation has relaxed memory semantics
///       and does not provide any ordering or visibility guarantees.
///     - `predicate`: Optional predicate for conditional execution used only when lowering to
///       inline-ptx.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive-drop)
class MBarrierArriveExpectTxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Arrive No-Complete Operation
/// The `nvvm.mbarrier.arrive.nocomplete` operation performs an arrive-on operation 
///     on the *mbarrier object* with the guarantee that it will not cause the barrier to 
///     complete its current phase. Uses the default `.release.cta` semantics. This release 
///     pattern establishes memory ordering for operations occurring in program order before 
///     this arrive instruction by making operations from the current thread visible to 
///     subsequent operations in other threads within the CTA. When other threads perform 
///     corresponding acquire operations (like 'mbarrier.test.wait'), they synchronize with 
///     this release pattern.
/// 
///     This operation causes the executing thread to signal its arrival at the barrier 
///     with a specified count, but ensures that the barrier phase will not complete as 
///     a result of this operation. The operation returns an opaque value that 
///     captures the phase of the *mbarrier object* prior to the arrive-on operation.
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. The `addr`
///       must be a pointer to generic or shared::cta memory. When it is generic, the
///       underlying address must be within the shared::cta memory space; otherwise
///       the behavior is undefined.
///     - `count`: Integer specifying the count argument to the arrive-on operation. 
///       Must be in the valid range as specified in the *mbarrier object* contents.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive)
class MBarrierArriveNocompleteOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Arrive Operation
/// The `nvvm.mbarrier.arrive` operation performs an arrive-on operation on the 
///     *mbarrier object* at the specified address. Uses the default `.release.cta` semantics. 
///     This release pattern establishes memory ordering for operations occurring in program 
///     order before this arrive instruction by making operations from the current thread 
///     visible to subsequent operations in other threads within the CTA. When other threads 
///     perform corresponding acquire operations (like 'mbarrier.test.wait'), they synchronize 
///     with this release pattern.
/// 
///     This operation causes the executing thread to signal its arrival at the barrier.
/// 
///     - `res`: When the `space` is not shared_cluster, this operation returns an
///       opaque 64-bit value capturing the phase of the *mbarrier object* prior to
///       the arrive-on operation. The contents of this return value are
///       implementation-specific. An *mbarrier object* located in the shared_cluster
///       space cannot return a value.
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. The `addr`
///       must be a pointer to generic or shared_cta or shared_cluster memory. When it
///       is generic, the underlying address must be within the shared_cta memory space;
///       otherwise the behavior is undefined.
///     - `count`: This specifies the amount by which the pending arrival count is
///       decremented. If the `count` argument is not specified, the pending arrival
///       count is decremented by 1.
///     - `scope`: This specifies the set of threads that directly observe the memory
///       synchronizing effect of the `mbarrier.arrive` operation.
///     - `space`: This indicates the memory space where the mbarrier object resides.
///     - `relaxed`: When set to true, the `arrive` operation has relaxed memory semantics
///       and does not provide any ordering or visibility guarantees.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-arrive)
class MBarrierArriveOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier complete-tx Operation
/// The `nvvm.mbarrier.complete_tx` operation decrements the transaction
///     count of the *mbarrier object* at `addr` by `txcount`. It also signals
///     the completion of asynchronous transactions that were tracked by the
///     current phase. The `scope` specifies the set of threads that can directly
///     observe the memory synchronizing effect of the `mbarrier.complete_tx`
///     operation. `CTA` and `CLUSTER` are the only allowed values for `scope`.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-complete-tx)
class MBarrierCompleteTxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier expect-tx Operation
/// The `nvvm.mbarrier.expect_tx` operation increases the transaction count
///     of the mbarrier located at `addr` by `txcount` amount. The `scope`
///     specifies the set of threads that can directly observe the memory
///     synchronizing effect of the `mbarrier.expect_tx` operation. `CTA`
///     and `CLUSTER` are the only allowed values for `scope`.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-expect-tx)
class MBarrierExpectTxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Initialization Op
/// The `nvvm.mbarrier.init` operation initializes an *mbarrier object* at the specified 
///     memory location. 
/// 
///     This operation initializes the *mbarrier object* with the following state:
///     - Current phase: 0
///     - Expected arrival count: `count`
///     - Pending arrival count: `count`  
///     - Transaction count (tx-count): 0
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. The `addr`
///       must be a pointer to generic or shared::cta memory. When it is generic, the
///       underlying address must be within the shared::cta memory space; otherwise
///       the behavior is undefined.
///     - `count`: Integer specifying the number of threads that will participate in barrier
///       synchronization. Must be in the range [1, 2²⁰ - 1].
///     - `predicate`: Optional predicate for conditional execution.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-init)
class MBarrierInitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Invalidation Operation
/// The `nvvm.mbarrier.inval` operation invalidates an *mbarrier object* at the 
///     specified memory location. 
/// 
///     This operation marks the *mbarrier object* as invalid, making it safe to repurpose 
///     the memory location for other uses or to reinitialize it as a new *mbarrier object*.
///     It is undefined behavior if the *mbarrier object* is already invalid.
///     
///     The operation takes the following operand:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. The `addr`
///       must be a pointer to generic or shared::cta memory. When it is generic, the
///       underlying address must be within the shared::cta memory space; otherwise
///       the behavior is undefined.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-mbarrier-inval)
class MBarrierInvalOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Non-Blocking Test Wait Operation
/// The `nvvm.mbarrier.test.wait` operation performs a non-blocking test for the
///     completion of a specific phase of an *mbarrier object*. It uses the default
///     `.acquire.cta` semantics. This acquire pattern establishes memory ordering for
///     operations occurring in program order after this wait instruction by making
///     operations from other threads in the CTA visible to subsequent operations in the current
///     thread. When this wait completes, it synchronizes with the corresponding release
///     pattern from the `mbarrier.arrive` operation, establishing memory ordering within
///     the CTA.
/// 
///     This operation tests whether the mbarrier phase specified by the state operand
///     has completed. It is a non-blocking instruction that immediately returns the
///     completion status without suspending the executing thread.
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. Uses generic
///       addressing, but the address must still be in the shared memory space.
///     - `stateOrPhase`: This argument represents a `state` when it is a 64-bit value
///       and represents a `phase` when it is a 32-bit value. The `state` is an opaque
///       value returned by a previous `mbarrier.arrive` operation on the same
///       *mbarrier object* during the current or immediately preceding phase.
///       The `phase` is an integer specifying the phase parity (0 or 1).
///       Even phases have parity 0, odd phases have parity 1.
///     - `scope`: This specifies the set of threads that directly observe the memory
///       synchronizing effect of the `mbarrier.test.wait` operation.
///     - `relaxed`: When set to true, the `arrive` operation has relaxed memory semantics
///       and does not provide any ordering or visibility guarantees.
/// 
///     The operation returns a boolean value indicating whether the specified phase 
///     has completed:
///     - `true`: The immediately preceding phase has completed
///     - `false`: The phase is still incomplete (current phase)
/// 
///     **Memory ordering guarantees**: When this wait returns true, the following 
///     ordering guarantees hold:
/// 
///     1. All memory accesses (except async operations) requested prior to
///        `mbarrier.arrive` having release semantics by participating CTA threads
///        are visible to the executing thread.
///     2. All `cp.async` operations requested prior to `cp.async.mbarrier.arrive`
///        by participating CTA threads are visible to the executing thread.
///     3. All `cp.async.bulk` operations using the same *mbarrier object* requested
///        prior to `mbarrier.arrive` having release semantics by participating CTA
///        threads are visible to the executing thread.
///     4. Memory accesses requested after this wait are not visible to memory
///        accesses performed prior to `mbarrier.arrive` by other participating
///        threads.
///     5. No ordering guarantee exists for memory accesses by the same thread
///        between `mbarrier.arrive` and this wait.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-mbarrier-test-wait-try-wait)
class MBarrierTestWaitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier try wait on state or phase with an optional timelimit
/// The `nvvm.mbarrier.try_wait` operation checks whether the specified
///     *mbarrier object* at `addr` has completed the given phase. Note that
///     unlike the `nvvm.mbarrier.test.wait` operation, the try_wait operation
///     is a potentially-blocking one. If the phase is not yet complete, the
///     calling thread may be suspended. A suspended thread resumes execution
///     once the phase completes or when a system-defined timeout occurs.
///     Optionally, the `ticks` operand can be used to provide a custom timeout
///     (in nanoseconds), overriding the system-defined one. The semantics of
///     this operation and its operands are otherwise similar to those of the
///     `nvvm.mbarrier.test.wait` Op.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-mbarrier-test-wait-try-wait)
class MBarrierTryWaitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// MBarrier Potentially-Blocking Try Wait with Phase Parity
/// The `nvvm.mbarrier.try_wait.parity` operation performs a potentially-blocking 
///     test for the completion of a specific phase of an *mbarrier object* using phase 
///     parity. It uses the default `.acquire.cta` semantics. This acquire pattern 
///     establishes memory ordering for operations occurring in program order after this 
///     wait instruction by making operations from other threads in the CTA visible to subsequent 
///     operations in the current thread. When this wait completes, it synchronizes with 
///     the corresponding release pattern from the `mbarrier.arrive` operation, establishing 
///     memory ordering within the CTA.
/// 
///     This operation waits for the completion of the mbarrier phase indicated by the 
///     phase parity. While it uses the underlying PTX `mbarrier.try_wait.parity` 
///     instruction, this MLIR operation generates a loop that enforces the test to 
///     complete before continuing execution, ensuring the barrier phase is actually 
///     completed rather than potentially timing out.
/// 
///     The operation takes the following operands:
///     - `addr`: A pointer to the memory location of the *mbarrier object*. Uses generic 
///       addressing, but the address must still be in the shared memory space.
///     - `phase`: An integer specifying the phase parity (0 or 1). Even phases 
///       have parity 0, odd phases have parity 1.
///     - `ticks`: An unsigned integer specifying the suspend time hint in 
///       nanoseconds. This may be used instead of the system-dependent time limit.
/// 
///     **Memory ordering guarantees**: When this wait returns true, the following 
///     ordering guarantees hold:
/// 
///     1. All memory accesses (except async operations) requested prior to
///        `mbarrier.arrive` having release semantics by participating CTA threads
///        are visible to the executing thread.
///     2. All `cp.async` operations requested prior to `cp.async.mbarrier.arrive`
///        by participating CTA threads are visible to the executing thread.
///     3. All `cp.async.bulk` operations using the same *mbarrier object* requested
///        prior to `mbarrier.arrive` having release semantics by participating CTA
///        threads are visible to the executing thread.
///     4. Memory accesses requested after this wait are not visible to memory
///        accesses performed prior to `mbarrier.arrive` by other participating
///        threads.
///     5. No ordering guarantee exists for memory accesses by the same thread
///        between `mbarrier.arrive` and this wait.
/// 
///     **Implementation behavior**:
///     This operation generates a PTX loop that repeatedly calls the underlying 
///     `mbarrier.try_wait.parity` instruction until the barrier phase completes. 
///     Unlike the raw PTX instruction which may return without completion after a 
///     timeout, this MLIR operation guarantees completion by continuing to loop until 
///     the specified phase is reached.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-mbarrier-test-wait-try-wait)
class MBarrierTryWaitParityOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class MapaOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Broadcast and compare a value across threads in warp
/// The `match.sync` op performs broadcast and compare of operand `val` across 
///     all non-exited threads in `thread_mask` and returns a mask depending on the 
///     kind and an optional predicate.
/// 
///     The matching operation kinds are:
///     - `any`: Returns a mask corresponding to the non-exited threads in the 
///     `thread_mask` that have the same value of operand `val`.
///     - `all`: Returns a mask and a predicate. If all non-exited threads in the 
///     `thread_mask` have the same value of operand `val`, the predicate is set to 
///     true and the mask corresponds to the non-exited threads in the 
///     `thread_mask`. Otherwise, the predicate is set to false and the mask is 0.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-match-sync)
class MatchSyncOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Memory barrier operation
/// `membar` operation guarantees that prior memory accesses requested by this
///     thread are performed at the specified `scope`, before later memory
///     operations requested by this thread following the membar instruction.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-membar)
class MembarOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative matrix-multiply and accumulate with block scaling
/// The `nvvm.mma.block_scale` operation collectively performs the operation
///     `D = matmul(A * SF_A, B * SF_B) + C` using all threads in a warp.
/// 
///     A, B, C and D are dense matrices and SF_A and SF_B are scaling factors.
///     Dimensions of SF_A and SF_B are based on scale vector sizes (x1, x2, x4),
///     and the data type must be either ue8m0 or ue4m3.
/// 
///     All the threads in the warp must execute the same `mma.block_scale` operation.
/// 
///     This operation follows the same design pattern as `nvvm.mma.sync`, with additional
///     scaling operands for both A and B matrices.
/// 
///     Example:
///     ```mlir
///     %d = nvvm.mma.block_scale A[%a0, %a1] B[%b0, %b1] C[%c0, %c1]
///                               scaleA[%scaleAData, %byteIdA, %threadIdA]
///                               scaleB[%scaleBData, %byteIdB, %threadIdB]
///                               {shape = #nvvm.shape<m = 16, n = 8, k = 64>,
///                                multiplicandAPtxType = #nvvm.mma_type<e2m1>,
///                                multiplicandBPtxType = #nvvm.mma_type<e2m1>,
///                                scaleVecSize = #nvvm.scale_vec_size<x2>,
///                                blockScaleFormat = #nvvm.block_scale_format<ue8m0>,
///                                kind = #nvvm.block_scale_kind<mxf4nvf4>}
///         : (vector<4xf16>, vector<2xf16>, vector<2xf32>) -> !llvm.struct<(f32, f32)>
///     ```
class MmaBlockScaleOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative matrix-multiply and accumulate
/// The `nvvm.mma.sync` operation collectively performs the operation
///     `D = matmul(A, B) + C` using all threads in a warp.
/// 
///     All the threads in the warp must execute the same `mma.sync` operation.
/// 
///     For each possible multiplicand PTX data type, there are one or more possible
///     instruction shapes given as "mMnNkK". The below table describes the posssibilities
///     as well as the types required for the operands. Note that the data type for
///     C (the accumulator) and D (the result) can vary independently when there are
///     multiple possibilities in the "C/D Type" column.
/// 
///     When an optional attribute cannot be immediately inferred from the types of
///     the operands and the result during parsing or validation, an error will be
///     raised.
/// 
///     `b1Op` is only relevant when the binary (b1) type is given to
///     `multiplicandDataType`. It specifies how the multiply-and-acumulate is
///     performed and is either `xor_popc` or `and_poc`. The default is `xor_popc`.
/// 
///     `intOverflowBehavior` is only relevant when the `multiplicandType` attribute
///     is one of `u8, s8, u4, s4`, this attribute describes how overflow is handled
///     in the accumulator. When the attribute is `satfinite`, the accumulator values
///     are clamped in the int32 range on overflow. This is the default behavior.
///     Alternatively, accumulator behavior `wrapped` can also be specified, in
///     which case overflow wraps from one end of the range to the other.
/// 
///     `layoutA` and `layoutB` are required and should generally be set to
///     `#nvvm.mma_layout<row>` and `#nvvm.mma_layout<col>` respectively, but other
///     combinations are possible for certain layouts according to the table below.
/// 
///     ```
///     | A/B Type | Shape     | ALayout | BLayout | A Type   | B Type   | C/D Type          |
///     |----------|-----------|---------|---------|----------|----------|-------------------|
///     | f64      | .m8n8k4   | row     | col     | 1x f64   | 1x f64   | 2x f64            |
///     | f16      | .m8n8k4   | row/col | row/col | 2x f16x2 | 2x f16x2 | 4x f16x2 or 8xf32 |
///     |          | .m16n8k8  | row     | col     | 2x f16x2 | 1x f16x2 | 2x f16x2 or 4 f32 |
///     |          | .m16n8k16 | row     | col     | 4x f16x2 | 2x f16x2 | 2x f16x2 or 4 f32 |
///     | bf16     | .m16n8k8  | row     | col     | 2x i32   | 1x i32   | 4x f32            |
///     |          | .m16n8k16 | row     | col     | 4x i32   | 2x i32   | 4x f32            |
///     | tf32     | .m16n8k4  | row     | col     | 2x i32   | 1x i32   | 4x f32            |
///     |          | .m16n8k8  | row     | col     | 4x i32   | 2x i32   | 2x f16x2 or 4 f32 |
///     | u8/s8    | .m8n8k16  | row     | col     | 1x i32   | 1x i32   | 2x i32            |
///     |          | .m16n8k16 | row     | col     | 2x i32   | 1x i32   | 4x i32            |
///     |          | .m16n8k32 | row     | col     | 4x i32   | 2x i32   | 4x i32            |
///     | u4/s4    | .m8n8k32  | row     | col     | 1x i32   | 1x i32   | 2x i32            |
///     |          | m16n8k32  | row     | col     | 2x i32   | 1x i32   | 4x i32            |
///     |          | m16n8k64  | row     | col     | 4x i32   | 2x i32   | 4x i32            |
///     | b1       | m8n8k128  | row     | col     | 1x i32   | 1x i32   | 2x i32            |
///     |          | m16n8k128 | row     | col     | 2x i32   | 1x i32   | 4x i32            |
///     ```
/// 
/// 
///     Example:
///     ```mlir
/// 
///     %128 = nvvm.mma.sync A[%120, %121, %122, %123]
///                          B[%124, %125]
///                          C[%126, %127]
///                          {layoutA = #nvvm.mma_layout<row>,
///                           layoutB = #nvvm.mma_layout<col>,
///                           shape = {k = 16 : i32, m = 16 : i32, n = 8 : i32}}
///         : (vector<2xf16>, vector<2xf16>, vector<2xf16>)
///            -> !llvm.struct<(vector<2xf16>, vector<2xf16>)>
///     ```
class MmaOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative sparse matrix-multiply and accumulate with block scaling
/// The `nvvm.mma.sp.block_scale` operation collectively performs the operation
///     `D = matmul(A_sparse * SF_A, B * SF_B) + C` using all threads in a warp.
/// 
///     A is a sparse matrix, and B, C and D are dense matrices.
///     SF_A and SF_B are scaling factors.
///     Dimensions of SF_A and SF_B are based on scale vector sizes (x1, x2, x4),
///     and the data type must be either ue8m0 or ue4m3.
/// 
///     This operation is similar to `nvvm.mma.block_scale` but with structured sparsity
///     in the A operand. The sparsity follows the 2:4 structured sparse pattern
///     where 2 out of every 4 elements are non-zero.
/// 
///     All the threads in the warp must execute the same `mma.sp.block_scale` operation.
/// 
///     The `sparseMetadata` operand provides the sparsity indices that indicate
///     which elements in the A operand are non-zero. The `sparsitySelector`
///     controls how the indices are distributed among threads in the warp and
///     should typically be 0 or 1.
/// 
///     This operation follows the same design pattern as `nvvm.mma.sp.sync`, with additional
///     scaling operands for both A and B matrices. Note that sparse block scale operations
///     always use ordered metadata (sm_90+).
/// 
///     Example:
///     ```mlir
///     %d = nvvm.mma.sp.block_scale A[%a0, %a1] B[%b0, %b1] C[%c0, %c1]
///                                  sparseMetadata[%meta] selector[%sel]
///                                  scaleA[%scaleAData, %byteIdA, %threadIdA]
///                                  scaleB[%scaleBData, %byteIdB, %threadIdB]
///                                  {shape = #nvvm.shape<m = 16, n = 8, k = 128>,
///                                   multiplicandAPtxType = #nvvm.mma_type<e2m1>,
///                                   multiplicandBPtxType = #nvvm.mma_type<e2m1>,
///                                   scaleVecSize = #nvvm.scale_vec_size<x2>,
///                                   blockScaleFormat = #nvvm.block_scale_format<ue8m0>,
///                                   kind = #nvvm.block_scale_kind<mxf4>}
///         : (vector<2xf16>, vector<2xf16>, vector<2xf32>) -> !llvm.struct<(f32, f32)>
///     ```
class MmaSpBlockScaleOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative sparse matrix-multiply and accumulate
/// The `nvvm.mma.sp.sync` operation collectively performs the sparse operation
///     `D = matmul(A_sparse, B) + C` using all threads in a warp.
/// 
///     This operation is similar to `nvvm.mma.sync` but with structured sparsity
///     in the A operand. The sparsity follows the 2:4 structured sparse pattern
///     where 2 out of every 4 elements are non-zero.
/// 
///     All the threads in the warp must execute the same `mma.sp.sync` operation.
/// 
///     The `sparseMetadata` operand provides the sparsity indices that indicate
///     which elements in the A operand are non-zero. The `sparsitySelector`
///     controls how the indices are distributed among threads in the warp and
///     should typically be 0 or 1.
/// 
///     The optional `orderedMetadata` attribute specifies the metadata ordering:
///     - Absence (default): Uses standard sparse metadata ordering
///     - Presence: Uses ordered metadata (PTX ISA 8.5+, sm_90+)
/// 
///     The optional `kind` attribute specifies mixed-precision modes for FP8 operations:
///     - `f8f6f4`: Enables e3m2, e2m3, e2m1 FP8 types and f16 accumulator (PTX ISA 8.7+, sm_90+)
///     - Only valid with ordered metadata and m16n8k64 shape
/// 
///     The shapes, layouts, and data types follow the same constraints as the
///     regular `nvvm.mma.sync` operation, but the A operand contains only the
///     non-zero elements in compressed format.
/// 
///     Example:
///     ```mlir
///     %d = nvvm.mma.sp.sync A[%a0, %a1] B[%b0, %b1] C[%c0, %c1]
///                           sparseMetadata[%meta] selector[%sel]
///                           {shape = {k = 32 : i32, m = 16 : i32, n = 8 : i32}}
///         : (vector<2xf16>, vector<2xf16>, vector<2xf16>) -> !llvm.struct<(vector<2xf16>, vector<2xf16>)>
/// 
///     // With ordered metadata:
///     %d = nvvm.mma.sp.sync A[%a0, %a1] B[%b0, %b1] C[%c0, %c1]
///                           sparseMetadata[%meta] selector[%sel]
///                           {orderedMetadata, shape = {k = 32 : i32, m = 16 : i32, n = 8 : i32}}
///         : (vector<2xf16>, vector<2xf16>, vector<2xf16>) -> !llvm.struct<(vector<2xf16>, vector<2xf16>)>
///     ```
class MmaSpOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Suspends the thread for a specified duration.
/// The op suspends the thread for a sleep duration approximately close to the 
///     delay `$duration`, specified in nanoseconds. 
/// 
///     The sleep duration is approximated, but guaranteed to be in the 
///     interval [0, 2*t]. The maximum sleep duration is 1 millisecond. 
///     The implementation may reduce the sleep duration for individual threads 
///     within a warp such that all sleeping threads in the warp wake up together.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#miscellaneous-instructions-nanosleep)
class NanosleepOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Trigger one or more Performance Monitor events.
/// Triggers one or more of a fixed number of performance monitor events, with
///     event index or mask specified by immediate operand.
/// 
///     Without `mask` it triggers a single performance monitor event indexed by
///     immediate operand a, in the range 0..15.
/// 
///     With `mask` it triggers one or more of the performance monitor events. Each
///     bit in the 16-bit immediate operand controls an event.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#miscellaneous-instructions-pmevent)
class PMEventOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Permute bytes from two 32-bit registers
/// The `nvvm.prmt` operation constructs a permutation of the
///     bytes of the first one or two operands, selecting based on 
///     the 2 least significant bits of the final operand.
///     
///     The bytes in the first one or two source operands are numbered. 
///     The first source operand (%lo) is numbered {b3, b2, b1, b0}, 
///     in the case of the '``default``', '``f4e``' and '``b4e``' variants, 
///     the second source operand (%hi) is numbered {b7, b6, b5, b4}.
/// 
///     Modes:
///     - `default`: Index mode         - each nibble in `selector` selects a byte from the 8-byte pool
///     - `f4e`    : Forward 4 extract  - extracts 4 contiguous bytes starting from position in `selector`
///     - `b4e`    : Backward 4 extract - extracts 4 contiguous bytes in reverse order
///     - `rc8`    : Replicate 8        - replicates the lower 8 bits across the 32-bit result
///     - `ecl`    : Edge clamp left    - clamps out-of-range indices to the leftmost valid byte
///     - `ecr`    : Edge clamp right   - clamps out-of-range indices to the rightmost valid byte  
///     - `rc16`   : Replicate 16       - replicates the lower 16 bits across the 32-bit result
/// 
///     Depending on the 2 least significant bits of the %selector operand, the result
///     of the permutation is defined as follows:
/// 
///     +------------+----------------+--------------+
///     |    Mode    | %selector[1:0] |    Output    |
///     +------------+----------------+--------------+
///     | '``f4e``'  | 0              | {3, 2, 1, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {4, 3, 2, 1} |
///     |            +----------------+--------------+
///     |            | 2              | {5, 4, 3, 2} |
///     |            +----------------+--------------+
///     |            | 3              | {6, 5, 4, 3} |
///     +------------+----------------+--------------+
///     | '``b4e``'  | 0              | {5, 6, 7, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {6, 7, 0, 1} |
///     |            +----------------+--------------+
///     |            | 2              | {7, 0, 1, 2} |
///     |            +----------------+--------------+
///     |            | 3              | {0, 1, 2, 3} |
///     +------------+----------------+--------------+
///     | '``rc8``'  | 0              | {0, 0, 0, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {1, 1, 1, 1} |
///     |            +----------------+--------------+
///     |            | 2              | {2, 2, 2, 2} |
///     |            +----------------+--------------+
///     |            | 3              | {3, 3, 3, 3} |
///     +------------+----------------+--------------+
///     | '``ecl``'  | 0              | {3, 2, 1, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {3, 2, 1, 1} |
///     |            +----------------+--------------+
///     |            | 2              | {3, 2, 2, 2} |
///     |            +----------------+--------------+
///     |            | 3              | {3, 3, 3, 3} |
///     +------------+----------------+--------------+
///     | '``ecr``'  | 0              | {0, 0, 0, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {1, 1, 1, 0} |
///     |            +----------------+--------------+
///     |            | 2              | {2, 2, 1, 0} |
///     |            +----------------+--------------+
///     |            | 3              | {3, 2, 1, 0} |
///     +------------+----------------+--------------+
///     | '``rc16``' | 0              | {1, 0, 1, 0} |
///     |            +----------------+--------------+
///     |            | 1              | {3, 2, 3, 2} |
///     |            +----------------+--------------+
///     |            | 2              | {1, 0, 1, 0} |
///     |            +----------------+--------------+
///     |            | 3              | {3, 2, 3, 2} |
///     +------------+----------------+--------------+
///     
///     [For more information, see PTX ISA]
///     (https://docs.nvidia.com/cuda/parallel-thread-execution/#data-movement-and-conversion-instructions-prmt)
class PermuteOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Brings the cache line containing an address into the specified cache level
/// Prefetches the cache line containing the address given by `addr`. The 
///     operand may be a global, local, or generic pointer. When `tensormap` is 
///     specified, the operand may instead be a constant or generic pointer. If the 
///     address maps to shared memory, the operation has no effect.
/// 
///     At most one of `cacheLevel` or `tensormap` may be present. The `cacheLevel` 
///     attribute selects the target cache level. When combined with `uniform`, the 
///     prefetch is performed to the uniform cache, in which case `addr` must be a 
///     generic pointer.
/// 
///     When `tensormap` is used, the line containing `addr` is brought from the 
///     constant or parameter state space for later use by `cp.async.bulk.tensor`. 
///     If `in_param_space` is specified, the generic pointer is interpreted as 
///     referring to the parameter state space.
/// 
///     `uniform` can be specified after the `cacheLevel` to indicate that the 
///     prefetch is performed to the specified uniform cache level. If `uniform` is 
///     specified, `addr` must be a generic address pointer and no operation is 
///     performed if `addr` maps to a `const`, `local`, or `shared` memory location.
/// 
///     The `evictPriority` attribute is optional and specifies the cache eviction
///     priority when `cacheLevel` is L2.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#data-movement-and-conversion-instructions-prefetch-prefetchu)
class PrefetchOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class RcpApproxFtzF32Op;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Redux Sync Op
/// `redux.sync` performs a reduction operation `kind` of the 32 bit source 
///     register across all non-exited threads in the membermask.
/// 
///     The `abs` and `nan` attributes can be used in the case of f32 input type, 
///     where the `abs` attribute causes the absolute value of the input to be used 
///     in the reduction operation, and the `nan` attribute causes the reduction 
///     operation to return NaN if any of the inputs to participating threads are 
///     NaN.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-redux-sync)
class ReduxOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class SetMaxRegisterOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// NVVM Dialect Op for shfl.sync
/// The `shfl.sync` Op implements data shuffle within threads of a warp.
///     The `thread_mask` denotes the threads participating in the Op where
///     the bit position corresponds to a particular thread's laneid.
///     The `offset` specifies a source lane or source lane offset
///     (depending on `kind`). The `val` is the input value to be copied from
///     the source. The `mask_and_clamp` contains two packed values specifying
///     a mask for logically splitting warps into sub-segments and an upper bound
///     for clamping the source lane index.
///     
///     The `return_value_and_is_valid` unit attribute can be specified to indicate 
///     that the return value is a two-element struct, where the first element is 
///     the result value and the second element is a predicate indicating if the 
///     computed source lane index is valid.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#data-movement-and-conversion-instructions-shfl-sync)
class ShflOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class SmDimOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class SmIdOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// cooperative matrix store
/// Collectively store one or more matrices across all threads in a warp to the
///     location indicated by the address operand $ptr in shared memory.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#warp-level-matrix-store-instruction-stmatrix)
class StMatrixOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Warp Barrier Synchronization Op
/// The `nvvm.bar.warp.sync` operation performs barrier synchronization for threads 
///     within a warp. 
/// 
///     This operation causes the executing thread to wait until all threads corresponding 
///     to the `mask` operand have executed a `bar.warp.sync` with the same mask value 
///     before resuming execution.
/// 
///     The `mask` operand specifies the threads participating in the barrier, where each 
///     bit position corresponds to the thread's lane ID within the warp. Only threads with 
///     their corresponding bit set in the mask participate in the barrier synchronization.
/// 
///     **Important constraints**:
///     - The behavior is undefined if the executing thread is not included in the mask 
///       (i.e., the bit corresponding to the thread's lane ID is not set)
///     - For compute capability sm_6x or below, all threads in the mask must execute 
///       the same `bar.warp.sync` instruction in convergence
/// 
///     This operation also guarantees memory ordering among participating threads. 
///     Threads within the warp that wish to communicate via memory can store to memory, 
///     execute `bar.warp.sync`, and then safely read values stored by other threads 
///     in the warp.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#parallel-synchronization-and-communication-instructions-bar-warp-sync)
class SyncWarpOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 alloc operation
/// The `tcgen05.alloc` Op allocates tensor core memory for
///     the amount specified by `nCols` and writes the destination
///     address to the `addr` argument. The `nCols` operand specifies the
///     number of columns to be allocated and it must be a power-of-two.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-memory-alloc-manage-instructions)
class Tcgen05AllocOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 commit operations
/// The `tcgen05.commit` makes the *mbarrier object*, specified by
///     the operand `addr`, track the completion of all the prior
///     async-tcgen05 operations initiated by the executing thread.
///     The multicast variants allow signaling on the *mbarrier objects*
///     of multiple CTAs within the cluster. Operand `multicastMask`,
///     when present, specifies the destination CTAs in the cluster such
///     that each bit position in the 16-bit `multicastMask` operand
///     corresponds to the `nvvm.read.ptx.sreg.ctaid` of the destination CTA.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen-async-sync-operations-commit)
class Tcgen05CommitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 copy operation
/// Instruction tcgen05.cp initiates an asynchronous copy operation from
///     shared memory to the location specified by the address operand `taddr`
///     in the Tensor Memory. The 64-bit register operand `smem_desc` specifies
///     the matrix descriptor representing the source matrix in the shared memory
///     that needs to be copied.
/// 
///     Example:
///     ```mlir
///       nvvm.tcgen05.cp %taddr, %smem_desc {
///         group = #nvvm.tcgen05_group<cta_2>,
///         shape = #nvvm.tcgen05_cp_shape<shape_64x128b>,
///         multicast = #nvvm.tcgen05_cp_multicast<warpx2_01_23>,
///         srcFormat = #nvvm.tcgen05_cp_src_fmt<b6x16_p32>
///       }
///     ```
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tensorcore-5th-generation-instructions-tcgen05-cp)
class Tcgen05CpOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 dealloc operation
/// The `tcgen05.dealloc` Op de-allocates the tensor core memory
///     specified by `tmemAddr`, which must be from a previous tensor
///     memory allocation. The `nCols` operand specifies the number
///     of columns to be de-allocated, and it must be a power-of-two.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-memory-alloc-manage-instructions)
class Tcgen05DeallocOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 fence operations
/// The `tcgen05.fence<before>` orders all prior async tcgen05 operations
///     with respect to the subsequent tcgen05 and execution ordering operations.
///     The `tcgen05.fence<after>` orders all subsequent async tcgen05 operations
///     with respect to the prior tcgen05 and execution ordering operations.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tensorcore-5th-generation-instructions-tcgen05-fence)
class Tcgen05FenceOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// tensor memory load instructions
/// Instruction `tcgen05.ld` asynchronously loads data from the Tensor Memory at
///     the location specified by the 32-bit address operand `tmemAddr` into the
///     destination register `res`, collectively across all threads of the warps.
/// 
///     The `shape` and the `num` attribute together determines the total
///     dimension of the data which is loaded from the Tensor Memory. The `shape`
///     attribute indicates the base dimension of data to be accessed as described
///     in the Data Movement Shape. The `num` attribute indicates the repeat
///     factor on the base dimension resulting in the total dimension of the data
///     that is accessed.
/// 
///     The shape `16x32bx2` performs two accesses into Tensor Memory of the shape
///     `16x32b`. The base address of the first access is specified by `tmemAddr`
///     and the base address of the second access is specified by
///     `tmemAddr + offset`, where `offset` is an immediate argument.
/// 
///     The unit attribute `pack` can be used to pack two 16-bit
///     elements from adjacent columns into a single 32-bit element during the load.
/// 
///     The following table describes the size of the vector for various combinations
///     of `num` and `shape` attributes:
///     ```
///     |=====================================================================|
///     | num/shape      |     16x32bx2/16x64b/32x32b |  16x128b   | 16x256b  |
///     |=====================================================================|
///     | x1             |          1                 |    2       |    4     |
///     | x2             |          2                 |    4       |    8     |
///     | x4             |          4                 |    8       |    16    |
///     | x8             |          8                 |    16      |    32    |
///     | x16            |          16                |    32      |    64    |
///     | x32            |          32                |    64      |    128   |
///     | x64            |          64                |    128     |    NA    |
///     | x128           |          128               |    NA      |    NA    |
///     |=====================================================================|
///     ```
/// 
///     Example:
///     ```mlir
///       nvvm.tcgen05.ld %tmemAddr, %offset pack {
///         shape = #nvvm.tcgen05_ldst_shape<shape_16x32bx2>,
///       } : <2xi32>
///     ```
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instructions-tcgen05-st)
class Tcgen05LdOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs block scaled MMA operation on 5th-gen tensor cores
/// The `tcgen05.mma.block_scale` operation is an asynchronous tensor core instruction
///     that performs matrix multiplication, accumulation with block scaling in a
///     single fused operation. It targets 5th-generation tensor cores, providing
///     developers with fine-grained control over execution and scheduling.
/// 
///     ```
///     D = (A * scale_a)  * (B * scale_b)`      // if `enableInputD` is false
///     D = (A * scale_a)  * (B * scale_b) + D`
///     ```
/// 
///     where:
///     - A is an M x (K / 2) matrix in tensor memory or described using shared memory descriptor
///     - B is a K x N matrix described using shared memory descriptor
///     - D is an M x N accumulator matrix in tensor memory
///     - `scale_a` and `scale_b` are matrices in tensor memory used to scale `A` and `B` respectively
/// 
///     The `shared memory descriptor` can be generated using `tcgen05.mma_smem_desc` Op
/// 
///     - `idesc` is a 32 bit value representing the [Instruction Descriptor](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instruction-descriptor)
/// 
///     Required Attributes:
///     - `kind` is a MMABlockScaleKind attribute
/// 
///     - `ctaGroup` specifies CTA group configuration
///       * cta_1: MMA will be performed on the current thread's CTA
///       * cta_2: MMA will be performed on the current thread and it's peer CTA
/// 
///     Default Attributes:
///     - collectorOp is a Tcgen05MMACollectorOp attribute with matrix A as the collector buffer
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma)
class Tcgen05MMABlockScaleOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs MMA operation on 5th-gen tensor cores
/// The `tcgen05.mma` operation is an asynchronous tensor core instruction that
///     performs matrix multiplication, accumulation in a single fused operation. It
///     targets 5th-generation tensor cores, providing developers with fine-grained
///     control over execution and scheduling.
/// 
///     ```
///     D = A * B + (D * 2^ -scaleInputD)    // if `scaleInputD` is provided
///     D = A * B                            // if `enableInputD` is false
///     D = A * B + D                        // otherwise
///     ```
/// 
///     where:
///     - A is an `M x K` matrix in tensor memory or described using shared memory descriptor
///     - B is a `K x N` matrix described using shared memory descriptor
///     - D is an `M x N` accumulator matrix in tensor memory
/// 
///     The `shared memory descriptor` can be generated using `tcgen05.mma_smem_desc` Op
/// 
///     - idesc is a 32-bit value representing the [Instruction Descriptor](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instruction-descriptor)
/// 
///     Optional Operands:
///     - `scaleInputD` is an Immediate value operand used for scaling D matrix by 2 ^ (-scaleInputD). The valid range is [0, 15]
/// 
///     - `disableOutputLane` is a vector mask for selective output
///       * vector<4 x i32> when ctaGroup is CTA_1
///       * vector<8 x i32> when ctaGroup is CTA_2
/// 
///     Required Attributes:
///     - `kind` is a Tcgen05MMAKind attribute
/// 
///     - `ctaGroup` specifies CTA group configuration
///       * cta_1: MMA will be performed on the current thread's CTA
///       * cta_2: MMA will be performed on the current thread and it's peer CTA
/// 
///     Default Attributes:
///     - collectorOp is a Tcgen05MMACollectorOp attribute with matrix A as the collector buffer
/// 
///     - `aShift` shifts the rows of the A matrix down by one row and can only be
///        applied if A is in tensor memory
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma)
class Tcgen05MMAOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs block scaled MMA operation with sparse A matrix on 5th-gen tensor cores
/// The `tcgen05.mma.sp.block_scale` operation is an asynchronous tensor core
///     instruction that performs matrix multiplication, accumulation with block
///     scaling, and sparse `A` matrix in a single fused operation. It targets
///     5th-generation tensor cores, providing developers with fine-grained control
///     over execution, and scheduling.
/// 
///     ```
///     D = (A * scale_a)  * (B * scale_b)      // if `enableInputD` is specified
///     D = (A * scale_a)  * (B * scale_b) + D  // otherwise
///     ```
/// 
///     where:
///     - A is an M x (K / 2) matrix in tensor memory or described using shared memory descriptor
///     - B is a K x N matrix described using shared memory descriptor
///     - D is an M x N accumulator matrix in tensor memory
///     - `scale_a` and `scale_b` are matrices in tensor memory used to scale `A` and `B` respectively
/// 
///     Other attributes and operands are similar to that of tcgen05.mma.block_scale Op
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma-sp)
class Tcgen05MMASparseBlockScaleOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs MMA operation with sparse A matrix on 5th-gen tensor cores
/// The `tcgen05.mma.sp` operation is an asynchronous tensor core instruction
///     that performs matrix multiplication, accumulation with sparse `A` matrix in
///     a single fused operation. It targets 5th-generation tensor cores, providing
///     developers with fine-grained control over execution and scheduling.
/// 
///     ```
///     D = A * B + (D * 2^ -scaleInputD)    // if `scaleInputD` is provided
///     D = A * B                            // if `enableInputD` is false
///     D = A * B + D                        // otherwise
///     ```
/// 
///     where:
///     - A is an `M x (K / 2)` matrix in tensor memory or described using shared memory descriptor
///     - B is a `K x N` matrix described using shared memory descriptor
///     - D is an `M x N` accumulator matrix in tensor memory
///     - sparseMetadata located in tensor memory specifies the mapping of the `K / 2`
///     non-zero elements to the K elements before performing the MMA operation
/// 
///     Other attributes and operands are similar to that of tcgen05.mma Op
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma-sp)
class Tcgen05MMASparseOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs weight stationary convolution MMA operation on 5th-gen tensor cores
/// The `tcgen05.mma.ws` operation is an asynchronous tensor core instruction
///     that performs weight stationary convolution matrix multiplication, accumulation
///     in a single fused operation. It targets 5th-generation tensor cores, providing
///     developers with fine-grained control over execution, and scheduling.
/// 
///     ```
///     D = A * B`      // if `enableInputD` is false
///     D = A * B + D`  // otherwise
///     ```
/// 
///     where:
///     - A is an `M x K` matrix in tensor memory or described using shared memory descriptor
///     - B is a `K x N` matrix described using shared memory descriptor
///     - D is an `M x N` accumulator matrix in tensor memory
/// 
///     The `shared memory descriptor` can be generated using `tcgen05.mma_smem_desc` Op
/// 
///     - idesc is a 32-bit value representing the [Instruction Descriptor](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instruction-descriptor)
/// 
///     Optional Operands:
///     - zeroColMask is a 64 bit value representing the [Zero-column mask descriptor](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-zero-column-mask-descriptor)
/// 
///     Required Attributes:
///     - `kind` is a Tcgen05MMAKind attribute
/// 
///     Default Valued Attributes:
///     - collectorBBuffer specifies collector buffer for matrix B: b0 (default), b1, b2, b3
/// 
///     - collectorOp is a Tcgen05MMACollectorOp attribute with matrix B as the collector buffer
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma-ws)
class Tcgen05MMAWsOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Performs weight stationary convolution MMA with sparse A matrix on 5th-gen tensor cores
/// The `tcgen05.mma.ws.sp` operation is an asynchronous tensor core instruction
///     that performs weight stationary convolution matrix multiplication, accumulation
///     with sparse `A` matrix in a single fused operation. It targets 5th-generation
///     tensor cores, providing developers with fine-grained control over execution,
///     and scheduling.
/// 
///     ```
///     D = A * B`      // if `enableInputD` is false
///     D = A * B + D`  // otherwise
///     ```
/// 
///     where:
///     - A is an M x (K / 2) matrix in memory or descriptor format
///     - B is a K x N matrix
///     - D is an M x N accumulator matrix
///     - sparseMetadata located in tensor memory specifies the mapping of the `K / 2`
///     non-zero elements to the K elements before performing the MMA operation
/// 
///     Other attributes and operands are similar to that of tcgen05.mma.ws Op
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-mma-instructions-mma-ws-sp)
class Tcgen05MMAWsSparseOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Constructs a Shared Memory descriptor for MMA Operands A or B
/// The `nvvm.tcgen05_mma_smem_desc` constructs a Shared Memory descriptor
///     for tcgen05.mma. This descriptor is a 64-bit value which describes the
///     properties of multiplicand matrix in shared memory including its location
///     in the shared memory of the current CTA.
/// 
///     ```
///     +-----------+------+------------------------------------------------------+
///     | Bit-field | Size | Description                                          |
///     +-----------+------+------------------------------------------------------+
///     | 0-13      | 14   | Matrix start address                                 |
///     | 14-15     | 2    | Reserved                                             |
///     | 16-29     | 14   | Leading dim relative-offset (or) absolute-address    |
///     | 30-31     | 2    | Reserved                                             |
///     | 32-45     | 14   | Stride dimension byte offset                         |
///     | 46-48     | 3    | Fixed constant value of 0b001                        |
///     | 49-51     | 3    | Matrix base offset                                   |
///     | 52        | 1    | Leading dimension stride mode:                       |
///     |           |      |   0: byte offset relative                            |
///     |           |      |   1: byte address absolute                           |
///     | 53-60     | 8    | Fixed constant value of 0xb00000000                  |
///     | 61-63     | 3    | Swizzling mode:                                      |
///     |           |      |   0: No swizzling                                    |
///     |           |      |   1: 128-Byte with 32B atomic swizzling              |
///     |           |      |   2: 128-Byte swizzling                              |
///     |           |      |   4: 64-Byte swizzling                               |
///     |           |      |   6: 32-Byte swizzling                               |
///     |           |      |   (Values 3, 5 and 7 are invalid)                    |
///     +-----------+------+------------------------------------------------------+    
///     ```
/// 
///     Example:
///     ```mlir
///       %desc = nvvm.tcgen05.mma_smem_desc (%startAddr, %leadingDimOffset, %strideDimOffset,
///                                           %baseOffset, %leadingDimMode, %swizzleMode) : (i32, i32, i32, i8, i1, i8) -> i64
///     ```
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-shared-memory-descriptor)
class Tcgen05MmaSmemDescOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 Op to relinquish the right to allocate
/// The `tcgen05.relinquish_alloc_permit` Op specifies that the CTA
///     of the executing thread is relinquishing the right to allocate
///     Tensor Memory. So, it is illegal for a CTA to perform `tcgen05.alloc`
///     after any of its constituent threads execute `tcgen05.relinquish_alloc_permit`.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-memory-alloc-manage-instructions)
class Tcgen05RelinquishAllocPermitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 shift operation
/// The `tcgen05.shift` is an asynchronous instruction which initiates
///     the shifting of 32-byte elements downwards across all the rows,
///     except the last, by one row. The operand `taddr` specifies the base
///     address of the matrix in Tensor Memory whose rows must be down shifted.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instructions-tcgen05-shift)
class Tcgen05ShiftOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// tensor memory store instructions
/// Instruction `tcgen05.st` asynchronously stores data from the source register `r`
///     into the Tensor Memory at the location specified by the 32-bit address operand
///     `tmemAddr`, collectively across all threads of the warps.
/// 
///     The `shape` and the `num` attribute together determines the total dimension of
///     the data which is stored to the Tensor Memory. The `shape` indicates the base
///     dimension of data to be accessed. The `num` attribute indicates the repeat
///     factor on the base dimension resulting in the total dimension of the data that
///     is accessed.
/// 
///     The shape `16x32bx2` performs two accesses into Tensor Memory of the shape
///     `16x32b`. The base address of the first access is specified by `tmemAddr`
///     and the base address of the second access is specified by
///     `tmemAddr + offset`, where `offset` is an immediate argument.
/// 
///     The unit attribute `unpack` can be used to unpack a 32-bit element
///     in the register into two 16-bit elements and store them in adjacent columns.
/// 
///     The following table describes the size of the vector for various combinations
///     of `num` and `shape` attributes:
///     ```
///     |=====================================================================|
///     | num/shape      |     16x32bx2/16x64b/32x32b |  16x128b   | 16x256b  |
///     |=====================================================================|
///     | x1             |          1                 |    2       |    4     |
///     | x2             |          2                 |    4       |    8     |
///     | x4             |          4                 |    8       |    16    |
///     | x8             |          8                 |    16      |    32    |
///     | x16            |          16                |    32      |    64    |
///     | x32            |          32                |    64      |    128   |
///     | x64            |          64                |    128     |    NA    |
///     | x128           |          128               |    NA      |    NA    |
///     |=====================================================================|
///     ```
/// 
///     Example:
///     ```mlir
///       nvvm.tcgen05.st %tmemAddr, %val, %offset unpack {
///         shape = #nvvm.tcgen05_ldst_shape<shape_16x32bx2>,
///       } : <2xi32>
///     ```
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instructions-tcgen05-st)
class Tcgen05StOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Tcgen05 wait operations
/// The `tcgen05.wait<load>` causes the executing thread to block until
///     all prior `tcgen05.ld` operations issued by the executing thread
///     have completed. Similarly, the `tcgen05.wait<store>` causes the executing
///     thread to block until all prior `tcgen05.st` operations issued by the
///     executing thread have completed.
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#tcgen05-instructions-tcgen05-wait)
class Tcgen05WaitOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ThreadIdXOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ThreadIdYOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class ThreadIdZOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class TotalSmemSize;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Vote across thread group
/// The `vote.sync` op will cause executing thread to wait until all non-exited
///     threads corresponding to membermask have executed `vote.sync` with the same
///     qualifiers and same membermask value before resuming execution.
/// 
///     The vote operation kinds are:
///     - `any`: True if source predicate is True for some thread in membermask.
///     - `all`: True if source predicate is True for all non-exited threads in
///       membermask. 
///     - `uni`: True if source predicate has the same value in all non-exited
///       threads in membermask.
///     - `ballot`: In the ballot form, the destination result is a 32 bit integer.
///       In this form, the predicate from each thread in membermask are copied into
///       the corresponding bit position of the result, where the bit position
///       corresponds to the thread's lane id.
/// 
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/#parallel-synchronization-and-communication-instructions-vote-sync)
class VoteSyncOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Warp synchronous matrix load
class WMMALoadOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Warp synchronous matrix-multiply accumulate using tensor cores.
class WMMAMmaOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Warp synchronous matrix store
class WMMAStoreOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class WarpDimOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class WarpIdOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

class WarpSizeOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Enforce an ordering of register accesses between warpgroup level matrix 
///     multiplication and other operations. 
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#asynchronous-warpgroup-level-matrix-instructions-wgmma-fence)
class WgmmaFenceAlignedOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Commits all prior uncommitted warpgroup level matrix multiplication operations.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#asynchronous-warpgroup-level-matrix-instructions-wgmma-commit-group)
class WgmmaGroupSyncAlignedOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// The warpgroup (128 threads) level matrix multiply and accumulate operation 
///     has either of the following forms, where matrix D is called accumulator:
///       D = A * B + D
///       D = A * B, where the input from accumulator D is disabled.
/// 
///     Supported shapes:  
///     ```
///     |--------------|--------------|------------|--------------|---------------|
///     |              |              |            |              |f16+=e4m3*e4m3 |
///     |              |              |            |              |f16+=e5m2*e5m2 |
///     |f32+=tf32*tf32|f16+=f16 *f16 | s32+=s8*s8 |s32 += b1 * b1|f16+=e5m2*e4m3 |
///     |              |f32+=f16 *f16 | s32+=u8*u8 |              |f16+=e4m3*e5m2 |
///     |              |f32+=bf16*bf16| s32+=u8*u8 |              |f16+=e4m3*e5m2 |
///     |              |f32+=bf16*bf16| s32+=s8*u8 |              |f32+=e4m3*e4m3 |
///     |              |              | s32+=u8*s8 |              |f32+=e5m2*e5m2 |
///     |              |              |            |              |f32+=e4m3*e5m2 |
///     |              |              |            |              |f32+=e4m3*e5m2 |
///     |--------------|--------------|------------|--------------|---------------|
///     |   .m64n8k8   |  .m64n8k16   | .m64n8k32  | .m64n8k256   | .m64n8k32     |
///     |   .m64n16k8  |  .m64n16k16  | .m64n16k32 | .m64n16k256  | .m64n16k32    |
///     |   .m64n24k8  |  .m64n24k16  | .m64n24k32 | .m64n24k256  | .m64n24k32    |
///     |   .m64n32k8  |  .m64n32k16  | .m64n32k32 | .m64n32k256  | .m64n32k32    |
///     |   .m64n40k8  |  .m64n40k16  | .m64n48k32 | .m64n48k256  | .m64n40k32    |
///     |   .m64n48k8  |  .m64n48k16  | .m64n64k32 | .m64n64k256  | .m64n48k32    |
///     |   .m64n56k8  |  .m64n56k16  | .m64n80k32 | .m64n80k256  | .m64n56k32    |
///     |   .m64n64k8  |  .m64n64k16  | .m64n96k32 | .m64n96k256  | .m64n64k32    |
///     |   .m64n72k8  |  .m64n72k16  | .m64n112k32| .m64n112k256 | .m64n72k32    |
///     |   .m64n80k8  |  .m64n80k16  | .m64n128k32| .m64n128k256 | .m64n80k32    |
///     |   .m64n88k8  |  .m64n88k16  | .m64n144k32| .m64n144k256 | .m64n88k32    |
///     |   .m64n96k8  |  .m64n96k16  | .m64n160k32| .m64n160k256 | .m64n96k32    |
///     |   .m64n104k8 |  .m64n104k16 | .m64n176k32| .m64n176k256 | .m64n104k32   |
///     |   .m64n112k8 |  .m64n112k16 | .m64n192k32| .m64n192k256 | .m64n112k32   |
///     |   .m64n120k8 |  .m64n120k16 | .m64n208k32| .m64n208k256 | .m64n120k32   |
///     |   .m64n128k8 |  .m64n128k16 | .m64n224k32| .m64n224k256 | .m64n128k32   |
///     |   .m64n136k8 |  .m64n136k16 | .m64n240k32| .m64n240k256 | .m64n136k32   |
///     |   .m64n144k8 |  .m64n144k16 | .m64n256k32| .m64n256k256 | .m64n144k32   |
///     |   .m64n152k8 |  .m64n152k16 |            |              | .m64n152k32   |
///     |   .m64n160k8 |  .m64n160k16 |            |              | .m64n160k32   |
///     |   .m64n168k8 |  .m64n168k16 |            |              | .m64n168k32   |
///     |   .m64n176k8 |  .m64n176k16 |            |              | .m64n176k32   |
///     |   .m64n184k8 |  .m64n184k16 |            |              | .m64n184k32   |
///     |   .m64n192k8 |  .m64n192k16 |            |              | .m64n192k32   |
///     |   .m64n200k8 |  .m64n200k16 |            |              | .m64n200k32   |
///     |   .m64n208k8 |  .m64n208k16 |            |              | .m64n208k32   |
///     |   .m64n216k8 |  .m64n216k16 |            |              | .m64n216k32   |
///     |   .m64n224k8 |  .m64n224k16 |            |              | .m64n224k32   |
///     |   .m64n232k8 |  .m64n232k16 |            |              | .m64n232k32   |
///     |   .m64n240k8 |  .m64n240k16 |            |              | .m64n240k32   |
///     |   .m64n248k8 |  .m64n248k16 |            |              | .m64n248k32   |
///     |   .m64n256k8 |  .m64n256k16 |            |              | .m64n256k32   |
///     |--------------|--------------|------------|--------------|---------------|
///     ```
/// 
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#asynchronous-warpgroup-level-matrix-instructions)
class WgmmaMmaAsyncOp;

} // namespace mlir::NVVM
namespace mlir::NVVM {

/// Signal the completion of a preceding warpgroup operation.
///     
///     [For more information, see PTX ISA](https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#asynchronous-warpgroup-level-matrix-instructions-wgmma-wait-group)
class WgmmaWaitGroupSyncOp;

} // namespace mlir::NVVM
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::AggrSmemSize declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AggrSmemSizeGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AggrSmemSizeGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.aggr.smem.size", odsAttrs.getContext());
  }

  AggrSmemSizeGenericAdaptorBase(AggrSmemSize op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class AggrSmemSizeGenericAdaptor : public detail::AggrSmemSizeGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AggrSmemSizeGenericAdaptorBase;
public:
  AggrSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AggrSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AggrSmemSizeGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AggrSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AggrSmemSizeGenericAdaptor(values, attrs, Properties{}, {}) {}

  AggrSmemSizeGenericAdaptor(RangeT values, const AggrSmemSizeGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AggrSmemSize, typename = std::enable_if_t<std::is_same_v<LateInst, AggrSmemSize>>>
  AggrSmemSizeGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AggrSmemSizeAdaptor : public AggrSmemSizeGenericAdaptor<::mlir::ValueRange> {
public:
  using AggrSmemSizeGenericAdaptor::AggrSmemSizeGenericAdaptor;
  AggrSmemSizeAdaptor(AggrSmemSize op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AggrSmemSize : public ::mlir::Op<AggrSmemSize, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AggrSmemSizeAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AggrSmemSizeGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.aggr.smem.size");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static AggrSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static AggrSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static AggrSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static AggrSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AggrSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AggrSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AggrSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AggrSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::AggrSmemSize)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::Barrier0Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class Barrier0OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Barrier0OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.barrier0", odsAttrs.getContext());
  }

  Barrier0OpGenericAdaptorBase(Barrier0Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class Barrier0OpGenericAdaptor : public detail::Barrier0OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Barrier0OpGenericAdaptorBase;
public:
  Barrier0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Barrier0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Barrier0OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Barrier0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Barrier0OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Barrier0OpGenericAdaptor(RangeT values, const Barrier0OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Barrier0Op, typename = std::enable_if_t<std::is_same_v<LateInst, Barrier0Op>>>
  Barrier0OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Barrier0OpAdaptor : public Barrier0OpGenericAdaptor<::mlir::ValueRange> {
public:
  using Barrier0OpGenericAdaptor::Barrier0OpGenericAdaptor;
  Barrier0OpAdaptor(Barrier0Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Barrier0Op : public ::mlir::Op<Barrier0Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Barrier0OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Barrier0OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.barrier0");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static Barrier0Op create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static Barrier0Op create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static Barrier0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static Barrier0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Barrier0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Barrier0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Barrier0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Barrier0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::Barrier0Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BarrierArriveOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierArriveOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierArriveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.barrier.arrive", odsAttrs.getContext());
  }

  BarrierArriveOpGenericAdaptorBase(BarrierArriveOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BarrierArriveOpGenericAdaptor : public detail::BarrierArriveOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierArriveOpGenericAdaptorBase;
  static constexpr int odsIndex_barrierId = 0;
  static constexpr int odsIndex_numberOfThreads = 1;
public:
  BarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierArriveOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierArriveOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierArriveOpGenericAdaptor(RangeT values, const BarrierArriveOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierArriveOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierArriveOp>>>
  BarrierArriveOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBarrierId() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getNumberOfThreads() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierArriveOpAdaptor : public BarrierArriveOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierArriveOpGenericAdaptor::BarrierArriveOpGenericAdaptor;
  BarrierArriveOpAdaptor(BarrierArriveOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierArriveOp : public ::mlir::Op<BarrierArriveOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::NVVM::BasicPtxBuilderInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierArriveOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierArriveOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_barrierId = 0;
  static constexpr int odsIndex_numberOfThreads = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<BarrierArriveOp>::getPredicate;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<BarrierArriveOp>::hasIntrinsic;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<BarrierArriveOp>::hasSideEffect;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<BarrierArriveOp>::makeConstantI32;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<BarrierArriveOp>::getAsmValues;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.barrier.arrive");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBarrierId() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getNumberOfThreads() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::MutableOperandRange getBarrierIdMutable();
  ::mlir::OpOperand &getNumberOfThreadsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static BarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static BarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static BarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static BarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, ::mlir::Value numberOfThreads);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  std::string getPtx();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BarrierArriveOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using reductionOpTy = ::mlir::NVVM::BarrierReductionAttr;
    reductionOpTy reductionOp;

    auto getReductionOp() const {
      auto &propStorage = this->reductionOp;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::BarrierReductionAttr>(propStorage);
    }
    void setReductionOp(const ::mlir::NVVM::BarrierReductionAttr &propValue) {
      this->reductionOp = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.reductionOp == this->reductionOp &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.barrier", odsAttrs.getContext());
  }

  BarrierOpGenericAdaptorBase(BarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::BarrierReductionAttr getReductionOpAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::NVVM::BarrierReductionAttr>(getProperties().reductionOp);
    return attr;
  }

  ::std::optional<::mlir::NVVM::BarrierReduction> getReductionOp();
};

} // namespace detail
template <typename RangeT>
class BarrierOpGenericAdaptor : public detail::BarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierOpGenericAdaptorBase;
  static constexpr int odsIndex_barrierId = 0;
  static constexpr int odsIndex_numberOfThreads = 1;
  static constexpr int odsIndex_reductionPredicate = 2;
public:
  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : BarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierOpGenericAdaptor(RangeT values, const BarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierOp>>>
  BarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBarrierId() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getNumberOfThreads() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getReductionPredicate() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierOpAdaptor : public BarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierOpGenericAdaptor::BarrierOpGenericAdaptor;
  BarrierOpAdaptor(BarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierOp : public ::mlir::Op<BarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_barrierId = 0;
  static constexpr int odsIndex_numberOfThreads = 1;
  static constexpr int odsIndex_reductionPredicate = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("reductionOp"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReductionOpAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReductionOpAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getBarrierId() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getNumberOfThreads() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getReductionPredicate() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getBarrierIdMutable();
  ::mlir::MutableOperandRange getNumberOfThreadsMutable();
  ::mlir::MutableOperandRange getReductionPredicateMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::IntegerType>() : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::BarrierReductionAttr getReductionOpAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::BarrierReductionAttr>(getProperties().reductionOp);
  }

  ::std::optional<::mlir::NVVM::BarrierReduction> getReductionOp();
  void setReductionOpAttr(::mlir::NVVM::BarrierReductionAttr attr) {
    getProperties().reductionOp = attr;
  }

  void setReductionOp(::std::optional<::mlir::NVVM::BarrierReduction> attrValue);
  ::mlir::Attribute removeReductionOpAttr() {
      auto attr = getProperties().reductionOp;
      getProperties().reductionOp = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value barrierId);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value barrierId);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, Value barrierId);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type res, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type res, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type res, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value barrierId, /*optional*/::mlir::Value numberOfThreads, /*optional*/::mlir::NVVM::BarrierReductionAttr reductionOp, /*optional*/::mlir::Value reductionPredicate);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BarrierOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockDimXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ntid.x", odsAttrs.getContext());
  }

  BlockDimXOpGenericAdaptorBase(BlockDimXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimXOpGenericAdaptor : public detail::BlockDimXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimXOpGenericAdaptorBase;
public:
  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimXOpGenericAdaptor(RangeT values, const BlockDimXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimXOp>>>
  BlockDimXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimXOpAdaptor : public BlockDimXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimXOpGenericAdaptor::BlockDimXOpGenericAdaptor;
  BlockDimXOpAdaptor(BlockDimXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimXOp : public ::mlir::Op<BlockDimXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockDimXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ntid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockDimXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockDimYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ntid.y", odsAttrs.getContext());
  }

  BlockDimYOpGenericAdaptorBase(BlockDimYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimYOpGenericAdaptor : public detail::BlockDimYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimYOpGenericAdaptorBase;
public:
  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimYOpGenericAdaptor(RangeT values, const BlockDimYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimYOp>>>
  BlockDimYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimYOpAdaptor : public BlockDimYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimYOpGenericAdaptor::BlockDimYOpGenericAdaptor;
  BlockDimYOpAdaptor(BlockDimYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimYOp : public ::mlir::Op<BlockDimYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockDimYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ntid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockDimYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockDimZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ntid.z", odsAttrs.getContext());
  }

  BlockDimZOpGenericAdaptorBase(BlockDimZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimZOpGenericAdaptor : public detail::BlockDimZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimZOpGenericAdaptorBase;
public:
  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimZOpGenericAdaptor(RangeT values, const BlockDimZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimZOp>>>
  BlockDimZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimZOpAdaptor : public BlockDimZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimZOpGenericAdaptor::BlockDimZOpGenericAdaptor;
  BlockDimZOpAdaptor(BlockDimZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimZOp : public ::mlir::Op<BlockDimZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockDimZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ntid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockDimZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ctaid.x", odsAttrs.getContext());
  }

  BlockIdXOpGenericAdaptorBase(BlockIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdXOpGenericAdaptor : public detail::BlockIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdXOpGenericAdaptorBase;
public:
  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdXOpGenericAdaptor(RangeT values, const BlockIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdXOp>>>
  BlockIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdXOpAdaptor : public BlockIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdXOpGenericAdaptor::BlockIdXOpGenericAdaptor;
  BlockIdXOpAdaptor(BlockIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdXOp : public ::mlir::Op<BlockIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockIdXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ctaid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockIdXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ctaid.y", odsAttrs.getContext());
  }

  BlockIdYOpGenericAdaptorBase(BlockIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdYOpGenericAdaptor : public detail::BlockIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdYOpGenericAdaptorBase;
public:
  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdYOpGenericAdaptor(RangeT values, const BlockIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdYOp>>>
  BlockIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdYOpAdaptor : public BlockIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdYOpGenericAdaptor::BlockIdYOpGenericAdaptor;
  BlockIdYOpAdaptor(BlockIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdYOp : public ::mlir::Op<BlockIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockIdYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ctaid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockIdYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.ctaid.z", odsAttrs.getContext());
  }

  BlockIdZOpGenericAdaptorBase(BlockIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdZOpGenericAdaptor : public detail::BlockIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdZOpGenericAdaptorBase;
public:
  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdZOpGenericAdaptor(RangeT values, const BlockIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdZOp>>>
  BlockIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdZOpAdaptor : public BlockIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdZOpGenericAdaptor::BlockIdZOpGenericAdaptor;
  BlockIdZOpAdaptor(BlockIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdZOp : public ::mlir::Op<BlockIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockIdZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.ctaid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockIdZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockInClusterIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockInClusterIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockInClusterIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.ctaid.x", odsAttrs.getContext());
  }

  BlockInClusterIdXOpGenericAdaptorBase(BlockInClusterIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockInClusterIdXOpGenericAdaptor : public detail::BlockInClusterIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockInClusterIdXOpGenericAdaptorBase;
public:
  BlockInClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockInClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockInClusterIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockInClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockInClusterIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockInClusterIdXOpGenericAdaptor(RangeT values, const BlockInClusterIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockInClusterIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockInClusterIdXOp>>>
  BlockInClusterIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockInClusterIdXOpAdaptor : public BlockInClusterIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockInClusterIdXOpGenericAdaptor::BlockInClusterIdXOpGenericAdaptor;
  BlockInClusterIdXOpAdaptor(BlockInClusterIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockInClusterIdXOp : public ::mlir::Op<BlockInClusterIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockInClusterIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockInClusterIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockInClusterIdXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.ctaid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockInClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockInClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockInClusterIdXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockInClusterIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockInClusterIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockInClusterIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.ctaid.y", odsAttrs.getContext());
  }

  BlockInClusterIdYOpGenericAdaptorBase(BlockInClusterIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockInClusterIdYOpGenericAdaptor : public detail::BlockInClusterIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockInClusterIdYOpGenericAdaptorBase;
public:
  BlockInClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockInClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockInClusterIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockInClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockInClusterIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockInClusterIdYOpGenericAdaptor(RangeT values, const BlockInClusterIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockInClusterIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockInClusterIdYOp>>>
  BlockInClusterIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockInClusterIdYOpAdaptor : public BlockInClusterIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockInClusterIdYOpGenericAdaptor::BlockInClusterIdYOpGenericAdaptor;
  BlockInClusterIdYOpAdaptor(BlockInClusterIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockInClusterIdYOp : public ::mlir::Op<BlockInClusterIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockInClusterIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockInClusterIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockInClusterIdYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.ctaid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockInClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockInClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockInClusterIdYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BlockInClusterIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockInClusterIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockInClusterIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.ctaid.z", odsAttrs.getContext());
  }

  BlockInClusterIdZOpGenericAdaptorBase(BlockInClusterIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockInClusterIdZOpGenericAdaptor : public detail::BlockInClusterIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockInClusterIdZOpGenericAdaptorBase;
public:
  BlockInClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockInClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockInClusterIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockInClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockInClusterIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockInClusterIdZOpGenericAdaptor(RangeT values, const BlockInClusterIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockInClusterIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockInClusterIdZOp>>>
  BlockInClusterIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockInClusterIdZOpAdaptor : public BlockInClusterIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockInClusterIdZOpGenericAdaptor::BlockInClusterIdZOpGenericAdaptor;
  BlockInClusterIdZOpAdaptor(BlockInClusterIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockInClusterIdZOp : public ::mlir::Op<BlockInClusterIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockInClusterIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockInClusterIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<BlockInClusterIdZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.ctaid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockInClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockInClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockInClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockInClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockInClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BlockInClusterIdZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::Breakpoint declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BreakpointGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BreakpointGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.breakpoint", odsAttrs.getContext());
  }

  BreakpointGenericAdaptorBase(Breakpoint op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BreakpointGenericAdaptor : public detail::BreakpointGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BreakpointGenericAdaptorBase;
public:
  BreakpointGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BreakpointGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BreakpointGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BreakpointGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BreakpointGenericAdaptor(values, attrs, Properties{}, {}) {}

  BreakpointGenericAdaptor(RangeT values, const BreakpointGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Breakpoint, typename = std::enable_if_t<std::is_same_v<LateInst, Breakpoint>>>
  BreakpointGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BreakpointAdaptor : public BreakpointGenericAdaptor<::mlir::ValueRange> {
public:
  using BreakpointGenericAdaptor::BreakpointGenericAdaptor;
  BreakpointAdaptor(Breakpoint op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Breakpoint : public ::mlir::Op<Breakpoint, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BreakpointAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BreakpointGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.breakpoint");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static Breakpoint create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static Breakpoint create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static Breakpoint create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static Breakpoint create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Breakpoint create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Breakpoint create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Breakpoint create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Breakpoint create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::Breakpoint)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::BulkStoreOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BulkStoreOpGenericAdaptorBase {
public:
  struct Properties {
    using initValTy = ::mlir::IntegerAttr;
    initValTy initVal;

    auto getInitVal() const {
      auto &propStorage = this->initVal;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setInitVal(const ::mlir::IntegerAttr &propValue) {
      this->initVal = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.initVal == this->initVal &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BulkStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.st.bulk", odsAttrs.getContext());
  }

  BulkStoreOpGenericAdaptorBase(BulkStoreOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getInitValAttr();
  uint64_t getInitVal();
};

} // namespace detail
template <typename RangeT>
class BulkStoreOpGenericAdaptor : public detail::BulkStoreOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BulkStoreOpGenericAdaptorBase;
  static constexpr int odsIndex_addr = 0;
  static constexpr int odsIndex_size = 1;
public:
  BulkStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BulkStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BulkStoreOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BulkStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BulkStoreOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BulkStoreOpGenericAdaptor(RangeT values, const BulkStoreOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BulkStoreOp, typename = std::enable_if_t<std::is_same_v<LateInst, BulkStoreOp>>>
  BulkStoreOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAddr() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSize() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BulkStoreOpAdaptor : public BulkStoreOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BulkStoreOpGenericAdaptor::BulkStoreOpGenericAdaptor;
  BulkStoreOpAdaptor(BulkStoreOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BulkStoreOp : public ::mlir::Op<BulkStoreOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BulkStoreOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BulkStoreOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_addr = 0;
  static constexpr int odsIndex_size = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("initVal")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getInitValAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getInitValAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.st.bulk");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAddr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAddrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSizeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getInitValAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().initVal);
  }

  uint64_t getInitVal();
  void setInitValAttr(::mlir::IntegerAttr attr) {
    getProperties().initVal = attr;
  }

  void setInitVal(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, ::mlir::IntegerAttr initVal);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::Value size, uint64_t initVal = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BulkStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BulkStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::BulkStoreOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::Clock64Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class Clock64OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Clock64OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.clock64", odsAttrs.getContext());
  }

  Clock64OpGenericAdaptorBase(Clock64Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class Clock64OpGenericAdaptor : public detail::Clock64OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Clock64OpGenericAdaptorBase;
public:
  Clock64OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Clock64OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Clock64OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Clock64OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Clock64OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Clock64OpGenericAdaptor(RangeT values, const Clock64OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Clock64Op, typename = std::enable_if_t<std::is_same_v<LateInst, Clock64Op>>>
  Clock64OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Clock64OpAdaptor : public Clock64OpGenericAdaptor<::mlir::ValueRange> {
public:
  using Clock64OpGenericAdaptor::Clock64OpGenericAdaptor;
  Clock64OpAdaptor(Clock64Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Clock64Op : public ::mlir::Op<Clock64Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Clock64OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Clock64OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.clock64");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static Clock64Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static Clock64Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static Clock64Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static Clock64Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Clock64Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Clock64Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Clock64Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Clock64Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::Clock64Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClockOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClockOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClockOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.clock", odsAttrs.getContext());
  }

  ClockOpGenericAdaptorBase(ClockOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ClockOpGenericAdaptor : public detail::ClockOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClockOpGenericAdaptorBase;
public:
  ClockOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClockOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClockOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClockOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClockOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClockOpGenericAdaptor(RangeT values, const ClockOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClockOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClockOp>>>
  ClockOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClockOpAdaptor : public ClockOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClockOpGenericAdaptor::ClockOpGenericAdaptor;
  ClockOpAdaptor(ClockOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClockOp : public ::mlir::Op<ClockOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClockOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClockOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.clock");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static ClockOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static ClockOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static ClockOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static ClockOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClockOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClockOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClockOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClockOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClockOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterArriveOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterArriveOpGenericAdaptorBase {
public:
  struct Properties {
    using alignedTy = ::mlir::UnitAttr;
    alignedTy aligned;

    auto getAligned() const {
      auto &propStorage = this->aligned;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAligned(const ::mlir::UnitAttr &propValue) {
      this->aligned = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aligned == this->aligned &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterArriveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cluster.arrive", odsAttrs.getContext());
  }

  ClusterArriveOpGenericAdaptorBase(ClusterArriveOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getAlignedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
    return attr;
  }

  ::std::optional<bool> getAligned();
};

} // namespace detail
template <typename RangeT>
class ClusterArriveOpGenericAdaptor : public detail::ClusterArriveOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterArriveOpGenericAdaptorBase;
public:
  ClusterArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterArriveOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterArriveOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterArriveOpGenericAdaptor(RangeT values, const ClusterArriveOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterArriveOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterArriveOp>>>
  ClusterArriveOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterArriveOpAdaptor : public ClusterArriveOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterArriveOpGenericAdaptor::ClusterArriveOpGenericAdaptor;
  ClusterArriveOpAdaptor(ClusterArriveOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterArriveOp : public ::mlir::Op<ClusterArriveOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterArriveOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterArriveOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("aligned")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlignedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlignedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cluster.arrive");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getAlignedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
  }

  ::std::optional<bool> getAligned();
  void setAlignedAttr(::mlir::UnitAttr attr) {
    getProperties().aligned = attr;
  }

  void setAligned(bool attrValue);
  ::mlir::Attribute removeAlignedAttr() {
      auto attr = getProperties().aligned;
      getProperties().aligned = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterArriveOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterArriveRelaxedOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterArriveRelaxedOpGenericAdaptorBase {
public:
  struct Properties {
    using alignedTy = ::mlir::UnitAttr;
    alignedTy aligned;

    auto getAligned() const {
      auto &propStorage = this->aligned;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAligned(const ::mlir::UnitAttr &propValue) {
      this->aligned = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aligned == this->aligned &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterArriveRelaxedOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cluster.arrive.relaxed", odsAttrs.getContext());
  }

  ClusterArriveRelaxedOpGenericAdaptorBase(ClusterArriveRelaxedOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getAlignedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
    return attr;
  }

  ::std::optional<bool> getAligned();
};

} // namespace detail
template <typename RangeT>
class ClusterArriveRelaxedOpGenericAdaptor : public detail::ClusterArriveRelaxedOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterArriveRelaxedOpGenericAdaptorBase;
public:
  ClusterArriveRelaxedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterArriveRelaxedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterArriveRelaxedOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterArriveRelaxedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterArriveRelaxedOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterArriveRelaxedOpGenericAdaptor(RangeT values, const ClusterArriveRelaxedOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterArriveRelaxedOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterArriveRelaxedOp>>>
  ClusterArriveRelaxedOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterArriveRelaxedOpAdaptor : public ClusterArriveRelaxedOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterArriveRelaxedOpGenericAdaptor::ClusterArriveRelaxedOpGenericAdaptor;
  ClusterArriveRelaxedOpAdaptor(ClusterArriveRelaxedOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterArriveRelaxedOp : public ::mlir::Op<ClusterArriveRelaxedOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterArriveRelaxedOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterArriveRelaxedOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("aligned")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlignedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlignedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cluster.arrive.relaxed");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getAlignedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
  }

  ::std::optional<bool> getAligned();
  void setAlignedAttr(::mlir::UnitAttr attr) {
    getProperties().aligned = attr;
  }

  void setAligned(bool attrValue);
  ::mlir::Attribute removeAlignedAttr() {
      auto attr = getProperties().aligned;
      getProperties().aligned = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveRelaxedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveRelaxedOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveRelaxedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterArriveRelaxedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterArriveRelaxedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterArriveRelaxedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterArriveRelaxedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterArriveRelaxedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterArriveRelaxedOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDim declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.nctarank", odsAttrs.getContext());
  }

  ClusterDimGenericAdaptorBase(ClusterDim op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimGenericAdaptor : public detail::ClusterDimGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimGenericAdaptorBase;
public:
  ClusterDimGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimGenericAdaptor(RangeT values, const ClusterDimGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDim, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDim>>>
  ClusterDimGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimAdaptor : public ClusterDimGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimGenericAdaptor::ClusterDimGenericAdaptor;
  ClusterDimAdaptor(ClusterDim op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDim : public ::mlir::Op<ClusterDim, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDim>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.nctarank");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDim create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDim create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDim create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDim create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDim create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDim create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDim create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDim create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDim create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDim create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDim)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimBlocksXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimBlocksXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimBlocksXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.nctaid.x", odsAttrs.getContext());
  }

  ClusterDimBlocksXOpGenericAdaptorBase(ClusterDimBlocksXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimBlocksXOpGenericAdaptor : public detail::ClusterDimBlocksXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimBlocksXOpGenericAdaptorBase;
public:
  ClusterDimBlocksXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimBlocksXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimBlocksXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimBlocksXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimBlocksXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimBlocksXOpGenericAdaptor(RangeT values, const ClusterDimBlocksXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimBlocksXOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimBlocksXOp>>>
  ClusterDimBlocksXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimBlocksXOpAdaptor : public ClusterDimBlocksXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimBlocksXOpGenericAdaptor::ClusterDimBlocksXOpGenericAdaptor;
  ClusterDimBlocksXOpAdaptor(ClusterDimBlocksXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimBlocksXOp : public ::mlir::Op<ClusterDimBlocksXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimBlocksXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimBlocksXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimBlocksXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.nctaid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimBlocksXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimBlocksXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimBlocksXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimBlocksYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimBlocksYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimBlocksYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.nctaid.y", odsAttrs.getContext());
  }

  ClusterDimBlocksYOpGenericAdaptorBase(ClusterDimBlocksYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimBlocksYOpGenericAdaptor : public detail::ClusterDimBlocksYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimBlocksYOpGenericAdaptorBase;
public:
  ClusterDimBlocksYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimBlocksYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimBlocksYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimBlocksYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimBlocksYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimBlocksYOpGenericAdaptor(RangeT values, const ClusterDimBlocksYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimBlocksYOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimBlocksYOp>>>
  ClusterDimBlocksYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimBlocksYOpAdaptor : public ClusterDimBlocksYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimBlocksYOpGenericAdaptor::ClusterDimBlocksYOpGenericAdaptor;
  ClusterDimBlocksYOpAdaptor(ClusterDimBlocksYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimBlocksYOp : public ::mlir::Op<ClusterDimBlocksYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimBlocksYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimBlocksYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimBlocksYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.nctaid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimBlocksYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimBlocksYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimBlocksYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimBlocksZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimBlocksZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimBlocksZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.nctaid.z", odsAttrs.getContext());
  }

  ClusterDimBlocksZOpGenericAdaptorBase(ClusterDimBlocksZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimBlocksZOpGenericAdaptor : public detail::ClusterDimBlocksZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimBlocksZOpGenericAdaptorBase;
public:
  ClusterDimBlocksZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimBlocksZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimBlocksZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimBlocksZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimBlocksZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimBlocksZOpGenericAdaptor(RangeT values, const ClusterDimBlocksZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimBlocksZOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimBlocksZOp>>>
  ClusterDimBlocksZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimBlocksZOpAdaptor : public ClusterDimBlocksZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimBlocksZOpGenericAdaptor::ClusterDimBlocksZOpGenericAdaptor;
  ClusterDimBlocksZOpAdaptor(ClusterDimBlocksZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimBlocksZOp : public ::mlir::Op<ClusterDimBlocksZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimBlocksZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimBlocksZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimBlocksZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.nctaid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimBlocksZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimBlocksZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimBlocksZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimBlocksZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimBlocksZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimBlocksZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.nclusterid.x", odsAttrs.getContext());
  }

  ClusterDimXOpGenericAdaptorBase(ClusterDimXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimXOpGenericAdaptor : public detail::ClusterDimXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimXOpGenericAdaptorBase;
public:
  ClusterDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimXOpGenericAdaptor(RangeT values, const ClusterDimXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimXOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimXOp>>>
  ClusterDimXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimXOpAdaptor : public ClusterDimXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimXOpGenericAdaptor::ClusterDimXOpGenericAdaptor;
  ClusterDimXOpAdaptor(ClusterDimXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimXOp : public ::mlir::Op<ClusterDimXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.nclusterid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.nclusterid.y", odsAttrs.getContext());
  }

  ClusterDimYOpGenericAdaptorBase(ClusterDimYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimYOpGenericAdaptor : public detail::ClusterDimYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimYOpGenericAdaptorBase;
public:
  ClusterDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimYOpGenericAdaptor(RangeT values, const ClusterDimYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimYOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimYOp>>>
  ClusterDimYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimYOpAdaptor : public ClusterDimYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimYOpGenericAdaptor::ClusterDimYOpGenericAdaptor;
  ClusterDimYOpAdaptor(ClusterDimYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimYOp : public ::mlir::Op<ClusterDimYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.nclusterid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterDimZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterDimZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterDimZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.nclusterid.z", odsAttrs.getContext());
  }

  ClusterDimZOpGenericAdaptorBase(ClusterDimZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterDimZOpGenericAdaptor : public detail::ClusterDimZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterDimZOpGenericAdaptorBase;
public:
  ClusterDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterDimZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterDimZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterDimZOpGenericAdaptor(RangeT values, const ClusterDimZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterDimZOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterDimZOp>>>
  ClusterDimZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterDimZOpAdaptor : public ClusterDimZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterDimZOpGenericAdaptor::ClusterDimZOpGenericAdaptor;
  ClusterDimZOpAdaptor(ClusterDimZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterDimZOp : public ::mlir::Op<ClusterDimZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterDimZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterDimZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterDimZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.nclusterid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterDimZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterDimZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterId declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.cluster.ctarank", odsAttrs.getContext());
  }

  ClusterIdGenericAdaptorBase(ClusterId op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdGenericAdaptor : public detail::ClusterIdGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdGenericAdaptorBase;
public:
  ClusterIdGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdGenericAdaptor(RangeT values, const ClusterIdGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterId, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterId>>>
  ClusterIdGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdAdaptor : public ClusterIdGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdGenericAdaptor::ClusterIdGenericAdaptor;
  ClusterIdAdaptor(ClusterId op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterId : public ::mlir::Op<ClusterId, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterId>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.cluster.ctarank");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterId create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterId create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterId create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterId create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterId create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterId create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterId create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterId create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterId create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterId create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterId)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.clusterid.x", odsAttrs.getContext());
  }

  ClusterIdXOpGenericAdaptorBase(ClusterIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdXOpGenericAdaptor : public detail::ClusterIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdXOpGenericAdaptorBase;
public:
  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdXOpGenericAdaptor(RangeT values, const ClusterIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdXOp>>>
  ClusterIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdXOpAdaptor : public ClusterIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdXOpGenericAdaptor::ClusterIdXOpGenericAdaptor;
  ClusterIdXOpAdaptor(ClusterIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdXOp : public ::mlir::Op<ClusterIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterIdXOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.clusterid.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterIdXOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.clusterid.y", odsAttrs.getContext());
  }

  ClusterIdYOpGenericAdaptorBase(ClusterIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdYOpGenericAdaptor : public detail::ClusterIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdYOpGenericAdaptorBase;
public:
  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdYOpGenericAdaptor(RangeT values, const ClusterIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdYOp>>>
  ClusterIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdYOpAdaptor : public ClusterIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdYOpGenericAdaptor::ClusterIdYOpGenericAdaptor;
  ClusterIdYOpAdaptor(ClusterIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdYOp : public ::mlir::Op<ClusterIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterIdYOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.clusterid.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterIdYOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.clusterid.z", odsAttrs.getContext());
  }

  ClusterIdZOpGenericAdaptorBase(ClusterIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdZOpGenericAdaptor : public detail::ClusterIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdZOpGenericAdaptorBase;
public:
  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdZOpGenericAdaptor(RangeT values, const ClusterIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdZOp>>>
  ClusterIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdZOpAdaptor : public ClusterIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdZOpGenericAdaptor::ClusterIdZOpGenericAdaptor;
  ClusterIdZOpAdaptor(ClusterIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdZOp : public ::mlir::Op<ClusterIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferIntRangeInterface::Trait<ClusterIdZOp>::inferResultRangesFromOptional;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.clusterid.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterIdZOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterLaunchControlQueryCancelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterLaunchControlQueryCancelOpGenericAdaptorBase {
public:
  struct Properties {
    using query_typeTy = ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr;
    query_typeTy query_type;

    auto getQueryType() const {
      auto &propStorage = this->query_type;
      return ::llvm::cast<::mlir::NVVM::ClusterLaunchControlQueryTypeAttr>(propStorage);
    }
    void setQueryType(const ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr &propValue) {
      this->query_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.query_type == this->query_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterLaunchControlQueryCancelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.clusterlaunchcontrol.query.cancel", odsAttrs.getContext());
  }

  ClusterLaunchControlQueryCancelOpGenericAdaptorBase(ClusterLaunchControlQueryCancelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr getQueryTypeAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::ClusterLaunchControlQueryTypeAttr>(getProperties().query_type);
    return attr;
  }

  ::mlir::NVVM::ClusterLaunchControlQueryType getQueryType();
};

} // namespace detail
template <typename RangeT>
class ClusterLaunchControlQueryCancelOpGenericAdaptor : public detail::ClusterLaunchControlQueryCancelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterLaunchControlQueryCancelOpGenericAdaptorBase;
  static constexpr int odsIndex_try_cancel_response = 0;
public:
  ClusterLaunchControlQueryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterLaunchControlQueryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterLaunchControlQueryCancelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterLaunchControlQueryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterLaunchControlQueryCancelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterLaunchControlQueryCancelOpGenericAdaptor(RangeT values, const ClusterLaunchControlQueryCancelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterLaunchControlQueryCancelOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterLaunchControlQueryCancelOp>>>
  ClusterLaunchControlQueryCancelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTryCancelResponse() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterLaunchControlQueryCancelOpAdaptor : public ClusterLaunchControlQueryCancelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterLaunchControlQueryCancelOpGenericAdaptor::ClusterLaunchControlQueryCancelOpGenericAdaptor;
  ClusterLaunchControlQueryCancelOpAdaptor(ClusterLaunchControlQueryCancelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterLaunchControlQueryCancelOp : public ::mlir::Op<ClusterLaunchControlQueryCancelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<100>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterLaunchControlQueryCancelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterLaunchControlQueryCancelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_try_cancel_response = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("query_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getQueryTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getQueryTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.clusterlaunchcontrol.query.cancel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getTryCancelResponse() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getTryCancelResponseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr getQueryTypeAttr() {
    return ::llvm::cast<::mlir::NVVM::ClusterLaunchControlQueryTypeAttr>(getProperties().query_type);
  }

  ::mlir::NVVM::ClusterLaunchControlQueryType getQueryType();
  void setQueryTypeAttr(::mlir::NVVM::ClusterLaunchControlQueryTypeAttr attr) {
    getProperties().query_type = attr;
  }

  void setQueryType(::mlir::NVVM::ClusterLaunchControlQueryType attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryTypeAttr query_type, ::mlir::Value try_cancel_response);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::NVVM::ClusterLaunchControlQueryType query_type, ::mlir::Value try_cancel_response);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterLaunchControlQueryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterLaunchControlQueryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterLaunchControlQueryCancelOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterLaunchControlTryCancelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterLaunchControlTryCancelOpGenericAdaptorBase {
public:
  struct Properties {
    using multicastTy = ::mlir::UnitAttr;
    multicastTy multicast;

    auto getMulticast() const {
      auto &propStorage = this->multicast;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setMulticast(const ::mlir::UnitAttr &propValue) {
      this->multicast = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.multicast == this->multicast &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterLaunchControlTryCancelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.clusterlaunchcontrol.try.cancel", odsAttrs.getContext());
  }

  ClusterLaunchControlTryCancelOpGenericAdaptorBase(ClusterLaunchControlTryCancelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getMulticastAttr();
  bool getMulticast();
};

} // namespace detail
template <typename RangeT>
class ClusterLaunchControlTryCancelOpGenericAdaptor : public detail::ClusterLaunchControlTryCancelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterLaunchControlTryCancelOpGenericAdaptorBase;
  static constexpr int odsIndex_smemAddress = 0;
  static constexpr int odsIndex_mbarrier = 1;
public:
  ClusterLaunchControlTryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterLaunchControlTryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterLaunchControlTryCancelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterLaunchControlTryCancelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterLaunchControlTryCancelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterLaunchControlTryCancelOpGenericAdaptor(RangeT values, const ClusterLaunchControlTryCancelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterLaunchControlTryCancelOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterLaunchControlTryCancelOp>>>
  ClusterLaunchControlTryCancelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSmemAddress() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMbarrier() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterLaunchControlTryCancelOpAdaptor : public ClusterLaunchControlTryCancelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterLaunchControlTryCancelOpGenericAdaptor::ClusterLaunchControlTryCancelOpGenericAdaptor;
  ClusterLaunchControlTryCancelOpAdaptor(ClusterLaunchControlTryCancelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterLaunchControlTryCancelOp : public ::mlir::Op<ClusterLaunchControlTryCancelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<100>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterLaunchControlTryCancelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterLaunchControlTryCancelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_smemAddress = 0;
  static constexpr int odsIndex_mbarrier = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("multicast")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMulticastAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMulticastAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.clusterlaunchcontrol.try.cancel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSmemAddress() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getMbarrier() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSmemAddressMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMbarrierMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getMulticastAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().multicast);
  }

  bool getMulticast();
  void setMulticastAttr(::mlir::UnitAttr attr) {
    getProperties().multicast = attr;
  }

  void setMulticast(bool attrValue);
  ::mlir::Attribute removeMulticastAttr() {
      auto attr = getProperties().multicast;
      getProperties().multicast = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/bool multicast, ::mlir::Value smemAddress, ::mlir::Value mbarrier);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterLaunchControlTryCancelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterLaunchControlTryCancelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterLaunchControlTryCancelOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ClusterWaitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterWaitOpGenericAdaptorBase {
public:
  struct Properties {
    using alignedTy = ::mlir::UnitAttr;
    alignedTy aligned;

    auto getAligned() const {
      auto &propStorage = this->aligned;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAligned(const ::mlir::UnitAttr &propValue) {
      this->aligned = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aligned == this->aligned &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterWaitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cluster.wait", odsAttrs.getContext());
  }

  ClusterWaitOpGenericAdaptorBase(ClusterWaitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getAlignedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
    return attr;
  }

  ::std::optional<bool> getAligned();
};

} // namespace detail
template <typename RangeT>
class ClusterWaitOpGenericAdaptor : public detail::ClusterWaitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterWaitOpGenericAdaptorBase;
public:
  ClusterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterWaitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterWaitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterWaitOpGenericAdaptor(RangeT values, const ClusterWaitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterWaitOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterWaitOp>>>
  ClusterWaitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterWaitOpAdaptor : public ClusterWaitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterWaitOpGenericAdaptor::ClusterWaitOpGenericAdaptor;
  ClusterWaitOpAdaptor(ClusterWaitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterWaitOp : public ::mlir::Op<ClusterWaitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterWaitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterWaitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("aligned")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlignedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlignedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cluster.wait");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getAlignedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aligned);
  }

  ::std::optional<bool> getAligned();
  void setAlignedAttr(::mlir::UnitAttr attr) {
    getProperties().aligned = attr;
  }

  void setAligned(bool attrValue);
  ::mlir::Attribute removeAlignedAttr() {
      auto attr = getProperties().aligned;
      getProperties().aligned = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr aligned);
  static ClusterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::UnitAttr aligned);
  static ClusterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static ClusterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr aligned);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ClusterWaitOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertBF16x2ToF8x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertBF16x2ToF8x2OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using rndTy = ::mlir::NVVM::FPRoundingModeAttr;
    rndTy rnd;

    auto getRnd() const {
      auto &propStorage = this->rnd;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(propStorage);
    }
    void setRnd(const ::mlir::NVVM::FPRoundingModeAttr &propValue) {
      this->rnd = propValue;
    }
    using satTy = ::mlir::NVVM::SaturationModeAttr;
    satTy sat;

    auto getSat() const {
      auto &propStorage = this->sat;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(propStorage);
    }
    void setSat(const ::mlir::NVVM::SaturationModeAttr &propValue) {
      this->sat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.rnd == this->rnd &&
        rhs.sat == this->sat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertBF16x2ToF8x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.bf16x2.to.f8x2", odsAttrs.getContext());
  }

  ConvertBF16x2ToF8x2OpGenericAdaptorBase(ConvertBF16x2ToF8x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::FPRoundingModeAttr getRndAttr();
  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr();
  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertBF16x2ToF8x2OpGenericAdaptor : public detail::ConvertBF16x2ToF8x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertBF16x2ToF8x2OpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
public:
  ConvertBF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertBF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertBF16x2ToF8x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertBF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertBF16x2ToF8x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertBF16x2ToF8x2OpGenericAdaptor(RangeT values, const ConvertBF16x2ToF8x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertBF16x2ToF8x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertBF16x2ToF8x2Op>>>
  ConvertBF16x2ToF8x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertBF16x2ToF8x2OpAdaptor : public ConvertBF16x2ToF8x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertBF16x2ToF8x2OpGenericAdaptor::ConvertBF16x2ToF8x2OpGenericAdaptor;
  ConvertBF16x2ToF8x2OpAdaptor(ConvertBF16x2ToF8x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertBF16x2ToF8x2Op : public ::mlir::Op<ConvertBF16x2ToF8x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertBF16x2ToF8x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertBF16x2ToF8x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("rnd"), ::llvm::StringRef("sat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRndAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSatAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.bf16x2.to.f8x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::FPRoundingModeAttr getRndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(getProperties().rnd);
  }

  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(getProperties().sat);
  }

  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setRndAttr(::mlir::NVVM::FPRoundingModeAttr attr) {
    getProperties().rnd = attr;
  }

  void setRnd(::mlir::NVVM::FPRoundingMode attrValue);
  void setSatAttr(::mlir::NVVM::SaturationModeAttr attr) {
    getProperties().sat = attr;
  }

  void setSat(::mlir::NVVM::SaturationMode attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertBF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertBF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID getIntrinsicID(NVVM::FPRoundingMode rnd,
                                            NVVM::SaturationMode sat);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertBF16x2ToF8x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF16x2ToF8x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF16x2ToF8x2OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF16x2ToF8x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f16x2.to.f8x2", odsAttrs.getContext());
  }

  ConvertF16x2ToF8x2OpGenericAdaptorBase(ConvertF16x2ToF8x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF16x2ToF8x2OpGenericAdaptor : public detail::ConvertF16x2ToF8x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF16x2ToF8x2OpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
public:
  ConvertF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF16x2ToF8x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF16x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF16x2ToF8x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF16x2ToF8x2OpGenericAdaptor(RangeT values, const ConvertF16x2ToF8x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF16x2ToF8x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF16x2ToF8x2Op>>>
  ConvertF16x2ToF8x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF16x2ToF8x2OpAdaptor : public ConvertF16x2ToF8x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF16x2ToF8x2OpGenericAdaptor::ConvertF16x2ToF8x2OpGenericAdaptor;
  ConvertF16x2ToF8x2OpAdaptor(ConvertF16x2ToF8x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF16x2ToF8x2Op : public ::mlir::Op<ConvertF16x2ToF8x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF16x2ToF8x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF16x2ToF8x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f16x2.to.f8x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF16x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF16x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID getIntrinsicID(mlir::Type dstTy,
                                            bool hasRelu);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF16x2ToF8x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x2ToBF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x2ToBF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using rndTy = ::mlir::NVVM::FPRoundingModeAttr;
    rndTy rnd;

    auto getRnd() const {
      auto &propStorage = this->rnd;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(propStorage);
    }
    void setRnd(const ::mlir::NVVM::FPRoundingModeAttr &propValue) {
      this->rnd = propValue;
    }
    using satTy = ::mlir::NVVM::SaturationModeAttr;
    satTy sat;

    auto getSat() const {
      auto &propStorage = this->sat;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(propStorage);
    }
    void setSat(const ::mlir::NVVM::SaturationModeAttr &propValue) {
      this->sat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.rnd == this->rnd &&
        rhs.sat == this->sat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x2ToBF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x2.to.bf16x2", odsAttrs.getContext());
  }

  ConvertF32x2ToBF16x2OpGenericAdaptorBase(ConvertF32x2ToBF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::FPRoundingModeAttr getRndAttr();
  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr();
  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x2ToBF16x2OpGenericAdaptor : public detail::ConvertF32x2ToBF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x2ToBF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src_hi = 0;
  static constexpr int odsIndex_src_lo = 1;
  static constexpr int odsIndex_random_bits = 2;
public:
  ConvertF32x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x2ToBF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x2ToBF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x2ToBF16x2OpGenericAdaptor(RangeT values, const ConvertF32x2ToBF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x2ToBF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x2ToBF16x2Op>>>
  ConvertF32x2ToBF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcHi() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcLo() {
    return (*getODSOperands(1).begin());
  }

  ValueT getRandomBits() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x2ToBF16x2OpAdaptor : public ConvertF32x2ToBF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x2ToBF16x2OpGenericAdaptor::ConvertF32x2ToBF16x2OpGenericAdaptor;
  ConvertF32x2ToBF16x2OpAdaptor(ConvertF32x2ToBF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x2ToBF16x2Op : public ::mlir::Op<ConvertF32x2ToBF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x2ToBF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x2ToBF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src_hi = 0;
  static constexpr int odsIndex_src_lo = 1;
  static constexpr int odsIndex_random_bits = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("rnd"), ::llvm::StringRef("sat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRndAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSatAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x2.to.bf16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcHi() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcLo() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRandomBits() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSrcHiMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcLoMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getRandomBitsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::FPRoundingModeAttr getRndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(getProperties().rnd);
  }

  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(getProperties().sat);
  }

  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  void setRndAttr(::mlir::NVVM::FPRoundingModeAttr attr) {
    getProperties().rnd = attr;
  }

  void setRnd(::mlir::NVVM::FPRoundingMode attrValue);
  void setSatAttr(::mlir::NVVM::SaturationModeAttr attr) {
    getProperties().sat = attr;
  }

  void setSat(::mlir::NVVM::SaturationMode attrValue);
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
  getIntrinsicIDAndArgs(
    NVVM::ConvertF32x2ToBF16x2Op &op, 
    LLVM::ModuleTranslation &mt, llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x2ToBF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x2ToF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x2ToF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using rndTy = ::mlir::NVVM::FPRoundingModeAttr;
    rndTy rnd;

    auto getRnd() const {
      auto &propStorage = this->rnd;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(propStorage);
    }
    void setRnd(const ::mlir::NVVM::FPRoundingModeAttr &propValue) {
      this->rnd = propValue;
    }
    using satTy = ::mlir::NVVM::SaturationModeAttr;
    satTy sat;

    auto getSat() const {
      auto &propStorage = this->sat;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(propStorage);
    }
    void setSat(const ::mlir::NVVM::SaturationModeAttr &propValue) {
      this->sat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.rnd == this->rnd &&
        rhs.sat == this->sat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x2ToF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x2.to.f16x2", odsAttrs.getContext());
  }

  ConvertF32x2ToF16x2OpGenericAdaptorBase(ConvertF32x2ToF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::FPRoundingModeAttr getRndAttr();
  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr();
  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x2ToF16x2OpGenericAdaptor : public detail::ConvertF32x2ToF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x2ToF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src_hi = 0;
  static constexpr int odsIndex_src_lo = 1;
  static constexpr int odsIndex_random_bits = 2;
public:
  ConvertF32x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x2ToF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x2ToF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x2ToF16x2OpGenericAdaptor(RangeT values, const ConvertF32x2ToF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x2ToF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x2ToF16x2Op>>>
  ConvertF32x2ToF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcHi() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcLo() {
    return (*getODSOperands(1).begin());
  }

  ValueT getRandomBits() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x2ToF16x2OpAdaptor : public ConvertF32x2ToF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x2ToF16x2OpGenericAdaptor::ConvertF32x2ToF16x2OpGenericAdaptor;
  ConvertF32x2ToF16x2OpAdaptor(ConvertF32x2ToF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x2ToF16x2Op : public ::mlir::Op<ConvertF32x2ToF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x2ToF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x2ToF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src_hi = 0;
  static constexpr int odsIndex_src_lo = 1;
  static constexpr int odsIndex_random_bits = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("rnd"), ::llvm::StringRef("sat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRndAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSatAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x2.to.f16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcHi() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcLo() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRandomBits() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSrcHiMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcLoMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getRandomBitsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::FPRoundingModeAttr getRndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(getProperties().rnd);
  }

  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(getProperties().sat);
  }

  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  void setRndAttr(::mlir::NVVM::FPRoundingModeAttr attr) {
    getProperties().rnd = attr;
  }

  void setRnd(::mlir::NVVM::FPRoundingMode attrValue);
  void setSatAttr(::mlir::NVVM::SaturationModeAttr attr) {
    getProperties().sat = attr;
  }

  void setSat(::mlir::NVVM::SaturationMode attrValue);
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src_hi, ::mlir::Value src_lo, /*optional*/::mlir::Value random_bits, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
  getIntrinsicIDAndArgs(
    NVVM::ConvertF32x2ToF16x2Op &op, 
    LLVM::ModuleTranslation &mt, llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x2ToF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x2ToF4x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x2ToF4x2OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x2ToF4x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x2.to.f4x2", odsAttrs.getContext());
  }

  ConvertF32x2ToF4x2OpGenericAdaptorBase(ConvertF32x2ToF4x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x2ToF4x2OpGenericAdaptor : public detail::ConvertF32x2ToF4x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x2ToF4x2OpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
public:
  ConvertF32x2ToF4x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x2ToF4x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x2ToF4x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x2ToF4x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x2ToF4x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x2ToF4x2OpGenericAdaptor(RangeT values, const ConvertF32x2ToF4x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x2ToF4x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x2ToF4x2Op>>>
  ConvertF32x2ToF4x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x2ToF4x2OpAdaptor : public ConvertF32x2ToF4x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x2ToF4x2OpGenericAdaptor::ConvertF32x2ToF4x2OpGenericAdaptor;
  ConvertF32x2ToF4x2OpAdaptor(ConvertF32x2ToF4x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x2ToF4x2Op : public ::mlir::Op<ConvertF32x2ToF4x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x2ToF4x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x2ToF4x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x2.to.f4x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF4x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF4x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(NVVM::ConvertF32x2ToF4x2Op op, 
    LLVM::ModuleTranslation &mt, llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x2ToF4x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x2ToF6x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x2ToF6x2OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x2ToF6x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x2.to.f6x2", odsAttrs.getContext());
  }

  ConvertF32x2ToF6x2OpGenericAdaptorBase(ConvertF32x2ToF6x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x2ToF6x2OpGenericAdaptor : public detail::ConvertF32x2ToF6x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x2ToF6x2OpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
public:
  ConvertF32x2ToF6x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x2ToF6x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x2ToF6x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x2ToF6x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x2ToF6x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x2ToF6x2OpGenericAdaptor(RangeT values, const ConvertF32x2ToF6x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x2ToF6x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x2ToF6x2Op>>>
  ConvertF32x2ToF6x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x2ToF6x2OpAdaptor : public ConvertF32x2ToF6x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x2ToF6x2OpGenericAdaptor::ConvertF32x2ToF6x2OpGenericAdaptor;
  ConvertF32x2ToF6x2OpAdaptor(ConvertF32x2ToF6x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x2ToF6x2Op : public ::mlir::Op<ConvertF32x2ToF6x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x2ToF6x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x2ToF6x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x2.to.f6x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF6x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF6x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID getIntrinsicID(mlir::Type dstTy,
                                            bool hasRelu);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x2ToF6x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x2ToF8x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x2ToF8x2OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using rndTy = ::mlir::NVVM::FPRoundingModeAttr;
    rndTy rnd;

    auto getRnd() const {
      auto &propStorage = this->rnd;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(propStorage);
    }
    void setRnd(const ::mlir::NVVM::FPRoundingModeAttr &propValue) {
      this->rnd = propValue;
    }
    using satTy = ::mlir::NVVM::SaturationModeAttr;
    satTy sat;

    auto getSat() const {
      auto &propStorage = this->sat;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(propStorage);
    }
    void setSat(const ::mlir::NVVM::SaturationModeAttr &propValue) {
      this->sat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        rhs.rnd == this->rnd &&
        rhs.sat == this->sat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x2ToF8x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x2.to.f8x2", odsAttrs.getContext());
  }

  ConvertF32x2ToF8x2OpGenericAdaptorBase(ConvertF32x2ToF8x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::FPRoundingModeAttr getRndAttr();
  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr();
  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x2ToF8x2OpGenericAdaptor : public detail::ConvertF32x2ToF8x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x2ToF8x2OpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
public:
  ConvertF32x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x2ToF8x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x2ToF8x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x2ToF8x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x2ToF8x2OpGenericAdaptor(RangeT values, const ConvertF32x2ToF8x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x2ToF8x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x2ToF8x2Op>>>
  ConvertF32x2ToF8x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x2ToF8x2OpAdaptor : public ConvertF32x2ToF8x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x2ToF8x2OpGenericAdaptor::ConvertF32x2ToF8x2OpGenericAdaptor;
  ConvertF32x2ToF8x2OpAdaptor(ConvertF32x2ToF8x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x2ToF8x2Op : public ::mlir::Op<ConvertF32x2ToF8x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x2ToF8x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x2ToF8x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu"), ::llvm::StringRef("rnd"), ::llvm::StringRef("sat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getRndAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getRndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSatAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x2.to.f8x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::FPRoundingModeAttr getRndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(getProperties().rnd);
  }

  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(getProperties().sat);
  }

  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setRndAttr(::mlir::NVVM::FPRoundingModeAttr attr) {
    getProperties().rnd = attr;
  }

  void setRnd(::mlir::NVVM::FPRoundingMode attrValue);
  void setSatAttr(::mlir::NVVM::SaturationModeAttr attr) {
    getProperties().sat = attr;
  }

  void setSat(::mlir::NVVM::SaturationMode attrValue);
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::NVVM::FPRoundingMode rnd, ::mlir::NVVM::SaturationMode sat, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF8x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x2ToF8x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID getIntrinsicID(mlir::Type dstTy,
                                            NVVM::FPRoundingMode rnd,
                                            NVVM::SaturationMode sat,
                                            bool hasRelu);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x2ToF8x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x4ToF4x4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x4ToF4x4OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x4ToF4x4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x4.to.f4x4", odsAttrs.getContext());
  }

  ConvertF32x4ToF4x4OpGenericAdaptorBase(ConvertF32x4ToF4x4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x4ToF4x4OpGenericAdaptor : public detail::ConvertF32x4ToF4x4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x4ToF4x4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
public:
  ConvertF32x4ToF4x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x4ToF4x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x4ToF4x4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x4ToF4x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x4ToF4x4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x4ToF4x4OpGenericAdaptor(RangeT values, const ConvertF32x4ToF4x4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x4ToF4x4Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x4ToF4x4Op>>>
  ConvertF32x4ToF4x4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRbits() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x4ToF4x4OpAdaptor : public ConvertF32x4ToF4x4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x4ToF4x4OpGenericAdaptor::ConvertF32x4ToF4x4OpGenericAdaptor;
  ConvertF32x4ToF4x4OpAdaptor(ConvertF32x4ToF4x4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x4ToF4x4Op : public ::mlir::Op<ConvertF32x4ToF4x4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSMa<100,103>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x4ToF4x4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x4ToF4x4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x4.to.f4x4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRbits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRbitsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF4x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF4x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  llvm::Intrinsic::ID getIntrinsicID();
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x4ToF4x4Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x4ToF6x4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x4ToF6x4OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x4ToF6x4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x4.to.f6x4", odsAttrs.getContext());
  }

  ConvertF32x4ToF6x4OpGenericAdaptorBase(ConvertF32x4ToF6x4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x4ToF6x4OpGenericAdaptor : public detail::ConvertF32x4ToF6x4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x4ToF6x4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
public:
  ConvertF32x4ToF6x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x4ToF6x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x4ToF6x4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x4ToF6x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x4ToF6x4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x4ToF6x4OpGenericAdaptor(RangeT values, const ConvertF32x4ToF6x4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x4ToF6x4Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x4ToF6x4Op>>>
  ConvertF32x4ToF6x4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRbits() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x4ToF6x4OpAdaptor : public ConvertF32x4ToF6x4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x4ToF6x4OpGenericAdaptor::ConvertF32x4ToF6x4OpGenericAdaptor;
  ConvertF32x4ToF6x4OpAdaptor(ConvertF32x4ToF6x4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x4ToF6x4Op : public ::mlir::Op<ConvertF32x4ToF6x4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSMa<100,103>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x4ToF6x4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x4ToF6x4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x4.to.f6x4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRbits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRbitsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF6x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF6x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  llvm::Intrinsic::ID getIntrinsicID();
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x4ToF6x4Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF32x4ToF8x4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF32x4ToF8x4OpGenericAdaptorBase {
public:
  struct Properties {
    using dstTyTy = ::mlir::TypeAttr;
    dstTyTy dstTy;

    auto getDstTy() const {
      auto &propStorage = this->dstTy;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setDstTy(const ::mlir::TypeAttr &propValue) {
      this->dstTy = propValue;
    }
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstTy == this->dstTy &&
        rhs.relu == this->relu &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF32x4ToF8x4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f32x4.to.f8x4", odsAttrs.getContext());
  }

  ConvertF32x4ToF8x4OpGenericAdaptorBase(ConvertF32x4ToF8x4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
    return attr;
  }

  ::mlir::Type getDstTy();
};

} // namespace detail
template <typename RangeT>
class ConvertF32x4ToF8x4OpGenericAdaptor : public detail::ConvertF32x4ToF8x4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF32x4ToF8x4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
public:
  ConvertF32x4ToF8x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF32x4ToF8x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF32x4ToF8x4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF32x4ToF8x4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF32x4ToF8x4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF32x4ToF8x4OpGenericAdaptor(RangeT values, const ConvertF32x4ToF8x4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF32x4ToF8x4Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF32x4ToF8x4Op>>>
  ConvertF32x4ToF8x4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRbits() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF32x4ToF8x4OpAdaptor : public ConvertF32x4ToF8x4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF32x4ToF8x4OpGenericAdaptor::ConvertF32x4ToF8x4OpGenericAdaptor;
  ConvertF32x4ToF8x4OpAdaptor(ConvertF32x4ToF8x4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF32x4ToF8x4Op : public ::mlir::Op<ConvertF32x4ToF8x4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSMa<100,103>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF32x4ToF8x4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF32x4ToF8x4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_rbits = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstTy"), ::llvm::StringRef("relu")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstTyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstTyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f32x4.to.f8x4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRbits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRbitsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getDstTyAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().dstTy);
  }

  ::mlir::Type getDstTy();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setDstTyAttr(::mlir::TypeAttr attr) {
    getProperties().dstTy = attr;
  }

  void setDstTy(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, ::mlir::BoolAttr relu, ::mlir::TypeAttr dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value rbits, bool relu, ::mlir::Type dstTy);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF8x4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF32x4ToF8x4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  llvm::Intrinsic::ID getIntrinsicID();
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF32x4ToF8x4Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF4x2ToF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF4x2ToF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using srcTypeTy = ::mlir::TypeAttr;
    srcTypeTy srcType;

    auto getSrcType() const {
      auto &propStorage = this->srcType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setSrcType(const ::mlir::TypeAttr &propValue) {
      this->srcType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.srcType == this->srcType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF4x2ToF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f4x2.to.f16x2", odsAttrs.getContext());
  }

  ConvertF4x2ToF16x2OpGenericAdaptorBase(ConvertF4x2ToF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
    return attr;
  }

  ::mlir::Type getSrcType();
};

} // namespace detail
template <typename RangeT>
class ConvertF4x2ToF16x2OpGenericAdaptor : public detail::ConvertF4x2ToF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF4x2ToF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  ConvertF4x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF4x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF4x2ToF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF4x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF4x2ToF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF4x2ToF16x2OpGenericAdaptor(RangeT values, const ConvertF4x2ToF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF4x2ToF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF4x2ToF16x2Op>>>
  ConvertF4x2ToF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF4x2ToF16x2OpAdaptor : public ConvertF4x2ToF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF4x2ToF16x2OpGenericAdaptor::ConvertF4x2ToF16x2OpGenericAdaptor;
  ConvertF4x2ToF16x2OpAdaptor(ConvertF4x2ToF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF4x2ToF16x2Op : public ::mlir::Op<ConvertF4x2ToF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF4x2ToF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF4x2ToF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("srcType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f4x2.to.f16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
  }

  ::mlir::Type getSrcType();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setSrcTypeAttr(::mlir::TypeAttr attr) {
    getProperties().srcType = attr;
  }

  void setSrcType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF4x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF4x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF4x2ToF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF6x2ToF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF6x2ToF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using srcTypeTy = ::mlir::TypeAttr;
    srcTypeTy srcType;

    auto getSrcType() const {
      auto &propStorage = this->srcType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setSrcType(const ::mlir::TypeAttr &propValue) {
      this->srcType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.srcType == this->srcType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF6x2ToF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f6x2.to.f16x2", odsAttrs.getContext());
  }

  ConvertF6x2ToF16x2OpGenericAdaptorBase(ConvertF6x2ToF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
    return attr;
  }

  ::mlir::Type getSrcType();
};

} // namespace detail
template <typename RangeT>
class ConvertF6x2ToF16x2OpGenericAdaptor : public detail::ConvertF6x2ToF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF6x2ToF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  ConvertF6x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF6x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF6x2ToF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF6x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF6x2ToF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF6x2ToF16x2OpGenericAdaptor(RangeT values, const ConvertF6x2ToF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF6x2ToF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF6x2ToF16x2Op>>>
  ConvertF6x2ToF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF6x2ToF16x2OpAdaptor : public ConvertF6x2ToF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF6x2ToF16x2OpGenericAdaptor::ConvertF6x2ToF16x2OpGenericAdaptor;
  ConvertF6x2ToF16x2OpAdaptor(ConvertF6x2ToF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF6x2ToF16x2Op : public ::mlir::Op<ConvertF6x2ToF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF6x2ToF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF6x2ToF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("srcType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f6x2.to.f16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
  }

  ::mlir::Type getSrcType();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setSrcTypeAttr(::mlir::TypeAttr attr) {
    getProperties().srcType = attr;
  }

  void setSrcType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF6x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF6x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF6x2ToF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF8x2ToBF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF8x2ToBF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using srcTypeTy = ::mlir::TypeAttr;
    srcTypeTy srcType;

    auto getSrcType() const {
      auto &propStorage = this->srcType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setSrcType(const ::mlir::TypeAttr &propValue) {
      this->srcType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcType == this->srcType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF8x2ToBF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f8x2.to.bf16x2", odsAttrs.getContext());
  }

  ConvertF8x2ToBF16x2OpGenericAdaptorBase(ConvertF8x2ToBF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getSrcTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
    return attr;
  }

  ::mlir::Type getSrcType();
};

} // namespace detail
template <typename RangeT>
class ConvertF8x2ToBF16x2OpGenericAdaptor : public detail::ConvertF8x2ToBF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF8x2ToBF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  ConvertF8x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF8x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF8x2ToBF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF8x2ToBF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF8x2ToBF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF8x2ToBF16x2OpGenericAdaptor(RangeT values, const ConvertF8x2ToBF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF8x2ToBF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF8x2ToBF16x2Op>>>
  ConvertF8x2ToBF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF8x2ToBF16x2OpAdaptor : public ConvertF8x2ToBF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF8x2ToBF16x2OpGenericAdaptor::ConvertF8x2ToBF16x2OpGenericAdaptor;
  ConvertF8x2ToBF16x2OpAdaptor(ConvertF8x2ToBF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF8x2ToBF16x2Op : public ::mlir::Op<ConvertF8x2ToBF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF8x2ToBF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF8x2ToBF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f8x2.to.bf16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getSrcTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
  }

  ::mlir::Type getSrcType();
  void setSrcTypeAttr(::mlir::TypeAttr attr) {
    getProperties().srcType = attr;
  }

  void setSrcType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::Type srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::Type srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Type srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Type srcType);
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF8x2ToBF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF8x2ToBF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF8x2ToBF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertF8x2ToF16x2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertF8x2ToF16x2OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using srcTypeTy = ::mlir::TypeAttr;
    srcTypeTy srcType;

    auto getSrcType() const {
      auto &propStorage = this->srcType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setSrcType(const ::mlir::TypeAttr &propValue) {
      this->srcType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.srcType == this->srcType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertF8x2ToF16x2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.f8x2.to.f16x2", odsAttrs.getContext());
  }

  ConvertF8x2ToF16x2OpGenericAdaptorBase(ConvertF8x2ToF16x2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
    return attr;
  }

  ::mlir::Type getSrcType();
};

} // namespace detail
template <typename RangeT>
class ConvertF8x2ToF16x2OpGenericAdaptor : public detail::ConvertF8x2ToF16x2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertF8x2ToF16x2OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  ConvertF8x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertF8x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertF8x2ToF16x2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertF8x2ToF16x2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertF8x2ToF16x2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertF8x2ToF16x2OpGenericAdaptor(RangeT values, const ConvertF8x2ToF16x2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertF8x2ToF16x2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertF8x2ToF16x2Op>>>
  ConvertF8x2ToF16x2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertF8x2ToF16x2OpAdaptor : public ConvertF8x2ToF16x2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertF8x2ToF16x2OpGenericAdaptor::ConvertF8x2ToF16x2OpGenericAdaptor;
  ConvertF8x2ToF16x2OpAdaptor(ConvertF8x2ToF16x2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertF8x2ToF16x2Op : public ::mlir::Op<ConvertF8x2ToF16x2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertF8x2ToF16x2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertF8x2ToF16x2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("srcType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.f8x2.to.f16x2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  ::mlir::TypeAttr getSrcTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().srcType);
  }

  ::mlir::Type getSrcType();
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  void setSrcTypeAttr(::mlir::TypeAttr attr) {
    getProperties().srcType = attr;
  }

  void setSrcType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::BoolAttr relu, ::mlir::TypeAttr srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type dst, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool relu, ::mlir::Type srcType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF8x2ToF16x2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertF8x2ToF16x2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertF8x2ToF16x2Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ConvertFloatToTF32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertFloatToTF32OpGenericAdaptorBase {
public:
  struct Properties {
    using reluTy = ::mlir::BoolAttr;
    reluTy relu;

    auto getRelu() const {
      auto &propStorage = this->relu;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRelu(const ::mlir::BoolAttr &propValue) {
      this->relu = propValue;
    }
    using rndTy = ::mlir::NVVM::FPRoundingModeAttr;
    rndTy rnd;

    auto getRnd() const {
      auto &propStorage = this->rnd;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(propStorage);
    }
    void setRnd(const ::mlir::NVVM::FPRoundingModeAttr &propValue) {
      this->rnd = propValue;
    }
    using satTy = ::mlir::NVVM::SaturationModeAttr;
    satTy sat;

    auto getSat() const {
      auto &propStorage = this->sat;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(propStorage);
    }
    void setSat(const ::mlir::NVVM::SaturationModeAttr &propValue) {
      this->sat = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.relu == this->relu &&
        rhs.rnd == this->rnd &&
        rhs.sat == this->sat &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertFloatToTF32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.convert.float.to.tf32", odsAttrs.getContext());
  }

  ConvertFloatToTF32OpGenericAdaptorBase(ConvertFloatToTF32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::FPRoundingModeAttr getRndAttr();
  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr();
  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr();
  bool getRelu();
};

} // namespace detail
template <typename RangeT>
class ConvertFloatToTF32OpGenericAdaptor : public detail::ConvertFloatToTF32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertFloatToTF32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  ConvertFloatToTF32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertFloatToTF32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertFloatToTF32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertFloatToTF32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertFloatToTF32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertFloatToTF32OpGenericAdaptor(RangeT values, const ConvertFloatToTF32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertFloatToTF32Op, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertFloatToTF32Op>>>
  ConvertFloatToTF32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertFloatToTF32OpAdaptor : public ConvertFloatToTF32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertFloatToTF32OpGenericAdaptor::ConvertFloatToTF32OpGenericAdaptor;
  ConvertFloatToTF32OpAdaptor(ConvertFloatToTF32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertFloatToTF32Op : public ::mlir::Op<ConvertFloatToTF32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertFloatToTF32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertFloatToTF32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("relu"), ::llvm::StringRef("rnd"), ::llvm::StringRef("sat")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReluAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReluAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRndAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSatAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.convert.float.to.tf32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::FPRoundingModeAttr getRndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::FPRoundingModeAttr>(getProperties().rnd);
  }

  ::mlir::NVVM::FPRoundingMode getRnd();
  ::mlir::NVVM::SaturationModeAttr getSatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::SaturationModeAttr>(getProperties().sat);
  }

  ::mlir::NVVM::SaturationMode getSat();
  ::mlir::BoolAttr getReluAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().relu);
  }

  bool getRelu();
  void setRndAttr(::mlir::NVVM::FPRoundingModeAttr attr) {
    getProperties().rnd = attr;
  }

  void setRnd(::mlir::NVVM::FPRoundingMode attrValue);
  void setSatAttr(::mlir::NVVM::SaturationModeAttr attr) {
    getProperties().sat = attr;
  }

  void setSat(::mlir::NVVM::SaturationMode attrValue);
  void setReluAttr(::mlir::BoolAttr attr) {
    getProperties().relu = attr;
  }

  void setRelu(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingModeAttr rnd, ::mlir::NVVM::SaturationModeAttr sat = nullptr, ::mlir::BoolAttr relu = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::NVVM::FPRoundingMode rnd = FPRoundingMode::NONE, ::mlir::NVVM::SaturationMode sat = SaturationMode::NONE, bool relu = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertFloatToTF32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertFloatToTF32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID getIntrinsicID(NVVM::FPRoundingMode,
                                            NVVM::SaturationMode,
                                            bool hasRelu);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ConvertFloatToTF32Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkCommitGroupOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkCommitGroupOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkCommitGroupOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.commit.group", odsAttrs.getContext());
  }

  CpAsyncBulkCommitGroupOpGenericAdaptorBase(CpAsyncBulkCommitGroupOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkCommitGroupOpGenericAdaptor : public detail::CpAsyncBulkCommitGroupOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkCommitGroupOpGenericAdaptorBase;
public:
  CpAsyncBulkCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkCommitGroupOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncBulkCommitGroupOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkCommitGroupOpGenericAdaptor(RangeT values, const CpAsyncBulkCommitGroupOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkCommitGroupOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkCommitGroupOp>>>
  CpAsyncBulkCommitGroupOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkCommitGroupOpAdaptor : public CpAsyncBulkCommitGroupOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkCommitGroupOpGenericAdaptor::CpAsyncBulkCommitGroupOpGenericAdaptor;
  CpAsyncBulkCommitGroupOpAdaptor(CpAsyncBulkCommitGroupOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkCommitGroupOp : public ::mlir::Op<CpAsyncBulkCommitGroupOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkCommitGroupOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkCommitGroupOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.commit.group");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static CpAsyncBulkCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static CpAsyncBulkCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static CpAsyncBulkCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static CpAsyncBulkCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkCommitGroupOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkGlobalToSharedClusterOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 6>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.shared.cluster.global", odsAttrs.getContext());
  }

  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase(CpAsyncBulkGlobalToSharedClusterOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor : public detail::CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_mbar = 2;
  static constexpr int odsIndex_size = 3;
  static constexpr int odsIndex_multicastMask = 4;
  static constexpr int odsIndex_l2CacheHint = 5;
public:
  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(RangeT values, const CpAsyncBulkGlobalToSharedClusterOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkGlobalToSharedClusterOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkGlobalToSharedClusterOp>>>
  CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDstMem() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcMem() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMbar() {
    return (*getODSOperands(2).begin());
  }

  ValueT getSize() {
    return (*getODSOperands(3).begin());
  }

  ValueT getMulticastMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkGlobalToSharedClusterOpAdaptor : public CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor::CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor;
  CpAsyncBulkGlobalToSharedClusterOpAdaptor(CpAsyncBulkGlobalToSharedClusterOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkGlobalToSharedClusterOp : public ::mlir::Op<CpAsyncBulkGlobalToSharedClusterOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkGlobalToSharedClusterOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkGlobalToSharedClusterOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_mbar = 2;
  static constexpr int odsIndex_size = 3;
  static constexpr int odsIndex_multicastMask = 4;
  static constexpr int odsIndex_l2CacheHint = 5;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.shared.cluster.global");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDstMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getMulticastMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getDstMemMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSizeMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getMulticastMaskMutable();
  ::mlir::MutableOperandRange getL2CacheHintMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkGlobalToSharedClusterOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkPrefetchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkPrefetchOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkPrefetchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.prefetch", odsAttrs.getContext());
  }

  CpAsyncBulkPrefetchOpGenericAdaptorBase(CpAsyncBulkPrefetchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkPrefetchOpGenericAdaptor : public detail::CpAsyncBulkPrefetchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkPrefetchOpGenericAdaptorBase;
  static constexpr int odsIndex_srcMem = 0;
  static constexpr int odsIndex_size = 1;
  static constexpr int odsIndex_l2CacheHint = 2;
public:
  CpAsyncBulkPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkPrefetchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncBulkPrefetchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkPrefetchOpGenericAdaptor(RangeT values, const CpAsyncBulkPrefetchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkPrefetchOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkPrefetchOp>>>
  CpAsyncBulkPrefetchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcMem() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSize() {
    return (*getODSOperands(1).begin());
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkPrefetchOpAdaptor : public CpAsyncBulkPrefetchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkPrefetchOpGenericAdaptor::CpAsyncBulkPrefetchOpGenericAdaptor;
  CpAsyncBulkPrefetchOpAdaptor(CpAsyncBulkPrefetchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkPrefetchOp : public ::mlir::Op<CpAsyncBulkPrefetchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkPrefetchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkPrefetchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcMem = 0;
  static constexpr int odsIndex_size = 1;
  static constexpr int odsIndex_l2CacheHint = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.prefetch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSizeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getL2CacheHintMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkPrefetchOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkSharedCTAToGlobalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.global.shared.cta", odsAttrs.getContext());
  }

  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase(CpAsyncBulkSharedCTAToGlobalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor : public detail::CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_size = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  static constexpr int odsIndex_byteMask = 4;
public:
  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(RangeT values, const CpAsyncBulkSharedCTAToGlobalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkSharedCTAToGlobalOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkSharedCTAToGlobalOp>>>
  CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDstMem() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcMem() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSize() {
    return (*getODSOperands(2).begin());
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getByteMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkSharedCTAToGlobalOpAdaptor : public CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor::CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor;
  CpAsyncBulkSharedCTAToGlobalOpAdaptor(CpAsyncBulkSharedCTAToGlobalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkSharedCTAToGlobalOp : public ::mlir::Op<CpAsyncBulkSharedCTAToGlobalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkSharedCTAToGlobalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkSharedCTAToGlobalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_size = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  static constexpr int odsIndex_byteMask = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.global.shared.cta");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getDstMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getByteMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getDstMemMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSizeMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getL2CacheHintMutable();
  ::mlir::MutableOperandRange getByteMaskMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value size, /*optional*/::mlir::Value l2CacheHint, /*optional*/::mlir::Value byteMask);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkSharedCTAToGlobalOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkSharedCTAToSharedClusterOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.shared.cluster.shared.cta", odsAttrs.getContext());
  }

  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase(CpAsyncBulkSharedCTAToSharedClusterOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor : public detail::CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_mbar = 2;
  static constexpr int odsIndex_size = 3;
public:
  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(RangeT values, const CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkSharedCTAToSharedClusterOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkSharedCTAToSharedClusterOp>>>
  CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDstMem() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcMem() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMbar() {
    return (*getODSOperands(2).begin());
  }

  ValueT getSize() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkSharedCTAToSharedClusterOpAdaptor : public CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor::CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor;
  CpAsyncBulkSharedCTAToSharedClusterOpAdaptor(CpAsyncBulkSharedCTAToSharedClusterOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkSharedCTAToSharedClusterOp : public ::mlir::Op<CpAsyncBulkSharedCTAToSharedClusterOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkSharedCTAToSharedClusterOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkSharedCTAToSharedClusterOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_mbar = 2;
  static constexpr int odsIndex_size = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.shared.cluster.shared.cta");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getDstMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getDstMemMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSizeMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value srcMem, ::mlir::Value mbar, ::mlir::Value size);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkSharedCTAToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkSharedCTAToSharedClusterOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkTensorGlobalToSharedClusterOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase {
public:
  struct Properties {
    using groupTy = ::mlir::NVVM::CTAGroupKindAttr;
    groupTy group;

    auto getGroup() const {
      auto &propStorage = this->group;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::CTAGroupKindAttr>(propStorage);
    }
    void setGroup(const ::mlir::NVVM::CTAGroupKindAttr &propValue) {
      this->group = propValue;
    }
    using isCTAOnlyTy = ::mlir::BoolAttr;
    isCTAOnlyTy isCTAOnly;

    auto getIsCTAOnly() const {
      auto &propStorage = this->isCTAOnly;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setIsCTAOnly(const ::mlir::BoolAttr &propValue) {
      this->isCTAOnly = propValue;
    }
    using modeTy = ::mlir::NVVM::TMALoadModeAttr;
    modeTy mode;

    auto getMode() const {
      auto &propStorage = this->mode;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMALoadModeAttr>(propStorage);
    }
    void setMode(const ::mlir::NVVM::TMALoadModeAttr &propValue) {
      this->mode = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 8>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.group == this->group &&
        rhs.isCTAOnly == this->isCTAOnly &&
        rhs.mode == this->mode &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.tensor.shared.cluster.global", odsAttrs.getContext());
  }

  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase(CpAsyncBulkTensorGlobalToSharedClusterOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::TMALoadModeAttr getModeAttr();
  ::mlir::NVVM::TMALoadMode getMode();
  ::mlir::BoolAttr getIsCTAOnlyAttr();
  bool getIsCTAOnly();
  ::mlir::NVVM::CTAGroupKindAttr getGroupAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::NVVM::CTAGroupKindAttr>(getProperties().group);
    return attr;
  }

  ::std::optional<::mlir::NVVM::CTAGroupKind> getGroup();
};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor : public detail::CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_tmaDescriptor = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_mbar = 3;
  static constexpr int odsIndex_im2colOffsets = 4;
  static constexpr int odsIndex_multicastMask = 5;
  static constexpr int odsIndex_l2CacheHint = 6;
  static constexpr int odsIndex_predicate = 7;
public:
  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(RangeT values, const CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkTensorGlobalToSharedClusterOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkTensorGlobalToSharedClusterOp>>>
  CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDstMem() {
    return (*getODSOperands(0).begin());
  }

  ValueT getTmaDescriptor() {
    return (*getODSOperands(1).begin());
  }

  RangeT getCoordinates() {
    return getODSOperands(2);
  }

  ValueT getMbar() {
    return (*getODSOperands(3).begin());
  }

  RangeT getIm2colOffsets() {
    return getODSOperands(4);
  }

  ValueT getMulticastMask() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPredicate() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkTensorGlobalToSharedClusterOpAdaptor : public CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor::CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor;
  CpAsyncBulkTensorGlobalToSharedClusterOpAdaptor(CpAsyncBulkTensorGlobalToSharedClusterOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkTensorGlobalToSharedClusterOp : public ::mlir::Op<CpAsyncBulkTensorGlobalToSharedClusterOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::NVVM::BasicPtxBuilderInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkTensorGlobalToSharedClusterOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkTensorGlobalToSharedClusterOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dstMem = 0;
  static constexpr int odsIndex_tmaDescriptor = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_mbar = 3;
  static constexpr int odsIndex_im2colOffsets = 4;
  static constexpr int odsIndex_multicastMask = 5;
  static constexpr int odsIndex_l2CacheHint = 6;
  static constexpr int odsIndex_predicate = 7;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorGlobalToSharedClusterOp>::getPredicate;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorGlobalToSharedClusterOp>::hasIntrinsic;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorGlobalToSharedClusterOp>::hasSideEffect;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorGlobalToSharedClusterOp>::makeConstantI32;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorGlobalToSharedClusterOp>::getAsmValues;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("group"), ::llvm::StringRef("isCTAOnly"), ::llvm::StringRef("mode"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGroupAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGroupAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIsCTAOnlyAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIsCTAOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getModeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.tensor.shared.cluster.global");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDstMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getTmaDescriptor() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getCoordinates() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(3).begin());
  }

  ::mlir::Operation::operand_range getIm2colOffsets() {
    return getODSOperands(4);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getMulticastMask() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPredicate() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getDstMemMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getTmaDescriptorMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordinatesMutable();
  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIm2colOffsetsMutable();
  ::mlir::MutableOperandRange getMulticastMaskMutable();
  ::mlir::MutableOperandRange getL2CacheHintMutable();
  ::mlir::MutableOperandRange getPredicateMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::TMALoadModeAttr getModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMALoadModeAttr>(getProperties().mode);
  }

  ::mlir::NVVM::TMALoadMode getMode();
  ::mlir::BoolAttr getIsCTAOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().isCTAOnly);
  }

  bool getIsCTAOnly();
  ::mlir::NVVM::CTAGroupKindAttr getGroupAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::CTAGroupKindAttr>(getProperties().group);
  }

  ::std::optional<::mlir::NVVM::CTAGroupKind> getGroup();
  void setModeAttr(::mlir::NVVM::TMALoadModeAttr attr) {
    getProperties().mode = attr;
  }

  void setMode(::mlir::NVVM::TMALoadMode attrValue);
  void setIsCTAOnlyAttr(::mlir::BoolAttr attr) {
    getProperties().isCTAOnly = attr;
  }

  void setIsCTAOnly(bool attrValue);
  void setGroupAttr(::mlir::NVVM::CTAGroupKindAttr attr) {
    getProperties().group = attr;
  }

  void setGroup(::std::optional<::mlir::NVVM::CTAGroupKind> attrValue);
  ::mlir::Attribute removeGroupAttr() {
      auto attr = getProperties().group;
      getProperties().group = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadModeAttr mode, ::mlir::BoolAttr isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dstMem, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::Value mbar, ::mlir::ValueRange im2colOffsets, /*optional*/::mlir::Value multicastMask, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMALoadMode mode, bool isCTAOnly, /*optional*/::mlir::NVVM::CTAGroupKindAttr group, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorGlobalToSharedClusterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  std::string getPtx();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  bool hasIntrinsic() { return !getPredicate(); }

  bool getAsmValues(RewriterBase &rewriter,
    llvm::SmallVectorImpl<std::pair<mlir::Value, mlir::NVVM::PTXRegisterMod>> &asmValues);

  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkTensorGlobalToSharedClusterOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkTensorPrefetchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkTensorPrefetchOpGenericAdaptorBase {
public:
  struct Properties {
    using modeTy = ::mlir::NVVM::TMALoadModeAttr;
    modeTy mode;

    auto getMode() const {
      auto &propStorage = this->mode;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMALoadModeAttr>(propStorage);
    }
    void setMode(const ::mlir::NVVM::TMALoadModeAttr &propValue) {
      this->mode = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.mode == this->mode &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkTensorPrefetchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.tensor.prefetch", odsAttrs.getContext());
  }

  CpAsyncBulkTensorPrefetchOpGenericAdaptorBase(CpAsyncBulkTensorPrefetchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::TMALoadModeAttr getModeAttr();
  ::mlir::NVVM::TMALoadMode getMode();
};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkTensorPrefetchOpGenericAdaptor : public detail::CpAsyncBulkTensorPrefetchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkTensorPrefetchOpGenericAdaptorBase;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_coordinates = 1;
  static constexpr int odsIndex_im2colOffsets = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
public:
  CpAsyncBulkTensorPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkTensorPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkTensorPrefetchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkTensorPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkTensorPrefetchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkTensorPrefetchOpGenericAdaptor(RangeT values, const CpAsyncBulkTensorPrefetchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkTensorPrefetchOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkTensorPrefetchOp>>>
  CpAsyncBulkTensorPrefetchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTmaDescriptor() {
    return (*getODSOperands(0).begin());
  }

  RangeT getCoordinates() {
    return getODSOperands(1);
  }

  RangeT getIm2colOffsets() {
    return getODSOperands(2);
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkTensorPrefetchOpAdaptor : public CpAsyncBulkTensorPrefetchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkTensorPrefetchOpGenericAdaptor::CpAsyncBulkTensorPrefetchOpGenericAdaptor;
  CpAsyncBulkTensorPrefetchOpAdaptor(CpAsyncBulkTensorPrefetchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkTensorPrefetchOp : public ::mlir::Op<CpAsyncBulkTensorPrefetchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkTensorPrefetchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkTensorPrefetchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_coordinates = 1;
  static constexpr int odsIndex_im2colOffsets = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("mode"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getModeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.tensor.prefetch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getTmaDescriptor() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getCoordinates() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getIm2colOffsets() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getTmaDescriptorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordinatesMutable();
  ::mlir::MutableOperandRange getIm2colOffsetsMutable();
  ::mlir::MutableOperandRange getL2CacheHintMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::TMALoadModeAttr getModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMALoadModeAttr>(getProperties().mode);
  }

  ::mlir::NVVM::TMALoadMode getMode();
  void setModeAttr(::mlir::NVVM::TMALoadModeAttr attr) {
    getProperties().mode = attr;
  }

  void setMode(::mlir::NVVM::TMALoadMode attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadModeAttr mode, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::ValueRange coordinates, ::mlir::ValueRange im2colOffsets, ::mlir::NVVM::TMALoadMode mode, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkTensorPrefetchOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkTensorReduceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkTensorReduceOpGenericAdaptorBase {
public:
  struct Properties {
    using modeTy = ::mlir::NVVM::TMAStoreModeAttr;
    modeTy mode;

    auto getMode() const {
      auto &propStorage = this->mode;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMAStoreModeAttr>(propStorage);
    }
    void setMode(const ::mlir::NVVM::TMAStoreModeAttr &propValue) {
      this->mode = propValue;
    }
    using redKindTy = ::mlir::NVVM::TMAReduxKindAttr;
    redKindTy redKind;

    auto getRedKind() const {
      auto &propStorage = this->redKind;
      return ::llvm::cast<::mlir::NVVM::TMAReduxKindAttr>(propStorage);
    }
    void setRedKind(const ::mlir::NVVM::TMAReduxKindAttr &propValue) {
      this->redKind = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.mode == this->mode &&
        rhs.redKind == this->redKind &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkTensorReduceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.tensor.reduce", odsAttrs.getContext());
  }

  CpAsyncBulkTensorReduceOpGenericAdaptorBase(CpAsyncBulkTensorReduceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::TMAReduxKindAttr getRedKindAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::TMAReduxKindAttr>(getProperties().redKind);
    return attr;
  }

  ::mlir::NVVM::TMAReduxKind getRedKind();
  ::mlir::NVVM::TMAStoreModeAttr getModeAttr();
  ::mlir::NVVM::TMAStoreMode getMode();
};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkTensorReduceOpGenericAdaptor : public detail::CpAsyncBulkTensorReduceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkTensorReduceOpGenericAdaptorBase;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
public:
  CpAsyncBulkTensorReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkTensorReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkTensorReduceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkTensorReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkTensorReduceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkTensorReduceOpGenericAdaptor(RangeT values, const CpAsyncBulkTensorReduceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkTensorReduceOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkTensorReduceOp>>>
  CpAsyncBulkTensorReduceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTmaDescriptor() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcMem() {
    return (*getODSOperands(1).begin());
  }

  RangeT getCoordinates() {
    return getODSOperands(2);
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkTensorReduceOpAdaptor : public CpAsyncBulkTensorReduceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkTensorReduceOpGenericAdaptor::CpAsyncBulkTensorReduceOpGenericAdaptor;
  CpAsyncBulkTensorReduceOpAdaptor(CpAsyncBulkTensorReduceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkTensorReduceOp : public ::mlir::Op<CpAsyncBulkTensorReduceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkTensorReduceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkTensorReduceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("mode"), ::llvm::StringRef("redKind"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getModeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRedKindAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRedKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.tensor.reduce");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getTmaDescriptor() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getCoordinates() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getTmaDescriptorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordinatesMutable();
  ::mlir::MutableOperandRange getL2CacheHintMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::TMAReduxKindAttr getRedKindAttr() {
    return ::llvm::cast<::mlir::NVVM::TMAReduxKindAttr>(getProperties().redKind);
  }

  ::mlir::NVVM::TMAReduxKind getRedKind();
  ::mlir::NVVM::TMAStoreModeAttr getModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMAStoreModeAttr>(getProperties().mode);
  }

  ::mlir::NVVM::TMAStoreMode getMode();
  void setRedKindAttr(::mlir::NVVM::TMAReduxKindAttr attr) {
    getProperties().redKind = attr;
  }

  void setRedKind(::mlir::NVVM::TMAReduxKind attrValue);
  void setModeAttr(::mlir::NVVM::TMAStoreModeAttr attr) {
    getProperties().mode = attr;
  }

  void setMode(::mlir::NVVM::TMAStoreMode attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKindAttr redKind, ::mlir::NVVM::TMAStoreModeAttr mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::NVVM::TMAReduxKind redKind, ::mlir::NVVM::TMAStoreMode mode, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op,
    LLVM::ModuleTranslation &mt, llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkTensorReduceOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkTensorSharedCTAToGlobalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase {
public:
  struct Properties {
    using modeTy = ::mlir::NVVM::TMAStoreModeAttr;
    modeTy mode;

    auto getMode() const {
      auto &propStorage = this->mode;
      return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMAStoreModeAttr>(propStorage);
    }
    void setMode(const ::mlir::NVVM::TMAStoreModeAttr &propValue) {
      this->mode = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.mode == this->mode &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.tensor.global.shared.cta", odsAttrs.getContext());
  }

  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase(CpAsyncBulkTensorSharedCTAToGlobalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::TMAStoreModeAttr getModeAttr();
  ::mlir::NVVM::TMAStoreMode getMode();
};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor : public detail::CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  static constexpr int odsIndex_predicate = 4;
public:
  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(RangeT values, const CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkTensorSharedCTAToGlobalOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkTensorSharedCTAToGlobalOp>>>
  CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTmaDescriptor() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcMem() {
    return (*getODSOperands(1).begin());
  }

  RangeT getCoordinates() {
    return getODSOperands(2);
  }

  ValueT getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPredicate() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkTensorSharedCTAToGlobalOpAdaptor : public CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor::CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor;
  CpAsyncBulkTensorSharedCTAToGlobalOpAdaptor(CpAsyncBulkTensorSharedCTAToGlobalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkTensorSharedCTAToGlobalOp : public ::mlir::Op<CpAsyncBulkTensorSharedCTAToGlobalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::NVVM::BasicPtxBuilderInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkTensorSharedCTAToGlobalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkTensorSharedCTAToGlobalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_tmaDescriptor = 0;
  static constexpr int odsIndex_srcMem = 1;
  static constexpr int odsIndex_coordinates = 2;
  static constexpr int odsIndex_l2CacheHint = 3;
  static constexpr int odsIndex_predicate = 4;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorSharedCTAToGlobalOp>::getPredicate;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorSharedCTAToGlobalOp>::hasIntrinsic;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorSharedCTAToGlobalOp>::hasSideEffect;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorSharedCTAToGlobalOp>::makeConstantI32;
  using ::mlir::NVVM::BasicPtxBuilderInterface::Trait<CpAsyncBulkTensorSharedCTAToGlobalOp>::getAsmValues;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("mode"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getModeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.tensor.global.shared.cta");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getTmaDescriptor() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrcMem() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getCoordinates() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getL2CacheHint() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPredicate() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getTmaDescriptorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMemMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordinatesMutable();
  ::mlir::MutableOperandRange getL2CacheHintMutable();
  ::mlir::MutableOperandRange getPredicateMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::TMAStoreModeAttr getModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::NVVM::TMAStoreModeAttr>(getProperties().mode);
  }

  ::mlir::NVVM::TMAStoreMode getMode();
  void setModeAttr(::mlir::NVVM::TMAStoreModeAttr attr) {
    getProperties().mode = attr;
  }

  void setMode(::mlir::NVVM::TMAStoreMode attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreModeAttr mode, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value tmaDescriptor, ::mlir::Value srcMem, ::mlir::ValueRange coordinates, /*optional*/::mlir::Value l2CacheHint, ::mlir::NVVM::TMAStoreMode mode, /*optional*/::mlir::Value predicate);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkTensorSharedCTAToGlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  std::string getPtx();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  bool hasIntrinsic() { return !getPredicate(); }

  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase& builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkTensorSharedCTAToGlobalOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncBulkWaitGroupOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncBulkWaitGroupOpGenericAdaptorBase {
public:
  struct Properties {
    using groupTy = ::mlir::IntegerAttr;
    groupTy group;

    auto getGroup() const {
      auto &propStorage = this->group;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setGroup(const ::mlir::IntegerAttr &propValue) {
      this->group = propValue;
    }
    using readTy = ::mlir::UnitAttr;
    readTy read;

    auto getRead() const {
      auto &propStorage = this->read;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRead(const ::mlir::UnitAttr &propValue) {
      this->read = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.group == this->group &&
        rhs.read == this->read &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncBulkWaitGroupOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.bulk.wait_group", odsAttrs.getContext());
  }

  CpAsyncBulkWaitGroupOpGenericAdaptorBase(CpAsyncBulkWaitGroupOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getGroupAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().group);
    return attr;
  }

  uint32_t getGroup();
  ::mlir::UnitAttr getReadAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().read);
    return attr;
  }

  ::std::optional<bool> getRead();
};

} // namespace detail
template <typename RangeT>
class CpAsyncBulkWaitGroupOpGenericAdaptor : public detail::CpAsyncBulkWaitGroupOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncBulkWaitGroupOpGenericAdaptorBase;
public:
  CpAsyncBulkWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncBulkWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncBulkWaitGroupOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncBulkWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncBulkWaitGroupOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncBulkWaitGroupOpGenericAdaptor(RangeT values, const CpAsyncBulkWaitGroupOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncBulkWaitGroupOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncBulkWaitGroupOp>>>
  CpAsyncBulkWaitGroupOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncBulkWaitGroupOpAdaptor : public CpAsyncBulkWaitGroupOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncBulkWaitGroupOpGenericAdaptor::CpAsyncBulkWaitGroupOpGenericAdaptor;
  CpAsyncBulkWaitGroupOpAdaptor(CpAsyncBulkWaitGroupOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncBulkWaitGroupOp : public ::mlir::Op<CpAsyncBulkWaitGroupOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::NVVMRequiresSM<90>::Impl> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncBulkWaitGroupOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncBulkWaitGroupOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("group"), ::llvm::StringRef("read")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGroupAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGroupAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReadAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.bulk.wait_group");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getGroupAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().group);
  }

  uint32_t getGroup();
  ::mlir::UnitAttr getReadAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().read);
  }

  ::std::optional<bool> getRead();
  void setGroupAttr(::mlir::IntegerAttr attr) {
    getProperties().group = attr;
  }

  void setGroup(uint32_t attrValue);
  void setReadAttr(::mlir::UnitAttr attr) {
    getProperties().read = attr;
  }

  void setRead(bool attrValue);
  ::mlir::Attribute removeReadAttr() {
      auto attr = getProperties().read;
      getProperties().read = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr group, /*optional*/::mlir::UnitAttr read);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t group, /*optional*/::mlir::UnitAttr read);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncBulkWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncBulkWaitGroupOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncCommitGroupOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncCommitGroupOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncCommitGroupOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.commit.group", odsAttrs.getContext());
  }

  CpAsyncCommitGroupOpGenericAdaptorBase(CpAsyncCommitGroupOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CpAsyncCommitGroupOpGenericAdaptor : public detail::CpAsyncCommitGroupOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncCommitGroupOpGenericAdaptorBase;
public:
  CpAsyncCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncCommitGroupOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncCommitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncCommitGroupOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncCommitGroupOpGenericAdaptor(RangeT values, const CpAsyncCommitGroupOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncCommitGroupOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncCommitGroupOp>>>
  CpAsyncCommitGroupOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncCommitGroupOpAdaptor : public CpAsyncCommitGroupOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncCommitGroupOpGenericAdaptor::CpAsyncCommitGroupOpGenericAdaptor;
  CpAsyncCommitGroupOpAdaptor(CpAsyncCommitGroupOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncCommitGroupOp : public ::mlir::Op<CpAsyncCommitGroupOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncCommitGroupOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncCommitGroupOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.commit.group");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static CpAsyncCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static CpAsyncCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static CpAsyncCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static CpAsyncCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncCommitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncCommitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncCommitGroupOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncMBarrierArriveOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncMBarrierArriveOpGenericAdaptorBase {
public:
  struct Properties {
    using noincTy = ::mlir::IntegerAttr;
    noincTy noinc;

    auto getNoinc() const {
      auto &propStorage = this->noinc;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setNoinc(const ::mlir::IntegerAttr &propValue) {
      this->noinc = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.noinc == this->noinc &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncMBarrierArriveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.mbarrier.arrive", odsAttrs.getContext());
  }

  CpAsyncMBarrierArriveOpGenericAdaptorBase(CpAsyncMBarrierArriveOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getNoincAttr();
  bool getNoinc();
};

} // namespace detail
template <typename RangeT>
class CpAsyncMBarrierArriveOpGenericAdaptor : public detail::CpAsyncMBarrierArriveOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncMBarrierArriveOpGenericAdaptorBase;
  static constexpr int odsIndex_addr = 0;
public:
  CpAsyncMBarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncMBarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncMBarrierArriveOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncMBarrierArriveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncMBarrierArriveOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncMBarrierArriveOpGenericAdaptor(RangeT values, const CpAsyncMBarrierArriveOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncMBarrierArriveOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncMBarrierArriveOp>>>
  CpAsyncMBarrierArriveOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAddr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncMBarrierArriveOpAdaptor : public CpAsyncMBarrierArriveOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncMBarrierArriveOpGenericAdaptor::CpAsyncMBarrierArriveOpGenericAdaptor;
  CpAsyncMBarrierArriveOpAdaptor(CpAsyncMBarrierArriveOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncMBarrierArriveOp : public ::mlir::Op<CpAsyncMBarrierArriveOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncMBarrierArriveOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncMBarrierArriveOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_addr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("noinc")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNoincAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNoincAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.mbarrier.arrive");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAddr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAddrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getNoincAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().noinc);
  }

  bool getNoinc();
  void setNoincAttr(::mlir::IntegerAttr attr) {
    getProperties().noinc = attr;
  }

  void setNoinc(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::IntegerAttr noinc);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, bool noinc = 0);
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value addr, bool noinc = 0);
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value addr, bool noinc = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, bool noinc = 0);
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, bool noinc = 0);
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, bool noinc = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncMBarrierArriveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncMBarrierArriveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static NVVM::IDArgPair
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncMBarrierArriveOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncOpGenericAdaptorBase {
public:
  struct Properties {
    using modifierTy = ::mlir::NVVM::LoadCacheModifierKindAttr;
    modifierTy modifier;

    auto getModifier() const {
      auto &propStorage = this->modifier;
      return ::llvm::cast<::mlir::NVVM::LoadCacheModifierKindAttr>(propStorage);
    }
    void setModifier(const ::mlir::NVVM::LoadCacheModifierKindAttr &propValue) {
      this->modifier = propValue;
    }
    using sizeTy = ::mlir::IntegerAttr;
    sizeTy size;

    auto getSize() const {
      auto &propStorage = this->size;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSize(const ::mlir::IntegerAttr &propValue) {
      this->size = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.modifier == this->modifier &&
        rhs.size == this->size &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.shared.global", odsAttrs.getContext());
  }

  CpAsyncOpGenericAdaptorBase(CpAsyncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
    return attr;
  }

  uint32_t getSize();
  ::mlir::NVVM::LoadCacheModifierKindAttr getModifierAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::LoadCacheModifierKindAttr>(getProperties().modifier);
    return attr;
  }

  ::mlir::NVVM::LoadCacheModifierKind getModifier();
};

} // namespace detail
template <typename RangeT>
class CpAsyncOpGenericAdaptor : public detail::CpAsyncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncOpGenericAdaptorBase;
  static constexpr int odsIndex_dst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_cpSize = 2;
public:
  CpAsyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncOpGenericAdaptor(RangeT values, const CpAsyncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncOp>>>
  CpAsyncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getCpSize() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncOpAdaptor : public CpAsyncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncOpGenericAdaptor::CpAsyncOpGenericAdaptor;
  CpAsyncOpAdaptor(CpAsyncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncOp : public ::mlir::Op<CpAsyncOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_cpSize = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("modifier"), ::llvm::StringRef("size")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getModifierAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getModifierAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.shared.global");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCpSize() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getDstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCpSizeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
  }

  uint32_t getSize();
  ::mlir::NVVM::LoadCacheModifierKindAttr getModifierAttr() {
    return ::llvm::cast<::mlir::NVVM::LoadCacheModifierKindAttr>(getProperties().modifier);
  }

  ::mlir::NVVM::LoadCacheModifierKind getModifier();
  void setSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().size = attr;
  }

  void setSize(uint32_t attrValue);
  void setModifierAttr(::mlir::NVVM::LoadCacheModifierKindAttr attr) {
    getProperties().modifier = attr;
  }

  void setModifier(::mlir::NVVM::LoadCacheModifierKind attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr size, ::mlir::NVVM::LoadCacheModifierKindAttr modifier, /*optional*/::mlir::Value cpSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, uint32_t size, ::mlir::NVVM::LoadCacheModifierKind modifier, /*optional*/::mlir::Value cpSize);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static llvm::Intrinsic::ID
    getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                          llvm::SmallVector<llvm::Value *> &args);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::CpAsyncWaitGroupOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CpAsyncWaitGroupOpGenericAdaptorBase {
public:
  struct Properties {
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.n == this->n &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CpAsyncWaitGroupOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.cp.async.wait.group", odsAttrs.getContext());
  }

  CpAsyncWaitGroupOpGenericAdaptorBase(CpAsyncWaitGroupOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
};

} // namespace detail
template <typename RangeT>
class CpAsyncWaitGroupOpGenericAdaptor : public detail::CpAsyncWaitGroupOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CpAsyncWaitGroupOpGenericAdaptorBase;
public:
  CpAsyncWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CpAsyncWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CpAsyncWaitGroupOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CpAsyncWaitGroupOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CpAsyncWaitGroupOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CpAsyncWaitGroupOpGenericAdaptor(RangeT values, const CpAsyncWaitGroupOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CpAsyncWaitGroupOp, typename = std::enable_if_t<std::is_same_v<LateInst, CpAsyncWaitGroupOp>>>
  CpAsyncWaitGroupOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CpAsyncWaitGroupOpAdaptor : public CpAsyncWaitGroupOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CpAsyncWaitGroupOpGenericAdaptor::CpAsyncWaitGroupOpGenericAdaptor;
  CpAsyncWaitGroupOpAdaptor(CpAsyncWaitGroupOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CpAsyncWaitGroupOp : public ::mlir::Op<CpAsyncWaitGroupOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CpAsyncWaitGroupOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CpAsyncWaitGroupOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("n")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.cp.async.wait.group");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr n);
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr n);
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr n);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr n);
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr n);
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr n);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t n);
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t n);
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t n);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t n);
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t n);
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t n);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncWaitGroupOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CpAsyncWaitGroupOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::CpAsyncWaitGroupOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::DotAccumulate2WayOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DotAccumulate2WayOpGenericAdaptorBase {
public:
  struct Properties {
    using a_typeTy = ::mlir::NVVM::DotAccumulateTypeAttr;
    a_typeTy a_type;

    auto getAType() const {
      auto &propStorage = this->a_type;
      return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(propStorage);
    }
    void setAType(const ::mlir::NVVM::DotAccumulateTypeAttr &propValue) {
      this->a_type = propValue;
    }
    using b_hiTy = ::mlir::BoolAttr;
    b_hiTy b_hi;

    auto getBHi() const {
      auto &propStorage = this->b_hi;
      return ::llvm::cast<::mlir::BoolAttr>(propStorage);
    }
    void setBHi(const ::mlir::BoolAttr &propValue) {
      this->b_hi = propValue;
    }
    using b_typeTy = ::mlir::NVVM::DotAccumulateTypeAttr;
    b_typeTy b_type;

    auto getBType() const {
      auto &propStorage = this->b_type;
      return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(propStorage);
    }
    void setBType(const ::mlir::NVVM::DotAccumulateTypeAttr &propValue) {
      this->b_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.a_type == this->a_type &&
        rhs.b_hi == this->b_hi &&
        rhs.b_type == this->b_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DotAccumulate2WayOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.dot.accumulate.2way", odsAttrs.getContext());
  }

  DotAccumulate2WayOpGenericAdaptorBase(DotAccumulate2WayOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::DotAccumulateTypeAttr getATypeAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().a_type);
    return attr;
  }

  ::mlir::NVVM::DotAccumulateType getAType();
  ::mlir::NVVM::DotAccumulateTypeAttr getBTypeAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().b_type);
    return attr;
  }

  ::mlir::NVVM::DotAccumulateType getBType();
  ::mlir::BoolAttr getBHiAttr() {
    auto attr = ::llvm::cast<::mlir::BoolAttr>(getProperties().b_hi);
    return attr;
  }

  bool getBHi();
};

} // namespace detail
template <typename RangeT>
class DotAccumulate2WayOpGenericAdaptor : public detail::DotAccumulate2WayOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DotAccumulate2WayOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
public:
  DotAccumulate2WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DotAccumulate2WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DotAccumulate2WayOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DotAccumulate2WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DotAccumulate2WayOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DotAccumulate2WayOpGenericAdaptor(RangeT values, const DotAccumulate2WayOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DotAccumulate2WayOp, typename = std::enable_if_t<std::is_same_v<LateInst, DotAccumulate2WayOp>>>
  DotAccumulate2WayOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DotAccumulate2WayOpAdaptor : public DotAccumulate2WayOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DotAccumulate2WayOpGenericAdaptor::DotAccumulate2WayOpGenericAdaptor;
  DotAccumulate2WayOpAdaptor(DotAccumulate2WayOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DotAccumulate2WayOp : public ::mlir::Op<DotAccumulate2WayOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DotAccumulate2WayOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DotAccumulate2WayOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("a_type"), ::llvm::StringRef("b_hi"), ::llvm::StringRef("b_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getATypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getATypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBHiAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBHiAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getBTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getBTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.dot.accumulate.2way");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::DotAccumulateTypeAttr getATypeAttr() {
    return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().a_type);
  }

  ::mlir::NVVM::DotAccumulateType getAType();
  ::mlir::NVVM::DotAccumulateTypeAttr getBTypeAttr() {
    return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().b_type);
  }

  ::mlir::NVVM::DotAccumulateType getBType();
  ::mlir::BoolAttr getBHiAttr() {
    return ::llvm::cast<::mlir::BoolAttr>(getProperties().b_hi);
  }

  bool getBHi();
  void setATypeAttr(::mlir::NVVM::DotAccumulateTypeAttr attr) {
    getProperties().a_type = attr;
  }

  void setAType(::mlir::NVVM::DotAccumulateType attrValue);
  void setBTypeAttr(::mlir::NVVM::DotAccumulateTypeAttr attr) {
    getProperties().b_type = attr;
  }

  void setBType(::mlir::NVVM::DotAccumulateType attrValue);
  void setBHiAttr(::mlir::BoolAttr attr) {
    getProperties().b_hi = attr;
  }

  void setBHi(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c, ::mlir::BoolAttr b_hi);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c, bool b_hi);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotAccumulate2WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotAccumulate2WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::DotAccumulate2WayOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::DotAccumulate4WayOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DotAccumulate4WayOpGenericAdaptorBase {
public:
  struct Properties {
    using a_typeTy = ::mlir::NVVM::DotAccumulateTypeAttr;
    a_typeTy a_type;

    auto getAType() const {
      auto &propStorage = this->a_type;
      return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(propStorage);
    }
    void setAType(const ::mlir::NVVM::DotAccumulateTypeAttr &propValue) {
      this->a_type = propValue;
    }
    using b_typeTy = ::mlir::NVVM::DotAccumulateTypeAttr;
    b_typeTy b_type;

    auto getBType() const {
      auto &propStorage = this->b_type;
      return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(propStorage);
    }
    void setBType(const ::mlir::NVVM::DotAccumulateTypeAttr &propValue) {
      this->b_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.a_type == this->a_type &&
        rhs.b_type == this->b_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DotAccumulate4WayOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.dot.accumulate.4way", odsAttrs.getContext());
  }

  DotAccumulate4WayOpGenericAdaptorBase(DotAccumulate4WayOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::NVVM::DotAccumulateTypeAttr getATypeAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().a_type);
    return attr;
  }

  ::mlir::NVVM::DotAccumulateType getAType();
  ::mlir::NVVM::DotAccumulateTypeAttr getBTypeAttr() {
    auto attr = ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().b_type);
    return attr;
  }

  ::mlir::NVVM::DotAccumulateType getBType();
};

} // namespace detail
template <typename RangeT>
class DotAccumulate4WayOpGenericAdaptor : public detail::DotAccumulate4WayOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DotAccumulate4WayOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
public:
  DotAccumulate4WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DotAccumulate4WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DotAccumulate4WayOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DotAccumulate4WayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DotAccumulate4WayOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DotAccumulate4WayOpGenericAdaptor(RangeT values, const DotAccumulate4WayOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DotAccumulate4WayOp, typename = std::enable_if_t<std::is_same_v<LateInst, DotAccumulate4WayOp>>>
  DotAccumulate4WayOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DotAccumulate4WayOpAdaptor : public DotAccumulate4WayOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DotAccumulate4WayOpGenericAdaptor::DotAccumulate4WayOpGenericAdaptor;
  DotAccumulate4WayOpAdaptor(DotAccumulate4WayOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DotAccumulate4WayOp : public ::mlir::Op<DotAccumulate4WayOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DotAccumulate4WayOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DotAccumulate4WayOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("a_type"), ::llvm::StringRef("b_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getATypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getATypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.dot.accumulate.4way");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::NVVM::DotAccumulateTypeAttr getATypeAttr() {
    return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().a_type);
  }

  ::mlir::NVVM::DotAccumulateType getAType();
  ::mlir::NVVM::DotAccumulateTypeAttr getBTypeAttr() {
    return ::llvm::cast<::mlir::NVVM::DotAccumulateTypeAttr>(getProperties().b_type);
  }

  ::mlir::NVVM::DotAccumulateType getBType();
  void setATypeAttr(::mlir::NVVM::DotAccumulateTypeAttr attr) {
    getProperties().a_type = attr;
  }

  void setAType(::mlir::NVVM::DotAccumulateType attrValue);
  void setBTypeAttr(::mlir::NVVM::DotAccumulateTypeAttr attr) {
    getProperties().b_type = attr;
  }

  void setBType(::mlir::NVVM::DotAccumulateType attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateTypeAttr a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateTypeAttr b_type, ::mlir::Value c);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::NVVM::DotAccumulateType a_type, ::mlir::Value b, ::mlir::NVVM::DotAccumulateType b_type, ::mlir::Value c);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotAccumulate4WayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotAccumulate4WayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::NVVM::IDArgPair
  getIntrinsicIDAndArgs(Operation &op, LLVM::ModuleTranslation &mt,
                        llvm::IRBuilderBase &builder);
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::DotAccumulate4WayOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::DynamicSmemSize declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DynamicSmemSizeGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicSmemSizeGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.dynamic.smem.size", odsAttrs.getContext());
  }

  DynamicSmemSizeGenericAdaptorBase(DynamicSmemSize op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class DynamicSmemSizeGenericAdaptor : public detail::DynamicSmemSizeGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicSmemSizeGenericAdaptorBase;
public:
  DynamicSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicSmemSizeGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicSmemSizeGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicSmemSizeGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicSmemSizeGenericAdaptor(RangeT values, const DynamicSmemSizeGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicSmemSize, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicSmemSize>>>
  DynamicSmemSizeGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicSmemSizeAdaptor : public DynamicSmemSizeGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicSmemSizeGenericAdaptor::DynamicSmemSizeGenericAdaptor;
  DynamicSmemSizeAdaptor(DynamicSmemSize op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicSmemSize : public ::mlir::Op<DynamicSmemSize, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicSmemSizeAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicSmemSizeGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.dynamic.smem.size");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static DynamicSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static DynamicSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static DynamicSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static DynamicSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSmemSize create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSmemSize create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::DynamicSmemSize)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::ElectSyncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ElectSyncOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ElectSyncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.elect.sync", odsAttrs.getContext());
  }

  ElectSyncOpGenericAdaptorBase(ElectSyncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ElectSyncOpGenericAdaptor : public detail::ElectSyncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ElectSyncOpGenericAdaptorBase;
  static constexpr int odsIndex_membermask = 0;
public:
  ElectSyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ElectSyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ElectSyncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ElectSyncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ElectSyncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ElectSyncOpGenericAdaptor(RangeT values, const ElectSyncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ElectSyncOp, typename = std::enable_if_t<std::is_same_v<LateInst, ElectSyncOp>>>
  ElectSyncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMembermask() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ElectSyncOpAdaptor : public ElectSyncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ElectSyncOpGenericAdaptor::ElectSyncOpGenericAdaptor;
  ElectSyncOpAdaptor(ElectSyncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ElectSyncOp : public ::mlir::Op<ElectSyncOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ElectSyncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ElectSyncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_membermask = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.elect.sync");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getMembermask() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getMembermaskMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type pred, /*optional*/::mlir::Value membermask);
  static ElectSyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type pred, /*optional*/::mlir::Value membermask);
  static ElectSyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type pred, /*optional*/::mlir::Value membermask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value membermask);
  static ElectSyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value membermask);
  static ElectSyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value membermask);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ElectSyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ElectSyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ElectSyncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ElectSyncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::ElectSyncOp)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg0Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg0OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg0OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg0", odsAttrs.getContext());
  }

  EnvReg0OpGenericAdaptorBase(EnvReg0Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg0OpGenericAdaptor : public detail::EnvReg0OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg0OpGenericAdaptorBase;
public:
  EnvReg0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg0OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg0OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg0OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg0OpGenericAdaptor(RangeT values, const EnvReg0OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg0Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg0Op>>>
  EnvReg0OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg0OpAdaptor : public EnvReg0OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg0OpGenericAdaptor::EnvReg0OpGenericAdaptor;
  EnvReg0OpAdaptor(EnvReg0Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg0Op : public ::mlir::Op<EnvReg0Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg0OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg0OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg0");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg0Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg0Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg0Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg10Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg10OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg10OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg10", odsAttrs.getContext());
  }

  EnvReg10OpGenericAdaptorBase(EnvReg10Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg10OpGenericAdaptor : public detail::EnvReg10OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg10OpGenericAdaptorBase;
public:
  EnvReg10OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg10OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg10OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg10OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg10OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg10OpGenericAdaptor(RangeT values, const EnvReg10OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg10Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg10Op>>>
  EnvReg10OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg10OpAdaptor : public EnvReg10OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg10OpGenericAdaptor::EnvReg10OpGenericAdaptor;
  EnvReg10OpAdaptor(EnvReg10Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg10Op : public ::mlir::Op<EnvReg10Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg10OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg10OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg10");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg10Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg10Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg10Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg10Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg10Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg10Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg10Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg10Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg10Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg11Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg11OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg11OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg11", odsAttrs.getContext());
  }

  EnvReg11OpGenericAdaptorBase(EnvReg11Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg11OpGenericAdaptor : public detail::EnvReg11OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg11OpGenericAdaptorBase;
public:
  EnvReg11OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg11OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg11OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg11OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg11OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg11OpGenericAdaptor(RangeT values, const EnvReg11OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg11Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg11Op>>>
  EnvReg11OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg11OpAdaptor : public EnvReg11OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg11OpGenericAdaptor::EnvReg11OpGenericAdaptor;
  EnvReg11OpAdaptor(EnvReg11Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg11Op : public ::mlir::Op<EnvReg11Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg11OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg11OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg11");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg11Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg11Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg11Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg11Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg11Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg11Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg11Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg11Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg11Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg12Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg12OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg12OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg12", odsAttrs.getContext());
  }

  EnvReg12OpGenericAdaptorBase(EnvReg12Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg12OpGenericAdaptor : public detail::EnvReg12OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg12OpGenericAdaptorBase;
public:
  EnvReg12OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg12OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg12OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg12OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg12OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg12OpGenericAdaptor(RangeT values, const EnvReg12OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg12Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg12Op>>>
  EnvReg12OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg12OpAdaptor : public EnvReg12OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg12OpGenericAdaptor::EnvReg12OpGenericAdaptor;
  EnvReg12OpAdaptor(EnvReg12Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg12Op : public ::mlir::Op<EnvReg12Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg12OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg12OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg12");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg12Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg12Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg12Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg12Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg12Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg12Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg12Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg12Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg12Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg13Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg13OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg13OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg13", odsAttrs.getContext());
  }

  EnvReg13OpGenericAdaptorBase(EnvReg13Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg13OpGenericAdaptor : public detail::EnvReg13OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg13OpGenericAdaptorBase;
public:
  EnvReg13OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg13OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg13OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg13OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg13OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg13OpGenericAdaptor(RangeT values, const EnvReg13OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg13Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg13Op>>>
  EnvReg13OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg13OpAdaptor : public EnvReg13OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg13OpGenericAdaptor::EnvReg13OpGenericAdaptor;
  EnvReg13OpAdaptor(EnvReg13Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg13Op : public ::mlir::Op<EnvReg13Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg13OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg13OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg13");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg13Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg13Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg13Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg13Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg13Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg13Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg13Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg13Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg13Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg14Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg14OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg14OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg14", odsAttrs.getContext());
  }

  EnvReg14OpGenericAdaptorBase(EnvReg14Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg14OpGenericAdaptor : public detail::EnvReg14OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg14OpGenericAdaptorBase;
public:
  EnvReg14OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg14OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg14OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg14OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg14OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg14OpGenericAdaptor(RangeT values, const EnvReg14OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg14Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg14Op>>>
  EnvReg14OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg14OpAdaptor : public EnvReg14OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg14OpGenericAdaptor::EnvReg14OpGenericAdaptor;
  EnvReg14OpAdaptor(EnvReg14Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg14Op : public ::mlir::Op<EnvReg14Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg14OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg14OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg14");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg14Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg14Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg14Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg14Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg14Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg14Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg14Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg14Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg14Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg15Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg15OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg15OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg15", odsAttrs.getContext());
  }

  EnvReg15OpGenericAdaptorBase(EnvReg15Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg15OpGenericAdaptor : public detail::EnvReg15OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg15OpGenericAdaptorBase;
public:
  EnvReg15OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg15OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg15OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg15OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg15OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg15OpGenericAdaptor(RangeT values, const EnvReg15OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg15Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg15Op>>>
  EnvReg15OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg15OpAdaptor : public EnvReg15OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg15OpGenericAdaptor::EnvReg15OpGenericAdaptor;
  EnvReg15OpAdaptor(EnvReg15Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg15Op : public ::mlir::Op<EnvReg15Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg15OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg15OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg15");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg15Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg15Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg15Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg15Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg15Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg15Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg15Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg15Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg15Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg16", odsAttrs.getContext());
  }

  EnvReg16OpGenericAdaptorBase(EnvReg16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg16OpGenericAdaptor : public detail::EnvReg16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg16OpGenericAdaptorBase;
public:
  EnvReg16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg16OpGenericAdaptor(RangeT values, const EnvReg16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg16Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg16Op>>>
  EnvReg16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg16OpAdaptor : public EnvReg16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg16OpGenericAdaptor::EnvReg16OpGenericAdaptor;
  EnvReg16OpAdaptor(EnvReg16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg16Op : public ::mlir::Op<EnvReg16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnvReg16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::NVVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::NVVM::EnvReg16Op)

namespace mlir::NVVM {


//===----------------------------------------------------------------------===//
// ::mlir::NVVM::EnvReg17Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EnvReg17OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnvReg17OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("nvvm.read.ptx.sreg.envreg17", odsAttrs.getContext());
  }

  EnvReg17OpGenericAdaptorBase(EnvReg17Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EnvReg17OpGenericAdaptor : public detail::EnvReg17OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnvReg17OpGenericAdaptorBase;
public:
  EnvReg17OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnvReg17OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnvReg17OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnvReg17OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EnvReg17OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnvReg17OpGenericAdaptor(RangeT values, const EnvReg17OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnvReg17Op, typename = std::enable_if_t<std::is_same_v<LateInst, EnvReg17Op>>>
  EnvReg17OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnvReg17OpAdaptor : public EnvReg17OpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnvReg17OpGenericAdaptor::EnvReg17OpGenericAdaptor;
  EnvReg17OpAdaptor(EnvReg17Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnvReg17Op : public ::mlir::Op<EnvReg17Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnvReg17OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnvReg17OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("nvvm.read.ptx.sreg.envreg17");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static EnvReg17Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static EnvReg17Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static EnvReg17Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static EnvReg17Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnvReg17Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRang