/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AttrDef Declarations                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_ATTRDEF_CLASSES
#undef GET_ATTRDEF_CLASSES


namespace mlir {
class AsmParser;
class AsmPrinter;
} // namespace mlir
namespace mlir::LLVM {

/// LLVM address space
/// The `address_space` attribute represents an LLVM address space. It takes an
///     unsigned integer parameter that specifies the address space number.
/// 
///     Different address spaces in LLVM can have different properties:
///     - Address space 0 is the default/generic address space
///     - Other address spaces may have specific semantics (e.g., shared memory,
///       constant memory, etc.) depending on the target architecture
/// 
///     Example:
/// 
///     ```mlir
///     // Address space 0 (default)
///     #llvm.address_space<0>
/// 
///     // Address space 1 (e.g., global memory on some targets)
///     #llvm.address_space<1>
/// 
///     // Address space 3 (e.g., shared memory on some GPU targets)
///     #llvm.address_space<3>
///     ```
class AddressSpaceAttr;
class CConvAttr;
class ComdatAttr;
class LinkageAttr;
class FramePointerKindAttr;
/// This attribute defines vectorization specific loop annotations that map to
///     the "!llvm.loop.vectorize" metadata.
class LoopVectorizeAttr;
/// This attribute defines interleaving specific loop annotations that map to
///     the "!llvm.loop.interleave" metadata.
class LoopInterleaveAttr;
/// This attribute defines unrolling specific loop annotations that map to
///     the "!llvm.loop.unroll" metadata.
class LoopUnrollAttr;
/// This attribute defines "unroll and jam" specific loop annotations that map to
///     the "!llvm.loop.unroll_and_jam" metadata.
class LoopUnrollAndJamAttr;
/// This attribute encapsulates loop invariant code motion (licm) specific loop
///     annotations. The fields correspond to the "!llvm.licm.disable" and the
///     "!llvm.loop.licm_versioning.disable" metadata.
class LoopLICMAttr;
/// This attribute defines distribution specific loop annotations that map to
///     the "!llvm.loop.distribute" metadata.
class LoopDistributeAttr;
/// This attribute defines pipelining specific loop annotations that map to
///     the "!llvm.loop.pipeline" metadata.
class LoopPipelineAttr;
/// This attribute defines pipelining specific loop annotations that map to
///     the "!llvm.loop.peeled" metadata.
class LoopPeeledAttr;
/// This attribute defines pipelining specific loop annotations that map to
///     the "!llvm.loop.unswitch" metadata.
class LoopUnswitchAttr;
/// This attributes encapsulates "loop metadata". It is meant to decorate
///     branches that are "latches" (loop backedges) and maps to the `!llvm.loop`
///     metadatas: https://llvm.org/docs/LangRef.html#llvm-loop
///     It stores annotations in attribute parameters and groups related options in
///     nested attributes to provide structured access.
class LoopAnnotationAttr;
class DIExpressionElemAttr;
class DIExpressionAttr;
class DINullTypeAttr;
class DIBasicTypeAttr;
class DICompileUnitAttr;
class DICompositeTypeAttr;
class DIDerivedTypeAttr;
class DIFileAttr;
class DIGlobalVariableExpressionAttr;
class DIGlobalVariableAttr;
class DILexicalBlockAttr;
class DILexicalBlockFileAttr;
class DILocalVariableAttr;
class DISubprogramAttr;
class DIModuleAttr;
class DINamespaceAttr;
class DIImportedEntityAttr;
class DIAnnotationAttr;
class DISubrangeAttr;
class DICommonBlockAttr;
class DIGenericSubrangeAttr;
class DISubroutineTypeAttr;
class DILabelAttr;
class DIStringTypeAttr;
class MemoryEffectsAttr;
/// LLVM dialect alias scope domain metadata
/// Defines a domain that may be associated with an alias scope.
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#noalias-and-alias-scope-metadata
class AliasScopeDomainAttr;
/// LLVM dialect alias scope
/// Defines an alias scope that can be attached to a memory-accessing operation.
///     Such scopes can be used in combination with `noalias` metadata to indicate
///     that sets of memory-affecting operations in one scope do not alias with
///     memory-affecting operations in another scope.
/// 
///     Example:
///     ```mlir
///     #domain = #llvm.alias_scope_domain<id = distinct[1]<>, description = "Optional domain description">
///     #scope1 = #llvm.alias_scope<id = distinct[2]<>, domain = #domain>
///     #scope2 = #llvm.alias_scope<id = distinct[3]<>, domain = #domain, description = "Optional scope description">
///     llvm.func @foo(%ptr1 : !llvm.ptr) {
///         %c0 = llvm.mlir.constant(0 : i32) : i32
///         %c4 = llvm.mlir.constant(4 : i32) : i32
///         %1 = llvm.ptrtoint %ptr1 : !llvm.ptr to i32
///         %2 = llvm.add %1, %c1 : i32
///         %ptr2 = llvm.inttoptr %2 : i32 to !llvm.ptr
///         llvm.store %c0, %ptr1 { alias_scopes = [#scope1], llvm.noalias = [#scope2] } : i32, !llvm.ptr
///         llvm.store %c4, %ptr2 { alias_scopes = [#scope2], llvm.noalias = [#scope1] } : i32, !llvm.ptr
///         llvm.return
///     }
///     ```
/// 
///     The first attribute can either be a DistinctAttr or a StringAttr.
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#noalias-and-alias-scope-metadata
class AliasScopeAttr;
/// LLVM dialect access group metadata
/// Defines an access group metadata that can be set on any instruction
///     that potentially accesses memory via the `AccessGroupOpInterface` or on
///     branch instructions in the loop latch block via the `parallelAccesses`
///     parameter of `LoopAnnotationAttr`.
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#llvm-access-group-metadata
class AccessGroupAttr;
/// LLVM dialect TBAA root metadata
/// Defines a TBAA root node.
/// 
///     Example:
///     ```mlir
///     #cpp_root = #llvm.tbaa_root<identity = "Simple C/C++ TBAA">
///     #other_root = #llvm.tbaa_root
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#tbaa-metadata
class TBAARootAttr;
class TBAAMemberAttr;
/// LLVM dialect TBAA type metadata
/// Defines a TBAA node describing a type.
/// 
///     Example:
///     ```mlir
///     #tbaa_root = #llvm.tbaa_root<identity = "Simple C/C++ TBAA">
///     #tbaa_type_desc1 = #llvm.tbaa_type_desc<id = "omnipotent char", members = {<#tbaa_root, 0>}>
///     #tbaa_type_desc2 = #llvm.tbaa_type_desc<id = "long long", members = {<#tbaa_root, 0>}>
///     #tbaa_type_desc3 = #llvm.tbaa_type_desc<id = "agg2_t", members = {<#tbaa_type_desc2, 0>, <#tbaa_type_desc2, 8>}>
///     #tbaa_type_desc4 = #llvm.tbaa_type_desc<id = "int", members = {<#tbaa_type_desc1, 0>}>
///     #tbaa_type_desc5 = #llvm.tbaa_type_desc<id = "agg1_t", members = {<#tbaa_type_desc4, 0>, <#tbaa_type_desc4, 4>}>
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#tbaa-metadata
class TBAATypeDescriptorAttr;
/// LLVM dialect TBAA tag metadata
/// Defines a TBAA node describing a memory access.
/// 
///     Example:
///     ```mlir
///     #tbaa_root = #llvm.tbaa_root<identity = "Simple C/C++ TBAA">
///     #tbaa_type_desc1 = #llvm.tbaa_type_desc<id = "omnipotent char", members = {<#tbaa_root, 0>}>
///     #tbaa_type_desc2 = #llvm.tbaa_type_desc<id = "int", members = {<#tbaa_type_desc1, 0>}>
///     #tbaa_type_desc3 = #llvm.tbaa_type_desc<id = "agg1_t", members = {<#tbaa_type_desc4, 0>, <#tbaa_type_desc4, 4>}>
///     #tbaa_tag = #llvm.tbaa_tag<base_type = #tbaa_type_desc3, access_type = #tbaa_type_desc2, offset = 0, constant = true>
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#tbaa-metadata
class TBAATagAttr;
/// MLIR wrapper around a prefix:suffix MMRA tag
/// Defines a single memory model relaxation annotation (MMRA) entry
///     with prefix `$prefix` and suffix `$suffix`. This corresponds directly
///     to a LLVM `!{prefix, suffix}` metadata tuple, which is often written
///     `prefix:shuffix` as shorthand.
/// 
///     Example:
///     ```mlir
///     #mmra_tag = #llvm.mmmra_tag<"amdgpu-synchronize-as":"local">
///     #mmra_tag1 = #llvm.mmra_tag<"foo":"bar">
///     ```
/// 
///     Either one MMRA tag or an array of them may be added to any LLVM
///     operation that operates on memory.
/// 
///     ```mlir
///     %v = llvm.load %ptr {llvm.mmra = #mmra_tag} : !llvm.ptr -> i8
///     llvm.store %v, %ptr2 {llvm.mmra [#mmra_tag, #mmra_tag1]} : i8, !llvm.ptr
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/MemoryModelRelaxationAnnotations.html
class MMRATagAttr;
/// A range of two integers, corresponding to LLVM's ConstantRange
/// A pair of two integers, mapping to the ConstantRange structure in LLVM IR,
///     which is allowed to wrap or be empty.
/// 
///     The range represented is [Lower, Upper), and is either signed or unsigned
///     depending on context.
/// 
///     `lower` and `upper` must have the same width.
/// 
///     Syntax:
///     ```
///     `<` `i`(width($lower)) $lower `,` $upper `>`
///     ```
class ConstantRangeAttr;
class VScaleRangeAttr;
/// LLVM target features attribute
/// Represents the LLVM target features as a list that can be checked within
///     passes/rewrites.
/// 
///     Example:
///     ```mlir
///     #llvm.target_features<["+sme", "+sve", "+sme-f64f64"]>
///     ```
/// 
///     Then within a pass or rewrite the features active at an op can be queried:
/// 
///     ```c++
///     auto targetFeatures = LLVM::TargetFeaturesAttr::featuresAt(op);
/// 
///     if (!targetFeatures.contains("+sme-f64f64"))
///       return failure();
///     ```
class TargetFeaturesAttr;
/// LLVM target info: triple, chip, features
/// An attribute to hold LLVM target information, specifying LLVM's target
///     `triple` string, the target `chip` string (i.e. the `cpu` string), and
///     target `features` string as an attribute. The latter is optional.
/// 
///     Responds to DLTI-queries on the keys:
///       * A query for `"triple"` returns the `StringAttr` for the `triple`.
///       * A query for `"chip"` returns the `StringAttr` for the `chip`/`cpu`.
///       * A query for `"features"` returns the `StringAttr`, if provided.
class TargetAttr;
class UndefAttr;
class PoisonAttr;
class DSOLocalEquivalentAttr;
class BlockTagAttr;
/// Describes a block address identified by a pair of `$function` and `$tag`.
class BlockAddressAttr;
/// Explicit vectorization compiler hint
/// A hint to the compiler that indicates most operations used in the function
///     are explictly vectorized using a particular vector type. `$hint` is the
///     vector or scalar type in particular. `$is_signed` can be used with integer
///     types to state whether the type is signed.
class VecTypeHintAttr;
class ZeroAttr;
class TailCallKindAttr;
/// GPU workgroup attribution information
/// GPU workgroup attributions are `gpu.func` attributes encoding memory
///     allocations in the workgroup address space. These might be encoded as
///     `llvm.ptr` function arguments in our dialect, but then type and size
///     information would be dropped. This attribute can be attached to `llvm.ptr`
///     function arguments encoding GPU workgroup attributions to mark them as
///     arguments encoding workgroup attributions and keeping type and size
///     information in our dialect.
class WorkgroupAttributionAttr;
/// LLVM dereferenceable attribute
/// Defines `dereferenceable` or `dereferenceable_or_null` metadata that can
///     be set via the `DereferenceableOpInterface` on an `inttoptr` operation or
///     on a `load` operation which loads a pointer. The attribute is used to
///     denote that the result of these operations is dereferenceable up to a
///     certain number of bytes, represented by `$bytes`. The optional `$mayBeNull`
///     parameter is set to true if the attribute defines `dereferenceable_or_null`
///     metadata.
/// 
///     See the following links for more details:
///     https://llvm.org/docs/LangRef.html#dereferenceable-metadata
///     https://llvm.org/docs/LangRef.html#dereferenceable-or-null-metadata
class DereferenceableAttr;
/// LLVM module flag metadata
/// Represents a single entry of llvm.module.flags metadata
///     (llvm::Module::ModuleFlagEntry in LLVM). The first element is a behavior
///     flag described by `ModFlagBehaviorAttr`, the second is a string ID
///     and third is the value of the flag. Supported keys and values include:
///       - Arbitrary `key`s holding integer constants or strings.
///       - Domain specific keys (e.g "CG Profile"), holding lists of supported
///         module flag values (e.g. `llvm.cgprofile_entry`).
/// 
///     Example:
///     ```mlir
///       llvm.module_flags [
///           #llvm.mlir.module_flag<error, "wchar_size", 4>,
///           #llvm.mlir.module_flag<error, "probe-stack", "inline-asm">,
///           #llvm.mlir.module_flag<append, "CG Profile", [
///             #llvm.cgprofile_entry<from = @from, to = @to, count = 222>,
///             #llvm.cgprofile_entry<from = @from, to = @from, count = 222>,
///             #llvm.cgprofile_entry<from = @to, to = @from, count = 222>
///           ]
///       >]
///     ```
class ModuleFlagAttr;
/// CG profile module flag entry
/// Describes a single entry for a CG profile module flag. Example:
///     ```mlir
///       llvm.module_flags [
///         #llvm.mlir.module_flag<append, "CG Profile",
///           [#llvm.cgprofile_entry<from = @from, to = @to, count = 222>,
///            ...
///           ]>]
///     ```
class ModuleFlagCGProfileEntryAttr;
/// ProfileSummary detailed information
/// Contains detailed information pertinent to "ProfileSummary" attribute.
///     A `#llvm.profile_summary` may contain several of it.
///     ```mlir
///     llvm.module_flags [ ...
///         detailed_summary =
///         <cut_off = 10000, min_count = 86427, num_counts = 1>,
///         <cut_off = 100000, min_count = 86427, num_counts = 1>
///     ```
class ModuleFlagProfileSummaryDetailedAttr;
/// ProfileSummary module flag
/// Describes ProfileSummary gathered data in a module. Example:
///     ```mlir
///     llvm.module_flags [#llvm.mlir.module_flag<error, "ProfileSummary",
///       #llvm.profile_summary<format = InstrProf, total_count = 263646, max_count = 86427,
///         max_internal_count = 86427, max_function_count = 4691,
///         num_counts = 3712, num_functions = 796,
///         is_partial_profile = 0,
///         partial_profile_ratio = 0.000000e+00 : f64,
///         detailed_summary =
///           <cut_off = 10000, min_count = 86427, num_counts = 1>,
///           <cut_off = 100000, min_count = 86427, num_counts = 1>
///     >>]
///     ```
class ModuleFlagProfileSummaryAttr;
/// LLVM dependent libraries attribute
/// Represents the list of dependent libraries for the current module.
///     This attribute is used to specify the libraries that the module depends
///     on, and it can be used for linking purposes.
/// 
///     See the following links for more details:
///     https://llvm.org/docs/LangRef.html#dependent-libs-named-metadata
class DependentLibrariesAttr;
class UWTableKindAttr;
/// LLVM integer overflow flags
/// Enum cases:
/// * none (`none`)
/// * nsw (`nsw`)
/// * nuw (`nuw`)
class IntegerOverflowFlagsAttr;
/// LLVM fastmath flags
class FastmathFlagsAttr;
namespace detail {

struct AddressSpaceAttrStorage;

} // namespace detail
class AddressSpaceAttr : public ::mlir::Attribute::AttrBase<AddressSpaceAttr, ::mlir::Attribute, detail::AddressSpaceAttrStorage, ::mlir::LLVM::LLVMAddrSpaceAttrInterface::Trait, ::mlir::ptr::MemorySpaceAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.address_space";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static AddressSpaceAttr get(::mlir::MLIRContext *context, unsigned addressSpace);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"address_space"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getAddressSpace() const;
  bool isValidLoad(::mlir::Type type, ::mlir::ptr::AtomicOrdering ordering, std::optional<int64_t> alignment, const ::mlir::DataLayout *dataLayout, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
  bool isValidStore(::mlir::Type type, ::mlir::ptr::AtomicOrdering ordering, std::optional<int64_t> alignment, const ::mlir::DataLayout *dataLayout, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
  bool isValidAtomicOp(::mlir::ptr::AtomicBinOp op, ::mlir::Type type, ::mlir::ptr::AtomicOrdering ordering, std::optional<int64_t> alignment, const ::mlir::DataLayout *dataLayout, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
  bool isValidAtomicXchg(::mlir::Type type, ::mlir::ptr::AtomicOrdering successOrdering, ::mlir::ptr::AtomicOrdering failureOrdering, std::optional<int64_t> alignment, const ::mlir::DataLayout *dataLayout, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
  bool isValidAddrSpaceCast(::mlir::Type tgt, ::mlir::Type src, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
  bool isValidPtrIntCast(::mlir::Type intLikeTy, ::mlir::Type ptrLikeTy, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) const;
};
namespace detail {

struct CConvAttrStorage;

} // namespace detail
class CConvAttr : public ::mlir::Attribute::AttrBase<CConvAttr, ::mlir::Attribute, detail::CConvAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.cconv";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static CConvAttr get(::mlir::MLIRContext *context, CConv CallingConv);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"cconv"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  CConv getCallingConv() const;
};
namespace detail {

struct ComdatAttrStorage;

} // namespace detail
class ComdatAttr : public ::mlir::Attribute::AttrBase<ComdatAttr, ::mlir::Attribute, detail::ComdatAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.comdat";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static ComdatAttr get(::mlir::MLIRContext *context, comdat::Comdat comdat);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"comdat"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  comdat::Comdat getComdat() const;
};
namespace detail {

struct LinkageAttrStorage;

} // namespace detail
class LinkageAttr : public ::mlir::Attribute::AttrBase<LinkageAttr, ::mlir::Attribute, detail::LinkageAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.linkage";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LinkageAttr get(::mlir::MLIRContext *context, linkage::Linkage linkage);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"linkage"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  linkage::Linkage getLinkage() const;
};
namespace detail {

struct FramePointerKindAttrStorage;

} // namespace detail
class FramePointerKindAttr : public ::mlir::Attribute::AttrBase<FramePointerKindAttr, ::mlir::Attribute, detail::FramePointerKindAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.framePointerKind";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static FramePointerKindAttr get(::mlir::MLIRContext *context, framePointerKind::FramePointerKind framePointerKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"framePointerKind"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  framePointerKind::FramePointerKind getFramePointerKind() const;
};
namespace detail {

struct LoopVectorizeAttrStorage;

} // namespace detail
class LoopVectorizeAttr : public ::mlir::Attribute::AttrBase<LoopVectorizeAttr, ::mlir::Attribute, detail::LoopVectorizeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_vectorize";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopVectorizeAttr get(::mlir::MLIRContext *context, BoolAttr disable, BoolAttr predicateEnable, BoolAttr scalableEnable, IntegerAttr width, LoopAnnotationAttr followupVectorized, LoopAnnotationAttr followupEpilogue, LoopAnnotationAttr followupAll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_vectorize"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  BoolAttr getPredicateEnable() const;
  BoolAttr getScalableEnable() const;
  IntegerAttr getWidth() const;
  LoopAnnotationAttr getFollowupVectorized() const;
  LoopAnnotationAttr getFollowupEpilogue() const;
  LoopAnnotationAttr getFollowupAll() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopInterleaveAttrStorage;

} // namespace detail
class LoopInterleaveAttr : public ::mlir::Attribute::AttrBase<LoopInterleaveAttr, ::mlir::Attribute, detail::LoopInterleaveAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_interleave";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopInterleaveAttr get(::mlir::MLIRContext *context, IntegerAttr count);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_interleave"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  IntegerAttr getCount() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopUnrollAttrStorage;

} // namespace detail
class LoopUnrollAttr : public ::mlir::Attribute::AttrBase<LoopUnrollAttr, ::mlir::Attribute, detail::LoopUnrollAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_unroll";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopUnrollAttr get(::mlir::MLIRContext *context, BoolAttr disable, IntegerAttr count, BoolAttr runtimeDisable, BoolAttr full, LoopAnnotationAttr followupUnrolled, LoopAnnotationAttr followupRemainder, LoopAnnotationAttr followupAll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_unroll"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  IntegerAttr getCount() const;
  BoolAttr getRuntimeDisable() const;
  BoolAttr getFull() const;
  LoopAnnotationAttr getFollowupUnrolled() const;
  LoopAnnotationAttr getFollowupRemainder() const;
  LoopAnnotationAttr getFollowupAll() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopUnrollAndJamAttrStorage;

} // namespace detail
class LoopUnrollAndJamAttr : public ::mlir::Attribute::AttrBase<LoopUnrollAndJamAttr, ::mlir::Attribute, detail::LoopUnrollAndJamAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_unroll_and_jam";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopUnrollAndJamAttr get(::mlir::MLIRContext *context, BoolAttr disable, IntegerAttr count, LoopAnnotationAttr followupOuter, LoopAnnotationAttr followupInner, LoopAnnotationAttr followupRemainderOuter, LoopAnnotationAttr followupRemainderInner, LoopAnnotationAttr followupAll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_unroll_and_jam"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  IntegerAttr getCount() const;
  LoopAnnotationAttr getFollowupOuter() const;
  LoopAnnotationAttr getFollowupInner() const;
  LoopAnnotationAttr getFollowupRemainderOuter() const;
  LoopAnnotationAttr getFollowupRemainderInner() const;
  LoopAnnotationAttr getFollowupAll() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopLICMAttrStorage;

} // namespace detail
class LoopLICMAttr : public ::mlir::Attribute::AttrBase<LoopLICMAttr, ::mlir::Attribute, detail::LoopLICMAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_licm";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopLICMAttr get(::mlir::MLIRContext *context, BoolAttr disable, BoolAttr versioningDisable);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_licm"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  BoolAttr getVersioningDisable() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopDistributeAttrStorage;

} // namespace detail
class LoopDistributeAttr : public ::mlir::Attribute::AttrBase<LoopDistributeAttr, ::mlir::Attribute, detail::LoopDistributeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_distribute";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopDistributeAttr get(::mlir::MLIRContext *context, BoolAttr disable, LoopAnnotationAttr followupCoincident, LoopAnnotationAttr followupSequential, LoopAnnotationAttr followupFallback, LoopAnnotationAttr followupAll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_distribute"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  LoopAnnotationAttr getFollowupCoincident() const;
  LoopAnnotationAttr getFollowupSequential() const;
  LoopAnnotationAttr getFollowupFallback() const;
  LoopAnnotationAttr getFollowupAll() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopPipelineAttrStorage;

} // namespace detail
class LoopPipelineAttr : public ::mlir::Attribute::AttrBase<LoopPipelineAttr, ::mlir::Attribute, detail::LoopPipelineAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_pipeline";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopPipelineAttr get(::mlir::MLIRContext *context, BoolAttr disable, IntegerAttr initiationinterval);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_pipeline"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisable() const;
  IntegerAttr getInitiationinterval() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopPeeledAttrStorage;

} // namespace detail
class LoopPeeledAttr : public ::mlir::Attribute::AttrBase<LoopPeeledAttr, ::mlir::Attribute, detail::LoopPeeledAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_peeled";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopPeeledAttr get(::mlir::MLIRContext *context, IntegerAttr count);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_peeled"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  IntegerAttr getCount() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopUnswitchAttrStorage;

} // namespace detail
class LoopUnswitchAttr : public ::mlir::Attribute::AttrBase<LoopUnswitchAttr, ::mlir::Attribute, detail::LoopUnswitchAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_unswitch";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopUnswitchAttr get(::mlir::MLIRContext *context, BoolAttr partialDisable);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_unswitch"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getPartialDisable() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct LoopAnnotationAttrStorage;

} // namespace detail
class LoopAnnotationAttr : public ::mlir::Attribute::AttrBase<LoopAnnotationAttr, ::mlir::Attribute, detail::LoopAnnotationAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.loop_annotation";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static LoopAnnotationAttr get(::mlir::MLIRContext *context, BoolAttr disableNonforced, LoopVectorizeAttr vectorize, LoopInterleaveAttr interleave, LoopUnrollAttr unroll, LoopUnrollAndJamAttr unrollAndJam, LoopLICMAttr licm, LoopDistributeAttr distribute, LoopPipelineAttr pipeline, LoopPeeledAttr peeled, LoopUnswitchAttr unswitch, BoolAttr mustProgress, BoolAttr isVectorized, FusedLoc startLoc, FusedLoc endLoc, ::llvm::ArrayRef<AccessGroupAttr> parallelAccesses);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"loop_annotation"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  BoolAttr getDisableNonforced() const;
  LoopVectorizeAttr getVectorize() const;
  LoopInterleaveAttr getInterleave() const;
  LoopUnrollAttr getUnroll() const;
  LoopUnrollAndJamAttr getUnrollAndJam() const;
  LoopLICMAttr getLicm() const;
  LoopDistributeAttr getDistribute() const;
  LoopPipelineAttr getPipeline() const;
  LoopPeeledAttr getPeeled() const;
  LoopUnswitchAttr getUnswitch() const;
  BoolAttr getMustProgress() const;
  BoolAttr getIsVectorized() const;
  FusedLoc getStartLoc() const;
  FusedLoc getEndLoc() const;
  ::llvm::ArrayRef<AccessGroupAttr> getParallelAccesses() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIExpressionElemAttrStorage;

} // namespace detail
class DIExpressionElemAttr : public ::mlir::Attribute::AttrBase<DIExpressionElemAttr, ::mlir::Attribute, detail::DIExpressionElemAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_expression_elem";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIExpressionElemAttr get(::mlir::MLIRContext *context, unsigned opcode, ::llvm::ArrayRef<uint64_t> arguments);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_expression_elem"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getOpcode() const;
  ::llvm::ArrayRef<uint64_t> getArguments() const;
};
namespace detail {

struct DIExpressionAttrStorage;

} // namespace detail
class DIExpressionAttr : public ::mlir::Attribute::AttrBase<DIExpressionAttr, ::mlir::Attribute, detail::DIExpressionAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_expression";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIExpressionAttr get(::mlir::MLIRContext *context, ::llvm::ArrayRef<DIExpressionElemAttr> operations);
  static DIExpressionAttr get(::mlir::MLIRContext *context);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_expression"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<DIExpressionElemAttr> getOperations() const;
};
class DINullTypeAttr : public ::mlir::Attribute::AttrBase<DINullTypeAttr, DITypeAttr, ::mlir::AttributeStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_null_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_null_type"};
  }

  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIBasicTypeAttrStorage;

} // namespace detail
class DIBasicTypeAttr : public ::mlir::Attribute::AttrBase<DIBasicTypeAttr, DITypeAttr, detail::DIBasicTypeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_basic_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIBasicTypeAttr get(::mlir::MLIRContext *context, unsigned tag, StringAttr name, uint64_t sizeInBits, unsigned encoding);
  static DIBasicTypeAttr get(::mlir::MLIRContext *context, unsigned tag, const Twine &name, uint64_t sizeInBits, unsigned encoding);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_basic_type"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getTag() const;
  StringAttr getName() const;
  uint64_t getSizeInBits() const;
  unsigned getEncoding() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DICompileUnitAttrStorage;

} // namespace detail
class DICompileUnitAttr : public ::mlir::Attribute::AttrBase<DICompileUnitAttr, DIScopeAttr, detail::DICompileUnitAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_compile_unit";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DICompileUnitAttr get(::mlir::MLIRContext *context, DistinctAttr id, unsigned sourceLanguage, DIFileAttr file, StringAttr producer, bool isOptimized, DIEmissionKind emissionKind, DINameTableKind nameTableKind, StringAttr splitDebugFilename);
  static DICompileUnitAttr get(DistinctAttr id, unsigned sourceLanguage, DIFileAttr file, StringAttr producer, bool isOptimized, DIEmissionKind emissionKind, DINameTableKind nameTableKind = DINameTableKind::Default, StringAttr splitDebugFilename = {});
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_compile_unit"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DistinctAttr getId() const;
  unsigned getSourceLanguage() const;
  DIFileAttr getFile() const;
  StringAttr getProducer() const;
  bool getIsOptimized() const;
  DIEmissionKind getEmissionKind() const;
  DINameTableKind getNameTableKind() const;
  StringAttr getSplitDebugFilename() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DICompositeTypeAttrStorage;

} // namespace detail
class DICompositeTypeAttr : public ::mlir::Attribute::AttrBase<DICompositeTypeAttr, DITypeAttr, detail::DICompositeTypeAttrStorage, ::mlir::LLVM::DIRecursiveTypeAttrInterface::Trait, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  /// Requirements of DIRecursiveTypeAttrInterface.
  /// @{

  /// Get a copy of this type attr but with the recursive ID set to `recId`.
  DIRecursiveTypeAttrInterface withRecId(DistinctAttr recId);

  /// Build a rec-self instance using the provided `recId`.
  static DIRecursiveTypeAttrInterface getRecSelf(DistinctAttr recId);

  /// @}
  static constexpr ::llvm::StringLiteral name = "llvm.di_composite_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DICompositeTypeAttr get(::mlir::MLIRContext *context, DistinctAttr recId, bool isRecSelf, unsigned tag, StringAttr name, DIFileAttr file, uint32_t line, DIScopeAttr scope, DITypeAttr baseType, DIFlags flags, uint64_t sizeInBits, uint64_t alignInBits, DIExpressionAttr dataLocation, DIExpressionAttr rank, DIExpressionAttr allocated, DIExpressionAttr associated, ::llvm::ArrayRef<DINodeAttr> elements);
  static DICompositeTypeAttr get(::mlir::MLIRContext *context, unsigned tag, StringAttr name, DIFileAttr file, uint32_t line, DIScopeAttr scope, DITypeAttr baseType, DIFlags flags, uint64_t sizeInBits, uint64_t alignInBits, DIExpressionAttr dataLocation, DIExpressionAttr rank, DIExpressionAttr allocated, DIExpressionAttr associated, ArrayRef<DINodeAttr> elements);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_composite_type"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DistinctAttr getRecId() const;
  bool getIsRecSelf() const;
  unsigned getTag() const;
  StringAttr getName() const;
  DIFileAttr getFile() const;
  uint32_t getLine() const;
  DIScopeAttr getScope() const;
  DITypeAttr getBaseType() const;
  DIFlags getFlags() const;
  uint64_t getSizeInBits() const;
  uint64_t getAlignInBits() const;
  DIExpressionAttr getDataLocation() const;
  DIExpressionAttr getRank() const;
  DIExpressionAttr getAllocated() const;
  DIExpressionAttr getAssociated() const;
  ::llvm::ArrayRef<DINodeAttr> getElements() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIDerivedTypeAttrStorage;

} // namespace detail
class DIDerivedTypeAttr : public ::mlir::Attribute::AttrBase<DIDerivedTypeAttr, DITypeAttr, detail::DIDerivedTypeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_derived_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIDerivedTypeAttr get(::mlir::MLIRContext *context, unsigned tag, StringAttr name, DITypeAttr baseType, uint64_t sizeInBits, uint32_t alignInBits, uint64_t offsetInBits, std::optional<unsigned> dwarfAddressSpace, DINodeAttr extraData);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_derived_type"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getTag() const;
  StringAttr getName() const;
  DITypeAttr getBaseType() const;
  uint64_t getSizeInBits() const;
  uint32_t getAlignInBits() const;
  uint64_t getOffsetInBits() const;
  std::optional<unsigned> getDwarfAddressSpace() const;
  DINodeAttr getExtraData() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIFileAttrStorage;

} // namespace detail
class DIFileAttr : public ::mlir::Attribute::AttrBase<DIFileAttr, DIScopeAttr, detail::DIFileAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_file";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIFileAttr get(::mlir::MLIRContext *context, StringAttr name, StringAttr directory);
  static DIFileAttr get(::mlir::MLIRContext *context, StringRef name, StringRef directory);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_file"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  StringAttr getName() const;
  StringAttr getDirectory() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIGlobalVariableExpressionAttrStorage;

} // namespace detail
class DIGlobalVariableExpressionAttr : public ::mlir::Attribute::AttrBase<DIGlobalVariableExpressionAttr, ::mlir::Attribute, detail::DIGlobalVariableExpressionAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_global_variable_expression";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIGlobalVariableExpressionAttr get(::mlir::MLIRContext *context, DIGlobalVariableAttr var, DIExpressionAttr expr);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_global_variable_expression"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIGlobalVariableAttr getVar() const;
  DIExpressionAttr getExpr() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIGlobalVariableAttrStorage;

} // namespace detail
class DIGlobalVariableAttr : public ::mlir::Attribute::AttrBase<DIGlobalVariableAttr, DINodeAttr, detail::DIGlobalVariableAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_global_variable";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIGlobalVariableAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, StringAttr name, StringAttr linkageName, DIFileAttr file, unsigned line, DITypeAttr type, bool isLocalToUnit, bool isDefined, unsigned alignInBits);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_global_variable"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  StringAttr getName() const;
  StringAttr getLinkageName() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  DITypeAttr getType() const;
  bool getIsLocalToUnit() const;
  bool getIsDefined() const;
  unsigned getAlignInBits() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DILexicalBlockAttrStorage;

} // namespace detail
class DILexicalBlockAttr : public ::mlir::Attribute::AttrBase<DILexicalBlockAttr, DILocalScopeAttr, detail::DILexicalBlockAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_lexical_block";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DILexicalBlockAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, DIFileAttr file, unsigned line, unsigned column);
  static DILexicalBlockAttr get(DIScopeAttr scope, DIFileAttr file, unsigned line, unsigned column);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_lexical_block"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  unsigned getColumn() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DILexicalBlockFileAttrStorage;

} // namespace detail
class DILexicalBlockFileAttr : public ::mlir::Attribute::AttrBase<DILexicalBlockFileAttr, DILocalScopeAttr, detail::DILexicalBlockFileAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_lexical_block_file";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DILexicalBlockFileAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, DIFileAttr file, unsigned discriminator);
  static DILexicalBlockFileAttr get(DIScopeAttr scope, DIFileAttr file, unsigned discriminator);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_lexical_block_file"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  DIFileAttr getFile() const;
  unsigned getDiscriminator() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DILocalVariableAttrStorage;

} // namespace detail
class DILocalVariableAttr : public ::mlir::Attribute::AttrBase<DILocalVariableAttr, DINodeAttr, detail::DILocalVariableAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_local_variable";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DILocalVariableAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, StringAttr name, DIFileAttr file, unsigned line, unsigned arg, unsigned alignInBits, DITypeAttr type, DIFlags flags);
  static DILocalVariableAttr get(DIScopeAttr scope, StringRef name, DIFileAttr file, unsigned line, unsigned arg, unsigned alignInBits, DITypeAttr type, DIFlags flags);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_local_variable"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  StringAttr getName() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  unsigned getArg() const;
  unsigned getAlignInBits() const;
  DITypeAttr getType() const;
  DIFlags getFlags() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DISubprogramAttrStorage;

} // namespace detail
class DISubprogramAttr : public ::mlir::Attribute::AttrBase<DISubprogramAttr, DILocalScopeAttr, detail::DISubprogramAttrStorage, ::mlir::LLVM::DIRecursiveTypeAttrInterface::Trait, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  /// Requirements of DIRecursiveTypeAttrInterface.
  /// @{

  /// Get a copy of this type attr but with the recursive ID set to `recId`.
  DIRecursiveTypeAttrInterface withRecId(DistinctAttr recId);

  /// Build a rec-self instance using the provided `recId`.
  static DIRecursiveTypeAttrInterface getRecSelf(DistinctAttr recId);

  /// @}
  static constexpr ::llvm::StringLiteral name = "llvm.di_subprogram";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DISubprogramAttr get(::mlir::MLIRContext *context, DistinctAttr recId, bool isRecSelf, DistinctAttr id, DICompileUnitAttr compileUnit, DIScopeAttr scope, StringAttr name, StringAttr linkageName, DIFileAttr file, unsigned line, unsigned scopeLine, DISubprogramFlags subprogramFlags, DISubroutineTypeAttr type, ::llvm::ArrayRef<DINodeAttr> retainedNodes, ::llvm::ArrayRef<DINodeAttr> annotations);
  static DISubprogramAttr get(::mlir::MLIRContext *context, DistinctAttr id, DICompileUnitAttr compileUnit, DIScopeAttr scope, StringAttr name, StringAttr linkageName, DIFileAttr file, unsigned line, unsigned scopeLine, DISubprogramFlags subprogramFlags, DISubroutineTypeAttr type, ArrayRef<DINodeAttr> retainedNodes, ArrayRef<DINodeAttr> annotations);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_subprogram"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DistinctAttr getRecId() const;
  bool getIsRecSelf() const;
  DistinctAttr getId() const;
  DICompileUnitAttr getCompileUnit() const;
  DIScopeAttr getScope() const;
  StringAttr getName() const;
  StringAttr getLinkageName() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  unsigned getScopeLine() const;
  DISubprogramFlags getSubprogramFlags() const;
  DISubroutineTypeAttr getType() const;
  ::llvm::ArrayRef<DINodeAttr> getRetainedNodes() const;
  ::llvm::ArrayRef<DINodeAttr> getAnnotations() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIModuleAttrStorage;

} // namespace detail
class DIModuleAttr : public ::mlir::Attribute::AttrBase<DIModuleAttr, DIScopeAttr, detail::DIModuleAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_module";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIModuleAttr get(::mlir::MLIRContext *context, DIFileAttr file, DIScopeAttr scope, StringAttr name, StringAttr configMacros, StringAttr includePath, StringAttr apinotes, unsigned line, bool isDecl);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_module"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIFileAttr getFile() const;
  DIScopeAttr getScope() const;
  StringAttr getName() const;
  StringAttr getConfigMacros() const;
  StringAttr getIncludePath() const;
  StringAttr getApinotes() const;
  unsigned getLine() const;
  bool getIsDecl() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DINamespaceAttrStorage;

} // namespace detail
class DINamespaceAttr : public ::mlir::Attribute::AttrBase<DINamespaceAttr, DIScopeAttr, detail::DINamespaceAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_namespace";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DINamespaceAttr get(::mlir::MLIRContext *context, StringAttr name, DIScopeAttr scope, bool exportSymbols);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_namespace"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  StringAttr getName() const;
  DIScopeAttr getScope() const;
  bool getExportSymbols() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIImportedEntityAttrStorage;

} // namespace detail
class DIImportedEntityAttr : public ::mlir::Attribute::AttrBase<DIImportedEntityAttr, DINodeAttr, detail::DIImportedEntityAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_imported_entity";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIImportedEntityAttr get(::mlir::MLIRContext *context, unsigned tag, DIScopeAttr scope, DINodeAttr entity, DIFileAttr file, unsigned line, StringAttr name, ::llvm::ArrayRef<DINodeAttr> elements);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_imported_entity"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getTag() const;
  DIScopeAttr getScope() const;
  DINodeAttr getEntity() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  StringAttr getName() const;
  ::llvm::ArrayRef<DINodeAttr> getElements() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIAnnotationAttrStorage;

} // namespace detail
class DIAnnotationAttr : public ::mlir::Attribute::AttrBase<DIAnnotationAttr, DINodeAttr, detail::DIAnnotationAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_annotation";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIAnnotationAttr get(::mlir::MLIRContext *context, StringAttr name, StringAttr value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_annotation"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  StringAttr getName() const;
  StringAttr getValue() const;
};
namespace detail {

struct DISubrangeAttrStorage;

} // namespace detail
class DISubrangeAttr : public ::mlir::Attribute::AttrBase<DISubrangeAttr, DINodeAttr, detail::DISubrangeAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_subrange";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DISubrangeAttr get(::mlir::MLIRContext *context, ::mlir::Attribute count, ::mlir::Attribute lowerBound, ::mlir::Attribute upperBound, ::mlir::Attribute stride);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_subrange"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::Attribute getCount() const;
  ::mlir::Attribute getLowerBound() const;
  ::mlir::Attribute getUpperBound() const;
  ::mlir::Attribute getStride() const;
};
namespace detail {

struct DICommonBlockAttrStorage;

} // namespace detail
class DICommonBlockAttr : public ::mlir::Attribute::AttrBase<DICommonBlockAttr, DIScopeAttr, detail::DICommonBlockAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_common_block";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DICommonBlockAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, DIGlobalVariableAttr decl, StringAttr name, DIFileAttr file, unsigned line);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_common_block"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  DIGlobalVariableAttr getDecl() const;
  StringAttr getName() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIGenericSubrangeAttrStorage;

} // namespace detail
class DIGenericSubrangeAttr : public ::mlir::Attribute::AttrBase<DIGenericSubrangeAttr, DINodeAttr, detail::DIGenericSubrangeAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_generic_subrange";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIGenericSubrangeAttr get(::mlir::MLIRContext *context, ::mlir::Attribute count, ::mlir::Attribute lowerBound, ::mlir::Attribute upperBound, ::mlir::Attribute stride);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_generic_subrange"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::Attribute getCount() const;
  ::mlir::Attribute getLowerBound() const;
  ::mlir::Attribute getUpperBound() const;
  ::mlir::Attribute getStride() const;
};
namespace detail {

struct DISubroutineTypeAttrStorage;

} // namespace detail
class DISubroutineTypeAttr : public ::mlir::Attribute::AttrBase<DISubroutineTypeAttr, DITypeAttr, detail::DISubroutineTypeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_subroutine_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DISubroutineTypeAttr get(::mlir::MLIRContext *context, unsigned callingConvention, ::llvm::ArrayRef<DITypeAttr> types);
  static DISubroutineTypeAttr get(::mlir::MLIRContext *context, ArrayRef<DITypeAttr> types);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_subroutine_type"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getCallingConvention() const;
  ::llvm::ArrayRef<DITypeAttr> getTypes() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DILabelAttrStorage;

} // namespace detail
class DILabelAttr : public ::mlir::Attribute::AttrBase<DILabelAttr, DINodeAttr, detail::DILabelAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_label";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DILabelAttr get(::mlir::MLIRContext *context, DIScopeAttr scope, StringAttr name, DIFileAttr file, unsigned line);
  static DILabelAttr get(DIScopeAttr scope, StringRef name, DIFileAttr file, unsigned line);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_label"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DIScopeAttr getScope() const;
  StringAttr getName() const;
  DIFileAttr getFile() const;
  unsigned getLine() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct DIStringTypeAttrStorage;

} // namespace detail
class DIStringTypeAttr : public ::mlir::Attribute::AttrBase<DIStringTypeAttr, DITypeAttr, detail::DIStringTypeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.di_string_type";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DIStringTypeAttr get(::mlir::MLIRContext *context, unsigned tag, StringAttr name, uint64_t sizeInBits, uint32_t alignInBits, DIVariableAttr stringLength, DIExpressionAttr stringLengthExp, DIExpressionAttr stringLocationExp, unsigned encoding);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"di_string_type"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getTag() const;
  StringAttr getName() const;
  uint64_t getSizeInBits() const;
  uint32_t getAlignInBits() const;
  DIVariableAttr getStringLength() const;
  DIExpressionAttr getStringLengthExp() const;
  DIExpressionAttr getStringLocationExp() const;
  unsigned getEncoding() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct MemoryEffectsAttrStorage;

} // namespace detail
class MemoryEffectsAttr : public ::mlir::Attribute::AttrBase<MemoryEffectsAttr, ::mlir::Attribute, detail::MemoryEffectsAttrStorage> {
public:
  using Base::Base;
  bool isReadWrite();
  static constexpr ::llvm::StringLiteral name = "llvm.memory_effects";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static MemoryEffectsAttr get(::mlir::MLIRContext *context, ModRefInfo other, ModRefInfo argMem, ModRefInfo inaccessibleMem, ModRefInfo errnoMem, ModRefInfo targetMem0, ModRefInfo targetMem1);
  static MemoryEffectsAttr get(::mlir::MLIRContext *context, ArrayRef<ModRefInfo> memInfoArgs);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"memory_effects"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ModRefInfo getOther() const;
  ModRefInfo getArgMem() const;
  ModRefInfo getInaccessibleMem() const;
  ModRefInfo getErrnoMem() const;
  ModRefInfo getTargetMem0() const;
  ModRefInfo getTargetMem1() const;
};
namespace detail {

struct AliasScopeDomainAttrStorage;

} // namespace detail
class AliasScopeDomainAttr : public ::mlir::Attribute::AttrBase<AliasScopeDomainAttr, ::mlir::Attribute, detail::AliasScopeDomainAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.alias_scope_domain";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static AliasScopeDomainAttr get(::mlir::MLIRContext *context, Attribute id, StringAttr description);
  static AliasScopeDomainAttr get(::mlir::MLIRContext *context, StringAttr description = {});
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"alias_scope_domain"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  Attribute getId() const;
  StringAttr getDescription() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct AliasScopeAttrStorage;

} // namespace detail
class AliasScopeAttr : public ::mlir::Attribute::AttrBase<AliasScopeAttr, ::mlir::Attribute, detail::AliasScopeAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.alias_scope";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  using Base::getChecked;
  static AliasScopeAttr get(::mlir::MLIRContext *context, Attribute id, AliasScopeDomainAttr domain, StringAttr description);
  static AliasScopeAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, Attribute id, AliasScopeDomainAttr domain, StringAttr description);
  static AliasScopeAttr get(AliasScopeDomainAttr domain, StringAttr description = {});
  static AliasScopeAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, AliasScopeDomainAttr domain, StringAttr description = {});
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, Attribute id, AliasScopeDomainAttr domain, StringAttr description);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, Attribute id, AliasScopeDomainAttr domain, StringAttr description);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"alias_scope"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  Attribute getId() const;
  AliasScopeDomainAttr getDomain() const;
  StringAttr getDescription() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct AccessGroupAttrStorage;

} // namespace detail
class AccessGroupAttr : public ::mlir::Attribute::AttrBase<AccessGroupAttr, ::mlir::Attribute, detail::AccessGroupAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.access_group";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static AccessGroupAttr get(::mlir::MLIRContext *context, DistinctAttr id);
  static AccessGroupAttr get(::mlir::MLIRContext *context);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"access_group"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  DistinctAttr getId() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct TBAARootAttrStorage;

} // namespace detail
class TBAARootAttr : public ::mlir::Attribute::AttrBase<TBAARootAttr, TBAANodeAttr, detail::TBAARootAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.tbaa_root";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TBAARootAttr get(::mlir::MLIRContext *context, StringAttr id);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tbaa_root"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  StringAttr getId() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct TBAAMemberAttrStorage;

} // namespace detail
class TBAAMemberAttr : public ::mlir::Attribute::AttrBase<TBAAMemberAttr, ::mlir::Attribute, detail::TBAAMemberAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.tbaa_member";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TBAAMemberAttr get(::mlir::MLIRContext *context, TBAANodeAttr typeDesc, int64_t offset);
  static TBAAMemberAttr get(TBAANodeAttr typeDesc, int64_t offset);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tbaa_member"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  TBAANodeAttr getTypeDesc() const;
  int64_t getOffset() const;
};
namespace detail {

struct TBAATypeDescriptorAttrStorage;

} // namespace detail
class TBAATypeDescriptorAttr : public ::mlir::Attribute::AttrBase<TBAATypeDescriptorAttr, TBAANodeAttr, detail::TBAATypeDescriptorAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.tbaa_type_desc";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TBAATypeDescriptorAttr get(::mlir::MLIRContext *context, ::llvm::StringRef id, ::llvm::ArrayRef<TBAAMemberAttr> members);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tbaa_type_desc"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::StringRef getId() const;
  ::llvm::ArrayRef<TBAAMemberAttr> getMembers() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct TBAATagAttrStorage;

} // namespace detail
class TBAATagAttr : public ::mlir::Attribute::AttrBase<TBAATagAttr, ::mlir::Attribute, detail::TBAATagAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.tbaa_tag";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TBAATagAttr get(::mlir::MLIRContext *context, TBAATypeDescriptorAttr base_type, TBAATypeDescriptorAttr access_type, int64_t offset, bool constant);
  static TBAATagAttr get(TBAATypeDescriptorAttr baseType, TBAATypeDescriptorAttr accessType, int64_t offset);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tbaa_tag"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  TBAATypeDescriptorAttr getBaseType() const;
  TBAATypeDescriptorAttr getAccessType() const;
  int64_t getOffset() const;
  bool getConstant() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct MMRATagAttrStorage;

} // namespace detail
class MMRATagAttr : public ::mlir::Attribute::AttrBase<MMRATagAttr, ::mlir::Attribute, detail::MMRATagAttrStorage, ::mlir::OpAsmAttrInterface::Trait> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.mmra_tag";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static MMRATagAttr get(::mlir::MLIRContext *context, ::llvm::StringRef prefix, ::llvm::StringRef suffix);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"mmra_tag"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::StringRef getPrefix() const;
  ::llvm::StringRef getSuffix() const;
  ::mlir::OpAsmAliasResult getAlias(::llvm::raw_ostream &os) const;
};
namespace detail {

struct ConstantRangeAttrStorage;

} // namespace detail
class ConstantRangeAttr : public ::mlir::Attribute::AttrBase<ConstantRangeAttr, ::mlir::Attribute, detail::ConstantRangeAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.constant_range";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  using Base::getChecked;
  static ConstantRangeAttr get(::mlir::MLIRContext *context, ::llvm::APInt lower, ::llvm::APInt upper);
  static ConstantRangeAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::APInt lower, ::llvm::APInt upper);
  static ConstantRangeAttr get(::mlir::MLIRContext *context, uint32_t bitWidth, int64_t lower, int64_t upper);
  static ConstantRangeAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, uint32_t bitWidth, int64_t lower, int64_t upper);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::APInt lower, ::llvm::APInt upper);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::APInt lower, ::llvm::APInt upper);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"constant_range"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::APInt getLower() const;
  ::llvm::APInt getUpper() const;
};
namespace detail {

struct VScaleRangeAttrStorage;

} // namespace detail
class VScaleRangeAttr : public ::mlir::Attribute::AttrBase<VScaleRangeAttr, ::mlir::Attribute, detail::VScaleRangeAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.vscale_range";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static VScaleRangeAttr get(::mlir::MLIRContext *context, IntegerAttr minRange, IntegerAttr maxRange);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"vscale_range"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  IntegerAttr getMinRange() const;
  IntegerAttr getMaxRange() const;
};
namespace detail {

struct TargetFeaturesAttrStorage;

} // namespace detail
class TargetFeaturesAttr : public ::mlir::Attribute::AttrBase<TargetFeaturesAttr, ::mlir::Attribute, detail::TargetFeaturesAttrStorage, ::mlir::DLTIQueryInterface::Trait> {
public:
  using Base::Base;
  /// Checks if a feature is contained within the features list.
  /// Note: Using a StringAttr allows doing pointer-comparisons.
  bool contains(::mlir::StringAttr feature) const;
  bool contains(::llvm::StringRef feature) const;

  bool nullOrEmpty() const {
    // Checks if this attribute is null, or the features are empty.
    return !bool(*this) || getFeatures().empty();
  }

  /// Returns the list of features as an LLVM-compatible string.
  std::string getFeaturesString() const;

  /// Finds the target features on the parent FunctionOpInterface.
  /// Note: This assumes the attribute name matches the return value of
  /// `getAttributeName()`.
  static TargetFeaturesAttr featuresAt(Operation* op);

  /// Canonical name for this attribute within MLIR.
  static constexpr StringLiteral getAttributeName() {
    return StringLiteral("target_features");
  }

  /// Returns the attribute associated with the key.
  FailureOr<Attribute> query(DataLayoutEntryKey key);
  static constexpr ::llvm::StringLiteral name = "llvm.target_features";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  using Base::getChecked;
  static TargetFeaturesAttr get(::mlir::MLIRContext *context, ::llvm::ArrayRef<StringAttr> features);
  static TargetFeaturesAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<StringAttr> features);
  static TargetFeaturesAttr get(::mlir::MLIRContext *context, ::llvm::StringRef features);
  static TargetFeaturesAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::StringRef features);
  static TargetFeaturesAttr get(::mlir::MLIRContext *context, ::llvm::ArrayRef<::llvm::StringRef> features);
  static TargetFeaturesAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<::llvm::StringRef> features);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<StringAttr> features);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<StringAttr> features);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"target_features"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<StringAttr> getFeatures() const;
};
namespace detail {

struct TargetAttrStorage;

} // namespace detail
class TargetAttr : public ::mlir::Attribute::AttrBase<TargetAttr, ::mlir::Attribute, detail::TargetAttrStorage, ::mlir::DLTIQueryInterface::Trait, ::mlir::LLVM::TargetAttrInterface::Trait> {
public:
  using Base::Base;
  FailureOr<Attribute> query(DataLayoutEntryKey key);
  static constexpr ::llvm::StringLiteral name = "llvm.target";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TargetAttr get(::mlir::MLIRContext *context, StringAttr triple, StringAttr chip, TargetFeaturesAttr features);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"target"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  StringAttr getTriple() const;
  StringAttr getChip() const;
  TargetFeaturesAttr getFeatures() const;
};
class UndefAttr : public ::mlir::Attribute::AttrBase<UndefAttr, ::mlir::Attribute, ::mlir::AttributeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.undef";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"undef"};
  }

};
class PoisonAttr : public ::mlir::Attribute::AttrBase<PoisonAttr, ::mlir::Attribute, ::mlir::AttributeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.poison";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"poison"};
  }

};
namespace detail {

struct DSOLocalEquivalentAttrStorage;

} // namespace detail
class DSOLocalEquivalentAttr : public ::mlir::Attribute::AttrBase<DSOLocalEquivalentAttr, ::mlir::Attribute, detail::DSOLocalEquivalentAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.dso_local_equivalent";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DSOLocalEquivalentAttr get(::mlir::MLIRContext *context, FlatSymbolRefAttr sym);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"dso_local_equivalent"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  FlatSymbolRefAttr getSym() const;
};
namespace detail {

struct BlockTagAttrStorage;

} // namespace detail
class BlockTagAttr : public ::mlir::Attribute::AttrBase<BlockTagAttr, ::mlir::Attribute, detail::BlockTagAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.blocktag";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static BlockTagAttr get(::mlir::MLIRContext *context, uint32_t id);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"blocktag"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint32_t getId() const;
};
namespace detail {

struct BlockAddressAttrStorage;

} // namespace detail
class BlockAddressAttr : public ::mlir::Attribute::AttrBase<BlockAddressAttr, ::mlir::Attribute, detail::BlockAddressAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.blockaddress";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static BlockAddressAttr get(::mlir::MLIRContext *context, FlatSymbolRefAttr function, BlockTagAttr tag);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"blockaddress"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  FlatSymbolRefAttr getFunction() const;
  BlockTagAttr getTag() const;
};
namespace detail {

struct VecTypeHintAttrStorage;

} // namespace detail
class VecTypeHintAttr : public ::mlir::Attribute::AttrBase<VecTypeHintAttr, ::mlir::Attribute, detail::VecTypeHintAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.vec_type_hint";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static VecTypeHintAttr get(::mlir::MLIRContext *context, TypeAttr hint, bool is_signed);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"vec_type_hint"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  TypeAttr getHint() const;
  bool getIsSigned() const;
};
class ZeroAttr : public ::mlir::Attribute::AttrBase<ZeroAttr, ::mlir::Attribute, ::mlir::AttributeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.zero";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"zero"};
  }

};
namespace detail {

struct TailCallKindAttrStorage;

} // namespace detail
class TailCallKindAttr : public ::mlir::Attribute::AttrBase<TailCallKindAttr, ::mlir::Attribute, detail::TailCallKindAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.tailcallkind";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static TailCallKindAttr get(::mlir::MLIRContext *context, TailCallKind tailCallKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tailcallkind"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  TailCallKind getTailCallKind() const;
};
namespace detail {

struct WorkgroupAttributionAttrStorage;

} // namespace detail
class WorkgroupAttributionAttr : public ::mlir::Attribute::AttrBase<WorkgroupAttributionAttr, ::mlir::Attribute, detail::WorkgroupAttributionAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.mlir.workgroup_attribution";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static WorkgroupAttributionAttr get(::mlir::MLIRContext *context, IntegerAttr num_elements, TypeAttr element_type);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"mlir.workgroup_attribution"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  IntegerAttr getNumElements() const;
  TypeAttr getElementType() const;
};
namespace detail {

struct DereferenceableAttrStorage;

} // namespace detail
class DereferenceableAttr : public ::mlir::Attribute::AttrBase<DereferenceableAttr, ::mlir::Attribute, detail::DereferenceableAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.dereferenceable";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DereferenceableAttr get(::mlir::MLIRContext *context, uint64_t bytes, bool mayBeNull);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"dereferenceable"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint64_t getBytes() const;
  bool getMayBeNull() const;
};
namespace detail {

struct ModuleFlagAttrStorage;

} // namespace detail
class ModuleFlagAttr : public ::mlir::Attribute::AttrBase<ModuleFlagAttr, ::mlir::Attribute, detail::ModuleFlagAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.mlir.module_flag";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  using Base::getChecked;
  static ModuleFlagAttr get(::mlir::MLIRContext *context, ModFlagBehavior behavior, StringAttr key, Attribute value);
  static ModuleFlagAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ModFlagBehavior behavior, StringAttr key, Attribute value);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ModFlagBehavior behavior, StringAttr key, Attribute value);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ModFlagBehavior behavior, StringAttr key, Attribute value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"mlir.module_flag"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ModFlagBehavior getBehavior() const;
  StringAttr getKey() const;
  Attribute getValue() const;
};
namespace detail {

struct ModuleFlagCGProfileEntryAttrStorage;

} // namespace detail
class ModuleFlagCGProfileEntryAttr : public ::mlir::Attribute::AttrBase<ModuleFlagCGProfileEntryAttr, ::mlir::Attribute, detail::ModuleFlagCGProfileEntryAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.cgprofile_entry";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static ModuleFlagCGProfileEntryAttr get(::mlir::MLIRContext *context, FlatSymbolRefAttr from, FlatSymbolRefAttr to, uint64_t count);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"cgprofile_entry"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  FlatSymbolRefAttr getFrom() const;
  FlatSymbolRefAttr getTo() const;
  uint64_t getCount() const;
};
namespace detail {

struct ModuleFlagProfileSummaryDetailedAttrStorage;

} // namespace detail
class ModuleFlagProfileSummaryDetailedAttr : public ::mlir::Attribute::AttrBase<ModuleFlagProfileSummaryDetailedAttr, ::mlir::Attribute, detail::ModuleFlagProfileSummaryDetailedAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.profile_summary_detailed";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static ModuleFlagProfileSummaryDetailedAttr get(::mlir::MLIRContext *context, uint32_t cut_off, uint64_t min_count, uint32_t num_counts);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"profile_summary_detailed"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint32_t getCutOff() const;
  uint64_t getMinCount() const;
  uint32_t getNumCounts() const;
};
namespace detail {

struct ModuleFlagProfileSummaryAttrStorage;

} // namespace detail
class ModuleFlagProfileSummaryAttr : public ::mlir::Attribute::AttrBase<ModuleFlagProfileSummaryAttr, ::mlir::Attribute, detail::ModuleFlagProfileSummaryAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.profile_summary";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static ModuleFlagProfileSummaryAttr get(::mlir::MLIRContext *context, ProfileSummaryFormatKind format, uint64_t total_count, uint64_t max_count, uint64_t max_internal_count, uint64_t max_function_count, uint64_t num_counts, uint64_t num_functions, std::optional<uint64_t> is_partial_profile, FloatAttr partial_profile_ratio, ::llvm::ArrayRef<ModuleFlagProfileSummaryDetailedAttr> detailed_summary);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"profile_summary"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ProfileSummaryFormatKind getFormat() const;
  uint64_t getTotalCount() const;
  uint64_t getMaxCount() const;
  uint64_t getMaxInternalCount() const;
  uint64_t getMaxFunctionCount() const;
  uint64_t getNumCounts() const;
  uint64_t getNumFunctions() const;
  std::optional<uint64_t> getIsPartialProfile() const;
  FloatAttr getPartialProfileRatio() const;
  ::llvm::ArrayRef<ModuleFlagProfileSummaryDetailedAttr> getDetailedSummary() const;
};
namespace detail {

struct DependentLibrariesAttrStorage;

} // namespace detail
class DependentLibrariesAttr : public ::mlir::Attribute::AttrBase<DependentLibrariesAttr, ::mlir::Attribute, detail::DependentLibrariesAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.dependent_libraries";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static DependentLibrariesAttr get(::mlir::MLIRContext *context, ::llvm::ArrayRef<StringAttr> libs);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"dependent_libraries"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<StringAttr> getLibs() const;
};
namespace detail {

struct UWTableKindAttrStorage;

} // namespace detail
class UWTableKindAttr : public ::mlir::Attribute::AttrBase<UWTableKindAttr, ::mlir::Attribute, detail::UWTableKindAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.uwtableKind";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static UWTableKindAttr get(::mlir::MLIRContext *context, uwtable::UWTableKind uwtableKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"uwtableKind"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uwtable::UWTableKind getUwtableKind() const;
};
namespace detail {

struct IntegerOverflowFlagsAttrStorage;

} // namespace detail
class IntegerOverflowFlagsAttr : public ::mlir::Attribute::AttrBase<IntegerOverflowFlagsAttr, ::mlir::Attribute, detail::IntegerOverflowFlagsAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.overflow";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static IntegerOverflowFlagsAttr get(::mlir::MLIRContext *context, ::mlir::LLVM::IntegerOverflowFlags value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"overflow"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::LLVM::IntegerOverflowFlags getValue() const;
};
namespace detail {

struct FastmathFlagsAttrStorage;

} // namespace detail
class FastmathFlagsAttr : public ::mlir::Attribute::AttrBase<FastmathFlagsAttr, ::mlir::Attribute, detail::FastmathFlagsAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "llvm.fastmath";
  static constexpr ::llvm::StringLiteral dialectName = "llvm";
  static FastmathFlagsAttr get(::mlir::MLIRContext *context, ::mlir::LLVM::FastmathFlags value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"fastmath"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::LLVM::FastmathFlags getValue() const;
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AddressSpaceAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::CConvAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ComdatAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LinkageAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FramePointerKindAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopVectorizeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopInterleaveAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopUnrollAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopUnrollAndJamAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopLICMAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopDistributeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopPipelineAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopPeeledAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopUnswitchAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoopAnnotationAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIExpressionElemAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIExpressionAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DINullTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIBasicTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DICompileUnitAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DICompositeTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIDerivedTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIFileAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIGlobalVariableExpressionAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIGlobalVariableAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DILexicalBlockAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DILexicalBlockFileAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DILocalVariableAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DISubprogramAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIModuleAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DINamespaceAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIImportedEntityAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIAnnotationAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DISubrangeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DICommonBlockAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIGenericSubrangeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DISubroutineTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DILabelAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DIStringTypeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::MemoryEffectsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AliasScopeDomainAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AliasScopeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AccessGroupAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TBAARootAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TBAAMemberAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TBAATypeDescriptorAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TBAATagAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::MMRATagAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ConstantRangeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::VScaleRangeAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TargetFeaturesAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TargetAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::UndefAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::PoisonAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DSOLocalEquivalentAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BlockTagAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BlockAddressAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::VecTypeHintAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ZeroAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::TailCallKindAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::WorkgroupAttributionAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DereferenceableAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ModuleFlagAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ModuleFlagCGProfileEntryAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ModuleFlagProfileSummaryDetailedAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ModuleFlagProfileSummaryAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DependentLibrariesAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::UWTableKindAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::IntegerOverflowFlagsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FastmathFlagsAttr)

#endif // GET_ATTRDEF_CLASSES

