/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: AMDGPU.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::amdgpu {

/// AMDGPU DPP operation
/// This operation represents DPP functionality in a GPU program.
///      DPP provides the following operations:
///     - Full crossbar in a group of four (`quad_perm`)
///     - Wavefront shift left by one lane (`wave_shl`)
///     - Wavefront shift right by one lane (`wave_shr`)
///     - Wavefront rotate right by one lane (`wave_ror`)
///     - Wavefront rotate left by one lane (`wave_rol`)
///     - Row shift left by 1–15 lanes (`row_shl`)
///     - Row shift right by 1–15 lanes (`row_shr`)
///     - Row rotate right by 1–15 lanes (`row_ror`)
///     - Reverse within a row (`row_mirror`)
///     - Reverse within a half-row (`row_half_mirror`)
///     - Broadcast the 15th lane of each row to the next row (`row_bcast`)
///     - Broadcast lane 31 to rows 2 and 3 (`row_bcast`)
class DPPOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Extend a fp8 value to a float or a vector of packed fp8 values to two floats
/// Extend one or two 8-bit floats in `source[index]` to a 32-bit float or
///     two floats and return them.
/// 
///     This rather unusual signature arises from the fact that AMD GPUs cannot
///     easily work with sub 32-bit quantities, so the compiler intrinsics for
///     extending 8-bit floats (which are, currently, the only way to work with
///     this operation) take packed vectors of 4 such floats.
/// 
///     If the passed-in vector has fewer than four elements, or the input is scalar,
///     the remaining values in the <4 x i8> will be filled with
///     undefined values as needed.
class ExtPackedFp8Op;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Create a raw buffer fat pointer that matches `memref`
/// Wraps the memory pointed to by `source` as a raw buffer fat pointer, or,
///     in LLVM terms, a `ptr addrspace(7)`, returning a memref that has the same
///     sizes and layout but the `#amdgpu.address_space<fat_raw_buffer>`
///     address space.
/// 
///     This memref can be used with standard memref operations like `memref.load`,
///     `memref.store`, and `memref.atomicrmw`, which will be lowered to the relevant
///     buffer intrinsics. (`vector.masked_load/store` will work once there's backend
///     support for lowering them, and then this document will be updated)
/// 
///     If `validBytes` is given, it is the number of bytes that will be valid as
///     an offset to `out`. If it is not provided, this will be inferred from
///     the size of the memref during lowering. This size is
///     max_{d = 0 upto rank(source)} (sizes[d] * strides[d]) * sizeof(element type).
/// 
///     The flags of the buffer descriptor will be set up to enable raw usage -
///     for example, stride = 0, add_tid = 0, and so on. The `boundsCheck`
///     property determines if bounds checking is enabled or not (on architectures
///     where this can be controlled - that is, on RDNA chips).
/// 
///     If `cacheSwizzleStride` is provided, L1 cache swizzling will be enabled
///     on architectures that support it. This swizzling, unlike the main swizzling
///     mode (whose usage makes a buffer non-raw) does not affect index calculation,
///     but does affect cache behavior. Mixing access between cache-swizzled raw
///     buffers and other forms of memory access, like ordinary pointer loads or
///     unswizzled buffer pointers can cause incorrect behavior and must be avoided.
/// 
///     This operation preserves the sizes, strides, and offset of the input
///     memref - they'll be added in by `memref.load` later. However, if
///     `resetOffset` is set, that offset will be added to the base pointer.
///     If the value of the memref's offset is not uniform (independent of the lane/thread ID),
///     this will lead to substantially decreased performance due to the need for
///     a waterfall loop on the base address of the buffer resource.
class FatRawBufferCastOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for CDNA Gather to LDS instructions
/// The `amdgpu.gather_to_lds` op is a wrapper around the `global_load_lds` instructions.
/// 
///     Operands:
///     * `$src`: global memory (including fat buffer) memref to read from.
///     * `$srcIndices`: indices into `$src` to read from for this thread.
///     * `$dst`: LDS memory memref to write to.
///     * `$dstIndices`: base indices into `$dst` to write to for the subgroup of this thread.
///       The elements gathered by the subgroup will be written contiguously in order of lane ID
///       starting at `$dst[$dstIndices]`. Byte-sized (ex. i8) or short-sized (ex. i16)
///       types will be zero-padded/extended to 32 bits before being written. 96-bit types
///       (ex. vector<3xf32>) will be zero-padded to 128 bits before being written. Only the
///       offsets held by lane 0 are used.
///     * `$transferType`: type of the data to be transferred by each thread. This is used to determine
///       the size of the data to be transferred and the number of threads in the subgroup.
///       The transfer type must be a scalar type or a vector type with a single element type.
/// 
///     The `$dst`, along with its indices, points to the memory location the subgroup of this thread
///     will write to.
/// 
///     Note: only supported on gfx9 and gfx10.
class GatherToLDSOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Barrier that includes a wait for LDS memory operations.
/// `amdgpu.lds_barrier` is both a barrier (all workitems in a workgroup must reach
///     the barrier before any of them may proceed past it) and a wait for all
///     operations that affect the Local Data Store (LDS) issued from that wrokgroup
///     to complete before the workgroup may continue. Since the LDS is per-workgroup
///     memory, this barrier may be used, for example, to ensure all workitems have
///     written data to LDS before any workitem attempts to read from it.
/// 
///     Note that `lds_barrier` does **not** force reads to or from global memory
///     to complete before execution continues. Therefore, it should be used when
///     operations on global memory can be issued far in advance of when their results
///     are used (for example, by writing them to LDS).
/// 
///     WARNING: On architectures that do not support the BackOffBarrier feature,
///     (those which will implement this barrier by emitting inline assembly),
///     use of this operation will impede the usabiliity of memory watches (including
///     breakpoints set on variables) when debugging.
class LDSBarrierOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for CDNA mfma instructions
/// The `amdgpu.mfma` op is an MLIR wrapper around intrinsics
///     for various `mfma` instructions in the CDNA architecture, which perform
///     multiple outer products in order to allow fast matrix multiplication.
/// 
///     The wrapper will select an appropriate `mfma` instruction, if one is available,
///     based on the provided `m`, `k`, `n`, and `nBlks` attributes, along with the
///     types of the source and destination arguments.
/// 
///     For information on the layouts of the input and output matrices (which are stored
///     in `sourceA`, `sourceB`, `destC`, and `destD`), see the CDNA ISA documentation.
/// 
///     The `cbsz`, `abid`, and `blgp` parameters control how the lanes of the wave
///     are permuted when matrix data is being loaded: `blgp` can be any number of
///     fixed permutations, `cbsz` specifies the log_2 of the number of chunks the lanes
///     holding sourceA are split into, and `abid` selects one of those chunks.
/// 
///     Note, this wrapper allows specifying `vector<4Kxi8>` arguments to MFMA
///     intrinsics that take an integer type of width `4K`. For example,
///     one can provide a vector<4xi8> as an argument to an MFMA instruction that
///     logically takes 4 i8s but whose intrinsics are specified to take an i32.
///     In these cases, the bytes in the vector will be concatenated in little-endian
///     order (that is, v[0] will go to arg[7:0], v[1] to arg[15:8] and so on).
/// 
///     The negateA, negateB, and negateC flags are only supported for double-precision
///     operations on gfx94x.
/// 
///     Example:
///     ```mlir
///       %0 = amdgpu.mfma 16x16x16 %matA * %matB + %matC
///         : vector<4xf16>, vector<4xf16>, vector<4xf32>
/// 
///       %1 = amdgpu.mfma 32x32x1 %matD * %matE + %matF
///         { abid = 1 : i32, cbsz = 1 : i32, blocks = 2 : i32 }
///         blgp = bcast_second_32 : f32, f32, vector<32xf32>
///     ```
class MFMAOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Pair of based addresses used when moving tiles between LDS and global memory.
/// This operation creates a pair of addresses that will be used by tensor_load_to_lds
///     and tensor_store_from_lds.
/// 
///     This operation creates a value corresponding to the tensor descriptor (D#) group 0
///     found in TensorLoadToLDSOp and TensorStoreFromLDSOp in the rocdl dialect.
/// 
///     For example:
/// 
///     ```mlir
///       %base = amdgpu.make_dma_base %global[%idx0, %idx1], %lds[%idx2, %idx3] : memref<64x64xi32>, memref<64x64xi32, #gpu.address_space<workgroup>> -> !amdgpu.tdm_base<i32>
///       %descriptor = amdgpu.make_dma_descriptor %base globalSize [2, 2] globalStride [2, 1] sharedSize [2, 2] : !amdgpu.tdm_base<i32> -> !amdgpu.tdm_descriptor
///       amdgpu.tensor_load_to_lds %descriptor : !amdgpu.tdm_descriptor
///     ```
/// 
///     to
/// 
///     ```mlir
///       // pseudo-code
///       %global_base = llvm.extractvalue %global_memref[1]
///       %global_address = llvm.get_element_ptr ...
/// 
///       %lds_base = llvm.extractvalue %lds_memref[1]
///       %lds_address = llvm.get_element_ptr ...
/// 
///       // Definition of %base
///       %undef = llvm.mlir.undef : vector<4xi32>
///       %v0 = llvm.insertelement %15, %undef[0] : vector<4xi32>
///       %v1 = llvm.insertelement %lds_address, %v0[1] : vector<4xi32>
///       %v2 = llvm.insertelement %global_address_low, %v1[2] : vector<4xi32>
///       %base = llvm.insertelement %global_address_high, %v2[3] : vector<4xi32>
/// 
///       rocdl.tensor.load.to.lds %base, %dgroup1, %dgroup2, %dgroup3 cachepolicy 0 : vector<4xi32>, vector<8xi32>
///     ```
/// 
///     These tensor DMA operations were introduced in gfx1250.
class MakeDmaBaseOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Make all descriptor groups needed by TensorLoadToLDS/TensorStoreFromLDS.
/// Make all descriptor groups needed by tensor memory operations.
/// 
///      The $base operand corresponds to the base pair addresses, one must be an address in LDS
///      while the other must be a global memory location.
/// 
///      $global_{static/dynamic}_sizes determine the size of the tensor.
///      $global_{static/dynamic}_strides determine the strides of the tensor.
///      $shared_{static/dynamic}_sizes determines the size of the tile.
/// 
///      $workgroup_mask broadcast load to workgroups inside of a workgroup cluster
///      (0 = do not broadcast result to workgroup, 1 = broadcast result to workgroup). Ignored for stores.
///      An all zeros mask is interpreted as a non-broadcasted load.
/// 
///      $early_timeout return data to requesters as soon as cache supplies it.
/// 
///      Padding can be applied to the LDS address when copying from memory to LDS,
///      but not when copying from LDS to memory.
///      The values in the padded target addresses remain the same as before the operation was applied.
///      $pad_interval must be a power of two contained in [2, 256].
///      $pad_amount must be a value contained in [1, 128].
/// 
///      $atomic_barrier_address must be aligned to 8 bytes.
/// 
///      2D and 3D tensors may be iterated over by setting $global_increment, $lds_increment, and $iteration_count.
///      $global_increment determines how much to increment the starting global memory address per iteration in units of the $base's element type.
///      $lds_increment determines how much to increment the starting LDS address per iteration in units of the $base's element type.
///      $iterate_count determines how many times to iterate, it must be a value in the inclusive interval [1, 256].
/// 
///      ```mlir
///       // Example of moving a two-dimensional tensor to LDS.
///       %base = amdgpu.make_dma_base %global[0, 0], %lds[0, 0] : memref<64x64xi32>, memref<64x64xi32, #gpu.address_space<workgroup>> -> !amdgpu.tdm_base<i32>
///       %descriptor = amdgpu.make_dma_descriptor %base globalSize [64, 64] globalStride [64, 1] sharedSize [64, 64] : !amdgpu.tdm_base<i32> -> !amdgpu.tdm_descriptor
///       amdgpu.tensor_load_to_lds %descriptor : !amdgpu.tdm_descriptor
/// 
///       // Example of moving a two dimension tensor to LDS where padding is applied after every integer.
///       %base = amdgpu.make_dma_base %global[0, 0], %lds[0, 0] : memref<32x32xi32>, memref<64x64xi32, #gpu.address_space<workgroup>> -> !amdgpu.tdm_base<i32>
///       %descriptor = amdgpu.make_dma_descriptor %base globalSize [32, 32] globalStride [32, 1] sharedSize [64, 64] padShared(%pad_amount every %pad_interval) : !amdgpu.tdm_base<i32> -> !amdgpu.tdm_descriptor
///       amdgpu.tensor_load_to_lds %descriptor : !amdgpu.tdm_descriptor
///      ```
class MakeDmaDescriptorOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Pair of based addresses used when moving tiles between LDS and global memory.
/// This operation creates a pair of addresses that will be used by `tensor_load_to_lds`
///     and `tensor_store_from_lds`.
/// 
///     This operation creates a value corresponding to the tensor descriptor (D#) group 0
///     found in TensorLoadToLDSOp and TensorStoreFromLDSOp in the rocdl dialect.
/// 
///     Unlike `make_dma_base`, this operation returns `!amdgpu.tdm_gather_base<$element_type, $index_type>`
///     which is only compatible with `make_gather_dma_descriptor`. Using the descriptor returned
///     by `make_gather_dma_descriptor` will set the `tensor_load_to_lds` and `tensor_store_from_lds` to gather mode.
/// 
///     ```mlir
///       %base = amdgpu.make_gather_dma_base %global[%idx0, %idx1], %lds[%idx2, %idx3] : memref<64x64xi32>, memref<64x64xi32, #gpu.address_space<workgroup>> -> !amdgpu.tdm_gather_base<i32, i16>
///       // %indices : i16
///       %descriptor = amdgpu.make_gather_dma_descriptor %base[%indices] globalSize [2, 2] globalStride [2, 1] sharedSize [2, 2] : !amdgpu.tdm_gather_base<i32, i16>, i16 -> !amdgpu.tdm_descriptor
///       amdgpu.tensor_load_to_lds %descriptor : !amdgpu.tdm_descriptor
///     ```
class MakeGatherDmaBaseOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Make all descriptor groups needed by TensorLoadToLDS/TensorStoreFromLDS.
class MakeGatherDmaDescriptorOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Wait for specified hardware counters
/// Wait for the specified counters to be less-than or equal-to the provided
///     values before continuing.
/// 
///     Counters can lower to different instructions on different architectires,
///     including clamping to the some HW supported max value or combining multiple
///     counters into one.
class MemoryCounterWaitOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Round two floats into a packed vector of floats
/// Scale and round the inputs `source` (which is undefined if not
///     specified) into the low or high word (bottom two or top two) elements
///     of the returned vector, keeping the other two elements of `existing`
///     unchanged if present (or undefined if it was not passed in).
/// 
///     The reason for this odd signature is that AMD GPUs cannot easily work with
///     sub-registers, and so the conversion intrinsics take 32-bit wide
///     packed vectors of float values.
class PackedScaledTruncOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Round float stochiastically into a packed vector of 8-bit floats
/// Round the input `source`, adding in `stochiasticParam`, and place it into
///     the `storeIndex`th element of `res`.
/// 
///     If `existing` is passed in, elements of `res` other than the one at `storeIndex`
///     are copied from `existing`.
/// 
///     The reason for this odd signature is that AMD GPUs cannot easily work with
///     sub-registers, and so the conversion intrinsics (which are currently the
///     only way to work with 8-bit float types) take packed vectors of 4 8-bit
///     values.
class PackedStochRoundFp8Op;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Round two floats into a packed vector of 8-bit floats
/// Round the inputs `sourceA` and `sourceB` (which is undefined if not
///     specified) into the low or high word (bottom two or top two) elements
///     of the returned vector, keeping the other two elements of `existing`
///     unchanged if present (or undefined if it was not passed in).
/// 
///     The reason for this odd signature is that AMD GPUs cannot easily work with
///     sub-registers, and so the conversion intrinsics (which are currently the
///     only way to work with 8-bit float types) take packed vectors of 4 8-bit
///     values.
class PackedTrunc2xFp8Op;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// AMDGPU permlane swap op
/// High-level wrapper on `rocdl.permlane{16,32}.swap` variants for permutations
///     on rows of lanes in a subgroup.
/// 
///     Supports arbitrary int/float/vector types, which will be repacked to i32 and
///     one or more `rocdl.permlane_swap` ops during lowering.
///     Supported lane permutations:
///     - Swap the data between odd and even rows of 16 lanes
///     - Swap the data between the first 32 lanes and the last 32 lanes
/// 
///     Example:
///     ```mlir
///     %0 = amdgpu.permlane_swap %src 16 : f16
///     %1 = amdgpu.permlane_swap %src 32 { fetch_inactive = true, bound_ctrl = true } : f16
///     ```
/// 
///     Operands:
///     * `$src`: Vector register to permute across lanes of the subgroup.
///     * `$row_length`: The length of a row to permute in number of lanes (valid values are 16 and 32).
///     * `$fetch_inactive`: Optional. Used to dertermine behavior of a fetch from a disabled lane.
///       `fetch_inactive = false`: If the source lane is disabled, use `bound_ctrl` to determine the source value.
///       `fetch_inactive = true`: If the source lane is disabled, fetch the source value anyway (ignoring `bound_ctrl`).
///     * `$bound_ctrl`: Optional. Used to determine what a thread should do if its source operand is from
///       a disabled lane: use the value zero, or disable the write.
///       `bound_ctrl = false`: Do not write when source is from a disabled lane
///       `bound_ctrl = true`: Use zero as input if source is from a disabled lane
/// 
///     Note: Lowering is only supported on gfx950 and up.
class PermlaneSwapOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Atomic compare-and-swap
/// The `amdgpu.raw_buffer_atomic_cmpswap` op is a wrapper around the
///     buffer-based atomic compare-and-swap min available on AMD GPUs.
/// 
///     The index into the buffer is computed as for `memref.store` with the addition
///     of `indexOffset` (which is used to aid in emitting vectorized code) and,
///     if present `sgprOffset` (which is added after bounds checks and includes
///     any non-zero offset on the memref type).
/// 
///     All indexing components are given in terms of the memref's element size, not
///     the byte lengths required by the intrinsic.
/// 
///     Out of bounds atomic operations are ignored in hardware.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferAtomicCmpswapOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Floating-point Atomic Add (MI-* only)
/// The `amdgpu.raw_buffer_atomic_fadd` op is a wrapper around the
///     buffer-based atomic floating point addition available on the MI-* series
///     of AMD GPUs.
/// 
///     The index into the buffer is computed as for `memref.store` with the addition
///     of `indexOffset` (which is used to aid in emitting vectorized code) and,
///     if present `sgprOffset` (which is added after bounds checks and includes
///     any non-zero offset on the memref type).
/// 
///     All indexing components are given in terms of the memref's element size, not
///     the byte lengths required by the intrinsic.
/// 
///     Out of bounds atomic operations are ignored in hardware.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferAtomicFaddOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Floating-point Atomic Max (non-GFX9)
/// The `amdgpu.raw_buffer_atomic_fmax` op is a wrapper around the
///     buffer-based atomic floating point max available on AMD GPUs (except GFX9).
/// 
///     The index into the buffer is computed as for `memref.store` with the addition
///     of `indexOffset` (which is used to aid in emitting vectorized code) and,
///     if present `sgprOffset` (which is added after bounds checks and includes
///     any non-zero offset on the memref type).
/// 
///     All indexing components are given in terms of the memref's element size, not
///     the byte lengths required by the intrinsic.
/// 
///     Out of bounds atomic operations are ignored in hardware.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferAtomicFmaxOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Signed Integer Atomic Max
/// The `amdgpu.raw_buffer_atomic_smax` op is a wrapper around the
///     buffer-based atomic signed integer max available on AMD GPUs.
/// 
///     The index into the buffer is computed as for `memref.store` with the addition
///     of `indexOffset` (which is used to aid in emitting vectorized code) and,
///     if present `sgprOffset` (which is added after bounds checks and includes
///     any non-zero offset on the memref type).
/// 
///     All indexing components are given in terms of the memref's element size, not
///     the byte lengths required by the intrinsic.
/// 
///     Out of bounds atomic operations are ignored in hardware.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferAtomicSmaxOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Unsigned Integer Atomic Min
/// The `amdgpu.raw_buffer_atomic_umin` op is a wrapper around the
///     buffer-based atomic signed integer min available on AMD GPUs.
/// 
///     The index into the buffer is computed as for `memref.store` with the addition
///     of `indexOffset` (which is used to aid in emitting vectorized code) and,
///     if present `sgprOffset` (which is added after bounds checks and includes
///     any non-zero offset on the memref type).
/// 
///     All indexing components are given in terms of the memref's element size, not
///     the byte lengths required by the intrinsic.
/// 
///     Out of bounds atomic operations are ignored in hardware.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferAtomicUminOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer load, exposing GCN features
/// The `amdgpu.raw_buffer_load` op is a wrapper around the buffer load intrinsics
///     available on AMD GPUs, including extensions in newer GPUs.
/// 
///     The index into the buffer is computed as for `memref.load` with the additon
///     of `indexOffset` and `sgprOffset` (which **may or may not** be considered
///     in bounds checks and includes any offset present on the memref type if it's
///     non-zero).
/// 
///     All indices and offsets are in units of the memref's data type and are
///     converted to bytes during lowering.
/// 
///     When a load is out of bounds, the instruction returns zero.
///     Partially-out of bounds have chipset-dependent behavior: whether reading
///     2 elements starting at index 7 of a `memref<8xf32>` returns the last element
///     in the first vector component depends on the architecture.
/// 
///     The memref struct is converted into a buffer resource (a V#) and the arguments
///     are translated to intrinsic arguments as follows:
///     - The base address of the buffer is the base address of the memref
///     - The stride is 0 to enable raw mode
///     - The number of records is the size of the memref, in bytes
///       In the case of dynamically-shaped memrefs, this is computed at runtime
///       as max_d (size(d) * stride(d)) * sizeof(elementType(memref))
///     - The offset enable bit is 1, the index enable bit is 0.
///     - The thread ID addition bit is off
///     - If `boundsCheck` is false and the target chipset is RDNA, OOB_SELECT is set
///       to 2 to disable bounds checks, otherwise it is 3
///     - The cache coherency bits are off
class RawBufferLoadOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Raw Buffer Store, exposing GCN features
/// The `amdgpu.raw_buffer_store` op is a wrapper around the buffer store
///     intrinsics available on AMD GPUs, including extensions in newer GPUs.
/// 
///     The store index is computed as in `memref.store` with the addition of
///     `indexOffset` (which is included for uniformity with atomics and may be useful
///     when writing vectorized code) and `sgprOffset` (which is added after bounds
///     checks and implicitly includes the offset of the memref type if non-zero).
///     All index components are in terms of the elements of the memref, not bytes,
///     and are scaled up appropriately.
/// 
///     Out of bounds stores are ignored in hardware.
///     Wthether a vector write that includes some in-bounds and soeme out-of-bounds
///     components is partically completed is chipset-dependent.
/// 
///     See `amdgpu.raw_buffer_load` for a description of how the underlying
///     instruction is constructed.
class RawBufferStoreOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Extend a wave-wide matrix of packed floating point values
/// Extend matrix of microfloats (8 or 16 elements per lane) using a set of scales
///     that may be stored on other lanes.
/// 
///     The scales applied to the input microfloats are stored in bytes which
///     come from the `scales` input provided in a *half* of the wave identified
///     by `firstScaleLane`. The bytes used is selected by `firstScaleByte` and depends
///     on the type of `source`. The 16 vectors in consecutive lanes starting from
///     `firstScaleLane` (which we'll call the scale vectors) will be used by both
///     halves of the wave (with lane L reading from L % 16'th scale vector).
/// 
///     When `source` is either F4E2M1FN, F6E2M3FN, or F6E3M2FN each half of the
///     wave will use a different byte. The first one being `firstScaleByte` and
///     the second one being `firstScaleByte` + 1. When the block size is 32,
///     `firstScaleByte` can be either 0 or 2, selecting halves of the scale vectors.
///     Lanes 0-15 will read from `firstScaleByte` and lanes 16-31 will read
///     from `firstScaleByte` + 1.
/// 
/// 
///     For example:
///     ```mlir
///     // Input: 8-element vector of F8E4M3FN, converting to F32
///     // Lanes 0-15 read from byte 0, lanes 16-31 read from byte 1
///     %result = amdgpu.scaled_ext_packed_matrix %source scale(%scales)
///       blockSize(32) firstScaleLane(0) firstScaleByte(0)
///       : vector<8xf8E4M3FN>, vector<4xf8E8M0FNU> -> vector<8xf32>
/// 
///     // Input: 16-element vector of F6E2M3FN, converting to F16
///     // Lanes 0-15 read from byte 2, lanes 16-31 read from byte 3
///     %result = amdgpu.scaled_ext_packed_matrix %source scale(%scales)
///       blockSize(32) firstScaleLane(16) firstScaleByte(2)
///       : vector<16xf6E2M3FN>, vector<4xf8E8M0FNU> -> vector<16xf16>
///     ```
/// 
///     When `source` is either F4E2M1FN, F6E2M3FN, or F6E3M2FN and
///     the block size is 16, `firstScaleByte` can be 0 or 1.
///     Lanes 0-15 read from the `firstScaleByte`th element of the scale vectors,
///     while lanes 16-31 read from `firstScaleByte` + 2.
///     For example:
///     ```mlir
///     // Input: 8-element vector of F8E5M2, converting to BF16
///     // Lanes 0-15 read from byte 0, lanes 16-31 read from byte 2 (0+2)
///     %result = amdgpu.scaled_ext_packed_matrix %source scale(%scales)
///       blockSize(16) firstScaleLane(0) firstScaleByte(0)
///       : vector<8xf8E5M2>, vector<4xf8E8M0FNU> -> vector<8xbf16>
/// 
///     // Input: 16-element vector of F6E3M2FN, converting to F32
///     // Lanes 0-15 read from byte 1, lanes 16-31 read from byte 3 (1+2)
///     %result = amdgpu.scaled_ext_packed_matrix %source scale(%scales)
///       blockSize(16) firstScaleLane(16) firstScaleByte(1)
///       : vector<16xf6E3M2FN>, vector<4xf8E8M0FNU> -> vector<16xf32>
///     ```
/// 
///     Note: the layout for the scales generally mirrors how the WMMA
///     instructions use for matrix scales. These selection operands allows
///     one to choose portions of the matrix to convert.
/// 
///     When `source` is either F8E4M3FN or F8E5M2 and `blockSize` is 32,
///     then the same byte will be used by both halves of the wave.
///     In this case, `firstScaleByte` can be any value from 0 to 3.
/// 
///     When `source` is either F8E4M3FN or F8E5M2 and `blockSize` is 16,
///     following combinations are allowed:
///     * `firstScaleLane(0), firstScaleByte(0)`
///     * `firstScaleLane(16), firstScaleByte(2)`
///     all other combinations are reserved.
/// 
///     Available on gfx1250+.
class ScaledExtPackedMatrixOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Extend a vector of packed floating point values
/// Extend and scale two packed floats in `source[index]` to two floats and
///     return them.
/// 
///     This rather unusual signature arises from the fact that AMD GPUs cannot
///     easily work with sub 32-bit quantities, so the compiler intrinsics for
///     extending 8-bit floats (which are, currently, the only way to work with
///     this operation) take packed vectors of 2 such floats.
/// 
///     If the passed-in vector has fewer than two elements, or the input is scalar,
///     the remaining values in the <2 x i8> will be filled with
///     undefined values as needed.
class ScaledExtPackedOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for CDNA scaled mfma instructions
/// The `amdgpu.scaled_mfma` op is an MLIR wrapper around intrinsics
///     for various scaled versions of `mfma` instructions in the CDNA architecture, which
///     perform multiple outer products in order to allow fast matrix multiplication.
/// 
///     The wrapper will select an appropriate `mfma` instruction, if one is available,
///     based on the provided `m`, `k`, `n`, and `nBlks` attributes, along with the
///     types of the source and destination arguments.
/// 
///     Note, this wrapper allows specifying `vector<4Kxi8>` arguments to MFMA
///     intrinsics that take an integer type of width `4K`. For example,
///     one can provide a `vector<4xi8>` as an argument to an MFMA instruction that
///     logically takes 4 i8s but whose intrinsics are specified to take an i32.
///     In these cases, the bytes in the vector will be concatenated in little-endian
///     order (that is, v[0] will go to arg[7:0], v[1] to arg[15:8] and so on).
/// 
///     This wrapper takes inspiration from `amdgpu.mfma`, but has some key differences:
///     - `amdgpu.scaled_mfma` operates on fp4 (f4E2M1FN), fp6 (f6E2M3FN and f6E3M2FN) and
///       fp8 (f8E4M3FN and f8E5M2) types using either M=N=16, K=128 or M=N=32, K=64 as
///       their tile size.
///     - `amdgpu.scaled_mfma` does not support broadcasting. So, `cbsz`, `abid`, and `blgp`
///       are omitted from this wrapper.
///     - The `negateA`, `negateB`, and `negateC` flags in `amdgpu.mfma` are only supported
///       for double-precision operations on gfx94x and so are not included here.
/// 
///     Example:
///     ```mlir
///       %0 = amdgpu.scaled_mfma 32x32x64 (%arg0[0] * %arg1) * (%arg0[1] * %arg1) + %arg2
///         : vector<4xf8E8M0FNU>, vector<32xf6E2M3FN>, f8E8M0FNU, vector<32xf6E2M3FN>, vector<16xf32>
///     ```
class ScaledMFMAOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for scaled wmma instructions
/// The `amdgpu.scaled_wmma` op is an MLIR wrapper around intrinsics for scaled
///     `wmma` instructions. These instructions perform matrix multiplication with
///     per-block scaling of inputs, supporting fp4, fp6, and fp8 data formats.
/// 
///     The scale instructions support a block size of 16 or 32 and two tile sizes:
///     - 16x16x128 with mixed f8/f6/f4 formats (output: vector<8xf32>)
///     - 32x16x128 with f4 format only (output: vector<16xf32>)
/// 
///     Scale parameters (`scaleA`, `scaleB`) are small vectors of f8 scale values
///     (either f8E8M0FNU, or f8E4M3FN) that are packed into i32/i64 values during
///     lowering. Each lane can operate on 4 bytes (4 scale values), and the
///     number of scales required for each matrix is determined by:
///       num_scales_A = (M × K) / block_size
///       num_scales_B = (N × K) / block_size
/// 
///     The index attributes (`a_first_scale_lane`, `b_first_scale_lane`) select
///     which lane to start reading scale values from (0 or 16):
///     - For block size 32, 32 lanes across a single wave are used for the scale
///     values. If the number of scales (num_scales_A or num_scales_B) can fit
///     into half of the available lanes
///     (i.e., num_scales / scales_per_lane == 16 (num_lanes)),
///     then then first_scale_lane can be either 0 or 16. If all lanes are required
///     for storing the scale values (num_scales / scales_per_lane == 32 (num_lanes)),
///     then the first_scale_lane must be 0.
///     - For block size 16, the same rules apply as above except that there are 64
///     lanes across two waves that are used for the scale values. When
///     num_scales / scales_per_lane == 32 (num lanes), then 16 lanes from each wave are used.
///     first_scale_lane of 0 or 16 will decide which lanes are used for this. When
///     num_scales / scales_per_lane == 64 (num_lanes), then first_scale_lane must
///     be set to 0.
/// 
///     Example:
///     ```mlir
///       // 16x16x128: fp8 inputs
///       %0 = amdgpu.scaled_wmma 16x16x128 (%scaleVecA * %matA) * (%scaleVecB * %matB) + %matC
///         {a_first_scale_lane = 0 : i32, b_first_scale_lane = 0 : i32}
///         : vector<4xf8E8M0FNU>, vector<64xf8E4M3FN>,
///         vector<4xf8E8M0FNU>, vector<64xf8E4M3FN>, vector<8xf32>
/// 
///       // 32x16x128: fp4 inputs with different scale lanes
///       %1 = amdgpu.scaled_wmma 32x16x128 (%scaleVecD * %matD) * (%scaleVecE * %matE) + %matF
///         {a_first_scale_lane = 0 : i32, b_first_scale_lane = 16 : i32}
///         : vector<8xf8E4M3FN>, vector<128xf4E2M1FN>,
///         vector<8xf8E4M3FN>, vector<64xf4E2M1FN>, vector<16xf32>
///     ```
class ScaledWMMAOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Barrier that limits the backend scheduler of instruction movement
/// `amdgpu.sched_barrier` serves as a barrier that could be
///     configured to restrict movements of instructions through it as
///     defined by sched_barrier_opts.
class SchedBarrierOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for CDNA sparse mfma (smfmac) instructions
/// The `amdgpu.sparse_mfma` op is an MLIR wrapper around intrinsics for various
///     `smfmac` instructions in the AMDGPU architecture, which perform matrix
///     multiply-accumulate operations using 2:4 structured sparsity on matrix A
///     with dense matrices B, C, and D.
/// 
///     On gfx942, smfmac intrinsics support:
///       - M=N=16, K=32 and M=N=32, K=16 for f16 and bf16 sources
///       - M=N=16, K=64 and M=N=32, K=32 for i8 and fp8 sources
/// 
///     On gfx950, smfmac intrinsics additionally support:
///       - M=N=16, K=64 and M=N=32, K=32 for f16 and bf16 sources
///       - M=N=16, K=128 and M=N=32, K=64 for i8 and fp8 sources
/// 
///     The `sparseIdx` parameter contains packed indices identifying the positions
///     of non-zero elements in the 2:4 sparse matrix A. For 16-bit source data,
///     use `vector<4xi8>` (four 8-bit indices). For 8-bit source data, use
///     `vector<2xi16>` (two 16-bit indices).
/// 
///     The `cbsz` and `abid` parameters are repurposed to select the index set.
///     If `cbsz == 0`, then `abid[1:0]` selects which index set to use.
///     If `cbsz != 0`, then the very first is selected.
/// 
///     Example:
///     ```mlir
///       %0 = amdgpu.sparse_mfma 16x16x32 %matA * %matB + %matC sparse(%idx : vector<4xi8>)
///         : vector<4xf16>, vector<8xf16>, vector<4xf32>
/// 
///       %1 = amdgpu.sparse_mfma 16x16x64 %matA * %matB + %matC sparse(%idx : vector<2xi16>)
///         : vector<8xi8>, vector<16xi8>, vector<4xi32>
/// 
///       %2 = amdgpu.sparse_mfma 16x16x64 %matA * %matB + %matC sparse(%idx : vector<2xi16>)
///         { cbsz = 0 : i32, abid = 1 : i32 }
///         : vector<8xf8E4M3FNUZ>, vector<16xf8E4M3FNUZ>, vector<4xf32>
///     ```
class SparseMFMAOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// AMDGPU ds_swizzle op, bitmode variant
/// High-level wrapper on bitmode `rocdl.ds_swizzle` op, masks are represented
///     as separate fields so user won't need to do manual bitpacking.
/// 
///     Supports arbitrary int/float/vector types, which will be repacked to i32 and
///     one or more `rocdl.ds_swizzle` ops during lowering.
class SwizzleBitModeOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Load tensors from global memory to LDS.
/// Load tensors of up to five dimensions from global memory to LDS.
/// 
///     This operation was introduced in gfx1250.
class TensorLoadToLDSOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// Store tensors from LDS to global memory.
/// Store tensors of up to five dimensions from LDS to global memory.
/// 
///     This operation was introduced in gfx1250.
class TensorStoreFromLDSOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for CDNA Transpose Load instructions
/// The `amdgpu.transpose_load` op is a wrapper around the `ds_read_tr` instructions.
///     The transpose load op represents a subgroup load from LDS memory,
///     where the subgroup of threads collectively reads a matrix from the source
///     memref, with each thread reading a vector of the matrix, and gets a transposed matrix
///     in as the result. That is, each thread reads a vector of the col-major matrix at different
///     indices, and the thread's read result is a vector of the corresponding row of the transposed
///     matrix.
/// 
///     This op is a direct wrapper around the ROCDL `ds_read_tr` family intrinsics. Please refer
///     to the CDNA4 ISA documentation for more details about its exact semantics.
/// 
///     Format example:
///     ```
///     %0 = amdgpu.transpose_load %src[%srcIndices] : memref<128x256xf16> -> vector<4xf16>
///     ```
///     Operands:
///     * `$src`: LDS memref to read from.
///     * `$srcIndices`: indices into `$src` to read from for this thread.
///     * `$result`: target register this transpose load instruction will write to.
/// 
///     Note: Lowering is only supported on gfx950 and up.
class TransposeLoadOp;

} // namespace mlir::amdgpu
namespace mlir::amdgpu {

/// MLIR wrapper for wmma instructions
/// The `amdgpu.wmma` op is an MLIR wrapper around intrinsics for various `wmma`
///     instructions in the AMDGPU architecture, which perform matrix multiplication.
/// 
///     On gfx11/RDNA3, wmma intrinsics have M=N=K=16 dimensions.
/// 
///     On gfx12/RDNA4, wmma intrinsics have M=N=16 dimensions and support K=16 for
///     all element types, and K=32 for i4 sources.
/// 
///     On gfx1250, wmma intrinsics have M=N=16 and K dimensions of 4, 32, 64, or 128,
///     depending on the element types.
/// 
///     On gfx11/RDNA3, emitting f16->f16 (or bf16->bf16) wmma the output is a 16xf16
///     (or 16xbf16) vector containing only 8 valid values:
///       - If `subwordOffset` is 0, then the output is stored at indices 0, 2, 4, ..., 14.
///       - If `subwordOffset` is 1, then the output is stored at indices 1, 3, 5, ..., 15.
///     On gfx12/RDNA4 and gfx1250, the result is instead returned as vector where all
///     the values are valid and the `subwordOffset` must be `0`, as it cannot be used.
/// 
///     `unsignedA` and `unsignedB` flag that the `int8` LLVM inputs are unsigned.
/// 
///     The `clamp` flag is used to saturate the output of type T to `numeric_limits<T>::max()`
///     in case of overflow.
/// 
///     Example:
///     ```mlir
///       %0 = amdgpu.wmma 16x16x16 %matA * %matB + %matC : vector<8xf16>, vector<8xf16>, vector<8xf16>
/// 
///       %1 = amdgpu.wmma 16x16x64 %matD * %matE + %matF : vector<32xi8>, vector<8xf32>, vector<8xf32>
/// 
///       %2 = amdgpu.wmma 16x16x128 %matG * %matH + %matI : vector<64xf4E2M1FN>, vector<64xf4E2M1FN>, vector<8xf32>
/// 
///       %3 = amdgpu.wmma 16x16x4 %matJ * %matK + %matL : vector<2xf32>, vector<2xf32>, vector<8xf32>
///     ```
class WMMAOp;

} // namespace mlir::amdgpu
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::DPPOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DPPOpGenericAdaptorBase {
public:
  struct Properties {
    using bank_maskTy = ::mlir::IntegerAttr;
    bank_maskTy bank_mask;

    auto getBankMask() const {
      auto &propStorage = this->bank_mask;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setBankMask(const ::mlir::IntegerAttr &propValue) {
      this->bank_mask = propValue;
    }
    using bound_ctrlTy = ::mlir::BoolAttr;
    bound_ctrlTy bound_ctrl;

    auto getBoundCtrl() const {
      auto &propStorage = this->bound_ctrl;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundCtrl(const ::mlir::BoolAttr &propValue) {
      this->bound_ctrl = propValue;
    }
    using kindTy = ::mlir::amdgpu::DPPPermAttr;
    kindTy kind;

    auto getKind() const {
      auto &propStorage = this->kind;
      return ::llvm::cast<::mlir::amdgpu::DPPPermAttr>(propStorage);
    }
    void setKind(const ::mlir::amdgpu::DPPPermAttr &propValue) {
      this->kind = propValue;
    }
    using permArgumentTy = ::mlir::Attribute;
    permArgumentTy permArgument;

    auto getPermArgument() const {
      auto &propStorage = this->permArgument;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setPermArgument(const ::mlir::Attribute &propValue) {
      this->permArgument = propValue;
    }
    using row_maskTy = ::mlir::IntegerAttr;
    row_maskTy row_mask;

    auto getRowMask() const {
      auto &propStorage = this->row_mask;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setRowMask(const ::mlir::IntegerAttr &propValue) {
      this->row_mask = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bank_mask == this->bank_mask &&
        rhs.bound_ctrl == this->bound_ctrl &&
        rhs.kind == this->kind &&
        rhs.permArgument == this->permArgument &&
        rhs.row_mask == this->row_mask &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DPPOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.dpp", odsAttrs.getContext());
  }

  DPPOpGenericAdaptorBase(DPPOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::amdgpu::DPPPermAttr getKindAttr() {
    auto attr = ::llvm::cast<::mlir::amdgpu::DPPPermAttr>(getProperties().kind);
    return attr;
  }

  ::mlir::amdgpu::DPPPerm getKind();
  ::mlir::Attribute getPermArgumentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().permArgument);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getPermArgument();
  ::mlir::IntegerAttr getRowMaskAttr();
  uint32_t getRowMask();
  ::mlir::IntegerAttr getBankMaskAttr();
  uint32_t getBankMask();
  ::mlir::BoolAttr getBoundCtrlAttr();
  bool getBoundCtrl();
};

} // namespace detail
template <typename RangeT>
class DPPOpGenericAdaptor : public detail::DPPOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DPPOpGenericAdaptorBase;
  static constexpr int odsIndex_old = 0;
  static constexpr int odsIndex_src = 1;
public:
  DPPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DPPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DPPOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DPPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DPPOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DPPOpGenericAdaptor(RangeT values, const DPPOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DPPOp, typename = std::enable_if_t<std::is_same_v<LateInst, DPPOp>>>
  DPPOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOld() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DPPOpAdaptor : public DPPOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DPPOpGenericAdaptor::DPPOpGenericAdaptor;
  DPPOpAdaptor(DPPOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DPPOp : public ::mlir::Op<DPPOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameTypeOperands, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DPPOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DPPOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_old = 0;
  static constexpr int odsIndex_src = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bank_mask"), ::llvm::StringRef("bound_ctrl"), ::llvm::StringRef("kind"), ::llvm::StringRef("permArgument"), ::llvm::StringRef("row_mask")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBankMaskAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBankMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBoundCtrlAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBoundCtrlAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKindAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getPermArgumentAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getPermArgumentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRowMaskAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRowMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.dpp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::amdgpu::DPPPermAttr getKindAttr() {
    return ::llvm::cast<::mlir::amdgpu::DPPPermAttr>(getProperties().kind);
  }

  ::mlir::amdgpu::DPPPerm getKind();
  ::mlir::Attribute getPermArgumentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().permArgument);
  }

  ::std::optional<::mlir::Attribute> getPermArgument();
  ::mlir::IntegerAttr getRowMaskAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().row_mask);
  }

  uint32_t getRowMask();
  ::mlir::IntegerAttr getBankMaskAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().bank_mask);
  }

  uint32_t getBankMask();
  ::mlir::BoolAttr getBoundCtrlAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().bound_ctrl);
  }

  bool getBoundCtrl();
  void setKindAttr(::mlir::amdgpu::DPPPermAttr attr) {
    getProperties().kind = attr;
  }

  void setKind(::mlir::amdgpu::DPPPerm attrValue);
  void setPermArgumentAttr(::mlir::Attribute attr) {
    getProperties().permArgument = attr;
  }

  void setRowMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().row_mask = attr;
  }

  void setRowMask(uint32_t attrValue);
  void setBankMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().bank_mask = attr;
  }

  void setBankMask(uint32_t attrValue);
  void setBoundCtrlAttr(::mlir::BoolAttr attr) {
    getProperties().bound_ctrl = attr;
  }

  void setBoundCtrl(bool attrValue);
  ::mlir::Attribute removePermArgumentAttr() {
      auto attr = getProperties().permArgument;
      getProperties().permArgument = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPermAttr kind, /*optional*/::mlir::Attribute permArgument, ::mlir::IntegerAttr row_mask = nullptr, ::mlir::IntegerAttr bank_mask = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::amdgpu::DPPPerm kind, /*optional*/::mlir::Attribute permArgument, uint32_t row_mask = 0xf, uint32_t bank_mask = 0xf, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::DPPOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::ExtPackedFp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ExtPackedFp8OpGenericAdaptorBase {
public:
  struct Properties {
    using indexTy = ::mlir::IntegerAttr;
    indexTy index;

    auto getIndex() const {
      auto &propStorage = this->index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIndex(const ::mlir::IntegerAttr &propValue) {
      this->index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.index == this->index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtPackedFp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.ext_packed_fp8", odsAttrs.getContext());
  }

  ExtPackedFp8OpGenericAdaptorBase(ExtPackedFp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
    return attr;
  }

  uint32_t getIndex();
};

} // namespace detail
template <typename RangeT>
class ExtPackedFp8OpGenericAdaptor : public detail::ExtPackedFp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtPackedFp8OpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
public:
  ExtPackedFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtPackedFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtPackedFp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtPackedFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtPackedFp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtPackedFp8OpGenericAdaptor(RangeT values, const ExtPackedFp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtPackedFp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, ExtPackedFp8Op>>>
  ExtPackedFp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtPackedFp8OpAdaptor : public ExtPackedFp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtPackedFp8OpGenericAdaptor::ExtPackedFp8OpGenericAdaptor;
  ExtPackedFp8OpAdaptor(ExtPackedFp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtPackedFp8Op : public ::mlir::Op<ExtPackedFp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtPackedFp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtPackedFp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.ext_packed_fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
  }

  uint32_t getIndex();
  void setIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().index = attr;
  }

  void setIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::IntegerAttr index);
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::IntegerAttr index);
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::IntegerAttr index);
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::IntegerAttr index);
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, uint32_t index);
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, uint32_t index);
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, uint32_t index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, uint32_t index);
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, uint32_t index);
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, uint32_t index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtPackedFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtPackedFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::ExtPackedFp8Op)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::FatRawBufferCastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FatRawBufferCastOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using resetOffsetTy = ::mlir::UnitAttr;
    resetOffsetTy resetOffset;

    auto getResetOffset() const {
      auto &propStorage = this->resetOffset;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setResetOffset(const ::mlir::UnitAttr &propValue) {
      this->resetOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.resetOffset == this->resetOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FatRawBufferCastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.fat_raw_buffer_cast", odsAttrs.getContext());
  }

  FatRawBufferCastOpGenericAdaptorBase(FatRawBufferCastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::UnitAttr getResetOffsetAttr();
  bool getResetOffset();
};

} // namespace detail
template <typename RangeT>
class FatRawBufferCastOpGenericAdaptor : public detail::FatRawBufferCastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FatRawBufferCastOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_validBytes = 1;
  static constexpr int odsIndex_cacheSwizzleStride = 2;
public:
  FatRawBufferCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FatRawBufferCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FatRawBufferCastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FatRawBufferCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : FatRawBufferCastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FatRawBufferCastOpGenericAdaptor(RangeT values, const FatRawBufferCastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FatRawBufferCastOp, typename = std::enable_if_t<std::is_same_v<LateInst, FatRawBufferCastOp>>>
  FatRawBufferCastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValidBytes() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getCacheSwizzleStride() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FatRawBufferCastOpAdaptor : public FatRawBufferCastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FatRawBufferCastOpGenericAdaptor::FatRawBufferCastOpGenericAdaptor;
  FatRawBufferCastOpAdaptor(FatRawBufferCastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FatRawBufferCastOp : public ::mlir::Op<FatRawBufferCastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::MemRefType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::ReifyRankedShapedTypeOpInterface::Trait, ::mlir::ViewLikeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FatRawBufferCastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FatRawBufferCastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_validBytes = 1;
  static constexpr int odsIndex_cacheSwizzleStride = 2;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::InferTypeOpInterface::Trait<FatRawBufferCastOp>::refineReturnTypes;
  using ::mlir::ReifyRankedShapedTypeOpInterface::Trait<FatRawBufferCastOp>::reifyResultShapes;
  using ::mlir::ReifyRankedShapedTypeOpInterface::Trait<FatRawBufferCastOp>::reifyShapeOfResult;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("resetOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getResetOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getResetOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.fat_raw_buffer_cast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValidBytes() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCacheSwizzleStride() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getValidBytesMutable();
  ::mlir::MutableOperandRange getCacheSwizzleStrideMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::UnitAttr getResetOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().resetOffset);
  }

  bool getResetOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setResetOffsetAttr(::mlir::UnitAttr attr) {
    getProperties().resetOffset = attr;
  }

  void setResetOffset(bool attrValue);
  ::mlir::Attribute removeResetOffsetAttr() {
      auto attr = getProperties().resetOffset;
      getProperties().resetOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::UnitAttr resetOffset = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, /*optional*/::mlir::Value validBytes, /*optional*/::mlir::Value cacheSwizzleStride, bool boundsCheck = true, /*optional*/bool resetOffset = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FatRawBufferCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FatRawBufferCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::llvm::FailureOr<::mlir::OpFoldResult> reifyDimOfResult(::mlir::OpBuilder &builder, int resultIndex, int dim);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  Value getViewSource() { return getSource(); }
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::FatRawBufferCastOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::GatherToLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GatherToLDSOpGenericAdaptorBase {
public:
  struct Properties {
    using transferTypeTy = ::mlir::TypeAttr;
    transferTypeTy transferType;

    auto getTransferType() const {
      auto &propStorage = this->transferType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setTransferType(const ::mlir::TypeAttr &propValue) {
      this->transferType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.transferType == this->transferType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GatherToLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.gather_to_lds", odsAttrs.getContext());
  }

  GatherToLDSOpGenericAdaptorBase(GatherToLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getTransferTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().transferType);
    return attr;
  }

  ::mlir::Type getTransferType();
};

} // namespace detail
template <typename RangeT>
class GatherToLDSOpGenericAdaptor : public detail::GatherToLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GatherToLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_srcIndices = 1;
  static constexpr int odsIndex_dst = 2;
  static constexpr int odsIndex_dstIndices = 3;
public:
  GatherToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GatherToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GatherToLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GatherToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : GatherToLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GatherToLDSOpGenericAdaptor(RangeT values, const GatherToLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GatherToLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, GatherToLDSOp>>>
  GatherToLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getSrcIndices() {
    return getODSOperands(1);
  }

  ValueT getDst() {
    return (*getODSOperands(2).begin());
  }

  RangeT getDstIndices() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GatherToLDSOpAdaptor : public GatherToLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GatherToLDSOpGenericAdaptor::GatherToLDSOpGenericAdaptor;
  GatherToLDSOpAdaptor(GatherToLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GatherToLDSOp : public ::mlir::Op<GatherToLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GatherToLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GatherToLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_srcIndices = 1;
  static constexpr int odsIndex_dst = 2;
  static constexpr int odsIndex_dstIndices = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("transferType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTransferTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTransferTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.gather_to_lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getSrcIndices() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getDstIndices() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSrcIndicesMutable();
  ::mlir::OpOperand &getDstMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDstIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getTransferTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().transferType);
  }

  ::mlir::Type getTransferType();
  void setTransferTypeAttr(::mlir::TypeAttr attr) {
    getProperties().transferType = attr;
  }

  void setTransferType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::TypeAttr transferType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices, ::mlir::Value dst, ::mlir::ValueRange dstIndices, ::mlir::Type transferType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::GatherToLDSOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::LDSBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LDSBarrierOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LDSBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.lds_barrier", odsAttrs.getContext());
  }

  LDSBarrierOpGenericAdaptorBase(LDSBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class LDSBarrierOpGenericAdaptor : public detail::LDSBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LDSBarrierOpGenericAdaptorBase;
public:
  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LDSBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LDSBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LDSBarrierOpGenericAdaptor(RangeT values, const LDSBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LDSBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, LDSBarrierOp>>>
  LDSBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LDSBarrierOpAdaptor : public LDSBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LDSBarrierOpGenericAdaptor::LDSBarrierOpGenericAdaptor;
  LDSBarrierOpAdaptor(LDSBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LDSBarrierOp : public ::mlir::Op<LDSBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LDSBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LDSBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.lds_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::LDSBarrierOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MFMAOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MFMAOpGenericAdaptorBase {
public:
  struct Properties {
    using abidTy = ::mlir::IntegerAttr;
    abidTy abid;

    auto getAbid() const {
      auto &propStorage = this->abid;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAbid(const ::mlir::IntegerAttr &propValue) {
      this->abid = propValue;
    }
    using blgpTy = ::mlir::amdgpu::MFMAPermBAttr;
    blgpTy blgp;

    auto getBlgp() const {
      auto &propStorage = this->blgp;
      return ::llvm::dyn_cast_or_null<::mlir::amdgpu::MFMAPermBAttr>(propStorage);
    }
    void setBlgp(const ::mlir::amdgpu::MFMAPermBAttr &propValue) {
      this->blgp = propValue;
    }
    using blocksTy = ::mlir::IntegerAttr;
    blocksTy blocks;

    auto getBlocks() const {
      auto &propStorage = this->blocks;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setBlocks(const ::mlir::IntegerAttr &propValue) {
      this->blocks = propValue;
    }
    using cbszTy = ::mlir::IntegerAttr;
    cbszTy cbsz;

    auto getCbsz() const {
      auto &propStorage = this->cbsz;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setCbsz(const ::mlir::IntegerAttr &propValue) {
      this->cbsz = propValue;
    }
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using mTy = ::mlir::IntegerAttr;
    mTy m;

    auto getM() const {
      auto &propStorage = this->m;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setM(const ::mlir::IntegerAttr &propValue) {
      this->m = propValue;
    }
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    using negateATy = ::mlir::UnitAttr;
    negateATy negateA;

    auto getNegateA() const {
      auto &propStorage = this->negateA;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNegateA(const ::mlir::UnitAttr &propValue) {
      this->negateA = propValue;
    }
    using negateBTy = ::mlir::UnitAttr;
    negateBTy negateB;

    auto getNegateB() const {
      auto &propStorage = this->negateB;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNegateB(const ::mlir::UnitAttr &propValue) {
      this->negateB = propValue;
    }
    using negateCTy = ::mlir::UnitAttr;
    negateCTy negateC;

    auto getNegateC() const {
      auto &propStorage = this->negateC;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNegateC(const ::mlir::UnitAttr &propValue) {
      this->negateC = propValue;
    }
    using reducePrecisionTy = ::mlir::UnitAttr;
    reducePrecisionTy reducePrecision;

    auto getReducePrecision() const {
      auto &propStorage = this->reducePrecision;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setReducePrecision(const ::mlir::UnitAttr &propValue) {
      this->reducePrecision = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.abid == this->abid &&
        rhs.blgp == this->blgp &&
        rhs.blocks == this->blocks &&
        rhs.cbsz == this->cbsz &&
        rhs.k == this->k &&
        rhs.m == this->m &&
        rhs.n == this->n &&
        rhs.negateA == this->negateA &&
        rhs.negateB == this->negateB &&
        rhs.negateC == this->negateC &&
        rhs.reducePrecision == this->reducePrecision &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MFMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.mfma", odsAttrs.getContext());
  }

  MFMAOpGenericAdaptorBase(MFMAOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getMAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
    return attr;
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint32_t getK();
  ::mlir::IntegerAttr getBlocksAttr();
  uint32_t getBlocks();
  ::mlir::IntegerAttr getCbszAttr();
  uint32_t getCbsz();
  ::mlir::IntegerAttr getAbidAttr();
  uint32_t getAbid();
  ::mlir::amdgpu::MFMAPermBAttr getBlgpAttr();
  ::mlir::amdgpu::MFMAPermB getBlgp();
  ::mlir::UnitAttr getReducePrecisionAttr();
  bool getReducePrecision();
  ::mlir::UnitAttr getNegateAAttr();
  bool getNegateA();
  ::mlir::UnitAttr getNegateBAttr();
  bool getNegateB();
  ::mlir::UnitAttr getNegateCAttr();
  bool getNegateC();
};

} // namespace detail
template <typename RangeT>
class MFMAOpGenericAdaptor : public detail::MFMAOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MFMAOpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
public:
  MFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MFMAOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MFMAOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MFMAOpGenericAdaptor(RangeT values, const MFMAOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MFMAOp, typename = std::enable_if_t<std::is_same_v<LateInst, MFMAOp>>>
  MFMAOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDestC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MFMAOpAdaptor : public MFMAOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MFMAOpGenericAdaptor::MFMAOpGenericAdaptor;
  MFMAOpAdaptor(MFMAOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MFMAOp : public ::mlir::Op<MFMAOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MFMAOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MFMAOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("abid"), ::llvm::StringRef("blgp"), ::llvm::StringRef("blocks"), ::llvm::StringRef("cbsz"), ::llvm::StringRef("k"), ::llvm::StringRef("m"), ::llvm::StringRef("n"), ::llvm::StringRef("negateA"), ::llvm::StringRef("negateB"), ::llvm::StringRef("negateC"), ::llvm::StringRef("reducePrecision")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAbidAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAbidAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBlgpAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBlgpAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getBlocksAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getBlocksAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getCbszAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getCbszAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getMAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getMAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getNegateAAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getNegateAAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getNegateBAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getNegateBAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getNegateCAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getNegateCAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getReducePrecisionAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getReducePrecisionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.mfma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSourceB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDestD() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getMAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint32_t getK();
  ::mlir::IntegerAttr getBlocksAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().blocks);
  }

  uint32_t getBlocks();
  ::mlir::IntegerAttr getCbszAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().cbsz);
  }

  uint32_t getCbsz();
  ::mlir::IntegerAttr getAbidAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().abid);
  }

  uint32_t getAbid();
  ::mlir::amdgpu::MFMAPermBAttr getBlgpAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::amdgpu::MFMAPermBAttr>(getProperties().blgp);
  }

  ::mlir::amdgpu::MFMAPermB getBlgp();
  ::mlir::UnitAttr getReducePrecisionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().reducePrecision);
  }

  bool getReducePrecision();
  ::mlir::UnitAttr getNegateAAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().negateA);
  }

  bool getNegateA();
  ::mlir::UnitAttr getNegateBAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().negateB);
  }

  bool getNegateB();
  ::mlir::UnitAttr getNegateCAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().negateC);
  }

  bool getNegateC();
  void setMAttr(::mlir::IntegerAttr attr) {
    getProperties().m = attr;
  }

  void setM(uint32_t attrValue);
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint32_t attrValue);
  void setBlocksAttr(::mlir::IntegerAttr attr) {
    getProperties().blocks = attr;
  }

  void setBlocks(uint32_t attrValue);
  void setCbszAttr(::mlir::IntegerAttr attr) {
    getProperties().cbsz = attr;
  }

  void setCbsz(uint32_t attrValue);
  void setAbidAttr(::mlir::IntegerAttr attr) {
    getProperties().abid = attr;
  }

  void setAbid(uint32_t attrValue);
  void setBlgpAttr(::mlir::amdgpu::MFMAPermBAttr attr) {
    getProperties().blgp = attr;
  }

  void setBlgp(::mlir::amdgpu::MFMAPermB attrValue);
  void setReducePrecisionAttr(::mlir::UnitAttr attr) {
    getProperties().reducePrecision = attr;
  }

  void setReducePrecision(bool attrValue);
  void setNegateAAttr(::mlir::UnitAttr attr) {
    getProperties().negateA = attr;
  }

  void setNegateA(bool attrValue);
  void setNegateBAttr(::mlir::UnitAttr attr) {
    getProperties().negateB = attr;
  }

  void setNegateB(bool attrValue);
  void setNegateCAttr(::mlir::UnitAttr attr) {
    getProperties().negateC = attr;
  }

  void setNegateC(bool attrValue);
  ::mlir::Attribute removeReducePrecisionAttr() {
      auto attr = getProperties().reducePrecision;
      getProperties().reducePrecision = {};
      return attr;
  }

  ::mlir::Attribute removeNegateAAttr() {
      auto attr = getProperties().negateA;
      getProperties().negateA = {};
      return attr;
  }

  ::mlir::Attribute removeNegateBAttr() {
      auto attr = getProperties().negateB;
      getProperties().negateB = {};
      return attr;
  }

  ::mlir::Attribute removeNegateCAttr() {
      auto attr = getProperties().negateC;
      getProperties().negateC = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::IntegerAttr blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr, ::mlir::amdgpu::MFMAPermBAttr blgp = nullptr, /*optional*/::mlir::UnitAttr reducePrecision = nullptr, /*optional*/::mlir::UnitAttr negateA = nullptr, /*optional*/::mlir::UnitAttr negateB = nullptr, /*optional*/::mlir::UnitAttr negateC = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, uint32_t blocks, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t cbsz = 0, uint32_t abid = 0, ::mlir::amdgpu::MFMAPermB blgp = ::mlir::amdgpu::MFMAPermB::none, /*optional*/bool reducePrecision = false, /*optional*/bool negateA = false, /*optional*/bool negateB = false, /*optional*/bool negateC = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 11 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MFMAOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MakeDmaBaseOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MakeDmaBaseOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MakeDmaBaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.make_dma_base", odsAttrs.getContext());
  }

  MakeDmaBaseOpGenericAdaptorBase(MakeDmaBaseOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class MakeDmaBaseOpGenericAdaptor : public detail::MakeDmaBaseOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MakeDmaBaseOpGenericAdaptorBase;
  static constexpr int odsIndex_global = 0;
  static constexpr int odsIndex_global_indices = 1;
  static constexpr int odsIndex_lds = 2;
  static constexpr int odsIndex_lds_indices = 3;
public:
  MakeDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MakeDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MakeDmaBaseOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MakeDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : MakeDmaBaseOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MakeDmaBaseOpGenericAdaptor(RangeT values, const MakeDmaBaseOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MakeDmaBaseOp, typename = std::enable_if_t<std::is_same_v<LateInst, MakeDmaBaseOp>>>
  MakeDmaBaseOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getGlobal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getGlobalIndices() {
    return getODSOperands(1);
  }

  ValueT getLds() {
    return (*getODSOperands(2).begin());
  }

  RangeT getLdsIndices() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MakeDmaBaseOpAdaptor : public MakeDmaBaseOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MakeDmaBaseOpGenericAdaptor::MakeDmaBaseOpGenericAdaptor;
  MakeDmaBaseOpAdaptor(MakeDmaBaseOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MakeDmaBaseOp : public ::mlir::Op<MakeDmaBaseOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::amdgpu::TDMBaseType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MakeDmaBaseOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MakeDmaBaseOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_global = 0;
  static constexpr int odsIndex_global_indices = 1;
  static constexpr int odsIndex_lds = 2;
  static constexpr int odsIndex_lds_indices = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.make_dma_base");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getGlobal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getGlobalIndices() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::MemRefType> getLds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getLdsIndices() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getGlobalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getGlobalIndicesMutable();
  ::mlir::OpOperand &getLdsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getLdsIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMBaseType> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMBaseType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  static constexpr bool isGather() {
    return false;
  }
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MakeDmaBaseOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MakeDmaDescriptorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MakeDmaDescriptorOpGenericAdaptorBase {
public:
  struct Properties {
    using global_static_sizesTy = ::mlir::DenseI64ArrayAttr;
    global_static_sizesTy global_static_sizes;

    auto getGlobalStaticSizes() const {
      auto &propStorage = this->global_static_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setGlobalStaticSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->global_static_sizes = propValue;
    }
    using global_static_stridesTy = ::mlir::DenseI64ArrayAttr;
    global_static_stridesTy global_static_strides;

    auto getGlobalStaticStrides() const {
      auto &propStorage = this->global_static_strides;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setGlobalStaticStrides(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->global_static_strides = propValue;
    }
    using shared_static_sizesTy = ::mlir::DenseI64ArrayAttr;
    shared_static_sizesTy shared_static_sizes;

    auto getSharedStaticSizes() const {
      auto &propStorage = this->shared_static_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSharedStaticSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->shared_static_sizes = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 13>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.global_static_sizes == this->global_static_sizes &&
        rhs.global_static_strides == this->global_static_strides &&
        rhs.shared_static_sizes == this->shared_static_sizes &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MakeDmaDescriptorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.make_dma_descriptor", odsAttrs.getContext());
  }

  MakeDmaDescriptorOpGenericAdaptorBase(MakeDmaDescriptorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getGlobalStaticSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticSizes();
  ::mlir::DenseI64ArrayAttr getGlobalStaticStridesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_strides);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticStrides();
  ::mlir::DenseI64ArrayAttr getSharedStaticSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().shared_static_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getSharedStaticSizes();
};

} // namespace detail
template <typename RangeT>
class MakeDmaDescriptorOpGenericAdaptor : public detail::MakeDmaDescriptorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MakeDmaDescriptorOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_global_dynamic_sizes = 1;
  static constexpr int odsIndex_global_dynamic_strides = 2;
  static constexpr int odsIndex_shared_dynamic_sizes = 3;
  static constexpr int odsIndex_workgroup_mask = 4;
  static constexpr int odsIndex_early_timeout = 5;
  static constexpr int odsIndex_pad_amount = 6;
  static constexpr int odsIndex_pad_interval = 7;
  static constexpr int odsIndex_atomic_barrier_address = 8;
  static constexpr int odsIndex_atomic_barrier_indices = 9;
  static constexpr int odsIndex_global_increment = 10;
  static constexpr int odsIndex_lds_increment = 11;
  static constexpr int odsIndex_iteration_count = 12;
public:
  MakeDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MakeDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MakeDmaDescriptorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MakeDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : MakeDmaDescriptorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MakeDmaDescriptorOpGenericAdaptor(RangeT values, const MakeDmaDescriptorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MakeDmaDescriptorOp, typename = std::enable_if_t<std::is_same_v<LateInst, MakeDmaDescriptorOp>>>
  MakeDmaDescriptorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  RangeT getGlobalDynamicSizes() {
    return getODSOperands(1);
  }

  RangeT getGlobalDynamicStrides() {
    return getODSOperands(2);
  }

  RangeT getSharedDynamicSizes() {
    return getODSOperands(3);
  }

  ValueT getWorkgroupMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getEarlyTimeout() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPadAmount() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPadInterval() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getAtomicBarrierAddress() {
    auto operands = getODSOperands(8);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getAtomicBarrierIndices() {
    return getODSOperands(9);
  }

  ValueT getGlobalIncrement() {
    auto operands = getODSOperands(10);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getLdsIncrement() {
    auto operands = getODSOperands(11);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getIterationCount() {
    auto operands = getODSOperands(12);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MakeDmaDescriptorOpAdaptor : public MakeDmaDescriptorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MakeDmaDescriptorOpGenericAdaptor::MakeDmaDescriptorOpGenericAdaptor;
  MakeDmaDescriptorOpAdaptor(MakeDmaDescriptorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MakeDmaDescriptorOp : public ::mlir::Op<MakeDmaDescriptorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::amdgpu::TDMDescriptorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MakeDmaDescriptorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MakeDmaDescriptorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_global_dynamic_sizes = 1;
  static constexpr int odsIndex_global_dynamic_strides = 2;
  static constexpr int odsIndex_shared_dynamic_sizes = 3;
  static constexpr int odsIndex_workgroup_mask = 4;
  static constexpr int odsIndex_early_timeout = 5;
  static constexpr int odsIndex_pad_amount = 6;
  static constexpr int odsIndex_pad_interval = 7;
  static constexpr int odsIndex_atomic_barrier_address = 8;
  static constexpr int odsIndex_atomic_barrier_indices = 9;
  static constexpr int odsIndex_global_increment = 10;
  static constexpr int odsIndex_lds_increment = 11;
  static constexpr int odsIndex_iteration_count = 12;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("global_static_sizes"), ::llvm::StringRef("global_static_strides"), ::llvm::StringRef("shared_static_sizes"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGlobalStaticSizesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGlobalStaticSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getGlobalStaticStridesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getGlobalStaticStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSharedStaticSizesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSharedStaticSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.make_dma_descriptor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMBaseType> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMBaseType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getGlobalDynamicSizes() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getGlobalDynamicStrides() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getSharedDynamicSizes() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::VectorType> getWorkgroupMask() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::VectorType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getEarlyTimeout() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPadAmount() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPadInterval() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getAtomicBarrierAddress() {
    auto operands = getODSOperands(8);
    return operands.empty() ? ::mlir::TypedValue<::mlir::MemRefType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getAtomicBarrierIndices() {
    return getODSOperands(9);
  }

  ::mlir::TypedValue<::mlir::IndexType> getGlobalIncrement() {
    auto operands = getODSOperands(10);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IndexType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getLdsIncrement() {
    auto operands = getODSOperands(11);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getIterationCount() {
    auto operands = getODSOperands(12);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IndexType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getGlobalDynamicSizesMutable();
  ::mlir::MutableOperandRange getGlobalDynamicStridesMutable();
  ::mlir::MutableOperandRange getSharedDynamicSizesMutable();
  ::mlir::MutableOperandRange getWorkgroupMaskMutable();
  ::mlir::MutableOperandRange getEarlyTimeoutMutable();
  ::mlir::MutableOperandRange getPadAmountMutable();
  ::mlir::MutableOperandRange getPadIntervalMutable();
  ::mlir::MutableOperandRange getAtomicBarrierAddressMutable();
  ::mlir::MutableOperandRange getAtomicBarrierIndicesMutable();
  ::mlir::MutableOperandRange getGlobalIncrementMutable();
  ::mlir::MutableOperandRange getLdsIncrementMutable();
  ::mlir::MutableOperandRange getIterationCountMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType> getDesc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getGlobalStaticSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_sizes);
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticSizes();
  ::mlir::DenseI64ArrayAttr getGlobalStaticStridesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_strides);
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticStrides();
  ::mlir::DenseI64ArrayAttr getSharedStaticSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().shared_static_sizes);
  }

  ::llvm::ArrayRef<int64_t> getSharedStaticSizes();
  void setGlobalStaticSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().global_static_sizes = attr;
  }

  void setGlobalStaticSizes(::llvm::ArrayRef<int64_t> attrValue);
  void setGlobalStaticStridesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().global_static_strides = attr;
  }

  void setGlobalStaticStrides(::llvm::ArrayRef<int64_t> attrValue);
  void setSharedStaticSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().shared_static_sizes = attr;
  }

  void setSharedStaticSizes(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  int64_t getRank() {
    return getGlobalStaticSizes().size();
  }

  unsigned getElementTypeWidth() {
    return getBase().getType().getElementType().getIntOrFloatBitWidth();
  }

  SmallVector<OpFoldResult> getMixedGlobalSizes() {
    return getMixedValues(getGlobalStaticSizes(), getGlobalDynamicSizes(), getContext());
  }

  SmallVector<OpFoldResult> getMixedGlobalStrides() {
    return getMixedValues(getGlobalStaticStrides(), getGlobalDynamicStrides(), getContext());
  }

  SmallVector<OpFoldResult> getMixedSharedSizes() {
    return getMixedValues(getSharedStaticSizes(), getSharedDynamicSizes(), getContext());
  }


  static constexpr bool isGather() {
    return false;
  }
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MakeDmaDescriptorOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MakeGatherDmaBaseOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MakeGatherDmaBaseOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MakeGatherDmaBaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.make_gather_dma_base", odsAttrs.getContext());
  }

  MakeGatherDmaBaseOpGenericAdaptorBase(MakeGatherDmaBaseOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class MakeGatherDmaBaseOpGenericAdaptor : public detail::MakeGatherDmaBaseOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MakeGatherDmaBaseOpGenericAdaptorBase;
  static constexpr int odsIndex_global = 0;
  static constexpr int odsIndex_global_indices = 1;
  static constexpr int odsIndex_lds = 2;
  static constexpr int odsIndex_lds_indices = 3;
public:
  MakeGatherDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MakeGatherDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MakeGatherDmaBaseOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MakeGatherDmaBaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : MakeGatherDmaBaseOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MakeGatherDmaBaseOpGenericAdaptor(RangeT values, const MakeGatherDmaBaseOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MakeGatherDmaBaseOp, typename = std::enable_if_t<std::is_same_v<LateInst, MakeGatherDmaBaseOp>>>
  MakeGatherDmaBaseOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getGlobal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getGlobalIndices() {
    return getODSOperands(1);
  }

  ValueT getLds() {
    return (*getODSOperands(2).begin());
  }

  RangeT getLdsIndices() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MakeGatherDmaBaseOpAdaptor : public MakeGatherDmaBaseOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MakeGatherDmaBaseOpGenericAdaptor::MakeGatherDmaBaseOpGenericAdaptor;
  MakeGatherDmaBaseOpAdaptor(MakeGatherDmaBaseOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MakeGatherDmaBaseOp : public ::mlir::Op<MakeGatherDmaBaseOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::amdgpu::TDMGatherBaseType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MakeGatherDmaBaseOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MakeGatherDmaBaseOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_global = 0;
  static constexpr int odsIndex_global_indices = 1;
  static constexpr int odsIndex_lds = 2;
  static constexpr int odsIndex_lds_indices = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.make_gather_dma_base");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getGlobal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getGlobalIndices() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::MemRefType> getLds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getLdsIndices() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getGlobalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getGlobalIndicesMutable();
  ::mlir::OpOperand &getLdsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getLdsIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMGatherBaseType> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMGatherBaseType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeGatherDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeGatherDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type base, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeGatherDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static MakeGatherDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value global, ::mlir::ValueRange global_indices, ::mlir::Value lds, ::mlir::ValueRange lds_indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaBaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaBaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  static constexpr bool isGather() {
    return true;
  }
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MakeGatherDmaBaseOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MakeGatherDmaDescriptorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MakeGatherDmaDescriptorOpGenericAdaptorBase {
public:
  struct Properties {
    using global_static_sizesTy = ::mlir::DenseI64ArrayAttr;
    global_static_sizesTy global_static_sizes;

    auto getGlobalStaticSizes() const {
      auto &propStorage = this->global_static_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setGlobalStaticSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->global_static_sizes = propValue;
    }
    using global_static_stridesTy = ::mlir::DenseI64ArrayAttr;
    global_static_stridesTy global_static_strides;

    auto getGlobalStaticStrides() const {
      auto &propStorage = this->global_static_strides;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setGlobalStaticStrides(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->global_static_strides = propValue;
    }
    using shared_static_sizesTy = ::mlir::DenseI64ArrayAttr;
    shared_static_sizesTy shared_static_sizes;

    auto getSharedStaticSizes() const {
      auto &propStorage = this->shared_static_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSharedStaticSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->shared_static_sizes = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 14>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.global_static_sizes == this->global_static_sizes &&
        rhs.global_static_strides == this->global_static_strides &&
        rhs.shared_static_sizes == this->shared_static_sizes &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MakeGatherDmaDescriptorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.make_gather_dma_descriptor", odsAttrs.getContext());
  }

  MakeGatherDmaDescriptorOpGenericAdaptorBase(MakeGatherDmaDescriptorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getGlobalStaticSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticSizes();
  ::mlir::DenseI64ArrayAttr getGlobalStaticStridesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_strides);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticStrides();
  ::mlir::DenseI64ArrayAttr getSharedStaticSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().shared_static_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getSharedStaticSizes();
};

} // namespace detail
template <typename RangeT>
class MakeGatherDmaDescriptorOpGenericAdaptor : public detail::MakeGatherDmaDescriptorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MakeGatherDmaDescriptorOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_global_dynamic_sizes = 2;
  static constexpr int odsIndex_global_dynamic_strides = 3;
  static constexpr int odsIndex_shared_dynamic_sizes = 4;
  static constexpr int odsIndex_workgroup_mask = 5;
  static constexpr int odsIndex_early_timeout = 6;
  static constexpr int odsIndex_pad_amount = 7;
  static constexpr int odsIndex_pad_interval = 8;
  static constexpr int odsIndex_atomic_barrier_address = 9;
  static constexpr int odsIndex_atomic_barrier_indices = 10;
  static constexpr int odsIndex_global_increment = 11;
  static constexpr int odsIndex_lds_increment = 12;
  static constexpr int odsIndex_iteration_count = 13;
public:
  MakeGatherDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MakeGatherDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MakeGatherDmaDescriptorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MakeGatherDmaDescriptorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : MakeGatherDmaDescriptorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MakeGatherDmaDescriptorOpGenericAdaptor(RangeT values, const MakeGatherDmaDescriptorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MakeGatherDmaDescriptorOp, typename = std::enable_if_t<std::is_same_v<LateInst, MakeGatherDmaDescriptorOp>>>
  MakeGatherDmaDescriptorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  ValueT getIndices() {
    return (*getODSOperands(1).begin());
  }

  RangeT getGlobalDynamicSizes() {
    return getODSOperands(2);
  }

  RangeT getGlobalDynamicStrides() {
    return getODSOperands(3);
  }

  RangeT getSharedDynamicSizes() {
    return getODSOperands(4);
  }

  ValueT getWorkgroupMask() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getEarlyTimeout() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPadAmount() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getPadInterval() {
    auto operands = getODSOperands(8);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getAtomicBarrierAddress() {
    auto operands = getODSOperands(9);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getAtomicBarrierIndices() {
    return getODSOperands(10);
  }

  ValueT getGlobalIncrement() {
    auto operands = getODSOperands(11);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getLdsIncrement() {
    auto operands = getODSOperands(12);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getIterationCount() {
    auto operands = getODSOperands(13);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MakeGatherDmaDescriptorOpAdaptor : public MakeGatherDmaDescriptorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MakeGatherDmaDescriptorOpGenericAdaptor::MakeGatherDmaDescriptorOpGenericAdaptor;
  MakeGatherDmaDescriptorOpAdaptor(MakeGatherDmaDescriptorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MakeGatherDmaDescriptorOp : public ::mlir::Op<MakeGatherDmaDescriptorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::amdgpu::TDMDescriptorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MakeGatherDmaDescriptorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MakeGatherDmaDescriptorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_global_dynamic_sizes = 2;
  static constexpr int odsIndex_global_dynamic_strides = 3;
  static constexpr int odsIndex_shared_dynamic_sizes = 4;
  static constexpr int odsIndex_workgroup_mask = 5;
  static constexpr int odsIndex_early_timeout = 6;
  static constexpr int odsIndex_pad_amount = 7;
  static constexpr int odsIndex_pad_interval = 8;
  static constexpr int odsIndex_atomic_barrier_address = 9;
  static constexpr int odsIndex_atomic_barrier_indices = 10;
  static constexpr int odsIndex_global_increment = 11;
  static constexpr int odsIndex_lds_increment = 12;
  static constexpr int odsIndex_iteration_count = 13;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("global_static_sizes"), ::llvm::StringRef("global_static_strides"), ::llvm::StringRef("shared_static_sizes"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGlobalStaticSizesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGlobalStaticSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getGlobalStaticStridesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getGlobalStaticStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSharedStaticSizesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSharedStaticSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.make_gather_dma_descriptor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMGatherBaseType> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMGatherBaseType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getGlobalDynamicSizes() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getGlobalDynamicStrides() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getSharedDynamicSizes() {
    return getODSOperands(4);
  }

  ::mlir::TypedValue<::mlir::VectorType> getWorkgroupMask() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::VectorType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getEarlyTimeout() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPadAmount() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPadInterval() {
    auto operands = getODSOperands(8);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getAtomicBarrierAddress() {
    auto operands = getODSOperands(9);
    return operands.empty() ? ::mlir::TypedValue<::mlir::MemRefType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getAtomicBarrierIndices() {
    return getODSOperands(10);
  }

  ::mlir::TypedValue<::mlir::IndexType> getGlobalIncrement() {
    auto operands = getODSOperands(11);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IndexType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getLdsIncrement() {
    auto operands = getODSOperands(12);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getIterationCount() {
    auto operands = getODSOperands(13);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IndexType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getGlobalDynamicSizesMutable();
  ::mlir::MutableOperandRange getGlobalDynamicStridesMutable();
  ::mlir::MutableOperandRange getSharedDynamicSizesMutable();
  ::mlir::MutableOperandRange getWorkgroupMaskMutable();
  ::mlir::MutableOperandRange getEarlyTimeoutMutable();
  ::mlir::MutableOperandRange getPadAmountMutable();
  ::mlir::MutableOperandRange getPadIntervalMutable();
  ::mlir::MutableOperandRange getAtomicBarrierAddressMutable();
  ::mlir::MutableOperandRange getAtomicBarrierIndicesMutable();
  ::mlir::MutableOperandRange getGlobalIncrementMutable();
  ::mlir::MutableOperandRange getLdsIncrementMutable();
  ::mlir::MutableOperandRange getIterationCountMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType> getDesc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getGlobalStaticSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_sizes);
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticSizes();
  ::mlir::DenseI64ArrayAttr getGlobalStaticStridesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().global_static_strides);
  }

  ::llvm::ArrayRef<int64_t> getGlobalStaticStrides();
  ::mlir::DenseI64ArrayAttr getSharedStaticSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().shared_static_sizes);
  }

  ::llvm::ArrayRef<int64_t> getSharedStaticSizes();
  void setGlobalStaticSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().global_static_sizes = attr;
  }

  void setGlobalStaticSizes(::llvm::ArrayRef<int64_t> attrValue);
  void setGlobalStaticStridesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().global_static_strides = attr;
  }

  void setGlobalStaticStrides(::llvm::ArrayRef<int64_t> attrValue);
  void setSharedStaticSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().shared_static_sizes = attr;
  }

  void setSharedStaticSizes(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::mlir::DenseI64ArrayAttr global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::mlir::DenseI64ArrayAttr global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::mlir::DenseI64ArrayAttr shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value indices, ::mlir::ValueRange global_dynamic_sizes, ::llvm::ArrayRef<int64_t> global_static_sizes, ::mlir::ValueRange global_dynamic_strides, ::llvm::ArrayRef<int64_t> global_static_strides, ::mlir::ValueRange shared_dynamic_sizes, ::llvm::ArrayRef<int64_t> shared_static_sizes, /*optional*/::mlir::Value workgroup_mask, /*optional*/::mlir::Value early_timeout, /*optional*/::mlir::Value pad_amount, /*optional*/::mlir::Value pad_interval, /*optional*/::mlir::Value atomic_barrier_address, ::mlir::ValueRange atomic_barrier_indices, /*optional*/::mlir::Value global_increment, /*optional*/::mlir::Value lds_increment, /*optional*/::mlir::Value iteration_count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeGatherDmaDescriptorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  int64_t getRank() {
    return getGlobalStaticSizes().size();
  }

  unsigned getElementTypeWidth() {
    return getBase().getType().getElementType().getIntOrFloatBitWidth();
  }

  SmallVector<OpFoldResult> getMixedGlobalSizes() {
    return getMixedValues(getGlobalStaticSizes(), getGlobalDynamicSizes(), getContext());
  }

  SmallVector<OpFoldResult> getMixedGlobalStrides() {
    return getMixedValues(getGlobalStaticStrides(), getGlobalDynamicStrides(), getContext());
  }

  SmallVector<OpFoldResult> getMixedSharedSizes() {
    return getMixedValues(getSharedStaticSizes(), getSharedDynamicSizes(), getContext());
  }


  static constexpr bool isGather() {
    return true;
  }
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MakeGatherDmaDescriptorOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::MemoryCounterWaitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MemoryCounterWaitOpGenericAdaptorBase {
public:
  struct Properties {
    using dsTy = ::mlir::IntegerAttr;
    dsTy ds;

    auto getDs() const {
      auto &propStorage = this->ds;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDs(const ::mlir::IntegerAttr &propValue) {
      this->ds = propValue;
    }
    using expTy = ::mlir::IntegerAttr;
    expTy exp;

    auto getExp() const {
      auto &propStorage = this->exp;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setExp(const ::mlir::IntegerAttr &propValue) {
      this->exp = propValue;
    }
    using loadTy = ::mlir::IntegerAttr;
    loadTy load;

    auto getLoad() const {
      auto &propStorage = this->load;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setLoad(const ::mlir::IntegerAttr &propValue) {
      this->load = propValue;
    }
    using storeTy = ::mlir::IntegerAttr;
    storeTy store;

    auto getStore() const {
      auto &propStorage = this->store;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setStore(const ::mlir::IntegerAttr &propValue) {
      this->store = propValue;
    }
    using tensorTy = ::mlir::IntegerAttr;
    tensorTy tensor;

    auto getTensor() const {
      auto &propStorage = this->tensor;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setTensor(const ::mlir::IntegerAttr &propValue) {
      this->tensor = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.ds == this->ds &&
        rhs.exp == this->exp &&
        rhs.load == this->load &&
        rhs.store == this->store &&
        rhs.tensor == this->tensor &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MemoryCounterWaitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.memory_counter_wait", odsAttrs.getContext());
  }

  MemoryCounterWaitOpGenericAdaptorBase(MemoryCounterWaitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getLoadAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().load);
    return attr;
  }

  ::std::optional<uint32_t> getLoad();
  ::mlir::IntegerAttr getStoreAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().store);
    return attr;
  }

  ::std::optional<uint32_t> getStore();
  ::mlir::IntegerAttr getDsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().ds);
    return attr;
  }

  ::std::optional<uint32_t> getDs();
  ::mlir::IntegerAttr getExpAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().exp);
    return attr;
  }

  ::std::optional<uint32_t> getExp();
  ::mlir::IntegerAttr getTensorAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().tensor);
    return attr;
  }

  ::std::optional<uint32_t> getTensor();
};

} // namespace detail
template <typename RangeT>
class MemoryCounterWaitOpGenericAdaptor : public detail::MemoryCounterWaitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MemoryCounterWaitOpGenericAdaptorBase;
public:
  MemoryCounterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MemoryCounterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MemoryCounterWaitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MemoryCounterWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MemoryCounterWaitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MemoryCounterWaitOpGenericAdaptor(RangeT values, const MemoryCounterWaitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MemoryCounterWaitOp, typename = std::enable_if_t<std::is_same_v<LateInst, MemoryCounterWaitOp>>>
  MemoryCounterWaitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MemoryCounterWaitOpAdaptor : public MemoryCounterWaitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MemoryCounterWaitOpGenericAdaptor::MemoryCounterWaitOpGenericAdaptor;
  MemoryCounterWaitOpAdaptor(MemoryCounterWaitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MemoryCounterWaitOp : public ::mlir::Op<MemoryCounterWaitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MemoryCounterWaitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MemoryCounterWaitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("ds"), ::llvm::StringRef("exp"), ::llvm::StringRef("load"), ::llvm::StringRef("store"), ::llvm::StringRef("tensor")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getExpAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getExpAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getLoadAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getLoadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStoreAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStoreAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getTensorAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getTensorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.memory_counter_wait");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getLoadAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().load);
  }

  ::std::optional<uint32_t> getLoad();
  ::mlir::IntegerAttr getStoreAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().store);
  }

  ::std::optional<uint32_t> getStore();
  ::mlir::IntegerAttr getDsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().ds);
  }

  ::std::optional<uint32_t> getDs();
  ::mlir::IntegerAttr getExpAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().exp);
  }

  ::std::optional<uint32_t> getExp();
  ::mlir::IntegerAttr getTensorAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().tensor);
  }

  ::std::optional<uint32_t> getTensor();
  void setLoadAttr(::mlir::IntegerAttr attr) {
    getProperties().load = attr;
  }

  void setLoad(::std::optional<uint32_t> attrValue);
  void setStoreAttr(::mlir::IntegerAttr attr) {
    getProperties().store = attr;
  }

  void setStore(::std::optional<uint32_t> attrValue);
  void setDsAttr(::mlir::IntegerAttr attr) {
    getProperties().ds = attr;
  }

  void setDs(::std::optional<uint32_t> attrValue);
  void setExpAttr(::mlir::IntegerAttr attr) {
    getProperties().exp = attr;
  }

  void setExp(::std::optional<uint32_t> attrValue);
  void setTensorAttr(::mlir::IntegerAttr attr) {
    getProperties().tensor = attr;
  }

  void setTensor(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeLoadAttr() {
      auto attr = getProperties().load;
      getProperties().load = {};
      return attr;
  }

  ::mlir::Attribute removeStoreAttr() {
      auto attr = getProperties().store;
      getProperties().store = {};
      return attr;
  }

  ::mlir::Attribute removeDsAttr() {
      auto attr = getProperties().ds;
      getProperties().ds = {};
      return attr;
  }

  ::mlir::Attribute removeExpAttr() {
      auto attr = getProperties().exp;
      getProperties().exp = {};
      return attr;
  }

  ::mlir::Attribute removeTensorAttr() {
      auto attr = getProperties().tensor;
      getProperties().tensor = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static MemoryCounterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static MemoryCounterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static MemoryCounterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static MemoryCounterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::IntegerAttr load, /*optional*/::mlir::IntegerAttr store, /*optional*/::mlir::IntegerAttr ds, /*optional*/::mlir::IntegerAttr exp, /*optional*/::mlir::IntegerAttr tensor);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MemoryCounterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MemoryCounterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MemoryCounterWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MemoryCounterWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::MemoryCounterWaitOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::PackedScaledTruncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PackedScaledTruncOpGenericAdaptorBase {
public:
  struct Properties {
    using indexTy = ::mlir::IntegerAttr;
    indexTy index;

    auto getIndex() const {
      auto &propStorage = this->index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIndex(const ::mlir::IntegerAttr &propValue) {
      this->index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.index == this->index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PackedScaledTruncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.packed_scaled_trunc", odsAttrs.getContext());
  }

  PackedScaledTruncOpGenericAdaptorBase(PackedScaledTruncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
    return attr;
  }

  uint32_t getIndex();
};

} // namespace detail
template <typename RangeT>
class PackedScaledTruncOpGenericAdaptor : public detail::PackedScaledTruncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PackedScaledTruncOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_existing = 2;
public:
  PackedScaledTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PackedScaledTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PackedScaledTruncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PackedScaledTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PackedScaledTruncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PackedScaledTruncOpGenericAdaptor(RangeT values, const PackedScaledTruncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PackedScaledTruncOp, typename = std::enable_if_t<std::is_same_v<LateInst, PackedScaledTruncOp>>>
  PackedScaledTruncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  ValueT getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PackedScaledTruncOpAdaptor : public PackedScaledTruncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PackedScaledTruncOpGenericAdaptor::PackedScaledTruncOpGenericAdaptor;
  PackedScaledTruncOpAdaptor(PackedScaledTruncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PackedScaledTruncOp : public ::mlir::Op<PackedScaledTruncOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PackedScaledTruncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PackedScaledTruncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_existing = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.packed_scaled_trunc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExistingMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
  }

  uint32_t getIndex();
  void setIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().index = attr;
  }

  void setIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedScaledTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedScaledTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::PackedScaledTruncOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::PackedStochRoundFp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PackedStochRoundFp8OpGenericAdaptorBase {
public:
  struct Properties {
    using storeIndexTy = ::mlir::IntegerAttr;
    storeIndexTy storeIndex;

    auto getStoreIndex() const {
      auto &propStorage = this->storeIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setStoreIndex(const ::mlir::IntegerAttr &propValue) {
      this->storeIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.storeIndex == this->storeIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PackedStochRoundFp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.packed_stoch_round_fp8", odsAttrs.getContext());
  }

  PackedStochRoundFp8OpGenericAdaptorBase(PackedStochRoundFp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getStoreIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().storeIndex);
    return attr;
  }

  uint32_t getStoreIndex();
};

} // namespace detail
template <typename RangeT>
class PackedStochRoundFp8OpGenericAdaptor : public detail::PackedStochRoundFp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PackedStochRoundFp8OpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_stochiasticParam = 1;
  static constexpr int odsIndex_existing = 2;
public:
  PackedStochRoundFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PackedStochRoundFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PackedStochRoundFp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PackedStochRoundFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PackedStochRoundFp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PackedStochRoundFp8OpGenericAdaptor(RangeT values, const PackedStochRoundFp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PackedStochRoundFp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, PackedStochRoundFp8Op>>>
  PackedStochRoundFp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getStochiasticParam() {
    return (*getODSOperands(1).begin());
  }

  ValueT getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PackedStochRoundFp8OpAdaptor : public PackedStochRoundFp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using PackedStochRoundFp8OpGenericAdaptor::PackedStochRoundFp8OpGenericAdaptor;
  PackedStochRoundFp8OpAdaptor(PackedStochRoundFp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PackedStochRoundFp8Op : public ::mlir::Op<PackedStochRoundFp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PackedStochRoundFp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PackedStochRoundFp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_stochiasticParam = 1;
  static constexpr int odsIndex_existing = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("storeIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getStoreIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getStoreIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.packed_stoch_round_fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getStochiasticParam() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::VectorType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStochiasticParamMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExistingMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getStoreIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().storeIndex);
  }

  uint32_t getStoreIndex();
  void setStoreIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().storeIndex = attr;
  }

  void setStoreIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, ::mlir::IntegerAttr storeIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value stochiasticParam, uint32_t storeIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedStochRoundFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedStochRoundFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::PackedStochRoundFp8Op)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::PackedTrunc2xFp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PackedTrunc2xFp8OpGenericAdaptorBase {
public:
  struct Properties {
    using wordIndexTy = ::mlir::IntegerAttr;
    wordIndexTy wordIndex;

    auto getWordIndex() const {
      auto &propStorage = this->wordIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordIndex(const ::mlir::IntegerAttr &propValue) {
      this->wordIndex = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordIndex == this->wordIndex &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PackedTrunc2xFp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.packed_trunc_2xfp8", odsAttrs.getContext());
  }

  PackedTrunc2xFp8OpGenericAdaptorBase(PackedTrunc2xFp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordIndex);
    return attr;
  }

  uint32_t getWordIndex();
};

} // namespace detail
template <typename RangeT>
class PackedTrunc2xFp8OpGenericAdaptor : public detail::PackedTrunc2xFp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PackedTrunc2xFp8OpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_existing = 2;
public:
  PackedTrunc2xFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PackedTrunc2xFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PackedTrunc2xFp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PackedTrunc2xFp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : PackedTrunc2xFp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PackedTrunc2xFp8OpGenericAdaptor(RangeT values, const PackedTrunc2xFp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PackedTrunc2xFp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, PackedTrunc2xFp8Op>>>
  PackedTrunc2xFp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PackedTrunc2xFp8OpAdaptor : public PackedTrunc2xFp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using PackedTrunc2xFp8OpGenericAdaptor::PackedTrunc2xFp8OpGenericAdaptor;
  PackedTrunc2xFp8OpAdaptor(PackedTrunc2xFp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PackedTrunc2xFp8Op : public ::mlir::Op<PackedTrunc2xFp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PackedTrunc2xFp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PackedTrunc2xFp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_existing = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordIndex"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.packed_trunc_2xfp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSourceB() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::FloatType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getExisting() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::VectorType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSourceBMutable();
  ::mlir::MutableOperandRange getExistingMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordIndex);
  }

  uint32_t getWordIndex();
  void setWordIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().wordIndex = attr;
  }

  void setWordIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, ::mlir::IntegerAttr wordIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sourceA, /*optional*/::mlir::Value sourceB, uint32_t wordIndex, /*optional*/::mlir::Value existing);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedTrunc2xFp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackedTrunc2xFp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::PackedTrunc2xFp8Op)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::PermlaneSwapOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PermlaneSwapOpGenericAdaptorBase {
public:
  struct Properties {
    using bound_ctrlTy = ::mlir::BoolAttr;
    bound_ctrlTy bound_ctrl;

    auto getBoundCtrl() const {
      auto &propStorage = this->bound_ctrl;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundCtrl(const ::mlir::BoolAttr &propValue) {
      this->bound_ctrl = propValue;
    }
    using fetch_inactiveTy = ::mlir::BoolAttr;
    fetch_inactiveTy fetch_inactive;

    auto getFetchInactive() const {
      auto &propStorage = this->fetch_inactive;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setFetchInactive(const ::mlir::BoolAttr &propValue) {
      this->fetch_inactive = propValue;
    }
    using row_lengthTy = ::mlir::IntegerAttr;
    row_lengthTy row_length;

    auto getRowLength() const {
      auto &propStorage = this->row_length;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setRowLength(const ::mlir::IntegerAttr &propValue) {
      this->row_length = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bound_ctrl == this->bound_ctrl &&
        rhs.fetch_inactive == this->fetch_inactive &&
        rhs.row_length == this->row_length &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PermlaneSwapOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.permlane_swap", odsAttrs.getContext());
  }

  PermlaneSwapOpGenericAdaptorBase(PermlaneSwapOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getRowLengthAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().row_length);
    return attr;
  }

  uint32_t getRowLength();
  ::mlir::BoolAttr getFetchInactiveAttr();
  bool getFetchInactive();
  ::mlir::BoolAttr getBoundCtrlAttr();
  bool getBoundCtrl();
};

} // namespace detail
template <typename RangeT>
class PermlaneSwapOpGenericAdaptor : public detail::PermlaneSwapOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PermlaneSwapOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  PermlaneSwapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PermlaneSwapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PermlaneSwapOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PermlaneSwapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PermlaneSwapOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PermlaneSwapOpGenericAdaptor(RangeT values, const PermlaneSwapOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PermlaneSwapOp, typename = std::enable_if_t<std::is_same_v<LateInst, PermlaneSwapOp>>>
  PermlaneSwapOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PermlaneSwapOpAdaptor : public PermlaneSwapOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PermlaneSwapOpGenericAdaptor::PermlaneSwapOpGenericAdaptor;
  PermlaneSwapOpAdaptor(PermlaneSwapOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PermlaneSwapOp : public ::mlir::Op<PermlaneSwapOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PermlaneSwapOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PermlaneSwapOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bound_ctrl"), ::llvm::StringRef("fetch_inactive"), ::llvm::StringRef("row_length")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundCtrlAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundCtrlAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFetchInactiveAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFetchInactiveAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getRowLengthAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getRowLengthAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.permlane_swap");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getRowLengthAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().row_length);
  }

  uint32_t getRowLength();
  ::mlir::BoolAttr getFetchInactiveAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().fetch_inactive);
  }

  bool getFetchInactive();
  ::mlir::BoolAttr getBoundCtrlAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().bound_ctrl);
  }

  bool getBoundCtrl();
  void setRowLengthAttr(::mlir::IntegerAttr attr) {
    getProperties().row_length = attr;
  }

  void setRowLength(uint32_t attrValue);
  void setFetchInactiveAttr(::mlir::BoolAttr attr) {
    getProperties().fetch_inactive = attr;
  }

  void setFetchInactive(bool attrValue);
  void setBoundCtrlAttr(::mlir::BoolAttr attr) {
    getProperties().bound_ctrl = attr;
  }

  void setBoundCtrl(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr row_length, ::mlir::BoolAttr fetch_inactive = nullptr, ::mlir::BoolAttr bound_ctrl = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t row_length, bool fetch_inactive = false, bool bound_ctrl = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PermlaneSwapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PermlaneSwapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::PermlaneSwapOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferAtomicCmpswapOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferAtomicCmpswapOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferAtomicCmpswapOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_atomic_cmpswap", odsAttrs.getContext());
  }

  RawBufferAtomicCmpswapOpGenericAdaptorBase(RawBufferAtomicCmpswapOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferAtomicCmpswapOpGenericAdaptor : public detail::RawBufferAtomicCmpswapOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferAtomicCmpswapOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_cmp = 1;
  static constexpr int odsIndex_memref = 2;
  static constexpr int odsIndex_indices = 3;
  static constexpr int odsIndex_sgprOffset = 4;
public:
  RawBufferAtomicCmpswapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferAtomicCmpswapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferAtomicCmpswapOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferAtomicCmpswapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferAtomicCmpswapOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferAtomicCmpswapOpGenericAdaptor(RangeT values, const RawBufferAtomicCmpswapOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferAtomicCmpswapOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferAtomicCmpswapOp>>>
  RawBufferAtomicCmpswapOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getCmp() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(2).begin());
  }

  RangeT getIndices() {
    return getODSOperands(3);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferAtomicCmpswapOpAdaptor : public RawBufferAtomicCmpswapOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferAtomicCmpswapOpGenericAdaptor::RawBufferAtomicCmpswapOpGenericAdaptor;
  RawBufferAtomicCmpswapOpAdaptor(RawBufferAtomicCmpswapOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferAtomicCmpswapOp : public ::mlir::Op<RawBufferAtomicCmpswapOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferAtomicCmpswapOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferAtomicCmpswapOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_cmp = 1;
  static constexpr int odsIndex_memref = 2;
  static constexpr int odsIndex_indices = 3;
  static constexpr int odsIndex_sgprOffset = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_atomic_cmpswap");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getCmp() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCmpMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type value, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value cmp, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicCmpswapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferAtomicCmpswapOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferAtomicFaddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferAtomicFaddOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferAtomicFaddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_atomic_fadd", odsAttrs.getContext());
  }

  RawBufferAtomicFaddOpGenericAdaptorBase(RawBufferAtomicFaddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferAtomicFaddOpGenericAdaptor : public detail::RawBufferAtomicFaddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferAtomicFaddOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
public:
  RawBufferAtomicFaddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferAtomicFaddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferAtomicFaddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferAtomicFaddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferAtomicFaddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferAtomicFaddOpGenericAdaptor(RangeT values, const RawBufferAtomicFaddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferAtomicFaddOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferAtomicFaddOp>>>
  RawBufferAtomicFaddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferAtomicFaddOpAdaptor : public RawBufferAtomicFaddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferAtomicFaddOpGenericAdaptor::RawBufferAtomicFaddOpGenericAdaptor;
  RawBufferAtomicFaddOpAdaptor(RawBufferAtomicFaddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferAtomicFaddOp : public ::mlir::Op<RawBufferAtomicFaddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferAtomicFaddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferAtomicFaddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_atomic_fadd");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicFaddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicFaddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferAtomicFaddOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferAtomicFmaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferAtomicFmaxOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferAtomicFmaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_atomic_fmax", odsAttrs.getContext());
  }

  RawBufferAtomicFmaxOpGenericAdaptorBase(RawBufferAtomicFmaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferAtomicFmaxOpGenericAdaptor : public detail::RawBufferAtomicFmaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferAtomicFmaxOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
public:
  RawBufferAtomicFmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferAtomicFmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferAtomicFmaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferAtomicFmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferAtomicFmaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferAtomicFmaxOpGenericAdaptor(RangeT values, const RawBufferAtomicFmaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferAtomicFmaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferAtomicFmaxOp>>>
  RawBufferAtomicFmaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferAtomicFmaxOpAdaptor : public RawBufferAtomicFmaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferAtomicFmaxOpGenericAdaptor::RawBufferAtomicFmaxOpGenericAdaptor;
  RawBufferAtomicFmaxOpAdaptor(RawBufferAtomicFmaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferAtomicFmaxOp : public ::mlir::Op<RawBufferAtomicFmaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferAtomicFmaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferAtomicFmaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_atomic_fmax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicFmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicFmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferAtomicFmaxOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferAtomicSmaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferAtomicSmaxOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferAtomicSmaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_atomic_smax", odsAttrs.getContext());
  }

  RawBufferAtomicSmaxOpGenericAdaptorBase(RawBufferAtomicSmaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferAtomicSmaxOpGenericAdaptor : public detail::RawBufferAtomicSmaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferAtomicSmaxOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
public:
  RawBufferAtomicSmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferAtomicSmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferAtomicSmaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferAtomicSmaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferAtomicSmaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferAtomicSmaxOpGenericAdaptor(RangeT values, const RawBufferAtomicSmaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferAtomicSmaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferAtomicSmaxOp>>>
  RawBufferAtomicSmaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferAtomicSmaxOpAdaptor : public RawBufferAtomicSmaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferAtomicSmaxOpGenericAdaptor::RawBufferAtomicSmaxOpGenericAdaptor;
  RawBufferAtomicSmaxOpAdaptor(RawBufferAtomicSmaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferAtomicSmaxOp : public ::mlir::Op<RawBufferAtomicSmaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferAtomicSmaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferAtomicSmaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_atomic_smax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicSmaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicSmaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferAtomicSmaxOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferAtomicUminOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferAtomicUminOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferAtomicUminOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_atomic_umin", odsAttrs.getContext());
  }

  RawBufferAtomicUminOpGenericAdaptorBase(RawBufferAtomicUminOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferAtomicUminOpGenericAdaptor : public detail::RawBufferAtomicUminOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferAtomicUminOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
public:
  RawBufferAtomicUminOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferAtomicUminOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferAtomicUminOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferAtomicUminOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferAtomicUminOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferAtomicUminOpGenericAdaptor(RangeT values, const RawBufferAtomicUminOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferAtomicUminOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferAtomicUminOp>>>
  RawBufferAtomicUminOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferAtomicUminOpAdaptor : public RawBufferAtomicUminOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferAtomicUminOpGenericAdaptor::RawBufferAtomicUminOpGenericAdaptor;
  RawBufferAtomicUminOpAdaptor(RawBufferAtomicUminOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferAtomicUminOp : public ::mlir::Op<RawBufferAtomicUminOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferAtomicUminOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferAtomicUminOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_atomic_umin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicUminOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferAtomicUminOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferAtomicUminOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferLoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferLoadOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_load", odsAttrs.getContext());
  }

  RawBufferLoadOpGenericAdaptorBase(RawBufferLoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferLoadOpGenericAdaptor : public detail::RawBufferLoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferLoadOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_sgprOffset = 2;
public:
  RawBufferLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferLoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferLoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferLoadOpGenericAdaptor(RangeT values, const RawBufferLoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferLoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferLoadOp>>>
  RawBufferLoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getIndices() {
    return getODSOperands(1);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferLoadOpAdaptor : public RawBufferLoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferLoadOpGenericAdaptor::RawBufferLoadOpGenericAdaptor;
  RawBufferLoadOpAdaptor(RawBufferLoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferLoadOp : public ::mlir::Op<RawBufferLoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferLoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferLoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_sgprOffset = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferLoadOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::RawBufferStoreOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class RawBufferStoreOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsCheckTy = ::mlir::BoolAttr;
    boundsCheckTy boundsCheck;

    auto getBoundsCheck() const {
      auto &propStorage = this->boundsCheck;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setBoundsCheck(const ::mlir::BoolAttr &propValue) {
      this->boundsCheck = propValue;
    }
    using indexOffsetTy = ::mlir::IntegerAttr;
    indexOffsetTy indexOffset;

    auto getIndexOffset() const {
      auto &propStorage = this->indexOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndexOffset(const ::mlir::IntegerAttr &propValue) {
      this->indexOffset = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.boundsCheck == this->boundsCheck &&
        rhs.indexOffset == this->indexOffset &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RawBufferStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.raw_buffer_store", odsAttrs.getContext());
  }

  RawBufferStoreOpGenericAdaptorBase(RawBufferStoreOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getBoundsCheckAttr();
  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
    return attr;
  }

  ::std::optional<uint32_t> getIndexOffset();
};

} // namespace detail
template <typename RangeT>
class RawBufferStoreOpGenericAdaptor : public detail::RawBufferStoreOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RawBufferStoreOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
public:
  RawBufferStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RawBufferStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RawBufferStoreOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RawBufferStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : RawBufferStoreOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RawBufferStoreOpGenericAdaptor(RangeT values, const RawBufferStoreOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RawBufferStoreOp, typename = std::enable_if_t<std::is_same_v<LateInst, RawBufferStoreOp>>>
  RawBufferStoreOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  ValueT getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RawBufferStoreOpAdaptor : public RawBufferStoreOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RawBufferStoreOpGenericAdaptor::RawBufferStoreOpGenericAdaptor;
  RawBufferStoreOpAdaptor(RawBufferStoreOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RawBufferStoreOp : public ::mlir::Op<RawBufferStoreOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RawBufferStoreOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RawBufferStoreOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  static constexpr int odsIndex_memref = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_sgprOffset = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("boundsCheck"), ::llvm::StringRef("indexOffset"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsCheckAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsCheckAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndexOffsetAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndexOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.raw_buffer_store");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSgprOffset() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getSgprOffsetMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getBoundsCheckAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().boundsCheck);
  }

  bool getBoundsCheck();
  ::mlir::IntegerAttr getIndexOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().indexOffset);
  }

  ::std::optional<uint32_t> getIndexOffset();
  void setBoundsCheckAttr(::mlir::BoolAttr attr) {
    getProperties().boundsCheck = attr;
  }

  void setBoundsCheck(bool attrValue);
  void setIndexOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().indexOffset = attr;
  }

  void setIndexOffset(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeIndexOffsetAttr() {
      auto attr = getProperties().indexOffset;
      getProperties().indexOffset = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, ::mlir::BoolAttr boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value memref, ::mlir::ValueRange indices, bool boundsCheck, /*optional*/::mlir::IntegerAttr indexOffset, /*optional*/::mlir::Value sgprOffset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static RawBufferStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::RawBufferStoreOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::ScaledExtPackedMatrixOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ScaledExtPackedMatrixOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using firstScaleByteTy = ::mlir::IntegerAttr;
    firstScaleByteTy firstScaleByte;

    auto getFirstScaleByte() const {
      auto &propStorage = this->firstScaleByte;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFirstScaleByte(const ::mlir::IntegerAttr &propValue) {
      this->firstScaleByte = propValue;
    }
    using firstScaleLaneTy = ::mlir::IntegerAttr;
    firstScaleLaneTy firstScaleLane;

    auto getFirstScaleLane() const {
      auto &propStorage = this->firstScaleLane;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFirstScaleLane(const ::mlir::IntegerAttr &propValue) {
      this->firstScaleLane = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        rhs.firstScaleByte == this->firstScaleByte &&
        rhs.firstScaleLane == this->firstScaleLane &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ScaledExtPackedMatrixOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.scaled_ext_packed_matrix", odsAttrs.getContext());
  }

  ScaledExtPackedMatrixOpGenericAdaptorBase(ScaledExtPackedMatrixOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getFirstScaleLaneAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().firstScaleLane);
    return attr;
  }

  uint32_t getFirstScaleLane();
  ::mlir::IntegerAttr getFirstScaleByteAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().firstScaleByte);
    return attr;
  }

  uint32_t getFirstScaleByte();
};

} // namespace detail
template <typename RangeT>
class ScaledExtPackedMatrixOpGenericAdaptor : public detail::ScaledExtPackedMatrixOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ScaledExtPackedMatrixOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
public:
  ScaledExtPackedMatrixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ScaledExtPackedMatrixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ScaledExtPackedMatrixOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ScaledExtPackedMatrixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ScaledExtPackedMatrixOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ScaledExtPackedMatrixOpGenericAdaptor(RangeT values, const ScaledExtPackedMatrixOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ScaledExtPackedMatrixOp, typename = std::enable_if_t<std::is_same_v<LateInst, ScaledExtPackedMatrixOp>>>
  ScaledExtPackedMatrixOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ScaledExtPackedMatrixOpAdaptor : public ScaledExtPackedMatrixOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ScaledExtPackedMatrixOpGenericAdaptor::ScaledExtPackedMatrixOpGenericAdaptor;
  ScaledExtPackedMatrixOpAdaptor(ScaledExtPackedMatrixOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ScaledExtPackedMatrixOp : public ::mlir::Op<ScaledExtPackedMatrixOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ScaledExtPackedMatrixOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ScaledExtPackedMatrixOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize"), ::llvm::StringRef("firstScaleByte"), ::llvm::StringRef("firstScaleLane")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFirstScaleByteAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFirstScaleByteAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFirstScaleLaneAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFirstScaleLaneAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.scaled_ext_packed_matrix");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getFirstScaleLaneAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().firstScaleLane);
  }

  uint32_t getFirstScaleLane();
  ::mlir::IntegerAttr getFirstScaleByteAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().firstScaleByte);
  }

  uint32_t getFirstScaleByte();
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  void setFirstScaleLaneAttr(::mlir::IntegerAttr attr) {
    getProperties().firstScaleLane = attr;
  }

  void setFirstScaleLane(uint32_t attrValue);
  void setFirstScaleByteAttr(::mlir::IntegerAttr attr) {
    getProperties().firstScaleByte = attr;
  }

  void setFirstScaleByte(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr firstScaleLane, ::mlir::IntegerAttr firstScaleByte);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t blockSize, uint32_t firstScaleLane, uint32_t firstScaleByte);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledExtPackedMatrixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledExtPackedMatrixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::ScaledExtPackedMatrixOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::ScaledExtPackedOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ScaledExtPackedOpGenericAdaptorBase {
public:
  struct Properties {
    using indexTy = ::mlir::IntegerAttr;
    indexTy index;

    auto getIndex() const {
      auto &propStorage = this->index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIndex(const ::mlir::IntegerAttr &propValue) {
      this->index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.index == this->index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ScaledExtPackedOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.scaled_ext_packed", odsAttrs.getContext());
  }

  ScaledExtPackedOpGenericAdaptorBase(ScaledExtPackedOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
    return attr;
  }

  uint32_t getIndex();
};

} // namespace detail
template <typename RangeT>
class ScaledExtPackedOpGenericAdaptor : public detail::ScaledExtPackedOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ScaledExtPackedOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
public:
  ScaledExtPackedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ScaledExtPackedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ScaledExtPackedOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ScaledExtPackedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ScaledExtPackedOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ScaledExtPackedOpGenericAdaptor(RangeT values, const ScaledExtPackedOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ScaledExtPackedOp, typename = std::enable_if_t<std::is_same_v<LateInst, ScaledExtPackedOp>>>
  ScaledExtPackedOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ScaledExtPackedOpAdaptor : public ScaledExtPackedOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ScaledExtPackedOpGenericAdaptor::ScaledExtPackedOpGenericAdaptor;
  ScaledExtPackedOpAdaptor(ScaledExtPackedOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ScaledExtPackedOp : public ::mlir::Op<ScaledExtPackedOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ScaledExtPackedOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ScaledExtPackedOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.scaled_ext_packed");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
  }

  uint32_t getIndex();
  void setIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().index = attr;
  }

  void setIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value scale, uint32_t index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledExtPackedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledExtPackedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::ScaledExtPackedOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::ScaledMFMAOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ScaledMFMAOpGenericAdaptorBase {
public:
  struct Properties {
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using mTy = ::mlir::IntegerAttr;
    mTy m;

    auto getM() const {
      auto &propStorage = this->m;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setM(const ::mlir::IntegerAttr &propValue) {
      this->m = propValue;
    }
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    using scalesIdxATy = ::mlir::IntegerAttr;
    scalesIdxATy scalesIdxA;

    auto getScalesIdxA() const {
      auto &propStorage = this->scalesIdxA;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScalesIdxA(const ::mlir::IntegerAttr &propValue) {
      this->scalesIdxA = propValue;
    }
    using scalesIdxBTy = ::mlir::IntegerAttr;
    scalesIdxBTy scalesIdxB;

    auto getScalesIdxB() const {
      auto &propStorage = this->scalesIdxB;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScalesIdxB(const ::mlir::IntegerAttr &propValue) {
      this->scalesIdxB = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.k == this->k &&
        rhs.m == this->m &&
        rhs.n == this->n &&
        rhs.scalesIdxA == this->scalesIdxA &&
        rhs.scalesIdxB == this->scalesIdxB &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ScaledMFMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.scaled_mfma", odsAttrs.getContext());
  }

  ScaledMFMAOpGenericAdaptorBase(ScaledMFMAOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getMAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
    return attr;
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint32_t getK();
  ::mlir::IntegerAttr getScalesIdxAAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scalesIdxA);
    return attr;
  }

  uint32_t getScalesIdxA();
  ::mlir::IntegerAttr getScalesIdxBAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scalesIdxB);
    return attr;
  }

  uint32_t getScalesIdxB();
};

} // namespace detail
template <typename RangeT>
class ScaledMFMAOpGenericAdaptor : public detail::ScaledMFMAOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ScaledMFMAOpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_scalesA = 3;
  static constexpr int odsIndex_scalesB = 4;
public:
  ScaledMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ScaledMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ScaledMFMAOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ScaledMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ScaledMFMAOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ScaledMFMAOpGenericAdaptor(RangeT values, const ScaledMFMAOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ScaledMFMAOp, typename = std::enable_if_t<std::is_same_v<LateInst, ScaledMFMAOp>>>
  ScaledMFMAOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDestC() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScalesA() {
    return (*getODSOperands(3).begin());
  }

  ValueT getScalesB() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ScaledMFMAOpAdaptor : public ScaledMFMAOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ScaledMFMAOpGenericAdaptor::ScaledMFMAOpGenericAdaptor;
  ScaledMFMAOpAdaptor(ScaledMFMAOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ScaledMFMAOp : public ::mlir::Op<ScaledMFMAOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ScaledMFMAOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ScaledMFMAOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_scalesA = 3;
  static constexpr int odsIndex_scalesB = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("k"), ::llvm::StringRef("m"), ::llvm::StringRef("n"), ::llvm::StringRef("scalesIdxA"), ::llvm::StringRef("scalesIdxB")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getScalesIdxAAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getScalesIdxAAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getScalesIdxBAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getScalesIdxBAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.scaled_mfma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSourceB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getScalesA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getScalesB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScalesAMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScalesBMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDestD() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getMAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint32_t getK();
  ::mlir::IntegerAttr getScalesIdxAAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scalesIdxA);
  }

  uint32_t getScalesIdxA();
  ::mlir::IntegerAttr getScalesIdxBAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scalesIdxB);
  }

  uint32_t getScalesIdxB();
  void setMAttr(::mlir::IntegerAttr attr) {
    getProperties().m = attr;
  }

  void setM(uint32_t attrValue);
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint32_t attrValue);
  void setScalesIdxAAttr(::mlir::IntegerAttr attr) {
    getProperties().scalesIdxA = attr;
  }

  void setScalesIdxA(uint32_t attrValue);
  void setScalesIdxBAttr(::mlir::IntegerAttr attr) {
    getProperties().scalesIdxB = attr;
  }

  void setScalesIdxB(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, ::mlir::IntegerAttr scalesIdxA, ::mlir::IntegerAttr scalesIdxB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scalesA, ::mlir::Value scalesB, uint32_t scalesIdxA, uint32_t scalesIdxB);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::ScaledMFMAOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::ScaledWMMAOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ScaledWMMAOpGenericAdaptorBase {
public:
  struct Properties {
    using a_first_scale_laneTy = ::mlir::IntegerAttr;
    a_first_scale_laneTy a_first_scale_lane;

    auto getAFirstScaleLane() const {
      auto &propStorage = this->a_first_scale_lane;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAFirstScaleLane(const ::mlir::IntegerAttr &propValue) {
      this->a_first_scale_lane = propValue;
    }
    using b_first_scale_laneTy = ::mlir::IntegerAttr;
    b_first_scale_laneTy b_first_scale_lane;

    auto getBFirstScaleLane() const {
      auto &propStorage = this->b_first_scale_lane;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBFirstScaleLane(const ::mlir::IntegerAttr &propValue) {
      this->b_first_scale_lane = propValue;
    }
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using mTy = ::mlir::IntegerAttr;
    mTy m;

    auto getM() const {
      auto &propStorage = this->m;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setM(const ::mlir::IntegerAttr &propValue) {
      this->m = propValue;
    }
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.a_first_scale_lane == this->a_first_scale_lane &&
        rhs.b_first_scale_lane == this->b_first_scale_lane &&
        rhs.k == this->k &&
        rhs.m == this->m &&
        rhs.n == this->n &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ScaledWMMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.scaled_wmma", odsAttrs.getContext());
  }

  ScaledWMMAOpGenericAdaptorBase(ScaledWMMAOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getMAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
    return attr;
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint32_t getK();
  ::mlir::IntegerAttr getAFirstScaleLaneAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().a_first_scale_lane);
    return attr;
  }

  uint32_t getAFirstScaleLane();
  ::mlir::IntegerAttr getBFirstScaleLaneAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().b_first_scale_lane);
    return attr;
  }

  uint32_t getBFirstScaleLane();
};

} // namespace detail
template <typename RangeT>
class ScaledWMMAOpGenericAdaptor : public detail::ScaledWMMAOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ScaledWMMAOpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_scaleA = 3;
  static constexpr int odsIndex_scaleB = 4;
public:
  ScaledWMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ScaledWMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ScaledWMMAOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ScaledWMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ScaledWMMAOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ScaledWMMAOpGenericAdaptor(RangeT values, const ScaledWMMAOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ScaledWMMAOp, typename = std::enable_if_t<std::is_same_v<LateInst, ScaledWMMAOp>>>
  ScaledWMMAOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDestC() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScaleA() {
    return (*getODSOperands(3).begin());
  }

  ValueT getScaleB() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ScaledWMMAOpAdaptor : public ScaledWMMAOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ScaledWMMAOpGenericAdaptor::ScaledWMMAOpGenericAdaptor;
  ScaledWMMAOpAdaptor(ScaledWMMAOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ScaledWMMAOp : public ::mlir::Op<ScaledWMMAOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ScaledWMMAOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ScaledWMMAOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_scaleA = 3;
  static constexpr int odsIndex_scaleB = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("a_first_scale_lane"), ::llvm::StringRef("b_first_scale_lane"), ::llvm::StringRef("k"), ::llvm::StringRef("m"), ::llvm::StringRef("n")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAFirstScaleLaneAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAFirstScaleLaneAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBFirstScaleLaneAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBFirstScaleLaneAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getMAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getMAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.scaled_wmma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSourceB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getScaleA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getScaleB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleAMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleBMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDestD() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getMAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint32_t getK();
  ::mlir::IntegerAttr getAFirstScaleLaneAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().a_first_scale_lane);
  }

  uint32_t getAFirstScaleLane();
  ::mlir::IntegerAttr getBFirstScaleLaneAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().b_first_scale_lane);
  }

  uint32_t getBFirstScaleLane();
  void setMAttr(::mlir::IntegerAttr attr) {
    getProperties().m = attr;
  }

  void setM(uint32_t attrValue);
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint32_t attrValue);
  void setAFirstScaleLaneAttr(::mlir::IntegerAttr attr) {
    getProperties().a_first_scale_lane = attr;
  }

  void setAFirstScaleLane(uint32_t attrValue);
  void setBFirstScaleLaneAttr(::mlir::IntegerAttr attr) {
    getProperties().b_first_scale_lane = attr;
  }

  void setBFirstScaleLane(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, ::mlir::IntegerAttr a_first_scale_lane, ::mlir::Value scaleB, ::mlir::IntegerAttr b_first_scale_lane);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value scaleA, uint32_t a_first_scale_lane, ::mlir::Value scaleB, uint32_t b_first_scale_lane);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledWMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ScaledWMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::ScaledWMMAOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::SchedBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SchedBarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using optsTy = ::mlir::amdgpu::sched_barrier_opt_enumAttr;
    optsTy opts;

    auto getOpts() const {
      auto &propStorage = this->opts;
      return ::llvm::cast<::mlir::amdgpu::sched_barrier_opt_enumAttr>(propStorage);
    }
    void setOpts(const ::mlir::amdgpu::sched_barrier_opt_enumAttr &propValue) {
      this->opts = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.opts == this->opts &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SchedBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.sched_barrier", odsAttrs.getContext());
  }

  SchedBarrierOpGenericAdaptorBase(SchedBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::amdgpu::sched_barrier_opt_enumAttr getOptsAttr() {
    auto attr = ::llvm::cast<::mlir::amdgpu::sched_barrier_opt_enumAttr>(getProperties().opts);
    return attr;
  }

  ::mlir::amdgpu::sched_barrier_opt_enum getOpts();
};

} // namespace detail
template <typename RangeT>
class SchedBarrierOpGenericAdaptor : public detail::SchedBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SchedBarrierOpGenericAdaptorBase;
public:
  SchedBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SchedBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SchedBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SchedBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SchedBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SchedBarrierOpGenericAdaptor(RangeT values, const SchedBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SchedBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, SchedBarrierOp>>>
  SchedBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SchedBarrierOpAdaptor : public SchedBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SchedBarrierOpGenericAdaptor::SchedBarrierOpGenericAdaptor;
  SchedBarrierOpAdaptor(SchedBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SchedBarrierOp : public ::mlir::Op<SchedBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SchedBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SchedBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("opts")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOptsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOptsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.sched_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::amdgpu::sched_barrier_opt_enumAttr getOptsAttr() {
    return ::llvm::cast<::mlir::amdgpu::sched_barrier_opt_enumAttr>(getProperties().opts);
  }

  ::mlir::amdgpu::sched_barrier_opt_enum getOpts();
  void setOptsAttr(::mlir::amdgpu::sched_barrier_opt_enumAttr attr) {
    getProperties().opts = attr;
  }

  void setOpts(::mlir::amdgpu::sched_barrier_opt_enum attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enumAttr opts);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::amdgpu::sched_barrier_opt_enum opts);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SchedBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SchedBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::SchedBarrierOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::SparseMFMAOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SparseMFMAOpGenericAdaptorBase {
public:
  struct Properties {
    using abidTy = ::mlir::IntegerAttr;
    abidTy abid;

    auto getAbid() const {
      auto &propStorage = this->abid;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAbid(const ::mlir::IntegerAttr &propValue) {
      this->abid = propValue;
    }
    using cbszTy = ::mlir::IntegerAttr;
    cbszTy cbsz;

    auto getCbsz() const {
      auto &propStorage = this->cbsz;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setCbsz(const ::mlir::IntegerAttr &propValue) {
      this->cbsz = propValue;
    }
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using mTy = ::mlir::IntegerAttr;
    mTy m;

    auto getM() const {
      auto &propStorage = this->m;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setM(const ::mlir::IntegerAttr &propValue) {
      this->m = propValue;
    }
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.abid == this->abid &&
        rhs.cbsz == this->cbsz &&
        rhs.k == this->k &&
        rhs.m == this->m &&
        rhs.n == this->n &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SparseMFMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.sparse_mfma", odsAttrs.getContext());
  }

  SparseMFMAOpGenericAdaptorBase(SparseMFMAOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getMAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
    return attr;
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint32_t getK();
  ::mlir::IntegerAttr getCbszAttr();
  uint32_t getCbsz();
  ::mlir::IntegerAttr getAbidAttr();
  uint32_t getAbid();
};

} // namespace detail
template <typename RangeT>
class SparseMFMAOpGenericAdaptor : public detail::SparseMFMAOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SparseMFMAOpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_sparseIdx = 3;
public:
  SparseMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SparseMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SparseMFMAOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SparseMFMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SparseMFMAOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SparseMFMAOpGenericAdaptor(RangeT values, const SparseMFMAOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SparseMFMAOp, typename = std::enable_if_t<std::is_same_v<LateInst, SparseMFMAOp>>>
  SparseMFMAOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDestC() {
    return (*getODSOperands(2).begin());
  }

  ValueT getSparseIdx() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SparseMFMAOpAdaptor : public SparseMFMAOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SparseMFMAOpGenericAdaptor::SparseMFMAOpGenericAdaptor;
  SparseMFMAOpAdaptor(SparseMFMAOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SparseMFMAOp : public ::mlir::Op<SparseMFMAOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SparseMFMAOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SparseMFMAOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  static constexpr int odsIndex_sparseIdx = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("abid"), ::llvm::StringRef("cbsz"), ::llvm::StringRef("k"), ::llvm::StringRef("m"), ::llvm::StringRef("n")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAbidAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAbidAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getCbszAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getCbszAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getMAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getMAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.sparse_mfma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSourceB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSparseIdx() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSparseIdxMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDestD() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getMAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint32_t getK();
  ::mlir::IntegerAttr getCbszAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().cbsz);
  }

  uint32_t getCbsz();
  ::mlir::IntegerAttr getAbidAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().abid);
  }

  uint32_t getAbid();
  void setMAttr(::mlir::IntegerAttr attr) {
    getProperties().m = attr;
  }

  void setM(uint32_t attrValue);
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint32_t attrValue);
  void setCbszAttr(::mlir::IntegerAttr attr) {
    getProperties().cbsz = attr;
  }

  void setCbsz(uint32_t attrValue);
  void setAbidAttr(::mlir::IntegerAttr attr) {
    getProperties().abid = attr;
  }

  void setAbid(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, ::mlir::IntegerAttr cbsz = nullptr, ::mlir::IntegerAttr abid = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::Value sparseIdx, uint32_t cbsz = 0, uint32_t abid = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SparseMFMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SparseMFMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::SparseMFMAOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::SwizzleBitModeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SwizzleBitModeOpGenericAdaptorBase {
public:
  struct Properties {
    using and_maskTy = ::mlir::IntegerAttr;
    and_maskTy and_mask;

    auto getAndMask() const {
      auto &propStorage = this->and_mask;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAndMask(const ::mlir::IntegerAttr &propValue) {
      this->and_mask = propValue;
    }
    using or_maskTy = ::mlir::IntegerAttr;
    or_maskTy or_mask;

    auto getOrMask() const {
      auto &propStorage = this->or_mask;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setOrMask(const ::mlir::IntegerAttr &propValue) {
      this->or_mask = propValue;
    }
    using xor_maskTy = ::mlir::IntegerAttr;
    xor_maskTy xor_mask;

    auto getXorMask() const {
      auto &propStorage = this->xor_mask;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setXorMask(const ::mlir::IntegerAttr &propValue) {
      this->xor_mask = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.and_mask == this->and_mask &&
        rhs.or_mask == this->or_mask &&
        rhs.xor_mask == this->xor_mask &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SwizzleBitModeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.swizzle_bitmode", odsAttrs.getContext());
  }

  SwizzleBitModeOpGenericAdaptorBase(SwizzleBitModeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAndMaskAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().and_mask);
    return attr;
  }

  uint32_t getAndMask();
  ::mlir::IntegerAttr getOrMaskAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().or_mask);
    return attr;
  }

  uint32_t getOrMask();
  ::mlir::IntegerAttr getXorMaskAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().xor_mask);
    return attr;
  }

  uint32_t getXorMask();
};

} // namespace detail
template <typename RangeT>
class SwizzleBitModeOpGenericAdaptor : public detail::SwizzleBitModeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SwizzleBitModeOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  SwizzleBitModeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SwizzleBitModeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SwizzleBitModeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SwizzleBitModeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SwizzleBitModeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SwizzleBitModeOpGenericAdaptor(RangeT values, const SwizzleBitModeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SwizzleBitModeOp, typename = std::enable_if_t<std::is_same_v<LateInst, SwizzleBitModeOp>>>
  SwizzleBitModeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SwizzleBitModeOpAdaptor : public SwizzleBitModeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SwizzleBitModeOpGenericAdaptor::SwizzleBitModeOpGenericAdaptor;
  SwizzleBitModeOpAdaptor(SwizzleBitModeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SwizzleBitModeOp : public ::mlir::Op<SwizzleBitModeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SwizzleBitModeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SwizzleBitModeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("and_mask"), ::llvm::StringRef("or_mask"), ::llvm::StringRef("xor_mask")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAndMaskAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAndMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOrMaskAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOrMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getXorMaskAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getXorMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.swizzle_bitmode");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAndMaskAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().and_mask);
  }

  uint32_t getAndMask();
  ::mlir::IntegerAttr getOrMaskAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().or_mask);
  }

  uint32_t getOrMask();
  ::mlir::IntegerAttr getXorMaskAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().xor_mask);
  }

  uint32_t getXorMask();
  void setAndMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().and_mask = attr;
  }

  void setAndMask(uint32_t attrValue);
  void setOrMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().or_mask = attr;
  }

  void setOrMask(uint32_t attrValue);
  void setXorMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().xor_mask = attr;
  }

  void setXorMask(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr and_mask, ::mlir::IntegerAttr or_mask, ::mlir::IntegerAttr xor_mask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t and_mask, uint32_t or_mask, uint32_t xor_mask);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SwizzleBitModeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SwizzleBitModeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::SwizzleBitModeOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::TensorLoadToLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class TensorLoadToLDSOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TensorLoadToLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.tensor_load_to_lds", odsAttrs.getContext());
  }

  TensorLoadToLDSOpGenericAdaptorBase(TensorLoadToLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class TensorLoadToLDSOpGenericAdaptor : public detail::TensorLoadToLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TensorLoadToLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_desc = 0;
public:
  TensorLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TensorLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TensorLoadToLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TensorLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : TensorLoadToLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TensorLoadToLDSOpGenericAdaptor(RangeT values, const TensorLoadToLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TensorLoadToLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, TensorLoadToLDSOp>>>
  TensorLoadToLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDesc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TensorLoadToLDSOpAdaptor : public TensorLoadToLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TensorLoadToLDSOpGenericAdaptor::TensorLoadToLDSOpGenericAdaptor;
  TensorLoadToLDSOpAdaptor(TensorLoadToLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TensorLoadToLDSOp : public ::mlir::Op<TensorLoadToLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TensorLoadToLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TensorLoadToLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_desc = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.tensor_load_to_lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType> getDesc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getDescMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc);
  static TensorLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc);
  static TensorLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static TensorLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static TensorLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::TensorLoadToLDSOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::TensorStoreFromLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class TensorStoreFromLDSOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TensorStoreFromLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.tensor_store_from_lds", odsAttrs.getContext());
  }

  TensorStoreFromLDSOpGenericAdaptorBase(TensorStoreFromLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class TensorStoreFromLDSOpGenericAdaptor : public detail::TensorStoreFromLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TensorStoreFromLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_desc = 0;
public:
  TensorStoreFromLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TensorStoreFromLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TensorStoreFromLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TensorStoreFromLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : TensorStoreFromLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TensorStoreFromLDSOpGenericAdaptor(RangeT values, const TensorStoreFromLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TensorStoreFromLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, TensorStoreFromLDSOp>>>
  TensorStoreFromLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDesc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TensorStoreFromLDSOpAdaptor : public TensorStoreFromLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TensorStoreFromLDSOpGenericAdaptor::TensorStoreFromLDSOpGenericAdaptor;
  TensorStoreFromLDSOpAdaptor(TensorStoreFromLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TensorStoreFromLDSOp : public ::mlir::Op<TensorStoreFromLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TensorStoreFromLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TensorStoreFromLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_desc = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.tensor_store_from_lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType> getDesc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::amdgpu::TDMDescriptorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getDescMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc);
  static TensorStoreFromLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc);
  static TensorStoreFromLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static TensorStoreFromLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static TensorStoreFromLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorStoreFromLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorStoreFromLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorStoreFromLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorStoreFromLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::TensorStoreFromLDSOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::TransposeLoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class TransposeLoadOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TransposeLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.transpose_load", odsAttrs.getContext());
  }

  TransposeLoadOpGenericAdaptorBase(TransposeLoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class TransposeLoadOpGenericAdaptor : public detail::TransposeLoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TransposeLoadOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_srcIndices = 1;
public:
  TransposeLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TransposeLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TransposeLoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TransposeLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : TransposeLoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TransposeLoadOpGenericAdaptor(RangeT values, const TransposeLoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TransposeLoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, TransposeLoadOp>>>
  TransposeLoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getSrcIndices() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TransposeLoadOpAdaptor : public TransposeLoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TransposeLoadOpGenericAdaptor::TransposeLoadOpGenericAdaptor;
  TransposeLoadOpAdaptor(TransposeLoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TransposeLoadOp : public ::mlir::Op<TransposeLoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TransposeLoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TransposeLoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_srcIndices = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.transpose_load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getSrcIndices() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSrcIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static TransposeLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static TransposeLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static TransposeLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static TransposeLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::ValueRange srcIndices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TransposeLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TransposeLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TransposeLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TransposeLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::TransposeLoadOp)

namespace mlir::amdgpu {


//===----------------------------------------------------------------------===//
// ::mlir::amdgpu::WMMAOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class WMMAOpGenericAdaptorBase {
public:
  struct Properties {
    using clampTy = ::mlir::UnitAttr;
    clampTy clamp;

    auto getClamp() const {
      auto &propStorage = this->clamp;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setClamp(const ::mlir::UnitAttr &propValue) {
      this->clamp = propValue;
    }
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using mTy = ::mlir::IntegerAttr;
    mTy m;

    auto getM() const {
      auto &propStorage = this->m;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setM(const ::mlir::IntegerAttr &propValue) {
      this->m = propValue;
    }
    using nTy = ::mlir::IntegerAttr;
    nTy n;

    auto getN() const {
      auto &propStorage = this->n;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setN(const ::mlir::IntegerAttr &propValue) {
      this->n = propValue;
    }
    using subwordOffsetTy = ::mlir::IntegerAttr;
    subwordOffsetTy subwordOffset;

    auto getSubwordOffset() const {
      auto &propStorage = this->subwordOffset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSubwordOffset(const ::mlir::IntegerAttr &propValue) {
      this->subwordOffset = propValue;
    }
    using unsignedATy = ::mlir::UnitAttr;
    unsignedATy unsignedA;

    auto getUnsignedA() const {
      auto &propStorage = this->unsignedA;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUnsignedA(const ::mlir::UnitAttr &propValue) {
      this->unsignedA = propValue;
    }
    using unsignedBTy = ::mlir::UnitAttr;
    unsignedBTy unsignedB;

    auto getUnsignedB() const {
      auto &propStorage = this->unsignedB;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUnsignedB(const ::mlir::UnitAttr &propValue) {
      this->unsignedB = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.clamp == this->clamp &&
        rhs.k == this->k &&
        rhs.m == this->m &&
        rhs.n == this->n &&
        rhs.subwordOffset == this->subwordOffset &&
        rhs.unsignedA == this->unsignedA &&
        rhs.unsignedB == this->unsignedB &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  WMMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("amdgpu.wmma", odsAttrs.getContext());
  }

  WMMAOpGenericAdaptorBase(WMMAOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getMAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
    return attr;
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
    return attr;
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint32_t getK();
  ::mlir::IntegerAttr getSubwordOffsetAttr();
  uint32_t getSubwordOffset();
  ::mlir::UnitAttr getUnsignedAAttr();
  bool getUnsignedA();
  ::mlir::UnitAttr getUnsignedBAttr();
  bool getUnsignedB();
  ::mlir::UnitAttr getClampAttr();
  bool getClamp();
};

} // namespace detail
template <typename RangeT>
class WMMAOpGenericAdaptor : public detail::WMMAOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::WMMAOpGenericAdaptorBase;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
public:
  WMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  WMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : WMMAOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  WMMAOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : WMMAOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  WMMAOpGenericAdaptor(RangeT values, const WMMAOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = WMMAOp, typename = std::enable_if_t<std::is_same_v<LateInst, WMMAOp>>>
  WMMAOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSourceA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSourceB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDestC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class WMMAOpAdaptor : public WMMAOpGenericAdaptor<::mlir::ValueRange> {
public:
  using WMMAOpGenericAdaptor::WMMAOpGenericAdaptor;
  WMMAOpAdaptor(WMMAOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class WMMAOp : public ::mlir::Op<WMMAOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = WMMAOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = WMMAOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sourceA = 0;
  static constexpr int odsIndex_sourceB = 1;
  static constexpr int odsIndex_destC = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("clamp"), ::llvm::StringRef("k"), ::llvm::StringRef("m"), ::llvm::StringRef("n"), ::llvm::StringRef("subwordOffset"), ::llvm::StringRef("unsignedA"), ::llvm::StringRef("unsignedB")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getClampAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getClampAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getMAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getMAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSubwordOffsetAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSubwordOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getUnsignedAAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getUnsignedAAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getUnsignedBAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getUnsignedBAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("amdgpu.wmma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSourceA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSourceB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSourceAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDestD() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getMAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().m);
  }

  uint32_t getM();
  ::mlir::IntegerAttr getNAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().n);
  }

  uint32_t getN();
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint32_t getK();
  ::mlir::IntegerAttr getSubwordOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().subwordOffset);
  }

  uint32_t getSubwordOffset();
  ::mlir::UnitAttr getUnsignedAAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().unsignedA);
  }

  bool getUnsignedA();
  ::mlir::UnitAttr getUnsignedBAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().unsignedB);
  }

  bool getUnsignedB();
  ::mlir::UnitAttr getClampAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().clamp);
  }

  bool getClamp();
  void setMAttr(::mlir::IntegerAttr attr) {
    getProperties().m = attr;
  }

  void setM(uint32_t attrValue);
  void setNAttr(::mlir::IntegerAttr attr) {
    getProperties().n = attr;
  }

  void setN(uint32_t attrValue);
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint32_t attrValue);
  void setSubwordOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().subwordOffset = attr;
  }

  void setSubwordOffset(uint32_t attrValue);
  void setUnsignedAAttr(::mlir::UnitAttr attr) {
    getProperties().unsignedA = attr;
  }

  void setUnsignedA(bool attrValue);
  void setUnsignedBAttr(::mlir::UnitAttr attr) {
    getProperties().unsignedB = attr;
  }

  void setUnsignedB(bool attrValue);
  void setClampAttr(::mlir::UnitAttr attr) {
    getProperties().clamp = attr;
  }

  void setClamp(bool attrValue);
  ::mlir::Attribute removeUnsignedAAttr() {
      auto attr = getProperties().unsignedA;
      getProperties().unsignedA = {};
      return attr;
  }

  ::mlir::Attribute removeUnsignedBAttr() {
      auto attr = getProperties().unsignedB;
      getProperties().unsignedB = {};
      return attr;
  }

  ::mlir::Attribute removeClampAttr() {
      auto attr = getProperties().clamp;
      getProperties().clamp = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr m, ::mlir::IntegerAttr n, ::mlir::IntegerAttr k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, ::mlir::IntegerAttr subwordOffset = nullptr, /*optional*/::mlir::UnitAttr unsignedA = nullptr, /*optional*/::mlir::UnitAttr unsignedB = nullptr, /*optional*/::mlir::UnitAttr clamp = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type destD, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t m, uint32_t n, uint32_t k, ::mlir::Value sourceA, ::mlir::Value sourceB, ::mlir::Value destC, uint32_t subwordOffset = 0, /*optional*/bool unsignedA = false, /*optional*/bool unsignedB = false, /*optional*/bool clamp = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WMMAOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WMMAOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::amdgpu
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::amdgpu::WMMAOp)


#endif // GET_OP_CLASSES

