/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Named
@Singleton
public class DefaultPluginDescriptorCache
implements PluginDescriptorCache {
    private Map<PluginDescriptorCache.Key, PluginDescriptor> descriptors = new ConcurrentHashMap<PluginDescriptorCache.Key, PluginDescriptor>(128);
    private Map<PluginDescriptorCache.Key, PluginDescriptorCache.Key> keys = new ConcurrentHashMap<PluginDescriptorCache.Key, PluginDescriptorCache.Key>();

    @Override
    public void flush() {
        this.descriptors.clear();
    }

    @Override
    public PluginDescriptorCache.Key createKey(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return this.keys.computeIfAbsent(new CacheKey(plugin, repositories, session), k -> k);
    }

    @Override
    public PluginDescriptor get(PluginDescriptorCache.Key cacheKey) {
        return DefaultPluginDescriptorCache.clone(this.descriptors.get(cacheKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginDescriptor get(PluginDescriptorCache.Key key, PluginDescriptorCache.PluginDescriptorSupplier supplier) throws PluginDescriptorParsingException, PluginResolutionException, InvalidPluginDescriptorException {
        PluginDescriptor desc = this.descriptors.get(key);
        if (desc == null) {
            PluginDescriptorCache.Key key2 = key;
            synchronized (key2) {
                desc = this.descriptors.get(key);
                if (desc == null) {
                    desc = supplier.load();
                    this.descriptors.putIfAbsent(key, DefaultPluginDescriptorCache.clone(desc));
                }
            }
        }
        return DefaultPluginDescriptorCache.clone(desc);
    }

    @Override
    public void put(PluginDescriptorCache.Key cacheKey, PluginDescriptor pluginDescriptor) {
        this.descriptors.put(cacheKey, DefaultPluginDescriptorCache.clone(pluginDescriptor));
    }

    protected static PluginDescriptor clone(PluginDescriptor original) {
        return new PluginDescriptor(original);
    }

    private static final class CacheKey
    implements PluginDescriptorCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        CacheKey(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.groupId = plugin.getGroupId();
            this.artifactId = plugin.getArtifactId();
            this.version = plugin.getVersion();
            this.workspace = RepositoryUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + this.localRepo.hashCode();
            this.hashCode = hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey that = (CacheKey)obj;
                return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.version, that.version) && Objects.equals(this.localRepo, that.localRepo) && Objects.equals(this.workspace, that.workspace) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories);
            }
            return false;
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }
    }
}

