
include Either

(*
type ('a, 'b) t = ('a, 'b) Stdcompat__init.either =
  | Left of 'a
  | Right of 'b

let left v = Left v

let right v = Right v

let is_left e =
  match e with
  | Left _ -> true
  | Right _ -> false

let is_right e =
  match e with
  | Left _ -> false
  | Right _ -> true

let find_left e =
  match e with
  | Left v -> Some v
  | Right _ -> None

let find_right e =
  match e with
  | Left _ -> None
  | Right v -> Some v

let map_left f e =
  match e with
  | Left v -> Left (f v)
  | Right _ as e -> e

let map_right f e =
  match e with
  | Left _ as e -> e
  | Right v -> Right (f v)

let map ~left ~right e =
  match e with
  | Left v -> Left (left v)
  | Right v -> Right (right v)

let fold ~left ~right e =
  match e with
  | Left v -> left v
  | Right v -> right v

let iter = fold

let for_all = fold

let equal ~left ~right e1 e2 =
  match e1, e2 with
  | Left v1, Left v2 -> left v1 v2
  | Right v1, Right v2 -> right v1 v2
  | Left _, Right _
  | Right _, Left _ -> false

let compare ~left ~right e1 e2 =
  match e1, e2 with
  | Left v1, Left v2 -> left v1 v2
  | Right v1, Right v2 -> right v1 v2
  | Left _, Right _ -> -1
  | Right _, Left _ -> 1
*)
