
module MenhirBasics = struct
  
  exception Error
  
  let _eRR =
    fun _s ->
      raise Error
  
  type token = 
    | VEC_UNARY of (
# 225 "interpreter/text/parser.mly"
      (Ast.instr')
# 15 "interpreter/text/parser.ml"
  )
    | VEC_TYPE of (
# 207 "interpreter/text/parser.mly"
      (Types.vec_type)
# 20 "interpreter/text/parser.ml"
  )
    | VEC_TEST of (
# 225 "interpreter/text/parser.mly"
      (Ast.instr')
# 25 "interpreter/text/parser.ml"
  )
    | VEC_TERNARY of (
# 225 "interpreter/text/parser.mly"
      (Ast.instr')
# 30 "interpreter/text/parser.ml"
  )
    | VEC_STORE_LANE of (
# 223 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> int -> Ast.instr')
# 35 "interpreter/text/parser.ml"
  )
    | VEC_STORE of (
# 222 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 40 "interpreter/text/parser.ml"
  )
    | VEC_SPLAT of (
# 226 "interpreter/text/parser.mly"
      (Ast.instr')
# 45 "interpreter/text/parser.ml"
  )
    | VEC_SHUFFLE
    | VEC_SHIFT of (
# 226 "interpreter/text/parser.mly"
      (Ast.instr')
# 51 "interpreter/text/parser.ml"
  )
    | VEC_SHAPE of (
# 208 "interpreter/text/parser.mly"
      (V128.shape)
# 56 "interpreter/text/parser.ml"
  )
    | VEC_REPLACE of (
# 228 "interpreter/text/parser.mly"
      (int -> Ast.instr')
# 61 "interpreter/text/parser.ml"
  )
    | VEC_LOAD_LANE of (
# 223 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> int -> Ast.instr')
# 66 "interpreter/text/parser.ml"
  )
    | VEC_LOAD of (
# 222 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 71 "interpreter/text/parser.ml"
  )
    | VEC_EXTRACT of (
# 228 "interpreter/text/parser.mly"
      (int -> Ast.instr')
# 76 "interpreter/text/parser.ml"
  )
    | VEC_CONST of (
# 224 "interpreter/text/parser.mly"
      (V128.shape -> string Source.phrase list -> Source.region -> Ast.instr' * Values.vec)
# 81 "interpreter/text/parser.ml"
  )
    | VEC_BITMASK of (
# 226 "interpreter/text/parser.mly"
      (Ast.instr')
# 86 "interpreter/text/parser.ml"
  )
    | VEC_BINARY of (
# 225 "interpreter/text/parser.mly"
      (Ast.instr')
# 91 "interpreter/text/parser.ml"
  )
    | VAR of (
# 205 "interpreter/text/parser.mly"
      (string)
# 96 "interpreter/text/parser.ml"
  )
    | UNREACHABLE
    | UNARY of (
# 220 "interpreter/text/parser.mly"
      (Ast.instr')
# 102 "interpreter/text/parser.ml"
  )
    | TYPE
    | THEN
    | TEST of (
# 220 "interpreter/text/parser.mly"
      (Ast.instr')
# 109 "interpreter/text/parser.ml"
  )
    | TABLE_SIZE
    | TABLE_SET
    | TABLE_INIT
    | TABLE_GROW
    | TABLE_GET
    | TABLE_FILL
    | TABLE_COPY
    | TABLE
    | STRING of (
# 205 "interpreter/text/parser.mly"
      (string)
# 122 "interpreter/text/parser.ml"
  )
    | STORE of (
# 217 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 127 "interpreter/text/parser.ml"
  )
    | START
    | SELECT
    | SCRIPT
    | RPAR
    | RETURN
    | RESULT
    | REGISTER
    | REF_NULL
    | REF_IS_NULL
    | REF_FUNC
    | REF_EXTERN
    | QUOTE
    | PARAM
    | OUTPUT
    | OFFSET_EQ_NAT of (
# 218 "interpreter/text/parser.mly"
      (string)
# 146 "interpreter/text/parser.ml"
  )
    | OFFSET
    | NUM_TYPE of (
# 206 "interpreter/text/parser.mly"
      (Types.num_type)
# 152 "interpreter/text/parser.ml"
  )
    | NOP
    | NAT of (
# 205 "interpreter/text/parser.mly"
      (string)
# 158 "interpreter/text/parser.ml"
  )
    | NAN of (
# 235 "interpreter/text/parser.mly"
      (Script.nan)
# 163 "interpreter/text/parser.ml"
  )
    | MUT
    | MODULE
    | MEMORY_SIZE
    | MEMORY_INIT
    | MEMORY_GROW
    | MEMORY_FILL
    | MEMORY_COPY
    | MEMORY
    | LPAR
    | LOOP
    | LOCAL_TEE
    | LOCAL_SET
    | LOCAL_GET
    | LOCAL
    | LOAD of (
# 217 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 182 "interpreter/text/parser.ml"
  )
    | ITEM
    | INVOKE
    | INT of (
# 205 "interpreter/text/parser.mly"
      (string)
# 189 "interpreter/text/parser.ml"
  )
    | INPUT
    | IMPORT
    | IF
    | GLOBAL_SET
    | GLOBAL_GET
    | GLOBAL
    | GET
    | FUNCREF
    | FUNC
    | FLOAT of (
# 205 "interpreter/text/parser.mly"
      (string)
# 203 "interpreter/text/parser.ml"
  )
    | EXTERNREF
    | EXTERN
    | EXPORT
    | EOF
    | END
    | ELSE
    | ELEM_DROP
    | ELEM
    | DROP
    | DECLARE
    | DATA_DROP
    | DATA
    | CONVERT of (
# 220 "interpreter/text/parser.mly"
      (Ast.instr')
# 220 "interpreter/text/parser.ml"
  )
    | CONST of (
# 219 "interpreter/text/parser.mly"
      (string Source.phrase -> Ast.instr' * Values.num)
# 225 "interpreter/text/parser.ml"
  )
    | COMPARE of (
# 220 "interpreter/text/parser.mly"
      (Ast.instr')
# 230 "interpreter/text/parser.ml"
  )
    | CALL_INDIRECT
    | CALL
    | BR_TABLE
    | BR_IF
    | BR
    | BLOCK
    | BINARY of (
# 220 "interpreter/text/parser.mly"
      (Ast.instr')
# 241 "interpreter/text/parser.ml"
  )
    | BIN
    | ASSERT_UNLINKABLE
    | ASSERT_TRAP
    | ASSERT_RETURN
    | ASSERT_MALFORMED
    | ASSERT_INVALID
    | ASSERT_EXHAUSTION
    | ALIGN_EQ_NAT of (
# 218 "interpreter/text/parser.mly"
      (string)
# 253 "interpreter/text/parser.ml"
  )
  
end

include MenhirBasics

# 1 "interpreter/text/parser.mly"
  
open Source
open Types
open Ast
open Operators
open Script


(* Error handling *)

let error at msg = raise (Parse_error.Syntax (at, msg))


(* Position handling *)

let position_to_pos position =
  { file = position.Lexing.pos_fname;
    line = position.Lexing.pos_lnum;
    column = position.Lexing.pos_cnum - position.Lexing.pos_bol
  }

let positions_to_region position1 position2 =
  { left = position_to_pos position1;
    right = position_to_pos position2
  }

let at (l, r) = positions_to_region l r

let (@@) x loc = x @@ at loc


(* Literals *)

let num f s =
  try f s with Failure _ -> error s.at "constant out of range"

let vec f shape ss loc =
  try f shape ss (at loc) with
  | Failure _ -> error (at loc) "constant out of range"
  | Invalid_argument _ -> error (at loc) "wrong number of lane literals"

let vec_lane_nan shape l at' =
  let open Values in
  let open Source in
  match shape with
  | V128.F32x4 () -> NanPat (F32 l @@ at')
  | V128.F64x2 () -> NanPat (F64 l @@ at')
  | _ -> error at' "invalid vector constant"

let vec_lane_lit shape l at' =
  let open Values in
  let open Source in
  match shape with
  | V128.I8x16 () -> NumPat (I32 (I8.of_string l) @@ at')
  | V128.I16x8 () -> NumPat (I32 (I16.of_string l) @@ at')
  | V128.I32x4 () -> NumPat (I32 (I32.of_string l) @@ at')
  | V128.I64x2 () -> NumPat (I64 (I64.of_string l) @@ at')
  | V128.F32x4 () -> NumPat (F32 (F32.of_string l) @@ at')
  | V128.F64x2 () -> NumPat (F64 (F64.of_string l) @@ at')

let vec_lane_index s at =
  match int_of_string s with
  | n when 0 <= n && n < 256 -> n
  | _ | exception Failure _ -> error at "malformed lane index"

let shuffle_lit ss loc =
  if not (List.length ss = 16) then
    error (at loc) "invalid lane length";
  List.map (fun s -> vec_lane_index s.it s.at) ss

let nanop f nan =
  let open Source in
  let open Values in
  match snd (f ("0" @@ no_region)) with
  | F32 _ -> F32 nan.it @@ nan.at
  | F64 _ -> F64 nan.it @@ nan.at
  | I32 _ | I64 _ -> error nan.at "NaN pattern with non-float type"

let nat s loc =
  try
    let n = int_of_string s in
    if n >= 0 then n else raise (Failure "")
  with Failure _ -> error (at loc) "integer constant out of range"

let nat32 s loc =
  try I32.of_string_u s with Failure _ -> error (at loc) "i32 constant out of range"

let name s loc =
  try Utf8.decode s with Utf8.Utf8 -> error (at loc) "malformed UTF-8 encoding"


(* Symbolic variables *)

module VarMap = Map.Make(String)

type space = {mutable map : int32 VarMap.t; mutable count : int32}
let empty () = {map = VarMap.empty; count = 0l}

type types = {space : space; mutable list : type_ list}
let empty_types () = {space = empty (); list = []}

type context =
  { types : types; tables : space; memories : space;
    funcs : space; locals : space; globals : space;
    datas : space; elems : space;
    labels : int32 VarMap.t; deferred_locals : (unit -> unit) list ref
  }

let empty_context () =
  { types = empty_types (); tables = empty (); memories = empty ();
    funcs = empty (); locals = empty (); globals = empty ();
    datas = empty (); elems = empty ();
    labels = VarMap.empty; deferred_locals = ref []
  }

let force_locals (c : context) =
  List.fold_right Stdlib.(@@) !(c.deferred_locals) ();
  c.deferred_locals := []

let enter_func (c : context) =
  {c with labels = VarMap.empty; locals = empty ()}

let lookup category space x =
  try VarMap.find x.it space.map
  with Not_found -> error x.at ("unknown " ^ category ^ " " ^ x.it)

let type_ (c : context) x = lookup "type" c.types.space x
let func (c : context) x = lookup "function" c.funcs x
let local (c : context) x = force_locals c; lookup "local" c.locals x
let global (c : context) x = lookup "global" c.globals x
let table (c : context) x = lookup "table" c.tables x
let memory (c : context) x = lookup "memory" c.memories x
let elem (c : context) x = lookup "elem segment" c.elems x
let data (c : context) x = lookup "data segment" c.datas x
let label (c : context) x =
  try VarMap.find x.it c.labels
  with Not_found -> error x.at ("unknown label " ^ x.it)

let func_type (c : context) x =
  try (Lib.List32.nth c.types.list x.it).it
  with Failure _ -> error x.at ("unknown type " ^ Int32.to_string x.it)


let anon category space n =
  let i = space.count in
  space.count <- Int32.add i n;
  if I32.lt_u space.count n then
    error no_region ("too many " ^ category ^ " bindings");
  i

let bind category space x =
  let i = anon category space 1l in
  if VarMap.mem x.it space.map then
    error x.at ("duplicate " ^ category ^ " " ^ x.it);
  space.map <- VarMap.add x.it i space.map;
  i

let bind_type (c : context) x ty =
  c.types.list <- c.types.list @ [ty];
  bind "type" c.types.space x
let bind_func (c : context) x = bind "function" c.funcs x
let bind_local (c : context) x = force_locals c; bind "local" c.locals x
let bind_global (c : context) x = bind "global" c.globals x
let bind_table (c : context) x = bind "table" c.tables x
let bind_memory (c : context) x = bind "memory" c.memories x
let bind_elem (c : context) x = bind "elem segment" c.elems x
let bind_data (c : context) x = bind "data segment" c.datas x
let bind_label (c : context) x =
  {c with labels = VarMap.add x.it 0l (VarMap.map (Int32.add 1l) c.labels)}

let anon_type (c : context) ty =
  c.types.list <- c.types.list @ [ty];
  anon "type" c.types.space 1l
let anon_func (c : context) = anon "function" c.funcs 1l
let anon_locals (c : context) lazy_ts =
  let f () =
    ignore (anon "local" c.locals (Lib.List32.length (Lazy.force lazy_ts)))
  in c.deferred_locals := f :: !(c.deferred_locals)
let anon_global (c : context) = anon "global" c.globals 1l
let anon_table (c : context) = anon "table" c.tables 1l
let anon_memory (c : context) = anon "memory" c.memories 1l
let anon_elem (c : context) = anon "elem segment" c.elems 1l
let anon_data (c : context) = anon "data segment" c.datas 1l
let anon_label (c : context) =
  {c with labels = VarMap.map (Int32.add 1l) c.labels}


let inline_type (c : context) ft loc =
  match Lib.List.index_where (fun ty -> ty.it = ft) c.types.list with
  | Some i -> Int32.of_int i @@ loc
  | None -> anon_type c (ft @@ loc) @@ loc

let inline_type_explicit (c : context) x ft loc =
  if ft = FuncType ([], []) then
    (* Laziness ensures that type lookup is only triggered when
       symbolic identifiers are used, and not for desugared functions *)
    anon_locals c (lazy (let FuncType (ts, _) = func_type c x in ts))
  else if ft <> func_type c x then
    error (at loc) "inline function type does not match explicit type";
  x


# 463 "interpreter/text/parser.ml"

type ('s, 'r) _menhir_state = 
  | MenhirState000 : ('s, _menhir_box_module1) _menhir_state
    (** State 000.
        Stack shape : .
        Start symbol: module1. *)

  | MenhirState002 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 002.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState005 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_FUNC, 'r) _menhir_state
    (** State 005.
        Stack shape : LPAR FUNC.
        Start symbol: <undetermined>. *)

  | MenhirState006 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 006.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState007 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 007.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState012 : (('s, 'r) _menhir_cell1_value_type, 'r) _menhir_state
    (** State 012.
        Stack shape : value_type.
        Start symbol: <undetermined>. *)

  | MenhirState016 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 016.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState017 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 017.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState019 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 019.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState021 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 021.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState024 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_state
    (** State 024.
        Stack shape : LPAR PARAM bind_var.
        Start symbol: <undetermined>. *)

  | MenhirState026 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_cell1_value_type _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 026.
        Stack shape : LPAR PARAM bind_var value_type RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState033 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var, 'r) _menhir_state
    (** State 033.
        Stack shape : LPAR bind_var.
        Start symbol: <undetermined>. *)

  | MenhirState036 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 036.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState037 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 037.
        Stack shape : LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState040 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 040.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState041 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IMPORT, 'r) _menhir_state
    (** State 041.
        Stack shape : LPAR IMPORT.
        Start symbol: <undetermined>. *)

  | MenhirState043 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IMPORT, 'r) _menhir_cell1_name, 'r) _menhir_state
    (** State 043.
        Stack shape : LPAR IMPORT name.
        Start symbol: <undetermined>. *)

  | MenhirState046 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_EXPORT, 'r) _menhir_state
    (** State 046.
        Stack shape : LPAR EXPORT.
        Start symbol: <undetermined>. *)

  | MenhirState054 : (('s, 'r) _menhir_cell1_ref_type _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 054.
        Stack shape : ref_type LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState057 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 057.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState061 : (('s, 'r) _menhir_cell1_VEC_STORE_LANE, 'r) _menhir_state
    (** State 061.
        Stack shape : VEC_STORE_LANE.
        Start symbol: <undetermined>. *)

  | MenhirState063 : ((('s, 'r) _menhir_cell1_VEC_STORE_LANE, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 063.
        Stack shape : VEC_STORE_LANE offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState067 : (('s, 'r) _menhir_cell1_VEC_STORE, 'r) _menhir_state
    (** State 067.
        Stack shape : VEC_STORE.
        Start symbol: <undetermined>. *)

  | MenhirState068 : ((('s, 'r) _menhir_cell1_VEC_STORE, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 068.
        Stack shape : VEC_STORE offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState071 : (('s, 'r) _menhir_cell1_VEC_SHUFFLE, 'r) _menhir_state
    (** State 071.
        Stack shape : VEC_SHUFFLE.
        Start symbol: <undetermined>. *)

  | MenhirState075 : (('s, 'r) _menhir_cell1_num, 'r) _menhir_state
    (** State 075.
        Stack shape : num.
        Start symbol: <undetermined>. *)

  | MenhirState081 : (('s, 'r) _menhir_cell1_VEC_LOAD_LANE, 'r) _menhir_state
    (** State 081.
        Stack shape : VEC_LOAD_LANE.
        Start symbol: <undetermined>. *)

  | MenhirState082 : ((('s, 'r) _menhir_cell1_VEC_LOAD_LANE, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 082.
        Stack shape : VEC_LOAD_LANE offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState085 : (('s, 'r) _menhir_cell1_VEC_LOAD, 'r) _menhir_state
    (** State 085.
        Stack shape : VEC_LOAD.
        Start symbol: <undetermined>. *)

  | MenhirState086 : ((('s, 'r) _menhir_cell1_VEC_LOAD, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 086.
        Stack shape : VEC_LOAD offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState091 : (('s, 'r) _menhir_cell1_VEC_CONST _menhir_cell0_VEC_SHAPE, 'r) _menhir_state
    (** State 091.
        Stack shape : VEC_CONST VEC_SHAPE.
        Start symbol: <undetermined>. *)

  | MenhirState098 : (('s, 'r) _menhir_cell1_TABLE_SIZE, 'r) _menhir_state
    (** State 098.
        Stack shape : TABLE_SIZE.
        Start symbol: <undetermined>. *)

  | MenhirState100 : (('s, 'r) _menhir_cell1_TABLE_SET, 'r) _menhir_state
    (** State 100.
        Stack shape : TABLE_SET.
        Start symbol: <undetermined>. *)

  | MenhirState102 : (('s, 'r) _menhir_cell1_TABLE_INIT, 'r) _menhir_state
    (** State 102.
        Stack shape : TABLE_INIT.
        Start symbol: <undetermined>. *)

  | MenhirState103 : ((('s, 'r) _menhir_cell1_TABLE_INIT, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 103.
        Stack shape : TABLE_INIT var.
        Start symbol: <undetermined>. *)

  | MenhirState105 : (('s, 'r) _menhir_cell1_TABLE_GROW, 'r) _menhir_state
    (** State 105.
        Stack shape : TABLE_GROW.
        Start symbol: <undetermined>. *)

  | MenhirState107 : (('s, 'r) _menhir_cell1_TABLE_GET, 'r) _menhir_state
    (** State 107.
        Stack shape : TABLE_GET.
        Start symbol: <undetermined>. *)

  | MenhirState109 : (('s, 'r) _menhir_cell1_TABLE_FILL, 'r) _menhir_state
    (** State 109.
        Stack shape : TABLE_FILL.
        Start symbol: <undetermined>. *)

  | MenhirState111 : (('s, 'r) _menhir_cell1_TABLE_COPY, 'r) _menhir_state
    (** State 111.
        Stack shape : TABLE_COPY.
        Start symbol: <undetermined>. *)

  | MenhirState112 : ((('s, 'r) _menhir_cell1_TABLE_COPY, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 112.
        Stack shape : TABLE_COPY var.
        Start symbol: <undetermined>. *)

  | MenhirState114 : (('s, 'r) _menhir_cell1_STORE, 'r) _menhir_state
    (** State 114.
        Stack shape : STORE.
        Start symbol: <undetermined>. *)

  | MenhirState115 : ((('s, 'r) _menhir_cell1_STORE, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 115.
        Stack shape : STORE offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState117 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_SELECT, 'r) _menhir_state
    (** State 117.
        Stack shape : LPAR SELECT.
        Start symbol: <undetermined>. *)

  | MenhirState118 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 118.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState120 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 120.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState122 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 122.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState125 : (('s, 'r) _menhir_cell1_expr, 'r) _menhir_state
    (** State 125.
        Stack shape : expr.
        Start symbol: <undetermined>. *)

  | MenhirState126 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 126.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState127 : (('s, 'r) _menhir_cell1_REF_NULL, 'r) _menhir_state
    (** State 127.
        Stack shape : REF_NULL.
        Start symbol: <undetermined>. *)

  | MenhirState132 : (('s, 'r) _menhir_cell1_REF_FUNC, 'r) _menhir_state
    (** State 132.
        Stack shape : REF_FUNC.
        Start symbol: <undetermined>. *)

  | MenhirState136 : (('s, 'r) _menhir_cell1_MEMORY_INIT, 'r) _menhir_state
    (** State 136.
        Stack shape : MEMORY_INIT.
        Start symbol: <undetermined>. *)

  | MenhirState141 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOOP, 'r) _menhir_state
    (** State 141.
        Stack shape : LPAR LOOP.
        Start symbol: <undetermined>. *)

  | MenhirState142 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOOP, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 142.
        Stack shape : LPAR LOOP labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState143 : (('s, 'r) _menhir_cell1_SELECT, 'r) _menhir_state
    (** State 143.
        Stack shape : SELECT.
        Start symbol: <undetermined>. *)

  | MenhirState144 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 144.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState145 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 145.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState147 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 147.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState148 : (('s, 'r) _menhir_cell1_LOOP, 'r) _menhir_state
    (** State 148.
        Stack shape : LOOP.
        Start symbol: <undetermined>. *)

  | MenhirState149 : ((('s, 'r) _menhir_cell1_LOOP, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 149.
        Stack shape : LOOP labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState150 : ((('s, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 150.
        Stack shape : labeling_opt LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState151 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_TYPE, 'r) _menhir_state
    (** State 151.
        Stack shape : LPAR TYPE.
        Start symbol: <undetermined>. *)

  | MenhirState154 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 154.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState156 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 156.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState157 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 157.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState158 : (('s, 'r) _menhir_cell1_LOCAL_TEE, 'r) _menhir_state
    (** State 158.
        Stack shape : LOCAL_TEE.
        Start symbol: <undetermined>. *)

  | MenhirState160 : (('s, 'r) _menhir_cell1_LOCAL_SET, 'r) _menhir_state
    (** State 160.
        Stack shape : LOCAL_SET.
        Start symbol: <undetermined>. *)

  | MenhirState162 : (('s, 'r) _menhir_cell1_LOCAL_GET, 'r) _menhir_state
    (** State 162.
        Stack shape : LOCAL_GET.
        Start symbol: <undetermined>. *)

  | MenhirState164 : (('s, 'r) _menhir_cell1_LOAD, 'r) _menhir_state
    (** State 164.
        Stack shape : LOAD.
        Start symbol: <undetermined>. *)

  | MenhirState165 : ((('s, 'r) _menhir_cell1_LOAD, 'r) _menhir_cell1_offset_opt, 'r) _menhir_state
    (** State 165.
        Stack shape : LOAD offset_opt.
        Start symbol: <undetermined>. *)

  | MenhirState167 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IF, 'r) _menhir_state
    (** State 167.
        Stack shape : LPAR IF.
        Start symbol: <undetermined>. *)

  | MenhirState168 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 168.
        Stack shape : LPAR IF labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState169 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 169.
        Stack shape : LPAR IF labeling_opt LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState170 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_THEN, 'r) _menhir_state
    (** State 170.
        Stack shape : LPAR THEN.
        Start symbol: <undetermined>. *)

  | MenhirState171 : (('s, 'r) _menhir_cell1_IF, 'r) _menhir_state
    (** State 171.
        Stack shape : IF.
        Start symbol: <undetermined>. *)

  | MenhirState172 : ((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 172.
        Stack shape : IF labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState173 : (('s, 'r) _menhir_cell1_GLOBAL_SET, 'r) _menhir_state
    (** State 173.
        Stack shape : GLOBAL_SET.
        Start symbol: <undetermined>. *)

  | MenhirState175 : (('s, 'r) _menhir_cell1_GLOBAL_GET, 'r) _menhir_state
    (** State 175.
        Stack shape : GLOBAL_GET.
        Start symbol: <undetermined>. *)

  | MenhirState177 : (('s, 'r) _menhir_cell1_ELEM_DROP, 'r) _menhir_state
    (** State 177.
        Stack shape : ELEM_DROP.
        Start symbol: <undetermined>. *)

  | MenhirState180 : (('s, 'r) _menhir_cell1_DATA_DROP, 'r) _menhir_state
    (** State 180.
        Stack shape : DATA_DROP.
        Start symbol: <undetermined>. *)

  | MenhirState183 : (('s, 'r) _menhir_cell1_CONST, 'r) _menhir_state
    (** State 183.
        Stack shape : CONST.
        Start symbol: <undetermined>. *)

  | MenhirState186 : (('s, 'r) _menhir_cell1_CALL_INDIRECT, 'r) _menhir_state
    (** State 186.
        Stack shape : CALL_INDIRECT.
        Start symbol: <undetermined>. *)

  | MenhirState187 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 187.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState188 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 188.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState190 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 190.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState191 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 191.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState192 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_CALL_INDIRECT, 'r) _menhir_state
    (** State 192.
        Stack shape : LPAR CALL_INDIRECT.
        Start symbol: <undetermined>. *)

  | MenhirState193 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 193.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState194 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 194.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState196 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 196.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState197 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 197.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState198 : (('s, 'r) _menhir_cell1_CALL, 'r) _menhir_state
    (** State 198.
        Stack shape : CALL.
        Start symbol: <undetermined>. *)

  | MenhirState200 : (('s, 'r) _menhir_cell1_BR_TABLE, 'r) _menhir_state
    (** State 200.
        Stack shape : BR_TABLE.
        Start symbol: <undetermined>. *)

  | MenhirState201 : ((('s, 'r) _menhir_cell1_BR_TABLE, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 201.
        Stack shape : BR_TABLE var.
        Start symbol: <undetermined>. *)

  | MenhirState203 : (('s, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 203.
        Stack shape : var.
        Start symbol: <undetermined>. *)

  | MenhirState205 : (('s, 'r) _menhir_cell1_BR_IF, 'r) _menhir_state
    (** State 205.
        Stack shape : BR_IF.
        Start symbol: <undetermined>. *)

  | MenhirState207 : (('s, 'r) _menhir_cell1_BR, 'r) _menhir_state
    (** State 207.
        Stack shape : BR.
        Start symbol: <undetermined>. *)

  | MenhirState209 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_BLOCK, 'r) _menhir_state
    (** State 209.
        Stack shape : LPAR BLOCK.
        Start symbol: <undetermined>. *)

  | MenhirState210 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_BLOCK, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 210.
        Stack shape : LPAR BLOCK labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState211 : (('s, 'r) _menhir_cell1_BLOCK, 'r) _menhir_state
    (** State 211.
        Stack shape : BLOCK.
        Start symbol: <undetermined>. *)

  | MenhirState212 : ((('s, 'r) _menhir_cell1_BLOCK, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_state
    (** State 212.
        Stack shape : BLOCK labeling_opt.
        Start symbol: <undetermined>. *)

  | MenhirState214 : ((('s, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 214.
        Stack shape : labeling_opt type_use.
        Start symbol: <undetermined>. *)

  | MenhirState215 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 215.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState216 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 216.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState218 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 218.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState222 : (('s, 'r) _menhir_cell1_instr1, 'r) _menhir_state
    (** State 222.
        Stack shape : instr1.
        Start symbol: <undetermined>. *)

  | MenhirState229 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_plain_instr, 'r) _menhir_state
    (** State 229.
        Stack shape : LPAR plain_instr.
        Start symbol: <undetermined>. *)

  | MenhirState236 : (((('s, 'r) _menhir_cell1_BLOCK, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_state
    (** State 236.
        Stack shape : BLOCK labeling_opt block.
        Start symbol: <undetermined>. *)

  | MenhirState243 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 243.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState245 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 245.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState246 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 246.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState249 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_CALL_INDIRECT, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 249.
        Stack shape : LPAR CALL_INDIRECT var.
        Start symbol: <undetermined>. *)

  | MenhirState250 : (('s, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 250.
        Stack shape : type_use.
        Start symbol: <undetermined>. *)

  | MenhirState257 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 257.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState259 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 259.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState260 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 260.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState263 : ((('s, 'r) _menhir_cell1_CALL_INDIRECT, 'r) _menhir_cell1_var, 'r) _menhir_state
    (** State 263.
        Stack shape : CALL_INDIRECT var.
        Start symbol: <undetermined>. *)

  | MenhirState264 : (('s, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 264.
        Stack shape : type_use.
        Start symbol: <undetermined>. *)

  | MenhirState270 : (((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_state
    (** State 270.
        Stack shape : IF labeling_opt block.
        Start symbol: <undetermined>. *)

  | MenhirState272 : (((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_state
    (** State 272.
        Stack shape : IF labeling_opt block.
        Start symbol: <undetermined>. *)

  | MenhirState273 : ((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_cell1_labeling_end_opt, 'r) _menhir_state
    (** State 273.
        Stack shape : IF labeling_opt block labeling_end_opt.
        Start symbol: <undetermined>. *)

  | MenhirState275 : (((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_cell1_labeling_end_opt, 'r) _menhir_cell1_instr_list, 'r) _menhir_state
    (** State 275.
        Stack shape : IF labeling_opt block labeling_end_opt instr_list.
        Start symbol: <undetermined>. *)

  | MenhirState280 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_instr_list _menhir_cell0_RPAR _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 280.
        Stack shape : LPAR THEN instr_list RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState283 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 283.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState285 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 285.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState286 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 286.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState289 : (('s, 'r) _menhir_cell1_expr, 'r) _menhir_state
    (** State 289.
        Stack shape : expr.
        Start symbol: <undetermined>. *)

  | MenhirState290 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 290.
        Stack shape : expr LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState292 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 292.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState294 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 294.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState295 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 295.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState298 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 298.
        Stack shape : LPAR IF labeling_opt type_use.
        Start symbol: <undetermined>. *)

  | MenhirState304 : (((('s, 'r) _menhir_cell1_LOOP, 'r) _menhir_cell1_labeling_opt, 'r) _menhir_cell1_block, 'r) _menhir_state
    (** State 304.
        Stack shape : LOOP labeling_opt block.
        Start symbol: <undetermined>. *)

  | MenhirState312 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_ITEM, 'r) _menhir_state
    (** State 312.
        Stack shape : LPAR ITEM.
        Start symbol: <undetermined>. *)

  | MenhirState320 : ((('s, 'r) _menhir_cell1_ref_type _menhir_cell0_LPAR, 'r) _menhir_cell1_elem_expr, 'r) _menhir_state
    (** State 320.
        Stack shape : ref_type LPAR elem_expr.
        Start symbol: <undetermined>. *)

  | MenhirState323 : (('s, 'r) _menhir_cell1_elem_expr, 'r) _menhir_state
    (** State 323.
        Stack shape : elem_expr.
        Start symbol: <undetermined>. *)

  | MenhirState325 : (('s, 'r) _menhir_cell1_limits, 'r) _menhir_state
    (** State 325.
        Stack shape : limits.
        Start symbol: <undetermined>. *)

  | MenhirState327 : (('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_state
    (** State 327.
        Stack shape : inline_import.
        Start symbol: <undetermined>. *)

  | MenhirState329 : (('s, 'r) _menhir_cell1_inline_export, 'r) _menhir_state
    (** State 329.
        Stack shape : inline_export.
        Start symbol: <undetermined>. *)

  | MenhirState332 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 332.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState335 : (('s, _menhir_box_module1) _menhir_cell1_LPAR, _menhir_box_module1) _menhir_state
    (** State 335.
        Stack shape : LPAR.
        Start symbol: module1. *)

  | MenhirState337 : ((('s, _menhir_box_module1) _menhir_cell1_LPAR, _menhir_box_module1) _menhir_cell1_option_module_var_, _menhir_box_module1) _menhir_state
    (** State 337.
        Stack shape : LPAR option(module_var).
        Start symbol: module1. *)

  | MenhirState339 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 339.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState340 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 340.
        Stack shape : LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState341 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 341.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState342 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_DATA, 'r) _menhir_state
    (** State 342.
        Stack shape : LPAR DATA.
        Start symbol: <undetermined>. *)

  | MenhirState350 : (('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_state
    (** State 350.
        Stack shape : inline_import.
        Start symbol: <undetermined>. *)

  | MenhirState352 : (('s, 'r) _menhir_cell1_inline_export, 'r) _menhir_state
    (** State 352.
        Stack shape : inline_export.
        Start symbol: <undetermined>. *)

  | MenhirState354 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 354.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState355 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_state
    (** State 355.
        Stack shape : LPAR name.
        Start symbol: <undetermined>. *)

  | MenhirState358 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 358.
        Stack shape : LPAR name name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState359 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 359.
        Stack shape : LPAR name name LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState362 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 362.
        Stack shape : LPAR name name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState363 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 363.
        Stack shape : LPAR name name LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState366 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 366.
        Stack shape : LPAR name name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState367 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 367.
        Stack shape : LPAR name name LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState368 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 368.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState369 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_MUT, 'r) _menhir_state
    (** State 369.
        Stack shape : LPAR MUT.
        Start symbol: <undetermined>. *)

  | MenhirState375 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, 'r) _menhir_state
    (** State 375.
        Stack shape : LPAR name name LPAR FUNC.
        Start symbol: <undetermined>. *)

  | MenhirState376 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 376.
        Stack shape : LPAR name name LPAR FUNC bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState377 : (((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 377.
        Stack shape : LPAR name name LPAR FUNC bind_var_opt LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState384 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 384.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState385 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 385.
        Stack shape : LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState386 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 386.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState387 : (('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_state
    (** State 387.
        Stack shape : inline_import.
        Start symbol: <undetermined>. *)

  | MenhirState389 : (('s, 'r) _menhir_cell1_inline_export, 'r) _menhir_state
    (** State 389.
        Stack shape : inline_export.
        Start symbol: <undetermined>. *)

  | MenhirState390 : (('s, 'r) _menhir_cell1_global_type, 'r) _menhir_state
    (** State 390.
        Stack shape : global_type.
        Start symbol: <undetermined>. *)

  | MenhirState395 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_FUNC, 'r) _menhir_state
    (** State 395.
        Stack shape : LPAR FUNC.
        Start symbol: <undetermined>. *)

  | MenhirState396 : ((('s, 'r) _menhir_cell1_LPAR _menhir_cell0_FUNC, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 396.
        Stack shape : LPAR FUNC bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState397 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 397.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState398 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 398.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState400 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 400.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState401 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 401.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState402 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOCAL, 'r) _menhir_state
    (** State 402.
        Stack shape : LPAR LOCAL.
        Start symbol: <undetermined>. *)

  | MenhirState404 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOCAL, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 404.
        Stack shape : LPAR LOCAL list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState405 : (('s _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 405.
        Stack shape : RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState408 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOCAL, 'r) _menhir_cell1_bind_var, 'r) _menhir_state
    (** State 408.
        Stack shape : LPAR LOCAL bind_var.
        Start symbol: <undetermined>. *)

  | MenhirState410 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_LOCAL, 'r) _menhir_cell1_bind_var, 'r) _menhir_cell1_value_type _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 410.
        Stack shape : LPAR LOCAL bind_var value_type RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState414 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 414.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState416 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 416.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState417 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 417.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState420 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_state
    (** State 420.
        Stack shape : LPAR PARAM bind_var.
        Start symbol: <undetermined>. *)

  | MenhirState422 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_cell1_value_type _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 422.
        Stack shape : LPAR PARAM bind_var value_type RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState424 : (('s, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 424.
        Stack shape : type_use.
        Start symbol: <undetermined>. *)

  | MenhirState426 : (('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_state
    (** State 426.
        Stack shape : inline_import.
        Start symbol: <undetermined>. *)

  | MenhirState427 : ((('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 427.
        Stack shape : inline_import LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState428 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_state
    (** State 428.
        Stack shape : LPAR RESULT.
        Start symbol: <undetermined>. *)

  | MenhirState430 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 430.
        Stack shape : LPAR RESULT list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState431 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_RESULT, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 431.
        Stack shape : LPAR RESULT list(value_type) RPAR LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState433 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_state
    (** State 433.
        Stack shape : LPAR PARAM.
        Start symbol: <undetermined>. *)

  | MenhirState435 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 435.
        Stack shape : LPAR PARAM list(value_type) RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState436 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 436.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState439 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_state
    (** State 439.
        Stack shape : LPAR PARAM bind_var.
        Start symbol: <undetermined>. *)

  | MenhirState441 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_PARAM, 'r) _menhir_cell1_bind_var, 'r) _menhir_cell1_value_type _menhir_cell0_RPAR, 'r) _menhir_state
    (** State 441.
        Stack shape : LPAR PARAM bind_var value_type RPAR.
        Start symbol: <undetermined>. *)

  | MenhirState443 : ((('s, 'r) _menhir_cell1_inline_import, 'r) _menhir_cell1_type_use, 'r) _menhir_state
    (** State 443.
        Stack shape : inline_import type_use.
        Start symbol: <undetermined>. *)

  | MenhirState446 : (('s, 'r) _menhir_cell1_inline_export, 'r) _menhir_state
    (** State 446.
        Stack shape : inline_export.
        Start symbol: <undetermined>. *)

  | MenhirState451 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 451.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState454 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 454.
        Stack shape : LPAR name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState457 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 457.
        Stack shape : LPAR name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState460 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name _menhir_cell0_LPAR, 'r) _menhir_state
    (** State 460.
        Stack shape : LPAR name LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState463 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, 'r) _menhir_state
    (** State 463.
        Stack shape : LPAR name LPAR FUNC.
        Start symbol: <undetermined>. *)

  | MenhirState468 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 468.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState469 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 469.
        Stack shape : LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState470 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 470.
        Stack shape : LPAR bind_var_opt LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState471 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_TABLE, 'r) _menhir_state
    (** State 471.
        Stack shape : LPAR bind_var_opt LPAR TABLE.
        Start symbol: <undetermined>. *)

  | MenhirState474 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_OFFSET, 'r) _menhir_state
    (** State 474.
        Stack shape : LPAR OFFSET.
        Start symbol: <undetermined>. *)

  | MenhirState478 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_DECLARE, 'r) _menhir_state
    (** State 478.
        Stack shape : LPAR bind_var_opt DECLARE.
        Start symbol: <undetermined>. *)

  | MenhirState479 : (('s, 'r) _menhir_cell1_ref_type, 'r) _menhir_state
    (** State 479.
        Stack shape : ref_type.
        Start symbol: <undetermined>. *)

  | MenhirState483 : (('s, 'r) _menhir_cell1_elem_kind, 'r) _menhir_state
    (** State 483.
        Stack shape : elem_kind.
        Start symbol: <undetermined>. *)

  | MenhirState485 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_table_use, 'r) _menhir_state
    (** State 485.
        Stack shape : LPAR bind_var_opt table_use.
        Start symbol: <undetermined>. *)

  | MenhirState486 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 486.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState487 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_table_use, 'r) _menhir_cell1_offset, 'r) _menhir_state
    (** State 487.
        Stack shape : LPAR bind_var_opt table_use offset.
        Start symbol: <undetermined>. *)

  | MenhirState491 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_offset, 'r) _menhir_state
    (** State 491.
        Stack shape : LPAR bind_var_opt offset.
        Start symbol: <undetermined>. *)

  | MenhirState498 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 498.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState499 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_state
    (** State 499.
        Stack shape : LPAR bind_var_opt.
        Start symbol: <undetermined>. *)

  | MenhirState500 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 500.
        Stack shape : LPAR bind_var_opt LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState501 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_MEMORY, 'r) _menhir_state
    (** State 501.
        Stack shape : LPAR bind_var_opt LPAR MEMORY.
        Start symbol: <undetermined>. *)

  | MenhirState506 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_offset, 'r) _menhir_state
    (** State 506.
        Stack shape : LPAR bind_var_opt offset.
        Start symbol: <undetermined>. *)

  | MenhirState509 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_memory_use, 'r) _menhir_state
    (** State 509.
        Stack shape : LPAR bind_var_opt memory_use.
        Start symbol: <undetermined>. *)

  | MenhirState510 : ((((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_bind_var_opt, 'r) _menhir_cell1_memory_use, 'r) _menhir_cell1_offset, 'r) _menhir_state
    (** State 510.
        Stack shape : LPAR bind_var_opt memory_use offset.
        Start symbol: <undetermined>. *)

  | MenhirState513 : (('s, 'r) _menhir_cell1_type_def, 'r) _menhir_state
    (** State 513.
        Stack shape : type_def.
        Start symbol: <undetermined>. *)

  | MenhirState514 : (('s, 'r) _menhir_cell1_table, 'r) _menhir_state
    (** State 514.
        Stack shape : table.
        Start symbol: <undetermined>. *)

  | MenhirState515 : (('s, 'r) _menhir_cell1_start, 'r) _menhir_state
    (** State 515.
        Stack shape : start.
        Start symbol: <undetermined>. *)

  | MenhirState518 : (('s, 'r) _menhir_cell1_memory, 'r) _menhir_state
    (** State 518.
        Stack shape : memory.
        Start symbol: <undetermined>. *)

  | MenhirState520 : (('s, 'r) _menhir_cell1_import, 'r) _menhir_state
    (** State 520.
        Stack shape : import.
        Start symbol: <undetermined>. *)

  | MenhirState522 : (('s, 'r) _menhir_cell1_global, 'r) _menhir_state
    (** State 522.
        Stack shape : global.
        Start symbol: <undetermined>. *)

  | MenhirState524 : (('s, 'r) _menhir_cell1_func, 'r) _menhir_state
    (** State 524.
        Stack shape : func.
        Start symbol: <undetermined>. *)

  | MenhirState526 : (('s, 'r) _menhir_cell1_export, 'r) _menhir_state
    (** State 526.
        Stack shape : export.
        Start symbol: <undetermined>. *)

  | MenhirState528 : (('s, 'r) _menhir_cell1_elem, 'r) _menhir_state
    (** State 528.
        Stack shape : elem.
        Start symbol: <undetermined>. *)

  | MenhirState530 : (('s, 'r) _menhir_cell1_data, 'r) _menhir_state
    (** State 530.
        Stack shape : data.
        Start symbol: <undetermined>. *)

  | MenhirState543 : ('s, _menhir_box_script) _menhir_state
    (** State 543.
        Stack shape : .
        Start symbol: script. *)

  | MenhirState545 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 545.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState548 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_script_var_, 'r) _menhir_state
    (** State 548.
        Stack shape : LPAR option(script_var).
        Start symbol: <undetermined>. *)

  | MenhirState550 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 550.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState551 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_name, 'r) _menhir_state
    (** State 551.
        Stack shape : LPAR name.
        Start symbol: <undetermined>. *)

  | MenhirState554 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 554.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState559 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 559.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState560 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_state
    (** State 560.
        Stack shape : LPAR option(module_var).
        Start symbol: <undetermined>. *)

  | MenhirState561 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_cell1_QUOTE, 'r) _menhir_state
    (** State 561.
        Stack shape : LPAR option(module_var) QUOTE.
        Start symbol: <undetermined>. *)

  | MenhirState564 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_cell1_BIN, 'r) _menhir_state
    (** State 564.
        Stack shape : LPAR option(module_var) BIN.
        Start symbol: <undetermined>. *)

  | MenhirState567 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 567.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState568 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_state
    (** State 568.
        Stack shape : LPAR option(module_var).
        Start symbol: <undetermined>. *)

  | MenhirState569 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_cell1_name, 'r) _menhir_state
    (** State 569.
        Stack shape : LPAR option(module_var) name.
        Start symbol: <undetermined>. *)

  | MenhirState572 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_VEC_CONST _menhir_cell0_VEC_SHAPE, 'r) _menhir_state
    (** State 572.
        Stack shape : LPAR VEC_CONST VEC_SHAPE.
        Start symbol: <undetermined>. *)

  | MenhirState575 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_REF_NULL, 'r) _menhir_state
    (** State 575.
        Stack shape : LPAR REF_NULL.
        Start symbol: <undetermined>. *)

  | MenhirState581 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_CONST, 'r) _menhir_state
    (** State 581.
        Stack shape : LPAR CONST.
        Start symbol: <undetermined>. *)

  | MenhirState587 : (('s, 'r) _menhir_cell1_literal, 'r) _menhir_state
    (** State 587.
        Stack shape : literal.
        Start symbol: <undetermined>. *)

  | MenhirState591 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 591.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState595 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 595.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState596 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_option_module_var_, 'r) _menhir_state
    (** State 596.
        Stack shape : LPAR option(module_var).
        Start symbol: <undetermined>. *)

  | MenhirState599 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 599.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState605 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 605.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState613 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 613.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState615 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_action, 'r) _menhir_state
    (** State 615.
        Stack shape : LPAR action.
        Start symbol: <undetermined>. *)

  | MenhirState618 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_VEC_CONST _menhir_cell0_VEC_SHAPE, 'r) _menhir_state
    (** State 618.
        Stack shape : LPAR VEC_CONST VEC_SHAPE.
        Start symbol: <undetermined>. *)

  | MenhirState620 : (('s, 'r) _menhir_cell1_numpat, 'r) _menhir_state
    (** State 620.
        Stack shape : numpat.
        Start symbol: <undetermined>. *)

  | MenhirState629 : (('s, 'r) _menhir_cell1_LPAR _menhir_cell0_CONST, 'r) _menhir_state
    (** State 629.
        Stack shape : LPAR CONST.
        Start symbol: <undetermined>. *)

  | MenhirState632 : (('s, 'r) _menhir_cell1_result, 'r) _menhir_state
    (** State 632.
        Stack shape : result.
        Start symbol: <undetermined>. *)

  | MenhirState638 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 638.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState642 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 642.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState646 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
    (** State 646.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

  | MenhirState654 : (('s, 'r) _menhir_cell1_cmd, 'r) _menhir_state
    (** State 654.
        Stack shape : cmd.
        Start symbol: <undetermined>. *)

  | MenhirState664 : ('s, _menhir_box_script1) _menhir_state
    (** State 664.
        Stack shape : .
        Start symbol: script1. *)

  | MenhirState666 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 666.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState667 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_script_var_, _menhir_box_script1) _menhir_state
    (** State 667.
        Stack shape : LPAR option(script_var).
        Start symbol: script1. *)

  | MenhirState670 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 670.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState671 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_name, _menhir_box_script1) _menhir_state
    (** State 671.
        Stack shape : LPAR name.
        Start symbol: script1. *)

  | MenhirState674 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 674.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState679 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 679.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState680 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_state
    (** State 680.
        Stack shape : LPAR option(module_var).
        Start symbol: script1. *)

  | MenhirState681 : (((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_QUOTE, _menhir_box_script1) _menhir_state
    (** State 681.
        Stack shape : LPAR option(module_var) QUOTE.
        Start symbol: script1. *)

  | MenhirState684 : (((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_BIN, _menhir_box_script1) _menhir_state
    (** State 684.
        Stack shape : LPAR option(module_var) BIN.
        Start symbol: script1. *)

  | MenhirState689 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 689.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState690 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_state
    (** State 690.
        Stack shape : LPAR option(module_var).
        Start symbol: script1. *)

  | MenhirState691 : (((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_name, _menhir_box_script1) _menhir_state
    (** State 691.
        Stack shape : LPAR option(module_var) name.
        Start symbol: script1. *)

  | MenhirState694 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 694.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState698 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 698.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState699 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_state
    (** State 699.
        Stack shape : LPAR option(module_var).
        Start symbol: script1. *)

  | MenhirState702 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 702.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState706 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 706.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState713 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 713.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState714 : ((('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_action, _menhir_box_script1) _menhir_state
    (** State 714.
        Stack shape : LPAR action.
        Start symbol: script1. *)

  | MenhirState717 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 717.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState721 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 721.
        Stack shape : LPAR.
        Start symbol: script1. *)

  | MenhirState725 : (('s, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_state
    (** State 725.
        Stack shape : LPAR.
        Start symbol: script1. *)


and ('s, 'r) _menhir_cell1_action = 
  | MenhirCell1_action of 's * ('s, 'r) _menhir_state * (Script.action) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_bind_var = 
  | MenhirCell1_bind_var of 's * ('s, 'r) _menhir_state * (string Source.phrase) * Lexing.position

and ('s, 'r) _menhir_cell1_bind_var_opt = 
  | MenhirCell1_bind_var_opt of 's * ('s, 'r) _menhir_state * (context ->
  (context -> int32) -> (context -> string Source.phrase -> int32) -> int32)

and ('s, 'r) _menhir_cell1_block = 
  | MenhirCell1_block of 's * ('s, 'r) _menhir_state * (context -> Ast.block_type * Ast.instr list)

and ('s, 'r) _menhir_cell1_cmd = 
  | MenhirCell1_cmd of 's * ('s, 'r) _menhir_state * (Script.command)

and ('s, 'r) _menhir_cell1_data = 
  | MenhirCell1_data of 's * ('s, 'r) _menhir_state * (context -> unit -> Ast.data_segment) * Lexing.position

and ('s, 'r) _menhir_cell1_elem = 
  | MenhirCell1_elem of 's * ('s, 'r) _menhir_state * (context -> unit -> Ast.elem_segment) * Lexing.position

and ('s, 'r) _menhir_cell1_elem_expr = 
  | MenhirCell1_elem_expr of 's * ('s, 'r) _menhir_state * (context -> Ast.const)

and ('s, 'r) _menhir_cell1_elem_kind = 
  | MenhirCell1_elem_kind of 's * ('s, 'r) _menhir_state * (Types.ref_type)

and ('s, 'r) _menhir_cell1_export = 
  | MenhirCell1_export of 's * ('s, 'r) _menhir_state * (context -> Ast.export) * Lexing.position

and ('s, 'r) _menhir_cell1_expr = 
  | MenhirCell1_expr of 's * ('s, 'r) _menhir_state * (context -> Ast.instr list) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_func = 
  | MenhirCell1_func of 's * ('s, 'r) _menhir_state * (context -> unit -> Ast.func list * Ast.import list * Ast.export list) * Lexing.position

and ('s, 'r) _menhir_cell1_global = 
  | MenhirCell1_global of 's * ('s, 'r) _menhir_state * (context -> unit -> Ast.global list * Ast.import list * Ast.export list) * Lexing.position

and ('s, 'r) _menhir_cell1_global_type = 
  | MenhirCell1_global_type of 's * ('s, 'r) _menhir_state * (Types.global_type)

and ('s, 'r) _menhir_cell1_import = 
  | MenhirCell1_import of 's * ('s, 'r) _menhir_state * (context -> unit -> Ast.import) * Lexing.position

and ('s, 'r) _menhir_cell1_inline_export = 
  | MenhirCell1_inline_export of 's * ('s, 'r) _menhir_state * (Ast.export_desc' -> context -> Ast.export)

and ('s, 'r) _menhir_cell1_inline_import = 
  | MenhirCell1_inline_import of 's * ('s, 'r) _menhir_state * (Utf8.unicode * Utf8.unicode)

and ('s, 'r) _menhir_cell1_instr1 = 
  | MenhirCell1_instr1 of 's * ('s, 'r) _menhir_state * (context -> Ast.instr list) * Lexing.position

and ('s, 'r) _menhir_cell1_instr_list = 
  | MenhirCell1_instr_list of 's * ('s, 'r) _menhir_state * (context -> Ast.instr list) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_labeling_end_opt = 
  | MenhirCell1_labeling_end_opt of 's * ('s, 'r) _menhir_state * (string Source.phrase list) * Lexing.position

and ('s, 'r) _menhir_cell1_labeling_opt = 
  | MenhirCell1_labeling_opt of 's * ('s, 'r) _menhir_state * (context -> string Source.phrase list -> context)

and ('s, 'r) _menhir_cell1_limits = 
  | MenhirCell1_limits of 's * ('s, 'r) _menhir_state * (int32 Types.limits)

and ('s, 'r) _menhir_cell1_list_value_type_ = 
  | MenhirCell1_list_value_type_ of 's * ('s, 'r) _menhir_state * (Types.value_type list)

and ('s, 'r) _menhir_cell1_literal = 
  | MenhirCell1_literal of 's * ('s, 'r) _menhir_state * (Values.value Source.phrase)

and ('s, 'r) _menhir_cell1_memory = 
  | MenhirCell1_memory of 's * ('s, 'r) _menhir_state * (context ->
  unit ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list) * Lexing.position

and ('s, 'r) _menhir_cell1_memory_use = 
  | MenhirCell1_memory_use of 's * ('s, 'r) _menhir_state * (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase)

and ('s, 'r) _menhir_cell1_name = 
  | MenhirCell1_name of 's * ('s, 'r) _menhir_state * (Utf8.unicode)

and ('s, 'r) _menhir_cell1_num = 
  | MenhirCell1_num of 's * ('s, 'r) _menhir_state * (string Source.phrase) * Lexing.position

and ('s, 'r) _menhir_cell1_numpat = 
  | MenhirCell1_numpat of 's * ('s, 'r) _menhir_state * (V128.shape -> Script.num_pat)

and ('s, 'r) _menhir_cell1_offset = 
  | MenhirCell1_offset of 's * ('s, 'r) _menhir_state * (context -> Ast.const)

and ('s, 'r) _menhir_cell1_offset_opt = 
  | MenhirCell1_offset_opt of 's * ('s, 'r) _menhir_state * (int32)

and ('s, 'r) _menhir_cell1_option_module_var_ = 
  | MenhirCell1_option_module_var_ of 's * ('s, 'r) _menhir_state * (Script.var option)

and ('s, 'r) _menhir_cell1_option_script_var_ = 
  | MenhirCell1_option_script_var_ of 's * ('s, 'r) _menhir_state * (Script.var option)

and ('s, 'r) _menhir_cell1_plain_instr = 
  | MenhirCell1_plain_instr of 's * ('s, 'r) _menhir_state * (context -> Ast.instr') * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_ref_type = 
  | MenhirCell1_ref_type of 's * ('s, 'r) _menhir_state * (Types.ref_type)

and ('s, 'r) _menhir_cell1_result = 
  | MenhirCell1_result of 's * ('s, 'r) _menhir_state * (Script.result' Source.phrase)

and ('s, 'r) _menhir_cell1_start = 
  | MenhirCell1_start of 's * ('s, 'r) _menhir_state * (context -> Ast.start' Source.phrase) * Lexing.position

and ('s, 'r) _menhir_cell1_string_list = 
  | MenhirCell1_string_list of 's * ('s, 'r) _menhir_state * (string)

and ('s, 'r) _menhir_cell1_table = 
  | MenhirCell1_table of 's * ('s, 'r) _menhir_state * (context ->
  unit ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list) * Lexing.position

and ('s, 'r) _menhir_cell1_table_use = 
  | MenhirCell1_table_use of 's * ('s, 'r) _menhir_state * (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase)

and ('s, 'r) _menhir_cell1_type_def = 
  | MenhirCell1_type_def of 's * ('s, 'r) _menhir_state * (context -> int32) * Lexing.position

and ('s, 'r) _menhir_cell1_type_use = 
  | MenhirCell1_type_use of 's * ('s, 'r) _menhir_state * (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_value_type = 
  | MenhirCell1_value_type of 's * ('s, 'r) _menhir_state * (Types.value_type)

and ('s, 'r) _menhir_cell1_var = 
  | MenhirCell1_var of 's * ('s, 'r) _menhir_state * (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase) * Lexing.position

and ('s, 'r) _menhir_cell1_BIN = 
  | MenhirCell1_BIN of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_BLOCK = 
  | MenhirCell1_BLOCK of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_BR = 
  | MenhirCell1_BR of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_BR_IF = 
  | MenhirCell1_BR_IF of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_BR_TABLE = 
  | MenhirCell1_BR_TABLE of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_CALL = 
  | MenhirCell1_CALL of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_CALL_INDIRECT = 
  | MenhirCell1_CALL_INDIRECT of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_CONST = 
  | MenhirCell1_CONST of 's * ('s, 'r) _menhir_state * (
# 219 "interpreter/text/parser.mly"
      (string Source.phrase -> Ast.instr' * Values.num)
# 2059 "interpreter/text/parser.ml"
) * Lexing.position

and 's _menhir_cell0_CONST = 
  | MenhirCell0_CONST of 's * (
# 219 "interpreter/text/parser.mly"
      (string Source.phrase -> Ast.instr' * Values.num)
# 2066 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_DATA = 
  | MenhirCell1_DATA of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_DATA_DROP = 
  | MenhirCell1_DATA_DROP of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_DECLARE = 
  | MenhirCell1_DECLARE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_ELEM_DROP = 
  | MenhirCell1_ELEM_DROP of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_EXPORT = 
  | MenhirCell1_EXPORT of 's * ('s, 'r) _menhir_state

and 's _menhir_cell0_FUNC = 
  | MenhirCell0_FUNC of 's * Lexing.position

and ('s, 'r) _menhir_cell1_GLOBAL_GET = 
  | MenhirCell1_GLOBAL_GET of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_GLOBAL_SET = 
  | MenhirCell1_GLOBAL_SET of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_IF = 
  | MenhirCell1_IF of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_IMPORT = 
  | MenhirCell1_IMPORT of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_ITEM = 
  | MenhirCell1_ITEM of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_LOAD = 
  | MenhirCell1_LOAD of 's * ('s, 'r) _menhir_state * (
# 217 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 2106 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_LOCAL = 
  | MenhirCell1_LOCAL of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_LOCAL_GET = 
  | MenhirCell1_LOCAL_GET of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_LOCAL_SET = 
  | MenhirCell1_LOCAL_SET of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_LOCAL_TEE = 
  | MenhirCell1_LOCAL_TEE of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_LOOP = 
  | MenhirCell1_LOOP of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_LPAR = 
  | MenhirCell1_LPAR of 's * ('s, 'r) _menhir_state * Lexing.position

and 's _menhir_cell0_LPAR = 
  | MenhirCell0_LPAR of 's * Lexing.position

and ('s, 'r) _menhir_cell1_MEMORY = 
  | MenhirCell1_MEMORY of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_MEMORY_INIT = 
  | MenhirCell1_MEMORY_INIT of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_MUT = 
  | MenhirCell1_MUT of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_OFFSET = 
  | MenhirCell1_OFFSET of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_PARAM = 
  | MenhirCell1_PARAM of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_QUOTE = 
  | MenhirCell1_QUOTE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_REF_FUNC = 
  | MenhirCell1_REF_FUNC of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_REF_NULL = 
  | MenhirCell1_REF_NULL of 's * ('s, 'r) _menhir_state * Lexing.position

and 's _menhir_cell0_REF_NULL = 
  | MenhirCell0_REF_NULL of 's * Lexing.position

and ('s, 'r) _menhir_cell1_RESULT = 
  | MenhirCell1_RESULT of 's * ('s, 'r) _menhir_state

and 's _menhir_cell0_RPAR = 
  | MenhirCell0_RPAR of 's * Lexing.position

and ('s, 'r) _menhir_cell1_SELECT = 
  | MenhirCell1_SELECT of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_STORE = 
  | MenhirCell1_STORE of 's * ('s, 'r) _menhir_state * (
# 217 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 2170 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE = 
  | MenhirCell1_TABLE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_TABLE_COPY = 
  | MenhirCell1_TABLE_COPY of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_FILL = 
  | MenhirCell1_TABLE_FILL of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_GET = 
  | MenhirCell1_TABLE_GET of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_GROW = 
  | MenhirCell1_TABLE_GROW of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_INIT = 
  | MenhirCell1_TABLE_INIT of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_SET = 
  | MenhirCell1_TABLE_SET of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TABLE_SIZE = 
  | MenhirCell1_TABLE_SIZE of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_THEN = 
  | MenhirCell1_THEN of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_TYPE = 
  | MenhirCell1_TYPE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_VEC_CONST = 
  | MenhirCell1_VEC_CONST of 's * ('s, 'r) _menhir_state * (
# 224 "interpreter/text/parser.mly"
      (V128.shape -> string Source.phrase list -> Source.region -> Ast.instr' * Values.vec)
# 2207 "interpreter/text/parser.ml"
) * Lexing.position

and 's _menhir_cell0_VEC_CONST = 
  | MenhirCell0_VEC_CONST of 's * (
# 224 "interpreter/text/parser.mly"
      (V128.shape -> string Source.phrase list -> Source.region -> Ast.instr' * Values.vec)
# 2214 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_VEC_LOAD = 
  | MenhirCell1_VEC_LOAD of 's * ('s, 'r) _menhir_state * (
# 222 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 2221 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_VEC_LOAD_LANE = 
  | MenhirCell1_VEC_LOAD_LANE of 's * ('s, 'r) _menhir_state * (
# 223 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> int -> Ast.instr')
# 2228 "interpreter/text/parser.ml"
) * Lexing.position

and 's _menhir_cell0_VEC_SHAPE = 
  | MenhirCell0_VEC_SHAPE of 's * (
# 208 "interpreter/text/parser.mly"
      (V128.shape)
# 2235 "interpreter/text/parser.ml"
)

and ('s, 'r) _menhir_cell1_VEC_SHUFFLE = 
  | MenhirCell1_VEC_SHUFFLE of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_VEC_STORE = 
  | MenhirCell1_VEC_STORE of 's * ('s, 'r) _menhir_state * (
# 222 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> Ast.instr')
# 2245 "interpreter/text/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_VEC_STORE_LANE = 
  | MenhirCell1_VEC_STORE_LANE of 's * ('s, 'r) _menhir_state * (
# 223 "interpreter/text/parser.mly"
      (int option -> Memory.offset -> int -> Ast.instr')
# 2252 "interpreter/text/parser.ml"
) * Lexing.position

and _menhir_box_script1 = 
  | MenhirBox_script1 of (Script.script) [@@unboxed]

and _menhir_box_script = 
  | MenhirBox_script of (Script.script) [@@unboxed]

and _menhir_box_module1 = 
  | MenhirBox_module1 of (Script.var option * Script.definition) [@@unboxed]

let _menhir_action_003 =
  fun _3 _4 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1006 "interpreter/text/parser.mly"
    ( Invoke (_3, _4, _5) @@ _sloc )
# 2272 "interpreter/text/parser.ml"
     : (Script.action))

let _menhir_action_004 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1008 "interpreter/text/parser.mly"
    ( Get (_3, _4) @@ _sloc )
# 2283 "interpreter/text/parser.ml"
     : (Script.action))

let _menhir_action_005 =
  fun () ->
    (
# 348 "interpreter/text/parser.mly"
                ( None )
# 2291 "interpreter/text/parser.ml"
     : (int option))

let _menhir_action_006 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 350 "interpreter/text/parser.mly"
    ( let n = nat _1 _sloc in
      if not (Lib.Int.is_power_of_two n) then
        error (at _sloc) "alignment must be a power of two";
      Some (Lib.Int.log2 n) )
# 2305 "interpreter/text/parser.ml"
     : (int option))

let _menhir_action_007 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1012 "interpreter/text/parser.mly"
    ( AssertMalformed (snd _3, _4) @@ _sloc )
# 2316 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_008 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1014 "interpreter/text/parser.mly"
    ( AssertInvalid (snd _3, _4) @@ _sloc )
# 2327 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_009 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1016 "interpreter/text/parser.mly"
    ( AssertUnlinkable (snd _3, _4) @@ _sloc )
# 2338 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_010 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1018 "interpreter/text/parser.mly"
    ( AssertUninstantiable (snd _3, _4) @@ _sloc )
# 2349 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_011 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1019 "interpreter/text/parser.mly"
                                                ( AssertReturn (_3, _4) @@ _sloc )
# 2360 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_012 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1020 "interpreter/text/parser.mly"
                                        ( AssertTrap (_3, _4) @@ _sloc )
# 2371 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_013 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1021 "interpreter/text/parser.mly"
                                              ( AssertExhaustion (_3, _4) @@ _sloc )
# 2382 "interpreter/text/parser.ml"
     : (Script.assertion))

let _menhir_action_014 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 326 "interpreter/text/parser.mly"
        ( _1 @@ _sloc )
# 2393 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_015 =
  fun () ->
    (
# 322 "interpreter/text/parser.mly"
                ( fun c anon bind -> anon c )
# 2401 "interpreter/text/parser.ml"
     : (context ->
  (context -> int32) -> (context -> string Source.phrase -> int32) -> int32))

let _menhir_action_016 =
  fun _1 ->
    (
# 323 "interpreter/text/parser.mly"
             ( fun c anon bind -> bind c _1 )
# 2410 "interpreter/text/parser.ml"
     : (context ->
  (context -> int32) -> (context -> string Source.phrase -> int32) -> int32))

let _menhir_action_017 =
  fun _1 _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 499 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c ->
      VarBlockType (inline_type_explicit c (_1 c type_) (fst _2) at1),
      snd _2 c )
# 2423 "interpreter/text/parser.ml"
     : (context -> Ast.block_type * Ast.instr list))

let _menhir_action_018 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = if _startpos__1_ != _endpos__1_ then
      _startpos__1_
    else
      _endpos in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 504 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c ->
      let bt =
        match fst _1 with
        | FuncType ([], []) -> ValBlockType None
        | FuncType ([], [t]) -> ValBlockType (Some t)
        | ft ->  VarBlockType (inline_type c ft at)
      in bt, snd _1 c )
# 2444 "interpreter/text/parser.ml"
     : (context -> Ast.block_type * Ast.instr list))

let _menhir_action_019 =
  fun _2 _3 _5 ->
    (
# 488 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c _5 in let bt, es = _3 c' in block bt es )
# 2452 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_020 =
  fun _2 _3 _5 ->
    (
# 490 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c _5 in let bt, es = _3 c' in loop bt es )
# 2460 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_021 =
  fun _2 _3 _5 ->
    (
# 492 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c _5 in let bt, es = _3 c' in if_ bt es [] )
# 2468 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_022 =
  fun _2 _3 _5 _6 _8 ->
    (
# 494 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c (_5 @ _8) in
      let ts, es1 = _3 c' in if_ ts es1 (_6 c') )
# 2477 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_023 =
  fun _1 ->
    (
# 514 "interpreter/text/parser.mly"
                      ( _1 )
# 2485 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.instr list)))

let _menhir_action_024 =
  fun _3 _5 ->
    (
# 516 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (_3 @ ins, out), snd _5 )
# 2494 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.instr list)))

let _menhir_action_025 =
  fun _1 ->
    (
# 520 "interpreter/text/parser.mly"
               ( FuncType ([], []), _1 )
# 2502 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.instr list)))

let _menhir_action_026 =
  fun _3 _5 ->
    (
# 522 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (ins, _3 @ out), snd _5 )
# 2511 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.instr list)))

let _menhir_action_027 =
  fun _3 _5 ->
    (
# 566 "interpreter/text/parser.mly"
    ( fun c ->
      let FuncType (ts1, ts2), es = _5 c in FuncType (_3 @ ts1, ts2), es )
# 2520 "interpreter/text/parser.ml"
     : (context -> Types.func_type * Ast.instr' Source.phrase list))

let _menhir_action_028 =
  fun _1 ->
    (
# 569 "interpreter/text/parser.mly"
    ( fun c -> let ts, es = _1 c in FuncType ([], ts), es )
# 2528 "interpreter/text/parser.ml"
     : (context -> Types.func_type * Ast.instr' Source.phrase list))

let _menhir_action_029 =
  fun _3 _5 ->
    (
# 573 "interpreter/text/parser.mly"
    ( fun c -> let ts, es = _5 c in _3 @ ts, es )
# 2536 "interpreter/text/parser.ml"
     : (context -> Types.result_type * Ast.instr' Source.phrase list))

let _menhir_action_030 =
  fun _1 ->
    (
# 575 "interpreter/text/parser.mly"
    ( fun c -> [], _1 c )
# 2544 "interpreter/text/parser.ml"
     : (context -> Types.result_type * Ast.instr' Source.phrase list))

let _menhir_action_031 =
  fun _1 _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 555 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c ->
      match _2 c with
      | FuncType ([], []), es -> _1 c type_, es
      | ft, es -> inline_type_explicit c (_1 c type_) ft at1, es )
# 2557 "interpreter/text/parser.ml"
     : (context -> Ast.var * Ast.instr' Source.phrase list))

let _menhir_action_032 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 561 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c -> let ft, es = _1 c in inline_type c ft at1, es )
# 2567 "interpreter/text/parser.ml"
     : (context -> Ast.var * Ast.instr' Source.phrase list))

let _menhir_action_033 =
  fun _2 _3 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 453 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c -> let x, es = _3 c in
      (call_indirect (_2 c table) x @@ at1) :: es )
# 2578 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_034 =
  fun _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 457 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c -> let x, es = _2 c in
      (call_indirect (0l @@ at1) x @@ at1) :: es )
# 2589 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_035 =
  fun _3 _5 ->
    (
# 474 "interpreter/text/parser.mly"
    ( fun c ->
      let FuncType (ts1, ts2), es = _5 c in FuncType (_3 @ ts1, ts2), es )
# 2598 "interpreter/text/parser.ml"
     : (context -> Types.func_type * Ast.instr list))

let _menhir_action_036 =
  fun _1 ->
    (
# 477 "interpreter/text/parser.mly"
    ( fun c -> let ts, es = _1 c in FuncType ([], ts), es )
# 2606 "interpreter/text/parser.ml"
     : (context -> Types.func_type * Ast.instr list))

let _menhir_action_037 =
  fun _3 _5 ->
    (
# 481 "interpreter/text/parser.mly"
    ( fun c -> let ts, es = _5 c in _3 @ ts, es )
# 2614 "interpreter/text/parser.ml"
     : (context -> Types.result_type * Ast.instr list))

let _menhir_action_038 =
  fun _1 ->
    (
# 483 "interpreter/text/parser.mly"
    ( fun c -> [], _1 c )
# 2622 "interpreter/text/parser.ml"
     : (context -> Types.result_type * Ast.instr list))

let _menhir_action_039 =
  fun _1 _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 463 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c ->
      match _2 c with
      | FuncType ([], []), es -> _1 c type_, es
      | ft, es -> inline_type_explicit c (_1 c type_) ft at1, es )
# 2635 "interpreter/text/parser.ml"
     : (context -> int32 Source.phrase * Ast.instr list))

let _menhir_action_040 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = if _startpos__1_ != _endpos__1_ then
      _startpos__1_
    else
      _endpos in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 469 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> let ft, es = _1 c in inline_type c ft at, es )
# 2650 "interpreter/text/parser.ml"
     : (context -> int32 Source.phrase * Ast.instr list))

let _menhir_action_041 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1024 "interpreter/text/parser.mly"
           ( Action _1 @@ _sloc )
# 2661 "interpreter/text/parser.ml"
     : (Script.command))

let _menhir_action_042 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1025 "interpreter/text/parser.mly"
              ( Assertion _1 @@ _sloc )
# 2672 "interpreter/text/parser.ml"
     : (Script.command))

let _menhir_action_043 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1026 "interpreter/text/parser.mly"
                  ( Module (fst _1, snd _1) @@ _sloc )
# 2683 "interpreter/text/parser.ml"
     : (Script.command))

let _menhir_action_044 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1027 "interpreter/text/parser.mly"
                                               ( Register (_3, _4) @@ _sloc )
# 2694 "interpreter/text/parser.ml"
     : (Script.command))

let _menhir_action_045 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1028 "interpreter/text/parser.mly"
         ( Meta _1 @@ _sloc )
# 2705 "interpreter/text/parser.ml"
     : (Script.command))

let _menhir_action_046 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = if _startpos__1_ != _endpos__1_ then
      _startpos__1_
    else
      _endpos in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 620 "interpreter/text/parser.mly"
               ( let at = _sloc in fun c -> _1 c @@ at )
# 2719 "interpreter/text/parser.ml"
     : (context -> Ast.const))

let _menhir_action_047 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 801 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_data bind_data);
      fun () -> {dinit = _4; dmode = Passive @@ at} @@ at )
# 2732 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.data_segment))

let _menhir_action_048 =
  fun _3 _4 _5 _6 _endpos__7_ _startpos__1_ ->
    let _endpos = _endpos__7_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 805 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_data bind_data);
      fun () ->
      {dinit = _6; dmode = Active {index = _4 c memory; offset = _5 c} @@ at} @@ at )
# 2746 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.data_segment))

let _menhir_action_049 =
  fun _3 _4 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 810 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_data bind_data);
      fun () ->
      {dinit = _5; dmode = Active {index = 0l @@ at; offset = _4 c} @@ at} @@ at )
# 2760 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.data_segment))

let _menhir_action_050 =
  fun _3 ->
    (
# 276 "interpreter/text/parser.mly"
                             ( _3 )
# 2768 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_051 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 735 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_elem bind_elem);
      fun () ->
      { etype = (fst _4); einit = (snd _4) c; emode = Passive @@ at } @@ at )
# 2782 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.elem_segment))

let _menhir_action_052 =
  fun _3 _4 _5 _6 _endpos__7_ _startpos__1_ ->
    let _endpos = _endpos__7_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 740 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_elem bind_elem);
      fun () ->
      { etype = (fst _6); einit = (snd _6) c;
        emode = Active {index = _4 c table; offset = _5 c} @@ at } @@ at )
# 2797 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.elem_segment))

let _menhir_action_053 =
  fun _3 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 746 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_elem bind_elem);
      fun () ->
      { etype = (fst _5); einit = (snd _5) c; emode = Declarative @@ at } @@ at )
# 2811 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.elem_segment))

let _menhir_action_054 =
  fun _3 _4 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 751 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_elem bind_elem);
      fun () ->
      { etype = (fst _5); einit = (snd _5) c;
        emode = Active {index = 0l @@ at; offset = _4 c} @@ at } @@ at )
# 2826 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.elem_segment))

let _menhir_action_055 =
  fun _3 _4 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 757 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> ignore (_3 c anon_elem bind_elem);
      fun () ->
      { etype = FuncRefType; einit = _5 c;
        emode = Active {index = 0l @@ at; offset = _4 c} @@ at } @@ at )
# 2841 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.elem_segment))

let _menhir_action_056 =
  fun _3 ->
    (
# 714 "interpreter/text/parser.mly"
                              ( _3 )
# 2849 "interpreter/text/parser.ml"
     : (context -> Ast.const))

let _menhir_action_057 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 715 "interpreter/text/parser.mly"
         ( let at = _sloc in fun c -> _1 c @@ at )
# 2860 "interpreter/text/parser.ml"
     : (context -> Ast.const))

let _menhir_action_058 =
  fun () ->
    (
# 718 "interpreter/text/parser.mly"
                ( fun c -> [] )
# 2868 "interpreter/text/parser.ml"
     : (context -> Ast.const list))

let _menhir_action_059 =
  fun _1 _2 ->
    (
# 719 "interpreter/text/parser.mly"
                             ( fun c -> _1 c :: _2 c )
# 2876 "interpreter/text/parser.ml"
     : (context -> Ast.const list))

let _menhir_action_060 =
  fun () ->
    (
# 711 "interpreter/text/parser.mly"
         ( FuncRefType )
# 2884 "interpreter/text/parser.ml"
     : (Types.ref_type))

let _menhir_action_061 =
  fun _1 _2 ->
    (
# 728 "interpreter/text/parser.mly"
    ( (_1, fun c -> _2 c) )
# 2892 "interpreter/text/parser.ml"
     : (Types.ref_type * (context -> Ast.const list)))

let _menhir_action_062 =
  fun _1 _2 ->
    (
# 730 "interpreter/text/parser.mly"
    ( (_1, fun c -> _2 c) )
# 2900 "interpreter/text/parser.ml"
     : (Types.ref_type * (context -> Ast.const list)))

let _menhir_action_063 =
  fun _1 ->
    (
# 723 "interpreter/text/parser.mly"
    ( let f = function {at = at'; _} as x -> Source.([ref_func x @@ at'] @@ at') in
      fun c -> List.map f (_1 c func) )
# 2909 "interpreter/text/parser.ml"
     : (context -> Ast.const list))

let _menhir_action_064 =
  fun _3 _4 _endpos__4_ _endpos__5_ _startpos__1_ _startpos__4_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _loc__4_ = (_startpos__4_, _endpos__4_) in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 896 "interpreter/text/parser.mly"
    ( let at = _sloc and at4 = _loc__4_ in
      fun c -> {name = _3; edesc = _4 c @@ at4} @@ at )
# 2922 "interpreter/text/parser.ml"
     : (context -> Ast.export))

let _menhir_action_065 =
  fun _3 ->
    (
# 889 "interpreter/text/parser.mly"
                       ( fun c -> FuncExport (_3 c func) )
# 2930 "interpreter/text/parser.ml"
     : (context -> Ast.export_desc'))

let _menhir_action_066 =
  fun _3 ->
    (
# 890 "interpreter/text/parser.mly"
                        ( fun c -> TableExport (_3 c table) )
# 2938 "interpreter/text/parser.ml"
     : (context -> Ast.export_desc'))

let _menhir_action_067 =
  fun _3 ->
    (
# 891 "interpreter/text/parser.mly"
                         ( fun c -> MemoryExport (_3 c memory) )
# 2946 "interpreter/text/parser.ml"
     : (context -> Ast.export_desc'))

let _menhir_action_068 =
  fun _3 ->
    (
# 892 "interpreter/text/parser.mly"
                         ( fun c -> GlobalExport (_3 c global) )
# 2954 "interpreter/text/parser.ml"
     : (context -> Ast.export_desc'))

let _menhir_action_069 =
  fun _2 _endpos__3_ _startpos__1_ ->
    let _endpos = _endpos__3_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 528 "interpreter/text/parser.mly"
    ( let at = _sloc in fun c -> let es, e' = _2 c in es @ [e' @@ at] )
# 2965 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_070 =
  fun _1 _2 ->
    (
# 531 "interpreter/text/parser.mly"
                          ( fun c -> _2 c, _1 c )
# 2973 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_071 =
  fun _2 ->
    (
# 533 "interpreter/text/parser.mly"
    ( fun c -> let b, ts, es = _2 c in es, select (if b then (Some ts) else None) )
# 2981 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_072 =
  fun _2 _3 ->
    (
# 535 "interpreter/text/parser.mly"
    ( fun c -> let x, es = _3 c in es, call_indirect (_2 c table) x )
# 2989 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_073 =
  fun _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 537 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c -> let x, es = _2 c in es, call_indirect (0l @@ at1) x )
# 2999 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_074 =
  fun _2 _3 ->
    (
# 540 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c [] in let bt, es = _3 c' in [], block bt es )
# 3007 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_075 =
  fun _2 _3 ->
    (
# 542 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c [] in let bt, es = _3 c' in [], loop bt es )
# 3015 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_076 =
  fun _2 _3 ->
    (
# 544 "interpreter/text/parser.mly"
    ( fun c -> let c' = _2 c [] in
      let bt, (es, es1, es2) = _3 c c' in es, if_ bt es1 es2 )
# 3024 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list * Ast.instr'))

let _menhir_action_077 =
  fun () ->
    (
# 616 "interpreter/text/parser.mly"
                ( fun c -> [] )
# 3032 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list))

let _menhir_action_078 =
  fun _1 _2 ->
    (
# 617 "interpreter/text/parser.mly"
                   ( fun c -> _1 c @ _2 c )
# 3040 "interpreter/text/parser.ml"
     : (context -> Ast.instr' Source.phrase list))

let _menhir_action_079 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 627 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> let x = _3 c anon_func bind_func @@ at in fun () -> _4 c x at )
# 3052 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_080 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = if _startpos__1_ != _endpos__1_ then
      _startpos__1_
    else
      _endpos in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 688 "interpreter/text/parser.mly"
    ( fun c -> let c' = anon_label c in
      {ftype = -1l @@ _sloc; locals = []; body = _1 c'} )
# 3067 "interpreter/text/parser.ml"
     : (context -> Ast.func'))

let _menhir_action_081 =
  fun _3 _5 ->
    (
# 691 "interpreter/text/parser.mly"
    ( fun c -> anon_locals c (lazy _3); let f = _5 c in
      {f with locals = _3 @ f.Ast.locals} )
# 3076 "interpreter/text/parser.ml"
     : (context -> Ast.func'))

let _menhir_action_082 =
  fun _3 _4 _6 ->
    (
# 694 "interpreter/text/parser.mly"
    ( fun c -> ignore (bind_local c _3); let f = _6 c in
      {f with locals = _4 :: f.Ast.locals} )
# 3085 "interpreter/text/parser.ml"
     : (context -> Ast.func'))

let _menhir_action_083 =
  fun _1 _2 ->
    (
# 632 "interpreter/text/parser.mly"
    ( fun c x at ->
      let c' = enter_func c in
      let y = inline_type_explicit c' (_1 c' type_) (fst _2) at in
      [{(snd _2 c') with ftype = y} @@ at], [], [] )
# 3096 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_084 =
  fun _1 ->
    (
# 637 "interpreter/text/parser.mly"
    ( fun c x at ->
      let c' = enter_func c in
      let y = inline_type c' (fst _1) at in
      [{(snd _1 c') with ftype = y} @@ at], [], [] )
# 3110 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_085 =
  fun _1 _2 _3 ->
    (
# 642 "interpreter/text/parser.mly"
    ( fun c x at ->
      let y = inline_type_explicit c (_2 c type_) _3 at in
      [],
      [{ module_name = fst _1; item_name = snd _1;
         idesc = FuncImport y @@ at } @@ at ], [] )
# 3125 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_086 =
  fun _1 _2 ->
    (
# 648 "interpreter/text/parser.mly"
    ( fun c x at ->
      let y = inline_type c _2 at in
      [],
      [{ module_name = fst _1; item_name = snd _1;
         idesc = FuncImport y @@ at } @@ at ], [] )
# 3140 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_087 =
  fun _1 _2 ->
    (
# 654 "interpreter/text/parser.mly"
    ( fun c x at ->
      let fns, ims, exs = _2 c x at in fns, ims, _1 (FuncExport x) c :: exs )
# 3152 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.func list * Ast.import list * Ast.export list))

let _menhir_action_088 =
  fun _1 ->
    (
# 670 "interpreter/text/parser.mly"
                     ( _1 )
# 3163 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.func')))

let _menhir_action_089 =
  fun _3 _5 ->
    (
# 672 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (_3 @ ins, out),
      fun c -> anon_locals c (lazy _3); snd _5 c )
# 3173 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.func')))

let _menhir_action_090 =
  fun _3 _4 _6 ->
    (
# 676 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _6 in
      FuncType (_4 :: ins, out),
      fun c -> ignore (bind_local c _3); snd _6 c )
# 3183 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.func')))

let _menhir_action_091 =
  fun _1 ->
    (
# 658 "interpreter/text/parser.mly"
                              ( _1 )
# 3191 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_092 =
  fun _3 _5 ->
    (
# 660 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = _5 in FuncType (_3 @ ins, out) )
# 3199 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_093 =
  fun _4 _6 ->
    (
# 662 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = _6 in FuncType (_4 :: ins, out) )
# 3207 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_094 =
  fun () ->
    (
# 665 "interpreter/text/parser.mly"
                ( FuncType ([], []) )
# 3215 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_095 =
  fun _3 _5 ->
    (
# 667 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = _5 in FuncType (ins, _3 @ out) )
# 3223 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_096 =
  fun _1 ->
    (
# 681 "interpreter/text/parser.mly"
              ( FuncType ([], []), _1 )
# 3231 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.func')))

let _menhir_action_097 =
  fun _3 _5 ->
    (
# 683 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (ins, _3 @ out), snd _5 )
# 3240 "interpreter/text/parser.ml"
     : (Types.func_type * (context -> Ast.func')))

let _menhir_action_098 =
  fun _1 ->
    (
# 280 "interpreter/text/parser.mly"
    ( FuncType ([], _1) )
# 3248 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_099 =
  fun _3 _5 ->
    (
# 282 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = _5 in FuncType (_3 @ ins, out) )
# 3256 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_100 =
  fun _4 _6 ->
    (
# 284 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = _6 in FuncType (_4 :: ins, out) )
# 3264 "interpreter/text/parser.ml"
     : (Types.func_type))

let _menhir_action_101 =
  fun () ->
    (
# 288 "interpreter/text/parser.mly"
    ( [] )
# 3272 "interpreter/text/parser.ml"
     : (Types.result_type))

let _menhir_action_102 =
  fun _3 _5 ->
    (
# 290 "interpreter/text/parser.mly"
    ( _3 @ _5 )
# 3280 "interpreter/text/parser.ml"
     : (Types.result_type))

let _menhir_action_103 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 842 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> let x = _3 c anon_global bind_global @@ at in
      fun () -> _4 c x at )
# 3293 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.global list * Ast.import list * Ast.export list))

let _menhir_action_104 =
  fun _1 _2 ->
    (
# 848 "interpreter/text/parser.mly"
    ( fun c x at -> [{gtype = _1; ginit = _2 c} @@ at], [], [] )
# 3301 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.global list * Ast.import list * Ast.export list))

let _menhir_action_105 =
  fun _1 _2 ->
    (
# 850 "interpreter/text/parser.mly"
    ( fun c x at ->
      [],
      [{ module_name = fst _1; item_name = snd _1;
         idesc = GlobalImport _2 @@ at } @@ at], [] )
# 3315 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.global list * Ast.import list * Ast.export list))

let _menhir_action_106 =
  fun _1 _2 ->
    (
# 855 "interpreter/text/parser.mly"
    ( fun c x at -> let globs, ims, exs = _2 c x at in
      globs, ims, _1 (GlobalExport x) c :: exs )
# 3327 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.global list * Ast.import list * Ast.export list))

let _menhir_action_107 =
  fun _1 ->
    (
# 272 "interpreter/text/parser.mly"
               ( GlobalType (_1, Immutable) )
# 3338 "interpreter/text/parser.ml"
     : (Types.global_type))

let _menhir_action_108 =
  fun _3 ->
    (
# 273 "interpreter/text/parser.mly"
                             ( GlobalType (_3, Mutable) )
# 3346 "interpreter/text/parser.ml"
     : (Types.global_type))

let _menhir_action_109 =
  fun _1 _2 ->
    (
# 608 "interpreter/text/parser.mly"
    ( fun c c' -> let es = _1 c in let es0, es1, es2 = _2 c c' in
      es @ es0, es1, es2 )
# 3355 "interpreter/text/parser.ml"
     : (context ->
  context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list))

let _menhir_action_110 =
  fun _3 _7 ->
    (
# 611 "interpreter/text/parser.mly"
    ( fun c c' -> [], _3 c', _7 c' )
# 3364 "interpreter/text/parser.ml"
     : (context ->
  context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list))

let _menhir_action_111 =
  fun _3 ->
    (
# 613 "interpreter/text/parser.mly"
    ( fun c c' -> [], _3 c', [] )
# 3373 "interpreter/text/parser.ml"
     : (context ->
  context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list))

let _menhir_action_112 =
  fun _1 _2 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 580 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c c' ->
      VarBlockType (inline_type_explicit c (_1 c type_) (fst _2) at),
      snd _2 c c' )
# 3388 "interpreter/text/parser.ml"
     : (context ->
  context ->
  Ast.block_type *
  (Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_113 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 585 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c c' ->
      let bt =
        match fst _1 with
        | FuncType ([], []) -> ValBlockType None
        | FuncType ([], [t]) -> ValBlockType (Some t)
        | ft ->  VarBlockType (inline_type c ft at)
      in bt, snd _1 c c' )
# 3409 "interpreter/text/parser.ml"
     : (context ->
  context ->
  Ast.block_type *
  (Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_114 =
  fun _1 ->
    (
# 595 "interpreter/text/parser.mly"
                         ( _1 )
# 3420 "interpreter/text/parser.ml"
     : (Types.func_type *
  (context ->
   context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_115 =
  fun _3 _5 ->
    (
# 597 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (_3 @ ins, out), snd _5 )
# 3431 "interpreter/text/parser.ml"
     : (Types.func_type *
  (context ->
   context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_116 =
  fun _1 ->
    (
# 601 "interpreter/text/parser.mly"
        ( FuncType ([], []), _1 )
# 3441 "interpreter/text/parser.ml"
     : (Types.func_type *
  (context ->
   context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_117 =
  fun _3 _5 ->
    (
# 603 "interpreter/text/parser.mly"
    ( let FuncType (ins, out) = fst _5 in
      FuncType (ins, _3 @ out), snd _5 )
# 3452 "interpreter/text/parser.ml"
     : (Types.func_type *
  (context ->
   context -> Ast.instr' Source.phrase list * Ast.instr list * Ast.instr list)))

let _menhir_action_118 =
  fun _3 _4 _5 _endpos__5_ _endpos__6_ _startpos__1_ _startpos__5_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _loc__5_ = (_startpos__5_, _endpos__5_) in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 881 "interpreter/text/parser.mly"
    ( let at = _sloc and at5 = _loc__5_ in
      fun c -> let df = _5 c in
      fun () -> {module_name = _3; item_name = _4; idesc = df () @@ at5} @@ at )
# 3468 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import))

let _menhir_action_119 =
  fun _3 _4 ->
    (
# 863 "interpreter/text/parser.mly"
    ( fun c -> ignore (_3 c anon_func bind_func);
      fun () -> FuncImport (_4 c type_) )
# 3477 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import_desc'))

let _menhir_action_120 =
  fun _3 _4 _endpos__4_ _startpos__4_ ->
    let _loc__4_ = (_startpos__4_, _endpos__4_) in
    (
# 866 "interpreter/text/parser.mly"
    ( let at4 = _loc__4_ in
      fun c -> ignore (_3 c anon_func bind_func);
      fun () -> FuncImport (inline_type c _4 at4) )
# 3488 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import_desc'))

let _menhir_action_121 =
  fun _3 _4 ->
    (
# 870 "interpreter/text/parser.mly"
    ( fun c -> ignore (_3 c anon_table bind_table);
      fun () -> TableImport _4 )
# 3497 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import_desc'))

let _menhir_action_122 =
  fun _3 _4 ->
    (
# 873 "interpreter/text/parser.mly"
    ( fun c -> ignore (_3 c anon_memory bind_memory);
      fun () -> MemoryImport _4 )
# 3506 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import_desc'))

let _menhir_action_123 =
  fun _3 _4 ->
    (
# 876 "interpreter/text/parser.mly"
    ( fun c -> ignore (_3 c anon_global bind_global);
      fun () -> GlobalImport _4 )
# 3515 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.import_desc'))

let _menhir_action_124 =
  fun _3 _endpos__4_ _startpos__1_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 901 "interpreter/text/parser.mly"
    ( let at = _sloc in fun d c -> {name = _3; edesc = d @@ at} @@ at )
# 3526 "interpreter/text/parser.ml"
     : (Ast.export_desc' -> context -> Ast.export))

let _menhir_action_125 =
  fun _3 _4 ->
    (
# 886 "interpreter/text/parser.mly"
                               ( _3, _4 )
# 3534 "interpreter/text/parser.ml"
     : (Utf8.unicode * Utf8.unicode))

let _menhir_action_126 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = if _startpos__1_ != _endpos__1_ then
      _startpos__1_
    else
      _endpos in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 986 "interpreter/text/parser.mly"
                  ( Textual (_1 (empty_context ()) () @@ _sloc) @@ _sloc )
# 3548 "interpreter/text/parser.ml"
     : (Script.definition))

let _menhir_action_127 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 989 "interpreter/text/parser.mly"
                   ( Textual (_1 (empty_context ()) () @@ _sloc) @@ _sloc )
# 3559 "interpreter/text/parser.ml"
     : (Script.definition))

let _menhir_action_128 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 365 "interpreter/text/parser.mly"
                ( let at = _sloc in fun c -> [_1 c @@ at] )
# 3570 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_129 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 366 "interpreter/text/parser.mly"
                ( let at = _sloc in fun c -> [_1 c @@ at] )
# 3581 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_130 =
  fun _1 ->
    (
# 367 "interpreter/text/parser.mly"
         ( _1 )
# 3589 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_131 =
  fun () ->
    (
# 359 "interpreter/text/parser.mly"
                ( fun c -> [] )
# 3597 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_132 =
  fun _1 _2 ->
    (
# 360 "interpreter/text/parser.mly"
                      ( fun c -> _1 c @ _2 c )
# 3605 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_133 =
  fun _1 ->
    (
# 361 "interpreter/text/parser.mly"
                            ( _1 )
# 3613 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_134 =
  fun _1 ->
    (
# 362 "interpreter/text/parser.mly"
                          ( _1 )
# 3621 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_135 =
  fun () ->
    (
# 340 "interpreter/text/parser.mly"
                ( [] )
# 3629 "interpreter/text/parser.ml"
     : (string Source.phrase list))

let _menhir_action_136 =
  fun _1 ->
    (
# 341 "interpreter/text/parser.mly"
             ( [_1] )
# 3637 "interpreter/text/parser.ml"
     : (string Source.phrase list))

let _menhir_action_137 =
  fun () ->
    (
# 330 "interpreter/text/parser.mly"
    ( fun c xs ->
      List.iter (fun x -> error x.at "mismatching label") xs;
      anon_label c )
# 3647 "interpreter/text/parser.ml"
     : (context -> string Source.phrase list -> context))

let _menhir_action_138 =
  fun _1 ->
    (
# 334 "interpreter/text/parser.mly"
    ( fun c xs ->
      List.iter
        (fun x -> if x.it <> _1.it then error x.at "mismatching label") xs;
      bind_label c _1 )
# 3658 "interpreter/text/parser.ml"
     : (context -> string Source.phrase list -> context))

let _menhir_action_139 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 299 "interpreter/text/parser.mly"
        ( {min = nat32 _1 _loc__1_; max = None} )
# 3667 "interpreter/text/parser.ml"
     : (int32 Types.limits))

let _menhir_action_140 =
  fun _1 _2 _endpos__1_ _endpos__2_ _startpos__1_ _startpos__2_ ->
    let _loc__2_ = (_startpos__2_, _endpos__2_) in
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 300 "interpreter/text/parser.mly"
            ( {min = nat32 _1 _loc__1_; max = Some (nat32 _2 _loc__2_)} )
# 3677 "interpreter/text/parser.ml"
     : (int32 Types.limits))

let _menhir_action_141 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3685 "interpreter/text/parser.ml"
     : (Script.script))

let _menhir_action_142 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3693 "interpreter/text/parser.ml"
     : (Script.script))

let _menhir_action_143 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3701 "interpreter/text/parser.ml"
     : (Script.literal list))

let _menhir_action_144 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3709 "interpreter/text/parser.ml"
     : (Script.literal list))

let _menhir_action_145 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3717 "interpreter/text/parser.ml"
     : (string Source.phrase list))

let _menhir_action_146 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3725 "interpreter/text/parser.ml"
     : (string Source.phrase list))

let _menhir_action_147 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3733 "interpreter/text/parser.ml"
     : ((V128.shape -> Script.num_pat) list))

let _menhir_action_148 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3741 "interpreter/text/parser.ml"
     : ((V128.shape -> Script.num_pat) list))

let _menhir_action_149 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3749 "interpreter/text/parser.ml"
     : (Script.result list))

let _menhir_action_150 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3757 "interpreter/text/parser.ml"
     : (Script.result list))

let _menhir_action_151 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 3765 "interpreter/text/parser.ml"
     : (Types.value_type list))

let _menhir_action_152 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 3773 "interpreter/text/parser.ml"
     : (Types.value_type list))

let _menhir_action_153 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1047 "interpreter/text/parser.mly"
                ( Values.Num _1 @@ _sloc )
# 3784 "interpreter/text/parser.ml"
     : (Values.value Source.phrase))

let _menhir_action_154 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1048 "interpreter/text/parser.mly"
                ( Values.Vec _1 @@ _sloc )
# 3795 "interpreter/text/parser.ml"
     : (Values.value Source.phrase))

let _menhir_action_155 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1049 "interpreter/text/parser.mly"
                ( Values.Ref _1 @@ _sloc )
# 3806 "interpreter/text/parser.ml"
     : (Values.value Source.phrase))

let _menhir_action_156 =
  fun _2 _3 ->
    (
# 1037 "interpreter/text/parser.mly"
                        ( snd (num _2 _3) )
# 3814 "interpreter/text/parser.ml"
     : (Values.num))

let _menhir_action_157 =
  fun _3 ->
    (
# 1043 "interpreter/text/parser.mly"
                                ( Values.NullRef _3 )
# 3822 "interpreter/text/parser.ml"
     : (Values.ref_))

let _menhir_action_158 =
  fun _3 _endpos__3_ _startpos__3_ ->
    let _loc__3_ = (_startpos__3_, _endpos__3_) in
    (
# 1044 "interpreter/text/parser.mly"
                             ( ExternRef (nat32 _3 _loc__3_) )
# 3831 "interpreter/text/parser.ml"
     : (Values.ref_))

let _menhir_action_159 =
  fun _2 _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1040 "interpreter/text/parser.mly"
                                            ( snd (vec _2 _3 _4 _sloc) )
# 3842 "interpreter/text/parser.ml"
     : (Values.vec))

let _menhir_action_160 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 817 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> let x = _3 c anon_memory bind_memory @@ at in
      fun () -> _4 c x at )
# 3855 "interpreter/text/parser.ml"
     : (context ->
  unit ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list))

let _menhir_action_161 =
  fun _1 ->
    (
# 823 "interpreter/text/parser.mly"
    ( fun c x at -> [{mtype = _1} @@ at], [], [], [] )
# 3865 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list))

let _menhir_action_162 =
  fun _1 _2 ->
    (
# 825 "interpreter/text/parser.mly"
    ( fun c x at ->
      [], [],
      [{ module_name = fst _1; item_name = snd _1;
         idesc = MemoryImport _2 @@ at } @@ at], [] )
# 3879 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list))

let _menhir_action_163 =
  fun _1 _2 ->
    (
# 830 "interpreter/text/parser.mly"
    ( fun c x at -> let mems, data, ims, exs = _2 c x at in
      mems, data, ims, _1 (MemoryExport x) c :: exs )
# 3891 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list))

let _menhir_action_164 =
  fun _3 ->
    (
# 833 "interpreter/text/parser.mly"
    ( fun c x at ->
      let offset = [i32_const (0l @@ at) @@ at] @@ at in
      let size = Int32.(div (add (of_int (String.length _3)) 65535l) 65536l) in
      [{mtype = MemoryType {min = size; max = Some size}} @@ at],
      [{dinit = _3; dmode = Active {index = x; offset} @@ at} @@ at],
      [], [] )
# 3907 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.memory list * Ast.data_segment list * Ast.import list * Ast.export list))

let _menhir_action_165 =
  fun _1 ->
    (
# 296 "interpreter/text/parser.mly"
           ( MemoryType _1 )
# 3918 "interpreter/text/parser.ml"
     : (Types.memory_type))

let _menhir_action_166 =
  fun _3 ->
    (
# 704 "interpreter/text/parser.mly"
                         ( fun c -> _3 c )
# 3926 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase))

let _menhir_action_167 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1031 "interpreter/text/parser.mly"
                                                  ( Script (_3, _4) @@ _sloc )
# 3938 "interpreter/text/parser.ml"
     : (Script.meta' Source.phrase))

let _menhir_action_168 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1032 "interpreter/text/parser.mly"
                                              ( Input (_3, _4) @@ _sloc )
# 3949 "interpreter/text/parser.ml"
     : (Script.meta' Source.phrase))

let _menhir_action_169 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1033 "interpreter/text/parser.mly"
                                               ( Output (_3, Some _4) @@ _sloc )
# 3960 "interpreter/text/parser.ml"
     : (Script.meta' Source.phrase))

let _menhir_action_170 =
  fun _3 _endpos__4_ _startpos__1_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1034 "interpreter/text/parser.mly"
                                        ( Output (_3, None) @@ _sloc )
# 3971 "interpreter/text/parser.ml"
     : (Script.meta' Source.phrase))

let _menhir_action_171 =
  fun _1 ->
    (
# 1075 "interpreter/text/parser.mly"
                ( _1 )
# 3979 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_172 =
  fun _1 ->
    (
# 1076 "interpreter/text/parser.mly"
                      ( None, _1 )
# 3987 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_173 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 983 "interpreter/text/parser.mly"
    ( _3, Textual (_4 (empty_context ()) () @@ _sloc) @@ _sloc )
# 3998 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_174 =
  fun () ->
    (
# 921 "interpreter/text/parser.mly"
    ( fun (c : context) () -> {empty_module with types = c.types.list} )
# 4006 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_175 =
  fun _1 ->
    (
# 922 "interpreter/text/parser.mly"
                   ( _1 )
# 4014 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_176 =
  fun _1 _2 ->
    (
# 926 "interpreter/text/parser.mly"
    ( fun c -> ignore (_1 c); _2 c )
# 4022 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_177 =
  fun _1 _2 ->
    (
# 928 "interpreter/text/parser.mly"
    ( fun c -> let gf = _1 c in let mf = _2 c in
      fun () -> let globs, ims, exs = gf () in let m = mf () in
      if globs <> [] && m.imports <> [] then
        error (List.hd m.imports).at "import after global definition";
      { m with globals = globs @ m.globals;
        imports = ims @ m.imports; exports = exs @ m.exports } )
# 4035 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_178 =
  fun _1 _2 ->
    (
# 935 "interpreter/text/parser.mly"
    ( fun c -> let tf = _1 c in let mf = _2 c in
      fun () -> let tabs, elems, ims, exs = tf () in let m = mf () in
      if tabs <> [] && m.imports <> [] then
        error (List.hd m.imports).at "import after table definition";
      { m with tables = tabs @ m.tables; elems = elems @ m.elems;
        imports = ims @ m.imports; exports = exs @ m.exports } )
# 4048 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_179 =
  fun _1 _2 ->
    (
# 942 "interpreter/text/parser.mly"
    ( fun c -> let mmf = _1 c in let mf = _2 c in
      fun () -> let mems, data, ims, exs = mmf () in let m = mf () in
      if mems <> [] && m.imports <> [] then
        error (List.hd m.imports).at "import after memory definition";
      { m with memories = mems @ m.memories; datas = data @ m.datas;
        imports = ims @ m.imports; exports = exs @ m.exports } )
# 4061 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_180 =
  fun _1 _2 ->
    (
# 949 "interpreter/text/parser.mly"
    ( fun c -> let ff = _1 c in let mf = _2 c in
      fun () -> let funcs, ims, exs = ff () in let m = mf () in
      if funcs <> [] && m.imports <> [] then
        error (List.hd m.imports).at "import after function definition";
      { m with funcs = funcs @ m.funcs;
        imports = ims @ m.imports; exports = exs @ m.exports } )
# 4074 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_181 =
  fun _1 _2 ->
    (
# 956 "interpreter/text/parser.mly"
    ( fun c -> let ef = _1 c in let mf = _2 c in
      fun () -> let elems = ef () in let m = mf () in
      {m with elems = elems :: m.Ast.elems} )
# 4084 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_182 =
  fun _1 _2 ->
    (
# 960 "interpreter/text/parser.mly"
    ( fun c -> let df = _1 c in let mf = _2 c in
      fun () -> let data = df () in let m = mf () in
      {m with datas = data :: m.Ast.datas} )
# 4094 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_183 =
  fun _1 _2 ->
    (
# 964 "interpreter/text/parser.mly"
    ( fun c -> let mf = _2 c in
      fun () -> let m = mf () in let x = _1 c in
      match m.start with
      | Some _ -> error x.at "multiple start sections"
      | None -> {m with start = Some x} )
# 4106 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_184 =
  fun _1 _2 ->
    (
# 970 "interpreter/text/parser.mly"
    ( fun c -> let imf = _1 c in let mf = _2 c in
      fun () -> let im = imf () in let m = mf () in
      {m with imports = im :: m.imports} )
# 4116 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_185 =
  fun _1 _2 ->
    (
# 974 "interpreter/text/parser.mly"
    ( fun c -> let mf = _2 c in
      fun () -> let m = mf () in
      {m with exports = _1 c :: m.exports} )
# 4126 "interpreter/text/parser.ml"
     : (context -> unit -> Ast.module_'))

let _menhir_action_186 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 979 "interpreter/text/parser.mly"
        ( _1 @@ _sloc )
# 4137 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_187 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 249 "interpreter/text/parser.mly"
           ( name _1 _sloc )
# 4148 "interpreter/text/parser.ml"
     : (Utf8.unicode))

let _menhir_action_188 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 309 "interpreter/text/parser.mly"
        ( _1 @@ _sloc )
# 4159 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_189 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 310 "interpreter/text/parser.mly"
        ( _1 @@ _sloc )
# 4170 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_190 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 311 "interpreter/text/parser.mly"
          ( _1 @@ _sloc )
# 4181 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_191 =
  fun _1 ->
    (
# 1052 "interpreter/text/parser.mly"
        ( fun sh -> vec_lane_lit sh _1.it _1.at )
# 4189 "interpreter/text/parser.ml"
     : (V128.shape -> Script.num_pat))

let _menhir_action_192 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1053 "interpreter/text/parser.mly"
        ( fun sh -> vec_lane_nan sh _1 (at _sloc) )
# 4200 "interpreter/text/parser.ml"
     : (V128.shape -> Script.num_pat))

let _menhir_action_193 =
  fun _3 ->
    (
# 707 "interpreter/text/parser.mly"
                                ( _3 )
# 4208 "interpreter/text/parser.ml"
     : (context -> Ast.const))

let _menhir_action_194 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 708 "interpreter/text/parser.mly"
         ( let at = _sloc in fun c -> _1 c @@ at )
# 4219 "interpreter/text/parser.ml"
     : (context -> Ast.const))

let _menhir_action_195 =
  fun () ->
    (
# 344 "interpreter/text/parser.mly"
                ( 0l )
# 4227 "interpreter/text/parser.ml"
     : (int32))

let _menhir_action_196 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 345 "interpreter/text/parser.mly"
                  ( nat32 _1 _sloc )
# 4238 "interpreter/text/parser.ml"
     : (int32))

let _menhir_action_197 =
  fun () ->
    (
# 111 "<standard.mly>"
    ( None )
# 4246 "interpreter/text/parser.ml"
     : (Script.var option))

let _menhir_action_198 =
  fun x ->
    (
# 114 "<standard.mly>"
    ( Some x )
# 4254 "interpreter/text/parser.ml"
     : (Script.var option))

let _menhir_action_199 =
  fun () ->
    (
# 111 "<standard.mly>"
    ( None )
# 4262 "interpreter/text/parser.ml"
     : (Script.var option))

let _menhir_action_200 =
  fun x ->
    (
# 114 "<standard.mly>"
    ( Some x )
# 4270 "interpreter/text/parser.ml"
     : (Script.var option))

let _menhir_action_201 =
  fun () ->
    (
# 370 "interpreter/text/parser.mly"
                ( fun c -> unreachable )
# 4278 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_202 =
  fun () ->
    (
# 371 "interpreter/text/parser.mly"
        ( fun c -> nop )
# 4286 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_203 =
  fun () ->
    (
# 372 "interpreter/text/parser.mly"
         ( fun c -> drop )
# 4294 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_204 =
  fun _2 ->
    (
# 373 "interpreter/text/parser.mly"
           ( fun c -> br (_2 c label) )
# 4302 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_205 =
  fun _2 ->
    (
# 374 "interpreter/text/parser.mly"
              ( fun c -> br_if (_2 c label) )
# 4310 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_206 =
  fun _2 _3 ->
    (
# 376 "interpreter/text/parser.mly"
    ( fun c -> let xs, x = Lib.List.split_last (_2 c label :: _3 c label) in
      br_table xs x )
# 4319 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_207 =
  fun () ->
    (
# 378 "interpreter/text/parser.mly"
           ( fun c -> return )
# 4327 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_208 =
  fun _2 ->
    (
# 379 "interpreter/text/parser.mly"
             ( fun c -> call (_2 c func) )
# 4335 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_209 =
  fun _2 ->
    (
# 380 "interpreter/text/parser.mly"
                  ( fun c -> local_get (_2 c local) )
# 4343 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_210 =
  fun _2 ->
    (
# 381 "interpreter/text/parser.mly"
                  ( fun c -> local_set (_2 c local) )
# 4351 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_211 =
  fun _2 ->
    (
# 382 "interpreter/text/parser.mly"
                  ( fun c -> local_tee (_2 c local) )
# 4359 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_212 =
  fun _2 ->
    (
# 383 "interpreter/text/parser.mly"
                   ( fun c -> global_get (_2 c global) )
# 4367 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_213 =
  fun _2 ->
    (
# 384 "interpreter/text/parser.mly"
                   ( fun c -> global_set (_2 c global) )
# 4375 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_214 =
  fun _2 ->
    (
# 385 "interpreter/text/parser.mly"
                  ( fun c -> table_get (_2 c table) )
# 4383 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_215 =
  fun _2 ->
    (
# 386 "interpreter/text/parser.mly"
                  ( fun c -> table_set (_2 c table) )
# 4391 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_216 =
  fun _2 ->
    (
# 387 "interpreter/text/parser.mly"
                   ( fun c -> table_size (_2 c table) )
# 4399 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_217 =
  fun _2 ->
    (
# 388 "interpreter/text/parser.mly"
                   ( fun c -> table_grow (_2 c table) )
# 4407 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_218 =
  fun _2 ->
    (
# 389 "interpreter/text/parser.mly"
                   ( fun c -> table_fill (_2 c table) )
# 4415 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_219 =
  fun _2 _3 ->
    (
# 390 "interpreter/text/parser.mly"
                       ( fun c -> table_copy (_2 c table) (_3 c table) )
# 4423 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_220 =
  fun _2 _3 ->
    (
# 391 "interpreter/text/parser.mly"
                       ( fun c -> table_init (_2 c table) (_3 c elem) )
# 4431 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_221 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 392 "interpreter/text/parser.mly"
              ( let at = _sloc in fun c -> table_get (0l @@ at) )
# 4442 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_222 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 393 "interpreter/text/parser.mly"
              ( let at = _sloc in fun c -> table_set (0l @@ at) )
# 4453 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_223 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 394 "interpreter/text/parser.mly"
               ( let at = _sloc in fun c -> table_size (0l @@ at) )
# 4464 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_224 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 395 "interpreter/text/parser.mly"
               ( let at = _sloc in fun c -> table_grow (0l @@ at) )
# 4475 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_225 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 396 "interpreter/text/parser.mly"
               ( let at = _sloc in fun c -> table_fill (0l @@ at) )
# 4486 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_226 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 398 "interpreter/text/parser.mly"
    ( let at = _sloc in fun c -> table_copy (0l @@ at) (0l @@ at) )
# 4497 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_227 =
  fun _2 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 400 "interpreter/text/parser.mly"
    ( let at = _sloc in fun c -> table_init (0l @@ at) (_2 c elem) )
# 4508 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_228 =
  fun _2 ->
    (
# 401 "interpreter/text/parser.mly"
                  ( fun c -> elem_drop (_2 c elem) )
# 4516 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_229 =
  fun _1 _2 _3 ->
    (
# 402 "interpreter/text/parser.mly"
                              ( fun c -> _1 _3 _2 )
# 4524 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_230 =
  fun _1 _2 _3 ->
    (
# 403 "interpreter/text/parser.mly"
                               ( fun c -> _1 _3 _2 )
# 4532 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_231 =
  fun _1 _2 _3 ->
    (
# 404 "interpreter/text/parser.mly"
                                  ( fun c -> _1 _3 _2 )
# 4540 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_232 =
  fun _1 _2 _3 ->
    (
# 405 "interpreter/text/parser.mly"
                                   ( fun c -> _1 _3 _2 )
# 4548 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_233 =
  fun _1 _2 _3 _4 _endpos__4_ _startpos__1_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 407 "interpreter/text/parser.mly"
    ( let at = at _sloc in fun c -> _1 _3 _2 (vec_lane_index _4 at) )
# 4559 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_234 =
  fun _1 _2 _3 _4 _endpos__4_ _startpos__1_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 409 "interpreter/text/parser.mly"
    ( let at = at _sloc in fun c -> _1 _3 _2 (vec_lane_index _4 at) )
# 4570 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_235 =
  fun () ->
    (
# 410 "interpreter/text/parser.mly"
                ( fun c -> memory_size )
# 4578 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_236 =
  fun () ->
    (
# 411 "interpreter/text/parser.mly"
                ( fun c -> memory_grow )
# 4586 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_237 =
  fun () ->
    (
# 412 "interpreter/text/parser.mly"
                ( fun c -> memory_fill )
# 4594 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_238 =
  fun () ->
    (
# 413 "interpreter/text/parser.mly"
                ( fun c -> memory_copy )
# 4602 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_239 =
  fun _2 ->
    (
# 414 "interpreter/text/parser.mly"
                    ( fun c -> memory_init (_2 c data) )
# 4610 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_240 =
  fun _2 ->
    (
# 415 "interpreter/text/parser.mly"
                  ( fun c -> data_drop (_2 c data) )
# 4618 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_241 =
  fun _2 ->
    (
# 416 "interpreter/text/parser.mly"
                      ( fun c -> ref_null _2 )
# 4626 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_242 =
  fun () ->
    (
# 417 "interpreter/text/parser.mly"
                ( fun c -> ref_is_null )
# 4634 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_243 =
  fun _2 ->
    (
# 418 "interpreter/text/parser.mly"
                 ( fun c -> ref_func (_2 c func) )
# 4642 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_244 =
  fun _1 _2 ->
    (
# 419 "interpreter/text/parser.mly"
              ( fun c -> fst (num _1 _2) )
# 4650 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_245 =
  fun _1 ->
    (
# 420 "interpreter/text/parser.mly"
         ( fun c -> _1 )
# 4658 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_246 =
  fun _1 ->
    (
# 421 "interpreter/text/parser.mly"
            ( fun c -> _1 )
# 4666 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_247 =
  fun _1 ->
    (
# 422 "interpreter/text/parser.mly"
          ( fun c -> _1 )
# 4674 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_248 =
  fun _1 ->
    (
# 423 "interpreter/text/parser.mly"
           ( fun c -> _1 )
# 4682 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_249 =
  fun _1 ->
    (
# 424 "interpreter/text/parser.mly"
            ( fun c -> _1 )
# 4690 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_250 =
  fun _1 _2 _3 _endpos__3_ _startpos__1_ ->
    let _endpos = _endpos__3_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 425 "interpreter/text/parser.mly"
                                  ( let at = _sloc in fun c -> fst (vec _1 _2 _3 at) )
# 4701 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_251 =
  fun _1 ->
    (
# 426 "interpreter/text/parser.mly"
              ( fun c -> _1 )
# 4709 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_252 =
  fun _1 ->
    (
# 427 "interpreter/text/parser.mly"
               ( fun c -> _1 )
# 4717 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_253 =
  fun _1 ->
    (
# 428 "interpreter/text/parser.mly"
                ( fun c -> _1 )
# 4725 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_254 =
  fun _1 ->
    (
# 429 "interpreter/text/parser.mly"
             ( fun c -> _1 )
# 4733 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_255 =
  fun _1 ->
    (
# 430 "interpreter/text/parser.mly"
              ( fun c -> _1 )
# 4741 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_256 =
  fun _1 ->
    (
# 431 "interpreter/text/parser.mly"
                ( fun c -> _1 )
# 4749 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_257 =
  fun _2 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 432 "interpreter/text/parser.mly"
                          ( let at = _sloc in fun c -> i8x16_shuffle (shuffle_lit _2 at) )
# 4760 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_258 =
  fun _1 ->
    (
# 433 "interpreter/text/parser.mly"
              ( fun c -> _1 )
# 4768 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_259 =
  fun _1 _2 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 434 "interpreter/text/parser.mly"
                    ( let at = at _sloc in fun c -> _1 (vec_lane_index _2 at) )
# 4779 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_260 =
  fun _1 _2 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 435 "interpreter/text/parser.mly"
                    ( let at = at _sloc in fun c -> _1 (vec_lane_index _2 at) )
# 4790 "interpreter/text/parser.ml"
     : (context -> Ast.instr'))

let _menhir_action_261 =
  fun () ->
    (
# 259 "interpreter/text/parser.mly"
         ( FuncRefType )
# 4798 "interpreter/text/parser.ml"
     : (Types.ref_type))

let _menhir_action_262 =
  fun () ->
    (
# 260 "interpreter/text/parser.mly"
           ( ExternRefType )
# 4806 "interpreter/text/parser.ml"
     : (Types.ref_type))

let _menhir_action_263 =
  fun () ->
    (
# 263 "interpreter/text/parser.mly"
            ( FuncRefType )
# 4814 "interpreter/text/parser.ml"
     : (Types.ref_type))

let _menhir_action_264 =
  fun () ->
    (
# 264 "interpreter/text/parser.mly"
              ( ExternRefType )
# 4822 "interpreter/text/parser.ml"
     : (Types.ref_type))

let _menhir_action_265 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1056 "interpreter/text/parser.mly"
                ( NumResult (NumPat (_1 @@ _sloc)) @@ _sloc )
# 4833 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_266 =
  fun _2 _3 _endpos__3_ _endpos__4_ _startpos__1_ _startpos__3_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _loc__3_ = (_startpos__3_, _endpos__3_) in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1057 "interpreter/text/parser.mly"
                        ( NumResult (NanPat (nanop _2 (_3 @@ _loc__3_))) @@ _sloc )
# 4845 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_267 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1058 "interpreter/text/parser.mly"
                ( RefResult (RefPat (_1 @@ _sloc)) @@ _sloc )
# 4856 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_268 =
  fun _endpos__3_ _startpos__1_ ->
    let _endpos = _endpos__3_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1059 "interpreter/text/parser.mly"
                       ( RefResult (RefTypePat FuncRefType) @@ _sloc )
# 4867 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_269 =
  fun _endpos__3_ _startpos__1_ ->
    let _endpos = _endpos__3_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1060 "interpreter/text/parser.mly"
                         ( RefResult (RefTypePat ExternRefType) @@ _sloc )
# 4878 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_270 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1061 "interpreter/text/parser.mly"
                                               (
    if V128.num_lanes _3 <> List.length _4 then
      error (at _sloc) "wrong number of lane literals";
    VecResult (VecPat (Values.V128 (_3, List.map (fun lit -> lit _3) _4))) @@ _sloc
  )
# 4893 "interpreter/text/parser.ml"
     : (Script.result' Source.phrase))

let _menhir_action_271 =
  fun _1 ->
    (
# 1068 "interpreter/text/parser.mly"
                  ( _1 )
# 4901 "interpreter/text/parser.ml"
     : (Script.script))

let _menhir_action_272 =
  fun _1 _endpos__2_ _startpos__1_ ->
    let _endpos = _endpos__2_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1069 "interpreter/text/parser.mly"
                       ( [Module (None, _1) @@ _sloc] )
# 4912 "interpreter/text/parser.ml"
     : (Script.script))

let _menhir_action_273 =
  fun _1 ->
    (
# 1072 "interpreter/text/parser.mly"
        ( [_1] )
# 4920 "interpreter/text/parser.ml"
     : (Script.script))

let _menhir_action_274 =
  fun _1 ->
    (
# 998 "interpreter/text/parser.mly"
            ( _1 )
# 4928 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_275 =
  fun _3 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1000 "interpreter/text/parser.mly"
    ( _3, Encoded ("binary:" ^ string_of_pos (at _sloc).left, _5) @@ _sloc )
# 4939 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_276 =
  fun _3 _5 _endpos__6_ _startpos__1_ ->
    let _endpos = _endpos__6_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 1002 "interpreter/text/parser.mly"
    ( _3, Quoted ("quote:" ^ string_of_pos (at _sloc).left, _5) @@ _sloc )
# 4950 "interpreter/text/parser.ml"
     : (Script.var option * Script.definition))

let _menhir_action_277 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 995 "interpreter/text/parser.mly"
        ( _1 @@ _sloc )
# 4961 "interpreter/text/parser.ml"
     : (string Source.phrase))

let _menhir_action_278 =
  fun _3 _5 ->
    (
# 549 "interpreter/text/parser.mly"
    ( fun c -> let _, ts, es = _5 c in true, _3 @ ts, es )
# 4969 "interpreter/text/parser.ml"
     : (context -> bool * Types.value_type list * Ast.instr' Source.phrase list))

let _menhir_action_279 =
  fun _1 ->
    (
# 551 "interpreter/text/parser.mly"
    ( fun c -> false, [], _1 c )
# 4977 "interpreter/text/parser.ml"
     : (context -> bool * Types.value_type list * Ast.instr' Source.phrase list))

let _menhir_action_280 =
  fun _2 _endpos__1_ _startpos__1_ ->
    let _loc__1_ = (_startpos__1_, _endpos__1_) in
    (
# 440 "interpreter/text/parser.mly"
    ( let at1 = _loc__1_ in
      fun c -> let b, ts, es = _2 c in
      (select (if b then (Some ts) else None) @@ at1) :: es )
# 4988 "interpreter/text/parser.ml"
     : (context -> Ast.instr list))

let _menhir_action_281 =
  fun _3 _5 ->
    (
# 446 "interpreter/text/parser.mly"
    ( fun c -> let _, ts, es = _5 c in true, _3 @ ts, es )
# 4996 "interpreter/text/parser.ml"
     : (context -> bool * Types.value_type list * Ast.instr list))

let _menhir_action_282 =
  fun _1 ->
    (
# 448 "interpreter/text/parser.mly"
    ( fun c -> false, [], _1 c )
# 5004 "interpreter/text/parser.ml"
     : (context -> bool * Types.value_type list * Ast.instr list))

let _menhir_action_283 =
  fun _3 _endpos__4_ _startpos__1_ ->
    let _endpos = _endpos__4_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 917 "interpreter/text/parser.mly"
    ( let at = _sloc in fun c -> {sfunc = _3 c func} @@ at )
# 5015 "interpreter/text/parser.ml"
     : (context -> Ast.start' Source.phrase))

let _menhir_action_284 =
  fun () ->
    (
# 252 "interpreter/text/parser.mly"
                ( "" )
# 5023 "interpreter/text/parser.ml"
     : (string))

let _menhir_action_285 =
  fun _1 _2 ->
    (
# 253 "interpreter/text/parser.mly"
                       ( _1 ^ _2 )
# 5031 "interpreter/text/parser.ml"
     : (string))

let _menhir_action_286 =
  fun _3 _4 _endpos__5_ _startpos__1_ ->
    let _endpos = _endpos__5_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 765 "interpreter/text/parser.mly"
    ( let at = _sloc in
      fun c -> let x = _3 c anon_table bind_table @@ at in
      fun () -> _4 c x at )
# 5044 "interpreter/text/parser.ml"
     : (context ->
  unit ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_287 =
  fun _1 ->
    (
# 771 "interpreter/text/parser.mly"
    ( fun c x at -> [{ttype = _1} @@ at], [], [], [] )
# 5055 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_288 =
  fun _1 _2 ->
    (
# 773 "interpreter/text/parser.mly"
    ( fun c x at ->
      [], [],
      [{ module_name = fst _1; item_name = snd _1;
        idesc = TableImport _2 @@ at } @@ at], [] )
# 5070 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_289 =
  fun _1 _2 ->
    (
# 778 "interpreter/text/parser.mly"
    ( fun c x at -> let tabs, elems, ims, exs = _2 c x at in
      tabs, elems, ims, _1 (TableExport x) c :: exs )
# 5083 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_290 =
  fun _1 _4 _5 ->
    (
# 781 "interpreter/text/parser.mly"
    ( fun c x at ->
      let offset = [i32_const (0l @@ at) @@ at] @@ at in
      let einit = _4 c :: _5 c in
      let size = Lib.List32.length einit in
      let emode = Active {index = x; offset} @@ at in
      [{ttype = TableType ({min = size; max = Some size}, _1)} @@ at],
      [{etype = _1; einit; emode} @@ at],
      [], [] )
# 5102 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_291 =
  fun _1 _4 ->
    (
# 790 "interpreter/text/parser.mly"
    ( fun c x at ->
      let offset = [i32_const (0l @@ at) @@ at] @@ at in
      let einit = _4 c in
      let size = Lib.List32.length einit in
      let emode = Active {index = x; offset} @@ at in
      [{ttype = TableType ({min = size; max = Some size}, _1)} @@ at],
      [{etype = FuncRefType; einit; emode} @@ at],
      [], [] )
# 5121 "interpreter/text/parser.ml"
     : (context ->
  Ast.var ->
  Lexing.position * Lexing.position ->
  Ast.table' Source.phrase list * Ast.elem_segment' Source.phrase list *
  Ast.import' Source.phrase list * Ast.export list))

let _menhir_action_292 =
  fun _1 _2 ->
    (
# 293 "interpreter/text/parser.mly"
                    ( TableType (_1, _2) )
# 5133 "interpreter/text/parser.ml"
     : (Types.table_type))

let _menhir_action_293 =
  fun _3 ->
    (
# 701 "interpreter/text/parser.mly"
                        ( fun c -> _3 c )
# 5141 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase))

let _menhir_action_294 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 907 "interpreter/text/parser.mly"
             ( _1 @@ _sloc )
# 5153 "interpreter/text/parser.ml"
     : (Ast.type_))

let _menhir_action_295 =
  fun _3 ->
    (
# 911 "interpreter/text/parser.mly"
    ( fun c -> anon_type c _3 )
# 5161 "interpreter/text/parser.ml"
     : (context -> int32))

let _menhir_action_296 =
  fun _3 _4 ->
    (
# 913 "interpreter/text/parser.mly"
    ( fun c -> bind_type c _3 _4 )
# 5169 "interpreter/text/parser.ml"
     : (context -> int32))

let _menhir_action_297 =
  fun _3 ->
    (
# 303 "interpreter/text/parser.mly"
                       ( _3 )
# 5177 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase))

let _menhir_action_298 =
  fun _1 ->
    (
# 267 "interpreter/text/parser.mly"
             ( NumType _1 )
# 5186 "interpreter/text/parser.ml"
     : (Types.value_type))

let _menhir_action_299 =
  fun _1 ->
    (
# 268 "interpreter/text/parser.mly"
             ( VecType _1 )
# 5194 "interpreter/text/parser.ml"
     : (Types.value_type))

let _menhir_action_300 =
  fun _1 ->
    (
# 269 "interpreter/text/parser.mly"
             ( RefType _1 )
# 5202 "interpreter/text/parser.ml"
     : (Types.value_type))

let _menhir_action_301 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 314 "interpreter/text/parser.mly"
        ( let at = _sloc in fun c lookup -> nat32 _1 at @@ at )
# 5213 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase))

let _menhir_action_302 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _symbolstartpos = _startpos__1_ in
    let _sloc = (_symbolstartpos, _endpos) in
    (
# 315 "interpreter/text/parser.mly"
        ( let at = _sloc in fun c lookup -> lookup c (_1 @@ at) @@ at )
# 5225 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase))

let _menhir_action_303 =
  fun () ->
    (
# 318 "interpreter/text/parser.mly"
                ( fun c lookup -> [] )
# 5234 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase list))

let _menhir_action_304 =
  fun _1 _2 ->
    (
# 319 "interpreter/text/parser.mly"
                 ( fun c lookup -> _1 c lookup :: _2 c lookup )
# 5243 "interpreter/text/parser.ml"
     : (context ->
  (context -> string Source.phrase -> int32) -> int32 Source.phrase list))

let _menhir_print_token : token -> string =
  fun _tok ->
    match _tok with
    | ALIGN_EQ_NAT _ ->
        "ALIGN_EQ_NAT"
    | ASSERT_EXHAUSTION ->
        "ASSERT_EXHAUSTION"
    | ASSERT_INVALID ->
        "ASSERT_INVALID"
    | ASSERT_MALFORMED ->
        "ASSERT_MALFORMED"
    | ASSERT_RETURN ->
        "ASSERT_RETURN"
    | ASSERT_TRAP ->
        "ASSERT_TRAP"
    | ASSERT_UNLINKABLE ->
        "ASSERT_UNLINKABLE"
    | BIN ->
        "BIN"
    | BINARY _ ->
        "BINARY"
    | BLOCK ->
        "BLOCK"
    | BR ->
        "BR"
    | BR_IF ->
        "BR_IF"
    | BR_TABLE ->
        "BR_TABLE"
    | CALL ->
        "CALL"
    | CALL_INDIRECT ->
        "CALL_INDIRECT"
    | COMPARE _ ->
        "COMPARE"
    | CONST _ ->
        "CONST"
    | CONVERT _ ->
        "CONVERT"
    | DATA ->
        "DATA"
    | DATA_DROP ->
        "DATA_DROP"
    | DECLARE ->
        "DECLARE"
    | DROP ->
        "DROP"
    | ELEM ->
        "ELEM"
    | ELEM_DROP ->
        "ELEM_DROP"
    | ELSE ->
        "ELSE"
    | END ->
        "END"
    | EOF ->
        "EOF"
    | EXPORT ->
        "EXPORT"
    | EXTERN ->
        "EXTERN"
    | EXTERNREF ->
        "EXTERNREF"
    | FLOAT _ ->
        "FLOAT"
    | FUNC ->
        "FUNC"
    | FUNCREF ->
        "FUNCREF"
    | GET ->
        "GET"
    | GLOBAL ->
        "GLOBAL"
    | GLOBAL_GET ->
        "GLOBAL_GET"
    | GLOBAL_SET ->
        "GLOBAL_SET"
    | IF ->
        "IF"
    | IMPORT ->
        "IMPORT"
    | INPUT ->
        "INPUT"
    | INT _ ->
        "INT"
    | INVOKE ->
        "INVOKE"
    | ITEM ->
        "ITEM"
    | LOAD _ ->
        "LOAD"
    | LOCAL ->
        "LOCAL"
    | LOCAL_GET ->
        "LOCAL_GET"
    | LOCAL_SET ->
        "LOCAL_SET"
    | LOCAL_TEE ->
        "LOCAL_TEE"
    | LOOP ->
        "LOOP"
    | LPAR ->
        "LPAR"
    | MEMORY ->
        "MEMORY"
    | MEMORY_COPY ->
        "MEMORY_COPY"
    | MEMORY_FILL ->
        "MEMORY_FILL"
    | MEMORY_GROW ->
        "MEMORY_GROW"
    | MEMORY_INIT ->
        "MEMORY_INIT"
    | MEMORY_SIZE ->
        "MEMORY_SIZE"
    | MODULE ->
        "MODULE"
    | MUT ->
        "MUT"
    | NAN _ ->
        "NAN"
    | NAT _ ->
        "NAT"
    | NOP ->
        "NOP"
    | NUM_TYPE _ ->
        "NUM_TYPE"
    | OFFSET ->
        "OFFSET"
    | OFFSET_EQ_NAT _ ->
        "OFFSET_EQ_NAT"
    | OUTPUT ->
        "OUTPUT"
    | PARAM ->
        "PARAM"
    | QUOTE ->
        "QUOTE"
    | REF_EXTERN ->
        "REF_EXTERN"
    | REF_FUNC ->
        "REF_FUNC"
    | REF_IS_NULL ->
        "REF_IS_NULL"
    | REF_NULL ->
        "REF_NULL"
    | REGISTER ->
        "REGISTER"
    | RESULT ->
        "RESULT"
    | RETURN ->
        "RETURN"
    | RPAR ->
        "RPAR"
    | SCRIPT ->
        "SCRIPT"
    | SELECT ->
        "SELECT"
    | START ->
        "START"
    | STORE _ ->
        "STORE"
    | STRING _ ->
        "STRING"
    | TABLE ->
        "TABLE"
    | TABLE_COPY ->
        "TABLE_COPY"
    | TABLE_FILL ->
        "TABLE_FILL"
    | TABLE_GET ->
        "TABLE_GET"
    | TABLE_GROW ->
        "TABLE_GROW"
    | TABLE_INIT ->
        "TABLE_INIT"
    | TABLE_SET ->
        "TABLE_SET"
    | TABLE_SIZE ->
        "TABLE_SIZE"
    | TEST _ ->
        "TEST"
    | THEN ->
        "THEN"
    | TYPE ->
        "TYPE"
    | UNARY _ ->
        "UNARY"
    | UNREACHABLE ->
        "UNREACHABLE"
    | VAR _ ->
        "VAR"
    | VEC_BINARY _ ->
        "VEC_BINARY"
    | VEC_BITMASK _ ->
        "VEC_BITMASK"
    | VEC_CONST _ ->
        "VEC_CONST"
    | VEC_EXTRACT _ ->
        "VEC_EXTRACT"
    | VEC_LOAD _ ->
        "VEC_LOAD"
    | VEC_LOAD_LANE _ ->
        "VEC_LOAD_LANE"
    | VEC_REPLACE _ ->
        "VEC_REPLACE"
    | VEC_SHAPE _ ->
        "VEC_SHAPE"
    | VEC_SHIFT _ ->
        "VEC_SHIFT"
    | VEC_SHUFFLE ->
        "VEC_SHUFFLE"
    | VEC_SPLAT _ ->
        "VEC_SPLAT"
    | VEC_STORE _ ->
        "VEC_STORE"
    | VEC_STORE_LANE _ ->
        "VEC_STORE_LANE"
    | VEC_TERNARY _ ->
        "VEC_TERNARY"
    | VEC_TEST _ ->
        "VEC_TEST"
    | VEC_TYPE _ ->
        "VEC_TYPE"
    | VEC_UNARY _ ->
        "VEC_UNARY"

let _menhir_fail : unit -> 'a =
  fun () ->
    Printf.eprintf "Internal failure -- please contact the parser generator's developers.\n%!";
    assert false

include struct
  
  [@@@ocaml.warning "-4-37"]
  
  let _menhir_run_733 : type  ttv_stack. ttv_stack -> _ -> _menhir_box_script1 =
    fun _menhir_stack _v ->
      let _1 = _v in
      let _v = _menhir_action_273 _1 in
      MenhirBox_script1 _v
  
  let _menhir_goto_script : type  ttv_stack. ttv_stack -> _ -> _menhir_box_script =
    fun _menhir_stack _v ->
      MenhirBox_script _v
  
  let _menhir_run_659 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> _menhir_box_script =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_127 _1 _endpos__1_ _startpos__1_ in
      let _startpos = _startpos__1_ in
      match (_tok : MenhirBasics.token) with
      | EOF ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let (_startpos__1_, _1, _endpos__2_) = (_startpos, _v, _endpos) in
          let _v = _menhir_action_272 _1 _endpos__2_ _startpos__1_ in
          _menhir_goto_script _menhir_stack _v
      | _ ->
          _eRR ()
  
  let _menhir_goto_module1 : type  ttv_stack. ttv_stack -> _ -> _menhir_box_module1 =
    fun _menhir_stack _v ->
      MenhirBox_module1 _v
  
  let _menhir_run_538 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_module1 =
    fun _menhir_stack _v _tok ->
      match (_tok : MenhirBasics.token) with
      | EOF ->
          let _1 = _v in
          let _v = _menhir_action_171 _1 in
          _menhir_goto_module1 _menhir_stack _v
      | _ ->
          _eRR ()
  
  let _menhir_run_537 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _menhir_box_module1 =
    fun _menhir_stack _endpos _startpos _v _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_126 _1 _endpos__1_ _startpos__1_ in
      match (_tok : MenhirBasics.token) with
      | EOF ->
          let _1 = _v in
          let _v = _menhir_action_172 _1 in
          _menhir_goto_module1 _menhir_stack _v
      | _ ->
          _eRR ()
  
  let _menhir_run_660 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_script =
    fun _menhir_stack _v _tok ->
      match (_tok : MenhirBasics.token) with
      | EOF ->
          let _1 = _v in
          let _v = _menhir_action_271 _1 in
          _menhir_goto_script _menhir_stack _v
      | _ ->
          _eRR ()
  
  let rec _menhir_run_002 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState002 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LPAR ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_003 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_014 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_bind_var _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_bind_var : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState433 ->
          _menhir_run_439 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState414 ->
          _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState402 ->
          _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState498 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState468 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState395 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState384 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState375 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState366 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState362 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState358 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState339 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState036 ->
          _menhir_run_331 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState141 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState148 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState167 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState171 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState209 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState211 ->
          _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState304 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState272 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState275 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState270 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState236 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState002 ->
          _menhir_run_033 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState019 ->
          _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_439 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState439
      | NUM_TYPE _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState439
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState439
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState439
      | _ ->
          _eRR ()
  
  and _menhir_run_008 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _1 = _v in
      let _v = _menhir_action_299 _1 in
      _menhir_goto_value_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_value_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState439 ->
          _menhir_run_440 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState420 ->
          _menhir_run_421 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState408 ->
          _menhir_run_409 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState389 ->
          _menhir_run_372 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState387 ->
          _menhir_run_372 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState385 ->
          _menhir_run_372 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState367 ->
          _menhir_run_372 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState369 ->
          _menhir_run_370 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState024 ->
          _menhir_run_025 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState433 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState428 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState414 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState402 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState398 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState292 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState283 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState257 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState243 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState216 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState194 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState188 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState154 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState145 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState120 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState019 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState012 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState007 ->
          _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_440 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_bind_var as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_value_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_436 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState441
          | RPAR ->
              let _v_0 = _menhir_action_094 () in
              _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState441 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_436 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState436 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | RESULT ->
          _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_433 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_428 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState428
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState428
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState428
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState428
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_429 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState428
      | _ ->
          _eRR ()
  
  and _menhir_run_009 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _1 = _v in
      let _v = _menhir_action_298 _1 in
      _menhir_goto_value_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_010 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _v = _menhir_action_263 () in
      _menhir_goto_ref_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_ref_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState491 ->
          _menhir_run_479 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState469 ->
          _menhir_run_479 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState487 ->
          _menhir_run_479 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState478 ->
          _menhir_run_479 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState325 ->
          _menhir_run_326 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState329 ->
          _menhir_run_052 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_052 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState439 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState433 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState428 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState420 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState414 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState408 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState402 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState398 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState389 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState387 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState385 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState367 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState369 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState292 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState283 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState257 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState243 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState216 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState194 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState188 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState154 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState145 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState120 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState024 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState019 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState007 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState012 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_479 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_ref_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState479
      | RPAR ->
          let _v_0 = _menhir_action_058 () in
          _menhir_run_480 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_057 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | ITEM ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_ITEM (_menhir_stack, MenhirState057) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | SELECT ->
              _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LPAR ->
              _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LOOP ->
              _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | IF ->
              _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | CALL_INDIRECT ->
              _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | BLOCK ->
              _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState312
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState312
          | RPAR ->
              let _v = _menhir_action_131 () in
              _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState312 _tok
          | _ ->
              _eRR ())
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState057
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState057
      | _ ->
          _eRR ()
  
  and _menhir_run_058 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_251 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_plain_instr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState500 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState486 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState470 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState397 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState417 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState401 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState405 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState057 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState118 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState126 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState144 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState150 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState157 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState169 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState290 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState286 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState187 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState260 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState191 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState193 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState246 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState197 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState215 ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState474 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState422 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState416 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState400 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState410 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState404 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState390 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState312 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState143 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState147 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState156 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState280 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState170 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState273 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState186 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState264 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState259 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState190 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState214 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState218 ->
          _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_229 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_plain_instr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState229
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_230 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_126 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState126 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_059 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_254 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_060 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_253 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_061 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_VEC_STORE_LANE (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState061
      | ALIGN_EQ_NAT _ | NAT _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState061 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_062 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_196 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_offset_opt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_offset_opt : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState164 ->
          _menhir_run_165 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState114 ->
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState085 ->
          _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState081 ->
          _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState067 ->
          _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState061 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_165 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LOAD as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState165
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_166 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_064 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_offset_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_006 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_align_opt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_align_opt : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_offset_opt as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState165 ->
          _menhir_run_166 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState115 ->
          _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState086 ->
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState082 ->
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState068 ->
          _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState063 ->
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_166 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LOAD, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_LOAD (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_229 _1 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_116 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_STORE, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_STORE (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_230 _1 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_087 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_LOAD, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_VEC_LOAD (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_231 _1 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_083 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_LOAD_LANE, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
          let MenhirCell1_VEC_LOAD_LANE (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _4, _3) = (_endpos_1, _v_0, _v) in
          let _v = _menhir_action_233 _1 _2 _3 _4 _endpos__4_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_069 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_STORE, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_VEC_STORE (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_232 _1 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_065 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_STORE_LANE, ttv_result) _menhir_cell1_offset_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset_opt (_menhir_stack, _, _2) = _menhir_stack in
          let MenhirCell1_VEC_STORE_LANE (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _4, _3) = (_endpos_1, _v_0, _v) in
          let _v = _menhir_action_234 _1 _2 _3 _4 _endpos__4_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_115 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_STORE as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState115
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_086 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_LOAD as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState086
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_082 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_LOAD_LANE as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState082
      | NAT _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_068 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_STORE as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState068
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_063 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VEC_STORE_LANE as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ALIGN_EQ_NAT _v_0 ->
          _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState063
      | NAT _ ->
          let _v_1 = _menhir_action_005 () in
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_067 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_VEC_STORE (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState067
      | ALIGN_EQ_NAT _ | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState067 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_070 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_258 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_071 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_VEC_SHUFFLE (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | NAT _v ->
          _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState071
      | INT _v ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState071
      | FLOAT _v ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState071
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_145 () in
          _menhir_run_077 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_072 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_188 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_num _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_num : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState618 ->
          _menhir_run_621 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState620 ->
          _menhir_run_621 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState629 ->
          _menhir_run_582 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState581 ->
          _menhir_run_582 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState183 ->
          _menhir_run_184 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState572 ->
          _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState091 ->
          _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState075 ->
          _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState071 ->
          _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_621 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_191 _1 in
      _menhir_goto_numpat _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_numpat : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_numpat (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState620
      | NAN _v_1 ->
          _menhir_run_619 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState620
      | INT _v_2 ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState620
      | FLOAT _v_3 ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState620
      | RPAR ->
          let _v_4 = _menhir_action_147 () in
          _menhir_run_622 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4
      | _ ->
          _eRR ()
  
  and _menhir_run_619 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_192 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_numpat _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_073 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_189 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_num _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_run_074 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_190 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_num _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_run_622 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_numpat -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_numpat (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_148 x xs in
      _menhir_goto_list_numpat_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_goto_list_numpat_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState618 ->
          _menhir_run_623 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState620 ->
          _menhir_run_622 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_623 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_VEC_CONST _menhir_cell0_VEC_SHAPE -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell0_VEC_SHAPE (_menhir_stack, _3) = _menhir_stack in
      let MenhirCell0_VEC_CONST (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _4) = (_endpos, _v) in
      let _v = _menhir_action_270 _3 _4 _endpos__5_ _startpos__1_ in
      _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_result : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_result (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_616 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState632
      | RPAR ->
          let _v_0 = _menhir_action_149 () in
          _menhir_run_635 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_616 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_CONST _v ->
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_VEC_CONST (_menhir_stack, _v, _startpos_0) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_SHAPE _v_1 ->
              let _menhir_stack = MenhirCell0_VEC_SHAPE (_menhir_stack, _v_1) in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | NAT _v_2 ->
                  _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState618
              | NAN _v_3 ->
                  _menhir_run_619 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState618
              | INT _v_4 ->
                  _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState618
              | FLOAT _v_5 ->
                  _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState618
              | RPAR ->
                  let _v_6 = _menhir_action_147 () in
                  _menhir_run_623 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6
              | _ ->
                  _eRR ())
          | _ ->
              _eRR ())
      | REF_NULL ->
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          _menhir_run_575 _menhir_stack _menhir_lexbuf _menhir_lexer
      | REF_FUNC ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_startpos__1_, _endpos__3_) = (_startpos, _endpos) in
              let _v = _menhir_action_268 _endpos__3_ _startpos__1_ in
              _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
          | _ ->
              _eRR ())
      | REF_EXTERN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_startpos__1_, _endpos__3_) = (_startpos, _endpos) in
              let _v = _menhir_action_269 _endpos__3_ _startpos__1_ in
              _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
          | NAT _v ->
              let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
              _menhir_run_579 _menhir_stack _menhir_lexbuf _menhir_lexer _v
          | _ ->
              _eRR ())
      | CONST _v ->
          let _startpos_8 = _menhir_lexbuf.Lexing.lex_start_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | NAT _v_9 ->
              let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
              let _menhir_stack = MenhirCell0_CONST (_menhir_stack, _v, _startpos_8) in
              _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState629
          | NAN _v_10 ->
              let _startpos_11 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | RPAR ->
                  let _endpos_12 = _menhir_lexbuf.Lexing.lex_curr_p in
                  let _tok = _menhir_lexer _menhir_lexbuf in
                  let (_startpos__1_, _2, _endpos__4_, _endpos__3_, _startpos__3_, _3) = (_startpos, _v, _endpos_12, _endpos, _startpos_11, _v_10) in
                  let _v = _menhir_action_266 _2 _3 _endpos__3_ _endpos__4_ _startpos__1_ _startpos__3_ in
                  _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
              | _ ->
                  _eRR ())
          | INT _v_13 ->
              let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
              let _menhir_stack = MenhirCell0_CONST (_menhir_stack, _v, _startpos_8) in
              _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState629
          | FLOAT _v_14 ->
              let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
              let _menhir_stack = MenhirCell0_CONST (_menhir_stack, _v, _startpos_8) in
              _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState629
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_575 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell0_REF_NULL (_menhir_stack, _startpos) in
      let _menhir_s = MenhirState575 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | FUNC ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXTERN ->
          _menhir_run_129 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_128 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _endpos__1_ = _endpos in
      let _v = _menhir_action_261 () in
      _menhir_goto_ref_kind _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_ref_kind : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState575 ->
          _menhir_run_576 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState127 ->
          _menhir_run_130 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_576 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_REF_NULL -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_REF_NULL (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_157 _3 in
          _menhir_goto_literal_ref _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_literal_ref : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState714 ->
          _menhir_run_633 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState615 ->
          _menhir_run_633 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState632 ->
          _menhir_run_633 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState691 ->
          _menhir_run_585 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState587 ->
          _menhir_run_585 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState569 ->
          _menhir_run_585 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_633 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_267 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_585 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_155 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_literal _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_literal : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_literal (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_570 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState587
      | RPAR ->
          let _v_0 = _menhir_action_143 () in
          _menhir_run_588 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_570 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_CONST _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_VEC_CONST (_menhir_stack, _v, _startpos_0) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_SHAPE _v_1 ->
              let _menhir_stack = MenhirCell0_VEC_SHAPE (_menhir_stack, _v_1) in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | NAT _v_2 ->
                  _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState572
              | INT _v_3 ->
                  _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState572
              | FLOAT _v_4 ->
                  _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState572
              | RPAR ->
                  let _v_5 = _menhir_action_145 () in
                  _menhir_run_573 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 _tok
              | _ ->
                  _eRR ())
          | _ ->
              _eRR ())
      | REF_NULL ->
          _menhir_run_575 _menhir_stack _menhir_lexbuf _menhir_lexer
      | REF_EXTERN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | NAT _v ->
              _menhir_run_579 _menhir_stack _menhir_lexbuf _menhir_lexer _v
          | _ ->
              _eRR ())
      | CONST _v ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_CONST (_menhir_stack, _v, _startpos) in
          let _menhir_s = MenhirState581 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | NAT _v ->
              _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | INT _v ->
              _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | FLOAT _v ->
              _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_573 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_VEC_CONST _menhir_cell0_VEC_SHAPE -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_VEC_SHAPE (_menhir_stack, _3) = _menhir_stack in
          let MenhirCell0_VEC_CONST (_menhir_stack, _2, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos_0, _v) in
          let _v = _menhir_action_159 _2 _3 _4 _endpos__5_ _startpos__1_ in
          let (_endpos, _startpos) = (_endpos__5_, _startpos__1_) in
          let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_154 _1 _endpos__1_ _startpos__1_ in
          _menhir_goto_literal _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_579 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _endpos__3_, _startpos__3_, _3) = (_endpos_0, _endpos, _startpos, _v) in
          let _v = _menhir_action_158 _3 _endpos__3_ _startpos__3_ in
          _menhir_goto_literal_ref _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_588 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_literal -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_literal (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_144 x xs in
      _menhir_goto_list_literal_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_list_literal_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState691 ->
          _menhir_run_692 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState569 ->
          _menhir_run_589 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState587 ->
          _menhir_run_588 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_692 : type  ttv_stack. (((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_name -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_name (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_5, _endpos__6_) = (_v, _endpos) in
      let _v = _menhir_action_003 _3 _4 _5 _endpos__6_ _startpos__1_ in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_action : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_735 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState725 ->
          _menhir_run_726 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState713 ->
          _menhir_run_714 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState706 ->
          _menhir_run_710 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState667 ->
          _menhir_run_657 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_657 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_657 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_657 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState646 ->
          _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState613 ->
          _menhir_run_615 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState605 ->
          _menhir_run_610 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_735 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_041 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_cmd : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_733 _menhir_stack _v
      | MenhirState667 ->
          _menhir_run_654 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_654 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_654 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_654 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_654 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_cmd (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_549 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState654
      | EOF | RPAR ->
          let _v_0 = _menhir_action_141 () in
          _menhir_run_655 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_549 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | SCRIPT ->
          _menhir_run_545 _menhir_stack _menhir_lexbuf _menhir_lexer
      | REGISTER ->
          _menhir_run_550 _menhir_stack _menhir_lexbuf _menhir_lexer
      | OUTPUT ->
          _menhir_run_554 _menhir_stack _menhir_lexbuf _menhir_lexer
      | MODULE ->
          _menhir_run_559 _menhir_stack _menhir_lexbuf _menhir_lexer
      | INVOKE ->
          _menhir_run_567 _menhir_stack _menhir_lexbuf _menhir_lexer
      | INPUT ->
          _menhir_run_591 _menhir_stack _menhir_lexbuf _menhir_lexer
      | GET ->
          _menhir_run_595 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_UNLINKABLE ->
          _menhir_run_599 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_TRAP ->
          _menhir_run_605 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_RETURN ->
          _menhir_run_613 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_MALFORMED ->
          _menhir_run_638 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_INVALID ->
          _menhir_run_642 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ASSERT_EXHAUSTION ->
          _menhir_run_646 _menhir_stack _menhir_lexbuf _menhir_lexer
      | _ ->
          _eRR ()
  
  and _menhir_run_545 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_546 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState545
      | LPAR | RPAR ->
          let _v = _menhir_action_199 () in
          _menhir_run_548 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState545 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_546 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_277 _1 _endpos__1_ _startpos__1_ in
      let x = _v in
      let _v = _menhir_action_200 x in
      _menhir_goto_option_script_var_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_option_script_var_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState694 ->
          _menhir_run_695 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState674 ->
          _menhir_run_675 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState666 ->
          _menhir_run_667 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState591 ->
          _menhir_run_592 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState554 ->
          _menhir_run_555 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState545 ->
          _menhir_run_548 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_695 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_1, _v_0, _v) in
              let _v = _menhir_action_168 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_goto_meta : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_732 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState667 ->
          _menhir_run_651 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_651 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_651 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_651 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_732 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_045 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_651 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_045 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_675 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_1, _v_0, _v) in
              let _v = _menhir_action_169 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos, _v) in
          let _v = _menhir_action_170 _3 _endpos__4_ _startpos__1_ in
          _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_667 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_script_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_549 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState667
      | RPAR ->
          let _v_0 = _menhir_action_141 () in
          _menhir_run_668 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_668 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_script_var_ -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_option_script_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_167 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_592 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_1, _v_0, _v) in
              let _v = _menhir_action_168 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_555 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_1, _v_0, _v) in
              let _v = _menhir_action_169 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos, _v) in
          let _v = _menhir_action_170 _3 _endpos__4_ _startpos__1_ in
          _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_548 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_script_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_549 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState548
      | RPAR ->
          let _v_0 = _menhir_action_141 () in
          _menhir_run_652 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_652 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_script_var_ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_option_script_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_167 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_meta _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_550 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState550 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | STRING _v ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_042 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_187 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_name _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_name : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState699 ->
          _menhir_run_700 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState690 ->
          _menhir_run_691 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState670 ->
          _menhir_run_671 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState596 ->
          _menhir_run_597 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState568 ->
          _menhir_run_569 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState550 ->
          _menhir_run_551 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState451 ->
          _menhir_run_452 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState355 ->
          _menhir_run_356 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState354 ->
          _menhir_run_355 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState046 ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState043 ->
          _menhir_run_044 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState041 ->
          _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_700 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_ -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_004 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_691 : type  ttv_stack. (((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_ as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_570 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState691
      | RPAR ->
          let _v_0 = _menhir_action_143 () in
          _menhir_run_692 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_671 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState671
      | RPAR ->
          let _v_1 = _menhir_action_197 () in
          _menhir_run_672 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_336 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_186 _1 _endpos__1_ _startpos__1_ in
      let x = _v in
      let _v = _menhir_action_198 x in
      _menhir_goto_option_module_var_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_option_module_var_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState698 ->
          _menhir_run_699 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState689 ->
          _menhir_run_690 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState679 ->
          _menhir_run_680 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState671 ->
          _menhir_run_672 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState595 ->
          _menhir_run_596 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState567 ->
          _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState559 ->
          _menhir_run_560 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState551 ->
          _menhir_run_552 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState335 ->
          _menhir_run_337 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_699 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState699
      | _ ->
          _eRR ()
  
  and _menhir_run_690 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState690
      | _ ->
          _eRR ()
  
  and _menhir_run_680 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | QUOTE ->
          let _menhir_stack = MenhirCell1_QUOTE (_menhir_stack, MenhirState680) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_0 = _menhir_action_284 () in
          _menhir_run_682 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState681 _tok
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState680
      | BIN ->
          let _menhir_stack = MenhirCell1_BIN (_menhir_stack, MenhirState680) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_1 = _menhir_action_284 () in
          _menhir_run_685 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState684 _tok
      | RPAR ->
          let _v_2 = _menhir_action_174 () in
          _menhir_run_687 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_682 : type  ttv_stack. ((((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_QUOTE as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_QUOTE (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_276 _3 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_344 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_string_list -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_string_list (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_285 _1 _2 in
      _menhir_goto_string_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_string_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState684 ->
          _menhir_run_685 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState681 ->
          _menhir_run_682 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState564 ->
          _menhir_run_565 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState561 ->
          _menhir_run_562 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState510 ->
          _menhir_run_511 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState506 ->
          _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState499 ->
          _menhir_run_504 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState342 ->
          _menhir_run_343 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_685 : type  ttv_stack. ((((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_, _menhir_box_script1) _menhir_cell1_BIN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_BIN (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_275 _3 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_script_module : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_729 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState721 ->
          _menhir_run_722 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState717 ->
          _menhir_run_718 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState706 ->
          _menhir_run_707 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState702 ->
          _menhir_run_703 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState667 ->
          _menhir_run_650 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_650 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_650 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_650 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState642 ->
          _menhir_run_643 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState638 ->
          _menhir_run_639 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState605 ->
          _menhir_run_607 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState599 ->
          _menhir_run_601 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_729 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_043 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_722 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_008 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_goto_assertion : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_734 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState667 ->
          _menhir_run_656 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_656 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_656 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_656 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_734 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_042 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_656 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_042 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_718 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_007 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_707 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_010 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_703 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_009 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_650 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_043 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_643 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_008 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_639 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_007 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_607 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_010 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_601 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_009 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_565 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_, ttv_result) _menhir_cell1_BIN as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_BIN (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_275 _3 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_562 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_, ttv_result) _menhir_cell1_QUOTE as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_QUOTE (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_276 _3 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_511 : type  ttv_stack ttv_result. (((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_memory_use, ttv_result) _menhir_cell1_offset as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset (_menhir_stack, _, _5) = _menhir_stack in
          let MenhirCell1_memory_use (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_6, _endpos__7_) = (_v, _endpos) in
          let _v = _menhir_action_048 _3 _4 _5 _6 _endpos__7_ _startpos__1_ in
          _menhir_goto_data _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_data : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_data (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState530
      | EOF | RPAR ->
          let _v_0 = _menhir_action_174 () in
          _menhir_run_531 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_338 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TYPE ->
          _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer
      | TABLE ->
          _menhir_run_036 _menhir_stack _menhir_lexbuf _menhir_lexer
      | START ->
          _menhir_run_332 _menhir_stack _menhir_lexbuf _menhir_lexer
      | MEMORY ->
          _menhir_run_339 _menhir_stack _menhir_lexbuf _menhir_lexer
      | IMPORT ->
          _menhir_run_354 _menhir_stack _menhir_lexbuf _menhir_lexer
      | GLOBAL ->
          _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer
      | FUNC ->
          _menhir_run_395 _menhir_stack _menhir_lexbuf _menhir_lexer
      | EXPORT ->
          _menhir_run_451 _menhir_stack _menhir_lexbuf _menhir_lexer
      | ELEM ->
          _menhir_run_468 _menhir_stack _menhir_lexbuf _menhir_lexer
      | DATA ->
          _menhir_run_498 _menhir_stack _menhir_lexbuf _menhir_lexer
      | _ ->
          _eRR ()
  
  and _menhir_run_036 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState036
      | EXTERNREF | FUNCREF | LPAR | NAT _ ->
          let _v = _menhir_action_015 () in
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState036 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_037 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState037
      | LPAR ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | _ ->
          _eRR ()
  
  and _menhir_run_038 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos_2 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos__1_, _startpos__1_, _1, _endpos__2_, _startpos__2_, _2) = (_endpos, _startpos, _v, _endpos_2, _startpos_1, _v_0) in
          let _v = _menhir_action_140 _1 _2 _endpos__1_ _endpos__2_ _startpos__1_ _startpos__2_ in
          _menhir_goto_limits _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | EXTERNREF | FUNCREF | RPAR ->
          let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_139 _1 _endpos__1_ _startpos__1_ in
          _menhir_goto_limits _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_limits : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState363 ->
          _menhir_run_349 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState352 ->
          _menhir_run_349 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState350 ->
          _menhir_run_349 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState340 ->
          _menhir_run_349 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState359 ->
          _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState329 ->
          _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState327 ->
          _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_349 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_165 _1 in
      _menhir_goto_memory_type _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_memory_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState363 ->
          _menhir_run_364 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState350 ->
          _menhir_run_351 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState352 ->
          _menhir_run_346 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState340 ->
          _menhir_run_346 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_364 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_122 _3 _4 in
          _menhir_goto_import_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_import_desc : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name -> _ -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_name (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_name (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos, _endpos__5_, _startpos__5_, _5, _endpos__6_) = (_endpos_0, _endpos, _startpos, _v, _endpos_0) in
          let _v = _menhir_action_118 _3 _4 _5 _endpos__5_ _endpos__6_ _startpos__1_ _startpos__5_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_import (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState520
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_521 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_521 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_import -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_import (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_184 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_module_fields1 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState543 ->
          _menhir_run_659 _menhir_stack _menhir_lexbuf _endpos _startpos _v _tok
      | MenhirState680 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState560 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState000 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState337 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState513 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState514 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState530 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState528 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState526 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState524 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState522 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState520 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState518 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState515 ->
          _menhir_run_516 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_516 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_175 _1 in
      _menhir_goto_module_fields _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_module_fields : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState680 ->
          _menhir_run_687 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState000 ->
          _menhir_run_537 _menhir_stack _endpos _startpos _v _tok
      | MenhirState560 ->
          _menhir_run_534 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState337 ->
          _menhir_run_534 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState513 ->
          _menhir_run_533 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState514 ->
          _menhir_run_532 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState530 ->
          _menhir_run_531 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState528 ->
          _menhir_run_529 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState526 ->
          _menhir_run_527 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState524 ->
          _menhir_run_525 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState522 ->
          _menhir_run_523 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState520 ->
          _menhir_run_521 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState518 ->
          _menhir_run_519 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState515 ->
          _menhir_run_517 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_687 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_option_module_var_ -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos_0, _v) in
          let _v = _menhir_action_173 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_module_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_module_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState664 ->
          _menhir_run_731 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState721 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState717 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState706 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState702 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState667 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState543 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState654 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState548 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState642 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState638 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState605 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState599 ->
          _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState000 ->
          _menhir_run_538 _menhir_stack _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_731 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_274 _1 in
      _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_604 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_274 _1 in
      _menhir_goto_script_module _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_534 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos_0, _v) in
          let _v = _menhir_action_173 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_module_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_533 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_type_def -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_type_def (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_176 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_532 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_table -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_table (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_178 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_531 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_data -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_data (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_182 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_529 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_elem -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_elem (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_181 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_527 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_export -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_export (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_185 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_525 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_func -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_func (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_180 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_523 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_global -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_global (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_177 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_519 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_memory -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_memory (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_179 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_517 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_start -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_start (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_183 _1 _2 in
      _menhir_goto_module_fields1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_351 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_import -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_import (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_162 _1 _2 in
      _menhir_goto_memory_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_memory_fields : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState352 ->
          _menhir_run_353 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState340 ->
          _menhir_run_347 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_353 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_export -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_export (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_163 _1 _2 in
      _menhir_goto_memory_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_347 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_160 _3 _4 _endpos__5_ _startpos__1_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_memory (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState518
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_519 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_346 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_161 _1 in
      _menhir_goto_memory_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_325 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_limits (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState325
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState325
      | _ ->
          _eRR ()
  
  and _menhir_run_011 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _v = _menhir_action_264 () in
      _menhir_goto_ref_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_040 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState040 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | IMPORT ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXPORT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_041 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_IMPORT (_menhir_stack, _menhir_s) in
      let _menhir_s = MenhirState041 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | STRING _v ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_046 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_EXPORT (_menhir_stack, _menhir_s) in
      let _menhir_s = MenhirState046 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | STRING _v ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_332 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState332 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_055 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_302 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_var _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_var : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState501 ->
          _menhir_run_502 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState471 ->
          _menhir_run_472 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState463 ->
          _menhir_run_464 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState460 ->
          _menhir_run_461 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState457 ->
          _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState454 ->
          _menhir_run_455 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState332 ->
          _menhir_run_333 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState186 ->
          _menhir_run_263 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState192 ->
          _menhir_run_249 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState207 ->
          _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState205 ->
          _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState491 ->
          _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState483 ->
          _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState054 ->
          _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState203 ->
          _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState201 ->
          _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState200 ->
          _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState198 ->
          _menhir_run_199 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState180 ->
          _menhir_run_181 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState177 ->
          _menhir_run_178 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState175 ->
          _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState173 ->
          _menhir_run_174 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState162 ->
          _menhir_run_163 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState160 ->
          _menhir_run_161 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState158 ->
          _menhir_run_159 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState151 ->
          _menhir_run_152 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState136 ->
          _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState132 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState112 ->
          _menhir_run_113 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState111 ->
          _menhir_run_112 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState109 ->
          _menhir_run_110 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState107 ->
          _menhir_run_108 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState105 ->
          _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState103 ->
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState102 ->
          _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState100 ->
          _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState098 ->
          _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_502 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_MEMORY -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_MEMORY (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_166 _3 in
          let _menhir_stack = MenhirCell1_memory_use (_menhir_stack, _menhir_s, _v) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_486 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState509
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_486 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState486 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | OFFSET ->
          _menhir_run_474 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_078 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_255 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_079 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos__1_, _1, _endpos__2_, _2) = (_startpos, _v, _endpos, _v_0) in
          let _v = _menhir_action_260 _1 _2 _endpos__2_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_081 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_VEC_LOAD_LANE (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState081
      | ALIGN_EQ_NAT _ | NAT _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState081 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_085 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_VEC_LOAD (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState085
      | ALIGN_EQ_NAT _ | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState085 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_088 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos__1_, _1, _endpos__2_, _2) = (_startpos, _v, _endpos, _v_0) in
          let _v = _menhir_action_259 _1 _2 _endpos__2_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_090 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_VEC_CONST (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_SHAPE _v_0 ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_VEC_SHAPE (_menhir_stack, _v_0) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | NAT _v_1 ->
              _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState091
          | INT _v_2 ->
              _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState091
          | FLOAT _v_3 ->
              _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState091
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_4 = _menhir_action_145 () in
              _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_4 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_092 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_VEC_CONST _menhir_cell0_VEC_SHAPE -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_VEC_SHAPE (_menhir_stack, _2) = _menhir_stack in
      let MenhirCell1_VEC_CONST (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_250 _1 _2 _3 _endpos__3_ _startpos__1_ in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_093 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_256 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_094 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_252 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_095 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_201 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_096 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_247 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_097 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_245 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_098 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_SIZE (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState098
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_SIZE (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState098
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_223 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_056 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_301 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_var _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_run_100 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_SET (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState100
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_SET (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState100
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_222 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_102 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_TABLE_INIT (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState102 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_105 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_GROW (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState105
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_GROW (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState105
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_224 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_107 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_GET (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState107
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_GET (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState107
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_221 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_109 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_FILL (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState109
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_FILL (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState109
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_225 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_111 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          let _menhir_stack = MenhirCell1_TABLE_COPY (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState111
      | NAT _v ->
          let _menhir_stack = MenhirCell1_TABLE_COPY (_menhir_stack, _menhir_s, _startpos, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState111
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
          let _v = _menhir_action_226 _endpos__1_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_114 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_STORE (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState114
      | ALIGN_EQ_NAT _ | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState114 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_117 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_SELECT (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState117
      | RPAR ->
          let _v = _menhir_action_077 () in
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState117 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_118 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | RESULT ->
          let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, MenhirState118) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_TYPE _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState120
          | NUM_TYPE _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState120
          | FUNCREF ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState120
          | EXTERNREF ->
              _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState120
          | RPAR ->
              let _v = _menhir_action_151 () in
              _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState120
          | _ ->
              _eRR ())
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState118
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState118
      | _ ->
          _eRR ()
  
  and _menhir_run_119 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_207 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_121 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState122
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState122 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_124 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_279 _1 in
      _menhir_goto_select_expr_results _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_select_expr_results : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState117 ->
          _menhir_run_311 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState122 ->
          _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_311 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_SELECT -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_SELECT (_menhir_stack, _, _, _) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_071 _2 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_goto_expr1 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_2, _endpos__3_) = (_v, _endpos) in
          let _v = _menhir_action_069 _2 _endpos__3_ _startpos__1_ in
          _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_expr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState499 ->
          _menhir_run_490 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState509 ->
          _menhir_run_490 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState469 ->
          _menhir_run_490 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState485 ->
          _menhir_run_490 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState479 ->
          _menhir_run_317 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState323 ->
          _menhir_run_317 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState320 ->
          _menhir_run_317 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState054 ->
          _menhir_run_317 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState168 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState298 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState294 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState289 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState474 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState422 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState416 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState400 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState410 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState404 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState390 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState312 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState143 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState147 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState156 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState170 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState280 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState273 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState186 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState264 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState259 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState190 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState214 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState218 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState117 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState192 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState249 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState250 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState196 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState229 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_490 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_194 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_offset _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_offset : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState509 ->
          _menhir_run_510 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState499 ->
          _menhir_run_506 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState469 ->
          _menhir_run_491 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState485 ->
          _menhir_run_487 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_510 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_memory_use as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset (_menhir_stack, _menhir_s, _v) in
      let _v_0 = _menhir_action_284 () in
      _menhir_run_511 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState510 _tok
  
  and _menhir_run_506 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset (_menhir_stack, _menhir_s, _v) in
      let _v_0 = _menhir_action_284 () in
      _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState506 _tok
  
  and _menhir_run_507 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_offset as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_049 _3 _4 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_data _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_491 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState491
      | NAT _v_1 ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState491
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState491
      | FUNC ->
          _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState491
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState491
      | RPAR ->
          let _v_2 = _menhir_action_303 () in
          _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState491 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_477 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _v = _menhir_action_060 () in
      let _menhir_stack = MenhirCell1_elem_kind (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState483
      | NAT _v_1 ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState483
      | RPAR ->
          let _v_2 = _menhir_action_303 () in
          _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState483 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_316 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_063 _1 in
      _menhir_goto_elem_var_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_elem_var_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState491 ->
          _menhir_run_492 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState483 ->
          _menhir_run_484 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState054 ->
          _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_492 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_offset -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_055 _3 _4 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_elem _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_elem : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_elem (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState528
      | EOF | RPAR ->
          let _v_0 = _menhir_action_174 () in
          _menhir_run_529 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_484 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_elem_kind -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_elem_kind (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_061 _1 _2 in
      _menhir_goto_elem_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_elem_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState469 ->
          _menhir_run_496 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState491 ->
          _menhir_run_494 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState487 ->
          _menhir_run_488 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState478 ->
          _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_496 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_051 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_elem _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_494 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_offset -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_054 _3 _4 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_elem _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_488 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_table_use, ttv_result) _menhir_cell1_offset -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_offset (_menhir_stack, _, _5) = _menhir_stack in
          let MenhirCell1_table_use (_menhir_stack, _, _4) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_6, _endpos__7_) = (_v, _endpos) in
          let _v = _menhir_action_052 _3 _4 _5 _6 _endpos__7_ _startpos__1_ in
          _menhir_goto_elem _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_481 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_DECLARE -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_DECLARE (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_5, _endpos__6_) = (_v, _endpos) in
          let _v = _menhir_action_053 _3 _5 _endpos__6_ _startpos__1_ in
          _menhir_goto_elem _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_318 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_ref_type _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_LPAR (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_ref_type (_menhir_stack, _menhir_s, _1) = _menhir_stack in
          let _4 = _v in
          let _v = _menhir_action_291 _1 _4 in
          _menhir_goto_table_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_table_fields : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState329 ->
          _menhir_run_330 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState037 ->
          _menhir_run_050 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_330 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_export -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_export (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_289 _1 _2 in
      _menhir_goto_table_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_050 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_286 _3 _4 _endpos__5_ _startpos__1_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_table (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState514
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_532 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_487 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_table_use as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_offset (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState487
      | FUNC ->
          _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState487
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState487
      | _ ->
          _eRR ()
  
  and _menhir_run_317 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_057 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_elem_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_elem_expr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState479 ->
          _menhir_run_323 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState323 ->
          _menhir_run_323 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState320 ->
          _menhir_run_323 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState054 ->
          _menhir_run_320 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_323 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_elem_expr (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState323
      | RPAR ->
          let _v_0 = _menhir_action_058 () in
          _menhir_run_324 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_324 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_elem_expr -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_elem_expr (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_059 _1 _2 in
      _menhir_goto_elem_expr_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_elem_expr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState479 ->
          _menhir_run_480 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState323 ->
          _menhir_run_324 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState320 ->
          _menhir_run_321 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_480 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_ref_type -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_ref_type (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_062 _1 _2 in
      _menhir_goto_elem_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_321 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_ref_type _menhir_cell0_LPAR, ttv_result) _menhir_cell1_elem_expr -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_elem_expr (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell0_LPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_ref_type (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_290 _1 _4 _5 in
      _menhir_goto_table_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_320 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_ref_type _menhir_cell0_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_elem_expr (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState320
      | RPAR ->
          let _v_0 = _menhir_action_058 () in
          _menhir_run_321 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | _ ->
          _eRR ()
  
  and _menhir_run_289 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState289 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState290 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | THEN ->
              _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_170 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_THEN (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState170
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState170
      | RPAR ->
          let _v = _menhir_action_131 () in
          _menhir_run_277 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState170 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_143 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_SELECT (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LPAR ->
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState143
      | ELSE | END | RPAR ->
          let _v = _menhir_action_131 () in
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState143 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_127 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_REF_NULL (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState127 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | FUNC ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXTERN ->
          _menhir_run_129 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_129 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _endpos__1_ = _endpos in
      let _v = _menhir_action_262 () in
      _menhir_goto_ref_kind _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_run_131 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_242 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_132 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_REF_FUNC (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState132 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_134 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_202 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_135 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_235 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_136 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_MEMORY_INIT (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState136 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_138 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_236 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_139 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_237 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_140 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_238 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_144 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | RESULT ->
          let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, MenhirState144) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_TYPE _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState145
          | NUM_TYPE _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState145
          | FUNCREF ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState145
          | EXTERNREF ->
              _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState145
          | RPAR ->
              let _v = _menhir_action_151 () in
              _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState145
          | _ ->
              _eRR ())
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState144
      | _ ->
          _eRR ()
  
  and _menhir_run_146 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState147
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState147
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState147
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState147
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState147
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState147
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState147
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState147
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState147
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState147
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState147
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState147
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState147
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState147
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState147
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState147
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState147
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LPAR ->
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState147
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState147
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState147
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState147
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState147
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState147
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_22 MenhirState147 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_148 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LOOP (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_137 () in
          _menhir_run_149 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState148 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_149 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LOOP as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState149
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState149
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState149
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState149
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState149
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState149
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState149
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState149
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState149
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState149
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState149
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState149
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState149
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState149
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState149
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState149
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState149
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LPAR ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState149
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState149
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState149
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState149
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState149
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState149
      | END ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState149 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_150 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState150 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TYPE ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_216 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_151 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s) in
      let _menhir_s = MenhirState151 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_154 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState154
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState154
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState154
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState154
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_155 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState154
      | _ ->
          _eRR ()
  
  and _menhir_run_155 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState156
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState156
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState156
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState156
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState156
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState156
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState156
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState156
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState156
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState156
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState156
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState156
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState156
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState156
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState156
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState156
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState156
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | LPAR ->
          let _menhir_s = MenhirState156 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState157 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | LOAD _v_39 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_39 MenhirState156
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | CONVERT _v_40 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_40 MenhirState156
      | CONST _v_41 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_41 MenhirState156
      | COMPARE _v_42 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_42 MenhirState156
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState156
      | BINARY _v_43 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_43 MenhirState156
      | ELSE | END | RPAR ->
          let _v_44 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_44 MenhirState156 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_141 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LOOP (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState141
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_137 () in
          _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState141 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_142 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOOP as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState142
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState142
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState142
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState142
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState142
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState142
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState142
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState142
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState142
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState142
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState142
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState142
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState142
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState142
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState142
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState142
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState142
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LPAR ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState142
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState142
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState142
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState142
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState142
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState142 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_158 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LOCAL_TEE (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState158 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_160 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LOCAL_SET (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState160 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_162 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LOCAL_GET (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState162 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_164 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LOAD (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OFFSET_EQ_NAT _v_0 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState164
      | ALIGN_EQ_NAT _ | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_1 = _menhir_action_195 () in
          _menhir_run_165 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState164 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_171 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState171
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_137 () in
          _menhir_run_172 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState171 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_172 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IF as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState172
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState172
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState172
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState172
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState172
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState172
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState172
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState172
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState172
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState172
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState172
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState172
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState172
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState172
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState172
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState172
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState172
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LPAR ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState172
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState172
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState172
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState172
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState172
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState172
      | ELSE | END ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState172 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_173 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_GLOBAL_SET (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState173 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_175 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_GLOBAL_GET (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState175 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_177 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_ELEM_DROP (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState177 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_179 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_203 () in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_180 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_DATA_DROP (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState180 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_182 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_249 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_183 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_CONST (_menhir_stack, _menhir_s, _v, _startpos) in
      let _menhir_s = MenhirState183 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | NAT _v ->
          _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | INT _v ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | FLOAT _v ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_185 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_246 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_186 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_CALL_INDIRECT (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LPAR ->
          _menhir_run_187 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState186
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState186
      | ELSE | END | RPAR ->
          let _v = _menhir_action_131 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState186 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_187 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState187 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TYPE ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_188 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_188 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState188
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState188
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState188
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState188
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_189 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState188
      | _ ->
          _eRR ()
  
  and _menhir_run_189 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState190
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState190
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState190
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState190
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState190
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState190
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState190
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState190
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState190
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState190
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState190
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState190
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState190
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState190
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState190
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState190
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState190
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | LPAR ->
          let _menhir_s = MenhirState190 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState191 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_188 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | LOAD _v_39 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_39 MenhirState190
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | CONVERT _v_40 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_40 MenhirState190
      | CONST _v_41 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_41 MenhirState190
      | COMPARE _v_42 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_42 MenhirState190
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState190
      | BINARY _v_43 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_43 MenhirState190
      | ELSE | END | RPAR ->
          let _v_44 = _menhir_action_131 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_44 MenhirState190 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_167 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState167
      | LPAR ->
          let _v = _menhir_action_137 () in
          _menhir_run_168 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState167 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_168 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IF as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState168 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState169 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TYPE ->
              _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | THEN ->
              _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_283 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | PARAM ->
              _menhir_run_292 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_283 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState283
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState283
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState283
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState283
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_284 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState283
      | _ ->
          _eRR ()
  
  and _menhir_run_284 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _menhir_s = MenhirState285 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState286 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | THEN ->
              _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_283 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_192 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_CALL_INDIRECT (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState192
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState192
      | LPAR ->
          _menhir_run_193 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState192
      | RPAR ->
          let _v = _menhir_action_077 () in
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState192 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_193 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState193 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TYPE ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_194 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_243 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_194 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState194
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState194
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState194
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState194
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_195 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState194
      | _ ->
          _eRR ()
  
  and _menhir_run_195 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState196 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState197 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_194 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | RPAR ->
          let _v_22 = _menhir_action_077 () in
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState196 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_198 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_CALL (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState198 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_200 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_BR_TABLE (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState200 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_205 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_BR_IF (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState205 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_207 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_BR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState207 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NAT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_209 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_BLOCK (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState209
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_137 () in
          _menhir_run_210 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState209 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_210 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_BLOCK as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState210
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState210
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState210
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState210
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState210
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState210
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState210
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState210
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState210
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState210
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState210
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState210
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState210
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState210
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState210
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState210
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState210
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LPAR ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState210
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState210
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState210
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState210
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState210
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState210
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState210 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_211 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_BLOCK (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState211
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_137 () in
          _menhir_run_212 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState211 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_212 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_BLOCK as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState212
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState212
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState212
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState212
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState212
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState212
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState212
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState212
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState212
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState212
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState212
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState212
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState212
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState212
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState212
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState212
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState212
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LPAR ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState212
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState212
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState212
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState212
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState212
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState212
      | END ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState212 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_213 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_248 _1 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_221 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_025 _1 in
      _menhir_goto_block_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_block_result_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState156 ->
          _menhir_run_302 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState142 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState214 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState218 ->
          _menhir_run_227 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_302 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_026 _3 _5 in
      _menhir_goto_block_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_227 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_023 _1 in
      _menhir_goto_block_param_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_block_param_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState142 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState214 ->
          _menhir_run_233 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState218 ->
          _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_234 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_018 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_block _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_block : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState142 ->
          _menhir_run_309 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState149 ->
          _menhir_run_303 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_269 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState212 ->
          _menhir_run_235 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_309 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOOP, ttv_result) _menhir_cell1_labeling_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_LOOP (_menhir_stack, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_075 _2 _3 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_303 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LOOP, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_block (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | END ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VAR _v_0 ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState304
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_1 = _menhir_action_135 () in
              _menhir_run_305 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_305 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LOOP, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_block (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_LOOP (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_020 _2 _3 _5 in
      _menhir_goto_block_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_block_instr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_129 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_instr1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_instr1 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_instr1 (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState222
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState222
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState222
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState222
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState222
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState222
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState222
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState222
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState222
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState222
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState222
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState222
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState222
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState222
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState222
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState222
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState222
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState222
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState222
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState222
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState222
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState222
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState222
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_22 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_223 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_instr1 -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_instr1 (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_132 _1 _2 in
      _menhir_goto_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState446 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState422 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState416 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState400 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState410 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState404 ->
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState474 ->
          _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState390 ->
          _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState312 ->
          _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState143 ->
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState147 ->
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState280 ->
          _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState170 ->
          _menhir_run_277 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState273 ->
          _menhir_run_274 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState186 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState264 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState259 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState190 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState142 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState156 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState214 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState218 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_406 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_080 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_func_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState396 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState422 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState416 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState400 ->
          _menhir_run_413 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState410 ->
          _menhir_run_411 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState404 ->
          _menhir_run_407 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_413 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_096 _1 in
      _menhir_goto_func_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_result_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState396 ->
          _menhir_run_418 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_418 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_418 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState422 ->
          _menhir_run_418 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState416 ->
          _menhir_run_418 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState400 ->
          _menhir_run_412 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_418 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_088 _1 in
      _menhir_goto_func_fields_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_fields_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState396 ->
          _menhir_run_447 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_447 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState424 ->
          _menhir_run_425 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState422 ->
          _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState416 ->
          _menhir_run_419 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_447 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_084 _1 in
      _menhir_goto_func_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_fields : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState396 ->
          _menhir_run_449 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState446 ->
          _menhir_run_448 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_449 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_FUNC, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_079 _3 _4 _endpos__5_ _startpos__1_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_func (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState524
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_525 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_448 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_export -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_export (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_087 _1 _2 in
      _menhir_goto_func_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_425 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_083 _1 _2 in
      _menhir_goto_func_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_423 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_bind_var, ttv_result) _menhir_cell1_value_type _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_value_type (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_bind_var (_menhir_stack, _, _3, _) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _6 = _v in
      let _v = _menhir_action_090 _3 _4 _6 in
      _menhir_goto_func_fields_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_419 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_089 _3 _5 in
      _menhir_goto_func_fields_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_412 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_097 _3 _5 in
      _menhir_goto_func_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_411 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOCAL, ttv_result) _menhir_cell1_bind_var, ttv_result) _menhir_cell1_value_type _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_value_type (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_bind_var (_menhir_stack, _, _3, _) = _menhir_stack in
      let MenhirCell1_LOCAL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _6 = _v in
      let _v = _menhir_action_082 _3 _4 _6 in
      _menhir_goto_func_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_407 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOCAL, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_LOCAL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_081 _3 _5 in
      _menhir_goto_func_body _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_313 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_046 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_const_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_const_expr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState474 ->
          _menhir_run_475 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState390 ->
          _menhir_run_391 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState312 ->
          _menhir_run_314 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_475 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_OFFSET -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_OFFSET (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_193 _3 in
          _menhir_goto_offset _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_391 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_global_type -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_global_type (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_104 _1 _2 in
      _menhir_goto_global_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_global_fields : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState385 ->
          _menhir_run_393 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState389 ->
          _menhir_run_392 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_393 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_103 _3 _4 _endpos__5_ _startpos__1_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_global (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState522
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_523 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_392 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_export -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_export (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_106 _1 _2 in
      _menhir_goto_global_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_314 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_ITEM -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_ITEM (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_056 _3 in
          _menhir_goto_elem_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_307 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let (_endpos__1_, _1) = (_endpos, _v) in
      let _v = _menhir_action_282 _1 in
      _menhir_goto_select_instr_results_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_select_instr_results_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState143 ->
          _menhir_run_308 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState147 ->
          _menhir_run_306 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_308 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_SELECT -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_SELECT (_menhir_stack, _menhir_s, _startpos__1_, _endpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_280 _2 _endpos__1_ _startpos__1_ in
      let (_endpos, _startpos) = (_endpos__2_, _startpos__1_) in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_133 _1 in
      _menhir_goto_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_306 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_281 _3 _5 in
      _menhir_goto_select_instr_results_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _v _menhir_s _tok
  
  and _menhir_run_281 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_instr_list _menhir_cell0_RPAR _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_LPAR (_menhir_stack, _) = _menhir_stack in
          let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_instr_list (_menhir_stack, _, _3, _, _) = _menhir_stack in
          let MenhirCell1_THEN (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__8_, _7) = (_endpos_0, _v) in
          let _v = _menhir_action_110 _3 _7 in
          _menhir_goto_if_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__8_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_if_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState289 ->
          _menhir_run_291 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState168 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState298 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState294 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_291 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_expr -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_expr (_menhir_stack, _menhir_s, _1, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_109 _1 _2 in
      _menhir_goto_if_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_288 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_116 _1 in
      _menhir_goto_if_block_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_if_block_result_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState168 ->
          _menhir_run_296 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState298 ->
          _menhir_run_296 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState294 ->
          _menhir_run_296 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_296 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_114 _1 in
      _menhir_goto_if_block_param_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_if_block_param_body : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState168 ->
          _menhir_run_300 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok
      | MenhirState298 ->
          _menhir_run_299 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState294 ->
          _menhir_run_297 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_300 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt -> _ -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_113 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_if_block _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_goto_if_block : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_IF (_menhir_stack, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_076 _2 _3 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_299 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _, _1, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_112 _1 _2 _endpos__2_ _startpos__1_ in
      _menhir_goto_if_block _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_297 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_115 _3 _5 in
      _menhir_goto_if_block_param_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_287 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_117 _3 _5 in
      _menhir_goto_if_block_result_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_277 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_THEN as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              let _menhir_stack = MenhirCell1_instr_list (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos_0) in
              let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
              let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos_1) in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | ELSE ->
                  let _tok = _menhir_lexer _menhir_lexbuf in
                  (match (_tok : MenhirBasics.token) with
                  | VEC_UNARY _v_3 ->
                      _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState280
                  | VEC_TEST _v_4 ->
                      _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState280
                  | VEC_TERNARY _v_5 ->
                      _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState280
                  | VEC_STORE_LANE _v_6 ->
                      _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState280
                  | VEC_STORE _v_7 ->
                      _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState280
                  | VEC_SPLAT _v_8 ->
                      _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState280
                  | VEC_SHUFFLE ->
                      _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | VEC_SHIFT _v_9 ->
                      _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState280
                  | VEC_REPLACE _v_10 ->
                      _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState280
                  | VEC_LOAD_LANE _v_11 ->
                      _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState280
                  | VEC_LOAD _v_12 ->
                      _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState280
                  | VEC_EXTRACT _v_13 ->
                      _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState280
                  | VEC_CONST _v_14 ->
                      _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState280
                  | VEC_BITMASK _v_15 ->
                      _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState280
                  | VEC_BINARY _v_16 ->
                      _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState280
                  | UNREACHABLE ->
                      _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | UNARY _v_17 ->
                      _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState280
                  | TEST _v_18 ->
                      _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState280
                  | TABLE_SIZE ->
                      _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_SET ->
                      _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_INIT ->
                      _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_GROW ->
                      _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_GET ->
                      _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_FILL ->
                      _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | TABLE_COPY ->
                      _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | STORE _v_19 ->
                      _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState280
                  | SELECT ->
                      _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | RETURN ->
                      _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | REF_NULL ->
                      _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | REF_IS_NULL ->
                      _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | REF_FUNC ->
                      _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | NOP ->
                      _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | MEMORY_SIZE ->
                      _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | MEMORY_INIT ->
                      _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | MEMORY_GROW ->
                      _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | MEMORY_FILL ->
                      _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | MEMORY_COPY ->
                      _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LPAR ->
                      _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LOOP ->
                      _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LOCAL_TEE ->
                      _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LOCAL_SET ->
                      _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LOCAL_GET ->
                      _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | LOAD _v_20 ->
                      _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState280
                  | IF ->
                      _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | GLOBAL_SET ->
                      _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | GLOBAL_GET ->
                      _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | ELEM_DROP ->
                      _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | DROP ->
                      _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | DATA_DROP ->
                      _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | CONVERT _v_21 ->
                      _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState280
                  | CONST _v_22 ->
                      _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_22 MenhirState280
                  | COMPARE _v_23 ->
                      _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_23 MenhirState280
                  | CALL_INDIRECT ->
                      _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | CALL ->
                      _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | BR_TABLE ->
                      _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | BR_IF ->
                      _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | BR ->
                      _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | BLOCK ->
                      _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState280
                  | BINARY _v_24 ->
                      _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_24 MenhirState280
                  | RPAR ->
                      let _v_25 = _menhir_action_131 () in
                      _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _v_25 _tok
                  | _ ->
                      _eRR ())
              | _ ->
                  _eRR ())
          | RPAR ->
              let MenhirCell1_THEN (_menhir_stack, _) = _menhir_stack in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__4_, _3) = (_endpos_0, _v) in
              let _v = _menhir_action_111 _3 in
              _menhir_goto_if_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_274 : type  ttv_stack ttv_result. (((((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block, ttv_result) _menhir_cell1_labeling_end_opt as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_instr_list (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | END ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VAR _v_1 ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState275
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_2 = _menhir_action_135 () in
              _menhir_run_276 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_0 _v_2 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_276 : type  ttv_stack ttv_result. (((((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block, ttv_result) _menhir_cell1_labeling_end_opt, ttv_result) _menhir_cell1_instr_list -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_instr_list (_menhir_stack, _, _6, _, _) = _menhir_stack in
      let MenhirCell1_labeling_end_opt (_menhir_stack, _, _5, _) = _menhir_stack in
      let MenhirCell1_block (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__8_, _8) = (_endpos, _v) in
      let _v = _menhir_action_022 _2 _3 _5 _6 _8 in
      _menhir_goto_block_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__8_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_255 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_038 _1 in
      _menhir_goto_call_instr_results_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_instr_results_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState186 ->
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState264 ->
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState259 ->
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState190 ->
          _menhir_run_256 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_261 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_036 _1 in
      _menhir_goto_call_instr_params_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_instr_params_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState186 ->
          _menhir_run_267 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_267 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState264 ->
          _menhir_run_265 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState259 ->
          _menhir_run_262 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_267 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_040 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_instr_type_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_instr_type_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState186 ->
          _menhir_run_268 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState263 ->
          _menhir_run_266 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_268 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_CALL_INDIRECT -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CALL_INDIRECT (_menhir_stack, _menhir_s, _startpos__1_, _endpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_034 _2 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_instr_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_instr_instr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_134 _1 in
      _menhir_goto_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_266 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_CALL_INDIRECT, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_var (_menhir_stack, _, _2, _) = _menhir_stack in
      let MenhirCell1_CALL_INDIRECT (_menhir_stack, _menhir_s, _startpos__1_, _endpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_033 _2 _3 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_instr_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_265 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _menhir_s, _1, _startpos__1_, _endpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_039 _1 _2 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_instr_type_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
  
  and _menhir_run_262 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_035 _3 _5 in
      _menhir_goto_call_instr_params_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_256 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_037 _3 _5 in
      _menhir_goto_call_instr_results_instr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_269 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_block (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | END ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VAR _v_0 ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState270
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_1 = _menhir_action_135 () in
              _menhir_run_271 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
          | _ ->
              _eRR ())
      | ELSE ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VAR _v_2 ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState272
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_3 = _menhir_action_135 () in
              _menhir_run_273 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_3 MenhirState272 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_271 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_block (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_021 _2 _3 _5 in
      _menhir_goto_block_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_273 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_labeling_end_opt (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState273
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState273
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState273
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState273
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState273
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState273
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState273
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState273
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState273
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState273
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState273
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState273
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState273
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState273
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState273
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState273
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState273
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState273
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState273
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState273
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState273
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState273
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState273
      | END ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_274 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState273 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_240 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_BLOCK, ttv_result) _menhir_cell1_labeling_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_BLOCK (_menhir_stack, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_074 _2 _3 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_235 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_BLOCK, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_block (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | END ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VAR _v_0 ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState236
          | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
              let _v_1 = _menhir_action_135 () in
              _menhir_run_237 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_237 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_BLOCK, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_block -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_block (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_labeling_opt (_menhir_stack, _, _2) = _menhir_stack in
      let MenhirCell1_BLOCK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_019 _2 _3 _5 in
      _menhir_goto_block_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_233 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_labeling_opt, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _menhir_s, _1, _startpos__1_, _endpos__1_) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_017 _1 _2 _endpos__1_ _startpos__1_ in
      _menhir_goto_block _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_228 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_024 _3 _5 in
      _menhir_goto_block_param_body _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_241 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_030 _1 in
      _menhir_goto_call_expr_results _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_expr_results : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState192 ->
          _menhir_run_247 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState249 ->
          _menhir_run_247 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState250 ->
          _menhir_run_247 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_247 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState196 ->
          _menhir_run_242 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_247 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_028 _1 in
      _menhir_goto_call_expr_params _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_call_expr_params : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState192 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState249 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState250 ->
          _menhir_run_251 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState245 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_253 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_032 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_expr_type _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_call_expr_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState192 ->
          _menhir_run_254 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState249 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_254 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_CALL_INDIRECT -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_CALL_INDIRECT (_menhir_stack, _, _startpos__1_, _endpos__1_) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_073 _2 _endpos__1_ _startpos__1_ in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_252 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_CALL_INDIRECT, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_var (_menhir_stack, _, _2, _) = _menhir_stack in
      let MenhirCell1_CALL_INDIRECT (_menhir_stack, _, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_072 _2 _3 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_251 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _menhir_s, _1, _startpos__1_, _endpos__1_) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_031 _1 _2 _endpos__1_ _startpos__1_ in
      _menhir_goto_call_expr_type _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_248 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_027 _3 _5 in
      _menhir_goto_call_expr_params _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_242 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_029 _3 _5 in
      _menhir_goto_call_expr_results _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_243 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState243
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState243
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState243
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState243
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState243
      | _ ->
          _eRR ()
  
  and _menhir_run_244 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_246 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState245
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_0 MenhirState245 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_246 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState246 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_194 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_243 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_292 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState292
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState292
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState292
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState292
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_293 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState292
      | _ ->
          _eRR ()
  
  and _menhir_run_293 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _menhir_s = MenhirState294 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_295 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_295 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState295 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | THEN ->
          _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_283 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_292 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_257 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState257
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState257
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState257
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState257
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_258 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState257
      | _ ->
          _eRR ()
  
  and _menhir_run_258 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState259
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState259
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState259
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState259
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState259
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState259
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState259
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState259
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState259
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState259
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState259
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState259
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState259
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState259
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState259
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState259
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState259
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LPAR ->
          _menhir_run_260 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState259
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState259
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState259
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState259
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState259
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState259 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_260 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState260 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_188 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_216 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState216
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState216
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState216
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState216
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_217 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState216
      | _ ->
          _eRR ()
  
  and _menhir_run_217 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState218
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState218
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState218
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState218
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState218
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState218
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState218
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState218
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState218
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState218
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState218
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState218
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState218
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState218
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState218
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState218
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState218
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LPAR ->
          _menhir_run_215 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState218
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState218
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState218
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState218
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState218
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState218
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState218 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_215 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState215 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_216 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_224 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_startpos__1_, _1) = (_startpos, _v) in
      let _v = _menhir_action_130 _1 in
      _menhir_goto_instr1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_125 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState125
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_310 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_310 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_expr -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_expr (_menhir_stack, _menhir_s, _1, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_078 _1 _2 in
      _menhir_goto_expr_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_expr_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState125 ->
          _menhir_run_310 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState192 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState249 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState250 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState196 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState229 ->
          _menhir_run_230 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState117 ->
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_230 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_plain_instr -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_plain_instr (_menhir_stack, _, _1, _, _) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_070 _1 _2 in
      _menhir_goto_expr1 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_123 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_278 _3 _5 in
      _menhir_goto_select_expr_results _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_474 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_OFFSET (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LPAR ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState474
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState474
      | RPAR ->
          let _v = _menhir_action_131 () in
          _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState474 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_472 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_TABLE -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_TABLE (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_293 _3 in
          let _menhir_stack = MenhirCell1_table_use (_menhir_stack, _menhir_s, _v) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_486 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState485
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_464 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_065 _3 in
          _menhir_goto_export_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_export_desc : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name -> _ -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_name (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos, _endpos__5_, _endpos__4_, _startpos__4_, _4) = (_endpos_0, _endpos_0, _endpos, _startpos, _v) in
          let _v = _menhir_action_064 _3 _4 _endpos__4_ _endpos__5_ _startpos__1_ _startpos__4_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_export (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState526
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_527 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_461 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_068 _3 in
          _menhir_goto_export_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_458 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_067 _3 in
          _menhir_goto_export_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_455 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_066 _3 in
          _menhir_goto_export_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_333 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos, _endpos__4_, _3) = (_endpos_0, _endpos_0, _v) in
          let _v = _menhir_action_283 _3 _endpos__4_ _startpos__1_ in
          let _startpos = _startpos__1_ in
          let _menhir_stack = MenhirCell1_start (_menhir_stack, _menhir_s, _v, _startpos) in
          (match (_tok : MenhirBasics.token) with
          | LPAR ->
              _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState515
          | EOF | RPAR ->
              let _v_0 = _menhir_action_174 () in
              _menhir_run_517 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_263 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_CALL_INDIRECT as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState263
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState263
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState263
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState263
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState263
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState263
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState263
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState263
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState263
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState263
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState263
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState263
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState263
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState263
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState263
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState263
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState263
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LPAR ->
          _menhir_run_187 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState263
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState263
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState263
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState263
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState263
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState263
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState263 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_249 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_CALL_INDIRECT as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_193 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState249
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_0 MenhirState249 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_208 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_BR -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_BR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_204 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_206 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_BR_IF -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_BR_IF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_205 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_203 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState203
      | NAT _v_1 ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState203
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_2 = _menhir_action_303 () in
          _menhir_run_204 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_2 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_204 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_var (_menhir_stack, _menhir_s, _1, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_304 _1 _2 in
      _menhir_goto_var_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
  
  and _menhir_goto_var_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState491 ->
          _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState483 ->
          _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState054 ->
          _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState203 ->
          _menhir_run_204 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState201 ->
          _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_202 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_BR_TABLE, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_var (_menhir_stack, _, _2, _) = _menhir_stack in
      let MenhirCell1_BR_TABLE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_206 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_201 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_BR_TABLE as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState201
      | NAT _v_1 ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState201
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_2 = _menhir_action_303 () in
          _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_2 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_199 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_CALL -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CALL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_208 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_181 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_DATA_DROP -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_DATA_DROP (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_240 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_178 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_ELEM_DROP -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ELEM_DROP (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_228 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_176 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_GLOBAL_GET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_GLOBAL_GET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_212 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_174 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_GLOBAL_SET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_GLOBAL_SET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_213 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_163 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LOCAL_GET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_LOCAL_GET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_209 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_161 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LOCAL_SET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_LOCAL_SET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_210 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_159 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LOCAL_TEE -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_LOCAL_TEE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_211 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_152 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_TYPE -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_TYPE (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_297 _3 in
          _menhir_goto_type_use _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_type_use : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState426 ->
          _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState446 ->
          _menhir_run_424 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_424 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState376 ->
          _menhir_run_378 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState168 ->
          _menhir_run_298 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState186 ->
          _menhir_run_264 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState263 ->
          _menhir_run_264 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState192 ->
          _menhir_run_250 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState249 ->
          _menhir_run_250 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState149 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState172 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState210 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState212 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_443 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_inline_import as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_436 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState443
      | RPAR ->
          let _v_0 = _menhir_action_094 () in
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState443 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_437 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_091 _1 in
      _menhir_goto_func_fields_import _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_fields_import : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState426 ->
          _menhir_run_445 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState443 ->
          _menhir_run_444 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState441 ->
          _menhir_run_442 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState435 ->
          _menhir_run_438 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_445 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_import -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_import (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_086 _1 _2 in
      _menhir_goto_func_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_444 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_inline_import, ttv_result) _menhir_cell1_type_use -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_type_use (_menhir_stack, _, _2, _, _) = _menhir_stack in
      let MenhirCell1_inline_import (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_085 _1 _2 _3 in
      _menhir_goto_func_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_442 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_bind_var, ttv_result) _menhir_cell1_value_type _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_value_type (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_bind_var (_menhir_stack, _, _, _) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _6 = _v in
      let _v = _menhir_action_093 _4 _6 in
      _menhir_goto_func_fields_import _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_438 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_092 _3 _5 in
      _menhir_goto_func_fields_import _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_424 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState424
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState424
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState424
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState424
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState424
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState424
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState424
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState424
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState424
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState424
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState424
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState424
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState424
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState424
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState424
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState424
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState424
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LPAR ->
          _menhir_run_417 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState424
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState424
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState424
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState424
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState424
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState424
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState424 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_417 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState417 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_398 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_414 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL ->
          _menhir_run_402 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_398 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState398
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState398
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState398
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState398
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_399 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState398
      | _ ->
          _eRR ()
  
  and _menhir_run_399 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState400
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState400
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState400
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState400
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState400
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState400
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState400
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState400
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState400
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState400
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState400
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState400
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState400
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState400
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState400
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState400
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState400
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | LPAR ->
          let _menhir_s = MenhirState400 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState401 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_398 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL ->
              _menhir_run_402 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | LOAD _v_39 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_39 MenhirState400
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | CONVERT _v_40 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_40 MenhirState400
      | CONST _v_41 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_41 MenhirState400
      | COMPARE _v_42 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_42 MenhirState400
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState400
      | BINARY _v_43 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_43 MenhirState400
      | RPAR ->
          let _v_44 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_44 MenhirState400 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_402 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_LOCAL (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState402
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState402
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState402
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState402
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState402
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_403 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState402
      | _ ->
          _eRR ()
  
  and _menhir_run_403 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOCAL as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState404
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState404
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState404
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState404
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState404
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState404
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState404
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState404
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState404
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState404
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState404
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState404
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState404
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState404
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState404
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState404
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState404
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LPAR ->
          _menhir_run_405 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState404
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState404
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState404
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState404
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState404
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState404
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState404 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_405 : type  ttv_stack ttv_result. (ttv_stack _menhir_cell0_RPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState405 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL ->
          _menhir_run_402 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_414 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState414
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState414
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState414
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState414
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState414
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_415 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState414
      | _ ->
          _eRR ()
  
  and _menhir_run_415 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState416
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState416
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState416
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState416
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState416
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState416
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState416
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState416
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState416
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState416
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState416
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState416
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState416
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState416
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState416
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState416
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState416
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LPAR ->
          _menhir_run_417 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState416
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState416
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState416
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState416
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState416
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState416
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState416 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_378 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos_0, _v) in
          let _v = _menhir_action_119 _3 _4 in
          _menhir_goto_import_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_298 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_295 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState298
      | _ ->
          _eRR ()
  
  and _menhir_run_264 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState264
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState264
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState264
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState264
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState264
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState264
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState264
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState264
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState264
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState264
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState264
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState264
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState264
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState264
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState264
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState264
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState264
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LPAR ->
          _menhir_run_260 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState264
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState264
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState264
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState264
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState264
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState264
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState264 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_250 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_246 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState250
      | RPAR ->
          let _v_0 = _menhir_action_077 () in
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_0 MenhirState250 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_214 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_labeling_opt as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_use (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState214
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState214
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState214
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState214
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState214
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState214
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState214
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState214
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState214
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState214
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState214
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState214
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState214
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState214
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState214
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState214
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState214
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LPAR ->
          _menhir_run_215 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState214
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState214
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState214
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState214
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState214
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState214
      | ELSE | END | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState214 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_137 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_MEMORY_INIT -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_MEMORY_INIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_239 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_133 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_REF_FUNC -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_REF_FUNC (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_243 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_113 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_TABLE_COPY, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_var (_menhir_stack, _, _2, _) = _menhir_stack in
      let MenhirCell1_TABLE_COPY (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_219 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_112 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_TABLE_COPY as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState112
      | NAT _v_1 ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState112
      | _ ->
          _eRR ()
  
  and _menhir_run_110 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_TABLE_FILL -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_TABLE_FILL (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_218 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_108 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_TABLE_GET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_TABLE_GET (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_214 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_106 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_TABLE_GROW -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_TABLE_GROW (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_217 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_104 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_TABLE_INIT, ttv_result) _menhir_cell1_var -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_var (_menhir_stack, _, _2, _) = _menhir_stack in
      let MenhirCell1_TABLE_INIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__3_, _3) = (_endpos, _v) in
      let _v = _menhir_action_220 _2 _3 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_103 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_TABLE_INIT as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState103
      | NAT _v_1 ->
          let _menhir_stack = MenhirCell1_var (_menhir_stack, _menhir_s, _v, _endpos) in
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState103
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let MenhirCell1_TABLE_INIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__2_, _2) = (_endpos, _v) in
          let _v = _menhir_action_227 _2 _endpos__2_ _startpos__1_ in
          _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_101 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_TABLE_SET -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_TABLE_SET (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_215 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_099 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_TABLE_SIZE -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_TABLE_SIZE (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_216 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_339 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState339
      | LPAR | NAT _ ->
          let _v = _menhir_action_015 () in
          _menhir_run_340 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState339 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_340 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState340
      | LPAR ->
          _menhir_run_341 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState340
      | _ ->
          _eRR ()
  
  and _menhir_run_341 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | IMPORT ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState341
      | EXPORT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState341
      | DATA ->
          let _menhir_stack = MenhirCell1_DATA (_menhir_stack, MenhirState341) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v = _menhir_action_284 () in
          _menhir_run_343 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState342 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_343 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_DATA as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_DATA (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_164 _3 in
          _menhir_goto_memory_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_354 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState354 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | STRING _v ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_384 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState384
      | EXTERNREF | FUNCREF | LPAR | NUM_TYPE _ | VEC_TYPE _ ->
          let _v = _menhir_action_015 () in
          _menhir_run_385 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState384 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_385 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState385
      | NUM_TYPE _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState385
      | LPAR ->
          _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState385
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState385
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState385
      | _ ->
          _eRR ()
  
  and _menhir_run_386 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState386 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | MUT ->
          _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | IMPORT ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXPORT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_369 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_MUT (_menhir_stack, _menhir_s) in
      let _menhir_s = MenhirState369 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_395 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState395
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v = _menhir_action_015 () in
          _menhir_run_396 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState395 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_396 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_FUNC as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState396
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState396
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState396
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState396
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState396
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState396
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState396
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState396
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState396
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState396
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState396
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState396
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState396
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState396
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState396
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState396
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState396
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LPAR ->
          _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState396
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState396
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState396
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState396
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState396
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState396
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState396 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_397 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState397 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TEST _v ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_TERNARY _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE_LANE _v ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_STORE _v ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SPLAT _v ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | VEC_SHIFT _v ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_REPLACE _v ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD_LANE _v ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_LOAD _v ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_EXTRACT _v ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_CONST _v ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BITMASK _v ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | VEC_BINARY _v ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UNARY _v ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TYPE ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TEST _v ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | STORE _v ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | SELECT ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | RESULT ->
          _menhir_run_398 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_414 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOOP ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOCAL ->
          _menhir_run_402 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LOAD _v ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | IMPORT ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | IF ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | EXPORT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CONVERT _v ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CONST _v ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | COMPARE _v ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | CALL_INDIRECT ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BLOCK ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | BINARY _v ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_451 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState451 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | STRING _v ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_468 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState468
      | DECLARE | EXTERNREF | FUNC | FUNCREF | LPAR ->
          let _v = _menhir_action_015 () in
          _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState468 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_469 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState469 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState470 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE ->
              let _menhir_stack = MenhirCell1_TABLE (_menhir_stack, _menhir_s) in
              let _menhir_s = MenhirState471 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OFFSET ->
              _menhir_run_474 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState469
      | FUNC ->
          _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState469
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState469
      | DECLARE ->
          let _menhir_stack = MenhirCell1_DECLARE (_menhir_stack, MenhirState469) in
          let _menhir_s = MenhirState478 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | FUNCREF ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | FUNC ->
              _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | EXTERNREF ->
              _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_498 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState498
      | LPAR | RPAR | STRING _ ->
          let _v = _menhir_action_015 () in
          _menhir_run_499 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState498 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_499 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState499 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState500 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TEST _v ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_TERNARY _v ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE_LANE _v ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_STORE _v ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SPLAT _v ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | VEC_SHIFT _v ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_REPLACE _v ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD_LANE _v ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_LOAD _v ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_EXTRACT _v ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_CONST _v ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BITMASK _v ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | VEC_BINARY _v ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UNARY _v ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TEST _v ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | STORE _v ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | SELECT ->
              _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OFFSET ->
              _menhir_run_474 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | MEMORY ->
              let _menhir_stack = MenhirCell1_MEMORY (_menhir_stack, _menhir_s) in
              let _menhir_s = MenhirState501 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | LOOP ->
              _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LOAD _v ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | IF ->
              _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CONVERT _v ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CONST _v ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | COMPARE _v ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | CALL_INDIRECT ->
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BLOCK ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | BINARY _v ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR ())
      | RPAR | STRING _ ->
          let _v_24 = _menhir_action_284 () in
          _menhir_run_504 _menhir_stack _menhir_lexbuf _menhir_lexer _v_24 MenhirState499 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_504 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var_opt as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _menhir_stack = MenhirCell1_string_list (_menhir_stack, _menhir_s, _v) in
          _menhir_run_344 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_047 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_data _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_672 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_name -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let MenhirCell1_name (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_044 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_596 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState596
      | _ ->
          _eRR ()
  
  and _menhir_run_568 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState568
      | _ ->
          _eRR ()
  
  and _menhir_run_560 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | QUOTE ->
          let _menhir_stack = MenhirCell1_QUOTE (_menhir_stack, MenhirState560) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_0 = _menhir_action_284 () in
          _menhir_run_562 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState561 _tok
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState560
      | BIN ->
          let _menhir_stack = MenhirCell1_BIN (_menhir_stack, MenhirState560) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_1 = _menhir_action_284 () in
          _menhir_run_565 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState564 _tok
      | RPAR ->
          let _v_2 = _menhir_action_174 () in
          _menhir_run_534 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_552 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_name (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_044 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_337 : type  ttv_stack. ((ttv_stack, _menhir_box_module1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_module1) _menhir_state -> _ -> _menhir_box_module1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_module_var_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState337
      | RPAR ->
          let _v_0 = _menhir_action_174 () in
          _menhir_run_534 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_597 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_004 _3 _4 _endpos__5_ _startpos__1_ in
          _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_569 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_ as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_570 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState569
      | RPAR ->
          let _v_0 = _menhir_action_143 () in
          _menhir_run_589 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | _ ->
          _eRR ()
  
  and _menhir_run_589 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_option_module_var_, ttv_result) _menhir_cell1_name -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_name (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_option_module_var_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_5, _endpos__6_) = (_v, _endpos) in
      let _v = _menhir_action_003 _3 _4 _5 _endpos__6_ _startpos__1_ in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_551 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VAR _v_0 ->
          _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState551
      | RPAR ->
          let _v_1 = _menhir_action_197 () in
          _menhir_run_552 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_452 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TABLE ->
              let _menhir_s = MenhirState454 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | MEMORY ->
              let _menhir_s = MenhirState457 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | GLOBAL ->
              let _menhir_s = MenhirState460 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | FUNC ->
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _endpos) in
              let _menhir_s = MenhirState463 in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | NAT _v ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
              | _ ->
                  _eRR ())
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_356 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TABLE ->
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v_0 ->
                  _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState358
              | NAT _ ->
                  let _v_1 = _menhir_action_015 () in
                  _menhir_run_359 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState358 _tok
              | _ ->
                  _eRR ())
          | MEMORY ->
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v_2 ->
                  _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState362
              | NAT _ ->
                  let _v_3 = _menhir_action_015 () in
                  _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState362 _tok
              | _ ->
                  _eRR ())
          | GLOBAL ->
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v_4 ->
                  _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState366
              | EXTERNREF | FUNCREF | LPAR | NUM_TYPE _ | VEC_TYPE _ ->
                  let _v_5 = _menhir_action_015 () in
                  _menhir_run_367 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState366 _tok
              | _ ->
                  _eRR ())
          | FUNC ->
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _endpos) in
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v_6 ->
                  _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState375
              | LPAR | RPAR ->
                  let _v_7 = _menhir_action_015 () in
                  _menhir_run_376 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_7 MenhirState375 _tok
              | _ ->
                  _eRR ())
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_359 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState359
      | _ ->
          _eRR ()
  
  and _menhir_run_363 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState363
      | _ ->
          _eRR ()
  
  and _menhir_run_367 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState367
      | NUM_TYPE _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState367
      | LPAR ->
          _menhir_run_368 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState367
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState367
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState367
      | _ ->
          _eRR ()
  
  and _menhir_run_368 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState368 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | MUT ->
          _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_376 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_bind_var_opt (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState376 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState377 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TYPE ->
              _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | PARAM ->
              _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | _ ->
              _eRR ())
      | RPAR ->
          let _v_0 = _menhir_action_101 () in
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_0 MenhirState376
      | _ ->
          _eRR ()
  
  and _menhir_run_007 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_RESULT (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState007
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState007
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState007
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState007
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState007
      | _ ->
          _eRR ()
  
  and _menhir_run_015 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState016 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState017 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RESULT ->
              _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | _ ->
              _eRR ())
      | RPAR ->
          let _v_0 = _menhir_action_101 () in
          _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0
      | _ ->
          _eRR ()
  
  and _menhir_run_018 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_102 _3 _5 in
      _menhir_goto_func_type_result _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s
  
  and _menhir_goto_func_type_result : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState376 ->
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s
      | MenhirState005 ->
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s
      | MenhirState026 ->
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s
      | MenhirState021 ->
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s
      | MenhirState016 ->
          _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_022 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_098 _1 in
      _menhir_goto_func_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s
  
  and _menhir_goto_func_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState376 ->
          _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v
      | MenhirState005 ->
          _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState026 ->
          _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v
      | MenhirState021 ->
          _menhir_run_023 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_380 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR _menhir_cell0_FUNC, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v ->
      let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
      let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _endpos__4_, _startpos__4_, _4) = (_endpos_0, _endpos, _startpos, _v) in
      let _v = _menhir_action_120 _3 _4 _endpos__4_ _startpos__4_ in
      _menhir_goto_import_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _tok
  
  and _menhir_run_028 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_FUNC -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__4_, _3) = (_endpos_0, _v) in
      let _v = _menhir_action_050 _3 in
      let (_endpos, _startpos) = (_endpos__4_, _startpos__1_) in
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_294 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_type_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_type_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState033 ->
          _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState002 ->
          _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_034 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_bind_var -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var (_menhir_stack, _, _3, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let _4 = _v in
          let _v = _menhir_action_296 _3 _4 in
          _menhir_goto_type_def _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_type_def : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_def (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_338 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState513
      | EOF | RPAR ->
          let _v_0 = _menhir_action_174 () in
          _menhir_run_533 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_030 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_295 _3 in
          _menhir_goto_type_def _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_027 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_bind_var, ttv_result) _menhir_cell1_value_type _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_value_type (_menhir_stack, _, _4) = _menhir_stack in
      let MenhirCell1_bind_var (_menhir_stack, _, _, _) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__6_, _6) = (_endpos, _v) in
      let _v = _menhir_action_100 _4 _6 in
      _menhir_goto_func_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__6_ _startpos__1_ _v _menhir_s
  
  and _menhir_run_023 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_PARAM (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _5) = (_endpos, _v) in
      let _v = _menhir_action_099 _3 _5 in
      _menhir_goto_func_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s
  
  and _menhir_run_019 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState019
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState019
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState019
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState019
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState019
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState019
      | _ ->
          _eRR ()
  
  and _menhir_run_020 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState021
      | RPAR ->
          let _v_0 = _menhir_action_101 () in
          _menhir_run_022 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_0 MenhirState021
      | _ ->
          _eRR ()
  
  and _menhir_run_006 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState006 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | RESULT ->
          _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | PARAM ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_355 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState355
      | _ ->
          _eRR ()
  
  and _menhir_run_047 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_EXPORT -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_EXPORT (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos, _v) in
          let _v = _menhir_action_124 _3 _endpos__4_ _startpos__1_ in
          _menhir_goto_inline_export _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_inline_export : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState446 ->
          _menhir_run_446 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_446 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState389 ->
          _menhir_run_389 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState385 ->
          _menhir_run_389 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState352 ->
          _menhir_run_352 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState340 ->
          _menhir_run_352 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState329 ->
          _menhir_run_329 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_329 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_446 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_export (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState446
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState446
      | VEC_TERNARY _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState446
      | VEC_STORE_LANE _v_3 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState446
      | VEC_STORE _v_4 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState446
      | VEC_SPLAT _v_5 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState446
      | VEC_SHUFFLE ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | VEC_SHIFT _v_6 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState446
      | VEC_REPLACE _v_7 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState446
      | VEC_LOAD_LANE _v_8 ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState446
      | VEC_LOAD _v_9 ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState446
      | VEC_EXTRACT _v_10 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState446
      | VEC_CONST _v_11 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState446
      | VEC_BITMASK _v_12 ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState446
      | VEC_BINARY _v_13 ->
          _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState446
      | UNREACHABLE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | UNARY _v_14 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState446
      | TEST _v_15 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState446
      | TABLE_SIZE ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_SET ->
          _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_INIT ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_GROW ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_GET ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_FILL ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | TABLE_COPY ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | STORE _v_16 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState446
      | SELECT ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | RETURN ->
          _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | REF_NULL ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | REF_IS_NULL ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | REF_FUNC ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | NOP ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | MEMORY_SIZE ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | MEMORY_INIT ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | MEMORY_GROW ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | MEMORY_FILL ->
          _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | MEMORY_COPY ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LPAR ->
          _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LOOP ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LOCAL_TEE ->
          _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LOCAL_SET ->
          _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LOCAL_GET ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | LOAD _v_17 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState446
      | IF ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | GLOBAL_SET ->
          _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | GLOBAL_GET ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | ELEM_DROP ->
          _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | DROP ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | DATA_DROP ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | CONVERT _v_18 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState446
      | CONST _v_19 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState446
      | COMPARE _v_20 ->
          _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState446
      | CALL_INDIRECT ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | CALL ->
          _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | BR_TABLE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | BR_IF ->
          _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | BR ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | BLOCK ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState446
      | BINARY _v_21 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState446
      | RPAR ->
          let _v_22 = _menhir_action_131 () in
          _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState446 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_389 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_export (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState389
      | NUM_TYPE _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState389
      | LPAR ->
          _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState389
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState389
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState389
      | _ ->
          _eRR ()
  
  and _menhir_run_352 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_export (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState352
      | LPAR ->
          _menhir_run_341 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState352
      | _ ->
          _eRR ()
  
  and _menhir_run_329 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_export (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState329
      | LPAR ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState329
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState329
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState329
      | _ ->
          _eRR ()
  
  and _menhir_run_044 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IMPORT, ttv_result) _menhir_cell1_name -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_name (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell1_IMPORT (_menhir_stack, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
          let _4 = _v in
          let _v = _menhir_action_125 _3 _4 in
          _menhir_goto_inline_import _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_inline_import : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState446 ->
          _menhir_run_426 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState396 ->
          _menhir_run_426 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState389 ->
          _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState385 ->
          _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState352 ->
          _menhir_run_350 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState340 ->
          _menhir_run_350 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState329 ->
          _menhir_run_327 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_327 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_426 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_import (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState426 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState427 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TYPE ->
              _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | RESULT ->
              _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | PARAM ->
              _menhir_run_433 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | _ ->
              _eRR ())
      | RPAR ->
          let _v_0 = _menhir_action_094 () in
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState426 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_433 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_PARAM (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState433
      | VAR _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState433
      | NUM_TYPE _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState433
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState433
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState433
      | RPAR ->
          let _v = _menhir_action_151 () in
          _menhir_run_434 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState433
      | _ ->
          _eRR ()
  
  and _menhir_run_434 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_436 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState435
      | RPAR ->
          let _v_0 = _menhir_action_094 () in
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState435 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_387 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_import (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_TYPE _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState387
      | NUM_TYPE _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState387
      | LPAR ->
          _menhir_run_368 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState387
      | FUNCREF ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState387
      | EXTERNREF ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState387
      | _ ->
          _eRR ()
  
  and _menhir_run_350 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_import (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState350
      | _ ->
          _eRR ()
  
  and _menhir_run_327 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_inline_import (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState327
      | _ ->
          _eRR ()
  
  and _menhir_run_043 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_IMPORT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_name (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState043
      | _ ->
          _eRR ()
  
  and _menhir_run_554 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_546 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState554
      | RPAR | STRING _ ->
          let _v = _menhir_action_199 () in
          _menhir_run_555 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_559 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState559
      | BIN | LPAR | QUOTE | RPAR ->
          let _v = _menhir_action_197 () in
          _menhir_run_560 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState559 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_567 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState567
      | STRING _ ->
          let _v = _menhir_action_197 () in
          _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState567 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_591 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_546 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState591
      | STRING _ ->
          let _v = _menhir_action_199 () in
          _menhir_run_592 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_595 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | VAR _v ->
          _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState595
      | STRING _ ->
          let _v = _menhir_action_197 () in
          _menhir_run_596 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState595 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_599 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState599 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_600 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_600 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | MODULE ->
          _menhir_run_559 _menhir_stack _menhir_lexbuf _menhir_lexer
      | _ ->
          _eRR ()
  
  and _menhir_run_605 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState605 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_606 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_606 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | MODULE ->
          _menhir_run_559 _menhir_stack _menhir_lexbuf _menhir_lexer
      | INVOKE ->
          _menhir_run_567 _menhir_stack _menhir_lexbuf _menhir_lexer
      | GET ->
          _menhir_run_595 _menhir_stack _menhir_lexbuf _menhir_lexer
      | _ ->
          _eRR ()
  
  and _menhir_run_613 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState613 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_614 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_614 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | INVOKE ->
          _menhir_run_567 _menhir_stack _menhir_lexbuf _menhir_lexer
      | GET ->
          _menhir_run_595 _menhir_stack _menhir_lexbuf _menhir_lexer
      | _ ->
          _eRR ()
  
  and _menhir_run_638 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState638 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_600 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_642 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState642 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_600 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_646 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _menhir_s = MenhirState646 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_614 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | _ ->
          _eRR ()
  
  and _menhir_run_655 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_cmd -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_cmd (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_142 x xs in
      _menhir_goto_list_cmd_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_list_cmd_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState667 ->
          _menhir_run_668 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState543 ->
          _menhir_run_660 _menhir_stack _v _tok
      | MenhirState654 ->
          _menhir_run_655 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState548 ->
          _menhir_run_652 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_726 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_013 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_714 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_script1) _menhir_state -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_616 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState714
      | RPAR ->
          let _v_0 = _menhir_action_149 () in
          _menhir_run_715 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_715 : type  ttv_stack. ((ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR, _menhir_box_script1) _menhir_cell1_action -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_action (_menhir_stack, _, _3, _, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _4) = (_endpos, _v) in
      let _v = _menhir_action_011 _3 _4 _endpos__5_ _startpos__1_ in
      _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_710 : type  ttv_stack. (ttv_stack, _menhir_box_script1) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> _menhir_box_script1 =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_012 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_657 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_041 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_cmd _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_647 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_013 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_615 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          _menhir_run_616 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState615
      | RPAR ->
          let _v_0 = _menhir_action_149 () in
          _menhir_run_636 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0
      | _ ->
          _eRR ()
  
  and _menhir_run_636 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_action -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_action (_menhir_stack, _, _3, _, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__5_, _4) = (_endpos, _v) in
      let _v = _menhir_action_011 _3 _4 _endpos__5_ _startpos__1_ in
      _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_610 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | STRING _v_0 ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RPAR ->
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
              let (_endpos__5_, _4, _3) = (_endpos_3, _v_0, _v) in
              let _v = _menhir_action_012 _3 _4 _endpos__5_ _startpos__1_ in
              _menhir_goto_assertion _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _menhir_s _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_130 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_REF_NULL -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_REF_NULL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_241 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_635 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_result -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_result (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_150 x xs in
      _menhir_goto_list_result_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_list_result_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState714 ->
          _menhir_run_715 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState615 ->
          _menhir_run_636 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState632 ->
          _menhir_run_635 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_582 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LPAR _menhir_cell0_CONST -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell0_CONST (_menhir_stack, _2, _) = _menhir_stack in
          let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos__4_, _3) = (_endpos_0, _v) in
          let _v = _menhir_action_156 _2 _3 in
          _menhir_goto_literal_num _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_literal_num : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState714 ->
          _menhir_run_634 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState615 ->
          _menhir_run_634 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState632 ->
          _menhir_run_634 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState691 ->
          _menhir_run_586 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState587 ->
          _menhir_run_586 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState569 ->
          _menhir_run_586 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_634 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_265 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_586 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_153 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_literal _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_184 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_CONST -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CONST (_menhir_stack, _menhir_s, _1, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_244 _1 _2 in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_075 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_num (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | NAT _v_0 ->
          _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState075
      | INT _v_1 ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState075
      | FLOAT _v_2 ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState075
      | BINARY _ | BLOCK | BR | BR_IF | BR_TABLE | CALL | CALL_INDIRECT | COMPARE _ | CONST _ | CONVERT _ | DATA_DROP | DROP | ELEM_DROP | ELSE | END | GLOBAL_GET | GLOBAL_SET | IF | LOAD _ | LOCAL_GET | LOCAL_SET | LOCAL_TEE | LOOP | LPAR | MEMORY_COPY | MEMORY_FILL | MEMORY_GROW | MEMORY_INIT | MEMORY_SIZE | NOP | REF_FUNC | REF_IS_NULL | REF_NULL | RETURN | RPAR | SELECT | STORE _ | TABLE_COPY | TABLE_FILL | TABLE_GET | TABLE_GROW | TABLE_INIT | TABLE_SET | TABLE_SIZE | TEST _ | UNARY _ | UNREACHABLE | VEC_BINARY _ | VEC_BITMASK _ | VEC_CONST _ | VEC_EXTRACT _ | VEC_LOAD _ | VEC_LOAD_LANE _ | VEC_REPLACE _ | VEC_SHIFT _ | VEC_SHUFFLE | VEC_SPLAT _ | VEC_STORE _ | VEC_STORE_LANE _ | VEC_TERNARY _ | VEC_TEST _ | VEC_UNARY _ ->
          let _v_3 = _menhir_action_145 () in
          _menhir_run_076 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_3 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_076 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_num -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_num (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_146 x xs in
      _menhir_goto_list_num_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_goto_list_num_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState572 ->
          _menhir_run_573 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState091 ->
          _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState071 ->
          _menhir_run_077 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState075 ->
          _menhir_run_076 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_077 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_VEC_SHUFFLE -> _ -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_VEC_SHUFFLE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__2_, _2) = (_endpos, _v) in
      let _v = _menhir_action_257 _2 _endpos__2_ _startpos__1_ in
      _menhir_goto_plain_instr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_220 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_128 _1 _endpos__1_ _startpos__1_ in
      _menhir_goto_instr1 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_326 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_limits -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_limits (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_292 _1 _2 in
      _menhir_goto_table_type _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_table_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState359 ->
          _menhir_run_360 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState327 ->
          _menhir_run_328 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState329 ->
          _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_360 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_name, ttv_result) _menhir_cell1_name _menhir_cell0_LPAR, ttv_result) _menhir_cell1_bind_var_opt -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_bind_var_opt (_menhir_stack, _, _3) = _menhir_stack in
          let MenhirCell0_LPAR (_menhir_stack, _startpos__1_) = _menhir_stack in
          let (_endpos__5_, _4) = (_endpos, _v) in
          let _v = _menhir_action_121 _3 _4 in
          _menhir_goto_import_desc _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__5_ _startpos__1_ _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_328 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_inline_import -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_inline_import (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_288 _1 _2 in
      _menhir_goto_table_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_049 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_287 _1 in
      _menhir_goto_table_fields _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_052 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_ref_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | ELEM ->
              let _tok = _menhir_lexer _menhir_lexbuf in
              (match (_tok : MenhirBasics.token) with
              | VAR _v_0 ->
                  _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState054
              | NAT _v_1 ->
                  _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState054
              | LPAR ->
                  _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState054
              | RPAR ->
                  let _v_2 = _menhir_action_303 () in
                  _menhir_run_316 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState054 _tok
              | _ ->
                  _eRR ())
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_013 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_300 _1 in
      _menhir_goto_value_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_429 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_list_value_type_ (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LPAR ->
          let _menhir_s = MenhirState430 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState431 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | RESULT ->
              _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | _ ->
              _eRR ())
      | RPAR ->
          let _v_0 = _menhir_action_094 () in
          _menhir_run_432 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_432 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_RESULT, ttv_result) _menhir_cell1_list_value_type_ _menhir_cell0_RPAR -> _ -> _ -> _ -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_RPAR (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_value_type_ (_menhir_stack, _, _3) = _menhir_stack in
      let MenhirCell1_RESULT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let _5 = _v in
      let _v = _menhir_action_095 _3 _5 in
      _menhir_goto_func_fields_import_result _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_func_fields_import_result : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState426 ->
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState443 ->
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState441 ->
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState435 ->
          _menhir_run_437 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState430 ->
          _menhir_run_432 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_421 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_PARAM, ttv_result) _menhir_cell1_bind_var as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_value_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v_0 ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState422
          | VEC_TEST _v_1 ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState422
          | VEC_TERNARY _v_2 ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState422
          | VEC_STORE_LANE _v_3 ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState422
          | VEC_STORE _v_4 ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState422
          | VEC_SPLAT _v_5 ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState422
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | VEC_SHIFT _v_6 ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState422
          | VEC_REPLACE _v_7 ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState422
          | VEC_LOAD_LANE _v_8 ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState422
          | VEC_LOAD _v_9 ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState422
          | VEC_EXTRACT _v_10 ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState422
          | VEC_CONST _v_11 ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState422
          | VEC_BITMASK _v_12 ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState422
          | VEC_BINARY _v_13 ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState422
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | UNARY _v_14 ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState422
          | TEST _v_15 ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState422
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | STORE _v_16 ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState422
          | SELECT ->
              _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LPAR ->
              _menhir_run_417 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LOOP ->
              _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | LOAD _v_17 ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState422
          | IF ->
              _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | CONVERT _v_18 ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState422
          | CONST _v_19 ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState422
          | COMPARE _v_20 ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState422
          | CALL_INDIRECT ->
              _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | BLOCK ->
              _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState422
          | BINARY _v_21 ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState422
          | RPAR ->
              let _v_22 = _menhir_action_131 () in
              _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState422 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_409 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_LOCAL, ttv_result) _menhir_cell1_bind_var as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_value_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | RPAR ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_RPAR (_menhir_stack, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | VEC_UNARY _v_0 ->
              _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState410
          | VEC_TEST _v_1 ->
              _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState410
          | VEC_TERNARY _v_2 ->
              _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState410
          | VEC_STORE_LANE _v_3 ->
              _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState410
          | VEC_STORE _v_4 ->
              _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState410
          | VEC_SPLAT _v_5 ->
              _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState410
          | VEC_SHUFFLE ->
              _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | VEC_SHIFT _v_6 ->
              _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState410
          | VEC_REPLACE _v_7 ->
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState410
          | VEC_LOAD_LANE _v_8 ->
              _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState410
          | VEC_LOAD _v_9 ->
              _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState410
          | VEC_EXTRACT _v_10 ->
              _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState410
          | VEC_CONST _v_11 ->
              _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState410
          | VEC_BITMASK _v_12 ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState410
          | VEC_BINARY _v_13 ->
              _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState410
          | UNREACHABLE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | UNARY _v_14 ->
              _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState410
          | TEST _v_15 ->
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState410
          | TABLE_SIZE ->
              _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_SET ->
              _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_INIT ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_GROW ->
              _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_GET ->
              _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_FILL ->
              _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | TABLE_COPY ->
              _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | STORE _v_16 ->
              _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_16 MenhirState410
          | SELECT ->
              _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | RETURN ->
              _menhir_run_119 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | REF_NULL ->
              _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | REF_IS_NULL ->
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | REF_FUNC ->
              _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | NOP ->
              _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | MEMORY_SIZE ->
              _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | MEMORY_INIT ->
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | MEMORY_GROW ->
              _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | MEMORY_FILL ->
              _menhir_run_139 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | MEMORY_COPY ->
              _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LPAR ->
              _menhir_run_405 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LOOP ->
              _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LOCAL_TEE ->
              _menhir_run_158 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LOCAL_SET ->
              _menhir_run_160 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LOCAL_GET ->
              _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | LOAD _v_17 ->
              _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _v_17 MenhirState410
          | IF ->
              _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | GLOBAL_SET ->
              _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | GLOBAL_GET ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | ELEM_DROP ->
              _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | DROP ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | DATA_DROP ->
              _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | CONVERT _v_18 ->
              _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _v_18 MenhirState410
          | CONST _v_19 ->
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _v_19 MenhirState410
          | COMPARE _v_20 ->
              _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer _v_20 MenhirState410
          | CALL_INDIRECT ->
              _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | CALL ->
              _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | BR_TABLE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | BR_IF ->
              _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | BR ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | BLOCK ->
              _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState410
          | BINARY _v_21 ->
              _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v_21 MenhirState410
          | RPAR ->
              let _v_22 = _menhir_action_131 () in
              _menhir_run_406 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_22 MenhirState410 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_372 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _1 = _v in
      let _v = _menhir_action_107 _1 in
      _menhir_goto_global_type _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_global_type : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState385 ->
          _menhir_run_390 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState389 ->
          _menhir_run_390 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState387 ->
          _menhir_run_388 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState367 ->
          _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_390 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_global_type (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | VEC_UNARY _v_0 ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState390
      | VEC_TEST _v_1 ->
          _menhir_run_059 _menhir_stack 