/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gd extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Bun-\u00e0m Acre",
               "",
               "T\u00ecde samhraidh Acre",
               "",
               "\u00c0m Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Bun-\u00e0m Apia",
               "",
               "T\u00ecde samhraidh Apia",
               "",
               "\u00c0m Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Bun-\u00e0m Eileanan Cook",
               "",
               "Leth-th\u00ecde samhraidh Eileanan Cook",
               "",
               "\u00c0m Eileanan Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Bun-\u00e0m C\u00f9ba",
               "CST",
               "T\u00ecde samhraidh C\u00f9ba",
               "CDT",
               "\u00c0m C\u00f9ba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Bun-\u00e0m F\u00ecdi",
               "",
               "T\u00ecde samhraidh F\u00ecdi",
               "",
               "\u00c0m F\u00ecdi",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00c0m a\u2019 Chamais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Bun-\u00e0m Hovd",
               "",
               "T\u00ecde samhraidh Hovd",
               "",
               "\u00c0m Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Bun-\u00e0m Ior\u00e0in",
               "",
               "T\u00ecde samhraidh Ior\u00e0in",
               "",
               "\u00c0m Ior\u00e0in",
               "",
            };
        final String[] Niue = new String[] {
               "\u00c0m Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Bun-\u00e0m Omsk",
               "",
               "T\u00ecde samhraidh Omsk",
               "",
               "\u00c0m Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Bun-\u00e0m Pear\u00f9",
               "",
               "T\u00ecde samhraidh Pear\u00f9",
               "",
               "\u00c0m Pear\u00f9",
               "",
            };
        final String[] Truk = new String[] {
               "\u00c0m Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u00c0m Eilean Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "\u00c0m Chasey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Bun-\u00e0m na Sile",
               "",
               "T\u00ecde samhraidh na Sile",
               "",
               "\u00c0m na Sile",
               "",
            };
        final String[] China = new String[] {
               "Bun-\u00e0m na S\u00ecne",
               "CST",
               "T\u00ecde samhraidh na S\u00ecne",
               "CDT",
               "\u00c0m na S\u00ecne",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u00c0m Eileanan Chocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u00c0m Dhavis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u00c0m nan Innseachan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Bun-\u00e0m na Seapaine",
               "JST",
               "T\u00ecde samhraidh na Seapaine",
               "JDT",
               "\u00c0m na Seapaine",
               "JT",
            };
        final String[] Korea = new String[] {
               "Bun-\u00e0m Choir\u00e8a",
               "KST",
               "T\u00ecde samhraidh Choir\u00e8a",
               "KST",
               "\u00c0m Choir\u00e8a",
               "KST",
            };
        final String[] Nauru = new String[] {
               "\u00c0m Nabhru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "\u00c0m Neap\u00e0l",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "\u00c0m Palabh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Bun-\u00e0m Samotha",
               "SST",
               "T\u00ecde samhraidh Samotha",
               "SST",
               "\u00c0m Samotha",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u00c0m Shyowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Bun-\u00e0m Tonga",
               "",
               "T\u00ecde samhraidh Tonga",
               "",
               "\u00c0m Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "\u00c0m Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Bun-\u00e0m Alaska",
               "AKST",
               "T\u00ecde samhraidh Alaska",
               "AKDT",
               "\u00c0m Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Bun-\u00e0m Amasoin",
               "",
               "T\u00ecde samhraidh Amasoin",
               "",
               "\u00c0m Amasoin",
               "",
            };
        final String[] Anadyr = new String[] {
               "Bun-\u00e0m Anadyr",
               "",
               "T\u00ecde samhraidh Anadyr",
               "",
               "\u00c0m Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Bun-\u00e0m nan Eileanan Asorach",
               "",
               "T\u00ecde samhraidh nan Eileanan Asorach",
               "",
               "\u00c0m nan Eileanan Asorach",
               "",
            };
        final String[] Bhutan = new String[] {
               "\u00c0m But\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "\u00c0m Bhr\u00f9naigh D\u00e0r as-Sal\u00e0m",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Bun-\u00e0m Eilean na C\u00e0isge",
               "",
               "T\u00ecde samhraidh Eilean na C\u00e0isge",
               "",
               "\u00c0m Eilean na C\u00e0isge",
               "",
            };
        final String[] Guyana = new String[] {
               "\u00c0m Guidhe\u00e0na",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Bun-\u00e0m Iosrael",
               "IST",
               "T\u00ecde samhraidh Iosrael",
               "IDT",
               "\u00c0m Iosrael",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "\u00c0m Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u00c0m Mhawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Bun-\u00e0m Mhosgo",
               "MSK",
               "T\u00ecde samhraidh Mhosgo",
               "MSK",
               "\u00c0m Mhosgo",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "\u00c0m Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Bun-\u00e0m Samara",
               "",
               "T\u00ecde samhraidh Samara",
               "",
               "\u00c0m Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "\u00c0m Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Bun-\u00e0m Taipei",
               "CST",
               "T\u00ecde samhraidh Taipei",
               "CDT",
               "\u00c0m Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "\u00c0m Tubhalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u00c0m Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u00c0m Uallas agus Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Bun-\u00e0m Arabach",
               "",
               "T\u00ecde samhraidh Arabach",
               "",
               "\u00c0m Arabach",
               "",
            };
        final String[] Armenia = new String[] {
               "Bun-\u00e0m Airmeinia",
               "",
               "T\u00ecde samhraidh Airmeinia",
               "",
               "\u00c0m Airmeinia",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u00c0m Boilibhia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Bun-\u00e0m Chatham",
               "",
               "T\u00ecde samhraidh Chatham",
               "",
               "\u00c0m Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u00c0m Uile-choitcheann Co-\u00f2rdanaichte",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u00c0m Eacuadoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "\u00c0m Ghambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Bun-\u00e0m na Cairtbheile",
               "",
               "T\u00ecde samhraidh na Cairtbheile",
               "",
               "\u00c0m na Cairtbheile",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Bun-\u00e0m Irkutsk",
               "",
               "T\u00ecde Samhraidh Irkutsk",
               "",
               "\u00c0m Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Bun-\u00e0m Magadan",
               "",
               "T\u00ecde Samhraidh Magadan",
               "",
               "\u00c0m Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "\u00c0m Mi\u00e0nmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Bun-\u00e0m Eilein Norfolk",
               "",
               "T\u00ecde samhraidh Eilein Norfolk",
               "",
               "\u00c0m Eilein Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Bun-\u00e0m Fernando de Noronha",
               "",
               "T\u00ecde Samhraidh Fernando de Noronha",
               "",
               "\u00c0m Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "\u00c0m Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u00c0m Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u00c0m Eileanan Sholaimh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u00c0m Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Bun-\u00e0m Uruguaidh",
               "",
               "T\u00ecde samhraidh Uruguaidh",
               "",
               "\u00c0m Uruguaidh",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Bun-\u00e0m Vanuatu",
               "",
               "T\u00ecde samhraidh Vanuatu",
               "",
               "\u00c0m Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Bun-\u00e0m Yakutsk",
               "",
               "T\u00ecde samhraidh Yakutsk",
               "",
               "\u00c0m Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Bun-\u00e0m a\u2019 Chuain Siar",
               "AST",
               "T\u00ecde samhraidh a\u2019 Chuain Siar",
               "ADT",
               "\u00c0m a\u2019 Chuain Siar",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Bun-\u00e0m Bhras\u00edlia",
               "",
               "T\u00ecde samhraidh Bhras\u00edlia",
               "",
               "\u00c0m Bhras\u00edlia",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u00c0m Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Bun-\u00e0m Coloimbia",
               "",
               "T\u00ecde samhraidh Coloimbia",
               "",
               "\u00c0m Coloimbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Bun-\u00e0m nan Eileanan F\u00e0clannach",
               "",
               "T\u00ecde samhraidh nan Eileanan F\u00e0clannach",
               "",
               "\u00c0m nan Eileanan F\u00e0clannach",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u00c0m Mhalaidhsea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "\u00c0m nan Eileanan Mhaladaibh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Bun-\u00e0m Ulan Bator",
               "",
               "T\u00ecde samhraidh Ulan Bator",
               "",
               "\u00c0m Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Bun-\u00e0m Pagast\u00e0in",
               "PKT",
               "T\u00ecde samhraidh Pagast\u00e0in",
               "PKST",
               "\u00c0m Pagast\u00e0in",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Bun-\u00e0m Paraguaidh",
               "",
               "T\u00ecde samhraidh Paraguaidh",
               "",
               "\u00c0m Paraguaidh",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u00c0m Peit a\u2019 Ch\u00e0irn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Bun-\u00e0m Sakhalin",
               "",
               "T\u00ecde samhraidh Sakhalin",
               "",
               "\u00c0m Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "\u00c0m Suranaim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Bun-\u00e0m na h-Argantaine",
               "",
               "T\u00ecde samhraidh na h-Argantaine",
               "",
               "\u00c0m na h-Argantaine",
               "",
            };
        final String[] Christmas = new String[] {
               "\u00c0m Eilean na Nollaig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u00c0m Ghalapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Bun-\u00e0m Hong Kong",
               "HKT",
               "T\u00ecde samhraidh Hong Kong",
               "HKST",
               "\u00c0m Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "\u00c0m S\u00ecn-Innseanach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Bun-\u00e0m Petropavlovsk-Kamchatsky",
               "",
               "T\u00ecde samhraidh Petropavlovsk-Kamchatsky",
               "",
               "\u00c0m Petropavlovsk-Kamchatsky",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u00c0m C\u00ecorgastain",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Bun-\u00e0m Lord Howe",
               "",
               "T\u00ecde samhraidh Lord Howe",
               "",
               "\u00c0m Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "\u00c0m Eileanan a\u2019 Mharcais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Bun-\u00e0m nan Eileanan Mhoiriseas",
               "",
               "T\u00ecde samhraidh nan Eileanan Mhoiriseas",
               "",
               "\u00c0m nan Eileanan Mhoiriseas",
               "",
            };
        final String[] Singapore = new String[] {
               "\u00c0m Singeap\u00f2r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u00c0m na Bheiniseala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Bun-\u00e0m Volgograd",
               "MSK",
               "T\u00ecde samhraidh Volgograd",
               "MSK",
               "\u00c0m Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Bun-\u00e0m Asarbaide\u00e0in",
               "",
               "T\u00ecde samhraidh Asarbaide\u00e0in",
               "",
               "\u00c0m Asarbaide\u00e0in",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bun-\u00e0m Bangladais",
               "",
               "T\u00ecde samhraidh Bangladais",
               "",
               "\u00c0m Bangladais",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Bun-\u00e0m a\u2019 Chip Uaine",
               "",
               "T\u00ecde samhraidh a\u2019 Chip Uaine",
               "",
               "\u00c0m a\u2019 Chip Uaine",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00c0m Th\u00ecomor an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u00c0m nan Eileanan Sheiseall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u00c0m Taidigeast\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Bun-\u00e0m Usbagast\u00e0n",
               "",
               "T\u00ecde samhraidh Usbagast\u00e0n",
               "",
               "\u00c0m Usbagast\u00e0n",
               "",
            };
        final String[] Afghanistan = new String[] {
               "\u00c0m Afghanast\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Bun-\u00e0m Krasnoyarsk",
               "",
               "T\u00ecde samhraidh Krasnoyarsk",
               "",
               "\u00c0m Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Bun-\u00e0m Shealainn Nuaidh",
               "NZST",
               "T\u00ecde samhraidh Shealainn Nuaidh",
               "NZDT",
               "\u00c0m Shealainn Nuaidh",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Bun-\u00e0m Novosibirsk",
               "",
               "T\u00ecde samhraidh Novosibirsk",
               "",
               "\u00c0m Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Bun-\u00e0m nan Eilean Filipineach",
               "PST",
               "T\u00ecde samhraidh nan Eilean Filipineach",
               "PDT",
               "\u00c0m nan Eilean Filipineach",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Bun-\u00e0m Vladivostok",
               "",
               "T\u00ecde Samhraidh Vladivostok",
               "",
               "\u00c0m Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00c0m Cuan nan Innseachan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u00c0m Eileanan Teraina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Bun-\u00e0m Talamh an \u00c8isg",
               "NST",
               "T\u00ecde samhraidh Talamh an \u00c8isg",
               "NDT",
               "\u00c0m Talamh an \u00c8isg",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Bun-\u00e0m Turcmanast\u00e0in",
               "",
               "T\u00ecde samhraidh Turcmanast\u00e0in",
               "",
               "\u00c0m Turcmanast\u00e0in",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u00c0m Guidhe\u00e0na na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Bun-\u00e0m Chailleann Nuaidh",
               "",
               "T\u00ecde samhraidh Chailleann Nuaidh",
               "",
               "\u00c0m Chailleann Nuaidh",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u00c0m Se\u00f2rsea a Deas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Bun-\u00e0m Yekaterinburg",
               "",
               "T\u00ecde samhraidh Yekaterinburg",
               "",
               "\u00c0m Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u00c0m Meadhan Afraga",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00c0m Afraga an Ear",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Bun-\u00e0m Afraga an Iar",
               "WAT",
               "T\u00ecde Samhraidh Afraga an Iar",
               "WAT",
               "\u00c0m Afraga an Iar",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u00c0m Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Bun-\u00e0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
               "T\u00ecde samhraidh Meadhan na Roinn-E\u00f2rpa",
               "CEST",
               "\u00c0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Ear",
               "EET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Ear",
               "EEST",
               "\u00c0m na Roinn-E\u00f2rpa an Ear",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Iar",
               "WET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Iar",
               "WEST",
               "\u00c0m na Roinn-E\u00f2rpa an Iar",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "MST",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh Mheagsago",
               "MDT",
               "\u00c0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "\u00c0m Afraga a Deas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Bun-\u00e0m Meadhan Aimeireaga a Tuath",
               "CST",
               "T\u00ecde samhraidh Meadhan Aimeireaga a Tuath",
               "CDT",
               "\u00c0m Meadhan Aimeireaga a Tuath",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Bun-\u00e0m Aimeireaga a Tuath an Ear",
               "EST",
               "T\u00ecde samhraidh Aimeireaga a Tuath an Ear",
               "EDT",
               "\u00c0m Aimeireaga a Tuath an Ear",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh",
               "PST",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh",
               "PDT",
               "\u00c0m a\u2019 Chuain S\u00e8imh",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u00c0m Deasach agus Antartaigeach na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u00c0m Eileanan Ghileabairt",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAST",
               "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HADT",
               "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u00c0m Eileanan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Bun-\u00e0m Saint Pierre agus Miquelon",
               "",
               "T\u00ecde Samhraidh Saint Pierre agus Miquelon",
               "",
               "\u00c0m Saint Pierre agus Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Bun-\u00e0m Monadh Aimeireaga a Tuath",
               "MST",
               "T\u00ecde samhraidh Monadh Aimeireaga a Tuath",
               "MDT",
               "\u00c0m Monadh Aimeireaga a Tuath",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u00c0m Eileanan Mharshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Bun-\u00e0m Mheagsago an Iar-thuath",
               "",
               "T\u00ecde samhraidh Mheagsago an Iar-thuath",
               "",
               "\u00c0m Mheagsago an Iar-thuath",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u00c0m Gini Nuaidh Paputhaiche",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia",
               "ACST",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia",
               "ACDT",
               "\u00c0m Meadhan Astr\u00e0ilia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Ear",
               "AEST",
               "T\u00ecde samhraidh Astr\u00e0ilia an Ear",
               "AEDT",
               "\u00c0m Astr\u00e0ilia an Ear",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Iar",
               "AWST",
               "T\u00ecde samhraidh Astr\u00e0ilia an Iar",
               "AWDT",
               "\u00c0m Astr\u00e0ilia an Iar",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Bun-\u00e0m na Graonlainn an Ear",
               "",
               "T\u00ecde samhraidh na Graonlainn an Ear",
               "",
               "\u00c0m na Graonlainn an Ear",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Bun-\u00e0m na Graonlainn an Iar",
               "",
               "T\u00ecde samhraidh na Graonlainn an Iar",
               "",
               "\u00c0m na Graonlainn an Iar",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "\u00c0m Meadhan nan Innd-Innse",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00c0m nan Innd-Innse an Ear",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u00c0m nan Innd-Innse an Iar",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00c0m Casachst\u00e0in an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u00c0m Casachst\u00e0in an Iar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia an Iar",
               "",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia an Iar",
               "",
               "\u00c0m Meadhan Astr\u00e0ilia an Iar",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                    "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HDT",
                    "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Bun-\u00e0m na h-\u00c8ireann",
                    "TS\u00c8 (\u00c8irinn)",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "T\u00ecde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                    "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HDT",
                    "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "T\u00ecde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "G\u00e0sa" },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u0101n" },
            { "timezone.excity.Asia/Macau", "Mac\u00e0thu" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Tokyo", "T\u014dky\u014d" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Brunei", "Br\u00f9naigh" },
            { "timezone.excity.Asia/Kuwait", "Cuibh\u00e8it" },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Tehr\u0101n" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Baile neo-aithnichte" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Riga", "R\u012bga" },
            { "timezone.excity.Europe/Rome", "An R\u00f2imh" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Asia/Baghdad", "Baghd\u0101d" },
            { "timezone.excity.Asia/Bahrain", "Bachrain" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Karachi", "Kar\u0101c\u012b" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "T\u2019bilisi" },
            { "timezone.excity.Europe/Paris", "Paras" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "timezone.excity.Pacific/Fiji", "F\u00ecdi" },
            { "timezone.excity.Africa/Asmera", "Asmar\u00e0" },
            { "timezone.excity.America/Aruba", "Ar\u00f9ba" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "A\u015fgabat" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Qostanay", "Qostana\u0131" },
            { "timezone.excity.Asia/Tashkent", "To\u0161kent" },
            { "timezone.excity.Europe/Athens", "An \u00c0ithne" },
            { "timezone.excity.Europe/Dublin", "Baile \u00c0tha Cliath" },
            { "timezone.excity.Europe/Jersey", "De\u00e0rsaidh" },
            { "timezone.excity.Europe/London", "D\u00f9n \u00c8ideann/Lunnainn" },
            { "timezone.excity.Europe/Moscow", "Mosgo" },
            { "timezone.excity.Europe/Prague", "Pr\u00e0g" },
            { "timezone.excity.Europe/Tirane", "Tiran\u00eb" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Pacific/Nauru", "Nabhru" },
            { "timezone.excity.Pacific/Palau", "Palabh" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "A\u2019 Bheil\u00ecs" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Caimean" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Guyana", "Guidhe\u00e0na" },
            { "timezone.excity.America/Inuvik", "Inuuvik" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Jerusalem", "Ierusalam" },
            { "timezone.excity.Asia/Pyongyang", "Pyeongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Q\u0131z\u0131lorda" },
            { "timezone.excity.Asia/Singapore", "Singeap\u00f2r" },
            { "timezone.excity.Asia/Vientiane", "Viang Chan" },
            { "timezone.excity.Europe/Vatican", "A\u2019 Bhatacan" },
            { "timezone.excity.Pacific/Easter", "Rapa Nui" },
            { "timezone.excity.Pacific/Wallis", "Uallas" },
            { "timezone.excity.Africa/Djibouti", "Diob\u00f9taidh" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djam\u00e9na" },
            { "timezone.excity.America/Antigua", "Aint\u00ecoga" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Grenada", "Grean\u00e0da" },
            { "timezone.excity.America/Jamaica", "Diameuga" },
            { "timezone.excity.Atlantic/Azores", "Ponta Delgada" },
            { "timezone.excity.Atlantic/Canary", "Na h-Eileanan Can\u00e0rach" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e0ro" },
            { "timezone.excity.Europe/Brussels", "A\u2019 Bhruiseal" },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.Europe/Guernsey", "Ge\u00e0rnsaidh" },
            { "timezone.excity.Indian/Maldives", "Na h-Eileanan Mhaladaibh" },
            { "timezone.excity.Pacific/Gambier", "Mangareva" },
            { "timezone.excity.America/Anguilla", "Anguillia" },
            { "timezone.excity.America/Dominica", "Doiminicea" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/New_York", "Nuadh Eabhrac" },
            { "timezone.excity.America/Resolute", "Qausuittuq" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Kitts", "Naomh Cr\u00ecstean" },
            { "timezone.excity.America/St_Lucia", "Naomh L\u00f9isea" },
            { "timezone.excity.Atlantic/Bermuda", "Bearm\u00f9da" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Sydney", "Sidni" },
            { "timezone.excity.Europe/Gibraltar", "Diobraltar" },
            { "timezone.excity.Indian/Christmas", "Nollaig" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenn" },
            { "timezone.excity.Indian/Mauritius", "Na h-Eileanan Mhoiriseas" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Peit a\u2019 Ch\u00e0irn" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Glace_Bay", "Glasbaidh" },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Europe/Copenhagen", "Beirbh" },
            { "timezone.excity.Europe/Luxembourg", "Lugsamburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Marquesas", "Eileanan a\u2019 Mharcais" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ab\u00e4ba" },
            { "timezone.excity.America/Costa_Rica", "Costa R\u00eccea" },
            { "timezone.excity.America/Grand_Turk", "An Turc Mh\u00f2r" },
            { "timezone.excity.America/Guadeloupe", "Guadalup" },
            { "timezone.excity.America/Martinique", "Mairtinic" },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "timezone.excity.America/St_Vincent", "Naomh Bhionsant" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Eilean Naomh Eilidh" },
            { "timezone.excity.Europe/Isle_of_Man", "Eilean Mhanainn" },
            { "timezone.excity.Africa/Johannesburg", "Hannsaborgh" },
            { "timezone.excity.America/El_Salvador", "An Salbhador" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheagsago" },
            { "timezone.excity.America/Pangnirtung", "Pangniqtuuq" },
            { "timezone.excity.America/Puerto_Rico", "Porto R\u00ecceo" },
            { "timezone.excity.Atlantic/Cape_Verde", "An Ceap Uaine" },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u00e0r as-Sal\u00e0m" },
            { "timezone.excity.America/Rankin_Inlet", "Kangiqliniq" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Eilean MhicGuaire" },
            { "timezone.excity.America/Port_of_Spain", "Port na Sp\u00e0inne" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Se\u00f2rsea a Deas" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
        };
        return data;
    }
}
