/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.Internal;

@Internal
public final class EntryUtils {
    private EntryUtils() {
    }

    @Internal
    public static void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        if (entry.isDirectoryEntry()) {
            DirectoryEntry dirEntry = (DirectoryEntry)entry;
            DirectoryEntry newTarget = target.createDirectory(entry.getName());
            newTarget.setStorageClsid(dirEntry.getStorageClsid());
            Iterator<Entry> entries = dirEntry.getEntries();
            while (entries.hasNext()) {
                EntryUtils.copyNodeRecursively(entries.next(), newTarget);
            }
        } else {
            DocumentEntry dentry = (DocumentEntry)entry;
            DocumentInputStream dstream = new DocumentInputStream(dentry);
            target.createDocument(dentry.getName(), dstream);
            dstream.close();
        }
    }

    public static void copyNodes(DirectoryEntry sourceRoot, DirectoryEntry targetRoot) throws IOException {
        for (Entry entry : sourceRoot) {
            EntryUtils.copyNodeRecursively(entry, targetRoot);
        }
    }

    public static void copyNodes(POIFSFileSystem source, POIFSFileSystem target) throws IOException {
        EntryUtils.copyNodes(source.getRoot(), target.getRoot());
    }

    public static void copyNodes(POIFSFileSystem source, POIFSFileSystem target, List<String> excepts) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(source.getRoot(), excepts), new FilteringDirectoryNode(target.getRoot(), excepts));
    }

    public static boolean areDirectoriesIdentical(DirectoryEntry dirA, DirectoryEntry dirB) {
        return new DirectoryDelegate(dirA).equals(new DirectoryDelegate(dirB));
    }

    public static boolean areDocumentsIdentical(DocumentEntry docA, DocumentEntry docB) throws IOException {
        try {
            return new DocumentDelegate(docA).equals(new DocumentDelegate(docB));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private static class DirectoryDelegate
    implements POIDelegate {
        final DirectoryEntry dir;

        DirectoryDelegate(DirectoryEntry dir) {
            this.dir = dir;
        }

        private Map<String, POIDelegate> entries() {
            return StreamSupport.stream(this.dir.spliterator(), false).collect(Collectors.toMap(Entry::getName, DirectoryDelegate::toDelegate));
        }

        private static POIDelegate toDelegate(Entry entry) {
            return entry.isDirectoryEntry() ? new DirectoryDelegate((DirectoryEntry)entry) : new DocumentDelegate((DocumentEntry)entry);
        }

        public int hashCode() {
            return this.dir.getName().hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof DirectoryDelegate)) {
                return false;
            }
            DirectoryDelegate dd = (DirectoryDelegate)other;
            if (this == dd) {
                return true;
            }
            if (!Objects.equals(this.dir.getName(), dd.dir.getName())) {
                return false;
            }
            if (this.dir.getEntryCount() != dd.dir.getEntryCount()) {
                return false;
            }
            if (!this.dir.getStorageClsid().equals(dd.dir.getStorageClsid())) {
                return false;
            }
            return this.entries().equals(dd.entries());
        }
    }

    private static class DocumentDelegate
    implements POIDelegate {
        final DocumentEntry doc;

        DocumentDelegate(DocumentEntry doc) {
            this.doc = doc;
        }

        public int hashCode() {
            return this.doc.getName().hashCode();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object other) {
            if (!(other instanceof DocumentDelegate)) {
                return false;
            }
            DocumentDelegate dd = (DocumentDelegate)other;
            if (this == dd) {
                return true;
            }
            if (!Objects.equals(this.doc.getName(), dd.doc.getName())) {
                return false;
            }
            try (DocumentInputStream inpA = new DocumentInputStream(this.doc);){
                DocumentInputStream inpB;
                block17: {
                    inpB = new DocumentInputStream(dd.doc);
                    try {
                        if (!PropertySet.isPropertySetStream(inpA) || !PropertySet.isPropertySetStream(inpB)) break block17;
                        PropertySet ps1 = PropertySetFactory.create(inpA);
                        PropertySet ps2 = PropertySetFactory.create(inpB);
                        boolean bl = ps1.equals(ps2);
                        inpB.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            inpB.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                boolean bl = DocumentDelegate.isEqual(inpA, inpB);
                inpB.close();
                return bl;
            }
            catch (IOException | NoPropertySetStreamException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private static boolean isEqual(DocumentInputStream i1, DocumentInputStream i2) throws IOException {
            byte[] buf1 = new byte[4096];
            byte[] buf2 = new byte[4096];
            try {
                int len;
                while ((len = i1.read(buf1)) > 0) {
                    i2.readFully(buf2, 0, len);
                    for (int i = 0; i < len; ++i) {
                        if (buf1[i] == buf2[i]) continue;
                        return false;
                    }
                }
                return i2.read() < 0;
            }
            catch (EOFException | RuntimeException ioe) {
                return false;
            }
        }
    }

    private static interface POIDelegate {
    }
}

