#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : Simulation
- Name     : Hydrology: IHACRES
- ID       : sim_ihacres

Description
----------
The metric conceptual rainfall-runoff model [IHACRES] (Identification of unit Hydrographs and Component flows from Rainfall, Evaporation and Streamflow data) has been implemented as a module library. The IHACRES model was developed by: Jakeman, A.J. and G.M. Hornberger (1993); Jakeman et al. (1990).

[Purpose]
The tool can be used to simulate streamflow (catchment runoff) on the basis of daily rainfall and temperature data. No spatial data, such as elevation models, soil or land use maps are required.

IHACRES has been applied to catchments with a wide range of climatologies and sizes (Croke et al., 2004). It has been used to predict streamflow in ungauged catchments (Kokkonen et al., 2003; Post and Jakeman, 1999; Post et al., 1998), to study land cover effects on hydrologic processes (Croke et al., 2004; Kokkonen and Jakeman, 2002), and to investigate dynamic response characteristics and physical catchment descriptors (Kokkonen et al., 2003; Sefton and Howarth, 1998).

More recently, the model has been used to develop a [rainfall-runoff database](http://www.ufz.de/index.php?en=17175) for flood risk assessment and forecasting by Liersch, S. and M. Volk (2008) ([pdf](http://www.iemss.org/iemss2008/uploads/Main/S05-12_Liersch_et_al-IEMSS2008.pdf)).

[References]

(-) Croke, B.F.W., Merritt, W.S., Jakeman, A.J., 2004. A dynamic model for predicting hydrologic response to land cover changes in gauged and ungauged catchments. Journal Of Hydrology 291 (1), 115-31.

(-) Jakeman, A.J., Littlewood, I.G., Whitehead, P.G., 1990. Computation of the instantaneous unit hydrograph and identifiable component flows with application to two small upland catchments. Journal of Hydrology 117 (1-4), 275-300.

(-) Jakeman, A.J. and Hornberger, G.M., 1993. How Much Complexity Is Warranted in a Rainfall-Runoff Model?. Water Resources Research 29 (8), 2637-49.

(-) Kokkonen, T.S., Jakeman, A.J., Young, P.C., Koivusalo, H.J., 2003. Predicting daily flows in ungauged catchments: model regionalization from catchment descriptors at the Coweeta Hydrologic Laboratory. North Carolina Hydrological Processes 17 (11), 2219-38.

(-) Kokkonen, T.S. and Jakeman, A.J., 2002. Structural Effects of Landscape and Land Use on Streamflow Response. In: Environmental Foresight and Models: A Manifesto, 303-321.

(-) Liersch, S. and M. Volk, 2008. A rainfall-runoff database to support flood risk assessment. iEMSs 2008: International Congress on Environmental Modelling and Software. In: M. Sanchez-Marre, J. Bejar, J. Comas, A. Rizzoli and G. Guariso (Eds.): Proceedings of the iEMSs Fourth Biennial Meeting: International Congress on Environmental Modelling and Software (iEMSs 2008). International Environmental Modelling and Software Society, Barcelona, Catalonia, July 2008. Vol. 1: 494-502. ISBN: 978-84-7653-074-0. (PEER reviewed).

(-) Post, D.A. and Jakeman, A.J., 1999. Predicting the daily streamflow of ungauged catchments in S.E. Australia by regionalising the parameters of a lumped conceptual rainfall-runoff model. Ecological Modelling 123 (2-3), 91-104.

(-) Post, D.A., Jones, J.A. and Grant, G.E., 1998. An improved methodology for predicting the daily hydrologic response of ungauged catchments. Environmental Modelling & Software 13 (3-4), 395-403.

(-) Sefton, C.E.M. and Howarth, S.M., 1998. Relationships between dynamic response characteristics and physical descriptors of catchments in England and Wales. Journal of Hydrology 211 (1-4), 1-16.



'''

from PySAGA.helper import Tool_Wrapper

