/*******************************************************************************
* Copyright 1999-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) interface for SCALAPACK routines
!******************************************************************************/

#ifndef _MKL_SCALAPACK_H_
#define _MKL_SCALAPACK_H_

#include "mkl_types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void	psgetrf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pdgetrf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pcgetrf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pzgetrf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);

void psgeevx( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, float* a, const MKL_INT* desca, float* wr, float* wi, float* vl,  const MKL_INT* descvl, float* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,  float* rconde, float* rcondv, float* work,  const MKL_INT* lwork, MKL_INT* info );
void pdgeevx( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, double* a, const MKL_INT* desca, double* wr, double* wi, double* vl,  const MKL_INT* descvl, double* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,  double* rconde, double* rcondv, double* work,  const MKL_INT* lwork, MKL_INT* info );
void pcgeevx( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex8* a,  const MKL_INT* desca, MKL_Complex8* w, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm, float* rconde, float* rcondv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void pzgeevx( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex16* a,  const MKL_INT* desca, MKL_Complex16* w, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm, double* rconde, double* rcondv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void	psgbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrf(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspotrf(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotrf(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotrf(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotrf(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	pspbtrf(const char* uplo, const MKL_INT* n, const MKL_INT* bw, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrf(const char* uplo, const MKL_INT* n, const MKL_INT* bw, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrf(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrf(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspttrf(const MKL_INT* n, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrf(const MKL_INT* n, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrf(const MKL_INT* n, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrf(const MKL_INT* n, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdttrf(const MKL_INT* n, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrf(const MKL_INT* n, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrf(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrf(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgetrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdgetrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcgetrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzgetrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	psgbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspotrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdpotrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcpotrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzpotrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	pspbtrs(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrs(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrs(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrs(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspttrs(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrs(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdttrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrs(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pstrtrs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdtrtrs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pctrtrs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pztrtrs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	psgecon(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgecon(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgecon(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgecon(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pspocon(const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdpocon(const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcpocon(const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzpocon(const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pstrcon(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrcon(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pctrcon(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pztrcon(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	psgerfs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgerfs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgerfs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgerfs(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	psporfs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdporfs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcporfs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzporfs(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pstrrfs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrrfs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pctrrfs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pztrrfs(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	psgetri(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgetri(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgetri(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzgetri(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pspotri(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotri(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotri(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotri(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	pstrtri(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdtrtri(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pctrtri(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pztrtri(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	psgeequ(const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	pdgeequ(const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	pcgeequ(const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	pzgeequ(const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);

void	pspoequ(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	pdpoequ(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	pcpoequ(const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	pzpoequ(const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);

void	psgeqrf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqrf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqrf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqrf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgeqpf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqpf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqpf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgeqpf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	psorgqr(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgqr(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcungqr(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungqr(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormqr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormqr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmqr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmqr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgelqf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgelqf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgelqf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgelqf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorglq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorglq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunglq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunglq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormlq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormlq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmlq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmlq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgeqlf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqlf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqlf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqlf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorgql(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgql(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcungql(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungql(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormql(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormql(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmql(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmql(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgerqf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgerqf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgerqf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgerqf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorgrq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgrq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcungrq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungrq(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormrq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormrq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmrq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmrq(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pstzrzf(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdtzrzf(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pctzrzf(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pztzrzf(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormrz(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormrz(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmrz(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmrz(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psggqrf(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdggqrf(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcggqrf(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzggqrf(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psggrqf(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdggrqf(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcggrqf(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzggrqf(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pssytrd(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsytrd(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	psormtr(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormtr(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pchetrd(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhetrd(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmtr(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmtr(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psstebz(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, const float* d, const float* e, MKL_INT* m, MKL_INT* nsplit, float* w, MKL_INT* iblock, MKL_INT* isplit, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdstebz(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, const double* d, const double* e, MKL_INT* m, MKL_INT* nsplit, double* w, MKL_INT* iblock, MKL_INT* isplit, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	psstein(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdstein(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pcstein(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzstein(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	psgehrd(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgehrd(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgehrd(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgehrd(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormhr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormhr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmhr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmhr(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pslahqr(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pdlahqr(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	psgebrd(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgebrd(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgebrd(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgebrd(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormbr(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormbr(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pcunmbr(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmbr(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pssygst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	pdsygst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);

void	pchegst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	pzhegst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);

void	psgesv(const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdgesv(const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcgesv(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzgesv(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	psgesvx(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgesvx(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgesvx(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgesvx(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	psgbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbsv(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdtsv(const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddtsv(const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdtsv(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdtsv(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psposv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdposv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcposv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzposv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	psposvx(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdposvx(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcposvx(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzposvx(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pspbsv(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbsv(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbsv(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbsv(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psptsv(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdptsv(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcptsv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzptsv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgels(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgels(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgels(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgels(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pssyev(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyev(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pssyevd(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdsyevd(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pssyevx(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdsyevx(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	pcheev(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzheev(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pcheevd(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzheevd(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pcheevx(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzheevx(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	psgesvd(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, float* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, float* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgesvd(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, double* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, double* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgesvd(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, MKL_Complex8* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex8* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* info);
void	pzgesvd(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, MKL_Complex16* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex16* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* info);

void	pssygvx(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdsygvx(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	pchegvx(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzhegvx(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	pclacgv(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzlacgv(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	pcmax1(const MKL_INT* n, MKL_Complex8* amax, MKL_INT* indx, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzmax1(const MKL_INT* n, MKL_Complex16* amax, MKL_INT* indx, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	ccombamax1(MKL_Complex8* v1, const MKL_Complex8* v2);
void	zcombamax1(MKL_Complex16* v1, const MKL_Complex16* v2);

void	pscsum1(const MKL_INT* n, float* asum, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pdzsum1(const MKL_INT* n, double* asum, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	psdbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgebd2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgebd2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgebd2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgebd2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgehd2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgehd2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgehd2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgehd2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgelq2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgelq2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgelq2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgelq2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgeql2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeql2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeql2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeql2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgeqr2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqr2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqr2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqr2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgerq2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgerq2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgerq2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgerq2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psgetf2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pdgetf2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pcgetf2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pzgetf2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);

void	pslabrd(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	pdlabrd(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	pclabrd(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	pzlabrd(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);

void	pslacon(const MKL_INT* n, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, float* est, MKL_INT* kase);
void	pdlacon(const MKL_INT* n, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, double* est, MKL_INT* kase);
void	pclacon(const MKL_INT* n, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* est, MKL_INT* kase);
void	pzlacon(const MKL_INT* n, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* est, MKL_INT* kase);

void	pslaconsb(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const float* h44, const float* h33, const float* h43h34, float* buf, const MKL_INT* lwork);
void	pdlaconsb(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const double* h44, const double* h33, const double* h43h34, double* buf, const MKL_INT* lwork);

void	pslacp2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlacp2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclacp2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlacp2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	pslacp3(const MKL_INT* m, const MKL_INT* i, float* a, const MKL_INT* desca, float* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pdlacp3(const MKL_INT* m, const MKL_INT* i, double* a, const MKL_INT* desca, double* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);

void	pslacpy(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlacpy(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclacpy(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlacpy(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	pslaevswp(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* work, const MKL_INT* lwork);
void	pdlaevswp(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* work, const MKL_INT* lwork);
void	pclaevswp(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* rwork, const MKL_INT* lrwork);
void	pzlaevswp(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* rwork, const MKL_INT* lrwork);

void	pslahrd(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* t, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	pdlahrd(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* t, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	pclahrd(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	pzlahrd(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);

void	pslaiect(const float* sigma, const MKL_INT* n, const float* d, MKL_INT* count);

float	pslange(const char* norm, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlange(const char* norm, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclange(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlange(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	pslanhs(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlanhs(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclanhs(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlanhs(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	pslansy(const char* norm, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlansy(const char* norm, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclansy(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlansy(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclanhe(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlanhe(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	pslantr(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlantr(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclantr(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlantr(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

void	pslapiv(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pdlapiv(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pclapiv(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pzlapiv(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);

void	pslaqge(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	pdlaqge(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	pclaqge(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	pzlaqge(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);

void	pslaqsy(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	pdlaqsy(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	pclaqsy(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	pzlaqsy(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);

void	pslared1d(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* bycol, float* byall, float* work, const MKL_INT* lwork);
void	pdlared1d(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* bycol, double* byall, double* work, const MKL_INT* lwork);

void	pslared2d(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* byrow, float* byall, float* work, const MKL_INT* lwork);
void	pdlared2d(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* byrow, double* byall, double* work, const MKL_INT* lwork);

void	pslarf(const char* side, const MKL_INT* m, const MKL_INT* n, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarf(const char* side, const MKL_INT* m, const MKL_INT* n, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarf(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarf(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pslarfb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarfb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarfb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarfb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pclarfc(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarfc(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pslarfg(const MKL_INT* n, float* alpha, const MKL_INT* iax, const MKL_INT* jax, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* tau);
void	pdlarfg(const MKL_INT* n, double* alpha, const MKL_INT* iax, const MKL_INT* jax, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* tau);
void	pclarfg(const MKL_INT* n, MKL_Complex8* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* tau);
void	pzlarfg(const MKL_INT* n, MKL_Complex16* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* tau);

void	pslarft(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	pdlarft(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	pclarft(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	pzlarft(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);

void	pslarz(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarz(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarz(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarz(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pslarzb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarzb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarzb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarzb(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pclarzc(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarzc(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	pslarzt(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	pdlarzt(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	pclarzt(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	pzlarzt(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);

void	pslascl(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdlascl(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pclascl(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzlascl(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	pslaset(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlaset(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclaset(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlaset(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	pslasmsub(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, float* buf, const MKL_INT* lwork);
void	pdlasmsub(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, double* buf, const MKL_INT* lwork);

void	pslassq(const MKL_INT* n, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	pdlassq(const MKL_INT* n, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	pclassq(const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	pzlassq(const MKL_INT* n, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);

void	pslaswp(const char* direc, const char* rowcol, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pdlaswp(const char* direc, const char* rowcol, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pclaswp(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pzlaswp(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);

float	pslatra(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
double	pdlatra(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclatra(MKL_Complex8 *, const MKL_INT *n, const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);
void	pzlatra(MKL_Complex16 *, const MKL_INT *n, const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);

void	pslatrd(const char* uplo, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, float* work);
void	pdlatrd(const char* uplo, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, double* work);
void	pclatrd(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex8* work);
void	pzlatrd(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex16* work);

void	pslatrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, float* work);
void	pdlatrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, double* work);
void	pclatrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_Complex8* work);
void	pzlatrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_Complex16* work);

void	pslatrz(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work);
void	pdlatrz(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work);
void	pclatrz(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work);
void	pzlatrz(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work);

void	pslauu2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlauu2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclauu2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlauu2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	pslauum(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlauum(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclauum(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlauum(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	pslawil(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const float* a, const MKL_INT* desca, const float* h44, const float* h33, const float* h43h34, float* v);
void	pdlawil(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const double* a, const MKL_INT* desca, const double* h44, const double* h33, const double* h43h34, double* v);

void	psorg2l(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorg2l(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcung2l(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzung2l(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorg2r(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorg2r(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcung2r(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzung2r(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorgl2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgl2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungl2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungl2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorgr2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgr2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungr2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungr2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorm2l(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorm2l(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunm2l(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunm2l(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorm2r(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorm2r(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunm2r(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunm2r(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psorml2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorml2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunml2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunml2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	psormr2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormr2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmr2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmr2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspttrsv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrsv(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pspotf2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotf2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotf2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotf2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	psrscl(const MKL_INT* n, const float* sa, float* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pdrscl(const MKL_INT* n, const double* sa, double* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pcsrscl(const MKL_INT* n, const float* sa, MKL_Complex8* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzdrscl(const MKL_INT* n, const double* sa, MKL_Complex16* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	pssygs2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdsygs2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pchegs2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzhegs2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	pssytd2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsytd2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pchetd2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhetd2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pstrti2(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdtrti2(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pctrti2(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pztrti2(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	slamsh(float* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, float* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	dlamsh(double* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, double* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);

void	slaref(const char* type, float* a, const MKL_INT* lda, const MKL_INT* wantz, float* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const float* vecs, float* v2, float* v3, float* t1, float* t2, float* t3);
void	dlaref(const char* type, double* a, const MKL_INT* lda, const MKL_INT* wantz, double* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const double* vecs, double* v2, double* v3, double* t1, double* t2, double* t3);

void	slasorte(float* s, const MKL_INT* lds, const MKL_INT* j, float* out, MKL_INT* info);
void	dlasorte(double* s, const MKL_INT* lds, const MKL_INT* j, double* out, MKL_INT* info);

void	slasrt2(const char* id, const MKL_INT* n, float* d, MKL_INT* key, MKL_INT* info);
void	dlasrt2(const char* id, const MKL_INT* n, double* d, MKL_INT* key, MKL_INT* info);

void	sstein2(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, const float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	dstein2(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, const double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);

void	sdbtf2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	ddbtf2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	cdbtf2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	zdbtf2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);

void	sdbtrf(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	ddbtrf(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	cdbtrf(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	zdbtrf(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);

void	sdttrf(const MKL_INT* n, float* dl, float* d, float* du, MKL_INT* info);
void	ddttrf(const MKL_INT* n, double* dl, double* d, double* du, MKL_INT* info);
void	cdttrf(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, MKL_INT* info);
void	zdttrf(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, MKL_INT* info);

void	sdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* dl, const float* d, const float* du, float* b, const MKL_INT* ldb, MKL_INT* info);
void	ddttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* dl, const double* d, const double* du, double* b, const MKL_INT* ldb, MKL_INT* info);
void	cdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* dl, const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	zdttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* dl, const MKL_Complex16* d, const MKL_Complex16* du, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);

void	spttrsv(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const float* e, float* b, const MKL_INT* ldb, MKL_INT* info);
void	dpttrsv(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const double* e, double* b, const MKL_INT* ldb, MKL_INT* info);
void	cpttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const MKL_Complex8* e, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	zpttrsv(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const MKL_Complex16* e, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);

void	ssteqr2(const char* compz, const MKL_INT* n, float* d, float* e, float* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	dsteqr2(const char* compz, const MKL_INT* n, double* d, double* e, double* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);

void	pslabad(const MKL_INT* ictxt, float* small, float* large);
void	pdlabad(const MKL_INT* ictxt, double* small, double* large);

void	pslachkieee(MKL_INT* isieee, const float* rmax, const float* rmin);
void	pdlachkieee(MKL_INT* isieee, const double* rmax, const double* rmin);

float	pslamch(const MKL_INT* ictxt, const char* cmach);
double	pdlamch(const MKL_INT* ictxt, const char* cmach);

void	pslasnbt(MKL_INT* ieflag);
void	pdlasnbt(MKL_INT* ieflag);

void	pxerbla(const MKL_INT* ictxt, const char* srname, const MKL_INT* info, MKL_INT srname_len);

/* Declarations are added in oneMKL 11.2 Beta */

void	bdlaapp(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, double* dtraf, double* work);
void	bdlaexc(const MKL_INT* n, double* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, double* dtraf, double* work, MKL_INT* info);
void	bdtrexc(const MKL_INT* n, double* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, double* dtraf, double* work, MKL_INT* info);
void	bslaapp(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, float* dtraf, float* work);
void	bslaexc(const MKL_INT* n, float* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, float* dtraf, float* work, MKL_INT* info);
void	bstrexc(const MKL_INT* n, float* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, float* dtraf, float* work, MKL_INT* info);

void	dlaqr6(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* ldz, double* v, const MKL_INT* ldv, double* u, const MKL_INT* ldu, const MKL_INT* nv, double* wv, const MKL_INT* ldwv, const MKL_INT* nh, double* wh, const MKL_INT* ldwh);
void	dlar1va(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const double* lambda, const double* d, const double* l, const double* ld, const double* lld, const double* pivmin, const double* gaptol, double* z, const MKL_INT* wantnc, MKL_INT* negcnt, double* ztz, double* mingma, MKL_INT* r, MKL_INT* isuppz, double* nrminv, double* resid, double* rqcorr, double* work);
void	dlarrb2(const MKL_INT* n, const double* d, const double* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const double* rtol1, const double* rtol2, const MKL_INT* offset, double* w, double* wgap, double* werr, double* work, MKL_INT* iwork, const double* pivmin, const double* lgpvmn, const double* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	dlarrd2(const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* gers, const double* reltol, const double* d, const double* e, const double* e2, const double* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, double* w, double* werr, double* wl, double* wu, MKL_INT* iblock, MKL_INT* indexw, double* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	dlarre2(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* pivmin, double* work, MKL_INT* iwork, MKL_INT* info);
void	dlarre2a(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* sdiam, double* pivmin, double* work, MKL_INT* iwork, const double* minrgp, MKL_INT* info);
void	dlarrf2(const MKL_INT* n, const double* d, const double* l, const double* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const double* w, double* wgap, const double* werr, const MKL_INT* trymid, const double* spdiam, const double* clgapl, const double* clgapr, const double* pivmin, double* sigma, double* dplus, double* lplus, double* work, MKL_INT* info);
void	dlarrv2(const MKL_INT* n, const double* vl, const double* vu, double* d, double* l, const double* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const double* minrgp, const double* rtol1, const double* rtol2, double* w, double* werr, double* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const double* gers, const double* sdiam, double* z, const MKL_INT* ldz, MKL_INT* isuppz, double* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	dstegr2(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	dstegr2a(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, double* pivmin, double* scale, double* wl, double* wu, MKL_INT* info);
void	dstegr2b(const char* jobz, const MKL_INT* n, double* d, double* e, const MKL_INT* m, const double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const double* pivmin, const double* scale, const double* wl, const double* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	pcheevr(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcrot(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* c, const MKL_Complex8* s);

void	pdgebal(const char* job, const MKL_INT* n, double* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void	pdlamve(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* dwork);
void	pdlaqr0(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	pdlaqr1(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pdlaqr2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* wr, double* wi, double* work, const MKL_INT* lwork);
void	pdlaqr3(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* v, const MKL_INT* descv, const MKL_INT* nh, double* t, const MKL_INT* desct, const MKL_INT* nv, double* wv, const MKL_INT* descw, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	pdlaqr4(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pdlaqr5(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	pdrot(const MKL_INT* n, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* cs, const double* sn, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyevr(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrord(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrsen(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* s, double* sep, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pmpcol(const MKL_INT* myproc, const MKL_INT* nprocs, const MKL_INT* iil, const MKL_INT* needil, const MKL_INT* neediu, const MKL_INT* pmyils, const MKL_INT* pmyius, MKL_INT* colbrt, MKL_INT* frstcl, MKL_INT* lastcl);
void	pmpim2(const MKL_INT* il, const MKL_INT* iu, const MKL_INT* nprocs, MKL_INT* pmyils, MKL_INT* pmyius);

void	psgebal(const char* job, const MKL_INT* n, float* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void	pslamve(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* dwork);
void	pslaqr0(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	pslaqr1(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pslaqr2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* wr, float* wi, float* work, const MKL_INT* lwork);
void	pslaqr3(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* v, const MKL_INT* descv, const MKL_INT* nh, float* t, const MKL_INT* desct, const MKL_INT* nv, float* wv, const MKL_INT* descw, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	pslaqr4(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pslaqr5(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	psrot(const MKL_INT* n, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* cs, const float* sn, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pssyevr(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pstrord(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pstrsen(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* s, float* sep, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pzheevr(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzrot(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* c, const MKL_Complex16* s);

void	slaqr6(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* ldz, float* v, const MKL_INT* ldv, float* u, const MKL_INT* ldu, const MKL_INT* nv, float* wv, const MKL_INT* ldwv, const MKL_INT* nh, float* wh, const MKL_INT* ldwh);
void	slar1va(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const float* lambda, const float* d, const float* l, const float* ld, const float* lld, const float* pivmin, const float* gaptol, float* z, const MKL_INT* wantnc, MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r, MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr, float* work);
void	slarrb2(const MKL_INT* n, const float* d, const float* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const float* rtol1, const float* rtol2, const MKL_INT* offset, float* w, float* wgap, float* werr, float* work, MKL_INT* iwork, const float* pivmin, const float* lgpvmn, const float* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	slarrd2(const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* gers, const float* reltol, const float* d, const float* e, const float* e2, const float* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, float* w, float* werr, float* wl, float* wu, MKL_INT* iblock, MKL_INT* indexw, float* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	slarre2(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* pivmin, float* work, MKL_INT* iwork, MKL_INT* info);
void	slarre2a(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* sdiam, float* pivmin, float* work, MKL_INT* iwork, const float* minrgp, MKL_INT* info);
void	slarrf2(const MKL_INT* n, const float* d, const float* l, const float* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const float* w, float* wgap, const float* werr, const MKL_INT* trymid, const float* spdiam, const float* clgapl, const float* clgapr, const float* pivmin, float* sigma, float* dplus, float* lplus, float* work, MKL_INT* info);
void	slarrv2(const MKL_INT* n, const float* vl, const float* vu, float* d, float* l, const float* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const float* minrgp, const float* rtol1, const float* rtol2, float* w, float* werr, float* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const float* gers, const float* sdiam, float* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	sstegr2(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	sstegr2a(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, float* pivmin, float* scale, float* wl, float* wu, MKL_INT* info);
void	sstegr2b(const char* jobz, const MKL_INT* n, float* d, float* e, const MKL_INT* m, const float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const float* pivmin, const float* scale, const float* wl, const float* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

/* Declarations added oneMKL 11.3.2 */

void	pchengst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhengst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pchentrd(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzhentrd(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	pchettrd(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhettrd(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	pshseqr(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdhseqr(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pclaconsb(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* buf, const MKL_INT* lwork);
void	pzlaconsb(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* buf, const MKL_INT* lwork);

void	pclacp3(const MKL_INT* m, const MKL_INT* i, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pzlacp3(const MKL_INT* m, const MKL_INT* i, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);

void	pslaed0(const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* iwork, MKL_INT* info);
void	pdlaed0(const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* iwork, MKL_INT* info);

void	pslaed1(const MKL_INT* n, const MKL_INT* n1, float* d, const MKL_INT* id, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const float* rho, float* work, MKL_INT* iwork, MKL_INT* info);
void	pdlaed1(const MKL_INT* n, const MKL_INT* n1, double* d, const MKL_INT* id, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const double* rho, double* work, MKL_INT* iwork, MKL_INT* info);

void	pslaed2(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* q, const MKL_INT* ldq, float* rho, const float* z, float* w, float* dlamda, float* q2, const MKL_INT* ldq2, float* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	pdlaed2(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* q, const MKL_INT* ldq, double* rho, const double* z, double* w, double* dlamda, double* q2, const MKL_INT* ldq2, double* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);

void	pslaed3(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* rho, float* dlamda, float* w, const float* z, float* u, const MKL_INT* ldu, float* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	pdlaed3(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* rho, double* dlamda, double* w, const double* z, double* u, const MKL_INT* ldu, double* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);

void	pslaedz(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, float* z, float* work);
void	pdlaedz(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, double* z, double* work);

void	pclahqr(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pzlahqr(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	clahqr2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* info);
void	zlahqr2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* h, const MKL_INT* ldh, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* ldz, MKL_INT* info);

void	pdlaiectb(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);
void	pdlaiectl(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);

void	slamov(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const float* A, const MKL_INT* LDA, float* B, const MKL_INT* LDB);
void	dlamov(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const double* A, const MKL_INT* LDA, double* B, const MKL_INT* LDB);
void	clamov(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex8* A, const MKL_INT* LDA, MKL_Complex8* B, const MKL_INT* LDB);
void	zlamov(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex16* A, const MKL_INT* LDA, MKL_Complex16* B, const MKL_INT* LDB);

void	pslamr1d(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlamr1d(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclamr1d(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlamr1d(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	clamsh(MKL_Complex8* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	zlamsh(MKL_Complex16* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex16* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);

void	clanv2(MKL_Complex8* a, MKL_Complex8* b, MKL_Complex8* c, MKL_Complex8* d, MKL_Complex8* rt1, MKL_Complex8* rt2, float* cs, MKL_Complex8* sn);
void	zlanv2(MKL_Complex16* a, MKL_Complex16* b, MKL_Complex16* c, MKL_Complex16* d, MKL_Complex16* rt1, MKL_Complex16* rt2, double* cs, MKL_Complex16* sn);

void	slapst(const char* id, const MKL_INT* n, const float* d, MKL_INT* indx, MKL_INT* info);
void	dlapst(const char* id, const MKL_INT* n, const double* d, MKL_INT* indx, MKL_INT* info);

void	pslapv2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pdlapv2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pclapv2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pzlapv2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);

void	claref(const char* type, MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex8* vecs, MKL_Complex8* v2, MKL_Complex8* v3, MKL_Complex8* t1, MKL_Complex8* t2, MKL_Complex8* t3);
void	zlaref(const char* type, MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex16* vecs, MKL_Complex16* v2, MKL_Complex16* v3, MKL_Complex16* t1, MKL_Complex16* t2, MKL_Complex16* t3);

void	pslase2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlase2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclase2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlase2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	pclasmsub(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, MKL_Complex8* buf, const MKL_INT* lwork);
void	pzlasmsub(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, MKL_Complex16* buf, const MKL_INT* lwork);

void	pslasrt(const char* id, const MKL_INT* n, float* d, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdlasrt(const char* id, const MKL_INT* n, double* d, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	pclattrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_INT* info);
void	pzlattrs(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_INT* info);

void	pilaver(MKL_INT* vers_major, MKL_INT* vers_minor, MKL_INT* vers_patch);

void	pclawil(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex8* a, const MKL_INT* desca, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* v);
void	pzlawil(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex16* a, const MKL_INT* desca, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* v);

void	psormr3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormr3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	psstedc(const char* compz, const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdstedc(const char* compz, const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	csteqr2(const char* compz, const MKL_INT* n, float* d, float* e, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	zsteqr2(const char* compz, const MKL_INT* n, double* d, double* e, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);

void	pssyngst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyngst(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pssyntrd(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyntrd(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pssyttrd(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyttrd(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	pctrevc(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex8* t, const MKL_INT* desct, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork, MKL_INT* info);
void	pztrevc(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex16* t, const MKL_INT* desct, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work, double* rwork, MKL_INT* info);
void	pstrevc(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, float* t, const MKL_INT* desct, float* vl, const MKL_INT* descvl, float* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, float* work, MKL_INT* info);
void	pdtrevc(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, double* t, const MKL_INT* desct, double* vl, const MKL_INT* descvl, double* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* info);

void	strmvt(const char* uplo, const MKL_INT* n, const float* t, const MKL_INT* ldt, float* x, const MKL_INT* incx, const float* y, const MKL_INT* incy, float* w, const MKL_INT* incw, const float* z, const MKL_INT* incz);
void	dtrmvt(const char* uplo, const MKL_INT* n, const double* t, const MKL_INT* ldt, double* x, const MKL_INT* incx, const double* y, const MKL_INT* incy, double* w, const MKL_INT* incw, const double* z, const MKL_INT* incz);
void	ctrmvt(const char* uplo, const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* x, const MKL_INT* incx, const MKL_Complex8* y, const MKL_INT* incy, MKL_Complex8* w, const MKL_INT* incw, const MKL_Complex8* z, const MKL_INT* incz);
void	ztrmvt(const char* uplo, const MKL_INT* n, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* x, const MKL_INT* incx, const MKL_Complex16* y, const MKL_INT* incy, MKL_Complex16* w, const MKL_INT* incw, const MKL_Complex16* z, const MKL_INT* incz);

void	pcunmr3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmr3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

MKL_INT	pilaenvx(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	piparmq(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_INT* lworknb);
MKL_INT	pjlaenv(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);



/* OTHER NAMING CONVENTIONS FOLLOW */

void	PSGETRF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PDGETRF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PCGETRF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PZGETRF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PSGETRF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PDGETRF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PCGETRF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PZGETRF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	psgetrf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pdgetrf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pcgetrf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pzgetrf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);

void psgeevx_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, float* a, const MKL_INT* desca, float* wr, float* wi, float* vl,  const MKL_INT* descvl, float* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,  float* rconde, float* rcondv, float* work,  const MKL_INT* lwork, MKL_INT* info );
void pdgeevx_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, double* a, const MKL_INT* desca, double* wr, double* wi, double* vl,  const MKL_INT* descvl, double* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,  double* rconde, double* rcondv, double* work,  const MKL_INT* lwork, MKL_INT* info );
void pcgeevx_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex8* a,  const MKL_INT* desca, MKL_Complex8* w, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm, float* rconde, float* rcondv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void pzgeevx_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex16* a,  const MKL_INT* desca, MKL_Complex16* w, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm, double* rconde, double* rcondv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void PSGEEVX( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, float* a, const MKL_INT* desca, float* wr, float* wi, float* vl,  const MKL_INT* descvl, float* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,  float* rconde, float* rcondv, float* work,  const MKL_INT* lwork, MKL_INT* info );
void PDGEEVX( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, double* a, const MKL_INT* desca, double* wr, double* wi, double* vl,  const MKL_INT* descvl, double* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,  double* rconde, double* rcondv, double* work,  const MKL_INT* lwork, MKL_INT* info );
void PCGEEVX( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex8* a,  const MKL_INT* desca, MKL_Complex8* w, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm, float* rconde, float* rcondv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void PZGEEVX( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex16* a,  const MKL_INT* desca, MKL_Complex16* w, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm, double* rconde, double* rcondv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void PSGEEVX_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, float* a, const MKL_INT* desca, float* wr, float* wi, float* vl,  const MKL_INT* descvl, float* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,  float* rconde, float* rcondv, float* work,  const MKL_INT* lwork, MKL_INT* info );
void PDGEEVX_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, double* a, const MKL_INT* desca, double* wr, double* wi, double* vl,  const MKL_INT* descvl, double* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,  double* rconde, double* rcondv, double* work,  const MKL_INT* lwork, MKL_INT* info ); 
void PCGEEVX_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex8* a,  const MKL_INT* desca, MKL_Complex8* w, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm, float* rconde, float* rcondv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ); 
void PZGEEVX_( const char* balanc, const char* jobvl, const char* jobvr, const char* sense, const MKL_INT* n, MKL_Complex16* a,  const MKL_INT* desca, MKL_Complex16* w, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm, double* rconde, double* rcondv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );




void	PSGBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRF(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRF_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrf_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPOTRF(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTRF(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTRF(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTRF(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSPOTRF_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTRF_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTRF_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTRF_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pspotrf_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotrf_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotrf_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotrf_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	PSPBTRF(const char* uplo, const MKL_INT* n, const MKL_INT* bw, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRF(const char* uplo, const MKL_INT* n, const MKL_INT* bw, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRF(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRF(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPBTRF_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRF_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRF_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRF_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspbtrf_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, float* a, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrf_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, double* a, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrf_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrf_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPTTRF(const MKL_INT* n, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRF(const MKL_INT* n, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRF(const MKL_INT* n, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRF(const MKL_INT* n, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPTTRF_(const MKL_INT* n, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRF_(const MKL_INT* n, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRF_(const MKL_INT* n, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRF_(const MKL_INT* n, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspttrf_(const MKL_INT* n, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrf_(const MKL_INT* n, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrf_(const MKL_INT* n, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrf_(const MKL_INT* n, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDTTRF(const MKL_INT* n, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRF(const MKL_INT* n, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRF(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRF(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDTTRF_(const MKL_INT* n, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRF_(const MKL_INT* n, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRF_(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRF_(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdttrf_(const MKL_INT* n, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrf_(const MKL_INT* n, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrf_(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrf_(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGETRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDGETRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCGETRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZGETRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSGETRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDGETRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCGETRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZGETRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	psgetrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdgetrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcgetrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzgetrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSGBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPOTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDPOTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCPOTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZPOTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSPOTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDPOTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCPOTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZPOTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pspotrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdpotrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcpotrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzpotrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSPBTRS(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRS(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRS(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRS(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPBTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspbtrs_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrs_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrs_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrs_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPTTRS(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRS(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPTTRS_(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRS_(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspttrs_(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrs_(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDTTRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDTTRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdttrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRS(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRS_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrs_(const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSTRTRS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDTRTRS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCTRTRS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZTRTRS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSTRTRS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDTRTRS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCTRTRS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZTRTRS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pstrtrs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdtrtrs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pctrtrs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pztrtrs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSGECON(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGECON(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGECON(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGECON(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSGECON_(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGECON_(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGECON_(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGECON_(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psgecon_(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgecon_(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgecon_(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgecon_(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSPOCON(const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPOCON(const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPOCON(const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPOCON(const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSPOCON_(const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPOCON_(const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPOCON_(const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPOCON_(const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pspocon_(const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdpocon_(const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcpocon_(const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* anorm, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzpocon_(const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* anorm, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSTRCON(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRCON(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCTRCON(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZTRCON(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSTRCON_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRCON_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCTRCON_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZTRCON_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pstrcon_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrcon_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pctrcon_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* rcond, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pztrcon_(const char* norm, const char* uplo, const char* diag, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* rcond, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSGERFS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGERFS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGERFS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGERFS(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSGERFS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGERFS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGERFS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGERFS_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psgerfs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgerfs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgerfs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgerfs_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_INT* ipiv, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSPORFS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPORFS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPORFS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPORFS(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSPORFS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPORFS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPORFS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPORFS_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psporfs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdporfs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcporfs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzporfs_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSTRRFS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRRFS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCTRRFS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZTRRFS(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSTRRFS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRRFS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCTRRFS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZTRRFS_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pstrrfs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrrfs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pctrrfs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pztrrfs_(const char* uplo, const char* trans, const char* diag, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSGETRI(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGETRI(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGETRI(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PZGETRI(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSGETRI_(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGETRI_(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGETRI_(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PZGETRI_(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	psgetri_(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgetri_(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgetri_(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzgetri_(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PSPOTRI(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTRI(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTRI(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTRI(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSPOTRI_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTRI_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTRI_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTRI_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pspotri_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotri_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotri_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotri_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	PSTRTRI(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDTRTRI(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCTRTRI(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZTRTRI(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSTRTRI_(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDTRTRI_(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCTRTRI_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZTRTRI_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pstrtri_(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdtrtri_(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pctrtri_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pztrtri_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	PSGEEQU(const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	PDGEEQU(const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	PCGEEQU(const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	PZGEEQU(const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	PSGEEQU_(const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	PDGEEQU_(const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	PCGEEQU_(const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	PZGEEQU_(const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	psgeequ_(const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	pdgeequ_(const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);
void	pcgeequ_(const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* r, float* c, float* rowcnd, float* colcnd, float* amax, MKL_INT* info);
void	pzgeequ_(const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* r, double* c, double* rowcnd, double* colcnd, double* amax, MKL_INT* info);

void	PSPOEQU(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	PDPOEQU(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	PCPOEQU(const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	PZPOEQU(const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	PSPOEQU_(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	PDPOEQU_(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	PCPOEQU_(const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	PZPOEQU_(const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	pspoequ_(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	pdpoequ_(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);
void	pcpoequ_(const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* sr, float* sc, float* scond, float* amax, MKL_INT* info);
void	pzpoequ_(const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* sr, double* sc, double* scond, double* amax, MKL_INT* info);

void	PSGEQRF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQRF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQRF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQRF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEQRF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQRF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQRF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQRF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgeqrf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqrf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqrf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqrf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEQPF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQPF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQPF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGEQPF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSGEQPF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQPF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQPF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGEQPF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psgeqpf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqpf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqpf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgeqpf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSORGQR(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGQR(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGQR_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGQR_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psorgqr_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgqr_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNGQR(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGQR(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGQR_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGQR_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungqr_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungqr_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMQR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMQR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMQR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMQR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormqr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormqr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMQR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMQR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMQR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMQR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmqr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmqr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGELQF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELQF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELQF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELQF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGELQF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELQF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELQF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELQF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgelqf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgelqf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgelqf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgelqf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORGLQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGLQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGLQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGLQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psorglq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorglq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNGLQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGLQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGLQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGLQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunglq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunglq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMLQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMLQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMLQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMLQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormlq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormlq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMLQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMLQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMLQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMLQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmlq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmlq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEQLF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQLF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQLF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQLF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEQLF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQLF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQLF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQLF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgeqlf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqlf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqlf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqlf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORGQL(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGQL(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGQL_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGQL_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psorgql_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgql_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNGQL(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGQL(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGQL_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGQL_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungql_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungql_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMQL(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMQL(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMQL_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMQL_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormql_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormql_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMQL(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMQL(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMQL_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMQL_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmql_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmql_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGERQF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGERQF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGERQF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGERQF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGERQF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGERQF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGERQF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGERQF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgerqf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgerqf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgerqf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgerqf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORGRQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGRQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGRQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGRQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psorgrq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgrq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNGRQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGRQ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGRQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGRQ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungrq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungrq_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMRQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMRQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMRQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMRQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormrq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormrq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMRQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMRQ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMRQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMRQ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmrq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmrq_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSTZRZF(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDTZRZF(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCTZRZF(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZTZRZF(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSTZRZF_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDTZRZF_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCTZRZF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZTZRZF_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pstzrzf_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdtzrzf_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pctzrzf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pztzrzf_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMRZ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMRZ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMRZ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMRZ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormrz_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormrz_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMRZ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMRZ(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMRZ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMRZ_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmrz_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmrz_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGGQRF(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGGQRF(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGGQRF(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGGQRF(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGGQRF_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGGQRF_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGGQRF_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGGQRF_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psggqrf_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdggqrf_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcggqrf_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzggqrf_(const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGGRQF(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGGRQF(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGGRQF(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGGRQF(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGGRQF_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGGRQF_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGGRQF_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGGRQF_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psggrqf_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* taua, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* taub, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdggrqf_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* taua, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* taub, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcggrqf_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* taua, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* taub, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzggrqf_(const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* taua, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* taub, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYTRD(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTRD(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYTRD_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTRD_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pssytrd_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsytrd_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMTR(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMTR(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMTR_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMTR_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormtr_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormtr_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCHETRD(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETRD(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCHETRD_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETRD_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pchetrd_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhetrd_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMTR(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMTR(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMTR_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMTR_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmtr_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmtr_(const char* side, const char* uplo, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSTEBZ(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, const float* d, const float* e, MKL_INT* m, MKL_INT* nsplit, float* w, MKL_INT* iblock, MKL_INT* isplit, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSTEBZ(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, const double* d, const double* e, MKL_INT* m, MKL_INT* nsplit, double* w, MKL_INT* iblock, MKL_INT* isplit, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSSTEBZ_(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, const float* d, const float* e, MKL_INT* m, MKL_INT* nsplit, float* w, MKL_INT* iblock, MKL_INT* isplit, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSTEBZ_(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, const double* d, const double* e, MKL_INT* m, MKL_INT* nsplit, double* w, MKL_INT* iblock, MKL_INT* isplit, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	psstebz_(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, const float* d, const float* e, MKL_INT* m, MKL_INT* nsplit, float* w, MKL_INT* iblock, MKL_INT* isplit, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdstebz_(const MKL_INT* ictxt, const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, const double* d, const double* e, MKL_INT* m, MKL_INT* nsplit, double* w, MKL_INT* iblock, MKL_INT* isplit, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PSSTEIN(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSTEIN(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PCSTEIN(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZSTEIN(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PSSTEIN_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSTEIN_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PCSTEIN_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZSTEIN_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	psstein_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdstein_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pcstein_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzstein_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	PSGEHRD(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEHRD(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEHRD(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEHRD(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEHRD_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEHRD_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEHRD_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEHRD_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgehrd_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgehrd_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgehrd_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgehrd_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMHR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMHR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMHR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMHR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormhr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormhr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMHR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMHR(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMHR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMHR_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmhr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmhr_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSLAHQR(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PDLAHQR(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PSLAHQR_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PDLAHQR_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pslahqr_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pdlahqr_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	PSGEBRD(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEBRD(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEBRD(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEBRD(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEBRD_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEBRD_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEBRD_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEBRD_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgebrd_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgebrd_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgebrd_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgebrd_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMBR(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMBR(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMBR_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMBR_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormbr_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormbr_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCUNMBR(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMBR(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMBR_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMBR_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmbr_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmbr_(const char* vect, const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	PDSYGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);
void	PSSYGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	PDSYGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);
void	pssygst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	pdsygst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);

void	PCHEGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	PZHEGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);
void	PCHEGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	PZHEGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);
void	pchegst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_INT* info);
void	pzhegst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_INT* info);

void	PSGESV(const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDGESV(const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCGESV(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZGESV(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSGESV_(const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDGESV_(const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCGESV_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZGESV_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	psgesv_(const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdgesv_(const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcgesv_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzgesv_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSGESVX(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGESVX(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGESVX(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGESVX(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSGESVX_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDGESVX_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCGESVX_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZGESVX_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psgesvx_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdgesvx_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcgesvx_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, float* r, float* c, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzgesvx_(const char* fact, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, MKL_INT* ipiv, char* equed, double* r, double* c, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSGBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBSV(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBSV_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbsv_(const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDTSV(const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTSV(const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTSV(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTSV(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDTSV_(const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTSV_(const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTSV_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTSV_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdtsv_(const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddtsv_(const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdtsv_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdtsv_(const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPOSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDPOSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCPOSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZPOSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSPOSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDPOSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCPOSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZPOSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	psposv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdposv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pcposv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzposv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSPOSVX(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPOSVX(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPOSVX(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPOSVX(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PSPOSVX_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDPOSVX_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCPOSVX_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZPOSVX_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	psposvx_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdposvx_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcposvx_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, float* sr, float* sc, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* rcond, float* ferr, float* berr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzposvx_(const char* fact, const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* af, const MKL_INT* iaf, const MKL_INT* jaf, const MKL_INT* descaf, char* equed, double* sr, double* sc, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* rcond, double* ferr, double* berr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PSPBSV(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBSV(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBSV(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBSV(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPBSV_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBSV_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBSV_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBSV_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspbsv_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbsv_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbsv_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbsv_(const char* uplo, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPTSV(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTSV(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPTSV_(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTSV_(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psptsv_(const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdptsv_(const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcptsv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzptsv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGELS(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELS(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELS(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELS(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGELS_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELS_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELS_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELS_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgels_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgels_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgels_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgels_(const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYEV(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYEV(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYEV_(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYEV_(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pssyev_(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyev_(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYEVD(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSYEVD(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSSYEVD_(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSYEVD_(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pssyevd_(const char* jobz, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdsyevd_(const char* jobz, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PSSYEVX(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSYEVX(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PSSYEVX_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSYEVX_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pssyevx_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdsyevx_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	PCHEEV(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZHEEV(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PCHEEV_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZHEEV_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pcheev_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzheev_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PCHEEVD(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PZHEEVD(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCHEEVD_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PZHEEVD_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcheevd_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzheevd_(const char* jobz, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PCHEEVX(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZHEEVX(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PCHEEVX_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZHEEVX_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pcheevx_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzheevx_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	PSGESVD(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, float* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, float* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGESVD(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, double* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, double* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGESVD(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, MKL_Complex8* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex8* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* info);
void	PZGESVD(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, MKL_Complex16* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex16* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* info);
void	PSGESVD_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, float* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, float* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGESVD_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, double* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, double* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGESVD_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, MKL_Complex8* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex8* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* info);
void	PZGESVD_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, MKL_Complex16* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex16* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* info);
void	psgesvd_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, float* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, float* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgesvd_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, double* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, double* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgesvd_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* s, MKL_Complex8* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex8* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* info);
void	pzgesvd_(const char* jobu, const char* jobvt, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* s, MKL_Complex16* u, const MKL_INT* iu, const MKL_INT* ju, const MKL_INT* descu, MKL_Complex16* vt, const MKL_INT* ivt, const MKL_INT* jvt, const MKL_INT* descvt, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* info);

void	PSSYGVX(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSYGVX(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PSSYGVX_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PDSYGVX_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pssygvx_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pdsygvx_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	PCHEGVX(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZHEGVX(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	PCHEGVX_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	PZHEGVX_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);
void	pchegvx_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* abstol, MKL_INT* m, MKL_INT* nz, float* w, const float* orfac, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, float* gap, MKL_INT* info);
void	pzhegvx_(const MKL_INT* ibtype, const char* jobz, const char* range, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* abstol, MKL_INT* m, MKL_INT* nz, double* w, const double* orfac, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* ifail, MKL_INT* iclustr, double* gap, MKL_INT* info);

void	PCLACGV(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZLACGV(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PCLACGV_(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZLACGV_(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pclacgv_(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzlacgv_(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	PCMAX1(const MKL_INT* n, MKL_Complex8* amax, MKL_INT* indx, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZMAX1(const MKL_INT* n, MKL_Complex16* amax, MKL_INT* indx, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PCMAX1_(const MKL_INT* n, MKL_Complex8* amax, MKL_INT* indx, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZMAX1_(const MKL_INT* n, MKL_Complex16* amax, MKL_INT* indx, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pcmax1_(const MKL_INT* n, MKL_Complex8* amax, MKL_INT* indx, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzmax1_(const MKL_INT* n, MKL_Complex16* amax, MKL_INT* indx, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	CCOMBAMAX1(MKL_Complex8* v1, const MKL_Complex8* v2);
void	ZCOMBAMAX1(MKL_Complex16* v1, const MKL_Complex16* v2);
void	CCOMBAMAX1_(MKL_Complex8* v1, const MKL_Complex8* v2);
void	ZCOMBAMAX1_(MKL_Complex16* v1, const MKL_Complex16* v2);
void	ccombamax1_(MKL_Complex8* v1, const MKL_Complex8* v2);
void	zcombamax1_(MKL_Complex16* v1, const MKL_Complex16* v2);

void	PSCSUM1(const MKL_INT* n, float* asum, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PDZSUM1(const MKL_INT* n, double* asum, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PSCSUM1_(const MKL_INT* n, float* asum, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PDZSUM1_(const MKL_INT* n, double* asum, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pscsum1_(const MKL_INT* n, float* asum, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pdzsum1_(const MKL_INT* n, double* asum, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	PSDBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bwl, const MKL_INT* bwu, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* dl, float* d, float* du, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pddttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d, double* du, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEBD2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEBD2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEBD2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEBD2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEBD2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEBD2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEBD2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEBD2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgebd2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgebd2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgebd2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgebd2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEHD2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEHD2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEHD2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEHD2(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEHD2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEHD2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEHD2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEHD2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgehd2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgehd2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgehd2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgehd2_(const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGELQ2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELQ2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELQ2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELQ2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGELQ2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGELQ2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGELQ2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGELQ2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgelq2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgelq2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgelq2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgelq2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEQL2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQL2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQL2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQL2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEQL2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQL2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQL2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQL2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgeql2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeql2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeql2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeql2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGEQR2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQR2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQR2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQR2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGEQR2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGEQR2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGEQR2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGEQR2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgeqr2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgeqr2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgeqr2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgeqr2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGERQ2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGERQ2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGERQ2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGERQ2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSGERQ2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDGERQ2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCGERQ2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZGERQ2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psgerq2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdgerq2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcgerq2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzgerq2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSGETF2(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PDGETF2(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PCGETF2(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PZGETF2(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PSGETF2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PDGETF2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PCGETF2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	PZGETF2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	psgetf2_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pdgetf2_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pcgetf2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);
void	pzgetf2_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* ipiv, MKL_INT* info);

void	PSLABRD(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	PDLABRD(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	PCLABRD(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	PZLABRD(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);
void	PSLABRD_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	PDLABRD_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	PCLABRD_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	PZLABRD_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);
void	pslabrd_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tauq, float* taup, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	pdlabrd_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tauq, double* taup, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	pclabrd_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	pzlabrd_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tauq, MKL_Complex16* taup, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);

void	PSLACON(const MKL_INT* n, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, float* est, MKL_INT* kase);
void	PDLACON(const MKL_INT* n, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, double* est, MKL_INT* kase);
void	PCLACON(const MKL_INT* n, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* est, MKL_INT* kase);
void	PZLACON(const MKL_INT* n, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* est, MKL_INT* kase);
void	PSLACON_(const MKL_INT* n, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, float* est, MKL_INT* kase);
void	PDLACON_(const MKL_INT* n, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, double* est, MKL_INT* kase);
void	PCLACON_(const MKL_INT* n, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* est, MKL_INT* kase);
void	PZLACON_(const MKL_INT* n, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* est, MKL_INT* kase);
void	pslacon_(const MKL_INT* n, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, float* est, MKL_INT* kase);
void	pdlacon_(const MKL_INT* n, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, MKL_INT* isgn, double* est, MKL_INT* kase);
void	pclacon_(const MKL_INT* n, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* est, MKL_INT* kase);
void	pzlacon_(const MKL_INT* n, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* est, MKL_INT* kase);

void	PSLACONSB(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const float* h44, const float* h33, const float* h43h34, float* buf, const MKL_INT* lwork);
void	PDLACONSB(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const double* h44, const double* h33, const double* h43h34, double* buf, const MKL_INT* lwork);
void	PSLACONSB_(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const float* h44, const float* h33, const float* h43h34, float* buf, const MKL_INT* lwork);
void	PDLACONSB_(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const double* h44, const double* h33, const double* h43h34, double* buf, const MKL_INT* lwork);
void	pslaconsb_(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const float* h44, const float* h33, const float* h43h34, float* buf, const MKL_INT* lwork);
void	pdlaconsb_(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const double* h44, const double* h33, const double* h43h34, double* buf, const MKL_INT* lwork);

void	PSLACP2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLACP2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLACP2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLACP2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PSLACP2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLACP2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLACP2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLACP2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pslacp2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlacp2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclacp2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlacp2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	PSLACP3(const MKL_INT* m, const MKL_INT* i, float* a, const MKL_INT* desca, float* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PDLACP3(const MKL_INT* m, const MKL_INT* i, double* a, const MKL_INT* desca, double* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PSLACP3_(const MKL_INT* m, const MKL_INT* i, float* a, const MKL_INT* desca, float* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PDLACP3_(const MKL_INT* m, const MKL_INT* i, double* a, const MKL_INT* desca, double* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pslacp3_(const MKL_INT* m, const MKL_INT* i, float* a, const MKL_INT* desca, float* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pdlacp3_(const MKL_INT* m, const MKL_INT* i, double* a, const MKL_INT* desca, double* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);

void	PSLACPY(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLACPY(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLACPY(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLACPY(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PSLACPY_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLACPY_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLACPY_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLACPY_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pslacpy_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlacpy_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclacpy_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlacpy_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	PSLAEVSWP(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* work, const MKL_INT* lwork);
void	PDLAEVSWP(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* work, const MKL_INT* lwork);
void	PCLAEVSWP(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* rwork, const MKL_INT* lrwork);
void	PZLAEVSWP(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* rwork, const MKL_INT* lrwork);
void	PSLAEVSWP_(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* work, const MKL_INT* lwork);
void	PDLAEVSWP_(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* work, const MKL_INT* lwork);
void	PCLAEVSWP_(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* rwork, const MKL_INT* lrwork);
void	PZLAEVSWP_(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* rwork, const MKL_INT* lrwork);
void	pslaevswp_(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* work, const MKL_INT* lwork);
void	pdlaevswp_(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* work, const MKL_INT* lwork);
void	pclaevswp_(const MKL_INT* n, const float* zin, const MKL_INT* ldzi, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, float* rwork, const MKL_INT* lrwork);
void	pzlaevswp_(const MKL_INT* n, const double* zin, const MKL_INT* ldzi, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, const MKL_INT* nvs, const MKL_INT* key, double* rwork, const MKL_INT* lrwork);

void	PSLAHRD(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* t, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	PDLAHRD(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* t, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	PCLAHRD(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	PZLAHRD(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);
void	PSLAHRD_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* t, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	PDLAHRD_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* t, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	PCLAHRD_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	PZLAHRD_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);
void	pslahrd_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* t, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, float* work);
void	pdlahrd_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* t, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, double* work);
void	pclahrd_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex8* work);
void	pzlahrd_(const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, MKL_Complex16* work);

void	PSLAIECT(const float* sigma, const MKL_INT* n, const float* d, MKL_INT* count);
void	PSLAIECT_(const float* sigma, const MKL_INT* n, const float* d, MKL_INT* count);
void	pslaiect_(const float* sigma, const MKL_INT* n, const float* d, MKL_INT* count);

float	PSLANGE(const char* norm, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANGE(const char* norm, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANGE(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANGE(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PSLANGE_(const char* norm, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANGE_(const char* norm, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANGE_(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANGE_(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pslange_(const char* norm, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlange_(const char* norm, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclange_(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlange_(const char* norm, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	PSLANHS(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANHS(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANHS(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANHS(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PSLANHS_(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANHS_(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANHS_(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANHS_(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pslanhs_(const char* norm, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlanhs_(const char* norm, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclanhs_(const char* norm, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlanhs_(const char* norm, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	PSLANSY(const char* norm, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANSY(const char* norm, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANSY(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANSY(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANHE(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANHE(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PSLANSY_(const char* norm, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANSY_(const char* norm, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANSY_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANSY_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANHE_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANHE_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pslansy_(const char* norm, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlansy_(const char* norm, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclansy_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlansy_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclanhe_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlanhe_(const char* norm, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

float	PSLANTR(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANTR(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANTR(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANTR(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PSLANTR_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PDLANTR_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	PCLANTR_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	PZLANTR_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pslantr_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pdlantr_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);
float	pclantr_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* work);
double	pzlantr_(const char* norm, const char* uplo, const char* diag, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* work);

void	PSLAPIV(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PDLAPIV(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PCLAPIV(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PZLAPIV(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PSLAPIV_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PDLAPIV_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PCLAPIV_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	PZLAPIV_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pslapiv_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pdlapiv_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pclapiv_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);
void	pzlapiv_(const char* direc, const char* rowcol, const char* pivroc, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip, MKL_INT* iwork);

void	PSLAQGE(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	PDLAQGE(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	PCLAQGE(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	PZLAQGE(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	PSLAQGE_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	PDLAQGE_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	PCLAQGE_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	PZLAQGE_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	pslaqge_(const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	pdlaqge_(const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);
void	pclaqge_(const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* r, const float* c, const float* rowcnd, const float* colcnd, const float* amax, char* equed);
void	pzlaqge_(const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* r, const double* c, const double* rowcnd, const double* colcnd, const double* amax, char* equed);

void	PSLAQSY(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	PDLAQSY(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	PCLAQSY(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	PZLAQSY(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	PSLAQSY_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	PDLAQSY_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	PCLAQSY_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	PZLAQSY_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	pslaqsy_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	pdlaqsy_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);
void	pclaqsy_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* sr, const float* sc, const float* scond, const float* amax, char* equed);
void	pzlaqsy_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* sr, const double* sc, const double* scond, const double* amax, char* equed);

void	PSLARED1D(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* bycol, float* byall, float* work, const MKL_INT* lwork);
void	PDLARED1D(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* bycol, double* byall, double* work, const MKL_INT* lwork);
void	PSLARED1D_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* bycol, float* byall, float* work, const MKL_INT* lwork);
void	PDLARED1D_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* bycol, double* byall, double* work, const MKL_INT* lwork);
void	pslared1d_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* bycol, float* byall, float* work, const MKL_INT* lwork);
void	pdlared1d_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* bycol, double* byall, double* work, const MKL_INT* lwork);

void	PSLARED2D(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* byrow, float* byall, float* work, const MKL_INT* lwork);
void	PDLARED2D(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* byrow, double* byall, double* work, const MKL_INT* lwork);
void	PSLARED2D_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* byrow, float* byall, float* work, const MKL_INT* lwork);
void	PDLARED2D_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* byrow, double* byall, double* work, const MKL_INT* lwork);
void	pslared2d_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const float* byrow, float* byall, float* work, const MKL_INT* lwork);
void	pdlared2d_(const MKL_INT* n, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desc, const double* byrow, double* byall, double* work, const MKL_INT* lwork);

void	PSLARF(const char* side, const MKL_INT* m, const MKL_INT* n, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARF(const char* side, const MKL_INT* m, const MKL_INT* n, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARF(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARF(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PSLARF_(const char* side, const MKL_INT* m, const MKL_INT* n, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARF_(const char* side, const MKL_INT* m, const MKL_INT* n, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARF_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARF_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pslarf_(const char* side, const MKL_INT* m, const MKL_INT* n, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarf_(const char* side, const MKL_INT* m, const MKL_INT* n, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarf_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarf_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PSLARFB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARFB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARFB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARFB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PSLARFB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARFB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARFB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARFB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pslarfb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarfb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarfb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarfb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PCLARFC(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARFC(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PCLARFC_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARFC_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pclarfc_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarfc_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PSLARFG(const MKL_INT* n, float* alpha, const MKL_INT* iax, const MKL_INT* jax, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* tau);
void	PDLARFG(const MKL_INT* n, double* alpha, const MKL_INT* iax, const MKL_INT* jax, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* tau);
void	PCLARFG(const MKL_INT* n, MKL_Complex8* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* tau);
void	PZLARFG(const MKL_INT* n, MKL_Complex16* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* tau);
void	PSLARFG_(const MKL_INT* n, float* alpha, const MKL_INT* iax, const MKL_INT* jax, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* tau);
void	PDLARFG_(const MKL_INT* n, double* alpha, const MKL_INT* iax, const MKL_INT* jax, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* tau);
void	PCLARFG_(const MKL_INT* n, MKL_Complex8* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* tau);
void	PZLARFG_(const MKL_INT* n, MKL_Complex16* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* tau);
void	pslarfg_(const MKL_INT* n, float* alpha, const MKL_INT* iax, const MKL_INT* jax, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* tau);
void	pdlarfg_(const MKL_INT* n, double* alpha, const MKL_INT* iax, const MKL_INT* jax, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* tau);
void	pclarfg_(const MKL_INT* n, MKL_Complex8* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* tau);
void	pzlarfg_(const MKL_INT* n, MKL_Complex16* alpha, const MKL_INT* iax, const MKL_INT* jax, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* tau);

void	PSLARFT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	PDLARFT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	PCLARFT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	PZLARFT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);
void	PSLARFT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	PDLARFT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	PCLARFT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	PZLARFT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);
void	pslarft_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	pdlarft_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	pclarft_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	pzlarft_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);

void	PSLARZ(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARZ(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARZ(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZ(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PSLARZ_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARZ_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARZ_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZ_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pslarz_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarz_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarz_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarz_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PSLARZB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARZB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARZB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZB(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PSLARZB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	PDLARZB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	PCLARZB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZB_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pslarzb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* t, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work);
void	pdlarzb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* t, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work);
void	pclarzb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* t, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarzb_(const char* side, const char* trans, const char* direct, const char* storev, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* t, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PCLARZC(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZC(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	PCLARZC_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	PZLARZC_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);
void	pclarzc_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work);
void	pzlarzc_(const char* side, const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work);

void	PSLARZT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	PDLARZT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	PCLARZT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	PZLARZT(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);
void	PSLARZT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	PDLARZT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	PCLARZT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	PZLARZT_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);
void	pslarzt_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, float* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const float* tau, float* t, float* work);
void	pdlarzt_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, double* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const double* tau, double* t, double* work);
void	pclarzt_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex8* tau, MKL_Complex8* t, MKL_Complex8* work);
void	pzlarzt_(const char* direct, const char* storev, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* v, const MKL_INT* iv, const MKL_INT* jv, const MKL_INT* descv, const MKL_Complex16* tau, MKL_Complex16* t, MKL_Complex16* work);

void	PSLASCL(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDLASCL(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCLASCL(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZLASCL(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSLASCL_(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDLASCL_(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCLASCL_(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZLASCL_(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pslascl_(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdlascl_(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pclascl_(const char* type, const float* cfrom, const float* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzlascl_(const char* type, const double* cfrom, const double* cto, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	PSLASET(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLASET(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLASET(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLASET(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PSLASET_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLASET_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLASET_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLASET_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pslaset_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlaset_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclaset_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlaset_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	PSLASMSUB(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, float* buf, const MKL_INT* lwork);
void	PDLASMSUB(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, double* buf, const MKL_INT* lwork);
void	PSLASMSUB_(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, float* buf, const MKL_INT* lwork);
void	PDLASMSUB_(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, double* buf, const MKL_INT* lwork);
void	pslasmsub_(const float* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, float* buf, const MKL_INT* lwork);
void	pdlasmsub_(const double* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, double* buf, const MKL_INT* lwork);

void	PSLASSQ(const MKL_INT* n, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	PDLASSQ(const MKL_INT* n, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	PCLASSQ(const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	PZLASSQ(const MKL_INT* n, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	PSLASSQ_(const MKL_INT* n, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	PDLASSQ_(const MKL_INT* n, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	PCLASSQ_(const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	PZLASSQ_(const MKL_INT* n, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	pslassq_(const MKL_INT* n, const float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	pdlassq_(const MKL_INT* n, const double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);
void	pclassq_(const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* scale, float* sumsq);
void	pzlassq_(const MKL_INT* n, const MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* scale, double* sumsq);

void	PSLASWP(const char* direc, const char* rowcol, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PDLASWP(const char* direc, const char* rowcol, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PCLASWP(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PZLASWP(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PSLASWP_(const char* direc, const char* rowcol, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PDLASWP_(const char* direc, const char* rowcol, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PCLASWP_(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	PZLASWP_(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pslaswp_(const char* direc, const char* rowcol, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pdlaswp_(const char* direc, const char* rowcol, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pclaswp_(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);
void	pzlaswp_(const char* direc, const char* rowcol, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv);

float	PSLATRA(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
double	PDLATRA(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLATRA(MKL_Complex8 *, const MKL_INT *n, const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);
void	PZLATRA(MKL_Complex16 *, const MKL_INT *n, const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);
float	PSLATRA_(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
double	PDLATRA_(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLATRA_(MKL_Complex8 *, const MKL_INT *n, const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);
void	PZLATRA_(MKL_Complex16 *, const MKL_INT *n, const MKL_Complex16 *a, const MKL_INT *ia,const  MKL_INT *ja, const MKL_INT *desca);
float	pslatra_(const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
double	pdlatra_(const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclatra_(MKL_Complex8 *, const MKL_INT *n, const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);
void	pzlatra_(MKL_Complex16 *, const MKL_INT *n, const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca);

void	PSLATRD(const char* uplo, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, float* work);
void	PDLATRD(const char* uplo, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, double* work);
void	PCLATRD(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex8* work);
void	PZLATRD(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex16* work);
void	PSLATRD_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, float* work);
void	PDLATRD_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, double* work);
void	PCLATRD_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex8* work);
void	PZLATRD_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex16* work);
void	pslatrd_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, float* work);
void	pdlatrd_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, double* work);
void	pclatrd_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex8* work);
void	pzlatrd_(const char* uplo, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* w, const MKL_INT* iw, const MKL_INT* jw, const MKL_INT* descw, MKL_Complex16* work);

void	PSLATRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, float* work);
void	PDLATRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, double* work);
void	PCLATRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_Complex8* work);
void	PZLATRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_Complex16* work);
void	PSLATRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, float* work);
void	PDLATRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, double* work);
void	PCLATRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_Complex8* work);
void	PZLATRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_Complex16* work);
void	pslatrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, float* work);
void	pdlatrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, double* work);
void	pclatrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_Complex8* work);
void	pzlatrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_Complex16* work);

void	PSLATRZ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work);
void	PDLATRZ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work);
void	PCLATRZ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work);
void	PZLATRZ(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work);
void	PSLATRZ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work);
void	PDLATRZ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work);
void	PCLATRZ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work);
void	PZLATRZ_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work);
void	pslatrz_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* tau, float* work);
void	pdlatrz_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* tau, double* work);
void	pclatrz_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* tau, MKL_Complex8* work);
void	pzlatrz_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* tau, MKL_Complex16* work);

void	PSLAUU2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLAUU2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLAUU2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLAUU2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PSLAUU2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLAUU2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLAUU2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLAUU2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pslauu2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlauu2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclauu2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlauu2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	PSLAUUM(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLAUUM(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLAUUM(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLAUUM(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PSLAUUM_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLAUUM_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLAUUM_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLAUUM_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pslauum_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlauum_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclauum_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlauum_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	PSLAWIL(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const float* a, const MKL_INT* desca, const float* h44, const float* h33, const float* h43h34, float* v);
void	PDLAWIL(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const double* a, const MKL_INT* desca, const double* h44, const double* h33, const double* h43h34, double* v);
void	PSLAWIL_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const float* a, const MKL_INT* desca, const float* h44, const float* h33, const float* h43h34, float* v);
void	PDLAWIL_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const double* a, const MKL_INT* desca, const double* h44, const double* h33, const double* h43h34, double* v);
void	pslawil_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const float* a, const MKL_INT* desca, const float* h44, const float* h33, const float* h43h34, float* v);
void	pdlawil_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const double* a, const MKL_INT* desca, const double* h44, const double* h33, const double* h43h34, double* v);

void	PSORG2L(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORG2L(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNG2L(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNG2L(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORG2L_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORG2L_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNG2L_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNG2L_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorg2l_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorg2l_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcung2l_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzung2l_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORG2R(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORG2R(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNG2R(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNG2R(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORG2R_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORG2R_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNG2R_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNG2R_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorg2r_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorg2r_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcung2r_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzung2r_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORGL2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGL2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGL2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGL2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGL2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGL2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGL2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGL2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorgl2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgl2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungl2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungl2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORGR2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGR2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGR2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGR2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORGR2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORGR2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNGR2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNGR2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorgr2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorgr2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcungr2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzungr2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORM2L(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORM2L(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNM2L(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNM2L(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORM2L_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORM2L_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNM2L_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNM2L_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorm2l_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorm2l_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunm2l_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunm2l_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORM2R(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORM2R(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNM2R(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNM2R(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORM2R_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORM2R_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNM2R_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNM2R_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorm2r_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorm2r_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunm2r_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunm2r_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORML2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORML2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNML2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNML2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORML2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORML2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNML2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNML2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psorml2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdorml2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunml2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunml2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSORMR2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMR2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMR2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMR2(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMR2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMR2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMR2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMR2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	psormr2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormr2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmr2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmr2_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPBTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, float* a, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, double* a, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpbtrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* bw, const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPTTRSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRSV(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSPTTRSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDPTTRSV_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCPTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZPTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pspttrsv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* d, float* e, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* descb, float* af, const MKL_INT* laf, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdpttrsv_(const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* d, double* e, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* descb, double* af, const MKL_INT* laf, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pcpttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex8* af, const MKL_INT* laf, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzpttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, double* d, MKL_Complex16* e, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* descb, MKL_Complex16* af, const MKL_INT* laf, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSPOTF2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTF2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTF2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTF2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSPOTF2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDPOTF2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCPOTF2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZPOTF2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pspotf2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdpotf2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pcpotf2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pzpotf2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	PSRSCL(const MKL_INT* n, const float* sa, float* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PDRSCL(const MKL_INT* n, const double* sa, double* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PCSRSCL(const MKL_INT* n, const float* sa, MKL_Complex8* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZDRSCL(const MKL_INT* n, const double* sa, MKL_Complex16* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PSRSCL_(const MKL_INT* n, const float* sa, float* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PDRSCL_(const MKL_INT* n, const double* sa, double* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PCSRSCL_(const MKL_INT* n, const float* sa, MKL_Complex8* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	PZDRSCL_(const MKL_INT* n, const double* sa, MKL_Complex16* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	psrscl_(const MKL_INT* n, const float* sa, float* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pdrscl_(const MKL_INT* n, const double* sa, double* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pcsrscl_(const MKL_INT* n, const float* sa, MKL_Complex8* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);
void	pzdrscl_(const MKL_INT* n, const double* sa, MKL_Complex16* sx, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx);

void	PSSYGS2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDSYGS2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCHEGS2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZHEGS2(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PSSYGS2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PDSYGS2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PCHEGS2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	PZHEGS2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pssygs2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pdsygs2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pchegs2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);
void	pzhegs2_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, MKL_INT* info);

void	PSSYTD2(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTD2(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCHETD2(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETD2(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYTD2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTD2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PCHETD2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETD2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pssytd2_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsytd2_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pchetd2_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhetd2_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSTRTI2(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDTRTI2(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCTRTI2(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZTRTI2(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PSTRTI2_(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PDTRTI2_(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PCTRTI2_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	PZTRTI2_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pstrti2_(const char* uplo, const char* diag, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pdtrti2_(const char* uplo, const char* diag, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pctrti2_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);
void	pztrti2_(const char* uplo, const char* diag, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_INT* info);

void	SLAMSH(float* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, float* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	DLAMSH(double* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, double* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);
void	SLAMSH_(float* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, float* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	DLAMSH_(double* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, double* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);
void	slamsh_(float* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, float* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	dlamsh_(double* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, double* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);

void	SLAREF(const char* type, float* a, const MKL_INT* lda, const MKL_INT* wantz, float* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const float* vecs, float* v2, float* v3, float* t1, float* t2, float* t3);
void	DLAREF(const char* type, double* a, const MKL_INT* lda, const MKL_INT* wantz, double* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const double* vecs, double* v2, double* v3, double* t1, double* t2, double* t3);
void	SLAREF_(const char* type, float* a, const MKL_INT* lda, const MKL_INT* wantz, float* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const float* vecs, float* v2, float* v3, float* t1, float* t2, float* t3);
void	DLAREF_(const char* type, double* a, const MKL_INT* lda, const MKL_INT* wantz, double* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const double* vecs, double* v2, double* v3, double* t1, double* t2, double* t3);
void	slaref_(const char* type, float* a, const MKL_INT* lda, const MKL_INT* wantz, float* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const float* vecs, float* v2, float* v3, float* t1, float* t2, float* t3);
void	dlaref_(const char* type, double* a, const MKL_INT* lda, const MKL_INT* wantz, double* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const double* vecs, double* v2, double* v3, double* t1, double* t2, double* t3);

void	SLASORTE(float* s, const MKL_INT* lds, const MKL_INT* j, float* out, MKL_INT* info);
void	DLASORTE(double* s, const MKL_INT* lds, const MKL_INT* j, double* out, MKL_INT* info);
void	SLASORTE_(float* s, const MKL_INT* lds, const MKL_INT* j, float* out, MKL_INT* info);
void	DLASORTE_(double* s, const MKL_INT* lds, const MKL_INT* j, double* out, MKL_INT* info);
void	slasorte_(float* s, const MKL_INT* lds, const MKL_INT* j, float* out, MKL_INT* info);
void	dlasorte_(double* s, const MKL_INT* lds, const MKL_INT* j, double* out, MKL_INT* info);

void	SLASRT2(const char* id, const MKL_INT* n, float* d, MKL_INT* key, MKL_INT* info);
void	DLASRT2(const char* id, const MKL_INT* n, double* d, MKL_INT* key, MKL_INT* info);
void	SLASRT2_(const char* id, const MKL_INT* n, float* d, MKL_INT* key, MKL_INT* info);
void	DLASRT2_(const char* id, const MKL_INT* n, double* d, MKL_INT* key, MKL_INT* info);
void	slasrt2_(const char* id, const MKL_INT* n, float* d, MKL_INT* key, MKL_INT* info);
void	dlasrt2_(const char* id, const MKL_INT* n, double* d, MKL_INT* key, MKL_INT* info);

void	SSTEIN2(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, const float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	DSTEIN2(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, const double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	SSTEIN2_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, const float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	DSTEIN2_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, const double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	sstein2_(const MKL_INT* n, const float* d, const float* e, const MKL_INT* m, const float* w, const MKL_INT* iblock, const MKL_INT* isplit, const float* orfac, float* z, const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);
void	dstein2_(const MKL_INT* n, const double* d, const double* e, const MKL_INT* m, const double* w, const MKL_INT* iblock, const MKL_INT* isplit, const double* orfac, double* z, const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info);

void	SDBTF2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	DDBTF2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	CDBTF2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	ZDBTF2(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);
void	SDBTF2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	DDBTF2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	CDBTF2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	ZDBTF2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);
void	sdbtf2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	ddbtf2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	cdbtf2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	zdbtf2_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);

void	SDBTRF(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	DDBTRF(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	CDBTRF(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	ZDBTRF(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);
void	SDBTRF_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	DDBTRF_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	CDBTRF_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	ZDBTRF_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);
void	sdbtrf_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, float* ab, const MKL_INT* ldab, MKL_INT* info);
void	ddbtrf_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* info);
void	cdbtrf_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info);
void	zdbtrf_(const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku, MKL_Complex16* ab, const MKL_INT* ldab, MKL_INT* info);

void	SDTTRF(const MKL_INT* n, float* dl, float* d, float* du, MKL_INT* info);
void	DDTTRF(const MKL_INT* n, double* dl, double* d, double* du, MKL_INT* info);
void	CDTTRF(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, MKL_INT* info);
void	ZDTTRF(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, MKL_INT* info);
void	SDTTRF_(const MKL_INT* n, float* dl, float* d, float* du, MKL_INT* info);
void	DDTTRF_(const MKL_INT* n, double* dl, double* d, double* du, MKL_INT* info);
void	CDTTRF_(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, MKL_INT* info);
void	ZDTTRF_(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, MKL_INT* info);
void	sdttrf_(const MKL_INT* n, float* dl, float* d, float* du, MKL_INT* info);
void	ddttrf_(const MKL_INT* n, double* dl, double* d, double* du, MKL_INT* info);
void	cdttrf_(const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d, MKL_Complex8* du, MKL_INT* info);
void	zdttrf_(const MKL_INT* n, MKL_Complex16* dl, MKL_Complex16* d, MKL_Complex16* du, MKL_INT* info);

void	SDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* dl, const float* d, const float* du, float* b, const MKL_INT* ldb, MKL_INT* info);
void	DDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* dl, const double* d, const double* du, double* b, const MKL_INT* ldb, MKL_INT* info);
void	CDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* dl, const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	ZDTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* dl, const MKL_Complex16* d, const MKL_Complex16* du, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);
void	SDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* dl, const float* d, const float* du, float* b, const MKL_INT* ldb, MKL_INT* info);
void	DDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* dl, const double* d, const double* du, double* b, const MKL_INT* ldb, MKL_INT* info);
void	CDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* dl, const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	ZDTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* dl, const MKL_Complex16* d, const MKL_Complex16* du, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);
void	sdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* dl, const float* d, const float* du, float* b, const MKL_INT* ldb, MKL_INT* info);
void	ddttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* dl, const double* d, const double* du, double* b, const MKL_INT* ldb, MKL_INT* info);
void	cdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* dl, const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	zdttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex16* dl, const MKL_Complex16* d, const MKL_Complex16* du, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);

void	SPTTRSV(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const float* e, float* b, const MKL_INT* ldb, MKL_INT* info);
void	DPTTRSV(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const double* e, double* b, const MKL_INT* ldb, MKL_INT* info);
void	CPTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const MKL_Complex8* e, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	ZPTTRSV(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const MKL_Complex16* e, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);
void	SPTTRSV_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const float* e, float* b, const MKL_INT* ldb, MKL_INT* info);
void	DPTTRSV_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const double* e, double* b, const MKL_INT* ldb, MKL_INT* info);
void	CPTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const MKL_Complex8* e, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	ZPTTRSV_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const MKL_Complex16* e, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);
void	spttrsv_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const float* e, float* b, const MKL_INT* ldb, MKL_INT* info);
void	dpttrsv_(const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const double* e, double* b, const MKL_INT* ldb, MKL_INT* info);
void	cpttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const float* d, const MKL_Complex8* e, MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info);
void	zpttrsv_(const char* uplo, const char* trans, const MKL_INT* n, const MKL_INT* nrhs, const double* d, const MKL_Complex16* e, MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info);

void	SSTEQR2(const char* compz, const MKL_INT* n, float* d, float* e, float* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	DSTEQR2(const char* compz, const MKL_INT* n, double* d, double* e, double* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);
void	SSTEQR2_(const char* compz, const MKL_INT* n, float* d, float* e, float* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	DSTEQR2_(const char* compz, const MKL_INT* n, double* d, double* e, double* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);
void	ssteqr2_(const char* compz, const MKL_INT* n, float* d, float* e, float* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	dsteqr2_(const char* compz, const MKL_INT* n, double* d, double* e, double* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);

void	PSLABAD(const MKL_INT* ictxt, float* small, float* large);
void	PDLABAD(const MKL_INT* ictxt, double* small, double* large);
void	PSLABAD_(const MKL_INT* ictxt, float* small, float* large);
void	PDLABAD_(const MKL_INT* ictxt, double* small, double* large);
void	pslabad_(const MKL_INT* ictxt, float* small, float* large);
void	pdlabad_(const MKL_INT* ictxt, double* small, double* large);

void	PSLACHKIEEE(MKL_INT* isieee, const float* rmax, const float* rmin);
void	PDLACHKIEEE(MKL_INT* isieee, const double* rmax, const double* rmin);
void	PSLACHKIEEE_(MKL_INT* isieee, const float* rmax, const float* rmin);
void	PDLACHKIEEE_(MKL_INT* isieee, const double* rmax, const double* rmin);
void	pslachkieee_(MKL_INT* isieee, const float* rmax, const float* rmin);
void	pdlachkieee_(MKL_INT* isieee, const double* rmax, const double* rmin);

float	PSLAMCH(const MKL_INT* ictxt, const char* cmach);
double	PDLAMCH(const MKL_INT* ictxt, const char* cmach);
float	PSLAMCH_(const MKL_INT* ictxt, const char* cmach);
double	PDLAMCH_(const MKL_INT* ictxt, const char* cmach);
float	pslamch_(const MKL_INT* ictxt, const char* cmach);
double	pdlamch_(const MKL_INT* ictxt, const char* cmach);

void	PSLASNBT(MKL_INT* ieflag);
void	PDLASNBT(MKL_INT* ieflag);
void	PSLASNBT_(MKL_INT* ieflag);
void	PDLASNBT_(MKL_INT* ieflag);
void	pslasnbt_(MKL_INT* ieflag);
void	pdlasnbt_(MKL_INT* ieflag);

void	PXERBLA(const MKL_INT* ictxt, const char* srname, const MKL_INT* info, MKL_INT srname_len);
void	PXERBLA_(const MKL_INT* ictxt, const char* srname, const MKL_INT* info, MKL_INT srname_len);
void	pxerbla_(const MKL_INT* ictxt, const char* srname, const MKL_INT* info, MKL_INT srname_len);

/* Declarations are added in oneMKL 11.2 Beta */

void	BDLAAPP(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, double* dtraf, double* work);
void	BDLAAPP_(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, double* dtraf, double* work);
void	bdlaapp_(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, double* dtraf, double* work);

void	BDLAEXC(const MKL_INT* n, double* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, double* dtraf, double* work, MKL_INT* info);
void	BDLAEXC_(const MKL_INT* n, double* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, double* dtraf, double* work, MKL_INT* info);
void	bdlaexc_(const MKL_INT* n, double* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, double* dtraf, double* work, MKL_INT* info);

void	BDTREXC(const MKL_INT* n, double* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, double* dtraf, double* work, MKL_INT* info);
void	BDTREXC_(const MKL_INT* n, double* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, double* dtraf, double* work, MKL_INT* info);
void	bdtrexc_(const MKL_INT* n, double* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, double* dtraf, double* work, MKL_INT* info);

void	BSLAAPP(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, float* dtraf, float* work);
void	BSLAAPP_(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, float* dtraf, float* work);
void	bslaapp_(const MKL_INT* iside, const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, const MKL_INT* nitraf, const MKL_INT* itraf, float* dtraf, float* work);

void	BSLAEXC(const MKL_INT* n, float* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, float* dtraf, float* work, MKL_INT* info);
void	BSLAEXC_(const MKL_INT* n, float* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, float* dtraf, float* work, MKL_INT* info);
void	bslaexc_(const MKL_INT* n, float* t, const MKL_INT* ldt, const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2, MKL_INT* itraf, float* dtraf, float* work, MKL_INT* info);

void	BSTREXC(const MKL_INT* n, float* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, float* dtraf, float* work, MKL_INT* info);
void	BSTREXC_(const MKL_INT* n, float* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, float* dtraf, float* work, MKL_INT* info);
void	bstrexc_(const MKL_INT* n, float* t, const MKL_INT* ldt, MKL_INT* ifst, MKL_INT* ilst, MKL_INT* nitraf, MKL_INT* itraf, MKL_INT* ndtraf, float* dtraf, float* work, MKL_INT* info);

void	DLAQR6(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* ldz, double* v, const MKL_INT* ldv, double* u, const MKL_INT* ldu, const MKL_INT* nv, double* wv, const MKL_INT* ldwv, const MKL_INT* nh, double* wh, const MKL_INT* ldwh);
void	DLAQR6_(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* ldz, double* v, const MKL_INT* ldv, double* u, const MKL_INT* ldu, const MKL_INT* nv, double* wv, const MKL_INT* ldwv, const MKL_INT* nh, double* wh, const MKL_INT* ldwh);
void	dlaqr6_(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* ldz, double* v, const MKL_INT* ldv, double* u, const MKL_INT* ldu, const MKL_INT* nv, double* wv, const MKL_INT* ldwv, const MKL_INT* nh, double* wh, const MKL_INT* ldwh);

void	DLAR1VA(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const double* lambda, const double* d, const double* l, const double* ld, const double* lld, const double* pivmin, const double* gaptol, double* z, const MKL_INT* wantnc, MKL_INT* negcnt, double* ztz, double* mingma, MKL_INT* r, MKL_INT* isuppz, double* nrminv, double* resid, double* rqcorr, double* work);
void	DLAR1VA_(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const double* lambda, const double* d, const double* l, const double* ld, const double* lld, const double* pivmin, const double* gaptol, double* z, const MKL_INT* wantnc, MKL_INT* negcnt, double* ztz, double* mingma, MKL_INT* r, MKL_INT* isuppz, double* nrminv, double* resid, double* rqcorr, double* work);
void	dlar1va_(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const double* lambda, const double* d, const double* l, const double* ld, const double* lld, const double* pivmin, const double* gaptol, double* z, const MKL_INT* wantnc, MKL_INT* negcnt, double* ztz, double* mingma, MKL_INT* r, MKL_INT* isuppz, double* nrminv, double* resid, double* rqcorr, double* work);

void	DLARRB2(const MKL_INT* n, const double* d, const double* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const double* rtol1, const double* rtol2, const MKL_INT* offset, double* w, double* wgap, double* werr, double* work, MKL_INT* iwork, const double* pivmin, const double* lgpvmn, const double* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	DLARRB2_(const MKL_INT* n, const double* d, const double* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const double* rtol1, const double* rtol2, const MKL_INT* offset, double* w, double* wgap, double* werr, double* work, MKL_INT* iwork, const double* pivmin, const double* lgpvmn, const double* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	dlarrb2_(const MKL_INT* n, const double* d, const double* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const double* rtol1, const double* rtol2, const MKL_INT* offset, double* w, double* wgap, double* werr, double* work, MKL_INT* iwork, const double* pivmin, const double* lgpvmn, const double* lgspdm, const MKL_INT* twist, MKL_INT* info);

void	DLARRD2(const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* gers, const double* reltol, const double* d, const double* e, const double* e2, const double* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, double* w, double* werr, double* wl, double* wu, MKL_INT* iblock, MKL_INT* indexw, double* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	DLARRD2_(const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* gers, const double* reltol, const double* d, const double* e, const double* e2, const double* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, double* w, double* werr, double* wl, double* wu, MKL_INT* iblock, MKL_INT* indexw, double* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	dlarrd2_(const char* range, const char* order, const MKL_INT* n, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, const double* gers, const double* reltol, const double* d, const double* e, const double* e2, const double* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, double* w, double* werr, double* wl, double* wu, MKL_INT* iblock, MKL_INT* indexw, double* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);

void	DLARRE2(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* pivmin, double* work, MKL_INT* iwork, MKL_INT* info);
void	DLARRE2_(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* pivmin, double* work, MKL_INT* iwork, MKL_INT* info);
void	dlarre2_(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* pivmin, double* work, MKL_INT* iwork, MKL_INT* info);

void	DLARRE2A(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* sdiam, double* pivmin, double* work, MKL_INT* iwork, const double* minrgp, MKL_INT* info);
void	DLARRE2A_(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* sdiam, double* pivmin, double* work, MKL_INT* iwork, const double* minrgp, MKL_INT* info);
void	dlarre2a_(const char* range, const MKL_INT* n, double* vl, double* vu, const MKL_INT* il, const MKL_INT* iu, double* d, double* e, double* e2, const double* rtol1, const double* rtol2, const double* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, double* w, double* werr, double* wgap, MKL_INT* iblock, MKL_INT* indexw, double* gers, double* sdiam, double* pivmin, double* work, MKL_INT* iwork, const double* minrgp, MKL_INT* info);

void	DLARRF2(const MKL_INT* n, const double* d, const double* l, const double* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const double* w, double* wgap, const double* werr, const MKL_INT* trymid, const double* spdiam, const double* clgapl, const double* clgapr, const double* pivmin, double* sigma, double* dplus, double* lplus, double* work, MKL_INT* info);
void	DLARRF2_(const MKL_INT* n, const double* d, const double* l, const double* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const double* w, double* wgap, const double* werr, const MKL_INT* trymid, const double* spdiam, const double* clgapl, const double* clgapr, const double* pivmin, double* sigma, double* dplus, double* lplus, double* work, MKL_INT* info);
void	dlarrf2_(const MKL_INT* n, const double* d, const double* l, const double* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const double* w, double* wgap, const double* werr, const MKL_INT* trymid, const double* spdiam, const double* clgapl, const double* clgapr, const double* pivmin, double* sigma, double* dplus, double* lplus, double* work, MKL_INT* info);

void	DLARRV2(const MKL_INT* n, const double* vl, const double* vu, double* d, double* l, const double* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const double* minrgp, const double* rtol1, const double* rtol2, double* w, double* werr, double* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const double* gers, const double* sdiam, double* z, const MKL_INT* ldz, MKL_INT* isuppz, double* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	DLARRV2_(const MKL_INT* n, const double* vl, const double* vu, double* d, double* l, const double* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const double* minrgp, const double* rtol1, const double* rtol2, double* w, double* werr, double* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const double* gers, const double* sdiam, double* z, const MKL_INT* ldz, MKL_INT* isuppz, double* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	dlarrv2_(const MKL_INT* n, const double* vl, const double* vu, double* d, double* l, const double* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const double* minrgp, const double* rtol1, const double* rtol2, double* w, double* werr, double* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const double* gers, const double* sdiam, double* z, const MKL_INT* ldz, MKL_INT* isuppz, double* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	DSTEGR2(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	DSTEGR2_(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	dstegr2_(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);

void	DSTEGR2A(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, double* pivmin, double* scale, double* wl, double* wu, MKL_INT* info);
void	DSTEGR2A_(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, double* pivmin, double* scale, double* wl, double* wu, MKL_INT* info);
void	dstegr2a_(const char* jobz, const char* range, const MKL_INT* n, double* d, double* e, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, double* pivmin, double* scale, double* wl, double* wu, MKL_INT* info);

void	DSTEGR2B(const char* jobz, const MKL_INT* n, double* d, double* e, const MKL_INT* m, const double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const double* pivmin, const double* scale, const double* wl, const double* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	DSTEGR2B_(const char* jobz, const MKL_INT* n, double* d, double* e, const MKL_INT* m, const double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const double* pivmin, const double* scale, const double* wl, const double* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	dstegr2b_(const char* jobz, const MKL_INT* n, double* d, double* e, const MKL_INT* m, const double* w, double* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const double* pivmin, const double* scale, const double* wl, const double* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	PCHEEVR(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PCHEEVR_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pcheevr_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, MKL_Complex8* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PCROT(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* c, const MKL_Complex8* s);
void	PCROT_(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* c, const MKL_Complex8* s);
void	pcrot_(const MKL_INT* n, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex8* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* c, const MKL_Complex8* s);

void	PDGEBAL(const char* job, const MKL_INT* n, double* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void	PDGEBAL_(const char* job, const MKL_INT* n, double* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void	pdgebal_(const char* job, const MKL_INT* n, double* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);

void	PDLAMVE(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* dwork);
void	PDLAMVE_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* dwork);
void	pdlamve_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* dwork);

void	PDLAQR0(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	PDLAQR0_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	pdlaqr0_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);

void	PDLAQR1(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PDLAQR1_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pdlaqr1_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	PDLAQR2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* wr, double* wi, double* work, const MKL_INT* lwork);
void	PDLAQR2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* wr, double* wi, double* work, const MKL_INT* lwork);
void	pdlaqr2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* wr, double* wi, double* work, const MKL_INT* lwork);

void	PDLAQR3(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* v, const MKL_INT* descv, const MKL_INT* nh, double* t, const MKL_INT* desct, const MKL_INT* nv, double* wv, const MKL_INT* descw, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	PDLAQR3_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* v, const MKL_INT* descv, const MKL_INT* nh, double* t, const MKL_INT* desct, const MKL_INT* nv, double* wv, const MKL_INT* descw, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	pdlaqr3_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, double* sr, double* si, double* v, const MKL_INT* descv, const MKL_INT* nh, double* t, const MKL_INT* desct, const MKL_INT* nv, double* wv, const MKL_INT* descw, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);

void	PDLAQR4(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PDLAQR4_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pdlaqr4_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* a, const MKL_INT* desca, double* wr, double* wi, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* t, const MKL_INT* ldt, double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PDLAQR5(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	PDLAQR5_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	pdlaqr5_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const double* sr, const double* si, double* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);

void	PDROT(const MKL_INT* n, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* cs, const double* sn, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PDROT_(const MKL_INT* n, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* cs, const double* sn, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pdrot_(const MKL_INT* n, double* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, double* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* cs, const double* sn, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PDSYEVR(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSYEVR_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdsyevr_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, double* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PDTRORD(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRORD_(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrord_(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PDTRSEN(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* s, double* sep, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDTRSEN_(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* s, double* sep, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdtrsen_(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, double* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* wr, double* wi, MKL_INT* m, double* s, double* sep, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PMPCOL(const MKL_INT* myproc, const MKL_INT* nprocs, const MKL_INT* iil, const MKL_INT* needil, const MKL_INT* neediu, const MKL_INT* pmyils, const MKL_INT* pmyius, MKL_INT* colbrt, MKL_INT* frstcl, MKL_INT* lastcl);
void	PMPCOL_(const MKL_INT* myproc, const MKL_INT* nprocs, const MKL_INT* iil, const MKL_INT* needil, const MKL_INT* neediu, const MKL_INT* pmyils, const MKL_INT* pmyius, MKL_INT* colbrt, MKL_INT* frstcl, MKL_INT* lastcl);
void	pmpcol_(const MKL_INT* myproc, const MKL_INT* nprocs, const MKL_INT* iil, const MKL_INT* needil, const MKL_INT* neediu, const MKL_INT* pmyils, const MKL_INT* pmyius, MKL_INT* colbrt, MKL_INT* frstcl, MKL_INT* lastcl);

void	PMPIM2(const MKL_INT* il, const MKL_INT* iu, const MKL_INT* nprocs, MKL_INT* pmyils, MKL_INT* pmyius);
void	PMPIM2_(const MKL_INT* il, const MKL_INT* iu, const MKL_INT* nprocs, MKL_INT* pmyils, MKL_INT* pmyius);
void	pmpim2_(const MKL_INT* il, const MKL_INT* iu, const MKL_INT* nprocs, MKL_INT* pmyils, MKL_INT* pmyius);

void	PSGEBAL(const char* job, const MKL_INT* n, float* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void	PSGEBAL_(const char* job, const MKL_INT* n, float* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void	psgebal_(const char* job, const MKL_INT* n, float* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);

void	PSLAMVE(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* dwork);
void	PSLAMVE_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* dwork);
void	pslamve_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* dwork);

void	PSLAQR0(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	PSLAQR0_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);
void	pslaqr0_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info, const MKL_INT* reclevel);

void	PSLAQR1(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PSLAQR1_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pslaqr1_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	PSLAQR2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* wr, float* wi, float* work, const MKL_INT* lwork);
void	PSLAQR2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* wr, float* wi, float* work, const MKL_INT* lwork);
void	pslaqr2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* a, const MKL_INT* desca, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* wr, float* wi, float* work, const MKL_INT* lwork);

void	PSLAQR3(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* v, const MKL_INT* descv, const MKL_INT* nh, float* t, const MKL_INT* desct, const MKL_INT* nv, float* wv, const MKL_INT* descw, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	PSLAQR3_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* v, const MKL_INT* descv, const MKL_INT* nh, float* t, const MKL_INT* desct, const MKL_INT* nv, float* wv, const MKL_INT* descw, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);
void	pslaqr3_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, MKL_INT* ns, MKL_INT* nd, float* sr, float* si, float* v, const MKL_INT* descv, const MKL_INT* nh, float* t, const MKL_INT* desct, const MKL_INT* nv, float* wv, const MKL_INT* descw, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* reclevel);

void	PSLAQR4(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PSLAQR4_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pslaqr4_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* a, const MKL_INT* desca, float* wr, float* wi, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* t, const MKL_INT* ldt, float* v, const MKL_INT* ldv, float* work, const MKL_INT* lwork, MKL_INT* info);

void	PSLAQR5(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	PSLAQR5_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);
void	pslaqr5_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* desch, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork);

void	PSROT(const MKL_INT* n, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* cs, const float* sn, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PSROT_(const MKL_INT* n, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* cs, const float* sn, float* work, const MKL_INT* lwork, MKL_INT* info);
void	psrot_(const MKL_INT* n, float* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, float* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const float* cs, const float* sn, float* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYEVR(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSSYEVR_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pssyevr_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, float* w, float* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PSTRORD(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSTRORD_(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pstrord_(const char* compq, MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PSTRSEN(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* s, float* sep, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSTRSEN_(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* s, float* sep, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pstrsen_(const char* job, const char* compq, const MKL_INT* select, const MKL_INT* para, const MKL_INT* n, float* t, const MKL_INT* it, const MKL_INT* jt, const MKL_INT* desct, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* wr, float* wi, MKL_INT* m, float* s, float* sep, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PZHEEVR(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PZHEEVR_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pzheevr_(const char* jobz, const char* range, const char* uplo, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* vl, const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, MKL_INT* nz, double* w, MKL_Complex16* z, const MKL_INT* iz, const MKL_INT* jz, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PZROT(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* c, const MKL_Complex16* s);
void	PZROT_(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* c, const MKL_Complex16* s);
void	pzrot_(const MKL_INT* n, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, const MKL_INT* incx, MKL_Complex16* y, const MKL_INT* iy, const MKL_INT* jy, const MKL_INT* descy, const MKL_INT* incy, const double* c, const MKL_Complex16* s);

void	SLAQR6(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* ldz, float* v, const MKL_INT* ldv, float* u, const MKL_INT* ldu, const MKL_INT* nv, float* wv, const MKL_INT* ldwv, const MKL_INT* nh, float* wh, const MKL_INT* ldwh);
void	SLAQR6_(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* ldz, float* v, const MKL_INT* ldv, float* u, const MKL_INT* ldu, const MKL_INT* nv, float* wv, const MKL_INT* ldwv, const MKL_INT* nh, float* wh, const MKL_INT* ldwh);
void	slaqr6_(const char* job, const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nshfts, const float* sr, const float* si, float* h, const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz, float* z, const MKL_INT* ldz, float* v, const MKL_INT* ldv, float* u, const MKL_INT* ldu, const MKL_INT* nv, float* wv, const MKL_INT* ldwv, const MKL_INT* nh, float* wh, const MKL_INT* ldwh);

void	SLAR1VA(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const float* lambda, const float* d, const float* l, const float* ld, const float* lld, const float* pivmin, const float* gaptol, float* z, const MKL_INT* wantnc, MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r, MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr, float* work);
void	SLAR1VA_(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const float* lambda, const float* d, const float* l, const float* ld, const float* lld, const float* pivmin, const float* gaptol, float* z, const MKL_INT* wantnc, MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r, MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr, float* work);
void	slar1va_(const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn, const float* lambda, const float* d, const float* l, const float* ld, const float* lld, const float* pivmin, const float* gaptol, float* z, const MKL_INT* wantnc, MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r, MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr, float* work);

void	SLARRB2(const MKL_INT* n, const float* d, const float* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const float* rtol1, const float* rtol2, const MKL_INT* offset, float* w, float* wgap, float* werr, float* work, MKL_INT* iwork, const float* pivmin, const float* lgpvmn, const float* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	SLARRB2_(const MKL_INT* n, const float* d, const float* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const float* rtol1, const float* rtol2, const MKL_INT* offset, float* w, float* wgap, float* werr, float* work, MKL_INT* iwork, const float* pivmin, const float* lgpvmn, const float* lgspdm, const MKL_INT* twist, MKL_INT* info);
void	slarrb2_(const MKL_INT* n, const float* d, const float* lld, const MKL_INT* ifirst, const MKL_INT* ilast, const float* rtol1, const float* rtol2, const MKL_INT* offset, float* w, float* wgap, float* werr, float* work, MKL_INT* iwork, const float* pivmin, const float* lgpvmn, const float* lgspdm, const MKL_INT* twist, MKL_INT* info);

void	SLARRD2(const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* gers, const float* reltol, const float* d, const float* e, const float* e2, const float* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, float* w, float* werr, float* wl, float* wu, MKL_INT* iblock, MKL_INT* indexw, float* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	SLARRD2_(const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* gers, const float* reltol, const float* d, const float* e, const float* e2, const float* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, float* w, float* werr, float* wl, float* wu, MKL_INT* iblock, MKL_INT* indexw, float* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);
void	slarrd2_(const char* range, const char* order, const MKL_INT* n, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, const float* gers, const float* reltol, const float* d, const float* e, const float* e2, const float* pivmin, const MKL_INT* nsplit, const MKL_INT* isplit, MKL_INT* m, float* w, float* werr, float* wl, float* wu, MKL_INT* iblock, MKL_INT* indexw, float* work, MKL_INT* iwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* info);

void	SLARRE2(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* pivmin, float* work, MKL_INT* iwork, MKL_INT* info);
void	SLARRE2_(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* pivmin, float* work, MKL_INT* iwork, MKL_INT* info);
void	slarre2_(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* pivmin, float* work, MKL_INT* iwork, MKL_INT* info);

void	SLARRE2A(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* sdiam, float* pivmin, float* work, MKL_INT* iwork, const float* minrgp, MKL_INT* info);
void	SLARRE2A_(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* sdiam, float* pivmin, float* work, MKL_INT* iwork, const float* minrgp, MKL_INT* info);
void	slarre2a_(const char* range, const MKL_INT* n, float* vl, float* vu, const MKL_INT* il, const MKL_INT* iu, float* d, float* e, float* e2, const float* rtol1, const float* rtol2, const float* spltol, MKL_INT* nsplit, MKL_INT* isplit, MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, float* w, float* werr, float* wgap, MKL_INT* iblock, MKL_INT* indexw, float* gers, float* sdiam, float* pivmin, float* work, MKL_INT* iwork, const float* minrgp, MKL_INT* info);

void	SLARRF2(const MKL_INT* n, const float* d, const float* l, const float* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const float* w, float* wgap, const float* werr, const MKL_INT* trymid, const float* spdiam, const float* clgapl, const float* clgapr, const float* pivmin, float* sigma, float* dplus, float* lplus, float* work, MKL_INT* info);
void	SLARRF2_(const MKL_INT* n, const float* d, const float* l, const float* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const float* w, float* wgap, const float* werr, const MKL_INT* trymid, const float* spdiam, const float* clgapl, const float* clgapr, const float* pivmin, float* sigma, float* dplus, float* lplus, float* work, MKL_INT* info);
void	slarrf2_(const MKL_INT* n, const float* d, const float* l, const float* ld, const MKL_INT* clstrt, const MKL_INT* clend, const MKL_INT* clmid1, const MKL_INT* clmid2, const float* w, float* wgap, const float* werr, const MKL_INT* trymid, const float* spdiam, const float* clgapl, const float* clgapr, const float* pivmin, float* sigma, float* dplus, float* lplus, float* work, MKL_INT* info);

void	SLARRV2(const MKL_INT* n, const float* vl, const float* vu, float* d, float* l, const float* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const float* minrgp, const float* rtol1, const float* rtol2, float* w, float* werr, float* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const float* gers, const float* sdiam, float* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	SLARRV2_(const MKL_INT* n, const float* vl, const float* vu, float* d, float* l, const float* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const float* minrgp, const float* rtol1, const float* rtol2, float* w, float* werr, float* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const float* gers, const float* sdiam, float* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	slarrv2_(const MKL_INT* n, const float* vl, const float* vu, float* d, float* l, const float* pivmin, const MKL_INT* isplit, const MKL_INT* m, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, const float* minrgp, const float* rtol1, const float* rtol2, float* w, float* werr, float* wgap, const MKL_INT* iblock, const MKL_INT* indexw, const float* gers, const float* sdiam, float* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

void	SSTEGR2(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	SSTEGR2_(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);
void	sstegr2_(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, const MKL_INT* zoffset, MKL_INT* info);

void	SSTEGR2A(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, float* pivmin, float* scale, float* wl, float* wu, MKL_INT* info);
void	SSTEGR2A_(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, float* pivmin, float* scale, float* wl, float* wu, MKL_INT* info);
void	sstegr2a_(const char* jobz, const char* range, const MKL_INT* n, float* d, float* e, const float* vl, const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* m, float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* inderr, MKL_INT* nsplit, float* pivmin, float* scale, float* wl, float* wu, MKL_INT* info);

void	SSTEGR2B(const char* jobz, const MKL_INT* n, float* d, float* e, const MKL_INT* m, const float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const float* pivmin, const float* scale, const float* wl, const float* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	SSTEGR2B_(const char* jobz, const MKL_INT* n, float* d, float* e, const MKL_INT* m, const float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const float* pivmin, const float* scale, const float* wl, const float* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);
void	sstegr2b_(const char* jobz, const MKL_INT* n, float* d, float* e, const MKL_INT* m, const float* w, float* z, const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, const MKL_INT* dol, const MKL_INT* dou, MKL_INT* needil, MKL_INT* neediu, MKL_INT* indwlc, const float* pivmin, const float* scale, const float* wl, const float* wu, MKL_INT* vstart, MKL_INT* finish, MKL_INT* maxcls, MKL_INT* ndepth, MKL_INT* parity, const MKL_INT* zoffset, MKL_INT* info);

/* Declarations added oneMKL 11.3.2 */

void	PCHENGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHENGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCHENGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHENGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pchengst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhengst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PCHENTRD(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZHENTRD(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PCHENTRD_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	PZHENTRD_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pchentrd_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info);
void	pzhentrd_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info);

void	PCHETTRD(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETTRD(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCHETTRD_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZHETTRD_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pchettrd_(const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzhettrd_(const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void	PSHSEQR(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDHSEQR(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSHSEQR_(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDHSEQR_(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pshseqr_(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, float* h, const MKL_INT* desch, float* wr, float* wi, float* z, const MKL_INT* descz, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdhseqr_(const char* job, const char* compz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, double* h, const MKL_INT* desch, double* wr, double* wi, double* z, const MKL_INT* descz, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PCLACONSB(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* buf, const MKL_INT* lwork);
void	PZLACONSB(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* buf, const MKL_INT* lwork);
void	PCLACONSB_(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* buf, const MKL_INT* lwork);
void	PZLACONSB_(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* buf, const MKL_INT* lwork);
void	pclaconsb_(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* buf, const MKL_INT* lwork);
void	pzlaconsb_(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* m, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* buf, const MKL_INT* lwork);

void	PCLACP3(const MKL_INT* m, const MKL_INT* i, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PZLACP3(const MKL_INT* m, const MKL_INT* i, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PCLACP3_(const MKL_INT* m, const MKL_INT* i, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	PZLACP3_(const MKL_INT* m, const MKL_INT* i, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pclacp3_(const MKL_INT* m, const MKL_INT* i, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);
void	pzlacp3_(const MKL_INT* m, const MKL_INT* i, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ldb, const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* rev);

void	PSLAED0(const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* iwork, MKL_INT* info);
void	PDLAED0(const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* iwork, MKL_INT* info);
void	PSLAED0_(const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* iwork, MKL_INT* info);
void	PDLAED0_(const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* iwork, MKL_INT* info);
void	pslaed0_(const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* iwork, MKL_INT* info);
void	pdlaed0_(const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* iwork, MKL_INT* info);

void	PSLAED1(const MKL_INT* n, const MKL_INT* n1, float* d, const MKL_INT* id, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const float* rho, float* work, MKL_INT* iwork, MKL_INT* info);
void	PDLAED1(const MKL_INT* n, const MKL_INT* n1, double* d, const MKL_INT* id, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const double* rho, double* work, MKL_INT* iwork, MKL_INT* info);
void	PSLAED1_(const MKL_INT* n, const MKL_INT* n1, float* d, const MKL_INT* id, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const float* rho, float* work, MKL_INT* iwork, MKL_INT* info);
void	PDLAED1_(const MKL_INT* n, const MKL_INT* n1, double* d, const MKL_INT* id, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const double* rho, double* work, MKL_INT* iwork, MKL_INT* info);
void	pslaed1_(const MKL_INT* n, const MKL_INT* n1, float* d, const MKL_INT* id, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const float* rho, float* work, MKL_INT* iwork, MKL_INT* info);
void	pdlaed1_(const MKL_INT* n, const MKL_INT* n1, double* d, const MKL_INT* id, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, const double* rho, double* work, MKL_INT* iwork, MKL_INT* info);

void	PSLAED2(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* q, const MKL_INT* ldq, float* rho, const float* z, float* w, float* dlamda, float* q2, const MKL_INT* ldq2, float* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	PDLAED2(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* q, const MKL_INT* ldq, double* rho, const double* z, double* w, double* dlamda, double* q2, const MKL_INT* ldq2, double* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	PSLAED2_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* q, const MKL_INT* ldq, float* rho, const float* z, float* w, float* dlamda, float* q2, const MKL_INT* ldq2, float* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	PDLAED2_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* q, const MKL_INT* ldq, double* rho, const double* z, double* w, double* dlamda, double* q2, const MKL_INT* ldq2, double* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	pslaed2_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* q, const MKL_INT* ldq, float* rho, const float* z, float* w, float* dlamda, float* q2, const MKL_INT* ldq2, float* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);
void	pdlaed2_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* q, const MKL_INT* ldq, double* rho, const double* z, double* w, double* dlamda, double* q2, const MKL_INT* ldq2, double* qbuf, MKL_INT* ctot, MKL_INT* psm, const MKL_INT* npcol, MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* indcol, MKL_INT* coltyp, MKL_INT* nn, MKL_INT* nn1, MKL_INT* nn2, MKL_INT* ib1, MKL_INT* ib2);

void	PSLAED3(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* rho, float* dlamda, float* w, const float* z, float* u, const MKL_INT* ldu, float* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	PDLAED3(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* rho, double* dlamda, double* w, const double* z, double* u, const MKL_INT* ldu, double* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	PSLAED3_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* rho, float* dlamda, float* w, const float* z, float* u, const MKL_INT* ldu, float* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	PDLAED3_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* rho, double* dlamda, double* w, const double* z, double* u, const MKL_INT* ldu, double* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	pslaed3_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, float* d, const MKL_INT* drow, const MKL_INT* dcol, float* rho, float* dlamda, float* w, const float* z, float* u, const MKL_INT* ldu, float* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);
void	pdlaed3_(const MKL_INT* ictxt, MKL_INT* k, const MKL_INT* n, const MKL_INT* nb, double* d, const MKL_INT* drow, const MKL_INT* dcol, double* rho, double* dlamda, double* w, const double* z, double* u, const MKL_INT* ldu, double* buf, MKL_INT* indx, MKL_INT* indcol, MKL_INT* indrow, MKL_INT* indxr, MKL_INT* indxc, MKL_INT* ctot, const MKL_INT* npcol, MKL_INT* info);

void	PSLAEDZ(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, float* z, float* work);
void	PDLAEDZ(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, double* z, double* work);
void	PSLAEDZ_(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, float* z, float* work);
void	PDLAEDZ_(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, double* z, double* work);
void	pslaedz_(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, float* z, float* work);
void	pdlaedz_(const MKL_INT* n, const MKL_INT* n1, const MKL_INT* id, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* ldq, const MKL_INT* descq, double* z, double* work);

void	PCLAHQR(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PZLAHQR(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PCLAHQR_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	PZLAHQR_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pclahqr_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* desca, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* descz, MKL_Complex8* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);
void	pzlahqr_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* desca, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* descz, MKL_Complex16* work, const MKL_INT* lwork, const MKL_INT* iwork, const MKL_INT* ilwork, MKL_INT* info);

void	CLAHQR2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* info);
void	ZLAHQR2(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* h, const MKL_INT* ldh, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* ldz, MKL_INT* info);
void	CLAHQR2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* info);
void	ZLAHQR2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* h, const MKL_INT* ldh, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* ldz, MKL_INT* info);
void	clahqr2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* info);
void	zlahqr2_(const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex16* h, const MKL_INT* ldh, MKL_Complex16* w, const MKL_INT* iloz, const MKL_INT* ihiz, MKL_Complex16* z, const MKL_INT* ldz, MKL_INT* info);

void	PDLAIECTB(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);
void	PDLAIECTB_(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);
void	pdlaiectb_(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);

void	PDLAIECTL(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);
void	PDLAIECTL_(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);
void	pdlaiectl_(const double* sigma, const MKL_INT* n, const double* d, MKL_INT* count);

void	SLAMOV(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const float* A, const MKL_INT* LDA, float* B, const MKL_INT* LDB);
void	DLAMOV(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const double* A, const MKL_INT* LDA, double* B, const MKL_INT* LDB);
void	CLAMOV(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex8* A, const MKL_INT* LDA, MKL_Complex8* B, const MKL_INT* LDB);
void	ZLAMOV(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex16* A, const MKL_INT* LDA, MKL_Complex16* B, const MKL_INT* LDB);
void	SLAMOV_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const float* A, const MKL_INT* LDA, float* B, const MKL_INT* LDB);
void	DLAMOV_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const double* A, const MKL_INT* LDA, double* B, const MKL_INT* LDB);
void	CLAMOV_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex8* A, const MKL_INT* LDA, MKL_Complex8* B, const MKL_INT* LDB);
void	ZLAMOV_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex16* A, const MKL_INT* LDA, MKL_Complex16* B, const MKL_INT* LDB);
void	slamov_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const float* A, const MKL_INT* LDA, float* B, const MKL_INT* LDB);
void	dlamov_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const double* A, const MKL_INT* LDA, double* B, const MKL_INT* LDB);
void	clamov_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex8* A, const MKL_INT* LDA, MKL_Complex8* B, const MKL_INT* LDB);
void	zlamov_(const char* UPLO, const MKL_INT* M, const MKL_INT* N, const MKL_Complex16* A, const MKL_INT* LDA, MKL_Complex16* B, const MKL_INT* LDB);

void	PSLAMR1D(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLAMR1D(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLAMR1D(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLAMR1D(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PSLAMR1D_(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PDLAMR1D_(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PCLAMR1D_(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	PZLAMR1D_(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pslamr1d_(const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pdlamr1d_(const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pclamr1d_(const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);
void	pzlamr1d_(const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb);

void	CLAMSH(MKL_Complex8* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	ZLAMSH(MKL_Complex16* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex16* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);
void	CLAMSH_(MKL_Complex8* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	ZLAMSH_(MKL_Complex16* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex16* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);
void	clamsh_(MKL_Complex8* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* n, const float* ulp);
void	zlamsh_(MKL_Complex16* s, const MKL_INT* lds, MKL_INT* nbulge, const MKL_INT* jblk, MKL_Complex16* h, const MKL_INT* ldh, const MKL_INT* n, const double* ulp);

void	CLANV2(MKL_Complex8* a, MKL_Complex8* b, MKL_Complex8* c, MKL_Complex8* d, MKL_Complex8* rt1, MKL_Complex8* rt2, float* cs, MKL_Complex8* sn);
void	ZLANV2(MKL_Complex16* a, MKL_Complex16* b, MKL_Complex16* c, MKL_Complex16* d, MKL_Complex16* rt1, MKL_Complex16* rt2, double* cs, MKL_Complex16* sn);
void	CLANV2_(MKL_Complex8* a, MKL_Complex8* b, MKL_Complex8* c, MKL_Complex8* d, MKL_Complex8* rt1, MKL_Complex8* rt2, float* cs, MKL_Complex8* sn);
void	ZLANV2_(MKL_Complex16* a, MKL_Complex16* b, MKL_Complex16* c, MKL_Complex16* d, MKL_Complex16* rt1, MKL_Complex16* rt2, double* cs, MKL_Complex16* sn);
void	clanv2_(MKL_Complex8* a, MKL_Complex8* b, MKL_Complex8* c, MKL_Complex8* d, MKL_Complex8* rt1, MKL_Complex8* rt2, float* cs, MKL_Complex8* sn);
void	zlanv2_(MKL_Complex16* a, MKL_Complex16* b, MKL_Complex16* c, MKL_Complex16* d, MKL_Complex16* rt1, MKL_Complex16* rt2, double* cs, MKL_Complex16* sn);

void	SLAPST(const char* id, const MKL_INT* n, const float* d, MKL_INT* indx, MKL_INT* info);
void	DLAPST(const char* id, const MKL_INT* n, const double* d, MKL_INT* indx, MKL_INT* info);
void	SLAPST_(const char* id, const MKL_INT* n, const float* d, MKL_INT* indx, MKL_INT* info);
void	DLAPST_(const char* id, const MKL_INT* n, const double* d, MKL_INT* indx, MKL_INT* info);
void	slapst_(const char* id, const MKL_INT* n, const float* d, MKL_INT* indx, MKL_INT* info);
void	dlapst_(const char* id, const MKL_INT* n, const double* d, MKL_INT* indx, MKL_INT* info);

void	PSLAPV2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PDLAPV2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PCLAPV2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PZLAPV2(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PSLAPV2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PDLAPV2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PCLAPV2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	PZLAPV2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pslapv2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pdlapv2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pclapv2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);
void	pzlapv2_(const char* direc, const char* rowcol, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_INT* ipiv, const MKL_INT* ip, const MKL_INT* jp, const MKL_INT* descip);

void	CLAREF(const char* type, MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex8* vecs, MKL_Complex8* v2, MKL_Complex8* v3, MKL_Complex8* t1, MKL_Complex8* t2, MKL_Complex8* t3);
void	ZLAREF(const char* type, MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex16* vecs, MKL_Complex16* v2, MKL_Complex16* v3, MKL_Complex16* t1, MKL_Complex16* t2, MKL_Complex16* t3);
void	CLAREF_(const char* type, MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex8* vecs, MKL_Complex8* v2, MKL_Complex8* v3, MKL_Complex8* t1, MKL_Complex8* t2, MKL_Complex8* t3);
void	ZLAREF_(const char* type, MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex16* vecs, MKL_Complex16* v2, MKL_Complex16* v3, MKL_Complex16* t1, MKL_Complex16* t2, MKL_Complex16* t3);
void	claref_(const char* type, MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex8* vecs, MKL_Complex8* v2, MKL_Complex8* v3, MKL_Complex8* t1, MKL_Complex8* t2, MKL_Complex8* t3);
void	zlaref_(const char* type, MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* wantz, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* block, MKL_INT* irow1, MKL_INT* icol1, const MKL_INT* istart, const MKL_INT* istop, const MKL_INT* itmp1, const MKL_INT* itmp2, const MKL_INT* liloz, const MKL_INT* lihiz, const MKL_Complex16* vecs, MKL_Complex16* v2, MKL_Complex16* v3, MKL_Complex16* t1, MKL_Complex16* t2, MKL_Complex16* t3);

void	PSLASE2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLASE2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLASE2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLASE2(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PSLASE2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PDLASE2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PCLASE2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	PZLASE2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pslase2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const float* alpha, const float* beta, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pdlase2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const double* alpha, const double* beta, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pclase2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* beta, MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);
void	pzlase2_(const char* uplo, const MKL_INT* m, const MKL_INT* n, const MKL_Complex16* alpha, const MKL_Complex16* beta, MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca);

void	PCLASMSUB(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, MKL_Complex8* buf, const MKL_INT* lwork);
void	PZLASMSUB(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, MKL_Complex16* buf, const MKL_INT* lwork);
void	PCLASMSUB_(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, MKL_Complex8* buf, const MKL_INT* lwork);
void	PZLASMSUB_(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, MKL_Complex16* buf, const MKL_INT* lwork);
void	pclasmsub_(const MKL_Complex8* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const float* smlnum, MKL_Complex8* buf, const MKL_INT* lwork);
void	pzlasmsub_(const MKL_Complex16* a, const MKL_INT* desca, const MKL_INT* i, const MKL_INT* l, MKL_INT* k, const double* smlnum, MKL_Complex16* buf, const MKL_INT* lwork);

void	PSLASRT(const char* id, const MKL_INT* n, float* d, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDLASRT(const char* id, const MKL_INT* n, double* d, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSLASRT_(const char* id, const MKL_INT* n, float* d, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDLASRT_(const char* id, const MKL_INT* n, double* d, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pslasrt_(const char* id, const MKL_INT* n, float* d, const float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdlasrt_(const char* id, const MKL_INT* n, double* d, const double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	PCLATTRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_INT* info);
void	PZLATTRS(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_INT* info);
void	PCLATTRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_INT* info);
void	PZLATTRS_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_INT* info);
void	pclattrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex8* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, float* scale, float* cnorm, MKL_INT* info);
void	pzlattrs_(const char* uplo, const char* trans, const char* diag, const char* normin, const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, MKL_Complex16* x, const MKL_INT* ix, const MKL_INT* jx, const MKL_INT* descx, double* scale, double* cnorm, MKL_INT* info);

void	PILAVER(MKL_INT* vers_major, MKL_INT* vers_minor, MKL_INT* vers_patch);
void	PILAVER_(MKL_INT* vers_major, MKL_INT* vers_minor, MKL_INT* vers_patch);
void	pilaver_(MKL_INT* vers_major, MKL_INT* vers_minor, MKL_INT* vers_patch);

void	PCLAWIL(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex8* a, const MKL_INT* desca, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* v);
void	PZLAWIL(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex16* a, const MKL_INT* desca, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* v);
void	PCLAWIL_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex8* a, const MKL_INT* desca, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* v);
void	PZLAWIL_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex16* a, const MKL_INT* desca, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* v);
void	pclawil_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex8* a, const MKL_INT* desca, const MKL_Complex8* h44, const MKL_Complex8* h33, const MKL_Complex8* h43h34, MKL_Complex8* v);
void	pzlawil_(const MKL_INT* ii, const MKL_INT* jj, const MKL_INT* m, const MKL_Complex16* a, const MKL_INT* desca, const MKL_Complex16* h44, const MKL_Complex16* h33, const MKL_Complex16* h43h34, MKL_Complex16* v);

void	PSORMR3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMR3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSORMR3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDORMR3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);
void	psormr3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* tau, float* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdormr3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* tau, double* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSTEDC(const char* compz, const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSTEDC(const char* compz, const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PSSTEDC_(const char* compz, const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	PDSTEDC_(const char* compz, const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	psstedc_(const char* compz, const MKL_INT* n, float* d, float* e, float* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, float* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);
void	pdstedc_(const char* compz, const MKL_INT* n, double* d, double* e, double* q, const MKL_INT* iq, const MKL_INT* jq, const MKL_INT* descq, double* work, MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info);

void	CSTEQR2(const char* compz, const MKL_INT* n, float* d, float* e, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	ZSTEQR2(const char* compz, const MKL_INT* n, double* d, double* e, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);
void	CSTEQR2_(const char* compz, const MKL_INT* n, float* d, float* e, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	ZSTEQR2_(const char* compz, const MKL_INT* n, double* d, double* e, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);
void	csteqr2_(const char* compz, const MKL_INT* n, float* d, float* e, MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* nr, float* work, MKL_INT* info);
void	zsteqr2_(const char* compz, const MKL_INT* n, double* d, double* e, MKL_Complex16* z, const MKL_INT* ldz, const MKL_INT* nr, double* work, MKL_INT* info);

void	PSSYNGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYNGST(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYNGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYNGST_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pssyngst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const float* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, float* scale, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyngst_(const MKL_INT* ibtype, const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const double* b, const MKL_INT* ib, const MKL_INT* jb, const MKL_INT* descb, double* scale, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYNTRD(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYNTRD(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYNTRD_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYNTRD_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pssyntrd_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyntrd_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PSSYTTRD(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTTRD(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	PSSYTTRD_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	PDSYTTRD_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);
void	pssyttrd_(const char* uplo, const MKL_INT* n, float* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, float* d, float* e, float* tau, float* work, const MKL_INT* lwork, MKL_INT* info);
void	pdsyttrd_(const char* uplo, const MKL_INT* n, double* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, double* d, double* e, double* tau, double* work, const MKL_INT* lwork, MKL_INT* info);

void	PCTREVC(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex8* t, const MKL_INT* desct, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork, MKL_INT* info);
void	PZTREVC(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex16* t, const MKL_INT* desct, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work, double* rwork, MKL_INT* info);
void	PSTREVC(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, float* t, const MKL_INT* desct, float* vl, const MKL_INT* descvl, float* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, float* work, MKL_INT* info);
void	PDTREVC(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, double* t, const MKL_INT* desct, double* vl, const MKL_INT* descvl, double* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* info);
void	PCTREVC_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex8* t, const MKL_INT* desct, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork, MKL_INT* info);
void	PZTREVC_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex16* t, const MKL_INT* desct, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work, double* rwork, MKL_INT* info);
void	PSTREVC_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, float* t, const MKL_INT* desct, float* vl, const MKL_INT* descvl, float* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, float* work, MKL_INT* info);
void	PDTREVC_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, double* t, const MKL_INT* desct, double* vl, const MKL_INT* descvl, double* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* info);
void	pctrevc_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex8* t, const MKL_INT* desct, MKL_Complex8* vl, const MKL_INT* descvl, MKL_Complex8* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork, MKL_INT* info);
void	pztrevc_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, MKL_Complex16* t, const MKL_INT* desct, MKL_Complex16* vl, const MKL_INT* descvl, MKL_Complex16* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, MKL_Complex16* work, double* rwork, MKL_INT* info);
void	pstrevc_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, float* t, const MKL_INT* desct, float* vl, const MKL_INT* descvl, float* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, float* work, MKL_INT* info);
void	pdtrevc_(const char* side, const char* howmny, const MKL_INT* select, const MKL_INT* n, double* t, const MKL_INT* desct, double* vl, const MKL_INT* descvl, double* vr, const MKL_INT* descvr, const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* info);

void	STRMVT(const char* uplo, const MKL_INT* n, const float* t, const MKL_INT* ldt, float* x, const MKL_INT* incx, const float* y, const MKL_INT* incy, float* w, const MKL_INT* incw, const float* z, const MKL_INT* incz);
void	DTRMVT(const char* uplo, const MKL_INT* n, const double* t, const MKL_INT* ldt, double* x, const MKL_INT* incx, const double* y, const MKL_INT* incy, double* w, const MKL_INT* incw, const double* z, const MKL_INT* incz);
void	CTRMVT(const char* uplo, const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* x, const MKL_INT* incx, const MKL_Complex8* y, const MKL_INT* incy, MKL_Complex8* w, const MKL_INT* incw, const MKL_Complex8* z, const MKL_INT* incz);
void	ZTRMVT(const char* uplo, const MKL_INT* n, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* x, const MKL_INT* incx, const MKL_Complex16* y, const MKL_INT* incy, MKL_Complex16* w, const MKL_INT* incw, const MKL_Complex16* z, const MKL_INT* incz);
void	STRMVT_(const char* uplo, const MKL_INT* n, const float* t, const MKL_INT* ldt, float* x, const MKL_INT* incx, const float* y, const MKL_INT* incy, float* w, const MKL_INT* incw, const float* z, const MKL_INT* incz);
void	DTRMVT_(const char* uplo, const MKL_INT* n, const double* t, const MKL_INT* ldt, double* x, const MKL_INT* incx, const double* y, const MKL_INT* incy, double* w, const MKL_INT* incw, const double* z, const MKL_INT* incz);
void	CTRMVT_(const char* uplo, const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* x, const MKL_INT* incx, const MKL_Complex8* y, const MKL_INT* incy, MKL_Complex8* w, const MKL_INT* incw, const MKL_Complex8* z, const MKL_INT* incz);
void	ZTRMVT_(const char* uplo, const MKL_INT* n, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* x, const MKL_INT* incx, const MKL_Complex16* y, const MKL_INT* incy, MKL_Complex16* w, const MKL_INT* incw, const MKL_Complex16* z, const MKL_INT* incz);
void	strmvt_(const char* uplo, const MKL_INT* n, const float* t, const MKL_INT* ldt, float* x, const MKL_INT* incx, const float* y, const MKL_INT* incy, float* w, const MKL_INT* incw, const float* z, const MKL_INT* incz);
void	dtrmvt_(const char* uplo, const MKL_INT* n, const double* t, const MKL_INT* ldt, double* x, const MKL_INT* incx, const double* y, const MKL_INT* incy, double* w, const MKL_INT* incw, const double* z, const MKL_INT* incz);
void	ctrmvt_(const char* uplo, const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* x, const MKL_INT* incx, const MKL_Complex8* y, const MKL_INT* incy, MKL_Complex8* w, const MKL_INT* incw, const MKL_Complex8* z, const MKL_INT* incz);
void	ztrmvt_(const char* uplo, const MKL_INT* n, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* x, const MKL_INT* incx, const MKL_Complex16* y, const MKL_INT* incy, MKL_Complex16* w, const MKL_INT* incw, const MKL_Complex16* z, const MKL_INT* incz);

void	PCUNMR3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMR3(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	PCUNMR3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	PZUNMR3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);
void	pcunmr3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);
void	pzunmr3_(const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_Complex16* a, const MKL_INT* ia, const MKL_INT* ja, const MKL_INT* desca, const MKL_Complex16* tau, MKL_Complex16* c, const MKL_INT* ic, const MKL_INT* jc, const MKL_INT* descc, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

MKL_INT	PILAENVX(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	PIPARMQ(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_INT* lworknb);
MKL_INT	PJLAENV(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	PILAENVX_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	PIPARMQ_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_INT* lworknb);
MKL_INT	PJLAENV_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	pilaenvx_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);
MKL_INT	piparmq_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi, const MKL_INT* lworknb);
MKL_INT	pjlaenv_(const MKL_INT* ictxt, const MKL_INT* ispec, const char* name, const char* opts, const MKL_INT* n1, const MKL_INT* n2, const MKL_INT* n3, const MKL_INT* n4);

/* p?gemr2d - redistribute general submatrix */

void psgemr2d( const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pdgemr2d( const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pcgemr2d( const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pzgemr2d( const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pigemr2d( const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void PSGEMR2D( const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PDGEMR2D( const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PCGEMR2D( const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PZGEMR2D( const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PIGEMR2D( const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void psgemr2d_(const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pdgemr2d_(const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pcgemr2d_(const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pzgemr2d_(const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pigemr2d_(const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void PSGEMR2D_(const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PDGEMR2D_(const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PCGEMR2D_(const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PZGEMR2D_(const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PIGEMR2D_(const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void Cpsgemr2d(MKL_INT m, MKL_INT n,
               const float *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               float *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpdgemr2d(MKL_INT m, MKL_INT n,
               const double *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               double *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpcgemr2d(MKL_INT m, MKL_INT n,
               const MKL_Complex8 *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_Complex8 *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpzgemr2d(MKL_INT m, MKL_INT n,
               const MKL_Complex16 *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_Complex16 *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpigemr2d(MKL_INT m, MKL_INT n,
               const MKL_INT *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_INT *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);

/* p?trmr2d - redistribute trapezoidal submatrix */

void pstrmr2d( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pdtrmr2d( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pctrmr2d( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pztrmr2d( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pitrmr2d( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void PSTRMR2D( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PDTRMR2D( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PCTRMR2D( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PZTRMR2D( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PITRMR2D( const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void pstrmr2d_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pdtrmr2d_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pctrmr2d_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pztrmr2d_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void pitrmr2d_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void PSTRMR2D_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const float *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               float *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PDTRMR2D_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const double *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               double *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PCTRMR2D_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex8 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex8 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PZTRMR2D_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_Complex16 *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_Complex16 *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);
void PITRMR2D_(const char *uplo, const char *diag, const MKL_INT *m, const MKL_INT *n,
               const MKL_INT *a, const MKL_INT *ia, const MKL_INT *ja, const MKL_INT *desca,
               MKL_INT *b, const MKL_INT *ib, const MKL_INT *jb, const MKL_INT *descb,
               const MKL_INT *ictxt);

void Cpstrmr2d(const char *uplo, const char *diag, MKL_INT m, MKL_INT n,
               const float *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               float *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpdtrmr2d(const char *uplo, const char *diag, MKL_INT m, MKL_INT n,
               const double *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               double *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpctrmr2d(const char *uplo, const char *diag, MKL_INT m, MKL_INT n,
               const MKL_Complex8 *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_Complex8 *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpztrmr2d(const char *uplo, const char *diag, MKL_INT m, MKL_INT n,
               const MKL_Complex16 *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_Complex16 *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);
void Cpitrmr2d(const char *uplo, const char *diag, MKL_INT m, MKL_INT n,
               const MKL_INT *a, MKL_INT ia, MKL_INT ja, const MKL_INT *desca,
               MKL_INT *b, MKL_INT ib, MKL_INT jb, const MKL_INT *descb,
               MKL_INT ictxt);

void descinit(MKL_INT* desc, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* mb, const MKL_INT* nb, const MKL_INT* irsrc,
              const MKL_INT* icsrc, const MKL_INT* ictxt, const MKL_INT* lld,
              MKL_INT* info);
void descinit_(MKL_INT* desc, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* mb, const MKL_INT* nb, const MKL_INT* irsrc,
               const MKL_INT* icsrc, const MKL_INT* ictxt, const MKL_INT* lld,
               MKL_INT* info);
void DESCINIT(MKL_INT* desc, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* mb, const MKL_INT* nb, const MKL_INT* irsrc,
              const MKL_INT* icsrc, const MKL_INT* ictxt, const MKL_INT* lld,
              MKL_INT* info);
void DESCINIT_(MKL_INT* desc, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* mb, const MKL_INT* nb, const MKL_INT* irsrc,
               const MKL_INT* icsrc, const MKL_INT* ictxt, const MKL_INT* lld,
               MKL_INT* info);

MKL_INT numroc(const MKL_INT* n, const MKL_INT* nb, const MKL_INT* iproc,
               const MKL_INT* isrcproc, const MKL_INT* nprocs);
MKL_INT numroc_(const MKL_INT* n, const MKL_INT* nb, const MKL_INT* iproc,
                const MKL_INT* isrcproc, const MKL_INT* nprocs);
MKL_INT NUMROC(const MKL_INT* n, const MKL_INT* nb, const MKL_INT* iproc,
               const MKL_INT* isrcproc, const MKL_INT* nprocs);
MKL_INT NUMROC_(const MKL_INT* n, const MKL_INT* nb, const MKL_INT* iproc,
                const MKL_INT* isrcproc, const MKL_INT* nprocs);

void infog2l(const MKL_INT* grindx, const MKL_INT* gcindx, const MKL_INT* desc,
             const MKL_INT* nprow, const MKL_INT* npcol,
             const MKL_INT* myrow, const MKL_INT* mycol,
             MKL_INT* lrindx, MKL_INT* lcindx, MKL_INT* rsrc, MKL_INT* csrc);
void infog2l_(const MKL_INT* grindx, const MKL_INT* gcindx, const MKL_INT* desc,
             const MKL_INT* nprow, const MKL_INT* npcol,
             const MKL_INT* myrow, const MKL_INT* mycol,
             MKL_INT* lrindx, MKL_INT* lcindx, MKL_INT* rsrc, MKL_INT* csrc);
void INFOG2L(const MKL_INT* grindx, const MKL_INT* gcindx, const MKL_INT* desc,
             const MKL_INT* nprow, const MKL_INT* npcol,
             const MKL_INT* myrow, const MKL_INT* mycol,
             MKL_INT* lrindx, MKL_INT* lcindx, MKL_INT* rsrc, MKL_INT* csrc);
void INFOG2L_(const MKL_INT* grindx, const MKL_INT* gcindx, const MKL_INT* desc,
             const MKL_INT* nprow, const MKL_INT* npcol,
             const MKL_INT* myrow, const MKL_INT* mycol,
             MKL_INT* lrindx, MKL_INT* lcindx, MKL_INT* rsrc, MKL_INT* csrc);

void pcgebal(const char* job, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void PCGEBAL(const char* job, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void PCGEBAL_(const char* job, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);
void pcgebal_(const char* job, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, float* scale, MKL_INT* info);

void pzgebal(const char* job, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void PZGEBAL(const char* job, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void PZGEBAL_(const char* job, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);
void pzgebal_(const char* job, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* desca, MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info);


void	pcgebak(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, MKL_Complex8* v, const MKL_INT* descv,  MKL_INT* info);
void	PCGEBAK(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, MKL_Complex8* v, const MKL_INT* descv,  MKL_INT* info);
void	pcgebak_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, MKL_Complex8* v, const MKL_INT* descv,  MKL_INT* info);
void	PCGEBAK_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, MKL_Complex8* v, const MKL_INT* descv,  MKL_INT* info);

void	pdgebak(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, double* v, const MKL_INT* descv,  MKL_INT* info);
void	PDGEBAK(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, double* v, const MKL_INT* descv,  MKL_INT* info);
void	pdgebak_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, double* v, const MKL_INT* descv,  MKL_INT* info);
void	PDGEBAK_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, double* v, const MKL_INT* descv,  MKL_INT* info);

void	pzgebak(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, MKL_Complex16* v, const MKL_INT* descv,  MKL_INT* info);
void	PZGEBAK(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, MKL_Complex16* v, const MKL_INT* descv,  MKL_INT* info);
void	pzgebak_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, MKL_Complex16* v, const MKL_INT* descv,  MKL_INT* info);
void	PZGEBAK_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, double* scale, const MKL_INT* m, MKL_Complex16* v, const MKL_INT* descv,  MKL_INT* info);

void	psgebak(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, float* v, const MKL_INT* descv,  MKL_INT* info);
void	PSGEBAK(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, float* v, const MKL_INT* descv,  MKL_INT* info);
void	psgebak_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, float* v, const MKL_INT* descv,  MKL_INT* info);
void	PSGEBAK_(const char* job, const char* side, const MKL_INT* n, MKL_INT* ilo, MKL_INT* ihi, float* scale, const MKL_INT* m, float* v, const MKL_INT* descv,  MKL_INT* info);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _MKL_SCALAPACK_H_ */

