from typing import Final, final
from typing_extensions import Self

__all__ = ("MAX", "MIN", "InvalidRomanNumeralError", "OutOfRangeError", "RomanNumeral")

MIN: Final = 1
MAX: Final = 4_999

@final
class OutOfRangeError(TypeError): ...

@final
class InvalidRomanNumeralError(ValueError):
    def __init__(self, value: str, *args: object) -> None: ...

@final
class RomanNumeral:
    def __init__(self, value: int, /) -> None: ...
    def __int__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __setattr__(self, key: str, value: object) -> None: ...
    def to_uppercase(self) -> str: ...
    def to_lowercase(self) -> str: ...
    @classmethod
    def from_string(cls, string: str, /) -> Self: ...

_ROMAN_NUMERAL_PREFIXES: Final[list[tuple[int, str, str]]]
