from typing import Final

from pymeeus.Angle import Angle
from pymeeus.Epoch import Epoch

VSOP87_L: Final[list[list[list[float]]]]
VSOP87_B: Final[list[list[list[float]]]]
VSOP87_R: Final[list[list[list[float]]]]
VSOP87_L_J2000: Final[list[list[list[float]]]]
VSOP87_B_J2000: Final[list[list[list[float]]]]
ORBITAL_ELEM: Final[list[list[float]]]
ORBITAL_ELEM_J2000: Final[list[list[float]]]

class Ellipsoid:
    def __init__(self, a: float, f: float, omega: float) -> None: ...
    def b(self) -> float: ...
    def e(self) -> float: ...

IAU76: Final[Ellipsoid]
WGS84: Final[Ellipsoid]

class Earth:
    def __init__(self, ellipsoid: Ellipsoid = ...) -> None: ...
    def set(self, ellipsoid: Ellipsoid) -> None: ...
    def rho(self, latitude: float | Angle) -> float: ...
    def rho_sinphi(self, latitude: float | Angle, height: float) -> float: ...
    def rho_cosphi(self, latitude: float | Angle, height: float) -> float: ...
    def rp(self, latitude: float | Angle) -> float: ...
    def linear_velocity(self, latitude: float | Angle) -> float: ...
    def rm(self, latitude: float | Angle) -> float: ...
    def distance(
        self, lon1: float | Angle, lat1: float | Angle, lon2: float | Angle, lat2: float | Angle
    ) -> tuple[float, float]: ...
    @staticmethod
    def geometric_heliocentric_position(epoch: Epoch, tofk5: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def apparent_heliocentric_position(epoch: Epoch, nutation: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def geometric_heliocentric_position_j2000(epoch: Epoch, tofk5: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def orbital_elements_mean_equinox(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def orbital_elements_j2000(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def perihelion_aphelion(epoch: Epoch, perihelion: bool | None = True) -> Epoch: ...
    @staticmethod
    def passage_nodes(epoch: Epoch, ascending: bool = True) -> tuple[Epoch, float]: ...
    @staticmethod
    def parallax_correction(
        right_ascension: Angle, declination: Angle, latitude: Angle, distance: float, hour_angle: Angle, height: float = 0.0
    ) -> tuple[Angle, Angle]: ...
    @staticmethod
    def parallax_ecliptical(
        longitude: Angle,
        latitude: Angle,
        semidiameter: Angle,
        obs_lat: Angle,
        obliquity: Angle,
        sidereal_time: Angle,
        distance: float,
        height: float = 0.0,
    ) -> tuple[Angle, Angle, Angle]: ...

def main() -> None: ...
