from _typeshed import Incomplete
from typing import Literal, TextIO

from antlr4.atn.ATNDeserializationOptions import ATNDeserializationOptions as ATNDeserializationOptions
from antlr4.atn.ATNDeserializer import ATNDeserializer as ATNDeserializer
from antlr4.atn.ParserATNSimulator import ParserATNSimulator
from antlr4.BufferedTokenStream import TokenStream as TokenStream
from antlr4.CommonTokenFactory import TokenFactory as TokenFactory
from antlr4.error.Errors import (
    RecognitionException as RecognitionException,
    UnsupportedOperationException as UnsupportedOperationException,
)
from antlr4.error.ErrorStrategy import DefaultErrorStrategy as DefaultErrorStrategy
from antlr4.InputStream import InputStream as InputStream
from antlr4.Lexer import Lexer as Lexer
from antlr4.ParserRuleContext import ParserRuleContext as ParserRuleContext
from antlr4.Recognizer import Recognizer as Recognizer
from antlr4.RuleContext import RuleContext as RuleContext
from antlr4.Token import Token as Token
from antlr4.tree.ParseTreePattern import ParseTreePattern
from antlr4.tree.ParseTreePatternMatcher import ParseTreePatternMatcher as ParseTreePatternMatcher
from antlr4.tree.Tree import ErrorNode as ErrorNode, ParseTreeListener as ParseTreeListener, TerminalNode as TerminalNode

class TraceListener(ParseTreeListener):
    __slots__ = "_parser"
    def __init__(self, parser) -> None: ...
    def enterEveryRule(self, ctx) -> None: ...
    def visitTerminal(self, node) -> None: ...
    def visitErrorNode(self, node) -> None: ...
    def exitEveryRule(self, ctx) -> None: ...

class Parser(Recognizer):
    __slots__ = (
        "_input",
        "_output",
        "_errHandler",
        "_precedenceStack",
        "_ctx",
        "buildParseTrees",
        "_tracer",
        "_parseListeners",
        "_syntaxErrors",
    )
    _input: TokenStream
    _output: TextIO
    _errHandler: DefaultErrorStrategy
    _precedenceStack: list[int]
    _ctx: ParserRuleContext | None
    _tracer: TraceListener | None
    _parseListeners: list[ParseTreeListener]
    _syntaxErrors: int
    _interp: ParserATNSimulator
    bypassAltsAtnCache: dict[Incomplete, Incomplete]
    buildParseTrees: bool
    def __init__(self, input: TokenStream, output: TextIO = ...) -> None: ...
    def reset(self) -> None: ...
    def match(self, ttype: int) -> Token: ...
    def matchWildcard(self) -> Token: ...
    def getParseListeners(self) -> list[ParseTreeListener]: ...
    def addParseListener(self, listener: ParseTreeListener) -> None: ...
    def removeParseListener(self, listener: ParseTreeListener) -> None: ...
    def removeParseListeners(self) -> None: ...
    def triggerEnterRuleEvent(self) -> None: ...
    def triggerExitRuleEvent(self) -> None: ...
    def getNumberOfSyntaxErrors(self) -> int: ...
    def getTokenFactory(self) -> TokenFactory: ...
    def setTokenFactory(self, factory: TokenFactory) -> None: ...
    def getATNWithBypassAlts(self): ...
    def compileParseTreePattern(self, pattern: str, patternRuleIndex: int, lexer: Lexer | None = None) -> ParseTreePattern: ...
    def getInputStream(self) -> InputStream: ...
    def setInputStream(self, input: InputStream) -> None: ...
    def getTokenStream(self) -> TokenStream: ...
    def setTokenStream(self, input: TokenStream) -> None: ...
    def getCurrentToken(self) -> Token | None: ...
    def notifyErrorListeners(
        self, msg: str, offendingToken: Token | None = None, e: RecognitionException | None = None
    ) -> None: ...
    def consume(self) -> None: ...
    def addContextToParseTree(self) -> None: ...
    state: int
    def enterRule(self, localctx: ParserRuleContext, state: int, ruleIndex: int) -> None: ...
    def exitRule(self) -> None: ...
    def enterOuterAlt(self, localctx: ParserRuleContext, altNum: int) -> None: ...
    def getPrecedence(self) -> int: ...
    def enterRecursionRule(self, localctx: ParserRuleContext, state: int, ruleIndex: int, precedence: int) -> None: ...
    def pushNewRecursionContext(self, localctx: ParserRuleContext, state: int, ruleIndex: int) -> None: ...
    def unrollRecursionContexts(self, parentCtx: ParserRuleContext) -> None: ...
    def getInvokingContext(self, ruleIndex: int) -> RuleContext | None: ...
    def precpred(self, localctx: RuleContext, precedence: int) -> bool: ...
    def inContext(self, context: str) -> Literal[False]: ...
    def isExpectedToken(self, symbol: int) -> bool: ...
    def getExpectedTokens(self): ...
    def getExpectedTokensWithinCurrentRule(self): ...
    def getRuleIndex(self, ruleName: str) -> int: ...
    def getRuleInvocationStack(self, p: RuleContext | None = None) -> list[str]: ...
    def getDFAStrings(self) -> list[str]: ...
    def dumpDFA(self) -> None: ...
    def getSourceName(self) -> str: ...
    def setTrace(self, trace: bool) -> None: ...
