private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_0_0 {
	meta:
		name = "FindDefaultComponentOwnerPageName"
		size = 176
		refs = "0016 FindDefaultComponentOwnerPageName 0024 @UStrClr 0035 @IntfClear 004a Supports 0053 WebContext 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 5E 04 85 DB 75 02 8B DE 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 85 C0 74 03 83 E8 CC E8 ?? ?? ?? ?? 84 C0 74 28 E8 ?? ?? ?? ?? 8B F0 8B 03 89 45 F0 8D 4D F4 8B 55 F0 8B C6 8B 18 FF 53 50 84 C0 74 0B 8B 55 F8 8B 45 F4 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 00 00 61 1F 8D 60 23 F2 74 45 89 F7 F2 9A 73 37 2F FC }
	condition:
		$1
}

rule function_1_0 {
	meta:
		name = "ExtractStringValue"
		size = 96
		refs = "000a ExtractStringValue 000f AnsiPos 003d @UStrCopy 0048 @UStrSetLength"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B D6 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 12 8B C6 85 C0 74 05 83 E8 04 8B 00 3B D8 0F 9C C0 EB 02 33 C0 84 C0 74 12 57 8D 53 01 B9 FF FF FF 7F 8B C6 E8 ?? ?? ?? ?? EB 09 8B C7 33 D2 E8 ?? ?? ?? ?? 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_2_0 {
	meta:
		name = "RaiseActionDoesNotProvideResponse"
		size = 84
		refs = "0009 RaiseActionDoesNotProvideResponse 0017 sActionDoesNotProvideResponse 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70281_0 {
	meta:
		name = "@DispInvokeError"
		size = 84
		refs = "0009 @DispInvokeError 0017 SDispatchError 001c LoadResString 0026 _DV_EVariantDispatchError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_80351_0 {
	meta:
		name = "OutOfResources"
		size = 84
		refs = "0009 OutOfResources 0017 SOutOfResources 001c LoadResString 0026 _Dn_EOutOfResources 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_4_0 {
	meta:
		name = "RaiseActionCantRedirectToBlankURL"
		size = 84
		refs = "0009 RaiseActionCantRedirectToBlankURL 0017 sActionCantRedirectToBlankURL 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_96693_0 {
	meta:
		name = "RaiseAdapterModificationNotPermitted"
		size = 84
		refs = "0009 RaiseAdapterModificationNotPermitted 0017 sAdapterModificationNotPermitted 001c LoadResString 0026 _DV_EAdapterException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_3_0 {
	meta:
		name = "RaiseCantResponseToUnknownHTTPMethod"
		size = 84
		refs = "0009 RaiseCantResponseToUnknownHTTPMethod 0017 sActionCantRespondToUnkownHTTPMethod 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97810_0 {
	meta:
		name = "RaiseDispatchBlankPageNameException"
		size = 84
		refs = "0009 RaiseDispatchBlankPageNameException 0017 sDispatchBlankPageName 001c LoadResString 0026 _DV_EPageDispatcherException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97348_0 {
	meta:
		name = "RaiseIntegerParameterExpected"
		size = 84
		refs = "0009 RaiseIntegerParameterExpected 0017 sIntegerParameterExpected 001c LoadResString 0026 _Dn_EScriptEvalError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97347_0 {
	meta:
		name = "RaiseObjectParameterExpected"
		size = 84
		refs = "0009 RaiseObjectParameterExpected 0017 sStringParameterExpected 001c LoadResString 0026 _Dn_EScriptEvalError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_66469_0 {
	meta:
		name = "RaiseOverflowError"
		size = 84
		refs = "0009 RaiseOverflowError 0017 SIntOverflow 001c LoadResString 0026 _Dn_EIntOverflow 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97811_0 {
	meta:
		name = "RaisePageAccessDenied"
		size = 84
		refs = "0009 RaisePageAccessDenied 0017 sPageAccessDenied 001c LoadResString 0026 _DV_EPageDispatcherException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97345_0 {
	meta:
		name = "RaiseParameterExpected"
		size = 84
		refs = "0009 RaiseParameterExpected 0017 sParameterExpected 001c LoadResString 0026 _Dn_EScriptEvalError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_97346_0 {
	meta:
		name = "RaiseStringParameterExpected"
		size = 84
		refs = "0009 RaiseStringParameterExpected 0017 sStringParameterExpected 001c LoadResString 0026 _Dn_EScriptEvalError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_66214_0 {
	meta:
		name = "RoundExError"
		size = 84
		refs = "0009 RoundExError 0017 SVarInvalid 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70637_0 {
	meta:
		name = "SafeArrayCreateError"
		size = 84
		refs = "0009 SafeArrayCreateError 0017 SVarArrayCreate 001c LoadResString 0026 _DV_ESafeArrayCreateError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_68730_0 {
	meta:
		name = "TConditionVariableMutex.Acquire"
		size = 84
		refs = "0009 TConditionVariableMutex.Acquire 0017 sCannotCallAcquireOnConditionVar 001c LoadResString 0026 _DV_ESyncObjectException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_26335_0 {
	meta:
		name = "TCustomDataSetAdapter.RaiseNilDataSet"
		size = 84
		refs = "0009 TCustomDataSetAdapter.RaiseNilDataSet 0017 sNilAdapterDataSet 001c LoadResString 0026 _Dn_EAdapterException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8272_0 {
	meta:
		name = "TDBXCustomValueRow.GetDBXTableName"
		size = 84
		refs = "0009 TDBXCustomValueRow.GetDBXTableName 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8271_0 {
	meta:
		name = "TDBXCustomValueRow.SetDBXTableName"
		size = 84
		refs = "0009 TDBXCustomValueRow.SetDBXTableName 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8207_0 {
	meta:
		name = "TDBXTable.AcceptChanges"
		size = 84
		refs = "0009 TDBXTable.AcceptChanges 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8202_0 {
	meta:
		name = "TDBXTable.Clear"
		size = 84
		refs = "0009 TDBXTable.Clear 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8201_0 {
	meta:
		name = "TDBXTable.Close"
		size = 84
		refs = "0009 TDBXTable.Close 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8203_0 {
	meta:
		name = "TDBXTable.DeleteRow"
		size = 84
		refs = "0009 TDBXTable.DeleteRow 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8192_0 {
	meta:
		name = "TDBXTable.GetDBXTableName"
		size = 84
		refs = "0009 TDBXTable.GetDBXTableName 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8199_0 {
	meta:
		name = "TDBXTable.Insert"
		size = 84
		refs = "0009 TDBXTable.Insert 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8200_0 {
	meta:
		name = "TDBXTable.Post"
		size = 84
		refs = "0009 TDBXTable.Post 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8194_0 {
	meta:
		name = "TDBXTable.SetColumns"
		size = 84
		refs = "0009 TDBXTable.SetColumns 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8191_0 {
	meta:
		name = "TDBXTable.SetDBXTableName"
		size = 84
		refs = "0009 TDBXTable.SetDBXTableName 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16682_0 {
	meta:
		name = "TDSDefaultCommandHandler.DbxMoreBlob"
		size = 84
		refs = "0009 TDSDefaultCommandHandler.DbxMoreBlob 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16681_0 {
	meta:
		name = "TDSDefaultCommandHandler.DbxNext"
		size = 84
		refs = "0009 TDSDefaultCommandHandler.DbxNext 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16680_0 {
	meta:
		name = "TDSDefaultCommandHandler.DbxNextResult"
		size = 84
		refs = "0009 TDSDefaultCommandHandler.DbxNextResult 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16679_0 {
	meta:
		name = "TDSDefaultCommandHandler.DbxPrepare"
		size = 84
		refs = "0009 TDSDefaultCommandHandler.DbxPrepare 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16743_0 {
	meta:
		name = "TDSServerCommandHandler.DbxMoreBlob"
		size = 84
		refs = "0009 TDSServerCommandHandler.DbxMoreBlob 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16744_0 {
	meta:
		name = "TDSServerCommandHandler.DbxNext"
		size = 84
		refs = "0009 TDSServerCommandHandler.DbxNext 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16745_0 {
	meta:
		name = "TDSServerCommandHandler.DbxNextResult"
		size = 84
		refs = "0009 TDSServerCommandHandler.DbxNextResult 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_16746_0 {
	meta:
		name = "TDSServerCommandHandler.DbxReaderClose"
		size = 84
		refs = "0009 TDSServerCommandHandler.DbxReaderClose 0017 SUnsupportedOperation 001c LoadResString 0026 _Dn_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_78562_0 {
	meta:
		name = "TDirect2DCanvas.DrawFocusRect"
		size = 84
		refs = "0009 TDirect2DCanvas.DrawFocusRect 0017 SInvalidCanvasOperation 001c LoadResString 0026 _Dn_EInvalidOperation 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_78565_0 {
	meta:
		name = "TDirect2DCanvas.GetClipRect"
		size = 84
		refs = "0009 TDirect2DCanvas.GetClipRect 0017 SInvalidCanvasOperation 001c LoadResString 0026 _Dn_EInvalidOperation 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_32792_0 {
	meta:
		name = "TIdCustomTransparentProxy.CloseUDP"
		size = 84
		refs = "0009 TIdCustomTransparentProxy.CloseUDP 0017 RSTransparentProxyCanNotSupportUDP 001c LoadResString 0026 _DV_EIdTransparentProxyUDPNotSupported 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_33551_0 {
	meta:
		name = "TIdFTPBaseFileSystem.ErrCantRemoveDir"
		size = 84
		refs = "0009 TIdFTPBaseFileSystem.ErrCantRemoveDir 0017 RSFTPFSysErrMsg 001c LoadResString 0026 _DV_EIdFileSystemCannotRemoveDir 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_33552_0 {
	meta:
		name = "TIdFTPBaseFileSystem.ErrFileNotFound"
		size = 84
		refs = "0009 TIdFTPBaseFileSystem.ErrFileNotFound 0017 RSFTPFSysErrMsg 001c LoadResString 0026 _DV_EIdFileSystemFileNotFound 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_33553_0 {
	meta:
		name = "TIdFTPBaseFileSystem.ErrNotADir"
		size = 84
		refs = "0009 TIdFTPBaseFileSystem.ErrNotADir 0017 RSFTPFSysErrMsg 001c LoadResString 0026 _DV_EIdFileSystemNotADir 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_33554_0 {
	meta:
		name = "TIdFTPBaseFileSystem.ErrNotAFile"
		size = 84
		refs = "0009 TIdFTPBaseFileSystem.ErrNotAFile 0017 RSFTPFSysErrMsg 001c LoadResString 0026 _DV_EIdFileSystemNotAFile 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_33555_0 {
	meta:
		name = "TIdFTPBaseFileSystem.ErrPermissionDenied"
		size = 84
		refs = "0009 TIdFTPBaseFileSystem.ErrPermissionDenied 0017 RSFTPFSysErrMsg 001c LoadResString 0026 _DV_EIdFileSystemPermissionDenied 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_35533_0 {
	meta:
		name = "TIdIOHandler.RaiseConnClosedGracefully"
		size = 84
		refs = "0009 TIdIOHandler.RaiseConnClosedGracefully 0017 RSConnectionClosedGracefully 001c LoadResString 0026 _Dn_EIdConnClosedGracefully 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_37113_0 {
	meta:
		name = "TIdSMTPRelay.SetHost"
		size = 84
		refs = "0009 TIdSMTPRelay.SetHost 0017 RSDirSMTPCantAssignHost 001c LoadResString 0026 _DV_EIdDirectSMTPCannotAssignHost 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_38442_0 {
	meta:
		name = "TIdUDPClient.RaiseUseProxyError"
		size = 84
		refs = "0009 TIdUDPClient.RaiseUseProxyError 0017 RSUDPMustUseProxyOpen 001c LoadResString 0026 _DV_EIdMustUseOpenProxy 002b EIdException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_39464_0 {
	meta:
		name = "TInCustomTransparentProxy.CloseUDP"
		size = 84
		refs = "0009 TInCustomTransparentProxy.CloseUDP 0017 RSTransparentProxyCanNotSupportUDP 001c LoadResString 0026 _DV_EIdTransparentProxyUDPNotSupported 002b EInException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_41141_0 {
	meta:
		name = "TInIOHandler.RaiseConnClosedGracefully"
		size = 84
		refs = "0009 TInIOHandler.RaiseConnClosedGracefully 0017 RSConnectionClosedGracefully 001c LoadResString 0026 _Dn_EIdConnClosedGracefully 002b EInException.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_87235_0 {
	meta:
		name = "TUxThemeStyle.SaveToStream"
		size = 84
		refs = "0009 TUxThemeStyle.SaveToStream 0017 SStyleFeatureNotSupported 001c LoadResString 0026 _DV_ECustomStyleException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_59432_0 {
	meta:
		name = "TVirtualObjectMemberInstance.SetValue"
		size = 84
		refs = "0009 TVirtualObjectMemberInstance.SetValue 0017 sVirtualMemberReadOnly 001c LoadResString 0026 _Dn_EWrapperError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70276_0 {
	meta:
		name = "VarArrayCreateError"
		size = 84
		refs = "0009 VarArrayCreateError 0017 SVarArrayCreate 001c LoadResString 0026 _DV_EVariantArrayCreateError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70270_0 {
	meta:
		name = "VarCastError"
		size = 84
		refs = "0009 VarCastError 0017 SInvalidVarCast 001c LoadResString 0026 _DV_EVariantTypeCastError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70273_0 {
	meta:
		name = "VarInvalidNullOp"
		size = 84
		refs = "0009 VarInvalidNullOp 0017 SInvalidVarNullOp 001c LoadResString 0026 _DV_EVariantInvalidNullOpError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_70272_0 {
	meta:
		name = "VarInvalidOp"
		size = 84
		refs = "0009 VarInvalidOp 0017 SInvalidVarOp 001c LoadResString 0026 _DV_EVariantInvalidOpError 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_5_0 {
	meta:
		name = "TestRedirectOptions"
		size = 46
		refs = "0025 RaiseCantResponseToUnknownHTTPMethod"
	strings:
		$1 = { 53 51 88 04 24 33 DB FE CA 74 07 80 EA 02 74 0B EB 12 F6 04 24 02 0F 95 C3 EB 0E F6 04 24 01 0F 95 C3 EB 05 E8 ?? ?? ?? ?? 8B C3 5A 5B C3 }
	condition:
		$1
}

rule function_6_0 {
	meta:
		name = "TAdapterRequestParamsImpl.AssignTo"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B 56 04 8B C7 8B 08 FF 51 08 5F 5E C3 }
	condition:
		$1
}

rule function_7_0 {
	meta:
		name = "TAdapterRequestParamsImpl.Create"
		size = 135
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterRequestParamsImpl.Create 0034 TObject.Create 003f @IntfCopy 005f @IntfClear 0065 @HandleFinally 0072 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 08 8B 55 FC E8 ?? ?? ?? ?? 8B 46 08 8B 10 FF 52 14 89 46 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_8_0 {
	meta:
		name = "TAdapterModes.GetAdapterCount"
		size = 9
		altNames = "TAdapterRequestParamsImpl.GetParamCount TAllocatedActions.GetCount TGeneratedFunctions.GetItemCount TIWContainerContext.GetControlsCount TIdMIMEBoundary.Count"
	strings:
		$1 = { 8B 40 04 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_9_0 {
	meta:
		name = "TAdapterModes.GetAdapterName"
		size = 25
		refs = "0011 TStrings.GetName"
		altNames = "TAdapterRequestParamsImpl.GetParamName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "TAdapterRequestParamsImpl.ValueOfParam"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_89693_0 {
	meta:
		name = "TVirtualKeys.GetItem"
		size = 25
		refs = "0011 TList<Vcl.Touch.KeyboardTypes.TVirtualKey>.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10_0 {
	meta:
		name = "TAdapterRequestParamsImpl.GetParamValue"
		size = 93
		refs = "0018 TAdapterRequestParamsImpl.GetParamValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_60_0 {
	meta:
		name = "TAdapterModes.GetAdapterMode"
		size = 93
		refs = "0018 TAdapterModes.GetAdapterMode 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "TAdapterRequestParamsImpl.IndexOfParam"
		size = 9
	strings:
		$1 = { 8B 40 04 8B 08 FF 51 54 C3 }
	condition:
		$1
}

rule function_13_0 {
	meta:
		name = "AddValues"
		size = 1024
		refs = "0017 AddValues 0047 TStrings.GetName 005d @UStrCopy 006a @UStrLAsg 0091 CompareText 00ac @UStrDelete 011f ExtractStringValue 0138 @UStrClr 015d @UStrEqual 01a2 _Dn_TStringList 01a7 TStringList.Create 01b0 TList.Add 0295 TList.Get 0397 @UStrArrayClr 03aa @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 10 FF 52 14 48 85 C0 0F 8C A7 01 00 00 40 89 45 E0 33 DB 8D 4D FC 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 8D 45 F8 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8D 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 3B 45 F4 75 04 B0 01 EB 20 83 7D F8 00 74 06 83 7D F4 00 75 04 33 C0 EB 10 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 17 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 B6 00 00 00 8D 45 F0 50 B9 06 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 3B 45 EC 75 04 B0 01 EB 20 83 7D F0 00 74 06 83 7D EC 00 75 04 33 C0 EB 10 8B 55 EC 8B 45 F0 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 36 8D 4D D8 8B 45 08 8B 40 FC 8B D3 8B 30 FF 56 0C 8B 45 D8 8D 55 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 08 8B 40 F8 8B 40 04 8B 08 FF 51 38 8D 45 FC E8 ?? ?? ?? ?? EB 2D 8D 45 D4 50 B9 02 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 08 8D 45 FC E8 ?? ?? ?? ?? 83 7D FC 00 74 61 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 40 75 4D 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 38 8B 45 08 8B 40 F8 8B 70 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 70 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 43 FF 4D E0 0F 85 5F FE FF FF 8B 45 08 8B 40 FC 8B 10 FF 52 14 48 85 C0 0F 8C 91 01 00 00 40 89 45 E0 33 DB 8D 4D FC 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 8D 45 E8 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8D 45 E4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 3B 45 E4 75 04 B0 01 EB 20 83 7D E8 00 74 06 83 7D E4 00 75 04 33 C0 EB 10 8B 55 E4 8B 45 E8 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 6C 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 8B F0 83 FE FF 0F 84 F0 00 00 00 8B 45 08 8B 40 F8 8B 78 14 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 8D 4D CC 8B 45 08 8B 40 FC 8B D3 8B 38 FF 57 0C 8B 45 CC 8D 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 8B C6 8B 08 FF 51 38 E9 B2 00 00 00 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 8B F0 83 FE FF 0F 84 96 00 00 00 8B 45 08 8B 40 FC 8B D3 8B 08 FF 51 18 85 C0 74 4C 8B 45 08 8B 40 F8 8B 78 10 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 8D 4D C4 8B 45 08 8B 40 FC 8B D3 8B 38 FF 57 0C 8B 45 C4 8D 55 C8 E8 ?? ?? ?? ?? 8B 45 C8 50 8B 45 08 8B 40 FC 8B D3 8B 08 FF 51 18 8B C8 8B C6 5A 8B 30 FF 56 3C EB 39 8B 45 08 8B 40 F8 8B 78 10 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 8D 4D BC 8B 45 08 8B 40 FC 8B D3 8B 38 FF 57 0C 8B 45 BC 8D 55 C0 E8 ?? ?? ?? ?? 8B 55 C0 8B C6 8B 08 FF 51 38 43 FF 4D E0 0F 85 75 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC BA 09 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 BA 07 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 6F 00 76 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 5F 00 5F 00 6B 00 65 00 79 00 2E 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 5F 00 5F 00 00 00 00 00 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "TActionFieldValuesImpl.Create"
		size = 174
		refs = "000f @ClassCreate 0021 TObject.Create 0028 _Dn_TStringList 002d TStringList.Create 0060 _Dn_TObjectList 0065 TObjectList.Create 008b AddValues 0098 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 89 45 F8 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 0C B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 10 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 14 83 7D FC 00 74 07 55 E8 ?? ?? ?? ?? 59 8B 45 F8 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "TActionFieldValueImpl.GetFileCount"
		size = 7
		altNames = "TActionFieldValuesImpl.GetFieldCount TScriptProducer.GetHTMLItemCount TTestResult.FailureCount"
	strings:
		$1 = { 8B 40 10 8B 40 08 C3 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "TActionFieldValuesImpl.GetFieldName"
		size = 25
		altNames = "TInvokable.Invoke"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 0C 8B 18 FF 53 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "TActionFieldValuesImpl.AddValue"
		size = 81
		refs = "0024 _Dn_TStringList 0029 TStringList.Create 0032 TList.Add"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 08 FF 51 54 85 C0 7D 3A 8B D6 8B 43 0C 8B 08 FF 51 38 8B 73 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 5B 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "TActionFieldValuesImpl.IndexOfField"
		size = 9
	strings:
		$1 = { 8B 40 0C 8B 08 FF 51 54 C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 328
		refs = "001f TActionFieldValuesImpl.CreateValue 0042 _Dn_TInterfaceList 0047 TInterfaceList.Create 0058 @IntfCopy 008d TList.Get 00ab _DV_TActionFieldValueImpl 00b0 TActionFieldValueImpl.Create 00c6 @IntfCast 00f5 @IntfClear 0112 @UStrClr 0128 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B8 00 00 00 83 7B 1C 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 1C E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 1C 8B 08 FF 51 20 8D 4D F0 8B D6 8B 43 1C 8B 38 FF 57 0C 83 7D F0 00 75 56 8B 7B 10 89 75 F4 8B 55 F4 8B C7 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 50 8D 4D E8 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D E8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC 8B D6 8B 43 1C 8B 38 FF 57 18 8D 4D E4 8B D6 8B 43 1C 8B 18 FF 53 0C 8B 55 E4 8B 45 FC E8 ?? ?? ?? ?? EB 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 00 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateOrigValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 328
		refs = "001f TActionFieldValuesImpl.CreateOrigValue 0042 _Dn_TInterfaceList 0047 TInterfaceList.Create 0058 @IntfCopy 008d TList.Get 00ab _DV_TActionFieldValueImpl 00b0 TActionFieldValueImpl.Create 00c6 @IntfCast 00f5 @IntfClear 0112 @UStrClr 0128 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B8 00 00 00 83 7B 18 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 18 E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 18 8B 08 FF 51 20 8D 4D F0 8B D6 8B 43 18 8B 38 FF 57 0C 83 7D F0 00 75 56 8B 7B 14 89 75 F4 8B 55 F4 8B C7 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 50 8D 4D E8 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D E8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC 8B D6 8B 43 18 8B 38 FF 57 18 8D 4D E4 8B D6 8B 43 18 8B 18 FF 53 0C 8B 55 E4 8B 45 FC E8 ?? ?? ?? ?? EB 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 00 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "TActionFieldValuesImpl.GetValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateValue"
		altNames = "TActionFieldValuesImpl.ValueOfField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_100025_0 {
	meta:
		name = "D2D_MATRIX_3X2_F.&op_Multiply"
		size = 24
		refs = "0010 TD2DMatrix3x2FHelper.SetProduct"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_70027_0 {
	meta:
		name = "GetStrProp"
		size = 24
		refs = "0010 GetUnicodeStrProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12693_0 {
	meta:
		name = "SubString"
		size = 24
		refs = "0010 TDBXStringBuffer.Substring"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "TActionFieldValuesImpl.GetOrigValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "TActionFieldValuesImpl.OrigValueOfField"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_96909_0 {
	meta:
		name = "TBaseAdapterAction.GetInputStyle"
		size = 24
		refs = "0010 TBaseAdapterAction.GetDisplayStyle"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12785_0 {
	meta:
		name = "TBaseFilterProperties.GetName"
		size = 24
		refs = "0010 TStrings.GetName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12786_0 {
	meta:
		name = "TBaseFilterProperties.GetValue"
		size = 24
		refs = "0010 TStrings.GetValueFromIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_115446_0 {
	meta:
		name = "TCustomXSLPageProducer.ProduceContentFromString"
		size = 24
		refs = "0010 TCustomXSLPageProducer.ContentFromString"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12716_0 {
	meta:
		name = "TDBXStringStore.GetString"
		size = 24
		refs = "0010 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_98714_0 {
	meta:
		name = "THTMLItemsObj.Item"
		size = 24
		refs = "0010 THTMLItemsObj.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_43792_0 {
	meta:
		name = "TIWMenu.RenderStyle"
		size = 24
		refs = "0010 TIWCustomControl.RenderStyle"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_33061_0 {
	meta:
		name = "TIdRR_SOA.GetName"
		size = 24
		refs = "0010 TIdTextModeResourceRecord.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_63160_0 {
	meta:
		name = "TIntegerBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_63156_0 {
	meta:
		name = "TObjectBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_82774_0 {
	meta:
		name = "TOleControl.GetVariantProp"
		size = 24
		refs = "0010 TOleControl.GetOleVariantProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_67317_0 {
	meta:
		name = "TRawVirtualClass.TVTable.AllocateRawThunk"
		size = 24
		refs = "0010 AllocFirstStageIntercept"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69761_0 {
	meta:
		name = "TRect.&op_Addition"
		size = 24
		refs = "0010 TRect.Union"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69762_0 {
	meta:
		name = "TRect.&op_Multiply"
		size = 24
		refs = "0010 TRect.Intersect"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69858_0 {
	meta:
		name = "TRectF.&op_Addition"
		size = 24
		refs = "0010 TRectF.Union"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69859_0 {
	meta:
		name = "TRectF.&op_Multiply"
		size = 24
		refs = "0010 TRectF.Intersect"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_98644_0 {
	meta:
		name = "TSessionObj.Values"
		size = 24
		refs = "0010 TSessionObj.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69682_0 {
	meta:
		name = "TTimeSpan.&op_Addition"
		size = 24
		refs = "0010 TTimeSpan.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_69716_0 {
	meta:
		name = "TTimeSpan.&op_Subtraction"
		size = 24
		refs = "0010 TTimeSpan.Subtract"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "TActionFieldValuesImpl.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001a TObject.Free 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B 46 14 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "TBasicActionRequestImpl.Create"
		size = 328
		refs = "0019 @ClassCreate 0028 @IntfAddRef 0030 TBasicActionRequestImpl.Create 003f TAbstractAdapterRequest.Create 004a @IntfCopy 0054 _DV_TAdapterRequestParamsImpl 0059 TAdapterRequestParamsImpl.Create 0064 @IntfClear 0073 Supports 008d @UStrAsg 00b0 TAbstractAdapterRequest.GetRequest 00b8 PageNameOfRequest 00fd @UStrArrayClr 0113 @HandleFinally 0120 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 84 C0 74 2C 8D 55 F4 8B 45 F8 8B 08 FF 51 0C 8B 55 F4 8D 46 14 E8 ?? ?? ?? ?? 8D 55 F0 8B 45 F8 8B 08 FF 51 10 8B 55 F0 8D 46 18 E8 ?? ?? ?? ?? 83 7E 14 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 46 14 E8 ?? ?? ?? ?? 83 7E 18 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8D 46 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 00 F4 78 D9 14 E9 D1 D4 11 A5 32 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_29_0 {
	meta:
		name = "TActiveScriptSite.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001a TObject.Free 0025 @ClassDestroy"
		altNames = "TBasicActionRequestImpl.Destroy TBasicImageRequestImpl.Destroy TConnectionAdmin.Destroy TMimeAttachHandlerImpl.Destroy TWebRequestFile.Destroy TWebSessionIDsImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48143_0 {
	meta:
		name = "TSessionItem.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TCollectionItem.Destroy 001a TObject.Free 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46261_0 {
	meta:
		name = "TTempFileStream.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TFileStream.Destroy 001a DeleteFile 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_30_0 {
	meta:
		name = "TBasicActionRequestImpl.GetActionName"
		size = 19
		altNames = "TBasicImageRequestImpl.GetImageName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 10 8B 08 FF 51 10 5E 5B C3 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "TAdapterDispatchParams.GetFailurePage"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TBaseWebPageInfo.GetPageTitle TBasicActionRequestImpl.GetFailurePage TDBXSocketChannelInfo.GetInfo TDSProxyParameter.GetTypeUnit THeaderInfo.GetEncodingStyle TPC1Cypher.GetEncryptionKey TRttiInstMethParameter.GetName TRttiIntfMethParameter.GetName TStreamLoader.GetPassword TTransportFilterItem.GetFilterId TXMLDataSet.GetDataSetField"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59438_0 {
	meta:
		name = "TAbstractObjectMemberGroup.GetBinding"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_32_0 {
	meta:
		name = "TBasicActionRequestImpl.GetHandled"
		size = 5
		altNames = "TCustomOwnedNode.GetReadOnly TDBXMySqlCustomMetaDataReader.IsDefaultCharSetUnicode TDSMethod.IsPublicMethod TIWBaseHTMLControlImplementation.GetVisible"
	strings:
		$1 = { 0F B6 40 1C C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "TActionFieldValueImpl.GetFieldName"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TActionLink.GetFailurePage TAdapterDispatchParams.GetSuccessPage TBaseWebPageInfo.GetPageDescription TBasicActionRequestImpl.GetSuccessPage TComServer.GetHelpFileName THeaderInfo.GetUse TNameContentScriptObject.GetContent TScriptError.GetFileName TStreamLoader.GetUserName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_112304_0 {
	meta:
		name = "TDomXPathFunctionCall.GetFunctionName"
		size = 19
		refs = "000c @WStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48045_0 {
	meta:
		name = "TScriptManager.GetXMLDocuments"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48082_0 {
	meta:
		name = "TXMLDocument.GetRowSets"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_34_0 {
	meta:
		name = "TBasicActionRequestImpl.SetHandled"
		size = 4
		altNames = "TCustomOwnedNode.SetReadOnly TIWBaseHTMLControlImplementation.SetVisible TSeriesPointer.Change3D TWebServExp.SetBindingType"
	strings:
		$1 = { 88 50 1C C3 }
	condition:
		$1
}

rule function_35_0 {
	meta:
		name = "TSingleRecordActionRequestImpl.Create"
		size = 532
		refs = "001c @ClassCreate 002d @IntfAddRef 0035 TSingleRecordActionRequestImpl.Create 0048 TBasicActionRequestImpl.Create 004f _Dn_TStringList 0054 TStringList.Create 006d TAbstractAdapterRequest.GetRequest 0072 TWebRequest.GetQueryFields 0089 TWebRequest.GetContentFields 00a0 TWebRequest.GetFiles 0128 Format 015d _DV_TActionFieldValuesImpl 0162 TActionFieldValuesImpl.Create 017d TObject.Free 0183 @HandleFinally 0196 _DV_TAdapterModes 019b TAdapterModes.Create 01bb @LStrArrayClr 01c3 @UStrClr 01cb @IntfClear 01e1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 DB 89 5D EC 89 5D D8 89 5D D4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 88 55 F7 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 AB 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 12 8B F0 4E 85 F6 0F 8C 8F 00 00 00 46 33 DB 8D 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D8 8B 08 FF 11 8B 45 D8 89 45 DC C6 45 E0 0B 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D4 8B 08 FF 51 04 8B 45 D4 89 45 E4 C6 45 E8 0B 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8B C8 8B 45 F0 5A 8B 38 FF 57 3C 43 4E 0F 85 74 FF FF FF 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B 45 F8 80 7D F7 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_36_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.Destroy"
		size = 52
		refs = "0003 @BeforeDestruction 0012 TBasicActionRequestImpl.Destroy 001a TObject.Free 002d @ClassDestroy"
		altNames = "TSingleRecordActionRequestImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 2C E8 ?? ?? ?? ?? 8B 46 30 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37_0 {
	meta:
		name = "TBasicActionResponseImpl.Create"
		size = 68
		refs = "000b @ClassCreate 001a TAbstractAdapterResponse.Create 0030 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 20 C6 47 0C 02 C6 47 0E 03 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_38_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCacheMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetExecuteStatus TCustomWrapper.GetWrapperType TDefaultDBScreenApplication.GetCursor TIWTestFramework.IsRecording TTransportFilter.IsHandshakeStarted"
	strings:
		$1 = { 0F B6 40 0C C3 }
	condition:
		$1
}

rule function_39_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCreateMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetHandled"
	strings:
		$1 = { 0F B6 40 0D C3 }
	condition:
		$1
}

rule function_40_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRespondWith"
		size = 5
		altNames = "TIBSQLMonitorHook.GetEnabled"
	strings:
		$1 = { 0F B6 40 0E C3 }
	condition:
		$1
}

rule function_41_0 {
	meta:
		name = "TBasicActionResponseImpl.SetExecuteStatus"
		size = 133
		refs = "000e TBasicActionResponseImpl.SetExecuteStatus 001e TBasicActionResponseImpl.GetRespondWith 0034 TBasicActionResponseImpl.GetFailurePage 0041 TBasicActionResponseImpl.RespondWithFailurePage 004d TBasicActionResponseImpl.GetSuccessPage 005a TBasicActionResponseImpl.RespondWithSuccessPage 0074 @UStrArrayClr 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 88 53 0C 8B C3 E8 ?? ?? ?? ?? 3C 03 75 38 0F B6 43 0C FE C8 75 19 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 20 8B C3 E8 ?? ?? ?? ?? EB 17 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_42_0 {
	meta:
		name = "TBasicActionResponseImpl.SetHandled"
		size = 4
		altNames = "TTIWHTMLEdGlyphs.SetSuperscript"
	strings:
		$1 = { 88 50 0D C3 }
	condition:
		$1
}

rule function_43_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithComponentPage"
		size = 8
	strings:
		$1 = { 89 50 1C C6 40 0E 02 C3 }
	condition:
		$1
}

rule function_44_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithPage"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 10 8B D6 E8 ?? ?? ?? ?? C6 43 0E 00 5E 5B C3 }
	condition:
		$1
}

rule function_45_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithURL"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 18 8B D6 E8 ?? ?? ?? ?? C6 43 0E 01 5E 5B C3 }
	condition:
		$1
}

rule function_46_0 {
	meta:
		name = "RespondWithPage"
		size = 188
		refs = "000b WebContext 002e TBasicActionResponseImpl.GetRedirectOptions 0034 TestRedirectOptions 0041 _Dn_TStringList 0046 TStringList.Create 0051 RespondWithPage 006a TAbstractAdapterResponse.GetResponse 0076 RedirectToPageName 008b TObject.Free 0091 @HandleFinally 00ae DispatchPageName"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F0 33 DB E8 ?? ?? ?? ?? 8B 10 FF 52 04 85 C0 74 22 E8 ?? ?? ?? ?? 8B 10 FF 52 04 0F B6 40 08 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D8 84 DB 74 59 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 05 ?? ?? ?? ?? 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 0F B6 0D ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_47_0 {
	meta:
		name = "TBasicActionResponseImpl.HandleResponse"
		size = 241
		refs = "0010 TBasicActionResponseImpl.HandleResponse 001e TBasicActionResponseImpl.GetRespondWith 0039 RaiseActionDoesNotProvideResponse 004d FindDefaultComponentOwnerPageName 0055 RespondWithPage 0066 RaiseActionCantRedirectToBlankURL 006e TAbstractAdapterResponse.GetResponse 008e SafeRedirect 00ac @LStrFromUStr 00d9 @LStrClr 00e1 @UStrClr 00e7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 2C 01 0F 82 91 00 00 00 74 30 FE C8 74 12 FE C8 0F 85 90 00 00 00 E8 ?? ?? ?? ?? E9 86 00 00 00 55 8D 55 F8 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 6C 8B 45 FC 83 78 18 00 75 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 0C 8B 40 08 8B 40 08 85 C0 7E 15 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 52 18 E8 ?? ?? ?? ?? EB 34 8B 45 FC E8 ?? ?? ?? ?? 50 8D 45 F4 8B 55 FC 8B 52 18 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 58 8B 08 FF 51 38 EB 0D 55 8B 45 FC 8B 40 10 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 }
	condition:
		$1
}

rule function_48_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRedirectOptions"
		size = 7
	strings:
		$1 = { 0F B6 50 14 8B C2 C3 }
	condition:
		$1
}

rule function_49_0 {
	meta:
		name = "TBasicActionResponseImpl.SetRedirectOptions"
		size = 13
	strings:
		$1 = { 51 88 14 24 0F B6 14 24 88 50 14 5A C3 }
	condition:
		$1
}

rule function_50_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithFailurePage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithFailurePage 001c TBasicActionResponseImpl.GetFailurePage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.FailureRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_51_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithSuccessPage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithSuccessPage 001c TBasicActionResponseImpl.GetSuccessPage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.SuccessRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_52_0 {
	meta:
		name = "TBasicActionResponseImpl.FailureRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.FailureRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_53_0 {
	meta:
		name = "TBasicActionResponseImpl.SuccessRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.SuccessRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_54_0 {
	meta:
		name = "TBasicActionResponseImpl.GetFailurePage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetFailurePage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_55_0 {
	meta:
		name = "TBasicActionResponseImpl.GetSuccessPage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetSuccessPage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59362_0 {
	meta:
		name = "TObjectWrapper.GetValue"
		size = 19
		refs = "000c TValue.&op_Implicit"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56_0 {
	meta:
		name = "GetModes"
		size = 292
		refs = "0015 GetModes 0043 TStrings.GetName 0055 @UStrCopy 0062 @UStrLAsg 0089 CompareText 00ea @UStrArrayClr 00fd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 10 FF 52 14 48 85 C0 0F 8C A4 00 00 00 40 89 45 F0 33 DB 8D 45 FC 50 8D 4D EC 8B D3 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 EC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 3B 45 F8 75 04 B0 01 EB 20 83 7D FC 00 74 06 83 7D F8 00 75 04 33 C0 EB 10 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 34 8D 45 E8 50 8D 4D E4 8B D3 8B 45 F4 8B 30 FF 56 0C 8B 45 E4 B9 FF FF FF 7F BA 06 00 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 08 8B 40 FC 8B 40 04 8B 08 FF 51 38 43 FF 4D F0 0F 85 62 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 61 00 6D 00 2E 00 00 00 }
	condition:
		$1
}

rule function_57_0 {
	meta:
		name = "TAdapterModes.Create"
		size = 111
		refs = "000e @ClassCreate 001f TObject.Create 0026 _Dn_TStringList 002b TStringList.Create 0039 TWebRequest.GetQueryFields 003e GetModes 0047 TWebRequest.GetContentFields 0059 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 89 45 FC 33 D2 8B 45 FC E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 04 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 FC 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_61_0 {
	meta:
		name = "TAdapterModes.FindAdapterMode"
		size = 260
		refs = "0021 TAdapterModes.FindAdapterMode 0033 @IntfClear 0041 Supports 0075 TStrings.GetName 0080 @UStrEqual 009d ExtractStringValue 00a8 @UStrAsg 00cc @UStrArrayClr 00d4 @UStrClr 00e2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 89 4D F0 8B DA 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 EF 00 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 6D 8D 55 F8 8B 45 FC 8B 08 FF 51 0C 8B 45 F4 8B 40 04 8B 10 FF 52 14 8B F0 4E 85 F6 7C 50 46 33 DB 8D 4D E8 8B 45 F4 8B 40 04 8B D3 E8 ?? ?? ?? ?? 8B 45 E8 8B 55 F8 E8 ?? ?? ?? ?? 75 2C 8D 4D E0 8B 45 F4 8B 40 04 8B D3 8B 30 FF 56 0C 8B 45 E0 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F0 E8 ?? ?? ?? ?? C6 45 EF 01 EB 04 43 4E 75 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 EF 5E 5B 8B E5 5D C3 00 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_62_0 {
	meta:
		name = "TAbstractWebPageModuleFactory.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001a TObject.Free 0025 @ClassDestroy"
		altNames = "TAdapterActionFieldValuesList.Destroy TAdapterModes.Destroy TLocateParamsList.Destroy TNotifyList.Destroy TScriptObjectFactories.Destroy TWebNotifyContainer.Destroy TWebRequestFiles.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_95553_0 {
	meta:
		name = "TWebDispatch.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001a TObject.Free 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_63_0 {
	meta:
		name = "TBasicImageRequestImpl.Create"
		size = 142
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TBasicImageRequestImpl.Create 0034 TAbstractAdapterRequest.Create 003f @IntfCopy 0049 _DV_TAdapterRequestParamsImpl 004e TAdapterRequestParamsImpl.Create 0066 @IntfClear 006c @HandleFinally 0079 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_66_0 {
	meta:
		name = "TBasicImageResponseImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractAdapterResponse.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16630_0 {
	meta:
		name = "DSAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16711_0 {
	meta:
		name = "DSMetadata.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_33294_0 {
	meta:
		name = "EIdException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_40473_0 {
	meta:
		name = "EInException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_98566_0 {
	meta:
		name = "TAbstractActiveScriptLanguages.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73536_0 {
	meta:
		name = "TActiveForm.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomActiveForm.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73526_0 {
	meta:
		name = "TActiveFormControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73527_0 {
	meta:
		name = "TActiveFormControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73386_0 {
	meta:
		name = "TActiveXControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73387_0 {
	meta:
		name = "TActiveXControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70868_0 {
	meta:
		name = "TAutoObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70869_0 {
	meta:
		name = "TAutoObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70959_0 {
	meta:
		name = "TAutoObjectEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70961_0 {
	meta:
		name = "TAutoObjectEvent.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28064_0 {
	meta:
		name = "TAzureBlobService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28113_0 {
	meta:
		name = "TAzureTableService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28375_0 {
	meta:
		name = "TBBlock.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBBlockList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28369_0 {
	meta:
		name = "TBPageRange.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBPageList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28361_0 {
	meta:
		name = "TBSignedIdentifier.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBSignedIdentifiers>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12776_0 {
	meta:
		name = "TBaseTransportFilterItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5551_0 {
	meta:
		name = "TBinaryField.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TField.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73736_0 {
	meta:
		name = "TBindCheckBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73713_0 {
	meta:
		name = "TBindComboBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73710_0 {
	meta:
		name = "TBindListBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73745_0 {
	meta:
		name = "TBindListComboBoxEditor.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBaseBindListListBoxEditor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73686_0 {
	meta:
		name = "TBindListListBoxEditor.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBaseBindListListBoxEditor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73730_0 {
	meta:
		name = "TBindListViewEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73733_0 {
	meta:
		name = "TBindStringGridEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1267_0 {
	meta:
		name = "TBinder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95583_0 {
	meta:
		name = "TCGIRequest.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebRequest.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_74274_0 {
	meta:
		name = "TCOMAdminCatalog.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_74321_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_74306_0 {
	meta:
		name = "TCOMAdminCatalogObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91319_0 {
	meta:
		name = "TCanvas3D.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6393_0 {
	meta:
		name = "TClassRegistryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_81158_0 {
	meta:
		name = "TColorLookup.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1511_0 {
	meta:
		name = "TCommonBindComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TContainedBindComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_63093_0 {
	meta:
		name = "TComponentList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObjectList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50674_0 {
	meta:
		name = "TConnectionIntercept.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdBaseComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1475_0 {
	meta:
		name = "TContainedBindComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_74998_0 {
	meta:
		name = "TConversion.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9607_0 {
	meta:
		name = "TConverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1865_0 {
	meta:
		name = "TCustomBindExpression.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBaseBindExpression.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_84902_0 {
	meta:
		name = "TCustomComboBoxStrings.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95478_0 {
	meta:
		name = "TCustomHTMLDragDropDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95490_0 {
	meta:
		name = "TCustomHTMLRegionDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15239_0 {
	meta:
		name = "TCustomRemoteServer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_87128_0 {
	meta:
		name = "TCustomStyleServices.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6242_0 {
	meta:
		name = "TDBByteBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7073_0 {
	meta:
		name = "TDBXAnsiMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26568_0 {
	meta:
		name = "TDBXAnsiStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7053_0 {
	meta:
		name = "TDBXAnsiStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26563_0 {
	meta:
		name = "TDBXBlobSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26557_0 {
	meta:
		name = "TDBXBooleanSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6403_0 {
	meta:
		name = "TDBXClientDriverLoader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TClassRegistryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7400_0 {
	meta:
		name = "TDBXClosedByteReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_11714_0 {
	meta:
		name = "TDBXColumnsTableCursor.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDelegateTable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7493_0 {
	meta:
		name = "TDBXConnectionBuilder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10764_0 {
	meta:
		name = "TDBXConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8288_0 {
	meta:
		name = "TDBXDataExpressMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXMetaDataProvider.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_11542_0 {
	meta:
		name = "TDBXDataExpressProviderContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26532_0 {
	meta:
		name = "TDBXDataGeneratedRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26572_0 {
	meta:
		name = "TDBXDataGeneratorException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26573_0 {
	meta:
		name = "TDBXDateSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26580_0 {
	meta:
		name = "TDBXDecimalSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26585_0 {
	meta:
		name = "TDBXDoubleSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12889_0 {
	meta:
		name = "TDBXIdTCPLayer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TFactoryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26590_0 {
	meta:
		name = "TDBXInt16SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26595_0 {
	meta:
		name = "TDBXInt32SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26600_0 {
	meta:
		name = "TDBXInt64SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26605_0 {
	meta:
		name = "TDBXInt8SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7538_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_11615_0 {
	meta:
		name = "TDBXMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8876_0 {
	meta:
		name = "TDBXMethodTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8171_0 {
	meta:
		name = "TDBXNoOpRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXStreamerRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12871_0 {
	meta:
		name = "TDBXSocketChannel.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12695_0 {
	meta:
		name = "TDBXStringBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7182_0 {
	meta:
		name = "TDBXStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWideStringValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8190_0 {
	meta:
		name = "TDBXTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXTableRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8188_0 {
	meta:
		name = "TDBXTableRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26610_0 {
	meta:
		name = "TDBXTimeSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26617_0 {
	meta:
		name = "TDBXTimestampSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6813_0 {
	meta:
		name = "TDBXTransaction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6654_0 {
	meta:
		name = "TDBXValueType.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7175_0 {
	meta:
		name = "TDBXWideMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26628_0 {
	meta:
		name = "TDBXWideStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7152_0 {
	meta:
		name = "TDBXWideStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6830_0 {
	meta:
		name = "TDBXWritableValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7646_0 {
	meta:
		name = "TDBXWritableValueList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26026_0 {
	meta:
		name = "TDCOMConnection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDispatchConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22598_0 {
	meta:
		name = "TDSAdminRestClient.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSRestClient.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16626_0 {
	meta:
		name = "TDSCustomAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15620_0 {
	meta:
		name = "TDSCustomProxyGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16750_0 {
	meta:
		name = "TDSCustomServerClass.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16738_0 {
	meta:
		name = "TDSServerCommandHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16747_0 {
	meta:
		name = "TDSServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16808_0 {
	meta:
		name = "TDSServerMethod.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16829_0 {
	meta:
		name = "TDSServerMethodProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16881_0 {
	meta:
		name = "TDSVoidConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48996_0 {
	meta:
		name = "TDataContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59477_0 {
	meta:
		name = "TDynamicObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "TEnumDispatcherAS.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomEnumDispatcher.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12780_0 {
	meta:
		name = "TFactoryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_80378_0 {
	meta:
		name = "TGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31606_0 {
	meta:
		name = "TIBValidationService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIBControlAndQueryService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_96544_0 {
	meta:
		name = "TISAPIFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_44051_0 {
	meta:
		name = "TIWCustomControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIWVCLBaseControl.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_32301_0 {
	meta:
		name = "TIdBaseComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdInitializerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_33271_0 {
	meta:
		name = "TIdEMailAddressItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_33730_0 {
	meta:
		name = "TIdFTPRegParseList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34772_0 {
	meta:
		name = "TIdHash.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35695_0 {
	meta:
		name = "TIdIRCReplies.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_36149_0 {
	meta:
		name = "TIdMessageDecoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_36156_0 {
	meta:
		name = "TIdMessageEncoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38008_0 {
	meta:
		name = "TIdNotify.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35039_0 {
	meta:
		name = "TIdProxyConnectionInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_37978_0 {
	meta:
		name = "TIdStruct.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38005_0 {
	meta:
		name = "TIdSync.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_39163_0 {
	meta:
		name = "TInBaseComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdInitializerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_40886_0 {
	meta:
		name = "TInHash.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_42020_0 {
	meta:
		name = "TInSync.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59390_0 {
	meta:
		name = "TIndexedObjectPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48246_0 {
	meta:
		name = "TInternetExplorer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48333_0 {
	meta:
		name = "TInternetExplorerMedium.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9319_0 {
	meta:
		name = "TJSONException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9353_0 {
	meta:
		name = "TJSONNumber.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONString.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9320_0 {
	meta:
		name = "TJSONPair.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9340_0 {
	meta:
		name = "TJSONString.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28389_0 {
	meta:
		name = "TLeaseItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50735_0 {
	meta:
		name = "TLogDetail.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomForm.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_49461_0 {
	meta:
		name = "TLogLinkedWebNode.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TLinkedWebNode.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47657_0 {
	meta:
		name = "TMaster.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_98796_0 {
	meta:
		name = "TModuleObj.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponentsEnumerator.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47570_0 {
	meta:
		name = "TOLECtrl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59416_0 {
	meta:
		name = "TObjectFieldInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59409_0 {
	meta:
		name = "TObjectMethodInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59376_0 {
	meta:
		name = "TObjectPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73592_0 {
	meta:
		name = "TOleGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TGraphic.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47716_0 {
	meta:
		name = "TOutlookApplication.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59400_0 {
	meta:
		name = "TPhysicalObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47595_0 {
	meta:
		name = "TPowerPointApplication.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47493_0 {
	meta:
		name = "TPowerPointPresentation.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47452_0 {
	meta:
		name = "TPowerPointSlide.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47939_0 {
	meta:
		name = "TPowerRex.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_73556_0 {
	meta:
		name = "TPropertyPageImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAggregatedObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9614_0 {
	meta:
		name = "TReverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48504_0 {
	meta:
		name = "TShellNameSpace.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48444_0 {
	meta:
		name = "TShellUIHelper.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_48422_0 {
	meta:
		name = "TShellWindows.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_62340_0 {
	meta:
		name = "TStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_92885_0 {
	meta:
		name = "TTeeExportFormat.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_49484_0 {
	meta:
		name = "TTypeTranslator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70861_0 {
	meta:
		name = "TTypedComObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70862_0 {
	meta:
		name = "TTypedComObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59422_0 {
	meta:
		name = "TVirtualObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_39050_0 {
	meta:
		name = "TWebBrowserSearchFindFirst.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebBrowserSearchFind.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47296_0 {
	meta:
		name = "TWebButton.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebContainedComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_97349_0 {
	meta:
		name = "TWebComponentsStub.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TScriptComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_98812_0 {
	meta:
		name = "TWebUserItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_70749_0 {
	meta:
		name = "TWideStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_114748_0 {
	meta:
		name = "TXMLDocument.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50304_0 {
	meta:
		name = "TXSBaseDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50372_0 {
	meta:
		name = "TXSDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TRemotable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50408_0 {
	meta:
		name = "TXSDuration.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TRemotable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_85450_0 {
	meta:
		name = "TseBitmapList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_67_0 {
	meta:
		name = "TActionFieldValueImpl.Create"
		size = 245
		refs = "0016 @ClassCreate 0025 TActionFieldValueImpl.Create 0035 @UStrAsg 003e _Dn_TObjectList 0043 TObjectList.Create 004d _Dn_TStringList 0052 TStringList.Create 0092 TList.Add 00c7 @UStrClr 00cd @HandleFinally 00dc @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FF 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 14 8B D3 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 83 7D 08 00 74 57 8B 45 08 8B 10 FF 52 14 48 85 C0 7C 4A 40 89 45 F8 33 DB 8B D3 8B 45 08 8B 08 FF 51 18 85 C0 74 18 8B 7E 10 8B D3 8B 45 08 8B 08 FF 51 18 8B D0 8B C7 E8 ?? ?? ?? ?? EB 18 8D 4D F4 8B D3 8B 45 08 8B 38 FF 57 0C 8B 55 F4 8B 46 0C 8B 08 FF 51 38 43 FF 4D F8 75 BC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_68_0 {
	meta:
		name = "TActionFieldValueImpl.Destroy"
		size = 52
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001a TObject.Free 002d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_70_0 {
	meta:
		name = "TActionFieldValueImpl.GetFile"
		size = 34
		refs = "000c TList.Get 0016 _Dn_TAbstractWebRequestFile 001b @AsClass"
	strings:
		$1 = { 53 56 8B 58 10 8B F2 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_72_0 {
	meta:
		name = "TActionFieldValueImpl.GetValue"
		size = 93
		refs = "0018 TActionFieldValueImpl.GetValue 0036 @VarFromUStr 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 0C 8B 18 FF 53 0C 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_73_0 {
	meta:
		name = "TActionFieldValueImpl.GetValueCount"
		size = 9
		altNames = "TBindEditLinkObserver.GetUpdating TIdHeaderListPeer.GetCount TIdTextModeResourceRecord.ItemCount TWebPageInfoWrapper.GetPageIsPublished TXMLNodeList.GetCount"
	strings:
		$1 = { 8B 40 0C 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_74_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.Create"
		size = 164
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMultiRecordActionRequestImpl.Create 0037 TBasicActionRequestImpl.Create 003e TAbstractAdapterRequest.GetRequest 0047 _DV_TAdapterActionFieldValuesList 004c TAdapterActionFieldValuesList.Create 005f _DV_TAdapterModes 0064 TAdapterModes.Create 007c @IntfClear 0082 @HandleFinally 008f @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 2C 8B C6 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.GetFieldValues"
		size = 17
		refs = "0006 TMultiRecordActionRequestImpl.GetFieldValuesList 000b TEnumActionFieldValueRecordsImpl.GetCurrentFieldValues"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_63997_0 {
	meta:
		name = "ChDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b ChDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_66829_0 {
	meta:
		name = "GetValueStackSize"
		size = 17
		refs = "0006 TValue.GetDataSize 000b Align4"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_64004_0 {
	meta:
		name = "MkDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b MkDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_64014_0 {
	meta:
		name = "RmDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b RmDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_97317_0 {
	meta:
		name = "TCustomAdapterGotoPageAction.GetItemCount"
		size = 17
		refs = "0006 TCustomPagedAdapterAction.GetAdapter 000b TDefaultFieldsPagedAdapter.GetPageCount"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10766_0 {
	meta:
		name = "TDBXConnectionHandler.GetCommandHandle"
		size = 17
		refs = "0006 TDBXConnectionHandler.InvalidOperationError 000b @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10767_0 {
	meta:
		name = "TDBXConnectionHandler.SetCommandHandle"
		size = 17
		refs = "0006 TDBXConnectionHandler.InvalidOperationError 000b @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_78492_0 {
	meta:
		name = "TDirect2DFont.GetColor"
		size = 17
		refs = "0006 TDirect2DFont.GetBrush 000b TDirect2DBrush.GetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_78482_0 {
	meta:
		name = "TDirect2DPen.GetColor"
		size = 17
		refs = "0006 TDirect2DPen.GetBrush 000b TDirect2DBrush.GetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5116_0 {
	meta:
		name = "TFieldDef.AddChild"
		size = 17
		refs = "0006 TFieldDef.GetChildDefs 000b TFieldDefs.AddFieldDef"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30333_0 {
	meta:
		name = "TIBCustomDataSet.PSInTransaction"
		size = 17
		refs = "0006 TIBCustomDataSet.GetTransaction 000b TIBTransaction.GetInTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44163_0 {
	meta:
		name = "TIWCustomControl.SupportsInput"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWBaseComponentImplementation.SupportsInput"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44164_0 {
	meta:
		name = "TIWCustomControl.SupportsSubmit"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWBaseComponentImplementation.SupportsSubmit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44160_0 {
	meta:
		name = "TIWCustomControl.get_HTMLLeft"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWHTMLControlImplementation.GetHTMLLeft"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44161_0 {
	meta:
		name = "TIWCustomControl.get_HTMLTop"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWHTMLControlImplementation.GetHTMLTop"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44170_0 {
	meta:
		name = "TIWCustomControl.get_SupportsPartial"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWHTMLControlImplementation.get_SupportsPartial"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_44114_0 {
	meta:
		name = "TIWCustomControl.get_WebCursor"
		size = 17
		refs = "0006 TIWCustomControl.HTMLControlImplementation 000b TIWHTMLControlImplementation.GetCursor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_34993_0 {
	meta:
		name = "TIdCustomHTTP.GetResponseCode"
		size = 17
		refs = "0006 TIdCustomHTTP.GetResponse 000b TIdHTTPResponse.GetResponseCode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75162_0 {
	meta:
		name = "TListItem.GetHandle"
		size = 17
		refs = "0006 TListItem.GetListView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_66163_0 {
	meta:
		name = "TPath.IsExtendedPrefixed"
		size = 17
		refs = "0006 TPath.GetExtendedPrefix 000b TPath.PrefixExtendsPath"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_66995_0 {
	meta:
		name = "TRttiType.GetIsManaged"
		size = 17
		refs = "0006 TRttiType.GetHandle 000b IsManaged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_67009_0 {
	meta:
		name = "TRttiType.GetTypeData"
		size = 17
		refs = "0006 TRttiType.GetHandle 000b GetTypeData"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_50888_0 {
	meta:
		name = "TSyncController.EndUpdate"
		size = 17
		refs = "0006 TSyncController.GetGraph 000b TGraph.EndUpdate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74664_0 {
	meta:
		name = "TTreeNode.GetHandle"
		size = 17
		refs = "0006 TTreeNode.GetTreeView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77_0 {
	meta:
		name = "MoveValues"
		size = 157
		refs = "002e TList.Get 0037 TList.Add 0079 TList.ExtractItem"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B 43 0C 8B 55 FC 8B 08 FF 51 38 8B 46 10 89 45 F8 89 7D F4 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 53 10 92 E8 ?? ?? ?? ?? 8B 46 14 89 45 F0 89 7D EC 8B 55 EC 8B 45 F0 E8 ?? ?? ?? ?? 8B 53 14 92 E8 ?? ?? ?? ?? 8B D7 8B 46 0C 8B 08 FF 51 48 8B 5E 10 89 7D E8 8B 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 56 10 33 C9 92 E8 ?? ?? ?? ?? 8B 5E 14 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 56 14 33 C9 92 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_78_0 {
	meta:
		name = "NameAndIndex"
		size = 192
		refs = "0012 NameAndIndex 0021 @UStrAsg 0033 Pos 005a @UStrCopy 0062 StrToInt 0072 @UStrDelete 0081 @HandleAnyException 0086 @DoneExcept 009b @UStrClr 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B D6 E8 ?? ?? ?? ?? C7 07 FF FF FF FF 8B 13 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 7E 4D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 56 01 8B 03 B9 FF FF FF 7F E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 07 8B C3 B9 FF FF FF 7F 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_79_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.Create"
		size = 465
		refs = "0016 @ClassCreate 0026 TEnumActionFieldValueRecordsImpl.Create 0035 _Dn_TObjectList 003a TObjectList.Create 004d @UStrAsg 008b _Dn_TStrings 0090 TObject.InheritsFrom 00bb _Dn_TStringList 00c0 TStringList.Create 00e7 @AsClass 0135 _DV_TActionFieldValuesImpl 013a TActionFieldValuesImpl.Create 0143 TList.Add 0158 TObject.Free 015e @HandleFinally 01a1 @UStrClr 01b7 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FB 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 08 8B 45 FC 83 C0 04 8B D3 E8 ?? ?? ?? ?? 83 7D 08 00 0F 84 17 01 00 00 8B 45 08 8B 10 FF 52 14 85 C0 0F 8E 07 01 00 00 33 D2 8B 45 08 8B 08 FF 51 18 85 C0 0F 84 F5 00 00 00 33 D2 8B 45 08 8B 08 FF 51 18 8B 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D6 00 00 00 8B 45 08 8B 10 FF 52 14 48 85 C0 0F 8C E3 00 00 00 40 89 45 EC C7 45 F4 00 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F4 8B 45 08 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B C6 8B 10 FF 52 14 48 85 C0 7C 30 40 89 45 E8 33 DB 8D 4D E4 8B D3 8B C6 8B 38 FF 57 0C 8B 45 E4 50 8B D3 8B C6 8B 08 FF 51 18 8B C8 8B 45 F0 5A 8B 38 FF 57 3C 43 FF 4D E8 75 D6 8B 45 FC 8B 58 08 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 FF 45 F4 FF 4D EC 0F 85 48 FF FF FF EB 1E 8B 45 FC 8B 58 08 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 80 7D FB 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_80_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001a TObject.Free 0025 @ClassDestroy"
		altNames = "TLocateParams.Destroy TSchemaIterator.Destroy TScriptGlobalObjects.Destroy TWebModuleFactoryList.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.FindPopulatedRecord"
		size = 84
		refs = "0021 TList.Get 002b _DV_TActionFieldValuesImpl 0030 @AsClass 0039 TActionFieldValuesImpl.GetFieldCount"
	strings:
		$1 = { 53 56 57 55 51 8B F8 8B 47 08 8B 70 08 4E 85 F6 7C 3A 46 33 DB 8B 6F 08 89 1C 24 8B 14 24 8B C5 E8 ?? ?? ?? ?? 8B E8 8B C5 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B C5 E8 ?? ?? ?? ?? 85 C0 7E 07 89 5F 0C B0 01 EB 06 43 4E 75 C9 33 C0 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_82_0 {
	meta:
		name = "TBindingManager.GetExprCount"
		size = 7
		altNames = "TCollection.GetCount TDSCacheResultCommandHandler.GetCommandCount TDSCallbackTunnel.CallbackCount TDSCommandComplexParams.GetParameterCount TEnumActionFieldValueRecordsImpl.GetRecordCount TJSONNumber.EstimatedByteSize TWebComponentList.GetCount TWebModuleFactoryList.GetItemCount TWebModuleList.GetItemCount"
	strings:
		$1 = { 8B 40 08 8B 40 08 C3 }
	condition:
		$1
}

rule function_83_0 {
	meta:
		name = "TAbstractTest.GetEnabled"
		size = 5
		altNames = "TDBXConnection.GetIsOpen TDBXDataExpressProviderContext.GetMarkerIncludedInParameterName TDSClass.IsArrayParameter TEnumActionFieldValueRecordsImpl.GetInIterator TGIFGraphicControlExtension.GetTransparentColorIndex THeaderInfo.GetRequired TParamObject.GetDataType"
	strings:
		$1 = { 0F B6 40 10 C3 }
	condition:
		$1
}

rule function_84_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetCurrentFieldValues"
		size = 49
		refs = "0016 TList.Get 0020 _DV_TActionFieldValuesImpl 0025 @AsClass"
	strings:
		$1 = { 53 56 8B 50 08 8B 4A 08 8B 70 0C 3B CE 7E 1D 8B DA 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_85_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetEOF"
		size = 13
	strings:
		$1 = { 8B 50 08 8B 52 08 3B 50 0C 0F 9E C0 C3 }
	condition:
		$1
}

rule function_86_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetFirstRecord"
		size = 22
		refs = "000b TEnumActionFieldValueRecordsImpl.GetEOF"
	strings:
		$1 = { 53 8B D8 33 C0 89 43 0C 8B C3 E8 ?? ?? ?? ?? 34 01 88 43 10 5B C3 }
	condition:
		$1
}

rule function_87_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetNextRecord"
		size = 20
		refs = "0009 TEnumActionFieldValueRecordsImpl.GetEOF"
	strings:
		$1 = { 53 8B D8 FF 43 0C 8B C3 E8 ?? ?? ?? ?? 34 01 88 43 10 5B C3 }
	condition:
		$1
}

rule function_88_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.EndIterator"
		size = 10
	strings:
		$1 = { C6 40 10 00 33 D2 89 50 0C C3 }
	condition:
		$1
}

rule function_89_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetRecord"
		size = 19
	strings:
		$1 = { 8B 48 08 3B 51 08 0F 9C C1 84 C9 74 03 89 50 0C 8B C1 C3 }
	condition:
		$1
}

rule function_90_0 {
	meta:
		name = "TActionFieldValuesImpl.ExpandRecordKeys"
		size = 105
		refs = "000d TActionFieldValuesImpl.ExpandRecordKeys 0043 ExtractParamNameValues 0058 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 04 8B 10 FF 52 14 85 C0 7E 24 8B 43 08 8B 10 FF 52 14 85 C0 75 18 8D 4D FC 33 D2 8B 43 04 8B 30 FF 56 0C 8B 45 FC 8B 53 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyCount"
		size = 20
		refs = "0006 TActionFieldValuesImpl.ExpandRecordKeys"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 08 8B 10 FF 52 14 5B C3 }
	condition:
		$1
}

rule function_92_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyName"
		size = 25
		refs = "0011 TStrings.GetName"
		altNames = "TLocateParams.GetParamName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_6621_0 {
	meta:
		name = "TDBXProperties.GetValue"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyValue"
		size = 93
		refs = "0018 TActionFieldValuesImpl.GetRecordKeyValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 08 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_26463_0 {
	meta:
		name = "TLocateParams.GetParamValue"
		size = 93
		refs = "0018 TLocateParams.GetParamValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 08 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "NewStrings"
		size = 36
		refs = "0007 _Dn_TStringList 000c TStringList.Create 001b TList.Add"
	strings:
		$1 = { 55 8B EC 53 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "FindAdapterStrings"
		size = 94
		refs = "0020 NewStrings 0051 _Dn_TStrings 0056 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B F0 8B 45 08 8B 40 F8 8B D6 8B 08 FF 51 54 8B D8 83 FB FF 75 27 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B C8 8B 45 08 8B 40 F8 8B D6 8B 18 FF 53 3C 8B 45 08 8B 40 F8 8B 10 FF 52 14 8B D8 4B 8B 45 08 8B 40 F8 8B D3 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "FindAdapterRecordStrings"
		size = 108
		refs = "0034 NewStrings 005a _Dn_TStrings 005f @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 85 F6 7C 57 8B C3 8B 10 FF 52 14 85 C0 7E 2B 33 D2 8B C3 8B 08 FF 51 18 85 C0 75 1E 8B C3 8B 10 FF 52 44 EB 15 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B C8 33 D2 8B C3 8B 38 FF 57 3C 8B C3 8B 10 FF 52 14 3B F0 7D E0 8B D6 8B C3 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 8B C3 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "ExtractRecordIndex"
		size = 188
		refs = "0014 ExtractRecordIndex 002d Pos 0054 @UStrCopy 005c StrToInt 006d @UStrDelete 007c @HandleAnyException 0081 @DoneExcept 0096 @UStrClr 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 FC FF FF FF FF 8B 16 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7E 4E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 8D 53 01 8B 06 B9 FF FF FF 7F E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 8B C6 B9 FF FF FF 7F 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_98_0 {
	meta:
		name = "ExtractAdapterName"
		size = 84
		refs = "000a @UStrClr 0011 ExtractAdapterName 0016 Pos 002c @UStrCopy 003a @UStrDelete"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B C7 E8 ?? ?? ?? ?? 8B 16 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7E 1E 57 8B CB 49 8B 06 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C6 8B CB BA 01 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_99_0 {
	meta:
		name = "TAdapterActionFieldValuesList.Create"
		size = 1344
		refs = "001f @ClassCreate 0030 TAdapterActionFieldValuesList.Create 0040 TObject.Create 0049 _Dn_TObjectList 004e TObjectList.Create 0079 NewStrings 0085 TWebRequest.GetQueryFields 0097 TWebRequest.GetContentFields 00a9 TWebRequest.GetFiles 011e Format 017b @UStrClr 0188 TStrings.GetName 019e @UStrCopy 01ab @UStrLAsg 01d2 CompareText 01ed @UStrDelete 01fc ExtractAdapterName 0204 ExtractRecordIndex 02b0 @UStrEqual 02e8 FindAdapterStrings 02f2 FindAdapterRecordStrings 0325 ExtractStringValue 0357 @UStrCat3 03ed _DV_TEnumActionFieldValueRecordsImpl 03f2 TEnumActionFieldValueRecordsImpl.Create 03fb TList.Add 0428 _Dn_TStrings 042d @AsClass 046d TObject.Free 0473 @HandleFinally 048f @UStrArrayClr 049c @LStrArrayClr 04c7 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D D0 88 55 D7 89 45 D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B 45 D8 E8 ?? ?? ?? ?? B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 D8 89 42 04 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 55 E8 ?? ?? ?? ?? 59 89 45 CC 8B 45 D0 E8 ?? ?? ?? ?? 8B D0 8B 45 CC 8B 08 FF 51 40 8B 45 D0 E8 ?? ?? ?? ?? 8B D0 8B 45 CC 8B 08 FF 51 40 8B 45 D0 E8 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 8B 45 D0 E8 ?? ?? ?? ?? 8B 10 FF 12 8B F0 4E 85 F6 7C 7C 46 33 DB 8D 45 B8 50 8B 45 D0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 A4 8B 08 FF 11 8B 45 A4 89 45 A8 C6 45 AC 0B 8B 45 D0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 A0 8B 08 FF 51 04 8B 45 A0 89 45 B0 C6 45 B4 0B 8D 55 A8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 B8 50 8B 45 D0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8B C8 8B 45 CC 5A 8B 38 FF 57 3C 43 4E 75 87 55 E8 ?? ?? ?? ?? 59 89 45 F8 8B 45 CC 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C 73 02 00 00 46 33 DB C6 45 C7 00 C6 45 C6 00 C6 45 C5 00 C7 45 C8 FF FF FF FF 8D 45 F0 E8 ?? ?? ?? ?? 8D 4D F4 8B D3 8B 45 CC E8 ?? ?? ?? ?? 8D 45 E8 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8D 45 E4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 3B 45 E4 75 04 B0 01 EB 20 83 7D E8 00 74 06 83 7D E4 00 75 04 33 C0 EB 10 8B 55 E4 8B 45 E8 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 31 8D 45 F4 B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? C6 45 C7 01 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 89 45 C8 E9 C0 00 00 00 8D 45 E0 50 B9 06 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8D 45 DC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 3B 45 DC 75 04 B0 01 EB 20 83 7D E0 00 74 06 83 7D DC 00 75 04 33 C0 EB 10 8B 55 DC 8B 45 E0 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 2E C6 45 C6 01 8D 45 F4 B9 06 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 89 45 C8 EB 3F 8D 45 9C 50 B9 02 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 9C BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 1A C6 45 C5 01 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 89 45 C8 0F B6 45 C7 0A 45 C6 75 0A 80 7D C5 00 0F 84 E9 00 00 00 55 8B 45 F0 E8 ?? ?? ?? ?? 59 55 8B 55 C8 E8 ?? ?? ?? ?? 59 89 45 C0 0F B6 45 C7 0A 45 C5 74 5A 8D 45 EC 50 8B 45 F4 89 45 A8 C6 45 AC 11 8D 4D 94 8B D3 8B 45 CC 8B 38 FF 57 0C 8B 45 94 8D 55 98 E8 ?? ?? ?? ?? 8B 45 98 89 45 B0 C6 45 B4 11 8D 55 A8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D C7 00 74 6A 8D 45 EC 8B 4D EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 8D 45 EC 50 8B 45 F0 89 45 A8 C6 45 AC 11 8D 4D 8C 8B D3 8B 45 CC 8B 38 FF 57 0C 8B 45 8C 8D 55 90 E8 ?? ?? ?? ?? 8B 45 90 89 45 B0 C6 45 B4 11 8D 55 A8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D C6 00 74 10 8D 45 EC 8B 4D EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 45 CC 8B 08 FF 51 18 8B C8 8B 55 EC 8B 45 C0 8B 38 FF 57 3C 43 4E 0F 85 90 FD FF FF 8B 45 F8 8B 10 FF 52 14 85 C0 75 21 8B 45 D8 8B 58 04 6A 00 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? EB 5B 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 7C 4C 46 33 DB 8B 45 D8 8B 40 04 89 45 BC 8B D3 8B 45 F8 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 4D 88 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 4D 88 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 BC E8 ?? ?? ?? ?? 43 4E 75 B7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 88 BA 06 00 00 00 E8 ?? ?? ?? ?? 8D 45 A0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 B8 E8 ?? ?? ?? ?? 8D 45 DC BA 07 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C9 8B 45 D8 80 7D D7 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 D8 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 6F 00 76 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 5F 00 5F 00 6B 00 65 00 79 00 2E 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 5F 00 5F 00 00 00 00 00 }
	condition:
		$1
}

rule function_101_0 {
	meta:
		name = "TAdapterActionFieldValuesList.GetCurrentFieldValuesList"
		size = 49
		refs = "0016 TList.Get 0020 _DV_TEnumActionFieldValueRecordsImpl 0025 @AsClass"
	strings:
		$1 = { 53 56 8B 50 04 8B 4A 08 8B 70 08 3B CE 7E 1D 8B DA 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_102_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.GetFieldValuesList"
		size = 9
		refs = "0004 TAdapterActionFieldValuesList.GetCurrentFieldValuesList"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_82972_0 {
	meta:
		name = "TOutlineStrings.Clear"
		size = 9
		refs = "0004 TCustomOutline.Clear"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_82971_0 {
	meta:
		name = "TOutlineStrings.GetCount"
		size = 9
		refs = "0004 TCustomOutline.GetItemCount"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80984_0 {
	meta:
		name = "TStringGridStrings.SetUpdateState"
		size = 9
		refs = "0004 TStringGrid.SetUpdateState"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80967_0 {
	meta:
		name = "TStringSparseList.Exchange"
		size = 9
		refs = "0004 TSparseList.Exchange"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_98721_0 {
	meta:
		name = "TStringsObj.SetCommaText"
		size = 9
		refs = "0004 TStrings.SetCommaText"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_98723_0 {
	meta:
		name = "TStringsObj.SetValues"
		size = 9
		refs = "0004 TStrings.SetValue"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74779_0 {
	meta:
		name = "TTreeStrings.Clear"
		size = 9
		refs = "0004 TTreeNodes.Clear"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74778_0 {
	meta:
		name = "TTreeStrings.GetCount"
		size = 9
		refs = "0004 TTreeNodes.GetCount"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_103_0 {
	meta:
		name = "TAdapterActionFieldValuesList.LocateActionFieldValuesOfAdapter"
		size = 304
		refs = "0018 TAdapterActionFieldValuesList.LocateActionFieldValuesOfAdapter 002a @IntfClear 003f Supports 0076 TList.Get 0080 _DV_TEnumActionFieldValueRecordsImpl 0085 @AsClass 0092 @UStrLAsg 00c4 CompareText 00f7 @UStrArrayClr 0107 @UStrClr 010d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B F2 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 EB 00 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C6 85 C0 74 03 83 E8 CC E8 ?? ?? ?? ?? 84 C0 0F 84 96 00 00 00 8D 55 FC 8B 45 F8 8B 08 FF 51 0C 8B 45 EC 8B 40 04 8B 58 08 4B 85 DB 7C 7D 43 33 F6 8B 45 EC 8B 78 04 89 75 E4 8B 55 E4 8B C7 E8 ?? ?? ?? ?? 8B F8 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8D 45 F4 8B 57 04 E8 ?? ?? ?? ?? 8D 45 F0 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F4 3B 45 F0 75 04 B0 01 EB 20 83 7D F4 00 74 06 83 7D F0 00 75 04 33 C0 EB 10 8B 55 F0 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 0C C6 45 EB 01 8B 45 EC 89 70 08 EB 04 46 4B 75 86 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 EB 5F 5E 5B 8B E5 5D C3 00 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_105_0 {
	meta:
		name = "AdaptReq"
		size = 8
		refs = "0002 _DV_41"
		altNames = "BindingGraphViewNodes DSAzureQueue Data.Bind.Editors Data.DBXDynalinkNative Data.DBXMSSQLMetaDataReader Data.DBXMessageHandlerServer Data.DBXSybaseASAMetaDataReader Data.DBXSybaseASEMetaDataReader Datasnap.DSProxyWriter Datasnap.DataBkr Datasnap.Provider IBScript IWBaseControl IWBaseRenderContext IWCompCalendar IWCompObject IWContainerBorderOptions IWControl IWDBExtCtrls IWDBGrids IWDsnTreeView IWRenderContext IdAuthenticationManager IdBuffer IdCommandHandlers IdCustomTransparentProxy IdEMailAddress IdFTPList IdGopher IdIRC IdIcmpClient IdIntercept IdLPR IdMappedFTP IdMappedTelnet IdMessageParts IdOTPCalculator IdReply IdReplyFTP IdReplyRFC IdSocksServer IdStruct IdSync IdTelnetServer IdUDPBase IdUDPServer IdVCard InBuffer InCustomTransparentProxy InIntercept InReply InReplyRFC InSync InUDPBase InUDPServer Office2000 ReqFiles SHDocVw Soap.IntfInfo Soap.SOAPHTTPTrans Soap.WSDLNode SockAppNotify SockHTTP SockRequestInterpreter System.Bindings.Expression System.WideStrings System.Win.ScktComp VCLTee.TeeChartGrid VCLTee.TeeData VCLTee.TeeEdiGrad VCLTee.TeePreviewPanel Vcl.DBCGrids Vcl.DBOleCtl Vcl.RibbonStyleActnCtrls Vcl.ScreenTips Vcl.Tabs Vcl.ToolWin Vcl.Touch.GestureMgr Vcl.ValEdit WebAuto WebContnrs Winapi.GDIPAPI XSLProd Xml.Internal.UriUtils"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115_0 {
	meta:
		name = "ADODB2000"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_129_0 {
	meta:
		name = "ADODB2010"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_139_0 {
	meta:
		name = "ADODBXP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_184_0 {
	meta:
		name = "ASPBehavior"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_141_0 {
	meta:
		name = "AscrLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "AutoAdap"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "AzureUI"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "BDE"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "Bde.Bdeconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "Bde.DBBdeWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1254_0 {
	meta:
		name = "Bde.DrTable"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1256_0 {
	meta:
		name = "Bde.SMINTF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1309_0 {
	meta:
		name = "Binder2000"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1311_0 {
	meta:
		name = "BindingGraphResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1327_0 {
	meta:
		name = "ComApp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1335_0 {
	meta:
		name = "CompProd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1337_0 {
	meta:
		name = "CtlConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1392_0 {
	meta:
		name = "DAO2000"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1412_0 {
	meta:
		name = "DAO2010"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1432_0 {
	meta:
		name = "DAOXP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26481_0 {
	meta:
		name = "DBAdapt"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26633_0 {
	meta:
		name = "DBXCustomDataGenerator"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26670_0 {
	meta:
		name = "DBXDBMetaData"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26694_0 {
	meta:
		name = "DBXTestResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26719_0 {
	meta:
		name = "DSAzDlgACL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26731_0 {
	meta:
		name = "DSAzDlgBlock"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26758_0 {
	meta:
		name = "DSAzDlgBlockBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26956_0 {
	meta:
		name = "DSAzDlgBlockProps"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26982_0 {
	meta:
		name = "DSAzDlgCopyBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27186_0 {
	meta:
		name = "DSAzDlgCreateContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27380_0 {
	meta:
		name = "DSAzDlgMetadata"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27397_0 {
	meta:
		name = "DSAzDlgPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27418_0 {
	meta:
		name = "DSAzDlgPageBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27610_0 {
	meta:
		name = "DSAzDlgPageProps"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27635_0 {
	meta:
		name = "DSAzDlgPutBlockList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27836_0 {
	meta:
		name = "DSAzDlgSnapshotBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28148_0 {
	meta:
		name = "DSAzure"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28965_0 {
	meta:
		name = "DSAzureMessageDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29106_0 {
	meta:
		name = "DSAzureQueueMetadataDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29152_0 {
	meta:
		name = "DSAzureTable"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29242_0 {
	meta:
		name = "DSAzureTableDialog"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29564_0 {
	meta:
		name = "DSAzureTableRowDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29572_0 {
	meta:
		name = "DUnitAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29574_0 {
	meta:
		name = "DUnitConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29580_0 {
	meta:
		name = "DUnitMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29583_0 {
	meta:
		name = "DUnitTestRunner"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2587_0 {
	meta:
		name = "Data.Bind.Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3288_0 {
	meta:
		name = "Data.Bind.ObserverLinks"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3510_0 {
	meta:
		name = "Data.Cloud.AmazonAPI"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4338_0 {
	meta:
		name = "Data.Cloud.AzureAPI"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4979_0 {
	meta:
		name = "Data.Cloud.CloudAPI"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6248_0 {
	meta:
		name = "Data.DBByteBuffer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6332_0 {
	meta:
		name = "Data.DBCommon"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6334_0 {
	meta:
		name = "Data.DBCommonTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6352_0 {
	meta:
		name = "Data.DBConnAdmin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6354_0 {
	meta:
		name = "Data.DBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6376_0 {
	meta:
		name = "Data.DBPlatform"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6395_0 {
	meta:
		name = "Data.DBXClassRegistry"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6453_0 {
	meta:
		name = "Data.DBXClient"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6455_0 {
	meta:
		name = "Data.DBXClientResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8127_0 {
	meta:
		name = "Data.DBXCommonIndy"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8129_0 {
	meta:
		name = "Data.DBXCommonResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8276_0 {
	meta:
		name = "Data.DBXCommonTable"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8585_0 {
	meta:
		name = "Data.DBXDBReaders"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8298_0 {
	meta:
		name = "Data.DBXDataExpressMetaDataProvider"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8398_0 {
	meta:
		name = "Data.DBXDb2MetaDataReader"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8406_0 {
	meta:
		name = "Data.DBXDb2MetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8862_0 {
	meta:
		name = "Data.DBXDelegate"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9007_0 {
	meta:
		name = "Data.DBXEncryption"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9069_0 {
	meta:
		name = "Data.DBXFirebirdMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9083_0 {
	meta:
		name = "Data.DBXFirebirdMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9186_0 {
	meta:
		name = "Data.DBXInformixMetaDataReader"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9198_0 {
	meta:
		name = "Data.DBXInformixMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9263_0 {
	meta:
		name = "Data.DBXInterbaseMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9277_0 {
	meta:
		name = "Data.DBXInterbaseMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9440_0 {
	meta:
		name = "Data.DBXJSON"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9450_0 {
	meta:
		name = "Data.DBXJSONCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9716_0 {
	meta:
		name = "Data.DBXJSONReflect"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12149_0 {
	meta:
		name = "Data.DBXMSSQLMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10735_0 {
	meta:
		name = "Data.DBXMemoryRow"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10798_0 {
	meta:
		name = "Data.DBXMessageHandlerCommon"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10843_0 {
	meta:
		name = "Data.DBXMessageHandlerJSonClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10869_0 {
	meta:
		name = "Data.DBXMessageHandlerJSonCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10949_0 {
	meta:
		name = "Data.DBXMessageHandlerJSonServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11536_0 {
	meta:
		name = "Data.DBXMetaDataCommand"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11558_0 {
	meta:
		name = "Data.DBXMetaDataCommandFactory"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11568_0 {
	meta:
		name = "Data.DBXMetaDataError"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11570_0 {
	meta:
		name = "Data.DBXMetaDataNames"
		size = 8
		refs = "0002 _DV_74"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11681_0 {
	meta:
		name = "Data.DBXMetaDataProvider"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11929_0 {
	meta:
		name = "Data.DBXMetaDataReader"
		size = 8
		refs = "0002 _DV_32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11933_0 {
	meta:
		name = "Data.DBXMetaDataUtil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12063_0 {
	meta:
		name = "Data.DBXMetaDataWriter"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11565_0 {
	meta:
		name = "Data.DBXMetadataCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12304_0 {
	meta:
		name = "Data.DBXMySqlMetaDataReader"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12322_0 {
	meta:
		name = "Data.DBXMySqlMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12551_0 {
	meta:
		name = "Data.DBXOdbcMetaDataReader"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12555_0 {
	meta:
		name = "Data.DBXOdbcMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12585_0 {
	meta:
		name = "Data.DBXOpenSSLRes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12652_0 {
	meta:
		name = "Data.DBXOracleMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12662_0 {
	meta:
		name = "Data.DBXOracleMetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12790_0 {
	meta:
		name = "Data.DBXPlatform"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12868_0 {
	meta:
		name = "Data.DBXRSAFilter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12854_0 {
	meta:
		name = "Data.DBXReaderTableStorage"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12920_0 {
	meta:
		name = "Data.DBXSqlScanner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13172_0 {
	meta:
		name = "Data.DBXStream"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13248_0 {
	meta:
		name = "Data.DBXStreamPlatform"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13183_0 {
	meta:
		name = "Data.DBXStreamer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13318_0 {
	meta:
		name = "Data.DBXSybaseASAMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13406_0 {
	meta:
		name = "Data.DBXSybaseASEMetaDataWriter"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13412_0 {
	meta:
		name = "Data.DBXTableFactory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13802_0 {
	meta:
		name = "Data.DBXTransport"
		size = 8
		refs = "0002 _DV_31"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13829_0 {
	meta:
		name = "Data.DBXTransportFilter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14177_0 {
	meta:
		name = "Data.DBXTypedTableStorage"
		size = 8
		refs = "0002 _DV_32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14189_0 {
	meta:
		name = "Data.DSUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14292_0 {
	meta:
		name = "Data.SqlConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14771_0 {
	meta:
		name = "Data.Win.ADOConEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14773_0 {
	meta:
		name = "Data.Win.ADOConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15542_0 {
	meta:
		name = "Datasnap.DBClient"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15578_0 {
	meta:
		name = "Datasnap.DSAuth"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15628_0 {
	meta:
		name = "Datasnap.DSClientMetadata"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16075_0 {
	meta:
		name = "Datasnap.DSClientResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16248_0 {
	meta:
		name = "Datasnap.DSClientRest"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16603_0 {
	meta:
		name = "Datasnap.DSCommonProxy"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16905_0 {
	meta:
		name = "Datasnap.DSCommonServer"
		size = 8
		refs = "0002 _DV_73"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16989_0 {
	meta:
		name = "Datasnap.DSCommonTable"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17014_0 {
	meta:
		name = "Datasnap.DSConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17044_0 {
	meta:
		name = "Datasnap.DSCustomConnectorProxyWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17727_0 {
	meta:
		name = "Datasnap.DSHTTPCommon"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18977_0 {
	meta:
		name = "Datasnap.DSHTTPServiceProxyDispatcher"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19216_0 {
	meta:
		name = "Datasnap.DSHTTPWebBroker"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19233_0 {
	meta:
		name = "Datasnap.DSNames"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19294_0 {
	meta:
		name = "Datasnap.DSProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20955_0 {
	meta:
		name = "Datasnap.DSProxyDispatcher"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22607_0 {
	meta:
		name = "Datasnap.DSProxyRest"
		size = 8
		refs = "0002 _DV_82"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22611_0 {
	meta:
		name = "Datasnap.DSProxyUtils"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23177_0 {
	meta:
		name = "Datasnap.DSReflect"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24141_0 {
	meta:
		name = "Datasnap.DSServerResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25496_0 {
	meta:
		name = "Datasnap.DSTCPServerTransport"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25762_0 {
	meta:
		name = "Datasnap.DSTransport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25766_0 {
	meta:
		name = "Datasnap.MidConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25764_0 {
	meta:
		name = "Datasnap.Midas"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26044_0 {
	meta:
		name = "Datasnap.Win.MConnect"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26052_0 {
	meta:
		name = "Datasnap.Win.MidasCon"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26073_0 {
	meta:
		name = "Datasnap.Win.MtsRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26096_0 {
	meta:
		name = "Datasnap.Win.ObjBrkr"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26233_0 {
	meta:
		name = "Datasnap.Win.SConnect"
		size = 8
		refs = "0002 _DV_31"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26254_0 {
	meta:
		name = "Datasnap.Win.TConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26665_0 {
	meta:
		name = "DbxDataGenerator"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26692_0 {
	meta:
		name = "DbxTest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29585_0 {
	meta:
		name = "ExDispID"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30039_0 {
	meta:
		name = "GUITestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29900_0 {
	meta:
		name = "GUITesting"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29589_0 {
	meta:
		name = "Graph2010"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29667_0 {
	meta:
		name = "GraphView"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30101_0 {
	meta:
		name = "HTTPParse"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30150_0 {
	meta:
		name = "IBBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30166_0 {
	meta:
		name = "IBConnectionBroker"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30539_0 {
	meta:
		name = "IBDatabase"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30781_0 {
	meta:
		name = "IBDatabaseINI"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30758_0 {
	meta:
		name = "IBDatabaseInfo"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30783_0 {
	meta:
		name = "IBErrorCodes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30819_0 {
	meta:
		name = "IBEvents"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30881_0 {
	meta:
		name = "IBExternals"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30925_0 {
	meta:
		name = "IBExtract"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30967_0 {
	meta:
		name = "IBFilterSummary"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30975_0 {
	meta:
		name = "IBHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31018_0 {
	meta:
		name = "IBInstallHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31457_0 {
	meta:
		name = "IBQuery"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31879_0 {
	meta:
		name = "IBSQL"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31667_0 {
	meta:
		name = "IBServices"
		size = 8
		refs = "0002 _DV_62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31979_0 {
	meta:
		name = "IBStoredProc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32060_0 {
	meta:
		name = "IBTable"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32075_0 {
	meta:
		name = "IBUpdateSQL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32100_0 {
	meta:
		name = "IBVisualConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32102_0 {
	meta:
		name = "IBXConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32107_0 {
	meta:
		name = "IBXMLHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39122_0 {
	meta:
		name = "IEActions"
		size = 8
		refs = "0002 _DV_89"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39124_0 {
	meta:
		name = "IEConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42510_0 {
	meta:
		name = "IPPeerAPI"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43135_0 {
	meta:
		name = "IPPeerResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43238_0 {
	meta:
		name = "IWAuther"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43241_0 {
	meta:
		name = "IWAutherEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43246_0 {
	meta:
		name = "IWAutherINI"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43252_0 {
	meta:
		name = "IWAutherList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43261_0 {
	meta:
		name = "IWBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43287_0 {
	meta:
		name = "IWBaseComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43296_0 {
	meta:
		name = "IWBaseContainerLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43362_0 {
	meta:
		name = "IWBaseForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43373_0 {
	meta:
		name = "IWBaseHTML40Component"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43392_0 {
	meta:
		name = "IWBaseHTMLComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43459_0 {
	meta:
		name = "IWBaseHTMLControl"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43465_0 {
	meta:
		name = "IWBaseHTMLForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43469_0 {
	meta:
		name = "IWBaseHTMLInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43488_0 {
	meta:
		name = "IWBaseInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43495_0 {
	meta:
		name = "IWBaseLayoutComponent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43531_0 {
	meta:
		name = "IWCallBack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43549_0 {
	meta:
		name = "IWCompActiveX"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43557_0 {
	meta:
		name = "IWCompButton"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43657_0 {
	meta:
		name = "IWCompEdit"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43667_0 {
	meta:
		name = "IWCompFlash"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43683_0 {
	meta:
		name = "IWCompLabel"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43809_0 {
	meta:
		name = "IWCompMPEG"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43766_0 {
	meta:
		name = "IWCompMemo"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43847_0 {
	meta:
		name = "IWCompProgressBar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43854_0 {
	meta:
		name = "IWCompQuickTime"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43869_0 {
	meta:
		name = "IWCompRadioButton"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43881_0 {
	meta:
		name = "IWCompRectangle"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43948_0 {
	meta:
		name = "IWCompText"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43958_0 {
	meta:
		name = "IWCompTimeEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43897_0 {
	meta:
		name = "IWCompress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44003_0 {
	meta:
		name = "IWContainer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44034_0 {
	meta:
		name = "IWContainerLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44036_0 {
	meta:
		name = "IWContentASPX"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44042_0 {
	meta:
		name = "IWContentBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44047_0 {
	meta:
		name = "IWContentPas"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44214_0 {
	meta:
		name = "IWCopyParser"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44246_0 {
	meta:
		name = "IWDBCommon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44239_0 {
	meta:
		name = "IWDataModulePool"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44427_0 {
	meta:
		name = "IWDsnAppWizForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44481_0 {
	meta:
		name = "IWDsnColorDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44485_0 {
	meta:
		name = "IWDsnControlAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44488_0 {
	meta:
		name = "IWDsnDesignerDestroyer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44491_0 {
	meta:
		name = "IWDsnFormWebsite"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44495_0 {
	meta:
		name = "IWDsnFormWizard"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44499_0 {
	meta:
		name = "IWDsnFrameWizard"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44530_0 {
	meta:
		name = "IWDsnIDEMenu"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44579_0 {
	meta:
		name = "IWDsnScriptEvents"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44584_0 {
	meta:
		name = "IWDsnTabControl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44678_0 {
	meta:
		name = "IWDsnTestWizard"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44909_0 {
	meta:
		name = "IWDsnWizard"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44917_0 {
	meta:
		name = "IWException"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44987_0 {
	meta:
		name = "IWExtCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45030_0 {
	meta:
		name = "IWFileReference"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45047_0 {
	meta:
		name = "IWFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45091_0 {
	meta:
		name = "IWForm"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45105_0 {
	meta:
		name = "IWFormDsn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45111_0 {
	meta:
		name = "IWFormListManager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45114_0 {
	meta:
		name = "IWGIF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45120_0 {
	meta:
		name = "IWGlobal"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45124_0 {
	meta:
		name = "IWGridCommon"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45194_0 {
	meta:
		name = "IWGrids"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45213_0 {
	meta:
		name = "IWHTML40Container"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45222_0 {
	meta:
		name = "IWHTML40Interfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45234_0 {
	meta:
		name = "IWHTMLContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45273_0 {
	meta:
		name = "IWHTMLControls"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45304_0 {
	meta:
		name = "IWIDEUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45358_0 {
	meta:
		name = "IWIWPProcessor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45370_0 {
	meta:
		name = "IWIWPTemplater"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45307_0 {
	meta:
		name = "IWImageList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45333_0 {
	meta:
		name = "IWInitService"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45386_0 {
	meta:
		name = "IWJQueryWidget"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45377_0 {
	meta:
		name = "IWJpegOptions"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45425_0 {
	meta:
		name = "IWLayoutMgrForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45441_0 {
	meta:
		name = "IWLayoutMgrHTMLInterface"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45499_0 {
	meta:
		name = "IWMain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45545_0 {
	meta:
		name = "IWMarkupLanguageTag"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45835_0 {
	meta:
		name = "IWNativeXml"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45839_0 {
	meta:
		name = "IWPermissions"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45859_0 {
	meta:
		name = "IWProgressIndicator"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46058_0 {
	meta:
		name = "IWScriptEvents"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46188_0 {
	meta:
		name = "IWServerControllerBase"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46199_0 {
	meta:
		name = "IWService"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46207_0 {
	meta:
		name = "IWSessionList"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46254_0 {
	meta:
		name = "IWStandAloneServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46258_0 {
	meta:
		name = "IWStart"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46275_0 {
	meta:
		name = "IWStreams"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46294_0 {
	meta:
		name = "IWStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46335_0 {
	meta:
		name = "IWTag"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46345_0 {
	meta:
		name = "IWTagParser"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46350_0 {
	meta:
		name = "IWTemplateProcessing"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46372_0 {
	meta:
		name = "IWTemplateProcessorHTML"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46468_0 {
	meta:
		name = "IWTypes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46489_0 {
	meta:
		name = "IWURLResponder"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46491_0 {
	meta:
		name = "IWURLResponderBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46499_0 {
	meta:
		name = "IWURLResponderDirLister"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46502_0 {
	meta:
		name = "IWUserSessionBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46532_0 {
	meta:
		name = "IWUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46626_0 {
	meta:
		name = "IWVCLBaseContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46670_0 {
	meta:
		name = "IWVCLBaseControl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46672_0 {
	meta:
		name = "IWVCLClasses"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46681_0 {
	meta:
		name = "IWVCLComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46537_0 {
	meta:
		name = "IWVar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46551_0 {
	meta:
		name = "IWVarDir"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46574_0 {
	meta:
		name = "IWVarDoc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46765_0 {
	meta:
		name = "IWWebEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46772_0 {
	meta:
		name = "IWXMLTag"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32135_0 {
	meta:
		name = "IdASN1Util"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32109_0 {
	meta:
		name = "IdAllAuthentications"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32111_0 {
	meta:
		name = "IdAllFTPListParsers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32113_0 {
	meta:
		name = "IdAllHeaderCoders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32121_0 {
	meta:
		name = "IdAntiFreezeBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32137_0 {
	meta:
		name = "IdAssignedNumbers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32150_0 {
	meta:
		name = "IdAttachment"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32159_0 {
	meta:
		name = "IdAttachmentFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32172_0 {
	meta:
		name = "IdAttachmentMemory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32304_0 {
	meta:
		name = "IdBaseComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32313_0 {
	meta:
		name = "IdBlockCipherIntercept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32643_0 {
	meta:
		name = "IdCTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32356_0 {
	meta:
		name = "IdChargenServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32360_0 {
	meta:
		name = "IdChargenUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32366_0 {
	meta:
		name = "IdCharsets"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32381_0 {
	meta:
		name = "IdCmdTCPClient"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32414_0 {
	meta:
		name = "IdCmdTCPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32438_0 {
	meta:
		name = "IdCoder"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32442_0 {
	meta:
		name = "IdCoder00E"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32449_0 {
	meta:
		name = "IdCoder3to4"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32470_0 {
	meta:
		name = "IdCoderHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32485_0 {
	meta:
		name = "IdCoderQuotedPrintable"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32540_0 {
	meta:
		name = "IdCompressionIntercept"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32551_0 {
	meta:
		name = "IdCompressorZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32557_0 {
	meta:
		name = "IdConnectThroughHttpProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32572_0 {
	meta:
		name = "IdContainers"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32582_0 {
	meta:
		name = "IdContext"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32627_0 {
	meta:
		name = "IdCookie"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32641_0 {
	meta:
		name = "IdCookieManager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32741_0 {
	meta:
		name = "IdCustomHTTPServer"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32781_0 {
	meta:
		name = "IdCustomTCPServer"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32903_0 {
	meta:
		name = "IdDICT"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32928_0 {
	meta:
		name = "IdDICTCommon"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32944_0 {
	meta:
		name = "IdDICTServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33152_0 {
	meta:
		name = "IdDNSResolver"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33253_0 {
	meta:
		name = "IdDNSServer"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32868_0 {
	meta:
		name = "IdDateTimeStamp"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32872_0 {
	meta:
		name = "IdDayTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32876_0 {
	meta:
		name = "IdDayTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32880_0 {
	meta:
		name = "IdDayTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32884_0 {
	meta:
		name = "IdDayTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32948_0 {
	meta:
		name = "IdDiscardServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32951_0 {
	meta:
		name = "IdDiscardUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33257_0 {
	meta:
		name = "IdEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33261_0 {
	meta:
		name = "IdEchoServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33265_0 {
	meta:
		name = "IdEchoUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33269_0 {
	meta:
		name = "IdEchoUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33297_0 {
	meta:
		name = "IdException"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33299_0 {
	meta:
		name = "IdExceptionCore"
		size = 8
		refs = "0002 _DV_36"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33323_0 {
	meta:
		name = "IdExplicitTLSClientServerBase"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33394_0 {
	meta:
		name = "IdFSP"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33537_0 {
	meta:
		name = "IdFTP"
		size = 8
		refs = "0002 _DV_33"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33557_0 {
	meta:
		name = "IdFTPBaseFileSystem"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33645_0 {
	meta:
		name = "IdFTPCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33723_0 {
	meta:
		name = "IdFTPListOutput"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34162_0 {
	meta:
		name = "IdFTPListTypes"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34347_0 {
	meta:
		name = "IdFTPServerContextBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33329_0 {
	meta:
		name = "IdFinger"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33333_0 {
	meta:
		name = "IdFingerServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34592_0 {
	meta:
		name = "IdGlobalCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34758_0 {
	meta:
		name = "IdGopherConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34764_0 {
	meta:
		name = "IdGopherServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34929_0 {
	meta:
		name = "IdHMACMD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34951_0 {
	meta:
		name = "IdHMACSHA1"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35024_0 {
	meta:
		name = "IdHTTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35076_0 {
	meta:
		name = "IdHTTPHeaderInfo"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35088_0 {
	meta:
		name = "IdHTTPProxyServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35090_0 {
	meta:
		name = "IdHTTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34807_0 {
	meta:
		name = "IdHash"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34814_0 {
	meta:
		name = "IdHashCRC"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34818_0 {
	meta:
		name = "IdHashElf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34838_0 {
	meta:
		name = "IdHashMessageDigest"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34855_0 {
	meta:
		name = "IdHashSHA"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34909_0 {
	meta:
		name = "IdHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35371_0 {
	meta:
		name = "IdIMAP4"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35443_0 {
	meta:
		name = "IdIMAP4Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35558_0 {
	meta:
		name = "IdIOHandler"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35581_0 {
	meta:
		name = "IdIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35609_0 {
	meta:
		name = "IdIOHandlerStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35633_0 {
	meta:
		name = "IdIPAddrMon"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35621_0 {
	meta:
		name = "IdIPAddress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35648_0 {
	meta:
		name = "IdIPMCastBase"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35664_0 {
	meta:
		name = "IdIPMCastClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35679_0 {
	meta:
		name = "IdIPMCastServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35694_0 {
	meta:
		name = "IdIPWatch"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35173_0 {
	meta:
		name = "IdIdent"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35180_0 {
	meta:
		name = "IdIdentServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35462_0 {
	meta:
		name = "IdInterceptSimLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35467_0 {
	meta:
		name = "IdInterceptThrottler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35893_0 {
	meta:
		name = "IdIrcServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35916_0 {
	meta:
		name = "IdLogDebug"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35921_0 {
	meta:
		name = "IdLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35931_0 {
	meta:
		name = "IdLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35938_0 {
	meta:
		name = "IdLogStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35964_0 {
	meta:
		name = "IdMailBox"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35989_0 {
	meta:
		name = "IdMappedPOP3"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36014_0 {
	meta:
		name = "IdMappedPortTCP"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36019_0 {
	meta:
		name = "IdMappedPortUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36077_0 {
	meta:
		name = "IdMessage"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36115_0 {
	meta:
		name = "IdMessageBuilder"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36140_0 {
	meta:
		name = "IdMessageClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36166_0 {
	meta:
		name = "IdMessageCoder"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36225_0 {
	meta:
		name = "IdMessageCollection"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36291_0 {
	meta:
		name = "IdMultipartFormData"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36395_0 {
	meta:
		name = "IdNNTP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36455_0 {
	meta:
		name = "IdNNTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36466_0 {
	meta:
		name = "IdNTLM"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36326_0 {
	meta:
		name = "IdNetworkCalculator"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36488_0 {
	meta:
		name = "IdOSFileName"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36527_0 {
	meta:
		name = "IdPOP3"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36558_0 {
	meta:
		name = "IdPOP3Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36570_0 {
	meta:
		name = "IdQOTDUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36575_0 {
	meta:
		name = "IdQOTDUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36562_0 {
	meta:
		name = "IdQotd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36566_0 {
	meta:
		name = "IdQotdServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36868_0 {
	meta:
		name = "IdRSH"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36872_0 {
	meta:
		name = "IdRSHServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36589_0 {
	meta:
		name = "IdRawBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36591_0 {
	meta:
		name = "IdRawClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36607_0 {
	meta:
		name = "IdRawFunctions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36727_0 {
	meta:
		name = "IdRawHeaders"
		size = 8
		refs = "0002 _DV_32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36736_0 {
	meta:
		name = "IdRemoteCMDClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36743_0 {
	meta:
		name = "IdRemoteCMDServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36801_0 {
	meta:
		name = "IdReplyIMAP4"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36816_0 {
	meta:
		name = "IdReplyPOP3"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36850_0 {
	meta:
		name = "IdReplySMTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36852_0 {
	meta:
		name = "IdResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36854_0 {
	meta:
		name = "IdResourceStringsCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36856_0 {
	meta:
		name = "IdResourceStringsProtocols"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36860_0 {
	meta:
		name = "IdRexec"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36864_0 {
	meta:
		name = "IdRexecServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36889_0 {
	meta:
		name = "IdSASLAnonymous"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36909_0 {
	meta:
		name = "IdSASLCollection"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36921_0 {
	meta:
		name = "IdSASLDigest"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36927_0 {
	meta:
		name = "IdSASLExternal"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36933_0 {
	meta:
		name = "IdSASLLogin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36940_0 {
	meta:
		name = "IdSASLOTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36945_0 {
	meta:
		name = "IdSASLPlain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36952_0 {
	meta:
		name = "IdSASLSKey"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36959_0 {
	meta:
		name = "IdSASLUserPass"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36964_0 {
	meta:
		name = "IdSASL_CRAMBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36969_0 {
	meta:
		name = "IdSASL_CRAM_MD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36973_0 {
	meta:
		name = "IdSASL_CRAM_SHA1"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37079_0 {
	meta:
		name = "IdSMTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37101_0 {
	meta:
		name = "IdSMTPBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37129_0 {
	meta:
		name = "IdSMTPRelay"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37189_0 {
	meta:
		name = "IdSMTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37226_0 {
	meta:
		name = "IdSNMP"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37235_0 {
	meta:
		name = "IdSNPP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37244_0 {
	meta:
		name = "IdSNTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37787_0 {
	meta:
		name = "IdSSPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36983_0 {
	meta:
		name = "IdScheduler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36993_0 {
	meta:
		name = "IdSchedulerOfThread"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36998_0 {
	meta:
		name = "IdSchedulerOfThreadDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37007_0 {
	meta:
		name = "IdSchedulerOfThreadPool"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37035_0 {
	meta:
		name = "IdServerIOHandler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37040_0 {
	meta:
		name = "IdServerIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37044_0 {
	meta:
		name = "IdServerIOHandlerStack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37019_0 {
	meta:
		name = "IdServerInterceptLogBase"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37022_0 {
	meta:
		name = "IdServerInterceptLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37027_0 {
	meta:
		name = "IdServerInterceptLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37059_0 {
	meta:
		name = "IdSimpleServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37296_0 {
	meta:
		name = "IdSocketHandle"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37322_0 {
	meta:
		name = "IdSocks"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37896_0 {
	meta:
		name = "IdStackBSDBase"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37898_0 {
	meta:
		name = "IdStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37962_0 {
	meta:
		name = "IdStream"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37967_0 {
	meta:
		name = "IdStreamVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37977_0 {
	meta:
		name = "IdStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38021_0 {
	meta:
		name = "IdSysLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38058_0 {
	meta:
		name = "IdSysLogMessage"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38063_0 {
	meta:
		name = "IdSysLogServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38067_0 {
	meta:
		name = "IdSystat"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38071_0 {
	meta:
		name = "IdSystatServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38075_0 {
	meta:
		name = "IdSystatUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38080_0 {
	meta:
		name = "IdSystatUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38119_0 {
	meta:
		name = "IdTCPClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38154_0 {
	meta:
		name = "IdTCPConnection"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38157_0 {
	meta:
		name = "IdTCPServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38165_0 {
	meta:
		name = "IdTCPStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38092_0 {
	meta:
		name = "IdTask"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38181_0 {
	meta:
		name = "IdTelnet"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38199_0 {
	meta:
		name = "IdText"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38276_0 {
	meta:
		name = "IdThreadComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38337_0 {
	meta:
		name = "IdThreadSafe"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38343_0 {
	meta:
		name = "IdTime"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38347_0 {
	meta:
		name = "IdTimeServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38353_0 {
	meta:
		name = "IdTimeUDP"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38357_0 {
	meta:
		name = "IdTimeUDPServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38361_0 {
	meta:
		name = "IdTraceRoute"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38373_0 {
	meta:
		name = "IdTrivialFTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38380_0 {
	meta:
		name = "IdTrivialFTPBase"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38403_0 {
	meta:
		name = "IdTrivialFTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38456_0 {
	meta:
		name = "IdUDPClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38501_0 {
	meta:
		name = "IdURI"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38480_0 {
	meta:
		name = "IdUnixTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38483_0 {
	meta:
		name = "IdUnixTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38486_0 {
	meta:
		name = "IdUnixTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38489_0 {
	meta:
		name = "IdUnixTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38506_0 {
	meta:
		name = "IdUriUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38541_0 {
	meta:
		name = "IdUserAccounts"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38543_0 {
	meta:
		name = "IdUserPassProvider"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38621_0 {
	meta:
		name = "IdWebDAV"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38629_0 {
	meta:
		name = "IdWhoIsServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38625_0 {
	meta:
		name = "IdWhois"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38816_0 {
	meta:
		name = "IdWship6"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38818_0 {
	meta:
		name = "IdYarn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38864_0 {
	meta:
		name = "IdZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38880_0 {
	meta:
		name = "IdZLibCompressorBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38882_0 {
	meta:
		name = "IdZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38957_0 {
	meta:
		name = "IdZLibHeaders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35895_0 {
	meta:
		name = "Idispids"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39132_0 {
	meta:
		name = "InAntiFreezeBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39134_0 {
	meta:
		name = "InAssignedNumbers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39166_0 {
	meta:
		name = "InBaseComponent"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39315_0 {
	meta:
		name = "InCTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39211_0 {
	meta:
		name = "InCharsets"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39235_0 {
	meta:
		name = "InCoder"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39242_0 {
	meta:
		name = "InCoder3to4"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39268_0 {
	meta:
		name = "InContext"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39313_0 {
	meta:
		name = "InCookie"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39413_0 {
	meta:
		name = "InCustomHTTPServer"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39453_0 {
	meta:
		name = "InCustomTCPServer"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39540_0 {
	meta:
		name = "InDateTimeStamp"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40476_0 {
	meta:
		name = "InException"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40478_0 {
	meta:
		name = "InExceptionCore"
		size = 8
		refs = "0002 _DV_36"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40741_0 {
	meta:
		name = "InGlobalCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41016_0 {
	meta:
		name = "InHTTPHeaderInfo"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40921_0 {
	meta:
		name = "InHash"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40941_0 {
	meta:
		name = "InHashMessageDigest"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40964_0 {
	meta:
		name = "InHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41166_0 {
	meta:
		name = "InIOHandler"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41189_0 {
	meta:
		name = "InIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41213_0 {
	meta:
		name = "InIPAddress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41259_0 {
	meta:
		name = "InResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41261_0 {
	meta:
		name = "InResourceStringsCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41263_0 {
	meta:
		name = "InResourceStringsProtocols"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41273_0 {
	meta:
		name = "InScheduler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41283_0 {
	meta:
		name = "InSchedulerOfThread"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41288_0 {
	meta:
		name = "InSchedulerOfThreadDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41297_0 {
	meta:
		name = "InSchedulerOfThreadPool"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41305_0 {
	meta:
		name = "InServerIOHandler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41310_0 {
	meta:
		name = "InServerIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41314_0 {
	meta:
		name = "InServerIOHandlerStack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41366_0 {
	meta:
		name = "InSocketHandle"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41392_0 {
	meta:
		name = "InSocks"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41936_0 {
	meta:
		name = "InStackBSDBase"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41938_0 {
	meta:
		name = "InStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42002_0 {
	meta:
		name = "InStream"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42007_0 {
	meta:
		name = "InStreamVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42017_0 {
	meta:
		name = "InStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42068_0 {
	meta:
		name = "InTCPClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42103_0 {
	meta:
		name = "InTCPConnection"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42106_0 {
	meta:
		name = "InTCPServer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42041_0 {
	meta:
		name = "InTask"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42195_0 {
	meta:
		name = "InThreadSafe"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42248_0 {
	meta:
		name = "InUDPClient"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42281_0 {
	meta:
		name = "InURI"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42286_0 {
	meta:
		name = "InURIUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42473_0 {
	meta:
		name = "InWship6"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42475_0 {
	meta:
		name = "InYarn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40472_0 {
	meta:
		name = "IndySockTransport"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46803_0 {
	meta:
		name = "JUnitXmlTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47368_0 {
	meta:
		name = "MSBuildTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47416_0 {
	meta:
		name = "MSComctlLibXP"
		size = 8
		refs = "0002 _DV_42"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47418_0 {
	meta:
		name = "MSDATASRCXP"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47438_0 {
	meta:
		name = "MSForms2000"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47676_0 {
	meta:
		name = "MSPpt2000"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46926_0 {
	meta:
		name = "MidComp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47363_0 {
	meta:
		name = "MidProd"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47442_0 {
	meta:
		name = "Mshtmdid"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47810_0 {
	meta:
		name = "OWC10XP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47694_0 {
	meta:
		name = "OfficeXP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47800_0 {
	meta:
		name = "OutlookXP"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47823_0 {
	meta:
		name = "PagItems"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47943_0 {
	meta:
		name = "PowerPointXP"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47980_0 {
	meta:
		name = "ScktCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48040_0 {
	meta:
		name = "ScktMain"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48135_0 {
	meta:
		name = "ScrptMgr"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48557_0 {
	meta:
		name = "SimpleDS"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48577_0 {
	meta:
		name = "SiteConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48626_0 {
	meta:
		name = "SiteProd"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48640_0 {
	meta:
		name = "Soap.EncdDecd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48644_0 {
	meta:
		name = "Soap.HTTPSOAPToPasBind"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48672_0 {
	meta:
		name = "Soap.HTTPUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48813_0 {
	meta:
		name = "Soap.InvConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48816_0 {
	meta:
		name = "Soap.Invoker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49018_0 {
	meta:
		name = "Soap.OPConvert"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49020_0 {
	meta:
		name = "Soap.OpConvertOptions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49199_0 {
	meta:
		name = "Soap.Rio"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49255_0 {
	meta:
		name = "Soap.SOAPAttach"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49262_0 {
	meta:
		name = "Soap.SOAPAttachIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49301_0 {
	meta:
		name = "Soap.SOAPConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49340_0 {
	meta:
		name = "Soap.SOAPDm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49351_0 {
	meta:
		name = "Soap.SOAPDomConv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49357_0 {
	meta:
		name = "Soap.SOAPEnv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49378_0 {
	meta:
		name = "Soap.SOAPHTTPClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49383_0 {
	meta:
		name = "Soap.SOAPHTTPDisp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49387_0 {
	meta:
		name = "Soap.SOAPHTTPPasInv"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49470_0 {
	meta:
		name = "Soap.SOAPLinked"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49483_0 {
	meta:
		name = "Soap.SOAPPasInv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49508_0 {
	meta:
		name = "Soap.UDDIHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49718_0 {
	meta:
		name = "Soap.WSDLBind"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49730_0 {
	meta:
		name = "Soap.WSDLIntf"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49824_0 {
	meta:
		name = "Soap.WSDLItems"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49909_0 {
	meta:
		name = "Soap.WSDLLookup"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50253_0 {
	meta:
		name = "Soap.WSILIntf"
		size = 8
		refs = "0002 _DV_31"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49522_0 {
	meta:
		name = "Soap.WebBrokerSOAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49524_0 {
	meta:
		name = "Soap.WebNode"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49588_0 {
	meta:
		name = "Soap.WebServExp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49610_0 {
	meta:
		name = "Soap.Win.CertHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48786_0 {
	meta:
		name = "Soap.inquire_v1"
		size = 8
		refs = "0002 _DV_94"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50469_0 {
	meta:
		name = "SockAppHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50502_0 {
	meta:
		name = "SockAppReg"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50504_0 {
	meta:
		name = "SockConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50591_0 {
	meta:
		name = "SockTransport"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50600_0 {
	meta:
		name = "SvrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50679_0 {
	meta:
		name = "SvrHTTPIndy"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50683_0 {
	meta:
		name = "SvrInfoConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50725_0 {
	meta:
		name = "SvrLog"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50730_0 {
	meta:
		name = "SvrLogColSettingsFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50741_0 {
	meta:
		name = "SvrLogDetailDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50759_0 {
	meta:
		name = "SvrLogDetailFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50843_0 {
	meta:
		name = "SvrMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50865_0 {
	meta:
		name = "SvrPropDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50872_0 {
	meta:
		name = "SvrSockRequest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50879_0 {
	meta:
		name = "SvrStatsFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51490_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51592_0 {
	meta:
		name = "System.AnsiStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51594_0 {
	meta:
		name = "System.Bindings.Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51603_0 {
	meta:
		name = "System.Bindings.CustomScope"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51882_0 {
	meta:
		name = "System.Bindings.CustomWrapper"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51921_0 {
	meta:
		name = "System.Bindings.EvalProtocol"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52370_0 {
	meta:
		name = "System.Bindings.EvalSys"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52989_0 {
	meta:
		name = "System.Bindings.Evaluator"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53909_0 {
	meta:
		name = "System.Bindings.ExpressionDefaults"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54435_0 {
	meta:
		name = "System.Bindings.Factories"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54773_0 {
	meta:
		name = "System.Bindings.Graph"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56671_0 {
	meta:
		name = "System.Bindings.Helper"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57018_0 {
	meta:
		name = "System.Bindings.Manager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57147_0 {
	meta:
		name = "System.Bindings.ManagerDefaults"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59316_0 {
	meta:
		name = "System.Bindings.NotifierContracts"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59327_0 {
	meta:
		name = "System.Bindings.NotifierDefaults"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59494_0 {
	meta:
		name = "System.Bindings.ObjEval"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61591_0 {
	meta:
		name = "System.Bindings.Search"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61951_0 {
	meta:
		name = "System.Character"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63165_0 {
	meta:
		name = "System.Contnrs"
		size = 8
		refs = "0002 _DV_31"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63432_0 {
	meta:
		name = "System.DateUtils"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64955_0 {
	meta:
		name = "System.Diagnostics"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65175_0 {
	meta:
		name = "System.Generics.Collections"
		size = 8
		refs = "0002 _DV_32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65714_0 {
	meta:
		name = "System.Generics.Defaults"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65762_0 {
	meta:
		name = "System.HelpIntfs"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66178_0 {
	meta:
		name = "System.IOUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65836_0 {
	meta:
		name = "System.IniFiles"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65887_0 {
	meta:
		name = "System.Internal.StrHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65930_0 {
	meta:
		name = "System.Internal.VarHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66211_0 {
	meta:
		name = "System.MaskUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66194_0 {
	meta:
		name = "System.Masks"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66545_0 {
	meta:
		name = "System.ObjAuto"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66560_0 {
	meta:
		name = "System.Odbc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66737_0 {
	meta:
		name = "System.RTLConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66625_0 {
	meta:
		name = "System.RegularExpressions"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66679_0 {
	meta:
		name = "System.RegularExpressionsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66681_0 {
	meta:
		name = "System.RegularExpressionsConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66735_0 {
	meta:
		name = "System.RegularExpressionsCore"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68689_0 {
	meta:
		name = "System.StrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68830_0 {
	meta:
		name = "System.SysConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69723_0 {
	meta:
		name = "System.TimeSpan"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70056_0 {
	meta:
		name = "System.TypInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69926_0 {
	meta:
		name = "System.Types"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70096_0 {
	meta:
		name = "System.UIConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70103_0 {
	meta:
		name = "System.UITypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70799_0 {
	meta:
		name = "System.WideStrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70801_0 {
	meta:
		name = "System.Win.ComConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70998_0 {
	meta:
		name = "System.Win.ComObjWrapper"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71165_0 {
	meta:
		name = "System.Win.Crtl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71179_0 {
	meta:
		name = "System.Win.Mtsobj"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71200_0 {
	meta:
		name = "System.Win.ObjComAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71307_0 {
	meta:
		name = "System.Win.Registry"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71458_0 {
	meta:
		name = "System.Win.StdVCL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71966_0 {
	meta:
		name = "System.ZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71968_0 {
	meta:
		name = "System.ZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71533_0 {
	meta:
		name = "System.Zip"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61964_0 {
	meta:
		name = "TBinaryWriter.Create@"
		size = 8
		refs = "0002 TBinaryWriter.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59752_0 {
	meta:
		name = "TBindingCallbackFactory.Create@"
		size = 8
		refs = "0002 TBindingCallbackFactory.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54403_0 {
	meta:
		name = "TBindingScopeFactory.Create@"
		size = 8
		refs = "0002 TBindingScopeFactory.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87016_0 {
	meta:
		name = "TCustomStyleEngine.Create@"
		size = 8
		refs = "0002 TCustomStyleEngine.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68832_0 {
	meta:
		name = "TEncoding.Create@"
		size = 8
		refs = "0002 TEncoding.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35128_0 {
	meta:
		name = "TIdHTTPWebBrokerBridgeRequestHandler.Create@"
		size = 8
		refs = "0002 TIdHTTPWebBrokerBridgeRequestHandler.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41054_0 {
	meta:
		name = "TInHTTPWebBrokerBridgeRequestHandler.Create@"
		size = 8
		refs = "0002 TInHTTPWebBrokerBridgeRequestHandler.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68831_0 {
	meta:
		name = "TLanguages.Create@"
		size = 8
		refs = "0002 TLanguages.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61952_0 {
	meta:
		name = "TObserverMapping.Create@"
		size = 8
		refs = "0002 TObserverMapping.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71993_0 {
	meta:
		name = "TestExtensions"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72254_0 {
	meta:
		name = "TestModules"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72279_0 {
	meta:
		name = "TextTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72281_0 {
	meta:
		name = "UrlHist"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72325_0 {
	meta:
		name = "VBIDE2000"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72361_0 {
	meta:
		name = "VBIDE2010"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72397_0 {
	meta:
		name = "VBIDEXP"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90547_0 {
	meta:
		name = "VCLTee.DBChart"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90581_0 {
	meta:
		name = "VCLTee.EditChar"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91070_0 {
	meta:
		name = "VCLTee.Series"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95189_0 {
	meta:
		name = "VCLTee.TeExport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91805_0 {
	meta:
		name = "VCLTee.TeeAxMaxMin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91800_0 {
	meta:
		name = "VCLTee.TeeAxisIncr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91819_0 {
	meta:
		name = "VCLTee.TeeBackImage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91903_0 {
	meta:
		name = "VCLTee.TeeBrushDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92061_0 {
	meta:
		name = "VCLTee.TeeCustomShapeEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92179_0 {
	meta:
		name = "VCLTee.TeeDBEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92218_0 {
	meta:
		name = "VCLTee.TeeDraw3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92248_0 {
	meta:
		name = "VCLTee.TeeEdi3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92329_0 {
	meta:
		name = "VCLTee.TeeEdiAxis"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92352_0 {
	meta:
		name = "VCLTee.TeeEdiFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92407_0 {
	meta:
		name = "VCLTee.TeeEdiGene"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92504_0 {
	meta:
		name = "VCLTee.TeeEdiLege"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92520_0 {
	meta:
		name = "VCLTee.TeeEdiPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92545_0 {
	meta:
		name = "VCLTee.TeeEdiPane"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92639_0 {
	meta:
		name = "VCLTee.TeeEdiSeri"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92759_0 {
	meta:
		name = "VCLTee.TeeEdiTitl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92810_0 {
	meta:
		name = "VCLTee.TeeEdiWall"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92785_0 {
	meta:
		name = "VCLTee.TeeEditTools"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92814_0 {
	meta:
		name = "VCLTee.TeeEmbossEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93068_0 {
	meta:
		name = "VCLTee.TeeFiltersEditor"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93095_0 {
	meta:
		name = "VCLTee.TeeFormatting"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93101_0 {
	meta:
		name = "VCLTee.TeeFrames"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93128_0 {
	meta:
		name = "VCLTee.TeeFuncEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93161_0 {
	meta:
		name = "VCLTee.TeeGalleryAlternate"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93456_0 {
	meta:
		name = "VCLTee.TeeLisB"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93465_0 {
	meta:
		name = "VCLTee.TeeMargins"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93481_0 {
	meta:
		name = "VCLTee.TeeMouseCursor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93513_0 {
	meta:
		name = "VCLTee.TeeNavigator"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94471_0 {
	meta:
		name = "VCLTee.TeePenDlg"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94559_0 {
	meta:
		name = "VCLTee.TeePrevi"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94898_0 {
	meta:
		name = "VCLTee.TeeSelectList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94916_0 {
	meta:
		name = "VCLTee.TeeShadowEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94995_0 {
	meta:
		name = "VCLTee.TeeSourceEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95109_0 {
	meta:
		name = "VCLTee.TeeStringsEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95124_0 {
	meta:
		name = "VCLTee.TeeSymbolEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95173_0 {
	meta:
		name = "VCLTee.TeeVisualsEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72429_0 {
	meta:
		name = "Vcl.ABAccessibility"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72436_0 {
	meta:
		name = "Vcl.ActnColorMaps"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_72558_0 {
	meta:
		name = "Vcl.ActnCtrls"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73294_0 {
	meta:
		name = "Vcl.ActnPopup"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73643_0 {
	meta:
		name = "Vcl.BandActn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73645_0 {
	meta:
		name = "Vcl.Bind.Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73829_0 {
	meta:
		name = "Vcl.ButtonGroup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74235_0 {
	meta:
		name = "Vcl.CheckLst"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74339_0 {
	meta:
		name = "Vcl.CmAdmCtl"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74368_0 {
	meta:
		name = "Vcl.ColorGrd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76085_0 {
	meta:
		name = "Vcl.ComStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76087_0 {
	meta:
		name = "Vcl.Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_77085_0 {
	meta:
		name = "Vcl.DBActns"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_77168_0 {
	meta:
		name = "Vcl.DBClientActns"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_77894_0 {
	meta:
		name = "Vcl.DBGrids"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78012_0 {
	meta:
		name = "Vcl.DBLookup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78573_0 {
	meta:
		name = "Vcl.Direct2D"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78799_0 {
	meta:
		name = "Vcl.ExtActns"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79477_0 {
	meta:
		name = "Vcl.FileCtrl"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81046_0 {
	meta:
		name = "Vcl.Grids"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81082_0 {
	meta:
		name = "Vcl.IdAntiFreeze"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81084_0 {
	meta:
		name = "Vcl.Imaging.GIFConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81596_0 {
	meta:
		name = "Vcl.Imaging.JConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81948_0 {
	meta:
		name = "Vcl.Imaging.pnglang"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82029_0 {
	meta:
		name = "Vcl.ImgList"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82107_0 {
	meta:
		name = "Vcl.ListActns"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82458_0 {
	meta:
		name = "Vcl.MPlayer"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82162_0 {
	meta:
		name = "Vcl.Mask"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82530_0 {
	meta:
		name = "Vcl.OleConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83078_0 {
	meta:
		name = "Vcl.Outline"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83142_0 {
	meta:
		name = "Vcl.Printers"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84015_0 {
	meta:
		name = "Vcl.RibbonActnCtrls"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84095_0 {
	meta:
		name = "Vcl.RibbonConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84114_0 {
	meta:
		name = "Vcl.RibbonGalleryBar"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84203_0 {
	meta:
		name = "Vcl.Samples.Calendar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84223_0 {
	meta:
		name = "Vcl.Samples.DirOutln"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84246_0 {
	meta:
		name = "Vcl.Samples.Gauges"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84295_0 {
	meta:
		name = "Vcl.Samples.Spin"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84435_0 {
	meta:
		name = "Vcl.ShadowWnd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84437_0 {
	meta:
		name = "Vcl.Shell.ShellConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84621_0 {
	meta:
		name = "Vcl.ShellAnimations"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84656_0 {
	meta:
		name = "Vcl.StdActnMenus"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84760_0 {
	meta:
		name = "Vcl.StdActns"
		size = 8
		refs = "0002 _DV_83"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_85366_0 {
	meta:
		name = "Vcl.StdCtrls"
		size = 8
		refs = "0002 _DV_83"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86866_0 {
	meta:
		name = "Vcl.TabNotBk"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87015_0 {
	meta:
		name = "Vcl.ThemedActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87362_0 {
	meta:
		name = "Vcl.Themes"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88185_0 {
	meta:
		name = "Vcl.Touch.GestureConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88292_0 {
	meta:
		name = "Vcl.Touch.GestureCtrls"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_89467_0 {
	meta:
		name = "Vcl.Touch.Keyboard"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_89698_0 {
	meta:
		name = "Vcl.Touch.KeyboardTypes"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90031_0 {
	meta:
		name = "Vcl.VDBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90103_0 {
	meta:
		name = "Vcl.XPActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90105_0 {
	meta:
		name = "Vcl.XPMan"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95549_0 {
	meta:
		name = "WBComp"
		size = 8
		refs = "0002 _DV_64"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95551_0 {
	meta:
		name = "WbmConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95564_0 {
	meta:
		name = "Web.AutoDisp"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95566_0 {
	meta:
		name = "Web.BrkrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95625_0 {
	meta:
		name = "Web.CGIHTTP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95661_0 {
	meta:
		name = "Web.CopyPrsr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95759_0 {
	meta:
		name = "Web.DBWeb"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95766_0 {
	meta:
		name = "Web.DBXpressWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95773_0 {
	meta:
		name = "Web.DSProd"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96100_0 {
	meta:
		name = "Web.HTTPProd"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96110_0 {
	meta:
		name = "Web.WebBroker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96174_0 {
	meta:
		name = "Web.WebCntxt"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96176_0 {
	meta:
		name = "Web.WebConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96253_0 {
	meta:
		name = "Web.WebFileDispatcher"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96493_0 {
	meta:
		name = "Web.Win.AdsConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96529_0 {
	meta:
		name = "Web.Win.AdsTypes"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_96583_0 {
	meta:
		name = "Web.Win.IsapiHTTP"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_97653_0 {
	meta:
		name = "WebCat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_97763_0 {
	meta:
		name = "WebComp"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_97960_0 {
	meta:
		name = "WebDisp"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_97995_0 {
	meta:
		name = "WebFact"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98295_0 {
	meta:
		name = "WebForm"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98398_0 {
	meta:
		name = "WebModu"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98611_0 {
	meta:
		name = "WebSess"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98805_0 {
	meta:
		name = "WebSnapObjs"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98832_0 {
	meta:
		name = "WebUsers"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99288_0 {
	meta:
		name = "Winapi.ADOInt"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98834_0 {
	meta:
		name = "Winapi.AccCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98892_0 {
	meta:
		name = "Winapi.AclAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99274_0 {
	meta:
		name = "Winapi.ActiveX"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99304_0 {
	meta:
		name = "Winapi.AspTlb"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99306_0 {
	meta:
		name = "Winapi.COMAdmin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99836_0 {
	meta:
		name = "Winapi.ComSvcs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99804_0 {
	meta:
		name = "Winapi.CommCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99834_0 {
	meta:
		name = "Winapi.CommDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99875_0 {
	meta:
		name = "Winapi.Cor"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99877_0 {
	meta:
		name = "Winapi.CorError"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100018_0 {
	meta:
		name = "Winapi.CorHdr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100020_0 {
	meta:
		name = "Winapi.Cpl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100079_0 {
	meta:
		name = "Winapi.D2D1"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100270_0 {
	meta:
		name = "Winapi.D3D10"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100277_0 {
	meta:
		name = "Winapi.D3D10_1"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_100788_0 {
	meta:
		name = "Winapi.D3DX10"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101101_0 {
	meta:
		name = "Winapi.D3DX8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101623_0 {
	meta:
		name = "Winapi.D3DX9"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101658_0 {
	meta:
		name = "Winapi.DDEml"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101950_0 {
	meta:
		name = "Winapi.DX7toDX8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101956_0 {
	meta:
		name = "Winapi.DXFile"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101960_0 {
	meta:
		name = "Winapi.DXGI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101980_0 {
	meta:
		name = "Winapi.DXTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101711_0 {
	meta:
		name = "Winapi.Direct3D"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101741_0 {
	meta:
		name = "Winapi.Direct3D8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101777_0 {
	meta:
		name = "Winapi.Direct3D9"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101797_0 {
	meta:
		name = "Winapi.DirectDraw"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101817_0 {
	meta:
		name = "Winapi.DirectInput"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101824_0 {
	meta:
		name = "Winapi.DirectMusic"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101827_0 {
	meta:
		name = "Winapi.DirectPlay8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101863_0 {
	meta:
		name = "Winapi.DirectShow9"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101885_0 {
	meta:
		name = "Winapi.DirectSound"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101887_0 {
	meta:
		name = "Winapi.Dlgs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101944_0 {
	meta:
		name = "Winapi.Dwmapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101952_0 {
	meta:
		name = "Winapi.DxDiag"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101962_0 {
	meta:
		name = "Winapi.DxgiFormat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101966_0 {
	meta:
		name = "Winapi.DxgiType"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104035_0 {
	meta:
		name = "Winapi.GDIPUTIL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104099_0 {
	meta:
		name = "Winapi.ImageHlp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104234_0 {
	meta:
		name = "Winapi.Imm"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104236_0 {
	meta:
		name = "Winapi.IpExport"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104294_0 {
	meta:
		name = "Winapi.IpHlpApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104296_0 {
	meta:
		name = "Winapi.IpRtrMib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104298_0 {
	meta:
		name = "Winapi.IpTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104300_0 {
	meta:
		name = "Winapi.Isapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104302_0 {
	meta:
		name = "Winapi.Isapi2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104304_0 {
	meta:
		name = "Winapi.KnownFolders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104317_0 {
	meta:
		name = "Winapi.LZExpand"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104545_0 {
	meta:
		name = "Winapi.MMSystem"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104319_0 {
	meta:
		name = "Winapi.Manipulations"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104334_0 {
	meta:
		name = "Winapi.Mapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104340_0 {
	meta:
		name = "Winapi.Messages"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104547_0 {
	meta:
		name = "Winapi.MsInkAut"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104549_0 {
	meta:
		name = "Winapi.MsInkAut15"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104665_0 {
	meta:
		name = "Winapi.Mtx"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104674_0 {
	meta:
		name = "Winapi.MultiMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104677_0 {
	meta:
		name = "Winapi.Nb30"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104679_0 {
	meta:
		name = "Winapi.ObjectArray"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_105356_0 {
	meta:
		name = "Winapi.Ole2"
		size = 8
		refs = "0002 _DV_17"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_105474_0 {
	meta:
		name = "Winapi.OleCtl"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_105476_0 {
	meta:
		name = "Winapi.OleDB"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_105503_0 {
	meta:
		name = "Winapi.OleDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106223_0 {
	meta:
		name = "Winapi.PenWin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106225_0 {
	meta:
		name = "Winapi.PropKey"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106358_0 {
	meta:
		name = "Winapi.PropSys"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106384_0 {
	meta:
		name = "Winapi.PsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106386_0 {
	meta:
		name = "Winapi.Qos"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106388_0 {
	meta:
		name = "Winapi.RegStr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106391_0 {
	meta:
		name = "Winapi.RichEdit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106393_0 {
	meta:
		name = "Winapi.RtsCom"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106531_0 {
	meta:
		name = "Winapi.SHFolder"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107292_0 {
	meta:
		name = "Winapi.ShLwApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106526_0 {
	meta:
		name = "Winapi.ShellAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106841_0 {
	meta:
		name = "Winapi.ShlObj"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107294_0 {
	meta:
		name = "Winapi.StructuredQuery"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107296_0 {
	meta:
		name = "Winapi.StructuredQueryCondition"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107319_0 {
	meta:
		name = "Winapi.TlHelp32"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107321_0 {
	meta:
		name = "Winapi.TpcShrd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107394_0 {
	meta:
		name = "Winapi.UrlMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110920_0 {
	meta:
		name = "Winapi.WMF9"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110344_0 {
	meta:
		name = "Winapi.WinInet"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110419_0 {
	meta:
		name = "Winapi.WinSock"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110827_0 {
	meta:
		name = "Winapi.WinSpool"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110902_0 {
	meta:
		name = "Winapi.WinSvc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_107471_0 {
	meta:
		name = "Winapi.Wincodec"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110356_0 {
	meta:
		name = "Winapi.Winsafer"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_110569_0 {
	meta:
		name = "Winapi.Winsock2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_104655_0 {
	meta:
		name = "Winapi.msxml"
		size = 8
		refs = "0002 _DV_35"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_105368_0 {
	meta:
		name = "Winapi.oleacc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115343_0 {
	meta:
		name = "XMLBrokr"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115366_0 {
	meta:
		name = "XMLTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_111186_0 {
	meta:
		name = "Xml.Internal.AbnfUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_112746_0 {
	meta:
		name = "Xml.Internal.CodecUtilsWin32"
		size = 8
		refs = "0002 _DV_211"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114024_0 {
	meta:
		name = "Xml.Internal.EncodingUtils"
		size = 8
		refs = "0002 _DV_652"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114037_0 {
	meta:
		name = "Xml.Internal.LangUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114095_0 {
	meta:
		name = "Xml.Internal.ParserUtilsWin32"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114146_0 {
	meta:
		name = "Xml.Internal.TreeUtils"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114349_0 {
	meta:
		name = "Xml.Internal.WideStringUtils"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114414_0 {
	meta:
		name = "Xml.Internal.XmlRulesUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114593_0 {
	meta:
		name = "Xml.XMLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114839_0 {
	meta:
		name = "Xml.XMLDoc"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114907_0 {
	meta:
		name = "Xml.XMLIniFile"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_114909_0 {
	meta:
		name = "Xml.XMLIntf"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115263_0 {
	meta:
		name = "Xml.XMLSchema"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115278_0 {
	meta:
		name = "Xml.XMLSchemaTags"
		size = 8
		refs = "0002 _DV_3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115430_0 {
	meta:
		name = "Xmlxform"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36468_0 {
	meta:
		name = "idoc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47440_0 {
	meta:
		name = "mshtmcid"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_115400_0 {
	meta:
		name = "xmlutil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_106_0 {
	meta:
		name = "CoConnection.Create"
		size = 100
		refs = "000c CoConnection.Create 001a CLASS_Connection 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 50 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_107_0 {
	meta:
		name = "CoConnection.CreateRemote"
		size = 128
		refs = "0011 CoConnection.CreateRemote 0021 @WStrFromUStr 002c CLASS_Connection 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 50 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_108_0 {
	meta:
		name = "CoCommand.Create"
		size = 100
		refs = "000c CoCommand.Create 001a CLASS_Command 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 4E 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_109_0 {
	meta:
		name = "CoCommand.CreateRemote"
		size = 128
		refs = "0011 CoCommand.CreateRemote 0021 @WStrFromUStr 002c CLASS_Command 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 4E 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_110_0 {
	meta:
		name = "CoRecordset.Create"
		size = 100
		refs = "000c CoRecordset.Create 001a CLASS_Recordset 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 55 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_111_0 {
	meta:
		name = "CoRecordset.CreateRemote"
		size = 128
		refs = "0011 CoRecordset.CreateRemote 0021 @WStrFromUStr 002c CLASS_Recordset 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 55 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_112_0 {
	meta:
		name = "CoParameter.Create"
		size = 100
		refs = "000c CoParameter.Create 001a CLASS_Parameter 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 0C 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_113_0 {
	meta:
		name = "CoParameter.CreateRemote"
		size = 128
		refs = "0011 CoParameter.CreateRemote 0021 @WStrFromUStr 002c CLASS_Parameter 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 0C 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_116_0 {
	meta:
		name = "CoConnection.Create"
		size = 100
		refs = "000c CoConnection.Create 001a CLASS_Connection 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 50 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_117_0 {
	meta:
		name = "CoConnection.CreateRemote"
		size = 128
		refs = "0011 CoConnection.CreateRemote 0021 @WStrFromUStr 002c CLASS_Connection 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 50 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_118_0 {
	meta:
		name = "CoRecord_.Create"
		size = 100
		refs = "000c CoRecord_.Create 001a CLASS_Record_ 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 62 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_119_0 {
	meta:
		name = "CoRecord_.CreateRemote"
		size = 128
		refs = "0011 CoRecord_.CreateRemote 0021 @WStrFromUStr 002c CLASS_Record_ 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 62 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_120_0 {
	meta:
		name = "CoStream.Create"
		size = 100
		refs = "000c CoStream.Create 001a CLASS_Stream 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 65 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_121_0 {
	meta:
		name = "CoStream.CreateRemote"
		size = 128
		refs = "0011 CoStream.CreateRemote 0021 @WStrFromUStr 002c CLASS_Stream 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 65 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_122_0 {
	meta:
		name = "CoCommand.Create"
		size = 100
		refs = "000c CoCommand.Create 001a CLASS_Command 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 E8 61 67 98 69 72 90 48 AA 65 AD 7C 03 69 7A 6D }
	condition:
		$1
}

rule function_123_0 {
	meta:
		name = "CoCommand.CreateRemote"
		size = 128
		refs = "0011 CoCommand.CreateRemote 0021 @WStrFromUStr 002c CLASS_Command 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 E8 61 67 98 69 72 90 48 AA 65 AD 7C 03 69 7A 6D }
	condition:
		$1
}

rule function_124_0 {
	meta:
		name = "CoRecordset.Create"
		size = 100
		refs = "000c CoRecordset.Create 001a CLASS_Recordset 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 56 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_125_0 {
	meta:
		name = "CoRecordset.CreateRemote"
		size = 128
		refs = "0011 CoRecordset.CreateRemote 0021 @WStrFromUStr 002c CLASS_Recordset 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 56 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_126_0 {
	meta:
		name = "CoParameter.Create"
		size = 100
		refs = "000c CoParameter.Create 001a CLASS_Parameter 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 0C 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_127_0 {
	meta:
		name = "CoParameter.CreateRemote"
		size = 128
		refs = "0011 CoParameter.CreateRemote 0021 @WStrFromUStr 002c CLASS_Parameter 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 0C 15 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_142_0 {
	meta:
		name = "TASPBehaviorEvents.DoInvoke"
		size = 47
		refs = "0026 TBehaviorElementEvents.DoInvoke"
	strings:
		$1 = { 55 8B EC 53 8B DA 8B 55 20 52 0F B7 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 55 08 52 8B D3 E8 ?? ?? ?? ?? 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_143_0 {
	meta:
		name = "TASPBehavior.Destroy"
		size = 47
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001d TCustomPaintedBehavior.Destroy 0028 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 64 01 00 00 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "TASPBehavior.DoCanvasCreated"
		size = 148
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 0014 TASPBehavior.DoCanvasCreated 0019 TFont.SetName 002c TFont.SetSize 0041 TFont.SetStyle 0054 TFont.SetColor 0064 TBrush.SetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA 07 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 0F B6 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA FF 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 33 D2 E8 ?? ?? ?? ?? 5B C3 00 00 B0 04 02 00 FF FF FF FF 0B 00 00 00 53 00 6D 00 61 00 6C 00 6C 00 20 00 46 00 6F 00 6E 00 74 00 73 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_145_0 {
	meta:
		name = "TASPBehavior.DoDraw"
		size = 51
	strings:
		$1 = { 55 8B EC 51 53 33 C9 89 4D FC 80 B8 60 01 00 00 00 74 17 8B 88 64 01 00 00 51 8B 4A 04 8B 12 8B 80 C8 00 00 00 8B 18 FF 53 44 8B 45 FC 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_147_0 {
	meta:
		name = "TASPBehavior.Initialize"
		size = 168
		refs = "000b TCustomPaintedBehavior.Initialize 0019 _Dn_TBitmap 001e TBitmap.Create 0032 TBitmap.SetTransparentColor 0044 TASPBehavior.Initialize 004a HInstance 0055 TBitmap.LoadFromResourceName 006d Rect"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 60 01 00 00 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 64 01 00 00 BA FF 00 FF 00 8B C6 E8 ?? ?? ?? ?? B2 01 8B 83 64 01 00 00 8B 08 FF 51 40 B9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 83 64 01 00 00 E8 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 33 C9 BA 02 00 00 00 B8 04 00 00 00 E8 ?? ?? ?? ?? 8B F4 8D BB 44 01 00 00 A5 A5 A5 A5 83 C4 10 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 0B 00 00 00 41 00 53 00 50 00 42 00 45 00 48 00 41 00 56 00 49 00 4F 00 52 00 00 00 }
	condition:
		$1
}

rule function_148_0 {
	meta:
		name = "TShowTagsBehavior.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomPaintedBehavior.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_97778_0 {
	meta:
		name = "TAbstractNamedVariants.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73537_0 {
	meta:
		name = "TActiveForm.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomForm.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73529_0 {
	meta:
		name = "TActiveFormControl.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TActiveXControl.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73545_0 {
	meta:
		name = "TActiveFormFactory.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TActiveXControlFactory.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3339_0 {
	meta:
		name = "TAmazonService.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCloudService.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28028_0 {
	meta:
		name = "TAzureConnectionString.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28376_0 {
	meta:
		name = "TBBlock.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TBEnumerationItem<DSAzureBlob.TBBlockList>.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28370_0 {
	meta:
		name = "TBPageRange.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TBEnumerationItem<DSAzureBlob.TBPageList>.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28362_0 {
	meta:
		name = "TBSignedIdentifier.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TBEnumerationItem<DSAzureBlob.TBSignedIdentifiers>.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1549_0 {
	meta:
		name = "TBaseBindExpression.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCommonBindComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2690_0 {
	meta:
		name = "TBaseDBGridLinkColumn.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCollectionItem.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1268_0 {
	meta:
		name = "TBinder.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_74275_0 {
	meta:
		name = "TCOMAdminCatalog.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_74322_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_74307_0 {
	meta:
		name = "TCOMAdminCatalogObject.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1512_0 {
	meta:
		name = "TCommonBindComponent.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TContainedBindComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50677_0 {
	meta:
		name = "TConnectionIntercept.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1477_0 {
	meta:
		name = "TContainedBindComponent.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_75624_0 {
	meta:
		name = "TCoolBands.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCollection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1576_0 {
	meta:
		name = "TCustomBindScope.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TBaseBindScopeComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_84903_0 {
	meta:
		name = "TCustomComboBoxStrings.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TStrings.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_96670_0 {
	meta:
		name = "TCustomTcpServer.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TBaseSocket.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_38845_0 {
	meta:
		name = "TCustomZlibStream.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6645_0 {
	meta:
		name = "TDBXConnectionValue.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXWritableValue.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13680_0 {
	meta:
		name = "TDBXConsoleTraceOutput.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXTraceOutput.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24329_0 {
	meta:
		name = "TDBXCropRequestFilter.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSRequestFilter<Data.DBXCommon.TDBXValue>.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8552_0 {
	meta:
		name = "TDBXDataSetReader.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXTableReader.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8713_0 {
	meta:
		name = "TDBXDelegateParameterList.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXParameterList.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12670_0 {
	meta:
		name = "TDBXInt32Object.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10908_0 {
	meta:
		name = "TDBXJSonServerOutputConnectionHandler.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXJSonConnectionHandler.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7539_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXConnectionFactory.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7605_0 {
	meta:
		name = "TDBXNullValue.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXWritableValue.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12405_0 {
	meta:
		name = "TDBXOdbcBlockMgr.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8556_0 {
	meta:
		name = "TDBXParamsReader.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXTableReader.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12812_0 {
	meta:
		name = "TDBXPoolCommand.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXCommand.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12824_0 {
	meta:
		name = "TDBXPoolReader.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXReader.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7599_0 {
	meta:
		name = "TDBXStateItemList.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7183_0 {
	meta:
		name = "TDBXStringValue.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXWideStringValue.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13668_0 {
	meta:
		name = "TDBXTraceParameter.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXDelegateParameter.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13564_0 {
	meta:
		name = "TDBXTraceParameterList.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXDelegateParameterList.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13578_0 {
	meta:
		name = "TDBXTraceWritableValue.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXDelegateWritableValue.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6692_0 {
	meta:
		name = "TDBXValueType.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6831_0 {
	meta:
		name = "TDBXWritableValue.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXValue.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81147_0 {
	meta:
		name = "TDIBReader.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17678_0 {
	meta:
		name = "TDSCacheResponseHandler.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSJsonResponseHandler.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17655_0 {
	meta:
		name = "TDSClientCallbackChannelManager.TDSChannelCallback.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17716_0 {
	meta:
		name = "TDSClientCallbackChannelManager.TDSExecuteThread.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TThread.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17191_0 {
	meta:
		name = "TDSHTTPSServerIndy.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSHTTPServerIndy.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25759_0 {
	meta:
		name = "TDSJSONProtocolHandlerFactory.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24272_0 {
	meta:
		name = "TDSJSONService.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSService.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24261_0 {
	meta:
		name = "TDSRESTService.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSService.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24402_0 {
	meta:
		name = "TDSRequestFilter<Data.DBXCommon.TDBXValue>.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16104_0 {
	meta:
		name = "TDSRestCacheCommand.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23318_0 {
	meta:
		name = "TDSServerClass.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23339_0 {
	meta:
		name = "TDSServerDriver.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDBXDriver.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24194_0 {
	meta:
		name = "TDSTunnelSession.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TDSSession.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_96200_0 {
	meta:
		name = "TDispatchFileRequest.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "TEnumDispatcherAS.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomEnumDispatcher.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_97416_0 {
	meta:
		name = "TEventDispatchEx.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81460_0 {
	meta:
		name = "TGIFApplicationExtension.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TGIFExtension.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_103875_0 {
	meta:
		name = "TGPFontCollection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_103881_0 {
	meta:
		name = "TGPInstalledFontCollection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TGPFontCollection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_88649_0 {
	meta:
		name = "TGestureCollection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCollection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43229_0 {
	meta:
		name = "TIWCallback.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_45536_0 {
	meta:
		name = "TIWMarkupLanguageTagCollection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TList.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_39888_0 {
	meta:
		name = "TIdContextPeer.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_35386_0 {
	meta:
		name = "TIdIMAP4Server.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdCmdTCPServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_35660_0 {
	meta:
		name = "TIdIPMCastListenerThread.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdThread.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36138_0 {
	meta:
		name = "TIdMessageClient.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdExplicitTLSClient.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36382_0 {
	meta:
		name = "TIdNNTP.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdMessageClient.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36729_0 {
	meta:
		name = "TIdRemoteCMDClient.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdTCPConnection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37488_0 {
	meta:
		name = "TIdSSLCipher.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37900_0 {
	meta:
		name = "TIdStackWindows.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TIdStack.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41533_0 {
	meta:
		name = "TInSSLCipher.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41940_0 {
	meta:
		name = "TInStackWindows.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TInStack.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_40460_0 {
	meta:
		name = "TIndyTCPConnectionTransport.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48247_0 {
	meta:
		name = "TInternetExplorer.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48334_0 {
	meta:
		name = "TInternetExplorerMedium.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36311_0 {
	meta:
		name = "TIpProperty.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_69466_0 {
	meta:
		name = "TLanguages.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49462_0 {
	meta:
		name = "TLogLinkedWebNode.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TLinkedWebNode.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47658_0 {
	meta:
		name = "TMaster.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_98797_0 {
	meta:
		name = "TModuleObj.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObjectScripter.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_98678_0 {
	meta:
		name = "TModulesObj.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObjectScripter.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47838_0 {
	meta:
		name = "TOLECtrl.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73363_0 {
	meta:
		name = "TOleStream.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47717_0 {
	meta:
		name = "TOutlookApplication.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47596_0 {
	meta:
		name = "TPowerPointApplication.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47494_0 {
	meta:
		name = "TPowerPointPresentation.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47453_0 {
	meta:
		name = "TPowerPointSlide.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47940_0 {
	meta:
		name = "TPowerRex.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73557_0 {
	meta:
		name = "TPropertyPageImpl.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_67325_0 {
	meta:
		name = "TRawVirtualClass.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50716_0 {
	meta:
		name = "TResponseTransaction.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49341_0 {
	meta:
		name = "TSOAPDOMProcessor.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TComponent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14311_0 {
	meta:
		name = "TSQLBlobStream.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TMemoryStream.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48059_0 {
	meta:
		name = "TScriptObjectContainer.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80492_0 {
	meta:
		name = "TSharedImage.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48505_0 {
	meta:
		name = "TShellNameSpace.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48445_0 {
	meta:
		name = "TShellUIHelper.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48423_0 {
	meta:
		name = "TShellWindows.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TOleServer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48546_0 {
	meta:
		name = "TSimpleDataSet.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomClientDataSet.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49277_0 {
	meta:
		name = "TSoapConnection.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomConnection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48646_0 {
	meta:
		name = "TStreamLoader.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46725_0 {
	meta:
		name = "TTIWComboboxes.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46684_0 {
	meta:
		name = "TTIWHTMLEdGlyphs.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46732_0 {
	meta:
		name = "TTIWHTMLEdHints.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TPersistent.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_78370_0 {
	meta:
		name = "TTaskDialogButtons.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCollection.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49485_0 {
	meta:
		name = "TTypeTranslator.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_97352_0 {
	meta:
		name = "TWebComponentsStub.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49207_0 {
	meta:
		name = "TWebRequestStream.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50623_0 {
	meta:
		name = "TWebServerResponse.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TWebResponse.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48079_0 {
	meta:
		name = "TXMLDocument.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_114630_0 {
	meta:
		name = "TXMLNodeList.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TObject.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48067_0 {
	meta:
		name = "TXMLRowSets.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TScriptObjectContainer.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_115414_0 {
	meta:
		name = "TXMLTransformProvider.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TCustomProvider.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50403_0 {
	meta:
		name = "TXSCustomDateTime.Destroy"
		size = 36
		refs = "0003 @BeforeDestruction 0012 TRemotable.Destroy 001d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_149_0 {
	meta:
		name = "TShowTagsBehavior.DoCanvasCreated"
		size = 112
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 0014 TShowTagsBehavior.DoCanvasCreated 0019 TFont.SetName 002c TFont.SetSize 0041 TFont.SetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA 06 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 0F B6 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 B0 04 02 00 FF FF FF FF 0B 00 00 00 53 00 6D 00 61 00 6C 00 6C 00 20 00 46 00 6F 00 6E 00 74 00 73 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_150_0 {
	meta:
		name = "TShowTagsBehavior.DoDraw"
		size = 2604
		refs = "0023 TShowTagsBehavior.DoDraw 0040 TCustomPaintedBehavior.DoDraw 0055 @IntfClear 0061 TCustomElementBehavior.GetElement 0072 @CheckAutoResult 008b Supports 00b7 TFont.SetColor 00e2 TBrush.SetStyle 00ea @WStrClr 010f @UStrFromWStr 0120 TCustomCanvas.TextHeight 0162 @OleVarFromInt 01ab @IntfCast 0276 @IntfCopy 02d0 @WStrEqual 0398 @WStrCatN 03ff TCustomCanvas.TextWidth 0413 PtInRect 04ff CompareText 0808 @UStrClr 089c @WStrArrayClr 08a8 OleVariant 08b2 @FinalizeArray 093c @UStrArrayClr 0952 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 20 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 89 4D E4 89 55 E8 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 45 0C 50 8B 45 08 50 8B 4D E4 8B 55 E8 8B 45 EC E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 0F 85 98 07 00 00 8D 45 B4 E8 ?? ?? ?? ?? 50 8D 55 B0 8B 45 EC E8 ?? ?? ?? ?? 8B 45 B0 50 8B 00 FF 90 74 01 00 00 E8 ?? ?? ?? ?? 8B 45 B4 50 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 0F 84 52 07 00 00 8B 45 EC 8B 80 60 01 00 00 85 C0 74 19 8B 90 EC 00 00 00 8B 45 EC 8B 80 C8 00 00 00 8B 40 40 E8 ?? ?? ?? ?? EB 16 8B 45 EC 8B 80 C8 00 00 00 8B 40 40 BA 80 80 80 00 E8 ?? ?? ?? ?? 8B 45 EC 8B 80 C8 00 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 8D 45 A8 E8 ?? ?? ?? ?? 50 8D 55 A4 8B 45 EC E8 ?? ?? ?? ?? 8B 45 A4 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 55 A8 8D 45 AC E8 ?? ?? ?? ?? 8B 55 AC 8B 45 EC 8B 80 C8 00 00 00 E8 ?? ?? ?? ?? 89 45 D4 8D 45 A0 50 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 A0 48 85 C0 0F 8C A4 06 00 00 40 89 45 D0 C7 45 DC 00 00 00 00 8D 45 9C E8 ?? ?? ?? ?? 50 8D 45 8C 8B 55 DC B1 FC E8 ?? ?? ?? ?? FF 75 98 FF 75 94 FF 75 90 FF 75 8C 8D 85 7C FF FF FF 8B 55 DC B1 FC E8 ?? ?? ?? ?? FF 75 88 FF 75 84 FF 75 80 FF B5 7C FF FF FF 8B 45 F8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 8B 55 9C 8D 45 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D0 00 00 00 E8 ?? ?? ?? ?? 8B 7D A0 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D4 00 00 00 E8 ?? ?? ?? ?? 8B 75 A0 8B 45 E8 8B 40 04 99 33 C2 2B C2 8B 55 E4 03 42 0C 3B F0 0F 8F E5 05 00 00 8B 45 EC 8B 98 60 01 00 00 85 DB 0F 84 A1 00 00 00 8D 85 74 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 74 FF FF FF 8D 85 78 FF FF FF E8 ?? ?? ?? ?? 8B 95 78 FF FF FF 8B 83 E8 00 00 00 8B 08 FF 51 54 85 C0 0F 8D 90 05 00 00 EB 5B 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 90 E0 00 00 00 E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 8D 45 FC E8 ?? ?? ?? ?? 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D0 00 00 00 E8 ?? ?? ?? ?? 03 7D A0 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D4 00 00 00 E8 ?? ?? ?? ?? 03 75 A0 8D 85 6C FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 85 75 FF FF FF 8D 85 68 FF FF FF E8 ?? ?? ?? ?? 50 8D 85 58 FF FF FF 8B 55 DC B1 FC E8 ?? ?? ?? ?? FF B5 64 FF FF FF FF B5 60 FF FF FF FF B5 5C FF FF FF FF B5 58 FF FF FF 8D 85 48 FF FF FF 8B 55 DC B1 FC E8 ?? ?? ?? ?? FF B5 54 FF FF FF FF B5 50 FF FF FF FF B5 4C FF FF FF FF B5 48 FF FF FF 8B 45 F8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 8B 95 68 FF FF FF 8D 45 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 03 38 8B 45 E8 03 70 04 68 ?? ?? ?? ?? 8D 85 40 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? FF B5 40 FF FF FF 68 ?? ?? ?? ?? 8D 85 44 FF FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 95 44 FF FF FF 8D 45 F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 38 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? FF B5 38 FF FF FF 68 ?? ?? ?? ?? 8D 85 3C FF FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 95 3C FF FF FF 8D 45 F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 80 C8 00 00 00 8B 55 F4 E8 ?? ?? ?? ?? 89 45 D8 89 7D C8 89 75 CC 8D 55 C8 8B 45 E4 E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 4B 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D8 00 00 00 E8 ?? ?? ?? ?? 8B 5D A0 03 DF 2B 5D D8 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 8B 45 A0 03 C6 2B 45 D4 89 5D C0 89 45 C4 8D 55 C0 8B 45 E4 E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 4E 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 D8 00 00 00 E8 ?? ?? ?? ?? 8B 5D A0 03 DF 2B 5D D8 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 8B 45 A0 03 C6 2B 45 D4 83 C0 04 89 5D B8 89 45 BC 8D 55 B8 8B 45 E4 E8 ?? ?? ?? ?? 84 C0 0F 84 15 03 00 00 8D 85 30 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 30 FF FF FF 8D 85 34 FF FF FF E8 ?? ?? ?? ?? 8B 85 34 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 21 8B 45 F4 50 8B CE 83 E9 04 8B 45 EC 8B 80 C8 00 00 00 8B D7 8B 18 FF 93 90 00 00 00 E9 2D 01 00 00 8D 85 28 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 28 FF FF FF 8D 85 2C FF FF FF E8 ?? ?? ?? ?? 8B 85 2C FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 21 8B 45 F4 50 8B CE 83 E9 04 8B 45 EC 8B 80 C8 00 00 00 8B D7 8B 18 FF 93 90 00 00 00 E9 CD 00 00 00 8D 85 20 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 20 FF FF FF 8D 85 24 FF FF FF E8 ?? ?? ?? ?? 8B 85 24 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 1B 8B 45 F4 50 8B 45 EC 8B 80 C8 00 00 00 8B CE 8B D7 8B 18 FF 93 90 00 00 00 EB 73 8D 85 18 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 18 FF FF FF 8D 85 1C FF FF FF E8 ?? ?? ?? ?? 8B 85 1C FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 1B 8B 45 F4 50 8B 45 EC 8B 80 C8 00 00 00 8B CE 8B D7 8B 18 FF 93 90 00 00 00 EB 19 8B 45 F4 50 8B 45 EC 8B 80 C8 00 00 00 8B CE 8B D7 8B 18 FF 93 90 00 00 00 8B 45 EC 8B 80 C8 00 00 00 8B 55 F0 E8 ?? ?? ?? ?? 89 45 D8 8D 85 10 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 10 FF FF FF 8D 85 14 FF FF FF E8 ?? ?? ?? ?? 8B 85 14 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 31 01 00 00 8D 85 08 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 08 FF FF FF 8D 85 0C FF FF FF E8 ?? ?? ?? ?? 8B 85 0C FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 EE 00 00 00 8D 85 00 FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 95 00 FF FF FF 8D 85 04 FF FF FF E8 ?? ?? ?? ?? 8B 85 04 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 5A 8B 45 F0 50 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 03 75 A0 2B 75 D4 83 C6 04 56 8D 85 FC FE FF FF 50 8B 45 FC 50 8B 00 FF 90 D8 00 00 00 E8 ?? ?? ?? ?? 8B 95 FC FE FF FF 03 D7 2B 55 D8 8B 45 EC 8B 80 C8 00 00 00 59 8B 18 FF 93 90 00 00 00 EB 55 8B 45 F0 50 8D 45 A0 50 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 03 75 A0 2B 75 D4 56 8D 85 FC FE FF FF 50 8B 45 FC 50 8B 00 FF 90 D8 00 00 00 E8 ?? ?? ?? ?? 8B 95 FC FE FF FF 03 D7 2B 55 D8 8B 45 EC 8B 80 C8 00 00 00 59 8B 18 FF 93 90 00 00 00 FF 45 DC FF 4D D0 0F 85 67 F9 FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 00 FF FF FF E8 ?? ?? ?? ?? 8D 85 04 FF FF FF E8 ?? ?? ?? ?? 8D 85 08 FF FF FF E8 ?? ?? ?? ?? 8D 85 0C FF FF FF E8 ?? ?? ?? ?? 8D 85 10 FF FF FF E8 ?? ?? ?? ?? 8D 85 14 FF FF FF E8 ?? ?? ?? ?? 8D 85 18 FF FF FF E8 ?? ?? ?? ?? 8D 85 1C FF FF FF E8 ?? ?? ?? ?? 8D 85 20 FF FF FF E8 ?? ?? ?? ?? 8D 85 24 FF FF FF E8 ?? ?? ?? ?? 8D 85 28 FF FF FF E8 ?? ?? ?? ?? 8D 85 2C FF FF FF E8 ?? ?? ?? ?? 8D 85 30 FF FF FF E8 ?? ?? ?? ?? 8D 85 34 FF FF FF E8 ?? ?? ?? ?? 8D 85 38 FF FF FF BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 85 48 FF FF FF 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 85 68 FF FF FF E8 ?? ?? ?? ?? 8D 85 6C FF FF FF E8 ?? ?? ?? ?? 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8D 85 74 FF FF FF E8 ?? ?? ?? ?? 8D 85 78 FF FF FF E8 ?? ?? ?? ?? 8D 85 7C FF FF FF 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 9C E8 ?? ?? ?? ?? 8D 45 A4 E8 ?? ?? ?? ?? 8D 45 A8 E8 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? 8D 45 B0 E8 ?? ?? ?? ?? 8D 45 B4 E8 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? E9 9B FE FF FF 8B 45 E0 5F 5E 5B 8B E5 5D C2 08 00 00 1F F2 50 30 B5 98 CF 11 BB 82 00 AA 00 BD CE 0B FF F1 50 30 B5 98 CF 11 BB 82 00 AA 00 BD CE 0B 08 00 00 00 42 00 4F 00 44 00 59 00 00 00 00 00 02 00 00 00 3C 00 00 00 02 00 00 00 3E 00 00 00 04 00 00 00 3C 00 2F 00 00 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 42 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 54 00 41 00 42 00 4C 00 45 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 54 00 52 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 54 00 44 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 48 00 52 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 42 00 52 00 00 00 00 00 }
	condition:
		$1
}

rule function_151_0 {
	meta:
		name = "TShowTagsBehavior.Initialize"
		size = 44
		refs = "0006 TCustomPaintedBehavior.Initialize 0014 TShowTagsBehavior.Initialize"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 42 01 00 00 08 0F B7 05 ?? ?? ?? ?? 66 0B 83 40 01 00 00 66 89 83 40 01 00 00 5B C3 10 00 00 00 }
	condition:
		$1
}

rule function_152_0 {
	meta:
		name = "TShowTagsBehaviorWrapper.Create"
		size = 260
		refs = "000e @ClassCreate 001c TCustomBehaviorWrapper.Create 002d _Dn_TStringList 0032 TStringList.Create 0043 TStringList.SetSorted 004e TShowTagsBehaviorWrapper.Create 0090 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C7 83 EC 00 00 00 80 80 80 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 E8 00 00 00 8B C6 B2 01 E8 ?? ?? ?? ?? 8B 83 E8 00 00 00 BA ?? ?? ?? ?? 8B 08 FF 51 38 8B 83 E8 00 00 00 BA ?? ?? ?? ?? 8B 08 FF 51 38 8B 83 E8 00 00 00 BA ?? ?? ?? ?? 8B 08 FF 51 38 8B 83 E8 00 00 00 BA ?? ?? ?? ?? 8B 08 FF 51 38 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 54 00 42 00 4F 00 44 00 59 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 21 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 53 00 43 00 52 00 49 00 50 00 54 00 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 53 00 54 00 59 00 4C 00 45 00 00 00 }
	condition:
		$1
}

rule function_153_0 {
	meta:
		name = "TShowTagsBehaviorWrapper.Destroy"
		size = 47
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001d TCustomBehaviorWrapper.Destroy 0028 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 E8 00 00 00 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_154_0 {
	meta:
		name = "TShowTagsBehaviorWrapper.DoCreated"
		size = 54
		refs = "000b TCustomBehaviorWrapper.DoCreated 0013 _DV_TShowTagsBehavior 0018 @IsClass 0029 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 13 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 98 60 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_156_0 {
	meta:
		name = "TShowTagsBehaviorWrapper.SetIgnoreTags"
		size = 12
	strings:
		$1 = { 8B 80 E8 00 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_157_0 {
	meta:
		name = "TTagBehavior.Detach"
		size = 29
		refs = "000e @IntfClear 0014 TCustomPaintedBehavior.Detach"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8D 83 60 01 00 00 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_158_0 {
	meta:
		name = "InRect"
		size = 69
	strings:
		$1 = { 56 57 83 C4 E8 8B F2 8D 7C 24 08 A5 A5 A5 A5 8B F0 8D 3C 24 A5 A5 8B 04 24 3B 44 24 08 7C 1A 3B 44 24 10 7F 14 8B 44 24 04 3B 44 24 0C 7C 0A 8B 44 24 04 3B 44 24 14 7E 04 33 C0 EB 02 B0 01 83 C4 18 5F 5E C3 }
	condition:
		$1
}

rule function_159_0 {
	meta:
		name = "TTagBehavior.DoCanvasCreated"
		size = 148
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 0014 TTagBehavior.DoCanvasCreated 0019 TFont.SetName 002e TFont.SetStyle 0041 TFont.SetSize 0054 TFont.SetColor 0064 TBrush.SetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 0F B6 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA 07 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA FF 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 5B C3 00 00 B0 04 02 00 FF FF FF FF 0B 00 00 00 53 00 6D 00 61 00 6C 00 6C 00 20 00 46 00 6F 00 6E 00 74 00 73 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_160_0 {
	meta:
		name = "TTagBehavior.DoDraw"
		size = 916
		refs = "0022 TTagBehavior.DoDraw 003d TCustomPaintedBehavior.DoDraw 006f @CheckAutoResult 009e @IntfCopy 00a8 @IntfClear 010c @WStrClr 0128 @WStrEqual 013e @IntfCast 019c @UStrFromWStr 01aa TCustomCanvas.TextHeight 01e5 TCustomCanvas.TextWidth 01f3 Rect 024d @WStrCatN 029e IntersectRect 02fe @UStrClr 030b @WStrArrayClr 0351 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B D9 89 55 F0 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 45 0C 50 8B 45 08 50 8B CB 8B 55 F0 8B C6 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 0F 85 97 02 00 00 83 BE 60 01 00 00 00 0F 84 8A 02 00 00 8D 45 C0 50 8B 86 60 01 00 00 50 8B 00 FF 90 D0 00 00 00 E8 ?? ?? ?? ?? 8B 7D C0 8D 45 C0 50 8B 86 60 01 00 00 50 8B 00 FF 90 D4 00 00 00 E8 ?? ?? ?? ?? 8B 45 C0 89 45 E8 8D 45 FC 8B 96 60 01 00 00 E8 ?? ?? ?? ?? EB 5E 8D 45 BC E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 90 E0 00 00 00 E8 ?? ?? ?? ?? 8B 55 BC 8D 45 FC E8 ?? ?? ?? ?? 83 7D FC 00 74 33 8D 45 C0 50 8B 45 FC 50 8B 00 FF 90 D0 00 00 00 E8 ?? ?? ?? ?? 03 7D C0 8D 45 C0 50 8B 45 FC 50 8B 00 FF 90 D4 00 00 00 E8 ?? ?? ?? ?? 8B 45 C0 01 45 E8 83 7D FC 00 74 2A 8D 45 B8 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 45 B8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 85 72 FF FF FF 8D 45 F8 8B 55 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 C0 50 8B 45 F8 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 C0 F7 D8 03 F8 8D 45 C0 50 8B 45 F8 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 C0 F7 D8 01 45 E8 8D 45 B0 E8 ?? ?? ?? ?? 50 8B 86 60 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 55 B0 8D 45 B4 E8 ?? ?? ?? ?? 8B 55 B4 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 03 45 E8 50 8D 45 D4 50 8D 45 A8 E8 ?? ?? ?? ?? 50 8B 86 60 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 55 A8 8D 45 AC E8 ?? ?? ?? ?? 8B 55 AC 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 8B C8 03 CF 8B 55 E8 8B C7 E8 ?? ?? ?? ?? 8D 45 C0 50 8B 45 F8 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 F0 8B 40 04 99 33 C2 2B C2 2B 45 C0 89 45 E4 68 ?? ?? ?? ?? 8D 45 A0 E8 ?? ?? ?? ?? 50 8B 86 60 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? FF 75 A0 68 ?? ?? ?? ?? 8D 45 A4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 55 A4 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 C0 50 8B 45 F8 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 F0 8B 40 04 99 33 C2 2B C2 03 43 0C 2B 45 C0 50 8D 45 90 50 8B 4B 08 8B 03 8B 55 E4 E8 ?? ?? ?? ?? 8D 4D 90 8D 55 D4 8D 45 C4 E8 ?? ?? ?? ?? 84 C0 74 3F 8D 45 88 E8 ?? ?? ?? ?? 50 8B 86 60 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8B 55 88 8D 45 8C E8 ?? ?? ?? ?? 8B 45 8C 50 8B 4D E8 2B 4D E4 8B D7 8B 86 C8 00 00 00 8B 18 FF 93 90 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 88 E8 ?? ?? ?? ?? 8D 45 8C E8 ?? ?? ?? ?? 8D 45 A0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? 8D 45 B0 E8 ?? ?? ?? ?? 8D 45 B4 E8 ?? ?? ?? ?? 8D 45 B8 E8 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB 9B 8B 45 EC 5F 5E 5B 8B E5 5D C2 08 00 00 08 00 00 00 42 00 4F 00 44 00 59 00 00 00 00 00 34 F4 50 30 B5 98 CF 11 BB 82 00 AA 00 BD CE 0B 02 00 00 00 3C 00 00 00 02 00 00 00 3E 00 00 00 }
	condition:
		$1
}

rule function_161_0 {
	meta:
		name = "TTagBehavior.SetTag"
		size = 44
		refs = "0017 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B B3 60 01 00 00 74 1B 8D 83 60 01 00 00 8B D6 E8 ?? ?? ?? ?? 6A 00 8B 83 CC 00 00 00 50 8B 00 FF 50 10 5E 5B C3 }
	condition:
		$1
}

rule function_162_0 {
	meta:
		name = "TRulerBehavior.DoCanvasCreated"
		size = 144
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 001a TPen.SetColor 0028 TRulerBehavior.DoCanvasCreated 002d TFont.SetName 0040 TFont.SetSize 0054 TFont.SetColor 0064 TBrush.SetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 8B 93 6C 01 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA 07 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 8B 93 68 01 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 5B C3 00 00 B0 04 02 00 FF FF FF FF 0B 00 00 00 53 00 6D 00 61 00 6C 00 6C 00 20 00 46 00 6F 00 6E 00 74 00 73 00 00 00 }
	condition:
		$1
}

rule function_163_0 {
	meta:
		name = "TRulerBehavior.DoDraw"
		size = 1661
		refs = "0023 TRulerBehavior.DoDraw 003f TCustomPaintedBehavior.DoDraw 0072 TCustomElementBehavior.GetElement2 0083 @CheckAutoResult 00ca TFont.SetOrientation 01d7 IntToStr 01e5 TCustomCanvas.TextWidth 037b TCustomCanvas.TextHeight 0640 IHTMLElement2 064a @FinalizeArray 0665 @UStrClr 066b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 0A 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 89 4D F4 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 45 0C 50 8B 45 08 50 8B 4D F4 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 0F 85 DE 05 00 00 F6 86 61 01 00 00 02 75 0D F6 86 61 01 00 00 04 0F 84 61 03 00 00 33 FF 8D 45 E8 50 8D 55 E4 8B C6 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 83 7D E8 00 74 31 8D 45 E8 50 8D 55 E0 8B C6 E8 ?? ?? ?? ?? 8B 45 E0 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 B9 0A 00 00 00 99 F7 F9 BF F6 FF FF FF 2B FA 8B 86 C8 00 00 00 8B 40 40 33 D2 E8 ?? ?? ?? ?? E9 E8 02 00 00 F6 86 61 01 00 00 02 0F 84 3F 01 00 00 8D 45 E8 50 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 8B 45 DC 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 4D E8 8B 45 F8 8B 40 04 99 33 C2 2B C2 3B C8 0F 85 0A 01 00 00 33 C9 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 64 8D 45 E8 50 8D 55 D8 8B C6 E8 ?? ?? ?? ?? 8B 45 D8 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 32 00 00 00 99 F7 F9 85 D2 0F 85 B5 00 00 00 B9 07 00 00 00 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 60 80 BE 60 01 00 00 00 0F 84 A8 00 00 00 85 FF 0F 84 A0 00 00 00 8D 45 E8 50 8D 55 D4 8B C6 E8 ?? ?? ?? ?? 8B 45 D4 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 64 00 00 00 99 F7 F9 85 D2 75 70 8D 45 E8 50 8D 55 D0 8B C6 E8 ?? ?? ?? ?? 8B 45 D0 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 89 45 EC 8B 45 FC 50 8B D7 83 EA 02 2B 55 EC B9 03 00 00 00 8B 86 C8 00 00 00 8B 18 FF 93 90 00 00 00 EB 12 B9 03 00 00 00 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 60 F6 86 61 01 00 00 04 0F 84 8C 01 00 00 8D 45 E8 50 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 8B 45 CC 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 F8 8B 40 04 99 33 C2 2B C2 8B D8 2B 5D E8 8B 45 F4 03 58 0C 8D 45 C8 50 8D 55 C4 8B C6 E8 ?? ?? ?? ?? 8B 45 C4 50 8B 00 FF 90 F8 00 00 00 E8 ?? ?? ?? ?? 3B 5D C8 0F 8C 2F 01 00 00 8B 4D F4 8B 49 0C 41 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 64 8D 45 E8 50 8D 55 C0 8B C6 E8 ?? ?? ?? ?? 8B 45 C0 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 32 00 00 00 99 F7 F9 85 D2 0F 85 D1 00 00 00 8B 4D F4 8B 49 0C 83 E9 07 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 60 80 BE 60 01 00 00 00 0F 84 C4 00 00 00 85 FF 0F 84 BC 00 00 00 8D 45 E8 50 8D 55 BC 8B C6 E8 ?? ?? ?? ?? 8B 45 BC 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 64 00 00 00 99 F7 F9 85 D2 0F 85 88 00 00 00 8D 45 E8 50 8D 55 B8 8B C6 E8 ?? ?? ?? ?? 8B 45 B8 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 89 45 EC 8B 45 FC 50 8B 55 FC 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 8B 4D F4 8B 49 0C 83 E9 04 2B C8 8B D7 83 EA 02 2B 55 EC 8B 86 C8 00 00 00 8B 18 FF 93 90 00 00 00 EB 16 8B 4D F4 8B 49 0C 83 E9 04 8B D7 8B 86 C8 00 00 00 8B 18 FF 53 60 83 C7 05 8B 45 F4 3B 78 08 0F 8E 0C FD FF FF F6 86 61 01 00 00 01 75 0D F6 86 61 01 00 00 08 0F 84 51 02 00 00 8B 86 C8 00 00 00 8B 40 40 BA 84 03 00 00 E8 ?? ?? ?? ?? 33 FF 8D 45 E8 50 8D 55 B4 8B C6 E8 ?? ?? ?? ?? 8B 45 B4 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 83 7D E8 00 0F 84 07 02 00 00 8D 45 E8 50 8D 55 B0 8B C6 E8 ?? ?? ?? ?? 8B 45 B0 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 B9 0A 00 00 00 99 F7 F9 BF F6 FF FF FF 2B FA E9 D1 01 00 00 F6 86 61 01 00 00 01 0F 84 BC 00 00 00 8B CF 33 D2 8B 86 C8 00 00 00 8B 18 FF 53 64 8D 45 E8 50 8D 55 AC 8B C6 E8 ?? ?? ?? ?? 8B 45 AC 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 32 00 00 00 99 F7 F9 85 D2 75 6B 8B CF BA 07 00 00 00 8B 86 C8 00 00 00 8B 18 FF 53 60 80 BE 60 01 00 00 00 74 62 85 FF 74 5E 8B 45 F8 8B 40 04 99 33 C2 2B C2 03 C7 B9 64 00 00 00 99 F7 F9 85 D2 75 45 8B 45 F8 8B 40 04 99 33 C2 2B C2 03 C7 8D 55 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B CF 83 E9 02 BA 04 00 00 00 8B 86 C8 00 00 00 8B 18 FF 93 90 00 00 00 EB 12 8B CF BA 04 00 00 00 8B 86 C8 00 00 00 8B 18 FF 53 60 F6 86 61 01 00 00 08 0F 84 F8 00 00 00 8B 55 F4 8B 52 08 83 EA 06 8B CF 8B 86 C8 00 00 00 8B 18 FF 53 64 8D 45 E8 50 8D 55 A8 8B C6 E8 ?? ?? ?? ?? 8B 45 A8 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 45 E8 03 C7 B9 32 00 00 00 99 F7 F9 85 D2 0F 85 85 00 00 00 8B 55 F4 8B 52 08 8B CF 8B 86 C8 00 00 00 8B 18 FF 53 60 80 BE 60 01 00 00 00 0F 84 8E 00 00 00 85 FF 0F 84 86 00 00 00 8B 45 F8 8B 40 04 99 33 C2 2B C2 03 C7 B9 64 00 00 00 99 F7 F9 85 D2 75 6D 8B 45 F8 8B 40 04 99 33 C2 2B C2 03 C7 8D 55 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B 55 FC 8B 86 C8 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 52 08 2B D0 8B CF 83 E9 02 8B 86 C8 00 00 00 8B 18 FF 93 90 00 00 00 EB 29 8B 55 F4 8B 52 08 83 EA 03 8B CF 8B 86 C8 00 00 00 8B 18 FF 53 64 8B 55 F4 8B 52 08 8B CF 8B 86 C8 00 00 00 8B 18 FF 53 60 83 C7 05 8B 45 F4 3B 78 0C 0F 8E 23 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 A8 8B 15 ?? ?? ?? ?? B9 08 00 00 00 E8 ?? ?? ?? ?? 8D 45 CC 8B 15 ?? ?? ?? ?? B9 07 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CA 8B 45 F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_164_0 {
	meta:
		name = "TRulerBehavior.Initialize"
		size = 64
		refs = "0006 TCustomPaintedBehavior.Initialize 000d TRulerBehavior.Initialize"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 88 83 61 01 00 00 C6 83 60 01 00 00 01 C7 83 68 01 00 00 80 80 80 00 C7 83 6C 01 00 00 C0 C0 C0 00 C6 83 42 01 00 00 04 5B C3 00 03 00 00 00 }
	condition:
		$1
}

rule function_165_0 {
	meta:
		name = "TCustomGridBehavior.InvalidateGrid"
		size = 24
		altNames = "TRulerBehavior.Refresh"
	strings:
		$1 = { 83 B8 CC 00 00 00 00 74 0E 6A 00 8B 80 CC 00 00 00 50 8B 00 FF 50 10 C3 }
	condition:
		$1
}

rule function_166_0 {
	meta:
		name = "TRulerBehavior.SetIncrement"
		size = 20
		refs = "000f TRulerBehavior.Refresh"
	strings:
		$1 = { 3B 90 64 01 00 00 74 0B 89 90 64 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_167_0 {
	meta:
		name = "TRulerBehavior.SetLabelColor"
		size = 50
		refs = "0024 TFont.SetColor 002b TRulerBehavior.Refresh"
	strings:
		$1 = { 53 56 8B D8 3B 93 68 01 00 00 74 23 8B F2 89 B3 68 01 00 00 8B 83 C8 00 00 00 85 C0 74 0A 8B 40 40 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_168_0 {
	meta:
		name = "TRulerBehavior.SetRulerOptions"
		size = 39
		refs = "0020 TRulerBehavior.Refresh"
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 04 24 3A 83 61 01 00 00 74 11 0F B6 04 24 88 83 61 01 00 00 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_169_0 {
	meta:
		name = "TRulerBehavior.SetShowLabels"
		size = 20
		refs = "000f TRulerBehavior.Refresh"
	strings:
		$1 = { 3A 90 60 01 00 00 74 0B 88 90 60 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_170_0 {
	meta:
		name = "TRulerBehavior.SetTickColor"
		size = 50
		refs = "0024 TPen.SetColor 002b TRulerBehavior.Refresh"
	strings:
		$1 = { 53 56 8B D8 3B 93 6C 01 00 00 74 23 8B F2 89 B3 6C 01 00 00 8B 83 C8 00 00 00 85 C0 74 0A 8B 40 44 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_171_0 {
	meta:
		name = "TMessageBehavior.Destroy"
		size = 47
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001d TCustomPaintedBehavior.Destroy 0028 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 60 01 00 00 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_172_0 {
	meta:
		name = "TMessageBehavior.DoDraw"
		size = 628
		refs = "001b TMessageBehavior.DoDraw 0041 Format 0049 @UStrToPWChar 004f OutputDebugString 0063 TCustomPaintedBehavior.DoDraw 0097 TBrush.SetStyle 00aa TBrush.SetColor 00bd TFont.SetColor 00c7 TCustomElementBehavior.GetElement2 00e4 @CheckAutoResult 00f9 Rect 0104 TCanvas.GetHandle 0135 DrawText 01b5 OffsetRect 01ff @UStrClr 0207 @IntfClear 020d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D E0 89 5D FC 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E0 50 8B 83 64 01 00 00 89 45 D8 C6 45 DC 11 8D 55 D8 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 0F B6 45 0C 50 8B 45 08 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 0F 85 7A 01 00 00 8B 83 64 01 00 00 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 8E 63 01 00 00 8B 83 C8 00 00 00 8B 40 48 33 D2 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 BA FF FF FF 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 40 BA FF 00 00 00 E8 ?? ?? ?? ?? 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 46 0C 50 8D 45 E4 50 8D 45 D4 50 8B 45 FC 50 8B 00 FF 90 54 01 00 00 E8 ?? ?? ?? ?? 8B 4E 08 2B 4D D4 83 E9 19 33 D2 B8 19 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B BB 64 01 00 00 85 FF 74 05 83 EF 04 8B 3F 68 11 04 00 00 8D 45 E4 50 57 8B 83 64 01 00 00 E8 ?? ?? ?? ?? 50 8B 45 F4 50 E8 ?? ?? ?? ?? 8D 45 D4 50 8B 45 FC 50 8B 00 FF 90 4C 01 00 00 E8 ?? ?? ?? ?? 8B 7D D4 8D 45 D0 50 8B 45 FC 50 8B 00 FF 90 F8 00 00 00 E8 ?? ?? ?? ?? 8B 45 D0 D1 F8 79 03 83 D0 00 03 F8 03 7E 04 8B 45 F0 2B 45 E8 D1 F8 79 03 83 D0 00 2B F8 57 8D 45 CC 50 8B 45 FC 50 8B 00 FF 90 FC 00 00 00 E8 ?? ?? ?? ?? 8B 55 CC D1 FA 79 03 83 D2 00 8B 45 EC D1 F8 79 03 83 D0 00 2B D0 8D 45 E4 59 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 E8 ?? ?? ?? ?? 8B F8 8B B3 64 01 00 00 85 F6 74 05 83 EE 04 8B 36 6A 11 8D 45 E4 50 56 8B 83 64 01 00 00 E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B 45 F8 5F 5E 5B 8B E5 5D C2 08 00 00 B0 04 02 00 FF FF FF FF 23 00 00 00 54 00 4D 00 65 00 73 00 73 00 61 00 67 00 65 00 42 00 65 00 68 00 61 00 76 00 69 00 6F 00 72 00 2E 00 44 00 6F 00 44 00 72 00 61 00 77 00 20 00 4D 00 65 00 73 00 73 00 61 00 67 00 65 00 3A 00 20 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_174_0 {
	meta:
		name = "TMessageBehavior.Initialize"
		size = 108
		refs = "0007 TCustomPaintedBehavior.Initialize 000e _Dn_TFont 0013 TFont.Create 0020 TMessageBehavior.Initialize 0027 TFont.SetName 0037 TFont.SetColor 0047 TMessageBehavior.FontChanged"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 60 01 00 00 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? BA 80 80 80 00 8B 83 60 01 00 00 E8 ?? ?? ?? ?? 8B 83 60 01 00 00 89 58 0C C7 40 08 ?? ?? ?? ?? 5E 5B C3 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 54 00 61 00 68 00 6F 00 6D 00 61 00 00 00 00 00 }
	condition:
		$1
}

rule function_175_0 {
	meta:
		name = "TMessageBehavior.SetFont"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 60 01 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_176_0 {
	meta:
		name = "TMessageBehavior.SetMessage"
		size = 29
		refs = "000f @UStrAsg 0016 TCustomPaintedBehavior.InvalidatePainterInfo"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 83 64 01 00 00 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_177_0 {
	meta:
		name = "TFocusBehavior.DoCanvasCreated"
		size = 79
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 0016 TBrush.SetStyle 0026 TPen.SetStyle 0039 TPen.SetWidth 0049 TPen.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 33 D2 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 BA 02 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_178_0 {
	meta:
		name = "TEditFocusBehavior.DoDraw"
		size = 56
		refs = "0018 TCustomPaintedBehavior.DoDraw 002b TCustomCanvas.Rectangle"
		altNames = "TFocusBehavior.DoDraw"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 0F B6 45 0C 50 8B 45 08 50 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 75 0D 8B D6 8B 83 C8 00 00 00 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_179_0 {
	meta:
		name = "TEditFocusBehavior.DoCanvasCreated"
		size = 82
		refs = "0006 TCustomPaintedBehavior.DoCanvasCreated 0016 TBrush.SetStyle 0026 TPen.SetStyle 0039 TPen.SetWidth 004c TPen.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 33 D2 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 83 C8 00 00 00 8B 40 44 BA FF 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_180_0 {
	meta:
		name = "TEditFocusBehavior.Detach"
		size = 176
		refs = "0013 TEditFocusBehavior.Detach 0023 TCustomElementBehavior.GetElement2 002b @IntfClear 003d @CheckAutoResult 005b TCustomPaintedBehavior.Detach 007c LTemp 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 00 FF 90 84 01 00 00 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 45 FC 50 8B 00 FF 90 94 02 00 00 E8 ?? ?? ?? ?? 8B 75 F4 53 E8 ?? ?? ?? ?? 8B F8 8D 45 F4 50 8B 45 FC 50 8B 00 FF 90 94 02 00 00 E8 ?? ?? ?? ?? 8B 45 F4 03 C6 A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C7 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_181_0 {
	meta:
		name = "TEditFocusBehavior.GetPainterInfo"
		size = 58
		refs = "000d TCustomPaintedBehavior.GetPainterInfo 0013 FExpandFocusRectHeight 0025 FExpandFocusRectWidth"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 8B 45 08 53 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 53 1C 8B 15 ?? ?? ?? ?? 89 53 24 8B 15 ?? ?? ?? ?? 89 53 18 8B 15 ?? ?? ?? ?? 89 53 20 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_197_0 {
	meta:
		name = "TAdapterStub.FindObject"
		size = 120
		refs = "000f TAdapterStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "TAdapterComponentsStub.FindObject"
		size = 120
		refs = "000f TAdapterComponentsStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "TAdapterFieldValuesStub.FindObject"
		size = 120
		refs = "000f TAdapterFieldValuesStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_262_0 {
	meta:
		name = "TAdapterValuesListStub.FindObject"
		size = 120
		refs = "000f TAdapterValuesListStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_269_0 {
	meta:
		name = "TBaseAdapterStub.FindObject"
		size = 120
		refs = "000f TBaseAdapterStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_97404_0 {
	meta:
		name = "TModuleObjectsStub.FindObject"
		size = 120
		refs = "000f TModuleObjectsStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_97354_0 {
	meta:
		name = "TWebModuleStub.FindObject"
		size = 120
		refs = "000f TWebModuleStub.FindObject 001d @IntfClear 002c Supports 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 B1 42 21 13 20 03 D4 11 AB E8 E0 35 EE C2 EA 5A }
	condition:
		$1
}

rule function_198_0 {
	meta:
		name = "TAdapterStub.Get_CanModify"
		size = 116
		refs = "000c TAdapterStub.Get_CanModify 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 C0 32 92 17 77 CC D4 11 A5 2B 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_199_0 {
	meta:
		name = "TAdapterStub.Get_CanView"
		size = 116
		refs = "000c TAdapterStub.Get_CanView 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 C0 32 92 17 77 CC D4 11 A5 2B 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "TAdapterStub.Get_Errors"
		size = 132
		refs = "000f TAdapterStub.Get_Errors 001d @IntfClear 002c Supports 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 FC 8B 10 FF 52 0C 8B D0 8B CE 8B C3 8B 18 FF 53 14 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 9F D8 A6 27 E1 58 D4 11 A4 93 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "TAdapterStub.Get_HiddenFields"
		size = 156
		refs = "0016 TAdapterStub.Get_HiddenFields 0024 @IntfClear 0033 Supports 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 26 8B 45 FC 8B 10 FF 52 0C 8B F0 85 F6 74 0E 8B 4D F8 8B D6 8B C3 8B 18 FF 53 18 EB 12 8B 45 F8 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 4D C3 E9 90 54 D0 D4 11 A5 30 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_202_0 {
	meta:
		name = "TAdapterStub.Get_HiddenRecordFields"
		size = 156
		refs = "0016 TAdapterStub.Get_HiddenRecordFields 0024 @IntfClear 0033 Supports 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 26 8B 45 FC 8B 10 FF 52 10 8B F0 85 F6 74 0E 8B 4D F8 8B D6 8B C3 8B 18 FF 53 18 EB 12 8B 45 F8 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 4D C3 E9 90 54 D0 D4 11 A5 30 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "TAdapterStub.Get_Mode"
		size = 124
		refs = "000f TAdapterStub.Get_Mode 001d @IntfClear 002c Supports 0043 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 7C 6A 6E 9E 4F 57 D4 11 A4 91 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_204_0 {
	meta:
		name = "TAdapterStub.Set_Mode"
		size = 112
		refs = "000f TAdapterStub.Set_Mode 001d @IntfClear 002c Supports 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0A 8B D6 8B 45 FC 8B 08 FF 51 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 7C 6A 6E 9E 4F 57 D4 11 A4 91 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_206_0 {
	meta:
		name = "TAdapterErrorsStub.Create"
		size = 56
		refs = "000a @ClassCreate 001a TObject.Create 0025 @AfterConstruction"
		altNames = "TAdapterHiddenFieldsStub.Create TAdapterRecordsStub.Create TScriptComponent.Create TSockWebRequestAccess.Create TWebPageInfoWrapper.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 0C 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_207_0 {
	meta:
		name = "TAdapterActionArrayStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterActionArrayStub.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "TAdapterSubComponentStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterSubComponentStub.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98459_0 {
	meta:
		name = "TCurrentWebPageInfo.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TCurrentWebPageInfo.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_97367_0 {
	meta:
		name = "THTMLItemsStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 THTMLItemsStub.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114427_0 {
	meta:
		name = "TMSDOMNode.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMSDOMNode.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_50585_0 {
	meta:
		name = "TSendDataBlock.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TSendDataBlock.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_97363_0 {
	meta:
		name = "TWebProducerStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TWebProducerStub.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_97358_0 {
	meta:
		name = "TWebResponseStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TWebResponseStub.Create 0036 @IntfCopy 003f TObject.Create 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98586_0 {
	meta:
		name = "TWebSessionImpl.Create"
		size = 124
		refs = "000e @ClassCreate 001d @UStrAddRef 0025 TWebSessionImpl.Create 0036 @UStrAsg 003f TObject.Create 0054 @UStrClr 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "TAdapterErrorsStub.DefineLabel"
		size = 220
		refs = "001e TAdapterErrorsStub.DefineLabel 002c @IntfClear 003b Supports 006f @VarToUStr 0091 @VarClr 0099 @UStrClr 00af @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 3D 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 23 8D 55 E4 8B 45 F8 8B 08 FF 51 10 8D 55 E4 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B CF 8B 45 FC 8B 18 FF 53 18 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 A0 D8 A6 27 E1 58 D4 11 A4 93 00 C0 4F 6B B8 53 79 CA 3A 6C 14 63 D4 11 A4 A2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_210_0 {
	meta:
		name = "TAdapterErrorsStub.FieldErrors"
		size = 284
		refs = "0020 TAdapterErrorsStub.FieldErrors 002e @IntfClear 003d Supports 0071 @VarToUStr 00c1 @VarClr 00c9 @UStrClr 00ef @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 6B 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 51 8D 55 E0 8B 45 F8 8B 08 FF 51 10 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 FC 8B 08 FF 51 1C 84 C0 74 2C 8D 55 CC 8B 45 F8 8B 08 FF 51 10 8D 55 CC 8D 45 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 FC 8B 08 FF 51 20 8B D0 8B 4D F4 8B C3 8B 18 FF 13 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 5E 5B 8B E5 5D C3 00 A0 D8 A6 27 E1 58 D4 11 A4 93 00 C0 4F 6B B8 53 79 CA 3A 6C 14 63 D4 11 A4 A2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_212_0 {
	meta:
		name = "TAdapterHiddenFieldsStub.WriteFields"
		size = 532
		refs = "001b TAdapterHiddenFieldsStub.WriteFields 0029 @IntfClear 0037 Supports 0052 @IntfCopy 00f9 Format 0104 @UStrLAsg 012d @UStrArrayClr 0135 @UStrClr 016b @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 07 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 0D 8D 55 E8 8B 45 F0 8B 08 FF 51 0C EB 0A 8D 45 E8 8B D6 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 84 C0 0F 84 A2 00 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 0F 84 83 00 00 00 8B 45 FC 8B 10 FF 52 0C 8B D8 4B 85 DB 7C 69 43 33 F6 8D 4D F8 8B D6 8B 45 FC 8B 38 FF 57 10 8D 45 E4 50 8B 45 EC 89 45 CC C6 45 D0 11 8D 55 C8 8B 45 F8 8B 08 FF 51 0C 8B 45 C8 89 45 D4 C6 45 D8 11 8D 55 C4 8B 45 F8 8B 08 FF 51 10 8B 45 C4 89 45 DC C6 45 E0 11 8D 55 CC B9 02 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 8D 45 EC E8 ?? ?? ?? ?? 46 4B 75 9A 8B 55 EC 8B 45 F4 8B 08 FF 51 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B3 5F 5E 5B 8B E5 5D C3 9B 61 21 88 26 6B 32 42 A2 AA EA E0 12 AF 31 AB 05 D0 61 4A D3 46 14 42 99 46 5B C1 DD 51 1F 02 4C C3 E9 90 54 D0 D4 11 A5 30 00 C0 4F 6B B8 53 B0 04 02 00 FF FF FF FF 2E 00 00 00 25 00 73 00 3C 00 69 00 6E 00 70 00 75 00 74 00 20 00 74 00 79 00 70 00 65 00 3D 00 22 00 68 00 69 00 64 00 64 00 65 00 6E 00 22 00 20 00 6E 00 61 00 6D 00 65 00 3D 00 22 00 25 00 73 00 22 00 20 00 76 00 61 00 6C 00 75 00 65 00 3D 00 22 00 25 00 73 00 22 00 3E 00 0D 00 0A 00 00 00 00 00 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "TAdapterSubComponentStub.Create"
		size = 74
		refs = "000b @ClassCreate 0022 @IntfCopy 002b TObject.Create 0036 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 0C 8B D6 85 D2 74 03 83 EA D0 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_215_0 {
	meta:
		name = "TAdapterSubComponentStub.GetComponent"
		size = 116
		refs = "000c TAdapterSubComponentStub.GetComponent 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "TActionLink.GetComponent"
		size = 116
		refs = "000c TActionLink.GetComponent 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "TAdapterSubComponentStub.Get_Name"
		size = 168
		refs = "0016 TAdapterSubComponentStub.Get_Name 0024 @IntfClear 0033 Supports 004c @VarFromUStr 0056 @VarClear 0060 @VarCopy 0075 @UStrClr 007d @VarClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 17 8D 55 E4 8B 45 FC 8B 08 FF 51 0C 8B 55 E4 8B C6 E8 ?? ?? ?? ?? EB 12 8D 45 E8 E8 ?? ?? ?? ?? 8B C6 8D 55 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_217_0 {
	meta:
		name = "TAdapterRecordStub.Create"
		size = 78
		refs = "000e @ClassCreate 002c TObject.Create 0037 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 89 77 0C 8B CE B2 01 8B 45 08 FF 10 89 47 10 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "TAdapterFieldStub.Get_DisplayText"
		size = 128
		refs = "000f TAdapterFieldStub.Get_DisplayText 001d @IntfClear 002c Supports 0047 TAdapterFieldStub.Get_EditText 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 83 7D FC 00 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 62 88 13 18 C0 52 D4 11 A4 8D 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_219_0 {
	meta:
		name = "TAdapterFieldStub.Get_DisplayWidth"
		size = 116
		refs = "000c TAdapterFieldStub.Get_DisplayWidth 001a @IntfClear 0029 Supports 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 03 83 CB FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 B6 86 3C A2 2A 67 D4 11 A4 A7 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_220_0 {
	meta:
		name = "TAdapterFieldStub.Get_MaxLength"
		size = 116
		refs = "000c TAdapterFieldStub.Get_MaxLength 001a @IntfClear 0029 Supports 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 03 83 CB FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 39 76 2D 77 09 82 44 47 91 46 2B 6D 3A 5F 22 0F }
	condition:
		$1
}

rule function_221_0 {
	meta:
		name = "TAdapterFieldStub.Get_DisplayLabel"
		size = 124
		refs = "000f TAdapterFieldStub.Get_DisplayLabel 001d @IntfClear 002c Supports 0043 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 B7 86 3C A2 2A 67 D4 11 A4 A7 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_245_0 {
	meta:
		name = "TAdapterActionStub.Get_DisplayLabel"
		size = 124
		refs = "000f TAdapterActionStub.Get_DisplayLabel 001d @IntfClear 002c Supports 0043 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 B7 86 3C A2 2A 67 D4 11 A4 A7 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_222_0 {
	meta:
		name = "TAdapterFieldStub.Get_EditText"
		size = 86
		refs = "0013 TAdapterFieldStub.Get_EditText 0023 TAdapterFieldStub.Get_Value 002f TAdapterFieldStub.AsEditText 0044 @VarClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8D 55 F0 8B CE 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_98771_0 {
	meta:
		name = "TAdapterFieldObj.GetEditText"
		size = 86
		refs = "0013 TAdapterFieldObj.GetEditText 0023 TAdapterFieldObj.GetValue 002f TAdapterFieldObj.AsEditText 0044 @VarClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8D 55 F0 8B CE 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_223_0 {
	meta:
		name = "TAdapterFieldStub.Get_InputName"
		size = 188
		refs = "0011 TAdapterFieldStub.Get_InputName 001f @IntfClear 002e Supports 006c @UStrClr 008f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 F8 8B 08 FF 51 0C EB 2E 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 C0 44 16 CD E8 41 06 4C 9A B8 CD 6B 05 36 7E 27 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_224_0 {
	meta:
		name = "TAdapterFieldObj.AsEditText"
		size = 50
		refs = "0009 VarIsEmpty 0014 VarIsNull 0021 @VarToUStr 002b @UStrClr"
		altNames = "TAdapterFieldStub.AsEditText"
	strings:
		$1 = { 53 56 8B F1 8B DA 8B C3 E8 ?? ?? ?? ?? 84 C0 75 17 8B C3 E8 ?? ?? ?? ?? 84 C0 75 0C 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_225_0 {
	meta:
		name = "TAdapterFieldStub.Get_ValuesList"
		size = 224
		refs = "0013 TAdapterFieldStub.Get_ValuesList 0021 @IntfClear 0030 Supports 00b2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 4C 8D 55 F8 8B 45 FC 8B 08 FF 51 0C 83 7D F8 00 74 3B 8D 45 F4 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 27 8B 45 F4 8B 10 FF 52 0C 85 C0 74 1B 8B 45 F4 8B 10 FF 52 0C 8B D0 8B CE 8B C3 8B 18 FF 13 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 4D E9 D7 59 A9 9B D4 11 A4 F2 00 C0 4F 6B B8 53 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED }
	condition:
		$1
}

rule function_226_0 {
	meta:
		name = "TAdapterFieldStub.Get_Image"
		size = 168
		refs = "0011 TAdapterFieldStub.Get_Image 001f @IntfClear 002e Supports 004b @IntfCopy 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 2D 8B 45 FC 8B 10 FF 52 0C 8B D0 85 D2 74 03 83 EA CC 8D 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 74 0E 8B CE 8B 55 F8 8B C3 8B 18 FF 53 04 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 00 00 30 D2 F5 E7 F9 7A C8 46 99 76 B9 54 BD 11 52 D8 }
	condition:
		$1
}

rule function_227_0 {
	meta:
		name = "TAdapterFieldStub.Get_DisplayStyle"
		size = 124
		refs = "000f TAdapterFieldStub.Get_DisplayStyle 001d @IntfClear 002c Supports 0045 @UStrClr 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE 33 D2 8B 45 FC 8B 18 FF 53 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 D1 57 15 1C 79 CA EE 4B 86 E2 25 3B EC 89 25 E2 }
	condition:
		$1
}

rule function_246_0 {
	meta:
		name = "TAdapterActionStub.Get_DisplayStyle"
		size = 124
		refs = "000f TAdapterActionStub.Get_DisplayStyle 001d @IntfClear 002c Supports 0045 @UStrClr 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE 33 D2 8B 45 FC 8B 18 FF 53 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 D1 57 15 1C 79 CA EE 4B 86 E2 25 3B EC 89 25 E2 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "TAdapterFieldStub.Get_InputStyle"
		size = 124
		refs = "000f TAdapterFieldStub.Get_InputStyle 001d @IntfClear 002c Supports 0045 @UStrClr 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE 33 D2 8B 45 FC 8B 18 FF 53 10 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 D1 57 15 1C 79 CA EE 4B 86 E2 25 3B EC 89 25 E2 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "TAdapterFieldStub.Get_CanModify"
		size = 116
		refs = "000c TAdapterFieldStub.Get_CanModify 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 64 D5 C3 98 E4 3C 2C 41 A7 FE DA 05 A1 A3 79 53 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "TAdapterFieldStub.Get_CanView"
		size = 116
		refs = "000c TAdapterFieldStub.Get_CanView 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 64 D5 C3 98 E4 3C 2C 41 A7 FE DA 05 A1 A3 79 53 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "TAdapterFieldStub.Get_Values"
		size = 148
		refs = "0016 TAdapterFieldStub.Get_Values 0024 @IntfClear 0033 Supports 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 1C 8B 45 FC 8B 10 FF 52 0C 8B F0 85 F6 74 0E 8B 4D F8 8B D6 8B C3 8B 18 FF 53 08 EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 00 00 12 FE BD 87 10 CA D4 11 A5 28 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "TAdapterFieldStub.Get_Value"
		size = 148
		refs = "0015 TAdapterFieldStub.Get_Value 0023 @IntfClear 0032 Supports 004a @VarClear 0054 @VarCopy 0069 @VarClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 12 8D 45 E8 E8 ?? ?? ?? ?? 8B C6 8D 55 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 7F 6A 6E 9E 4F 57 D4 11 A4 91 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "TAdapterFieldStub.IsEqual"
		size = 264
		refs = "0029 @VarAddRef 0031 TAdapterFieldStub.IsEqual 003f @IntfClear 004e Supports 006b TAdapterFieldStub.Get_Value 0081 VarIsEmpty 009a @VarCmpEQ 00b1 @HandleAnyException 00b8 @DoneExcept 00ce Variant 00d8 @FinalizeArray 00e6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 C9 89 4D FC 89 4D D8 89 4D DC 89 4D E0 89 4D E4 8B F2 8D 7D E8 A5 A5 A5 A5 8B D8 8D 45 E8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0F 8D 55 E8 8B 45 FC 8B 08 FF 51 0C 8B D8 EB 57 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 E8 ?? ?? ?? ?? 8B D8 8D 45 D8 E8 ?? ?? ?? ?? 3A D8 75 0D 8D 45 E8 8D 55 D8 E8 ?? ?? ?? ?? 74 04 33 DB EB 02 B3 01 33 C0 5A 59 59 64 89 10 EB 0C E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5F 5E 5B 8B E5 5D C3 00 00 00 FB 42 50 49 CE 97 A1 4C 92 1F 9A 09 DD 3B 65 F2 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "TAdapterFieldStub.Get_ViewMode"
		size = 124
		refs = "000f TAdapterFieldStub.Get_ViewMode 001d @IntfClear 002c Supports 0045 @UStrClr 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE 33 D2 8B 45 FC 8B 18 FF 53 14 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 D1 57 15 1C 79 CA EE 4B 86 E2 25 3B EC 89 25 E2 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "TAdapterFieldStub.Get_Required"
		size = 116
		refs = "000c TAdapterFieldStub.Get_Required 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 BF 32 92 17 77 CC D4 11 A5 2B 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "TAdapterFieldStub.Get_Visible"
		size = 116
		refs = "000c TAdapterFieldStub.Get_Visible 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 BF 32 92 17 77 CC D4 11 A5 2B 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "FindApplicationModuleOfObject"
		size = 204
		refs = "0014 @IntfAddRef 001c FindApplicationModuleOfObject 002a @IntfClear 0039 Supports 005c @CallDynaInst 0075 WebContext 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 D2 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 F8 8B 10 FF 52 0C 8B D8 EB 02 33 DB 85 DB 74 21 EB 0D 8B C3 66 BE F2 FF E8 ?? ?? ?? ?? 8B D8 8B C3 66 BE F2 FF E8 ?? ?? ?? ?? 85 C0 75 E4 8B 5B 04 E8 ?? ?? ?? ?? 85 C0 74 10 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 3C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5E 5B 59 59 5D C3 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "TTempAdapterDispatcher.Create"
		size = 70
		refs = "000a @ClassCreate 0017 _Dn_TAdapterDispatcher 001c TComponent.Create 0028 TObject.Create 0033 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "TBPageList.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TObject.Destroy 0025 @ClassDestroy"
		altNames = "TBSignedIdentifiers.Destroy TCompiledBinding.Destroy TCustomScope.Destroy TDictionaryScope.Destroy TObjectMemberGroupScope.Destroy TScopeSymbols.Destroy TSimpleRWSync.Destroy TTempAdapterDispatcher.Destroy TValueRefConverter.Destroy TWinSocketStream.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6391_0 {
	meta:
		name = "TClassRegistryPackageItem.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f UnloadPackage 001a TObject.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_77658_0 {
	meta:
		name = "TColumnTitle.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TPersistent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24255_0 {
	meta:
		name = "TDSService.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TDSRequestFilterManager.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81445_0 {
	meta:
		name = "TGIFCommentExtension.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TGIFExtension.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81435_0 {
	meta:
		name = "TGIFTextExtension.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TGIFExtension.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80412_0 {
	meta:
		name = "TPicture.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TPersistent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "FindAdapterDispatcher"
		size = 188
		refs = "0016 @IntfAddRef 001e FindAdapterDispatcher 002c FindApplicationModuleOfObject 0036 @IntfClear 004b Supports 0065 _DV_TTempAdapterDispatcher 006a TTempAdapterDispatcher.Create 007a @IntfCopy 009d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C6 85 C0 74 03 83 E8 CC E8 ?? ?? ?? ?? 84 C0 74 0A 8B D3 8B 45 F8 8B 08 FF 51 14 83 3B 00 75 1C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 00 00 0D 2F CD 19 8F E6 6F 4A 92 AA 4C 76 59 E8 37 08 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "TAdapterActionStub.Get_Array_"
		size = 136
		refs = "000f TAdapterActionStub.Get_Array_ 001d @IntfClear 002c Supports 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 19 8B 45 FC 8B 10 FF 52 0C 84 C0 74 0D 8B CE 8B 53 0C 8B C3 8B 18 FF 13 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 90 5E A0 AF AA DD 7F 4B B7 A6 D3 F9 09 3D 94 27 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "TAdapterActionStub.Get_AsFieldValue"
		size = 144
		refs = "000f TAdapterActionStub.Get_AsFieldValue 0020 FindAdapterDispatcher 0047 @UStrAsg 005c @IntfClear 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 0C E8 ?? ?? ?? ?? 83 7D FC 00 74 15 56 0F B6 0D ?? ?? ?? ?? 8B 53 0C 8B 45 FC 8B 18 FF 53 14 EB 0C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 00 00 00 00 B0 04 02 00 FF FF FF FF 07 00 00 00 55 00 6E 00 6B 00 6E 00 6F 00 77 00 6E 00 00 00 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "TAdapterActionStub.Get_AsHREF"
		size = 144
		refs = "000f TAdapterActionStub.Get_AsHREF 0020 FindAdapterDispatcher 0047 @UStrAsg 005c @IntfClear 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 0C E8 ?? ?? ?? ?? 83 7D FC 00 74 15 56 0F B6 0D ?? ?? ?? ?? 8B 53 0C 8B 45 FC 8B 18 FF 53 10 EB 0C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 00 00 00 00 B0 04 02 00 FF FF FF FF 07 00 00 00 55 00 6E 00 6B 00 6E 00 6F 00 77 00 6E 00 00 00 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "TAdapterActionStub.Get_CanExecute"
		size = 116
		refs = "000c TAdapterActionStub.Get_CanExecute 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 44 5C 28 55 BE A3 21 48 99 94 00 51 64 76 99 A7 }
	condition:
		$1
}

rule function_247_0 {
	meta:
		name = "TAdapterActionStub.Get_Enabled"
		size = 116
		refs = "000c TAdapterActionStub.Get_Enabled 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 D7 97 8F 64 99 B2 4A 44 89 CA E6 0B D1 FB 9E A3 }
	condition:
		$1
}

rule function_248_0 {
	meta:
		name = "TAdapterActionStub.Get_Visible"
		size = 116
		refs = "000c TAdapterActionStub.Get_Visible 001a @IntfClear 0029 Supports 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 C3 48 6F B8 EB BE A7 43 9B EF 1A BE 13 11 E4 19 }
	condition:
		$1
}

rule function_249_0 {
	meta:
		name = "TAdapterActionStub.LinkToPage"
		size = 144
		refs = "0016 TAdapterActionStub.LinkToPage 0029 _DV_TActionLink 0030 TActionLink.Create 0048 @IntfCast 006a @IntfClear 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 52 8B 45 FC 50 8B 4B 0C A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B F0 8D 45 F8 8B D6 85 D2 74 03 83 EA F8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 4D 08 8B C3 8B 18 FF 53 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C2 04 00 00 00 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "TActionLink.GetAdapterItemRequestParams"
		size = 156
		refs = "0018 @IntfAddRef 0020 TActionLink.GetAdapterItemRequestParams 003b @IntfClear 004a Supports 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 1C 8B 10 FF 52 44 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0D 8B D6 8B 4D FC 8B 45 F8 8B 18 FF 53 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 00 F5 78 D9 14 E9 D1 D4 11 A5 32 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_251_0 {
	meta:
		name = "TActionLink.Create"
		size = 148
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TActionLink.Create 0034 TObject.Create 003f @UStrAsg 004a @IntfCopy 006a @IntfClear 0070 @HandleFinally 007d @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 0C E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 8D 46 14 8B 55 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_253_0 {
	meta:
		name = "TActionLink.GetSuccessPage"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TAdapterDispatchParams.GetRequestIdentifier TAdapterItemRequestParams.GetFailurePage TDBXBaseMetaDataReader.GetVersion TDBXHTTPLayer.Info TDSMethod.GetDSMethodName TDefaultDBScreenApplication.GetTitle TIncludeFile.GetFileName TNameContentScriptObject.GetName TQualifiedName.GetNamespace TRecipientItem.GetDisplayName TScriptError.GetSourceLine TStreamLoader.GetProxy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3274_0 {
	meta:
		name = "TBindObserver.GetOnObserverToggle"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_51870_0 {
	meta:
		name = "TCustomWrapper.GetGetterCallback"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47952_0 {
	meta:
		name = "TWebRequestFile.GetContentType"
		size = 19
		refs = "000c @LStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_111780_0 {
	meta:
		name = "TXmlCustomSubsetTokenizer.GetClue"
		size = 19
		refs = "000c @WStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "TAdapterErrorStub.Create"
		size = 67
		refs = "000b @ClassCreate 001b @IntfCopy 0024 TObject.Create 002f @AfterConstruction"
		altNames = "TAdapterHiddenFieldStub.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 0C 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_97386_0 {
	meta:
		name = "TSampleWebPageInfo.Create"
		size = 67
		refs = "000b @ClassCreate 001b @UStrAsg 0024 TObject.Create 002f @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 0C 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "TAdapterErrorStub.Get_Field"
		size = 128
		refs = "000f TAdapterErrorStub.Get_Field 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 52 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "TAdapterErrorStub.Get_ID"
		size = 9
		altNames = "TBindEditLinkObserver.EndUpdate"
	strings:
		$1 = { 8B 40 0C 8B 10 FF 52 10 C3 }
	condition:
		$1
}

rule function_258_0 {
	meta:
		name = "TAdapterErrorStub.Get_Message"
		size = 19
		altNames = "TAdapterHiddenFieldStub.Get_Name TWebPageInfoWrapper.GetPageDescription TWebPageStub.Get_Name"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 08 FF 51 0C 5E 5B C3 }
	condition:
		$1
}

rule function_261_0 {
	meta:
		name = "TAdapterHiddenFieldStub.Get_Value"
		size = 19
		altNames = "TWebPageInfoWrapper.GetPageTitle TWebPageStub.Get_HREF"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 08 FF 51 10 5E 5B C3 }
	condition:
		$1
}

rule function_263_0 {
	meta:
		name = "TAdapterValuesListStub.Get_Image"
		size = 176
		refs = "0011 TAdapterValuesListStub.Get_Image 001f @IntfClear 002e Supports 004b @IntfCopy 0092 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 36 8B 45 FC 8B 10 FF 52 18 8B D0 85 D2 74 03 83 EA CC 8D 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 74 0E 8B CE 8B 55 F8 8B C3 8B 18 FF 53 14 EB 10 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 00 51 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_264_0 {
	meta:
		name = "TAdapterFieldValuesStub.Get_Records"
		size = 21
		altNames = "TAdapterValuesListStub.Get_Records"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 8B 53 0C 8B C3 8B 18 FF 53 10 5E 5B C3 }
	condition:
		$1
}

rule function_265_0 {
	meta:
		name = "TAdapterValuesListStub.Get_Value"
		size = 148
		refs = "0015 TAdapterValuesListStub.Get_Value 0023 @IntfClear 0032 Supports 004a @VarClear 0054 @VarCopy 0069 @VarClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 12 8D 45 E8 E8 ?? ?? ?? ?? 8B C6 8D 55 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 51 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_266_0 {
	meta:
		name = "TAdapterValuesListStub.Get_ValueName"
		size = 124
		refs = "000f TAdapterValuesListStub.Get_ValueName 001d @IntfClear 002c Supports 0043 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 10 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 51 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_267_0 {
	meta:
		name = "TAdapterValuesListStub.ImageOfValue"
		size = 204
		refs = "0022 @VarAddRef 002a TAdapterValuesListStub.ImageOfValue 0038 @IntfClear 0047 Supports 0067 @IntfCopy 0097 @VarClr 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D FC 89 5D F8 8B F2 8D 7D E8 A5 A5 A5 A5 8B F1 8B D8 8D 45 E8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 30 8D 55 E8 8B 45 FC 8B 08 FF 51 1C 8B D0 85 D2 74 03 83 EA CC 8D 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 74 0E 8B CE 8B 55 F8 8B C3 8B 18 FF 53 14 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 00 00 51 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_268_0 {
	meta:
		name = "TAdapterValuesListStub.NameOfValue"
		size = 160
		refs = "001f @VarAddRef 0027 TAdapterValuesListStub.NameOfValue 0035 @IntfClear 0044 Supports 005e @UStrClr 0073 @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D FC 8B F2 8D 7D E8 A5 A5 A5 A5 8B F1 8B D8 8D 45 E8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0F 8B CE 8D 55 E8 8B 45 FC 8B 18 FF 53 14 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 00 51 64 C1 CA AD 9B D4 11 A4 F2 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_270_0 {
	meta:
		name = "TBaseAdapterStub.Get_Actions"
		size = 164
		refs = "0012 TBaseAdapterStub.Get_Actions 0026 @IntfClear 0035 Supports 0058 @IntfCopy 0085 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 1C 00 75 3A 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 1F 8B 45 FC 8B 10 FF 52 0C 8B D0 8D 4D F8 8B C3 8B 38 FF 57 0C 8B 55 F8 8D 43 1C E8 ?? ?? ?? ?? 8B C6 8B 53 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 CE 1E 2D 0C BA 7B FE 43 A4 66 2D 8B C7 0C C8 5D }
	condition:
		$1
}

rule function_271_0 {
	meta:
		name = "TBaseAdapterStub.Get_ClassName_"
		size = 21
		refs = "000e TObject.ClassName"
		altNames = "TWebModuleStub.Get_ClassName_"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "TBaseAdapterStub.Get_Fields"
		size = 164
		refs = "0012 TBaseAdapterStub.Get_Fields 0026 @IntfClear 0035 Supports 0058 @IntfCopy 0085 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 18 00 75 3A 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 1F 8B 45 FC 8B 10 FF 52 0C 8B D0 8D 4D F8 8B C3 8B 38 FF 57 0C 8B 55 F8 8D 43 18 E8 ?? ?? ?? ?? 8B C6 8B 53 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 2F 5B B4 30 B7 B5 AE 4B A6 FC EC 47 E5 B0 C9 41 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "TBaseAdapterStub.Get_Name_"
		size = 124
		refs = "000f TBaseAdapterStub.Get_Name_ 001d @IntfClear 002c Supports 0043 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_274_0 {
	meta:
		name = "TBaseRecordsAdapterStub.Get_Records"
		size = 38
		refs = "001e @IntfClear"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 7B 0C 85 FF 74 0D 8B CE 8B D7 8B C3 8B 18 FF 53 10 EB 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "TAdapterImageStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterImageStub.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_26342_0 {
	meta:
		name = "TAdapterRecordKeysWrapper.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterRecordKeysWrapper.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_25485_0 {
	meta:
		name = "TDSTCPChannel.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TDSTCPChannel.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114423_0 {
	meta:
		name = "TMSDOMImplementation.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMSDOMImplementation.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114462_0 {
	meta:
		name = "TMSDOMNamedNodeMap.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMSDOMNamedNodeMap.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114459_0 {
	meta:
		name = "TMSDOMNodeList.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMSDOMNodeList.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "TAdapterImageStub.Get_AsHREF"
		size = 296
		refs = "0013 TAdapterImageStub.Get_AsHREF 0021 @IntfClear 0030 Supports 004d @UStrAsg 0081 FindAdapterDispatcher 00c5 @UStrClr 00db @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 1B 8D 55 F4 8B 45 F8 8B 08 FF 51 0C 84 C0 74 0C 8B C6 8B 55 F4 E8 ?? ?? ?? ?? EB 59 8D 45 F0 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 17 8B 45 F0 8B 10 FF 52 0C 85 C0 74 03 83 E8 CC 8D 55 FC E8 ?? ?? ?? ?? 83 7D FC 00 74 15 56 0F B6 0D ?? ?? ?? ?? 8B 53 0C 8B 45 FC 8B 18 FF 53 10 EB 0C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5E 5B 8B E5 5D C3 00 A2 73 E8 10 DD A6 E9 4A 8A B5 45 97 14 2E 46 31 58 18 8B E2 86 EC 59 45 8F CD 6B 4F 82 41 51 ED 00 00 00 00 B0 04 02 00 FF FF FF FF 07 00 00 00 55 00 6E 00 6B 00 6E 00 6F 00 77 00 6E 00 00 00 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "TWebApplicationStub.Create"
		size = 198
		refs = "0013 @ClassCreate 0022 @IntfAddRef 002a TWebApplicationStub.Create 003b @IntfCopy 0045 TWebApplicationStub.ApplicationInfo 0068 TWebComponentsStub.Create 008b IWebApplicationInfo 0095 @FinalizeArray 009d @IntfClear 00a3 @HandleFinally 00b0 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 30 8B 55 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 83 7D F8 00 74 1F 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 8B 10 FF 52 10 8B C8 33 D2 8B C6 E8 ?? ?? ?? ?? EB 0B 33 C9 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "TWebApplicationStub.ApplicationInfo"
		size = 192
		refs = "0012 TWebApplicationStub.ApplicationInfo 0023 WebContext 0045 @IntfClear 005a Supports 0074 @IntfCopy 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 34 00 75 56 E8 ?? ?? ?? ?? 85 C0 74 4D 8B 43 30 8B 10 FF 52 0C 50 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 3C 8B F8 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C7 85 C0 74 03 83 E8 CC E8 ?? ?? ?? ?? 84 C0 74 16 8D 55 F8 8B 45 FC 8B 08 FF 51 18 8B 55 F8 8D 43 34 E8 ?? ?? ?? ?? 8B C6 8B 53 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 0D 2F CD 19 8F E6 6F 4A 92 AA 4C 76 59 E8 37 08 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "TWebApplicationStub.Get_Title"
		size = 118
		refs = "0011 TWebApplicationStub.Get_Title 0021 TWebApplicationStub.ApplicationInfo 0044 @UStrClr 005a IWebApplicationInfo 0064 @FinalizeArray 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B D6 8B 08 FF 51 0C EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "TWebApplicationStub.Get_Designing"
		size = 47
		refs = "000d _Dn_TComponent 0012 @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 30 8B 10 FF 52 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B 43 30 8B 10 FF 52 0C F6 40 1C 10 0F 95 C0 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "TWebApplicationStub.Get_ModulePath"
		size = 79
		refs = "000f TWebApplicationStub.Get_ModulePath 001f TWebApplicationStub.Get_ModuleFileName 0029 ExtractFilePath 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_14236_0 {
	meta:
		name = "IntegerToBcd"
		size = 79
		refs = "000f IntegerToBcd 001f IntToStr 0029 StrToBcd 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_14201_0 {
	meta:
		name = "TBcd.&op_Implicit"
		size = 79
		refs = "000f TBcd.&op_Implicit 001f IntToStr 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_31740_0 {
	meta:
		name = "TIBXSQLVAR.GetAsTrimString"
		size = 79
		refs = "000f TIBXSQLVAR.GetAsTrimString 001f TIBXSQLVAR.GetAsString 0029 TrimRight 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_32142_0 {
	meta:
		name = "TIdAttachment.GetContentDisposition"
		size = 79
		refs = "000f TIdAttachment.GetContentDisposition 001f TIdMessagePart.GetContentDisposition 0029 ExtractHeaderItem 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_32143_0 {
	meta:
		name = "TIdAttachment.GetContentType"
		size = 79
		refs = "000f TIdAttachment.GetContentType 001f TIdMessagePart.GetContentType 0029 ExtractHeaderItem 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_38193_0 {
	meta:
		name = "TIdText.GetContentDisposition"
		size = 79
		refs = "000f TIdText.GetContentDisposition 001f TIdMessagePart.GetContentDisposition 0029 ExtractHeaderItem 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_38194_0 {
	meta:
		name = "TIdText.GetContentType"
		size = 79
		refs = "000f TIdText.GetContentType 001f TIdMessagePart.GetContentType 0029 ExtractHeaderItem 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "TWebApplicationStub.Get_ModuleFileName"
		size = 39
		refs = "0005 GetModuleFileNameProc 0020 @UStrClr"
	strings:
		$1 = { 53 56 8B DA A1 ?? ?? ?? ?? 83 38 00 74 0F 8B 35 ?? ?? ?? ?? 8B 36 8B C3 FF D6 5E 5B C3 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "TWebApplicationStub.QualifyFileName"
		size = 79
		refs = "000f TWebApplicationStub.QualifyFileName 001f @UStrFromPWChar 0029 QualifyFileName 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "TWebEndUserStub.Create"
		size = 198
		refs = "0013 @ClassCreate 0022 @IntfAddRef 002a TWebEndUserStub.Create 003b @IntfCopy 0045 TWebEndUserStub.EndUser 0068 TWebComponentsStub.Create 008b IWebEndUser 0095 @FinalizeArray 009d @IntfClear 00a3 @HandleFinally 00b0 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 30 8B 55 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 83 7D F8 00 74 1F 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 8B 10 FF 52 28 8B C8 33 D2 8B C6 E8 ?? ?? ?? ?? EB 0B 33 C9 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "TWebEndUserStub.EndUser"
		size = 192
		refs = "0012 TWebEndUserStub.EndUser 0023 WebContext 0045 @IntfClear 005a Supports 0074 @IntfCopy 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 34 00 75 56 E8 ?? ?? ?? ?? 85 C0 74 4D 8B 43 30 8B 10 FF 52 0C 50 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 3C 8B F8 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C7 85 C0 74 03 83 E8 CC E8 ?? ?? ?? ?? 84 C0 74 16 8D 55 F8 8B 45 FC 8B 08 FF 51 1C 8B 55 F8 8D 43 34 E8 ?? ?? ?? ?? 8B C6 8B 53 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 0D 2F CD 19 8F E6 6F 4A 92 AA 4C 76 59 E8 37 08 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "TWebEndUserStub.Get_LoginFormAction"
		size = 136
		refs = "0014 TWebEndUserStub.Get_LoginFormAction 0022 @IntfClear 002c TWebEndUserStub.EndUser 006c IWebEndUser 0076 @FinalizeArray 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 74 24 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 8B 10 FF 52 24 8B F0 85 F6 74 0C 8B 4D FC 8B D6 8B C3 8B 18 FF 53 1C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "TWebEndUserStub.Get_LogoutAction"
		size = 136
		refs = "0014 TWebEndUserStub.Get_LogoutAction 0022 @IntfClear 002c TWebEndUserStub.EndUser 006c IWebEndUser 0076 @FinalizeArray 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 74 24 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 8B 10 FF 52 20 8B F0 85 F6 74 0C 8B 4D FC 8B D6 8B C3 8B 18 FF 53 1C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "TWebEndUserStub.Get_DisplayName"
		size = 118
		refs = "0011 TWebEndUserStub.Get_DisplayName 0021 TWebEndUserStub.EndUser 0044 @UStrClr 005a IWebEndUser 0064 @FinalizeArray 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B D6 8B 08 FF 51 18 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "TWebEndUserStub.Get_LoggedIn"
		size = 111
		refs = "000e TWebEndUserStub.Get_LoggedIn 001e TWebEndUserStub.EndUser 0052 IWebEndUser 005c @FinalizeArray 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 10 FF 52 1C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_98462_0 {
	meta:
		name = "TCurrentWebPageInfo.GetPageIsPublished"
		size = 111
		refs = "000e TCurrentWebPageInfo.GetPageIsPublished 001e TCurrentWebPageInfo.WebPageInfo 0052 IWebPageInfo 005c @FinalizeArray 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 10 FF 52 1C 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "TAdapterFieldValuesStub.Get_Value"
		size = 208
		refs = "0015 TAdapterFieldValuesStub.Get_Value 0023 @IntfClear 0032 Supports 006c @VarClear 0076 @VarCopy 008b @VarClr 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 2E 8B 45 F8 8B 10 FF 52 0C 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B 45 FC 8B 08 FF 51 0C EB 12 8D 45 E8 E8 ?? ?? ?? ?? 8B C6 8D 55 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 00 13 FE BD 87 10 CA D4 11 A5 28 00 C0 4F 6B B8 53 07 D6 C0 5D 9C 1C 67 4E B3 BA 35 CE 2A 58 72 A0 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "TAdapterFieldValuesStub.HasValue"
		size = 216
		refs = "0020 @VarAddRef 0028 TAdapterFieldValuesStub.HasValue 0036 @IntfClear 0045 Supports 0091 @VarClr 00a7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D FC 89 4D F8 8B F2 8D 7D E8 A5 A5 A5 A5 8B D8 8D 45 E8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 31 8B 45 F8 8B 10 FF 52 0C 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0F 8D 55 E8 8B 45 FC 8B 08 FF 51 10 8B D8 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C3 5F 5E 5B 8B E5 5D C3 00 00 13 FE BD 87 10 CA D4 11 A5 28 00 C0 4F 6B B8 53 07 D6 C0 5D 9C 1C 67 4E B3 BA 35 CE 2A 58 72 A0 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "TEnumDispatcherAS.Invoke"
		size = 152
		refs = "002b _DV_TScriptEnumerator 0030 TScriptEnumerator.Create 0041 TEnumDispatcherAS.Invoke 0046 @IntfCast 0050 @VarFromIntf 007c TCustomEnumDispatcher.Invoke"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 20 8B 45 0C 8B 5D 08 83 F8 FC 75 4B 85 F6 74 40 8B FE 66 C7 07 00 00 83 7B 18 00 75 25 8B 4B 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 43 18 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 8B 53 18 E8 ?? ?? ?? ?? 33 C0 EB 28 B8 01 00 00 00 EB 21 8B 55 28 52 8B 55 24 52 56 8B 55 1C 52 0F B7 55 18 52 8B 55 14 52 8B 55 10 52 50 53 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 24 00 00 04 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "TActiveScriptSite.GetDocVersionString"
		size = 23
		altNames = "TCustomMSHTMLParser.GetContainer TOleControl.GetExtendedControl TOleLinkStub.GetBoundSource TOleLinkStub.GetSourceMoniker TScriptEnumerator.Clone TStreamAdapter.Clone"
	strings:
		$1 = { 55 8B EC 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "TScriptEnumerator.Create"
		size = 81
		refs = "000b @ClassCreate 001a TObject.Create 002e @IntfCopy 003d @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8D 47 10 8B D6 85 D2 74 03 83 EA E4 E8 ?? ?? ?? ?? C6 47 15 01 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "TScriptEnumerator.Destroy"
		size = 33
		refs = "0003 @BeforeDestruction 000f @IntfClear 001a @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 10 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "TScriptEnumerator.GetIDsOfNames"
		size = 39
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 0C 50 8B 00 FF 50 0C 5D C2 18 00 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "TScriptEnumerator.GetTypeInfo"
		size = 31
		refs = "0017 TObjectDispatch.GetTypeInfo"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 0C 50 E8 ?? ?? ?? ?? 5D C2 10 00 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "TScriptEnumerator.GetTypeInfoCount"
		size = 23
		refs = "000f TObjectDispatch.GetTypeInfoCount"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 52 8B 40 0C 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "TScriptEnumerator.Invoke"
		size = 52
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 28 52 8B 55 24 52 8B 55 20 52 8B 55 1C 52 0F B7 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 0C 50 8B 00 FF 50 10 5D C2 24 00 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "TScriptEnumerator.Next"
		size = 189
		refs = "0011 TScriptEnumerator.Next 0061 TEnumeratorObj.item 006c @OleVarFromVar 00a8 @VarClr 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 15 00 74 20 C6 43 1C 00 C6 43 15 00 33 C0 89 43 18 C6 43 1C 01 8B 43 0C 8B 10 FF 52 28 34 01 88 43 14 EB 0D 8B 43 0C 8B 10 FF 52 2C 34 01 88 43 14 80 7B 14 00 75 34 83 7D 0C 01 75 27 8D 55 F0 8B 43 0C E8 ?? ?? ?? ?? 8D 55 F0 8B 45 10 E8 ?? ?? ?? ?? 8B 45 14 85 C0 74 11 8B 45 14 8B 55 0C 89 10 EB 07 BB 01 40 00 80 EB 0F 80 7B 14 00 74 07 BB 01 00 00 00 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "TScriptEnumerator.Reset"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 C6 40 15 01 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "TScriptEnumerator.Skip"
		size = 75
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 0C 8B 5D 08 80 7B 14 00 74 07 B8 01 00 00 00 EB 2B 33 F6 EB 0E 8B 43 0C 8B 10 FF 52 2C 34 01 88 43 14 46 80 7B 14 00 75 04 3B FE 77 E8 80 7B 14 00 75 04 33 C0 EB 05 B8 01 00 00 00 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "Finalization"
		size = 18
		refs = "0002 _DV_1 0009 DispatcherClass"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 09 A1 ?? ?? ?? ?? 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_71473_0 {
	meta:
		name = "Finalization"
		size = 18
		refs = "0002 _DV_2 0009 CreateVCLComObjectProc"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 09 A1 ?? ?? ?? ?? 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_78042_0 {
	meta:
		name = "Finalization"
		size = 18
		refs = "0002 _DV_2 0009 PasswordDialog"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 09 A1 ?? ?? ?? ?? 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "AutoAdapAS"
		size = 23
		refs = "0002 _DV_1 000a DispatcherClass 0010 _DV_TEnumDispatcherAS"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_26501_0 {
	meta:
		name = "DBAdaptImg"
		size = 23
		refs = "0002 _DV_3 000a DataSetAdapterImageFieldClass 0010 _DV_TDataSetAdapterImageField"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_73969_0 {
	meta:
		name = "Vcl.CaptionedDockTree"
		size = 23
		refs = "0002 _DV_3 000a DefaultDockTreeClass 0010 _DV_TCaptionedDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_78690_0 {
	meta:
		name = "Vcl.DockTabSet"
		size = 23
		refs = "0002 _DV_6 000a DefaultDockTreeClass 0010 _DV_TCaptionedTabDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "ConfirmDeleteItem"
		size = 144
		refs = "000c ConfirmDeleteItem 001e SDeleteConfirmPlural 0023 LoadResString 002d SDeleteConfirm 003d @UStrLAsg 0059 MessageDlgPosHelp 0079 @UStrArrayClr 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 84 C0 74 0F 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F8 8B 55 FC E8 ?? ?? ?? ?? B0 03 0F B7 15 ?? ?? ?? ?? 33 C9 51 6A FF 6A FF 6A 00 8B 4D F8 92 91 E8 ?? ?? ?? ?? 83 F8 06 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5B 59 59 5D C3 03 00 00 00 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "GetAzureImage"
		size = 95
		refs = "000c @UStrAddRef 0014 GetAzureImage 0021 _Dn_TBitmap 0026 TBitmap.Create 0031 HInstance 0038 TBitmap.LoadFromResourceName 004d @UStrClr 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 4D FC 8B 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "GetFirstMatchingChildNode"
		size = 269
		refs = "001c @IntfAddRef 0024 @UStrAddRef 002c GetFirstMatchingChildNode 0039 @IntfClear 0054 EmptyStr 005b @UStrEqual 009b @IntfCopy 00d9 @UStrClr 00f2 IXMLNode 00fc @FinalizeArray 0102 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 8B D9 89 55 F4 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 7D 8B 45 FC 8B 10 FF 52 24 84 C0 74 71 8B 45 F4 8B 15 ?? ?? ?? ?? 8B 12 E8 ?? ?? ?? ?? 74 5F 8D 55 F0 8B 45 FC 8B 08 FF 51 14 8B 45 F0 8D 55 F8 8B 08 FF 51 34 83 7D F8 00 74 43 8D 55 EC 8B 45 F8 8B 08 FF 51 34 8B 45 EC 8B 55 F4 E8 ?? ?? ?? ?? 75 0C 8B C3 8B 55 F8 E8 ?? ?? ?? ?? EB 1F 8D 55 E8 8B 45 F8 8B 08 FF 91 90 00 00 00 8B 55 E8 8D 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 75 BD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C5 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "SelectBottomCell"
		size = 91
		refs = "000e TValueListEditor.GetRowCount 0018 TValueListEditor.GetColCount 0023 TValueListEditor.GetStrings 004a TCustomGrid.SetRow 0053 TCustomGrid.SetCol"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 85 FF 74 4C 8B C7 E8 ?? ?? ?? ?? 48 7E 42 8B C7 E8 ?? ?? ?? ?? 85 C0 7E 37 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 52 14 85 C0 7E 27 84 DB 74 04 33 F6 EB 05 BE 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 48 8B D0 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "SelectTopCell"
		size = 89
		refs = "000d TValueListEditor.GetRowCount 0017 TValueListEditor.GetColCount 0022 TValueListEditor.GetStrings 0037 TCustomGrid.SetRow 0044 TCustomGrid.SetCol"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 F6 74 4C 8B C6 E8 ?? ?? ?? ?? 48 7E 42 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 37 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 14 85 C0 7E 27 BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0B 33 D2 8B C6 E8 ?? ?? ?? ?? EB 0C BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "ShowErrorMessage$131$ActRec.$0$Body"
		size = 100
		refs = "000c ShowErrorMessage$131$ActRec.$0$Body 001d @UStrLAsg 0039 MessageDlgPosHelp 004e @UStrClr 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 53 0C E8 ?? ?? ?? ?? B0 01 0F B7 15 ?? ?? ?? ?? 33 C9 51 6A FF 6A FF 6A 00 8B 4D FC 92 91 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "ShowErrorMessage"
		size = 114
		refs = "000d ShowErrorMessage 001a _DV_ShowErrorMessage$131$ActRec 001f TObject.Create 0032 @IntfCopy 003c @UStrAsg 004c TThread.Synchronize 0061 @IntfClear 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8D 45 FC 8B D3 85 D2 74 03 83 EA F8 E8 ?? ?? ?? ?? 8D 43 0C 8B D6 E8 ?? ?? ?? ?? 8B D3 85 D2 74 03 83 EA F0 33 C0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "ShowInformationMessage"
		size = 114
		refs = "000d ShowInformationMessage 001a _DV_ShowInformationMessage$133$ActRec 001f TObject.Create 0032 @IntfCopy 003c @UStrAsg 004c TThread.Synchronize 0061 @IntfClear 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8D 45 FC 8B D3 85 D2 74 03 83 EA F8 E8 ?? ?? ?? ?? 8D 43 0C 8B D6 E8 ?? ?? ?? ?? 8B D3 85 D2 74 03 83 EA F0 33 C0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "ShowInformationMessage$133$ActRec.$0$Body"
		size = 100
		refs = "000c ShowInformationMessage$133$ActRec.$0$Body 001d @UStrLAsg 0039 MessageDlgPosHelp 004e @UStrClr 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 53 0C E8 ?? ?? ?? ?? B0 02 0F B7 15 ?? ?? ?? ?? 33 C9 51 6A FF 6A FF 6A 00 8B 4D FC 92 91 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "TAzureTreeNode.Destroy"
		size = 63
		refs = "0003 @BeforeDestruction 0019 TObject.Free 0022 TTreeNode.SetData 002d TTreeNode.Destroy 0038 @ClassDestroy"
		altNames = "TBTreeNode.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 83 7E 0C 00 74 15 8B 46 0C D1 E8 03 C0 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "TAzureManagement.Notification"
		size = 45
		refs = "0010 TCustomTreeView.Notification"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 10 3B BE B0 03 00 00 75 08 33 C0 89 86 B0 03 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "TQueryTableProducer.Content"
		size = 454
		refs = "001c TQueryTableProducer.Content 002a @UStrClr 003d TDataSet.Close 0048 TQuery.GetParamsCount 005d TCustomContentProducer.GetDispatcher 0092 TWebRequest.GetContentFields 00c5 TWebRequest.GetQueryFields 00ef TStrings.GetName 0103 TParams.ParamByName 0116 TStrings.GetValue 0120 TParam.SetText 0133 TDataSet.Open 013a TDSTableProducer.DoCreateContent 0160 HtmlTable 017e @UStrCatN 0198 @UStrArrayClr 01a1 IWebDispatcherAccess 01ab @FinalizeArray 01b9 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 83 A0 00 00 00 85 C0 0F 84 46 01 00 00 E8 ?? ?? ?? ?? 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 66 85 C0 0F 84 D7 00 00 00 33 F6 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 83 7D EC 00 74 64 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 45 E8 8B 10 FF 52 0C 80 78 08 03 75 1B 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 8B 10 FF 52 0C E8 ?? ?? ?? ?? 8B F0 EB 31 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 8B 45 E0 8B 10 FF 52 0C 80 78 08 01 75 19 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 45 DC 8B 10 FF 52 0C E8 ?? ?? ?? ?? 8B F0 85 F6 74 5D 8B C6 8B 10 FF 52 14 48 85 C0 7C 51 40 89 45 F0 C7 45 F4 00 00 00 00 8D 4D FC 8B 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 83 A0 00 00 00 8B 80 58 02 00 00 8B 55 FC E8 ?? ?? ?? ?? 8B F8 85 FF 74 17 8D 4D D8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 D8 8B C7 E8 ?? ?? ?? ?? FF 45 F4 FF 4D F0 75 BA 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 40 8D 55 D4 8B 43 64 8B 08 FF 51 1C FF 75 D4 8D 45 D0 50 8B 4B 6C 8B D3 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? FF 75 D0 8D 55 CC 8B 43 68 8B 08 FF 51 1C FF 75 CC 8B 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? B9 05 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "TArrowSeries.GetStartXValues"
		size = 7
		altNames = "TDataSetTableProducer.GetDataSet TGanttSeries.GetStartValues TQueryTableProducer.GetDataSet TSQLQueryTableProducer.GetDataSet"
	strings:
		$1 = { 8B 80 A0 00 00 00 C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "TDataSetTableProducer.Notification"
		size = 45
		refs = "0010 TDSTableProducer.Notification"
		altNames = "TQueryTableProducer.Notification TSQLQueryTableProducer.Notification"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 10 3B B7 A0 00 00 00 75 08 33 C0 89 87 A0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_329_0 {
	meta:
		name = "TQueryTableProducer.SetDataSet"
		size = 31
		refs = "000a _Dn_TQuery 000f @AsClass 0018 TQueryTableProducer.SetQuery"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_95763_0 {
	meta:
		name = "TSQLQueryTableProducer.SetDataSet"
		size = 31
		refs = "000a _Dn_TSQLQuery 000f @AsClass 0018 TSQLQueryTableProducer.SetQuery"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "TDataSetTableProducer.SetDataSet"
		size = 48
		refs = "0017 TComponent.FreeNotification 0029 TDataSource.SetDataSet"
		altNames = "TQueryTableProducer.SetQuery TSQLQueryTableProducer.SetQuery"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B B3 A0 00 00 00 74 1F 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 89 83 A0 00 00 00 8B D0 8B 43 58 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "RegisterBDEInitProc"
		size = 43
		refs = "0005 BDEInitProcs 000f _Dn_TList 0014 TObject.Create 0025 TList.Add"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_45117_0 {
	meta:
		name = "RegisterIWFormType"
		size = 43
		refs = "0005 GIWFormTypes 000f _Dn_TList 0014 TObject.Create 0025 TList.Add"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_92901_0 {
	meta:
		name = "RegisterTeeExportFormat"
		size = 43
		refs = "0005 TeeExportFormats 000f _DV_TTeeExportFormats 0014 TObject.Create 0025 TList.Add"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "CheckIndexOpen"
		size = 17
		refs = "000c DbiError"
	strings:
		$1 = { 66 85 C0 74 0B 66 3D 2C 27 74 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "GetPChar"
		size = 24
		refs = "000c GetPChar"
	strings:
		$1 = { 53 8B D8 85 DB 74 04 8B C3 5B C3 B8 ?? ?? ?? ?? 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "Split"
		size = 11
	strings:
		$1 = { 55 8B EC 8B 55 08 89 42 FC 5D C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "NextItem"
		size = 352
		refs = "0013 @UStrClr 0033 NextItem 003b CharInSet 00fd @UStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 81 C4 D8 F7 FF FF 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 58 FC 8D B5 FA F7 FF FF EB 0D 66 83 3B 00 0F 84 E8 00 00 00 83 C3 02 BA ?? ?? ?? ?? 0F B7 03 E8 ?? ?? ?? ?? 84 C0 75 E2 66 C7 45 FA 2E 00 66 83 3B 22 75 5F 66 C7 45 FA 22 00 83 C3 02 EB 54 0F B7 3B 66 81 FF 00 D8 72 12 66 81 FF FF DF 77 0B 66 89 3E 83 C3 02 83 C6 02 EB 2C 66 83 FF 5C 75 26 83 C3 02 66 81 3B 00 D8 72 13 66 81 3B FF DF 77 0C 0F B7 03 66 89 06 83 C3 02 83 C6 02 66 83 3B 00 75 03 83 EB 02 0F B7 03 66 89 06 83 C3 02 83 C6 02 56 BE ?? ?? ?? ?? 8D BD D8 F7 FF FF B9 08 00 00 00 F3 A5 5E 0F B7 45 FA 0F B6 C0 0F AB 85 D8 F7 FF FF 8D 95 D8 F7 FF FF 0F B7 03 E8 ?? ?? ?? ?? 84 C0 0F 84 74 FF FF FF 8D 85 FA F7 FF FF 8B CE 2B C8 D1 F9 79 03 83 D1 00 8B D0 8B 45 FC E8 ?? ?? ?? ?? 66 83 7D FA 22 75 09 66 83 3B 00 74 03 83 C3 02 8B 45 08 89 58 FC 5F 5E 5B 8B E5 5D C3 00 00 01 00 00 00 01 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "PopValue"
		size = 52
		refs = "001a GetPChar 0027 PopValue"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 F8 00 7C 1A 8B 45 08 8B 40 F8 8B 55 08 8B 44 82 E4 E8 ?? ?? ?? ?? 8B 55 08 FF 4A F8 5D C3 B8 ?? ?? ?? ?? 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_6278_0 {
	meta:
		name = "PopValue"
		size = 52
		refs = "001a GetPWChar 0027 PopValue"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 F8 00 7C 1A 8B 45 08 8B 40 F8 8B 55 08 8B 44 82 E4 E8 ?? ?? ?? ?? 8B 55 08 FF 4A F8 5D C3 B8 ?? ?? ?? ?? 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "GetFieldSource"
		size = 318
		refs = "001f string 0024 @InitializeArray 002c GetFieldSource 0047 @UStrFromArray 0051 TDataSet.FindField 0074 Split 0088 NextItem 0098 @UStrLAsg 00b7 PopValue 00c5 StrCopy 0116 @UStrArrayClr 0129 @FinalizeArray 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 C9 89 4D DC 89 4D E0 8B FA 8B F0 B9 05 00 00 00 8D 45 E4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8D 45 E0 8D 97 27 01 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 E0 8B C6 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 A1 00 00 00 83 BE 98 00 00 00 00 0F 84 94 00 00 00 55 8B 86 98 00 00 00 E8 ?? ?? ?? ?? 59 C7 45 F8 FF FF FF FF FF 45 F8 55 8D 45 DC E8 ?? ?? ?? ?? 59 8B 55 DC 8B 45 F8 8D 44 85 E4 E8 ?? ?? ?? ?? 8B 45 F8 83 7C 85 E4 00 74 06 83 7D F8 04 75 D4 83 7D F8 04 74 4E FF 4D F8 55 E8 ?? ?? ?? ?? 59 8B D0 8D 87 47 01 00 00 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B D0 8D 47 22 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B D0 8D 47 02 E8 ?? ?? ?? ?? 80 BF 47 01 00 00 00 74 06 80 7F 22 00 75 04 33 DB EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 B9 05 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "ApplicationHandleException"
		size = 29
		refs = "0003 ApplicationHandleException"
		altNames = "TCustomClientDataSet.InternalHandleException TTeeDataSet.InternalHandleException"
	strings:
		$1 = { 53 8B 15 ?? ?? ?? ?? 66 83 7A 02 00 74 0D 8B 1D ?? ?? ?? ?? 8B D0 8B 43 04 FF 13 5B C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "GetParamDataSize"
		size = 227
		refs = "0010 GetParamDataSize 001d TParam.GetDataType 002f TParam.GetAsAnsiString 00b1 TParam.GetDataSize 00c8 @LStrClr 00d6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 2C 01 74 04 2C 16 75 26 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 89 45 F8 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 3D FF 00 00 00 0F 9F C0 EB 02 33 C0 84 C0 74 04 B0 01 EB 19 8B C3 E8 ?? ?? ?? ?? 04 F1 2C 07 72 0A 04 F8 2C 02 72 04 33 C0 EB 02 B0 01 84 C0 74 07 BB 10 00 00 00 EB 3A 8B C3 E8 ?? ?? ?? ?? 2C 18 74 06 04 F2 2C 02 73 20 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 89 45 F8 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 8B D8 EB 09 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_347_0 {
	meta:
		name = "VarToAnsiStr"
		size = 110
		refs = "000f VarToAnsiStr 0020 VarIsType 002d @VarToLStr 0039 VarToStr 0048 @LStrFromUStr 005d @UStrClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 66 BA 00 01 E8 ?? ?? ?? ?? 84 C0 74 0B 8B C6 8B D3 E8 ?? ?? ?? ?? EB 19 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 00 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "MakeNativeStr"
		size = 41
		refs = "0016 @UStrSetLength 0021 Move"
	strings:
		$1 = { 53 56 57 8B F1 8B DA 8B F8 8D 53 01 D1 FA 79 03 83 D2 00 8B C6 E8 ?? ?? ?? ?? 8B 16 8B C7 8B CB E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "GetParamData"
		size = 521
		refs = "0021 GetParamData 002e TParam.GetDataType 0050 TParam.GetAsVariant 005b VarToAnsiStr 00b3 @LStrToPChar 00c7 AnsiToNativeBuf 00e0 MakeNativeStr 00eb @UStrAsg 0159 Move 0164 TParam.GetData 0183 TParam.GetAsBytes 018b @DynArrayLength 01d8 @UStrArrayClr 01e0 @VarClr 01e9 TArray<System.Byte> 01ee @DynArrayClear 01f6 @LStrClr 01fc @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 2C 01 74 14 2C 0F 74 10 04 F9 2C 02 72 0A 04 F3 2C 02 0F 83 20 01 00 00 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8D 45 E4 8D 55 FC E8 ?? ?? ?? ?? 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 3D FF 00 00 00 7E 04 B0 01 EB 0C 8B C3 E8 ?? ?? ?? ?? 3C 10 0F 94 C0 84 C0 74 04 B0 01 EB 0C 8B C3 E8 ?? ?? ?? ?? 3C 27 0F 94 C0 84 C0 74 6E 8B FE 83 7D F4 00 74 29 8B 75 FC 85 F6 74 05 83 EE 04 8B 36 56 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 F4 59 E8 ?? ?? ?? ?? 8B 75 FC 85 F6 74 05 83 EE 04 8B 36 8D 4D E0 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E0 8D 43 10 E8 ?? ?? ?? ?? 8B 43 10 89 07 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 89 47 04 E9 BA 00 00 00 83 7D F4 00 74 27 8B 5D FC 85 DB 74 05 83 EB 04 8B 1B 43 53 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B CE 8B 45 F4 E8 ?? ?? ?? ?? E9 8D 00 00 00 8B C3 E8 ?? ?? ?? ?? 2C 18 74 06 04 F2 2C 02 73 19 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 8B D6 8B 4D FC 91 E8 ?? ?? ?? ?? EB 63 8B D6 8B C3 E8 ?? ?? ?? ?? EB 58 8B C3 E8 ?? ?? ?? ?? 04 F1 2C 07 72 06 04 F8 2C 02 73 3C 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8D 4D DC 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 DC 8D 43 10 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 89 46 04 8B 43 10 89 06 EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CD 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_350_0 {
	meta:
		name = "GetStatementLocale"
		size = 67
		refs = "0020 DbiGetProp 0029 @PCharLen 0038 OsLdLoadBySymbName"
	strings:
		$1 = { 83 C4 D8 C6 44 24 06 00 33 D2 89 14 24 8D 54 24 04 52 6A 20 8D 54 24 0E 52 68 04 00 06 00 50 E8 ?? ?? ?? ?? 8D 44 24 06 E8 ?? ?? ?? ?? 85 C0 76 0B 54 8D 44 24 0A 50 E8 ?? ?? ?? ?? 8B 04 24 83 C4 28 C3 }
	condition:
		$1
}

rule function_351_0 {
	meta:
		name = "FreeStatementLocale"
		size = 20
		refs = "000a OsLdUnloadObj"
	strings:
		$1 = { 53 8B D8 83 3B 00 74 06 53 E8 ?? ?? ?? ?? 33 C0 89 03 5B C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "SetQueryParams"
		size = 746
		refs = "0024 SetQueryParams 0042 TFieldDescList 0047 @DynArraySetLength 0066 TParams.GetItem 006b GetParamDataSize 0084 TArray<System.Byte> 00b1 GetStatementLocale 00f9 TParam.GetDataType 0103 FldTypeMap 012a FldSubTypeMap 0143 SNoParameterValue 0148 LoadResString 0164 DatabaseErrorFmt 0192 GetParamData 01a6 TParam.GetIsNull 01e2 TParam.GetAsAnsiString 0202 TParam.GetDataSize 0271 @DynArrayHigh 027c DbiQSetParams 0281 Check 0296 FreeStatementLocale 029c @HandleFinally 02b3 @LStrClr 02bb @UStrClr 02c9 @DynArrayClear"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 33 DB 89 5D C8 89 5D D4 89 5D FC 89 5D F8 89 4D EC 89 55 F0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 75 EC 8B 46 08 8B 40 08 50 8D 45 FC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 66 BB 02 00 8B 46 08 8B 78 08 4F 85 FF 7C 19 47 33 F6 8B D6 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 03 D8 46 4F 75 EA 0F B7 F3 56 8D 45 F8 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 89 45 E8 8B 45 E8 89 45 E4 03 75 E8 83 EE 02 89 75 E0 8B 45 E0 66 C7 00 FF FF 8B 45 F0 E8 ?? ?? ?? ?? 89 45 DC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 EC 8B 40 08 8B 78 08 4F 85 FF 0F 8C 8D 01 00 00 47 33 F6 8B C6 C1 E0 05 2B C6 8B 55 FC 8D 1C 42 8B D6 8B 45 EC E8 ?? ?? ?? ?? 89 45 D8 8B 45 D8 E8 ?? ?? ?? ?? 83 E0 7F 0F B6 80 ?? ?? ?? ?? 66 89 43 22 0F B7 43 22 66 83 E8 01 74 06 66 83 E8 02 75 19 8B 45 D8 E8 ?? ?? ?? ?? 83 E0 7F 0F B7 04 45 ?? ?? ?? ?? 66 89 43 24 EB 34 66 83 7B 22 00 75 2D 8B 45 F4 50 8D 55 D4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D4 50 8B 45 D8 8B 40 34 89 45 CC C6 45 D0 11 8D 55 CC 33 C9 58 E8 ?? ?? ?? ?? 8B C6 40 66 89 03 8B D6 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 43 2C 8B D6 8B 45 EC E8 ?? ?? ?? ?? 8B 4D DC 8B 55 E4 E8 ?? ?? ?? ?? 0F B7 45 E4 66 2B 45 E8 66 89 43 2A 8B 45 D8 E8 ?? ?? ?? ?? 84 C0 74 11 0F B7 45 E0 66 2B 45 E8 66 89 43 2E E9 97 00 00 00 0F B7 43 22 66 83 F8 01 75 44 8B 45 D8 E8 ?? ?? ?? ?? 2C 18 74 06 04 F2 2C 02 73 23 8D 55 C8 8B 45 D8 E8 ?? ?? ?? ?? 8B 45 C8 89 45 C4 8B 45 C4 85 C0 74 05 83 E8 04 8B 00 66 89 43 26 EB 58 8B 45 D8 E8 ?? ?? ?? ?? 48 66 89 43 26 EB 49 66 83 F8 09 75 0E 8B 45 D8 E8 ?? ?? ?? ?? 66 89 43 26 EB 35 66 83 F8 0F 75 12 8B 45 D8 E8 ?? ?? ?? ?? 66 83 E8 02 66 89 43 26 EB 1D 66 83 F8 03 75 17 8B 45 D8 E8 ?? ?? ?? ?? 83 E0 7F 0F B7 04 45 ?? ?? ?? ?? 66 89 43 24 0F B7 43 2C 01 45 E4 46 4F 0F 85 76 FE FF FF 8B 45 F8 50 8B 45 FC 50 8B 45 FC E8 ?? ?? ?? ?? 40 50 8B 45 F0 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_353_0 {
	meta:
		name = "FreeTimer"
		size = 93
		refs = "0006 TimerID 0012 GetTickCount 0018 StartTime 001e SQLDelay 002f KillTimer 0044 DBScreen"
	strings:
		$1 = { 53 8B D8 66 83 3D ?? ?? ?? ?? 00 74 4E 84 DB 75 13 E8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 76 37 0F B7 05 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 66 C7 05 ?? ?? ?? ?? 00 00 33 C0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 74 0E A1 ?? ?? ?? ?? 8B 00 33 D2 8B 08 FF 51 10 5B C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "TimerCallBack"
		size = 14
		refs = "0006 FreeTimer"
	strings:
		$1 = { 55 8B EC 33 C0 E8 ?? ?? ?? ?? 5D C2 10 00 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "BdeCallBack"
		size = 33
		refs = "0014 TBDECallback.Invoke"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 85 DB 74 0F 8B 55 08 8B 4D 10 8B C3 E8 ?? ?? ?? ?? EB 02 33 C0 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "DLLDetachCallBack"
		size = 28
		refs = "0004 Session 000d Sessions 0012 TSessionList.CloseAll"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? C6 40 59 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5D C2 0C 00 }
	condition:
		$1
}

rule function_357_0 {
	meta:
		name = "TBDECallback.Create"
		size = 157
		refs = "000d @ClassCreate 0047 DbiGetCallBack 005a BdeCallBack 0071 DbiRegisterCallBack 0076 Check 0087 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 8B 45 20 89 4B 08 89 43 04 8B 55 1C 89 53 0C 8B 55 0C 89 53 28 8B 55 10 89 53 2C 8D 53 1C 52 8D 53 14 52 8D 53 18 52 8D 53 10 52 8B 53 0C 52 50 E8 ?? ?? ?? ?? 83 7B 1C 00 0F 95 C0 34 01 0A 45 08 74 25 68 ?? ?? ?? ?? 8B 45 18 50 0F B7 45 14 50 53 8B 43 0C 50 8B 43 04 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 43 20 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5B 59 5D C2 1C 00 }
	condition:
		$1
}

rule function_358_0 {
	meta:
		name = "TBDECallback.Destroy"
		size = 170
		refs = "000a @BeforeDestruction 002a TBDECallback.Destroy 0060 DbiRegisterCallBack 006f @HandleAnyException 0074 @DoneExcept 009f @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 E8 ?? ?? ?? ?? 88 55 FB 89 45 FC 8B 45 FC 80 78 20 00 74 78 8B 45 FC 83 78 1C 00 74 54 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 1C 50 8B 45 FC 8B 40 14 50 8B 45 FC 0F B7 40 18 50 8B 45 FC 8B 40 10 50 8B 45 FC 8B 40 0C 50 8B 45 FC 8B 40 04 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 27 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 6A 00 6A 00 6A 00 6A 00 8B 45 FC 8B 40 0C 50 8B 45 FC 8B 40 04 50 E8 ?? ?? ?? ?? 80 7D FB 00 7E 08 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "TBDECallback.Invoke"
		size = 45
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 3B 73 0C 75 0A 8B D7 8B 43 2C FF 53 28 EB 02 33 C0 83 7B 1C 00 74 09 57 8B 43 10 50 56 FF 53 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_360_0 {
	meta:
		name = "StrToOem"
		size = 57
		refs = "000c @LStrAsg 0028 @LStrToPChar 0031 CharToOemA"
	strings:
		$1 = { 53 56 51 8B DA 8B F0 8B C3 8B D6 E8 ?? ?? ?? ?? 8B 03 89 04 24 8B 04 24 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 10 8B 03 E8 ?? ?? ?? ?? 8B F0 56 56 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "AnsiToNative"
		size = 99
		refs = "002b SysLocale 003a ByteType 0054 AnsiToNativeBuf"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F1 8B FA 89 45 FC 8B 55 08 89 7D F8 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 8B D8 3B D3 7D 1B 8B DA A1 ?? ?? ?? ?? 80 78 0C 00 74 0E 8B D3 8B C7 E8 ?? ?? ?? ?? 3C 01 75 01 4B C6 04 1E 00 85 DB 7E 0D 53 8B CE 8B D7 8B 45 FC E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "NativeToAnsi"
		size = 56
		refs = "000e @PCharLen 001d @LStrFromPCharLen 002f NativeToAnsiBuf"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 89 04 24 8B C6 E8 ?? ?? ?? ?? 8B D8 6A 00 8B C7 8B CB 33 D2 E8 ?? ?? ?? ?? 85 DB 7E 0E 53 8B 0F 8B D6 8B 44 24 04 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "AnsiToNative"
		size = 100
		refs = "0012 AnsiToNative 002b @LStrFromUStr 004e @LStrClr 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 8D 45 FC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B CF 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "NativeToAnsi"
		size = 100
		refs = "0012 NativeToAnsi 0027 @LStrFromUStr 003d @UStrFromLStr 0052 @LStrClr 0058 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 13 B9 00 00 00 00 E8 ?? ?? ?? ?? 8D 4D FC 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "AnsiToNativeBuf"
		size = 137
		refs = "001c CSAnsiToNative 0024 TMonitor.CheckMonitorSupport 002c TMonitor.GetMonitor 0034 TMonitor.Enter 003c AnsiToNativeBuf 0052 DbiAnsiToNative 0069 TMonitor.Exit 006f @HandleFinally 007c CharToOemBuffA"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 85 DB 7E 69 85 F6 74 5A A1 ?? ?? ?? ?? 89 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 53 57 8B 45 FC 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 53 8B 45 FC 50 57 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "NativeToAnsiBuf"
		size = 137
		refs = "001c CSNativeToAnsi 0024 TMonitor.CheckMonitorSupport 002c TMonitor.GetMonitor 0034 TMonitor.Enter 003c NativeToAnsiBuf 0052 DbiNativeToAnsi 0069 TMonitor.Exit 006f @HandleFinally 007c OemToCharBuffA"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 85 DB 7E 69 85 F6 74 5A A1 ?? ?? ?? ?? 89 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 53 57 8B 45 FC 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 53 8B 45 FC 50 57 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "NativeCompareStr"
		size = 48
		refs = "0013 @LStrToPChar 0025 NativeCompareStrBuf"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 50 8B C7 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 59 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "NativeCompareText"
		size = 48
		refs = "0013 @LStrToPChar 0025 NativeCompareTextBuf"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 50 8B C7 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 59 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "NativeCompareStrBuf"
		size = 60
		refs = "001d OsLdStrnCmp 002d OsLdStrCmp"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 85 DB 7E 11 53 8B 45 FC 50 57 56 E8 ?? ?? ?? ?? 0F B7 C0 EB 0E 8B 45 FC 50 57 56 E8 ?? ?? ?? ?? 0F B7 C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "NativeCompareTextBuf"
		size = 60
		refs = "001d OsLdStrnCmpi 002d OsLdStrCmpi"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 85 DB 7E 11 53 8B 45 FC 50 57 56 E8 ?? ?? ?? ?? 0F BF C0 EB 0E 8B 45 FC 50 57 56 E8 ?? ?? ?? ?? 0F BF C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "IsDirectory"
		size = 55
		refs = "0027 @UStrLen"
	strings:
		$1 = { 53 56 57 8B F0 B3 01 85 F6 74 26 BF 01 00 00 00 EB 12 0F B7 44 7E FE 66 83 E8 3A 74 14 66 83 E8 22 74 0E 47 8B C6 E8 ?? ?? ?? ?? 3B F8 7E E3 33 DB 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "IsStandardType"
		size = 84
		refs = "0004 IsStandardType 000b StrIComp"
	strings:
		$1 = { 53 8B D8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 24 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 14 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 5B C3 B0 01 5B C3 00 50 41 52 41 44 4F 58 00 44 42 41 53 45 00 00 00 46 4F 58 50 52 4F 00 00 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "GetIntProp"
		size = 48
		refs = "001a DbiGetProp"
	strings:
		$1 = { 53 56 83 C4 F8 8B F2 8B D8 33 C0 89 44 24 04 54 6A 04 8D 44 24 0C 50 56 53 E8 ?? ?? ?? ?? 66 85 C0 75 06 8B 44 24 04 EB 02 33 C0 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "SetBoolProp"
		size = 34
		refs = "0014 DbiSetProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C7 99 33 C2 2B C2 50 56 53 E8 ?? ?? ?? ?? 66 85 C0 0F 94 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "StringListToParams"
		size = 416
		refs = "0023 StringListToParams 005f Pos 0099 @UStrCopy 00d3 Format 00e3 @LStrFromUStr 00fa StrToOem 0105 @LStrAsg 0126 @LStrSetLength 013b @LStrClr 0148 @UStrArrayClr 0150 @UStrClr 015e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 33 C9 89 4D C8 89 4D EC 89 4D D0 89 4D CC 89 4D FC 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C B1 00 00 00 46 C7 45 F0 00 00 00 00 8D 4D FC 8B 55 F0 8B 45 F8 8B 18 FF 53 0C 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7C 7E 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 3B C3 7E 6E 8D 45 EC 50 8B 45 F4 8B 00 89 45 D4 C6 45 D8 0B 8D 45 D0 50 8B CB 49 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D0 89 45 DC C6 45 E0 11 8D 45 CC 50 8D 53 01 B9 FF 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 CC 89 45 E4 C6 45 E8 11 8D 55 D4 B9 02 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8B 45 F4 B9 00 00 00 00 E8 ?? ?? ?? ?? FF 45 F0 4E 0F 85 57 FF FF FF 8D 55 C8 8B 45 F4 8B 00 E8 ?? ?? ?? ?? 8B 55 C8 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 8B 00 89 45 C4 8B 45 C4 85 C0 74 05 83 E8 04 8B 00 8B D0 4A 8B 45 F4 33 C9 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D3 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 B0 04 02 00 FF FF FF FF 0A 00 00 00 25 00 73 00 25 00 73 00 3A 00 22 00 25 00 73 00 22 00 3B 00 00 00 00 00 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "DbiError"
		size = 24
		refs = "0008 _DV_EDBEngineError 000d EDBEngineError.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_96494_0 {
	meta:
		name = "AdsError"
		size = 24
		refs = "0008 _DV_EAdsException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_66219_0 {
	meta:
		name = "ArgError"
		size = 24
		refs = "0008 _DV_EInvalidArgument 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14190_0 {
	meta:
		name = "BcdError"
		size = 24
		refs = "0008 _DV_EBcdException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_68849_0 {
	meta:
		name = "ConvertError"
		size = 24
		refs = "0008 _DV_EConvertError 000d Exception.CreateRes 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_81104_0 {
	meta:
		name = "Error"
		size = 24
		refs = "0008 _DV_GIFException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80347_0 {
	meta:
		name = "InvalidGraphic"
		size = 24
		refs = "0008 _DV_EInvalidGraphic 000d Exception.CreateRes 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80673_0 {
	meta:
		name = "InvalidOp"
		size = 24
		refs = "0008 _DV_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_81600_0 {
	meta:
		name = "InvalidOperation"
		size = 24
		refs = "0008 _Dn_EInvalidGraphicOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80346_0 {
	meta:
		name = "InvalidOperation"
		size = 24
		refs = "0008 _DV_EInvalidGraphicOperation 000d Exception.CreateRes 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_82459_0 {
	meta:
		name = "OleError"
		size = 24
		refs = "0008 _DV_EOleSysError 000d EOleSysError.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14192_0 {
	meta:
		name = "OverflowError"
		size = 24
		refs = "0008 _DV_EBcdOverflowException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_63168_0 {
	meta:
		name = "RaiseConversionError"
		size = 24
		refs = "0008 _DV_EConversionError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83089_0 {
	meta:
		name = "RaiseError"
		size = 24
		refs = "0008 _DV_EPrinter 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77631_0 {
	meta:
		name = "RaiseGridError"
		size = 24
		refs = "0008 _Dn_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_115432_0 {
	meta:
		name = "RaiseXSLPageProducerError"
		size = 24
		refs = "0008 _DV_EXSLPageProducerError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_62421_0 {
	meta:
		name = "ReadError"
		size = 24
		refs = "0008 _DV_EReadError 000d Exception.CreateRes 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_50255_0 {
	meta:
		name = "SoapDateTimeError"
		size = 24
		refs = "0008 _DV_EXSDateTimeException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_50257_0 {
	meta:
		name = "SoapDecimalError"
		size = 24
		refs = "0008 _DV_EXSDecimalException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_50259_0 {
	meta:
		name = "SoapHexBinaryError"
		size = 24
		refs = "0008 _DV_EXSHexBinaryException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74404_0 {
	meta:
		name = "TabControlError"
		size = 24
		refs = "0008 _Dn_EListError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_95664_0 {
	meta:
		name = "TableError"
		size = 24
		refs = "0008 _Dn_Exception 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_115403_0 {
	meta:
		name = "TransformError"
		size = 24
		refs = "0008 _DV_TranslateException 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74660_0 {
	meta:
		name = "TreeViewError"
		size = 24
		refs = "0008 _DV_ETreeViewError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_114604_0 {
	meta:
		name = "XMLDocError"
		size = 24
		refs = "0008 _Dn_EXMLDocError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "Check"
		size = 11
		refs = "0006 DbiError"
	strings:
		$1 = { 66 85 C0 74 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "TDBError.Create"
		size = 140
		refs = "000e @ClassCreate 001c @UStrAddRef 0024 TDBError.Create 0034 TList.Add 004d @UStrAsg 0062 @UStrClr 0068 @HandleFinally 0075 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 46 18 E8 ?? ?? ?? ?? 0F B7 45 10 66 89 47 04 8B 45 0C 89 47 08 8D 47 0C 8B 55 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "TDBError.GetCategory"
		size = 9
	strings:
		$1 = { 0F B7 40 04 66 C1 E8 08 C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "TDBError.GetSubCode"
		size = 7
	strings:
		$1 = { 0F B6 40 04 24 FF C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "AddMessage"
		size = 42
	strings:
		$1 = { 55 8B EC 53 8B D8 85 DB 74 1D 8B 45 08 8B 40 FC 8B D3 8B 08 FF 51 54 40 75 0D 8B 45 08 8B 40 FC 8B D3 8B 08 FF 51 38 5B 5D C3 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "GetErrorString"
		size = 109
		refs = "0018 GetErrorString 0028 DbiGetErrorString 0037 @UStrFromArray 0044 Trim 005c @UStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 7C FF FF FF 53 33 C9 89 8D 7C FF FF FF 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 80 52 50 E8 ?? ?? ?? ?? 8B C3 8D 55 80 B9 80 00 00 00 E8 ?? ?? ?? ?? 8D 95 7C FF FF FF 8B 03 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 7C FF FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "EDBEngineError.Create"
		size = 779
		refs = "0049 @ClassCreate 0059 EDBEngineError.Create 0066 FreeTimer 006d _Dn_TList 0072 TObject.Create 007d DefaultSession 0082 TSession.GetActive 009f SInitError 00a4 LoadResString 00c7 Format 00d8 @UStrAsg 00ec _DV_TDBError 00f1 TDBError.Create 0106 GetErrorString 0123 _Dn_TStringList 0128 TStringList.Create 014b EDBEngineError.GetError 0153 AddMessage 016a DbiGetErrorEntry 018b @UStrFromArray 01d9 Trim 023e @UStrCopy 0252 SBDEError 02a0 TObject.Free 02a6 @HandleFinally 02c5 @UStrArrayClr 02dd @UStrClr 02f3 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 81 C4 44 FF FF FF 53 56 57 33 DB 89 9D 48 FF FF FF 89 9D 44 FF FF FF 89 9D 4C FF FF FF 89 9D 50 FF FF FF 89 9D 54 FF FF FF 89 9D 58 FF FF FF 89 9D 68 FF FF FF 89 9D 64 FF FF FF 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 F3 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B0 01 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 89 42 18 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 70 66 81 FE 01 2F 74 69 8D 85 68 FF FF FF 50 8D 95 64 FF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 64 FF FF FF 0F B7 D6 89 95 5C FF FF FF C6 85 60 FF FF FF 00 8D 95 5C FF FF FF 33 C9 E8 ?? ?? ?? ?? 8B 95 68 FF FF FF 8B 45 F4 83 C0 04 E8 ?? ?? ?? ?? 56 6A 00 8B 45 F4 8B 40 04 50 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 B2 01 00 00 56 6A 00 8D 95 58 FF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 85 58 FF FF FF 50 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 81 FE C4 2E 74 14 55 33 D2 8B 45 F4 E8 ?? ?? ?? ?? 8B 40 0C E8 ?? ?? ?? ?? 59 BF 01 00 00 00 8D 85 6C FF FF FF 50 8D 45 EC 50 57 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 7A 66 81 FB 06 2A 74 73 8D 45 F8 8D 95 6C FF FF FF B9 80 00 00 00 E8 ?? ?? ?? ?? 53 8B 45 EC 50 8B 45 F8 50 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D EC 00 75 21 66 81 FE C4 2E 74 1A 55 8D 95 54 FF FF FF 8B C3 E8 ?? ?? ?? ?? 8B 85 54 FF FF FF E8 ?? ?? ?? ?? 59 55 8D 95 50 FF FF FF 8B 45 F8 E8 ?? ?? ?? ?? 8B 85 50 FF FF FF E8 ?? ?? ?? ?? 59 47 E9 6E FF FF FF 8D 95 4C FF FF FF 8B 45 FC 8B 08 FF 51 1C 8B 95 4C FF FF FF 8B 45 F4 83 C0 04 E8 ?? ?? ?? ?? 8B 45 F4 83 78 04 00 74 2D 8B 45 F4 8B 58 04 85 DB 74 05 83 EB 04 8B 1B 8B 45 F4 83 C0 04 50 8B CB 83 E9 02 8B 45 F4 8B 40 04 BA 01 00 00 00 E8 ?? ?? ?? ?? EB 4B 8D 85 48 FF FF FF 50 8D 95 44 FF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 44 FF FF FF 0F B7 D6 89 95 5C FF FF FF C6 85 60 FF FF FF 00 8D 95 5C FF FF FF 33 C9 E8 ?? ?? ?? ?? 8B 95 48 FF FF FF 8B 45 F4 83 C0 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 44 FF FF FF BA 06 00 00 00 E8 ?? ?? ?? ?? 8D 85 64 FF FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D0 8B 45 F4 80 7D F3 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "EDBEngineError.Destroy"
		size = 83
		refs = "0004 @BeforeDestruction 0022 TList.Get 0027 TObject.Free 0040 Exception.Destroy 004b @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 18 85 C0 74 26 8B 78 08 4F 83 FF 00 7C 15 8B 46 18 8B D7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4F 83 FF FF 75 EB 8B 46 18 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "EDBEngineError.GetError"
		size = 19
		refs = "000c TList.Get"
		altNames = "TUpdateTree.GetDetail"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "EDBEngineError.GetErrorCount"
		size = 7
		altNames = "TDBXConnectionBuilder.GetConnectionProperties TUpdateTree.GetDetailCount"
	strings:
		$1 = { 8B 40 18 8B 40 08 C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "TSessionList.Create"
		size = 100
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TThreadList 0023 TThreadList.Create 002d _Dn_TBits 003c _Dn_TObject 0046 FCSect 0051 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "TSessionList.Destroy"
		size = 69
		refs = "0003 @BeforeDestruction 000e TSessionList.CloseAll 0013 FCSect 0018 TObject.Free 0033 TObject.Destroy 003e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "TSessionList.AddSession"
		size = 91
		refs = "0011 TThreadList.LockList 0019 TSessionList.AddSession 0030 TList.Add 004b TMonitor.Exit 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 78 08 00 75 04 C6 43 55 01 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5B 59 5D C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "TSessionList.CloseAll"
		size = 105
		refs = "0010 TThreadList.LockList 001a TSessionList.CloseAll 0032 TList.Get 0037 TObject.Free 0058 TMonitor.Exit 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5E 08 4B 83 FB 00 7C 14 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4B 83 FB FF 75 EC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "TSessionList.GetCount"
		size = 82
		refs = "0010 TThreadList.LockList 0018 TSessionList.GetCount 003f TMonitor.Exit 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 08 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "TSessionList.GetCurrentSession"
		size = 156
		refs = "0013 TThreadList.LockList 001d TSessionList.GetCurrentSession 002c DbiGetCurrSession 0031 Check 0045 TList.Get 004a TSession.GetHandle 0060 @TryFinallyExit 0086 TMonitor.Exit 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 45 FC 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 77 08 4E 85 F6 7C 2D 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 45 F4 75 13 8B D3 8B C7 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? EB 2C 43 4E 75 D6 33 C0 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "TSessionList.GetSession"
		size = 96
		refs = "0014 TThreadList.LockList 001e TSessionList.GetSession 002d TList.Get 004b TMonitor.Exit 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 8B F2 89 45 FC 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 F8 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "TSessionList.GetSessionByName"
		size = 132
		refs = "0015 TSessionList.GetSessionByName 0025 Session 0030 TSessionList.FindSession 0040 SInvalidSessionName 0045 LoadResString 005b DatabaseErrorFmt 0070 @UStrClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 75 08 8B 35 ?? ?? ?? ?? EB 0B 8B D3 8B C6 E8 ?? ?? ?? ?? 8B F0 85 F6 75 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 5D F4 C6 45 F8 11 8D 55 F4 33 C9 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "TSessionList.FindSession"
		size = 160
		refs = "0016 Session 0026 TThreadList.LockList 0030 TSessionList.FindSession 004a TList.Get 005b AnsiCompareText 0064 @TryFinallyExit 008a TMonitor.Exit 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 F8 89 45 FC 83 7D F8 00 75 0A A1 ?? ?? ?? ?? 89 45 F4 EB 77 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 85 DB 7C 2C 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 8B 40 5C 8B 55 F8 E8 ?? ?? ?? ?? 85 C0 75 07 E8 ?? ?? ?? ?? EB 2C 46 4B 75 D7 33 C0 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "TSessionList.GetSessionNames"
		size = 185
		refs = "0013 TStrings.BeginUpdate 001b TSessionList.GetSessionNames 0034 TThreadList.LockList 005d TList.Get 0089 TMonitor.Exit 008f @HandleFinally 00a6 TStrings.EndUpdate"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 F8 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 44 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 58 08 4B 85 DB 7C 1E 43 33 F6 8B D6 8B 45 F4 E8 ?? ?? ?? ?? 8B F8 8B 57 5C 8B 45 F8 8B 08 FF 51 38 46 4B 75 E5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 40 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "TSessionList.OpenSession"
		size = 56
		refs = "0007 TSessionList.FindSession 0016 _DV_TSession 001b TSession.Create 0026 TSession.SetSessionName 002f TSession.SetActive"
	strings:
		$1 = { 53 56 8B F2 8B D6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 19 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "TSessionList.SetCurrentSession"
		size = 19
		refs = "0008 DbiSetCurrSession 000d Check"
	strings:
		$1 = { 53 8B DA 8B 43 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "TSession.Create"
		size = 130
		refs = "000b @ClassCreate 001c TSession.ValidateAutoSession 0027 TComponent.Create 002e _Dn_TList 0033 TObject.Create 0054 Sessions 0059 TSessionList.AddSession 006e @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C9 8B D6 8B C7 E8 ?? ?? ?? ?? 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 3C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 40 C6 47 54 01 C6 47 56 01 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 47 74 33 C0 89 47 38 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "TSession.Destroy"
		size = 78
		refs = "0003 @BeforeDestruction 0010 TSession.SetActive 0015 Sessions 0021 TThreadList.RemoveItem 002c TComponent.Destroy 0034 TObject.Free 0047 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 8B D6 33 C9 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 46 3C E8 ?? ?? ?? ?? 8B 46 40 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TSession.AddAlias"
		size = 44
		refs = "0013 TSession.GetConfigMode 0021 TSession.InternalAddAlias"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 50 6A 01 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "TSession.AddDriver"
		size = 296
		refs = "001e TSession.AddDriver 002e StringListToParams 0036 TSession.LockSession 004c TSession.GetConfigMode 006f TSession.CheckConfigMode 0079 @LStrToPChar 008a @LStrFromUStr 0095 StrToOem 00a5 DbiAddDriver 00aa Check 00c3 TSession.SetConfigMode 00c9 @HandleFinally 00e0 TSession.UnlockSession 00f5 TSession.DBNotification 010f @LStrArrayClr 0117 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 DB 89 5D EC 89 5D E8 89 5D FC 8B D9 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 88 45 F3 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 6A FF 8B 45 FC E8 ?? ?? ?? ?? 50 8D 45 E8 8B 55 F4 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 F3 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8D 4D F4 B2 06 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TSession.AddDatabase"
		size = 32
		refs = "000e TList.Add 0019 TSession.DBNotification"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B 14 24 8B 43 3C E8 ?? ?? ?? ?? 8B CC B2 02 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "TSession.AddStandardAlias"
		size = 392
		refs = "001b TSession.AddStandardAlias 0028 _Dn_TStringList 002d TStringList.Create 0067 Format 00bb TSession.AddAlias 00d0 TObject.Free 00d6 @HandleFinally 00ed @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 B8 ?? ?? ?? ?? 89 45 E8 C6 45 EC 11 89 7D F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 51 38 8D 45 E4 50 B8 ?? ?? ?? ?? 89 45 E8 C6 45 EC 11 8B 45 08 89 45 F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 8B 45 FC 8B 08 FF 51 38 8B 45 FC 50 B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 50 00 41 00 54 00 48 00 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 B0 04 02 00 FF FF FF FF 0E 00 00 00 44 00 45 00 46 00 41 00 55 00 4C 00 54 00 20 00 44 00 52 00 49 00 56 00 45 00 52 00 00 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 53 00 54 00 41 00 4E 00 44 00 41 00 52 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TSession.AddPassword"
		size = 110
		refs = "0013 TSession.LockSession 001b TSession.AddPassword 003d AnsiToNative 0043 DbiAddPassword 0048 Check 005d TSession.UnlockSession 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 23 68 FF 00 00 00 8D 8D FC FE FF FF 8B 45 FC 8B 40 44 8B D3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TSession.CallBDEInitProcs"
		size = 58
		refs = "0008 BDEInitProcs 0027 TList.Get"
	strings:
		$1 = { 53 56 57 55 8B F8 83 3D ?? ?? ?? ?? 00 74 26 A1 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 19 43 33 F6 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B C7 FF D5 46 4B 75 EA 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "TSession.CheckInactive"
		size = 89
		refs = "000c TSession.CheckInactive 0019 TSession.GetActive 0025 SSessionActive 002a LoadResString 0034 DatabaseError 0049 @UStrClr 004f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "TSession.CheckConfigMode"
		size = 52
		refs = "000a TSession.CheckConfigMode 0024 TSession.SetConfigMode"
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 05 ?? ?? ?? ?? 3A 04 24 75 0A 0F B6 05 ?? ?? ?? ?? 88 04 24 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 00 07 00 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "TSession.Close"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_69408_0 {
	meta:
		name = "InitializePackage"
		size = 8
		refs = "0003 InitializePackage"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_69411_0 {
	meta:
		name = "LoadPackage"
		size = 8
		refs = "0003 LoadPackage"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71422_0 {
	meta:
		name = "TAbstractSocket.Close"
		size = 8
		refs = "0003 TAbstractSocket.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_79891_0 {
	meta:
		name = "TApplication.NormalizeTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94135_0 {
	meta:
		name = "TChartAxes.Hide"
		size = 8
		refs = "0003 TChartAxes.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_93538_0 {
	meta:
		name = "TChartAxis.Hide"
		size = 8
		refs = "0003 TChartAxis.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_91178_0 {
	meta:
		name = "TChartPen.Hide"
		size = 8
		refs = "0003 TChartPen.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94919_0 {
	meta:
		name = "TChartShape.DrawLegendShape"
		size = 8
		refs = "0003 TChartShape.DrawShape"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90202_0 {
	meta:
		name = "TChartTitle.Clear"
		size = 8
		refs = "0003 TChartTitle.SetCaption"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90207_0 {
	meta:
		name = "TChartWalls.Hide"
		size = 8
		refs = "0003 TChartWalls.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63112_0 {
	meta:
		name = "TClassList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62198_0 {
	meta:
		name = "TCollectionItem.SetDisplayName"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63098_0 {
	meta:
		name = "TComponentList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_76353_0 {
	meta:
		name = "TControl.Hide"
		size = 8
		refs = "0003 TControl.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15049_0 {
	meta:
		name = "TCustomADODataSet.InternalDelete"
		size = 8
		refs = "0003 DoRecordsetDelete"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1586_0 {
	meta:
		name = "TCustomBindScope.UpdateDataChanging"
		size = 8
		refs = "0003 TCustomBindScope.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_79749_0 {
	meta:
		name = "TCustomForm.Hide"
		size = 8
		refs = "0003 TCustomForm.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_82132_0 {
	meta:
		name = "TCustomMaskEdit.Clear"
		size = 8
		refs = "0003 TCustomMaskEdit.SetText"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94108_0 {
	meta:
		name = "TCustomSeriesList.First"
		size = 8
		refs = "0003 TCustomSeriesList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94680_0 {
	meta:
		name = "TCustomTeePanel.PrintPortrait"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95457_0 {
	meta:
		name = "TCustomWebBrowserChangeManager.Undo"
		size = 8
		refs = "0003 TCustomWebBrowserChangeManager.ExecChange"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65937_0 {
	meta:
		name = "TDirectory.CheckGetDirectoryRootParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65944_0 {
	meta:
		name = "TDirectory.CheckGetParentParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65961_0 {
	meta:
		name = "TDirectory.Delete"
		size = 8
		refs = "0003 TDirectory.Delete"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66035_0 {
	meta:
		name = "TFile.CheckAppendTextParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66037_0 {
	meta:
		name = "TFile.CheckCreateParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66038_0 {
	meta:
		name = "TFile.CheckCreateTextParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66040_0 {
	meta:
		name = "TFile.CheckDeleteParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66050_0 {
	meta:
		name = "TFile.CheckOpenParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66065_0 {
	meta:
		name = "TFile.CheckWriteAllBytesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66070_0 {
	meta:
		name = "TFile.Create"
		size = 8
		refs = "0003 TFile.Create"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_93021_0 {
	meta:
		name = "TFiltersEditor.ChangedProperties"
		size = 8
		refs = "0003 TFiltersEditor.Preview"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95687_0 {
	meta:
		name = "THTMLTableColumn.TitleChanged"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31425_0 {
	meta:
		name = "TIBQuery.UnPrepare"
		size = 8
		refs = "0003 TIBQuery.SetPrepared"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31955_0 {
	meta:
		name = "TIBStoredProc.UnPrepare"
		size = 8
		refs = "0003 TIBStoredProc.SetPrepared"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43645_0 {
	meta:
		name = "TIWEdit.Clear"
		size = 8
		refs = "0003 TControl.SetText"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35626_0 {
	meta:
		name = "TIdIPAddrMon.ForceCheck"
		size = 8
		refs = "0003 TIdIPAddrMon.CheckAdapters"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62107_0 {
	meta:
		name = "TList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28550_0 {
	meta:
		name = "TList<DSAzureBlob.TBBlob>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBBlob>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28772_0 {
	meta:
		name = "TList<DSAzureBlob.TBBlock>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBBlock>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28426_0 {
	meta:
		name = "TList<DSAzureBlob.TBContainer>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBContainer>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28715_0 {
	meta:
		name = "TList<DSAzureBlob.TBPageRange>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBPageRange>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28658_0 {
	meta:
		name = "TList<DSAzureBlob.TBSignedIdentifier>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBSignedIdentifier>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28605_0 {
	meta:
		name = "TList<DSAzureBlob.TLeaseItem>.First"
		size = 8
		refs = "0003 TList<DSAzureBlob.TLeaseItem>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29073_0 {
	meta:
		name = "TList<DSAzureQueue.TMessageNodeData>.First"
		size = 8
		refs = "0003 TList<DSAzureQueue.TMessageNodeData>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29491_0 {
	meta:
		name = "TList<DSAzureTableDialog.TAzureTableColumn>.First"
		size = 8
		refs = "0003 TList<DSAzureTableDialog.TAzureTableColumn>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29346_0 {
	meta:
		name = "TList<DSAzureTableDialog.TAzureTableRow>.First"
		size = 8
		refs = "0003 TList<DSAzureTableDialog.TAzureTableRow>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3053_0 {
	meta:
		name = "TList<Data.Bind.Components.TBasicBindComponent>.First"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TBasicBindComponent>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2284_0 {
	meta:
		name = "TList<Data.Bind.Components.TBindEditorFactoryClass>.First"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TBindEditorFactoryClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2057_0 {
	meta:
		name = "TList<Data.Bind.Components.TContainedBindComponent>.First"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TContainedBindComponent>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2758_0 {
	meta:
		name = "TList<Data.Bind.DBLinks.TBindDBColumnFactoryClass>.First"
		size = 8
		refs = "0003 TList<Data.Bind.DBLinks.TBindDBColumnFactoryClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3100_0 {
	meta:
		name = "TList<Data.Bind.DBScope.TBaseDataLink>.First"
		size = 8
		refs = "0003 TList<Data.Bind.DBScope.TBaseDataLink>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4680_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureBlob>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureBlob>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4578_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureContainer>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureContainer>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4629_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TSignedIdentifier>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TSignedIdentifier>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4425_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudQueueMessage>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudQueueMessage>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4056_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudTableColumn>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudTableColumn>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4374_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudTableRow>.First"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudTableRow>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16400_0 {
	meta:
		name = "TList<Data.DBXCommon.TDBXParameter>.First"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TDBXParameter>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7898_0 {
	meta:
		name = "TList<Data.DBXCommon.TDBXScheduler.TDBXSchedulerRec>.First"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TDBXScheduler.TDBXSchedulerRec>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25134_0 {
	meta:
		name = "TList<Data.DBXCommon.TResultCommandHandler>.First"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TResultCommandHandler>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10375_0 {
	meta:
		name = "TList<Data.DBXJSON.TJSONAncestor>.First"
		size = 8
		refs = "0003 TList<Data.DBXJSON.TJSONAncestor>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10328_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TConverterEvent>.First"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TConverterEvent>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23933_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TReverterEvent>.First"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TReverterEvent>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11107_0 {
	meta:
		name = "TList<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler>.First"
		size = 8
		refs = "0003 TList<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16282_0 {
	meta:
		name = "TList<Datasnap.DSClientRest.TDSRestClientCallback>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSClientRest.TDSRestClientCallback>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17402_0 {
	meta:
		name = "TList<Datasnap.DSHTTP.TDSHTTPClass>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTP.TDSHTTPClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18396_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSCallbackItem>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSCallbackItem>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18088_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSCommandComplexParams>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSCommandComplexParams>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17766_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSExecutionResponse>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSExecutionResponse>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23735_0 {
	meta:
		name = "TList<Datasnap.DSServer.TDSCallbackTunnel>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TDSCallbackTunnel>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24509_0 {
	meta:
		name = "TList<Datasnap.DSService.TDBXRequestFilter>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TDBXRequestFilter>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11389_0 {
	meta:
		name = "TList<Datasnap.DSService.TDSSession>.First"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TDSSession>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29700_0 {
	meta:
		name = "TList<GraphView.TGraphEdge>.First"
		size = 8
		refs = "0003 TList<GraphView.TGraphEdge>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29810_0 {
	meta:
		name = "TList<GraphView.TGraphNode>.First"
		size = 8
		refs = "0003 TList<GraphView.TGraphNode>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29755_0 {
	meta:
		name = "TList<GraphView.TObjectList<GraphView.TGraphEdge>>.First"
		size = 8
		refs = "0003 TList<GraphView.TObjectList<GraphView.TGraphEdge>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30572_0 {
	meta:
		name = "TList<IBDatabase.TIBBase>.First"
		size = 8
		refs = "0003 TList<IBDatabase.TIBBase>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30674_0 {
	meta:
		name = "TList<IBDatabase.TIBDatabase>.First"
		size = 8
		refs = "0003 TList<IBDatabase.TIBDatabase>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30623_0 {
	meta:
		name = "TList<IBDatabase.TIBTransaction>.First"
		size = 8
		refs = "0003 TList<IBDatabase.TIBTransaction>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_42992_0 {
	meta:
		name = "TList<IPPeerAPI.TDictionary<System.TGUID,System.TClass>>.First"
		size = 8
		refs = "0003 TList<IPPeerAPI.TDictionary<System.TGUID,System.TClass>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40338_0 {
	meta:
		name = "TList<IdContext.TIdContext>.First"
		size = 8
		refs = "0003 TList<IdContext.TIdContext>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54633_0 {
	meta:
		name = "TList<System.Bindings.CustomScope.TScopeClass>.First"
		size = 8
		refs = "0003 TList<System.Bindings.CustomScope.TScopeClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52593_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TOverload>.First"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TOverload>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2006_0 {
	meta:
		name = "TList<System.Bindings.Expression.TBindingExpression>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Expression.TBindingExpression>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56118_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.IInterface,System.Pointer>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.IInterface,System.Pointer>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55830_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.string,System.Int64>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.string,System.Int64>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56261_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.string,System.Integer>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.string,System.Integer>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57051_0 {
	meta:
		name = "TList<System.Bindings.Manager.TBindingManager>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Manager.TBindingManager>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58612_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58465_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58224_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60757_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>.First"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64890_0 {
	meta:
		name = "TList<System.Boolean>.First"
		size = 8
		refs = "0003 TList<System.Boolean>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86473_0 {
	meta:
		name = "TList<System.Classes.TComponent>.First"
		size = 8
		refs = "0003 TList<System.Classes.TComponent>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15904_0 {
	meta:
		name = "TList<System.Classes.TStream>.First"
		size = 8
		refs = "0003 TList<System.Classes.TStream>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24029_0 {
	meta:
		name = "TList<System.Classes.TStrings>.First"
		size = 8
		refs = "0003 TList<System.Classes.TStrings>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63635_0 {
	meta:
		name = "TList<System.DateUtils.TLocalTimeZone.TYearlyChanges>.First"
		size = 8
		refs = "0003 TList<System.DateUtils.TLocalTimeZone.TYearlyChanges>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24564_0 {
	meta:
		name = "TList<System.Integer>.First"
		size = 8
		refs = "0003 TList<System.Integer>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22944_0 {
	meta:
		name = "TList<System.Masks.TMask>.First"
		size = 8
		refs = "0003 TList<System.Masks.TMask>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51194_0 {
	meta:
		name = "TList<System.Pointer>.First"
		size = 8
		refs = "0003 TList<System.Pointer>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68008_0 {
	meta:
		name = "TList<System.Rtti.TRttiField>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiField>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68060_0 {
	meta:
		name = "TList<System.Rtti.TRttiManagedField>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiManagedField>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67955_0 {
	meta:
		name = "TList<System.Rtti.TRttiMethod>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiMethod>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68218_0 {
	meta:
		name = "TList<System.Rtti.TRttiObject>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiObject>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67903_0 {
	meta:
		name = "TList<System.Rtti.TRttiProperty>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiProperty>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67568_0 {
	meta:
		name = "TList<System.Rtti.TVirtualInterface.TImplInfo>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TVirtualInterface.TImplInfo>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67513_0 {
	meta:
		name = "TList<System.Rtti.TVirtualMethodInterceptor.TInterceptInfo>.First"
		size = 8
		refs = "0003 TList<System.Rtti.TVirtualMethodInterceptor.TInterceptInfo>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54586_0 {
	meta:
		name = "TList<System.TClass>.First"
		size = 8
		refs = "0003 TList<System.TClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67846_0 {
	meta:
		name = "TList<System.TCustomAttribute>.First"
		size = 8
		refs = "0003 TList<System.TCustomAttribute>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54178_0 {
	meta:
		name = "TList<System.TObject>.First"
		size = 8
		refs = "0003 TList<System.TObject>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68336_0 {
	meta:
		name = "TList<System.TypInfo.PTypeInfo>.First"
		size = 8
		refs = "0003 TList<System.TypInfo.PTypeInfo>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63588_0 {
	meta:
		name = "TList<System.Word>.First"
		size = 8
		refs = "0003 TList<System.Word>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88864_0 {
	meta:
		name = "TList<Vcl.Controls.TControl>.First"
		size = 8
		refs = "0003 TList<Vcl.Controls.TControl>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89269_0 {
	meta:
		name = "TList<Vcl.Controls.TCustomGestureCollectionItem>.First"
		size = 8
		refs = "0003 TList<Vcl.Controls.TCustomGestureCollectionItem>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88746_0 {
	meta:
		name = "TList<Vcl.Controls.TCustomGestureManager>.First"
		size = 8
		refs = "0003 TList<Vcl.Controls.TCustomGestureManager>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_78606_0 {
	meta:
		name = "TList<Vcl.Direct2D.TDirect2DGraphicsObject>.First"
		size = 8
		refs = "0003 TList<Vcl.Direct2D.TDirect2DGraphicsObject>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86669_0 {
	meta:
		name = "TList<Vcl.Styles.TList<Vcl.Themes.TStyleHookClass>>.First"
		size = 8
		refs = "0003 TList<Vcl.Styles.TList<Vcl.Themes.TStyleHookClass>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87640_0 {
	meta:
		name = "TList<Vcl.Themes.TCustomStyleEngineClass>.First"
		size = 8
		refs = "0003 TList<Vcl.Themes.TCustomStyleEngineClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87691_0 {
	meta:
		name = "TList<Vcl.Themes.TCustomStyleServices>.First"
		size = 8
		refs = "0003 TList<Vcl.Themes.TCustomStyleServices>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87891_0 {
	meta:
		name = "TList<Vcl.Themes.TList<Vcl.Themes.TStyleHookClass>>.First"
		size = 8
		refs = "0003 TList<Vcl.Themes.TList<Vcl.Themes.TStyleHookClass>>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86520_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleHook>.First"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleHook>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86303_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleHookClass>.First"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleHookClass>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89017_0 {
	meta:
		name = "TList<Vcl.Touch.GestureMgr.TGestureCollection>.First"
		size = 8
		refs = "0003 TList<Vcl.Touch.GestureMgr.TGestureCollection>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89500_0 {
	meta:
		name = "TList<Vcl.Touch.Keyboard.TCustomKeyboardButton>.First"
		size = 8
		refs = "0003 TList<Vcl.Touch.Keyboard.TCustomKeyboardButton>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89884_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TVirtualKeyLayout>.First"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TVirtualKeyLayout>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89782_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TVirtualKeys>.First"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TVirtualKeys>.GetItem"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50742_0 {
	meta:
		name = "TLogDetailFrame.Clear"
		size = 8
		refs = "0003 TLogDetailFrame.SetText"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64273_0 {
	meta:
		name = "TMonitor.TSpinLock.Exit"
		size = 8
		refs = "0003 InterlockedExchange"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63081_0 {
	meta:
		name = "TObjectList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_82952_0 {
	meta:
		name = "TOutlineNode.Collapse"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_78728_0 {
	meta:
		name = "TPreviousTab.ExecuteTarget"
		size = 8
		refs = "0003 TTabAction.SelectNextTab"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62471_0 {
	meta:
		name = "TReader.ReadListEnd"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14427_0 {
	meta:
		name = "TSQLConnection.BeginTransaction"
		size = 8
		refs = "0003 TSQLConnection.BeginTransaction"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_79851_0 {
	meta:
		name = "TScreen.Realign"
		size = 8
		refs = "0003 TScreen.AlignForm"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94418_0 {
	meta:
		name = "TSeriesGroup.Show"
		size = 8
		refs = "0003 TSeriesGroup.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68800_0 {
	meta:
		name = "TSpinLock.TryEnter"
		size = 8
		refs = "0003 TSpinLock.TryEnter"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94763_0 {
	meta:
		name = "TTeeCustomShapeBrushPen.Hide"
		size = 8
		refs = "0003 TTeeCustomShapeBrushPen.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62700_0 {
	meta:
		name = "TThread.Start"
		size = 8
		refs = "0003 TThread.InternalStart"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83980_0 {
	meta:
		name = "TTimerSpeedButton.CMMouseleave"
		size = 8
		refs = "0003 TTimerSpeedButton.SetMouseInControl"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74688_0 {
	meta:
		name = "TTreeNode.GetCut"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50826_0 {
	meta:
		name = "TWebAppDbgMainForm.HideActionExecute"
		size = 8
		refs = "0003 TCustomForm.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50806_0 {
	meta:
		name = "TWebAppDbgMainForm.StopActionExecute"
		size = 8
		refs = "0003 TWebAppDbgMainForm.SetServerActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_76759_0 {
	meta:
		name = "TWinControl.DoPaddingChange"
		size = 8
		refs = "0003 TWinControl.AlignControl"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_76521_0 {
	meta:
		name = "TWinControl.Realign"
		size = 8
		refs = "0003 TWinControl.AlignControl"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62539_0 {
	meta:
		name = "TWriter.WriteListEnd"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "TSession.CloseDatabase"
		size = 50
		refs = "001e TCustomConnection.Close 002d TObject.Free"
	strings:
		$1 = { 83 7A 7C 00 74 03 FF 4A 7C 83 7A 7C 00 75 22 80 7A 71 00 75 1C 80 7A 72 00 75 09 8B C2 E8 ?? ?? ?? ?? EB 0D F6 42 1C 08 75 07 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "TSession.CloseDatabaseHandle"
		size = 98
		refs = "0024 TList.Get 0044 AnsiCompareText 0058 DbiCloseDatabase"
	strings:
		$1 = { 53 56 57 55 51 8B FA 89 04 24 8B 04 24 8B 40 3C 8B 70 08 4E 85 F6 7C 38 46 33 ED 8B 04 24 8B 40 3C 8B D5 E8 ?? ?? ?? ?? 8B D8 3B FB 74 1E 83 BB 80 00 00 00 00 74 15 8B 97 98 00 00 00 8B 83 98 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 10 45 4E 75 CB 8D 87 80 00 00 00 50 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "TSession.DBLoginCallback"
		size = 544
		refs = "0019 TSession.DBLoginCallback 005d @UStrFromArray 0068 TSession.OpenDatabase 0093 TSession.CloseDatabase 00a6 _Dn_TStringList 00ab TStringList.Create 00da TSession.GetAliasParams 00ea TStrings.GetValue 00ff TObject.Free 0105 @HandleFinally 010f @UStrClr 0114 LoginDialogExProc 015c AnsiToNative 018a TSession.FindDatabase 01b5 @HandleAnyException 01c1 @DoneExcept 01db @UStrArrayClr"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 F0 04 00 00 00 89 55 E8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 E8 83 78 4C 00 0F 85 2B 01 00 00 8B 45 F4 80 78 5A 00 75 52 8D 45 E4 8B 55 E8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F4 E8 ?? ?? ?? ?? 80 78 79 00 75 1B 8B 80 80 00 00 00 8B 55 E8 89 42 4C 8B 45 E8 C7 40 48 FF FF FF FF E9 1D 01 00 00 8B D0 8B 45 F4 E8 ?? ?? ?? ?? C7 45 F0 02 00 00 00 E9 07 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E0 8B 55 E8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 E0 8B 4D EC 8B 45 F4 E8 ?? ?? ?? ?? 8D 4D FC BA ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8D 45 F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 0F 84 89 00 00 00 6A 01 8D 45 DC 8B 55 E8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 45 DC 8B 1D ?? ?? ?? ?? 8B 1B 8D 4D F8 8D 55 FC FF D3 84 C0 74 20 6A 1F 8B 45 E8 8D 48 28 8B 45 F4 8B 40 44 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 E8 33 D2 89 50 48 EB 40 C7 45 F0 02 00 00 00 EB 37 8D 45 D8 8B 55 E8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 D8 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 74 18 8B 55 E8 8B 52 4C 3B 90 80 00 00 00 75 0A 8B D0 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? C7 45 F0 02 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 8B 45 F0 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 55 00 53 00 45 00 52 00 20 00 4E 00 41 00 4D 00 45 00 00 00 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "TIdCustomTCPServer.DoDisconnect"
		size = 27
		altNames = "TInCustomTCPServer.DoDisconnect TSession.DBNotification"
	strings:
		$1 = { 53 66 83 B8 DA 00 00 00 00 74 0E 8B D8 8B 83 DC 00 00 00 FF 93 D8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "TSession.DeleteAlias"
		size = 29
		refs = "000b TSession.GetConfigMode 0016 TSession.InternalDeleteAlias"
	strings:
		$1 = { 53 56 8B F2 8B D8 6A 01 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "TSession.DeleteDriver"
		size = 181
		refs = "0018 TSession.DeleteDriver 002b TSession.DBNotification 0033 TSession.LockSession 0053 @LStrFromUStr 005e StrToOem 0066 @LStrToPChar 006e DbiDeleteDriver 0083 TSession.UnlockSession 0089 @HandleFinally 00a5 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 33 C9 89 4D F4 89 4D F0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 B2 07 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8D 45 F0 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B E5 5D C3 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "TSession.DeleteConfigPath"
		size = 152
		refs = "0018 TSession.DeleteConfigPath 0035 Format 0045 @LStrFromUStr 004d @LStrToPChar 0057 DbiCfgPosition 0064 DbiCfgDropRecord 0069 Check 007e @LStrClr 0086 @UStrClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 DB 89 5D F0 89 5D FC 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 89 75 F4 C6 45 F8 11 8D 55 F4 33 C9 8B C3 E8 ?? ?? ?? ?? 8D 45 F0 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B D8 53 6A 00 E8 ?? ?? ?? ?? 66 85 C0 75 0D 53 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "TSession.DropConnections"
		size = 52
		refs = "0016 TList.Get 0027 TObject.Free"
	strings:
		$1 = { 53 56 8B F0 8B 46 3C 8B 58 08 4B 83 FB 00 7C 21 8B 46 3C 8B D3 E8 ?? ?? ?? ?? 80 78 72 00 74 0B 83 78 7C 00 75 05 E8 ?? ?? ?? ?? 4B 83 FB FF 75 DF 5E 5B C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "TSession.FindDatabase"
		size = 83
		refs = "001e TList.Get 003d AnsiCompareText"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B E8 8B 45 3C 8B 70 08 4E 85 F6 7C 34 46 33 FF 8B 45 3C 8B D7 E8 ?? ?? ?? ?? 8B D8 83 BB 98 00 00 00 00 75 06 80 7B 72 00 74 12 8B 83 98 00 00 00 8B 14 24 E8 ?? ?? ?? ?? 85 C0 74 06 47 4E 75 CF 33 DB 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "TSession.DoFindDatabase"
		size = 107
		refs = "002b TList.Get 004a AnsiCompareText 005c TSession.FindDatabase"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 89 14 24 8B F8 83 7C 24 04 00 74 3F 8B 47 3C 8B 70 08 4E 85 F6 7C 34 46 33 ED 8B 47 3C 8B D5 E8 ?? ?? ?? ?? 8B D8 8B 43 04 3B 44 24 04 75 18 80 7B 79 00 74 12 8B 83 98 00 00 00 8B 14 24 E8 ?? ?? ?? ?? 85 C0 74 10 45 4E 75 CF 8B 14 24 8B C7 E8 ?? ?? ?? ?? 8B D8 8B C3 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "TSession.FindDatabaseHandle"
		size = 89
		refs = "001e TList.Get 0037 AnsiCompareText"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B E8 8B 45 3C 8B 70 08 4E 85 F6 7C 3C 46 33 FF 8B 45 3C 8B D7 E8 ?? ?? ?? ?? 8B D8 83 BB 80 00 00 00 00 74 20 8B 14 24 8B 83 98 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 0E 80 7B 79 00 74 08 8B 83 80 00 00 00 EB 06 47 4E 75 C7 33 C0 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "TCanvas.HandleAllocated"
		size = 8
		altNames = "TControl.HasParent TCustomScreenTipsManager.HasLinkedActionLists TDSConnectionMetaDataProvider.HasProvider TDSRestMetaDataProvider.HasProvider TDSServerMetaDataProvider.HasProvider TSession.GetActive"
	strings:
		$1 = { 83 78 38 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "TSession.GetAliasDriverName"
		size = 311
		refs = "002a TSession.GetAliasDriverName 0038 TSession.LockSession 005f @LStrFromUStr 0070 StrToOem 007b @LStrToPChar 0081 DbiGetDatabaseDesc 0093 SInvalidAliasName 0098 LoadResString 00ba DatabaseErrorFmt 00cf TSession.UnlockSession 00d5 @HandleFinally 00ee OemToCharA 00fe @UStrFromArray 0116 @UStrClr 0126 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 81 C4 7C FE FF FF 53 33 DB 89 9D 84 FE FF FF 89 9D 8C FE FF FF 89 9D 88 FE FF FF 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 93 FE FF FF 50 8D 85 88 FE FF FF 8B D3 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 88 FE FF FF 8D 95 8C FE FF FF E8 ?? ?? ?? ?? 8B 85 8C FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 74 34 6A 00 8D 95 84 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 84 FE FF FF 50 89 9D 7C FE FF FF C6 85 80 FE FF FF 11 8D 95 7C FE FF FF 33 C9 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D F7 00 74 04 C6 45 F7 00 8D 45 D8 50 8D 45 D8 50 E8 ?? ?? ?? ?? 8B 45 F8 8D 55 D8 B9 20 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 84 FE FF FF E8 ?? ?? ?? ?? 8D 85 88 FE FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "TSession.GetAliasNames"
		size = 323
		refs = "001b TSession.GetAliasNames 0029 TStrings.BeginUpdate 0047 TSession.LockSession 005e DbiOpenDatabaseList 0063 Check 0078 TSession.UnlockSession 007e @HandleFinally 00a3 OemToCharA 00b9 @UStrFromArray 00db DbiGetNextRecord 00f6 DbiCloseCursor 0113 TStrings.EndUpdate 0133 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 88 FE FF FF 33 C9 89 8D 88 FE FF FF 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 44 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 37 8D 85 8F FE FF FF 50 8D 85 8F FE FF FF 50 E8 ?? ?? ?? ?? 8D 85 88 FE FF FF 8D 95 8F FE FF FF B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 95 88 FE FF FF 8B 45 F8 8B 08 FF 51 38 6A 00 8D 85 8F FE FF FF 50 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 66 85 C0 74 B0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 88 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B E5 5D C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "TSession.GetAliasParams"
		size = 564
		refs = "002a TSession.GetAliasParams 0038 TStrings.BeginUpdate 0060 @LStrFromUStr 0073 StrPLCopy 0080 CharToOemA 0088 TSession.LockSession 00a6 DbiGetDatabaseDesc 00ab Check 00c0 TSession.UnlockSession 00c6 @HandleFinally 00df StrIComp 00fa @UStrFromArray 010d TSession.GetConfigParams 011c TStrings.SetValue 015d TStrings.EndUpdate 0182 @UStrArrayClr 018d @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 64 FE FF FF 53 33 DB 89 9D 64 FE FF FF 89 9D 68 FE FF FF 89 9D 6C FE FF FF 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 44 8D 85 6C FE FF FF 8B D3 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 95 6C FE FF FF 8D 45 D8 B9 1F 00 00 00 E8 ?? ?? ?? ?? 8D 45 D8 50 8D 45 D8 50 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 73 FE FF FF 50 8D 45 D8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D D7 00 74 04 C6 45 D7 00 BA ?? ?? ?? ?? 8D 45 B8 E8 ?? ?? ?? ?? 85 C0 75 3B 8B 45 F8 50 8D 85 68 FE FF FF 8D 55 D8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 8D 68 FE FF FF BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C9 BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? EB 2A 8B 45 F8 50 8D 85 64 FE FF FF 8D 55 D8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 8D 64 FE FF FF BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 64 FE FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 85 6C FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5B 8B E5 5D C3 00 00 53 54 41 4E 44 41 52 44 00 00 00 00 B0 04 02 00 FF FF FF FF 15 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 49 00 4E 00 46 00 4F 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 54 00 59 00 50 00 45 00 00 00 00 00 B0 04 02 00 FF FF FF FF 15 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 4F 00 50 00 45 00 4E 00 00 00 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "TSession.GetConfigParams"
		size = 448
		refs = "002a TSession.GetConfigParams 0038 TSession.LockSession 006d Format 0083 @LStrFromUStr 008e @LStrToPChar 009a DbiOpenCfgInfoList 009f Check 00b4 TSession.UnlockSession 00ba @HandleFinally 00df OemToCharA 0143 DbiGetNextRecord 015e DbiCloseCursor 017e @UStrClr 0194 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 B0 FE FF FF 53 56 33 DB 89 9D C0 FE FF FF 89 9D D0 FE FF FF 89 9D CC FE FF FF 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 8D 85 CC FE FF FF 50 89 B5 C4 FE FF FF C6 85 C8 FE FF FF 11 8D 95 C4 FE FF FF 33 C9 8B C3 E8 ?? ?? ?? ?? 8B 95 CC FE FF FF 8D 85 D0 FE FF FF B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 D0 FE FF FF E8 ?? ?? ?? ?? 50 6A 00 6A 01 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 63 8D 85 76 FF FF FF 50 8D 85 76 FF FF FF 50 E8 ?? ?? ?? ?? 8D 85 C0 FE FF FF 50 8D 85 D4 FE FF FF 89 85 B0 FE FF FF C6 85 B4 FE FF FF 06 8D 85 76 FF FF FF 89 85 B8 FE FF FF C6 85 BC FE FF FF 06 8D 95 B0 FE FF FF B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 C0 FE FF FF 8B 45 08 8B 08 FF 51 38 6A 00 8D 85 D4 FE FF FF 50 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 66 85 C0 74 84 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 C0 FE FF FF E8 ?? ?? ?? ?? 8D 85 CC FE FF FF E8 ?? ?? ?? ?? 8D 85 D0 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D7 5E 5B 8B E5 5D C2 04 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "TAppletApplication.GetModules"
		size = 19
		refs = "000c TList.Get"
		altNames = "TCustomConnection.GetDataSet TSession.GetDatabase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 3C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17177_0 {
	meta:
		name = "TDSCustomHTTPServiceFileDispatcher.GetRootDirectory"
		size = 19
		refs = "000c TWebFileDispatcherProperties.GetRootDirectory"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 3C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "TAppletApplication.GetModuleCount"
		size = 7
		altNames = "TCustomConnection.GetDataSetCount TIBTransaction.GetDatabaseCount TSession.GetDatabaseCount TTeeCustomShape.GetShadowColor"
	strings:
		$1 = { 8B 40 3C 8B 40 08 C3 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "TSession.GetDatabaseNames"
		size = 177
		refs = "0012 _Dn_TStringList 0017 TStringList.Create 0022 TSession.GetDatabaseNames 0032 TStringList.SetSorted 003d TSession.GetAliasNames 005b TList.Get 0068 IsDirectory 009e TObject.Free 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 F8 89 45 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C 8B 70 08 4E 85 F6 7C 33 46 33 FF 8B 45 FC 8B 40 3C 8B D7 E8 ?? ?? ?? ?? 8B D8 8B 83 98 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0E 8B 93 98 00 00 00 8B 45 F4 8B 08 FF 51 38 47 4E 75 D0 8B 55 F4 8B 45 F8 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "TSession.GetDriverNames"
		size = 356
		refs = "0015 TSession.GetDriverNames 0023 TStrings.BeginUpdate 004e TSession.LockSession 0065 DbiOpenDriverList 006a Check 007f TSession.UnlockSession 0085 @HandleFinally 009f IsStandardType 00b0 OemToCharA 00c0 @UStrFromArray 00dc DbiGetNextRecord 00f7 DbiCloseCursor 0114 TStrings.EndUpdate 0131 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 D0 33 C9 89 4D D0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 44 BA ?? ?? ?? ?? 8B 45 F8 8B 08 FF 51 38 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 34 8D 45 D4 E8 ?? ?? ?? ?? 84 C0 75 28 8D 45 D4 50 8D 45 D4 50 E8 ?? ?? ?? ?? 8D 45 D0 8D 55 D4 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 D0 8B 45 F8 8B 08 FF 51 38 6A 00 8D 45 D4 50 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 66 85 C0 74 B6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 53 00 54 00 41 00 4E 00 44 00 41 00 52 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "TSession.GetDriverParams"
		size = 696
		refs = "0027 TSession.GetDriverParams 0035 TStrings.BeginUpdate 0057 CompareText 007e Format 0110 @LStrFromUStr 011b StrToOem 0126 @UStrFromLStr 0135 TSession.GetConfigParams 014a TStrings.EndUpdate 0150 @HandleFinally 016c @LStrArrayClr 0179 @UStrArrayClr 0181 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 33 DB 89 5D D4 89 5D D0 89 5D CC 89 5D D8 89 5D EC 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 44 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 85 9E 00 00 00 8D 45 F8 50 B8 ?? ?? ?? ?? 89 45 F0 C6 45 F4 11 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 51 38 8D 45 EC 50 B8 ?? ?? ?? ?? 89 45 DC C6 45 E0 11 B8 ?? ?? ?? ?? 89 45 E4 C6 45 E8 11 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8B 45 FC 8B 08 FF 51 38 8D 45 D8 50 B8 ?? ?? ?? ?? 89 45 DC C6 45 E0 11 B8 ?? ?? ?? ?? 89 45 E4 C6 45 E8 11 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 D8 8B 45 FC 8B 08 FF 51 38 EB 38 8B 45 FC 50 8D 45 CC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 CC 8D 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 8D 45 D4 E8 ?? ?? ?? ?? 8B 4D D4 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CE 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 08 00 00 00 53 00 54 00 41 00 4E 00 44 00 41 00 52 00 44 00 00 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 50 00 41 00 54 00 48 00 00 00 00 00 B0 04 02 00 FF FF FF FF 03 00 00 00 25 00 73 00 3D 00 00 00 B0 04 02 00 FF FF FF FF 0E 00 00 00 44 00 45 00 46 00 41 00 55 00 4C 00 54 00 20 00 44 00 52 00 49 00 56 00 45 00 52 00 00 00 00 00 B0 04 02 00 FF FF FF FF 07 00 00 00 50 00 41 00 52 00 41 00 44 00 4F 00 58 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 B0 04 02 00 FF FF FF FF 0A 00 00 00 45 00 4E 00 41 00 42 00 4C 00 45 00 20 00 42 00 43 00 44 00 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 46 00 41 00 4C 00 53 00 45 00 00 00 B0 04 02 00 FF FF FF FF 13 00 00 00 5C 00 44 00 52 00 49 00 56 00 45 00 52 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 4F 00 50 00 45 00 4E 00 00 00 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "TSession.GetHandle"
		size = 39
		refs = "000d DbiSetCurrSession 0012 Check 001d TSession.SetActive"
	strings:
		$1 = { 53 56 8B D8 8B 73 38 85 F6 74 0D 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 09 B2 01 8B C3 E8 ?? ?? ?? ?? 8B 43 38 5E 5B C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "TSession.GetNetFileDir"
		size = 245
		refs = "001b TSession.GetNetFileDir 0029 TSession.GetActive 003e TSession.LockSession 006d DbiGetProp 0072 Check 0087 TSession.UnlockSession 008d @HandleFinally 009f NativeToAnsi 00af @UStrAsg 00bf AnsiUpperCaseFileName 00e5 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 33 C9 89 8D EC FE FF FF 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 74 8B 45 FC F6 40 1C 04 75 6B 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F6 50 68 05 01 00 00 8D 85 F1 FE FF FF 50 68 02 00 02 00 8B 45 FC 8B 40 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 4D F8 8D 95 F1 FE FF FF 33 C0 E8 ?? ?? ?? ?? EB 0E 8B 45 F8 8B 55 FC 8B 52 64 E8 ?? ?? ?? ?? 8D 95 EC FE FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8B 95 EC FE FF FF 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 EC FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B E5 5D C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "TSession.GetPrivateDir"
		size = 224
		refs = "001b TSession.GetPrivateDir 0029 TSession.GetActive 003e TSession.LockSession 0058 DbiGetSesInfo 005d Check 0072 TSession.UnlockSession 0078 @HandleFinally 008a NativeToAnsi 009a @UStrAsg 00aa AnsiUpperCaseFileName 00d0 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 C0 FD FF FF 33 C9 89 8D C0 FD FF FF 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 5F 8B 45 FC F6 40 1C 04 75 56 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 C6 FD FF FF 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 4D F8 8D 95 F3 FE FF FF 33 C0 E8 ?? ?? ?? ?? EB 0E 8B 45 F8 8B 55 FC 8B 52 68 E8 ?? ?? ?? ?? 8D 95 C0 FD FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8B 95 C0 FD FF FF 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 C0 FD FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B E5 5D C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "TSession.GetPassword"
		size = 172
		refs = "0012 TSession.GetPassword 003e PasswordDialog 0059 @IntfCast 0084 @IntfClear 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB CA 00 00 00 00 74 17 C6 45 FF 00 8D 4D FF 8B D3 8B 83 CC 00 00 00 FF 93 C8 00 00 00 EB 36 A1 ?? ?? ?? ?? 83 38 00 74 28 8D 45 F8 8B D3 85 D2 74 03 83 EA CC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 1D ?? ?? ?? ?? 8B 1B FF D3 88 45 FF EB 04 C6 45 FF 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 0F B6 45 FF 5B 59 59 5D C3 00 00 00 FB 48 24 CC 72 B6 A2 4B 93 F7 77 CB ED A8 15 FE }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "TSession.GetTableNames"
		size = 452
		refs = "0026 TSession.GetTableNames 0034 TStrings.BeginUpdate 0055 TSession.OpenDatabase 0087 AnsiToNative 00a7 DbiOpenTableList 00ac Check 00d9 StrCat 00fb NativeToAnsi 0109 @UStrFromLStr 012b DbiGetNextRecord 0146 DbiCloseCursor 014c @HandleFinally 0166 TSession.CloseDatabase 0183 TStrings.EndUpdate 01a3 @UStrClr 01ab @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 A4 FC FF FF 53 56 57 33 DB 89 9D A4 FC FF FF 89 5D FC 8B F9 89 55 F4 89 45 F8 8B 5D 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 10 FF 52 44 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 85 FF 74 1D 68 04 01 00 00 8D 8D E7 FE FF FF 8B 45 F0 8B 80 84 00 00 00 8B D7 E8 ?? ?? ?? ?? 8B F0 8D 45 EC 50 56 80 7D 0C 01 F5 1B C0 50 6A 00 8B 45 F0 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 5B 84 DB 74 24 80 BD B3 FE FF FF 00 74 1B BA ?? ?? ?? ?? 8D 85 A9 FC FF FF E8 ?? ?? ?? ?? 8D 95 B3 FE FF FF E8 ?? ?? ?? ?? 8D 4D FC 8D 95 A9 FC FF FF 8B 45 F0 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8D 85 A4 FC FF FF 8B 55 FC E8 ?? ?? ?? ?? 8B 95 A4 FC FF FF 8B 45 08 8B 08 FF 51 38 6A 00 8D 85 A9 FC FF FF 50 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 66 85 C0 74 8C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F0 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 A4 FC FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5F 5E 5B 8B E5 5D C2 0C 00 2E 00 00 00 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "TSession.GetFieldNames"
		size = 380
		refs = "001e TSession.GetFieldNames 002c TStrings.BeginUpdate 004c TSession.OpenDatabase 0077 @LStrFromUStr 007f @LStrToPChar 008f DbiOpenFieldList 0094 Check 00b8 NativeToAnsi 00c3 @UStrFromLStr 00df DbiGetNextRecord 00fa DbiCloseCursor 0100 @HandleFinally 011a TSession.CloseDatabase 0137 TStrings.EndUpdate 0154 @UStrClr 015c @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 A8 53 56 33 DB 89 5D A8 89 5D AC 89 5D FC 8B F1 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 10 FF 52 44 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 50 6A 00 68 ?? ?? ?? ?? 8D 45 AC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 AC E8 ?? ?? ?? ?? 50 8B 45 F4 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 2A 8D 4D FC 8D 55 B4 8B 45 F4 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8D 45 A8 8B 55 FC E8 ?? ?? ?? ?? 8B 55 A8 8B 45 08 8B 08 FF 51 38 6A 00 8D 45 B2 50 6A 00 8B 45 F0 50 E8 ?? ?? ?? ?? 66 85 C0 74 C0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 A8 E8 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C2 04 00 00 00 00 00 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "TSession.GetStoredProcNames"
		size = 337
		refs = "001b TSession.GetStoredProcNames 0029 TStrings.BeginUpdate 0049 TSession.OpenDatabase 0073 DbiOpenSPList 0078 Check 009c NativeToAnsi 00a7 @UStrFromLStr 00c3 DbiGetNextRecord 00de DbiCloseCursor 00e4 @HandleFinally 00fe TSession.CloseDatabase 011b TStrings.EndUpdate 0138 @UStrClr 0140 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 9C 53 33 DB 89 5D 9C 89 5D FC 89 4D F4 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 10 FF 52 44 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC 50 6A 00 6A FF 6A 00 8B 45 F0 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 2A 8D 4D FC 8D 55 A3 8B 45 F0 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8D 45 9C 8B 55 FC E8 ?? ?? ?? ?? 8B 55 9C 8B 45 F4 8B 08 FF 51 38 6A 00 8D 45 A3 50 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 66 85 C0 74 C0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F0 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 9C E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "TSession.InitializeBDE"
		size = 404
		refs = "001e TSession.InitializeBDE 0029 GetCurrentThreadId 002f MainThreadID 0038 DBScreen 0080 @FillChar 008b SIDAPILangID 0090 LoadResString 00a6 @LStrFromUStr 00b9 StrPLCopy 00c5 DbiInit 00d5 Check 00de DbiGetCurrSession 00f0 DbiGetObjFromName 00fa GDAL 0109 DbiSetProp 010e IsLibrary 0118 DLLDetachCallBack 0127 DbiRegisterCallBack 015e @HandleFinally 0178 @UStrClr 0183 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 A4 FD FF FF 53 33 D2 89 95 A8 FD FF FF 89 95 A4 FD FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 75 10 A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 0C 84 C0 74 04 33 C0 EB 02 B0 01 88 45 FB 80 7D FB 00 74 0E A1 ?? ?? ?? ?? 8B 00 B2 01 8B 08 FF 51 10 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 85 AF FD FF FF 33 C9 BA 4C 02 00 00 E8 ?? ?? ?? ?? 8D 95 A4 FD FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 A4 FD FF FF 8D 85 A8 FD FF FF B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 95 A8 FD FF FF 8D 45 BB B9 1F 00 00 00 E8 ?? ?? ?? ?? 8D 85 AF FD FF FF 50 E8 ?? ?? ?? ?? 66 85 C0 74 0B 66 3D 07 2A 74 05 E8 ?? ?? ?? ?? 8D 43 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC 50 6A 00 6A 07 E8 ?? ?? ?? ?? 66 85 C0 75 14 E8 ?? ?? ?? ?? 50 68 02 00 07 FF 8B 45 FC 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 14 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 1D 6A 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D FB 00 74 1E A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 0C 3C 01 75 0E A1 ?? ?? ?? ?? 8B 00 33 D2 8B 08 FF 51 10 C3 E9 ?? ?? ?? ?? EB D4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 A4 FD FF FF E8 ?? ?? ?? ?? 8D 85 A8 FD FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "TSession.InternalAddAlias"
		size = 516
		refs = "0024 TSession.InternalAddAlias 0034 StringListToParams 0043 TStrings.GetValue 0055 CompareText 0066 @UStrLAsg 007a TSession.LockSession 0090 TSession.GetConfigMode 00ad TSession.CheckConfigMode 00b7 @LStrToPChar 00c8 @LStrFromUStr 00d3 StrToOem 0107 DbiAddAlias 010c Check 012b TSession.SetConfigMode 0131 @HandleFinally 0148 TSession.UnlockSession 015d TSession.DBNotification 0177 @LStrArrayClr 017f @UStrClr 0187 @LStrClr"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 8B F1 89 55 F0 89 45 F4 8B 5D 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 75 29 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0F 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 88 45 EF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 55 0C 8B 45 F4 E8 ?? ?? ?? ?? 6A FF 8B 45 FC E8 ?? ?? ?? ?? 50 8D 45 E4 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 50 8D 45 DC 8B 55 F0 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 DC 8D 55 E0 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D 08 00 74 0C 0F B6 55 EF 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8D 4D F0 B2 04 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5E 5B 8B E5 5D C2 0C 00 00 B0 04 02 00 FF FF FF FF 0E 00 00 00 44 00 45 00 46 00 41 00 55 00 4C 00 54 00 20 00 44 00 52 00 49 00 56 00 45 00 52 00 00 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 53 00 54 00 41 00 4E 00 44 00 41 00 52 00 44 00 00 00 00 00 B0 04 02 00 FF FF FF FF 07 00 00 00 50 00 41 00 52 00 41 00 44 00 4F 00 58 00 00 00 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "TSession.InternalDeleteAlias"
		size = 324
		refs = "001f TSession.InternalDeleteAlias 0032 TSession.DBNotification 003a TSession.LockSession 0050 TSession.GetConfigMode 006d TSession.CheckConfigMode 007d @LStrFromUStr 0088 StrToOem 0093 @UStrFromLStr 00a3 TSession.DeleteConfigPath 00c2 TSession.SetConfigMode 00c8 @HandleFinally 00df TSession.UnlockSession 0101 @LStrArrayClr 0109 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 DB 89 5D F0 89 5D EC 89 5D E8 88 4D F7 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 B2 05 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 88 45 F6 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 55 F7 8B 45 FC E8 ?? ?? ?? ?? 8D 45 E8 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 8B 4D F0 BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D 08 00 74 0C 0F B6 55 F6 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C2 04 00 B0 04 02 00 FF FF FF FF 0D 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "TSession.IsAlias"
		size = 296
		refs = "001e TSession.IsAlias 002c TSession.LockSession 0051 @LStrFromUStr 005c StrToOem 0075 Format 008d @LStrToPChar 0095 DbiCfgPosition 00b8 TSession.UnlockSession 00be @HandleFinally 00da @LStrArrayClr 00e2 @UStrClr 00ea @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 33 C9 89 4D F4 89 4D F0 89 4D E4 89 4D E0 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 5C 8D 45 F0 50 8D 45 E0 8B D3 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E0 8D 55 E4 E8 ?? ?? ?? ?? 8B 45 E4 89 45 E8 C6 45 EC 0B 8D 55 E8 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 66 85 C0 74 04 33 C0 EB 02 B0 01 88 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 FB 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 0D 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "TSession.Loaded"
		size = 118
		refs = "000e TComponent.Loaded 0016 TSession.Loaded 002d TSession.SetSessionNames 0040 TSession.SetActive 004f @HandleAnyException 0060 ApplicationHandleException 0067 @RaiseAgain 006c @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 57 00 74 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 78 53 00 74 0A B2 01 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 8B 45 FC F6 40 1C 10 74 0A 8B 45 FC E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "TSession.LockSession"
		size = 55
		refs = "000c FCSect 0011 TMonitor.CheckMonitorSupport 0018 TMonitor.GetMonitor 0020 TMonitor.Enter 002a TSession.MakeCurrent"
	strings:
		$1 = { 53 56 8B D8 83 7B 70 00 75 27 8B 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? FF 43 70 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 FF 43 70 5E 5B C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "TSession.UnlockSession"
		size = 20
		refs = "000a FCSect 000f TMonitor.Exit"
	strings:
		$1 = { FF 48 70 83 78 70 00 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "TSession.MakeCurrent"
		size = 37
		refs = "000d DbiSetCurrSession 0012 Check 001e TSession.SetActive"
	strings:
		$1 = { 53 56 8B D8 8B 73 38 85 F6 74 0E 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 B2 01 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "TSession.ModifyAlias"
		size = 476
		refs = "001e @UStrAddRef 0026 TSession.ModifyAlias 0034 TSession.LockSession 004a TSession.GetConfigMode 006d TSession.CheckConfigMode 007b TSession.GetAliasDriverName 008b @LStrFromUStr 0096 StrToOem 00a1 @UStrFromLStr 00b2 TSession.ModifyConfigParams 00bf CompareText 00ed TSession.SetConfigMode 00f3 @HandleFinally 010a TSession.UnlockSession 012c @LStrArrayClr 0139 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 8B D9 89 55 FC 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 E8 ?? ?? ?? ?? 88 45 EF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B 45 F0 E8 ?? ?? ?? ?? 8D 4D F8 8B 55 FC 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 E4 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F4 E8 ?? ?? ?? ?? 53 8B 4D F4 BA ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 74 11 53 8B 4D F4 BA ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 EF 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 15 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 49 00 4E 00 46 00 4F 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 53 00 54 00 41 00 4E 00 44 00 41 00 52 00 44 00 00 00 00 00 B0 04 02 00 FF FF FF FF 15 00 00 00 5C 00 44 00 41 00 54 00 41 00 42 00 41 00 53 00 45 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 4F 00 50 00 45 00 4E 00 00 00 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "TSession.ModifyDriver"
		size = 516
		refs = "001e @UStrAddRef 0026 TSession.ModifyDriver 0034 TSession.LockSession 004a TSession.GetConfigMode 006d TSession.CheckConfigMode 007d @LStrFromUStr 0088 StrToOem 0093 @UStrFromLStr 00a4 TSession.ModifyConfigParams 00bc @LStrToPChar 00c1 IsStandardType 0102 TSession.SetConfigMode 0108 @HandleFinally 011f TSession.UnlockSession 0141 @LStrArrayClr 014e @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 8B D9 89 55 FC 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 88 45 F3 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 8B 45 F4 E8 ?? ?? ?? ?? 8D 45 E8 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F8 E8 ?? ?? ?? ?? 53 8B 4D F8 BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8D 45 E4 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 13 53 8B 4D F8 BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? EB 11 53 8B 4D F8 BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 F3 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 10 00 00 00 5C 00 44 00 52 00 49 00 56 00 45 00 52 00 53 00 5C 00 25 00 73 00 5C 00 49 00 4E 00 49 00 54 00 00 00 00 00 B0 04 02 00 FF FF FF FF 18 00 00 00 5C 00 44 00 52 00 49 00 56 00 45 00 52 00 53 00 5C 00 25 00 73 00 5C 00 54 00 41 00 42 00 4C 00 45 00 20 00 43 00 52 00 45 00 41 00 54 00 45 00 00 00 00 00 B0 04 02 00 FF FF FF FF 13 00 00 00 5C 00 44 00 52 00 49 00 56 00 45 00 52 00 53 00 5C 00 25 00 73 00 5C 00 44 00 42 00 20 00 4F 00 50 00 45 00 4E 00 00 00 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "TSession.ModifyConfigParams"
		size = 270
		refs = "001d TSession.ModifyConfigParams 002a _Dn_TStringList 002f TStringList.Create 0052 TSession.GetConfigParams 0077 TStrings.GetName 00c3 TSession.SetConfigParams 00d8 TObject.Free 00de @HandleFinally 00fa @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 33 DB 89 5D E0 89 5D E4 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 50 8B 4D F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F0 8B 45 EC 8B 10 FF 52 14 48 85 C0 7C 47 40 89 45 E8 33 DB 8D 4D E4 8B D3 8B 45 EC E8 ?? ?? ?? ?? 8B 55 E4 8B 45 08 8B 08 FF 51 58 8B F0 85 F6 7C 1D 8D 4D E0 8B D6 8B 45 08 8B 30 FF 56 0C 8B 4D E0 8B D3 8B 45 EC 8B 30 FF 56 20 FF 45 F0 43 FF 4D E8 75 BF 83 7D F0 00 7E 12 8B 45 EC 50 8B 4D F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "TSession.Notification"
		size = 90
		refs = "0010 TComponent.Notification 0022 _DV_TDBDataSet 0027 @IsClass 0039 @UStrAsg 0043 _DV_TDatabase"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 7F 57 00 74 3C 84 DB 75 38 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 8D 86 4C 02 00 00 8B 57 5C E8 ?? ?? ?? ?? EB 17 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 89 BE 88 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "TSession.Open"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_79472_0 {
	meta:
		name = "DirectoryExists"
		size = 8
		refs = "0003 DirectoryExists"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_34499_0 {
	meta:
		name = "IndyDirectoryExists"
		size = 8
		refs = "0003 DirectoryExists"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71421_0 {
	meta:
		name = "TAbstractSocket.Open"
		size = 8
		refs = "0003 TAbstractSocket.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_79892_0 {
	meta:
		name = "TApplication.NormalizeAllTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28177_0 {
	meta:
		name = "TAzureBlobManagement.ActivateAction"
		size = 8
		refs = "0003 TAzureBlobManagement.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28970_0 {
	meta:
		name = "TAzureQueueManagement.ActivateAction"
		size = 8
		refs = "0003 TAzureQueueManagement.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29110_0 {
	meta:
		name = "TAzureTableManagement.ActivateAction"
		size = 8
		refs = "0003 TAzureTableManagement.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_91179_0 {
	meta:
		name = "TChartPen.Show"
		size = 8
		refs = "0003 TChartPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90208_0 {
	meta:
		name = "TChartWalls.Show"
		size = 8
		refs = "0003 TChartWalls.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_73181_0 {
	meta:
		name = "TCustomAddRemoveItem.SetEnabled"
		size = 8
		refs = "0003 TControl.SetEnabled"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_26311_0 {
	meta:
		name = "TCustomDataSetAdapter.RestoreDefaultAdapterMode"
		size = 8
		refs = "0003 TCustomDataSetAdapter.SetInDefaultMode"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83520_0 {
	meta:
		name = "TCustomRibbonGroup.SetAutoSizing"
		size = 8
		refs = "0003 TCustomActionBar.SetAutoSizing"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94681_0 {
	meta:
		name = "TCustomTeePanel.PrintLandscape"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95455_0 {
	meta:
		name = "TCustomWebBrowserChangeManager.Redo"
		size = 8
		refs = "0003 TCustomWebBrowserChangeManager.ExecChange"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65933_0 {
	meta:
		name = "TDirectory.CheckGetAttributesParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65934_0 {
	meta:
		name = "TDirectory.CheckGetCreationTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65935_0 {
	meta:
		name = "TDirectory.CheckGetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65940_0 {
	meta:
		name = "TDirectory.CheckGetLastAccessTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65941_0 {
	meta:
		name = "TDirectory.CheckGetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65942_0 {
	meta:
		name = "TDirectory.CheckGetLastWriteTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65943_0 {
	meta:
		name = "TDirectory.CheckGetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65948_0 {
	meta:
		name = "TDirectory.CheckSetAttributesParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65949_0 {
	meta:
		name = "TDirectory.CheckSetCreationTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65950_0 {
	meta:
		name = "TDirectory.CheckSetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65951_0 {
	meta:
		name = "TDirectory.CheckSetCurrentDirectoryParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65952_0 {
	meta:
		name = "TDirectory.CheckSetLastAccessTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65953_0 {
	meta:
		name = "TDirectory.CheckSetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65954_0 {
	meta:
		name = "TDirectory.CheckSetLastWriteTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65955_0 {
	meta:
		name = "TDirectory.CheckSetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66039_0 {
	meta:
		name = "TFile.CheckDecryptParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66041_0 {
	meta:
		name = "TFile.CheckEncryptParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66042_0 {
	meta:
		name = "TFile.CheckGetAttributesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66043_0 {
	meta:
		name = "TFile.CheckGetCreationTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66044_0 {
	meta:
		name = "TFile.CheckGetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66045_0 {
	meta:
		name = "TFile.CheckGetLastAccessTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66046_0 {
	meta:
		name = "TFile.CheckGetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66047_0 {
	meta:
		name = "TFile.CheckGetLastWriteTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66048_0 {
	meta:
		name = "TFile.CheckGetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66051_0 {
	meta:
		name = "TFile.CheckOpenReadParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66052_0 {
	meta:
		name = "TFile.CheckOpenTextParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66053_0 {
	meta:
		name = "TFile.CheckOpenWriteParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66054_0 {
	meta:
		name = "TFile.CheckReadAllBytesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66058_0 {
	meta:
		name = "TFile.CheckSetAttributesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66059_0 {
	meta:
		name = "TFile.CheckSetCreationTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66060_0 {
	meta:
		name = "TFile.CheckSetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66061_0 {
	meta:
		name = "TFile.CheckSetLastAccessTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66062_0 {
	meta:
		name = "TFile.CheckSetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66063_0 {
	meta:
		name = "TFile.CheckSetLastWriteTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66064_0 {
	meta:
		name = "TFile.CheckSetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_93033_0 {
	meta:
		name = "TFiltersEditor.ImageResize"
		size = 8
		refs = "0003 TFiltersEditor.Preview"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31424_0 {
	meta:
		name = "TIBQuery.Prepare"
		size = 8
		refs = "0003 TIBQuery.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31789_0 {
	meta:
		name = "TIBSQL.Close"
		size = 8
		refs = "0003 TIBSQL.InternalClose"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31799_0 {
	meta:
		name = "TIBSQL.FreeHandle"
		size = 8
		refs = "0003 TIBSQL.InternalFreeHandle"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31954_0 {
	meta:
		name = "TIBStoredProc.Prepare"
		size = 8
		refs = "0003 TIBStoredProc.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31736_0 {
	meta:
		name = "TIBXSQLVAR.Clear"
		size = 8
		refs = "0003 TIBXSQLVAR.SetIsNull"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_44083_0 {
	meta:
		name = "TIWCustomControl.RepaintControl"
		size = 8
		refs = "0003 TIWCustomControl.set_DoRefreshControl"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_73066_0 {
	meta:
		name = "TInternalMDIAction.UpdateTarget"
		size = 8
		refs = "0003 TCustomAction.SetEnabled"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_82951_0 {
	meta:
		name = "TOutlineNode.Expand"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_66175_0 {
	meta:
		name = "TPath.IsPathRooted"
		size = 8
		refs = "0003 TPath.DoIsPathRooted"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_882_0 {
	meta:
		name = "TQuery.CreateHandle"
		size = 8
		refs = "0003 TQuery.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62470_0 {
	meta:
		name = "TReader.ReadListBegin"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_78759_0 {
	meta:
		name = "TSendMail.UpdateTarget"
		size = 8
		refs = "0003 TCustomAction.SetEnabled"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94417_0 {
	meta:
		name = "TSeriesGroup.Hide"
		size = 8
		refs = "0003 TSeriesGroup.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9915_0 {
	meta:
		name = "TStack<Data.DBXJSON.TJSONAncestor>.Pop"
		size = 8
		refs = "0003 TStack<Data.DBXJSON.TJSONAncestor>.DoPop"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_829_0 {
	meta:
		name = "TStoredProc.CreateHandle"
		size = 8
		refs = "0003 TStoredProc.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94762_0 {
	meta:
		name = "TTeeCustomShapeBrushPen.Show"
		size = 8
		refs = "0003 TTeeCustomShapeBrushPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83979_0 {
	meta:
		name = "TTimerSpeedButton.CMMouseenter"
		size = 8
		refs = "0003 TTimerSpeedButton.SetMouseInControl"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74690_0 {
	meta:
		name = "TTreeNode.GetDropTarget"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50808_0 {
	meta:
		name = "TWebAppDbgMainForm.StartActionExecute"
		size = 8
		refs = "0003 TWebAppDbgMainForm.SetServerActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62538_0 {
	meta:
		name = "TWriter.WriteListBegin"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_70510_0 {
	meta:
		name = "VarIsArray"
		size = 8
		refs = "0003 VarIsArray"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "TSession.DoOpenDatabase"
		size = 225
		refs = "0019 TSession.LockSession 0021 TSession.DoOpenDatabase 0046 TSession.DoFindDatabase 0059 _DV_TDatabase 005e TDatabase.Create 006b TDatabase.SetDatabaseName 007a TDatabase.SetKeepConnection 008f TCustomConnection.Open 00a4 @HandleAnyException 00ac TObject.Free 00b1 @RaiseAgain 00b6 @DoneExcept 00cb TSession.UnlockSession 00d1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B F1 8B DA 89 45 FC 33 C0 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 38 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 8B D3 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 FC 0F B6 50 54 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 C6 40 72 01 8B 45 F4 89 45 F8 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 FF 40 7C 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "TSession.OpenDatabase"
		size = 8
		refs = "0003 TSession.DoOpenDatabase"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64159_0 {
	meta:
		name = "@Write0Bool"
		size = 8
		refs = "0003 @WriteBool"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64164_0 {
	meta:
		name = "@Write0CString"
		size = 8
		refs = "0003 @WriteCString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64161_0 {
	meta:
		name = "@Write0Long"
		size = 8
		refs = "0003 @WriteLong"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64162_0 {
	meta:
		name = "@Write0String"
		size = 8
		refs = "0003 @WriteString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64168_0 {
	meta:
		name = "@Write0UString"
		size = 8
		refs = "0003 @WriteUString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64176_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94459_0 {
	meta:
		name = "AddFormTo"
		size = 8
		refs = "0003 AddFormTo"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_65845_0 {
	meta:
		name = "AnsiSetLength"
		size = 8
		refs = "0003 @LStrSetLength"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95047_0 {
	meta:
		name = "ConvertTeeFileToBinary"
		size = 8
		refs = "0003 ConvertTeeFile"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90577_0 {
	meta:
		name = "EditChart"
		size = 8
		refs = "0003 EditChartPage"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_91686_0 {
	meta:
		name = "SmoothStretch"
		size = 8
		refs = "0003 SmoothStretch"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5582_0 {
	meta:
		name = "TBCDField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80562_0 {
	meta:
		name = "TBitmap.SaveToStream"
		size = 8
		refs = "0003 TBitmap.WriteStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63110_0 {
	meta:
		name = "TClassList.Extract"
		size = 8
		refs = "0003 TList.ExtractItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63118_0 {
	meta:
		name = "TClassList.Remove"
		size = 8
		refs = "0003 TList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63096_0 {
	meta:
		name = "TComponentList.Extract"
		size = 8
		refs = "0003 TList.ExtractItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63106_0 {
	meta:
		name = "TComponentList.Remove"
		size = 8
		refs = "0003 TList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95649_0 {
	meta:
		name = "TCopyParser.SkipToken"
		size = 8
		refs = "0003 TCopyParser.SkipToNextToken"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15405_0 {
	meta:
		name = "TCustomClientDataSet.SetIndexName"
		size = 8
		refs = "0003 TCustomClientDataSet.SetIndex"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90518_0 {
	meta:
		name = "TCustomDBChart.DataSourceCheckDataSet"
		size = 8
		refs = "0003 TCustomDBChart.CheckDataSet"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83058_0 {
	meta:
		name = "TCustomOutline.LoadFromFile"
		size = 8
		refs = "0003 TCustomOutline.LoadFromFile"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83065_0 {
	meta:
		name = "TCustomOutline.LoadFromStream"
		size = 8
		refs = "0003 TCustomOutline.LoadFromStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83068_0 {
	meta:
		name = "TCustomOutline.SaveToFile"
		size = 8
		refs = "0003 TCustomOutline.SaveToFile"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_83070_0 {
	meta:
		name = "TCustomOutline.SaveToStream"
		size = 8
		refs = "0003 TCustomOutline.SaveToStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74860_0 {
	meta:
		name = "TCustomTreeView.LoadFromStream"
		size = 8
		refs = "0003 TCustomTreeView.LoadFromStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_74864_0 {
	meta:
		name = "TCustomTreeView.SaveToStream"
		size = 8
		refs = "0003 TCustomTreeView.SaveToStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12905_0 {
	meta:
		name = "TDBXSqlScanner.Init"
		size = 8
		refs = "0003 TDBXSqlScanner.Init"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24363_0 {
	meta:
		name = "TDSSessionManager.TerminateAllSessions"
		size = 8
		refs = "0003 TDSSessionManager.TerminateAllSessions"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TDatabase.SetDriverName"
		size = 8
		refs = "0003 TDatabase.SetDatabaseType"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5511_0 {
	meta:
		name = "TDateTimeField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5610_0 {
	meta:
		name = "TFMTBCDField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30176_0 {
	meta:
		name = "TIBStringField.SetAsString"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_32003_0 {
	meta:
		name = "TIBTable.SetIndexName"
		size = 8
		refs = "0003 TIBTable.SetIndex"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43157_0 {
	meta:
		name = "TIWApplication.TerminateAndRedirect"
		size = 8
		refs = "0003 TIWApplication.TerminateAndRedirect"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35736_0 {
	meta:
		name = "TIdIRC.CommandBOUNCE"
		size = 8
		refs = "0003 TIdIRC.DoBounce"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_32568_0 {
	meta:
		name = "TIdObjectList.Remove"
		size = 8
		refs = "0003 TList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80715_0 {
	meta:
		name = "TInplaceEdit.UpdateLoc"
		size = 8
		refs = "0003 TInplaceEdit.InternalMove"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62151_0 {
	meta:
		name = "TInterfaceList.IndexOf"
		size = 8
		refs = "0003 TInterfaceList.IndexOfItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62157_0 {
	meta:
		name = "TInterfaceList.Remove"
		size = 8
		refs = "0003 TInterfaceList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_48830_0 {
	meta:
		name = "TInvokableClassRegistry.RegisterInvokableClass"
		size = 8
		refs = "0003 TInvokableClassRegistry.RegisterInvokableClass"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62126_0 {
	meta:
		name = "TList.Extract"
		size = 8
		refs = "0003 TList.ExtractItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62117_0 {
	meta:
		name = "TList.Remove"
		size = 8
		refs = "0003 TList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63078_0 {
	meta:
		name = "TObjectList.Extract"
		size = 8
		refs = "0003 TList.ExtractItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63088_0 {
	meta:
		name = "TObjectList.Remove"
		size = 8
		refs = "0003 TList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14436_0 {
	meta:
		name = "TSQLConnection.RollbackFreeAndNil"
		size = 8
		refs = "0003 TSQLConnection.EndFreeAndNilTransaction"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5528_0 {
	meta:
		name = "TSQLTimeStampField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5529_0 {
	meta:
		name = "TSQLTimeStampField.SetAsSQLTimeStamp"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5542_0 {
	meta:
		name = "TSQLTimeStampOffsetField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5544_0 {
	meta:
		name = "TSQLTimeStampOffsetField.SetAsSQLTimeStampOffset"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62356_0 {
	meta:
		name = "TStream.WriteComponent"
		size = 8
		refs = "0003 TStream.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_81005_0 {
	meta:
		name = "TStringGrid.GetRows"
		size = 8
		refs = "0003 TStringGrid.EnsureColRow"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TTable.SetIndexName"
		size = 8
		refs = "0003 TTable.SetIndex"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "TTable.UnlockTable"
		size = 8
		refs = "0003 TTable.SetTableLock"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_92896_0 {
	meta:
		name = "TTeeExportFormat.SaveToFile"
		size = 8
		refs = "0003 TTeeExportFormat.SaveToFile"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62135_0 {
	meta:
		name = "TThreadList.Remove"
		size = 8
		refs = "0003 TThreadList.RemoveItem"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_62573_0 {
	meta:
		name = "TWriter.WriteRootComponent"
		size = 8
		refs = "0003 TWriter.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_109929_0 {
	meta:
		name = "ZeroMemory"
		size = 8
		refs = "0003 @FillChar"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TSession.SessionNameStored"
		size = 7
	strings:
		$1 = { 0F B6 40 57 34 01 C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "TSession.LoadSMClient"
		size = 612
		refs = "001a TSession.LoadSMClient 004a DbiGetCallBack 0077 OpenFileMapping 008e CloseHandle 009c DefaultSession 00af @IntfClear 00be Class_SMClient 00c4 CoCreateInstance 00e0 @IntfCopy 00f5 DBApplication 010a SUntitled 010f LoadResString 0145 Format 0150 @UStrLAsg 0155 TSession.SMClientSignal 0161 @UStrToPWChar 0184 @GetMem 019f TSession.SqlTraceCallback 01ab _DV_TBDECallback 01b0 TBDECallback.Create 01bd TList.Add 01e9 @HandleAnyException 01f5 @DoneExcept 020a @UStrClr 0218 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 33 C9 89 4D F0 89 4D FC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 83 78 48 00 75 21 8D 45 F4 50 6A 00 6A 00 6A 00 6A 1B 6A 00 E8 ?? ?? ?? ?? 66 85 C0 74 09 8B 45 F8 80 78 52 00 74 0D 33 C0 5A 59 59 64 89 10 E9 90 01 00 00 84 DB 75 25 68 ?? ?? ?? ?? 6A 00 6A 04 E8 ?? ?? ?? ?? 85 C0 75 0D 33 C0 5A 59 59 64 89 10 E9 6D 01 00 00 50 E8 ?? ?? ?? ?? 8B 45 F8 83 78 48 00 75 49 E8 ?? ?? ?? ?? 83 78 48 00 75 22 E8 ?? ?? ?? ?? 83 C0 48 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 01 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 F8 80 78 55 00 75 13 E8 ?? ?? ?? ?? 8B 50 48 8B 45 F8 83 C0 48 E8 ?? ?? ?? ?? 8B 45 F8 83 78 48 00 0F 84 ED 00 00 00 8D 55 FC A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 0C 83 7D FC 00 75 0D 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 80 78 55 00 75 38 8D 45 F0 50 8B 45 FC 89 45 E0 C6 45 E4 11 8B 45 F8 8B 40 5C 89 45 E8 C6 45 EC 11 8D 55 E0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F0 8D 45 FC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 F8 8B 40 38 50 8B 45 F8 8B 40 48 50 8B 00 FF 50 0C 66 85 C0 74 45 B8 06 80 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 F8 89 58 4C 6A 00 6A 1B 53 68 06 80 00 00 8B 45 F8 50 68 ?? ?? ?? ?? 6A 00 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 8B 40 40 E8 ?? ?? ?? ?? EB 0B 8B 45 F8 83 C0 48 E8 ?? ?? ?? ?? 8B 45 F8 83 78 48 00 0F 94 C0 8B 55 F8 88 42 52 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? 8B 45 F8 C6 40 52 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 00 00 53 00 4D 00 42 00 75 00 66 00 66 00 65 00 72 00 00 00 00 00 E1 79 98 CB 95 43 D0 11 9F FC 00 A0 24 8E 4B 9A B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 2E 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "TSession.RegisterCallbacks"
		size = 225
		refs = "000d GetCurrentThreadId 0013 MainThreadID 0031 TSession.ServerCallback 003c _DV_TBDECallback 0041 TBDECallback.Create 004b TList.Add 005b TSession.DBLoginCallback 008d TList.Get 0092 TObject.Free 00ae TSession.RegisterCallbacks 00bc @FreeMem 00c4 @IntfClear 00d3 @HandleAnyException 00d8 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D8 84 D2 74 6F E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 0F 85 BD 00 00 00 80 7B 56 00 74 2A 6A 00 6A 15 8D 43 6C 50 6A 04 53 68 ?? ?? ?? ?? 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 40 E8 ?? ?? ?? ?? 6A 00 6A 1C 8D 43 78 50 6A 50 53 68 ?? ?? ?? ?? 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 40 E8 ?? ?? ?? ?? EB 61 8B 43 40 8B 70 08 4E 83 FE 00 7C 15 8B 43 40 8B D6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4E 83 FE FF 75 EB 8B 43 40 8B 10 FF 52 08 83 7B 48 00 74 32 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 4C E8 ?? ?? ?? ?? 8D 43 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "TSession.RemoveDatabase"
		size = 34
		refs = "0010 TList.RemoveItem 001b TSession.DBNotification"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B 43 3C 8B 14 24 33 C9 E8 ?? ?? ?? ?? 8B CC B2 03 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "TSession.RemoveAllPasswords"
		size = 68
		refs = "000b TSession.LockSession 0013 TSession.RemoveAllPasswords 0020 DbiDropPassword 0035 TSession.UnlockSession 003b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "TSession.RemovePassword"
		size = 105
		refs = "0013 TSession.LockSession 001b TSession.RemovePassword 003d AnsiToNative 0043 DbiDropPassword 0058 TSession.UnlockSession 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 1E 68 FF 00 00 00 8D 8D FC FE FF FF 8B 45 FC 8B 40 44 8B D3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "TSession.SaveConfigFile"
		size = 108
		refs = "000d TSession.GetConfigMode 0018 TSession.SaveConfigFile 002d TSession.SetConfigMode 0038 DbiCfgSave 003d Check 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 15 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 6A FF 6A 00 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 FB 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 59 59 5D C3 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "TSession.ServerCallback"
		size = 118
		refs = "0007 GetCurrentThreadId 000d MainThreadID 001e TimerID 0026 TimerCallBack 002b SQLDelay 0035 SetTimer 0040 DBScreen 0068 GetTickCount 006d StartTime"
	strings:
		$1 = { 53 56 8B D8 33 F6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 75 5C 83 7B 6C 01 75 56 66 83 3D ?? ?? ?? ?? 00 75 1A 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? 66 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 74 1E A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 0C 3C 02 74 0E A1 ?? ?? ?? ?? 8B 00 B2 02 8B 08 FF 51 10 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "TSession.SetActive"
		size = 41
		refs = "0015 TSession.GetActive 0022 TSession.StartSession"
	strings:
		$1 = { 53 56 8B DA 8B F0 F6 46 1C 02 74 06 88 5E 53 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 3A D8 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "TSession.SetAutoSessionName"
		size = 308
		refs = "002b TSession.CheckInactive 003b TSession.ValidateAutoSession 004b FCSect 0050 TMonitor.CheckMonitorSupport 0057 TMonitor.GetMonitor 005f TMonitor.Enter 0067 TSession.SetAutoSessionName 0072 Sessions 007a TBits.OpenBit 0093 TBits.SetBit 00aa TMonitor.Exit 00b0 @HandleFinally 00ba TSession.UpdateAutoSessionName"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 88 55 FB 89 45 FC 8B 45 FC 0F B6 40 57 3A 45 FB 0F 84 12 01 00 00 80 7D FB 00 0F 84 99 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 50 04 B1 01 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 60 FF FF FF FF 8B 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 40 08 E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 58 60 8B D3 A1 ?? ?? ?? ?? 8B 40 08 B1 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 8B 45 FC E8 ?? ?? ?? ?? EB 65 8B 45 FC 83 78 60 FF 7E 5C 8B 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 60 A1 ?? ?? ?? ?? 8B 40 08 33 C9 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 8B 45 FC 0F B6 55 FB 88 50 57 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "TSession.GetConfigMode"
		size = 87
		refs = "000d TSession.LockSession 0015 TSession.GetConfigMode 002b GetIntProp 0043 TSession.UnlockSession 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 38 BA 0C 00 02 00 E8 ?? ?? ?? ?? 88 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 0F B6 45 FB 59 59 5D C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "TSession.SetConfigMode"
		size = 94
		refs = "0010 TSession.LockSession 0018 TSession.SetConfigMode 0034 DbiSetProp 0039 Check 004e TSession.UnlockSession 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 88 55 FB 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 45 FB 50 68 0C 00 02 00 8B 45 FC 8B 40 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "TSession.SetConfigParams"
		size = 222
		refs = "0018 TSession.SetConfigParams 0028 _DV_TParamList 002d TParamList.Create 006b Format 007b @LStrFromUStr 0083 @LStrToPChar 008b DbiCfgModifyRecord 0090 Check 00a5 TObject.Free 00ab @HandleFinally 00c2 @UStrClr 00ca @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 DB 89 5D F8 89 5D F4 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C 50 8B 45 FC 8B 40 08 50 8B 45 FC 0F B7 40 04 50 8D 45 F4 50 89 75 EC C6 45 F0 11 8D 55 EC 33 C9 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 8D 45 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "TSession.SetName"
		size = 25
		refs = "0006 TComponent.SetName 0013 TSession.UpdateAutoSessionName"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 7B 57 00 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "TSession.SetNetFileDir"
		size = 142
		refs = "0013 TSession.GetActive 001f TSession.LockSession 0027 TSession.SetNetFileDir 0042 AnsiToNative 0050 TSession.GetHandle 0056 DbiSetProp 005b Check 0070 TSession.UnlockSession 0076 @HandleFinally 0086 @UStrAsg"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 61 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 04 01 00 00 8D 8D F3 FE FF FF 8B 55 F8 33 C0 E8 ?? ?? ?? ?? 50 68 02 00 02 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 83 C0 64 8B 55 F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "TSession.SetPrivateDir"
		size = 128
		refs = "0013 TSession.GetActive 001f TSession.LockSession 0027 TSession.SetPrivateDir 0042 AnsiToNative 0048 DbiSetPrivateDir 004d Check 0062 TSession.UnlockSession 0068 @HandleFinally 0078 @UStrAsg"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 53 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 04 01 00 00 8D 8D F3 FE FF FF 8B 55 F8 33 C0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 83 C0 68 8B 55 F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "TSession.SetSessionName"
		size = 186
		refs = "0018 TSession.SetSessionName 0032 SAutoSessionActive 0037 LoadResString 0041 DatabaseError 0048 TSession.CheckInactive 0053 Sessions 0058 TSessionList.FindSession 0069 SDuplicateSessionName 0084 DatabaseErrorFmt 008e @UStrAsg 00a8 @UStrArrayClr 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 57 00 74 1D 80 7B 58 00 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 F6 74 38 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 28 3B D8 74 24 53 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 89 75 F0 C6 45 F4 11 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 8D 43 5C 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "TSession.SetSessionNames"
		size = 143
		refs = "0010 TComponent.GetComponentCount 0024 TComponent.GetComponent 002e _DV_TDBDataSet 0033 @IsClass 0045 AnsiCompareText 0053 TDBDataSet.SetSessionName 005d _DV_TDatabase 0082 TDatabase.SetSessionName"
	strings:
		$1 = { 53 56 57 55 8B F0 8B 5E 04 85 DB 74 7D 8B C3 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 6F 47 33 ED 8B D5 8B 46 04 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B 83 4C 02 00 00 8B 56 5C E8 ?? ?? ?? ?? 85 C0 74 0C 8B 56 5C 8B C3 E8 ?? ?? ?? ?? EB 2D 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B 83 94 00 00 00 8B 56 5C E8 ?? ?? ?? ?? 85 C0 74 0A 8B 56 5C 8B C3 E8 ?? ?? ?? ?? 45 4F 75 94 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "TSession.SetTraceFlags"
		size = 58
		refs = "0023 TList.Get 002c TDatabase.SetTraceFlags"
	strings:
		$1 = { 53 56 51 66 89 14 24 8B F0 0F B7 04 24 66 89 46 50 8B 46 3C 8B 58 08 4B 83 FB 00 7C 19 8B D3 8B 46 3C E8 ?? ?? ?? ?? 0F B7 56 50 E8 ?? ?? ?? ?? 4B 83 FB FF 75 E7 5A 5E 5B C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "TSession.SMClientSignal"
		size = 8
		refs = "0003 TSession.SetTraceFlags"
	strings:
		$1 = { 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_45478_0 {
	meta:
		name = "TFormIWMain.OnDebugLogBytes"
		size = 8
		refs = "0003 TFormIWMain.LogBytes"
	strings:
		$1 = { 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "TSession.SqlTraceCallback"
		size = 96
		refs = "000e TSession.SqlTraceCallback 001e @PCharLen 003b @HandleAnyException 004a TSession.SetTraceFlags 004f @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8D 5A 06 8B C3 E8 ?? ?? ?? ?? 50 53 8B 45 FC 8B 40 48 50 8B 00 FF 50 10 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5F 5E 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "TSession.StartSession"
		size = 588
		refs = "0017 TSession.StartSession 0023 FCSect 0028 TMonitor.CheckMonitorSupport 002f TMonitor.GetMonitor 0037 TMonitor.Enter 007d SSessionNameMissing 0082 LoadResString 008d DatabaseError 0092 DefaultSession 00a3 TSession.SetActive 00b4 TSession.InitializeBDE 00c6 DbiStartSession 00cb Check 00e3 TSession.RegisterCallbacks 00fa TSession.SetNetFileDir 0111 TSession.SetPrivateDir 0120 TSession.SetConfigMode 0128 TSession.CallBDEInitProcs 013a @HandleAnyException 0149 @RaiseAgain 014e @DoneExcept 015f DbiSetCurrSession 017b TList.Get 0186 TObject.Free 018d TCustomConnection.Close 01b4 IsLibrary 01c0 DLLDetachCallBack 01cd DbiRegisterCallBack 01d2 DbiDLLExit 01d7 DbiExit 01e5 DbiCloseSession 0217 TMonitor.Exit 021d @HandleFinally 0234 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 84 DB 0F 84 06 01 00 00 8B 45 FC 66 83 B8 D2 00 00 00 00 74 12 8B 5D FC 8B 55 FC 8B 83 D4 00 00 00 FF 93 D0 00 00 00 8B 45 FC 83 78 5C 00 75 18 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 45 FC 74 0C E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 45 FC 80 78 55 00 74 0A 8B 45 FC E8 ?? ?? ?? ?? EB 15 6A 00 8B 45 FC 83 C0 38 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 78 64 00 74 0E 8B 45 FC 8B 50 64 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 78 68 00 74 0E 8B 45 FC 8B 50 68 8B 45 FC E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 E9 CB 00 00 00 E9 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 AD 00 00 00 8B 45 FC 8B 40 38 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C 8B 58 08 4B 83 FB 00 7C 25 8B 45 FC 8B 40 3C 8B D3 E8 ?? ?? ?? ?? 80 78 72 00 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 4B 83 FB FF 75 DB 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 78 55 00 74 33 8B 45 FC 80 78 59 00 75 49 A1 ?? ?? ?? ?? 80 38 00 74 19 6A 00 68 ?? ?? ?? ?? 6A 00 6A 00 6A 1D 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1F 8B 45 FC 8B 40 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 38 50 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 38 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 00 07 00 00 00 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "TSession.UpdateAutoSessionName"
		size = 204
		refs = "0012 TSession.UpdateAutoSessionName 005e Format 0069 TSession.SetSessionName 0083 @HandleFinally 008d TSession.SetSessionNames 00a2 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC C6 40 58 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 8B 45 FC 8B 40 08 89 45 E8 C6 45 EC 11 8B 45 FC 8B 40 60 40 89 45 F0 C6 45 F4 00 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 58 00 C3 E9 ?? ?? ?? ?? EB F1 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 5F 00 25 00 64 00 00 00 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "TSession.ValidateAutoSession"
		size = 225
		refs = "001e TSession.ValidateAutoSession 0036 TComponent.GetComponentCount 004a TComponent.GetComponent 0059 _DV_TSession 005e @IsClass 0070 SAutoSessionExclusive 0075 LoadResString 0080 DatabaseError 0092 SAutoSessionExists 00b0 DatabaseErrorFmt 00ce @UStrArrayClr 00d4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D EC 89 5D F0 88 4D F7 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F8 00 0F 84 86 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 77 46 33 FF 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 3B 5D FC 74 5F 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4E 80 7D F7 00 74 1A 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 8B 55 FC E8 ?? ?? ?? ?? EB 2E 80 7B 57 00 74 28 6A 00 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 43 08 89 45 E4 C6 45 E8 11 8D 55 E4 33 C9 58 E8 ?? ?? ?? ?? 47 4E 75 8C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "TParamList.Create"
		size = 600
		refs = "0022 @ClassCreate 0033 TParamList.Create 006b Pos 00b4 TFieldDescList 00b9 @DynArraySetLength 00c8 AllocMem 0111 @LStrFromUStr 0159 @LStrCopy 0169 StrPLCopy 01ae @LStrToPChar 01b8 StrCopy 01c5 CharToOemA 01f0 @LStrArrayClr 01f8 @UStrClr 0200 @LStrClr 020e @HandleFinally 021e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 DB 89 5D D4 89 5D D8 89 5D DC 89 5D FC 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D EC 88 55 F3 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 4C 46 C7 45 E8 00 00 00 00 8D 4D FC 8B 55 E8 8B 45 EC 8B 18 FF 53 0C 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 74 1D 8B 45 F4 FF 40 04 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 66 2B C7 40 8B 55 F4 66 01 42 10 FF 45 E8 4E 75 BC 8B 45 F4 8B 58 04 85 DB 0F 8E 34 01 00 00 53 8B 45 F4 83 C0 08 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 F4 0F B7 40 10 E8 ?? ?? ?? ?? 8B D8 8B 45 F4 89 58 0C 33 C0 89 45 E4 89 5D E0 8B 45 EC 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C EB 00 00 00 46 C7 45 E8 00 00 00 00 8D 4D DC 8B 55 E8 8B 45 EC 8B 18 FF 53 0C 8B 55 DC 8D 45 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 A4 00 00 00 8B 45 E4 8B D0 C1 E0 05 2B C2 8B 55 F4 8B 52 08 8D 1C 42 FF 45 E4 0F B7 45 E4 66 89 03 8D 45 D8 50 8B CF 49 BA 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 D8 8D 43 02 B9 1F 00 00 00 E8 ?? ?? ?? ?? 66 C7 43 22 01 00 8B 45 F4 0F B7 55 E0 66 2B 50 0C 66 89 53 2A 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 66 2B C7 40 66 89 43 2C 8D 45 D4 50 8D 57 01 B9 FF 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 D4 E8 ?? ?? ?? ?? 8B D0 8B 45 E0 E8 ?? ?? ?? ?? 8B 45 E0 50 8B 45 E0 50 E8 ?? ?? ?? ?? 0F B7 43 2C 01 45 E0 FF 45 E8 4E 0F 85 1D FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D3 8B 45 F4 80 7D F3 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F4 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 E4 04 01 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "TParamList.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 DisposeMem 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 0F B7 56 10 8D 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TDatabase.Create"
		size = 190
		refs = "000b @ClassCreate 001c TCustomConnection.Create 002d _DV_TSession 0032 @IsClass 0043 DefaultSession 0059 TDatabase.SetSessionName 0066 TSession.AddDatabase 006d _Dn_TStringList 0072 TStringList.Create 0084 TDatabase.ParamsChanging 00aa @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 83 BF 88 00 00 00 00 75 24 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 89 B7 88 00 00 00 EB 0B E8 ?? ?? ?? ?? 89 87 88 00 00 00 8B 87 88 00 00 00 8B 50 5C 8B C7 E8 ?? ?? ?? ?? 8B 87 88 00 00 00 8B D7 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B7 8C 00 00 00 89 7E 4C C7 46 48 ?? ?? ?? ?? C6 47 44 01 C6 47 71 01 8B 87 88 00 00 00 8B 40 44 89 87 84 00 00 00 C6 47 70 01 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TDatabase.Destroy"
		size = 89
		refs = "0003 @BeforeDestruction 000e TComponent.Destroying 0015 TCustomConnection.Close 0026 TSession.RemoveDatabase 0031 TCustomConnection.Destroy 003c TObject.Free 0052 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 86 88 00 00 00 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 86 8C 00 00 00 E8 ?? ?? ?? ?? 8B 86 90 00 00 00 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TDatabase.ApplyUpdates"
		size = 273
		refs = "001e TDatabase.ApplyUpdates 002c TDatabase.StartTransaction 005e SUpdateWrongDB 0063 LoadResString 008c Format 0096 DatabaseError 009d TBDEDataSet.ApplyUpdates 00ab TDatabase.Commit 00ba @HandleAnyException 00c2 TDatabase.Rollback 00c7 @RaiseAgain 00cc @DoneExcept 00de TBDEDataSet.CommitUpdates 00fe @UStrArrayClr 0104 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 DB 89 5D F0 89 5D EC 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 75 F4 85 F6 7C 62 46 8B 5D F8 8B 3B 8B 87 44 02 00 00 3B 45 FC 74 44 8D 45 F0 50 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 47 08 89 45 DC C6 45 E0 11 8B 45 FC 8B 40 08 89 45 E4 C6 45 E8 11 8D 55 DC B9 01 00 00 00 58 E8 ?? ?? ?? ?? 8B 45 F0 33 D2 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 A2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 F4 85 F6 7C 11 46 8B 5D F8 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TDatabase.ClearStatements"
		size = 91
		refs = "0023 TList.Get 002c DbiQFree 003f TStmtInfo 0044 @Dispose"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 90 00 00 00 85 C0 74 48 8B 78 08 4F 85 FF 7C 35 47 33 F6 8B D6 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 83 C0 04 50 E8 ?? ?? ?? ?? 8B D6 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4F 75 CE 8B 83 90 00 00 00 8B 10 FF 52 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "GetHashCode"
		size = 103
		refs = "0013 @PWCharLen"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F8 33 DB BE 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 83 F8 10 7D 1A 48 83 F8 00 7C 3D 0F B7 14 77 6B CB 25 03 D1 8B DA 46 48 83 F8 FF 75 EE EB 29 8B D0 85 D2 79 03 83 C2 07 C1 FA 03 89 55 FC 48 85 C0 7C 15 0F B7 14 77 6B CB 27 03 D1 8B DA 2B 45 FC 03 75 FC 85 C0 7D EB 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "GetStmtInfo"
		size = 336
		refs = "0017 GetStmtInfo 0033 _Dn_TList 0038 TObject.Create 0050 GetHashCode 0083 TList.Get 0097 @UStrLAsg 00a1 @UStrFromPWChar 00c8 CompareText 00e8 TStmtInfo 00f2 @New 0109 TList.Add 0118 @FillChar 013a @UStrArrayClr 0140 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 D2 89 55 FC 89 55 F8 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 83 B8 90 00 00 00 00 75 18 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 08 8B 52 FC 89 82 90 00 00 00 33 C0 89 45 F4 8B C7 E8 ?? ?? ?? ?? 89 45 F0 8B 45 08 8B 40 FC 8B 80 90 00 00 00 8B 70 08 4E 85 F6 7C 75 46 C7 45 EC 00 00 00 00 8B 45 08 8B 40 FC 8B 80 90 00 00 00 8B 55 EC E8 ?? ?? ?? ?? 8B D8 8B 03 3B 45 F0 75 4A 8D 45 FC 8B 53 08 E8 ?? ?? ?? ?? 8D 45 F8 8B D7 E8 ?? ?? ?? ?? 8B 45 FC 3B 45 F8 75 04 B0 01 EB 20 83 7D FC 00 74 06 83 7D F8 00 75 04 33 C0 EB 10 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 74 05 89 5D F4 EB 06 FF 45 EC 4E 75 93 83 7D F4 00 75 3E 8B 15 ?? ?? ?? ?? B8 0C 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 08 8B 40 FC 8B 80 90 00 00 00 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 33 C9 BA 0C 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8B 55 F0 89 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "GetStatementHandle"
		size = 358
		refs = "0011 GetStatementHandle 0036 @UStrToPWChar 003b GetStmtInfo 0066 DbiQAlloc 006b Check 0084 DbiSetProp 00a4 SetBoolProp 00d9 @LStrFromUStr 00e1 @LStrToPChar 00eb DbiQPrepare 010e TSession.GetPassword 0119 DbiError 0136 @UStrAsg 0151 @LStrClr 0157 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C0 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 33 C0 89 45 FC 8B 45 08 80 78 0C 00 74 1D 8B 45 08 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F0 8B 46 04 89 45 FC 83 7D FC 00 0F 85 EE 00 00 00 8D 45 FC 50 6A 02 8B 45 08 8B 40 FC 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 78 08 00 74 15 6A 02 68 21 00 06 00 8B 45 FC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 80 78 76 00 75 21 33 C9 BA 26 00 06 00 8B 45 FC E8 ?? ?? ?? ?? 83 C9 FF BA 42 00 06 00 8B 45 FC E8 ?? ?? ?? ?? EB 10 83 C9 FF BA 10 00 06 00 8B 45 FC E8 ?? ?? ?? ?? 8D 45 F8 8B 55 08 8B 52 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B D8 8B C3 66 83 E8 01 72 2F 66 2D 01 29 74 02 EB 1E 8B 45 08 8B 40 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 B4 8B C3 E8 ?? ?? ?? ?? EB AB 8B C3 E8 ?? ?? ?? ?? EB A2 85 F6 74 14 8D 46 08 8B 55 08 8B 52 F8 E8 ?? ?? ?? ?? 8B 45 FC 89 46 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "TDatabase.Execute"
		size = 285
		refs = "0018 TDatabase.Execute 0026 TCustomConnection.Open 0042 GetStatementHandle 0061 SetQueryParams 006e DbiQExec 0073 Check 008f DbiQFree 0095 @HandleFinally 00ab @LStrFromUStr 00b3 @LStrToPChar 00c5 DbiQExecDirect 00e8 DbiGetProp 0107 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 DB 89 5D E8 8B D9 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 85 DB 74 0C 8B 43 08 83 78 08 00 0F 9F C0 EB 02 33 C0 84 C0 74 5B 55 E8 ?? ?? ?? ?? 59 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B 55 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 F0 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D 0C 00 75 09 8D 45 F0 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E9 8B 45 08 50 8D 45 E8 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 50 6A 02 8B 45 FC 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 08 00 75 22 8D 45 EE 50 6A 04 8D 45 F4 50 68 14 00 06 00 8B 45 F0 50 E8 ?? ?? ?? ?? 66 85 C0 74 05 33 C0 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "TDatabase.CheckActive"
		size = 87
		refs = "000c TDatabase.CheckActive 0023 SDatabaseClosed 0028 LoadResString 0032 DatabaseError 0047 @UStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 80 00 00 00 00 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "TDatabase.CheckInactive"
		size = 102
		refs = "000c TDatabase.CheckInactive 0028 TCustomConnection.Close 0032 SDatabaseOpen 0037 LoadResString 0041 DatabaseError 0056 @UStrClr 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 80 00 00 00 00 74 26 F6 43 1C 10 74 09 8B C3 E8 ?? ?? ?? ?? EB 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "TDatabase.CheckDatabaseName"
		size = 93
		refs = "000c TDatabase.CheckDatabaseName 0029 SDatabaseNameMissing 002e LoadResString 0038 DatabaseError 004d @UStrClr 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 98 00 00 00 00 75 1D 80 7B 72 00 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "TDatabase.CheckSessionName"
		size = 231
		refs = "001a Sessions 001f TSessionList.GetSessionByName 0036 TSessionList.FindSession 0060 TSession.RemoveDatabase 0073 TComponent.FreeNotification 0084 TSession.AddDatabase 008c TDatabase.CheckSessionName 00a3 TDatabase.ValidateName 00b2 @HandleAnyException 00bf @UStrClr 00c4 @RaiseAgain 00c9 @DoneExcept 00dd TSession.SetActive"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 84 DB 74 17 8B 45 FC 8B 90 94 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 EB 15 8B 45 FC 8B 90 94 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 89 00 00 00 8B 45 FC 3B B0 88 00 00 00 74 7E 8B 45 FC 8B 80 88 00 00 00 85 C0 74 08 8B 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C6 89 82 88 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 88 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 98 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1C E9 ?? ?? ?? ?? 8B 45 FC 05 98 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 DB 74 10 8B 45 FC 8B 80 88 00 00 00 B2 01 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "TDatabase.DoDisconnect"
		size = 220
		refs = "0018 TDatabase.ClearStatements 002a TSession.DBNotification 0032 TDatabase.CloseDataSets 0049 OsLdUnloadObj 0055 DefaultSession 007b TSession.CloseDatabaseHandle 00c4 TDatabase.DoDisconnect 00c9 TSession.InternalDeleteAlias"
	strings:
		$1 = { 51 89 04 24 8B 04 24 83 B8 80 00 00 00 00 0F 84 C0 00 00 00 8B 04 24 E8 ?? ?? ?? ?? 8B CC 8B 04 24 8B 80 88 00 00 00 B2 01 E8 ?? ?? ?? ?? 8B 04 24 E8 ?? ?? ?? ?? 8B 04 24 80 78 74 00 74 0E 8B 04 24 05 84 00 00 00 50 E8 ?? ?? ?? ?? 8B 04 24 C6 40 74 00 E8 ?? ?? ?? ?? 8B 40 44 8B 14 24 89 82 84 00 00 00 8B 04 24 80 78 77 00 75 13 8B 04 24 8B 80 88 00 00 00 8B 14 24 E8 ?? ?? ?? ?? EB 07 8B 04 24 C6 40 77 00 8B 04 24 C6 40 76 00 8B 04 24 33 D2 89 90 80 00 00 00 8B 04 24 33 D2 89 50 7C 8B 04 24 80 78 73 00 74 29 6A 01 8B 44 24 04 8B 90 98 00 00 00 8B 44 24 04 8B 80 88 00 00 00 0F B6 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 04 24 C6 40 73 00 5A C3 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "TDatabase.CloseDataSets"
		size = 43
		refs = "0012 TDatabase.GetDataSet"
	strings:
		$1 = { 53 8B D8 EB 19 8B C3 8B 10 FF 52 50 8B D0 4A 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 D4 02 00 00 8B C3 8B 10 FF 52 50 85 C0 75 DC 5B C3 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "TDatabase.Commit"
		size = 21
		refs = "0006 TDatabase.CheckActive 000f TDatabase.EndTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90752_0 {
	meta:
		name = "TCustomBarSeries.SetParentChart"
		size = 21
		refs = "0006 TChartSeries.SetParentChart 000f TCustomBarSeries.SetOtherBars"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77578_0 {
	meta:
		name = "TCustomDBLookupComboBox.CMFontChanged"
		size = 21
		refs = "0006 TWinControl.CMFontChanged 000f TControl.SetHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_95302_0 {
	meta:
		name = "TCustomGridBehavior.Refresh"
		size = 21
		refs = "0006 TCustomBGColorBehavior.Refresh 000f TCustomGridBehavior.InvalidateGrid"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84895_0 {
	meta:
		name = "TCustomMemo.Loaded"
		size = 21
		refs = "0006 TControl.Loaded 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83887_0 {
	meta:
		name = "TCustomRibbonComboBox.CMMouseleave"
		size = 21
		refs = "0006 TControl.CMMouseLeave 000f TCustomRibbonComboBox.SetMouseInControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83371_0 {
	meta:
		name = "TCustomRibbonPage.Resize"
		size = 21
		refs = "0006 TControl.Resize 000f TCustomRibbonPage.SetGroupOffset"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75024_0 {
	meta:
		name = "TCustomRichEdit.Clear"
		size = 21
		refs = "0006 TCustomEdit.Clear 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_43903_0 {
	meta:
		name = "TIWTabControl.InitDesignTime"
		size = 21
		refs = "0006 TIWCustomRegion.InitDesignTime 000f TIWCustomRegion.set_Clip"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_43925_0 {
	meta:
		name = "TIWTabPage.InitDesignTime"
		size = 21
		refs = "0006 TIWCustomRegion.InitDesignTime 000f TIWCustomRegion.set_Clip"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83383_0 {
	meta:
		name = "TOffice2007Button.CMMouseleave"
		size = 21
		refs = "0006 TControl.CMMouseLeave 000f TOffice2007Button.SetMouseInControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_82672_0 {
	meta:
		name = "TOleContainer.WMKillFocus"
		size = 21
		refs = "0006 TWinControl.WMKillFocus 000f TOleContainer.SetFocused"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83853_0 {
	meta:
		name = "TRibbonComboControl.CMMouseleave"
		size = 21
		refs = "0006 TCustomButtonControl.CMMouseLeave 000f TRibbonComboControl.SetMouseInControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83170_0 {
	meta:
		name = "TRibbonGroupCollapsedControl.CMMouseleave"
		size = 21
		refs = "0006 TControl.CMMouseLeave 000f TRibbonGroupCollapsedControl.SetMouseInControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83587_0 {
	meta:
		name = "TRibbonGroupScrollButton.CMMouseleave"
		size = 21
		refs = "0006 TControl.CMMouseLeave 000f TRibbonGroupScrollButton.SetMouseInControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83909_0 {
	meta:
		name = "TRibbonQATScrollButton.CMMouseLeave"
		size = 21
		refs = "0006 TCustomUtilityButton.CMMouseLeave 000f TRibbonQATScrollButton.SetCursorInBtn"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83812_0 {
	meta:
		name = "TRibbonSmallSplitButton.CMMouseLeave"
		size = 21
		refs = "0006 TCustomButtonControl.CMMouseLeave 000f TRibbonSmallSplitButton.SetCursorInSplit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_111682_0 {
	meta:
		name = "TXmlSourceCode.Pack"
		size = 21
		refs = "0006 TList.Pack 000f TXmlSourceCode.CalculatePieceOffset"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_111684_0 {
	meta:
		name = "TXmlSourceCode.Sort"
		size = 21
		refs = "0006 TList.Sort 000f TXmlSourceCode.CalculatePieceOffset"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "TDatabase.EndTransaction"
		size = 29
		refs = "0011 DbiEndTran 0016 Check"
	strings:
		$1 = { 53 56 8B F2 8B D8 56 6A 00 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "TDatabase.GetAliasName"
		size = 38
		refs = "0015 @UStrAsg 001f @UStrClr"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 75 00 74 10 8B C6 8B 93 9C 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "TDatabase.GetConnected"
		size = 11
		altNames = "TXMLDocument.GetModified"
	strings:
		$1 = { 83 B8 80 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "TDatabase.GetDataSet"
		size = 29
		refs = "000b TCustomConnection.GetDataSet 0011 _DV_TDBDataSet 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_74167_0 {
	meta:
		name = "TButtonCategories.GetItem"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TButtonCategory 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_74143_0 {
	meta:
		name = "TButtonCollection.GetItem"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TButtonItem 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_111396_0 {
	meta:
		name = "TDomNode.RemoveChild"
		size = 29
		refs = "000b TCustomOwnedNode.Remove 0011 _DV_TDomNode 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48105_0 {
	meta:
		name = "TFunctions.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TFunction 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48111_0 {
	meta:
		name = "THTMLBlocks.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_THTMLBlock 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_32612_0 {
	meta:
		name = "TIdCookies.GetCookie"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TIdCookie 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_39298_0 {
	meta:
		name = "TInCookies.GetCookie"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TInCookie 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48100_0 {
	meta:
		name = "TIncludeFiles.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TIncludeFile 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_84086_0 {
	meta:
		name = "TOptionItems.GetItem"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TOptionItem 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_84087_0 {
	meta:
		name = "TOptionItems.Insert"
		size = 29
		refs = "000b TCollection.Insert 0011 _DV_TOptionItem 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_83451_0 {
	meta:
		name = "TRibbonTabs.GetItem"
		size = 29
		refs = "000b TCollection.GetItem 0011 _DV_TRibbonTabItem 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48117_0 {
	meta:
		name = "TScriptBlocks.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TScriptBlock 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48123_0 {
	meta:
		name = "TVars.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TVar 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48064_0 {
	meta:
		name = "TXMLDocuments.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TXMLDocument 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48071_0 {
	meta:
		name = "TXMLRowSets.GetObject"
		size = 29
		refs = "000b TScriptObjectContainer.GetAsObject 0011 _DV_TXMLRowSet 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "TDatabase.GetDirectory"
		size = 172
		refs = "001c TDatabase.GetDirectory 003b DbiGetDirectory 0040 Check 0053 OemToCharA 006b @LStrFromArray 0078 @UStrFromLStr 0081 @UStrClr 0099 @LStrClr 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 57 33 C9 89 8D F4 FE FF FF 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B BB 80 00 00 00 85 FF 74 4E 8D 85 FB FE FF FF 50 6A 00 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 FB FE FF FF 50 8D 85 FB FE FF FF 50 E8 ?? ?? ?? ?? 8D 85 F4 FE FF FF 8D 95 FB FE FF FF B9 05 01 00 00 6A 00 E8 ?? ?? ?? ?? 8B 95 F4 FE FF FF 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "TDatabase.GetFieldNames"
		size = 30
		refs = "0018 TSession.GetFieldNames"
	strings:
		$1 = { 56 8B B0 88 00 00 00 85 F6 74 11 51 8B CE 8B 80 98 00 00 00 91 87 CA E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TDatabase.GetTableNames"
		size = 33
		refs = "001b TSession.GetTableNames"
	strings:
		$1 = { 56 8B B0 88 00 00 00 85 F6 74 14 6A 00 51 52 8B D6 8B 80 98 00 00 00 33 C9 92 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "TDatabase.GetDriverName"
		size = 38
		refs = "000f @UStrClr 001f @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 75 00 74 0A 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 8B 93 9C 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "TDatabase.SetDatabaseFlags"
		size = 124
		refs = "001b DbiGetProp 0020 Check 0025 TDatabase.SetDatabaseFlags 002e StrIComp"
	strings:
		$1 = { 53 83 C4 D8 8B D8 54 6A 20 8D 44 24 10 50 68 02 00 04 00 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 88 43 76 54 6A 04 8D 44 24 0C 50 68 01 00 03 FF 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 07 83 7C 24 04 00 75 04 33 C0 EB 02 B0 01 88 43 78 83 C4 28 5B C3 00 00 00 53 54 41 4E 44 41 52 44 00 00 00 00 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "TDatabase.GetTraceFlags"
		size = 60
		refs = "0021 GetIntProp 002c TDatabase.GetTraceFlags"
	strings:
		$1 = { 53 56 8B D8 8B C3 8B 10 FF 52 48 84 C0 74 1A 80 7B 76 00 74 14 BA 07 00 04 04 8B 83 80 00 00 00 E8 ?? ?? ?? ?? 8B F0 EB 07 0F B7 35 ?? ?? ?? ?? 8B C6 5E 5B C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "TDatabase.GetObjectContext"
		size = 31
		refs = "0005 GetObjectContextProc 0019 @IntfClear"
	strings:
		$1 = { 53 8B DA 83 3D ?? ?? ?? ?? 00 74 0A 8B C3 FF 15 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "TDatabase.GetInTransaction"
		size = 49
		refs = "0016 DbiGetTranInfo"
	strings:
		$1 = { 53 56 83 C4 F4 8B D8 8B B3 80 00 00 00 85 F6 74 14 54 6A 00 56 E8 ?? ?? ?? ?? 66 85 C0 75 06 83 3C 24 01 74 04 33 C0 EB 02 B0 01 83 C4 0C 5E 5B C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "TDatabase.Loaded"
		size = 27
		refs = "0006 TCustomConnection.Loaded 0015 TDatabase.CheckSessionName"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 7B 45 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "TDatabase.Notification"
		size = 66
		refs = "0010 TComponent.Notification 0022 DefaultSession 0031 TCustomConnection.Close 003a TDatabase.SetSessionName"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 25 3B B7 88 00 00 00 75 1D E8 ?? ?? ?? ?? 3B 87 88 00 00 00 74 10 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "TDatabase.LoadLocale"
		size = 70
		refs = "001b DbiGetLdNameFromDb 002b OsLdLoadBySymbName"
	strings:
		$1 = { 53 83 C4 DC 8B D8 80 7B 76 00 74 35 8D 44 24 04 50 6A 00 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 1D 54 8D 44 24 08 50 E8 ?? ?? ?? ?? 66 85 C0 75 0D 8B 04 24 89 83 84 00 00 00 C6 43 74 01 83 C4 24 5B C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "TDatabase.Login"
		size = 292
		refs = "0015 TDatabase.Login 0046 TStrings.GetValue 004b LoginDialogExProc 0076 SLoginError 007b LoadResString 0097 DatabaseErrorFmt 00a6 TStrings.SetValue 00cf @UStrArrayClr 00d5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB A2 00 00 00 00 74 12 8B CE 8B D3 8B 83 A4 00 00 00 FF 93 A0 00 00 00 EB 7E 8D 4D FC BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 74 47 6A 00 8B 3D ?? ?? ?? ?? 8B 3F 8D 4D F8 8D 55 FC 8B 83 98 00 00 00 FF D7 84 C0 75 2B 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 50 8B 83 98 00 00 00 89 45 EC C6 45 F0 11 8D 55 EC 33 C9 58 E8 ?? ?? ?? ?? 8B 4D FC BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 4D F8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 55 00 53 00 45 00 52 00 20 00 4E 00 41 00 4D 00 45 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 50 00 41 00 53 00 53 00 57 00 4F 00 52 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "NeedsDBAlias"
		size = 356
		refs = "0010 NeedsDBAlias 004b @UStrEqual 00b2 TStrings.GetName 00bf CompareText 00ef TStrings.GetValue 0100 TStrings.SetValue 0122 @UStrArrayClr 012a @UStrClr 0130 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 80 78 FF 00 74 32 8B 45 08 8B 40 F8 83 B8 9C 00 00 00 00 74 1F 8B 45 08 8B 40 F8 8B 80 98 00 00 00 8B 55 08 8B 52 F8 8B 92 9C 00 00 00 E8 ?? ?? ?? ?? 75 04 33 C0 EB 02 B0 01 88 45 FB 8B 45 08 8B 40 F8 8B 80 8C 00 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C 96 00 00 00 46 33 DB 8D 4D F4 8B 45 08 8B 40 F8 8B 80 8C 00 00 00 8B D3 8B 38 FF 57 0C 8B 55 F4 8B 45 08 8B 40 F4 8B 08 FF 51 54 40 7F 64 8D 4D FC 8B 45 08 8B 40 F8 8B 80 8C 00 00 00 8B D3 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 3D 8B 45 08 8B 40 F4 8B 55 FC 8B 08 FF 51 58 40 7E 2C C6 45 FB 01 8D 4D F0 8B 45 08 8B 40 F8 8B 80 8C 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 8B 4D F0 8B 45 08 8B 40 F4 8B 55 FC E8 ?? ?? ?? ?? 43 4E 0F 85 6D FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 0F B6 45 FB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 50 00 41 00 53 00 53 00 57 00 4F 00 52 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "TDatabase.CheckDatabaseAlias"
		size = 940
		refs = "004b TDatabase.CheckDatabaseAlias 0058 @UStrClr 0066 _Dn_TStringList 006b TStringList.Create 0099 @UStrLAsg 00de @LStrFromUStr 00ef StrToOem 00fa @LStrToPChar 0100 DbiGetDatabaseDesc 010a @TryFinallyExit 0126 OemToCharA 0136 @UStrFromArray 014a TSession.GetAliasParams 0160 TSession.GetDriverParams 01c8 TStrings.GetValue 01fd TStrings.SetValue 0234 TDatabase.Login 0254 @UStrAsg 0295 TObject.Free 029b @HandleFinally 02c9 NeedsDBAlias 02f6 TSession.InternalAddAlias 0337 @UStrArrayClr 0347 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 81 C4 60 FE FF FF 53 33 C9 89 8D 60 FE FF FF 89 8D 64 FE FF FF 89 8D 68 FE FF FF 89 8D 6C FE FF FF 89 8D 70 FE FF FF 89 8D 74 FE FF FF 89 8D 7C FE FF FF 89 8D 78 FE FF FF 89 4D F0 89 4D EC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 C6 40 73 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 83 B8 9C 00 00 00 00 74 1D 8D 45 F0 8B 55 F8 8B 92 9C 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 0F B6 40 75 88 45 FF EB 15 8D 45 F0 8B 55 F8 8B 92 98 00 00 00 E8 ?? ?? ?? ?? C6 45 FF 01 80 7D FF 00 0F 84 88 00 00 00 8D 85 83 FE FF FF 50 8D 85 78 FE FF FF 8B 55 F0 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 78 FE FF FF 8D 95 7C FE FF FF E8 ?? ?? ?? ?? 8B 85 7C FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 74 0A E8 ?? ?? ?? ?? E9 0B 02 00 00 80 7D E7 00 74 04 C6 45 E7 00 8D 45 C8 50 8D 45 C8 50 E8 ?? ?? ?? ?? 8D 45 EC 8D 55 C8 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 8B 80 88 00 00 00 8B 4D F4 8B 55 F0 E8 ?? ?? ?? ?? EB 25 8B 45 F8 8B 80 88 00 00 00 8B 4D F4 8B 55 F0 E8 ?? ?? ?? ?? 8D 45 EC 8B 55 F8 8B 92 9C 00 00 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 F4 8B 08 FF 51 58 40 0F 84 3E 01 00 00 8B 45 F8 80 78 44 00 0F 84 0B 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 8D 74 FE FF FF 8B 45 F8 8B 80 8C 00 00 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD 74 FE FF FF 00 75 2C 8D 8D 70 FE FF FF BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 8D 70 FE FF FF 8B 45 F8 8B 80 8C 00 00 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D 6C FE FF FF 8B 45 F8 8B 80 8C 00 00 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D 6C FE FF FF BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F8 E8 ?? ?? ?? ?? 8D 8D 68 FE FF FF BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B 95 68 FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 8D 64 FE FF FF BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B 8D 64 FE FF FF 8B 45 F8 8B 80 8C 00 00 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8D 8D 60 FE FF FF 8B 45 F8 8B 80 8C 00 00 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 60 FE FF FF 8B C3 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 2F 8B 45 F4 50 0F B6 05 ?? ?? ?? ?? 50 6A 00 8B 45 F8 8B 90 98 00 00 00 8B 45 F8 8B 80 88 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 8B 45 F8 C6 40 73 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 60 FE FF FF BA 06 00 00 00 E8 ?? ?? ?? ?? 8D 85 78 FE FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CB 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 55 00 53 00 45 00 52 00 20 00 4E 00 41 00 4D 00 45 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 50 00 41 00 53 00 53 00 57 00 4F 00 52 00 44 00 00 00 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "TDatabase.OpenFromExistingDB"
		size = 45
		refs = "0010 TSession.FindDatabaseHandle 0019 TDatabase.SetHandle"
	strings:
		$1 = { 53 8B D8 8B 93 98 00 00 00 8B 83 88 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? C6 43 77 00 83 BB 80 00 00 00 00 0F 95 C0 5B C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "TDatabase.DoConnect"
		size = 884
		refs = "0024 TDatabase.DoConnect 0042 TDatabase.CheckDatabaseName 004c TDatabase.CheckSessionName 005d TDatabase.OpenFromExistingDB 0073 TSession.LockSession 008f TSession.GetConfigMode 00ab TDatabase.CheckDatabaseAlias 00d3 IsDirectory 00df @LStrClr 00f7 @LStrFromUStr 0102 StrToOem 010d TDatabase.GetObjectContext 0136 StrCopy 0196 @LStrToPChar 01a5 ShareModes 01b4 OpenModes 01ca DbiOpenDatabase 01cf Check 01e6 TDatabase.SetDirectory 01fc SetBoolProp 0230 TDatabase.SetDatabaseFlags 0238 TDatabase.LoadLocale 0259 TSession.LoadSMClient 026e TDatabase.SetTraceFlags 0281 TSession.DBNotification 0290 @HandleAnyException 02b9 TSession.InternalDeleteAlias 02be @RaiseAgain 02c3 @DoneExcept 02e2 TSession.SetConfigMode 02e8 @HandleFinally 0305 TSession.UnlockSession 0327 @LStrArrayClr 032f @IntfClear 033f @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 9C 53 56 57 33 D2 89 55 A0 89 55 9C 89 55 A4 89 55 A8 89 55 FC 89 55 F8 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 83 B8 80 00 00 00 00 0F 85 D3 02 00 00 8B 45 F4 E8 ?? ?? ?? ?? B2 01 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 80 78 79 00 74 10 8B 45 F4 E8 ?? ?? ?? ?? 84 C0 0F 85 A8 02 00 00 8B 45 F4 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 88 45 F3 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 83 B8 9C 00 00 00 00 75 1C 8B 45 F4 8B 80 98 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 0A 8D 45 FC E8 ?? ?? ?? ?? EB 21 8D 45 A8 8B 55 F4 8B 92 98 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 A8 8D 55 FC E8 ?? ?? ?? ?? 8D 55 A4 8B 45 F4 E8 ?? ?? ?? ?? 8B 5D A4 33 F6 85 DB 74 46 C7 45 EC 01 00 00 00 66 C7 45 DA 04 00 66 C7 45 D8 00 00 BA ?? ?? ?? ?? 8D 45 B0 E8 ?? ?? ?? ?? 8D 7D AE 8B 45 F4 0F B6 40 70 2C 01 72 08 74 0A FE C8 74 0C EB 17 33 F6 EB 13 66 BE 00 01 EB 0D 66 BE 00 02 EB 07 33 C0 89 45 EC 33 FF 8B 45 F4 05 80 00 00 00 50 53 57 0F B7 45 EC 50 8D 45 9C 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 9C 8D 55 A0 E8 ?? ?? ?? ?? 8B 45 A0 E8 ?? ?? ?? ?? 50 8B 45 F4 0F B6 40 7A 8B 04 85 ?? ?? ?? ?? 50 8B 45 F4 0F B6 40 7B 8B 04 85 ?? ?? ?? ?? 0F B7 D6 0B C2 50 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D FC 00 75 11 8B 45 F4 8B 90 98 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 8B 80 80 00 00 00 83 C9 FF BA 05 00 04 00 E8 ?? ?? ?? ?? 8B 45 F4 8B 80 80 00 00 00 83 C9 FF BA 04 00 04 00 E8 ?? ?? ?? ?? 8B 45 F4 8B 80 80 00 00 00 83 C9 FF BA 11 00 04 04 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 80 78 76 00 74 18 8B 45 F4 F6 40 1C 10 0F 95 C2 8B 45 F4 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8B 80 88 00 00 00 0F B7 50 50 8B 45 F4 E8 ?? ?? ?? ?? 8D 4D F4 8B 45 F4 8B 80 88 00 00 00 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 38 E9 ?? ?? ?? ?? 8B 45 F4 80 78 73 00 74 20 6A 00 8B 45 F4 8B 90 98 00 00 00 8B 45 F4 8B 80 88 00 00 00 0F B6 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 8B 80 88 00 00 00 0F B6 55 F3 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 8B 80 88 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 9C BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 A4 E8 ?? ?? ?? ?? 8D 45 A8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CB 5F 5E 5B 8B E5 5D C3 00 00 4D 54 53 20 43 4F 4E 54 45 58 54 20 4F 42 4A 45 43 54 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "TDatabase.Rollback"
		size = 24
		refs = "0006 TDatabase.CheckActive 0012 TDatabase.EndTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "TDatabase.SetAliasName"
		size = 8
		refs = "0003 TDatabase.SetDatabaseType"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_95046_0 {
	meta:
		name = "ConvertTeeFileToText"
		size = 8
		refs = "0003 ConvertTeeFile"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80557_0 {
	meta:
		name = "TBitmap.WriteData"
		size = 8
		refs = "0003 TBitmap.WriteStream"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_94219_0 {
	meta:
		name = "TCustomAxisPanel.ActiveSeriesLegend"
		size = 8
		refs = "0003 TCustomAxisPanel.SeriesLegend"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15446_0 {
	meta:
		name = "TCustomClientDataSet.ReadData"
		size = 8
		refs = "0003 TCustomClientDataSet.ReadDataPacket"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11613_0 {
	meta:
		name = "TDBXMetaDataIndex.AddColumn"
		size = 8
		refs = "0003 TDBXMetaDataIndex.AddColumn"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35204_0 {
	meta:
		name = "TIdIMAP4.IsImapPartNumberValid"
		size = 8
		refs = "0003 TIdIMAP4.IsItDigitsAndOptionallyPeriod"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_80717_0 {
	meta:
		name = "TInplaceEdit.Move"
		size = 8
		refs = "0003 TInplaceEdit.InternalMove"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5415_0 {
	meta:
		name = "TLargeintField.GetValue"
		size = 8
		refs = "0003 TField.GetData"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_26849_0 {
	meta:
		name = "TList<DSAzDlgBlockBlob.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgBlockBlob.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27073_0 {
	meta:
		name = "TList<DSAzDlgCopyBlob.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgCopyBlob.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27277_0 {
	meta:
		name = "TList<DSAzDlgCreateContainer.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgCreateContainer.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27509_0 {
	meta:
		name = "TList<DSAzDlgPageBlob.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgPageBlob.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27726_0 {
	meta:
		name = "TList<DSAzDlgPutBlockList.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgPutBlockList.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27927_0 {
	meta:
		name = "TList<DSAzDlgSnapshotBlob.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzDlgSnapshotBlob.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28545_0 {
	meta:
		name = "TList<DSAzureBlob.TBBlob>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBBlob>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28767_0 {
	meta:
		name = "TList<DSAzureBlob.TBBlock>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBBlock>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28421_0 {
	meta:
		name = "TList<DSAzureBlob.TBContainer>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBContainer>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28710_0 {
	meta:
		name = "TList<DSAzureBlob.TBPageRange>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBPageRange>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28653_0 {
	meta:
		name = "TList<DSAzureBlob.TBSignedIdentifier>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TBSignedIdentifier>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28600_0 {
	meta:
		name = "TList<DSAzureBlob.TLeaseItem>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TLeaseItem>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28824_0 {
	meta:
		name = "TList<DSAzureBlob.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<DSAzureBlob.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29068_0 {
	meta:
		name = "TList<DSAzureQueue.TMessageNodeData>.Delete"
		size = 8
		refs = "0003 TList<DSAzureQueue.TMessageNodeData>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29486_0 {
	meta:
		name = "TList<DSAzureTableDialog.TAzureTableColumn>.Delete"
		size = 8
		refs = "0003 TList<DSAzureTableDialog.TAzureTableColumn>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29341_0 {
	meta:
		name = "TList<DSAzureTableDialog.TAzureTableRow>.Delete"
		size = 8
		refs = "0003 TList<DSAzureTableDialog.TAzureTableRow>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29388_0 {
	meta:
		name = "TList<DSAzureTableDialog.TPair<System.string,DSAzureTableDialog.TAzureTableColumn>>.Delete"
		size = 8
		refs = "0003 TList<DSAzureTableDialog.TPair<System.string,DSAzureTableDialog.TAzureTableColumn>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3048_0 {
	meta:
		name = "TList<Data.Bind.Components.TBasicBindComponent>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TBasicBindComponent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2279_0 {
	meta:
		name = "TList<Data.Bind.Components.TBindEditorFactoryClass>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TBindEditorFactoryClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2052_0 {
	meta:
		name = "TList<Data.Bind.Components.TContainedBindComponent>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TContainedBindComponent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2398_0 {
	meta:
		name = "TList<Data.Bind.Components.TPair<System.Integer,System.Classes.IObserver>>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.Components.TPair<System.Integer,System.Classes.IObserver>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2753_0 {
	meta:
		name = "TList<Data.Bind.DBLinks.TBindDBColumnFactoryClass>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.DBLinks.TBindDBColumnFactoryClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3095_0 {
	meta:
		name = "TList<Data.Bind.DBScope.TBaseDataLink>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.DBScope.TBaseDataLink>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2997_0 {
	meta:
		name = "TList<Data.Bind.DBScope.TPair<Data.Bind.Components.TBasicBindComponent,Data.Bind.DBScope.TBaseDataLink>>.Delete"
		size = 8
		refs = "0003 TList<Data.Bind.DBScope.TPair<Data.Bind.Components.TBasicBindComponent,Data.Bind.DBScope.TBaseDataLink>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3592_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonBatchRow>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonBatchRow>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3847_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonGrant>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonGrant>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3949_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonMultipartPart>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonMultipartPart>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3898_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonMultipartUploadItem>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonMultipartUploadItem>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4000_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonNotificationEvent>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonNotificationEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3796_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonObjectResult>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonObjectResult>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3541_0 {
	meta:
		name = "TList<Data.Cloud.AmazonAPI.TAmazonRowConditional>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AmazonAPI.TAmazonRowConditional>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4675_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureBlob>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureBlob>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4726_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureBlobPageRange>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureBlobPageRange>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4522_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureBlockListItem>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureBlockListItem>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4573_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TAzureContainer>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TAzureContainer>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4624_0 {
	meta:
		name = "TList<Data.Cloud.AzureAPI.TSignedIdentifier>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.AzureAPI.TSignedIdentifier>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4471_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudQueue>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudQueue>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4420_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudQueueMessage>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudQueueMessage>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4777_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudTableColumn>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudTableColumn>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3643_0 {
	meta:
		name = "TList<Data.Cloud.CloudAPI.TCloudTableRow>.Delete"
		size = 8
		refs = "0003 TList<Data.Cloud.CloudAPI.TCloudTableRow>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16395_0 {
	meta:
		name = "TList<Data.DBXCommon.TDBXParameter>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TDBXParameter>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7893_0 {
	meta:
		name = "TList<Data.DBXCommon.TDBXScheduler.TDBXSchedulerRec>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TDBXScheduler.TDBXSchedulerRec>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8613_0 {
	meta:
		name = "TList<Data.DBXCommon.TDBXWritableValueArray>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TDBXWritableValueArray>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8038_0 {
	meta:
		name = "TList<Data.DBXCommon.TEventPointer>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TEventPointer>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7940_0 {
	meta:
		name = "TList<Data.DBXCommon.TPair<System.string,Data.DBXCommon.TEventPointer>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TPair<System.string,Data.DBXCommon.TEventPointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25129_0 {
	meta:
		name = "TList<Data.DBXCommon.TResultCommandHandler>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXCommon.TResultCommandHandler>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10370_0 {
	meta:
		name = "TList<Data.DBXJSON.TJSONAncestor>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSON.TJSONAncestor>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23832_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TConverterEvent>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TConverterEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10129_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TPair<System.Integer,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TPair<System.Integer,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10225_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10514_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10418_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TPair<System.string,System.TObject>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TPair<System.string,System.TObject>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23928_0 {
	meta:
		name = "TList<Data.DBXJSONReflect.TReverterEvent>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXJSONReflect.TReverterEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11102_0 {
	meta:
		name = "TList<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11051_0 {
	meta:
		name = "TList<Data.DBXMessageHandlerJSonServer.TPair<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler,Datasnap.DSService.TDSSessionEvent>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXMessageHandlerJSonServer.TPair<Data.DBXMessageHandlerJSonServer.TDBXJSonServerProtocolHandler,Datasnap.DSService.TDSSessionEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11286_0 {
	meta:
		name = "TList<Data.DBXMessageHandlerJSonServer.TPair<System.string,Datasnap.DSService.TDSSession>>.Delete"
		size = 8
		refs = "0003 TList<Data.DBXMessageHandlerJSonServer.TPair<System.string,Datasnap.DSService.TDSSession>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15946_0 {
	meta:
		name = "TList<Datasnap.DSClientMetadata.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSClientMetadata.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15801_0 {
	meta:
		name = "TList<Datasnap.DSClientMetadata.TPair<System.string,System.Classes.TStream>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSClientMetadata.TPair<System.string,System.Classes.TStream>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16277_0 {
	meta:
		name = "TList<Datasnap.DSClientRest.TDSRestClientCallback>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSClientRest.TDSRestClientCallback>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16451_0 {
	meta:
		name = "TList<Datasnap.DSClientRest.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSClientRest.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20390_0 {
	meta:
		name = "TList<Datasnap.DSCommonProxy.IDSProxyWriter>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSCommonProxy.IDSProxyWriter>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17397_0 {
	meta:
		name = "TList<Datasnap.DSHTTP.TDSHTTPClass>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTP.TDSHTTPClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17299_0 {
	meta:
		name = "TList<Datasnap.DSHTTP.TPair<System.string,Datasnap.DSHTTP.TDSHTTPClass>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTP.TPair<System.string,Datasnap.DSHTTP.TDSHTTPClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18391_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSCallbackItem>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSCallbackItem>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18083_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSCommandComplexParams>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSCommandComplexParams>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17761_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSExecutionResponse>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSExecutionResponse>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18136_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TDSSessionTunnelInfo>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TDSSessionTunnelInfo>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18438_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18534_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18293_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TPair<System.string,Datasnap.DSHTTPCommon.TDSCallbackItem>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TPair<System.string,Datasnap.DSHTTPCommon.TDSCallbackItem>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18767_0 {
	meta:
		name = "TList<Datasnap.DSHTTPCommon.TPair<System.string,Datasnap.DSService.TDSSession>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPCommon.TPair<System.string,Datasnap.DSService.TDSSession>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19068_0 {
	meta:
		name = "TList<Datasnap.DSHTTPServiceProxyDispatcher.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSHTTPServiceProxyDispatcher.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19427_0 {
	meta:
		name = "TList<Datasnap.DSProxyCpp.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyCpp.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19722_0 {
	meta:
		name = "TList<Datasnap.DSProxyCppRest.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyCppRest.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20010_0 {
	meta:
		name = "TList<Datasnap.DSProxyCsharpSilverlight.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyCsharpSilverlight.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20292_0 {
	meta:
		name = "TList<Datasnap.DSProxyDelphi.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyDelphi.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20818_0 {
	meta:
		name = "TList<Datasnap.DSProxyDelphiRest.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyDelphiRest.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20722_0 {
	meta:
		name = "TList<Datasnap.DSProxyDelphiRest.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyDelphiRest.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21046_0 {
	meta:
		name = "TList<Datasnap.DSProxyDispatcher.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyDispatcher.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21280_0 {
	meta:
		name = "TList<Datasnap.DSProxyFreePascal_iOS.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyFreePascal_iOS.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21567_0 {
	meta:
		name = "TList<Datasnap.DSProxyJavaAndroid.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyJavaAndroid.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21834_0 {
	meta:
		name = "TList<Datasnap.DSProxyJavaBlackBerry.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyJavaBlackBerry.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22126_0 {
	meta:
		name = "TList<Datasnap.DSProxyJavaScript.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyJavaScript.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22419_0 {
	meta:
		name = "TList<Datasnap.DSProxyObjectiveCiOS.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyObjectiveCiOS.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22986_0 {
	meta:
		name = "TList<Datasnap.DSProxyWriter.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyWriter.TPair<System.string,Datasnap.DSCommonProxy.IDSProxyWriter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22841_0 {
	meta:
		name = "TList<Datasnap.DSProxyWriter.TPair<System.string,System.Masks.TMask>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSProxyWriter.TPair<System.string,System.Masks.TMask>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23730_0 {
	meta:
		name = "TList<Datasnap.DSServer.TDSCallbackTunnel>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TDSCallbackTunnel>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23679_0 {
	meta:
		name = "TList<Datasnap.DSServer.TDSCallbackTunnelEvent>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TDSCallbackTunnelEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23781_0 {
	meta:
		name = "TList<Datasnap.DSServer.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TPair<System.string,Data.DBXJSONReflect.TConverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23879_0 {
	meta:
		name = "TList<Datasnap.DSServer.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TPair<System.string,Data.DBXJSONReflect.TReverterEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23975_0 {
	meta:
		name = "TList<Datasnap.DSServer.TPair<System.string,System.Classes.TStrings>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSServer.TPair<System.string,System.Classes.TStrings>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18187_0 {
	meta:
		name = "TList<Datasnap.DSService.TDBXRequestFilter>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TDBXRequestFilter>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25691_0 {
	meta:
		name = "TList<Datasnap.DSService.TDSSession>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TDSSession>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24874_0 {
	meta:
		name = "TList<Datasnap.DSService.TDSSessionEvent>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TDSSessionEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25078_0 {
	meta:
		name = "TList<Datasnap.DSService.TPair<System.Integer,Data.DBXCommon.TResultCommandHandler>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TPair<System.Integer,Data.DBXCommon.TResultCommandHandler>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24972_0 {
	meta:
		name = "TList<Datasnap.DSService.TPair<System.string,Datasnap.DSService.TDBXRequestFilter>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TPair<System.string,Datasnap.DSService.TDBXRequestFilter>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25319_0 {
	meta:
		name = "TList<Datasnap.DSService.TPair<System.string,Datasnap.DSService.TDSSession>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TPair<System.string,Datasnap.DSService.TDSSession>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25223_0 {
	meta:
		name = "TList<Datasnap.DSService.TPair<System.string,System.TObject>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TPair<System.string,System.TObject>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25176_0 {
	meta:
		name = "TList<Datasnap.DSService.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSService.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25593_0 {
	meta:
		name = "TList<Datasnap.DSTCPServerTransport.TPair<System.string,Datasnap.DSService.TDSSession>>.Delete"
		size = 8
		refs = "0003 TList<Datasnap.DSTCPServerTransport.TPair<System.string,Datasnap.DSService.TDSSession>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29695_0 {
	meta:
		name = "TList<GraphView.TGraphEdge>.Delete"
		size = 8
		refs = "0003 TList<GraphView.TGraphEdge>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29805_0 {
	meta:
		name = "TList<GraphView.TGraphNode>.Delete"
		size = 8
		refs = "0003 TList<GraphView.TGraphNode>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29750_0 {
	meta:
		name = "TList<GraphView.TObjectList<GraphView.TGraphEdge>>.Delete"
		size = 8
		refs = "0003 TList<GraphView.TObjectList<GraphView.TGraphEdge>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30567_0 {
	meta:
		name = "TList<IBDatabase.TIBBase>.Delete"
		size = 8
		refs = "0003 TList<IBDatabase.TIBBase>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30669_0 {
	meta:
		name = "TList<IBDatabase.TIBDatabase>.Delete"
		size = 8
		refs = "0003 TList<IBDatabase.TIBDatabase>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30618_0 {
	meta:
		name = "TList<IBDatabase.TIBTransaction>.Delete"
		size = 8
		refs = "0003 TList<IBDatabase.TIBTransaction>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31360_0 {
	meta:
		name = "TList<IBIntf.IGDSLibrary>.Delete"
		size = 8
		refs = "0003 TList<IBIntf.IGDSLibrary>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31262_0 {
	meta:
		name = "TList<IBIntf.TPair<System.string,IBIntf.IGDSLibrary>>.Delete"
		size = 8
		refs = "0003 TList<IBIntf.TPair<System.string,IBIntf.IGDSLibrary>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40380_0 {
	meta:
		name = "TList<IPPeerAPI.IIPContext>.Delete"
		size = 8
		refs = "0003 TList<IPPeerAPI.IIPContext>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_42987_0 {
	meta:
		name = "TList<IPPeerAPI.TDictionary<System.TGUID,System.TClass>>.Delete"
		size = 8
		refs = "0003 TList<IPPeerAPI.TDictionary<System.TGUID,System.TClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_42744_0 {
	meta:
		name = "TList<IPPeerAPI.TPair<System.TGUID,System.TClass>>.Delete"
		size = 8
		refs = "0003 TList<IPPeerAPI.TPair<System.TGUID,System.TClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_42889_0 {
	meta:
		name = "TList<IPPeerAPI.TPair<System.string,System.Generics.Collections.TDictionary<System.TGUID,System.TClass>>>.Delete"
		size = 8
		refs = "0003 TList<IPPeerAPI.TPair<System.string,System.Generics.Collections.TDictionary<System.TGUID,System.TClass>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43034_0 {
	meta:
		name = "TList<IPPeerAPI.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<IPPeerAPI.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40333_0 {
	meta:
		name = "TList<IdContext.TIdContext>.Delete"
		size = 8
		refs = "0003 TList<IdContext.TIdContext>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40282_0 {
	meta:
		name = "TList<IndyPeerImpl.TPair<IdContext.TIdContext,IPPeerAPI.IIPContext>>.Delete"
		size = 8
		refs = "0003 TList<IndyPeerImpl.TPair<IdContext.TIdContext,IPPeerAPI.IIPContext>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40186_0 {
	meta:
		name = "TList<IndyPeerImpl.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<IndyPeerImpl.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50051_0 {
	meta:
		name = "TList<Soap.WSDLLookup.TPair<System.string,System.Variant>>.Delete"
		size = 8
		refs = "0003 TList<Soap.WSDLLookup.TPair<System.string,System.Variant>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51236_0 {
	meta:
		name = "TList<SyncController.TPair<System.Bindings.EvalProtocol.ILocation,SyncController.TPair<System.TObject,System.string>>>.Delete"
		size = 8
		refs = "0003 TList<SyncController.TPair<System.Bindings.EvalProtocol.ILocation,SyncController.TPair<System.TObject,System.string>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51091_0 {
	meta:
		name = "TList<SyncController.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<SyncController.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51334_0 {
	meta:
		name = "TList<SyncController.TPair<System.TObject,System.string>>.Delete"
		size = 8
		refs = "0003 TList<SyncController.TPair<System.TObject,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30847_0 {
	meta:
		name = "TList<System.AnsiString>.Delete"
		size = 8
		refs = "0003 TList<System.AnsiString>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51707_0 {
	meta:
		name = "TList<System.Bindings.CustomScope.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.CustomScope.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54628_0 {
	meta:
		name = "TList<System.Bindings.CustomScope.TScopeClass>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.CustomScope.TScopeClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_51287_0 {
	meta:
		name = "TList<System.Bindings.EvalProtocol.ILocation>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalProtocol.ILocation>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53173_0 {
	meta:
		name = "TList<System.Bindings.EvalProtocol.IScope>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalProtocol.IScope>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53026_0 {
	meta:
		name = "TList<System.Bindings.EvalProtocol.ISubscription>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalProtocol.ISubscription>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52122_0 {
	meta:
		name = "TList<System.Bindings.EvalProtocol.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalProtocol.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52843_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TFunc<System.Rtti.TValue,System.Rtti.TValue>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TFunc<System.Rtti.TValue,System.Rtti.TValue>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52588_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TOverload>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TOverload>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52745_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TPair<System.Bindings.EvalSys.TValueConverter.TConvPair,System.SysUtils.TFunc<System.Rtti.TValue,System.Rtti.TValue>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TPair<System.Bindings.EvalSys.TValueConverter.TConvPair,System.SysUtils.TFunc<System.Rtti.TValue,System.Rtti.TValue>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52647_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_52796_0 {
	meta:
		name = "TList<System.Bindings.EvalSys.TValueConverter.TConvPair>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.EvalSys.TValueConverter.TConvPair>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53220_0 {
	meta:
		name = "TList<System.Bindings.Evaluator.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Evaluator.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57712_0 {
	meta:
		name = "TList<System.Bindings.Expression.TBindingExpression>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Expression.TBindingExpression>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53603_0 {
	meta:
		name = "TList<System.Bindings.Expression.TPair<System.TObject,System.string>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Expression.TPair<System.TObject,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53748_0 {
	meta:
		name = "TList<System.Bindings.Expression.TPair<System.string,System.Bindings.Expression.TBindingExpression>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Expression.TPair<System.string,System.Bindings.Expression.TBindingExpression>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54122_0 {
	meta:
		name = "TList<System.Bindings.ExpressionDefaults.TPair<System.TObject,System.string>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ExpressionDefaults.TPair<System.TObject,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54267_0 {
	meta:
		name = "TList<System.Bindings.ExpressionDefaults.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ExpressionDefaults.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56113_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55825_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.string,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.string,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56256_0 {
	meta:
		name = "TList<System.Bindings.Graph.TDictionary<System.string,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TDictionary<System.string,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56307_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.Bindings.EvalProtocol.ILocation,System.Generics.Collections.TPair<System.TObject,System.string>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.Bindings.EvalProtocol.ILocation,System.Generics.Collections.TPair<System.TObject,System.string>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56064_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Generics.Collections.TDictionary<System.IInterface,System.Pointer>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Generics.Collections.TDictionary<System.IInterface,System.Pointer>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55872_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55484_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.Bindings.Expression.TBindingExpression,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55919_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55727_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.TObject,System.Generics.Collections.TDictionary<System.string,System.Int64>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.TObject,System.Generics.Collections.TDictionary<System.string,System.Int64>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56207_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.TObject,System.Generics.Collections.TDictionary<System.string,System.Integer>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.TObject,System.Generics.Collections.TDictionary<System.string,System.Integer>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56405_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.TObject,System.string>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.TObject,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55582_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.string,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.string,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56160_0 {
	meta:
		name = "TList<System.Bindings.Graph.TPair<System.string,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Graph.TPair<System.string,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56838_0 {
	meta:
		name = "TList<System.Bindings.Helper.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Helper.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57046_0 {
	meta:
		name = "TList<System.Bindings.Manager.TBindingManager>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Manager.TBindingManager>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58607_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58460_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58219_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58558_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Bindings.ManagerDefaults.TDictionary<System.IInterface,System.Pointer>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58507_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58266_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.Bindings.Expression.TBindingExpression,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57831_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58411_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.TObject,System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.TObject,System.Bindings.ManagerDefaults.TDictionary<System.string,System.Int64>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58121_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.TObject,System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.TObject,System.Bindings.ManagerDefaults.TDictionary<System.string,System.Integer>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58315_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.string,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.string,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57976_0 {
	meta:
		name = "TList<System.Bindings.ManagerDefaults.TPair<System.string,System.Integer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ManagerDefaults.TPair<System.string,System.Integer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59139_0 {
	meta:
		name = "TList<System.Bindings.Methods.TMethodDescription>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Methods.TMethodDescription>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59041_0 {
	meta:
		name = "TList<System.Bindings.Methods.TPair<System.string,System.Bindings.Methods.TMethodDescription>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Methods.TPair<System.string,System.Bindings.Methods.TMethodDescription>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59186_0 {
	meta:
		name = "TList<System.Bindings.Methods.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Methods.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59694_0 {
	meta:
		name = "TList<System.Bindings.ObjEval.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.ObjEval.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59915_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60284_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TBindingOutput.TLocationRec>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TBindingOutput.TLocationRec>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60109_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TConvertPair>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TConvertPair>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60850_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TConverterDescription>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TConverterDescription>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60752_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61005_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.Bindings.EvalProtocol.ILocation,System.Generics.Collections.TPair<System.TObject,System.string>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.Bindings.EvalProtocol.ILocation,System.Generics.Collections.TPair<System.TObject,System.string>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61258_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.Bindings.Expression.TBindingExpression,System.Int64>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60799_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.Bindings.Outputs.TConvertPair,System.Bindings.Outputs.TConverterDescription>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.Bindings.Outputs.TConvertPair,System.Bindings.Outputs.TConverterDescription>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60950_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.Generics.Collections.TList<System.Bindings.Outputs.TConvertPair>,System.Bindings.Outputs.TConverterDescription>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.Generics.Collections.TList<System.Bindings.Outputs.TConvertPair>,System.Bindings.Outputs.TConverterDescription>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61103_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.TObject,System.string>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.TObject,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60701_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.string,System.Generics.Collections.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.string,System.Generics.Collections.TList<System.Bindings.Outputs.TBindingCallbackFactory.TBindingCallback>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60901_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.string,System.Generics.Collections.TPair<System.Generics.Collections.TList<System.Bindings.Outputs.TConvertPair>,System.Bindings.Outputs.TConverterDescription>>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.string,System.Generics.Collections.TPair<System.Generics.Collections.TList<System.Bindings.Outputs.TConvertPair>,System.Bindings.Outputs.TConverterDescription>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61162_0 {
	meta:
		name = "TList<System.Bindings.Outputs.TPair<System.string,System.IInterface>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Outputs.TPair<System.string,System.IInterface>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61695_0 {
	meta:
		name = "TList<System.Bindings.Search.TPair<System.IInterface,System.Pointer>>.Delete"
		size = 8
		refs = "0003 TList<System.Bindings.Search.TPair<System.IInterface,System.Pointer>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64885_0 {
	meta:
		name = "TList<System.Boolean>.Delete"
		size = 8
		refs = "0003 TList<System.Boolean>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2496_0 {
	meta:
		name = "TList<System.Classes.IObserver>.Delete"
		size = 8
		refs = "0003 TList<System.Classes.IObserver>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88489_0 {
	meta:
		name = "TList<System.Classes.TComponent>.Delete"
		size = 8
		refs = "0003 TList<System.Classes.TComponent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3151_0 {
	meta:
		name = "TList<System.Classes.TNotifyEvent>.Delete"
		size = 8
		refs = "0003 TList<System.Classes.TNotifyEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15899_0 {
	meta:
		name = "TList<System.Classes.TStream>.Delete"
		size = 8
		refs = "0003 TList<System.Classes.TStream>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24024_0 {
	meta:
		name = "TList<System.Classes.TStrings>.Delete"
		size = 8
		refs = "0003 TList<System.Classes.TStrings>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63630_0 {
	meta:
		name = "TList<System.DateUtils.TLocalTimeZone.TYearlyChanges>.Delete"
		size = 8
		refs = "0003 TList<System.DateUtils.TLocalTimeZone.TYearlyChanges>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63532_0 {
	meta:
		name = "TList<System.DateUtils.TPair<System.Word,System.DateUtils.TLocalTimeZone.TYearlyChanges>>.Delete"
		size = 8
		refs = "0003 TList<System.DateUtils.TPair<System.Word,System.DateUtils.TLocalTimeZone.TYearlyChanges>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_64787_0 {
	meta:
		name = "TList<System.DebugUtils.TPair<System.string,System.Boolean>>.Delete"
		size = 8
		refs = "0003 TList<System.DebugUtils.TPair<System.string,System.Boolean>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54530_0 {
	meta:
		name = "TList<System.Generics.Collections.TPair<System.TClass,System.Bindings.CustomScope.TScopeClass>>.Delete"
		size = 8
		refs = "0003 TList<System.Generics.Collections.TPair<System.TClass,System.Bindings.CustomScope.TScopeClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61746_0 {
	meta:
		name = "TList<System.IInterface>.Delete"
		size = 8
		refs = "0003 TList<System.IInterface>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61356_0 {
	meta:
		name = "TList<System.Int64>.Delete"
		size = 8
		refs = "0003 TList<System.Int64>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24559_0 {
	meta:
		name = "TList<System.Integer>.Delete"
		size = 8
		refs = "0003 TList<System.Integer>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22939_0 {
	meta:
		name = "TList<System.Masks.TMask>.Delete"
		size = 8
		refs = "0003 TList<System.Masks.TMask>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61793_0 {
	meta:
		name = "TList<System.Pointer>.Delete"
		size = 8
		refs = "0003 TList<System.Pointer>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67386_0 {
	meta:
		name = "TList<System.Rtti.TMethodImplementation.TParamLoc>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TMethodImplementation.TParamLoc>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68115_0 {
	meta:
		name = "TList<System.Rtti.TPair<System.Pointer,System.Rtti.TRttiObject>>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TPair<System.Pointer,System.Rtti.TRttiObject>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68282_0 {
	meta:
		name = "TList<System.Rtti.TPair<System.TypInfo.PTypeInfo,System.string>>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TPair<System.TypInfo.PTypeInfo,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68425_0 {
	meta:
		name = "TList<System.Rtti.TPair<System.string,System.TypInfo.PTypeInfo>>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TPair<System.string,System.TypInfo.PTypeInfo>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68003_0 {
	meta:
		name = "TList<System.Rtti.TRttiField>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiField>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68055_0 {
	meta:
		name = "TList<System.Rtti.TRttiManagedField>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiManagedField>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67950_0 {
	meta:
		name = "TList<System.Rtti.TRttiMethod>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiMethod>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68213_0 {
	meta:
		name = "TList<System.Rtti.TRttiObject>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiObject>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67898_0 {
	meta:
		name = "TList<System.Rtti.TRttiProperty>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TRttiProperty>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67563_0 {
	meta:
		name = "TList<System.Rtti.TVirtualInterface.TImplInfo>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TVirtualInterface.TImplInfo>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67508_0 {
	meta:
		name = "TList<System.Rtti.TVirtualMethodInterceptor.TInterceptInfo>.Delete"
		size = 8
		refs = "0003 TList<System.Rtti.TVirtualMethodInterceptor.TInterceptInfo>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_60406_0 {
	meta:
		name = "TList<System.SysUtils.TProc<System.Rtti.TValue>>.Delete"
		size = 8
		refs = "0003 TList<System.SysUtils.TProc<System.Rtti.TValue>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86617_0 {
	meta:
		name = "TList<System.TClass>.Delete"
		size = 8
		refs = "0003 TList<System.TClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_67841_0 {
	meta:
		name = "TList<System.TCustomAttribute>.Delete"
		size = 8
		refs = "0003 TList<System.TCustomAttribute>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_42795_0 {
	meta:
		name = "TList<System.TGUID>.Delete"
		size = 8
		refs = "0003 TList<System.TGUID>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55778_0 {
	meta:
		name = "TList<System.TObject>.Delete"
		size = 8
		refs = "0003 TList<System.TObject>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_68331_0 {
	meta:
		name = "TList<System.TypInfo.PTypeInfo>.Delete"
		size = 8
		refs = "0003 TList<System.TypInfo.PTypeInfo>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87737_0 {
	meta:
		name = "TList<System.Types.TPoint>.Delete"
		size = 8
		refs = "0003 TList<System.Types.TPoint>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50102_0 {
	meta:
		name = "TList<System.Variant>.Delete"
		size = 8
		refs = "0003 TList<System.Variant>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_63583_0 {
	meta:
		name = "TList<System.Word>.Delete"
		size = 8
		refs = "0003 TList<System.Word>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71778_0 {
	meta:
		name = "TList<System.Zip.TPair<System.Zip.TStreamConstructor,System.Zip.TStreamConstructor>>.Delete"
		size = 8
		refs = "0003 TList<System.Zip.TPair<System.Zip.TStreamConstructor,System.Zip.TStreamConstructor>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71680_0 {
	meta:
		name = "TList<System.Zip.TPair<System.Zip.TZipCompression,System.Generics.Collections.TPair<System.Zip.TStreamConstructor,System.Zip.TStreamConstructor>>>.Delete"
		size = 8
		refs = "0003 TList<System.Zip.TPair<System.Zip.TZipCompression,System.Generics.Collections.TPair<System.Zip.TStreamConstructor,System.Zip.TStreamConstructor>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71731_0 {
	meta:
		name = "TList<System.Zip.TZipCompression>.Delete"
		size = 8
		refs = "0003 TList<System.Zip.TZipCompression>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_71633_0 {
	meta:
		name = "TList<System.Zip.TZipHeader>.Delete"
		size = 8
		refs = "0003 TList<System.Zip.TZipHeader>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21095_0 {
	meta:
		name = "TList<System.string>.Delete"
		size = 8
		refs = "0003 TList<System.string>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88859_0 {
	meta:
		name = "TList<Vcl.Controls.TControl>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Controls.TControl>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89264_0 {
	meta:
		name = "TList<Vcl.Controls.TCustomGestureCollectionItem>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Controls.TCustomGestureCollectionItem>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88741_0 {
	meta:
		name = "TList<Vcl.Controls.TCustomGestureManager>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Controls.TCustomGestureManager>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_78601_0 {
	meta:
		name = "TList<Vcl.Direct2D.TDirect2DGraphicsObject>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Direct2D.TDirect2DGraphicsObject>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86664_0 {
	meta:
		name = "TList<Vcl.Styles.TList<Vcl.Themes.TStyleHookClass>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Styles.TList<Vcl.Themes.TStyleHookClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86417_0 {
	meta:
		name = "TList<Vcl.Styles.TPair<System.Classes.TComponent,Vcl.Themes.TStyleHook>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Styles.TPair<System.Classes.TComponent,Vcl.Themes.TStyleHook>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86566_0 {
	meta:
		name = "TList<Vcl.Styles.TPair<System.TClass,System.Generics.Collections.TList<Vcl.Themes.TStyleHookClass>>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Styles.TPair<System.TClass,System.Generics.Collections.TList<Vcl.Themes.TStyleHookClass>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87635_0 {
	meta:
		name = "TList<Vcl.Themes.TCustomStyleEngineClass>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TCustomStyleEngineClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87686_0 {
	meta:
		name = "TList<Vcl.Themes.TCustomStyleServices>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TCustomStyleServices>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87886_0 {
	meta:
		name = "TList<Vcl.Themes.TList<Vcl.Themes.TStyleHookClass>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TList<Vcl.Themes.TStyleHookClass>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87788_0 {
	meta:
		name = "TList<Vcl.Themes.TPair<System.TClass,System.Generics.Collections.TList<Vcl.Themes.TStyleHookClass>>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TPair<System.TClass,System.Generics.Collections.TList<Vcl.Themes.TStyleHookClass>>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87933_0 {
	meta:
		name = "TList<Vcl.Themes.TPair<System.string,Vcl.Themes.TStyleManager.TSourceInfo>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TPair<System.string,Vcl.Themes.TStyleManager.TSourceInfo>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_86515_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleHook>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleHook>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87390_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleHookClass>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleHookClass>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88031_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleManager.TSourceInfo>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleManager.TSourceInfo>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_87584_0 {
	meta:
		name = "TList<Vcl.Themes.TStyleManager.TStyleClassDescriptor>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Themes.TStyleManager.TStyleClassDescriptor>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88536_0 {
	meta:
		name = "TList<Vcl.Touch.GestureCtrls.TGestureProviderChangeEvent>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.GestureCtrls.TGestureProviderChangeEvent>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88438_0 {
	meta:
		name = "TList<Vcl.Touch.GestureCtrls.TPair<System.Classes.TComponent,Vcl.Touch.GestureCtrls.TGestureProviderChangeEvent>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.GestureCtrls.TPair<System.Classes.TComponent,Vcl.Touch.GestureCtrls.TGestureProviderChangeEvent>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89012_0 {
	meta:
		name = "TList<Vcl.Touch.GestureMgr.TGestureCollection>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.GestureMgr.TGestureCollection>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_88961_0 {
	meta:
		name = "TList<Vcl.Touch.GestureMgr.TPair<Vcl.Controls.TControl,Vcl.Touch.GestureMgr.TGestureCollection>>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.GestureMgr.TPair<Vcl.Controls.TControl,Vcl.Touch.GestureMgr.TGestureCollection>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89315_0 {
	meta:
		name = "TList<Vcl.Touch.Gestures.TGesturePoint>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.Gestures.TGesturePoint>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89495_0 {
	meta:
		name = "TList<Vcl.Touch.Keyboard.TCustomKeyboardButton>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.Keyboard.TCustomKeyboardButton>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89546_0 {
	meta:
		name = "TList<Vcl.Touch.Keyboard.TCustomTouchKeyboard.TChangeState>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.Keyboard.TCustomTouchKeyboard.TChangeState>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89597_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TKeyData>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TKeyData>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89828_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TKeyboardLanguage>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TKeyboardLanguage>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89726_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TVirtualKey>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TVirtualKey>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89879_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TVirtualKeyLayout>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TVirtualKeyLayout>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_89777_0 {
	meta:
		name = "TList<Vcl.Touch.KeyboardTypes.TVirtualKeys>.Delete"
		size = 8
		refs = "0003 TList<Vcl.Touch.KeyboardTypes.TVirtualKeys>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_96344_0 {
	meta:
		name = "TList<Web.WebFileDispatcher.TPair<System.string,System.string>>.Delete"
		size = 8
		refs = "0003 TList<Web.WebFileDispatcher.TPair<System.string,System.string>>.DoDelete"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14435_0 {
	meta:
		name = "TSQLConnection.CommitFreeAndNil"
		size = 8
		refs = "0003 TSQLConnection.EndFreeAndNilTransaction"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_81003_0 {
	meta:
		name = "TStringGrid.GetCols"
		size = 8
		refs = "0003 TStringGrid.EnsureColRow"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "TTable.LockTable"
		size = 8
		refs = "0003 TTable.SetTableLock"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90009_0 {
	meta:
		name = "TValueListStrings.GetItemProp"
		size = 8
		refs = "0003 TValueListStrings.FindItemProp"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5747_0 {
	meta:
		name = "TVariantField.SetVarValue"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50171_0 {
	meta:
		name = "TWSDLView.SetDesignState"
		size = 8
		refs = "0003 TComponent.SetDesigning"
	strings:
		$1 = { B1 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "TDatabase.SetDatabaseName"
		size = 75
		refs = "0015 @UStrAsg 0025 @UStrEqual 002e TDatabase.CheckInactive 0037 TDatabase.ValidateName"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 02 74 10 8D 83 98 00 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 8B 83 98 00 00 00 8B D6 E8 ?? ?? ?? ?? 74 1D 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8D 83 98 00 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "TDatabase.SetDatabaseType"
		size = 36
		refs = "000c TDatabase.CheckInactive 0019 @UStrAsg"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B C7 E8 ?? ?? ?? ?? 8D 87 9C 00 00 00 8B D6 E8 ?? ?? ?? ?? 88 5F 75 5F 5E 5B C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "TDatabase.SetDirectory"
		size = 125
		refs = "0012 TDatabase.SetDirectory 0031 @LStrFromUStr 003c StrToOem 0044 @LStrToPChar 004b DbiSetDirectory 0050 Check 006a @LStrArrayClr 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B B3 80 00 00 00 85 F6 74 2E 8D 45 F8 8B D7 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 8D 55 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TDatabase.SetHandle"
		size = 222
		refs = "0015 TDatabase.SetHandle 002f TCustomConnection.Close 0043 DbiGetObjFromObj 0048 Check 0050 TDatabase.CheckDatabaseName 005a TDatabase.CheckSessionName 0068 TSession.GetHandle 0075 SDatabaseHandleSet 007a LoadResString 0085 DatabaseError 0096 TDatabase.SetDatabaseFlags 009e TDatabase.LoadLocale 00b1 TSession.DBNotification 00cd @UStrClr 00d3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 C9 89 4D F4 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 48 84 C0 74 08 8B 45 FC E8 ?? ?? ?? ?? 85 DB 0F 84 81 00 00 00 8D 45 F8 50 6A 02 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 74 18 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 FC 89 98 80 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8D 4D FC 8B 45 FC 8B 80 88 00 00 00 33 D2 E8 ?? ?? ?? ?? 8B 45 FC C6 40 77 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TDatabase.SetKeepConnection"
		size = 24
		refs = "0013 TCustomConnection.Close"
	strings:
		$1 = { 3A 50 71 74 12 88 50 71 84 D2 75 0B 83 78 7C 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TDatabase.SetParams"
		size = 29
		refs = "0009 TDatabase.CheckInactive"
	strings:
		$1 = { 56 57 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D7 8B 86 8C 00 00 00 8B 08 FF 51 08 5F 5E C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TDatabase.SetSessionName"
		size = 91
		refs = "0015 @UStrAsg 001f TDatabase.CheckInactive 002c @UStrEqual 0054 TDatabase.CheckSessionName"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 02 74 10 8D 83 94 00 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 E8 ?? ?? ?? ?? 8B 83 94 00 00 00 8B D6 E8 ?? ?? ?? ?? 74 26 8D 83 94 00 00 00 8B D6 E8 ?? ?? ?? ?? F6 43 1C 08 74 0A 33 C0 89 83 88 00 00 00 EB 09 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TDatabase.SetTraceFlags"
		size = 50
		refs = "002b DbiSetProp"
	strings:
		$1 = { 53 51 66 89 14 24 8B D8 8B C3 8B 10 FF 52 48 84 C0 74 1C 80 7B 76 00 74 16 0F B7 04 24 50 68 07 00 04 04 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TDatabase.SetExclusive"
		size = 19
		refs = "0009 TDatabase.CheckInactive"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 88 5E 7A 5E 5B C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TDatabase.SetReadOnly"
		size = 19
		refs = "0009 TDatabase.CheckInactive"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 88 5E 7B 5E 5B C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TDatabase.StartTransaction"
		size = 130
		refs = "0012 TDatabase.StartTransaction 001f TDatabase.CheckActive 0033 SLocalTransDirty 0038 LoadResString 0042 DatabaseError 0057 DbiBeginTran 005c Check 0071 @UStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 80 7B 76 00 75 1D 80 7B 70 00 74 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B D3 E8 ?? ?? ?? ?? 8D 45 FC 50 0F B6 43 70 50 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TDatabase.ValidateName"
		size = 172
		refs = "0016 TDatabase.ValidateName 0036 TSession.FindDatabase 0062 SDuplicateDatabaseName 0067 LoadResString 007d DatabaseErrorFmt 0084 TObject.Free 0099 @UStrClr 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D FC 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 64 83 BB 88 00 00 00 00 74 5B 8B D7 8B 83 88 00 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 74 48 3B DE 74 44 80 7E 79 00 74 06 80 7B 79 00 75 38 80 7E 72 00 74 06 83 7E 7C 00 74 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 7D F4 C6 45 F8 11 8D 55 F4 33 C9 58 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TDatabase.FlushSchemaCache"
		size = 117
		refs = "000f TDatabase.FlushSchemaCache 0035 @LStrFromUStr 003d @LStrToPChar 004a DbiSchemaCacheFlush 004f Check 0064 @LStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 48 84 C0 74 2F 80 7B 76 00 74 29 8D 45 FC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TBDEDataSet.Create"
		size = 86
		refs = "000a @ClassCreate 0017 TDataSet.Create 001c DefaultSession 0026 TBDEDataSet.SetLocale 0032 _DV_TNestedTable 0043 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 44 8B C6 E8 ?? ?? ?? ?? C6 86 CD 01 00 00 01 A1 ?? ?? ?? ?? 89 86 98 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TBDEDataSet.Destroy"
		size = 68
		refs = "0003 @BeforeDestruction 0012 TDataSet.Destroy 0021 @FreeMem 0032 TBDEDataSet.SetUpdateObject 003d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 86 20 02 00 00 85 C0 74 0D E8 ?? ?? ?? ?? 33 C0 89 86 20 02 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "TBDEDataSet.OpenCursor"
		size = 180
		refs = "0015 TBDEDataSet.OpenCursor 0044 FreeTimer 004c SHandleError 0051 LoadResString 005b _DV_ENoResultSet 0060 Exception.Create 0065 @RaiseExcept 0075 DbiGetLdObj 0084 TBDEDataSet.SetLocale 008d TDataSet.OpenCursor 00a2 @UStrClr 00a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BE 80 01 00 00 00 75 10 8B C6 8B 10 FF 92 C0 02 00 00 89 86 80 01 00 00 83 BE 80 01 00 00 00 75 28 B0 01 E8 ?? ?? ?? ?? 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC 50 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 0A 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TBDEDataSet.CloseCursor"
		size = 62
		refs = "0006 TDataSet.CloseCursor 000b DefaultSession 0015 TBDEDataSet.SetLocale"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 44 8B C3 E8 ?? ?? ?? ?? 83 BB 80 01 00 00 00 74 12 8B C3 8B 10 FF 92 C4 02 00 00 33 C0 89 83 80 01 00 00 33 C0 89 83 24 02 00 00 5B C3 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TBDEDataSet.DestroyHandle"
		size = 31
		refs = "000d DbiRelRecordLock 0019 DbiCloseCursor"
	strings:
		$1 = { 53 8B D8 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 8D 83 80 01 00 00 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TBDEDataSet.GetHandle"
		size = 7
	strings:
		$1 = { 8B 80 80 01 00 00 C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TBDEDataSet.InternalInitFieldDefs"
		size = 556
		refs = "0017 TBDEDataSet.InternalInitFieldDefs 0030 DbiGetCursorProps 0058 SetBoolProp 0086 _Dn_TBits 008b TObject.Create 00ac GetIntProp 00bb TBits.SetSize 00f2 DbiGetVchkDesc 0117 TBits.SetBit 012c TFieldDescList 0131 @DynArraySetLength 0144 DbiGetFieldDescs 015c TCollection.Clear 017a TBDEDataSet.AddFieldDesc 01bb TFieldDefs.GetFieldDef 01d7 TFieldDef.SetAttributes 01f2 TObject.Free 01f8 @HandleFinally 0215 @DynArrayClear"
	strings:
		$1 = { 55 8B EC 81 C4 7C F9 FF FF 53 56 57 33 D2 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 7E F9 FF FF 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 0F B7 BD A5 FA FF FF 33 C0 89 45 EC 8B 43 40 80 78 3C 00 74 3A 8B 83 80 01 00 00 83 C9 FF BA 04 00 05 04 E8 ?? ?? ?? ?? 84 C0 74 23 8D 85 7E F9 FF FF 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 0F B7 85 A5 FA FF FF 8B D0 2B D7 89 55 EC 8B F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 83 80 01 00 00 BA 0F 00 05 00 E8 ?? ?? ?? ?? 85 C0 7E 0D 8D 50 01 8B 45 F0 E8 ?? ?? ?? ?? EB 0B 8D 57 01 8B 45 F0 E8 ?? ?? ?? ?? 0F B7 B5 AF FA FF FF 85 F6 7E 4A C7 45 F8 01 00 00 00 8D 85 29 FB FF FF 50 0F B7 45 F8 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 83 BD 2B FB FF FF 00 74 1B 66 83 BD 31 FB FF FF 00 75 11 0F B7 95 29 FB FF FF B1 01 8B 45 F0 E8 ?? ?? ?? ?? FF 45 F8 4E 75 BD 57 8D 45 FC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 8B 83 A0 00 00 00 89 45 F4 8B 45 F4 48 89 45 F8 8B 43 40 E8 ?? ?? ?? ?? 3B 7D F8 7E 1E 8D 45 F4 50 8B 45 F0 50 8B 43 40 50 8D 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 3B 7D F8 7F E2 8B 43 40 80 78 3C 00 74 55 8B 83 80 01 00 00 33 C9 BA 04 00 05 04 E8 ?? ?? ?? ?? 83 7D EC 00 7E 3D 8B C7 2B 45 EC 8B F7 4E 2B F0 7C 31 46 89 45 F8 8B 43 40 8B 55 F8 E8 ?? ?? ?? ?? 0F B6 40 26 0A 05 ?? ?? ?? ?? 50 8B 43 40 8B 55 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? FF 45 F8 4E 75 D3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5F 5E 5B 8B E5 5D C3 01 00 00 00 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "TBDEDataSet.GetObjectTypeNames"
		size = 277
		refs = "000f TFields.GetCount 0026 TFields.GetField 002c _Dn_TObjectField 0031 @IsClass 0074 DbiGetProp 0095 @UStrFromArray 00eb TBDEDataSet.GetObjectTypeNames"
	strings:
		$1 = { 53 56 57 55 83 C4 D8 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 0F 8C EF 00 00 00 47 33 F6 8B D6 8B C5 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 C8 00 00 00 8B D6 8B C5 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 10 FF 92 A8 00 00 00 66 89 44 24 06 8D 44 24 04 50 6A 22 8D 44 24 0E 50 68 11 00 05 00 8B 44 24 10 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 1C 66 83 7C 24 04 00 76 14 8D 83 F8 00 00 00 8D 54 24 08 B9 20 00 00 00 E8 ?? ?? ?? ?? 0F B6 43 48 04 E6 2C 02 73 62 80 7B 48 1B 75 48 8B 04 24 80 B8 B2 00 00 00 00 74 3C 8B C3 8B 10 FF 92 34 01 00 00 33 D2 E8 ?? ?? ?? ?? 80 78 48 1A 75 25 8B C3 8B 10 FF 92 34 01 00 00 33 D2 E8 ?? ?? ?? ?? 8B 10 FF 92 34 01 00 00 8B D0 8B 04 24 E8 ?? ?? ?? ?? EB 14 8B C3 8B 10 FF 92 34 01 00 00 8B D0 8B 04 24 E8 ?? ?? ?? ?? 46 4F 0F 85 14 FF FF FF 83 C4 28 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "TBDEDataSet.InternalOpen"
		size = 425
		refs = "001b DbiBeginDelayedUpdates 0020 Check 002d DbiGetCursorProps 006f TBDEDataSet.HasConstraints 0097 TBDEDataSet.ConstraintCallBack 00a6 DbiBeginConstraintLayer 00c5 TFieldDefs.Update 00cc TBDEDataSet.GetIndexInfo 00fe TBDEDataSet.GetObjectTypeNames 0107 TBDEDataSet.InitBufferPointers 0119 TBDEDataSet.AllocCachedUpdateBuffers 0120 TBDEDataSet.UpdateCallbackRequired 0129 TBDEDataSet.SetupCallBack 0130 TBDEDataSet.AllocKeyBuffers 013c DbiSetToBegin 0165 TBDEDataSet.CreateExprFilter 017a TBDEDataSet.RecordFilter 0186 TBDEDataSet.CreateFuncFilter 019c TBDEDataSet.ActivateFilters"
	strings:
		$1 = { 53 56 81 C4 54 FE FF FF 8B F0 80 BE CA 01 00 00 00 74 11 8D 86 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 54 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 0F B7 84 24 2B 01 00 00 66 89 86 00 02 00 00 0F B7 84 24 35 01 00 00 89 46 6C 83 BC 24 39 01 00 00 00 75 0B 66 83 BC 24 89 01 00 00 00 74 04 33 C0 EB 02 B0 01 88 86 CC 01 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C6 8B 10 FF 92 5C 01 00 00 84 C0 75 04 33 DB EB 02 B3 01 88 9E 0A 02 00 00 84 DB 74 1A 56 B8 ?? ?? ?? ?? 50 8D 86 80 01 00 00 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 84 24 43 01 00 00 88 86 F4 01 00 00 8B 46 40 C6 40 20 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 80 BE AE 00 00 00 00 74 0A 8B C6 8B 10 FF 92 D8 00 00 00 B2 01 8B C6 8B 08 FF 91 B4 00 00 00 80 BE B1 00 00 00 00 74 0A 8B 56 38 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 80 BE CA 01 00 00 00 74 19 B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 D0 02 00 00 83 BE 80 00 00 00 00 74 1C 6A 00 0F B6 8E A4 00 00 00 8B 96 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 86 9C 01 00 00 66 83 BE 72 01 00 00 00 74 17 BA ?? ?? ?? ?? B9 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 86 A0 01 00 00 80 BE B0 00 00 00 00 74 07 8B C6 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TBDEDataSet.InternalClose"
		size = 166
		refs = "0016 TBDEDataSet.FreeKeyBuffers 0028 TBDEDataSet.SetupCallBack 0031 TBDEDataSet.AllocCachedUpdateBuffers 0046 DbiEndConstraintLayer 005b DbiEndDelayedUpdates"
	strings:
		$1 = { 53 8B D8 33 C0 89 83 A0 01 00 00 33 C0 89 83 9C 01 00 00 8B C3 E8 ?? ?? ?? ?? 80 BB CA 01 00 00 00 74 3C 33 D2 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 80 BB 0A 02 00 00 00 74 0C 8D 83 80 01 00 00 50 E8 ?? ?? ?? ?? 83 BB 80 01 00 00 00 74 0C 8D 83 80 01 00 00 50 E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 91 B4 00 00 00 80 BB AE 00 00 00 00 74 0A 8B C3 8B 10 FF 92 EC 00 00 00 33 C0 89 83 F8 01 00 00 66 C7 83 CE 01 00 00 00 00 C6 83 C8 01 00 00 00 C6 83 C9 01 00 00 00 C6 83 CC 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TBDEDataSet.IsCursorOpen"
		size = 11
		altNames = "TTeeDataSet.IsCursorOpen"
	strings:
		$1 = { 83 B8 80 01 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TBDEDataSet.SetLocale"
		size = 7
	strings:
		$1 = { 89 90 98 01 00 00 C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TBDEDataSet.InitBufferPointers"
		size = 125
		refs = "0016 DbiGetCursorProps 001b Check"
	strings:
		$1 = { 53 81 C4 54 FE FF FF 8B D8 84 D2 74 2C 54 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 84 24 35 01 00 00 89 43 6C 0F B7 84 24 2B 01 00 00 66 89 83 00 02 00 00 0F B7 83 00 02 00 00 66 03 43 70 66 89 83 06 02 00 00 0F B7 53 7C 03 D2 03 D2 66 03 D0 66 89 93 04 02 00 00 8B C2 66 83 C0 06 66 89 83 02 02 00 00 66 03 43 6C 66 89 83 08 02 00 00 81 C4 AC 01 00 00 5B C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TBDEDataSet.AllocRecordBuffer"
		size = 13
		refs = "0008 AllocMem"
	strings:
		$1 = { 0F B7 80 08 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TBDEDataSet.FreeRecordBuffer"
		size = 19
		refs = "0006 TBDEDataSet.ClearBlobCache 000d @FreeMem"
	strings:
		$1 = { 53 8B DA 8B 13 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "TBDEDataSet.InternalInitRecord"
		size = 14
		refs = "0009 DbiInitRecord"
	strings:
		$1 = { 52 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "TBDEDataSet.ClearBlobCache"
		size = 70
		refs = "0031 TArray<System.Byte> 0036 @DynArraySetLength"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 80 BE CD 01 00 00 00 74 30 8B 5E 7C 4B 85 DB 7C 28 43 33 FF 6A 00 0F B7 86 06 02 00 00 03 C5 8D 04 B8 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 47 4B 75 DB 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "TBDEDataSet.ClearCalcFields"
		size = 35
		refs = "001c @FillChar"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 F8 01 00 00 0F B7 C0 8D 04 06 33 C9 8B 53 70 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TBDEDataSet.InitRecord"
		size = 50
		refs = "000b TDataSet.InitRecord 0014 TBDEDataSet.ClearBlobCache"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 0F B7 83 04 02 00 00 03 C6 C6 40 04 02 C6 40 05 03 C7 00 FF FF FF FF 5E 5B C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TBDEDataSet.GetRecord"
		size = 270
		refs = "002f DbiGetRecord 0047 DbiGetNextRecord 005f DbiGetPriorRecord 00c1 TBDEDataSet.ClearBlobCache 00e3 DbiGetBookMark 00e8 Check"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B F2 8B D8 0F B6 45 FF 2C 01 72 08 74 1E FE C8 74 32 EB 48 8D 83 88 01 00 00 50 56 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? EB 32 8D 83 88 01 00 00 50 56 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? EB 1A 8D 83 88 01 00 00 50 56 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? EB 02 33 C0 8B D0 66 83 EA 01 72 0E 66 81 EA 00 22 74 7A 66 FF CA 74 79 EB 7B 0F B7 83 04 02 00 00 03 C6 0F B6 93 90 01 00 00 88 50 04 C6 40 05 00 0F B6 93 F4 01 00 00 80 EA 01 72 0C 75 14 8B 93 88 01 00 00 89 10 EB 10 8B 93 8C 01 00 00 89 10 EB 06 C7 00 FF FF FF FF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 91 58 01 00 00 0F B7 83 02 02 00 00 03 F0 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB EB 15 B3 01 EB 11 B3 02 EB 0D B3 03 80 7D 08 00 74 05 E8 ?? ?? ?? ?? 8B C3 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "TBDEDataSet.GetCurrentRecord"
		size = 91
		refs = "0033 TDataSet.UpdateCursorPos 0048 DbiGetRecord"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B F3 8B 7E 5C 3B 7E 58 7D 17 8B 46 64 8B 14 B8 8B C3 8B 08 FF 91 F4 01 00 00 84 C0 0F 94 C0 EB 02 33 C0 84 C0 74 24 8B C3 E8 ?? ?? ?? ?? 6A 00 8B 44 24 04 50 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 C0 EB 02 33 C0 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TBDEDataSet.GetOldRecord"
		size = 163
		refs = "000d TDataSet.UpdateCursorPos 0023 SetBoolProp 002f TBDEDataSet.GetOldRecord 0055 DbiGetRecord 005a Check 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 80 01 00 00 83 C9 FF BA 04 00 05 05 E8 ?? ?? ?? ?? 84 C0 74 6C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B 45 FC 8B 80 D0 01 00 00 8B 40 0C 50 6A 00 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 80 D0 01 00 00 8B 40 0C 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 80 01 00 00 33 C9 BA 04 00 05 05 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 33 C0 89 45 F8 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "TBDEDataSet.FetchAll"
		size = 70
		refs = "000f TDataSet.CheckBrowseMode 001b DbiSetToEnd 0020 Check 0032 DbiGetPriorRecord"
	strings:
		$1 = { 53 8B D8 80 BB A9 00 00 00 00 75 38 8B C3 E8 ?? ?? ?? ?? 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 C7 40 60 FF FF FF FF 5B C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TBDEDataSet.FlushBuffers"
		size = 29
		refs = "0006 TDataSet.CheckBrowseMode 0012 DbiSaveChanges 0017 Check"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TBDEDataSet.GetRecordCount"
		size = 63
		refs = "0017 DbiGetExactRecordCount 0029 DbiGetRecordCount"
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 92 BC 00 00 00 54 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 74 19 54 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 74 07 C7 04 24 FF FF FF FF 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TBDEDataSet.GetRecNo"
		size = 51
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 BC 00 00 00 80 BB A5 00 00 00 05 75 05 8B 43 68 EB 0B 8B C3 8B 50 5C 8B 40 64 8B 04 90 0F B7 93 04 02 00 00 03 C2 8B 00 5B C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TBDEDataSet.SetRecNo"
		size = 100
		refs = "0009 TDataSet.CheckBrowseMode 0037 DbiSetToSeqNo 0043 TBDEDataSet.SetRecNo"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB F4 01 00 00 01 75 45 8B C3 8B 10 FF 92 8C 01 00 00 3B F0 74 37 8B C3 8B 10 FF 92 34 01 00 00 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 1B 0F B6 15 ?? ?? ?? ?? 8B C3 8B 08 FF 91 B4 02 00 00 8B C3 8B 10 FF 92 10 01 00 00 5E 5B C3 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "TBDEDataSet.GetRecordSize"
		size = 8
	strings:
		$1 = { 0F B7 80 00 02 00 00 C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TBDEDataSet.GetActiveRecBuf"
		size = 256
		refs = "0019 TBDEDataSet.GetActiveRecBuf 00eb TBDEDataSet.GetOldRecord"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B6 83 A5 00 00 00 83 F8 0A 0F 87 DD 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0F B7 83 00 02 00 00 F7 AB 10 02 00 00 03 83 20 02 00 00 89 06 E9 94 00 00 00 8B C3 8B 50 5C 3B 50 58 7C 09 33 C0 89 06 E9 81 00 00 00 8B 40 64 8B 04 90 89 06 EB 77 8B C3 8B 50 5C 8B 40 64 8B 04 90 89 06 EB 68 8B 83 F0 01 00 00 83 C0 06 89 06 EB 5B 8B 43 68 89 06 EB 54 8B 83 A4 01 00 00 89 06 EB 4A 80 BB CB 01 00 00 00 74 0D 8B 83 D0 01 00 00 8B 40 08 89 06 EB 34 8B C3 8B 50 5C 8B 40 64 8B 04 90 89 06 EB 25 80 BB CB 01 00 00 00 74 0D 8B 83 D0 01 00 00 8B 40 0C 89 06 EB 0F 8B C3 E8 ?? ?? ?? ?? 89 06 EB 04 33 C0 89 06 83 3E 00 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TBDEDataSet.AddFieldDesc"
		size = 932
		refs = "002c @DynArrayAddRef 0034 TBDEDataSet.AddFieldDesc 006f NativeToAnsi 007f @LStrLAsg 00ae Format 00be @LStrFromUStr 00c9 @UStrFromLStr 00d3 TDefCollection.IndexOf 00eb DataTypeMap 0113 TBits.GetBit 01e2 BlobTypeMap 01ec TFieldDefs.AddFieldDef 020a TNamedItem.SetDisplayName 0215 TFieldDef.SetDataType 0220 TFieldDef.SetSize 022a TFieldDef.SetPrecision 023e TFieldDef.SetAttributes 02c1 TFieldDef.GetChildDefs 02f6 StrCopy 0300 StrCat 033d @UStrArrayClr 0345 @UStrClr 0352 @LStrArrayClr 035b TFieldDescList 0360 @DynArrayClear 0366 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 80 53 56 57 33 DB 89 5D 80 89 5D 84 89 5D 98 89 5D F8 89 5D F4 8B F9 89 55 FC 89 45 F0 8B 5D 08 8B 75 10 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 07 8B D0 C1 E0 05 2B C2 8B 55 FC 56 57 8D 34 42 8D 7D 9E B9 0F 00 00 00 F3 A5 66 A5 5F 5E FF 07 8D 4D F8 8D 55 A0 8B 45 F0 8B 80 98 01 00 00 E8 ?? ?? ?? ?? 33 C0 89 45 E0 8D 45 F4 8B 55 F8 E8 ?? ?? ?? ?? EB 3D FF 45 E0 8D 45 98 50 8B 45 F8 89 45 88 C6 45 8C 0B 8B 45 E0 89 45 90 C6 45 94 00 8D 55 88 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 98 8D 45 F4 B9 00 00 00 00 E8 ?? ?? ?? ?? 8D 45 84 8B 55 F4 E8 ?? ?? ?? ?? 8B 55 84 8B C3 E8 ?? ?? ?? ?? 85 C0 7D AA 0F B7 45 C0 66 83 F8 19 73 0F 0F B7 C0 0F B6 80 ?? ?? ?? ?? 88 45 EF EB 04 C6 45 EF 00 66 C7 45 EC 00 00 33 C0 89 45 E4 8B 45 0C 8B 40 04 3B 06 7E 0F 8B 16 8B 45 0C E8 ?? ?? ?? ?? 88 45 EB EB 04 C6 45 EB 00 0F B7 45 C0 83 F8 16 0F 87 BC 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 00 06 00 02 03 04 05 01 00 00 02 00 00 01 00 00 00 00 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0F B7 45 C4 66 85 C0 75 06 C6 45 EF 00 EB 6C 66 89 45 EC EB 66 66 83 7D CA 02 74 5F C6 45 EF 00 EB 59 66 83 7D C2 1D 75 52 C6 45 EF 0E C6 45 EB 00 EB 48 66 83 7D C2 15 75 41 C6 45 EF 07 EB 3B 0F BF 45 C6 99 33 C2 2B C2 66 89 45 EC 0F BF 45 C4 89 45 E4 EB 25 0F B7 45 C4 66 89 45 EC 0F B7 45 C2 66 83 F8 16 72 13 66 83 F8 24 77 0D 0F B7 C0 0F B6 80 ?? ?? ?? ?? 88 45 EF 8B C3 E8 ?? ?? ?? ?? 8B D8 8B 06 89 43 1C FF 06 8D 45 80 8B 55 F4 E8 ?? ?? ?? ?? 8B 55 80 8B C3 E8 ?? ?? ?? ?? 0F B6 55 EF 8B C3 E8 ?? ?? ?? ?? 0F B7 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 E4 8B C3 E8 ?? ?? ?? ?? 80 7D EB 00 74 0E 0F B6 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 7D D2 01 75 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 66 83 7D C2 1F 75 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 66 83 7D D6 01 1B C0 40 88 43 24 0F B6 45 EF 2C 1A 74 09 FE C8 74 55 E9 9A 00 00 00 66 83 7D C2 23 75 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 0F BF 45 C4 48 85 C0 7C 79 40 89 45 DC C7 45 E0 00 00 00 00 56 8B 45 0C 50 8B C3 E8 ?? ?? ?? ?? 50 8B CF 8B 55 FC 8B 45 F0 E8 ?? ?? ?? ?? FF 45 E0 FF 4D DC 75 DE EB 4A 8B 06 89 45 E0 8B 07 8B D0 C1 E0 05 2B C2 8B 55 FC 8D 44 42 02 8D 55 A0 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E0 50 8B 45 0C 50 8B C3 E8 ?? ?? ?? ?? 50 8B CF 8B 55 FC 8B 45 F0 E8 ?? ?? ?? ?? 0F BF 45 C6 01 06 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 80 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 98 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 5F 5E 5B 8B E5 5D C2 0C 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 5F 00 25 00 64 00 00 00 04 00 00 00 02 00 00 00 20 00 00 00 10 00 00 00 5B 30 5D 00 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TBDEDataSet.GetBlobFieldData"
		size = 372
		refs = "0052 TBDEDataSet.GetActiveRecBuf 0074 DbiOpenBlob 008b TBDEDataSet.GetBlobFieldData 00a9 DbiGetBlobSize 00bf @TryFinallyExit 00cb @DynArrayLength 00ee TArray<System.Byte> 00f3 @DynArraySetLength 011b DbiGetBlob 0150 DbiFreeBlob 015f Check 0165 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 8B D9 89 55 F8 89 45 FC 33 C0 89 45 F4 8B 45 FC 8B 80 84 00 00 00 85 C0 0F 94 45 ED 85 C0 7E 23 8B 45 FC 8B 80 10 02 00 00 8B 55 FC 0F B7 92 00 02 00 00 F7 EA 8B 55 FC 03 82 20 02 00 00 89 45 F0 EB 13 8D 55 F0 8B 45 FC E8 ?? ?? ?? ?? 84 C0 0F 84 0D 01 00 00 6A 01 0F B7 75 F8 56 8B 45 F0 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 EE 66 83 7D EE 00 0F 85 E4 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 50 56 8B 45 F0 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 EE 66 83 7D EE 00 75 06 83 7D F4 00 75 0A E8 ?? ?? ?? ?? E9 A3 00 00 00 8B 03 E8 ?? ?? ?? ?? 3B 45 F4 7F 26 8B 45 F4 85 C0 79 03 83 C0 03 C1 F8 02 03 45 F4 50 8B C3 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8D 45 F4 50 8B 03 50 8B 45 F4 50 6A 00 0F B7 45 F8 50 8B 45 F0 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 66 83 7D EE 00 74 05 33 C0 89 45 F4 0F B7 45 F8 50 8B 45 F0 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 80 7D ED 00 74 09 0F B7 45 EE E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C5 8B 45 F4 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TBDEDataSet.GetFieldData"
		size = 131
		refs = "0034 DbiGetField 0052 TBDEDataSet.GetActiveRecBuf 006f Check"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F9 8B F2 8B D8 83 BB 84 00 00 00 00 7E 36 54 57 0F B7 83 00 02 00 00 F7 AB 10 02 00 00 03 83 20 02 00 00 50 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 06 83 3C 24 00 74 04 33 C0 EB 36 B0 01 EB 32 8D 54 24 04 8B C3 E8 ?? ?? ?? ?? 84 C0 74 23 54 57 8B 44 24 0C 50 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 04 24 83 F8 01 1B C0 F7 D8 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TBDEDataSet.GetFieldData"
		size = 173
		refs = "0055 TBDEDataSet.GetActiveRecBuf 00a1 Move"
	strings:
		$1 = { 53 56 57 55 51 8B E9 8B FA 8B F0 8B C7 8B 10 FF 92 A8 00 00 00 85 C0 7E 1C 8B C7 8B 10 FF 92 A8 00 00 00 8B D0 8B CD 8B C6 8B 18 FF 93 90 02 00 00 8B D8 EB 70 80 BE A5 00 00 00 0A 75 12 8B C6 8B 50 58 8B 40 64 8B 04 90 89 04 24 B3 01 EB 0B 8B D4 8B C6 E8 ?? ?? ?? ?? 8B D8 84 DB 74 46 0F B6 86 A5 00 00 00 48 2C 03 72 08 2C 01 74 04 2C 05 75 32 0F B7 86 00 02 00 00 03 47 54 01 04 24 8B 04 24 0F B6 18 84 DB 74 1B 85 ED 74 17 8B C7 8B 10 FF 92 9C 00 00 00 8B C8 8B D5 8B 04 24 40 E8 ?? ?? ?? ?? 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "TBDEDataSet.SetFieldData"
		size = 559
		refs = "0021 TBDEDataSet.SetFieldData 0040 SNotEditing 0045 LoadResString 004f DatabaseError 0076 TField.GetIsIndexField 0086 TField.GetDisplayName 009c SNotIndexField 00ac DatabaseErrorFmt 00b6 TBDEDataSet.GetActiveRecBuf 011f SFieldReadOnly 0138 TField.Validate 0182 DbiVerifyField 0187 Check 01a3 DbiPutField 01df Move 0214 @UStrArrayClr 021c @UStrClr 0222 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 83 A5 00 00 00 04 FE 2C 06 72 1B 2C 03 74 17 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 8B D3 E8 ?? ?? ?? ?? 80 BB A5 00 00 00 04 75 54 8B C6 8B 10 FF 92 A8 00 00 00 85 C0 7C 14 83 BB F8 01 00 00 00 7E 3D 8B C6 E8 ?? ?? ?? ?? 84 C0 75 32 6A 00 8D 55 E8 8B C6 E8 ?? ?? ?? ?? 8B 45 E8 89 45 EC C6 45 F0 11 8D 45 EC 50 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E4 33 C9 5A E8 ?? ?? ?? ?? 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 A8 00 00 00 85 C0 0F 8E E2 00 00 00 80 BB A5 00 00 00 05 75 17 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 8B D3 E8 ?? ?? ?? ?? 80 7E 49 00 74 41 0F B6 83 A5 00 00 00 2C 04 74 36 2C 02 74 32 6A 00 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 8B 45 DC 89 45 EC C6 45 F0 11 8D 45 EC 50 8D 55 D8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D8 33 C9 5A E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 80 7E 4A 03 0F 84 9D 00 00 00 80 BB 0A 02 00 00 00 74 3C 8B C6 8B 10 FF 92 AC 00 00 00 84 C0 74 2E 0F B6 83 A5 00 00 00 04 FE 2C 02 73 21 8D 45 F8 50 57 8B C6 8B 10 FF 92 A8 00 00 00 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 8B 45 FC 50 8B C6 8B 10 FF 92 A8 00 00 00 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 35 0F B7 83 00 02 00 00 03 46 54 01 45 FC 83 FF 01 1B C0 40 8B 55 FC 88 02 84 C0 74 19 8B C6 8B 10 FF 92 9C 00 00 00 8B C8 8B 45 FC 8D 50 01 8B C7 E8 ?? ?? ?? ?? 0F B6 83 A5 00 00 00 04 FB 2C 03 72 0E 8B CE 33 D2 8B C3 8B 18 FF 93 E4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 BA 05 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "TBDEDataSet.GetBlobData"
		size = 48
		refs = "0020 TArray<System.Byte> 0025 @DynArrayAsg"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 0F B7 93 06 02 00 00 03 FA 8B 56 54 8B 14 97 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "TBDEDataSet.SetBlobData"
		size = 118
		refs = "0010 @DynArrayAddRef 0018 TBDEDataSet.SetBlobData 0043 TArray<System.Byte> 0048 @DynArrayAsg 0063 @DynArrayClear 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F1 8B FA 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 50 5C 8B 40 64 3B 34 90 75 1D 8B 47 54 0F B7 93 06 02 00 00 03 F2 8D 04 86 8B 55 08 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "TBDEDataSet.CreateBlobStream"
		size = 37
		refs = "000b _Dn_TBlobField 0010 @AsClass 0019 _DV_TBlobStream 001e TBlobStream.Create"
	strings:
		$1 = { 53 56 8B D9 8B F2 53 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15037_0 {
	meta:
		name = "TCustomADODataSet.CreateBlobStream"
		size = 37
		refs = "000b _Dn_TBlobField 0010 @AsClass 0019 _DV_TADOBlobStream 001e TADOBlobStream.Create"
	strings:
		$1 = { 53 56 8B D9 8B F2 53 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14491_0 {
	meta:
		name = "TCustomSQLDataSet.CreateBlobStream"
		size = 37
		refs = "000b _Dn_TBlobField 0010 @AsClass 0019 _DV_TSQLBlobStream 001e TSQLBlobStream.Create"
	strings:
		$1 = { 53 56 8B D9 8B F2 53 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TBDEDataSet.CloseBlob"
		size = 46
		refs = "0026 DbiFreeBlob"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B C7 8B 10 FF 92 A8 00 00 00 50 8B F3 8B 46 5C 8B 56 64 8B 04 82 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TBDEDataSet.GetStateFieldValue"
		size = 41
		refs = "000f TBDEDataSet.CheckCachedUpdateMode 001e TDataSet.GetStateFieldValue"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 45 08 50 8B D3 8B CF 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TBDEDataSet.SetStateFieldValue"
		size = 41
		refs = "000f TBDEDataSet.CheckCachedUpdateMode 001e TDataSet.SetStateFieldValue"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 45 08 50 8B D3 8B CF 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TBDEDataSet.Translate"
		size = 87
		refs = "0011 @PCharLen 002c AnsiToNativeBuf 0041 NativeToAnsiBuf"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 8B DA 89 45 FC 8B C3 E8 ?? ?? ?? ?? 8B F8 80 7D 08 00 74 15 57 8B 45 FC 8B 80 98 01 00 00 8B CE 8B D3 E8 ?? ?? ?? ?? EB 13 57 8B 45 FC 8B 80 98 01 00 00 8B CE 8B D3 E8 ?? ?? ?? ?? 3B F3 74 04 C6 04 3E 00 8B C7 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TBDEDataSet.GetFieldFullName"
		size = 125
		refs = "004c DbiGetProp 0051 Check 0062 NativeToAnsi 006f TDataSet.GetFieldFullName"
	strings:
		$1 = { 53 56 57 81 C4 F4 FB FF FF 8B F9 8B F2 8B D8 8B C6 8B 10 FF 92 A8 00 00 00 85 C0 7E 4B 8B C6 8B 10 FF 92 A8 00 00 00 66 89 44 24 02 8D 44 24 08 89 44 24 04 54 68 01 04 00 00 8D 44 24 0A 50 68 10 00 05 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B CF 8D 54 24 08 8B 83 98 01 00 00 E8 ?? ?? ?? ?? EB 0B 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 81 C4 0C 04 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TBDEDataSet.InternalFirst"
		size = 22
		refs = "000b DbiSetToBegin 0010 Check"
	strings:
		$1 = { 53 8B D8 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TBDEDataSet.InternalLast"
		size = 22
		refs = "000b DbiSetToEnd 0010 Check"
	strings:
		$1 = { 53 8B D8 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TBDEDataSet.InternalEdit"
		size = 56
		refs = "001c DbiGetRecord 0021 Check 0031 TBDEDataSet.ClearBlobCache"
	strings:
		$1 = { 53 56 8B D8 6A 00 8B F3 8B 46 5C 8B 56 64 8B 04 82 50 6A 01 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 46 5C 8B 56 64 8B 14 82 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TBDEDataSet.InternalInsert"
		size = 33
		refs = "0012 SetBoolProp"
	strings:
		$1 = { 53 8B D8 83 C9 FF BA 14 00 05 00 8B 83 80 01 00 00 E8 ?? ?? ?? ?? 8B C3 C7 40 60 FF FF FF FF 5B C3 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "TBDEDataSet.InternalPost"
		size = 88
		refs = "0007 TDataSet.InternalPost 002a DbiModifyRecord 002f Check 004c DbiInsertRecord"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A5 00 00 00 02 75 22 6A FF 8B F3 8B 46 5C 8B 56 64 8B 04 82 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 8B F3 8B 46 5C 8B 56 64 8B 04 82 50 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TBDEDataSet.InternalDelete"
		size = 44
		refs = "000b DbiDeleteRecord 0019 ErrCat 0026 Check"
	strings:
		$1 = { 53 6A 00 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 14 8B C3 E8 ?? ?? ?? ?? 66 83 F8 22 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TBDEDataSet.IsSequenced"
		size = 24
	strings:
		$1 = { 80 B8 F4 01 00 00 01 75 09 80 B8 B0 00 00 00 00 74 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TBDEDataSet.GetCanModify"
		size = 31
		refs = "000f TBDEDataSet.ForceUpdateCallback"
	strings:
		$1 = { 53 8B D8 80 BB CC 01 00 00 00 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TBDEDataSet.InternalRefresh"
		size = 72
		refs = "0028 DbiForceRecordReread 002d Check 003c DbiForceReread"
	strings:
		$1 = { 53 56 8B D8 8B 83 8C 00 00 00 85 C0 74 26 80 78 48 1C 75 20 8B F3 8B 46 5C 8B 56 64 8B 04 82 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TBDEDataSet.Post"
		size = 30
		refs = "0006 TDataSet.Post 0018 TBDEDataSet.PostKeyBuffer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A5 00 00 00 04 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TBDEDataSet.Cancel"
		size = 30
		refs = "0006 TDataSet.Cancel 0018 TBDEDataSet.PostKeyBuffer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A5 00 00 00 04 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15370_0 {
	meta:
		name = "TCustomClientDataSet.Cancel"
		size = 30
		refs = "0006 TDataSet.Cancel 0018 TCustomClientDataSet.PostKeyBuffer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A5 00 00 00 04 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TBDEDataSet.InternalCancel"
		size = 24
		refs = "0013 DbiRelRecordLock"
	strings:
		$1 = { 80 B8 A5 00 00 00 02 75 0E 6A 00 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TBDEDataSet.InternalAddRecord"
		size = 54
		refs = "0013 DbiAppendRecord 0018 Check 002a DbiInsertRecord"
	strings:
		$1 = { 53 56 8B F2 8B D8 84 C9 74 15 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 56 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TBDEDataSet.InternalGotoBookmark"
		size = 27
		refs = "000f DbiSetToBookMark 0014 Check"
	strings:
		$1 = { 53 56 8B F2 8B D8 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TBDEDataSet.InternalSetToRecord"
		size = 18
	strings:
		$1 = { 0F B7 88 02 02 00 00 03 D1 8B 08 FF 91 08 02 00 00 C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TBDEDataSet.GetBookmarkFlag"
		size = 14
	strings:
		$1 = { 0F B7 80 04 02 00 00 03 D0 0F B6 42 05 C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TBDEDataSet.SetBookmarkFlag"
		size = 13
	strings:
		$1 = { 0F B7 80 04 02 00 00 03 D0 88 4A 05 C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TBDEDataSet.GetBookmarkData"
		size = 23
		refs = "0011 Move"
	strings:
		$1 = { 53 0F B7 98 02 02 00 00 03 D3 8B 40 6C 92 87 CA E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "TBDEDataSet.SetBookmarkData"
		size = 21
		refs = "000f Move"
	strings:
		$1 = { 53 0F B7 98 02 02 00 00 03 D3 8B 40 6C 91 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TBDEDataSet.CompareBookmarks"
		size = 172
		refs = "0013 @DynArrayAddRef 0023 TBDEDataSet.CompareBookmarks 0044 RetCodes 006d DbiCompareBookMarks 008e TArray<System.Byte> 0098 @FinalizeArray 009e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 89 4D F8 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F8 00 0F 94 C0 83 E0 7F 83 7D FC 00 0F 94 C2 83 E2 7F 8D 14 55 ?? ?? ?? ?? 0F BE 04 02 89 45 F4 83 7D F4 02 75 27 8B 83 80 01 00 00 85 C0 74 12 8D 55 F4 52 8B 55 F8 52 8B 55 FC 52 50 E8 ?? ?? ?? ?? 83 7D F4 02 75 05 33 C0 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 F4 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TBDEDataSet.BookmarkValid"
		size = 148
		refs = "000f @DynArrayAddRef 0017 TBDEDataSet.BookmarkValid 0044 DbiSetToBookMark 005b DbiGetRecord 007c TArray<System.Byte> 0081 @DynArrayClear 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 55 FC 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BE 80 01 00 00 00 0F 95 C3 84 DB 74 3B 8B C6 C7 40 60 FF FF FF FF 8B 45 FC 50 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 17 6A 00 6A 00 6A 00 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 74 04 33 DB EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "CanBlockRead"
		size = 108
		refs = "0035 TFields.GetCount 004f TFields.GetField"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 8B 40 FC 83 78 54 01 7F 0F 8B 45 08 8B 40 FC 83 B8 8C 00 00 00 00 74 04 33 DB EB 02 B3 01 84 DB 74 3A 8B 45 08 8B 40 FC 8B 40 38 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 25 47 33 F6 8B 45 08 8B 40 FC 8B 40 38 8B D6 E8 ?? ?? ?? ?? 0F B6 40 48 04 E4 2C 02 73 04 33 DB EB 04 46 4F 75 DE 8B C3 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "FreeBuffer"
		size = 40
		refs = "0014 @FreeMem"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 8B 80 20 02 00 00 85 C0 74 13 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 33 D2 89 90 20 02 00 00 5D C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TBDEDataSet.SetBlockReadSize"
		size = 259
		refs = "0034 CanBlockRead 0043 FreeBuffer 004c TDataSet.UpdateCursorPos 0062 DbiSetProp 0085 AllocMem 00dc TDataSet.SetBlockReadSize"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B 45 FC 3B 98 84 00 00 00 0F 84 E4 00 00 00 85 DB 0F 8E CB 00 00 00 8B 45 FC 80 B8 A9 00 00 00 00 0F 85 CC 00 00 00 55 E8 ?? ?? ?? ?? 59 84 C0 0F 84 BD 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 FC E8 ?? ?? ?? ?? 6A 00 68 14 00 05 00 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 81 FB FF FF FF 7F 75 07 BE 00 00 01 00 EB 0D 8B 45 FC 0F B7 B0 00 02 00 00 0F AF F3 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 89 82 20 02 00 00 8B 45 FC 0F B7 80 00 02 00 00 50 8B C6 5A 8B CA 99 F7 F9 8B C8 8B 45 FC 89 88 0C 02 00 00 8B 45 FC 89 88 10 02 00 00 8B 45 FC 8B 80 0C 02 00 00 8B 55 FC 89 82 14 02 00 00 8B 45 FC 33 D2 89 90 18 02 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 B0 01 00 00 EB 11 8B D3 8B 45 FC E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TBDEDataSet.BlockReadNext"
		size = 181
		refs = "0020 TDataSet.Last 003c DbiReadBlock 0051 Check"
	strings:
		$1 = { 53 56 8B D8 8B 83 14 02 00 00 8B D0 4A 3B 93 10 02 00 00 7F 6D 3B 83 0C 02 00 00 7D 09 8B C3 E8 ?? ?? ?? ?? EB 62 8B 83 20 02 00 00 50 8D 83 14 02 00 00 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 8B F0 66 85 F6 74 0E 66 81 FE 02 22 74 07 8B C6 E8 ?? ?? ?? ?? 83 BB 14 02 00 00 00 75 0E 66 81 FE 02 22 75 07 8B C3 E8 ?? ?? ?? ?? 8B 83 14 02 00 00 01 83 18 02 00 00 33 C0 89 83 10 02 00 00 EB 06 FF 83 10 02 00 00 83 7B 70 00 7E 15 8B C3 8B 50 58 8B 40 64 8B 14 90 8B C3 8B 08 FF 91 58 01 00 00 83 C9 FF B2 03 8B C3 8B 18 FF 93 E4 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TBDEDataSet.GetIndexInfo"
		size = 135
		refs = "0016 DbiGetIndexDesc"
	strings:
		$1 = { 53 56 57 81 C4 80 FC FF FF 8B D8 54 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 5E 66 83 BC 24 51 01 00 00 01 1B C0 40 88 83 C8 01 00 00 66 83 BC 24 37 03 00 00 01 1B C0 40 88 83 C9 01 00 00 80 BB C8 01 00 00 00 75 22 0F B7 84 24 55 01 00 00 89 83 F8 01 00 00 8D B4 24 5D 01 00 00 8D BB A8 01 00 00 B9 08 00 00 00 F3 A5 0F B7 84 24 57 01 00 00 66 89 83 CE 01 00 00 81 C4 80 03 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "TBDEDataSet.SwitchToIndex"
		size = 366
		refs = "0019 TBDEDataSet.SwitchToIndex 0027 TBDEDataSet.ResetCursorRange 002f TDataSet.UpdateCursorPos 0042 @LStrFromUStr 004a @LStrToPChar 0073 DbiSwitchToIndex 00a9 Check 00eb TBDEDataSet.InitBufferPointers 011a @HandleAnyException 0124 TDataSet.SetState 0134 @RaiseAgain 0139 @DoneExcept 0141 TBDEDataSet.GetIndexInfo 015b @LStrArrayClr 0161 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 6A FF 6A 00 8D 45 F8 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 50 8D 45 F4 8B D3 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B F8 57 8B 45 FC 05 80 01 00 00 50 E8 ?? ?? ?? ?? 66 3D 05 22 75 2B 6A 00 6A 00 8D 45 F0 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 50 57 8B 45 FC 05 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 66 C7 80 CE 01 00 00 00 00 8B 45 FC C6 80 C8 01 00 00 00 8B 45 FC C6 80 C9 01 00 00 00 8B 45 FC 33 D2 89 90 F8 01 00 00 33 D2 8B 45 FC 8B 08 FF 91 C0 01 00 00 B2 01 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 54 42 8B 45 FC 8B 08 FF 91 C0 01 00 00 33 C0 5A 59 59 64 89 10 EB 24 E9 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 D4 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TBDEDataSet.GetIndexField"
		size = 194
		refs = "0019 TBDEDataSet.GetIndexField 0033 SFieldIndexError 0038 LoadResString 0042 DatabaseError 0058 TFields.FieldByNumber 006a TFieldDefs.GetFieldDef 0080 SIndexFieldMissing 0090 DatabaseErrorFmt 00a5 @UStrClr 00b3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F0 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 08 3B B3 F8 01 00 00 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 0F B7 84 73 A8 01 00 00 8B F0 8B C3 8B D6 8B 40 38 E8 ?? ?? ?? ?? 8B F8 85 FF 75 32 53 8B D6 4A 8B 43 40 E8 ?? ?? ?? ?? 8B 40 0C 89 45 F4 C6 45 F8 11 8D 45 F4 50 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 33 C9 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TBDEDataSet.SetIndexField"
		size = 29
		refs = "000e TBDEDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_72717_0 {
	meta:
		name = "TActionListCollection.SetListItem"
		size = 29
		refs = "000e TActionListCollection.GetListItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2684_0 {
	meta:
		name = "TBaseDBGridLinkColumns.SetColumn"
		size = 29
		refs = "000e TCollection.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_94137_0 {
	meta:
		name = "TChartCustomAxes.Put"
		size = 29
		refs = "000e TChartCustomAxes.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_95862_0 {
	meta:
		name = "TCookieCollection.SetCookie"
		size = 29
		refs = "000e TCookieCollection.GetCookie"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15134_0 {
	meta:
		name = "TCustomADODataSet.SetIndexField"
		size = 29
		refs = "000e TCustomADODataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15406_0 {
	meta:
		name = "TCustomClientDataSet.SetIndexField"
		size = 29
		refs = "000e TCustomClientDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_77744_0 {
	meta:
		name = "TDBGridColumns.SetColumn"
		size = 29
		refs = "000e TDBGridColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5169_0 {
	meta:
		name = "TFields.SetField"
		size = 29
		refs = "000e TFields.GetField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_95695_0 {
	meta:
		name = "THTMLTableColumns.SetColumn"
		size = 29
		refs = "000e THTMLTableColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_32032_0 {
	meta:
		name = "TIBTable.SetIndexField"
		size = 29
		refs = "000e TIBTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_46052_0 {
	meta:
		name = "TIWScriptEvents.SetItem"
		size = 29
		refs = "000e TIWScriptEvents.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_37120_0 {
	meta:
		name = "TIdSMTPRelayStatusList.SetItems"
		size = 29
		refs = "000e TIdSMTPRelayStatusList.GetItems"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_75204_0 {
	meta:
		name = "TListItems.SetItem"
		size = 29
		refs = "000e TListItems.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_14617_0 {
	meta:
		name = "TSQLTable.SetIndexField"
		size = 29
		refs = "000e TSQLTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_95909_0 {
	meta:
		name = "TWebActionItems.SetActionItem"
		size = 29
		refs = "000e TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_98819_0 {
	meta:
		name = "TWebUserItems.SetUserItem"
		size = 29
		refs = "000e TWebUserItems.GetUserItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "TBDEDataSet.GetIndexFieldCount"
		size = 7
		altNames = "TRibbonCustomControl.GetContainedControl TRibbonGalleryControl.GetContainedControl"
	strings:
		$1 = { 8B 80 F8 01 00 00 C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "TBDEDataSet.AllocKeyBuffers"
		size = 109
		refs = "000e TBDEDataSet.AllocKeyBuffers 0028 AllocMem 0032 TBDEDataSet.InitKeyBuffer 0051 @HandleAnyException 0059 TBDEDataSet.FreeKeyBuffers 005e @RaiseAgain 0063 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8B 45 FC 0F B7 80 00 02 00 00 83 C0 06 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 89 84 9A D8 01 00 00 43 83 FB 06 75 D4 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "TBDEDataSet.FreeKeyBuffers"
		size = 37
		refs = "0018 DisposeMem"
	strings:
		$1 = { 53 56 8B F0 33 DB 0F B7 96 00 02 00 00 83 C2 06 8D 84 9E D8 01 00 00 E8 ?? ?? ?? ?? 43 83 FB 06 75 E4 5E 5B C3 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "TBDEDataSet.InitKeyBuffer"
		size = 48
		refs = "0015 @FillChar 0027 DbiInitRecord"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B7 93 00 02 00 00 83 C2 06 8B C6 33 C9 E8 ?? ?? ?? ?? 8B C6 83 C0 06 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "TBDEDataSet.CheckSetKeyMode"
		size = 87
		refs = "000c TBDEDataSet.CheckSetKeyMode 0023 SNotEditing 0028 LoadResString 0032 DatabaseError 0047 @UStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB A5 00 00 00 04 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_15416_0 {
	meta:
		name = "TCustomClientDataSet.CheckSetKeyMode"
		size = 87
		refs = "000c TCustomClientDataSet.CheckSetKeyMode 0023 SNotEditing 0028 LoadResString 0032 DatabaseError 0047 @UStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB A5 00 00 00 04 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "TBDEDataSet.SetCursorRange"
		size = 520
		refs = "0030 CompareMem 0075 AllocMem 0080 TBDEDataSet.SetCursorRange 00b5 DbiExtractKey 0172 DbiSetRange 0177 Check 019b Move 01f1 @FreeMem 01f7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 45 FC C6 45 FB 00 8B 45 FC 8B 80 DC 01 00 00 8B 55 FC 8B 92 E4 01 00 00 8B 4D FC 0F B7 89 00 02 00 00 83 C1 06 E8 ?? ?? ?? ?? 84 C0 74 26 8B 45 FC 8B 80 E0 01 00 00 8B 55 FC 8B 92 E8 01 00 00 8B 4D FC 0F B7 89 00 02 00 00 83 C1 06 E8 ?? ?? ?? ?? EB 02 33 C0 84 C0 0F 85 95 01 00 00 8B 45 FC 0F B7 80 CE 01 00 00 03 C0 E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 EF 01 C6 45 EE 01 8B 45 FC 8B 98 DC 01 00 00 80 3B 00 74 22 8B FB 83 C7 06 8B 45 F0 50 57 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 45 EF EB 02 33 FF 8B 45 FC 8B B0 E0 01 00 00 80 3E 00 74 32 8B C6 83 C0 06 89 45 F4 8B 45 FC 0F B7 80 CE 01 00 00 03 45 F0 50 8B 45 F4 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 45 EE EB 05 33 C0 89 45 F4 0F B6 45 EF 22 45 EE 88 45 ED 80 7D ED 00 74 1D 85 FF 74 03 8B 7D F0 83 7D F4 00 74 10 8B 45 FC 0F B7 80 CE 01 00 00 03 45 F0 89 45 F4 0F B6 46 01 34 01 F6 D8 1B C0 50 8B 45 F4 50 6A 00 0F B7 46 02 50 0F B6 43 01 34 01 F6 D8 1B C0 50 57 6A 00 0F B7 43 02 50 80 7D ED 01 F5 1B C0 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 0F B7 88 00 02 00 00 83 C1 06 8B 45 FC 8B 90 E4 01 00 00 8B 45 FC 8B 80 DC 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 0F B7 88 00 02 00 00 83 C1 06 8B 45 FC 8B 90 E8 01 00 00 8B 45 FC 8B 80 E0 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 C8 02 00 00 C6 45 FB 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 0F B7 80 CE 01 00 00 8B D0 03 D2 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 0F B6 45 FB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "TBDEDataSet.ResetCursorRange"
		size = 84
		refs = "0023 DbiResetRange 0028 Check 0035 TBDEDataSet.InitKeyBuffer"
	strings:
		$1 = { 53 8B D8 33 C0 8B 93 E4 01 00 00 80 3A 00 75 0B 8B 93 E8 01 00 00 80 3A 00 74 37 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 93 E4 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B 93 E8 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 C8 02 00 00 B0 01 5B C3 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TBDEDataSet.SetLinkRanges"
		size = 204
		refs = "0014 TDataSet.SetTempState 001f TBDEDataSet.SetLinkRanges 0036 TBDEDataSet.InitKeyBuffer 0058 TList.Get 0063 TBDEDataSet.GetIndexField 0095 TDataSet.RestoreState 009b @HandleFinally 00c1 Move"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B FA 89 45 FC B2 04 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 DC 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 F0 01 00 00 C6 03 01 8B 77 08 4E 85 F6 7C 21 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 50 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 43 4E 75 E2 8B 47 08 8B 55 FC 8B 92 F0 01 00 00 89 42 02 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 FB 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 8B 45 FC 0F B7 88 00 02 00 00 83 C1 06 8B 45 FC 8B 90 E0 01 00 00 8B 45 FC 8B 80 DC 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "TBDEDataSet.GetKeyBuffer"
		size = 8
	strings:
		$1 = { 8B 84 90 D8 01 00 00 C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TBDEDataSet.SetKeyBuffer"
		size = 111
		refs = "000c TDataSet.CheckBrowseMode 002e Move 003f TBDEDataSet.InitKeyBuffer 0048 TDataSet.SetState"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 84 BE D8 01 00 00 89 86 F0 01 00 00 0F B7 8E 00 02 00 00 83 C1 06 8B 96 EC 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8B 96 F0 01 00 00 8B C6 E8 ?? ?? ?? ?? B2 04 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 96 F0 01 00 00 0F B6 12 88 90 AA 00 00 00 33 C9 B2 02 8B C6 8B 18 FF 93 E4 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TBDEDataSet.PostKeyBuffer"
		size = 96
		refs = "0041 Move 004a TDataSet.SetState"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 33 C9 B2 07 8B C6 8B 38 FF 97 E4 00 00 00 84 DB 74 11 8B 86 F0 01 00 00 0F B6 96 AA 00 00 00 88 10 EB 1B 0F B7 8E 00 02 00 00 83 C1 06 8B 96 F0 01 00 00 8B 86 EC 01 00 00 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 33 C9 B2 02 8B C6 8B 18 FF 93 E4 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TBDEDataSet.GetKeyExclusive"
		size = 22
		refs = "0006 TBDEDataSet.CheckSetKeyMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 0F B6 40 01 5B C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TBDEDataSet.SetKeyExclusive"
		size = 25
		refs = "0009 TBDEDataSet.CheckSetKeyMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 F0 01 00 00 88 58 01 5E 5B C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TBDEDataSet.GetKeyFieldCount"
		size = 21
		refs = "0006 TBDEDataSet.CheckSetKeyMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 8B 40 02 5B C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TBDEDataSet.SetKeyFieldCount"
		size = 25
		refs = "0009 TBDEDataSet.CheckSetKeyMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 89 70 02 5E 5B C3 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TBDEDataSet.SetKeyFields"
		size = 306
		refs = "001d TBDEDataSet.SetKeyFields 0037 SCompositeIndexError 003c LoadResString 0047 DatabaseError 005b SNoFieldIndexes 0075 TDataSet.SetTempState 0098 TBDEDataSet.InitKeyBuffer 00b8 TBDEDataSet.GetIndexField 00bf TField.AssignValue 00fb TDataSet.RestoreState 0101 @HandleFinally 011d @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 5D F0 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 C8 01 00 00 00 74 18 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 8B 55 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 F8 01 00 00 00 75 18 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 8B 55 FC E8 ?? ?? ?? ?? B2 04 8B 45 FC E8 ?? ?? ?? ?? 88 45 F7 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 94 98 D8 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 89 82 F0 01 00 00 8B 75 08 85 F6 7C 1E 46 33 FF 8B 5D F8 8B D7 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 47 83 C3 08 4E 75 E8 8B 55 08 42 8B 45 FC 8B 80 F0 01 00 00 89 50 02 8B 55 FC 0F B6 92 AA 00 00 00 88 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 55 F7 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TBDEDataSet.GetIsIndexField"
		size = 116
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B D8 80 BB A5 00 00 00 04 75 18 83 BB F8 01 00 00 00 75 0F 80 BB C8 01 00 00 00 74 06 C6 04 24 01 EB 40 C6 04 24 00 8B C5 8B 10 FF 92 A8 00 00 00 85 C0 7E 2E 8B B3 F8 01 00 00 4E 85 F6 7C 23 46 33 FF 8B C5 8B 10 FF 92 A8 00 00 00 0F B7 94 7B A8 01 00 00 3B C2 75 06 C6 04 24 01 EB 04 47 4E 75 E0 0F B6 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TBDEDataSet.MapsToIndex"
		size = 154
		refs = "0023 TList.Get"
	strings:
		$1 = { 53 56 57 55 51 88 0C 24 8B FA 8B E8 C6 44 24 01 00 33 C0 8B 77 08 4E 85 F6 7C 28 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 0F B6 40 48 2C 01 74 0A 04 EA 2C 02 72 04 33 C0 EB 02 B0 01 84 C0 75 04 43 4E 75 DB 0F B6 95 C9 01 00 00 3A 14 24 0F 95 C2 84 C2 75 3B 8B 47 08 3B 85 F8 01 00 00 7F 30 8B F0 4E 85 F6 7C 24 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 92 A8 00 00 00 0F B7 94 5D A8 01 00 00 3B C2 75 09 43 4E 75 DF C6 44 24 01 01 0F B6 44 24 01 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TBDEDataSet.ActivateFilters"
		size = 192
		refs = "0017 DbiActivateFilter 002f DbiDropFilter 0045 TBDEDataSet.CreateExprFilter 005f Check 0093 TBDEDataSet.RecordFilter 009f TBDEDataSet.CreateFuncFilter"
	strings:
		$1 = { 53 56 8B D8 8B B3 9C 01 00 00 85 F6 74 55 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 74 43 8B 83 9C 01 00 00 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 6A 00 0F B6 8B A4 00 00 00 8B 93 80 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 89 B3 9C 01 00 00 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B3 A0 01 00 00 85 F6 74 50 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 74 3E 8B 83 A0 01 00 00 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 89 B3 A0 01 00 00 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TBDEDataSet.DeactivateFilters"
		size = 63
		refs = "0017 DbiDeactivateFilter 001c Check"
	strings:
		$1 = { 53 56 8B D8 8B B3 A0 01 00 00 85 F6 74 12 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B3 9C 01 00 00 85 F6 74 12 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TBDEDataSet.CreateExprFilter"
		size = 216
		refs = "0018 TBDEDataSet.CreateExprFilter 0028 @WStrFromUStr 0042 FldTypeMap 004d _Dn_TExprParser 0052 TExprParser.Create 0085 DbiAddFilter 008a Check 009f TObject.Free 00a5 @HandleFinally 00bc @WStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 DB 89 5D F0 88 4D FF 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 8B D6 E8 ?? ?? ?? ?? 8B 45 F0 50 0F B6 45 FF 50 0F B6 05 ?? ?? ?? ?? 50 6A 00 6A 00 68 ?? ?? ?? ?? 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 6A 00 8B 45 F4 8B 40 5C 50 6A 00 0F B7 45 08 50 6A 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5E 5B 8B E5 5D C2 04 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "TBDEDataSet.CreateFuncFilter"
		size = 43
		refs = "001a DbiAddFilter 001f Check"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 54 56 6A 00 6A 00 57 53 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 04 24 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TBDEDataSet.CreateLookupFilter"
		size = 432
		refs = "0023 TBDEDataSet.CreateLookupFilter 0051 FldTypeMap 005d _Dn_TFilterExpr 0062 TFilterExpr.Create 008c TList.Get 0098 TFilterExpr.NewCompareNode 00b9 @VarArrayGet 00e9 @VarClear 00fe TFilterExpr.NewNode 0123 TFilterExpr.GetFilterData 013f DbiAddFilter 0144 Check 0159 TObject.Free 015f @HandleFinally 0177 TExprData 017c @DynArrayClear 0184 @VarClr"
	strings:
		$1 = { 55 8B EC 51 B9 07 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 89 4D E4 89 55 E8 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 F6 45 0C 01 74 09 0F B6 05 ?? ?? ?? ?? EB 07 0F B6 05 ?? ?? ?? ?? 50 0F B6 05 ?? ?? ?? ?? 50 6A 00 6A 00 68 ?? ?? ?? ?? 6A 00 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 DC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 E8 8B 40 08 83 F8 01 75 21 8B 45 E4 50 33 D2 8B 45 E8 E8 ?? ?? ?? ?? 8B D0 B1 03 8B 45 DC E8 ?? ?? ?? ?? 8B F0 89 75 D8 EB 66 8B F8 4F 85 FF 7C 5F 47 33 DB 53 6A 01 8B 45 E4 50 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 C8 50 8B D3 8B 45 E8 E8 ?? ?? ?? ?? 8B D0 B1 03 8B 45 DC E8 ?? ?? ?? ?? 8B F0 85 DB 75 05 89 75 D8 EB 20 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 D8 50 56 B1 0A B2 02 8B 45 DC E8 ?? ?? ?? ?? 89 45 D8 43 4F 75 A4 F6 45 0C 02 74 04 C6 46 05 01 8D 45 E0 50 6A 00 8D 4D C4 8B 55 D8 8B 45 DC E8 ?? ?? ?? ?? 8B 45 C4 50 6A 00 0F B7 45 08 50 6A 00 8B 45 EC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 DC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B 45 E0 5F 5E 5B 8B E5 5D C2 08 00 03 00 00 00 02 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TBDEDataSet.SetFilterHandle"
		size = 119
		refs = "002d DbiSetToBegin 0041 DbiDropFilter 0057 DbiActivateFilter"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 80 BB B0 00 00 00 00 74 4B 8B C3 C7 40 60 FF FF FF FF 8B C3 8B 10 FF 92 C8 02 00 00 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 83 3E 00 74 0F 8B 06 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 89 3E 83 3E 00 74 27 8B 06 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? EB 16 83 3E 00 74 0F 8B 06 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 89 3E 5F 5E 5B C3 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TBDEDataSet.SetFilterData"
		size = 145
		refs = "000d TDataSet.GetActive 0018 TDataSet.CheckBrowseMode 0025 @UStrEqual 0047 TBDEDataSet.CreateExprFilter 005a TBDEDataSet.SetFilterHandle 0063 TDataSet.SetFilterText 006e TDataSet.SetFilterOptions 0089 TDataSet.First"
	strings:
		$1 = { 53 56 51 88 0C 24 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 49 8B C3 E8 ?? ?? ?? ?? 8B 83 80 00 00 00 8B D6 E8 ?? ?? ?? ?? 75 0C 0F B6 04 24 3A 83 A4 00 00 00 74 27 85 F6 74 12 6A 00 0F B6 4C 24 04 8B D6 8B C3 E8 ?? ?? ?? ?? EB 02 33 C0 8D 93 9C 01 00 00 8B C8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 80 BB B0 00 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TBDEDataSet.SetFilterText"
		size = 13
		refs = "0008 TBDEDataSet.SetFilterData"
	strings:
		$1 = { 0F B6 88 A4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15461_0 {
	meta:
		name = "TCustomClientDataSet.SetFilterText"
		size = 13
		refs = "0008 TCustomClientDataSet.SetFilterData"
	strings:
		$1 = { 0F B6 88 A4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TBDEDataSet.SetFiltered"
		size = 105
		refs = "0009 TDataSet.GetActive 0014 TDataSet.CheckBrowseMode 0032 DbiSetToBegin 003d TBDEDataSet.ActivateFilters 0046 TBDEDataSet.DeactivateFilters 004f TDataSet.SetFiltered 0056 TDataSet.First"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 74 4C 8B C6 E8 ?? ?? ?? ?? 3A 9E B0 00 00 00 74 33 8B C6 8B 10 FF 92 C8 02 00 00 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? 84 DB 74 09 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "TBDEDataSet.SetFilterOptions"
		size = 21
		refs = "000f TBDEDataSet.SetFilterData"
	strings:
		$1 = { 51 88 14 24 0F B6 0C 24 8B 90 80 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_15462_0 {
	meta:
		name = "TCustomClientDataSet.SetFilterOptions"
		size = 21
		refs = "000f TCustomClientDataSet.SetFilterData"
	strings:
		$1 = { 51 88 14 24 0F B6 0C 24 8B 90 80 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TBDEDataSet.SetOnFilterRecord"
		size = 139
		refs = "0009 TDataSet.GetActive 0014 TDataSet.CheckBrowseMode 0037 TBDEDataSet.RecordFilter 0043 TBDEDataSet.CreateFuncFilter 0056 TBDEDataSet.SetFilterHandle 0063 TDataSet.SetOnFilterRecord 0073 TDataSet.First"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 68 8B C3 E8 ?? ?? ?? ?? 66 83 BB 72 01 00 00 00 0F 95 C2 0F B7 45 0A 66 85 C0 0F 95 C1 3A D1 74 29 66 85 C0 74 13 BA ?? ?? ?? ?? B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 02 33 C0 8D 93 A0 01 00 00 8B C8 8B C3 E8 ?? ?? ?? ?? FF 75 0C FF 75 08 8B C3 E8 ?? ?? ?? ?? 80 BB B0 00 00 00 00 74 16 8B C3 E8 ?? ?? ?? ?? EB 0D FF 75 0C FF 75 08 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TBDEDataSet.FindRecord"
		size = 316
		refs = "0013 TDataSet.CheckBrowseMode 0030 TDataSet.UpdateCursorPos 004e TBDEDataSet.ActivateFilters 0056 TBDEDataSet.FindRecord 0075 DbiSetToBegin 007a Check 008f DbiGetNextRecord 00a8 DbiSetToEnd 00c2 DbiGetPriorRecord 00e7 TBDEDataSet.DeactivateFilters 00ed @HandleFinally 011a TDataSet.GetFound"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 88 4D FB 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 34 01 00 00 8B 45 FC C6 80 AD 00 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 60 FF FF FF FF 8B 45 FC 80 B8 B0 00 00 00 00 75 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7D FB 00 74 33 84 DB 74 14 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 F8 EB 31 84 DB 74 14 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 80 B8 B0 00 00 00 00 75 08 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 66 83 7D F8 00 75 1C 0F B6 15 ?? ?? ?? ?? 8B 45 FC 8B 08 FF 91 B4 02 00 00 8B 45 FC C6 80 AD 00 00 00 01 8B 45 FC E8 ?? ?? ?? ?? 8B D8 84 DB 74 0B 8B 45 FC 8B 10 FF 92 10 01 00 00 8B C3 5B 59 59 5D C3 00 00 03 00 00 00 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TBDEDataSet.RecordFilter"
		size = 123
		refs = "000d TDataSet.SetTempState 0024 TBDEDataSet.RecordFilter 0052 @HandleAnyException 005a ApplicationHandleException 005f @DoneExcept 006b TDataSet.RestoreState"
	strings:
		$1 = { 55 8B EC 51 53 56 57 B2 06 8B 45 08 E8 ?? ?? ?? ?? 88 45 FE 8B 45 08 8B 55 0C 89 90 A4 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 01 8D 4D FF 8B 5D 08 8B 55 08 8B 83 74 01 00 00 FF 93 70 01 00 00 33 C0 5A 59 59 64 89 10 EB 12 E9 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 55 FE 8B 45 08 E8 ?? ?? ?? ?? 0F B6 45 FF 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TBDEDataSet.LocateRecord"
		size = 775
		refs = "0023 TBDEDataSet.LocateRecord 0031 TDataSet.CheckBrowseMode 004e _Dn_TList 0053 TObject.Create 0071 TDataSet.GetFieldList 009d TBDEDataSet.MapsToIndex 00d7 TDataSet.SetTempState 00f8 DbiInitRecord 010f VarIsArray 011d TList.Get 0130 @VarArrayGet 01a2 TList.Last 01e5 DbiGetRecordForKey 0200 TDataSet.RestoreState 0206 @HandleFinally 023a DbiSetToCursor 024f DbiSetToBegin 0254 Check 0269 TBDEDataSet.CreateLookupFilter 027b DbiActivateFilter 028f DbiGetNextRecord 02a3 DbiDropFilter 02b8 TObject.Free 02dd @UStrClr 02e6 Variant 02f0 @FinalizeArray"
	strings:
		$1 = { 55 8B EC 51 B9 07 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 89 4D F8 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 60 FF FF FF FF 8B 45 FC 8B 50 58 8B 40 64 8B 1C 90 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B CE 8B 55 F0 8B 45 FC E8 ?? ?? ?? ?? F6 45 0C 01 0F 95 C0 88 45 E9 8B 45 FC 80 B8 CA 01 00 00 00 74 07 33 C0 89 45 EC EB 35 0F B6 4D E9 8B 55 F0 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 0E 8B 45 FC 8B 80 80 01 00 00 89 45 EC EB 14 0F B6 4D E9 8B D6 8B 45 FC 8B 30 FF 96 CC 02 00 00 89 45 EC 83 7D EC 00 0F 84 73 01 00 00 B2 06 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 89 98 A4 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 53 8B 45 EC 50 E8 ?? ?? ?? ?? 8B 45 F0 8B 40 08 89 45 F4 83 7D F4 01 75 52 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 2F 8B 45 F0 33 D2 E8 ?? ?? ?? ?? 8B F0 6A 00 6A 01 8B 45 F8 50 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 D8 8B C6 8B 08 FF 91 00 01 00 00 EB 50 8B 45 F0 33 D2 E8 ?? ?? ?? ?? 8B 55 F8 8B 08 FF 91 00 01 00 00 EB 39 8B 75 F4 4E 85 F6 7C 31 46 33 FF 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 50 57 6A 01 8B 45 F8 50 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 C8 58 8B 08 FF 91 00 01 00 00 47 4E 75 D2 33 F6 F6 45 0C 02 74 38 8B 45 F0 E8 ?? ?? ?? ?? 80 78 48 01 75 2A FF 4D F4 8B 45 F0 E8 ?? ?? ?? ?? 8D 55 C4 8B 08 FF 91 80 00 00 00 8B 45 C4 89 45 C0 8B 45 C0 85 C0 74 05 83 E8 04 8B 00 8B F0 53 53 56 0F B7 45 F4 50 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 66 89 45 EA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 66 83 7D EA 00 0F 94 C0 22 45 08 0F 84 8A 00 00 00 8B 45 FC 8B 80 80 01 00 00 3B 45 EC 74 7C 8B 45 EC 50 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 EA EB 63 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 45 0C 50 6A 02 8B 4D F8 8B 55 F0 8B 45 FC E8 ?? ?? ?? ?? 8B F0 56 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 6A 00 53 6A 00 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 66 89 45 EA 56 8B 45 FC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 66 83 7D EA 00 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 E8 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TBDEDataSet.Lookup"
		size = 156
		refs = "0014 Null 001b TBDEDataSet.Lookup 002a TBDEDataSet.LocateRecord 0038 TDataSet.SetTempState 006a TDataSet.GetFieldValue 0081 TDataSet.RestoreState 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 8B DA 89 45 FC 8B 75 08 8B C6 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 50 6A 00 8B CF 8B D3 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 5B B2 05 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 7D FC 8B 47 58 8B 57 64 8B 14 82 8B 45 FC 8B 08 FF 91 B8 00 00 00 8B CE 8B 55 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 5D C2 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_15469_0 {
	meta:
		name = "TCustomClientDataSet.Lookup"
		size = 156
		refs = "0014 Null 001b TCustomClientDataSet.Lookup 002a TCustomClientDataSet.LocateRecord 0038 TDataSet.SetTempState 006a TDataSet.GetFieldValue 0081 TDataSet.RestoreState 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 8B DA 89 45 FC 8B 75 08 8B C6 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 50 6A 00 8B CF 8B D3 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 5B B2 05 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 7D FC 8B 47 58 8B 57 64 8B 14 82 8B 45 FC 8B 08 FF 91 B8 00 00 00 8B CE 8B 55 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 5D C2 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TBDEDataSet.Locate"
		size = 88
		refs = "0024 TBDEDataSet.LocateRecord 0031 TBDEDataSet.Locate"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 8B 10 FF 92 34 01 00 00 0F B6 45 08 50 6A 01 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 84 DB 74 1B 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 8B C6 8B 10 FF 92 10 01 00 00 8B C3 5F 5E 5B 5D C2 04 00 00 00 03 00 00 00 }
	condition:
		$1
}

rule function_15470_0 {
	meta:
		name = "TCustomClientDataSet.Locate"
		size = 88
		refs = "0024 TCustomClientDataSet.LocateRecord 0031 TCustomClientDataSet.Locate"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 8B 10 FF 92 34 01 00 00 0F B6 45 08 50 6A 01 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 84 DB 74 1B 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 8B C6 8B 10 FF 92 10 01 00 00 8B C3 5F 5E 5B 5D C2 04 00 00 00 03 00 00 00 }
	condition:
		$1
}

rule function_14580_0 {
	meta:
		name = "TCustomSQLDataSet.Locate"
		size = 88
		refs = "0024 TCustomSQLDataSet.LocateRecord 0031 TCustomSQLDataSet.Locate"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 8B 10 FF 92 34 01 00 00 0F B6 45 08 50 6A 01 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 84 DB 74 1B 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 8B C6 8B 10 FF 92 10 01 00 00 8B C3 5F 5E 5B 5D C2 04 00 00 00 03 00 00 00 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "TBDEDataSet.HasConstraints"
		size = 78
		refs = "001d TFields.GetCount 0031 TFields.GetField"
	strings:
		$1 = { 53 56 57 55 8B F8 B3 01 8B 87 88 00 00 00 8B 40 08 83 78 08 00 7F 30 8B C7 8B 40 38 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 7C 1D 45 33 F6 8B 47 38 8B D6 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 00 00 00 84 C0 75 06 46 4D 75 E6 33 DB 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TBDEDataSet.ConstraintsDisabled"
		size = 11
	strings:
		$1 = { 83 B8 FC 01 00 00 00 0F 9F C0 C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "TBDEDataSet.DisableConstraints"
		size = 38
		refs = "001a SetBoolProp"
	strings:
		$1 = { 53 8B D8 83 BB FC 01 00 00 00 75 12 33 C9 BA 9B 00 05 04 8B 83 80 01 00 00 E8 ?? ?? ?? ?? FF 83 FC 01 00 00 5B C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "TBDEDataSet.EnableConstraints"
		size = 44
		refs = "0027 SetBoolProp"
	strings:
		$1 = { 83 B8 FC 01 00 00 00 74 22 FF 88 FC 01 00 00 83 B8 FC 01 00 00 00 75 13 83 C9 FF BA 9B 00 05 04 8B 80 80 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "GetFieldConstraint"
		size = 356
		refs = "0010 GetFieldConstraint 0031 @UStrFromArray 003f TDataSet.FindField 0078 @LStrFromUStr 0080 @LStrToPChar 0092 StrCopy 0148 @LStrArrayClr 0150 @UStrClr 0156 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8D 45 FC 8B 55 08 8B 52 10 81 C2 27 01 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 08 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 E5 00 00 00 80 7E 4D 00 75 16 83 BE 8C 00 00 00 00 75 0D 83 BE 88 00 00 00 00 0F 84 C9 00 00 00 8D 45 F8 8B 96 8C 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 67 01 00 00 E8 ?? ?? ?? ?? 8D 45 F4 8B 96 88 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 68 21 00 00 E8 ?? ?? ?? ?? 8D 45 F0 8B 96 90 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 E9 41 00 00 E8 ?? ?? ?? ?? 8D 45 EC 8B 96 90 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 69 41 00 00 E8 ?? ?? ?? ?? 80 7E 4D 01 F5 1B C0 8B 55 08 8B 52 10 89 82 69 42 00 00 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_646_0 {
	meta:
		name = "GetTableConstraint"
		size = 260
		refs = "000e GetTableConstraint 002f TCheckConstraints.GetItem 0041 @LStrFromUStr 0049 @LStrToPChar 005b StrCopy 00f3 @LStrArrayClr 00f9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 10 0F B7 12 4A 8B 45 08 8B 40 08 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 8B D8 8D 45 FC 8B 53 0C B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 67 01 00 00 E8 ?? ?? ?? ?? 8D 45 F8 8B 53 10 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 68 21 00 00 E8 ?? ?? ?? ?? 8D 45 F4 8B 53 14 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 E9 41 00 00 E8 ?? ?? ?? ?? 8D 45 F0 8B 53 14 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 69 41 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 04 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_647_0 {
	meta:
		name = "GetDefaultExpression"
		size = 171
		refs = "000d GetDefaultExpression 002e @UStrFromArray 003c TDataSet.FindField 005e @LStrFromUStr 0066 @LStrToPChar 0078 StrCopy 008f @LStrClr 0097 @UStrClr 009d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8D 45 FC 8B 55 08 8B 52 10 81 C2 27 01 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 08 E8 ?? ?? ?? ?? 8B F0 85 F6 74 38 83 BE 94 00 00 00 00 74 2F 8D 45 F8 8B 96 94 00 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 10 05 67 01 00 00 E8 ?? ?? ?? ?? B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_648_0 {
	meta:
		name = "TBDEDataSet.ConstraintCallBack"
		size = 204
		refs = "0011 TBDEDataSet.ConstraintCallBack 004c GetFieldSource 005e GetFieldConstraint 0071 GetDefaultExpression 00a1 GetTableConstraint 00b7 @HandleAnyException 00bc @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 66 C7 45 FE 04 2A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C 83 C0 FD 83 F8 04 0F 87 82 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 55 10 8B 45 08 E8 ?? ?? ?? ?? 84 C0 74 58 66 C7 45 FE 00 00 EB 50 55 E8 ?? ?? ?? ?? 59 84 C0 74 45 66 C7 45 FE 00 00 EB 3D 55 E8 ?? ?? ?? ?? 59 84 C0 74 32 66 C7 45 FE 00 00 EB 2A 8B 45 08 8B 80 88 00 00 00 8B 40 08 8B 40 08 8B 55 10 66 89 02 66 C7 45 FE 00 00 EB 0D 55 E8 ?? ?? ?? ?? 59 66 C7 45 FE 00 00 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 45 FE 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_649_0 {
	meta:
		name = "TBDEDataSet.AllocCachedUpdateBuffers"
		size = 131
		refs = "000e AllocMem 005e @FreeMem 007c DisposeMem"
	strings:
		$1 = { 53 56 8B D8 84 D2 74 48 B8 10 00 00 00 E8 ?? ?? ?? ?? 89 83 D0 01 00 00 0F B7 83 08 02 00 00 E8 ?? ?? ?? ?? 8B 93 D0 01 00 00 89 42 08 0F B7 83 08 02 00 00 E8 ?? ?? ?? ?? 8B B3 D0 01 00 00 89 46 0C 0F B7 83 00 02 00 00 66 89 46 06 5E 5B C3 8B 83 D0 01 00 00 85 C0 74 26 8B 40 08 E8 ?? ?? ?? ?? 8B 83 D0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8D 83 D0 01 00 00 BA 10 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_650_0 {
	meta:
		name = "TBDEDataSet.CheckCachedUpdateMode"
		size = 87
		refs = "000c TBDEDataSet.CheckCachedUpdateMode 0023 SNoCachedUpdates 0028 LoadResString 0032 DatabaseError 0047 @UStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB CA 01 00 00 00 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "TBDEDataSet.UpdateCallbackRequired"
		size = 44
	strings:
		$1 = { 80 B8 CA 01 00 00 00 74 1D 66 83 B8 32 02 00 00 00 75 16 66 83 B8 3A 02 00 00 00 75 0C 83 B8 28 02 00 00 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "TBDEDataSet.ForceUpdateCallback"
		size = 34
	strings:
		$1 = { 80 B8 CA 01 00 00 00 74 13 66 83 B8 3A 02 00 00 00 75 0C 83 B8 28 02 00 00 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "ReAllocBuffers"
		size = 166
		refs = "001b TBDEDataSet.FreeKeyBuffers 0033 ReAllocBuffers 0046 TBDEDataSet.InitBufferPointers 0069 TBDEDataSet.AllocKeyBuffers 0078 @HandleAnyException 0085 TDataSet.SetState 0098 @RaiseAgain 009d @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 8B 40 FC 8B 10 FF 92 44 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 33 D2 8B 08 FF 91 C0 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 50 54 42 8B 45 08 8B 40 FC 8B 08 FF 91 C0 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 2A E9 ?? ?? ?? ?? 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 10 FF 92 D4 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "TBDEDataSet.SetCachedUpdates"
		size = 268
		refs = "0040 TDataSet.CheckBrowseMode 0048 TDataSet.UpdateCursorPos 0062 DbiEndConstraintLayer 007c DbiEndDelayedUpdates 0081 Check 0091 DbiBeginDelayedUpdates 00ab TBDEDataSet.ConstraintCallBack 00bc DbiBeginConstraintLayer 00d0 ReAllocBuffers 00db TBDEDataSet.AllocCachedUpdateBuffers 00e3 TBDEDataSet.UpdateCallbackRequired 00ed TBDEDataSet.SetupCallBack 00f4 TBDEDataSet.SetCachedUpdates"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 80 B8 A5 00 00 00 00 74 09 8B 45 FC F6 40 1C 10 74 0E 8B 45 FC 88 98 CA 01 00 00 E9 D6 00 00 00 8B 45 FC 3A 98 CA 01 00 00 0F 84 C7 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 0A 02 00 00 00 74 0E 8B 45 FC 05 80 01 00 00 50 E8 ?? ?? ?? ?? 8B 45 FC 80 B8 CA 01 00 00 00 74 15 8B 45 FC 05 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 13 8B 45 FC 05 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 80 B8 0A 02 00 00 00 74 1F 8B 45 FC 50 B8 ?? ?? ?? ?? 50 8B 45 FC 05 80 01 00 00 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 88 98 CA 01 00 00 55 E8 ?? ?? ?? ?? 59 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B 45 FC 8B 08 FF 91 B4 02 00 00 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "TBDEDataSet.SetupCallBack"
		size = 95
		refs = "002a TBDEDataSet.CachedUpdateCallBack 0035 _DV_TBDECallback 003a TBDECallback.Create 0051 TObject.Free"
	strings:
		$1 = { 53 8B D8 84 D2 74 3F F6 43 1C 10 75 50 83 BB D4 01 00 00 00 75 47 8B 83 80 01 00 00 50 6A 19 8B 83 D0 01 00 00 50 6A 10 53 68 ?? ?? ?? ?? 6A 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 D4 01 00 00 EB 17 8B 83 D4 01 00 00 85 C0 74 0D E8 ?? ?? ?? ?? 33 C0 89 83 D4 01 00 00 5B C3 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "TBDEDataSet.ProcessUpdates"
		size = 36
		refs = "0009 TBDEDataSet.CheckCachedUpdateMode 0010 TDataSet.UpdateCursorPos 001d DbiApplyDelayedUpdates"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 56 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "TBDEDataSet.ApplyUpdates"
		size = 59
		refs = "001e TBDEDataSet.ProcessUpdates 002e Abort 0035 DbiError"
	strings:
		$1 = { 53 8B D8 80 BB A5 00 00 00 01 74 0A 8B C3 8B 10 FF 92 B0 02 00 00 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 66 85 C0 74 12 66 3D 06 33 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "TBDEDataSet.CommitUpdates"
		size = 40
		refs = "0008 TBDEDataSet.ProcessUpdates 000d Check 0014 TBDEDataSet.CommitUpdates"
	strings:
		$1 = { 56 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 5E C3 00 00 00 00 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "TBDEDataSet.CancelUpdates"
		size = 60
		refs = "0015 TBDEDataSet.ProcessUpdates 001c TDataSet.GetActive 0027 TBDEDataSet.CancelUpdates"
	strings:
		$1 = { 56 8B F0 8B C6 8B 10 FF 92 68 02 00 00 BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 11 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 5E C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_660_0 {
	meta:
		name = "TBDEDataSet.RevertRecord"
		size = 80
		refs = "0022 TBDEDataSet.ProcessUpdates 0032 Check 0039 TBDEDataSet.RevertRecord"
	strings:
		$1 = { 56 8B F0 0F B6 86 A5 00 00 00 04 FE 2C 03 73 0A 8B C6 8B 10 FF 92 68 02 00 00 BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 66 85 C0 74 0B 66 3D 01 30 74 05 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 5E C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_661_0 {
	meta:
		name = "TBDEDataSet.UpdateStatus"
		size = 51
	strings:
		$1 = { 80 B8 CA 01 00 00 00 74 27 80 B8 A5 00 00 00 05 75 05 8B 50 68 EB 0B 8B D0 8B 4A 5C 8B 52 64 8B 14 8A 0F B7 80 04 02 00 00 03 D0 0F B6 42 04 C3 33 C0 C3 }
	condition:
		$1
}

rule function_662_0 {
	meta:
		name = "TBDEDataSet.CachedUpdateCallBack"
		size = 333
		refs = "002e TBDEDataSet.CachedUpdateCallBack 0081 DbiError 0093 @HandleOnException 009b _Dn_Exception 00a9 _DV_EDBEngineError 00ae @IsClass 00bb EDBEngineError.GetError 00d3 _Dn_EDatabaseError 0110 ApplicationHandleException 0119 @DoneExcept 0124 CBRetCode"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 8B 45 FC C6 80 CB 01 00 00 01 C6 45 FB 00 8B 45 FC 8B 90 D0 01 00 00 8B 42 02 48 88 45 FA 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 66 83 B8 3A 02 00 00 00 74 1C 8D 45 FB 50 0F B6 4D FA 8B 5D FC 8B 55 FC 8B 83 3C 02 00 00 FF 93 38 02 00 00 EB 24 8B 45 FC 8B 80 28 02 00 00 85 C0 74 0F 0F B6 55 FA 8B 08 FF 51 48 C6 45 FB 04 EB 08 0F B7 02 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 E9 8B 00 00 00 E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 33 D2 8B C3 E8 ?? ?? ?? ?? 0F B7 40 04 8B 55 FC 8B 92 D0 01 00 00 66 89 02 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 8B 45 FC 66 83 B8 32 02 00 00 00 74 1F 0F B6 45 FA 50 8D 45 FB 50 8B 75 FC 8B CB 8B 55 FC 8B 86 34 02 00 00 FF 96 30 02 00 00 EB 0C 8B 45 FC E8 ?? ?? ?? ?? C6 45 FB 01 E8 ?? ?? ?? ?? 0F B6 45 FB 8B 04 85 ?? ?? ?? ?? 80 7D FB 01 75 0E 8B 55 FC 8B 92 D0 01 00 00 66 C7 02 06 33 8B 55 FC C6 82 CB 01 00 00 00 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_663_0 {
	meta:
		name = "TBDEDataSet.GetUpdateRecordSet"
		size = 60
		refs = "0007 TDataSet.GetActive 0012 TBDEDataSet.CheckCachedUpdateMode 0022 GetIntProp 002d TBDEDataSet.GetUpdateRecordSet"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 74 1B 8B C6 E8 ?? ?? ?? ?? BA 03 00 05 05 8B 86 80 01 00 00 E8 ?? ?? ?? ?? 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 8B C3 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "TBDEDataSet.SetUpdateRecordSet"
		size = 80
		refs = "000a TBDEDataSet.CheckCachedUpdateMode 0011 TDataSet.CheckBrowseMode 0018 TDataSet.UpdateCursorPos 002e DbiSetProp 0033 Check 003a TBDEDataSet.SetUpdateRecordSet"
	strings:
		$1 = { 56 51 88 14 24 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 04 24 50 68 03 00 05 05 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 5A 5E C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_665_0 {
	meta:
		name = "TBDEDataSet.SetUpdateObject"
		size = 156
		refs = "005d _DV_TBDEDataSet 0062 @IsClass 0087 TBDEDataSet.SetUpdateObject"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 3B B3 28 02 00 00 0F 84 85 00 00 00 8B BB 28 02 00 00 85 FF 74 18 8B C7 8B 10 FF 52 40 3B D8 75 0D 33 D2 8B 83 28 02 00 00 8B 08 FF 51 44 8B C6 89 83 28 02 00 00 85 C0 74 57 8B 83 28 02 00 00 8B 10 FF 52 40 85 C0 74 3B 8B 83 28 02 00 00 8B 10 FF 52 40 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B 83 28 02 00 00 8B 10 FF 52 40 3B D8 74 12 8B 83 28 02 00 00 8B 10 FF 52 40 33 D2 E8 ?? ?? ?? ?? 8B D3 8B 83 28 02 00 00 8B 08 FF 51 44 5F 5E 5B C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TBDEDataSet.SetOnUpdateError"
		size = 56
		refs = "0009 TDataSet.GetActive 0014 TBDEDataSet.UpdateCallbackRequired 001d TBDEDataSet.SetupCallBack"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 89 83 30 02 00 00 8B 45 0C 89 83 34 02 00 00 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TBDEDataSet.GetUpdatesPending"
		size = 26
		refs = "000f GetIntProp"
	strings:
		$1 = { 53 8B D8 BA 05 00 05 05 8B 83 80 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 9F C0 5B C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "CheckIfParentScrolled"
		size = 160
		refs = "0063 TDataSet.First 007c TDataSet.UpdateCursorPos 0089 CheckIfParentScrolled"
	strings:
		$1 = { 55 8B EC 53 56 57 33 DB 8B 45 08 8B 40 FC 8B 80 24 02 00 00 8B D0 8B 4A 5C 3B 4A 58 7D 27 8B 50 6C 4A 85 D2 7C 1F 42 33 C9 8B 70 5C 8B 78 64 8B 34 B7 0F B7 B8 02 02 00 00 03 F9 0F B6 34 3E 03 DE 41 4A 75 E4 8B 45 08 8B 40 FC 8B 80 1C 02 00 00 85 C0 74 07 8B 55 08 3B C3 74 19 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 89 98 1C 02 00 00 EB 20 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 0F B6 15 ?? ?? ?? ?? 8B 08 FF 91 B4 02 00 00 5F 5E 5B 5D C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TBDEDataSet.DataEvent"
		size = 42
		refs = "0014 CheckIfParentScrolled 0021 TDataSet.DataEvent"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 80 FB 0B 75 07 55 E8 ?? ?? ?? ?? 59 8B D3 8B CE 8B 45 FC E8 ?? ?? ?? ?? 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TBDEDataSet.PSGetUpdateException"
		size = 87
		refs = "000d _DV_EDBEngineError 0012 @IsClass 002a EDBEngineError.GetError 003d _Dn_EUpdateError 0042 EUpdateError.Create 004f TDataSet.PSGetUpdateException"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2E 85 FF 74 05 8B 77 18 EB 02 33 F6 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 0F B7 40 04 50 56 53 8B 4B 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0B 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TBDEDataSet.PSReset"
		size = 28
		refs = "0006 TDataSet.PSReset 0016 DbiForceReread"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 80 01 00 00 85 C0 74 06 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TBDEDataSet.PSUpdateRecord"
		size = 61
	strings:
		$1 = { 53 51 33 DB 66 83 B8 3A 02 00 00 00 74 2A C6 04 24 00 66 83 B8 3A 02 00 00 00 74 1C 54 8B D8 8B C1 8B CA 8B D0 8B 83 3C 02 00 00 FF 93 38 02 00 00 80 3C 24 04 0F 94 C3 8B C3 5A 5B C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TNestedTable.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TBDEDataSet.Create 0020 TDataSet.SetObjectView 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_84144_0 {
	meta:
		name = "TAlphaBitmap.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TBitmap.Create 0020 TBitmap.SetAlphaFormat 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_93523_0 {
	meta:
		name = "TChartAxisTitle.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TTeeCustomShape.Create 0020 TTeeCustomShape.InitTransparent 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5352_0 {
	meta:
		name = "TNumericField.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TField.Create 0020 TField.SetAlignment 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_78703_0 {
	meta:
		name = "TRichEditAction.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TAction.Create 0020 TCustomAction.SetAutoCheck 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38997_0 {
	meta:
		name = "TWebBrowserDesignMode.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TCustomWebBrowserAction.Create 0020 TCustomAction.SetAutoCheck 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_39058_0 {
	meta:
		name = "TWebBrowserSeamlessJoin.Create"
		size = 62
		refs = "000a @ClassCreate 0017 TWebBrowserUndoAction.Create 0020 TCustomAction.SetAutoCheck 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TNestedTable.CreateHandle"
		size = 294
		refs = "0014 TNestedTable.CreateHandle 002b SNoDataSetField 0030 LoadResString 003a DatabaseError 0049 _DV_TBDEDataSet 004e @AsClass 005f TDataSet.OpenParentDataSet 0096 DbiOpenNestedTable 009b Check 00bc DbiOpenRef 00d6 TFieldDefs.SetHiddenFields 0110 @UStrClr 0116 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 8C 00 00 00 00 75 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 8B 40 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 24 02 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 83 24 02 00 00 8B B8 80 01 00 00 8B B3 8C 00 00 00 80 7E 48 1D 75 26 8D 45 FC 50 6A 00 80 7E 49 01 F5 1B C0 50 8B C6 8B 10 FF 92 A8 00 00 00 50 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 24 8D 45 FC 50 6A 00 80 7E 49 01 F5 1B C0 50 8B C6 8B 10 FF 92 A8 00 00 00 50 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 24 02 00 00 8B 40 40 0F B6 50 3C 8B 43 40 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 80 B8 10 01 00 00 00 74 0C C7 83 A0 00 00 00 01 00 00 00 EB 0A C7 83 A0 00 00 00 02 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TNestedTable.DoAfterPost"
		size = 314
		refs = "001e TNestedTable.DoAfterPost 005b DbiGetProp 0060 Check 00b5 VarArrayCreate 00bd VarArrayLock 00dc Move 00f1 VarArrayUnlock 00f7 @HandleFinally 0115 TDataSet.DoAfterPost 012a @VarClr"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 33 D2 89 55 F0 89 55 F4 89 55 F8 89 55 FC 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 8B 80 8C 00 00 00 80 78 48 1C 0F 85 D6 00 00 00 8D 45 EA 50 68 00 01 00 00 8D 85 EA FE FF FF 50 68 07 00 05 04 8B 45 EC 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 8B 80 8C 00 00 00 8B 10 FF 92 9C 00 00 00 0F B7 55 EA 3B C2 0F 8C 90 00 00 00 8D 45 F0 50 33 C0 89 85 E0 FE FF FF 8B 45 EC 8B 80 8C 00 00 00 8B 10 FF 92 9C 00 00 00 48 89 85 E4 FE FF FF 8D 85 E0 FE FF FF 66 B9 11 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 0F B7 4D EA 8B D0 8D 85 EA FE FF FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8D 55 F0 8B 45 EC 8B 80 8C 00 00 00 8B 08 FF 91 00 01 00 00 8B 45 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TNestedTable.DoBeforeInsert"
		size = 53
		refs = "0006 TDataSet.DoBeforeInsert"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 80 78 48 1D 75 1D 8B 83 24 02 00 00 80 B8 A5 00 00 00 03 75 0E 8B 83 24 02 00 00 8B 10 FF 92 B0 02 00 00 5B C3 }
	condition:
		$1
}

rule function_678_0 {
	meta:
		name = "TNestedTable.InternalPost"
		size = 234
		refs = "0012 TNestedTable.InternalPost 001f TBDEDataSet.InternalPost 0051 TField.GetDisplayName 0067 SNoReferenceTableName 006c LoadResString 0077 DatabaseErrorFmt 0090 @LStrFromUStr 0098 @LStrToPChar 00aa DbiSetProp 00af Check 00cb @LStrClr 00d8 @UStrArrayClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B B3 8C 00 00 00 80 7E 48 1C 0F 85 80 00 00 00 80 BB A5 00 00 00 03 75 77 83 BE 18 01 00 00 00 75 36 6A 00 8D 55 F4 8B 83 8C 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 89 45 F8 C6 45 FC 11 8D 45 F8 50 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 33 C9 5A E8 ?? ?? ?? ?? 8D 45 EC 8B 93 8C 00 00 00 8B 92 18 01 00 00 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 50 68 06 00 05 04 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TDBDataSet.Create"
		size = 120
		refs = "000f @ClassCreate 0021 TBDEDataSet.Create 0029 _DV_TDatabase 002e @IsClass 0041 TDBDataSet.SetDatabaseName 004e TDBDataSet.SetSessionName 0062 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B FE 8B 97 98 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 97 94 00 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 40 02 00 00 00 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TDBDataSet.SetHandle"
		size = 97
		refs = "0010 TDataSet.Close 0025 TDBDataSet.SetHandle 0033 TDataSet.Open 0042 @HandleAnyException 0052 @RaiseAgain 0057 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 89 98 80 01 00 00 85 DB 74 3A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1A E9 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 80 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TDBDataSet.OpenCursor"
		size = 67
		refs = "001a TBDEDataSet.OpenCursor 0028 TDBDataSet.SetUpdateMode 003b TDBDataSet.SetupAutoRefresh"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 B1 01 33 D2 8B C6 8B 38 FF 97 D8 02 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 96 43 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B 86 44 02 00 00 80 78 76 00 74 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TDBDataSet.CloseCursor"
		size = 26
		refs = "0006 TBDEDataSet.CloseCursor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 C9 33 D2 8B C3 8B 18 FF 93 D8 02 00 00 5B C3 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "TDBDataSet.CheckDBSessionName"
		size = 95
		refs = "001d Sessions 0022 TSessionList.FindSession 0037 TSession.DoFindDatabase 0040 DefaultSession 0058 TDatabase.CheckSessionName"
	strings:
		$1 = { 53 56 8B D8 83 BB 4C 02 00 00 00 74 4F 83 BB 48 02 00 00 00 74 46 8B 93 4C 02 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 30 8B CB 8B 93 48 02 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 75 1D E8 ?? ?? ?? ?? 8B CB 8B 93 48 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B2 01 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TDBDataSet.CheckOpen"
		size = 67
		refs = "001e TDBDataSet.GetDBSession 0023 TSession.GetPassword 002e DbiError"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 66 83 E8 01 72 08 66 2D 01 29 74 07 EB 21 B0 01 5E 5B C3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5E 5B C3 8B C3 E8 ?? ?? ?? ?? 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TCustomBindPosition.RequiresControlHandler"
		size = 17
		altNames = "TCustomClientDataSet.ConstraintsStored TDBDataSet.ConstraintsStored TIBCustomDataSet.ConstraintsStored"
	strings:
		$1 = { 8B 80 88 00 00 00 8B 40 08 83 78 08 00 0F 9F C0 C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TDBDataSet.GetDBHandle"
		size = 20
	strings:
		$1 = { 8B 90 44 02 00 00 85 D2 74 07 8B 82 80 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TDBDataSet.GetDBLocale"
		size = 20
	strings:
		$1 = { 8B 90 44 02 00 00 85 D2 74 07 8B 82 84 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TDBDataSet.GetDBSession"
		size = 44
		refs = "0019 Sessions 001e TSessionList.FindSession 0027 DefaultSession"
	strings:
		$1 = { 8B 90 44 02 00 00 85 D2 74 08 8B 82 88 00 00 00 EB 10 8B 90 4C 02 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TDBDataSet.OpenDatabase"
		size = 35
		refs = "000a Sessions 000f TSessionList.GetSessionByName 001d TSession.DoOpenDatabase"
	strings:
		$1 = { 53 8B D8 8B 93 4C 02 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4B 04 8B 93 48 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TDBDataSet.CloseDatabase"
		size = 16
		refs = "000b TSession.CloseDatabase"
	strings:
		$1 = { 85 D2 74 0B 8B 82 88 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "TDBDataSet.SetDatabaseName"
		size = 164
		refs = "000f TDBDataSet.SetDatabaseName 0028 @UStrAsg 0037 @UStrEqual 0054 SDatabaseOpen 0059 LoadResString 0063 DatabaseError 0093 @UStrClr 0099 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 F6 43 1C 02 74 0F 8D 83 48 02 00 00 8B D6 E8 ?? ?? ?? ?? EB 54 8B 83 48 02 00 00 8B D6 E8 ?? ?? ?? ?? 74 45 8B C3 8B 10 FF 92 C4 00 00 00 83 BB 44 02 00 00 00 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 8D 83 48 02 00 00 8B D6 E8 ?? ?? ?? ?? 33 C9 B2 08 8B C3 8B 18 FF 93 E4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "TDBDataSet.SetDBFlag"
		size = 264
		refs = "002f TDBDataSet.SetDBFlag 003f TDBDataSet.CheckDBSessionName 0046 TDBDataSet.OpenDatabase 006e TBDEDataSet.SetLocale 008d TSession.LoadSMClient 00c8 TDBDataSet.GetDBLocale 00f0 TSession.CloseDatabase"
	strings:
		$1 = { 53 56 57 55 51 88 0C 24 8B FA 8B F0 8B C7 83 F8 0F 77 08 66 0F A3 86 41 02 00 00 0F 92 C3 80 3C 24 00 74 7E 84 DB 0F 85 D0 00 00 00 0F B7 05 ?? ?? ?? ?? 66 3B 86 41 02 00 00 75 55 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B E8 89 AE 44 02 00 00 6A 00 6A 00 8B D6 8B C5 8B 08 FF 51 54 8B 86 44 02 00 00 8B 90 84 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 86 44 02 00 00 80 78 72 00 74 13 F6 46 1C 10 74 0D 8B 80 88 00 00 00 B2 01 E8 ?? ?? ?? ?? 8B C7 83 F8 0F 77 64 66 0F AB 86 41 02 00 00 EB 5A 84 DB 74 56 8B C7 83 F8 0F 77 08 66 0F B3 86 41 02 00 00 0F B7 05 ?? ?? ?? ?? 66 3B 86 41 02 00 00 75 37 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B D6 8B 86 44 02 00 00 8B 08 FF 51 5C 8B 86 44 02 00 00 8B 90 88 00 00 00 92 E8 ?? ?? ?? ?? 33 C0 89 86 44 02 00 00 8B C3 5A 5D 5F 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_694_0 {
	meta:
		name = "TDBDataSet.SetSessionName"
		size = 46
		refs = "0019 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 C4 00 00 00 8D 83 4C 02 00 00 8B D6 E8 ?? ?? ?? ?? 33 C9 B2 08 8B C3 8B 18 FF 93 E4 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "TDBDataSet.SetUpdateMode"
		size = 76
		refs = "003a DbiSetProp 003f Check"
	strings:
		$1 = { 53 56 8B DA 8B F0 83 BE 80 01 00 00 00 74 34 8B 86 44 02 00 00 80 78 76 00 74 28 8B C6 8B 10 FF 92 5C 01 00 00 84 C0 74 1A 0F B6 C3 50 68 00 00 05 04 8B 86 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 9E 43 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "TDBDataSet.SetAutoRefresh"
		size = 25
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 C4 00 00 00 88 9E 40 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TDBDataSet.SetupAutoRefresh"
		size = 132
		refs = "001f DbiSetProp 0024 Check 002c TFields.GetCount 0040 TFields.GetField 0064 PropFlags"
	strings:
		$1 = { 53 56 57 55 51 8B E8 80 BD 40 02 00 00 00 74 18 6A 01 68 17 00 05 00 8B 85 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 38 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 47 47 33 DB 8B 45 38 8B D3 E8 ?? ?? ?? ?? 8B F0 80 7E 38 00 74 2E 8B C3 40 66 89 04 24 66 C7 44 24 02 FF FF 8B C4 50 0F B6 46 38 8B 04 85 ?? ?? ?? ?? 50 8B 85 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 4F 75 BC 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "TDBDataSet.PSGetAttributes"
		size = 120
		refs = "000c TDataSet.PSGetAttributes 001b TPacketAttribute 0025 @New 0030 TList.Add 003b TDBDataSet.PSGetAttributes 0040 @UStrAsg 0053 @OleVarFromInt"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B D7 8B C3 E8 ?? ?? ?? ?? 83 BB 98 01 00 00 00 74 42 8B 15 ?? ?? ?? ?? B8 20 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B D6 8B C7 E8 ?? ?? ?? ?? 8B C6 8B F0 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 46 08 8B 93 98 01 00 00 8B 52 62 B1 FC E8 ?? ?? ?? ?? C6 46 18 00 5F 5E 5B C3 00 B0 04 02 00 FF FF FF FF 04 00 00 00 4C 00 43 00 49 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TDBDataSet.PSIsSQLBased"
		size = 111
		refs = "0023 TDBDataSet.PSIsSQLBased 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 45 FC B1 01 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 88 45 FA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 44 02 00 00 0F B6 40 76 88 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 4D FA BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E4 0F B6 45 FB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TDBDataSet.PSGetQuoteChar"
		size = 208
		refs = "0026 TDBDataSet.PSGetQuoteChar 0033 @UStrClr 006c DbiGetProp 007e @UStrFromWChar 008c @UStrAsg 00b3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 8B DA 89 45 FC B1 01 BA 0A 00 00 00 8B 45 FC 8B 30 FF 96 D8 02 00 00 88 45 F7 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 94 00 00 00 84 C0 74 3E 66 C7 45 FA 00 00 8D 45 F8 50 6A 02 8D 45 FA 50 68 0A 00 04 04 8B 45 FC 8B 80 44 02 00 00 8B 80 80 00 00 00 50 E8 ?? ?? ?? ?? 66 83 7D FA 00 74 19 8B C3 0F B7 55 FA E8 ?? ?? ?? ?? EB 0C 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 4D F7 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E4 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 22 00 00 00 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TDBDataSet.PSInTransaction"
		size = 86
		refs = "000d Sessions 0012 TSessionList.GetSessionByName 0034 TSession.DoFindDatabase 0041 TDatabase.GetInTransaction"
	strings:
		$1 = { 53 56 8B F0 33 DB 8B 96 4C 02 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 37 8B 96 4C 02 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4E 04 8B 96 48 02 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 8B D8 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "TDBDataSet.PSStartTransaction"
		size = 133
		refs = "0020 TDBDataSet.PSStartTransaction 0050 TDatabase.StartTransaction 005f @HandleAnyException 0076 @RaiseAgain 007b @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC B1 01 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 94 00 00 00 84 C0 75 0D 8B 45 FC 8B 80 44 02 00 00 C6 40 70 00 8B 45 FC 8B 80 44 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 21 E9 ?? ?? ?? ?? 33 C9 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "TDBDataSet.PSEndTransaction"
		size = 105
		refs = "000e TDBDataSet.PSEndTransaction 0022 TDatabase.ClearStatements 002c EndType 003a TDatabase.EndTransaction 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 44 02 00 00 E8 ?? ?? ?? ?? 0F B6 C3 8B 14 85 ?? ?? ?? ?? 8B 45 FC 8B 80 44 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 5B 59 5D C3 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "TDBDataSet.PSExecuteStatement"
		size = 196
		refs = "002d TDBDataSet.PSExecuteStatement 0050 TDatabase.Execute 005c _DV_TDBDataSet 0061 TDBDataSet.Create 006f TDBDataSet.SetHandle 00b2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 4D F8 8B F2 89 45 FC 8B 5D 08 B1 01 BA 0A 00 00 00 8B 45 FC 8B 38 FF 97 D8 02 00 00 88 45 F3 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 3A 6A 01 8D 45 EC 50 8B 45 FC 8B 80 44 02 00 00 8B 4D F8 8B D6 E8 ?? ?? ?? ?? 89 45 F4 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 33 8B C6 8B 55 EC E8 ?? ?? ?? ?? EB 1A 6A 01 6A 00 8B 45 FC 8B 80 44 02 00 00 8B 4D F8 8B D6 E8 ?? ?? ?? ?? 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 4D F3 BA 0A 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E4 8B 45 F4 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "TDBDataSet.PSUpdateRecord"
		size = 137
		refs = "0014 TBDEDataSet.PSUpdateRecord 002f _DV_TUpdateSQL 0034 @IsClass 0059 @UStrAsg"
	strings:
		$1 = { 53 56 57 51 8B F9 88 14 24 8B F0 0F B6 14 24 8B CF 8B C6 E8 ?? ?? ?? ?? 8B D8 84 DB 75 64 83 BE 28 02 00 00 00 74 5B 8B 86 28 02 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 46 8B D7 8B 86 28 02 00 00 8B 08 FF 51 44 8B 86 28 02 00 00 83 C0 3C 8B 96 48 02 00 00 E8 ?? ?? ?? ?? 8B 86 28 02 00 00 83 C0 40 8B 96 4C 02 00 00 E8 ?? ?? ?? ?? 0F B6 14 24 8B 86 28 02 00 00 8B 08 FF 51 48 B3 01 8B C3 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "TBatchMove.Create"
		size = 80
		refs = "000a @ClassCreate 0017 TComponent.Create 002a _Dn_TStringList 002f TStringList.Create 003d @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 41 01 C6 46 42 01 C6 46 43 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 58 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "TBatchMove.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TComponent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 58 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47079_0 {
	meta:
		name = "TXMLButton.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000f TObject.Free 001a TWebContainedComponent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 58 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TBatchMove.ConvertName"
		size = 34
		refs = "0016 AnsiToNative"
	strings:
		$1 = { 53 56 8B F1 8B DA 85 DB 74 13 68 04 01 00 00 8B CE 8B D3 33 C0 E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "GetMappingNames"
		size = 188
		refs = "000a GetMappingNames 0034 Pos 0051 @UStrCopy 0078 @UStrLAsg 009b @UStrClr 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B 45 08 8B 50 F8 8B 45 08 8B 40 FC 8B 40 58 8B 18 FF 53 0C 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7E 30 8B 45 08 83 C0 F4 50 8B CB 49 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 83 C0 F0 50 8D 53 01 B9 FF 00 00 00 8B 45 FC E8 ?? ?? ?? ?? EB 1C 8B 45 08 83 C0 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 08 83 C0 F0 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "TBatchMove.Execute"
		size = 1103
		refs = "0024 TBatchMove.Execute 0050 SInvalidBatchMove 0055 LoadResString 0063 DatabaseError 006e TDataSet.GetActive 008e TFieldMap 0093 @DynArrayClear 00ac TDataSet.DisableControls 00c2 TDataSet.Open 00cd TDataSet.CheckBrowseMode 00d8 TDataSet.UpdateCursorPos 00f3 TDataSet.Close 0116 TDataSet.SetFieldDefs 0126 TCollection.Clear 0146 GetMappingNames 0158 TFieldDefs.Find 0161 TFieldDef.GetSize 017f TFieldDefs.Add 01a1 TTable.CreateTable 01f7 @DynArraySetLength 0231 TFieldDef.GetFieldNo 028b DbiSetToBegin 0290 Check 02d5 TDBDataSet.GetDBHandle 02db DbiSetProp 0331 TBatchMove.ConvertName 037a TBDEDataSet.GetHandle 0391 DbiBatchMove 03b4 TDataSet.First 03ba @HandleFinally 03f6 TDataSet.EnableControls 0421 @UStrClr 043c @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 81 C4 D4 FC FF FF 53 56 57 33 D2 89 95 D4 FC FF FF 89 55 EC 89 55 F4 89 55 F0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 38 85 C0 74 11 8B 55 FC 83 7A 3C 00 74 08 8B 55 FC 3B 42 3C 75 1E 8D 95 D4 FC FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 D4 FC FF FF 8B 55 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 88 45 EB 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 88 45 EA 66 C7 45 E8 00 00 8D 45 EC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 0F B6 58 40 80 FB 04 0F 85 BB 00 00 00 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 58 8B 10 FF 52 14 85 C0 75 16 8B 45 FC 8B 40 3C 8B 50 40 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? EB 6D 8B 45 FC 8B 40 38 8B 40 40 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 58 8B 10 FF 52 14 8B F8 4F 85 FF 7C 4D 47 C7 45 F8 00 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 40 3C 8B 40 40 8B 55 F0 E8 ?? ?? ?? ?? 8B F0 8B C6 E8 ?? ?? ?? ?? 50 F6 46 26 04 0F 95 C0 50 0F B6 4E 25 8B 45 FC 8B 40 38 8B 40 40 8B 55 F4 E8 ?? ?? ?? ?? FF 45 F8 4F 75 BB 8B 45 FC 8B 40 38 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 33 DB 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 58 8B 10 FF 52 14 85 C0 0F 84 8B 00 00 00 8B 45 FC 8B 40 38 8B 40 40 8B 40 08 8B 40 08 66 89 45 E8 0F B7 45 E8 50 8D 45 EC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B 40 58 8B 10 FF 52 14 8B F8 4F 85 FF 7C 4B 47 C7 45 F8 00 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 40 3C 8B 40 40 8B 55 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 45 FC 8B 40 38 8B 40 40 8B 55 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 66 89 74 42 FE FF 45 F8 4F 75 BD 8B 45 FC 83 78 44 00 7E 19 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 44 8B 55 FC 89 42 48 EB 21 8B 45 FC 8B 40 3C 8B 80 80 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC C7 40 48 FF FF FF 7F 8B 45 FC 8B 40 3C C7 40 60 FF FF FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 68 00 7E 22 8B 45 FC 8B 40 68 50 68 06 00 04 04 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 80 78 43 01 F5 1B C0 50 8B 45 FC 83 C0 48 50 8B 45 FC 80 78 41 01 F5 1B C0 50 8B 45 FC 80 78 42 01 F5 1B C0 50 8B 45 FC 83 C0 54 50 8B 45 FC 83 C0 4C 50 8B 45 FC 83 C0 50 50 8D 8D D9 FC FF FF 8B 45 FC 8B 50 64 8B 45 FC E8 ?? ?? ?? ?? 50 8D 8D DE FD FF FF 8B 45 FC 8B 50 60 8B 45 FC E8 ?? ?? ?? ?? 50 8D 8D E3 FE FF FF 8B 45 FC 8B 50 5C 8B 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 00 8B 45 EC 50 0F B7 45 E8 50 0F B6 C3 50 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 50 6A 00 8B 45 FC 8B 40 3C 8B 80 80 01 00 00 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D EA 00 74 0B 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D EA 00 75 0B 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 80 7D EB 00 75 0B 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 D4 FC FF FF E8 ?? ?? ?? ?? 8D 45 EC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D2 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "TBatchMove.Notification"
		size = 53
		refs = "0010 TComponent.Notification 002d TBatchMove.SetSource"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 18 3B 77 38 75 05 33 C0 89 47 38 3B 77 3C 75 09 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "TBatchMove.SetMappings"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 46 58 8B 08 FF 51 08 5F 5E C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TBatchMove.SetSource"
		size = 14
		refs = "0009 TComponent.FreeNotification"
		altNames = "TDdeServerItem.SetServerConv"
	strings:
		$1 = { 89 50 3C 85 D2 74 06 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TIWCallBacks.Create"
		size = 60
		refs = "000b @ClassCreate 001a TStringList.Create 0028 @AfterConstruction"
		altNames = "TIndexFiles.Create TTabList.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 58 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_80488_0 {
	meta:
		name = "TBitmapCanvas.Create"
		size = 60
		refs = "000b @ClassCreate 001a TCanvas.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 58 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_83106_0 {
	meta:
		name = "TPrinterCanvas.Create"
		size = 60
		refs = "000b @ClassCreate 001a TCanvas.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 58 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TIndexFiles.Add"
		size = 53
		refs = "000d TDataSet.GetActive 001a TTable.OpenIndexFile 002d TStringList.Add"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 5E 58 8B C3 E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 83 54 02 00 00 C6 40 20 00 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "TIndexFiles.Clear"
		size = 143
		refs = "0014 TIndexFiles.Clear 0028 TDataSet.GetActive 005a TTable.CloseIndexFile 0067 TStringList.Clear 007c @UStrClr 0082 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 58 89 45 F8 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 34 8B C3 8B 10 FF 52 14 8B F0 4E 85 F6 7C 26 46 C7 45 FC 00 00 00 00 8D 4D F4 8B 55 FC 8B C3 8B 38 FF 57 0C 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? FF 45 FC 4E 75 E2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "TIndexFiles.Insert"
		size = 51
		refs = "000b TStringList.Insert 0015 TDataSet.GetActive 0022 TTable.OpenIndexFile"
	strings:
		$1 = { 53 56 8B F1 8B D8 8B CE 8B C3 E8 ?? ?? ?? ?? 8B 5B 58 8B C3 E8 ?? ?? ?? ?? 84 C0 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 83 54 02 00 00 C6 40 20 00 5E 5B C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "TIndexFiles.Delete"
		size = 126
		refs = "0017 TIndexFiles.Delete 0027 TDataSet.GetActive 0042 TTable.CloseIndexFile 0056 TStringList.Delete 006b @UStrClr 0071 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 58 8B C6 E8 ?? ?? ?? ?? 84 C0 74 17 8D 4D F8 8B 55 FC 8B C3 8B 38 FF 57 0C 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 86 54 02 00 00 C6 40 20 00 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "TTable.Create"
		size = 158
		refs = "000e @ClassCreate 001c TDBDataSet.Create 0025 _Dn_TIndexDefs 002a TIndexDefs.Create 0039 _Dn_TMasterDataLink 003e TMasterDataLink.Create 0050 TTable.MasterChanged 005a TTable.MasterDisabled 0063 _DV_TIndexFiles 0068 TIndexFiles.Create 0089 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 54 02 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 58 02 00 00 89 5E 2C C7 46 28 ?? ?? ?? ?? 89 5E 34 C7 46 30 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 6C 02 00 00 C6 83 5C 02 00 00 01 C6 83 82 03 00 00 00 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "TTable.Destroy"
		size = 69
		refs = "0003 @BeforeDestruction 0012 TBDEDataSet.Destroy 001d TObject.Free 003e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 8B 86 6C 02 00 00 E8 ?? ?? ?? ?? 8B 86 58 02 00 00 E8 ?? ?? ?? ?? 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "TTable.GetHandle"
		size = 472
		refs = "0032 TTable.GetHandle 004d TBDEDataSet.ForceUpdateCallback 0061 OpenModes 0090 ShareModes 00aa @LStrFromUStr 00b5 @LStrToPChar 00dc TTable.GetTableTypeName 00e4 TTable.NativeTableName 00ec TDBDataSet.GetDBHandle 00f2 DbiOpenTable 010e TDBDataSet.CheckOpen 011d TTable.IsXBaseTable 017d CharToOemA 018f DbiOpenIndex 0194 CheckIndexOpen 01b2 @UStrClr 01c2 @LStrArrayClr 01c8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 D4 FE FF FF 53 56 57 33 DB 89 9D D8 FE FF FF 89 9D D4 FE FF FF 89 9D E0 FE FF FF 89 9D DC FE FF FF 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F4 80 BB 5E 02 00 00 00 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 83 E0 7F 8B 3C 85 ?? ?? ?? ?? 80 BB 5C 02 00 00 00 74 08 66 C7 45 F2 00 00 EB 06 66 C7 45 F2 FF FF 8D 45 F4 50 6A 00 6A 00 6A 02 0F B6 83 5D 02 00 00 8B 04 85 ?? ?? ?? ?? 50 57 0F B7 45 F2 50 8D 85 E0 FE FF FF 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 E0 FE FF FF E8 ?? ?? ?? ?? 50 8D 85 DC FE FF FF 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 DC FE FF FF E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 66 81 FE 0B 2A 75 0A BF 01 00 00 00 E9 73 FF FF FF 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 62 FF FF FF 8B C3 E8 ?? ?? ?? ?? 84 C0 74 79 8B 83 6C 02 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 7C 67 46 C7 45 EC 00 00 00 00 8D 85 E7 FE FF FF 50 8D 8D D4 FE FF FF 8B 55 EC 8B 83 6C 02 00 00 8B 38 FF 57 0C 8B 95 D4 FE FF FF 8D 85 D8 FE FF FF B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 D8 FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8D 85 E7 FE FF FF 50 8B 45 F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 45 EC 4E 75 A1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 D4 FE FF FF E8 ?? ?? ?? ?? 8D 85 D8 FE FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "TTable.CreateHandle"
		size = 362
		refs = "0013 TTable.CreateHandle 002a SNoTableName 002f LoadResString 0039 DatabaseError 006b TTable.GetIndexParams 0078 TTable.GetHandle 00a4 DbiGetLdObj 00b3 TBDEDataSet.SetLocale 00df TTable.IsProductionIndex 00f7 @LStrFromUStr 00ff @LStrToPChar 0122 DbiSwitchToIndex 0127 Check 0141 @LStrArrayClr 0149 @UStrClr 0156 @UStrArrayClr 015c @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 64 02 00 00 00 75 17 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 8B D3 E8 ?? ?? ?? ?? 8B 83 54 02 00 00 C6 40 20 00 8B 83 44 02 00 00 80 78 76 00 74 31 8D 45 FC 50 8D 45 F8 50 0F B6 8B 60 02 00 00 8B 93 68 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 89 45 F4 E9 A7 00 00 00 33 C9 33 D2 8B C3 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 89 83 80 01 00 00 8D 45 F0 50 8B 45 F4 50 E8 ?? ?? ?? ?? 66 85 C0 75 0A 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 50 8D 45 F8 50 0F B6 8B 60 02 00 00 8B 93 68 02 00 00 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 52 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 84 C0 74 44 6A 00 6A 00 8D 45 E8 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 50 8D 45 E4 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? 50 8D 45 F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D6 8B 45 F4 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "TTable.GetLanguageDriverName"
		size = 492
		refs = "0025 TTable.GetLanguageDriverName 0070 TDBDataSet.GetDBSession 0084 TSession.GetAliasDriverName 009a @LStrFromUStr 00a5 @LStrToPChar 00e8 FmtStr 00f5 TDBDataSet.GetDBLocale 0103 AnsiToNative 0116 TTable.NativeTableName 0123 DbiFormFullName 012b TTable.GetTableTypeName 0141 DbiGetLdName 017c @HandleFinally 0191 @UStrFromArray 01a9 @UStrClr 01b4 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 B4 FE FF FF 53 33 C9 89 8D C8 FE FF FF 89 8D C4 FE FF FF 89 4D FC 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 85 EE FE FF FF 00 B1 01 BA 09 00 00 00 8B 45 F8 8B 18 FF 93 D8 02 00 00 88 45 F3 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 98 44 02 00 00 80 7B 76 00 0F 84 9D 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8D 8D C4 FE FF FF 8B 55 F8 8B 92 48 02 00 00 E8 ?? ?? ?? ?? 8B 95 C4 FE FF FF 8D 85 C8 FE FF FF B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 C8 FE FF FF E8 ?? ?? ?? ?? 8B D8 6A 01 8B 45 F8 8B 80 48 02 00 00 89 85 B4 FE FF FF C6 85 B8 FE FF FF 11 8B 45 F8 8B 80 64 02 00 00 89 85 BC FE FF FF C6 85 C0 FE FF FF 11 8D 8D B4 FE FF FF 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 04 01 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8D 8D EE FE FF FF 8B 55 FC E8 ?? ?? ?? ?? EB 28 8D 85 EE FE FF FF 50 6A 00 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 83 80 00 00 00 50 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 8D 85 CE FE FF FF 50 8D 85 EE FE FF FF 50 53 E8 ?? ?? ?? ?? 66 85 C0 74 0F 8D 85 CE FE FF FF 50 6A 00 53 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 4D F3 BA 09 00 00 00 8B 45 F8 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E4 8B 45 F4 8D 95 CE FE FF FF B9 20 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 C4 FE FF FF E8 ?? ?? ?? ?? 8D 85 C8 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 3A 00 25 00 73 00 3A 00 25 00 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "TTable.SetTempLocale"
		size = 214
		refs = "0011 TTable.SetTempLocale 0034 TTable.GetLanguageDriverName 004e @LStrFromUStr 0056 @LStrToPChar 005c OsLdLoadBySymbName 0076 TBDEDataSet.SetLocale 0081 OsLdUnloadObj 0093 DbiGetLdObj 00ba @LStrClr 00c2 @UStrClr 00c8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 84 D2 74 09 83 BB 80 01 00 00 00 75 5F 8B B3 98 01 00 00 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 6B 8D 45 F8 50 8D 45 F4 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 44 8B 45 F8 3B 83 98 01 00 00 74 0C 8B 55 F8 8B C3 E8 ?? ?? ?? ?? EB 2D 8D 45 F8 50 E8 ?? ?? ?? ?? EB 22 8D 45 F8 50 8B 83 80 01 00 00 50 E8 ?? ?? ?? ?? 66 85 C0 75 0A 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 75 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "TTable.RestoreLocale"
		size = 44
		refs = "001c OsLdUnloadObj 0025 TBDEDataSet.SetLocale"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 98 01 00 00 3B F0 74 19 85 C0 74 15 8D 83 98 01 00 00 50 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "TTable.PrepareCursor"
		size = 136
		refs = "000e TTable.PrepareCursor 001b TTable.IsXBaseTable 003b TTable.GetIndexParams 0045 TTable.IsProductionIndex 0056 TBDEDataSet.SwitchToIndex 005d TTable.CheckMasterRange 0077 @UStrArrayClr 007d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 74 37 8D 45 FC 50 8D 45 F8 50 0F B6 8B 60 02 00 00 8B 93 68 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 84 C0 75 0D 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "TTable.DefChanged"
		size = 8
	strings:
		$1 = { C6 80 50 02 00 00 01 C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "TTable.InitFieldDefs"
		size = 907
		refs = "001c TTable.InitFieldDefs 0075 SNoTableName 007a LoadResString 0088 DatabaseError 0092 TTable.SetTempLocale 00b1 TTable.GetTableTypeName 00ba TTable.NativeTableName 00c3 TDBDataSet.GetDBHandle 00c9 DbiOpenFieldList 00d3 TDBDataSet.CheckOpen 00f2 DbiGetRecordCount 00f7 Check 0109 TFieldDescList 010e @DynArraySetLength 013f DbiGetNextRecord 0151 _Dn_TBits 0156 TObject.Create 018d TBits.SetSize 01bf DbiOpenVchkList 021e TBits.SetBit 024d DbiCloseCursor 0253 @HandleFinally 0279 TCollection.Clear 02aa TBDEDataSet.AddFieldDesc 02e7 TObject.Free 0325 TTable.RestoreLocale 036c @UStrClr 037a @DynArrayClear"
	strings:
		$1 = { 55 8B EC 81 C4 14 FB FF FF 53 33 D2 89 95 14 FB FF FF 89 55 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 83 B8 80 01 00 00 00 74 10 8B 45 F8 8B 10 FF 92 38 02 00 00 E9 16 03 00 00 B1 01 BA 04 00 00 00 8B 45 F8 8B 18 FF 93 D8 02 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 83 B8 64 02 00 00 00 75 1E 8D 95 14 FB FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 14 FB FF FF 8B 55 F8 E8 ?? ?? ?? ?? B2 01 8B 45 F8 E8 ?? ?? ?? ?? 89 45 DC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 45 E8 50 6A 00 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 CC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 45 EC 50 8B 45 E8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8D 45 FC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 5D EC 4B 85 DB 7C 31 43 C7 45 F4 00 00 00 00 6A 00 8B 45 F4 8B D0 C1 E0 05 2B C2 8B 55 FC 8D 04 42 50 6A 00 8B 45 E8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 45 F4 4B 75 D7 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 EC 8B D0 C1 E0 05 2B C2 8B 55 FC 0F B7 44 42 C2 0F B7 D0 3B 55 EC 7E 0E 0F B7 D0 42 8B 45 E0 E8 ?? ?? ?? ?? EB 0C 8B 55 EC 42 8B 45 E0 E8 ?? ?? ?? ?? 8D 45 E4 50 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 85 8D 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 46 66 83 BD 1B FB FF FF 00 74 3C 66 83 BD 21 FB FF FF 00 75 32 0F B7 85 19 FB FF FF 8B 55 E0 8B 5A 04 8B D3 4A 3B C2 7E 0D 8B D3 83 C2 64 8B 45 E0 E8 ?? ?? ?? ?? 0F B7 95 19 FB FF FF B1 01 8B 45 E0 E8 ?? ?? ?? ?? 6A 00 8D 85 19 FB FF FF 50 6A 00 8B 45 E4 50 E8 ?? ?? ?? ?? 66 85 C0 74 A1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 8B 45 F8 8B 40 40 8B 10 FF 52 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 40 40 E8 ?? ?? ?? ?? 33 C0 89 45 F4 C7 45 F0 01 00 00 00 8B 45 F4 3B 45 EC 7D 25 8D 45 F0 50 8B 45 E0 50 8B 45 F8 8B 40 40 50 8D 4D F4 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F4 3B 45 EC 7C DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 8B 40 40 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 DC 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 04 00 00 00 8B 45 F8 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 14 FB FF FF E8 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DF 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "TTable.DestroyHandle"
		size = 22
		refs = "0010 TBDEDataSet.DestroyHandle"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 C8 02 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "ConcatField"
		size = 156
		refs = "0015 ConcatField 0029 @UStrAsg 0051 Format 0070 @UStrClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3B 00 75 0B 8B C3 8B D6 E8 ?? ?? ?? ?? EB 30 8D 45 FC 50 8B 03 89 45 EC C6 45 F0 11 89 75 F4 C6 45 F8 11 8D 55 EC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3B 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "TTable.DecodeIndexDesc"
		size = 468
		refs = "0022 TTable.DecodeIndexDesc 003b @UStrClr 0053 NativeToAnsi 0070 ExtractFileName 007a @UStrAsg 013a TFieldDefList.GetFieldDef 0145 @UStrLAsg 0150 ConcatField 0184 @UStrEqual 01b1 @UStrArrayClr 01bf @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D E8 89 5D EC 89 5D FC 8B D9 8B F2 89 45 F8 8B 7D 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BE 07 01 00 00 00 75 0C 89 75 F0 8B C3 E8 ?? ?? ?? ?? EB 16 8B C6 8D 96 07 01 00 00 89 55 F0 8B CB 8B D0 33 C0 E8 ?? ?? ?? ?? 8B CF 8B 45 F8 8B 80 98 01 00 00 8B 55 F0 E8 ?? ?? ?? ?? 8D 55 EC 8B 07 E8 ?? ?? ?? ?? 8B 55 EC 8B C7 E8 ?? ?? ?? ?? 8D 55 E8 8B 03 E8 ?? ?? ?? ?? 8B 55 E8 8B C3 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 88 45 F7 66 83 BE 47 01 00 00 00 74 04 80 4D F7 01 66 83 BE 49 01 00 00 00 74 04 80 4D F7 02 66 83 BE 4B 01 00 00 00 74 04 80 4D F7 04 66 83 BE 37 03 00 00 00 74 04 80 4D F7 08 66 83 BE 4D 01 00 00 00 75 04 80 4D F7 20 66 83 BE 51 01 00 00 00 74 20 8B 4D 10 8D 96 7D 01 00 00 8B 45 F8 8B 80 98 01 00 00 E8 ?? ?? ?? ?? 80 4D F7 10 E9 86 00 00 00 8B 45 10 E8 ?? ?? ?? ?? 8B 45 0C E8 ?? ?? ?? ?? 0F B7 BE 55 01 00 00 4F 85 FF 7C 47 47 8D 9E 5D 01 00 00 0F B7 13 4A 8B 45 F8 8B 40 44 E8 ?? ?? ?? ?? 8B 50 0C 8D 45 FC E8 ?? ?? ?? ?? 8B 45 10 8B 55 FC E8 ?? ?? ?? ?? 66 83 BB E0 01 00 00 00 74 0B 8B 45 0C 8B 55 FC E8 ?? ?? ?? ?? 83 C3 02 4F 75 C0 66 83 BE 4B 01 00 00 00 74 19 8B 45 0C 8B 00 8B 55 10 8B 12 E8 ?? ?? ?? ?? 75 08 8B 45 0C E8 ?? ?? ?? ?? 8B 45 08 0F B6 55 F7 88 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C2 10 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "IndexFieldOfs"
		size = 185
		refs = "0014 IndexFieldOfs 002b TFieldDefs.Find 0030 TFieldDef.GetFieldNo 006f SIndexFieldMissing 0074 LoadResString 008d DatabaseErrorFmt 00a5 @UStrClr 00ab @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 40 40 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 50 F8 0F B7 92 55 01 00 00 4A 85 D2 7C 1C 42 33 DB 8B 45 08 8B 40 F8 05 5D 01 00 00 0F B7 08 3B F1 74 37 43 83 C0 02 4A 75 F2 8B 45 08 8B 40 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 8B 45 FC 89 45 F0 C6 45 F4 11 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 83 CB FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "TTable.EncodeIndexDesc"
		size = 577
		refs = "0027 TTable.EncodeIndexDesc 003c @FillChar 00b2 TTable.IsXBaseTable 00df AnsiToNative 015f ExtractFieldName 016d TFieldDefs.Find 0172 TFieldDef.GetFieldNo 01b7 @UStrLen 01f8 IndexFieldOfs 022c @UStrArrayClr 0232 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D E8 89 5D EC 89 4D F4 89 55 F8 89 45 FC 8B 7D 08 8B 5D 0C 8B 75 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 33 C9 BA 7D 03 00 00 E8 ?? ?? ?? ?? F6 C3 01 0F 95 C0 F6 D8 1B C0 8B 55 F8 66 89 82 47 01 00 00 F6 C3 02 0F 95 C0 F6 D8 1B C0 8B 55 F8 66 89 82 49 01 00 00 F6 C3 04 74 04 85 FF 74 04 33 C0 EB 02 B0 01 F6 D8 1B C0 8B 55 F8 66 89 82 4B 01 00 00 F6 C3 20 0F 95 C0 34 01 F6 D8 1B C0 8B 55 F8 66 89 82 4D 01 00 00 F6 C3 08 0F 95 C0 83 E0 7F 8B 55 F8 66 89 82 37 03 00 00 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 46 8B 45 F8 66 83 B8 4D 01 00 00 00 74 1E 6A 1F 8B 4D F8 81 C1 07 01 00 00 8B 45 FC 8B 80 98 01 00 00 8B 55 F4 E8 ?? ?? ?? ?? EB 34 68 04 01 00 00 8B 4D F8 8B 45 FC 8B 80 98 01 00 00 8B 55 F4 E8 ?? ?? ?? ?? EB 19 68 04 01 00 00 8B 4D F8 8B 45 FC 8B 80 98 01 00 00 8B 55 F4 E8 ?? ?? ?? ?? F6 C3 10 74 2F 8B 45 F8 66 C7 80 51 01 00 00 FF FF 68 DC 00 00 00 8B 4D F8 81 C1 7D 01 00 00 8B 45 FC 8B 80 98 01 00 00 8B D6 E8 ?? ?? ?? ?? E9 C9 00 00 00 C7 45 F0 01 00 00 00 EB 5E 8D 4D EC 8D 55 F0 8B C6 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 FC 8B 40 40 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 0F B7 92 55 01 00 00 8B 4D F8 66 89 84 51 5D 01 00 00 8B 45 F8 0F B7 80 55 01 00 00 8B 55 F8 8B 4D F8 0F B7 89 4B 01 00 00 66 89 8C 42 3D 03 00 00 8B 45 F8 66 FF 80 55 01 00 00 8B C6 E8 ?? ?? ?? ?? 3B 45 F0 7C 0D 8B 45 F8 66 83 B8 55 01 00 00 10 72 89 85 FF 74 45 8B 45 F8 66 C7 80 4B 01 00 00 FF FF C7 45 F0 01 00 00 00 EB 24 55 8D 4D E8 8D 55 F0 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 59 8B 55 F8 66 C7 84 42 3D 03 00 00 FF FF 8B C7 E8 ?? ?? ?? ?? 3B 45 F0 7D D0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TTable.AddIndex"
		size = 353
		refs = "001d TFieldDefs.Update 0025 TDataSet.GetActive 003f TTable.EncodeIndexDesc 0047 TDataSet.CheckBrowseMode 0066 TBDEDataSet.GetHandle 006f TDBDataSet.GetDBHandle 0075 DbiAddIndex 007a Check 0089 TTable.SetTempLocale 0094 TTable.AddIndex 00c8 TTable.RestoreLocale 00ce @HandleFinally 0101 TTable.GetTableTypeName 010a TTable.NativeTableName"
	strings:
		$1 = { 55 8B EC 81 C4 78 FC FF FF 53 56 57 8B F1 8B FA 89 45 FC 8B 5D 0C 8B 45 FC 8B 40 40 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 56 56 53 8B 45 08 50 8D 95 7B FC FF FF 8B CF 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 60 FF FF FF FF 6A 00 8D 85 7B FC FF FF 50 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 C8 00 00 00 33 D2 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 53 8B 45 08 50 8D 95 7B FC FF FF 8B CF 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED B1 01 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8D 85 7B FC FF FF 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 8B 45 FC 8B 80 54 02 00 00 C6 40 20 00 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "TTable.DeleteIndex"
		size = 408
		refs = "0016 TTable.DeleteIndex 0024 TDataSet.GetActive 003c TTable.GetIndexParams 0044 TDataSet.CheckBrowseMode 0056 @LStrFromUStr 005e @LStrToPChar 0084 TBDEDataSet.GetHandle 008d TDBDataSet.GetDBHandle 0093 DbiDeleteIndex 0098 Check 010d TTable.GetTableTypeName 0116 TTable.NativeTableName 0151 @HandleFinally 017a @LStrArrayClr 0187 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 8B DA 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 84 C0 74 75 8D 45 FC 50 8D 45 F8 50 33 C9 8B D3 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 6A 00 8D 45 F0 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 50 8D 45 EC 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 45 F4 E8 ?? ?? ?? ?? 50 8B 45 F4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 B6 00 00 00 8D 45 FC 50 8D 45 F8 50 33 C9 8B D3 8B 45 F4 E8 ?? ?? ?? ?? B1 01 BA 03 00 00 00 8B 45 F4 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8D 45 E8 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 50 8D 45 E4 8B 55 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? 50 8B 45 F4 E8 ?? ?? ?? ?? 50 8B 45 F4 E8 ?? ?? ?? ?? 50 6A 00 8B 45 F4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 F4 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 8B 45 F4 8B 80 54 02 00 00 C6 40 20 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "TTable.GetIndexFieldNames"
		size = 41
		refs = "0018 @UStrAsg 0022 @UStrClr"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 60 02 00 00 00 74 10 8B C6 8B 93 68 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "TTable.GetIndexName"
		size = 41
		refs = "0012 @UStrClr 0022 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 60 02 00 00 00 74 0A 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 8B 93 68 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "TTable.GetIndexNames"
		size = 33
		refs = "000d TIndexDefs.Update 001a TDefCollection.GetItemNames"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B D6 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "TTable.GetIndexParams"
		size = 652
		refs = "002e TTable.GetIndexParams 0058 TIndexDefs.Update 0062 @UStrLAsg 006c TTable.SetTempLocale 00ba @UniqueStringU 00d5 @UStrCat3 00e7 TIndexDefs.FindIndexForFields 00fa TTable.IsXBaseTable 0110 ExtractFileExt 0121 UpperCase 0131 @UStrEqual 0150 AnsiToNative 0163 TDefCollection.IndexOf 0173 TIndexDefs.GetIndexDef 018f SIndexDoesNotExist 0194 LoadResString 01b6 DatabaseErrorFmt 01fb TTable.RestoreLocale 0201 @HandleFinally 0216 @UStrFromArray 0246 @UStrArrayClr 024e @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 40 FF FF FF 53 56 57 33 DB 89 9D 48 FF FF FF 89 9D 50 FF FF FF 89 9D 4C FF FF FF 89 5D FC 8B D9 8B F2 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 85 74 FF FF FF 00 C6 85 54 FF FF FF 00 85 F6 0F 84 B9 01 00 00 8B 45 F8 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 E8 ?? ?? ?? ?? B2 01 8B 45 F8 E8 ?? ?? ?? ?? 89 45 F4 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 84 DB 74 71 8B 45 F8 8B 80 44 02 00 00 80 78 78 00 74 47 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 8B F8 85 FF 7E 23 BB 01 00 00 00 8B 45 FC 66 83 7C 58 FE 3B 75 0F 8D 45 FC E8 ?? ?? ?? ?? 66 C7 44 58 FE 40 00 43 4F 75 E2 8D 45 FC 8B 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 8B 45 F8 8B 80 54 02 00 00 8B D6 E8 ?? ?? ?? ?? 8B 50 0C 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 0F 84 C8 00 00 00 8D 95 4C FF FF FF 8B 45 FC E8 ?? ?? ?? ?? 8B 85 4C FF FF FF 8D 95 50 FF FF FF E8 ?? ?? ?? ?? 8B 85 50 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 93 00 00 00 6A 1F 8D 8D 54 FF FF FF 8B 45 F8 8B 80 98 01 00 00 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F8 8B B8 54 02 00 00 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 16 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 50 14 8D 45 FC E8 ?? ?? ?? ?? EB 36 8B 45 F8 50 8D 95 48 FF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 48 FF FF FF 50 89 B5 40 FF FF FF C6 85 44 FF FF FF 11 8D 95 40 FF FF FF 33 C9 58 E8 ?? ?? ?? ?? 6A 7F 8D 8D 74 FF FF FF 8B 55 FC 33 C0 E8 ?? ?? ?? ?? EB 19 6A 7F 8D 8D 74 FF FF FF 8B 45 F8 8B 80 98 01 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 0C 8D 95 74 FF FF FF B9 80 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 8D 95 54 FF FF FF B9 20 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 48 FF FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C2 08 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 40 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 4E 00 44 00 58 00 00 00 00 00 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "TTable.SetIndexDefs"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 54 02 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "TTable.SetIndex"
		size = 216
		refs = "0014 TTable.SetIndex 0021 TDataSet.GetActive 002c TDataSet.CheckBrowseMode 0039 @UStrEqual 0061 TTable.GetIndexParams 006e TBDEDataSet.SwitchToIndex 0075 TTable.CheckMasterRange 0082 @UStrAsg 00be @UStrArrayClr 00c4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 84 C0 74 07 8B C6 E8 ?? ?? ?? ?? 8B 86 68 02 00 00 8B D7 E8 ?? ?? ?? ?? 75 08 3A 9E 60 02 00 00 74 61 8B C6 E8 ?? ?? ?? ?? 84 C0 74 27 8D 45 FC 50 8D 45 F8 50 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 4D F8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8D 86 68 02 00 00 8B D7 E8 ?? ?? ?? ?? 88 9E 60 02 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 74 11 0F B6 15 ?? ?? ?? ?? 8B C6 8B 08 FF 91 B4 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 59 59 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TTable.SetIndexFieldNames"
		size = 23
		refs = "0010 TTable.SetIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 0F 95 C1 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_32002_0 {
	meta:
		name = "TIBTable.SetIndexFieldNames"
		size = 23
		refs = "0010 TIBTable.SetIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 0F 95 C1 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TTable.SetIndexFiles"
		size = 22
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 86 6C 02 00 00 8B 08 FF 51 08 5F 5E C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TTable.OpenIndexFile"
		size = 55
		refs = "001a AnsiToNative 0022 TBDEDataSet.GetHandle 0028 DbiOpenIndex 002d CheckIndexOpen"
	strings:
		$1 = { 53 56 83 C4 E0 8B F2 8B D8 6A 00 6A 1F 8D 4C 24 08 8B D6 8B 83 98 01 00 00 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 5E 5B C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TTable.CloseIndexFile"
		size = 205
		refs = "001e TTable.CloseIndexFile 0040 TTable.GetIndexParams 004b AnsiUpperCaseFileName 0062 @UStrEqual 006d TTable.SetIndexName 0081 AnsiToNative 0089 TBDEDataSet.GetHandle 008f DbiCloseIndex 0094 Check 00ae @UStrArrayClr 00c1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 33 C9 89 4D D4 89 4D D0 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 45 F8 50 0F B6 8B 60 02 00 00 8B 93 68 02 00 00 8B C3 E8 ?? ?? ?? ?? 8D 55 D4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D4 50 8D 55 D0 8B C6 E8 ?? ?? ?? ?? 8B 55 D0 58 E8 ?? ?? ?? ?? 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 6A 1F 8D 4D D8 8B D6 8B 83 98 01 00 00 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "UpdateFromCursor"
		size = 514
		refs = "0015 UpdateFromCursor 0035 TBDEDataSet.GetHandle 0048 TTable.GetHandle 0058 DbiGetLdObj 006b TBDEDataSet.SetLocale 0099 DbiGetCursorProps 00bb TIndexDescList 00c0 @DynArraySetLength 00d0 DbiGetIndexDescs 011b TTable.DecodeIndexDesc 012c TIndexDefs.AddIndexDef 013b TNamedItem.SetDisplayName 0148 TIndexDef.SetFields 0155 TIndexDef.SetDescFields 0163 TIndexDef.SetOptions 0179 TIndexDef.SetSource 01ad DbiCloseCursor 01d2 @HandleFinally 01ef @DynArrayClear"
	strings:
		$1 = { 55 8B EC 81 C4 44 FE FF FF 53 56 57 33 C0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 E8 8B 80 98 01 00 00 89 45 F4 8B 45 08 8B 40 E8 E8 ?? ?? ?? ?? 85 C0 75 34 8B 45 08 8B 40 E8 33 C9 33 D2 E8 ?? ?? ?? ?? 89 45 F8 8D 45 F0 50 8B 45 F8 50 E8 ?? ?? ?? ?? 66 85 C0 75 1E 8B 45 08 8B 40 E8 8B 55 F0 E8 ?? ?? ?? ?? EB 0E 8B 45 08 8B 40 E8 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 45 FE FF FF 50 8B 45 F8 50 E8 ?? ?? ?? ?? 0F B7 9D 74 FF FF FF 66 85 DB 0F 86 D8 00 00 00 0F B7 C3 50 8D 45 FC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 8B 45 F8 50 E8 ?? ?? ?? ?? 0F B7 B5 74 FF FF FF 4E 85 F6 0F 8C A1 00 00 00 46 33 FF 8B 45 08 83 C0 F8 50 8B 45 08 83 C0 F4 50 8B 45 08 83 C0 F0 50 8B 45 08 83 C0 EF 50 69 C7 7D 03 00 00 8B 55 FC 03 D0 8B 45 08 8D 48 FC 8B 45 08 8B 40 E8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 E8 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 50 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 50 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 50 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 0F B6 50 EF 8B C3 E8 ?? ?? ?? ?? 8B 45 08 83 78 FC 00 74 0D 8B 45 08 8B 50 FC 8B C3 E8 ?? ?? ?? ?? 47 4E 0F 85 62 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 19 8B 45 08 8B 40 E8 E8 ?? ?? ?? ?? 3B 45 F8 74 09 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 8B 40 E8 8B 80 98 01 00 00 3B 45 F4 74 0E 8B 45 08 8B 40 E8 8B 55 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB BA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "UpdateFromIndexList"
		size = 269
		refs = "0018 TTable.GetTableTypeName 0020 TTable.NativeTableName 0028 TDBDataSet.GetDBHandle 002e DbiOpenIndexList 0037 TDBDataSet.CheckOpen 0043 UpdateFromIndexList 0084 TTable.DecodeIndexDesc 0091 TIndexDefs.AddIndexDef 00a0 TNamedItem.SetDisplayName 00ad TIndexDef.SetFields 00ba TIndexDef.SetDescFields 00c8 TIndexDef.SetOptions 00dc DbiGetNextRecord 00fb DbiCloseCursor 0101 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 7C FC FF FF 53 56 8B 75 08 83 C6 E8 8D 45 FC 50 8B 06 E8 ?? ?? ?? ?? 50 8B 06 E8 ?? ?? ?? ?? 50 8B 06 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 84 C0 74 D2 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 7D 66 83 BD CC FD FF FF 00 74 73 8B 45 08 83 C0 F8 50 8B 45 08 83 C0 F4 50 8B 45 08 83 C0 F0 50 8B 45 08 83 C0 EF 50 8B 45 08 8D 48 FC 8D 95 7F FC FF FF 8B 06 E8 ?? ?? ?? ?? 8B 06 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 50 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 50 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 50 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 0F B6 50 EF 8B C3 E8 ?? ?? ?? ?? 6A 00 8D 85 7F FC FF FF 50 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 66 85 C0 0F 84 66 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TTable.UpdateIndexDefs"
		size = 210
		refs = "0013 TTable.UpdateIndexDefs 0044 TFieldDefs.Update 0052 TCollection.Clear 0076 UpdateFromCursor 007f UpdateFromIndexList 00a5 @HandleFinally 00c1 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B1 01 BA 05 00 00 00 8B 45 E8 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 E8 8B 40 40 E8 ?? ?? ?? ?? 8B 45 E8 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B 45 E8 8B 10 FF 92 40 02 00 00 84 C0 75 0F 8B 45 E8 8B 80 44 02 00 00 80 78 76 00 75 09 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 05 00 00 00 8B 45 E8 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 04 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TTable.IsProductionIndex"
		size = 240
		refs = "0017 TTable.IsProductionIndex 0026 TTable.IsXBaseTable 0038 ExtractFileExt 0043 AnsiUpperCase 0050 @UStrEqual 005d TTable.NativeTableName 0067 @UStrFromPChar 0074 ChangeFileExt 007f AnsiUpperCaseFileName 00c0 @UStrArrayClr 00c6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B3 01 8B C7 E8 ?? ?? ?? ?? 84 C0 74 7C 85 F6 74 78 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 45 F8 8D 55 FC E8 ?? ?? ?? ?? 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 04 33 DB EB 50 8B C7 E8 ?? ?? ?? ?? 8B D0 8D 45 EC E8 ?? ?? ?? ?? 8B 45 EC 8D 4D F0 33 D2 E8 ?? ?? ?? ?? 8B 45 F0 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8D 4D E4 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 58 E8 ?? ?? ?? ?? 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 07 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 4E 00 44 00 58 00 00 00 00 00 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TTable.GetExists"
		size = 288
		refs = "0013 TTable.GetExists 0021 TDataSet.GetActive 007d TTable.NativeTableName 0086 TDBDataSet.GetDBHandle 008c DbiOpenFieldList 00a2 DbiCloseCursor 00b5 DbiError 00c2 TTable.GetFileName 00cc FileExists 00f4 @HandleFinally 010b @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 80 7D FB 00 0F 85 C8 00 00 00 8B 45 FC 83 B8 64 02 00 00 00 0F 84 B8 00 00 00 B1 01 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 44 02 00 00 80 78 76 00 74 4A 8D 45 F4 50 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 45 FB 80 7D FB 00 74 0B 8D 45 F4 50 E8 ?? ?? ?? ?? EB 2B 66 3D 28 27 74 25 66 3D 08 22 74 1F E8 ?? ?? ?? ?? EB 18 8D 55 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F0 B2 01 E8 ?? ?? ?? ?? 88 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 0F B6 45 FB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TTable.FindKey"
		size = 39
		refs = "000c TDataSet.CheckBrowseMode 0018 TBDEDataSet.SetKeyFields 001f TTable.GotoKey"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15427_0 {
	meta:
		name = "TCustomClientDataSet.FindKey"
		size = 39
		refs = "000c TDataSet.CheckBrowseMode 0018 TCustomClientDataSet.SetKeyFields 001f TCustomClientDataSet.GotoKey"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15428_0 {
	meta:
		name = "TCustomClientDataSet.FindNearest"
		size = 39
		refs = "000c TDataSet.CheckBrowseMode 0018 TCustomClientDataSet.SetKeyFields 001f TCustomClientDataSet.GotoNearest"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TTable.FindNearest"
		size = 39
		refs = "000c TDataSet.CheckBrowseMode 0018 TBDEDataSet.SetKeyFields 001f TTable.GotoNearest"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "TTable.GotoKey"
		size = 256
		refs = "0010 TDataSet.CheckBrowseMode 002f TBDEDataSet.GetKeyBuffer 0040 AllocMem 004b TTable.GotoKey 0063 TBDEDataSet.GetHandle 0069 DbiExtractKey 0095 DbiGetRecordForKey 00e4 @FreeMem 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 34 01 00 00 8B 45 FC C7 40 60 FF FF FF FF 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B 45 FC 0F B7 80 CE 01 00 00 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B FE 83 C7 06 8B 45 F4 50 57 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 C3 84 DB 74 03 8B 7D F4 6A 00 57 6A 00 0F B7 46 02 50 80 FB 01 F5 1B C0 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 45 FB 80 7D FB 00 74 12 0F B6 15 ?? ?? ?? ?? 8B 45 FC 8B 08 FF 91 B4 02 00 00 80 7D FB 00 74 0B 8B 45 FC 8B 10 FF 92 10 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 0F B7 90 CE 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 0F B6 45 FB 5F 5E 5B 8B E5 5D C3 00 03 00 00 00 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "TTable.GotoNearest"
		size = 240
		refs = "0010 TDataSet.CheckBrowseMode 0024 TBDEDataSet.GetKeyBuffer 004b AllocMem 0056 TTable.GotoNearest 006e TBDEDataSet.GetHandle 0074 DbiExtractKey 00a2 DbiSetToKey 00a7 Check 00d8 @FreeMem 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 60 FF FF FF FF 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B F8 80 7F 01 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 02 00 00 00 8B 45 FC 0F B7 80 CE 01 00 00 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B F7 83 C6 06 8B 45 F4 50 56 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 C3 84 DB 74 03 8B 75 F4 56 6A 00 0F B7 47 02 50 80 FB 01 F5 1B C0 50 8B 45 F8 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B 45 FC 8B 08 FF 91 B4 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 0F B7 90 CE 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5F 5E 5B 8B E5 5D C3 00 02 00 00 00 }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "TTable.SetKey"
		size = 10
		refs = "0005 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15431_0 {
	meta:
		name = "TCustomClientDataSet.SetKey"
		size = 10
		refs = "0005 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24364_0 {
	meta:
		name = "TDSSessionManager.TerminateAllSessions"
		size = 10
		refs = "0005 TDSSessionManager.TerminateAllSessions"
	strings:
		$1 = { B1 01 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TTable.EditKey"
		size = 10
		refs = "0005 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15432_0 {
	meta:
		name = "TCustomClientDataSet.EditKey"
		size = 10
		refs = "0005 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11485_0 {
	meta:
		name = "TDBXDatabaseConnectionHandler.DbxDisconnect"
		size = 10
		refs = "0005 TDBXDatabaseConnectionHandler.EndTransaction"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30494_0 {
	meta:
		name = "TIBTransaction.Rollback"
		size = 10
		refs = "0005 TIBTransaction.EndTransaction"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "TTable.ApplyRange"
		size = 37
		refs = "0006 TDataSet.CheckBrowseMode 000d TBDEDataSet.SetCursorRange 0018 TDataSet.First"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 07 8B C3 E8 ?? ?? ?? ?? C6 83 82 03 00 00 01 5B C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TTable.CancelRange"
		size = 60
		refs = "0006 TDataSet.CheckBrowseMode 000d TDataSet.UpdateCursorPos 0014 TBDEDataSet.ResetCursorRange 001f TTable.CancelRange"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 0F B6 15 ?? ?? ?? ?? 8B C3 8B 08 FF 91 B4 02 00 00 C6 83 82 03 00 00 00 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "TTable.SetRange"
		size = 67
		refs = "000f TDataSet.CheckBrowseMode 001e TBDEDataSet.SetKeyFields 0038 TTable.ApplyRange"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D 0C BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_15435_0 {
	meta:
		name = "TCustomClientDataSet.SetRange"
		size = 67
		refs = "000f TDataSet.CheckBrowseMode 001e TCustomClientDataSet.SetKeyFields 0038 TCustomClientDataSet.ApplyRange"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 57 8B CE BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D 0C BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_761_0 {
	meta:
		name = "TTable.SetRangeEnd"
		size = 13
		refs = "0008 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15436_0 {
	meta:
		name = "TCustomClientDataSet.SetRangeEnd"
		size = 13
		refs = "0008 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "TTable.SetRangeStart"
		size = 13
		refs = "0008 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15437_0 {
	meta:
		name = "TCustomClientDataSet.SetRangeStart"
		size = 13
		refs = "0008 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { B1 01 BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "TTable.EditRangeEnd"
		size = 13
		refs = "0008 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15438_0 {
	meta:
		name = "TCustomClientDataSet.EditRangeEnd"
		size = 13
		refs = "0008 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "TTable.EditRangeStart"
		size = 13
		refs = "0008 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15439_0 {
	meta:
		name = "TCustomClientDataSet.EditRangeStart"
		size = 13
		refs = "0008 TCustomClientDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "TTable.UpdateRange"
		size = 15
		refs = "000a TBDEDataSet.SetLinkRanges"
	strings:
		$1 = { 8B 90 58 02 00 00 8B 52 24 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_766_0 {
	meta:
		name = "TTable.GetLookupCursor"
		size = 440
		refs = "001e TTable.GetLookupCursor 0031 @UStrEqual 0089 @UStrLAsg 00a2 TIndexDefs.GetIndexForFields 00fb TBDEDataSet.GetHandle 0101 DbiCloneCursor 0106 Check 011c TTable.GetIndexParams 0130 @LStrFromUStr 0138 @LStrToPChar 015e DbiSwitchToIndex 0170 @UStrAsg 0196 @LStrArrayClr 01a3 @UStrArrayClr 01a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 96 74 02 00 00 E8 ?? ?? ?? ?? 75 0C 3A 9E 7C 02 00 00 0F 84 37 01 00 00 8B C6 8B 10 FF 92 C8 02 00 00 C6 45 F3 00 C6 45 F2 00 8B 86 E4 01 00 00 80 38 00 0F 85 16 01 00 00 8B 86 E8 01 00 00 80 38 00 0F 85 07 01 00 00 8B 86 44 02 00 00 80 78 78 00 74 18 84 DB 75 50 8D 45 FC 8B D7 E8 ?? ?? ?? ?? C6 45 F2 01 C6 45 F3 01 EB 3C 8B CB 8B D7 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 24 8B 45 EC F6 40 24 08 0F 95 C0 3A D8 75 16 8D 45 FC 8B 55 EC 8B 52 0C E8 ?? ?? ?? ?? C6 45 F2 00 C6 45 F3 01 80 7D F3 00 0F 84 8A 00 00 00 8B C7 85 C0 74 05 83 E8 04 8B 00 83 F8 7F 7D 7A 8D 86 70 02 00 00 50 6A 00 6A FF 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 F4 50 0F B6 4D F2 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 6A 00 6A 00 8D 45 E8 8B 55 F4 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 50 8D 45 E4 8B 55 F8 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? 50 8D 86 70 02 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 86 74 02 00 00 8B D7 E8 ?? ?? ?? ?? 88 9E 7C 02 00 00 8B 9E 70 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_767_0 {
	meta:
		name = "TTable.DestroyLookupCursor"
		size = 45
		refs = "0014 DbiCloseCursor 0027 @UStrClr"
	strings:
		$1 = { 53 8B D8 83 BB 70 02 00 00 00 74 1F 8D 83 70 02 00 00 50 E8 ?? ?? ?? ?? 33 C0 89 83 70 02 00 00 8D 83 74 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "TTable.GotoCurrent"
		size = 212
		refs = "000f TTable.GotoCurrent 001c TDataSet.CheckBrowseMode 0034 AnsiCompareText 0055 STableMismatch 005a LoadResString 0064 DatabaseError 006b TDataSet.UpdateCursorPos 0072 TBDEDataSet.GetHandle 0080 DbiSetToCursor 0085 Check 00bf @UStrClr 00c5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 96 48 02 00 00 8B 83 48 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 15 8B 96 64 02 00 00 8B 83 64 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 34 01 00 00 0F B6 15 ?? ?? ?? ?? 8B C3 8B 08 FF 91 B4 02 00 00 8B C3 8B 10 FF 92 10 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 03 00 00 00 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "TTable.GetDetailLinkFields"
		size = 386
		refs = "0021 TTable.GetDetailLinkFields 0066 TTable.GetMasterFields 0095 TDataSet.GetFieldList 00a9 TTable.GetIndexName 00c7 TIndexDefs.Find 00d5 TTable.GetIndexFieldNames 00f5 TIndexDefs.GetIndexForFields 011d TIndexDefs.GetIndexDef 0148 TIndexDef.GetFields 016f @UStrArrayClr 0175 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 89 4D FC 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 10 FF 52 08 8B 45 FC 8B 10 FF 52 08 8B C3 8B 10 FF 92 60 01 00 00 85 C0 0F 84 0D 01 00 00 8B C3 8B 10 FF 92 60 01 00 00 83 78 38 00 0F 84 F9 00 00 00 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 83 7D F4 00 0F 84 E5 00 00 00 33 F6 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 50 8B C3 8B 10 FF 92 60 01 00 00 8B 40 38 8B D7 59 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 E4 01 00 00 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 83 7D EC 00 74 1C 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 55 E8 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B F0 EB 6F 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 83 7D E4 00 74 1E 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 8B 55 E0 33 C9 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B F0 EB 41 8B 83 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 7C 30 40 89 45 F8 33 FF 8B D7 8B 83 54 02 00 00 E8 ?? ?? ?? ?? F6 40 24 01 74 11 8B D7 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B F0 EB 06 47 FF 4D F8 75 D6 85 F6 74 17 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 8B 4D DC 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 07 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "TTable.CheckMasterRange"
		size = 43
		refs = "001e TBDEDataSet.SetLinkRanges 0025 TBDEDataSet.SetCursorRange"
	strings:
		$1 = { 53 8B D8 8B 83 58 02 00 00 80 78 15 00 74 1A 8B 50 24 83 7A 08 00 7E 11 8B 50 24 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "TTable.MasterChanged"
		size = 26
		refs = "0006 TDataSet.CheckBrowseMode 000d TTable.UpdateRange 0014 TTable.ApplyRange"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83037_0 {
	meta:
		name = "TCustomOutline.CMFontChanged"
		size = 26
		refs = "0006 TCustomGrid.CMFontChanged 000d TCustomOutline.SetRowHeight 0014 TCustomOutline.SetHorzScrollBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79391_0 {
	meta:
		name = "TDriveComboBox.CMFontChanged"
		size = 26
		refs = "0006 TWinControl.CMFontChanged 000d TDriveComboBox.ResetItemHeight 0014 TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_81347_0 {
	meta:
		name = "TGIFFrame.Dormant"
		size = 26
		refs = "0006 TGIFFrame.FreeBitmap 000d TGIFFrame.FreeMask 0014 TGIFFrame.FreePalette"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_29610_0 {
	meta:
		name = "TGraphView.Paint"
		size = 26
		refs = "0006 TCustomControl.Paint 000d TGraphView.PaintNodes 0014 TGraphView.PaintEdges"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_32019_0 {
	meta:
		name = "TIBTable.MasterChanged"
		size = 26
		refs = "0006 TDataSet.CheckBrowseMode 000d TIBTable.SetParams 0014 TIBCustomDataSet.ReQuery"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "TTable.GetDataSource"
		size = 10
	strings:
		$1 = { 8B 80 58 02 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "TTable.SetDataSource"
		size = 108
		refs = "000f TTable.SetDataSource 001e TDataSet.IsLinkedTo 002a SCircularDataLink 002f LoadResString 0039 DatabaseError 0046 TDataLink.SetDataSource 005b @UStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B D3 E8 ?? ?? ?? ?? 8B D6 8B 83 58 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "TTable.GetMasterFields"
		size = 25
		refs = "0012 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 93 58 02 00 00 8B 52 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "TTable.SetMasterFields"
		size = 12
		refs = "0007 TMasterDataLink.SetFieldNames"
	strings:
		$1 = { 8B 80 58 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_880_0 {
	meta:
		name = "TQuery.ParamByName"
		size = 12
		refs = "0007 TParams.ParamByName"
	strings:
		$1 = { 8B 80 58 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_868_0 {
	meta:
		name = "TQuery.SetParamsList"
		size = 12
		refs = "0007 TParams.AssignValues"
	strings:
		$1 = { 8B 80 58 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "TTable.DoOnNewRecord"
		size = 82
		refs = "0034 TList.Get 003f TBDEDataSet.SetIndexField 004a TDataSet.DoOnNewRecord"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 58 02 00 00 80 78 15 00 74 36 8B 50 24 83 7A 08 00 7E 2D 8B 40 24 8B 78 08 4F 85 FF 7C 22 47 33 F6 8B 83 58 02 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 8B C8 8B D6 8B C3 E8 ?? ?? ?? ?? 46 4F 75 E1 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "TTable.BatchMove"
		size = 124
		refs = "0014 _DV_TBatchMove 0019 TBatchMove.Create 0024 TTable.BatchMove 003a TBatchMove.SetSource 0048 TBatchMove.Execute 0066 TObject.Free 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B D9 8B F2 8B F8 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 89 78 38 8B D6 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 88 58 40 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 40 48 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "InitTableSettings"
		size = 340
		refs = "000c InitTableSettings 0026 @FillChar 0057 AnsiToNative 0065 TTable.GetTableTypeName 0078 StrCopy 00a2 IntToStr 00b2 @LStrFromUStr 00ba @LStrToPChar 00f6 @PCharLen 0130 @UStrClr 0138 @LStrClr 013e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 05 56 FD FF FF 33 C9 BA AA 02 00 00 E8 ?? ?? ?? ?? 68 04 01 00 00 8B 45 08 8D 88 56 FD FF FF 8B 45 08 8B 80 A8 FC FF FF 8B 90 64 02 00 00 8B 45 08 8B 80 A8 FC FF FF 8B 80 98 01 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 80 A8 FC FF FF E8 ?? ?? ?? ?? 85 C0 74 0F 8B 55 08 81 C2 5B FE FF FF 92 E8 ?? ?? ?? ?? 8B 45 08 8B 80 A8 FC FF FF 8B 98 78 02 00 00 85 DB 0F 8E 8C 00 00 00 8B 45 08 66 C7 40 F6 01 00 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 8D 45 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 08 05 36 FD FF FF E8 ?? ?? ?? ?? 8B 45 08 05 36 FD FF FF 8B 55 08 89 42 FC BA ?? ?? ?? ?? 8B 45 08 05 FA FC FF FF E8 ?? ?? ?? ?? 8B 45 08 05 36 FD FF FF E8 ?? ?? ?? ?? 40 8B 55 08 66 89 82 24 FD FF FF 8B 45 08 66 C7 80 22 FD FF FF 00 00 8B 45 08 05 F8 FC FF FF 8B 55 08 89 42 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 00 00 00 4C 45 56 45 4C 00 00 00 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "InitFieldDescriptors"
		size = 445
		refs = "000c InitFieldDescriptors 0020 TDataSet.InitFieldDefsFromFields 004d TFieldDescList 0052 @DynArraySetLength 0084 TFieldDefs.GetFieldDef 0092 TFieldDef.GetSize 00b5 TTable.EncodeFieldDesc 0131 TDBDataSet.GetDBHandle 0137 DbiGetLdNameFromDb 0177 TTable.GetDriverTypeName 018b DbiTranslateRecordStructure 0190 Check 01ab @DynArrayClear 01b1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 80 A8 FC FF FF E8 ?? ?? ?? ?? 8B 45 08 8B 80 A8 FC FF FF 8B 40 40 8B 40 08 8B 40 08 8B D8 8B 45 08 66 89 58 C4 0F B7 C3 50 8D 45 FC B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 80 A8 FC FF FF 8B 40 40 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 58 47 33 F6 8B 45 08 8B 80 A8 FC FF FF 8B 40 40 8B D6 E8 ?? ?? ?? ?? 8B D8 0F B6 43 25 50 8B C3 E8 ?? ?? ?? ?? 50 8B 43 18 50 8B C6 C1 E0 05 2B C6 8B 55 FC 8D 14 42 8B 45 08 8B 80 A8 FC FF FF 8B 4B 0C E8 ?? ?? ?? ?? F6 43 26 04 74 07 8B 45 08 66 FF 40 E2 46 4F 75 AB 8B 45 08 0F B7 40 C4 50 8B 45 08 05 F4 FC FF FF B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 80 F4 FC FF FF 8B 55 08 89 42 CA 8B 45 08 33 D2 89 90 A4 FC FF FF 8B 45 08 8B 80 A8 FC FF FF 8B 80 44 02 00 00 80 78 76 00 74 35 8B 45 08 05 D4 FC FF FF 50 6A 00 8B 45 08 8B 80 A8 FC FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 11 8B 45 08 05 D4 FC FF FF 8B 55 08 89 82 A4 FC FF FF 6A 00 8B 45 08 8B 40 CA 50 8B 45 08 8B 80 A4 FC FF FF 50 8B 45 08 8D 90 B4 FC FF FF 8B 45 08 8B 80 A8 FC FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 45 08 0F B7 40 C4 50 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "InitIndexDescriptors"
		size = 191
		refs = "0036 TIndexDescList 003b @DynArraySetLength 0082 TIndexDefs.GetIndexDef 00b3 TTable.EncodeIndexDesc"
	strings:
		$1 = { 55 8B EC 53 56 8B 45 08 8B 80 A8 FC FF FF 8B 80 54 02 00 00 8B 40 08 8B 40 08 8B D8 8B 45 08 66 89 58 CE 0F B7 C3 50 8B 45 08 05 B0 FC FF FF B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 80 B0 FC FF FF 8B 55 08 89 42 D4 8B 45 08 8B 80 A8 FC FF FF 8B 80 54 02 00 00 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 4E 46 33 DB 8B 45 08 8B 80 A8 FC FF FF 8B 80 54 02 00 00 8B D3 E8 ?? ?? ?? ?? 8B 50 18 52 0F B6 50 24 52 8B 50 1C 52 69 D3 7D 03 00 00 8B 4D 08 8B 89 B0 FC FF FF 8D 14 11 8B 4D 08 8B 89 A8 FC FF FF 8B 40 0C 91 E8 ?? ?? ?? ?? 43 4E 75 B5 5E 5B 5D C3 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "InitValChecks"
		size = 176
		refs = "0029 TValCheckList 002e @DynArraySetLength 0062 TFieldDefs.GetFieldDef"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 0F B7 58 E2 66 85 DB 0F 86 95 00 00 00 0F B7 C3 50 8B 45 08 05 AC FC FF FF B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 FF 8B 45 08 8B 80 A8 FC FF FF 8B 40 40 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 4C 46 33 DB 8B 45 08 8B 80 A8 FC FF FF 8B 40 40 8B D3 E8 ?? ?? ?? ?? F6 40 26 04 0F 95 C0 84 C0 74 27 69 C7 C3 04 00 00 8B 55 08 8B 92 AC FC FF FF 8B CB 41 66 89 0C 02 8B 55 08 8B 92 AC FC FF FF 66 C7 44 02 02 FF FF 47 43 4E 75 B7 8B 45 08 8B 80 AC FC FF FF 8B 55 08 89 42 E8 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_783_0 {
	meta:
		name = "TTable.CreateTable"
		size = 348
		refs = "0028 TTable.CreateTable 0065 InitTableSettings 0073 TTable.SetTempLocale 008d InitFieldDescriptors 0094 InitIndexDescriptors 009b InitValChecks 00b0 TDBDataSet.GetDBHandle 00b6 DbiCreateTable 00bb Check 00d9 TTable.RestoreLocale 00df @HandleFinally 0124 TValCheckList 0129 @DynArrayClear 0135 TIndexDescList 0146 TFieldDescList"
	strings:
		$1 = { 55 8B EC 81 C4 A0 FC FF FF 53 33 D2 89 95 B0 FC FF FF 89 95 F4 FC FF FF 89 95 AC FC FF FF 89 85 A8 FC FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 85 A8 FC FF FF 8B 10 FF 92 C4 00 00 00 B1 01 BA 03 00 00 00 8B 85 A8 FC FF FF 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 55 E8 ?? ?? ?? ?? 59 33 D2 8B 85 A8 FC FF FF E8 ?? ?? ?? ?? 89 85 A0 FC FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 55 E8 ?? ?? ?? ?? 59 55 E8 ?? ?? ?? ?? 59 55 E8 ?? ?? ?? ?? 59 8D 85 56 FD FF FF 50 6A FF 8B 85 A8 FC FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 95 A0 FC FF FF 8B 85 A8 FC FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 85 A8 FC FF FF 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 AC FC FF FF 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 B0 FC FF FF 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 F4 FC FF FF 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C5 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "TTable.DeleteTable"
		size = 131
		refs = "0029 TTable.DeleteTable 0037 TTable.GetTableTypeName 0040 TTable.NativeTableName 0049 TDBDataSet.GetDBHandle 004f DbiDeleteTable 0054 Check 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 8B 10 FF 92 C4 00 00 00 B1 01 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 5B 59 5D C3 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "TTable.EmptyTable"
		size = 202
		refs = "000c TDataSet.GetActive 0018 TDataSet.CheckBrowseMode 0024 TBDEDataSet.GetHandle 002d TDBDataSet.GetDBHandle 0033 DbiEmptyTable 0038 Check 006e TTable.EmptyTable 007c TTable.GetTableTypeName 0085 TTable.NativeTableName 00c0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 44 8B 45 FC E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 C8 00 00 00 33 C9 B2 02 8B 45 FC 8B 18 FF 93 E4 00 00 00 EB 6E B1 01 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 5B 59 5D C3 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "TTable.SetTableLock"
		size = 90
		refs = "002f TBDEDataSet.GetHandle 0035 DbiAcqTableLock 003a Check 004c DbiRelTableLock"
	strings:
		$1 = { 53 56 57 51 88 0C 24 8B DA 8B F8 8B C7 8B 10 FF 92 BC 00 00 00 84 DB 75 07 BE 02 00 00 00 EB 05 BE 01 00 00 00 80 3C 24 00 74 15 56 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 15 56 6A 00 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "TTable.RenameTable"
		size = 179
		refs = "0031 TTable.RenameTable 0044 TDBDataSet.GetDBLocale 0052 AnsiToNative 005b TTable.GetTableTypeName 0064 TTable.NativeTableName 006d TDBDataSet.GetDBHandle 0073 DbiRenameTable 0078 Check 009d @HandleFinally 00aa TTable.SetTableName"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 89 55 F8 89 45 FC 8B 45 FC 8B 10 FF 92 C4 00 00 00 B1 01 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 04 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8D 8D F3 FE FF FF 8B 55 F8 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 03 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_790_0 {
	meta:
		name = "TTable.EncodeFieldDesc"
		size = 170
		refs = "001d AnsiToNative 0027 FldTypeMap 0033 FldSubTypeMap 0046 TTable.EncodeFieldDesc"
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F2 8B 5D 10 6A 1F 8D 4E 02 8B 80 98 01 00 00 8B 55 FC E8 ?? ?? ?? ?? 0F B6 C3 0F B6 90 ?? ?? ?? ?? 66 89 56 22 0F B7 04 45 ?? ?? ?? ?? 66 89 46 24 0F B6 C3 83 F8 17 77 60 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 00 00 00 00 00 00 02 00 00 00 01 01 00 01 01 01 01 01 01 01 00 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0F B7 45 0C 66 89 46 26 EB 24 83 7D 08 00 7E 10 83 7D 08 20 7F 0A 0F B7 45 08 66 89 46 26 EB 06 66 C7 46 26 20 00 0F B7 45 0C 66 89 46 28 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "TTable.DataEvent"
		size = 32
		refs = "001a TBDEDataSet.DataEvent"
	strings:
		$1 = { 53 80 FA 08 75 13 83 B8 54 02 00 00 00 74 0A 8B 98 54 02 00 00 C6 43 20 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "TTable.GetCanModify"
		size = 31
		refs = "0006 TBDEDataSet.GetCanModify"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 09 80 BB 5E 02 00 00 00 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_793_0 {
	meta:
		name = "TTable.GetDriverTypeName"
		size = 96
		refs = "0016 TDBDataSet.GetDBHandle 001c DbiGetProp 0021 Check 0026 TTable.GetDriverTypeName 002d StrIComp 0038 TTable.GetTableTypeName 0047 StrCopy"
	strings:
		$1 = { 53 56 57 51 8B DA 8B F8 8B F3 54 6A 20 53 68 02 00 04 00 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 75 18 8B C7 E8 ?? ?? ?? ?? 8B F0 85 F6 74 0B 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C6 5A 5F 5E 5B C3 53 54 41 4E 44 41 52 44 00 00 00 00 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "TTable.GetTableTypeName"
		size = 38
		refs = "0016 TTable.GetTableType 0020 TableTypeDriverNames"
	strings:
		$1 = { 53 8B D8 8B 83 44 02 00 00 80 78 76 00 74 04 33 C0 5B C3 8B C3 E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_795_0 {
	meta:
		name = "TTable.GetTableLevel"
		size = 41
		refs = "0006 TBDEDataSet.GetHandle 001b GetIntProp"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 13 8B C3 E8 ?? ?? ?? ?? BA 03 00 05 00 E8 ?? ?? ?? ?? 5B C3 8B 83 78 02 00 00 5B C3 }
	condition:
		$1
}

rule function_796_0 {
	meta:
		name = "TTable.FieldDefsStored"
		size = 26
	strings:
		$1 = { 80 B8 50 02 00 00 00 74 0E 8B 40 40 8B 40 08 83 78 08 00 0F 9F C0 C3 33 C0 C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "TTable.IndexDefsStored"
		size = 29
	strings:
		$1 = { 80 B8 50 02 00 00 00 74 11 8B 80 54 02 00 00 8B 40 08 83 78 08 00 0F 9F C0 C3 33 C0 C3 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "TTable.IsXBaseTable"
		size = 136
		refs = "000c TTable.IsXBaseTable 002d ExtractFileExt 003a CompareText 005b @UStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 83 5F 02 00 00 04 FE 2C 02 72 23 8D 55 FC 8B 83 64 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 44 00 42 00 46 00 00 00 00 00 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "TTable.GetFileName"
		size = 316
		refs = "0019 TTable.GetFileName 0052 TDatabase.GetDirectory 0071 IsPathDelimiter 0081 @UStrCat 0092 ExtractFileExt 00ac Exts 00ba ChangeFileExt 00fd @HandleFinally 0119 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 89 4D F0 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B1 01 BA 09 00 00 00 8B 45 FC 8B 30 FF 96 D8 02 00 00 88 45 FB 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D3 8B 45 FC 8B 80 44 02 00 00 E8 ?? ?? ?? ?? 83 3B 00 74 2A 8B 03 89 45 F4 8B 75 F4 85 F6 74 05 83 EE 04 8B 36 8B 03 8B D6 E8 ?? ?? ?? ?? 84 C0 75 0C 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 F0 8B 45 FC 8B 80 64 02 00 00 E8 ?? ?? ?? ?? 83 7D F0 00 75 2E 8D 4D EC 8B 45 FC 0F B6 80 5F 02 00 00 8B 14 85 ?? ?? ?? ?? 8B 45 FC 8B 80 64 02 00 00 E8 ?? ?? ?? ?? 8B 55 EC 8B C3 E8 ?? ?? ?? ?? EB 10 8B C3 8B 55 FC 8B 92 64 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 0F B6 4D FB BA 09 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 5C 00 00 00 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "TTable.GetTableType"
		size = 488
		refs = "0013 TTable.GetTableType 0076 ExtractFileExt 0083 CompareText 00a9 TTable.GetFileName 00b9 ChangeFileExt 00c3 FileExists 0136 @HandleFinally 0152 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F3 00 B1 01 BA 09 00 00 00 8B 45 F4 8B 18 FF 93 D8 02 00 00 88 45 F2 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F4 8B 80 44 02 00 00 80 78 76 00 0F 85 B8 00 00 00 8B 45 F4 0F B6 80 5F 02 00 00 84 C0 0F 85 A3 00 00 00 8D 55 F8 8B 45 F4 8B 80 64 02 00 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 75 06 C6 45 F3 01 EB 7E BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 75 53 8D 55 FC 8B 45 F4 E8 ?? ?? ?? ?? 8D 4D EC BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 EC B2 01 E8 ?? ?? ?? ?? 84 C0 75 1E 8D 4D E8 BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E8 B2 01 E8 ?? ?? ?? ?? 84 C0 74 06 C6 45 F3 03 EB 20 C6 45 F3 02 EB 1A BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 75 09 C6 45 F3 04 EB 03 88 45 F3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D F2 00 75 12 33 C9 BA 09 00 00 00 8B 45 F4 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 0F B6 45 F3 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 03 00 00 00 2E 00 44 00 42 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 44 00 42 00 46 00 00 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 46 00 50 00 54 00 00 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 43 00 44 00 58 00 00 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 54 00 58 00 54 00 00 00 00 00 }
	condition:
		$1
}

rule function_801_0 {
	meta:
		name = "TTable.NativeTableName"
		size = 49
		refs = "0014 TDBDataSet.GetDBLocale 0025 AnsiToNative"
	strings:
		$1 = { 53 8B D8 80 BB 7D 02 00 00 00 75 1D 68 04 01 00 00 8B C3 E8 ?? ?? ?? ?? 8D 8B 7D 02 00 00 8B 93 64 02 00 00 E8 ?? ?? ?? ?? 8D 83 7D 02 00 00 5B C3 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "TTable.SetExclusive"
		size = 25
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 C4 00 00 00 88 9E 5D 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_803_0 {
	meta:
		name = "TTable.SetReadOnly"
		size = 25
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 C4 00 00 00 88 9E 5E 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_804_0 {
	meta:
		name = "TTable.SetTableName"
		size = 101
		refs = "0015 @UStrAsg 0025 @UStrEqual"
	strings:
		$1 = { 53 56 8B DA 8B F0 F6 46 1C 02 74 10 8D 86 64 02 00 00 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 8B 86 64 02 00 00 8B D3 E8 ?? ?? ?? ?? 74 37 8B C6 8B 10 FF 92 C4 00 00 00 8B 86 6C 02 00 00 8B 10 FF 52 44 8D 86 64 02 00 00 8B D3 E8 ?? ?? ?? ?? C6 86 7D 02 00 00 00 33 C9 B2 08 8B C6 8B 18 FF 93 E4 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "TTable.SetTableType"
		size = 25
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 C4 00 00 00 88 9E 5F 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "TTable.PSGetCommandText"
		size = 22
		refs = "000f @UStrAsg"
		altNames = "TTable.PSGetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 93 64 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "GetIdx"
		size = 254
		refs = "0015 GetIdx 0057 TIndexDefs.GetIndexDef 009a TIndexDef.GetFields 00aa TDataSet.GetFieldList 00c1 @HandleAnyException 00c8 @DoneExcept 00e9 @UStrClr 00ef @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 D2 89 55 F0 88 45 FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8B 45 08 8B 40 FC 8B 80 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 0F 8C 9C 00 00 00 40 89 45 F4 C7 45 F8 00 00 00 00 8B 45 08 8B 40 FC 8B 80 54 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? 0F B6 55 FF 80 FA 07 77 0A 83 E2 7F 0F B6 40 24 0F A3 D0 73 5C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 80 54 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 4D F0 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 20 33 C0 5A 59 59 64 89 10 E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? FF 45 F8 FF 4D F4 0F 85 6F FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TTable.PSGetDefaultOrder"
		size = 312
		refs = "0015 TTable.PSGetDefaultOrder 002b TIndexDefs.Update 0044 TTable.GetIndexName 0066 TIndexDefs.Find 0075 TTable.GetIndexFieldNames 0097 TIndexDefs.FindIndexForFields 00a7 TIndexDef.GetFields 00b4 TDataSet.GetFieldList 00c3 @HandleAnyException 00ca @DoneExcept 00d6 GetIdx 00f5 _Dn_TIndexDef 00fa TCollectionItem.Create 0123 @UStrArrayClr 0129 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8B 45 FC 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? 83 7D F8 00 74 20 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 EB 2F 8D 55 F0 8B 45 FC E8 ?? ?? ?? ?? 83 7D F0 00 74 1E 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 FC 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 17 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 4D E8 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0C E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? 85 DB 75 0B 55 33 C0 E8 ?? ?? ?? ?? 59 8B D8 85 DB 75 0B 55 B0 01 E8 ?? ?? ?? ?? 59 8B D8 85 DB 74 1B 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B D3 8B C6 8B 08 FF 51 08 EB 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 05 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_810_0 {
	meta:
		name = "TTable.PSGetIndexDefs"
		size = 21
		refs = "000f TDataSet.GetIndexDefs"
	strings:
		$1 = { 51 88 14 24 0F B6 0C 24 8B 90 54 02 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "AssignFields"
		size = 218
		refs = "001a AssignFields 003b TParams.GetItem 0052 TParam.GetAsVariant 006d TDataSet.FieldByName 009a TBDEDataSet.GetIndexField 00bd Variant 00c7 @FinalizeArray 00cd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 51 53 56 57 8B 7D 08 83 C7 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 07 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 78 46 33 DB 8B 07 8B D3 E8 ?? ?? ?? ?? 83 78 34 00 74 37 8B 07 8B D3 E8 ?? ?? ?? ?? 8D 55 F0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 07 8B D3 E8 ?? ?? ?? ?? 8B 50 34 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 5A 8B 08 FF 91 00 01 00 00 EB 2B 8B 07 8B D3 E8 ?? ?? ?? ?? 8D 55 E0 E8 ?? ?? ?? ?? 8D 45 E0 50 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 5A 8B 08 FF 91 00 01 00 00 43 4E 75 8B 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "TTable.PSSetParams"
		size = 107
		refs = "001c TDataSet.Open 0024 TTable.SetRangeStart 002a AssignFields 0033 TTable.SetRangeEnd 0042 TTable.ApplyRange 004c TDataSet.GetActive 0058 TTable.CancelRange"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 55 FC 89 45 F8 8B 45 FC 8B 40 08 83 78 08 00 7E 30 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B 45 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B 45 F8 E8 ?? ?? ?? ?? EB 14 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 08 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 10 FF 92 9C 00 00 00 59 59 5D C3 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "TTable.PSSetCommandText"
		size = 22
		refs = "000f TTable.SetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_31975_0 {
	meta:
		name = "TIBStoredProc.PSSetCommandText"
		size = 22
		refs = "000f TIBStoredProc.SetProcName"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_32052_0 {
	meta:
		name = "TIBTable.PSSetCommandText"
		size = 22
		refs = "000f TIBTable.SetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "TStoredProc.PSSetCommandText"
		size = 22
		refs = "000f TStoredProc.SetProcName"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "TTable.PSGetKeyFields"
		size = 282
		refs = "0016 TTable.PSGetKeyFields 0025 TDataSet.PSGetKeyFields 0035 TTable.GetExists 004a TIndexDefs.Update 0078 TIndexDefs.GetIndexDef 0093 TIndexDef.GetFields 009d TFields.GetCount 00bc ExtractFieldName 00c6 TDataSet.FindField 00d6 @UStrLen 00f2 @UStrClr 010d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F0 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B C6 E8 ?? ?? ?? ?? 83 3F 00 0F 85 C4 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 B5 00 00 00 33 DB 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 8B 86 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 0F 8C 88 00 00 00 40 89 45 F4 C7 45 FC 00 00 00 00 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? F6 40 24 02 74 61 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B C6 8B 40 38 E8 ?? ?? ?? ?? 85 C0 0F 94 C3 84 DB 75 35 C7 45 F8 01 00 00 00 EB 20 8D 4D F0 8D 55 F8 8B 07 E8 ?? ?? ?? ?? 8B 55 F0 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 0C 8B 07 E8 ?? ?? ?? ?? 3B 45 F8 7D D4 84 DB 75 08 FF 45 FC FF 4D F4 75 83 84 DB 75 07 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_816_0 {
	meta:
		name = "THTTPDataLink.Create"
		size = 60
		refs = "000b @ClassCreate 001a TDataLink.Create 0028 @AfterConstruction"
		altNames = "TIBDataLink.Create TQueryDataLink.Create TSQLDataLink.Create TScopeDataLink.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_76801_0 {
	meta:
		name = "TDockZone.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_73583_0 {
	meta:
		name = "TFontAdapter.Create"
		size = 60
		refs = "000b @ClassCreate 001a TCustomAdapter.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_82920_0 {
	meta:
		name = "TOutlineNode.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_73588_0 {
	meta:
		name = "TPictureAdapter.Create"
		size = 60
		refs = "000b @ClassCreate 001a TCustomAdapter.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "TQueryDataLink.ActiveChanged"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TQuery.RefreshParams"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30186_0 {
	meta:
		name = "TIBDataLink.ActiveChanged"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TIBCustomDataSet.RefreshParams"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30189_0 {
	meta:
		name = "TIBDataLink.CheckBrowseMode"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TDataSet.CheckBrowseMode"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5832_0 {
	meta:
		name = "TMasterDataLink.CheckBrowseMode"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TDataSet.CheckBrowseMode"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TQueryDataLink.CheckBrowseMode"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TDataSet.CheckBrowseMode"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14456_0 {
	meta:
		name = "TSQLDataLink.ActiveChanged"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TCustomSQLDataSet.RefreshParams"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14459_0 {
	meta:
		name = "TSQLDataLink.CheckBrowseMode"
		size = 25
		refs = "0007 TDataSet.GetActive 0013 TDataSet.CheckBrowseMode"
	strings:
		$1 = { 53 8B D8 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TAdapterDispatchParams.GetParams"
		size = 4
		altNames = "TButtonCollection.GetOwner TCoolBands.GetOwner TDBXAnsiStringValue.GetStreamReader TDBXDriverHelp.GetMetaDataReader TDBXFilterSocketChannel.GetFlag TDBXWideStringValue.GetStreamReader TDirect2DFont.GetHeight THelpManager.GetHandle TIBDataLink.GetDetailDataSet TIdIOHandlerSocketPeer.GetObject TMasterDataLink.GetDetailDataSet TQueryDataLink.GetDetailDataSet TRttiIntfMethod.GetTailHandle TSQLDataLink.GetDetailDataSet TSeriesMarks.GetBackColor TStreamLoader.GetTimeout TXMLNodeList.GetUpdateCount"
	strings:
		$1 = { 8B 40 1C C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TQueryDataLink.RecordChanged"
		size = 33
		refs = "000e TDataSet.GetActive 001a TQuery.RefreshParams"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 75 14 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_30188_0 {
	meta:
		name = "TIBDataLink.RecordChanged"
		size = 33
		refs = "000e TDataSet.GetActive 001a TIBCustomDataSet.RefreshParams"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 75 14 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14458_0 {
	meta:
		name = "TSQLDataLink.RecordChanged"
		size = 33
		refs = "000e TDataSet.GetActive 001a TCustomSQLDataSet.RefreshParams"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 75 14 8B 43 1C E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 1C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TStoredProc.Create"
		size = 73
		refs = "000a @ClassCreate 0017 TDBDataSet.Create 0020 _Dn_TParams 0025 TParams.Create 0036 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 54 02 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TStoredProc.Destroy"
		size = 64
		refs = "0003 @BeforeDestruction 000e TComponent.Destroying 0023 TObject.Free 002e TBDEDataSet.Destroy 0039 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 D4 02 00 00 8B 86 54 02 00 00 E8 ?? ?? ?? ?? B2 FC 22 D3 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "WriteData"
		size = 71
		refs = "0024 TParams.IsEqual"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 8B 58 20 85 DB 74 1C 8B 93 54 02 00 00 8B 45 08 8B 40 F8 8B 80 54 02 00 00 E8 ?? ?? ?? ?? 34 01 5B 5D C3 8B 45 08 8B 40 F8 8B 80 54 02 00 00 8B 40 08 8B 40 08 85 C0 0F 9F C0 5B 5D C3 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TStoredProc.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TStoredProc.ReadParamData 0026 TStoredProc.WriteParamData 002c WriteData 0034 TStoredProc.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 50 00 61 00 72 00 61 00 6D 00 44 00 61 00 74 00 61 00 00 00 }
	condition:
		$1
}

rule function_31431_0 {
	meta:
		name = "TIBQuery.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TIBQuery.ReadParamData 0026 TIBQuery.WriteParamData 002c WriteData 0034 TIBQuery.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 50 00 61 00 72 00 61 00 6D 00 44 00 61 00 74 00 61 00 00 00 }
	condition:
		$1
}

rule function_31968_0 {
	meta:
		name = "TIBStoredProc.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TIBStoredProc.ReadParamData 0026 TIBStoredProc.WriteParamData 002c WriteData 0034 TIBStoredProc.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 50 00 61 00 72 00 61 00 6D 00 44 00 61 00 74 00 61 00 00 00 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TStoredProc.WriteParamData"
		size = 13
		refs = "0008 TWriter.WriteCollection"
	strings:
		$1 = { 8B 80 54 02 00 00 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TStoredProc.ReadParamData"
		size = 29
		refs = "0009 TReader.ReadValue 0016 TReader.ReadCollection"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 8B 93 54 02 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_827_0 {
	meta:
		name = "TStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_46321_0 {
	meta:
		name = "FileMove"
		size = 19
		refs = "0006 FileCopy 000d FileDelete"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90718_0 {
	meta:
		name = "TAreaSeries.GalleryChanged3D"
		size = 19
		refs = "0006 TCustomChartSeries.GalleryChanged3D 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90736_0 {
	meta:
		name = "TAreaSeries.PrepareForGallery"
		size = 19
		refs = "0006 TChartSeries.PrepareForGallery 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_93210_0 {
	meta:
		name = "TChartGalleryPanel.Resize"
		size = 19
		refs = "0006 TControl.Resize 000d TChartGalleryPanel.ResizeCharts"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74199_0 {
	meta:
		name = "TCheckListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74196_0 {
	meta:
		name = "TCheckListBox.CreateWnd"
		size = 19
		refs = "0006 TCustomListBox.CreateWnd 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_70145_0 {
	meta:
		name = "TComplexData.DoArcCot"
		size = 19
		refs = "0006 TComplexData.DoInverse 000d TComplexData.DoArcTan"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_70153_0 {
	meta:
		name = "TComplexData.DoSecH"
		size = 19
		refs = "0006 TComplexData.DoCosH 000d TComplexData.DoInverse"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75700_0 {
	meta:
		name = "TCoolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75653_0 {
	meta:
		name = "TCoolBar.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCoolBar.UpdateBands"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_73205_0 {
	meta:
		name = "TCustomActionMainMenuBar.CloseMenu"
		size = 19
		refs = "0006 TCustomActionMenuBar.ClearSubMenus 000d TCustomActionMenuBar.CloseMenu"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_85065_0 {
	meta:
		name = "TCustomCheckBox.Click"
		size = 19
		refs = "0006 TControl.Changed 000d TControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77891_0 {
	meta:
		name = "TCustomDBGrid.TopLeftChanged"
		size = 19
		refs = "0006 TCustomDBGrid.InvalidateTitles 000d TCustomGrid.TopLeftChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77880_0 {
	meta:
		name = "TCustomDBGrid.WMIMEStartComp"
		size = 19
		refs = "0006 TWinControl.WMIMEStartComp 000d TCustomGrid.ShowEditor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26306_0 {
	meta:
		name = "TCustomDataSetAdapter.AddDefaultFields"
		size = 19
		refs = "0006 AddDefaultDataSetFields 000d TCustomDataSetAdapter.CreateDataLink"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80900_0 {
	meta:
		name = "TCustomGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80905_0 {
	meta:
		name = "TCustomGrid.ColWidthsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80906_0 {
	meta:
		name = "TCustomGrid.RowHeightsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_80896_0 {
	meta:
		name = "TCustomGrid.WMCancelMode"
		size = 19
		refs = "0006 TControl.WMCancelMode 000d TCustomGrid.CancelMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79329_0 {
	meta:
		name = "TCustomLinkLabel.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79328_0 {
	meta:
		name = "TCustomLinkLabel.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_85151_0 {
	meta:
		name = "TCustomListBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TCustomListBox.SetColumnWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79039_0 {
	meta:
		name = "TCustomRadioGroup.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79031_0 {
	meta:
		name = "TCustomRadioGroup.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TCustomRadioGroup.UpdateButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79029_0 {
	meta:
		name = "TCustomRadioGroup.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79040_0 {
	meta:
		name = "TCustomRadioGroup.WMSize"
		size = 19
		refs = "0006 TCustomGroupBox.WMSize 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83400_0 {
	meta:
		name = "TCustomRibbonQuickAccessToolbar.CreateControls"
		size = 19
		refs = "0006 TCustomActionToolBar.CreateControls 000d TCustomRibbonQuickAccessToolbar.DoUpdateQATWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84321_0 {
	meta:
		name = "TCustomScreenTipsManager.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TCustomScreenTipsManager.ValidateAllocatedActions"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84554_0 {
	meta:
		name = "TCustomShellComboBox.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellComboBox.ClearItems 000d TCustomComboBoxEx.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84576_0 {
	meta:
		name = "TCustomShellComboBox.Loaded"
		size = 19
		refs = "0006 TCustomCombo.Loaded 000d TCustomShellComboBox.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84585_0 {
	meta:
		name = "TCustomShellListView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellListView.ClearItems 000d TCustomListView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84514_0 {
	meta:
		name = "TCustomShellTreeView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellTreeView.ClearItems 000d TCustomTreeView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84545_0 {
	meta:
		name = "TCustomShellTreeView.Loaded"
		size = 19
		refs = "0006 TCustomTreeView.Loaded 000d TCustomShellTreeView.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_85195_0 {
	meta:
		name = "TCustomStaticText.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_85197_0 {
	meta:
		name = "TCustomStaticText.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74573_0 {
	meta:
		name = "TCustomStatusBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74576_0 {
	meta:
		name = "TCustomStatusBar.CMSysColorChange"
		size = 19
		refs = "0006 TWinControl.CMSysColorChange 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74577_0 {
	meta:
		name = "TCustomStatusBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TCustomStatusBar.SyncToSystemFont"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_76934_0 {
	meta:
		name = "TCustomTransparentControl.Invalidate"
		size = 19
		refs = "0006 TCustomTransparentControl.InvalidateControlsUnderneath 000d TWinControl.Invalidate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74877_0 {
	meta:
		name = "TCustomTreeView.DoEnter"
		size = 19
		refs = "0006 TCustomTreeView.InvalidateSelectionsRects 000d TWinControl.DoEnter"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74878_0 {
	meta:
		name = "TCustomTreeView.DoExit"
		size = 19
		refs = "0006 TWinControl.DoExit 000d TCustomTreeView.InvalidateSelectionsRects"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_95452_0 {
	meta:
		name = "TCustomWebBrowserChangeManager.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TCustomWebBrowserChangeManager.CreateChangeLog"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90559_0 {
	meta:
		name = "TDBChartEditor.CBSourcesChange"
		size = 19
		refs = "0006 TBaseSourceEditor.CBSourcesChange 000d TDBChartEditor.SetFields"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77277_0 {
	meta:
		name = "TDBComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TDBComboBox.SetEditReadOnly"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77938_0 {
	meta:
		name = "TDBLookupCombo.CMFontChanged"
		size = 19
		refs = "0006 TCustomEdit.CMFontChanged 000d TDBLookupCombo.GetMinHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_77525_0 {
	meta:
		name = "TDBLookupListBox.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TDBLookupListBox.UpdateScrollBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7576_0 {
	meta:
		name = "TDBXStreamValue.SetNull"
		size = 19
		refs = "0006 TDBXWritableValue.SetNull 000d TDBXStreamValue.FreeLastReadStream"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17579_0 {
	meta:
		name = "TDSHTTPServerTransport.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TDSHTTPServerTransport.RequiresServer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79414_0 {
	meta:
		name = "TDirectoryListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TDirectoryListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79409_0 {
	meta:
		name = "TDirectoryListBox.DblClick"
		size = 19
		refs = "0006 TControl.DblClick 000d TDirectoryListBox.OpenCurrent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_52953_0 {
	meta:
		name = "TEvaluator.TParser.Eat"
		size = 19
		refs = "0006 TEvaluator.TParser.Expect 000d TEvaluator.TParser.NextToken"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79442_0 {
	meta:
		name = "TFileListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TFileListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_79450_0 {
	meta:
		name = "TFilterComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TFilterComboBox.BuildList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_81528_0 {
	meta:
		name = "TGIFRenderer.HaltAnimation"
		size = 19
		refs = "0006 TCustomGIFRenderer.HaltAnimation 000d TGIFRenderer.StopAnimationTimer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30420_0 {
	meta:
		name = "TIBDatabase.DBParamsChanging"
		size = 19
		refs = "0006 TIBDatabase.EnsureInactive 000d TIBDatabase.CheckInactive"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_31422_0 {
	meta:
		name = "TIBQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_31632_0 {
	meta:
		name = "TIBSecurityService.Loaded"
		size = 19
		refs = "0006 TIBCustomService.Loaded 000d TIBSecurityService.ClearParams"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_31946_0 {
	meta:
		name = "TIBStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30506_0 {
	meta:
		name = "TIBTransaction.TRParamsChanging"
		size = 19
		refs = "0006 TIBTransaction.EnsureNotInTransaction 000d TIBTransaction.CheckNotInTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_43962_0 {
	meta:
		name = "TIWContainer.Loaded"
		size = 19
		refs = "0006 TIWBaseContainer.Loaded 000d TIWContainer.FixUpTabList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_45860_0 {
	meta:
		name = "TIWCustomRegion.Loaded"
		size = 19
		refs = "0006 TIWContainer.Loaded 000d TIWCustomRegion.DoCreate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_45293_0 {
	meta:
		name = "TIWHTTPServerModule.ForcePortRefresh"
		size = 19
		refs = "0006 TIWHTTPServerModule.SetHTTPPort 000d TIWHTTPServerModule.SetHTTPSPort"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_32532_0 {
	meta:
		name = "TIdCompressionIntercept.Disconnect"
		size = 19
		refs = "0006 TIdConnectionIntercept.Disconnect 000d TIdCompressionIntercept.DeinitCompressors"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35591_0 {
	meta:
		name = "TIdConnectThread.DoTerminate"
		size = 19
		refs = "0006 TThread.Terminate 000d TThread.DoTerminate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36036_0 {
	meta:
		name = "TIdMessage.Clear"
		size = 19
		refs = "0006 TIdMessage.ClearHeader 000d TIdMessage.ClearBody"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35040_0 {
	meta:
		name = "TIdProxyConnectionInfo.AfterConstruction"
		size = 19
		refs = "0006 TObject.AfterConstruction 000d TIdProxyConnectionInfo.Clear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_82416_0 {
	meta:
		name = "TMediaPlayer.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d TMediaPlayer.Adjust"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_64224_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 19
		refs = "0006 TObject.CleanupInstance 000d @FreeMem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74488_0 {
	meta:
		name = "TPageControl.Loaded"
		size = 19
		refs = "0006 TCustomTabControl.Loaded 000d TPageControl.UpdateTabHighlights"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90705_0 {
	meta:
		name = "TPointSeries.Assign"
		size = 19
		refs = "0006 TCustomSeries.Assign 000d TPointSeries.SetFixed"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83140_0 {
	meta:
		name = "TPrinter.Refresh"
		size = 19
		refs = "0006 TPrinter.FreeFonts 000d TPrinter.FreePrinters"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_860_0 {
	meta:
		name = "TQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84023_0 {
	meta:
		name = "TRibbonApplicationPopupMenu.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TRibbonApplicationPopupMenu.CreateWindowRegion"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_83961_0 {
	meta:
		name = "TRibbonSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TRibbonSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84397_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseLeave"
		size = 19
		refs = "0006 TControl.CMMouseLeave 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84396_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseenter"
		size = 19
		refs = "0006 TControl.CMMouseEnter 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_84276_0 {
	meta:
		name = "TSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_94304_0 {
	meta:
		name = "TTeeSeriesSource.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TTeeSeriesSource.Refresh"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75545_0 {
	meta:
		name = "TToolBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_75548_0 {
	meta:
		name = "TToolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_90003_0 {
	meta:
		name = "TValueListStrings.Clear"
		size = 19
		refs = "0006 TStringList.Clear 000d TValueListStrings.FreeItemProps"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_115059_0 {
	meta:
		name = "TXMLTypedSchemaItem.SetRefItem"
		size = 19
		refs = "0006 TXMLSchemaItem.SetRefItem 000d TXMLTypedSchemaItem.RemoveTypeInfo"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TStoredProc.CreateCursor"
		size = 41
		refs = "0014 TStoredProc.SetPrepared 001d TStoredProc.GetCursor"
	strings:
		$1 = { 53 56 8B DA 8B F0 83 BE 50 02 00 00 00 74 15 B2 01 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TStoredProc.GetCursor"
		size = 59
		refs = "0017 TStoredProc.BindParams 0024 DbiQExec 0029 Check 0030 TStoredProc.GetResults"
	strings:
		$1 = { 53 56 51 8B D8 33 C0 89 04 24 84 D2 74 04 8B F4 EB 02 33 F6 8B C3 E8 ?? ?? ?? ?? 56 8B 83 84 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TStoredProc.ExecProc"
		size = 104
		refs = "0029 TStoredProc.ExecProc 0039 TStoredProc.CreateCursor 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 8B 10 FF 92 C4 00 00 00 B1 01 BA 07 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 07 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 5B 59 5D C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TStoredProc.SetProcName"
		size = 87
		refs = "001f @UStrEqual 002e @UStrAsg 0035 TStoredProc.FreeStatement 0040 TCollection.Clear"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 02 75 3B 8B C3 8B 10 FF 92 C4 00 00 00 8B C6 8B 93 50 02 00 00 E8 ?? ?? ?? ?? 74 2F 8D 83 50 02 00 00 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 8D 83 50 02 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TStoredProc.SetOverLoad"
		size = 69
		refs = "0029 TStoredProc.FreeStatement 0034 TCollection.Clear"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 02 75 2F 8B C3 8B 10 FF 92 C4 00 00 00 66 3B B3 64 02 00 00 74 23 66 89 B3 64 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 66 89 B3 64 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_834_0 {
	meta:
		name = "TStoredProc.GetParamsCount"
		size = 13
	strings:
		$1 = { 8B 80 54 02 00 00 8B 40 08 8B 40 08 C3 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "TStoredProc.CreateParamDesc"
		size = 414
		refs = "001d TStoredProc.CreateParamDesc 002c TDBDataSet.GetDBLocale 003a AnsiToNative 0053 TDBDataSet.GetDBHandle 0059 DbiOpenSPParamList 0087 NativeToAnsi 009e SResultName 00a3 LoadResString 00b6 @LStrFromUStr 00c8 DataTypeMap 0100 BlobTypeMap 010b TCollection.Add 0118 TParam.SetParamType 0121 TParam.SetDataType 012c @UStrFromLStr 013d DbiGetNextRecord 014d TStoredProc.SetServerParams 0163 DbiCloseCursor 0169 @HandleFinally 0183 @UStrClr 018b @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 7C FF FF FF 53 56 57 33 D2 89 95 7C FF FF FF 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 40 8B C7 E8 ?? ?? ?? ?? 8D 4D 83 8B 97 50 02 00 00 E8 ?? ?? ?? ?? 8D 45 F8 50 0F B7 87 64 02 00 00 50 6A 00 8D 45 83 50 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 85 09 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E9 B7 00 00 00 8B C7 E8 ?? ?? ?? ?? 8D 4D FC 8D 55 C6 E8 ?? ?? ?? ?? 80 7D E6 04 75 29 83 7D FC 00 75 23 8D 95 7C FF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 7C FF FF FF 8D 45 FC B9 00 00 00 00 E8 ?? ?? ?? ?? 66 83 7D EA 19 73 0D 0F B7 45 EA 0F B6 98 ?? ?? ?? ?? EB 02 33 DB 0F B7 45 EA 66 83 E8 03 74 11 66 83 E8 04 75 24 66 83 7D EC 15 75 1D B3 07 EB 19 66 83 7D EC 16 72 12 66 83 7D EC 24 77 0B 0F B7 45 EC 0F B6 98 ?? ?? ?? ?? 8B 87 54 02 00 00 E8 ?? ?? ?? ?? 8B F0 0F B6 55 E6 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8D 46 34 8B 55 FC E8 ?? ?? ?? ?? 6A 00 8D 45 C4 50 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 66 85 C0 0F 84 2F FF FF FF 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 7C FF FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "TStoredProc.SetServerParams"
		size = 246
		refs = "001a TStoredProc.SetServerParams 003e TServerDescList 0043 @DynArraySetLength 006a TParams.GetItem 0092 @LStrFromUStr 00a8 @LStrToString 00b8 @PStrNCpy 00bf TParam.GetDataType 00e3 @LStrClr 00e9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 57 33 D2 89 95 F4 FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 54 02 00 00 8B 40 08 8B 40 08 50 8D 83 5C 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 83 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 7C 74 40 89 45 FC 33 F6 8B D6 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B F8 8B C6 C1 E0 05 03 C6 8B 93 5C 02 00 00 8D 04 42 89 45 F8 8D 85 F4 FE FF FF 8B 57 34 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 95 F4 FE FF FF 8D 85 F8 FE FF FF B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8B 45 F8 B1 40 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 88 42 41 46 FF 4D FC 75 92 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "TStoredProc.CheckServerParams"
		size = 262
		refs = "0014 TStoredProc.CheckServerParams 002a TStoredProc.SetServerParams 0041 @DynArrayHigh 007d TParams.GetItem 009c @UStrFromString 00a7 @UStrEqual 00b0 TParam.GetDataType 00f1 @UStrClr 00f7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 D2 89 55 E8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 5C 02 00 00 00 75 0E 8B C3 E8 ?? ?? ?? ?? 33 DB E9 AB 00 00 00 33 C0 89 45 FC 8B 83 5C 02 00 00 E8 ?? ?? ?? ?? 85 C0 0F 8C 91 00 00 00 40 89 45 F0 C7 45 F8 00 00 00 00 8B 45 FC 8B 93 54 02 00 00 8B 52 08 8B 52 08 4A 2B D0 7C 66 42 89 55 EC 89 45 F4 8B 55 F4 8B 83 54 02 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 F8 8B D0 C1 E0 05 03 C2 8B 93 5C 02 00 00 8D 3C 42 8D 45 E8 8B D7 E8 ?? ?? ?? ?? 8B 55 E8 8B 46 34 E8 ?? ?? ?? ?? 75 1D 8B C6 E8 ?? ?? ?? ?? 3A 47 41 74 04 33 DB EB 23 8B 45 F4 3B 45 FC 75 0D FF 45 FC EB 08 FF 45 F4 FF 4D EC 75 A1 FF 45 F8 FF 4D F0 0F 85 7A FF FF FF B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "TStoredProc.DescriptionsAvailable"
		size = 174
		refs = "0020 TStoredProc.DescriptionsAvailable 0030 TDBDataSet.GetDBLocale 0041 AnsiToNative 005e TDBDataSet.GetDBHandle 0064 DbiOpenSPParamList 007a DbiCloseCursor 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 B0 53 89 45 FC B1 01 BA 08 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 40 8B 45 FC E8 ?? ?? ?? ?? 8D 4D B3 8B 55 FC 8B 92 50 02 00 00 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 45 FC 0F B7 80 64 02 00 00 50 6A 00 8D 45 B3 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 0F 94 45 FB 80 7D FB 00 74 09 8D 45 F4 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 08 00 00 00 8B 45 FC 8B 18 FF 93 D8 02 00 00 C3 E9 ?? ?? ?? ?? EB E6 0F B6 45 FB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "TStoredProc.PrepareProc"
		size = 835
		refs = "002f TStoredProc.PrepareProc 0053 TSPParamDescList 0058 @DynArraySetLength 008b TParams.GetItem 0094 TParam.GetDataType 00b7 GetParamDataSize 00dd TArray<System.Byte> 013c SNoParameterValue 0141 LoadResString 015a DatabaseErrorFmt 0161 TParam.GetParamType 016e SNoParameterType 01a8 AnsiToNative 01d0 FldTypeMap 01e6 FldSubTypeMap 0212 TParam.GetAsVariant 021a @VarToInteger 02e8 @DynArrayHigh 02f5 TDBDataSet.GetDBHandle 02fb DbiQPrepareProc 0300 Check 0316 Variant 0320 @FinalizeArray 0328 @UStrClr 0336 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 80 53 56 57 33 D2 89 55 80 89 55 84 89 55 88 89 55 8C 89 55 90 89 55 94 89 55 98 89 55 9C 89 55 A0 89 55 AC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 86 54 02 00 00 8B 40 08 8B 40 08 50 8D 86 58 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 66 C7 45 FA 00 00 8B 86 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 7C 55 40 89 45 F4 C7 45 FC 00 00 00 00 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 2C 01 74 04 2C 16 75 08 66 81 45 FA 01 01 EB 1B 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 83 C0 02 66 01 45 FA FF 45 FC FF 4D F4 75 B6 0F B7 45 FA 50 8D 86 60 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 66 C7 45 F8 00 00 8B 86 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 0F 8C B7 01 00 00 40 89 45 F4 C7 45 FC 00 00 00 00 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 8B F8 6B 45 FC 0D 8B 96 58 02 00 00 8D 1C 82 8B C7 E8 ?? ?? ?? ?? 84 C0 75 27 56 8D 55 AC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 AC 50 8B 47 34 89 45 A4 C6 45 A8 11 8D 55 A4 33 C9 58 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 84 C0 75 27 56 8D 55 A0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 A0 50 8B 47 34 89 45 A4 C6 45 A8 11 8D 55 A4 33 C9 58 E8 ?? ?? ?? ?? 80 BE 68 02 00 00 00 75 15 6A 1F 8D 4B 02 8B 57 34 8B 86 98 01 00 00 E8 ?? ?? ?? ?? EB 08 0F B7 45 FC 40 66 89 03 8B C7 E8 ?? ?? ?? ?? 83 E0 7F 89 43 22 8B C7 E8 ?? ?? ?? ?? 83 E0 7F 0F B6 80 ?? ?? ?? ?? 66 89 43 26 8B C7 E8 ?? ?? ?? ?? 83 E0 7F 0F B7 04 45 ?? ?? ?? ?? 66 89 43 28 0F B7 43 26 66 83 F8 01 75 0E 66 C7 43 30 FF 00 66 C7 43 2A FF 00 EB 5E 66 83 F8 14 75 41 8D 55 90 8B C7 E8 ?? ?? ?? ?? 8D 45 90 E8 ?? ?? ?? ?? 66 89 43 2A 8D 55 80 8B C7 E8 ?? ?? ?? ?? 8D 45 80 E8 ?? ?? ?? ?? 66 89 43 2C 6A 1F 8D 4B 02 8B 57 34 8B 86 98 01 00 00 E8 ?? ?? ?? ?? EB 17 8B 55 FC 8B 86 54 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 43 30 0F B7 45 F8 66 89 43 2E 0F B7 43 30 66 01 45 F8 0F B7 45 FC 40 03 C0 0F B7 55 FA 66 2B D0 66 89 53 32 8B C7 E8 ?? ?? ?? ?? 2C 01 74 04 2C 02 75 1A 0F B7 45 FA 8B 55 FC 42 03 D2 2B C2 8B 96 60 02 00 00 8D 04 02 66 C7 00 FF FF FF 45 FC FF 4D F4 0F 85 54 FE FF FF 6A 40 8D 4D B3 8B 96 50 02 00 00 8B 86 98 01 00 00 E8 ?? ?? ?? ?? 8D 86 84 01 00 00 50 6A 00 8B 86 58 02 00 00 50 8B 86 58 02 00 00 E8 ?? ?? ?? ?? 40 50 8D 45 B3 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 80 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 A0 E8 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "TStoredProc.GetResults"
		size = 386
		refs = "0020 TStoredProc.GetResults 0047 @DynArrayHigh 0074 TParams.GetItem 007d TParam.GetParamType 008e TParam.GetDataType 009e @PCharLen 00b0 NativeToAnsiBuf 00d5 Null 00df TParam.SetAsVariant 00f1 STruncationError 00f6 LoadResString 010f DatabaseErrorFmt 011b TParam.SetData 0145 GetParamDataSize 0167 @UStrClr 016f @VarClr 0175 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 D2 89 55 E0 89 55 E4 89 55 E8 89 55 EC 89 55 F0 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BE 60 02 00 00 00 0F 84 1F 01 00 00 8B 86 60 02 00 00 89 45 FC 8B 86 60 02 00 00 E8 ?? ?? ?? ?? 40 66 89 45 FA 8B 86 54 02 00 00 8B 40 08 8B 40 08 48 85 C0 0F 8C F1 00 00 00 40 89 45 F4 33 FF 8B D7 8B 86 54 02 00 00 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 04 FE 2C 03 0F 83 94 00 00 00 8B C3 E8 ?? ?? ?? ?? 2C 01 74 04 2C 16 75 1A 8B 45 FC E8 ?? ?? ?? ?? 50 8B 4D FC 8B 55 FC 8B 86 98 01 00 00 E8 ?? ?? ?? ?? 0F B7 45 FA 8D 57 01 03 D2 2B C2 8B 96 60 02 00 00 8D 04 02 0F B7 10 66 83 FA FF 75 14 8D 45 E4 E8 ?? ?? ?? ?? 8D 55 E4 8B C3 E8 ?? ?? ?? ?? EB 3A 66 83 FA FE 75 2A 6A 00 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 50 8B 43 34 89 45 D8 C6 45 DC 11 8D 55 D8 33 C9 58 E8 ?? ?? ?? ?? EB 0A 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 2C 01 74 04 2C 16 75 09 81 45 FC FF 00 00 00 EB 15 8B D7 8B 86 54 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 01 45 FC 47 FF 4D F4 0F 85 15 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E4 