private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 215
		refs = "0019 __getptd 0047 ___ptlocinfo 0058 ___globallocalestatus 005f ___updatetlocinfo 0070 ___ptmbcinfo 0088 ___updatetmbcinfo"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 0F 85 A6 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 08 8B 55 FC 8B 42 08 8B 4D FC 8B 50 6C 89 11 8B 45 FC 8B 48 08 8B 55 FC 8B 41 68 89 42 04 8B 4D FC 8B 11 3B 15 ?? ?? ?? ?? 74 1B 8B 45 FC 8B 48 08 8B 51 70 23 15 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 42 04 3B 05 ?? ?? ?? ?? 74 1C 8B 4D FC 8B 51 08 8B 42 70 23 05 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 8B 42 08 8B 48 70 83 E1 02 75 1C 8B 55 FC 8B 42 08 8B 48 70 83 C9 02 8B 55 FC 8B 42 08 89 48 70 8B 4D FC C6 41 0C 01 EB 10 8B 55 08 8B 02 8B 4A 04 8B 55 FC 89 02 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 43
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 15 8B 55 FC 8B 42 08 8B 48 70 83 E1 FD 8B 55 FC 8B 42 08 89 48 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "__mbsncat_s_l"
		size = 1969
		refs = "0052 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0057 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GK@MIHKNAIH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0067 __CrtDbgReportW 007b __errno 008f ??_C@_1BK@GDKGAICE@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0099 __invalid_parameter 00e1 ___crtDebugFillThreshold 010c _memset 0136 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0196 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 019e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01bc _strncat_s 01ca ??1_LocaleUpdate@@QAE@XZ 0265 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 028e ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0345 __ismbblead_l 03e5 __CrtGetCheckCount 03f6 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0691 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 94 00 00 00 C7 45 E8 00 00 00 00 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 84 07 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 03 07 00 00 83 7D 14 00 0F 84 DA 00 00 00 83 7D 10 00 0F 85 D0 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D A8 EB 09 8B 55 0C 83 EA 01 89 55 A8 8B 45 A8 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 10 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 A0 83 7D A0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D A0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 1F 06 00 00 8B 4D 18 51 8D 4D AC E8 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 2B 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 94 8D 4D AC E8 ?? ?? ?? ?? 8B 45 94 E9 D7 05 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 F8 83 7D F8 00 76 1E 8B 45 FC 0F B6 08 85 C9 74 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 E8 01 89 45 F8 EB DC 83 7D F8 00 0F 85 E9 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 98 EB 09 8B 4D 0C 83 E9 01 89 4D 98 8B 55 98 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 9C 83 7D 9C 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 9C 00 75 43 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 6C FF FF FF 16 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 85 6C FF FF FF E9 B4 04 00 00 8B 55 F8 3B 55 0C 0F 83 9C 00 00 00 C7 45 F0 00 00 00 00 8B 45 08 89 85 70 FF FF FF B9 01 00 00 00 6B C9 FF 03 4D FC 89 4D C0 8B 55 C0 89 55 F4 8B 45 F4 3B 85 70 FF FF FF 72 27 8D 4D AC E8 ?? ?? ?? ?? 50 8B 4D F4 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 F4 83 E8 01 89 45 F4 EB CE 8B 4D C0 2B 4D F4 83 E1 01 74 09 C7 45 A4 01 00 00 00 EB 07 C7 45 A4 00 00 00 00 8B 55 A4 89 55 F0 83 7D F0 00 74 1F 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC C6 01 00 8B 55 F8 83 C2 01 89 55 F8 C7 45 E8 01 00 00 00 83 7D 14 FF 75 3D 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F B6 08 89 4D 88 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 83 7D 88 00 74 0D 8B 4D F8 83 E9 01 89 4D F8 74 02 EB C8 E9 35 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 2B 8B 55 14 3B 55 F8 72 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 14 00 0F 86 E2 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 50 8B 4D 10 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 7A B8 01 00 00 00 C1 E0 00 8B 4D 10 0F B6 14 01 85 D2 75 12 8B 45 FC C6 00 00 C7 45 E8 01 00 00 00 E9 A1 00 00 00 83 7D F8 02 77 0C C7 45 F8 00 00 00 00 E9 8F 00 00 00 8B 4D FC 8B 55 10 8A 02 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 83 C2 01 89 55 10 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 10 83 C1 01 89 4D 10 8B 55 F8 83 EA 02 89 55 F8 EB 3E 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F B6 08 89 8D 78 FF FF FF 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 83 BD 78 FF FF FF 00 74 0B 8B 4D F8 83 E9 01 89 4D F8 75 02 EB 0E 8B 55 14 83 EA 01 89 55 14 E9 14 FF FF FF 83 7D 14 00 75 0F 8B 45 FC C6 00 00 8B 4D FC 83 C1 01 89 4D FC 83 7D F8 00 0F 85 D9 01 00 00 83 7D 14 FF 0F 85 E6 00 00 00 83 7D E8 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 01 0F 86 AA 00 00 00 C7 45 F0 00 00 00 00 8B 55 08 89 55 80 8B 45 0C 8B 4D 08 8D 54 01 FE 89 55 E4 8B 45 E4 89 45 EC 8B 4D EC 3B 4D 80 72 27 8D 4D AC E8 ?? ?? ?? ?? 50 8B 55 EC 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D EC 83 E9 01 89 4D EC EB D1 8B 55 E4 2B 55 EC 83 E2 01 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 F0 83 7D F0 00 74 34 8B 4D 08 03 4D 0C C6 41 FE 00 83 3D ?? ?? ?? ?? 00 76 0A 8B 55 08 03 55 0C C6 42 FF FE C7 45 90 50 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 45 90 E9 BB 01 00 00 8B 45 08 03 45 0C C6 40 FF 00 C7 45 8C 50 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 45 8C E9 9A 01 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C4 EB 09 8B 4D 0C 83 E9 01 89 4D C4 8B 55 C4 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 45 BC 89 45 E0 83 7D E0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 84 22 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 45 84 E9 B1 00 00 00 83 7D 0C FF 74 68 81 7D 0C FF FF FF 7F 74 5F 8B 55 0C 2B 55 F8 83 C2 01 3B 55 0C 73 51 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D8 EB 11 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 89 4D D8 8B 55 D8 52 68 FE 00 00 00 8B 45 0C 2B 45 F8 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E8 00 74 25 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 85 7C FF FF FF 2A 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 85 7C FF FF FF EB 18 C7 85 74 FF FF FF 00 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__lfind_s"
		size = 683
		refs = "0030 ??_C@_1BI@OEOAAOGG@?$AAk?$AAe?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003e ??_C@_1FO@HAHHEENA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0045 __CrtDbgReportW 0059 __errno 006d ??_C@_1BC@LKOPFLDJ@?$AA_?$AAl?$AAf?$AAi?$AAn?$AAd?$AA_?$AAs?$AA?$AA@ 0077 __invalid_parameter 00a8 ??_C@_1BI@LBPPPCD@?$AAn?$AAu?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0128 ??_C@_1DE@BOPBJJCA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01a0 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0218 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C C7 45 FC 00 00 00 00 83 7D 08 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 89 45 F4 83 7D F4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 22 02 00 00 83 7D 10 00 74 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 EC 83 7D EC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 AA 01 00 00 83 7D 0C 00 75 11 8B 4D 10 83 39 00 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 55 E8 89 55 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2A 01 00 00 83 7D 14 00 76 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 4D E0 89 4D DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B2 00 00 00 83 7D 18 00 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 45 D8 89 45 D4 83 7D D4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D4 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3D 8B 55 10 8B 45 FC 3B 02 73 31 8B 4D 0C 51 8B 55 08 52 8B 45 1C 50 FF 55 18 83 C4 0C 85 C0 75 07 8B 45 0C EB 18 EB 12 8B 4D 0C 03 4D 14 89 4D 0C 8B 55 FC 83 C2 01 89 55 FC EB C5 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__chdrive"
		size = 287
		refs = "0007 ___security_cookie 001d ___doserrno 0048 ??_C@_1DE@JLKLCHND@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?5?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 004d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1FO@IEKJKJGK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005d __CrtDbgReportW 0071 __errno 0085 ??_C@_1BC@JCHHEAGH@?$AA_?$AAc?$AAh?$AAd?$AAr?$AAi?$AAv?$AAe?$AA?$AA@ 008f __invalid_parameter 00d3 ___report_rangecheckfailure 00e7 __imp__SetCurrentDirectoryW@4 00fa __imp__GetLastError@0 0100 __dosmaperr 0117 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 01 7C 06 83 7D 08 1A 7E 7F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 33 C0 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 2B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 76 8B 45 08 83 C0 40 B9 02 00 00 00 6B C9 00 66 89 44 0D F4 BA 02 00 00 00 C1 E2 00 B8 3A 00 00 00 66 89 44 15 F4 B9 02 00 00 00 D1 E1 89 4D F0 83 7D F0 06 73 02 EB 05 E8 ?? ?? ?? ?? 33 D2 8B 45 F0 66 89 54 05 F4 8D 4D F4 51 FF 15 ?? ?? ?? ?? 85 C0 74 09 C7 45 EC 00 00 00 00 EB 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 EC FF FF FF FF 8B 45 EC 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "__getdrive"
		size = 431
		refs = "000a ___security_cookie 004b __imp__GetCurrentDirectoryW@8 0064 ??_C@_0CP@HMMFJLEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0077 __calloc_dbg 008e __errno 0194 __free_dbg 01a7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 24 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 E4 FD FF FF 00 00 00 00 8D 85 F0 FD FF FF 89 85 EC FD FF FF C7 85 E0 FD FF FF 00 00 00 00 C7 85 E8 FD FF FF 00 00 00 00 8B 8D EC FD FF FF 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 89 85 E8 FD FF FF 81 BD E8 FD FF FF 04 01 00 00 7E 73 6A 34 68 ?? ?? ?? ?? 6A 02 6A 02 8B 95 E8 FD FF FF 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 EC FD FF FF 83 BD EC FD FF FF 00 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 85 E8 FD FF FF 00 00 00 00 EB 0A C7 85 E0 FD FF FF 01 00 00 00 83 BD E8 FD FF FF 00 74 1D 8B 85 EC FD FF FF 50 8B 8D E8 FD FF FF 83 C1 01 51 FF 15 ?? ?? ?? ?? 89 85 E8 FD FF FF C7 85 E4 FD FF FF 00 00 00 00 83 BD E8 FD FF FF 00 0F 84 8B 00 00 00 BA 02 00 00 00 C1 E2 00 8B 85 EC FD FF FF 0F B7 0C 10 83 F9 3A 75 72 BA 02 00 00 00 6B D2 00 8B 85 EC FD FF FF 0F B7 0C 10 83 F9 61 7C 34 BA 02 00 00 00 6B D2 00 8B 85 EC FD FF FF 0F B7 0C 10 83 F9 7A 7F 1D BA 02 00 00 00 6B D2 00 8B 85 EC FD FF FF 0F B7 0C 10 83 E9 20 89 8D DC FD FF FF EB 18 BA 02 00 00 00 6B D2 00 8B 85 EC FD FF FF 0F B7 0C 10 89 8D DC FD FF FF 8B 95 DC FD FF FF 83 EA 40 89 95 E4 FD FF FF EB 0B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 BD E0 FD FF FF 00 74 11 6A 02 8B 85 EC FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 85 E4 FD FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_setbuf"
		size = 95
		refs = "000a ??_C@_1BO@KIJENGPH@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 000f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0018 ??_C@_1GA@HNJOAPAE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 001f __CrtDbgReportW 003d _setvbuf"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 0C 00 75 14 6A 00 6A 04 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 EB 17 68 00 02 00 00 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 74
		refs = "000f @__security_check_cookie@4 0039 ___InternalCxxFrameHandler"
	strings:
		$1 = { 55 8B EC 51 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 6A 00 8B 4D 0C 51 8B 55 0C 8B 42 14 50 8B 4D 0C 8B 51 0C 52 6A 00 8B 45 10 50 8B 4D 0C 8B 51 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 171
		refs = "0010 @__security_check_cookie@4 005b ___InternalCxxFrameHandler 0074 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 008c ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 55 8B EC 51 53 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 8B 4D 08 8B 51 04 83 E2 66 74 13 8B 45 0C C7 40 24 01 00 00 00 B8 01 00 00 00 EB 76 EB 74 6A 01 8B 4D 0C 8B 51 18 52 8B 45 0C 8B 48 14 51 8B 55 0C 8B 42 0C 50 6A 00 8B 4D 10 51 8B 55 0C 8B 42 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 8B 55 0C 83 7A 24 00 75 0D 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 55 FC 52 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 B8 01 00 00 00 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 108
		refs = "0010 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 0015 ___security_cookie 0055 __CallSettingFrame@12"
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 E4 00 00 00 00 C7 45 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D E4 33 C1 89 45 EC 8B 55 0C 89 55 F0 8B 45 08 89 45 F4 8B 4D 14 83 C1 01 89 4D F8 64 A1 00 00 00 00 89 45 E4 8D 45 E4 64 A3 00 00 00 00 8B 55 18 52 8B 45 08 50 8B 4D 10 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 E4 64 A3 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 234
		refs = "0011 $ExceptionContinuation$6 002e ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 0033 ___security_cookie 0098 __getptd"
	strings:
		$1 = { 55 8B EC 83 EC 38 53 81 7D 08 23 01 00 00 75 14 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 B8 01 00 00 00 E9 C1 00 00 00 C7 45 C8 00 00 00 00 C7 45 CC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D C8 33 C1 89 45 D0 8B 55 18 89 55 D4 8B 45 0C 89 45 D8 8B 4D 1C 89 4D DC 8B 55 20 89 55 E0 C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 EC 00 00 00 00 89 65 E4 89 6D E8 64 A1 00 00 00 00 89 45 C8 8D 45 C8 64 A3 00 00 00 00 C7 45 FC 01 00 00 00 8B 45 08 89 45 F0 8B 4D 10 89 4D F4 E8 ?? ?? ?? ?? 8B 90 80 00 00 00 89 55 F8 8D 45 F0 50 8B 4D 08 8B 11 52 FF 55 F8 83 C4 08 C7 45 FC 00 00 00 00 83 7D EC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D C8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 C8 64 A3 00 00 00 00 8B 45 FC 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_7_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 136
		refs = "002a ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 4D 08 53 8B 41 10 56 8B 71 0C 57 8B 7D 0C 89 45 F8 8B DE 89 75 FC 85 FF 78 3E 8B 4D 10 83 FE FF 75 08 E8 ?? ?? ?? ?? 8B 4D 10 8B 55 F8 4E 8D 04 B6 39 4C 82 04 8B 55 FC 7D 0C 8B 55 F8 3B 4C 82 08 8B 55 FC 7E 05 83 FE FF 75 06 4F 8B DA 89 75 FC 85 FF 79 C8 8B 4D 08 8B 45 14 46 89 30 8B 45 18 89 18 3B 59 0C 77 04 3B F3 76 05 E8 ?? ?? ?? ?? 8B 4D F8 5F 8D 04 B6 5E 8D 04 81 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_8_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 50
	strings:
		$1 = { 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 6D FC 8B 63 FC FF E0 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_4_9_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 89
		refs = "0016 $ReturnPoint$3 002a __imp__RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 64 8B 35 00 00 00 00 89 75 F8 C7 45 FC ?? ?? ?? ?? 6A 00 8B 45 0C 50 8B 4D FC 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 8B 45 0C 8B 48 04 83 E1 FD 8B 55 0C 89 4A 04 64 8B 3D 00 00 00 00 8B 5D F8 89 3B 64 89 1D 00 00 00 00 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_4_10_0 {
	meta:
		name = "__CreateFrameInfo"
		size = 42
		refs = "000d __getptd"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 56 8B 75 08 89 0E E8 ?? ?? ?? ?? 8B 88 98 00 00 00 89 4E 04 E8 ?? ?? ?? ?? 89 B0 98 00 00 00 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_4_11_0 {
	meta:
		name = "__FindAndUnlinkFrame"
		size = 85
		refs = "0005 __getptd 0048 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 3B B0 98 00 00 00 75 11 E8 ?? ?? ?? ?? 8B 4E 04 89 88 98 00 00 00 5E 5D C3 E8 ?? ?? ?? ?? 8B 88 98 00 00 00 83 79 04 00 74 0F 8B 41 04 3B F0 74 0F 8B C8 83 79 04 00 75 F1 5E 5D E9 ?? ?? ?? ?? 8B 46 04 89 41 04 5E 5D C3 }
	condition:
		$1
}

rule file_4_12_0 {
	meta:
		name = "__IsExceptionObjectToBeDestroyed"
		size = 43
		refs = "0004 __getptd"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 80 98 00 00 00 85 C0 74 0E 8B 4D 08 39 08 74 0E 8B 40 04 85 C0 75 F5 B8 01 00 00 00 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_4_13_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 60
		refs = "0028 ___InternalCxxFrameHandler"
		altNames = "___CxxFrameHandler2 ___CxxFrameHandler3"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 FC 6A 00 6A 00 6A 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 5F 5E 5B 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_16_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 47
		refs = "0024 ___FrameUnwindToState"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 48 1C 51 BA 04 00 00 00 6B D2 00 8B 45 08 8B 4C 10 28 51 6A 00 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 10 5D C2 04 00 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__stat64i32"
		size = 84
		refs = "001c ___copy_path_to_wide_string 0035 __wstat64i32 0046 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 74 19 8D 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 83 C8 FF EB 24 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_967_0_0 {
	meta:
		name = "__chmod"
		size = 84
		refs = "001c ___copy_path_to_wide_string 0035 __wchmod 0046 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 74 19 8D 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 83 C8 FF EB 24 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_1083_0_0 {
	meta:
		name = "__stat32"
		size = 84
		refs = "001c ___copy_path_to_wide_string 0035 __wstat32 0046 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 74 19 8D 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 83 C8 FF EB 24 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_649_0_0 {
	meta:
		name = "__stat32i64"
		size = 84
		refs = "001c ___copy_path_to_wide_string 0035 __wstat32i64 0046 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 74 19 8D 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 83 C8 FF EB 24 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_1183_0_0 {
	meta:
		name = "__stat64"
		size = 84
		refs = "001c ___copy_path_to_wide_string 0035 __wstat64 0046 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 74 19 8D 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 83 C8 FF EB 24 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__vwprintf_l"
		size = 30
		refs = "0010 __woutput_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "__vprintf_l"
		size = 30
		refs = "0010 __output_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_2_0 {
	meta:
		name = "__vprintf_p_l"
		size = 30
		refs = "0010 __output_p_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_3_0 {
	meta:
		name = "__vprintf_s_l"
		size = 30
		refs = "0010 __output_s_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_788_2_0 {
	meta:
		name = "__vscprintf_l"
		size = 30
		refs = "0010 __output_l 0015 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_788_4_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 30
		refs = "0010 __output_p_l 0015 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_140_3_0 {
	meta:
		name = "__vscwprintf_l"
		size = 30
		refs = "0010 __woutput_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_140_5_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 30
		refs = "0010 __woutput_p_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_2_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 30
		refs = "0010 __woutput_p_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_3_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 30
		refs = "0010 __woutput_s_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "__vwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_1_0 {
	meta:
		name = "__vprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_788_0_0 {
	meta:
		name = "__vscprintf"
		size = 28
		refs = "000e __output_l 0013 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_788_3_0 {
	meta:
		name = "__vscprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_140_1_0 {
	meta:
		name = "__vscwprintf"
		size = 28
		refs = "000e __woutput_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "__vscwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_4_0 {
	meta:
		name = "_vprintf"
		size = 28
		refs = "000e __output_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_353_6_0 {
	meta:
		name = "_vprintf_s"
		size = 28
		refs = "000e __output_s_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_4_0 {
	meta:
		name = "_vwprintf"
		size = 28
		refs = "000e __woutput_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_6_0 {
	meta:
		name = "_vwprintf_s"
		size = 28
		refs = "000e __woutput_s_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_7_5_0 {
	meta:
		name = "_vwprintf_helper"
		size = 307
		refs = "0006 __sehtable$_vwprintf_helper 000b __except_handler4 001d ___security_cookie 0031 ___iob_func 0065 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 006a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0073 ??_C@_1GE@HBOOEGHP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 007a __CrtDbgReportW 008e __errno 00a2 ??_C@_1CA@KIPAKOJP@?$AAv?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 00ac __invalid_parameter 00bd __lock_file 00d0 __stbuf 00fc __ftbuf 0116 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? B9 20 00 00 00 C1 E1 00 03 C1 89 45 E4 83 7D 0C 00 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 69 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 E4 50 FF 55 08 83 C4 10 89 45 D4 8B 4D E4 51 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__fullpath"
		size = 31
		refs = "0016 __fullpath_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "__dupenv_s"
		size = 31
		refs = "0016 __dupenv_s_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_164_2_0 {
	meta:
		name = "__getdcwd"
		size = 31
		refs = "0016 __getdcwd_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_706_1_0 {
	meta:
		name = "__wdupenv_s"
		size = 31
		refs = "0016 __wdupenv_s_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__wfullpath"
		size = 31
		refs = "0016 __wfullpath_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_115_2_0 {
	meta:
		name = "__wgetdcwd"
		size = 31
		refs = "0016 __wgetdcwd_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "__fullpath_dbg"
		size = 457
		refs = "001f __getcwd 0041 __imp__GetFullPathNameA@16 0050 __imp__GetLastError@0 0056 __dosmaperr 0087 __errno 00ab __calloc_dbg 00f5 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00fa ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0106 ??_C@_1GE@EJNCNJPK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 010d __CrtDbgReportW 0138 ??_C@_1BM@BMDEPKPP@?$AA_?$AAf?$AAu?$AAl?$AAl?$AAp?$AAa?$AAt?$AAh?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0142 __invalid_parameter 017f _free"
	strings:
		$1 = { 55 8B EC 83 EC 18 83 7D 0C 00 74 0A 8B 45 0C 0F BE 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 9A 01 00 00 83 7D 08 00 0F 85 9D 00 00 00 6A 00 6A 00 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 61 01 00 00 8B 55 10 3B 55 FC 76 08 8B 45 10 89 45 F4 EB 06 8B 4D FC 89 4D F4 8B 55 F4 89 55 10 83 7D 10 FF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 2D 01 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 6A 01 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 F8 00 00 00 E9 81 00 00 00 83 7D 10 00 76 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 89 4D EC 83 7D EC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 78 8B 45 08 89 45 F8 8D 4D E8 51 8B 55 F8 52 8B 45 10 50 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 3B 55 10 72 23 83 7D 08 00 75 0C 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 30 EB 2B 83 7D FC 00 75 25 83 7D 08 00 75 0C 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__frnd"
		size = 21
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 08 D9 FC DD 5D F8 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "__ftime64"
		size = 17
		refs = "0008 __ftime64_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_60_665_2 {
	meta:
		name = "??2_AllocBase@details@Concurrency@@SAPAXI@Z"
		size = 17
		refs = "0008 ?Alloc@Concurrency@@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_857_0_6 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1105_0_0 {
	meta:
		name = "??3@YAXPAXHPBDH@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_578_18_0 {
	meta:
		name = "??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_8_668_1 {
	meta:
		name = "??3_AllocBase@details@Concurrency@@SAXPAX@Z"
		size = 17
		refs = "0008 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_37_159_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAX@Z"
		size = 17
		refs = "0008 ??$_DebugHeapDelete@Vfacet@locale@std@@@std@@YAXPAVfacet@locale@0@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_97_158_3 {
	meta:
		name = "??3facet@locale@std@@SAXPAXABU_DebugHeapTag_t@2@PADH@Z"
		size = 17
		refs = "0008 ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_10_0_2 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 17
		refs = "0008 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "??_V@YAXPAX@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1883_0_6 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1105_1_0 {
	meta:
		name = "??_V@YAXPAXHPBDH@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_41_60_0 {
	meta:
		name = "??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_715_14_0 {
	meta:
		name = "?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
		size = 17
		refs = "0008 ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_755_58_0 {
	meta:
		name = "?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
		size = 17
		refs = "0008 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_749_443_0 {
	meta:
		name = "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 17
		refs = "0008 ?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_41_253_0 {
	meta:
		name = "?set_task_execution_resources@Concurrency@@YAXK@Z"
		size = 17
		refs = "0008 ?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_63_0_1 {
	meta:
		name = "__LDtest"
		size = 17
		refs = "0008 __Dtest"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_650_6_0 {
	meta:
		name = "___free_locale"
		size = 17
		refs = "0008 __free_locale"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_232_27_0 {
	meta:
		name = "__aligned_free"
		size = 17
		refs = "0008 __aligned_free_dbg"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "__ftime32"
		size = 17
		refs = "0008 __ftime32_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_291_6_0 {
	meta:
		name = "__inc"
		size = 17
		refs = "0008 __fgetwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_811_0_0 {
	meta:
		name = "__unlink"
		size = 17
		refs = "0008 _remove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "__wtoi"
		size = 17
		refs = "0008 __wtol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_452_1_0 {
	meta:
		name = "__wunlink"
		size = 17
		refs = "0008 __wremove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_765_4_0 {
	meta:
		name = "_atoi"
		size = 17
		refs = "0008 _atol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "_clearerr"
		size = 17
		refs = "0008 _clearerr_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_733_2_0 {
	meta:
		name = "_getwc"
		size = 17
		refs = "0008 _fgetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_701_1_0 {
	meta:
		name = "_putchar"
		size = 17
		refs = "0008 __fputchar"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "__ftime64_s"
		size = 549
		refs = "000a ___security_cookie 004f ??_C@_1BO@BCOPJGHK@?$AA?$CI?$AA?5?$AAt?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0054 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005d ??_C@_1GC@IFLFPLPB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0064 __CrtDbgReportW 007b __errno 008f ??_C@_1BG@OMGGMME@?$AA_?$AAf?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAs?$AA?$AA@ 0099 __invalid_parameter 00ab ___tzset 00be ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 00ca __get_timezone 00d3 __invoke_watson_if_error 00f8 __imp__GetSystemTimeAsFileTime@4 0112 __aulldiv 012a _elapsed_minutes_cache 0147 __imp__GetTimeZoneInformation@4 0173 _dstflag_cache 01dd __aullrem 021d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC D0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 30 FF FF FF 00 00 00 00 83 7D 08 00 74 0C C7 85 34 FF FF FF 01 00 00 00 EB 0A C7 85 34 FF FF FF 00 00 00 00 8B 85 34 FF FF FF 89 85 40 FF FF FF 83 BD 40 FF FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 40 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6D 01 00 00 E8 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 85 30 FF FF FF 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 0A 8D 85 48 FF FF FF 50 FF 15 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 8D 4C FF FF FF 51 8B 95 48 FF FF FF 52 E8 ?? ?? ?? ?? 89 85 38 FF FF FF 89 95 3C FF FF FF 8B 85 38 FF FF FF 3B 05 ?? ?? ?? ?? 75 0E 8B 8D 3C FF FF FF 3B 0D ?? ?? ?? ?? 74 6D 8D 95 50 FF FF FF 52 FF 15 ?? ?? ?? ?? 89 85 44 FF FF FF 83 BD 44 FF FF FF FF 74 2F 83 BD 44 FF FF FF 02 75 1A 0F B7 45 EA 85 C0 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 8B 8D 38 FF FF FF 89 0D ?? ?? ?? ?? 8B 95 3C FF FF FF 89 15 ?? ?? ?? ?? 8B 45 08 66 8B 0D ?? ?? ?? ?? 66 89 48 0C 6A 00 68 10 27 00 00 8B 95 4C FF FF FF 52 8B 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 4D 08 66 89 41 08 8B 95 48 FF FF FF 81 EA 00 80 3E D5 8B 85 4C FF FF FF 1D DE B1 9D 01 6A 00 68 80 96 98 00 50 52 E8 ?? ?? ?? ?? 8B 4D 08 89 01 89 51 04 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_2_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 38
		refs = "0020 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 EB 19 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_8_234_1 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_8_236_1 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_77_238_3 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_102_9_3 {
	meta:
		name = "__Cnd_wait"
		size = 23
		refs = "000e ?do_wait@@YAHPAPAU_Cnd_internal_imp_t@@PAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 23
		refs = "000e __aligned_offset_malloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_435_3_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e __atodbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_435_5_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e __atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_435_7_0 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1041_2_0 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_305_3_0 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_124_3_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_695_3_0 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_425_3_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_866_3_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_214_3_0 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_775_3_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_985_3_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_950_3_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_809_5_0 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_490_3_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_431_3_0 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_668_3_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_527_3_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_412_3_0 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_559_3_0 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_818_3_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_897_0_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_825_3_0 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_647_5_0 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_234_8_0 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_8_0 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_437_8_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1068_8_0 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_724_2_0 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_914_4_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e __strtod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_639_4_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e __wcstod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_13_4_0 {
	meta:
		name = "__mbsspnp_l"
		size = 684
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002c _strspn 005f ??1_LocaleUpdate@@QAE@XZ 008e ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0093 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 009c ??_C@_1GA@HAFFGCEC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00a3 __CrtDbgReportW 00b7 __errno 00cb ??_C@_1BG@DIADCNPB@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAp?$AAn?$AAp?$AA_?$AAl?$AA?$AA@ 00d5 __invalid_parameter 0116 ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 44 8B 45 10 50 8D 4D BC E8 ?? ?? ?? ?? 8D 4D BC E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 48 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 4D 08 03 4D F4 0F B6 11 85 D2 74 0B 8B 45 08 03 45 F4 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 89 4D D8 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D8 E9 3D 02 00 00 83 7D 08 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D4 E9 B5 01 00 00 83 7D 0C 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 00 00 00 00 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D0 E9 2D 01 00 00 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 0F 84 E4 00 00 00 8B 4D 0C 89 4D F8 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 0F 84 84 00 00 00 8D 4D BC E8 ?? ?? ?? ?? 8B 50 04 8B 45 F8 0F B6 08 0F B6 54 0A 19 83 E2 04 74 52 8B 45 F8 0F B6 08 8B 55 FC 0F B6 02 3B C8 75 22 B9 01 00 00 00 C1 E1 00 8B 55 F8 0F B6 04 0A B9 01 00 00 00 C1 E1 00 8B 55 FC 0F B6 0C 0A 3B C1 74 13 BA 01 00 00 00 C1 E2 00 8B 45 F8 0F B6 0C 10 85 C9 75 02 EB 22 8B 55 F8 83 C2 01 89 55 F8 EB 12 8B 45 F8 0F B6 08 8B 55 FC 0F B6 02 3B C8 75 02 EB 05 E9 65 FF FF FF 8B 4D F8 0F B6 11 85 D2 75 02 EB 35 8D 4D BC E8 ?? ?? ?? ?? 8B 40 04 8B 4D FC 0F B6 11 0F B6 44 10 19 83 E0 04 74 15 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 75 02 EB 05 E9 05 FF FF FF 8B 4D FC 0F B6 11 85 D2 74 08 8B 45 FC 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D CC 8D 4D BC E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "___common_satan2_cout_rare"
		size = 4192
		refs = "0104 __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 45 08 8B 4D 0C F3 0F 10 18 F3 0F 10 11 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 18 F2 0F 11 4C 24 20 0F B6 78 03 0F B7 40 02 25 80 7F 00 00 0F B6 71 03 0F B7 4C 24 1E 81 E6 80 00 00 00 0F B7 5C 24 26 81 E1 F0 7F 00 00 81 E3 F0 7F 00 00 C1 E8 07 C1 EF 07 C1 EE 07 C1 E9 04 C1 EB 04 3D FF 00 00 00 0F 84 91 0E 00 00 8B 55 0C 0F B7 52 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 78 0E 00 00 85 C9 75 0F 8B 45 08 F7 00 FF FF 7F 00 0F 84 D5 0D 00 00 85 DB 75 0F 8B 45 0C F7 00 FF FF 7F 00 0F 84 7D 0D 00 00 F7 DB F2 0F 11 44 24 20 03 D9 F2 0F 11 4C 24 28 0F B6 44 24 27 0F B6 54 24 2F 83 E0 7F 83 E2 7F 89 44 24 1C 83 FB CA 89 54 24 18 0F 8E 6F 0C 00 00 83 FB 36 0F 8D 16 0C 00 00 8B C2 85 F6 8B 54 24 1C 88 44 24 2F 88 54 24 27 75 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 54 24 18 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 44 24 18 F2 0F 10 5C 24 20 85 C9 F2 0F 10 44 24 28 0F 28 E3 F2 0F 5E E0 0F B7 44 24 26 F2 0F 11 64 24 50 0F 8E 9E 0D 00 00 81 F9 FE 07 00 00 7D 1D 25 0F 80 FF FF 81 C1 01 FC FF FF F2 0F 11 5C 24 20 0D F0 3F FF FF 66 89 44 24 26 EB 17 F2 0F 10 0D ?? ?? ?? ?? B9 FE 03 00 00 F2 0F 59 D9 F2 0F 11 5C 24 20 F7 D9 81 C1 FF 03 00 00 81 E1 FF 07 00 00 0F B7 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 25 0F 80 FF FF C1 E1 04 F2 0F 11 4C 24 28 0B C1 66 89 44 24 2E F2 0F 10 5C 24 28 F2 0F 59 C3 66 0F 2F 25 ?? ?? ?? ?? 0F 82 19 07 00 00 F2 0F 10 2D ?? ?? ?? ?? 0F 28 F8 F2 0F 59 FD 0F 28 F0 F2 0F 11 3C 24 B9 71 00 00 00 F2 0F 11 54 24 38 F2 0F 10 14 24 F2 0F 11 64 24 40 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 64 24 08 0F B7 44 24 56 F2 0F 5C DC F2 0F 11 1C 24 25 F0 7F 00 00 F2 0F 11 4C 24 48 F2 0F 10 0C 24 C1 E8 04 F2 0F 5C F1 8B 54 24 54 C1 E0 14 81 E2 FF FF 0F 00 8B 5C 24 44 0B C2 8B D3 81 E3 00 00 08 00 81 E2 00 00 F0 FF 81 CB 00 00 04 00 0B D3 05 00 00 40 C0 C7 44 24 40 00 00 00 00 89 54 24 44 F2 0F 11 74 24 08 F2 0F 10 0C 24 F2 0F 10 54 24 40 F2 0F 10 74 24 08 F2 0F 59 CA F2 0F 59 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 F7 0F 28 E1 C1 F8 13 F2 0F 58 E6 F2 0F 11 24 24 83 F8 71 F2 0F 10 1C 24 0F 4D C1 F2 0F 5C CB C1 E0 04 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 20 F2 0F 10 24 24 0F 28 F9 F2 0F 10 74 24 08 F2 0F 58 FC F2 0F 11 3C 24 0F 28 F9 F2 0F 10 1C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 5C 24 08 F2 0F 58 FB F2 0F 11 7C 24 10 0F 28 F9 F2 0F 10 5C 24 08 F2 0F 58 E3 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C FC F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 58 DC F2 0F 11 5C 24 10 F2 0F 10 1C 24 F2 0F 10 64 24 10 F2 0F 58 E6 0F 28 F3 F2 0F 59 F5 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 0F 28 F9 F2 0F 10 34 24 F2 0F 59 3D ?? ?? ?? ?? F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 1C 24 F2 0F 10 74 24 08 F2 0F 11 3C 24 F2 0F 58 E6 F2 0F 10 34 24 F2 0F 5C 74 24 20 F2 0F 11 74 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 59 F2 F2 0F 59 FA 0F 28 D6 F2 0F 58 D7 F2 0F 11 14 24 F2 0F 10 14 24 F2 0F 5C F2 0F 28 D0 F2 0F 58 F7 F2 0F 11 74 24 08 0F 28 F0 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 F1 F2 0F 11 34 24 F2 0F 10 34 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 74 24 08 F2 0F 58 D6 F2 0F 11 54 24 10 F2 0F 10 74 24 08 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 10 F2 0F 5C C1 F2 0F 11 44 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 58 F0 F2 0F 11 74 24 10 F2 0F 10 34 24 F2 0F 10 44 24 10 F2 0F 58 C7 0F 28 FE F2 0F 59 FD F2 0F 11 3C 24 F2 0F 10 14 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 10 54 24 48 F2 0F 5C CF F2 0F 11 0C 24 F2 0F 10 3C 24 F2 0F 5C F7 F2 0F 11 74 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 58 C6 0F 28 F2 F2 0F 5E F7 0F 28 CE F2 0F 59 CD F2 0F 11 4C 24 08 F2 0F 10 4C 24 08 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 59 FE F2 0F 5C D7 F2 0F 10 7C 24 10 F2 0F 59 C7 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 10 7C 24 10 F2 0F 10 44 24 08 F2 0F 10 74 24 10 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C7 F2 0F 59 C3 F2 0F 59 CE 0F 28 D1 F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E7 F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D4 F2 0F 11 14 24 0F 28 E0 F2 0F 10 34 24 F2 0F 58 E6 F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C6 F2 0F 11 44 24 08 F2 0F 10 1C 24 0F 28 D3 0F 28 CB F2 0F 59 D3 F2 0F 59 CD F2 0F 59 FA F2 0F 10 44 24 08 F2 0F 11 0C 24 F2 0F 10 34 24 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 FA F2 0F 11 74 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D7 F2 0F 10 3C 24 F2 0F 10 64 24 08 F2 0F 59 EA F2 0F 5C FC F2 0F 11 3C 24 F2 0F 10 34 24 F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 58 C3 F2 0F 10 2C 24 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 5C D1 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 0F 28 F2 0F 28 FB F2 0F 59 F8 F2 0F 59 D0 F2 0F 59 DC F2 0F 59 F4 F2 0F 58 FA 0F 28 CE 0F 28 D6 F2 0F 58 FB F2 0F 58 CC F2 0F 11 3C 24 F2 0F 10 3C 24 F2 0F 11 0C 24 F2 0F 10 2C 24 F2 0F 5C D5 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 6C 24 08 F2 0F 10 98 ?? ?? ?? ?? F2 0F 58 E5 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C F4 F2 0F 11 74 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 34 24 F2 0F 10 54 24 10 0F 28 EE F2 0F 58 DE F2 0F 58 C2 F2 0F 11 1C 24 F2 0F 58 C7 F2 0F 10 24 24 F2 0F 11 44 24 30 F2 0F 5C EC F2 0F 11 6C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 CF F2 0F 11 4C 24 10 F2 0F 10 54 24 08 F2 0F 58 90 ?? ?? ?? ?? F2 0F 11 54 24 08 F2 0F 10 5C 24 10 F2 0F 10 54 24 38 F2 0F 5C F3 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 64 24 10 F2 0F 58 EC F2 0F 11 6C 24 10 F2 0F 10 34 24 F2 0F 10 7C 24 10 F2 0F 11 74 24 28 F2 0F 58 C7 0F B6 54 24 2F 0F 28 CA 83 E2 7F F2 0F 58 80 ?? ?? ?? ?? 8B C6 C1 E0 07 0B D0 88 54 24 2F F2 0F 11 44 24 30 F2 0F 10 44 24 28 0F 28 E0 F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 1C 24 0F B6 4C 24 37 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C E3 F2 0F 11 64 24 08 F2 0F 10 34 24 F2 0F 10 6C 24 08 C1 E6 07 F2 0F 58 F5 F2 0F 11 74 24 10 0B DE F2 0F 10 7C 24 08 88 5C 24 37 F2 0F 58 D7 F2 0F 11 54 24 08 F2 0F 10 54 24 10 C1 E7 07 F2 0F 5C C2 F2 0F 11 44 24 10 F2 0F 10 4C 24 08 F2 0F 10 44 24 10 8B 75 10 F2 0F 58 C8 F2 0F 11 4C 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 11 64 24 28 F2 0F 58 5C 24 30 F2 0F 58 5C 24 18 F2 0F 58 E3 F2 0F 11 64 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 54 24 40 F3 0F 11 16 E9 F3 05 00 00 F2 0F 10 7C 24 20 8B C6 0F 28 E7 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 11 54 24 38 F2 0F 10 25 ?? ?? ?? ?? C1 E0 07 F2 0F 5C 5C 24 20 F2 0F 11 5C 24 08 F2 0F 10 2C 24 F2 0F 10 54 24 08 C1 E7 07 F2 0F 5C EA F2 0F 11 2C 24 0F 28 E8 F2 0F 10 34 24 F2 0F 59 EC F2 0F 5C FE F2 0F 11 7C 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C F0 F2 0F 11 74 24 08 F2 0F 10 2C 24 F2 0F 10 7C 24 08 F2 0F 5C EF F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C C6 F2 0F 11 44 24 08 0F 28 C1 F2 0F 10 2C 24 F2 0F 5E C5 0F 28 F0 F2 0F 59 F4 F2 0F 10 7C 24 08 F2 0F 11 74 24 08 F2 0F 10 74 24 08 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 44 24 10 F2 0F 59 E8 F2 0F 5C CD F2 0F 10 6C 24 10 F2 0F 59 FD F2 0F 11 7C 24 08 F2 0F 10 7C 24 08 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 6C 24 08 F2 0F 10 74 24 10 F2 0F 10 4C 24 08 0F 28 C6 F2 0F 59 C2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 E9 F2 0F 10 4C 24 10 F2 0F 59 E9 0F 28 FD F2 0F 59 FB F2 0F 59 D5 F2 0F 58 FA 0F 28 D0 F2 0F 58 FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 44 24 50 F2 0F 59 C0 F2 0F 59 C8 F2 0F 10 3C 24 0F 28 EF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EC F2 0F 59 C8 F2 0F 10 54 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F7 F2 0F 59 C8 F2 0F 11 74 24 08 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 04 24 F2 0F 10 5C 24 08 F2 0F 59 E1 F2 0F 5C C3 F2 0F 11 04 24 F2 0F 10 2C 24 F2 0F 5C FD F2 0F 11 7C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 11 24 24 F2 0F 58 D7 F2 0F 10 24 24 F2 0F 5C E1 F2 0F 11 64 24 08 F2 0F 10 2C 24 F2 0F 10 44 24 08 F2 0F 5C E8 F2 0F 11 2C 24 F2 0F 10 1C 24 F2 0F 5C CB F2 0F 11 4C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 0F 28 E9 0F 28 C7 F2 0F 59 C2 F2 0F 59 CA F2 0F 59 FE F2 0F 59 EE F2 0F 58 C1 0F 28 CD 0F 28 DD F2 0F 58 C7 F2 0F 58 CE F2 0F 11 04 24 F2 0F 10 04 24 F2 0F 11 0C 24 F2 0F 10 24 24 F2 0F 5C DC F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 4C 24 08 F2 0F 58 E1 F2 0F 11 64 24 10 F2 0F 10 7C 24 08 F2 0F 58 F7 F2 0F 11 74 24 08 F2 0F 10 74 24 10 F2 0F 5C EE F2 0F 10 74 24 38 F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 F2 0F 10 4C 24 10 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 24 24 F2 0F 10 6C 24 10 F2 0F 11 64 24 28 F2 0F 58 D5 0F B6 54 24 2F F2 0F 58 D0 83 E2 7F 0B D0 88 54 24 2F F2 0F 11 54 24 30 0F 28 D6 F2 0F 10 4C 24 28 0F 28 C1 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 14 24 0F B6 4C 24 37 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C C2 F2 0F 11 44 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 C1 E6 07 F2 0F 58 E3 F2 0F 11 64 24 10 0B DE F2 0F 10 6C 24 08 88 5C 24 37 F2 0F 58 F5 F2 0F 11 74 24 08 F2 0F 10 7C 24 10 8B 75 10 F2 0F 5C CF F2 0F 11 4C 24 10 F2 0F 10 44 24 08 F2 0F 10 4C 24 10 F2 0F 58 C1 F2 0F 11 44 24 10 F2 0F 10 1C 24 F2 0F 10 54 24 10 F2 0F 11 5C 24 28 F2 0F 58 54 24 30 F2 0F 58 54 24 18 F2 0F 58 DA F2 0F 11 5C 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 F3 0F 11 0E E9 DA 01 00 00 83 FB 4A 0F 8D 33 01 00 00 88 44 24 27 F2 0F 5E 4C 24 20 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 5C C1 8B 4D 10 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 0F B6 54 24 47 83 E2 7F 0B D7 88 54 24 47 F2 0F 5A 4C 24 40 F3 0F 11 09 E9 8A 01 00 00 85 F6 0F 85 4E 01 00 00 8B D0 8B 44 24 18 88 54 24 27 88 44 24 2F F2 0F 10 54 24 20 F2 0F 5E 54 24 28 F2 0F 5A C2 F3 0F 11 44 24 58 0F B7 4C 24 5A F7 C1 80 7F 00 00 F2 0F 11 54 24 40 74 43 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 C2 F2 0F 11 04 24 F2 0F 10 0C 24 F2 0F 59 D1 F2 0F 11 54 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 54 24 40 8B 55 10 F3 0F 11 12 E9 08 01 00 00 F2 0F 5A 44 24 40 F3 0F 11 44 24 58 F3 0F 10 54 24 58 F3 0F 10 4C 24 58 F3 0F 59 D1 F3 0F 11 54 24 58 F3 0F 10 5C 24 58 F3 0F 5A DB C1 E7 07 F2 0F 58 5C 24 40 F2 0F 11 5C 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 64 24 40 8B 55 10 F3 0F 11 22 E9 AD 00 00 00 85 C9 75 0B 8B 45 08 F7 00 FF FF 7F 00 74 36 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A EB 68 85 F6 75 30 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 40 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A EB 34 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? B9 02 FC FF FF F2 0F 59 D9 F2 0F 11 5C 24 20 E9 82 F2 FF FF 81 F9 FF 07 00 00 0F 84 31 01 00 00 81 FB FF 07 00 00 0F 84 06 01 00 00 8B 55 0C 0F B7 4A 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 74 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A E9 72 FF FF FF 3D FF 00 00 00 74 3B 85 F6 0F 85 2F FF FF FF 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 40 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A E9 30 FF FF FF 85 F6 75 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 0F B6 44 24 47 83 E0 7F 0B C7 88 44 24 47 F2 0F 5A 4C 24 40 8B 55 10 F3 0F 11 0A E9 F3 FE FF FF F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__ftol"
		size = 39
	strings:
		$1 = { 55 8B EC 83 C4 F4 9B D9 7D FE 9B 66 8B 45 FE 80 CC 0C 66 89 45 FC D9 6D FC DF 7D F4 D9 6D FE 8B 45 F4 8B 55 F8 C9 C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___avx_cosh4"
		size = 544
		refs = "0010 ___common_dcosh_data 0208 ___common_dcosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 11 44 24 20 C5 FD 11 54 24 40 C5 E5 55 E8 C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 74 24 40 C5 C1 73 D3 0B C4 E3 7D 19 D9 01 C5 D9 73 D1 0B C5 FA 7F 64 24 60 C5 FA 7F 7C 24 10 C5 F8 10 0D ?? ?? ?? ?? C4 E3 7D 19 EA 01 C4 E3 7D 19 F4 01 C5 D0 C6 DA DD C5 C8 C6 C4 88 C5 D9 73 F4 2C C5 E1 66 3D ?? ?? ?? ?? C5 F9 DB 15 ?? ?? ?? ?? C5 F8 50 C7 C5 C1 72 F2 03 C5 F9 7E FA C5 F1 FA DA C5 E1 72 F3 03 C4 E3 79 16 F9 01 C5 FB 10 82 ?? ?? ?? ?? C4 E3 79 16 FA 02 C5 F9 16 91 ?? ?? ?? ?? C4 E3 79 16 F9 03 C5 FB 10 8A ?? ?? ?? ?? C5 F9 7E DA C5 F1 16 89 ?? ?? ?? ?? C4 E3 79 16 D9 01 C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 DA 02 C5 C1 16 B9 ?? ?? ?? ?? C4 E3 79 16 D9 03 C5 FB 10 82 ?? ?? ?? ?? C5 F9 11 7C 24 70 C5 F9 16 99 ?? ?? ?? ?? C5 CD 5C 44 24 40 C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C EF C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C C7 C5 C1 73 F6 2C C5 F9 10 35 ?? ?? ?? ?? C5 C1 DB FE C5 D9 DB E6 C5 E9 D4 F7 C5 E1 FB DC C5 F1 D4 CC C5 E1 FB 64 24 60 C5 FD 59 E8 C5 F9 10 54 24 70 C5 E9 FB FF C5 C1 FB 7C 24 10 C4 E3 4D 18 C9 01 C4 E3 45 18 DC 01 C5 F5 5C FB C5 F5 58 DB C5 D5 59 0D ?? ?? ?? ?? C5 F5 59 D0 C5 ED 58 C0 C5 FD 59 D7 C5 D5 59 05 ?? ?? ?? ?? C5 FD 58 0D ?? ?? ?? ?? C5 F5 59 ED C5 D5 59 C3 C5 FD 58 CA C5 F5 58 C3 85 C0 75 04 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E5 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BB C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "___libm_sse2_asin"
		size = 1097
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 0089 _T_table 0096 _Tbl_addr 00c2 _cv 00d6 _SIGNMASK 014b _HALFMASK2 01a2 _PI_BY_2 025d _cv2 02c4 _ONE_BY_2"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 BE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 54 15 ?? ?? ?? ?? F2 0F 10 D9 F2 0F 59 C9 66 0F 12 35 ?? ?? ?? ?? 83 C4 0C F2 0F 59 D9 F2 0F 59 F9 F2 0F 59 EB 66 0F 57 E2 F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 66 0F 56 E2 F2 0F 58 C6 F2 0F 58 C4 C3 2D BB 03 00 00 83 F8 43 0F 83 18 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 8B C2 66 0F 54 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 00 00 08 00 C1 E8 04 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 83 C4 0C 66 0F C4 F0 03 F2 0F 58 C5 F2 0F 10 EC 66 0F 70 DB EE F2 0F 5C E3 F2 0F 58 DC F2 0F 5C EB F2 0F 5C C5 F2 0F 5C C4 66 0F 56 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 73 5D 66 0F 14 FF 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 F7 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 83 C4 0C 66 0F 59 FF 66 0F 59 F7 66 0F 59 CF 66 0F 59 FF F2 0F 10 DE F2 0F 59 F6 66 0F 58 CA 66 0F 59 E7 F2 0F 59 F3 66 0F 58 CC 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 C3 2D FE 3B 00 00 83 F8 02 0F 83 BB 00 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 5C D9 F2 0F 59 E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 70 FC 44 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 59 DF 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FD 66 0F 58 D3 F2 0F 59 D7 66 0F 59 D5 F2 0F 58 E4 66 0F 70 EE EE 66 0F 70 DC 44 F2 0F 5C E5 F2 0F 58 EC F2 0F 5C EB 66 0F 59 D3 F2 0F 58 EE 66 0F 57 F6 66 0F 70 C2 EE F2 0F 5C D5 83 C4 0C F2 0F 58 C2 25 00 80 00 00 35 00 80 00 00 66 0F C4 F0 03 F2 0F 58 C4 66 0F 57 C6 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 8A 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 42 83 C4 0C 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 10 F8 83 C4 0C 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1009_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_890_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_790_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_867_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1009_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_890_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_473_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1124_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_790_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_867_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "__CIcos_default"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__ftell_nolock"
		size = 1720
		refs = "0009 __chkstk 000e ___security_cookie 0049 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0057 ??_C@_1FO@NBACIADE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005e __CrtDbgReportW 0075 __errno 0089 ??_C@_1BM@EPIDANEK@?$AA_?$AAf?$AAt?$AAe?$AAl?$AAl?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0093 __invalid_parameter 00b3 __fileno 00e5 __lseek 011b ___pioinfo 0216 __lseeki64 02c0 __imp__ReadFile@20 03a2 __lookuptrailbytes 06b0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC B8 48 10 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0C C7 85 D0 EF FF FF 01 00 00 00 EB 0A C7 85 D0 EF FF FF 00 00 00 00 8B 85 D0 EF FF FF 89 85 CC EF FF FF 83 BD CC EF FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD CC EF FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 08 06 00 00 8B 55 08 89 95 F8 EF FF FF 8B 85 F8 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 F0 EF FF FF 8B 8D F8 EF FF FF 83 79 04 00 7D 0D 8B 95 F8 EF FF FF C7 42 04 00 00 00 00 6A 01 6A 00 8B 85 F0 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 EF FF FF 83 BD E4 EF FF FF 00 7D 08 83 C8 FF E9 A7 05 00 00 8B 8D F0 EF FF FF C1 F9 05 8B 95 F0 EF FF FF 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8A 4C 10 24 D0 E1 D0 F9 88 8D EF EF FF FF 8B 95 F8 EF FF FF 8B 42 0C 25 08 01 00 00 75 14 8B 8D F8 EF FF FF 8B 85 E4 EF FF FF 2B 41 04 E9 59 05 00 00 8B 95 F8 EF FF FF 8B 85 F8 EF FF FF 8B 0A 2B 48 08 89 8D E0 EF FF FF 8B 95 F8 EF FF FF 8B 42 0C 83 E0 03 0F 84 E9 02 00 00 0F BE 8D EF EF FF FF 83 F9 01 0F 85 5F 02 00 00 8B 95 F0 EF FF FF C1 FA 05 8B 85 F0 EF FF FF 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 83 7C 01 30 00 0F 84 38 02 00 00 8B 95 F8 EF FF FF 8B 85 F8 EF FF FF 8B 0A 2B 48 08 D1 E9 89 8D DC EF FF FF 8B 95 F8 EF FF FF 83 7A 04 00 75 10 8B 85 E4 EF FF FF E9 C9 04 00 00 E9 03 02 00 00 6A 00 8B 85 F0 EF FF FF C1 F8 05 8B 8D F0 EF FF FF 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 44 0A 2C 50 8B 4C 0A 28 51 8B 95 F0 EF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 C0 EF FF FF 89 95 C4 EF FF FF 8B 85 F0 EF FF FF C1 F8 05 8B 8D F0 EF FF FF 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 89 95 D4 EF FF FF 89 8D C8 EF FF FF 8B 85 C8 EF FF FF 8B 8D D4 EF FF FF 8B 95 C0 EF FF FF 3B 54 01 28 75 18 8B 85 C8 EF FF FF 8B 8D D4 EF FF FF 8B 95 C4 EF FF FF 3B 54 01 2C 74 08 83 C8 FF E9 21 04 00 00 6A 00 8D 85 D8 EF FF FF 50 68 00 10 00 00 8D 8D FC EF FF FF 51 8B 95 F0 EF FF FF C1 FA 05 8B 85 F0 EF FF FF 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 75 08 83 C8 FF E9 DA 03 00 00 6A 00 8B 85 E4 EF FF FF 50 8B 8D F0 EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 08 83 C8 FF E9 B6 03 00 00 8B 95 DC EF FF FF 3B 95 D8 EF FF FF 76 08 83 C8 FF E9 A0 03 00 00 8D 85 FC EF FF FF 89 85 F4 EF FF FF 8B 8D DC EF FF FF 89 8D BC EF FF FF 8B 95 DC EF FF FF 83 EA 01 89 95 DC EF FF FF 83 BD BC EF FF FF 00 0F 84 88 00 00 00 8B 85 D8 EF FF FF 8D 8C 05 FC EF FF FF 39 8D F4 EF FF FF 73 73 8B 95 F4 EF FF FF 0F BE 02 83 F8 0D 75 35 8B 8D D8 EF FF FF 8D 94 0D FB EF FF FF 39 95 F4 EF FF FF 73 1E 8B 85 F4 EF FF FF 0F BE 48 01 83 F9 0A 75 0F 8B 95 F4 EF FF FF 83 C2 01 89 95 F4 EF FF FF EB 1C 8B 85 F4 EF FF FF 0F B6 08 0F BE 91 ?? ?? ?? ?? 03 95 F4 EF FF FF 89 95 F4 EF FF FF 8B 85 F4 EF FF FF 83 C0 01 89 85 F4 EF FF FF E9 50 FF FF FF 8B 8D F4 EF FF FF 8D 95 FC EF FF FF 2B CA 8B C1 33 C9 03 85 C0 EF FF FF 13 8D C4 EF FF FF E9 C1 02 00 00 8B 95 F0 EF FF FF C1 FA 05 8B 85 F0 EF FF FF 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 81 E2 80 00 00 00 74 4F 8B 85 F8 EF FF FF 8B 48 08 89 8D F4 EF FF FF EB 0F 8B 95 F4 EF FF FF 83 C2 01 89 95 F4 EF FF FF 8B 85 F8 EF FF FF 8B 8D F4 EF FF FF 3B 08 73 1F 8B 95 F4 EF FF FF 0F BE 02 83 F8 0A 75 0F 8B 8D E0 EF FF FF 83 C1 01 89 8D E0 EF FF FF EB C2 EB 23 8B 95 F8 EF FF FF 8B 42 0C 25 80 00 00 00 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 24 02 00 00 83 BD E4 EF FF FF 00 75 0B 8B 85 E0 EF FF FF E9 10 02 00 00 8B 8D F8 EF FF FF 8B 51 0C 83 E2 01 0F 84 D8 01 00 00 8B 85 F8 EF FF FF 83 78 04 00 75 0F C7 85 E0 EF FF FF 00 00 00 00 E9 BD 01 00 00 8B 8D F8 EF FF FF 8B 95 F8 EF FF FF 8B 01 2B 42 08 8B 8D F8 EF FF FF 03 41 04 89 85 E8 EF FF FF 8B 95 F0 EF FF FF C1 FA 05 8B 85 F0 EF FF FF 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 81 E2 80 00 00 00 0F 84 5E 01 00 00 6A 02 6A 00 8B 85 F0 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 3B 85 E4 EF FF FF 0F 85 87 00 00 00 8B 8D F8 EF FF FF 8B 51 08 03 95 E8 EF FF FF 89 95 B8 EF FF FF 8B 85 F8 EF FF FF 8B 48 08 89 8D F4 EF FF FF EB 0F 8B 95 F4 EF FF FF 83 C2 01 89 95 F4 EF FF FF 8B 85 F4 EF FF FF 3B 85 B8 EF FF FF 73 1F 8B 8D F4 EF FF FF 0F BE 11 83 FA 0A 75 0F 8B 85 E8 EF FF FF 83 C0 01 89 85 E8 EF FF FF EB C4 8B 8D F8 EF FF FF 8B 51 0C 81 E2 00 20 00 00 74 0F 8B 85 E8 EF FF FF 83 C0 01 89 85 E8 EF FF FF E9 9E 00 00 00 6A 00 8B 8D E4 EF FF FF 51 8B 95 F0 EF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 08 83 C8 FF E9 CC 00 00 00 81 BD E8 EF FF FF 00 02 00 00 77 2A 8B 85 F8 EF FF FF 8B 48 0C 83 E1 08 74 1C 8B 95 F8 EF FF FF 8B 42 0C 25 00 04 00 00 75 0C C7 85 E8 EF FF FF 00 02 00 00 EB 0F 8B 8D F8 EF FF FF 8B 51 18 89 95 E8 EF FF FF 8B 85 F0 EF FF FF C1 F8 05 8B 8D F0 EF FF FF 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 04 74 0F 8B 8D E8 EF FF FF 83 C1 01 89 8D E8 EF FF FF 0F BE 95 EF EF FF FF 83 FA 01 75 0E 8B 85 E8 EF FF FF D1 E8 89 85 E8 EF FF FF 8B 8D E4 EF FF FF 2B 8D E8 EF FF FF 89 8D E4 EF FF FF 0F BE 95 EF EF FF FF 83 FA 01 75 0E 8B 85 E0 EF FF FF D1 E8 89 85 E0 EF FF FF 8B 85 E4 EF FF FF 03 85 E0 EF FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "_ftell"
		size = 248
		refs = "0006 __sehtable$_ftell 000b __except_handler4 001d ___security_cookie 0053 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0061 ??_C@_1FO@NBACIADE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0068 __CrtDbgReportW 007c __errno 0090 ??_C@_1M@CKCKPMNP@?$AAf?$AAt?$AAe?$AAl?$AAl?$AA?$AA@ 009a __invalid_parameter 00ab __lock_file 00be __ftell_nolock 00db __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 40 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__chsize"
		size = 56
		refs = "0011 __chsize_s"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 99 52 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 75 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "__chsize_nolock"
		size = 677
		refs = "0027 __lseeki64_nolock 0063 __errno 009f __imp__GetProcessHeap@0 00a6 __imp__HeapAlloc@12 00e2 __setmode_nolock 013f __write_nolock 0150 ___doserrno 01c0 __imp__HeapFree@12 020b __get_osfhandle 0215 __imp__SetEndOfFile@4 0256 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 44 56 C7 45 D4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 6A 01 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C4 89 55 C8 8B 4D C4 23 4D C8 83 F9 FF 74 23 6A 02 6A 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 89 55 D0 8B 45 CC 23 45 D0 83 F8 FF 75 0C E8 ?? ?? ?? ?? 8B 00 E9 32 02 00 00 8B 4D 0C 2B 4D CC 8B 55 10 1B 55 D0 89 4D DC 89 55 E0 83 7D E0 00 0F 8C 3F 01 00 00 7F 0A 83 7D DC 00 0F 86 33 01 00 00 68 00 10 00 00 6A 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 25 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 45 F4 0C 00 00 00 C7 45 D4 FF FF FF FF C7 45 D8 FF FF FF FF E9 EC 00 00 00 68 00 80 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 83 7D E0 00 7C 14 7F 09 81 7D DC 00 10 00 00 72 09 C7 45 F0 00 10 00 00 EB 06 8B 4D DC 89 4D F0 8B 55 F0 89 55 FC 83 7D E0 00 7C 14 7F 09 81 7D DC 00 10 00 00 72 09 C7 45 EC 00 10 00 00 EB 06 8B 45 DC 89 45 EC 8B 4D EC 51 8B 55 F8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC FF 75 28 E8 ?? ?? ?? ?? 83 38 05 75 12 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 F4 0D 00 00 00 8B 45 FC 99 89 45 D4 89 55 D8 EB 2A 8B 45 FC 99 8B 4D DC 2B C8 8B 45 E0 1B C2 89 4D DC 89 45 E0 83 7D E0 00 0F 8F 57 FF FF FF 7C 0A 83 7D DC 00 0F 87 4B FF FF FF 8B 4D E4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? E9 9A 00 00 00 83 7D E0 00 0F 8F 90 00 00 00 7C 0A 83 7D DC 00 0F 83 84 00 00 00 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 89 55 D8 8B 4D D4 23 4D D8 83 F9 FF 74 5D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 FF FF FF FF 8B 45 E8 99 89 45 D4 89 55 D8 8B 45 D4 23 45 D8 83 F8 FF 75 21 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 F4 0D 00 00 00 FF 15 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 8B 4D D4 23 4D D8 83 F9 FF 74 27 6A 00 8B 55 C8 52 8B 45 C4 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 89 55 C0 8B 55 BC 23 55 C0 83 FA FF 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "__chsize_s"
		size = 722
		refs = "0006 __sehtable$__chsize_s 000b __except_handler4 001d ___security_cookie 0037 ___doserrno 004c __ioinit 0069 __nhandle 008c ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0091 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 009a ??_C@_1GA@DBKMEDOF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00a1 __CrtDbgReportW 00c0 __errno 00d4 ??_C@_1BE@MAFDNGED@?$AA_?$AAc?$AAh?$AAs?$AAi?$AAz?$AAe?$AA_?$AAs?$AA?$AA@ 00de __invalid_parameter 0101 ___pioinfo 012c ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 01ba ??_C@_1BI@GALBKMKE@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0222 ___lock_fhandle 025d __chsize_nolock 026e ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 02b5 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 15 E8 ?? ?? ?? ?? C7 00 00 00 00 00 B8 09 00 00 00 E9 75 02 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A B8 09 00 00 00 E9 62 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 D1 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 31 01 00 00 83 7D 10 00 7C 11 7F 06 83 7D 0C 00 72 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 45 D4 89 45 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 A3 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC EB 39 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 42 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 CC 09 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 CC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "___common_sasin_cout_rare"
		size = 2528
		refs = "0040 __vmldASinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 55 08 0F B7 42 02 25 80 7F 00 00 F3 0F 10 12 3D 80 7F 00 00 0F 84 89 09 00 00 F3 0F 5A C2 F2 0F 11 44 24 40 80 64 24 47 7F F2 0F 10 4C 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 3D 09 00 00 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 0F 86 00 04 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 86 54 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 0F 28 D9 F2 0F 59 DA 0F 28 F1 F2 0F 11 5C 24 30 F2 0F 10 6C 24 30 F2 0F 11 0C 24 8B 4D 0C F2 0F 5C 6C 24 40 F2 0F 11 6C 24 28 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 30 0F 28 C1 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 74 24 28 F2 0F 10 6C 24 30 0F 28 F5 F2 0F 58 C5 F2 0F 59 F5 F2 0F 10 64 24 28 0F 28 DE F2 0F 59 C4 F2 0F 58 D8 F2 0F 59 FB F2 0F 11 5C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB 0F 28 DA F2 0F 59 DE F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 11 7C 24 10 F2 0F 10 7C 24 30 F2 0F 5C FE F2 0F 11 7C 24 28 F2 0F 10 7C 24 30 F2 0F 10 5C 24 28 F2 0F 5C FB F2 0F 11 7C 24 30 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 7C 24 28 F2 0F 59 E6 F2 0F 58 C7 F2 0F 59 EE F2 0F 59 C8 F2 0F 58 CC 0F 28 E2 F2 0F 59 E5 F2 0F 11 64 24 30 F2 0F 10 7C 24 30 F2 0F 5C FD F2 0F 11 7C 24 28 F2 0F 10 5C 24 30 F2 0F 10 64 24 28 F2 0F 5C DC 0F 28 E5 F2 0F 58 E9 F2 0F 11 5C 24 30 0F 28 DE F2 0F 10 7C 24 30 F2 0F 59 C5 F2 0F 5C E7 F2 0F 11 64 24 28 F2 0F 10 64 24 30 F2 0F 59 DC F2 0F 59 D3 F2 0F 10 7C 24 28 F2 0F 11 7C 24 18 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 59 F7 F2 0F 5C D3 F2 0F 11 54 24 28 F2 0F 58 F0 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 0F 28 FB F2 0F 58 DE F2 0F 11 44 24 30 F2 0F 10 54 24 30 F2 0F 5C FA F2 0F 11 7C 24 28 F2 0F 10 7C 24 08 F2 0F 59 FB F2 0F 10 44 24 30 F2 0F 10 54 24 28 F2 0F 11 54 24 20 F2 0F 10 54 24 10 F2 0F 59 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 10 1C 24 F2 0F 58 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 F5 F2 0F 59 C5 F2 0F 59 6C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 E2 F2 0F 58 F9 F2 0F 10 4C 24 18 F2 0F 59 CA 0F 28 D3 F2 0F 58 D4 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 4C 24 30 F2 0F 5C D9 F2 0F 58 DC F2 0F 11 5C 24 28 F2 0F 10 4C 24 30 F2 0F 10 64 24 28 F2 0F 58 FC F2 0F 58 FE 0F 28 F1 F2 0F 58 F0 F2 0F 58 FD F2 0F 11 74 24 30 F2 0F 10 64 24 30 F2 0F 5C CC F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 F8 83 E2 80 F2 0F 58 F9 F2 0F 11 7C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 7C 24 38 F3 0F 11 39 83 C4 64 5B 5F 5E 8B E5 5D C3 66 0F 2F 0D ?? ?? ?? ?? 72 4A 8B 4D 0C F2 0F 58 C8 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 F2 0F 59 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 0F B6 52 03 83 E0 7F 83 E2 80 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 0F B6 52 03 83 E2 80 F2 0F 58 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 8B 4D 0C F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B C8 81 E1 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C D9 F2 0F 59 D3 F2 0F 11 14 24 0F B7 74 24 06 81 E6 F0 7F 00 00 C1 EE 04 81 C6 01 FC FF FF 8B FE F7 DF 81 C7 FF 03 00 00 81 E7 FF 07 00 00 C1 E7 04 0B CF 66 89 4C 24 0E 8B CE F2 0F 59 54 24 08 83 E1 01 0F 28 EA 83 F9 01 F2 0F 10 35 ?? ?? ?? ?? 8B D9 F2 0F 11 44 24 18 F2 0F 58 EA 74 03 0F 28 EA F2 0F 59 F5 F2 0F 58 15 ?? ?? ?? ?? 0F 28 FE 0F 28 E5 F2 0F 11 54 24 10 2B F1 8B 7C 24 10 F2 0F 5C FD C1 E3 08 81 E7 FF 01 00 00 03 FB F2 0F 11 7C 24 28 F2 0F 10 4C 24 28 D1 EE F2 0F 5C F1 F2 0F 10 0C FD ?? ?? ?? ?? 0F 28 D6 0F 28 F9 81 C6 FF 03 00 00 F2 0F 59 F9 F2 0F 5C E6 F2 0F 59 F1 F2 0F 59 D7 F2 0F 59 FC F2 0F 5C D0 81 E6 FF 07 00 00 F2 0F 58 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FA C1 E6 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA 0B C6 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 F9 F2 0F 59 CC F2 0F 59 FD F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 F9 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 30 F2 0F 10 64 24 30 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 44 24 30 F2 0F 10 4C 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C C1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 6C 24 30 F2 0F 58 05 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 C3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 4C 24 28 F2 0F 11 74 24 40 F2 0F 58 F9 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 F4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 EE F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 0F 28 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 48 F2 0F 58 E8 0F 28 C2 F2 0F 59 C3 F2 0F 59 FD F2 0F 11 44 24 30 F2 0F 11 7C 24 50 F2 0F 10 7C 24 30 F2 0F 5C FB F2 0F 11 7C 24 28 F2 0F 10 6C 24 30 F2 0F 10 44 24 28 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 11 74 24 28 F2 0F 10 64 24 30 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 28 F2 0F 11 5C 24 30 F2 0F 10 74 24 30 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 5C 24 28 F2 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 5C 24 30 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 28 F2 0F 10 74 24 30 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 28 F2 0F 58 DE F2 0F 11 5C 24 30 F2 0F 11 6C 24 58 F2 0F 10 6C 24 30 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 28 0F 28 E5 F2 0F 10 5C 24 30 F2 0F 10 74 24 28 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 64 24 30 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 28 F2 0F 10 64 24 30 F2 0F 59 D4 F2 0F 10 5C 24 28 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 54 24 30 F2 0F 10 6C 24 28 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 58 D3 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 59 E3 F2 0F 58 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 58 64 24 48 F2 0F 10 44 24 40 F2 0F 59 D0 F2 0F 59 E0 F2 0F 59 C5 F2 0F 10 4C 24 50 F2 0F 58 CA F2 0F 10 15 ?? ?? ?? ?? 0F 28 F2 F2 0F 58 CC F2 0F 5C F0 F2 0F 11 74 24 30 F2 0F 10 7C 24 30 F2 0F 5C D7 F2 0F 5C D0 F2 0F 11 54 24 28 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 5C 24 30 F2 0F 5C D1 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 D0 83 E2 80 F2 0F 58 DA F2 0F 11 5C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F F2 0F 5A 44 24 38 8B 45 0C F3 0F 11 00 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8B 45 0C F3 0F 5C D2 F3 0F 5E D2 F3 0F 11 10 B8 01 00 00 00 83 C4 64 5B 5F 5E 8B E5 5D C3 F3 0F 5E D2 8B 45 0C B9 01 00 00 00 F3 0F 11 10 33 C0 F7 02 FF FF 7F 00 0F 44 C1 83 C4 64 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 60
		refs = "0033 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 10 8B 45 08 3B 45 0C 74 0D 8B 4D 08 3B 4D 10 74 05 8B 45 08 EB 1C 8B 55 24 52 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "__searchenv"
		size = 30
		refs = "0015 __searchenv_s"
	strings:
		$1 = { 55 8B EC 68 04 01 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_791_2_0 {
	meta:
		name = "__wsearchenv"
		size = 30
		refs = "0015 __wsearchenv_s"
	strings:
		$1 = { 55 8B EC 68 04 01 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "__searchenv_s"
		size = 1761
		refs = "000a ___security_cookie 0063 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0068 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0071 ??_C@_1GE@PHBNAIPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0078 __CrtDbgReportW 008f __errno 00a3 ??_C@_1BK@PNDGCBHE@?$AA_?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AAe?$AAn?$AAv?$AA_?$AAs?$AA?$AA@ 00ad __invalid_parameter 00f0 ??_C@_1BC@FCDIKEIH@?$AA?$CI?$AAs?$AAz?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 018d ??_C@_1CA@JLJGIEHM@?$AA?$CI?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0232 __access_s 0262 __fullpath 02a3 ??_C@_1OC@JEBOJDOC@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 02ae ??_C@_0DC@OPHNAMFI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 02c2 __dupenv_s_dbg 02cb __invoke_watson_if_oneof 0313 _strlen 0376 __calloc_dbg 03f4 __getpath 056b ??_C@_1FA@OKEPIJPD@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAb?$AAu?$AAf?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAp?$AA?5?$AA?9?$AA?5?$AAp?$AAb?$AAu?$AAf?$AA?$CJ?$AA?0@ 0590 _strcpy_s 0599 __invoke_watson_if_error 05e8 __free_dbg 062b ??_C@_1DC@DGBEGMOD@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?0?$AA?5?$AAs?$AAz?$AA?0?$AA?5?$AAp?$AAb?$AAu?$AAf?$AA?$CJ?$AA?$AA@ 06d9 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 D8 FE FF FF 00 00 00 00 C7 85 F0 FE FF FF 00 00 00 00 C7 85 EC FE FF FF 00 00 00 00 83 7D 10 00 74 0C C7 85 B8 FE FF FF 01 00 00 00 EB 0A C7 85 B8 FE FF FF 00 00 00 00 8B 85 B8 FE FF FF 89 85 B4 FE FF FF 83 BD B4 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD B4 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 15 06 00 00 83 7D 14 00 76 0C C7 85 C0 FE FF FF 01 00 00 00 EB 0A C7 85 C0 FE FF FF 00 00 00 00 8B 95 C0 FE FF FF 89 95 B0 FE FF FF 83 BD B0 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 41 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 88 05 00 00 83 7D 08 00 0F 85 93 00 00 00 8B 4D 10 C6 01 00 83 7D 08 00 74 0C C7 85 C8 FE FF FF 01 00 00 00 EB 0A C7 85 C8 FE FF FF 00 00 00 00 8B 95 C8 FE FF FF 89 95 C4 FE FF FF 83 BD C4 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD C4 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EB 04 00 00 B9 01 00 00 00 6B C9 00 8B 55 08 0F BE 04 0A 85 C0 75 23 8B 4D 10 C6 01 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 EC FE FF FF E9 7F 04 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D0 FE FF FF 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 AC FE FF FF E8 ?? ?? ?? ?? 8B 95 D0 FE FF FF 89 10 83 BD AC FE FF FF 00 75 3F 8B 45 14 50 8B 4D 08 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 18 8B 45 10 C6 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D EC FE FF FF E9 18 04 00 00 C7 85 EC FE FF FF 00 00 00 00 E9 09 04 00 00 6A 00 6A 64 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 64 68 ?? ?? ?? ?? 6A 02 8B 55 0C 52 6A 00 8D 85 D8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 09 83 BD D8 FE FF FF 00 75 23 8B 4D 10 C6 01 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 EC FE FF FF E9 9B 03 00 00 8B 85 D8 FE FF FF 89 85 E8 FE FF FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 DC FE FF FF 8D 95 F4 FE FF FF 89 95 F0 FE FF FF C7 85 E4 FE FF FF 08 01 00 00 8B 85 DC FE FF FF 3B 85 E4 FE FF FF 72 6B 8B 8D E8 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 95 DC FE FF FF 8D 44 10 02 89 85 E4 FE FF FF 6A 76 68 ?? ?? ?? ?? 6A 02 6A 01 8B 8D E4 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 F0 FE FF FF 83 BD F0 FE FF FF 00 75 23 8B 55 10 C6 02 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 EC FE FF FF E9 EE 02 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D D0 FE FF FF 83 BD E8 FE FF FF 00 0F 84 B6 02 00 00 8B 95 E8 FE FF FF 89 95 BC FE FF FF 8B 85 E4 FE FF FF 2B 85 DC FE FF FF 83 E8 01 50 8B 8D F0 FE FF FF 51 8B 95 E8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FE FF FF 83 BD E8 FE FF FF 00 0F 85 B7 00 00 00 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 0F 85 A5 00 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 97 00 00 00 8B 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 95 DC FE FF FF 8D 44 10 02 89 85 E4 FE FF FF 68 8A 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 8B 8D E4 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 F0 FE FF FF 83 BD F0 FE FF FF 00 75 23 8B 55 10 C6 02 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 EC FE FF FF E9 01 02 00 00 8B 8D E4 FE FF FF 2B 8D DC FE FF FF 51 8B 95 F0 FE FF FF 52 8B 85 BC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FE FF FF 83 BD E8 FE FF FF 00 74 0D 8B 8D F0 FE FF FF 0F BE 11 85 D2 75 05 E9 9F 01 00 00 8B 85 F0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 D4 FE FF FF 8B 8D F0 FE FF FF 03 8D D4 FE FF FF 89 8D E0 FE FF FF 8B 95 E0 FE FF FF 0F BE 42 FF 89 85 CC FE FF FF 83 BD CC FE FF FF 2F 74 39 83 BD CC FE FF FF 5C 74 30 83 BD CC FE FF FF 3A 74 27 8B 8D E0 FE FF FF C6 01 5C 8B 95 E0 FE FF FF 83 C2 01 89 95 E0 FE FF FF 8B 85 D4 FE FF FF 83 C0 01 89 85 D4 FE FF FF 6A 00 68 A9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 51 8B 95 E0 FE FF FF 2B 95 F0 FE FF FF 8B 85 E4 FE FF FF 2B C2 50 8B 8D E0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 8B 95 F0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 C1 00 00 00 8B 85 D4 FE FF FF 03 85 DC FE FF FF 3B 45 14 72 42 8B 4D 10 C6 01 00 8D 95 F4 FE FF FF 39 95 F0 FE FF FF 74 11 6A 02 8B 85 F0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D EC FE FF FF E9 91 00 00 00 E8 ?? ?? ?? ?? 8B 95 D0 FE FF FF 89 10 6A 00 68 BB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 F0 FE FF FF 50 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 74 11 6A 02 8B 8D F0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 C7 85 EC FE FF FF 00 00 00 00 EB 23 E9 3D FD FF FF 8B 55 10 C6 02 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 EC FE FF FF 8D 8D F4 FE FF FF 39 8D F0 FE FF FF 74 11 6A 02 8B 95 F0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 85 D8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 85 EC FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "__mbsninc_l"
		size = 38
		refs = "001a __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 04 33 C0 EB 17 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 03 45 08 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 106
		refs = "0010 ??1GlobalCore@details@Concurrency@@QAE@XZ 0022 ??_M@YGXPAXIHP6EX0@Z@Z 0036 ??_V@YAXPAX@Z 005a ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 83 E0 02 74 36 68 ?? ?? ?? ?? 8B 4D FC 8B 51 FC 52 6A 24 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 4D 08 83 E1 01 74 0F 8B 55 FC 83 EA 04 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 83 E8 04 EB 1F 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 35
	strings:
		$1 = { 55 8B EC 8B 45 10 83 E8 01 89 45 10 78 11 8B 4D 08 FF 55 14 8B 4D 08 03 4D 0C 89 4D 08 EB E4 5D C2 10 00 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "___avx_atanf8"
		size = 192
		refs = "0004 ___common_satan_data"
	strings:
		$1 = { C5 FC 10 3D ?? ?? ?? ?? C5 FC 10 0D ?? ?? ?? ?? C5 FC 54 1D ?? ?? ?? ?? C5 C4 5F D3 C5 C4 5D E3 C5 E4 C2 EF 1E C5 DC 5E DA C5 D4 54 35 ?? ?? ?? ?? C5 F4 54 C0 C5 D4 54 E9 C5 D4 57 F8 C5 C4 57 E3 C5 DC 59 D4 C5 EC 59 CA C5 CC 57 D8 C5 F4 59 35 ?? ?? ?? ?? C5 F4 59 2D ?? ?? ?? ?? C5 CC 58 35 ?? ?? ?? ?? C5 D4 58 3D ?? ?? ?? ?? C5 CC 59 C1 C5 C4 59 E9 C5 FC 58 35 ?? ?? ?? ?? C5 D4 58 3D ?? ?? ?? ?? C5 CC 59 C1 C5 C4 59 E9 C5 FC 58 35 ?? ?? ?? ?? C5 D4 58 3D ?? ?? ?? ?? C5 CC 59 C9 C5 C4 59 D2 C5 F4 58 0D ?? ?? ?? ?? C5 EC 58 D1 C5 EC 59 E4 C5 DC 58 C3 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__woutput_s_l"
		size = 5636
		refs = "000a ___security_cookie 0064 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0073 __errno 007e __ioinit 0097 ??1_LocaleUpdate@@QAE@XZ 00d8 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00dd ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e9 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f0 __CrtDbgReportW 011e ??_C@_1BK@ONMFGLDB@?$AA_?$AAw?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0128 __invalid_parameter 0181 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0289 ___lookuptable_s 030b ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 03a4 $LN170 03c6 _write_char 0451 $LN166 0458 $LN171 04c8 _get_int_arg 05af $LN167 05b6 $LN172 070e $LN168 0715 $LN173 0794 ___report_rangecheckfailure 07ad ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 07d2 __mbtowc_l 0844 ___nullstring 0856 _strlen 09a6 __isleadbyte_l 09e1 ___wnullstring 0a6f __get_printf_count_output 0aab ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0bff ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0c13 __malloc_dbg 0cb1 __cfltcvt_tab 0cb8 __imp__DecodePointer@4 0e6e _get_int64_arg 1099 __aullrem 10be __aulldiv 1265 _write_multi_char 128d _write_string 140d __free_dbg 1461 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 14f8 @__security_check_cookie@4 1500 $NORMAL_STATE$174 1504 $LN132 1508 $LN131 150c $LN123 1510 $LN119 1514 $LN118 1518 $LN114 151c $LN98 1520 $LN126 1524 $LN125 1528 $LN127 152c $LN128 1530 $LN124 1534 $LN129 154c $LN108 1550 $LN100 1554 $LN111 1558 $LN99 155c $LN112 1590 $LN65 1594 $LN95 1598 $LN83 159c $LN47 15a0 $LN89 15a4 $LN64 15a8 $LN93 15ac $LN52 15b0 $LN70 15b4 $LN42 15b8 $LN48 15bc $LN81 15c0 $LN50 15c4 $LN45 15c8 $LN96"
	strings:
		$1 = { 55 8B EC 81 EC 18 05 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 94 FB FF FF 00 00 00 00 C7 85 F8 FB FF FF 00 00 00 00 C7 85 E0 FB FF FF 00 00 00 00 C7 85 EC FB FF FF 00 00 00 00 C7 85 D8 FB FF FF 00 00 00 00 C7 85 B0 FB FF FF 00 00 00 00 C7 85 BC FB FF FF 00 00 00 00 8B 45 10 50 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? C7 85 C4 FB FF FF 00 00 00 00 E8 ?? ?? ?? ?? 89 85 50 FB FF FF E8 ?? ?? ?? ?? 85 C0 7D 20 C7 85 04 FB FF FF FF FF FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 85 04 FB FF FF E9 4C 14 00 00 83 7D 08 00 74 0C C7 85 30 FB FF FF 01 00 00 00 EB 0A C7 85 30 FB FF FF 00 00 00 00 8B 8D 30 FB FF FF 89 8D 60 FB FF FF 83 BD 60 FB FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 60 FB FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 08 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 0C FB FF FF FF FF FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 85 0C FB FF FF E9 A3 13 00 00 83 7D 0C 00 74 0C C7 85 28 FB FF FF 01 00 00 00 EB 0A C7 85 28 FB FF FF 00 00 00 00 8B 85 28 FB FF FF 89 85 20 FB FF FF 83 BD 20 FB FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0D 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 20 FB FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0D 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FB FF FF FF FF FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 85 1C FB FF FF E9 FA 12 00 00 C7 85 E4 FB FF FF 00 00 00 00 C7 85 E8 FB FF FF 00 00 00 00 C7 85 C0 FB FF FF 00 00 00 00 C7 85 C4 FB FF FF 00 00 00 00 C7 85 74 FB FF FF 00 00 00 00 8B 55 0C 66 8B 02 66 89 85 F4 FB FF FF 0F B7 8D F4 FB FF FF 89 8D F0 FA FF FF 8B 55 0C 83 C2 02 89 55 0C 83 BD F0 FA FF FF 00 0F 84 C9 11 00 00 83 BD E4 FB FF FF 00 0F 8C BC 11 00 00 0F B7 85 F4 FB FF FF 83 F8 20 7C 25 0F B7 8D F4 FB FF FF 83 F9 78 7F 19 0F B7 95 F4 FB FF FF 0F B6 82 ?? ?? ?? ?? 83 E0 0F 89 85 3C FB FF FF EB 0A C7 85 3C FB FF FF 00 00 00 00 8B 8D 3C FB FF FF 89 8D F4 FA FF FF 8B 95 F4 FA FF FF 6B D2 09 8B 85 C0 FB FF FF 0F B6 8C 02 ?? ?? ?? ?? C1 F9 04 89 8D C0 FB FF FF 83 BD C0 FB FF FF 08 0F 85 A7 00 00 00 33 D2 74 0C C7 85 38 FB FF FF 01 00 00 00 EB 0A C7 85 38 FB FF FF 00 00 00 00 8B 85 38 FB FF FF 89 85 54 FB FF FF 83 BD 54 FB FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 66 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 54 FB FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 66 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 00 FB FF FF FF FF FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 85 00 FB FF FF E9 70 11 00 00 8B 95 C0 FB FF FF 89 95 2C FB FF FF 83 BD 2C FB FF FF 07 0F 87 83 10 00 00 8B 85 2C FB FF FF FF 24 85 ?? ?? ?? ?? C7 85 BC FB FF FF 01 00 00 00 8D 8D E4 FB FF FF 51 8B 55 08 52 0F B7 85 F4 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C E9 4C 10 00 00 C7 85 84 FB FF FF 00 00 00 00 8B 8D 84 FB FF FF 89 8D B0 FB FF FF 8B 95 B0 FB FF FF 89 95 E0 FB FF FF 8B 85 E0 FB FF FF 89 85 D8 FB FF FF C7 85 F8 FB FF FF 00 00 00 00 C7 85 EC FB FF FF FF FF FF FF C7 85 BC FB FF FF 00 00 00 00 E9 FB 0F 00 00 0F B7 8D F4 FB FF FF 89 8D 98 FB FF FF 8B 95 98 FB FF FF 83 EA 20 89 95 98 FB FF FF 83 BD 98 FB FF FF 10 77 6A 8B 85 98 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 95 F8 FB FF FF 83 CA 04 89 95 F8 FB FF FF EB 45 8B 85 F8 FB FF FF 83 C8 01 89 85 F8 FB FF FF EB 34 8B 8D F8 FB FF FF 83 C9 02 89 8D F8 FB FF FF EB 23 8B 95 F8 FB FF FF 81 CA 80 00 00 00 89 95 F8 FB FF FF EB 0F 8B 85 F8 FB FF FF 83 C8 08 89 85 F8 FB FF FF E9 67 0F 00 00 0F B7 8D F4 FB FF FF 83 F9 2A 75 3A 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 E0 FB FF FF 83 BD E0 FB FF FF 00 7D 1D 8B 85 F8 FB FF FF 83 C8 04 89 85 F8 FB FF FF 8B 8D E0 FB FF FF F7 D9 89 8D E0 FB FF FF EB 1A 8B 95 E0 FB FF FF 6B D2 0A 0F B7 85 F4 FB FF FF 8D 4C 02 D0 89 8D E0 FB FF FF E9 02 0F 00 00 C7 85 EC FB FF FF 00 00 00 00 E9 F3 0E 00 00 0F B7 95 F4 FB FF FF 83 FA 2A 75 27 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 EC FB FF FF 83 BD EC FB FF FF 00 7D 0A C7 85 EC FB FF FF FF FF FF FF EB 1A 8B 8D EC FB FF FF 6B C9 0A 0F B7 95 F4 FB FF FF 8D 44 11 D0 89 85 EC FB FF FF E9 A1 0E 00 00 0F B7 8D F4 FB FF FF 89 8D 8C FB FF FF 8B 95 8C FB FF FF 83 EA 49 89 95 8C FB FF FF 83 BD 8C FB FF FF 2E 0F 87 31 01 00 00 8B 85 8C FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 0F B7 02 83 F8 6C 75 1D 8B 4D 0C 83 C1 02 89 4D 0C 8B 95 F8 FB FF FF 81 CA 00 10 00 00 89 95 F8 FB FF FF EB 0F 8B 85 F8 FB FF FF 83 C8 10 89 85 F8 FB FF FF E9 E1 00 00 00 8B 4D 0C 0F B7 11 83 FA 36 75 2B 8B 45 0C 0F B7 48 02 83 F9 34 75 1F 8B 55 0C 83 C2 04 89 55 0C 8B 85 F8 FB FF FF 0D 00 80 00 00 89 85 F8 FB FF FF E9 86 00 00 00 8B 4D 0C 0F B7 11 83 FA 33 75 28 8B 45 0C 0F B7 48 02 83 F9 32 75 1C 8B 55 0C 83 C2 04 89 55 0C 8B 85 F8 FB FF FF 25 FF 7F FF FF 89 85 F8 FB FF FF EB 53 8B 4D 0C 0F B7 11 83 FA 64 74 37 8B 45 0C 0F B7 08 83 F9 69 74 2C 8B 55 0C 0F B7 02 83 F8 6F 74 21 8B 4D 0C 0F B7 11 83 FA 75 74 16 8B 45 0C 0F B7 08 83 F9 78 74 0B 8B 55 0C 0F B7 02 83 F8 58 75 02 EB 0F C7 85 C0 FB FF FF 00 00 00 00 E9 F6 FC FF FF EB 23 8B 8D F8 FB FF FF 83 C9 20 89 8D F8 FB FF FF EB 12 8B 95 F8 FB FF FF 81 CA 00 08 00 00 89 95 F8 FB FF FF E9 42 0D 00 00 0F B7 85 F4 FB FF FF 89 85 90 FB FF FF 8B 8D 90 FB FF FF 83 E9 41 89 8D 90 FB FF FF 83 BD 90 FB FF FF 37 0F 87 87 0A 00 00 8B 95 90 FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 8D F8 FB FF FF 81 E1 30 08 00 00 75 0F 8B 95 F8 FB FF FF 83 CA 20 89 95 F8 FB FF FF C7 85 BC FB FF FF 01 00 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 DC FB FF FF 8B 8D F8 FB FF FF 83 E1 20 0F 84 87 00 00 00 0F B7 95 DC FB FF FF 81 E2 FF 00 00 00 B8 01 00 00 00 6B C0 00 88 94 05 A8 FB FF FF C7 85 4C FB FF FF 01 00 00 00 83 BD 4C FB FF FF 02 73 02 EB 05 E8 ?? ?? ?? ?? 8B 8D 4C FB FF FF C6 84 0D A8 FB FF FF 00 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 50 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 10 8B 42 74 50 8D 8D A8 FB FF FF 51 8D 95 FC FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 0A C7 85 B0 FB FF FF 01 00 00 00 EB 17 B8 02 00 00 00 6B C0 00 66 8B 8D DC FB FF FF 66 89 8C 05 FC FB FF FF 8D 95 FC FB FF FF 89 95 F0 FB FF FF C7 85 E8 FB FF FF 01 00 00 00 E9 71 09 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 B4 FB FF FF 83 BD B4 FB FF FF 00 74 0C 8B 8D B4 FB FF FF 83 79 04 00 75 23 8B 15 ?? ?? ?? ?? 89 95 F0 FB FF FF 8B 85 F0 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 E8 FB FF FF EB 65 8B 8D F8 FB FF FF 81 E1 00 08 00 00 74 2F 8B 95 B4 FB FF FF 8B 42 04 89 85 F0 FB FF FF 8B 8D B4 FB FF FF 0F BF 01 99 2B C2 D1 F8 89 85 E8 FB FF FF C7 85 BC FB FF FF 01 00 00 00 EB 28 C7 85 BC FB FF FF 00 00 00 00 8B 95 B4 FB FF FF 8B 42 04 89 85 F0 FB FF FF 8B 8D B4 FB FF FF 0F BF 11 89 95 E8 FB FF FF E9 BD 08 00 00 8B 85 F8 FB FF FF 25 30 08 00 00 75 0F 8B 8D F8 FB FF FF 83 C9 20 89 8D F8 FB FF FF 83 BD EC FB FF FF FF 75 0C C7 85 34 FB FF FF FF FF FF 7F EB 0C 8B 95 EC FB FF FF 89 95 34 FB FF FF 8B 85 34 FB FF FF 89 85 88 FB FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 F0 FB FF FF 8B 95 F8 FB FF FF 83 E2 20 0F 84 9D 00 00 00 83 BD F0 FB FF FF 00 75 0B A1 ?? ?? ?? ?? 89 85 F0 FB FF FF 8B 8D F0 FB FF FF 89 8D B8 FB FF FF C7 85 E8 FB FF FF 00 00 00 00 EB 0F 8B 95 E8 FB FF FF 83 C2 01 89 95 E8 FB FF FF 8B 85 E8 FB FF FF 3B 85 88 FB FF FF 7D 4F 8B 8D B8 FB FF FF 0F BE 11 85 D2 74 42 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 50 8B 85 B8 FB FF FF 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 95 B8 FB FF FF 83 C2 01 89 95 B8 FB FF FF 8B 85 B8 FB FF FF 83 C0 01 89 85 B8 FB FF FF EB 94 E9 81 00 00 00 83 BD F0 FB FF FF 00 75 0C 8B 0D ?? ?? ?? ?? 89 8D F0 FB FF FF C7 85 BC FB FF FF 01 00 00 00 8B 95 F0 FB FF FF 89 95 A0 FB FF FF 8B 85 88 FB FF FF 89 85 10 FB FF FF 8B 8D 88 FB FF FF 83 E9 01 89 8D 88 FB FF FF 83 BD 10 FB FF FF 00 74 1E 8B 95 A0 FB FF FF 0F B7 02 85 C0 74 11 8B 8D A0 FB FF FF 83 C1 02 89 8D A0 FB FF FF EB BE 8B 95 A0 FB FF FF 2B 95 F0 FB FF FF D1 FA 89 95 E8 FB FF FF E9 30 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 5C FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 AC 00 00 00 33 C9 74 0C C7 85 44 FB FF FF 01 00 00 00 EB 0A C7 85 44 FB FF FF 00 00 00 00 8B 95 44 FB FF FF 89 95 24 FB FF FF 83 BD 24 FB FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9B 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 24 FB FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9B 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC FA FF FF FF FF FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 8B 85 FC FA FF FF E9 D0 09 00 00 E9 65 06 00 00 8B 8D F8 FB FF FF 83 E1 20 74 12 8B 95 5C FB FF FF 66 8B 85 E4 FB FF FF 66 89 02 EB 0E 8B 8D 5C FB FF FF 8B 95 E4 FB FF FF 89 11 C7 85 B0 FB FF FF 01 00 00 00 E9 2B 06 00 00 C7 85 84 FB FF FF 01 00 00 00 0F B7 85 F4 FB FF FF 83 C0 20 66 89 85 F4 FB FF FF 8B 8D F8 FB FF FF 83 C9 40 89 8D F8 FB FF FF 8D 95 FC FB FF FF 89 95 F0 FB FF FF C7 85 74 FB FF FF 00 02 00 00 83 BD EC FB FF FF 00 7D 0C C7 85 EC FB FF FF 06 00 00 00 EB 37 83 BD EC FB FF FF 00 75 18 0F B7 85 F4 FB FF FF 83 F8 67 75 0C C7 85 EC FB FF FF 01 00 00 00 EB 16 81 BD EC FB FF FF 00 02 00 00 7E 0A C7 85 EC FB FF FF 00 02 00 00 81 BD EC FB FF FF A3 00 00 00 7E 59 68 E0 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 8D EC FB FF FF 81 C1 5D 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 C4 FB FF FF 83 BD C4 FB FF FF 00 74 1F 8B 95 C4 FB FF FF 89 95 F0 FB FF FF 8B 85 EC FB FF FF 05 5D 01 00 00 89 85 74 FB FF FF EB 0A C7 85 EC FB FF FF A3 00 00 00 8B 4D 14 83 C1 08 89 4D 14 8B 55 14 8B 42 F8 8B 4A FC 89 85 E8 FA FF FF 89 8D EC FA FF FF 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 50 8B 95 84 FB FF FF 52 8B 85 EC FB FF FF 50 0F BE 8D F4 FB FF FF 51 8B 95 74 FB FF FF 52 8B 85 F0 FB FF FF 50 8D 8D E8 FA FF FF 51 BA 04 00 00 00 6B D2 06 8B 82 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 1C 8B 8D F8 FB FF FF 81 E1 80 00 00 00 74 36 83 BD EC FB FF FF 00 75 2D 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 50 8B 95 F0 FB FF FF 52 B8 04 00 00 00 6B C0 09 8B 88 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 0F B7 95 F4 FB FF FF 83 FA 67 75 3A 8B 85 F8 FB FF FF 25 80 00 00 00 75 2D 8D 8D 64 FB FF FF E8 ?? ?? ?? ?? 50 8B 8D F0 FB FF FF 51 BA 04 00 00 00 C1 E2 03 8B 82 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 8B 8D F0 FB FF FF 0F BE 11 83 FA 2D 75 20 8B 85 F8 FB FF FF 0D 00 01 00 00 89 85 F8 FB FF FF 8B 8D F0 FB FF FF 83 C1 01 89 8D F0 FB FF FF 8B 95 F0 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 E8 FB FF FF E9 F9 03 00 00 8B 85 F8 FB FF FF 83 C8 40 89 85 F8 FB FF FF C7 85 A4 FB FF FF 0A 00 00 00 E9 AA 00 00 00 C7 85 A4 FB FF FF 0A 00 00 00 E9 9B 00 00 00 C7 85 EC FB FF FF 08 00 00 00 C7 85 94 FB FF FF 07 00 00 00 EB 0A C7 85 94 FB FF FF 27 00 00 00 C7 85 A4 FB FF FF 10 00 00 00 8B 8D F8 FB FF FF 81 E1 80 00 00 00 74 38 BA 02 00 00 00 6B D2 00 B8 30 00 00 00 66 89 84 15 AC FB FF FF 8B 8D 94 FB FF FF 83 C1 51 BA 02 00 00 00 C1 E2 00 66 89 8C 15 AC FB FF FF C7 85 D8 FB FF FF 02 00 00 00 EB 29 C7 85 A4 FB FF FF 08 00 00 00 8B 85 F8 FB FF FF 25 80 00 00 00 74 12 8B 8D F8 FB FF FF 81 C9 00 02 00 00 89 8D F8 FB FF FF 8B 95 F8 FB FF FF 81 E2 00 80 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 C8 FB FF FF 89 95 CC FB FF FF E9 BB 00 00 00 8B 8D F8 FB FF FF 81 E1 00 10 00 00 74 1D 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 C8 FB FF FF 89 95 CC FB FF FF E9 90 00 00 00 8B 85 F8 FB FF FF 83 E0 20 74 45 8B 8D F8 FB FF FF 83 E1 40 74 1C 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 C8 FB FF FF 89 95 CC FB FF FF EB 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 C8 FB FF FF 89 95 CC FB FF FF EB 40 8B 8D F8 FB FF FF 83 E1 40 74 1B 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 C8 FB FF FF 89 95 CC FB FF FF EB 1A 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 C8 FB FF FF 89 8D CC FB FF FF 8B 95 F8 FB FF FF 83 E2 40 74 47 83 BD CC FB FF FF 00 7F 3E 7C 09 83 BD C8 FB FF FF 00 73 33 8B 85 C8 FB FF FF F7 D8 8B 8D CC FB FF FF 83 D1 00 F7 D9 89 85 D0 FB FF FF 89 8D D4 FB FF FF 8B 95 F8 FB FF FF 81 CA 00 01 00 00 89 95 F8 FB FF FF EB 18 8B 85 C8 FB FF FF 89 85 D0 FB FF FF 8B 8D CC FB FF FF 89 8D D4 FB FF FF 8B 95 F8 FB FF FF 81 E2 00 80 00 00 75 28 8B 85 F8 FB FF FF 25 00 10 00 00 75 1B 8B 8D D0 FB FF FF 8B 95 D4 FB FF FF 83 E2 00 89 8D D0 FB FF FF 89 95 D4 FB FF FF 83 BD EC FB FF FF 00 7D 0C C7 85 EC FB FF FF 01 00 00 00 EB 25 8B 85 F8 FB FF FF 83 E0 F7 89 }
	condition:
		$1
}

rule file_28_4_0 {
	meta:
		name = "_get_int64_arg"
		size = 29
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_28_5_0 {
	meta:
		name = "_get_int_arg"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_28_6_0 {
	meta:
		name = "_write_char"
		size = 92
		refs = "0030 __fputwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 34 8B 45 0C 50 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B7 D0 81 FA FF FF 00 00 75 0B 8B 45 10 C7 00 FF FF FF FF EB 0D 8B 4D 10 8B 11 83 C2 01 8B 45 10 89 10 5D C3 }
	condition:
		$1
}

rule file_28_7_0 {
	meta:
		name = "_write_multi_char"
		size = 62
		refs = "0027 _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 45 FC 8B 4D 0C 83 E9 01 89 4D 0C 83 7D FC 00 7E 21 8B 55 14 52 8B 45 10 50 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CA 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_8_0 {
	meta:
		name = "_write_string"
		size = 179
		refs = "0067 _write_char"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 18 8B 08 89 4D F4 8B 55 10 8B 42 0C 83 E0 40 74 18 8B 4D 10 83 79 08 00 75 0F 8B 55 14 8B 02 03 45 0C 8B 4D 14 89 01 EB 7E 8B 55 18 C7 02 00 00 00 00 8B 45 0C 89 45 F8 8B 4D 0C 83 E9 01 89 4D 0C 83 7D F8 00 7E 50 8B 55 08 66 8B 02 66 89 45 FE 8B 4D 14 51 8B 55 10 52 0F B7 45 FE 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 02 89 4D 08 8B 55 14 83 3A FF 75 1E 8B 45 18 83 38 2A 75 14 8B 4D 14 51 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB 9B 8B 45 18 83 38 00 75 08 8B 4D 18 8B 55 F4 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_ax0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 B0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "_ax8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A B0 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "_ax32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 B0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "_cx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 AC 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "_cx8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A AC 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "_cx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 AC 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_6_0 {
	meta:
		name = "_dx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A8 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_7_0 {
	meta:
		name = "_dx8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A8 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_8_0 {
	meta:
		name = "_dx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A8 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_9_0 {
	meta:
		name = "_bx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A4 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_10_0 {
	meta:
		name = "_bx8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A4 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_11_0 {
	meta:
		name = "_bx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_12_0 {
	meta:
		name = "_sib0"
		size = 536
		refs = "0052 $LN30 0131 $LN31 01d8 $LN23 01dc $LN22 01e0 $LN21 01e4 $LN20 01e8 $LN19 01ec $LN18 01f0 $LN17 01f4 $LN16 01f8 $LN9 01fc $LN8 0200 $LN7 0204 $LN6 0208 $LN5 020c $LN4 0210 $LN3 0214 $LN2"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 F4 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F0 83 7D F0 07 77 7A 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 05 75 1C 8B 55 FC 0F AF 55 F4 8B 45 10 03 50 01 8B 4D 08 89 11 B8 05 00 00 00 E9 DC 00 00 00 83 7D F8 04 75 1A 8B 55 FC 0F AF 55 F4 8B 45 0C 03 90 C4 00 00 00 8B 4D 08 89 11 E9 B7 00 00 00 8B 55 F8 83 E2 07 89 55 EC 83 7D EC 07 0F 87 8A 00 00 00 8B 45 EC FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 FC 0F AF 55 F4 8B 45 08 03 10 8B 4D 08 89 11 B8 01 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_13_0 {
	meta:
		name = "_sib8"
		size = 520
		refs = "0052 $LN29 0118 $LN30 01c8 $LN22 01cc $LN21 01d0 $LN20 01d4 $LN19 01d8 $LN18 01dc $LN17 01e0 $LN16 01e4 $LN15 01e8 $LN9 01ec $LN8 01f0 $LN7 01f4 $LN6 01f8 $LN5 01fc $LN4 0200 $LN3 0204 $LN2"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 EC 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F4 83 7D F4 07 77 7A 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 23 8B 55 10 0F B6 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 FC 0F AF 55 EC 03 C2 8B 4D 08 89 01 E9 C0 00 00 00 8B 55 F8 83 E2 07 89 55 F0 83 7D F0 07 0F 87 8A 00 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 10 0F B6 42 01 8B 4D FC 0F AF 4D EC 03 C1 8B 55 08 03 02 8B 4D 08 89 01 B8 02 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_14_0 {
	meta:
		name = "_sib32"
		size = 520
		refs = "0052 $LN29 0117 $LN30 01c8 $LN22 01cc $LN21 01d0 $LN20 01d4 $LN19 01d8 $LN18 01dc $LN17 01e0 $LN16 01e4 $LN15 01e8 $LN9 01ec $LN8 01f0 $LN7 01f4 $LN6 01f8 $LN5 01fc $LN4 0200 $LN3 0204 $LN2"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 EC 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F4 83 7D F4 07 77 7A 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 22 8B 55 10 8B 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 FC 0F AF 55 EC 03 C2 8B 4D 08 89 01 E9 BF 00 00 00 8B 55 F8 83 E2 07 89 55 F0 83 7D F0 07 0F 87 8A 00 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 FC 0F AF 55 EC 8B 45 10 8B 48 01 03 CA 8B 55 08 03 0A 8B 45 08 89 08 B8 05 00 00 00 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_15_0 {
	meta:
		name = "_d32"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 10 8B 11 89 10 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_16_0 {
	meta:
		name = "_bp8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A B4 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_17_0 {
	meta:
		name = "_bp32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 B4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_18_0 {
	meta:
		name = "_si0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_19_0 {
	meta:
		name = "_si8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A0 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_20_0 {
	meta:
		name = "_si32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_21_0 {
	meta:
		name = "_di0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 9C 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_32_22_0 {
	meta:
		name = "_di8"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A 9C 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_23_0 {
	meta:
		name = "_di32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 9C 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_32_25_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 1060
		refs = "0050 $LN60 0057 $LN69 0073 $LN70 00eb $LN71 0104 $LN61 010b $LN72 0145 $LN62 014c $LN73 0183 $LN63 018a $LN74 01c1 $LN64 01c8 $LN75 0204 $LN76 021d $LN65 0224 $LN77 026c $LN66 0273 $LN78 02bb $LN67 02c2 $LN79 0307 $LN68 030e $LN80 0340 $LN46 0344 $LN53 0348 $LN23 034c $LN58 0374 $LN50 0378 $LN49 037c $LN48 0380 $LN47 0384 $LN43 0388 $LN38 038c $LN33 0390 $LN28 0394 $LN40 0398 $LN39 03a4 $LN34 03a8 $LN35 03b4 $LN29 03b8 $LN30 03c4 $LN25 03c8 $LN24 03d4 $LN20 03d8 $LN15 03dc $LN10 03e0 $LN5 03e4 $LN17 03e8 $LN16 03f4 $LN11 03f8 $LN12 0404 $LN6 0408 $LN7 0414 $LN2 0418 $LN1"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 8B 48 20 8B 51 60 83 E2 01 75 05 E9 23 03 00 00 8B 45 0C 8B 48 20 8B 51 60 D1 EA 83 E2 0F 83 FA 07 74 05 E9 0B 03 00 00 8B 45 08 89 45 FC 8B 4D FC 83 E9 39 89 4D FC 83 7D FC 21 0F 87 F2 02 00 00 8B 55 FC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 8B 42 50 89 45 F8 83 7D F8 03 77 5D 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 1C 25 6A F7 FF FF 83 C8 40 8B 4D 0C 89 41 1C EB 3D 8B 55 0C 8B 42 1C 25 2A F7 FF FF 8B 4D 0C 89 41 1C EB 2A 8B 55 0C 8B 42 1C 25 2B F7 FF FF 83 C8 01 8B 4D 0C 89 41 1C EB 14 8B 55 0C 8B 42 1C 25 6F F7 FF FF 83 C8 45 8B 4D 0C 89 41 1C E9 6D 02 00 00 8B 55 0C 8B 42 20 8B 48 50 89 4D F4 83 7D F4 03 0F 87 03 01 00 00 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 18 89 4D F0 83 7D F0 07 77 2D 8B 55 F0 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 FF FF FF FF EB 0D 8B 45 0C 8B 48 20 C7 41 50 00 00 00 00 E9 B8 00 00 00 8B 55 0C 8B 42 18 89 45 EC 83 7D EC 07 77 2D 8B 4D EC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF EB 0D 8B 55 0C 8B 42 20 C7 40 50 00 00 00 00 EB 7A 8B 4D 0C 8B 51 18 89 55 E8 83 7D E8 07 77 2D 8B 45 E8 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 20 C7 40 50 FF FF FF FF EB 0D 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 EB 3C 8B 45 0C 8B 48 18 89 4D E4 83 7D E4 07 77 2D 8B 55 E4 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 EB 0D 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF 8B 55 0C 8B 42 20 8B 48 50 89 4D E0 83 7D E0 03 0F 87 3E 01 00 00 8B 55 E0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 18 89 4D DC 83 7D DC 07 77 3B 8B 55 DC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 FF FF FF FF C7 42 54 FF FF FF FF EB 14 8B 45 0C 8B 48 20 C7 41 50 00 00 00 00 C7 41 54 00 00 00 00 E9 E5 00 00 00 8B 55 0C 8B 42 18 89 45 D8 83 7D D8 07 77 3B 8B 4D D8 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF C7 41 54 FF FF FF FF EB 14 8B 55 0C 8B 42 20 C7 40 50 00 00 00 00 C7 40 54 00 00 00 00 E9 96 00 00 00 8B 4D 0C 8B 51 18 89 55 D4 83 7D D4 07 77 3B 8B 45 D4 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 20 C7 40 50 FF FF FF FF C7 40 54 FF FF FF FF EB 14 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 C7 42 54 00 00 00 00 EB 4A 8B 45 0C 8B 48 18 89 4D D0 83 7D D0 07 77 3B 8B 55 D0 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 C7 42 54 00 00 00 00 EB 14 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF C7 41 54 FF FF FF FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 01 01 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 02 01 01 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 01 01 00 }
	condition:
		$1
}

rule file_32_26_0 {
	meta:
		name = "_DppxEmulationWrapper"
		size = 1202
		refs = "00cf _LoopDppxSimdValue"
	strings:
		$1 = { 55 8B EC 83 EC 38 56 57 C7 45 D0 00 00 00 00 8B 45 1C 8B 08 C1 E9 1E 83 E1 03 83 C1 01 89 4D F4 8B 55 0C 83 7A 28 6D 75 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 02 00 00 00 8B 45 F0 89 45 CC C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 CC 0F 87 AE 03 00 00 8B 45 0C 8B 48 28 89 4D EC 83 7D EC 48 74 26 83 7D EC 6D 74 02 EB 3A 83 7D F8 00 75 09 C7 45 E8 4D 00 00 00 EB 07 C7 45 E8 49 00 00 00 8B 55 E8 89 55 E0 EB 1C 83 7D F8 00 75 09 C7 45 E4 2F 00 00 00 EB 07 C7 45 E4 2B 00 00 00 8B 45 E4 89 45 E0 8B 4D E0 51 8B 55 F8 52 8B 45 F4 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 D0 8B 45 08 89 45 DC 83 7D DC 00 0F 84 DD 00 00 00 83 7D DC 01 74 05 E9 12 03 00 00 8B 4D F8 89 4D C8 83 7D C8 00 74 05 E9 BC 00 00 00 BA 08 00 00 00 6B D2 00 B8 08 00 00 00 6B C0 00 8B 4D 0C 8B 75 0C 8B BC 16 B0 00 00 00 89 7C 01 50 8B 94 16 B4 00 00 00 89 54 01 54 B8 08 00 00 00 C1 E0 00 B9 08 00 00 00 C1 E1 00 8B 55 0C 8B 75 0C 8B BC 06 B0 00 00 00 89 7C 0A 50 8B 84 06 B4 00 00 00 89 44 0A 54 B9 08 00 00 00 C1 E1 00 BA 08 00 00 00 6B D2 00 8B 45 0C 8B 75 0C 8B BC 0E B0 00 00 00 89 BC 10 80 00 00 00 8B 8C 0E B4 00 00 00 89 8C 10 84 00 00 00 BA 08 00 00 00 6B D2 00 B8 08 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B BC 16 B0 00 00 00 89 BC 01 80 00 00 00 8B 94 16 B4 00 00 00 89 94 01 84 00 00 00 E9 40 02 00 00 8B 45 F8 89 45 D8 83 7D D8 00 74 0F 83 7D D8 01 0F 84 1A 01 00 00 E9 25 02 00 00 B9 04 00 00 00 6B C9 00 BA 04 00 00 00 6B D2 00 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 4C 10 50 BA 04 00 00 00 C1 E2 00 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 01 50 B8 04 00 00 00 D1 E0 B9 04 00 00 00 D1 E1 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 44 0A 50 B9 04 00 00 00 6B C9 03 BA 04 00 00 00 6B D2 03 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 4C 10 50 BA 04 00 00 00 C1 E2 00 B8 04 00 00 00 6B C0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 01 80 00 00 00 B8 04 00 00 00 6B C0 00 B9 04 00 00 00 C1 E1 00 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 84 0A 80 00 00 00 B9 04 00 00 00 6B C9 03 BA 04 00 00 00 D1 E2 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 8C 10 80 00 00 00 BA 04 00 00 00 D1 E2 B8 04 00 00 00 6B C0 03 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 01 80 00 00 00 E9 10 01 00 00 B8 04 00 00 00 D1 E0 B9 04 00 00 00 6B C9 00 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 44 0A 50 B9 04 00 00 00 6B C9 03 BA 04 00 00 00 C1 E2 00 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 4C 10 50 BA 04 00 00 00 6B D2 00 B8 04 00 00 00 D1 E0 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 01 50 B8 04 00 00 00 C1 E0 00 B9 04 00 00 00 6B C9 03 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 44 0A 50 B9 04 00 00 00 C1 E1 00 BA 04 00 00 00 6B D2 00 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 8C 10 80 00 00 00 BA 04 00 00 00 6B D2 00 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 01 80 00 00 00 B8 04 00 00 00 6B C0 03 B9 04 00 00 00 D1 E1 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 84 0A 80 00 00 00 B9 04 00 00 00 D1 E1 BA 04 00 00 00 6B D2 03 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 8C 10 80 00 00 00 E9 3D FC FF FF 8B 55 08 89 55 D4 83 7D D4 00 74 55 83 7D D4 01 74 05 E9 87 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D F4 73 2E 8B 55 10 8B 42 18 8B 4D FC D3 E8 83 E0 01 75 1C 8B 4D FC 8B 55 0C C7 84 CA B0 00 00 00 00 00 00 00 C7 84 CA B4 00 00 00 00 00 00 00 EB C1 EB 3D C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D F4 73 23 8B 55 10 8B 42 18 8B 4D FC D3 E8 83 E0 01 75 11 8B 4D FC 8B 55 0C C7 84 8A B0 00 00 00 00 00 00 00 EB CC 8B 45 D0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_27_0 {
	meta:
		name = "_LoadOperand"
		size = 1248
		refs = "011b $LN42 03f1 $LN43 0470 $LN11 0474 $LN40 047c $LN16 0480 $LN17 0484 $LN18 0488 $LN20 0498 $LN22 049c $LN21 04a0 $LN12 04a4 $LN15 04ac $LN14 04b4 $LN19 04b8 $LN23 04bc $LN13 04c0 $LN8 04c4 $LN7 04c8 $LN6 04cc $LN5 04d4 $LN3 04d8 $LN2 04dc $LN1"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 14 8B 4D 0C 89 08 8B 55 14 83 3A 1F 75 14 8B 45 14 8B 48 20 83 E1 FE 8B 55 14 89 4A 20 E9 42 04 00 00 83 7D 0C 15 74 12 83 7D 0C 14 74 0C 83 7D 0C 17 74 06 83 7D 0C 1B 75 22 0F B6 45 08 85 C0 74 0F 83 7D 0C 14 75 09 8B 4D 14 C7 01 08 00 00 00 8B 55 14 8B 45 1C 89 42 04 EB 4A 0F B6 4D 08 85 C9 74 42 83 7D 0C 1F 74 3C 83 7D 0C 12 75 09 8B 55 14 C7 02 0D 00 00 00 83 7D 0C 13 75 09 8B 45 14 C7 00 19 00 00 00 83 7D 0C 0E 75 09 8B 4D 14 C7 01 0D 00 00 00 83 7D 0C 0C 75 09 8B 55 14 C7 02 0B 00 00 00 B8 01 00 00 00 6B C0 00 8B 4D 18 8D 94 01 CC 00 00 00 89 55 FC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 83 7D F0 04 73 10 8B 4D F0 8B 55 14 C7 44 8A 10 00 00 00 00 EB E1 8B 45 14 8B 48 20 83 C9 01 8B 55 14 89 4A 20 8B 45 14 8B 08 89 4D EC 8B 55 EC 83 EA 08 89 55 EC 83 7D EC 13 0F 87 57 03 00 00 8B 45 EC FF 24 85 ?? ?? ?? ?? 8B 4D 14 8B 51 20 83 E2 E1 83 CA 0A 8B 45 14 89 50 20 8B 4D FC 8B 55 14 83 C2 10 8B 41 10 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E9 14 03 00 00 8B 4D 14 8B 51 20 83 E2 E1 8B 45 14 89 50 20 8B 4D FC 8B 55 14 83 C2 10 8B 41 10 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E9 DE 02 00 00 8B 4D 14 8B 51 20 83 E2 E1 83 CA 02 8B 45 14 89 50 20 8B 4D FC 8B 55 14 83 C2 10 8B 41 10 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E9 A5 02 00 00 8B 4D 14 8B 51 20 83 E2 E1 8B 45 14 89 50 20 8B 4D FC 8B 51 10 8B 02 8B 4A 04 8B 55 14 89 42 10 89 4A 14 E9 7D 02 00 00 8B 45 14 8B 48 20 83 E1 E1 83 C9 02 8B 55 14 89 4A 20 8B 45 FC 8B 48 10 8B 11 8B 41 04 8B 4D 14 89 51 10 89 41 14 E9 52 02 00 00 8B 55 14 8B 42 20 83 E0 E1 8B 4D 14 89 41 20 8B 55 FC 8B 42 10 8B 4D 14 8B 10 89 51 10 E9 30 02 00 00 8B 45 14 8B 48 20 83 E1 E1 83 C9 0A 8B 55 14 89 4A 20 8B 45 FC 8B 48 10 8B 11 8B 41 04 8B 4D 14 89 51 10 89 41 14 E9 05 02 00 00 8B 55 14 8B 42 20 83 E0 E1 83 C8 0A 8B 4D 14 89 41 20 8B 55 FC 8B 42 10 8B 4D 14 8B 10 89 51 10 E9 E0 01 00 00 B8 10 00 00 00 6B C0 00 8B 4D FC 8D 94 01 A0 00 00 00 89 55 F8 8B 45 14 8B 48 20 83 E1 E1 8B 55 14 89 4A 20 8B 45 10 C1 E0 04 03 45 F8 89 45 F4 8B 4D 14 83 C1 10 8B 55 F4 8B 02 89 01 8B 42 04 89 41 04 8B 42 08 89 41 08 8B 52 0C 89 51 0C E9 8C 01 00 00 B8 10 00 00 00 6B C0 00 8B 4D FC 8D 94 01 A0 00 00 00 89 55 F8 8B 45 14 8B 48 20 83 E1 E1 83 C9 02 8B 55 14 89 4A 20 8B 45 10 C1 E0 04 03 45 F8 89 45 F4 8B 4D 14 83 C1 10 8B 55 F4 8B 02 89 01 8B 42 04 89 41 04 8B 42 08 89 41 08 8B 52 0C 89 51 0C E9 35 01 00 00 B8 10 00 00 00 6B C0 00 8B 4D FC 8D 94 01 A0 00 00 00 89 55 F8 8B 45 14 8B 48 20 83 E1 E1 83 C9 0A 8B 55 14 89 4A 20 8B 45 10 C1 E0 04 03 45 F8 89 45 F4 B9 04 00 00 00 6B C9 00 8B 55 14 8B 45 F4 8B 0C 08 89 4A 10 E9 E9 00 00 00 BA 10 00 00 00 6B D2 00 8B 45 FC 8D 4C 10 20 89 4D E4 8B 55 14 8B 42 20 83 E0 E1 83 C8 0A 8B 4D 14 89 41 20 8B 55 10 C1 E2 04 03 55 E4 89 55 E0 8B 45 E0 8B 08 8B 50 04 8B 45 14 89 48 10 89 50 14 E9 A3 00 00 00 8B 4D 14 8B 51 20 83 E2 E1 83 CA 0A 8B 45 14 89 50 20 8B 4D 10 89 4D E8 83 7D E8 07 0F 87 81 00 00 00 8B 55 E8 FF 24 95 ?? ?? ?? ?? 8B 45 14 8B 4D 18 8B 91 B0 00 00 00 89 50 10 EB 66 8B 45 14 8B 4D 18 8B 91 AC 00 00 00 89 50 10 EB 55 8B 45 14 8B 4D 18 8B 91 A8 00 00 00 89 50 10 EB 44 8B 45 14 8B 4D 18 8B 91 A4 00 00 00 89 50 10 EB 33 EB 31 8B 45 14 8B 4D 18 8B 91 B4 00 00 00 89 50 10 EB 20 8B 45 14 8B 4D 18 8B 91 A0 00 00 00 89 50 10 EB 0F 8B 45 14 8B 4D 18 8B 91 9C 00 00 00 89 50 10 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_28_0 {
	meta:
		name = "_LoopDppxSimdValue"
		size = 1351
		refs = "03ba __XMMI2_FP_Emulation 03d2 __XMMI_FP_Emulation"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 C7 45 F0 FF FF FF FF 8B 45 10 83 C0 04 89 45 F4 8B 4D 0C 83 C1 04 89 4D F8 C7 45 D8 04 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 3B 45 1C 0F 83 FA 04 00 00 83 7D 20 00 75 7C 8B 4D FC 03 4D D8 8B 55 10 8B 42 18 D3 E8 83 E0 01 75 69 8B 4D 08 89 4D EC 83 7D EC 00 74 26 83 7D EC 01 74 02 EB 2F 8B 55 FC 8B 45 0C C7 84 D0 B0 00 00 00 00 00 00 00 C7 84 D0 B4 00 00 00 00 00 00 00 EB 11 8B 4D FC 8B 55 0C C7 84 8A B0 00 00 00 00 00 00 00 8B 45 0C 8B 88 C0 00 00 00 83 C9 01 8B 55 0C 89 8A C0 00 00 00 8B 45 0C 8B 4D 10 8B 51 1C 89 50 30 E9 69 FF FF FF 8B 45 10 C7 40 04 00 00 00 00 8B 4D 14 8B 51 04 83 E2 FE 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 FD 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 FB 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 F7 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 EF 8B 45 14 89 50 04 8B 4D 14 8B 51 08 83 E2 FE 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 FD 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 FB 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 F7 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 EF 8B 45 14 89 50 08 8B 4D 14 8B 51 0C 83 E2 FE 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 FD 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 FB 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 F7 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 EF 8B 45 14 89 50 0C 8B 4D 10 8B 51 10 83 E2 03 8B 45 14 8B 08 83 E1 FC 0B CA 8B 55 14 89 0A 8B 45 10 8B 48 14 83 E1 07 C1 E1 02 8B 55 14 8B 02 83 E0 E3 0B C1 8B 4D 14 89 01 8B 55 24 81 E2 FF 0F 00 00 C1 E2 05 8B 45 14 8B 08 81 E1 1F 00 FE FF 0B CA 8B 55 14 89 0A 8B 45 0C 8B 48 60 83 E1 01 83 E1 01 8B 55 14 8B 42 20 83 E0 FE 0B C1 8B 4D 14 89 41 20 8B 55 0C 8B 42 60 D1 E8 83 E0 0F 83 E0 0F D1 E0 8B 4D 14 8B 51 20 83 E2 E1 0B D0 8B 45 14 89 50 20 8B 4D 08 89 4D E8 83 7D E8 00 74 21 83 7D E8 01 74 02 EB 29 8B 55 14 8B 45 FC 8B 4D 0C 8B 74 C1 50 89 72 10 8B 44 C1 54 89 42 14 EB 10 8B 4D 14 8B 55 FC 8B 45 0C 8B 54 90 50 89 51 10 8B 45 0C 8B 88 90 00 00 00 83 E1 01 74 46 8B 55 0C 8B 82 90 00 00 00 83 E0 01 83 E0 01 8B 4D 14 8B 51 40 83 E2 FE 0B D0 8B 45 14 89 50 40 8B 4D 0C 8B 91 90 00 00 00 D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 14 8B 48 40 83 E1 E1 0B CA 8B 55 14 89 4A 40 EB 0F 8B 45 14 8B 48 40 83 E1 FE 8B 55 14 89 4A 40 8B 45 08 89 45 E4 83 7D E4 00 74 27 83 7D E4 01 74 02 EB 32 8B 4D 14 8B 55 FC 8B 45 0C 8B B4 D0 80 00 00 00 89 71 30 8B 94 D0 84 00 00 00 89 51 34 EB 13 8B 45 14 8B 4D FC 8B 55 0C 8B 8C 8A 80 00 00 00 89 48 30 8B 55 14 8B 42 60 83 E0 FE 8B 4D 14 89 41 60 8B 55 08 89 55 E0 83 7D E0 00 74 27 83 7D E0 01 74 02 EB 32 8B 45 14 8B 4D FC 8B 55 0C 8B B4 CA B0 00 00 00 89 70 50 8B 8C CA B4 00 00 00 89 48 54 EB 13 8B 55 14 8B 45 FC 8B 4D 0C 8B 84 81 B0 00 00 00 89 42 50 8B 4D 0C 8B 91 C0 00 00 00 D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 14 8B 48 60 83 E1 E1 0B CA 8B 55 14 89 4A 60 8B 45 10 8B 4D 14 89 48 20 83 7D 08 01 74 06 83 7D 08 02 75 18 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 55 0C 89 44 8A 08 EB 16 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 55 0C 89 44 8A 08 8B 45 FC 8B 4D 0C 8B 55 10 8B 52 04 89 54 81 18 8B 45 FC 8B 4D 0C 83 7C 81 08 01 0F 85 B3 00 00 00 8B 55 F4 8B 02 C1 E8 05 83 E0 01 74 0D 8B 4D F8 8B 11 83 CA 20 8B 45 F8 89 10 8B 4D F4 8B 11 C1 EA 04 83 E2 01 74 0D 8B 45 F8 8B 08 83 C9 10 8B 55 F8 89 0A 8B 45 F4 8B 08 C1 E9 03 83 E1 01 74 0D 8B 55 F8 8B 02 83 C8 08 8B 4D F8 89 01 8B 55 F4 8B 02 C1 E8 02 83 E0 01 74 0D 8B 4D F8 8B 11 83 CA 04 8B 45 F8 89 10 8B 4D F4 8B 11 D1 EA 83 E2 01 74 0D 8B 45 F8 8B 08 83 C9 02 8B 55 F8 89 0A 8B 45 F4 8B 08 83 E1 01 74 0D 8B 55 F8 8B 02 83 C8 01 8B 4D F8 89 01 8B 55 14 52 FF 55 18 83 C4 04 89 45 F0 83 7D F0 FF 74 08 8B 45 F0 E9 8B 00 00 00 8B 45 14 8B 48 60 83 E1 01 83 E1 01 8B 55 0C 8B 82 C0 00 00 00 83 E0 FE 0B C1 8B 4D 0C 89 81 C0 00 00 00 8B 55 0C 8B 45 10 8B 48 1C 89 4A 30 8B 55 0C 8B 82 C0 00 00 00 83 E0 01 74 46 8B 4D 08 89 4D DC 83 7D DC 00 74 27 83 7D DC 01 74 02 EB 32 8B 55 FC 8B 45 0C 8B 4D 14 8B 71 50 89 B4 D0 B0 00 00 00 8B 49 54 89 8C D0 B4 00 00 00 EB 13 8B 55 FC 8B 45 0C 8B 4D 14 8B 49 50 89 8C 90 B0 00 00 00 E9 F1 FA FF FF 8B 45 F0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_29_0 {
	meta:
		name = "_SetPniOperation"
		size = 264
		refs = "0029 $LN17 0030 $LN18 00c4 $LN9 00c8 $LN4 00cc $LN2 00d0 $LN12 00d4 $LN5 00d8 $LN3 00dc $LN1"
	strings:
		$1 = { 55 8B EC 83 EC 08 C6 45 FF 00 8B 45 08 89 45 F8 8B 4D F8 83 E9 43 89 4D F8 83 7D F8 27 0F 87 93 00 00 00 8B 55 F8 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7D 10 00 75 0B 8B 4D 0C C7 01 4B 00 00 00 EB 09 8B 55 0C C7 02 49 00 00 00 C6 45 FF 01 EB 66 83 7D 10 00 74 06 83 7D 10 02 75 0B 8B 45 0C C7 00 2D 00 00 00 EB 09 8B 4D 0C C7 01 2B 00 00 00 C6 45 FF 01 EB 40 8B 55 0C C7 02 49 00 00 00 C6 45 FF 01 EB 31 8B 45 0C C7 00 2B 00 00 00 C6 45 FF 01 EB 22 8B 4D 0C C7 01 4B 00 00 00 C6 45 FF 01 EB 13 8B 55 0C C7 02 2D 00 00 00 C6 45 FF 01 EB 04 C6 45 FF 00 8A 45 FF 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 02 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 03 04 05 }
	condition:
		$1
}

rule file_32_30_0 {
	meta:
		name = "_UpdateResult"
		size = 576
		refs = "006c $LN24 0073 $LN25 0158 $LN26 01e4 $LN12 01e8 $LN1 01ec $LN15 01f0 $LN16 01f4 $LN17 01f8 $LN18 01fc $LN19 0200 $LN13 0204 $LN14 0208 $LN22 0220 $LN9 0224 $LN8 0228 $LN7 022c $LN6 0234 $LN4 0238 $LN3 023c $LN2"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 45 08 8B 48 04 89 4D F4 BA 01 00 00 00 6B D2 00 8B 45 0C 8D 8C 10 CC 00 00 00 89 4D FC BA 10 00 00 00 6B D2 00 8B 45 FC 8D 8C 10 A0 00 00 00 89 4D EC BA 10 00 00 00 6B D2 00 8B 45 FC 8D 4C 10 20 89 4D E8 8B 55 08 8B 02 89 45 F8 8B 4D F8 83 E9 08 89 4D F8 83 7D F8 13 0F 87 79 01 00 00 8B 55 F8 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 08 83 C1 10 8B 55 FC 8B 42 10 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 41 01 00 00 8B 55 08 8B 42 10 8B 4A 14 8B 55 FC 8B 52 10 89 02 89 4A 04 E9 28 01 00 00 8B 45 FC 8B 48 10 8B 55 08 8B 42 10 89 01 E9 15 01 00 00 8B 4D 08 8B 51 10 8B 41 14 8B 4D FC 8B 49 10 89 11 89 41 04 E9 FC 00 00 00 8B 55 FC 8B 42 10 8B 4D 08 8B 51 10 89 10 E9 E9 00 00 00 8B 45 08 83 C0 10 8B 4D F4 C1 E1 04 03 4D EC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C E9 BF 00 00 00 8B 4D F4 C1 E1 04 03 4D E8 89 4D E4 8B 55 08 8B 42 10 8B 4A 14 8B 55 E4 89 02 89 4A 04 E9 9D 00 00 00 8B 45 F4 89 45 F0 83 7D F0 07 0F 87 81 00 00 00 8B 4D F0 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 45 08 8B 48 10 89 8A B0 00 00 00 EB 66 8B 55 0C 8B 45 08 8B 48 10 89 8A AC 00 00 00 EB 55 8B 55 0C 8B 45 08 8B 48 10 89 8A A8 00 00 00 EB 44 8B 55 0C 8B 45 08 8B 48 10 89 8A A4 00 00 00 EB 33 EB 31 8B 55 0C 8B 45 08 8B 48 10 89 8A B4 00 00 00 EB 20 8B 55 0C 8B 45 08 8B 48 10 89 8A A0 00 00 00 EB 0F 8B 55 0C 8B 45 08 8B 48 10 89 8A 9C 00 00 00 8B 55 0C 8B 45 10 89 82 C0 00 00 00 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 09 02 03 04 05 09 09 09 06 06 07 08 09 08 09 05 06 08 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_31_0 {
	meta:
		name = "__fpieee_flt_simd"
		size = 8977
		refs = "0019 __sehtable$__fpieee_flt_simd 001e __except_handler4 0035 ___security_cookie 0104 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0110 ??_C@_1II@FNOCMDLL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0117 __CrtDbgReportW 0228 $LN242 022f $LN250 06cb $LN251 06d5 _InstInfoTable5X 06e4 _InstInfoTableCX 06f3 _InstInfoTable2X 0702 _InstInfoTableEX 0711 _InstInfoTableDX 0735 _InstInfoTable7X 07f1 _InstInfoTable0X 07fd _InstInfoTable4X 0a3c _InstInfoTableX 0b7c $LN243 0b83 $LN252 0bde ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 0be3 ??_C@_0N@MDJJJHMB@kernel32?4dll?$AA@ 0be9 __imp__GetModuleHandleA@4 0bf0 __imp__GetProcAddress@8 0bfb ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 0c18 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 0e13 _modrm32 107f _LoadOperand 1245 $LN253 1373 _DppxEmulationWrapper 14ea _SetPniOperation 17a9 $LN244 17b0 $LN254 1aaa $LN245 1ab1 $LN255 1ba0 $LN246 1ba7 $LN256 1c44 __XMMI2_FP_Emulation 1c62 __XMMI_FP_Emulation 1e94 _AdjustExceptionResult 1f5d $LN247 1f64 $LN257 1fd6 _UpdateResult 212f @__security_check_cookie@4 213c $LN200 2140 $LN202 2144 $LN185 2148 $LN199 214c $LN189 2150 $LN201 2154 $LN203 2158 $LN184 222c $LN172 2230 $LN166 2234 $LN157 2238 $LN174 2240 $LN168 2254 $LN173 2258 $LN170 225c $LN171 2260 $LN126 2264 $LN130 22a4 $LN99 22a8 $LN98 22ac $LN97 22b0 $LN96 22b4 $LN67 22b8 $LN65 22bc $LN66 22cc $LN44 22d0 $LN42 22d4 $LN43 22e4 $LN34 22e8 $LN32 22ec $LN33 22fc $LN7 2300 $LN6 2304 $LN5"
	strings:
		$1 = { 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 51 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 DC 56 57 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 85 B4 FD FF FF FF FF FF FF C6 85 E3 FD FF FF 00 C7 85 EC FD FF FF 00 00 00 00 C7 85 84 FD FF FF 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 85 BC FD FF FF 00 00 00 00 C6 85 77 FD FF FF 00 8B 43 0C 8B 08 89 8D DC FC FF FF 8B 95 DC FC FF FF 83 C2 14 89 95 4C FD FF FF B8 04 00 00 00 6B C0 00 8B 8D 4C FD FF FF 83 3C 01 00 74 1D BA 04 00 00 00 6B D2 00 8B 85 4C FD FF FF 8B 0C 10 51 FF 53 10 83 C4 04 E9 41 20 00 00 8B 53 0C 8B 42 04 89 85 E4 FD FF FF 8B 8D E4 FD FF FF 8B 11 81 E2 20 00 01 00 81 FA 20 00 01 00 74 30 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 C1 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 E9 F1 1F 00 00 EB 36 BA 01 00 00 00 6B D2 00 8B 85 E4 FD FF FF 8D 8C 10 CC 00 00 00 89 8D C4 FD FF FF BA 10 00 00 00 6B D2 00 8B 85 C4 FD FF FF 8D 8C 10 A0 00 00 00 89 8D BC FC FF FF 8B 95 C4 FD FF FF 8B 42 10 89 85 B4 FC FF FF C7 85 F0 FD FF FF 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C6 85 0E FE FF FF 00 C7 45 FC 00 00 00 00 C6 85 EA FD FF FF 01 C6 85 0F FE FF FF 00 C6 85 F6 FD FF FF 00 8A 8D F6 FD FF FF 88 8D E9 FD FF FF 8B 95 E4 FD FF FF 8B 82 B8 00 00 00 89 85 F8 FD FF FF 0F B6 8D EA FD FF FF 85 C9 0F 84 48 03 00 00 8B 95 F8 FD FF FF 8A 02 88 85 EB FD FF FF 8B 8D F8 FD FF FF 83 C1 01 89 8D F8 FD FF FF 0F B6 95 EB FD FF FF 89 95 88 FD FF FF 8B 85 88 FD FF FF 83 E8 26 89 85 88 FD FF FF 81 BD 88 FD FF FF CD 00 00 00 0F 87 F3 02 00 00 8B 8D 88 FD FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C6 85 0F FE FF FF 01 8B 85 EC FD FF FF 83 C0 01 89 85 EC FD FF FF E9 CB 02 00 00 C7 85 F0 FD FF FF 01 00 00 00 8B 8D EC FD FF FF 83 C1 01 89 8D EC FD FF FF E9 AD 02 00 00 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 8B 95 EC FD FF FF 83 C2 01 89 95 EC FD FF FF E9 88 02 00 00 C6 85 0E FE FF FF 01 E9 7C 02 00 00 C6 85 F6 FD FF FF 01 8B 85 F8 FD FF FF 8A 08 88 8D FF FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 8A 08 88 8D F7 FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 0F B6 85 F7 FD FF FF 83 E0 03 83 F8 01 75 0A C7 85 F0 FD FF FF 01 00 00 00 0F B6 8D F7 FD FF FF 83 E1 03 83 F9 02 75 07 C6 85 0F FE FF FF 01 0F B6 95 F7 FD FF FF 83 E2 03 83 FA 03 75 11 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 0F B6 85 F7 FD FF FF 83 E0 04 74 0C C7 85 40 FD FF FF 01 00 00 00 EB 0A C7 85 40 FD FF FF 00 00 00 00 8A 8D 40 FD FF FF 88 8D E3 FD FF FF 0F B6 95 F7 FD FF FF C1 FA 03 83 E2 0F 83 F2 0F 89 95 3C FD FF FF 0F B6 85 F7 FD FF FF C1 F8 07 89 85 B0 FC FF FF 0F B6 8D FF FD FF FF 83 E1 0F 89 8D F4 FC FF FF 8B 95 F4 FC FF FF 89 95 64 FD FF FF 83 BD 64 FD FF FF 01 74 14 83 BD 64 FD FF FF 02 74 14 83 BD 64 FD FF FF 03 74 14 EB 1B C6 85 F5 FD FF FF 0F EB 55 C6 85 F5 FD FF FF 38 EB 4C C6 85 F5 FD FF FF 3A EB 43 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 3D 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 C8 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 C8 FC FF FF E9 04 1D 00 00 8B 95 EC FD FF FF 83 C2 02 89 95 EC FD FF FF C6 85 EA FD FF FF 00 E9 E6 00 00 00 C6 85 E9 FD FF FF 01 8B 85 F8 FD FF FF 8A 08 88 8D FF FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 0F B6 85 FF FD FF FF 83 E0 03 83 F8 01 75 0A C7 85 F0 FD FF FF 01 00 00 00 0F B6 8D FF FD FF FF 83 E1 03 83 F9 02 75 07 C6 85 0F FE FF FF 01 0F B6 95 FF FD FF FF 83 E2 03 83 FA 03 75 11 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 0F B6 85 FF FD FF FF 83 E0 04 74 0C C7 85 2C FD FF FF 01 00 00 00 EB 0A C7 85 2C FD FF FF 00 00 00 00 8A 8D 2C FD FF FF 88 8D E3 FD FF FF 0F B6 95 FF FD FF FF C1 FA 03 83 E2 0F 83 F2 0F 89 95 3C FD FF FF C6 85 F5 FD FF FF 0F 8B 85 EC FD FF FF 83 C0 01 89 85 EC FD FF FF C6 85 EA FD FF FF 00 EB 10 C6 85 0E FE FF FF 01 EB 07 C6 85 EA FD FF FF 00 E9 A9 FC FF FF C7 45 FC FE FF FF FF E9 89 00 00 00 8B 5D E4 8B 4D EC 8B 11 8B 02 89 85 C0 FC FF FF 81 BD C0 FC FF FF 05 00 00 C0 75 0C C7 85 28 FD FF FF 01 00 00 00 EB 0A C7 85 28 FD FF FF 00 00 00 00 8B 85 28 FD FF FF C3 8B 5D E4 8B 65 E8 33 C9 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 70 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 B8 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 B8 FC FF FF E9 70 1B 00 00 C7 45 FC FE FF FF FF 0F B6 85 0E FE FF FF 85 C0 74 2E 33 C9 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 7B 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 E9 30 1B 00 00 C7 45 FC 01 00 00 00 8B 85 F8 FD FF FF 89 85 DC FD FF FF 8B 8D DC FD FF FF 8B 11 83 E2 0F 89 95 AC FD FF FF 8B 85 DC FD FF FF 8B 08 C1 E9 04 83 E1 0F 89 8D 90 FD FF FF 0F B6 95 E9 FD FF FF 85 D2 75 0B 0F B6 85 F6 FD FF FF 85 C0 74 34 0F B6 8D F5 FD FF FF 83 F9 0F 74 1A C7 85 90 FD FF FF 03 00 00 00 0F B6 95 F5 FD FF FF 83 E2 0F 89 95 AC FD FF FF 8B 85 3C FD FF FF 89 85 BC FD FF FF EB 2C 8B 8D DC FD FF FF 8B 11 C1 EA 0B 83 E2 07 89 95 BC FD FF FF 0F B6 85 EB FD FF FF 83 F8 0F 74 0C C6 85 0E FE FF FF 01 E9 DD 07 00 00 8B 8D 90 FD FF FF 89 8D 98 FD FF FF 8B 95 98 FD FF FF 83 EA 02 89 95 98 FD FF FF 83 BD 98 FD FF FF 0C 0F 87 5D 01 00 00 8B 85 98 FD FF FF FF 24 85 ?? ?? ?? ?? C7 85 CC FD FF FF ?? ?? ?? ?? E9 4D 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 3E 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 2F 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 20 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? 0F B6 8D 0F FE FF FF 85 C9 74 0A C7 85 F0 FD FF FF 00 00 00 00 E9 FC 00 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? 0F B6 95 0F FE FF FF 85 D2 74 0A C7 85 F0 FD FF FF 00 00 00 00 E9 D8 00 00 00 83 BD AC FD FF FF 0A 0F 85 B1 00 00 00 C7 85 A4 FD FF FF 01 00 00 00 0F B6 85 E9 FD FF FF 0F B6 8D F6 FD FF FF 0B C1 75 1E 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 EC FD FF FF 83 C0 01 89 85 EC FD FF FF 8B 8D F8 FD FF FF 89 8D DC FD FF FF 8B 95 DC FD FF FF 8B 02 83 E0 0F 89 85 AC FD FF FF 8B 8D DC FD FF FF 8B 11 C1 EA 04 83 E2 0F 89 95 90 FD FF FF 8B 85 90 FD FF FF 89 85 54 FD FF FF 83 BD 54 FD FF FF 00 74 0B 83 BD 54 FD FF FF 04 74 0E EB 18 C7 85 CC FD FF FF ?? ?? ?? ?? EB 18 C7 85 CC FD FF FF ?? ?? ?? ?? EB 0C C6 85 0E FE FF FF 01 E9 68 06 00 00 EB 0C C6 85 0E FE FF FF 01 E9 5A 06 00 00 EB 0C C6 85 0E FE FF FF 01 E9 4C 06 00 00 8B 8D DC FD FF FF 8B 11 C1 EA 0E 83 E2 03 83 FA 03 75 0C C7 85 38 FD FF FF 00 00 00 00 EB 0A C7 85 38 FD FF FF 01 00 00 00 8A 85 38 FD FF FF 88 85 D3 FD FF FF 0F B6 8D D3 FD FF FF C1 E1 04 0B 8D AC FD FF FF 89 8D 08 FE FF FF 83 BD 08 FE FF FF 20 76 0C C6 85 0E FE FF FF 01 E9 EC 05 00 00 83 BD A4 FD FF FF 01 0F 85 39 01 00 00 8B 95 08 FE FF FF 8B 85 CC FD FF FF 8D 0C 90 89 8D 04 FE FF FF 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 6B 74 26 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 6C 74 13 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 6D 75 0C C7 85 F0 FD FF FF 01 00 00 00 EB 50 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 46 74 26 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 47 74 13 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 48 75 0C C7 85 F0 FD FF FF 00 00 00 00 EB 0C C6 85 0E FE FF FF 01 E9 36 05 00 00 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 6B 74 38 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 46 74 25 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 6D 74 12 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 48 75 09 C6 85 0F FE FF FF 00 EB 3B 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 6C 74 13 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 47 75 09 C6 85 0F FE FF FF 01 EB 0C C6 85 0E FE FF FF 01 E9 A8 04 00 00 EB 1E 8B 95 08 FE FF FF 8B 85 F0 FD FF FF 8D 0C 50 8B 95 CC FD FF FF 8D 04 8A 89 85 04 FE FF FF 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 75 0E C6 85 0E FE FF FF 01 E9 6C 04 00 00 EB 67 8B 85 04 FE FF FF 8B 08 C1 E9 0C 83 E1 1F 83 F9 1E 75 54 0F B6 95 0F FE FF FF 85 D2 74 1D 8B 85 04 FE FF FF 8B 08 C1 E9 11 83 E1 1F 8D 14 8D ?? ?? ?? ?? 89 95 04 FE FF FF EB 1B 8B 85 04 FE FF FF 8B 08 C1 E9 11 83 E1 1F 8D 14 8D ?? ?? ?? ?? 89 95 04 FE FF FF C6 85 0F FE FF FF 00 C7 85 F0 FD FF FF 02 00 00 00 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 43 74 25 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 44 74 13 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 45 75 07 C6 85 0F FE FF FF 00 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 68 74 25 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 69 74 13 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 6A 75 0A C7 85 F0 FD FF FF 01 00 00 00 83 BD A4 FD FF FF 00 75 1F 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 0F B6 95 0F FE FF FF 03 CA 89 8D 38 FE FF FF EB 14 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 89 8D 38 FE FF FF 0F B6 95 E9 FD FF FF 85 D2 75 0B 0F B6 85 F6 FD FF FF 85 C0 74 54 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 89 95 94 FD FF FF 8B 85 94 FD FF FF 83 E8 33 89 85 94 FD FF FF 83 BD 94 FD FF FF 38 77 28 8B 8D 94 FD FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 85 DC FD FF FF 8B 08 C1 E9 0B 83 E1 07 89 8D BC FD FF FF 8B 95 EC FD FF FF 83 C2 03 89 95 EC FD FF FF C7 85 C8 FD FF FF 00 00 00 00 0F B6 85 E3 FD FF FF 85 C0 0F 84 D8 01 00 00 8B 8D E4 FD FF FF 8B 11 81 E2 40 00 01 00 81 FA 40 00 01 00 0F 85 BE 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 E4 FC FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 CC FC FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 70 FD FF FF 83 BD 70 FD FF FF 00 75 43 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 DE 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 C4 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 C4 FC FF FF E9 9C 14 00 00 FF 95 E4 FC FF FF 89 85 F8 FC FF FF 89 95 FC FC FF FF 8B 95 F8 FC FF FF 83 E2 04 8B 85 FC FC FF FF 83 E0 00 89 95 D0 FC FF FF 89 85 D4 FC FF FF 8B 8D D0 FC FF FF 0B 8D D4 FC FF FF 75 43 33 D2 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 E9 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 E8 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 E8 FC FF FF E9 1B 14 00 00 8D 8D F8 FC FF FF 51 8B 95 E4 FD FF FF 52 FF 95 CC FC FF FF 85 C0 75 43 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 F3 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 E0 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 E0 FC FF FF E9 C0 13 00 00 8D 95 AC FC FF FF 52 6A 01 8B 85 E4 FD FF FF 50 FF 95 70 FD FF FF 89 85 D8 FD FF FF 6A 00 6A 02 8B 8D E4 FD FF FF 51 FF 95 70 FD FF FF 89 85 C8 FD FF FF C7 85 80 FD FF FF 02 00 00 00 EB 16 8B 95 BC FC FF FF 89 95 D8 FD FF FF C7 85 80 FD FF FF 01 00 00 00 0F B6 85 D3 FD FF FF 85 C0 74 66 8B 8D DC FD FF FF 89 8D F8 FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 8A 08 88 8D EB FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 50 8B 8D E4 FD FF FF 51 8D 95 7C FD FF FF 52 0F B6 85 EB FD FF FF 8B 0C 85 ?? ?? ?? ?? FF D1 83 C4 0C 89 85 84 FD FF FF 8B 95 EC FD FF FF 03 95 84 FD FF FF 89 95 EC FD FF FF 8B 85 04 FE FF FF 8B 08 C1 E9 16 83 E1 07 83 F9 01 75 30 8B 95 F8 FD FF FF 03 95 84 FD FF FF 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 0F B6 08 89 8D 3C FE FF FF 8B 95 EC FD FF FF 83 C2 01 89 95 EC FD FF FF C7 45 FC FE FF FF FF E9 89 00 00 00 8B 5D E4 8B 45 EC 8B 08 8B 11 89 95 D8 FC FF FF 81 BD D8 FC FF FF 05 00 00 C0 75 0C C7 85 60 FD FF FF 01 00 00 00 EB 0A C7 85 60 FD FF FF 00 00 00 00 8B 85 60 FD FF FF C3 8B 5D E4 8B 65 E8 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 33 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 F0 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 F0 FC FF FF E9 17 12 00 00 C7 45 FC FE FF FF FF C7 85 B8 FD FF FF 00 00 00 00 EB 0F 8B 95 B8 FD FF FF 83 C2 01 89 95 B8 FD FF FF 8B 85 B8 FD FF FF 3B 85 80 FD FF FF 0F 8D A9 10 00 00 83 BD B8 FD FF FF 00 0F 84 F6 00 00 00 C7 85 00 FE FF FF 00 00 00 00 EB 0F 8B 8D 00 FE FF FF 83 C1 01 89 8D 00 FE FF FF 83 BD 00 FE FF FF 08 0F 8D BA 00 00 00 8B 95 00 FE FF FF C1 E2 04 8B 85 00 FE FF FF C1 E0 04 8B 8D D8 FD FF FF 8B 34 11 89 B4 05 50 FF FF FF 8B 54 11 04 89 94 05 54 FF FF FF 8B 85 00 FE FF FF C1 E0 04 8B 8D 00 FE FF FF C1 E1 04 8B 95 D8 FD FF FF 8B 74 02 08 89 B4 0D 58 FF FF FF 8B 44 02 0C 89 84 0D 5C FF FF FF 8B 8D 00 FE FF FF C1 E1 04 8B 95 00 FE FF FF C1 E2 04 8B 85 D8 FD FF FF 8B B5 C8 FD FF FF 8B 3C 0E 89 3C 10 8B 4C 0E 04 89 4C 10 04 8B 95 00 FE FF FF C1 E2 04 8B 85 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__except_handler3"
		size = 254
		refs = "0035 __ValidateEH3RN 007a _CallDestructExceptionObject 0086 __global_unwind2 0093 __local_unwind2 00a4 __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 C3 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 0F 8E 8F 00 00 00 83 FE FF 0F 84 8D 00 00 00 8D 0C 76 8B 44 8F 04 0B C0 74 66 56 55 8D 6B 10 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 5D 5E 8B 5D 0C 0B C0 74 4C 78 58 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 08 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C 8B 44 8F 08 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 8B 7B 08 8D 0C 76 8B 34 8F E9 78 FF FF FF B8 00 00 00 00 EB 23 8B 45 08 83 48 04 08 B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__controlfp_s"
		size = 227
		refs = "002e __control87 005b ??_C@_1DG@JNDMIEJL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0060 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0069 ??_C@_1HI@JIOCECAH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0070 __CrtDbgReportW 0084 __errno 0098 ??_C@_1BK@CDOALEA@?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA_?$AAs?$AA?$AA@ 00a2 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 10 25 FF FF F7 FF 89 45 10 8B 4D 0C 23 4D 10 81 E1 E0 FC F0 FC 0F 84 8D 00 00 00 83 7D 08 00 74 11 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 33 C0 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2F 83 7D 08 00 74 17 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 EB 10 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "__stripquote"
		size = 180
		refs = "0013 ??_C@_0DB@BPDMLIHG@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0020 _strlen 002c __calloc_dbg 00a7 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 68 10 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 04 33 C0 EB 70 8B 4D FC 89 4D F4 8B 55 08 0F BE 02 85 C0 74 3D 8B 4D 08 0F BE 11 83 FA 22 75 14 8B 45 08 83 C0 01 89 45 08 8B 4D F8 83 C1 01 89 4D F8 EB 1C 8B 55 FC 8B 45 08 8A 08 88 0A 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 83 C0 01 89 45 08 EB B9 83 7D F8 00 74 0D 8B 4D FC C6 01 00 8B 45 F4 EB 12 EB 10 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_3_0 {
	meta:
		name = "__tempnam"
		size = 27
		refs = "0012 __tempnam_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_232_57_0 {
	meta:
		name = "__nh_malloc"
		size = 27
		refs = "0012 __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_754_3_0 {
	meta:
		name = "__wtempnam"
		size = 27
		refs = "0012 __wtempnam_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_38_4_0 {
	meta:
		name = "__tempnam_dbg"
		size = 1022
		refs = "0006 __sehtable$__tempnam_dbg 000b __except_handler4 001d ___security_cookie 0056 __mtinitlocknum 006d ??_C@_1GC@LAGBNMD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0072 ??_C@_1BK@GFOMIAGH@?$AA_?$AAt?$AAe?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0077 ??_C@_1NM@LBPNFNDK@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 0082 ??_C@_0DB@BPDMLIHG@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0089 ??_C@_03FICNPLNB@TMP?$AA@ 0094 __dupenv_s_dbg 009d __invoke_watson_if_oneof 00b5 __access_s 00d9 __stripquote 011e ??_C@_01KICIPPFI@?2?$AA@ 013a ??_C@_01LFCBOECM@?4?$AA@ 0149 _strlen 017c __calloc_dbg 01a9 ??_C@_1DE@PMKKLKPC@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAs?$AA?0?$AA?5?$AAb?$AAu?$AAf?$AAs?$AAz?$AA?0?$AA?5?$AAd?$AAi?$AAr?$AA?5?$AA?$CJ?$AA?$AA@ 01ba _strcat_s 01c3 __invoke_watson_if_error 01f2 __mbsrchr 0210 ??_C@_1DG@NBELFNDG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAs?$AA?0?$AA?5?$AAb?$AAu?$AAf?$AAs?$AAz?$AA?0?$AA?5?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?5?$AA?$CJ?$AA?$AA@ 028b ??_C@_1DE@JDHPCLDE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAs?$AA?0?$AA?5?$AAb?$AAu?$AAf?$AAs?$AAz?$AA?0?$AA?5?$AAp?$AAf?$AAx?$AA?5?$AA?$CJ?$AA?$AA@ 02c1 __lock 02d1 __old_pfxlen 02dc __tempoff 02f6 __errno 032c _free 034e ??_C@_1IA@CLGKKMJF@?$AA_?$AAu?$AAl?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?$CJ?$AA_?$AAt?$AAe?$AAm?$AAp?$AAo?$AAf@ 036b __ultoa_s 03c5 __unlock 03d4 __free_dbg"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D4 00 00 00 00 C7 45 D8 00 00 00 00 6A 02 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 07 33 C0 E9 84 03 00 00 6A 00 6A 6B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 6B 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 26 83 7D D8 00 74 20 6A 00 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 0E 8B 55 D8 89 55 E0 8B 45 E0 89 45 08 EB 70 83 7D E0 00 74 2F 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 83 7D D4 00 74 1A 6A 00 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 08 8B 45 D4 89 45 08 EB 3B 83 7D 08 00 74 12 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 23 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 09 C7 45 08 ?? ?? ?? ?? EB 07 C7 45 08 ?? ?? ?? ?? 83 7D 0C 00 74 0F 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D D0 8D 54 08 0C 89 55 DC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 01 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 05 E9 3C 02 00 00 8B 4D E4 C6 01 00 6A 00 68 99 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 8B 45 DC 50 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8D 54 01 FF 89 55 CC 8B 45 CC 0F BE 08 83 F9 5C 75 49 6A 5C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 39 45 CC 74 34 6A 00 68 A0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 DC 50 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 3F 8B 55 CC 0F BE 02 83 F8 2F 74 34 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D DC 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 0C 00 74 33 6A 00 68 AD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 0C 50 8B 4D DC 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 E4 89 45 E0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 0D ?? ?? ?? ?? 3B 4D D0 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B 55 D0 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 C4 E8 ?? ?? ?? ?? 8B 08 89 4D C8 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B 45 C4 3D FF FF FF 7F 76 1F E8 ?? ?? ?? ?? 8B 4D C8 89 08 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 E4 00 00 00 00 EB 78 6A 00 68 D0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 8B 45 E0 2B 45 E4 8B 4D DC 2B C8 51 8B 55 E0 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? C7 00 00 00 00 00 6A 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 63 FF FF FF E8 ?? ?? ?? ?? 83 38 0D 0F 84 55 FF FF FF E8 ?? ?? ?? ?? 8B 55 C8 89 10 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C3 6A 02 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "__pclose"
		size = 405
		refs = "0006 __sehtable$__pclose 000b __except_handler4 001d ___security_cookie 005a ??_C@_1CE@LJKJAHN@?$AA?$CI?$AAp?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006b ??_C@_1FO@GHLFGGJE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0072 __CrtDbgReportW 0086 __errno 009d ??_C@_1BA@KDAKDIPO@?$AA_?$AAp?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 00a7 __invalid_parameter 00b9 __mtinitlocknum 00cf __lock 00e2 _idtab 0104 _fclose 012e __cwait 0178 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 D8 FF FF FF FF 83 7D 08 00 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 89 45 DC 83 7D DC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C8 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C8 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CD 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 08 83 C8 FF E9 B7 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 68 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 08 89 4D D0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 6A 01 8B 55 E4 8B 42 04 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 0A E8 ?? ?? ?? ?? 83 38 04 75 06 8B 55 D4 89 55 D8 E8 ?? ?? ?? ?? 8B 4D D0 89 08 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 C7 40 04 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "__popen"
		size = 2769
		refs = "0006 __sehtable$__popen 000b __except_handler4 0020 ___security_cookie 00ad ??_C@_1CI@KEGLLDHA@?$AA?$CI?$AAc?$AAm?$AAd?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00b2 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00be ??_C@_1FO@GHLFGGJE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00c5 __CrtDbgReportW 00dc __errno 00f3 ??_C@_1O@HEONKIBD@?$AA_?$AAp?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 00fd __invalid_parameter 0134 ??_C@_1BO@FNGOKJKH@?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ea ??_C@_1FG@PLKOLFIL@?$AA?$CI?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AAw?$AA?8?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN@ 02c4 ??_C@_1HG@CICOIJEK@?$AA?$CI?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AAt@ 0381 __pipe 03d3 __mtinitlocknum 03ec __close 0412 __lock 0442 __imp__GetCurrentProcess@0 0471 ___pioinfo 047f __imp__DuplicateHandle@28 04b4 __fdopen 04cc _idtab 04f3 ??_C@_1OA@NFNDPBHB@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 0501 ??_C@_0CP@FGKFGAJD@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0508 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0513 __dupenv_s_dbg 051c __invoke_watson_if_oneof 0530 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 0548 _memset 05e0 _strlen 05ea ??_C@_04NPFIMJFF@?5?1c?5?$AA@ 061e __calloc_dbg 0645 ??_C@_1FO@BAEKHEKF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 0656 _strcpy_s 065f __invoke_watson_if_error 0678 ??_C@_1FO@GNCHDDLF@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 068a _strcat_s 06ac ??_C@_1GE@LPBCCHLN@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 06f1 __access_s 0720 __imp__CreateProcessA@40 0768 __free_dbg 07b3 ??_C@_1NM@MDJOLMEP@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAP?$AAa?$AAt?$AAh?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK@ 07c8 ??_C@_04HBHDLLBA@PATH?$AA@ 0849 __getpath 0893 __mbsrchr 08b1 ??_C@_1DC@INHIHLBE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 08b6 ??_C@_01KICIPPFI@?2?$AA@ 094c ??_C@_1DG@DHDDFIJF@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAc?$AAm?$AAd?$AAe?$AAx?$AAe?$AA?$CJ?$AA?$AA@ 09fb __imp__CloseHandle@4 0a56 _fclose 0ab4 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 C4 10 FF FF FF 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 C4 00 00 00 00 C7 45 B4 00 00 00 00 C7 45 CC 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 C0 00 00 00 00 C6 45 E0 00 C6 45 E1 00 C6 45 E2 00 C7 45 B8 00 00 00 00 C7 85 48 FF FF FF 00 00 00 00 C7 85 4C FF FF FF 00 00 00 00 83 7D 08 00 74 09 C7 45 94 01 00 00 00 EB 07 C7 45 94 00 00 00 00 8B 45 94 89 85 64 FF FF FF 83 BD 64 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 93 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 64 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 93 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B4 09 00 00 83 7D 0C 00 74 09 C7 45 8C 01 00 00 00 EB 07 C7 45 8C 00 00 00 00 8B 55 8C 89 95 74 FF FF FF 83 BD 74 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 74 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2D 09 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 83 FA 77 74 17 8B 45 0C 0F BE 08 83 F9 72 74 0C C7 85 6C FF FF FF 00 00 00 00 EB 0A C7 85 6C FF FF FF 01 00 00 00 8B 95 6C FF FF FF 89 95 70 FF FF FF 83 BD 70 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 70 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 77 08 00 00 B9 01 00 00 00 6B C9 00 8B 55 0C 8A 02 88 44 0D E0 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 0C 0F BE 02 83 F8 20 75 0B 8B 4D 0C 83 C1 01 89 4D 0C EB EA 8B 55 0C 0F BE 02 85 C0 74 22 8B 4D 0C 0F BE 11 83 FA 74 74 17 8B 45 0C 0F BE 08 83 F9 62 74 0C C7 85 78 FF FF FF 00 00 00 00 EB 0A C7 85 78 FF FF FF 01 00 00 00 8B 95 78 FF FF FF 89 95 68 FF FF FF 83 BD 68 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 68 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 9D 07 00 00 B9 01 00 00 00 C1 E1 00 8B 55 0C 8A 02 88 44 0D E0 B9 01 00 00 00 C1 E1 00 0F BE 54 0D E0 83 FA 74 75 09 C7 45 C4 00 40 00 00 EB 19 B8 01 00 00 00 C1 E0 00 0F BE 4C 05 E0 83 F9 62 75 07 C7 45 C4 00 80 00 00 8B 55 C4 81 CA 80 00 00 00 89 55 C4 8B 45 C4 50 68 00 04 00 00 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 2A 07 00 00 BA 01 00 00 00 6B D2 00 0F BE 44 15 E0 83 F8 77 75 17 C7 45 A4 00 00 00 00 C7 45 D4 00 00 00 00 C7 45 C8 01 00 00 00 EB 15 C7 45 A4 01 00 00 00 C7 45 D4 01 00 00 00 C7 45 C8 00 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 31 B9 04 00 00 00 6B C9 00 8B 54 0D A8 52 E8 ?? ?? ?? ?? 83 C4 04 B8 04 00 00 00 C1 E0 00 8B 4C 05 A8 51 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 B0 06 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 BA 04 00 00 00 C1 E2 00 C7 44 15 80 01 00 00 00 B8 04 00 00 00 6B C0 00 C7 44 05 80 01 00 00 00 FF 15 ?? ?? ?? ?? 89 45 88 6A 02 6A 01 6A 00 8D 4D B4 51 8B 55 88 52 8B 45 D4 8B 4C 85 A8 C1 F9 05 8B 55 D4 8B 44 95 A8 83 E0 1F C1 E0 06 8B 0C 8D ?? ?? ?? ?? 8B 14 01 52 8B 45 88 50 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 E3 05 00 00 8B 4D D4 8B 54 8D A8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 D4 C7 44 85 80 00 00 00 00 8D 4D E0 51 8B 55 C8 8B 44 95 A8 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 83 7D CC 00 75 05 E9 A6 05 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 BC 83 7D BC 00 75 05 E9 70 05 00 00 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 68 ED 00 00 00 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 06 83 7D D0 00 75 09 C7 45 DC ?? ?? ?? ?? EB 06 8B 55 D0 89 55 DC 6A 44 6A 00 8D 85 00 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 00 FF FF FF 44 00 00 00 C7 85 2C FF FF FF 00 01 00 00 83 7D A4 00 75 0B 8B 4D B4 89 8D 7C FF FF FF EB 16 BA 04 00 00 00 6B D2 00 8B 82 ?? ?? ?? ?? 8B 08 89 8D 7C FF FF FF 8B 95 7C FF FF FF 89 95 38 FF FF FF 83 7D A4 01 75 08 8B 45 B4 89 45 90 EB 14 B9 04 00 00 00 6B C9 00 8B 91 ?? ?? ?? ?? 8B 42 40 89 45 90 8B 4D 90 89 8D 3C FF FF FF BA 04 00 00 00 6B D2 00 8B 82 ?? ?? ?? ?? 8B 88 80 00 00 00 89 8D 40 FF FF FF 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 03 F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4C 06 01 89 4D C0 68 08 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 8B 55 C0 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 D8 83 7D D8 00 75 05 E9 1E 04 00 00 6A 00 68 0A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 DC 50 8B 4D C0 51 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 C0 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 8B 45 C0 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 10 6A 00 8D 95 50 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 00 89 45 A0 6A 00 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 30 8D 95 50 FF FF FF 52 8D 85 00 FF FF FF 50 6A 00 6A 00 6A 00 6A 01 6A 00 6A 00 8B 4D D8 51 8B 55 DC 52 FF 15 ?? ?? ?? ?? 89 45 B8 E9 A6 02 00 00 C7 45 B0 00 00 00 00 C7 85 44 FF FF FF 00 00 00 00 68 24 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 40 6A 02 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 DC 00 00 00 00 E8 ?? ?? ?? ?? 8B 4D A0 89 08 E9 B0 02 00 00 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 68 2D 01 00 00 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 4E 6A 02 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 D0 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 DC 00 00 00 00 E8 ?? ?? ?? ?? 8B 4D A0 89 08 E9 1C 02 00 00 8B 55 B0 89 55 98 68 03 01 00 00 8B 45 E4 50 8B 4D 98 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 98 83 7D 98 00 0F 84 59 01 00 00 8B 55 E4 0F BE 02 85 C0 0F 84 4B 01 00 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 E4 8D 44 02 FF 89 45 9C 8B 4D 9C 0F BE 11 83 FA 5C 75 4A 6A 5C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 39 45 9C 74 35 6A 00 68 43 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 40 8B 55 9C 0F BE 02 83 F8 2F 74 35 6A 00 68 46 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 36 6A 00 68 51 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D DC 51 68 04 01 00 00 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 02 EB 44 6A 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 2D 8D 8D 50 FF FF FF 51 8D 95 00 FF FF FF 52 6A 00 6A 00 6A 00 6A 01 6A 00 6A 00 8B 45 D8 50 8B 4D E4 51 FF 15 ?? ?? ?? ?? 89 45 B8 EB 05 E9 85 FE FF FF 6A 02 8B 55 B0 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 DC 00 00 00 00 8B 45 B4 50 FF 15 ?? ?? ?? ?? 83 7D B8 00 74 0D 8B 8D 54 FF FF FF 51 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 A0 89 10 83 7D B8 00 74 0E 8B 85 50 FF FF FF 89 85 60 FF FF FF EB 02 EB 16 8B 4D BC 8B 95 60 FF FF FF 89 51 04 8B 45 BC 8B 4D CC 89 08 EB 5B 8B 55 BC C7 02 00 00 00 00 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D C8 C7 44 8D 80 00 00 00 00 C7 45 CC 00 00 00 00 8B 55 D4 83 7C 95 80 00 74 10 8B 45 D4 8B 4C 85 A8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 C8 83 7C 95 80 00 74 10 8B 45 C8 8B 4C 85 A8 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 CC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "_idtab"
		size = 220
		refs = "0007 ___idpairs 001b ___idtabsiz 0084 ??_C@_0CP@FGKFGAJD@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 009d __recalloc_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 08 89 4D FC 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 0C D0 39 4D FC 73 0E 8B 55 FC 8B 02 3B 45 08 75 02 EB 02 EB D6 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 04 CA 39 45 FC 73 08 8B 45 FC E9 82 00 00 00 83 7D 08 00 75 51 8B 0D ?? ?? ?? ?? 83 C1 01 3B 0D ?? ?? ?? ?? 72 40 8B 15 ?? ?? ?? ?? 83 C2 01 81 FA FF FF FF 1F 73 2F 68 2F 02 00 00 68 ?? ?? ?? ?? 6A 02 6A 08 A1 ?? ?? ?? ?? 83 C0 01 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 04 33 C0 EB 27 8B 55 F8 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D F8 8D 14 C1 89 55 FC A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_3_0 {
	meta:
		name = "__output_p_l"
		size = 15892
		refs = "000a ___security_cookie 0064 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00cd __errno 00d8 __ioinit 00f1 ??1_LocaleUpdate@@QAE@XZ 0132 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0137 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0143 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 014a __CrtDbgReportW 0178 ??_C@_1BI@KANOLAMF@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 0182 __invalid_parameter 01cc __fileno 0203 ___pioinfo 0215 ___badioinfo 02af ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0358 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 04f5 ___lookuptable_s 056d _strtol 059e _memset 064b ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 0738 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 07d1 $LN425 080f ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 081d __isleadbyte_l 0840 _write_char 0892 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 09a8 $LN421 09af $LN426 0a2c _get_int_arg 0ac1 ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 0be7 __validate_param_reuseA 0c1e ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0dd0 ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0f2d ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 103c $LN422 1043 $LN427 11ac $LN423 11b3 $LN428 1200 _get_short_arg 1251 ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 1387 ??_C@_1IK@MHEDJAMK@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 144d _wctomb_s 1607 ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1875 ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1934 ___nullstring 1946 _strlen 1c65 ___wnullstring 1f95 __get_printf_count_output 1fd1 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 2231 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2321 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 2334 __malloc_dbg 245f ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 2502 __cfltcvt_tab 2509 __imp__DecodePointer@4 26c6 _get_int64_arg 2852 ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2ab2 ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 3630 __aullrem 3655 __aulldiv 3800 _write_multi_char 3828 _write_string 39bc __free_dbg 3a10 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 3b09 $LN429 3bfd _get_crtdouble_arg 3c45 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 3ce6 @__security_check_cookie@4 3cf0 $LN265 3cf4 $LN259 3cf8 $LN258 3cfc $LN250 3d00 $LN238 3d04 $LN237 3d08 $LN225 3d0c $LN209 3d10 $LN253 3d14 $LN252 3d18 $LN254 3d1c $LN255 3d20 $LN251 3d24 $LN256 3d3c $LN219 3d40 $LN211 3d44 $LN222 3d48 $LN210 3d4c $LN223 3d80 $LN138 3d84 $LN206 3d88 $LN170 3d8c $LN112 3d90 $LN184 3d94 $LN137 3d98 $LN204 3d9c $LN117 3da0 $LN151 3da4 $LN107 3da8 $LN113 3dac $LN168 3db0 $LN115 3db4 $LN110 3db8 $LN207 3df4 $LN9 3df8 $LN8 3dfc $LN7 3e00 $LN6 3e04 $LN5 3e08 $LN4 3e0c $LN2 3e10 $LN3"
	strings:
		$1 = { 55 8B EC 81 EC 7C 0B 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 0C F7 FF FF 00 00 00 00 C7 85 A8 F7 FF FF 00 00 00 00 C7 85 78 F7 FF FF 00 00 00 00 C7 85 A0 F7 FF FF 00 00 00 00 C7 85 54 F7 FF FF 00 00 00 00 C7 85 34 F7 FF FF 00 00 00 00 C7 85 40 F7 FF FF 00 00 00 00 8B 45 10 50 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? C7 85 E8 F5 FF FF 00 00 00 00 C7 85 70 F7 FF FF 00 00 00 00 C7 85 9C F7 FF FF 00 00 00 00 C7 85 8C F4 FF FF 00 00 00 00 C7 85 80 F7 FF FF FF FF FF FF C7 85 AC F7 FF FF FF FF FF FF C7 85 7C F7 FF FF FF FF FF FF C7 85 84 F7 FF FF FF FF FF FF C7 85 98 F7 FF FF FF FF FF FF C7 85 48 F7 FF FF 00 00 00 00 E8 ?? ?? ?? ?? 89 85 F4 F6 FF FF E8 ?? ?? ?? ?? 85 C0 7D 20 C7 85 78 F5 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 78 F5 FF FF E9 E0 3B 00 00 83 7D 08 00 74 0C C7 85 CC F5 FF FF 01 00 00 00 EB 0A C7 85 CC F5 FF FF 00 00 00 00 8B 8D CC F5 FF FF 89 8D A8 F5 FF FF 83 BD A8 F5 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD A8 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 08 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 B8 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 B8 F4 FF FF E9 37 3B 00 00 8B 45 08 89 85 A0 F5 FF FF 8B 8D A0 F5 FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 A0 F5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 5C F7 FF FF 83 BD 5C F7 FF FF FF 74 2D 83 BD 5C F7 FF FF FE 74 24 8B 8D 5C F7 FF FF C1 F9 05 8B 95 5C F7 FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 98 F5 FF FF EB 0A C7 85 98 F5 FF FF ?? ?? ?? ?? 8B 85 98 F5 FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 5C F7 FF FF FF 74 2D 83 BD 5C F7 FF FF FE 74 24 8B 85 5C F7 FF FF C1 F8 05 8B 8D 5C F7 FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D 84 F5 FF FF EB 0A C7 85 84 F5 FF FF ?? ?? ?? ?? 8B 95 84 F5 FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 88 F5 FF FF 00 00 00 00 EB 0A C7 85 88 F5 FF FF 01 00 00 00 8B 95 88 F5 FF FF 89 95 A4 F5 FF FF 83 BD A4 F5 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0A 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD A4 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0A 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 B0 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 B0 F4 FF FF E9 BA 39 00 00 83 7D 0C 00 74 0C C7 85 F0 F5 FF FF 01 00 00 00 EB 0A C7 85 F0 F5 FF FF 00 00 00 00 8B 8D F0 F5 FF FF 89 8D D8 F6 FF FF 83 BD D8 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0D 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD D8 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0D 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 A8 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 A8 F4 FF FF E9 11 39 00 00 C7 85 90 F7 FF FF 00 00 00 00 8B 45 0C 89 85 E8 F5 FF FF C7 85 9C F7 FF FF 00 00 00 00 EB 0F 8B 8D 9C F7 FF FF 83 C1 01 89 8D 9C F7 FF FF 83 BD 9C F7 FF FF 02 0F 8D B9 38 00 00 83 BD 9C F7 FF FF 01 75 0E 83 BD 98 F7 FF FF 00 75 05 E9 A2 38 00 00 C7 85 94 F7 FF FF 00 00 00 00 C7 85 58 F7 FF FF 00 00 00 00 C7 85 48 F7 FF FF 00 00 00 00 C7 85 F8 F6 FF FF 00 00 00 00 C7 85 80 F7 FF FF FF FF FF FF C7 85 78 F7 FF FF 00 00 00 00 C7 85 A0 F7 FF FF 00 00 00 00 8B 95 E8 F5 FF FF 89 55 0C C7 85 AC F7 FF FF FF FF FF FF C7 85 7C F7 FF FF FF FF FF FF C7 85 84 F7 FF FF FF FF FF FF C7 85 98 F7 FF FF FF FF FF FF 8B 45 0C 8A 08 88 8D B3 F7 FF FF 0F BE 95 B3 F7 FF FF 89 95 A0 F4 FF FF 8B 45 0C 83 C0 01 89 45 0C 83 BD A0 F4 FF FF 00 0F 84 0C 35 00 00 83 BD 90 F7 FF FF 00 0F 8C FF 34 00 00 0F BE 8D B3 F7 FF FF 83 F9 20 7C 25 0F BE 95 B3 F7 FF FF 83 FA 78 7F 19 0F BE 85 B3 F7 FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D D0 F6 FF FF EB 0A C7 85 D0 F6 FF FF 00 00 00 00 8B 95 D0 F6 FF FF 89 95 98 F4 FF FF 8B 85 98 F4 FF FF 6B C0 09 8B 8D 58 F7 FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 58 F7 FF FF 83 BD 58 F7 FF FF 01 0F 85 B4 01 00 00 8B 45 0C 0F BE 08 83 F9 25 0F 84 A5 01 00 00 83 BD 98 F7 FF FF FF 75 5C 6A 0A 8D 95 70 F7 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 39 8B 8D 70 F7 FF FF 0F BE 11 83 FA 24 75 2B 83 BD 9C F7 FF FF 00 75 16 68 40 06 00 00 6A 00 8D 85 B4 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 98 F7 FF FF 01 00 00 00 EB 0A C7 85 98 F7 FF FF 00 00 00 00 83 BD 98 F7 FF FF 01 0F 85 2E 01 00 00 6A 0A 8D 8D 70 F7 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 AC F7 FF FF 8B 85 70 F7 FF FF 83 C0 01 89 45 0C 83 BD 9C F7 FF FF 00 0F 85 F7 00 00 00 83 BD AC F7 FF FF 00 7C 23 8B 8D 70 F7 FF FF 0F BE 11 83 FA 24 75 15 83 BD AC F7 FF FF 64 7D 0C C7 85 E0 F5 FF FF 01 00 00 00 EB 0A C7 85 E0 F5 FF FF 00 00 00 00 8B 85 E0 F5 FF FF 89 85 C8 F6 FF FF 83 BD C8 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 56 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD C8 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 56 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 90 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 90 F4 FF FF E9 1E 36 00 00 8B 95 AC F7 FF FF 3B 95 80 F7 FF FF 7E 0E 8B 85 AC F7 FF FF 89 85 D8 F5 FF FF EB 0C 8B 8D 80 F7 FF FF 89 8D D8 F5 FF FF 8B 95 D8 F5 FF FF 89 95 80 F7 FF FF E9 B4 00 00 00 83 BD 58 F7 FF FF 08 0F 85 A7 00 00 00 33 C0 74 0C C7 85 C0 F6 FF FF 01 00 00 00 EB 0A C7 85 C0 F6 FF FF 00 00 00 00 8B 8D C0 F6 FF FF 89 8D D0 F5 FF FF 83 BD D0 F5 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 62 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD D0 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 62 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 C4 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 C4 F4 FF FF E9 31 35 00 00 8B 85 58 F7 FF FF 89 85 B8 F6 FF FF 83 BD B8 F6 FF FF 07 0F 87 05 32 00 00 8B 8D B8 F6 FF FF FF 24 8D ?? ?? ?? ?? 83 BD 9C F7 FF FF 00 75 09 83 BD 98 F7 FF FF 01 74 12 83 BD 9C F7 FF FF 01 75 0E 83 BD 98 F7 FF FF FF 75 05 E9 CF 31 00 00 C7 85 40 F7 FF FF 00 00 00 00 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 50 0F B6 95 B3 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 DD 00 00 00 8D 85 90 F7 FF FF 50 8B 4D 08 51 0F B6 95 B3 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D B3 F7 FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 B3 F7 FF FF 85 C0 74 0C C7 85 C8 F5 FF FF 01 00 00 00 EB 0A C7 85 C8 F5 FF FF 00 00 00 00 8B 8D C8 F5 FF FF 89 8D B0 F6 FF FF 83 BD B0 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD B0 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 FC F4 FF FF E9 D7 33 00 00 8D 85 90 F7 FF FF 50 8B 4D 08 51 0F B6 95 B3 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C E9 A4 30 00 00 C7 85 08 F7 FF FF 00 00 00 00 8B 85 08 F7 FF FF 89 85 34 F7 FF FF 8B 8D 34 F7 FF FF 89 8D 78 F7 FF FF 8B 95 78 F7 FF FF 89 95 54 F7 FF FF C7 85 A8 F7 FF FF 00 00 00 00 C7 85 A0 F7 FF FF FF FF FF FF C7 85 40 F7 FF FF 00 00 00 00 E9 53 30 00 00 0F BE 85 B3 F7 FF FF 89 85 18 F7 FF FF 8B 8D 18 F7 FF FF 83 E9 20 89 8D 18 F7 FF FF 83 BD 18 F7 FF FF 10 77 6A 8B 95 18 F7 FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 8D A8 F7 FF FF 83 C9 04 89 8D A8 F7 FF FF EB 45 8B 95 A8 F7 FF FF 83 CA 01 89 95 A8 F7 FF FF EB 34 8B 85 A8 F7 FF FF 83 C8 02 89 85 A8 F7 FF FF EB 23 8B 8D A8 F7 FF FF 81 C9 80 00 00 00 89 8D A8 F7 FF FF EB 0F 8B 95 A8 F7 FF FF 83 CA 08 89 95 A8 F7 FF FF E9 BF 2F 00 00 0F BE 85 B3 F7 FF FF 83 F8 2A 0F 85 D1 02 00 00 83 BD 98 F7 FF FF 00 75 17 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 78 F7 FF FF E9 89 02 00 00 6A 0A 8D 95 70 F7 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 7C F7 FF FF 8B 8D 70 F7 FF FF 83 C1 01 89 4D 0C 83 BD 9C F7 FF FF 00 0F 85 27 02 00 00 83 BD 7C F7 FF FF 00 7C 23 8B 95 70 F7 FF FF 0F BE 02 83 F8 24 75 15 83 BD AC F7 FF FF 64 7D 0C C7 85 C0 F5 FF FF 01 00 00 00 EB 0A C7 85 C0 F5 FF FF 00 00 00 00 8B 8D C0 F5 FF FF 89 8D A8 F6 FF FF 83 BD A8 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C1 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD A8 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C1 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 6C F5 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 6C F5 FF FF E9 A8 31 00 00 8B 85 7C F7 FF FF 3B 85 80 F7 FF FF 7E 0E 8B 8D 7C F7 FF FF 89 8D B8 F5 FF FF EB 0C 8B 95 80 F7 FF FF 89 95 B8 F5 FF FF 8B 85 B8 F5 FF FF 89 85 80 F7 FF FF 8B 8D 7C F7 FF FF C1 E1 04 83 BC 0D B4 F9 FF FF 00 75 45 8B 95 7C F7 FF FF C1 E2 04 C7 84 15 B4 F9 FF FF 01 00 00 00 8B 85 7C F7 FF FF C1 E0 04 8A 8D B3 F7 FF FF 88 8C 05 BC F9 FF FF 8B 95 7C F7 FF FF C1 E2 04 8B 85 A8 F7 FF FF 89 84 15 C0 F9 FF FF E9 D1 00 00 00 8B 8D A8 F7 FF FF 51 0F B6 95 B3 F7 FF FF 52 6A 01 8B 85 7C F7 FF FF C1 E0 04 8D 8C 05 B4 F9 FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0C C7 85 B0 F5 FF FF 01 00 00 00 EB 0A C7 85 B0 F5 FF FF 00 00 00 00 8B 95 B0 F5 FF FF 89 95 9C F6 FF FF 83 BD 9C F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C6 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 9C F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C6 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 9C F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 9C F4 FF FF E9 4B 30 00 00 E9 33 2D 00 00 EB 2B 8B 8D 7C F7 FF FF C1 E1 04 8B 94 0D B8 F9 FF FF 89 95 64 F5 FF FF 8D 85 64 F5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 78 F7 FF FF 83 BD 78 F7 FF FF 00 7D 1D 8B 8D A8 F7 FF FF 83 C9 04 89 8D A8 F7 FF FF 8B 95 78 F7 FF FF F7 DA 89 95 78 F7 FF FF EB 1A 8B 85 78 F7 FF FF 6B C0 0A 0F BE 8D B3 F7 FF FF 8D 54 08 D0 89 95 78 F7 FF FF E9 BF 2C 00 00 C7 85 A0 F7 FF FF 00 00 00 00 E9 B0 2C 00 00 0F BE 85 B3 F7 FF FF 83 F8 2A 0F 85 BE 02 00 00 83 BD 98 F7 FF FF 00 75 17 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 A0 F7 FF FF E9 89 02 00 00 6A 0A 8D 95 70 F7 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 84 F7 FF FF 8B 8D 70 F7 FF FF 83 C1 01 89 4D 0C 83 BD 9C F7 FF FF 00 0F 85 27 02 00 00 83 BD 84 F7 FF FF 00 7C 23 8B 95 70 F7 FF FF 0F BE 02 83 F8 24 75 15 83 BD AC F7 FF FF 64 7D 0C C7 85 0C F6 FF FF 01 00 00 00 EB 0A C7 85 0C F6 FF FF 00 00 00 00 8B 8D 0C F6 FF FF 89 8D 94 F6 FF FF 83 BD 94 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F6 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 94 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F6 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F4 F4 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 F4 F4 FF FF E9 99 2E 00 00 8B 85 84 F7 FF FF 3B 85 80 F7 FF FF 7E 0E 8B 8D 84 F7 FF FF 89 8D C4 F5 FF FF EB 0C 8B 95 80 F7 FF FF 89 95 C4 F5 FF FF 8B 85 C4 F5 FF FF 89 85 80 F7 FF FF 8B 8D 84 F7 FF FF C1 E1 04 83 BC 0D B4 F9 FF FF 00 75 45 8B 95 84 F7 FF FF C1 E2 04 C7 84 15 B4 F9 FF FF 01 00 00 00 8B 85 84 F7 FF FF C1 E0 04 8A 8D B3 F7 FF FF 88 8C 05 BC F9 FF FF 8B 95 84 F7 FF FF C1 E2 04 8B 85 A8 F7 FF FF 89 84 15 C0 F9 FF FF E9 D1 00 00 00 8B 8D A8 F7 FF FF 51 0F B6 95 B3 F7 FF FF 52 6A 01 8B 85 84 F7 FF FF C1 E0 04 8D 8C 05 B4 F9 FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0C C7 85 8C F6 FF FF 01 00 00 00 EB 0A C7 85 8C F6 FF FF 00 00 00 00 8B 95 8C F6 FF FF 89 95 04 F6 FF FF 83 BD 04 F6 FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 FB 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 04 F6 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 FB 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 5C F5 FF FF FF FF FF FF 8D 8D 60 F7 FF FF E8 ?? ?? ?? ?? 8B 85 5C F5 FF FF E9 3C 2D 00 00 E9 24 2A 00 00 EB 2B 8B 8D 84 F7 FF FF C1 E1 04 8B 94 0D B8 F9 FF FF 89 95 BC F4 FF FF 8D 85 BC F4 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 A0 F7 FF FF 83 BD A0 F7 FF FF 00 7D 0A C7 85 A0 F7 FF FF FF FF FF FF EB 1A 8B 8D A0 F7 FF FF 6B C9 0A 0F BE 95 B3 F7 FF FF 8D 44 11 D0 89 }
	condition:
		$1
}

rule file_40_4_0 {
	meta:
		name = "__validate_param_reuseA"
		size = 738
	strings:
		$1 = { 55 8B EC 83 EC 3C C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 0F BE 48 08 83 F9 70 74 09 0F BE 55 10 83 FA 70 75 27 8B 45 08 0F BE 48 08 0F BE 55 10 3B CA 75 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 E9 8E 02 00 00 8B 45 08 0F BE 48 08 83 F9 73 74 15 8B 55 08 0F BE 42 08 83 F8 53 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 4D F0 89 4D FC 0F BE 55 10 83 FA 73 74 12 0F BE 45 10 83 F8 53 74 09 C7 45 EC 00 00 00 00 EB 07 C7 45 EC 01 00 00 00 8B 4D EC 89 4D F8 83 7D FC 00 75 06 83 7D F8 00 74 61 8B 55 FC 3B 55 F8 75 4A 8B 45 08 8B 48 0C 81 E1 10 08 00 00 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 55 14 81 E2 10 08 00 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E8 3B 45 E4 75 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 E9 CB 01 00 00 8B 4D 08 0F BE 51 08 83 FA 64 74 76 8B 45 08 0F BE 48 08 83 F9 69 74 6A 8B 55 08 0F BE 42 08 83 F8 6F 74 5E 8B 4D 08 0F BE 51 08 83 FA 75 74 52 8B 45 08 0F BE 48 08 83 F9 78 74 46 8B 55 08 0F BE 42 08 83 F8 58 74 3A 0F BE 4D 10 83 F9 64 74 31 0F BE 55 10 83 FA 69 74 28 0F BE 45 10 83 F8 6F 74 1F 0F BE 4D 10 83 F9 75 74 16 0F BE 55 10 83 FA 78 74 0D 0F BE 45 10 83 F8 58 0F 85 2C 01 00 00 8B 4D 08 0F BE 51 08 83 FA 64 74 45 8B 45 08 0F BE 48 08 83 F9 69 74 39 8B 55 08 0F BE 42 08 83 F8 6F 74 2D 8B 4D 08 0F BE 51 08 83 FA 75 74 21 8B 45 08 0F BE 48 08 83 F9 78 74 15 8B 55 08 0F BE 42 08 83 F8 58 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 0F BE 4D 10 83 F9 64 74 36 0F BE 55 10 83 FA 69 74 2D 0F BE 45 10 83 F8 6F 74 24 0F BE 4D 10 83 F9 75 74 1B 0F BE 55 10 83 FA 78 74 12 0F BE 45 10 83 F8 58 74 09 C7 45 D8 00 00 00 00 EB 07 C7 45 D8 01 00 00 00 8B 4D DC 3B 4D D8 74 07 33 C0 E9 9C 00 00 00 8B 55 08 8B 42 0C 25 00 00 01 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D 14 81 E1 00 00 01 00 74 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D4 3B 55 D0 75 3B 8B 45 08 8B 48 0C 83 E1 20 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 55 14 83 E2 20 74 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 45 CC 3B 45 C8 74 04 33 C0 EB 1D 8B 4D 08 8B 11 3B 55 0C 75 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 45 C4 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_8_0 {
	meta:
		name = "_get_short_arg"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_40_9_0 {
	meta:
		name = "_write_char"
		size = 160
		refs = "0074 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 73 8B 45 0C 8B 48 04 83 E9 01 89 4D FC 8B 55 0C 8B 45 FC 89 42 04 83 7D FC 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D F8 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 14 8B 55 0C 52 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_10_0 {
	meta:
		name = "_write_multi_char"
		size = 62
		refs = "0027 _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 45 FC 8B 4D 0C 83 E9 01 89 4D 0C 83 7D FC 00 7E 21 8B 55 14 52 8B 45 10 50 0F B6 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CA 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_11_0 {
	meta:
		name = "_write_string"
		size = 177
		refs = "0065 _write_char"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 18 8B 08 89 4D F4 8B 55 10 8B 42 0C 83 E0 40 74 18 8B 4D 10 83 79 08 00 75 0F 8B 55 14 8B 02 03 45 0C 8B 4D 14 89 01 EB 7C 8B 55 18 C7 02 00 00 00 00 8B 45 0C 89 45 F8 8B 4D 0C 83 E9 01 89 4D 0C 83 7D F8 00 7E 4E 8B 55 08 8A 02 88 45 FF 8B 4D 14 51 8B 55 10 52 0F B6 45 FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 83 3A FF 75 1E 8B 45 18 83 38 2A 75 14 8B 4D 14 51 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB 9D 8B 45 18 83 38 00 75 08 8B 4D 18 8B 55 F4 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "??0?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ"
		size = 32
		refs = "000b ??0Count@CollectionTypes@details@Concurrency@@QAE@XZ"
		altNames = "??0?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 04 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "??0AffinityRestriction@ResourceManager@details@Concurrency@@QAE@GPAUHardwareAffinity@23@@Z"
		size = 35
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 66 8B 4D 08 66 89 08 8B 55 FC 8B 45 0C 89 42 04 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_3_0 {
	meta:
		name = "??0Count@CollectionTypes@details@Concurrency@@QAE@XZ"
		size = 23
		altNames = "??0?$ISource@I@Concurrency@@QAE@XZ ??0?$ISource@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$ITarget@I@Concurrency@@QAE@XZ ??0?$ITarget@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ ??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAE@XZ ??0?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$_Func_base@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@QAE@XZ ??0?$_Func_base@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ ??0?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ ??0?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@QAE@XZ ??0?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ ??0?$message_processor@I@Concurrency@@QAE@XZ ??0?$message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ ??0Block@_HeapManager@@QAE@XZ ??0ClaimTicket@VirtualProcessor@details@Concurrency@@QAE@XZ ??0Context@Concurrency@@QAE@XZ ??0DNameNode@@IAE@XZ ??0IExecutionContext@Concurrency@@QAE@XZ ??0IExecutionResource@Concurrency@@QAE@XZ ??0IResourceManager@Concurrency@@QAE@XZ ??0IScheduler@Concurrency@@QAE@XZ ??0ISchedulerProxy@Concurrency@@QAE@XZ ??0IThreadProxy@Concurrency@@QAE@XZ ??0IThreadProxyFactory@details@Concurrency@@QAE@XZ ??0ITopologyExecutionResource@Concurrency@@QAE@XZ ??0ITopologyNode@Concurrency@@QAE@XZ ??0IUMSCompletionList@Concurrency@@QAE@XZ ??0IUMSUnblockNotification@Concurrency@@QAE@XZ ??0ScheduleGroup@Concurrency@@QAE@XZ ??0Scheduler@Concurrency@@IAE@XZ ??0StructuredEvent@details@Concurrency@@QAE@XZ ??0UMSBaseObject@details@Concurrency@@QAE@XZ ??0_Chore@details@Concurrency@@IAE@XZ ??0_Container_base12@std@@QAE@XZ ??0_Facet_base@std@@QAE@XZ ??0_NonReentrantLock@details@Concurrency@@QAE@XZ ??0error_category@std@@QAE@XZ ??0ios_base@std@@IAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_4_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@ABU012@@Z"
		size = 34
		refs = "0012 _memcpy"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 0C 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_5_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@GK@Z"
		size = 51
		refs = "0010 _memset"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 0C 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 66 8B 55 08 66 89 51 04 8B 45 FC 8B 4D 0C 89 08 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_6_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@K@Z"
		size = 49
		refs = "0010 _memset"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 0C 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 8B 55 FC 66 89 4A 04 8B 45 FC 8B 4D 08 89 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_7_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z"
		size = 159
		refs = "0012 _memset 001a ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0025 ?s_pfnGetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@@ZA 002b ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0045 ??_C@_1FA@MEPBPLFG@?$AAf?$AAn?$AAD?$AAe?$AAc?$AAo?$AAd?$AAe?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?$CI?$AAh?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AA?0?$AA?5?$AA?$CG?$AAm?$AA_?$AAa?$AAf@ 004a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005d __CrtDbgReportW 007a __imp__GetCurrentProcess@0 0081 __imp__GetProcessAffinityMask@12"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 6A 0C 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 F8 04 7C 4D 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 55 FC 52 8B 45 08 50 FF 55 F8 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B1 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C7 EB 26 8D 45 F0 50 8D 4D F4 51 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 D2 8B 45 FC 66 89 50 04 8B 4D FC 8B 55 F4 89 11 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_8_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@XZ"
		size = 48
		refs = "0010 _memset"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 0C 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 8B 55 FC 66 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_12_0 {
	meta:
		name = "??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 357
		refs = "0006 __ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ 0015 ___security_cookie 002c ??0IResourceManager@Concurrency@@QAE@XZ 0035 ??_7ResourceManager@details@Concurrency@@6B@ 007c ??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 00d4 ??0?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ 00df ??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 00ea ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 00f5 ?DetermineTopology@ResourceManager@details@Concurrency@@AAEXXZ 0103 __imp__CreateEventW@16 0118 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0139 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC C7 00 ?? ?? ?? ?? 8B 4D EC C7 41 04 00 00 00 00 8B 55 EC C7 42 08 00 00 00 00 8B 45 EC C7 40 0C 10 00 00 00 8B 4D EC C7 41 10 00 00 00 00 8B 55 EC C7 42 24 00 00 00 00 8B 45 EC C7 40 28 00 00 00 00 8B 4D EC 83 C1 2C E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC C7 41 44 00 00 00 00 8B 55 EC C7 42 48 00 00 00 00 8B 45 EC C7 40 4C 00 00 00 00 8B 4D EC C7 41 50 00 00 00 00 8B 55 EC C7 42 54 00 00 00 00 8B 45 EC C7 40 58 00 00 00 00 8B 4D EC C7 41 5C 00 00 00 00 8B 4D EC 83 C1 60 E8 ?? ?? ?? ?? 8B 4D EC 83 C1 68 E8 ?? ?? ?? ?? C6 45 FC 01 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8B 55 EC 89 42 50 33 C0 88 45 F3 68 B9 01 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 55 EC 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 8B 45 EC 8B 4D E8 89 48 54 C7 45 FC FF FF FF FF 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_15_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "__ehhandler$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_37_0 {
	meta:
		name = "__ehhandler$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_21_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_24_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_465_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_468_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_471_3 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_31_0 {
	meta:
		name = "__ehhandler$??1event@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1event@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_235_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_131_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1066_27_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_66_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_29_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_424_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_843_55_0 {
	meta:
		name = "__ehhandler$?StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UAEXPAVScheduleGroupSegmentBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UAEXPAVScheduleGroupSegmentBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_676_137_0 {
	meta:
		name = "__ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_54_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_240_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_125_190_2 {
	meta:
		name = "__ehhandler$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_768_2 {
	meta:
		name = "__ehhandler$?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_169_0 {
	meta:
		name = "__ehhandler$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1055_60_0 {
	meta:
		name = "__ehhandler$?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_909_3 {
	meta:
		name = "__ehhandler$?_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IBEXPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IBEXPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_912_3 {
	meta:
		name = "__ehhandler$?_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IBEXPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IBEXPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_131_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_130_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_130_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_16_0 {
	meta:
		name = "??0SchedulerCore@details@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??0?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 0C E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_17_0 {
	meta:
		name = "??0TopologyObject@GlobalCore@details@Concurrency@@QAE@PAU123@@Z"
		size = 42
		refs = "000b ??0ITopologyExecutionResource@Concurrency@@QAE@XZ 0014 ??_7TopologyObject@GlobalCore@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_18_0 {
	meta:
		name = "??0TopologyObject@GlobalNode@details@Concurrency@@QAE@PAU123@@Z"
		size = 42
		refs = "000b ??0ITopologyNode@Concurrency@@QAE@XZ 0014 ??_7TopologyObject@GlobalNode@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_19_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_4_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 34
		refs = "0015 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_126_3_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_332_41_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_69_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_20_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_852_19_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_842_7_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_852_20_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1180_31_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 34
		refs = "0015 ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_21_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_12_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0bad_typeid@std@@QAE@ABV01@@Z 0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0bad_typeid@std@@QAE@PBD@Z 0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_2_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_540_1_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_114_22_1 {
	meta:
		name = "??0bad_function_call@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_472_3 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_4_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_64_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_8_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_9_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_164_3 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_72_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_111_98_3 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0system_error@std@@QAE@ABV01@@Z 0018 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1180_21_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_73_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_74_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_75_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_114_27_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_41_2 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_475_1 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_29_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_828_7_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_12_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1109_3_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1109_4_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1109_5_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_49_0 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_51_2 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_111_22_1 {
	meta:
		name = "??0lock_error@threads@stdext@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_477_3 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_479_3 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_314_1 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_30_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_315_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7money_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_16_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_480_2 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_46_2 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_56_3 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_48_2 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_89_50_3 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@PBD@Z 0018 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_57_3 {
	meta:
		name = "??0range_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_57_2 {
	meta:
		name = "??0range_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@PBD@Z 0018 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_59_3 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_953_1_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_191_4_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z 0018 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_44_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z"
		size = 37
		refs = "000f ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0018 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_503_2 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_111_26_1 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_428_3 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7time_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_29_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_22_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 46
		refs = "000c ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 001a ??0exception@std@@QAE@ABQBDH@Z 0023 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC C7 45 F8 ?? ?? ?? ?? 6A 01 8D 45 F8 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_27_0 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_3_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_48_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_5_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_4_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_6_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_8_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_10_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_12_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_14_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_16_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_18_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_20_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_22_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_24_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_26_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_28_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_30_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_32_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_34_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_36_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_38_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_95_38_2 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_40_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_46_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_48_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABQBD@Z 0018 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_28_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z"
		size = 49
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 48 0C 89 4A 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_114_37_1 {
	meta:
		name = "??0regex_error@std@@QAE@ABV01@@Z"
		size = 49
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 48 0C 89 4A 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_30_0 {
	meta:
		name = "??1AffinityRestriction@ResourceManager@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_332_57_0 {
	meta:
		name = "??1QuickBitSet@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_32_0 {
	meta:
		name = "??1GlobalNode@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 24 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_33_0 {
	meta:
		name = "??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 469
		refs = "0006 __ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ 0015 ___security_cookie 002d ??_7ResourceManager@details@Concurrency@@6B@ 007a ??_EGlobalCore@details@Concurrency@@QAEPAXI@Z 00a7 ??_EGlobalNode@details@Concurrency@@QAEPAXI@Z 00c5 ??_V@YAXPAX@Z 00d3 ?Empty@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ 00df ??_C@_1CK@OKCPIOJB@?$AAm?$AA_?$AAs?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?4?$AAE?$AAm?$AAp?$AAt?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 00e4 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00f0 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f7 __CrtDbgReportW 0116 ??_C@_1CO@ICAHHBPK@?$AAm?$AA_?$AAh?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAE?$AAv?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 014c __imp__CloseHandle@4 01b0 ??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 01c2 ??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 30 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? C7 45 FC 01 00 00 00 C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 8B 55 F0 8B 45 EC 3B 42 18 73 37 8B 4D EC 6B C9 28 8B 55 F0 8B 42 48 8B 4C 08 20 89 4D E0 8B 55 E0 89 55 E8 83 7D E8 00 74 0F 6A 03 8B 4D E8 E8 ?? ?? ?? ?? 89 45 DC EB 07 C7 45 DC 00 00 00 00 EB B5 8B 45 F0 8B 48 48 89 4D D8 8B 55 D8 89 55 E4 83 7D E4 00 74 0F 6A 03 8B 4D E4 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 45 F0 8B 48 44 89 4D D0 8B 55 D0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 83 C1 60 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 62 13 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 8B 4D F0 83 79 50 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 65 13 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 55 F0 8B 42 50 50 FF 15 ?? ?? ?? ?? 8B 4D F0 8B 51 54 89 55 CC 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 83 79 4C 00 74 37 8B 55 F0 8B 42 4C 50 FF 15 ?? ?? ?? ?? 8B 4D F0 8B 51 58 89 55 C8 8B 45 C8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8B 51 5C 89 55 C4 8B 45 C4 50 E8 ?? ?? ?? ?? 83 C4 04 C6 45 FC 00 8B 4D F0 83 C1 68 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 83 C1 2C E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_36_0 {
	meta:
		name = "__ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_90_1 {
	meta:
		name = "__ehhandler$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_93_1 {
	meta:
		name = "__ehhandler$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_131_1 {
	meta:
		name = "__ehhandler$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_173_2 {
	meta:
		name = "__ehhandler$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_676_45_0 {
	meta:
		name = "__ehhandler$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_447_0 {
	meta:
		name = "__ehhandler$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_473_0 {
	meta:
		name = "__ehhandler$?ThrottlerDispatch@SchedulerBase@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ThrottlerDispatch@SchedulerBase@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_309_3 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_637_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_527_1 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1005_1 {
	meta:
		name = "__ehhandler$?_Sync_send_helper@?$ordered_message_processor@I@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Sync_send_helper@?$ordered_message_processor@I@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1008_1 {
	meta:
		name = "__ehhandler$?_Sync_send_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Sync_send_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_971_3 {
	meta:
		name = "__ehhandler$?_Throw_future_error@std@@YAXABVerror_code@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Throw_future_error@std@@YAXABVerror_code@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_215_3 {
	meta:
		name = "__ehhandler$?back@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAA_WXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?back@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAA_WXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1248_3 {
	meta:
		name = "__ehhandler$?propagate_to_any_targets@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_to_any_targets@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1324_2 {
	meta:
		name = "__ehhandler$?reserve@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE_NHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reserve@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE_NHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1327_2 {
	meta:
		name = "__ehhandler$?reserve@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE_NHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reserve@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE_NHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1330_3 {
	meta:
		name = "__ehhandler$?reserve@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE_NHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reserve@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE_NHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1413_3 {
	meta:
		name = "__ehhandler$?unlink_targets@?$_SyncOriginator@I@details@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_targets@?$_SyncOriginator@I@details@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1416_2 {
	meta:
		name = "__ehhandler$?unlink_targets@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_targets@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1419_1 {
	meta:
		name = "__ehhandler$?unlink_targets@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_targets@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1422_1 {
	meta:
		name = "__ehhandler$?unlink_targets@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_targets@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1425_1 {
	meta:
		name = "__ehhandler$?unlink_targets@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_targets@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1430_3 {
	meta:
		name = "__ehhandler$?wait@?$ordered_message_processor@I@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@?$ordered_message_processor@I@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1433_1 {
	meta:
		name = "__ehhandler$?wait@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_37_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_856_29_0 {
	meta:
		name = "??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_8_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_332_73_0 {
	meta:
		name = "??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_676_17_0 {
	meta:
		name = "??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_477_3_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_35_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_7_0 {
	meta:
		name = "??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_842_17_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_36_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_42_0 {
	meta:
		name = "??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_41_0 {
	meta:
		name = "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_42_0 {
	meta:
		name = "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_43_0 {
	meta:
		name = "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_753_1 {
	meta:
		name = "?cancel@cancellation_token_source@Concurrency@@QBEXXZ"
		size = 21
		refs = "000d ?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_39_0 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_alloc@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_312_27_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0014 ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_312_28_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0014 ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_505_2 {
	meta:
		name = "??1?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@6B@ 0014 ??1?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_90_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_115_2 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_115_2 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_115_2 {
	meta:
		name = "??1?$codecvt@DDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@DDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_119_2 {
	meta:
		name = "??1?$codecvt@GDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@GDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_136_3 {
	meta:
		name = "??1?$codecvt@_WDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@_WDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_135_1 {
	meta:
		name = "??1?$messages@D@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@D@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_420_2 {
	meta:
		name = "??1?$messages@G@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@G@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_333_1 {
	meta:
		name = "??1?$messages@_W@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@_W@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_136_1 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_422_2 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_457_3 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_179_2 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_424_2 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_425_2 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_180_2 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$00@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_192_3 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$0A@@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_338_1 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$00@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_461_3 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$0A@@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_428_2 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$00@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_341_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$0A@@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_98_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_430_2 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_465_3 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_118_2 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_432_2 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_433_2 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_312_29_0 {
	meta:
		name = "??1FreeThreadProxy@details@Concurrency@@UAE@XZ"
		size = 28
		refs = "000c ??_7FreeThreadProxy@details@Concurrency@@6B@ 0014 ??1ThreadProxy@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_312_30_0 {
	meta:
		name = "??1FreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 28
		refs = "000c ??_7FreeThreadProxyFactory@details@Concurrency@@6B@ 0014 ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1168_4_0 {
	meta:
		name = "??1ThreadVirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 28
		refs = "000c ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 0014 ??1VirtualProcessor@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1101_10_0 {
	meta:
		name = "??1__non_rtti_object@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7__non_rtti_object@std@@6B@ 0014 ??1bad_typeid@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1101_11_0 {
	meta:
		name = "??1bad_cast@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_cast@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_64_0 {
	meta:
		name = "??1bad_exception@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_exception@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1101_12_0 {
	meta:
		name = "??1bad_typeid@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_typeid@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_134_3 {
	meta:
		name = "??1codecvt_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7codecvt_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_101_1 {
	meta:
		name = "??1ctype_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7ctype_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1101_13_0 {
	meta:
		name = "??1exception@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7exception@std@@6B@ 0014 ?_Tidy@exception@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_361_1 {
	meta:
		name = "??1facet@locale@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7facet@locale@std@@6B@ 0014 ??1_Facet_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_210_3 {
	meta:
		name = "??1time_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7time_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_40_0 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
		altNames = "??1future_error@std@@UAE@XZ ??1length_error@std@@UAE@XZ ??1out_of_range@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_491_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_492_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_493_3 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_494_3 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_499_2 {
	meta:
		name = "??1?$_Func_class@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_378_1 {
	meta:
		name = "??1?$_Func_class@XEU_Nil@std@@U12@U12@U12@U12@U12@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XEU_Nil@std@@U12@U12@U12@U12@U12@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_500_2 {
	meta:
		name = "??1?$_Func_class@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_501_1 {
	meta:
		name = "??1?$_Func_class@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_513_2 {
	meta:
		name = "??1?$_Func_class@XU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@U_Nil@2@U32@U32@U32@U32@U32@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@U_Nil@2@U32@U32@U32@U32@U32@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_380_1 {
	meta:
		name = "??1?$_Func_class@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_554_3 {
	meta:
		name = "??1?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_503_2 {
	meta:
		name = "??1?$_Func_class@_NABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@_NABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_504_3 {
	meta:
		name = "??1?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_108_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_429_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_557_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_519_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_65_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_56_0 {
	meta:
		name = "??1?$_Ref_count@V__ExceptionPtr@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_524_2 {
	meta:
		name = "??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_110_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_436_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_437_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_127_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_404_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_405_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_128_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_441_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_73_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_571_3 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_533_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_577_3 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_539_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_540_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@E@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_580_3 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_581_3 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_539_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V_ContextCallback@details@Concurrency@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_113_2 {
	meta:
		name = "??1?$_Yarn@D@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Yarn@D@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_130_3 {
	meta:
		name = "??1?$_Yarn@_W@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Yarn@_W@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_546_2 {
	meta:
		name = "??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_547_2 {
	meta:
		name = "??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_548_2 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_549_2 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_389_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_551_2 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_396_1 {
	meta:
		name = "??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_592_3 {
	meta:
		name = "??1?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_60_0 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_393_1 {
	meta:
		name = "??1?$task@E@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_589_3 {
	meta:
		name = "??1?$task@X@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$task@E@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_551_2 {
	meta:
		name = "??1?$task_completion_event@E@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_596_3 {
	meta:
		name = "??1?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_402_1 {
	meta:
		name = "??1?$vector@EV?$allocator@E@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@EV?$allocator@E@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_403_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_399_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_405_1 {
	meta:
		name = "??1?$vector@V_ContextCallback@details@Concurrency@@V?$allocator@V_ContextCallback@details@Concurrency@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@V_ContextCallback@details@Concurrency@@V?$allocator@V_ContextCallback@details@Concurrency@@@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_87_0 {
	meta:
		name = "??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_88_0 {
	meta:
		name = "??1CacheLocalScheduleGroupSegment@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1055_12_0 {
	meta:
		name = "??1CancellationTokenRegistration_TaskProc@@UAE@XZ"
		size = 19
		refs = "000b ??1_CancellationTokenRegistration@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_89_0 {
	meta:
		name = "??1FairScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_90_0 {
	meta:
		name = "??1FairScheduleGroupSegment@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_458_10_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_96_0 {
	meta:
		name = "??1RealizedChore@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1_Chore@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_746_7_0 {
	meta:
		name = "??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UAE@XZ"
		size = 19
		refs = "000b ??1_Timer@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_45_2 {
	meta:
		name = "??1_Container_base12@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_606_3 {
	meta:
		name = "??1_Future_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_41_1 {
	meta:
		name = "??1_Generic_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_51_0 {
	meta:
		name = "??1_Interruption_exception@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_443_2 {
	meta:
		name = "??1_Iostream_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_651_2 {
	meta:
		name = "??1_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_652_1 {
	meta:
		name = "??1_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_24_1 {
	meta:
		name = "??1_System_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_417_1 {
	meta:
		name = "??1_TaskProcThunk@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$function@$$A6AXXZ@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_45_1 {
	meta:
		name = "??1bad_function_call@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_52_0 {
	meta:
		name = "??1bad_target@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_418_1 {
	meta:
		name = "??1cancellation_token@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@cancellation_token@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_572_2 {
	meta:
		name = "??1cancellation_token_registration@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@cancellation_token_registration@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_856_31_0 {
	meta:
		name = "??1context_self_unblock@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_959_24_0 {
	meta:
		name = "??1context_unblock_unbalanced@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_55_0 {
	meta:
		name = "??1default_scheduler_exists@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_105_1 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1system_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_39_0 {
	meta:
		name = "??1improper_lock@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_57_0 {
	meta:
		name = "??1improper_scheduler_attach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_58_0 {
	meta:
		name = "??1improper_scheduler_detach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_125_0 {
	meta:
		name = "??1improper_scheduler_reference@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_658_1 {
	meta:
		name = "??1invalid_link_target@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_61_0 {
	meta:
		name = "??1invalid_multiple_scheduling@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_659_2 {
	meta:
		name = "??1invalid_operation@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_856_34_0 {
	meta:
		name = "??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_64_0 {
	meta:
		name = "??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_65_0 {
	meta:
		name = "??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_66_0 {
	meta:
		name = "??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_48_2 {
	meta:
		name = "??1lock_error@threads@stdext@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_66_3 {
	meta:
		name = "??1logic_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_67_0 {
	meta:
		name = "??1message_not_found@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_152_1 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_6_0 {
	meta:
		name = "??1missing_wait@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_364_1 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_856_37_0 {
	meta:
		name = "??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_70_0 {
	meta:
		name = "??1operation_timed_out@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_67_2 {
	meta:
		name = "??1overflow_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_73_2 {
	meta:
		name = "??1range_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_69_3 {
	meta:
		name = "??1regex_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_45_1 {
	meta:
		name = "??1runtime_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_71_0 {
	meta:
		name = "??1scheduler_not_attached@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_200_10_0 {
	meta:
		name = "??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1012_11_0 {
	meta:
		name = "??1scheduler_worker_creation_error@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_153_3 {
	meta:
		name = "??1system_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_420_1 {
	meta:
		name = "??1task_canceled@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_51_3 {
	meta:
		name = "??1thread_resource_error@threads@stdext@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_44_0 {
	meta:
		name = "??1unsupported_os@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_443_1 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_609_2 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_655_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_650_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_612_2 {
	meta:
		name = "??C?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_72_0 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_147_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEAADXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_396_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEAAGXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEABGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_528_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAA_WXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_450_1 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEAAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
		size = 19
		refs = "000b ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_616_2 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEAAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
		size = 19
		refs = "000b ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_79_0 {
	meta:
		name = "?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEHXZ"
		size = 19
		refs = "000b ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_849_50_0 {
	meta:
		name = "?Destroy@WaitAllBlock@details@Concurrency@@UAEXXZ"
		size = 19
		refs = "000b ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_340_0 {
	meta:
		name = "?InitializeSchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ"
		size = 19
		refs = "000b ?IncrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_149_0 {
	meta:
		name = "?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?Raise@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_332_182_0 {
	meta:
		name = "?IsStructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_172_0 {
	meta:
		name = "?PopStructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 19
		refs = "000b ?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_401_0 {
	meta:
		name = "?Reference@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_332_202_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1066_49_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?_DebugAcquire@_NonReentrantLock@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_548_1 {
	meta:
		name = "?_Cancel@?$task_completion_event@E@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_549_1 {
	meta:
		name = "?_Cancel@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_245_0 {
	meta:
		name = "?_IsLockHeld@_CriticalNonReentrantLock@details@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_IsLockHeld@_NonReentrantLock@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1170_171_0 {
	meta:
		name = "?_NotificationHandler@_AsyncTaskCollection@details@Concurrency@@AAEXXZ"
		size = 19
		refs = "000b ?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1180_94_0 {
	meta:
		name = "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_715_46_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 19
		refs = "000b ?_DebugTryAcquire@_NonReentrantLock@details@Concurrency@@AAE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_284_1 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_1139_3 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBEPBGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_161_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBEPB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_1140_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_1141_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_1142_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_1143_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_1164_2 {
	meta:
		name = "?empty@?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_1165_1 {
	meta:
		name = "?empty@?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_151_0 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_45_0 {
	meta:
		name = "??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
		size = 27
		refs = "0012 ??2@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_842_28_0 {
	meta:
		name = "??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
		size = 27
		refs = "0012 ??_U@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_41_47_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QAEAAU012@ABU012@@Z"
		size = 40
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 66 8B 51 04 66 89 50 04 8B 45 FC 8B 4D 08 8B 11 89 10 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_49_0 {
	meta:
		name = "??_EGlobalNode@details@Concurrency@@QAEPAXI@Z"
		size = 106
		refs = "0010 ??1GlobalNode@details@Concurrency@@QAE@XZ 0022 ??_M@YGXPAXIHP6EX0@Z@Z 0036 ??_V@YAXPAX@Z 005a ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 83 E0 02 74 36 68 ?? ?? ?? ?? 8B 4D FC 8B 51 FC 52 6A 28 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 4D 08 83 E1 01 74 0F 8B 55 FC 83 EA 04 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 83 E8 04 EB 1F 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_50_0 {
	meta:
		name = "??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1AffinityRestriction@ResourceManager@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_719_2 {
	meta:
		name = "??_G?$ISource@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ISource@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_720_1 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_721_2 {
	meta:
		name = "??_G?$ITarget@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ITarget@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_722_3 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_45_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_46_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_723_2 {
	meta:
		name = "??_G?$_AnonymousOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_724_2 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_725_3 {
	meta:
		name = "??_G?$_Func_base@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_726_3 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_727_3 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_676_2 {
	meta:
		name = "??_G?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_728_3 {
	meta:
		name = "??_G?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_729_3 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_736_3 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_849_39_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PAVContext@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_MallocaArrayHolder@PAVContext@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_52_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PAVevent@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_MallocaArrayHolder@PAVevent@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_188_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_572_3 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_573_3 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_737_1 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_73_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count@V__ExceptionPtr@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_74_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_11_684_2 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_99_516_1 {
	meta:
		name = "??_G?$_RunAllParam@E@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_RunAllParam@E@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_681_2 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_738_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_739_3 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_740_1 {
	meta:
		name = "??_G?$_SyncOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_741_2 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_151_2 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_86_122_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_122_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_124_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_65_123_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_50_151_2 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_126_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_125_153_2 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_97_153_2 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_742_2 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_160_3 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@DDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_72_154_2 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@GDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_97_154_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@_WDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_255_3 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_542_2 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_543_2 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_743_2 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_744_2 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_245_2 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_544_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_545_2 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_745_3 {
	meta:
		name = "??_G?$function@$$A6A_NABI@Z@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$function@$$A6A_NABI@Z@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_746_2 {
	meta:
		name = "??_G?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_747_1 {
	meta:
		name = "??_G?$message@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$message@I@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_748_3 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$message@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_191_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_546_2 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_547_2 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_247_2 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_548_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_583_3 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_248_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_550_2 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_442_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_194_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_195_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_552_2 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_553_2 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_445_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_589_3 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_749_3 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_750_3 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_751_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_752_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_162_3 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_556_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_557_2 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_163_3 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_558_2 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_559_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_135_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_451_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_561_2 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_753_3 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_754_3 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_755_3 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_756_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_757_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_758_2 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_728_3 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_99_519_1 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_75_0 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_759_3 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_assignment@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_760_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_761_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_762_2 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_763_2 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_764_1 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_765_2 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_196_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_596_3 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_597_3 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_120_252_2 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_455_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_456_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_138_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_139_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CacheLocalScheduleGroupSegment@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_852_50_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1055_25_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CancellationTokenRegistration_TaskProc@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_959_31_0 {
	meta:
		name = "??_GContext@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1Context@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_852_52_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_842_23_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1ExecutionResource@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_959_32_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ExternalContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_140_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FairScheduleGroup@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_141_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FairScheduleGroupSegment@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_47_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_48_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_458_20_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_49_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_43_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1InternalContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_142_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1RealizedChore@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_51_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 44
		refs = "000b ??1ResourceManager@details@Concurrency@@AAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_143_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroup@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_144_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_332_89_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_145_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1Scheduler@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_146_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_147_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerPolicy@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_842_24_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerProxy@details@Concurrency@@IAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_148_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulingNode@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_149_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulingRing@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_831_31_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_332_90_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_150_0 {
	meta:
		name = "??_GSubAllocator@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SubAllocator@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_53_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1TaskStack@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_843_14_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadInternalContext@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_191_10_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_843_15_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadScheduler@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1168_6_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_746_11_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1066_17_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_50_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_312_51_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_755_32_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_755_33_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_503_13_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSSchedulingContext@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_995_9_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1012_13_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_169_14_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadScheduler@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_503_14_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_831_32_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1VirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_755_34_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_332_91_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1WorkQueue@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_54_0 {
	meta:
		name = "??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_766_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_767_3 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1055_26_0 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_CancellationTokenRegistration@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1055_27_0 {
	meta:
		name = "??_G_CancellationTokenState@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_CancellationTokenState@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_151_0 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Chore@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_36_40_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_1_2 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_Condition_variable@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_731_3 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_ExceptionHolder@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_76_3 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_Fac_node@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_173_3 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Facet_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_99_522_1 {
	meta:
		name = "??_G_Future_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Future_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_46_3 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_55_0 {
	meta:
		name = "??_G_Interruption_exception@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Interruption_exception@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_5_130_1 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Iostream_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_63_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Locimp@locale@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_11_694_2 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_RefCounterBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_736_3 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_132_1 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_System_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_57_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_TaskCollection@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_522_1 {
	meta:
		name = "??_G_TaskProcThunk@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_TaskProcThunk@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_746_12_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Timer@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_77_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1__ExceptionPtr@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1__non_rtti_object@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_768_2 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1agent@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_52_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_alloc@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_cast@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_254_79_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_78_2 {
	meta:
		name = "??_Gbad_function_call@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_function_call@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_769_1 {
	meta:
		name = "??_Gbad_target@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_target@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_typeid@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_111_166_3 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1codecvt_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_44_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1context_self_unblock@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_45_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1context_unblock_unbalanced@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_101_38_1 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_170_3 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ctype_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_81_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1default_scheduler_exists@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_692_2 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1101_18_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_500_7_0 {
	meta:
		name = "??_Gexception_ptr@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1exception_ptr@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_2_163_2 {
	meta:
		name = "??_Gfacet@locale@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1facet@locale@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_74_3 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1failure@ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_99_530_1 {
	meta:
		name = "??_Gfuture_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1future_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1180_48_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_lock@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_153_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_attach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_154_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_detach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_749_155_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_reference@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_287_9_0 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_argument@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_86_0 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_link_target@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1170_60_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_multiple_scheduling@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_693_2 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_operation@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_995_10_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_90_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1109_15_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1109_16_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_97_182_3 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_114_65_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1length_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_17_183_3 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1locale@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_111_43_1 {
	meta:
		name = "??_Glock_error@threads@stdext@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1lock_error@threads@stdext@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_304_21_0 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1logic_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_774_2 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1message_not_found@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_574_2 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1messages_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_196_9_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1missing_wait@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_575_2 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1money_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_856_49_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_775_3 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1operation_timed_out@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_76_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1out_of_range@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_114_68_1 {
	meta:
		name = "??_Goverflow_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1overflow_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_94_3 {
	meta:
		name = "??_Grange_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1range_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_89_86_3 {
	meta:
		name = "??_Gregex_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1regex_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_98_184_3 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1runtime_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_147_97_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_not_attached@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1012_14_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_191_12_0 {
	meta:
		name = "??_Gscheduler_worker_creation_error@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_worker_creation_error@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_140_1 {
	meta:
		name = "??_Gsystem_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1system_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_103_735_3 {
	meta:
		name = "??_Gtask_canceled@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1task_canceled@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_62_3 {
	meta:
		name = "??_Gthread_resource_error@threads@stdext@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1thread_resource_error@threads@stdext@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_57_611_3 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1time_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_5_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1type_info@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_57_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1unsupported_os@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_63_0 {
	meta:
		name = "?AddTail@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 165
		refs = "000e ??_C@_1BG@DFKLBKHK@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0013 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 001f ??_C@_1GK@MCONHIPB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0026 __CrtDbgReportW 009b ?Increment@Count@CollectionTypes@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8B 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 8B 45 FC 83 78 04 00 75 14 8B 4D 08 8B 55 08 89 51 18 8B 45 08 8B 4D 08 89 48 1C EB 36 8B 55 FC 8B 42 04 8B 4D 08 8B 50 18 89 51 18 8B 45 08 8B 4D FC 8B 51 04 89 50 1C 8B 45 FC 8B 48 04 8B 51 18 8B 45 08 89 42 1C 8B 4D FC 8B 51 04 8B 45 08 89 42 18 8B 4D FC 8B 55 08 89 51 04 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_64_0 {
	meta:
		name = "?AdjustDynamicAllocation@ResourceManager@details@Concurrency@@AAEIIII@Z"
		size = 339
		refs = "00a4 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00e4 ?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 48 56 89 4D FC C7 45 F0 00 00 00 00 8B 45 08 3B 45 0C 0F 83 D6 00 00 00 83 7D 10 01 75 1C B9 04 00 00 00 6B C9 00 8B 55 FC 8B 42 5C 8B 0C 08 8B 55 08 89 51 04 E9 AC 00 00 00 8B 45 08 89 45 E8 C7 45 EC 00 00 00 00 DF 6D E8 DD 5D D0 DD 45 D0 8B 4D 0C 89 4D E0 C7 45 E4 00 00 00 00 DF 6D E0 DD 5D C8 DC 75 C8 DD 5D B8 C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 10 73 4C 8B 4D FC 8B 51 5C 8B 45 F8 8B 34 82 8B 4D FC 8B 51 5C 8B 45 F8 8B 0C 82 8B 49 10 E8 ?? ?? ?? ?? 8B 56 24 2B D0 89 55 D8 C7 45 DC 00 00 00 00 DF 6D D8 DD 5D C0 DD 45 C0 DC 4D B8 8B 45 FC 8B 48 5C 8B 55 F8 8B 04 91 DD 58 08 EB A3 8B 4D 08 51 8B 55 10 52 8B 45 FC 8B 48 5C 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 89 55 F0 EB 56 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 3B 4D 10 73 36 8B 55 FC 8B 42 5C 8B 4D F4 8B 34 88 8B 55 FC 8B 42 5C 8B 4D F4 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 8B 4E 24 2B C8 8B 55 FC 8B 42 5C 8B 55 F4 8B 04 90 89 48 04 EB B9 8B 4D 0C 89 4D F0 8B 45 F0 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_65_0 {
	meta:
		name = "?ApplyAffinityLimits@AffinityRestriction@ResourceManager@details@Concurrency@@QAEXPAU_GROUP_AFFINITY@@@Z"
		size = 69
		refs = "0015 ?FindGroupAffinity@AffinityRestriction@ResourceManager@details@Concurrency@@QAEPAUHardwareAffinity@34@G@Z 0026 ?GetMask@HardwareAffinity@details@Concurrency@@QAEKXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 0F B7 48 04 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 14 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 23 02 8B 4D 08 89 01 EB 09 8B 55 08 C7 02 00 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_66_0 {
	meta:
		name = "?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAK@Z"
		size = 79
		refs = "0007 ___security_cookie 0032 ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z 0047 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 45 F0 00 00 00 00 33 C0 89 45 F4 89 45 F8 33 C9 66 89 4D F4 8B 55 08 8B 02 89 45 F0 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 45 F0 89 02 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_67_0 {
	meta:
		name = "?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z"
		size = 127
		refs = "0005 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 000e ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0016 ??_C@_1IM@EMFLNEJJ@?$AAs?$AA_?$AAp?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAA?$AAf?$AAf?$AAi?$AAn?$AAi?$AAt?$AAy?$AAR?$AAe?$AAs?$AAt?$AAr?$AAi?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN@ 001b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0027 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 005f ?ApplyAffinityLimits@AffinityRestriction@ResourceManager@details@Concurrency@@QAEXPAU_GROUP_AFFINITY@@@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 2F 83 3D ?? ?? ?? ?? 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3E 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C4 33 D2 75 C0 8B 45 08 83 38 00 74 32 83 3D ?? ?? ?? ?? 00 74 11 8B 4D 08 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 18 83 3D ?? ?? ?? ?? 00 74 0F 8B 55 08 52 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_41_68_0 {
	meta:
		name = "?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z"
		size = 165
		refs = "000a ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0014 ?s_pfnSetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@1@ZA 001a ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0036 ??_C@_1FG@ILFAILPD@?$AAf?$AAn?$AAD?$AAe?$AAc?$AAo?$AAd?$AAe?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?$CI?$AAh?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AA?0?$AA?5?$AA?$CG?$AAm?$AA_?$AAa?$AAf@ 003b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0047 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004e __CrtDbgReportW 006d __imp__SetThreadAffinityMask@8 0076 ??_C@_1GA@IEBMGJMO@?$AAS?$AAe?$AAt?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAA?$AAf?$AAf?$AAi?$AAn?$AAi?$AAt?$AAy?$AAM?$AAa?$AAs?$AAk?$AA?$CI?$AAh?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AA?0?$AA?5?$AAm@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC E8 ?? ?? ?? ?? 83 F8 04 7C 4E A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 6A 00 8B 4D FC 51 8B 55 08 52 FF 55 F8 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 CF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C5 EB 3E 8B 55 FC 8B 02 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D3 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C2 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_69_0 {
	meta:
		name = "?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ"
		size = 639
		refs = "0006 __ehhandler$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0015 ___security_cookie 0029 ?s_systemAffinityMask@ResourceManager@details@Concurrency@@0KA 002e ?s_processAffinityMask@ResourceManager@details@Concurrency@@0KA 0034 __imp__GetCurrentProcess@0 003b __imp__GetProcessAffinityMask@12 0045 __imp__GetLastError@0 004b _HRESULT_FROM_WIN32 0057 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 005c __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0065 __CxxThrowException@8 007d ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 008a __imp__GetCurrentThread@0 0093 ??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z 00a8 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00b6 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00d7 ?GetGroup@HardwareAffinity@details@Concurrency@@QAEGXZ 00e3 ??0HardwareAffinity@details@Concurrency@@QAE@GK@Z 0146 ??0AffinityRestriction@ResourceManager@details@Concurrency@@QAE@GPAUHardwareAffinity@23@@Z 0168 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 017b ??_C@_1GI@ODAPOKOM@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 0180 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 018c ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0193 __CrtDbgReportW 021c ??0HardwareAffinity@details@Concurrency@@QAE@K@Z 0277 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 68 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D 8C E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 8C 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 0F 84 EB 01 00 00 83 3D ?? ?? ?? ?? 04 0F 8C E9 00 00 00 FF 15 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 33 D2 88 55 E0 8D 45 E0 89 45 B4 68 2C 03 00 00 68 ?? ?? ?? ?? 8B 4D B4 0F B6 11 52 6A 0C E8 ?? ?? ?? ?? 83 C4 10 89 45 C8 C7 45 FC 00 00 00 00 83 7D C8 00 74 1F A1 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 0F B7 C8 51 8B 4D C8 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 A0 C7 45 FC FF FF FF FF 8B 45 A0 89 45 A4 33 C9 88 4D E1 8D 55 E1 89 55 BC 68 2D 03 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 08 51 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 C7 45 FC 01 00 00 00 83 7D C0 00 74 13 8B 55 A4 52 6A 01 8B 4D C0 E8 ?? ?? ?? ?? 89 45 C4 EB 07 C7 45 C4 00 00 00 00 8B 45 C4 89 45 AC C7 45 FC FF FF FF FF 8B 4D AC 89 0D ?? ?? ?? ?? E9 F5 00 00 00 83 3D ?? ?? ?? ?? 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 32 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 33 D2 88 55 E3 8D 45 E3 89 45 9C 68 33 03 00 00 68 ?? ?? ?? ?? 8B 4D 9C 0F B6 11 52 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 C7 45 FC 02 00 00 00 83 7D D0 00 74 6B 33 C0 88 45 E2 8D 4D E2 89 4D B8 68 33 03 00 00 68 ?? ?? ?? ?? 8B 55 B8 0F B6 02 50 6A 0C E8 ?? ?? ?? ?? 83 C4 10 89 45 CC C6 45 FC 03 83 7D CC 00 74 14 8B 0D ?? ?? ?? ?? 51 8B 4D CC E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 55 D8 89 55 B0 C6 45 FC 02 8B 45 B0 50 6A 01 8B 4D D0 E8 ?? ?? ?? ?? 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D A8 C7 45 FC FF FF FF FF 8B 55 A8 89 15 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_70_0 {
	meta:
		name = "__unwindfunclet$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ$0"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 2C 03 00 00 68 ?? ?? ?? ?? 8B 45 B4 0F B6 00 50 8B 45 C8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_71_0 {
	meta:
		name = "__unwindfunclet$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ$1"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 2D 03 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 00 50 8B 45 C0 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_72_0 {
	meta:
		name = "__unwindfunclet$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ$2"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 33 03 00 00 68 ?? ?? ?? ?? 8B 45 9C 0F B6 00 50 8B 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_73_0 {
	meta:
		name = "__unwindfunclet$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ$3"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 33 03 00 00 68 ?? ?? ?? ?? 8B 45 B8 0F B6 00 50 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_74_0 {
	meta:
		name = "__ehhandler$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_178_2 {
	meta:
		name = "__ehhandler$?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PB_W@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PB_W@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_75_0 {
	meta:
		name = "?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ"
		size = 39
		refs = "0004 ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 000a _free 001d ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_41_76_0 {
	meta:
		name = "?CommitStolenCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z"
		size = 595
		refs = "0023 ??_C@_1GC@NENMEBKN@?$AAp?$AAN?$AAe?$AAw?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD@ 0028 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0034 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003b __CrtDbgReportW 0054 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00f6 ?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ 0161 ?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ 017e ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 01a4 ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 01bb ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 01e3 ??_C@_1GG@PNGFHBFM@?$AAp?$AAN?$AAe?$AAw?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs@ 0249 ?ValidateBorrowedCores@ResourceManager@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 34 89 4D F4 B8 04 00 00 00 6B C0 00 8B 4D F4 8B 51 54 8B 04 02 8B 4D 08 3B 48 10 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8B 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 BD 33 C9 75 B9 8B 4D 08 E8 ?? ?? ?? ?? 89 45 D4 C7 45 EC 00 00 00 00 EB 09 8B 55 EC 83 C2 01 89 55 EC 8B 45 F4 8B 4D EC 3B 48 18 0F 83 C9 01 00 00 8B 55 EC 6B D2 34 03 55 D4 89 55 DC C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D DC 8B 55 FC 3B 51 04 0F 83 97 01 00 00 8B 45 FC 6B C0 34 8B 4D DC 03 41 30 89 45 E0 C7 45 D8 00 00 00 00 C7 45 F0 01 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 F4 8B 4D F0 3B 48 08 0F 83 5B 01 00 00 8B 55 F4 8B 42 54 8B 4D F0 8B 14 88 8B 42 10 89 45 E4 8B 4D E4 E8 ?? ?? ?? ?? 89 45 D0 8B 4D D0 83 79 2C 00 0F 86 2C 01 00 00 8B 55 F4 8B 42 54 8B 4D F0 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 89 45 CC 8B 45 EC 6B C0 34 03 45 CC 89 45 E8 8B 4D FC 6B C9 34 8B 55 E8 03 4A 30 89 4D F8 8B 45 F8 83 38 05 0F 85 EE 00 00 00 8B 4D E0 83 39 04 0F 85 86 00 00 00 8B 55 E0 83 7A 18 00 75 6B 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 06 83 7D D8 00 74 12 8B 4D FC 51 8B 55 E8 52 8B 4D E4 E8 ?? ?? ?? ?? EB 42 8B 45 F8 8B 48 14 8B 11 83 C2 01 8B 45 F8 8B 48 14 89 11 8B 55 F8 C7 02 04 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 10 8B 4D FC 51 8B 55 E8 52 8B 4D E4 E8 ?? ?? ?? ?? C7 45 D8 01 00 00 00 EB 10 8B 45 FC 50 8B 4D E8 51 8B 4D E4 E8 ?? ?? ?? ?? EB 5C 8B 55 E0 83 3A 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C8 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA 8B 45 F8 8B 48 14 8B 11 83 C2 01 8B 45 F8 8B 48 14 89 11 8B 55 FC 6B D2 34 8B 45 E8 8B 48 30 C7 04 0A 04 00 00 00 E9 8D FE FF FF E9 51 FE FF FF E9 1F FE FF FF 8B 4D F4 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_77_0 {
	meta:
		name = "?ComputeDesiredHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 72
		refs = "000d ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 01 8B 4D FC 39 81 BC 00 00 00 73 0E 8B 55 FC 8B 82 BC 00 00 00 89 45 F8 EB 0E 8B 4D FC E8 ?? ?? ?? ?? 83 C0 01 89 45 F8 8B 4D F8 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_78_0 {
	meta:
		name = "?ComputeMinHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 72
		refs = "000d ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 01 8B 4D FC 39 81 BC 00 00 00 73 0E 8B 55 FC 8B 82 BC 00 00 00 89 45 F8 EB 0E 8B 4D FC E8 ?? ?? ?? ?? 83 C0 01 89 45 F8 8B 4D F8 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_80_0 {
	meta:
		name = "?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ"
		size = 563
		refs = "0006 __ehhandler$?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ 0015 ___security_cookie 0033 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0054 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0075 _memset 00c3 _memcpy 00d4 ??_C@_1DK@KPONIKKJ@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 00d9 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e5 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ec __CrtDbgReportW 0153 ??0SchedulerCore@details@Concurrency@@QAE@XZ 0162 ??_H@YGXPAXIHP6EPAX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 34 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E0 33 C0 88 45 F3 68 BF 05 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 55 E0 8B 42 18 BA 34 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C8 8B 45 C8 89 45 D4 8B 4D E0 8B 51 18 6B D2 34 52 6A 00 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 E0 8B 45 E4 3B 42 18 0F 83 84 01 00 00 8B 4D E4 6B C9 34 03 4D D4 89 4D EC 8B 55 E4 6B D2 28 8B 45 E0 03 50 48 89 55 D8 6A 18 8B 4D D8 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC 83 78 08 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C9 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D EC 8B 51 04 89 55 D0 33 C0 88 45 F2 8D 4D F2 89 4D C4 68 CB 05 00 00 68 ?? ?? ?? ?? 8B 55 C4 0F B6 02 50 33 C9 8B 45 D0 BA 34 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC C7 45 FC 00 00 00 00 83 7D DC 00 74 1C 68 ?? ?? ?? ?? 8B 45 D0 50 6A 34 8B 4D DC 51 E8 ?? ?? ?? ?? 8B 55 DC 89 55 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 C0 C7 45 FC FF FF FF FF 8B 4D EC 8B 55 C0 89 51 30 8B 45 EC 8B 48 04 6B C9 34 51 6A 00 8B 55 EC 8B 42 30 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 EC 8B 45 E8 3B 42 04 73 59 6A 0C 8B 4D E8 6B C9 24 8B 55 D8 03 4A 20 51 8B 45 E8 6B C0 34 8B 4D EC 03 41 30 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E8 6B D2 34 8B 45 EC 8B 48 30 C7 04 0A 01 00 00 00 8B 55 E8 6B D2 24 8B 45 D8 8B 48 20 8D 54 11 10 8B 45 E8 6B C0 34 8B 4D EC 8B 49 30 89 54 01 14 EB 93 E9 64 FE FF FF 8B 45 D4 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_81_0 {
	meta:
		name = "__unwindfunclet$?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ$0"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 CB 05 00 00 68 ?? ?? ?? ?? 8B 45 C4 0F B6 00 50 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_82_0 {
	meta:
		name = "__ehhandler$?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_13_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_233_3 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_239_3 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_3_0 {
	meta:
		name = "__ehhandler$??0UMSSchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSSchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_175_0 {
	meta:
		name = "__ehhandler$?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_960_1 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEJXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEJXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_963_1 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEJXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEJXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_83_0 {
	meta:
		name = "?CreateDynamicRMWorker@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 151
		refs = "0012 ?DynamicRMThreadProc@ResourceManager@details@Concurrency@@CGKPAX@Z 001e ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z 0036 __imp__GetLastError@0 003c _HRESULT_FROM_WIN32 0048 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 004d __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0056 __CxxThrowException@8 0065 __imp__SetThreadPriority@8"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D FC 6A 00 6A 00 8B 45 FC 50 68 ?? ?? ?? ?? 68 00 00 01 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 89 41 4C 8B 55 FC 83 7A 4C 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D EC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 6A 0F 8B 4D FC 8B 51 4C 52 FF 15 ?? ?? ?? ?? 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_84_0 {
	meta:
		name = "?CreateNodeTopology@ResourceManager@details@Concurrency@@UAEXIPAIPAPAI0@Z"
		size = 812
		refs = "0006 __ehhandler$?CreateNodeTopology@ResourceManager@details@Concurrency@@UAEXIPAIPAPAI0@Z 0016 ___security_cookie 0030 ??_C@_0L@GMKDIJLB@pCoreCount?$AA@ 0038 ??0invalid_argument@std@@QAE@PBD@Z 003d __TI3?AVinvalid_argument@std@@ 0046 __CxxThrowException@8 0051 ??_C@_09BKPLLCBE@nodeCount?$AA@ 0076 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 0088 ?Empty@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ 009a ??0invalid_operation@Concurrency@@QAE@XZ 009f __TI2?AVinvalid_operation@Concurrency@@ 00f1 ??_EGlobalCore@details@Concurrency@@QAEPAXI@Z 011e ??_EGlobalNode@details@Concurrency@@QAEPAXI@Z 013b ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 0179 ?s_coreCount@ResourceManager@details@Concurrency@@0IA 01a3 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 01cd ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0214 _memset 0233 __imp__GetCurrentProcess@0 023a __imp__GetProcessAffinityMask@12 0248 ??_C@_1BI@NFIPOIEG@?$AAr?$AAe?$AAt?$AAV?$AAa?$AAl?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 024d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0259 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0260 __CrtDbgReportW 0302 ?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z 0316 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 7C 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E8 83 7D 0C 00 75 1B 68 ?? ?? ?? ?? 8D 4D 90 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 90 50 E8 ?? ?? ?? ?? 83 7D 08 01 73 1B 68 ?? ?? ?? ?? 8D 4D 84 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D 84 51 E8 ?? ?? ?? ?? 8B 55 E8 83 C2 2C 52 8D 4D A0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E8 83 C1 60 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1C 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 EB 09 8B 55 E0 83 C2 01 89 55 E0 8B 45 E8 8B 4D E0 3B 48 18 73 37 8B 55 E0 6B D2 28 8B 45 E8 8B 48 48 8B 54 11 20 89 55 B8 8B 45 B8 89 45 D0 83 7D D0 00 74 0F 6A 03 8B 4D D0 E8 ?? ?? ?? ?? 89 45 B4 EB 07 C7 45 B4 00 00 00 00 EB B5 8B 4D E8 8B 51 48 89 55 B0 8B 45 B0 89 45 CC 83 7D CC 00 74 0F 6A 03 8B 4D CC E8 ?? ?? ?? ?? 89 45 AC EB 07 C7 45 AC 00 00 00 00 8B 4D E8 8B 55 08 89 51 18 8B 45 08 A3 ?? ?? ?? ?? C7 45 D8 00 00 00 00 C7 45 DC 00 00 00 00 EB 09 8B 4D DC 83 C1 01 89 4D DC 8B 55 E8 8B 45 DC 3B 42 18 73 11 8B 4D DC 8B 55 0C 8B 45 D8 03 04 8A 89 45 D8 EB DB 8B 4D D8 89 0D ?? ?? ?? ?? 8B 55 E8 A1 ?? ?? ?? ?? 89 42 1C C7 45 9C 00 00 00 00 8B 4D E8 8B 51 18 89 55 C8 33 C0 88 45 F3 68 7C 05 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 45 C8 BA 28 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 33 C0 83 C1 04 0F 92 C0 F7 D8 0B C1 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 83 7D D4 00 74 13 8B 4D D4 8B 55 C8 89 11 8B 45 D4 83 C0 04 89 45 C4 EB 07 C7 45 C4 00 00 00 00 8B 4D E8 8B 55 C4 89 51 48 8B 45 E8 8B 48 18 6B C9 28 51 6A 00 8B 55 E8 8B 42 48 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 BC 00 00 00 00 C7 45 A8 00 00 00 00 8D 4D A8 51 8D 55 BC 52 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 A4 83 7D A4 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 87 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E8 8B 55 E4 3B 51 18 73 79 33 C0 66 89 45 EC C7 45 C0 00 00 00 00 83 7D 14 00 74 30 83 7D E4 00 76 1C 8B 4D E4 8B 55 14 8B 45 E4 8B 75 14 8B 0C 8A 3B 4C 86 FC 74 07 C7 45 C0 00 00 00 00 8B 55 E4 8B 45 14 66 8B 0C 90 66 89 4D EC 8B 55 C0 52 8B 45 E4 8B 4D 0C 8B 14 81 52 8B 45 BC 50 0F B7 4D EC 51 0F B7 55 E4 52 8B 45 E8 50 8B 4D E4 6B C9 28 8B 55 E8 03 4A 48 E8 ?? ?? ?? ?? E9 73 FF FF FF C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_86_0 {
	meta:
		name = "__ehhandler$?CreateNodeTopology@ResourceManager@details@Concurrency@@UAEXIPAIPAPAI0@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$?CreateNodeTopology@ResourceManager@details@Concurrency@@UAEXIPAIPAPAI0@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 7C FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_151_3 {
	meta:
		name = "__ehhandler$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 7C FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_161_3 {
	meta:
		name = "__ehhandler$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$??$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 7C FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_340_1 {
	meta:
		name = "__ehhandler$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 7C FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_985_1 {
	meta:
		name = "__ehhandler$?_Reset@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$?_Reset@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 7C FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_88_0 {
	meta:
		name = "?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 201
		refs = "0006 __ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0015 ___security_cookie 0051 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0062 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0086 ??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 00b1 ??1SchedulerPolicy@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D DC 8D 45 E4 50 8B 4D 08 8B 11 8B 4D 08 8B 42 08 FF D0 C7 45 FC 00 00 00 00 33 C9 88 4D F3 8D 55 F3 89 55 E0 68 DD 0A 00 00 68 ?? ?? ?? ?? 8B 45 E0 0F B6 08 51 68 D0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC C6 45 FC 01 83 7D EC 00 74 19 8D 55 E4 52 8B 45 DC 50 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 55 E8 89 55 D8 C6 45 FC 00 8B 45 D8 89 45 D4 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_90_0 {
	meta:
		name = "__unwindfunclet$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z$1"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 DD 0A 00 00 68 ?? ?? ?? ?? 8B 45 E0 0F B6 00 50 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_91_0 {
	meta:
		name = "__ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_195_2 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_200_2 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_211_2 {
	meta:
		name = "__ehhandler$??$_Uninitialized_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@U?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninitialized_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@U?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_255_3 {
	meta:
		name = "__ehhandler$??$_Uninitialized_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@U?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninitialized_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@U?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_327_2 {
	meta:
		name = "__ehhandler$??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_370_3 {
	meta:
		name = "__ehhandler$??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_644_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_648_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_111_0 {
	meta:
		name = "__ehhandler$?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_31_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_24_0 {
	meta:
		name = "__ehhandler$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_270_0 {
	meta:
		name = "__ehhandler$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_831_82_0 {
	meta:
		name = "__ehhandler$?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_343_0 {
	meta:
		name = "__ehhandler$?Insert@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABI0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Insert@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABI0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_96_0 {
	meta:
		name = "__ehhandler$?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_387_19_0 {
	meta:
		name = "__ehhandler$?LocateSegment@FairScheduleGroup@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?LocateSegment@FairScheduleGroup@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_107_0 {
	meta:
		name = "__ehhandler$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_210_0 {
	meta:
		name = "__ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_218_0 {
	meta:
		name = "__ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_828_3 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_618_1 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_142_0 {
	meta:
		name = "__ehhandler$?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_898_1 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_901_3 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_904_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1084_2 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1087_3 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1291_3 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1294_3 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1297_3 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_92_0 {
	meta:
		name = "?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 382
		refs = "0006 __ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0015 ___security_cookie 002d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0042 ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 005a ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 006b ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0083 ??0ResourceManager@details@Concurrency@@AAE@XZ 00b4 ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 00cd ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 00db ?SafeReference@ResourceManager@details@Concurrency@@AAE_NXZ 0168 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 EC 00 00 00 00 68 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 7C 33 C0 88 45 F3 8D 4D F3 89 4D D8 68 87 01 00 00 68 ?? ?? ?? ?? 8B 55 D8 0F B6 02 50 68 8C 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C6 45 FC 01 83 7D E8 00 74 0D 8B 4D E8 E8 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D D4 C6 45 FC 00 8B 55 D4 89 55 EC 8B 45 EC 8B 10 8B 4D EC 8B 02 FF D0 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? E9 98 00 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 77 33 C9 88 4D F2 8D 55 F2 89 55 D0 68 91 01 00 00 68 ?? ?? ?? ?? 8B 45 D0 0F B6 08 51 68 8C 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C6 45 FC 02 83 7D E0 00 74 0D 8B 4D E0 E8 ?? ?? ?? ?? 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 CC C6 45 FC 00 8B 45 CC 89 45 EC 8B 4D EC 8B 11 8B 4D EC 8B 02 FF D0 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_94_0 {
	meta:
		name = "__unwindfunclet$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ$1"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 87 01 00 00 68 ?? ?? ?? ?? 8B 45 D8 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_95_0 {
	meta:
		name = "__unwindfunclet$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ$2"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 91 01 00 00 68 ?? ?? ?? ?? 8B 45 D0 0F B6 00 50 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_96_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_51_3 {
	meta:
		name = "__ehhandler$??$?GV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YAHAAV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@ABV10@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?GV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YAHAAV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@ABV10@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_55_3 {
	meta:
		name = "__ehhandler$??$?GV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YAHAAV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@ABV10@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?GV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YAHAAV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@ABV10@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_185_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_503_28_0 {
	meta:
		name = "__ehhandler$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_118_0 {
	meta:
		name = "__ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_733_1 {
	meta:
		name = "__ehhandler$?_Throw_future_error@std@@YAXABVerror_code@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Throw_future_error@std@@YAXABVerror_code@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1202_3 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1205_1 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1208_1 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_104_0 {
	meta:
		name = "__ehhandler$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1237_1 {
	meta:
		name = "__ehhandler$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1306_3 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1309_1 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_107_0 {
	meta:
		name = "__ehhandler$?reset@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reset@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1393_3 {
	meta:
		name = "__ehhandler$?unlink_target@?$_SyncOriginator@I@details@Concurrency@@UAEXPAV?$ITarget@I@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$_SyncOriginator@I@details@Concurrency@@UAEXPAV?$ITarget@I@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1396_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1399_3 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1402_1 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1405_1 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_97_0 {
	meta:
		name = "?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
		size = 191
		refs = "0006 __ehhandler$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z 0015 ___security_cookie 003a ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 004c ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 0060 ?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z 0071 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00a7 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C7 45 E8 00 00 00 00 8B 45 EC 83 C0 2C 50 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 60 E8 ?? ?? ?? ?? 89 45 F0 EB 12 8B 4D F0 51 8B 4D EC 83 C1 60 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 2F 8B 4D F0 E8 ?? ?? ?? ?? 89 45 E4 8B 55 08 6B D2 34 8B 45 0C 6B C0 34 8B 4D E4 03 44 11 30 89 45 E0 8B 55 E0 8B 42 18 03 45 E8 89 45 E8 EB B9 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 E8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_99_0 {
	meta:
		name = "__ehhandler$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_92_3 {
	meta:
		name = "__ehhandler$??$_Debug_range@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Debug_range@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_97_3 {
	meta:
		name = "__ehhandler$??$_Debug_range@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Debug_range@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_93_2 {
	meta:
		name = "__ehhandler$??$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@I@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AAI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@I@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AAI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_127_3 {
	meta:
		name = "__ehhandler$??$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@I@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AAI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@I@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AAI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_11_0 {
	meta:
		name = "__ehhandler$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1055_18_0 {
	meta:
		name = "__ehhandler$??1_CancellationTokenState@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_CancellationTokenState@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_39_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_856_60_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_181_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_61_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_30_0 {
	meta:
		name = "__ehhandler$?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UAEPAVScheduleGroup@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UAEPAVScheduleGroup@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_90_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_843_33_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_33_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_54_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_93_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_319_0 {
	meta:
		name = "__ehhandler$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_172_0 {
	meta:
		name = "__ehhandler$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_463_0 {
	meta:
		name = "__ehhandler$?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_90_0 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_128_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_393_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_783_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_786_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_477_26_0 {
	meta:
		name = "__ehhandler$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_889_2 {
	meta:
		name = "__ehhandler$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_501_2 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1286_3 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1289_3 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_406_3 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_1051_2 {
	meta:
		name = "__ehhandler$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_1037_2 {
	meta:
		name = "__ehhandler$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_100_0 {
	meta:
		name = "?Decrement@Count@CollectionTypes@details@Concurrency@@QAEXXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 E9 01 8B 55 FC 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_101_0 {
	meta:
		name = "?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 158
		refs = "006a ??_C@_1IM@KOCFIBME@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAE?$AAx?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAd?$AAe?$AAs@ 006f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007b ??_C@_1HA@HKMLDPPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0082 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 88 80 00 00 00 8B 55 FC 03 8A B8 00 00 00 8B 45 FC 39 88 BC 00 00 00 73 0E 8B 4D FC 8B 91 BC 00 00 00 89 55 F8 EB 15 8B 45 FC 8B 88 80 00 00 00 8B 55 FC 03 8A B8 00 00 00 89 4D F8 8B 45 F8 89 45 F4 8B 4D FC 83 B9 B4 00 00 00 00 75 34 8B 55 FC 8B 45 F4 3B 82 80 00 00 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BC 33 C0 75 B8 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_102_0 {
	meta:
		name = "?DestroyAllocatedNodeData@ResourceManager@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z"
		size = 92
		refs = "003b ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 8B 55 FC 3B 51 18 73 1E 8B 45 FC 6B C0 34 8B 4D 08 8B 54 01 30 89 55 F4 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 EB CE 8B 4D 08 89 4D F0 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_103_0 {
	meta:
		name = "?DetermineTopology@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 1828
		refs = "001d ??_C@_1FO@PJCCFBDN@?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl@ 0022 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002e ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0035 __CrtDbgReportW 004c ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 0060 ??_C@_1FK@ICNGNLCA@?$AAs?$AA_?$AAn?$AAo?$AAd?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AA_?$AAn?$AAo?$AAd?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM@ 0091 ?s_numaNodeCount@ResourceManager@details@Concurrency@@0IA 00a9 ?s_coreCount@ResourceManager@details@Concurrency@@0IA 00bb ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00dc ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0103 _memset 0198 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 01ac ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 01c6 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 01f0 ?s_countProcessorPackages@ResourceManager@details@Concurrency@@0_NA 0209 ??_C@_1EM@KKPNDFAF@?$AAp?$AAS?$AAy?$AAs?$AAI?$AAn?$AAf?$AAo?$AAE?$AAx?$AA?9?$AA?$DO?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AA?4?$AAG?$AAr?$AAo?$AAu?$AAp?$AAC?$AAo?$AAu?$AAn?$AAt@ 0284 ?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z 0337 ?Initialize@GlobalNumaNode@details@Concurrency@@QAEXKGK@Z 036d ??_C@_1DC@KJFIMBMK@?$AAn?$AAo?$AAd?$AAe?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAo?$AAd?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 03a6 ??_C@_1DK@JPFOALPH@?$AAn?$AAu?$AAm?$AAa?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAu?$AAm?$AAa?$AAN?$AAo?$AAd?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 03d4 ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ 03e7 ??_C@_1GI@ODAPOKOM@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 068c ??_C@_1NM@INAKGLKE@?$AA?$CI?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AAs?$AA?$FL?$AAi?$AA?$FN?$AA?4?$AAm?$AA_?$AAn?$AAo?$AAd?$AAe?$AAA?$AAf?$AAf?$AAi?$AAn?$AAi?$AAt@ 06ed ??_C@_1BI@GCMBAGJO@?$AAf?$AAD?$AAi?$AAs?$AAc?$AAo?$AAv?$AAe?$AAr?$AAe?$AAd?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 4C 56 89 4D F8 8B 45 F8 83 78 48 00 75 09 8B 4D F8 83 79 44 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 56 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C4 33 C9 75 C0 83 3D ?? ?? ?? ?? 00 76 0C 81 3D ?? ?? ?? ?? FF FF FF 7F 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 57 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C1 33 C9 75 BD 8B 55 F8 A1 ?? ?? ?? ?? 89 42 14 8B 4D F8 8B 15 ?? ?? ?? ?? 89 51 18 8B 45 F8 8B 0D ?? ?? ?? ?? 89 48 1C 33 D2 88 55 FE 68 5E 04 00 00 68 ?? ?? ?? ?? 0F B6 45 FE 50 33 C9 8B 55 F8 8B 42 14 BA 0C 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 B4 8B 45 F8 8B 4D B4 89 48 44 8B 55 F8 8B 42 14 6B C0 0C 50 6A 00 8B 4D F8 8B 51 44 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B 48 18 89 4D C4 33 D2 88 55 FD 68 61 04 00 00 68 ?? ?? ?? ?? 0F B6 45 FD 50 33 C9 8B 45 C4 BA 28 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 33 C0 83 C1 04 0F 92 C0 F7 D8 0B C1 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 83 7D D0 00 74 13 8B 4D D0 8B 55 C4 89 11 8B 45 D0 83 C0 04 89 45 C0 EB 07 C7 45 C0 00 00 00 00 8B 4D F8 8B 55 C0 89 51 48 8B 45 F8 8B 48 18 6B C9 28 51 6A 00 8B 55 F8 8B 42 48 50 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 04 0F 8C 3A 02 00 00 C7 45 CC 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D F4 C7 45 EC 00 00 00 00 C7 45 D8 00 00 00 00 8B 55 CC 3B 15 ?? ?? ?? ?? 0F 83 91 01 00 00 8B 45 F4 8B 08 89 4D BC 83 7D BC 01 0F 84 C9 00 00 00 83 7D BC 03 74 05 E9 57 01 00 00 0F B6 15 ?? ?? ?? ?? 85 D2 0F 84 AA 00 00 00 8B 45 F4 0F B7 48 1E 83 F9 01 7D 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 79 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CA 33 C9 75 C6 C7 45 DC 00 00 00 00 8B 55 DC 6B D2 0C 8B 45 F4 83 7C 10 20 00 74 44 6A 00 6A 00 8B 4D DC 6B C9 0C 8B 55 F4 8B 44 0A 20 50 8B 4D DC 6B C9 0C 8B 55 F4 0F B7 44 0A 24 50 0F B7 4D EC 51 8B 55 F8 52 8B 4D EC 6B C9 28 8B 45 F8 03 48 48 E8 ?? ?? ?? ?? 8B 4D EC 83 C1 01 89 4D EC 8B 55 DC 83 C2 01 89 55 DC 8B 45 F4 0F B7 48 1E 39 4D DC 7C 97 E9 99 00 00 00 0F B6 15 ?? ?? ?? ?? 85 D2 75 55 8B 45 F4 83 78 20 00 74 4C 6A 00 6A 00 8B 4D F4 8B 51 20 52 8B 45 F4 0F B7 48 24 51 0F B7 55 EC 52 8B 45 F8 50 8B 4D EC 6B C9 28 8B 55 F8 03 4A 48 E8 ?? ?? ?? ?? 8B 45 EC 6B C0 28 8B 4D F8 8B 51 48 8B 4D F4 8B 49 08 89 4C 02 14 8B 55 EC 83 C2 01 89 55 EC 8B 45 F4 83 78 20 00 74 30 8B 4D F4 8B 51 20 52 8B 45 F4 0F B7 48 24 51 8B 55 F4 8B 42 08 50 8B 4D D8 6B C9 0C 8B 55 F8 03 4A 44 E8 ?? ?? ?? ?? 8B 45 D8 83 C0 01 89 45 D8 8B 4D F4 8B 55 CC 03 51 04 89 55 CC 8B 45 F4 8B 4D F4 03 48 04 89 4D F4 E9 60 FE FF FF 8B 55 F8 8B 45 EC 3B 42 18 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AD 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 8B 4D F8 8B 55 D8 3B 51 14 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AE 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CB 33 D2 75 C7 E8 ?? ?? ?? ?? E9 E0 01 00 00 83 3D ?? ?? ?? ?? 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B5 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 C7 45 C8 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 C7 45 E8 00 00 00 00 C7 45 D4 00 00 00 00 8B 4D C8 3B 0D ?? ?? ?? ?? 0F 83 06 01 00 00 8B 55 F0 8B 42 04 89 45 B8 83 7D B8 01 74 57 83 7D B8 03 74 0A E9 D5 00 00 00 E9 D0 00 00 00 0F B6 0D ?? ?? ?? ?? 85 C9 74 37 8B 55 F0 83 3A 00 74 2F 6A 00 6A 00 8B 45 F0 8B 08 51 6A 00 0F B7 55 E8 52 8B 45 F8 50 8B 4D E8 6B C9 28 8B 55 F8 03 4A 48 E8 ?? ?? ?? ?? 8B 45 E8 83 C0 01 89 45 E8 E9 89 00 00 00 0F B6 0D ?? ?? ?? ?? 85 C9 75 4D 8B 55 F0 83 3A 00 74 45 6A 00 6A 00 8B 45 F0 8B 08 51 6A 00 0F B7 55 E8 52 8B 45 F8 50 8B 4D E8 6B C9 28 8B 55 F8 03 4A 48 E8 ?? ?? ?? ?? 8B 45 E8 6B C0 28 8B 4D F8 8B 51 48 8B 4D F0 8B 49 08 89 4C 02 14 8B 55 E8 83 C2 01 89 55 E8 8B 45 F0 83 38 00 74 29 8B 4D F0 8B 11 52 6A 00 8B 45 F0 8B 48 08 51 8B 4D D4 6B C9 0C 8B 55 F8 03 4A 44 E8 ?? ?? ?? ?? 8B 45 D4 83 C0 01 89 45 D4 8B 4D C8 83 C1 18 89 4D C8 8B 55 F0 83 C2 18 89 55 F0 E9 EB FE FF FF 8B 45 F8 8B 4D E8 3B 48 18 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F1 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CB 33 C9 75 C7 8B 55 F8 8B 45 D4 3B 42 14 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F2 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 E8 ?? ?? ?? ?? 0F B6 0D ?? ?? ?? ?? 85 C9 0F 84 53 01 00 00 C7 45 E4 00 00 00 00 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 F8 8B 4D E4 3B 48 18 0F 83 32 01 00 00 C6 45 FF 00 C7 45 E0 00 00 00 00 EB 09 8B 55 E0 83 C2 01 89 55 E0 8B 45 F8 8B 4D E0 3B 48 14 0F 83 D2 00 00 00 8B 55 E4 6B D2 28 8B 45 F8 8B 48 48 8B 45 E0 6B C0 0C 8B 75 F8 8B 76 44 8B 4C 11 0C 3B 4C 06 04 0F 85 A7 00 00 00 8B 55 E4 6B D2 28 8B 45 F8 8B 48 48 8B 45 E0 6B C0 0C 8B 75 F8 8B 76 44 8B 0C 11 23 0C 06 0F 84 83 00 00 00 8B 55 E4 6B D2 28 8B 45 F8 8B 48 48 8B 45 E0 6B C0 0C 8B 75 F8 8B 76 44 8B 0C 11 23 0C 06 8B 55 E4 6B D2 28 8B 45 F8 8B 40 48 3B 0C 02 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 A7 33 C0 75 A3 8B 4D E0 6B C9 0C 8B 55 F8 8B 42 44 8B 55 E4 6B D2 28 8B 75 F8 8B 76 48 8B 44 08 08 89 44 16 14 C6 45 FF 01 EB 05 E9 16 FF FF FF 0F B6 4D FF 85 C9 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0F 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA E9 B6 FE FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_104_0 {
	meta:
		name = "?DiscardExistingSchedulerStatistics@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 245
		refs = "0013 ??_C@_1CI@MLKCALNG@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA1?$AA?$AA@ 0018 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0024 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 004a ??_C@_1EM@HPCPHMHG@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAL?$AAo?$AAa?$AAd?$AAB?$AAa@ 0085 ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 0099 ?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z 00b8 ?GetQueueLength@SchedulerProxy@details@Concurrency@@QAEIXZ 00c3 ?Scheduler@SchedulerProxy@details@Concurrency@@QBEPAUIScheduler@3@XZ 00eb ?SetQueueLength@SchedulerProxy@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D F8 8B 45 F8 83 78 08 01 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D4 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D F8 83 79 28 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D5 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 C7 45 FC 00 00 00 00 8B 4D F8 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC EB 12 8B 55 FC 52 8B 4D F8 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 4B C7 45 E8 00 00 00 00 C7 45 EC 00 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 89 45 F0 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 8D 45 F0 50 8D 4D EC 51 8D 55 E8 52 8B 45 F4 8B 10 8B 4D F4 8B 42 04 FF D0 8B 4D F0 51 8B 4D FC E8 ?? ?? ?? ?? EB 9D 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_105_0 {
	meta:
		name = "?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ"
		size = 1080
		refs = "0015 ??_C@_1CK@CDOGMKIO@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 001a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0026 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002d __CrtDbgReportW 0049 ?Empty@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ 005f ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 006d ??_C@_1CK@LCJKKBJN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 009e ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00a8 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00b1 ??_C@_1JO@PDFBBMCL@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd@ 00e2 ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00f6 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0101 ??_C@_1OE@KFCEFBEK@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC@ 0161 ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z 017c ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0187 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 02f4 ??_C@_1EE@PEPCCENE@?$AA?$CK?$AAp?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAU?$AAs?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AAP?$AAt?$AAr?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 0342 ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z 035d ??_C@_1FO@IGJMPFHA@?$AAp?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AAC@ 038e ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 03a5 ??_C@_1EE@EMEOEDLB@?$AA?$CK?$AAp?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAU?$AAs?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AAP?$AAt?$AAr?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 03de ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 03f0 ?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ 0401 ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 4C 56 57 89 4D E8 8B 45 E8 83 78 08 01 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C9 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D E8 83 C1 60 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 0F 85 D8 03 00 00 8B 4D E8 83 C1 60 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 CF 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 3B F0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D0 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 8B F8 8B 4D F8 E8 ?? ?? ?? ?? 2B F8 3B F7 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D1 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 B4 33 C9 75 B0 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 3B F0 72 10 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 86 98 02 00 00 8B 4D F8 E8 ?? ?? ?? ?? 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 B8 8B 4D F8 E8 ?? ?? ?? ?? 8B 55 B8 2B D0 89 55 D8 8B 4D F8 E8 ?? ?? ?? ?? 89 45 D0 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D E8 3B 41 1C 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8A 55 CC 88 55 FF C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D E8 8B 55 F4 3B 51 18 0F 83 17 02 00 00 83 7D D8 00 76 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 0F B6 45 FF 23 45 C8 88 45 FF 0F B6 4D FF 85 C9 0F 84 97 00 00 00 8B 55 F4 89 55 DC 8B 45 DC 8B 4D F0 8B 14 81 6B D2 34 03 55 D0 89 55 C0 8B 45 F4 83 C0 01 89 45 E0 EB 09 8B 4D E0 83 C1 01 89 4D E0 8B 55 E8 8B 45 E0 3B 42 18 73 2E 8B 4D E0 8B 55 F0 8B 04 8A 6B C0 34 03 45 D0 89 45 C4 8B 4D C4 8B 55 C0 8B 41 1C 3B 42 1C 76 0C 8B 4D E0 89 4D DC 8B 55 C4 89 55 C0 EB BE 8B 45 F4 3B 45 DC 74 2A 8B 4D F4 8B 55 F0 8B 04 8A 89 45 B4 8B 4D F4 8B 55 F0 8B 45 DC 8B 75 F0 8B 04 86 89 04 8A 8B 4D DC 8B 55 F0 8B 45 B4 89 04 8A 8B 4D F4 8B 55 F0 8B 04 8A 6B C0 34 03 45 D0 89 45 D4 C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 D4 8B 45 E4 3B 42 04 0F 83 1C 01 00 00 8B 4D E4 6B C9 34 8B 55 D4 03 4A 30 89 4D EC 8B 45 EC 83 38 01 75 72 83 7D D8 00 76 67 8B 4D EC 8B 51 14 83 3A 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CB 33 D2 75 C7 8B 45 EC 8B 48 14 8B 11 83 C2 01 8B 45 EC 8B 48 14 89 11 6A 00 8B 55 E4 52 8B 45 D4 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D D8 83 E9 01 89 4D D8 E9 8E 00 00 00 8B 55 EC 83 3A 04 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 12 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 49 8B 4D EC 8B 51 14 83 3A 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 15 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CB 33 D2 75 C7 8B 45 E4 50 8B 4D D4 51 8B 4D F8 E8 ?? ?? ?? ?? E9 CC FE FF FF E9 D1 FD FF FF 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0A 6A 00 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 3B F0 75 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8A 45 BC EB 02 B0 01 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_106_0 {
	meta:
		name = "?DistributeExclusiveCores@ResourceManager@details@Concurrency@@AAEXIIIII@Z"
		size = 603
		refs = "007f ?FindCoreForPartiallyFilledNode@ResourceManager@details@Concurrency@@AAE_NAAI0PAUDynamicAllocationData@23@I@Z 0183 ??_C@_1CC@MAHLNJCC@?$AAn?$AAu?$AAm?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0188 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0194 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 019b __CrtDbgReportW 01fa ?FindBestFitExclusiveAllocation@ResourceManager@details@Concurrency@@AAEIAAI0PAUDynamicAllocationData@23@II@Z 0227 ??_C@_1DA@INFPFCGI@?$AAr?$AAe?$AAm?$AAa?$AAi?$AAn?$AAi?$AAn?$AAg?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAe?$AAr?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 89 4D F8 C6 45 FF 00 C6 45 FF 00 C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D 14 73 69 8B 55 F8 8B 42 5C 8B 4D F0 8B 14 88 83 7A 04 00 76 55 8B 45 F8 8B 48 5C 8B 55 F0 8B 04 91 8B 4D F8 8B 51 5C 8B 4D F0 8B 14 8A 8B 40 28 3B 42 2C 76 35 C6 45 FF 01 8B 4D 18 51 8B 55 F8 8B 42 5C 8B 4D F0 8B 14 88 52 8D 45 10 50 8D 4D 0C 51 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 8B 45 08 83 E8 01 89 45 08 EB 86 0F B6 4D FF 85 C9 0F 85 6D FF FF FF 83 7D 08 00 0F 86 A9 01 00 00 8B 55 14 89 55 EC C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 3B 4D 14 0F 83 A7 00 00 00 8B 55 F4 89 55 E4 8B 45 F4 83 C0 01 89 45 E8 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 E8 3B 55 14 73 28 8B 45 F8 8B 48 5C 8B 55 E8 8B 04 91 8B 4D F8 8B 51 5C 8B 4D E4 8B 14 8A 8B 40 04 3B 42 04 76 06 8B 4D E8 89 4D E4 EB C7 8B 55 F4 3B 55 E4 74 36 8B 45 F8 8B 48 5C 8B 55 F4 8B 04 91 89 45 D8 8B 4D F8 8B 51 5C 8B 45 F8 8B 48 5C 8B 45 F4 8B 75 E4 8B 14 B2 89 14 81 8B 45 F8 8B 48 5C 8B 55 E4 8B 45 D8 89 04 91 8B 4D F8 8B 51 5C 8B 45 F4 8B 0C 82 83 79 04 00 75 08 8B 55 F4 89 55 EC EB 05 E9 44 FF FF FF 8B 45 EC 89 45 14 83 7D 14 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 89 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC C7 45 E0 00 00 00 00 EB 09 8B 4D E0 83 C1 01 89 4D E0 8B 55 E0 3B 55 14 73 50 8B 45 F8 8B 48 5C 8B 55 E0 8B 04 91 89 45 DC 8B 4D DC 83 79 04 00 76 36 8B 55 18 52 8B 45 EC 50 8B 4D DC 51 8D 55 10 52 8D 45 0C 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 2B C8 89 4D 08 8B 55 DC 83 7A 04 00 75 09 8B 45 EC 83 E8 01 89 45 EC EB 9F 83 7D 08 00 77 90 83 7D EC 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A2 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 5E 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_41_107_0 {
	meta:
		name = "?DistributeIdleCores@ResourceManager@details@Concurrency@@AAEXII@Z"
		size = 801
		refs = "0073 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 0090 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00bb ??_C@_1MO@NGHNCBAP@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 00c0 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00cc ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d3 __CrtDbgReportW 010e ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 024b ??_C@_1CC@MAHLNJCC@?$AAn?$AAu?$AAm?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 02c0 ?FindBestFitIdleAllocation@ResourceManager@details@Concurrency@@AAEIIPAUDynamicAllocationData@23@I@Z 02ed ??_C@_1DA@INFPFCGI@?$AAr?$AAe?$AAm?$AAa?$AAi?$AAn?$AAi?$AAn?$AAg?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAe?$AAr?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 3C 56 89 4D F4 C6 45 FF 00 C6 45 FF 00 C7 45 DC 00 00 00 00 EB 09 8B 45 DC 83 C0 01 89 45 DC 8B 4D DC 3B 4D 0C 0F 83 2D 01 00 00 83 7D 08 00 0F 86 23 01 00 00 8B 55 F4 8B 42 5C 8B 4D DC 8B 14 88 89 55 F8 8B 45 F8 83 78 04 00 0F 86 02 01 00 00 8B 4D F8 8B 55 F8 8B 41 28 3B 42 2C 0F 86 F0 00 00 00 C6 45 FF 01 8B 4D F8 8B 49 10 E8 ?? ?? ?? ?? 89 45 CC 8B 55 F8 8B 42 2C 8B 4D CC 8B 14 81 89 55 D4 8B 45 F8 8B 48 10 E8 ?? ?? ?? ?? 89 45 C8 8B 4D D4 6B C9 34 03 4D C8 89 4D E8 8B 55 E8 83 7A 1C 00 76 0E 8B 45 E8 8B 4D E8 8B 50 1C 3B 51 04 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 28 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BF 33 D2 75 BB 8B 45 D4 6B C0 28 8B 4D F4 8B 51 48 83 7C 02 1C 00 76 4E 6A 01 6A 01 8B 45 D4 50 8B 4D F8 8B 51 10 52 8B 4D F4 E8 ?? ?? ?? ?? 8B 45 E8 8B 4D E8 8B 50 1C 3B 51 04 75 0F 8B 45 F8 8B 48 2C 83 C1 01 8B 55 F8 89 4A 2C 8B 45 F8 8B 48 04 83 E9 01 8B 55 F8 89 4A 04 8B 45 08 83 E8 01 89 45 08 EB 0F 8B 4D F8 8B 51 2C 83 C2 01 8B 45 F8 89 50 2C E9 BE FE FF FF 0F B6 4D FF 85 C9 0F 85 A5 FE FF FF 83 7D 08 00 0F 86 A7 01 00 00 8B 55 0C 89 55 EC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D 0C 0F 83 A7 00 00 00 8B 55 F0 89 55 E0 8B 45 F0 83 C0 01 89 45 E4 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 E4 3B 55 0C 73 28 8B 45 F4 8B 48 5C 8B 55 E4 8B 04 91 8B 4D F4 8B 51 5C 8B 4D E0 8B 14 8A 8B 40 04 3B 42 04 76 06 8B 4D E4 89 4D E0 EB C7 8B 55 F0 3B 55 E0 74 36 8B 45 F4 8B 48 5C 8B 55 F0 8B 04 91 89 45 C4 8B 4D F4 8B 51 5C 8B 45 F4 8B 48 5C 8B 45 F0 8B 75 E0 8B 14 B2 89 14 81 8B 45 F4 8B 48 5C 8B 55 E0 8B 45 C4 89 04 91 8B 4D F4 8B 51 5C 8B 45 F0 8B 0C 82 83 79 04 00 75 08 8B 55 F0 89 55 EC EB 05 E9 44 FF FF FF 8B 45 EC 89 45 0C 83 7D 0C 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 61 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC C7 45 D8 00 00 00 00 EB 09 8B 4D D8 83 C1 01 89 4D D8 8B 55 D8 3B 55 0C 73 4E 83 7D 08 00 76 48 8B 45 F4 8B 48 5C 8B 55 D8 8B 04 91 89 45 D0 8B 4D D0 83 79 04 00 76 2E 8B 55 EC 52 8B 45 D0 50 8B 4D 08 51 8B 4D F4 E8 ?? ?? ?? ?? 8B 55 08 2B D0 89 55 08 8B 45 D0 83 78 04 00 75 09 8B 4D EC 83 E9 01 89 4D EC EB A1 83 7D 08 00 77 92 83 7D EC 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 75 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_108_0 {
	meta:
		name = "?DoCoreMigration@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 2025
		refs = "000e ?PopulateDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0016 ?PreProcessDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0066 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00ac ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00b9 ??_C@_1KM@BPOANDP@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AAC@ 00be ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ca ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d1 __CrtDbgReportW 01aa ??_C@_1BBE@JFHOFJMB@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAb?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe@ 0201 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0214 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 021d ??_C@_1PG@MNCFLOGK@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw@ 0256 ??_C@_1FE@GIHDJHFF@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AAC@ 03b1 ?IncreaseFullyLoadedSchedulerAllocations@ResourceManager@details@Concurrency@@AAEXXZ 0446 ??_C@_1CA@MOPJBJCN@?$AAc?$AAo?$AAr?$AAe?$AAs?$AAN?$AAe?$AAe?$AAd?$AAe?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 048d ?AdjustDynamicAllocation@ResourceManager@details@Concurrency@@AAEIIII@Z 049c ?PrepareReceiversForCoreTransfer@ResourceManager@details@Concurrency@@AAEII@Z 04e3 ??_C@_1FA@KPODGDCB@?$AAu?$AAn?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAu?$AAn?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo@ 0561 ??_C@_1EI@MICAENCG@?$AAc?$AAo?$AAr?$AAe?$AAs?$AAD?$AAi?$AAs?$AAt?$AAr?$AAi?$AAb?$AAu?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAT?$AAr?$AAa?$AAn?$AAs@ 05a6 ?DistributeExclusiveCores@ResourceManager@details@Concurrency@@AAEXIIIII@Z 05c9 ??_C@_1GC@NKEPNJKP@?$AAe?$AAx?$AAc?$AAl?$AAu?$AAs?$AAi?$AAv?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5@ 0614 ??_C@_1DE@MCBBGCGA@?$AAu?$AAn?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0648 ??_C@_1DA@IOFJOFLC@?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0679 ?ValidateDRMSchedulerState@ResourceManager@details@Concurrency@@AAEXXZ 06b2 ?DistributeIdleCores@ResourceManager@details@Concurrency@@AAEXII@Z 06ca ??_C@_1KC@DAAHIJA@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAI?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc@ 0720 ?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 076e ??_C@_1IO@HEOAKEMN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@ 07a9 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 07b2 ??_C@_1JO@PDFBBMCL@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 55 8B EC 83 EC 74 56 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 B4 00 00 00 00 C7 45 C4 00 00 00 00 EB 09 8B 45 C4 83 C0 01 89 45 C4 8B 4D F8 8B 55 C4 3B 51 08 0F 83 38 02 00 00 8B 45 F8 8B 48 54 8B 55 C4 8B 04 91 89 45 FC 8B 4D FC 8B 49 10 E8 ?? ?? ?? ?? 8B 55 FC 3B 42 24 0F 86 D6 01 00 00 8B 45 F8 8B 48 58 8B 55 B4 8B 45 FC 89 04 91 8B 4D B4 83 C1 01 89 4D B4 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 03 45 E8 89 45 E8 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 39 41 18 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9E 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C3 33 C9 75 BF 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 8B 55 FC 39 42 18 73 0B 8B 45 FC 8B 48 18 89 4D A4 EB 14 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 89 45 A4 8B 55 FC 8B 45 A4 89 42 28 8B 4D FC 8B 49 10 E8 ?? ?? ?? ?? 8B F0 8B 55 FC 2B 72 18 8B 45 FC 8B 48 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 8B 55 FC 2B 42 28 3B F0 73 16 8B 45 FC 8B 48 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 18 89 45 A0 EB 1A 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 8B 55 FC 2B 42 28 89 45 A0 8B 45 FC 8B 4D A0 89 48 2C 8B 55 FC 8B 72 28 8B 45 FC 03 70 2C 8B 4D FC 8B 49 10 E8 ?? ?? ?? ?? 3B F0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A5 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 BB 33 C9 75 B7 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 2B 41 24 8B 55 FC 2B 42 28 8B 4D FC 2B 41 2C 8B 55 FC 89 42 30 8B 45 FC 8B 48 10 E8 ?? ?? ?? ?? 8B F0 8B 4D FC 2B 71 30 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A9 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B4 33 D2 75 B0 EB 37 8B 45 FC 83 78 18 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AD 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 E9 B0 FD FF FF C7 45 F0 00 00 00 00 8B 4D F8 C7 41 20 00 00 00 00 C7 45 C0 00 00 00 00 EB 09 8B 55 C0 83 C2 01 89 55 C0 8B 45 F8 8B 4D C0 3B 48 18 0F 83 A6 00 00 00 8B 55 C0 6B D2 28 8B 45 F8 03 50 48 89 55 DC C7 45 BC 00 00 00 00 EB 09 8B 4D BC 83 C1 01 89 4D BC 8B 55 DC 8B 45 BC 3B 42 04 73 75 8B 4D BC 6B C9 24 8B 55 DC 03 4A 20 89 4D D4 8B 45 D4 83 78 10 00 75 23 8B 4D D4 C7 01 02 00 00 00 8B 55 DC 8B 42 08 83 C0 01 8B 4D DC 89 41 08 8B 55 F0 83 C2 01 89 55 F0 EB 35 8B 45 D4 8B 4D D4 8B 50 10 3B 51 1C 75 27 8B 45 D4 C7 00 06 00 00 00 8B 4D DC 8B 51 1C 83 C2 01 8B 45 DC 89 50 1C 8B 4D F8 8B 51 20 83 C2 01 8B 45 F8 89 50 20 E9 77 FF FF FF E9 42 FF FF FF 8B 4D E8 03 4D F0 89 4D E0 8B 55 F8 C7 42 24 00 00 00 00 EB 0F 8B 45 F8 8B 48 24 83 C1 01 8B 55 F8 89 4A 24 83 7D E0 00 77 0D 8B 45 F8 83 78 20 00 0F 86 85 03 00 00 8B 4D F8 83 79 24 02 0F 83 78 03 00 00 8B 55 F8 83 7A 24 01 75 08 8B 4D F8 E8 ?? ?? ?? ?? C7 45 E4 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 B8 00 00 00 00 EB 09 8B 45 B8 83 C0 01 89 45 B8 8B 4D F8 8B 55 B8 3B 51 08 73 55 8B 45 F8 8B 48 54 8B 55 B8 8B 04 91 89 45 D0 8B 4D D0 8B 49 10 E8 ?? ?? ?? ?? 8B 55 D0 3B 42 24 73 31 8B 45 F8 8B 48 5C 8B 55 E4 8B 45 D0 89 04 91 8B 4D E4 83 C1 01 89 4D E4 8B 55 D0 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D D0 8B 51 24 2B D0 03 55 F4 89 55 F4 EB 97 83 7D E4 00 0F 86 D8 02 00 00 83 7D F4 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EF 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 83 7D E0 00 0F 86 79 01 00 00 8B 45 E4 50 8B 4D F4 51 8B 55 E0 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 EC 8B 45 E4 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 90 C7 45 CC 00 00 00 00 C7 45 B0 00 00 00 00 C7 45 D8 00 00 00 00 8B 4D F0 3B 4D EC 73 08 8B 55 F0 89 55 9C EB 06 8B 45 EC 89 45 9C 8B 4D 9C 89 4D CC 8B 55 CC 89 55 D8 8B 45 F0 3B 45 CC 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CE 33 C0 75 CA 8B 4D F0 2B 4D CC 89 4D F0 8B 55 D8 3B 55 EC 73 37 8B 45 EC 2B 45 D8 89 45 98 8B 4D 98 3B 4D E8 73 08 8B 55 98 89 55 94 EB 06 8B 45 E8 89 45 94 8B 4D 94 89 4D B0 8B 55 D8 03 55 B0 89 55 D8 8B 45 E8 2B 45 B0 89 45 E8 8B 4D D8 3B 4D EC 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 13 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA 8B 55 B4 52 8B 45 90 50 8B 4D B0 51 8B 55 CC 52 8B 45 EC 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D E0 2B 4D EC 89 4D E0 8B 55 F4 2B 55 EC 89 55 F4 83 7D E0 00 72 06 83 7D F4 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 19 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 83 7D F4 00 0F 86 17 01 00 00 8B 45 F8 83 78 20 00 0F 86 0A 01 00 00 83 7D F0 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 22 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 83 7D E8 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 23 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D E4 51 8B 55 F4 52 8B 45 F8 8B 48 20 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 C8 8B 55 E4 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 8C 8B 45 8C 50 8B 4D C8 51 8B 4D F8 E8 ?? ?? ?? ?? 8B 55 F8 8B 42 20 3B 45 C8 72 08 8B 4D F4 3B 4D C8 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 31 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C3 33 C9 75 BF 8B 4D F8 E8 ?? ?? ?? ?? 8B 55 F8 8B 42 20 2B 45 C8 8B 4D F8 89 41 20 8B 55 F4 2B 55 C8 89 55 F4 E9 59 FC FF FF 8B 4D F8 E8 ?? ?? ?? ?? C7 45 AC 00 00 00 00 EB 09 8B 45 AC 83 C0 01 89 45 AC 8B 4D F8 8B 55 AC 3B 51 08 0F 83 9F 00 00 00 8B 45 F8 8B 48 54 8B 55 AC 8B 04 91 8B 48 10 89 4D A8 8B 4D A8 E8 ?? ?? ?? ?? 8B F0 8B 4D A8 E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 42 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC 8B 4D A8 E8 ?? ?? ?? ?? 8B F0 8B 4D A8 E8 ?? ?? ?? ?? 3B F0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 43 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC E9 49 FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_109_0 {
	meta:
		name = "?DoHillClimbing@SchedulerProxy@details@Concurrency@@QAEIIIII@Z"
		size = 40
		refs = "001e ?Update@HillClimbing@details@Concurrency@@QAEIIIII@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8B 4D FC 8B 49 38 E8 ?? ?? ?? ?? 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_110_0 {
	meta:
		name = "?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z"
		size = 521
		refs = "001f ??_C@_1CK@CNKENBPM@?$AAn?$AAu?$AAm?$AAC?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAA?$AAs?$AAs?$AAi?$AAg?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0024 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0030 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0037 __CrtDbgReportW 0073 ??_C@_1PC@OOGLEOOK@?$AA?$CI?$AA?$CB?$AAf?$AAI?$AAd?$AAl?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa@ 0131 ??_C@_1DM@EGEMCFDO@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAi?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0179 ??_C@_1EG@IHHNJAJH@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN@ 01b3 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 01c4 ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z 01db ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F0 8B 45 0C 6B C0 28 8B 4D F0 03 41 48 89 45 FC 83 7D 10 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7E 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 0F B6 55 14 85 D2 75 0B 8B 45 FC 8B 48 08 3B 4D 10 73 39 0F B6 55 14 85 D2 74 0B 8B 45 FC 8B 48 1C 3B 4D 10 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 80 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 B0 33 C9 75 AC C7 45 F4 00 00 00 00 EB 09 8B 55 F4 83 C2 01 89 55 F4 8B 45 FC 8B 4D F4 3B 48 04 0F 83 19 01 00 00 8B 55 F4 6B D2 24 8B 45 FC 03 50 20 89 55 F8 8B 4D F8 83 39 02 75 08 0F B6 55 14 85 D2 74 18 8B 45 F8 83 38 06 0F 85 E9 00 00 00 0F B6 4D 14 85 C9 0F 84 DD 00 00 00 8B 55 F8 8B 42 10 83 C0 01 8B 4D F8 89 41 10 8B 55 F8 C7 02 00 00 00 00 0F B6 45 14 85 C0 74 48 8B 4D FC 8B 51 1C 83 EA 01 8B 45 FC 89 50 1C 8B 4D FC 83 79 1C 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9C 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 EB 46 8B 55 FC 8B 42 08 83 E8 01 8B 4D FC 89 41 08 8B 55 FC 83 7A 08 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A1 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 0F B6 45 14 50 8B 4D F4 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 0C 6B D2 34 03 C2 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 10 83 E8 01 89 45 10 75 02 EB 2E E9 CF FE FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AC 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 CC 33 C0 75 DB 33 C9 75 D7 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_111_0 {
	meta:
		name = "?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z"
		size = 1327
		refs = "0017 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0034 ?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 003e ??_C@_1KG@PDOJHDDH@?$AAn?$AAu?$AAm?$AAC?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAM?$AAi?$AAg?$AAr?$AAa?$AAt?$AAe?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg@ 0043 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004f ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0056 __CrtDbgReportW 007a ??_C@_1IK@BHMBLJIA@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5@ 00b6 ??_C@_1HO@KKIPJNAM@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAD?$AAR?$AAM?$AAI?$AAd?$AAl?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAp?$AAG?$AAi@ 0155 ?GetNumBorrowedCores@SchedulerNode@details@Concurrency@@QAEIXZ 0161 ??_C@_1LI@LECPKFNC@?$AAr?$AAe?$AAm?$AAa?$AAi?$AAn?$AAi?$AAn?$AAg?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAG@ 01e5 ??_C@_1BCK@EGEDDCD@?$AAn?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAI?$AAn?$AAU?$AAs?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA?$CI?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm@ 0224 ??_C@_1KO@HPBJBMIL@?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AA?5?$AA?$CL?$AA?5?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAn?$AAU@ 0295 ?IsFixed@SchedulerCore@details@Concurrency@@QAE_NXZ 02a8 ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 02b7 ?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ 0382 ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 03b3 ??_C@_1GG@KPNOBCFK@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAb?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe@ 03fb ??_C@_1GI@BHHDFFHF@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAb?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAn?$AAU?$AAs@ 0443 ??_C@_1FI@CAKHOJID@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAo?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo@ 048b ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 04ad ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z 04cb ??_C@_1IO@CFBEPIHE@?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AA?5?$AA?$CL?$AA?5?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAn?$AAU@ 0500 ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 44 56 89 4D D8 8B 45 08 8B 48 10 89 4D C8 8B 4D C8 E8 ?? ?? ?? ?? 89 45 C4 8B 55 10 6B D2 34 03 55 C4 89 55 F8 83 7D 14 00 76 0D 8B 4D F8 E8 ?? ?? ?? ?? 3B 45 14 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B8 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C3 33 D2 75 BF 8B 45 F8 8B 4D F8 8B 50 20 3B 51 2C 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BB 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 F8 8B 4D F8 8B 50 28 3B 51 2C 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BC 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 F8 8B 4D 14 3B 48 2C 73 08 8B 55 14 89 55 D4 EB 09 8B 45 F8 8B 48 2C 89 4D D4 8B 55 D4 89 55 F0 8B 45 14 2B 45 F0 8B 4D F8 8B 55 F8 8B 49 20 2B 4A 2C 3B C1 73 0B 8B 55 14 2B 55 F0 89 55 D0 EB 0F 8B 45 F8 8B 4D F8 8B 50 20 2B 51 2C 89 55 D0 8B 45 D0 89 45 E8 8B 4D 14 2B 4D F0 2B 4D E8 89 4D DC 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 2B F0 39 75 DC 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C3 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 BD 33 C9 75 B9 8B 55 F8 8B 45 F8 8B 4A 28 2B 48 2C 39 4D DC 73 08 8B 55 DC 89 55 CC EB 0F 8B 45 F8 8B 4D F8 8B 50 28 2B 51 2C 89 55 CC 8B 45 CC 89 45 E4 8B 4D DC 2B 4D E4 89 4D E0 8B 55 F8 8B 45 F8 8B 4A 1C 2B 48 20 8B 55 F8 8B 45 F8 8B 52 28 2B 50 2C 2B CA 39 4D E0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C8 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B7 33 D2 75 B3 8B 45 F0 03 45 E8 03 45 E4 03 45 E0 3B 45 14 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C9 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C5 33 C0 75 C1 C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 8B 55 F8 8B 45 EC 3B 42 04 0F 83 8D 02 00 00 C6 45 FF 00 8B 4D EC 6B C9 34 8B 55 F8 03 4A 30 89 4D F4 8B 45 F4 83 38 04 0F 85 69 02 00 00 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 0F 85 56 02 00 00 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 39 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 15 83 7D F0 00 76 0F 8B 4D F0 83 E9 01 89 4D F0 C6 45 FF 01 EB 13 83 7D E8 00 76 0D 8B 55 E8 83 EA 01 89 55 E8 C6 45 FF 01 EB 37 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 15 83 7D E4 00 76 0F 8B 4D E4 83 E9 01 89 4D E4 C6 45 FF 01 EB 13 83 7D E0 00 76 0D 8B 55 E0 83 EA 01 89 55 E0 C6 45 FF 01 0F B6 45 FF 85 C0 0F 84 CB 01 00 00 8B 4D 10 6B C9 28 8B 55 D8 03 4A 48 89 4D BC 8B 45 10 6B C0 28 8B 4D D8 8B 51 48 8B 4D EC 6B C9 24 03 4C 02 20 89 4D C0 8B 4D F4 E8 ?? ?? ?? ?? 88 45 FE 0F B6 55 FE 85 D2 74 1C 8B 45 08 50 8B 4D C0 51 8B 55 BC 52 8B 45 F4 50 8B 4D F8 51 8B 4D D8 E8 ?? ?? ?? ?? C6 45 FD 00 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 84 9C 00 00 00 C6 45 FD 01 0F B6 45 FE 85 C0 74 48 8B 4D 08 83 79 28 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 07 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 55 08 8B 42 28 83 E8 01 8B 4D 08 89 41 28 EB 46 8B 55 08 83 7A 2C 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0C 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 08 8B 48 2C 83 E9 01 8B 55 08 89 4A 2C EB 46 8B 45 08 83 78 30 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 12 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 08 8B 51 30 83 EA 01 8B 45 08 89 50 30 8B 4D EC 51 8B 55 F8 52 8B 4D C8 E8 ?? ?? ?? ?? 0F B6 45 FD 50 8B 4D EC 51 8B 4D 0C E8 ?? ?? ?? ?? 8B 55 10 6B D2 34 03 C2 50 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 14 83 E8 01 89 45 14 75 3E 8B 4D F0 03 4D E8 03 4D E4 03 4D E0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1F 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C8 33 C9 75 C4 EB 2E E9 5B FD FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 25 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 CC 33 C9 75 DB 33 D2 75 D7 5E 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_112_0 {
	meta:
		name = "?DynamicRMThreadProc@ResourceManager@details@Concurrency@@CGKPAX@Z"
		size = 36
		refs = "000e ?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0015 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_113_0 {
	meta:
		name = "?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 579
		refs = "0006 __ehhandler$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0015 ___security_cookie 0038 __imp__GetTickCount@0 0065 __imp__WaitForSingleObject@8 0077 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 00a6 ??_C@_1CK@CDOGMKIO@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 00ab ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00b7 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00be __CrtDbgReportW 00d7 ?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ 0104 ?DoCoreMigration@ResourceManager@details@Concurrency@@AAEXXZ 010c ?SchedulersNeedNotifications@ResourceManager@details@Concurrency@@QAE_NXZ 011d ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0158 ??_C@_1CI@MLKCALNG@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA1?$AA?$AA@ 0192 ?DiscardExistingSchedulerStatistics@ResourceManager@details@Concurrency@@AAEXXZ 01f3 ??_C@_1DO@HGFEAHNL@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAE?$AAx?$AAi?$AAt?$AA?$AA@ 022b ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 C7 45 D0 64 00 00 00 C7 45 EC 64 00 00 00 FF 15 ?? ?? ?? ?? 2D F4 01 00 00 89 45 E8 C7 45 DC 00 00 00 00 8B 45 F0 83 78 28 02 0F 84 DC 01 00 00 8B 4D EC 51 8B 55 F0 8B 42 50 50 FF 15 ?? ?? ?? ?? 89 45 D8 8B 4D F0 83 C1 2C 51 8D 4D D4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 55 F0 8B 42 28 89 45 E0 83 7D E0 00 74 0B 83 7D E0 01 74 60 E9 4D 01 00 00 8B 4D F0 83 79 08 01 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F6 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 C7 45 EC FF FF FF FF EB 07 C7 45 EC 64 00 00 00 E9 29 01 00 00 81 7D D8 02 01 00 00 75 36 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0A 6A 00 8B 4D F0 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E8 C7 45 EC 64 00 00 00 E9 B1 00 00 00 FF 15 ?? ?? ?? ?? 89 45 DC 8B 4D DC 2B 4D E8 89 4D E4 83 7D E4 64 76 75 8B 55 F0 83 7A 08 01 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1E 13 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 81 7D E4 82 00 00 00 76 0A 8B 4D F0 E8 ?? ?? ?? ?? EB 19 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0A 6A 00 8B 4D F0 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E8 C7 45 EC 64 00 00 00 EB 24 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 6A 00 8B 4D F0 E8 ?? ?? ?? ?? BA 64 00 00 00 2B 55 E4 89 55 EC EB 37 8B 45 F0 83 78 28 02 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3C 13 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 C7 45 FC FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? E9 17 FE FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_115_0 {
	meta:
		name = "__ehhandler$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_218_3 {
	meta:
		name = "__ehhandler$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_223_3 {
	meta:
		name = "__ehhandler$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_45_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_25_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_100_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_33_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_130_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_133_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_33_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_45_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_45_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_53_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_176_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_179_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_56_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_148_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_151_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_70_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_127_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_157_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_48_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_76_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_160_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_136_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_139_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_169_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_36_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_172_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_209_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_54_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_151_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_215_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_57_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_184_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_187_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_54_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_163_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_193_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_82_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_230_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_233_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_22_0 {
	meta:
		name = "__ehhandler$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_145_0 {
	meta:
		name = "__ehhandler$?FindSegment@ScheduleGroupBase@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?FindSegment@ScheduleGroupBase@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_237_0 {
	meta:
		name = "__ehhandler$?Shutdown@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Shutdown@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_151_0 {
	meta:
		name = "__ehhandler$?_Initialize@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Initialize@_StructuredTaskCollection@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_126_3 {
	meta:
		name = "__ehhandler$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_102_3 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_101_3 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_101_3 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_62_1 {
	meta:
		name = "__ehhandler$?_Pop@_Micro_queue@details@Concurrency@@QAE_NPAXIAAV_Concurrent_queue_base_v4@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Pop@_Micro_queue@details@Concurrency@@QAE_NPAXIAAV_Concurrent_queue_base_v4@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_500_30_0 {
	meta:
		name = "__ehhandler$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1132_2 {
	meta:
		name = "__ehhandler$?consume_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?consume_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1148_3 {
	meta:
		name = "__ehhandler$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_934_7_0 {
	meta:
		name = "__ehhandler$?getSystemCP@@YAHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?getSystemCP@@YAHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1386_3 {
	meta:
		name = "__ehhandler$?unlink_sources@?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_sources@?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_116_0 {
	meta:
		name = "?Empty@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ"
		size = 41
		altNames = "?IsEmpty@TaskStack@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 04 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_117_0 {
	meta:
		name = "?FindBestFitExclusiveAllocation@ResourceManager@details@Concurrency@@AAEIAAI0PAUDynamicAllocationData@23@II@Z"
		size = 3214
		refs = "0014 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0022 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 00b6 ??_C@_1NC@BNCAKIEO@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 00bb ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00c7 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ce __CrtDbgReportW 0128 ??_C@_1CM@KGAFDPJA@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0216 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0284 ??_C@_1CBK@PIJMBABI@?$AA?$CI?$AAm?$AA_?$AAp?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AAg?$AAi?$AAv?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAP?$AAr?$AAo?$AAx@ 02e2 ?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 02f2 ?GetNumBorrowedIdleCores@SchedulerNode@details@Concurrency@@QAEIXZ 0330 ?GetNumBorrowedInUseCores@SchedulerNode@details@Concurrency@@QAEIXZ 0368 ?GetNumOwnedMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 03dd ??_C@_1PO@OLDDNKJI@?$AAn?$AAu?$AAm?$AAM?$AAi?$AAg?$AAr?$AAa?$AAt?$AAa?$AAb?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAm?$AA_?$AAp?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg@ 04a6 ??_C@_1CM@CJBDPCJA@?$AAb?$AAe?$AAs?$AAt?$AAF?$AAi?$AAt?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0510 ??_C@_1EM@PHHLFBAM@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 054c ??_C@_1GC@CCDBFECD@?$AAb?$AAe?$AAs?$AAt?$AAF?$AAi?$AAt?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN@ 05ab ??_C@_1DA@IJAAMOKO@?$AAs?$AAa?$AAt?$AAi?$AAs?$AAf?$AAi?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 05fa ??_C@_1EO@GLDKJHAH@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo@ 06ec ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 06fb ??_C@_1EG@CGKJNDAE@?$AAu?$AAn?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAQ?$AAu?$AAo?$AAt?$AAa?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAT?$AAr?$AAa?$AAn?$AAs?$AAf@ 0731 ??_C@_1EO@MPEBEHIO@?$AAs?$AAa?$AAt?$AAi?$AAs?$AAf?$AAi?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAT?$AAr@ 0972 ??_C@_1IK@BHMBLJIA@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5@ 0a67 ??_C@_1CI@DIFHLMPH@?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAT?$AAr?$AAa?$AAn?$AAs?$AAf?$AAe?$AAr?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0ab4 ?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z 0ac3 ??_C@_1EC@FBEFHOPB@?$AAu?$AAs?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAQ?$AAu?$AAo?$AAt?$AAa?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAo?$AAT?$AAr?$AAa?$AAn?$AAs?$AAf?$AAe?$AAr@ 0b48 ??_C@_1DC@LDCMJCBD@?$AAs?$AAa?$AAt?$AAi?$AAs?$AAf?$AAi?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0bc9 ??_C@_1HA@BLDGDKMK@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAt?$AAa?$AAr?$AAt?$AAi?$AAn?$AAg?$AAN@ 0c0e ??_C@_1MC@KPFMAJLG@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAt?$AAa?$AAr?$AAt?$AAi?$AAn?$AAg?$AAN@ 0c4d ??_C@_1BC@KCEIOCCF@?$AAe?$AAx?$AAa?$AAc?$AAt?$AAF?$AAi?$AAt?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC BC 00 00 00 56 89 4D FC 8B 45 10 8B 48 10 E8 ?? ?? ?? ?? 89 45 80 8B 4D 10 8B 49 10 E8 ?? ?? ?? ?? 89 45 D4 83 7D 14 01 75 06 C6 45 EE 00 EB 09 8B 55 10 8A 42 20 88 45 EE 8A 4D EE 88 4D EF C7 85 5C FF FF FF 00 00 00 00 C7 45 BC FF FF FF FF C7 45 E0 00 00 00 00 C7 45 A8 00 00 00 00 8B 55 10 8B 42 2C 89 45 B8 EB 09 8B 4D B8 83 C1 01 89 4D B8 8B 55 FC 8B 45 B8 3B 42 18 0F 83 58 04 00 00 8B 4D B8 8B 55 D4 8B 04 8A 89 45 C0 8B 4D C0 6B C9 34 03 4D 80 89 4D C4 8B 55 C4 83 7A 1C 00 74 34 8B 45 C4 8B 4D C4 8B 50 1C 3B 51 04 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 99 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BF 33 D2 75 BB 8B 45 C4 83 78 1C 00 0F 85 E9 03 00 00 8B 4D 10 8B 55 C4 8B 41 04 3B 42 04 73 0E 8B 4D 10 8B 51 04 89 95 70 FF FF FF EB 0C 8B 45 C4 8B 48 04 89 8D 70 FF FF FF 8B 95 70 FF FF FF 89 55 A4 83 7D A4 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9E 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC C7 85 50 FF FF FF 00 00 00 00 C7 45 DC 00 00 00 00 8B 45 08 83 38 00 76 59 8B 4D C0 6B C9 28 8B 55 FC 8B 42 48 83 7C 08 08 00 76 46 8B 4D C0 6B C9 28 8B 55 FC 8B 42 48 8B 55 08 8B 12 3B 54 08 08 73 0A 8B 45 08 8B 08 89 4D 98 EB 13 8B 55 C0 6B D2 28 8B 45 FC 8B 48 48 8B 54 11 08 89 55 98 8B 45 98 89 85 50 FF FF FF 8B 4D DC 83 C1 01 89 4D DC C7 45 C8 00 00 00 00 8B 55 0C 83 3A 00 0F 86 6D 02 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 3B 4D 18 0F 83 4F 02 00 00 8B 55 0C 8B 45 C8 3B 02 0F 83 41 02 00 00 8B 4D FC 8B 51 58 8B 45 F4 8B 0C 82 8B 49 10 E8 ?? ?? ?? ?? 8B 55 FC 8B 4A 58 8B 55 F4 8B 0C 91 3B 41 24 0F 86 13 02 00 00 8B 55 FC 8B 42 58 8B 4D F4 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F4 8B 14 8A 2B 42 24 8B 4D FC 8B 51 58 8B 4D F4 8B 14 8A 8B 4D FC 8B 49 58 8B 75 F4 8B 0C B1 8B 52 28 03 51 2C 8B 4D FC 8B 49 58 8B 75 F4 8B 0C B1 03 51 30 3B C2 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B5 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 82 33 C9 0F 85 7A FF FF FF 8B 55 FC 8B 42 58 8B 4D F4 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 89 85 4C FF FF FF 8B 45 C0 6B C0 34 03 85 4C FF FF FF 89 45 D8 8B 4D D8 E8 ?? ?? ?? ?? 85 C0 0F 86 54 01 00 00 8B 4D D8 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F4 8B 14 8A 3B 42 28 73 10 8B 4D D8 E8 ?? ?? ?? ?? 89 85 58 FF FF FF EB 15 8B 45 FC 8B 48 58 8B 55 F4 8B 04 91 8B 48 28 89 8D 58 FF FF FF 8B 4D D8 E8 ?? ?? ?? ?? 8B 55 FC 8B 4A 58 8B 55 F4 8B 0C 91 3B 41 2C 73 0D 8B 4D D8 E8 ?? ?? ?? ?? 89 45 90 EB 12 8B 55 FC 8B 42 58 8B 4D F4 8B 14 88 8B 42 2C 89 45 90 8B 4D D8 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F4 8B 14 8A 3B 42 30 73 10 8B 4D D8 E8 ?? ?? ?? ?? 89 85 68 FF FF FF EB 15 8B 45 FC 8B 48 58 8B 55 F4 8B 04 91 8B 48 30 89 8D 68 FF FF FF 8B 95 58 FF FF FF 03 55 90 03 95 68 FF FF FF 89 55 B0 8B 45 FC 8B 48 58 8B 55 F4 8B 04 91 8B 48 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F4 8B 14 8A 2B 42 24 39 45 B0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C5 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 AE 33 D2 75 AA 83 7D B0 00 76 32 8B 45 0C 8B 08 2B 4D C8 3B 4D B0 73 0D 8B 55 0C 8B 02 2B 45 C8 89 45 88 EB 06 8B 4D B0 89 4D 88 8B 55 C8 03 55 88 89 55 C8 8B 45 DC 83 C0 01 89 45 DC E9 9C FD FF FF 8B 8D 50 FF FF FF 03 4D C8 89 4D AC 0F B6 55 EF 85 D2 74 10 8B 45 AC 3B 45 A4 75 08 8B 4D DC 3B 4D A8 77 28 0F B6 55 EF 85 D2 75 66 8B 45 E0 3B 45 A4 73 08 8B 4D AC 3B 4D E0 77 10 8B 55 AC 3B 55 E0 75 4E 8B 45 DC 3B 45 A8 76 46 8B 4D B8 89 4D BC 8B 55 AC 89 55 E0 83 7D E0 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D8 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 8B 45 DC 89 45 A8 E9 90 FB FF FF 83 7D BC FF 0F 84 5C 07 00 00 8B 4D BC 8B 55 D4 8B 04 8A 89 45 E4 8B 4D E4 6B C9 34 03 4D 80 89 8D 60 FF FF FF 8B 95 60 FF FF FF 83 7A 1C 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E4 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 8B 85 60 FF FF FF 8B 4D E0 3B 48 04 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E5 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C8 33 C9 75 C4 8B 55 10 8B 42 04 3B 45 E0 73 0E 8B 4D 10 8B 51 04 89 95 78 FF FF FF EB 09 8B 45 E0 89 85 78 FF FF FF 8B 8D 78 FF FF FF 89 4D F0 83 7D F0 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E8 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 55 F0 89 95 5C FF FF FF 8B 45 10 8B 48 04 2B 4D F0 8B 55 10 89 4A 04 8B 45 10 83 78 04 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EC 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 08 83 39 00 0F 86 41 01 00 00 8B 55 E4 6B D2 28 8B 45 FC 8B 48 48 83 7C 11 08 00 0F 86 2A 01 00 00 8B 55 E4 6B D2 28 8B 45 FC 8B 48 48 8B 45 08 8B 00 3B 44 11 08 73 0D 8B 4D 08 8B 11 89 95 54 FF FF FF EB 16 8B 45 E4 6B C0 28 8B 4D FC 8B 51 48 8B 44 02 08 89 85 54 FF FF FF 8B 8D 54 FF FF FF 3B 4D F0 73 3C 8B 55 E4 6B D2 28 8B 45 FC 8B 48 48 8B 45 08 8B 00 3B 44 11 08 73 0A 8B 4D 08 8B 11 89 55 A0 EB 13 8B 45 E4 6B C0 28 8B 4D FC 8B 51 48 8B 44 02 08 89 45 A0 8B 4D A0 89 4D 9C EB 06 8B 55 F0 89 55 9C 8B 45 9C 89 45 B4 6A 00 8B 4D B4 51 8B 55 E4 52 8B 45 10 8B 48 10 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 8B 02 3B 45 B4 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F3 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CC 33 C0 75 C8 8B 4D F0 3B 4D B4 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F4 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA 8B 55 08 8B 02 2B 45 B4 8B 4D 08 89 01 8B 55 F0 2B 55 B4 89 55 F0 83 7D F0 00 0F 86 F7 03 00 00 8B 45 0C 83 38 00 0F 86 EB 03 00 00 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 83 7D F0 00 0F 86 9B 03 00 00 8B 55 F8 3B 55 18 0F 83 8F 03 00 00 8B 45 0C 83 38 00 0F 86 83 03 00 00 8B 4D FC 8B 51 58 8B 45 F8 8B 0C 82 8B 51 10 89 55 94 8B 4D 94 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F8 8B 14 8A 3B 42 24 0F 86 4F 03 00 00 8B 4D 94 E8 ?? ?? ?? ?? 89 85 48 FF FF FF 8B 45 E4 6B C0 34 03 85 48 FF FF FF 89 45 E8 8B 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 86 22 03 00 00 8B 4D FC 8B 51 58 8B 45 F8 8B 0C 82 8B 49 10 E8 ?? ?? ?? ?? 8B 55 FC 8B 4A 58 8B 55 F8 8B 0C 91 2B 41 24 8B 55 FC 8B 4A 58 8B 55 F8 8B 0C 91 8B 55 FC 8B 52 58 8B 75 F8 8B 14 B2 8B 49 28 03 4A 2C 8B 55 FC 8B 52 58 8B 75 F8 8B 14 B2 03 4A 30 3B C1 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 82 33 D2 0F 85 7A FF FF FF 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F8 8B 14 8A 3B 42 28 73 0D 8B 4D E8 E8 ?? ?? ?? ?? 89 45 8C EB 12 8B 45 FC 8B 48 58 8B 55 F8 8B 04 91 8B 48 28 89 4D 8C 8B 4D E8 E8 ?? ?? ?? ?? 8B 55 FC 8B 4A 58 8B 55 F8 8B 0C 91 3B 41 2C 73 0D 8B 4D E8 E8 ?? ?? ?? ?? 89 45 84 EB 12 8B 55 FC 8B 42 58 8B 4D F8 8B 14 88 8B 42 2C 89 45 84 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F8 8B 14 8A 3B 42 30 73 10 8B 4D E8 E8 ?? ?? ?? ?? 89 85 7C FF FF FF EB 15 8B 45 FC 8B 48 58 8B 55 F8 8B 04 91 8B 48 30 89 8D 7C FF FF FF 8B 55 8C 03 55 84 03 95 7C FF FF FF 89 55 D0 0F 84 D9 01 00 00 8B 45 E8 8B 4D E8 8B 50 20 3B 51 2C 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 19 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 FC 8B 48 58 8B 55 F8 8B 04 91 8B 48 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 58 8B 4D F8 8B 14 8A 2B 42 24 39 45 D0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1A 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 AE 33 D2 75 AA 8B 45 0C 8B 08 3B 4D D0 73 0D 8B 55 0C 8B 02 89 85 74 FF FF FF EB 09 8B 4D D0 89 8D 74 FF FF FF 8B 95 74 FF FF FF 3B 55 F0 73 2E 8B 45 0C 8B 08 3B 4D D0 73 0D 8B 55 0C 8B 02 89 85 6C FF FF FF EB 09 8B 4D D0 89 8D 6C FF FF FF 8B 95 6C FF FF FF 89 95 64 FF FF FF EB 09 8B 45 F0 89 85 64 FF FF FF 8B 8D 64 FF FF FF 89 4D CC 83 7D CC 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1E 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 55 CC 52 8B 45 E4 50 8B 4D 10 8B 51 10 52 8B 45 FC 8B 48 58 8B 55 F8 8B 04 91 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 0C 8B 11 3B 55 CC 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 21 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CC 33 D2 75 C8 8B 45 F0 3B 45 CC 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 22 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CE 33 C0 75 CA 8B 4D 0C 8B 11 2B 55 CC 8B 45 0C 89 10 8B 4D F0 2B 4D CC 89 4D F0 E9 52 FC FF FF 83 7D F0 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2A 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 55 10 8B 42 2C 8B 4D D4 8B 14 81 89 95 44 FF FF FF 8B 45 10 8B 48 2C 8B 55 D4 8B 45 BC 8B 75 D4 8B 04 86 89 04 8A 8B 4D BC 8B 55 D4 8B 85 44 FF FF FF 89 04 8A 8B 4D 10 8B 51 2C 83 C2 01 8B 45 10 89 50 2C 8B 4D 10 8B 55 FC 8B 41 2C 3B 42 18 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 35 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 8B 4D 10 8B 55 FC 8B 41 2C 3B 42 18 72 2F 8B 4D 10 83 79 04 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 36 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 BF 33 C9 75 BB 8B 55 10 C6 42 20 01 EB 3D 0F B6 45 EF 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3C 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CE 33 C0 75 CA 8B 4D 10 C6 41 20 00 8B 85 5C FF FF FF 5E 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_41_118_0 {
	meta:
		name = "?FindBestFitIdleAllocation@ResourceManager@details@Concurrency@@AAEIIPAUDynamicAllocationData@23@I@Z"
		size = 1072
		refs = "0011 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 001f ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 00a9 ??_C@_1NC@BNCAKIEO@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 00ae ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ba ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00c1 __CrtDbgReportW 01c2 ??_C@_1EM@PHHLFBAM@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 01fb ??_C@_1GC@CCDBFECD@?$AAb?$AAe?$AAs?$AAt?$AAF?$AAi?$AAt?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN@ 0251 ??_C@_1CK@DFKMPKMO@?$AAc?$AAo?$AAr?$AAe?$AAs?$AAT?$AAr?$AAa?$AAn?$AAs?$AAf?$AAe?$AAr?$AAr?$AAe?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0294 ??_C@_1HE@LOFIGJDJ@?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAN?$AAo?$AAd?$AAe?$AAs?$AA?$FL?$AAn?$AAo?$AAd?$AAe?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?$FN?$AA?4?$AAm?$AA_?$AAi?$AAd?$AAl?$AAe@ 02d6 ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 02f3 ??_C@_1EO@GLDKJHAH@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo@ 036e ??_C@_1HA@BLDGDKMK@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAt?$AAa?$AAr?$AAt?$AAi?$AAn?$AAg?$AAN@ 03b3 ??_C@_1MC@KPFMAJLG@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAt?$AAa?$AAr?$AAt?$AAi?$AAn?$AAg?$AAN@ 03f2 ??_C@_1BC@KCEIOCCF@?$AAe?$AAx?$AAa?$AAc?$AAt?$AAF?$AAi?$AAt?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 48 56 89 4D F8 8B 45 0C 8B 48 10 E8 ?? ?? ?? ?? 89 45 C8 8B 4D 0C 8B 49 10 E8 ?? ?? ?? ?? 89 45 F0 83 7D 10 01 75 06 C6 45 FE 00 EB 09 8B 55 0C 8A 42 20 88 45 FE 8A 4D FE 88 4D FF C7 45 EC 00 00 00 00 C7 45 E0 FF FF FF FF C7 45 E4 00 00 00 00 8B 55 0C 8B 42 2C 89 45 E8 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 F8 8B 45 E8 3B 42 18 0F 83 1D 01 00 00 8B 4D E8 8B 55 F0 8B 04 8A 89 45 DC 8B 4D DC 6B C9 34 03 4D C8 89 4D F4 8B 55 F4 83 7A 1C 00 74 34 8B 45 F4 8B 4D F4 8B 50 1C 3B 51 04 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C0 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BF 33 D2 75 BB 8B 45 F4 83 78 1C 00 0F 85 AE 00 00 00 8B 4D 0C 8B 55 F4 8B 41 04 3B 42 04 73 0B 8B 4D 0C 8B 51 04 89 55 D0 EB 09 8B 45 F4 8B 48 04 89 4D D0 8B 55 D0 89 55 BC C7 45 D8 00 00 00 00 8B 45 DC 6B C0 28 8B 4D F8 8B 51 48 83 7C 02 1C 00 76 36 8B 45 DC 6B C0 28 8B 4D F8 8B 51 48 8B 4D 08 3B 4C 02 1C 73 08 8B 55 08 89 55 CC EB 13 8B 45 DC 6B C0 28 8B 4D F8 8B 51 48 8B 44 02 1C 89 45 CC 8B 4D CC 89 4D D8 0F B6 55 FF 85 D2 74 08 8B 45 D8 3B 45 BC 74 10 0F B6 4D FF 85 C9 75 1E 8B 55 D8 3B 55 E4 76 16 8B 45 E8 89 45 E0 8B 4D D8 89 4D E4 0F B6 55 FF 85 D2 74 02 EB 05 E9 CB FE FF FF 83 7D E0 FF 0F 84 49 02 00 00 8B 45 E0 8B 4D F0 8B 14 81 89 55 D4 8B 45 D4 6B C0 34 03 45 C8 89 45 C4 8B 4D C4 83 79 1C 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E5 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 55 C4 8B 45 E4 3B 42 04 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E6 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 8B 4D 0C 8B 51 04 3B 55 E4 73 0B 8B 45 0C 8B 48 04 89 4D C0 EB 06 8B 55 E4 89 55 C0 8B 45 C0 89 45 EC 83 7D EC 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E9 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 8B 4D D4 6B C9 28 8B 55 F8 8B 42 48 8B 4C 08 1C 3B 4D EC 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EB 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C1 33 C9 75 BD 6A 01 8B 55 EC 52 8B 45 D4 50 8B 4D 0C 8B 51 10 52 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 0C 8B 48 04 2B 4D EC 8B 55 0C 89 4A 04 8B 45 0C 83 78 04 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F0 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 0C 8B 51 2C 8B 45 F0 8B 0C 90 89 4D B8 8B 55 0C 8B 42 2C 8B 4D F0 8B 55 E0 8B 75 F0 8B 14 96 89 14 81 8B 45 E0 8B 4D F0 8B 55 B8 89 14 81 8B 45 0C 8B 48 2C 83 C1 01 8B 55 0C 89 4A 2C 8B 45 0C 8B 4D F8 8B 50 2C 3B 51 18 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 FA 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 0C 8B 4D F8 8B 50 2C 3B 51 18 72 2F 8B 45 0C 83 78 04 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 FB 10 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BF 33 C0 75 BB 8B 4D 0C C6 41 20 01 EB 3D 0F B6 55 FF 85 D2 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 01 11 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA 8B 45 0C C6 40 20 00 8B 45 EC 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_119_0 {
	meta:
		name = "?FindCoreForPartiallyFilledNode@ResourceManager@details@Concurrency@@AAE_NAAI0PAUDynamicAllocationData@23@I@Z"
		size = 734
		refs = "0014 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0022 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 0033 ??_C@_1EM@CIOEBKBI@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo@ 0038 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0044 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004b __CrtDbgReportW 006f ??_C@_1LE@PDIPMFDC@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAP?$AAa?$AAr?$AAt?$AAi?$AAa@ 00cf ??_C@_1MO@NGHNCBAP@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 012e ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 0190 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 01c4 ?GetNumBorrowedIdleCores@SchedulerNode@details@Concurrency@@QAEIXZ 01d0 ?GetNumBorrowedInUseCores@SchedulerNode@details@Concurrency@@QAEIXZ 01ee ?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 022b ??_C@_1NA@EPBHPNED@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd?$AAl?$AAe?$AAC@ 027a ?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 28 89 4D F4 C6 45 FF 00 8B 45 10 8B 48 10 E8 ?? ?? ?? ?? 89 45 DC 8B 4D 10 8B 49 10 E8 ?? ?? ?? ?? 89 45 E0 8B 55 10 83 7A 04 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3A 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 10 8B 4D 10 8B 50 28 3B 51 2C 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3B 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 10 8B 48 2C 8B 55 E0 8B 04 8A 89 45 F0 8B 4D F0 6B C9 34 03 4D DC 89 4D EC 8B 55 EC 83 7A 1C 00 76 0E 8B 45 EC 8B 4D EC 8B 50 1C 3B 51 04 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 41 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BF 33 D2 75 BB 8B 45 08 83 38 00 76 40 8B 4D F0 6B C9 28 8B 55 F4 8B 42 48 83 7C 08 08 00 76 2D C6 45 FF 01 6A 00 6A 01 8B 4D F0 51 8B 55 10 8B 42 10 50 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D 08 8B 11 83 EA 01 8B 45 08 89 10 E9 4C 01 00 00 8B 4D 0C 83 39 00 0F 86 40 01 00 00 C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 14 0F 83 22 01 00 00 0F B6 4D FF 85 C9 0F 85 16 01 00 00 8B 55 F4 8B 42 58 8B 4D F8 8B 14 88 8B 42 10 89 45 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 8B 51 58 8B 4D F8 8B 14 8A 3B 42 24 0F 86 E2 00 00 00 8B 4D E4 E8 ?? ?? ?? ?? 89 45 D8 8B 45 F0 6B C0 34 03 45 D8 89 45 E8 8B 4D E8 E8 ?? ?? ?? ?? 85 C0 77 40 8B 4D E8 E8 ?? ?? ?? ?? 85 C0 76 12 8B 4D F4 8B 51 58 8B 45 F8 8B 0C 82 83 79 2C 00 77 22 8B 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 86 91 00 00 00 8B 55 F4 8B 42 58 8B 4D F8 8B 14 88 83 7A 30 00 76 7F 8B 4D E8 E8 ?? ?? ?? ?? 85 C0 74 38 8B 45 F4 8B 48 58 8B 55 F8 8B 04 91 83 78 28 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 59 0F 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 B8 33 C0 75 B4 C6 45 FF 01 6A 01 8B 4D F0 51 8B 55 10 8B 42 10 50 8B 4D F4 8B 51 58 8B 45 F8 8B 0C 82 51 8B 4D F4 E8 ?? ?? ?? ?? 8B 55 0C 8B 02 83 E8 01 8B 4D 0C 89 01 E9 C9 FE FF FF 0F B6 55 FF 85 D2 74 2E 8B 45 EC 8B 4D EC 8B 50 1C 3B 51 04 75 0F 8B 45 10 8B 48 2C 83 C1 01 8B 55 10 89 4A 2C 8B 45 10 8B 48 04 83 E9 01 8B 55 10 89 4A 04 EB 0F 8B 45 10 8B 48 2C 83 C1 01 8B 55 10 89 4A 2C 8A 45 FF 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_120_0 {
	meta:
		name = "?FindGroupAffinity@AffinityRestriction@ResourceManager@details@Concurrency@@QAEPAUHardwareAffinity@34@G@Z"
		size = 97
		refs = "0039 ?GetGroup@HardwareAffinity@details@Concurrency@@QAEGXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 33 C0 66 89 45 FC EB 0C 66 8B 4D FC 66 83 C1 01 66 89 4D FC 0F B7 55 FC 8B 45 F8 0F B7 08 3B D1 7D 2E 0F B7 4D FC 6B C9 0C 8B 55 F8 03 4A 04 E8 ?? ?? ?? ?? 0F B7 C0 0F B7 4D 08 3B C1 75 0F 0F B7 45 FC 6B C0 0C 8B 55 F8 03 42 04 EB 04 EB B8 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_121_0 {
	meta:
		name = "?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ"
		size = 46
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 04 00 74 0E 8B 4D FC 8B 51 04 8B 42 18 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_122_0 {
	meta:
		name = "?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ"
		size = 17
		altNames = "?Count@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHXZ ?GetNumSchedulersForNotifications@ResourceManager@details@Concurrency@@QAEIXZ ?GetProxy@UMSSchedulingContext@details@Concurrency@@UAEPAUIThreadProxy@3@XZ ?GetUMSContext@UMSThreadProxy@details@Concurrency@@QBEPAXXZ ?GetVirtualProcessorRoot@ThreadProxy@details@Concurrency@@QAEPAVVirtualProcessorRoot@23@XZ ?GetWaitBlock@MultiWaitBlockHolder@details@Concurrency@@QBEPAVMultiWaitBlock@23@XZ ?_GetToken@_CancellationTokenRegistration@details@Concurrency@@QAEPAV_CancellationTokenState@23@XZ ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ ?size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEIXZ ?size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEIXZ ?state@?$fpos@H@std@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_123_0 {
	meta:
		name = "?GetAvailableNodeCount@ResourceManager@details@Concurrency@@UBEIXZ"
		size = 17
		altNames = "?GetPriority@ThreadProxy@details@Concurrency@@QAEHXZ ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ ?LastDataPointCount@MeasuredHistory@HillClimbing@details@Concurrency@@QAEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_124_0 {
	meta:
		name = "?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 118
		refs = "0006 __ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0013 ___security_cookie 0025 ?s_coreCount@ResourceManager@details@Concurrency@@0IA 002d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 004c ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 005e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 36 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 0A 6A 00 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_142_0 {
	meta:
		name = "?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 118
		refs = "0006 __ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0013 ___security_cookie 0025 ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 002d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 004c ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 005e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 36 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 0A 6A 00 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_126_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_2_3 {
	meta:
		name = "__ehhandler$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_5_3 {
	meta:
		name = "__ehhandler$??$?0AAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@AAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@1@ABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@AAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@1@ABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_33_3 {
	meta:
		name = "__ehhandler$??$?0ABQ6A_NABW4agent_status@Concurrency@@@Z@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@ABQ6A_NABW4agent_status@Concurrency@@@ZABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0ABQ6A_NABW4agent_status@Concurrency@@@Z@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@ABQ6A_NABW4agent_status@Concurrency@@@ZABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_38_1 {
	meta:
		name = "__ehhandler$??$?0U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@$$QAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@1@ABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QAE@$$QAU?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@1@ABV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_4_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_7_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_299_3 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_60_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_206_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_178_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_39_0 {
	meta:
		name = "__ehhandler$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_313_1 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_316_1 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_32_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@ABV?$allocator@D@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@ABV?$allocator@D@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_215_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@ABV?$allocator@G@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@ABV?$allocator@G@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_35_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@ABV?$allocator@_W@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@ABV?$allocator@_W@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_40_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_222_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_39_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_322_2 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_327_3 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_403_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_406_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_410_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@PBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@PBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_414_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@PBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@PBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_33_1 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_33_1 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_62_3 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_355_2 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_67_3 {
	meta:
		name = "__ehhandler$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_293_2 {
	meta:
		name = "__ehhandler$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_44_1 {
	meta:
		name = "__ehhandler$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_113_2 {
	meta:
		name = "__ehhandler$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_299_2 {
	meta:
		name = "__ehhandler$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_336_3 {
	meta:
		name = "__ehhandler$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_127_3 {
	meta:
		name = "__ehhandler$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_47_1 {
	meta:
		name = "__ehhandler$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_82_3 {
	meta:
		name = "__ehhandler$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_360_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_445_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_487_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_451_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_330_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_366_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_369_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_130_3 {
	meta:
		name = "__ehhandler$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_239_1 {
	meta:
		name = "__ehhandler$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_314_2 {
	meta:
		name = "__ehhandler$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_122_2 {
	meta:
		name = "__ehhandler$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_245_1 {
	meta:
		name = "__ehhandler$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_354_3 {
	meta:
		name = "__ehhandler$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_92_1 {
	meta:
		name = "__ehhandler$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_251_1 {
	meta:
		name = "__ehhandler$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_326_2 {
	meta:
		name = "__ehhandler$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_458_2 {
	meta:
		name = "__ehhandler$??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_462_2 {
	meta:
		name = "__ehhandler$??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_76_2 {
	meta:
		name = "__ehhandler$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_367_3 {
	meta:
		name = "__ehhandler$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_370_3 {
	meta:
		name = "__ehhandler$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_88_3 {
	meta:
		name = "__ehhandler$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_267_1 {
	meta:
		name = "__ehhandler$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_342_2 {
	meta:
		name = "__ehhandler$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_67_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_379_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_382_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_390_3 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_394_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_398_1 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_402_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_406_2 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_414_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_420_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_426_3 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_430_3 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_434_3 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_439_2 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_141_3 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_385_3 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_388_3 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_145_3 {
	meta:
		name = "__ehhandler$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_358_2 {
	meta:
		name = "__ehhandler$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_362_2 {
	meta:
		name = "__ehhandler$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_29_0 {
	meta:
		name = "__ehhandler$??0CacheLocalScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0CacheLocalScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_14_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_34_0 {
	meta:
		name = "__ehhandler$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_37_0 {
	meta:
		name = "__ehhandler$??0FairScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FairScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_10_0 {
	meta:
		name = "__ehhandler$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_41_0 {
	meta:
		name = "__ehhandler$??0NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_47_0 {
	meta:
		name = "__ehhandler$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_26_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_13_0 {
	meta:
		name = "__ehhandler$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1168_2_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_746_2_0 {
	meta:
		name = "__ehhandler$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1066_5_0 {
	meta:
		name = "__ehhandler$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_19_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_503_3_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_831_13_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessor@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessor@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_828_4_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_10_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_11_0 {
	meta:
		name = "__ehhandler$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_448_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_457_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_27_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_30_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_109_3 {
	meta:
		name = "__ehhandler$??0facet@locale@std@@IAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0facet@locale@std@@IAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_44_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_45_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_45_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_29_1 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@HABVerror_category@1@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0system_error@std@@QAE@HABVerror_category@1@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_106_2 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0system_error@std@@QAE@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_59_0 {
	meta:
		name = "__ehhandler$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_525_2 {
	meta:
		name = "__ehhandler$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_523_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_526_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_542_1 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_545_1 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_548_2 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_575_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_582_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_585_3 {
	meta:
		name = "__ehhandler$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_604_3 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_612_3 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_618_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_624_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_629_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_634_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_856_24_0 {
	meta:
		name = "__ehhandler$??1ContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_959_21_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_856_28_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_94_0 {
	meta:
		name = "__ehhandler$??1NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_101_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_68_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_116_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_23_0 {
	meta:
		name = "__ehhandler$??1SchedulingNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingNode@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_578_15_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_35_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1066_13_0 {
	meta:
		name = "__ehhandler$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_39_0 {
	meta:
		name = "__ehhandler$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_831_27_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_72_0 {
	meta:
		name = "__ehhandler$??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_36_0 {
	meta:
		name = "__ehhandler$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_27_0 {
	meta:
		name = "__ehhandler$??1_Condition_variable@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Condition_variable@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_409_1 {
	meta:
		name = "__ehhandler$??1_ExceptionHolder@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_655_2 {
	meta:
		name = "__ehhandler$??1agent@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1agent@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_709_3 {
	meta:
		name = "__ehhandler$??R?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QBEXV?$task@X@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QBEXV?$task@X@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_198_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_144_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_248_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_555_1 {
	meta:
		name = "__ehhandler$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_113_0 {
	meta:
		name = "__ehhandler$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_127_0 {
	meta:
		name = "?GetCurrentNodeAndCore@ResourceManager@details@Concurrency@@QAEIPAI@Z"
		size = 520
		refs = "000a ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0018 ?s_pfnGetCurrentProcessorNumberEx@ResourceManager@details@Concurrency@@0P6GXPAU_PROCESSOR_NUMBER@@@ZA 001e ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 00d6 ??_C@_13COJANIEC@?$AA0?$AA?$AA@ 00db ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e7 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ee __CrtDbgReportW 010c ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0114 ??_C@_1GI@ODAPOKOM@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 0143 __imp__GetCurrentProcessorNumber@0"
	strings:
		$1 = { 55 8B EC 83 EC 34 89 4D E8 E8 ?? ?? ?? ?? 83 F8 04 0F 8C F3 00 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 8D 4D E0 51 FF 55 D4 0F B6 55 E2 89 55 DC B8 01 00 00 00 8B 4D DC D3 E0 89 45 D0 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 E8 8B 45 F8 3B 42 18 73 75 8B 4D F8 6B C9 28 8B 55 E8 03 4A 48 89 4D EC 0F B7 45 E0 8B 4D EC 39 41 0C 75 55 8B 55 EC 8B 02 23 45 D0 74 4B C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 EC 8B 45 FC 3B 42 04 73 2E 8B 4D FC 6B C9 24 8B 55 EC 8B 42 20 0F B6 4C 08 08 3B 4D DC 75 16 83 7D 08 00 74 08 8B 55 08 8B 45 FC 89 02 8B 45 F8 E9 34 01 00 00 EB BE E9 77 FF FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 58 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 CC 33 C0 75 DB 33 C9 75 D7 33 C0 E9 FD 00 00 00 E9 F8 00 00 00 83 3D ?? ?? ?? ?? 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 FF 15 ?? ?? ?? ?? 89 45 D8 BA 01 00 00 00 8B 4D D8 D3 E2 89 55 CC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D E8 8B 55 F0 3B 51 18 73 63 8B 45 F0 6B C0 28 8B 4D E8 03 41 48 89 45 E4 8B 55 E4 8B 02 23 45 CC 74 48 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 E4 8B 45 F4 3B 42 04 73 2B 8B 4D F4 6B C9 24 8B 55 E4 8B 42 20 0F B6 4C 08 08 3B 4D D8 75 13 83 7D 08 00 74 08 8B 55 08 8B 45 F4 89 02 8B 45 F0 EB 2F EB C1 EB 89 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 76 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 CC 33 C0 75 DB 33 C9 75 D7 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_128_0 {
	meta:
		name = "?GetDynamicAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUDynamicAllocationData@23@XZ"
		size = 17
		altNames = "?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 40 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_130_0 {
	meta:
		name = "?GetExecutionContextId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 22
		refs = "0004 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_749_294_0 {
	meta:
		name = "?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
		size = 22
		refs = "0004 ?s_workQueueIdCounter@SchedulerBase@details@Concurrency@@0JC"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_41_161_0 {
	meta:
		name = "?GetSchedulerId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 22
		refs = "0004 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_191_18_0 {
	meta:
		name = "?GetThreadProxyId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 22
		refs = "0004 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_715_23_0 {
	meta:
		name = "?ReferenceStaticOneShot@SchedulerBase@details@Concurrency@@SAJXZ"
		size = 22
		refs = "0004 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_23_628_1 {
	meta:
		name = "?_GetNextAsyncId@details@Concurrency@@YAIXZ"
		size = 22
		refs = "0004 _s_asyncId"
	strings:
		$1 = { 55 8B EC B8 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_41_131_0 {
	meta:
		name = "?GetExecutionResourceCount@TopologyObject@GlobalNode@details@Concurrency@@UBEIXZ"
		size = 20
		altNames = "?GetId@TopologyObject@GlobalCore@details@Concurrency@@UBEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 41 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_132_0 {
	meta:
		name = "?GetFirstExecutionResource@TopologyObject@GlobalNode@details@Concurrency@@UBEPAUITopologyExecutionResource@4@XZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 51 20 8B 42 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_133_0 {
	meta:
		name = "?GetFirstNode@ResourceManager@details@Concurrency@@UBEPAUITopologyNode@3@XZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 48 8B 41 24 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_134_0 {
	meta:
		name = "?GetGroup@HardwareAffinity@details@Concurrency@@QAEGXZ"
		size = 18
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 66 8B 40 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_136_0 {
	meta:
		name = "?GetId@TopologyObject@GlobalNode@details@Concurrency@@UBEIXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 41 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_137_0 {
	meta:
		name = "?GetMask@HardwareAffinity@details@Concurrency@@QAEKXZ"
		size = 16
		altNames = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEABGXZ ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAB_WXZ ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ ?BeaconCount@CancellationBeaconStack@ContextBase@details@Concurrency@@QBEJXZ ?Current@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QBEPAVSafePointInvocation@23@XZ ?GetEvent@UMSBackgroundPoller@details@Concurrency@@QAEPAXXZ ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ ?GetType@WorkItem@details@Concurrency@@QBE?AW4WorkItemType@123@XZ ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QBEPAU_ExceptionHolder@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ ?_Getptr@_Timevec@std@@QBEPAXXZ ?value@error_code@std@@QBEHXZ ?value@error_condition@std@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_138_0 {
	meta:
		name = "?GetNext@TopologyObject@GlobalCore@details@Concurrency@@UBEPAUITopologyExecutionResource@4@XZ"
		size = 64
		refs = "001a ?GetNextGlobalCore@GlobalNode@details@Concurrency@@QAEPAUGlobalCore@23@PBU423@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 04 51 8B 55 FC 8B 42 04 8B 48 0C E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 0B 8B 4D F8 8B 51 20 89 55 F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_139_0 {
	meta:
		name = "?GetNext@TopologyObject@GlobalNode@details@Concurrency@@UBEPAUITopologyNode@4@XZ"
		size = 64
		refs = "001a ?GetNextGlobalNode@ResourceManager@details@Concurrency@@QAEPAUGlobalNode@23@PBU423@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 04 51 8B 55 FC 8B 42 04 8B 48 18 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 0B 8B 4D F8 8B 51 24 89 55 F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_140_0 {
	meta:
		name = "?GetNextGlobalCore@GlobalNode@details@Concurrency@@QAEPAUGlobalCore@23@PBU423@@Z"
		size = 78
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 4D 08 2B 48 20 8B C1 99 B9 24 00 00 00 F7 F9 83 C0 01 89 45 F8 8B 55 FC 8B 45 F8 3B 42 04 73 11 8B 4D F8 6B C9 24 8B 55 FC 03 4A 20 89 4D F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_141_0 {
	meta:
		name = "?GetNextGlobalNode@ResourceManager@details@Concurrency@@QAEPAUGlobalNode@23@PBU423@@Z"
		size = 78
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 4D 08 2B 48 48 8B C1 99 B9 28 00 00 00 F7 F9 83 C0 01 89 45 F8 8B 55 FC 8B 45 F8 3B 42 18 73 11 8B 4D F8 6B C9 28 8B 55 FC 03 4A 48 89 4D F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_145_0 {
	meta:
		name = "?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 20
		altNames = "?GetContext@UMSFreeThreadProxy@details@Concurrency@@UAEPAUIExecutionContext@3@XZ ?UNSAFE_CurrentVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 A0 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_146_0 {
	meta:
		name = "?GetNumBorrowedCores@SchedulerNode@details@Concurrency@@QAEIXZ"
		size = 17
		altNames = "?GetVirtualProcessorRoot@UMSThreadProxy@details@Concurrency@@QAEPAVUMSFreeVirtualProcessorRoot@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_147_0 {
	meta:
		name = "?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 A8 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_148_0 {
	meta:
		name = "?GetNumBorrowedIdleCores@SchedulerNode@details@Concurrency@@QAEIXZ"
		size = 17
		altNames = "?GetExecutionResourceId@ExecutionResource@details@Concurrency@@UBEIXZ ?GetNumaNodeNumber@SchedulingNode@details@Concurrency@@QBEKXZ ?GetPriority@UMSThreadProxy@details@Concurrency@@QAEHXZ ?GetThreadId@ThreadProxy@details@Concurrency@@QBEKXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 2C 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_149_0 {
	meta:
		name = "?GetNumBorrowedInUseCores@SchedulerNode@details@Concurrency@@QAEIXZ"
		size = 83
		refs = "0016 ??_C@_1FG@EDMMACO@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAu?$AAm?$AAD?$AAR?$AAM?$AAB?$AAo@ 001b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0027 ??_C@_1GI@MGKJCJEA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D FC 8B 50 20 3B 51 2C 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E8 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 FC 8B 4D FC 8B 40 20 2B 41 2C 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_150_0 {
	meta:
		name = "?GetNumExternalThreads@SchedulerProxy@details@Concurrency@@QAEIXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 B4 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_151_0 {
	meta:
		name = "?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D FC 8B 40 1C 2B 41 24 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_152_0 {
	meta:
		name = "?GetNumNestedThreadSubscriptions@SchedulerProxy@details@Concurrency@@QAEIXZ"
		size = 25
		refs = "0011 ?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 81 C1 C4 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_153_0 {
	meta:
		name = "?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 29
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D FC 8B 80 A0 00 00 00 2B 81 A8 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_154_0 {
	meta:
		name = "?GetNumOwnedMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ"
		size = 29
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D FC 8B 40 1C 2B 41 20 8B 55 FC 2B 42 24 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_155_0 {
	meta:
		name = "?GetNumaNode@TopologyObject@GlobalNode@details@Concurrency@@UBEKXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 41 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_159_0 {
	meta:
		name = "?GetQueueLength@SchedulerProxy@details@Concurrency@@QAEIXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 78 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_162_0 {
	meta:
		name = "?GetSchedulerProxy@ExecutionResource@details@Concurrency@@QAEPAVSchedulerProxy@23@XZ"
		size = 17
		altNames = "?ControlSetting@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHXZ ?GetNumberOfVirtualProcessors@SchedulerBase@details@Concurrency@@UBEIXZ ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ ?GetStackSize@ThreadProxy@details@Concurrency@@QAEIXZ ?GetThreadHandle@UMSThreadProxy@details@Concurrency@@QAEPAXXZ ?do_date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?do_date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?do_date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?flags@ios_base@std@@QBEHXZ ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ ?size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEIXZ ?size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_165_0 {
	meta:
		name = "?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z"
		size = 609
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0010 ??_C@_1HI@JBAGEKLL@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 0015 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0021 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0028 __CrtDbgReportW 004b ??_C@_0CB@HOJBBPPI@GetLogicalProcessorInformationEx@ 0050 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0056 __imp__GetModuleHandleW@4 005d __imp__GetProcAddress@8 006c __imp__GetLastError@0 0072 _HRESULT_FROM_WIN32 007e ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0083 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 008c __CxxThrowException@8 0091 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 00d9 ??_C@_1FA@CNCNODFP@?$AAs?$AA_?$AAl?$AAo?$AAg?$AAi?$AAc?$AAa?$AAl?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AAI?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AAL?$AAe?$AAn@ 010d _malloc 0115 ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 0126 ??0bad_alloc@std@@QAE@XZ 012b __TI2?AVbad_alloc@std@@ 0183 __imp__GetLogicalProcessorInformation@8"
	strings:
		$1 = { 55 8B EC 83 EC 6C 83 3D ?? ?? ?? ?? 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5F 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 83 3D ?? ?? ?? ?? 04 0F 8C 30 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D D4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 8B 4D 08 51 FF 55 FC FF 15 ?? ?? ?? ?? 83 F8 7A 74 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D C4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 C4 52 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7E 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 16 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 8B 45 08 50 FF 55 FC 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D B4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D B4 51 E8 ?? ?? ?? ?? E9 E3 00 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 7A 74 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D A4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 A4 52 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9A 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 16 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E4 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D 94 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 94 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_166_0 {
	meta:
		name = "?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
		size = 727
		refs = "000d ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0016 ??_C@_1FG@ODLOKAHM@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC@ 001b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0027 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0047 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0097 ??_C@_1IO@DBJALCEG@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 0104 ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 0117 ?IsFixed@SchedulerCore@details@Concurrency@@QAE_NXZ 0123 ??_C@_1DG@CPKOBDLE@?$AA?$CB?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAI?$AAs?$AAF?$AAi?$AAx?$AAe?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 0183 ?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ 0198 ??_C@_1MO@LBDAMGHH@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAi?$AAd?$AAl?$AAe?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 01d5 ??_C@_1DK@DAAKMLJG@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAI?$AAs?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 020e ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 02b3 ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 02c3 ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 89 4D E8 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E3 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E0 C7 45 EC 00 00 00 00 EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D E8 8B 55 EC 3B 51 18 0F 83 62 02 00 00 8B 45 EC 6B C0 34 03 45 E0 89 45 FC 8B 4D FC 83 79 20 00 0F 86 44 02 00 00 8B 55 FC 8B 45 FC 8B 4A 1C 3B 48 20 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EB 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C8 33 C9 75 C4 C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 FC 8B 4D F0 3B 48 04 0F 83 E7 01 00 00 8B 55 F0 6B D2 34 8B 45 FC 03 50 30 89 55 F8 8B 4D F8 83 39 04 0F 85 C7 01 00 00 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 84 B4 01 00 00 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F1 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C7 33 C0 75 C3 8B 4D EC 6B C9 28 8B 55 E8 8B 42 48 8B 55 F0 6B D2 24 03 54 08 20 89 55 F4 8B 45 F4 83 78 10 01 0F 85 CE 00 00 00 8B 4D F4 83 79 1C 00 74 3E 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 8B 45 F4 83 78 1C 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 01 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 B5 33 C0 75 B1 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 02 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C7 33 C9 75 C3 8B 55 F0 52 8B 45 FC 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 1E 8B 55 FC 8B 42 2C 83 E8 01 8B 4D FC 89 41 2C 8B 55 0C 8B 42 18 83 E8 01 8B 4D 0C 89 41 18 E9 83 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 F4 8B 4D F4 8B 50 10 2B 51 1C 3B 55 E4 76 53 8B 45 F4 8B 48 10 83 E9 01 8B 55 F4 89 4A 10 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 25 8B 4D 0C 51 8B 55 F4 52 8B 45 EC 6B C0 28 8B 4D E8 03 41 48 50 8B 55 F8 52 8B 45 FC 50 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D F0 51 8B 55 FC 52 8B 4D 08 E8 ?? ?? ?? ?? E9 01 FE FF FF E9 86 FD FF FF 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_167_0 {
	meta:
		name = "?HandleSharedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUDynamicAllocationData@23@@Z"
		size = 826
		refs = "000f ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0022 ??_C@_1PI@JCBPDLOA@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAI?$AAd@ 0027 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0033 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003a __CrtDbgReportW 0069 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0073 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00b7 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00f9 ?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 0114 ??_C@_1IO@DBJALCEG@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 018b ?IsFixed@SchedulerCore@details@Concurrency@@QAE_NXZ 019e ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 01d0 ??_C@_1DI@JHPFMDMI@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAu?$AAs?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0219 ?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ 0245 ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 0255 ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 027d ??_C@_1KE@DIHCMNFN@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAu?$AAg?$AAg?$AAe?$AAs?$AAt?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo@ 02c1 ??_C@_1IO@HEOAKEMN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@"
	strings:
		$1 = { 55 8B EC 83 EC 24 56 57 89 4D E8 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 0C 2B 41 24 8B 55 0C 39 42 18 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2D 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC 8B 4D 08 E8 ?? ?? ?? ?? 8B F0 8B 45 0C 2B 70 24 8B 4D 0C 2B 71 18 8B 4D 08 E8 ?? ?? ?? ?? 8B F8 8B 4D 08 E8 ?? ?? ?? ?? 2B F8 3B F7 73 19 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 0C 2B 42 24 8B 4D 0C 2B 41 18 89 45 E0 EB 17 8B 4D 08 E8 ?? ?? ?? ?? 8B F0 8B 4D 08 E8 ?? ?? ?? ?? 2B F0 89 75 E0 8B 55 E0 89 55 E4 8B 4D 08 E8 ?? ?? ?? ?? 89 45 DC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D E4 00 0F 86 92 01 00 00 8B 4D E8 8B 55 F8 3B 51 18 0F 83 83 01 00 00 8B 45 F8 6B C0 34 03 45 DC 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 0F 86 62 01 00 00 8B 4D FC 8B 55 FC 8B 41 1C 3B 42 20 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 37 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 83 7D E4 00 0F 86 0A 01 00 00 8B 55 FC 8B 45 F4 3B 42 04 0F 83 FB 00 00 00 8B 4D F4 6B C9 34 8B 55 FC 03 4A 30 89 4D EC 8B 45 EC 83 38 04 0F 85 DB 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 0F 85 C8 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 85 B5 00 00 00 8B 45 F8 6B C0 28 8B 4D E8 8B 51 48 8B 4D F4 6B C9 24 03 4C 02 20 89 4D F0 8B 55 F0 83 7A 10 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3F 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 F0 83 78 10 01 76 5C 8B 4D F0 8B 51 10 83 EA 01 8B 45 F0 89 50 10 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 25 8B 55 0C 52 8B 45 F0 50 8B 4D F8 6B C9 28 8B 55 E8 03 4A 48 51 8B 45 EC 50 8B 4D FC 51 8B 4D E8 E8 ?? ?? ?? ?? 8B 55 F4 52 8B 45 FC 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D E4 83 E9 01 89 4D E4 E9 E3 FE FF FF E9 5B FE FF FF 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 0C 39 42 24 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5B 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C6 33 D2 75 C2 8B 4D 08 E8 ?? ?? ?? ?? 8B F0 8B 4D 08 E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5C 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 0C 2B 41 24 8B 55 0C 39 42 18 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5D 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC 5F 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_168_0 {
	meta:
		name = "?IncreaseFullyLoadedSchedulerAllocations@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 231
		refs = "0056 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0063 ??_C@_1JO@IPBKEALO@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAu?$AAg?$AAg?$AAe?$AAs?$AAt?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt@ 0068 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0074 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 007b __CrtDbgReportW 009a ??_C@_1EE@CBBHKLBL@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAI?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 00cb ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00d4 ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F0 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F0 8B 55 F8 3B 51 08 0F 83 B9 00 00 00 8B 45 F0 8B 48 54 8B 55 F8 8B 04 91 89 45 FC 8B 4D FC 0F B6 51 21 83 FA 01 0F 85 95 00 00 00 8B 45 FC 8B 48 10 89 4D F4 8B 4D F4 E8 ?? ?? ?? ?? 8B 55 FC 39 42 24 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C0 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C6 33 D2 75 C2 8B 45 FC 83 78 14 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C1 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D F4 E8 ?? ?? ?? ?? 50 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D FC 89 41 24 E9 2F FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_169_0 {
	meta:
		name = "?Increment@Count@CollectionTypes@details@Concurrency@@QAEXXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 C1 01 8B 55 FC 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_170_0 {
	meta:
		name = "?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
		size = 184
		refs = "0006 __ehhandler$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z 0015 ___security_cookie 0039 ??_C@_0DE@MLPFJGPA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0047 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0066 ??0TopologyObject@GlobalCore@details@Concurrency@@QAE@PAU123@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 33 C0 88 45 F3 8D 4D F3 89 4D E0 68 EE 00 00 00 68 ?? ?? ?? ?? 8B 55 E0 0F B6 02 50 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 11 8B 4D EC 51 8B 4D E8 E8 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 DC C7 45 FC FF FF FF FF 8B 45 EC 8B 4D DC 89 48 20 8B 55 EC 8B 45 08 89 42 0C 8B 4D EC 8B 55 0C 89 51 04 8B 45 EC 8A 4D 10 88 48 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_171_0 {
	meta:
		name = "__unwindfunclet$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z$0"
		size = 30
		refs = "0006 ??_C@_0DE@MLPFJGPA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 EE 00 00 00 68 ?? ?? ?? ?? 8B 45 E0 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_173_0 {
	meta:
		name = "?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z"
		size = 636
		refs = "0006 __ehhandler$?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z 0015 ___security_cookie 0039 ??_C@_0DE@MLPFJGPA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0047 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0066 ??0TopologyObject@GlobalNode@details@Concurrency@@QAE@PAU123@@Z 00bc ?NumberOfBitsSet@details@Concurrency@@YAGK@Z 011f ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0166 _memset 019c ??_C@_1DE@HOCBGJGH@?$AAi?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAU?$AAL?$AAO?$AAN?$AAG?$AA_?$AAP?$AAT?$AAR?$AA?$CJ?$AA?5?$AA?$CK?$AA?5?$AA8?$AA?$AA@ 01a1 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 01ad ??_C@_1GI@MGKJCJEA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 01b4 __CrtDbgReportW 0213 ?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 34 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 33 C0 88 45 F3 8D 4D F3 89 4D CC 68 0E 02 00 00 68 ?? ?? ?? ?? 8B 55 CC 0F B6 02 50 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC C7 45 FC 00 00 00 00 83 7D DC 00 74 11 8B 4D EC 51 8B 4D DC E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 55 D8 89 55 C8 C7 45 FC FF FF FF FF 8B 45 EC 8B 4D C8 89 48 24 8B 55 EC 8B 45 08 89 42 18 0F B7 4D 0C 8B 55 EC 89 4A 10 0F B7 45 10 8B 4D EC 89 41 0C 8B 55 EC 8B 45 14 89 02 83 7D 18 00 75 17 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 D0 8B 45 EC 89 50 04 EB 09 8B 4D EC 8B 55 18 89 51 04 8B 45 EC C7 40 08 00 00 00 00 8B 4D EC 8B 51 04 89 55 D4 33 C0 88 45 F2 68 1C 02 00 00 68 ?? ?? ?? ?? 0F B6 4D F2 51 33 C9 8B 45 D4 BA 24 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 33 C0 83 C1 04 0F 92 C0 F7 D8 0B C1 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 13 8B 4D E0 8B 55 D4 89 11 8B 45 E0 83 C0 04 89 45 D0 EB 07 C7 45 D0 00 00 00 00 8B 4D EC 8B 55 D0 89 51 20 8B 45 EC 8B 48 04 6B C9 24 51 6A 00 8B 55 EC 8B 42 20 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 EC 8B 45 E8 3B 42 04 0F 83 D6 00 00 00 83 7D E4 20 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 21 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 83 7D 18 00 75 0C 8B 4D 14 83 E1 01 0F 84 83 00 00 00 83 7D 18 00 75 38 8B 55 E8 6B D2 24 8B 45 EC 03 50 20 89 55 C4 8B 4D E8 83 C1 01 89 4D E8 0F B6 55 E4 52 8B 45 EC 8B 48 0C C1 E1 08 03 4D E4 51 8B 55 EC 52 8B 4D C4 E8 ?? ?? ?? ?? EB 45 8B 45 E8 6B C0 24 8B 4D EC 03 41 20 89 45 C0 8B 55 E8 83 C2 01 89 55 E8 0F B6 45 1C 0F B6 4D E4 03 C8 51 0F B7 55 0C C1 E2 08 8B 45 EC 8B 48 0C C1 E1 10 03 4D E4 03 D1 52 8B 55 EC 52 8B 4D C0 E8 ?? ?? ?? ?? 8B 45 14 D1 E8 89 45 14 E9 12 FF FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_41_174_0 {
	meta:
		name = "__unwindfunclet$?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z$0"
		size = 30
		refs = "0006 ??_C@_0DE@MLPFJGPA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 0E 02 00 00 68 ?? ?? ?? ?? 8B 45 CC 0F B6 00 50 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_176_0 {
	meta:
		name = "?Initialize@GlobalNumaNode@details@Concurrency@@QAEXKGK@Z"
		size = 40
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 08 0F B7 55 0C 8B 45 FC 89 50 04 8B 4D FC 8B 55 10 89 11 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_177_0 {
	meta:
		name = "?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 526
		refs = "0047 ??_V@YAXPAX@Z 0083 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00a4 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00ce ??_C@_1DE@INOIAEFP@?$AAm?$AA_?$AAp?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 00d3 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00df ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00e6 __CrtDbgReportW 018d _memset"
	strings:
		$1 = { 55 8B EC 83 EC 20 89 4D F8 8B 45 F8 8B 4D F8 8B 50 0C 3B 51 08 0F 83 5E 01 00 00 8B 45 F8 8B 4D F8 8B 50 0C 3B 51 08 73 10 8B 45 F8 8B 48 0C D1 E1 8B 55 F8 89 4A 0C EB E2 8B 45 F8 8B 48 54 89 4D F4 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 48 58 89 4D F0 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 48 5C 89 4D EC 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 88 45 FF 68 C0 0B 00 00 68 ?? ?? ?? ?? 0F B6 4D FF 51 33 C9 8B 55 F8 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 8B 45 F8 8B 4D E8 89 48 54 8B 55 F8 83 7A 58 00 0F 84 B5 00 00 00 8B 45 F8 83 78 5C 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C3 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 33 C9 88 4D FE 68 C4 0B 00 00 68 ?? ?? ?? ?? 0F B6 55 FE 52 33 C9 8B 55 F8 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 8B 45 F8 8B 4D E4 89 48 58 33 D2 88 55 FD 68 C5 0B 00 00 68 ?? ?? ?? ?? 0F B6 45 FD 50 33 C9 8B 55 F8 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 8B 45 F8 8B 4D E0 89 48 5C 8B 55 F8 8B 42 08 C1 E0 02 50 6A 00 8B 4D F8 8B 51 54 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 83 78 58 00 74 6D 8B 4D F8 83 79 5C 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 CC 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 55 F8 8B 42 08 C1 E0 02 50 6A 00 8B 4D F8 8B 51 58 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B 48 08 C1 E1 02 51 6A 00 8B 55 F8 8B 42 5C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_178_0 {
	meta:
		name = "?InitializeSetThreadGroupAffinityFn@HardwareAffinity@details@Concurrency@@SAXXZ"
		size = 144
		refs = "0007 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 000d __imp__GetModuleHandleW@4 0015 ??_C@_0BH@CJPDKMEB@SetThreadGroupAffinity?$AA@ 001f __imp__GetProcAddress@8 0027 ??_C@_0BH@CINNILJO@GetThreadGroupAffinity?$AA@ 0046 __imp__GetLastError@0 004c _HRESULT_FROM_WIN32 0058 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 005d __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0066 __CxxThrowException@8 006f ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0077 ?s_pfnSetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@1@ZA 0088 ?s_pfnGetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@@ZA"
	strings:
		$1 = { 55 8B EC 83 EC 1C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 8B 4D FC 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F8 00 74 06 83 7D F4 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 E4 52 E8 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_179_0 {
	meta:
		name = "?InitializeSystemFunctionPointers@ResourceManager@details@Concurrency@@CAXXZ"
		size = 111
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0010 ?InitializeSetThreadGroupAffinityFn@HardwareAffinity@details@Concurrency@@SAXXZ 0015 ??_C@_0BM@JLHMEGJA@GetCurrentProcessorNumberEx?$AA@ 001a ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0020 __imp__GetModuleHandleW@4 0027 __imp__GetProcAddress@8 0036 __imp__GetLastError@0 003c _HRESULT_FROM_WIN32 0048 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 004d __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0056 __CxxThrowException@8 005f ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0067 ?s_pfnGetCurrentProcessorNumberEx@ResourceManager@details@Concurrency@@0P6GXPAU_PROCESSOR_NUMBER@@@ZA"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 04 7C 5C E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D EC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_180_0 {
	meta:
		name = "?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z"
		size = 1186
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0010 ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 001e ??_C@_1HI@JBAGEKLL@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 0023 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002f ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0036 __CrtDbgReportW 004d ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 0055 ??_C@_1CA@INACGGDB@?$AAs?$AA_?$AAp?$AAS?$AAy?$AAs?$AAI?$AAn?$AAf?$AAo?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0084 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 008c ?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 00a3 ?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z 00d3 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 0101 ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z 0120 ?NumberOfBitsSet@details@Concurrency@@YAGK@Z 019b ??_C@_1FA@CNCNODFP@?$AAs?$AA_?$AAl?$AAo?$AAg?$AAi?$AAc?$AAa?$AAl?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AAI?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AAL?$AAe?$AAn@ 01d5 ??_C@_1FO@HNIMBPMI@?$AAp?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AAP?$AAa?$AAc?$AAk?$AAa?$AAg?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAu?$AAm@ 021f ?s_countProcessorPackages@ResourceManager@details@Concurrency@@0_NA 0241 ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 0249 ?s_coreCount@ResourceManager@details@Concurrency@@0IA 0252 ?s_numaNodeCount@ResourceManager@details@Concurrency@@0IA 025f ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ 0272 ??_C@_1GI@ODAPOKOM@?$AAs?$AA_?$AAv?$AAe?$AAr?$AAs?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?3?$AA?3?$AAC?$AAo?$AAn?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAc?$AAy?$AA?3?$AA?3?$AAI?$AAR?$AAe?$AAs@ 02e9 ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAK@Z 0428 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0441 ??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z 0471 ??_C@_1FC@FCELAFMJ@?$AAs?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM@"
	strings:
		$1 = { 55 8B EC 83 EC 50 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BF 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 83 3D ?? ?? ?? ?? 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C0 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 04 0F 8C CB 01 00 00 68 FF FF 00 00 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? 89 45 FC C7 45 DC 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 4D DC 3B 0D ?? ?? ?? ?? 0F 83 B4 00 00 00 8B 55 FC 83 3A 03 75 60 C7 45 E4 00 00 00 00 8B 45 E4 6B C0 0C 8B 4D FC 8D 54 01 20 89 55 E0 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E0 83 39 00 74 20 8B 55 EC 83 C2 01 89 55 EC 8B 45 E0 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 D0 03 55 D8 89 55 D8 8B 45 E4 83 C0 01 89 45 E4 8B 4D FC 0F B7 51 1E 39 55 E4 7C A7 8B 45 FC 83 38 01 75 27 8B 4D FC 83 C1 20 89 4D B8 8B 55 B8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 83 78 20 00 74 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 FC 8B 45 DC 03 42 04 89 45 DC 8B 4D FC 8B 55 FC 03 51 04 89 55 FC E9 3D FF FF FF 83 3D ?? ?? ?? ?? 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 03 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 83 7D EC 00 76 06 83 7D F4 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 8B 45 EC 3B 45 F4 76 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8A 4D CC 88 0D ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 85 D2 74 08 8B 45 EC 89 45 C8 EB 06 8B 4D F4 89 4D C8 8B 55 C8 89 15 ?? ?? ?? ?? 8B 45 D8 A3 ?? ?? ?? ?? 8B 4D F4 89 0D ?? ?? ?? ?? 0F B6 55 08 85 D2 75 05 E8 ?? ?? ?? ?? E9 BF 01 00 00 83 3D ?? ?? ?? ?? 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 14 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 68 FF FF 00 00 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? 89 45 F8 C7 45 D4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 F0 00 00 00 00 8B 4D D4 3B 0D ?? ?? ?? ?? 73 7A 8B 55 F8 83 7A 04 03 75 34 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 83 39 00 74 20 8B 55 E8 83 C2 01 89 55 E8 8B 45 F8 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 D0 03 55 D0 89 55 D0 8B 45 F8 83 78 04 01 75 1D 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 83 3A 00 74 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D D4 83 C1 18 89 4D D4 8B 55 F8 83 C2 18 89 55 F8 E9 7B FF FF FF 83 3D ?? ?? ?? ?? 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 83 7D E8 00 76 06 83 7D F0 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3D 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 8B 45 E8 3B 45 F0 76 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8A 4D C4 88 0D ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 85 D2 74 08 8B 45 E8 89 45 C0 EB 06 8B 4D F0 89 4D C0 8B 55 C0 89 15 ?? ?? ?? ?? 8B 45 D0 A3 ?? ?? ?? ?? 8B 4D F0 89 0D ?? ?? ?? ?? 0F B6 55 08 85 D2 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 B4 8B 4D B4 89 4D BC 83 7D BC 00 74 0F 6A 01 8B 4D BC E8 ?? ?? ?? ?? 89 45 B0 EB 07 C7 45 B0 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 76 0C 81 3D ?? ?? ?? ?? FF FF 00 00 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 4E 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C1 33 C9 75 BD 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_181_0 {
	meta:
		name = "?IntersectWith@HardwareAffinity@details@Concurrency@@QAEXK@Z"
		size = 26
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 23 4D 08 8B 55 FC 89 0A 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_182_0 {
	meta:
		name = "?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 31 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_183_0 {
	meta:
		name = "?IsFixed@SchedulerCore@details@Concurrency@@QAE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 28 00 76 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_184_0 {
	meta:
		name = "?IsHillClimbingEnabled@SchedulerProxy@details@Concurrency@@QAE_NXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 80 CC 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_185_0 {
	meta:
		name = "?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 30 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_186_0 {
	meta:
		name = "?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 96
		refs = "000d ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 002c ??_C@_1DI@JMMGCOBE@?$AAm?$AAi?$AAn?$AAi?$AAm?$AAu?$AAm?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0031 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003d ??_C@_1HA@HKMLDPPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 03 81 B8 00 00 00 89 45 F8 8B 55 FC 8B 45 F8 3B 82 BC 00 00 00 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_187_0 {
	meta:
		name = "?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 137
		refs = "001e ??_C@_1FI@GLLDDAEC@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAF?$AAi?$AAx?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAu?$AAm?$AAE?$AAx?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl@ 0023 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002f ??_C@_1HA@HKMLDPPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0036 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 4D FC 8B 90 AC 00 00 00 3B 91 B8 00 00 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C2 33 D2 75 BE 8B 45 FC 8B 4D FC 8B 90 AC 00 00 00 2B 91 B8 00 00 00 89 55 F8 8B 45 FC 8B 4D F8 3B 88 84 00 00 00 76 08 8B 55 F8 89 55 F4 EB 0C 8B 45 FC 8B 88 84 00 00 00 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_188_0 {
	meta:
		name = "?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z"
		size = 47
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 4D 08 3B 48 04 74 0B 8B 55 08 8B 42 18 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_189_0 {
	meta:
		name = "?NumberOfBitsSet@details@Concurrency@@YAGK@Z"
		size = 50
	strings:
		$1 = { 55 8B EC 51 33 C0 66 89 45 FC 83 7D 08 00 74 1A 66 8B 4D FC 66 83 C1 01 66 89 4D FC 8B 55 08 83 EA 01 23 55 08 89 55 08 EB E0 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_190_0 {
	meta:
		name = "?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z"
		size = 1321
		refs = "001a ??_C@_1FI@PMPOHIM@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0032 __CrtDbgReportW 0053 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 005c ??_C@_1HG@CBOKJAMM@?$AAf?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr@ 009a ??_C@_1FM@HJNCEJEH@?$AAf?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAf?$AAS?$AAu?$AAb?$AAs?$AAc?$AAr?$AAi?$AAb?$AAe@ 00d3 ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00dc ??_C@_1II@CMMPLMHA@?$AA?$CB?$AAf?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe@ 0115 ?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ 011e ?SetAllocatedNodes@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z 0160 ?ComputeMinHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ 016b ?ComputeDesiredHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ 018f ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 01aa ??_C@_1HK@IMCFCHLD@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAM?$AAi?$AAn?$AAi?$AAm?$AAu?$AAm?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$CG?$AA?$CG@ 0204 ??_C@_1NO@KNGDEILA@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAM?$AAi?$AAn?$AAi?$AAm?$AAu?$AAm?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0279 ??_C@_1BO@CMIHJKDM@?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 02bb ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 02d1 ??_C@_1CM@FIPFKEHK@?$AAr?$AAe?$AAq?$AAu?$AAe?$AAs?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAm?$AAi?$AAn?$AAR?$AAe?$AAq?$AAu?$AAe?$AAs?$AAt?$AA?$AA@ 031b ?SetupStaticAllocationData@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@_N@Z 0323 ?PreProcessStaticAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0335 ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 036f ?ReleaseCoresOnExistingSchedulers@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 039b ?RedistributeCoresAmongAll@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@III@Z 03df ?ReserveAtHigherUseCounts@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@I@Z 03fd ??_C@_1HE@JGIMKHIM@?$AAr?$AAe?$AAs?$AAe?$AAr?$AAv?$AAe?$AAd?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAm?$AAi?$AAn?$AAR?$AAe?$AAq?$AAu?$AAe?$AAs?$AAt?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAe?$AAs?$AAe?$AAr?$AAv@ 042e ?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0444 ?GrantAllocation@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@I_N0@Z 045b ?CommitStolenCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z 0496 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 04a9 ??_C@_1IO@HEOAKEMN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@ 04ed ??_C@_1JO@PDFBBMCL@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 55 8B EC 83 EC 38 56 89 4D F4 83 7D 08 00 74 09 8B 45 F4 83 78 48 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BD 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C7 33 C0 75 C3 0F B6 4D 0C 85 C9 75 32 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BE 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C2 33 C9 75 BE 0F B6 55 0C 85 D2 75 2E 0F B6 45 10 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BF 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C6 33 C0 75 C2 0F B6 4D 0C 85 C9 74 32 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C0 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C2 33 C9 75 BE 0F B6 55 0C 85 D2 74 11 8B 4D F4 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? C7 45 E4 00 00 00 00 C7 45 DC 00 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E8 C7 45 F8 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 EC 00 00 00 00 0F B6 45 10 85 C0 0F 84 16 01 00 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E4 8B 4D 08 E8 ?? ?? ?? ?? 89 45 DC 0F B6 4D 0C 85 C9 74 11 8B 55 DC 89 55 F0 8B 45 E4 89 45 EC E9 E5 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E0 8B 4D F4 8B 55 E0 3B 51 1C 77 08 8B 45 E0 3B 45 E8 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DD 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C3 33 C0 75 BF 8B 4D F4 8B 55 E0 3B 51 1C 72 47 8B 45 F4 8B 4D DC 3B 48 1C 75 16 8B 55 F4 8B 45 E4 3B 42 1C 75 0B 8B 4D F4 8B 55 E8 3B 51 1C 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DE 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 AA 33 D2 75 A6 8B 45 F4 8B 4D E0 3B 48 1C 73 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 F0 8B 45 E8 3B 45 E4 73 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D EC EB 56 83 7D E8 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EA 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 8B 55 EC 89 55 E4 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 89 45 DC 8B 4D F0 3B 4D EC 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EE 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA C6 45 FF 00 8B 55 F8 3B 55 F0 0F 83 24 01 00 00 0F B6 45 10 50 8B 4D 08 51 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? 6A 00 8B 55 F0 52 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? 89 45 F8 8B 4D F8 3B 4D F0 0F 83 E2 00 00 00 0F B6 55 0C 85 D2 75 0A 83 7D EC 00 0F 86 D0 00 00 00 C6 45 FF 01 6A FE 8B 45 F0 2B 45 F8 50 8B 4D 08 51 8B 4D F4 E8 ?? ?? ?? ?? 03 45 F8 89 45 F8 8B 55 F8 3B 55 F0 73 68 8B 45 E8 03 45 F0 50 8B 4D E4 51 8B 55 E8 03 55 F8 52 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? 03 45 F8 89 45 F8 8B 4D F8 3B 4D EC 73 3C 6A FF 8B 55 EC 2B 55 F8 52 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? 03 45 F8 89 45 F8 8B 4D F8 3B 4D EC 73 19 8B 55 EC 2B 55 F8 52 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? 03 45 F8 89 45 F8 8B 4D F8 3B 4D EC 72 0B 8B 55 F8 03 55 E8 3B 55 E4 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1F 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C3 33 D2 75 BF 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 45 10 50 0F B6 4D 0C 51 8B 55 F8 52 8B 4D 08 E8 ?? ?? ?? ?? 89 45 C8 0F B6 45 FF 85 C0 74 0C 8B 4D 08 51 8B 4D F4 E8 ?? ?? ?? ?? C7 45 D8 00 00 00 00 EB 09 8B 55 D8 83 C2 01 89 55 D8 8B 45 F4 8B 4D D8 3B 48 08 0F 83 9F 00 00 00 8B 55 F4 8B 42 54 8B 4D D8 8B 14 88 8B 42 10 89 45 D4 8B 4D D4 E8 ?? ?? ?? ?? 8B F0 8B 4D D4 E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 38 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C0 33 C0 75 BC 8B 4D D4 E8 ?? ?? ?? ?? 8B F0 8B 4D D4 E8 ?? ?? ?? ?? 3B F0 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 39 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C0 33 C0 75 BC E9 49 FF FF FF 8B 45 C8 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_191_0 {
	meta:
		name = "?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
		size = 272
		refs = "0026 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00ff ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 89 4D EC 8B 45 10 8B 4D 08 89 08 8B 55 10 D9 EE DD 5A 08 8B 45 10 8B 4D 0C 89 48 10 8B 4D 0C E8 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 0F 84 D3 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 EC 8B 4D F8 3B 48 18 0F 83 B2 00 00 00 8B 55 F8 6B D2 34 03 55 E8 89 55 FC 8B 45 FC C7 40 28 00 00 00 00 8B 4D FC C7 41 2C 00 00 00 00 8B 55 FC 83 7A 1C 00 0F 86 80 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D FC 8B 55 F4 3B 51 04 73 63 8B 45 F4 6B C0 34 8B 4D FC 03 41 30 89 45 F0 8B 55 F0 C6 42 30 00 8B 45 F0 83 38 04 75 43 8B 4D F0 83 79 18 00 75 3A 8B 55 F8 6B D2 28 8B 45 EC 03 50 48 89 55 E4 8B 4D F4 6B C9 24 8B 55 E4 03 4A 20 89 4D E0 8B 45 10 50 8B 4D E0 51 8B 55 E4 52 8B 45 F0 50 8B 4D FC 51 8B 4D EC E8 ?? ?? ?? ?? EB 89 E9 36 FF FF FF 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_192_0 {
	meta:
		name = "?PopulateDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 755
		refs = "001c ?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ 0027 ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 003b ?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z 0050 ?GetDynamicAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUDynamicAllocationData@23@XZ 0060 _memset 0077 ?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z 007f ?IsHillClimbingEnabled@SchedulerProxy@details@Concurrency@@QAE_NXZ 00a0 ?GetQueueLength@SchedulerProxy@details@Concurrency@@QAEIXZ 00ab ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00b6 ?Scheduler@SchedulerProxy@details@Concurrency@@QBEPAUIScheduler@3@XZ 00ea ?DoHillClimbing@SchedulerProxy@details@Concurrency@@QAEIIIII@Z 010f ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z 0121 ?SetQueueLength@SchedulerProxy@details@Concurrency@@QAEXI@Z 0129 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0139 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0146 ??_C@_1BCK@LKOGMEAJ@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAs?$AAu?$AAg?$AAg?$AAe?$AAs?$AAt?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt@ 014b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0157 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 015e __CrtDbgReportW 01e9 ??_C@_1FK@IJFFIJNC@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd@ 0220 ??_C@_1EE@CBBHKLBL@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAI?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 0251 ?GetNumNestedThreadSubscriptions@SchedulerProxy@details@Concurrency@@QAEIXZ 02c1 ??_C@_1DC@POCEEKIJ@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C 56 89 4D F4 C7 45 F0 00 00 00 00 C7 45 FC 00 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D F4 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC EB 12 8B 45 FC 50 8B 4D F4 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 69 02 00 00 8B 4D FC E8 ?? ?? ?? ?? 89 45 F8 6A 38 6A 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 52 8B 45 FC 50 8B 4D F0 51 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 84 E7 00 00 00 C7 45 E0 00 00 00 00 C7 45 E4 00 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 89 45 EC 8B 4D FC E8 ?? ?? ?? ?? 89 45 D4 8B 4D FC E8 ?? ?? ?? ?? 89 45 E8 8D 45 EC 50 8D 4D E4 51 8D 55 E0 52 8B 45 E8 8B 10 8B 4D E8 8B 42 04 FF D0 8B 4D EC 51 8B 55 E4 52 8B 45 E0 50 8B 4D D4 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 89 42 24 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 39 41 24 76 15 8B 55 F8 8B 42 24 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 89 41 24 8B 55 EC 52 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 39 41 24 72 10 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 39 42 24 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9C 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B6 33 D2 75 B2 EB 0E 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 89 41 24 8B 4D FC E8 ?? ?? ?? ?? 85 C0 76 4D 8B 55 F8 83 7A 14 00 75 2F 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 3B 41 24 77 1F 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 73 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 F8 8A 45 DC 88 42 21 E9 BC 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B1 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CA 33 C0 75 C6 8B 4D F8 83 79 14 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B2 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 33 C9 75 C9 8B 4D FC E8 ?? ?? ?? ?? 85 C0 76 2F 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 3B 42 24 77 1F 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 45 F8 8A 4D D8 88 48 21 8B 55 F4 8B 42 54 8B 4D F0 8B 55 F8 89 14 88 8B 45 F0 83 C0 01 89 45 F0 E9 7B FD FF FF 8B 4D F4 8B 55 F0 3B 51 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C3 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CB 33 D2 75 C7 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_193_0 {
	meta:
		name = "?PreProcessDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 629
		refs = "0047 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0051 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 005a ??_C@_1IO@HEOAKEMN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006b ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0072 __CrtDbgReportW 008b ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 009f ?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z 00eb ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00f8 ??_C@_1JA@LHEKDBNA@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAI?$AAd?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5@ 0197 ??_C@_1EM@LAPCPLNB@?$AAp?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAf?$AAF?$AAu?$AAl?$AAl?$AAy?$AAL?$AAo?$AAa?$AAd?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 01f6 ?HandleSharedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUDynamicAllocationData@23@@Z 0242 ?IsHillClimbingEnabled@SchedulerProxy@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 89 4D F0 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F0 8B 55 F4 3B 51 08 0F 83 45 02 00 00 8B 45 F0 8B 48 54 8B 55 F4 8B 04 91 89 45 F8 8B 4D F8 8B 51 10 89 55 FC 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 89 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 76 10 8B 45 F8 50 8B 4D FC 51 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 90 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 39 42 14 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 91 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C6 33 D2 75 C2 8B 45 F8 83 78 14 00 0F 86 92 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 2B 41 14 8B 55 F8 39 42 24 76 7C 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 2B 41 14 3B F0 76 0D 8B 4D FC E8 ?? ?? ?? ?? 89 45 EC EB 11 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 2B 42 14 89 45 EC 8B 45 F8 8B 4D EC 89 48 24 8B 55 F8 0F B6 42 21 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 99 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 39 41 24 73 6A 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 76 54 8B 55 F8 52 8B 45 FC 50 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A7 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C0 33 C0 75 BC 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 1E 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 39 42 24 76 0E 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 89 41 24 E9 A3 FD FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_194_0 {
	meta:
		name = "?PreProcessStaticAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 176
		refs = "0041 ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 004d ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0057 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0060 ??_C@_1IO@HEOAKEMN@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@ 0065 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0071 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0078 __CrtDbgReportW 00a2 ?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 89 4D F4 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F4 8B 55 FC 3B 51 08 0F 83 80 00 00 00 8B 45 F4 8B 48 54 8B 55 FC 8B 04 91 8B 48 10 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 76 5D 8B 4D F8 E8 ?? ?? ?? ?? 8B F0 8B 4D F8 E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 6F 0D 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC 8B 55 F4 8B 42 54 8B 4D FC 8B 14 88 52 8B 45 F8 50 8B 4D F4 E8 ?? ?? ?? ?? E9 68 FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_195_0 {
	meta:
		name = "?PrepareReceiversForCoreTransfer@ResourceManager@details@Concurrency@@AAEII@Z"
		size = 1017
		refs = "00c5 ??_C@_1CC@MAHLNJCC@?$AAn?$AAu?$AAm?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00ca ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00d6 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00dd __CrtDbgReportW 0148 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 02e3 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 50 56 89 4D FC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D 08 0F 83 96 00 00 00 8B 55 F0 3B 55 08 73 53 8B 45 FC 8B 48 5C 8B 55 F0 8B 04 91 83 78 04 00 75 41 8B 4D 08 83 E9 01 89 4D 08 8B 55 FC 8B 42 5C 8B 4D F0 8B 14 88 89 55 C0 8B 45 FC 8B 48 5C 8B 55 FC 8B 42 5C 8B 55 F0 8B 75 08 8B 0C B1 89 0C 90 8B 55 FC 8B 42 5C 8B 4D 08 8B 55 C0 89 14 88 EB A5 8B 45 FC 8B 48 5C 8B 55 F0 8B 04 91 C7 40 28 00 00 00 00 8B 4D FC 8B 51 5C 8B 45 F0 8B 0C 82 C7 41 2C 00 00 00 00 8B 55 FC 8B 42 5C 8B 4D F0 8B 14 88 C6 42 20 01 E9 55 FF FF FF 83 7D 08 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1B 0E 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 8B 45 08 89 45 B0 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 08 0F 83 00 01 00 00 8B 45 F8 3B 45 08 0F 83 EF 00 00 00 8B 4D FC 8B 51 5C 8B 45 F8 8B 0C 82 83 79 28 00 0F 85 D9 00 00 00 8B 55 FC 8B 42 5C 8B 4D F8 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 89 45 C8 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D FC 8B 55 E4 3B 51 18 73 4F 8B 45 E4 6B C0 34 8B 4D C8 83 7C 01 1C 00 76 3D 8B 55 E4 6B D2 34 8B 45 E4 6B C0 34 8B 4D C8 8B 75 C8 8B 54 11 1C 3B 54 06 04 73 21 8B 45 FC 8B 48 5C 8B 55 F8 8B 04 91 8B 48 28 83 C1 01 8B 55 FC 8B 42 5C 8B 55 F8 8B 04 90 89 48 28 EB 9D 8B 4D FC 8B 51 5C 8B 45 F8 8B 0C 82 83 79 28 00 75 3F 8B 55 08 83 EA 01 89 55 08 8B 45 FC 8B 48 5C 8B 55 F8 8B 04 91 89 45 BC 8B 4D FC 8B 51 5C 8B 45 FC 8B 48 5C 8B 45 F8 8B 75 08 8B 14 B2 89 14 81 8B 45 FC 8B 48 5C 8B 55 08 8B 45 BC 89 04 91 E9 05 FF FF FF E9 EB FE FF FF C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 3B 55 08 0F 83 BB 01 00 00 8B 45 F4 89 45 D8 8B 4D F4 83 C1 01 89 4D DC EB 09 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC 3B 45 08 73 28 8B 4D FC 8B 51 5C 8B 45 DC 8B 0C 82 8B 55 FC 8B 42 5C 8B 55 D8 8B 04 90 8B 49 28 3B 48 28 73 06 8B 55 DC 89 55 D8 EB C7 8B 45 F4 3B 45 D8 74 36 8B 4D FC 8B 51 5C 8B 45 F4 8B 0C 82 89 4D B8 8B 55 FC 8B 42 5C 8B 4D FC 8B 51 5C 8B 4D F4 8B 75 D8 8B 04 B0 89 04 8A 8B 4D FC 8B 51 5C 8B 45 D8 8B 4D B8 89 0C 82 8B 55 FC 8B 42 5C 8B 4D F4 8B 14 88 8B 4A 10 E8 ?? ?? ?? ?? 89 45 C4 8B 45 FC 8B 48 5C 8B 55 F4 8B 04 91 8B 48 10 E8 ?? ?? ?? ?? 89 45 E8 C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 8B 55 FC 8B 42 5C 8B 4D F4 8B 14 88 8B 45 EC 3B 42 28 0F 83 D6 00 00 00 8B 4D EC 89 4D E0 8B 55 E0 8B 45 E8 8B 0C 90 6B C9 34 03 4D C4 89 4D D0 8B 55 EC 83 C2 01 89 55 D4 EB 09 8B 45 D4 83 C0 01 89 45 D4 8B 4D FC 8B 55 D4 3B 51 18 73 68 8B 45 D4 8B 4D E8 8B 14 81 6B D2 34 03 55 C4 89 55 CC 8B 45 CC 83 78 1C 00 76 4B 8B 4D CC 8B 55 CC 8B 41 1C 3B 42 04 73 3D 8B 4D D0 83 79 1C 00 76 1C 8B 55 D0 8B 45 D0 8B 4A 1C 3B 48 04 73 0E 8B 55 CC 8B 45 D0 8B 4A 1C 3B 48 1C 76 18 8B 55 D4 89 55 E0 8B 45 E0 8B 4D E8 8B 14 81 6B D2 34 03 55 C4 89 55 D0 EB 84 8B 45 EC 3B 45 E0 74 2A 8B 4D EC 8B 55 E8 8B 04 8A 89 45 B4 8B 4D EC 8B 55 E8 8B 45 E0 8B 75 E8 8B 04 86 89 04 8A 8B 4D E0 8B 55 E8 8B 45 B4 89 04 8A E9 09 FF FF FF E9 30 FE FF FF 8B 45 B0 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_196_0 {
	meta:
		name = "?RedistributeCoresAmongAll@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@III@Z"
		size = 2647
		refs = "0037 ??_C@_1IK@MKBPHJEI@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy@ 003c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0048 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004f __CrtDbgReportW 00c0 ??_C@_1DE@LJNDEJLD@?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?$AA@ 00f1 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00fb ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0152 __real@3e7ad7f29abcaf48 0164 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0182 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 01cb ??_C@_1DG@PIBBDMGO@?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 02c7 ?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ 02e1 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0314 ??_C@_1IE@MJAOJPLG@?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAd?$AAj?$AAu?$AAs?$AAt?$AAe?$AAd?$AAD?$AAe?$AAs?$AAi@ 036a ??_C@_1CO@CLPACIPD@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?$AA@ 0419 ?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z 0579 ??_C@_1JK@DKHPCAJO@?$AAt?$AAo?$AAt?$AAa?$AAl?$AAD?$AAe?$AAs?$AAi?$AAr?$AAe?$AAd?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAu?$AAm?$AAD?$AAe?$AAs?$AAi?$AAr?$AAe?$AAd?$AA?5?$AA?$CL?$AA?5?$AAe?$AAp?$AAs@ 08c9 ??_C@_1BCC@NOMGNALB@?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AAi?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAM?$AAi?$AAn?$AAH?$AAW?$AAT?$AAh?$AAr@ 0922 ??_C@_1IK@CCHPGHEE@?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAM?$AAi?$AAn?$AAH?$AAW?$AAT?$AAh?$AAr@ 0966 ??_C@_1FE@EEDPENFN@?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAi?$AAe?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd@ 0a09 ?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z 0a2e ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 0a46 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 81 EC 2C 01 00 00 56 89 4D EC C7 45 8C 00 00 00 00 8B 45 EC 83 78 08 00 76 19 B9 04 00 00 00 6B C9 00 8B 55 EC 8B 42 54 8B 0C 08 8B 51 10 3B 55 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AE 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B4 33 D2 75 B0 8B 45 EC 83 78 08 01 0F 86 DC 09 00 00 8B 4D 10 89 4D A8 8B 55 0C 89 55 C8 C7 45 F4 01 00 00 00 C7 45 BC 01 00 00 00 EB 09 8B 45 BC 83 C0 01 89 45 BC 8B 4D EC 8B 55 BC 3B 51 08 0F 83 88 00 00 00 8B 45 EC 8B 48 54 8B 55 BC 8B 04 91 8B 48 10 89 4D C0 8B 55 08 3B 55 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BF 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA 8B 4D C0 E8 ?? ?? ?? ?? 8B F0 8B 4D C0 E8 ?? ?? ?? ?? 3B F0 76 25 8B 45 F4 83 C0 01 89 45 F4 8B 4D C0 E8 ?? ?? ?? ?? 03 45 A8 89 45 A8 8B 4D C0 E8 ?? ?? ?? ?? 03 45 C8 89 45 C8 E9 60 FF FF FF 83 7D F4 01 0F 86 16 09 00 00 8B 4D A8 3B 4D C8 0F 87 0A 09 00 00 D9 EE DD 5D DC D9 EE DD 9D 64 FF FF FF DD 05 ?? ?? ?? ?? DD 5D A0 33 D2 88 55 D3 68 D6 07 00 00 68 ?? ?? ?? ?? 0F B6 45 D3 50 33 C9 8B 45 F4 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 70 FF FF FF 8B 85 70 FF FF FF 89 45 FC B9 04 00 00 00 6B C9 00 8B 55 EC 8B 42 54 BA 04 00 00 00 6B D2 00 8B 75 FC 8B 04 01 89 04 16 B9 04 00 00 00 6B C9 00 8B 55 FC 8B 04 0A 83 38 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D9 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C3 33 C0 75 BF 8B 4D 14 89 8D 34 FF FF FF C7 85 38 FF FF FF 00 00 00 00 DF AD 34 FF FF FF BA 04 00 00 00 6B D2 00 8B 45 FC 8B 0C 10 DD 59 20 BA 04 00 00 00 6B D2 00 8B 45 FC 8B 0C 10 DD 45 DC DC 41 20 DD 5D DC C7 45 F0 01 00 00 00 C7 45 B0 01 00 00 00 EB 09 8B 55 B0 83 C2 01 89 55 B0 8B 45 EC 8B 4D B0 3B 48 08 0F 83 00 01 00 00 8B 55 EC 8B 42 54 8B 4D B0 8B 14 88 8B 42 10 89 45 C4 8B 4D 08 3B 4D C4 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E2 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA 8B 4D C4 E8 ?? ?? ?? ?? 8B F0 8B 4D C4 E8 ?? ?? ?? ?? 3B F0 0F 86 99 00 00 00 8B 4D C4 E8 ?? ?? ?? ?? 8B 55 F0 8B 4D FC 89 04 91 8B 55 F0 8B 45 FC 8B 34 90 8B 4D C4 E8 ?? ?? ?? ?? 89 85 4C FF FF FF C7 85 50 FF FF FF 00 00 00 00 DF AD 4C FF FF FF DD 9D 04 FF FF FF DD 85 04 FF FF FF DD 46 20 DA E9 DF E0 F6 C4 44 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E7 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 97 33 C0 75 93 8B 4D F0 8B 55 FC 8B 04 8A DD 45 DC DC 40 20 DD 5D DC 8B 4D F0 83 C1 01 89 4D F0 E9 E8 FE FF FF 8B 55 F0 3B 55 F4 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 ED 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA B8 01 00 00 00 85 C0 0F 84 F6 05 00 00 8B 4D C8 89 8D 1C FF FF FF C7 85 20 FF FF FF 00 00 00 00 DF AD 1C FF FF FF DD 9D DC FE FF FF DD 85 DC FE FF FF DC 75 DC DD 9D 64 FF FF FF C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 F0 3B 45 F4 73 20 8B 4D F0 8B 55 FC 8B 04 8A DD 40 20 DC 8D 64 FF FF FF 8B 4D F0 8B 55 FC 8B 04 8A DD 58 08 EB CF 8B 4D C8 51 8B 55 F4 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C C6 45 FB 00 C7 45 E4 01 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 E4 3B 55 F4 0F 83 C8 00 00 00 8B 45 E4 8B 4D FC 8B 14 81 8B 42 10 89 45 90 8B 4D E4 8B 55 FC 8B 34 8A 8B 4D 90 E8 ?? ?? ?? ?? 39 46 04 0F 86 9A 00 00 00 8B 4D 90 E8 ?? ?? ?? ?? 89 85 3C FF FF FF C7 85 40 FF FF FF 00 00 00 00 DF AD 3C FF FF FF DD 9D EC FE FF FF DD 85 EC FE FF FF 8B 45 E4 8B 4D FC 8B 14 81 8B 42 04 89 85 0C FF FF FF C7 85 10 FF FF FF 00 00 00 00 DF AD 0C FF FF FF DD 9D FC FE FF FF DC B5 FC FE FF FF DD 9D 14 FF FF FF 8B 4D E4 8B 55 FC 8B 04 8A D9 E8 DC A5 14 FF FF FF DC 48 20 DC 6D DC DD 5D DC 8B 4D E4 8B 55 FC 8B 04 8A DD 85 14 FF FF FF DC 48 20 8B 4D E4 8B 55 FC 8B 04 8A DD 58 20 C6 45 FB 01 E9 23 FF FF FF 0F B6 4D FB 85 C9 0F 84 95 00 00 00 D9 EE DD 9D 7C FF FF FF C7 45 AC 00 00 00 00 EB 09 8B 55 AC 83 C2 01 89 55 AC 8B 45 AC 3B 45 F4 73 1A 8B 4D AC 8B 55 FC 8B 04 8A DD 85 7C FF FF FF DC 40 20 DD 9D 7C FF FF FF EB D5 DD 85 7C FF FF FF DC 45 A0 DC 5D DC DF E0 F6 C4 01 75 13 DD 85 7C FF FF FF DC 65 A0 DC 5D DC DF E0 F6 C4 41 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2C 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 B0 33 C0 75 AC E9 EC FD FF FF C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 E8 3B 55 F4 0F 83 C8 00 00 00 8B 45 E8 8B 4D FC 8B 14 81 8B 42 10 89 45 98 8B 4D E8 8B 55 FC 8B 34 8A 8B 4D 98 E8 ?? ?? ?? ?? 39 46 04 0F 86 9A 00 00 00 8B 4D 98 E8 ?? ?? ?? ?? 89 85 24 FF FF FF C7 85 28 FF FF FF 00 00 00 00 DF AD 24 FF FF FF DD 9D F4 FE FF FF DD 85 F4 FE FF FF 8B 45 E8 8B 4D FC 8B 14 81 8B 42 04 89 85 5C FF FF FF C7 85 60 FF FF FF 00 00 00 00 DF AD 5C FF FF FF DD 9D E4 FE FF FF DC B5 E4 FE FF FF DD 9D 2C FF FF FF 8B 4D E8 8B 55 FC 8B 04 8A D9 E8 DC A5 2C FF FF FF DC 48 20 DC 6D DC DD 5D DC 8B 4D E8 8B 55 FC 8B 04 8A DD 85 2C FF FF FF DC 48 20 8B 4D E8 8B 55 FC 8B 04 8A DD 58 20 C6 45 FB 01 E9 23 FF FF FF 0F B6 4D FB 85 C9 0F 84 95 00 00 00 D9 EE DD 9D 74 FF FF FF C7 45 B4 00 00 00 00 EB 09 8B 55 B4 83 C2 01 89 55 B4 8B 45 B4 3B 45 F4 73 1A 8B 4D B4 8B 55 FC 8B 04 8A DD 85 74 FF FF FF DC 40 20 DD 9D 74 FF FF FF EB D5 DD 85 74 FF FF FF DC 45 A0 DC 5D DC DF E0 F6 C4 01 75 13 DD 85 74 FF FF FF DC 65 A0 DC 5D DC DF E0 F6 C4 41 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 47 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 B0 33 C0 75 AC E9 65 FC FF FF C7 45 D8 00 00 00 00 EB 09 8B 4D D8 83 C1 01 89 4D D8 8B 55 D8 3B 55 F4 0F 83 8E 00 00 00 8B 45 D8 8B 4D FC 8B 14 81 8B 42 10 89 45 9C 8B 4D 9C E8 ?? ?? ?? ?? 8B 4D D8 8B 55 FC 8B 0C 8A 3B 41 04 76 64 8B 4D 9C E8 ?? ?? ?? ?? 89 85 54 FF FF FF C7 85 58 FF FF FF 00 00 00 00 DF AD 54 FF FF FF DD 9D D4 FE FF FF DD 85 D4 FE FF FF DC B5 64 FF FF FF DD 9D 44 FF FF FF 8B 55 D8 8B 45 FC 8B 0C 90 DD 85 44 FF FF FF DC 61 20 DC 45 DC DD 5D DC 8B 55 D8 8B 45 FC 8B 0C 90 DD 85 44 FF FF FF DD 59 20 C6 45 FB 01 E9 5D FF FF FF 0F B6 55 FB 85 D2 0F 84 86 00 00 00 D9 EE DD 5D 84 C7 45 B8 00 00 00 00 EB 09 8B 45 B8 83 C0 01 89 45 B8 8B 4D B8 3B 4D F4 73 14 8B 55 B8 8B 45 FC 8B 0C 90 DD 45 84 DC 41 20 DD 5D 84 EB DB DD 45 84 DC 45 A0 DC 5D DC DF E0 F6 C4 01 75 10 DD 45 84 DC 65 A0 DC 5D DC DF E0 F6 C4 41 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 62 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 B6 33 C9 75 B2 E9 27 FB FF FF C7 45 D4 01 00 00 00 EB 09 8B 55 D4 83 C2 01 89 55 D4 8B 45 D4 3B 45 F4 73 6E 8B 4D D4 8B 55 FC 8B 04 8A 8B 48 10 E8 ?? ?? ?? ?? 8B 4D D4 8B 55 FC 8B 0C 8A 3B 41 04 77 1F 8B 55 D4 8B 45 FC 8B 34 90 8B 4D D4 8B 55 FC 8B 04 8A 8B 48 10 E8 ?? ?? ?? ?? 39 46 04 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 69 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 98 33 C0 75 94 EB 81 B9 04 00 00 00 6B C9 00 8B 55 FC 8B 04 0A 8B 48 10 E8 ?? ?? ?? ?? B9 04 00 00 00 6B C9 00 8B 55 FC 8B 0C 0A 3B 41 04 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 6B 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 AD 33 C9 75 A9 BA 04 00 00 00 6B D2 00 8B 45 FC 8B 0C 10 8B 51 10 3B 55 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 6C 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC EB 05 E9 FD F9 FF FF B8 04 00 00 00 6B C0 00 8B 4D FC 8B 14 01 8B 42 04 3B 45 0C 0F 86 81 00 00 00 C7 45 CC 01 00 00 00 EB 09 8B 4D CC 83 C1 01 89 4D CC 8B 55 CC 3B 55 F4 73 41 8B 45 CC 8B 4D FC 8B 14 81 8B 4A 10 E8 ?? ?? ?? ?? 8B 4D CC 8B 55 FC 8B 0C 8A 2B 41 04 89 45 94 74 1D 8B 55 94 52 8B 45 CC 8B 4D FC 8B 14 81 8B 42 10 50 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? EB AE 6A 00 BA 04 00 00 00 6B D2 00 8B 45 FC 8B 0C 10 8B 51 04 2B 55 0C 52 8B 45 08 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 8C 8B 4D FC 89 8D 6C FF FF FF 8B 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 8C 5E 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_41_197_0 {
	meta:
		name = "?Reference@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 29
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 04 B9 01 00 00 00 F0 0F C1 08 41 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_198_0 {
	meta:
		name = "?RegisterScheduler@ResourceManager@details@Concurrency@@UAEPAUISchedulerProxy@3@PAUIScheduler@3@I@Z"
		size = 96
		refs = "0010 ??_C@_0L@HKFDMHB@pScheduler?$AA@ 0018 ??0invalid_argument@std@@QAE@PBD@Z 001d __TI3?AVinvalid_argument@std@@ 0026 __CxxThrowException@8 0034 ??_C@_07CPCPJPKL@version?$AA@ 0056 ?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D FC 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 81 7D 0C 00 00 01 00 74 1B 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E4 51 E8 ?? ?? ?? ?? 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_199_0 {
	meta:
		name = "?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 365
		refs = "0006 __ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0015 ___security_cookie 0040 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0048 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0055 ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 005b ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 007c ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ 0098 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 00a6 ??_C@_1EM@OPKBEHIM@?$AAm?$AA_?$AAh?$AAD?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAH?$AAa?$AAn?$AAd?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?$CI?$AAH?$AAA?$AAN@ 00ab ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00b7 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00be __CrtDbgReportW 00dd ??_C@_1EE@HAKDPCGF@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAt?$AAa?$AAn?$AAd?$AAb@ 0118 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 0120 ?WakeupDynamicRMWorker@ResourceManager@details@Concurrency@@QAEXXZ 012f __imp__WaitForSingleObject@8 014b ??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 1C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 04 83 C9 FF F0 0F C1 08 49 89 4D E8 0F 85 1C 01 00 00 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 39 45 F0 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 F0 83 78 4C 00 0F 84 A6 00 00 00 8B 4D F0 83 C1 2C 51 8D 4D E0 E8 ?? ?? ?? ?? 8B 55 F0 83 7A 4C 01 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 41 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 F0 83 78 28 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 43 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D F0 C7 41 28 02 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 6A FF 8B 55 F0 8B 42 4C 50 FF 15 ?? ?? ?? ?? 8B 4D F0 89 4D DC 8B 55 DC 89 55 EC 83 7D EC 00 74 0F 6A 01 8B 4D EC E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 45 E8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_201_0 {
	meta:
		name = "__ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_109_2 {
	meta:
		name = "__ehhandler$??$_Equal@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Equal@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_141_3 {
	meta:
		name = "__ehhandler$??$_Equal@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Equal@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_168_3 {
	meta:
		name = "__ehhandler$??$_Less@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Less@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_171_3 {
	meta:
		name = "__ehhandler$??$_Less@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Less@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_146_1 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_149_1 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_234_1 {
	meta:
		name = "__ehhandler$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@PAX@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@PAX@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_26_0 {
	meta:
		name = "__ehhandler$??$reset@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$reset@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_831_3_0 {
	meta:
		name = "__ehhandler$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_2_0 {
	meta:
		name = "__ehhandler$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_5_0 {
	meta:
		name = "__ehhandler$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_520_2 {
	meta:
		name = "__ehhandler$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_246_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_548_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_520_2 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_708_18_0 {
	meta:
		name = "__ehhandler$??IQuickBitSet@details@Concurrency@@QBE?AV012@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??IQuickBitSet@details@Concurrency@@QBE?AV012@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_172_0 {
	meta:
		name = "__ehhandler$?AddContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_78_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_48_0 {
	meta:
		name = "__ehhandler$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_843_26_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_26_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_63_0 {
	meta:
		name = "__ehhandler$?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_387_16_0 {
	meta:
		name = "__ehhandler$?FindSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?FindSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_283_0 {
	meta:
		name = "__ehhandler$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_310_0 {
	meta:
		name = "__ehhandler$?GetRealizedChore@SchedulerBase@details@Concurrency@@QAEPAVRealizedChore@23@P6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetRealizedChore@SchedulerBase@details@Concurrency@@QAEPAVRealizedChore@23@P6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_842_83_0 {
	meta:
		name = "__ehhandler$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_157_0 {
	meta:
		name = "__ehhandler$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_399_0 {
	meta:
		name = "__ehhandler$?PushRunnableToInactive@SchedulerBase@details@Concurrency@@UAE_NPAVInternalContextBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?PushRunnableToInactive@SchedulerBase@details@Concurrency@@UAE_NPAVInternalContextBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_739_2 {
	meta:
		name = "__ehhandler$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_349_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_812_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_850_3 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1041_3 {
	meta:
		name = "__ehhandler$?_internal_send@?$_AnonymousOriginator@I@details@Concurrency@@AAE_NPAV?$ITarget@I@3@ABI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_internal_send@?$_AnonymousOriginator@I@details@Concurrency@@AAE_NPAV?$ITarget@I@3@ABI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1044_3 {
	meta:
		name = "__ehhandler$?_internal_send@?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@AAE_NPAV?$ITarget@W4agent_status@Concurrency@@@3@ABW4agent_status@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_internal_send@?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@AAE_NPAV?$ITarget@W4agent_status@Concurrency@@@3@ABW4agent_status@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_479_5_0 {
	meta:
		name = "__ehhandler$?x_ismbbtype_l@@YAHPAUlocaleinfo_struct@@IHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?x_ismbbtype_l@@YAHPAUlocaleinfo_struct@@IHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_138_3 {
	meta:
		name = "__ehhandler$__Call_func@4"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$__Call_func@4 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_202_0 {
	meta:
		name = "?ReleaseCoresOnExistingSchedulers@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
		size = 341
		refs = "002c ??_C@_1HO@EHPEHFJL@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy@ 0031 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003d ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW 0066 ??_C@_1KE@DLBCNEPA@?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAR?$AAe?$AAl?$AAe?$AAa?$AAs?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AAD?$AAo?$AAw?$AAn@ 00c9 ??_C@_1FI@CEONPNEG@?$AAp?$AAN?$AAe?$AAw?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?$FL?$AAi?$AAn?$AAd?$AAe?$AAx@ 0112 ?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z 013c ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F8 8B 45 F8 83 78 08 00 76 19 B9 04 00 00 00 6B C9 00 8B 55 F8 8B 42 54 8B 0C 08 8B 51 10 3B 55 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8E 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B4 33 D2 75 B0 83 7D 10 FF 74 2C 83 7D 10 FE 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8F 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 C6 45 FF 00 C7 45 F4 01 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F8 8B 55 F4 3B 51 08 73 72 8B 45 F8 8B 48 54 8B 55 F4 8B 04 91 8B 4D 08 3B 48 10 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 96 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C2 33 C9 75 BE 8B 55 10 52 8B 45 F8 8B 48 54 8B 55 F4 8B 04 91 8B 48 10 51 8B 55 08 52 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 C6 45 FF 01 E9 7A FF FF FF 0F B6 4D FF 85 C9 74 17 6A 00 8B 55 0C 52 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 45 F0 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_203_0 {
	meta:
		name = "?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z"
		size = 1448
		refs = "0017 ??_C@_1FE@EBHBPHOF@?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP@ 001c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0028 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002f __CrtDbgReportW 0056 ?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ 006d ??_C@_1EG@GGHLFOFO@?$AAp?$AAS?$AAt?$AAa?$AAt?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAC?$AAo?$AAr?$AAe?$AAs?$AAS?$AAt?$AAo?$AAl?$AAe?$AAn?$AA?5?$AA?$DN?$AA?$DN@ 009e ?GetNumBorrowedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 00d7 ??_C@_1OC@ENMKHCIM@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe@ 0108 ?GetNumOwnedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0112 ?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 011b ??_C@_1IC@BNKCMGPO@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?$CI?$AA?$CJ@ 018e ??_C@_1IK@DENMFNAB@?$AAp?$AAS?$AAt?$AAa?$AAt?$AAi?$AAc?$AAD?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAC?$AAo?$AAr?$AAe?$AAs?$AAS?$AAt?$AAo?$AAl?$AAe?$AAn?$AA?5?$AA?$DN?$AA?$DN@ 021f ??_C@_1MI@ONIBJPOM@?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe@ 0265 ??_C@_1HO@INGEIFNB@?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs@ 02a9 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 02bf ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 031a ??_C@_1FE@FIDLIEIK@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAi?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAR?$AAe?$AAc?$AAe?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN@ 0356 ??_C@_1HA@EGFGMFCE@?$AAp?$AAG?$AAi?$AAv?$AAi?$AAn?$AAg?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAR?$AAe?$AAc@ 0387 ?GetNumMigratableCores@SchedulerNode@details@Concurrency@@QAEIXZ 03d3 ?IsFixed@SchedulerCore@details@Concurrency@@QAE_NXZ 03ec ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 03f8 ??_C@_1GM@EELJIOJB@?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CB?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa@ 0459 ??_C@_1JG@MCDFHAIA@?$AA?$CB?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAI?$AAs?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAe?$AAd?$AA?$CI?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM@ 04c7 ??_C@_1CE@BKJBDPDP@?$AAn?$AAu?$AAm?$AAO?$AAw?$AAn?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 050d ??_C@_1FO@HLKACLJC@?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe@ 054d ?ValidateStaticSchedulerState@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z 0566 ??_C@_1CE@LJMCJCIC@?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAT?$AAo?$AAF?$AAr?$AAe?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 56 89 4D E0 83 7D 08 00 74 06 83 7D 0C 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1D 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 C7 45 F8 00 00 00 00 C7 45 E8 00 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 89 45 F4 83 7D 10 FE 75 4D 8B 45 F4 83 78 2C 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 26 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 0C E8 ?? ?? ?? ?? 89 45 F8 8B 4D F8 89 4D 10 E9 A3 01 00 00 83 7D 10 FF 0F 85 C3 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 36 8B 4D 0C E8 ?? ?? ?? ?? 8B 55 F4 39 42 2C 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2C 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BA 33 D2 75 B6 8B 4D 0C E8 ?? ?? ?? ?? 8B F0 8B 4D 0C E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2D 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C0 33 D2 75 BC 8B 4D 0C E8 ?? ?? ?? ?? 8B F0 8B 4D 0C E8 ?? ?? ?? ?? 2B F0 8B 4D 0C E8 ?? ?? ?? ?? 8B 4D F4 8B 51 2C 2B D0 2B F2 89 75 10 C7 45 F8 00 00 00 00 E9 D6 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 8B 4D F4 39 41 2C 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 38 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C6 33 C9 75 C2 8B 4D 0C E8 ?? ?? ?? ?? 8B F0 8B 4D 0C E8 ?? ?? ?? ?? 3B F0 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 39 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C0 33 C9 75 BC 83 7D 10 00 76 19 8B 4D 0C E8 ?? ?? ?? ?? 8B F0 8B 4D 0C E8 ?? ?? ?? ?? 2B F0 39 75 10 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3A 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 B7 33 C9 75 B3 C7 45 F8 00 00 00 00 8B 55 10 3B 55 F8 72 09 81 7D 10 FF FF FF 7F 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3F 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C5 33 D2 75 C1 8B 45 10 2B 45 F8 89 45 E8 83 7D 10 00 0F 86 EE 02 00 00 8B 4D 0C E8 ?? ?? ?? ?? 89 45 D0 8B 4D 08 E8 ?? ?? ?? ?? 89 45 D4 8B 4D 08 E8 ?? ?? ?? ?? 89 45 DC C7 45 F0 00 00 00 00 EB 09 8B 4D F0 83 C1 01 89 4D F0 8B 55 E0 8B 45 F0 3B 42 18 0F 83 78 02 00 00 8B 4D F0 8B 55 DC 8B 04 8A 6B C0 34 03 45 D4 89 45 D8 8B 4D F0 8B 55 DC 8B 04 8A 6B C0 34 03 45 D0 89 45 EC 8B 4D EC 8B 55 D8 8B 41 10 3B 42 10 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 52 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 8B 4D EC 8B 55 D8 8B 41 04 3B 42 04 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 53 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 8B 4D EC E8 ?? ?? ?? ?? 85 C0 0F 86 C7 01 00 00 C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 EC 8B 45 E4 3B 42 04 0F 83 A6 01 00 00 8B 4D E4 6B C9 34 8B 55 EC 03 4A 30 89 4D FC 8B 45 FC 83 38 04 0F 85 86 01 00 00 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 0F 85 73 01 00 00 83 7D F8 00 77 35 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5D 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C1 33 D2 75 BD 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A 83 7D E8 00 0F 86 17 01 00 00 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 31 8B 55 FC 8B 42 14 83 38 01 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 62 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BC 33 C0 75 B8 8B 4D FC C7 01 05 00 00 00 8B 55 F4 8B 42 2C 83 C0 01 8B 4D F4 89 41 2C 8B 55 FC 8B 42 14 8B 08 83 E9 01 8B 55 FC 8B 42 14 89 08 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 3D 83 7D E8 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 6D 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 55 E8 83 EA 01 89 55 E8 83 7D 10 00 76 09 81 7D 10 FF FF FF 7F 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 71 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C7 33 D2 75 C3 8B 45 10 83 E8 01 89 45 10 75 10 8B 4D 0C 51 8B 4D E0 E8 ?? ?? ?? ?? B0 01 EB 4C E9 42 FE FF FF E9 70 FD FF FF 83 7D 10 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7D 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 55 0C 52 8B 4D E0 E8 ?? ?? ?? ?? 32 C0 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_204_0 {
	meta:
		name = "?Remove@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 172
		refs = "0019 ??_C@_1DG@KBDKHCCH@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAT?$AAa?$AAi?$AAl?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 001e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002a ??_C@_1GK@MCONHIPB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0031 __CrtDbgReportW 004a ?Decrement@Count@CollectionTypes@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 83 7D 08 00 74 09 8B 45 FC 83 78 04 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DE 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C7 33 C0 75 C3 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 8B 51 18 8B 45 08 8B 48 1C 89 4A 1C 8B 55 08 8B 42 1C 8B 4D 08 8B 51 18 89 50 18 8B 45 FC 8B 4D 08 3B 48 04 75 2F 8B 55 FC 8B 42 04 8B 4D FC 8B 51 04 3B 50 18 75 09 C7 45 F8 00 00 00 00 EB 0C 8B 45 FC 8B 48 04 8B 51 1C 89 55 F8 8B 45 FC 8B 4D F8 89 48 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_205_0 {
	meta:
		name = "?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 240
		refs = "0006 __ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0016 ___security_cookie 0038 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 0047 ?GetSchedulerProxy@ExecutionResource@details@Concurrency@@QAEPAVSchedulerProxy@23@XZ 0052 ?DecrementUseCounts@ExecutionResource@details@Concurrency@@QAEXXZ 005a ?GetNumAllocatedCores@SchedulerProxy@details@Concurrency@@QBEIXZ 0064 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 007f ??_C@_1EE@HAKDPCGF@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAt?$AAa?$AAn?$AAd?$AAb@ 0084 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0090 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0097 __CrtDbgReportW 00b0 ?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ 00ca ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 00da ?WakeupDynamicRMWorker@ResourceManager@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 10 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C6 45 F3 00 8B 45 EC 83 C0 2C 50 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E8 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D E8 E8 ?? ?? ?? ?? 8B F0 8B 4D E8 E8 ?? ?? ?? ?? 3B F0 73 53 8B 4D EC 83 79 08 01 75 4A 8B 55 EC 83 7A 28 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7B 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 C6 45 F3 01 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 4D F3 85 C9 74 08 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_207_0 {
	meta:
		name = "__ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_152_1 {
	meta:
		name = "__ehhandler$??$_Uninit_move@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV12@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@V12@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@PAV10@00AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@0U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_move@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV12@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@V12@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@PAV10@00AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@0U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_245_3 {
	meta:
		name = "__ehhandler$??$_Uninit_move@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@PAV12@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@V12@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@PAV10@00AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@0U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_move@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@PAV12@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@V12@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@PAV10@00AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@0U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_34_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_578_9_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_16_0 {
	meta:
		name = "__ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_16_2 {
	meta:
		name = "__ehhandler$??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IAE@ABV_Concurrent_queue_base_v4@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IAE@ABV_Concurrent_queue_base_v4@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_37_3 {
	meta:
		name = "__ehhandler$??0_Pad@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Pad@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1170_18_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1180_27_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1180_30_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_232_2 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_545_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_92_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_249_3 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_557_3 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_560_3 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_631_2 {
	meta:
		name = "__ehhandler$??H?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_634_2 {
	meta:
		name = "__ehhandler$??H?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_843_23_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_23_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_67_0 {
	meta:
		name = "__ehhandler$?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_70_0 {
	meta:
		name = "__ehhandler$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_54_0 {
	meta:
		name = "__ehhandler$?FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AAE_NAAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AAE_NAAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_172_0 {
	meta:
		name = "__ehhandler$?Initialize@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVScheduleGroupBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVScheduleGroupBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_708_48_0 {
	meta:
		name = "__ehhandler$?PostAffinityMessage@SchedulerBase@details@Concurrency@@QAEXABVQuickBitSet@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?PostAffinityMessage@SchedulerBase@details@Concurrency@@QAEXABVQuickBitSet@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_467_0 {
	meta:
		name = "__ehhandler$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_57_0 {
	meta:
		name = "__ehhandler$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_801_2 {
	meta:
		name = "__ehhandler$?_Copy@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAV?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@2@PAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAV?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@2@PAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_124_2 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_840_2 {
	meta:
		name = "__ehhandler$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_928_1 {
	meta:
		name = "__ehhandler$?_Move@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAV?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@2@PAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Move@?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAV?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@2@PAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1055_64_0 {
	meta:
		name = "__ehhandler$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_902_2 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_1065_3 {
	meta:
		name = "__ehhandler$?accept_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?accept_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_497_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1278_3 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_1246_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_825_1 {
	meta:
		name = "__ehhandler$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_828_1 {
	meta:
		name = "__ehhandler$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?swap@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAEXAAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1180_128_0 {
	meta:
		name = "__ehhandler$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_384_3 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_386_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_336_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_208_0 {
	meta:
		name = "?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 709
		refs = "0006 __ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0015 ___security_cookie 0042 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 0051 ?GetNumExternalThreads@SchedulerProxy@details@Concurrency@@QAEIXZ 005a ??_C@_1EK@PJMFHFHM@?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAN?$AAu?$AAm?$AAE?$AAx?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAs?$AA?$CI?$AA?$CJ?$AA?5@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006b ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0072 __CrtDbgReportW 0093 ?ReferenceCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@XZ 00a8 ?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ 00dc ?AddTail@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 00ef ?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z 010b ??_C@_1DG@KNDIBEAP@?$AAp?$AAN?$AAe?$AAw?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAo?$AAn?$AAR?$AAe?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 014f ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 016d ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 0183 ??_C@_1EE@HAKDPCGF@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAt?$AAa?$AAn?$AAd?$AAb@ 01db ??_C@_1CG@LMNMFOBC@?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0213 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0234 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 029d ?WakeupDynamicRMWorker@ResourceManager@details@Concurrency@@QAEXXZ 02ad ?CreateDynamicRMWorker@ResourceManager@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C6 45 F2 00 C7 45 E8 00 00 00 00 C6 45 F3 00 8B 45 EC 83 C0 2C 50 8D 4D E0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 01 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CA 33 C0 75 C6 0F B6 4D 0C 85 C9 74 15 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 04 C6 45 F3 01 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0F 8B 45 EC 8B 48 10 83 C1 01 8B 55 EC 89 4A 10 8B 45 EC 8B 48 08 83 C1 01 8B 55 EC 89 4A 08 8B 45 08 50 8B 4D EC 83 C1 60 E8 ?? ?? ?? ?? 0F B6 4D F3 51 6A 01 8B 55 08 52 8B 4D EC E8 ?? ?? ?? ?? 89 45 E4 83 7D E8 00 75 08 8B 45 E4 89 45 E8 EB 34 83 7D E4 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 24 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C 8B 55 08 52 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 78 08 02 74 1D 8B 4D E8 89 4D DC C7 45 FC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 DC E9 3B 01 00 00 8B 55 EC 83 7A 28 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 32 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 EC C7 40 28 01 00 00 00 8B 4D EC 83 79 4C 00 0F 85 C3 00 00 00 8B 55 EC C7 42 4C 01 00 00 00 8B 45 EC 83 78 54 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3C 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 33 C9 88 4D F1 68 3D 06 00 00 68 ?? ?? ?? ?? 0F B6 55 F1 52 33 C9 8B 55 EC 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 8B 45 EC 8B 4D D8 89 48 58 33 D2 88 55 F0 68 3E 06 00 00 68 ?? ?? ?? ?? 0F B6 45 F0 50 33 C9 8B 55 EC 8B 42 0C BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 8B 45 EC 8B 4D D4 89 48 5C C6 45 F2 01 C7 45 FC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 0F B6 55 F2 85 D2 74 08 8B 4D EC E8 ?? ?? ?? ?? 8B 45 E8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_211_0 {
	meta:
		name = "?ReserveAtHigherUseCounts@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@I@Z"
		size = 80
		refs = "003b ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 FC 3B 45 0C 73 28 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 52 8B 45 0C 2B 45 FC 50 8B 4D 08 51 8B 4D F4 E8 ?? ?? ?? ?? 03 45 FC 89 45 FC EB D0 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_212_0 {
	meta:
		name = "?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
		size = 1009
		refs = "0015 ?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ 002d ?GetCurrentNodeAndCore@ResourceManager@details@Concurrency@@QAEIPAI@Z 0038 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0043 ?GetSortedNodeOrder@SchedulerProxy@details@Concurrency@@QBEPAIXZ 0055 ??_C@_1BI@HGMMJCLL@?$AAr?$AAe?$AAq?$AAu?$AAe?$AAs?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 005a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0066 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d __CrtDbgReportW 0123 ??_C@_1OE@IICMAFKE@?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAP@ 02c8 ??_C@_1JI@KKALNNDH@?$AAp?$AAM?$AAa?$AAx?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AAC?$AAo?$AAr?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5@"
	strings:
		$1 = { 55 8B EC 83 EC 50 56 89 4D C0 C7 45 B4 FF FF FF FF 8B 4D 08 E8 ?? ?? ?? ?? 89 45 B8 8B 45 B8 0F B6 48 28 85 C9 74 0D 6A 00 8B 4D C0 E8 ?? ?? ?? ?? 89 45 B4 8B 4D 08 E8 ?? ?? ?? ?? 89 45 D8 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F4 C6 45 FF 00 83 7D 0C 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5F 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC C7 45 CC 00 00 00 00 EB 09 8B 55 CC 83 C2 01 89 55 CC 8B 45 C0 8B 4D CC 3B 48 18 0F 83 B7 00 00 00 8B 55 CC 6B D2 34 03 55 D8 89 55 C4 C7 45 C8 00 00 00 00 EB 09 8B 45 C8 83 C0 01 89 45 C8 8B 4D C4 8B 55 C8 3B 51 04 0F 83 85 00 00 00 8B 45 C8 6B C0 34 8B 4D C4 03 41 30 89 45 E0 8B 55 E0 83 3A 01 75 2B 8B 45 E0 8B 48 14 8B 55 10 3B 11 75 1C C6 45 FF 01 8B 45 E0 C7 00 02 00 00 00 8B 4D C4 8B 51 08 83 C2 01 8B 45 C4 89 50 08 EB 3E 8B 4D E0 83 39 04 74 2E 8B 55 E0 83 3A 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 76 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C6 33 D2 75 C2 E9 63 FF FF FF E9 31 FF FF FF C7 45 D0 00 00 00 00 0F B6 45 FF 85 C0 0F 84 7A 02 00 00 C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 C0 8B 45 E8 3B 42 18 0F 83 59 02 00 00 8B 4D E8 89 4D F0 8B 55 F0 8B 45 F4 8B 0C 90 6B C9 34 03 4D D8 89 4D F8 8B 55 0C 2B 55 D0 89 55 DC 0F 84 FD 00 00 00 8B 45 F8 8B 48 08 3B 4D DC 76 09 8B 55 F8 8B 45 DC 89 42 08 8B 4D E8 83 C1 01 89 4D E4 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 C0 8B 4D E4 3B 48 18 0F 83 C6 00 00 00 8B 55 E4 8B 45 F4 8B 0C 90 6B C9 34 03 4D D8 89 4D EC 8B 55 EC 8B 42 08 3B 45 DC 76 09 8B 4D EC 8B 55 DC 89 51 08 8B 45 F8 8B 48 08 8B 55 F8 03 4A 18 8B 45 F8 03 48 1C 8B 55 EC 8B 42 08 8B 55 EC 03 42 18 8B 55 EC 03 42 1C 3B C8 73 1A 8B 45 E4 89 45 F0 8B 4D F0 8B 55 F4 8B 04 8A 6B C0 34 03 45 D8 89 45 F8 EB 59 8B 4D F8 8B 51 08 8B 45 F8 03 50 18 8B 4D F8 03 51 1C 8B 45 EC 8B 48 08 8B 45 EC 03 48 18 8B 45 EC 03 48 1C 3B D1 75 31 8B 4D B8 0F B6 51 28 85 D2 74 26 8B 45 E4 8B 4D F4 8B 14 81 3B 55 B4 75 18 8B 45 E4 89 45 F0 8B 4D F0 8B 55 F4 8B 04 8A 6B C0 34 03 45 D8 89 45 F8 E9 22 FF FF FF 8B 4D F8 83 79 08 00 72 0C 8B 55 F8 81 7A 08 FF FF FF 7F 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D6 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C1 33 D2 75 BD 8B 45 F8 83 78 08 00 0F 86 AE 00 00 00 C7 45 BC 00 00 00 00 EB 09 8B 4D BC 83 C1 01 89 4D BC 8B 55 F8 8B 45 BC 3B 42 04 0F 83 83 00 00 00 8B 4D BC 6B C9 34 8B 55 F8 03 4A 30 89 4D D4 8B 45 D4 83 38 02 75 67 8B 4D D0 3B 4D 0C 73 56 8B 55 D4 C7 02 03 00 00 00 8B 45 D4 8B 48 14 8B 11 83 C2 01 8B 45 D4 8B 48 14 89 11 8B 55 F8 8B 42 18 83 C0 01 8B 4D F8 89 41 18 8B 55 B8 0F B6 42 28 85 C0 74 15 8B 4D F0 8B 55 F4 8B 04 8A 3B 45 B4 75 07 8B 4D B8 C6 41 28 00 8B 55 D0 83 C2 01 89 55 D0 EB 09 8B 45 D4 C7 00 01 00 00 00 E9 65 FF FF FF 8B 4D F8 C7 41 08 00 00 00 00 8B 55 E8 3B 55 F0 74 2A 8B 45 E8 8B 4D F4 8B 14 81 89 55 B0 8B 45 E8 8B 4D F4 8B 55 F0 8B 75 F4 8B 14 96 89 14 81 8B 45 F0 8B 4D F4 8B 55 B0 89 14 81 E9 8F FD FF FF 8B 45 D0 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_41_213_0 {
	meta:
		name = "?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 144
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D F0 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F0 8B 55 FC 3B 51 18 73 66 8B 45 FC 6B C0 28 8B 4D F0 03 41 48 89 45 F4 8B 55 F4 C7 42 08 00 00 00 00 8B 45 F4 C7 40 1C 00 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F4 8B 45 F8 3B 42 04 73 24 8B 4D F8 6B C9 24 8B 55 F4 03 4A 20 89 4D EC 8B 45 EC C7 00 00 00 00 00 8B 4D EC C7 41 1C 00 00 00 00 EB C8 EB 86 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_214_0 {
	meta:
		name = "?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ"
		size = 217
		refs = "000a ___security_cookie 0026 __imp__GetVersionExW@4 0035 ??0unsupported_os@Concurrency@@QAE@XZ 003a __TI2?AVunsupported_os@Concurrency@@ 0046 __CxxThrowException@8 0083 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 00b9 ?InitializeSystemFunctionPointers@ResourceManager@details@Concurrency@@CAXXZ 00c7 ?Initialize@WinRT@details@Concurrency@@SAXXZ 00d1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 2C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 E8 FE FF FF 14 01 00 00 8D 85 E8 FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 1C 8D 8D D4 FE FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D D4 FE FF FF 51 E8 ?? ?? ?? ?? 8B 95 EC FE FF FF 89 95 E0 FE FF FF 83 BD E0 FE FF FF 06 74 02 EB 44 8B 85 F0 FE FF FF 89 85 E4 FE FF FF 83 BD E4 FE FF FF 00 74 0B 83 BD E4 FE FF FF 01 74 0E EB 18 C7 05 ?? ?? ?? ?? 03 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 04 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 06 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 06 00 00 00 83 3D ?? ?? ?? ?? 04 7C 13 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 06 7C 05 E8 ?? ?? ?? ?? 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_215_0 {
	meta:
		name = "?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z"
		size = 1381
		refs = "0017 ??_C@_1DC@ICFJAGFF@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA1?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAp?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 001c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0028 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002f __CrtDbgReportW 0046 __real@3e7ad7f29abcaf48 00cd ??_C@_1MG@FHAEFIHH@?$AAs?$AAu?$AAm?$AAS?$AAc?$AAa?$AAl?$AAe?$AAd?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAt?$AAo?$AAt?$AAa?$AAl?$AAA?$AAl?$AAl?$AAo@ 0290 ??_C@_1CI@HANBJNMC@?$AAj?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAj?$AA?5?$AA?$DM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 02ff ??_C@_1BC@LADMKMJD@?$AAi?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAj?$AA?$CL?$AA1?$AA?$AA@ 0348 ??_C@_1CI@IDGHJAHL@?$AAi?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAj?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAj?$AA?5?$AA?$DM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 038f ??_C@_1BE@DBAEFIC@?$AAj?$AA?5?$AA?$DM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0435 ??_C@_1FI@FMBHCNE@?$AAf?$AAr?$AAa?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAe?$AAp?$AAs?$AAi?$AAl?$AAo?$AAn?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAf?$AAr?$AAa?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5@ 04a0 ??_C@_1EA@LIDLEAJA@?$AAs?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAt?$AAo?$AAt?$AAa?$AAl?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 56 83 7D 0C 01 76 06 83 7D 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3A 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 DD 05 ?? ?? ?? ?? DD 5D CC D9 EE DD 5D B4 C7 45 D4 00 00 00 00 EB 09 8B 45 D4 83 C0 01 89 45 D4 8B 4D D4 3B 4D 0C 73 14 8B 55 D4 8B 45 08 8B 0C 90 DD 45 B4 DC 41 08 DD 5D B4 EB DB 8B 55 10 89 55 98 C7 45 9C 00 00 00 00 DF 6D 98 DD 5D 88 DD 45 88 DC 45 CC DC 5D B4 DF E0 F6 C4 01 75 29 8B 45 10 89 45 A0 C7 45 A4 00 00 00 00 DF 6D A0 DD 9D 78 FF FF FF DD 85 78 FF FF FF DC 65 CC DC 5D B4 DF E0 F6 C4 41 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 43 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 8A 33 C0 75 86 D9 EE DD 5D C0 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 3B 55 0C 73 75 8B 45 F4 8B 4D 08 8B 14 81 DD 42 08 D9 7D DE 0F B7 45 DE 0D 00 0C 00 00 89 45 B0 D9 6D B0 DF 7D 80 D9 6D DE 8B 45 80 8B 4D F4 8B 55 08 8B 0C 8A 89 41 04 8B 55 F4 8B 45 08 8B 0C 90 8B 55 F4 8B 45 08 8B 14 90 8B 42 04 89 45 90 C7 45 94 00 00 00 00 DF 6D 90 DD 9D 70 FF FF FF DD 85 70 FF FF FF DC 69 08 8B 4D F4 8B 55 08 8B 04 8A DD 58 08 E9 7A FF FF FF C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 8B 55 EC 3B 55 0C 0F 83 83 00 00 00 8B 45 EC 89 45 D8 8B 4D EC 83 C1 01 89 4D E8 EB 09 8B 55 E8 83 C2 01 89 55 E8 8B 45 E8 3B 45 0C 73 2A 8B 4D E8 8B 55 08 8B 04 8A 8B 4D D8 8B 55 08 8B 0C 8A DD 41 08 DC 45 CC DC 58 08 DF E0 F6 C4 05 7A 06 8B 55 E8 89 55 D8 EB C5 8B 45 EC 3B 45 D8 74 2A 8B 4D EC 8B 55 08 8B 04 8A 89 45 AC 8B 4D EC 8B 55 08 8B 45 D8 8B 75 08 8B 04 86 89 04 8A 8B 4D D8 8B 55 08 8B 45 AC 89 04 8A E9 68 FF FF FF C7 45 F8 00 00 00 00 8B 4D 0C 83 E9 01 89 4D FC EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 0C 0F 83 C2 01 00 00 DD 45 CC DC 5D C0 DF E0 F6 C4 05 0F 8A 13 01 00 00 8B 4D FC 8B 55 08 8B 04 8A DD 45 CC DC 58 08 DF E0 F6 C4 05 0F 8A AD 00 00 00 83 7D FC 00 72 08 8B 4D FC 3B 4D 0C 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 6A 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C8 33 C9 75 C4 8B 55 FC 8B 45 08 8B 0C 90 DD 45 C0 DC 61 08 DD 5D C0 8B 55 FC 8B 45 08 8B 0C 90 D9 EE DD 59 08 8B 55 FC 83 EA 01 89 55 FC DD 45 CC DC 5D C0 DF E0 F6 C4 05 7B 8E 8B 45 FC 83 C0 01 39 45 F8 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 70 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 EB 47 8B 4D FC 83 E9 01 89 4D FC 8B 55 F8 3B 55 FC 77 08 8B 45 FC 3B 45 0C 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 75 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C6 33 C0 75 C2 E9 DC FE FF FF 8B 4D F8 3B 4D FC 0F 87 8B 00 00 00 8B 55 FC 3B 55 0C 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7B 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA 8B 45 F8 8B 4D 08 8B 14 81 DD 45 CC DC 5A 08 DF E0 F6 C4 05 7A 3D 8B 45 F8 8B 4D 08 8B 14 81 D9 E8 DC 62 08 DC 45 C0 DD 5D C0 8B 45 F8 8B 4D 08 8B 14 81 D9 EE DD 5A 08 8B 45 F8 8B 4D 08 8B 14 81 8B 42 04 83 C0 01 8B 4D F8 8B 55 08 8B 0C 8A 89 41 04 EB 02 EB 05 E9 29 FE FF FF DD 45 CC DC 5D C0 DF E0 F6 C4 01 75 0F DD 45 CC D9 E0 DC 5D C0 DF E0 F6 C4 41 7B 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 87 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 BA 33 C9 75 B6 C7 45 BC 00 00 00 00 C7 45 C8 00 00 00 00 EB 09 8B 55 C8 83 C2 01 89 55 C8 8B 45 C8 3B 45 0C 73 14 8B 4D C8 8B 55 08 8B 04 8A 8B 4D BC 03 48 04 89 4D BC EB DB 8B 55 BC 3B 55 10 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8F 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CE 33 D2 75 CA C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D 0C 73 79 8B 55 F0 89 55 E4 8B 45 F0 83 C0 01 89 45 E0 EB 09 8B 4D E0 83 C1 01 89 4D E0 8B 55 E0 3B 55 0C 73 20 8B 45 E0 8B 4D 08 8B 14 81 8B 45 E4 8B 4D 08 8B 04 81 8B 0A 3B 08 73 06 8B 55 E0 89 55 E4 EB CF 8B 45 F0 3B 45 E4 74 2A 8B 4D F0 8B 55 08 8B 04 8A 89 45 A8 8B 4D F0 8B 55 08 8B 45 E4 8B 75 08 8B 04 86 89 04 8A 8B 4D E4 8B 55 08 8B 45 A8 89 04 8A E9 76 FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_216_0 {
	meta:
		name = "?SafeInterlockedIncrement@details@Concurrency@@YA_NPCJ@Z"
		size = 49
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 89 4D FC 83 7D FC 00 75 04 32 C0 EB 17 8B 55 FC 83 C2 01 8B 4D 08 8B 45 FC F0 0F B1 11 3B 45 FC 75 D9 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_217_0 {
	meta:
		name = "?SafeReference@ResourceManager@details@Concurrency@@AAE_NXZ"
		size = 26
		refs = "000f ?SafeInterlockedIncrement@details@Concurrency@@YA_NPCJ@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_218_0 {
	meta:
		name = "?Scheduler@SchedulerProxy@details@Concurrency@@QBEPAUIScheduler@3@XZ"
		size = 17
		altNames = "?GetAnonymousScheduleGroupSegment@SchedulingRing@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ ?GetExecutionResourceTls@ThreadProxyFactoryManager@details@Concurrency@@QBEKXZ ?GetId@ContextBase@details@Concurrency@@UBEIXZ ?GetSchedulingRing@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVSchedulingRing@23@XZ ?GetThreadHandle@ThreadProxy@details@Concurrency@@QAEPAXXZ ?_GetId@location@Concurrency@@QBEIXZ ?_OwningCollection@_UnrealizedChore@details@Concurrency@@QBEPAV_TaskCollectionBase@23@XZ ?length@DNameStatusNode@@UBEHXZ ?length@pcharNode@@UBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_219_0 {
	meta:
		name = "?SchedulersNeedNotifications@ResourceManager@details@Concurrency@@QAE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 10 00 76 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_220_0 {
	meta:
		name = "?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 856
		refs = "008b ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 009f ?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z 00b0 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0181 ??_C@_1CI@KFAFICGD@?$AAp?$AAr?$AAe?$AAv?$AAi?$AAo?$AAu?$AAs?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0186 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0192 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0199 __CrtDbgReportW 01b5 ??_C@_1CG@IHEMMCHJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0212 ?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ 0263 ??_C@_1GM@FNLIPHMC@?$AAp?$AAr?$AAe?$AAv?$AAi?$AAo?$AAu?$AAs?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAp?$AAr?$AAe?$AAv?$AAi?$AAo?$AAu?$AAs?$AAL?$AAo?$AAc?$AAa?$AAl?$AA?5@ 029f ??_C@_1GG@KILALFEJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AA?5?$AA?$CG?$AA?$CG@ 02ef ?SendCoreNotification@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerCore@23@_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 44 89 4D FC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D FC 8B 55 F0 3B 51 18 0F 83 D9 00 00 00 C7 45 E8 00 00 00 00 EB 09 8B 45 E8 83 C0 01 89 45 E8 8B 4D F0 6B C9 28 8B 55 FC 8B 42 48 8B 55 E8 3B 54 08 04 0F 83 A9 00 00 00 8B 45 F0 6B C0 28 8B 4D FC 8B 51 48 8B 4D E8 6B C9 24 03 4C 02 20 89 4D E0 8B 55 E0 8B 45 E0 8B 48 14 89 4A 18 8B 55 E0 C7 42 14 00 00 00 00 8B 4D FC 83 C1 60 E8 ?? ?? ?? ?? 89 45 D0 EB 12 8B 45 D0 50 8B 4D FC 83 C1 60 E8 ?? ?? ?? ?? 89 45 D0 83 7D D0 00 74 4D 8B 4D D0 E8 ?? ?? ?? ?? 89 45 C0 8B 4D F0 6B C9 34 8B 55 E8 6B D2 34 8B 45 C0 03 54 08 30 89 55 E4 8B 4D E4 8B 55 E4 8B 42 1C 89 41 20 8B 4D E4 8B 51 18 8B 45 E4 89 50 1C 8B 4D E0 8B 51 14 8B 45 E4 03 50 1C 8B 4D E0 89 51 14 EB 9B E9 35 FF FF FF E9 0F FF FF FF C7 45 EC 00 00 00 00 EB 09 8B 55 EC 83 C2 01 89 55 EC 8B 45 FC 8B 4D EC 3B 48 18 0F 83 2E 02 00 00 C7 45 DC 00 00 00 00 EB 09 8B 55 DC 83 C2 01 89 55 DC 8B 45 EC 6B C0 28 8B 4D FC 8B 51 48 8B 4D DC 3B 4C 02 04 0F 83 FE 01 00 00 8B 55 EC 6B D2 28 8B 45 FC 8B 48 48 8B 45 DC 6B C0 24 03 44 11 20 89 45 C4 8B 4D C4 8B 51 18 89 55 CC 8B 45 C4 8B 48 14 89 4D D8 83 7D CC 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 95 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 83 7D D8 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 96 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 4D FC 83 C1 60 E8 ?? ?? ?? ?? 89 45 F8 EB 12 8B 55 F8 52 8B 4D FC 83 C1 60 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 0F 84 3A 01 00 00 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 84 22 01 00 00 8B 4D F8 E8 ?? ?? ?? ?? 89 45 BC 8B 4D EC 6B C9 34 8B 55 DC 6B D2 34 8B 45 BC 03 54 08 30 89 55 F4 8B 4D F4 8B 51 20 89 55 C8 8B 45 F4 8B 48 1C 89 4D D4 8B 55 CC 3B 55 C8 72 06 83 7D C8 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A1 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C8 33 D2 75 C4 8B 45 D8 3B 45 D4 72 06 83 7D D4 00 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A2 12 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 8B 4D F4 83 79 24 00 76 6E 8B 55 F8 3B 55 08 75 28 8B 45 D8 3B 45 D4 76 10 6A 01 8B 4D F4 51 8B 4D F8 E8 ?? ?? ?? ?? EB 0E 6A 00 8B 55 F4 52 8B 4D F8 E8 ?? ?? ?? ?? EB 3E 8B 45 CC 3B 45 C8 75 18 8B 4D D8 3B 4D D4 76 10 6A 01 8B 55 F4 52 8B 4D F8 E8 ?? ?? ?? ?? EB 1E 8B 45 D8 3B 45 D4 75 16 8B 4D CC 3B 4D C8 76 0E 6A 00 8B 55 F4 52 8B 4D F8 E8 ?? ?? ?? ?? E9 AA FE FF FF E9 E0 FD FF FF E9 BA FD FF FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_221_0 {
	meta:
		name = "?SetAllocatedNodes@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z"
		size = 83
		refs = "0017 ??_C@_1EM@JPGPHKHI@?$AAm?$AA_?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAN?$AAo?$AAd?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAN?$AAo?$AAd?$AAe?$AAs@ 001c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0028 ??_C@_1HA@HKMLDPPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002f __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 10 00 75 06 83 7D 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 FD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C7 33 C0 75 C3 8B 4D FC 8B 55 08 89 51 10 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_222_0 {
	meta:
		name = "?SetQueueLength@SchedulerProxy@details@Concurrency@@QAEXI@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 78 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_223_0 {
	meta:
		name = "?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z"
		size = 1348
		refs = "0006 __ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z 0018 ___security_cookie 002d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0042 ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 0050 ??0invalid_operation@Concurrency@@QAE@XZ 0055 __TI2?AVinvalid_operation@Concurrency@@ 0061 __CxxThrowException@8 0067 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 006f ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 00a1 ??_C@_05IOMEMJEC@count?$AA@ 00ac ??0invalid_argument@std@@QAE@PBD@Z 00b1 __TI3?AVinvalid_argument@std@@ 00c8 ??_C@_0P@CGIPNALJ@pGroupAffinity?$AA@ 0100 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0120 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0135 ??0HardwareAffinity@details@Concurrency@@QAE@XZ 0144 ??_H@YGXPAXIHP6EPAX0@Z@Z 01a8 ??0HardwareAffinity@details@Concurrency@@QAE@GK@Z 01b7 ??4HardwareAffinity@details@Concurrency@@QAEAAU012@ABU012@@Z 0209 ?GetGroup@HardwareAffinity@details@Concurrency@@QAEGXZ 028f ??0HardwareAffinity@details@Concurrency@@QAE@ABU012@@Z 02c5 ?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z 02cd ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 02dd ??_C@_1FE@PDPNLAE@?$AAp?$AAS?$AAy?$AAs?$AAI?$AAn?$AAf?$AAo?$AAE?$AAx?$AA?9?$AA?$DO?$AAR?$AAe?$AAl?$AAa?$AAt?$AAi?$AAo?$AAn?$AAs?$AAh?$AAi?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAR?$AAe?$AAl?$AAa@ 02e2 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 02ee ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 02f5 __CrtDbgReportW 03f6 ??_C@_1DK@DMIAEBAI@?$AAj?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAA?$AAf?$AAf?$AAi?$AAn?$AAi?$AAt?$AAy?$AA?$FL?$AAi?$AA?$FN?$AA?4?$AAG?$AAe?$AAt?$AAG?$AAr?$AAo?$AAu?$AAp?$AA?$CI?$AA?$CJ?$AA?$AA@ 043d ?IntersectWith@HardwareAffinity@details@Concurrency@@QAEXK@Z 044c ?GetMask@HardwareAffinity@details@Concurrency@@QAEKXZ 0483 ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ 0489 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 04a8 ??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z 04d7 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 04f8 ??0AffinityRestriction@ResourceManager@details@Concurrency@@QAE@GPAUHardwareAffinity@23@@Z 0526 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ 053c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC DC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 56 50 8D 45 F4 64 A3 00 00 00 00 68 ?? ?? ?? ?? 8D 4D 90 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 1C 8D 8D 18 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 18 FF FF FF 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 04 7D 1C 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 3C FF FF FF 51 E8 ?? ?? ?? ?? 0F B7 55 08 85 D2 75 21 68 ?? ?? ?? ?? 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 6C FF FF FF 50 E8 ?? ?? ?? ?? 83 7D 0C 00 75 21 68 ?? ?? ?? ?? 8D 8D 54 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 0F B7 55 08 89 55 A4 33 C0 88 45 C6 8D 4D C6 89 4D 88 68 5A 02 00 00 68 ?? ?? ?? ?? 8B 55 88 0F B6 02 50 33 C9 8B 45 A4 BA 0C 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 AC C6 45 FC 01 83 7D AC 00 74 1C 68 ?? ?? ?? ?? 8B 45 A4 50 6A 0C 8B 4D AC 51 E8 ?? ?? ?? ?? 8B 55 AC 89 55 94 EB 07 C7 45 94 00 00 00 00 8B 45 94 89 85 78 FF FF FF C6 45 FC 00 8B 8D 78 FF FF FF 89 4D CC C7 45 C0 00 00 00 00 EB 09 8B 55 C0 83 C2 01 89 55 C0 0F B7 45 08 39 45 C0 7D 35 8B 4D C0 6B C9 0C 8B 55 0C 8B 04 0A 50 8B 4D C0 6B C9 0C 8B 55 0C 0F B7 44 0A 04 50 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D C0 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? EB B9 C7 45 C8 00 00 00 00 EB 09 8B 4D C8 83 C1 01 89 4D C8 0F B7 55 08 39 55 C8 0F 83 E6 00 00 00 8B 45 C8 89 45 B8 8B 4D C8 83 C1 01 89 4D BC EB 09 8B 55 BC 83 C2 01 89 55 BC 0F B7 45 08 39 45 BC 73 7A 8B 4D BC 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 F0 8B 4D B8 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 C8 3B F1 75 23 68 ?? ?? ?? ?? 8D 8D 24 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 24 FF FF FF 52 E8 ?? ?? ?? ?? EB 2C 8B 4D BC 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 F0 8B 4D B8 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 C0 3B F0 7D 06 8B 4D BC 89 4D B8 E9 74 FF FF FF 8B 55 C8 3B 55 B8 74 3C 8B 45 C8 6B C0 0C 03 45 CC 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D B8 6B C9 0C 03 4D CC 51 8B 4D C8 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 8D 55 E4 52 8B 4D B8 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? E9 04 FF FF FF 6A 04 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? 89 45 A0 8B 4D A0 83 39 04 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA 8B 55 A0 83 C2 08 89 55 B4 0F B7 45 08 8B 4D B4 0F B7 51 02 3B C2 7E 21 68 ?? ?? ?? ?? 8D 8D 60 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 50 E8 ?? ?? ?? ?? C7 45 B0 00 00 00 00 33 C9 66 89 4D D4 33 D2 66 89 55 D0 EB 0C 66 8B 45 D4 66 83 C0 01 66 89 45 D4 0F B7 4D D4 0F B7 55 08 3B CA 0F 8D E7 00 00 00 0F B7 75 D0 0F B7 4D D4 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 C0 3B F0 7D 1D 0F B7 4D D0 8B 55 B4 0F B7 42 02 3B C8 7D 0E 66 8B 4D D0 66 83 C1 01 66 89 4D D0 EB C9 0F B7 55 D0 8B 45 B4 0F B7 48 02 3B D1 75 21 68 ?? ?? ?? ?? 8D 8D 48 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 48 FF FF FF 52 E8 ?? ?? ?? ?? 0F B7 75 D0 0F B7 4D D4 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 C0 3B F0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 97 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BC 33 C0 75 B8 0F B7 4D D0 6B C9 2C 8B 55 B4 8B 44 0A 40 50 0F B7 4D D4 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0F B7 4D D4 6B C9 0C 03 4D CC E8 ?? ?? ?? ?? 0B 45 B0 89 45 B0 E9 FD FE FF FF 83 7D B0 00 75 21 68 ?? ?? ?? ?? 8D 8D 30 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 95 7C FF FF FF 8B 85 7C FF FF FF 89 45 9C 83 7D 9C 00 74 0F 6A 01 8B 4D 9C E8 ?? ?? ?? ?? 89 45 80 EB 07 C7 45 80 00 00 00 00 33 C9 88 4D C7 8D 55 C7 89 55 84 68 A6 02 00 00 68 ?? ?? ?? ?? 8B 45 84 0F B6 08 51 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 98 C6 45 FC 02 83 7D 98 00 74 16 8B 55 CC 52 0F B7 45 08 50 8B 4D 98 E8 ?? ?? ?? ?? 89 45 A8 EB 07 C7 45 A8 00 00 00 00 8B 4D A8 89 4D 8C C6 45 FC 00 8B 55 8C 89 15 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D 90 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_225_0 {
	meta:
		name = "__unwindfunclet$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z$1"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 5A 02 00 00 68 ?? ?? ?? ?? 8B 45 88 0F B6 00 50 8B 45 AC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_226_0 {
	meta:
		name = "__unwindfunclet$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z$2"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 A6 02 00 00 68 ?? ?? ?? ?? 8B 45 84 0F B6 00 50 8B 45 98 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_227_0 {
	meta:
		name = "__ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 1C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_228_0 {
	meta:
		name = "?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
		size = 559
		refs = "0006 __ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z 0015 ___security_cookie 0029 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0031 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 003e ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 0049 ??0invalid_operation@Concurrency@@QAE@XZ 004e __TI2?AVinvalid_operation@Concurrency@@ 0057 __CxxThrowException@8 005d ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0065 ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 006b __imp__GetCurrentThread@0 0074 ??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z 0089 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0097 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00b3 ?GetGroup@HardwareAffinity@details@Concurrency@@QAEGXZ 00bf ??0HardwareAffinity@details@Concurrency@@QAE@GK@Z 00e0 ?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 00e5 ?s_systemAffinityMask@ResourceManager@details@Concurrency@@0KA 00ee ?IntersectWith@HardwareAffinity@details@Concurrency@@QAEXK@Z 00f6 ?GetMask@HardwareAffinity@details@Concurrency@@QAEKXZ 00ff ??_C@_0P@MBGDBGHG@dwAffinityMask?$AA@ 0107 ??0invalid_argument@std@@QAE@PBD@Z 010c __TI3?AVinvalid_argument@std@@ 0123 ?s_processAffinityMask@ResourceManager@details@Concurrency@@0KA 013e __imp__GetCurrentProcess@0 0145 __imp__SetProcessAffinityMask@8 014a ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0163 ??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z 01b0 ??0AffinityRestriction@ResourceManager@details@Concurrency@@QAE@GPAUHardwareAffinity@23@@Z 01d4 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0212 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ 0227 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 6C A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 68 ?? ?? ?? ?? 8D 4D B0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 16 8D 4D 94 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 94 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 33 C9 88 4D E2 8D 55 E2 89 55 A4 68 11 02 00 00 68 ?? ?? ?? ?? 8B 45 A4 0F B6 08 51 6A 0C E8 ?? ?? ?? ?? 83 C4 10 89 45 C4 C6 45 FC 01 83 7D C4 00 74 1D 8B 55 08 52 8D 4D E4 E8 ?? ?? ?? ?? 0F B7 C0 50 8B 4D C4 E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D C0 C6 45 FC 00 8B 55 C0 89 55 DC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B 4D DC E8 ?? ?? ?? ?? 8B 4D DC E8 ?? ?? ?? ?? 85 C0 75 1B 68 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D 88 51 E8 ?? ?? ?? ?? 8B 4D DC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? F7 D2 23 C2 74 1C 8B 4D DC E8 ?? ?? ?? ?? 0B 05 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 A8 8B 4D A8 89 4D D0 83 7D D0 00 74 0F 6A 01 8B 4D D0 E8 ?? ?? ?? ?? 89 45 B4 EB 07 C7 45 B4 00 00 00 00 33 D2 88 55 E3 8D 45 E3 89 45 A0 68 23 02 00 00 68 ?? ?? ?? ?? 8B 4D A0 0F B6 11 52 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 C8 C6 45 FC 02 83 7D C8 00 74 13 8B 45 DC 50 6A 01 8B 4D C8 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D AC C6 45 FC 00 8B 55 AC 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 BC 8B 4D BC 89 4D CC 83 7D CC 00 74 0F 6A 01 8B 4D CC E8 ?? ?? ?? ?? 89 45 B8 EB 07 C7 45 B8 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_230_0 {
	meta:
		name = "__unwindfunclet$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z$1"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 11 02 00 00 68 ?? ?? ?? ?? 8B 45 A4 0F B6 00 50 8B 45 C4 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_231_0 {
	meta:
		name = "__unwindfunclet$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z$2"
		size = 30
		refs = "0006 ??_C@_0DL@MEOGFKPI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 23 02 00 00 68 ?? ?? ?? ?? 8B 45 A0 0F B6 00 50 8B 45 C8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_41_232_0 {
	meta:
		name = "__ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 90 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_432_1 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 90 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_233_0 {
	meta:
		name = "?SetupStaticAllocationData@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@_N@Z"
		size = 346
		refs = "000d ?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ 0015 ?GetStaticAllocationData@SchedulerProxy@details@Concurrency@@QAEPAUStaticAllocationData@23@XZ 0025 _memset 003a ?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z 0042 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 008b ?First@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@XZ 009f ?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z 0127 ??_C@_1DC@POCEEKIJ@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAn?$AAu?$AAm?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?$AA@ 012c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0138 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 013f __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F4 6A 30 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 51 8B 55 08 52 6A 00 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E4 C7 45 E8 00 00 00 00 DF 6D E4 8B 45 F4 DD 58 20 8B 4D F4 8A 55 0C 88 51 28 B8 04 00 00 00 6B C0 00 8B 4D F8 8B 51 54 8B 4D F4 89 0C 10 C7 45 F0 01 00 00 00 C7 45 FC 00 00 00 00 8B 4D F8 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC EB 12 8B 55 FC 52 8B 4D F8 83 C1 60 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 6F 8B 45 FC 3B 45 08 74 62 8B 4D FC E8 ?? ?? ?? ?? 89 45 EC 6A 30 6A 00 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 EC 52 8B 45 FC 50 8B 4D F0 51 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 89 45 DC C7 45 E0 00 00 00 00 DF 6D DC 8B 55 EC DD 5A 20 8B 45 F8 8B 48 54 8B 55 F0 8B 45 EC 89 04 91 8B 4D F0 83 C1 01 89 4D F0 E9 79 FF FF FF 8B 55 F8 8B 45 F0 3B 42 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 63 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CB 33 C0 75 C7 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_41_234_0 {
	meta:
		name = "?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ"
		size = 52
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D FC 8B 90 84 00 00 00 3B 91 80 00 00 00 75 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_235_0 {
	meta:
		name = "?Shutdown@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 485
		refs = "0006 __ehhandler$?Shutdown@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0015 ___security_cookie 0037 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 004d ?Remove@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0055 ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00e0 ??_C@_1FE@EAAOFNLF@?$AA?$CK?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAU?$AAs?$AAe?$AAC?$AAo?$AAu@ 00e5 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00f1 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f8 __CrtDbgReportW 012e ?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ 016d ??_C@_1EM@HPCPHMHG@?$AAm?$AA_?$AAd?$AAy?$AAn?$AAa?$AAm?$AAi?$AAc?$AAR?$AAM?$AAW?$AAo?$AAr?$AAk?$AAe?$AAr?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAL?$AAo?$AAa?$AAd?$AAB?$AAa@ 01b3 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 01c3 ?WakeupDynamicRMWorker@ResourceManager@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C6 45 F3 00 8B 45 EC 83 C0 2C 50 8D 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D EC 83 C1 60 E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 89 45 D4 C7 45 E4 00 00 00 00 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 EC 8B 4D E4 3B 48 18 0F 83 AD 00 00 00 8B 55 E4 6B D2 34 03 55 D4 89 55 E0 8B 45 E0 83 78 1C 00 0F 86 8F 00 00 00 C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 E0 8B 45 E8 3B 42 04 73 72 8B 4D E8 6B C9 34 8B 55 E0 8B 42 30 83 3C 01 04 75 5B 8B 4D E8 6B C9 34 8B 55 E0 03 4A 30 89 4D DC 8B 45 DC 8B 48 14 83 39 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A3 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CB 33 C9 75 C7 8B 55 DC 8B 42 14 8B 08 83 E9 01 8B 55 DC 8B 42 14 89 08 E9 7A FF FF FF E9 3B FF FF FF 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 EC 8B 42 10 83 E8 01 8B 4D EC 89 41 10 8B 55 EC 8B 42 08 83 E8 01 89 45 D8 8B 4D EC 8B 55 D8 89 51 08 83 7D D8 01 75 45 8B 45 EC 83 78 28 01 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B1 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D EC C7 41 28 00 00 00 00 C6 45 F3 01 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 0F B6 55 F3 85 D2 74 08 8B 4D EC E8 ?? ?? ?? ?? 8B 45 08 8B 10 8B 4D 08 8B 42 20 FF D0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_238_0 {
	meta:
		name = "?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 140
		refs = "0006 __ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0015 ___security_cookie 003a ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z 0049 ?ReferenceCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@XZ 0062 ?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z 0074 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C7 45 F0 00 00 00 00 8B 45 EC 83 C0 2C 50 8D 4D E8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 75 13 6A 01 6A 00 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? 89 45 F0 C7 45 FC FF FF FF FF 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_241_0 {
	meta:
		name = "?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z"
		size = 392
		refs = "000b ?IsIdle@SchedulerCore@details@Concurrency@@QAE_NXZ 0043 ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 010a ??_C@_1GA@NKCGIAMM@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAc?$AAo?$AAr?$AAe?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAP?$AAr?$AAo?$AAc@ 010f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 011b ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0122 __CrtDbgReportW 0155 ??_C@_1HC@FLOJGPGI@?$AAp?$AAG?$AAl?$AAo?$AAb?$AAa?$AAl?$AAC?$AAo?$AAr?$AAe?$AA?9?$AA?$DO?$AAm?$AA_?$AAi?$AAd?$AAl?$AAe?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DM?$AA?$DN@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 84 95 00 00 00 8B 4D 0C C6 41 30 00 8B 55 18 8B 42 14 83 E8 01 8B 4D 18 89 41 14 8B 55 08 8B 42 28 83 E8 01 8B 4D 08 89 41 28 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 1E 8B 45 18 8B 48 18 83 E9 01 8B 55 18 89 4A 18 8B 45 08 8B 48 2C 83 E9 01 8B 55 08 89 4A 2C 8B 45 14 83 38 06 75 27 8B 4D 14 C7 01 00 00 00 00 8B 55 10 8B 42 1C 83 E8 01 8B 4D 10 89 41 1C 8B 55 FC 8B 42 20 83 E8 01 8B 4D FC 89 41 20 8B 55 14 8B 42 1C 83 E8 01 8B 4D 14 89 41 1C E9 D3 00 00 00 8B 55 0C C6 42 30 01 8B 45 18 8B 48 14 83 C1 01 8B 55 18 89 4A 14 8B 45 08 8B 48 28 83 C1 01 8B 55 08 89 4A 28 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1E 8B 4D 18 8B 51 18 83 C2 01 8B 45 18 89 50 18 8B 4D 08 8B 51 2C 83 C2 01 8B 45 08 89 50 2C 8B 4D 14 83 39 06 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 00 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CE 33 C9 75 CA 8B 55 14 8B 42 1C 83 C0 01 8B 4D 14 89 41 1C 8B 55 14 8B 45 14 8B 4A 1C 3B 48 10 76 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 03 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C8 33 C9 75 C4 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_41_242_0 {
	meta:
		name = "?ValidateBorrowedCores@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 273
		refs = "008d ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 00b6 ?IsBorrowed@SchedulerCore@details@Concurrency@@QAE_NXZ 00d1 ??_C@_1DG@BLHIIPFK@?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo?$AAw?$AAi?$AAn?$AAg?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAs?$AA?5?$AA?$DM?$AA?5?$AA2?$AA?$AA@ 00d6 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e2 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00e9 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D F8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 8B 55 FC 3B 51 18 0F 83 E3 00 00 00 C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 4D FC 6B C9 28 8B 55 F8 8B 42 48 8B 55 F0 3B 54 08 04 0F 83 B3 00 00 00 C7 45 EC 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F8 8B 55 F4 3B 51 08 0F 83 86 00 00 00 8B 45 F8 8B 48 54 8B 55 F4 8B 04 91 8B 48 10 E8 ?? ?? ?? ?? 89 45 E4 8B 4D FC 6B C9 34 8B 55 F0 6B D2 34 8B 45 E4 03 54 08 30 89 55 E8 8B 4D E8 83 39 04 75 4C 8B 4D E8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 3D 8B 45 EC 83 C0 01 89 45 EC 83 7D EC 02 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A7 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC E9 62 FF FF FF E9 2B FF FF FF E9 05 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_243_0 {
	meta:
		name = "?ValidateDRMSchedulerState@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 116
		refs = "0039 ??_C@_1GE@DJNLDNEC@?$AAm?$AA_?$AAp?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AAD?$AAa?$AAt?$AAa?$AA?$FL?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?$FN?$AA?9?$AA?$DO?$AAm?$AA_?$AAn?$AAu?$AAm?$AAB?$AAo?$AAr?$AAr?$AAo@ 003e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004a ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0051 __CrtDbgReportW 006c ?ValidateBorrowedCores@ResourceManager@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 8B 55 FC 3B 51 08 73 42 8B 45 F8 8B 48 54 8B 55 FC 8B 04 91 83 78 18 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8E 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 EB AA 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_244_0 {
	meta:
		name = "?ValidateStaticSchedulerState@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z"
		size = 198
		refs = "000d ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ 0089 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0093 ??_C@_1GK@OLFIDNHE@?$AAn?$AAu?$AAm?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAp?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9@ 0098 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00a4 ??_C@_1HG@EMGDAMJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ab __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D EC 8B 4D 08 E8 ?? ?? ?? ?? 89 45 E8 C7 45 F4 00 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D EC 8B 55 FC 3B 51 18 73 4D 8B 45 FC 6B C0 34 03 45 E8 89 45 F0 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F0 8B 45 F8 3B 42 04 73 22 8B 4D F8 6B C9 34 8B 55 F0 03 4A 30 89 4D E4 8B 45 E4 83 38 04 75 09 8B 4D F4 83 C1 01 89 4D F4 EB CA EB 9F 8B 4D 08 E8 ?? ?? ?? ?? 39 45 F4 73 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 81 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C9 33 C9 75 C5 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_246_0 {
	meta:
		name = "?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 113
		refs = "0006 __ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0013 ___security_cookie 0025 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 002d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 004a ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 0059 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 31 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_249_0 {
	meta:
		name = "?WakeupDynamicRMWorker@ResourceManager@details@Concurrency@@QAEXXZ"
		size = 24
		refs = "0010 __imp__SetEvent@4"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 50 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_251_0 {
	meta:
		name = "?_Release@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 E1 FE 8B 55 FC 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_252_0 {
	meta:
		name = "?set_task_execution_resources@Concurrency@@YAXGPAU_GROUP_AFFINITY@@@Z"
		size = 22
		refs = "000d ?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_544_2_0 {
	meta:
		name = "_putwc"
		size = 22
		refs = "000d _fputwc"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_41_254_0 {
	meta:
		name = "_HRESULT_FROM_WIN32"
		size = 49
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7F 08 8B 45 08 89 45 FC EB 18 8B 4D 08 81 E1 FF FF 00 00 81 C9 00 00 07 00 81 C9 00 00 00 80 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "__setenvp"
		size = 410
		refs = "0008 ___mbctype_initialized 0010 ___initmbctable 001c __aenvptr 0054 _strlen 006a ??_C@_0DB@BMEBJJKP@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 007a __calloc_dbg 0089 __environ 010e __free_dbg 012c ??_C@_1GC@DGBFLDBN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0131 ??_C@_1BC@GHMCNHHL@?$AA_?$AAs?$AAe?$AAt?$AAe?$AAn?$AAv?$AAp?$AA?$AA@ 0136 ??_C@_1DE@MMOGFGHF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAv?$AA?0?$AA?5?$AAc?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAp?$AA?$CJ?$AA?$AA@ 0149 _strcpy_s 0152 __invoke_watson_if_error 018c ___env_initialized"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? C7 45 F4 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 65 01 00 00 8B 4D FC 0F BE 11 85 D2 74 2C 8B 45 FC 0F BE 08 83 F9 3D 74 09 8B 55 F4 83 C2 01 89 55 F4 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC EB CA 6A 75 68 ?? ?? ?? ?? 6A 02 6A 04 8B 45 F4 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 8B 4D F8 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 F8 00 00 00 8B 15 ?? ?? ?? ?? 89 55 FC EB 09 8B 45 FC 03 45 F0 89 45 FC 8B 4D FC 0F BE 11 85 D2 0F 84 A7 00 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 8B 4D FC 0F BE 11 83 FA 3D 0F 84 81 00 00 00 6A 7E 68 ?? ?? ?? ?? 6A 02 6A 01 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D F8 89 01 8B 55 F8 83 3A 00 75 1F 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF EB 72 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D FC 51 8B 55 F0 52 8B 45 F8 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F8 83 C2 04 89 55 F8 E9 42 FF FF FF 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__CrtDbgReport"
		size = 65
		refs = "0029 __CrtDbgReportV"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 1C 89 45 FC 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 04 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_636_0_0 {
	meta:
		name = "?_CrtDbgReportW@@YAHHPBGH00ZZ"
		size = 65
		refs = "0029 __CrtDbgReportWV"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 1C 89 45 FC 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 04 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_636_1_0 {
	meta:
		name = "__CrtDbgReportW"
		size = 65
		refs = "0029 __CrtDbgReportWV"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 1C 89 45 FC 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 04 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "__CrtDbgReportV"
		size = 41
		refs = "0020 __VCrtDbgReportA"
	strings:
		$1 = { 55 8B EC 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_636_2_0 {
	meta:
		name = "__CrtDbgReportWV"
		size = 41
		refs = "0020 __VCrtDbgReportW"
	strings:
		$1 = { 55 8B EC 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "__CrtSetReportHook2"
		size = 838
		refs = "0006 __sehtable$__CrtSetReportHook2 000b __except_handler4 001d ___security_cookie 0059 ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 005e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0067 ??_C@_1GA@IBJGKIFE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006e __CrtDbgReportW 0082 __errno 0096 ??_C@_1CG@GNMJDMIO@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AA2?$AA?$AA@ 00a0 __invalid_parameter 00d2 ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 012b __lock 013b __pReportHookList 01d4 __free_dbg 01e2 ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 029f ??_C@_0DA@PCCBBBID@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 02a8 __malloc_dbg 0329 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 74 0F 83 7D 08 01 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 45 DC 89 45 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 85 02 00 00 83 7D 0C 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0C 02 00 00 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D E4 EB 09 8B 55 E4 8B 42 04 89 45 E4 83 7D E4 00 74 0F 8B 4D E4 8B 51 0C 3B 55 0C 75 02 EB 02 EB E2 83 7D 08 01 0F 85 B2 00 00 00 83 7D E4 00 74 6B 8B 45 E4 8B 48 08 83 E9 01 89 4D CC 8B 55 E4 8B 45 CC 89 42 08 8B 4D CC 89 4D E0 83 7D E0 00 75 48 8B 55 E4 83 7A 04 00 74 0D 8B 45 E4 8B 48 04 8B 55 E4 8B 02 89 01 8B 4D E4 83 39 00 74 10 8B 55 E4 8B 02 8B 4D E4 8B 51 04 89 50 04 EB 0C 8B 45 E4 8B 48 04 89 0D ?? ?? ?? ?? 6A 02 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 EB 3C 33 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 92 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 E0 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 FA 00 00 00 83 7D E4 00 74 75 8B 55 E4 8B 42 08 83 C0 01 89 45 C8 8B 4D E4 8B 55 C8 89 51 08 8B 45 C8 89 45 E0 8B 4D E4 3B 0D ?? ?? ?? ?? 74 4D 8B 55 E4 83 7A 04 00 74 0D 8B 45 E4 8B 48 04 8B 55 E4 8B 02 89 01 8B 4D E4 8B 11 8B 45 E4 8B 48 04 89 4A 04 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 04 8B 15 ?? ?? ?? ?? 8B 45 E4 89 02 8B 4D E4 89 0D ?? ?? ?? ?? EB 7F 68 AC 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 10 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 83 7D E4 00 75 14 C7 45 E0 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 4C 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 04 83 3D ?? ?? ?? ?? 00 74 0B 8B 15 ?? ?? ?? ?? 8B 45 E4 89 02 8B 4D E4 C7 41 08 01 00 00 00 C7 45 E0 01 00 00 00 8B 55 E4 8B 45 0C 89 42 0C 8B 4D E4 89 0D ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_636_3_0 {
	meta:
		name = "__CrtSetReportHookW2"
		size = 838
		refs = "0006 __sehtable$__CrtSetReportHookW2 000b __except_handler4 001d ___security_cookie 0059 ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 005e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0067 ??_C@_1GA@IBJGKIFE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006e __CrtDbgReportW 0082 __errno 0096 ??_C@_1CI@IIHEAKEI@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AAW?$AA2?$AA?$AA@ 00a0 __invalid_parameter 00d2 ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 012b __lock 013b __pReportHookListW 01d4 __free_dbg 01e2 ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 029f ??_C@_0DA@PCCBBBID@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 02a8 __malloc_dbg 0329 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 74 0F 83 7D 08 01 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 45 DC 89 45 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 85 02 00 00 83 7D 0C 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0C 02 00 00 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D E4 EB 09 8B 55 E4 8B 42 04 89 45 E4 83 7D E4 00 74 0F 8B 4D E4 8B 51 0C 3B 55 0C 75 02 EB 02 EB E2 83 7D 08 01 0F 85 B2 00 00 00 83 7D E4 00 74 6B 8B 45 E4 8B 48 08 83 E9 01 89 4D CC 8B 55 E4 8B 45 CC 89 42 08 8B 4D CC 89 4D E0 83 7D E0 00 75 48 8B 55 E4 83 7A 04 00 74 0D 8B 45 E4 8B 48 04 8B 55 E4 8B 02 89 01 8B 4D E4 83 39 00 74 10 8B 55 E4 8B 02 8B 4D E4 8B 51 04 89 50 04 EB 0C 8B 45 E4 8B 48 04 89 0D ?? ?? ?? ?? 6A 02 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 EB 3C 33 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 92 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 E0 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 FA 00 00 00 83 7D E4 00 74 75 8B 55 E4 8B 42 08 83 C0 01 89 45 C8 8B 4D E4 8B 55 C8 89 51 08 8B 45 C8 89 45 E0 8B 4D E4 3B 0D ?? ?? ?? ?? 74 4D 8B 55 E4 83 7A 04 00 74 0D 8B 45 E4 8B 48 04 8B 55 E4 8B 02 89 01 8B 4D E4 8B 11 8B 45 E4 8B 48 04 89 4A 04 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 04 8B 15 ?? ?? ?? ?? 8B 45 E4 89 02 8B 4D E4 89 0D ?? ?? ?? ?? EB 7F 68 AC 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 10 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 83 7D E4 00 75 14 C7 45 E0 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 4C 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 04 83 3D ?? ?? ?? ?? 00 74 0B 8B 15 ?? ?? ?? ?? 8B 45 E4 89 02 8B 4D E4 C7 41 08 01 00 00 00 C7 45 E0 01 00 00 00 8B 55 E4 8B 45 0C 89 42 0C 8B 4D E4 89 0D ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "___crtMessageWindowA"
		size = 1184
		refs = "0009 __chkstk 000e ___security_cookie 0054 __imp__GetModuleHandleExW@12 0086 ___report_rangecheckfailure 00ad __imp__GetModuleFileNameA@12 00bd ??_C@_1GA@IBJGKIFE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00c2 ??_C@_1CI@IDOKFLAJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AAW?$AAi?$AAn?$AAd?$AAo?$AAw?$AAA?$AA?$AA@ 00c7 ??_C@_1GG@DLDHOIGE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAE?$AAx?$AAe?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AA?$CC?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr@ 00cc ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 00dd _strcpy_s 00e6 __invoke_watson_if_error 0101 _strlen 013e ??_C@_1NO@LECLLHOL@?$AAm?$AAe?$AAm?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAS?$AAh?$AAo?$AAr?$AAt?$AAP?$AAr?$AAo?$AAg?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf@ 0145 _dotdotdot 0168 _memcpy_s 01a9 __errno 01cc ??_C@_1OG@PMPPFHAF@?$AA?6?$AA?6?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr@ 01d8 ??_C@_11LOCGONAA@?$AA?$AA@ 0200 ??_C@_00CNPNBAHC@?$AA@ 0223 ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 024c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 0283 ??_C@_1BA@GLLGCPCK@?$AA?6?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 02ba ??_C@_1BA@LNHECFIM@?$AA?6?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0317 ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 0333 ??_C@_1BE@CGCJKGHI@?$AA?6?$AAM?$AAo?$AAd?$AAu?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 039d __CrtDbgModeMsg 03a3 ??_C@_1LG@BEHAHJLI@?$AAD?$AAe?$AAb?$AAu?$AAg?$AA?5?$AA?$CF?$AAs?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$CF?$AAh?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAh?$AAs?$AA?$CF?$AAs@ 03b9 __snwprintf_s 03e1 ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 03f2 __invoke_watson_if_oneof 0421 ??_C@_1JI@EACPGHID@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC?$AA_@ 0426 ??_C@_1FG@BBOLDHGF@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0437 _wcscpy_s 044d ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0459 ___crtMessageBoxW 0472 _raise 047c __exit 0498 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC B8 58 21 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 EC DE FF FF 00 00 00 00 C7 85 E4 DE FF FF 00 00 00 00 C7 85 E8 DE FF FF 00 00 00 00 83 7D 1C 00 75 0A B8 01 00 00 00 E9 4D 04 00 00 8D 85 E8 DE FF FF 50 8B 4D 0C 51 6A 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A C7 85 E8 DE FF FF 00 00 00 00 BA 01 00 00 00 69 D2 04 01 00 00 89 95 CC DE FF FF 81 BD CC DE FF FF 05 01 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 8B 85 CC DE FF FF C6 84 05 F4 FE FF FF 00 68 04 01 00 00 8D 8D F4 FE FF FF 51 8B 95 E8 DE FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 75 38 6A 00 68 5F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8D 85 F4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 8D F4 FE FF FF 89 8D F0 DE FF FF 8B 95 F0 DE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 40 76 6B 8B 85 F0 DE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D F0 DE FF FF 8D 54 01 C0 89 95 F0 DE FF FF 6A 00 68 68 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 03 A1 ?? ?? ?? ?? 50 8B 8D F0 DE FF FF 8D 95 F4 FE FF FF 2B CA B8 04 01 00 00 2B C1 50 8B 8D F0 DE FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 18 00 74 2A 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 40 76 19 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 18 8D 54 01 C3 89 95 EC DE FF FF E8 ?? ?? ?? ?? 8B 00 89 85 A8 DE FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 7D 08 02 75 0C C7 85 B0 DE FF FF ?? ?? ?? ?? EB 0A C7 85 B0 DE FF FF ?? ?? ?? ?? B9 01 00 00 00 6B C9 00 8B 55 1C 0F BE 04 0A 85 C0 74 0B 8B 4D 1C 89 8D B4 DE FF FF EB 0A C7 85 B4 DE FF FF ?? ?? ?? ?? BA 01 00 00 00 6B D2 00 8B 45 1C 0F BE 0C 10 85 C9 74 12 83 7D 08 02 75 0C C7 85 D4 DE FF FF ?? ?? ?? ?? EB 0A C7 85 D4 DE FF FF ?? ?? ?? ?? BA 01 00 00 00 6B D2 00 8B 45 1C 0F BE 0C 10 85 C9 74 0C C7 85 BC DE FF FF ?? ?? ?? ?? EB 0A C7 85 BC DE FF FF ?? ?? ?? ?? 83 7D 14 00 74 0B 8B 55 14 89 95 E0 DE FF FF EB 0A C7 85 E0 DE FF FF ?? ?? ?? ?? 83 7D 14 00 74 0C C7 85 B8 DE FF FF ?? ?? ?? ?? EB 0A C7 85 B8 DE FF FF ?? ?? ?? ?? 83 7D 10 00 74 0B 8B 45 10 89 85 C4 DE FF FF EB 0A C7 85 C4 DE FF FF ?? ?? ?? ?? 83 7D 10 00 74 0C C7 85 DC DE FF FF ?? ?? ?? ?? EB 0A C7 85 DC DE FF FF ?? ?? ?? ?? 83 BD EC DE FF FF 00 74 0E 8B 8D EC DE FF FF 89 8D D8 DE FF FF EB 27 83 7D 18 00 74 0B 8B 55 18 89 95 AC DE FF FF EB 0A C7 85 AC DE FF FF ?? ?? ?? ?? 8B 85 AC DE FF FF 89 85 D8 DE FF FF 83 BD EC DE FF FF 00 74 0C C7 85 D0 DE FF FF ?? ?? ?? ?? EB 0A C7 85 D0 DE FF FF ?? ?? ?? ?? 83 7D 18 00 74 0C C7 85 C8 DE FF FF ?? ?? ?? ?? EB 0A C7 85 C8 DE FF FF ?? ?? ?? ?? 8B 8D B0 DE FF FF 51 8B 95 B4 DE FF FF 52 8B 85 D4 DE FF FF 50 8B 8D BC DE FF FF 51 8B 95 E0 DE FF FF 52 8B 85 B8 DE FF FF 50 8B 8D C4 DE FF FF 51 8B 95 DC DE FF FF 52 8B 85 D8 DE FF FF 50 8B 8D D0 DE FF FF 51 8B 95 C8 DE FF FF 52 8B 85 F0 DE FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 68 FF 0F 00 00 68 00 10 00 00 8D 85 F4 DE FF FF 50 E8 ?? ?? ?? ?? 83 C4 44 89 85 E4 DE FF FF 83 BD E4 DE FF FF 00 7D 2A 6A 00 68 7F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 95 A8 DE FF FF 89 10 83 BD E4 DE FF FF 00 7D 38 6A 00 68 82 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 F4 DE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 68 12 20 01 00 68 ?? ?? ?? ?? 8D 8D F4 DE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 C0 DE FF FF 83 BD C0 DE FF FF 03 75 11 6A 16 E8 ?? ?? ?? ?? 83 C4 04 6A 03 E8 ?? ?? ?? ?? 83 BD C0 DE FF FF 04 75 07 B8 01 00 00 00 EB 02 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_3_0 {
	meta:
		name = "__mblen_l"
		size = 369
		refs = "002b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0033 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0050 ??_C@_1NC@EINCOKCO@?$AA_?$AAl?$AAo?$AAc?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi?$AAn?$AAf@ 0055 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005e ??_C@_1FO@DGDAMKHF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0065 __CrtDbgReportW 0083 __isleadbyte_l 00dc __imp__MultiByteToWideChar@24 00ef ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 7D 08 00 74 10 8B 45 08 0F BE 08 85 C9 74 06 83 7D 0C 00 75 07 33 C0 E9 4A 01 00 00 8B 55 10 52 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 83 78 74 01 74 33 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 83 79 74 02 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 45 08 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 87 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 10 83 7A 74 01 7E 42 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 8B 4D 0C 3B 48 74 7C 30 6A 00 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 10 8B 42 74 50 8B 4D 08 51 6A 09 8D 4D E0 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 16 C7 45 FC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 FC EB 75 EB 1D 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 51 74 89 55 F8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 F8 EB 56 EB 4C 6A 00 6A 00 6A 01 8B 45 08 50 6A 09 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 85 C0 75 14 C7 45 F4 FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 F4 EB 1C C7 45 F0 01 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 F0 EB 08 8D 4D E0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "_mblen"
		size = 57
		refs = "0005 ___locale_changed 000d ___initiallocalestructinfo 001a __mblen_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 19 68 ?? ?? ?? ?? 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C EB 14 EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "___avx_atan2f8"
		size = 560
		refs = "0010 ___common_satan2_data 0220 ___common_satan2_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FC 10 3D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 FC 11 44 24 20 C5 FC 11 4C 24 60 C5 F4 54 D7 C5 FC 54 F7 C5 FC 11 54 24 40 C5 FC 11 B4 24 80 00 00 00 C4 E3 7D 19 F5 01 C4 E3 7D 19 D3 01 C5 E9 FA D4 C5 E1 FA FC C5 C9 FA DC C5 D1 FA F4 C5 F8 10 2D ?? ?? ?? ?? C5 E9 66 E5 C5 E9 76 D5 C5 D9 EB E2 C5 E1 66 D5 C5 E1 76 DD C5 E9 EB D3 C5 D9 EB DA C5 C1 66 E5 C5 C1 76 FD C5 D9 EB D7 C5 C9 66 FD C5 C9 76 ED C5 C1 EB FD C5 C9 EF F6 C5 E9 EB D7 C5 E1 6B DA C5 E1 63 E6 C5 F9 D7 D4 C5 FC 10 25 ?? ?? ?? ?? C5 FC 10 1D ?? ?? ?? ?? C5 FC 10 B4 24 80 00 00 00 C5 FC 54 C4 C5 FC 56 FB C5 FC 11 BC 24 A0 00 00 00 C5 FC 10 7C 24 40 C5 F4 54 EC C5 D4 56 D3 C5 C4 C2 EE 11 C5 F4 C2 0D ?? ?? ?? ?? 11 C5 D4 54 C7 C5 D4 55 DE C5 D4 54 F6 C5 D4 55 FF C5 FC 56 DB C5 CC 56 F7 C5 E4 5E C6 C5 D4 54 E4 C5 FC 56 FC C5 C4 59 F7 C5 D4 54 1D ?? ?? ?? ?? C5 CC 59 EE C5 D4 59 25 ?? ?? ?? ?? C5 DC 58 05 ?? ?? ?? ?? C5 D4 59 25 ?? ?? ?? ?? C5 FC 59 C5 C5 DC 58 25 ?? ?? ?? ?? C5 FC 58 05 ?? ?? ?? ?? C5 DC 59 E5 C5 FC 59 C5 C5 DC 58 25 ?? ?? ?? ?? C5 FC 58 05 ?? ?? ?? ?? C5 DC 59 E5 C5 FC 59 ED C5 DC 58 25 ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 DC 59 E6 C5 DC 58 E8 C5 D4 59 F7 C5 CC 58 DB C5 E4 59 D2 C5 F4 54 0D ?? ?? ?? ?? C5 EC 58 C9 0F B6 C2 C5 F4 59 84 24 A0 00 00 00 85 C0 75 04 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 10 54 24 60 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 C5 FC 11 94 24 80 00 00 00 85 D2 74 D4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB AA C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "??0DName@@QAE@AAPBDD@Z"
		size = 700
		refs = "01d2 ?doNoIdentCharCheck@UnDecorator@@SAHXZ 0210 ?doPchar@DName@@AAEXPBDH@Z 026b ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FE FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FD FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FB FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF F7 FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 8B 4D 08 83 39 00 0F 84 DF 01 00 00 8B 55 08 8B 02 0F BE 08 85 C9 0F 84 B9 01 00 00 C7 45 F8 00 00 00 00 8B 55 08 8B 02 89 45 F4 EB 0D 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 8B 4D 08 8B 11 0F BE 02 85 C0 0F 84 06 01 00 00 8B 4D 08 8B 11 0F BE 02 0F BE 4D 0C 3B C1 0F 84 F2 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 5F 0F 84 B7 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 24 0F 84 A6 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 3C 0F 84 95 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 3E 0F 84 84 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 2D 74 77 8B 55 08 8B 02 0F BE 08 83 F9 61 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 7A 7E 5D 8B 55 08 8B 02 0F BE 08 83 F9 41 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 5A 7E 43 8B 55 08 8B 02 0F BE 08 83 F9 30 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 39 7E 29 8B 55 08 8B 02 0F B6 08 81 F9 80 00 00 00 7C 10 8B 55 08 8B 02 0F B6 08 81 F9 FE 00 00 00 7E 09 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 55 F8 83 C2 01 89 55 F8 EB 1A 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 83 C9 02 8B 55 FC 89 4A 04 E9 B4 00 00 00 E9 DD FE FF FF 8B 45 F8 50 8B 4D F4 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 8B 02 0F BE 08 85 C9 74 47 8B 55 08 8B 02 0F BE 08 89 4D F0 0F BE 55 0C 89 55 EC 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A 8B 45 F0 3B 45 EC 74 1E 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 83 CA 03 8B 45 FC 89 50 04 8B 4D FC C7 01 00 00 00 00 EB 20 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 14 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 01 8B 4D FC 89 41 04 EB 14 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 01 8B 4D FC 89 41 04 EB 14 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 02 8B 4D FC 89 41 04 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_2_0 {
	meta:
		name = "??0DName@@QAE@ABV0@@Z"
		size = 32
		altNames = "??4DName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 8B 11 89 10 8B 49 04 89 48 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "??0DName@@QAE@D@Z"
		size = 209
		refs = "00c4 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FE FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FD FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FB FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF F7 FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 0F BE 4D 08 85 C9 74 0E 6A 01 8D 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "??0DName@@QAE@PAV0@@Z"
		size = 306
		refs = "0012 _heap 0019 ??2@YAPAXIAAV_HeapManager@@H@Z 0031 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 83 7D 08 00 74 70 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D FC 8B 55 F4 89 11 8B 45 FC 83 38 00 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 03 00 00 00 8B 4D F0 81 E1 FF 00 00 00 8B 55 FC 8B 42 04 25 00 FF FF FF 0B C1 8B 4D FC 89 41 04 EB 1A 8B 55 FC 8B 42 04 25 00 FF FF FF 8B 4D FC 89 41 04 8B 55 FC C7 02 00 00 00 00 8B 45 FC 8B 48 04 81 E1 FF FE FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FD FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FB FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF F7 FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF EF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF DF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF BF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF 7F FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "??0DName@@QAE@PBD@Z"
		size = 232
		refs = "00bf ?und_strlen@@YAIPBD@Z 00db ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF FE FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FD FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FB FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF F7 FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 83 7D 08 00 74 25 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 76 10 8B 55 F8 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_6_0 {
	meta:
		name = "??0DName@@QAE@W4DNameStatus@@@Z"
		size = 278
		refs = "00e4 ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 81 E1 FF FE FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FD FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FB FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF F7 FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF EF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF DF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF BF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF 7F FF FF 8B 55 FC 89 4A 04 83 7D 08 02 74 0F 83 7D 08 03 74 09 C7 45 F8 00 00 00 00 EB 06 8B 45 08 89 45 F8 8B 4D F8 81 E1 FF 00 00 00 8B 55 FC 8B 42 04 25 00 FF FF FF 0B C1 8B 4D FC 89 41 04 8B 55 FC C7 02 00 00 00 00 83 7D 08 01 75 2E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 89 01 8B 55 FC 83 3A 00 75 15 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 83 C9 03 8B 55 FC 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_7_0 {
	meta:
		name = "??0DName@@QAE@XZ"
		size = 185
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FE FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FD FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FB FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF F7 FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_8_0 {
	meta:
		name = "??0DName@@QAE@_J@Z"
		size = 373
		refs = "0007 ___security_cookie 0101 __aullrem 011d __aulldiv 015e ?doPchar@DName@@AAEXPBDH@Z 016b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 4D E0 8D 45 F9 89 45 D8 8B 4D E0 8B 51 04 81 E2 00 FF FF FF 8B 45 E0 89 50 04 8B 4D E0 C7 01 00 00 00 00 8B 55 E0 8B 42 04 25 FF FE FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF FD FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF FB FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF F7 FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF EF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF DF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF BF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF 7F FF FF 8B 4D E0 89 41 04 8B 55 D8 C6 02 00 C6 45 DF 00 83 7D 0C 00 7F 1F 7C 06 83 7D 08 00 73 17 C6 45 DF 01 8B 45 08 F7 D8 8B 4D 0C 83 D1 00 F7 D9 89 45 08 89 4D 0C 8B 55 D8 83 EA 01 89 55 D8 6A 00 6A 0A 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C0 30 83 D2 00 8B 55 D8 88 02 6A 00 6A 0A 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 8B 55 08 0B 55 0C 75 BC 0F B6 45 DF 85 C0 74 0F 8B 4D D8 83 E9 01 89 4D D8 8B 55 D8 C6 02 2D 8B 45 D8 8D 4D E4 2B C1 BA 15 00 00 00 2B D0 52 8B 45 D8 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_9_0 {
	meta:
		name = "??0DName@@QAE@_K@Z"
		size = 309
		refs = "0007 ___security_cookie 00d8 __aullrem 00f4 __aulldiv 011e ?doPchar@DName@@AAEXPBDH@Z 012b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 4D E0 8D 45 F8 89 45 DC 8B 4D E0 8B 51 04 81 E2 00 FF FF FF 8B 45 E0 89 50 04 8B 4D E0 C7 01 00 00 00 00 8B 55 E0 8B 42 04 25 FF FE FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF FD FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF FB FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF F7 FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF EF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF DF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF BF FF FF 8B 4D E0 89 41 04 8B 55 E0 8B 42 04 25 FF 7F FF FF 8B 4D E0 89 41 04 8B 55 DC C6 02 00 8B 45 DC 83 E8 01 89 45 DC 6A 00 6A 0A 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C0 30 83 D2 00 8B 4D DC 88 01 6A 00 6A 0A 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 8B 4D 08 0B 4D 0C 75 BC 8B 55 DC 8D 45 E4 2B D0 B9 14 00 00 00 2B CA 51 8B 55 DC 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_11_0 {
	meta:
		name = "??0DNameStatusNode@@AAE@W4DNameStatus@@@Z"
		size = 78
		refs = "000d ??0DNameNode@@IAE@XZ 0016 ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 04 8B 45 FC 83 78 04 01 75 09 C7 45 F8 04 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D FC 8B 55 F8 89 51 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_12_0 {
	meta:
		name = "??0Replicator@@QAE@XZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_13_0 {
	meta:
		name = "??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z"
		size = 145
		refs = "000b ??0Replicator@@QAE@XZ 001e ?name@UnDecorator@@0PBDB 002a ?gName@UnDecorator@@0PBDB 0039 ?maxStringLength@UnDecorator@@0HA 0041 ?outputString@UnDecorator@@0PADA 0063 ?pZNameList@UnDecorator@@0PAVReplicator@@A 006c ?pArgList@UnDecorator@@0PAVReplicator@@A 0074 ?disableFlags@UnDecorator@@0KA 007d ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0083 ?fExplicitTemplateParams@UnDecorator@@0_NA"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 2C E8 ?? ?? ?? ?? 8B 45 0C A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 83 7D 08 00 74 13 8B 55 10 89 15 ?? ?? ?? ?? 8B 45 08 A3 ?? ?? ?? ?? EB 14 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 4D FC 83 C1 2C 89 0D ?? ?? ?? ?? 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 8B 4D 14 89 0D ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 8B 45 FC 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_52_14_0 {
	meta:
		name = "??0charNode@@QAE@D@Z"
		size = 42
		refs = "000b ??0DNameNode@@IAE@XZ 0014 ??_7charNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8A 55 08 88 51 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_15_0 {
	meta:
		name = "??0pDNameNode@@QAE@PAVDName@@@Z"
		size = 91
		refs = "000d ??0DNameNode@@IAE@XZ 0016 ??_7pDNameNode@@6B@ 0024 ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 83 7D 08 00 74 23 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 02 74 0D 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 03 75 09 C7 45 F8 00 00 00 00 EB 06 8B 4D 08 89 4D F8 8B 55 FC 8B 45 F8 89 42 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_16_0 {
	meta:
		name = "??0pairNode@@QAE@PAVDNameNode@@0@Z"
		size = 61
		refs = "000b ??0DNameNode@@IAE@XZ 0014 ??_7pairNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 04 8B 45 FC 8B 4D 0C 89 48 08 8B 55 FC C7 42 0C FF FF FF FF 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_17_0 {
	meta:
		name = "??0pcharNode@@QAE@PBDH@Z"
		size = 153
		refs = "000d ??0DNameNode@@IAE@XZ 0016 ??_7pcharNode@@6B@ 0029 _heap 0032 ??2@YAPAXIAAV_HeapManager@@H@Z 0067 ?und_memcpy@@YAXPADPBDI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 83 7D 0C 00 74 5C 83 7D 08 00 74 56 6A 00 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 8B 55 FC 8B 45 F8 89 42 04 8B 4D FC 8B 55 0C 89 51 08 8B 45 FC 83 78 04 00 74 19 8B 4D 0C 51 8B 55 08 52 8B 45 FC 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 0C EB 0A 8B 55 FC C7 42 08 00 00 00 00 EB 14 8B 45 FC C7 40 04 00 00 00 00 8B 4D FC C7 41 08 00 00 00 00 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_18_0 {
	meta:
		name = "??2@YAPAXIAAV_HeapManager@@H@Z"
		size = 23
		refs = "000c _heap 0011 ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 08 51 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_52_20_0 {
	meta:
		name = "??4DName@@QAEAAV0@D@Z"
		size = 209
		refs = "00c4 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF FE FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FD FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FB FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF F7 FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 0F BE 4D 08 85 C9 74 0E 6A 01 8D 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_21_0 {
	meta:
		name = "??4DName@@QAEAAV0@PAV0@@Z"
		size = 303
		refs = "00bd _heap 00c4 ??2@YAPAXIAAV_HeapManager@@H@Z 00dc ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF FE FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FD FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FB FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF F7 FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 83 7D 08 00 74 58 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 55 FC 8B 45 F4 89 02 8B 4D FC 83 39 00 75 14 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 03 8B 4D FC 89 41 04 EB 14 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 03 8B 4D FC 89 41 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_22_0 {
	meta:
		name = "??4DName@@QAEAAV0@PBD@Z"
		size = 212
		refs = "00b7 ?und_strlen@@YAIPBD@Z 00c7 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 81 E2 FF FE FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FD FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF FB FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF F7 FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF EF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF DF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF BF FF FF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 81 E2 FF 7F FF FF 8B 45 FC 89 50 04 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_23_0 {
	meta:
		name = "??4DName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 251
		refs = "00be ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 81 E1 FF FE FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FD FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF FB FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF F7 FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF EF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF DF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF BF FF FF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 81 E1 FF 7F FF FF 8B 55 FC 89 4A 04 8B 45 08 25 FF 00 00 00 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 0B D0 8B 45 FC 89 50 04 83 7D 08 01 75 30 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 89 02 8B 45 FC 83 38 00 75 15 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 83 CA 03 8B 45 FC 89 50 04 EB 09 8B 4D FC C7 01 00 00 00 00 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_24_0 {
	meta:
		name = "??AReplicator@@QBE?AVDName@@H@Z"
		size = 99
		refs = "0019 ??0DName@@QAE@W4DNameStatus@@@Z 0056 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 0C 00 7C 06 83 7D 0C 09 7E 11 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 3B EB 39 8B 45 FC 83 38 FF 74 0A 8B 4D FC 8B 55 0C 3B 11 7E 11 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 18 EB 16 8B 45 0C 8B 4D FC 8B 54 81 04 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_25_0 {
	meta:
		name = "??BUnDecorator@@QAEPADXZ"
		size = 652
		refs = "000d ??0DName@@QAE@XZ 001b ?name@UnDecorator@@0PBDB 004b ?gName@UnDecorator@@0PBDB 005d ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0066 ??_C@_04HEJADOOB@CV?3?5?$AA@ 006f ??H@YA?AVDName@@PBDABV0@@Z 007b ??4DName@@QAEAAV0@ABV0@@Z 00b0 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 00c4 ?status@DName@@QBE?AW4DNameStatus@@XZ 013a ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0179 ?doNameOnly@UnDecorator@@SAHXZ 0199 ??4DName@@QAEAAV0@PBD@Z 01ad ?outputString@UnDecorator@@0PADA 01b8 ?length@DName@@QBEHXZ 01c0 ?maxStringLength@UnDecorator@@0HA 01c7 _heap 01d2 ??2@YAPAXIAAV_HeapManager@@H@Z 0203 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 48 89 4D F0 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 84 2F 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 75 51 BA 01 00 00 00 C1 E2 00 A1 ?? ?? ?? ?? 0F BE 0C 10 83 F9 40 75 3B 8B 15 ?? ?? ?? ?? 83 C2 02 89 15 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 04 50 68 ?? ?? ?? ?? 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? E9 D1 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 3F 75 5E B9 01 00 00 00 C1 E1 00 8B 15 ?? ?? ?? ?? 0F BE 04 0A 83 F8 24 75 47 6A 00 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 83 F8 02 75 21 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? EB 65 B9 01 00 00 00 6B C9 00 8B 15 ?? ?? ?? ?? 0F BE 04 0A 83 F8 3F 75 39 B9 01 00 00 00 C1 E1 00 8B 15 ?? ?? ?? ?? 0F BE 04 0A 83 F8 3F 75 22 B9 01 00 00 00 D1 E1 8B 15 ?? ?? ?? ?? 0F BE 04 0A 83 F8 40 75 0C 6A 02 8D 4D E8 E8 ?? ?? ?? ?? EB 15 8D 4D B8 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 83 F8 03 75 09 33 C0 E9 1F 01 00 00 EB 40 8D 4D E8 E8 ?? ?? ?? ?? 83 F8 02 74 16 E8 ?? ?? ?? ?? 85 C0 75 1E 8B 15 ?? ?? ?? ?? 0F BE 02 85 C0 74 11 8B 0D ?? ?? ?? ?? 51 8D 4D E0 E8 ?? ?? ?? ?? EB 0C 8D 55 E8 52 8D 4D E0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 31 8D 4D E0 E8 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 4D F4 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 84 91 00 00 00 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 FC 89 55 F8 8B 45 FC 0F BE 08 85 C9 74 59 8B 55 FC 0F BE 02 83 F8 20 75 30 8B 4D FC 83 C1 01 89 4D FC 8B 55 F8 C6 02 20 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 0F BE 11 83 FA 20 75 0B 8B 45 FC 83 C0 01 89 45 FC EB EA EB 1C 8B 4D F8 8B 55 FC 8A 02 88 01 8B 4D F8 83 C1 01 89 4D F8 8B 55 FC 83 C2 01 89 55 FC EB 9D 8B 45 F8 8B 4D FC 8A 11 88 10 A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_26_0 {
	meta:
		name = "??H@YA?AVDName@@DABV0@@Z"
		size = 41
		refs = "0017 ??0DName@@QAE@D@Z 001e ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 10 50 8B 4D 08 51 0F B6 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_27_0 {
	meta:
		name = "??H@YA?AVDName@@PBDABV0@@Z"
		size = 40
		refs = "0016 ??0DName@@QAE@PBD@Z 001d ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 10 50 8B 4D 08 51 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_28_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
		size = 40
		refs = "0016 ??0DName@@QAE@W4DNameStatus@@@Z 001d ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 10 50 8B 4D 08 51 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_29_0 {
	meta:
		name = "??HDName@@QBE?AV0@ABV0@@Z"
		size = 54
		refs = "0011 ??0DName@@QAE@ABV0@@Z 001d ??YDName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_31_0 {
	meta:
		name = "??HDName@@QBE?AV0@PAV0@@Z"
		size = 54
		refs = "0011 ??0DName@@QAE@ABV0@@Z 001d ??YDName@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_32_0 {
	meta:
		name = "??HDName@@QBE?AV0@PBD@Z"
		size = 54
		refs = "0011 ??0DName@@QAE@ABV0@@Z 001d ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_33_0 {
	meta:
		name = "??HDName@@QBE?AV0@W4DNameStatus@@@Z"
		size = 54
		refs = "0011 ??0DName@@QAE@ABV0@@Z 001d ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_30_0 {
	meta:
		name = "??HDName@@QBE?AV0@D@Z"
		size = 55
		refs = "0011 ??0DName@@QAE@ABV0@@Z 001e ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 50 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_34_0 {
	meta:
		name = "??YDName@@QAEAAV0@ABV0@@Z"
		size = 99
		refs = "000b ?isValid@DName@@QBEHXZ 0017 ?isEmpty@DName@@QBEHXZ 0023 ?status@DName@@QBE?AW4DNameStatus@@XZ 002c ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0046 ??4DName@@QAEAAV0@ABV0@@Z 0056 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 47 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 13 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? EB 28 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0E 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? EB 0E 8B 4D 08 8B 11 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_35_0 {
	meta:
		name = "??YDName@@QAEAAV0@D@Z"
		size = 128
		refs = "000d ?isValid@DName@@QBEHXZ 0021 ?isEmpty@DName@@QBEHXZ 0032 ??4DName@@QAEAAV0@D@Z 003b _heap 0042 ??2@YAPAXIAAV_HeapManager@@H@Z 005b ??0charNode@@QAE@D@Z 0073 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 62 0F BE 45 08 85 C0 74 5A 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0F 0F B6 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? EB 3F 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 12 0F B6 55 08 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_36_0 {
	meta:
		name = "??YDName@@QAEAAV0@PAV0@@Z"
		size = 176
		refs = "000d ?isValid@DName@@QBEHXZ 0027 ?isEmpty@DName@@QBEHXZ 0037 ??4DName@@QAEAAV0@PAV0@@Z 0041 ?status@DName@@QBE?AW4DNameStatus@@XZ 0059 _heap 0060 ??2@YAPAXIAAV_HeapManager@@H@Z 0078 ??0pDNameNode@@QAE@PAVDName@@@Z 0090 ?append@DName@@AAEXPAVDNameNode@@@Z 00a3 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 0F 84 8E 00 00 00 83 7D 08 00 0F 84 84 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0E 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? EB 6A 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 0D 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 01 75 40 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 52 8B 4D FC E8 ?? ?? ?? ?? EB 11 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_37_0 {
	meta:
		name = "??YDName@@QAEAAV0@PBD@Z"
		size = 147
		refs = "000d ?isValid@DName@@QBEHXZ 0029 ?isEmpty@DName@@QBEHXZ 0039 ??4DName@@QAEAAV0@PBD@Z 0042 _heap 0049 ??2@YAPAXIAAV_HeapManager@@H@Z 005e ?und_strlen@@YAIPBD@Z 006e ??0pcharNode@@QAE@PBDH@Z 0086 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 75 83 7D 08 00 74 6F 8B 45 08 0F BE 08 85 C9 74 65 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0E 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? EB 4B 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 1E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_38_0 {
	meta:
		name = "??YDName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 95
		refs = "000b ?isValid@DName@@QBEHXZ 0017 ?isEmpty@DName@@QBEHXZ 0033 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0046 ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z 0052 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 43 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 0C 83 7D 08 02 74 06 83 7D 08 03 75 0E 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? EB 1D 83 7D 08 00 75 02 EB 15 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_39_0 {
	meta:
		name = "??YReplicator@@QAEAAV0@ABVDName@@@Z"
		size = 136
		refs = "000d ?isFull@Replicator@@QBEHXZ 0019 ?isEmpty@DName@@QBEHXZ 0024 _heap 002b ??2@YAPAXIAAV_HeapManager@@H@Z 0043 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 6A 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 75 5E 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 89 4D EC 83 7D EC 00 74 20 8B 55 FC 8B 02 83 C0 01 89 45 F0 8B 4D FC 8B 55 F0 89 11 8B 45 F0 8B 4D FC 8B 55 EC 89 54 81 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_40_0 {
	meta:
		name = "??_5DName@@QAEAAV0@ABV0@@Z"
		size = 82
		refs = "000d ?status@DName@@QBE?AW4DNameStatus@@XZ 001a ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 F8 03 74 33 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 75 27 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 25 FF 00 00 00 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 0B D0 8B 45 FC 89 50 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_41_0 {
	meta:
		name = "?Constructor@_HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z"
		size = 60
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 45 0C 89 42 04 8B 4D FC C7 41 10 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 8B 45 FC C7 40 0C 00 00 00 00 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_42_0 {
	meta:
		name = "?Destructor@_HeapManager@@QAEXXZ"
		size = 75
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 04 00 74 37 8B 4D FC 8B 55 FC 8B 42 08 89 41 0C 8B 4D FC 83 79 0C 00 74 22 8B 55 FC 8B 42 0C 8B 4D FC 8B 10 89 51 08 8B 45 FC 8B 48 0C 51 8B 55 FC 8B 42 04 FF D0 83 C4 04 EB C9 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_43_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPBDW4Tokens@@@Z"
		size = 41
		refs = "0004 ?doUnderScore@UnDecorator@@SAHXZ 0012 _tokenTable"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0E 8B 45 08 8B 04 85 ?? ?? ?? ?? EB 0F EB 0D 8B 4D 08 8B 04 8D ?? ?? ?? ?? 83 C0 02 5D C3 }
	condition:
		$1
}

rule file_52_44_0 {
	meta:
		name = "?append@DName@@AAEXPAVDNameNode@@@Z"
		size = 137
		refs = "0012 _heap 0019 ??2@YAPAXIAAV_HeapManager@@H@Z 0037 ??0pairNode@@QAE@PAVDNameNode@@0@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 83 7D 08 00 74 5F 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 17 8B 45 08 50 8B 4D FC 8B 11 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 45 FC 8B 4D F4 89 08 8B 55 FC 83 3A 00 75 15 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 83 C9 03 8B 55 FC 89 4A 04 EB 15 8B 45 FC 8B 48 04 81 E1 00 FF FF FF 83 C9 03 8B 55 FC 89 4A 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_52_45_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 7294
		refs = "000d ??0DName@@QAE@XZ 0012 ?getTypeEncoding@UnDecorator@@CAHXZ 001d ?isUDC@DName@@QBEHXZ 0036 ??0DName@@QAE@W4DNameStatus@@@Z 0058 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 007a ??0DName@@QAE@ABV0@@Z 02a9 ?doMSKeywords@UnDecorator@@SAHXZ 02b2 ?doAllocationModel@UnDecorator@@SAHXZ 02c2 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 02d4 ??H@YA?AVDName@@DABV0@@Z 02e0 ??4DName@@QAEAAV0@ABV0@@Z 02fa ??_5DName@@QAEAAV0@ABV0@@Z 03e2 ?getCallIndex@UnDecorator@@CA?AVDName@@XZ 03fe ??HDName@@QBE?AV0@D@Z 0405 ??HDName@@QBE?AV0@ABV0@@Z 040e ??YDName@@QAEAAV0@ABV0@@Z 041a ?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ 0422 ?doNameOnly@UnDecorator@@SAHXZ 042b ??_C@_03OPGICMGF@?$HN?8?5?$AA@ 0451 ??HDName@@QBE?AV0@PBD@Z 045f ??_C@_02IGFCGPIL@?$HN?8?$AA@ 0467 ??YDName@@QAEAAV0@PBD@Z 0473 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 0484 ?doAllocationLanguage@UnDecorator@@SAHXZ 0626 ?getDisplacement@UnDecorator@@CA?AVDName@@XZ 0866 ?doThisTypes@UnDecorator@@SAHXZ 0876 ?getThisType@UnDecorator@@CA?AVDName@@XZ 091a ?isEmpty@DName@@QBEHXZ 0988 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 0991 ??_C@_01CLKCMJKC@?5?$AA@ 099d ??H@YA?AVDName@@PBDABV0@@Z 09cf _heap 09d6 ??2@YAPAXIAAV_HeapManager@@H@Z 0b9e ??_C@_0N@CBHHHENL@?$GAvtordispex?$HL?$AA@ 0c78 ??_C@_0L@GHPFDFH@?$GAvtordisp?$HL?$AA@ 0c9e ??_C@_0L@HNGCOGAE@?$GAadjustor?$HL?$AA@ 0cdb ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0e53 ?doRestrictionSpec@UnDecorator@@SAHXZ 0e63 ?getRestrictionSpec@UnDecorator@@CA?AVDName@@XZ 0e8e ?doThrowTypes@UnDecorator@@SAHXZ 0e9e ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 0ed0 ?getDispatchTarget@UnDecorator@@CA?AVDName@@XZ 0ee1 ?doFunctionReturns@UnDecorator@@SAHXZ 0f3e ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 0f76 ?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 0fb7 ?getGuardNumber@UnDecorator@@CA?AVDName@@XZ 1017 ?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z 111b ??_C@_0CB@KJDOOODE@?$GAlocal?5static?5destructor?5helper?8@ 121c ??_C@_0DB@ILEFOCIJ@?$GAtemplate?5static?5data?5member?5con@ 131d ??_C@_0DA@HGFJFBBE@?$GAtemplate?5static?5data?5member?5des@ 14cd ?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 1558 ?doMemberTypes@UnDecorator@@SAHXZ 162e ??_C@_07PGOEDBHP@static?5?$AA@ 1848 ??_C@_08NIEOINHE@virtual?5?$AA@ 1865 ?doAccessSpecifiers@UnDecorator@@SAHXZ 1939 ??_C@_09LAPHOOG@private?3?5?$AA@ 1a51 ??_C@_0M@GAIFPFIP@protected?3?5?$AA@ 1b5e ??_C@_08GPDDCMKI@public?3?5?$AA@ 1c24 ??_C@_08KJLFOPNE@?$FLthunk?$FN?3?$AA@ 1c4f ??_C@_0M@DHNBOJMP@extern?5?$CCC?$CC?5?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 08 04 00 00 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 8B 4D 0C E8 ?? ?? ?? ?? 89 85 E8 FD FF FF 81 7D FC FF FF 00 00 75 14 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 38 1C 00 00 EB 42 81 7D FC FE FF 00 00 75 1C 8B 45 0C 50 6A 01 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 E9 13 1C 00 00 EB 1D 81 7D FC FD FF 00 00 75 14 8B 55 0C 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 F4 1B 00 00 8B 45 FC 25 00 80 00 00 0F 84 7B 0E 00 00 8B 4D FC 81 E1 00 80 00 00 74 35 8B 55 FC 81 E2 00 18 00 00 81 FA 00 08 00 00 75 0C C7 85 74 FE FF FF 01 00 00 00 EB 0A C7 85 74 FE FF FF 00 00 00 00 8B 85 74 FE FF FF 89 85 F0 FE FF FF EB 2D 8B 4D FC 81 E1 00 60 00 00 75 0C C7 85 F4 FD FF FF 01 00 00 00 EB 0A C7 85 F4 FD FF FF 00 00 00 00 8B 95 F4 FD FF FF 89 95 F0 FE FF FF 83 BD F0 FE FF FF 00 74 0D 8B 45 FC 25 00 04 00 00 89 45 E0 EB 0C 8B 4D FC 81 E1 00 10 00 00 89 4D E0 83 7D E0 00 74 4C 8B 55 FC 81 E2 00 80 00 00 74 30 8B 45 FC 25 00 1B 00 00 3D 00 10 00 00 75 0C C7 85 E8 FE FF FF 01 00 00 00 EB 0A C7 85 E8 FE FF FF 00 00 00 00 8B 8D E8 FE FF FF 89 4D D8 EB 07 C7 45 D8 00 00 00 00 83 7D D8 00 0F 85 9A 0D 00 00 8B 55 FC 81 E2 00 80 00 00 74 33 8B 45 FC 25 00 18 00 00 3D 00 08 00 00 75 0C C7 85 E0 FE FF FF 01 00 00 00 EB 0A C7 85 E0 FE FF FF 00 00 00 00 8B 8D E0 FE FF FF 89 8D D8 FE FF FF EB 24 8B 55 FC 81 E2 00 60 00 00 75 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 85 D8 FE FF FF 83 BD D8 FE FF FF 00 74 0E 8B 4D FC 81 E1 00 04 00 00 89 4D C8 EB 0C 8B 55 FC 81 E2 00 10 00 00 89 55 C8 83 7D C8 00 0F 84 9A 00 00 00 8B 45 FC 25 00 80 00 00 74 32 8B 4D FC 81 E1 00 1B 00 00 81 F9 00 11 00 00 75 0C C7 85 D0 FE FF FF 01 00 00 00 EB 0A C7 85 D0 FE FF FF 00 00 00 00 8B 95 D0 FE FF FF 89 55 C0 EB 07 C7 45 C0 00 00 00 00 83 7D C0 00 0F 85 BE 0C 00 00 8B 45 FC 25 00 80 00 00 74 32 8B 4D FC 81 E1 00 1B 00 00 81 F9 00 12 00 00 75 0C C7 85 C8 FE FF FF 01 00 00 00 EB 0A C7 85 C8 FE FF FF 00 00 00 00 8B 95 C8 FE FF FF 89 55 B8 EB 07 C7 45 B8 00 00 00 00 83 7D B8 00 0F 85 71 0C 00 00 8B 45 FC 25 00 40 00 00 74 56 E8 ?? ?? ?? ?? 85 C0 74 35 E8 ?? ?? ?? ?? 85 C0 74 2C 8D 8D 70 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 20 8D 95 60 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 8D 85 90 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 74 35 8B 55 FC 81 E2 00 18 00 00 81 FA 00 08 00 00 75 0C C7 85 C0 FE FF FF 01 00 00 00 EB 0A C7 85 C0 FE FF FF 00 00 00 00 8B 85 C0 FE FF FF 89 85 B8 FE FF FF EB 24 8B 4D FC 81 E1 00 60 00 00 75 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 55 B0 89 95 B8 FE FF FF 83 BD B8 FE FF FF 00 74 0D 8B 45 FC 25 00 04 00 00 89 45 A8 EB 0C 8B 4D FC 81 E1 00 10 00 00 89 4D A8 83 7D A8 00 0F 84 4F 01 00 00 8B 55 FC 81 E2 00 80 00 00 74 30 8B 45 FC 25 00 18 00 00 3D 00 18 00 00 75 0C C7 85 B0 FE FF FF 01 00 00 00 EB 0A C7 85 B0 FE FF FF 00 00 00 00 8B 8D B0 FE FF FF 89 4D A0 EB 07 C7 45 A0 00 00 00 00 83 7D A0 00 0F 84 03 01 00 00 8D 95 C0 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 85 80 FD FF FF 50 6A 7B 8D 8D 10 FC FF FF 51 8B 4D 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 34 68 ?? ?? ?? ?? 8D 85 70 FD FF FF 50 8D 8D B8 FD FF FF 51 6A 2C 8D 95 B0 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 55 E8 ?? ?? ?? ?? 85 C0 74 4C E8 ?? ?? ?? ?? 85 C0 75 43 8D 4D F4 51 8D 95 60 FD FF FF 52 6A 20 8D 85 50 FC FF FF 50 8D 8D B0 FD FF FF 51 6A 20 8D 95 50 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? E9 2D 0A 00 00 8D 8D C8 FD FF FF E8 ?? ?? ?? ?? 8D 8D C0 FD FF FF E8 ?? ?? ?? ?? 8D 8D EC FD FF FF E8 ?? ?? ?? ?? 8D 8D D8 FD FF FF E8 ?? ?? ?? ?? 8D 8D E0 FD FF FF E8 ?? ?? ?? ?? 8B 45 FC 25 00 80 00 00 74 35 8B 4D FC 81 E1 00 18 00 00 81 F9 00 08 00 00 75 0C C7 85 A8 FE FF FF 01 00 00 00 EB 0A C7 85 A8 FE FF FF 00 00 00 00 8B 95 A8 FE FF FF 89 95 A0 FE FF FF EB 23 8B 45 FC 25 00 60 00 00 75 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 4D 98 89 8D A0 FE FF FF 83 BD A0 FE FF FF 00 74 0E 8B 55 FC 81 E2 00 04 00 00 89 55 90 EB 0B 8B 45 FC 25 00 10 00 00 89 45 90 83 7D 90 00 0F 84 84 01 00 00 8B 4D FC 81 E1 00 80 00 00 74 35 8B 55 FC 81 E2 00 18 00 00 81 FA 00 08 00 00 75 0C C7 85 98 FE FF FF 01 00 00 00 EB 0A C7 85 98 FE FF FF 00 00 00 00 8B 85 98 FE FF FF 89 85 90 FE FF FF EB 24 8B 4D FC 81 E1 00 60 00 00 75 09 C7 45 88 01 00 00 00 EB 07 C7 45 88 00 00 00 00 8B 55 88 89 95 90 FE FF FF 83 BD 90 FE FF FF 00 74 65 8B 45 FC 25 00 07 00 00 3D 00 06 00 00 75 56 8D 8D A0 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D C8 FD FF FF E8 ?? ?? ?? ?? 8D 95 40 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D C0 FD FF FF E8 ?? ?? ?? ?? 8D 85 20 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D EC FD FF FF E8 ?? ?? ?? ?? E9 97 00 00 00 8B 4D FC 81 E1 00 80 00 00 74 2C 8B 55 FC 81 E2 00 18 00 00 81 FA 00 08 00 00 75 09 C7 45 80 01 00 00 00 EB 07 C7 45 80 00 00 00 00 8B 45 80 89 85 78 FF FF FF EB 2D 8B 4D FC 81 E1 00 60 00 00 75 0C C7 85 88 FE FF FF 01 00 00 00 EB 0A C7 85 88 FE FF FF 00 00 00 00 8B 95 88 FE FF FF 89 95 78 FF FF FF 83 BD 78 FF FF FF 00 74 2A 8B 45 FC 25 00 07 00 00 3D 00 05 00 00 75 1B 8D 8D 30 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D EC FD FF FF E8 ?? ?? ?? ?? 8D 95 90 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D D8 FD FF FF E8 ?? ?? ?? ?? 8B 45 FC 25 00 80 00 00 74 35 8B 4D FC 81 E1 00 18 00 00 81 F9 00 08 00 00 75 0C C7 85 80 FE FF FF 01 00 00 00 EB 0A C7 85 80 FE FF FF 00 00 00 00 8B 95 80 FE FF FF 89 95 78 FE FF FF EB 2C 8B 45 FC 25 00 60 00 00 75 0C C7 85 70 FF FF FF 01 00 00 00 EB 0A C7 85 70 FF FF FF 00 00 00 00 8B 8D 70 FF FF FF 89 8D 78 FE FF FF 83 BD 78 FE FF FF 00 0F 84 08 01 00 00 8B 55 FC 81 E2 00 80 00 00 74 33 8B 45 FC 25 00 18 00 00 3D 00 08 00 00 75 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 8D 68 FF FF FF 89 8D 60 FF FF FF EB 2D 8B 55 FC 81 E2 00 60 00 00 75 0C C7 85 70 FE FF FF 01 00 00 00 EB 0A C7 85 70 FE FF FF 00 00 00 00 8B 85 70 FE FF FF 89 85 60 FF FF FF 83 BD 60 FF FF FF 00 74 53 8B 4D FC 81 E1 00 80 00 00 74 35 8B 55 FC 81 E2 00 07 00 00 81 FA 00 02 00 00 75 0C C7 85 68 FE FF FF 01 00 00 00 EB 0A C7 85 68 FE FF FF 00 00 00 00 8B 85 68 FE FF FF 89 85 58 FF FF FF EB 0A C7 85 58 FF FF FF 01 00 00 00 83 BD 58 FF FF FF 00 75 41 E8 ?? ?? ?? ?? 85 C0 74 1D 8D 8D 20 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D E0 FD FF FF E8 ?? ?? ?? ?? EB 1B 8D 95 40 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D E0 FD FF FF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 4F E8 ?? ?? ?? ?? 85 C0 74 2C 8D 45 F4 50 8D 8D 10 FD FF FF 51 8D 95 80 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 8D 85 00 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 8D 8D 00 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 41 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 75 29 E8 ?? ?? ?? ?? 85 C0 75 20 8B 55 0C 52 6A 20 8D 85 F0 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? EB 0C 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? C7 45 F0 00 00 00 00 8D 8D D0 FD FF FF E8 ?? ?? ?? ?? 83 BD E8 FD FF FF 00 74 4E 6A 00 8D 95 A8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 68 ?? ?? ?? ?? 8D 85 E0 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 14 8D 4D F4 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 B0 12 00 00 EB 65 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 85 60 FE FF FF 83 BD 60 FE FF FF 00 74 13 8B 8D 60 FE FF FF E8 ?? ?? ?? ?? 89 85 50 FF FF FF EB 0A C7 85 50 FF FF FF 00 00 00 00 8B 95 50 FF FF FF 89 55 F0 8B 45 F0 50 8D 8D 30 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 50 8D 8D D0 FD FF FF E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 74 33 8B 45 FC 25 00 18 00 00 3D 00 08 00 00 75 0C C7 85 58 FE FF FF 01 00 00 00 EB 0A C7 85 58 FE FF FF 00 00 00 00 8B 8D 58 FE FF FF 89 8D 50 FE FF FF EB 2D 8B 55 FC 81 E2 00 60 00 00 75 0C C7 85 48 FF FF FF 01 00 00 00 EB 0A C7 85 48 FF FF FF 00 00 00 00 8B 85 48 FF FF FF 89 85 50 FE FF FF 83 BD 50 FE FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D 40 FF FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 40 FF FF FF 83 BD 40 FF FF FF 00 0F 84 F8 01 00 00 8B 45 FC 25 00 80 00 00 74 35 8B 4D FC 81 E1 00 18 00 00 81 F9 00 08 00 00 75 0C C7 85 48 FE FF FF 01 00 00 00 EB 0A C7 85 48 FE FF FF 00 00 00 00 8B 95 48 FE FF FF 89 95 40 FE FF FF EB 2C 8B 45 FC 25 00 60 00 00 75 0C C7 85 38 FF FF FF 01 00 00 00 EB 0A C7 85 38 FF FF FF 00 00 00 00 8B 8D 38 FF FF FF 89 8D 40 FE FF FF 83 BD 40 FE FF FF 00 0F 84 98 00 00 00 8B 55 FC 81 E2 00 07 00 00 81 FA 00 06 00 00 0F 85 83 00 00 00 6A 2C 8D 85 D0 FC FF FF 50 8D 8D EC FD FF FF 51 8D 95 A0 FD FF FF 52 6A 2C 8D 85 98 FD FF FF 50 8D 8D C0 FD FF FF 51 8D 95 88 FD FF FF 52 6A 2C 8D 85 78 FD FF FF 50 8D 8D C8 FD FF FF 51 68 ?? ?? ?? ?? 8D 95 68 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? E9 C8 00 00 00 8B 45 FC 25 00 80 00 00 74 35 8B 4D FC 81 E1 00 18 00 00 81 F9 00 08 00 00 75 0C C7 85 30 FF FF FF 01 00 00 00 EB 0A C7 85 30 FF FF FF 00 00 00 00 8B 95 30 FF FF FF 89 95 28 FF FF FF EB 2C 8B 45 FC 25 00 60 00 00 75 0C C7 85 38 FE FF FF 01 00 00 00 EB 0A C7 85 38 FE FF FF 00 00 00 00 8B 8D 38 FE FF FF 89 8D 28 FF FF FF 83 BD 28 FF FF FF 00 74 47 8B 55 FC 81 E2 00 07 00 00 81 FA 00 05 00 00 75 36 6A 2C 8D 85 58 FD FF FF 50 8D 8D EC FD FF FF 51 68 ?? ?? ?? ?? 8D 95 48 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 38 FD FF FF 50 8D 8D D8 FD FF FF E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 29 8D 8D 28 FD FF FF 51 8D 95 18 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 28 8D 85 08 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 74 35 8B 55 FC 81 E2 00 18 00 00 81 FA 00 08 00 00 75 0C C7 85 30 FE FF FF 01 00 00 00 EB 0A C7 85 30 FE FF FF 00 00 00 00 8B 85 30 FE FF FF 89 85 28 FE FF FF EB 2D 8B 4D FC 81 E1 00 60 00 00 75 0C C7 85 20 FF FF FF 01 00 00 00 EB 0A C7 85 20 FF FF FF 00 00 00 00 8B 95 20 FF FF FF 89 95 28 FE FF FF 83 BD 28 FE FF FF 00 0F 84 D4 00 00 00 8B 45 FC 25 00 80 00 00 74 35 8B 4D FC 81 E1 00 18 00 00 81 F9 00 08 00 00 75 0C C7 85 18 FF FF FF 01 00 00 00 EB 0A C7 85 18 FF FF FF 00 00 00 00 8B 95 18 FF FF FF 89 95 10 FF FF FF EB 2C 8B 45 FC 25 00 60 00 00 75 0C C7 85 20 FE FF FF 01 00 00 00 EB 0A C7 85 20 FE FF FF 00 00 00 00 8B 8D 20 FE FF FF 89 8D 10 FF FF FF 83 BD 10 FF FF FF 00 74 51 8B 55 FC 81 E2 00 80 00 00 74 33 8B 45 FC 25 00 07 00 00 3D 00 02 00 00 75 0C C7 85 18 FE FF FF 01 00 00 00 EB 0A C7 85 18 FE FF FF 00 00 00 00 8B 8D 18 FE FF FF 89 8D 08 FF FF FF EB 0A C7 85 08 FF FF FF 01 00 00 00 83 BD 08 FF FF FF 00 75 0F 8D 95 E0 FD FF FF 52 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1A 8D 85 F8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 8D 8D E8 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1A 8D 95 D8 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 8D 85 C8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 8D B8 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 21 83 7D F0 00 74 1B 8D 55 F4 52 8B 4D F0 E8 ?? ?? ?? ?? 8D 85 D0 FD FF FF 50 8D 4D F4 E8 ?? ?? ?? ?? E9 CE 05 00 00 8B 4D 0C 51 8D 4D F4 E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 75 2C 8B 45 FC 25 00 7C 00 00 3D 00 68 00 00 75 1D 8D 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 E9 2D 0D 00 00 E9 07 04 00 00 8B 45 FC 25 00 80 00 00 75 2E 8B 4D FC 81 E1 00 7C 00 00 81 F9 00 70 00 00 75 1D 8D 55 F4 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 E9 F5 0C 00 00 E9 CF 03 00 00 8B 4D FC 81 E1 00 80 00 00 75 5D 8B 55 FC 81 E2 00 7C 00 00 81 FA 00 60 00 00 75 4C 68 ?? ?? ?? ?? 8B 45 08 50 8D 8D A8 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 95 98 FC FF FF 52 6A 7B 8D 85 88 FC FF FF 50 8D 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 E9 8D 0C 00 00 E9 67 03 00 00 8B 4D FC 81 E1 00 80 00 00 75 2E 8B 55 FC }
	condition:
		$1
}

rule file_52_46_0 {
	meta:
		name = "?dbGetString@DName@@QBEPADXZ"
		size = 31
		refs = "000a ?buf@?1??dbGetString@DName@@QBEPADXZ@4PADA 0012 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 50 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_47_0 {
	meta:
		name = "?doAccessSpecifiers@UnDecorator@@SAHXZ"
		size = 39
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 25 80 00 00 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_48_0 {
	meta:
		name = "?doAllocationLanguage@UnDecorator@@SAHXZ"
		size = 37
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E0 10 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_49_0 {
	meta:
		name = "?doAllocationModel@UnDecorator@@SAHXZ"
		size = 37
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E0 08 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_50_0 {
	meta:
		name = "?doEcsu@UnDecorator@@SAHXZ"
		size = 39
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 25 00 80 00 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_51_0 {
	meta:
		name = "?doEllipsis@UnDecorator@@SAHXZ"
		size = 39
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 25 00 00 04 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_52_0 {
	meta:
		name = "?doFunctionReturns@UnDecorator@@SAHXZ"
		size = 37
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E0 04 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_53_0 {
	meta:
		name = "?doMSKeywords@UnDecorator@@SAHXZ"
		size = 37
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E0 02 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_54_0 {
	meta:
		name = "?doMemberTypes@UnDecorator@@SAHXZ"
		size = 39
		refs = "0005 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 25 00 02 00 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_57_0 {
	meta:
		name = "?doPchar@DName@@AAEXPBDH@Z"
		size = 309
		refs = "0017 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0064 _heap 006b ??2@YAPAXIAAV_HeapManager@@H@Z 0086 ??0charNode@@QAE@D@Z 00e3 ??0pcharNode@@QAE@PBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D FC 8B 45 FC 83 38 00 74 0F 6A 03 8B 4D FC E8 ?? ?? ?? ?? E9 0F 01 00 00 83 7D 08 00 0F 84 F0 00 00 00 83 7D 0C 00 0F 84 E6 00 00 00 8B 4D 0C 89 4D F8 83 7D F8 00 74 08 83 7D F8 01 74 1B EB 75 8B 55 FC 8B 42 04 25 00 FF FF FF 83 C8 03 8B 4D FC 89 41 04 E9 B7 00 00 00 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 14 8B 55 08 0F B6 02 50 8B 4D F4 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D FC 8B 55 F0 89 11 8B 45 FC 83 38 00 75 15 8B 4D FC 8B 51 04 81 E2 00 FF FF FF 83 CA 03 8B 45 FC 89 50 04 EB 5B 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 83 7D EC 00 74 15 8B 4D 0C 51 8B 55 08 52 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 45 FC 8B 4D E8 89 08 8