private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_wcsset_s"
		size = 84
		refs = "0037 _errno 0042 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 45 33 C9 48 85 C9 74 2A 48 85 D2 74 25 48 8B C1 66 44 39 09 74 13 48 FF CA 74 0E 66 44 89 00 48 83 C0 02 66 44 39 08 75 ED 48 85 D2 75 1E 66 44 89 09 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 48 83 C4 28 C3 33 C0 EB F7 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_556_22_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@PEAV123@@Z"
		size = 29
		refs = "0010 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_7_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_579_8_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_595_4_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_572_75_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@AEAV12@@Z"
		size = 29
		refs = "0010 ?lock_read@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "??_H@YAXPEAX_KHP6APEAX0@Z@Z"
		size = 67
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F1 41 8B F8 48 8B EA 48 8B D9 EB 08 48 8B CB FF D6 48 03 DD FF CF 79 F4 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z"
		size = 91
		altNames = "??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEBAPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z ??A?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEBAPEAVExternalStatistics@12@H@Z ??A?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEBAPEAVScheduleGroupBase@12@H@Z ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEBAPEAVWorkQueue@12@H@Z"
	strings:
		$1 = { 4C 8B C9 8B 49 54 4C 63 DA 45 8B C3 41 D3 F8 45 3B 41 6C 7C 03 33 C0 C3 49 8B 41 60 45 3B 41 68 7C 1E 45 2B 41 68 49 63 49 68 4C 8B 54 C8 F8 78 16 41 8D 48 01 48 FF C9 4D 8B 52 08 75 F7 EB 07 49 63 C8 4C 8B 14 C8 41 8B 41 50 FF C8 48 63 D0 49 8B 02 49 23 D3 48 8B 04 D0 C3 }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAPEAVVirtualProcessor@23@XZ"
		size = 26
		refs = "0006 __imp_InterlockedPopEntrySList"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 48 85 C0 74 06 48 05 10 FF FF FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_16_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 46
		altNames = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 8B 51 04 8B 01 4C 8B C9 3B C2 7D 1F 48 63 09 4D 63 41 08 49 8B 51 10 4C 23 C1 33 C0 4A 87 04 C2 48 85 C0 74 08 FF C1 41 89 09 C3 33 C0 C3 }
	condition:
		$1
}

rule file_1_17_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVVirtualProcessor@23@@Z"
		size = 16
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVExternalStatistics@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVWorkQueue@23@@Z"
	strings:
		$1 = { 48 83 61 08 00 83 49 10 FF 48 89 11 48 8B C1 C3 }
	condition:
		$1
}

rule file_1_18_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QEAAXI@Z"
		size = 26
	strings:
		$1 = { 85 D2 75 08 C7 41 08 04 00 00 00 C3 B8 01 00 00 00 89 11 89 41 04 89 41 08 C3 }
	condition:
		$1
}

rule file_1_19_0 {
	meta:
		name = "??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPEAVVirtualProcessor@01@@Z"
		size = 24
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 0A 48 8B 01 BA 01 00 00 00 FF 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_20_0 {
	meta:
		name = "?FindMatchingVirtualProcessor@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEAUIVirtualProcessorRoot@3@@Z"
		size = 154
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 8B 99 90 00 00 00 45 33 C9 48 8B FA 4C 8B C1 85 DB 7E 70 41 8B 48 74 41 8B D1 D3 FA 41 3B 90 8C 00 00 00 7D 56 4D 63 90 88 00 00 00 49 8B 80 80 00 00 00 41 3B D2 7C 18 41 2B D2 4E 8B 5C D0 F8 78 15 8D 4A 01 48 FF C9 4D 8B 5B 08 75 F7 EB 07 48 63 CA 4C 8B 1C C8 41 8B 40 70 FF C8 48 63 C8 49 63 C1 48 23 C8 49 8B 03 48 8B 04 C8 48 85 C0 74 09 48 39 B8 88 00 00 00 74 0A 41 FF C1 44 3B CB 7C 90 33 C0 48 8B 5C 24 08 48 8B 7C 24 10 C3 }
	condition:
		$1
}

rule file_1_21_0 {
	meta:
		name = "?FindAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AEAAPEAVVirtualProcessor@23@PEAV423@@Z"
		size = 217
		refs = "0027 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B DA 48 8B F9 48 85 D2 74 1D 80 BA C3 00 00 00 00 75 14 48 8B CA E8 ?? ?? ?? ?? 84 C0 74 08 48 8B C3 E9 92 00 00 00 8B 87 90 00 00 00 33 F6 85 C0 0F 8E 80 00 00 00 8B 4F 74 8B D6 D3 FA 3B 97 8C 00 00 00 7D 65 4C 63 8F 88 00 00 00 48 8B 87 80 00 00 00 41 3B D1 7C 18 41 2B D1 4E 8B 44 C8 F8 78 15 8D 4A 01 48 FF C9 4D 8B 40 08 75 F7 EB 07 48 63 CA 4C 8B 04 C8 8B 47 70 FF C8 48 63 C8 48 63 C6 48 23 C8 49 8B 00 48 8B 1C C8 48 85 DB 74 19 80 BB C3 00 00 00 00 75 10 48 8B CB E8 ?? ?? ?? ?? 84 C0 0F 85 74 FF FF FF 8B 87 90 00 00 00 FF C6 3B F0 7C 80 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_22_0 {
	meta:
		name = "?CheckForNewOwningRing@SchedulingNode@details@Concurrency@@AEAAXXZ"
		size = 487
		refs = "001f __security_cookie 005c __chkstk 0070 memset 01cc __security_check_cookie"
	strings:
		$1 = { 40 55 48 81 EC 30 01 00 00 48 8D 6C 24 20 48 89 9D 28 01 00 00 48 89 BD 30 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 85 00 01 00 00 48 8B 01 48 8B D9 83 78 38 40 7E 2A 48 63 40 38 48 C1 E0 02 48 8D 50 0F 48 3B D0 77 0A 48 BA F0 FF FF FF FF FF FF 0F 48 83 E2 F0 48 8B C2 E8 ?? ?? ?? ?? 48 2B E2 48 8D 4D 00 33 D2 41 B8 00 01 00 00 E8 ?? ?? ?? ?? 8B 83 90 00 00 00 33 FF 45 33 DB 45 33 C0 85 C0 0F 8E 92 00 00 00 8B 4B 74 41 8B D0 D3 FA 3B 93 8C 00 00 00 7D 70 4C 63 8B 88 00 00 00 48 8B 83 80 00 00 00 41 3B D1 7C 18 41 2B D1 4E 8B 54 C8 F8 78 15 8D 4A 01 48 FF C9 4D 8B 52 08 75 F7 EB 07 48 63 CA 4C 8B 14 C8 8B 43 70 FF C8 48 63 C8 49 63 C0 48 23 C8 49 8B 02 48 8B 14 C8 48 85 D2 74 24 48 8B 42 78 48 63 88 A4 00 00 00 FF 44 8D 00 39 7C 8D 00 7E 0F 48 8B 42 78 8B 7C 8D 00 44 8B 98 A4 00 00 00 8B 83 90 00 00 00 41 FF C0 44 3B C0 0F 8C 6E FF FF FF 8B 83 90 00 00 00 45 33 C0 4D 63 DB 85 C0 0F 8E 91 00 00 00 8B 4B 74 41 8B D0 D3 FA 3B 93 8C 00 00 00 7D 6F 4C 63 93 88 00 00 00 48 8B 83 80 00 00 00 41 3B D2 7C 18 41 2B D2 4E 8B 4C D0 F8 78 15 8D 4A 01 48 FF C9 4D 8B 49 08 75 F7 EB 07 48 63 CA 4C 8B 0C C8 8B 43 70 FF C8 48 63 C8 49 63 C0 48 23 C8 49 8B 01 48 8B 14 C8 48 85 D2 74 23 48 8B 03 48 8B 48 30 4A 8B 04 D9 48 89 82 80 00 00 00 33 C0 87 82 98 00 00 00 83 F8 01 75 04 F0 FF 4B 18 8B 83 90 00 00 00 41 FF C0 44 3B C0 0F 8C 6F FF FF FF 48 8B 8D 00 01 00 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 9D 28 01 00 00 48 8B BD 30 01 00 00 48 8D A5 10 01 00 00 5D C3 }
	condition:
		$1
}

rule file_1_23_0 {
	meta:
		name = "??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 302
		refs = "009a ??_U@YAPEAX_K@Z 00af memset 00b7 ??2@YAPEAX_K@Z 00f7 __imp_InitializeSListHead"
		altNames = "??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z ??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z ??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z ??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 20 48 83 61 20 00 83 61 54 00 48 83 61 58 00 48 89 51 48 C7 41 68 00 02 00 00 C7 41 6C 01 00 00 00 41 8D 40 FF C7 41 70 00 00 00 00 44 89 49 74 48 8B D9 C7 41 78 00 00 00 00 41 85 C0 74 2F 41 8B C0 D1 F8 44 0B C0 41 8B C0 C1 F8 02 44 0B C0 41 8B C0 C1 F8 04 44 0B C0 41 8B C0 C1 F8 08 44 0B C0 41 8B C0 C1 F8 10 44 0B C0 41 FF C0 44 89 41 50 49 63 C8 B8 08 00 00 00 48 C7 C5 FF FF FF FF 48 F7 E1 48 0F 40 C5 48 8B C8 E8 ?? ?? ?? ?? 4C 63 43 50 33 D2 49 C1 E0 03 48 8B C8 48 8B F8 E8 ?? ?? ?? ?? 8D 4D 19 E8 ?? ?? ?? ?? 48 85 C0 74 0B 48 83 60 08 00 48 89 38 89 68 10 48 63 4B 68 48 89 43 58 B8 08 00 00 00 48 F7 E1 48 0F 40 C5 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 58 48 89 43 60 48 89 08 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 4B 10 FF 15 ?? ?? ?? ?? 44 8B 5B 50 41 D1 FB 74 0D 8B 43 54 FF C0 41 D1 FB 75 F9 89 43 54 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_24_0 {
	meta:
		name = "?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 98
		refs = "001a ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 004b ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 59 18 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 44 8B 5F 04 8B 07 33 F6 41 3B C3 7D 1C 48 63 0F 48 63 57 08 48 8B 47 10 48 23 D1 48 87 34 D0 48 85 F6 74 05 8D 41 01 89 07 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_25_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ"
		size = 50
		refs = "000e ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 83 61 08 00 48 8B D9 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 0D 89 03 B8 01 00 00 00 89 43 04 89 43 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_26_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
		size = 49
	strings:
		$1 = { 48 85 D2 74 2B 53 48 83 EC 20 48 8B DA 48 8D 8B 10 FF FF FF 48 8B 1B 48 85 C9 74 0A 48 8B 01 BA 01 00 00 00 FF 10 48 85 DB 75 E2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_27_0 {
	meta:
		name = "?StealLocalRunnableContext@SchedulingNode@details@Concurrency@@AEAAPEAVInternalContextBase@23@PEAVVirtualProcessor@23@@Z"
		size = 203
		refs = "00a1 ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B B1 90 00 00 00 45 33 C9 48 8B F9 48 85 D2 74 0C 8B AA 9C 00 00 00 41 8D 59 01 EB 7E 33 ED 33 DB EB 78 8B 4F 74 8D 04 2B 99 F7 FE 44 8B C2 41 D3 F8 44 3B 87 8C 00 00 00 7D 5E 4C 63 97 88 00 00 00 48 8B 87 80 00 00 00 45 3B C2 7C 19 45 2B C2 4E 8B 5C D0 F8 78 16 41 8D 48 01 48 FF C9 4D 8B 5B 08 75 F7 EB 07 49 63 C8 4C 8B 1C C8 8B 47 70 FF C8 48 63 C8 48 63 C2 48 23 C8 49 8B 03 48 8B 0C C8 48 85 C9 74 11 48 83 C1 10 E8 ?? ?? ?? ?? 4C 8B C8 48 85 C0 75 06 FF C3 3B DE 7C 84 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 49 8B C1 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_28_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
		size = 180
		refs = "001a ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 33 FF 8B 4B 08 85 C9 75 27 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB E4 89 03 C7 43 04 01 00 00 00 C7 43 08 01 00 00 00 EB D2 FF C9 74 53 FF C9 74 33 FF C9 74 06 FF C9 74 3F EB 25 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 10 89 03 C7 43 04 01 00 00 00 C7 43 08 01 00 00 00 32 C0 EB 31 8B 43 08 FF 4B 04 B9 03 00 00 00 0F 44 C1 40 B7 01 89 43 08 FF 53 10 40 8A C7 EB 15 F3 90 FF 0B 75 0D 8B 4B 04 F7 D9 1B D2 83 C2 03 89 53 08 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_29_0 {
	meta:
		name = "??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 261
		refs = "0019 __imp_InterlockedFlushSList 00d4 ??_V@YAXPEAX@Z 00dc ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F9 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 1F 48 8D 8B 10 FF FF FF 48 8B 1B 48 85 C9 74 0B 4C 8B 01 BA 01 00 00 00 41 FF 10 48 85 DB 75 E1 48 8D 4F 10 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 1F 48 8D 8B 10 FF FF FF 48 8B 1B 48 85 C9 74 0B 4C 8B 01 BA 01 00 00 00 41 FF 10 48 85 DB 75 E1 48 8B 5F 20 EB 19 48 8D 8B 10 FF FF FF 48 8B 1B 48 85 C9 74 0A 48 8B 01 BA 01 00 00 00 FF 10 48 85 DB 75 E2 48 8B 77 58 48 85 F6 74 46 33 DB 39 5F 50 7E 23 33 ED 48 8B 06 48 8B 0C 28 48 85 C9 74 0A 48 8B 01 BA 01 00 00 00 FF 10 FF C3 48 83 C5 08 3B 5F 50 7C DF 48 8B 0E 48 8B 5E 08 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B F3 48 85 DB 75 BA 48 8B 4F 60 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_30_0 {
	meta:
		name = "?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHPEAVVirtualProcessor@23@@Z"
		size = 370
		refs = "00c4 ??_U@YAPEAX_K@Z 00d9 memset 00e3 ??2@YAPEAX_K@Z 012a ?_UnderlyingYield@details@Concurrency@@YAXXZ 0139 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 41 55 41 57 48 83 EC 40 48 8B 59 58 33 F6 40 32 ED 4C 8B EA 48 8B F9 49 83 CB FF 44 8D 7E 01 44 39 5B 10 7C 53 4C 8B 0B 33 D2 39 57 50 7E 49 4D 8B C1 49 83 38 00 75 1B 8D 04 32 48 63 CA 41 89 85 9C 00 00 00 44 8B 57 70 33 C0 F0 4D 0F B1 2C C9 74 0E 41 03 D7 49 83 C0 08 3B 57 50 7D 19 EB D1 03 F2 41 8A EF 41 3B F2 7C 05 F0 44 01 7F 70 8B C2 F0 44 0F B1 5B 10 40 84 ED 0F 85 B4 00 00 00 B9 FE FF FF FF 41 8B C3 F0 0F B1 4B 10 03 77 50 48 83 7B 08 00 75 76 33 C0 F0 4C 0F B1 7B 08 75 6C 48 63 4F 50 B8 08 00 00 00 48 F7 E1 49 0F 40 C3 48 8B C8 E8 ?? ?? ?? ?? 4C 63 47 50 33 D2 49 C1 E0 03 48 8B C8 4C 8B E0 E8 ?? ?? ?? ?? B9 18 00 00 00 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 0E 48 83 60 08 00 83 48 10 FF 4C 89 20 EB 03 45 33 DB 48 63 47 6C 3B 47 68 7D 0F 48 8B C8 48 8B 47 60 4C 89 1C C8 44 01 7F 6C 4C 87 5B 08 4C 39 7B 08 75 21 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 39 7B 08 74 F0 48 8B 5B 08 49 C7 C3 FF FF FF FF 40 84 ED 0F 84 D6 FE FF FF 4C 8D 5C 24 40 8B C6 49 8B 5B 38 49 8B 6B 40 49 8B E3 41 5F 41 5D 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_1_31_0 {
	meta:
		name = "??0SchedulingNode@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z"
		size = 77
		refs = "002c ??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 51 08 33 C0 48 8B D9 89 41 10 89 41 14 89 41 18 48 8B 12 48 83 C1 20 41 B9 FF FF FF 7F 41 B8 00 01 00 00 E8 ?? ?? ?? ?? 4C 8B 5B 08 49 8B 03 48 89 03 41 8B 83 A4 00 00 00 89 43 1C 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_33_0 {
	meta:
		name = "?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEAUIVirtualProcessorRoot@3@_N@Z"
		size = 389
		refs = "002a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0037 __imp_InterlockedPopEntrySList 00ab ?ThrottlingTime@SchedulerBase@details@Concurrency@@QEAAKK@Z 00f4 ?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHPEAVVirtualProcessor@23@@Z 00ff ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QEAA_N_N@Z 0110 ?GetScheduleGroup@ContextBase@details@Concurrency@@QEBAPEAVScheduleGroupBase@23@XZ 011b ?GetAnonymousScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 56 48 83 EC 20 45 8A E8 4C 8B E2 48 8B F9 40 32 F6 E8 ?? ?? ?? ?? 48 8D 4F 20 48 8B E8 FF 15 ?? ?? ?? ?? 48 85 C0 74 1E 48 8D 98 10 FF FF FF 48 85 DB 74 12 4C 8B 0B 4D 8B C4 48 8B D7 48 8B CB 41 FF 51 30 EB 15 48 8B 0F 4D 8B C4 48 8B D7 48 8B 01 FF 90 A0 00 00 00 48 8B D8 41 BC 01 00 00 00 45 84 ED 74 44 44 88 A3 C0 00 00 00 48 8D 4D F0 48 89 8B C8 00 00 00 48 89 99 E8 00 00 00 48 8B 0F 48 8B 11 FF 52 58 84 C0 74 1B 48 8B 0F 41 8B D4 E8 ?? ?? ?? ?? 85 C0 74 0C 41 8A F4 44 88 A3 C3 00 00 00 EB 03 40 32 F6 F0 44 01 67 14 40 84 F6 75 7F 48 8B 07 44 8B 80 7C 01 00 00 45 85 C0 75 52 48 8B 07 44 8B 40 1C 45 85 C0 7E 46 33 C0 48 8D 4F 20 48 8B D3 87 43 08 E8 ?? ?? ?? ?? 48 8B 0F 41 8A D4 E8 ?? ?? ?? ?? 84 C0 74 5C 48 85 ED 74 0A 48 8B CD E8 ?? ?? ?? ?? EB 09 48 8B 4F 08 E8 ?? ?? ?? ?? 48 8B D0 48 8B 03 48 8B CB FF 50 38 EB 36 F0 44 01 67 10 48 8B 07 F0 44 01 A0 7C 01 00 00 48 8D 4F 20 48 8B D3 E8 ?? ?? ?? ?? EB 18 48 8D 4F 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D3 48 8B 01 FF 50 60 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 8B C3 48 8B 5C 24 40 48 83 C4 20 41 5E 41 5D 41 5C C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_calloc_impl"
		size = 154
		refs = "0024 _errno 004d _crtheap 0059 __imp_HeapAlloc 0064 _newmode 006f _callnewh"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 49 8B D8 48 8B FA 48 85 C9 74 1D 33 D2 48 8D 42 E0 48 F7 F1 48 3B C7 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 5D 48 0F AF F9 B8 01 00 00 00 48 85 FF 48 0F 44 F8 33 C0 48 83 FF E0 77 18 48 8B 0D ?? ?? ?? ?? 8D 50 08 4C 8B C7 FF 15 ?? ?? ?? ?? 48 85 C0 75 2D 83 3D ?? ?? ?? ?? 00 74 19 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 CB 48 85 DB 74 B2 C7 03 0C 00 00 00 EB AA 48 85 DB 74 06 C7 03 0C 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_mbccpy_l"
		size = 29
		refs = "0014 _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 45 33 C0 4C 8B CA 41 8D 50 02 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_mbccpy"
		size = 30
		refs = "0015 _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C0 4C 8B CA 41 8D 50 02 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "rename"
		size = 47
		refs = "0006 __imp_MoveFileA 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_742_0_0 {
	meta:
		name = "_rmdir"
		size = 47
		refs = "0006 __imp_RemoveDirectoryA 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "_wremove"
		size = 47
		refs = "0006 __imp_DeleteFileW 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "_wrename"
		size = 47
		refs = "0006 __imp_MoveFileW 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "_wrmdir"
		size = 47
		refs = "0006 __imp_RemoveDirectoryW 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "remove"
		size = 47
		refs = "0006 __imp_DeleteFileA 0010 __imp_GetLastError 001f _dosmaperr"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "sin"
		size = 1165
		refs = "0088 L__real_3fc5555555555555 00b4 L__real_3fe0000000000000 00c4 Lsinarray 0153 L__real_411E848000000000 0165 L__real_3fe45f306dc9c883 0188 L__real_3ff921fb54400000 0194 L__real_3dd0b4611a626331 01b8 L__real_3dd0b4611a600000 01c5 L__real_3ba3198a2e037073 0254 L__real_3ff0000000000000 02b1 __remainder_piby2 03a0 Lcosarray 0481 _sin_special"
	strings:
		$1 = { 48 81 EC F8 00 00 00 66 0F 57 D2 F2 0F 11 04 24 48 8B 14 24 48 B8 00 00 00 00 00 00 F0 7F 4C 8B D0 4C 23 D2 4C 3B D0 0F 84 53 04 00 00 49 BA FF FF FF FF FF FF FF 7F 4C 23 D2 41 B8 01 00 00 00 48 B8 18 2D 44 54 FB 21 E9 3F 4C 3B D0 0F 8F DD 00 00 00 48 B8 00 00 00 00 00 00 20 3F 4C 3B D0 7D 4E 48 B8 00 00 00 00 00 00 40 3E 4C 3B D0 7D 0F E9 FA 03 00 00 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 D0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 59 D0 F2 0F 59 D4 F2 0F 5C C2 E9 CF 03 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 D0 F2 0F 59 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 CA F2 0F 59 CA F2 0F 59 EA F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 DA F2 0F 59 E2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 DD F2 0F 59 E3 F2 0F 58 C4 E9 47 03 00 00 0F 1F 80 00 00 00 00 49 3B D2 41 BB 00 00 00 00 74 15 41 BB 01 00 00 00 F2 0F 5C D0 F2 0F 10 C2 0F 1F 80 00 00 00 00 4C 3B 15 ?? ?? ?? ?? 0F 83 33 01 00 00 F2 0F 10 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 D3 4D 8B CA 49 C1 E9 34 F2 0F 58 D5 F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 F2 0F 10 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? F2 0F 11 04 24 F2 0F 10 2D ?? ?? ?? ?? 48 8B 0C 24 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 F2 0F 10 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 F2 0F 10 C4 F2 0F 10 CD F2 0F 5C C5 F2 0F 5C E0 F2 0F 5C E1 48 81 F9 F2 03 00 00 0F 8D C6 00 00 00 48 81 F9 DE 03 00 00 7E 4D F2 0F 10 D0 F2 0F 59 D2 44 23 C0 75 20 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 DA F2 0F 5C C3 E9 F7 01 00 00 0F 1F 80 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 D7 01 00 00 0F 1F 80 00 00 00 00 44 23 C0 0F 84 C7 01 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 BA 01 00 00 66 66 0F 1F 84 00 00 00 00 00 4C 89 1C 24 4C 8D 8C 24 C0 00 00 00 4C 8D 84 24 B0 00 00 00 48 8D 94 24 A0 00 00 00 48 83 EC 20 E8 ?? ?? ?? ?? 48 83 C4 20 4C 8B 1C 24 41 B8 01 00 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 10 A4 24 B0 00 00 00 8B 84 24 C0 00 00 00 0F 1F 40 00 F2 0F 10 D8 F2 0F 10 D0 F2 0F 59 D0 44 23 C0 0F 85 9B 00 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 2D ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 CA F2 0F 59 CA F2 0F 11 44 24 10 F2 0F 59 EA F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 DA F2 0F 59 E2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 04 24 F2 0F 59 D9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 DD F2 0F 59 E3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 58 44 24 10 E9 BC 00 00 00 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 59 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 EA F2 0F 10 DA F2 0F 11 24 24 F2 0F 59 CA F2 0F 59 C2 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E2 F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 5C EC F2 0F 59 CB F2 0F 58 C1 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 5C 2C 24 F2 0F 59 C2 F2 0F 58 C5 F2 0F 5C C4 66 66 0F 1F 84 00 00 00 00 00 D1 E8 8B C8 41 23 C3 F7 D1 41 F7 D3 41 23 CB 0B C1 83 E0 01 75 1A F2 0F 10 D0 66 0F 57 C0 F2 0F 5C C2 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 48 81 C4 F8 00 00 00 C3 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 49
		refs = "002b _invoke_watson"
	strings:
		$1 = { 85 C9 74 2C 53 48 83 EC 30 48 8B 44 24 68 4D 8B D1 44 8B 4C 24 60 4D 8B D8 48 8B DA 4D 8B C2 49 8B D3 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? CC C3 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_tsopen_nolock"
		size = 1960
		refs = "005e _get_fmode 00a4 __doserrno 00ae _errno 00ba _invalid_parameter_noinfo 01a6 _umaskval 01fc _alloc_osfhnd 0254 __imp_CreateFileW 02bd __pioinfo 02da __imp_GetLastError 02e1 _dosmaperr 02f6 __imp_GetFileType 0334 __imp_CloseHandle 0364 _set_osfhnd 03d1 _lseek_nolock 03ed _close_nolock 0407 _read_nolock 041d _chsize_nolock 053a _lseeki64_nolock 0651 _write 076a _free_osfhnd 07a3 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 4C 89 44 24 18 48 89 4C 24 08 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 33 FF 41 B5 80 41 8B F1 48 8B DA C7 45 E8 18 00 00 00 44 8D 67 01 89 7D D8 40 88 7D 58 48 89 7D F0 45 84 CD 74 08 89 7D F8 41 B7 10 EB 07 44 89 65 F8 44 8A FF 48 8D 4D D8 E8 ?? ?? ?? ?? 85 C0 0F 85 29 07 00 00 B8 00 80 00 00 85 F0 75 10 F7 C6 00 40 07 00 75 05 39 45 D8 74 03 45 0A FD 8B CE 41 B9 03 00 00 00 B8 00 00 00 C0 41 23 C9 41 B8 00 00 00 80 74 5B FF C9 74 41 FF C9 74 38 E8 ?? ?? ?? ?? 89 38 83 0B FF E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 9C 24 C8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 44 8B F0 EB 19 40 F6 C6 08 74 08 F7 C6 00 00 07 00 75 ED 41 BE 00 00 00 40 EB 03 45 8B F0 8B 4D 60 44 89 75 C0 41 BD 02 00 00 00 83 E9 10 74 2D 83 E9 10 74 23 83 E9 10 74 19 83 E9 10 74 0F 83 F9 40 75 84 45 3B F0 8B D7 0F 94 C2 EB 11 41 8B D1 EB 0C 41 8B D5 EB 07 41 8B D4 EB 02 8B D7 8B C6 B9 00 07 00 00 89 55 C4 23 C1 41 B8 00 01 00 00 74 46 41 3B C0 74 39 3D 00 02 00 00 74 2A 3D 00 03 00 00 74 1E 3D 00 04 00 00 74 2C 3D 00 05 00 00 74 28 3D 00 06 00 00 74 0E 3B C1 74 1D E9 24 FF FF FF 45 8B E5 EB 13 41 BC 05 00 00 00 EB 0B 41 BC 04 00 00 00 EB 03 45 8B E1 B9 80 00 00 00 89 4D CC 41 85 F0 74 16 8A 05 ?? ?? ?? ?? F6 D0 22 45 68 A8 80 8D 41 81 0F 44 C8 89 4D CC 40 F6 C6 40 74 16 0F BA E9 1A 41 0F BA EE 10 83 CA 04 89 55 C4 89 4D CC 44 89 75 C0 0F BA E6 0C 73 06 41 0B C8 89 4D CC 40 F6 C6 20 74 06 0F BA E9 1B EB 0A 40 F6 C6 10 74 07 0F BA E9 1C 89 4D CC E8 ?? ?? ?? ?? 89 03 83 F8 FF 75 21 E8 ?? ?? ?? ?? 89 38 83 0B FF E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 98 FE FF FF 48 8B 45 40 44 8B 45 C4 48 8B 4D 50 C7 00 01 00 00 00 8B 45 CC 48 89 7C 24 30 89 44 24 28 4C 8D 4D E8 41 8B D6 44 89 64 24 20 FF 15 ?? ?? ?? ?? 48 89 45 E0 48 83 F8 FF 0F 85 8B 00 00 00 B9 00 00 00 C0 41 8B C6 23 C1 3B C1 75 43 B8 01 00 00 00 40 84 F0 74 39 8B 45 CC 44 8B 45 C4 48 8B 4D 50 41 0F BA F6 1F 48 89 7C 24 30 89 44 24 28 4C 8D 4D E8 41 8B D6 44 89 64 24 20 44 89 75 C0 FF 15 ?? ?? ?? ?? 48 89 45 E0 48 83 F8 FF 75 3A 48 63 0B 4C 8D 35 ?? ?? ?? ?? 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 49 8B 04 C6 80 64 08 08 FE FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 38 E9 9B 04 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 75 4B 48 63 0B 4C 8D 35 ?? ?? ?? ?? 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 49 8B 04 C6 80 64 08 08 FE FF 15 ?? ?? ?? ?? 8B C8 8B D8 E8 ?? ?? ?? ?? 48 8B 4D E0 FF 15 ?? ?? ?? ?? 85 DB 75 A9 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB 9C 41 3B C5 75 06 41 80 CF 40 EB 09 83 F8 03 75 04 41 80 CF 08 48 8B 55 E0 8B 0B E8 ?? ?? ?? ?? 48 63 0B 4C 8D 35 ?? ?? ?? ?? 48 8B C1 83 E1 1F 41 B8 01 00 00 00 48 C1 F8 05 45 0A F8 49 8B 04 C6 48 6B C9 58 44 88 7C 08 08 48 63 0B 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 49 8B 04 C6 80 64 08 38 80 41 8A C7 24 48 88 45 D0 0F 85 83 00 00 00 45 84 FF 0F 89 A5 02 00 00 41 84 F5 74 75 8B 0B 45 8B C5 83 CA FF E8 ?? ?? ?? ?? 89 45 C8 83 F8 FF 75 19 E8 ?? ?? ?? ?? 81 38 83 00 00 00 74 4D 8B 0B E8 ?? ?? ?? ?? E9 EF FE FF FF 8B 0B 48 8D 55 D4 41 B8 01 00 00 00 66 89 7D D4 E8 ?? ?? ?? ?? 85 C0 75 17 66 83 7D D4 1A 75 10 48 63 55 C8 8B 0B E8 ?? ?? ?? ?? 83 F8 FF 74 C4 8B 0B 45 33 C0 33 D2 E8 ?? ?? ?? ?? 83 F8 FF 74 B3 41 B8 01 00 00 00 45 84 FF 0F 89 22 02 00 00 BA 00 40 07 00 B9 00 40 00 00 85 F2 75 0D 8B 45 D8 23 C2 75 04 0B F1 EB 02 0B F0 8B C6 23 C2 3B C1 74 43 3D 00 00 01 00 74 29 3D 00 40 01 00 74 22 3D 00 00 02 00 74 28 3D 00 40 02 00 74 21 3D 00 00 04 00 74 07 3D 00 40 04 00 75 1D 44 88 45 58 EB 17 B9 01 03 00 00 8B C6 23 C1 3B C1 75 0A 44 88 6D 58 EB 04 40 88 7D 58 F7 C6 00 00 07 00 0F 84 AC 01 00 00 41 F6 C7 40 44 8B 7D C0 89 7D C8 0F 85 9F 01 00 00 41 8B C7 B9 00 00 00 C0 23 C1 3D 00 00 00 40 0F 84 0D 01 00 00 3D 00 00 00 80 74 70 3B C1 0F 85 7B 01 00 00 45 85 E4 0F 84 72 01 00 00 45 3B E5 76 10 41 83 FC 04 76 2D 41 83 FC 05 0F 85 5D 01 00 00 0F BE 4D 58 44 8B E7 FF C9 0F 84 15 01 00 00 FF C9 0F 85 46 01 00 00 C7 45 C8 FF FE 00 00 E9 0E 01 00 00 8B 0B 45 8B C5 33 D2 E8 ?? ?? ?? ?? 48 85 C0 74 CC 8B 0B 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 91 FE FF FF 8B 0B 48 8D 55 C8 41 B8 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 77 FE FF FF 41 3B C5 74 1B 83 F8 03 75 61 81 7D C8 EF BB BF 00 75 0D 44 8D 40 FE 44 88 45 58 E9 DF 00 00 00 0F B7 45 C8 3D FE FF 00 00 75 1A 8B 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 8B FB E9 D4 01 00 00 3D FF FE 00 00 75 1F 8B 0B 45 33 C0 41 8B D5 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 15 FE FF FF 44 88 6D 58 E9 8E 00 00 00 8B 0B 45 33 C0 33 D2 E8 ?? ?? ?? ?? 83 F8 FF EB 3D 45 85 E4 74 78 45 3B E5 0F 86 12 FF FF FF 41 83 FC 04 0F 87 FE FE FF FF 8B 0B 45 8B C5 33 D2 E8 ?? ?? ?? ?? 48 85 C0 0F 84 F3 FE FF FF 8B 0B 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 83 F8 FF 75 3E E9 B7 FD FF FF C7 45 C8 EF BB BF 00 41 BD 03 00 00 00 8B 0B 49 63 C4 45 8B C5 48 8D 54 05 C8 45 2B C4 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 8C FD FF FF 44 03 E0 45 3B EC 7F DA EB 04 44 8B 7D C0 41 B8 01 00 00 00 48 63 0B 44 8A 65 58 48 8B C1 83 E1 1F 41 80 E4 7F 48 C1 F8 05 48 6B C9 58 49 8B 04 C6 80 64 08 38 80 44 08 64 08 38 48 63 13 48 8B C2 83 E2 1F 48 C1 F8 05 48 6B D2 58 49 8B 0C C6 8B C6 80 64 11 38 7F C1 E8 10 C0 E0 07 08 44 11 38 40 38 7D D0 75 20 40 F6 C6 08 74 1A 48 63 0B 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 49 8B 04 C6 80 4C 08 08 20 B9 00 00 00 C0 41 8B C7 23 C1 3B C1 0F 85 95 00 00 00 41 84 F0 0F 84 8C 00 00 00 48 8B 4D E0 FF 15 ?? ?? ?? ?? 8B 45 CC 44 8B 45 C4 48 8B 4D 50 48 89 7C 24 30 89 44 24 28 41 0F BA F7 1F 4C 8D 4D E8 C7 44 24 20 03 00 00 00 41 8B D7 FF 15 ?? ?? ?? ?? 48 83 F8 FF 75 35 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 63 1B 49 8B C3 41 83 E3 1F 48 C1 F8 05 4D 6B DB 58 49 8B 04 C6 42 80 64 18 08 FE 8B 0B E8 ?? ?? ?? ?? E9 72 FB FF FF 48 63 13 48 8B CA 83 E2 1F 48 C1 F9 05 48 6B D2 58 49 8B 0C CE 48 89 04 0A 8B C7 E9 2D F9 FF FF 45 33 C9 45 33 C0 33 D2 33 C9 48 89 7C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_7_2_0 {
	meta:
		name = "_wopen"
		size = 213
		refs = "002c _errno 0037 _invalid_parameter_noinfo 006e _tsopen_nolock 0095 __pioinfo 00b2 _unlock_fhandle"
		altNames = "_open"
	strings:
		$1 = { 48 8B C4 89 50 10 4C 89 40 18 4C 89 48 20 53 57 48 83 EC 48 83 48 D8 FF 83 60 DC 00 45 33 C0 48 85 C9 41 0F 95 C0 45 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 8B 00 00 00 48 8D 44 24 70 48 83 C0 08 44 8B 40 F8 44 89 44 24 28 C7 44 24 20 40 00 00 00 44 8B CA 4C 8B C1 48 8D 54 24 30 48 8D 4C 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 83 7C 24 34 00 74 39 85 C0 74 28 48 63 5C 24 30 48 8B CB 48 8B C3 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE EB 04 8B 5C 24 30 8B CB E8 ?? ?? ?? ?? EB 04 8B 5C 24 30 85 FF 74 0C E8 ?? ?? ?? ?? 89 38 E9 6F FF FF FF 8B C3 48 83 C4 48 5F 5B C3 }
	condition:
		$1
}

rule file_7_3_0 {
	meta:
		name = "_wopen$fin$0"
		size = 78
		refs = "0026 __pioinfo 0042 _unlock_fhandle"
		altNames = "_open$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 83 7D 34 00 74 38 83 7D 38 00 74 27 48 63 55 30 48 8B CA 48 8B C2 48 C1 F8 05 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 49 8B 04 C0 80 64 08 08 FE EB 03 8B 55 30 8B CA E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_7_4_0 {
	meta:
		name = "_wsopen_helper"
		size = 210
		refs = "0021 _errno 002d _invalid_parameter_noinfo 007a _tsopen_nolock 009c __pioinfo 00b3 _unlock_fhandle"
		altNames = "_sopen_helper"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 83 64 24 30 00 33 C0 48 8B 7C 24 70 48 85 FF 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 8F 00 00 00 83 0F FF 33 C0 48 85 C9 0F 95 C0 85 C0 74 D9 83 7C 24 78 00 74 13 41 F7 C1 7F FE FF FF B8 00 00 00 00 0F 94 C0 85 C0 74 BF 44 89 4C 24 28 44 89 44 24 20 44 8B CA 4C 8B C1 48 8B D7 48 8D 4C 24 30 E8 ?? ?? ?? ?? 8B D8 89 44 24 34 83 7C 24 30 00 74 2C 85 C0 74 21 48 63 0F 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 0F E8 ?? ?? ?? ?? 85 DB 0F 84 72 FF FF FF 83 0F FF E9 6A FF FF FF 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_7_5_0 {
	meta:
		name = "_wsopen_helper$fin$0"
		size = 73
		refs = "0026 __pioinfo 003d _unlock_fhandle"
		altNames = "_sopen_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 83 7D 30 00 74 33 48 8B 55 70 83 7D 34 00 74 21 48 63 0A 48 8B C1 48 C1 F8 05 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 49 8B 04 C0 80 64 08 08 FE 8B 0A E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_7_6_0 {
	meta:
		name = "_wsopen"
		size = 65
		refs = "002c _wsopen_helper"
	strings:
		$1 = { 4C 8B DC 45 89 43 18 4D 89 4B 20 53 48 83 EC 40 83 64 24 28 00 4D 8D 4B E8 49 8D 43 20 4D 89 4B D8 44 8B 08 83 CB FF 89 5C 24 30 E8 ?? ?? ?? ?? 8B 4C 24 30 85 C0 0F 45 CB 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_590_6_0 {
	meta:
		name = "_sopen"
		size = 65
		refs = "002c _sopen_helper"
	strings:
		$1 = { 4C 8B DC 45 89 43 18 4D 89 4B 20 53 48 83 EC 40 83 64 24 28 00 4D 8D 4B E8 49 8D 43 20 4D 89 4B D8 44 8B 08 83 CB FF 89 5C 24 30 E8 ?? ?? ?? ?? 8B 4C 24 30 85 C0 0F 45 CB 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_7_7_0 {
	meta:
		name = "_wsopen_s"
		size = 50
		refs = "0029 _wsopen_helper"
	strings:
		$1 = { 48 83 EC 38 41 8B C1 44 8B 4C 24 60 45 8B D0 4C 8B DA C7 44 24 28 01 00 00 00 48 89 4C 24 20 44 8B C0 41 8B D2 49 8B CB E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_590_7_0 {
	meta:
		name = "_sopen_s"
		size = 50
		refs = "0029 _sopen_helper"
	strings:
		$1 = { 48 83 EC 38 41 8B C1 44 8B 4C 24 60 45 8B D0 4C 8B DA C7 44 24 28 01 00 00 00 48 89 4C 24 20 44 8B C0 41 8B D2 49 8B CB E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_RTC_InitBase"
		size = 56
		refs = "0006 ?init@?1??_RTC_InitBase@@9@4_NA 0027 _CRT_RTC_INITW 002f _RTC_SetErrorFuncW"
	strings:
		$1 = { 48 83 EC 38 80 3D ?? ?? ?? ?? 00 75 26 83 64 24 20 00 41 B9 01 00 00 00 45 33 C0 33 D2 33 C9 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "_RTC_Shutdown"
		size = 32
		refs = "0017 _CRT_RTC_INITW"
	strings:
		$1 = { 48 83 EC 38 41 B9 01 00 00 00 45 33 C0 33 D2 33 C9 44 89 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "_resetstkoflw"
		size = 294
		refs = "002a __security_cookie 0054 __imp_VirtualQuery 006b __imp_GetSystemInfo 007d __imp_SetThreadStackGuarantee 00d0 __imp_VirtualAlloc 00ea __imp_VirtualProtect 0103 __security_check_cookie"
	strings:
		$1 = { 40 55 41 54 41 55 48 81 EC 90 00 00 00 48 8D 6C 24 20 48 89 9D 90 00 00 00 48 89 B5 98 00 00 00 48 89 BD A0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 68 8B 04 24 48 83 EC 10 4C 8D 64 24 20 41 8B 04 24 48 8D 55 08 41 B8 30 00 00 00 49 8B CC FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 98 00 00 00 4C 8B 6D 10 48 8D 4D 38 FF 15 ?? ?? ?? ?? 8B 7D 3C 48 8D 4D 00 33 DB 21 5D 00 FF 15 ?? ?? ?? ?? 85 C0 74 08 8B 45 00 85 C0 0F 45 D8 8D 57 FF 8D 4C 3B FF 8B C2 F7 D0 23 C8 74 02 03 CF 8D 04 3F 8B DA 3B C8 48 F7 D3 0F 42 C8 49 23 DC 49 8D 44 3D 00 8B F1 48 2B DE 48 3B D8 72 3C 41 B9 04 00 00 00 41 B8 00 10 00 00 8B D6 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0 74 20 4C 8D 4D 04 41 B8 04 01 00 00 8B D6 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 07 B8 01 00 00 00 EB 02 33 C0 48 8B 4D 68 48 33 CD E8 ?? ?? ?? ?? 48 8B 9D 90 00 00 00 48 8B B5 98 00 00 00 48 8B BD A0 00 00 00 48 8D 65 70 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 61
		refs = "0031 _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 4D 8B D1 85 C9 74 2B 3B CA 74 05 41 3B C8 75 22 48 8B 44 24 78 44 8B 4C 24 70 4C 8B 44 24 68 48 8B 54 24 60 49 8B CA 48 89 44 24 20 E8 ?? ?? ?? ?? CC 8B C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "system"
		size = 264
		refs = "0018 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0029 _dupenv_s 0046 _invoke_watson 0064 _access_s 0072 ??_C@_02HNHPBPFE@?1c?$AA@ 0088 _errno 00a3 _spawnve 00d5 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 00e7 _spawnvpe 00f2 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 18 55 48 8B EC 48 83 EC 50 48 8B F9 4C 8D 05 ?? ?? ?? ?? 48 8D 4D 18 33 DB 33 D2 48 89 5D 18 E8 ?? ?? ?? ?? 85 C0 74 1A 83 F8 16 75 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 4D 18 48 89 4D E0 48 85 FF 75 17 48 85 C9 0F 84 90 00 00 00 33 D2 E8 ?? ?? ?? ?? 85 C0 0F 94 C3 EB 7E 48 8D 05 ?? ?? ?? ?? 48 89 7D F0 48 89 5D F8 48 89 45 E8 48 85 C9 74 4B E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 4C 8D 45 E0 89 18 48 8B 55 E0 45 33 C9 33 C9 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 09 E8 ?? ?? ?? ?? 89 38 EB 36 E8 ?? ?? ?? ?? 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 22 E8 ?? ?? ?? ?? 89 38 48 8D 15 ?? ?? ?? ?? 4C 8D 45 E0 45 33 C9 33 C9 48 89 55 E0 E8 ?? ?? ?? ?? 8B D8 48 8B 4D 18 E8 ?? ?? ?? ?? 48 8B 7C 24 70 8B C3 48 8B 5C 24 60 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_653_1_0 {
	meta:
		name = "_wsystem"
		size = 264
		refs = "0018 ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 0029 _wdupenv_s 0046 _invoke_watson 0064 _waccess_s 0072 ??_C@_15JBFELBFC@?$AA?1?$AAc?$AA?$AA@ 0088 _errno 00a3 _wspawnve 00d5 ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00e7 _wspawnvpe 00f2 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 18 55 48 8B EC 48 83 EC 50 48 8B F9 4C 8D 05 ?? ?? ?? ?? 48 8D 4D 18 33 DB 33 D2 48 89 5D 18 E8 ?? ?? ?? ?? 85 C0 74 1A 83 F8 16 75 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 4D 18 48 89 4D E0 48 85 FF 75 17 48 85 C9 0F 84 90 00 00 00 33 D2 E8 ?? ?? ?? ?? 85 C0 0F 94 C3 EB 7E 48 8D 05 ?? ?? ?? ?? 48 89 7D F0 48 89 5D F8 48 89 45 E8 48 85 C9 74 4B E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 4C 8D 45 E0 89 18 48 8B 55 E0 45 33 C9 33 C9 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 09 E8 ?? ?? ?? ?? 89 38 EB 36 E8 ?? ?? ?? ?? 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 22 E8 ?? ?? ?? ?? 89 38 48 8D 15 ?? ?? ?? ?? 4C 8D 45 E0 45 33 C9 33 C9 48 89 55 E0 E8 ?? ?? ?? ?? 8B D8 48 8B 4D 18 E8 ?? ?? ?? ?? 48 8B 7C 24 70 8B C3 48 8B 5C 24 60 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_wexeclpe"
		size = 183
		refs = "0024 _errno 002f _invalid_parameter_noinfo 0066 _wcapture_argv 008b _wexecvpe 00a5 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 30 02 00 00 33 F6 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 73 66 39 31 74 E5 48 85 D2 74 E0 66 39 32 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 89 74 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 30 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_549_0_0 {
	meta:
		name = "_wexecle"
		size = 183
		refs = "0024 _errno 002f _invalid_parameter_noinfo 0066 _wcapture_argv 008b _wexecve 00a5 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 30 02 00 00 33 F6 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 73 66 39 31 74 E5 48 85 D2 74 E0 66 39 32 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 89 74 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 30 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
		size = 161
		refs = "0013 _getptd 0033 __ptlocinfo 0041 __globallocalestatus 0048 __updatetlocinfo 0052 __ptmbcinfo 006f __updatetmbcinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 C6 41 18 00 48 85 D2 75 7F E8 ?? ?? ?? ?? 48 89 43 10 48 8B 90 C0 00 00 00 48 89 13 48 8B 88 B8 00 00 00 48 89 4B 08 48 3B 15 ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 89 03 48 8B 05 ?? ?? ?? ?? 48 39 43 08 74 1B 48 8B 43 10 8B 88 C8 00 00 00 85 0D ?? ?? ?? ?? 75 09 E8 ?? ?? ?? ?? 48 89 43 08 48 8B 43 10 F6 80 C8 00 00 00 02 75 14 83 88 C8 00 00 00 02 C6 43 18 01 EB 07 0F 10 02 F3 0F 7F 01 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 18
	strings:
		$1 = { 80 79 18 00 74 0B 48 8B 41 10 83 A0 C8 00 00 00 FD C3 }
	condition:
		$1
}

rule file_12_3_0 {
	meta:
		name = "_mbslen_l"
		size = 101
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0022 strlen"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 54 24 28 83 7A 08 00 75 0A 48 8B CB E8 ?? ?? ?? ?? EB 24 33 C9 EB 17 0F B6 C0 F6 44 10 1D 04 74 08 48 FF C3 80 3B 00 74 0B FF C1 48 FF C3 8A 03 84 C0 75 E3 48 63 C1 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_wgetdcwd_nolock"
		size = 337
		refs = "000e __security_cookie 002a _validdrive 0033 __doserrno 003e _errno 0049 _invalid_parameter_noinfo 0053 _getdrive 00b4 __imp_GetFullPathNameW 00e9 calloc 012c __imp_GetLastError 0133 _dosmaperr 0142 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 45 33 E4 41 8B F8 48 8B DA 8B F1 85 C9 74 29 E8 ?? ?? ?? ?? 85 C0 75 27 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? E9 E5 00 00 00 E8 ?? ?? ?? ?? 8B F0 48 85 DB 74 19 85 FF 7F 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D9 8B EF 66 44 89 23 EB 03 41 8B EC 85 F6 74 1D 66 83 C6 40 B8 3A 00 00 00 C7 44 24 2C 2E 00 00 00 66 89 74 24 28 66 89 44 24 2A EB 08 C7 44 24 28 2E 00 00 00 4C 8D 4C 24 20 48 8D 4C 24 28 4C 8B C3 8B D5 FF 15 ?? ?? ?? ?? 85 C0 74 6E 48 85 DB 74 1A 3B C5 7D 05 48 8B C3 EB 6F E8 ?? ?? ?? ?? C7 00 22 00 00 00 66 44 89 23 EB 5C 3B C7 BA 02 00 00 00 0F 4F F8 48 63 CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 EB 2A 4C 8D 4C 24 20 48 8D 4C 24 28 4C 8B C0 8B D7 FF 15 ?? ?? ?? ?? 85 C0 74 04 3B C7 7C 9B FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "_wgetcwd"
		size = 66
		refs = "0015 _lock 0023 _wgetdcwd_nolock 0030 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 44 8B C3 48 8B D7 33 C9 E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_755_2_0 {
	meta:
		name = "_getcwd"
		size = 66
		refs = "0015 _lock 0023 _getdcwd_nolock 0030 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 44 8B C3 48 8B D7 33 C9 E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "_wgetcwd$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_chdrive$fin$0 _getcwd$fin$0 _getdcwd$fin$0 _putenv$fin$0 _putenv_s$fin$0 _wgetdcwd$fin$0 _wgetenv$fin$0 _wputenv$fin$0 _wputenv_s$fin$0 getenv$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "_wgetdcwd"
		size = 79
		refs = "001d _lock 002b _wgetdcwd_nolock 0038 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8B D8 48 8B FA 8B F1 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 44 8B C3 48 8B D7 8B CE E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_755_4_0 {
	meta:
		name = "_getdcwd"
		size = 79
		refs = "001d _lock 002b _getdcwd_nolock 0038 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8B D8 48 8B FA 8B F1 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 44 8B C3 48 8B D7 8B CE E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "_wstripquote"
		size = 128
		refs = "0017 wcslen 0023 _calloc_crt 006a free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B D9 8B FE E8 ?? ?? ?? ?? 8D 56 02 48 8D 48 01 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 3F 48 8B C8 0F B7 03 66 85 C0 74 2F 66 83 F8 22 75 08 48 83 C3 02 FF C7 EB 0C 66 41 89 03 49 83 C3 02 48 83 C3 02 0F B7 03 66 85 C0 75 DE 85 FF 74 09 66 41 89 33 48 8B C1 EB 07 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "_wtempnam"
		size = 665
		refs = "002f _mtinitlocknum 0041 ??_C@_17DDHKMLLK@?$AAT?$AAM?$AAP?$AA?$AA@ 004d _wdupenv_s 006a _invoke_watson 0080 _waccess_s 00a7 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 00ba ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00cd wcslen 00e8 calloc 0106 wcscat_s 0193 _lock 019a _tempoff 01a6 _old_pfxlen 01bb _errno 01e5 free 0207 _ultow_s 023c _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 41 54 41 55 41 56 41 57 48 83 EC 30 48 8B F2 48 8B F9 45 33 FF 45 8B EF 4C 89 7C 24 70 41 8D 5F 02 8B CB E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 43 02 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 70 E8 ?? ?? ?? ?? 85 C0 74 1E 83 F8 16 75 15 4C 89 7C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 85 C0 75 1C 48 8B 4C 24 70 48 85 C9 74 12 33 D2 E8 ?? ?? ?? ?? 85 C0 75 07 48 8B 7C 24 70 EB 35 48 85 FF 74 0E 33 D2 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 22 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 85 C0 48 0F 45 F9 48 85 F6 74 0B 48 8B CE E8 ?? ?? ?? ?? 4C 8B E8 48 8B CF E8 ?? ?? ?? ?? 42 8D 4C 28 0C 44 8B E1 48 8B D3 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 74 01 00 00 66 44 89 38 4C 8B C7 41 8B D4 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 45 01 00 00 48 8B CF E8 ?? ?? ?? ?? 66 83 7C 47 FE 5C 74 33 66 83 7C 47 FE 2F 74 2B 4C 8D 05 ?? ?? ?? ?? 41 8B D4 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 15 4C 89 7C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 85 F6 74 27 4C 8B C6 49 8B D4 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 15 4C 89 7C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B CB E8 ?? ?? ?? ?? 4C 8D 34 43 B9 02 00 00 00 E8 ?? ?? ?? ?? 90 8B 3D ?? ?? ?? ?? B8 01 00 00 00 44 39 2D ?? ?? ?? ?? 0F 42 F8 89 3D ?? ?? ?? ?? 44 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 30 8B 0D ?? ?? ?? ?? FF C1 89 0D ?? ?? ?? ?? 8B C1 2B C7 3D FF FF FF 7F 76 14 E8 ?? ?? ?? ?? 89 30 48 8B CB E8 ?? ?? ?? ?? 49 8B DF EB 48 49 8B C6 48 2B C3 48 D1 F8 4D 8B C4 4C 2B C0 41 B9 0A 00 00 00 49 8B D6 E8 ?? ?? ?? ?? 85 C0 75 33 E8 ?? ?? ?? ?? 44 89 38 33 D2 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 9C E8 ?? ?? ?? ?? 83 38 0D 74 92 E8 ?? ?? ?? ?? 89 30 B9 02 00 00 00 E8 ?? ?? ?? ?? EB 2A 4C 89 7C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 4C 89 7C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 4C 24 70 E8 ?? ?? ?? ?? 49 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "_wtempnam$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_tempnam$fin$0 _tmpnam_helper$fin$0 _wperror$fin$0 _wtmpnam_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 02 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "??0logic_error@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "??0bad_alloc@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_8_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_0_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_34_0 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_10_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_27_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_24_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_21_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_67_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_12_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_15_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_18_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_40_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_61_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_52_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_64_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_43_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_49_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_46_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_37_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_30_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_55_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_58_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_56_9_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_9_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_70_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_445_6_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_20_0 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_2_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_10_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_72_11_1 {
	meta:
		name = "??0range_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7range_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@G_K@Z"
		size = 61
		refs = "001f memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 0F B7 DA 33 D2 49 8B F0 44 8D 42 10 48 8B F9 E8 ?? ?? ?? ?? 66 89 5F 08 48 8B 5C 24 30 48 89 37 48 8B 74 24 38 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_5_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@AEBU012@@Z"
		size = 29
		refs = "0010 memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 41 B8 10 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_6_0 {
	meta:
		name = "??8HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 27
	strings:
		$1 = { 0F B7 41 08 66 39 42 08 75 0E 48 8B 01 48 39 02 75 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_17_7_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 34
	strings:
		$1 = { 0F B7 41 08 45 33 C0 66 39 42 08 75 0C 48 8B 01 48 39 02 41 8D 40 01 74 03 41 8B C0 84 C0 0F 94 C0 C3 }
	condition:
		$1
}

rule file_17_8_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QEAAAEAU012@AEBU012@@Z"
		size = 18
	strings:
		$1 = { 0F B7 42 08 66 89 41 08 48 8B 02 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_17_14_0 {
	meta:
		name = "??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
		size = 22
		refs = "0003 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 000d ??_7ExecutionResource@details@Concurrency@@6B@"
		altNames = "??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 08 C3 }
	condition:
		$1
}

rule file_17_21_0 {
	meta:
		name = "?DeleteThis@VirtualProcessorRoot@details@Concurrency@@UEAAXXZ"
		size = 25
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 40 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_17_22_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 49
		refs = "0009 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0016 ??_7ExecutionResource@details@Concurrency@@6B@ 0024 ??3@YAXPEAX@Z"
		altNames = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 08 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_24_0 {
	meta:
		name = "?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QEAA?AUHardwareAffinity@23@I@Z"
		size = 79
		refs = "0031 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 20 45 8B C8 48 8B F2 33 D2 48 8B CE 4D 6B C9 38 49 8B 3C 01 41 0F B7 5C 01 14 44 8D 42 10 E8 ?? ?? ?? ?? 66 89 5E 08 48 8B 5C 24 30 48 89 3E 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_29_0 {
	meta:
		name = "?SetAffinity@FreeThreadProxy@details@Concurrency@@QEAAXUHardwareAffinity@23@@Z"
		size = 73
		refs = "002b ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 18 57 48 83 EC 20 0F B7 41 50 48 8B FA 48 8B D9 66 39 42 08 75 09 48 8B 41 48 48 39 02 74 0C 48 8B 51 10 48 8B CF E8 ?? ?? ?? ?? 0F B7 47 08 66 89 43 50 48 8B 07 48 89 43 48 48 8B 5C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_30_0 {
	meta:
		name = "??0FreeVirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 38
		refs = "000a ??0VirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z 0016 ??_7FreeVirtualProcessorRoot@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 83 63 78 00 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_32_0 {
	meta:
		name = "?Deactivate@FreeVirtualProcessorRoot@details@Concurrency@@UEAA_NPEAUIExecutionContext@3@@Z"
		size = 215
		refs = "0017 ??_C@_08BAFMHLII@pContext?$AA@ 0028 ??0exception@std@@QEAA@AEBQEBD@Z 002f ??_7invalid_argument@std@@6B@ 0036 _TI3?AVinvalid_argument@std@@ 0045 _CxxThrowException 0057 ??0invalid_operation@Concurrency@@QEAA@XZ 005e _TI2?AVinvalid_operation@Concurrency@@ 00ad ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00b6 ?SuspendExecution@ThreadProxy@details@Concurrency@@QEAAXXZ 00c3 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 57 48 83 EC 70 48 8B F9 48 85 D2 75 36 48 8D 05 ?? ?? ?? ?? 49 8D 53 10 49 8D 4B A8 49 89 43 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 83 79 78 00 75 1C 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC 48 8B 02 48 8B CA FF 50 10 48 39 47 78 74 1C 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? CC 83 C8 FF F0 0F C1 47 70 FF C8 75 23 48 8B 4F 28 48 8D 57 08 E8 ?? ?? ?? ?? 48 8B 4F 78 E8 ?? ?? ?? ?? 48 8B 4F 28 48 8D 57 08 E8 ?? ?? ?? ?? B0 01 48 8B 9C 24 80 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_17_34_0 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_21_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_12_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0bad_typeid@std@@QEAA@PEBD@Z 0011 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_3_1 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_17_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_866_39_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_4_1 {
	meta:
		name = "??0bad_function_call@tr1@std@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_42_0_2 {
	meta:
		name = "??0bad_function_call@tr1@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_129_1 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_19_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_88_0 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_18_0_2 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_556_93_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_149_16_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_258_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_572_67_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_268_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_264_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_284_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_27_1 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_118_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_51_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_38_22_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_587_28_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_555_12_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_555_25_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_555_16_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_69_0 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_258_2 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_129_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_556_100_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_160_2 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_72_45_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_28_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_22_23_2 {
	meta:
		name = "??0range_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7range_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_25_103_1 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_820_8_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_313_23_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_579_68_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_36_0 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
		altNames = "??_Gbad_function_call@tr1@std@@UEAAPEAXI@Z ??_Gbad_target@Concurrency@@UEAAPEAXI@Z ??_Gbad_weak_ptr@tr1@std@@UEAAPEAXI@Z ??_Gcontext_self_unblock@Concurrency@@UEAAPEAXI@Z ??_Gcontext_unblock_unbalanced@Concurrency@@UEAAPEAXI@Z ??_Gdefault_scheduler_exists@Concurrency@@UEAAPEAXI@Z ??_Gfailure@ios_base@std@@UEAAPEAXI@Z ??_Gimproper_lock@Concurrency@@UEAAPEAXI@Z ??_Gimproper_scheduler_attach@Concurrency@@UEAAPEAXI@Z ??_Gimproper_scheduler_detach@Concurrency@@UEAAPEAXI@Z ??_Gimproper_scheduler_reference@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_argument@std@@UEAAPEAXI@Z ??_Ginvalid_link_target@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_multiple_scheduling@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_oversubscribe_operation@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_scheduler_policy_key@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UEAAPEAXI@Z ??_Ginvalid_scheduler_policy_value@Concurrency@@UEAAPEAXI@Z ??_Glength_error@std@@UEAAPEAXI@Z ??_Glogic_error@std@@UEAAPEAXI@Z ??_Gmessage_not_found@Concurrency@@UEAAPEAXI@Z ??_Gmissing_wait@Concurrency@@UEAAPEAXI@Z ??_Gnested_scheduler_missing_detach@Concurrency@@UEAAPEAXI@Z ??_Goperation_timed_out@Concurrency@@UEAAPEAXI@Z ??_Gout_of_range@std@@UEAAPEAXI@Z ??_Goverflow_error@std@@UEAAPEAXI@Z ??_Grange_error@std@@UEAAPEAXI@Z ??_Gregex_error@tr1@std@@UEAAPEAXI@Z ??_Gruntime_error@std@@UEAAPEAXI@Z ??_Gscheduler_not_attached@Concurrency@@UEAAPEAXI@Z ??_Gscheduler_resource_allocation_error@Concurrency@@UEAAPEAXI@Z ??_Gsystem_error@std@@UEAAPEAXI@Z ??_Gtask_canceled@details@Concurrency@@UEAAPEAXI@Z ??_Gunsupported_os@Concurrency@@UEAAPEAXI@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_996_1 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_945_1 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_78_226_2 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_51_262_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_80_236_2 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_862_2 {
	meta:
		name = "??_G?$call@_KV?$function@$$A6AXAEB_K@Z@tr1@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$call@_KV?$function@$$A6AXAEB_K@Z@tr1@std@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_553_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_557_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_551_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_554_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_552_2 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_556_1 {
	meta:
		name = "??_G?$ordered_message_processor@_K@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_939_1 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_860_2 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_861_2 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_875_2 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_940_2 {
	meta:
		name = "??_G?$single_assignment@_K@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$single_assignment@_K@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_588_2 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_729_2 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_60_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ExternalContextBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_556_115_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1InternalContextBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_579_130_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ResourceManager@details@Concurrency@@AEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_735_302_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_735_84_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerPolicy@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_595_73_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerProxy@details@Concurrency@@IEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_735_65_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulingNode@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_735_66_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulingRing@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_287_20_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ThreadProxy@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_819_15_0 {
	meta:
		name = "??_GTransmogrificator@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1Transmogrificator@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_943_15_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1TransmogrifiedPrimary@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_636_9_0 {
	meta:
		name = "??_GUMSBackgroundPoller@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSBackgroundPoller@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_637_84_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_651_34_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSSchedulerProxy@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_132_40_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_48_18_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_229_45_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_16_388_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_624_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@tr1@std@@@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Blocking_recipient@?1???$_receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@tr1@std@@@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_253_18_0 {
	meta:
		name = "??_G_Exception_ptr@std@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ?__ExceptionPtrDestroy@@YAXPEAX@Z 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_74_13_1 {
	meta:
		name = "??_G_Fac_node@std@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Fac_node@std@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_622_1 {
	meta:
		name = "??_G_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPEAV?$ITarget@W4agent_status@Concurrency@@@1@AEBW4agent_status@1@@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPEAV?$ITarget@W4agent_status@Concurrency@@@1@AEBW4agent_status@1@@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_85_623_1 {
	meta:
		name = "??_G_Originator@?1???$send@_K@Concurrency@@YA_NPEAV?$ITarget@_K@1@AEB_K@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Originator@?1???$send@_K@Concurrency@@YA_NPEAV?$ITarget@_K@1@AEB_K@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_131_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_883_42_0 {
	meta:
		name = "??_G__ExceptionPtr@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1__ExceptionPtr@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_35_52_1 {
	meta:
		name = "??_Glocale@std@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1locale@std@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_37_0 {
	meta:
		name = "?EnsureAllTasksVisible@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 167
		refs = "0011 ??_C@_08BAFMHLII@pContext?$AA@ 0025 ??0exception@std@@QEAA@AEBQEBD@Z 002c ??_7invalid_argument@std@@6B@ 0033 _TI3?AVinvalid_argument@std@@ 0042 _CxxThrowException 0054 ??0invalid_operation@Concurrency@@QEAA@XZ 005b _TI2?AVinvalid_operation@Concurrency@@ 00a3 ?FlushStoreBuffers@ResourceManager@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B D9 48 85 D2 75 39 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 48 89 44 24 58 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 83 79 78 00 75 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8B 02 48 8B CA FF 50 10 48 39 43 78 74 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8B 4B 28 48 8B 49 18 48 83 C4 40 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_38_0 {
	meta:
		name = "?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z"
		size = 213
		refs = "0012 __security_cookie 0028 ?SpinUntilBlocked@ThreadProxy@details@Concurrency@@QEAAXXZ 005f memset 007e memcpy 00a2 ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z 00c1 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 48 8B F9 48 8B CA 48 8B F2 E8 ?? ?? ?? ?? 48 89 77 78 48 89 7E 20 48 8B 07 48 8B 5F 28 48 8B CF FF 10 33 D2 8B C8 48 8B 43 20 44 8D 42 10 48 6B C9 38 48 8B 3C 01 0F B7 5C 01 14 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 20 41 B8 10 00 00 00 66 89 5C 24 38 48 89 7C 24 30 E8 ?? ?? ?? ?? 0F B7 4C 24 28 66 3B 4E 50 75 0B 48 8B 44 24 20 48 3B 46 48 74 18 48 8B 56 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F B7 4C 24 28 48 8B 44 24 20 66 89 4E 50 48 89 46 48 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_17_42_0 {
	meta:
		name = "?Activate@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 221
		refs = "001e ??_C@_08BAFMHLII@pContext?$AA@ 002f ??0exception@std@@QEAA@AEBQEBD@Z 0036 ??_7invalid_argument@std@@6B@ 003d _TI3?AVinvalid_argument@std@@ 004c _CxxThrowException 0070 ??0invalid_operation@Concurrency@@QEAA@XZ 0077 _TI2?AVinvalid_operation@Concurrency@@ 00a4 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00af ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z 00c9 ?ResumeExecution@ThreadProxy@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 73 18 57 48 83 EC 50 48 8B F2 48 8B D9 48 85 D2 75 36 48 8D 05 ?? ?? ?? ?? 49 8D 53 10 49 8D 4B C8 49 89 43 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 02 48 8B CA FF 50 10 48 83 7B 78 00 48 8B F8 74 22 48 3B 43 78 74 49 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC 48 85 C0 75 10 48 8B 4B 28 48 8B D6 48 8B 01 FF 50 38 48 8B F8 48 8B 4B 28 48 8D 53 08 E8 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? B8 01 00 00 00 F0 0F C1 43 70 FF C0 83 F8 02 74 09 48 8B 4B 78 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "wcsnlen"
		size = 31
	strings:
		$1 = { 45 33 C0 41 8B C0 48 85 D2 74 12 66 44 39 01 74 0C 48 FF C0 48 83 C1 02 48 3B C2 72 EE F3 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "log10"
		size = 798
		refs = "0026 __mask_1023 003a __real_inf 0050 __real_mant 0058 __real_one 0060 __mask_1023_f 0070 __mask_mant_all8 0077 __mask_mant9 008a __real_notsign 0092 __real_threshold 00aa __real_half 00b9 __log_F_inv 00e0 __log_256_lead 00e8 __real_1_over_6 00f0 __real_1_over_3 0108 __real_1_over_5 0110 __real_1_over_2 0124 __real_1_over_4 0138 __real_log10_e 0140 __real_log10_2_tail 0155 __log_256_tail 0166 __real_log10_2_lead 0194 __real_two 01b0 __real_ca2 01b8 __real_ca4 01dc __real_ca1 01e4 __real_ca3 020c __mask_lower 0224 __real_log10_e_tail 0234 __real_log10_e_lead 0284 __mask_2045 02a6 __real_ninf 02ad __flag_x_zero 02b2 _log10_special 02c4 __real_neg_qnan 02cb __flag_x_neg 02f5 __real_qnanbit 0301 __flag_x_nan"
	strings:
		$1 = { 48 81 EC 98 00 00 00 66 0F 7F 74 24 40 48 33 C0 66 0F 6F D8 F2 0F 10 E0 66 0F 73 D3 34 66 48 0F 7E C0 66 0F FB 1D ?? ?? ?? ?? 66 0F 6F D0 F3 0F E6 F3 66 0F 6F E8 66 0F 54 2D ?? ?? ?? ?? 66 0F 2F 2D ?? ?? ?? ?? 0F 84 94 02 00 00 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C 25 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 0F 84 F0 01 00 00 4C 8B C8 48 23 05 ?? ?? ?? ?? 4C 23 0D ?? ?? ?? ?? 49 D1 E1 49 03 C1 48 89 44 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 0F 82 F4 00 00 00 F2 0F 10 4C 24 30 48 C1 E8 2C 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 66 0F 57 ED 66 0F 2F C5 0F 86 D5 01 00 00 F2 0F 5C CA F2 41 0F 59 0C C1 F2 0F 10 D1 F2 0F 10 C1 4C 8D 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 DA F2 0F 59 C8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CA F2 0F 59 DC F2 0F 58 CB F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 5C E9 F2 41 0F 10 04 C1 48 8D 15 ?? ?? ?? ?? F2 0F 10 14 C2 F2 0F 58 D5 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E6 F2 0F 58 C4 F2 0F 58 C2 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 10 C8 F2 0F 5E CA F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 F0 F2 0F 59 F1 F2 0F 58 C9 F2 0F 10 D1 F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 EA F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 D2 F2 0F 59 D1 F2 0F 59 EA F2 0F 58 E5 F2 0F 5C E6 66 0F 6F D8 66 0F DB 1D ?? ?? ?? ?? F2 0F 5C C3 F2 0F 58 E0 F2 0F 10 C3 F2 0F 10 CC F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 1D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 58 C1 F2 0F 58 C3 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 66 0F EB 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 10 EA 66 0F DB 15 ?? ?? ?? ?? 66 48 0F 7E D0 66 0F 73 D5 34 66 0F FA 2D ?? ?? ?? ?? F3 0F E6 F5 E9 D9 FD FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 75 1E F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3A 66 66 0F 1F 84 00 00 00 00 00 48 3B 05 ?? ?? ?? ?? 74 27 48 3B 05 ?? ?? ?? ?? 74 CE 48 0B 05 ?? ?? ?? ?? 66 48 0F 6E C8 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 0F 1F 40 00 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_wcsrev"
		size = 64
	strings:
		$1 = { 4C 8B C1 4C 8B D1 4C 8B C9 41 0F B7 00 49 83 C0 02 66 85 C0 75 F3 49 83 E8 04 49 3B C8 73 1D 41 0F B7 08 41 0F B7 11 66 41 89 09 66 41 89 10 49 83 E8 02 49 83 C1 02 4D 3B C8 72 E3 49 8B C2 C3 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "_execvpe"
		size = 783
		refs = "0032 _errno 003d _invalid_parameter_noinfo 006f _execve 008a _mbschr 00bd ??_C@_04HBHDLLBA@PATH?$AA@ 00c9 _dupenv_s 00ea _invoke_watson 0105 _calloc_crt 013d isleadbyte 01a3 _mbsrchr 01af ??_C@_01KICIPPFI@?2?$AA@ 01bc strcat_s 01fe strlen 02db free"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 ED 4D 8B F8 4C 8B F2 48 8B F1 4C 89 68 08 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 A8 02 00 00 44 38 29 74 E6 48 85 D2 74 E1 48 8B 02 48 85 C0 74 D9 44 38 28 74 D4 E8 ?? ?? ?? ?? 4D 8B C7 49 8B D6 48 8B CE 44 89 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 38 02 0F 85 5E 02 00 00 BA 5C 00 00 00 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 0F 85 48 02 00 00 8D 50 2F 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 0F 85 34 02 00 00 44 38 2E 74 0A 80 7E 01 3A 0F 84 25 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 60 33 D2 E8 ?? ?? ?? ?? 85 C0 74 1E 83 F8 16 0F 85 05 02 00 00 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 4C 39 6C 24 60 0F 84 F4 01 00 00 BA 01 00 00 00 B9 04 01 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 8B E8 48 85 C0 0F 84 C7 01 00 00 4C 8B 64 24 60 41 8A 04 24 84 C0 74 5D 48 8D 5F 01 3C 3B 74 55 4C 8D AF 02 01 00 00 49 3B ED 73 46 0F BE C8 E8 ?? ?? ?? ?? 85 C0 74 1D 41 80 7C 24 01 00 74 32 49 3B DD 73 2D 41 8A 04 24 48 FF C3 88 45 00 48 FF C5 49 FF C4 41 8A 04 24 49 FF C4 48 FF C3 88 45 00 41 8A 04 24 48 FF C5 45 33 ED 84 C0 75 AC EB 03 45 33 ED 44 88 6D 00 48 8D 5D FF 48 3B EF 77 03 48 8B DD 80 3B 5C 48 8B EF 75 3F BA 5C 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 3B D8 74 4E 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 36 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 80 3B 2F 74 1C 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 B3 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B CE 48 8B D8 E8 ?? ?? ?? ?? 48 03 D8 B8 04 01 00 00 48 3B D8 0F 83 B9 00 00 00 4C 8B C6 8B D0 48 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 8F 00 00 00 E8 ?? ?? ?? ?? 4D 8B C7 49 8B D6 48 8B CF 44 89 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 38 02 74 4C BA 5C 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 3B F8 74 12 BA 2F 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 3B F8 75 60 48 8D 5F 01 BA 5C 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 3B D8 74 12 BA 2F 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 3B D8 75 38 45 38 2C 24 74 32 49 FF C4 E9 70 FE FF FF 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B 6C 24 70 48 8B 74 24 78 48 83 C8 FF 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_25_3_0 {
	meta:
		name = "write_char"
		size = 37
		refs = "000a _putwch_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 05 83 0B FF EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_25_4_0 {
	meta:
		name = "write_multi_char"
		size = 79
		refs = "0021 _putwch_nolock"
	strings:
		$1 = { 85 D2 7E 4A 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D8 8B FA 0F B7 F1 0F B7 CE FF CF E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 0D FF 03 83 3B FF 74 09 85 FF 7E 05 EB DF 83 0B FF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_25_5_0 {
	meta:
		name = "write_string"
		size = 171
		refs = "0022 _errno 0040 _putwch_nolock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 55 48 83 EC 20 49 8B D8 8B F2 48 8B F9 E8 ?? ?? ?? ?? 8B 28 E8 ?? ?? ?? ?? 83 20 00 85 F6 7E 4B 41 BD FF FF 00 00 0F B7 0F FF CE E8 ?? ?? ?? ?? 66 41 3B C5 75 05 83 0B FF EB 02 FF 03 48 83 C7 02 83 3B FF 75 21 E8 ?? ?? ?? ?? 83 38 2A 75 1B B9 3F 00 00 00 E8 ?? ?? ?? ?? 66 41 3B C5 75 05 83 0B FF EB 02 FF 03 85 F6 7F BB E8 ?? ?? ?? ?? 83 38 00 75 07 E8 ?? ?? ?? ?? 89 28 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5D C3 }
	condition:
		$1
}

rule file_25_8_0 {
	meta:
		name = "_vcwprintf_p_l"
		size = 4625
		refs = "0022 __security_cookie 005b ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006e _errno 0079 _invalid_parameter_noinfo 011f __lookuptable_s 017d wcstol 01a8 memset 03a8 _validate_param_reuseW 0415 __nullstring 041d strlen 0526 _mbtowc_l 0671 _isleadbyte_l 069b __wnullstring 075e _get_printf_count_output 0ac9 _malloc_crt 0b29 _cfltcvt_tab 0b36 __imp_DecodePointer 0c2d write_multi_char 0c3d write_string 0c97 _putwch_nolock 0d07 free 1131 get_crtdouble_arg 11f2 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 B0 F2 FF FF 48 81 EC 50 0E 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 40 0D 00 00 45 33 ED 4C 8B E1 48 89 4D D8 48 8D 4C 24 60 4C 89 44 24 50 44 89 6D B8 45 8B F5 44 89 6C 24 5C 44 89 6C 24 48 44 89 6C 24 4C E8 ?? ?? ?? ?? 83 CA FF 8B F2 4C 89 6D B0 4D 85 E4 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 6C 24 78 74 0C 48 8B 4C 24 70 83 A1 C8 00 00 00 FD 83 C8 FF E9 4F 11 00 00 48 8B 5D D8 4C 8B 4C 24 50 41 8B C5 41 8B CD 89 44 24 40 89 4D A8 83 F9 01 75 08 85 F6 0F 84 19 11 00 00 45 8B FD 45 8B C5 4C 89 6D C8 44 89 6D 88 41 8B FD 44 89 6C 24 58 4D 8B D4 45 0F B7 24 24 44 8B EA 44 8B DA 89 54 24 44 89 55 C0 8B F2 89 55 80 48 63 55 A8 48 89 55 98 66 45 85 E4 0F 84 5C 10 00 00 49 83 C2 02 4C 89 55 90 85 C0 0F 88 CC 0F 00 00 41 8D 44 24 E0 B9 58 00 00 00 66 3B C1 77 18 48 8D 0D ?? ?? ?? ?? 41 0F B7 C4 0F B6 4C 08 E0 83 E1 0F 45 33 DB EB 06 45 33 DB 41 8B CB 48 63 C1 48 8D 0C C0 49 63 C0 48 03 C8 48 8D 05 ?? ?? ?? ?? 0F B6 04 01 C1 E8 04 89 45 BC 83 F8 01 0F 85 DE 00 00 00 66 41 83 3A 25 0F 84 DC 00 00 00 83 FE FF 75 59 44 8D 40 09 48 8D 55 B0 49 8B CA E8 ?? ?? ?? ?? 45 33 DB 85 C0 7E 2E 48 8B 45 B0 66 83 38 24 75 24 4C 39 5D 98 75 14 48 8D 8D E0 03 00 00 33 D2 41 B8 60 09 00 00 E8 ?? ?? ?? ?? BE 01 00 00 00 89 75 80 EB 19 4C 8B 4C 24 50 48 8B 55 98 4C 8B 55 90 41 8B F3 44 89 5D 80 83 FE 01 75 79 48 8B 4D 90 48 8D 55 B0 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D B0 48 8B 55 98 4C 8D 51 02 44 8D 68 FF 45 33 DB 4C 89 55 90 44 89 6D C0 48 85 D2 75 36 45 85 ED 0F 88 6E 0F 00 00 66 83 39 24 0F 85 64 0F 00 00 44 8D 42 64 45 3B E8 0F 8D 57 0F 00 00 8B 44 24 44 4C 8B 4C 24 50 44 3B E8 41 0F 4F C5 89 44 24 44 EB 16 4C 8B 4C 24 50 EB 09 83 F8 08 0F 84 31 0F 00 00 41 B8 64 00 00 00 8B 4D BC 85 C9 0F 84 03 0E 00 00 FF C9 0F 84 D8 0D 00 00 FF C9 0F 84 6B 0D 00 00 FF C9 0F 84 62 0C 00 00 FF C9 0F 84 4D 0C 00 00 FF C9 0F 84 87 0B 00 00 FF C9 0F 84 96 0A 00 00 FF C9 0F 85 26 0E 00 00 41 0F B7 C4 41 3B C0 0F 8F 10 03 00 00 0F 84 FC 04 00 00 83 F8 41 0F 84 9C 02 00 00 83 F8 43 0F 84 A6 01 00 00 83 F8 45 0F 84 8A 02 00 00 83 F8 47 0F 84 81 02 00 00 83 F8 53 0F 84 55 01 00 00 B9 58 00 00 00 3B C1 0F 84 F6 03 00 00 83 F8 5A 74 63 83 F8 61 0F 84 69 02 00 00 83 F8 63 0F 84 7B 01 00 00 8B 7C 24 4C B9 20 00 00 00 41 BC 30 00 00 00 BE 2D 00 00 00 8B 44 24 48 83 7D 80 01 75 0D 48 8B 55 98 48 85 D2 0F 84 8F 0D 00 00 85 C0 0F 85 D5 09 00 00 41 F6 C6 40 0F 84 DE 08 00 00 41 0F BA E6 08 0F 83 AD 08 00 00 66 89 75 A4 E9 B3 08 00 00 85 F6 75 0F 49 83 C1 08 4C 89 4C 24 50 49 8B 41 F8 EB 70 41 83 FD 63 0F 87 16 0E 00 00 49 63 C5 48 8D 0C 40 48 85 D2 75 4F 48 8D 84 CD E0 03 00 00 44 39 18 75 1C C7 00 02 00 00 00 66 44 89 A4 CD F0 03 00 00 44 89 B4 CD F4 03 00 00 E9 5D FF FF FF BA 02 00 00 00 45 0F B7 C4 45 8B CE 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 C5 0D 00 00 4C 8B 4C 24 50 E9 37 FF FF FF 48 8B 84 CD E8 03 00 00 48 8B 00 48 85 C0 74 44 48 8B 58 08 48 85 DB 74 3B B9 20 00 00 00 8D 71 0D 44 8D 61 10 41 0F BA E6 0B 73 17 0F BF 00 8D 79 E1 99 89 7C 24 4C 2B C2 D1 F8 44 8B F8 E9 08 FF FF FF 44 0F BF 38 41 8B FB 44 89 5C 24 4C E9 F7 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 4C 8B F8 EB 8E 41 F7 C6 30 08 00 00 75 04 41 83 CE 20 83 FF FF 8B F7 B8 FF FF FF 7F 0F 44 F0 44 39 5D 80 0F 85 CD 01 00 00 49 83 C1 08 4C 89 4C 24 50 49 8B 59 F8 E9 E0 01 00 00 41 B8 20 00 00 00 41 F7 C6 30 08 00 00 75 0B 45 0B F0 EB 06 41 B8 20 00 00 00 BF 01 00 00 00 89 7C 24 4C 85 F6 75 10 49 83 C1 08 4C 89 4C 24 50 41 0F B7 41 F8 EB 69 41 83 FD 63 0F 87 DC 0C 00 00 49 63 C5 48 8D 0C 40 48 85 D2 75 48 48 8D 84 CD E0 03 00 00 44 39 18 75 18 89 38 66 44 89 A4 CD F0 03 00 00 44 89 B4 CD F4 03 00 00 E9 2B FE FF FF 45 8B CE 45 0F B7 C4 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 92 0C 00 00 4C 8B 4C 24 50 E9 08 FE FF FF 48 8B 84 CD E8 03 00 00 0F B7 00 66 89 45 84 45 84 F0 74 34 88 45 A0 48 8B 44 24 60 44 88 5D A1 4C 63 80 0C 01 00 00 4C 8D 4C 24 60 48 8D 55 A0 48 8D 4D E0 E8 ?? ?? ?? ?? 4C 8B 4C 24 50 85 C0 79 0A 89 7C 24 48 EB 04 66 89 45 E0 48 8D 5D E0 44 8B FF E9 B0 FD FF FF C7 45 C4 01 00 00 00 66 41 83 C4 20 B9 67 00 00 00 41 83 CE 40 83 FE 01 0F 85 18 05 00 00 48 85 D2 0F 85 0F 05 00 00 41 83 FD 63 0F 87 FF 0B 00 00 49 63 C5 48 8D 0C 40 48 8D 84 CD E0 03 00 00 44 39 18 0F 85 C0 04 00 00 C7 00 07 00 00 00 66 44 89 A4 CD F0 03 00 00 44 89 B4 CD F4 03 00 00 E9 09 0B 00 00 83 F8 65 0F 8C 3E FD FF FF B9 67 00 00 00 3B C1 7E 9A B9 69 00 00 00 3B C1 0F 84 D3 01 00 00 83 F8 6E 0F 84 4F 01 00 00 B9 6F 00 00 00 3B C1 0F 84 26 01 00 00 83 F8 70 0F 84 DA 00 00 00 83 F8 73 0F 84 3E FE FF FF B9 75 00 00 00 3B C1 0F 84 A2 01 00 00 B9 78 00 00 00 3B C1 0F 85 E6 FC FF FF 8D 41 AF E9 C2 00 00 00 41 83 FD 63 0F 87 58 0B 00 00 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 3E FD FF FF 48 8B 9C CD E8 03 00 00 48 8B 1B B9 20 00 00 00 44 84 F1 74 49 48 85 DB 45 8B FB 48 0F 44 1D ?? ?? ?? ?? 48 8B FB 85 F6 0F 8E 82 05 00 00 44 38 1F 0F 84 4C FD FF FF 0F B6 0F 48 8D 54 24 60 E8 ?? ?? ?? ?? 45 33 DB 85 C0 74 03 48 FF C7 41 FF C7 48 FF C7 44 3B FE 7C D5 E9 25 FD FF FF 48 85 DB BF 01 00 00 00 48 0F 44 1D ?? ?? ?? ?? 89 7C 24 4C 48 8B C3 EB 0C FF CE 66 44 39 18 74 08 48 83 C0 02 85 F6 75 F0 48 2B C3 48 D1 F8 44 8B F8 E9 38 FC FF FF BF 10 00 00 00 41 0F BA EE 0F 89 7C 24 58 B8 07 00 00 00 89 45 B8 41 BA 10 00 00 00 45 84 F6 0F 89 BF 00 00 00 41 8D 4A 20 45 8D 5A F2 66 83 C0 51 66 89 4D A4 44 89 5C 24 5C 66 89 45 A6 E9 A6 00 00 00 41 BA 08 00 00 00 45 84 F6 0F 89 92 00 00 00 B8 00 02 00 00 44 0B F0 E9 85 00 00 00 85 F6 75 0F 49 83 C1 08 4C 89 4C 24 50 49 8B 79 F8 EB 25 41 83 FD 63 0F 87 37 0A 00 00 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 1D FC FF FF 48 8B 84 CD E8 03 00 00 48 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 0F 0A 00 00 8B 4C 24 40 B8 20 00 00 00 44 84 F0 74 05 66 89 0F EB 02 89 0F 4C 8B 4C 24 50 8B 7C 24 4C B8 01 00 00 00 8D 48 1F 8D 70 2C 44 8D 60 2F 89 44 24 48 E9 6D FB FF FF 41 83 CE 40 41 BA 0A 00 00 00 44 8B 5C 24 5C 41 0F BA E6 0F 73 51 85 F6 75 12 49 83 C1 08 4C 89 4C 24 50 4D 8B 41 F8 E9 BB 01 00 00 41 83 FD 63 0F 87 A3 09 00 00 49 63 C5 48 8D 0C 40 48 85 D2 75 6B 48 8D 84 CD E0 03 00 00 45 33 DB 44 39 18 75 0B C7 00 03 00 00 00 E9 85 FB FF FF BA 03 00 00 00 E9 96 FB FF FF 41 0F BA E6 0C 73 4F 85 F6 74 A8 41 83 FD 63 0F 87 5D 09 00 00 49 63 C5 48 8D 0C 40 48 85 D2 75 25 48 8D 84 CD E0 03 00 00 45 33 DB 44 39 18 75 0B C7 00 04 00 00 00 E9 3F FB FF FF BA 04 00 00 00 E9 50 FB FF FF 48 8B 84 CD E8 03 00 00 4C 8B 00 E9 2A 01 00 00 B8 20 00 00 00 44 84 F0 0F 84 A4 00 00 00 41 F6 C6 40 74 63 85 F6 75 13 49 83 C1 08 4C 89 4C 24 50 4D 0F BF 41 F8 E9 FF 00 00 00 41 83 FD 63 0F 87 E7 08 00 00 49 63 C5 48 8D 0C 40 48 85 D2 75 25 48 8D 84 CD E0 03 00 00 45 33 DB 44 39 18 75 0B C7 00 01 00 00 00 E9 C9 FA FF FF BA 01 00 00 00 E9 DA FA FF FF 48 8B 84 CD E8 03 00 00 4C 0F BF 00 E9 B3 00 00 00 85 F6 75 13 49 83 C1 08 4C 89 4C 24 50 45 0F B7 41 F8 E9 9C 00 00 00 41 83 FD 63 0F 87 84 08 00 00 49 63 C5 48 8D 0C 40 48 85 D2 74 9D 48 8B 84 CD E8 03 00 00 44 0F B7 00 EB 78 41 F6 C6 40 74 3A 85 F6 75 0F 49 83 C1 08 4C 89 4C 24 50 4D 63 41 F8 EB 5F 41 83 FD 63 0F 87 47 08 00 00 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 5C FF FF FF 48 8B 84 CD E8 03 00 00 4C 63 00 EB 38 85 F6 75 0F 49 83 C1 08 4C 89 4C 24 50 45 8B 41 F8 EB 25 41 83 FD 63 0F 87 0D 08 00 00 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 22 FF FF FF 48 8B 84 CD E8 03 00 00 44 8B 00 41 F6 C6 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EE 08 41 0F BA E6 0F 72 0A 41 0F BA E6 0C 72 03 45 8B C0 85 FF 79 07 BF 01 00 00 00 EB 0E BA 00 02 00 00 41 83 E6 F7 3B FA 0F 4F FA 44 8B 4D B8 49 8B C0 48 8D 9D DF 01 00 00 48 F7 D8 1B C9 41 23 CB 89 4C 24 5C 8B CF FF CF 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 CA 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C1 88 03 48 FF CB EB D3 4C 8B 4C 24 50 4C 8D BD DF 01 00 00 B8 00 02 00 00 44 2B FB 48 FF C3 89 7C 24 58 41 BC 30 00 00 00 44 85 F0 74 13 45 85 FF 74 05 44 38 23 74 09 48 FF CB 41 FF C7 44 88 23 8B 7C 24 4C B9 20 00 00 00 E9 B2 F8 FF FF 45 8B CE 45 0F B7 C4 BA 07 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 35 07 00 00 4C 8B 4C 24 50 48 8B 55 98 E9 34 06 00 00 B8 00 02 00 00 48 8D 5D E0 8B F0 85 FF 79 0D 41 BF 06 00 00 00 44 89 7C 24 58 EB 52 75 0E 66 44 3B E1 75 40 41 BF 01 00 00 00 EB E9 3B F8 41 BF A3 00 00 00 0F 4F F8 89 7C 24 58 41 3B FF 7E 2B 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 4C 8B 4C 24 50 45 33 DB 48 89 45 C8 48 85 C0 74 B6 48 8B D8 8B F7 44 8B 7C 24 58 EB 03 44 8B FF 44 39 5D 80 75 13 49 83 C1 08 4C 89 4C 24 50 49 8B 41 F8 48 89 45 D0 EB 20 41 83 FD 63 0F 87 69 06 00 00 49 63 C5 48 8D 0C 40 48 8B 84 CD E8 03 00 00 48 8B 08 48 89 4D D0 48 8B 0D ?? ?? ?? ?? 41 0F BE FC 48 63 F6 FF 15 ?? ?? ?? ?? 48 8D 4C 24 60 44 8B CF 48 89 4C 24 30 8B 4D C4 4C 8B C6 89 4C 24 28 48 8D 4D D0 48 8B D3 44 89 7C 24 20 FF D0 41 8B FE 81 E7 80 00 00 00 74 1C 45 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 60 48 8B CB FF D0 41 B8 67 00 00 00 66 45 3B E0 75 1B 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 60 48 8B CB FF D0 BE 2D 00 00 00 40 38 33 75 08 41 0F BA EE 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 4C 8B 4C 24 50 8B 7C 24 4C B9 20 00 00 00 44 8B F8 44 8D 61 10 E9 28 F7 FF FF 8B 7C 24 4C E9 14 F7 FF FF 41 F6 C6 01 74 14 B8 2B 00 00 00 66 89 45 A4 BE 01 00 00 00 89 74 24 5C EB 10 41 F6 C6 02 74 06 66 89 4D A4 EB E9 8B 74 24 5C 44 8B 6D 88 45 2B EF 44 2B EE 41 F6 C6 0C 75 0D 4C 8D 44 24 40 41 8B D5 E8 ?? ?? ?? ?? 4C 8D 44 24 40 48 8D 4D A4 8B D6 E8 ?? ?? ?? ?? 41 F6 C6 08 74 16 41 F6 C6 04 75 10 4C 8D 44 24 40 41 8B CC 41 8B D5 E8 ?? ?? ?? ?? 85 FF 75 67 45 85 FF 7E 62 48 8B FB 41 8B F7 48 8B 44 24 60 4C 8D 4C 24 60 48 8D 4D 84 4C 63 80 0C 01 00 00 48 8B D7 FF CE E8 ?? ?? ?? ?? 4C 63 E0 85 C0 7E 2D 0F B7 4D 84 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 09 83 C9 FF 89 4C 24 40 EB 08 FF 44 24 40 8B 4C 24 40 49 03 FC 85 F6 7F AF EB 1D 83 C9 FF 89 4C 24 40 EB 14 4C 8D 44 24 40 41 8B D7 48 8B CB E8 ?? ?? ?? ?? 8B 4C 24 40 85 C9 78 18 41 F6 C6 04 74 12 4C 8D 44 24 40 B9 20 00 00 00 41 8B D5 E8 ?? ?? ?? ?? 4C 8B 4C 24 50 48 8B 4D C8 48 85 C9 74 10 E8 ?? ?? ?? ?? 4C 8B 4C 24 50 33 C9 48 89 4D C8 8B 7C 24 58 E9 57 FD FF FF 41 0F B7 C4 83 F8 49 74 50 83 F8 68 74 42 B9 6C 00 00 00 3B C1 74 13 83 F8 77 0F 85 78 03 00 00 41 0F BA EE 0B E9 6E 03 00 00 8B 44 24 40 44 8B 5C 24 44 66 41 39 0A 75 0E 49 83 C2 02 41 0F BA EE 0C E9 5A 03 00 00 41 83 CE 10 E9 51 03 00 00 41 83 CE 20 E9 3F 03 00 00 B8 00 80 00 00 44 0B F0 66 41 83 3A 36 75 14 66 41 83 7A 02 34 75 0C 49 83 C2 04 44 0B F0 E9 1C 03 00 00 66 41 83 3A 33 75 16 66 41 83 7A 02 32 75 0E 49 83 C2 04 41 0F BA F6 0F E9 FF 02 00 00 66 45 39 02 74 40 B8 69 00 00 00 66 41 39 02 74 35 B8 6F 00 00 00 66 41 39 02 74 2A B8 75 00 00 00 66 41 39 02 74 1F B8 78 00 00 00 66 41 39 02 74 14 B8 58 00 00 00 66 41 39 02 74 09 44 89 5D BC E9 73 02 00 00 41 0F BA EE 10 E9 AF 02 00 00 B8 2A 00 00 00 66 44 3B E0 0F 85 9B 00 00 00 85 F6 75 0F 49 83 C1 08 4C 89 4C 24 50 41 8B 79 F8 EB 42 48 8D 55 B0 41 B8 0A 00 00 00 49 8B CA E8 ?? ?? ?? ?? 48 8B 4D B0 48 8B 55 98 4C 8D 51 02 FF C8 4C 89 55 90 48 85 D2 0F 84 CA 00 00 00 4C 8B 4C 24 50 48 98 48 8D 0C 40 48 8B 84 CD E8 03 00 00 8B 38 8B 44 24 40 44 8B 5C 24 44 89 7C 24 58 85 FF 0F 89 3F 02 00 00 83 CF FF 89 7C 24 58 E9 33 02 00 00 4C 8B 4C 24 50 C7 00 01 00 00 00 B8 2A 00 00 00 66 89 84 CD F0 03 00 00 44 89 B4 CD F4 03 00 00 E9 0A 02 00 00 8D 0C BF 41 0F B7 C4 8D 7C 48 D0 89 7C 24 58 E9 F1 01 00 00 41 8B FB 44 89 5C 24 58 E9 E4 01 00 00 B8 2A 00 00 00 66 44 3B E0 0F 85 DC 00 00 00 85 F6 75 12 49 83 C1 08 4C 89 4C 24 50 41 8B 49 F8 E9 A4 00 00 00 48 8D 55 B0 41 B8 0A 00 00 00 49 8B CA E8 ?? ?? ?? ?? 48 8B 4D B0 48 8B 55 98 4C 8D 51 02 FF C8 4C 89 55 90 48 85 D2 75 66 85 C0 0F 88 50 02 00 00 66 83 39 24 0F 85 46 02 00 00 41 B8 64 00 00 00 45 3B E8 0F 8D 37 02 00 00 44 8B 5C 24 44 41 3B C3 44 0F 4F D8 48 98 45 33 E4 48 8D 0C 40 44 89 5C 24 44 48 8D 84 CD E0 03 00 00 44 39 20 0F 84 20 FF FF FF 45 8D 44 24 2A 41 8D 54 24 01 45 8B CE 48 8B C8 E8 ?? ?? ?? ?? E9 E2 FA FF FF 4C 8B 4C 24 50 48 98 48 8D 0C 40 48 8B 84 CD E8 03 00 00 8B 08 8B 44 24 40 44 8B 5C 24 44 89 4D 88 85 C9 0F 89 10 01 00 00 41 83 CE 04 F7 D9 89 4D 88 E9 02 01 00 00 8B 45 88 8D 0C 80 41 0F B7 C4 8D 4C 48 D0 89 4D 88 E9 E3 00 00 00 41 0F B7 C4 B9 20 00 00 00 3B C1 74 52 83 F8 23 74 43 B9 2B 00 00 00 3B C1 74 31 B9 2D 00 00 00 3B C1 74 1F 44 8B 5C 24 44 B9 30 00 }
	condition:
		$1
}

rule file_25_9_0 {
	meta:
		name = "_cwprintf_p_l"
		size = 33
		refs = "0018 _vcwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_413_10_0 {
	meta:
		name = "_cprintf_l"
		size = 33
		refs = "0018 _vcprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_448_11_0 {
	meta:
		name = "_cprintf_p_l"
		size = 33
		refs = "0018 _vcprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_822_10_0 {
	meta:
		name = "_cprintf_s_l"
		size = 33
		refs = "0018 _vcprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_302_11_0 {
	meta:
		name = "_cscanf_l"
		size = 33
		refs = "0018 _cprinput_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_11_0 {
	meta:
		name = "_cscanf_s_l"
		size = 33
		refs = "0018 _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_186_9_0 {
	meta:
		name = "_cwprintf_l"
		size = 33
		refs = "0018 _vcwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_9_0 {
	meta:
		name = "_cwprintf_s_l"
		size = 33
		refs = "0018 _vcwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_729_12_0 {
	meta:
		name = "_cwscanf_l"
		size = 33
		refs = "0018 _cprinput_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_622_12_0 {
	meta:
		name = "_cwscanf_s_l"
		size = 33
		refs = "0018 _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_2_0 {
	meta:
		name = "_printf_l"
		size = 33
		refs = "0018 _vprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_5_0 {
	meta:
		name = "_printf_p_l"
		size = 33
		refs = "0018 _vprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "_printf_s_l"
		size = 33
		refs = "0018 _vprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_227_10_0 {
	meta:
		name = "_scprintf_l"
		size = 33
		refs = "0018 _vscprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_227_11_0 {
	meta:
		name = "_scprintf_p_l"
		size = 33
		refs = "0018 _vscprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_520_10_0 {
	meta:
		name = "_scwprintf_l"
		size = 33
		refs = "0018 _vscwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_520_11_0 {
	meta:
		name = "_scwprintf_p_l"
		size = 33
		refs = "0018 _vscwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_877_2_0 {
	meta:
		name = "_wprintf_l"
		size = 33
		refs = "0018 _vwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_877_5_0 {
	meta:
		name = "_wprintf_p_l"
		size = 33
		refs = "0018 _vwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_877_3_0 {
	meta:
		name = "_wprintf_s_l"
		size = 33
		refs = "0018 _vwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_10_0 {
	meta:
		name = "_cwprintf_p"
		size = 39
		refs = "001e _vcwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_413_11_0 {
	meta:
		name = "_cprintf"
		size = 39
		refs = "001e _vcprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_448_12_0 {
	meta:
		name = "_cprintf_p"
		size = 39
		refs = "001e _vcprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_822_11_0 {
	meta:
		name = "_cprintf_s"
		size = 39
		refs = "001e _vcprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_302_10_0 {
	meta:
		name = "_cscanf"
		size = 39
		refs = "001e _cprinput_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_10_0 {
	meta:
		name = "_cscanf_s"
		size = 39
		refs = "001e _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_186_10_0 {
	meta:
		name = "_cwprintf"
		size = 39
		refs = "001e _vcwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_10_0 {
	meta:
		name = "_cwprintf_s"
		size = 39
		refs = "001e _vcwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_729_11_0 {
	meta:
		name = "_cwscanf"
		size = 39
		refs = "001e _cprinput_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_622_11_0 {
	meta:
		name = "_cwscanf_s"
		size = 39
		refs = "001e _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_6_0 {
	meta:
		name = "_printf_p"
		size = 39
		refs = "001e _vprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_877_6_0 {
	meta:
		name = "_wprintf_p"
		size = 39
		refs = "001e _vwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "printf_s"
		size = 39
		refs = "001e _vprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_877_4_0 {
	meta:
		name = "wprintf_s"
		size = 39
		refs = "001e _vwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_3_0 {
	meta:
		name = "_mbsnbcpy_s_l"
		size = 631
		refs = "005e _errno 006a _invalid_parameter_noinfo 0097 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00b2 strncpy_s 012f _ismbblead_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 55 41 55 41 56 48 8B EC 48 83 EC 40 45 33 F6 49 8B F9 49 8B F0 4C 8B E2 48 8B D9 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 20 33 C0 EB 2F 48 85 C9 74 17 48 85 D2 74 12 4D 85 C9 75 05 44 88 31 EB E8 4D 85 C0 75 34 44 88 31 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 4C 8B 64 24 78 48 83 C4 40 41 5E 41 5D 5D C3 48 8B 55 40 48 8D 4D E0 E8 ?? ?? ?? ?? 4C 8B 5D E8 49 8B D4 48 8B CB 45 39 73 08 75 1E 4C 8B CF 4C 8B C6 E8 ?? ?? ?? ?? 44 38 75 F8 74 B4 48 8B 4D F0 83 A1 C8 00 00 00 FD EB A7 48 83 FF FF 75 15 8A 06 48 FF C6 88 01 48 FF C1 84 C0 74 2A 48 FF CA 75 ED EB 23 8A 06 48 FF C6 88 01 48 FF C1 84 C0 74 0A 48 FF CA 74 05 48 FF CF 75 E8 48 85 FF 75 06 44 88 31 48 FF C1 48 85 D2 0F 85 EC 00 00 00 44 38 36 74 06 48 83 FF 01 75 55 4C 8D 69 FF 49 8B F5 4C 3B EB 72 18 0F B6 0E 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CE 48 3B F3 73 E8 41 8B C5 2B C6 A8 01 74 28 45 88 75 00 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 44 38 75 F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C2 E9 00 FF FF FF 48 83 FF FF 75 58 49 83 FC 01 76 4B 4A 8D 74 23 FE 48 8B FE 48 3B F3 72 18 0F B6 0F 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CF 48 3B FB 73 E8 8B C6 2B C7 A8 01 74 1E 44 88 36 44 38 75 F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 50 00 00 00 E9 A9 FE FF FF 46 88 74 23 FF EB DE 44 88 33 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? 44 38 75 F8 0F 84 82 FE FF FF 48 8B 4D F0 83 A1 C8 00 00 00 FD E9 72 FE FF FF 48 8B C1 48 2B C3 48 83 F8 02 7C 55 48 8D 71 FE 48 8B FE 48 3B F3 72 18 0F B6 0F 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CF 48 3B FB 73 E8 8B C6 2B C7 A8 01 74 29 44 88 36 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 44 38 75 F8 0F 84 1C FF FF FF 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 0C FF FF FF 44 38 75 F8 0F 84 D6 FD FF FF 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 C6 FD FF FF }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "fast_error_exit"
		size = 44
		refs = "0008 __error_mode 0012 _FF_MSGBANNER 0019 _NMSG_WRITE 0028 __crtExitProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 83 3D ?? ?? ?? ?? 02 8B D9 74 05 E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? B9 FF 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "check_managed_app"
		size = 74
		refs = "0008 __ImageBase"
	strings:
		$1 = { B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 03 33 C0 C3 48 63 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 03 C8 81 39 50 45 00 00 75 E4 B8 0B 02 00 00 66 39 41 18 75 D9 33 C0 83 B9 84 00 00 00 0E 76 09 39 81 F8 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 375
		refs = "0012 __ImageBase 0059 _heap_init 0063 __error_mode 006b _FF_MSGBANNER 0075 _NMSG_WRITE 007f __crtExitProcess 0084 _mtinit 00af _RTC_Initialize 00b5 _ioinit 00c3 _amsg_exit 00c9 __imp_GetCommandLineA 00d0 _acmdln 00d5 __crtGetEnvironmentStringsA 00dc _aenvptr 00e1 _setargv 00f4 _setenvp 010c _cinit 011e _environ 0125 __initenv 012c __argv 0132 __argc 0137 main 0148 exit 014d _cexit 015f _exit 0165 _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 38 48 63 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 03 C1 81 38 50 45 00 00 75 E3 B9 0B 02 00 00 66 39 48 18 75 D8 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 5C 24 40 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? B9 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 17 8B F8 83 7C 24 40 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_676_2_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 375
		refs = "0012 __ImageBase 0059 _heap_init 0063 __error_mode 006b _FF_MSGBANNER 0075 _NMSG_WRITE 007f __crtExitProcess 0084 _mtinit 00af _RTC_Initialize 00b5 _ioinit 00c3 _amsg_exit 00c9 __imp_GetCommandLineW 00d0 _wcmdln 00d5 __crtGetEnvironmentStringsW 00dc _wenvptr 00e1 _wsetargv 00f4 _wsetenvp 010c _cinit 011e _wenviron 0125 __winitenv 012c __wargv 0132 __argc 0137 wmain 0148 exit 014d _cexit 015f _exit 0165 _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 38 48 63 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 03 C1 81 38 50 45 00 00 75 E3 B9 0B 02 00 00 66 39 48 18 75 D8 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 5C 24 40 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? B9 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 17 8B F8 83 7C 24 40 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "__tmainCRTStartup$filt$0"
		size = 30
		refs = "0012 _XcptFilter"
		altNames = "_callthreadstart$filt$0 _callthreadstartex$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 48 8B D1 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_599_3_0 {
	meta:
		name = "__DllMainCRTStartup$filt$0"
		size = 30
		refs = "0012 __CppXcptFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 48 8B D1 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "mainCRTStartup"
		size = 18
		refs = "0005 __security_init_cookie 000e __tmainCRTStartup"
		altNames = "WinMainCRTStartup wWinMainCRTStartup wmainCRTStartup"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_766_15_0 {
	meta:
		name = "?StandardDeviation@MeasuredHistory@HillClimbing@details@Concurrency@@QEAANXZ"
		size = 18
		refs = "0005 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QEAANXZ 000e sqrt"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_sincos_special"
		size = 218
		refs = "00cb _handle_error"
	strings:
		$1 = { 48 83 EC 58 F2 0F 11 44 24 60 41 8B C8 4C 8B D2 4C 8B 44 24 60 48 BA 00 00 00 00 00 00 F0 7F 66 0F 28 C8 49 8B C0 48 23 C2 48 3B C2 0F 85 9D 00 00 00 48 B8 FF FF FF FF FF FF 0F 00 4C 85 C0 75 3F 66 0F 57 C0 48 B8 00 00 00 00 00 00 F8 FF 41 B9 01 00 00 00 44 89 4C 24 40 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 48 89 44 24 60 4C 8B C0 C7 44 24 20 08 00 00 00 EB 45 48 BA 00 00 00 00 00 00 08 00 49 8B C0 48 23 C2 48 3B C2 74 08 4C 0B C2 4C 89 44 24 60 66 0F 57 C0 41 B9 01 00 00 00 44 89 4C 24 40 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 8B D1 49 8B CA E8 ?? ?? ?? ?? F2 0F 10 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "_sincosf_special"
		size = 151
		refs = "0088 _handle_errorf"
	strings:
		$1 = { 48 83 EC 58 48 83 64 24 78 00 0F 28 C8 4C 8B DA BA 00 00 80 7F 45 8B D0 F3 0F 11 4C 24 78 8B 4C 24 78 8B C1 23 C2 3B C2 75 62 0F 57 C0 41 B9 01 00 00 00 44 89 4C 24 40 F3 0F 11 44 24 38 F3 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 F7 C1 FF FF 7F 00 75 12 C7 44 24 78 00 00 C0 FF C7 44 24 20 08 00 00 00 EB 16 B8 00 00 40 00 85 C8 75 08 0B C8 89 4C 24 78 EB E5 83 64 24 20 00 4C 8B 44 24 78 41 8B D2 49 8B CB E8 ?? ?? ?? ?? F3 0F 10 44 24 78 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "_sinf_special"
		size = 18
		refs = "0003 ??_C@_04LAGPAAHP@sinf?$AA@ 000e _sincosf_special"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 41 B8 1E 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "_sin_special"
		size = 18
		refs = "0003 ??_C@_03BLEJJJBH@sin?$AA@ 000e _sincos_special"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 41 B8 1E 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "_cosf_special"
		size = 18
		refs = "0003 ??_C@_04OBBKPIAC@cosf?$AA@ 000e _sincosf_special"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 41 B8 12 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "_cos_special"
		size = 18
		refs = "0003 ??_C@_03LALBNOCG@cos?$AA@ 000e _sincos_special"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 41 B8 12 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__security_init_cookie"
		size = 179
		refs = "000d __security_cookie 002c __security_cookie_complement 0039 __imp_GetSystemTimeAsFileTime 0044 __imp_GetCurrentProcessId 0050 __imp_GetCurrentThreadId 005c __imp_GetTickCount 006d __imp_QueryPerformanceCounter"
	strings:
		$1 = { 48 89 5C 24 18 57 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 83 64 24 30 00 48 BF 32 A2 DF 2D 99 2B 00 00 48 3B C7 74 0C 48 F7 D0 48 89 05 ?? ?? ?? ?? EB 76 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 FF 15 ?? ?? ?? ?? 44 8B D8 49 33 DB FF 15 ?? ?? ?? ?? 44 8B D8 49 33 DB FF 15 ?? ?? ?? ?? 48 8D 4C 24 38 44 8B D8 49 33 DB FF 15 ?? ?? ?? ?? 4C 8B 5C 24 38 4C 33 DB 48 B8 FF FF FF FF FF FF 00 00 4C 23 D8 48 B8 33 A2 DF 2D 99 2B 00 00 4C 3B DF 4C 0F 44 D8 4C 89 1D ?? ?? ?? ?? 49 F7 D3 4C 89 1D ?? ?? ?? ?? 48 8B 5C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "__ascii_strnicmp"
		size = 70
	strings:
		$1 = { 4C 8B D1 4D 85 C0 74 3B 45 0F B6 0A 49 FF C2 41 8D 41 BF 83 F8 19 77 04 41 83 C1 20 0F B6 0A 48 FF C2 8D 41 BF 83 F8 19 77 03 83 C1 20 49 FF C8 74 0A 45 85 C9 74 05 44 3B C9 74 CC 44 2B C9 41 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "_strnicmp_l"
		size = 259
		refs = "0035 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 003f _errno 004a _invalid_parameter_noinfo 008b __ascii_strnicmp 00ae _tolower_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 55 48 8B EC 48 83 EC 40 4D 8B E0 48 8B F2 48 8B F9 4D 85 C0 0F 84 BA 00 00 00 48 8D 4D E0 49 8B D1 E8 ?? ?? ?? ?? 48 85 FF 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 FF FF FF 7F E9 80 00 00 00 48 85 F6 74 D0 49 81 FC FF FF FF 7F 77 C7 48 8B 45 E0 83 78 14 00 75 21 4D 8B C4 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 80 7D F8 00 74 54 48 8B 4D F0 83 A1 C8 00 00 00 FD EB 47 48 2B FE 0F B6 0C 37 48 8D 55 E0 E8 ?? ?? ?? ?? 0F B6 0E 48 8D 55 E0 8B D8 E8 ?? ?? ?? ?? 48 FF C6 49 FF CC 74 08 85 DB 74 04 3B D8 74 D5 2B D8 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C3 EB 02 33 C0 48 8B 5C 24 50 48 8B 74 24 58 48 8B 7C 24 60 4C 8B 64 24 68 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "_strnicmp"
		size = 79
		refs = "0006 __locale_changed 0013 _errno 001e _invalid_parameter_noinfo 003f __ascii_strnicmp 004b _strnicmp_l"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 36 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 49 81 F8 FF FF FF 7F 77 D8 48 83 C4 28 E9 ?? ?? ?? ?? 45 33 C9 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_616_4_0 {
	meta:
		name = "_strncoll"
		size = 79
		refs = "0006 __locale_changed 0013 _errno 001e _invalid_parameter_noinfo 003f strncmp 004b _strncoll_l"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 36 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 49 81 F8 FF FF FF 7F 77 D8 48 83 C4 28 E9 ?? ?? ?? ?? 45 33 C9 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_687_4_0 {
	meta:
		name = "_wcsncoll"
		size = 79
		refs = "0006 __locale_changed 0013 _errno 001e _invalid_parameter_noinfo 003f wcsncmp 004b _wcsncoll_l"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 36 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 49 81 F8 FF FF FF 7F 77 D8 48 83 C4 28 E9 ?? ?? ?? ?? 45 33 C9 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "_wsearchenv_s"
		size = 814
		refs = "0017 __security_cookie 0046 _errno 0051 _invalid_parameter_noinfo 008a _waccess_s 00a5 _wfullpath 00c7 _wdupenv_s 00e8 _invoke_watson 00ff wcslen 012b _calloc_crt 0173 _wgetpath 022a wcscpy_s 0269 free 0316 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 78 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 02 00 00 33 F6 4D 8B F1 4C 89 4C 24 40 4D 8B E0 4C 8B FA 4C 8B E9 48 89 74 24 30 8B EE 4D 85 C0 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 E9 AB 02 00 00 4D 85 C9 74 E1 48 85 C9 75 06 66 41 89 30 EB D6 66 39 31 75 09 66 41 89 30 E9 5D 02 00 00 E8 ?? ?? ?? ?? 33 D2 49 8B CD 8B 38 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 38 85 DB 75 21 4D 8B C6 49 8B D5 49 8B CC E8 ?? ?? ?? ?? 48 85 C0 0F 85 3A 02 00 00 66 41 89 34 24 E9 29 02 00 00 48 8D 4C 24 30 4D 8B C7 33 D2 E8 ?? ?? ?? ?? 85 C0 74 1E 83 F8 16 0F 85 FD 01 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 48 8B 5C 24 30 48 85 DB 0F 84 DA 01 00 00 49 8B CD E8 ?? ?? ?? ?? BF 08 01 00 00 48 8D 6C 24 50 4C 8B F8 48 3B C7 72 37 48 8B CB E8 ?? ?? ?? ?? BA 02 00 00 00 4A 8D 7C 38 02 48 8B CF E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 15 66 41 89 34 24 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 99 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 44 24 38 48 85 DB 0F 84 75 01 00 00 4C 8B C7 48 8B D5 48 8B CB 4D 2B C7 4C 8B F3 49 FF C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 5D 48 8D 44 24 50 48 3B E8 0F 85 48 01 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 3A 01 00 00 49 8B CE E8 ?? ?? ?? ?? 8D 53 02 4A 8D 7C 38 02 48 8B CF E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 0F 84 78 FF FF FF 4C 8B C7 48 8B D0 49 8B CE 4D 2B C7 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 F9 00 00 00 66 39 75 00 0F 84 EF 00 00 00 48 8B CD E8 ?? ?? ?? ?? 4C 8B F0 48 8D 4C 45 00 0F B7 41 FE 83 F8 2F 74 18 BA 5C 00 00 00 3B C2 74 0F 83 F8 3A 74 0A 66 89 11 48 83 C1 02 49 FF C6 48 8B C1 48 8B D7 4D 8B C5 48 2B C5 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 8A 00 00 00 33 D2 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 0F FF FF FF 48 8B 5C 24 40 4B 8D 04 3E 48 3B C3 72 24 48 8D 44 24 50 66 41 89 34 24 48 3B E8 74 08 48 8B CD E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 6B E8 ?? ?? ?? ?? 8B 4C 24 38 4C 8B C5 89 08 49 8B CC 48 8B D3 E8 ?? ?? ?? ?? 85 C0 75 14 48 8D 44 24 50 48 3B E8 74 4B 48 8B CD E8 ?? ?? ?? ?? EB 41 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 66 41 89 34 24 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 48 8D 44 24 50 48 3B E8 74 08 48 8B CD E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C6 48 8B 8C 24 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 78 02 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 31
		refs = "0003 __security_cookie 001b __report_gsfailure"
	strings:
		$1 = { 48 3B 0D ?? ?? ?? ?? 75 11 48 C1 C1 10 66 F7 C1 FF FF 75 02 F3 C3 48 C1 C9 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "localeconv"
		size = 56
		refs = "0005 _getptd 000c __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo 002f __lconv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 39 88 C0 00 00 00 74 13 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "modf"
		size = 192
	strings:
		$1 = { 48 B9 FF FF FF FF FF FF FF 7F F2 0F 11 44 24 08 66 0F 28 C8 4C 8B 44 24 08 49 8B C0 48 23 C1 48 B9 00 00 00 00 00 00 40 43 48 3B C1 72 32 48 B9 00 00 00 00 00 00 F0 7F F2 0F 11 02 48 3B C1 76 06 F2 0F 58 C9 EB 74 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 08 F2 0F 10 44 24 08 C3 48 B9 00 00 00 00 00 00 F0 3F 48 3B C1 73 1A 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 08 F2 0F 10 44 24 08 EB 2E 49 8B C0 B9 33 00 00 00 48 C1 E8 34 2A C8 B8 01 00 00 00 48 D3 E0 48 FF C8 48 F7 D0 49 23 C0 48 89 44 24 08 F2 0F 10 44 24 08 F2 0F 5C C8 F2 0F 11 02 66 0F 28 C1 C3 }
	condition:
		$1
}

rule file_38_5_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@XZ"
		size = 40
		refs = "0010 memset"
	strings:
		$1 = { 40 53 48 83 EC 20 33 D2 48 8B D9 44 8D 42 10 E8 ?? ?? ?? ?? 45 33 DB 48 8B C3 66 44 89 5B 08 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_38_16_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAV012@@Z"
		size = 154
		refs = "001f ??_7ExecutionResource@details@Concurrency@@6B@ 003e memset"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 45 33 E4 48 8D 05 ?? ?? ?? ?? 49 8B F0 48 89 01 45 8D 44 24 10 48 8B FA 48 8B E9 44 89 61 08 33 D2 49 03 C8 E8 ?? ?? ?? ?? 66 44 89 65 18 4C 89 65 10 48 89 7D 20 48 89 75 28 4C 89 65 30 4C 89 65 38 48 8B 06 48 8B CE FF 10 48 8B CE 89 45 40 8B 46 44 44 89 65 4C 89 45 44 48 8B 06 FF 50 08 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 89 45 48 48 8B C5 48 8B 6C 24 38 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_38_19_0 {
	meta:
		name = "?Remove@ExecutionResource@details@Concurrency@@UEAAXPEAUIScheduler@3@@Z"
		size = 179
		refs = "001a ??_C@_0L@HKFDMHB@pScheduler?$AA@ 002b ??0exception@std@@QEAA@AEBQEBD@Z 0032 ??_7invalid_argument@std@@6B@ 0039 _TI3?AVinvalid_argument@std@@ 0048 _CxxThrowException 0052 ?GetCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@XZ 0061 ??0invalid_operation@Concurrency@@QEAA@XZ 0068 _TI2?AVinvalid_operation@Concurrency@@ 00af ?RemoveExecutionResource@ResourceManager@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 57 48 83 EC 40 48 8B FA 48 8B D9 48 85 D2 75 36 48 8D 05 ?? ?? ?? ?? 49 8D 53 10 49 8D 4B D8 49 89 43 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 49 20 E8 ?? ?? ?? ?? 48 3B C3 74 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8B 4B 20 48 39 79 10 74 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8B 49 18 48 8B D3 48 8B 5C 24 50 48 83 C4 40 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_24_0 {
	meta:
		name = "?SetAsCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 61
		refs = "001f __imp_TlsGetValue 0039 __imp_TlsSetValue"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 20 48 8B F9 48 8B 50 18 8B 9A B8 00 00 00 8B CB FF 15 ?? ?? ?? ?? 48 8B D7 8B CB 48 89 47 38 48 8B 5C 24 30 48 83 C4 20 5F 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_25_0 {
	meta:
		name = "?ResetCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 44
		refs = "001d __imp_TlsSetValue"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 41 20 48 8B D9 48 8B 48 18 48 8B 53 38 8B 89 B8 00 00 00 FF 15 ?? ?? ?? ?? 48 83 63 38 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_38_26_0 {
	meta:
		name = "?IncrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 282
		refs = "0017 __security_cookie 005c ?IncrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z 006a __imp_GetCurrentThread 007a ??0HardwareAffinity@details@Concurrency@@QEAA@PEAX@Z 00b3 memset 00ca ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z 00d6 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00e2 ?AddExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00ec ?AddThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00f4 ?SetAsCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ 0101 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 48 8B E9 8B 49 4C 8D 41 01 89 45 4C 85 C9 0F 85 C1 00 00 00 48 83 7D 30 00 48 8B 4D 20 0F 95 C3 48 83 7D 28 00 0F 85 9A 00 00 00 44 8B 45 44 8B 55 40 84 DB 41 0F 94 C1 E8 ?? ?? ?? ?? 84 DB 0F 85 88 00 00 00 FF 15 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D0 48 8B F0 E8 ?? ?? ?? ?? 0F B7 48 08 66 89 4D 18 48 8B 08 48 89 4D 10 48 8B 4D 20 44 8B 45 40 48 8B 51 20 4D 6B C0 38 48 8D 4C 24 20 49 8B 3C 10 41 0F B7 5C 10 14 33 D2 44 8D 42 10 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D6 66 89 5C 24 28 48 89 7C 24 20 E8 ?? ?? ?? ?? 48 8B 4D 20 48 8B D5 E8 ?? ?? ?? ?? 48 8B 4D 20 48 8B D5 E8 ?? ?? ?? ?? EB 08 48 8B D5 E8 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_38_27_0 {
	meta:
		name = "?DecrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 141
		refs = "001c ?ResetCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ 003c ?DecrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z 0047 __imp_GetCurrentThread 0053 ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z 005f ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 006b ?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 0072 ?DecrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ 007e ?RemoveThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 FF 49 4C 48 8B D9 75 70 48 83 79 30 00 40 0F 95 C7 E8 ?? ?? ?? ?? 48 8B 4B 28 48 85 C9 75 48 44 8B 43 44 8B 53 40 48 8B 4B 20 40 84 FF 41 0F 94 C1 E8 ?? ?? ?? ?? 40 84 FF 75 3D FF 15 ?? ?? ?? ?? 48 8D 4B 10 48 8B D0 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? EB 11 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_38_28_0 {
	meta:
		name = "?CurrentSubscriptionLevel@ExecutionResource@details@Concurrency@@UEBAIXZ"
		size = 20
		refs = "0010 ?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QEAAIII@Z"
	strings:
		$1 = { 48 8B 41 20 44 8B 41 44 8B 51 40 48 8B 48 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_31_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 172
		refs = "001e ??_7ExecutionResource@details@Concurrency@@6B@ 003f memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 48 83 EC 20 45 33 ED 48 8D 05 ?? ?? ?? ?? 49 8B E8 48 89 01 45 8D 45 10 48 8B FA 4C 8B E1 44 89 69 08 33 D2 49 03 C8 41 8B F1 E8 ?? ?? ?? ?? 48 8B 5C 24 40 66 45 89 6C 24 18 4D 89 6C 24 10 49 89 7C 24 20 4D 89 6C 24 28 4D 89 6C 24 30 4D 89 6C 24 38 8B 45 18 41 89 44 24 40 41 89 74 24 44 45 89 6C 24 4C 48 8B 45 30 8B CE 48 8B 74 24 50 48 6B C9 38 0F B6 54 01 04 8B 45 14 48 8B 6C 24 48 C1 E0 08 03 D0 49 8B C4 41 89 54 24 48 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "_tolower_l"
		size = 334
		refs = "001a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 003f _isctype_l 00a0 _isleadbyte_l 00bc _errno 010d __crtLCMapStringA"
	strings:
		$1 = { 48 89 7C 24 10 4C 89 64 24 20 55 48 8B EC 48 83 EC 70 48 63 F9 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FF 00 01 00 00 73 5D 48 8B 55 E0 83 BA 0C 01 00 00 01 7E 16 4C 8D 45 E0 BA 01 00 00 00 8B CF E8 ?? ?? ?? ?? 48 8B 55 E0 EB 0E 48 8B 82 40 01 00 00 0F B7 04 78 83 E0 01 85 C0 74 10 48 8B 82 48 01 00 00 0F B6 04 38 E9 C0 00 00 00 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 8B C7 E9 B9 00 00 00 48 8B 45 E0 83 B8 0C 01 00 00 01 7E 2B 44 8B E7 48 8D 55 E0 41 C1 FC 08 41 0F B6 CC E8 ?? ?? ?? ?? 85 C0 74 13 44 88 65 10 40 88 7D 11 C6 45 12 00 BA 02 00 00 00 EB 18 E8 ?? ?? ?? ?? BA 01 00 00 00 C7 00 2A 00 00 00 40 88 7D 10 C6 45 11 00 48 8B 4D E0 C7 44 24 40 01 00 00 00 4C 8D 4D 10 8B 41 04 41 B8 00 01 00 00 89 44 24 38 48 8D 45 20 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 54 24 20 8B 51 14 48 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 0F 84 52 FF FF FF 83 F8 01 0F B6 45 20 74 09 0F B6 4D 21 C1 E0 08 0B C1 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 70 49 8B 7B 18 4D 8B 63 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "tolower"
		size = 30
		refs = "0002 __locale_changed 001a _tolower_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0E 8D 41 BF 83 F8 19 77 03 83 C1 20 8B C1 C3 33 D2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YAJPEAU_EXCEPTION_POINTERS@@@Z"
		size = 65
		refs = "0035 ?terminate@@YAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 81 38 63 73 6D E0 75 2B 83 78 18 04 75 25 8B 40 20 3D 20 05 93 19 74 15 3D 21 05 93 19 74 0E 3D 22 05 93 19 74 07 3D 00 40 99 01 75 06 E8 ?? ?? ?? ?? CC 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__CxxSetUnhandledExceptionFilter"
		size = 24
		refs = "0007 ?__CxxUnhandledExceptionFilter@@YAJPEAU_EXCEPTION_POINTERS@@@Z 000d __imp_SetUnhandledExceptionFilter"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_execlp"
		size = 164
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0063 _capture_argv 0079 _execvp 0093 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 38 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 64 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 64 24 20 00 48 8D 54 24 30 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 38 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "_purecall"
		size = 55
		refs = "0007 __pPurecall 000d __imp_DecodePointer 001e _NMSG_WRITE 002a _set_abort_behavior 0033 abort"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 74 02 FF D0 B9 19 00 00 00 E8 ?? ?? ?? ?? BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "_set_purecall_handler"
		size = 59
		refs = "0010 __pPurecall 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_251_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 59
		refs = "0010 ?__pInconsistency@@3P6AXXZEA 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_228_2_0 {
	meta:
		name = "_set_invalid_parameter_handler"
		size = 59
		refs = "0010 __pInvalidArgHandler 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_chsize_nolock"
		size = 408
		refs = "002b _lseeki64_nolock 005c __imp_GetProcessHeap 0071 __imp_HeapAlloc 007e _errno 00b6 _setmode_nolock 00cd _write_nolock 00e3 __doserrno 0115 __imp_HeapFree 0137 _get_osfhandle 0140 __imp_SetEndOfFile 016a __imp_GetLastError"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 57 48 83 EC 20 48 8B EA 33 FF 33 D2 44 8D 47 01 8B F1 E8 ?? ?? ?? ?? 4C 8B E8 48 83 F8 FF 74 50 44 8D 47 02 33 D2 8B CE E8 ?? ?? ?? ?? 48 83 F8 FF 74 3D 48 8B DD 48 2B D8 48 85 DB 0F 8E C1 00 00 00 FF 15 ?? ?? ?? ?? 41 BF 00 10 00 00 8D 57 08 48 8B C8 45 8B C7 FF 15 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5D 41 5C C3 BA 00 80 00 00 8B CE E8 ?? ?? ?? ?? 44 8B E0 44 8B C3 49 3B DF 48 8B D5 45 0F 4D C7 8B CE E8 ?? ?? ?? ?? 83 F8 FF 74 0C 48 98 48 2B D8 48 85 DB 7E 1B EB DB E8 ?? ?? ?? ?? 83 38 05 75 0B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 48 83 CF FF 41 8B D4 8B CE E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8B C5 48 8B C8 33 D2 FF 15 ?? ?? ?? ?? EB 55 79 5D 45 33 C0 48 8B D5 8B CE E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 54 FF FF FF 8B CE E8 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? F7 D8 48 1B FF 48 F7 DF 48 FF CF 48 83 FF FF 75 25 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 89 03 48 83 FF FF 0F 84 0E FF FF FF 45 33 C0 49 8B D5 8B CE E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 F7 FE FF FF 33 C0 E9 F7 FE FF FF }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "_chsize_s"
		size = 239
		refs = "0023 __doserrno 003c _nhandle 004f __pioinfo 007e _errno 008c __lock_fhandle 00a3 _chsize_nolock 00ba _unlock_fhandle 00d5 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 20 89 4C 24 08 57 41 54 41 55 48 83 EC 20 48 8B DA 48 63 F9 83 FF FE 75 10 E8 ?? ?? ?? ?? 83 20 00 8D 47 0B E9 A9 00 00 00 85 C9 0F 88 86 00 00 00 3B 3D ?? ?? ?? ?? 73 7E 48 8B F7 4C 8B E7 49 C1 FC 05 4C 8D 2D ?? ?? ?? ?? 83 E6 1F 48 6B F6 58 4B 8B 44 E5 00 0F BE 4C 30 08 83 E1 01 74 57 33 C0 48 85 D2 0F 99 C0 85 C0 75 14 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? BB 16 00 00 00 EB 49 8B CF E8 ?? ?? ?? ?? 90 4B 8B 44 E5 00 F6 44 30 08 01 74 0E 48 8B D3 8B CF E8 ?? ?? ?? ?? 8B D8 EB 0C E8 ?? ?? ?? ?? BB 09 00 00 00 89 18 8B CF E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? BB 09 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 48 48 8B 74 24 58 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "_chsize_s$fin$0"
		size = 25
		refs = "000d _unlock_fhandle"
		altNames = "_close$fin$0 _commit$fin$0 _dup$fin$0 _eof$fin$0 _setmode$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_44_3_0 {
	meta:
		name = "_chsize"
		size = 21
		refs = "0008 _chsize_s"
	strings:
		$1 = { 48 83 EC 28 48 63 D2 E8 ?? ?? ?? ?? F7 D8 1B C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "scaleDouble_1"
		size = 33
	strings:
		$1 = { 66 0F 28 C8 48 63 C2 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 08 F2 0F 10 44 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "valf_with_flags"
		size = 35
		refs = "0012 _controlfp_s"
	strings:
		$1 = { 48 83 EC 38 44 8B C2 33 C9 0F 29 74 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "splitexp"
		size = 302
		refs = "0008 __real@3fe0000000000000 002f __real@0000000000000000 004c __ImageBase 0063 ?two_to_jby32_trail_table@?1??splitexp@@9@9 006c ?two_to_jby32_lead_table@?1??splitexp@@9@9 00d4 __real@3f56c1728d739765 00dc __real@3f811115b7aa905e 00e8 __real@3fa5555555545d4e 00f4 __real@3fc5555555548f7c"
	strings:
		$1 = { 48 83 EC 38 F2 0F 10 2D ?? ?? ?? ?? 0F 29 74 24 20 0F 29 7C 24 10 66 0F 28 E0 66 0F 28 F9 66 0F 28 F0 44 0F 29 04 24 F2 0F 59 E2 66 0F 2F 25 ?? ?? ?? ?? 66 44 0F 28 C3 76 06 F2 0F 58 E5 EB 04 F2 0F 5C E5 F2 44 0F 2C C4 48 8D 15 ?? ?? ?? ?? 41 8B C8 66 41 0F 6E C0 83 E1 1F 48 63 C1 F2 0F 10 A4 C2 ?? ?? ?? ?? F2 0F 10 9C C2 ?? ?? ?? ?? 41 8B C0 2B C1 48 8B 4C 24 68 99 83 E2 1F F3 0F E6 C0 03 C2 C1 F8 05 41 F7 D8 89 01 48 8B 44 24 70 F2 41 0F 59 C0 44 0F 28 04 24 F2 0F 5C F0 F2 0F 59 F1 66 41 0F 6E C8 F2 0F 11 18 48 8B 44 24 78 F3 0F E6 C9 F2 0F 59 4C 24 60 F2 0F 59 CF 0F 28 7C 24 10 66 0F 28 C1 F2 0F 58 C6 66 0F 28 D0 F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 C0 F2 0F 58 D5 F2 0F 59 D0 66 0F 28 C4 F2 0F 58 C3 F2 0F 58 D1 F2 0F 58 D6 0F 28 74 24 20 F2 0F 59 D0 F2 0F 58 D4 F2 0F 11 10 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "sinhf"
		size = 732
		refs = "0054 _controlfp_s 0089 ??_C@_05PJDDOCIG@sinhf?$AA@ 00b0 _handle_errorf 00d2 __mask@@NegDouble@ 00da ?max_sinh_arg@?1??sinhf@@9@9 0130 ?small_threshold@?1??sinhf@@9@9 013e ?log2_by_32_tail@?1??sinhf@@9@9 0146 ?log2_by_32_lead@?1??sinhf@@9@9 014e ?thirtytwo_by_log2@?1??sinhf@@9@9 0184 __real@3ff0000000000000 0189 splitexp 01db __ImageBase 01fb __real@3d6b4125921ea08b 0207 __real@3de611cb2bdcb7be 0213 __real@3e5ae6460fbe61c0 021f __real@3ec71de3a4e13e7d 022b __real@3f2a01a01a01ee80 0237 __real@3f811111111110fd 0243 __real@3fc5555555555555 0253 __real@3da9984b7f63fcd7 0260 ?cosh_lead@?1??sinhf@@9@9 0268 __real@3e21ee56385b7b20 0274 __real@3e927e5069f1cb55 0280 __real@3efa01a019079011 028c __real@3f56c16c16c212e5 0298 __real@3fa5555555555502 02a4 __real@3fe0000000000000 02b9 ?sinh_lead@?1??sinhf@@9@9"
	strings:
		$1 = { 48 83 EC 68 0F 29 74 24 50 48 BA FF FF FF FF FF FF FF 7F 0F 28 F0 0F 14 F6 0F 5A E6 F2 0F 11 64 24 78 48 8B 4C 24 78 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 10 3F 48 3B C2 73 1E 48 85 C0 75 08 0F 28 C6 E9 89 02 00 00 BA 10 00 00 00 33 C9 44 8B C2 E8 ?? ?? ?? ?? EB E7 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 72 56 76 4E 0F 57 C0 C7 44 24 40 01 00 00 00 F3 0F 11 74 24 78 44 8B 44 24 78 BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? F3 0F 11 44 24 38 F3 0F 11 74 24 30 49 0F BA E8 16 C7 44 24 28 21 00 00 00 83 64 24 20 00 44 8D 4A E2 E8 ?? ?? ?? ?? E9 19 02 00 00 F3 0F 58 F6 EB 82 45 33 D2 48 3B C1 41 0F 95 C2 4D 85 D2 74 08 66 0F 57 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 72 4C 0F 57 C0 C7 44 24 40 01 00 00 00 BA 1F 00 00 00 F3 0F 11 44 24 38 F3 0F 11 74 24 30 C7 44 24 28 22 00 00 00 48 8D 0D ?? ?? ?? ?? C7 44 24 20 01 00 00 00 44 8D 4A E4 4D 85 D2 74 08 41 B8 00 00 80 FF EB 8B 41 B8 00 00 80 7F EB 83 66 0F 2F 25 ?? ?? ?? ?? 0F 82 93 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 84 24 88 00 00 00 48 89 44 24 38 48 8D 84 24 80 00 00 00 48 89 44 24 30 48 8D 44 24 70 66 0F 28 C4 48 89 44 24 28 F2 0F 11 4C 24 20 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 4C 24 70 41 FF C9 49 63 C1 44 89 4C 24 70 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 78 F2 0F 10 44 24 78 F2 0F 10 94 24 80 00 00 00 F2 0F 58 94 24 88 00 00 00 F2 0F 59 D0 E9 F4 00 00 00 F2 0F 2C C4 66 0F 6E C0 48 63 C8 48 8D 05 ?? ?? ?? ?? F3 0F E6 C0 F2 0F 5C E0 66 0F 28 CC F2 0F 59 CC 66 0F 28 D1 66 0F 28 C1 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 C4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 66 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 D4 F2 0F 59 94 C8 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 84 C8 ?? ?? ?? ?? F2 0F 58 D0 4D 85 D2 74 08 66 0F 57 15 ?? ?? ?? ?? F2 0F 5A C2 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "idtab"
		size = 150
		refs = "0007 __idpairs 000e __idtabsiz 0063 _recalloc_crt"
	strings:
		$1 = { 48 83 EC 28 4C 8B 15 ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? 45 8B C8 49 8B D2 49 C1 E1 04 4D 03 CA 4D 3B D1 73 0E 48 39 0A 74 09 48 83 C2 10 49 3B D1 72 F2 49 3B D1 73 05 48 8B C2 EB 55 48 85 C9 75 4E 41 8D 40 01 41 3B C0 72 45 8B D0 48 B8 FF FF FF FF FF FF FF 0F 48 3B D0 73 34 44 8D 41 10 49 8B CA E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 20 8B 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B C1 48 C1 E0 04 49 03 C3 FF C1 89 0D ?? ?? ?? ?? EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "_popen"
		size = 1644
		refs = "003f _errno 004a _invalid_parameter_noinfo 00c8 _pipe 0104 _mtinitlocknum 0111 _close 0129 _lock 0138 __imp_GetCurrentProcess 014e __pioinfo 0182 __imp_DuplicateHandle 01ac _fdopen 01c7 idtab 01da ??_C@_07CFPBBAOO@COMSPEC?$AA@ 01e6 _dupenv_s 0204 _invoke_watson 0219 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 0230 memset 028a strlen 029f ??_C@_04NPFIMJFF@?5?1c?5?$AA@ 02b4 _calloc_crt 02ce strcpy_s 02e8 strcat_s 0323 _access_s 0368 __imp_CreateProcessA 0391 free 03b6 ??_C@_04HBHDLLBA@PATH?$AA@ 0408 _getpath 0440 _mbsrchr 044c ??_C@_01KICIPPFI@?2?$AA@ 0589 __imp_CloseHandle 060b fclose 0652 _unlock"
	strings:
		$1 = { 48 8B C4 48 89 48 08 53 56 57 41 54 41 55 41 56 41 57 48 81 EC 20 01 00 00 4C 8B E1 33 FF 44 8B F7 48 89 7C 24 60 66 89 78 18 40 88 78 1A 89 7C 24 58 8B C7 48 85 C9 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 04 06 00 00 8B C7 48 85 D2 0F 95 C0 85 C0 74 DD B1 20 BE 01 00 00 00 38 0A 75 05 48 03 D6 EB F7 8A 02 3C 77 74 04 3C 72 75 C3 88 84 24 70 01 00 00 48 03 D6 38 0A 74 F9 8A 02 84 C0 74 08 3C 74 74 04 3C 62 75 A7 88 84 24 71 01 00 00 3C 74 75 08 41 B8 00 40 00 00 EB 0E 44 8B C7 B9 00 80 00 00 3C 62 44 0F 44 C1 41 0F BA E8 07 BA 00 04 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 81 05 00 00 80 BC 24 70 01 00 00 77 75 0A 8B DF 44 8B EF 44 8B FE EB 08 8B DE 44 8B EE 44 8B FF 44 89 7C 24 68 44 89 AC 24 78 01 00 00 B9 09 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 17 8B 4C 24 50 E8 ?? ?? ?? ?? 8B 4C 24 54 E8 ?? ?? ?? ?? E9 2B FF FF FF B9 09 00 00 00 E8 ?? ?? ?? ?? 90 89 74 24 74 89 74 24 70 FF 15 ?? ?? ?? ?? 49 63 FD 48 63 4C BC 50 48 8B D1 48 C1 FA 05 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 49 8B 14 D0 C7 44 24 30 02 00 00 00 89 74 24 28 83 64 24 20 00 4C 8D 8C 24 80 00 00 00 4C 8B C0 48 8B 14 0A 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 0F 84 97 04 00 00 8B 4C BC 50 E8 ?? ?? ?? ?? 83 64 BC 70 00 49 63 C7 48 8D 94 24 70 01 00 00 8B 4C 84 50 E8 ?? ?? ?? ?? 4C 8B F0 48 89 84 24 88 00 00 00 48 85 C0 0F 84 61 04 00 00 33 C9 E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 0F 84 30 04 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 85 C0 74 1E 83 F8 16 75 15 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 C0 75 0A 4C 8B 6C 24 60 4D 85 ED 75 07 4C 8D 2D ?? ?? ?? ?? BF 68 00 00 00 44 8B C7 33 D2 48 8D 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 89 BC 24 B0 00 00 00 C7 84 24 EC 00 00 00 00 01 00 00 48 8B 84 24 80 00 00 00 48 8B 0D ?? ?? ?? ?? 85 DB 48 8B D0 74 03 48 8B 11 48 89 94 24 00 01 00 00 3B DE 74 04 48 8B 41 58 48 89 84 24 08 01 00 00 48 8B 81 B0 00 00 00 48 89 84 24 10 01 00 00 49 8B CD E8 ?? ?? ?? ?? 48 8B D8 49 8B CC E8 ?? ?? ?? ?? 48 03 D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 5C 18 01 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 3B 03 00 00 4D 8B C5 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 10 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D3 49 8B CC E8 ?? ?? ?? ?? 85 C0 0F 85 E1 02 00 00 4C 8B 84 24 60 01 00 00 48 8B D3 49 8B CC E8 ?? ?? ?? ?? 85 C0 0F 85 B1 02 00 00 E8 ?? ?? ?? ?? 8B 18 89 9C 24 60 01 00 00 33 D2 49 8B CD E8 ?? ?? ?? ?? 85 C0 75 48 48 8D 84 24 98 00 00 00 48 89 44 24 48 48 8D 84 24 B0 00 00 00 48 89 44 24 40 48 83 64 24 38 00 48 83 64 24 30 00 83 64 24 28 00 89 74 24 20 45 33 C9 45 33 C0 49 8B D4 49 8B CD FF 15 ?? ?? ?? ?? 8B F0 E9 FA 01 00 00 48 83 64 24 78 00 48 8B D6 B9 04 01 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 25 33 C9 E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 E9 4C 02 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 78 E8 ?? ?? ?? ?? 85 C0 74 2D 83 F8 16 75 15 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 C0 74 0F 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B CF EB 99 48 8B 4C 24 78 33 DB 41 B8 03 01 00 00 48 8B D7 E8 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 48 85 C0 0F 84 33 01 00 00 38 1F 0F 84 2B 01 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8D 5C 38 FF 80 3B 5C 75 3F BA 5C 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 3B D8 74 5F 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 47 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 80 3B 2F 74 2D 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 15 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 49 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 8B CF E8 ?? ?? ?? ?? 48 03 D8 B8 04 01 00 00 48 3B D8 0F 83 84 00 00 00 4D 8B C5 8B D0 48 8B CF E8 ?? ?? ?? ?? 33 DB 85 C0 75 5D 33 D2 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 42 48 8D 84 24 98 00 00 00 48 89 44 24 48 48 8D 84 24 B0 00 00 00 48 89 44 24 40 48 89 5C 24 38 48 89 5C 24 30 89 5C 24 28 89 74 24 20 45 33 C9 45 33 C0 49 8B D4 48 8B CF FF 15 ?? ?? ?? ?? 8B F0 EB 25 48 8B 8C 24 90 00 00 00 E9 C2 FE FF FF 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 8B 74 24 58 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 8B 9C 24 60 01 00 00 49 8B CC E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 48 8B 8C 24 A0 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 85 F6 74 14 48 8B 84 24 98 00 00 00 49 89 47 08 4D 89 37 E9 92 00 00 00 49 83 27 00 EB 3F 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 44 8B AC 24 78 01 00 00 49 8B CE E8 ?? ?? ?? ?? 4C 63 7C 24 68 42 83 64 BC 70 00 45 33 F6 4C 89 B4 24 88 00 00 00 49 63 C5 83 7C 84 70 00 74 09 8B 4C 84 50 E8 ?? ?? ?? ?? 49 63 C7 83 7C 84 70 00 74 0A 8B 4C 84 50 E8 ?? ?? ?? ?? 90 B9 09 00 00 00 E8 ?? ?? ?? ?? 49 8B C6 48 81 C4 20 01 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "_popen$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_wpopen$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 50 48 8B EA B9 09 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 50 5D C3 CC }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "_pclose"
		size = 220
		refs = "0023 _errno 002e _invalid_parameter_noinfo 003f _mtinitlocknum 004d _lock 0056 idtab 0073 fclose 0096 _cwait 00c3 _unlock"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F1 48 83 CB FF 33 D2 48 85 C9 0F 95 C2 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C3 E9 93 00 00 00 B9 09 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 EB B9 09 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 4E 48 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 83 20 00 41 B8 01 00 00 00 48 8B 57 08 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 3B C3 75 0A E8 ?? ?? ?? ?? 83 38 04 75 04 8B 5C 24 30 E8 ?? ?? ?? ?? 89 30 48 83 27 00 48 83 67 08 00 B9 09 00 00 00 E8 ?? ?? ?? ?? E9 66 FF FF FF 48 8B 5C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "_pclose$fin$0"
		size = 27
		refs = "000f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 09 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_48_3_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_31_1 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_28_1 {
	meta:
		name = "??_G?$ISource@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ISource@_K@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_29_1 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_27_1 {
	meta:
		name = "??_G?$ITarget@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ITarget@_K@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_833_26_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_833_34_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_83_2 {
	meta:
		name = "??_G?$_Impl_base1@XAEB_K@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XAEB_K@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_103_1 {
	meta:
		name = "??_G?$_Impl_base1@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_104_2 {
	meta:
		name = "??_G?$_Impl_base1@XPEAV?$message@_K@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@_K@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_82_1 {
	meta:
		name = "??_G?$_Impl_base1@_NAEBW4agent_status@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@_NAEBW4agent_status@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_393_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NAEBW4agent_status@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@_NAEBW4agent_status@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_408_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0xd3335188@Concurrency@@$0A@@tr1@std@@XAEB_K@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XAEB_K@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_423_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0xd3335188@Concurrency@@$0A@@tr1@std@@XPEAV?$message@_K@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@_K@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_441_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0xd3335188@Concurrency@@$0A@@tr1@std@@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_463_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0xd3335188@Concurrency@@$0A@@tr1@std@@XPEAV?$message@_K@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@_K@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_483_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0xd3335188@Concurrency@@$0A@@tr1@std@@XPEAV?$message@_K@Concurrency@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Impl_base1@XPEAV?$message@_K@Concurrency@@@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_76_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_79_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_70_212_1 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_123_1 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_71_220_1 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_76_2 {
	meta:
		name = "??_G?$collate@D@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_316_1 {
	meta:
		name = "??_G?$collate@G@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_227_2 {
	meta:
		name = "??_G?$collate@_W@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_64_2 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_65_1 {
	meta:
		name = "??_G?$message@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$message@_K@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_46_101_1 {
	meta:
		name = "??_G?$messages@D@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_315_2 {
	meta:
		name = "??_G?$messages@G@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_250_1 {
	meta:
		name = "??_G?$messages@_W@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_105_2 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_318_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_253_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_53_133_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_342_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_262_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_5_79_2 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_283_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_200_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_5_106_2 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_305_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_227_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_595_55_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ExecutionResource@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_833_53_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_833_5_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_167_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_14_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7Scheduler@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_833_85_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_735_17_0 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_63_45_2 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_36_56_1 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_883_16_0 {
	meta:
		name = "??_G_Ref_count_base@tr1@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@tr1@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_63_47_2 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_52_184_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_27_2 {
	meta:
		name = "??_Gctype_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_63_3_2 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_73_10_2 {
	meta:
		name = "??_Gfacet@locale@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_46_73_1 {
	meta:
		name = "??_Gmessages_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_161_1 {
	meta:
		name = "??_Gmoney_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_57_1 {
	meta:
		name = "??_Gtime_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7facet@locale@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
		size = 142
		refs = "001d ?Initialize@VirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z 0046 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 004e ??3@YAXPEAX@Z 0058 ??2@YAPEAX_K@Z 0070 ??0UMSSchedulingContext@details@Concurrency@@QEAA@PEAVUMSThreadScheduler@12@PEAVUMSThreadVirtualProcessor@12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 89 74 24 50 48 8B F9 E8 ?? ?? ?? ?? 33 DB 48 89 9F 18 01 00 00 89 9F 08 01 00 00 48 8B 47 70 48 8B 30 48 8B 8F 10 01 00 00 48 85 C9 74 0F 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 85 C0 74 11 4C 8B C7 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 89 9F 10 01 00 00 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_48_6_0 {
	meta:
		name = "?StartupWorkerContext@UMSThreadVirtualProcessor@details@Concurrency@@UEAAXPEAVScheduleGroupBase@23@@Z"
		size = 51
		refs = "002f ?Activate@VirtualProcessor@details@Concurrency@@QEAAXPEAUIExecutionContext@3@@Z"
	strings:
		$1 = { 48 8B C2 48 8B 91 B0 00 00 00 4C 8B C1 48 85 D2 75 1C 49 8B 90 10 01 00 00 48 89 81 20 01 00 00 48 8B 89 88 00 00 00 48 8B 01 48 FF 60 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_7_0 {
	meta:
		name = "?Affinitize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVInternalContextBase@23@@Z"
		size = 19
		refs = "0006 ?Affinitize@VirtualProcessor@details@Concurrency@@MEAAXPEAVInternalContextBase@23@@Z"
	strings:
		$1 = { 48 85 D2 74 05 E9 ?? ?? ?? ?? 48 83 A1 B0 00 00 00 00 C3 }
	condition:
		$1
}

rule file_48_8_0 {
	meta:
		name = "?AttemptWake@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 39
		refs = "000a ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NXZ 001d ?Activate@VirtualProcessor@details@Concurrency@@QEAAXPEAUIExecutionContext@3@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 84 C0 74 0F 48 8B 93 B0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_48_9_0 {
	meta:
		name = "?MakeAvailableFromSchedulingContext@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 19
		refs = "000f ?MakeAvailable@VirtualProcessor@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B 81 10 01 00 00 48 89 81 B0 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_10_0 {
	meta:
		name = "?IsWaitingForReservedContext@UMSThreadVirtualProcessor@details@Concurrency@@QEAA_NXZ"
		size = 18
	strings:
		$1 = { 48 8B 91 10 01 00 00 48 39 91 B0 00 00 00 0F 94 C0 C3 }
	condition:
		$1
}

rule file_48_11_0 {
	meta:
		name = "?ToInternalContext@UMSThreadVirtualProcessor@details@Concurrency@@MEAAPEAVInternalContextBase@23@PEAUIExecutionContext@3@@Z"
		size = 17
	strings:
		$1 = { 33 C0 48 3B 91 10 01 00 00 48 0F 44 D0 48 8B C2 C3 }
	condition:
		$1
}

rule file_48_12_0 {
	meta:
		name = "?PreRunnableSearch@UMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAVInternalContextBase@23@XZ"
		size = 26
		refs = "000f ?MoveCompletionListToRunnables@UMSThreadScheduler@details@Concurrency@@QEAA_NPEAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 48 83 EC 28 48 8B D1 48 8B 49 70 48 8B 09 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_13_0 {
	meta:
		name = "??0UMSThreadVirtualProcessor@details@Concurrency@@QEAA@PEAVSchedulingNode@12@PEAUIVirtualProcessorRoot@2@@Z"
		size = 96
		refs = "0027 ??0VirtualProcessor@details@Concurrency@@QEAA@XZ 002f ??_7UMSThreadVirtualProcessor@details@Concurrency@@6B@ 0048 ?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 89 74 24 50 49 8B D8 48 8B FA 48 8B F1 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 06 48 83 A6 10 01 00 00 00 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 90 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_48_16_0 {
	meta:
		name = "??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ"
		size = 59
		refs = "0009 ??_7UMSThreadVirtualProcessor@details@Concurrency@@6B@ 0022 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 002a ??3@YAXPEAX@Z 0037 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8B 89 10 01 00 00 48 85 C9 74 0F 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_17_0 {
	meta:
		name = "?CriticalNotify@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 16
		refs = "000c ?AttemptWake@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { B8 01 00 00 00 87 81 08 01 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_3_0 {
	meta:
		name = "_mbccpy_s_l"
		size = 308
		refs = "003c _errno 0048 _invalid_parameter_noinfo 006e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 007b _ismbblead_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 49 8B F1 49 8B D8 48 8B EA 48 8B F9 4D 85 C0 74 04 41 83 20 00 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C9 75 2B 44 88 09 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 48 8B 54 24 70 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F B6 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 80 7E 01 00 75 31 C6 07 00 48 85 DB 74 06 C7 03 01 00 00 00 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 8B C2 EB 90 48 83 FD 02 73 30 C6 07 00 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? 80 7C 24 38 00 0F 84 69 FF FF FF 48 8B 4C 24 30 83 A1 C8 00 00 00 FD E9 58 FF FF FF 8A 06 88 07 8A 46 01 88 47 01 48 85 DB 74 17 C7 03 02 00 00 00 EB 0F 8A 06 88 07 48 85 DB 74 06 C7 03 01 00 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 E9 1A FF FF FF }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_logf_special_common"
		size = 271
		refs = "00fe _handle_errorf"
	strings:
		$1 = { 48 83 EC 78 41 FF C8 0F 29 74 24 60 41 8B D1 0F 28 F1 0F 28 D0 0F 84 9D 00 00 00 41 FF C8 74 6B 41 FF C8 0F 85 D9 00 00 00 48 83 64 24 50 00 0F 57 C0 48 8B 8C 24 A0 00 00 00 41 8D 40 01 F3 0F 11 94 24 88 00 00 00 F7 84 24 88 00 00 00 00 00 40 00 F3 0F 11 74 24 50 4C 8B 44 24 50 89 44 24 40 44 8B C8 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 21 00 00 00 75 0A C7 44 24 20 08 00 00 00 EB 79 83 64 24 20 00 EB 72 0F 57 C0 B8 01 00 00 00 89 44 24 40 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 44 8B C8 EB 2C 0F 57 C0 B8 01 00 00 00 89 44 24 40 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 44 8D 48 01 48 83 64 24 50 00 48 8B 8C 24 A0 00 00 00 F3 0F 11 74 24 50 4C 8B 44 24 50 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "_logf_special"
		size = 32
		refs = "0007 ??_C@_04HIGFGEHP@logf?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "_log_special"
		size = 32
		refs = "0007 ??_C@_03MGHMBJCF@log?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "_log10f_special"
		size = 32
		refs = "0007 ??_C@_06KDGOKGLH@log10f?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_5_0 {
	meta:
		name = "_log10_special"
		size = 32
		refs = "0007 ??_C@_05HGHHAHAP@log10?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_3_0 {
	meta:
		name = "_log_special_common"
		size = 207
		refs = "00bd _handle_error"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 41 FF C8 0F 29 70 E8 41 8B D1 66 0F 28 F1 66 0F 28 D0 74 60 41 FF C8 74 31 41 FF C8 0F 85 98 00 00 00 66 0F 57 C0 C7 40 D8 01 00 00 00 F2 0F 11 40 D0 F2 0F 11 50 C8 C7 40 C0 21 00 00 00 44 21 40 B8 41 B9 01 00 00 00 EB 58 66 0F 57 C0 C7 44 24 40 01 00 00 00 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 EB CE 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 02 00 00 00 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 48 8B 8C 24 90 00 00 00 F2 0F 11 4C 24 78 4C 8B 44 24 78 E8 ?? ?? ?? ?? 66 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__initconout"
		size = 59
		refs = "0018 ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 002b __imp_CreateFileW 0032 _confh"
	strings:
		$1 = { 48 83 EC 48 48 83 64 24 30 00 83 64 24 28 00 41 B8 03 00 00 00 48 8D 0D ?? ?? ?? ?? 45 33 C9 BA 00 00 00 40 44 89 44 24 20 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "__termconout"
		size = 34
		refs = "0007 _confh 0019 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? 48 83 F9 FF 74 0C 48 83 F9 FE 74 06 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_460_1_0 {
	meta:
		name = "__termconin"
		size = 34
		refs = "0007 _coninpfh 0019 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? 48 83 F9 FF 74 0C 48 83 F9 FE 74 06 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "_fstat32"
		size = 935
		refs = "001d __security_cookie 0045 __doserrno 004c _errno 0065 memset 008f _nhandle 00a6 __pioinfo 00ce __lock_fhandle 00f4 __imp_GetFileType 0115 __imp_GetLastError 011c _dosmaperr 0180 __imp_PeekNamedPipe 01ae __imp_GetFileInformationByHandle 01f2 __imp_FileTimeToLocalFileTime 020a __imp_FileTimeToSystemTime 0246 __loctotime32_t 0358 _unlock_fhandle 0373 _invalid_parameter_noinfo 0386 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 81 EC A0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 98 00 00 00 48 8B FA 48 63 F1 89 74 24 4C 33 DB 8B C3 48 85 D2 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 17 03 00 00 33 D2 44 8D 42 24 48 8B CF E8 ?? ?? ?? ?? 83 FE FE 75 17 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 F2 02 00 00 85 F6 0F 88 D3 02 00 00 3B 35 ?? ?? ?? ?? 0F 83 C7 02 00 00 4C 8B E6 4C 8B EE 49 C1 FD 05 4C 8D 3D ?? ?? ?? ?? 41 83 E4 1F 4D 6B E4 58 4B 8B 04 EF 42 0F BE 4C 20 08 41 BE 01 00 00 00 41 23 CE 0F 84 95 02 00 00 8B CE E8 ?? ?? ?? ?? 90 4B 8B 0C EF 46 84 74 21 08 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 64 02 00 00 4A 8B 0C 21 FF 15 ?? ?? ?? ?? 0F BA F0 0F 41 3B C6 0F 84 8F 00 00 00 83 F8 02 74 20 83 F8 03 74 16 85 C0 74 CB FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 2D 02 00 00 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4F 06 89 37 89 77 10 66 44 89 77 08 66 89 5F 04 89 5F 0A 48 89 5F 1C 89 5F 18 83 F8 02 75 08 89 5F 14 E9 F6 01 00 00 4B 8B 0C EF 48 89 5C 24 28 48 8D 44 24 48 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 4A 8B 0C 21 FF 15 ?? ?? ?? ?? F7 D8 1B C9 23 4C 24 48 89 4F 14 E9 C1 01 00 00 89 5F 0A 89 5F 04 66 44 89 77 08 4B 8B 0C EF 48 8D 54 24 60 4A 8B 0C 21 FF 15 ?? ?? ?? ?? 85 C0 0F 84 59 FF FF FF 0F B7 47 06 44 84 74 24 60 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 47 06 39 5C 24 74 75 0B 39 5C 24 78 75 05 89 5F 1C EB 67 48 8D 54 24 40 48 8D 4C 24 74 FF 15 ?? ?? ?? ?? 85 C0 0F 84 54 01 00 00 48 8D 54 24 50 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3C 01 00 00 0F B7 44 24 5C 44 0F B7 54 24 5A 44 0F B7 4C 24 58 44 0F B7 44 24 56 0F B7 54 24 52 0F B7 4C 24 50 83 4C 24 30 FF 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 89 47 1C 39 5C 24 6C 75 0B 39 5C 24 70 75 05 8B 47 1C EB 64 48 8D 54 24 40 48 8D 4C 24 6C FF 15 ?? ?? ?? ?? 85 C0 0F 84 DC 00 00 00 48 8D 54 24 50 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C4 00 00 00 0F B7 44 24 5C 44 0F B7 54 24 5A 44 0F B7 4C 24 58 44 0F B7 44 24 56 0F B7 54 24 52 0F B7 4C 24 50 83 4C 24 30 FF 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 89 47 18 39 5C 24 64 75 0B 39 5C 24 68 75 05 8B 47 1C EB 5C 48 8D 54 24 40 48 8D 4C 24 64 FF 15 ?? ?? ?? ?? 85 C0 74 68 48 8D 54 24 50 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 74 54 0F B7 44 24 5C 44 0F B7 54 24 5A 44 0F B7 4C 24 58 44 0F B7 44 24 56 0F B7 54 24 52 0F B7 4C 24 50 83 4C 24 30 FF 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 89 47 20 8B 84 24 84 00 00 00 89 47 14 0F B7 47 06 0F BA E8 0F 66 89 47 06 89 1F 89 5F 10 EB 03 83 CB FF 8B CE E8 ?? ?? ?? ?? 8B C3 EB 1A E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 8C 24 98 00 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 A0 00 00 00 49 8B 5B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "_fstat32$fin$0"
		size = 25
		refs = "000d _unlock_fhandle"
		altNames = "_fstat32i64$fin$0 _fstat64$fin$0 _fstat64i32$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA 8B 4D 4C E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "modff"
		size = 144
	strings:
		$1 = { 0F 28 C8 F3 0F 11 4C 24 08 44 8B 44 24 08 41 8B C0 C1 E8 17 0F B6 C8 83 E9 7F 79 1A 41 81 E0 00 00 00 80 44 89 44 24 08 F3 0F 10 44 24 08 F3 0F 11 02 0F 28 C1 C3 41 B9 17 00 00 00 41 3B C9 7D 24 44 2B C9 B8 01 00 00 00 41 8A C9 D3 E0 FF C8 F7 D0 41 23 C0 89 44 24 08 F3 0F 10 44 24 08 F3 0F 5C C8 EB C9 41 8B C0 F3 0F 11 0A 0F BA F0 1F 3D 00 00 80 7F 76 06 F3 0F 58 C9 EB B5 41 81 E0 00 00 00 80 44 89 44 24 08 F3 0F 10 44 24 08 C3 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "atanf"
		size = 593
		refs = "001a __mask@@NegDouble@ 0073 __real@3fddac670561bb4f 0083 __real@4000000000000000 008b __real@3ff0000000000000 00b7 __real@3fe921fb54442d18 00f3 __real@3fef730bd281f69b 00ff __real@3ff8000000000000 014f ??_C@_05HDLDHOMB@atanf?$AA@ 0176 _handle_errorf 0183 __real@43d3200000000000 0192 ?piby2@?1??atanf@@9@9 01b6 _controlfp_s 01c6 __real@bff0000000000000 01ce __real@3ff921fb54442d18 01f2 __real@3f73476a758da22a 01fa __real@3fd327e3df2cf2aa 0206 __real@3fc89e173a81ee7f 020e __real@3ff1c58793da6ea4 021e __real@3fd2fa5316907834 0226 __real@3fec777ca21053f0"
	strings:
		$1 = { 48 83 EC 68 48 BA FF FF FF FF FF FF FF 7F 0F 28 C8 0F 29 74 24 50 F2 0F 10 35 ?? ?? ?? ?? 0F 14 C9 0F 5A E1 F2 0F 11 64 24 78 48 8B 4C 24 78 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 00 80 48 23 CA 74 04 66 0F 57 E6 48 BA 00 00 00 00 00 00 DC 3F 48 3B C2 73 09 66 0F 57 ED E9 7A 01 00 00 48 BA 00 00 00 00 00 00 E6 3F 48 3B C2 73 35 F2 0F 10 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 28 C4 F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? 66 0F 28 E2 F2 0F 5E E0 E9 36 01 00 00 48 BA 00 00 00 00 00 00 F3 3F 48 3B C2 73 2D F2 0F 10 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 28 CC F2 0F 5C 15 ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? 66 0F 28 E2 F2 0F 5E E1 E9 FA 00 00 00 48 BA 00 00 00 00 00 80 03 40 48 3B C2 73 35 F2 0F 10 2D ?? ?? ?? ?? 66 0F 28 D4 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? 66 0F 28 CC F2 0F 58 0D ?? ?? ?? ?? 66 0F 28 E2 F2 0F 5E E1 E9 B6 00 00 00 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 76 4C 0F 57 C0 41 B9 01 00 00 00 F3 0F 11 4C 24 70 44 8B 44 24 70 44 89 4C 24 40 48 8D 0D ?? ?? ?? ?? F3 0F 11 44 24 38 F3 0F 11 4C 24 30 41 8D 51 0E 49 0F BA E8 16 C7 44 24 28 21 00 00 00 83 64 24 20 00 E8 ?? ?? ?? ?? E9 C8 00 00 00 66 0F 2F 25 ?? ?? ?? ?? 76 39 48 85 C9 74 12 F2 0F 10 05 ?? ?? ?? ?? 66 0F 57 C6 F2 0F 5A F0 EB 0B F2 0F 5A 05 ?? ?? ?? ?? 0F 28 F0 BA 10 00 00 00 33 C9 44 8B C2 E8 ?? ?? ?? ?? 0F 28 C6 E9 85 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 5E C4 66 0F 28 E0 66 0F 28 D4 F2 0F 59 D4 66 0F 28 DA 66 0F 28 CA 66 0F 28 C2 F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 C4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5E D9 F2 0F 5C DC F2 0F 5C EB 48 85 C9 74 04 66 0F 57 EE F2 0F 5A C5 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "_freea"
		size = 31
		refs = "0016 free"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "cos"
		size = 1165
		refs = "0075 L__real_3ff0000000000000 0094 L__real_3fe0000000000000 00bc Lcosarray 0104 L__real_bfe0000000000000 0160 L__real_411E848000000000 0172 L__real_3fe45f306dc9c883 0195 L__real_3ff921fb54400000 01a1 L__real_3dd0b4611a626331 01c5 L__real_3dd0b4611a600000 01d2 L__real_3ba3198a2e037073 0241 L__real_3fc5555555555555 02bd __remainder_piby2 0309 Lsinarray 0481 _cos_special"
	strings:
		$1 = { 48 81 EC F8 00 00 00 66 0F 57 D2 F2 0F 11 04 24 48 8B 14 24 48 B8 00 00 00 00 00 00 F0 7F 4C 8B D0 4C 23 D2 4C 3B D0 0F 84 53 04 00 00 49 BA FF FF FF FF FF FF FF 7F 4C 23 D2 41 B8 01 00 00 00 48 B8 18 2D 44 54 FB 21 E9 3F 4C 3B D0 0F 8F FD 00 00 00 48 B8 00 00 00 00 00 00 20 3F 4C 3B D0 7D 4E 48 B8 00 00 00 00 00 00 40 3E 4C 3B D0 7D 0F F2 0F 10 05 ?? ?? ?? ?? E9 F2 03 00 00 66 90 F2 0F 10 D0 F2 0F 59 D2 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 CF 03 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 E2 F2 0F 59 E2 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 C4 F2 0F 59 EA F2 0F 59 C4 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 E0 F2 0F 59 E5 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 CB F2 0F 10 DA F2 0F 58 D0 F2 0F 5C C2 F2 0F 58 C3 F2 0F 58 CC F2 0F 58 C1 F2 0F 58 C2 E9 27 03 00 00 0F 1F 80 00 00 00 00 49 3B D2 74 08 F2 0F 5C D0 F2 0F 10 C2 4C 3B 15 ?? ?? ?? ?? 0F 83 36 01 00 00 F2 0F 10 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 D3 4D 8B CA 49 C1 E9 34 F2 0F 58 D5 F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 F2 0F 10 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? F2 0F 11 04 24 F2 0F 10 2D ?? ?? ?? ?? 48 8B 0C 24 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 F2 0F 10 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 F2 0F 10 C4 F2 0F 10 CD F2 0F 5C C5 F2 0F 5C E0 F2 0F 5C E1 48 81 F9 F2 03 00 00 0F 8D C9 00 00 00 48 81 F9 DE 03 00 00 7E 50 F2 0F 10 D0 F2 0F 59 D2 44 23 C0 74 23 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 DA F2 0F 5C C3 E9 FA 01 00 00 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 D7 01 00 00 0F 1F 80 00 00 00 00 44 23 C0 0F 85 C7 01 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 BA 01 00 00 66 66 0F 1F 84 00 00 00 00 00 4C 8D 8C 24 C0 00 00 00 4C 8D 84 24 B0 00 00 00 48 8D 94 24 A0 00 00 00 48 83 EC 20 E8 ?? ?? ?? ?? 48 83 C4 20 41 B8 01 00 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 10 A4 24 B0 00 00 00 8B 84 24 C0 00 00 00 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 D8 F2 0F 10 D0 F2 0F 59 D0 44 23 C0 0F 84 9B 00 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 2D ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 CA F2 0F 59 CA F2 0F 11 44 24 10 F2 0F 59 EA F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 DA F2 0F 59 E2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 04 24 F2 0F 59 D9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 DD F2 0F 59 E3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 58 44 24 10 E9 BC 00 00 00 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 59 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 EA F2 0F 10 DA F2 0F 11 24 24 F2 0F 59 CA F2 0F 59 C2 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E2 F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 5C EC F2 0F 59 CB F2 0F 58 C1 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 5C 2C 24 F2 0F 59 C2 F2 0F 58 C5 F2 0F 5C C4 66 66 0F 1F 84 00 00 00 00 00 83 C0 01 83 E0 02 74 18 F2 0F 10 D0 66 0F 57 C0 F2 0F 5C C2 66 66 66 66 0F 1F 84 00 00 00 00 00 48 81 C4 F8 00 00 00 C3 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_60_3_0 {
	meta:
		name = "__check_float_string"
		size = 150
		refs = "002b _calloc_crt 0050 memcpy 006c _recalloc_crt"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F1 49 8B F8 48 8B DA 48 3B 0A 75 64 4D 39 08 75 3D 48 8B 0B BA 02 00 00 00 E8 ?? ?? ?? ?? 48 89 07 48 85 C0 75 04 33 C0 EB 4B 48 8B 44 24 50 48 8B D6 C7 00 01 00 00 00 4C 8B 03 48 8B 0F E8 ?? ?? ?? ?? 4C 8B 1B 4D 03 DB 4C 89 1B EB 22 48 8B 12 48 8B 0F 41 B8 02 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 C2 48 89 07 48 8B 0B 48 03 C9 48 89 0B B8 01 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_60_5_0 {
	meta:
		name = "_hextodec"
		size = 38
		refs = "000d isdigit"
	strings:
		$1 = { 40 53 48 83 EC 20 0F BE D9 0F B6 C9 E8 ?? ?? ?? ?? 8B CB 83 E1 DF 83 E9 07 85 C0 0F 45 CB 8B C1 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_60_7_0 {
	meta:
		name = "_un_inc"
		size = 19
		refs = "000a _ungetch_nolock"
	strings:
		$1 = { 48 83 EC 28 83 F9 FF 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_7_0 {
	meta:
		name = "_un_inc"
		size = 19
		refs = "000a _ungetc_nolock"
	strings:
		$1 = { 48 83 EC 28 83 F9 FF 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_8_0 {
	meta:
		name = "_whiteout"
		size = 52
		refs = "0010 _getche_nolock 001f isspace"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 FF 07 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 0C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 E6 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_60_9_0 {
	meta:
		name = "_cprinput_s_l"
		size = 4104
		refs = "0022 __security_cookie 006b _errno 0076 _invalid_parameter_noinfo 0087 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00b6 isspace 00ca _getche_nolock 00e4 _ungetch_nolock 015b isdigit 04de __check_float_string 0735 _cfltcvt_tab 073e __imp_DecodePointer 0815 memset 0b21 isleadbyte 0b5e _mbtowc_l 0cab isxdigit 0f0b free 0fe9 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 80 FE FF FF 48 81 EC 80 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 70 01 00 00 45 33 FF 4C 8D 6D 10 4C 89 45 B0 48 8B F1 48 89 4C 24 60 48 C7 45 A0 5E 01 00 00 4C 89 6C 24 70 44 89 7C 24 78 66 44 89 7C 24 7C 44 89 7C 24 3C 44 89 7C 24 48 48 85 C9 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 5C 0F 00 00 48 8D 4D C8 E8 ?? ?? ?? ?? 8A 06 41 8B DF 44 88 7C 24 41 45 8B F7 44 89 7C 24 34 89 5C 24 68 84 C0 0F 84 22 0F 00 00 41 83 CC FF 45 8D 6C 24 02 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 3E 45 2B F5 45 03 F5 44 89 74 24 34 E8 ?? ?? ?? ?? 8B D8 41 3B C4 74 13 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 E0 8B CB E8 ?? ?? ?? ?? 49 03 F5 0F B6 0E E8 ?? ?? ?? ?? 85 C0 75 F1 E9 82 0D 00 00 80 3E 25 0F 85 90 0D 00 00 80 7E 01 25 0F 84 76 0D 00 00 33 C0 44 89 7C 24 5C 44 88 7D 80 8D 48 01 44 89 7C 24 54 41 8B FF 45 8B EF 4C 89 7D C0 44 88 7C 24 50 44 88 7C 24 40 44 88 7C 24 30 41 8A F7 44 89 7D A8 4C 8B 7C 24 60 88 4C 24 38 44 8A E0 44 8B F0 4C 03 F9 41 0F B6 1F 8B CB E8 ?? ?? ?? ?? 45 33 C9 85 C0 74 15 43 8D 44 AD 00 41 8D 49 01 44 8D 6C 43 D0 03 F9 E9 9B 00 00 00 83 FB 2A 0F 84 06 01 00 00 83 FB 46 0F 84 84 00 00 00 83 FB 49 74 56 83 FB 4C 74 46 83 FB 4E 74 75 B9 01 00 00 00 83 FB 68 74 2B 83 FB 6C 74 0A 83 FB 77 74 1C E9 D0 00 00 00 41 80 7F 01 6C 75 0C 49 FF C7 44 03 F1 4C 89 4D 88 EB 4E 00 4C 24 38 44 02 E1 EB 45 83 CA FF 00 54 24 38 44 02 E2 EB 3C B9 01 00 00 00 00 4C 24 38 EB 2E 41 8A 47 01 3C 36 75 12 41 80 7F 02 34 75 0B 49 83 C7 02 B9 01 00 00 00 EB BD 3C 33 75 5F 41 80 7F 02 32 75 58 49 83 C7 02 B9 01 00 00 00 83 CA FF 44 8A 44 24 30 40 84 F6 0F 84 2A FF FF FF 89 7C 24 58 8B 7C 24 3C 44 89 74 24 4C 44 8A 75 80 4C 89 7C 24 60 44 8B 7D A8 44 89 6C 24 44 45 84 C0 75 59 48 8B 45 B0 48 89 45 B8 48 83 C0 08 48 89 45 B0 48 8B 40 F8 48 89 45 90 EB 43 3C 64 74 92 3C 69 74 8E 3C 6F 74 8A 3C 78 74 86 3C 58 74 82 B9 01 00 00 00 4C 89 4D 88 44 03 F1 40 02 F1 EB 8C 44 8A 44 24 30 B9 01 00 00 00 44 02 C1 83 CA FF 44 88 44 24 30 E9 7A FF FF FF 4C 89 4D 90 4C 8B 54 24 60 41 8A D9 45 84 E4 75 12 41 80 3A 53 74 09 41 80 3A 43 44 8A E2 75 03 44 8A E1 45 0F B6 2A 41 83 CD 20 41 83 FD 6E 74 6A 41 83 FD 63 74 37 41 83 FD 7B 74 31 8B 74 24 34 03 F1 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 F8 FF 74 11 0F B6 C8 E8 ?? ?? ?? ?? B9 01 00 00 00 85 C0 75 DD 44 8B 7D A8 89 74 24 34 EB 15 8B 44 24 34 03 C1 89 44 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 CA FF 3B FA 0F 84 C4 0B 00 00 4C 8B 54 24 60 44 8A 44 24 30 45 33 C9 8B 4C 24 58 8B 44 24 44 85 C9 74 08 85 C0 0F 84 98 0B 00 00 45 84 C0 0F 85 C8 00 00 00 41 83 FD 63 74 10 41 83 FD 73 74 0A 41 83 FD 7B 0F 85 B2 00 00 00 4C 8B 4D B8 49 8B 09 49 83 C1 08 41 8B 31 4D 8B D9 4C 89 4D B8 49 83 C1 08 48 89 4D 90 4C 89 4D B0 41 B9 01 00 00 00 49 3B F1 0F 82 A1 0B 00 00 8B 4C 24 58 45 33 C9 41 83 FD 6F 0F 8F CA 03 00 00 0F 84 96 08 00 00 41 83 FD 63 0F 84 93 03 00 00 41 83 FD 64 0F 84 82 08 00 00 0F 8E D8 03 00 00 41 83 FD 67 7E 75 41 83 FD 69 74 52 41 83 FD 6E 0F 85 C2 03 00 00 44 8B 74 24 34 45 33 FF 41 8B C6 45 8D 6F 01 45 84 C0 75 1E 44 8B 74 24 4C 48 8B 4D 90 45 85 F6 0F 84 40 0A 00 00 48 8B 45 88 48 89 01 44 8B 74 24 34 41 83 CC FF E9 4D 0A 00 00 48 8B 75 C0 4C 8B 5D B8 E9 78 FF FF FF 41 BD 64 00 00 00 41 BE 01 00 00 00 83 FF 2D 0F 85 B7 04 00 00 45 8A FE E9 B9 04 00 00 45 33 FF 41 8B DF 45 8D 6F 01 83 FF 2D 75 0D 48 8B 44 24 70 41 8B DD 40 88 38 EB 05 83 FF 2B 75 20 44 8B 64 24 44 44 8B 74 24 34 45 2B E5 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 CA FF EB 0A 44 8B 64 24 44 44 8B 74 24 34 44 39 7C 24 58 40 0F B6 CF 44 0F 44 E2 EB 53 41 8B C4 45 2B E5 85 C0 74 52 48 8B 44 24 70 44 01 6C 24 54 4C 8D 4D 10 40 88 3C 03 48 8D 44 24 78 49 03 DD 4C 8D 44 24 70 48 8D 55 A0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 75 0A 00 00 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A4 48 8B 45 C8 48 8B 88 28 01 00 00 48 8B 01 40 8A 30 40 3A F7 0F 85 B1 00 00 00 41 8B C4 45 2B E5 85 C0 0F 84 A3 00 00 00 45 03 F5 E8 ?? ?? ?? ?? 4C 8D 4D 10 8B F8 89 44 24 3C 48 8B 44 24 70 40 88 34 03 48 8D 44 24 78 49 03 DD 4C 8D 44 24 70 48 8D 55 A0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 F2 09 00 00 40 0F B6 CF EB 53 41 8B C4 45 2B E5 85 C0 74 52 48 8B 44 24 70 44 01 6C 24 54 4C 8D 4D 10 40 88 3C 03 48 8D 44 24 78 49 03 DD 4C 8D 44 24 70 48 8D 55 A0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 AA 09 00 00 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A4 8B 74 24 54 85 F6 0F 84 19 01 00 00 83 FF 65 74 09 83 FF 45 0F 85 0B 01 00 00 41 8B C4 45 2B E5 85 C0 0F 84 FD 00 00 00 48 8B 44 24 70 4C 8D 4D 10 4C 8D 44 24 70 C6 04 03 65 48 8D 44 24 78 49 03 DD 48 8D 55 A0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 35 09 00 00 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 F8 2D 75 35 48 8B 44 24 70 4C 8D 4D 10 4C 8D 44 24 70 40 88 3C 03 48 8D 44 24 78 49 03 DD 48 8D 55 A0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 EF 08 00 00 EB 05 83 F8 2B 75 1D 41 8B C4 45 2B E5 85 C0 75 05 45 8B E7 EB 0E 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 40 0F B6 CF EB 51 41 8B C4 45 2B E5 85 C0 74 50 48 8B 44 24 70 4C 8D 4D 10 4C 8D 44 24 70 40 88 3C 03 48 8D 44 24 78 49 03 DD 48 8D 55 A0 48 8B CB 41 03 F5 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 85 08 00 00 45 03 F5 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A6 45 2B F5 41 83 CC FF 44 89 74 24 34 41 3B FC 74 07 8B CF E8 ?? ?? ?? ?? 85 F6 0F 84 4B 08 00 00 44 38 7C 24 30 0F 85 52 07 00 00 48 8B 74 24 70 44 01 6C 24 68 44 88 3C 33 0F BE 5C 24 38 48 8B 0D ?? ?? ?? ?? 41 2B DD FF 15 ?? ?? ?? ?? 48 8B 55 90 4C 8D 4D C8 4C 8B C6 8B CB FF D0 E9 1B 07 00 00 41 BB 01 00 00 00 85 C9 75 0C 41 03 C3 44 89 5C 24 58 89 44 24 44 45 84 E4 0F 8E E0 02 00 00 45 8A FB E9 D8 02 00 00 41 83 FD 70 0F 84 B1 04 00 00 41 83 FD 73 0F 84 B3 02 00 00 41 83 FD 75 0F 84 B4 04 00 00 41 83 FD 78 0F 84 92 FC FF FF 41 83 FD 7B 74 35 41 0F B6 02 3B C7 0F 85 AD 07 00 00 00 54 24 41 44 8B 74 24 34 45 33 FF 41 83 CC FF 45 8D 6F 01 45 84 C0 0F 85 9D 06 00 00 4D 8B C3 4C 89 5D B0 E9 91 06 00 00 45 84 E4 B8 01 00 00 00 45 0F B6 FF 44 0F 4F F8 4C 03 D0 41 80 3A 5E 4C 89 54 24 60 75 0C 49 FF C2 88 54 24 50 4C 89 54 24 60 33 D2 48 8D 4D E8 44 8D 42 20 E8 ?? ?? ?? ?? 4C 8B 54 24 60 B3 5D 41 BB 01 00 00 00 41 38 1A 75 0A 44 8A F3 4D 03 D3 C6 45 F3 20 45 33 C9 41 8A 02 3A C3 0F 84 A4 00 00 00 4D 03 D3 3C 2D 75 7B 45 84 F6 74 76 41 8A 0A 3A CB 74 6F 4D 03 D3 4C 89 54 24 60 44 3A F1 73 05 44 8A C9 EB 06 45 8A CE 44 8A F1 45 3A F1 73 2C 45 0F B6 D6 41 0F B6 CE 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 45 02 F3 D2 E2 4D 03 D3 42 08 54 05 E8 45 3A F1 72 DD 4C 8B 54 24 60 41 0F B6 C1 45 0F B6 C1 41 8B D3 83 E0 07 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 E8 45 33 C9 45 8A F1 E9 73 FF FF FF 44 0F B6 C0 44 8A F0 0F B6 C0 83 E0 07 41 8B D3 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 E8 E9 51 FF FF FF 45 38 0A 0F 84 06 06 00 00 4C 89 54 24 60 83 CA FF E9 58 01 00 00 44 8A 7C 24 40 83 FF 2B 75 10 41 2B C6 89 44 24 44 75 61 85 C9 74 5D 41 8A DE 8B 74 24 34 83 FF 30 0F 85 81 00 00 00 41 03 F6 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 3C 78 0F 84 CB 00 00 00 3C 58 0F 84 C3 00 00 00 44 89 74 24 54 41 83 FD 78 74 38 44 8B 64 24 44 33 C0 39 44 24 58 74 08 45 2B E6 75 03 41 02 DE 41 BD 6F 00 00 00 E9 C9 00 00 00 8B 74 24 34 41 03 F6 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C EB 92 41 2B F6 89 74 24 34 83 F8 FF 74 07 8B C8 E8 ?? ?? ?? ?? BF 30 00 00 00 89 7C 24 3C 44 8B 74 24 4C 44 8B 64 24 44 45 85 F6 0F 84 88 03 00 00 48 8B 75 88 84 DB 0F 85 67 03 00 00 8B 5C 24 34 41 83 FD 78 0F 84 D2 02 00 00 41 83 FD 70 0F 84 C8 02 00 00 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 0F 84 28 03 00 00 41 83 FD 6F 0F 85 A4 02 00 00 83 FF 38 0F 8D 15 03 00 00 48 C1 E6 03 E9 CF 02 00 00 41 03 F6 89 74 24 34 E8 ?? ?? ?? ?? 44 8B 64 24 44 8B F8 89 44 24 3C 33 C0 39 44 24 58 74 0C 41 83 EC 02 45 3B E6 7D 03 41 02 DE 41 BD 78 00 00 00 44 8B 74 24 4C E9 6B FF FF FF 45 0F B6 FF 45 84 E4 41 BB 01 00 00 00 45 0F 4F FB 8B 4C 24 34 48 8B 5D 90 41 2B CB 89 4C 24 34 3B FA 74 11 8B CF E8 ?? ?? ?? ?? 8B 4C 24 34 41 BB 01 00 00 00 41 83 FD 63 74 03 49 2B F3 44 8B 64 24 44 44 8A 74 24 50 33 D2 39 54 24 58 74 0E 41 8B C4 45 2B E3 85 C0 0F 84 80 01 00 00 41 03 CB 89 4C 24 34 E8 ?? ?? ?? ?? 48 63 F8 89 7C 24 3C 41 83 FD 63 74 43 41 83 FD 73 75 13 83 FF 09 7C 09 83 FF 0D 0F 8E E6 00 00 00 83 FF 20 75 2A 41 83 FD 7B 0F 85 D7 00 00 00 48 8B C7 8B D7 48 C1 F8 03 83 E2 07 0F BE 4C 05 E8 41 0F BE C6 33 C8 0F A3 D1 0F 83 B7 00 00 00 33 D2 38 54 24 30 0F 85 99 00 00 00 48 85 F6 0F 84 67 04 00 00 45 84 FF 74 72 40 0F B6 CF 40 88 7D 98 E8 ?? ?? ?? ?? 85 C0 74 12 8B 44 24 34 FF C0 89 44 24 34 E8 ?? ?? ?? ?? 88 45 99 B8 3F 00 00 00 4C 8D 4D C8 48 8D 55 98 66 89 44 24 7C 48 8B 45 C8 48 8D 4C 24 7C 4C 63 80 0C 01 00 00 E8 ?? ?? ?? ?? 48 8B 45 90 44 0F B7 5C 24 7C 8B 4C 24 34 66 44 89 18 48 83 C0 02 41 BB 01 00 00 00 48 89 45 90 49 2B F3 E9 02 FF FF FF 48 8B 45 90 41 BB 01 00 00 00 40 88 38 49 03 C3 49 2B F3 48 89 45 90 EB 09 41 BB 01 00 00 00 49 03 DB 8B 4C 24 34 E9 D9 FE FF FF 44 8B 74 24 34 41 BB 01 00 00 00 41 83 CC FF 45 2B F3 44 89 74 24 34 41 3B FC 74 0C 8B CF E8 ?? ?? ?? ?? 45 8D 5C 24 02 33 D2 48 8B 45 90 48 3B D8 0F 84 0A 03 00 00 38 54 24 30 0F 85 72 02 00 00 8B 5C 24 68 41 03 DB 89 5C 24 68 41 83 FD 63 0F 84 5D 02 00 00 41 BD 01 00 00 00 45 84 FF 74 17 45 33 FF 66 44 89 38 E9 4F 02 00 00 44 8B 74 24 34 41 83 CC FF EB B2 45 33 FF 44 88 38 E9 39 02 00 00 44 8B 74 24 4C BA 01 00 00 00 4C 89 4D 88 44 03 F2 88 54 24 38 EB 0A 44 8B 74 24 4C BA 01 00 00 00 83 FF 2D 75 05 44 8A FA EB 0E 44 8A 7C 24 40 83 FF 2B 0F 85 39 FD FF FF 2B C2 89 44 24 44 75 0E 85 C9 74 0A 8A DA 44 8B E0 E9 28 FD FF FF 01 54 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 0F FD FF FF 48 8D 34 B6 48 03 F6 EB 34 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 85 C0 74 62 48 C1 65 88 04 8B CE 40 0F BE DF E8 ?? ?? ?? ?? 48 8B 75 88 8B FB 83 E7 DF 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C 8D 47 D0 BA 01 00 00 00 01 54 24 54 48 63 C8 33 C0 48 03 F1 48 89 75 88 39 44 24 58 74 05 44 2B E2 74 30 8B 5C 24 34 03 DA 89 5C 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 B3 FC FF FF FF CB 89 5C 24 34 83 FF FF 74 07 8B CF E8 ?? ?? ?? ?? 48 8B 75 88 45 84 FF 0F 84 E4 00 00 00 48 F7 DE 48 89 75 88 E9 D8 00 00 00 8B 74 24 5C 84 DB 0F 85 C1 00 00 00 8B 5C 24 34 41 83 FD 78 74 2F 41 83 FD 70 74 29 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 0F 84 8A 00 00 00 41 83 FD 6F 75 0A 83 FF 38 7D 7F C1 E6 03 EB 42 8D 04 B6 8D 34 00 EB 3A 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 85 C0 74 63 8B 44 24 5C 8B CE 40 0F BE DF C1 E0 04 89 44 24 5C E8 ?? ?? ?? ?? 8B 74 24 5C 8B FB 83 E7 DF 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C B9 01 00 00 00 8D 74 3E D0 33 C0 01 4C 24 54 89 74 24 5C 39 44 24 58 74 05 44 2B E1 74 30 8B 5C 24 34 03 D9 89 5C 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 59 FF FF FF FF CB 89 5C 24 34 83 FF FF 74 07 8B CF E8 ?? ?? ?? ?? 8B 74 24 5C 45 84 FF 74 06 F7 DE 89 74 24 5C 8B 44 24 54 41 83 FD 46 41 BF 00 00 00 00 41 0F 44 C7 85 C0 0F 84 2D 01 00 00 45 8D 6F 01 44 38 7C 24 30 0F 85 D5 F5 FF FF 44 01 6C 24 68 8B 44 24 5C E9 B3 F5 FF FF 44 8B 74 24 34 41 83 CC FF 44 38 7C 24 38 74 04 89 01 EB 0E 66 89 01 EB 09 41 BD 01 00 00 00 45 33 FF 48 8B 74 24 60 44 00 6C 24 41 49 03 F5 48 89 74 24 60 EB 5B 80 3E 25 75 0B 48 8D 46 01 80 38 25 48 0F 44 F0 45 03 F5 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 06 49 03 F5 48 89 74 24 60 3B C7 0F 85 F7 00 00 00 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 74 18 E8 ?? ?? ?? ?? 0F B6 0E 49 03 F5 48 89 74 24 60 3B C8 0F 85 C6 00 00 00 8A 06 84 C0 74 13 E9 C7 F1 FF FF 3B FA 74 07 8B CF E8 ?? ?? ?? ?? 45 33 FF 44 8B 6C 24 48 83 7C 24 78 01 75 0A 48 8B 4C 24 70 E8 ?? ?? ?? ?? 41 83 FD 01 0F 85 AE 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 7D E0 74 0B 48 8B 4D D8 83 A1 C8 00 00 00 FD 8B 44 24 68 E9 9B 00 00 00 45 33 FF 45 84 E4 7E 06 66 44 89 39 EB 03 44 88 39 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 45 8B EF EB 9A 3B FA 74 07 8B CF E8 ?? ?? ?? ?? 41 BD 01 00 00 00 45 33 FF EB 84 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 44 8B E8 45 84 FF 74 0C 45 33 FF 66 44 89 3B E9 63 FF FF FF 45 33 FF 44 88 3B E9 58 FF FF FF 41 3B C4 74 07 8B C8 E8 ?? ?? ?? ?? 41 3B FC 0F 84 3E FF FF FF 8B CF E8 ?? ?? ?? ?? E9 32 FF FF FF 8B 5C 24 68 44 38 7D E0 74 0B 48 8B 45 D8 83 A0 C8 00 00 00 FD 8B C3 48 8B 8D 70 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C8 02 00 00 48 81 C4 80 02 00 00 41 5F 41 5E }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@XZ"
		size = 56
		refs = "0009 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0021 ??0exception@std@@QEAA@AEBQEBDH@Z 0028 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 30 41 B8 01 00 00 00 48 89 44 24 30 48 8B D9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8B C3 4C 89 1B 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7bad_alloc@std@@6B@ 001a ??1exception@std@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_70_57_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_87_51_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_10_59_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_833_46_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7FreeThreadProxy@details@Concurrency@@6B@ 001a ??1ThreadProxy@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_792_40_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ThreadScheduler@details@Concurrency@@6B@ 001a ??1SchedulerBase@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_336_6_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 001a ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_384_33_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7UMSThreadScheduler@details@Concurrency@@6B@ 001a ??1SchedulerBase@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_20_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_866_2_0 {
	meta:
		name = "??_Gbad_exception@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7bad_exception@std@@6B@ 001a ??1exception@std@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_18_0 {
	meta:
		name = "??_Gbad_typeid@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_14_0 {
	meta:
		name = "??_Gexception@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_25_46_1 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_652_2_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7type_info@@6B@ 001a ?_Type_info_dtor@type_info@@CAXPEAV1@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "??1_MallocaHolder@details@Concurrency@@QEAA@XZ"
		size = 34
		refs = "0019 free"
	strings:
		$1 = { 48 83 EC 28 48 8B 09 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "??0_TaskCollectionBase@details@Concurrency@@QEAA@XZ"
		size = 27
	strings:
		$1 = { 81 49 08 FF FF FF 0F 83 61 18 00 48 83 61 20 00 C7 41 1C 00 00 00 80 48 8B C1 C3 }
	condition:
		$1
}

rule file_61_17_0 {
	meta:
		name = "?GetWorkQueue@ContextBase@details@Concurrency@@QEAAPEAVWorkQueue@23@XZ"
		size = 31
		refs = "0011 ?CreateWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 79 40 00 48 8B D9 75 05 E8 ?? ?? ?? ?? 48 8B 43 40 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_457_150_0 {
	meta:
		name = "?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QEAAPEAVWorkQueue@23@XZ"
		size = 31
		refs = "0011 ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 79 40 00 48 8B D9 75 05 E8 ?? ?? ?? ?? 48 8B 43 40 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_18_0 {
	meta:
		name = "?GetWorkQueueIdentity@ContextBase@details@Concurrency@@QEAAIXZ"
		size = 37
		refs = "0011 ?CreateWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 79 40 00 48 8B D9 75 05 E8 ?? ?? ?? ?? 48 8B 43 40 8B 80 90 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_25_0 {
	meta:
		name = "?HasAnyCancellation@ContextBase@details@Concurrency@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 8B 91 A8 00 00 00 8B 81 A0 00 00 00 03 D0 85 D2 0F 9F C0 C3 }
	condition:
		$1
}

rule file_61_26_0 {
	meta:
		name = "?CancelEntireContext@ContextBase@details@Concurrency@@QEAAXXZ"
		size = 18
		refs = "000e ?CancelCollection@ContextBase@details@Concurrency@@QEAAXH@Z"
	strings:
		$1 = { B8 01 00 00 00 33 D2 87 81 A4 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_29_0 {
	meta:
		name = "?MinimumCancellationDepth@ContextBase@details@Concurrency@@QEBAHXZ"
		size = 21
	strings:
		$1 = { 8B 81 A4 00 00 00 33 D2 85 C0 75 06 8B 91 9C 00 00 00 8B C2 C3 }
	condition:
		$1
}

rule file_61_31_0 {
	meta:
		name = "?CurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
		size = 43
		refs = "0006 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0012 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0018 __imp_TlsGetValue 0022 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
		altNames = "?CurrentContext@Context@Concurrency@@SAPEAV12@XZ"
	strings:
		$1 = { 48 83 EC 28 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_33_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QEAAXXZ"
		size = 34
		refs = "0010 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z"
	strings:
		$1 = { 48 8B 41 48 83 78 10 01 75 0A BA 01 00 00 00 E9 ?? ?? ?? ?? 48 8B 81 E0 00 00 00 FF 80 A4 00 00 00 C3 }
	condition:
		$1
}

rule file_61_34_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QEAAXI@Z"
		size = 29
		refs = "000b ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z"
	strings:
		$1 = { 48 8B 41 48 83 78 10 01 75 05 E9 ?? ?? ?? ?? 48 8B 81 E0 00 00 00 01 90 A4 00 00 00 C3 }
	condition:
		$1
}

rule file_61_39_0 {
	meta:
		name = "??0TaskStack@details@Concurrency@@QEAA@XZ"
		size = 16
	strings:
		$1 = { 33 C0 48 89 01 48 89 41 08 88 41 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_61_44_0 {
	meta:
		name = "??1TaskStack@details@Concurrency@@QEAA@XZ"
		size = 23
		refs = "000e ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 83 EC 28 48 8B 49 08 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_45_0 {
	meta:
		name = "?Push@TaskStack@details@Concurrency@@QEAA_NH@Z"
		size = 156
		refs = "004e ??_U@YAPEAX_K@Z 0064 memcpy 006f ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B 39 8B EA 48 8B F1 39 79 04 7C 57 81 79 04 00 04 00 00 7C 08 C6 41 10 01 32 C0 EB 56 83 C7 08 B8 04 00 00 00 48 63 CF 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 48 8B C8 E8 ?? ?? ?? ?? 4C 63 06 48 8B 56 08 49 C1 E0 02 48 8B C8 48 8B D8 E8 ?? ?? ?? ?? 48 8B 4E 08 89 3E E8 ?? ?? ?? ?? 48 89 5E 08 48 63 4E 04 48 8B 46 08 89 2C 88 FF 46 04 B0 01 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_49_0 {
	meta:
		name = "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QEAAXPEAV_UnrealizedChore@23@@Z"
		size = 136
		refs = "001d ??0invalid_multiple_scheduling@Concurrency@@QEAA@XZ 0024 _TI2?AVinvalid_multiple_scheduling@Concurrency@@ 002e _CxxThrowException 003a ?_StructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 004e ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 005a ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0060 __imp_TlsGetValue 006a ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0084 ?PushStructured@ContextBase@details@Concurrency@@QEAAXPEAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 83 7A 10 00 48 8B FA 48 8B D9 74 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 89 4A 10 48 8D 05 ?? ?? ?? ?? 48 89 42 18 FF 41 18 48 83 79 10 00 75 26 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 43 10 48 8B 4B 10 48 8B D7 48 8B 5C 24 50 48 83 C4 40 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_54_0 {
	meta:
		name = "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QEAA_NXZ"
		size = 145
		refs = "0017 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0023 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0029 __imp_TlsGetValue 0033 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0077 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 DB 48 8B F9 48 39 59 10 75 26 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 47 10 48 8B 57 10 8B CB 8B 82 A4 00 00 00 85 C0 75 06 8B 8A 9C 00 00 00 48 39 5F 20 75 28 83 F9 FF 74 0D 8B 47 08 C1 E0 04 C1 F8 04 3B C8 7E 16 8B 82 A8 00 00 00 85 C0 7E 11 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 05 BB 01 00 00 00 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_55_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QEAAPEAXI@Z"
		size = 57
		refs = "0019 ??_V@YAXPEAX@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 48 8B 49 08 8B FA 48 85 C9 74 05 E8 ?? ?? ?? ?? 40 F6 C7 01 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_57_0 {
	meta:
		name = "?_IsIndirectAlias@_TaskCollection@details@Concurrency@@AEBA_NXZ"
		size = 29
	strings:
		$1 = { 48 39 89 90 00 00 00 74 0F 8B 81 B0 00 00 00 B9 01 00 00 00 84 C1 75 02 33 C9 8A C1 C3 }
	condition:
		$1
}

rule file_61_58_0 {
	meta:
		name = "?_HasDirectAlias@_TaskCollection@details@Concurrency@@AEBA_NXZ"
		size = 20
	strings:
		$1 = { 48 8B 91 90 00 00 00 33 C0 48 39 82 98 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_61_59_0 {
	meta:
		name = "?_IsDirectAlias@_TaskCollection@details@Concurrency@@AEBA_NXZ"
		size = 29
	strings:
		$1 = { 48 39 89 90 00 00 00 74 0F 8B 81 B0 00 00 00 B9 01 00 00 00 84 C1 74 02 33 C9 8A C1 C3 }
	condition:
		$1
}

rule file_61_60_0 {
	meta:
		name = "?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QEBA_NXZ"
		size = 16
	strings:
		$1 = { 48 8B 81 90 00 00 00 8B 48 4C 85 C9 0F 95 C0 C3 }
	condition:
		$1
}

rule file_61_61_0 {
	meta:
		name = "?_NotifyNewChore@_TaskCollection@details@Concurrency@@AEAAXXZ"
		size = 52
		refs = "0022 ?wait@event@Concurrency@@QEAA_KI@Z 002a ?reset@event@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 B8 01 00 00 00 F0 0F C1 41 18 FF C0 83 F8 01 75 17 48 8D 59 58 83 CA FF 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_62_0 {
	meta:
		name = "?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AEAAXXZ"
		size = 30
		refs = "0015 ?set@event@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 83 C8 FF F0 0F C1 41 18 FF C8 75 09 48 83 C1 58 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_63_0 {
	meta:
		name = "?_FullAliasWait@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z"
		size = 385
		refs = "0026 __security_cookie 0087 __chkstk 00a1 malloc 00bf ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 00d6 ??0exception@std@@QEAA@AEBQEBDH@Z 00dd ??_7bad_alloc@std@@6B@ 00e8 _TI2?AVbad_alloc@std@@ 00f1 _CxxThrowException 013b ?wait_for_multiple@event@Concurrency@@SA_KPEAPEAV12@_K_NI@Z 014d free 015b ?wait@event@Concurrency@@QEAA_KI@Z 0167 __security_check_cookie"
	strings:
		$1 = { 40 55 41 54 41 55 48 83 EC 50 48 8D 6C 24 20 48 C7 45 08 FE FF FF FF 48 89 5D 50 48 89 75 58 48 89 7D 60 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 28 48 8B FA 4C 8B E1 33 C0 48 85 D2 0F 84 11 01 00 00 FF C0 48 8B 92 98 00 00 00 48 85 D2 75 F2 85 C0 0F 8E FB 00 00 00 8D 70 01 4C 63 EE 4A 8D 0C ED 10 00 00 00 48 81 F9 00 04 00 00 77 31 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 20 48 85 DB 74 24 C7 03 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0A C7 00 DD DD 00 00 48 83 C3 10 48 85 DB 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 45 00 41 B8 01 00 00 00 48 8D 55 00 48 8D 4D 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 5D 10 48 8D 15 ?? ?? ?? ?? 48 8D 4D 10 E8 ?? ?? ?? ?? CC 48 89 5D 00 49 8B 84 24 90 00 00 00 48 83 C0 58 48 89 03 83 FE 01 7E 1F 48 8D 4B 08 44 8D 46 FF 48 8D 47 58 48 89 01 48 83 C1 08 48 8B BF 98 00 00 00 49 FF C8 75 E9 41 83 C9 FF 41 B0 01 49 8B D5 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 4B F0 81 39 DD DD 00 00 75 13 E8 ?? ?? ?? ?? EB 0C 48 83 C1 58 83 CA FF E8 ?? ?? ?? ?? 48 8B 4D 28 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 50 48 8B 75 58 48 8B 7D 60 48 8D 65 30 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_61_67_0 {
	meta:
		name = "?_SweepAbortedChore@_TaskCollection@details@Concurrency@@CA_NPEAV_UnrealizedChore@23@PEAX@Z"
		size = 47
		refs = "000e ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 0023 ?set@event@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 59 10 FF 42 08 E8 ?? ?? ?? ?? 83 C9 FF F0 0F C1 4B 18 FF C9 75 09 48 8D 4B 58 E8 ?? ?? ?? ?? B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_68_0 {
	meta:
		name = "?_RaisedException@_TaskCollection@details@Concurrency@@AEAAXXZ"
		size = 43
		refs = "0011 ?_RaisedException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 89 90 00 00 00 E8 ?? ?? ?? ?? 4C 8B 9B 90 00 00 00 F0 41 81 4B 4C 00 00 00 80 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_70_0 {
	meta:
		name = "?_SetCancelState@_TaskCollection@details@Concurrency@@AEAA_NJ_N@Z"
		size = 46
	strings:
		$1 = { 8B 41 4C 4C 8B D1 45 32 C9 45 3A C1 74 07 A9 FF FF FF 7F 75 15 8B C8 81 E1 00 00 00 80 0B CA F0 41 0F B1 4A 4C 75 E2 41 B1 01 41 8A C1 C3 }
	condition:
		$1
}

rule file_61_81_0 {
	meta:
		name = "?Lookup@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@AEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@H@Z"
		size = 36
		altNames = "?Lookup@?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@AEAAPEAUListNode@123@AEBQEAXH@Z"
	strings:
		$1 = { 48 8B 41 08 4D 63 C0 4A 8B 04 C0 48 85 C0 74 11 48 8B 0A 48 39 48 08 74 0A 48 8B 00 48 85 C0 75 F2 33 C0 C3 }
	condition:
		$1
}

rule file_61_83_0 {
	meta:
		name = "??0ListNode@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA@AEBQEAV_TaskCollection@23@0@Z"
		size = 22
		altNames = "??0ListNode@?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@AEBQEAXAEBQEAVExternalContextBase@23@@Z"
	strings:
		$1 = { 48 83 21 00 48 8B 02 48 89 41 08 49 8B 00 48 89 41 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_61_85_0 {
	meta:
		name = "?Remove@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@AEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@H@Z"
		size = 72
		altNames = "?Remove@?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@AEAAPEAUListNode@123@AEBQEAXH@Z"
	strings:
		$1 = { 4C 8B 59 08 4D 63 D0 33 C0 4F 8B 04 D3 4C 8B C9 4D 85 C0 74 14 48 8B 0A 49 39 48 08 74 0E 49 8B C0 4D 8B 00 4D 85 C0 75 EF 33 C0 C3 48 85 C0 75 09 49 8B 00 4B 89 04 D3 EB 06 49 8B 08 48 89 08 41 FF 49 04 49 8B C0 C3 }
	condition:
		$1
}

rule file_61_86_0 {
	meta:
		name = "?Randomize@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@CAII@Z"
		size = 19
	strings:
		$1 = { 8B D1 48 69 D2 19 95 F1 7F 48 8B C2 48 C1 E8 20 03 C2 C3 }
	condition:
		$1
}

rule file_61_90_0 {
	meta:
		name = "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QEAAXXZ"
		size = 133
		refs = "0012 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 001e ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0024 __imp_TlsGetValue 002e ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 003a ?_MarkCancellation@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ 005b ?CancelCollection@ContextBase@details@Concurrency@@QEAAXH@Z 006f ?_FinishCancelState@_TaskCollectionBase@details@Concurrency@@IEAAX_K@Z 007b ?CancelStealers@ContextBase@details@Concurrency@@QEAAXPEAV_TaskCollectionBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 79 10 00 48 8B D9 75 26 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 43 10 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 3D 48 8B 4B 10 F0 FF 81 A8 00 00 00 8B 53 08 C1 E2 04 C1 FA 04 85 D2 78 0C E8 ?? ?? ?? ?? BA 03 00 00 00 EB 05 BA 02 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B 4B 10 48 8B D3 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_92_0 {
	meta:
		name = "?_ReleaseAlias@_TaskCollection@details@Concurrency@@AEAAXXZ"
		size = 55
		refs = "0025 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 002d ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 81 B0 00 00 00 48 8B D9 EB 0F 8B D0 83 CA 02 F0 0F B1 91 B0 00 00 00 74 11 A8 02 74 ED E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_94_0 {
	meta:
		name = "?_AbortiveSweep@_TaskCollection@details@Concurrency@@AEAAXPEAX@Z"
		size = 125
		refs = "0014 ?_CollectionMatchPredicate@_TaskCollection@details@Concurrency@@CA_NPEAV_UnrealizedChore@23@PEAX@Z 001b ?_SweepAbortedChore@_TaskCollection@details@Concurrency@@CA_NPEAV_UnrealizedChore@23@PEAX@Z 0028 ?SweepUnstructured@ContextBase@details@Concurrency@@QEAAXP6A_NPEAV_UnrealizedChore@23@PEAX@Z12@Z 0034 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0061 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 48 8B C2 48 89 4C 24 20 48 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 44 24 20 48 8B C8 E8 ?? ?? ?? ?? 83 7C 24 28 00 76 45 E8 ?? ?? ?? ?? 80 78 70 00 74 10 48 8B 88 D0 00 00 00 8B 44 24 28 01 41 24 EB 2A 48 8D 48 F0 48 8B 41 48 83 78 10 01 75 0B 8B 54 24 28 E8 ?? ?? ?? ?? EB 11 48 8B 89 E0 00 00 00 8B 44 24 28 01 81 A4 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_61_95_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 31
		refs = "0012 ??0_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
		altNames = "??0?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ ??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 21 00 48 8B D9 48 83 C1 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_96_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 30
		refs = "0011 ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8D 4A 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_636_20_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 30
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8D 4A 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_792_45_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 30
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8D 4A 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_99_0 {
	meta:
		name = "?HashValue@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@CAIAEBQEAV_TaskCollection@23@H@Z"
		size = 59
	strings:
		$1 = { 4C 8B 09 45 33 C0 44 8B D2 41 8D 48 08 45 6B C0 21 41 0F B6 C1 49 FF C1 44 03 C0 48 FF C9 75 ED 41 8B C8 33 D2 48 69 C9 19 95 F1 7F 48 8B C1 48 C1 E8 20 03 C1 41 F7 F2 8B C2 C3 }
	condition:
		$1
}

rule file_61_101_0 {
	meta:
		name = "?_Initialize@_TaskCollection@details@Concurrency@@AEAAXXZ"
		size = 61
		refs = "0033 ??0_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 33 C0 89 41 48 89 41 4C 89 81 B4 00 00 00 48 83 C1 28 48 89 4C 24 48 74 0D 48 89 01 48 83 C1 08 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_61_102_0 {
	meta:
		name = "?dtor$0@?0??_Initialize@_TaskCollection@details@Concurrency@@AEAAXXZ@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX0@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 55 40 48 83 C2 28 48 8B 4D 48 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_103_0 {
	meta:
		name = "?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AEAAX_N0@Z"
		size = 175
		refs = "0030 ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QEAAXXZ 0050 ?CancelStealers@ContextBase@details@Concurrency@@QEAAXPEAV_TaskCollectionBase@23@@Z 006f ?CancelCollection@ContextBase@details@Concurrency@@QEAAXH@Z 00ab ?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 56 57 41 54 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 58 48 89 6C 24 60 41 8A D8 48 8B F1 48 8D 69 28 48 89 6C 24 50 48 8D 4D 08 E8 ?? ?? ?? ?? 90 84 DB 75 0F 83 7E 48 00 7E 15 48 8B 7D 00 48 85 FF 75 3F 48 8B D6 48 8B 4E 10 E8 ?? ?? ?? ?? 48 8B 7D 00 48 85 FF EB 28 B8 01 00 00 00 87 47 1C 33 D2 48 8D 8F 78 FF FF FF E8 ?? ?? ?? ?? 33 D2 48 8D 8F 78 FF FF FF E8 ?? ?? ?? ?? 48 3B 7D 00 74 06 48 8B 7F 08 EB 02 33 FF 48 85 FF 75 C9 48 8D 4D 08 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5C 5F 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_106_0 {
	meta:
		name = "?Insert@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@0@Z"
		size = 202
		refs = "0074 ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 4C 8B 1A 48 8B D9 33 C9 49 8B E8 48 8B F2 4D 8B CB 44 8D 51 08 6B C9 21 41 0F B6 C1 49 FF C1 03 C8 49 FF CA 75 EF 48 69 C9 19 95 F1 7F 33 D2 48 8B C1 48 C1 E8 20 03 C1 F7 33 48 8B 43 08 48 63 FA 48 8B 0C F8 EB 09 4C 39 59 08 74 08 48 8B 09 48 85 C9 75 F2 48 85 C9 75 45 B9 18 00 00 00 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 15 48 83 20 00 48 8B 06 49 89 43 08 48 8B 45 00 49 89 43 10 EB 03 45 33 DB 48 8B 4B 08 49 8B C3 48 8B 14 F9 49 89 13 48 8B 4B 08 4C 89 1C F9 FF 43 04 EB 02 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_107_0 {
	meta:
		name = "?Find@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@PEAPEAV523@@Z"
		size = 112
	strings:
		$1 = { 48 89 5C 24 08 4C 8B 12 45 33 C9 48 8B D9 49 8B D2 45 8D 59 08 45 6B C9 21 0F B6 C2 48 FF C2 44 03 C8 49 FF CB 75 EE 41 8B C9 33 D2 48 69 C9 19 95 F1 7F 48 8B C1 48 C1 E8 20 03 C1 F7 33 48 8B 43 08 48 63 CA 48 8B 04 C8 EB 09 4C 39 50 08 74 08 48 8B 00 48 85 C0 75 F2 48 85 C0 74 0C 4D 85 C0 74 07 48 8B 48 10 49 89 08 48 8B 5C 24 08 C3 }
	condition:
		$1
}

rule file_61_108_0 {
	meta:
		name = "?FindAndDelete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@PEAPEAV423@@Z"
		size = 151
		refs = "0070 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B 1A 45 33 C9 4C 8B D1 49 8B CB 41 8D 51 08 45 6B C9 21 0F B6 C1 48 FF C1 44 03 C8 48 FF CA 75 EE 49 8B 5A 08 41 8B C9 48 69 C9 19 95 F1 7F 48 8B C1 48 C1 E8 20 03 C1 41 F7 32 4C 63 CA 33 D2 4A 8B 0C CB EB 0C 4C 39 59 08 74 25 48 8B D1 48 8B 09 48 85 C9 75 EF 48 85 C9 74 2C 4D 85 C0 74 07 48 8B 51 10 49 89 10 E8 ?? ?? ?? ?? B0 01 EB 19 48 8B 01 48 85 D2 75 06 4A 89 04 CB EB 03 48 89 02 41 FF 4A 04 EB CF 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_109_0 {
	meta:
		name = "?AddArbitraryAlias@ContextBase@details@Concurrency@@QEAAXPEAV_TaskCollection@23@0@Z"
		size = 51
		refs = "0013 ?SweepAliasTable@ContextBase@details@Concurrency@@QEAAXXZ 0029 ?Insert@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@0@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 8B B8 00 00 00 4C 8D 44 24 40 48 8D 54 24 38 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_110_0 {
	meta:
		name = "?_Initialize@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ"
		size = 99
		refs = "0035 ?_UnderlyingYield@details@Concurrency@@YAXXZ 004b ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 BF 01 00 00 80 48 8B D9 8D 47 FF F0 0F B1 79 1C 75 10 33 C0 48 83 C1 28 74 03 48 89 01 87 43 1C EB 2C 33 C0 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 8B 41 1C 3B C7 7F 13 48 8D 4C 24 20 E8 ?? ?? ?? ?? 44 8B 5B 1C 44 3B DF 7E ED 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_61_111_0 {
	meta:
		name = "??0_TaskCollection@details@Concurrency@@QEAA@XZ"
		size = 229
		refs = "003e ??0event@Concurrency@@QEAA@XZ 0066 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0072 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0078 __imp_TlsGetValue 0082 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0095 ?_Initialize@_TaskCollection@details@Concurrency@@AEAAXXZ 009e ?set@event@Concurrency@@QEAAXXZ 00aa ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00bc ?CreateWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B D9 81 49 08 FF FF FF 0F 83 61 18 00 C7 41 1C 00 00 00 80 48 83 61 20 00 C7 41 50 00 00 00 00 48 83 C1 58 E8 ?? ?? ?? ?? 90 48 83 A3 98 00 00 00 00 48 83 A3 A0 00 00 00 00 C7 83 B0 00 00 00 00 00 00 00 83 A3 BC 00 00 00 00 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 43 10 48 8B 40 60 48 89 03 48 8B CB E8 ?? ?? ?? ?? 48 8D 4B 58 E8 ?? ?? ?? ?? 48 89 9B 90 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 83 78 40 00 75 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 47 40 8B 88 90 00 00 00 89 8B B8 00 00 00 81 63 08 FF FF FF 0F 48 8B C3 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_61_112_0 {
	meta:
		name = "?dtor$0@?0???0_TaskCollection@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0???0_TaskCollection@details@Concurrency@@AEAA@PEAV012@_N@Z@4HA"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_113_0 {
	meta:
		name = "??0_TaskCollection@details@Concurrency@@AEAA@PEAV012@_N@Z"
		size = 338
		refs = "004d ??0event@Concurrency@@QEAA@XZ 007b ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0087 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 008d __imp_TlsGetValue 0097 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00aa ?_Initialize@_TaskCollection@details@Concurrency@@AEAAXXZ 00b3 ?set@event@Concurrency@@QEAAXXZ 010d ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 011f ?CreateWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 41 8A E8 48 8B DA 48 8B F9 81 49 08 FF FF FF 0F 83 61 18 00 C7 41 1C 00 00 00 80 48 83 61 20 00 C7 41 50 00 00 00 00 48 83 C1 58 E8 ?? ?? ?? ?? 90 48 8B 83 90 00 00 00 48 89 87 90 00 00 00 48 83 A7 A0 00 00 00 00 C7 87 B0 00 00 00 00 00 00 00 83 A7 BC 00 00 00 00 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 47 10 48 8B 40 60 48 89 07 48 8B CF E8 ?? ?? ?? ?? 48 8D 4F 58 E8 ?? ?? ?? ?? 40 84 ED 74 41 48 8B 8F 90 00 00 00 48 8B 81 98 00 00 00 48 89 87 98 00 00 00 F0 48 0F B1 B9 98 00 00 00 74 30 48 8B D0 48 89 87 98 00 00 00 48 8B 8F 90 00 00 00 F0 48 0F B1 B9 98 00 00 00 48 3B C2 75 E1 EB 0F 83 8F B0 00 00 00 01 48 83 A7 98 00 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 83 78 40 00 75 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 43 40 8B 88 90 00 00 00 89 8F B8 00 00 00 81 67 08 FF FF FF 0F 48 8B C7 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_61_115_0 {
	meta:
		name = "?_Reset@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z"
		size = 268
		refs = "0019 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0038 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 0047 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0068 ?CollectionCancelComplete@ContextBase@details@Concurrency@@QEAA_NH@Z 00a2 ?_Reset@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z 0106 ?_RethrowException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 33 F6 48 8D 2D ?? ?? ?? ?? 48 8B FA 48 89 68 D8 89 70 D0 8B 41 50 48 8B D9 83 F8 09 75 14 48 8D 4C 24 20 E8 ?? ?? ?? ?? 44 8B 5B 50 41 83 FB 09 74 EC E8 ?? ?? ?? ?? 48 3B 43 10 75 24 8B CE 87 4B 50 83 F9 04 75 11 8B 53 08 48 8B C8 C1 E2 04 C1 FA 04 E8 ?? ?? ?? ?? 81 4B 08 FF FF FF 0F EB 0A B8 03 00 00 00 F0 0F B1 73 50 48 39 9B 90 00 00 00 74 50 8B 83 B0 00 00 00 A8 01 75 14 48 85 FF 74 0F 48 8B 8B 90 00 00 00 48 8B D7 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 8B 87 B0 00 00 00 D1 E8 A8 01 75 0A 33 D2 48 8B CF E8 ?? ?? ?? ?? 48 8B BF 98 00 00 00 48 85 FF 75 DE 8B C6 87 43 4C 85 C0 79 C0 89 74 24 40 48 89 6C 24 48 EB 0A 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 83 7B 20 08 74 EF 48 8B CB E8 ?? ?? ?? ?? EB 9A }
	condition:
		$1
}

rule file_61_116_0 {
	meta:
		name = "?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AEAAX_N@Z"
		size = 190
		refs = "007b ?CancelCollection@ContextBase@details@Concurrency@@QEAAXH@Z 008b ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AEAAXPEAX@Z 0099 ?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AEAAX_N0@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 48 83 EC 20 8B 79 50 45 33 C0 44 8A EA 41 8D 70 04 48 8B D9 8B CF 85 FF 74 10 FF C9 74 04 3B CE 75 0E 41 B8 09 00 00 00 EB 0B 41 B8 03 00 00 00 45 85 C0 74 5C 8B C7 F0 44 0F B1 43 50 44 8B C0 74 04 8B F8 EB CE 40 32 ED 83 FF 01 74 05 83 FF 05 75 28 8B 53 08 4C 8B 63 10 40 B5 01 C1 E2 04 49 8B CC C1 FA 04 E8 ?? ?? ?? ?? 83 FF 05 75 0B 49 8B D4 48 8B CB E8 ?? ?? ?? ?? 44 8A C5 41 8A D5 48 8B CB E8 ?? ?? ?? ?? 40 84 ED 74 03 87 73 50 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_61_117_0 {
	meta:
		name = "?_CancelDirectAliases@_TaskCollection@details@Concurrency@@AEAAX_NPEAV123@@Z"
		size = 55
		refs = "001c ?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AEAAX_N@Z"
	strings:
		$1 = { 4D 85 C0 74 31 48 89 5C 24 08 57 48 83 EC 20 49 8B D8 40 8A FA 40 8A D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 9B 98 00 00 00 48 85 DB 75 E9 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_118_0 {
	meta:
		name = "?_Cancel@_TaskCollection@details@Concurrency@@AEAAX_NPEAV123@@Z"
		size = 235
		refs = "0023 ?_Alias@_TaskCollection@details@Concurrency@@AEAAPEAV123@XZ 0036 ?_SetCancelState@_TaskCollection@details@Concurrency@@AEAA_NJ_N@Z 005f ?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AEAAX_N@Z 008c ?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AEAAX_N0@Z 009a ?_CancelDirectAliases@_TaskCollection@details@Concurrency@@AEAAX_NPEAV123@@Z 00ca ?CancelCollection@ContextBase@details@Concurrency@@QEAAXH@Z 00da ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AEAAXPEAX@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 4D 8B E0 40 8A F2 48 8B D9 E8 ?? ?? ?? ?? 41 B0 01 BA 01 00 00 40 48 8B CB 4C 8B D8 E8 ?? ?? ?? ?? 84 C0 74 60 4D 39 9B 90 00 00 00 74 0C 41 8B 8B B0 00 00 00 41 84 C8 75 12 4C 3B DB 74 0D 40 8A D6 48 8B CB E8 ?? ?? ?? ?? EB 2B 8B 7B 50 83 FF 01 74 4C 83 FF 05 74 47 B9 03 00 00 00 33 C0 F0 0F B1 4B 50 3B C7 75 E3 41 B0 01 40 8A D6 48 8B CB E8 ?? ?? ?? ?? 4D 8B C4 40 8A D6 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 8B 53 08 48 8B 6B 10 C1 E2 04 48 8B CD C1 FA 04 E8 ?? ?? ?? ?? 83 FF 05 75 0B 48 8B D5 48 8B CB E8 ?? ?? ?? ?? B8 04 00 00 00 87 43 50 E9 7A FF FF FF }
	condition:
		$1
}

rule file_61_120_0 {
	meta:
		name = "?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AEAAXJ@Z"
		size = 63
		refs = "001a ?_Initialize@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ 0030 ?Wait@StructuredEvent@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 41 1C 8B FA 48 8B D9 3D 01 00 00 80 7F 05 E8 ?? ?? ?? ?? 8B C7 F7 D8 F0 0F C1 43 1C 2B C7 79 09 48 8D 4B 28 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_121_0 {
	meta:
		name = "?_CountUp@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ"
		size = 53
		refs = "0014 ?_Initialize@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ 002b ?Set@StructuredEvent@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 41 1C 48 8B D9 3D 01 00 00 80 7F 05 E8 ?? ?? ?? ?? B8 01 00 00 00 F0 0F C1 43 1C FF C0 75 09 48 8D 4B 28 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_61_122_0 {
	meta:
		name = "?_Abort@_TaskCollection@details@Concurrency@@AEAAX_N@Z"
		size = 453
		refs = "001f ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 006f ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AEAAXPEAX@Z 00a9 ?TryPopUnstructured@ContextBase@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@H@Z 00db ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z 00f8 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 010d ?set@event@Concurrency@@QEAAXXZ 014e ?_Cancel@_TaskCollection@details@Concurrency@@AEAAX_NPEAV123@@Z 0159 ?_FullAliasWait@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z 01a8 ?_Reset@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 48 83 EC 20 44 8A EA 48 8B D9 E8 ?? ?? ?? ?? 48 8B B3 A0 00 00 00 48 8B E8 48 39 9B 90 00 00 00 74 11 44 8B 83 B0 00 00 00 41 F6 C0 01 74 04 33 FF EB 0E 48 8B 83 90 00 00 00 48 8B B8 98 00 00 00 48 85 F6 0F 84 B3 00 00 00 80 7E 10 00 0F 84 A9 00 00 00 48 8B D5 48 8B CB E8 ?? ?? ?? ?? C6 46 10 00 E9 A2 00 00 00 48 63 83 BC 00 00 00 83 F8 02 76 10 FF 4E 04 48 8B 46 08 48 63 4E 04 8B 14 88 EB 07 8B 94 83 A4 00 00 00 FF 8B BC 00 00 00 48 8B CD E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 74 69 80 7D 70 00 74 0C 48 8B 8D D0 00 00 00 FF 41 24 EB 27 48 8D 4D F0 48 8B 41 48 83 78 10 01 75 0C BA 01 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 8B 81 E0 00 00 00 FF 80 A4 00 00 00 49 83 64 24 10 00 49 8B CC E8 ?? ?? ?? ?? 83 C8 FF F0 0F C1 43 18 FF C8 75 09 48 8D 4B 58 E8 ?? ?? ?? ?? 83 BB BC 00 00 00 00 0F 8F 5E FF FF FF 45 84 ED 75 1E 83 7B 18 00 7F 18 48 39 9B 90 00 00 00 74 0A 8B 83 B0 00 00 00 A8 01 74 05 48 85 FF 74 11 48 8B 8B 90 00 00 00 4C 8B C7 33 D2 E8 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 39 9B 90 00 00 00 74 0E 8B 83 B0 00 00 00 A8 01 74 04 33 C0 EB 0E 48 8B 83 90 00 00 00 48 8B 80 98 00 00 00 48 3B F8 74 05 48 8B F8 EB 92 83 A3 BC 00 00 00 00 48 85 F6 74 04 83 66 04 00 45 84 ED 75 0B 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_61_123_0 {
	meta:
		name = "?_Cancel@_TaskCollection@details@Concurrency@@QEAAXXZ"
		size = 21
		refs = "0011 ?_Cancel@_TaskCollection@details@Concurrency@@AEAAX_NPEAV123@@Z"
	strings:
		$1 = { 4C 8B 81 98 00 00 00 48 8B 89 90 00 00 00 33 D2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_124_0 {
	meta:
		name = "?_Abort@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ"
		size = 250
		refs = "001b ?PopStructured@ContextBase@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ 004f ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z 0075 ?_Cancel@_StructuredTaskCollection@details@Concurrency@@QEAAXXZ 0080 ?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AEAAXJ@Z 0090 ?_UnderlyingYield@details@Concurrency@@YAXXZ 00ad ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 00e3 ?CollectionCancelComplete@ContextBase@details@Concurrency@@QEAA_NH@Z 00eb ?_RethrowException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 83 79 18 00 48 8B 79 10 48 8B D9 7E 54 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 74 47 48 83 60 10 00 80 7F 70 00 74 0C 48 8B 87 D0 00 00 00 FF 40 24 EB 27 48 8D 4F F0 48 8B 41 48 83 78 10 01 75 0C BA 01 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 8B 81 E0 00 00 00 FF 80 A4 00 00 00 FF 4B 18 83 7B 18 00 7F AC 83 7B 18 00 7E 17 48 8B CB E8 ?? ?? ?? ?? 8B 53 18 48 8B CB E8 ?? ?? ?? ?? 83 63 18 00 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8B 43 20 48 83 E0 FC 48 83 F8 08 75 18 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 5B 20 49 83 E3 FC 49 83 FB 08 74 E8 B1 03 84 4B 20 74 07 F0 FF 8F A8 00 00 00 8A 43 20 22 C1 3A C1 75 11 8B 53 08 48 8B CF C1 E2 04 C1 FA 04 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_61_125_0 {
	meta:
		name = "?_TaskCleanup@_TaskCollection@details@Concurrency@@AEAA_N_N@Z"
		size = 166
		refs = "003d ?__uncaught_exception@@YA_NXZ 0081 ?_Abort@_TaskCollection@details@Concurrency@@AEAAX_N@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 33 DB 40 8A EA 48 8B F9 44 8D 63 01 40 8A F3 48 39 89 90 00 00 00 74 0B 8B 81 B0 00 00 00 41 84 C4 74 49 E8 ?? ?? ?? ?? 84 C0 75 35 39 5F 18 40 0F 9F C6 48 39 BF 90 00 00 00 75 20 48 8B 87 98 00 00 00 EB 12 39 58 18 48 8B 80 98 00 00 00 40 0F B6 F6 41 0F 4F F4 48 85 C0 75 E9 40 84 F6 74 0E 40 8A D5 48 8B CF E8 ?? ?? ?? ?? 40 84 F6 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 0F 94 C0 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_61_126_0 {
	meta:
		name = "??1_TaskCollection@details@Concurrency@@QEAA@XZ"
		size = 199
		refs = "0039 ?_TaskCleanup@_TaskCollection@details@Concurrency@@AEAA_N_N@Z 0060 ?_ReleaseAlias@_TaskCollection@details@Concurrency@@AEAAXXZ 0082 ??_V@YAXPEAX@Z 008a ??3@YAXPEAX@Z 0099 ??0missing_wait@Concurrency@@QEAA@XZ 00a0 _TI2?AVmissing_wait@Concurrency@@ 00aa _CxxThrowException 00c3 ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 58 48 89 74 24 60 48 8B F9 40 32 F6 48 39 89 90 00 00 00 74 0A 8B 81 B0 00 00 00 A8 01 74 36 33 D2 E8 ?? ?? ?? ?? 84 C0 40 0F 94 C6 48 39 BF 90 00 00 00 75 20 48 8B 8F 98 00 00 00 48 85 C9 74 14 48 8B 99 98 00 00 00 E8 ?? ?? ?? ?? 48 8B CB 48 85 DB 75 EC 48 8B 9F A0 00 00 00 48 85 DB 74 16 48 8B 4B 08 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 40 84 F6 74 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8D 4F 58 48 8B 5C 24 58 48 8B 74 24 60 48 83 C4 40 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_127_0 {
	meta:
		name = "?dtor$0@?0???1_TaskCollection@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_510_1 {
	meta:
		name = "?dtor$1@?0???1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_533_1 {
	meta:
		name = "?dtor$1@?0???1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_132_0 {
	meta:
		name = "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z"
		size = 494
		refs = "0030 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 003c ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0042 __imp_TlsGetValue 004c ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00b9 ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IEAAX_NH@Z 00d7 ?PopStructured@ContextBase@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ 013e ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z 0169 ?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AEAAXJ@Z 018f ?_Abort@_StructuredTaskCollection@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 41 54 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 68 4C 8B E2 48 8B D9 33 FF 48 39 79 10 75 26 F7 05 ?? ?? ?? ?? 00 00 00 80 74 11 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 89 43 10 48 8B 73 10 48 89 74 24 60 48 8B 46 60 48 89 03 48 89 5E 60 48 8B 03 48 85 C0 74 0D 8B 40 08 C1 E0 04 C1 F8 04 FF C0 EB 02 8B C7 81 63 08 00 00 00 F0 25 FF FF FF 0F 09 43 08 4D 85 E4 74 37 F6 43 20 03 75 16 8B 8E A8 00 00 00 8B 86 A0 00 00 00 03 C8 85 C9 7E 12 F6 43 20 03 0F 95 C2 45 33 C0 48 8B CB E8 ?? ?? ?? ?? 49 8B CC 41 FF 54 24 08 49 89 7C 24 10 39 7B 18 0F 8E 8B 00 00 00 48 8B CE E8 ?? ?? ?? ?? 4C 8B E0 48 89 44 24 58 F6 43 20 03 75 16 8B 96 A8 00 00 00 8B 8E A0 00 00 00 03 D1 85 D2 7E 15 F6 43 20 03 0F 95 C2 41 B8 02 00 00 00 48 8B CB E8 ?? ?? ?? ?? 4D 85 E4 74 49 FF 4B 18 40 38 7E 70 74 0C 48 8B 86 D0 00 00 00 FF 40 24 EB 27 48 8D 4E F0 48 8B 41 48 83 78 10 01 75 0C BA 01 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 8B 81 E0 00 00 00 FF 80 A4 00 00 00 49 8B CC 41 FF 54 24 08 E9 67 FF FF FF 8B 53 18 85 D2 7E 0B 48 8B CB E8 ?? ?? ?? ?? 89 7B 18 EB 0C 48 8B 74 24 60 48 8B 5C 24 50 33 FF 48 8B 03 48 89 46 60 48 39 7B 20 74 31 48 8B CB E8 ?? ?? ?? ?? 44 8B 9E A8 00 00 00 8B 8E A0 00 00 00 44 03 D9 45 85 DB 7E 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? B8 02 00 00 00 EB 24 8B 96 A8 00 00 00 8B 8E A0 00 00 00 03 D1 85 D2 7E 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? B8 01 00 00 00 48 8B 5C 24 68 48 83 C4 30 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_61_134_0 {
	meta:
		name = "__catch$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z$0"
		size = 129
		refs = "0043 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z 005f ?_RaisedCancel@_TaskCollectionBase@details@Concurrency@@IEAAXXZ 0067 $LN36"
	strings:
		$1 = { 48 8B 7D 58 48 8B 5D 50 48 85 FF 74 4E F7 43 08 00 00 00 20 74 40 FF 4B 18 48 8B 45 60 80 78 70 00 74 0C 48 8B 80 D0 00 00 00 FF 40 24 EB 27 48 8D 48 F0 48 8B 41 48 83 78 10 01 75 0C BA 01 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 8B 81 E0 00 00 00 FF 80 A4 00 00 00 48 83 67 10 00 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5F 5D 5B C3 CC CC CC CC CC CC CC CC CC CC CC CC CC CC }
	condition:
		$1
}

rule file_61_136_0 {
	meta:
		name = "__catch$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z$1"
		size = 38
		refs = "0013 ?_RaisedException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ 001b $LN38"
	strings:
		$1 = { 48 8B 45 58 48 85 C0 74 05 48 83 60 10 00 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_61_137_0 {
	meta:
		name = "?GetArbitraryAlias@ContextBase@details@Concurrency@@QEAAPEAV_TaskCollection@23@PEAV423@@Z"
		size = 128
		refs = "0022 ?Find@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@PEAPEAV523@@Z 005c ?FindAndDelete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@PEAPEAV423@@Z 0064 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 006c ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 18 48 89 54 24 10 57 48 83 EC 20 48 8D B9 B8 00 00 00 48 8D 54 24 38 45 33 C0 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 74 06 48 8B 58 10 EB 02 33 DB 48 85 DB 74 3A 8B 83 B0 00 00 00 D1 E8 A8 01 74 2E 48 8B 83 90 00 00 00 48 8D 54 24 30 45 33 C0 48 8B CF 48 89 44 24 30 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 33 DB 48 8B C3 48 8B 5C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_138_0 {
	meta:
		name = "?_Alias@_TaskCollection@details@Concurrency@@AEAAPEAV123@XZ"
		size = 247
		refs = "0020 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 002c ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0032 __imp_TlsGetValue 003f ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0050 ?CreateWorkQueue@ContextBase@details@Concurrency@@QEAAXXZ 0075 ?GetIndirectAlias@ContextBase@details@Concurrency@@QEBAPEAV_TaskCollection@23@XZ 008e ?GetArbitraryAlias@ContextBase@details@Concurrency@@QEAAPEAV_TaskCollection@23@PEAV423@@Z 009d ??2@YAPEAX_K@Z 00b5 ??0_TaskCollection@details@Concurrency@@AEAA@PEAV012@_N@Z 00ca ?SweepAliasTable@ContextBase@details@Concurrency@@QEAAXXZ 00e0 ?Insert@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAPEAUListNode@123@AEBQEAV_TaskCollection@23@0@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 50 48 89 74 24 58 48 8B F9 33 F6 F7 05 ?? ?? ?? ?? 00 00 00 80 74 14 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 08 E8 ?? ?? ?? ?? 48 8B D8 48 39 73 40 75 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 43 40 8B 88 90 00 00 00 48 3B 5F 10 75 0D 3B 8F B8 00 00 00 75 05 48 8B C7 EB 76 48 8B CB E8 ?? ?? ?? ?? 48 85 C0 74 09 48 39 B8 90 00 00 00 74 60 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 85 C0 75 50 B9 C0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 85 C0 74 11 41 B0 01 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 89 74 24 40 48 89 7C 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8D 8B B8 00 00 00 4C 8D 44 24 40 48 8D 54 24 48 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_61_140_0 {
	meta:
		name = "?_Schedule@_TaskCollection@details@Concurrency@@QEAAXPEAV_UnrealizedChore@23@@Z"
		size = 258
		refs = "002c ??0invalid_multiple_scheduling@Concurrency@@QEAA@XZ 0033 _TI2?AVinvalid_multiple_scheduling@Concurrency@@ 003d _CxxThrowException 0043 ?_Alias@_TaskCollection@details@Concurrency@@AEAAPEAV123@XZ 0051 ?_UnstructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 007e ??2@YAPEAX_K@Z 00a9 ?_NotifyNewChore@_TaskCollection@details@Concurrency@@AEAAXXZ 00ae ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00b9 ?PushUnstructured@ContextBase@details@Concurrency@@QEAAHPEAV_UnrealizedChore@23@@Z 00c3 ?Push@TaskStack@details@Concurrency@@QEAA_NH@Z"
	strings:
		$1 = { 48 8B C4 48 89 50 10 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 58 08 48 89 70 18 48 8B F2 48 83 7A 10 00 74 1B 48 8D 48 E0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 8B D8 48 89 46 10 48 8D 05 ?? ?? ?? ?? 48 89 46 18 48 63 BB BC 00 00 00 8D 47 01 89 83 BC 00 00 00 83 FF 02 72 65 48 8B BB A0 00 00 00 48 85 FF 75 2B 8D 4F 18 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 12 83 20 00 83 60 04 00 48 83 60 08 00 C6 40 10 00 EB 02 33 FF 48 89 BB A0 00 00 00 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8B CF E8 ?? ?? ?? ?? 84 C0 75 27 FF 8B BC 00 00 00 EB 1F 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 89 84 BB A8 00 00 00 48 8B 5C 24 50 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_61_142_0 {
	meta:
		name = "__catch$?_Schedule@_TaskCollection@details@Concurrency@@QEAAXPEAV_UnrealizedChore@23@@Z$0"
		size = 19
		refs = "0005 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 000e _CxxThrowException"
	strings:
		$1 = { 48 8B 4D 58 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_61_143_0 {
	meta:
		name = "?_RunAndWait@_TaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z"
		size = 1021
		refs = "002c ?_Alias@_TaskCollection@details@Concurrency@@AEAAPEAV123@XZ 0039 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00a4 ?_NotifyNewChore@_TaskCollection@details@Concurrency@@AEAAXXZ 00ae ??0task_canceled@details@Concurrency@@QEAA@XZ 00b5 _TI2?AVtask_canceled@details@Concurrency@@ 00bf _CxxThrowException 0120 ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IEAAX_NH@Z 0132 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 0147 ?set@event@Concurrency@@QEAAXXZ 01e4 ?TryPopUnstructured@ContextBase@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@H@Z 0234 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXI@Z 02d5 ?_FullAliasWait@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z 02f5 ?_UnderlyingYield@details@Concurrency@@YAXXZ 030d ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 03a0 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ 03af ?_Reset@_TaskCollection@details@Concurrency@@AEAAXPEAV123@@Z 03be ?_Abort@_TaskCollection@details@Concurrency@@AEAAX_N@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 53 56 57 41 54 41 55 41 56 41 57 48 81 EC 90 00 00 00 48 C7 44 24 38 FE FF FF FF 48 8B F2 4C 8B E9 E8 ?? ?? ?? ?? 48 8B F8 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B F0 48 89 44 24 30 4D 8B BD 98 00 00 00 4C 89 7C 24 28 33 DB 88 9C 24 E0 00 00 00 48 8B 40 60 48 89 07 44 8D 63 01 48 85 C0 74 0E 8B 48 08 C1 E1 04 C1 F9 04 41 03 CC EB 02 8B CB 81 67 08 00 00 00 F0 81 E1 FF FF FF 0F 09 4F 08 49 89 7E 60 33 C0 F0 44 0F B1 67 50 83 F8 03 75 28 48 85 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 85 F6 0F 84 87 00 00 00 48 8B CF E8 ?? ?? ?? ?? 41 8B 8E A8 00 00 00 41 8B 86 A0 00 00 00 03 C8 85 C9 7F 16 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 08 8B 47 50 41 3B C4 74 26 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 0A 8B 47 50 41 3B C4 8A D3 74 03 41 8A D4 45 33 C0 49 8B CD E8 ?? ?? ?? ?? 48 8B CE FF 56 08 48 89 5E 10 48 8B CE E8 ?? ?? ?? ?? 83 C8 FF F0 0F C1 47 18 FF C8 75 09 48 8D 4F 58 E8 ?? ?? ?? ?? 48 89 9C 24 D8 00 00 00 39 9F BC 00 00 00 0F 8E 19 01 00 00 41 8B 8E A8 00 00 00 41 8B 86 A0 00 00 00 03 C8 85 C9 7F 16 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 08 8B 47 50 41 3B C4 74 26 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 0A 8B 47 50 41 3B C4 8A D3 74 03 41 8A D4 45 33 C0 49 8B CD E8 ?? ?? ?? ?? 48 63 87 BC 00 00 00 83 F8 02 76 17 48 8B 87 A0 00 00 00 FF 48 04 48 63 48 04 48 8B 40 08 8B 14 88 EB 08 41 8B 94 85 A4 00 00 00 FF 8F BC 00 00 00 49 8B CE E8 ?? ?? ?? ?? 48 8B F0 48 89 84 24 D8 00 00 00 48 85 C0 75 17 48 8B 87 A0 00 00 00 48 85 C0 74 03 89 58 04 89 9F BC 00 00 00 EB 69 41 38 5E 70 74 0D 49 8B 86 D0 00 00 00 44 01 60 24 EB 26 49 8D 4E F0 48 8B 41 48 44 39 60 10 75 0A 41 8B D4 E8 ?? ?? ?? ?? EB 0E 48 8B 81 E0 00 00 00 44 01 A0 A4 00 00 00 48 8B CE FF 56 08 48 89 5E 10 48 8B CE E8 ?? ?? ?? ?? 83 C8 FF F0 0F C1 47 18 FF C8 0F 85 E1 FE FF FF 48 8D 4F 58 E8 ?? ?? ?? ?? E9 D3 FE FF FF 48 8B 87 A0 00 00 00 48 85 C0 74 42 38 58 10 74 3D 41 8A F4 44 88 A4 24 E0 00 00 00 41 8B C4 B9 05 00 00 00 F0 0F B1 4F 50 83 F8 04 74 05 83 F8 09 75 23 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 70 E8 ?? ?? ?? ?? 40 8A B4 24 E0 00 00 00 49 8B D7 49 8B CD E8 ?? ?? ?? ?? 40 84 F6 74 35 B8 05 00 00 00 F0 44 0F B1 67 50 83 F8 09 75 25 89 5C 24 48 48 8D 05 ?? ?? ?? ?? 48 89 44 24 50 41 8B 45 50 83 F8 09 75 0C 48 8D 4C 24 40 E8 ?? ?? ?? ?? EB EB 49 8B 85 98 00 00 00 4C 3B F8 75 02 EB 2A 4C 8B F8 48 89 44 24 28 E9 25 FE FF FF 4C 8B 7C 24 28 4C 8B 74 24 30 48 8B 7C 24 20 4C 8B AC 24 D0 00 00 00 41 BC 01 00 00 00 48 8B 07 49 89 46 60 41 8B 8E A0 00 00 00 41 8B 86 A8 00 00 00 03 C8 85 C9 7F 16 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 08 8B 47 50 41 3B C4 74 2C 41 8B 86 A0 00 00 00 85 C0 7F 31 49 8B 85 90 00 00 00 8B 48 4C 85 C9 75 23 8B 4F 50 85 C9 75 1C 49 8B CD E8 ?? ?? ?? ?? 84 C0 75 10 49 8B D7 48 8B CF E8 ?? ?? ?? ?? 41 8B C4 EB 32 33 D2 48 8B CF E8 ?? ?? ?? ?? 45 8B 9E A0 00 00 00 41 8B 8E A8 00 00 00 44 03 D9 45 85 DB 7E 0D 45 33 C0 33 D2 49 8B CD E8 ?? ?? ?? ?? B8 02 00 00 00 48 81 C4 90 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_61_145_0 {
	meta:
		name = "__catch$?_RunAndWait@_TaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z$0"
		size = 67
		refs = "0012 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 002b ?set@event@Concurrency@@QEAAXXZ 0033 $LN50"
	strings:
		$1 = { 48 8B 8D D8 00 00 00 48 85 C9 74 24 48 83 61 10 00 E8 ?? ?? ?? ?? 48 8B 4D 20 83 C8 FF F0 0F C1 41 18 FF C8 75 0A 48 83 C1 58 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC CC CC CC CC CC }
	condition:
		$1
}

rule file_61_147_0 {
	meta:
		name = "__catch$?_RunAndWait@_TaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z$1"
		size = 77
		refs = "0012 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPEAV123@@Z 002b ?set@event@Concurrency@@QEAAXXZ 0039 ?_RaisedException@_TaskCollection@details@Concurrency@@AEAAXXZ 0041 $LN52"
	strings:
		$1 = { 48 8B 8D D8 00 00 00 48 85 C9 74 25 48 83 61 10 00 E8 ?? ?? ?? ?? 48 8B 5D 20 83 C8 FF F0 0F C1 43 18 FF C8 75 0F 48 8D 4B 58 E8 ?? ?? ?? ?? EB 04 48 8B 5D 20 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 28 5D 5B C3 CC }
	condition:
		$1
}

rule file_61_151_0 {
	meta:
		name = "?_IsCanceling@_TaskCollection@details@Concurrency@@QEAA_NXZ"
		size = 258
		refs = "0020 ?_Alias@_TaskCollection@details@Concurrency@@AEAAPEAV123@XZ 0074 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B 41 4C 33 DB 48 8B F1 85 C0 0F 85 D1 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 8B 50 10 8B 8A A4 00 00 00 85 C9 8B CB 75 06 8B 8A 9C 00 00 00 8B 82 A4 00 00 00 85 C0 0F 85 A5 00 00 00 8B 47 08 C1 E0 04 C1 F8 04 83 F8 FF 74 0D 83 F9 FF 74 08 3B C8 0F 8E 8A 00 00 00 8B 82 A8 00 00 00 85 C0 7E 0C 48 8B CF E8 ?? ?? ?? ?? 84 C0 75 74 48 39 BF 90 00 00 00 74 67 8B 87 B0 00 00 00 A8 01 74 5D 48 8B 56 10 8B CB 8B 82 A4 00 00 00 85 C0 75 06 8B 8A 9C 00 00 00 8B 82 A4 00 00 00 85 C0 75 41 8B 46 08 C1 E0 04 C1 F8 04 83 F8 FF 74 0E 83 F9 FF 74 09 BF 01 00 00 00 3B C8 7E 02 8B FB 8B 82 A8 00 00 00 85 C0 7E 11 48 8B CE E8 ?? ?? ?? ?? 84 C0 74 05 BB 01 00 00 00 0B DF 75 04 32 C0 EB 02 B0 01 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_initp_misc_winsig"
		size = 29
		refs = "0003 ctrlc_action 000a ctrlbreak_action 0011 abort_action 0018 term_action"
	strings:
		$1 = { 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "ctrlevent_capture"
		size = 148
		refs = "0014 _lock 0020 ctrlc_action 002d __imp_DecodePointer 0039 ctrlbreak_action 005e _encoded_null 0068 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B D9 33 C9 E8 ?? ?? ?? ?? 90 85 DB 75 19 48 8D 3D ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 73 02 EB 19 48 8D 3D ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BE 15 00 00 00 48 8B D8 48 85 C0 74 0E 48 83 F8 01 74 08 E8 ?? ?? ?? ?? 48 89 07 33 C9 E8 ?? ?? ?? ?? 48 85 DB 75 04 33 C0 EB 0F 48 83 FB 01 74 04 8B CE FF D3 B8 01 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "ctrlevent_capture$fin$0"
		size = 24
		refs = "000c _unlock"
		altNames = "signal$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 33 C9 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "siglookup"
		size = 59
		refs = "0006 _XcptActTabCount"
	strings:
		$1 = { 44 8B C9 48 63 0D ?? ?? ?? ?? 48 8B C2 44 39 48 04 74 13 4C 8B C1 48 83 C0 10 49 C1 E0 04 4C 03 C2 49 3B C0 72 E7 48 C1 E1 04 48 03 CA 48 3B C1 73 06 44 39 48 04 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "__fpecode"
		size = 20
		refs = "0005 _getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 05 B0 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_6_0 {
	meta:
		name = "__pxcptinfoptrs"
		size = 20
		refs = "0005 _getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 05 A8 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_7_0 {
	meta:
		name = "signal"
		size = 701
		refs = "0072 _getptd_noexit 0085 _XcptActTab 0095 _XcptActTabSize 009a _malloc_crt 00bd memcpy 00cf _XcptActTabCount 0152 _lock 0163 ConsoleCtrlHandler_Installed 0172 ctrlevent_capture 0178 __imp_SetConsoleCtrlHandler 018a __doserrno 0193 __imp_GetLastError 01ca ctrlbreak_action 01d0 __imp_DecodePointer 01e6 __imp_EncodePointer 01f6 term_action 021e abort_action 0246 ctrlc_action 026c _unlock 0294 _errno 029f _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 48 83 EC 30 48 8B F2 8B F9 45 33 E4 48 83 FA 04 0F 84 53 02 00 00 48 83 FA 03 0F 84 49 02 00 00 83 F9 02 0F 84 15 01 00 00 83 F9 15 0F 84 0C 01 00 00 83 F9 16 0F 84 03 01 00 00 83 F9 06 0F 84 FA 00 00 00 83 F9 0F 0F 84 F1 00 00 00 83 F9 08 74 0E 83 F9 04 74 09 83 F9 0B 0F 85 09 02 00 00 E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 F8 01 00 00 48 8D 1D ?? ?? ?? ?? 48 39 98 A0 00 00 00 75 2F 48 63 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 49 89 84 24 A0 00 00 00 48 85 C0 0F 84 CB 01 00 00 4C 63 05 ?? ?? ?? ?? 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 49 8B 8C 24 A0 00 00 00 48 8B D1 4C 63 05 ?? ?? ?? ?? 39 7A 04 74 13 48 83 C2 10 49 8B C0 48 C1 E0 04 48 03 C1 48 3B D0 72 E8 49 8B C0 48 C1 E0 04 48 03 C1 48 3B D0 73 05 39 7A 04 74 02 33 D2 48 85 D2 0F 84 70 01 00 00 48 8B 5A 08 48 83 FE 02 0F 84 5D 01 00 00 48 83 C2 04 EB 28 48 89 72 04 48 83 C2 10 48 63 0D ?? ?? ?? ?? 48 C1 E1 04 49 03 8C 24 A0 00 00 00 48 8D 42 FC 48 3B C1 0F 83 2F 01 00 00 39 3A 74 D4 E9 26 01 00 00 33 C9 E8 ?? ?? ?? ?? 90 83 FF 02 74 05 83 FF 15 75 3E 83 3D ?? ?? ?? ?? 00 75 35 BA 01 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 01 75 08 89 05 ?? ?? ?? ?? EB 16 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 89 03 41 BC 01 00 00 00 8B CF 83 E9 02 0F 84 99 00 00 00 83 E9 04 74 6C 83 E9 09 74 3F 83 E9 06 74 0E FF C9 74 5E 48 8B 5C 24 20 E9 A2 00 00 00 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 FE 02 0F 84 88 00 00 00 48 8B CE FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 76 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 FE 02 74 60 48 8B CE FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 4E 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 FE 02 74 38 48 8B CE FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 26 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 FE 02 74 10 48 8B CE FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 45 85 E4 75 05 48 8B C3 EB 2D 83 FF 01 74 24 83 FF 03 74 1F 83 FF 0D 74 1A 83 FF 0F 7E 05 83 FF 11 7E 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 48 83 C4 30 41 5C C3 }
	condition:
		$1
}

rule file_62_9_0 {
	meta:
		name = "raise"
		size = 562
		refs = "004f _errno 005a _invalid_parameter_noinfo 0063 ctrlbreak_action 0076 term_action 0086 abort_action 0094 _getptd_noexit 00b5 _XcptActTabCount 00f4 ctrlc_action 010a __imp_DecodePointer 0128 _exit 0134 _lock 0187 _First_FPE_Indx 0193 _Num_FPE 01bf _encoded_null 01ce _unlock"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 30 8B D9 33 FF 89 7C 24 60 33 F6 8B D1 83 EA 02 0F 84 C5 00 00 00 83 EA 02 74 62 83 EA 02 74 4D 83 EA 02 74 58 83 EA 03 74 53 83 EA 04 74 2E 83 EA 06 74 16 FF CA 74 35 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 40 4C 8D 25 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? E9 8C 00 00 00 4C 8D 25 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? EB 7C 4C 8D 25 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? EB 6C E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 08 83 C8 FF E9 72 01 00 00 48 8B 90 A0 00 00 00 48 8B CA 4C 63 05 ?? ?? ?? ?? 39 59 04 74 13 48 83 C1 10 49 8B C0 48 C1 E0 04 48 03 C2 48 3B C8 72 E8 49 8B C0 48 C1 E0 04 48 03 C2 48 3B C8 73 05 39 59 04 74 02 33 C9 4C 8D 61 08 4D 8B 2C 24 EB 20 4C 8D 25 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? BF 01 00 00 00 89 7C 24 60 FF 15 ?? ?? ?? ?? 4C 8B E8 49 83 FD 01 75 07 33 C0 E9 FC 00 00 00 4D 85 ED 75 0A 41 8D 4D 03 E8 ?? ?? ?? ?? CC 85 FF 74 08 33 C9 E8 ?? ?? ?? ?? 90 83 FB 08 74 11 83 FB 0B 74 0C 83 FB 04 74 07 4C 8B 7C 24 28 EB 2C 4C 8B BE A8 00 00 00 4C 89 7C 24 28 48 83 A6 A8 00 00 00 00 83 FB 08 75 13 44 8B B6 B0 00 00 00 C7 86 B0 00 00 00 8C 00 00 00 EB 05 44 8B 74 24 60 83 FB 08 75 39 8B 0D ?? ?? ?? ?? 8B D1 89 4C 24 20 8B 05 ?? ?? ?? ?? 03 C8 3B D1 7D 2A 48 63 CA 48 03 C9 48 8B 86 A0 00 00 00 48 83 64 C8 08 00 FF C2 89 54 24 20 8B 0D ?? ?? ?? ?? EB D3 E8 ?? ?? ?? ?? 49 89 04 24 85 FF 74 07 33 C9 E8 ?? ?? ?? ?? BF 08 00 00 00 3B DF 75 0D 8B 96 B0 00 00 00 8B CF 41 FF D5 EB 05 8B CB 41 FF D5 3B DF 74 0E 83 FB 0B 74 09 83 FB 04 0F 85 18 FF FF FF 4C 89 BE A8 00 00 00 3B DF 0F 85 09 FF FF FF 44 89 B6 B0 00 00 00 E9 FD FE FF FF 48 8B 5C 24 68 48 8B 74 24 70 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_62_10_0 {
	meta:
		name = "raise$fin$0"
		size = 30
		refs = "0012 _unlock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 83 7D 60 00 74 08 33 C9 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "iswctype"
		size = 102
		refs = "0028 _pwctype 0049 __imp_GetStringTypeW"
	strings:
		$1 = { 66 89 4C 24 08 53 48 83 EC 20 B8 FF FF 00 00 0F B7 DA 66 3B C8 75 04 33 C0 EB 45 B8 00 01 00 00 66 3B C8 73 10 48 8B 05 ?? ?? ?? ?? 0F B7 C9 0F B7 04 48 EB 26 B9 01 00 00 00 4C 8D 4C 24 40 48 8D 54 24 30 44 8B C1 FF 15 ?? ?? ?? ?? 33 C9 85 C0 74 05 0F B7 4C 24 40 0F B7 C1 0F B7 CB 23 C1 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "calloc"
		size = 65
		refs = "0011 _calloc_impl 0024 _errno"
	strings:
		$1 = { 40 53 48 83 EC 20 83 64 24 40 00 4C 8D 44 24 40 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1B 39 44 24 40 74 15 E8 ?? ?? ?? ?? 48 85 C0 74 0B E8 ?? ?? ?? ?? 8B 4C 24 40 89 08 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "_inc"
		size = 37
		refs = "0018 _filbuf"
		altNames = "_getc_nolock"
	strings:
		$1 = { 48 83 EC 28 FF 49 08 78 0E 48 8B 01 0F B6 10 48 FF C0 48 89 01 EB 07 E8 ?? ?? ?? ?? 8B D0 8B C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_8_0 {
	meta:
		name = "_whiteout"
		size = 68
		refs = "001b _inc 002a isspace"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F2 48 8B F9 FF 07 48 8B CE E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 0C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 E3 48 8B 74 24 38 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_65_9_0 {
	meta:
		name = "_input_l"
		size = 4212
		refs = "0022 __security_cookie 006d _errno 0078 _invalid_parameter_noinfo 0094 _fileno 009b __badioinfo 00a2 __pioinfo 0117 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0143 isspace 015a _inc 0177 _ungetc_nolock 01f4 isdigit 04f5 __check_float_string 06a8 free 07bd _cfltcvt_tab 07cd __imp_DecodePointer 08af memset 0be1 isleadbyte 0c1b _mbtowc_l 0d46 isxdigit 1055 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 80 FE FF FF 48 81 EC 80 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 70 01 00 00 33 C0 4C 8D 6D 10 4C 89 4D B8 49 8B D8 4C 8B E2 48 89 54 24 50 4C 89 6C 24 78 48 8B F1 48 89 4C 24 68 48 C7 45 B0 5E 01 00 00 89 45 84 66 89 45 88 8B F8 89 44 24 3C 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C6 0F 00 00 48 85 C9 74 E3 41 83 CF FF F6 41 18 40 75 7C E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 41 3B C7 74 1D 83 F8 FE 74 18 4C 63 C0 49 8B C8 41 83 E0 1F 48 C1 F9 05 4D 6B C0 58 4D 03 04 C9 EB 03 4C 8B C2 41 F6 40 38 7F 75 25 41 3B C7 74 1A 83 F8 FE 74 15 48 63 D0 48 8B C2 83 E2 1F 48 C1 F8 05 48 6B D2 58 49 03 14 C1 F6 42 38 80 74 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 41 8B C7 E9 3B 0F 00 00 48 8D 4D C8 48 8B D3 E8 ?? ?? ?? ?? 41 8A 04 24 33 DB 88 5C 24 39 44 8B F3 89 5C 24 34 44 8B EB 89 5C 24 70 84 C0 0F 84 FC 0E 00 00 44 8D 6B 01 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 50 45 2B F5 45 03 F5 48 8B CE 44 89 74 24 34 E8 ?? ?? ?? ?? 8B D8 41 3B C7 74 16 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 DD 48 8B D6 8B CB E8 ?? ?? ?? ?? 4D 03 E5 41 0F B6 0C 24 E8 ?? ?? ?? ?? 85 C0 75 EF 48 8B 74 24 68 4C 89 64 24 50 E9 35 0E 00 00 B1 25 41 38 0C 24 0F 85 BC 0D 00 00 41 38 4C 24 01 0F 84 A0 0D 00 00 4C 8B 6C 24 50 BA 01 00 00 00 89 5C 24 5C 88 54 24 38 88 5D 80 89 5C 24 4C 89 5C 24 60 44 8B F3 88 5C 24 58 88 5C 24 40 88 5C 24 30 40 8A F3 88 5D A8 44 8A E3 8B FB 4C 03 EA 41 0F B6 5D 00 8B CB E8 ?? ?? ?? ?? 45 33 C0 85 C0 74 13 43 8D 04 B6 41 8D 50 01 01 54 24 60 44 8D 74 43 D0 EB 66 83 FB 2A 0F 84 07 01 00 00 83 FB 46 74 53 83 FB 49 0F 84 9F 00 00 00 83 FB 4C 0F 84 8B 00 00 00 83 FB 4E 74 3C 83 FB 68 74 2F BA 01 00 00 00 83 FB 6C 74 0A 83 FB 77 74 1B E9 CA 00 00 00 41 80 7D 01 6C 75 0B 49 FF C5 03 FA 4C 89 45 90 EB 16 00 54 24 38 44 02 E2 EB 0D 44 00 7C 24 38 45 02 E7 BA 01 00 00 00 8A 4C 24 30 40 84 F6 0F 84 64 FF FF FF 89 7C 24 48 8B 7C 24 3C 4C 89 6C 24 50 44 8A 6D 80 44 89 74 24 44 84 C9 0F 85 93 00 00 00 48 8B 45 B8 48 89 45 E8 48 83 C0 08 48 89 45 B8 48 8B 40 F8 48 89 45 A0 EB 7D BA 01 00 00 00 00 54 24 38 EB B0 41 8A 45 01 3C 36 75 16 49 8D 4D 02 80 39 34 75 0D 4C 8B E9 BA 01 00 00 00 E9 74 FF FF FF 3C 33 75 11 49 8D 4D 02 80 39 32 75 08 4C 8B E9 E9 78 FF FF FF 3C 64 74 DD 3C 69 74 D9 3C 6F 74 D5 3C 78 74 D1 3C 58 74 CD BA 01 00 00 00 4C 89 45 90 03 FA 40 02 F2 E9 56 FF FF FF 8A 4C 24 30 BA 01 00 00 00 02 CA 88 4C 24 30 E9 46 FF FF FF 4C 89 45 A0 48 8B 44 24 50 41 8A D8 45 84 E4 75 10 80 38 53 74 08 80 38 43 45 8A E7 75 03 44 8A E2 44 0F B6 30 41 83 CE 20 44 89 75 C0 41 83 FE 6E 74 6C 41 83 FE 63 74 42 41 83 FE 7B 74 3C 48 8B 74 24 68 44 8B 74 24 34 48 8B CE 44 03 F2 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 41 3B C7 74 11 0F B6 C8 E8 ?? ?? ?? ?? BA 01 00 00 00 85 C0 75 D9 44 89 74 24 34 44 8B 75 C0 EB 14 48 8B 4C 24 68 01 54 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 41 3B FF 0F 84 C8 02 00 00 8A 4C 24 30 45 33 C0 8B 44 24 60 8B 74 24 44 85 C0 74 08 85 F6 0F 84 FA 0B 00 00 41 83 FE 6F 0F 8F 23 04 00 00 0F 84 F0 08 00 00 41 83 FE 63 0F 84 E7 03 00 00 41 83 FE 64 0F 84 DC 08 00 00 0F 8E 31 04 00 00 41 83 FE 67 7E 46 41 83 FE 69 74 23 41 83 FE 6E 0F 85 1B 04 00 00 8B 44 24 34 84 C9 0F 84 CA 0A 00 00 4C 8B 64 24 50 44 8B F0 E9 F6 0A 00 00 41 BE 64 00 00 00 B9 01 00 00 00 83 FF 2D 0F 85 29 05 00 00 88 4C 24 40 E9 25 05 00 00 49 8B D8 BE 01 00 00 00 83 FF 2D 75 0C 48 8B 44 24 78 8B DE 40 88 38 EB 05 83 FF 2B 75 29 4C 8B 6C 24 68 44 8B 64 24 44 44 8B 74 24 34 49 8B CD 44 2B E6 44 03 F6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 8B 44 24 60 EB 0F 44 8B 64 24 44 4C 8B 6C 24 68 44 8B 74 24 34 85 C0 40 0F B6 CF 45 0F 44 E7 EB 54 41 8B C4 44 2B E6 85 C0 74 53 48 8B 44 24 78 01 74 24 4C 4C 8D 4D 10 40 88 3C 03 48 8D 45 84 48 03 DE 4C 8D 44 24 78 48 8D 55 B0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 95 01 00 00 49 8B CD 44 03 F6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A3 48 8B 45 C8 48 8B 88 28 01 00 00 48 8B 01 B9 01 00 00 00 40 8A 30 40 3A F7 0F 85 BC 00 00 00 41 8B C4 44 2B E1 85 C0 0F 84 AE 00 00 00 44 03 F1 49 8B CD E8 ?? ?? ?? ?? 4C 8D 4D 10 4C 8D 44 24 78 8B F8 89 44 24 3C 48 8B 44 24 78 40 88 34 03 48 8D 45 84 BE 01 00 00 00 48 03 DE 48 8D 55 B0 48 89 44 24 20 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 84 03 01 00 00 40 0F B6 CF EB 54 41 8B C4 44 2B E6 85 C0 74 53 48 8B 44 24 78 01 74 24 4C 4C 8D 4D 10 40 88 3C 03 48 8D 45 84 48 03 DE 4C 8D 44 24 78 48 8D 55 B0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 BD 00 00 00 49 8B CD 44 03 F6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A3 48 8B CE 8B 74 24 4C 85 F6 0F 84 6F 01 00 00 83 FF 65 74 09 83 FF 45 0F 85 61 01 00 00 41 8B C4 44 2B E1 85 C0 0F 84 53 01 00 00 48 8B 44 24 78 4C 8D 4D 10 4C 8D 44 24 78 C6 04 03 65 48 03 D9 48 8D 45 84 48 8D 55 B0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 47 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 F8 2D 75 7C 48 8B 44 24 78 4C 8D 4D 10 4C 8D 44 24 78 40 88 3C 03 48 8D 45 84 48 FF C3 48 8D 55 B0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 45 33 C0 85 C0 75 53 33 DB B8 01 00 00 00 39 45 84 75 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? 41 3B FF 0F 85 7D 09 00 00 8B 44 24 70 85 C0 75 08 8A 54 24 39 84 D2 74 03 44 8B F8 38 5D E0 0F 84 36 FA FF FF 48 8B 4D D8 83 A1 C8 00 00 00 FD E9 26 FA FF FF 83 F8 2B 75 28 45 33 C0 41 8B C4 B9 01 00 00 00 44 2B E1 85 C0 75 05 45 8B E0 EB 11 44 03 F1 49 8B CD E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 40 0F B6 CF EB 57 41 8B C4 B9 01 00 00 00 44 2B E1 85 C0 74 51 48 8B 44 24 78 03 F1 4C 8D 4D 10 40 88 3C 03 48 03 D9 48 8D 45 84 4C 8D 44 24 78 48 8D 55 B0 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 3F FF FF FF 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A0 B8 01 00 00 00 44 2B F0 44 89 74 24 34 41 3B FF 74 0F 49 8B D5 8B CF E8 ?? ?? ?? ?? B8 01 00 00 00 45 33 C0 85 F6 0F 84 F6 FE FF FF 44 38 44 24 30 75 39 44 8B 6C 24 70 48 8B 74 24 78 44 88 04 33 0F BE 5C 24 38 48 8B 0D ?? ?? ?? ?? 44 03 E8 2B D8 44 89 6C 24 70 FF 15 ?? ?? ?? ?? 48 8B 55 A0 4C 8D 4D C8 4C 8B C6 8B CB FF D0 4C 8B 64 24 50 E9 4E 07 00 00 41 BB 01 00 00 00 85 C0 75 0C 41 03 F3 44 89 5C 24 60 89 74 24 44 45 84 E4 4C 8B 64 24 50 0F 8E 02 03 00 00 41 8A F3 E9 FD 02 00 00 41 83 FE 70 0F 84 B2 04 00 00 41 83 FE 73 0F 84 CE 02 00 00 41 83 FE 75 0F 84 B5 04 00 00 41 83 FE 78 0F 84 0A FC FF FF 41 83 FE 7B 74 37 4C 8B 64 24 50 41 0F B6 04 24 3B C7 0F 85 8D 07 00 00 8A 54 24 39 44 8B 74 24 34 41 02 D7 88 54 24 39 84 C9 0F 85 CA 06 00 00 4C 8B 4D E8 4C 89 4D B8 E9 BD 06 00 00 8B 75 A8 45 84 E4 4C 8B 64 24 50 B8 01 00 00 00 40 0F B6 F6 0F 4F F0 4C 03 E0 41 80 3C 24 5E 75 08 49 FF C4 44 88 7C 24 58 33 D2 48 8D 4D F0 44 8D 42 20 E8 ?? ?? ?? ?? 41 80 3C 24 5D 41 BB 01 00 00 00 0F 85 A0 00 00 00 41 B5 5D 4D 03 E3 C6 45 FB 20 E9 91 00 00 00 4D 03 E3 3C 2D 75 6D 45 84 ED 74 68 41 8A 0C 24 80 F9 5D 74 5F 4D 03 E3 44 3A E9 73 05 44 8A C9 EB 06 45 8A CD 44 8A E9 45 3A E9 73 27 45 0F B6 D5 41 0F B6 CD 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 45 02 EB D2 E2 4D 03 D3 42 08 54 05 F0 45 3A E9 72 DD 41 0F B6 C1 45 0F B6 C1 41 8B D3 83 E0 07 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 F0 45 32 ED EB 1D 44 0F B6 C0 44 8A E8 0F B6 C0 83 E0 07 41 8B D3 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 F0 41 8A 04 24 3C 5D 0F 85 63 FF FF FF 33 DB 3A C3 0F 84 1E FD FF FF E9 94 01 00 00 83 FF 2B 75 16 2B F1 89 74 24 44 0F 85 D4 00 00 00 85 C0 0F 84 CC 00 00 00 8A D9 44 8B 6C 24 34 4C 8B 64 24 68 83 FF 30 75 53 44 03 E9 49 8B CC 44 89 6C 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 3C 78 0F 84 F1 00 00 00 3C 58 0F 84 E9 00 00 00 B8 01 00 00 00 89 44 24 4C 41 83 FE 78 0F 84 AE 00 00 00 45 33 C0 44 39 44 24 60 74 0A 2B F0 89 74 24 44 75 02 02 D8 41 BE 6F 00 00 00 44 8B 64 24 48 45 85 E4 0F 84 DE 03 00 00 48 8B 75 90 84 DB 0F 85 BB 03 00 00 44 8B 6C 24 44 48 8B 5C 24 68 41 83 FE 78 0F 84 15 03 00 00 41 83 FE 70 0F 84 0B 03 00 00 40 0F B6 CF E8 ?? ?? ?? ?? 45 33 C0 85 C0 0F 84 6F 03 00 00 41 83 FE 6F 0F 85 E4 02 00 00 83 FF 38 0F 8D 5C 03 00 00 48 C1 E6 03 E9 15 03 00 00 44 8B 6C 24 34 4C 8B 64 24 68 44 03 E9 49 8B CC 44 89 6C 24 34 E8 ?? ?? ?? ?? 45 33 C0 8B F8 89 44 24 3C 41 8D 48 01 E9 14 FF FF FF 44 2B E8 44 89 6C 24 34 41 3B FF 74 0A 49 8B D4 8B CF E8 ?? ?? ?? ?? BF 30 00 00 00 45 33 C0 89 7C 24 3C E9 44 FF FF FF 41 BE 01 00 00 00 49 8B CC 45 03 EE 44 89 6C 24 34 E8 ?? ?? ?? ?? 45 33 C0 8B F8 89 44 24 3C 44 39 44 24 60 74 0F 83 EE 02 89 74 24 44 41 3B F6 7D 03 41 02 DE 41 BE 78 00 00 00 E9 04 FF FF FF 0F B6 75 A8 45 84 E4 4C 8B 64 24 50 41 BB 01 00 00 00 41 0F 4F F3 EB 03 8B 75 A8 8B 4C 24 34 48 8B 5D A0 41 2B CB 89 4C 24 34 41 3B FF 74 16 48 8B 54 24 68 8B CF E8 ?? ?? ?? ?? 8B 4C 24 34 41 BB 01 00 00 00 44 8B 6C 24 44 45 33 C0 44 39 44 24 60 74 0E 41 8B C5 45 2B EB 85 C0 0F 84 36 01 00 00 41 03 CB 89 4C 24 34 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 63 F8 89 7C 24 3C 41 3B FF 0F 84 F0 00 00 00 41 83 FE 63 74 44 41 83 FE 73 75 13 83 FF 09 7C 09 83 FF 0D 0F 8E D6 00 00 00 83 FF 20 75 2B 41 83 FE 7B 0F 85 C7 00 00 00 48 8B C7 8B D7 48 C1 F8 03 83 E2 07 0F BE 4C 05 F0 0F BE 44 24 58 33 C8 0F A3 D1 0F 83 A6 00 00 00 45 33 C0 44 38 44 24 30 0F 85 86 00 00 00 40 84 F6 74 6B 40 0F B6 CF 40 88 7D 98 E8 ?? ?? ?? ?? 85 C0 74 11 48 8B 4C 24 68 FF 44 24 34 E8 ?? ?? ?? ?? 88 45 99 B8 3F 00 00 00 4C 8D 4D C8 48 8D 55 98 66 89 45 88 48 8B 45 C8 48 8D 4D 88 4C 63 80 0C 01 00 00 E8 ?? ?? ?? ?? 48 8B 45 A0 44 0F B7 5D 88 8B 4C 24 34 66 44 89 18 48 83 C0 02 48 89 45 A0 41 BB 01 00 00 00 E9 FF FE FF FF 48 8B 45 A0 41 BB 01 00 00 00 40 88 38 49 03 C3 48 89 45 A0 EB 09 41 BB 01 00 00 00 49 03 DB 8B 4C 24 34 E9 DA FE FF FF 41 BB 01 00 00 00 44 29 5C 24 34 41 3B FF 74 12 48 8B 54 24 68 8B CF E8 ?? ?? ?? ?? 41 BB 01 00 00 00 45 33 C0 48 8B 45 A0 48 3B D8 0F 84 F9 F9 FF FF 44 38 44 24 30 0F 85 71 02 00 00 44 01 5C 24 70 41 83 FE 63 44 8B 74 24 34 0F 84 7C 02 00 00 40 84 F6 74 09 66 44 89 00 E9 6E 02 00 00 44 88 00 E9 66 02 00 00 44 8B 64 24 48 B9 01 00 00 00 4C 89 45 90 44 03 E1 88 4C 24 38 EB 0A 44 8B 64 24 48 B9 01 00 00 00 83 FF 2D 75 06 88 4C 24 40 EB 09 83 FF 2B 0F 85 FA FC FF FF 2B F1 89 74 24 44 75 0B 85 C0 74 07 8A D9 E9 E7 FC FF FF 01 4C 24 34 48 8B 4C 24 68 E8 ?? ?? ?? ?? 45 33 C0 8B F8 89 44 24 3C E9 CB FC FF FF 48 8D 34 B6 48 03 F6 EB 3A 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 45 33 C0 85 C0 74 66 48 C1 65 90 04 8B CE 40 0F BE DF E8 ?? ?? ?? ?? 48 8B 75 90 8B FB 83 E7 DF 45 33 C0 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C 8D 47 D0 BA 01 00 00 00 01 54 24 4C 48 63 C8 48 03 F1 48 89 75 90 44 39 44 24 60 74 05 44 2B EA 74 36 48 8B 5C 24 68 01 54 24 34 48 8B CB E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 69 FC FF FF FF 4C 24 34 41 3B FF 74 0D 48 8B D3 8B CF E8 ?? ?? ?? ?? 45 33 C0 48 8B 75 90 44 38 44 24 40 0F 84 FE 00 00 00 48 F7 DE 48 89 75 90 E9 F2 00 00 00 8B 74 24 5C 84 DB 0F 85 D9 00 00 00 44 8B 6C 24 44 48 8B 5C 24 68 41 83 FE 78 74 36 41 83 FE 70 74 30 40 0F B6 CF E8 ?? ?? ?? ?? 45 33 C0 85 C0 0F 84 95 00 00 00 41 83 FE 6F 75 0E 83 FF 38 0F 8D 86 00 00 00 C1 E6 03 EB 48 8D 04 B6 8D 34 00 EB 40 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 45 33 C0 85 C0 74 67 8B 44 24 5C 8B CE 40 0F BE DF C1 E0 04 89 44 24 5C E8 ?? ?? ?? ?? 8B 74 24 5C 8B FB 45 33 C0 83 E7 DF 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C B8 01 00 00 00 8D 74 3E D0 01 44 24 4C 89 74 24 5C 44 39 44 24 60 74 05 44 2B E8 74 36 48 8B 5C 24 68 01 44 24 34 48 8B CB E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 4B FF FF FF FF 4C 24 34 41 3B FF 74 0D 48 8B D3 8B CF E8 ?? ?? ?? ?? 45 33 C0 8B 74 24 5C 44 38 44 24 40 74 06 F7 DE 89 74 24 5C 8B 44 24 4C 41 83 FE 46 41 0F 44 C0 85 C0 0F 84 A8 F7 FF FF 44 38 44 24 30 75 1F FF 44 24 70 8B 44 24 5C EB 05 44 8B 64 24 48 48 8B 4D A0 45 85 E4 74 13 48 8B 45 90 48 89 01 4C 8B 64 24 50 44 8B 74 24 34 EB 18 4C 8B 64 24 50 44 8B 74 24 34 44 38 44 24 38 74 04 89 01 EB 03 66 89 01 48 8B 74 24 68 41 BD 01 00 00 00 44 00 6C 24 39 4D 03 E5 4C 89 64 24 50 EB 62 41 38 0C 24 75 0B 49 8D 44 24 01 38 08 4C 0F 44 E0 45 03 F5 48 8B CE 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 41 0F B6 04 24 4D 03 E5 4C 89 64 24 50 3B C7 0F 85 8C 00 00 00 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 74 19 48 8B CE E8 ?? ?? ?? ?? 41 0F B6 0C 24 4D 03 E5 4C 89 64 24 50 3B C8 75 49 41 3B FF 75 17 41 80 3C 24 25 0F 85 D2 F6 FF FF 41 80 7C 24 01 6E 0F 85 C6 F6 FF FF 41 8A 04 24 33 DB 84 C0 0F 84 BA F6 FF FF E9 5C F1 FF FF 41 3B FF 0F 84 AA F6 FF FF 48 8B 54 24 68 8B CF E8 ?? ?? ?? ?? E9 99 F6 FF FF 41 3B C7 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "_mbsnset_s_l"
		size = 703
		refs = "0069 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0086 _strnset_s 00cb _ismbblead_l 01a5 _errno 0233 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 50 45 33 F6 33 F6 4D 8B E1 45 8B F8 48 8B FA 4C 8B E9 44 89 75 48 4D 85 C9 75 15 48 85 C9 75 19 48 85 D2 0F 85 47 02 00 00 33 C0 E9 53 02 00 00 48 85 C9 0F 84 37 02 00 00 48 85 D2 0F 84 2E 02 00 00 48 8B 55 50 48 8D 4D D8 E8 ?? ?? ?? ?? 4C 8B 5D E0 33 C9 41 39 4B 08 75 2D 4D 8B CC 45 8B C7 48 8B D7 49 8B CD E8 ?? ?? ?? ?? 44 8B D8 40 38 75 F0 74 0B 48 8B 45 E8 83 A0 C8 00 00 00 FD 41 8B C3 E9 FB 01 00 00 41 8B C7 49 8B DD C1 E8 08 89 45 D0 84 C0 0F 84 D3 00 00 00 45 84 FF 0F 84 DD 00 00 00 48 8D 55 D8 0F B6 C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 84 C7 00 00 00 41 38 4D 00 74 66 4D 85 E4 74 5D 48 FF CF 74 58 4C 8D 73 01 41 38 0E 0F 84 8A 00 00 00 85 F6 74 04 8B F1 EB 10 0F B6 0B 48 8D 55 D8 E8 ?? ?? ?? ?? 33 C9 8B F0 48 FF CF 8B 45 D0 88 03 49 8B DE 74 26 85 F6 74 04 8B F1 EB 11 41 0F B6 0E 48 8D 55 D8 E8 ?? ?? ?? ?? 33 C9 8B F0 48 FF C3 45 88 3E 49 FF CC 38 0B 75 9E 44 8B 75 48 4D 85 E4 0F 85 D1 00 00 00 85 F6 0F 84 C5 00 00 00 38 0B 0F 84 C1 00 00 00 48 FF CF 0F 84 B4 00 00 00 41 BE 01 00 00 00 38 4B 01 0F 85 98 00 00 00 88 0B 48 FF C7 E9 9B 00 00 00 88 0B 48 FF C7 41 BE 01 00 00 00 EB B8 48 8D 55 D8 41 0F B6 CF E8 ?? ?? ?? ?? 33 C9 85 C0 74 28 41 88 4D 00 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 40 38 75 F0 74 0B 48 8B 4D E8 83 A1 C8 00 00 00 FD 8B C2 E9 D9 00 00 00 41 38 4D 00 0F 84 73 FF FF FF 4D 85 E4 0F 84 73 FF FF FF 48 FF CF 0F 84 61 FF FF FF 85 F6 74 04 8B F1 EB 10 0F B6 0B 48 8D 55 D8 E8 ?? ?? ?? ?? 33 C9 8B F0 44 88 3B 48 FF C3 49 FF CC 38 0B 75 C9 E9 37 FF FF FF C6 03 20 EB 05 48 FF CF 74 07 48 FF C3 38 0B 75 F4 48 85 FF 75 26 41 88 4D 00 E8 ?? ?? ?? ?? 8D 5F 16 89 18 E8 ?? ?? ?? ?? 40 38 7D F0 74 62 48 8B 4D E8 83 A1 C8 00 00 00 FD EB 55 45 85 F6 74 26 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 80 7D F0 00 0F 84 5C FF FF FF 48 8B 45 E8 83 A0 C8 00 00 00 FD E9 4C FF FF FF 38 4D F0 0F 84 C9 FD FF FF 48 8B 45 E8 83 A0 C8 00 00 00 FD E9 B9 FD FF FF E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 4C 8D 5C 24 50 49 8B 5B 30 49 8B 73 38 49 8B 7B 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_fgetchar"
		size = 21
		refs = "0005 __iob_func 0011 getc"
		altNames = "getchar"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_735_178_0 {
	meta:
		name = "?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UEAAPEAVScheduleGroup@3@XZ"
		size = 21
		refs = "0005 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QEAAPEAVSchedulingRing@23@XZ 0011 ?CreateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_37_0 {
	meta:
		name = "?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ"
		size = 21
		refs = "0005 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPEAXXZ 0011 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "_fgetwchar"
		size = 21
		refs = "0005 __iob_func 0011 fgetwc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_701_1_0 {
	meta:
		name = "getwchar"
		size = 21
		refs = "0005 __iob_func 0011 fgetwc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_2_0 {
	meta:
		name = "_ungetch_nolock"
		size = 25
		refs = "0009 chbuf"
	strings:
		$1 = { 83 C8 FF 3B C8 74 11 39 05 ?? ?? ?? ?? 75 09 0F B6 C1 89 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_68_3_0 {
	meta:
		name = "_getextendedkeycode"
		size = 172
		refs = "0013 EnhancedKeys 0069 NormalKeys"
	strings:
		$1 = { 44 8B 41 0C 41 0F BA E0 08 73 57 44 0F B7 49 08 4C 8D 15 ?? ?? ?? ?? 33 D2 49 8B CA 8B C2 66 44 39 09 74 0D FF C2 48 83 C1 0A 83 FA 0C 72 EF F3 C3 48 63 C2 48 8D 0C 80 41 F6 C0 03 74 06 49 8D 44 4A 08 C3 41 F6 C0 0C 74 06 49 8D 44 4A 06 C3 41 F6 C0 10 74 06 49 8D 44 4A 04 C3 49 8D 44 4A 02 C3 0F B7 41 08 48 8D 0D ?? ?? ?? ?? 41 F6 C0 03 74 07 48 8D 44 C1 06 EB 1E 41 F6 C0 0C 74 07 48 8D 44 C1 04 EB 11 41 F6 C0 10 74 07 48 8D 44 C1 02 EB 04 48 8D 04 C1 33 D2 38 10 74 05 80 38 E0 75 05 38 50 01 75 03 48 8B C2 C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "_getch_nolock"
		size = 256
		refs = "000d __security_cookie 001b chbuf 0036 _coninpfh 0041 __initconin 0060 __imp_GetConsoleMode 006f __imp_SetConsoleMode 008e __imp_ReadConsoleInputA 00ba _getextendedkeycode 00f1 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 56 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 8B 05 ?? ?? ?? ?? 83 F8 FF 74 0F 83 0D ?? ?? ?? ?? FF 0F B6 C0 E9 B5 00 00 00 48 8B 0D ?? ?? ?? ?? 48 83 F9 FE 75 0C E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 F9 FF 75 07 0B C1 E9 8F 00 00 00 48 8D 54 24 24 FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 33 D2 FF 15 ?? ?? ?? ?? BE 01 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 8D 4C 24 20 48 8D 54 24 28 44 8B C6 FF 15 ?? ?? ?? ?? 85 C0 74 3C 83 7C 24 20 00 74 35 66 39 74 24 28 75 D4 83 7C 24 2C 00 74 CD 0F B6 5C 24 36 85 DB 75 21 48 8D 4C 24 2C E8 ?? ?? ?? ?? 48 85 C0 74 B5 0F B6 18 0F B6 40 01 89 05 ?? ?? ?? ?? EB 03 83 CB FF 8B 54 24 24 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C3 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 83 C4 50 5E C3 }
	condition:
		$1
}

rule file_68_5_0 {
	meta:
		name = "_getche_nolock"
		size = 66
		refs = "0008 chbuf 001e _getch_nolock 002c _putch_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 05 ?? ?? ?? ?? 83 F8 FF 74 0C 83 0D ?? ?? ?? ?? FF 0F B6 C0 EB 1F E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 10 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 04 8B C3 EB 03 83 C8 FF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_68_6_0 {
	meta:
		name = "_kbhit_nolock"
		size = 414
		refs = "001e __security_cookie 002e chbuf 0042 _coninpfh 004d __initconin 0068 __imp_GetNumberOfConsoleInputEvents 00bb __chkstk 00d9 malloc 010e __imp_PeekConsoleInputA 0148 _getextendedkeycode 0171 free 0184 __security_check_cookie"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8D 6C 24 20 48 89 5D 20 48 89 75 28 48 89 7D 30 4C 89 65 38 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 08 45 33 E4 83 3D ?? ?? ?? ?? FF 74 0A 41 8D 44 24 01 E9 3D 01 00 00 48 8B 0D ?? ?? ?? ?? 48 83 F9 FE 75 0C E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 F9 FF 0F 84 18 01 00 00 48 8D 55 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 06 01 00 00 8B 7D 00 85 FF 0F 84 FB 00 00 00 33 D2 48 8D 42 E0 48 F7 F7 48 83 F8 14 72 66 48 8D 04 BF 48 8D 0C 85 10 00 00 00 48 81 F9 00 04 00 00 77 35 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 20 48 85 DB 0F 84 AA 00 00 00 C7 03 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 11 C7 00 DD DD 00 00 8B 7D 00 48 83 C3 10 EB 02 33 DB 48 85 DB 74 7F 48 8B 0D ?? ?? ?? ?? 4C 8D 4D 04 44 8B C7 48 8B D3 FF 15 ?? ?? ?? ?? 85 C0 74 4E 44 8B 5D 04 45 85 DB 74 45 44 3B 5D 00 77 3F 45 85 DB 74 3A 48 8D 73 04 BF 01 00 00 00 66 39 7E FC 75 1B 83 3E 00 74 16 80 7E 0A 00 75 0D 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 74 03 44 8B E7 41 FF CB 48 83 C6 14 44 89 5D 04 45 85 DB 75 CF 48 8D 4B F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 41 8B C4 EB 02 33 C0 48 8B 4D 08 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 20 48 8B 75 28 48 8B 7D 30 4C 8B 65 38 48 8D 65 10 5D C3 }
	condition:
		$1
}

rule file_68_7_0 {
	meta:
		name = "_ungetch"
		size = 46
		refs = "000e _lock 0016 _ungetch_nolock 0022 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 8B CB E8 ?? ?? ?? ?? 8B D8 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_412_1_0 {
	meta:
		name = "_putch"
		size = 46
		refs = "000e _lock 0016 _putch_nolock 0022 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 8B CB E8 ?? ?? ?? ?? 8B D8 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_68_8_0 {
	meta:
		name = "_ungetch$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_cgets_s$fin$0 _cputs$fin$0 _getch$fin$0 _getche$fin$0 _getwch$fin$0 _getwche$fin$0 _kbhit$fin$0 _putch$fin$0 _putwch$fin$0 _ungetwch$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 03 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_68_9_0 {
	meta:
		name = "_getch"
		size = 42
		refs = "000c _lock 0012 _getch_nolock 001e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 8B D8 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_68_11_0 {
	meta:
		name = "_getche"
		size = 42
		refs = "000c _lock 0012 _getche_nolock 001e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 8B D8 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_68_13_0 {
	meta:
		name = "_kbhit"
		size = 42
		refs = "000c _lock 0012 _kbhit_nolock 001e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 8B D8 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "_strcoll_l"
		size = 204
		refs = "0020 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002a _errno 0035 _invalid_parameter_noinfo 0068 strcmp 0093 __crtCompareStringA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 55 48 8B EC 48 83 EC 60 48 8B F9 48 8B DA 48 8D 4D E0 49 8B D0 E8 ?? ?? ?? ?? 48 85 FF 75 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 FF FF FF 7F EB 6B 48 85 DB 74 D3 48 8B 45 E0 8B 50 10 85 D2 75 0D 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 3D 8B 40 08 48 8D 4D E0 4C 8B CF 89 44 24 38 83 C8 FF 41 B8 00 10 00 00 89 44 24 30 48 89 5C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 91 83 C0 FE 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 48 8B 5C 24 70 48 8B 7C 24 78 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "?strncnt@@YAHPEBDH@Z"
		size = 28
	strings:
		$1 = { 8B C2 85 D2 74 0E FF C8 80 39 00 74 09 48 FF C1 85 C0 75 F2 FF C8 2B D0 8D 42 FF C3 }
	condition:
		$1
}

rule file_70_6_0 {
	meta:
		name = "?__crtCompareStringA_stat@@YAHPEAUlocaleinfo_struct@@KKPEBDH1HH@Z"
		size = 836
		refs = "0019 __security_cookie 00f5 __imp_GetCPInfo 0174 __imp_MultiByteToWideChar 01bd __chkstk 01dd malloc 02fc __imp_CompareStringW 030f free 032f __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 83 EC 68 48 8D 6C 24 30 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 28 8B BD A0 00 00 00 4C 8B A5 A8 00 00 00 33 DB 44 89 45 04 4D 8B E9 89 55 00 4C 8B C1 4C 89 65 08 41 BF 01 00 00 00 85 FF 7E 43 8B D7 49 8B C1 41 2B D7 83 C9 FF 38 18 74 09 49 03 C7 85 D2 75 EF 8B D1 8B C1 2B C2 03 F8 8B B5 B0 00 00 00 85 F6 7E 29 8B C6 49 8B D4 41 2B C7 38 1A 74 09 49 03 D7 85 C0 75 F2 8B C1 2B C8 03 F1 EB 12 83 C9 FF 3B F9 7D D4 33 C0 E9 88 02 00 00 3B F1 7C F5 44 8B B5 B8 00 00 00 45 85 F6 75 07 49 8B 00 44 8B 70 04 85 FF 74 08 85 F6 0F 85 99 00 00 00 3B FE 75 0A B8 02 00 00 00 E9 57 02 00 00 41 3B F7 7E 08 41 8B C7 E9 4A 02 00 00 41 3B FF 7E 0A B8 03 00 00 00 E9 3B 02 00 00 48 8D 55 10 41 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 9B 85 FF 7E 29 83 7D 10 02 72 DB 38 5D 16 48 8D 45 16 74 D2 38 58 01 74 CD 41 8A 4D 00 3A 08 72 05 3A 48 01 76 A4 48 83 C0 02 38 18 EB E4 85 F6 7E 2D 83 7D 10 02 72 A1 38 5D 16 48 8D 45 16 74 98 38 58 01 74 93 41 8A 0C 24 3A 08 72 09 3A 48 01 0F 86 73 FF FF FF 48 83 C0 02 38 18 EB E0 44 8B CF 4D 8B C5 BA 09 00 00 00 41 8B CE 89 5C 24 28 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 4C 63 F8 85 C0 0F 84 15 FF FF FF 49 B8 F0 FF FF FF FF FF FF 0F 7E 66 33 D2 48 8D 42 E0 49 F7 F7 48 83 F8 02 72 57 4B 8D 4C 3F 10 48 81 F9 00 04 00 00 77 30 48 8D 41 0F 48 3B C1 77 03 49 8B C0 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 4C 8D 64 24 30 4D 85 E4 0F 84 C6 FE FF FF 41 C7 04 24 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 74 0F C7 00 DD DD 00 00 49 83 C4 10 EB 03 4C 8B E3 4D 85 E4 0F 84 97 FE FF FF 44 8B CF 4D 8B C5 BA 01 00 00 00 41 8B CE 44 89 7C 24 28 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EC 00 00 00 4C 8B 45 08 44 8B CE BA 09 00 00 00 41 8B CE 89 5C 24 28 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 4C 63 E8 85 C0 0F 84 C3 00 00 00 7E 67 33 D2 48 8D 42 E0 49 F7 F5 48 83 F8 02 72 58 4B 8D 4C 2D 10 48 81 F9 00 04 00 00 77 31 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 30 48 85 FF 74 7B C7 07 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0F C7 00 DD DD 00 00 48 83 C7 10 EB 03 48 8B FB 48 85 FF 74 52 4C 8B 45 08 44 8B CE BA 01 00 00 00 41 8B CE 44 89 6C 24 28 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 1E 8B 55 04 8B 4D 00 45 8B CF 4D 8B C4 44 89 6C 24 28 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 8B D8 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 49 8D 4C 24 F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 28 48 33 CD E8 ?? ?? ?? ?? 48 8D 65 38 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_70_7_0 {
	meta:
		name = "__crtCompareStringA"
		size = 137
		refs = "0020 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0062 ?__crtCompareStringA_stat@@YAHPEAUlocaleinfo_struct@@KKPEBDH1HH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 60 8B F2 48 8B D1 48 8D 4C 24 40 49 8B D9 41 8B F8 E8 ?? ?? ?? ?? 44 8B 9C 24 A8 00 00 00 8B 84 24 A0 00 00 00 48 8D 4C 24 40 44 89 5C 24 38 89 44 24 30 48 8B 84 24 98 00 00 00 48 89 44 24 28 8B 84 24 90 00 00 00 4C 8B CB 44 8B C7 8B D6 89 44 24 20 E8 ?? ?? ?? ?? 80 7C 24 58 00 74 0C 48 8B 4C 24 50 83 A1 C8 00 00 00 FD 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "store_dt"
		size = 50
	strings:
		$1 = { 44 8B C2 B8 67 66 66 66 F7 EA C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 42 30 88 01 8A C2 C0 E2 02 02 C2 02 C0 44 2A C0 48 8D 41 02 41 80 C0 30 44 88 41 01 C3 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "asctime_s"
		size = 773
		refs = "00a9 __ImageBase 00b1 _days 0145 __mnames 0160 __dnames 02ed _errno 02f9 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 4D 8B C8 4C 8B D1 48 85 C9 0F 84 D7 02 00 00 48 85 D2 0F 84 CE 02 00 00 C6 01 00 48 83 FA 1A 0F 82 C1 02 00 00 4D 85 C0 0F 84 B8 02 00 00 41 8B 50 14 85 D2 0F 88 AC 02 00 00 45 8B 40 10 45 85 C0 0F 88 9F 02 00 00 41 83 F8 0B 0F 8F 95 02 00 00 41 83 79 08 00 0F 8C 8A 02 00 00 41 83 79 08 17 0F 8F 7F 02 00 00 41 83 79 04 00 0F 8C 74 02 00 00 41 83 79 04 3B 0F 8F 69 02 00 00 41 83 39 00 0F 8C 5F 02 00 00 41 83 39 3B 0F 8F 55 02 00 00 41 83 79 0C 01 0F 8C 4A 02 00 00 49 63 49 10 4C 8D 1D ?? ?? ?? ?? 41 8B 84 8B ?? ?? ?? ?? 41 2B 84 8B ?? ?? ?? ?? 41 3B 41 0C 7D 66 8D 8A 6C 07 00 00 8B C1 25 03 00 00 80 7D 07 FF C8 83 C8 FC FF C0 85 C0 75 18 B8 1F 85 EB 51 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B D2 64 3B CA 75 1F B8 1F 85 EB 51 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 D2 90 01 00 00 3B CA 0F 85 D8 01 00 00 41 83 F8 01 0F 85 CE 01 00 00 41 83 79 0C 1D 0F 8F C3 01 00 00 41 8B 41 18 85 C0 0F 88 B7 01 00 00 83 F8 06 0F 8F AE 01 00 00 43 8D 0C 40 4C 8D 05 ?? ?? ?? ?? 8D 04 40 48 63 D0 48 63 C1 48 2B D0 4A 8D 0C 00 49 2B D0 4E 8D 9C 1A ?? ?? ?? ?? 49 8B D2 48 2B D0 49 2B D0 41 B8 03 00 00 00 41 8A 04 0B 41 88 02 8A 01 48 FF C1 88 44 0A 03 49 FF C2 49 FF C8 75 E8 41 C6 02 20 41 C6 42 04 20 41 8B 49 0C B3 30 41 BB 67 66 66 66 41 8B C3 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 13 41 88 42 05 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C3 02 CB 41 88 4A 06 41 C6 42 07 20 41 8B 49 08 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 13 41 88 42 08 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C3 02 CB 41 88 4A 09 41 C6 42 0A 3A 41 8B 49 04 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 13 41 88 42 0B 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C3 02 CB 41 88 4A 0C 41 C6 42 0D 3A 41 8B 09 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 13 41 88 42 0E 8A C2 C0 E2 02 02 C2 02 C0 2A C8 B8 1F 85 EB 51 02 CB 41 88 4A 0F 41 C6 42 10 20 41 F7 69 14 C1 FA 05 8B C2 C1 E8 1F 44 8D 44 02 13 41 8B C3 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 B8 1F 85 EB 51 8D 0C 13 41 88 4A 11 8A CA C0 E2 02 02 CA 02 C9 44 2A C1 44 02 C3 45 88 42 12 45 8B 41 14 41 F7 E8 C1 FA 05 41 8B C3 8B CA C1 E9 1F 03 D1 6B D2 64 44 2B C2 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 13 41 88 42 13 8A C2 C0 E2 02 02 C2 02 C0 44 2A C0 44 02 C3 33 C0 45 88 42 14 66 41 C7 42 15 0A 00 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_72_2_0 {
	meta:
		name = "asctime"
		size = 810
		refs = "0015 buf 001a _getptd_noexit 0036 _calloc_crt 00c8 __ImageBase 00d8 _days 0163 __mnames 017e __dnames 0309 _errno 0314 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 48 8D 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 21 48 83 78 68 00 75 16 BA 01 00 00 00 8D 4A 19 E8 ?? ?? ?? ?? 48 89 46 68 48 85 C0 74 04 48 8B 7E 68 4C 8B CF 48 85 FF 0F 84 B5 02 00 00 C6 07 00 48 85 DB 0F 84 A9 02 00 00 8B 53 14 85 D2 0F 88 9E 02 00 00 44 8B 43 10 45 85 C0 0F 88 91 02 00 00 41 83 F8 0B 0F 8F 87 02 00 00 83 7B 08 00 0F 8C 7D 02 00 00 83 7B 08 17 0F 8F 73 02 00 00 83 7B 04 00 0F 8C 69 02 00 00 83 7B 04 3B 0F 8F 5F 02 00 00 83 3B 00 0F 8C 56 02 00 00 83 3B 3B 0F 8F 4D 02 00 00 83 7B 0C 01 0F 8C 43 02 00 00 4C 8D 15 ?? ?? ?? ?? 49 63 C8 BE 1F 85 EB 51 41 8B 84 8A ?? ?? ?? ?? 41 2B 84 8A ?? ?? ?? ?? 3B 43 0C 7D 5F 8D 8A 6C 07 00 00 8B C1 25 03 00 00 80 7D 07 FF C8 83 C8 FC FF C0 85 C0 75 15 8B C6 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B D2 64 3B CA 75 1C 8B C6 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 D2 90 01 00 00 3B CA 0F 85 D4 01 00 00 41 83 F8 01 0F 85 CA 01 00 00 83 7B 0C 1D 0F 8F C0 01 00 00 8B 43 18 85 C0 0F 88 B5 01 00 00 83 F8 06 0F 8F AC 01 00 00 43 8D 0C 40 4C 8D 05 ?? ?? ?? ?? 8D 04 40 48 63 D0 48 63 C1 48 2B D0 4A 8D 0C 00 49 2B D0 4E 8D 94 12 ?? ?? ?? ?? 48 8B D7 48 2B D0 49 2B D0 41 B8 03 00 00 00 41 8A 04 0A 41 88 01 8A 01 48 FF C1 88 44 0A 03 49 FF C1 49 FF C8 75 E8 41 C6 01 20 41 C6 41 04 20 8B 4B 0C 41 B3 30 41 BA 67 66 66 66 41 8B C2 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 41 88 41 05 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C2 41 02 CB 41 88 49 06 41 C6 41 07 20 8B 4B 08 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 41 88 41 08 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C2 41 02 CB 41 88 49 09 41 C6 41 0A 3A 8B 4B 04 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 41 88 41 0B 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C2 41 02 CB 41 88 49 0C 41 C6 41 0D 3A 8B 0B F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 41 88 41 0E 8A C2 C0 E2 02 02 C2 02 C0 2A C8 8B C6 41 02 CB 41 88 49 0F 41 C6 41 10 20 F7 6B 14 C1 FA 05 8B C2 C1 E8 1F 8D 4C 02 13 41 8B C2 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 41 88 41 11 8A C2 C0 E2 02 02 C2 02 C0 2A C8 8B C6 41 02 CB 41 88 49 12 44 8B 43 14 41 F7 E8 C1 FA 05 8B C2 C1 E8 1F 03 D0 41 8B C2 6B D2 64 44 2B C2 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 8A CA 41 8D 04 13 C0 E2 02 41 88 41 13 02 CA 48 8B C7 02 C9 44 2A C1 45 02 C3 45 88 41 14 66 41 C7 41 15 0A 00 EB 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_wspawnle"
		size = 191
		refs = "0025 _errno 0030 _invalid_parameter_noinfo 006b _wcapture_argv 0092 _wspawnve 00ac free"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 55 56 57 48 81 EC 38 02 00 00 33 ED 49 8B C0 48 8B DA 8B F1 48 85 D2 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 79 66 39 2A 74 E5 48 85 C0 74 E0 66 41 39 28 74 DA 48 8D 8C 24 78 02 00 00 4C 8D 44 24 30 41 B9 40 00 00 00 48 89 4C 24 20 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 4C 8B 4C 24 20 48 8B D3 49 83 C1 08 4C 8B C0 8B CE 4C 89 4C 24 20 4D 8B 49 F8 48 8B F8 48 89 6C 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 38 02 00 00 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_wspawnlpe"
		size = 191
		refs = "0025 _errno 0030 _invalid_parameter_noinfo 006b _wcapture_argv 0092 _wspawnvpe 00ac free"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 55 56 57 48 81 EC 38 02 00 00 33 ED 49 8B C0 48 8B DA 8B F1 48 85 D2 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 79 66 39 2A 74 E5 48 85 C0 74 E0 66 41 39 28 74 DA 48 8D 8C 24 78 02 00 00 4C 8D 44 24 30 41 B9 40 00 00 00 48 89 4C 24 20 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 4C 8B 4C 24 20 48 8B D3 49 83 C1 08 4C 8B C0 8B CE 4C 89 4C 24 20 4D 8B 49 F8 48 8B F8 48 89 6C 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 38 02 00 00 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "_fptostr"
		size = 204
		refs = "001a _errno 0026 _invalid_parameter_noinfo 00ab strlen 00bb memmove"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 4D 8B 51 10 45 33 DB 48 8B D9 48 85 C9 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 90 00 00 00 48 85 D2 74 E3 41 8B C3 45 85 C0 44 88 19 41 0F 4F C0 FF C0 48 98 48 3B D0 77 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB CB C6 01 30 48 8D 41 01 EB 1B 45 38 1A 74 09 41 0F BE 0A 49 FF C2 EB 05 B9 30 00 00 00 88 08 48 FF C0 41 FF C8 45 85 C0 7F E0 44 88 18 78 15 41 80 3A 35 7C 0F EB 03 C6 00 30 48 FF C8 80 38 39 74 F5 FE 00 80 3B 31 75 06 41 FF 41 04 EB 19 48 8D 4B 01 E8 ?? ?? ?? ?? 48 8D 53 01 48 8B CB 4C 8D 40 01 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "memcmp"
		size = 199
	strings:
		$1 = { 48 2B D1 49 83 F8 08 72 22 F6 C1 07 74 14 66 90 8A 01 3A 04 0A 75 2C 48 FF C1 49 FF C8 F6 C1 07 75 EE 4D 8B C8 49 C1 E9 03 75 1F 4D 85 C0 74 0F 8A 01 3A 04 0A 75 0C 48 FF C1 49 FF C8 75 F1 48 33 C0 C3 1B C0 83 D8 FF C3 90 49 C1 E9 02 74 37 48 8B 01 48 3B 04 0A 75 5B 48 8B 41 08 48 3B 44 0A 08 75 4C 48 8B 41 10 48 3B 44 0A 10 75 3D 48 8B 41 18 48 3B 44 0A 18 75 2E 48 83 C1 20 49 FF C9 75 CD 49 83 E0 1F 4D 8B C8 49 C1 E9 03 74 9B 48 8B 01 48 3B 04 0A 75 1B 48 83 C1 08 49 FF C9 75 EE 49 83 E0 07 EB 83 48 83 C1 08 48 83 C1 08 48 83 C1 08 48 8B 0C 11 48 0F C8 48 0F C9 48 3B C1 1B C0 83 D8 FF C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_wmktemp_s"
		size = 333
		refs = "0035 wcsnlen 0046 __threadid 00c6 _errno 00da _waccess_s 012c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 45 33 E4 48 8B F2 48 8B D9 48 85 C9 0F 84 F4 00 00 00 48 85 D2 0F 84 EB 00 00 00 E8 ?? ?? ?? ?? 48 8B E8 48 3B C6 0F 83 D6 00 00 00 E8 ?? ?? ?? ?? 48 8D 7C 6B FE 44 8B D8 48 83 FD 06 0F 82 BF 00 00 00 48 3B F5 0F 86 B6 00 00 00 45 8B C4 EB 3F 66 83 3F 58 0F 85 A7 00 00 00 49 83 F8 05 73 34 B8 CD CC CC CC 49 FF C0 41 F7 E3 C1 EA 03 0F B7 C2 66 C1 E0 02 8D 0C 10 66 03 C9 66 44 2B D9 66 41 83 C3 30 66 44 89 1F 44 8B DA 48 83 EF 02 48 3B FB 73 BC 66 83 3F 58 75 67 49 83 F8 05 72 61 B8 61 00 00 00 66 89 07 8D 70 01 E8 ?? ?? ?? ?? 8B 28 E8 ?? ?? ?? ?? 33 D2 48 8B CB 44 89 20 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 0C 83 FE 7B 74 12 66 89 37 FF C6 EB D4 E8 ?? ?? ?? ?? 89 28 33 C0 EB 2F 66 44 89 23 E8 ?? ?? ?? ?? C7 00 11 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 17 66 44 89 23 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "_wmktemp"
		size = 77
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 0029 wcslen 0035 _wmktemp_s"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 1A E8 ?? ?? ?? ?? 48 8B CB 48 8D 50 01 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "_mktemp"
		size = 77
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 0029 strlen 0035 _mktemp_s"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 1A E8 ?? ?? ?? ?? 48 8B CB 48 8D 50 01 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_79_9_0 {
	meta:
		name = "_input_s_l"
		size = 4459
		refs = "0022 __security_cookie 0077 _errno 0082 _invalid_parameter_noinfo 009e _fileno 00a5 __badioinfo 00ac __pioinfo 0121 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0149 isspace 0160 _inc 017d _ungetc_nolock 01f9 isdigit 0598 __check_float_string 0749 free 0861 _cfltcvt_tab 0869 __imp_DecodePointer 092e memset 0c87 isleadbyte 0cc1 _mbtowc_l 0df8 isxdigit 114c __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 80 FE FF FF 48 81 EC 80 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 70 01 00 00 45 33 F6 4C 8D 6D 10 4C 89 4D B8 49 8B D8 48 8B F2 48 89 54 24 70 4C 89 6C 24 78 4C 8B E1 48 89 4C 24 60 48 C7 45 A8 5E 01 00 00 44 89 75 88 66 44 89 75 80 41 8B FE 44 89 74 24 3C 44 89 74 24 44 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B3 10 00 00 48 85 C9 74 E3 41 83 CF FF F6 41 18 40 75 7C E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 41 3B C7 74 1D 83 F8 FE 74 18 4C 63 C0 49 8B C8 41 83 E0 1F 48 C1 F9 05 4D 6B C0 58 4D 03 04 C9 EB 03 4C 8B C2 41 F6 40 38 7F 75 25 41 3B C7 74 1A 83 F8 FE 74 15 48 63 D0 48 8B C2 83 E2 1F 48 C1 F8 05 48 6B D2 58 49 03 14 C1 F6 42 38 80 74 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 41 8B C7 E9 28 10 00 00 48 8D 4D D0 48 8B D3 E8 ?? ?? ?? ?? 8A 06 33 C9 44 88 74 24 39 44 89 74 24 34 8B D9 89 4C 24 68 84 C0 0F 84 EE 0F 00 00 44 8D 69 01 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 50 45 2B F5 45 03 F5 49 8B CC 44 89 74 24 34 E8 ?? ?? ?? ?? 8B D8 41 3B C7 74 16 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 DD 49 8B D4 8B CB E8 ?? ?? ?? ?? 49 03 F5 0F B6 0E E8 ?? ?? ?? ?? 85 C0 75 F1 4C 8B 64 24 60 48 89 74 24 70 33 DB E9 A9 0E 00 00 B1 25 38 0E 0F 85 36 0E 00 00 38 4E 01 0F 84 1F 0E 00 00 4C 8B 74 24 70 BA 01 00 00 00 89 5C 24 5C 88 54 24 38 88 5D 84 89 5C 24 58 89 5C 24 50 44 8B EB 48 89 5D C0 88 5C 24 54 88 5C 24 40 88 5C 24 30 40 8A F3 88 5D A4 44 8A E3 8B FB 4C 03 F2 41 0F B6 1E 8B CB E8 ?? ?? ?? ?? 45 33 C9 85 C0 74 14 43 8D 44 AD 00 41 8D 51 01 01 54 24 50 44 8D 6C 43 D0 EB 66 83 FB 2A 0F 84 07 01 00 00 83 FB 46 74 53 83 FB 49 0F 84 9F 00 00 00 83 FB 4C 0F 84 8B 00 00 00 83 FB 4E 74 3C 83 FB 68 74 2F BA 01 00 00 00 83 FB 6C 74 0A 83 FB 77 74 1B E9 CA 00 00 00 41 80 7E 01 6C 75 0B 49 FF C6 03 FA 4C 89 4D 90 EB 16 00 54 24 38 44 02 E2 EB 0D 44 00 7C 24 38 45 02 E7 BA 01 00 00 00 8A 4C 24 30 40 84 F6 0F 84 64 FF FF FF 89 7C 24 4C 8B 7C 24 3C 4C 89 74 24 70 44 8A 75 84 44 89 6C 24 48 84 C9 0F 85 93 00 00 00 48 8B 45 B8 48 89 45 B0 48 83 C0 08 48 89 45 B8 48 8B 40 F8 48 89 45 98 EB 7D BA 01 00 00 00 00 54 24 38 EB B0 41 8A 46 01 3C 36 75 16 49 8D 4E 02 80 39 34 75 0D 4C 8B F1 BA 01 00 00 00 E9 74 FF FF FF 3C 33 75 11 49 8D 4E 02 80 39 32 75 08 4C 8B F1 E9 78 FF FF FF 3C 64 74 DD 3C 69 74 D9 3C 6F 74 D5 3C 78 74 D1 3C 58 74 CD BA 01 00 00 00 4C 89 4D 90 03 FA 40 02 F2 E9 56 FF FF FF 8A 4C 24 30 BA 01 00 00 00 02 CA 88 4C 24 30 E9 46 FF FF FF 4C 89 4D 98 4C 8B 54 24 70 41 8A D9 45 84 E4 75 12 41 80 3A 53 74 09 41 80 3A 43 45 8A E7 75 03 44 8A E2 45 0F B6 2A 41 83 CD 20 44 89 6D C8 41 83 FD 6E 74 71 41 83 FD 63 74 42 41 83 FD 7B 74 3C 48 8B 74 24 60 44 8B 6C 24 34 48 8B CE 44 03 EA E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 41 3B C7 74 11 0F B6 C8 E8 ?? ?? ?? ?? BA 01 00 00 00 85 C0 75 D9 44 89 6C 24 34 44 8B 6D C8 EB 14 48 8B 4C 24 60 01 54 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 41 3B FF 0F 84 5F 03 00 00 4C 8B 54 24 70 8A 4C 24 30 45 33 C9 8B 44 24 50 8B 74 24 48 85 C0 74 08 85 F6 0F 84 63 0C 00 00 84 C9 75 4F 41 83 FD 63 74 0C 41 83 FD 73 74 06 41 83 FD 7B 75 3D 48 8B 45 B0 BA 01 00 00 00 48 8B 08 48 83 C0 08 4C 8B C0 48 89 45 B0 48 83 C0 08 48 89 45 B8 8B 40 F8 48 89 4D 98 48 89 45 C0 48 3B C2 0F 82 34 0C 00 00 8B 44 24 50 8A 4C 24 30 EB 09 4C 8B 45 B0 BA 01 00 00 00 41 83 FD 6F 0F 8F 44 04 00 00 0F 84 3E 09 00 00 41 83 FD 63 0F 84 15 04 00 00 41 83 FD 64 0F 84 2A 09 00 00 0F 8E 52 04 00 00 41 83 FD 67 7E 76 41 83 FD 69 74 58 41 83 FD 6E 0F 85 3C 04 00 00 44 8B 74 24 34 41 8B C6 84 C9 75 1E 44 8B 74 24 4C 48 8B 4D 98 45 85 F6 0F 84 08 0B 00 00 48 8B 45 90 48 89 01 44 8B 74 24 34 48 8B 74 24 70 4C 8B 64 24 60 41 BD 01 00 00 00 44 00 6C 24 39 49 03 F5 33 DB 48 89 74 24 70 E9 52 0B 00 00 41 BD 64 00 00 00 83 FF 2D 0F 85 24 05 00 00 88 54 24 40 E9 20 05 00 00 49 8B D9 83 FF 2D 75 0D 48 8B 44 24 78 48 8B DA 40 88 38 EB 05 83 FF 2B 75 28 4C 8B 6C 24 60 44 8B 64 24 48 44 8B 74 24 34 49 8B CD 44 2B E2 44 03 F2 E8 ?? ?? ?? ?? 45 33 C9 8B F8 89 44 24 3C EB 0F 44 8B 64 24 48 4C 8B 6C 24 60 44 8B 74 24 34 44 39 4C 24 50 40 0F B6 CF 45 0F 44 E7 E8 ?? ?? ?? ?? 33 F6 EB 5E 41 8B C4 B9 01 00 00 00 44 2B E1 85 C0 74 53 48 8B 44 24 78 01 4C 24 58 4C 8D 4D 10 40 88 3C 03 48 03 D9 48 8D 45 88 4C 8D 44 24 78 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 91 01 00 00 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 0F B6 C8 8B F8 89 44 24 3C E8 ?? ?? ?? ?? 85 C0 75 9E 48 8B 45 D0 48 8B 88 28 01 00 00 48 8B 01 B9 01 00 00 00 40 8A 30 40 3A F7 0F 85 B9 00 00 00 41 8B C4 44 2B E1 85 C0 0F 84 AB 00 00 00 44 03 F1 49 8B CD E8 ?? ?? ?? ?? 4C 8D 4D 10 4C 8D 44 24 78 8B F8 89 44 24 3C 48 8B 44 24 78 40 88 34 03 48 8D 45 88 48 FF C3 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 04 01 00 00 40 0F B6 CF E8 ?? ?? ?? ?? B9 01 00 00 00 85 C0 74 56 41 8B C4 44 2B E1 85 C0 74 4C 48 8B 44 24 78 01 4C 24 58 4C 8D 4D 10 40 88 3C 03 48 03 D9 48 8D 45 88 4C 8D 44 24 78 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 B2 00 00 00 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 EB 9C 8B 74 24 58 85 F6 0F 84 70 01 00 00 83 FF 65 74 09 83 FF 45 0F 85 62 01 00 00 41 8B C4 44 2B E1 85 C0 0F 84 54 01 00 00 48 8B 44 24 78 4C 8D 4D 10 4C 8D 44 24 78 C6 04 03 65 48 03 D9 48 8D 45 88 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 46 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 83 F8 2D 75 7E 48 8B 44 24 78 4C 8D 4D 10 4C 8D 44 24 78 40 88 3C 03 48 8D 45 88 48 FF C3 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 33 C9 85 C0 75 55 44 8B 6C 24 44 45 33 E4 83 7D 88 01 75 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? 41 3B FF 0F 85 A6 09 00 00 8B 44 24 68 85 C0 75 08 8A 54 24 39 84 D2 74 03 44 8B F8 44 38 65 E8 0F 84 9E F9 FF FF 48 8B 4D E0 83 A1 C8 00 00 00 FD E9 8E F9 FF FF 83 F8 2B 75 27 33 C9 41 8B C4 BA 01 00 00 00 44 2B E2 85 C0 75 05 44 8B E1 EB 11 49 8B CD 44 03 F2 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 40 0F B6 CF EB 57 41 8B C4 BA 01 00 00 00 44 2B E2 85 C0 74 51 48 8B 44 24 78 03 F2 4C 8D 4D 10 40 88 3C 03 48 03 DA 48 8D 45 88 48 8D 55 A8 4C 8D 44 24 78 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 3D FF FF FF 49 8B CD 41 FF C6 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A0 B8 01 00 00 00 44 2B F0 44 89 74 24 34 41 3B FF 74 0F 49 8B D5 8B CF E8 ?? ?? ?? ?? B8 01 00 00 00 45 33 C9 85 F6 0F 84 B3 08 00 00 44 38 4C 24 30 0F 85 70 FC FF FF 48 8B 74 24 78 01 44 24 68 44 88 0C 33 0F BE 5C 24 38 48 8B 0D ?? ?? ?? ?? 2B D8 FF 15 ?? ?? ?? ?? 48 8B 55 98 4C 8D 4D D0 4C 8B C6 8B CB FF D0 E9 3B FC FF FF 85 C0 75 0A 03 F2 89 54 24 50 89 74 24 48 45 84 E4 0F 8E FC 02 00 00 40 8A F2 E9 F7 02 00 00 41 83 FD 70 0F 84 E4 04 00 00 41 83 FD 73 0F 84 D4 02 00 00 41 83 FD 75 0F 84 E2 04 00 00 41 83 FD 78 0F 84 1E FC FF FF 41 83 FD 7B 74 2D 41 0F B6 02 3B C7 0F 85 B7 07 00 00 8A 54 24 39 44 8B 74 24 34 41 02 D7 88 54 24 39 84 C9 0F 85 CA FB FF FF 4C 89 45 B8 E9 C1 FB FF FF 8B 75 A4 45 84 E4 40 0F B6 F6 0F 4F F2 4C 03 D2 41 80 3A 5E 4C 89 54 24 70 75 0D 49 FF C2 44 88 7C 24 54 4C 89 54 24 70 33 D2 48 8D 4D F0 44 8D 42 20 E8 ?? ?? ?? ?? 4C 8B 54 24 70 B3 5D 41 BB 01 00 00 00 41 38 1A 75 0A 44 8A F3 4D 03 D3 C6 45 FB 20 45 33 C9 41 8A 02 3A C3 0F 84 A4 00 00 00 4D 03 D3 3C 2D 75 7B 45 84 F6 74 76 41 8A 0A 3A CB 74 6F 4D 03 D3 4C 89 54 24 70 44 3A F1 73 05 44 8A C9 EB 06 45 8A CE 44 8A F1 45 3A F1 73 2C 45 0F B6 D6 41 0F B6 CE 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 45 02 F3 D2 E2 4D 03 D3 42 08 54 05 F0 45 3A F1 72 DD 4C 8B 54 24 70 41 0F B6 C1 45 0F B6 C1 41 8B D3 83 E0 07 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 F0 45 33 C9 45 8A F1 E9 73 FF FF FF 44 0F B6 C0 44 8A F0 0F B6 C0 83 E0 07 41 8B D3 49 C1 E8 03 8A C8 D2 E2 42 08 54 05 F0 E9 51 FF FF FF 45 38 0A 0F 84 2C FD FF FF 4C 89 54 24 70 E9 84 01 00 00 83 FF 2B 75 16 2B F2 89 74 24 48 0F 85 D4 00 00 00 85 C0 0F 84 CC 00 00 00 8A DA 44 8B 74 24 34 4C 8B 64 24 60 83 FF 30 75 53 41 FF C6 49 8B CC 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 3C 78 0F 84 ED 00 00 00 3C 58 0F 84 E5 00 00 00 B8 01 00 00 00 89 44 24 58 41 83 FD 78 0F 84 AA 00 00 00 45 33 C9 44 39 4C 24 50 74 0A 2B F0 89 74 24 48 75 02 02 D8 41 BD 6F 00 00 00 44 8B 74 24 4C 45 85 F6 0F 84 FC 03 00 00 48 8B 75 90 84 DB 0F 85 D9 03 00 00 44 8B 64 24 48 48 8B 5C 24 60 41 83 FD 78 0F 84 33 03 00 00 41 83 FD 70 0F 84 29 03 00 00 40 0F B6 CF E8 ?? ?? ?? ?? 45 33 C9 85 C0 0F 84 8D 03 00 00 41 83 FD 6F 0F 85 02 03 00 00 83 FF 38 0F 8D 7A 03 00 00 48 C1 E6 03 E9 33 03 00 00 44 8B 74 24 34 4C 8B 64 24 60 44 03 F2 49 8B CC 44 89 74 24 34 E8 ?? ?? ?? ?? 45 33 C9 8B F8 89 44 24 3C E9 18 FF FF FF 44 2B F0 44 89 74 24 34 41 3B FF 74 0A 49 8B D4 8B CF E8 ?? ?? ?? ?? BF 30 00 00 00 45 33 C9 89 7C 24 3C E9 48 FF FF FF 41 BD 01 00 00 00 49 8B CC 45 03 F5 44 89 74 24 34 E8 ?? ?? ?? ?? 45 33 C9 8B F8 89 44 24 3C 44 39 4C 24 50 74 0F 83 EE 02 89 74 24 48 41 3B F5 7D 03 41 02 DD 41 BD 78 00 00 00 E9 08 FF FF FF 0F B6 75 A4 45 84 E4 0F 4F F2 EB 03 8B 75 A4 8B 54 24 34 48 8B 5D 98 41 B8 01 00 00 00 41 2B D0 89 54 24 34 41 3B FF 74 16 48 8B 54 24 60 8B CF E8 ?? ?? ?? ?? 8B 54 24 34 41 B8 01 00 00 00 4C 8B 65 C0 41 83 FD 63 74 03 4D 2B E0 44 8A 74 24 54 45 33 C9 44 39 4C 24 50 74 15 8B 4C 24 48 8B C1 41 2B C8 89 4C 24 48 85 C0 0F 84 87 01 00 00 48 8B 4C 24 60 41 03 D0 89 54 24 34 E8 ?? ?? ?? ?? 48 63 F8 89 7C 24 3C 41 3B FF 0F 84 FE 00 00 00 41 83 FD 63 74 43 41 83 FD 73 75 13 83 FF 09 7C 09 83 FF 0D 0F 8E E4 00 00 00 83 FF 20 75 2A 41 83 FD 7B 0F 85 D5 00 00 00 48 8B C7 8B D7 48 C1 F8 03 83 E2 07 0F BE 4C 05 F0 41 0F BE C6 33 C8 0F A3 D1 0F 83 B5 00 00 00 45 33 C9 44 38 4C 24 30 0F 85 95 00 00 00 4D 85 E4 0F 84 34 04 00 00 40 84 F6 74 6E 40 0F B6 CF 40 88 7D A0 E8 ?? ?? ?? ?? 85 C0 74 11 48 8B 4C 24 60 FF 44 24 34 E8 ?? ?? ?? ?? 88 45 A1 B8 3F 00 00 00 4C 8D 4D D0 48 8D 55 A0 66 89 45 80 48 8B 45 D0 48 8D 4D 80 4C 63 80 0C 01 00 00 E8 ?? ?? ?? ?? 48 8B 45 98 44 0F B7 5D 80 8B 54 24 34 66 44 89 18 48 83 C0 02 41 B8 01 00 00 00 48 89 45 98 4D 2B E0 E9 ED FE FF FF 48 8B 45 98 41 B8 01 00 00 00 40 88 38 49 03 C0 4D 2B E0 48 89 45 98 EB 09 41 B8 01 00 00 00 49 03 D8 8B 54 24 34 E9 C5 FE FF FF 44 8B 74 24 34 41 B8 01 00 00 00 45 2B F0 44 89 74 24 34 41 3B FF 74 12 48 8B 54 24 60 8B CF E8 ?? ?? ?? ?? 41 B8 01 00 00 00 45 33 C9 48 8B 45 98 48 3B D8 0F 84 E4 F9 FF FF 44 38 4C 24 30 0F 85 60 F7 FF FF 8B 5C 24 68 41 03 D8 89 5C 24 68 41 83 FD 63 0F 84 4B F7 FF FF 40 84 F6 74 10 66 44 89 08 E9 3D F7 FF FF 44 8B 74 24 34 EB BE 44 88 08 E9 2E F7 FF FF 44 8B 74 24 4C 88 54 24 38 4C 89 4D 90 44 03 F2 EB 05 44 8B 74 24 4C 83 FF 2D 75 06 88 54 24 40 EB 09 83 FF 2B 0F 85 DC FC FF FF 2B F2 89 74 24 48 75 0B 85 C0 74 07 8A DA E9 C9 FC FF FF 48 8B 4C 24 60 01 54 24 34 E8 ?? ?? ?? ?? 45 33 C9 8B F8 89 44 24 3C E9 AD FC FF FF 48 8D 34 B6 48 03 F6 EB 3A 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 45 33 C9 85 C0 74 66 48 C1 65 90 04 8B CE 40 0F BE DF E8 ?? ?? ?? ?? 48 8B 75 90 8B FB 83 E7 DF 45 33 C9 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C 8D 47 D0 BA 01 00 00 00 01 54 24 58 48 63 C8 48 03 F1 48 89 75 90 44 39 4C 24 50 74 05 44 2B E2 74 36 48 8B 5C 24 60 01 54 24 34 48 8B CB E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 4B FC FF FF FF 4C 24 34 41 3B FF 74 0D 48 8B D3 8B CF E8 ?? ?? ?? ?? 45 33 C9 48 8B 75 90 44 38 4C 24 40 0F 84 FE 00 00 00 48 F7 DE 48 89 75 90 E9 F2 00 00 00 8B 74 24 5C 84 DB 0F 85 D9 00 00 00 44 8B 64 24 48 48 8B 5C 24 60 41 83 FD 78 74 36 41 83 FD 70 74 30 40 0F B6 CF E8 ?? ?? ?? ?? 45 33 C9 85 C0 0F 84 95 00 00 00 41 83 FD 6F 75 0E 83 FF 38 0F 8D 86 00 00 00 C1 E6 03 EB 48 8D 04 B6 8D 34 00 EB 40 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 45 33 C9 85 C0 74 67 8B 44 24 5C 8B CE 40 0F BE DF C1 E0 04 89 44 24 5C E8 ?? ?? ?? ?? 8B 74 24 5C 8B FB 45 33 C9 83 E7 DF 83 EF 07 85 C0 0F 45 FB 89 7C 24 3C B8 01 00 00 00 8D 74 3E D0 01 44 24 58 89 74 24 5C 44 39 4C 24 50 74 05 44 2B E0 74 36 48 8B 5C 24 60 01 44 24 34 48 8B CB E8 ?? ?? ?? ?? 8B F8 89 44 24 3C E9 4B FF FF FF FF 4C 24 34 41 3B FF 74 0D 48 8B D3 8B CF E8 ?? ?? ?? ?? 45 33 C9 8B 74 24 5C 44 38 4C 24 40 74 06 F7 DE 89 74 24 5C 8B 44 24 58 41 83 FD 46 41 0F 44 C1 85 C0 0F 84 95 F7 FF FF 44 38 4C 24 30 0F 85 0C F5 FF FF FF 44 24 68 8B 44 24 5C E9 EB F4 FF FF 44 8B 74 24 34 44 38 4C 24 38 74 07 89 01 E9 F1 F4 FF FF 66 89 01 E9 E9 F4 FF FF 38 0E 75 0A 48 8D 46 01 38 08 48 0F 44 F0 45 03 F5 49 8B CC 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 3C 0F B6 06 49 03 F5 48 89 74 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__crtMessageBoxA"
		size = 520
		refs = "0012 __security_cookie 0028 _encoded_null 0031 ?pfnMessageBox@?1??__crtMessageBoxA@@9@9 0041 ??_C@_1BG@GOEBHBDC@?$AAU?$AAS?$AAE?$AAR?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0047 __imp_LoadLibraryW 005a ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0063 __imp_GetProcAddress 0075 __imp_EncodePointer 007c ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 009c ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 00a6 ?pfnGetActiveWindow@?1??__crtMessageBoxA@@9@9 00bc ??_C@_0BK@CIDNPOGP@GetUserObjectInformationA?$AA@ 00c6 ?pfnGetLastActivePopup@?1??__crtMessageBoxA@@9@9 00df ?pfnGetUserObjectInformation@?1??__crtMessageBoxA@@9@9 00eb ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 0104 ?pfnGetProcessWindowStation@?1??__crtMessageBoxA@@9@9 0130 __imp_DecodePointer 01f5 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 41 8B E8 4C 8B F2 4C 8B E9 E8 ?? ?? ?? ?? 33 DB 48 39 1D ?? ?? ?? ?? 48 8B F8 0F 85 D5 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 93 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 7A 01 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B D8 48 89 05 ?? ?? ?? ?? 48 85 C0 74 22 48 8D 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 10 48 8B 05 ?? ?? ?? ?? EB 0E 48 8B 05 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 48 3B C7 74 62 4C 3B DF 74 5D 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8B F0 FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 F6 74 3C 48 85 C0 74 37 FF D6 48 85 C0 74 2A 48 8D 4C 24 30 41 B9 0C 00 00 00 4C 8D 44 24 38 48 89 4C 24 20 41 8D 51 F5 48 8B C8 41 FF D4 85 C0 74 07 F6 44 24 40 01 75 06 0F BA ED 15 EB 40 48 8B 0D ?? ?? ?? ?? 48 3B CF 74 34 FF 15 ?? ?? ?? ?? 48 85 C0 74 29 FF D0 48 8B D8 48 85 C0 74 1F 48 8B 0D ?? ?? ?? ?? 48 3B CF 74 13 FF 15 ?? ?? ?? ?? 48 85 C0 74 08 48 8B CB FF D0 48 8B D8 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 74 10 44 8B CD 4D 8B C6 49 8B D5 48 8B CB FF D0 EB 02 33 C0 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 50 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "__crtMessageBoxW"
		size = 520
		refs = "0012 __security_cookie 0028 _encoded_null 0031 ?pfnMessageBox@?1??__crtMessageBoxW@@9@9 0041 ??_C@_1BG@GOEBHBDC@?$AAU?$AAS?$AAE?$AAR?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0047 __imp_LoadLibraryW 005a ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0063 __imp_GetProcAddress 0075 __imp_EncodePointer 007c ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 009c ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 00a6 ?pfnGetActiveWindow@?1??__crtMessageBoxW@@9@9 00bc ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 00c6 ?pfnGetLastActivePopup@?1??__crtMessageBoxW@@9@9 00df ?pfnGetUserObjectInformation@?1??__crtMessageBoxW@@9@9 00eb ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 0104 ?pfnGetProcessWindowStation@?1??__crtMessageBoxW@@9@9 0130 __imp_DecodePointer 01f5 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 41 8B E8 4C 8B F2 4C 8B E9 E8 ?? ?? ?? ?? 33 DB 48 39 1D ?? ?? ?? ?? 48 8B F8 0F 85 D5 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 93 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 7A 01 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CE 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B D8 48 89 05 ?? ?? ?? ?? 48 85 C0 74 22 48 8D 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 10 48 8B 05 ?? ?? ?? ?? EB 0E 48 8B 05 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 48 3B C7 74 62 4C 3B DF 74 5D 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8B F0 FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 F6 74 3C 48 85 C0 74 37 FF D6 48 85 C0 74 2A 48 8D 4C 24 30 41 B9 0C 00 00 00 4C 8D 44 24 38 48 89 4C 24 20 41 8D 51 F5 48 8B C8 41 FF D4 85 C0 74 07 F6 44 24 40 01 75 06 0F BA ED 15 EB 40 48 8B 0D ?? ?? ?? ?? 48 3B CF 74 34 FF 15 ?? ?? ?? ?? 48 85 C0 74 29 FF D0 48 8B D8 48 85 C0 74 1F 48 8B 0D ?? ?? ?? ?? 48 3B CF 74 13 FF 15 ?? ?? ?? ?? 48 85 C0 74 08 48 8B CB FF D0 48 8B D8 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 74 10 44 8B CD 4D 8B C6 49 8B D5 48 8B CB FF D0 EB 02 33 C0 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 50 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "strchr"
		size = 26
	strings:
		$1 = { EB 07 3A C2 74 0D 48 FF C1 8A 01 84 C0 75 F3 3A C2 75 04 48 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "logf"
		size = 597
		refs = "001b __mask_127 002d __real_inf 0042 __real_mant 004a __real_one 0051 __real_neg127 0060 __mask_mant_all7 0067 __mask_mant8 0078 __real_ef 0085 __real_notsign 008c __real_threshold 00a3 __real_half 00b2 __log_F_inv 00d8 __real_1_over_3 00e4 __real_1_over_2 00ec __real_log2_tail 00f3 __log_128_tail 00fa __log_128_lead 010e __real_log2_lead 0144 __real_two 017c __real_ca2 0184 __real_ca1 01c9 __mask_253 01e6 __real_ninf 01ed __flag_x_zero 01f2 _logf_special 0204 __real_neg_qnan 020b __flag_x_neg 0232 __real_qnanbit 023d __flag_x_nan"
	strings:
		$1 = { 48 83 EC 78 33 C0 66 0F 6F D8 F3 0F 10 E0 66 0F 72 D3 17 66 0F 7E C0 66 0F FA 1D ?? ?? ?? ?? 66 0F 6F D0 0F 5B EB 66 0F 6F C8 0F 54 0D ?? ?? ?? ?? 0F 2F 0D ?? ?? ?? ?? 0F 84 E2 01 00 00 66 0F DB 15 ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? 0F 2F 2D ?? ?? ?? ?? 0F 84 45 01 00 00 44 8B C8 23 05 ?? ?? ?? ?? 44 23 0D ?? ?? ?? ?? 41 D1 E1 41 03 C1 89 44 24 30 0F 2F 05 ?? ?? ?? ?? 0F 84 AE 00 00 00 0F 54 25 ?? ?? ?? ?? 0F 2F 25 ?? ?? ?? ?? 0F 82 AA 00 00 00 F3 0F 10 4C 24 30 C1 E8 10 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 0F 57 E4 0F 2F C4 0F 86 1E 01 00 00 F3 0F 5C CA F3 41 0F 59 0C 81 F3 0F 10 D1 F3 0F 10 C1 F3 0F 59 15 ?? ?? ?? ?? F3 0F 59 C1 F3 0F 58 15 ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F3 0F 59 D0 F3 0F 59 DD F3 0F 58 CA F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C D9 F3 0F 59 C5 F3 41 0F 58 1C 81 F3 41 0F 58 04 82 F3 0F 58 C3 48 83 C4 78 C3 90 F3 0F 10 05 ?? ?? ?? ?? 48 83 C4 78 C3 0F 1F 00 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C 05 ?? ?? ?? ?? F3 0F 58 D0 F3 0F 10 C8 F3 0F 5E CA F3 0F 10 E0 F3 0F 59 E1 F3 0F 58 C9 F3 0F 10 D1 F3 0F 59 D2 F3 0F 10 D9 F3 0F 59 DA F3 0F 59 15 ?? ?? ?? ?? F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D3 F3 0F 5C D4 F3 0F 58 C2 48 83 C4 78 C3 0F 1F 80 00 00 00 00 66 0F EB 15 ?? ?? ?? ?? F3 0F 5C 15 ?? ?? ?? ?? 66 0F 6F EA 66 0F DB 15 ?? ?? ?? ?? 66 0F 7E D0 66 0F 72 D5 17 66 0F FA 2D ?? ?? ?? ?? 0F 5B ED E9 86 FE FF FF 66 66 66 0F 1F 84 00 00 00 00 00 75 1E F3 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 0F 1F 84 00 00 00 00 00 F3 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3A 66 66 0F 1F 84 00 00 00 00 00 3B 05 ?? ?? ?? ?? 74 28 3B 05 ?? ?? ?? ?? 74 D0 0B 05 ?? ?? ?? ?? 66 0F 6E C8 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 08 0F 1F 84 00 00 00 00 00 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "_mktemp_s"
		size = 330
		refs = "0032 strnlen 0043 __threadid 006d _ismbstrail 00c5 _errno 00d9 _access_s 0129 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 48 8B F2 48 8B D9 48 85 C9 0F 84 F4 00 00 00 48 85 D2 0F 84 EB 00 00 00 E8 ?? ?? ?? ?? 48 8B E8 48 3B C6 0F 83 D7 00 00 00 E8 ?? ?? ?? ?? 48 8D 7C 2B FF 44 8B E0 48 83 FD 06 0F 82 C0 00 00 00 48 3B F5 0F 86 B7 00 00 00 33 F6 EB 46 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 3C 80 3F 58 0F 85 9B 00 00 00 48 83 FE 05 73 2D B8 CD CC CC CC 48 FF C6 41 F7 E4 C1 EA 03 8A C2 C0 E0 02 8D 0C 10 02 C9 44 2A E1 41 80 C4 30 44 88 27 44 8B E2 48 FF CF 48 3B FB 73 B5 80 3F 58 75 63 48 83 FE 05 72 5D C6 07 61 BE 62 00 00 00 E8 ?? ?? ?? ?? 8B 28 E8 ?? ?? ?? ?? 33 D2 48 8B CB 83 20 00 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 0C 83 FE 7B 74 12 40 88 37 FF C6 EB D4 E8 ?? ?? ?? ?? 89 28 33 C0 EB 2D C6 03 00 E8 ?? ?? ?? ?? C7 00 11 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 16 C6 03 00 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "_mbscmp_l"
		size = 267
		refs = "0025 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0031 _errno 003c _invalid_parameter_noinfo 0071 strcmp"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 40 48 8B F9 48 8B DA 48 8D 4D E0 49 8B D0 E8 ?? ?? ?? ?? 33 F6 48 85 FF 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 75 F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 FF FF FF 7F E9 9B 00 00 00 48 85 DB 74 D0 4C 8B 45 E8 41 39 70 08 75 0D 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 6E 0F B6 0F 48 FF C7 42 F6 44 01 1D 04 74 16 40 38 37 75 04 8B CE EB 0D 0F B6 07 66 C1 E1 08 66 0B C8 48 FF C7 0F B6 13 48 FF C3 42 F6 44 02 1D 04 74 16 40 38 33 75 04 8B D6 EB 0D 0F B6 03 66 C1 E2 08 66 0B D0 48 FF C3 66 3B D1 75 1A 66 85 C9 75 AE 40 38 75 F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 33 C0 EB 18 1B C0 83 E0 02 FF C8 40 38 75 F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 8B 74 24 58 48 8B 7C 24 60 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "__initstdio"
		size = 224
		refs = "0008 _nstream 0030 _calloc_crt 0037 __piob 0069 _iob 009b __pioinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 05 ?? ?? ?? ?? BB 14 00 00 00 85 C0 75 07 B8 00 02 00 00 EB 05 3B C3 0F 4C C3 48 63 C8 BA 08 00 00 00 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 75 24 8D 50 08 48 8B CB 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 75 07 B8 1A 00 00 00 EB 76 33 C9 48 8D 15 ?? ?? ?? ?? 48 89 14 01 48 83 C2 30 48 83 C1 08 48 FF CB 74 09 48 8B 05 ?? ?? ?? ?? EB E6 45 33 C0 48 8D 15 ?? ?? ?? ?? 45 8D 48 03 49 8B C8 4C 8D 15 ?? ?? ?? ?? 49 8B C0 48 C1 F8 05 83 E1 1F 49 8B 04 C2 48 6B C9 58 4C 8B 14 01 49 83 FA FF 74 0B 49 83 FA FE 74 05 4D 85 D2 75 06 C7 02 FE FF FF FF 49 FF C0 48 83 C2 30 49 FF C9 75 BD 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_87_2_0 {
	meta:
		name = "__endstdio"
		size = 39
		refs = "0005 _flushall 000b _exitflag 0013 _fcloseall 001a __piob 0023 free"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_3_0 {
	meta:
		name = "_lock_file"
		size = 99
		refs = "000c _iob 0044 _lock 005f __imp_EnterCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8D 0D ?? ?? ?? ?? 48 3B D9 72 3E 48 8D 05 ?? ?? ?? ?? 48 3B D8 77 32 48 8B D3 48 B8 AB AA AA AA AA AA AA 2A 48 2B D1 48 F7 EA 48 C1 FA 03 48 8B CA 48 C1 E9 3F 8D 4C 11 10 E8 ?? ?? ?? ?? 0F BA 6B 18 0F 48 83 C4 20 5B C3 48 8D 4B 30 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_4_0 {
	meta:
		name = "_lock_file2"
		size = 49
		refs = "0012 _lock 002d __imp_EnterCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 83 F9 14 7D 13 83 C1 10 E8 ?? ?? ?? ?? 0F BA 6B 18 0F 48 83 C4 20 5B C3 48 8D 4A 30 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_5_0 {
	meta:
		name = "_unlock_file"
		size = 76
		refs = "0003 _iob 003d _unlock 0048 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 48 3B CA 72 35 48 8D 05 ?? ?? ?? ?? 48 3B C8 77 29 0F BA 71 18 0F 48 2B CA 48 B8 AB AA AA AA AA AA AA 2A 48 F7 E9 48 C1 FA 03 48 8B CA 48 C1 E9 3F 8D 4C 11 10 E9 ?? ?? ?? ?? 48 83 C1 30 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_6_0 {
	meta:
		name = "_unlock_file2"
		size = 29
		refs = "000e _unlock 0019 __imp_LeaveCriticalSection"
	strings:
		$1 = { 83 F9 14 7D 0D 0F BA 72 18 0F 83 C1 10 E9 ?? ?? ?? ?? 48 8D 4A 30 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "_mbsnbcpy_s"
		size = 20
		refs = "000b _mbsnbcpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_459_7_0 {
	meta:
		name = "_aligned_recalloc"
		size = 20
		refs = "000b _aligned_offset_recalloc"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_569_20_0 {
	meta:
		name = "_cftof"
		size = 20
		refs = "000b _cftof_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "_mbccpy_s"
		size = 20
		refs = "000b _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_909_0_0 {
	meta:
		name = "_mbsnbcat_s"
		size = 20
		refs = "000b _mbsnbcat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_625_0_0 {
	meta:
		name = "_mbsnbset_s"
		size = 20
		refs = "000b _mbsnbset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_888_0_0 {
	meta:
		name = "_mbsncat_s"
		size = 20
		refs = "000b _mbsncat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "_mbsncpy_s"
		size = 20
		refs = "000b _mbsncpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "_mbsnset_s"
		size = 20
		refs = "000b _mbsnset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_195_4_0 {
	meta:
		name = "wctomb_s"
		size = 20
		refs = "000b _wctomb_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "fast_error_exit"
		size = 44
		refs = "0008 __error_mode 0012 _FF_MSGBANNER 0019 _NMSG_WRITE 0028 __crtExitProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 83 3D ?? ?? ?? ?? 01 8B D9 75 05 E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? B9 FF 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 409
		refs = "0014 __imp_GetStartupInfoW 0021 __ImageBase 006c _heap_init 0076 __error_mode 007e _FF_MSGBANNER 0088 _NMSG_WRITE 0092 __crtExitProcess 0097 _mtinit 00c2 _RTC_Initialize 00c8 _ioinit 00d6 _amsg_exit 00dc __imp_GetCommandLineA 00e3 _acmdln 00e8 __crtGetEnvironmentStringsA 00ef _aenvptr 00f4 _setargv 0107 _setenvp 011f _cinit 012f _wincmdln 0150 WinMain 0161 exit 0166 _cexit 017b _exit 0181 _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 81 EC A0 00 00 00 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 41 BB 4D 5A 00 00 48 8D 3D ?? ?? ?? ?? 66 44 39 1D ?? ?? ?? ?? 74 04 33 DB EB 31 48 63 05 ?? ?? ?? ?? 48 03 C7 81 38 50 45 00 00 75 EA B9 0B 02 00 00 66 39 48 18 75 DF 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 9C 24 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? B9 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 6C 01 0F B7 54 24 70 41 B9 0A 00 00 00 44 0F 45 CA 4C 8B C0 33 D2 48 8B CF E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1A 8B F8 83 BC 24 B0 00 00 00 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 9C 24 B8 00 00 00 48 81 C4 A0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_814_2_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 409
		refs = "0014 __imp_GetStartupInfoW 0021 __ImageBase 006c _heap_init 0076 __error_mode 007e _FF_MSGBANNER 0088 _NMSG_WRITE 0092 __crtExitProcess 0097 _mtinit 00c2 _RTC_Initialize 00c8 _ioinit 00d6 _amsg_exit 00dc __imp_GetCommandLineW 00e3 _wcmdln 00e8 __crtGetEnvironmentStringsW 00ef _wenvptr 00f4 _wsetargv 0107 _wsetenvp 011f _cinit 012f _wwincmdln 0150 wWinMain 0161 exit 0166 _cexit 017b _exit 0181 _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 81 EC A0 00 00 00 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 41 BB 4D 5A 00 00 48 8D 3D ?? ?? ?? ?? 66 44 39 1D ?? ?? ?? ?? 74 04 33 DB EB 31 48 63 05 ?? ?? ?? ?? 48 03 C7 81 38 50 45 00 00 75 EA B9 0B 02 00 00 66 39 48 18 75 DF 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 9C 24 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? B9 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 6C 01 0F B7 54 24 70 41 B9 0A 00 00 00 44 0F 45 CA 4C 8B C0 33 D2 48 8B CF E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1A 8B F8 83 BC 24 B0 00 00 00 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 9C 24 B8 00 00 00 48 81 C4 A0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "vscan_fn"
		size = 175
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo 0057 wcslen"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F8 48 8B E9 44 8D 42 28 48 8D 48 D0 49 8B F1 E8 ?? ?? ?? ?? 48 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4C 48 85 FF 74 E6 48 8B CB E8 ?? ?? ?? ?? C7 44 24 38 49 00 00 00 48 89 5C 24 30 48 89 5C 24 20 48 3D FF FF FF 3F 76 0A C7 44 24 28 FF FF FF 7F EB 06 03 C0 89 44 24 28 4C 8B 8C 24 80 00 00 00 48 8D 4C 24 20 4C 8B C6 48 8B D7 FF D5 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_90_1_0 {
	meta:
		name = "swscanf"
		size = 53
		refs = "0020 _winput_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "fscanf"
		size = 53
		refs = "0020 _input_l 002c vfscanf"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "fscanf_s"
		size = 53
		refs = "0020 _input_s_l 002c vfscanf"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_904_2_0 {
	meta:
		name = "fwscanf"
		size = 53
		refs = "0020 _winput_l 002c vfwscanf"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_904_4_0 {
	meta:
		name = "fwscanf_s"
		size = 53
		refs = "0020 _winput_s_l 002c vfwscanf"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_694_1_0 {
	meta:
		name = "sscanf"
		size = 53
		refs = "0020 _input_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_694_3_0 {
	meta:
		name = "sscanf_s"
		size = 53
		refs = "0020 _input_s_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_90_3_0 {
	meta:
		name = "swscanf_s"
		size = 53
		refs = "0020 _winput_s_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_90_2_0 {
	meta:
		name = "_swscanf_l"
		size = 49
		refs = "001f _winput_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "_fscanf_l"
		size = 49
		refs = "001f _input_l 0028 vfscanf"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "_fscanf_s_l"
		size = 49
		refs = "001f _input_s_l 0028 vfscanf"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_904_3_0 {
	meta:
		name = "_fwscanf_l"
		size = 49
		refs = "001f _winput_l 0028 vfwscanf"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_904_5_0 {
	meta:
		name = "_fwscanf_s_l"
		size = 49
		refs = "001f _winput_s_l 0028 vfwscanf"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_694_2_0 {
	meta:
		name = "_sscanf_l"
		size = 49
		refs = "001f _input_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_694_4_0 {
	meta:
		name = "_sscanf_s_l"
		size = 49
		refs = "001f _input_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_90_4_0 {
	meta:
		name = "_swscanf_s_l"
		size = 49
		refs = "001f _winput_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_call_matherr"
		size = 92
		refs = "0037 _ctrlfp 0041 _matherr 004c _set_errno_from_matherr"
	strings:
		$1 = { 48 8B C4 53 48 83 EC 50 F2 0F 10 84 24 80 00 00 00 8B D9 89 48 C8 48 8B 8C 24 88 00 00 00 48 89 50 D0 BA C0 FF 00 00 F2 0F 11 50 D8 F2 0F 11 58 E0 F2 0F 11 40 E8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 85 C0 75 07 8B CB E8 ?? ?? ?? ?? F2 0F 10 44 24 40 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "_exception_enabled"
		size = 185
		refs = "0028 _set_statfp"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B D9 48 8B F2 8B F9 83 E3 1F F6 C1 08 74 13 84 D2 79 0F B9 01 00 00 00 E8 ?? ?? ?? ?? 83 E3 F7 EB 57 B9 04 00 00 00 40 84 F9 74 11 48 0F BA E2 09 73 0A E8 ?? ?? ?? ?? 83 E3 FB EB 3C 40 F6 C7 01 74 16 48 0F BA E2 0A 73 0F B9 08 00 00 00 E8 ?? ?? ?? ?? 83 E3 FE EB 20 40 F6 C7 02 74 1A 48 0F BA E2 0B 73 13 40 F6 C7 10 74 0A B9 10 00 00 00 E8 ?? ?? ?? ?? 83 E3 FD 40 F6 C7 10 74 14 48 0F BA E6 0C 73 0D B9 20 00 00 00 E8 ?? ?? ?? ?? 83 E3 EF 48 8B 74 24 38 33 C0 85 DB 48 8B 5C 24 30 0F 94 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "_handle_errorf"
		size = 347
		refs = "001d __security_cookie 0042 _ctrlfp 0064 _exception_enabled 00b0 _raise_excf 00b6 _matherr_flag 0106 _matherr 0111 _set_errno_from_matherr 013f __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 54 41 55 48 8D 68 C8 48 81 EC 08 01 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E0 8B F2 4C 8B E1 41 BD C0 FF 00 00 B9 80 1F 00 00 41 8B D5 41 8B F9 49 8B D8 E8 ?? ?? ?? ?? 8B 4D 60 48 89 44 24 38 89 5C 24 40 F3 0F 10 44 24 40 48 8B 54 24 38 F3 0F 11 44 24 30 E8 ?? ?? ?? ?? F3 0F 10 75 78 85 C0 75 43 83 BD 80 00 00 00 02 75 11 8B 45 B0 F3 0F 11 75 A0 83 E0 E1 83 C8 01 89 45 B0 44 8B 45 60 48 8D 44 24 30 48 8D 54 24 38 48 89 44 24 28 48 8D 45 70 48 8D 4C 24 70 44 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 60 85 FF 74 5C 66 0F 6E 45 70 48 8B 4C 24 38 0F 14 F6 49 8B D5 89 7C 24 48 4C 89 64 24 50 0F 5A CE 0F 5A C0 F2 0F 11 4C 24 60 F2 0F 11 44 24 58 66 0F 6E 44 24 30 0F 5A C0 F2 0F 11 44 24 68 E8 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 85 C0 75 07 8B CF E8 ?? ?? ?? ?? F2 0F 5A 44 24 68 EB 1A 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 38 49 8B D5 E8 ?? ?? ?? ?? F3 0F 10 44 24 30 48 8B 4D E0 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 F0 00 00 00 48 81 C4 08 01 00 00 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_92_3_0 {
	meta:
		name = "_handle_error"
		size = 336
		refs = "001d __security_cookie 0042 _ctrlfp 0065 _exception_enabled 00b1 _raise_exc 00b7 _matherr_flag 00fb _matherr 0106 _set_errno_from_matherr 0134 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 54 41 55 48 8D 68 C8 48 81 EC 08 01 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E0 8B F2 4C 8B E1 41 BD C0 FF 00 00 B9 80 1F 00 00 41 8B D5 41 8B F9 49 8B D8 E8 ?? ?? ?? ?? 8B 4D 60 48 89 44 24 30 48 89 5C 24 40 F2 0F 10 44 24 40 48 8B 54 24 30 F2 0F 11 44 24 38 E8 ?? ?? ?? ?? F2 0F 10 75 78 85 C0 75 43 83 BD 80 00 00 00 02 75 11 8B 45 B0 F2 0F 11 75 A0 83 E0 E3 83 C8 03 89 45 B0 44 8B 45 60 48 8D 44 24 38 48 8D 54 24 30 48 89 44 24 28 48 8D 45 70 48 8D 4C 24 70 44 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 54 85 FF 74 50 F2 0F 10 45 70 F2 0F 10 4C 24 38 48 8B 4C 24 30 49 8B D5 89 7C 24 48 4C 89 64 24 50 F2 0F 11 44 24 58 F2 0F 11 4C 24 68 F2 0F 11 74 24 60 E8 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 85 C0 75 07 8B CF E8 ?? ?? ?? ?? F2 0F 10 44 24 68 EB 1A 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 30 49 8B D5 E8 ?? ?? ?? ?? F2 0F 10 44 24 38 48 8B 4D E0 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 F0 00 00 00 48 81 C4 08 01 00 00 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "IsRootUNCName"
		size = 153
		refs = "000a strlen"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 83 F8 05 72 7D 41 B1 5C 41 B0 2F 44 38 0B 74 05 44 38 03 75 6D 8A 43 01 41 3A C1 74 05 41 3A C0 75 60 8A 43 02 41 3A C1 74 58 41 3A C0 74 53 48 8D 4B 03 33 D2 8A 01 84 C0 74 47 41 3A C1 74 0E 41 3A C0 74 09 48 FF C1 8A 01 84 C0 75 ED 38 11 74 30 48 FF C1 38 11 74 29 8A 01 84 C0 74 1C 41 3A C1 74 0E 41 3A C0 74 09 48 FF C1 8A 01 84 C0 75 ED 38 11 74 05 38 51 01 75 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_fullpath_helper"
		size = 151
		refs = "0026 _errno 003e _fullpath"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 4D 8B E1 49 8B D8 48 8B EA 48 8B F9 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 4C 8B C3 83 20 00 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0C E8 ?? ?? ?? ?? 89 30 48 8B C3 EB 26 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 18 E8 ?? ?? ?? ?? 45 33 C0 48 8B D5 33 C9 89 30 E8 ?? ?? ?? ?? 49 89 04 24 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_474_1_0 {
	meta:
		name = "_wfullpath_helper"
		size = 151
		refs = "0026 _errno 003e _wfullpath"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 4D 8B E1 49 8B D8 48 8B EA 48 8B F9 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 4C 8B C3 83 20 00 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0C E8 ?? ?? ?? ?? 89 30 48 8B C3 EB 26 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 18 E8 ?? ?? ?? ?? 45 33 C0 48 8B D5 33 C9 89 30 E8 ?? ?? ?? ?? 49 89 04 24 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "_stat64"
		size = 1260
		refs = "0022 __security_cookie 003f __doserrno 0047 _errno 0052 _invalid_parameter_noinfo 0063 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0068 _mbspbrk 009e _mbctolower 00a9 _getdrive 00c9 __imp_FindFirstFileExA 00e3 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 011c _fullpath 0168 strlen 021b __imp_GetDriveTypeA 0233 free 0266 __loctotime64_t 02c0 _sopen_s 02dd _fstat64 02e8 _close 0313 __imp_FileTimeToLocalFileTime 032b __imp_FileTimeToSystemTime 0468 __imp_FindClose 0474 __dtoxmode 04ab __imp_GetLastError 04b2 _dosmaperr 04cd __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 40 FE FF FF 48 81 EC C0 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 B0 01 00 00 45 33 FF 48 8B DA 48 8B F1 48 85 C9 75 1D E8 ?? ?? ?? ?? 44 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 64 04 00 00 48 85 D2 74 DE 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 18 E8 ?? ?? ?? ?? BB 02 00 00 00 89 18 E8 ?? ?? ?? ?? 89 18 E9 36 04 00 00 80 7E 01 3A 75 19 44 38 3E 74 06 44 38 7E 02 74 D7 0F BE 0E E8 ?? ?? ?? ?? 44 8D 70 A0 EB 08 E8 ?? ?? ?? ?? 44 8B F0 4C 8D 44 24 60 45 33 C9 33 D2 48 8B CE 44 89 7C 24 28 4C 89 7C 24 20 FF 15 ?? ?? ?? ?? 41 BD 01 00 00 00 48 8B F8 48 83 F8 FF 0F 85 B1 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CE 4D 8B E7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 76 FF FF FF E8 ?? ?? ?? ?? 44 8B 28 E8 ?? ?? ?? ?? 48 8D 8D A0 00 00 00 41 B8 04 01 00 00 48 8B D6 44 89 38 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0A E8 ?? ?? ?? ?? 44 89 28 EB 29 E8 ?? ?? ?? ?? 83 38 22 0F 85 31 FF FF FF E8 ?? ?? ?? ?? 45 33 C0 48 8B D6 33 C9 44 89 28 E8 ?? ?? ?? ?? 4C 8B E0 48 8B F8 48 85 FF 0F 84 17 01 00 00 48 8B CF E8 ?? ?? ?? ?? 48 83 F8 03 0F 84 A0 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 83 F8 05 0F 82 F3 00 00 00 41 B0 5C B2 2F 44 38 07 74 08 38 17 0F 85 E1 00 00 00 8A 47 01 41 3A C0 74 08 3A C2 0F 85 D1 00 00 00 8A 47 02 41 3A C0 0F 84 C5 00 00 00 3A C2 0F 84 BD 00 00 00 48 8D 47 03 8A 08 84 C9 0F 84 AF 00 00 00 41 3A C8 74 0D 3A CA 74 09 48 FF C0 8A 08 84 C9 75 EE 44 38 38 0F 84 94 00 00 00 48 FF C0 44 38 38 0F 84 88 00 00 00 8A 08 84 C9 74 1D 41 3A C8 74 0D 3A CA 74 09 48 FF C0 8A 08 84 C9 75 EE 44 38 38 74 06 44 38 78 01 75 65 48 8B CF FF 15 ?? ?? ?? ?? 41 BD 01 00 00 00 41 3B C5 76 51 4D 85 E4 74 08 49 8B CC E8 ?? ?? ?? ?? 83 4C 24 30 FF 45 33 C9 45 8B C5 41 8B D5 B9 BC 07 00 00 44 89 7C 24 28 C7 44 24 60 10 00 00 00 4C 89 7C 24 7C 44 88 7D 8C 44 89 7C 24 20 E8 ?? ?? ?? ?? 48 89 43 28 48 89 43 20 48 89 43 30 E9 F1 01 00 00 4D 85 E4 0F 84 ED FD FF FF 49 8B CC E8 ?? ?? ?? ?? E9 E0 FD FF FF F7 44 24 60 00 04 00 00 74 58 81 7D 84 0C 00 00 A0 75 4F 83 4C 24 40 FF 48 8D 4C 24 40 41 B9 40 00 00 00 45 33 C0 48 8B D6 44 89 7C 24 20 E8 ?? ?? ?? ?? 85 C0 0F 85 A5 FD FF FF 8B 4C 24 40 83 F9 FF 0F 84 98 FD FF FF 48 8B D3 E8 ?? ?? ?? ?? 8B 4C 24 40 8B D8 E8 ?? ?? ?? ?? 8B C3 E9 CF 01 00 00 44 39 7C 24 74 75 0D 44 39 7C 24 78 75 06 4C 89 7B 28 EB 68 48 8D 54 24 40 48 8D 4C 24 74 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8A 01 00 00 48 8D 54 24 48 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 0F 84 72 01 00 00 83 4C 24 30 FF 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 48 89 43 28 44 39 7C 24 6C 75 0D 44 39 7C 24 70 75 06 48 8B 43 28 EB 64 48 8D 54 24 40 48 8D 4C 24 6C FF 15 ?? ?? ?? ?? 85 C0 0F 84 0E 01 00 00 48 8D 54 24 48 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F6 00 00 00 83 4C 24 30 FF 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 48 89 43 20 44 39 7C 24 64 75 0D 44 39 7C 24 68 75 06 48 8B 43 28 EB 60 48 8D 54 24 40 48 8D 4C 24 64 FF 15 ?? ?? ?? ?? 85 C0 0F 84 92 00 00 00 48 8D 54 24 48 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 74 7E 83 4C 24 30 FF 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 48 8B CF 48 89 43 30 FF 15 ?? ?? ?? ?? 8B 4C 24 60 48 8B D6 E8 ?? ?? ?? ?? 8B 4C 24 7C 66 44 89 6B 08 66 89 43 06 8B 45 80 48 C1 E1 20 48 03 C8 41 8D 46 FF 66 44 89 7B 04 89 03 89 43 10 33 C0 48 89 4B 18 44 89 7B 0A EB 19 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 83 C8 FF 48 8B 8D B0 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 10 03 00 00 48 81 C4 C0 02 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_initp_misc_cfltcvt_tab"
		size = 54
		refs = "000d _cfltcvt_tab 001b __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 1D ?? ?? ?? ?? BF 0A 00 00 00 48 8B 0B FF 15 ?? ?? ?? ?? 48 89 03 48 83 C3 08 48 FF CF 75 EB 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "_wwincmdln"
		size = 87
		refs = "0003 _wcmdln 000d ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 48 8B 0D ?? ?? ?? ?? 45 33 C0 48 8D 05 ?? ?? ?? ?? 48 85 C9 41 8B D0 48 0F 44 C8 66 83 39 20 77 0A 66 44 39 01 74 2C 85 D2 74 20 66 83 39 22 75 0A 85 D2 41 8B C0 0F 94 C0 8B D0 48 83 C1 02 EB DA 66 83 F8 20 77 0C 48 83 C1 02 0F B7 01 66 85 C0 75 EE 48 8B C1 C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "fgetws"
		size = 205
		refs = "002b _errno 0036 _invalid_parameter_noinfo 0064 _lock_file 007a _fgetwc_nolock 00b2 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 41 54 41 55 48 83 EC 30 4D 8B E0 8B DA 48 8B F9 48 8B F1 45 33 ED 48 85 C9 75 18 85 D2 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 7B 41 8B C5 85 D2 0F 99 C0 85 C0 74 E0 41 8B C5 4D 85 C0 0F 95 C0 85 C0 74 D3 85 D2 74 DF 4C 89 44 24 50 49 8B C8 E8 ?? ?? ?? ?? 90 48 85 FF 74 40 FF CB 89 5C 24 58 74 34 49 8B CC E8 ?? ?? ?? ?? 44 0F B7 D8 41 81 FB FF FF 00 00 75 0A 48 3B F7 75 1A 49 8B FD EB 19 66 44 89 1E 48 83 C6 02 48 89 74 24 20 41 83 FB 0A 74 02 EB C4 66 44 89 2E 49 8B CC E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 30 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "fgetws$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_wfsopen$fin$0 fprintf$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "_fputchar"
		size = 29
		refs = "0009 __iob_func 0019 putc"
		altNames = "putchar"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 8B CB 48 8D 50 30 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "sinf"
		size = 893
		refs = "0081 L__real_3fc5555555555555 00a6 Lsinfarray 010c L__real_411E848000000000 011e L__real_3fe45f306dc9c883 012a L__real_3fe0000000000000 0141 L__real_3ff921fb54400000 014d L__real_3dd0b4611a626331 0171 L__real_3dd0b4611a600000 017e L__real_3ba3198a2e037073 0204 L__real_3ff0000000000000 0254 __remainder_piby2f 02d4 Lcosfarray 0371 _sinf_special"
	strings:
		$1 = { 48 81 EC F8 00 00 00 66 0F 57 D2 66 0F 7E C2 B8 00 00 80 7F 44 8B D0 44 23 D2 44 3B D0 0F 84 4D 03 00 00 F3 0F 5A C0 F2 0F 11 04 24 48 8B 14 24 49 BA FF FF FF FF FF FF FF 7F 4C 23 D2 41 B8 01 00 00 00 48 B8 18 2D 44 54 FB 21 E9 3F 4C 3B D0 0F 8F 9A 00 00 00 48 B8 00 00 00 00 00 00 80 3F 4C 3B D0 7D 35 48 B8 00 00 00 00 00 00 20 3F 4C 3B D0 7D 05 E9 E7 02 00 00 F2 0F 10 D0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 59 D0 F2 0F 59 D4 F2 0F 5C C2 E9 C6 02 00 00 F2 0F 10 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 E2 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 D8 F2 0F 59 EA F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 CD F2 0F 59 CB F2 0F 58 C1 E9 71 02 00 00 90 49 3B D2 41 BB 00 00 00 00 74 0E 41 BB 01 00 00 00 F2 0F 5C D0 F2 0F 10 C2 4C 3B 15 ?? ?? ?? ?? 0F 83 20 01 00 00 F2 0F 10 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 D3 4D 8B CA 49 C1 E9 34 F2 0F 58 D5 F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 F2 0F 10 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? F2 0F 11 04 24 F2 0F 10 2D ?? ?? ?? ?? 48 8B 0C 24 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 F2 0F 10 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 F2 0F 10 C4 F2 0F 10 CD F2 0F 5C C5 48 81 F9 F2 03 00 00 0F 8D AB 00 00 00 48 81 F9 DE 03 00 00 7E 4C F2 0F 10 D0 F2 0F 59 D2 44 23 C0 75 1F F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 DA F2 0F 5C C3 E9 36 01 00 00 66 0F 1F 44 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 17 01 00 00 0F 1F 80 00 00 00 00 44 23 C0 0F 84 07 01 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 FA 00 00 00 4C 89 1C 24 48 8D 94 24 B0 00 00 00 4C 8D 84 24 A0 00 00 00 66 48 0F 7E C1 48 83 EC 20 E8 ?? ?? ?? ?? 48 83 C4 20 4C 8B 1C 24 41 B8 01 00 00 00 F2 0F 10 8C 24 B0 00 00 00 8B 84 24 A0 00 00 00 F2 0F 10 D0 F2 0F 59 D0 44 23 C0 75 4D F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 E2 F2 0F 59 E2 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 10 D8 F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 CD F2 0F 59 CB F2 0F 58 C1 EB 63 0F 1F 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 E2 F2 0F 59 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CB F2 0F 59 CC F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 C1 66 66 66 66 0F 1F 84 00 00 00 00 00 D1 E8 8B C8 41 23 C3 F7 D1 41 F7 D3 41 23 CB 0B C1 83 E0 01 75 1A F2 0F 10 D0 66 0F 57 C0 F2 0F 5C C2 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 5A C0 48 81 C4 F8 00 00 00 C3 0F 1F 40 00 E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_fdopen"
		size = 425
		refs = "0025 _errno 0053 _nhandle 006a __pioinfo 00c0 _commode 0149 _getstream 016a _cflush 0178 _unlock_file 018d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 41 54 48 83 EC 20 48 63 F1 33 C0 48 85 D2 0F 95 C0 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 58 01 00 00 83 FE FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 48 01 00 00 85 C9 0F 88 30 01 00 00 3B 35 ?? ?? ?? ?? 0F 83 24 01 00 00 48 8B CE 48 8B C6 48 C1 F8 05 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 49 8B 04 C0 0F BE 4C 08 08 41 BC 01 00 00 00 41 23 CC 0F 84 F4 00 00 00 EB 03 49 03 D4 80 3A 20 74 F8 80 3A 61 74 14 80 3A 72 74 0A 80 3A 77 74 0A E9 79 FF FF FF 41 8B FC EB 05 BF 02 00 00 00 45 8B C4 45 33 C9 45 33 D2 0B 3D ?? ?? ?? ?? 49 03 D4 8A 02 84 C0 74 67 45 85 C0 74 62 0F BE C8 83 E9 20 74 EA 83 E9 0B 74 3F 83 E9 37 74 30 FF C9 74 1E 83 E9 0B 74 0B 83 F9 06 0F 85 2E FF FF FF EB 1C 45 85 C9 75 26 45 8B CC 0F BA F7 0E EB BE 45 85 C9 75 18 45 8B CC 0F BA EF 0E EB B0 45 85 D2 75 0A 45 8B D4 EB A6 40 84 FF 79 05 45 33 C0 EB 9C 83 E7 FC 0F BA EF 07 EB 93 49 03 D4 80 3A 20 74 F8 33 C0 38 02 0F 94 C0 85 C0 0F 84 DC FE FF FF E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 38 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB 2A 44 01 25 ?? ?? ?? ?? 89 78 18 89 70 1C 48 8B C8 E8 ?? ?? ?? ?? 48 8B C3 EB 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_fdopen$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "fputc$fin$0 fputs$fin$0 fputwc$fin$0 putc$fin$0 ungetc$fin$0 ungetwc$fin$0 vfwscanf$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 38 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "vwprintf_helper"
		size = 167
		refs = "0026 __iob_func 0040 _errno 004b _invalid_parameter_noinfo 0058 _lock_file 0061 _stbuf 007e _ftbuf 0087 _unlock_file"
		altNames = "vprintf_helper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 41 54 41 55 41 56 48 83 EC 20 4D 8B E1 4D 8B E8 48 8B F2 4C 8B F1 E8 ?? ?? ?? ?? 48 8D 78 30 48 89 7C 24 48 33 C0 48 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 39 48 8B CF E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B D8 4D 8B CC 4D 8B C5 48 8B D6 48 8B CF 41 FF D6 8B F0 48 8B D7 8B CB E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 40 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5E 41 5D 41 5C C3 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "vwprintf_helper$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_freopen_helper$fin$0 _wfdopen$fin$0 fwrite$fin$0 vfprintf_helper$fin$0 vfscanf$fin$0 vfwprintf_helper$fin$0 vprintf_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 48 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "_vwprintf_l"
		size = 21
		refs = "000c _woutput_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_2_0 {
	meta:
		name = "_vprintf_l"
		size = 21
		refs = "000c _output_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_4_0 {
	meta:
		name = "_vprintf_p_l"
		size = 21
		refs = "000c _output_p_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_3_0 {
	meta:
		name = "_vprintf_s_l"
		size = 21
		refs = "000c _output_s_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_953_4_0 {
	meta:
		name = "_vscprintf_l"
		size = 21
		refs = "000c _output_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_953_6_0 {
	meta:
		name = "_vscprintf_p_l"
		size = 21
		refs = "000c _output_p_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_5_0 {
	meta:
		name = "_vscwprintf_l"
		size = 21
		refs = "000c _woutput_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_7_0 {
	meta:
		name = "_vscwprintf_p_l"
		size = 21
		refs = "000c _woutput_p_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_4_0 {
	meta:
		name = "_vwprintf_p_l"
		size = 21
		refs = "000c _woutput_p_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "_vwprintf_s_l"
		size = 21
		refs = "000c _woutput_s_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_5_0 {
	meta:
		name = "vwprintf"
		size = 21
		refs = "0009 _woutput_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_7_0 {
	meta:
		name = "_vprintf_p"
		size = 21
		refs = "0009 _output_p_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_953_3_0 {
	meta:
		name = "_vscprintf"
		size = 21
		refs = "0009 _output_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_953_5_0 {
	meta:
		name = "_vscprintf_p"
		size = 21
		refs = "0009 _output_p_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_4_0 {
	meta:
		name = "_vscwprintf"
		size = 21
		refs = "0009 _woutput_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_6_0 {
	meta:
		name = "_vscwprintf_p"
		size = 21
		refs = "0009 _woutput_p_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_7_0 {
	meta:
		name = "_vwprintf_p"
		size = 21
		refs = "0009 _woutput_p_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_5_0 {
	meta:
		name = "vprintf"
		size = 21
		refs = "0009 _output_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_6_0 {
	meta:
		name = "vprintf_s"
		size = 21
		refs = "0009 _output_s_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_6_0 {
	meta:
		name = "vwprintf_s"
		size = 21
		refs = "0009 _woutput_s_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "_set_output_format"
		size = 52
		refs = "0008 _outputformat 0015 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 1D ?? ?? ?? ?? F7 C1 FE FF FF FF 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 06 89 0D ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "vfscanf"
		size = 292
		refs = "0033 _errno 003e _invalid_parameter_noinfo 005a _lock_file 006d _fileno 0088 __pioinfo 009a __badioinfo 010a _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 54 24 10 57 41 54 41 55 48 83 EC 20 4D 8B E1 49 8B F0 48 8B DA 4C 8B E9 33 FF 33 C0 48 85 D2 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C6 00 00 00 33 C0 4D 85 C0 0F 95 C0 85 C0 74 DC 48 8B CA E8 ?? ?? ?? ?? 90 F6 43 18 40 0F 85 86 00 00 00 48 8B CB E8 ?? ?? ?? ?? 83 F8 FF 74 2A 83 F8 FE 74 25 48 63 D0 48 8B CA 48 C1 F9 05 4C 8D 05 ?? ?? ?? ?? 83 E2 1F 48 6B D2 58 49 03 14 C8 48 8D 0D ?? ?? ?? ?? EB 11 48 8D 0D ?? ?? ?? ?? 48 8B D1 4C 8D 05 ?? ?? ?? ?? F6 42 38 7F 75 25 83 F8 FF 74 1A 83 F8 FE 74 15 48 63 C8 48 8B C1 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C0 F6 41 38 80 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CF FF 85 FF 75 13 4C 8B 4C 24 60 4D 8B C4 48 8B D6 48 8B CB 41 FF D5 8B F8 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_105_6_0 {
	meta:
		name = "_W_Getdays_l"
		size = 372
		refs = "002b ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b wcslen 0071 _malloc_crt 00b6 wcscpy_s 015a _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 56 48 83 EC 50 48 8B D1 45 33 ED 48 8D 48 C8 41 8B F5 E8 ?? ?? ?? ?? 4C 8B 5C 24 30 49 8B AB 58 01 00 00 45 8D 65 07 48 8D BD 68 01 00 00 48 8B 4F 38 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 48 83 C7 08 48 03 C6 49 FF CC 48 8D 74 18 02 75 DB 48 8D 4C 36 02 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 94 00 00 00 48 8B F8 4D 8B E5 48 81 C5 A0 01 00 00 41 BE 3A 00 00 00 66 44 89 37 4C 8B 45 C8 48 83 C7 02 48 8B C7 48 8B D6 48 8B CF 48 2B C3 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 0F 85 9D 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B D6 48 8D 3C 47 66 44 89 37 4C 8B 45 00 48 83 C7 02 48 8B C7 48 8B CF 48 2B C3 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 75 52 48 8B CF E8 ?? ?? ?? ?? 49 FF C4 48 83 C5 08 48 8D 3C 47 49 83 FC 07 72 83 66 44 89 2F 44 38 6C 24 48 74 0C 48 8B 44 24 40 83 A0 C8 00 00 00 FD 4C 8D 5C 24 50 48 8B C3 49 8B 5B 20 49 8B 6B 28 49 8B 73 30 49 8B 7B 38 49 8B E3 41 5E 41 5D 41 5C C3 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_105_8_0 {
	meta:
		name = "_W_Getmonths_l"
		size = 372
		refs = "002b ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b wcslen 0071 _malloc_crt 00b6 wcscpy_s 015a _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 56 48 83 EC 50 48 8B D1 45 33 ED 48 8D 48 C8 41 8B F5 E8 ?? ?? ?? ?? 4C 8B 5C 24 30 49 8B AB 58 01 00 00 45 8D 65 0C 48 8D BD D8 01 00 00 48 8B 4F 60 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 48 83 C7 08 48 03 C6 49 FF CC 48 8D 74 18 02 75 DB 48 8D 4C 36 02 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 94 00 00 00 48 8B F8 4D 8B E5 48 81 C5 38 02 00 00 41 BE 3A 00 00 00 66 44 89 37 4C 8B 45 A0 48 83 C7 02 48 8B C7 48 8B D6 48 8B CF 48 2B C3 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 0F 85 9D 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B D6 48 8D 3C 47 66 44 89 37 4C 8B 45 00 48 83 C7 02 48 8B C7 48 8B CF 48 2B C3 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 75 52 48 8B CF E8 ?? ?? ?? ?? 49 FF C4 48 83 C5 08 48 8D 3C 47 49 83 FC 0C 72 83 66 44 89 2F 44 38 6C 24 48 74 0C 48 8B 44 24 40 83 A0 C8 00 00 00 FD 4C 8D 5C 24 50 48 8B C3 49 8B 5B 20 49 8B 6B 28 49 8B 73 30 49 8B 7B 38 49 8B E3 41 5E 41 5D 41 5C C3 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_105_10_0 {
	meta:
		name = "_W_Gettnames_l"
		size = 1091
		refs = "002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004d wcslen 0101 _malloc_crt 0128 memcpy 0154 wcscpy_s 035e _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 57 41 54 41 55 41 56 41 57 48 83 EC 50 48 8B D1 45 33 FF 48 8D 48 B8 41 8B EF E8 ?? ?? ?? ?? 4C 8B 5C 24 30 49 8B BB 58 01 00 00 45 8D 67 07 4C 8D B7 68 01 00 00 49 8B F6 48 8B 4E 38 E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 48 83 C6 08 48 03 C5 49 FF CC 48 8D 6C 18 02 75 DB 4C 8D AF D8 01 00 00 41 BC 0C 00 00 00 49 8B F5 48 8B 4E 60 E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 48 83 C6 08 48 03 C5 49 FF CC 48 8D 6C 18 02 75 DB 48 8B 8F 98 02 00 00 E8 ?? ?? ?? ?? 48 8B 8F A0 02 00 00 48 8B D8 E8 ?? ?? ?? ?? 48 8B 8F A8 02 00 00 48 03 C5 48 8D 5C 18 02 E8 ?? ?? ?? ?? 48 8B 8F B0 02 00 00 48 8D 5C 03 01 E8 ?? ?? ?? ?? 48 8B 8F B8 02 00 00 48 8D 5C 03 01 E8 ?? ?? ?? ?? 48 8D 74 03 01 48 8D 8C 36 C0 02 00 00 E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 0F 84 FE 02 00 00 48 8D 98 C0 02 00 00 41 B8 C0 02 00 00 48 8B D7 48 8B C8 4C 8B E3 E8 ?? ?? ?? ?? 4C 89 BC 24 88 00 00 00 4C 8B FD 4C 2B FF 4B 89 1C 37 4D 8B 06 48 8B C3 49 2B C4 48 8B D6 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 99 02 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8D 5C 43 02 4B 89 5C 37 38 4D 8B 46 38 48 8B C3 49 2B C4 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 4E 02 00 00 48 8B CB E8 ?? ?? ?? ?? 49 83 C6 08 48 8D 5C 43 02 48 8B 84 24 88 00 00 00 48 FF C0 48 89 84 24 88 00 00 00 48 83 F8 07 0F 82 77 FF FF FF 45 33 F6 4B 89 5C 3D 00 4D 8B 45 00 48 8B C3 49 2B C4 48 8B D6 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 DF 01 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8D 5C 43 02 4B 89 5C 3D 60 4D 8B 45 60 48 8B C3 49 2B C4 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 94 01 00 00 48 8B CB E8 ?? ?? ?? ?? 49 FF C6 49 83 C5 08 48 8D 5C 43 02 49 83 FE 0C 72 89 48 89 9D 98 02 00 00 4C 8B 87 98 02 00 00 48 8B C3 49 2B C4 48 8B D6 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 45 33 FF 85 C0 0F 85 35 01 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8D 5C 43 02 48 89 9D A0 02 00 00 4C 8B 87 A0 02 00 00 48 8B C3 49 2B C4 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 E6 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8D 5C 43 02 48 89 9D A8 02 00 00 4C 8B 87 A8 02 00 00 48 8B C3 49 2B C4 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 97 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8D 5C 43 02 48 89 9D B0 02 00 00 4C 8B 87 B0 02 00 00 48 8B C3 49 2B C4 48 8B CB 48 D1 F8 48 2B D0 E8 ?? ?? ?? ?? 85 C0 75 4C 48 8B CB E8 ?? ?? ?? ?? 48 8D 4C 43 02 48 8B C1 48 89 8D B8 02 00 00 4C 8B 87 B8 02 00 00 49 2B C4 48 D1 F8 48 2B F0 48 8B D6 E8 ?? ?? ?? ?? 85 C0 0F 84 C1 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 44 38 7C 24 48 74 0C 48 8B 44 24 40 83 A0 C8 00 00 00 FD 4C 8D 5C 24 50 48 8B C5 49 8B 5B 30 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_105_12_0 {
	meta:
		name = "?_W_store_str@@YAXPEA_WPEAPEA_WPEA_K@Z"
		size = 40
	strings:
		$1 = { 45 33 D2 EB 1C 44 0F B7 09 66 45 85 C9 74 17 48 8B 02 48 83 C1 02 66 44 89 08 48 83 02 02 49 FF 08 4D 39 10 75 DF F3 C3 }
	condition:
		$1
}

rule file_105_13_0 {
	meta:
		name = "?_W_store_number@@YAXHPEAPEA_WPEA_K@Z"
		size = 114
	strings:
		$1 = { 4C 8B 0A 4C 8B D2 44 8B D9 EB 3A B8 67 66 66 66 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 8D 0C 10 66 03 C9 66 44 2B D9 66 41 83 C3 30 66 45 89 19 49 FF 08 49 83 C1 02 44 8B DA 85 D2 7E 06 49 83 38 01 77 C0 49 8B 12 4D 89 0A 49 83 E9 02 0F B7 02 41 0F B7 09 66 41 89 01 66 89 0A 48 83 C2 02 49 83 E9 02 49 3B D1 72 E5 F3 C3 }
	condition:
		$1
}

rule file_105_14_0 {
	meta:
		name = "?_W_store_winword@@YAHPEAUlocaleinfo_struct@@HPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@@Z"
		size = 1206
		refs = "001c __security_cookie 0091 __imp_GetTimeFormatW 009c __imp_GetDateFormatW 0133 __chkstk 0154 malloc 01cb free 025e ??_C@_1M@PBPMMENC@?$AAa?$AAm?$AA?1?$AAp?$AAm?$AA?$AA@ 0266 _wcsicmp 02c3 ??_C@_17BLFJJHMM@?$AAa?$AA?1?$AAp?$AA?$AA@ 0469 ?_W_expandtime@@YAHPEAUlocaleinfo_struct@@_WPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@I@Z 049a __security_check_cookie"
	strings:
		$1 = { 40 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 70 48 8D 6C 24 40 48 89 5D 78 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 28 4C 8B A5 98 00 00 00 4C 8B B5 90 00 00 00 45 33 DB 4D 8B F9 4C 89 45 00 4C 8B E9 4C 89 65 08 48 89 4D 10 44 8B D2 4D 8B C8 85 D2 74 19 41 FF CA 74 0A 49 8B BC 24 B8 02 00 00 EB 12 49 8B BC 24 B0 02 00 00 EB 08 49 8B BC 24 A8 02 00 00 41 BA 01 00 00 00 45 39 94 24 5C 01 00 00 0F 84 F8 03 00 00 41 0F B7 40 14 4C 8B 2D ?? ?? ?? ?? 83 FA 02 4C 0F 45 2D ?? ?? ?? ?? B9 6C 07 00 00 44 89 5C 24 28 66 03 C1 41 8B 8C 24 58 01 00 00 4C 8B CF 66 89 45 18 41 0F B7 40 10 33 D2 66 41 03 C2 66 44 89 5D 26 4C 89 5C 24 20 66 89 45 1A 41 0F B7 40 0C 66 89 45 1E 41 0F B7 40 08 66 89 45 20 41 0F B7 40 04 66 89 45 22 41 0F B7 00 4C 8D 45 18 66 89 45 24 41 FF D5 45 33 DB 4C 63 E0 85 C0 0F 84 CC 00 00 00 4B 8D 4C 24 10 48 81 F9 00 04 00 00 77 38 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 45 33 DB 48 8D 5C 24 40 48 85 DB 0F 84 8E 00 00 00 C7 03 CC CC 00 00 EB 16 E8 ?? ?? ?? ?? 45 33 DB 48 8B D8 48 85 C0 74 0A C7 00 DD DD 00 00 48 83 C3 10 48 85 DB 74 67 48 8B 45 08 4C 8D 45 18 4C 8B CF 8B 88 58 01 00 00 33 D2 44 89 64 24 28 48 8B F3 48 89 5C 24 20 41 FF D5 44 8D 58 FF 33 D2 EB 1C 49 39 16 76 1C 0F B7 06 49 8B 0F 48 83 C6 02 66 89 01 49 83 07 02 49 FF 0E 41 FF CB 45 85 DB 7F DF 48 8D 4B F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 B9 02 00 00 4C 8B 6D 10 4C 8B 65 08 E9 91 02 00 00 4D 39 1E 0F 84 A0 02 00 00 41 8B DB 41 8B CB 49 8B C3 48 8B F7 48 83 C6 02 41 03 CA 49 03 C2 66 44 39 06 74 F0 41 0F B7 D0 83 FA 64 0F 8F 49 01 00 00 41 B9 64 00 00 00 41 3B D1 0F 84 0C 01 00 00 41 B9 27 00 00 00 41 3B D1 0F 84 AB 00 00 00 41 8D 41 1A 3B D0 74 1D 44 8D 48 07 41 3B D1 74 60 41 8D 41 05 3B D0 74 25 41 8D 41 19 3B D0 0F 85 D6 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 52 48 8D 77 0A EB 63 FF C9 74 22 FF C9 74 21 FF C9 74 10 FF C9 0F 85 A9 01 00 00 8D 41 42 E9 BD 01 00 00 B8 62 00 00 00 E9 B3 01 00 00 41 8B DA B8 6D 00 00 00 E9 A6 01 00 00 FF C9 74 09 FF C9 74 08 E9 7D 01 00 00 41 8B DA 41 0F B7 C1 E9 8D 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 04 48 8D 77 06 B8 70 00 00 00 E9 6C 01 00 00 41 84 CA 74 41 48 8D 3C 47 0F B7 0F 66 85 C9 0F 84 99 01 00 00 4D 39 1E 0F 84 7E 01 00 00 48 83 C7 02 66 41 3B C9 0F 84 70 01 00 00 49 8B 07 66 89 08 49 83 07 02 49 FF 0E 0F B7 0F 66 85 C9 75 D4 E9 56 01 00 00 48 63 C1 48 8D 3C 47 E9 4A 01 00 00 FF C9 0F 84 79 FF FF FF FF C9 0F 84 74 FF FF FF FF C9 74 10 FF C9 0F 85 E2 00 00 00 8D 41 41 E9 F6 00 00 00 B8 61 00 00 00 E9 EC 00 00 00 83 EA 68 0F 84 BF 00 00 00 83 EA 05 0F 84 A2 00 00 00 83 EA 06 0F 84 85 00 00 00 FF CA 74 29 83 FA 05 0F 85 A8 00 00 00 83 F9 02 74 11 83 F9 04 0F 85 9A 00 00 00 8D 42 54 E9 AE 00 00 00 B8 79 00 00 00 E9 A4 00 00 00 41 83 79 08 0B 7F 0A 49 8B 94 24 98 02 00 00 EB 08 49 8B 94 24 A0 02 00 00 41 3B CA 75 2D 4D 39 1E 76 28 49 8B 0F 0F B7 02 66 89 01 49 83 07 02 49 FF 0E EB 1E 4D 39 1E 76 19 49 8B 07 48 83 C2 02 66 89 08 49 83 07 02 49 FF 0E 0F B7 0A 66 85 C9 75 E2 48 8B FE EB 7C FF C9 74 06 FF C9 74 05 EB 26 41 8B DA B8 53 00 00 00 EB 38 FF C9 74 06 FF C9 74 05 EB 12 41 8B DA B8 4D 00 00 00 EB 24 FF C9 74 18 FF C9 74 17 49 8B 07 48 83 C7 02 66 44 89 00 49 83 07 02 49 FF 0E EB 38 41 8B DA B8 49 00 00 00 4C 8B 45 00 89 5C 24 30 4D 8B CF 0F B7 D0 49 8B CD 4C 89 64 24 28 4C 89 74 24 20 E8 ?? ?? ?? ?? 45 33 DB 85 C0 74 3E 48 8B FE 41 BA 01 00 00 00 4C 8B 4D 00 44 0F B7 07 66 45 85 C0 0F 85 57 FD FF FF 41 8B C2 48 8B 4D 28 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 78 48 8D 65 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 33 C0 EB DC }
	condition:
		$1
}

rule file_105_15_0 {
	meta:
		name = "?_W_store_num@@YAXHHPEAPEA_WPEA_KI@Z"
		size = 239
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 45 33 DB 8B D9 44 39 5C 24 28 74 68 4D 8B 10 EB 36 B8 67 66 66 66 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 8D 0C 10 66 03 C9 66 2B D9 66 83 C3 30 66 41 89 1A 49 FF 09 49 83 C2 02 8B DA 85 D2 7E 06 49 83 39 01 77 C4 49 8B 10 4D 89 10 49 83 EA 02 0F B7 02 41 0F B7 0A 66 41 89 02 66 89 0A 48 83 C2 02 49 83 EA 02 49 3B D2 72 E5 EB 66 48 63 C2 49 3B 01 73 5B FF CA 48 63 C2 44 8D 52 01 45 85 D2 74 3E 48 8D 3C 00 B8 67 66 66 66 41 FF C3 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 8D 0C 10 49 8B 00 66 03 C9 66 2B D9 66 83 C3 30 66 89 1C 07 48 83 EF 02 41 FF CA 8B DA 75 C6 49 63 CB 48 8D 04 09 49 01 00 49 29 09 EB 03 4D 21 19 48 8B 5C 24 08 48 8B 7C 24 10 C3 }
	condition:
		$1
}

rule file_105_16_0 {
	meta:
		name = "?_W_expandtime@@YAHPEAUlocaleinfo_struct@@_WPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@I@Z"
		size = 1764
		refs = "0207 ?_W_store_winword@@YAHPEAUlocaleinfo_struct@@HPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@@Z 03b6 ?_W_store_num@@YAXHHPEAPEA_WPEA_KI@Z 0532 __tzset 053e __tzname 056f _mbstowcs_s_l 05a2 _invoke_watson 06b4 _errno 06bf _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 56 48 83 EC 40 44 0F B7 D2 49 8B F9 49 8B F0 48 8B E9 41 BE 01 00 00 00 41 83 FA 59 0F 8F E4 02 00 00 0F 84 91 02 00 00 41 83 FA 49 0F 8F 6D 01 00 00 0F 84 2D 01 00 00 41 83 EA 04 0F 84 54 06 00 00 41 83 EA 09 0F 84 4A 06 00 00 41 83 EA 18 0F 84 F0 00 00 00 41 83 EA 1C 0F 84 85 00 00 00 41 FF CA 74 21 41 8D 4E 05 44 3B D1 0F 85 39 06 00 00 41 8B 48 08 85 C9 0F 88 1D 06 00 00 83 F9 17 E9 F6 02 00 00 33 DB 41 39 58 10 0F 8C 09 06 00 00 41 83 78 10 0B 0F 8F FE 05 00 00 49 63 48 10 48 8B 84 24 88 00 00 00 48 8B 94 C8 38 02 00 00 48 8B 8C 24 80 00 00 00 EB 20 44 0F B7 02 66 45 85 C0 0F 84 CD 05 00 00 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 FF 09 48 39 19 75 DB E9 B1 05 00 00 33 DB 41 39 58 18 0F 8C AA 05 00 00 8D 4B 06 41 39 48 18 0F 8F 9D 05 00 00 49 63 48 18 48 8B 84 24 88 00 00 00 48 8B 94 C8 A0 01 00 00 48 8B 8C 24 80 00 00 00 EB 20 44 0F B7 02 66 45 85 C0 0F 84 6C 05 00 00 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 FF 09 48 39 19 75 DB E9 50 05 00 00 49 8B 01 B9 25 00 00 00 66 89 08 48 8B 84 24 80 00 00 00 49 83 01 02 48 FF 08 E9 31 05 00 00 41 8B 48 08 85 C9 0F 88 2A 05 00 00 83 F9 17 0F 8F 21 05 00 00 B8 AB AA AA 2A F7 E9 D1 FA 8B C2 C1 E8 1F 03 D0 8D 04 52 C1 E0 02 2B C8 B8 0C 00 00 00 0F 44 C8 E9 E3 01 00 00 41 83 EA 4D 0F 84 FC 00 00 00 B9 06 00 00 00 44 2B D1 0F 84 D2 00 00 00 41 83 EA 02 74 62 41 83 EA 02 74 3D 41 FF CA 0F 85 DF 04 00 00 48 8B 84 24 88 00 00 00 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 BA 02 00 00 00 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 9B 04 00 00 E9 AB 04 00 00 41 8B 40 18 33 DB 85 C0 0F 88 8D 04 00 00 3B C1 0F 8F 85 04 00 00 85 C0 74 1F 8D 48 FF EB 1A 33 DB 41 39 58 18 0F 8C 70 04 00 00 41 39 48 18 0F 8F 66 04 00 00 41 8B 48 18 41 39 58 1C 0F 8C 58 04 00 00 41 81 78 1C 6D 01 00 00 0F 8F 4A 04 00 00 41 39 48 1C 7C 2B 45 8B 40 1C B8 93 24 49 92 41 F7 E8 41 03 D0 C1 FA 02 8B C2 C1 E8 1F 03 D0 8B C2 8B DA 6B C0 07 44 2B C0 44 3B C1 7C 03 41 03 DE 8B CB E9 F9 00 00 00 33 DB 41 39 18 0F 8C 07 04 00 00 41 83 38 3B 0F 8F FD 03 00 00 8B 0E E9 DD 00 00 00 41 8B 48 04 85 C9 0F 88 EA 03 00 00 83 F9 3B E9 C3 00 00 00 41 81 78 14 94 F8 FF FF 0F 8C D4 03 00 00 41 81 78 14 A3 1F 00 00 0F 8F C6 03 00 00 45 8B 40 14 B8 1F 85 EB 51 41 F7 E8 C1 FA 05 8B C2 C1 E8 1F 03 D0 8B C2 8D 4A 13 BA 04 00 00 00 6B C0 64 44 2B C0 6B C9 64 41 03 C8 E9 81 00 00 00 41 83 FA 6D 0F 8F DE 01 00 00 0F 84 BC 01 00 00 41 83 EA 5A 0F 84 F9 01 00 00 41 83 EA 07 0F 84 47 01 00 00 41 FF CA 0F 84 DF 00 00 00 41 FF CA 74 6F 41 FF CA 74 2F B9 06 00 00 00 44 3B D1 0F 85 60 03 00 00 41 8B 48 1C 85 C9 0F 88 44 03 00 00 81 F9 6D 01 00 00 0F 8F 38 03 00 00 FF C1 BA 03 00 00 00 EB 1B 41 8B 48 0C 41 3B CE 0F 8C 22 03 00 00 83 F9 1F 0F 8F 19 03 00 00 BA 02 00 00 00 8B 84 24 90 00 00 00 4C 8B 8C 24 80 00 00 00 4C 8B C7 89 44 24 20 E8 ?? ?? ?? ?? E9 EF 02 00 00 4C 8B AC 24 88 00 00 00 4C 8B A4 24 80 00 00 00 33 DB 4C 89 6C 24 28 4C 89 64 24 20 39 9C 24 90 00 00 00 74 42 41 8B D6 E8 ?? ?? ?? ?? 85 C0 0F 84 CF 02 00 00 49 39 1C 24 0F 84 C5 02 00 00 48 8B 07 B9 20 00 00 00 4C 89 6C 24 28 66 89 08 48 83 07 02 49 FF 0C 24 4C 89 64 24 20 4C 8B CF 4C 8B C6 E9 D8 FD FF FF 33 D2 EB BD 33 DB 41 39 58 10 0F 8C 7D 02 00 00 41 83 78 10 0B 0F 8F 72 02 00 00 49 63 48 10 48 8B 84 24 88 00 00 00 48 8B 94 C8 D8 01 00 00 48 8B 8C 24 80 00 00 00 EB 20 44 0F B7 02 66 45 85 C0 0F 84 41 02 00 00 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 FF 09 48 39 19 75 DB E9 25 02 00 00 33 DB 41 39 58 18 0F 8C 1E 02 00 00 8D 4B 06 41 39 48 18 0F 8F 11 02 00 00 49 63 48 18 48 8B 84 24 88 00 00 00 48 8B 94 C8 68 01 00 00 48 8B 8C 24 80 00 00 00 EB 20 44 0F B7 02 66 45 85 C0 0F 84 E0 01 00 00 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 FF 09 48 39 19 75 DB E9 C4 01 00 00 41 8B 48 10 85 C9 0F 88 BD 01 00 00 83 F9 0B 0F 8F B4 01 00 00 FF C1 E9 94 FE FF FF 41 83 EA 70 0F 84 16 01 00 00 41 83 EA 07 0F 84 E8 00 00 00 41 FF CA 0F 84 AB 00 00 00 41 FF CA 74 7F 41 FF CA 0F 85 92 01 00 00 E8 ?? ?? ?? ?? 33 DB 48 89 5C 24 30 E8 ?? ?? ?? ?? 39 5E 20 48 8B B4 24 80 00 00 00 48 8B 17 44 8B CB 4C 8B 06 41 0F 95 C1 48 8D 4C 24 30 4E 8B 0C C8 48 89 6C 24 28 48 83 4C 24 20 FF E8 ?? ?? ?? ?? 85 C0 75 1B 48 8B 4C 24 30 48 8D 44 09 FE 48 01 07 49 8B C6 48 2B C1 48 01 06 E9 1C 01 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 5C 24 20 E8 ?? ?? ?? ?? CC 41 8B 48 14 85 C9 0F 88 00 01 00 00 B8 1F 85 EB 51 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B D2 64 2B CA E9 CC FD FF FF 48 8B 84 24 88 00 00 00 33 DB 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 39 9C 24 90 00 00 00 74 08 41 8B D6 E9 0B FC FF FF 33 D2 E9 04 FC FF FF 33 DB 41 39 58 18 0F 8C A5 00 00 00 8D 4B 06 41 39 48 18 0F 8F 98 00 00 00 8B 4E 18 41 8B D6 E9 79 FD FF FF 33 DB 41 39 58 08 0F 8C 81 00 00 00 41 83 78 08 17 7F 7A 41 83 78 08 0B 48 8B 84 24 88 00 00 00 7F 34 48 8B 90 98 02 00 00 48 8B 8C 24 80 00 00 00 EB 1C 44 0F B7 02 66 45 85 C0 74 4B 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 FF 09 48 39 19 75 DF EB 32 4C 8B 80 A0 02 00 00 48 8B 94 24 80 00 00 00 EB 1C 45 0F B7 08 66 45 85 C9 74 17 48 8B 0F 49 83 C0 02 66 44 89 09 48 83 07 02 48 FF 0A 48 39 1A 75 DF 41 8B C6 EB 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 40 41 5E 41 5D 41 5C C3 }
	condition:
		$1
}

rule file_105_17_0 {
	meta:
		name = "_Wcsftime_l"
		size = 423
		refs = "003e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00fd ?_W_expandtime@@YAHPEAUlocaleinfo_struct@@_WPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@I@Z 015a _errno 0172 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 48 89 48 08 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 48 8B FA 48 8B 55 58 4C 8B E9 48 8D 4D D8 45 33 FF 4D 8B F1 49 8B D8 45 8B E7 E8 ?? ?? ?? ?? 4C 8B 5D 30 4D 85 DB 0F 84 17 01 00 00 48 85 FF 0F 84 0E 01 00 00 66 45 89 3B 48 85 DB 0F 84 01 01 00 00 48 8B 75 50 48 85 F6 75 0B 48 8B 45 D8 48 8B B0 58 01 00 00 48 8B C7 48 89 45 D0 48 85 FF 0F 84 C0 00 00 00 48 8B 4D 30 0F B7 13 85 D2 0F 84 82 00 00 00 83 FA 25 74 20 66 89 11 48 8B 4D 30 48 8B 45 D0 48 83 C1 02 48 83 C3 02 48 FF C8 48 89 45 D0 48 89 4D 30 EB 54 4D 85 F6 0F 84 A0 00 00 00 48 83 C3 02 41 8B C7 66 83 3B 23 75 09 B8 01 00 00 00 48 83 C3 02 0F B7 13 89 44 24 30 48 8D 45 D0 4C 8D 4D 30 48 8D 4D D8 4D 8B C6 48 89 74 24 28 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 38 48 8B 4D 30 48 8B 45 D0 48 83 C3 02 48 85 C0 0F 85 73 FF FF FF 48 85 C0 74 2A 66 44 89 39 48 2B 7D D0 44 38 7D F0 74 0B 48 8B 4D E8 83 A1 C8 00 00 00 FD 48 8B C7 EB 4C 4C 39 7D D0 76 06 41 BC 01 00 00 00 66 45 89 7D 00 45 85 E4 75 13 4C 39 7D D0 77 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 7D F0 74 0B 48 8B 45 E8 83 A0 C8 00 00 00 FD 33 C0 4C 8D 5C 24 70 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_105_18_0 {
	meta:
		name = "_Wcsftime"
		size = 30
		refs = "0015 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_721_20_0 {
	meta:
		name = "_Strftime"
		size = 30
		refs = "0015 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_846_7_0 {
	meta:
		name = "mbstowcs_s"
		size = 30
		refs = "0015 _mbstowcs_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_155_8_0 {
	meta:
		name = "wcstombs_s"
		size = 30
		refs = "0015 _wcstombs_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_105_19_0 {
	meta:
		name = "_wcsftime_l"
		size = 30
		refs = "0015 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_721_18_0 {
	meta:
		name = "_strftime_l"
		size = 30
		refs = "0015 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_6_0 {
	meta:
		name = "_vsnprintf_s"
		size = 30
		refs = "0015 _vsnprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_6_0 {
	meta:
		name = "_vsnwprintf_s"
		size = 30
		refs = "0015 _vsnwprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_105_20_0 {
	meta:
		name = "wcsftime"
		size = 26
		refs = "0011 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 28 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_721_19_0 {
	meta:
		name = "strftime"
		size = 26
		refs = "0011 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 28 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "frexp"
		size = 228
		refs = "0022 _errno 002d _invalid_parameter_noinfo 0045 _ctrlfp 0066 _sptype 0083 _handle_qnan1 008d _d_ind 00a3 _except1 00b1 __real@3ff0000000000000 00bb _decomp"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 40 0F 29 74 24 30 48 8B DA 66 0F 28 F0 48 85 D2 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 66 0F 57 C0 E9 9A 00 00 00 BA C0 FF 00 00 B9 80 1F 00 00 E8 ?? ?? ?? ?? 0F B7 4C 24 56 66 0F 28 C6 48 8B F8 B8 F0 7F 00 00 66 23 C8 66 3B C8 75 55 83 0B FF E8 ?? ?? ?? ?? 85 C0 7E 3B 83 F8 02 7E 16 83 F8 03 75 31 8D 48 14 66 0F 28 CE 4C 8B C7 E8 ?? ?? ?? ?? EB 4B F2 0F 10 1D ?? ?? ?? ?? BA 17 00 00 00 66 0F 28 D6 48 89 7C 24 20 8D 4A F1 E8 ?? ?? ?? ?? EB 2B 66 0F 28 DE F2 0F 58 1D ?? ?? ?? ?? EB DA 48 8B D3 E8 ?? ?? ?? ?? BA C0 FF 00 00 48 8B CF 66 0F 28 F0 E8 ?? ?? ?? ?? 66 0F 28 C6 48 8B 5C 24 58 0F 28 74 24 30 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "_fsopen"
		size = 213
		refs = "0030 _errno 003b _invalid_parameter_noinfo 005b _getstream 0096 _local_unwind 00ad _openfile 00b8 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 41 54 48 83 EC 30 48 89 64 24 20 45 8B E0 48 8B FA 48 8B F1 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 7C 33 C0 48 85 D2 0F 95 C0 85 C0 74 E0 33 C0 38 02 0F 95 C0 85 C0 74 D5 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 40 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB C6 80 3E 00 75 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 8D 15 0C 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 90 33 C0 EB 1F 4C 8B C8 45 8B C4 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5C C3 }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "_fsopen$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "fwprintf$fin$0 setvbuf$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "fopen_s"
		size = 83
		refs = "0015 _errno 0021 _invalid_parameter_noinfo 0036 _fsopen"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 4C 8B CA 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 24 41 B8 80 00 00 00 48 8B D0 49 8B C9 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_307_3_0 {
	meta:
		name = "_wfopen_s"
		size = 83
		refs = "0015 _errno 0021 _invalid_parameter_noinfo 0036 _wfsopen"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 4C 8B CA 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 24 41 B8 80 00 00 00 48 8B D0 49 8B C9 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_111_8_0 {
	meta:
		name = "_vcwprintf_s_l"
		size = 2827
		refs = "0022 __security_cookie 0061 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0073 _errno 007e _invalid_parameter_noinfo 00f2 __lookuptable_s 0233 __nullstring 023b strlen 0297 _isleadbyte_l 0341 _mbtowc_l 0405 __wnullstring 048f _get_printf_count_output 060e _malloc_crt 0634 _cfltcvt_tab 064e __imp_DecodePointer 0742 write_multi_char 0753 write_string 07b3 _putwch_nolock 0833 free 0896 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 30 FC FF FF 48 81 EC D0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 C0 03 00 00 33 C0 48 89 4C 24 78 48 8D 4D 88 4D 8B F0 4C 89 44 24 50 89 44 24 70 44 8B E0 89 44 24 58 8B F8 89 44 24 48 89 44 24 4C 89 44 24 6C 89 44 24 44 E8 ?? ?? ?? ?? 48 8B 54 24 78 45 33 D2 48 85 D2 75 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 45 33 DB 44 38 5D A0 74 0B 48 8B 45 98 83 A0 C8 00 00 00 FD 83 C8 FF E9 ED 07 00 00 44 0F B7 2A 41 8B F2 44 89 54 24 40 45 8B FA 45 8B C2 4C 89 55 A8 66 45 85 ED 0F 84 BA 07 00 00 48 8B 5D B0 B9 58 00 00 00 41 B9 00 02 00 00 44 8D 59 C8 48 83 C2 02 48 89 54 24 78 85 F6 0F 88 87 07 00 00 41 0F B7 C5 66 41 2B C3 66 3B C1 77 15 48 8D 0D ?? ?? ?? ?? 41 0F B7 C5 0F B6 4C 08 E0 83 E1 0F EB 03 41 8B CA 48 63 C1 48 8D 0C C0 49 63 C0 48 03 C8 48 8D 05 ?? ?? ?? ?? 44 0F B6 04 01 41 C1 E8 04 44 89 44 24 5C 41 83 F8 08 0F 84 3F FF FF FF 41 8B C8 45 85 C0 0F 84 5A 08 00 00 FF C9 0F 84 96 09 00 00 FF C9 0F 84 2E 09 00 00 FF C9 0F 84 DB 08 00 00 FF C9 0F 84 C6 08 00 00 FF C9 0F 84 7A 08 00 00 FF C9 0F 84 46 07 00 00 FF C9 0F 85 DF 06 00 00 41 0F B7 C5 B9 64 00 00 00 3B C1 0F 8F 0E 02 00 00 0F 84 2D 03 00 00 83 F8 41 0F 84 CC 01 00 00 83 F8 43 0F 84 51 01 00 00 83 F8 45 0F 84 BA 01 00 00 83 F8 47 0F 84 B1 01 00 00 83 F8 53 0F 84 8C 00 00 00 83 F8 58 0F 84 77 02 00 00 83 F8 5A 74 17 83 F8 61 0F 84 9C 01 00 00 83 F8 63 0F 84 22 01 00 00 E9 D4 00 00 00 49 8B 06 49 83 C6 08 4C 89 74 24 50 48 85 C0 74 3F 48 8B 58 08 48 85 DB 74 36 BF 2D 00 00 00 41 0F BA E4 0B 73 19 0F BF 00 44 8D 6F D4 99 44 89 6C 24 44 2B C2 D1 F8 44 8B F8 E9 9F 00 00 00 44 0F BF 38 45 8B EA 44 89 54 24 44 E9 8E 00 00 00 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 4C 8B F8 EB 6D 41 F7 C4 30 08 00 00 75 03 45 0B E3 83 7C 24 48 FF 49 8B 1E B8 FF FF FF 7F 0F 44 F8 49 83 C6 08 4C 89 74 24 50 45 84 E3 0F 84 83 01 00 00 48 85 DB 45 8B FA 48 0F 44 1D ?? ?? ?? ?? 48 8B F3 85 FF 7E 26 44 38 16 74 21 0F B6 0E 48 8D 55 88 E8 ?? ?? ?? ?? 45 33 D2 85 C0 74 03 48 FF C6 41 FF C7 48 FF C6 44 3B FF 7C DA 8B 74 24 40 44 8B 6C 24 44 BF 2D 00 00 00 44 39 54 24 6C 0F 85 57 05 00 00 41 F6 C4 40 0F 84 4A 04 00 00 41 0F BA E4 08 0F 83 11 04 00 00 66 89 7C 24 64 BF 01 00 00 00 89 7C 24 4C E9 30 04 00 00 41 F7 C4 30 08 00 00 75 03 45 0B E3 41 0F B7 06 49 83 C6 08 41 BD 01 00 00 00 66 89 44 24 60 44 89 6C 24 44 4C 89 74 24 50 45 84 E3 74 34 88 44 24 68 48 8B 45 88 44 88 54 24 69 4C 63 80 0C 01 00 00 4C 8D 4D 88 48 8D 54 24 68 48 8D 4D C0 E8 ?? ?? ?? ?? 45 33 D2 85 C0 79 0B 44 89 6C 24 6C EB 04 66 89 45 C0 48 8D 5D C0 45 8B FD E9 56 FF FF FF C7 45 80 01 00 00 00 66 45 03 EB B9 67 00 00 00 41 83 CC 40 48 8D 5D C0 41 8B F1 85 FF 0F 89 55 02 00 00 41 BF 06 00 00 00 44 89 7C 24 48 E9 98 02 00 00 83 F8 65 0F 8C 15 FF FF FF B9 67 00 00 00 3B C1 7E CB B9 69 00 00 00 3B C1 0F 84 06 01 00 00 83 F8 6E 0F 84 C4 00 00 00 B9 6F 00 00 00 3B C1 0F 84 A1 00 00 00 83 F8 70 74 61 83 F8 73 0F 84 7A FE FF FF B9 75 00 00 00 3B C1 0F 84 D9 00 00 00 B9 78 00 00 00 3B C1 0F 85 C1 FE FF FF 8D 41 AF EB 48 48 85 DB 41 BD 01 00 00 00 48 0F 44 1D ?? ?? ?? ?? 44 89 6C 24 44 48 8B C3 EB 0C FF CF 66 44 39 10 74 08 48 83 C0 02 85 FF 75 F0 48 2B C3 48 D1 F8 44 8B F8 E9 88 FE FF FF BF 10 00 00 00 41 0F BA EC 0F B8 07 00 00 00 89 44 24 70 41 B9 10 00 00 00 41 BD 00 02 00 00 45 84 E4 79 76 41 8D 49 20 66 83 C0 51 8D 51 D2 66 89 4C 24 64 66 89 44 24 66 EB 63 41 B9 08 00 00 00 45 84 E4 79 4E 41 BD 00 02 00 00 45 0B E5 EB 49 49 8B 3E 49 83 C6 08 4C 89 74 24 50 E8 ?? ?? ?? ?? 45 33 D2 85 C0 0F 84 D4 FB FF FF 45 8D 5A 20 45 84 E3 74 05 66 89 37 EB 02 89 37 C7 44 24 6C 01 00 00 00 E9 6B 03 00 00 41 83 CC 40 41 B9 0A 00 00 00 41 BD 00 02 00 00 8B 54 24 4C B8 00 80 00 00 44 85 E0 74 09 4D 8B 06 49 83 C6 08 EB 39 41 0F BA E4 0C 72 F0 49 83 C6 08 45 84 E3 74 19 4C 89 74 24 50 41 F6 C4 40 74 07 4D 0F BF 46 F8 EB 1C 45 0F B7 46 F8 EB 15 41 F6 C4 40 74 06 4D 63 46 F8 EB 04 45 8B 46 F8 4C 89 74 24 50 41 F6 C4 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EC 08 44 85 E0 75 0A 41 0F BA E4 0C 72 03 45 8B C0 85 FF 79 07 BF 01 00 00 00 EB 0B 41 83 E4 F7 41 3B FD 41 0F 4F FD 8B 74 24 70 49 8B C0 48 8D 9D BF 01 00 00 48 F7 D8 1B C9 23 CA 89 4C 24 4C 8B CF FF CF 85 C9 7F 05 4D 85 C0 74 1F 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 02 03 C6 88 03 48 FF CB EB D4 8B 74 24 40 48 8D 85 BF 01 00 00 89 7C 24 48 2B C3 48 FF C3 44 8B F8 45 85 E5 0F 84 F7 FC FF FF 85 C0 B8 30 00 00 00 74 08 38 03 0F 84 E6 FC FF FF 48 FF CB 41 FF C7 88 03 E9 D9 FC FF FF 75 11 66 44 3B E9 75 41 41 BF 01 00 00 00 E9 9E FD FF FF 41 3B F9 41 BF A3 00 00 00 41 0F 4F F9 89 7C 24 48 41 3B FF 7E 27 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 48 89 45 A8 48 85 C0 0F 84 6D FD FF FF 48 8B D8 8B F7 44 8B 7C 24 48 EB 03 44 8B FF 49 8B 06 48 8B 0D ?? ?? ?? ?? 49 83 C6 08 4C 89 74 24 50 41 0F BE FD 48 63 F6 48 89 45 B0 FF 15 ?? ?? ?? ?? 48 8D 4D 88 48 89 4C 24 30 8B 4D 80 44 8B CF 89 4C 24 28 48 8D 4D B0 4C 8B C6 48 8B D3 44 89 7C 24 20 FF D0 41 8B FC 81 E7 80 00 00 00 74 1B 45 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 88 48 8B CB FF D0 B9 67 00 00 00 66 44 3B E9 75 1A 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 88 48 8B CB FF D0 BF 2D 00 00 00 40 38 3B 75 08 41 0F BA EC 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 8B 74 24 40 44 8B 6C 24 44 44 8B F8 45 33 D2 E9 CF FB FF FF 41 F6 C4 01 74 0F B8 2B 00 00 00 66 89 44 24 64 E9 DF FB FF FF 41 F6 C4 02 74 13 B8 20 00 00 00 66 89 44 24 64 8D 78 E1 89 7C 24 4C EB 09 8B 7C 24 4C B8 20 00 00 00 44 8B 74 24 58 45 2B F7 44 2B F7 41 F6 C4 0C 75 0F 4C 8D 44 24 40 8B C8 41 8B D6 E8 ?? ?? ?? ?? 4C 8D 44 24 40 48 8D 4C 24 64 8B D7 E8 ?? ?? ?? ?? 41 F6 C4 08 74 18 41 F6 C4 04 75 12 4C 8D 44 24 40 B9 30 00 00 00 41 8B D6 E8 ?? ?? ?? ?? 45 85 ED 75 67 45 85 FF 7E 62 48 8B FB 41 8B F7 48 8B 45 88 4C 8D 4D 88 48 8D 4C 24 60 4C 63 80 0C 01 00 00 48 8B D7 FF CE E8 ?? ?? ?? ?? 45 33 D2 4C 63 E8 85 C0 7E 2B 0F B7 4C 24 60 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 07 83 4C 24 40 FF EB 04 FF 44 24 40 49 03 FD 45 33 D2 85 F6 7F AF EB 1C 83 CE FF 89 74 24 40 EB 17 4C 8D 44 24 40 41 8B D7 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 8B 74 24 40 85 F6 78 1F 41 F6 C4 04 74 19 4C 8D 44 24 40 B9 20 00 00 00 41 8B D6 E8 ?? ?? ?? ?? 8B 74 24 40 45 33 D2 4C 8B 74 24 50 41 BB 20 00 00 00 48 8B 45 A8 48 85 C0 74 13 48 8B C8 E8 ?? ?? ?? ?? 45 33 D2 45 8D 5A 20 4C 89 55 A8 44 8B 44 24 5C 48 8B 54 24 78 8B 7C 24 48 41 B9 00 02 00 00 B9 58 00 00 00 44 0F B7 2A 66 45 85 ED 0F 85 68 F8 FF FF 45 85 C0 74 0A 41 83 F8 07 0F 85 FA F7 FF FF 44 38 55 A0 74 0B 48 8B 4D 98 83 A1 C8 00 00 00 FD 8B C6 48 8B 8D C0 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 18 05 00 00 48 81 C4 D0 04 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 41 0F B7 C5 83 F8 49 74 4B 83 F8 68 74 3E B9 6C 00 00 00 3B C1 74 14 B9 58 00 00 00 83 F8 77 75 85 41 0F BA EC 0B E9 7B FF FF FF 66 39 0A B9 58 00 00 00 75 0E 48 83 C2 02 41 0F BA EC 0C E9 63 FF FF FF 41 83 CC 10 E9 5A FF FF FF 45 0B E3 E9 4D FF FF FF 41 0F BA EC 0F 66 83 3A 36 75 15 66 83 7A 02 34 75 0E 48 83 C2 04 41 0F BA EC 0F E9 2D FF FF FF 66 83 3A 33 75 15 66 83 7A 02 32 75 0E 48 83 C2 04 41 0F BA F4 0F E9 12 FF FF FF B8 64 00 00 00 66 39 02 0F 84 04 FF FF FF B8 69 00 00 00 66 39 02 0F 84 F6 FE FF FF B8 6F 00 00 00 66 39 02 0F 84 E8 FE FF FF B8 75 00 00 00 8D 48 E3 66 39 02 0F 84 DC FE FF FF 8D 41 20 66 39 02 0F 84 D0 FE FF FF 66 39 0A 0F 84 C7 FE FF FF 44 89 54 24 5C 41 0F B7 CD C7 44 24 44 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 54 24 78 44 8B 44 24 5C B9 FF FF 00 00 41 BB 20 00 00 00 41 B9 00 02 00 00 66 3B C1 41 8D 4B 38 0F 85 32 01 00 00 83 CE FF 89 74 24 40 45 33 D2 E9 7A FE FF FF 66 41 83 FD 2A 75 29 41 8B 3E 49 83 C6 08 B9 58 00 00 00 4C 89 74 24 50 89 7C 24 48 85 FF 0F 89 56 FE FF FF 83 CF FF 89 7C 24 48 E9 4A FE FF FF 8D 0C BF 41 0F B7 C5 8D 7C 48 D0 89 7C 24 48 E9 31 FE FF FF 41 8B FA 44 89 54 24 48 E9 24 FE FF FF 66 41 83 FD 2A 75 2C 41 8B 06 49 83 C6 08 B9 58 00 00 00 4C 89 74 24 50 89 44 24 58 85 C0 0F 89 05 FE FF FF 41 83 CC 04 F7 D8 89 44 24 58 E9 F6 FD FF FF 8B 44 24 58 8D 0C 80 41 0F B7 C5 8D 44 48 D0 89 44 24 58 E9 D9 FD FF FF 41 0F B7 C5 41 3B C3 74 4E 83 F8 23 74 3F B9 2B 00 00 00 3B C1 74 2D B9 2D 00 00 00 3B C1 74 1B B9 30 00 00 00 3B C1 B9 58 00 00 00 0F 85 AC FD FF FF 41 83 CC 08 E9 A3 FD FF FF 41 83 CC 04 E9 95 FD FF FF 41 83 CC 01 E9 8C FD FF FF 41 0F BA EC 07 E9 82 FD FF FF 41 83 CC 02 E9 79 FD FF FF 83 CF FF 44 89 55 80 44 89 54 24 6C 44 89 54 24 58 44 89 54 24 4C 45 8B E2 89 7C 24 48 44 89 54 24 44 E9 52 FD FF FF FF C6 E9 CA FE FF FF }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "scaleDouble_2"
		size = 73
	strings:
		$1 = { 8B C2 44 8B C2 66 0F 28 D0 99 2B C2 BA FF 03 00 00 D1 F8 48 63 C8 44 2B C0 48 03 CA 49 63 C0 48 C1 E1 34 48 03 C2 48 89 4C 24 08 48 C1 E0 34 F2 0F 10 44 24 08 48 89 44 24 08 F2 0F 59 C2 F2 0F 10 4C 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_112_3_0 {
	meta:
		name = "val_with_flags"
		size = 37
		refs = "0013 _controlfp_s"
	strings:
		$1 = { 48 83 EC 38 44 8B C2 33 C9 0F 29 74 24 20 66 0F 28 F0 E8 ?? ?? ?? ?? 66 0F 28 C6 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "infinity_with_flags"
		size = 42
		refs = "000c _controlfp_s"
	strings:
		$1 = { 48 83 EC 28 44 8B C1 8B D1 33 C9 E8 ?? ?? ?? ?? 49 BB 00 00 00 00 00 00 F0 7F 4C 89 5C 24 38 F2 0F 10 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_112_6_0 {
	meta:
		name = "cosh"
		size = 962
		refs = "0056 __real@3ff0000000000000 006a _controlfp_s 00bc ??_C@_04HPJJNFIM@cosh?$AA@ 00c6 _handle_error 0100 __mask@@NegDouble@ 0109 ?max_cosh_arg@?1??cosh@@9@9 014a ?small_threshold@?1??cosh@@9@9 0158 ?log2_by_32_tail@?1??cosh@@9@9 0160 ?log2_by_32_lead@?1??cosh@@9@9 0168 ?thirtytwo_by_log2@?1??cosh@@9@9 01a7 splitexp 026d __ImageBase 027c ?cosh_tail@?1??cosh@@9@9 0285 ?cosh_lead@?1??cosh@@9@9 028e ?sinh_lead@?1??cosh@@9@9 02b5 __real@3da9984b7f63fcd7 02bd __real@3d6b4125921ea08b 02ca __real@3e21ee56385b7b20 02d2 __real@3de611cb2bdcb7be 02e2 __real@3e927e5069f1cb55 02ea __real@3e5ae6460fbe61c0 02fa __real@3efa01a019079011 0302 __real@3ec71de3a4e13e7d 0312 __real@3f56c16c16c212e5 031a __real@3f2a01a01a01ee80 032a __real@3fa5555555555502 0332 __real@3f811111111110fd 0342 __real@3fe0000000000000 034a __real@3fc5555555555555 035b ?sinh_tail@?1??cosh@@9@9"
	strings:
		$1 = { 40 53 48 81 EC 80 00 00 00 48 BA FF FF FF FF FF FF FF 7F 0F 29 74 24 70 F2 0F 11 84 24 A8 00 00 00 48 8B 8C 24 A8 00 00 00 0F 29 7C 24 60 66 0F 28 C8 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 30 3E 44 0F 29 44 24 50 48 3B C2 73 23 48 85 C0 75 0D F2 0F 10 05 ?? ?? ?? ?? E9 4A 03 00 00 BA 10 00 00 00 33 C9 44 8B C2 E8 ?? ?? ?? ?? EB E2 48 BB 00 00 00 00 00 00 F0 7F 48 3B C3 72 72 76 4E 66 0F 57 C0 C7 44 24 40 01 00 00 00 49 B8 00 00 00 00 00 00 08 00 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 4C 0B C1 83 64 24 20 00 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 13 00 00 00 E8 ?? ?? ?? ?? E9 DA 02 00 00 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 89 9C 24 A8 00 00 00 F2 0F 10 84 24 A8 00 00 00 E9 B8 02 00 00 66 44 0F 28 C0 48 3B C1 74 09 66 44 0F 57 05 ?? ?? ?? ?? 66 44 0F 2F 05 ?? ?? ?? ?? 72 36 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 03 00 00 00 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 4C 8B C3 E9 74 FF FF FF 66 44 0F 2F 05 ?? ?? ?? ?? 0F 82 11 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 84 24 A0 00 00 00 48 89 44 24 38 48 8D 84 24 98 00 00 00 48 89 44 24 30 48 8D 84 24 90 00 00 00 66 41 0F 28 C0 48 89 44 24 28 F2 0F 11 4C 24 20 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 8C 24 90 00 00 00 41 FF C9 44 89 8C 24 90 00 00 00 41 8D 81 FE 03 00 00 3D FD 07 00 00 77 34 49 63 C1 BA FF 03 00 00 48 03 C2 48 C1 E0 34 48 89 84 24 A8 00 00 00 F2 0F 10 84 24 A8 00 00 00 F2 0F 10 BC 24 98 00 00 00 F2 0F 58 BC 24 A0 00 00 00 EB 5C 41 8B C1 99 2B C2 BA FF 03 00 00 D1 F8 48 63 C8 44 2B C8 48 03 CA 49 63 C1 48 C1 E1 34 48 03 C2 48 89 8C 24 A8 00 00 00 48 C1 E0 34 F2 0F 10 8C 24 A8 00 00 00 48 89 84 24 A8 00 00 00 F2 0F 10 84 24 A8 00 00 00 F2 0F 10 BC 24 98 00 00 00 F2 0F 58 BC 24 A0 00 00 00 F2 0F 59 F9 F2 0F 59 F8 E9 40 01 00 00 F2 41 0F 2C C0 48 8D 0D ?? ?? ?? ?? 66 0F 6E C0 48 98 F2 0F 10 94 C1 ?? ?? ?? ?? F2 0F 10 A4 C1 ?? ?? ?? ?? F2 0F 10 9C C1 ?? ?? ?? ?? F3 0F E6 C0 F2 44 0F 5C C0 66 41 0F 28 C8 F2 41 0F 59 C8 66 0F 28 E9 66 0F 28 F1 66 0F 28 C1 F2 0F 59 2D ?? ?? ?? ?? F2 0F 59 35 ?? ?? ?? ?? F2 41 0F 59 C0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 E9 F2 0F 59 F0 F2 0F 10 8C C1 ?? ?? ?? ?? 66 0F 28 C2 F2 0F 59 C5 66 0F 28 F9 F2 41 0F 59 C8 F2 0F 59 FE F2 0F 58 F8 F2 0F 58 F9 66 0F 28 CC F2 0F 59 CD F2 0F 58 FA 66 0F 28 D3 F2 41 0F 59 D8 F2 0F 59 D6 F2 0F 58 F9 F2 0F 58 FA F2 0F 58 FB F2 0F 58 FC 66 0F 28 C7 0F 28 74 24 70 0F 28 7C 24 60 44 0F 28 44 24 50 48 81 C4 80 00 00 00 5B C3 }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "__pctype_func"
		size = 59
		refs = "0005 _getptd 0013 __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 C0 00 00 00 48 3B 0D ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 8B C8 48 8B 81 40 01 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_3_0 {
	meta:
		name = "_mbscpy_s_l"
		size = 418
		refs = "0033 _errno 003f _invalid_parameter_noinfo 0062 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 007b strcpy_s 00c7 _ismbblead_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 40 49 8B F0 48 8B FA 48 8B D9 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C0 75 2B 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 50 48 8B 74 24 58 48 8B 7C 24 60 48 83 C4 40 5D C3 48 8D 4D E0 49 8B D1 E8 ?? ?? ?? ?? 4C 8B 5D E8 48 8B CB 41 83 7B 08 00 75 1E 4C 8B C6 48 8B D7 E8 ?? ?? ?? ?? 80 7D F8 00 74 C0 48 8B 4D F0 83 A1 C8 00 00 00 FD EB B3 8A 06 48 FF C6 88 01 48 FF C1 84 C0 74 05 48 FF CF 75 ED 48 85 FF 0F 85 86 00 00 00 40 38 3E 75 53 48 8D 71 FF 48 8B FE 48 3B F3 72 18 0F B6 0F 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CF 48 3B FB 73 E8 8B C6 2B C7 A8 01 74 27 C6 06 00 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C2 E9 3F FF FF FF C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? 80 7D F8 00 0F 84 1F FF FF FF 48 8B 4D F0 83 A1 C8 00 00 00 FD E9 0F FF FF FF 48 8D 79 FE 48 8B F7 48 3B FB 72 18 0F B6 0E 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CE 48 3B F3 73 E8 8B C7 2B C6 A8 01 74 2A 48 3B FB 72 25 C6 07 00 E8 ?? ?? ?? ?? BA 2A 00 00 00 89 10 80 7D F8 00 74 85 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 75 FF FF FF 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 33 C0 E9 A3 FE FF FF }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "_local_unwind"
		size = 48
		refs = "0018 RtlUnwindEx"
	strings:
		$1 = { 48 81 EC D8 04 00 00 4D 33 C0 4D 33 C9 48 89 64 24 20 4C 89 44 24 28 E8 ?? ?? ?? ?? 48 81 C4 D8 04 00 00 C3 CC CC CC CC CC CC 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_116_1_0 {
	meta:
		name = "_NLG_Notify"
		size = 32
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 18 44 89 44 24 10 49 C7 C1 20 05 93 19 EB 08 CC CC CC CC CC CC 66 90 }
	condition:
		$1
}

rule file_116_2_0 {
	meta:
		name = "__NLG_Dispatch2"
		size = 16
	strings:
		$1 = { C3 CC CC CC CC CC CC 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_execlpe"
		size = 180
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0063 _capture_argv 0089 _execvpe 00a3 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 38 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 74 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 38 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_840_0_0 {
	meta:
		name = "_execle"
		size = 180
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0063 _capture_argv 0089 _execve 00a3 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 38 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 74 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 38 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "_expf_special"
		size = 221
		refs = "00ba ??_C@_04KBNCNMNN@expf?$AA@ 00cc _handle_errorf"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 41 FF C8 0F 29 70 E8 0F 28 D0 0F 28 F1 74 65 41 FF C8 74 31 41 FF C8 0F 85 AC 00 00 00 0F 57 C0 C7 40 D8 01 00 00 00 45 8D 48 03 F3 0F 11 40 D0 F3 0F 11 50 C8 C7 40 C0 22 00 00 00 C7 40 B8 11 00 00 00 EB 59 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 04 00 00 00 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 12 00 00 00 EB 2A 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 01 00 00 00 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 48 83 A4 24 88 00 00 00 00 F3 0F 11 B4 24 88 00 00 00 48 8D 0D ?? ?? ?? ?? 4C 8B 84 24 88 00 00 00 BA 14 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "_exp_special"
		size = 212
		refs = "00b3 ??_C@_03KHJOGHMM@exp?$AA@ 00c2 _handle_error"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 41 FF C8 0F 29 70 E8 66 0F 28 D0 66 0F 28 F1 74 67 41 FF C8 74 32 41 FF C8 0F 85 A0 00 00 00 66 0F 57 C0 C7 40 D8 01 00 00 00 45 8D 48 03 F2 0F 11 40 D0 F2 0F 11 50 C8 C7 40 C0 22 00 00 00 C7 40 B8 11 00 00 00 EB 5B 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 04 00 00 00 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 12 00 00 00 EB 2B 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 01 00 00 00 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 F2 0F 11 4C 24 78 48 8D 0D ?? ?? ?? ?? BA 14 00 00 00 4C 8B 44 24 78 E8 ?? ?? ?? ?? 66 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "sqrtf"
		size = 224
		refs = "006b ??_C@_05KGFAIMPG@sqrtf?$AA@ 0075 _handle_errorf"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 58 BA 00 00 80 7F F3 0F 11 44 24 68 41 B8 00 00 00 80 8B 4C 24 68 8B C1 23 C2 3B C2 0F 85 8D 00 00 00 F7 C1 FF FF 7F 00 74 48 0F 57 C0 F3 0F 10 4C 24 60 41 B9 01 00 00 00 44 89 4C 24 40 44 8B C1 49 0F BA E8 16 F3 0F 11 44 24 38 F3 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 48 8D 0D ?? ?? ?? ?? BA 05 00 00 00 E8 ?? ?? ?? ?? EB 60 41 85 C8 74 45 0F 57 C0 F3 0F 10 4C 24 60 41 B9 01 00 00 00 44 89 4C 24 40 41 B8 00 00 C0 FF F3 0F 11 44 24 38 F3 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 EB B0 41 85 C8 74 08 F7 C1 FF FF FF 7F EB B9 F3 0F 10 44 24 60 F3 0F 51 C0 F3 0F 11 44 24 70 F3 0F 10 44 24 70 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "?swprintf@@YAHPEAG_KPEBGZZ"
		size = 36
		refs = "001b ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_6_0 {
	meta:
		name = "_sprintf_p"
		size = 36
		refs = "001b _vsprintf_p_l"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_4_0 {
	meta:
		name = "_swprintf_p"
		size = 36
		refs = "001b _vswprintf_p_l"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_2_0 {
	meta:
		name = "sprintf_s"
		size = 36
		refs = "001b _vsprintf_s_l"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_438_1_0 {
	meta:
		name = "swprintf"
		size = 36
		refs = "001b _vswprintf_c_l"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_2_0 {
	meta:
		name = "swprintf_s"
		size = 36
		refs = "001b _vswprintf_s_l"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 20 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_122_1_0 {
	meta:
		name = "?swprintf@@YAHPEA_W_KPEB_WZZ"
		size = 177
		refs = "0029 memset 0063 _woutput_l 0089 _flsbuf"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 55 53 56 57 48 8B EC 48 83 EC 58 48 8B FA 33 D2 49 8B F0 48 8B D9 48 8D 4D D0 44 8D 42 28 E8 ?? ?? ?? ?? 4C 8D 4D 40 C7 45 E0 42 00 00 00 48 89 5D D8 48 89 5D C8 48 81 FF FF FF FF 3F 76 09 C7 45 D0 FF FF FF 7F EB 06 8D 04 3F 89 45 D0 48 8D 4D C8 45 33 C0 48 8B D6 E8 ?? ?? ?? ?? FF 4D D0 8B D8 78 14 48 8B 4D C8 C6 01 00 48 8B 4D C8 48 FF C1 48 89 4D C8 EB 0F 48 8D 55 C8 33 C9 E8 ?? ?? ?? ?? 48 8B 4D C8 FF 4D D0 78 05 C6 01 00 EB 0B 48 8D 55 C8 33 C9 E8 ?? ?? ?? ?? 8B C3 48 83 C4 58 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_lsearch"
		size = 163
		refs = "002e _errno 0039 _invalid_parameter_noinfo 007f memcpy"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 41 55 48 83 EC 20 45 33 E4 41 8B F1 49 8B F8 48 8B DA 4C 8B E9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 47 4D 85 C0 74 E7 48 85 D2 74 E2 45 85 C9 74 DD 4C 39 64 24 50 74 D6 45 39 20 76 19 48 8B D3 49 8B CD FF 54 24 50 85 C0 74 1B 41 FF C4 48 03 DE 44 3B 27 72 E7 4C 8B C6 49 8B D5 48 8B CB E8 ?? ?? ?? ?? FF 07 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 4C 8B 64 24 48 48 83 C4 20 41 5D C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_wchdir"
		size = 331
		refs = "001e __security_cookie 0041 __doserrno 0049 _errno 0054 _invalid_parameter_noinfo 005f __imp_SetCurrentDirectoryW 0077 __imp_GetCurrentDirectoryW 0090 _calloc_crt 00da towupper 00f5 __imp_SetEnvironmentVariableW 0104 __imp_GetLastError 010b _dosmaperr 0118 free 012a __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 48 81 EC 50 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 02 00 00 45 33 ED 83 CE FF 48 8D 5C 24 30 45 8B E5 48 85 C9 75 1D E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 BF 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 97 00 00 00 48 8D 54 24 30 B9 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F8 3D 04 01 00 00 7E 2F 8D 68 01 BA 02 00 00 00 48 63 CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 66 41 BC 01 00 00 00 85 FF 74 5C 48 8B D0 8B CD FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 4B 0F B7 03 66 83 F8 5C 74 06 66 83 F8 2F 75 06 66 3B 43 02 74 31 B8 3D 00 00 00 66 89 44 24 20 0F B7 0B E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D3 66 89 44 24 22 C7 44 24 24 3A 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 05 41 8B F5 EB 0D FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 45 85 E4 74 08 48 8B CB E8 ?? ?? ?? ?? 8B C6 48 8B 8C 24 40 02 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 50 02 00 00 49 8B 5B 28 49 8B 6B 30 49 8B 73 38 49 8B E3 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "??0exception@std@@QEAA@XZ"
		size = 23
		refs = "0008 ??_7exception@std@@6B@"
	strings:
		$1 = { 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? C6 41 10 00 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_125_1_0 {
	meta:
		name = "??0exception@std@@QEAA@AEBQEBDH@Z"
		size = 25
		refs = "0003 ??_7exception@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 02 C6 41 10 00 48 89 41 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_125_2_0 {
	meta:
		name = "?what@exception@std@@UEBAPEBDXZ"
		size = 18
		refs = "0008 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 48 83 79 08 00 48 8D 05 ?? ?? ?? ?? 48 0F 45 41 08 C3 }
	condition:
		$1
}

rule file_125_3_0 {
	meta:
		name = "?_Copy_str@exception@std@@AEAAXPEBD@Z"
		size = 90
		refs = "001e strlen 002a malloc 0042 strcpy_s"
	strings:
		$1 = { 48 85 D2 74 54 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 8B CA 48 8B DA E8 ?? ?? ?? ?? 48 8B F0 48 8D 48 01 E8 ?? ?? ?? ?? 48 89 47 08 48 85 C0 74 13 48 8D 56 01 4C 8B C3 48 8B C8 E8 ?? ?? ?? ?? C6 47 10 01 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_4_0 {
	meta:
		name = "?_Tidy@exception@std@@AEAAXXZ"
		size = 39
		refs = "0014 free"
	strings:
		$1 = { 40 53 48 83 EC 20 80 79 10 00 48 8B D9 74 09 48 8B 49 08 E8 ?? ?? ?? ?? 48 83 63 08 00 C6 43 10 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_5_0 {
	meta:
		name = "??0exception@std@@QEAA@AEBQEBD@Z"
		size = 45
		refs = "000e ??_7exception@std@@6B@ 0020 ?_Copy_str@exception@std@@AEAAXPEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? C6 41 10 00 48 89 01 48 8B 12 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_125_6_0 {
	meta:
		name = "??4exception@std@@QEAAAEAV01@AEBV01@@Z"
		size = 68
		refs = "0016 ?_Tidy@exception@std@@AEAAXXZ 0028 ?_Copy_str@exception@std@@AEAAXPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 48 8B D9 48 3B CA 74 21 E8 ?? ?? ?? ?? 80 7F 10 00 74 0E 48 8B 57 08 48 8B CB E8 ?? ?? ?? ?? EB 08 48 8B 47 08 48 89 43 08 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_125_15_0 {
	meta:
		name = "??0exception@std@@QEAA@AEBV01@@Z"
		size = 42
		refs = "000e ??_7exception@std@@6B@ 001d ??4exception@std@@QEAAAEAV01@AEBV01@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 C6 41 10 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "vscanf"
		size = 143
		refs = "002e _errno 0039 _invalid_parameter_noinfo 0043 __iob_func 004d _lock_file2 0073 _unlock_file2"
		altNames = "vwscanf"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 48 83 EC 20 49 8B F9 49 8B F0 48 8B DA 4C 8B E1 33 C0 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 37 E8 ?? ?? ?? ?? 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 8B C8 4C 8B CF 4C 8B C6 48 8B D3 41 FF D4 8B D8 E8 ?? ?? ?? ?? 48 8B D0 33 C9 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_126_1_0 {
	meta:
		name = "vscanf$fin$0"
		size = 32
		refs = "000a __iob_func 0014 _unlock_file2"
		altNames = "_gets_helper$fin$0 _getws_helper$fin$0 vwscanf$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_126_2_0 {
	meta:
		name = "scanf"
		size = 50
		refs = "0021 _input_l 0029 vscanf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8B D1 4C 8D 48 10 48 8D 0D ?? ?? ?? ?? 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "scanf_s"
		size = 50
		refs = "0021 _input_s_l 0029 vscanf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8B D1 4C 8D 48 10 48 8D 0D ?? ?? ?? ?? 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "wscanf"
		size = 50
		refs = "0021 _winput_l 0029 vwscanf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8B D1 4C 8D 48 10 48 8D 0D ?? ?? ?? ?? 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_261_4_0 {
	meta:
		name = "wscanf_s"
		size = 50
		refs = "0021 _winput_s_l 0029 vwscanf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8B D1 4C 8D 48 10 48 8D 0D ?? ?? ?? ?? 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_126_3_0 {
	meta:
		name = "_scanf_l"
		size = 46
		refs = "0020 _input_l 0025 vscanf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8B C2 48 8B D1 4C 8D 48 18 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_126_5_0 {
	meta:
		name = "_scanf_s_l"
		size = 46
		refs = "0020 _input_s_l 0025 vscanf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8B C2 48 8B D1 4C 8D 48 18 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "_wscanf_l"
		size = 46
		refs = "0020 _winput_l 0025 vwscanf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8B C2 48 8B D1 4C 8D 48 18 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_261_5_0 {
	meta:
		name = "_wscanf_s_l"
		size = 46
		refs = "0020 _winput_s_l 0025 vwscanf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8B C2 48 8B D1 4C 8D 48 18 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "_get_daylight"
		size = 47
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0022 _daylight"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 0A 8B 05 ?? ?? ?? ?? 89 01 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "_get_dstbias"
		size = 47
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0022 _dstbias"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 0A 8B 05 ?? ?? ?? ?? 89 01 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_get_fmode"
		size = 47
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0022 _fmode"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 0A 8B 05 ?? ?? ?? ?? 89 01 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "_get_timezone"
		size = 47
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0022 _timezone"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 0A 8B 05 ?? ?? ?? ?? 89 01 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_127_3_0 {
	meta:
		name = "_get_tzname"
		size = 182
		refs = "004a _tzname 0053 strlen 006c _errno 0078 _invalid_parameter_noinfo 0097 strcpy_s"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 49 8B D8 48 8B FA 48 8B F1 48 85 D2 74 3F 48 85 DB 74 3F 48 85 D2 74 03 C6 02 00 48 85 C9 74 32 45 85 C9 74 06 41 83 F9 01 75 27 49 63 E9 4C 8D 25 ?? ?? ?? ?? 49 8B 0C EC E8 ?? ?? ?? ?? 48 FF C0 48 89 06 48 85 FF 75 1E 33 C0 EB 35 48 85 DB 74 C1 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 1B 48 3B C3 76 07 B8 22 00 00 00 EB 0F 4D 8B 04 EC 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__addl"
		size = 25
	strings:
		$1 = { 44 8D 0C 11 33 C0 44 3B C9 72 05 44 3B CA 73 05 B8 01 00 00 00 45 89 08 C3 }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "__add_12"
		size = 122
	strings:
		$1 = { 8B 01 44 8B 12 45 33 C9 46 8D 04 10 4C 8B DA 44 3B C0 72 05 45 3B C2 73 06 41 B9 01 00 00 00 44 89 01 45 85 C9 74 23 8B 41 04 45 33 C0 8D 50 01 3B D0 72 05 83 FA 01 73 06 41 B8 01 00 00 00 89 51 04 45 85 C0 74 03 FF 41 08 8B 41 04 45 8B 4B 04 45 33 C0 42 8D 14 08 3B D0 72 05 41 3B D1 73 06 41 B8 01 00 00 00 89 51 04 45 85 C0 74 03 FF 41 08 41 8B 43 08 01 41 08 C3 }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "__shl_12"
		size = 44
	strings:
		$1 = { 8B 01 8B 51 04 44 8B C0 03 C0 44 8B CA 89 01 8D 04 12 41 C1 E8 1F 41 0B C0 41 C1 E9 1F 89 41 04 8B 41 08 03 C0 41 0B C1 89 41 08 C3 }
	condition:
		$1
}

rule file_128_3_0 {
	meta:
		name = "__mtold12"
		size = 537
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 56 48 83 EC 10 41 83 20 00 41 83 60 04 00 41 83 60 08 00 4D 8B D8 8B FA 48 8B E9 BB 4E 40 00 00 85 D2 0F 84 38 01 00 00 45 33 C9 45 33 D2 45 8D 71 01 49 8B 33 45 8B 63 08 41 8B D1 45 03 C9 45 03 D2 C1 EA 1F 44 0B D2 44 8D 04 36 8B CE C1 E9 1F 45 03 D2 41 8B C0 44 0B C9 45 03 C0 C1 E8 1F 41 8B C9 45 03 C9 48 89 34 24 C1 E9 1F 44 0B C8 33 C0 44 0B D1 8B CE 45 89 03 41 8D 14 08 45 89 4B 04 45 89 53 08 41 3B D0 72 04 3B D1 73 03 41 8B C6 41 89 13 85 C0 74 24 41 8B C1 41 FF C1 33 C9 44 3B C8 72 05 45 3B CE 73 03 41 8B CE 45 89 4B 04 85 C9 74 07 41 FF C2 45 89 53 08 48 C1 EE 20 33 C0 45 8D 04 31 45 3B C1 72 05 44 3B C6 73 03 41 8B C6 45 89 43 04 85 C0 74 07 45 03 D6 45 89 53 08 45 03 D4 8B C2 03 D2 C1 E8 1F 41 8B C8 47 8D 0C 00 C1 E9 1F 44 0B C8 45 03 D2 44 0B D1 45 89 4B 04 41 89 13 45 89 53 08 44 0F BE 45 00 33 C9 42 8D 04 02 3B C2 72 05 41 3B C0 73 03 41 8B CE 41 89 03 85 C9 74 24 41 8B C1 41 FF C1 33 C9 44 3B C8 72 05 45 3B CE 73 03 41 8B CE 45 89 4B 04 85 C9 74 07 41 FF C2 45 89 53 08 49 03 EE FF CF 45 89 4B 04 45 89 53 08 0F 85 D2 FE FF FF 41 83 7B 08 00 75 3A 45 8B 4B 04 41 8B 13 41 8B C1 45 8B C1 C1 E0 10 8B CA 41 C1 E8 10 C1 E9 10 C1 E2 10 45 89 43 08 44 8B C9 41 89 13 44 0B C8 B8 F0 FF 00 00 66 03 D8 45 89 4B 04 45 85 C0 74 CA 45 8B 43 08 41 BA 00 80 00 00 45 85 C2 75 38 45 8B 4B 04 41 8B 03 41 8B D1 45 03 C0 8B C8 03 C0 C1 EA 1F C1 E9 1F 45 03 C9 44 0B C2 44 0B C9 41 89 03 B8 FF FF 00 00 66 03 D8 45 89 4B 04 45 89 43 08 45 85 C2 74 CC 48 8B 6C 24 38 48 8B 74 24 40 66 41 89 5B 0A 48 8B 5C 24 30 48 83 C4 10 41 5E 41 5C 5F C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "_onexit_nolock"
		size = 244
		refs = "001e __onexitbegin 0024 __imp_DecodePointer 002b __onexitend 005c _msize 0080 _realloc_crt 00ac __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 48 83 EC 20 4C 8B E9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8B E8 FF 15 ?? ?? ?? ?? 48 8B F8 48 3B C5 0F 82 95 00 00 00 48 8B D8 48 2B DD 4C 8D 63 08 49 83 FC 08 0F 82 81 00 00 00 48 8B CD E8 ?? ?? ?? ?? 48 8B F0 49 3B C4 73 4F BA 00 10 00 00 48 3B C2 48 0F 42 D0 48 03 D0 48 3B D0 72 0D 48 8B CD E8 ?? ?? ?? ?? 48 85 C0 75 16 48 8D 56 20 48 3B D6 72 47 48 8B CD E8 ?? ?? ?? ?? 48 85 C0 74 3A 48 C1 FB 03 48 8B C8 48 8D 3C D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ?? 48 8D 4F 08 48 89 07 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 49 8B C5 EB 02 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "__onexitinit"
		size = 67
		refs = "000f _calloc_crt 001b __imp_EncodePointer 0022 __onexitbegin 0029 __onexitend"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 08 00 00 00 8D 4A 18 E8 ?? ?? ?? ?? 48 8B C8 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 DB 75 05 8D 43 18 EB 06 48 83 23 00 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_131_2_0 {
	meta:
		name = "_onexit"
		size = 266
		refs = "001d _lockexit 0025 __onexitbegin 002b __imp_DecodePointer 0035 __onexitend 0063 _msize 0087 _realloc_crt 00b9 __imp_EncodePointer 00e9 _unlockexit"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 41 55 41 56 48 83 EC 20 4C 8B F1 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8B E0 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 49 3B C4 0F 82 9B 00 00 00 48 8B F8 49 2B FC 4C 8D 6F 08 49 83 FD 08 0F 82 87 00 00 00 49 8B CC E8 ?? ?? ?? ?? 48 8B F0 49 3B C5 73 55 BA 00 10 00 00 48 3B C2 48 0F 42 D0 48 03 D0 48 3B D0 72 11 49 8B CC E8 ?? ?? ?? ?? 33 DB 48 85 C0 75 1A EB 02 33 DB 48 8D 56 20 48 3B D6 72 49 49 8B CC E8 ?? ?? ?? ?? 48 85 C0 74 3C 48 C1 FF 03 48 8D 1C F8 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 49 8B CE FF 15 ?? ?? ?? ?? 48 89 03 48 8D 4B 08 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 49 8B DE EB 02 33 DB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 48 83 C4 20 41 5E 41 5D 41 5C C3 }
	condition:
		$1
}

rule file_131_3_0 {
	meta:
		name = "_onexit$fin$0"
		size = 22
		refs = "000a _unlockexit"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_21_0 {
	meta:
		name = "__CxxCallUnwindDelDtor$filt$0"
		size = 22
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_19_0 {
	meta:
		name = "__CxxCallUnwindDtor$filt$0"
		size = 22
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_23_0 {
	meta:
		name = "__CxxCallUnwindStdDelDtor$filt$0"
		size = 22
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_25_0 {
	meta:
		name = "__CxxCallUnwindVecDtor$filt$0"
		size = 22
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_6_0 {
	meta:
		name = "__FrameUnwindToState$filt$0"
		size = 32
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
	condition:
		$1
}

rule file_131_4_0 {
	meta:
		name = "atexit"
		size = 23
		refs = "0005 _onexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 F7 D8 1B C0 F7 D8 FF C8 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "?GetThreadProxyId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0009 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_579_59_0 {
	meta:
		name = "?GetExecutionContextId@Concurrency@@YAIXZ"
		size = 16
		refs = "0009 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_579_55_0 {
	meta:
		name = "?GetExecutionContextId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0009 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_735_71_0 {
	meta:
		name = "?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0009 ?s_workQueueIdCounter@SchedulerBase@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_579_58_0 {
	meta:
		name = "?GetSchedulerId@Concurrency@@YAIXZ"
		size = 16
		refs = "0009 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_579_54_0 {
	meta:
		name = "?GetSchedulerId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0009 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 C3 }
	condition:
		$1
}

rule file_132_10_0 {
	meta:
		name = "??1UMSThreadProxy@details@Concurrency@@UEAA@XZ"
		size = 91
		refs = "0009 ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0016 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0021 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 0034 __imp_CloseHandle 0051 ?DeleteUmsThreadContext@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 41 10 48 8B 49 30 48 85 C9 74 06 FF 15 ?? ?? ?? ?? 48 8B 4B 28 48 85 C9 74 06 FF 15 ?? ?? ?? ?? 48 8B 4B 20 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_132_12_0 {
	meta:
		name = "?ForceEnterHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@QEAAHXZ"
		size = 21
	strings:
		$1 = { 8B 81 90 00 00 00 FF 81 8C 00 00 00 FF C0 89 81 90 00 00 00 C3 }
	condition:
		$1
}

rule file_132_13_0 {
	meta:
		name = "?ExitHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 21
	strings:
		$1 = { 8B 81 88 00 00 00 FF 89 84 00 00 00 FF C8 89 81 88 00 00 00 C3 }
	condition:
		$1
}

rule file_132_14_0 {
	meta:
		name = "?GetCriticalRegionType@UMSThreadProxy@details@Concurrency@@UEBA?AW4CriticalRegionType@3@XZ"
		size = 26
	strings:
		$1 = { 33 C0 39 81 88 00 00 00 76 06 B8 02 00 00 00 C3 39 81 84 00 00 00 0F 97 C0 C3 }
	condition:
		$1
}

rule file_132_15_0 {
	meta:
		name = "?GetNextUnblockNotification@UMSThreadProxy@details@Concurrency@@UEAAPEAUIUMSUnblockNotification@3@XZ"
		size = 33
	strings:
		$1 = { 48 8B 81 90 00 00 00 48 8D 88 60 FF FF FF 48 F7 D8 48 1B C0 48 23 C1 74 05 48 83 C0 10 C3 33 C0 C3 }
	condition:
		$1
}

rule file_132_18_0 {
	meta:
		name = "?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AEAAXXZ"
		size = 39
		refs = "0023 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 83 C1 08 48 8B 01 FF 50 30 48 8B CB C7 43 5C 07 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_19_0 {
	meta:
		name = "?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
		size = 136
		refs = "0030 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z 003a __imp_GetLastError 0052 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0059 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0063 _CxxThrowException"
	strings:
		$1 = { 40 53 48 83 EC 50 33 DB 48 85 C9 75 04 33 C0 EB 71 41 B9 08 00 00 00 48 8D 44 24 60 4C 8D 44 24 68 41 8D 51 F9 48 89 5C 24 68 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 48 8D 4C 24 30 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC 48 8B 4C 24 68 48 85 C9 74 0D 48 8B 11 FF 12 84 C0 48 0F 44 5C 24 68 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_132_21_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 51
		refs = "0011 ??0exception@std@@QEAA@AEBV01@@Z 0018 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1F 8B 43 18 48 8B 5C 24 30 89 47 18 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_11_1 {
	meta:
		name = "??0regex_error@tr1@std@@QEAA@AEBV012@@Z"
		size = 51
		refs = "0011 ??0exception@std@@QEAA@AEBV01@@Z 0018 ??_7regex_error@tr1@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1F 8B 43 18 48 8B 5C 24 30 89 47 18 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_132_23_0 {
	meta:
		name = "?FromListEntry@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAU_SLIST_ENTRY@@@Z"
		size = 16
	strings:
		$1 = { 48 85 C9 75 03 33 C0 C3 48 8D 81 60 FF FF FF C3 }
	condition:
		$1
}

rule file_132_24_0 {
	meta:
		name = "?InternalSwitchTo@UMSThreadProxy@details@Concurrency@@IEAAXPEAV123@W4SwitchingProxyState@3@@Z"
		size = 176
		refs = "0017 __security_cookie 0059 ?GetResourceManager@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEAAPEAVResourceManager@23@XZ 0068 ?PerformTransmogrification@Transmogrificator@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z 007b ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z 0097 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8B 41 08 48 8B D9 48 83 C1 08 49 63 F0 48 8B EA C7 44 24 20 02 00 00 00 C7 44 24 24 01 00 00 00 C7 44 24 28 03 00 00 00 FF 50 30 83 FE 02 75 18 48 8B 4B 40 E8 ?? ?? ?? ?? 48 8B D3 48 8B 88 A0 00 00 00 E8 ?? ?? ?? ?? 8B 54 B4 20 48 8B CB 48 89 6B 60 89 53 5C E8 ?? ?? ?? ?? 85 F6 74 0B 48 8B 43 08 48 8D 4B 08 FF 50 38 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_132_25_0 {
	meta:
		name = "?InternalSwitchOut@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 80
		refs = "0036 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 08 48 8B D9 48 83 C1 08 FF 50 30 48 8B 43 68 48 8B CB 48 85 C0 74 0A 48 C7 43 68 00 00 00 00 EB 07 C7 43 5C 06 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 08 48 8D 4B 08 48 8B 5C 24 30 48 83 C4 20 5F 48 FF 60 38 }
	condition:
		$1
}

rule file_132_26_0 {
	meta:
		name = "?Deactivate@UMSThreadProxy@details@Concurrency@@IEAA_NXZ"
		size = 89
		refs = "002d ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 08 48 8B F9 48 83 C1 08 FF 50 30 48 83 67 60 00 48 8B CF C7 47 5C 04 00 00 00 E8 ?? ?? ?? ?? 83 7F 70 01 48 8B 57 08 0F 94 C3 83 67 70 00 48 8D 4F 08 FF 52 38 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_132_27_0 {
	meta:
		name = "?SetPriority@UMSThreadProxy@details@Concurrency@@QEAAXH@Z"
		size = 74
		refs = "000d __imp_SetThreadPriority 0017 __imp_GetLastError 002f ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0036 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0040 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 89 51 54 48 8B 49 28 FF 15 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_132_29_0 {
	meta:
		name = "?IsSuspended@UMSThreadProxy@details@Concurrency@@QEAA_NXZ"
		size = 51
		refs = "0022 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 49 20 33 DB 4C 8D 44 24 40 44 8D 4B 01 8D 53 05 88 5C 24 40 48 89 5C 24 20 E8 ?? ?? ?? ?? 38 5C 24 40 0F 95 C0 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_132_30_0 {
	meta:
		name = "?IsTerminated@UMSThreadProxy@details@Concurrency@@QEAA_NXZ"
		size = 51
		refs = "0022 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 49 20 33 DB 4C 8D 44 24 40 44 8D 4B 01 8D 53 06 88 5C 24 40 48 89 5C 24 20 E8 ?? ?? ?? ?? 38 5C 24 40 0F 95 C0 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_132_31_0 {
	meta:
		name = "?PrepareToRun@UMSThreadProxy@details@Concurrency@@IEAAXPEAVUMSFreeVirtualProcessorRoot@23@@Z"
		size = 16
	strings:
		$1 = { C7 41 38 00 00 00 00 48 89 51 48 48 89 51 40 C3 }
	condition:
		$1
}

rule file_132_39_0 {
	meta:
		name = "?EnterHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 21
	strings:
		$1 = { 8B 81 88 00 00 00 FF 81 84 00 00 00 FF C0 89 81 88 00 00 00 C3 }
	condition:
		$1
}

rule file_132_42_0 {
	meta:
		name = "?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CAKPEAX@Z"
		size = 32
		refs = "000a ?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8B 1B 48 8B CB 41 FF 53 10 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_132_43_0 {
	meta:
		name = "?InternalYieldToSystem@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 66
		refs = "0028 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 08 48 8B D9 48 83 C1 08 FF 50 30 48 83 63 60 00 48 8B CB C7 43 5C 08 00 00 00 E8 ?? ?? ?? ?? 4C 8B 5B 08 48 8D 4B 08 48 8B 5C 24 30 48 83 C4 20 5F 49 FF 63 38 }
	condition:
		$1
}

rule file_132_44_0 {
	meta:
		name = "?FreeViaExit@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 74
		refs = "0015 ?s_fRequireUMSWorkaround@ResourceManager@details@Concurrency@@0_NA 0046 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 83 C1 08 48 8B 01 FF 50 30 80 3D ?? ?? ?? ?? 00 74 1A 48 8B 43 40 80 B8 BA 00 00 00 00 74 0D C7 43 78 01 00 00 00 48 83 C4 20 5B C3 48 8B CB C7 43 5C 05 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_46_0 {
	meta:
		name = "??0UMSThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z"
		size = 740
		refs = "0042 ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 004f ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 005d ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 008b __imp_CreateEventW 009a __imp_GetLastError 00b1 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00b8 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00c1 _CxxThrowException 00cf ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC 00e0 ?CreateUmsThreadContext@UMS@details@Concurrency@@SAHPEAPEAX@Z 012d ?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z 0189 ?InitializeProcThreadAttributeList@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPEA_K@Z 0192 ??_U@YAPEAX_K@Z 01b4 ??_V@YAXPEAX@Z 0209 ?UpdateProcThreadAttribute@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@K_KPEAX12PEA_K@Z 0253 __imp_GetCurrentProcess 0264 ?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CAKPEAX@Z 027e ?CreateRemoteThreadEx@UMS@details@Concurrency@@SAPEAXPEAXPEAU_SECURITY_ATTRIBUTES@@_KP6AK0@Z0KPEAU_PROC_THREAD_ATTRIBUTE_LIST@@PEAK@Z 028a ?DeleteProcThreadAttributeList@UMS@details@Concurrency@@SAXPEAU_PROC_THREAD_ATTRIBUTE_LIST@@@Z"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 48 8D 6C 24 E0 48 81 EC 20 01 00 00 45 33 ED 48 89 51 18 44 89 49 50 4C 89 69 20 4C 89 69 28 4C 89 69 30 4C 89 69 48 44 88 69 58 44 89 69 5C 44 89 69 70 48 8D 05 ?? ?? ?? ?? 41 8B F9 48 89 01 48 8D 05 ?? ?? ?? ?? 4D 8B E0 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 8B F1 48 89 41 10 44 89 69 38 4C 89 69 40 4C 89 69 68 4C 89 A9 8C 00 00 00 44 89 69 78 33 C9 45 33 C9 45 33 C0 33 D2 FF 15 ?? ?? ?? ?? 48 89 46 30 48 85 C0 75 2E FF 15 ?? ?? ?? ?? 48 8D 4D D8 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D D8 E8 ?? ?? ?? ?? CC B8 01 00 00 00 F0 0F C1 05 ?? ?? ?? ?? FF C0 48 8D 4E 20 89 86 88 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 2E FF 15 ?? ?? ?? ?? 48 8D 4D 98 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 98 E8 ?? ?? ?? ?? CC 48 8B 4E 20 41 B9 08 00 00 00 4C 8D 45 58 41 8D 51 F9 48 89 75 58 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 48 8D 4C 24 58 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? CC 48 8B 46 20 45 33 C0 4C 8D 4D 50 41 8D 50 01 33 C9 C7 44 24 40 00 01 00 00 48 89 44 24 48 4C 89 64 24 50 E8 ?? ?? ?? ?? 48 8B 4D 50 E8 ?? ?? ?? ?? 45 33 C0 4C 8D 4D 50 41 8D 50 01 48 8B C8 4C 8B E0 E8 ?? ?? ?? ?? 49 8B CC 85 C0 75 35 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 4C 24 78 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? CC 4C 89 6C 24 30 4C 8D 4C 24 40 33 D2 41 B8 06 00 03 00 4C 89 6C 24 28 48 C7 44 24 20 18 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 36 49 8B CC E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 4D B8 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D B8 E8 ?? ?? ?? ?? CC 48 8D 9E 94 00 00 00 C1 E7 0A FF 15 ?? ?? ?? ?? 48 89 5C 24 38 4C 89 64 24 30 4C 8D 0D ?? ?? ?? ?? 48 8B C8 44 8B C7 33 D2 C7 44 24 28 00 00 01 00 48 89 74 24 20 E8 ?? ?? ?? ?? 49 8B CC 48 89 46 28 E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? 4C 39 6E 28 75 2E FF 15 ?? ?? ?? ?? 48 8D 4D F8 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D F8 E8 ?? ?? ?? ?? CC 48 8B C6 48 8B 9C 24 60 01 00 00 48 81 C4 20 01 00 00 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_132_48_0 {
	meta:
		name = "?SpinUntilBlocked@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 60
		refs = "001a ?_Sleep0@details@Concurrency@@YAXXZ 0029 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 41 40 48 8B D9 48 85 C0 74 24 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 5B 40 4D 85 DB 75 ED 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_132_49_0 {
	meta:
		name = "?SpinOnAndReturnBlockingType@UMSThreadProxy@details@Concurrency@@IEAA?AW4BlockingType@123@XZ"
		size = 60
		refs = "0017 ?_Sleep0@details@Concurrency@@YAXXZ 0026 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 8B 41 38 48 8B D9 85 C0 75 23 21 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 44 8B 5B 38 45 85 DB 74 ED 8B 43 38 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "_isalpha_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 03 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "isalpha"
		size = 131
		refs = "0008 __locale_changed 0015 __initiallocinfo 002c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 12 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 25 03 01 00 00 EB 59 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 03 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "_isupper_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 01 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 01 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_6_0 {
	meta:
		name = "isupper"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 01 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 01 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 01 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_7_0 {
	meta:
		name = "_islower_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 02 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 02 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_8_0 {
	meta:
		name = "islower"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 02 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 02 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 02 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_9_0 {
	meta:
		name = "_isdigit_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 04 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 04 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_10_0 {
	meta:
		name = "isdigit"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 04 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 04 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 04 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_11_0 {
	meta:
		name = "_isxdigit_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 80 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 80 00 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_12_0 {
	meta:
		name = "isxdigit"
		size = 131
		refs = "0008 __locale_changed 0015 __initiallocinfo 002c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 12 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 25 80 00 00 00 EB 59 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 80 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 80 00 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_13_0 {
	meta:
		name = "_isspace_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 08 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 08 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_14_0 {
	meta:
		name = "isspace"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 08 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 08 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 08 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_15_0 {
	meta:
		name = "_ispunct_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 10 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 10 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_16_0 {
	meta:
		name = "ispunct"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 10 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 10 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 10 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_17_0 {
	meta:
		name = "_isalnum_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 07 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_18_0 {
	meta:
		name = "isalnum"
		size = 131
		refs = "0008 __locale_changed 0015 __initiallocinfo 002c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 12 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 25 07 01 00 00 EB 59 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 07 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_19_0 {
	meta:
		name = "_isprint_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 57 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 57 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_20_0 {
	meta:
		name = "isprint"
		size = 131
		refs = "0008 __locale_changed 0015 __initiallocinfo 002c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 12 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 25 57 01 00 00 EB 59 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 57 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 57 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_21_0 {
	meta:
		name = "_isgraph_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 17 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 17 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_22_0 {
	meta:
		name = "isgraph"
		size = 131
		refs = "0008 __locale_changed 0015 __initiallocinfo 002c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 12 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 25 17 01 00 00 EB 59 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 17 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 17 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_23_0 {
	meta:
		name = "_iscntrl_l"
		size = 99
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 20 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 20 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_24_0 {
	meta:
		name = "iscntrl"
		size = 126
		refs = "0008 __locale_changed 0015 __initiallocinfo 002a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0049 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 75 10 48 8B 05 ?? ?? ?? ?? 0F B7 04 58 83 E0 20 EB 56 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 20 00 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 10 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 83 E3 20 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 41 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_27_0 {
	meta:
		name = "_iscsymf_l"
		size = 117
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 03 01 00 00 33 C9 38 4C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 45 85 DB 75 05 83 FB 5F 75 05 B9 01 00 00 00 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_28_0 {
	meta:
		name = "__iscsymf"
		size = 37
		refs = "0009 isalpha"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 05 83 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_133_29_0 {
	meta:
		name = "_iscsym_l"
		size = 117
		refs = "000f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 83 B8 0C 01 00 00 01 7E 16 4C 8D 44 24 20 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 44 8B D8 EB 13 48 8B 80 40 01 00 00 44 0F B7 1C 58 41 81 E3 07 01 00 00 33 C9 38 4C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 45 85 DB 75 05 83 FB 5F 75 05 B9 01 00 00 00 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_133_30_0 {
	meta:
		name = "__iscsym"
		size = 40
		refs = "000c isalnum"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 0F B6 C9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 05 80 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "_strdup"
		size = 112
		refs = "0018 strlen 0024 malloc 003b strcpy_s 0059 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B D9 48 85 C9 74 47 E8 ?? ?? ?? ?? 48 8B F0 48 8D 48 01 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 2E 48 8D 56 01 4C 8B C3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 05 48 8B C7 EB 18 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 33 C0 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_GET_RTERRMSG"
		size = 41
		refs = "0003 rterrs"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 33 C0 49 8B D0 3B 0A 74 0E FF C0 48 83 C2 10 83 F8 16 72 F1 33 C0 C3 48 98 48 03 C0 49 8B 44 C0 08 C3 }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_NMSG_WRITE"
		size = 605
		refs = "001e __security_cookie 0030 _GET_RTERRMSG 0046 _set_error_mode 0061 __app_type 007b ?outmsg@?8??_NMSG_WRITE@@9@9 0088 ??_C@_1DE@JNGNBFGO@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 0093 wcscpy_s 00ba __imp_GetModuleFileNameW 00ca ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 00ec _invoke_watson 00f5 wcslen 010d ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 012c wcsncpy_s 014c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 0157 wcscat_s 0174 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0182 __crtMessageBoxW 01cf __imp_GetStdHandle 0211 strlen 022c __imp_WriteFile 023c __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 48 81 EC 50 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 02 00 00 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 0F 84 EE 01 00 00 8D 4E 03 E8 ?? ?? ?? ?? 83 F8 01 0F 84 75 01 00 00 8D 4E 03 E8 ?? ?? ?? ?? 85 C0 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 5C 01 00 00 81 FF FC 00 00 00 0F 84 B8 01 00 00 48 8D 2D ?? ?? ?? ?? 41 BC 14 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B CD 41 8B D4 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 14 01 00 00 4C 8D 2D ?? ?? ?? ?? 41 B8 04 01 00 00 66 89 35 ?? ?? ?? ?? 49 8B D5 FF 15 ?? ?? ?? ?? 41 8D 7C 24 E7 85 C0 75 2A 4C 8D 05 ?? ?? ?? ?? 8B D7 49 8B CD E8 ?? ?? ?? ?? 85 C0 74 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 49 8B CD E8 ?? ?? ?? ?? 48 FF C0 48 83 F8 3C 76 47 49 8B CD E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 41 B9 03 00 00 00 48 8D 4C 45 BC 48 8B C1 49 2B C5 48 D1 F8 48 2B F8 48 8B D7 E8 ?? ?? ?? ?? 85 C0 74 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 4C 8D 05 ?? ?? ?? ?? 49 8B D4 48 8B CD E8 ?? ?? ?? ?? 85 C0 75 41 4C 8B C3 49 8B D4 48 8B CD E8 ?? ?? ?? ?? 85 C0 75 1A 48 8D 15 ?? ?? ?? ?? 41 B8 10 20 01 00 48 8B CD E8 ?? ?? ?? ?? E9 A5 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 48 89 74 24 20 E8 ?? ?? ?? ?? CC B9 F4 FF FF FF FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 55 48 83 F8 FF 74 4F 8B D6 4C 8D 44 24 40 8A 0B 41 88 08 66 39 33 74 11 FF C2 49 FF C0 48 83 C3 02 81 FA F4 01 00 00 72 E5 48 8D 4C 24 40 40 88 B4 24 33 02 00 00 E8 ?? ?? ?? ?? 4C 8D 4C 24 30 48 8D 54 24 40 48 8B CF 4C 8B C0 48 89 74 24 20 FF 15 ?? ?? ?? ?? 48 8B 8C 24 40 02 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 50 02 00 00 49 8B 5B 28 49 8B 6B 30 49 8B 73 38 49 8B E3 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_FF_MSGBANNER"
		size = 67
		refs = "000a _set_error_mode 0023 __app_type 0030 _NMSG_WRITE"
	strings:
		$1 = { 48 83 EC 28 B9 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 74 17 B9 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1D 83 3D ?? ?? ?? ?? 01 75 14 B9 FC 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 18
		refs = "0007 ?_set_new_handler@@YAP6AH_K@ZP6AH0@Z@Z"
	strings:
		$1 = { 48 83 EC 28 33 C9 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "_vswprintf_helper"
		size = 282
		refs = "0038 memset 0042 _errno 004d _invalid_parameter_noinfo 00c7 _flsbuf"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 41 54 41 55 48 8B EC 48 83 EC 50 33 DB 4D 8B E0 4C 8B E9 48 8B F2 48 8D 4D D8 44 8D 43 28 33 D2 49 8B F9 48 89 5D D0 E8 ?? ?? ?? ?? 48 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 A7 00 00 00 4D 85 E4 74 05 48 85 F6 74 DE C7 45 E8 42 00 00 00 48 89 75 E0 48 89 75 D0 49 81 FC FF FF FF 3F 76 09 C7 45 D8 FF FF FF 7F EB 07 43 8D 04 24 89 45 D8 4C 8B 4D 48 4C 8B 45 40 48 8D 4D D0 48 8B D7 41 FF D5 8B F8 48 85 F6 74 5C 85 C0 78 49 FF 4D D8 78 13 48 8B 45 D0 88 18 48 8B 45 D0 48 FF C0 48 89 45 D0 EB 14 48 8D 55 D0 33 C9 E8 ?? ?? ?? ?? 83 F8 FF 74 21 48 8B 45 D0 FF 4D D8 78 04 88 18 EB 10 48 8D 55 D0 33 C9 E8 ?? ?? ?? ?? 83 F8 FF 74 04 8B C7 EB 0F 39 5D D8 66 42 89 5C 66 FE 0F 9D C3 8D 43 FE 4C 8D 5C 24 50 49 8B 5B 20 49 8B 73 28 49 8B 7B 30 49 8B E3 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "_vswprintf_c"
		size = 49
		refs = "001b _woutput_l 0020 _vswprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 28 48 83 64 24 20 00 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_1_0 {
	meta:
		name = "_vsnprintf_c"
		size = 49
		refs = "001b _output_l 0020 _vsnprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 28 48 83 64 24 20 00 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_7_0 {
	meta:
		name = "_vsprintf_p"
		size = 49
		refs = "001b _output_p_l 0020 _vsnprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 28 48 83 64 24 20 00 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_7_0 {
	meta:
		name = "_vswprintf_p"
		size = 49
		refs = "001b _woutput_p_l 0020 _vswprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 28 48 83 64 24 20 00 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_2_0 {
	meta:
		name = "_vswprintf_c_l"
		size = 53
		refs = "001f _woutput_l 0024 _vswprintf_helper"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_2_0 {
	meta:
		name = "_vsnprintf_c_l"
		size = 53
		refs = "001f _output_l 0024 _vsnprintf_helper"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_8_0 {
	meta:
		name = "_vsprintf_p_l"
		size = 53
		refs = "001f _output_p_l 0024 _vsnprintf_helper"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_8_0 {
	meta:
		name = "_vswprintf_p_l"
		size = 53
		refs = "001f _woutput_p_l 0024 _vswprintf_helper"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_3_0 {
	meta:
		name = "_vswprintf_s_l"
		size = 121
		refs = "0039 _woutput_s_l 003e _vswprintf_helper 004f _errno 0067 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 33 FF 48 8B D9 4D 85 C0 74 47 48 85 C9 74 42 48 85 D2 74 3D 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 03 66 89 3B 83 F8 FE 75 20 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_137_4_0 {
	meta:
		name = "vswprintf_s"
		size = 22
		refs = "000d _vswprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_685_3_0 {
	meta:
		name = "?vswprintf@@YAHPEAG_KPEBGPEAD@Z"
		size = 22
		refs = "000d ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_685_1_0 {
	meta:
		name = "?vswprintf@@YAHPEA_W_KPEB_WPEAD@Z"
		size = 22
		refs = "000d ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_621_1_0 {
	meta:
		name = "_vsnprintf"
		size = 22
		refs = "000d _vsnprintf_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_380_1_0 {
	meta:
		name = "_vsnwprintf"
		size = 22
		refs = "000d _vsnwprintf_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_857_4_0 {
	meta:
		name = "vsprintf_s"
		size = 22
		refs = "000d _vsprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_5_0 {
	meta:
		name = "_vsnwprintf_s_l"
		size = 333
		refs = "0062 _errno 006d _woutput_s_l 008e _vswprintf_helper 012d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 48 83 EC 30 45 33 ED 49 8B E9 49 8B F0 48 8B DA 48 8B F9 4D 85 C9 0F 84 F1 00 00 00 4D 85 C0 75 15 48 85 C9 75 19 48 85 D2 0F 85 DE 00 00 00 33 C0 E9 EA 00 00 00 48 85 C9 0F 84 CE 00 00 00 48 85 D2 0F 84 C5 00 00 00 49 3B D0 76 50 E8 ?? ?? ?? ?? 4C 8D 46 01 48 8D 0D ?? ?? ?? ?? 8B 18 48 8B 44 24 78 4C 8B CD 48 89 44 24 28 48 8B 44 24 70 48 8B D7 48 89 44 24 20 E8 ?? ?? ?? ?? 83 F8 FE 75 70 E8 ?? ?? ?? ?? 83 38 22 0F 85 8C 00 00 00 E8 ?? ?? ?? ?? 89 18 E9 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 4C 8B CD 44 8B 20 48 8B 44 24 78 4C 8B C3 48 89 44 24 28 48 8B 44 24 70 48 8B D7 48 89 44 24 20 E8 ?? ?? ?? ?? 66 44 89 6C 5F FE 83 F8 FE 75 1A 48 83 FE FF 75 18 E8 ?? ?? ?? ?? 83 38 22 75 34 E8 ?? ?? ?? ?? 44 89 20 EB 2A 85 C0 79 29 66 44 89 2F 83 F8 FE 75 1D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "winit_namebuf"
		size = 309
		refs = "0029 tmpnam_s_buf 0039 tmpfile_buf 0047 tmpnam_buf 0053 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 005e wcscpy_s 00ad _getpid 00c0 _ultow_s 00cb ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00d6 wcscat_s 00ef _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 30 33 F6 8B D9 8B D1 85 C9 74 26 FF CA 74 14 FF CA 75 09 48 8D 2D ?? ?? ?? ?? EB 0E 48 8B 6C 24 48 EB 1A 48 8D 2D ?? ?? ?? ?? BE 12 00 00 00 EB 0C 48 8D 2D ?? ?? ?? ?? BE 0E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 A0 00 00 00 48 8D 7D 02 B8 5C 00 00 00 66 39 47 FE 74 0E 66 83 7F FE 2F 74 07 66 89 07 48 83 C7 02 B8 74 00 00 00 83 FB 01 74 05 B8 73 00 00 00 66 89 07 48 83 C7 02 48 8B DE 48 8B C7 48 2B C5 48 D1 F8 48 2B D8 E8 ?? ?? ?? ?? 41 B9 20 00 00 00 4C 8B C3 48 8B D7 8B C8 E8 ?? ?? ?? ?? 85 C0 75 2C 4C 8D 05 ?? ?? ?? ?? 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 85 C0 74 42 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 5C 24 40 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_143_2_0 {
	meta:
		name = "wgenfname"
		size = 236
		refs = "0015 __security_cookie 0030 wcsrchr 005d wcstoul 0077 _ultow_s 008e wcscpy_s 00a7 _invoke_watson 00c3 _invalid_parameter_noinfo 00d3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 6C 24 20 56 57 41 54 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 48 8B FA BA 2E 00 00 00 45 8B E0 48 8B E9 E8 ?? ?? ?? ?? 48 8D 70 02 48 3B F5 0F 82 81 00 00 00 48 8B DE 48 2B DD 48 D1 FB 48 3B FB 76 73 BD 20 00 00 00 33 D2 48 8B CE 44 8B C5 E8 ?? ?? ?? ?? FF C0 41 3B C4 73 5F 44 8D 45 E8 48 8D 54 24 30 44 8B CD 8B C8 E8 ?? ?? ?? ?? 85 C0 75 2D 48 2B FB 4C 8D 44 24 30 48 8B CE 48 8B D7 E8 ?? ?? ?? ?? 85 C0 74 34 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 83 C8 FF 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 50 49 8B 5B 30 49 8B 6B 38 49 8B E3 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_143_3_0 {
	meta:
		name = "_wtmpnam_helper"
		size = 453
		refs = "002b _errno 0039 _mtinitlocknum 005e _lock 006a tmpnam_buf 0077 tmpnam_s_buf 008b winit_namebuf 009d wgenfname 00af _waccess_s 00da _getptd_noexit 00ff _calloc_crt 011c wcscpy_s 0134 _invoke_watson 0140 wcslen 0187 _unlock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 44 89 48 20 41 54 41 56 41 57 48 83 EC 40 41 8B F8 4C 8B FA 4C 8B E1 33 F6 8B DE E8 ?? ?? ?? ?? 8B 00 89 44 24 30 8D 4E 02 E8 ?? ?? ?? ?? 85 C0 75 17 48 8B 84 24 80 00 00 00 48 89 30 E8 ?? ?? ?? ?? 8B 00 E9 53 01 00 00 B9 02 00 00 00 E8 ?? ?? ?? ?? 90 85 FF 75 0D 48 8D 35 ?? ?? ?? ?? 44 8D 77 0E EB 0D 48 8D 35 ?? ?? ?? ?? 41 BE 12 00 00 00 33 C0 66 39 06 75 09 8B CF E8 ?? ?? ?? ?? EB 18 44 8B 44 24 78 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 D8 00 00 00 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 1A 44 8B 44 24 78 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 B2 00 00 00 EB D8 45 33 F6 4D 85 E4 75 5F E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 0A BB 0C 00 00 00 E9 91 00 00 00 4C 39 70 50 75 16 BA 02 00 00 00 8D 4A 0C E8 ?? ?? ?? ?? 48 89 47 50 48 85 C0 74 DA 4C 8B 67 50 4C 8B C6 BA 0E 00 00 00 49 8B CC E8 ?? ?? ?? ?? 85 C0 74 5D 4C 89 74 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 FF 74 1E 48 8B CE E8 ?? ?? ?? ?? 49 3B C7 72 11 BB 22 00 00 00 4D 85 FF 74 2E 66 45 89 34 24 EB 27 4C 8B C6 49 8B D7 49 8B CC E8 ?? ?? ?? ?? 85 C0 74 15 4C 89 74 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 B9 02 00 00 00 E8 ?? ?? ?? ?? 4C 8B 9C 24 80 00 00 00 4D 89 23 E8 ?? ?? ?? ?? 85 DB 74 04 89 18 EB 06 8B 4C 24 30 89 08 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_143_5_0 {
	meta:
		name = "_wtmpnam_s"
		size = 64
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0037 _wtmpnam_helper"
	strings:
		$1 = { 48 83 EC 38 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 1B 48 8D 44 24 40 41 B9 FF FF FF 7F 41 B8 02 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_259_6_0 {
	meta:
		name = "tmpnam_s"
		size = 64
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0037 _tmpnam_helper"
	strings:
		$1 = { 48 83 EC 38 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 1B 48 8D 44 24 40 41 B9 FF FF FF 7F 41 B8 02 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_143_6_0 {
	meta:
		name = "_wtmpnam"
		size = 48
		refs = "0022 _wtmpnam_helper"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 48 00 48 8D 44 24 48 41 B9 FF 7F 00 00 45 33 C0 48 83 CA FF 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_259_7_0 {
	meta:
		name = "tmpnam"
		size = 48
		refs = "0022 _tmpnam_helper"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 48 00 48 8D 44 24 48 41 B9 FF 7F 00 00 45 33 C0 48 83 CA FF 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_logb"
		size = 290
		refs = "0073 ??_C@_05JGDBENOH@_logb?$AA@ 007d _handle_error"
	strings:
		$1 = { 48 83 EC 58 F2 0F 11 44 24 60 41 B8 FF 03 00 00 48 BA FF FF FF FF FF FF FF 7F 48 8B 44 24 60 66 0F 28 C8 48 8B C8 48 C1 E9 34 81 E1 FF 07 00 00 49 2B C8 48 85 C2 75 4E 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 02 00 00 00 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 49 B8 00 00 00 00 00 00 F0 FF 48 8D 0D ?? ?? ?? ?? BA 25 00 00 00 E8 ?? ?? ?? ?? E9 97 00 00 00 48 C7 C2 02 FC FF FF 48 3B CA 7C 10 49 3B C8 7F 10 66 0F EF C0 F2 48 0F 2A C1 EB 7B 49 3B C8 7E 49 48 B9 FF FF FF FF FF FF 0F 00 48 85 C1 74 67 66 0F 57 C0 C7 44 24 40 01 00 00 00 49 B8 00 00 00 00 00 00 08 00 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 4C 0B C0 83 64 24 20 00 41 B9 01 00 00 00 EB 80 48 B9 FF FF FF FF FF FF 0F 00 48 23 C1 48 B9 00 00 00 00 00 00 10 00 EB 06 48 03 C0 48 FF CA 48 3B C1 72 F5 66 0F EF C0 F2 48 0F 2A C2 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_146_3_0 {
	meta:
		name = "_validate_param_reuseW"
		size = 372
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 44 0F B7 59 10 8B FA 48 8B D9 66 41 83 FB 70 0F 84 3C 01 00 00 66 41 83 F8 70 0F 84 31 01 00 00 45 33 D2 BA 01 00 00 00 66 41 83 FB 73 74 0A 41 8B CA 66 41 83 FB 53 75 02 8B CA 66 41 83 F8 73 74 0A 41 8B C2 66 41 83 F8 53 75 02 8B C2 85 C9 0F 85 DA 00 00 00 85 C0 0F 85 EC 00 00 00 66 B9 69 00 66 41 83 FB 64 74 77 66 44 3B D9 74 45 66 41 83 FB 6F 74 3E 66 41 83 FB 75 74 37 66 41 83 FB 78 74 30 66 41 83 FB 58 74 29 66 41 83 F8 64 74 22 66 44 3B C1 74 1C 66 41 83 F8 6F 74 15 66 41 83 F8 75 74 0E 66 41 83 F8 78 74 07 66 41 83 F8 58 75 78 66 41 83 FB 64 74 25 66 44 3B D9 74 1F 66 41 83 FB 6F 74 18 66 41 83 FB 75 74 11 66 41 83 FB 78 74 0A 41 8B C2 66 41 83 FB 58 75 02 8B C2 66 41 83 F8 64 74 25 66 44 3B C1 74 1F 66 41 83 F8 6F 74 18 66 41 83 F8 75 74 11 66 41 83 F8 78 74 0A 66 41 83 F8 58 74 03 41 8B D2 3B C2 74 04 33 C0 EB 49 8B 4B 14 8B C1 41 33 C1 0F BA E0 10 72 EE 41 33 C9 F6 C1 20 75 E6 39 3B EB 28 3B C8 75 16 8B 43 14 41 C1 E9 05 C1 E8 05 41 F7 D1 F7 D0 41 33 C1 84 C2 74 03 41 8B D2 8B C2 EB 0E 45 33 D2 66 45 3B D8 41 0F 94 C2 41 8B C2 48 8B 5C 24 08 48 8B 7C 24 10 C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "write_char"
		size = 55
		refs = "001c _fputwc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 42 18 40 49 8B D8 74 0C 48 83 7A 10 00 75 05 41 FF 00 EB 16 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 05 83 0B FF EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_146_5_0 {
	meta:
		name = "write_multi_char"
		size = 81
		refs = "002f write_char"
	strings:
		$1 = { 85 D2 7E 4C 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F9 49 8B F0 8B DA 0F B7 E9 4C 8B C7 48 8B D6 0F B7 CD FF CB E8 ?? ?? ?? ?? 83 3F FF 74 04 85 DB 7F E7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_146_6_0 {
	meta:
		name = "write_string"
		size = 172
		refs = "0025 _errno 0054 write_char"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 49 8B D9 49 8B F0 8B FA 48 8B E9 E8 ?? ?? ?? ?? F6 46 18 40 44 8B 20 74 0B 48 83 7E 10 00 75 04 01 3B EB 54 E8 ?? ?? ?? ?? 83 20 00 EB 34 0F B7 4D 00 4C 8B C3 48 8B D6 FF CF E8 ?? ?? ?? ?? 48 83 C5 02 83 3B FF 75 1A E8 ?? ?? ?? ?? 83 38 2A 75 14 B9 3F 00 00 00 4C 8B C3 48 8B D6 E8 ?? ?? ?? ?? 85 FF 7F C8 E8 ?? ?? ?? ?? 83 38 00 75 08 E8 ?? ?? ?? ?? 44 89 20 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_146_9_0 {
	meta:
		name = "_woutput_p_l"
		size = 4520
		refs = "0022 __security_cookie 0060 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0075 _errno 0080 _invalid_parameter_noinfo 014b __lookuptable_s 01a9 wcstol 01d4 memset 040d _validate_param_reuseW 0447 __nullstring 044f strlen 051a _mbtowc_l 0693 _isleadbyte_l 06be __wnullstring 077e _get_printf_count_output 0ac4 _malloc_crt 0b27 _cfltcvt_tab 0b34 __imp_DecodePointer 0c25 write_multi_char 0c38 write_string 0ca1 write_char 0d04 free 1108 get_crtdouble_arg 1189 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 A0 F2 FF FF 48 81 EC 60 0E 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 50 0D 00 00 33 FF 48 8B D9 48 89 4D C8 4C 8B E2 48 89 55 E8 48 8D 4C 24 68 49 8B D0 4C 89 4C 24 50 89 7D C0 44 8B F7 89 7C 24 64 89 7C 24 48 89 7C 24 40 E8 ?? ?? ?? ?? 41 83 C8 FF 41 8B F0 48 89 7D B8 48 85 DB 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7D 80 74 0C 48 8B 4C 24 78 83 A1 C8 00 00 00 FD 83 C8 FF E9 E0 10 00 00 4D 85 E4 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7D 80 74 DD 48 8B 44 24 78 83 A0 C8 00 00 00 FD EB CF 48 8B 5D E8 4C 8B 6C 24 50 8B C7 8B CF 89 44 24 60 89 4D B0 83 F9 01 75 08 85 F6 0F 84 84 10 00 00 41 8B D0 4D 8B CC 45 0F B7 24 24 45 8B D8 44 89 44 24 44 41 8B F0 44 89 45 88 4C 63 45 B0 44 8B FF 44 8B D7 48 89 7D D8 89 7D 8C 89 7C 24 58 89 54 24 5C 4C 89 45 98 66 45 85 E4 0F 84 05 10 00 00 49 83 C1 02 4C 89 4D A0 85 C0 0F 88 79 0F 00 00 41 8D 44 24 E0 B9 58 00 00 00 66 3B C1 77 18 48 8D 0D ?? ?? ?? ?? 41 0F B7 C4 0F B6 4C 08 E0 83 E1 0F 45 33 DB EB 06 45 33 DB 41 8B CB 48 63 C1 48 8D 0C C0 49 63 C2 48 03 C8 48 8D 05 ?? ?? ?? ?? 0F B6 04 01 C1 E8 04 89 45 C4 83 F8 01 0F 85 DE 00 00 00 66 41 83 39 25 0F 84 DC 00 00 00 83 FE FF 75 5D 44 8D 40 09 48 8D 55 B8 49 8B C9 E8 ?? ?? ?? ?? 45 33 DB 85 C0 7E 2E 48 8B 45 B8 66 83 38 24 75 24 4C 39 5D 98 75 14 48 8D 8D F0 03 00 00 33 D2 41 B8 60 09 00 00 E8 ?? ?? ?? ?? BE 01 00 00 00 89 75 88 EB 1D 4C 8B 6C 24 50 8B 54 24 5C 4C 8B 45 98 4C 8B 4D A0 41 8B F3 44 89 5D 88 83 FE 01 75 75 48 8B 4D A0 48 8D 55 B8 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D B8 4C 8B 45 98 4C 8D 49 02 8D 50 FF 45 33 DB 4C 89 4D A0 89 54 24 5C 4D 85 C0 75 33 85 D2 0F 88 E0 01 00 00 66 83 39 24 0F 85 D6 01 00 00 45 8D 50 64 41 3B D2 0F 8D C9 01 00 00 8B 44 24 44 4C 8B 6C 24 50 3B D0 0F 4F C2 89 44 24 44 EB 16 4C 8B 6C 24 50 EB 09 83 F8 08 0F 84 A5 01 00 00 41 BA 64 00 00 00 8B 4D C4 85 C9 0F 84 CF 0D 00 00 FF C9 0F 84 A4 0D 00 00 FF C9 0F 84 44 0D 00 00 FF C9 0F 84 A4 0C 00 00 FF C9 0F 84 8F 0C 00 00 FF C9 0F 84 54 0B 00 00 FF C9 0F 84 67 0A 00 00 FF C9 0F 85 D7 0D 00 00 41 0F B7 C4 41 3B C2 0F 8F F5 02 00 00 0F 84 EA 04 00 00 83 F8 41 0F 84 82 02 00 00 83 F8 43 0F 84 B4 01 00 00 83 F8 45 0F 84 70 02 00 00 83 F8 47 0F 84 67 02 00 00 83 F8 53 0F 84 63 01 00 00 B9 58 00 00 00 3B C1 0F 84 EE 03 00 00 83 F8 5A 74 5E 83 F8 61 0F 84 4F 02 00 00 83 F8 63 0F 84 89 01 00 00 BF 2D 00 00 00 B9 20 00 00 00 44 8B 64 24 40 8B 44 24 48 83 7D 88 01 75 0D 4C 8B 45 98 4D 85 C0 0F 84 41 0D 00 00 85 C0 0F 85 AB 09 00 00 41 F6 C6 40 0F 84 A8 08 00 00 41 0F BA E6 08 0F 83 77 08 00 00 66 89 7D A8 E9 7D 08 00 00 85 F6 75 0F 49 83 C5 08 4C 89 6C 24 50 49 8B 45 F8 EB 24 83 FA 63 0F 87 90 00 00 00 48 63 C2 48 8D 0C 40 4D 85 C0 0F 84 A4 02 00 00 48 8B 84 CD F8 03 00 00 48 8B 00 48 85 C0 0F 84 97 00 00 00 48 8B 58 08 48 85 DB 0F 84 8A 00 00 00 B9 20 00 00 00 8D 79 0D 41 0F BA E6 0B 73 6A 0F BF 00 C7 44 24 40 01 00 00 00 99 2B C2 D1 F8 44 8B F8 E9 4A FF FF FF C7 00 02 00 00 00 66 44 89 A4 CD 00 04 00 00 44 89 B4 CD 04 04 00 00 E9 24 FF FF FF BA 02 00 00 00 45 0F B7 C4 45 8B CE 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 08 FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C9 38 4D 80 E9 84 FC FF FF 44 0F BF 38 44 89 5C 24 40 45 8B E3 E9 EC FE FF FF 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 4C 8B F8 4C 8B 6C 24 50 E9 C1 FE FF FF 41 F7 C6 30 08 00 00 75 04 41 83 CE 20 83 FF FF 8B F7 B8 FF FF FF 7F 0F 44 F0 44 39 5D 88 0F 85 A4 01 00 00 49 83 C5 08 4C 89 6C 24 50 49 8B 5D F8 E9 C8 01 00 00 41 B9 20 00 00 00 41 F7 C6 30 08 00 00 75 0B 45 0B F1 EB 06 41 B9 20 00 00 00 C7 44 24 40 01 00 00 00 85 F6 75 10 49 83 C5 08 4C 89 6C 24 50 41 0F B7 45 F8 EB 24 83 FA 63 0F 87 44 FF FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 0F 84 CA 03 00 00 48 8B 84 CD F8 03 00 00 0F B7 00 66 89 45 90 45 84 F1 74 43 88 45 AC 48 8B 44 24 68 44 88 5D AD 4C 63 80 0C 01 00 00 4C 8D 4C 24 68 48 8D 55 AC 48 8D 4D F0 E8 ?? ?? ?? ?? 4C 8B 6C 24 50 85 C0 79 19 C7 44 24 48 01 00 00 00 EB 0F C7 00 01 00 00 00 E9 AB FE FF FF 66 89 45 F0 41 BF 01 00 00 00 48 8D 5D F0 41 8D 4F 1F 45 8B E7 BF 2D 00 00 00 E9 D5 FD FF FF C7 45 D0 01 00 00 00 66 41 83 C4 20 B9 67 00 00 00 41 83 CE 40 83 FE 01 0F 85 01 05 00 00 4D 85 C0 0F 85 F8 04 00 00 83 FA 63 0F 87 8E FE FF FF 48 63 C2 48 8D 0C 40 48 8D 84 CD F0 03 00 00 44 39 18 0F 85 AF 04 00 00 C7 00 07 00 00 00 66 44 89 A4 CD 00 04 00 00 44 89 B4 CD 04 04 00 00 E9 D5 0A 00 00 83 F8 65 0F 8C 59 FD FF FF B9 67 00 00 00 3B C1 7E 9B B9 69 00 00 00 3B C1 0F 84 DC 01 00 00 83 F8 6E 0F 84 5F 01 00 00 B9 6F 00 00 00 3B C1 0F 84 39 01 00 00 83 F8 70 0F 84 ED 00 00 00 83 F8 73 0F 84 67 FE FF FF B9 75 00 00 00 3B C1 0F 84 AB 01 00 00 B9 78 00 00 00 3B C1 0F 85 01 FD FF FF 8D 41 AF E9 D5 00 00 00 83 FA 63 0F 87 E8 FD FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 75 16 48 8D 84 CD F0 03 00 00 44 39 18 0F 84 93 FD FF FF E9 AA FD FF FF 48 8B 9C CD F8 03 00 00 48 8B 1B B9 20 00 00 00 44 84 F1 74 49 48 85 DB 45 8B FB 48 0F 44 1D ?? ?? ?? ?? 48 8B FB 85 F6 0F 8E 50 05 00 00 44 38 1F 0F 84 CC FD FF FF 0F B6 0F 48 8D 54 24 68 E8 ?? ?? ?? ?? 45 33 DB 85 C0 74 03 48 FF C7 41 FF C7 48 FF C7 44 3B FE 7C D5 E9 A5 FD FF FF 48 85 DB 41 BC 01 00 00 00 48 0F 44 1D ?? ?? ?? ?? 44 89 64 24 40 48 8B C3 EB 0C FF CE 66 44 39 18 74 08 48 83 C0 02 85 F6 75 F0 48 2B C3 48 D1 F8 44 8B F8 E9 67 FE FF FF BF 10 00 00 00 41 0F BA EE 0F 89 7C 24 58 B8 07 00 00 00 89 45 C0 41 B9 10 00 00 00 45 84 F6 0F 89 B5 00 00 00 41 8D 49 20 45 8D 51 F2 66 83 C0 51 66 89 4D A8 44 89 54 24 64 66 89 45 AA E9 9C 00 00 00 41 B9 08 00 00 00 45 84 F6 0F 89 88 00 00 00 B8 00 02 00 00 44 0B F0 EB 7E 85 F6 75 0F 49 83 C5 08 4C 89 6C 24 50 49 8B 7D F8 EB 24 83 FA 63 0F 87 B7 FC FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 0F 84 CB FE FF FF 48 8B 84 CD F8 03 00 00 48 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 8F FC FF FF 8B 44 24 60 B9 20 00 00 00 44 84 F1 74 05 66 89 07 EB 02 89 07 4C 8B 6C 24 50 44 8B 64 24 40 B8 01 00 00 00 8D 78 2C 89 44 24 48 E9 7A FB FF FF 41 83 CE 40 41 B9 0A 00 00 00 44 8B 54 24 64 41 0F BA E6 0F 73 4D 85 F6 75 12 49 83 C5 08 4C 89 6C 24 50 4D 8B 45 F8 E9 A5 01 00 00 83 FA 63 0F 87 2A FC FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 75 64 48 8D 84 CD F0 03 00 00 44 39 18 75 0B C7 00 03 00 00 00 E9 D4 FB FF FF BA 03 00 00 00 E9 E5 FB FF FF 41 0F BA E6 0C 73 4B 85 F6 74 AC 83 FA 63 0F 87 E8 FB FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 75 22 48 8D 84 CD F0 03 00 00 44 39 18 75 0B C7 00 04 00 00 00 E9 92 FB FF FF BA 04 00 00 00 E9 A3 FB FF FF 48 8B 84 CD F8 03 00 00 4C 8B 00 E9 1C 01 00 00 B8 20 00 00 00 44 84 F0 0F 84 98 00 00 00 41 F6 C6 40 74 58 85 F6 75 13 49 83 C5 08 4C 89 6C 24 50 4D 0F BF 45 F8 E9 F1 00 00 00 83 FA 63 0F 87 76 FB FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 75 1B 48 8D 84 CD F0 03 00 00 44 39 18 0F 84 71 FC FF FF BA 01 00 00 00 E9 38 FB FF FF 48 8B 84 CD F8 03 00 00 4C 0F BF 00 E9 B0 00 00 00 85 F6 75 13 49 83 C5 08 4C 89 6C 24 50 45 0F B7 45 F8 E9 99 00 00 00 83 FA 63 0F 87 1E FB FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 74 A8 48 8B 84 CD F8 03 00 00 44 0F B7 00 EB 76 41 F6 C6 40 74 39 85 F6 75 0F 49 83 C5 08 4C 89 6C 24 50 4D 63 45 F8 EB 5D 83 FA 63 0F 87 E2 FA FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 0F 84 68 FF FF FF 48 8B 84 CD F8 03 00 00 4C 63 00 EB 37 85 F6 75 0F 49 83 C5 08 4C 89 6C 24 50 45 8B 45 F8 EB 24 83 FA 63 0F 87 A9 FA FF FF 48 63 C2 48 8D 0C 40 4D 85 C0 0F 84 2F FF FF FF 48 8B 84 CD F8 03 00 00 44 8B 00 41 F6 C6 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EE 08 41 0F BA E6 0F 72 0A 41 0F BA E6 0C 72 03 45 8B C0 85 FF 79 07 BF 01 00 00 00 EB 0E BA 00 02 00 00 41 83 E6 F7 3B FA 0F 4F FA 44 8B 6D C0 49 8B C0 48 8D 9D EF 01 00 00 48 F7 D8 1B C9 41 23 CA 89 4C 24 64 8B CF FF CF 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C5 88 03 48 FF CB EB D3 4C 8B 6C 24 50 4C 8D BD EF 01 00 00 B8 00 02 00 00 44 2B FB 48 FF C3 89 7C 24 58 44 85 F0 0F 84 EE F8 FF FF B8 30 00 00 00 45 85 FF 74 08 38 03 0F 84 DC F8 FF FF 48 FF CB 41 FF C7 88 03 E9 CF F8 FF FF 45 8B CE 45 0F B7 C4 BA 07 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 E2 06 00 00 4C 8B 45 98 E9 12 06 00 00 B8 00 02 00 00 48 8D 5D F0 8B F0 85 FF 79 0D 41 BF 06 00 00 00 44 89 7C 24 58 EB 56 75 0E 66 44 3B E1 75 44 41 BF 01 00 00 00 EB E9 3B F8 41 BF A3 00 00 00 0F 4F F8 89 7C 24 58 41 3B FF 7E 2F 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 4C 8B 6C 24 50 8B 54 24 5C 45 33 DB 48 89 45 D8 48 85 C0 74 B2 48 8B D8 8B F7 44 8B 7C 24 58 EB 03 44 8B FF 44 39 5D 88 75 13 49 83 C5 08 4C 89 6C 24 50 49 8B 45 F8 48 89 45 E0 EB 1F 83 FA 63 0F 87 0B F9 FF FF 48 63 C2 48 8D 0C 40 48 8B 84 CD F8 03 00 00 48 8B 08 48 89 4D E0 48 8B 0D ?? ?? ?? ?? 41 0F BE FC 48 63 F6 FF 15 ?? ?? ?? ?? 48 8D 4C 24 68 44 8B CF 48 89 4C 24 30 8B 4D D0 4C 8B C6 89 4C 24 28 48 8D 4D E0 48 8B D3 44 89 7C 24 20 FF D0 41 8B FE 81 E7 80 00 00 00 74 1C 45 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 68 48 8B CB FF D0 BA 67 00 00 00 66 44 3B E2 75 1B 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 68 48 8B CB FF D0 BF 2D 00 00 00 40 38 3B 75 08 41 0F BA EE 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 4C 8B 6C 24 50 44 8B F8 E9 55 F7 FF FF BF 2D 00 00 00 E9 50 F7 FF FF 41 F6 C6 01 74 14 B8 2B 00 00 00 66 89 45 A8 BE 01 00 00 00 89 74 24 64 EB 10 41 F6 C6 02 74 06 66 89 4D A8 EB E9 8B 74 24 64 44 8B 6D 8C 48 8B 7D C8 45 2B EF 44 2B EE 41 F6 C6 0C 75 10 4C 8D 4C 24 60 4C 8B C7 41 8B D5 E8 ?? ?? ?? ?? 4C 8D 4C 24 60 48 8D 4D A8 4C 8B C7 8B D6 E8 ?? ?? ?? ?? 41 F6 C6 08 74 1B 41 F6 C6 04 75 15 4C 8D 4C 24 60 B9 30 00 00 00 4C 8B C7 41 8B D5 E8 ?? ?? ?? ?? 45 85 E4 75 5D 45 85 FF 7E 58 48 8B FB 41 8B F7 48 8B 44 24 68 4C 8D 4C 24 68 48 8D 4D 90 4C 63 80 0C 01 00 00 48 8B D7 FF CE E8 ?? ?? ?? ?? 4C 63 E0 85 C0 7E 1F 48 8B 55 C8 0F B7 4D 90 4C 8D 44 24 60 E8 ?? ?? ?? ?? 49 03 FC 85 F6 7F C1 48 8B 7D C8 EB 20 48 8B 7D C8 83 C8 FF 89 44 24 60 EB 17 4C 8D 4C 24 60 4C 8B C7 41 8B D7 48 8B CB E8 ?? ?? ?? ?? 8B 44 24 60 85 C0 78 1B 41 F6 C6 04 74 15 4C 8D 4C 24 60 B9 20 00 00 00 4C 8B C7 41 8B D5 E8 ?? ?? ?? ?? 4C 8B 6C 24 50 48 8B 4D D8 48 85 C9 74 10 E8 ?? ?? ?? ?? 4C 8B 6C 24 50 33 C9 48 89 4D D8 8B 7C 24 58 E9 55 FD FF FF 41 0F B7 C4 83 F8 49 74 4C 83 F8 68 74 3E B9 6C 00 00 00 3B C1 74 13 83 F8 77 0F 85 58 03 00 00 41 0F BA EE 0B E9 4E 03 00 00 44 8B 5C 24 44 66 41 39 09 75 0E 49 83 C1 02 41 0F BA EE 0C E9 3A 03 00 00 41 83 CE 10 E9 31 03 00 00 41 83 CE 20 E9 23 03 00 00 B8 00 80 00 00 44 0B F0 66 41 83 39 36 75 14 66 41 83 79 02 34 75 0C 49 83 C1 04 44 0B F0 E9 00 03 00 00 66 41 83 39 33 75 16 66 41 83 79 02 32 75 0E 49 83 C1 04 41 0F BA F6 0F E9 E3 02 00 00 66 45 39 11 74 40 B8 69 00 00 00 66 41 39 01 74 35 B8 6F 00 00 00 66 41 39 01 74 2A B8 75 00 00 00 66 41 39 01 74 1F B8 78 00 00 00 66 41 39 01 74 14 B8 58 00 00 00 66 41 39 01 74 09 44 89 5D C4 E9 72 02 00 00 41 0F BA EE 10 E9 93 02 00 00 B8 2A 00 00 00 66 44 3B E0 0F 85 10 01 00 00 85 F6 75 12 49 83 C5 08 4C 89 6C 24 50 41 8B 7D F8 E9 DD 00 00 00 48 8D 55 B8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D B8 4C 8B 45 98 4C 8D 49 02 FF C8 4C 89 4D A0 4D 85 C0 0F 85 97 00 00 00 85 C0 0F 88 BE F5 FF FF 66 83 39 24 0F 85 B4 F5 FF FF 8B 54 24 5C 41 BA 64 00 00 00 41 3B D2 0F 8D A1 F5 FF FF 44 8B 5C 24 44 41 3B C3 44 0F 4F D8 48 98 45 33 E4 48 8D 0C 40 44 89 5C 24 44 48 8D 84 CD F0 03 00 00 44 39 20 75 24 4C 8B 6C 24 50 C7 00 01 00 00 00 41 8D 42 C6 66 89 84 CD 00 04 00 00 44 89 B4 CD 04 04 00 00 E9 D6 01 00 00 41 B8 2A 00 00 00 45 8B CE 48 8B C8 41 8D 50 D7 E8 ?? ?? ?? ?? 85 C0 0F 84 73 02 00 00 4C 8B 6C 24 50 E9 87 FB FF FF 4C 8B 6C 24 50 8B 54 24 5C 48 98 48 8D 0C 40 48 8B 84 CD F8 03 00 00 8B 38 44 8B 5C 24 44 89 7C 24 58 85 FF 0F 89 85 01 00 00 83 CF FF 89 7C 24 58 E9 79 01 00 00 8D 0C BF 41 0F B7 C4 8D 7C 48 D0 89 7C 24 58 E9 60 01 00 00 41 8B FB 44 89 5C 24 58 E9 53 01 00 00 B8 2A 00 00 00 66 44 3B E0 75 77 85 F6 75 0F 49 83 C5 08 4C 89 6C 24 50 41 8B 4D F8 EB 46 48 8D 55 B8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D B8 4C 8B 45 98 4C 8D 49 02 FF C8 4C 89 4D A0 4D 85 C0 0F 84 C7 FE FF FF 4C 8B 6C 24 50 8B 54 24 5C 48 98 48 8D 0C 40 48 8B 84 CD F8 03 00 00 8B 08 44 8B 5C 24 44 89 4D 8C 85 C9 0F 89 E4 00 00 00 41 83 CE 04 F7 D9 89 4D 8C E9 D6 00 00 00 8B 45 8C 8D 0C 80 41 0F B7 C4 8D 4C 48 D0 89 4D 8C E9 BB 00 00 00 41 0F B7 C4 B9 20 00 00 00 3B C1 74 45 83 F8 23 74 39 B9 2B 00 00 00 3B C1 74 2A B9 2D 00 00 00 3B C1 74 1B 44 8B 5C }
	condition:
		$1
}

rule file_148_3_0 {
	meta:
		name = "_mbctolower_l"
		size = 228
		refs = "0015 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 008c __crtLCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 55 48 8B EC 48 83 EC 70 48 63 D9 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8B 4D E8 81 FB FF 00 00 00 0F 86 8B 00 00 00 8B C3 88 5D 11 C1 E8 08 88 45 10 0F B6 C0 F6 44 08 1D 04 75 17 80 7D F8 00 0F 84 8C 00 00 00 48 8B 45 F0 83 A0 C8 00 00 00 FD EB 7F 8B 41 04 C7 44 24 40 01 00 00 00 BA 02 00 00 00 89 44 24 38 89 54 24 30 48 8D 45 20 48 89 44 24 28 89 54 24 20 8B 51 0C 48 8D 4D E0 4C 8D 4D 10 41 B8 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 AA 0F B6 45 20 0F B6 4D 21 C1 E0 08 03 C1 80 7D F8 00 74 2F 48 8B 4D F0 83 A1 C8 00 00 00 FD EB 22 F6 44 0B 1D 10 74 08 0F B6 9C 0B 1D 01 00 00 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C3 48 8B 9C 24 88 00 00 00 48 83 C4 70 5D C3 }
	condition:
		$1
}

rule file_149_3_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IEAAXW4ConcRT_EventType@3@EKK@Z"
		size = 53
		refs = "0006 ?g_TraceOn@details@Concurrency@@3_NA 0018 ?g_EnableLevel@details@Concurrency@@3EA 002c ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 48 83 EC 28 80 3D ?? ?? ?? ?? 00 45 8B D1 41 8A C0 44 8B DA 74 1A 3A 05 ?? ?? ?? ?? 77 12 44 8B 4C 24 50 45 8B C2 8A D0 41 8B CB E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_229_36_0 {
	meta:
		name = "?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AEAAXW4ConcRT_EventType@3@EKK@Z"
		size = 53
		refs = "0006 ?g_TraceOn@details@Concurrency@@3_NA 0018 ?g_EnableLevel@details@Concurrency@@3EA 002c ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 48 83 EC 28 80 3D ?? ?? ?? ?? 00 45 8B D1 41 8A C0 44 8B DA 74 1A 3A 05 ?? ?? ?? ?? 77 12 44 8B 4C 24 50 45 8B C2 8A D0 41 8B CB E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_149_4_0 {
	meta:
		name = "??0ExternalStatistics@details@Concurrency@@QEAA@XZ"
		size = 21
	strings:
		$1 = { 33 C0 48 89 41 20 48 89 41 28 C7 41 30 01 00 00 00 48 8B C1 C3 }
	condition:
		$1
}

rule file_149_6_0 {
	meta:
		name = "?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QEAAPEAVSubAllocator@23@XZ"
		size = 46
		refs = "0016 ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPEAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 B9 D8 00 00 00 00 48 8B D9 75 0E B1 01 E8 ?? ?? ?? ?? 48 89 83 D8 00 00 00 48 8B 83 D8 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_149_7_0 {
	meta:
		name = "?DetachStatistics@ExternalContextBase@details@Concurrency@@QEAAPEAVExternalStatistics@23@XZ"
		size = 23
	strings:
		$1 = { 48 8B 81 D0 00 00 00 48 83 A1 D0 00 00 00 00 C7 40 30 00 00 00 00 C3 }
	condition:
		$1
}

rule file_149_8_0 {
	meta:
		name = "?PrepareForUse@ExternalContextBase@details@Concurrency@@QEAAX_N@Z"
		size = 198
		refs = "0021 __imp_GetCurrentThreadId 0032 __imp_GetCurrentProcess 003b __imp_GetCurrentThread 006c __imp_DuplicateHandle 0076 __imp_GetLastError 008e ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0095 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 009f _CxxThrowException 00ac ?RegisterForExitTracking@SchedulerBase@details@Concurrency@@QEAAXPEAVExternalContextBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 60 8A DA 48 8B E9 88 91 C8 00 00 00 FF 15 ?? ?? ?? ?? 89 45 68 84 DB 0F 85 80 00 00 00 FF 15 ?? ?? ?? ?? 48 8B F8 FF 15 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? C7 44 24 30 02 00 00 00 83 64 24 28 00 83 64 24 20 00 4C 8D 8D E0 00 00 00 48 8B C8 4C 8B C7 48 8B D3 FF 15 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 48 8D 4C 24 40 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? CC 48 8B 4D 38 48 8B D5 E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 5B 10 49 8B 6B 18 49 8B 73 20 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_149_12_0 {
	meta:
		name = "?Block@ExternalContextBase@details@Concurrency@@UEAAXXZ"
		size = 105
		refs = "001c ?g_TraceOn@details@Concurrency@@3_NA 0027 ?g_EnableLevel@details@Concurrency@@3EA 0039 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z 005a __imp_WaitForSingleObject"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 79 20 48 8B D9 48 8B 49 38 48 8B 01 FF 50 08 80 3D ?? ?? ?? ?? 00 74 1A B2 04 38 15 ?? ?? ?? ?? 72 10 44 8B CF 44 8B C0 B9 03 00 00 00 E8 ?? ?? ?? ?? B8 01 00 00 00 F0 0F C1 43 54 FF C0 83 F8 01 75 10 48 8B 8B E8 00 00 00 83 CA FF FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_13_0 {
	meta:
		name = "?Unblock@ExternalContextBase@details@Concurrency@@UEAAXXZ"
		size = 170
		refs = "000e ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0026 ?g_TraceOn@details@Concurrency@@3_NA 0034 ?g_EnableLevel@details@Concurrency@@3EA 0043 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z 005c __imp_SetEvent 0078 ??0context_unblock_unbalanced@Concurrency@@QEAA@XZ 007f _TI2?AVcontext_unblock_unbalanced@Concurrency@@ 0089 _CxxThrowException 0094 ??0context_self_unblock@Concurrency@@QEAA@XZ 009b _TI2?AVcontext_self_unblock@Concurrency@@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B D9 E8 ?? ?? ?? ?? 48 3B D8 74 77 48 8B 4B 38 8B 7B 20 48 8B 01 FF 50 08 80 3D ?? ?? ?? ?? 00 74 1A B9 04 00 00 00 38 0D ?? ?? ?? ?? 72 0D 44 8B CF 44 8B C0 8A D1 E8 ?? ?? ?? ?? 83 C8 FF F0 0F C1 43 54 FF C8 75 18 48 8B 8B E8 00 00 00 FF 15 ?? ?? ?? ?? 48 8B 5C 24 60 48 83 C4 50 5F C3 FF C0 83 F8 01 76 EE 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_20_0 {
	meta:
		name = "?Yield@ExternalContextBase@details@Concurrency@@UEAAXXZ"
		size = 66
		refs = "0015 ?g_TraceOn@details@Concurrency@@3_NA 0020 ?g_EnableLevel@details@Concurrency@@3EA 0032 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z 003e __imp_SwitchToThread"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 59 20 48 8B 49 38 48 8B 01 FF 50 08 80 3D ?? ?? ?? ?? 00 74 1A B2 04 38 15 ?? ?? ?? ?? 72 10 44 8B CB 44 8B C0 B9 05 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_21_0 {
	meta:
		name = "?Oversubscribe@ExternalContextBase@details@Concurrency@@UEAAX_N@Z"
		size = 58
		refs = "001a ??0invalid_oversubscribe_operation@Concurrency@@QEAA@XZ 0021 _TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 002b _CxxThrowException"
		altNames = "?Oversubscribe@UMSThreadInternalContext@details@Concurrency@@UEAAX_N@Z"
	strings:
		$1 = { 48 83 EC 48 84 D2 74 05 FF 41 2C EB 28 8B 41 2C 85 C0 75 1C 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC FF C8 89 41 2C 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_149_25_0 {
	meta:
		name = "?Alloc@ExternalContextBase@details@Concurrency@@UEAAPEAX_K@Z"
		size = 81
		refs = "001d ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPEAVSubAllocator@23@_N@Z 0038 ?Alloc@SubAllocator@details@Concurrency@@QEAAPEAX_K@Z 0042 ?StaticAlloc@SubAllocator@details@Concurrency@@SAPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 B9 D8 00 00 00 00 48 8B FA 48 8B D9 75 0E B1 01 E8 ?? ?? ?? ?? 48 89 83 D8 00 00 00 48 8B 8B D8 00 00 00 48 85 C9 74 0A 48 8B D7 E8 ?? ?? ?? ?? EB 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_26_0 {
	meta:
		name = "?Free@ExternalContextBase@details@Concurrency@@UEAAXPEAX@Z"
		size = 82
		refs = "001d ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPEAVSubAllocator@23@_N@Z 0038 ?Free@SubAllocator@details@Concurrency@@QEAAXPEAX@Z 0043 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 B9 D8 00 00 00 00 48 8B DA 48 8B F9 75 0E B1 01 E8 ?? ?? ?? ?? 48 89 87 D8 00 00 00 48 8B 8F D8 00 00 00 48 85 C9 74 0A 48 8B D3 E8 ?? ?? ?? ?? EB 09 48 8D 4B F8 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_27_0 {
	meta:
		name = "?RemoveFromUse@ExternalContextBase@details@Concurrency@@QEAAXXZ"
		size = 46
		refs = "000a ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IEAAXXZ 001c __imp_CloseHandle"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B 8B E0 00 00 00 48 85 C9 74 0E FF 15 ?? ?? ?? ?? 48 83 A3 E0 00 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_149_28_0 {
	meta:
		name = "?Cleanup@ExternalContextBase@details@Concurrency@@AEAAXXZ"
		size = 103
		refs = "000a ?Cleanup@ContextBase@details@Concurrency@@QEAAXXZ 001c __imp_CloseHandle 0047 ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPEAVSubAllocator@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B 8B E0 00 00 00 48 85 C9 74 0E FF 15 ?? ?? ?? ?? 48 83 A3 E0 00 00 00 00 48 8B 8B E8 00 00 00 48 85 C9 74 06 FF 15 ?? ?? ?? ?? 48 8B 8B D8 00 00 00 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 8B 83 D0 00 00 00 48 83 A3 D0 00 00 00 00 C7 40 30 00 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_149_41_0 {
	meta:
		name = "?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAAHPEAVExternalStatistics@23@@Z"
		size = 367
		refs = "00c1 ??_U@YAPEAX_K@Z 00d6 memset 00e0 ??2@YAPEAX_K@Z 0127 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0136 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
		altNames = "?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAAHPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 41 55 41 57 48 83 EC 40 48 8B 59 58 33 F6 40 32 ED 4C 8B EA 48 8B F9 49 83 CB FF 44 8D 7E 01 44 39 5B 10 7C 50 4C 8B 0B 33 D2 39 57 50 7E 46 4D 8B C1 49 83 38 00 75 18 8D 04 32 48 63 CA 41 89 45 00 44 8B 57 70 33 C0 F0 4D 0F B1 2C C9 74 0E 41 03 D7 49 83 C0 08 3B 57 50 7D 19 EB D4 03 F2 41 8A EF 41 3B F2 7C 05 F0 44 01 7F 70 8B C2 F0 44 0F B1 5B 10 40 84 ED 0F 85 B4 00 00 00 B9 FE FF FF FF 41 8B C3 F0 0F B1 4B 10 03 77 50 48 83 7B 08 00 75 76 33 C0 F0 4C 0F B1 7B 08 75 6C 48 63 4F 50 B8 08 00 00 00 48 F7 E1 49 0F 40 C3 48 8B C8 E8 ?? ?? ?? ?? 4C 63 47 50 33 D2 49 C1 E0 03 48 8B C8 4C 8B E0 E8 ?? ?? ?? ?? B9 18 00 00 00 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 0E 48 83 60 08 00 83 48 10 FF 4C 89 20 EB 03 45 33 DB 48 63 47 6C 3B 47 68 7D 0F 48 8B C8 48 8B 47 60 4C 89 1C C8 44 01 7F 6C 4C 87 5B 08 4C 39 7B 08 75 21 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 39 7B 08 74 F0 48 8B 5B 08 49 C7 C3 FF FF FF FF 40 84 ED 0F 84 D9 FE FF FF 4C 8D 5C 24 40 8B C6 49 8B 5B 38 49 8B 6B 40 49 8B E3 41 5F 41 5D 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_149_42_0 {
	meta:
		name = "?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ"
		size = 119
		refs = "0036 ??3@YAXPEAX@Z 005e memset"
		altNames = "?Wipe@?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 83 79 04 00 48 8B F9 7E 45 33 F6 39 31 7E 29 33 ED 48 8B 47 08 48 8B 0C 28 48 85 C9 74 10 48 8B 19 E8 ?? ?? ?? ?? 48 8B CB 48 85 DB 75 F0 FF C6 48 83 C5 08 3B 37 7C D9 4C 63 07 48 8B 4F 08 83 67 04 00 49 C1 E0 03 33 D2 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_44_0 {
	meta:
		name = "??1?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA@XZ"
		size = 28
		refs = "000a ?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ 0018 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B 4B 08 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_735_273_0 {
	meta:
		name = "??1?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 28
		refs = "000a ?Wipe@?$Hash@PEAXPEAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ 0018 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B 4B 08 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_45_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@QEAA@XZ"
		size = 35
		refs = "0011 ?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ 001f ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 99 B8 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B 4B 08 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_46_0 {
	meta:
		name = "??1ExternalContextBase@details@Concurrency@@UEAA@XZ"
		size = 67
		refs = "0019 ??_7ExternalContextBase@details@Concurrency@@6B@ 0021 ?Cleanup@ExternalContextBase@details@Concurrency@@AEAAXXZ 002e ?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ 003f ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 48 8D 8B B8 00 00 00 E8 ?? ?? ?? ?? 48 8B 8B C0 00 00 00 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_52_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UEBA?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 33 C0 39 41 28 76 06 B8 02 00 00 00 C3 39 41 24 0F 97 C0 C3 }
	condition:
		$1
}

rule file_149_58_0 {
	meta:
		name = "??0ExternalContextBase@details@Concurrency@@QEAA@PEAVSchedulerBase@12@_N@Z"
		size = 241
		refs = "0022 ??0ContextBase@details@Concurrency@@QEAA@PEAVSchedulerBase@12@_N@Z 002a ??_7ExternalContextBase@details@Concurrency@@6B@ 004d __imp_CreateEventW 005f __imp_GetLastError 0077 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 007e _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0088 _CxxThrowException 0092 ?GetAnonymousScheduleGroup@SchedulerBase@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ 00a0 ??2@YAPEAX_K@Z 00d3 ?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAAHPEAVExternalStatistics@23@@Z 00de ?PrepareForUse@ExternalContextBase@details@Concurrency@@QEAAX_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 50 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 68 41 8A F8 48 8B D9 41 B0 01 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 A3 D8 00 00 00 00 48 83 A3 E0 00 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 FF 15 ?? ?? ?? ?? 48 89 83 E8 00 00 00 48 85 C0 75 30 FF 15 ?? ?? ?? ?? 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 4B 38 E8 ?? ?? ?? ?? 48 89 43 30 B9 40 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 17 83 60 20 00 83 60 24 00 83 60 28 00 83 60 2C 00 C7 40 30 01 00 00 00 48 89 83 D0 00 00 00 48 8B 4B 38 48 83 C1 60 48 8B D0 E8 ?? ?? ?? ?? 40 8A D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "clock"
		size = 62
		refs = "000b __imp_GetSystemTimeAsFileTime 001f start_tics"
	strings:
		$1 = { 48 83 EC 28 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 8B 44 24 30 44 8B 5C 24 34 49 C1 E3 20 4C 2B 1D ?? ?? ?? ?? 4C 03 D8 48 B8 4B 59 86 38 D6 C5 6D 34 49 F7 E3 48 C1 EA 0B 8B C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__inittime"
		size = 45
		refs = "000b __imp_GetSystemTimeAsFileTime 0024 start_tics"
	strings:
		$1 = { 48 83 EC 28 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 8B 44 24 30 44 8B 5C 24 34 49 C1 E3 20 4C 03 D8 33 C0 4C 89 1D ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "_lseeki64_nolock"
		size = 149
		refs = "0018 _get_osfhandle 0023 _errno 0044 __imp_SetFilePointer 0053 __imp_GetLastError 005e _dosmaperr 006d __pioinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 D9 41 8B F8 48 89 54 24 38 8B CB E8 ?? ?? ?? ?? 48 83 F8 FF 75 11 E8 ?? ?? ?? ?? C7 00 09 00 00 00 48 83 C8 FF EB 57 8B 54 24 38 4C 8D 44 24 3C 44 8B CF 48 8B C8 FF 15 ?? ?? ?? ?? 89 44 24 38 83 F8 FF 75 13 FF 15 ?? ?? ?? ?? 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? EB C9 48 8B CB 48 8B C3 48 8D 15 ?? ?? ?? ?? 48 C1 F8 05 83 E1 1F 48 8B 04 C2 48 6B C9 58 80 64 08 08 FD 48 8B 44 24 38 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "_lseeki64"
		size = 227
		refs = "0024 __doserrno 002c _errno 0041 _nhandle 0054 __pioinfo 0070 __lock_fhandle 0089 _lseeki64_nolock 00ac _unlock_fhandle 00c9 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 89 4C 24 08 56 57 41 54 41 55 41 56 48 83 EC 20 41 8B F0 4C 8B E2 48 63 F9 83 FF FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 92 00 00 00 85 C9 78 76 3B 3D ?? ?? ?? ?? 73 6E 48 8B DF 4C 8B EF 49 C1 FD 05 4C 8D 35 ?? ?? ?? ?? 83 E3 1F 48 6B DB 58 4B 8B 04 EE 0F BE 4C 18 08 83 E1 01 74 48 8B CF E8 ?? ?? ?? ?? 90 4B 8B 04 EE F6 44 18 08 01 74 12 44 8B C6 49 8B D4 8B CF E8 ?? ?? ?? ?? 48 8B D8 EB 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 48 83 CB FF 8B CF E8 ?? ?? ?? ?? 48 8B C3 EB 1C E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 8B 5C 24 58 48 83 C4 20 41 5E 41 5D 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_151_2_0 {
	meta:
		name = "_lseeki64$fin$0"
		size = 25
		refs = "000d _unlock_fhandle"
		altNames = "_filelength$fin$0 _filelengthi64$fin$0 _locking$fin$0 _lseek$fin$0 _read$fin$0 _write$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "?Constructor@_HeapManager@@QEAAXP6APEAX_K@ZP6AXPEAX@Z@Z"
		size = 22
	strings:
		$1 = { 33 C0 48 89 11 4C 89 41 08 48 89 41 20 48 89 41 10 48 89 41 18 C3 }
	condition:
		$1
}

rule file_152_2_0 {
	meta:
		name = "?Destructor@_HeapManager@@QEAAXXZ"
		size = 65
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 79 08 00 48 8B D9 74 2B 48 8B 41 10 48 89 41 18 48 85 C0 74 1E 48 8B 43 18 48 8B 08 48 89 4B 10 48 8B C8 FF 53 08 4C 8B 5B 10 4C 89 5B 18 4D 85 DB 75 E2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_3_0 {
	meta:
		name = "?getNumberOfDimensions@UnDecorator@@CAHXZ"
		size = 110
		refs = "0003 ?gName@UnDecorator@@0PEBDEB"
	strings:
		$1 = { 48 8B 0D ?? ?? ?? ?? 8A 01 84 C0 75 03 33 C0 C3 3C 30 7C 15 3C 39 7F 11 0F BE C0 83 E8 2F 48 FF C1 48 89 0D ?? ?? ?? ?? C3 33 D2 41 B0 40 EB 21 84 C0 74 D9 3C 41 7C 32 3C 50 7F 2E 03 D2 0F BE C0 48 FF C1 8D 54 D0 BF 48 89 0D ?? ?? ?? ?? 8A 01 41 3A C0 75 DA 8A 01 48 FF C1 48 89 0D ?? ?? ?? ?? 41 3A C0 75 03 8B C2 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_152_4_0 {
	meta:
		name = "?getTypeEncoding@UnDecorator@@CAHXZ"
		size = 1277
		refs = "0007 ?gName@UnDecorator@@0PEBDEB 01fd ?getTypeEncoding@UnDecorator@@CAHXZ"
	strings:
		$1 = { 48 83 EC 28 4C 8B 05 ?? ?? ?? ?? 41 B9 00 40 00 00 33 D2 41 80 38 5F 75 0D 49 FF C0 41 8B D1 4C 89 05 ?? ?? ?? ?? 41 8A 00 3C 41 7C 08 3C 5A 0F 8E 9C 00 00 00 3C 24 0F 85 4A 03 00 00 49 FF C0 45 32 D2 4C 89 05 ?? ?? ?? ?? 41 0F BE 08 83 F9 42 0F 8F 07 02 00 00 0F 84 F6 01 00 00 85 C9 0F 84 E1 01 00 00 83 F9 24 0F 85 B0 01 00 00 49 8D 40 01 80 38 50 4C 0F 44 C0 49 FF C0 4C 89 05 ?? ?? ?? ?? 45 38 10 0F 84 88 01 00 00 41 80 38 46 74 30 41 80 38 48 74 2A 41 80 38 4A 0F 84 31 01 00 00 41 80 38 4B 0F 8E 86 00 00 00 41 80 38 4D 7E 10 41 80 38 4F 0F 8E 17 01 00 00 41 80 38 51 75 70 49 FF C0 4C 89 05 ?? ?? ?? ?? E9 40 FF FF FF 45 0F BE 10 49 FF C0 41 B9 00 80 00 00 41 83 EA 41 41 0B D1 4C 89 05 ?? ?? ?? ?? 41 F6 C2 01 74 06 0F BA EA 0D EB 04 0F BA F2 0D 41 83 FA 18 0F 8D F0 03 00 00 41 BB FF EF FF FF 41 85 D1 74 09 41 23 D3 0F BA EA 0B EB 06 81 E2 FF 9F FF FF 41 8B C2 83 E0 18 74 3A 83 F8 08 74 20 83 F8 10 74 0A B8 FF FF 00 00 E9 BC 03 00 00 8B C2 8B CA 25 3F FF FF FF 81 E2 FF E7 FF FF EB 27 8B C2 8B CA 0F BA F2 0B 83 E0 BF 0F BA E8 07 0F BA EA 0C EB 12 8B C2 8B CA 41 23 D3 0F BA F0 07 83 C8 40 0F BA EA 0B 41 23 C9 0F 45 D0 41 83 E2 06 0F 84 72 03 00 00 41 83 FA 02 74 2A 41 83 FA 04 74 15 41 83 FA 06 75 9C 81 E2 FF FC FF FF 0F BA EA 0A E9 51 03 00 00 81 E2 FF F9 FF FF 0F BA EA 08 E9 42 03 00 00 41 85 D1 74 0F 81 E2 FF FA FF FF 0F BA EA 09 E9 2E 03 00 00 81 E2 FF 9F FF FF E9 23 03 00 00 49 FF C0 4C 89 05 ?? ?? ?? ?? 41 80 38 30 7C 27 41 80 38 39 7F 21 41 0F BE 00 83 E8 2F 48 98 4C 03 C0 4C 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BA E8 10 E9 EE 02 00 00 BA FF FF 00 00 E9 64 01 00 00 B8 FE FF 00 00 E9 DA 02 00 00 83 F9 2F 0F 8E 0B FF FF FF 83 F9 35 7E 74 83 F9 41 0F 85 FD FE FF FF 81 E2 FF F4 FF FF 81 CA 00 90 00 00 E9 32 01 00 00 BA FE FF 00 00 49 FF C8 E9 25 01 00 00 81 CA 00 98 00 00 E9 1A 01 00 00 83 E9 43 0F 84 0B 01 00 00 FF C9 0F 84 F5 00 00 00 FF C9 0F 84 DF 00 00 00 83 F9 0D 0F 85 B2 FE FF FF 49 FF C0 41 B2 01 4C 89 05 ?? ?? ?? ?? 41 8A 00 3C 30 0F 8C AE 00 00 00 3C 35 0F 8F A6 00 00 00 41 0F BE 00 41 B9 00 80 00 00 41 BB FF EF FF FF 41 0B D1 83 E8 30 41 85 D1 74 09 41 23 D3 0F BA EA 0B EB 06 81 E2 FF 9F FF FF 45 84 D2 74 0C 0F BA F2 08 81 CA 00 06 00 00 EB 0A 0F BA F2 09 81 CA 00 05 00 00 A8 01 74 06 0F BA EA 0D EB 04 0F BA F2 0D 83 E0 06 74 34 83 F8 02 74 1A 83 F8 04 0F 85 2C FE FF FF 8B C2 8B CA 25 3F FF FF FF 81 E2 FF E7 FF FF EB 27 8B C2 8B CA 0F BA F2 0B 83 E0 BF 0F BA E8 07 0F BA EA 0C EB 12 8B C2 8B CA 41 23 D3 0F BA F0 07 83 C8 40 0F BA EA 0B 41 23 C9 0F 45 D0 EB 32 F6 D8 BA FF FF 00 00 1B C0 03 C2 E9 A2 01 00 00 81 E2 FF F6 FF FF 81 CA 00 92 00 00 EB 14 81 E2 FF F5 FF FF 81 CA 00 91 00 00 EB 06 81 CA 00 7C 00 00 49 FF C0 4C 89 05 ?? ?? ?? ?? E9 6F 01 00 00 41 8A 00 3C 30 0F 8C 42 01 00 00 3C 38 0F 8F 3A 01 00 00 49 FF C0 0F BE C8 0F BA F2 0F 83 E9 30 4C 89 05 ?? ?? ?? ?? 0F 84 E3 00 00 00 FF C9 0F 84 A9 00 00 00 FF C9 74 77 FF C9 74 67 FF C9 74 56 FF C9 74 41 FF C9 74 2C FF C9 74 17 FF C9 0F 85 56 FD FF FF 0F BA F2 0A 81 CA 00 78 00 00 E9 0B 01 00 00 81 E2 FF F3 FF FF 81 CA 00 70 00 00 E9 FA 00 00 00 81 E2 FF EB FF FF 81 CA 00 68 00 00 E9 E9 00 00 00 81 E2 FF E3 FF FF 81 CA 00 60 00 00 E9 D8 00 00 00 0F BA F2 0E 0F BA EA 0D E9 CB 00 00 00 0F BA F2 0D 41 0B D1 E9 BF 00 00 00 41 B9 00 80 00 00 41 85 D1 74 0C 81 E2 FF FA FF FF 0F BA EA 09 EB 06 81 E2 FF 9F FF FF 8B C2 8B CA 25 3F FF FF FF 81 E2 FF E7 FF FF EB 67 41 B9 00 80 00 00 41 85 D1 74 0C 81 E2 FF FA FF FF 0F BA EA 09 EB 06 81 E2 FF 9F FF FF 8B C2 8B CA 0F BA F2 0B 83 E0 BF 0F BA E8 07 0F BA EA 0C EB 35 41 B9 00 80 00 00 41 85 D1 74 0C 81 E2 FF FA FF FF 0F BA EA 09 EB 06 81 E2 FF 9F FF FF 8B C2 8B CA 41 BB FF EF FF FF 0F BA F0 07 41 23 D3 83 C8 40 0F BA EA 0B 41 23 C9 0F 45 D0 EB 22 3C 39 75 11 49 FF C0 BA FD FF 00 00 4C 89 05 ?? ?? ?? ?? EB 0D F6 D8 BA FE FF 00 00 1B C9 F7 D9 03 D1 8B C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_152_11_0 {
	meta:
		name = "?doThisTypes@UnDecorator@@SAHXZ"
		size = 18
		refs = "0002 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 33 C0 83 E1 60 80 F9 60 0F 95 C0 C3 }
	condition:
		$1
}

rule file_152_21_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPEBDW4Tokens@@@Z"
		size = 31
		refs = "0002 ?disableFlags@UnDecorator@@0KA 0010 tokenTable"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? F7 D0 A8 01 48 63 C1 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 75 04 48 83 C0 02 C3 }
	condition:
		$1
}

rule file_152_22_0 {
	meta:
		name = "?getMemory@_HeapManager@@QEAAPEAX_KH@Z"
		size = 180
		refs = "004f heap 005f ?getMemory@_HeapManager@@QEAAPEAX_KH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 7A 07 48 8B D9 48 83 E7 F8 45 85 C0 74 0A 48 8B 03 48 8B CF FF D0 EB 7B B8 08 00 00 00 48 85 FF 48 0F 44 F8 48 8B 41 20 48 3B C7 73 52 BE 00 10 00 00 48 3B FE 76 04 33 C0 EB 58 48 8D 0D ?? ?? ?? ?? BA 08 10 00 00 41 B8 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 83 20 00 48 85 C0 74 D7 48 8B 4B 18 48 85 C9 74 05 48 89 01 EB 04 48 89 43 10 48 2B F7 48 89 43 18 48 89 73 20 EB 07 48 2B C7 48 89 41 20 48 8B 4B 18 48 8B 43 20 48 8D 44 01 08 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_23_0 {
	meta:
		name = "??0DName@@QEAA@XZ"
		size = 19
	strings:
		$1 = { 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_30_0 {
	meta:
		name = "?isUDC@DName@@QEBAHXZ"
		size = 22
	strings:
		$1 = { 33 C0 48 39 01 74 0E F7 41 08 00 02 00 00 74 05 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_152_32_0 {
	meta:
		name = "?isUDTThunk@DName@@QEBAHXZ"
		size = 22
	strings:
		$1 = { 33 C0 48 39 01 74 0E F7 41 08 00 04 00 00 74 05 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_152_43_0 {
	meta:
		name = "?length@DName@@QEBAHXZ"
		size = 17
	strings:
		$1 = { 48 8B 09 48 85 C9 75 03 33 C0 C3 48 8B 01 48 FF 20 }
	condition:
		$1
}

rule file_152_44_0 {
	meta:
		name = "?getLastChar@DName@@QEBADXZ"
		size = 18
	strings:
		$1 = { 48 8B 09 48 85 C9 75 03 32 C0 C3 48 8B 01 48 FF 60 08 }
	condition:
		$1
}

rule file_152_45_0 {
	meta:
		name = "?getString@DName@@QEBAPEADPEAD0@Z"
		size = 19
	strings:
		$1 = { 48 8B 09 48 85 C9 75 04 48 8B C2 C3 48 8B 01 48 FF 60 10 }
	condition:
		$1
}

rule file_152_46_0 {
	meta:
		name = "??_5DName@@QEAAAEAV0@AEBV0@@Z"
		size = 20
	strings:
		$1 = { 80 79 08 03 74 0A 8A 42 08 3C 01 7E 03 88 41 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_51_0 {
	meta:
		name = "??0charNode@@QEAA@D@Z"
		size = 17
		refs = "0003 ??_7charNode@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 88 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_54_0 {
	meta:
		name = "?getString@charNode@@UEBAPEADPEAD0@Z"
		size = 17
	strings:
		$1 = { 49 3B D0 73 08 8A 41 08 88 02 48 FF C2 48 8B C2 C3 }
	condition:
		$1
}

rule file_152_55_0 {
	meta:
		name = "??0pDNameNode@@QEAA@PEAVDName@@@Z"
		size = 40
		refs = "0003 ??_7pDNameNode@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 33 C0 48 85 D2 74 0C 80 7A 08 02 74 09 80 7A 08 03 74 03 48 8B C2 48 89 41 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_56_0 {
	meta:
		name = "?length@pDNameNode@@UEBAHXZ"
		size = 33
	strings:
		$1 = { 48 83 EC 28 48 8B 51 08 33 C0 48 85 D2 74 0D 48 8B 0A 48 85 C9 74 05 48 8B 01 FF 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_152_57_0 {
	meta:
		name = "?getLastChar@pDNameNode@@UEBADXZ"
		size = 34
	strings:
		$1 = { 48 83 EC 28 48 8B 51 08 33 C0 48 85 D2 74 0E 48 8B 0A 48 85 C9 74 06 48 8B 01 FF 50 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_152_58_0 {
	meta:
		name = "?getString@pDNameNode@@UEBAPEADPEAD0@Z"
		size = 38
	strings:
		$1 = { 48 83 EC 28 48 8B 49 08 48 85 C9 74 11 48 8B 09 48 85 C9 74 09 48 8B 01 FF 50 10 48 8B D0 48 8B C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_152_59_0 {
	meta:
		name = "??0DNameStatusNode@@AEAA@W4DNameStatus@@@Z"
		size = 33
		refs = "0003 ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 33 C0 83 FA 01 44 8D 40 04 41 0F 44 C0 89 41 0C 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_62_0 {
	meta:
		name = "?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z"
		size = 136
		refs = "0002 ??_B?1??make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z@51 0011 ?nodes@?1??make@DNameStatusNode@@SAPEAV2@W4DNameStatus@@@Z@4PAV2@A 0022 ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? A8 01 75 5F 83 C8 01 33 D2 C7 05 ?? ?? ?? ?? 01 00 00 00 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 04 00 00 00 48 89 15 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 02 00 00 00 48 C7 05 ?? ?? ?? ?? 03 00 00 00 48 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 83 F9 03 77 12 48 63 C1 48 8D 0D ?? ?? ?? ?? 48 C1 E0 04 48 03 C1 C3 48 8D 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_152_63_0 {
	meta:
		name = "??0pairNode@@QEAA@PEAVDNameNode@@0@Z"
		size = 26
		refs = "0007 ??_7pairNode@@6B@"
	strings:
		$1 = { 83 49 18 FF 48 8D 05 ?? ?? ?? ?? 48 89 51 08 48 89 01 4C 89 41 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_64_0 {
	meta:
		name = "?length@pairNode@@UEBAHXZ"
		size = 71
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 83 79 18 00 48 8B F1 7D 1C 48 8B 49 10 48 8B 5E 08 48 8B 01 FF 10 48 8B 13 48 8B CB 8B F8 FF 12 03 F8 89 7E 18 8B 46 18 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_65_0 {
	meta:
		name = "?getLastChar@pairNode@@UEBADXZ"
		size = 39
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 10 48 8B 01 FF 50 08 84 C0 75 0A 48 8B 4B 08 48 8B 01 FF 50 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_66_0 {
	meta:
		name = "?getString@pairNode@@UEBAPEADPEAD0@Z"
		size = 59
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 49 08 49 8B D8 48 8B 01 FF 50 10 48 3B C3 73 11 48 8B 4F 10 4C 8B C3 48 8B D0 4C 8B 09 41 FF 51 10 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_67_0 {
	meta:
		name = "?und_strlen@@YAIPEBD@Z"
		size = 18
	strings:
		$1 = { 33 C0 38 01 74 0A 48 FF C1 FF C0 80 39 00 75 F6 F3 C3 }
	condition:
		$1
}

rule file_152_68_0 {
	meta:
		name = "?und_memcpy@@YAXPEADPEBDI@Z"
		size = 26
	strings:
		$1 = { 45 85 C0 74 13 48 2B D1 45 8B C0 8A 04 0A 88 01 48 FF C1 49 FF C8 75 F3 F3 C3 }
	condition:
		$1
}

rule file_152_69_0 {
	meta:
		name = "?und_strncmp@@YAIPEBD0I@Z"
		size = 44
	strings:
		$1 = { 45 85 C0 75 03 33 C0 C3 41 83 C9 FF EB 10 8A 01 84 C0 74 0F 3A 02 75 0B 48 FF C1 48 FF C2 45 03 C1 75 EB 0F B6 01 0F B6 0A 2B C1 C3 }
	condition:
		$1
}

rule file_152_70_0 {
	meta:
		name = "??0UnDecorator@@QEAA@PEADPEBDHP6APEADJ@ZK@Z"
		size = 113
		refs = "0011 ?name@UnDecorator@@0PEBDEB 0018 ?gName@UnDecorator@@0PEBDEB 0027 ?maxStringLength@UnDecorator@@0HA 002e ?outputString@UnDecorator@@0PEADEA 0045 ?pZNameList@UnDecorator@@0PEAVReplicator@@EA 0050 ?pArgList@UnDecorator@@0PEAVReplicator@@EA 0056 ?disableFlags@UnDecorator@@0KA 0062 ?fExplicitTemplateParams@UnDecorator@@0_NA 0069 ?m_pGetParameter@UnDecorator@@0P6APEADJ@ZEA"
	strings:
		$1 = { 41 83 CA FF 48 8D 41 58 44 89 11 44 89 10 4C 89 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 45 33 C0 48 85 D2 74 10 44 89 0D ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? EB 0E 4C 89 05 ?? ?? ?? ?? 44 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B 44 24 30 48 89 0D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 8B 44 24 28 44 88 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C1 C3 }
	condition:
		$1
}

rule file_152_71_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
		size = 70
		refs = "002d ??_C@_00CNPNBAHC@?$AA@ 0039 ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z"
		altNames = "?getStorageConvention@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 4C 8B DC 53 48 83 EC 50 48 8B D9 33 C9 B8 00 00 FF FF 49 89 4B D8 21 44 24 38 49 89 4B E8 21 44 24 48 89 4C 24 20 4D 8D 4B D8 4C 8D 05 ?? ?? ?? ?? 49 8D 53 E8 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_152_72_0 {
	meta:
		name = "?getThisType@UnDecorator@@CA?AVDName@@XZ"
		size = 71
		refs = "0026 ??_C@_00CNPNBAHC@?$AA@ 003a ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z"
	strings:
		$1 = { 4C 8B DC 53 48 83 EC 50 49 83 63 D8 00 49 83 63 E8 00 B8 00 00 FF FF 21 44 24 38 21 44 24 48 4D 8D 4B D8 4C 8D 05 ?? ?? ?? ?? 49 8D 53 E8 48 8B D9 C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_152_74_0 {
	meta:
		name = "?getStringHelper@@YAPEADPEAD00H@Z"
		size = 44
	strings:
		$1 = { 2B D1 44 3B CA 44 0F 4F CA 45 85 C9 74 17 48 8B D1 4C 2B C1 45 8B D1 41 8A 04 10 88 02 48 FF C2 49 FF CA 75 F2 49 63 C1 48 03 C1 C3 }
	condition:
		$1
}

rule file_152_75_0 {
	meta:
		name = "??0DName@@QEAA@PEAV0@@Z"
		size = 119
		refs = "001b heap 0024 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0030 ??_7pDNameNode@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 48 8B D9 48 85 D2 74 45 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 48 85 C0 74 1C 48 8D 0D ?? ?? ?? ?? 48 89 08 80 7F 08 02 74 06 80 7F 08 03 75 02 33 FF 48 89 78 08 48 89 03 48 F7 D8 1A C0 F6 D0 24 03 88 43 08 EB 08 48 83 21 00 C6 41 08 00 81 63 08 FF 00 FF FF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_76_0 {
	meta:
		name = "??0DName@@QEAA@W4DNameStatus@@@Z"
		size = 74
		refs = "0031 ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 81 61 08 FF 00 FF FF 48 8B D9 83 FA 02 74 09 83 FA 03 74 04 33 C0 EB 02 8B C2 48 83 21 00 88 41 08 B9 01 00 00 00 3B D1 75 11 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 75 04 C6 43 08 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_77_0 {
	meta:
		name = "?getString@DName@@QEBAPEADPEADH@Z"
		size = 134
		refs = "002d heap 003b ?getMemory@_HeapManager@@QEAAPEAX_KH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 8B 09 41 8B F0 48 8B DA 48 85 C9 74 4B 48 85 D2 75 22 48 8B 01 FF 10 48 8D 0D ?? ?? ?? ?? 45 33 C0 8D 70 01 48 63 D6 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 2C 48 8B 0F 48 85 C9 75 05 48 8B C3 EB 12 4C 8B 09 48 63 C6 48 8B D3 4C 8D 44 18 FF 41 FF 51 10 C6 00 00 EB 08 48 85 D2 74 03 C6 02 00 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_78_0 {
	meta:
		name = "?append@DName@@AEAAXPEAVDNameNode@@@Z"
		size = 99
		refs = "001b heap 0024 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0037 ??_7pairNode@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 48 8B D9 48 85 D2 74 3F 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 20 E8 ?? ?? ?? ?? 48 85 C0 74 19 48 8B 13 83 48 18 FF 48 8D 0D ?? ?? ?? ?? 48 89 50 08 48 89 08 48 89 78 10 48 89 03 48 85 C0 75 0A C6 43 08 03 EB 04 C6 41 08 03 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_79_0 {
	meta:
		name = "??4DName@@QEAAAEAV0@PEAV0@@Z"
		size = 120
		refs = "002a heap 0033 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 003f ??_7pDNameNode@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 48 8B FA 48 8B D9 48 85 D2 74 42 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 48 85 C0 74 1C 48 8D 0D ?? ?? ?? ?? 48 89 08 80 7F 08 02 74 06 80 7F 08 03 75 02 33 FF 48 89 78 08 48 89 03 48 85 C0 75 0A C6 43 08 03 EB 04 C6 41 08 03 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_80_0 {
	meta:
		name = "??4DName@@QEAAAEAV0@W4DNameStatus@@@Z"
		size = 60
		refs = "001d ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 81 61 08 FF 00 FF FF 48 8B D9 88 51 08 B9 01 00 00 00 3B D1 75 13 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 75 0A C6 43 08 03 EB 04 48 83 23 00 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_81_0 {
	meta:
		name = "??YReplicator@@QEAAAEAV0@AEBVDName@@@Z"
		size = 95
		refs = "0021 heap 002a ?getMemory@_HeapManager@@QEAAPEAX_KH@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 83 39 09 48 8B FA 48 8B D9 74 3C 48 83 3A 00 74 36 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 09 0F 10 07 F3 0F 7F 00 EB 03 45 33 DB 4D 85 DB 74 0A FF 03 48 63 03 4C 89 5C C3 08 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_82_0 {
	meta:
		name = "??AReplicator@@QEBA?AVDName@@H@Z"
		size = 65
	strings:
		$1 = { 41 83 F8 09 77 28 83 39 FF 74 16 44 3B 01 7F 11 49 63 C0 48 8B 4C C1 08 0F 10 01 F3 0F 7F 02 EB 1C 81 62 08 FF 00 FF FF C6 42 08 02 EB 0B 81 62 08 FF 00 FF FF C6 42 08 03 48 83 22 00 48 8B C2 C3 }
	condition:
		$1
}

rule file_152_83_0 {
	meta:
		name = "??0pcharNode@@QEAA@PEBDH@Z"
		size = 131
		refs = "0012 ??_7pcharNode@@6B@ 002f heap 003a ?getMemory@_HeapManager@@QEAAPEAX_KH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 41 8B F0 48 8B FA 48 8B D9 48 89 01 45 85 C0 74 40 48 85 D2 74 3B 48 8D 0D ?? ?? ?? ?? 48 63 D6 45 33 C0 E8 ?? ?? ?? ?? 89 73 10 4C 8B D8 48 89 43 08 48 85 C0 74 23 85 F6 74 1F 48 2B F8 8B CE 42 8A 04 1F 41 88 03 49 FF C3 48 FF C9 75 F1 EB 09 48 83 61 08 00 83 61 10 00 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_85_0 {
	meta:
		name = "?getLastChar@pcharNode@@UEBADXZ"
		size = 20
	strings:
		$1 = { 33 C0 39 41 10 74 0C 48 63 51 10 48 8B 41 08 8A 44 10 FF C3 }
	condition:
		$1
}

rule file_152_86_0 {
	meta:
		name = "?getString@pcharNode@@UEBAPEADPEAD0@Z"
		size = 53
	strings:
		$1 = { 44 8B 49 10 4C 8B 51 08 44 2B C2 45 3B C8 45 0F 4F C8 45 85 C9 74 17 48 8B CA 4C 2B D2 45 8B C1 41 8A 04 0A 88 01 48 FF C1 49 FF C8 75 F2 49 63 C1 48 03 C2 C3 }
	condition:
		$1
}

rule file_152_87_0 {
	meta:
		name = "?getString@DNameStatusNode@@UEBAPEADPEAD0@Z"
		size = 68
		refs = "001e ??_C@_04OKOHEJBO@?5?$DP?$DP?5?$AA@"
	strings:
		$1 = { 83 79 08 01 75 3A 44 2B C2 41 B9 04 00 00 00 45 3B C1 45 0F 4C C8 45 85 C9 74 1E 4C 8D 05 ?? ?? ?? ?? 48 8B CA 45 8B D1 4C 2B C2 41 8A 04 08 88 01 48 FF C1 49 FF CA 75 F2 49 63 C1 48 03 C2 C3 48 8B C2 C3 }
	condition:
		$1
}

rule file_152_88_0 {
	meta:
		name = "?getReturnType@UnDecorator@@CA?AVDName@@PEAV2@@Z"
		size = 52
		refs = "0009 ?gName@UnDecorator@@0PEBDEB 0020 ??0DName@@QEAA@PEAV0@@Z 0027 ?getDataType@UnDecorator@@CA?AVDName@@PEAV2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 8B D9 80 38 40 75 11 48 FF C0 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_90_0 {
	meta:
		name = "??YDName@@QEAAAEAV0@W4DNameStatus@@@Z"
		size = 69
		refs = "0026 ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 0031 ?append@DName@@AEAAXPEAVDNameNode@@@Z 0038 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 80 79 08 01 48 8B D9 7F 2D 48 83 39 00 74 22 83 FA 02 74 1D 83 FA 03 74 18 85 D2 74 19 8B CA E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_91_0 {
	meta:
		name = "?doPchar@DName@@AEAAXPEBDH@Z"
		size = 172
		refs = "0044 heap 004f ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0062 ??0pcharNode@@QEAA@PEBDH@Z 007c ??_7charNode@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 83 39 00 41 8B F8 48 8B F2 48 8B D9 74 11 81 61 08 FF 00 FF FF 48 83 21 00 C6 41 08 03 EB 6D 48 85 D2 74 64 45 85 C0 74 5F 41 8B C8 45 33 C0 FF C9 48 8D 0D ?? ?? ?? ?? 74 1E 41 8D 50 18 E8 ?? ?? ?? ?? 48 85 C0 74 30 44 8B C7 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? EB 22 BA 10 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 11 8A 0E 48 8D 15 ?? ?? ?? ?? 88 48 08 48 89 10 EB 02 33 C0 48 89 03 48 85 C0 75 0A C6 43 08 03 EB 04 C6 41 08 02 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_92_0 {
	meta:
		name = "??0DName@@QEAA@D@Z"
		size = 56
		refs = "002b ?doPchar@DName@@AEAAXPEBDH@Z"
		altNames = "??4DName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 88 54 24 10 53 48 83 EC 20 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 48 8B D9 84 D2 74 10 48 8D 54 24 38 41 B8 01 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_93_0 {
	meta:
		name = "??0DName@@QEAA@PEBD@Z"
		size = 71
		refs = "003a ?doPchar@DName@@AEAAXPEBDH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C9 88 4B 08 81 63 08 FF 00 FF FF 48 89 0B 48 85 D2 74 21 48 8B C2 44 8B C1 38 0A 74 17 48 FF C0 41 FF C0 38 08 75 F6 45 85 C0 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_94_0 {
	meta:
		name = "??0DName@@QEAA@AEAPEBDD@Z"
		size = 237
		refs = "007f ?disableFlags@UnDecorator@@0KA 009c ?doPchar@DName@@AEAAXPEBDH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 48 8B FA 48 8B 12 41 8A F0 48 8B D9 48 85 D2 0F 84 A3 00 00 00 80 3A 00 0F 84 94 00 00 00 45 33 C0 48 8B 0F 8A 01 40 3A C6 74 4F 3C 5F 74 3C 3C 24 74 38 3C 3C 74 34 3C 3E 74 30 3C 2D 74 2C 3C 61 7C 04 3C 7A 7E 24 3C 41 7C 04 3C 5A 7E 1C 3C 30 7C 04 3C 39 7E 14 3C 80 72 04 3C FE 76 0C F7 05 ?? ?? ?? ?? 00 00 01 00 74 35 48 8D 41 01 41 FF C0 48 89 07 80 38 00 75 A7 48 8B CB E8 ?? ?? ?? ?? 48 8B 07 8A 08 84 C9 74 1B 48 FF C0 48 89 07 40 3A CE 74 26 48 83 23 00 C6 43 08 03 EB 1C C6 43 08 02 EB 16 80 7B 08 00 75 10 C6 43 08 01 EB 0A C6 41 08 01 EB 04 C6 41 08 02 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_95_0 {
	meta:
		name = "??0DName@@QEAA@_K@Z"
		size = 143
		refs = "0009 __security_cookie 0075 ?doPchar@DName@@AEAAXPEBDH@Z 0085 __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 38 45 33 D2 4C 8B C2 48 8B D9 44 88 51 08 81 61 08 FF 00 FF FF 4C 8D 4C 24 34 4C 89 11 44 88 54 24 34 49 FF C9 48 B8 CD CC CC CC CC CC CC CC 49 F7 E0 48 C1 EA 03 8A C2 C0 E0 02 8D 0C 10 02 C9 44 2A C1 41 80 C0 30 45 88 01 4C 8B C2 48 85 D2 75 D0 4C 8D 44 24 34 49 8B D1 48 8B CB 45 2B C1 E8 ?? ?? ?? ?? 48 8B C3 48 8B 4C 24 38 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_152_96_0 {
	meta:
		name = "??0DName@@QEAA@_J@Z"
		size = 169
		refs = "0009 __security_cookie 008f ?doPchar@DName@@AEAAXPEBDH@Z 009f __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 38 45 33 DB 4C 8B C2 48 8B D9 44 88 59 08 81 61 08 FF 00 FF FF 4C 8D 4C 24 35 4C 89 19 44 88 5C 24 35 45 8A D3 48 85 D2 79 06 41 B2 01 49 F7 D8 49 FF C9 48 B8 CD CC CC CC CC CC CC CC 49 F7 E0 48 C1 EA 03 8A C2 C0 E0 02 8D 0C 10 02 C9 44 2A C1 41 80 C0 30 45 88 01 4C 8B C2 48 85 D2 75 D0 45 84 D2 74 07 49 FF C9 41 C6 01 2D 4C 8D 44 24 35 49 8B D1 48 8B CB 45 2B C1 E8 ?? ?? ?? ?? 48 8B C3 48 8B 4C 24 38 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_152_97_0 {
	meta:
		name = "??HDName@@QEBA?AV0@W4DNameStatus@@@Z"
		size = 36
		refs = "0017 ??YDName@@QEAAAEAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F 10 01 48 8B DA 48 8B CB F3 0F 7F 02 41 8B D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_98_0 {
	meta:
		name = "??YDName@@QEAAAEAV0@AEBV0@@Z"
		size = 64
		refs = "001a ??YDName@@QEAAAEAV0@W4DNameStatus@@@Z 0033 ?append@DName@@AEAAXPEAVDNameNode@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 80 79 08 01 48 8B D9 7F 28 48 83 3A 00 75 0B 0F BE 52 08 E8 ?? ?? ?? ?? EB 17 48 83 39 00 75 09 0F 10 02 F3 0F 7F 01 EB 08 48 8B 12 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_99_0 {
	meta:
		name = "??YDName@@QEAAAEAV0@PEAV0@@Z"
		size = 138
		refs = "0022 ??4DName@@QEAAAEAV0@PEAV0@@Z 0037 ??YDName@@QEAAAEAV0@W4DNameStatus@@@Z 0043 heap 004c ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0058 ??_7pDNameNode@@6B@ 0078 ?append@DName@@AEAAXPEAVDNameNode@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 80 79 08 01 48 8B FA 48 8B D9 7F 66 48 85 D2 74 61 48 83 39 00 75 07 E8 ?? ?? ?? ?? EB 54 8A 42 08 84 C0 74 0E 3C 01 74 0A 0F BE D0 E8 ?? ?? ?? ?? EB 3F 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 48 85 C0 74 1C 48 8D 0D ?? ?? ?? ?? 48 89 08 80 7F 08 02 74 06 80 7F 08 03 75 02 33 FF 48 89 78 08 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_101_0 {
	meta:
		name = "??4DName@@QEAAAEAV0@PEBD@Z"
		size = 61
		refs = "0030 ?doPchar@DName@@AEAAXPEBDH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C9 48 8B C2 88 4B 08 81 63 08 FF 00 FF FF 48 89 0B 44 8B C1 38 0A 74 0A 48 FF C0 41 FF C0 38 08 75 F6 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_102_0 {
	meta:
		name = "?getCallingConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 254
		refs = "0009 ?gName@UnDecorator@@0PEBDEB 003e ?disableFlags@UnDecorator@@0KA 007e tokenTable 00c9 ??4DName@@QEAAAEAV0@PEBD@Z 00f1 ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 8B D9 33 C9 38 08 0F 84 CE 00 00 00 0F BE 10 48 FF C0 83 EA 41 48 89 05 ?? ?? ?? ?? 83 FA 0E 0F 87 A5 00 00 00 8B 44 24 28 48 89 4C 24 20 8B 0D ?? ?? ?? ?? 25 02 00 FF FF 83 C8 02 89 44 24 28 8B C1 D1 E8 F7 D0 A8 01 74 75 83 E2 FE 74 54 83 FA 02 74 46 83 FA 04 74 38 83 FA 06 74 2A 83 FA 08 74 1C 83 FA 0C 74 0E 83 FA 0E 75 52 48 8B 15 ?? ?? ?? ?? EB 34 48 8B 15 ?? ?? ?? ?? EB 2B 48 8B 15 ?? ?? ?? ?? EB 22 48 8B 15 ?? ?? ?? ?? EB 19 48 8B 15 ?? ?? ?? ?? EB 10 48 8B 15 ?? ?? ?? ?? EB 07 48 8B 15 ?? ?? ?? ?? F7 D1 F6 C1 01 75 04 48 83 C2 02 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 44 24 20 F3 0F 7F 03 EB 1D 81 63 08 FF 00 FF FF 48 89 0B C6 43 08 02 EB 0D BA 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_152_103_0 {
	meta:
		name = "?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ"
		size = 86
		refs = "0009 ?gName@UnDecorator@@0PEBDEB 0031 ??_C@_06EEGAIFAK@?$HLflat?$HN?$AA@ 003d ??0DName@@QEAA@PEBD@Z 0049 ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 8B D9 80 38 00 74 2E 80 38 41 74 11 81 61 08 FF 00 FF FF 48 83 21 00 C6 41 08 02 EB 22 48 FF C0 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_104_0 {
	meta:
		name = "??HDName@@QEBA?AV0@AEBV0@@Z"
		size = 36
		refs = "0017 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F 10 01 48 8B DA 48 8B CB F3 0F 7F 02 49 8B D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_105_0 {
	meta:
		name = "??HDName@@QEBA?AV0@PEAV0@@Z"
		size = 36
		refs = "0017 ??YDName@@QEAAAEAV0@PEAV0@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F 10 01 48 8B DA 48 8B CB F3 0F 7F 02 49 8B D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_114_0 {
	meta:
		name = "??HDName@@QEBA?AV0@PEBD@Z"
		size = 36
		refs = "0017 ??YDName@@QEAAAEAV0@PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F 10 01 48 8B DA 48 8B CB F3 0F 7F 02 49 8B D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_106_0 {
	meta:
		name = "??YDName@@QEAAAEAV0@D@Z"
		size = 132
		refs = "003f ?doPchar@DName@@AEAAXPEBDH@Z 004b heap 0054 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0060 ??_7charNode@@6B@ 0072 ?append@DName@@AEAAXPEAVDNameNode@@@Z"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 41 B8 01 00 00 00 40 8A FA 48 8B D9 44 38 41 08 7F 5A 84 D2 74 56 48 83 39 00 75 1F 48 83 21 00 88 54 24 30 C6 41 08 00 81 61 08 FF 00 FF FF 48 8D 54 24 30 E8 ?? ?? ?? ?? EB 31 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8D 0D ?? ?? ?? ?? 40 88 78 08 48 89 08 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_107_0 {
	meta:
		name = "??YDName@@QEAAAEAV0@PEBD@Z"
		size = 138
		refs = "002c ??4DName@@QEAAAEAV0@PEBD@Z 0038 heap 0041 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0065 ??0pcharNode@@QEAA@PEBDH@Z 0073 ?append@DName@@AEAAXPEAVDNameNode@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 80 79 08 01 48 8B F2 48 8B F9 7F 5C 33 DB 48 85 D2 74 55 38 1A 74 51 48 39 19 75 07 E8 ?? ?? ?? ?? EB 45 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 18 E8 ?? ?? ?? ?? 48 85 C0 74 22 48 8B CE 44 8B C3 38 1E 74 0A 48 FF C1 41 FF C0 38 19 75 F6 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_152_108_0 {
	meta:
		name = "?getArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 357
		refs = "0033 ?gName@UnDecorator@@0PEBDEB 0057 ??YDName@@QEAAAEAV0@D@Z 007c ?pArgList@UnDecorator@@0PEAVReplicator@@EA 0090 ??AReplicator@@QEBA?AVDName@@H@Z 009b ??YDName@@QEAAAEAV0@AEBV0@@Z 00bd ?getPrimaryDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 00e3 ??YReplicator@@QEAAAEAV0@AEBVDName@@@Z 0134 ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 013f ?append@DName@@AEAAXPEAVDNameNode@@@Z 014e ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 50 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 80 79 08 00 48 8B D9 BE 01 00 00 00 0F 85 22 01 00 00 48 8B 05 ?? ?? ?? ?? 80 38 40 0F 84 12 01 00 00 80 38 5A 0F 84 09 01 00 00 85 F6 74 04 33 F6 EB 11 B2 2C 48 8B CB E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 00 0F 84 B7 00 00 00 44 0F BE 00 41 83 E8 30 41 83 F8 09 77 28 48 8B 0D ?? ?? ?? ?? 48 FF C0 48 8D 54 24 40 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? EB 6E 48 83 64 24 20 00 81 64 24 28 00 00 FF FF 48 8D 54 24 20 48 8D 4C 24 30 48 8B F8 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 4C 2B DF 49 83 FB 01 7E 16 48 8B 0D ?? ?? ?? ?? 83 39 09 74 0A 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8B CB E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 3B C7 75 16 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 48 8B 05 ?? ?? ?? ?? 80 7B 08 00 0F 84 17 FF FF FF EB 30 80 7B 08 01 7F 2A 48 83 3B 00 74 17 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? EB 0D BA 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B 74 24 68 48 8B C3 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_152_109_0 {
	meta:
		name = "?getVdispMapType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 91
		refs = "000c ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 0018 ??YDName@@QEAAAEAV0@PEBD@Z 0022 ?getScope@UnDecorator@@CA?AVDName@@XZ 002d ??YDName@@QEAAAEAV0@AEBV0@@Z 0037 ??YDName@@QEAAAEAV0@D@Z 003e ?gName@UnDecorator@@0PEBDEB"
	strings:
		$1 = { 40 53 48 83 EC 30 0F 10 02 48 8D 15 ?? ?? ?? ?? 48 8B D9 F3 0F 7F 01 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? B2 7D 48 8B CB E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 80 3B 40 75 0A 49 FF C3 4C 89 1D ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_152_110_0 {
	meta:
		name = "??H@YA?AVDName@@DAEBV0@@Z"
		size = 58
		refs = "0016 ??0DName@@QEAA@D@Z 0028 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8B F9 48 8D 4C 24 20 49 8B D8 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 0F 10 00 F3 0F 7F 07 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B C7 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_152_112_0 {
	meta:
		name = "??H@YA?AVDName@@PEBDAEBV0@@Z"
		size = 58
		refs = "0016 ??0DName@@QEAA@PEBD@Z 0028 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8B F9 48 8D 4C 24 20 49 8B D8 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 0F 10 00 F3 0F 7F 07 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B C7 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_152_111_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@AEBV0@@Z"
		size = 58
		refs = "0016 ??0DName@@QEAA@W4DNameStatus@@@Z 0028 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8B F9 48 8D 4C 24 20 49 8B D8 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 0F 10 00 F3 0F 7F 07 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B C7 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_152_113_0 {
	meta:
		name = "??HDName@@QEBA?AV0@D@Z"
		size = 36
		refs = "0017 ??YDName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F 10 01 48 8B DA 48 8B CB F3 0F 7F 02 41 8A D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_115_0 {
	meta:
		name = "?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		size = 360
		refs = "001a ?gName@UnDecorator@@0PEBDEB 0036 ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 004c ??0DName@@QEAA@W4DNameStatus@@@Z 00de ??0DName@@QEAA@_J@Z 0112 ??0DName@@QEAA@_K@Z 0121 ??0DName@@QEAA@PEBD@Z 0135 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 60 4C 8B 05 ?? ?? ?? ?? 33 F6 44 8A CA 41 80 38 51 48 8B F9 44 8D 56 01 75 11 4D 03 C2 48 8D 35 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 41 8A 00 84 C0 75 0D 41 8B D2 E8 ?? ?? ?? ?? E9 FA 00 00 00 3C 30 7C 2F 3C 39 7F 2B 41 0F BE 00 4D 03 C2 83 E8 2F 4C 89 05 ?? ?? ?? ?? 48 63 D0 48 85 F6 74 09 48 8D 4D D0 E9 92 00 00 00 48 8D 4D F0 E9 BB 00 00 00 33 D2 41 B3 40 EB 29 84 C0 74 62 3C 41 7C 4D 3C 50 7F 49 0F BE C0 48 C1 E2 04 83 E8 41 48 63 C8 48 03 D1 4D 03 C2 4C 89 05 ?? ?? ?? ?? 41 8A 00 41 3A C3 75 D2 41 8A 00 4D 03 C2 4C 89 05 ?? ?? ?? ?? 41 3A C3 75 15 45 84 C9 74 34 48 85 F6 74 24 48 8D 4D F0 E8 ?? ?? ?? ?? EB 32 81 67 08 FF 00 FF FF 48 83 27 00 C6 47 08 02 EB 5A 48 8B CF E9 4B FF FF FF 48 8D 4D D0 E8 ?? ?? ?? ?? EB 40 48 85 F6 74 32 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D6 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D C0 48 8B D3 0F 10 00 F3 0F 7F 45 C0 E8 ?? ?? ?? ?? 48 8D 45 C0 EB 09 48 8D 4D D0 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 07 4C 8D 5C 24 60 48 8B C7 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_116_0 {
	meta:
		name = "?getEnumType@UnDecorator@@CA?AVDName@@XZ"
		size = 256
		refs = "0010 ?gName@UnDecorator@@0PEBDEB 0053 ??_C@_05CJIMAING@long?5?$AA@ 005c ??_C@_04LAHKHJMA@int?5?$AA@ 0065 ??_C@_06EHJMALKF@short?5?$AA@ 006e ??_C@_05CIHEBHNO@char?5?$AA@ 0077 ??4DName@@QEAAAEAV0@PEBD@Z 00a9 ??_C@_09EBBEKKIH@unsigned?5?$AA@ 00b2 ??0DName@@QEAA@PEBD@Z 00c7 ??YDName@@QEAAAEAV0@AEBV0@@Z 00ee ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8B EC 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 81 65 D8 00 00 FF FF 48 8B D9 33 C9 48 89 4D D0 38 08 0F 84 B9 00 00 00 8A 00 3C 30 0F 8C 9F 00 00 00 3C 31 7E 31 3C 33 7E 24 3C 34 74 39 3C 35 74 13 2C 36 3C 01 0F 87 85 00 00 00 48 8D 15 ?? ?? ?? ?? EB 19 48 8D 15 ?? ?? ?? ?? EB 10 48 8D 15 ?? ?? ?? ?? EB 07 48 8D 15 ?? ?? ?? ?? 48 8D 4D D0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F BE 08 48 FF 05 ?? ?? ?? ?? 83 F9 31 74 15 83 F9 33 74 10 83 F9 35 74 0B 83 F9 37 74 06 0F 28 45 D0 EB 29 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D E0 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 45 E0 F3 0F 7F 03 EB 1D 81 63 08 FF 00 FF FF 48 89 0B C6 43 08 02 EB 0D BA 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 60 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_152_117_0 {
	meta:
		name = "?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 263
		refs = "0009 ?gName@UnDecorator@@0PEBDEB 0028 ?getArgumentList@UnDecorator@@CA?AVDName@@XZ 006a ??_C@_0M@ELJOJFFH@?0?$DMellipsis?$DO?$AA@ 0077 ?disableFlags@UnDecorator@@0KA 0090 ??_C@_04EENFHACM@?0?4?4?4?$AA@ 0099 ??YDName@@QEAAAEAV0@PEBD@Z 00c3 ??_C@_0L@EGPHHEKN@?$DMellipsis?$DO?$AA@ 00de ??_C@_03KHICJKCI@?4?4?4?$AA@ 00ee ??_C@_04GKJNKENE@void?$AA@ 00fa ??0DName@@QEAA@PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 8B D9 80 38 58 0F 84 CF 00 00 00 80 38 5A 0F 84 9B 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 45 33 DB 44 38 5C 24 28 75 7C 48 8B 05 ?? ?? ?? ?? 44 38 18 74 70 80 38 40 74 61 80 38 5A 74 13 81 63 08 FF 00 FF FF 4C 89 1B C6 43 08 02 E9 9F 00 00 00 0F 28 44 24 20 48 FF C0 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 48 8D 4C 24 20 66 0F 7F 44 24 20 C1 E8 12 F7 D0 A8 01 48 8D 05 ?? ?? ?? ?? 48 0F 45 D0 E8 ?? ?? ?? ?? 0F 28 6C 24 20 F3 0F 7F 2B EB 56 48 FF C0 48 89 05 ?? ?? ?? ?? 0F 28 44 24 20 F3 0F 7F 03 EB 41 48 FF C0 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? C1 E8 12 F7 D0 A8 01 48 8D 05 ?? ?? ?? ?? 48 0F 45 D0 EB 11 48 FF C0 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_152_118_0 {
	meta:
		name = "?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 242
		refs = "0015 ?gName@UnDecorator@@0PEBDEB 004e ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0055 ??_C@_07HDJPLPEK@?5throw?$CI?$AA@ 0061 ??0DName@@QEAA@PEBD@Z 0075 ??YDName@@QEAAAEAV0@AEBV0@@Z 00ad ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 00b9 ?append@DName@@AEAAXPEAVDNameNode@@@Z 00c9 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 00db ??YDName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 55 48 8B EC 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 33 DB 48 8B F9 38 18 74 61 80 38 5A 75 22 48 FF C0 81 65 D8 00 00 FF FF 48 89 5D D0 0F 10 45 D0 48 89 05 ?? ?? ?? ?? F3 0F 7F 01 E9 96 00 00 00 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D3 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 10 6D D0 F3 0F 7F 2F EB 52 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 D0 80 7D D8 01 7F 2C 48 39 5D D0 74 18 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D0 E8 ?? ?? ?? ?? EB 0E 48 8D 4D D0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 10 45 D0 F3 0F 7F 07 B2 29 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B C7 48 8B 7C 24 68 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_152_119_0 {
	meta:
		name = "?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AEAPEBDAEA_NH@Z"
		size = 613
		refs = "0026 ?gName@UnDecorator@@0PEBDEB 00dd ?doPchar@DName@@AEAAXPEBDH@Z 00e8 ??0DName@@QEAA@_K@Z 00fd ??YDName@@QEAAAEAV0@AEBV0@@Z 0117 ??YDName@@QEAAAEAV0@D@Z 017e ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 018a ?append@DName@@AEAAXPEAVDNameNode@@@Z 0198 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 01b5 ??0DName@@QEAA@W4DNameStatus@@@Z 01c1 ??_C@_01FGNFDNOH@?$CF?$AA@ 021e ??_C@_01JKBOJNNK@?$FO?$AA@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 4C 89 64 24 18 55 48 8B EC 48 83 EC 60 44 8B 55 D8 48 83 65 D0 00 48 8B D9 48 8B 0D ?? ?? ?? ?? 4C 8B DA 41 81 E2 00 00 FF FF 41 BC 01 00 00 00 49 8B F8 44 89 55 D8 49 03 CC 48 89 0D ?? ?? ?? ?? 44 0F BE 01 41 8B D0 83 EA 41 0F 84 AF 01 00 00 FF CA 0F 84 67 01 00 00 FF CA 0F 84 53 01 00 00 80 39 00 0F 84 3A 01 00 00 8A 41 01 84 C0 0F 84 2F 01 00 00 45 85 C9 74 14 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 E9 B4 01 00 00 45 03 C0 48 83 C1 02 0F BE C0 42 8D BC C0 D0 FC FF FF 48 89 0D ?? ?? ?? ?? 41 3B FC 76 51 48 83 65 D0 00 41 81 E2 00 FF FF FF 48 8D 55 C0 41 81 E2 FF 00 FF FF 48 8D 4D D0 45 8B C4 44 89 55 D8 C6 45 C0 2C E8 ?? ?? ?? ?? 48 8D 4D F0 8B D7 E8 ?? ?? ?? ?? 48 8D 4D E0 0F 28 45 D0 48 8B D0 66 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 6D E0 EB 04 0F 28 6D D0 48 8D 4D E0 B2 3E 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6D E0 80 38 24 66 0F 7F 6D D0 75 0C 49 03 C4 48 89 05 ?? ?? ?? ?? EB 20 48 8D 4D E0 B2 5E 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6D E0 66 0F 7F 6D D0 80 38 00 74 0C 49 03 C4 48 89 05 ?? ?? ?? ?? EB 2F 44 38 65 D8 7F 29 48 83 7D D0 00 74 16 41 8B CC E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D0 E8 ?? ?? ?? ?? EB 0C 48 8D 4D D0 41 8B D4 E8 ?? ?? ?? ?? 0F BA 6D D8 0E 0F 28 45 D0 F3 0F 7F 03 E9 9E 00 00 00 41 8B D4 48 8B CB E8 ?? ?? ?? ?? E9 8E 00 00 00 48 8D 15 ?? ?? ?? ?? 49 89 13 EB 37 45 85 C9 0F 85 B1 FE FF FF 48 83 65 D0 00 41 81 E2 00 FF FF FF 48 8D 55 C0 41 81 E2 FF 00 FF FF 48 8D 4D D0 45 8B C4 44 88 27 C6 45 C0 3E 44 89 55 D8 E8 ?? ?? ?? ?? 4C 01 25 ?? ?? ?? ?? EB 33 45 85 C9 75 24 49 8B 03 48 8D 15 ?? ?? ?? ?? 8A 08 48 8D 05 ?? ?? ?? ?? 80 F9 26 48 0F 44 C2 49 89 03 48 8B 0D ?? ?? ?? ?? 49 03 CC 48 89 0D ?? ?? ?? ?? 48 83 23 00 C6 43 08 00 81 63 08 FF 00 FF FF 4C 8D 5C 24 60 48 8B C3 49 8B 5B 10 49 8B 7B 18 4D 8B 63 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_120_0 {
	meta:
		name = "?getArrayType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 738
		refs = "0021 ?gName@UnDecorator@@0PEBDEB 0038 ?getNumberOfDimensions@UnDecorator@@CAHXZ 0051 ??0DName@@QEAA@D@Z 006e ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 007a ?append@DName@@AEAAXPEAVDNameNode@@@Z 008a ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 009e ??YDName@@QEAAAEAV0@D@Z 00c4 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 00cd ??YDName@@QEAAAEAV0@PEBD@Z 00f0 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0112 ??YDName@@QEAAAEAV0@AEBV0@@Z 01b5 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 01fa ??_C@_02GOGNNPBN@?$CJ?$FL?$AA@ 02be ?getBasicDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 4C 89 64 24 18 55 41 55 41 56 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 45 33 F6 4C 8B E2 48 8B F1 44 38 30 0F 84 94 01 00 00 E8 ?? ?? ?? ?? 85 C0 44 8B E8 45 0F 48 EE 45 85 ED 75 61 48 8D 4D D0 B2 5B E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 A0 80 7D A8 01 7F 2B 4C 39 75 A0 74 17 41 8D 4E 01 E8 ?? ?? ?? ?? 48 8D 4D A0 48 8B D0 E8 ?? ?? ?? ?? EB 0E 48 8D 4D A0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 28 45 A0 48 8D 4D B0 B2 5D 66 0F 7F 45 B0 E8 ?? ?? ?? ?? 48 8D 55 B0 E9 0F 02 00 00 81 65 A8 00 00 FF FF 41 F7 44 24 08 00 08 00 00 4C 89 75 A0 74 76 48 8D 15 ?? ?? ?? ?? 48 8D 4D A0 E8 ?? ?? ?? ?? EB 64 41 8B C5 41 FF CD 85 C0 74 60 48 8B 05 ?? ?? ?? ?? 44 38 30 74 54 48 8D 4D E0 33 D2 E8 ?? ?? ?? ?? 48 8D 4D F0 B2 5B 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D C0 48 8B D3 0F 10 00 F3 0F 7F 45 C0 E8 ?? ?? ?? ?? 0F 28 6D C0 48 8D 4D D0 B2 5D 66 0F 7F 6D D0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D A0 E8 ?? ?? ?? ?? 80 7D A8 01 7E 96 4D 39 34 24 74 69 41 F7 44 24 08 00 08 00 00 74 0C 41 0F 10 04 24 F3 0F 7F 45 D0 EB 3C 48 8D 4D F0 B2 28 E8 ?? ?? ?? ?? 48 8D 4D D0 49 8B D4 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 28 6D D0 48 8D 4D D0 B2 29 66 0F 7F 6D D0 E8 ?? ?? ?? ?? 0F 28 6D D0 66 0F 7F 6D D0 48 8D 55 A0 48 8D 4D D0 E8 ?? ?? ?? ?? 0F 28 6D D0 66 0F 7F 6D A0 48 8D 55 A0 48 8D 4D B0 E8 ?? ?? ?? ?? 0F BA 6D B8 0B 0F 10 45 B0 F3 0F 7F 06 E9 F7 00 00 00 48 8D 4D F0 4C 39 32 0F 84 89 00 00 00 B2 28 E8 ?? ?? ?? ?? 48 8D 4D D0 49 8B D4 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 28 6D D0 48 8D 15 ?? ?? ?? ?? 48 8D 4D A0 66 0F 7F 6D A0 E8 ?? ?? ?? ?? 80 7D A8 01 0F 28 6D A0 66 0F 7F 6D B0 7F 2C 4C 39 75 A0 74 18 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D B0 48 8B D0 E8 ?? ?? ?? ?? EB 0E 48 8D 4D B0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 28 45 B0 48 8D 4D C0 B2 5D 66 0F 7F 45 C0 E8 ?? ?? ?? ?? 48 8D 55 C0 EB 59 B2 5B E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 A0 80 7D A8 01 7F 2C 4C 39 75 A0 74 18 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D A0 48 8B D0 E8 ?? ?? ?? ?? EB 0E 48 8D 4D A0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 28 45 A0 48 8D 4D D0 B2 5D 66 0F 7F 45 D0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8B CE E8 ?? ?? ?? ?? 4C 8D 9C 24 80 00 00 00 48 8B C6 49 8B 5B 20 49 8B 73 28 4D 8B 63 30 49 8B E3 41 5E 41 5D 5D C3 }
	condition:
		$1
}

rule file_152_121_0 {
	meta:
		name = "?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ"
		size = 95
		refs = "0015 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0024 ??0DName@@QEAA@D@Z 003a ??YDName@@QEAAAEAV0@AEBV0@@Z 004d ??YDName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B F9 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? 48 8D 4C 24 40 B2 60 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D3 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 6C 24 20 B2 27 48 8B CF F3 0F 7F 2F E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B C7 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_152_122_0 {
	meta:
		name = "?getDisplacement@UnDecorator@@CA?AVDName@@XZ"
		size = 25
		refs = "000c ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 B2 01 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_123_0 {
	meta:
		name = "?getCallIndex@UnDecorator@@CA?AVDName@@XZ"
		size = 25
		refs = "000c ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		altNames = "?getGuardNumber@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 33 D2 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_125_0 {
	meta:
		name = "?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 497
		refs = "0029 ?gName@UnDecorator@@0PEBDEB 0051 ??_C@_00CNPNBAHC@?$AA@ 0064 ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 0078 ??YDName@@QEAAAEAV0@D@Z 008d ??YDName@@QEAAAEAV0@AEBV0@@Z 00b6 ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 00be ??YDName@@QEAAAEAV0@PEBD@Z 00e2 ?getScope@UnDecorator@@CA?AVDName@@XZ 00f0 ??0DName@@QEAA@D@Z 014c ??_C@_02MDINNEEG@s?5?$AA@ 016c ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 0177 ?append@DName@@AEAAXPEAVDNameNode@@@Z 0186 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 01bc ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 55 48 8B EC 48 83 EC 70 0F 10 02 48 8B F9 F3 0F 7F 01 80 79 08 01 0F 8F B6 01 00 00 48 8B 05 ?? ?? ?? ?? 80 38 00 0F 84 76 01 00 00 48 83 65 C0 00 48 83 65 D0 00 83 64 24 20 00 B8 00 00 FF FF 4C 8D 4D C0 4C 8D 05 ?? ?? ?? ?? 21 45 C8 21 45 D8 48 8D 55 D0 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 4D E0 B2 20 0F 28 6D F0 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D7 0F 28 6D E0 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 0F 28 6D E0 F3 0F 7F 2F 80 7F 08 01 0F 8F 39 01 00 00 48 8B 05 ?? ?? ?? ?? 80 38 40 0F 84 ED 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 7F 08 01 0F 8F C8 00 00 00 80 38 00 74 7D 80 38 40 74 78 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 4D C0 B2 60 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D3 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 6D E0 48 8D 4D D0 B2 27 66 0F 7F 6D D0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 40 75 0A 48 FF C0 48 89 05 ?? ?? ?? ?? 80 7F 08 01 7F 57 80 38 40 74 80 48 8D 15 ?? ?? ?? ?? E9 65 FF FF FF 80 7F 08 01 7F 40 80 38 00 75 2A 48 83 3F 00 74 17 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B CF 48 8B D0 E8 ?? ?? ?? ?? EB 0D BA 01 00 00 00 48 8B CF E8 ?? ?? ?? ?? B2 7D 48 8B CF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 40 75 3C 48 FF C0 48 89 05 ?? ?? ?? ?? EB 30 80 79 08 01 7F 2A 48 8D 4D F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D7 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 10 6D E0 F3 0F 7F 2F 4C 8D 5C 24 70 48 8B C7 49 8B 5B 10 49 8B 7B 18 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_126_0 {
	meta:
		name = "?getStringEncoding@UnDecorator@@CA?AVDName@@PEADH@Z"
		size = 209
		refs = "000f ??0DName@@QEAA@PEBD@Z 0016 ?gName@UnDecorator@@0PEBDEB 0052 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 00b3 ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 8A 03 49 FF C3 4C 89 1D ?? ?? ?? ?? 3C 40 0F 85 8A 00 00 00 41 8A 03 49 FF C3 4C 89 1D ?? ?? ?? ?? 3C 5F 75 79 49 FF C3 48 8D 4C 24 30 33 D2 4C 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 8A 03 84 C0 74 30 3C 40 74 11 49 FF C3 4C 89 1D ?? ?? ?? ?? 41 8A 03 84 C0 75 EB 41 80 3B 00 74 15 0F 10 44 24 20 49 FF C3 4C 89 1D ?? ?? ?? ?? F3 0F 7F 03 EB 28 49 FF CB BA 01 00 00 00 48 8B CB 4C 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0F 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 48 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_152_127_0 {
	meta:
		name = "?getSignedDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 124
		refs = "0010 ?gName@UnDecorator@@0PEBDEB 0023 ??0DName@@QEAA@W4DNameStatus@@@Z 003f ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 004e ??0DName@@QEAA@D@Z 0060 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B 0D ?? ?? ?? ?? 8A 01 84 C0 75 0F BA 01 00 00 00 48 8B CF E8 ?? ?? ?? ?? EB 45 33 D2 3C 3F 75 37 48 FF C1 48 89 0D ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 30 B2 2D 48 8B D8 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 0F 10 00 F3 0F 7F 07 E8 ?? ?? ?? ?? EB 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_152_128_0 {
	meta:
		name = "?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ"
		size = 869
		refs = "001e __security_cookie 002f ?gName@UnDecorator@@0PEBDEB 0077 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 00a7 ?getString@DName@@QEBAPEADPEADH@Z 00e8 ??0DName@@QEAA@PEBD@Z 00fd ??YDName@@QEAAAEAV0@D@Z 0112 ??YDName@@QEAAAEAV0@AEBV0@@Z 0126 ??_C@_04HIBGFPH@NULL?$AA@ 0143 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 014a ??_C@_01HNPIGOCE@?$CG?$AA@ 0187 ??0DName@@QEAA@W4DNameStatus@@@Z 01c0 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 01e7 ?disableFlags@UnDecorator@@0KA 020a atol 0212 ?m_pGetParameter@UnDecorator@@0P6APEADJ@ZEA 0231 ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 0257 ??_C@_01GEODFPGF@?8?$AA@ 0263 ??YDName@@QEAAAEAV0@PEBD@Z 026f ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 027d ??0DName@@QEAA@D@Z 0348 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 55 48 8D 68 B8 48 81 EC 40 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 30 48 8B F9 48 8B 0D ?? ?? ?? ?? 0F BE 31 48 FF C1 48 89 0D ?? ?? ?? ?? 8B DE 83 FE 44 0F 8F 45 01 00 00 83 FB 44 0F 84 87 01 00 00 85 DB 0F 84 18 01 00 00 83 EB 30 0F 84 02 01 00 00 FF CB 0F 84 AE 00 00 00 FF CB 75 3F 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? 80 7C 24 28 01 0F 8F EF 00 00 00 80 7D B8 01 0F 8F E5 00 00 00 44 8D 43 64 48 8D 55 C1 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 85 C0 75 14 81 67 08 FF 00 FF FF 48 83 27 00 C6 47 08 02 E9 79 02 00 00 8A 45 C1 88 45 C0 3C 2D 75 0C 8A 45 C2 C6 45 C2 2E 88 45 C1 EB 04 C6 45 C1 2E 48 8D 55 C0 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 4C 24 20 B2 65 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 6C 24 20 48 8D 55 B0 F3 0F 7F 2F 48 8B CF E8 ?? ?? ?? ?? E9 22 02 00 00 80 39 40 75 1E 48 FF C1 48 8D 15 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? E9 FF 01 00 00 48 8D 4D 90 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 70 48 8B D8 E8 ?? ?? ?? ?? 48 8B D3 0F 10 00 F3 0F 7F 07 EB A7 48 8B CF E8 ?? ?? ?? ?? E9 C9 01 00 00 48 FF C9 48 89 0D ?? ?? ?? ?? BA 01 00 00 00 48 8B CF E8 ?? ?? ?? ?? E9 AD 01 00 00 83 FB 45 0F 84 9C 01 00 00 0F 8E 11 FF FF FF 83 FB 4A 0F 8E CD 00 00 00 83 FB 51 74 2E 83 FB 52 0F 85 FA FE FF FF 48 8D 4D B0 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 6D B0 F3 0F 7F 2F E9 62 01 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 74 32 48 8D 55 B0 48 8D 4C 24 20 41 B8 10 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 74 08 48 8B D0 E9 0E FF FF FF 48 8D 4C 24 30 40 80 FE 44 75 3E 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24 20 48 8D 4D B0 0F 10 00 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 6D B0 48 8D 15 ?? ?? ?? ?? 48 8B CF F3 0F 7F 2F E8 ?? ?? ?? ?? E9 D1 00 00 00 48 8D 15 ?? ?? ?? ?? EB C0 48 8D 4C 24 20 B2 7B E8 ?? ?? ?? ?? 40 80 FE 48 7C 29 40 80 FE 4A 7F 23 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 8D 4C 24 20 B2 2C E8 ?? ?? ?? ?? 83 EB 46 74 33 FF CB 74 0C FF CB 74 4D FF CB 74 27 FF CB 75 5B 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 8D 4C 24 20 B2 2C E8 ?? ?? ?? ?? 48 8D 4D 80 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 8D 4C 24 20 B2 2C E8 ?? ?? ?? ?? 48 8D 4D A0 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 0F 10 44 24 20 B2 7D 48 8B CF F3 0F 7F 07 E8 ?? ?? ?? ?? EB 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 4D 30 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 40 01 00 00 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_129_0 {
	meta:
		name = "?getPtrRefDataType@UnDecorator@@CA?AVDName@@AEBV2@H@Z"
		size = 263
		refs = "0015 ?gName@UnDecorator@@0PEBDEB 0045 ??_C@_04GKJNKENE@void?$AA@ 004a ??0DName@@QEAA@PEBD@Z 0056 ??_C@_05BEFAKPML@void?5?$AA@ 0075 ?getArrayType@UnDecorator@@CA?AVDName@@AEBV2@@Z 0080 ?getBasicDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 0090 ??_C@_0M@EALIELKG@cli?3?3array?$DM?$AA@ 00ae ??YDName@@QEAAAEAV0@AEBV0@@Z 00c4 ??_C@_0O@GKABPPIF@cli?3?3pin_ptr?$DM?$AA@ 00de ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 55 48 8B EC 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 8B FA 48 8B D9 80 38 00 0F 84 AC 00 00 00 45 85 C0 74 38 80 38 58 75 33 48 FF C0 48 89 05 ?? ?? ?? ?? 48 83 3A 00 75 11 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 A1 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? EB 7D 80 38 59 75 11 48 FF C0 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 79 48 8D 4D D0 E8 ?? ?? ?? ?? F7 47 08 00 40 00 00 74 2B 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D E0 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 6D E0 EB 16 F7 47 08 00 20 00 00 74 09 48 8D 15 ?? ?? ?? ?? EB CA 0F 28 6D D0 F3 0F 7F 2B EB 20 48 8D 4D F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 10 00 48 8B D7 48 8B CB F3 0F 7F 03 E8 ?? ?? ?? ?? 48 8B 7C 24 68 48 8B C3 48 8B 5C 24 60 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_152_130_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 23
		refs = "000a ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "??0_Exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 23
		refs = "000a ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "??0_Exception_ptr@std@@QEAA@XZ"
		size = 23
		refs = "000a ?__ExceptionPtrCreate@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_42_192_1 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_528_1 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_526_1 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_46_186_1 {
	meta:
		name = "??Y?$_String_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_422_1 {
	meta:
		name = "??Y?$_String_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_65_419_1 {
	meta:
		name = "??Y?$_String_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_136_0 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 23
		refs = "000a ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_149_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
		size = 23
		refs = "000a ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_131_0 {
	meta:
		name = "?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 625
		refs = "001e __security_cookie 0043 ?fGetTemplateArgumentList@UnDecorator@@0_NA 0054 ?gName@UnDecorator@@0PEBDEB 0078 ??YDName@@QEAAAEAV0@D@Z 0093 ?pTemplateArgList@UnDecorator@@0PEAVReplicator@@EA 00a6 ??AReplicator@@QEBA?AVDName@@H@Z 00ce ??_C@_04GKJNKENE@void?$AA@ 00df ??4DName@@QEAAAEAV0@PEBD@Z 0100 ?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ 0117 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 011d ?disableFlags@UnDecorator@@0KA 0136 ?getString@DName@@QEBAPEADPEADH@Z 013f atol 0147 ?m_pGetParameter@UnDecorator@@0P6APEADJ@ZEA 0158 ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 0161 ??0DName@@QEAA@PEBD@Z 0176 ??YDName@@QEAAAEAV0@AEBV0@@Z 0181 ??_C@_01GEODFPGF@?8?$AA@ 018f ??YDName@@QEAAAEAV0@PEBD@Z 01f8 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 0227 ??YReplicator@@QEAAAEAV0@AEBVDName@@@Z 0254 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 55 48 8D 68 A1 48 81 EC 00 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 47 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF BE 01 00 00 00 48 8B D9 40 88 35 ?? ?? ?? ?? 80 79 08 00 0F 85 F1 01 00 00 48 8B 05 ?? ?? ?? ?? 80 38 00 0F 84 E1 01 00 00 80 38 40 0F 84 D8 01 00 00 85 F6 74 04 33 F6 EB 11 B2 2C 48 8B CB E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F BE 08 44 8D 41 D0 41 83 F8 09 77 22 48 8B 0D ?? ?? ?? ?? 48 FF C0 48 8D 55 E7 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 E9 7E 01 00 00 48 83 64 24 20 00 81 64 24 28 00 00 FF FF 48 8B F8 80 F9 58 75 20 48 FF C0 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? E9 1D 01 00 00 80 F9 24 75 1C 48 FF C0 38 08 74 15 48 8D 4D 07 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 F3 00 00 00 80 F9 3F 0F 85 D1 00 00 00 48 8D 4D 87 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 74 72 48 8D 55 37 48 8D 4D 87 41 B8 10 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D 37 E8 ?? ?? ?? ?? 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 74 05 48 8B D0 EB 84 48 8D 15 ?? ?? ?? ?? 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8D 55 87 48 8D 4D D7 0F 10 00 F3 0F 7F 45 D7 E8 ?? ?? ?? ?? 0F 28 6D D7 48 8D 15 ?? ?? ?? ?? 48 8D 4D C7 66 0F 7F 6D C7 E8 ?? ?? ?? ?? 0F 28 6D C7 EB 42 48 8D 15 ?? ?? ?? ?? 48 8D 4D 27 E8 ?? ?? ?? ?? 48 8D 55 87 48 8D 4D B7 0F 10 00 F3 0F 7F 45 B7 E8 ?? ?? ?? ?? 0F 28 6D B7 48 8D 15 ?? ?? ?? ?? 48 8D 4D A7 66 0F 7F 6D A7 E8 ?? ?? ?? ?? 0F 28 6D A7 66 0F 7F 6C 24 20 EB 22 48 83 65 97 00 81 65 9F 00 00 FF FF 48 8D 55 97 48 8D 4D 17 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 44 24 20 48 8B 05 ?? ?? ?? ?? 48 2B C7 48 83 F8 01 7E 16 48 8B 0D ?? ?? ?? ?? 83 39 09 74 0A 48 8D 54 24 20 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 8B CB E8 ?? ?? ?? ?? 80 7B 08 00 0F 84 0F FE FF FF C6 05 ?? ?? ?? ?? 00 48 8B C3 48 8B 4D 47 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 00 01 00 00 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_132_0 {
	meta:
		name = "?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z"
		size = 1849
		refs = "0022 ?gName@UnDecorator@@0PEBDEB 0085 __ImageBase 008d nameTable 0096 ??4DName@@QEAAAEAV0@PEBD@Z 00a8 ??_C@_08LHJFAFGD@operator?$AA@ 00b1 ??0DName@@QEAA@PEBD@Z 00c6 ??YDName@@QEAAAEAV0@AEBV0@@Z 00e7 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00f5 ??0DName@@QEAA@D@Z 0134 ??YDName@@QEAAAEAV0@D@Z 0179 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 0209 ??0DName@@QEAA@W4DNameStatus@@@Z 0301 ??_C@_08OBABFOLI@?$GAstring?8?$AA@ 030a ?getStringEncoding@UnDecorator@@CA?AVDName@@PEADH@Z 0344 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 03b7 ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 03c2 ?append@DName@@AEAAXPEAVDNameNode@@@Z 03d1 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 03fa rttiTable 0473 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 04f0 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0532 ?getDataType@UnDecorator@@CA?AVDName@@PEAV2@@Z 05ab ?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z 066e ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 069b ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 06ae ??_C@_02OHHJMEON@?8?8?$AA@ 06b7 ??YDName@@QEAAAEAV0@PEBD@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 20 4C 89 40 18 55 48 8D 68 A1 48 81 EC F0 00 00 00 48 8B 1D ?? ?? ?? ?? 45 33 C0 48 8B F9 0F BE 03 B9 00 00 FF FF 48 FF C3 21 4D 9F 21 4D 8F 4C 89 45 97 4C 89 45 87 41 8B F0 48 89 1D ?? ?? ?? ?? 83 F8 41 0F 8F B7 01 00 00 0F 84 A1 06 00 00 85 C0 0F 84 90 01 00 00 83 F8 2F 0F 8E BF 02 00 00 83 F8 31 7E 5F 83 F8 39 0F 8F B1 02 00 00 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 83 7D 97 00 0F 84 2D 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D C7 E8 ?? ?? ?? ?? 48 8D 55 97 48 8D 4D A7 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 0F 28 45 A7 E9 03 01 00 00 21 4D 8F 4C 89 45 87 84 D2 0F 84 8D 00 00 00 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8D 4D B7 B2 3C 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D A7 48 8B D3 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 87 E8 ?? ?? ?? ?? 48 8B 4D 87 48 85 C9 74 15 48 8B 01 FF 50 08 3C 3E 75 0B 48 8D 4D 87 B2 20 E8 ?? ?? ?? ?? 48 8D 4D 87 B2 3E E8 ?? ?? ?? ?? 48 8B 45 77 48 85 C0 74 03 C6 00 01 48 8B 1D ?? ?? ?? ?? 40 38 33 75 06 0F 10 45 87 EB 75 48 8B 75 87 48 FF C3 48 89 1D ?? ?? ?? ?? 48 8D 4D 47 45 33 C0 33 D2 E8 ?? ?? ?? ?? 0F 10 00 48 89 1D ?? ?? ?? ?? 0F 29 45 97 48 83 7D 97 00 74 2E 80 7B FF 31 75 28 48 8D 4D B7 B2 7E E8 ?? ?? ?? ?? 48 8D 55 97 48 8D 4D A7 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 0F 28 45 A7 0F 29 45 97 48 85 F6 74 11 48 8D 55 87 48 8D 4D 97 E8 ?? ?? ?? ?? 0F 28 45 97 F3 0F 7F 07 4C 8D 9C 24 F0 00 00 00 48 8B C7 49 8B 5B 10 49 8B 73 18 49 8B 7B 28 49 8B E3 5D C3 48 FF CB BA 01 00 00 00 48 89 1D ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? EB CB 83 F8 42 0F 84 E2 04 00 00 0F 8E 10 01 00 00 83 F8 5A 0F 8E D8 04 00 00 83 F8 5F 0F 85 FE 00 00 00 0F BE 0B 8D 70 A2 48 03 DE 48 89 1D ?? ?? ?? ?? 83 F9 4F 0F 8F 01 01 00 00 83 F9 44 0F 8D 76 04 00 00 83 F9 39 0F 8F 88 00 00 00 74 5F 85 C9 74 51 83 F9 2F 0F 8E C4 00 00 00 83 F9 36 7E 2A 83 F9 38 0F 8F B6 00 00 00 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? E9 41 FF FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? E9 DF FD FF FF 48 2B DE 8B D6 E9 42 FF FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8D 4D 87 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BA 6D 8F 0F E9 78 FE FF FF 83 F9 3F 74 30 83 F9 40 7E 41 83 F9 42 0F 8E D2 03 00 00 83 F9 43 75 33 44 8B C6 48 8D 15 ?? ?? ?? ?? 48 8D 4D 87 E8 ?? ?? ?? ?? 0F BA 6D 8F 0C E9 43 FE FF FF 0F BE 03 48 03 DE 48 89 1D ?? ?? ?? ?? 85 C0 74 89 83 F8 30 74 13 81 67 08 FF 00 FF FF 4C 89 07 C6 47 08 02 E9 99 FE FF FF 48 8D 15 ?? ?? ?? ?? EB BB 83 F9 54 0F 8F 7E 02 00 00 83 F9 53 0F 8D 6C 03 00 00 83 E9 50 0F 84 1F 02 00 00 FF C9 0F 84 65 FE FF FF FF C9 75 BD 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8D 4D 97 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 8A 03 84 C0 75 3E 0F 28 45 97 F3 0F 7F 07 40 38 77 08 0F 8F 2C FE FF FF 48 83 3F 00 74 17 8B CE E8 ?? ?? ?? ?? 48 8B CF 48 8B D0 E8 ?? ?? ?? ?? E9 0F FE FF FF 8B D6 48 8B CF E8 ?? ?? ?? ?? E9 00 FE FF FF 0F BE C0 83 E8 30 0F 88 8A 01 00 00 83 F8 05 0F 83 81 01 00 00 48 63 D0 48 8D 4D 87 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 0F BE 03 4C 03 DE 4C 89 1D ?? ?? ?? ?? 83 F8 30 0F 84 0A 01 00 00 83 F8 31 74 32 83 C0 CE 48 8B CF 83 F8 02 77 16 0F 28 45 97 F3 0F 7F 07 48 8D 55 87 E8 ?? ?? ?? ?? E9 93 FD FF FF 4C 2B DE 8B D6 4C 89 1D ?? ?? ?? ?? E9 B0 FD FF FF 0F 28 45 97 48 8D 55 87 48 8D 4D 97 66 0F 7F 45 97 E8 ?? ?? ?? ?? 48 8D 4D D7 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 2C 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 4D 37 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 2C 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 4D 17 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 2C 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 4D E7 33 D2 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 29 0F 10 00 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 97 E8 ?? ?? ?? ?? B2 27 48 8B CF 0F 28 6D 97 F3 0F 7F 2F E8 ?? ?? ?? ?? E9 AF FC FF FF 48 8D 4D B7 33 D2 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 20 0F 28 6D B7 66 0F 7F 6D A7 E8 ?? ?? ?? ?? 48 8D 55 97 48 8D 4D A7 0F 28 6D A7 66 0F 7F 6D A7 E8 ?? ?? ?? ?? 0F 28 6D A7 F3 0F 7F 2F 48 8B CF E9 C9 FE FF FF 81 67 08 FF 00 FF FF 48 83 27 00 C6 47 08 02 E9 56 FC FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8D 4D 97 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 4D 07 45 33 C0 33 D2 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 87 48 83 7D 87 00 74 09 F7 45 8F 00 04 00 00 75 A9 0F 28 45 97 F3 0F 7F 07 EB 97 83 F9 55 0F 8C 54 FD FF FF 83 F9 56 0F 8E FE 00 00 00 83 F9 57 0F 8E 42 FD FF FF 83 F9 59 0F 8E D3 00 00 00 83 F9 5F 0F 85 30 FD FF FF 0F BE 03 48 03 DE 48 89 1D ?? ?? ?? ?? 83 F8 41 0F 8C 1A FD FF FF 83 F8 44 7E 0E 83 F8 46 7E 22 83 F8 4A 0F 8F 07 FD FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? E9 4C FC FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8D 4D 87 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 3F 75 2D 48 8D 4D 27 E8 ?? ?? ?? ?? 48 8D 4D 87 48 8B D0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 40 75 21 48 03 C6 48 89 05 ?? ?? ?? ?? EB 15 48 8D 4D C7 E8 ?? ?? ?? ?? 48 8D 4D 87 48 8B D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 87 E8 ?? ?? ?? ?? 0F 10 6D 87 F3 0F 7F 2F E9 12 FB FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? E9 AB FB FF FF 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8B 94 D3 ?? ?? ?? ?? E9 97 F9 FF FF BE 01 00 00 00 48 0F BE 53 FF 48 8D 1D ?? ?? ?? ?? 48 8D 4D 97 48 8B 94 D3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 76 F9 FF FF 48 83 7D 97 00 0F 84 A3 FA FF FF 0F BA 6D 9F 09 E9 99 FA FF FF }
	condition:
		$1
}

rule file_152_133_0 {
	meta:
		name = "?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 466
		refs = "0027 ?gName@UnDecorator@@0PEBDEB 0047 ?pArgList@UnDecorator@@0PEAVReplicator@@EA 004e ?pZNameList@UnDecorator@@0PEAVReplicator@@EA 0055 ?pTemplateArgList@UnDecorator@@0PEAVReplicator@@EA 00bf ?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z 00cf ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 00d9 ?fExplicitTemplateParams@UnDecorator@@0_NA 0100 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 010f ??0DName@@QEAA@D@Z 0125 ??YDName@@QEAAAEAV0@AEBV0@@Z 0154 ??YDName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8D 6C 24 80 48 81 EC 80 01 00 00 48 8B 05 ?? ?? ?? ?? 44 8A E2 48 8B F9 80 38 3F 0F 85 65 01 00 00 80 78 01 24 0F 85 5B 01 00 00 4C 8B 2D ?? ?? ?? ?? 4C 8B 35 ?? ?? ?? ?? 4C 8B 3D ?? ?? ?? ?? 83 C9 FF 48 83 C0 02 32 DB 89 4C 24 60 89 4D C0 89 4D 20 48 8D 4C 24 60 BE 01 00 00 00 48 89 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 8D 4D C0 88 9D C0 00 00 00 48 89 0D ?? ?? ?? ?? 48 8D 4D 20 40 8A D6 48 89 0D ?? ?? ?? ?? 80 38 3F 48 8D 4C 24 30 75 1E 48 03 C6 4C 8D 85 C0 00 00 00 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8A 9D C0 00 00 00 EB 08 44 8A C6 E8 ?? ?? ?? ?? 0F 10 00 0F B6 05 ?? ?? ?? ?? F3 0F 7F 44 24 20 48 83 7C 24 20 00 0F 44 C6 88 05 ?? ?? ?? ?? 84 DB 0F 85 85 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 4C 24 40 B2 3C 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D3 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 85 C9 74 16 48 8B 01 FF 50 08 3C 3E 75 0C 48 8D 4C 24 20 B2 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 B2 3E E8 ?? ?? ?? ?? 45 84 E4 74 16 48 8B 05 ?? ?? ?? ?? 80 38 00 74 0A 48 03 C6 48 89 05 ?? ?? ?? ?? 0F 10 44 24 20 4C 89 2D ?? ?? ?? ?? 4C 89 35 ?? ?? ?? ?? 4C 89 3D ?? ?? ?? ?? F3 0F 7F 07 EB 0F 81 61 08 FF 00 FF FF 48 83 21 00 C6 41 08 02 4C 8D 9C 24 80 01 00 00 48 8B C7 49 8B 5B 30 49 8B 73 38 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_152_134_0 {
	meta:
		name = "?getZName@UnDecorator@@CA?AVDName@@_N0@Z"
		size = 632
		refs = "001d __security_cookie 002b ?gName@UnDecorator@@0PEBDEB 004c ?pZNameList@UnDecorator@@0PEAVReplicator@@EA 005b ??AReplicator@@QEBA?AVDName@@H@Z 0080 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 00c0 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 00cc ??_C@_0BE@JAEOCHPE@template?9parameter?9?$AA@ 0104 ??_C@_0O@KHGCOMHP@generic?9type?9?$AA@ 0147 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 014d ?disableFlags@UnDecorator@@0KA 0166 ?getString@DName@@QEBAPEADPEADH@Z 016f atol 0177 ?m_pGetParameter@UnDecorator@@0P6APEADJ@ZEA 0188 ??4DName@@QEAAAEAV0@PEBD@Z 0198 ??_C@_01NLNLIGKH@?$GA?$AA@ 01a9 ??0DName@@QEAA@PEBD@Z 01be ??YDName@@QEAAAEAV0@AEBV0@@Z 01c9 ??_C@_01GEODFPGF@?8?$AA@ 01d7 ??YDName@@QEAAAEAV0@PEBD@Z 0222 ??0DName@@QEAA@AEAPEBDD@Z 0244 ??YReplicator@@QEAAAEAV0@AEBVDName@@@Z 025b __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 4C 8B 0D ?? ?? ?? ?? 45 8A D0 40 8A F2 45 0F BE 01 48 8B D9 41 83 E8 30 41 83 F8 09 77 1E 48 8B D1 48 8B 0D ?? ?? ?? ?? 49 FF C1 4C 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 EC 01 00 00 48 83 65 A0 00 41 BB 00 00 FF FF 44 21 5D A8 41 80 39 3F 75 50 48 8D 4D E8 33 D2 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 0F 10 00 8A 01 48 FF C1 48 89 0D ?? ?? ?? ?? F3 0F 7F 45 A0 3C 40 0F 84 87 01 00 00 48 FF C9 48 89 0D ?? ?? ?? ?? 8A 01 48 8D 4D A0 F6 D8 1B D2 F7 DA FF C2 E8 ?? ?? ?? ?? E9 65 01 00 00 48 8D 3D ?? ?? ?? ?? 49 8B C9 41 B8 12 00 00 00 48 8B C7 8A 11 84 D2 74 0F 3A 10 75 0B 48 FF C1 48 FF C0 41 FF C8 75 EB 0F B6 09 0F B6 00 2B C8 75 06 49 83 C1 13 EB 3A 48 8D 3D ?? ?? ?? ?? 49 8B C9 41 B8 0C 00 00 00 48 8B C7 8A 11 84 D2 74 0F 3A 10 75 0B 48 FF C1 48 FF C0 41 FF C8 75 EB 0F B6 09 0F B6 00 2B C8 0F 85 B3 00 00 00 49 83 C1 0D 48 8D 4D C0 4C 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 74 3A 48 8D 55 E8 48 8D 4D C0 41 B8 10 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 FF 15 ?? ?? ?? ?? 48 8D 4D A0 48 85 C0 74 11 48 8B D0 E8 ?? ?? ?? ?? E9 9D 00 00 00 48 8D 4D A0 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 4D D8 48 8B D7 E8 ?? ?? ?? ?? 48 8D 55 C0 48 8D 4D B0 0F 10 00 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 28 6D B0 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 66 0F 7F 6D B0 E8 ?? ?? ?? ?? 48 8D 55 B0 48 8D 4D A0 E8 ?? ?? ?? ?? EB 44 45 84 D2 74 24 41 80 39 40 75 1E 48 83 65 C0 00 44 21 5D C8 0F 28 45 C0 49 FF C1 66 0F 7F 45 A0 4C 89 0D ?? ?? ?? ?? EB 1B 48 8D 15 ?? ?? ?? ?? 48 8D 4D D8 41 B0 40 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 A0 40 84 F6 74 15 48 8B 0D ?? ?? ?? ?? 83 39 09 74 09 48 8D 55 A0 E8 ?? ?? ?? ?? 0F 28 45 A0 F3 0F 7F 03 48 8B C3 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 80 00 00 00 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_135_0 {
	meta:
		name = "?getScopedName@UnDecorator@@CA?AVDName@@XZ"
		size = 280
		refs = "0029 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 003b ?gName@UnDecorator@@0PEBDEB 0050 ?getScope@UnDecorator@@CA?AVDName@@XZ 0057 ??_C@_02MOLJINC@?3?3?$AA@ 0068 ??YDName@@QEAAAEAV0@PEBD@Z 007d ??YDName@@QEAAAEAV0@AEBV0@@Z 00c6 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 00d1 ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8B EC 48 83 EC 40 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 48 8B D9 48 8D 4D E0 45 33 C0 B2 01 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 03 80 7B 08 00 48 8B 05 ?? ?? ?? ?? 75 4F 80 38 00 74 4A 80 38 40 74 4A 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 6D E0 48 8D 4D E0 48 8B D3 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 0F 28 6D E0 F3 0F 7F 2B 48 8B 05 ?? ?? ?? ?? 80 38 40 75 0C 48 FF C0 48 89 05 ?? ?? ?? ?? EB 69 80 38 00 74 11 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 EB 53 48 83 3B 00 BA 01 00 00 00 75 0A 48 8B CB E8 ?? ?? ?? ?? EB 3E 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 0F 10 00 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 0F 28 6D E0 48 8D 4D E0 48 8B D3 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 0F 28 6D E0 F3 0F 7F 2B 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_152_137_0 {
	meta:
		name = "?getECSUDataType@UnDecorator@@CA?AVDName@@XZ"
		size = 349
		refs = "0019 ?disableFlags@UnDecorator@@0KA 0042 ?gName@UnDecorator@@0PEBDEB 0083 ??_C@_0N@DLIEFKNA@cointerface?5?$AA@ 008c ??_C@_08KOFANOFK@coclass?5?$AA@ 009a ?getEnumType@UnDecorator@@CA?AVDName@@XZ 00a1 ??_C@_05LJGMCFOG@enum?5?$AA@ 00ad ??0DName@@QEAA@PEBD@Z 00c1 ??YDName@@QEAAAEAV0@AEBV0@@Z 00d3 ??_C@_06LJBABKPM@class?5?$AA@ 00dc ??_C@_07DIBCDNGL@struct?5?$AA@ 00e5 ??_C@_06MOJHIBMG@union?5?$AA@ 00ee ??4DName@@QEAAAEAV0@PEBD@Z 0110 ?getScopedName@UnDecorator@@CA?AVDName@@XZ 013b ??_C@_0P@GCIFDJCJ@?$GAunknown?5ecsu?8?$AA@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 60 8B 05 ?? ?? ?? ?? 48 8B F9 44 8B C0 41 C1 E8 0F 41 F7 D0 41 83 E0 01 74 0D 0F BA E0 0C 72 07 BE 01 00 00 00 EB 02 33 F6 48 8B 15 ?? ?? ?? ?? 48 83 65 C0 00 81 65 C8 00 00 FF FF 0F BE 0A 48 FF C2 48 89 15 ?? ?? ?? ?? 85 C9 0F 84 C4 00 00 00 83 E9 54 74 76 FF C9 74 69 FF C9 74 5C FF C9 74 1A FF C9 74 0D FF C9 75 72 48 8D 15 ?? ?? ?? ?? EB 60 48 8D 15 ?? ?? ?? ?? EB 57 48 8D 4D E0 41 8B F0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D3 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 28 6D D0 66 0F 7F 6D C0 EB 22 48 8D 15 ?? ?? ?? ?? EB 10 48 8D 15 ?? ?? ?? ?? EB 07 48 8D 15 ?? ?? ?? ?? 48 8D 4D C0 E8 ?? ?? ?? ?? 48 83 65 D0 00 81 65 D8 00 00 FF FF 85 F6 74 09 0F 28 45 C0 66 0F 7F 45 D0 48 8D 4D C0 E8 ?? ?? ?? ?? 48 8D 55 C0 48 8D 4D D0 E8 ?? ?? ?? ?? 0F 28 6D D0 F3 0F 7F 2F EB 19 48 FF CA 48 8B CF 48 89 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 5C 24 60 48 8B C7 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_138_0 {
	meta:
		name = "?getSymbolName@UnDecorator@@CA?AVDName@@XZ"
		size = 76
		refs = "0009 ?gName@UnDecorator@@0PEBDEB 0020 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 0033 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z 003f ?getZName@UnDecorator@@CA?AVDName@@_N0@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 8B D9 80 38 3F 75 24 48 FF C0 80 38 24 75 09 B2 01 E8 ?? ?? ?? ?? EB 1D 45 33 C0 33 D2 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A 45 33 C0 B2 01 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_139_0 {
	meta:
		name = "?getBasedType@UnDecorator@@CA?AVDName@@XZ"
		size = 234
		refs = "0008 ?disableFlags@UnDecorator@@0KA 000f tokenTable 0026 ??0DName@@QEAA@PEBD@Z 002d ?gName@UnDecorator@@0PEBDEB 006b ?getScopedName@UnDecorator@@CA?AVDName@@XZ 0078 ??YDName@@QEAAAEAV0@AEBV0@@Z 0081 ??_C@_04GKJNKENE@void?$AA@ 008b ??YDName@@QEAAAEAV0@PEBD@Z 00a5 ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 00b2 ?append@DName@@AEAAXPEAVDNameNode@@@Z 00c3 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 00ca ??_C@_02KCKGHPCA@?$CJ?5?$AA@"
	strings:
		$1 = { 40 53 48 83 EC 40 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B D9 F7 D0 A8 01 75 04 48 83 C2 02 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 45 33 DB 44 38 19 74 58 0F BE 01 48 FF C1 48 89 0D ?? ?? ?? ?? 83 F8 30 74 33 83 F8 32 74 15 83 F8 35 75 72 81 63 08 FF 00 FF FF 4C 89 1B C6 43 08 02 EB 7C 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? EB 49 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? EB 36 80 7C 24 28 01 7F 2F 4C 39 5C 24 20 74 19 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? EB 0F 48 8D 4C 24 20 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 6C 24 20 F3 0F 7F 2B 48 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_152_140_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 3353
		refs = "003a ?getTypeEncoding@UnDecorator@@CAHXZ 008b ??0DName@@QEAA@W4DNameStatus@@@Z 009d ??YDName@@QEAAAEAV0@AEBV0@@Z 0153 ?disableFlags@UnDecorator@@0KA 0171 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 017f ??0DName@@QEAA@D@Z 01f7 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 020c ??YDName@@QEAAAEAV0@D@Z 0238 ?gName@UnDecorator@@0PEBDEB 0263 ??_C@_06EEGAIFAK@?$HLflat?$HN?$AA@ 0273 ??0DName@@QEAA@PEBD@Z 02bb ??_C@_03OPGICMGF@?$HN?8?5?$AA@ 02c9 ??YDName@@QEAAAEAV0@PEBD@Z 02de ??_C@_02IGFCGPIL@?$HN?8?$AA@ 02f2 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 0489 ??_C@_00CNPNBAHC@?$AA@ 049f ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 05bd ?getReturnType@UnDecorator@@CA?AVDName@@PEAV2@@Z 05c4 ??_C@_01CLKCMJKC@?5?$AA@ 061b heap 0624 ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 067e ??_C@_0N@CBHHHENL@?$GAvtordispex?$HL?$AA@ 070c ??_C@_0L@GHPFDFH@?$GAvtordisp?$HL?$AA@ 075b ??_C@_0L@HNGCOGAE@?$GAadjustor?$HL?$AA@ 0794 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0817 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 08ae ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z 094e ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 0963 ?getScope@UnDecorator@@CA?AVDName@@XZ 0a06 ??_C@_0CB@KJDOOODE@?$GAlocal?5static?5destructor?5helper?8@ 0a30 ??_C@_0DB@ILEFOCIJ@?$GAtemplate?5static?5data?5member?5con@ 0a5a ??_C@_0DA@HGFJFBBE@?$GAtemplate?5static?5data?5member?5des@ 0af1 ?getExternalDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 0b3f ??_C@_07PGOEDBHP@static?5?$AA@ 0b9b ??_C@_08NIEOINHE@virtual?5?$AA@ 0bfc ??_C@_09LAPHOOG@private?3?5?$AA@ 0c26 ??_C@_0M@GAIFPFIP@protected?3?5?$AA@ 0c48 ??_C@_08GPDDCMKI@public?3?5?$AA@ 0c8b ??_C@_08KJLFOPNE@?$FLthunk?$FN?3?$AA@ 0cc3 ??_C@_0M@DHNBOJMP@extern?5?$CCC?$CC?5?$AA@"
	strings:
		$1 = { 48 8B C4 48 89 58 08 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC F0 00 00 00 48 83 64 24 40 00 81 64 24 48 00 00 FF FF 0F 29 70 B8 0F 29 78 A8 4C 8B EA 48 8B F9 E8 ?? ?? ?? ?? 49 83 7D 00 00 8B F0 74 13 41 F7 45 08 00 02 00 00 74 09 C7 45 7F 01 00 00 00 EB 04 83 65 7F 00 3D FF FF 00 00 75 14 81 67 08 FF 00 FF FF 48 83 27 00 C6 47 08 02 E9 78 0C 00 00 3D FE FF 00 00 75 26 48 8D 4C 24 30 BA 01 00 00 00 E8 ?? ?? ?? ?? 49 8B D5 48 8B CF 0F 10 00 F3 0F 7F 07 E8 ?? ?? ?? ?? E9 4B 0C 00 00 3D FD FF 00 00 75 0E 41 0F 10 45 00 F3 0F 7F 07 E9 36 0C 00 00 44 8B F0 41 81 E6 00 80 00 00 0F 84 B6 07 00 00 45 33 FF 8B C8 44 8B E0 81 E1 00 18 00 00 8B D8 BA 00 10 00 00 81 F9 00 08 00 00 89 4D 6F 41 0F 94 C7 44 23 E2 81 E3 00 04 00 00 45 85 FF 41 8B C4 44 89 7D C7 0F 45 C3 89 5D 77 44 89 65 CB 85 C0 74 0F 8B C6 25 00 1B 00 00 3B C2 0F 84 64 07 00 00 45 85 FF 41 8B C4 0F 45 C3 85 C0 74 1D 8B C6 25 00 1B 00 00 3D 00 11 00 00 0F 84 45 07 00 00 3D 00 12 00 00 0F 84 3A 07 00 00 0F BA E6 0E 0F 83 82 00 00 00 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 74 45 C1 E9 03 F7 D1 F6 C1 01 74 3B 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4D A7 B2 20 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D 87 48 8B D3 0F 10 00 F3 0F 7F 45 87 E8 ?? ?? ?? ?? 0F 28 6D 87 8B 5D 77 66 0F 7F 6C 24 40 EB 2A 48 8D 4C 24 30 E8 ?? ?? ?? ?? 80 7C 24 48 03 74 19 80 78 08 01 7E 13 0F BE 40 08 8B 4C 24 48 33 C1 0F B6 C0 33 C8 89 4C 24 48 8B 4D 6F 45 85 FF 44 0F 45 E3 45 85 E4 0F 84 9D 01 00 00 81 F9 00 18 00 00 0F 85 91 01 00 00 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? 48 8D 4D 87 B2 7B 41 0F 10 6D 00 F3 0F 7F 6D 87 E8 ?? ?? ?? ?? 48 8D 54 24 30 0F 28 6D 87 48 8D 4D 87 66 0F 7F 6D 87 E8 ?? ?? ?? ?? 48 8D 55 87 48 8D 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 80 3B 00 74 37 41 80 3B 41 74 15 8B 45 BF 25 02 00 FF FF 83 C8 02 48 83 65 B7 00 89 45 BF EB 2A 49 FF C3 48 8D 15 ?? ?? ?? ?? 48 8D 4D B7 4C 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0E 48 8D 4D B7 BA 01 00 00 00 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 10 00 00 75 48 48 8D 4C 24 30 B2 2C E8 ?? ?? ?? ?? 48 8D 55 B7 48 8D 4D 87 0F 10 00 F3 0F 7F 45 87 E8 ?? ?? ?? ?? 0F 28 6D 87 48 8D 15 ?? ?? ?? ?? 48 8D 4D 87 66 0F 7F 6D 87 E8 ?? ?? ?? ?? 48 8D 55 87 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 44 8B 1D ?? ?? ?? ?? 41 8B C3 D1 E8 F7 D0 A8 01 0F 84 67 05 00 00 41 8B C3 C1 E8 04 F7 D0 A8 01 0F 84 57 05 00 00 41 0F BA E3 0C 0F 82 4C 05 00 00 48 8D 4D A7 B2 20 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4D 87 0F 10 00 F3 0F 7F 45 87 E8 ?? ?? ?? ?? 0F 28 6D 87 48 8D 4D 87 B2 20 66 0F 7F 6D 87 E8 ?? ?? ?? ?? 48 8D 54 24 40 0F 28 6D 87 48 8D 4D 87 66 0F 7F 6D 87 E8 ?? ?? ?? ?? 0F 28 75 87 44 8B 6D 6F E9 78 07 00 00 8B 5D BF 48 83 65 E7 00 48 83 65 F7 00 48 83 65 D7 00 48 83 65 A7 00 48 83 65 B7 00 44 8B 65 CB B9 00 00 FF FF 21 4D EF 21 4D FF 21 4D DF 21 4D AF 23 D9 45 85 FF 41 8B C4 89 5D BF 0F 45 45 77 85 C0 0F 84 82 00 00 00 45 85 FF 74 65 8B C6 25 00 07 00 00 3D 00 06 00 00 75 2E 48 8D 4C 24 30 B2 01 E8 ?? ?? ?? ?? 48 8D 4C 24 30 B2 01 0F 28 6C 24 30 66 0F 7F 6D E7 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D F7 EB 13 45 85 FF 74 24 8B C6 25 00 07 00 00 3D 00 05 00 00 75 16 48 8D 4C 24 30 B2 01 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D D7 48 8D 4C 24 30 B2 01 E8 ?? ?? ?? ?? B9 00 00 FF FF 0F 28 7C 24 30 EB 04 0F 28 7D A7 45 85 FF 0F 84 81 00 00 00 8B C6 25 00 07 00 00 3D 00 02 00 00 74 73 21 4D AF 21 4D 8F 8B 05 ?? ?? ?? ?? 48 83 65 A7 00 48 83 65 87 00 83 E0 60 C7 44 24 20 01 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 3C 60 74 19 4C 8D 4D A7 48 8D 55 87 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D B7 EB 29 4C 8D 4D 87 48 8D 55 A7 E8 ?? ?? ?? ?? 80 7D BF 03 74 16 80 7C 24 38 01 7E 0F 0F BE 44 24 38 33 C3 0F B6 C0 33 D8 89 5D BF 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 74 38 C1 E9 04 F7 D1 F6 C1 01 74 2E 48 8D 4D 87 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6C 24 40 EB 2A 48 8D 4C 24 30 E8 ?? ?? ?? ?? 80 7C 24 48 03 74 19 80 78 08 01 7E 13 8B 4C 24 48 0F BE 40 08 33 C1 0F B6 C0 33 C8 89 4C 24 48 49 83 7D 00 00 74 51 48 83 7C 24 40 00 74 3E F7 05 ?? ?? ?? ?? 00 10 00 00 75 32 48 8D 4D 87 B2 20 E8 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D5 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 40 E8 ?? ?? ?? ?? EB 0B 41 0F 10 45 00 F3 0F 7F 44 24 40 81 65 8F 00 00 FF FF 45 33 ED 4C 21 6D 87 44 39 6D 7F 74 5F 48 8D 4D A7 33 D2 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D3 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 40 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 10 00 00 74 0A 0F 28 44 24 40 E9 A3 FA FF FF 0F 28 75 87 EB 3E 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 4C 8B E8 48 85 C0 74 11 48 83 20 00 C6 40 08 00 81 60 08 FF 00 FF FF EB 03 45 33 ED 48 8D 4D 97 49 8B D5 E8 ?? ?? ?? ?? 0F 10 30 45 85 FF 44 0F 45 65 77 45 85 E4 0F 84 2B 01 00 00 45 85 FF 0F 84 EB 00 00 00 8B C6 25 00 07 00 00 3D 00 06 00 00 75 7B 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 55 E7 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 48 8D 4C 24 30 B2 2C 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 55 F7 0F 28 6C 24 30 48 8D 4C 24 30 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 6C 24 30 B2 2C 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6C 24 30 EB 2C 45 85 FF 74 5D 8B C6 25 00 07 00 00 3D 00 05 00 00 75 4F 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 44 24 30 48 8D 55 D7 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 B2 2C 0F 28 6C 24 30 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 40 E8 ?? ?? ?? ?? EB 11 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 66 0F 7F 7C 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 4D 87 B2 28 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D3 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 48 8D 4C 24 30 B2 29 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4C 24 40 E8 ?? ?? ?? ?? 45 85 FF 74 1C 8B C6 25 00 07 00 00 3D 00 02 00 00 74 0E 48 8D 55 B7 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 48 8D 4D 97 C1 E8 08 F7 D0 A8 01 74 14 E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B D0 E8 ?? ?? ?? ?? EB 25 E8 ?? ?? ?? ?? 80 7C 24 48 03 74 19 80 78 08 01 7E 13 0F BE 40 08 8B 4C 24 48 33 C1 0F B6 C0 33 C8 89 4C 24 48 8B 05 ?? ?? ?? ?? C1 E8 02 F7 D0 A8 01 74 15 4D 85 ED 74 10 0F 28 44 24 40 F3 41 0F 7F 45 00 E9 04 FB FF FF 0F 28 74 24 40 44 8B 6D 6F E9 7C 02 00 00 48 8D 4C 24 40 49 8B D5 E8 ?? ?? ?? ?? 41 BB 00 7C 00 00 45 85 F6 75 2F 8B C6 41 23 C3 3D 00 68 00 00 75 12 48 8D 54 24 40 48 8B CF E8 ?? ?? ?? ?? E9 3A 04 00 00 45 85 F6 75 0C 8B C6 41 23 C3 3D 00 70 00 00 74 DD B9 00 60 00 00 45 85 F6 0F 85 C5 00 00 00 8B C6 41 23 C3 3B C1 75 58 48 8D 4D 87 33 D2 E8 ?? ?? ?? ?? 48 8D 4C 24 30 B2 7B 0F 28 6C 24 40 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 55 87 48 8D 4C 24 30 0F 28 6C 24 30 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF 0F 28 6C 24 30 F3 0F 7F 2F E8 ?? ?? ?? ?? E9 BA 03 00 00 45 85 F6 75 5F 8B C6 41 23 C3 41 3B C3 75 55 0F 28 44 24 40 48 8D 15 ?? ?? ?? ?? 48 8B CF F3 0F 7F 07 E8 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8B CF 48 8B D0 E8 ?? ?? ?? ?? B2 7D 48 8B CF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 80 38 40 0F 85 65 03 00 00 48 FF C0 48 89 05 ?? ?? ?? ?? E9 56 03 00 00 45 33 FF 44 8B EE 8B C6 41 81 E5 00 18 00 00 44 8B E6 41 81 FD 00 08 00 00 41 0F 94 C7 85 F1 B9 00 00 00 00 0F 94 C1 45 85 F6 41 0F 45 CF 25 00 04 00 00 41 81 E4 00 10 00 00 85 C9 89 4D C7 44 0F 45 E0 45 85 E4 0F 84 83 00 00 00 33 C9 8B C6 41 8B D6 25 00 1B 00 00 3D 00 10 00 00 0F 94 C1 F7 DA 1B C0 85 C1 74 09 48 8D 15 ?? ?? ?? ?? EB 52 45 85 E4 74 59 33 C9 8B C6 41 8B D6 25 00 1B 00 00 3D 00 11 00 00 0F 94 C1 F7 DA 1B C0 85 C1 74 09 48 8D 15 ?? ?? ?? ?? EB 28 45 85 E4 74 2F 33 C9 8B C6 41 8B D6 25 00 1B 00 00 3D 00 12 00 00 0F 94 C1 F7 DA 1B C0 85 C1 74 13 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? EB 15 45 85 F6 75 10 8B C6 41 23 C3 3D 00 78 00 00 0F 84 86 FB FF FF 45 85 E4 74 63 33 C9 8B D6 41 8B C6 81 E2 00 1B 00 00 81 FA 00 11 00 00 0F 94 C1 F7 D8 1B C0 85 C1 75 16 33 C9 81 FA 00 12 00 00 41 8B C6 0F 94 C1 F7 D8 1B C0 85 C1 74 2F 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 EB 11 48 8D 54 24 40 48 8D 4D 97 E8 ?? ?? ?? ?? 0F 10 30 0F 29 74 24 40 83 7D C7 00 0F 84 70 01 00 00 8B 05 ?? ?? ?? ?? C1 E8 09 F7 D0 A8 01 0F 84 B0 00 00 00 33 C9 8B DE B8 01 00 00 00 81 E3 00 07 00 00 81 FB 00 02 00 00 0F 94 C1 45 85 F6 0F 45 C1 85 C0 74 32 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 0F 29 74 24 40 45 85 F6 74 08 81 FB 00 01 00 00 74 1D 45 85 E4 74 4A 81 FB 00 05 00 00 74 10 81 FB 00 06 00 00 74 08 81 FB 00 04 00 00 75 32 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 0F 29 74 24 40 8B 05 ?? ?? ?? ?? C1 E8 07 F7 D0 A8 01 0F 84 9A 00 00 00 33 C0 8B D6 81 E2 C0 00 00 00 83 FA 40 0F 94 C0 45 85 F6 44 0F 45 F8 45 85 FF 74 09 48 8D 15 ?? ?? ?? ?? EB 4A 33 C9 81 FA 80 00 00 00 0F 94 C1 33 C0 41 81 FD 00 10 00 00 0F 94 C0 45 85 F6 0F 45 C1 85 C0 74 09 48 8D 15 ?? ?? ?? ?? EB 20 33 C9 85 D2 0F 94 C1 33 C0 45 85 ED 0F 94 C0 45 85 F6 0F 45 C1 85 C0 74 32 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 0F 29 74 24 40 45 85 E4 74 3E F7 05 ?? ?? ?? ?? 00 10 00 00 75 32 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 0F 29 74 24 40 0F BA E6 10 73 2D 48 8D 15 ?? ?? ?? ?? 48 8D 4D 97 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 74 24 30 F3 0F 7F 37 4C 8D 9C 24 F0 00 00 00 48 8B C7 49 8B 5B 40 41 0F 28 73 F0 41 0F 28 7B E0 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_152_141_0 {
	meta:
		name = "?getDecoratedName@UnDecorator@@CA?AVDName@@XZ"
		size = 653
		refs = "0014 ?disableFlags@UnDecorator@@0KA 0032 ?getDataType@UnDecorator@@CA?AVDName@@PEAV2@@Z 004e ?gName@UnDecorator@@0PEBDEB 0078 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 00a2 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 00b5 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z 00c5 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 011e ?getScope@UnDecorator@@CA?AVDName@@XZ 012f ?fExplicitTemplateParams@UnDecorator@@0_NA 014f ??YDName@@QEAAAEAV0@AEBV0@@Z 0193 ??_C@_02MOLJINC@?3?3?$AA@ 0198 ??YDName@@QEAAAEAV0@PEBD@Z 024d ?composeDeclaration@UnDecorator@@CA?AVDName@@AEBV2@@Z 0276 ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 20 55 48 8B EC 48 83 EC 50 8B 05 ?? ?? ?? ?? 48 8B D9 0F BA E0 0D 73 2A 0F BA F0 0D 48 8D 4D F0 33 D2 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BA 2D ?? ?? ?? ?? 0D 0F 10 45 F0 F3 0F 7F 03 E9 2F 02 00 00 48 8B 05 ?? ?? ?? ?? B2 3F 8A 08 3A CA 0F 85 0B 02 00 00 48 FF C0 48 89 05 ?? ?? ?? ?? 38 10 75 4F 48 FF C0 38 10 75 23 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? EB 0A 48 FF C0 48 89 05 ?? ?? ?? ?? 80 38 00 75 F1 EB A8 80 38 24 48 8D 4D D0 75 09 B2 01 E8 ?? ?? ?? ?? EB 21 45 33 C0 33 D2 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0E 48 8D 4D D0 45 33 C0 B2 01 E8 ?? ?? ?? ?? 48 83 7D D0 00 8B 75 D8 74 0F 0F BA E6 09 73 09 C7 45 20 01 00 00 00 EB 04 83 65 20 00 8B CE C1 E9 0F 83 E1 01 80 7D D8 01 89 4D 18 7E 09 0F 28 45 D0 E9 42 FF FF FF 48 8B 05 ?? ?? ?? ?? 80 38 00 0F 84 B1 00 00 00 80 38 40 0F 84 A8 00 00 00 48 8D 4D E0 E8 ?? ?? ?? ?? 48 83 7D E0 00 0F 84 91 00 00 00 80 3D ?? ?? ?? ?? 00 48 8D 4D F0 74 4D 0F 28 45 D0 48 8D 55 E0 C6 05 ?? ?? ?? ?? 00 66 0F 7F 45 F0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6D F0 80 38 40 66 0F 7F 6D D0 74 53 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 4D F0 0F 10 00 F3 0F 7F 45 E0 0F 10 08 F3 0F 7F 4D F0 EB 09 0F 28 45 E0 66 0F 7F 45 F0 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D F0 0F 28 6D F0 66 0F 7F 6D F0 E8 ?? ?? ?? ?? 0F 28 6D F0 66 0F 7F 6D D0 8B 75 D8 8B 4D 18 8B 55 20 85 D2 74 0E 48 83 7D D0 00 74 07 0F BA EE 09 89 75 D8 41 B8 00 80 00 00 85 C9 74 06 41 0B F0 89 75 D8 48 83 7D D0 00 0F 84 06 FF FF FF B9 00 10 00 00 85 F1 0F 85 F9 FE FF FF 48 8B 05 ?? ?? ?? ?? 80 38 00 74 1D 80 38 40 74 11 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 EB 5A 48 FF 05 ?? ?? ?? ?? 85 0D ?? ?? ?? ?? 74 2C 85 D2 75 28 41 85 F0 75 23 48 83 65 E0 00 81 65 E8 00 00 FF FF 48 8D 55 E0 48 8D 4D F0 E8 ?? ?? ?? ?? 0F 28 6D D0 F3 0F 7F 2B EB 1F 48 8D 55 D0 48 8B CB E8 ?? ?? ?? ?? EB 11 84 C9 75 A2 BA 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B 74 24 78 48 8B C3 48 8B 5C 24 60 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_152_142_0 {
	meta:
		name = "?getScope@UnDecorator@@CA?AVDName@@XZ"
		size = 1003
		refs = "0040 ?gName@UnDecorator@@0PEBDEB 0058 ?fExplicitTemplateParams@UnDecorator@@0_NA 0061 ?fGetTemplateArgumentList@UnDecorator@@0_NA 0075 ??_C@_02MOLJINC@?3?3?$AA@ 0081 ??0DName@@QEAA@PEBD@Z 0095 ??YDName@@QEAAAEAV0@AEBV0@@Z 00b0 ??0DName@@QEAA@D@Z 0122 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 013f ??0DName@@QEAA@AEBV0@@Z 0161 ??YDName@@QEAAAEAV0@D@Z 0195 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 01f4 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPEA_N@Z 0235 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 02a2 ??0DName@@QEAA@AEAPEBDD@Z 02a9 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 02d5 ?pZNameList@UnDecorator@@0PEAVReplicator@@EA 02e3 ??YReplicator@@QEAAAEAV0@AEBVDName@@@Z 0385 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 0390 ??0DName@@QEAA@W4DNameStatus@@@Z 03aa ??YDName@@QEAAAEAV0@PEBD@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 48 8D A8 38 FF FF FF 48 81 EC C0 01 00 00 48 83 21 00 C6 41 08 00 81 61 08 FF 00 FF FF 40 32 F6 48 8B F9 40 38 71 08 0F 85 17 03 00 00 48 8B 05 ?? ?? ?? ?? 80 38 00 0F 84 07 03 00 00 80 38 40 0F 84 FE 02 00 00 80 3D ?? ?? ?? ?? 00 74 0D 80 3D ?? ?? ?? ?? 00 0F 84 63 03 00 00 48 83 3F 00 74 64 48 8D 15 ?? ?? ?? ?? 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D7 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 10 6D D0 F3 0F 7F 2F 40 84 F6 74 30 48 8D 8D B0 00 00 00 B2 5B E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B D7 0F 10 00 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 0F 10 6C 24 40 40 32 F6 F3 0F 7F 2F 48 8B 05 ?? ?? ?? ?? 80 38 3F 0F 85 38 02 00 00 48 FF C0 48 89 05 ?? ?? ?? ?? 0F BE 08 83 E9 24 0F 84 ED 01 00 00 FF C9 0F 84 8F 01 00 00 83 E9 1A 0F 84 C0 00 00 00 83 E9 02 0F 84 7D 01 00 00 83 F9 08 74 69 48 8D 4D 40 33 D2 E8 ?? ?? ?? ?? 48 8D 8D 80 00 00 00 B2 60 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D F0 48 8B D0 E8 ?? ?? ?? ?? 48 8D 4D F0 48 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 60 B2 27 0F 28 6D F0 66 0F 7F 6C 24 60 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D7 0F 28 6C 24 60 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 0F 28 6D E0 E9 C3 01 00 00 48 FF 05 ?? ?? ?? ?? 48 8D 4D 60 45 33 C0 B2 01 E8 ?? ?? ?? ?? 48 8D 4D 80 B2 5D 0F 10 00 F3 0F 7F 45 80 E8 ?? ?? ?? ?? 0F 28 6D 80 48 8D 4D C0 48 8B D7 66 0F 7F 6D C0 E8 ?? ?? ?? ?? 40 B6 01 0F 28 6D C0 E9 7A 01 00 00 48 8B 05 ?? ?? ?? ?? 48 8D 48 01 80 39 5F 75 53 80 78 02 3F 75 4D 48 89 0D ?? ?? ?? ?? 48 8D 4D 20 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 8D 4D A0 48 8B D7 0F 10 00 F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 0F 10 6D A0 F3 0F 7F 2F 48 8B 05 ?? ?? ?? ?? 80 38 40 0F 85 27 01 00 00 48 FF 05 ?? ?? ?? ?? E9 1B 01 00 00 48 8D 4D 30 E8 ?? ?? ?? ?? 48 8D 4D 50 B2 60 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4C 24 50 48 8B D3 0F 10 00 F3 0F 7F 44 24 50 E8 ?? ?? ?? ?? 0F 28 6C 24 50 48 8D 4C 24 70 B2 27 66 0F 7F 6C 24 70 E8 ?? ?? ?? ?? 48 8D 4D 90 0F 28 6C 24 70 48 8B D7 66 0F 7F 6D 90 E8 ?? ?? ?? ?? 0F 28 6D 90 E9 B4 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D 00 41 B0 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 70 E8 ?? ?? ?? ?? 48 8D 4D B0 48 8B D7 0F 10 00 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 6D B0 F3 0F 7F 2F 48 8B 0D ?? ?? ?? ?? 83 39 09 74 6D 48 8D 55 00 E8 ?? ?? ?? ?? EB 62 48 FF 0D ?? ?? ?? ?? 48 8D 8D 90 00 00 00 45 33 C0 B2 01 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D7 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 10 6C 24 30 EB 29 48 8D 4D 10 45 33 C0 B2 01 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D7 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 6C 24 20 F3 0F 7F 2F 80 7F 08 00 E9 E3 FC FF FF 48 8B 05 ?? ?? ?? ?? 80 38 00 74 16 80 38 40 74 6A 81 67 08 FF 00 FF FF 48 83 27 00 C6 47 08 02 EB 59 48 83 3F 00 BA 01 00 00 00 75 0A 48 8B CF E8 ?? ?? ?? ?? EB 44 48 8D 4D 10 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 28 6C 24 20 48 8D 4C 24 20 48 8B D7 66 0F 7F 6C 24 20 E8 ?? ?? ?? ?? 0F 28 6C 24 20 F3 0F 7F 2F 4C 8D 9C 24 C0 01 00 00 48 8B C7 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_143_0 {
	meta:
		name = "?getFunctionIndirectType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 1257
		refs = "0026 ?gName@UnDecorator@@0PEBDEB 003e ??0DName@@QEAA@W4DNameStatus@@@Z 0050 ??YDName@@QEAAAEAV0@AEBV0@@Z 010c ??_C@_02MOLJINC@?3?3?$AA@ 0115 ??0DName@@QEAA@PEBD@Z 0147 ?getScope@UnDecorator@@CA?AVDName@@XZ 0155 ??0DName@@QEAA@D@Z 01d9 ?disableFlags@UnDecorator@@0KA 01e8 ??_C@_00CNPNBAHC@?$AA@ 020c ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 0237 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0297 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 039e ??YDName@@QEAAAEAV0@D@Z 03b1 heap 03ba ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 03e1 ?getReturnType@UnDecorator@@CA?AVDName@@PEAV2@@Z 03ea ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 046c ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC 90 00 00 00 48 8B 05 ?? ?? ?? ?? 33 DB 4C 8B F2 48 8B F9 38 18 75 23 8D 53 01 48 8D 4D 17 E8 ?? ?? ?? ?? 49 8B D6 0F 10 00 48 8B CF F3 0F 7F 07 E8 ?? ?? ?? ?? E9 6C 04 00 00 80 38 36 7C 05 80 38 39 7E 18 80 38 5F 74 13 81 61 08 FF 00 FF FF 48 89 19 C6 41 08 02 E9 4A 04 00 00 0F BE 30 41 BC 01 00 00 00 83 C9 FF 49 03 C4 83 EE 36 48 89 05 ?? ?? ?? ?? 83 FE 29 75 26 38 18 74 1A 0F BE 30 49 03 C4 83 EE 3D 48 89 05 ?? ?? ?? ?? 83 FE 04 7C 16 83 FE 07 EB 0F 41 8B D4 E9 7A FF FF FF 85 F6 78 05 83 FE 03 7E 02 8B F1 3B F1 75 13 81 67 08 FF 00 FF FF 48 89 1F C6 47 08 02 E9 E4 03 00 00 44 8B 6D EF 0F 10 02 44 8B FE 41 81 E5 00 00 FF FF 41 83 E7 02 48 89 5D E7 44 89 6D EF F3 0F 7F 45 D7 0F 84 10 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D 17 E8 ?? ?? ?? ?? 48 8D 55 D7 48 8D 4D 07 0F 10 00 F3 0F 7F 45 07 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6D 07 48 8D 4D 17 66 0F 7F 6D D7 38 18 74 41 E8 ?? ?? ?? ?? 48 8D 4D F7 B2 20 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D 07 48 8B D3 0F 10 00 F3 0F 7F 45 07 E8 ?? ?? ?? ?? 0F 28 6D 07 48 8D 55 D7 48 8D 4D 07 66 0F 7F 6D 07 E8 ?? ?? ?? ?? 33 DB EB 1D 41 8B D4 E8 ?? ?? ?? ?? 48 8D 55 D7 48 8D 4D 07 0F 10 00 F3 0F 7F 45 07 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6D 07 66 0F 7F 6D D7 38 18 0F 84 3F 01 00 00 80 38 40 0F 85 09 FF FF FF 49 03 C4 48 89 5D F7 48 89 5D 07 48 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 44 89 64 24 20 83 E0 60 4C 8D 05 ?? ?? ?? ?? 48 8D 4D 17 3C 60 B8 00 00 FF FF 0F 84 C1 00 00 00 21 45 FF 21 45 0F 4C 8D 4D F7 48 8D 55 07 E8 ?? ?? ?? ?? 0F 28 6D 17 66 0F 7F 6D E7 40 F6 C6 04 74 5D 8B 05 ?? ?? ?? ?? D1 E8 F7 D0 41 84 C4 0F 84 DE 00 00 00 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8D 4D F7 B2 20 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D 17 48 8B D3 0F 10 00 F3 0F 7F 45 17 E8 ?? ?? ?? ?? 0F 28 6D 17 48 8D 55 D7 48 8D 4D 17 66 0F 7F 6D 17 E8 ?? ?? ?? ?? 0F 28 6D 17 66 0F 7F 6D D7 8B 5D DF 8B 05 ?? ?? ?? ?? D1 E8 F7 D0 41 84 C4 0F 84 B1 00 00 00 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8D 55 D7 48 8D 4D 17 0F 10 00 F3 0F 7F 45 17 E8 ?? ?? ?? ?? 0F 28 6D 17 66 0F 7F 6D D7 E9 A8 00 00 00 21 45 0F 21 45 FF 4C 8D 4D 07 48 8D 55 F7 E8 ?? ?? ?? ?? 80 7D EF 03 0F 84 3E FF FF FF 44 38 65 1F 0F 8E 34 FF FF FF 0F BE 45 1F 41 33 C5 0F B6 C0 44 33 E8 44 89 6D EF E9 1E FF FF FF 48 8D 4D 17 41 8B D4 E8 ?? ?? ?? ?? 48 8D 55 D7 E9 35 FD FF FF 48 8D 4D 17 E8 ?? ?? ?? ?? 80 7D DF 03 0F 84 59 FF FF FF 44 38 60 08 0F 8E 4F FF FF FF 8B 5D DF 0F BE 40 08 33 C3 0F B6 C0 33 D8 89 5D DF E9 3C FF FF FF 48 8D 4D 17 E8 ?? ?? ?? ?? 80 7D DF 03 74 14 44 38 60 08 7E 0E 0F BE 40 08 33 C3 0F B6 C0 33 D8 89 5D DF 45 33 ED 4D 39 2E 74 3D 48 8D 4D 07 B2 28 E8 ?? ?? ?? ?? 48 8D 55 D7 48 8D 4D 17 0F 10 00 F3 0F 7F 45 17 E8 ?? ?? ?? ?? 0F 28 6D 17 48 8D 4D 17 B2 29 66 0F 7F 6D 17 E8 ?? ?? ?? ?? 0F 28 6D 17 66 0F 7F 6D D7 45 33 C0 48 8D 0D ?? ?? ?? ?? 41 8D 50 10 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 10 44 88 68 08 81 60 08 FF 00 FF FF 4C 89 28 EB 03 49 8B F5 48 8D 4D 27 48 8B D6 E8 ?? ?? ?? ?? 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8D 4D F7 B2 28 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D 17 48 8B D3 0F 10 00 F3 0F 7F 45 17 E8 ?? ?? ?? ?? 0F 28 6D 17 48 8D 4D 17 B2 29 66 0F 7F 6D 17 E8 ?? ?? ?? ?? 48 8D 55 17 48 8D 4D D7 E8 ?? ?? ?? ?? 44 8B 1D ?? ?? ?? ?? 41 8B C3 83 E0 60 3C 60 74 19 45 85 FF 74 14 48 8D 55 E7 48 8D 4D D7 E8 ?? ?? ?? ?? 44 8B 1D ?? ?? ?? ?? 41 C1 EB 08 48 8D 4D 17 41 F7 D3 45 84 DC 74 13 E8 ?? ?? ?? ?? 48 8D 4D D7 48 8B D0 E8 ?? ?? ?? ?? EB 22 E8 ?? ?? ?? ?? 80 7D DF 03 74 17 44 38 60 08 7E 11 8B 4D DF 0F BE 40 08 33 C1 0F B6 C0 33 C8 89 4D DF 48 85 F6 74 12 0F 28 45 D7 F3 0F 7F 06 0F 10 4D 27 F3 0F 7F 0F EB 0E 81 67 08 FF 00 FF FF 4C 89 2F C6 47 08 03 4C 8D 9C 24 90 00 00 00 48 8B C7 49 8B 5B 30 49 8B 73 38 49 8B 7B 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_152_144_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z"
		size = 1856
		refs = "002b ?gName@UnDecorator@@0PEBDEB 0069 ?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AEAPEBDAEA_NH@Z 00b6 ?disableFlags@UnDecorator@@0KA 00ef tokenTable 010c ??YDName@@QEAAAEAV0@D@Z 0121 ??YDName@@QEAAAEAV0@PEBD@Z 01b2 ??4DName@@QEAAAEAV0@PEBD@Z 02ce ??0DName@@QEAA@PEBD@Z 02e6 ??YDName@@QEAAAEAV0@AEBV0@@Z 0398 ??_C@_02MOLJINC@?3?3?$AA@ 03d7 ?getScope@UnDecorator@@CA?AVDName@@XZ 03e3 ??0DName@@QEAA@W4DNameStatus@@@Z 046d ?make@DNameStatusNode@@SAPEAV1@W4DNameStatus@@@Z 0479 ?append@DName@@AEAAXPEAVDNameNode@@@Z 0489 ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 04b3 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 050c ??_C@_09GAIEOBLP@volatile?5?$AA@ 0543 ??_C@_06LIJLOJAG@const?5?$AA@ 059a ??0DName@@QEAA@D@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 4C 89 40 18 55 57 41 54 41 55 41 56 48 8D 68 A9 48 81 EC E0 00 00 00 33 F6 0F 29 70 C8 48 8B 05 ?? ?? ?? ?? 4C 8B E2 BA 00 00 FF FF 4D 8B E9 21 55 C7 48 8B D9 48 89 75 BF 40 88 74 24 20 40 38 30 0F 84 1E 06 00 00 80 38 24 75 2E 44 8B 4D 7F 4C 8D 44 24 20 48 8D 55 6F 48 8D 4D AF E8 ?? ?? ?? ?? 48 39 75 AF 74 0D 0F 10 45 AF F3 0F 7F 03 E9 9C 06 00 00 BA 00 00 FF FF 48 8B 05 ?? ?? ?? ?? 48 89 75 8F 48 89 75 AF 0F BE 08 B8 16 00 00 00 4C 8B F6 44 8D 40 2B 8B F9 41 3A C8 41 0F 4D C0 21 55 B7 2B F8 21 55 97 8B 15 ?? ?? ?? ?? 0F 28 75 8F 8B C7 83 E8 04 0F 84 F7 00 00 00 FF C8 74 75 83 F8 03 0F 85 D0 01 00 00 8B C2 D1 E8 F7 D0 A8 01 0F 84 63 01 00 00 F7 D2 48 39 75 AF 74 47 48 8B 3D ?? ?? ?? ?? F6 C2 01 75 04 48 83 C7 02 0F 28 45 AF 48 8D 4D EF B2 20 66 0F 7F 45 EF E8 ?? ?? ?? ?? 48 8D 4D CF 0F 28 6D EF 48 8B D7 66 0F 7F 6D CF E8 ?? ?? ?? ?? 0F 28 6D CF 66 0F 7F 6D AF E9 08 01 00 00 F6 C2 01 48 8B 15 ?? ?? ?? ?? E9 EA 00 00 00 8B C2 D1 E8 F7 D0 A8 01 0F 84 F7 00 00 00 F7 D2 4D 85 F6 74 46 48 8B 3D ?? ?? ?? ?? F6 C2 01 75 04 48 83 C7 02 48 8D 4D 0F B2 20 66 0F 7F 75 0F E8 ?? ?? ?? ?? 48 8D 4D FF 48 8B D7 0F 28 6D 0F 66 0F 7F 6D FF E8 ?? ?? ?? ?? 0F 28 75 FF 0F 29 75 8F 4C 8B 75 8F E9 9E 00 00 00 F6 C2 01 48 8B 15 ?? ?? ?? ?? 75 04 48 83 C2 02 48 8D 4D 8F E8 ?? ?? ?? ?? 4C 8B 75 8F 0F 28 75 8F EB 7B 8B C2 D1 E8 F7 D0 A8 01 74 7D 8B C2 C1 E8 11 F7 D0 A8 01 74 72 F7 D2 48 39 75 AF 74 45 48 8B 3D ?? ?? ?? ?? F6 C2 01 75 04 48 83 C7 02 0F 28 45 AF 48 8D 4D DF B2 20 66 0F 7F 45 DF E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 6D DF 48 8B D7 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 E9 07 FF FF FF F6 C2 01 48 8B 15 ?? ?? ?? ?? 75 04 48 83 C2 02 48 8D 4D AF E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 41 B8 41 00 00 00 48 8B 05 ?? ?? ?? ?? 48 FF C0 48 89 05 ?? ?? ?? ?? 80 38 24 75 2C 44 8B 4D 7F 4C 8D 44 24 20 48 8D 55 6F 48 8D 4D 9F E8 ?? ?? ?? ?? 48 39 75 9F 0F 85 EA 03 00 00 8B 15 ?? ?? ?? ?? 41 B8 41 00 00 00 48 8B 05 ?? ?? ?? ?? B9 16 00 00 00 44 38 00 0F BE 38 41 0F 4D C8 2B F9 E9 18 FE FF FF 48 8B 05 ?? ?? ?? ?? 40 38 30 74 07 48 FF 05 ?? ?? ?? ?? 83 FF 1F 0F 87 92 03 00 00 48 8B 75 6F 48 8D 4D 8F 48 8B D6 E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 28 6D BF 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 83 7D AF 00 0F 28 6C 24 30 66 0F 7F 6D 8F 74 35 48 8D 4C 24 30 B2 20 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 48 8D 55 AF 48 8D 4C 24 30 0F 28 6C 24 30 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F 4D 85 F6 74 35 48 8D 4C 24 30 B2 20 66 0F 7F 74 24 30 E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 28 6C 24 30 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F 45 33 F6 40 F6 C7 10 0F 84 16 01 00 00 44 39 75 7F 74 13 81 63 08 FF 00 FF FF 4C 89 33 C6 43 08 02 E9 8C 03 00 00 44 38 36 74 75 48 8D 15 ?? ?? ?? ?? 48 8D 4D 9F E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 0F 28 6C 24 30 48 8D 4D 9F 66 0F 7F 6D 8F 44 38 30 74 07 E8 ?? ?? ?? ?? EB 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 10 00 48 8D 55 8F 48 8D 4C 24 30 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F EB 30 48 8B 05 ?? ?? ?? ?? 44 38 30 74 45 48 8D 4D 9F E8 ?? ?? ?? ?? 80 7D 97 03 74 15 80 78 08 01 7E 0F 0F BE 40 08 8B 4D 97 33 C1 0F B6 C0 31 45 97 48 8B 05 ?? ?? ?? ?? 8A 08 84 C9 74 14 48 FF C0 48 89 05 ?? ?? ?? ?? 80 F9 40 74 37 E9 22 FF FF FF 80 7D 97 01 7F 2C 4C 39 75 8F 74 18 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D 8F 48 8B D0 E8 ?? ?? ?? ?? EB 0E 48 8D 4D 8F BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 8B C7 74 3D 83 E0 0C 3C 0C 75 5F 44 39 75 7F 0F 85 CF FE FF FF 48 8D 4D 9F E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F EB 29 83 E0 0C 3C 0C 75 22 48 8D 4D 9F E8 ?? ?? ?? ?? 80 7D 97 03 74 13 80 78 08 01 7E 0D 0F BE 40 08 33 45 97 0F B6 C0 31 45 97 40 F6 C7 02 74 31 48 8D 15 ?? ?? ?? ?? 48 8D 4D 9F E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F 40 F6 C7 01 74 31 48 8D 15 ?? ?? ?? ?? 48 8D 4D 9F E8 ?? ?? ?? ?? 48 8D 55 8F 48 8D 4C 24 30 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 66 0F 7F 6D 8F BF 00 01 00 00 44 39 75 7F 0F 85 B7 00 00 00 4D 39 34 24 74 7C 41 85 7C 24 08 75 4E 4D 39 75 00 74 48 48 8D 4D 9F B2 20 E8 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D5 0F 10 00 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 0F 28 6C 24 30 48 8D 4C 24 30 B2 20 66 0F 7F 6C 24 30 E8 ?? ?? ?? ?? 49 8B D4 0F 28 6C 24 30 66 0F 7F 6C 24 30 EB 44 41 F7 44 24 08 00 08 00 00 74 0C 41 0F 10 04 24 F3 0F 7F 45 8F EB 45 48 8D 4D 9F B2 20 E8 ?? ?? ?? ?? 49 8B D4 EB 14 4D 39 75 00 74 2F 48 8D 4D 9F B2 20 E8 ?? ?? ?? ?? 49 8B D5 0F 10 00 F3 0F 7F 44 24 30 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8D 4D 8F E8 ?? ?? ?? ?? 8B 4D 97 0B CF 89 4D 97 44 38 74 24 20 74 05 0F BA 6D 97 0D 0F 28 45 8F E9 23 FA FF FF 81 63 08 FF 00 FF FF 48 89 33 C6 43 08 02 E9 B5 00 00 00 0F 10 45 9F E9 07 FA FF FF 39 75 7F 0F 85 99 00 00 00 49 39 34 24 74 74 BF 00 01 00 00 41 85 7C 24 08 75 51 49 39 31 74 4C 48 8D 4C 24 30 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D 9F 49 8B D5 0F 10 00 F3 0F 7F 45 9F E8 ?? ?? ?? ?? 0F 28 6D 9F 48 8D 4D 9F B2 20 66 0F 7F 6D 9F E8 ?? ?? ?? ?? 0F 28 6D 9F F3 0F 7F 2B 49 8B D4 48 8B CB E8 ?? ?? ?? ?? EB 40 48 8D 4D 9F BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 03 EB DC 49 39 31 74 1A 48 8D 4D 9F BA 01 00 00 00 E8 ?? ?? ?? ?? 49 8B D5 0F 10 00 F3 0F 7F 03 EB C0 BA 01 00 00 00 E8 ?? ?? ?? ?? 4C 8D 9C 24 E0 00 00 00 48 8B C3 49 8B 5B 30 49 8B 73 38 41 0F 28 73 F0 49 8B E3 41 5E 41 5D 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_152_145_0 {
	meta:
		name = "??BUnDecorator@@QEAAPEADXZ"
		size = 422
		refs = "0025 ?name@UnDecorator@@0PEBDEB 0042 ?gName@UnDecorator@@0PEBDEB 004c ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0053 ??_C@_04HEJADOOB@CV?3?5?$AA@ 005f ??0DName@@QEAA@PEBD@Z 0073 ??YDName@@QEAAAEAV0@AEBV0@@Z 0089 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 00d3 ?disableFlags@UnDecorator@@0KA 00fc ??4DName@@QEAAAEAV0@PEBD@Z 0103 ?outputString@UnDecorator@@0PEADEA 0121 ?maxStringLength@UnDecorator@@0HA 012f heap 014e ?getString@DName@@QEBAPEADPEADH@Z"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8B EC 48 83 EC 70 48 83 65 B0 00 48 83 65 C0 00 B8 00 00 FF FF 21 45 B8 21 45 C8 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 88 00 00 00 80 38 3F 75 71 8A 48 01 80 F9 40 75 3E 48 83 05 ?? ?? ?? ?? 02 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 48 8B D8 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D3 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 28 6D D0 EB 37 80 F9 24 75 26 48 8D 4D F0 33 D2 E8 ?? ?? ?? ?? 0F 10 28 0F 29 6D B0 80 7D B8 02 75 24 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 0F 10 28 0F 29 6D B0 EB 04 0F 28 6D B0 80 7D B8 03 75 07 33 C0 E9 CD 00 00 00 80 7D B8 02 74 1F F7 05 ?? ?? ?? ?? 00 10 00 00 75 0C 48 8B 05 ?? ?? ?? ?? 80 38 00 75 07 66 0F 7F 6D C0 EB 10 48 8B 15 ?? ?? ?? ?? 48 8D 4D C0 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 33 48 8B 4D C0 48 85 C9 74 05 48 8B 01 FF 10 FF C0 48 63 C8 89 05 ?? ?? ?? ?? 48 83 C1 07 48 83 E1 F8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 59 44 8B 05 ?? ?? ?? ?? 48 8D 4D C0 48 8B D0 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 41 8A 03 49 8B CB 84 C0 74 29 B2 20 3A C2 75 14 49 FF C3 88 11 48 FF C1 EB 03 49 FF C3 41 38 13 74 F8 EB 08 88 01 48 FF C1 49 FF C3 41 8A 03 84 C0 75 D9 41 8A 03 88 01 48 8B 05 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 48 83 C4 70 5D C3 }
	condition:
		$1
}

rule file_152_146_0 {
	meta:
		name = "?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
		size = 310
		refs = "001e ?gName@UnDecorator@@0PEBDEB 004f ??0DName@@QEAA@PEBD@Z 006f ??YDName@@QEAAAEAV0@AEBV0@@Z 008c ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@AEBV2@@Z 00a7 ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 00be ?getPtrRefDataType@UnDecorator@@CA?AVDName@@AEBV2@H@Z 00ce ??0DName@@QEAA@W4DNameStatus@@@Z 00da ??YDName@@QEAAAEAV0@PEBD@Z 0102 ??YDName@@QEAAAEAV0@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 41 54 41 55 48 8B EC 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 33 DB 4D 8B E9 49 8B F8 4C 8B E2 48 8B F1 38 18 0F 84 8C 00 00 00 80 38 36 7C 05 80 38 39 7E 05 80 38 5F 75 4E 48 8D 4D F0 49 8B D1 E8 ?? ?? ?? ?? 49 39 1C 24 74 1A 48 39 1F 74 09 F7 47 08 00 01 00 00 75 0C 48 8D 4D F0 49 8B D4 E8 ?? ?? ?? ?? 48 39 1F 74 0C 48 8D 4D F0 48 8B D7 E8 ?? ?? ?? ?? 48 8D 55 F0 48 8B CE E8 ?? ?? ?? ?? E9 85 00 00 00 4C 8B CA 48 8D 4D F0 4D 8B C5 48 8B D7 89 5C 24 20 E8 ?? ?? ?? ?? 41 80 7D 00 2A 48 8D 55 F0 0F 94 C3 48 8B CE 44 8B C3 E8 ?? ?? ?? ?? EB 56 48 8D 4D F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D F0 49 8B D5 E8 ?? ?? ?? ?? 49 39 1C 24 74 0C 48 8D 4D F0 49 8B D4 E8 ?? ?? ?? ?? 48 39 1F 74 1D 49 39 1C 24 74 0B 48 8D 4D F0 B2 20 E8 ?? ?? ?? ?? 48 8D 4D F0 48 8B D7 E8 ?? ?? ?? ?? 0F 10 45 F0 F3 0F 7F 06 48 8B 5C 24 60 48 8B 7C 24 70 48 8B C6 48 8B 74 24 68 48 83 C4 40 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_152_147_0 {
	meta:
		name = "?getPointerType@UnDecorator@@CA?AVDName@@AEBV2@0@Z"
		size = 30
		refs = "0009 ??_C@_01NBENCBCI@?$CK?$AA@ 0011 ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8D 0D ?? ?? ?? ?? 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_148_0 {
	meta:
		name = "?getPointerTypeArray@UnDecorator@@CA?AVDName@@AEBV2@0@Z"
		size = 30
		refs = "0009 ??_C@_00CNPNBAHC@?$AA@ 0011 ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8D 0D ?? ?? ?? ?? 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_152_150_0 {
	meta:
		name = "__unDName"
		size = 261
		refs = "0036 _mtinitlocknum 0044 _lock 004c heap 0098 ??0UnDecorator@@QEAA@PEADPEBDHP6APEADJ@ZK@Z 00a2 ??BUnDecorator@@QEAAPEADXZ 00e4 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 48 81 EC E0 00 00 00 49 8B D9 41 8B F8 48 8B F2 4C 8B E1 4D 85 C9 75 07 33 C0 E9 BB 00 00 00 B9 05 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 EB B9 05 00 00 00 E8 ?? ?? ?? ?? 90 48 89 1D ?? ?? ?? ?? 48 8B 84 24 10 01 00 00 48 89 05 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 25 ?? ?? ?? ?? 00 48 83 25 ?? ?? ?? ?? 00 0F B7 84 24 18 01 00 00 89 44 24 28 48 83 64 24 20 00 44 8B CF 4C 8B C6 49 8B D4 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B D8 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 74 29 48 8B 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 85 C9 74 16 48 8B 11 48 89 15 ?? ?? ?? ?? 41 FF D0 4C 8B 05 ?? ?? ?? ?? EB D7 B9 05 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 4C 8D 9C 24 E0 00 00 00 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 41 5C C3 }
	condition:
		$1
}

rule file_152_151_0 {
	meta:
		name = "__unDName$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "__unDNameEx$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 05 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_152_152_0 {
	meta:
		name = "__unDNameEx"
		size = 267
		refs = "0036 _mtinitlocknum 0044 _lock 004c heap 009e ??0UnDecorator@@QEAA@PEADPEBDHP6APEADJ@ZK@Z 00a8 ??BUnDecorator@@QEAAPEADXZ 00ea _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 48 81 EC E0 00 00 00 49 8B D9 41 8B F8 48 8B F2 4C 8B E1 4D 85 C9 75 07 33 C0 E9 C1 00 00 00 B9 05 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 EB B9 05 00 00 00 E8 ?? ?? ?? ?? 90 48 89 1D ?? ?? ?? ?? 48 8B 84 24 10 01 00 00 48 89 05 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 25 ?? ?? ?? ?? 00 48 83 25 ?? ?? ?? ?? 00 8B 84 24 20 01 00 00 89 44 24 28 48 8B 84 24 18 01 00 00 48 89 44 24 20 44 8B CF 4C 8B C6 49 8B D4 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B D8 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 74 29 48 8B 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 85 C9 74 16 48 8B 11 48 89 15 ?? ?? ?? ?? 41 FF D0 4C 8B 05 ?? ?? ?? ?? EB D7 B9 05 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 4C 8D 9C 24 E0 00 00 00 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 41 5C C3 }
	condition:
		$1
}

rule file_152_154_0 {
	meta:
		name = "?getBasicDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 1081
		refs = "001a ?gName@UnDecorator@@0PEBDEB 007f ??_C@_05KNFBNCOH@float?$AA@ 0088 ??4DName@@QEAAAEAV0@PEBD@Z 0094 ??_C@_04GOKPGOLB@long?$AA@ 009d ??_C@_03JBIPMCLC@int?$AA@ 00a6 ??_C@_05BFKKPKCG@short?$AA@ 00af ??_C@_04ENMBGAPA@char?$AA@ 0122 ??_C@_06EBGKOKIG@__int8?$AA@ 0139 ?getBasicDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 0140 ??_C@_06GCICPBLB@__w64?5?$AA@ 014c ??0DName@@QEAA@PEBD@Z 016c ??4DName@@QEAAAEAV0@W4DNameStatus@@@Z 0178 ??_C@_07ICFHOGAF@__int16?$AA@ 0190 ??_C@_07LFCOJCAC@__int64?$AA@ 0199 ??_C@_07OFLPPHGP@__int32?$AA@ 01a2 ??_C@_08GAHOLHEO@__int128?$AA@ 01da ?getECSUDataType@UnDecorator@@CA?AVDName@@XZ 01fc ??_C@_07NFANNNEC@UNKNOWN?$AA@ 0208 ??_C@_07CLGGIAMF@wchar_t?$AA@ 0214 ??_C@_09EEKGDCPH@?$DMunknown?$DO?$AA@ 0242 ??_C@_00CNPNBAHC@?$AA@ 025b ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z 0267 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 0270 ??YDName@@QEAAAEAV0@PEBD@Z 0280 ??_C@_04DDKJGDCM@bool?$AA@ 028c ??_C@_04GKJNKENE@void?$AA@ 02c5 ??_C@_05CJIMAING@long?5?$AA@ 02d5 ??_C@_06BNJCAIGJ@double?$AA@ 0332 ??_C@_09EBBEKKIH@unsigned?5?$AA@ 033b ??_C@_07EDHNAJHC@signed?5?$AA@ 0359 ??YDName@@QEAAAEAV0@AEBV0@@Z 0377 ??0DName@@QEAA@D@Z 03b3 ??_C@_05BNCCCJPP@const?$AA@ 03c8 ??_C@_09EFNPDFFP@?5volatile?$AA@ 03df ??_C@_08PABEKFH@volatile?$AA@ 03ef ??_C@_01NBENCBCI@?$CK?$AA@ 040f ??0DName@@QEAA@W4DNameStatus@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 55 56 57 48 8B EC 48 83 EC 70 48 8B F9 48 8B 0D ?? ?? ?? ?? 40 8A 31 40 84 F6 0F 84 DB 03 00 00 48 83 65 B0 00 81 65 B8 00 00 FF FF 48 FF C1 40 0F B6 C6 83 CB FF 48 89 0D ?? ?? ?? ?? C6 45 30 00 83 F8 4E 7F 65 0F 84 7C 02 00 00 83 F8 43 0F 8C 3D 02 00 00 83 F8 45 7E 48 83 F8 47 7E 3A 83 F8 49 7E 2C 83 F8 4B 7E 1E 83 F8 4D 0F 85 20 02 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? E9 5E 02 00 00 48 8D 15 ?? ?? ?? ?? EB E9 48 8D 15 ?? ?? ?? ?? EB E0 48 8D 15 ?? ?? ?? ?? EB D7 48 8D 15 ?? ?? ?? ?? EB CE 83 F8 4F 0F 84 04 02 00 00 0F 8E D8 01 00 00 83 F8 53 0F 8E C8 01 00 00 83 F8 58 0F 84 B3 01 00 00 83 F8 5F 0F 85 BD 01 00 00 0F B6 19 48 FF C1 8B C3 48 89 0D ?? ?? ?? ?? 83 FB 4D 0F 8F B4 00 00 00 83 F8 4C 0F 8D 9F 00 00 00 83 F8 47 7F 79 83 F8 46 7D 6B 85 C0 74 4A 83 F8 24 74 21 83 C0 BC 83 F8 01 0F 87 DA 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? E9 BE 01 00 00 48 8D 4D D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D C0 48 8B D8 E8 ?? ?? ?? ?? 48 8B D3 E9 BF 02 00 00 48 FF C9 BA 01 00 00 00 48 89 0D ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? E9 7D 01 00 00 48 8D 15 ?? ?? ?? ?? EB A8 83 F8 48 7C 76 83 F8 49 7E 0E 83 F8 4B 7F 6C 48 8D 15 ?? ?? ?? ?? EB 90 48 8D 15 ?? ?? ?? ?? EB 87 48 8D 15 ?? ?? ?? ?? E9 7B FF FF FF 83 F8 4E 0F 84 C9 00 00 00 83 F8 4F 74 64 83 F8 52 74 53 83 F8 57 74 42 83 C0 A8 83 F8 01 77 2E 48 FF C9 48 89 0D ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? 0F 10 00 0F 29 45 B0 48 83 7D B0 00 0F 85 02 01 00 00 F3 0F 7F 07 E9 2D 02 00 00 48 8D 15 ?? ?? ?? ?? E9 21 FF FF FF 48 8D 15 ?? ?? ?? ?? E9 15 FF FF FF 48 8D 15 ?? ?? ?? ?? E9 09 FF FF FF BB FE FF FF FF 0F 10 02 48 83 65 B0 00 81 65 B8 00 00 FF FF F3 0F 7F 45 C0 83 FB FE 0F 85 66 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 45 C0 48 8D 55 B0 48 8D 4D D0 BB 00 08 00 00 09 5D C8 E8 ?? ?? ?? ?? 85 5D D8 75 10 48 8D 15 ?? ?? ?? ?? 48 8D 4D D0 E8 ?? ?? ?? ?? 0F 10 45 D0 E9 73 FF FF FF 48 8D 15 ?? ?? ?? ?? E9 9D FE FF FF 48 8D 15 ?? ?? ?? ?? E9 EE FD FF FF 8B D8 83 E3 03 EB 4A 48 FF C9 48 89 0D ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 0F 10 00 0F 29 45 B0 48 83 7D B0 00 75 32 E9 2E FF FF FF 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? 48 8B 55 28 83 FB FF 0F 85 33 FF FF FF 8A 5D 30 40 80 FE 43 74 40 40 80 FE 45 74 31 40 80 FE 47 74 2B 40 80 FE 49 74 25 40 80 FE 4B 74 1F 40 80 FE 5F 75 50 80 FB 45 74 14 80 FB 47 74 0F 80 FB 49 74 0A 80 FB 4B 74 05 80 FB 4D 75 37 48 8D 15 ?? ?? ?? ?? EB 07 48 8D 15 ?? ?? ?? ?? 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 55 B0 48 8D 4D D0 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 0F 28 6D D0 66 0F 7F 6D B0 48 8B 5D 28 48 83 3B 00 74 2C 48 8D 4D F0 B2 20 E8 ?? ?? ?? ?? 48 8D 4D D0 48 8B D3 0F 10 00 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D B0 E8 ?? ?? ?? ?? 0F 28 45 B0 E9 4B FE FF FF 48 83 3A 00 75 41 F6 C3 01 74 27 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? F6 C3 02 74 27 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? EB 15 F6 C3 02 74 10 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 45 C0 48 8D 55 B0 48 8B CF E8 ?? ?? ?? ?? EB 21 48 8D 4D F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 55 28 0F 10 00 48 8B CF F3 0F 7F 07 E8 ?? ?? ?? ?? 48 8B C7 48 8B 9C 24 90 00 00 00 48 83 C4 70 5F 5E 5D C3 }
	condition:
		$1
}

rule file_152_155_0 {
	meta:
		name = "?getPrimaryDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 527
		refs = "001d ?gName@UnDecorator@@0PEBDEB 0050 ?getBasicDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 005c ??_C@_08PABEKFH@volatile?$AA@ 0065 ??4DName@@QEAAAEAV0@PEBD@Z 0076 ??YDName@@QEAAAEAV0@D@Z 0084 ??_C@_01HNPIGOCE@?$CG?$AA@ 00ab ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z 0119 ??_C@_0P@GCOCNKDM@std?3?3nullptr_t?$AA@ 0128 ??0DName@@QEAA@PEBD@Z 0168 ??_C@_02PPKAJPJL@?$CG?$CG?$AA@ 0189 ??_C@_00CNPNBAHC@?$AA@ 019c ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 01bf ?getPtrRefDataType@UnDecorator@@CA?AVDName@@AEBV2@H@Z 01d6 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@AEBV2@@Z 01e6 ??0DName@@QEAA@W4DNameStatus@@@Z 01f8 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 55 48 8B EC 48 83 EC 60 48 83 65 D0 00 48 8B D9 48 8B 0D ?? ?? ?? ?? 44 0F BE 01 41 B9 00 00 FF FF 48 8B FA 44 21 4D D8 45 85 C0 0F 84 A1 01 00 00 41 83 E8 24 74 73 41 83 E8 1D 74 3A 41 FF C8 74 0D 48 8B CB E8 ?? ?? ?? ?? E9 A3 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 4D D0 E8 ?? ?? ?? ?? 48 83 3F 00 74 0B 48 8D 4D D0 B2 20 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 0F 10 07 48 FF C1 4C 8D 45 E0 48 89 0D ?? ?? ?? ?? 48 8D 55 D0 48 8B CB F3 0F 7F 45 E0 0F BA 6D E8 08 E8 ?? ?? ?? ?? E9 48 01 00 00 8A 41 01 3C 24 74 1C 84 C0 0F 84 19 01 00 00 81 63 08 FF 00 FF FF 48 83 23 00 C6 43 08 02 E9 25 01 00 00 48 83 C1 02 48 89 0D ?? ?? ?? ?? 0F BE 11 85 D2 0F 84 EF 00 00 00 83 EA 41 0F 84 CF 00 00 00 FF CA 0F 84 AA 00 00 00 FF CA 74 6F 83 EA 0E 74 5E FF CA 74 32 FF CA 74 22 FF CA 75 B0 48 FF C1 48 8D 15 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? E9 CB 00 00 00 48 FF C1 48 89 0D ?? ?? ?? ?? EB 86 48 8D 15 ?? ?? ?? ?? 48 8D 4D D0 E8 ?? ?? ?? ?? 48 83 3F 00 74 0B 48 8D 4D D0 B2 20 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? E9 17 FF FF FF 44 21 4D E8 48 83 65 E0 00 83 64 24 20 00 48 FF C1 4C 8D 4D E0 4C 8D 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 8D 4D F0 48 8B D7 E8 ?? ?? ?? ?? 48 8B D0 E9 A4 FE FF FF 48 FF C1 41 B8 01 00 00 00 48 8B D7 48 89 0D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? EB 37 48 FF C1 48 8B D7 48 89 0D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? EB 20 48 8D 4D E0 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8B D7 48 8B CB 0F 10 00 F3 0F 7F 03 E8 ?? ?? ?? ?? 48 8B 7C 24 78 48 8B C3 48 8B 5C 24 70 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_152_156_0 {
	meta:
		name = "?getDataType@UnDecorator@@CA?AVDName@@PEAV2@@Z"
		size = 229
		refs = "0015 ??0DName@@QEAA@PEAV0@@Z 001c ?gName@UnDecorator@@0PEBDEB 003f ?getPrimaryDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z 005b ??_C@_04GKJNKENE@void?$AA@ 0063 ??0DName@@QEAA@PEBD@Z 006c ??_C@_05BEFAKPML@void?5?$AA@ 008c ??_C@_00CNPNBAHC@?$AA@ 00a8 ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 00c0 ??0DName@@QEAA@W4DNameStatus@@@Z 00d3 ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8B EC 48 83 EC 60 48 8B D9 48 8D 4D D0 E8 ?? ?? ?? ?? 4C 8B 1D ?? ?? ?? ?? 33 C0 41 38 03 0F 84 8B 00 00 00 41 80 3B 3F 74 4A 41 80 3B 58 74 11 48 8D 55 D0 48 8B CB E8 ?? ?? ?? ?? E9 8F 00 00 00 49 FF C3 4C 89 1D ?? ?? ?? ?? 48 39 45 D0 75 11 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? EB 6E 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? EB 49 81 65 E8 00 00 FF FF 49 FF C3 4C 8D 4D E0 4C 8D 05 ?? ?? ?? ?? 48 8D 55 D0 48 8D 4D F0 4C 89 1D ?? ?? ?? ?? 48 89 45 E0 89 44 24 20 E8 ?? ?? ?? ?? 0F 10 00 F3 0F 7F 45 D0 EB 81 48 8D 4D E0 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F 10 00 48 8D 55 D0 48 8B CB F3 0F 7F 03 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 70 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_152_157_0 {
	meta:
		name = "?getExternalDataType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 210
		refs = "0027 heap 002c ?getMemory@_HeapManager@@QEAAPEAX_KH@Z 0052 ?getDataType@UnDecorator@@CA?AVDName@@PEAV2@@Z 0077 ??_C@_00CNPNBAHC@?$AA@ 0084 ?getDataIndirectType@UnDecorator@@CA?AVDName@@AEBV2@PEBD0H@Z 0098 ??YDName@@QEAAAEAV0@D@Z 00ad ??YDName@@QEAAAEAV0@AEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 60 45 33 C0 48 8B F2 48 8B F9 41 8D 50 10 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 11 48 83 20 00 C6 40 08 00 81 60 08 FF 00 FF FF EB 02 33 DB 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 83 65 D0 00 48 83 65 E0 00 83 64 24 20 00 B8 00 00 FF FF 4C 8D 4D D0 21 45 D8 21 45 E8 4C 8D 05 ?? ?? ?? ?? 48 8D 55 E0 48 8D 4D F0 E8 ?? ?? ?? ?? 48 8D 4D E0 B2 20 0F 28 6D F0 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 48 8D 4D E0 48 8B D6 0F 28 6D E0 66 0F 7F 6D E0 E8 ?? ?? ?? ?? 4C 8D 5C 24 60 48 8B C7 0F 28 6D E0 F3 0F 7F 2B 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__C_specific_handler"
		size = 509
		refs = "00ad _pDestructExceptionObject 00bc _IsNonwritableInCurrentImage 00e2 _NLG_Notify 010c __imp_RtlUnwindEx 0111 __NLG_Return2"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 6B 18 49 89 73 20 49 89 53 10 57 41 54 41 55 41 56 41 57 48 83 EC 40 4D 8B 79 08 4D 8B 31 8B 41 04 49 8B 79 38 4D 2B F7 4D 8B E1 4C 8B EA 48 8B E9 A8 66 0F 85 ED 00 00 00 49 63 71 48 49 89 4B C8 4D 89 43 D0 48 8B C6 3B 37 0F 83 81 01 00 00 48 03 C0 48 8D 5C C7 0C 8B 43 F8 4C 3B F0 0F 82 A8 00 00 00 8B 43 FC 4C 3B F0 0F 83 9C 00 00 00 83 7B 04 00 0F 84 92 00 00 00 83 3B 01 74 19 8B 03 48 8D 4C 24 30 49 8B D5 49 03 C7 FF D0 85 C0 0F 88 89 00 00 00 7E 74 81 7D 00 63 73 6D E0 75 28 48 83 3D ?? ?? ?? ?? 00 74 1E 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0E BA 01 00 00 00 48 8B CD FF 15 ?? ?? ?? ?? 8B 4B 04 41 B8 01 00 00 00 49 8B D5 49 03 CF E8 ?? ?? ?? ?? 49 8B 44 24 40 8B 53 04 4C 63 4D 00 48 89 44 24 28 49 8B 44 24 28 49 03 D7 4C 8B C5 49 8B CD 48 89 44 24 20 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C6 48 83 C3 10 3B 37 0F 83 B7 00 00 00 E9 39 FF FF FF 33 C0 E9 B0 00 00 00 4D 8B 41 20 33 ED 45 33 ED 4D 2B C7 A8 20 74 3B 33 D2 39 17 76 35 48 8D 4F 08 8B 41 FC 4C 3B C0 72 07 8B 01 4C 3B C0 76 0C FF C2 48 83 C1 10 3B 17 73 18 EB E5 8B C2 48 03 C0 8B 4C C7 10 85 C9 75 06 8B 6C C7 0C EB 03 44 8B E9 49 63 71 48 48 8B DE 3B 37 73 55 48 FF C3 48 C1 E3 04 48 03 DF 8B 43 F4 4C 3B F0 72 39 8B 43 F8 4C 3B F0 73 31 45 85 ED 74 05 44 3B 2B 74 31 85 ED 74 05 3B 6B FC 74 28 83 3B 00 75 19 48 8B 54 24 78 8D 46 01 B1 01 41 89 44 24 48 44 8B 43 FC 4D 03 C7 41 FF D0 FF C6 48 83 C3 10 3B 37 72 B5 B8 01 00 00 00 4C 8D 5C 24 40 49 8B 5B 30 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_155_3_0 {
	meta:
		name = "?wcsncnt@@YA_KPEB_W_K@Z"
		size = 54
	strings:
		$1 = { 45 33 C9 48 8B C1 4C 8B C2 48 85 D2 74 24 66 44 39 08 74 09 48 83 C0 02 49 FF C8 75 F1 4D 85 C0 74 10 66 44 39 08 75 0A 48 2B C1 48 D1 F8 48 FF C0 C3 48 8B C2 C3 }
	condition:
		$1
}

rule file_155_4_0 {
	meta:
		name = "_wcstombs_l_helper"
		size = 914
		refs = "001d __security_cookie 0052 _errno 005d _invalid_parameter_noinfo 0072 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 015f __imp_WideCharToMultiByte 01ed __imp_GetLastError 0373 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 45 33 FF 49 8B F8 48 8B F2 4C 8B E9 41 8B DF 44 89 7D C0 48 85 C9 74 0C 4D 85 C0 75 07 33 C0 E9 1F 03 00 00 48 85 D2 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 01 03 00 00 48 8D 4D C8 49 8B D1 E8 ?? ?? ?? ?? 4D 85 ED 0F 84 43 02 00 00 4C 8B 75 C8 45 39 7E 14 75 72 48 85 FF 0F 84 C5 02 00 00 B9 FF 00 00 00 66 39 0E 77 3A 8A 06 41 88 44 1D 00 0F B7 06 48 83 C6 02 66 85 C0 74 0D 48 FF C3 48 3B DF 72 E0 E9 9B 02 00 00 44 38 7D E0 0F 84 A2 02 00 00 48 8B 4D D8 83 A1 C8 00 00 00 FD E9 92 02 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 44 38 7D E0 0F 84 76 FF FF FF 48 8B 45 D8 83 A0 C8 00 00 00 FD E9 66 FF FF FF 41 83 BE 0C 01 00 00 01 0F 85 93 00 00 00 48 85 FF 74 2C 48 8B C6 48 8B CF 66 44 39 38 74 09 48 83 C0 02 48 FF C9 75 F1 48 85 C9 74 12 66 44 39 38 75 0C 48 8B F8 48 2B FE 48 D1 FF 48 FF C7 41 8B 4E 04 48 8D 45 C0 44 8B CF 48 89 44 24 38 4C 89 7C 24 30 4C 8B C6 33 D2 89 7C 24 28 4C 89 6C 24 20 FF 15 ?? ?? ?? ?? 48 98 48 85 C0 0F 84 68 FF FF FF 44 39 7D C0 0F 85 5E FF FF FF 45 38 7C 05 FF 75 03 48 FF C8 44 38 7D E0 0F 84 DF 01 00 00 48 8B 4D D8 83 A1 C8 00 00 00 FD E9 CF 01 00 00 41 8B 4E 04 48 8D 45 C0 48 83 CB FF 48 89 44 24 38 4C 89 7C 24 30 44 8B CB 4C 8B C6 33 D2 89 7C 24 28 4C 89 6C 24 20 FF 15 ?? ?? ?? ?? 4C 63 E0 85 C0 74 11 44 39 7D C0 0F 85 72 01 00 00 49 8D 44 24 FF EB A1 44 39 7D C0 0F 85 61 01 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 52 01 00 00 48 85 FF 0F 84 93 00 00 00 41 8B 4E 04 48 8D 45 C0 41 B9 01 00 00 00 48 89 44 24 38 41 8B 86 0C 01 00 00 4C 89 7C 24 30 89 44 24 28 48 8D 45 E8 4C 8B C6 33 D2 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0A 01 00 00 44 39 7D C0 0F 85 00 01 00 00 85 C0 0F 88 F8 00 00 00 83 F8 05 0F 87 EF 00 00 00 48 63 D0 4A 8D 04 22 48 3B C7 77 2D 49 8B CF 48 85 D2 7E 18 8A 44 0D E8 43 88 44 25 00 84 C0 74 2B 48 FF C1 49 FF C4 48 3B CA 7C E8 48 83 C6 02 4C 3B E7 0F 82 6D FF FF FF 44 38 7D E0 74 1E 48 8B 45 D8 83 A0 C8 00 00 00 FD EB 11 44 38 7D E0 74 0B 48 8B 4D D8 83 A1 C8 00 00 00 FD 49 8B C4 E9 A9 00 00 00 48 8B 45 C8 44 39 78 14 75 3E 0F B7 06 49 8B D7 66 85 C0 74 1D B9 FF 00 00 00 66 3B C1 0F 87 F1 FD FF FF 48 83 C6 02 48 FF C2 0F B7 06 66 85 C0 75 E8 44 38 7D E0 74 0B 48 8B 4D D8 83 A1 C8 00 00 00 FD 48 8B C2 EB 61 48 8D 4D C0 48 83 CB FF 4C 8B C6 48 89 4C 24 38 8B 48 04 4C 89 7C 24 30 44 8B CB 33 D2 44 89 7C 24 28 4C 89 7C 24 20 FF 15 ?? ?? ?? ?? 48 98 48 85 C0 74 0E 44 39 7D C0 75 08 48 FF C8 E9 36 FE FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 44 38 7D E0 74 0B 48 8B 45 D8 83 A0 C8 00 00 00 FD 48 8B C3 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_155_7_0 {
	meta:
		name = "_wcstombs_s_l"
		size = 236
		refs = "005f _wcstombs_l_helper 0072 _errno 008c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 54 48 83 EC 20 45 33 E4 49 8B C1 49 8B F8 48 8B DA 48 8B F1 48 85 D2 74 51 4D 85 C0 74 51 48 85 D2 74 03 44 88 22 48 85 C9 74 03 4C 21 21 4C 8B 44 24 50 4C 3B C7 4C 0F 47 C7 49 81 F8 FF FF FF 7F 77 2C 4C 8B 4C 24 58 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 83 F8 FF 75 2B 48 85 DB 74 03 44 88 23 E8 ?? ?? ?? ?? 8B 00 EB 5C 4D 85 C0 74 AF E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 42 48 FF C0 48 85 DB 74 2F 48 3B C7 76 25 48 83 7C 24 50 FF 74 14 44 88 23 48 3B F8 77 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB CC 48 8B C7 41 BC 50 00 00 00 C6 44 18 FF 00 48 85 F6 74 03 48 89 06 41 8B C4 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "pow"
		size = 2993
		refs = "0032 __exp_mant_mask 0042 __pos_one 004f __sign_mask 0060 __pos_zero 008c __exp_mask 00ad __ay_max_bound 00c4 __ay_min_bound 00e3 __mask_1023 00f3 __real_mant 00fb __mask_1023_f 010f __mask_mant_all8 0116 __mask_mant9 011e __real_one 0134 __real_notsign 0149 __real_half 0159 __real_threshold 0160 __log_F_inv_head 0167 __log_F_inv_tail 019c __log_256_lead 01a4 __real_1_over_6 01ac __real_1_over_3 01c8 __real_1_over_5 01d0 __real_1_over_2 01e4 __real_1_over_4 01fc __real_log2_tail 0203 __log_256_tail 022b __real_log2_lead 0247 __real_fffffffff8000000 02ca __real_64_by_log2 02e1 __real_p65536 02ef __real_m68800 0300 __two_to_jby64_head_table 0307 __two_to_jby64_tail_table 0313 __real_log2_by_64_head 0330 __real_log2_by_64_tail 034d __real_1_by_2 0355 __real_1_by_24 035d __real_1_by_720 0385 __real_1_by_6 0391 __real_1_by_120 03a6 __denormal_threshold 03d8 __real_inf 0442 __enable_almost_inf 0486 __denormal_tiny_threshold 04c4 __real_smallest_denormal 04e3 __real_zero 054a __mask_2045 0587 __exp_shift 0591 __exp_bias 05b0 __yexp_53 05bc __mant_full 05cf __1_before_mant 05ea __neg_zero 05f7 __neg_one 067f __real_1_over_7 079e __mant_mask 0844 __neg_qnan 084b __flag_x_neg_y_notint 0850 _pow_special 08d4 __pos_inf 090a __flag_x_zero_z_inf 0926 __neg_inf 0a63 __flag_z_zero 0a72 __flag_z_inf 0ae8 __flag_x_nan 0b14 __flag_y_nan 0b36 __ind_pattern 0b7b __flag_x_nan_y_nan 0ba3 __flag_z_denormal"
	strings:
		$1 = { 48 81 EC 18 01 00 00 66 0F 7F B4 24 B0 00 00 00 66 0F 7F BC 24 C0 00 00 00 F2 0F 11 44 24 40 F2 0F 11 4C 24 50 48 8B 54 24 40 4C 8B 44 24 50 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 0F 84 31 07 00 00 4C 3B 05 ?? ?? ?? ?? 0F 84 34 07 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 0F 84 F1 04 00 00 48 3B 15 ?? ?? ?? ?? 0F 84 E4 06 00 00 48 3B 15 ?? ?? ?? ?? 0F 84 27 08 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 0F 84 B0 08 00 00 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 0F 8F A9 07 00 00 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 0F 8C F2 08 00 00 4D 33 C0 66 0F 6F D8 66 0F 73 D3 34 66 49 0F 7E C0 66 0F FB 1D ?? ?? ?? ?? 66 0F 6F D0 F3 0F E6 F3 66 0F DB 15 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 0F 84 1B 04 00 00 F2 0F 10 F8 4D 8B C8 4C 23 05 ?? ?? ?? ?? 4C 23 0D ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? 49 D1 E1 4D 03 C1 4C 89 84 24 A0 00 00 00 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 8C 24 A0 00 00 00 49 C1 E8 2C 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 66 0F 2F 3D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 0F 82 BF 04 00 00 F2 0F 5C CA F2 0F 10 E1 F2 43 0F 59 0C C1 F2 0F 10 E9 F2 42 0F 59 24 C2 F2 0F 10 FC F2 0F 58 CC F2 0F 10 D1 F2 0F 10 C1 4C 8D 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 5C EA F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 DA F2 0F 59 C8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 FD F2 0F 59 DC F2 0F 58 CB F2 0F 58 CF F2 0F 10 2D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? F2 0F 59 EE F2 43 0F 10 04 C1 F2 0F 5C E9 F2 42 0F 10 1C C2 F2 0F 58 DD F2 0F 10 CB F2 0F 5C DA F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FE F2 0F 58 C7 F2 0F 10 F8 F2 0F 58 C3 F2 0F 10 E8 66 0F 54 05 ?? ?? ?? ?? 48 8B 44 24 50 48 23 05 ?? ?? ?? ?? F2 0F 58 D3 F2 0F 5C FD F2 0F 5C CA F2 0F 58 FB F2 0F 5C E8 48 89 84 24 90 00 00 00 F2 0F 10 64 24 50 F2 0F 58 F9 F2 0F 58 FD F2 0F 10 94 24 90 00 00 00 F2 0F 5C E2 F2 0F 10 DC F2 0F 10 EF F2 0F 10 F0 F2 0F 59 DF F2 0F 59 E0 F2 0F 59 EA F2 0F 59 F2 F2 0F 10 CE F2 0F 58 DC F2 0F 58 DD F2 0F 58 CB F2 0F 10 C1 F2 0F 5C F1 F2 0F 58 F3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 60 F2 0F 59 F8 48 8B 54 24 60 66 0F 2F 3D ?? ?? ?? ?? 0F 87 15 02 00 00 66 0F 2F 3D ?? ?? ?? ?? 0F 82 E7 01 00 00 F2 0F E6 E7 4C 8D 15 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F3 0F E6 CC F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 66 0F 7E E1 48 C7 C0 3F 00 00 00 23 C1 F2 0F 5C C2 F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 D0 2B C8 C1 F9 06 F2 0F 58 D1 F2 0F 58 D6 F2 0F 10 CA F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 C2 F2 0F 59 DA F2 0F 59 E2 F2 0F 10 E9 F2 0F 59 CA F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 D9 F2 0F 59 E5 45 33 C9 3B 0D ?? ?? ?? ?? F2 0F 58 DC F2 0F 58 C3 44 0F 4E C9 48 81 C1 FF 03 00 00 48 C1 E1 34 F2 41 0F 10 2C C3 F2 41 0F 10 0C C2 F2 0F 59 E8 F2 0F 59 C8 48 3B 0D ?? ?? ?? ?? F2 41 0F 58 2C C3 F2 0F 58 CD F2 41 0F 58 0C C2 F2 0F 10 C1 74 3E 45 85 C9 48 89 4C 24 60 75 54 F2 0F 59 44 24 60 66 0F 56 44 24 70 66 0F 6F BC 24 C0 00 00 00 66 0F 6F B4 24 B0 00 00 00 48 81 C4 18 01 00 00 C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 83 C2 00 00 00 66 0F 56 05 ?? ?? ?? ?? 66 0F 56 44 24 70 EB BA 66 90 41 8B C9 45 33 DB 66 0F 2F 05 ?? ?? ?? ?? 44 0F 43 D9 44 3B 1D ?? ?? ?? ?? 75 15 F2 0F 59 44 24 60 66 0F 56 44 24 70 EB 8F 0F 1F 80 00 00 00 00 4D 33 C0 48 3B 15 ?? ?? ?? ?? 49 C7 C1 01 00 00 00 7F 2D 81 C1 32 04 00 00 49 0F 48 C8 49 D3 E1 49 8B C9 48 89 4C 24 60 F2 0F 59 44 24 60 66 0F 56 44 24 70 E9 D7 06 00 00 0F 1F 80 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 56 44 24 70 E9 BD 06 00 00 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4C 8B 1D ?? ?? ?? ?? 4C 0B 5C 24 70 E9 6F 05 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4C 8B 1D ?? ?? ?? ?? 4C 0B 5C 24 70 E9 4F 05 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 66 0F EB 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 10 EA 66 0F DB 15 ?? ?? ?? ?? 66 49 0F 7E D0 66 0F 73 D5 34 66 0F FA 2D ?? ?? ?? ?? F3 0F E6 F5 E9 AE FB FF FF 66 0F 1F 84 00 00 00 00 00 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 0F 8F E9 02 00 00 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4D 8B DA 48 8B 0D ?? ?? ?? ?? 49 D3 EA 4C 2B 15 ?? ?? ?? ?? 0F 88 75 02 00 00 48 8B 05 ?? ?? ?? ?? 48 23 C2 48 89 84 24 80 00 00 00 4C 3B 15 ?? ?? ?? ?? 49 8B CA 7F 2E 4C 8B 0D ?? ?? ?? ?? 49 D3 E9 4D 23 CB 0F 85 44 02 00 00 4C 8B 0D ?? ?? ?? ?? 49 D3 E9 4D 23 CB 74 0C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 48 3B 15 ?? ?? ?? ?? 0F 84 BC 02 00 00 48 3B 15 ?? ?? ?? ?? 0F 84 BF 01 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 0F 84 38 03 00 00 F2 0F 10 84 24 80 00 00 00 E9 A8 FA FF FF 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 C1 F2 0F 5C CA F2 0F 10 E1 F2 43 0F 10 1C C1 F2 42 0F 58 1C C2 F2 0F 59 E3 66 0F 54 25 ?? ?? ?? ?? F2 0F 10 EC F2 0F 59 E0 F2 0F 5C CC F2 0F 59 CB F2 0F 10 F9 F2 0F 58 CD F2 0F 10 D1 F2 0F 10 C1 4C 8D 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 DA F2 0F 59 CA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 C8 F2 0F 59 DC F2 0F 10 D5 F2 0F 10 C7 F2 0F 59 C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 EF F2 0F 58 E8 F2 0F 58 EF F2 0F 10 C2 F2 0F 10 FA F2 0F 59 C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 E0 F2 0F 58 D0 F2 0F 5C FA F2 0F 58 FC F2 0F 58 DF F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 CB F2 0F 59 E6 48 8D 15 ?? ?? ?? ?? F2 0F 58 CD F2 42 0F 58 24 C2 F2 0F 5C E1 F2 0F 10 DC F2 0F 10 CC F2 0F 5C DA F2 43 0F 10 04 C1 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FE F2 0F 58 C7 E9 D8 FA FF FF 90 E9 A3 FC FF FF 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 8B FC FF FF 0F 1F 00 48 33 C0 4C 8B DA 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 48 0F 44 C2 4C 8B 0D ?? ?? ?? ?? 4C 23 C8 0F 85 05 03 00 00 66 48 0F 6E C2 E9 53 FC FF FF 66 66 66 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 48 0B 54 24 70 48 33 C0 4D 8B D8 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 49 0F 44 C0 4C 8B 15 ?? ?? ?? ?? 4C 23 D0 0F 85 09 03 00 00 66 48 0F 6E C2 E9 07 FC FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 0F 84 29 01 00 00 48 3B 15 ?? ?? ?? ?? 0F 84 7C 00 00 00 F2 0F 10 44 24 40 F2 0F 10 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 AF FB FF FF 0F 1F 80 00 00 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 3B 0D ?? ?? ?? ?? 0F 84 D9 00 00 00 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 74 2D 48 3B 15 ?? ?? ?? ?? 0F 84 30 FF FF FF 4C 8B CA 4C 23 0D ?? ?? ?? ?? 4C 3B 0D ?? ?? ?? ?? 0F 8C 39 01 00 00 E9 54 01 00 00 0F 1F 40 00 4C 8B 15 ?? ?? ?? ?? 48 33 C0 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 74 5A 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 48 0F 45 05 ?? ?? ?? ?? 75 16 66 48 0F 6E C0 66 0F 56 44 24 70 E9 1E FB FF FF 66 0F 1F 44 00 00 F2 0F 10 44 24 40 F2 0F 10 4C 24 50 66 48 0F 6E D0 66 0F 56 54 24 70 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 F0 FA FF FF 0F 1F 84 00 00 00 00 00 4D 8B D8 4C 3B 05 ?? ?? ?? ?? 48 0F 44 05 ?? ?? ?? ?? 74 BC 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 0F 85 BC 01 00 00 66 48 0F 6E C0 E9 BA FA FF FF 66 90 4D 33 DB 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 0F 44 1D ?? ?? ?? ?? 48 8B C2 4C 8B 0D ?? ?? ?? ?? 4C 23 CA 4C 0F 45 D8 0F 85 34 01 00 00 48 33 C0 4D 8B C8 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 49 0F 44 C0 4C 8B 15 ?? ?? ?? ?? 4C 23 D0 4D 0F 45 D9 0F 85 55 01 00 00 66 49 0F 6E C3 66 0F 56 44 24 70 E9 4D FA FF FF 0F 1F 44 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 E9 37 FA FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4D 33 DB 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 0F 45 1D ?? ?? ?? ?? EB 29 66 0F 1F 84 00 00 00 00 00 4D 33 DB 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 0F 44 1D ?? ?? ?? ?? 66 66 66 0F 1F 84 00 00 00 00 00 48 33 C0 4D 8B C8 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 49 0F 44 C0 4C 8B 15 ?? ?? ?? ?? 4C 23 D0 4D 0F 45 D9 0F 85 B1 00 00 00 48 85 C0 75 4C 66 66 66 66 0F 1F 84 00 00 00 00 00 44 8B 0D ?? ?? ?? ?? 4C 85 1D ?? ?? ?? ?? 44 0F 45 0D ?? ?? ?? ?? F2 0F 10 44 24 40 F2 0F 10 4C 24 50 66 49 0F 6E D3 E8 ?? ?? ?? ?? E9 77 F9 FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 66 49 0F 6E C3 E9 5E F9 FF FF 66 0F 1F 44 00 00 48 33 C0 4C 8B 15 ?? ?? ?? ?? 4D 23 D0 4C 3B 15 ?? ?? ?? ?? 49 0F 44 C0 4C 8B 15 ?? ?? ?? ?? 4C 23 D0 75 5C F2 0F 10 44 24 40 F2 0F 10 4C 24 50 66 49 0F 6E D3 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 12 F9 FF FF 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 44 24 40 F2 0F 10 4C 24 50 66 49 0F 6E D3 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 E6 F8 FF FF 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4D 8B C8 4C 3B 1D ?? ?? ?? ?? 4D 0F 44 D9 74 27 4C 3B 0D ?? ?? ?? ?? 4D 0F 44 CB 4D 8B D1 4C 23 15 ?? ?? ?? ?? 4D 0F 45 CB 4D 8B D3 4C 23 15 ?? ?? ?? ?? 4D 0F 45 D9 F2 0F 10 44 24 40 F2 0F 10 4C 24 50 66 49 0F 6E D3 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 7F F8 FF FF 0F 1F 80 00 00 00 00 F2 0F 10 D0 F2 0F 10 44 24 40 F2 0F 10 4C 24 50 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 57 F8 FF FF }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_wgetpath"
		size = 228
		refs = "0039 _errno"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 48 8B D9 4C 8B E2 66 B9 3B 00 EB 04 48 83 C3 02 66 39 0B 74 F7 33 FF 49 FF C8 48 8B EB 75 0C E8 ?? ?? ?? ?? 8D 77 22 89 30 EB 76 0F B7 03 66 85 C0 74 69 BE 22 00 00 00 66 3B C1 74 5B 48 83 C3 02 66 3B C6 74 18 66 41 89 04 24 49 83 C4 02 49 FF C8 75 3A 48 8B EB E8 ?? ?? ?? ?? EB C9 0F B7 03 66 85 C0 74 36 66 3B C6 74 1A 66 41 89 04 24 48 83 C3 02 49 83 C4 02 49 FF C8 74 D7 0F B7 03 66 85 C0 75 E1 66 39 3B 74 12 48 83 C3 02 0F B7 03 66 85 C0 74 06 EB A0 48 83 C3 02 66 39 0B 74 F7 48 8B 74 24 40 48 3B EB 48 8B 6C 24 38 66 41 89 3C 24 48 0F 45 FB 48 8B 5C 24 30 48 8B C7 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "__getlocaleinfo"
		size = 475
		refs = "0015 __security_cookie 0059 __crtGetLocaleInfoA 0066 __imp_GetLastError 0092 _calloc_crt 00e3 free 00f6 __security_check_cookie 011a strncpy_s 0143 _invoke_watson 0162 __imp_GetLocaleInfoW"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 48 81 EC D0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 00 00 00 48 8B 9C 24 30 01 00 00 41 8B F1 45 8B E0 4C 8B F1 83 FA 01 0F 85 0A 01 00 00 4C 8D 4C 24 40 44 8B C6 41 8B D4 48 8D 7C 24 40 33 ED C7 44 24 20 80 00 00 00 E8 ?? ?? ?? ?? 44 8B E8 85 C0 75 5C FF 15 ?? ?? ?? ?? 83 F8 7A 75 78 21 6C 24 20 45 33 C9 44 8B C6 41 8B D4 49 8B CE E8 ?? ?? ?? ?? 4C 63 E8 85 C0 74 5C 8D 55 01 49 8B CD E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 49 4C 8B C8 44 8B C6 41 8B D4 49 8B CE BD 01 00 00 00 44 89 6C 24 20 E8 ?? ?? ?? ?? 44 8B E8 85 C0 74 1F 49 63 F5 BA 01 00 00 00 48 8B CE E8 ?? ?? ?? ?? 48 8B C8 48 89 03 48 85 C0 75 31 85 ED 74 08 48 8B CF E8 ?? ?? ?? ?? 83 C8 FF 48 8B 8C 24 C0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 D0 00 00 00 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 41 8D 45 FF 4C 8B C7 48 8B D6 4C 63 C8 E8 ?? ?? ?? ?? 85 C0 75 10 85 ED 74 08 48 8B CF E8 ?? ?? ?? ?? 33 C0 EB B8 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC BD 02 00 00 00 3B D5 75 54 48 83 23 00 45 33 C9 45 33 C0 8B D6 41 8B CC FF 15 ?? ?? ?? ?? 48 63 F8 85 C0 74 27 48 8B CF 8B D5 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 15 44 8B CF 4C 8B C0 8B D6 41 8B CC FF 15 ?? ?? ?? ?? 85 C0 75 9A 48 8B 0B E8 ?? ?? ?? ?? 48 83 23 00 E9 42 FF FF FF 85 D2 0F 85 3A FF FF FF 21 54 24 30 0F BA EE 1D 4C 8D 44 24 30 8B D6 44 8B CD 41 8B CC FF 15 ?? ?? ?? ?? 85 C0 0F 84 17 FF FF FF 8A 44 24 30 88 03 E9 53 FF FF FF }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "strcpy_s"
		size = 97
		refs = "0019 _errno 0025 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C0 75 1C 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 4C 8B C9 4D 2B C8 41 8A 00 43 88 04 01 49 FF C0 84 C0 74 05 48 FF CA 75 ED 48 85 D2 75 0E 88 11 E8 ?? ?? ?? ?? BB 22 00 00 00 EB C5 33 C0 EB CA }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "fprintf"
		size = 302
		refs = "002e _errno 0039 _invalid_parameter_noinfo 0057 _lock_file 006a _fileno 0085 __pioinfo 0097 __badioinfo 00f4 _stbuf 0109 _output_l 0115 _ftbuf 011e _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 50 10 48 89 48 08 4C 89 40 18 4C 89 48 20 53 56 57 41 54 48 83 EC 28 48 8B F9 33 F6 33 C0 48 85 C9 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 DF 00 00 00 33 C0 48 85 D2 0F 95 C0 85 C0 74 DC 4C 8D 64 24 60 E8 ?? ?? ?? ?? 90 F6 47 18 40 0F 85 86 00 00 00 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 2A 83 F8 FE 74 25 48 63 D0 48 8B CA 48 C1 F9 05 4C 8D 05 ?? ?? ?? ?? 83 E2 1F 48 6B D2 58 49 03 14 C8 48 8D 0D ?? ?? ?? ?? EB 11 48 8D 0D ?? ?? ?? ?? 48 8B D1 4C 8D 05 ?? ?? ?? ?? F6 42 38 7F 75 25 83 F8 FF 74 1A 83 F8 FE 74 15 48 63 C8 48 8B C1 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C0 F6 41 38 80 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CE FF 85 F6 75 2A 48 8B CF E8 ?? ?? ?? ?? 8B D8 4D 8B CC 45 33 C0 48 8B 54 24 58 48 8B CF E8 ?? ?? ?? ?? 8B F0 48 8B D7 8B CB E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B C6 48 83 C4 28 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_161_2_0 {
	meta:
		name = "_fprintf_l"
		size = 29
		refs = "0014 _vfprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_520_1_0 {
	meta:
		name = "__swprintf_l"
		size = 29
		refs = "0014 __vswprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_161_5_0 {
	meta:
		name = "_fprintf_p_l"
		size = 29
		refs = "0014 _vfprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_161_3_0 {
	meta:
		name = "_fprintf_s_l"
		size = 29
		refs = "0014 _vfprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_166_2_0 {
	meta:
		name = "_fwprintf_l"
		size = 29
		refs = "0014 _vfwprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_166_5_0 {
	meta:
		name = "_fwprintf_p_l"
		size = 29
		refs = "0014 _vfwprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_166_3_0 {
	meta:
		name = "_fwprintf_s_l"
		size = 29
		refs = "0014 _vfwprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_227_1_0 {
	meta:
		name = "_sprintf_l"
		size = 29
		refs = "0014 _vsprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_161_4_0 {
	meta:
		name = "fprintf_s"
		size = 36
		refs = "001b _vfprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_161_6_0 {
	meta:
		name = "_fprintf_p"
		size = 36
		refs = "001b _vfprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_166_6_0 {
	meta:
		name = "_fwprintf_p"
		size = 36
		refs = "001b _vfwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_166_4_0 {
	meta:
		name = "fwprintf_s"
		size = 36
		refs = "001b _vfwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_164_3_0 {
	meta:
		name = "_wpopen"
		size = 1804
		refs = "001e __security_cookie 0056 _errno 0061 _invalid_parameter_noinfo 00f4 _pipe 0134 _mtinitlocknum 0141 _close 0159 _lock 016a __imp_GetCurrentProcess 0180 __pioinfo 01b1 __imp_DuplicateHandle 01db _wfdopen 01f8 __idpairs 020d __idtabsiz 025d _recalloc_crt 029e ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 02aa _wdupenv_s 02c7 _invoke_watson 02dc ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 02f3 memset 0351 wcslen 0366 ??_C@_19FNCMDGGJ@?$AA?5?$AA?1?$AAc?$AA?5?$AA?$AA@ 037b _calloc_crt 0395 wcscpy_s 03b1 wcscat_s 03ed _waccess_s 0432 __imp_CreateProcessW 045b free 0480 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 04d1 _wgetpath 050a ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0617 __imp_CloseHandle 0691 fclose 06d8 _unlock 06eb __security_check_cookie"
	strings:
		$1 = { 4C 8B DC 49 89 5B 18 49 89 73 20 57 41 54 41 55 41 56 41 57 48 81 EC 40 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 38 01 00 00 48 89 4C 24 60 33 DB 44 8B FB 48 89 5C 24 78 41 89 5B C8 66 41 89 5B CC 89 5C 24 54 8B C3 48 85 C9 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 73 06 00 00 8B C3 48 85 D2 0F 95 C0 85 C0 74 DD 66 B9 20 00 BE 02 00 00 00 66 39 0A 75 05 48 03 D6 EB F6 0F B7 02 66 83 F8 77 74 06 66 83 F8 72 75 BB 66 89 84 24 30 01 00 00 48 03 D6 66 39 0A 74 F8 0F B7 02 66 85 C0 74 0C 66 83 F8 74 74 06 66 83 F8 62 75 97 66 89 84 24 32 01 00 00 66 83 F8 74 75 08 41 B8 00 40 00 00 EB 10 44 8B C3 B9 00 80 00 00 66 83 F8 62 44 0F 44 C1 41 0F BA E8 07 BA 00 04 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 DB 05 00 00 41 BC 01 00 00 00 66 83 BC 24 30 01 00 00 77 75 0B 44 8B EB 44 8B F3 41 8B FC EB 08 45 8B EC 45 8B F4 8B FB 89 7C 24 70 44 89 74 24 50 B9 09 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 17 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 5C E8 ?? ?? ?? ?? E9 12 FF FF FF B9 09 00 00 00 E8 ?? ?? ?? ?? 90 44 89 64 24 6C 44 89 64 24 68 FF 15 ?? ?? ?? ?? 49 63 DE 48 63 4C 9C 58 48 8B D1 48 C1 FA 05 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 49 8B 14 D0 89 74 24 30 44 89 64 24 28 83 64 24 20 00 4C 8D 8C 24 80 00 00 00 4C 8B C0 48 8B 14 0A 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EE 04 00 00 8B 4C 9C 58 E8 ?? ?? ?? ?? 83 64 9C 68 00 48 63 C7 48 8D 94 24 30 01 00 00 8B 4C 84 58 E8 ?? ?? ?? ?? 4C 8B F8 48 89 84 24 A0 00 00 00 33 DB 48 85 C0 0F 84 B8 04 00 00 4C 8B 0D ?? ?? ?? ?? 49 8B F9 4C 89 8C 24 90 00 00 00 44 8D 43 10 8B 15 ?? ?? ?? ?? 48 8B CA 48 C1 E1 04 49 03 C9 48 3B F9 73 12 48 39 1F 74 0D 49 03 F8 48 89 BC 24 90 00 00 00 EB DF 48 8B C2 48 C1 E0 04 49 03 C1 48 3B F8 72 51 8D 42 01 3B C2 72 47 8B D0 48 B8 FF FF FF FF FF FF FF 0F 48 3B D0 73 36 49 8B C9 E8 ?? ?? ?? ?? 48 85 C0 74 29 48 89 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B F9 48 C1 E7 04 48 03 F8 48 89 BC 24 90 00 00 00 41 03 CC 89 0D ?? ?? ?? ?? EB 03 48 8B FB 48 85 FF 0F 84 F2 03 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 78 E8 ?? ?? ?? ?? 85 C0 74 1D 83 F8 16 75 14 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 C0 75 0A 4C 8B 74 24 78 4D 85 F6 75 07 4C 8D 35 ?? ?? ?? ?? BB 68 00 00 00 44 8B C3 33 D2 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 89 9C 24 C0 00 00 00 C7 84 24 FC 00 00 00 00 01 00 00 48 8B 84 24 80 00 00 00 48 8B 0D ?? ?? ?? ?? 45 85 ED 48 8B D0 74 03 48 8B 11 48 89 94 24 10 01 00 00 45 3B EC 74 04 48 8B 41 58 48 89 84 24 18 01 00 00 48 8B 81 B0 00 00 00 48 89 84 24 20 01 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B D8 49 8B CE E8 ?? ?? ?? ?? 48 03 D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 5C 18 01 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 4C 8B E8 48 85 C0 0F 84 FB 02 00 00 4D 8B C6 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 D1 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D3 49 8B CD E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 A3 02 00 00 4C 8B 44 24 60 48 8B D3 49 8B CD E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 77 02 00 00 E8 ?? ?? ?? ?? 8B 18 89 9C 24 88 00 00 00 33 D2 49 8B CE E8 ?? ?? ?? ?? 33 C9 85 C0 75 47 48 8D 84 24 A8 00 00 00 48 89 44 24 48 48 8D 84 24 C0 00 00 00 48 89 44 24 40 48 89 4C 24 38 48 89 4C 24 30 89 4C 24 28 44 89 64 24 20 45 33 C9 45 33 C0 49 8B D5 49 8B CE FF 15 ?? ?? ?? ?? 44 8B E0 E9 BD 01 00 00 48 89 4C 24 60 48 8B D6 B9 04 01 00 00 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 25 33 C9 E8 ?? ?? ?? ?? 49 8B CD E8 ?? ?? ?? ?? 48 8B 4C 24 78 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 E9 09 02 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 33 C9 85 C0 74 2A 83 F8 16 75 12 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 85 C0 74 0F 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B CE EB 9A 48 8B 4C 24 60 33 DB 41 B8 03 01 00 00 48 8B D6 E8 ?? ?? ?? ?? 48 89 84 24 98 00 00 00 48 85 C0 0F 84 F7 00 00 00 66 39 1E 0F 84 EE 00 00 00 48 8B CE E8 ?? ?? ?? ?? 66 83 7C 46 FE 5C 74 34 66 83 7C 46 FE 2F 74 2C 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 14 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 49 8B CE E8 ?? ?? ?? ?? 48 8B D8 48 8B CE E8 ?? ?? ?? ?? 48 03 D8 B8 04 01 00 00 48 3B D8 0F 83 86 00 00 00 4D 8B C6 8B D0 48 8B CE E8 ?? ?? ?? ?? 33 DB 85 C0 75 5F 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 44 48 8D 84 24 A8 00 00 00 48 89 44 24 48 48 8D 84 24 C0 00 00 00 48 89 44 24 40 48 89 5C 24 38 48 89 5C 24 30 89 5C 24 28 44 89 64 24 20 45 33 C9 45 33 C0 49 8B D5 48 8B CE FF 15 ?? ?? ?? ?? 44 8B E0 EB 26 48 8B 8C 24 98 00 00 00 E9 FE FE FF FF 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 44 8B 64 24 54 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 8B 9C 24 88 00 00 00 49 8B CD E8 ?? ?? ?? ?? 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 48 8B 8C 24 B0 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 33 DB 45 85 E4 74 14 48 8B 84 24 A8 00 00 00 48 89 47 08 4C 89 3F E9 87 00 00 00 48 89 1F EB 38 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 33 DB 44 8B 74 24 50 49 8B CF E8 ?? ?? ?? ?? 48 63 7C 24 70 89 5C BC 68 4C 8B FB 48 89 9C 24 A0 00 00 00 EB 02 33 DB 49 63 C6 39 5C 84 68 74 09 8B 4C 84 58 E8 ?? ?? ?? ?? 48 63 C7 39 5C 84 68 74 0A 8B 4C 84 58 E8 ?? ?? ?? ?? 90 B9 09 00 00 00 E8 ?? ?? ?? ?? 49 8B C7 48 8B 8C 24 38 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 40 01 00 00 49 8B 5B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_165_3_0 {
	meta:
		name = "_validate_param_reuseA"
		size = 346
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 44 8A 59 10 41 8B D9 8B FA 4C 8B C9 41 80 FB 70 0F 84 22 01 00 00 41 80 F8 70 0F 84 18 01 00 00 45 33 D2 BA 01 00 00 00 41 80 FB 73 74 09 41 8B CA 41 80 FB 53 75 02 8B CA 41 80 F8 73 74 09 41 8B C2 41 80 F8 53 75 02 8B C2 85 C9 0F 85 C0 00 00 00 85 C0 0F 85 D7 00 00 00 B1 69 41 80 FB 64 74 66 44 3A D9 74 3B 41 80 FB 6F 74 35 41 80 FB 75 74 2F 41 80 FB 78 74 29 41 80 FB 58 74 23 41 80 F8 64 74 1D 44 3A C1 74 18 41 80 F8 6F 74 12 41 80 F8 75 74 0C 41 80 F8 78 74 06 41 80 F8 58 75 6B 41 80 FB 64 74 20 44 3A D9 74 1B 41 80 FB 6F 74 15 41 80 FB 75 74 0F 41 80 FB 78 74 09 41 8B C2 41 80 FB 58 75 02 8B C2 41 80 F8 64 74 20 44 3A C1 74 1B 41 80 F8 6F 74 15 41 80 F8 75 74 0F 41 80 F8 78 74 09 41 80 F8 58 74 03 41 8B D2 3B C2 74 04 33 C0 EB 4D 41 8B 49 14 8B C1 33 C3 0F BA E0 10 72 EE 33 CB F6 C1 20 75 E7 41 39 39 EB 2C 3B C8 75 1B B8 10 08 00 00 41 8B CA 41 85 41 14 0F 95 C1 85 D8 41 8B C2 0F 95 C0 3B C8 74 03 41 8B D2 8B C2 EB 0D 45 33 D2 45 3A D8 41 0F 94 C2 41 8B C2 48 8B 5C 24 08 48 8B 7C 24 10 C3 }
	condition:
		$1
}

rule file_165_4_0 {
	meta:
		name = "write_char"
		size = 70
		refs = "0031 _flsbuf"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 42 18 40 49 8B D8 74 0C 48 83 7A 10 00 75 05 41 FF 00 EB 25 FF 4A 08 78 0D 48 8B 02 88 08 48 FF 02 0F B6 C1 EB 08 0F BE C9 E8 ?? ?? ?? ?? 83 F8 FF 75 04 09 03 EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_165_5_0 {
	meta:
		name = "write_multi_char"
		size = 81
		refs = "002f write_char"
	strings:
		$1 = { 85 D2 7E 4C 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F9 49 8B F0 8B DA 40 8A E9 4C 8B C7 48 8B D6 40 8A CD FF CB E8 ?? ?? ?? ?? 83 3F FF 74 04 85 DB 7F E7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_165_6_0 {
	meta:
		name = "write_string"
		size = 167
		refs = "0025 _errno 0053 write_char"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 49 8B D9 49 8B F0 8B FA 48 8B E9 E8 ?? ?? ?? ?? F6 46 18 40 44 8B 20 74 0B 48 83 7E 10 00 75 04 01 3B EB 4F E8 ?? ?? ?? ?? 83 20 00 EB 2F 8A 4D 00 4C 8B C3 48 8B D6 FF CF E8 ?? ?? ?? ?? 48 FF C5 83 3B FF 75 17 E8 ?? ?? ?? ?? 83 38 2A 75 11 4C 8B C3 48 8B D6 B1 3F E8 ?? ?? ?? ?? 85 FF 7F CD E8 ?? ?? ?? ?? 83 38 00 75 08 E8 ?? ?? ?? ?? 44 89 20 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C C3 }
	condition:
		$1
}

rule file_165_11_0 {
	meta:
		name = "_output_p_l"
		size = 4373
		refs = "0022 __security_cookie 005d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0072 _errno 007d _invalid_parameter_noinfo 00aa _fileno 00b1 __badioinfo 00c5 __ImageBase 00dc __pioinfo 01d2 __lookuptable_s 022a strtol 0254 memset 045b _validate_param_reuseA 0494 __nullstring 049c strlen 054a wctomb_s 06ab __wnullstring 077b _get_printf_count_output 0a85 _malloc_crt 0ada _cfltcvt_tab 0ae7 __imp_DecodePointer 0bce write_multi_char 0be2 write_string 0cac free 0fa6 _isleadbyte_l 0fbb write_char 10f6 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 A0 F4 FF FF 48 81 EC 60 0C 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 58 0B 00 00 33 FF 48 8B D9 48 89 4D C0 4C 8B E2 48 89 55 E8 48 8D 4C 24 60 49 8B D0 4D 8B F1 89 7D B0 44 8B EF 89 7C 24 50 89 7C 24 44 89 7D 90 E8 ?? ?? ?? ?? 41 83 CF FF 41 8B F7 48 89 7D A8 48 85 DB 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7C 24 78 74 0C 48 8B 4C 24 70 83 A1 C8 00 00 00 FD 41 8B C7 E9 4F 10 00 00 F6 43 18 40 0F 85 A2 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 41 3B C7 74 28 83 F8 FE 74 23 4C 63 C0 4C 8D 0D ?? ?? ?? ?? 49 8B C8 41 83 E0 1F 48 C1 F9 05 4D 6B C0 58 4D 03 84 C9 ?? ?? ?? ?? EB 0A 4C 8B C2 4C 8D 0D ?? ?? ?? ?? 41 F6 40 38 7F 75 29 41 3B C7 74 1E 83 F8 FE 74 19 48 63 D0 48 8B C2 83 E2 1F 48 C1 F8 05 48 6B D2 58 49 03 94 C1 ?? ?? ?? ?? F6 42 38 80 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7C 24 78 0F 84 5D FF FF FF 48 8B 44 24 70 83 A0 C8 00 00 00 FD E9 4C FF FF FF 4D 85 E4 74 CF 48 8B 5D E8 8B C7 44 8B DF 89 44 24 4C 89 7D B8 41 83 FB 01 75 08 85 F6 0F 84 6D 0F 00 00 83 CE FF 89 7C 24 54 4D 8B CC 45 8A 24 24 4D 63 C3 8B D7 48 89 7D D8 45 8B D7 44 89 7C 24 40 89 7D 80 89 7C 24 48 44 89 7D C8 89 75 A0 4C 89 45 98 45 84 E4 0F 84 D4 0E 00 00 41 BB 01 00 00 00 4D 03 CB 4C 89 4D 88 85 C0 0F 88 5B 0E 00 00 41 8D 44 24 E0 3C 58 77 1B 48 8D 0D ?? ?? ?? ?? 49 0F BE C4 0F B6 8C 08 ?? ?? ?? ?? 83 E1 0F 45 33 D2 EB 06 45 33 D2 41 8B CA 48 63 C1 48 8D 0C C0 48 63 C2 48 03 C8 48 8D 05 ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? C1 E8 04 89 45 B4 41 3B C3 0F 85 D5 00 00 00 41 80 39 25 0F 84 D4 00 00 00 83 FE FF 75 59 44 8D 46 0B 48 8D 55 A8 49 8B C9 E8 ?? ?? ?? ?? 45 33 D2 85 C0 7E 2D 48 8B 45 A8 80 38 24 75 24 4C 39 55 98 75 14 48 8D 8D F0 01 00 00 33 D2 41 B8 60 09 00 00 E8 ?? ?? ?? ?? BE 01 00 00 00 89 75 A0 EB 1A 4C 8B 45 98 4C 8B 4D 88 41 8B F2 44 89 55 A0 41 BB 01 00 00 00 41 3B F3 75 71 48 8B 4D 88 48 8D 55 A8 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D A8 4C 8B 45 98 44 8B F8 41 BB 01 00 00 00 4C 8D 49 01 45 2B FB 45 33 D2 4C 89 4D 88 44 89 7D C8 4D 85 C0 75 36 45 85 FF 0F 88 D9 0D 00 00 80 39 24 0F 85 D0 0D 00 00 41 83 FF 64 0F 8D C6 0D 00 00 8B 44 24 40 44 3B F8 41 0F 4F C7 89 44 24 40 EB 09 83 F8 08 0F 84 AC 0D 00 00 8B 4D B4 85 C9 0F 84 8C 0C 00 00 FF C9 0F 84 62 0C 00 00 FF C9 0F 84 06 0C 00 00 FF C9 0F 84 14 0B 00 00 FF C9 0F 84 FF 0A 00 00 FF C9 0F 84 53 0A 00 00 FF C9 0F 84 95 09 00 00 FF C9 0F 85 C4 0C 00 00 41 0F BE C4 83 F8 64 0F 8F CC 02 00 00 0F 84 66 04 00 00 83 F8 41 0F 84 62 02 00 00 83 F8 43 0F 84 7C 01 00 00 83 F8 45 0F 84 50 02 00 00 83 F8 47 0F 84 47 02 00 00 83 F8 53 0F 84 32 01 00 00 83 F8 58 0F 84 8B 03 00 00 83 F8 5A 74 53 83 F8 61 0F 84 2F 02 00 00 83 F8 63 0F 84 4F 01 00 00 45 33 E4 8B 44 24 44 83 7D A0 01 75 0D 4C 8B 45 98 4D 85 C0 0F 84 42 0C 00 00 85 C0 0F 85 F0 08 00 00 41 F6 C5 40 0F 84 EA 07 00 00 41 0F BA E5 08 0F 83 BC 07 00 00 C6 44 24 58 2D E9 BD 07 00 00 85 F6 75 09 49 8B 06 49 83 C6 08 EB 25 41 83 FF 63 0F 87 B1 0C 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 0F 84 7E 02 00 00 48 8B 84 CD F8 01 00 00 48 8B 00 48 85 C0 0F 84 85 00 00 00 48 8B 58 08 48 85 DB 74 7C 0F BF 00 41 0F BA E5 0B 73 65 99 44 89 5D 90 2B C2 D1 F8 89 44 24 54 E9 5F FF FF FF C7 00 03 00 00 00 44 88 A4 CD 00 02 00 00 44 89 AC CD 04 02 00 00 E9 44 FF FF FF BA 03 00 00 00 45 8B CD 45 8A C4 48 8B C8 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 85 29 FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 64 24 78 E9 2A 0C 00 00 44 89 55 90 89 44 24 54 E9 FF FE FF FF 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? EB E6 41 F7 C5 30 08 00 00 75 05 41 0F BA ED 0B 83 FF FF 8B D7 B8 FF FF FF 7F 0F 44 D0 85 F6 0F 85 9B 01 00 00 49 8B 1E 49 83 C6 08 E9 C6 01 00 00 41 F7 C5 30 08 00 00 75 05 41 0F BA ED 0B 41 F7 C5 10 08 00 00 74 77 85 F6 75 0A 45 0F B7 0E 49 83 C6 08 EB 44 41 83 FF 63 0F 87 99 0B 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 75 22 48 8D 84 CD F0 01 00 00 44 39 10 75 0B C7 00 02 00 00 00 E9 13 FF FF FF BA 02 00 00 00 E9 23 FF FF FF 48 8B 84 CD F8 01 00 00 44 0F B7 08 48 8D 55 F0 48 8D 4C 24 54 41 B8 00 02 00 00 E8 ?? ?? ?? ?? 45 33 E4 85 C0 74 48 C7 44 24 44 01 00 00 00 EB 3E 85 F6 75 0A 41 0F B7 06 49 83 C6 08 EB 25 41 83 FF 63 0F 87 22 0B 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 0F 84 09 03 00 00 48 8B 84 CD F8 01 00 00 0F B7 00 88 45 F0 44 89 5C 24 54 45 33 E4 48 8D 5D F0 E9 ED FD FF FF 44 89 18 E9 89 FE FF FF 44 89 5D CC 41 80 C4 20 41 83 CD 40 41 3B F3 0F 85 7F 04 00 00 4D 85 C0 0F 85 76 04 00 00 41 83 FF 63 0F 87 C3 0A 00 00 49 63 C7 48 8D 0C 40 48 8D 84 CD F0 01 00 00 44 39 10 0F 85 2D 04 00 00 C7 00 08 00 00 00 44 88 A4 CD 00 02 00 00 44 89 AC CD 04 02 00 00 E9 EB 09 00 00 83 F8 65 0F 8C 7E FD FF FF 83 F8 67 7E 9F 83 F8 69 0F 84 89 01 00 00 83 F8 6E 0F 84 1F 01 00 00 83 F8 6F 0F 84 01 01 00 00 83 F8 70 0F 84 BB 00 00 00 83 F8 73 0F 84 6C FE FF FF 83 F8 75 0F 84 60 01 00 00 83 F8 78 0F 85 3A FD FF FF B8 27 00 00 00 E9 A9 00 00 00 41 83 FF 63 0F 87 2F 0A 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 75 16 48 8D 84 CD F0 01 00 00 44 39 10 0F 84 AA FD FF FF E9 C0 FD FF FF 48 8B 9C CD F8 01 00 00 48 8B 1B 41 F7 C5 10 08 00 00 74 30 48 85 DB 44 89 5D 90 48 0F 44 1D ?? ?? ?? ?? 48 8B C3 EB 0D 41 2B D3 66 44 39 10 74 08 48 83 C0 02 85 D2 75 EF 48 2B C3 48 D1 F8 E9 B8 FD FF FF 48 85 DB 48 0F 44 1D ?? ?? ?? ?? 48 8B C3 EB 0B 41 2B D3 44 38 10 74 07 49 03 C3 85 D2 75 F1 2B C3 E9 92 FD FF FF BF 10 00 00 00 41 0F BA ED 0F 89 7C 24 48 B8 07 00 00 00 89 45 B0 41 B9 10 00 00 00 45 84 ED 0F 89 98 00 00 00 41 8D 51 F2 04 51 C6 44 24 58 30 89 54 24 50 88 44 24 59 E9 84 00 00 00 41 B9 08 00 00 00 45 84 ED 79 75 B8 00 02 00 00 44 0B E8 EB 6B 85 F6 75 09 49 8B 3E 49 83 C6 08 EB 25 41 83 FF 63 0F 87 3A 09 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 0F 84 07 FF FF FF 48 8B 84 CD F8 01 00 00 48 8B 38 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 E0 FC FF FF 8B 44 24 4C 41 F6 C5 20 74 05 66 89 07 EB 02 89 07 B8 01 00 00 00 89 44 24 44 E9 EE FB FF FF 41 83 CD 40 41 B9 0A 00 00 00 8B 54 24 50 41 0F BA E5 0F 73 48 85 F6 75 0C 4D 8B 06 49 83 C6 08 E9 8D 01 00 00 41 83 FF 63 0F 87 C1 08 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 75 65 48 8D 84 CD F0 01 00 00 44 39 10 75 0B C7 00 04 00 00 00 E9 3B FC FF FF BA 04 00 00 00 E9 4B FC FF FF 41 0F BA E5 0C 73 4C 85 F6 74 B1 41 83 FF 63 0F 87 7E 08 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 75 22 48 8D 84 CD F0 01 00 00 44 39 10 75 0B C7 00 05 00 00 00 E9 F8 FB FF FF BA 05 00 00 00 E9 08 FC FF FF 48 8B 84 CD F8 01 00 00 4C 8B 00 E9 02 01 00 00 41 F6 C5 20 0F 84 8C 00 00 00 41 F6 C5 40 74 51 85 F6 75 0D 4D 0F BF 06 49 83 C6 08 E9 E1 00 00 00 41 83 FF 63 0F 87 15 08 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 75 19 48 8D 84 CD F0 01 00 00 44 39 10 0F 84 05 FD FF FF 41 8B D3 E9 A8 FB FF FF 48 8B 84 CD F8 01 00 00 4C 0F BF 00 E9 A1 00 00 00 85 F6 75 0D 45 0F B7 06 49 83 C6 08 E9 90 00 00 00 41 83 FF 63 0F 87 C4 07 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 74 AF 48 8B 84 CD F8 01 00 00 44 0F B7 00 EB 6C 41 F6 C5 40 74 34 85 F6 75 09 4D 63 06 49 83 C6 08 EB 59 41 83 FF 63 0F 87 8D 07 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 0F 84 74 FF FF FF 48 8B 84 CD F8 01 00 00 4C 63 00 EB 32 85 F6 75 09 45 8B 06 49 83 C6 08 EB 25 41 83 FF 63 0F 87 59 07 00 00 49 63 C7 48 8D 0C 40 4D 85 C0 0F 84 40 FF FF FF 48 8B 84 CD F8 01 00 00 44 8B 00 41 F6 C5 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA ED 08 41 0F BA E5 0F 72 0A 41 0F BA E5 0C 72 03 45 8B C0 BE 00 02 00 00 85 FF 79 05 41 8B FB EB 09 41 83 E5 F7 3B FE 0F 4F FE 44 8B 7D B0 49 8B C0 48 8D 9D EF 01 00 00 48 F7 D8 1B C9 23 CA 89 4C 24 50 8B CF 41 2B FB 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C7 88 03 49 2B DB EB D2 44 8B 7D C8 48 8D 85 EF 01 00 00 89 7C 24 48 2B C3 49 03 DB 89 44 24 54 44 85 EE 0F 84 92 F9 FF FF 85 C0 74 09 80 3B 30 0F 84 85 F9 FF FF 49 2B DB 44 01 5C 24 54 C6 03 30 E9 75 F9 FF FF 45 8B CD 45 8A C4 BA 08 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 31 FA FF FF 4C 8B 45 98 E9 AE 05 00 00 B8 00 02 00 00 48 8D 5D F0 8B F0 85 FF 79 0A C7 44 24 48 06 00 00 00 EB 49 75 0D 41 80 FC 67 75 41 44 89 5C 24 48 EB 3A 3B F8 0F 4F F8 89 7C 24 48 81 FF A3 00 00 00 7E 29 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 45 33 D2 48 89 45 D8 48 85 C0 74 07 48 8B D8 8B F7 EB 08 C7 44 24 48 A3 00 00 00 44 39 55 A0 75 0D 49 8B 06 49 83 C6 08 48 89 45 E0 EB 20 41 83 FF 63 0F 87 D8 05 00 00 49 63 C7 48 8D 0C 40 48 8B 84 CD F8 01 00 00 48 8B 08 48 89 4D E0 48 8B 0D ?? ?? ?? ?? 41 0F BE FC 48 63 F6 FF 15 ?? ?? ?? ?? 48 8D 4C 24 60 44 8B CF 48 89 4C 24 30 8B 4D CC 4C 8B C6 89 4C 24 28 8B 4C 24 48 48 8B D3 89 4C 24 20 48 8D 4D E0 FF D0 41 8B FD 81 E7 80 00 00 00 74 1E 83 7C 24 48 00 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 60 48 8B CB FF D0 41 80 FC 67 75 20 45 33 E4 85 FF 75 1C 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 60 48 8B CB FF D0 EB 03 45 33 E4 80 3B 2D 75 08 41 0F BA ED 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 89 44 24 54 E9 10 F8 FF FF 41 F6 C5 01 74 10 C6 44 24 58 2B BF 01 00 00 00 89 7C 24 50 EB 11 41 F6 C5 02 74 07 C6 44 24 58 20 EB E8 8B 7C 24 50 44 8B 65 80 48 8B 75 C0 44 2B 64 24 54 44 2B E7 41 F6 C5 0C 75 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D4 B1 20 E8 ?? ?? ?? ?? 4C 8D 4C 24 4C 48 8D 4C 24 58 4C 8B C6 8B D7 E8 ?? ?? ?? ?? 41 F6 C5 08 74 18 41 F6 C5 04 75 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D4 B1 30 E8 ?? ?? ?? ?? 8B 7C 24 54 33 C0 39 45 90 74 5E 85 FF 7E 5A 48 8B F3 44 0F B7 0E 48 8D 95 50 0B 00 00 48 8D 4D D0 41 B8 06 00 00 00 FF CF 48 83 C6 02 E8 ?? ?? ?? ?? 85 C0 75 26 8B 55 D0 85 D2 74 1F 4C 8B 45 C0 4C 8D 4C 24 4C 48 8D 8D 50 0B 00 00 E8 ?? ?? ?? ?? 85 FF 75 BC 48 8B 75 C0 EB 1F 48 8B 75 C0 83 C8 FF 89 44 24 4C EB 16 4C 8D 4C 24 4C 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? 8B 44 24 4C 85 C0 78 18 41 F6 C5 04 74 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D4 B1 20 E8 ?? ?? ?? ?? 45 33 E4 48 8B 4D D8 48 85 C9 74 09 E8 ?? ?? ?? ?? 4C 89 65 D8 8B 7C 24 48 E9 7C FD FF FF 41 80 FC 49 74 4A 41 80 FC 68 74 3B 41 80 FC 6C 74 14 41 80 FC 77 0F 85 1B 03 00 00 41 0F BA ED 0B E9 11 03 00 00 41 80 39 6C 44 8B 54 24 40 75 0D 4D 03 CB 41 0F BA ED 0C E9 FE 02 00 00 41 83 CD 10 E9 F5 02 00 00 41 83 CD 20 E9 E7 02 00 00 41 8A 01 B9 00 80 00 00 44 0B E9 3C 36 75 13 41 80 79 01 34 75 0C 49 83 C1 02 44 0B E9 E9 C5 02 00 00 3C 33 75 15 41 80 79 01 32 75 0E 49 83 C1 02 41 0F BA F5 0F E9 AC 02 00 00 3C 64 74 1D 3C 69 74 19 3C 6F 74 15 3C 75 74 11 3C 78 74 0D 3C 58 74 09 44 89 55 B4 E9 2F 02 00 00 41 0F BA ED 10 E9 81 02 00 00 41 80 FC 2A 0F 85 86 00 00 00 85 F6 75 09 41 8B 3E 49 83 C6 08 EB 44 48 8D 55 A8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D A8 4C 8B 45 98 4C 8D 49 01 41 BB 01 00 00 00 41 2B C3 4C 89 4D 88 4D 85 C0 0F 84 B0 00 00 00 48 98 48 8D 0C 40 48 8B 84 CD F8 01 00 00 8B 38 44 8B 54 24 40 89 7C 24 48 85 FF 0F 89 1A 02 00 00 83 CF FF 89 7C 24 48 E9 0E 02 00 00 44 89 18 C6 84 CD 00 02 00 00 2A 44 89 AC CD 04 02 00 00 E9 F6 01 00 00 8D 0C BF 41 0F BE C4 8D 7C 48 D0 89 7C 24 48 E9 DD 01 00 00 41 8B FA 44 89 54 24 48 E9 D0 01 00 00 41 80 FC 2A 0F 85 CA 00 00 00 85 F6 75 0C 41 8B 0E 49 83 C6 08 E9 9C 00 00 00 48 8D 55 A8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D A8 4C 8B 45 98 4C 8D 49 01 41 BB 01 00 00 00 41 2B C3 4C 89 4D 88 4D 85 C0 75 5C 85 C0 0F 88 23 02 00 00 80 39 24 0F 85 1A 02 00 00 41 83 FF 64 0F 8D 10 02 00 00 44 8B 54 24 40 41 3B C2 44 0F 4F D0 48 98 45 33 E4 48 8D 0C 40 44 89 54 24 40 48 8D 84 CD F0 01 00 00 44 39 20 0F 84 37 FF FF FF 45 8B CD 41 B0 2A 41 8B D3 48 8B C8 E8 ?? ?? ?? ?? E9 67 FB FF FF 48 98 48 8D 0C 40 48 8B 84 CD F8 01 00 00 8B 08 44 8B 54 24 40 89 4D 80 85 C9 0F 89 0F 01 00 00 41 83 CD 04 F7 D9 89 4D 80 E9 01 01 00 00 8B 45 80 8D 0C 80 41 0F BE C4 8D 4C 48 D0 89 4D 80 E9 E6 00 00 00 41 80 FC 20 74 45 41 80 FC 23 74 35 41 80 FC 2B 74 27 41 80 FC 2D 74 18 44 8B 54 24 40 41 80 FC 30 0F 85 C4 00 00 00 41 83 CD 08 E9 BB 00 00 00 41 83 CD 04 E9 AD 00 00 00 45 0B EB E9 A5 00 00 00 41 0F BA ED 07 E9 9B 00 00 00 41 83 CD 02 E9 92 00 00 00 83 CF FF 44 89 55 CC 44 89 54 24 44 44 89 55 80 44 89 54 24 50 45 8B EA 89 7C 24 48 44 89 55 90 EB 70 4D 85 C0 75 05 41 3B F3 74 66 4D 3B C3 75 05 83 FE FF 74 5C 48 8D 54 24 60 41 0F B6 CC 44 89 55 90 E8 ?? ?? ?? ?? 85 C0 74 28 48 8B 55 C0 4C 8D 44 24 4C 41 8A CC E8 ?? ?? ?? ?? 48 8B 45 88 44 8A 20 48 FF C0 48 89 45 88 45 84 E4 0F 84 C3 00 00 00 48 8B 55 C0 4C 8D 44 24 4C 41 8A CC E8 ?? ?? ?? ?? E9 4D FA FF FF 8B 7C 24 48 4C 8B 4D 88 44 8B 54 24 40 45 8A 21 8B 75 A0 8B }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "fwprintf"
		size = 145
		refs = "002a _errno 0035 _invalid_parameter_noinfo 0050 _lock_file 0059 _stbuf 006e _woutput_l 007a _ftbuf 0083 _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 50 10 48 89 48 08 4C 89 40 18 4C 89 48 20 53 56 57 48 83 EC 20 48 8B F9 33 C0 48 85 C9 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4B 33 C0 48 85 D2 0F 95 C0 85 C0 74 DF 48 8D 74 24 50 E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B D8 4C 8B CE 45 33 C0 48 8B 54 24 48 48 8B CF E8 ?? ?? ?? ?? 8B F0 48 8B D7 8B CB E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B C6 48 83 C4 20 5F 5E 5B C3 }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "_wcsicoll_l"
		size = 261
		refs = "0025 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0031 _errno 003c _invalid_parameter_noinfo 00c4 __crtCompareStringW"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 50 48 8B F9 48 8B DA 48 8D 4D E0 49 8B D0 E8 ?? ?? ?? ?? 33 F6 48 85 FF 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 75 F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 FF FF FF 7F E9 95 00 00 00 48 85 DB 74 D0 48 8B 45 E0 8B 48 10 85 C9 75 42 48 2B FB 0F B7 04 1F 66 83 F8 41 72 0A 66 83 F8 5A 77 04 66 83 C0 20 0F B7 0B 66 83 F9 41 72 0A 66 83 F9 5A 77 04 66 83 C1 20 48 83 C3 02 66 85 C0 74 05 66 3B C1 74 CB 0F B7 C9 0F B7 C0 2B C1 EB 32 41 83 C9 FF 4C 8B C7 BA 01 10 00 00 44 89 4C 24 28 48 89 5C 24 20 E8 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 64 FF FF FF 83 C0 FE 40 38 75 F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "_wcsicoll"
		size = 134
		refs = "000d __locale_changed 0019 _errno 0024 _invalid_parameter_noinfo 0082 _wcsicoll_l"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 4C 8B C9 44 39 05 ?? ?? ?? ?? 75 6A 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 4C 2B CA 41 0F B7 04 11 66 83 F8 41 72 0A 66 83 F8 5A 77 04 66 83 C0 20 0F B7 0A 66 83 F9 41 72 0A 66 83 F9 5A 77 04 66 83 C1 20 48 83 C2 02 66 85 C0 74 05 66 3B C1 74 CA 0F B7 C9 0F B7 C0 2B C1 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_192_4_0 {
	meta:
		name = "_wcsicmp"
		size = 134
		refs = "000d __locale_changed 0019 _errno 0024 _invalid_parameter_noinfo 0082 _wcsicmp_l"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 4C 8B C9 44 39 05 ?? ?? ?? ?? 75 6A 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 4C 2B CA 41 0F B7 04 11 66 83 F8 41 72 0A 66 83 F8 5A 77 04 66 83 C0 20 0F B7 0A 66 83 F9 41 72 0A 66 83 F9 5A 77 04 66 83 C1 20 48 83 C2 02 66 85 C0 74 05 66 3B C1 74 CA 0F B7 C9 0F B7 C0 2B C1 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_5_0 {
	meta:
		name = "?_strupr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z"
		size = 507
		refs = "001e __security_cookie 0038 _errno 0044 _invalid_parameter_noinfo 004e strnlen 0093 __crtLCMapStringA 0125 __chkstk 013f malloc 01b2 strcpy_s 01d3 free 01e1 __security_check_cookie"
	strings:
		$1 = { 40 55 41 54 41 55 48 83 EC 60 48 8D 6C 24 50 48 89 5D 30 48 89 75 38 48 89 7D 40 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 00 4D 8B E0 48 8B F2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? E9 8A 01 00 00 E8 ?? ?? ?? ?? 48 3B C6 72 05 C6 03 00 EB DB 49 8B 04 24 8B 50 14 85 D2 74 60 8B 40 04 C7 44 24 40 01 00 00 00 4C 8B CB 89 44 24 38 83 64 24 30 00 48 83 64 24 28 00 83 4C 24 20 FF 41 B8 00 02 00 00 49 8B CC E8 ?? ?? ?? ?? 4C 63 E8 85 C0 75 35 E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 E8 ?? ?? ?? ?? 8B 00 E9 23 01 00 00 8A 03 3C 61 7C 08 3C 7A 7F 04 2C 20 88 03 48 FF C3 80 3B 00 75 EA 33 C0 E9 06 01 00 00 49 8B CD 49 3B F5 73 12 C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 54 FF FF FF 85 C0 7E 66 33 D2 48 8D 42 E0 48 F7 F1 48 83 F8 01 72 57 48 83 C1 10 48 81 F9 00 04 00 00 77 31 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 50 48 85 FF 74 28 C7 07 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C7 10 EB 02 33 FF 48 85 FF 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 3C FF FF FF 49 8B 0C 24 C7 44 24 40 01 00 00 00 4C 8B CB 8B 41 04 8B 51 14 41 B8 00 02 00 00 89 44 24 38 44 89 6C 24 30 49 8B CC 48 89 7C 24 28 83 4C 24 20 FF E8 ?? ?? ?? ?? 85 C0 74 12 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B D8 EB 0C E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 30 48 8B 75 38 48 8B 7D 40 48 8D 65 10 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_168_6_0 {
	meta:
		name = "_strupr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0029 ?_strupr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B DA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 4C 8D 44 24 20 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_720_6_0 {
	meta:
		name = "_strlwr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0029 ?_strlwr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B DA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 4C 8D 44 24 20 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_821_6_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0029 ?_wcslwr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B DA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 4C 8D 44 24 20 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_230_6_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0029 ?_wcsupr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B DA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 4C 8D 44 24 20 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_168_8_0 {
	meta:
		name = "_strupr_l"
		size = 30
		refs = "0011 _strupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 83 CA FF 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_720_8_0 {
	meta:
		name = "_strlwr_l"
		size = 30
		refs = "0011 _strlwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 83 CA FF 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_821_8_0 {
	meta:
		name = "_wcslwr_l"
		size = 30
		refs = "0011 _wcslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 83 CA FF 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_230_8_0 {
	meta:
		name = "_wcsupr_l"
		size = 30
		refs = "0011 _wcsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 83 CA FF 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_168_9_0 {
	meta:
		name = "_strupr"
		size = 98
		refs = "000d __locale_changed 0019 _errno 0024 _invalid_parameter_noinfo 0055 _strupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 33 D2 48 8B D9 39 15 ?? ?? ?? ?? 75 3A 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 30 48 8B C1 38 11 74 26 8A 08 80 F9 61 7C 0A 80 F9 7A 7F 05 80 E9 20 88 08 48 FF C0 38 10 75 E8 EB 0C 45 33 C0 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "log"
		size = 702
		refs = "0026 __mask_1023 003a __real_inf 0050 __real_mant 0058 __real_one 0060 __mask_1023_f 0070 __mask_mant_all8 0077 __mask_mant9 008a __real_notsign 0092 __real_threshold 00aa __real_half 00b9 __log_F_inv 00e0 __log_256_lead 00e8 __real_1_over_6 00f0 __real_1_over_3 0108 __real_1_over_5 0110 __real_1_over_2 0124 __real_1_over_4 0138 __real_log2_tail 014d __log_256_tail 015e __real_log2_lead 0184 __real_two 01a0 __real_ca2 01a8 __real_ca4 01cc __real_ca1 01d4 __real_ca3 0230 __mask_2045 0246 __real_ninf 024d __flag_x_zero 0252 _log_special 0264 __real_neg_qnan 026b __flag_x_neg 0295 __real_qnanbit 02a1 __flag_x_nan"
	strings:
		$1 = { 48 81 EC 98 00 00 00 66 0F 7F 74 24 40 48 33 C0 66 0F 6F D8 F2 0F 10 E0 66 0F 73 D3 34 66 48 0F 7E C0 66 0F FB 1D ?? ?? ?? ?? 66 0F 6F D0 F3 0F E6 F3 66 0F 6F E8 66 0F 54 2D ?? ?? ?? ?? 66 0F 2F 2D ?? ?? ?? ?? 0F 84 34 02 00 00 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C 25 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 0F 84 9C 01 00 00 4C 8B C8 48 23 05 ?? ?? ?? ?? 4C 23 0D ?? ?? ?? ?? 49 D1 E1 49 03 C1 48 89 44 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 0F 82 E4 00 00 00 F2 0F 10 4C 24 30 48 C1 E8 2C 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 66 0F 57 ED 66 0F 2F C5 0F 86 75 01 00 00 F2 0F 5C CA F2 41 0F 59 0C C1 F2 0F 10 D1 F2 0F 10 C1 4C 8D 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 DA F2 0F 59 C8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CA F2 0F 59 DC F2 0F 58 CB F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 5C E9 F2 41 0F 10 04 C1 48 8D 15 ?? ?? ?? ?? F2 0F 10 14 C2 F2 0F 58 D5 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E6 F2 0F 58 C4 F2 0F 58 C2 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 0F 1F 40 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 10 C8 F2 0F 5E CA F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 F0 F2 0F 59 F1 F2 0F 58 C9 F2 0F 10 D1 F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 EA F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 D2 F2 0F 59 D1 F2 0F 59 EA F2 0F 58 E5 F2 0F 5C E6 F2 0F 58 C4 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 66 0F EB 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 10 EA 66 0F DB 15 ?? ?? ?? ?? 66 48 0F 7E D0 66 0F 73 D5 34 66 0F FA 2D ?? ?? ?? ?? F3 0F E6 F5 E9 2D FE FF FF 0F 1F 00 75 1E F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3A 66 66 0F 1F 84 00 00 00 00 00 48 3B 05 ?? ?? ?? ?? 74 27 48 3B 05 ?? ?? ?? ?? 74 CE 48 0B 05 ?? ?? ?? ?? 66 48 0F 6E C8 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 0F 1F 40 00 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "_chmod"
		size = 115
		refs = "0015 __doserrno 001c _errno 0027 _invalid_parameter_noinfo 0032 __imp_GetFileAttributesA 003d __imp_GetLastError 0044 _dosmaperr 005e __imp_SetFileAttributesA"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B FA 48 8B D9 48 85 C9 75 1C E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 38 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB E1 40 84 FF 79 05 83 E0 FE EB 03 83 C8 01 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "_wchmod"
		size = 115
		refs = "0015 __doserrno 001c _errno 0027 _invalid_parameter_noinfo 0032 __imp_GetFileAttributesW 003d __imp_GetLastError 0044 _dosmaperr 005e __imp_SetFileAttributesW"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B FA 48 8B D9 48 85 C9 75 1C E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 38 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB E1 40 84 FF 79 05 83 E0 FE EB 03 83 C8 01 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_174_3_0 {
	meta:
		name = "_mbsrev_l"
		size = 237
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 _errno 0033 _invalid_parameter_noinfo 0060 _strrev"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 48 8B D9 48 8B F1 48 8B F9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 85 DB 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 E9 8C 00 00 00 48 8B 54 24 28 83 7A 08 00 75 1D 48 8B CB E8 ?? ?? ?? ?? 80 7C 24 38 00 74 72 48 8B 4C 24 30 83 A1 C8 00 00 00 FD EB 64 8A 03 84 C0 74 40 0F B6 C0 48 FF C3 8A 4C 10 1D 80 E1 04 74 EB 8A 0B 84 C9 74 0D 8A 43 FF 88 4B FF 88 03 48 FF C3 EB D8 E8 ?? ?? ?? ?? 48 FF CB C7 00 16 00 00 00 C6 03 00 EB 0B 8A 0F 8A 03 88 07 48 FF C7 88 0B 48 FF CB 48 3B FB 72 ED 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B C6 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "wcscmp"
		size = 57
	strings:
		$1 = { 44 0F B7 02 0F B7 01 41 2B C0 75 1A 48 2B CA 66 45 85 C0 74 11 48 83 C2 02 44 0F B7 02 0F B7 04 11 41 2B C0 74 E9 85 C0 79 04 83 C8 FF C3 B9 01 00 00 00 85 C0 0F 4F C1 C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "_gets_helper"
		size = 603
		refs = "0034 _errno 003f _invalid_parameter_noinfo 0057 __iob_func 0061 _lock_file2 0079 _fileno 0094 __pioinfo 00a6 __badioinfo 0131 _filbuf 0228 _local_unwind 0240 _unlock_file2"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 41 54 41 55 48 83 EC 40 48 89 64 24 38 45 8B E8 48 8B FA 4C 8B E1 48 8B D9 48 8B F1 33 C0 48 85 C9 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 FD 01 00 00 33 C0 48 85 D2 0F 95 C0 85 C0 74 DD E8 ?? ?? ?? ?? 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? F6 40 18 40 0F 85 8A 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 2A 83 F8 FE 74 25 48 63 D0 48 8B CA 48 C1 F9 05 4C 8D 05 ?? ?? ?? ?? 83 E2 1F 48 6B D2 58 49 03 14 C8 48 8D 0D ?? ?? ?? ?? EB 11 48 8D 0D ?? ?? ?? ?? 48 8B D1 4C 8D 05 ?? ?? ?? ?? F6 42 38 7F 75 25 83 F8 FF 74 1A 83 F8 FE 74 15 48 63 C8 48 8B C1 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C0 F6 41 38 80 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 F6 48 89 74 24 20 48 85 F6 0F 84 2D 01 00 00 E8 ?? ?? ?? ?? FF 48 08 78 16 E8 ?? ?? ?? ?? 4C 8B D8 48 8B 00 0F B6 08 48 FF C0 49 89 03 EB 0F E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 8B C8 89 4C 24 60 83 F9 FF 75 10 33 F6 48 89 74 24 20 45 85 ED 0F 85 E5 00 00 00 48 83 FF FF 75 51 83 F9 0A 0F 84 D3 00 00 00 83 F9 FF 0F 84 CA 00 00 00 88 0B 48 FF C3 48 89 5C 24 30 E8 ?? ?? ?? ?? FF 48 08 78 16 E8 ?? ?? ?? ?? 4C 8B D8 48 8B 00 0F B6 08 48 FF C0 49 89 03 EB 0F E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 8B C8 89 4C 24 60 EB AF 48 89 7C 24 28 83 F9 0A 74 51 83 F9 FF 74 4C 48 85 FF 74 12 48 FF CF 48 89 7C 24 28 88 0B 48 FF C3 48 89 5C 24 30 E8 ?? ?? ?? ?? FF 48 08 78 16 E8 ?? ?? ?? ?? 4C 8B D8 48 8B 00 0F B6 08 48 FF C0 49 89 03 EB 0F E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 8B C8 89 4C 24 60 EB AA 48 85 FF 75 2B 41 88 3C 24 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 0C 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 90 90 33 C0 EB 15 C6 03 00 E8 ?? ?? ?? ?? 48 8B D0 33 C9 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 68 48 8B 74 24 70 48 83 C4 40 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_memccpy"
		size = 39
	strings:
		$1 = { 4D 85 C9 74 18 48 FF CA 48 FF C2 48 FF C1 8A 02 88 41 FF 41 3A C0 74 05 49 FF C9 75 EB 49 F7 D9 48 1B C0 48 23 C1 C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_cputs"
		size = 120
		refs = "001c __doserrno 0023 _errno 002e _invalid_parameter_noinfo 003d _lock 0052 _putch_nolock 0067 _unlock"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 48 8B F9 33 DB 8B C3 48 85 C9 0F 95 C0 85 C0 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 36 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 38 1F 74 1B 0F BE 0F 48 FF C7 48 89 7C 24 30 E8 ?? ?? ?? ?? 83 F8 FF 75 04 0B D8 EB 02 EB E1 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "strlen"
		size = 168
	strings:
		$1 = { 48 8B C1 48 F7 D9 48 A9 07 00 00 00 74 0F 66 90 8A 10 48 FF C0 84 D2 74 5F A8 07 75 F3 49 B8 FF FE FE FE FE FE FE 7E 49 BB 00 01 01 01 01 01 01 81 48 8B 10 4D 8B C8 48 83 C0 08 4C 03 CA 48 F7 D2 49 33 D1 49 23 D3 74 E8 48 8B 50 F8 84 D2 74 51 84 F6 74 47 48 C1 EA 10 84 D2 74 39 84 F6 74 2F 48 C1 EA 10 84 D2 74 21 84 F6 74 17 C1 EA 10 84 D2 74 0A 84 F6 75 B9 48 8D 44 01 FF C3 48 8D 44 01 FE C3 48 8D 44 01 FD C3 48 8D 44 01 FC C3 48 8D 44 01 FB C3 48 8D 44 01 FA C3 48 8D 44 01 F9 C3 48 8D 44 01 F8 C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_wstrdate_s"
		size = 343
		refs = "000d __security_cookie 003a _errno 004d __imp_GetLocalTime 0139 _invalid_parameter_noinfo 0148 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 FF 48 8B D9 48 85 C9 0F 84 05 01 00 00 48 85 D2 0F 84 FC 00 00 00 66 89 39 48 83 FA 09 73 0D E8 ?? ?? ?? ?? 8D 5F 22 E9 F0 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 44 0F B7 4C 24 20 44 0F B7 5C 24 22 44 0F B7 44 24 26 41 BA 67 66 66 66 B8 1F 85 EB 51 66 89 7B 10 66 BF 30 00 41 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 B8 2F 00 00 00 66 89 43 0A 66 89 43 04 41 8B C2 6B D2 64 44 2B CA 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B D8 41 8B C2 66 44 03 DF 66 44 89 5B 02 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8B C2 8D 0C 17 66 89 4B 06 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C1 66 44 03 C7 66 44 89 43 08 41 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 43 0C 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B C8 66 44 03 CF 33 C0 66 44 89 4B 0E EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "_wstrdate"
		size = 314
		refs = "000d __security_cookie 0024 _errno 002f _invalid_parameter_noinfo 0044 __imp_GetLocalTime 012b __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 FF 48 8B D9 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 E8 00 00 00 66 89 39 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 44 0F B7 4C 24 20 44 0F B7 5C 24 22 44 0F B7 44 24 26 41 BA 67 66 66 66 B8 1F 85 EB 51 66 89 7B 10 66 BF 30 00 41 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 B8 2F 00 00 00 66 89 43 0A 66 89 43 04 41 8B C2 6B D2 64 44 2B CA 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B D8 41 8B C2 66 44 03 DF 66 44 89 5B 02 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8B C2 8D 0C 17 66 89 4B 06 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C1 66 44 03 C7 66 44 89 43 08 41 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 48 8B C3 8D 0C 17 66 89 4B 0C 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C9 66 44 03 CF 66 44 89 4B 0E 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_ungetwc_nolock"
		size = 515
		refs = "0019 __security_cookie 006a _getbuf 007c _fileno 0083 __badioinfo 008a __pioinfo 0146 wctomb_s 01e1 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 6C 24 20 56 57 41 54 41 55 41 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 41 BD FF FF 00 00 48 8B FA 0F B7 E9 66 89 4C 24 24 66 41 3B CD 0F 84 94 01 00 00 F6 42 18 01 BE 02 00 00 00 75 14 F6 42 18 80 0F 84 7F 01 00 00 40 84 72 18 0F 85 75 01 00 00 48 83 7A 10 00 75 08 48 8B CA E8 ?? ?? ?? ?? F6 47 18 40 0F 85 2A 01 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8D 25 ?? ?? ?? ?? 4C 8D 3D ?? ?? ?? ?? 83 F8 FF 74 35 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 28 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 48 63 D8 48 C1 FB 05 E8 ?? ?? ?? ?? 44 8B D8 41 83 E3 1F 4D 6B DB 58 4D 03 1C DF EB 03 4D 8B DC 41 F6 43 08 80 0F 84 CC 00 00 00 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 33 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 26 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 48 63 D8 48 C1 FB 05 E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 1F 4D 6B E4 58 4D 03 24 DF 41 F6 44 24 38 7F 74 13 8A 44 24 25 40 88 6C 24 28 89 74 24 20 88 44 24 29 EB 25 48 8D 54 24 28 48 8D 4C 24 20 44 0F B7 CD 41 B8 05 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 82 00 00 00 8B 74 24 20 48 8B 47 10 48 63 D6 48 03 D0 48 39 17 73 0E 83 7F 08 00 75 69 3B 77 24 7F 64 48 89 17 8D 46 FF 48 63 D0 85 C0 78 15 48 FF 0F 8A 44 14 28 48 FF CA 48 8B 0F 88 01 79 EF 8B 74 24 20 01 77 08 83 67 18 EF 83 4F 18 01 0F B7 C5 EB 36 48 8B 47 10 48 03 C6 48 39 07 73 0E 83 7F 08 00 75 20 39 77 24 72 1B 48 89 07 48 83 07 FE F6 47 18 40 48 8B 07 74 35 66 39 28 74 C4 48 03 C6 48 89 07 41 0F B7 C5 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 40 49 8B 5B 40 49 8B 6B 48 49 8B E3 41 5F 41 5D 41 5C 5F 5E C3 66 89 28 EB 8F }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "ungetwc"
		size = 101
		refs = "0022 _errno 002d _invalid_parameter_noinfo 003c _lock_file 0048 _ungetwc_nolock 0053 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 0F B7 F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 22 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 0F B7 CF E8 ?? ?? ?? ?? 0F B7 F8 48 8B CB E8 ?? ?? ?? ?? 0F B7 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_351_1_0 {
	meta:
		name = "fputwc"
		size = 101
		refs = "0022 _errno 002d _invalid_parameter_noinfo 003c _lock_file 0048 _fputwc_nolock 0053 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 0F B7 F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 22 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 0F B7 CF E8 ?? ?? ?? ?? 0F B7 F8 48 8B CB E8 ?? ?? ?? ?? 0F B7 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__report_gsfailure"
		size = 330
		refs = "000f GS_ContextRecord 0015 __imp_RtlCaptureContext 0033 RtlLookupFunctionEntry 007f RtlVirtualUnwind 00b1 GS_ExceptionRecord 00db __security_cookie 00e7 __security_cookie_complement 00f2 __imp_IsDebuggerPresent 00f8 DebuggerWasPresent 0102 __crt_debugger_hook 010a __imp_SetUnhandledExceptionFilter 0111 GS_ExceptionPointers 0117 __imp_UnhandledExceptionFilter 0130 __imp_GetCurrentProcess 013e __imp_TerminateProcess"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 44 24 58 45 33 C0 48 8D 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 74 41 48 C7 44 24 38 00 00 00 00 48 8D 44 24 48 48 89 44 24 30 48 8D 44 24 40 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 4C 8B 4C 24 50 4C 8B 44 24 58 48 8B 54 24 60 33 C9 E8 ?? ?? ?? ?? EB 22 48 8B 84 24 88 00 00 00 48 89 05 ?? ?? ?? ?? 48 8D 84 24 88 00 00 00 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 68 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 FF 15 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C9 FF 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A B9 01 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BA 09 04 00 C0 48 8B C8 FF 15 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_184_15_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QEAAXXZ"
		size = 29
		refs = "000b ?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B 41 48 83 78 10 01 75 05 E9 ?? ?? ?? ?? 48 8B 81 E0 00 00 00 FF 80 A0 00 00 00 C3 }
	condition:
		$1
}

rule file_184_16_0 {
	meta:
		name = "?InternalReference@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
		size = 28
		altNames = "?Reference@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
	strings:
		$1 = { F6 81 BC 00 00 00 04 75 10 B8 01 00 00 00 F0 0F C1 81 B4 00 00 00 FF C0 C3 33 C0 C3 }
	condition:
		$1
}

rule file_184_17_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
		size = 57
		refs = "0029 ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AEAAXPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 81 BC 00 00 00 04 75 22 83 CB FF F0 0F C1 99 B4 00 00 00 FF CB 75 0F 48 8B D1 48 8B 89 A0 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_23_0 {
	meta:
		name = "?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IEAAXPEAVInternalContextBase@23@PEAVVirtualProcessor@23@@Z"
		size = 130
		refs = "0019 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0026 ?GetScheduleGroup@ContextBase@details@Concurrency@@QEBAPEAVScheduleGroupBase@23@XZ 0064 ?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QEAAXPEAVScheduleGroupBase@23@PEAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F0 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 85 C0 74 0D 48 8B C8 E8 ?? ?? ?? ?? 48 3B C7 74 0A C7 83 38 01 00 00 01 00 00 00 48 8B 07 48 8B D3 48 8B CF FF 50 28 48 8B 87 A8 00 00 00 8B 88 7C 01 00 00 85 C9 7E 12 48 8B 8F A8 00 00 00 4C 8B C6 48 8B D7 E8 ?? ?? ?? ?? 48 8B 74 24 38 C7 83 38 01 00 00 00 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_24_0 {
	meta:
		name = "?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IEAAPEAVInternalContextBase@23@PEAU_Chore@23@_N@Z"
		size = 85
		refs = "0025 ?GetInternalContext@SchedulerBase@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ 0039 ?PrepareForUse@InternalContextBase@details@Concurrency@@QEAAXPEAVScheduleGroupBase@23@PEAU_Chore@23@_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B E9 48 8B 89 A8 00 00 00 41 8A F8 48 8B F2 E8 ?? ?? ?? ?? 44 8A CF 4C 8B C6 48 8B D5 48 8B C8 48 8B D8 E8 ?? ?? ?? ?? 48 8B 6C 24 38 48 8B 74 24 40 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_25_0 {
	meta:
		name = "?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IEAAXPEAVInternalContextBase@23@@Z"
		size = 49
		refs = "0014 ?RemoveFromUse@InternalContextBase@details@Concurrency@@QEAAXXZ 002d ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QEAAXPEAVInternalContextBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B CA 48 8B DA E8 ?? ?? ?? ?? 48 8B 8F A8 00 00 00 48 8B D3 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_29_0 {
	meta:
		name = "?MarkDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAXXZ"
		size = 53
		refs = "0015 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 0031 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 59 10 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 8B 47 04 48 8B CB 89 47 1C C6 47 18 01 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_40_0 {
	meta:
		name = "?Enqueue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXPEAVRealizedChore@23@@Z"
		size = 20
	strings:
		$1 = { 4C 8D 42 20 49 83 20 00 48 8B 41 08 48 89 10 4C 89 41 08 C3 }
	condition:
		$1
}

rule file_184_41_0 {
	meta:
		name = "?Dequeue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ"
		size = 34
	strings:
		$1 = { 48 8B 11 48 8B C1 48 85 D2 75 03 33 C0 C3 48 8B 4A 20 48 89 08 48 85 C9 75 04 48 89 40 08 48 8B C2 C3 }
	condition:
		$1
}

rule file_184_52_0 {
	meta:
		name = "?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QEBA_NXZ"
		size = 18
	strings:
		$1 = { 8B 91 A4 00 00 00 8B 89 A0 00 00 00 3B D1 0F 9E C0 C3 }
	condition:
		$1
}

rule file_184_53_0 {
	meta:
		name = "?MarkDetachment@WorkQueue@details@Concurrency@@QEAAXXZ"
		size = 65
		refs = "0018 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 003d ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 99 B0 00 00 00 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 8B 87 A4 00 00 00 48 8B CB 89 87 BC 00 00 00 C6 87 B8 00 00 00 01 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_54_0 {
	meta:
		name = "?IsEmpty@WorkQueue@details@Concurrency@@QEBA_NXZ"
		size = 34
	strings:
		$1 = { 8B 51 04 8B 01 3B D0 7F 16 8B 91 A4 00 00 00 8B 81 A0 00 00 00 3B D0 7F 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_184_55_0 {
	meta:
		name = "?SetDetached@WorkQueue@details@Concurrency@@QEAAX_N@Z"
		size = 108
		refs = "002b ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 0046 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 40 8A EA 48 8B F1 84 D2 74 2A 48 8B 99 B0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 8B 86 A4 00 00 00 48 8B CB 89 86 BC 00 00 00 C6 86 B8 00 00 00 01 E8 ?? ?? ?? ?? 48 8B 5C 24 30 40 84 ED 48 8B 6C 24 38 40 0F 95 C7 87 BE 80 00 00 00 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_56_0 {
	meta:
		name = "??0?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
		size = 19
		altNames = "??0?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ ??0?$SafeSQueue@VSafePointInvocation@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ ??0?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 83 21 00 48 89 49 08 48 8B C1 C7 41 10 00 00 00 00 C3 }
	condition:
		$1
}

rule file_184_58_0 {
	meta:
		name = "?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAXPEAVRealizedChore@23@@Z"
		size = 73
		refs = "001a ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 0045 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 48 83 C1 10 48 8B FA E8 ?? ?? ?? ?? 4C 8D 5F 20 48 8D 4E 10 49 83 23 00 48 8B 46 08 48 89 38 4C 89 5E 08 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_59_0 {
	meta:
		name = "?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ"
		size = 84
		refs = "0017 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 003d ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 83 C1 10 E8 ?? ?? ?? ?? 4C 8B 1F 33 F6 4D 85 DB 74 13 49 8B 43 20 48 89 07 48 85 C0 75 04 48 89 7F 08 49 8B F3 48 8D 4F 10 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_63_0 {
	meta:
		name = "?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
		size = 36
		refs = "0015 ??3@YAXPEAX@Z"
		altNames = "?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
	strings:
		$1 = { 48 85 D2 74 1E 53 48 83 EC 20 48 8B DA 48 8D 4B F0 48 8B 1B E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_64_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
		size = 79
		refs = "0017 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 002f ??3@YAXPEAX@Z"
		altNames = "?CheckForDeletionBridge@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 8B 49 48 E8 ?? ?? ?? ?? 33 DB 84 C0 75 1E 48 8B 77 20 EB 0C 48 8D 4E F0 48 8B 36 E8 ?? ?? ?? ?? 48 85 F6 75 EF 48 89 5F 20 87 5F 78 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_65_0 {
	meta:
		name = "??1WorkQueue@details@Concurrency@@QEAA@XZ"
		size = 35
		refs = "0011 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 89 C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 10 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_66_0 {
	meta:
		name = "?GetRealizedChore@ScheduleGroupBase@details@Concurrency@@IEAAPEAVRealizedChore@23@XZ"
		size = 94
		refs = "0023 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 0047 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 79 08 33 F6 48 39 37 75 04 33 C0 EB 30 48 8D 4F 10 E8 ?? ?? ?? ?? 4C 8B 1F 4D 85 DB 74 13 49 8B 43 20 48 89 07 48 85 C0 75 04 48 89 7F 08 49 8B F3 48 8D 4F 10 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_69_0 {
	meta:
		name = "??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 210
		refs = "0019 __imp_InterlockedFlushSList 002d ??3@YAXPEAX@Z 00a1 ??_V@YAXPEAX@Z"
		altNames = "??1?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F9 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 11 48 8D 4B F0 48 8B 1B E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8D 4F 10 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 11 48 8D 4B F0 48 8B 1B E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 5F 20 EB 0C 48 8D 4B F0 48 8B 1B E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 77 58 48 85 F6 74 3C 33 DB 39 5F 50 7E 19 33 ED 48 8B 0E 48 8B 0C 29 E8 ?? ?? ?? ?? FF C3 48 83 C5 08 3B 5F 50 7C E9 48 8B 0E 48 8B 5E 08 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B F3 48 85 DB 75 C4 48 8B 4F 60 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_72_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QEAAPEAXI@Z"
		size = 63
		refs = "0017 ??_V@YAXPEAX@Z 002d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 89 C0 00 00 00 8B DA E8 ?? ?? ?? ?? 48 8B 4F 10 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_74_0 {
	meta:
		name = "?ScheduleTask@ScheduleGroupBase@details@Concurrency@@UEAAXP6AXPEAX@Z0@Z"
		size = 391
		refs = "001b ??_C@_04MGCDEED@proc?$AA@ 002c ??0exception@std@@QEAA@AEBQEBD@Z 0033 ??_7invalid_argument@std@@6B@ 003a _TI3?AVinvalid_argument@std@@ 0049 _CxxThrowException 0056 ?GetRealizedChore@SchedulerBase@details@Concurrency@@QEAAPEAVRealizedChore@23@P6AXPEAX@Z0@Z 0072 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 008e ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 0093 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00a3 ?GetScheduler@ContextBase@details@Concurrency@@QEBAPEAVSchedulerBase@23@XZ 00d4 ?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QEAAXXZ 00f5 __imp_TlsGetValue 0105 ??2@YAPEAX_K@Z 013b ?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAAHPEAVExternalStatistics@23@@Z 014f __imp_TlsSetValue"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 73 18 57 48 83 EC 40 48 8B F9 48 85 D2 75 36 48 8D 05 ?? ?? ?? ?? 49 8D 53 10 49 8D 4B D8 49 89 43 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 89 A8 00 00 00 E8 ?? ?? ?? ?? F6 87 BC 00 00 00 04 48 8B F0 75 07 F0 FF 87 B4 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 4C 8D 5E 20 48 8D 4F 18 49 83 23 00 48 8B 47 10 48 89 30 4C 89 5F 10 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 4A 48 8B C8 E8 ?? ?? ?? ?? 48 3B 87 A8 00 00 00 75 39 80 7B 70 00 74 0F 48 8B 83 D0 00 00 00 FF 40 20 E9 91 00 00 00 48 8B 43 38 83 78 10 01 75 0B 48 8D 4B F0 E8 ?? ?? ?? ?? EB 7C 48 8B 83 D0 00 00 00 FF 80 A0 00 00 00 EB 6D 48 8B 87 A8 00 00 00 8B 48 20 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 52 8D 48 40 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 19 83 60 20 00 83 60 24 00 83 60 28 00 83 60 2C 00 C7 40 30 01 00 00 00 EB 02 33 DB 48 8B 8F A8 00 00 00 48 8B D3 48 83 C1 60 E8 ?? ?? ?? ?? 4C 8B 9F A8 00 00 00 48 8B D3 41 8B 4B 20 FF 15 ?? ?? ?? ?? FF 43 20 48 8B 87 A8 00 00 00 8B 88 7C 01 00 00 85 C9 7E 10 48 8B 8F A8 00 00 00 48 8B D7 48 8B 01 FF 50 50 48 8B 5C 24 50 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_184_77_0 {
	meta:
		name = "?DetachActiveWorkQueue@ScheduleGroupBase@details@Concurrency@@IEAAXPEAVWorkQueue@23@@Z"
		size = 131
		refs = "003a ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 0055 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 007f ?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAAHPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 F6 81 BC 00 00 00 04 48 8B EA 48 8B F9 BE 01 00 00 00 75 07 F0 01 B1 B4 00 00 00 48 8B 9A B0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 8B 85 A4 00 00 00 48 8B CB 89 85 BC 00 00 00 40 88 B5 B8 00 00 00 E8 ?? ?? ?? ?? 87 B5 80 00 00 00 48 8D 55 50 48 8D 8F C0 00 00 00 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_78_0 {
	meta:
		name = "?RedetachQueue@ScheduleGroupBase@details@Concurrency@@QEAAXPEAVWorkQueue@23@@Z"
		size = 16
		refs = "000c ?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAAHPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 48 83 C2 50 48 81 C1 C0 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_79_0 {
	meta:
		name = "?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA_NPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z"
		size = 320
		refs = "00b0 __imp_QueryDepthSList 00c8 __imp_InterlockedPushEntrySList 00e5 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 00fc __imp_InterlockedFlushSList 010b ?CheckForDeletionBridge@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z 0117 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 48 83 EC 30 48 8B D9 8B 49 54 BD 01 00 00 00 44 8B 5B 50 45 8B D0 48 8B F2 44 2B DD 41 D3 FA 45 23 D8 44 3B 53 6C 0F 8D F1 00 00 00 48 8B 43 60 44 3B 53 68 7C 1F 48 63 4B 68 4C 8B 44 C8 F8 78 1B 44 2B 53 68 42 8D 44 15 00 48 2B C5 4D 8B 40 08 75 F7 EB 07 49 63 CA 4C 8B 04 C8 49 8B 10 48 89 74 24 50 49 63 CB 48 8B 44 24 50 45 33 E4 F0 4C 0F B1 24 CA 48 89 44 24 20 48 8B 4C 24 20 48 8B 44 24 50 48 3B C8 0F 85 90 00 00 00 41 8D 44 24 FE F0 45 0F B1 58 10 45 84 C9 74 7B 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 56 10 44 0F B7 D8 44 3B 5B 74 7E 5B 48 8D 4B 10 FF 15 ?? ?? ?? ?? 48 8D 4B 10 FF 15 ?? ?? ?? ?? 44 0F B7 D8 44 3B 5B 74 7E 46 48 8B 4B 48 E8 ?? ?? ?? ?? 84 C0 75 39 33 C0 F0 0F B1 6B 78 75 30 48 8D 4B 10 FF 15 ?? ?? ?? ?? 4C 8B 4B 48 48 8D 4B 28 48 8D 15 ?? ?? ?? ?? 4C 8B C3 48 89 43 20 E8 ?? ?? ?? ?? EB 09 48 8B CB FF 15 ?? ?? ?? ?? 40 8A C5 EB 02 32 C0 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_184_80_0 {
	meta:
		name = "??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPEAVWorkQueue@01@@Z"
		size = 48
		refs = "0015 ??_V@YAXPEAX@Z 0026 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 85 C9 74 2A 53 48 83 EC 20 48 8B D9 48 8B 89 C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 10 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_81_0 {
	meta:
		name = "?GetDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IEAAPEAVWorkQueue@23@XZ"
		size = 268
		refs = "00a7 ?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA_NPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z 0103 ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AEAAXPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 48 83 EC 20 44 8B A9 30 01 00 00 33 F6 48 8B D9 8B FE 45 85 ED 0F 8E 8B 00 00 00 8B 8B 14 01 00 00 8B D7 D3 FA 3B 93 2C 01 00 00 7D 6E 48 8B 83 20 01 00 00 3B 93 28 01 00 00 7C 22 2B 93 28 01 00 00 48 63 8B 28 01 00 00 4C 8B 44 C8 F8 78 15 8D 4A 01 48 FF C9 4D 8B 40 08 75 F7 EB 07 48 63 CA 4C 8B 04 C8 8B 83 10 01 00 00 FF C8 48 63 C8 48 63 C7 48 23 C8 49 8B 00 4C 8B 24 C8 4D 85 E4 74 19 48 8D 8B C0 00 00 00 45 33 C9 44 8B C7 49 8B D4 E8 ?? ?? ?? ?? 84 C0 75 26 FF C7 41 3B FD 0F 8C 75 FF FF FF 33 C0 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 20 41 5D 41 5C 5F C3 49 8B 7C 24 20 87 B7 80 00 00 00 F6 83 BC 00 00 00 04 75 1E 83 C9 FF F0 0F C1 8B B4 00 00 00 FF C9 75 0F 48 8B 8B A0 00 00 00 48 8B D3 E8 ?? ?? ?? ?? 48 8B C7 EB B0 }
	condition:
		$1
}

rule file_184_83_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
		size = 75
		refs = "0026 ??_V@YAXPEAX@Z 0037 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 85 D2 74 45 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8D 7B E0 48 8B 1B 48 85 FF 74 1D 48 8B 8F C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4F 10 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 85 DB 75 D2 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_84_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
		size = 118
		refs = "001c ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 0040 ??_V@YAXPEAX@Z 0051 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F1 48 8B 49 48 E8 ?? ?? ?? ?? 33 DB 84 C0 75 3B 48 8B 7E 20 EB 29 48 8D 6F E0 48 8B 3F 48 85 ED 74 1D 48 8B 8D C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 10 E8 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? 48 85 FF 75 D2 48 89 5E 20 87 5E 78 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_85_0 {
	meta:
		name = "?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IEAA_NPEAVWorkQueue@23@@Z"
		size = 93
		refs = "0022 ?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA_NPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z 0043 ?RetireAtSafePoint@WorkQueue@details@Concurrency@@QEAAXPEAVScheduleGroupBase@23@@Z 004c ?RedetachFromScheduleGroupAtSafePoint@WorkQueue@details@Concurrency@@QEAAXPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 83 C2 50 48 8B F9 44 8B 02 48 81 C1 C0 00 00 00 45 33 C9 E8 ?? ?? ?? ?? 84 C0 74 26 44 8B 83 A4 00 00 00 8B 83 A0 00 00 00 48 8B D7 48 8B CB 44 3B C0 7F 09 E8 ?? ?? ?? ?? B0 01 EB 07 E8 ?? ?? ?? ?? 32 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_86_0 {
	meta:
		name = "??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 339
		refs = "001e __imp_InterlockedFlushSList 003e ??_V@YAXPEAX@Z 004f ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 20 48 8B F9 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 2E 48 8D 73 E0 48 8B 1B 48 85 F6 74 1D 48 8B 8E C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4E 10 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 85 DB 75 D2 48 8D 4F 10 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 2E 48 8D 73 E0 48 8B 1B 48 85 F6 74 1D 48 8B 8E C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4E 10 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 85 DB 75 D2 48 8B 5F 20 EB 29 48 8D 73 E0 48 8B 1B 48 85 F6 74 1D 48 8B 8E C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4E 10 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 85 DB 75 D2 48 8B 77 58 48 85 F6 74 5B 33 DB 39 5F 50 7E 38 33 ED 48 8B 06 4C 8B 24 28 4D 85 E4 74 1F 49 8B 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 49 8B 4C 24 10 E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? FF C3 48 83 C5 08 3B 5F 50 7C CA 48 8B 0E 48 8B 5E 08 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B F3 48 85 DB 75 A5 48 8B 4F 60 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_88_0 {
	meta:
		name = "??0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z"
		size = 171
		refs = "0021 ??_7ScheduleGroupBase@details@Concurrency@@6B@ 004f ??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z 007c ??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z 0093 ?GetNewScheduleGroupId@SchedulerBase@details@Concurrency@@QEAAIXZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B DA 48 8B F9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 41 08 48 83 20 00 48 89 40 08 C7 40 10 00 00 00 00 48 83 C1 20 41 B9 40 00 00 00 41 B8 00 01 00 00 48 8B 12 E8 ?? ?? ?? ?? 90 48 89 9F A0 00 00 00 C7 87 B4 00 00 00 01 00 00 00 48 8D 8F C0 00 00 00 41 B9 FF FF FF 7F 41 B8 00 01 00 00 48 8B 13 E8 ?? ?? ?? ?? 90 48 8B 87 A0 00 00 00 48 8B 08 48 89 8F A8 00 00 00 E8 ?? ?? ?? ?? 89 87 B8 00 00 00 48 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_184_89_0 {
	meta:
		name = "?dtor$0@?0???0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z@4HA"
		size = 16
		refs = "000c ??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 20 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_72_0 {
	meta:
		name = "?dtor$0@?0???0SchedulingRing@details@Concurrency@@QEAA@PEAVSchedulerBase@12@H@Z@4HA"
		size = 16
		refs = "000c ??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 20 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_63_0 {
	meta:
		name = "?dtor$0@?0???1SchedulingRing@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 20 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_90_0 {
	meta:
		name = "?dtor$1@?0???0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z@4HA"
		size = 19
		refs = "000f ??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 81 C1 C0 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_93_0 {
	meta:
		name = "?IsEmptyAtSafePoint@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA_NXZ"
		size = 55
		altNames = "?IsEmptyAtSafePoint@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 8B 41 58 48 85 C0 74 28 44 8B 41 50 33 D2 45 85 C0 7E 14 48 8B 08 48 83 39 00 75 17 FF C2 48 83 C1 08 41 3B D0 7C EF 48 8B 40 08 48 85 C0 75 DC B0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_184_96_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 57
		refs = "0029 ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AEAAXPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 81 BC 00 00 00 04 75 20 83 CB FF F0 0F C1 99 B4 00 00 00 FF CB 75 13 48 8B D1 48 8B 89 A0 00 00 00 E8 ?? ?? ?? ?? EB 02 33 DB 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_97_0 {
	meta:
		name = "??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ"
		size = 45
		refs = "0009 ??_7ScheduleGroupBase@details@Concurrency@@6B@ 001b ??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0029 ??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		altNames = "??1CacheLocalScheduleGroup@details@Concurrency@@UEAA@XZ ??1FairScheduleGroup@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 81 C1 C0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4B 20 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_98_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 73
		refs = "000d ??_7ScheduleGroupBase@details@Concurrency@@6B@ 0021 ??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@XZ 002a ??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0037 ??3@YAXPEAX@Z"
		altNames = "??_GCacheLocalScheduleGroup@details@Concurrency@@UEAAPEAXI@Z ??_GFairScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 8B DA 48 89 01 48 81 C1 C0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4F 20 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_99_0 {
	meta:
		name = "?StealUnrealizedChore@ScheduleGroupBase@details@Concurrency@@IEAAPEAV_UnrealizedChore@23@XZ"
		size = 809
		refs = "0022 __security_cookie 00f3 ?TryToSteal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@AEA_N@Z 011d ?Steal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ 02e4 ?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IEAA_NPEAVWorkQueue@23@@Z 0304 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 70 44 8B A1 90 00 00 00 45 32 F6 48 8B D9 41 BF 01 00 00 00 45 85 E4 0F 8E F8 01 00 00 33 ED 33 F6 45 33 ED 40 88 6C 24 20 45 85 E4 0F 8E E3 01 00 00 8B 4B 74 8B D6 D3 FA 3B 93 8C 00 00 00 0F 8D E6 00 00 00 4C 63 83 88 00 00 00 48 8B 83 80 00 00 00 41 3B D0 7C 18 41 2B D0 4E 8B 4C C0 F8 78 15 8D 4A 01 49 2B CF 4D 8B 49 08 75 F7 EB 07 48 63 CA 4C 8B 0C C8 8B 43 70 41 2B C7 48 63 C8 48 63 C6 48 23 C8 49 8B 01 48 8B 3C C8 48 85 FF 0F 84 95 00 00 00 8B 4F 04 8B 07 3B C8 7F 1E 8B 8F A4 00 00 00 8B 87 A0 00 00 00 3B C8 7F 0E 8B 87 80 00 00 00 41 3B C7 0F 94 C0 EB 6B 48 8D 54 24 20 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 0F 85 FB 01 00 00 38 44 24 20 75 24 49 83 FD 0F 7D 0D 42 89 74 AC 30 41 03 EF 4D 03 EF EB 3F 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 0F 85 D1 01 00 00 8B 87 80 00 00 00 41 3B C7 75 1E 8B 4F 04 8B 07 3B C8 7F 15 8B 8F A4 00 00 00 8B 87 A0 00 00 00 3B C8 7F 05 41 8B C7 EB 02 33 C0 44 0A F0 41 03 F7 41 3B F4 0F 8C FB FE FF FF 85 ED 0F 8E D6 00 00 00 48 63 ED 33 F6 48 85 ED 0F 8E C8 00 00 00 8B 54 B4 30 8B 4B 74 D3 FA 3B 93 8C 00 00 00 0F 8D A7 00 00 00 4C 63 83 88 00 00 00 48 8B 83 80 00 00 00 41 3B D0 7C 18 41 2B D0 4E 8B 4C C0 F8 78 15 8D 4A 01 49 2B CF 4D 8B 49 08 75 F7 EB 07 48 63 CA 4C 8B 0C C8 8B 43 70 41 2B C7 48 63 C8 48 63 44 B4 30 48 23 C8 49 8B 01 48 8B 3C C8 48 85 FF 74 58 8B 0F 8B 47 04 3B C1 7F 10 8B 8F A4 00 00 00 8B 87 A0 00 00 00 3B C8 7E 11 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 0F 85 F3 00 00 00 8B 87 80 00 00 00 41 3B C7 75 1E 8B 0F 8B 47 04 3B C1 7F 15 8B 8F A4 00 00 00 8B 87 A0 00 00 00 3B C8 7F 05 41 8B C7 EB 02 33 C0 44 0A F0 49 03 F7 48 3B F5 0F 8C 38 FF FF FF 8B 83 30 01 00 00 85 C0 0F 8E A9 00 00 00 45 84 F6 0F 84 A0 00 00 00 8B 83 90 00 00 00 33 FF 85 C0 0F 8E 90 00 00 00 8B 4B 74 8B D7 D3 FA 3B 93 8C 00 00 00 7D 70 4C 63 8B 88 00 00 00 48 8B 83 80 00 00 00 41 3B D1 7C 18 41 2B D1 4E 8B 44 C8 F8 78 15 8D 4A 01 49 2B CF 4D 8B 40 08 75 F7 EB 07 48 63 CA 4C 8B 04 C8 8B 43 70 41 2B C7 48 63 C8 48 63 C7 48 23 C8 49 8B 00 48 8B 14 C8 48 85 D2 74 23 8B 82 80 00 00 00 41 3B C7 75 18 8B 8A A4 00 00 00 8B 82 A0 00 00 00 3B C8 7F 08 48 8B CB E8 ?? ?? ?? ?? 8B 83 90 00 00 00 41 03 FF 3B F8 0F 8C 70 FF FF FF 33 C0 48 8B 4C 24 70 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 80 00 00 00 49 8B 5B 38 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_184_100_0 {
	meta:
		name = "?HasUnrealizedChores@ScheduleGroupBase@details@Concurrency@@IEAA_NXZ"
		size = 197
		refs = "00a0 ?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IEAA_NPEAVWorkQueue@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 81 90 00 00 00 33 FF 48 8B D9 85 C0 0F 8E 97 00 00 00 8B 4B 74 8B D7 D3 FA 3B 93 8C 00 00 00 7D 78 4C 63 83 88 00 00 00 48 8B 83 80 00 00 00 41 3B D0 7C 18 41 2B D0 4E 8B 4C C0 F8 78 15 8D 4A 01 48 FF C9 4D 8B 49 08 75 F7 EB 07 48 63 CA 4C 8B 0C C8 8B 43 70 FF C8 48 63 C8 48 63 C7 48 23 C8 49 8B 01 48 8B 14 C8 48 85 D2 74 2C 8B 4A 04 8B 02 3B C8 7F 40 8B 8A A4 00 00 00 8B 82 A0 00 00 00 3B C8 7F 30 8B 82 80 00 00 00 83 F8 01 75 08 48 8B CB E8 ?? ?? ?? ?? 8B 83 90 00 00 00 FF C7 3B F8 0F 8C 69 FF FF FF 32 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 B0 01 EB F1 }
	condition:
		$1
}

rule file_184_101_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVWorkQueue@23@H_N@Z"
		size = 320
		refs = "00b0 __imp_QueryDepthSList 00c8 __imp_InterlockedPushEntrySList 00e5 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 00fc __imp_InterlockedFlushSList 010b ?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z 0117 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 48 83 EC 30 48 8B D9 8B 49 54 BD 01 00 00 00 44 8B 5B 50 45 8B D0 48 8B F2 44 2B DD 41 D3 FA 45 23 D8 44 3B 53 6C 0F 8D F1 00 00 00 48 8B 43 60 44 3B 53 68 7C 1F 48 63 4B 68 4C 8B 44 C8 F8 78 1B 44 2B 53 68 42 8D 44 15 00 48 2B C5 4D 8B 40 08 75 F7 EB 07 49 63 CA 4C 8B 04 C8 49 8B 10 48 89 74 24 50 49 63 CB 48 8B 44 24 50 45 33 E4 F0 4C 0F B1 24 CA 48 89 44 24 20 48 8B 4C 24 20 48 8B 44 24 50 48 3B C8 0F 85 90 00 00 00 41 8D 44 24 FE F0 45 0F B1 58 10 45 84 C9 74 7B 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 56 20 44 0F B7 D8 44 3B 5B 74 7E 5B 48 8D 4B 10 FF 15 ?? ?? ?? ?? 48 8D 4B 10 FF 15 ?? ?? ?? ?? 44 0F B7 D8 44 3B 5B 74 7E 46 48 8B 4B 48 E8 ?? ?? ?? ?? 84 C0 75 39 33 C0 F0 0F B1 6B 78 75 30 48 8D 4B 10 FF 15 ?? ?? ?? ?? 4C 8B 4B 48 48 8D 4B 28 48 8D 15 ?? ?? ?? ?? 4C 8B C3 48 89 43 20 E8 ?? ?? ?? ?? EB 09 48 8B CB FF 15 ?? ?? ?? ?? 40 8A C5 EB 02 32 C0 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_184_103_0 {
	meta:
		name = "?RetireDetachedQueue@ScheduleGroupBase@details@Concurrency@@QEAAXPEAVWorkQueue@23@@Z"
		size = 73
		refs = "0018 ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVWorkQueue@23@H_N@Z 003f ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AEAAXPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 44 8B 82 94 00 00 00 48 8B D9 41 B1 01 48 83 C1 20 E8 ?? ?? ?? ?? F6 83 BC 00 00 00 04 75 1E 83 C8 FF F0 0F C1 83 B4 00 00 00 FF C8 75 0F 48 8B 8B A0 00 00 00 48 8B D3 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "_ftelli64_nolock"
		size = 751
		refs = "001e __chkstk 0028 __security_cookie 003b _fileno 0056 _lseeki64 007f __ImageBase 0087 __pioinfo 0129 __imp_ReadFile 0191 _lookuptrailbytes 01e2 _errno 02ca __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 B8 50 10 00 00 E8 ?? ?? ?? ?? 48 2B E0 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 10 00 00 48 8B E9 E8 ?? ?? ?? ?? 33 DB 4C 63 E0 39 5D 08 7D 03 89 5D 08 33 D2 41 8B CC 44 8D 42 01 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 79 09 48 83 C8 FF E9 53 02 00 00 8B 55 18 4D 8B EC 4D 8B FC 49 C1 FF 05 41 83 E5 1F 48 8D 05 ?? ?? ?? ?? 4A 8B 8C F8 ?? ?? ?? ?? 4D 6B ED 58 45 8A 74 0D 38 45 02 F6 41 D0 FE F7 C2 08 01 00 00 75 0F 48 63 45 08 48 2B F0 48 8B C6 E9 0D 02 00 00 48 8B 7D 00 48 2B 7D 10 F6 C2 03 0F 84 1B 01 00 00 41 80 FE 01 0F 85 E5 00 00 00 41 39 5C 0D 48 0F 84 DA 00 00 00 48 D1 EF 39 5D 08 74 CA 49 8B 54 0D 40 45 33 C0 41 8B CC E8 ?? ?? ?? ?? 48 8D 2D ?? ?? ?? ?? 4A 8B 8C FD ?? ?? ?? ?? 48 8B D8 49 3B 44 0D 40 0F 85 56 FF FF FF 49 8B 4C 0D 00 48 83 64 24 20 00 4C 8D 4C 24 30 48 8D 54 24 40 41 B8 00 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2D FF FF FF 45 33 C0 48 8B D6 41 8B CC E8 ?? ?? ?? ?? 48 85 C0 0F 88 16 FF FF FF 8B 44 24 30 48 3B F8 0F 87 09 FF FF FF 48 8D 4C 24 40 48 85 FF 74 3D 48 8D 54 04 40 48 FF CF 48 3B CA 73 30 80 39 0D 75 14 48 8D 42 FF 48 3B C8 73 1A 80 79 01 0A 75 14 48 FF C1 EB 0F 0F B6 01 48 0F BE 84 28 ?? ?? ?? ?? 48 03 C8 48 FF C1 48 85 FF 75 C8 48 8D 44 24 40 48 2B C8 48 8D 04 0B E9 0D 01 00 00 41 F6 44 0D 08 80 74 17 48 8B 45 10 EB 0B 80 38 0A 75 03 48 FF C7 48 FF C0 48 3B 45 00 72 EF 48 85 F6 75 1C 48 8B C7 E9 E1 00 00 00 84 D2 78 EF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 71 FE FF FF F6 C2 01 0F 84 B7 00 00 00 39 5D 08 75 08 48 8B FB E9 AA 00 00 00 48 63 5D 08 48 2B 5D 10 48 03 5D 00 41 F6 44 0D 08 80 0F 84 86 00 00 00 33 D2 41 8B CC 44 8D 42 02 E8 ?? ?? ?? ?? 48 3B C6 75 23 48 8B 45 10 48 8D 0C 18 EB 0B 80 38 0A 75 03 48 FF C3 48 FF C0 48 3B C1 72 F0 F7 45 18 00 20 00 00 EB 4B 45 33 C0 48 8B D6 41 8B CC E8 ?? ?? ?? ?? 48 85 C0 0F 88 F6 FD FF FF B8 00 02 00 00 48 3B D8 77 11 F6 45 18 08 74 0B F7 45 18 00 04 00 00 8B D8 74 04 48 63 5D 24 48 8D 2D ?? ?? ?? ?? 4A 8B 84 FD ?? ?? ?? ?? 41 F6 44 05 08 04 74 03 48 FF C3 41 80 FE 01 75 03 48 D1 EB 48 2B F3 41 80 FE 01 75 03 48 D1 EF 48 8D 04 37 48 8B 8C 24 40 10 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 50 10 00 00 49 8B 5B 38 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "_ftelli64"
		size = 91
		refs = "001f _errno 002a _invalid_parameter_noinfo 0035 _lock_file 003e _ftelli64_nolock 0049 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 10 48 89 4C 24 08 57 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 1C E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "_ftelli64$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_fseeki64$fin$0 clearerr_s$fin$0 fclose$fin$0 fflush$fin$0 fgetc$fin$0 fgetwc$fin$0 fseek$fin$0 ftell$fin$0 getc$fin$0 rewind$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_866_35_0 {
	meta:
		name = "__CxxExceptionFilter$fin$0"
		size = 26
		refs = "000e _SetImageBase"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_186_8_0 {
	meta:
		name = "_vcwprintf_l"
		size = 2800
		refs = "0022 __security_cookie 0061 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0073 _errno 007e _invalid_parameter_noinfo 00f2 __lookuptable 0221 __nullstring 0229 strlen 0285 _isleadbyte_l 032f _mbtowc_l 03f3 __wnullstring 047d _get_printf_count_output 05fc _malloc_crt 0622 _cfltcvt_tab 063c __imp_DecodePointer 0730 write_multi_char 0741 write_string 07a1 _putwch_nolock 0821 free 0874 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 30 FC FF FF 48 81 EC D0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 C0 03 00 00 33 C0 48 89 4C 24 78 48 8D 4D 90 4D 8B F0 4C 89 44 24 50 89 44 24 70 44 8B E0 89 44 24 58 8B F8 89 44 24 48 89 44 24 4C 89 44 24 6C 89 44 24 44 E8 ?? ?? ?? ?? 4C 8B 44 24 78 45 33 D2 4D 85 C0 75 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 45 33 DB 44 38 5D A8 74 0B 48 8B 45 A0 83 A0 C8 00 00 00 FD 83 C8 FF E9 CB 07 00 00 45 0F B7 28 41 8B F2 44 89 54 24 40 45 8B FA 41 8B D2 4C 89 55 88 66 45 85 ED 0F 84 98 07 00 00 48 8B 5D B0 B9 58 00 00 00 41 B9 00 02 00 00 44 8D 59 C8 49 83 C0 02 4C 89 44 24 78 85 F6 0F 88 74 07 00 00 41 0F B7 C5 66 41 2B C3 66 3B C1 77 15 48 8D 0D ?? ?? ?? ?? 41 0F B7 C5 0F BE 4C 08 E0 83 E1 0F EB 03 41 8B CA 48 63 C2 48 63 C9 48 8D 14 C8 48 8D 05 ?? ?? ?? ?? 0F BE 14 02 C1 FA 04 89 54 24 5C 8B CA 85 D2 0F 84 52 08 00 00 FF C9 0F 84 8D 09 00 00 FF C9 0F 84 25 09 00 00 FF C9 0F 84 D2 08 00 00 FF C9 0F 84 BD 08 00 00 FF C9 0F 84 71 08 00 00 FF C9 0F 84 36 07 00 00 FF C9 0F 85 DE 06 00 00 41 0F B7 C5 B9 64 00 00 00 3B C1 0F 8F 0E 02 00 00 0F 84 2D 03 00 00 83 F8 41 0F 84 CC 01 00 00 83 F8 43 0F 84 51 01 00 00 83 F8 45 0F 84 BA 01 00 00 83 F8 47 0F 84 B1 01 00 00 83 F8 53 0F 84 8C 00 00 00 83 F8 58 0F 84 77 02 00 00 83 F8 5A 74 17 83 F8 61 0F 84 9C 01 00 00 83 F8 63 0F 84 22 01 00 00 E9 D4 00 00 00 49 8B 06 49 83 C6 08 4C 89 74 24 50 48 85 C0 74 3F 48 8B 58 08 48 85 DB 74 36 BF 2D 00 00 00 41 0F BA E4 0B 73 19 0F BF 00 44 8D 6F D4 99 44 89 6C 24 44 2B C2 D1 F8 44 8B F8 E9 9F 00 00 00 44 0F BF 38 45 8B EA 44 89 54 24 44 E9 8E 00 00 00 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 4C 8B F8 EB 6D 41 F7 C4 30 08 00 00 75 03 45 0B E3 83 7C 24 48 FF 49 8B 1E B8 FF FF FF 7F 0F 44 F8 49 83 C6 08 4C 89 74 24 50 45 84 E3 0F 84 83 01 00 00 48 85 DB 45 8B FA 48 0F 44 1D ?? ?? ?? ?? 48 8B F3 85 FF 7E 26 44 38 16 74 21 0F B6 0E 48 8D 55 90 E8 ?? ?? ?? ?? 45 33 D2 85 C0 74 03 48 FF C6 41 FF C7 48 FF C6 44 3B FF 7C DA 8B 74 24 40 44 8B 6C 24 44 BF 2D 00 00 00 44 39 54 24 6C 0F 85 57 05 00 00 41 F6 C4 40 0F 84 4A 04 00 00 41 0F BA E4 08 0F 83 11 04 00 00 66 89 7C 24 64 BF 01 00 00 00 89 7C 24 4C E9 30 04 00 00 41 F7 C4 30 08 00 00 75 03 45 0B E3 41 0F B7 06 49 83 C6 08 41 BD 01 00 00 00 66 89 44 24 60 44 89 6C 24 44 4C 89 74 24 50 45 84 E3 74 34 88 44 24 68 48 8B 45 90 44 88 54 24 69 4C 63 80 0C 01 00 00 4C 8D 4D 90 48 8D 54 24 68 48 8D 4D C0 E8 ?? ?? ?? ?? 45 33 D2 85 C0 79 0B 44 89 6C 24 6C EB 04 66 89 45 C0 48 8D 5D C0 45 8B FD E9 56 FF FF FF C7 45 80 01 00 00 00 66 45 03 EB B9 67 00 00 00 41 83 CC 40 48 8D 5D C0 41 8B F1 85 FF 0F 89 55 02 00 00 41 BF 06 00 00 00 44 89 7C 24 48 E9 98 02 00 00 83 F8 65 0F 8C 15 FF FF FF B9 67 00 00 00 3B C1 7E CB B9 69 00 00 00 3B C1 0F 84 06 01 00 00 83 F8 6E 0F 84 C4 00 00 00 B9 6F 00 00 00 3B C1 0F 84 A1 00 00 00 83 F8 70 74 61 83 F8 73 0F 84 7A FE FF FF B9 75 00 00 00 3B C1 0F 84 D9 00 00 00 B9 78 00 00 00 3B C1 0F 85 C1 FE FF FF 8D 41 AF EB 48 48 85 DB 41 BD 01 00 00 00 48 0F 44 1D ?? ?? ?? ?? 44 89 6C 24 44 48 8B C3 EB 0C FF CF 66 44 39 10 74 08 48 83 C0 02 85 FF 75 F0 48 2B C3 48 D1 F8 44 8B F8 E9 88 FE FF FF BF 10 00 00 00 41 0F BA EC 0F B8 07 00 00 00 89 44 24 70 41 B9 10 00 00 00 41 BD 00 02 00 00 45 84 E4 79 76 41 8D 49 20 66 83 C0 51 8D 51 D2 66 89 4C 24 64 66 89 44 24 66 EB 63 41 B9 08 00 00 00 45 84 E4 79 4E 41 BD 00 02 00 00 45 0B E5 EB 49 49 8B 3E 49 83 C6 08 4C 89 74 24 50 E8 ?? ?? ?? ?? 45 33 D2 85 C0 0F 84 E6 FB FF FF 45 8D 5A 20 45 84 E3 74 05 66 89 37 EB 02 89 37 C7 44 24 6C 01 00 00 00 E9 6B 03 00 00 41 83 CC 40 41 B9 0A 00 00 00 41 BD 00 02 00 00 8B 54 24 4C B8 00 80 00 00 44 85 E0 74 09 4D 8B 06 49 83 C6 08 EB 39 41 0F BA E4 0C 72 F0 49 83 C6 08 45 84 E3 74 19 4C 89 74 24 50 41 F6 C4 40 74 07 4D 0F BF 46 F8 EB 1C 45 0F B7 46 F8 EB 15 41 F6 C4 40 74 06 4D 63 46 F8 EB 04 45 8B 46 F8 4C 89 74 24 50 41 F6 C4 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EC 08 44 85 E0 75 0A 41 0F BA E4 0C 72 03 45 8B C0 85 FF 79 07 BF 01 00 00 00 EB 0B 41 83 E4 F7 41 3B FD 41 0F 4F FD 8B 74 24 70 49 8B C0 48 8D 9D BF 01 00 00 48 F7 D8 1B C9 23 CA 89 4C 24 4C 8B CF FF CF 85 C9 7F 05 4D 85 C0 74 1F 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 02 03 C6 88 03 48 FF CB EB D4 8B 74 24 40 48 8D 85 BF 01 00 00 89 7C 24 48 2B C3 48 FF C3 44 8B F8 45 85 E5 0F 84 F7 FC FF FF 85 C0 B8 30 00 00 00 74 08 38 03 0F 84 E6 FC FF FF 48 FF CB 41 FF C7 88 03 E9 D9 FC FF FF 75 11 66 44 3B E9 75 41 41 BF 01 00 00 00 E9 9E FD FF FF 41 3B F9 41 BF A3 00 00 00 41 0F 4F F9 89 7C 24 48 41 3B FF 7E 27 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 48 89 45 88 48 85 C0 0F 84 6D FD FF FF 48 8B D8 8B F7 44 8B 7C 24 48 EB 03 44 8B FF 49 8B 06 48 8B 0D ?? ?? ?? ?? 49 83 C6 08 4C 89 74 24 50 41 0F BE FD 48 63 F6 48 89 45 B0 FF 15 ?? ?? ?? ?? 48 8D 4D 90 48 89 4C 24 30 8B 4D 80 44 8B CF 89 4C 24 28 48 8D 4D B0 4C 8B C6 48 8B D3 44 89 7C 24 20 FF D0 41 8B FC 81 E7 80 00 00 00 74 1B 45 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 90 48 8B CB FF D0 B9 67 00 00 00 66 44 3B E9 75 1A 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 90 48 8B CB FF D0 BF 2D 00 00 00 40 38 3B 75 08 41 0F BA EC 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 8B 74 24 40 44 8B 6C 24 44 44 8B F8 45 33 D2 E9 CF FB FF FF 41 F6 C4 01 74 0F B8 2B 00 00 00 66 89 44 24 64 E9 DF FB FF FF 41 F6 C4 02 74 13 B8 20 00 00 00 66 89 44 24 64 8D 78 E1 89 7C 24 4C EB 09 8B 7C 24 4C B8 20 00 00 00 44 8B 74 24 58 45 2B F7 44 2B F7 41 F6 C4 0C 75 0F 4C 8D 44 24 40 8B C8 41 8B D6 E8 ?? ?? ?? ?? 4C 8D 44 24 40 48 8D 4C 24 64 8B D7 E8 ?? ?? ?? ?? 41 F6 C4 08 74 18 41 F6 C4 04 75 12 4C 8D 44 24 40 B9 30 00 00 00 41 8B D6 E8 ?? ?? ?? ?? 45 85 ED 75 67 45 85 FF 7E 62 48 8B FB 41 8B F7 48 8B 45 90 4C 8D 4D 90 48 8D 4C 24 60 4C 63 80 0C 01 00 00 48 8B D7 FF CE E8 ?? ?? ?? ?? 45 33 D2 4C 63 E8 85 C0 7E 2B 0F B7 4C 24 60 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 07 83 4C 24 40 FF EB 04 FF 44 24 40 49 03 FD 45 33 D2 85 F6 7F AF EB 1C 83 CE FF 89 74 24 40 EB 17 4C 8D 44 24 40 41 8B D7 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 8B 74 24 40 85 F6 78 1F 41 F6 C4 04 74 19 4C 8D 44 24 40 B9 20 00 00 00 41 8B D6 E8 ?? ?? ?? ?? 8B 74 24 40 45 33 D2 4C 8B 74 24 50 41 BB 20 00 00 00 48 8B 45 88 48 85 C0 74 13 48 8B C8 E8 ?? ?? ?? ?? 45 33 D2 45 8D 5A 20 4C 89 55 88 8B 54 24 5C 4C 8B 44 24 78 8B 7C 24 48 41 B9 00 02 00 00 B9 58 00 00 00 45 0F B7 28 66 45 85 ED 0F 85 7B F8 FF FF 44 38 55 A8 74 0B 48 8B 4D A0 83 A1 C8 00 00 00 FD 8B C6 48 8B 8D C0 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 18 05 00 00 48 81 C4 D0 04 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 41 0F B7 C5 83 F8 49 74 49 83 F8 68 74 3C B9 6C 00 00 00 3B C1 74 11 B9 58 00 00 00 83 F8 77 75 94 41 0F BA EC 0B EB 8D 66 41 39 08 B9 58 00 00 00 75 0E 49 83 C0 02 41 0F BA EC 0C E9 74 FF FF FF 41 83 CC 10 E9 6B FF FF FF 45 0B E3 E9 5E FF FF FF 41 0F BA EC 0F 66 41 83 38 36 75 16 66 41 83 78 02 34 75 0E 49 83 C0 04 41 0F BA EC 0F E9 3C FF FF FF 66 41 83 38 33 75 16 66 41 83 78 02 32 75 0E 49 83 C0 04 41 0F BA F4 0F E9 1F FF FF FF B8 64 00 00 00 66 41 39 00 0F 84 10 FF FF FF B8 69 00 00 00 66 41 39 00 0F 84 01 FF FF FF B8 6F 00 00 00 66 41 39 00 0F 84 F2 FE FF FF B8 75 00 00 00 8D 48 E3 66 41 39 00 0F 84 E5 FE FF FF 8D 41 20 66 41 39 00 0F 84 D8 FE FF FF 66 41 39 08 0F 84 CE FE FF FF 44 89 54 24 5C 41 0F B7 CD C7 44 24 44 01 00 00 00 E8 ?? ?? ?? ?? 4C 8B 44 24 78 8B 54 24 5C B9 FF FF 00 00 41 BB 20 00 00 00 41 B9 00 02 00 00 66 3B C1 41 8D 4B 38 0F 85 32 01 00 00 83 CE FF 89 74 24 40 45 33 D2 E9 82 FE FF FF 66 41 83 FD 2A 75 29 41 8B 3E 49 83 C6 08 B9 58 00 00 00 4C 89 74 24 50 89 7C 24 48 85 FF 0F 89 5E FE FF FF 83 CF FF 89 7C 24 48 E9 52 FE FF FF 8D 0C BF 41 0F B7 C5 8D 7C 48 D0 89 7C 24 48 E9 39 FE FF FF 41 8B FA 44 89 54 24 48 E9 2C FE FF FF 66 41 83 FD 2A 75 2C 41 8B 06 49 83 C6 08 B9 58 00 00 00 4C 89 74 24 50 89 44 24 58 85 C0 0F 89 0D FE FF FF 41 83 CC 04 F7 D8 89 44 24 58 E9 FE FD FF FF 8B 44 24 58 8D 0C 80 41 0F B7 C5 8D 44 48 D0 89 44 24 58 E9 E1 FD FF FF 41 0F B7 C5 41 3B C3 74 4E 83 F8 23 74 3F B9 2B 00 00 00 3B C1 74 2D B9 2D 00 00 00 3B C1 74 1B B9 30 00 00 00 3B C1 B9 58 00 00 00 0F 85 B4 FD FF FF 41 83 CC 08 E9 AB FD FF FF 41 83 CC 04 E9 9D FD FF FF 41 83 CC 01 E9 94 FD FF FF 41 0F BA EC 07 E9 8A FD FF FF 41 83 CC 02 E9 81 FD FF FF 83 CF FF 44 89 55 80 44 89 54 24 6C 44 89 54 24 58 44 89 54 24 4C 45 8B E2 89 7C 24 48 44 89 54 24 44 E9 5A FD FF FF FF C6 E9 CA FE FF FF }
	condition:
		$1
}

rule file_187_10_0 {
	meta:
		name = "?SwitchTo@UMSFreeThreadProxy@details@Concurrency@@UEAAXPEAUIExecutionContext@3@W4SwitchingProxyState@3@@Z"
		size = 221
		refs = "0025 ??_C@_08BAFMHLII@pContext?$AA@ 0036 ??0exception@std@@QEAA@AEBQEBD@Z 003d ??_7invalid_argument@std@@6B@ 0044 _TI3?AVinvalid_argument@std@@ 0053 _CxxThrowException 00d9 ?InternalSwitchTo@UMSThreadProxy@details@Concurrency@@IEAAXPEAV123@W4SwitchingProxyState@3@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 6B 18 49 89 73 20 57 48 83 EC 40 41 8B E8 48 8B DA 48 8B F9 48 85 D2 75 36 48 8D 05 ?? ?? ?? ?? 49 8D 53 10 49 8D 4B D8 49 89 43 10 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 01 FF 50 20 48 8B 47 38 33 F6 48 3B 98 A0 00 00 00 75 04 33 DB EB 08 48 8B 47 38 48 8B 70 38 48 8B 07 48 8B CF FF 50 28 33 D2 48 85 DB 74 34 48 8B 03 48 8B CB FF 50 10 48 85 C0 74 06 48 8D 50 F8 EB 02 33 D2 48 85 D2 75 19 48 8B 06 48 8B D3 48 8B CE FF 50 38 48 85 C0 74 06 48 8D 50 F8 EB 02 33 D2 48 8D 4F F8 44 8B C5 48 8B 5C 24 50 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_14_0 {
	meta:
		name = "?Dispatch@UMSFreeThreadProxy@details@Concurrency@@EEAAXXZ"
		size = 123
		refs = "0039 __imp_TlsSetValue 0065 ?FreeViaExit@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 8B 41 78 83 64 24 34 00 48 8B F9 C7 44 24 30 08 00 00 00 85 C0 75 48 48 8B 49 18 48 8B DF 48 8B 01 48 83 CB 02 FF 50 20 48 8B D3 8B C8 FF 15 ?? ?? ?? ?? EB 2A 48 8B 8F 00 01 00 00 C6 47 58 00 48 8D 54 24 30 48 8B 01 FF 50 20 80 7F 58 00 74 06 C6 47 58 00 EB 08 48 8B CF E8 ?? ?? ?? ?? 8B 47 78 85 C0 74 CF 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_187_15_0 {
	meta:
		name = "?AssociateExecutionContext@UMSFreeThreadProxy@details@Concurrency@@AEAAXPEAUIExecutionContext@3@@Z"
		size = 37
	strings:
		$1 = { 48 83 EC 28 4C 8B C2 48 89 91 00 01 00 00 48 85 D2 74 0D 49 8B 00 48 8D 51 08 49 8B C8 FF 50 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_187_16_0 {
	meta:
		name = "?ReturnIdleProxy@UMSFreeThreadProxy@details@Concurrency@@AEAAXXZ"
		size = 35
	strings:
		$1 = { 33 C0 C6 41 58 01 48 8D 51 08 48 89 81 8C 00 00 00 48 89 81 00 01 00 00 48 8B 49 18 48 8B 01 48 FF 60 08 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "vfwprintf_helper"
		size = 160
		refs = "0031 _errno 003c _invalid_parameter_noinfo 0055 _lock_file 005e _stbuf 007d _ftbuf 0086 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 54 24 10 57 41 54 41 55 48 83 EC 20 4D 8B E1 49 8B F0 48 8B FA 4C 8B E9 33 C0 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 47 33 C0 4D 85 C0 0F 95 C0 85 C0 74 DF 48 8B CA E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B D8 4C 8B 4C 24 60 4D 8B C4 48 8B D6 48 8B CF 41 FF D5 8B F0 48 8B D7 8B CB E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_188_2_0 {
	meta:
		name = "_vfwprintf_l"
		size = 35
		refs = "0015 _woutput_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_2_0 {
	meta:
		name = "_vfprintf_l"
		size = 35
		refs = "0015 _output_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_4_0 {
	meta:
		name = "_vfprintf_p_l"
		size = 35
		refs = "0015 _output_p_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_3_0 {
	meta:
		name = "_vfprintf_s_l"
		size = 35
		refs = "0015 _output_s_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_4_0 {
	meta:
		name = "_vfwprintf_p_l"
		size = 35
		refs = "0015 _woutput_p_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_3_0 {
	meta:
		name = "_vfwprintf_s_l"
		size = 35
		refs = "0015 _woutput_s_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_5_0 {
	meta:
		name = "vfwprintf"
		size = 35
		refs = "0012 _woutput_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_7_0 {
	meta:
		name = "_vfprintf_p"
		size = 35
		refs = "0012 _output_p_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_7_0 {
	meta:
		name = "_vfwprintf_p"
		size = 35
		refs = "0012 _woutput_p_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_5_0 {
	meta:
		name = "vfprintf"
		size = 35
		refs = "0012 _output_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_915_6_0 {
	meta:
		name = "vfprintf_s"
		size = 35
		refs = "0012 _output_s_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_6_0 {
	meta:
		name = "vfwprintf_s"
		size = 35
		refs = "0012 _woutput_s_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_chdir"
		size = 301
		refs = "0018 __security_cookie 0037 __doserrno 003e _errno 0049 _invalid_parameter_noinfo 0054 __imp_SetCurrentDirectoryA 006c __imp_GetCurrentDirectoryA 0086 _calloc_crt 00c5 _mbctoupper 00de __imp_SetEnvironmentVariableA 00ec __imp_GetLastError 00f3 _dosmaperr 00ff free 0111 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 48 81 EC 50 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 01 00 00 33 ED 83 CF FF 48 8D 5C 24 30 48 85 C9 75 1C E8 ?? ?? ?? ?? 21 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 B1 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8A 00 00 00 48 8D 54 24 30 B9 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F0 3D 04 01 00 00 7E 30 44 8D 60 01 BA 01 00 00 00 49 63 CC E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 58 BD 01 00 00 00 85 F6 74 4F 48 8B D0 41 8B CC FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 3D 8A 03 3C 5C 74 04 3C 2F 75 05 3A 43 01 74 2A C6 44 24 20 3D 0F B6 0B E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B D3 88 44 24 21 66 C7 44 24 22 3A 00 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 FF EB 0D FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 ED 74 08 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 8C 24 40 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 50 01 00 00 49 8B 5B 28 49 8B 6B 30 49 8B E3 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "_isnan"
		size = 43
	strings:
		$1 = { 48 B8 FF FF FF FF FF FF FF 7F F2 0F 11 44 24 08 48 BA 00 00 00 00 00 00 F0 7F 48 8B 4C 24 08 48 23 C8 33 C0 48 3B CA 0F 97 C0 C3 }
	condition:
		$1
}

rule file_190_1_0 {
	meta:
		name = "_isnanf"
		size = 26
	strings:
		$1 = { 33 C0 F3 0F 11 44 24 08 8B 4C 24 08 0F BA F1 1F 81 F9 00 00 80 7F 0F 97 C0 C3 }
	condition:
		$1
}

rule file_190_2_0 {
	meta:
		name = "_fpclass"
		size = 186
	strings:
		$1 = { 48 B9 FF FF FF FF FF FF 0F 00 F2 0F 11 44 24 08 48 BA 00 00 00 00 00 00 F0 7F 48 8B 44 24 08 48 85 C1 48 8B C8 74 3D 48 23 CA 48 3B CA 75 17 48 B9 00 00 00 00 00 00 08 00 48 23 C1 48 F7 D8 1B C0 F7 D8 FF C0 C3 48 85 C9 48 B9 00 00 00 00 00 00 00 80 75 43 48 23 C1 48 F7 D8 1B C0 83 E0 90 83 E8 80 C3 48 23 CA 48 3B CA 75 1D 48 B9 00 00 00 00 00 00 00 80 48 23 C1 48 F7 D8 1B C0 25 04 FE FF FF 05 00 02 00 00 C3 48 85 C9 48 B9 00 00 00 00 00 00 00 80 74 13 48 23 C1 48 F7 D8 1B C0 25 08 FF FF FF 05 00 01 00 00 C3 48 23 C1 48 F7 D8 1B C0 83 E0 E0 83 C0 40 C3 }
	condition:
		$1
}

rule file_190_3_0 {
	meta:
		name = "_fpclassf"
		size = 118
	strings:
		$1 = { F3 0F 11 44 24 08 B9 00 00 80 7F 8B 44 24 08 8B D0 23 D1 A9 FF FF 7F 00 74 26 3B D1 75 0E 25 00 00 40 00 F7 D8 1B C0 F7 D8 FF C0 C3 25 00 00 00 80 85 D2 75 27 F7 D8 1B C0 83 E0 90 83 E8 80 C3 25 00 00 00 80 3B D1 75 0F F7 D8 1B C0 25 04 FE FF FF 05 00 02 00 00 C3 85 D2 74 0F F7 D8 1B C0 25 08 FF FF FF 05 00 01 00 00 C3 F7 D8 1B C0 83 E0 E0 83 C0 40 C3 }
	condition:
		$1
}

rule file_190_4_0 {
	meta:
		name = "_nextafter"
		size = 485
		refs = "0083 ??_C@_0L@KDOEJCKC@_nextafter?$AA@ 008d _handle_error"
	strings:
		$1 = { 48 83 EC 58 F2 0F 11 44 24 60 48 8B 4C 24 60 F2 0F 11 4C 24 60 4C 8B 44 24 60 49 3B C8 75 09 66 0F 28 C1 E9 B8 01 00 00 48 BA 00 00 00 00 00 00 F0 7F 48 8B C1 49 B9 FF FF FF FF FF FF 0F 00 48 23 C2 48 3B C2 75 4F 49 85 C9 74 4A 49 B8 00 00 00 00 00 00 08 00 4C 0B C1 C7 44 24 40 02 00 00 00 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 26 00 00 00 E8 ?? ?? ?? ?? E9 4A 01 00 00 49 8B C0 48 23 C2 48 3B C2 75 14 4D 85 C1 74 0F 48 B8 00 00 00 00 00 00 08 00 4C 0B C0 EB A4 66 0F 2F C8 48 B8 00 00 00 00 00 00 00 80 76 7A 48 85 C8 74 30 48 B8 FE FF FF FF FF FF FF 7F 48 85 C8 0F 85 B0 00 00 00 80 E1 01 48 B8 FF FF FF FF FF FF FF 7F F6 D9 48 1B C9 48 23 C8 48 FF C1 E9 A2 00 00 00 48 FF C1 48 3B CA 0F 85 96 00 00 00 C7 44 24 40 02 00 00 00 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 03 00 00 00 49 B8 00 00 00 00 00 00 F0 7F C7 44 24 20 11 00 00 00 E9 41 FF FF FF 48 85 C8 74 44 48 FF C1 48 B8 00 00 00 00 00 00 F0 FF 48 3B C8 75 46 C7 44 24 40 02 00 00 00 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 03 00 00 00 4C 8B C0 C7 44 24 20 11 00 00 00 E9 F8 FE FF FF 48 85 C9 74 05 48 FF C9 EB 0A 48 B9 01 00 00 00 00 00 00 80 48 85 CA 75 34 49 85 C9 74 2F C7 44 24 40 02 00 00 00 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 83 64 24 28 00 41 B9 04 00 00 00 4C 8B C1 C7 44 24 20 12 00 00 00 E9 AB FE FF FF 48 89 4C 24 60 F2 0F 10 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_190_5_0 {
	meta:
		name = "_nextafterf"
		size = 393
		refs = "0071 ??_C@_0M@LNMOKHH@_nextafterf?$AA@ 007b _handle_errorf"
	strings:
		$1 = { 48 83 EC 58 F3 0F 11 44 24 60 8B 4C 24 60 F3 0F 11 4C 24 60 8B 54 24 60 3B CA 75 08 0F 28 C1 E9 60 01 00 00 41 B8 00 00 80 7F 8B C1 41 B9 FF FF 7F 00 41 23 C0 41 3B C0 75 4A 41 85 C9 74 45 4C 8B C1 C7 44 24 40 02 00 00 00 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 49 0F BA E8 16 83 64 24 20 00 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 26 00 00 00 E8 ?? ?? ?? ?? E9 00 01 00 00 8B C2 41 23 C0 41 3B C0 75 0A 41 85 D1 74 05 4C 8B C2 EB AA 0F 2F C8 76 58 85 C9 79 1E F7 C1 FE FF FF 7F 0F 85 8B 00 00 00 80 E1 01 F6 D9 1B C9 0F BA F1 1F FF C1 E9 82 00 00 00 FF C1 41 3B C8 75 7B C7 44 24 40 02 00 00 00 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 03 00 00 00 C7 44 24 20 11 00 00 00 E9 79 FF FF FF 85 C9 79 3D FF C1 B8 00 00 80 FF 3B C8 75 3D C7 44 24 40 02 00 00 00 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 03 00 00 00 44 8B C0 C7 44 24 20 11 00 00 00 E9 38 FF FF FF 74 04 FF C9 EB 05 B9 01 00 00 80 41 85 C8 75 34 41 85 C9 74 2F C7 44 24 40 02 00 00 00 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 83 64 24 28 00 44 8B C1 41 B9 04 00 00 00 C7 44 24 20 12 00 00 00 E9 F4 FE FF FF 89 4C 24 60 F3 0F 10 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_190_6_0 {
	meta:
		name = "_scalb"
		size = 476
		refs = "0099 ??_C@_06HBLGGACK@_scalb?$AA@ 00a3 _handle_error"
	strings:
		$1 = { 40 53 48 83 EC 50 F2 0F 11 44 24 60 48 B8 00 00 00 00 00 00 00 80 66 0F 28 C8 4C 8B 44 24 60 4D 8B D0 4C 23 D0 4D 3B C2 0F 84 A8 01 00 00 48 BB 00 00 00 00 00 00 F0 7F 49 8B C8 48 23 CB 48 3B CB 75 69 49 BB FF FF FF FF FF FF 0F 00 4D 85 C3 0F 84 75 01 00 00 C7 44 24 40 02 00 00 00 66 0F EF C0 48 B8 00 00 00 00 00 00 08 00 F2 48 0F 2A C2 4C 0B C0 45 33 C9 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 44 89 4C 24 20 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 19 00 00 00 E8 ?? ?? ?? ?? E9 2A 01 00 00 81 FA 00 00 00 80 75 08 4D 8B C2 E9 0F 01 00 00 45 33 C9 85 D2 0F 84 04 01 00 00 49 BB FF FF FF FF FF FF 0F 00 48 C1 E9 34 4D 23 C3 49 8B C0 85 D2 79 3F F7 DA 48 63 C2 48 3B C1 76 26 48 2B C1 48 83 F8 34 73 C2 48 85 C9 74 0D 48 B9 00 00 00 00 00 00 10 00 4C 0B C1 8D 48 01 49 D3 E8 E9 B9 00 00 00 48 2B C8 48 C1 E1 34 4C 0B C1 E9 AA 00 00 00 48 85 C9 0F 85 8B 00 00 00 4D 03 C0 48 B9 00 00 00 00 00 00 F0 FF 41 FF C1 4C 85 C1 74 EB 41 3B D1 7C 67 41 8D 81 FE 07 00 00 3B D0 7D 1E 49 63 C1 48 63 CA 48 2B C8 49 8B C0 48 FF C1 49 23 C3 48 C1 E1 34 4C 8B C1 4C 0B C0 EB 5E C7 44 24 40 02 00 00 00 66 0F EF C0 4C 0B D3 F2 48 0F 2A C2 41 B9 03 00 00 00 4D 8B C2 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 E9 EE FE FF FF 8B CA 4C 8B C0 49 D3 E0 EB 16 4C 63 CA 4C 03 C9 49 81 F9 FF 07 00 00 73 A9 49 C1 E1 34 4D 0B C1 4D 0B C2 4C 89 44 24 60 F2 0F 10 44 24 60 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_190_7_0 {
	meta:
		name = "_scalbf"
		size = 414
		refs = "007f ??_C@_07OIGNLDJH@_scalbf?$AA@ 0089 _handle_errorf"
	strings:
		$1 = { 40 53 48 83 EC 50 0F 28 C8 B8 00 00 00 80 F3 0F 11 4C 24 60 44 8B 44 24 60 45 8B C8 44 23 C8 45 3B C1 75 05 E9 6F 01 00 00 BB 00 00 80 7F 41 8B C8 23 CB 3B CB 75 5B 41 BB FF FF 7F 00 45 85 C3 0F 84 47 01 00 00 C7 44 24 40 02 00 00 00 66 0F EF C0 49 0F BA E8 16 45 33 D2 F3 48 0F 2A C2 45 8D 4A 01 F3 0F 11 44 24 38 F3 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 44 89 54 24 20 48 8D 0D ?? ?? ?? ?? BA 19 00 00 00 E8 ?? ?? ?? ?? E9 06 01 00 00 3B D0 75 08 45 8B C1 E9 EF 00 00 00 45 33 D2 85 D2 0F 84 E4 00 00 00 41 BB FF FF 7F 00 C1 E9 17 45 23 C3 41 8B C0 85 D2 79 2E F7 DA 3B D1 7E 1B 2B D1 83 FA 17 7D CD 85 C9 74 05 41 0F BA E8 17 8D 4A 01 41 D3 E8 E9 AD 00 00 00 C1 E1 17 C1 E2 17 2B CA E9 9D 00 00 00 85 C9 0F 85 83 00 00 00 45 03 C0 41 FF C2 41 F7 C0 00 00 80 FF 74 F1 41 3B D2 7C 65 41 8D 82 FE 00 00 00 3B D0 7D 1C C1 E2 17 41 8B C0 41 C1 E2 17 41 2B D2 41 23 C3 44 8D 82 00 00 80 00 44 0B C0 EB 5D C7 44 24 40 02 00 00 00 45 8B C1 66 0F EF C0 F3 48 0F 2A C2 4C 0B C3 41 B9 03 00 00 00 F3 0F 11 44 24 38 F3 0F 11 4C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 E9 11 FF FF FF 8B CA 44 8B C0 41 D3 E0 EB 15 8D 04 11 3D FF 00 00 00 7D AE C1 E1 17 C1 E2 17 03 CA 44 0B C1 45 0B C1 44 89 44 24 60 F3 0F 10 44 24 60 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_191_3_0 {
	meta:
		name = "_mbsnextc_l"
		size = 133
		refs = "0015 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 001f _errno 002a _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B D9 48 8D 4C 24 20 33 FF E8 ?? ?? ?? ?? 48 85 DB 75 27 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 7C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 EB 35 0F B6 0B 48 8B 44 24 28 F6 44 01 1D 04 74 0E 40 38 7B 01 74 08 8B F9 C1 E7 08 48 FF C3 0F B6 03 03 C7 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "_wcsicmp_l"
		size = 258
		refs = "0022 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 002e _errno 0039 _invalid_parameter_noinfo 00ac _towlower_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 40 48 8B F1 48 8B FA 48 8D 48 D8 49 8B D0 E8 ?? ?? ?? ?? 33 ED 48 85 F6 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 6C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD B8 FF FF FF 7F E9 93 00 00 00 48 85 FF 74 CE 48 8B 44 24 20 39 68 14 75 3A 48 2B F7 0F B7 1C 3E 66 83 FB 41 72 0A 66 83 FB 5A 77 04 66 83 C3 20 0F B7 07 66 83 F8 41 72 0A 66 83 F8 5A 77 04 66 83 C0 20 48 83 C7 02 66 85 DB 74 36 66 3B D8 74 CB EB 2F 0F B7 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 0F B7 0F 48 8D 54 24 20 0F B7 D8 48 83 C6 02 E8 ?? ?? ?? ?? 48 83 C7 02 66 85 DB 74 05 66 3B D8 74 D1 0F B7 C8 0F B7 C3 2B C1 40 38 6C 24 38 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "wcomexecmd"
		size = 141
		refs = "001b _errno 0026 _invalid_parameter_noinfo 004b _wcenvarg 0064 _wdospawn 0071 free"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 4D 8B D1 49 8B C0 48 8B DA 8B F9 48 85 D2 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 52 48 85 C0 74 E5 48 89 54 24 20 4C 8D 4C 24 30 4C 8D 44 24 58 49 8B D2 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 D6 4C 8B 4C 24 30 4C 8B 44 24 58 48 8B D3 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 58 48 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_753_1_0 {
	meta:
		name = "comexecmd"
		size = 141
		refs = "001b _errno 0026 _invalid_parameter_noinfo 004b _cenvarg 0064 _dospawn 0071 free"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 4D 8B D1 49 8B C0 48 8B DA 8B F9 48 85 D2 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 52 48 85 C0 74 E5 48 89 54 24 20 4C 8D 4C 24 30 4C 8D 44 24 58 49 8B D2 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 D6 4C 8B 4C 24 30 4C 8B 44 24 58 48 8B D3 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 58 48 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_194_2_0 {
	meta:
		name = "_wspawnve"
		size = 653
		refs = "0035 _errno 0040 _invalid_parameter_noinfo 0082 wcsrchr 00af wcschr 00c3 wcslen 00d2 _calloc_crt 00e5 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 00f0 wcscpy_s 0102 wcscat_s 0120 _invoke_watson 0161 _waccess_s 017a wcomexecmd 01d6 ext_strings 0248 free"
	strings:
		$1 = { 48 89 5C 24 18 4C 89 4C 24 20 89 4C 24 08 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 FF 4D 8B E1 4D 8B F0 48 8B EA 44 8B E9 48 8B FA 48 85 D2 75 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 8B 9C 24 80 00 00 00 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 66 44 39 3A 74 CE 4D 85 C0 74 C9 49 8B 00 48 85 C0 74 C1 66 44 39 38 74 BB BA 5C 00 00 00 48 8B CD E8 ?? ?? ?? ?? BA 2F 00 00 00 48 8B CD 48 8B F0 E8 ?? ?? ?? ?? 48 85 C0 0F 85 9B 00 00 00 48 85 F6 0F 85 9F 00 00 00 8D 50 3A 48 8B CD E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 85 88 00 00 00 48 8B CD E8 ?? ?? ?? ?? 8D 56 02 48 8D 58 03 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 0F 84 62 FF FF FF 4C 8D 05 ?? ?? ?? ?? 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 2D 4C 8B C5 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 06 48 8D 77 04 EB 37 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC 48 85 F6 74 05 48 3B C6 76 03 48 8B F0 48 83 CB FF 48 8B CE 8D 53 2F E8 ?? ?? ?? ?? 48 8B CF 48 85 C0 74 28 33 D2 E8 ?? ?? ?? ?? 85 C0 0F 85 DF 00 00 00 4D 8B CC 4D 8B C6 48 8B D7 41 8B CD E8 ?? ?? ?? ?? 48 8B D8 E9 C6 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 4C 8D 60 05 49 8B CC E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 08 48 8B C3 E9 9C FE FF FF 4C 8B C7 49 8B D4 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 B6 00 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8D 3C 46 E8 ?? ?? ?? ?? 4C 8D 2D ?? ?? ?? ?? 8B 00 89 44 24 78 49 8B C7 48 2B C6 48 D1 F8 4C 2B E0 4D 8B 45 00 49 8B D4 49 8B CF E8 ?? ?? ?? ?? 85 C0 75 63 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 12 48 8D 05 ?? ?? ?? ?? 49 83 ED 08 4C 3B E8 7D CF EB 25 E8 ?? ?? ?? ?? 8B 4C 24 78 4C 8B 8C 24 88 00 00 00 89 08 8B 4C 24 70 4D 8B C6 48 8B D6 E8 ?? ?? ?? ?? 48 8B D8 48 8B CE E8 ?? ?? ?? ?? 48 3B FD 0F 84 4F FF FF FF 48 8B CF E8 ?? ?? ?? ?? E9 42 FF FF FF 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 7C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_195_3_0 {
	meta:
		name = "_wctomb_s_l"
		size = 452
		refs = "0048 _errno 0054 _invalid_parameter_noinfo 0065 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0099 memset 0158 __imp_WideCharToMultiByte 0175 __imp_GetLastError"
	strings:
		$1 = { 48 89 5C 24 08 66 44 89 4C 24 20 55 56 57 48 8B EC 48 83 EC 60 49 8B F8 48 8B F2 48 8B D9 48 85 D2 75 13 4D 85 C0 74 0E 48 85 C9 74 02 21 11 33 C0 E9 8A 00 00 00 48 85 C9 74 03 83 09 FF 49 81 F8 FF FF FF 7F 76 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 64 48 8B 55 40 48 8D 4D E0 E8 ?? ?? ?? ?? 4C 8B 5D E0 41 83 7B 14 00 0F 85 B2 00 00 00 0F B7 45 38 B9 FF 00 00 00 66 3B C1 76 4A 48 85 F6 74 12 48 85 FF 74 0D 4C 8B C7 33 D2 48 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 80 7D F8 00 8B 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 48 8B 9C 24 80 00 00 00 48 83 C4 60 5F 5E 5D C3 48 85 F6 74 30 48 85 FF 75 29 E8 ?? ?? ?? ?? 8D 5F 22 89 18 E8 ?? ?? ?? ?? 40 38 7D F8 0F 84 65 FF FF FF 48 8B 4D F0 83 A1 C8 00 00 00 FD E9 55 FF FF FF 88 06 48 85 DB 74 06 C7 03 01 00 00 00 80 7D F8 00 0F 84 15 FF FF FF 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 05 FF FF FF 83 65 28 00 41 8B 4B 04 48 8D 45 28 48 89 44 24 38 48 83 64 24 30 00 4C 8D 45 38 41 B9 01 00 00 00 33 D2 89 7C 24 28 48 89 74 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 13 83 7D 28 00 0F 85 33 FF FF FF 48 85 DB 74 A1 89 03 EB 9D FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 1B FF FF FF 48 85 F6 74 12 48 85 FF 74 0D 4C 8B C7 33 D2 48 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? 80 7D F8 00 0F 84 A4 FE FF FF 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 94 FE FF FF }
	condition:
		$1
}

rule file_195_5_0 {
	meta:
		name = "_wctomb_l"
		size = 123
		refs = "0024 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004b _wctomb_s_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 57 48 83 EC 50 48 8B F9 0F B7 DA 48 8D 48 D8 83 CE FF 49 8B D0 89 70 20 E8 ?? ?? ?? ?? 4C 8B 5C 24 30 4D 63 83 0C 01 00 00 48 8D 44 24 30 48 8D 4C 24 78 44 0F B7 CB 48 8B D7 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 44 74 24 78 80 7C 24 48 00 74 0C 48 8B 44 24 40 83 A0 C8 00 00 00 FD 48 8B 5C 24 60 8B C6 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_195_6_0 {
	meta:
		name = "wctomb"
		size = 84
		refs = "001d ___mb_cur_max_func 0037 _wctomb_s_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 83 CE FF 0F B7 DA 48 8B F9 89 74 24 50 E8 ?? ?? ?? ?? 48 83 64 24 20 00 48 8D 4C 24 50 4C 63 C0 44 0F B7 CB 48 8B D7 E8 ?? ?? ?? ?? 48 8B 5C 24 40 85 C0 0F 44 74 24 50 8B C6 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "_swab"
		size = 88
		refs = "000d _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 4C 8B C9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 83 C4 28 E9 ?? ?? ?? ?? 48 85 D2 74 E7 45 85 C0 78 E2 41 83 F8 01 7E 23 41 83 C0 FE 41 D1 E8 41 FF C0 41 8A 41 01 41 8A 09 49 83 C1 02 88 02 88 4A 01 48 83 C2 02 49 FF C8 75 E7 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "_setmaxstdio"
		size = 277
		refs = "0018 _errno 0023 _invalid_parameter_noinfo 0035 _lock 003c _nstream 0050 __piob 0055 _recalloc_crt 00bd free 0104 _unlock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 63 D9 8D 43 EC 3D EC 07 00 00 76 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 DB 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 8B 05 ?? ?? ?? ?? 3B D8 7E 44 48 8B D3 41 B8 08 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 95 00 00 00 8B 15 ?? ?? ?? ?? 89 54 24 24 3B D3 7D 0C 48 63 CA 48 83 24 C8 00 FF C2 EB EC 89 1D ?? ?? ?? ?? 89 5C 24 20 EB 66 75 08 8B D8 89 44 24 20 EB 6C 89 5C 24 20 8D 78 FF 89 7C 24 24 48 8B 0D ?? ?? ?? ?? 3B FB 7C 28 48 63 C7 48 83 3C C1 00 74 16 48 8B 0C C1 F6 41 18 83 75 3B E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? FF CF 89 7C 24 24 EB D4 83 FB FF 74 29 48 8B D3 41 B8 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 0F 89 1D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 07 83 CB FF 89 5C 24 20 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "_setmaxstdio$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_fcloseall$fin$0 _getstream$fin$0 _rmtmp$fin$1 flsall$fin$1"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__chkstk"
		size = 78
	strings:
		$1 = { 48 83 EC 10 4C 89 14 24 4C 89 5C 24 08 4D 33 DB 4C 8D 54 24 18 4C 2B D0 4D 0F 42 D3 65 4C 8B 1C 25 10 00 00 00 4D 3B D3 73 16 66 41 81 E2 00 F0 4D 8D 9B 00 F0 FF FF 41 C6 03 00 4D 3B D3 75 F0 4C 8B 14 24 4C 8B 5C 24 08 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "fgets"
		size = 359
		refs = "0024 _errno 002f _invalid_parameter_noinfo 005e _lock_file 0071 _fileno 008c __pioinfo 009e __badioinfo 011b _filbuf 0154 _unlock_file"
	strings:
		$1 = { 40 53 56 57 41 54 41 55 48 83 EC 30 49 8B D8 8B F2 4C 8B E9 4C 8B E1 48 8B F9 48 85 C9 75 1B 85 D2 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 21 01 00 00 33 C0 85 D2 0F 99 C0 85 C0 74 DE 33 C0 48 85 DB 0F 95 C0 85 C0 74 D2 85 D2 74 DE 48 89 5C 24 78 48 8B CB E8 ?? ?? ?? ?? 90 F6 43 18 40 0F 85 8A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 83 F8 FF 74 2A 83 F8 FE 74 25 48 63 D0 48 8B CA 48 C1 F9 05 4C 8D 05 ?? ?? ?? ?? 83 E2 1F 48 6B D2 58 49 03 14 C8 48 8D 0D ?? ?? ?? ?? EB 11 48 8D 0D ?? ?? ?? ?? 48 8B D1 4C 8D 05 ?? ?? ?? ?? F6 42 38 7F 75 25 83 F8 FF 74 1A 83 F8 FE 74 15 48 63 C8 48 8B C1 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C0 F6 41 38 80 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 FF 48 89 7C 24 20 48 85 FF 74 54 FF CE 89 74 24 68 74 47 FF 4B 08 78 0E 48 8B 03 0F B6 08 48 FF C0 48 89 03 EB 0A 48 8B CB E8 ?? ?? ?? ?? 8B C8 89 4C 24 60 83 F9 FF 75 0E 4D 3B E5 75 1C 33 FF 48 89 7C 24 20 EB 18 41 88 0C 24 49 FF C4 4C 89 64 24 28 80 F9 0A 74 02 EB B1 41 C6 04 24 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 83 C4 30 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "fgets$fin$0"
		size = 26
		refs = "000e _unlock_file"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 78 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_wexecv"
		size = 71
		refs = "000d _errno 0018 _invalid_parameter_noinfo 0043 _wexecve"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 48 85 C9 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 83 C4 28 C3 66 44 39 01 74 E1 48 85 D2 74 DC 48 8B 02 48 85 C0 74 D4 66 44 39 00 74 CE 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_3_0 {
	meta:
		name = "_mbsncat_l"
		size = 322
		refs = "0030 _errno 003b _invalid_parameter_noinfo 0054 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006e strncat 00a9 _ismbslead_l 00f4 _mbsbtype_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 49 8B E8 48 8B FA 48 8B D9 4D 85 C0 75 08 48 8B C1 E9 03 01 00 00 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 E7 00 00 00 48 85 D2 74 E4 48 8D 4C 24 20 49 8B D1 E8 ?? ?? ?? ?? 4C 8B 5C 24 28 41 83 7B 08 00 75 2A 4C 8B C5 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 80 7C 24 38 00 0F 84 B0 00 00 00 48 8B 4C 24 30 83 A1 C8 00 00 00 FD E9 9F 00 00 00 48 8B F3 8A 03 48 FF C3 84 C0 75 F7 48 FF CB 4C 8D 44 24 20 48 8B CE 48 8B D3 E8 ?? ?? ?? ?? 85 C0 74 03 48 FF CB 48 8B 4C 24 28 0F B6 07 48 FF CD F6 44 08 1D 04 88 03 74 3B 8A 47 01 48 83 C3 02 48 83 C7 02 88 43 FF 84 C0 75 33 88 43 FE 48 3B DE 74 32 8B C3 4C 8D 44 24 20 48 8B CE 2B C6 FF C8 48 63 D0 E8 ?? ?? ?? ?? 83 F8 01 75 17 C6 43 FF 00 EB 14 48 FF C3 48 FF C7 84 C0 74 D0 48 85 ED 74 CB EB A5 C6 03 00 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B C6 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "_spawnl"
		size = 173
		refs = "0022 _errno 002d _invalid_parameter_noinfo 0068 _capture_argv 0081 _spawnve 009b free"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 30 02 00 00 49 8B C0 48 8B DA 8B F1 48 85 D2 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 6B 80 3A 00 74 E5 48 85 C0 74 E0 41 80 38 00 74 DA 48 8D 8C 24 68 02 00 00 4C 8D 44 24 30 41 B9 40 00 00 00 48 89 4C 24 20 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 48 8B D3 8B CE 4C 8B C0 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 30 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "_make__time32_t"
		size = 701
		refs = "0010 __security_cookie 002f _errno 003a _invalid_parameter_noinfo 00ad _days 0104 __security_check_cookie 0205 __tzset 020e _get_dstbias 021b _get_timezone 0232 _localtime32_s 0273 _invoke_watson 0297 _gmtime32_s 02b1 memcpy"
	strings:
		$1 = { 48 89 5C 24 10 55 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 83 65 C8 00 83 65 C4 00 44 8B D2 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 B6 00 00 00 8B 49 14 41 B9 08 04 00 00 8D 41 BB 89 4D C0 41 3B C1 0F 87 93 00 00 00 44 8B 43 10 45 85 C0 78 06 41 83 F8 0B 7E 3C B8 AB AA AA 2A 41 F7 E8 D1 FA 8B C2 C1 E8 1F 03 D0 03 CA 8D 04 52 89 4D C0 C1 E0 02 44 2B C0 44 89 43 10 45 85 C0 79 0C 41 8D 40 0C FF C9 89 43 10 89 4D C0 8D 41 BB 41 3B C1 77 48 48 63 43 10 48 8D 15 ?? ?? ?? ?? 8B 14 82 F6 C1 03 75 08 83 7B 10 01 7E 02 FF C2 8D 41 FF 69 C9 6D 01 00 00 C1 F8 02 03 C2 8D 8C 01 21 9C FF FF 8B 43 0C 44 8D 04 01 44 89 45 C0 85 C9 78 31 85 C0 78 36 45 85 C0 79 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 88 00 00 00 48 83 C4 70 5D C3 85 C0 79 05 45 85 C0 79 CF 47 8D 0C 40 33 C9 41 C1 E1 03 45 85 C0 74 0D 41 8B C1 99 41 F7 F8 83 F8 18 0F 95 C1 85 C9 75 AF 8B 43 08 42 8D 0C 08 89 4D C0 45 85 C9 78 0A 85 C0 78 0E 85 C9 78 98 EB 08 85 C0 79 04 85 C9 79 8E 44 8B C1 45 6B C0 3C 85 C9 74 10 41 8B C0 99 F7 F9 33 C9 83 F8 3C 0F 95 C1 EB 02 33 C9 85 C9 0F 85 69 FF FF FF 8B 43 04 42 8D 0C 00 89 4D C0 45 85 C0 78 0E 85 C0 78 16 85 C9 0F 88 4E FF FF FF EB 0C 85 C0 79 08 85 C9 0F 89 40 FF FF FF 44 8B C1 45 6B C0 3C 85 C9 74 10 41 8B C0 99 F7 F9 33 C9 83 F8 3C 0F 95 C1 EB 02 33 C9 85 C9 0F 85 1B FF FF FF 8B 0B 42 8D 04 01 89 45 C0 45 85 C0 78 0E 85 C9 78 16 85 C0 0F 88 01 FF FF FF EB 0C 85 C9 79 08 85 C0 0F 89 F3 FE FF FF 45 85 D2 0F 84 8A 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D C8 E8 ?? ?? ?? ?? 85 C0 75 62 48 8D 4D C4 E8 ?? ?? ?? ?? 85 C0 75 3F 8B 45 C4 48 8D 55 C0 48 8D 4D D0 01 45 C0 E8 ?? ?? ?? ?? 85 C0 0F 85 B0 FE FF FF 8B 43 20 85 C0 7F 08 79 5C 83 7D F0 00 7E 56 8B 45 C8 48 8D 55 C0 48 8D 4D D0 01 45 C0 E8 ?? ?? ?? ?? EB 39 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8D 55 C0 48 8D 4D D0 E8 ?? ?? ?? ?? 85 C0 0F 85 4B FE FF FF 48 8D 55 D0 48 8B CB 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 8B 45 C0 E9 3F FE FF FF }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_makepath_s"
		size = 326
		refs = "0084 _mbsdec 010c _errno 012b _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F2 48 8B E9 48 85 C9 0F 84 FB 00 00 00 48 85 D2 0F 84 F2 00 00 00 33 FF 48 8B D9 4D 85 C0 74 21 41 8A 00 84 C0 74 1A BF 02 00 00 00 48 3B D7 0F 86 BC 00 00 00 48 8D 59 01 88 01 C6 03 3A 48 FF C3 49 8B D1 4D 85 C9 74 41 41 80 39 00 74 3B 48 FF C7 48 3B FE 0F 83 96 00 00 00 8A 02 48 FF C2 88 03 48 FF C3 80 3A 00 75 E5 49 8B C9 E8 ?? ?? ?? ?? 80 38 2F 74 13 80 38 5C 74 0E 48 FF C7 48 3B FE 73 6D C6 03 5C 48 FF C3 48 8B 4C 24 50 48 85 C9 74 19 EB 12 48 FF C7 48 3B FE 73 53 8A 01 88 03 48 FF C3 48 FF C1 80 39 00 75 E9 48 8B 4C 24 58 48 85 C9 74 31 8A 01 84 C0 74 2B 3C 2E 74 22 48 FF C7 48 3B FE 73 28 C6 03 2E 48 FF C3 EB 12 48 FF C7 48 3B FE 73 18 8A 01 88 03 48 FF C3 48 FF C1 80 39 00 75 E9 48 8D 47 01 48 3B C6 76 10 C6 45 00 00 E8 ?? ?? ?? ?? BB 22 00 00 00 EB 11 C6 03 00 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_209_2_0 {
	meta:
		name = "?CPtoLCID@@YAHH@Z"
		size = 49
	strings:
		$1 = { 81 E9 A4 03 00 00 74 23 83 E9 04 74 18 83 E9 0D 74 0D FF C9 74 03 33 C0 C3 B8 04 04 00 00 C3 B8 12 04 00 00 C3 B8 04 08 00 00 C3 B8 11 04 00 00 C3 }
	condition:
		$1
}

rule file_209_3_0 {
	meta:
		name = "?setSBCS@@YAXPEAUthreadmbcinfostruct@@@Z"
		size = 140
		refs = "0029 memset 004a __initialmbcinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8D 59 1C 48 8B E9 BE 01 01 00 00 48 8B CB 44 8B C6 33 D2 E8 ?? ?? ?? ?? 45 33 DB 48 8D 7D 10 41 8D 4B 06 41 0F B7 C3 44 89 5D 0C 4C 89 5D 04 66 F3 AB 48 8D 3D ?? ?? ?? ?? 48 2B FD 8A 04 1F 88 03 48 FF C3 48 FF CE 75 F3 48 8D 8D 1D 01 00 00 BA 00 01 00 00 8A 04 39 88 01 48 FF C1 48 FF CA 75 F3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_209_4_0 {
	meta:
		name = "?setSBUpLow@@YAXPEAUthreadmbcinfostruct@@@Z"
		size = 496
		refs = "0021 __security_cookie 003c __imp_GetCPInfo 008e memset 00cb __crtGetStringTypeA 00fa __crtLCMapStringA 01d3 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 55 48 8D A8 78 FB FF FF 48 81 EC 80 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 70 04 00 00 48 8B F1 8B 49 04 48 8D 54 24 50 FF 15 ?? ?? ?? ?? BB 00 01 00 00 85 C0 0F 84 3C 01 00 00 33 C0 48 8D 4C 24 70 88 01 FF C0 48 FF C1 3B C3 72 F5 8A 44 24 56 C6 44 24 70 20 48 8D 7C 24 56 EB 29 0F B6 57 01 44 0F B6 C0 44 3B C2 77 16 41 2B D0 41 8B C0 4A 8D 4C 04 70 44 8D 42 01 B2 20 E8 ?? ?? ?? ?? 48 83 C7 02 8A 07 84 C0 75 D3 8B 46 0C 83 64 24 38 00 4C 8D 44 24 70 89 44 24 30 8B 46 04 44 8B CB 89 44 24 28 48 8D 85 70 02 00 00 BA 01 00 00 00 33 C9 48 89 44 24 20 E8 ?? ?? ?? ?? 83 64 24 40 00 8B 46 04 8B 56 0C 89 44 24 38 48 8D 45 70 89 5C 24 30 48 89 44 24 28 4C 8D 4C 24 70 44 8B C3 33 C9 89 5C 24 20 E8 ?? ?? ?? ?? 83 64 24 40 00 8B 46 04 8B 56 0C 89 44 24 38 48 8D 85 70 01 00 00 89 5C 24 30 48 89 44 24 28 4C 8D 4C 24 70 41 B8 00 02 00 00 33 C9 89 5C 24 20 E8 ?? ?? ?? ?? 48 8D 55 70 4C 8D 85 70 01 00 00 48 2B D6 4C 8D 9D 70 02 00 00 48 8D 4E 1D 4C 2B C6 41 F6 03 01 74 09 80 09 10 8A 44 0A E3 EB 0E 41 F6 03 02 74 10 80 09 20 41 8A 44 08 E3 88 81 00 01 00 00 EB 07 C6 81 00 01 00 00 00 48 FF C1 49 83 C3 02 48 FF CB 75 C8 EB 3F 33 D2 48 8D 4E 1D 44 8D 42 9F 41 8D 40 20 83 F8 19 77 08 80 09 10 8D 42 20 EB 0C 41 83 F8 19 77 0E 80 09 20 8D 42 E0 88 81 00 01 00 00 EB 07 C6 81 00 01 00 00 00 FF C2 48 FF C1 3B D3 72 C7 48 8B 8D 70 04 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 80 05 00 00 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_209_5_0 {
	meta:
		name = "__updatetmbcinfo"
		size = 186
		refs = "000b _getptd 001a __globallocalestatus 0039 _lock 004d __ptmbcinfo 0060 __initialmbcinfo 006f free 009b _unlock 00a8 _amsg_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 E8 ?? ?? ?? ?? 48 8B F8 8B 88 C8 00 00 00 85 0D ?? ?? ?? ?? 74 13 48 83 B8 C0 00 00 00 00 74 09 48 8B 98 B8 00 00 00 EB 6C B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 9F B8 00 00 00 48 89 5C 24 30 48 3B 1D ?? ?? ?? ?? 74 42 48 85 DB 74 1B F0 FF 0B 75 16 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 30 48 3B C8 74 05 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 87 B8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 30 F0 FF 00 48 8B 5C 24 30 B9 0D 00 00 00 E8 ?? ?? ?? ?? 48 85 DB 75 08 8D 4B 20 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_209_6_0 {
	meta:
		name = "__updatetmbcinfo$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_free_locale$fin$1 _freefls$fin$1 _get_current_locale$fin$0 _initptd$fin$1 _setmbcp$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_209_8_0 {
	meta:
		name = "?getSystemCP@@YAHH@Z"
		size = 144
		refs = "0010 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0016 fSystemSet 002c __imp_GetOEMCP 0056 __imp_GetACP"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 83 FB FE 75 25 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 80 7C 24 38 00 74 53 48 8B 4C 24 30 83 A1 C8 00 00 00 FD EB 45 83 FB FD 75 12 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? EB D4 83 FB FC 75 14 48 8B 44 24 20 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 40 04 EB BB 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_209_9_0 {
	meta:
		name = "_setmbcp_nolock"
		size = 629
		refs = "0013 __security_cookie 0023 ?getSystemCP@@YAHH@Z 0033 ?setSBCS@@YAXPEAUthreadmbcinfostruct@@@Z 003f __rgcode_page_info 0085 __imp_IsValidCodePage 009a __imp_GetCPInfo 00b3 memset 016d fSystemSet 0198 __rgctypeflag 024e ?setSBUpLow@@YAXPEAUthreadmbcinfostruct@@@Z 025d __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 38 48 8B F2 E8 ?? ?? ?? ?? 33 DB 8B F8 85 C0 75 0D 48 8B CE E8 ?? ?? ?? ?? E9 16 02 00 00 4C 8D 2D ?? ?? ?? ?? 8B CB 48 8B EB 49 8B C5 41 BC 01 00 00 00 39 38 0F 84 26 01 00 00 41 03 CC 49 03 EC 48 83 C0 30 83 F9 05 72 E9 81 FF E8 FD 00 00 0F 84 03 01 00 00 81 FF E9 FD 00 00 0F 84 F7 00 00 00 0F B7 CF FF 15 ?? ?? ?? ?? 85 C0 0F 84 E6 00 00 00 48 8D 54 24 20 8B CF FF 15 ?? ?? ?? ?? 85 C0 0F 84 C5 00 00 00 48 8D 4E 1C 33 D2 41 B8 01 01 00 00 E8 ?? ?? ?? ?? 89 7E 04 89 5E 0C 44 39 64 24 20 0F 86 8C 00 00 00 48 8D 44 24 26 38 5C 24 26 74 2D 38 58 01 74 28 0F B6 38 0F B6 48 01 3B F9 77 15 2B CF 48 8D 54 37 1D 41 03 CC 80 0A 04 49 03 D4 49 2B CC 75 F5 48 83 C0 02 38 18 75 D3 48 8D 46 1E B9 FE 00 00 00 80 08 08 49 03 C4 49 2B CC 75 F5 8B 4E 04 81 E9 A4 03 00 00 74 27 83 E9 04 74 1B 83 E9 0D 74 0F FF C9 74 04 8B C3 EB 1A B8 04 04 00 00 EB 13 B8 12 04 00 00 EB 0C B8 04 08 00 00 EB 05 B8 11 04 00 00 89 46 0C 44 89 66 08 EB 03 89 5E 08 48 8D 7E 10 0F B7 C3 B9 06 00 00 00 66 F3 AB E9 DF 00 00 00 39 1D ?? ?? ?? ?? 0F 85 B8 FE FF FF 83 C8 FF E9 D5 00 00 00 48 8D 4E 1C 33 D2 41 B8 01 01 00 00 E8 ?? ?? ?? ?? 4C 8D 54 6D 00 4C 8D 1D ?? ?? ?? ?? 49 C1 E2 04 BD 04 00 00 00 4F 8D 44 2A 10 49 8B C8 41 38 18 74 31 38 59 01 74 2C 0F B6 11 0F B6 41 01 3B D0 77 19 4C 8D 4C 32 1D 41 8A 03 41 03 D4 41 08 01 0F B6 41 01 4D 03 CC 3B D0 76 EC 48 83 C1 02 38 19 75 CF 49 83 C0 08 4D 03 DC 49 2B EC 75 BB 89 7E 04 81 EF A4 03 00 00 44 89 66 08 74 23 83 EF 04 74 17 83 EF 0D 74 0B FF CF 75 1A BB 04 04 00 00 EB 13 BB 12 04 00 00 EB 0C BB 04 08 00 00 EB 05 BB 11 04 00 00 4C 2B D6 89 5E 0C 48 8D 4E 10 4B 8D 7C 2A F4 BA 06 00 00 00 0F B7 04 0F 66 89 01 48 83 C1 02 49 2B D4 75 F0 48 8B CE E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 38 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 48 83 C4 40 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_209_10_0 {
	meta:
		name = "_getmbcp"
		size = 80
		refs = "000c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 28 45 33 DB 44 39 58 08 74 18 8B 40 04 44 38 5C 24 38 74 23 48 8B 4C 24 30 83 A1 C8 00 00 00 FD EB 15 44 38 5C 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_209_11_0 {
	meta:
		name = "_setmbcp"
		size = 478
		refs = "0020 _getptd 0028 __updatetmbcinfo 0036 ?getSystemCP@@YAHH@Z 004c _malloc_crt 006f memcpy 007c _setmbcp_nolock 0095 __initialmbcinfo 00ab free 00c8 __globallocalestatus 00db _lock 00e5 __mbcodepage 00ee __ismbcodepage 00f7 __mblcid 0100 __ImageBase 011a __mbulinfo 013b _mbctype 015d _mbcasemap 0168 __ptmbcinfo 018f _unlock 01af _errno"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 41 55 48 83 EC 30 8B F9 41 83 CD FF E8 ?? ?? ?? ?? 48 8B F0 E8 ?? ?? ?? ?? 48 8B 9E B8 00 00 00 8B CF E8 ?? ?? ?? ?? 44 8B E0 3B 43 04 0F 84 75 01 00 00 B9 20 02 00 00 E8 ?? ?? ?? ?? 48 8B D8 33 FF 48 85 C0 0F 84 62 01 00 00 48 8B 96 B8 00 00 00 48 8B C8 41 B8 20 02 00 00 E8 ?? ?? ?? ?? 89 3B 48 8B D3 41 8B CC E8 ?? ?? ?? ?? 44 8B E8 85 C0 0F 85 0A 01 00 00 48 8B 8E B8 00 00 00 4C 8D 25 ?? ?? ?? ?? F0 FF 09 75 11 48 8B 8E B8 00 00 00 49 3B CC 74 05 E8 ?? ?? ?? ?? 48 89 9E B8 00 00 00 F0 FF 03 F6 86 C8 00 00 00 02 0F 85 FA 00 00 00 F6 05 ?? ?? ?? ?? 01 0F 85 ED 00 00 00 BE 0D 00 00 00 8B CE E8 ?? ?? ?? ?? 90 8B 43 04 89 05 ?? ?? ?? ?? 8B 43 08 89 05 ?? ?? ?? ?? 8B 43 0C 89 05 ?? ?? ?? ?? 8B D7 4C 8D 05 ?? ?? ?? ?? 89 54 24 20 83 FA 05 7D 15 48 63 CA 0F B7 44 4B 10 66 41 89 84 48 ?? ?? ?? ?? FF C2 EB E2 8B D7 89 54 24 20 81 FA 01 01 00 00 7D 13 48 63 CA 8A 44 19 1C 42 88 84 01 ?? ?? ?? ?? FF C2 EB E1 89 7C 24 20 81 FF 00 01 00 00 7D 16 48 63 CF 8A 84 19 1D 01 00 00 42 88 84 01 ?? ?? ?? ?? FF C7 EB DE 48 8B 05 ?? ?? ?? ?? F0 FF 08 75 11 48 8B 0D ?? ?? ?? ?? 49 3B CC 74 05 E8 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? F0 FF 03 8B CE E8 ?? ?? ?? ?? EB 2B 83 F8 FF 75 26 4C 8D 25 ?? ?? ?? ?? 49 3B DC 74 08 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 05 33 FF 44 8B EF 41 8B C5 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 64 24 58 48 83 C4 30 41 5D C3 }
	condition:
		$1
}

rule file_209_13_0 {
	meta:
		name = "__initmbctable"
		size = 40
		refs = "0006 __mbctype_initialized 0013 _setmbcp"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 14 B9 FD FF FF FF E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "wcschr"
		size = 31
	strings:
		$1 = { EB 09 66 3B C2 74 11 48 83 C1 02 0F B7 01 66 85 C0 75 EF 66 3B C2 75 04 48 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "wcsncmp"
		size = 43
	strings:
		$1 = { 4D 85 C0 75 18 33 C0 C3 0F B7 01 66 85 C0 74 12 66 3B 02 75 0D 48 83 C1 02 48 83 C2 02 49 FF C8 75 E6 0F B7 01 0F B7 0A 2B C1 C3 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "_setenvp"
		size = 304
		refs = "0016 __mbctype_initialized 001e __initmbctable 0025 _aenvptr 0042 strlen 005d _calloc_crt 0067 _environ 00ae strcpy_s 00d0 free 00e2 __env_initialized 0112 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 33 FF 48 85 DB 75 1B 83 C8 FF E9 B4 00 00 00 3C 3D 74 02 FF C7 48 8B CB E8 ?? ?? ?? ?? 48 8D 5C 03 01 8A 03 84 C0 75 E7 8D 47 01 BA 08 00 00 00 48 63 C8 E8 ?? ?? ?? ?? 48 8B F8 48 89 05 ?? ?? ?? ?? 48 85 C0 74 C0 48 8B 1D ?? ?? ?? ?? 80 3B 00 74 50 48 8B CB E8 ?? ?? ?? ?? 80 3B 3D 8D 70 01 74 2E 48 63 EE BA 01 00 00 00 48 8B CD E8 ?? ?? ?? ?? 48 89 07 48 85 C0 74 73 4C 8B C3 48 8B D5 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 4B 48 83 C7 08 48 63 C6 48 03 D8 80 3B 00 75 B7 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 27 00 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 E9 00 FF FF FF }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "_assert"
		size = 2138
		refs = "0022 __security_cookie 003f _set_error_mode 005e __app_type 0072 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 007f strcpy_s 008e dblnewline 009b strcat_s 00aa ??_C@_09KLGCKDOD@Program?3?5?$AA@ 00db __imp_GetModuleFileNameA 00e6 ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 010f _invoke_watson 0123 strlen 0146 dotdotdot 016c _mbsnbcpy_s 01a4 newline 01c0 ??_C@_06IGPBOHMJ@File?3?5?$AA@ 0253 _mbsnbcat_s 049e ??_C@_06FIEBOLOH@Line?3?5?$AA@ 04e3 _itoa_s 050e ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 05e4 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 0618 ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 0630 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0640 __crtMessageBoxA 064d raise 0657 _exit 07d9 __iob_func 07f9 setvbuf 0805 _assertstring 0819 fprintf 0827 fflush 082c abort 083b __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 90 FD FF FF 48 81 EC 70 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 4C 8B F1 B9 03 00 00 00 45 8B F8 48 8B DA E8 ?? ?? ?? ?? 83 F8 01 0F 84 8C 07 00 00 B9 03 00 00 00 E8 ?? ?? ?? ?? 33 F6 85 C0 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 6F 07 00 00 41 BC 1C 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 38 07 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 07 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D4 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 D6 06 00 00 48 8D 95 50 01 00 00 41 B8 04 01 00 00 40 88 B5 54 02 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 31 4C 8D 05 ?? ?? ?? ?? 48 8D 8D 50 01 00 00 BA 05 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 48 8D 8D 50 01 00 00 48 8D BD 50 01 00 00 E8 ?? ?? ?? ?? 41 BD 31 00 00 00 48 83 C0 0B 48 83 F8 3C 76 52 48 8D 8D 50 01 00 00 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8D 95 55 02 00 00 48 8B F8 48 8D 85 50 01 00 00 45 8D 4D D2 49 2B C5 48 03 F8 48 2B D7 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 15 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 30 4C 8B C7 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 E5 05 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 B4 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 83 05 00 00 48 8B CB E8 ?? ?? ?? ?? 48 83 C0 08 48 83 F8 3C 0F 86 78 02 00 00 48 8B CB E8 ?? ?? ?? ?? BF 01 00 00 00 4C 8B E0 8A 44 03 FF 3C 5C 74 1A 4A 8D 4C 23 FF 3C 2F 74 11 49 3B FC 73 0C 48 FF C9 48 FF C7 8A 01 3C 5C 75 EB 49 8B F4 48 2B F7 48 83 FE 23 0F 86 A2 00 00 00 48 83 FF 11 0F 83 94 00 00 00 4C 2B EF 41 BC 1C 02 00 00 48 8D 4C 24 30 4D 8B CD 41 8B D4 4C 8B C3 E8 ?? ?? ?? ?? 85 C0 75 5E 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D4 E8 ?? ?? ?? ?? 85 C0 75 30 4C 8D 04 1E 48 8D 4C 24 30 41 8B D4 E8 ?? ?? ?? ?? 33 F6 85 C0 0F 84 F1 01 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 FE 23 4C 8B C3 48 8D 4C 24 30 0F 83 93 00 00 00 48 D1 EF 4C 2B EF 4D 8B CD 41 BD 1C 02 00 00 41 8B D5 E8 ?? ?? ?? ?? 33 F6 85 C0 75 61 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D5 E8 ?? ?? ?? ?? 85 C0 75 34 48 2B DF 48 8D 4C 24 30 41 8B D5 4D 8D 04 1C 45 8B E5 E8 ?? ?? ?? ?? 85 C0 0F 84 4A 01 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 41 BD 1C 02 00 00 41 B9 20 00 00 00 41 8B D5 E8 ?? ?? ?? ?? 85 C0 0F 85 C1 00 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D5 E8 ?? ?? ?? ?? 85 C0 0F 85 8F 00 00 00 4C 8D 04 1E 44 8D 48 07 48 8D 4C 24 30 41 8B D5 E8 ?? ?? ?? ?? 33 F6 85 C0 75 5F 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 41 8B D5 E8 ?? ?? ?? ?? 85 C0 75 32 4E 8D 44 23 F9 48 8D 4C 24 30 41 8B D5 45 8B E5 E8 ?? ?? ?? ?? 85 C0 0F 84 83 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8D 4C 24 30 4C 8B C3 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 C8 02 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 97 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 66 02 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B DC 48 2B D8 E8 ?? ?? ?? ?? 41 B9 0A 00 00 00 48 8D 54 04 30 4C 8B C3 41 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 19 02 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 E8 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 B7 01 00 00 49 8B CE E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D8 E8 ?? ?? ?? ?? 48 8D 8C 03 B0 00 00 00 49 3B CC 48 8D 4C 24 30 76 64 E8 ?? ?? ?? ?? 41 B9 69 01 00 00 48 8D 4C 24 30 4D 8B C6 49 8B D4 4C 2B C8 E8 ?? ?? ?? ?? 85 C0 75 2D 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 74 3D 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 4D 8B C6 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 04 01 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 D3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 A2 00 00 00 4C 8B 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 75 75 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 30 49 8B D4 E8 ?? ?? ?? ?? 85 C0 75 48 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 41 B8 12 20 01 00 E8 ?? ?? ?? ?? 83 F8 03 75 13 8D 48 13 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? CC 83 F8 04 75 06 CC E9 C9 01 00 00 83 F8 05 0F 85 BB 01 00 00 E9 BB 01 00 00 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? F7 40 78 0C 01 00 00 75 17 E8 ?? ?? ?? ?? 45 33 C9 33 D2 48 8D 48 60 45 8D 41 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 4C 8B CB 48 8D 48 60 4D 8B C6 44 89 7C 24 20 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 48 60 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C8 03 00 00 48 81 C4 70 03 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "fgetpos"
		size = 75
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 002f _ftelli64"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 DB 48 8B FA 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 17 48 85 D2 74 E6 E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 07 0F 95 C3 8D 43 FF 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_217_1_0 {
	meta:
		name = "_wgetenv_helper_nolock"
		size = 187
		refs = "0011 __env_initialized 0019 _wenviron 002e _environ 0035 __crtGetEnvironmentStringsW 003c _wenvptr 0041 _wsetenvp 004a __mbtow_environ 0067 wcslen 0091 _wcsnicoll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 83 3D ?? ?? ?? ?? 00 48 8B 1D ?? ?? ?? ?? 48 8B F1 0F 84 83 00 00 00 48 85 DB 75 33 48 39 1D ?? ?? ?? ?? 74 75 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 09 E8 ?? ?? ?? ?? 85 C0 75 57 48 8B 1D ?? ?? ?? ?? 48 85 DB 74 4B 48 85 F6 74 46 48 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 8B 0B 48 85 C9 74 33 E8 ?? ?? ?? ?? 48 3B C7 76 19 48 8B 0B 66 83 3C 79 3D 75 0F 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 85 C0 74 06 48 83 C3 08 EB CF 48 8B 03 48 8D 44 78 02 EB 02 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_217_2_0 {
	meta:
		name = "_wgetenv_s_helper"
		size = 208
		refs = "002b _errno 0037 _invalid_parameter_noinfo 0079 _wgetenv_helper_nolock 008d wcslen 00b3 wcscpy_s 00cb _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 48 83 EC 30 45 33 E4 49 8B D8 48 8B FA 48 8B E9 48 85 C9 75 2E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5C C3 4C 89 21 48 85 D2 74 07 48 85 DB 75 07 EB C3 48 85 DB 75 BE 48 85 D2 74 04 66 44 89 22 49 8B C9 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 04 33 C0 EB B4 48 8B C8 E8 ?? ?? ?? ?? 48 FF C0 48 89 45 00 48 85 DB 74 E8 48 3B C3 76 07 B8 22 00 00 00 EB 94 4C 8B C6 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 CA 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_217_3_0 {
	meta:
		name = "_wdupenv_s_helper"
		size = 212
		refs = "0020 _errno 002c _invalid_parameter_noinfo 005d _wgetenv_helper_nolock 0071 wcslen 0082 calloc 00ac wcscpy_s 00cf _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B DA 48 8B F9 48 85 C9 75 28 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 48 83 21 00 48 85 D2 74 04 48 83 22 00 4D 85 C0 74 C6 49 8B C8 E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 04 33 C0 EB C5 48 8B C8 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8D 70 01 48 8B CE E8 ?? ?? ?? ?? 48 89 07 48 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 90 4C 8B C5 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 0A 48 85 DB 74 B0 48 89 33 EB AB 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_217_4_0 {
	meta:
		name = "_wgetenv"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f wcsnlen 0048 _lock 0051 _wgetenv_helper_nolock 005e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_795_4_0 {
	meta:
		name = "getenv"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f strnlen 0048 _lock 0051 _getenv_helper_nolock 005e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_217_6_0 {
	meta:
		name = "_wgetenv_s"
		size = 254
		refs = "002b _lock 003f _errno 004b _invalid_parameter_noinfo 0082 _wgetenv_helper_nolock 0092 wcslen 00b8 wcscpy_s 00c6 _unlock 00de _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 41 55 48 83 EC 30 4D 8B E1 49 8B F0 48 8B FA 4C 8B E9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 ED 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 6F 49 89 5D 00 48 85 FF 74 0A 48 85 F6 75 0A 48 85 FF 75 0C 48 85 F6 75 07 B8 01 00 00 00 EB 02 8B C3 85 C0 74 C8 48 85 FF 74 03 66 89 1F 49 8B CC E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 74 32 48 8B C8 E8 ?? ?? ?? ?? 48 FF C0 49 89 45 00 48 85 F6 74 1E 48 3B C6 76 07 BB 22 00 00 00 EB 12 4D 8B C4 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 0E B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 64 24 58 48 83 C4 30 41 5D C3 }
	condition:
		$1
}

rule file_217_7_0 {
	meta:
		name = "_wgetenv_s$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_dupenv_s$fin$0 _wdupenv_s$fin$0 getenv_s$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_217_8_0 {
	meta:
		name = "_wdupenv_s"
		size = 258
		refs = "0028 _lock 003c _errno 0048 _invalid_parameter_noinfo 0069 _wgetenv_helper_nolock 0079 wcslen 008a calloc 00b4 wcscpy_s 00ca _unlock 00e2 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 41 55 48 83 EC 30 4D 8B E0 48 8B FA 48 8B F1 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 48 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 76 48 89 1E 48 85 FF 74 03 48 89 1F 8B C3 4D 85 E4 0F 95 C0 85 C0 74 D6 49 8B CC E8 ?? ?? ?? ?? 4C 8B E8 48 85 C0 74 4F 48 8B C8 E8 ?? ?? ?? ?? 4C 8D 60 01 BA 02 00 00 00 49 8B CC E8 ?? ?? ?? ?? 48 89 06 48 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 18 EB 1A 4D 8B C5 49 8B D4 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 16 48 85 FF 74 03 4C 89 27 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 64 24 58 48 83 C4 30 41 5D C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_flsbuf"
		size = 397
		refs = "001e _fileno 002e _errno 008d __iob_func 00ab _isatty 00b7 _getbuf 00ea _write 0110 __pioinfo 0128 __badioinfo 013b _lseeki64"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 89 48 08 57 48 83 EC 20 48 8B CA 48 8B DA E8 ?? ?? ?? ?? 8B 4B 18 48 63 F0 F6 C1 82 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4B 18 20 83 C8 FF E9 34 01 00 00 F6 C1 40 74 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB E2 33 FF F6 C1 01 74 19 89 7B 08 F6 C1 10 0F 84 89 00 00 00 48 8B 43 10 83 E1 FE 48 89 03 89 4B 18 8B 43 18 89 7B 08 83 E0 EF 83 C8 02 89 43 18 A9 0C 01 00 00 75 2F E8 ?? ?? ?? ?? 48 83 C0 30 48 3B D8 74 0E E8 ?? ?? ?? ?? 48 83 C0 60 48 3B D8 75 0B 8B CE E8 ?? ?? ?? ?? 85 C0 75 08 48 8B CB E8 ?? ?? ?? ?? F7 43 18 08 01 00 00 0F 84 8D 00 00 00 8B 2B 48 8B 53 10 2B 6B 10 48 8D 42 01 48 89 03 8B 43 24 FF C8 89 43 08 85 ED 7E 19 44 8B C5 8B CE E8 ?? ?? ?? ?? 8B F8 EB 57 83 C9 20 89 4B 18 E9 3F FF FF FF 83 FE FF 74 23 83 FE FE 74 1E 48 8B CE 48 8B C6 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 C1 F8 05 48 6B C9 58 48 03 0C C2 EB 07 48 8D 0D ?? ?? ?? ?? F6 41 08 20 74 17 33 D2 8B CE 44 8D 42 02 E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 EF FE FF FF 48 8B 4B 10 8A 44 24 30 88 01 EB 16 BD 01 00 00 00 48 8D 54 24 30 8B CE 44 8B C5 E8 ?? ?? ?? ?? 8B F8 3B FD 0F 85 C5 FE FF FF 0F B6 44 24 30 48 8B 5C 24 38 48 8B 6C 24 40 48 8B 74 24 48 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "_filbuf"
		size = 338
		refs = "0018 _errno 0023 _invalid_parameter_noinfo 005c _getbuf 006d _fileno 007c _read 00c2 __pioinfo 00e6 __badioinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 13 01 00 00 8B 41 18 A8 83 0F 84 08 01 00 00 A8 40 0F 85 00 01 00 00 A8 02 74 0B 83 C8 20 89 41 18 E9 F1 00 00 00 83 C8 01 89 41 18 A9 0C 01 00 00 75 07 E8 ?? ?? ?? ?? EB 07 48 8B 41 10 48 89 01 48 8B CF E8 ?? ?? ?? ?? 44 8B 47 24 48 8B 57 10 8B C8 E8 ?? ?? ?? ?? 89 47 08 85 C0 0F 84 A3 00 00 00 83 F8 FF 0F 84 9A 00 00 00 F6 47 18 82 75 5F 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 3C 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 2F 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 48 8D 35 ?? ?? ?? ?? 48 63 D8 48 C1 FB 05 E8 ?? ?? ?? ?? 44 8B D8 41 83 E3 1F 4D 6B DB 58 4C 03 1C DE EB 07 4C 8D 1D ?? ?? ?? ?? 41 8A 43 08 24 82 3C 82 75 05 0F BA 6F 18 0D 81 7F 24 00 02 00 00 75 1B F6 47 18 08 74 15 8B 47 24 F7 47 18 00 04 00 00 B9 00 10 00 00 0F 44 C1 89 47 24 48 8B 0F FF 4F 08 0F B6 01 48 FF C1 48 89 0F EB 14 F7 D8 1B C0 83 E0 10 83 C0 10 09 47 18 83 67 08 00 83 C8 FF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "_powf_special"
		size = 293
		refs = "0105 ??_C@_04MBFDLNIM@powf?$AA@ 0114 _handle_errorf"
	strings:
		$1 = { 48 83 EC 78 0F 29 74 24 60 B8 02 00 00 00 0F 28 F2 41 83 F9 01 0F 84 BB 00 00 00 44 3B C8 0F 84 8D 00 00 00 0F 86 EE 00 00 00 41 83 F9 06 76 61 41 83 F9 07 74 33 41 83 F9 09 0F 85 D8 00 00 00 89 44 24 40 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 44 8D 48 01 C7 44 24 20 11 00 00 00 E9 8D 00 00 00 89 44 24 40 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 04 00 00 00 C7 44 24 20 12 00 00 00 EB 65 89 44 24 40 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 41 B9 01 00 00 00 EB 3D 89 44 24 40 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 44 8B C8 C7 44 24 20 04 00 00 00 EB 20 89 44 24 40 F3 0F 11 4C 24 38 F3 0F 11 44 24 30 83 64 24 28 00 45 33 C9 C7 44 24 20 08 00 00 00 48 83 64 24 50 00 F3 0F 11 74 24 50 48 8D 0D ?? ?? ?? ?? 4C 8B 44 24 50 BA 1D 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_221_1_0 {
	meta:
		name = "_pow_special"
		size = 256
		refs = "00dc ??_C@_03JGHBODFD@pow?$AA@ 00ee _handle_error"
	strings:
		$1 = { 48 83 EC 68 B8 02 00 00 00 0F 29 74 24 50 66 0F 28 F2 44 3B C8 0F 84 92 00 00 00 0F 86 D1 00 00 00 41 83 F9 06 76 5E 41 83 F9 08 76 30 41 83 F9 09 0F 85 BB 00 00 00 89 44 24 40 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 44 8D 48 01 C7 44 24 20 11 00 00 00 EB 73 89 44 24 40 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 41 B9 04 00 00 00 C7 44 24 20 12 00 00 00 EB 4B 89 44 24 40 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 41 B9 01 00 00 00 C7 44 24 20 08 00 00 00 EB 23 89 44 24 40 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 44 8B C8 C7 44 24 20 04 00 00 00 F2 0F 11 94 24 80 00 00 00 48 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 4C 8B 84 24 80 00 00 00 E8 ?? ?? ?? ?? 66 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "??__C@YAXPEAX0_KHP6AX00@ZP6AX0@Z@Z"
		size = 101
	strings:
		$1 = { 4C 89 44 24 18 48 89 4C 24 08 53 56 57 41 54 41 55 48 83 EC 30 45 8B E9 4D 8B E0 48 8B F2 48 8B F9 33 DB 89 5C 24 20 89 5C 24 24 41 3B DD 7D 21 48 8B D6 48 8B CF FF 94 24 80 00 00 00 49 03 FC 48 89 7C 24 60 49 03 F4 48 89 74 24 68 FF C3 EB D6 C7 44 24 20 01 00 00 00 48 83 C4 30 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "?fin$0@?0???__C@YAXPEAX0_KHP6AX00@ZP6AX0@Z@Z@4HA"
		size = 47
		refs = "0023 ?__ArrayUnwind@@YAXPEAX_KHP6AX0@Z@Z"
		altNames = "?fin$0@?0???__D@YAXPEAX0_KHP6AX00@ZP6AX0@Z@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 83 7D 20 00 75 19 4C 8B 8D 88 00 00 00 44 8B 45 24 48 8B 55 70 48 8B 4D 60 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "_openfile"
		size = 694
		refs = "0018 _commode 0052 _errno 005d _invalid_parameter_noinfo 01a0 ?ccsField@?P@??_openfile@@9@9 01ae _mbsnbcmp 01dc ?utf8encoding@?P@??_openfile@@9@9 01ea _mbsnbicmp 01ff ?utf16encoding@?P@??_openfile@@9@9 0222 ?unicodeencoding@?P@??_openfile@@9@9 026e _sopen_s 027d _cflush"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 56 57 41 54 41 55 41 57 48 83 EC 30 8B 2D ?? ?? ?? ?? 49 8B F1 45 33 C9 45 33 D2 45 33 DB 80 3A 20 45 8D 79 01 45 8B E0 48 8B DA 4C 8B E9 75 08 49 03 DF 80 3B 20 74 F8 80 3B 61 74 2F 80 3B 72 74 23 80 3B 77 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 37 02 00 00 BF 01 03 00 00 EB 0C 33 FF 41 0B EF EB 08 BF 09 01 00 00 83 CD 02 49 03 DF 41 8B D7 8A 03 84 C0 0F 84 BB 01 00 00 41 B8 00 40 00 00 85 D2 0F 84 EE 00 00 00 0F BE C8 83 F9 53 7F 79 74 6A 83 E9 20 0F 84 CE 00 00 00 83 E9 0B 74 47 FF C9 74 3E 83 E9 18 74 27 83 E9 0A 74 19 83 F9 04 75 8A 45 85 D2 0F 85 A5 00 00 00 45 8B D7 83 CF 10 E9 A2 00 00 00 0F BA EF 07 E9 99 00 00 00 40 F6 C7 40 0F 85 87 00 00 00 83 CF 40 E9 87 00 00 00 45 8B DF EB 7A 40 F6 C7 02 75 74 83 E7 FE 83 E5 FC 83 CF 02 0F BA ED 07 EB 6D 45 85 D2 75 60 45 8B D7 83 CF 20 EB 60 83 E9 54 74 4D 83 E9 0E 74 3A FF C9 74 29 83 E9 0B 74 16 83 F9 06 0F 85 18 FF FF FF F7 C7 00 C0 00 00 75 34 41 0B F8 EB 37 45 85 C9 75 2A 45 8B CF 0F BA F5 0E EB 29 45 85 C9 75 1C 45 8B CF 41 0B E8 EB 1C F7 C7 00 C0 00 00 75 0C 0F BA EF 0F EB 0E 0F BA E7 0C 73 04 33 D2 EB 04 0F BA EF 0C 49 03 DF 8A 03 84 C0 0F 85 0A FF FF FF 45 85 DB 0F 84 B6 00 00 00 EB 03 49 03 DF 80 3B 20 74 F8 48 8D 0D ?? ?? ?? ?? 41 B8 03 00 00 00 48 8B D3 E8 ?? ?? ?? ?? 85 C0 0F 85 97 FE FF FF 48 83 C3 03 EB 03 49 03 DF 80 3B 20 74 F8 80 3B 3D 0F 85 80 FE FF FF 49 03 DF 80 3B 20 74 F8 48 8D 15 ?? ?? ?? ?? 41 B8 05 00 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 0A 48 83 C3 05 0F BA EF 12 EB 4D 48 8D 15 ?? ?? ?? ?? 41 B8 08 00 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 0A 48 83 C3 08 0F BA EF 11 EB 2A 48 8D 15 ?? ?? ?? ?? 41 B8 07 00 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 15 FE FF FF 48 83 C3 07 0F BA EF 10 EB 03 49 03 DF 80 3B 20 74 F8 80 3B 00 0F 85 FA FD FF FF 48 8D 4C 24 68 45 8B CC 44 8B C7 49 8B D5 C7 44 24 20 80 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 E7 FD FF FF 44 01 3D ?? ?? ?? ?? 21 46 08 8B 44 24 68 48 83 26 00 48 83 66 10 00 48 83 66 28 00 89 46 1C 89 6E 18 48 8B C6 48 8B 5C 24 60 48 8B 6C 24 70 48 83 C4 30 41 5F 41 5D 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_225_3_0 {
	meta:
		name = "_ismbstrail_l"
		size = 164
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0035 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 70 48 85 D2 74 E9 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 4C 8B 5C 24 28 41 83 7B 08 00 74 3F 48 3B DF 77 3A 80 3B 00 74 35 0F B6 03 42 F6 44 18 1D 04 74 0D 48 FF C3 48 3B DF 74 0A 80 3B 00 74 1D 48 FF C3 EB D9 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 83 C8 FF EB 15 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "sprintf"
		size = 160
		refs = "002f memset 0039 _errno 0044 _invalid_parameter_noinfo 0077 _output_l 0092 _flsbuf"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 55 53 57 48 8B EC 48 83 EC 50 48 83 65 D0 00 48 8B FA 33 D2 48 8B D9 48 8D 4D D8 44 8D 42 28 E8 ?? ?? ?? ?? 48 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4B 48 85 DB 74 E6 4C 8D 4D 30 48 8D 4D D0 45 33 C0 48 8B D7 C7 45 D8 FF FF FF 7F C7 45 E8 42 00 00 00 48 89 5D E0 48 89 5D D0 E8 ?? ?? ?? ?? FF 4D D8 8B D8 78 09 48 8B 4D D0 C6 01 00 EB 0B 48 8D 55 D0 33 C9 E8 ?? ?? ?? ?? 8B C3 48 83 C4 50 5F 5B 5D C3 }
	condition:
		$1
}

rule file_227_3_0 {
	meta:
		name = "_sprintf_s_l"
		size = 29
		refs = "0014 _vsprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_919_1_0 {
	meta:
		name = "_snprintf_c_l"
		size = 29
		refs = "0014 _vsnprintf_c_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_296_1_0 {
	meta:
		name = "_snprintf_l"
		size = 29
		refs = "0014 _vsnprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_619_1_0 {
	meta:
		name = "_snwprintf_l"
		size = 29
		refs = "0014 _vsnwprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_7_0 {
	meta:
		name = "_sprintf_p_l"
		size = 29
		refs = "0014 _vsprintf_p_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_714_1_0 {
	meta:
		name = "_swprintf_c_l"
		size = 29
		refs = "0014 _vswprintf_c_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_7_0 {
	meta:
		name = "_swprintf_p_l"
		size = 29
		refs = "0014 _vswprintf_p_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_5_0 {
	meta:
		name = "_swprintf_s_l"
		size = 29
		refs = "0014 _vswprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_4_0 {
	meta:
		name = "_snprintf_s"
		size = 34
		refs = "0019 _vsnprintf_s_l"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 49 83 63 E8 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_3_0 {
	meta:
		name = "_snwprintf_s"
		size = 34
		refs = "0019 _vsnwprintf_s_l"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 49 83 63 E8 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_5_0 {
	meta:
		name = "_snprintf_s_l"
		size = 33
		refs = "0018 _vsnprintf_s_l"
	strings:
		$1 = { 4C 8B DC 48 83 EC 38 49 8D 43 30 49 89 43 F0 49 8B 43 28 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_520_6_0 {
	meta:
		name = "_snwprintf_s_l"
		size = 33
		refs = "0018 _vsnwprintf_s_l"
	strings:
		$1 = { 4C 8B DC 48 83 EC 38 49 8D 43 30 49 89 43 F0 49 8B 43 28 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_227_8_0 {
	meta:
		name = "_scprintf"
		size = 37
		refs = "001c _vscprintf"
		altNames = "_scprintf_p"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8D 50 10 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_520_8_0 {
	meta:
		name = "_scwprintf"
		size = 37
		refs = "001c _vscwprintf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8D 50 10 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_520_9_0 {
	meta:
		name = "_scwprintf_p"
		size = 37
		refs = "001c _vscwprintf_p"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 48 8D 50 10 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "_call_reportfault"
		size = 331
		refs = "0020 __security_cookie 003b __crt_debugger_hook 0052 memset 006f __imp_RtlCaptureContext 0086 RtlLookupFunctionEntry 00c0 RtlVirtualUnwind 00f7 __imp_IsDebuggerPresent 0101 __imp_SetUnhandledExceptionFilter 010c __imp_UnhandledExceptionFilter 012f __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 55 57 41 54 48 8D AC 24 10 FB FF FF 48 81 EC F0 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 E0 04 00 00 41 8B F8 8B F2 8B D9 83 F9 FF 74 05 E8 ?? ?? ?? ?? 83 64 24 70 00 48 8D 4C 24 74 33 D2 41 B8 94 00 00 00 E8 ?? ?? ?? ?? 4C 8D 5C 24 70 48 8D 45 10 48 8D 4D 10 4C 89 5C 24 48 48 89 44 24 50 FF 15 ?? ?? ?? ?? 4C 8B A5 08 01 00 00 48 8D 54 24 40 49 8B CC 45 33 C0 E8 ?? ?? ?? ?? 48 85 C0 74 37 48 83 64 24 38 00 48 8B 54 24 40 48 8D 4C 24 60 48 89 4C 24 30 48 8D 4C 24 58 4C 8B C8 48 89 4C 24 28 48 8D 4D 10 4D 8B C4 48 89 4C 24 20 33 C9 E8 ?? ?? ?? ?? EB 1C 48 8B 85 08 05 00 00 48 89 85 08 01 00 00 48 8D 85 08 05 00 00 48 89 85 A8 00 00 00 48 8B 85 08 05 00 00 89 74 24 70 89 7C 24 74 48 89 45 80 FF 15 ?? ?? ?? ?? 33 C9 8B F8 FF 15 ?? ?? ?? ?? 48 8D 4C 24 48 FF 15 ?? ?? ?? ?? 85 C0 75 10 85 FF 75 0C 83 FB FF 74 07 8B CB E8 ?? ?? ?? ?? 48 8B 8D E0 04 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 05 00 00 49 8B 5B 28 49 8B 73 30 49 8B E3 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_228_4_0 {
	meta:
		name = "_invoke_watson"
		size = 49
		refs = "0014 _call_reportfault 001a __imp_GetCurrentProcess 002d __imp_TerminateProcess"
	strings:
		$1 = { 48 83 EC 28 41 B8 01 00 00 00 BA 17 04 00 C0 41 8D 48 01 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BA 17 04 00 C0 48 8B C8 48 83 C4 28 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_5_0 {
	meta:
		name = "?_invoke_watson@@YAXPEBG00I_K@Z"
		size = 20
		refs = "000f _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_228_6_0 {
	meta:
		name = "_invalid_parameter"
		size = 111
		refs = "001a __pInvalidArgHandler 0029 __imp_DecodePointer 006a _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B E9 48 8B 0D ?? ?? ?? ?? 41 8B D9 49 8B F8 48 8B F2 FF 15 ?? ?? ?? ?? 44 8B CB 4C 8B C7 48 8B D6 48 8B CD 48 85 C0 74 21 4C 8B 54 24 60 4C 89 54 24 20 FF D0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_228_7_0 {
	meta:
		name = "_invalid_parameter_noinfo"
		size = 30
		refs = "0015 _invalid_parameter"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_228_8_0 {
	meta:
		name = "_invalid_parameter_noinfo_noreturn"
		size = 47
		refs = "0015 _invalid_parameter 002a _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_228_9_0 {
	meta:
		name = "?_invalid_parameter@@YAXPEBG00I_K@Z"
		size = 24
		refs = "000f _invalid_parameter"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_46_84_1 {
	meta:
		name = "??$_LStrcoll@D@std@@YAHPEBD000PEBU_Collvec@@@Z"
		size = 24
		refs = "000f _Strcoll"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_65_234_1 {
	meta:
		name = "??$_LStrcoll@_W@std@@YAHPEB_W000PEBU_Collvec@@@Z"
		size = 24
		refs = "000f _Wcscoll"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_46_85_1 {
	meta:
		name = "??$_LStrxfrm@D@std@@YA_KPEAD0PEBD1PEBU_Collvec@@@Z"
		size = 24
		refs = "000f _Strxfrm"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_65_235_1 {
	meta:
		name = "??$_LStrxfrm@_W@std@@YA_KPEA_W0PEB_W1PEBU_Collvec@@@Z"
		size = 24
		refs = "000f _Wcsxfrm"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_685_2_0 {
	meta:
		name = "?_vswprintf_l@@YAHPEAG_KPEBGPEAUlocaleinfo_struct@@PEAD@Z"
		size = 24
		refs = "000f ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_229_3_0 {
	meta:
		name = "??0WorkSearchContext@details@Concurrency@@QEAA@XZ"
		size = 22
	strings:
		$1 = { 33 C0 48 89 41 10 48 89 41 18 48 89 41 28 48 89 41 30 48 8B C1 C3 }
	condition:
		$1
}

rule file_229_9_0 {
	meta:
		name = "?GetEnqueuedTaskCount@VirtualProcessor@details@Concurrency@@AEAAIXZ"
		size = 21
	strings:
		$1 = { 8B 91 A0 00 00 00 8B C2 2B 81 A8 00 00 00 89 91 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_229_10_0 {
	meta:
		name = "?GetDequeuedTaskCount@VirtualProcessor@details@Concurrency@@AEAAIXZ"
		size = 21
	strings:
		$1 = { 8B 91 A4 00 00 00 8B C2 2B 81 AC 00 00 00 89 91 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_229_14_0 {
	meta:
		name = "?SaveRetiredVirtualProcessorStatistics@SchedulerBase@details@Concurrency@@QEAAXPEAVVirtualProcessor@23@@Z"
		size = 63
	strings:
		$1 = { 8B 82 A0 00 00 00 44 8B C0 44 2B 82 A8 00 00 00 89 82 A8 00 00 00 F0 44 0F C1 81 80 01 00 00 8B 82 A4 00 00 00 44 8B C0 44 2B 82 AC 00 00 00 89 82 AC 00 00 00 F0 44 0F C1 81 84 01 00 00 C3 }
	condition:
		$1
}

rule file_229_19_0 {
	meta:
		name = "?StartupWorkerContext@VirtualProcessor@details@Concurrency@@EEAAXPEAVScheduleGroupBase@23@@Z"
		size = 74
		refs = "001f ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IEAAPEAVInternalContextBase@23@PEAU_Chore@23@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 B9 B0 00 00 00 00 48 8B C2 48 8B D9 75 1A 45 33 C0 33 D2 48 8B C8 E8 ?? ?? ?? ?? 4C 8B 03 48 8B CB 48 8B D0 41 FF 50 20 48 8B 8B 88 00 00 00 48 8B 93 B0 00 00 00 48 8B 01 48 83 C4 20 5B 48 FF 60 28 }
	condition:
		$1
}

rule file_229_20_0 {
	meta:
		name = "?Affinitize@VirtualProcessor@details@Concurrency@@MEAAXPEAVInternalContextBase@23@@Z"
		size = 77
		refs = "0014 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B CA 48 8B DA E8 ?? ?? ?? ?? 4C 8B 1B 48 8B D7 48 8B CB 41 FF 53 40 48 89 9F B0 00 00 00 F6 83 FF 00 00 00 01 74 0D FF 87 A4 00 00 00 80 A3 FF 00 00 00 FE 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_229_21_0 {
	meta:
		name = "?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
		size = 58
	strings:
		$1 = { 8B 41 08 4C 8B C1 83 F8 01 75 2C 33 C0 87 41 08 83 F8 01 75 22 80 B9 C3 00 00 00 00 75 16 48 8B 49 70 48 8B 11 F0 FF 8A 7C 01 00 00 49 8B 48 70 F0 FF 49 10 B0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_229_22_0 {
	meta:
		name = "?MakeAvailable@VirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 35
	strings:
		$1 = { 48 8B 41 70 41 B8 01 00 00 00 48 8B 10 F0 44 01 82 7C 01 00 00 48 8B 41 70 F0 44 01 40 10 44 87 41 08 C3 }
	condition:
		$1
}

rule file_229_23_0 {
	meta:
		name = "?Oversubscribe@VirtualProcessor@details@Concurrency@@EEAAPEAV123@XZ"
		size = 56
		refs = "0034 ?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEAUIVirtualProcessorRoot@3@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 41 70 48 8B D9 48 8B 10 48 8B 8A 70 01 00 00 48 8B 93 88 00 00 00 48 8B 01 FF 50 28 48 8B 4B 70 41 B0 01 48 8B D0 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_24_0 {
	meta:
		name = "?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QEAAPEAVSubAllocator@23@XZ"
		size = 46
		refs = "0016 ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPEAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 B9 90 00 00 00 00 48 8B D9 75 0E 33 C9 E8 ?? ?? ?? ?? 48 89 83 90 00 00 00 48 8B 83 90 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_229_25_0 {
	meta:
		name = "?UpdateRamblingState@VirtualProcessor@details@Concurrency@@QEAAX_NPEAVSchedulingRing@23@@Z"
		size = 120
		refs = "0047 ?CheckForNewOwningRing@SchedulingNode@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 4C 8B C9 4C 39 41 78 74 6E 8B 81 98 00 00 00 45 33 D2 84 D2 74 35 85 C0 75 5D 48 8B 41 70 4C 89 41 78 41 8D 52 01 C7 81 98 00 00 00 01 00 00 00 F0 0F C1 50 18 48 8B 41 70 FF C2 8B 48 14 3B D1 75 35 49 8B 49 70 E9 ?? ?? ?? ?? 85 C0 74 28 48 8B 41 70 48 8B 48 08 49 89 49 78 49 89 89 80 00 00 00 45 87 91 98 00 00 00 41 83 FA 01 75 08 49 8B 41 70 F0 FF 48 18 C3 }
	condition:
		$1
}

rule file_229_26_0 {
	meta:
		name = "?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
		size = 156
		refs = "0018 ?g_pEtw@details@Concurrency@@3PEAVEtw@12@EA 0036 memset 003d ?g_ConcRTSessionHandle@details@Concurrency@@3_KA 004b VirtualProcessorEventGuid 0081 ?Trace@Etw@details@Concurrency@@QEAAK_KPEAU_EVENT_TRACE_HEADER@@@Z"
	strings:
		$1 = { 48 8B C4 48 89 68 08 48 89 70 10 48 89 78 18 41 54 48 83 EC 60 48 83 3D ?? ?? ?? ?? 00 41 8B F9 41 8B F0 40 8A EA 44 8B E1 74 5A 33 D2 48 8D 48 BA 44 8D 42 3E E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 0F 10 05 ?? ?? ?? ?? 41 BB 40 00 00 00 4C 8D 44 24 20 C7 44 24 4C 00 00 02 00 F3 0F 7F 44 24 38 44 88 64 24 24 40 88 6C 24 25 89 74 24 54 66 44 89 5C 24 20 89 7C 24 50 E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 6B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 41 5C C3 }
	condition:
		$1
}

rule file_229_28_0 {
	meta:
		name = "?SafePoint@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
		size = 19
		refs = "000f ?MarkSafePoint@SchedulerBase@details@Concurrency@@QEAA_NPEAVSafePointMarker@23@@Z"
	strings:
		$1 = { 48 8B 41 70 48 8D 91 00 01 00 00 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_29_0 {
	meta:
		name = "??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_HyperNonReentrantLock@12@@Z"
		size = 72
		refs = "0027 ??_U@YAPEAX_K@Z 003b memset"
		altNames = "??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_CriticalNonReentrantLock@12@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 C7 01 00 00 00 00 48 8B D9 48 89 51 18 C7 41 04 00 00 00 00 C7 41 08 3F 00 00 00 B9 00 02 00 00 E8 ?? ?? ?? ?? 33 D2 41 B8 00 02 00 00 48 8B C8 48 89 43 10 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_229_31_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 44
		altNames = "?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ ?PopStructured@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 4C 8B C9 8B 49 04 4D 63 41 08 49 8B 51 10 FF C9 48 63 C1 41 89 49 04 4C 23 C0 33 C0 4A 87 04 C2 48 85 C0 75 06 FF C1 41 89 49 04 C3 }
	condition:
		$1
}

rule file_229_35_0 {
	meta:
		name = "?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AEAAPEAVInternalContextBase@23@XZ"
		size = 63
	strings:
		$1 = { 8B 51 14 8B 41 10 4C 8B C1 2B D0 85 D2 7E 2D 44 8B 49 14 48 63 51 18 41 FF C9 44 89 49 14 48 8B 49 20 49 63 C1 48 23 D0 33 C0 48 87 04 D1 48 85 C0 75 0B 41 8D 49 01 41 89 48 14 C3 33 C0 C3 }
	condition:
		$1
}

rule file_229_37_0 {
	meta:
		name = "??0VirtualProcessor@details@Concurrency@@QEAA@XZ"
		size = 139
		refs = "0014 ??_7VirtualProcessor@details@Concurrency@@6B@ 003d ??_U@YAPEAX_K@Z 0051 memset"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 99 B8 00 00 00 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 C7 41 10 00 00 00 00 C7 41 14 00 00 00 00 48 89 59 28 C7 41 18 3F 00 00 00 B9 00 02 00 00 E8 ?? ?? ?? ?? 33 D2 41 B8 00 02 00 00 48 8B C8 48 89 47 20 E8 ?? ?? ?? ?? 48 83 67 40 00 48 83 67 48 00 48 83 67 58 00 48 83 67 60 00 C7 03 00 00 00 00 48 8B 5C 24 30 C6 87 D0 00 00 00 00 83 A7 00 01 00 00 00 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_229_40_0 {
	meta:
		name = "?Initialize@VirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
		size = 241
		refs = "009c ?Reset@WorkSearchContext@details@Concurrency@@QEAAXPEAVVirtualProcessor@23@W4Algorithm@123@@Z 00c1 ?g_TraceOn@details@Concurrency@@3_NA 00cb ?g_EnableLevel@details@Concurrency@@3EA 00dd ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 89 51 70 48 8B 42 08 48 89 81 80 00 00 00 48 8B 42 08 4C 89 81 88 00 00 00 48 89 41 78 48 8B 41 70 40 88 B1 C1 00 00 00 89 B1 98 00 00 00 40 88 B1 C0 00 00 00 48 8B D9 C7 41 08 01 00 00 00 40 88 B1 C3 00 00 00 48 89 B1 A0 00 00 00 48 89 B1 A8 00 00 00 48 89 B1 B0 00 00 00 48 89 B1 C8 00 00 00 89 B1 00 01 00 00 48 89 B1 90 00 00 00 48 8B 08 39 71 14 49 8B F8 48 8B D3 48 8D 4B 30 44 8D 46 01 74 04 44 8D 46 02 E8 ?? ?? ?? ?? 48 8B 07 48 8B CF FF 50 20 89 83 BC 00 00 00 8B F8 48 8B 43 70 48 8B 08 48 8B 01 FF 50 08 40 38 35 ?? ?? ?? ?? 74 1A B2 04 38 15 ?? ?? ?? ?? 72 10 44 8B CF 44 8B C0 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_229_41_0 {
	meta:
		name = "??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
		size = 71
		refs = "0019 ??_7VirtualProcessor@details@Concurrency@@6B@ 002d ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPEAVSubAllocator@23@@Z 0043 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 89 90 00 00 00 48 85 C9 74 0D E8 ?? ?? ?? ?? 48 83 A3 90 00 00 00 00 48 8B 4B 20 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_42_0 {
	meta:
		name = "?dtor$0@?0???1VirtualProcessor@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_103_0 {
	meta:
		name = "?dtor$0@?0???1InternalContextBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1ContextBase@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_382_1 {
	meta:
		name = "?dtor$1@?0???0_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPEAV?$ITarget@W4agent_status@Concurrency@@@1@AEBW4agent_status@1@@Z@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_268_1 {
	meta:
		name = "?dtor$1@?0???0_Originator@?1???$send@_K@Concurrency@@YA_NPEAV?$ITarget@_K@1@AEB_K@Z@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_43_0 {
	meta:
		name = "?MarkForRetirement@VirtualProcessor@details@Concurrency@@AEAAXXZ"
		size = 81
		refs = "0008 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 83 EC 28 4C 8B C9 E8 ?? ?? ?? ?? 84 C0 74 34 49 8B 91 B0 00 00 00 48 85 D2 74 1A 49 8B 89 88 00 00 00 41 C6 81 C1 00 00 00 01 48 8B 01 48 83 C4 28 48 FF 60 28 49 8B 01 49 8B C9 48 83 C4 28 48 FF 60 18 41 C6 81 C1 00 00 00 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_229_46_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
		size = 92
		refs = "0017 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ"
		altNames = "?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 48 8B 49 48 E8 ?? ?? ?? ?? 33 DB 84 C0 75 2B 48 8B 7E 20 EB 19 48 8D 8F 10 FF FF FF 48 8B 3F 48 85 C9 74 0A 48 8B 01 BA 01 00 00 00 FF 10 48 85 FF 75 E2 48 89 5E 20 87 5E 78 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_229_48_0 {
	meta:
		name = "?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVVirtualProcessor@23@H_N@Z"
		size = 323
		refs = "00b0 __imp_QueryDepthSList 00cb __imp_InterlockedPushEntrySList 00e8 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 00ff __imp_InterlockedFlushSList 010e ?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z 011a ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 48 83 EC 30 48 8B D9 8B 49 54 BD 01 00 00 00 44 8B 5B 50 45 8B D0 48 8B F2 44 2B DD 41 D3 FA 45 23 D8 44 3B 53 6C 0F 8D F4 00 00 00 48 8B 43 60 44 3B 53 68 7C 1F 48 63 4B 68 4C 8B 44 C8 F8 78 1B 44 2B 53 68 42 8D 44 15 00 48 2B C5 4D 8B 40 08 75 F7 EB 07 49 63 CA 4C 8B 04 C8 49 8B 10 48 89 74 24 50 49 63 CB 48 8B 44 24 50 45 33 E4 F0 4C 0F B1 24 CA 48 89 44 24 20 48 8B 4C 24 20 48 8B 44 24 50 48 3B C8 0F 85 93 00 00 00 41 8D 44 24 FE F0 45 0F B1 58 10 45 84 C9 74 7E 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 96 F0 00 00 00 44 0F B7 D8 44 3B 5B 74 7E 5B 48 8D 4B 10 FF 15 ?? ?? ?? ?? 48 8D 4B 10 FF 15 ?? ?? ?? ?? 44 0F B7 D8 44 3B 5B 74 7E 46 48 8B 4B 48 E8 ?? ?? ?? ?? 84 C0 75 39 33 C0 F0 0F B1 6B 78 75 30 48 8D 4B 10 FF 15 ?? ?? ?? ?? 4C 8B 4B 48 48 8D 4B 28 48 8D 15 ?? ?? ?? ?? 4C 8B C3 48 89 43 20 E8 ?? ?? ?? ?? EB 09 48 8B CB FF 15 ?? ?? ?? ?? 40 8A C5 EB 02 32 C0 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_229_50_0 {
	meta:
		name = "?Retire@VirtualProcessor@details@Concurrency@@MEAAXXZ"
		size = 405
		refs = "0039 ?UpdateRamblingState@VirtualProcessor@details@Concurrency@@QEAAX_NPEAVSchedulingRing@23@@Z 00d2 ?GetScheduleGroup@ContextBase@details@Concurrency@@QEBAPEAVScheduleGroupBase@23@XZ 00e0 ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IEAAXPEAVInternalContextBase@23@PEAVVirtualProcessor@23@@Z 0137 ?g_TraceOn@details@Concurrency@@3_NA 0142 ?g_EnableLevel@details@Concurrency@@3EA 0154 ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z 0165 ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPEAVSubAllocator@23@@Z 0191 ?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVVirtualProcessor@23@H_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 80 B9 D0 00 00 00 00 48 8B D9 74 10 48 8B 41 70 48 8B D3 48 8B 08 48 8B 01 FF 50 68 8B 83 98 00 00 00 85 C0 74 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? 48 8B 43 70 F0 FF 48 14 80 BB C0 00 00 00 00 75 0B 48 8B 43 70 48 8B 08 F0 FF 49 1C 48 8B 43 70 48 8B 10 8B 83 A0 00 00 00 8B C8 2B 8B A8 00 00 00 89 83 A8 00 00 00 F0 0F C1 8A 80 01 00 00 8B 83 A4 00 00 00 8B C8 2B 8B AC 00 00 00 89 83 AC 00 00 00 F0 0F C1 8A 84 01 00 00 48 83 A3 B0 00 00 00 00 8B 43 10 8B 4B 14 2B C8 33 FF 85 C9 7E 4C 8B 53 14 48 63 4B 18 FF CA 48 63 C2 48 23 C8 48 8B 43 20 89 53 14 48 87 3C C8 48 85 FF 74 27 48 8D 4F 10 E8 ?? ?? ?? ?? 45 33 C0 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 44 8B 5B 10 8B 43 14 41 2B C3 33 FF 85 C0 EB B8 8D 42 01 89 43 14 48 85 FF 75 CE 48 8B 43 70 48 8B 8B 88 00 00 00 48 8B 10 4C 8B 01 48 8B 92 68 01 00 00 41 FF 50 10 48 21 BB 88 00 00 00 48 8B 43 70 48 8B 08 8B BB BC 00 00 00 48 8B 01 FF 50 08 80 3D ?? ?? ?? ?? 00 74 1A B2 04 38 15 ?? ?? ?? ?? 72 10 44 8B CF 44 8B C0 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B 8B 90 00 00 00 48 85 C9 74 0D E8 ?? ?? ?? ?? 48 83 A3 90 00 00 00 00 48 8B 4B 70 44 8B 83 9C 00 00 00 41 B1 01 48 83 C1 20 48 8B D3 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_5_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z"
		size = 491
		refs = "0022 __security_cookie 003f _errno 004b _invalid_parameter_noinfo 0055 wcsnlen 0086 __crtLCMapStringW 0124 __chkstk 013e malloc 019e wcscpy_s 01bf free 01cd __security_check_cookie"
	strings:
		$1 = { 40 55 41 55 41 56 48 83 EC 40 48 8D 6C 24 30 48 89 5D 30 48 89 75 38 48 89 7D 40 4C 89 65 48 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 00 45 33 F6 4D 8B E8 48 8B F2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? E9 6F 01 00 00 E8 ?? ?? ?? ?? 48 3B C6 72 06 66 44 89 33 EB DA 49 8B 45 00 8B 48 14 85 C9 74 54 41 83 C9 FF 4C 8B C3 BA 00 02 00 00 44 89 74 24 28 4C 89 74 24 20 E8 ?? ?? ?? ?? 4C 63 E0 85 C0 75 3F E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 E8 ?? ?? ?? ?? 8B 00 E9 1C 01 00 00 0F B7 03 66 83 F8 61 72 0D 66 83 F8 7A 77 07 66 83 E8 20 66 89 03 48 83 C3 02 66 44 39 33 75 E0 33 C0 E9 F5 00 00 00 49 8B CC 49 3B F4 73 13 66 44 89 33 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 5D FF FF FF 85 C0 7E 67 33 D2 48 8D 42 E0 48 F7 F1 48 83 F8 02 72 58 4B 8D 4C 24 10 48 81 F9 00 04 00 00 77 31 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 30 48 85 FF 74 29 C7 07 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0F C7 00 DD DD 00 00 48 83 C7 10 EB 03 49 8B FE 48 85 FF 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 2F FF FF FF 49 8B 45 00 41 83 C9 FF 4C 8B C3 8B 48 14 BA 00 02 00 00 44 89 64 24 28 48 89 7C 24 20 E8 ?? ?? ?? ?? 85 C0 74 12 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B D8 EB 0C E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 30 48 8B 75 38 48 8B 7D 40 4C 8B 65 48 48 8D 65 10 41 5E 41 5D 5D C3 }
	condition:
		$1
}

rule file_230_9_0 {
	meta:
		name = "_wcsupr"
		size = 111
		refs = "000f __locale_changed 001b _errno 0026 _invalid_parameter_noinfo 0062 _wcsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 48 8B D9 44 39 05 ?? ?? ?? ?? 75 48 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3B 48 8B C1 66 44 39 01 74 2F 0F B7 08 BA 61 00 00 00 66 3B D1 77 0D 66 83 F9 7A 77 07 66 83 E9 20 66 89 08 48 83 C0 02 66 44 39 00 75 DC EB 09 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "_abstract_cw"
		size = 156
	strings:
		$1 = { 33 C0 F6 C1 80 41 BA 00 02 00 00 8D 50 10 0F 45 C2 41 85 CA 74 03 83 C8 08 0F BA E1 0A 73 03 83 C8 04 0F BA E1 0B 73 03 83 C8 02 0F BA E1 0C 73 03 83 C8 01 41 B8 00 01 00 00 41 85 C8 74 04 0F BA E8 13 8B D1 41 B9 00 60 00 00 41 23 D1 74 24 81 FA 00 20 00 00 74 19 81 FA 00 40 00 00 74 0C 41 3B D1 75 0F 0D 00 03 00 00 EB 08 41 0B C2 EB 03 41 0B C0 81 E1 40 80 00 00 83 E9 40 74 18 81 E9 C0 7F 00 00 74 0A 83 F9 40 75 0F 0F BA E8 18 C3 0D 00 00 00 03 C3 0F BA E8 19 C3 }
	condition:
		$1
}

rule file_231_1_0 {
	meta:
		name = "_hw_cw"
		size = 156
	strings:
		$1 = { 33 C0 F6 C1 10 BA 80 00 00 00 0F 45 C2 41 BA 00 02 00 00 F6 C1 08 74 03 41 0B C2 F6 C1 04 74 04 0F BA E8 0A F6 C1 02 74 04 0F BA E8 0B F6 C1 01 74 04 0F BA E8 0C 41 B8 00 01 00 00 0F BA E1 13 73 03 41 0B C0 8B D1 41 B9 00 03 00 00 41 23 D1 74 20 41 3B D0 74 17 41 3B D2 74 0C 41 3B D1 75 11 0D 00 60 00 00 EB 0A 0F BA E8 0E EB 04 0F BA E8 0D BA 00 00 00 03 23 CA 81 F9 00 00 00 01 74 15 81 F9 00 00 00 02 74 09 3B CA 75 0E 0F BA E8 0F C3 83 C8 40 C3 0D 40 80 00 00 C3 }
	condition:
		$1
}

rule file_231_2_0 {
	meta:
		name = "_abstract_sw"
		size = 57
	strings:
		$1 = { 33 C0 F6 C1 3F 74 31 F6 C1 01 8D 50 10 0F 45 C2 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 84 CA 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 04 0F BA E8 13 C3 }
	condition:
		$1
}

rule file_231_4_0 {
	meta:
		name = "_statusfp"
		size = 66
	strings:
		$1 = { 0F AE 5C 24 08 33 C0 8B 4C 24 08 F6 C1 3F 74 31 F6 C1 01 8D 50 10 0F 45 C2 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 84 CA 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 04 0F BA E8 13 C3 }
	condition:
		$1
}

rule file_231_5_0 {
	meta:
		name = "_clearfp"
		size = 80
		refs = "0007 _get_fpsr 000e _fclrf"
	strings:
		$1 = { 40 53 48 83 EC 20 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 F6 C3 3F 74 31 F6 C3 01 8D 48 10 0F 45 C1 F6 C3 04 74 03 83 C8 08 F6 C3 08 74 03 83 C8 04 84 D9 74 03 83 C8 02 F6 C3 20 74 03 83 C8 01 F6 C3 02 74 04 0F BA E8 13 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_231_6_0 {
	meta:
		name = "_control87"
		size = 656
		refs = "0024 _get_fpsr 01a2 ?dazSupported@?1??_control87@@9@9 01b0 _set_fpsr"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 41 54 41 55 41 56 48 83 EC 20 8B DA 8B F1 81 E3 1F 03 08 03 E8 ?? ?? ?? ?? 44 8B D8 33 FF 41 BA 80 00 00 00 41 84 C2 8B C7 8D 4F 10 0F 45 C1 41 BE 00 02 00 00 45 85 DE 74 03 83 C8 08 41 0F BA E3 0A 73 03 83 C8 04 41 B8 00 08 00 00 45 85 D8 74 03 83 C8 02 41 B9 00 10 00 00 45 85 D9 74 03 83 C8 01 41 BC 00 01 00 00 45 85 DC 74 04 0F BA E8 13 41 8B CB 41 BD 00 60 00 00 41 23 CD 74 24 81 F9 00 20 00 00 74 19 81 F9 00 40 00 00 74 0C 41 3B CD 75 0F 0D 00 03 00 00 EB 08 41 0B C6 EB 03 41 0B C4 BA 40 80 00 00 44 23 DA 41 83 EB 40 74 1C 41 81 EB C0 7F 00 00 74 0C 41 83 FB 40 75 11 0F BA E8 18 EB 0B 0D 00 00 00 03 EB 04 0F BA E8 19 8B CB F7 D1 23 C8 23 F3 0B CE 3B C8 0F 84 83 01 00 00 BE 10 00 00 00 40 84 CE 8B DF 41 0F 45 DA 89 5C 24 40 F6 C1 08 74 07 41 0B DE 89 5C 24 40 F6 C1 04 74 08 0F BA EB 0A 89 5C 24 40 F6 C1 02 74 07 41 0B D8 89 5C 24 40 F6 C1 01 74 07 41 0B D9 89 5C 24 40 0F BA E1 13 73 07 41 0B DC 89 5C 24 40 8B C1 25 00 03 00 00 74 24 41 3B C4 74 17 41 3B C6 74 0C 3D 00 03 00 00 75 13 41 0B DD EB 0A 0F BA EB 0E EB 04 0F BA EB 0D 89 5C 24 40 81 E1 00 00 00 03 81 F9 00 00 00 01 74 1B 81 F9 00 00 00 02 74 0E 81 F9 00 00 00 03 75 11 0F BA EB 0F EB 07 83 CB 40 EB 02 0B DA 89 5C 24 40 40 38 3D ?? ?? ?? ?? 74 3C F6 C3 40 74 37 8B CB E8 ?? ?? ?? ?? EB 2C C6 05 ?? ?? ?? ?? 00 8B 5C 24 40 83 E3 BF 8B CB E8 ?? ?? ?? ?? 33 FF 8D 77 10 41 BE 00 02 00 00 41 BC 00 01 00 00 41 BD 00 60 00 00 EB 0A 83 E3 BF 8B CB E8 ?? ?? ?? ?? F6 C3 80 0F 45 FE 41 85 DE 74 03 83 CF 08 0F BA E3 0A 73 03 83 CF 04 0F BA E3 0B 73 03 83 CF 02 0F BA E3 0C 73 03 83 CF 01 41 85 DC 74 04 0F BA EF 13 8B C3 41 23 C5 74 23 3D 00 20 00 00 74 19 3D 00 40 00 00 74 0D 41 3B C5 75 10 81 CF 00 03 00 00 EB 08 41 0B FE EB 03 41 0B FC 81 E3 40 80 00 00 83 EB 40 74 1B 81 EB C0 7F 00 00 74 0B 83 FB 40 75 12 0F BA EF 18 EB 0C 81 CF 00 00 00 03 EB 04 0F BA EF 19 8B C7 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5E 41 5D 41 5C C3 }
	condition:
		$1
}

rule file_231_7_0 {
	meta:
		name = "_control87$filt$0"
		size = 44
		altNames = "_ctrlfp$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 81 38 05 00 00 C0 74 0C 81 38 1D 00 00 C0 74 04 33 C0 EB 05 B8 01 00 00 00 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_231_9_0 {
	meta:
		name = "_set_controlfp"
		size = 52
		refs = "002b _control87"
	strings:
		$1 = { 48 83 EC 28 81 F9 1F 00 09 00 75 1A 83 FA FF 75 15 0F AE 5C 24 30 8B 44 24 30 25 C0 FE 00 00 3D 80 1E 00 00 74 09 0F BA F2 13 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "_mbctokata_l"
		size = 41
		refs = "0009 _ismbchira_l"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 85 C0 74 10 81 C3 A1 00 00 00 81 FB 7F 83 00 00 72 02 FF C3 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "_vswprintf_l"
		size = 221
		refs = "0037 memset 0041 _errno 004c _invalid_parameter_noinfo 007e _woutput_l 00a4 _flsbuf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 55 48 8B EC 48 83 EC 50 48 83 65 D0 00 48 8B FA 33 D2 4D 8B E0 48 8B D9 44 8D 42 28 48 8D 4D D8 49 8B F1 E8 ?? ?? ?? ?? 48 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6E 48 85 DB 74 E6 48 8D 4D D0 4C 8B CE 4D 8B C4 48 8B D7 C7 45 E8 42 00 00 00 48 89 5D E0 48 89 5D D0 C7 45 D8 FF FF FF 7F E8 ?? ?? ?? ?? FF 4D D8 8B D8 78 14 48 8B 4D D0 C6 01 00 48 8B 4D D0 48 FF C1 48 89 4D D0 EB 0F 48 8D 55 D0 33 C9 E8 ?? ?? ?? ?? 48 8B 4D D0 FF 4D D8 78 05 C6 01 00 EB 0B 48 8D 55 D0 33 C9 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 4C 8B 64 24 78 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_233_3_0 {
	meta:
		name = "_vscwprintf_helper"
		size = 143
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo"
		altNames = "_vscprintf_helper"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F0 48 8B E9 44 8D 42 28 48 8D 48 D0 49 8B F9 E8 ?? ?? ?? ?? 48 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 2C 48 83 64 24 30 00 48 83 64 24 20 00 48 8D 4C 24 20 4C 8B CF 4C 8B C6 48 8B D3 C7 44 24 28 FF FF FF 7F C7 44 24 38 42 00 00 00 FF D5 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_endthreadex"
		size = 35
		refs = "0009 _getptd_noexit 0016 _freeptd 001e __imp_ExitThread"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 48 85 C0 74 08 48 8B C8 E8 ?? ?? ?? ?? 8B CB FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_callthreadstartex"
		size = 44
		refs = "0005 _getptd 001a _endthreadex 0022 _exit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 90 48 8B 88 98 00 00 00 FF 90 90 00 00 00 8B C8 E8 ?? ?? ?? ?? 90 8B C8 E8 ?? ?? ?? ?? 90 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_234_3_0 {
	meta:
		name = "_threadstartex"
		size = 128
		refs = "000a __set_flsgetvalue 000f __get_flsindex 0016 __fls_getvalue 002d __fls_setvalue 0037 __imp_GetLastError 003f __imp_ExitThread 0046 __imp_GetCurrentThreadId 0076 _freefls 007b _callthreadstartex"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 75 2C E8 ?? ?? ?? ?? 48 8B D3 8B C8 E8 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 FF 15 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 89 03 EB 2C 48 8B 83 90 00 00 00 48 8B CB 49 89 83 90 00 00 00 48 8B 83 98 00 00 00 49 89 83 98 00 00 00 48 8B 43 08 49 89 43 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_234_4_0 {
	meta:
		name = "_beginthreadex"
		size = 242
		refs = "002c _errno 0037 _invalid_parameter_noinfo 0041 __set_flsgetvalue 0050 _calloc_crt 005d _getptd 006c _initptd 0098 _threadstartex 00b3 __imp_CreateThread 00be __imp_GetLastError 00c8 free 00d3 _dosmaperr"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 20 57 41 54 41 55 48 83 EC 30 33 DB 49 8B E9 49 8B F0 44 8B E2 4C 8B E9 4D 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 97 00 00 00 E8 ?? ?? ?? ?? BA C8 02 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 68 E8 ?? ?? ?? ?? 48 8B CF 48 8B 90 C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 83 4F 08 FF 8B 44 24 70 48 85 C9 4C 8D 44 24 60 4C 0F 45 C1 49 8B D4 4C 8B CF 4C 89 44 24 28 4C 8D 05 ?? ?? ?? ?? 49 8B CD 48 89 B7 90 00 00 00 48 89 AF 98 00 00 00 89 44 24 20 FF 15 ?? ?? ?? ?? 48 85 C0 75 1D FF 15 ?? ?? ?? ?? 8B D8 48 8B CF E8 ?? ?? ?? ?? 85 DB 74 07 8B CB E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 68 48 83 C4 30 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "memchr"
		size = 27
	strings:
		$1 = { 4D 85 C0 74 0C 38 11 74 08 48 FF C1 49 FF C8 75 F4 49 F7 D8 48 1B C0 48 23 C1 C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "wcscat_s"
		size = 133
		refs = "0020 _errno 002c _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 D2 4C 8B C9 48 85 C9 74 0E 48 85 D2 74 09 4D 85 C0 75 1D 66 44 89 11 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 66 44 39 11 74 09 48 83 C1 02 48 FF CA 75 F1 48 85 D2 75 06 66 45 89 11 EB CD 49 2B C8 41 0F B7 00 66 42 89 04 01 49 83 C0 02 66 85 C0 74 05 48 FF CA 75 E9 48 85 D2 75 10 66 45 89 11 E8 ?? ?? ?? ?? BB 22 00 00 00 EB A8 33 C0 EB AD }
	condition:
		$1
}

rule file_238_3_0 {
	meta:
		name = "_mbspbrk_l"
		size = 242
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0035 strpbrk 0044 _errno 004f _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 48 8B D9 48 8B FA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 48 8B 54 24 28 33 F6 39 72 08 75 10 48 8B D7 48 8B CB E8 ?? ?? ?? ?? E9 91 00 00 00 48 85 DB 75 27 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 40 38 74 24 38 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 33 C0 EB 78 48 85 FF 74 D4 EB 4F 48 8B CF 40 38 37 74 2D 0F B6 01 F6 44 10 1D 04 74 17 3A 03 75 08 8A 43 01 38 41 01 74 17 40 38 71 01 74 11 48 FF C1 EB 04 3A 03 74 08 48 FF C1 40 38 31 75 D3 40 38 31 75 1A 0F B6 03 F6 44 10 1D 04 74 08 48 FF C3 40 38 33 74 08 48 FF C3 40 38 33 75 AC 8A 03 F6 D8 48 1B C0 48 23 C3 40 38 74 24 38 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_239_3_0 {
	meta:
		name = "_mbstok_s_l"
		size = 517
		refs = "0031 _errno 003c _invalid_parameter_noinfo 005e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0076 strtok_s 00b7 _ismbblead_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 40 45 33 FF 4D 8B F0 4C 8B EA 48 8B D9 4D 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 A0 01 00 00 48 85 D2 74 E4 48 85 C9 75 05 4D 39 38 74 DA 48 8D 4D E0 49 8B D1 E8 ?? ?? ?? ?? 4C 8B 5D E8 45 39 7B 08 75 28 4D 8B C6 49 8B D5 48 8B CB E8 ?? ?? ?? ?? 44 38 7D F8 0F 84 63 01 00 00 48 8B 4D F0 83 A1 C8 00 00 00 FD E9 53 01 00 00 48 85 DB 75 03 49 8B 1E 44 38 3B 74 7D BE 2A 00 00 00 49 8B FD 45 38 7D 00 74 41 0F B6 0F 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 17 8A 4F 01 84 C9 74 20 8A 03 38 07 75 05 3A 4B 01 74 1F 48 FF C7 EB 06 8A 03 38 07 74 14 48 FF C7 44 38 3F 74 3A EB C9 48 FF C7 E8 ?? ?? ?? ?? 89 30 44 38 3F 74 29 0F B6 0B 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF C3 44 38 3B 74 0A 48 FF C3 44 38 3B 74 09 EB 8F E8 ?? ?? ?? ?? 89 30 48 8B F3 44 38 3B 0F 84 87 00 00 00 49 8B FD 45 8B E7 45 38 7D 00 74 42 0F B6 0F 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 17 8A 4F 01 84 C9 74 28 8A 03 38 07 75 05 3A 4B 01 74 15 48 FF C7 EB 06 8A 03 38 07 74 15 48 FF C7 44 38 3F 74 12 EB C9 41 BC 01 00 00 00 EB 03 48 FF C7 44 38 3F 75 23 0F B6 0B 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 09 44 38 7B 01 74 08 48 FF C3 48 FF C3 EB 86 44 88 3B EB 11 44 88 3B 48 FF C3 45 85 E4 74 06 44 88 3B 48 FF C3 49 89 1E 48 3B F3 75 1A 44 38 7D F8 0F 84 7D FE FF FF 48 8B 45 F0 83 A0 C8 00 00 00 FD E9 6D FE FF FF 44 38 7D F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 48 8B C6 4C 8D 5C 24 40 49 8B 5B 30 49 8B 73 38 49 8B 7B 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_240_9_0 {
	meta:
		name = "?FreeScheduleGroup@SchedulingRing@details@Concurrency@@QEAAXPEAVScheduleGroupBase@23@@Z"
		size = 31
	strings:
		$1 = { 48 83 EC 28 4C 8B C2 48 85 D2 74 0E 48 8B 02 49 8B C8 BA 01 00 00 00 FF 50 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_240_12_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
		size = 26
		refs = "0006 __imp_InterlockedPopEntrySList"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 48 85 C0 74 06 48 05 C0 FE FF FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_240_21_0 {
	meta:
		name = "??$_InternalDeleteHelper@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@YAXPEAVScheduleGroupBase@01@@Z"
		size = 25
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_240_28_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
		size = 50
	strings:
		$1 = { 48 85 D2 74 2C 53 48 83 EC 20 48 8B DA 48 8D 8B C0 FE FF FF 48 8B 1B 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 20 48 85 DB 75 E1 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_240_30_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
		size = 93
		refs = "0017 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ"
		altNames = "?CheckForDeletionBridge@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 48 8B 49 48 E8 ?? ?? ?? ?? 33 DB 84 C0 75 2C 48 8B 7E 20 EB 1A 48 8D 8F C0 FE FF FF 48 8B 3F 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 20 48 85 FF 75 E1 48 89 5E 20 87 5E 78 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_240_33_0 {
	meta:
		name = "??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 265
		refs = "0019 __imp_InterlockedFlushSList 00d8 ??_V@YAXPEAX@Z 00e0 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F9 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 20 48 8D 8B C0 FE FF FF 48 8B 1B 48 85 C9 74 0C 4C 8B 01 BA 01 00 00 00 41 FF 50 20 48 85 DB 75 E0 48 8D 4F 10 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 20 48 8D 8B C0 FE FF FF 48 8B 1B 48 85 C9 74 0C 4C 8B 01 BA 01 00 00 00 41 FF 50 20 48 85 DB 75 E0 48 8B 5F 20 EB 1A 48 8D 8B C0 FE FF FF 48 8B 1B 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 20 48 85 DB 75 E1 48 8B 77 58 48 85 F6 74 47 33 DB 39 5F 50 7E 24 33 ED 48 8B 06 48 8B 0C 28 48 85 C9 74 0B 48 8B 01 BA 01 00 00 00 FF 50 20 FF C3 48 83 C5 08 3B 5F 50 7C DE 48 8B 0E 48 8B 5E 08 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B F3 48 85 DB 75 B9 48 8B 4F 60 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_34_0 {
	meta:
		name = "?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAAHPEAVScheduleGroupBase@23@@Z"
		size = 370
		refs = "00c4 ??_U@YAPEAX_K@Z 00d9 memset 00e3 ??2@YAPEAX_K@Z 012a ?_UnderlyingYield@details@Concurrency@@YAXXZ 0139 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 41 55 41 57 48 83 EC 40 48 8B 59 58 33 F6 40 32 ED 4C 8B EA 48 8B F9 49 83 CB FF 44 8D 7E 01 44 39 5B 10 7C 53 4C 8B 0B 33 D2 39 57 50 7E 49 4D 8B C1 49 83 38 00 75 1B 8D 04 32 48 63 CA 41 89 85 B0 00 00 00 44 8B 57 70 33 C0 F0 4D 0F B1 2C C9 74 0E 41 03 D7 49 83 C0 08 3B 57 50 7D 19 EB D1 03 F2 41 8A EF 41 3B F2 7C 05 F0 44 01 7F 70 8B C2 F0 44 0F B1 5B 10 40 84 ED 0F 85 B4 00 00 00 B9 FE FF FF FF 41 8B C3 F0 0F B1 4B 10 03 77 50 48 83 7B 08 00 75 76 33 C0 F0 4C 0F B1 7B 08 75 6C 48 63 4F 50 B8 08 00 00 00 48 F7 E1 49 0F 40 C3 48 8B C8 E8 ?? ?? ?? ?? 4C 63 47 50 33 D2 49 C1 E0 03 48 8B C8 4C 8B E0 E8 ?? ?? ?? ?? B9 18 00 00 00 E8 ?? ?? ?? ?? 4C 8B D8 48 85 C0 74 0E 48 83 60 08 00 83 48 10 FF 4C 89 20 EB 03 45 33 DB 48 63 47 6C 3B 47 68 7D 0F 48 8B C8 48 8B 47 60 4C 89 1C C8 44 01 7F 6C 4C 87 5B 08 4C 39 7B 08 75 21 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 39 7B 08 74 F0 48 8B 5B 08 49 C7 C3 FF FF FF FF 40 84 ED 0F 84 D6 FE FF FF 4C 8D 5C 24 40 8B C6 49 8B 5B 38 49 8B 6B 40 49 8B E3 41 5F 41 5D 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_240_38_0 {
	meta:
		name = "?Remove@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVScheduleGroupBase@23@H_N@Z"
		size = 323
		refs = "00b0 __imp_QueryDepthSList 00cb __imp_InterlockedPushEntrySList 00e8 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QEAA_NXZ 00ff __imp_InterlockedFlushSList 010e ?CheckForDeletionBridge@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z 011a ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 48 83 EC 30 48 8B D9 8B 49 54 BD 01 00 00 00 44 8B 5B 50 45 8B D0 48 8B F2 44 2B DD 41 D3 FA 45 23 D8 44 3B 53 6C 0F 8D F4 00 00 00 48 8B 43 60 44 3B 53 68 7C 1F 48 63 4B 68 4C 8B 44 C8 F8 78 1B 44 2B 53 68 42 8D 44 15 00 48 2B C5 4D 8B 40 08 75 F7 EB 07 49 63 CA 4C 8B 04 C8 49 8B 10 48 89 74 24 50 49 63 CB 48 8B 44 24 50 45 33 E4 F0 4C 0F B1 24 CA 48 89 44 24 20 48 8B 4C 24 20 48 8B 44 24 50 48 3B C8 0F 85 93 00 00 00 41 8D 44 24 FE F0 45 0F B1 58 10 45 84 C9 74 7E 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 96 40 01 00 00 44 0F B7 D8 44 3B 5B 74 7E 5B 48 8D 4B 10 FF 15 ?? ?? ?? ?? 48 8D 4B 10 FF 15 ?? ?? ?? ?? 44 0F B7 D8 44 3B 5B 74 7E 46 48 8B 4B 48 E8 ?? ?? ?? ?? 84 C0 75 39 33 C0 F0 0F B1 6B 78 75 30 48 8D 4B 10 FF 15 ?? ?? ?? ?? 4C 8B 4B 48 48 8D 4B 28 48 8D 15 ?? ?? ?? ?? 4C 8B C3 48 89 43 20 E8 ?? ?? ?? ?? EB 09 48 8B CB FF 15 ?? ?? ?? ?? 40 8A C5 EB 02 32 C0 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_240_42_0 {
	meta:
		name = "?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AEAAXPEAVScheduleGroupBase@23@@Z"
		size = 19
		refs = "000f ?Remove@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVScheduleGroupBase@23@H_N@Z"
	strings:
		$1 = { 44 8B 82 B0 00 00 00 48 83 C1 20 41 B1 01 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_49_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
		size = 71
		refs = "0037 ?Remove@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVScheduleGroupBase@23@H_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 81 BC 00 00 00 04 48 8B D1 75 2D 83 CB FF F0 0F C1 99 B4 00 00 00 FF CB 75 1A 48 8B 89 A0 00 00 00 44 8B 82 B0 00 00 00 41 B1 01 48 83 C1 20 E8 ?? ?? ?? ?? 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_240_51_0 {
	meta:
		name = "??0CacheLocalScheduleGroup@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z"
		size = 62
		refs = "000a ??0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z 0018 ??_7CacheLocalScheduleGroup@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 83 50 01 00 00 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 83 20 00 48 89 40 08 C7 40 10 00 00 00 00 C6 83 BC 00 00 00 01 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_240_55_0 {
	meta:
		name = "?Dequeue@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 37
	strings:
		$1 = { 48 8B 11 48 8B C1 48 85 D2 75 03 33 C0 C3 48 8B 8A 40 01 00 00 48 89 08 48 85 C9 75 04 48 89 40 08 48 8B C2 C3 }
	condition:
		$1
}

rule file_240_56_0 {
	meta:
		name = "?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 87
		refs = "0017 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 0040 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 83 C1 10 E8 ?? ?? ?? ?? 4C 8B 1F 33 F6 4D 85 DB 74 16 49 8B 83 40 01 00 00 48 89 07 48 85 C0 75 04 48 89 7F 08 49 8B F3 48 8D 4F 10 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_240_57_0 {
	meta:
		name = "?GetRunnableContext@CacheLocalScheduleGroup@details@Concurrency@@EEAAPEAVInternalContextBase@23@XZ"
		size = 100
		refs = "0026 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ 004d ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
		altNames = "?GetRunnableContext@FairScheduleGroup@details@Concurrency@@EEAAPEAVInternalContextBase@23@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D B9 50 01 00 00 33 F6 48 39 37 75 04 33 C0 EB 33 48 8D 4F 10 E8 ?? ?? ?? ?? 4C 8B 1F 4D 85 DB 74 16 49 8B 83 40 01 00 00 48 89 07 48 85 C0 75 04 48 89 7F 08 49 8B F3 48 8D 4F 10 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_240_59_0 {
	meta:
		name = "??0FairScheduleGroup@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z"
		size = 62
		refs = "000a ??0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z 0018 ??_7FairScheduleGroup@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 83 50 01 00 00 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 83 20 00 48 89 40 08 C7 40 10 00 00 00 00 C6 83 BC 00 00 00 02 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_240_62_0 {
	meta:
		name = "??1SchedulingRing@details@Concurrency@@QEAA@XZ"
		size = 106
		refs = "0053 ?Remove@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVScheduleGroupBase@23@H_N@Z 0066 ??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8B 41 10 80 A0 BC 00 00 00 FB 48 8B 51 10 F6 82 BC 00 00 00 04 75 29 83 C8 FF F0 0F C1 82 B4 00 00 00 FF C8 75 1A 48 8B 8A A0 00 00 00 48 83 C1 20 41 B1 01 44 8B 82 B0 00 00 00 E8 ?? ?? ?? ?? 48 83 63 10 00 48 8D 4B 20 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_64_0 {
	meta:
		name = "?AllocateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
		size = 197
		refs = "0026 ??2@YAPEAX_K@Z 003e ??0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulingRing@12@@Z 0045 ??_7CacheLocalScheduleGroup@details@Concurrency@@6B@ 008f ??_7FairScheduleGroup@details@Concurrency@@6B@"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B F9 48 8B 01 B9 70 01 00 00 83 78 14 00 75 4A E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 40 48 85 C0 74 34 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8D 83 50 01 00 00 48 83 20 00 48 89 40 08 C7 40 10 00 00 00 00 C6 83 BC 00 00 00 01 EB 02 33 DB EB 48 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 40 48 85 C0 74 34 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 89 1B 48 8D 83 50 01 00 00 48 83 20 00 48 89 40 08 C7 40 10 00 00 00 00 C6 83 BC 00 00 00 02 EB 02 33 DB 48 8B C3 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_240_65_0 {
	meta:
		name = "?dtor$0@?0??AllocateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ@4HA"
		size = 16
		refs = "0008 ??3CacheLocalScheduleGroup@details@Concurrency@@CAXPEAX@Z"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_998_2 {
	meta:
		name = "?dtor$0@?0???0?$_OrderBlock@V?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QEAA@_KPEAPEAVagent@1@PEAV?$ITarget@_K@1@@Z@4HA"
		size = 16
		refs = "0008 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_957_2 {
	meta:
		name = "?dtor$0@?0???0?$call@_KV?$function@$$A6AXAEB_K@Z@tr1@std@@@Concurrency@@QEAA@AEBV?$function@$$A6AXAEB_K@Z@tr1@std@@@Z@4HA"
		size = 16
		refs = "0008 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_864_1 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_867_2 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_749_1 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_967_1 {
	meta:
		name = "?dtor$0@?0???0?$single_assignment@_K@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_738_1 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_742_1 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_601_1 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_735_2 {
	meta:
		name = "?dtor$0@?0???0?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_845_34_0 {
	meta:
		name = "?dtor$0@?0???0WorkQueue@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_263_2 {
	meta:
		name = "?dtor$0@?0???0_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@tr1@std@@@Z@QEAA@0I@Z@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_278_2 {
	meta:
		name = "?dtor$0@?0???0_Blocking_recipient@?1???$_receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@tr1@std@@@Z@QEAA@0I@Z@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_381_1 {
	meta:
		name = "?dtor$0@?0???0_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPEAV?$ITarget@W4agent_status@Concurrency@@@1@AEBW4agent_status@1@@Z@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_267_1 {
	meta:
		name = "?dtor$0@?0???0_Originator@?1???$send@_K@Concurrency@@YA_NPEAV?$ITarget@_K@1@AEB_K@Z@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_993_1 {
	meta:
		name = "?dtor$0@?0???1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_849_2 {
	meta:
		name = "?dtor$0@?0???1?$call@_KV?$function@$$A6AXAEB_K@Z@tr1@std@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_811_2 {
	meta:
		name = "?dtor$0@?0???1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_830_2 {
	meta:
		name = "?dtor$0@?0???1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_870_2 {
	meta:
		name = "?dtor$0@?0???1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_925_2 {
	meta:
		name = "?dtor$0@?0???1?$single_assignment@_K@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_639_1 {
	meta:
		name = "?dtor$0@?0???1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_663_1 {
	meta:
		name = "?dtor$0@?0???1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_559_1 {
	meta:
		name = "?dtor$0@?0???1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_562_2 {
	meta:
		name = "?dtor$0@?0???1?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_687_2 {
	meta:
		name = "?dtor$0@?0???1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_735_290_0 {
	meta:
		name = "?dtor$0@?0???1SchedulerBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1Scheduler@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_385_2 {
	meta:
		name = "?dtor$0@?0???1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_620_2 {
	meta:
		name = "?dtor$0@?0???1_Blocking_recipient@?1???$_receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@tr1@std@@@Z@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_74_35_1 {
	meta:
		name = "?dtor$0@?0???1_Locimp@locale@std@@MEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1facet@locale@std@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_86_144_2 {
	meta:
		name = "?dtor$0@?0???1_Locinfo@std@@QEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_722_1 {
	meta:
		name = "?dtor$0@?0???_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "0008 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_16_726_2 {
	meta:
		name = "?dtor$0@?0???_G?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_73_38_2 {
	meta:
		name = "?dtor$0@?0???_G_Locimp@locale@std@@MEAAPEAXI@Z@4HA"
		size = 16
		refs = "0008 ??1facet@locale@std@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_816_1 {
	meta:
		name = "?dtor$7@?0???1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_85_835_1 {
	meta:
		name = "?dtor$7@?0???1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "0008 ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_240_67_0 {
	meta:
		name = "?CreateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
		size = 106
		refs = "0018 __imp_InterlockedPopEntrySList 0044 ?AllocateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ 0053 ?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAAHPEAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 83 C1 20 FF 15 ?? ?? ?? ?? 48 85 C0 74 1F 48 8D 98 C0 FE FF FF 48 85 DB 74 13 C7 83 B4 00 00 00 01 00 00 00 48 89 BB A0 00 00 00 EB 0B 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 8D 4F 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_240_68_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 71
		refs = "0037 ?Remove@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAVScheduleGroupBase@23@H_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 81 BC 00 00 00 04 48 8B D1 75 2B 83 CB FF F0 0F C1 99 B4 00 00 00 FF CB 75 1E 48 8B 89 A0 00 00 00 44 8B 82 B0 00 00 00 41 B1 01 48 83 C1 20 E8 ?? ?? ?? ?? EB 02 33 DB 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_240_71_0 {
	meta:
		name = "??0SchedulingRing@details@Concurrency@@QEAA@PEAVSchedulerBase@12@H@Z"
		size = 111
		refs = "003c ??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z 0052 ?CreateScheduleGroup@SchedulingRing@details@Concurrency@@QEAAPEAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 41 8B D8 48 8B F9 48 89 11 48 83 61 08 00 48 83 61 10 00 48 83 C1 20 41 B9 40 00 00 00 41 B8 00 01 00 00 E8 ?? ?? ?? ?? 90 83 A7 A0 00 00 00 00 89 9F A4 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 89 47 10 80 88 BC 00 00 00 04 48 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "_wstrtime_s"
		size = 319
		refs = "000d __security_cookie 003a _errno 004d __imp_GetLocalTime 0121 _invalid_parameter_noinfo 0130 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 FF 48 8B D9 48 85 C9 0F 84 ED 00 00 00 48 85 D2 0F 84 E4 00 00 00 66 89 39 48 83 FA 09 73 0D E8 ?? ?? ?? ?? 8D 5F 22 E9 D8 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 44 0F B7 5C 24 28 44 0F B7 44 24 2A 44 0F B7 4C 24 2C B8 3A 00 00 00 41 BA 67 66 66 66 66 89 43 0A 66 89 43 04 41 8B C2 66 89 7B 10 66 BF 30 00 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B D8 41 8B C2 66 44 03 DF 66 44 89 5B 02 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8B C2 8D 0C 17 66 89 4B 06 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C1 66 44 03 C7 66 44 89 43 08 41 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 43 0C 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B C8 66 44 03 CF 33 C0 66 44 89 4B 0E EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "_wstrtime"
		size = 290
		refs = "000d __security_cookie 0024 _errno 002f _invalid_parameter_noinfo 0044 __imp_GetLocalTime 0113 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 FF 48 8B D9 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 D0 00 00 00 66 89 39 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 44 0F B7 5C 24 28 44 0F B7 44 24 2A 44 0F B7 4C 24 2C B8 3A 00 00 00 41 BA 67 66 66 66 66 89 43 0A 66 89 43 04 41 8B C2 66 89 7B 10 66 BF 30 00 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 17 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B D8 41 8B C2 66 44 03 DF 66 44 89 5B 02 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8B C2 8D 0C 17 66 89 4B 06 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C1 66 44 03 C7 66 44 89 43 08 41 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 48 8B C3 8D 0C 17 66 89 4B 0C 0F B7 CA 66 C1 E2 02 66 03 CA 66 03 C9 66 44 2B C9 66 44 03 CF 66 44 89 4B 0E 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_fgetwc_nolock"
		size = 506
		refs = "0017 __pioinfo 001e __badioinfo 0029 _fileno 0088 _filbuf 0156 isleadbyte 0189 ungetc 01a9 mbtowc 01b7 _errno 01e8 _filwbuf"
	strings:
		$1 = { 48 89 5C 24 18 56 57 41 54 48 83 EC 20 F6 41 18 40 48 8B F9 4C 8D 25 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 0F 85 A9 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 35 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 28 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 48 63 D8 48 C1 FB 05 E8 ?? ?? ?? ?? 44 8B D8 41 83 E3 1F 4D 6B DB 58 4D 03 1C DC EB 03 4C 8B DE 41 F6 43 38 7F 74 60 FF 4F 08 78 0E 48 8B 07 0F B6 08 48 FF C0 48 89 07 EB 0A 48 8B CF E8 ?? ?? ?? ?? 8B C8 83 F9 FF 75 0A B8 FF FF 00 00 E9 4F 01 00 00 FF 4F 08 88 4C 24 40 78 0E 48 8B 07 0F B6 08 48 FF C0 48 89 07 EB 0A 48 8B CF E8 ?? ?? ?? ?? 8B C8 83 F9 FF 74 D0 88 4C 24 41 0F B7 44 24 40 E9 1B 01 00 00 F6 47 18 40 0F 85 EB 00 00 00 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 31 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 24 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 48 63 D8 48 C1 FB 05 E8 ?? ?? ?? ?? 8B F0 83 E6 1F 48 6B F6 58 49 03 34 DC F6 46 08 80 0F 84 A3 00 00 00 FF 4F 08 BB 01 00 00 00 78 0E 48 8B 07 0F B6 08 48 FF C0 48 89 07 EB 0A 48 8B CF E8 ?? ?? ?? ?? 8B C8 83 F9 FF 0F 84 45 FF FF FF 88 4C 24 48 0F B6 C9 E8 ?? ?? ?? ?? 85 C0 74 3D FF 4F 08 78 0E 48 8B 07 0F B6 08 48 FF C0 48 89 07 EB 0A 48 8B CF E8 ?? ?? ?? ?? 8B C8 83 F9 FF 75 12 0F BE 4C 24 48 48 8B D7 E8 ?? ?? ?? ?? E9 01 FF FF FF 88 4C 24 49 BB 02 00 00 00 48 8D 54 24 48 48 8D 4C 24 40 4C 63 C3 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 11 FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E9 CD FE FF FF 48 63 47 08 48 83 C0 FE 89 47 08 85 C0 78 0F 48 8B 0F 0F B7 01 48 83 C1 02 48 89 0F EB 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 50 48 83 C4 20 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "fgetwc"
		size = 92
		refs = "001f _errno 002a _invalid_parameter_noinfo 0036 _lock_file 003f _fgetwc_nolock 004a _unlock_file"
	strings:
		$1 = { 48 89 5C 24 10 48 89 4C 24 08 57 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 1C E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 0F B7 F8 48 8B CB E8 ?? ?? ?? ?? 0F B7 C7 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_sleep"
		size = 17
		refs = "000d __imp_Sleep"
	strings:
		$1 = { B8 01 00 00 00 85 C9 0F 44 C8 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "_strnicoll_l"
		size = 259
		refs = "0028 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 004e _errno 0059 _invalid_parameter_noinfo 009c _strnicmp_l 00c4 __crtCompareStringA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 60 48 8B F1 48 8B FA 48 8D 4D E0 49 8B D1 49 8B D8 E8 ?? ?? ?? ?? 48 85 DB 75 17 38 5D F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 33 C0 E9 A5 00 00 00 48 85 F6 75 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD B8 FF FF FF 7F EB 78 48 85 FF 74 D3 48 81 FB FF FF FF 7F 77 CA 48 8B 45 E0 8B 50 10 85 D2 75 14 4C 8D 4D E0 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? EB 3A 8B 40 08 48 8D 4D E0 4C 8B CE 89 44 24 38 89 5C 24 30 41 B8 01 10 00 00 48 89 7C 24 28 89 5C 24 20 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 84 83 C0 FE 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 60 49 8B 5B 10 49 8B 73 18 49 8B 7B 20 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_244_4_0 {
	meta:
		name = "_strnicoll"
		size = 22
		refs = "0002 __locale_changed 000a _strnicmp 0012 _strnicoll_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 05 E9 ?? ?? ?? ?? 45 33 C9 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_setmode_nolock"
		size = 206
		refs = "000b __pioinfo"
	strings:
		$1 = { 48 89 5C 24 08 4C 63 C1 48 8D 1D ?? ?? ?? ?? 4D 8B C8 41 83 E0 1F 49 C1 F9 05 4D 6B C0 58 4A 8B 0C CB 42 8A 44 01 38 46 0F B6 5C 01 08 02 C0 41 81 E3 80 00 00 00 44 0F BE D0 41 D1 FA 81 FA 00 40 00 00 74 58 81 FA 00 80 00 00 74 48 81 FA 00 00 01 00 74 28 81 FA 00 00 02 00 74 20 81 FA 00 00 04 00 75 48 42 80 4C 01 08 80 4A 8B 04 CB 42 80 64 00 38 81 42 80 4C 00 38 01 EB 30 42 80 4C 01 08 80 4A 8B 04 CB 42 80 64 00 38 82 42 80 4C 00 38 02 EB 18 42 80 64 01 08 7F EB 10 42 80 4C 01 08 80 4A 8B 0C CB 42 80 64 01 38 80 45 85 DB 75 07 B8 00 80 00 00 EB 0F 41 F7 DA 1B C0 25 00 C0 00 00 05 00 40 00 00 48 8B 5C 24 08 C3 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_set_fmode"
		size = 64
		refs = "001d _errno 0028 _invalid_parameter_noinfo 0035 _fmode"
	strings:
		$1 = { 48 83 EC 28 81 F9 00 40 00 00 74 27 81 F9 00 80 00 00 74 1F 81 F9 00 00 01 00 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 08 87 0D ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_setmode"
		size = 250
		refs = "0045 _errno 006c _nhandle 007f __pioinfo 009c __lock_fhandle 00b2 _setmode_nolock 00cb _unlock_fhandle 00df _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 89 4C 24 08 57 41 54 41 55 48 83 EC 20 8B DA 48 63 F9 81 FA 00 40 00 00 74 30 81 FA 00 80 00 00 74 28 81 FA 00 00 01 00 74 20 81 FA 00 00 04 00 74 18 81 FA 00 00 02 00 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 8A 00 00 00 83 FF FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 7D 85 C9 78 69 3B 3D ?? ?? ?? ?? 73 61 48 8B F7 4C 8B E7 49 C1 FC 05 4C 8D 2D ?? ?? ?? ?? 83 E6 1F 48 6B F6 58 4B 8B 44 E5 00 0F BE 4C 06 08 83 E1 01 74 3A 8B CF E8 ?? ?? ?? ?? 90 4B 8B 44 E5 00 F6 44 06 08 01 74 0D 8B D3 8B CF E8 ?? ?? ?? ?? 8B D8 EB 0E E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 CB FF 8B CF E8 ?? ?? ?? ?? 8B C3 EB 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "_fileno"
		size = 38
		refs = "000a _errno 0015 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 03 8B 41 1C 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_247_14_0 {
	meta:
		name = "?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ"
		size = 30
		refs = "0015 ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
	strings:
		$1 = { 48 83 EC 28 8B 41 70 83 F8 01 75 0D 48 8D 51 08 48 8B 49 28 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_247_18_0 {
	meta:
		name = "?Remove@VirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIScheduler@3@@Z"
		size = 147
		refs = "0011 ??_C@_0L@HKFDMHB@pScheduler?$AA@ 0025 ??0exception@std@@QEAA@AEBQEBD@Z 002c ??_7invalid_argument@std@@6B@ 0033 _TI3?AVinvalid_argument@std@@ 0042 _CxxThrowException 0057 ??0invalid_operation@Concurrency@@QEAA@XZ 005e _TI2?AVinvalid_operation@Concurrency@@ 007e ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 008f ?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QEAAXPEAVVirtualProcessorRoot@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B D9 48 85 D2 75 39 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 68 48 8D 4C 24 20 48 89 44 24 68 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 4C 89 5C 24 20 E8 ?? ?? ?? ?? CC 48 8B 41 28 48 39 50 10 74 1C 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC 8B 41 70 83 F8 01 75 0D 48 8D 51 08 48 8B 49 28 E8 ?? ?? ?? ?? 48 8B 4B 28 48 8B D3 48 83 C4 50 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_24_0 {
	meta:
		name = "??0VirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 79
		refs = "000d ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 001c ??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z 0034 ?s_currentId@VirtualProcessorRoot@details@Concurrency@@0JA"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 48 83 C1 08 E8 ?? ?? ?? ?? 45 33 DB 66 44 89 5F 68 41 8D 43 01 44 89 5F 70 F0 0F C1 05 ?? ?? ?? ?? 48 8B 5C 24 30 FF C0 89 47 6C 48 89 7F 38 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "__shr_12"
		size = 43
	strings:
		$1 = { 8B 41 08 8B 51 04 44 8B C0 D1 E8 44 8B CA 89 41 08 8B 01 41 C1 E0 1F 41 C1 E1 1F D1 EA D1 E8 41 0B C1 41 0B D0 89 01 89 51 04 C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "__ld12mul"
		size = 823
		refs = "0022 __security_cookie 0316 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 0F B7 42 0A 45 33 F6 4C 8B C1 48 89 4D D8 0F B7 49 0A 0F B7 F0 66 33 F1 4C 8B E2 BA 00 80 00 00 66 23 F2 BA FF 7F 00 00 44 89 75 D4 66 23 CA 66 23 C2 4C 89 75 E0 44 8D 0C 01 44 89 75 E8 66 89 75 D2 66 44 89 4D D0 66 3B CA 0F 83 79 02 00 00 66 3B C2 0F 83 70 02 00 00 BA FD BF 00 00 66 44 3B CA 0F 87 61 02 00 00 BA BF 3F 00 00 66 44 3B CA 77 0C 4D 89 70 04 45 89 30 E9 62 02 00 00 BA FF FF FF 7F 41 BD 01 00 00 00 66 85 C9 75 24 66 45 03 CD 66 44 89 4D D0 41 85 50 08 75 15 45 39 70 04 75 0F 45 39 30 75 0A 66 45 89 70 0A E9 2E 02 00 00 66 85 C0 75 1D 66 45 03 CD 66 44 89 4D D0 41 85 54 24 08 75 0D 45 39 74 24 04 75 06 45 39 34 24 74 9E 41 8B DE 48 8D 4D E4 BA 05 00 00 00 4D 8B CD 8D 04 1B 44 8B EA 4C 63 D0 85 D2 7E 57 8B F3 4F 8D 3C 02 4D 8D 74 24 08 41 23 F1 45 33 C0 41 0F B7 06 45 0F B7 17 41 8B F8 44 0F AF D0 8B 41 FC 46 8D 1C 10 44 3B D8 72 05 45 3B DA 73 03 41 8B F9 44 89 59 FC 85 FF 74 04 66 44 01 09 45 2B E9 49 83 C7 02 49 83 EE 02 45 85 ED 7F C1 4C 8B 45 D8 45 33 F6 41 2B D1 48 83 C1 02 41 03 D9 85 D2 7F 8E 44 0F B7 4D D0 44 8B 55 E8 44 8B 5D E0 B8 02 C0 00 00 BB 00 00 00 80 41 BC FF FF 00 00 66 44 03 C8 66 45 85 C9 7E 3C 44 85 D3 75 31 8B 7D E4 41 8B D3 45 03 D2 C1 EA 1F 45 03 DB 8B CF C1 E9 1F 8D 04 3F 66 45 03 CC 0B C2 44 0B D1 44 89 5D E0 89 45 E4 44 89 55 E8 66 45 85 C9 7F CA 66 45 85 C9 7F 6D 66 45 03 CC 41 BD 01 00 00 00 79 67 44 8B 45 D4 41 0F B7 C1 66 F7 D8 0F B7 D0 66 44 03 CA 44 84 6D E0 74 03 45 03 C5 8B 7D E4 41 8B C2 41 D1 EB 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 EA 44 0B D9 49 2B D5 89 7D E4 44 89 5D E0 75 D0 45 85 C0 4C 8B 45 D8 44 89 55 E8 74 18 41 0F B7 C3 66 41 0B C5 66 89 45 E0 44 8B 5D E0 EB 0A 41 BD 01 00 00 00 0F B7 45 E0 0F B7 75 D2 BA 00 80 00 00 66 3B C2 77 10 41 81 E3 FF FF 01 00 41 81 FB 00 80 01 00 75 49 8B 45 E2 83 C9 FF 3B C1 75 39 8B 45 E6 44 89 75 E2 3B C1 75 22 0F B7 45 EA 44 89 75 E6 66 41 3B C4 75 0A 66 89 55 EA 66 45 03 CD EB 10 66 41 03 C5 66 89 45 EA EB 06 41 03 C5 89 45 E6 44 8B 55 E8 EB 06 41 03 C5 89 45 E2 B8 FF 7F 00 00 66 44 3B C8 72 09 49 C7 00 00 00 00 00 EB 26 0F B7 45 E2 66 44 0B CE 45 89 50 06 66 41 89 00 8B 45 E4 66 45 89 48 0A 41 89 40 02 EB 18 BB 00 00 00 80 4D 89 30 66 F7 DE 1B C0 23 C3 05 00 80 FF 7F 41 89 40 08 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "__multtenpow12"
		size = 926
		refs = "002a __security_cookie 0038 _pow10pos 0053 _pow10neg 037c __security_check_cookie"
	strings:
		$1 = { 85 D2 0F 84 95 03 00 00 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 4C 8D 2D ?? ?? ?? ?? 33 FF 44 8B DA 49 83 ED 60 4C 8B C9 48 89 4D C8 85 D2 79 0E 4C 8D 2D ?? ?? ?? ?? 41 F7 DB 49 83 ED 60 45 85 C0 75 03 66 89 39 45 85 DB 0F 84 05 03 00 00 BB FF 7F 00 00 BE 01 00 00 00 44 8D 63 01 41 8B C3 41 C1 FB 03 49 83 C5 54 83 E0 07 44 89 5D C0 0F 84 D6 02 00 00 48 98 48 8D 0C 40 49 8D 54 8D 00 66 44 39 22 72 1A 48 8B 0A 8B 42 08 48 8D 55 E0 48 89 4D E0 48 C1 E9 10 89 45 E8 2B CE 89 4D E2 0F B7 4A 0A 41 0F B7 41 0A 89 7D B8 44 0F B7 D1 66 23 CB 48 C7 45 D0 00 00 00 00 66 44 33 D0 66 23 C3 89 7D D8 66 45 23 D4 44 8D 04 08 66 44 89 55 B0 66 3B C3 0F 83 55 02 00 00 66 3B CB 0F 83 4C 02 00 00 BB FD BF 00 00 66 44 3B C3 0F 87 38 02 00 00 41 BA BF 3F 00 00 66 45 3B C2 77 15 49 C7 41 04 00 00 00 00 41 89 39 BB FF 7F 00 00 E9 37 02 00 00 66 85 C0 75 20 66 44 03 C6 41 F7 41 08 FF FF FF 7F 75 12 41 39 79 04 75 0C 41 39 39 75 07 66 41 89 79 0A EB D1 66 85 C9 75 16 66 44 03 C6 F7 42 08 FF FF FF 7F 75 09 39 7A 04 75 04 39 3A 74 AB 45 33 DB 4C 8D 55 D4 41 8D 7B 05 45 8B E3 43 8D 04 24 89 7D B4 48 63 C8 85 FF 7E 5B 41 8B C4 4E 8D 3C 09 4C 8D 72 08 23 C6 44 8B C8 41 0F B7 07 41 0F B7 0E 41 8B F3 0F AF C8 41 8B 42 FC 8D 1C 08 3B D8 72 04 3B D9 73 05 BE 01 00 00 00 85 F6 41 89 5A FC BE 01 00 00 00 74 04 66 41 01 32 8B 5D B4 49 83 C7 02 49 83 EE 02 2B DE 89 5D B4 85 DB 7F B9 4C 8B 4D C8 2B FE 49 83 C2 02 44 03 E6 85 FF 7F 8A 44 8B 55 D8 8B 5D D0 B8 02 C0 00 00 66 44 03 C0 41 BE FF FF 00 00 66 45 85 C0 7E 39 45 85 D2 78 2E 8B 7D D4 8B D3 45 03 D2 C1 EA 1F 03 DB 8B CF C1 E9 1F 8D 04 3F 66 45 03 C6 0B C2 44 0B D1 89 5D D0 89 45 D4 44 89 55 D8 66 45 85 C0 7F CD 66 45 85 C0 7F 61 66 45 03 C6 79 5B 44 8B 4D B8 41 0F B7 C0 66 F7 D8 0F B7 D0 66 44 03 C2 40 84 75 D0 74 03 44 03 CE 8B 7D D4 41 8B C2 D1 EB 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 EA 0B D9 48 2B D6 89 7D D4 89 5D D0 75 D3 45 85 C9 4C 8B 4D C8 44 89 55 D8 74 0F 0F B7 C3 66 0B C6 66 89 45 D0 8B 5D D0 EB 04 0F B7 45 D0 44 8B 5D C0 41 BC 00 80 00 00 66 41 3B C4 77 0E 81 E3 FF FF 01 00 81 FB 00 80 01 00 75 46 8B 45 D2 83 F8 FF 75 39 8B 45 D6 33 FF 89 7D D2 83 F8 FF 75 21 0F B7 45 DA 89 7D D6 66 41 3B C6 75 0B 66 44 89 65 DA 66 44 03 C6 EB 0E 66 03 C6 66 89 45 DA EB 05 03 C6 89 45 D6 44 8B 55 D8 EB 07 03 C6 89 45 D2 33 FF BB FF 7F 00 00 66 44 3B C3 72 09 0F B7 45 B0 66 F7 D8 EB 28 0F B7 45 D2 66 44 0B 45 B0 45 89 51 06 66 41 89 01 8B 45 D4 66 45 89 41 0A 41 89 41 02 EB 20 BB FF 7F 00 00 66 41 F7 DA 1B C0 49 C7 01 00 00 00 00 25 00 00 00 80 05 00 80 FF 7F 41 89 41 08 45 85 DB 0F 85 09 FD FF FF 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 50 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "__strgtold12_l"
		size = 2146
		refs = "001f __security_cookie 0064 _errno 006f _invalid_parameter_noinfo 0445 __mtold12 047e _pow10pos 0493 _pow10neg 0843 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC A0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 FF 4C 8B 6D 7F 33 DB 44 89 4D 8F 44 8D 4B 01 48 89 4D A7 48 89 55 97 4C 8D 55 DF 66 89 5D 93 8B FB 44 89 4D 8B 44 8B F3 89 5D 87 44 8B FB 8B F3 44 8B E3 8B CB 4D 85 ED 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 C1 07 00 00 4D 8B D8 41 8A 00 3C 20 74 0C 3C 09 74 08 3C 0A 74 04 3C 0D 75 05 4D 03 C1 EB E8 41 8A 10 4D 03 C1 83 F9 05 0F 8F 1A 02 00 00 0F 84 FA 01 00 00 44 8B C9 85 C9 0F 84 8E 01 00 00 41 FF C9 0F 84 3D 01 00 00 41 FF C9 0F 84 E1 00 00 00 41 FF C9 0F 84 8B 00 00 00 41 FF C9 0F 85 AA 02 00 00 41 B9 01 00 00 00 45 8B F1 44 89 4D 87 85 FF 75 31 EB 09 41 8A 10 45 2B E1 4D 03 C1 80 FA 30 74 F2 EB 1F 80 FA 39 7F 1F 83 FF 19 73 0F 80 EA 30 41 03 F9 41 88 12 4D 03 D1 45 2B E1 41 8A 10 4D 03 C1 80 FA 30 7D DC 80 FA 2B 74 29 80 FA 2D 74 24 80 FA 43 0F 8E 4A 01 00 00 80 FA 45 7E 0C 80 EA 64 41 3A D1 0F 87 39 01 00 00 B9 06 00 00 00 E9 47 FF FF FF 4D 2B C1 B9 0B 00 00 00 E9 3A FF FF FF 41 B9 01 00 00 00 B0 30 45 8B F1 EB 20 80 FA 39 7F 1F 83 FF 19 73 0D 2A D0 41 03 F9 41 88 12 4D 03 D1 EB 03 45 03 E1 41 8A 10 4D 03 C1 3A D0 7D DC 49 8B 45 00 48 8B 88 28 01 00 00 48 8B 01 3A 10 75 82 B9 04 00 00 00 E9 ED FE FF FF 8D 42 CF 3C 08 77 13 B9 03 00 00 00 41 B9 01 00 00 00 4D 2B C1 E9 D3 FE FF FF 49 8B 45 00 48 8B 88 28 01 00 00 48 8B 01 3A 10 75 10 B9 05 00 00 00 41 B9 01 00 00 00 E9 B1 FE FF FF 80 FA 30 0F 85 F7 01 00 00 41 B9 01 00 00 00 41 8B C9 E9 9A FE FF FF 8D 42 CF 41 B9 01 00 00 00 45 8B F1 3C 08 77 06 41 8D 49 02 EB A9 49 8B 45 00 48 8B 88 28 01 00 00 48 8B 01 3A 10 0F 84 77 FF FF FF 80 FA 2B 0F 84 1E FF FF FF 80 FA 2D 0F 84 15 FF FF FF 80 FA 30 74 B5 E9 E7 FE FF FF 8D 42 CF 3C 08 0F 86 61 FF FF FF 49 8B 45 00 48 8B 88 28 01 00 00 48 8B 01 3A 10 0F 84 70 FF FF FF 80 FA 2B 74 2D 80 FA 2D 74 17 80 FA 30 0F 84 76 FF FF FF 41 B9 01 00 00 00 4D 2B C1 E9 68 01 00 00 B9 02 00 00 00 C7 45 93 00 80 00 00 E9 43 FF FF FF B9 02 00 00 00 66 89 5D 93 E9 35 FF FF FF 80 EA 30 44 89 4D 87 80 FA 09 0F 87 D9 00 00 00 B9 04 00 00 00 E9 FC FE FF FF 44 8B C9 41 83 E9 06 0F 84 9C 00 00 00 41 FF C9 74 73 41 FF C9 74 42 41 FF C9 0F 84 B4 00 00 00 41 83 F9 02 0F 85 9B 00 00 00 39 5D 77 74 8A 4D 8D 58 FF 80 FA 2B 74 17 80 FA 2D 0F 85 E5 00 00 00 83 4D 8B FF B9 07 00 00 00 E9 CC FE FF FF B9 07 00 00 00 E9 C2 FE FF FF 41 B9 01 00 00 00 45 8B F9 EB 06 41 8A 10 4D 03 C1 80 FA 30 74 F5 80 EA 31 80 FA 08 0F 87 44 FF FF FF B9 09 00 00 00 E9 77 FE FF FF 8D 42 CF 3C 08 77 0A B9 09 00 00 00 E9 60 FE FF FF 80 FA 30 0F 85 87 00 00 00 B9 08 00 00 00 E9 72 FE FF FF 8D 42 CF 4D 8D 58 FE 3C 08 76 D8 80 FA 2B 74 07 80 FA 2D 74 83 EB D6 B9 07 00 00 00 83 F9 0A 74 5F E9 4C FE FF FF 4D 8B C3 EB 5B 41 B9 01 00 00 00 41 B3 30 45 8B F9 EB 1D 80 FA 39 7F 35 8D 0C B6 0F BE C2 8D 74 48 D0 81 FE 50 14 00 00 7F 0D 41 8A 10 4D 03 C1 41 3A D3 7D DE EB 16 BE 51 14 00 00 EB 0F 80 FA 39 0F 8F A9 FE FF FF 41 8A 10 4D 03 C1 41 3A D3 7D EC E9 99 FE FF FF 4D 8B C3 41 B9 01 00 00 00 48 8B 45 97 4C 89 00 45 85 F6 0F 84 14 04 00 00 83 FF 18 76 18 8A 45 F6 3C 05 7C 06 41 02 C1 88 45 F6 4D 2B D1 BF 18 00 00 00 45 03 E1 85 FF 75 14 0F B7 D3 0F B7 C3 8B FB 8B CB E9 F3 03 00 00 FF CF 45 03 E1 4D 2B D1 41 38 1A 74 F3 4C 8D 45 BF 48 8D 4D DF 8B D7 E8 ?? ?? ?? ?? 39 5D 8B 7D 02 F7 DE 41 03 F4 45 85 FF 75 03 03 75 67 39 5D 87 75 03 2B 75 6F 81 FE 50 14 00 00 0F 8F 8C 03 00 00 81 FE B0 EB FF FF 0F 8C 70 03 00 00 4C 8D 2D ?? ?? ?? ?? 49 83 ED 60 85 F6 0F 84 4B 03 00 00 79 0D 4C 8D 2D ?? ?? ?? ?? F7 DE 49 83 ED 60 39 5D 8F 75 04 66 89 5D BF 85 F6 0F 84 2B 03 00 00 BF 00 00 00 80 41 BA FF 7F 00 00 41 BC 01 00 00 00 8B C6 49 83 C5 54 C1 FE 03 83 E0 07 89 75 8F 4C 89 6D 9F 0F 84 F9 02 00 00 48 98 41 BF 00 80 00 00 48 8D 0C 40 49 8D 54 8D 00 66 44 39 3A 72 1B 48 8B 0A 8B 42 08 48 8D 55 CF 48 89 4D CF 48 C1 E9 10 89 45 D7 41 2B CC 89 4D D1 0F B7 42 0A 0F B7 4D C9 48 89 5D AF 44 0F B7 C8 66 41 23 C2 89 5D B7 66 44 33 C9 66 41 23 CA 66 45 23 CF 44 8D 04 01 66 44 89 4D 8B 66 41 3B CA 0F 83 7D 02 00 00 66 41 3B C2 0F 83 73 02 00 00 41 BB FD BF 00 00 66 45 3B C3 0F 87 63 02 00 00 41 B9 BF 3F 00 00 66 45 3B C1 77 0C 48 89 5D C3 89 5D BF E9 5F 02 00 00 66 85 C9 75 20 66 45 03 C4 F7 45 C7 FF FF FF 7F 75 13 39 5D C3 75 0E 39 5D BF 75 09 66 89 5D C9 E9 3A 02 00 00 66 85 C0 75 16 66 45 03 C4 F7 42 08 FF FF FF 7F 75 09 39 5A 04 75 04 39 1A 74 B4 41 BA 05 00 00 00 44 8B E3 48 8D 4D B3 45 8D 6A FC 43 8D 04 24 44 89 55 87 4C 63 C8 45 85 D2 7E 55 41 8B FC 4E 8D 74 0D BF 4C 8D 7A 08 41 23 FD 41 0F B7 06 45 0F B7 0F 44 8B DB 44 0F AF C8 8B 41 FC 42 8D 34 08 3B F0 72 05 41 3B F1 73 03 45 8B DD 89 71 FC 45 85 DB 74 04 66 44 01 29 44 8B 5D 87 49 83 C6 02 49 83 EF 02 45 2B DD 44 89 5D 87 45 85 DB 7F BA 45 2B D5 48 83 C1 02 45 03 E5 45 85 D2 7F 8C 44 8B 55 B7 44 8B 4D AF B8 02 C0 00 00 66 44 03 C0 BF 00 00 00 80 41 BE FF FF 00 00 66 45 85 C0 7E 3F 44 85 D7 75 34 44 8B 5D B3 41 8B D1 45 03 D2 C1 EA 1F 45 03 C9 41 8B CB C1 E9 1F 43 8D 04 1B 66 45 03 C6 0B C2 44 0B D1 44 89 4D AF 89 45 B3 44 89 55 B7 66 45 85 C0 7F C7 66 45 85 C0 7F 6A 66 45 03 C6 79 64 41 0F B7 C0 8B FB 66 F7 D8 0F B7 D0 66 44 03 C2 44 84 6D AF 74 03 41 03 FD 44 8B 5D B3 41 8B C2 41 D1 E9 41 8B CB C1 E0 1F 41 D1 EB C1 E1 1F 44 0B D8 41 D1 EA 44 0B C9 49 2B D5 44 89 5D B3 44 89 4D AF 75 CB 85 FF 44 89 55 B7 BF 00 00 00 80 74 12 41 0F B7 C1 66 41 0B C5 66 89 45 AF 44 8B 4D AF EB 04 0F B7 45 AF 4C 8B 6D 9F 41 BF 00 80 00 00 66 41 3B C7 77 10 41 81 E1 FF FF 01 00 41 81 F9 00 80 01 00 75 50 8B 45 B1 83 C9 FF 41 BC 01 00 00 00 3B C1 75 38 8B 45 B5 89 5D B1 3B C1 75 22 0F B7 45 B9 89 5D B5 66 41 3B C6 75 0B 66 44 89 7D B9 66 45 03 C4 EB 10 66 41 03 C4 66 89 45 B9 EB 06 41 03 C4 89 45 B5 44 8B 55 B7 EB 0E 41 03 C4 89 45 B1 EB 06 41 BC 01 00 00 00 8B 75 8F B8 FF 7F 00 00 66 44 3B C0 72 0F 0F B7 45 8B 41 BA FF 7F 00 00 66 F7 D8 EB 28 0F B7 45 B1 66 44 0B 45 8B 44 89 55 C5 66 89 45 BF 8B 45 B3 66 44 89 45 C9 89 45 C1 41 BA FF 7F 00 00 EB 14 66 41 F7 D9 1B C0 48 89 5D BF 23 C7 05 00 80 FF 7F 89 45 C7 85 F6 0F 85 E6 FC FF FF 8B 45 C7 0F B7 55 BF 8B 4D C1 8B 7D C5 C1 E8 10 EB 35 8B D3 0F B7 C3 8B FB 8B CB BB 01 00 00 00 EB 25 8B CB 0F B7 D3 B8 FF 7F 00 00 BB 02 00 00 00 BF 00 00 00 80 EB 0F 0F B7 D3 0F B7 C3 8B FB 8B CB BB 04 00 00 00 4C 8B 45 A7 66 0B 45 93 66 41 89 40 0A 8B C3 66 41 89 10 41 89 48 02 41 89 78 06 48 8B 4D FF 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 F0 00 00 00 48 81 C4 A0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_248_6_0 {
	meta:
		name = "__STRINGTOLD_L"
		size = 117
		refs = "000d __security_cookie 003d __strgtold12_l 004c _ld12told 0063 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 83 EC 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 50 48 8B 84 24 90 00 00 00 48 8B D9 48 8D 4C 24 40 48 89 44 24 38 33 C0 89 44 24 30 89 44 24 28 89 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B D3 8B F8 E8 ?? ?? ?? ?? 83 F8 01 75 03 83 CF 02 8B C7 48 8B 4C 24 50 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 88 00 00 00 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_600_6_0 {
	meta:
		name = "__WSTRINGTOLD_L"
		size = 117
		refs = "000d __security_cookie 003d __wstrgtold12_l 004c _ld12told 0063 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 83 EC 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 50 48 8B 84 24 90 00 00 00 48 8B D9 48 8D 4C 24 40 48 89 44 24 38 33 C0 89 44 24 30 89 44 24 28 89 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B D3 8B F8 E8 ?? ?? ?? ?? 83 F8 01 75 03 83 CF 02 8B C7 48 8B 4C 24 50 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 88 00 00 00 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "bsearch"
		size = 240
		refs = "0042 _errno 004d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 55 41 57 48 83 EC 20 49 8D 78 FF 45 33 E4 4D 8B E9 49 8B F0 48 8B DA 4C 8B F9 49 0F AF F9 48 03 FA 48 85 D2 75 36 4D 85 C0 74 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5D 41 5C C3 4D 85 C9 74 CA 4C 39 64 24 60 74 C3 48 3B D7 77 CE 48 8B EE 48 D1 ED 74 41 40 F6 C6 01 48 8D 75 FF 49 8B CF 48 0F 45 F5 4C 8B E6 4D 0F AF E5 4C 03 E3 49 8B D4 FF 54 24 60 85 C0 74 18 79 08 49 8B FC 49 2B FD EB 07 4B 8D 1C 2C 48 8B F5 48 3B DF 76 BE EB 8A 49 8B C4 EB 87 45 33 E4 48 85 F6 0F 84 79 FF FF FF 48 8B D3 49 8B CF FF 54 24 60 85 C0 49 0F 45 DC 48 8B C3 E9 63 FF FF FF }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "_wexeclp"
		size = 167
		refs = "0024 _errno 002f _invalid_parameter_noinfo 0066 _wcapture_argv 007b _wexecvp 0095 free"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 30 02 00 00 33 F6 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 63 66 39 31 74 E5 48 85 D2 74 E0 66 39 32 74 DB 48 8D 84 24 60 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8B CB 48 8B F8 48 89 74 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 81 C4 30 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZP6AXXZ@Z"
		size = 51
		refs = "000e _getptd"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 48 8B 98 D0 00 00 00 E8 ?? ?? ?? ?? 48 89 B8 D0 00 00 00 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_251_1_0 {
	meta:
		name = "_get_terminate"
		size = 21
		refs = "0005 _getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 80 D0 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_251_2_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZP6AXXZ@Z"
		size = 51
		refs = "000e _getptd"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 48 8B 98 D8 00 00 00 E8 ?? ?? ?? ?? 48 89 B8 D8 00 00 00 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_251_3_0 {
	meta:
		name = "_get_unexpected"
		size = 21
		refs = "0005 _getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 80 D8 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_251_4_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPEAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
		size = 51
		refs = "000e _getptd"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 48 8B 98 E0 00 00 00 E8 ?? ?? ?? ?? 48 89 B8 E0 00 00 00 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_d_inttype"
		size = 90
		refs = "000e _fpclass 001b _frnd 002b __real@3fe0000000000000"
	strings:
		$1 = { 48 83 EC 38 0F 29 74 24 20 66 0F 28 F0 E8 ?? ?? ?? ?? A8 90 75 38 66 0F 28 C6 E8 ?? ?? ?? ?? 66 0F 2E C6 7A 29 75 27 F2 0F 59 35 ?? ?? ?? ?? 66 0F 28 C6 E8 ?? ?? ?? ?? 66 0F 2E C6 7A 09 75 07 B8 02 00 00 00 EB 09 B8 01 00 00 00 EB 02 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "_powhlp"
		size = 316
		refs = "001a __mask@@AbsDouble@ 0049 __real@3ff0000000000000 0057 _d_inf 00af _d_ind 00f7 _d_inttype 0116 __mask@@NegDouble@ 012f _d_mzero"
	strings:
		$1 = { 48 8B C4 48 89 58 18 F2 0F 11 48 10 F2 0F 11 40 08 57 48 83 EC 30 66 0F 54 05 ?? ?? ?? ?? 0F 29 70 E8 48 8B 40 10 48 8B C8 49 8B D8 41 B8 00 00 F0 7F 48 C1 E9 20 33 FF 66 0F 28 F1 41 3B C8 75 44 85 C0 75 40 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C1 76 0D F2 0F 10 05 ?? ?? ?? ?? E9 D3 00 00 00 66 0F 2F C8 77 3A 48 B8 00 00 00 00 00 00 F0 3F 48 89 03 48 8B 5C 24 50 0F 28 74 24 20 8B C7 48 83 C4 30 5F C3 BA 00 00 F0 FF 3B CA 75 30 85 C0 75 2C F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C1 76 05 48 89 3B EB CE 66 0F 2F C8 77 A8 F2 0F 10 05 ?? ?? ?? ?? BF 01 00 00 00 F2 0F 11 03 EB B5 48 8B 4C 24 40 48 8B C1 48 C1 E8 20 41 3B C0 75 1B 85 C9 75 17 66 0F 57 C0 66 0F 2F C8 0F 87 72 FF FF FF 66 0F 2F C1 E9 7A FF FF FF 3B C2 75 85 85 C9 75 81 66 0F 28 C1 E8 ?? ?? ?? ?? 66 0F 57 C0 66 0F 2F F0 76 17 F2 0F 10 05 ?? ?? ?? ?? 83 F8 01 75 21 66 0F 57 05 ?? ?? ?? ?? EB 17 66 0F 2F C6 0F 86 40 FF FF FF 83 F8 01 75 08 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 E9 37 FF FF FF }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ"
		size = 58
		refs = "001c ?__ExceptionPtrCreate@@YAXPEAX@Z 002c ?__ExceptionPtrCurrentException@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 83 64 24 48 00 E8 ?? ?? ?? ?? C7 44 24 48 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 CC }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "?dtor$0@?0??_Current_exception@_Exception_ptr@std@@SA?AV12@XZ@4HA"
		size = 38
		refs = "001c ??1_Exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 48 83 E0 01 85 C0 74 0D 83 65 48 FE 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_253_6_0 {
	meta:
		name = "?current_exception@std@@YA?AV_Exception_ptr@1@XZ"
		size = 28
		refs = "000f ?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 83 64 24 30 00 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "?rethrow_exception@std@@YAXV_Exception_ptr@1@@Z"
		size = 41
		refs = "0017 ?__ExceptionPtrRethrow@@YAXPEBX@Z 0025 ?__ExceptionPtrDestroy@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 E8 ?? ?? ?? ?? 90 48 8B CB 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_253_13_0 {
	meta:
		name = "?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IEAAPEAV123@XZ"
		size = 21
	strings:
		$1 = { 8B 41 08 BA FF FF FF 0F 23 C2 3B C2 74 04 48 8B 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_253_16_0 {
	meta:
		name = "?_RaisedException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 139
		refs = "003d ??2@YAPEAX_K@Z 0052 ?current_exception@std@@YA?AV_Exception_ptr@1@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8B 41 20 48 8B D0 48 83 E2 FC 74 06 48 83 FA 0C 75 60 48 8B C8 83 E1 03 48 83 C9 08 F0 48 0F B1 4B 20 75 DF B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 45 33 C0 48 85 C0 74 0B 48 8B C8 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 43 20 48 8B C8 83 E1 03 49 0B C8 F0 48 0F B1 4B 20 74 17 48 8B D0 48 8B C8 83 E1 03 49 0B C8 F0 48 0F B1 4B 20 48 3B C2 75 E9 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_253_19_0 {
	meta:
		name = "?_MarkCancellation@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
		size = 31
	strings:
		$1 = { 48 8B 41 20 EB 0F 48 8B D0 48 83 CA 01 F0 48 0F B1 51 20 74 07 A8 03 74 ED 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_253_20_0 {
	meta:
		name = "?_FinishCancelState@_TaskCollectionBase@details@Concurrency@@IEAAX_K@Z"
		size = 54
	strings:
		$1 = { 48 8B 41 20 4C 8B D2 4C 8B C9 4C 8B C0 49 83 E0 FC 4C 0B C2 F0 4C 0F B1 41 20 74 18 48 8B C8 48 8B D0 48 83 E1 FC 49 0B CA F0 49 0F B1 49 20 48 3B C2 75 E8 F3 C3 }
	condition:
		$1
}

rule file_253_21_0 {
	meta:
		name = "?_RaisedCancel@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 34
	strings:
		$1 = { 48 8B 41 20 EB 12 48 8B D0 83 E2 03 48 83 CA 0C F0 48 0F B1 51 20 74 08 48 A9 FC FF FF FF 74 E6 F3 C3 }
	condition:
		$1
}

rule file_253_22_0 {
	meta:
		name = "?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
		size = 99
		refs = "003c ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QEBA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 41 08 BF FF FF FF 0F 23 C7 3B C7 74 05 48 8B 19 EB 02 33 DB 48 85 DB 74 32 8B 43 08 C1 F8 1C 24 01 74 06 F6 43 20 03 75 1E 84 C0 75 0C 48 8B CB E8 ?? ?? ?? ?? 84 C0 75 0E 8B 43 08 23 C7 3B C7 74 D0 48 8B 1B EB CD B0 01 EB 02 32 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_253_23_0 {
	meta:
		name = "?_Interrupt@_TaskCollectionBase@details@Concurrency@@IEAAX_NH@Z"
		size = 115
		refs = "0019 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0032 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ 004d ??0task_canceled@details@Concurrency@@QEAA@XZ 0054 _TI2?AVtask_canceled@details@Concurrency@@ 005e _CxxThrowException"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 41 8B D8 40 8A F2 48 8B F9 E8 ?? ?? ?? ?? 44 8B 88 A0 00 00 00 45 85 C9 7F 11 40 84 F6 75 0C 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 29 85 DB 74 09 C1 E3 1C 0B 5F 08 89 5F 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_253_27_0 {
	meta:
		name = "?_RethrowException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 151
		refs = "0030 ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z 0039 ?__ExceptionPtrDestroy@@YAXPEAX@Z 0041 ??3@YAXPEAX@Z 004b ?__uncaught_exception@@YA_NXZ 0072 ?__ExceptionPtrRethrow@@YAXPEBX@Z"
	strings:
		$1 = { 40 57 48 83 EC 50 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 68 48 8B F9 48 8B 59 20 48 83 E3 FC 74 6B 48 83 FB 0C 74 65 48 8B D3 48 8D 4C 24 38 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 67 20 00 E8 ?? ?? ?? ?? 84 C0 75 2F 48 8D 54 24 38 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8D 5C 24 28 4C 89 5C 24 60 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_253_28_0 {
	meta:
		name = "?dtor$0@?0??_RethrowException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ@4HA"
		size = 16
		refs = "0008 ??1_Exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_42_246_1 {
	meta:
		name = "?dtor$0@?0??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 16
		refs = "0008 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_42_288_1 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z@4HA"
		size = 16
		refs = "0008 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_878_1 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z@4HA"
		size = 16
		refs = "0008 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_836_1 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z@4HA"
		size = 16
		refs = "0008 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_42_252_1 {
	meta:
		name = "?dtor$1@?0???$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0_KPEBD@Z@4HA"
		size = 16
		refs = "0008 ??1?$_String_val@DV?$allocator@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_758_1 {
	meta:
		name = "?dtor$1@?0???$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0_KPEBD@Z@4HA"
		size = 16
		refs = "0008 ??1?$_String_val@DV?$allocator@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_752_1 {
	meta:
		name = "?dtor$1@?0???$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0_KPEBD@Z@4HA"
		size = 16
		refs = "0008 ??1?$_String_val@DV?$allocator@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_755_1 {
	meta:
		name = "?dtor$1@?0???$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0_KPEBG@Z@4HA"
		size = 16
		refs = "0008 ??1?$_String_val@DV?$allocator@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_65_749_1 {
	meta:
		name = "?dtor$1@?0???$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0_KPEB_W@Z@4HA"
		size = 16
		refs = "0008 ??1?$_String_val@DV?$allocator@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_883_119_0 {
	meta:
		name = "?dtor$3@?0??_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ@4HA"
		size = 16
		refs = "0008 ??1bad_alloc@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 8A 38 00 00 00 E9 ?? ?? ?? ?? CC CC CC CC }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "??_L@YAXPEAX_KHP6AX0@Z2@Z"
		size = 100
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 70 20 48 89 50 10 48 89 48 08 57 41 54 41 55 48 83 EC 30 4D 8B E9 45 8B E0 48 8B F2 48 8B F9 33 DB 89 58 D8 89 5C 24 24 41 3B DC 7D 12 48 8B CF 41 FF D5 48 03 FE 48 89 7C 24 50 FF C3 EB E5 C7 44 24 20 01 00 00 00 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 30 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "?fin$0@?0???_L@YAXPEAX_KHP6AX0@Z2@Z@4HA"
		size = 44
		refs = "0020 ?__ArrayUnwind@@YAXPEAX_KHP6AX0@Z@Z"
		altNames = "?fin$0@?0???_N@YAXPEAX_KHP6AX0@Z2@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 83 7D 20 00 75 16 4C 8B 4D 70 44 8B 45 24 48 8B 55 58 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_256_4_0 {
	meta:
		name = "?_Nomemory@std@@YAXXZ"
		size = 127
		refs = "0008 ?$S1@?1??_Nomemory@std@@YAXXZ@4IA 0015 ??_7bad_alloc@std@@6B@ 0029 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0036 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0040 ??0exception@std@@QEAA@AEBQEBDH@Z 0047 ??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ 0053 atexit 0064 ??0exception@std@@QEAA@AEBV01@@Z 006b _TI2?AVbad_alloc@std@@ 007a _CxxThrowException"
	strings:
		$1 = { 40 53 48 83 EC 40 8B 05 ?? ?? ?? ?? 41 B8 01 00 00 00 48 8D 1D ?? ?? ?? ?? 41 84 C0 75 39 41 0B C0 48 8D 54 24 50 48 8D 0D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 50 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 5C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_256_5_0 {
	meta:
		name = "??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ"
		size = 26
		refs = "0003 ??_7bad_alloc@std@@6B@ 000a ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0016 ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_574_5_0 {
	meta:
		name = "??__Fnomem@?5???2@YAPEAX_K@Z@YAXXZ"
		size = 26
		refs = "0003 ??_7bad_alloc@std@@6B@ 000a ?nomem@?5???2@YAPEAX_K@Z@4Vbad_alloc@std@@B 0016 ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_312_1 {
	meta:
		name = "??__Fnomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z@YAXXZ"
		size = 26
		refs = "0003 ??_7bad_alloc@std@@6B@ 000a ?nomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV234@PEAVfacet@34@_K@Z@4Vbad_alloc@4@B 0016 ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_311_1 {
	meta:
		name = "??__Fnomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z@YAXXZ"
		size = 26
		refs = "0003 ??_7bad_alloc@std@@6B@ 000a ?nomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPEAV234@AEBV234@@Z@4Vbad_alloc@4@B 0016 ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_wincmdln"
		size = 121
		refs = "000e __mbctype_initialized 0015 __initmbctable 001c _acmdln 0023 ??_C@_00CNPNBAHC@?$AA@ 004e _ismbblead"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 DB 48 0F 44 D8 80 3B 20 77 09 80 3B 00 74 33 85 FF 74 29 80 3B 22 75 09 33 C0 85 FF 0F 94 C0 8B F8 0F B6 0B E8 ?? ?? ?? ?? 85 C0 74 03 48 FF C3 48 FF C3 EB D0 3C 20 77 09 48 FF C3 8A 03 84 C0 75 F3 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "fix_grouping"
		size = 58
	strings:
		$1 = { 45 33 C9 48 8B D1 44 38 09 74 16 8A 02 3C 30 7C 12 3C 39 7F 0E 2C 30 88 02 48 FF C2 44 38 0A 75 EA F3 C3 3C 3B 75 F2 4C 8B C2 41 8A 40 01 41 88 00 49 FF C0 84 C0 75 F2 EB E2 }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "__free_lconv_num"
		size = 108
		refs = "0013 __lconv_c 001a free"
	strings:
		$1 = { 48 85 C9 74 66 53 48 83 EC 20 48 8B D9 48 8B 09 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 08 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 10 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 58 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 60 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "__init_numeric"
		size = 616
		refs = "003c __lconv_c 0056 _calloc_crt 0078 memcpy 0084 _malloc_crt 0094 free 00d6 __getlocaleinfo 0168 __free_lconv_num"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 DB 48 8B F1 48 89 48 C8 48 89 58 D0 39 59 1C 75 17 39 59 18 75 12 44 8B EB 44 8B F3 48 8D 2D ?? ?? ?? ?? E9 B6 01 00 00 BF 98 00 00 00 41 BC 01 00 00 00 8B D7 41 8B CC E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 08 41 8B C4 E9 E0 01 00 00 48 8B 96 28 01 00 00 48 8B C8 4C 8B C7 E8 ?? ?? ?? ?? BF 04 00 00 00 8B CF E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 75 0A 48 8B CD E8 ?? ?? ?? ?? EB C8 89 18 39 5E 1C 0F 84 10 01 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8B E8 48 85 C0 0F 84 B7 00 00 00 89 18 0F B7 7E 3E 48 8D 4C 24 30 41 B9 0E 00 00 00 41 8B D4 44 8B C7 48 89 6C 24 20 E8 ?? ?? ?? ?? 48 8D 4D 08 48 89 4C 24 20 48 8D 4C 24 30 41 B9 0F 00 00 00 44 8B C7 41 8B D4 8B D8 E8 ?? ?? ?? ?? 4C 8D 7D 10 48 8D 4C 24 30 41 B9 10 00 00 00 44 8B C7 41 8B D4 0B D8 4C 89 7C 24 20 E8 ?? ?? ?? ?? 41 B9 0E 00 00 00 0B D8 48 8D 45 58 48 8D 4C 24 30 41 8D 51 F4 44 8B C7 48 89 44 24 20 E8 ?? ?? ?? ?? 41 B9 0F 00 00 00 0B D8 48 8D 45 60 48 8D 4C 24 30 41 8D 51 F3 44 8B C7 48 89 44 24 20 E8 ?? ?? ?? ?? 0B C3 74 1C 48 8B CD E8 ?? ?? ?? ?? 41 83 CC FF 48 8B CD E8 ?? ?? ?? ?? 49 8B CE E9 13 FF FF FF 49 8B 17 33 DB EB 11 8A 02 3C 30 7C 11 3C 39 7F 0D 2C 30 88 02 49 03 D4 38 1A 75 EB EB 51 3C 3B 75 F3 4C 8B C2 41 8A 40 01 41 88 00 49 FF C0 84 C0 75 F2 EB E3 48 8B 05 ?? ?? ?? ?? 4C 8B EB 48 89 45 00 48 8B 05 ?? ?? ?? ?? 48 89 45 08 48 8B 05 ?? ?? ?? ?? 48 89 45 10 48 8B 05 ?? ?? ?? ?? 48 89 45 58 48 8B 05 ?? ?? ?? ?? 48 89 45 60 45 89 26 4D 85 ED 74 04 45 89 65 00 48 8B 86 18 01 00 00 48 85 C0 74 03 F0 FF 08 48 8B 8E 10 01 00 00 48 85 C9 74 1D F0 FF 09 75 18 48 8B 8E 10 01 00 00 E8 ?? ?? ?? ?? 48 8B 8E 28 01 00 00 E8 ?? ?? ?? ?? 4C 89 AE 18 01 00 00 4C 89 B6 10 01 00 00 48 89 AE 28 01 00 00 33 C0 4C 8D 5C 24 40 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_259_1_0 {
	meta:
		name = "init_namebuf"
		size = 289
		refs = "0029 tmpnam_s_buf 0039 tmpfile_buf 0047 tmpnam_buf 0053 ??_C@_01KICIPPFI@?2?$AA@ 005e strcpy_s 0099 _getpid 00ac _ultoa_s 00b7 ??_C@_01LFCBOECM@?4?$AA@ 00c2 strcat_s 00db _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 30 33 F6 8B D9 8B D1 85 C9 74 26 FF CA 74 14 FF CA 75 09 48 8D 2D ?? ?? ?? ?? EB 0E 48 8B 6C 24 48 EB 1A 48 8D 2D ?? ?? ?? ?? BE 12 00 00 00 EB 0C 48 8D 2D ?? ?? ?? ?? BE 0E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 8C 00 00 00 48 8D 7D 01 8A 47 FF 3C 5C 74 0A 3C 2F 74 06 C6 07 5C 48 FF C7 83 FB 01 75 05 C6 07 74 EB 03 C6 07 73 48 FF C7 48 8B DD 48 2B DF 48 03 DE E8 ?? ?? ?? ?? 41 B9 20 00 00 00 4C 8B C3 48 8B D7 8B C8 E8 ?? ?? ?? ?? 85 C0 75 2C 4C 8D 05 ?? ?? ?? ?? 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 85 C0 74 42 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 5C 24 40 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "genfname"
		size = 214
		refs = "000f __security_cookie 002a _mbsrchr 004c strtoul 0068 _ultoa_s 0080 strcpy_s 0099 _invoke_watson 00b5 _invalid_parameter_noinfo 00c5 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 38 48 8B DA BA 2E 00 00 00 41 8B E8 48 8B F1 E8 ?? ?? ?? ?? 48 8D 78 01 48 3B FE 72 7D 48 8B C7 48 2B C6 48 3B D8 76 72 33 D2 48 8B CF 44 8D 42 20 E8 ?? ?? ?? ?? FF C0 3B C5 73 63 41 B9 20 00 00 00 48 8D 54 24 30 8B C8 45 8D 41 E8 E8 ?? ?? ?? ?? 85 C0 75 2E 48 2B DF 4C 8D 44 24 30 48 8B CF 48 8D 14 1E E8 ?? ?? ?? ?? 85 C0 74 34 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 83 C8 FF 48 8B 4C 24 38 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 70 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_259_4_0 {
	meta:
		name = "_tmpnam_helper"
		size = 445
		refs = "0029 _errno 0039 _mtinitlocknum 005b _lock 0067 tmpnam_buf 0074 tmpnam_s_buf 0086 init_namebuf 0098 genfname 00aa _access_s 00d2 _getptd_noexit 00f5 _malloc_crt 0112 strcpy_s 012b _invoke_watson 0137 strlen 017f _unlock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 44 89 48 20 41 54 41 56 41 57 48 83 EC 40 41 8B F8 4C 8B FA 4C 8B E1 33 DB E8 ?? ?? ?? ?? 8B 00 89 44 24 30 8D 73 02 8B CE E8 ?? ?? ?? ?? 85 C0 75 17 48 8B 84 24 80 00 00 00 48 21 18 E8 ?? ?? ?? ?? 8B 00 E9 4B 01 00 00 8B CE E8 ?? ?? ?? ?? 90 85 FF 75 0D 48 8D 35 ?? ?? ?? ?? 44 8D 77 0E EB 0D 48 8D 35 ?? ?? ?? ?? 41 BE 12 00 00 00 80 3E 00 75 09 8B CF E8 ?? ?? ?? ?? EB 18 44 8B 44 24 78 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 D5 00 00 00 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 1A 44 8B 44 24 78 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 AF 00 00 00 EB D8 4D 85 E4 75 5E E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 0A BB 0C 00 00 00 E9 91 00 00 00 48 83 78 48 00 75 13 B9 0E 00 00 00 E8 ?? ?? ?? ?? 48 89 47 48 48 85 C0 74 DC 4C 8B 67 48 4C 8B C6 BA 0E 00 00 00 49 8B CC E8 ?? ?? ?? ?? 85 C0 74 5F 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 FF 74 1E 48 8B CE E8 ?? ?? ?? ?? 49 3B C7 72 11 BB 22 00 00 00 4D 85 FF 74 2F 41 C6 04 24 00 EB 28 4C 8B C6 49 8B D7 49 8B CC E8 ?? ?? ?? ?? 85 C0 74 16 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 B9 02 00 00 00 E8 ?? ?? ?? ?? 4C 8B 9C 24 80 00 00 00 4D 89 23 E8 ?? ?? ?? ?? 85 DB 74 04 89 18 EB 06 8B 4C 24 30 89 08 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_259_8_0 {
	meta:
		name = "_tmpfile_helper"
		size = 649
		refs = "002f _errno 0039 _invalid_parameter_noinfo 004f _mtinitlocknum 0066 _lock 0074 tmpfile_buf 008b ??_C@_01KICIPPFI@?2?$AA@ 0090 strcpy_s 00df _getpid 00f2 _ultoa_s 00fd ??_C@_01LFCBOECM@?4?$AA@ 010c strcat_s 0125 _invoke_watson 015a genfname 0167 _getstream 01c0 _sopen_s 0207 _strdup 021c _close 0231 _commode 0259 _unlock_file 0263 _unlock"
	strings:
		$1 = { 48 89 5C 24 18 89 54 24 10 56 57 41 55 41 56 41 57 48 83 EC 50 4C 8B F1 33 F6 45 33 FF 44 89 7C 24 30 33 C0 48 85 C9 0F 95 C0 85 C0 75 16 E8 ?? ?? ?? ?? 8D 5E 16 89 18 E8 ?? ?? ?? ?? 8B C3 E9 30 02 00 00 48 21 31 BB 02 00 00 00 8B CB E8 ?? ?? ?? ?? 85 C0 75 0C E8 ?? ?? ?? ?? 8B 00 E9 11 02 00 00 8B CB E8 ?? ?? ?? ?? 90 41 BD 12 00 00 00 48 8D 0D ?? ?? ?? ?? 41 8B D5 80 3D ?? ?? ?? ?? 00 0F 85 CB 00 00 00 4C 8D 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 A2 00 00 00 48 8D 3D ?? ?? ?? ?? 48 89 7C 24 38 8A 05 ?? ?? ?? ?? 3C 5C 74 17 3C 2F 74 13 C6 05 ?? ?? ?? ?? 5C 48 8D 3D ?? ?? ?? ?? 48 89 7C 24 38 C6 07 74 48 FF C7 48 89 7C 24 38 48 8D 1D ?? ?? ?? ?? 48 2B DF E8 ?? ?? ?? ?? 8B C8 41 B9 20 00 00 00 4C 8B C3 48 8B D7 E8 ?? ?? ?? ?? 85 C0 75 2F 4C 8D 05 ?? ?? ?? ?? 49 8B D5 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 52 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 41 B8 FF FF FF 7F E8 ?? ?? ?? ?? 85 C0 0F 85 E5 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 40 48 85 C0 75 08 8D 70 18 E9 D0 00 00 00 41 BF 01 00 00 00 44 89 7C 24 30 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 83 20 00 C7 44 24 20 80 01 00 00 44 8B 8C 24 88 00 00 00 41 B8 42 85 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 83 F8 11 75 1B 41 B8 FF FF FF 7F 49 8B D5 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 02 EB B6 E8 ?? ?? ?? ?? 83 38 00 75 07 E8 ?? ?? ?? ?? 89 38 83 BC 24 80 00 00 00 FF 74 51 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 43 28 48 85 C0 75 0E 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? EB 2E 83 63 08 00 48 83 23 00 48 83 63 10 00 8B 05 ?? ?? ?? ?? 0F BA E8 07 89 43 18 8B 84 24 80 00 00 00 89 43 1C 49 89 1E EB 05 48 8B 5C 24 40 45 85 FF 74 08 48 8B CB E8 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 85 F6 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 48 8B 9C 24 90 00 00 00 48 83 C4 50 41 5F 41 5E 41 5D 5F 5E C3 }
	condition:
		$1
}

rule file_259_9_0 {
	meta:
		name = "_tmpfile_helper$fin$0"
		size = 43
		refs = "0014 _unlock_file 001f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 83 7D 30 00 74 0A 48 8B 4D 40 E8 ?? ?? ?? ?? 90 B9 02 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_259_10_0 {
	meta:
		name = "tmpfile"
		size = 35
		refs = "0015 _tmpfile_helper"
	strings:
		$1 = { 48 83 EC 28 48 83 64 24 30 00 48 8D 4C 24 30 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "log2"
		size = 895
		refs = "0081 ??_C@_04KGLCPMCP@log2?$AA@ 008b _handle_error 015e __real@3ff0000000000000 018b __real@4000000000000000 01b9 ?ca_4@?1??log2@@9@9 01c1 ?ca_3@?1??log2@@9@9 01cd ?ca_2@?1??log2@@9@9 01dd ?ca_1@?1??log2@@9@9 01f1 ?log2e_lead@?1??log2@@9@9 01f9 ?log2e_tail@?1??log2@@9@9 0253 ?corr@?N@??log2@@9@9 0277 __ImageBase 02cf ?ln_lead_table@?1??log2@@9@9 02db __real@3f80000000000000 02eb __real@3fe0000000000000 030f ?cb_3@?1??log2@@9@9 0317 ?cb_2@?1??log2@@9@9 0323 ?cb_1@?1??log2@@9@9 034d ?ln_tail_table@?1??log2@@9@9"
	strings:
		$1 = { 48 83 EC 68 48 B9 00 00 00 00 00 00 F0 7F F2 0F 11 44 24 70 0F 29 74 24 50 48 8B 54 24 70 66 0F 28 E8 48 8B C2 48 23 C1 48 3B C1 0F 85 AA 00 00 00 48 B9 FF FF FF FF FF FF 0F 00 48 85 D1 74 54 66 0F 57 C0 C7 44 24 40 01 00 00 00 48 B8 00 00 00 00 00 00 08 00 F2 0F 11 44 24 38 48 0B D0 45 33 C0 F2 0F 11 6C 24 30 C7 44 24 28 21 00 00 00 44 89 44 24 20 4C 8B C2 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? E9 E1 02 00 00 48 B8 00 00 00 00 00 00 00 80 48 85 D0 0F 84 CE 02 00 00 66 0F 57 C0 C7 44 24 40 01 00 00 00 49 B8 00 00 00 00 00 00 F8 FF F2 0F 11 44 24 38 F2 0F 11 6C 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 EB 9D 48 B8 FF FF FF FF FF FF FF 7F 48 85 D0 75 3D 66 0F 57 C0 C7 44 24 40 01 00 00 00 41 B9 02 00 00 00 F2 0F 11 44 24 38 F2 0F 11 6C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 49 B8 00 00 00 00 00 00 F0 FF E9 57 FF FF FF 48 B8 00 00 00 00 00 00 00 80 48 85 D0 0F 85 6D FF FF FF 48 B8 00 00 00 00 56 F0 11 C0 48 B9 00 00 00 00 82 F8 02 00 48 03 C2 48 3B C1 0F 87 C8 00 00 00 F2 0F 5C 2D ?? ?? ?? ?? 48 B9 00 00 00 00 FF FF FF FF 66 0F 28 C5 66 0F 28 CD F2 0F 11 6C 24 70 48 8B 44 24 70 48 23 C1 48 89 44 24 70 F2 0F 58 05 ?? ?? ?? ?? F2 0F 10 64 24 70 F2 0F 5E C8 66 0F 28 D1 F2 0F 58 C9 F2 0F 59 D5 66 0F 28 C1 F2 0F 5C EC F2 0F 59 C1 66 0F 28 D8 F2 0F 59 1D ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 C1 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C DA 66 0F 28 D4 F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 DD 66 0F 28 C3 F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 C2 F2 0F 58 C3 E9 4F 01 00 00 48 B8 00 00 00 00 00 00 10 00 48 3B D0 73 33 48 B8 00 00 00 00 00 00 D0 03 41 B8 3C 00 00 00 48 0B D0 48 89 54 24 70 F2 0F 10 44 24 70 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 11 44 24 70 48 8B 54 24 70 EB 03 45 33 C0 48 8B C2 48 B9 FF FF FF FF FF FF 0F 00 4C 8D 0D ?? ?? ?? ?? 48 23 C1 48 B9 00 00 00 00 00 00 E0 3F 48 0B C1 48 8B CA 48 89 44 24 70 48 8B C2 48 C1 E9 2E 83 E1 3F 48 C1 E8 2D 48 C1 EA 34 F2 0F 10 54 24 70 83 E0 01 83 C9 40 81 E2 FF 07 00 00 03 C8 41 2B D0 48 63 C1 81 EA FF 03 00 00 66 0F 6E C9 F2 41 0F 10 B4 C1 ?? ?? ?? ?? F3 0F E6 C9 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C D1 66 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 5E D0 66 0F 6E C2 F3 0F E6 C0 66 0F 28 CA F2 0F 59 CA 66 0F 28 E9 F2 0F 59 2D ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 CE F2 0F 59 35 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 EA F2 41 0F 58 AC C1 ?? ?? ?? ?? F2 0F 58 C1 66 0F 28 E5 F2 0F 59 2D ?? ?? ?? ?? F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 E6 F2 0F 58 E5 F2 0F 58 C4 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "wcscat"
		size = 44
	strings:
		$1 = { 66 83 39 00 4C 8B C1 74 0B 49 83 C0 02 66 41 83 38 00 75 F5 4C 2B C2 0F B7 02 66 41 89 04 10 48 83 C2 02 66 85 C0 75 EF 48 8B C1 C3 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "wcscpy"
		size = 27
	strings:
		$1 = { 4C 8B C1 4C 2B C2 0F B7 02 66 41 89 04 10 48 83 C2 02 66 85 C0 75 EF 48 8B C1 C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_recalloc"
		size = 134
		refs = "002b _errno 0043 _msize 0051 realloc 006f memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 FF 48 8B DA 48 8B F1 48 85 D2 74 1D 33 D2 48 8D 47 E0 48 F7 F3 49 3B C0 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 3D 49 0F AF D8 48 85 C9 74 08 E8 ?? ?? ?? ?? 48 8B F8 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 16 48 3B FB 73 11 48 2B DF 48 8D 0C 07 33 D2 4C 8B C3 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "log10f"
		size = 645
		refs = "001b __mask_127 002d __real_inf 0042 __real_mant 004a __real_one 0051 __real_neg127 0060 __mask_mant_all7 0067 __mask_mant8 0078 __real_notsign 007f __real_threshold 0096 __real_half 00a5 __log_F_inv 00cb __real_1_over_3 00d7 __real_1_over_2 00df __real_log10_2_tail 00e6 __log_128_tail 00ed __log_128_lead 0101 __real_log10_e 0109 __real_log10_2_lead 0134 __real_two 016c __real_ca2 0174 __real_ca1 0188 __mask_lower 01a0 __real_log10_e_tail 01b0 __real_log10_e_lead 01f6 __mask_253 0216 __real_ninf 021d __flag_x_zero 0222 _log10f_special 0234 __real_neg_qnan 023b __flag_x_neg 0262 __real_qnanbit 026d __flag_x_nan"
	strings:
		$1 = { 48 83 EC 78 33 C0 66 0F 6F D8 F3 0F 10 E0 66 0F 72 D3 17 66 0F 7E C0 66 0F FA 1D ?? ?? ?? ?? 66 0F 6F D0 0F 5B EB 66 0F 6F C8 0F 54 0D ?? ?? ?? ?? 0F 2F 0D ?? ?? ?? ?? 0F 84 12 02 00 00 66 0F DB 15 ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? 0F 2F 2D ?? ?? ?? ?? 0F 84 72 01 00 00 44 8B C8 23 05 ?? ?? ?? ?? 44 23 0D ?? ?? ?? ?? 41 D1 E1 41 03 C1 89 44 24 30 0F 54 25 ?? ?? ?? ?? 0F 2F 25 ?? ?? ?? ?? 0F 82 A7 00 00 00 F3 0F 10 4C 24 30 C1 E8 10 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 0F 57 E4 0F 2F C4 0F 86 5B 01 00 00 F3 0F 5C CA F3 41 0F 59 0C 81 F3 0F 10 D1 F3 0F 10 C1 F3 0F 59 15 ?? ?? ?? ?? F3 0F 59 C1 F3 0F 58 15 ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F3 0F 59 D0 F3 0F 59 DD F3 0F 58 CA F3 0F 59 0D ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C D9 F3 0F 59 C5 F3 41 0F 58 1C 81 F3 41 0F 58 04 82 F3 0F 58 C3 48 83 C4 78 C3 66 0F 1F 44 00 00 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C 05 ?? ?? ?? ?? F3 0F 58 D0 F3 0F 10 C8 F3 0F 5E CA F3 0F 10 E0 F3 0F 59 E1 F3 0F 58 C9 F3 0F 10 D1 F3 0F 59 D2 F3 0F 10 D9 F3 0F 59 DA F3 0F 59 15 ?? ?? ?? ?? F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D3 F3 0F 5C D4 66 0F 6F E8 66 0F DB 2D ?? ?? ?? ?? F3 0F 5C C5 F3 0F 58 D0 F3 0F 10 C5 F3 0F 10 CA F3 0F 59 15 ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? F3 0F 59 0D ?? ?? ?? ?? F3 0F 59 2D ?? ?? ?? ?? F3 0F 58 C2 F3 0F 58 C1 F3 0F 58 C5 48 83 C4 78 C3 66 0F EB 15 ?? ?? ?? ?? F3 0F 5C 15 ?? ?? ?? ?? 66 0F 6F EA 66 0F DB 15 ?? ?? ?? ?? 66 0F 7E D0 66 0F 72 D5 17 66 0F FA 2D ?? ?? ?? ?? 0F 5B ED E9 59 FE FF FF 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 75 1E F3 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 0F 1F 84 00 00 00 00 00 F3 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3A 66 66 0F 1F 84 00 00 00 00 00 3B 05 ?? ?? ?? ?? 74 28 3B 05 ?? ?? ?? ?? 74 D0 0B 05 ?? ?? ?? ?? 66 0F 6E C8 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 08 0F 1F 84 00 00 00 00 00 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "setbuf"
		size = 28
		refs = "0018 setvbuf"
	strings:
		$1 = { 48 85 D2 75 09 45 33 C9 44 8D 42 04 EB 09 41 B9 00 02 00 00 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_get_sys_err_msg"
		size = 49
		refs = "000d __sys_nerr 001d __sys_errlist"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 85 C9 78 09 E8 ?? ?? ?? ?? 3B 18 7C 07 E8 ?? ?? ?? ?? 8B 18 E8 ?? ?? ?? ?? 4C 8B D8 48 63 C3 49 8B 04 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "_strerror"
		size = 337
		refs = "0013 _getptd_noexit 0045 _calloc_crt 0073 _mbsnbcat_s 007e ??_C@_02LMMGGCAJ@?3?5?$AA@ 0089 strcat_s 00a2 _invoke_watson 00be _errno 00c9 __sys_nerr 00d9 __sys_errlist 00e8 strlen 00ff strncat_s 010a ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 30 48 8B D9 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 12 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 83 C4 30 5F C3 48 83 78 38 00 BD 86 00 00 00 75 15 BA 01 00 00 00 8B CD E8 ?? ?? ?? ?? 48 89 47 38 48 85 C0 74 CD 48 8B 7F 38 C6 07 00 48 85 DB 74 5F 80 3B 00 74 5A 41 B9 82 00 00 00 4C 8B C3 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 2C 4C 8D 05 ?? ?? ?? ?? 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 2C 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 8B 18 85 DB 78 09 E8 ?? ?? ?? ?? 3B 18 7C 07 E8 ?? ?? ?? ?? 8B 18 E8 ?? ?? ?? ?? 48 63 CB 48 8B 1C C8 48 8B CF E8 ?? ?? ?? ?? 41 B9 84 00 00 00 4C 8B C3 48 8B D5 48 8B CF 4C 2B C8 E8 ?? ?? ?? ?? 85 C0 75 34 4C 8D 05 ?? ?? ?? ?? 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 08 48 8B C7 E9 FC FE FF FF 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_268_3_0 {
	meta:
		name = "_strerror_s"
		size = 231
		refs = "001e _errno 002a _invalid_parameter_noinfo 004c strlen 0063 strcpy_s 006e ??_C@_02LMMGGCAJ@?3?5?$AA@ 0079 strcat_s 0092 _invoke_watson 00d3 strerror_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 49 8B D8 48 8B FA 48 8B F1 48 85 C9 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 A2 00 00 00 48 85 D2 74 E3 C6 01 00 48 85 DB 74 6B 41 80 38 00 74 65 48 8B CB E8 ?? ?? ?? ?? 48 8D 4F F9 48 3B C1 73 54 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 2C 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 2C 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 48 8B CE 48 8B D8 E8 ?? ?? ?? ?? 48 8B CE 48 2B F8 E8 ?? ?? ?? ?? 44 8B 03 48 8D 0C 06 48 8B D7 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_chgsignf"
		size = 25
	strings:
		$1 = { F3 0F 11 44 24 08 8B 44 24 08 0F BA F8 1F 89 44 24 08 F3 0F 10 44 24 08 C3 }
	condition:
		$1
}

rule file_271_3_0 {
	meta:
		name = "_mbsupr_s_l"
		size = 338
		refs = "0034 strnlen 0048 _errno 0054 _invalid_parameter_noinfo 0067 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00c4 __crtLCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 48 8B EC 48 83 EC 70 49 8B F0 48 8B DA 48 8B F9 48 85 C9 74 1D 48 85 D2 74 1D 48 85 C9 0F 84 DF 00 00 00 E8 ?? ?? ?? ?? 48 3B C3 72 22 C6 07 00 EB 05 48 85 D2 74 E3 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 B5 00 00 00 48 8D 4D E0 48 8B D6 E8 ?? ?? ?? ?? 80 3F 00 48 8B F7 48 8B DF 0F 84 84 00 00 00 48 8B 4D E8 0F B6 06 48 8D 14 08 F6 42 1D 04 74 5A 8B 41 04 8B 51 0C C7 44 24 40 01 00 00 00 89 44 24 38 48 8D 45 10 C7 44 24 30 02 00 00 00 48 89 44 24 28 48 8D 4D E0 4C 8B CE 41 B8 00 02 00 00 C7 44 24 20 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 5E 8A 4D 10 48 FF C6 88 0B 48 8B 4D E8 48 FF C3 83 F8 01 7E 16 8A 45 11 EB 0C F6 42 1D 20 74 06 8A 82 1D 01 00 00 88 03 48 FF C3 48 FF C6 80 3E 00 75 80 80 7D F8 00 C6 03 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 33 C0 4C 8D 5C 24 70 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 07 00 E8 ?? ?? ?? ?? 80 7D F8 00 8B 00 74 CF 48 8B 4D F0 83 A1 C8 00 00 00 FD EB C2 }
	condition:
		$1
}

rule file_271_5_0 {
	meta:
		name = "_mbsupr_l"
		size = 43
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 4C 8B C2 48 8B D9 48 F7 D8 48 1B D2 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_627_5_0 {
	meta:
		name = "_mbslwr_l"
		size = 43
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 4C 8B C2 48 8B D9 48 F7 D8 48 1B D2 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_271_6_0 {
	meta:
		name = "_mbsupr"
		size = 43
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 F7 D8 48 1B D2 45 33 C0 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_627_6_0 {
	meta:
		name = "_mbslwr"
		size = 43
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 F7 D8 48 1B D2 45 33 C0 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_273_3_0 {
	meta:
		name = "?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
		size = 619
		refs = "0030 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0042 _errno 004d _invalid_parameter_noinfo 0090 _isctype_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 40 4C 8B FA 48 8B D1 48 8D 4D E0 45 8B E9 4D 8B F0 E8 ?? ?? ?? ?? 4D 85 F6 74 03 4D 89 3E 4D 85 FF 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D F8 00 E9 E4 01 00 00 45 85 ED 74 0C 41 83 FD 02 7C DC 41 83 FD 24 7F D6 45 8A 27 4C 8B 45 E0 33 FF 49 8D 5F 01 41 83 B8 0C 01 00 00 01 7E 18 4C 8D 45 E0 41 0F B6 CC BA 08 00 00 00 E8 ?? ?? ?? ?? 4C 8B 45 E0 EB 12 49 8B 80 40 01 00 00 41 0F B6 CC 0F B7 04 48 83 E0 08 85 C0 74 08 44 8A 23 48 FF C3 EB C0 8B 75 50 41 80 FC 2D 75 05 83 CE 02 EB 06 41 80 FC 2B 75 06 44 8A 23 48 FF C3 45 85 ED 0F 88 57 01 00 00 41 83 FD 01 0F 84 4D 01 00 00 41 83 FD 24 0F 8F 43 01 00 00 45 85 ED 75 28 41 80 FC 30 74 08 41 BD 0A 00 00 00 EB 38 80 3B 78 74 0D 80 3B 58 74 08 41 BD 08 00 00 00 EB 26 41 BD 10 00 00 00 EB 0C 41 83 FD 10 75 18 41 80 FC 30 75 12 80 3B 78 74 05 80 3B 58 75 08 44 8A 63 01 48 83 C3 02 4D 8B 90 40 01 00 00 33 D2 83 C8 FF 41 F7 F5 44 8B C8 41 0F B6 CC 45 0F B7 04 4A 41 8B C8 83 E1 04 74 09 41 0F BE CC 83 E9 30 EB 1C 41 81 E0 03 01 00 00 74 2E 41 8D 44 24 9F 41 0F BE CC 3C 19 77 03 83 E9 20 83 C1 C9 41 3B CD 73 16 83 CE 08 41 3B F9 72 22 75 04 3B CA 76 1C 83 CE 04 4D 85 F6 75 1A 48 FF CB 40 F6 C6 08 75 19 4D 85 F6 49 0F 45 DF 33 FF EB 5C 41 0F AF FD 03 F9 44 8A 23 48 FF C3 EB 8D 41 BC FF FF FF 7F 40 F6 C6 04 75 1E 40 F6 C6 01 75 3C 8B C6 83 E0 02 74 08 81 FF 00 00 00 80 77 09 85 C0 75 29 41 3B FC 76 24 E8 ?? ?? ?? ?? C7 00 22 00 00 00 40 F6 C6 01 74 05 83 CF FF EB 0E 40 8A C6 24 02 F6 D8 1B FF F7 DF 41 03 FC 4D 85 F6 74 03 49 89 1E 40 F6 C6 02 74 02 F7 DF 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C7 EB 1B 4D 85 F6 74 03 4D 89 3E 40 38 7D F8 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 33 C0 4C 8D 5C 24 40 49 8B 5B 30 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_273_4_0 {
	meta:
		name = "strtol"
		size = 48
		refs = "000e __locale_changed 001e __initiallocalestructinfo 0027 ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 33 C0 45 8B C8 4C 8B C2 39 05 ?? ?? ?? ?? 89 44 24 20 48 8B D1 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_860_4_0 {
	meta:
		name = "_strtoi64"
		size = 48
		refs = "000e __locale_changed 001e __initiallocalestructinfo 0027 ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 33 C0 45 8B C8 4C 8B C2 39 05 ?? ?? ?? ?? 89 44 24 20 48 8B D1 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_664_3_0 {
	meta:
		name = "_wcstoi64"
		size = 48
		refs = "000e __locale_changed 001e __initiallocalestructinfo 0027 ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 48 83 EC 38 33 C0 45 8B C8 4C 8B C2 39 05 ?? ?? ?? ?? 89 44 24 20 48 8B D1 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_273_5_0 {
	meta:
		name = "_strtol_l"
		size = 34
		refs = "0019 ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 20 00 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_860_5_0 {
	meta:
		name = "_strtoi64_l"
		size = 34
		refs = "0019 ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 20 00 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_664_4_0 {
	meta:
		name = "_wcstoi64_l"
		size = 34
		refs = "0019 ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 20 00 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_273_6_0 {
	meta:
		name = "strtoul"
		size = 51
		refs = "0006 __locale_changed 0021 __initiallocalestructinfo 002a ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 45 8B C8 4C 8B C2 48 8B D1 C7 44 24 20 01 00 00 00 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_860_6_0 {
	meta:
		name = "_strtoui64"
		size = 51
		refs = "0006 __locale_changed 0021 __initiallocalestructinfo 002a ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 45 8B C8 4C 8B C2 48 8B D1 C7 44 24 20 01 00 00 00 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_664_5_0 {
	meta:
		name = "_wcstoui64"
		size = 51
		refs = "0006 __locale_changed 0021 __initiallocalestructinfo 002a ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 45 8B C8 4C 8B C2 48 8B D1 C7 44 24 20 01 00 00 00 75 09 48 8D 0D ?? ?? ?? ?? EB 02 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_273_7_0 {
	meta:
		name = "_strtoul_l"
		size = 37
		refs = "001c ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_860_7_0 {
	meta:
		name = "_strtoui64_l"
		size = 37
		refs = "001c ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 48 83 EC 38 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_664_6_0 {
	meta:
		name = "_wcstoui64_l"
		size = 37
		refs = "001c ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 48 83 EC 38 49 8B C1 45 8B C8 4C 8B C2 48 8B D1 48 8B C8 C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_274_3_0 {
	meta:
		name = "_isleadbyte_l"
		size = 69
		refs = "000e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 44 0F B6 DB 48 8B 88 40 01 00 00 42 0F B7 04 59 25 00 80 00 00 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_274_4_0 {
	meta:
		name = "isleadbyte"
		size = 71
		refs = "0010 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 20 44 0F B6 DB 48 8B 88 40 01 00 00 42 0F B7 04 59 25 00 80 00 00 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_274_28_0 {
	meta:
		name = "_iswcsym_l"
		size = 44
		refs = "000f iswctype"
		altNames = "__iswcsym"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 07 01 00 00 0F B7 D9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 06 66 83 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_274_30_0 {
	meta:
		name = "_iswcsymf_l"
		size = 44
		refs = "000f iswctype"
		altNames = "__iswcsymf"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 03 01 00 00 0F B7 D9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 06 66 83 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__remainder_piby2"
		size = 1246
		refs = "0030 __security_cookie 0088 ?pibits@?1??__remainder_piby2@@9@9 03f9 __real@c000000000000000 0403 __real@4000000000000000 040b ?piby2_lead@?1??__remainder_piby2@@9@9 042e ?piby2_part3@?1??__remainder_piby2@@9@9 044f ?piby2_part2@?1??__remainder_piby2@@9@9 0460 ?piby2_part1@?1??__remainder_piby2@@9@9 04b0 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 08 55 56 57 41 54 41 55 41 56 41 57 48 8D A8 D8 F0 FF FF 48 81 EC F0 0F 00 00 0F 29 70 B8 0F 29 78 A8 44 0F 29 40 98 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 B0 0E 00 00 4C 8B E2 41 BF FF 03 00 00 48 B8 FF FF FF FF FF FF 0F 00 F2 0F 11 04 24 4C 8B 14 24 48 83 65 A8 00 4D 8B DA 4C 23 D0 48 B8 00 00 00 00 00 00 10 00 4C 0B D0 49 C1 EB 34 B8 67 66 66 66 41 81 E3 FF 07 00 00 49 8B F9 4C 8D 0D ?? ?? ?? ?? 45 2B DF 4D 8B E8 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 92 03 C0 44 2B D8 8D 42 12 4C 63 C0 4B 8B 0C C1 4B 8B 54 C1 F8 49 0F AF CA 49 0F AF D2 48 8B C1 48 C1 E9 0A 48 03 D1 4B 8B 4C C1 F0 49 23 C7 48 89 45 A0 48 8B C2 48 C1 EA 0A 49 0F AF CA 48 03 CA 4B 8B 54 C1 E8 49 23 C7 48 89 45 98 48 8B C1 48 C1 E9 0A 49 0F AF D2 48 03 D1 4B 8B 4C C1 E0 49 23 C7 48 89 45 90 48 8B C2 48 C1 EA 0A 49 0F AF CA 48 03 CA 4B 8B 54 C1 D8 49 23 C7 48 89 45 88 48 8B C1 48 C1 E9 0A 49 0F AF D2 48 03 D1 4B 8B 4C C1 D0 49 23 C7 48 89 45 80 48 8B C2 48 C1 EA 0A 49 0F AF CA 48 03 CA 4B 8B 54 C1 C8 49 23 C7 48 89 44 24 78 48 8B C1 48 C1 E9 0A 49 0F AF D2 49 23 C7 48 03 D1 48 89 44 24 70 48 8B C2 49 23 C7 48 89 44 24 68 4B 8B 4C C1 C0 48 C1 EA 0A 49 0F AF CA 48 03 CA 4B 8B 54 C1 B8 48 8B C1 48 C1 E9 0A 49 23 C7 48 89 44 24 60 49 0F AF D2 48 03 D1 4B 8B 4C C1 B0 48 8B C2 48 C1 EA 0A 49 23 C7 48 89 44 24 58 49 0F AF CA 48 03 CA 4B 8B 54 C1 A8 48 8B C1 48 C1 E9 0A 49 23 C7 48 89 44 24 50 49 0F AF D2 48 03 D1 4B 8B 4C C1 A0 48 8B C2 48 C1 EA 0A 49 23 C7 48 89 44 24 48 49 0F AF CA 48 03 CA 4B 8B 54 C1 98 48 8B C1 48 C1 E9 0A 49 23 C7 48 89 44 24 40 49 0F AF D2 48 03 D1 4B 8B 4C C1 90 48 8B C2 48 C1 EA 0A 49 23 C7 48 89 44 24 38 49 0F AF CA 48 03 CA 4B 8B 54 C1 88 48 8B C1 48 C1 E9 0A 49 23 C7 48 89 44 24 30 49 0F AF D2 48 03 D1 4B 8B 4C C1 80 48 8B C2 48 C1 EA 0A 49 23 C7 48 89 44 24 28 49 0F AF CA 48 03 CA 4B 8B 94 C1 70 FF FF FF 48 8B C1 48 C1 E9 0A 49 23 C7 48 89 44 24 20 4B 8B 84 C1 78 FF FF FF 49 0F AF D2 49 0F AF C2 48 03 C1 48 8B D8 48 C1 E8 0A 48 03 D0 49 23 DF B8 0A 00 00 00 49 23 D7 41 2B C3 48 89 5C 24 18 48 89 54 24 10 48 C1 E2 0A 8D 48 FF 48 0B D3 48 D3 EA 41 BE 01 00 00 00 49 BA 00 00 00 00 00 00 20 00 83 E2 07 45 8B CE 8B C8 8B F2 41 23 F6 74 52 D1 FA 48 F7 D3 41 03 D6 83 E2 03 89 17 41 8B D6 48 D3 E2 49 2B D6 48 23 D3 49 3B D2 73 27 4C 8D 44 24 18 48 8B C2 49 83 C0 08 45 03 CE 49 8B 08 48 C1 E0 0A 48 F7 D1 49 23 CF 48 8B D1 48 0B D0 49 3B D2 72 DE 49 63 C1 4C 8B 44 C4 18 49 F7 D0 EB 35 D1 FA 89 17 49 8B D6 48 D3 E2 49 2B D6 48 23 D3 49 3B D2 73 18 48 8D 44 24 18 48 83 C0 08 48 C1 E2 0A 45 03 CE 48 0B 10 49 3B D2 72 ED 49 63 C1 4C 8B 44 C4 18 43 8D 04 89 49 C1 E0 36 03 C0 44 2B D8 41 83 C3 34 EB 19 49 8B C0 48 8B CA 45 03 DE 48 C1 E1 3F 48 D1 E8 4C 8B C1 4C 0B C0 48 D1 EA 49 3B D2 73 E2 49 63 CB 49 B9 FF FF FF FF FF FF 0F 00 49 23 D1 48 8D 81 FF 03 00 00 48 C1 E0 34 48 0B C2 85 F6 74 0D 48 BA 00 00 00 00 00 00 00 80 48 0B C2 48 89 04 24 49 C1 E8 0C 48 8D 81 CA 03 00 00 F2 44 0F 10 04 24 48 C1 E0 34 48 89 04 24 4C 0B C0 F2 0F 10 04 24 4C 89 04 24 F2 0F 10 3C 24 F2 0F 5C F8 85 F6 74 0A F2 0F 59 3D ?? ?? ?? ?? EB 08 F2 0F 59 3D ?? ?? ?? ?? F2 0F 59 3D ?? ?? ?? ?? F2 44 0F 11 04 24 66 41 0F 28 D8 48 8B 04 24 66 41 0F 28 F0 48 25 00 00 00 F8 F2 44 0F 59 05 ?? ?? ?? ?? 48 89 04 24 F2 0F 10 14 24 F2 0F 5C DA 66 0F 28 EA F2 0F 59 35 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? 66 0F 28 C3 F2 44 0F 58 C7 F2 0F 59 2D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 1D ?? ?? ?? ?? F2 0F 5C EE F2 0F 58 E8 F2 0F 58 EA F2 0F 58 EB F2 41 0F 58 E8 66 0F 28 C5 F2 0F 58 C6 F2 0F 5C F0 F2 41 0F 11 04 24 F2 0F 58 F5 F2 41 0F 11 75 00 48 8B 8D B0 0E 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 0F 00 00 49 8B 5B 40 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "expf"
		size = 344
		refs = "000d __real_inf 0027 __real_64_by_log2 0033 __real_p8192 0041 __real_m9600 0052 __two_to_jby64_table 005e __real_log2_by_64 0084 __real_1_by_6 0094 __real_1_by_2 00d4 __real_zero 00df __flag_y_zero 00e4 _expf_special 00ff __flag_y_inf 011a __real_ninf 0122 __real_qnanbit 012d __flag_x_nan"
	strings:
		$1 = { 48 81 EC 88 00 00 00 66 0F 7E C2 8B 05 ?? ?? ?? ?? 23 C2 3B 05 ?? ?? ?? ?? 0F 84 F1 00 00 00 F3 0F 5A C0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 66 0F 2F 1D ?? ?? ?? ?? 0F 83 B3 00 00 00 66 0F 2F 1D ?? ?? ?? ?? 0F 82 85 00 00 00 F2 0F E6 E3 4C 8D 15 ?? ?? ?? ?? F3 0F E6 CC F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 66 0F 7E E1 48 C7 C0 3F 00 00 00 23 C1 F2 0F 5C C2 F2 0F 10 C8 2B C8 C1 F9 06 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 C0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 C1 48 81 C1 FF 03 00 00 48 C1 E1 34 F2 41 0F 10 14 C2 F2 0F 59 C2 F2 0F 58 C2 48 89 4C 24 30 F2 0F 59 44 24 30 F2 0F 5A C0 48 81 C4 88 00 00 00 C3 F3 0F 10 0D ?? ?? ?? ?? 66 0F 6E C2 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 63 00 00 00 0F 1F 00 F3 0F 10 0D ?? ?? ?? ?? 66 0F 6E C2 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 46 66 0F 1F 44 00 00 3B 15 ?? ?? ?? ?? 74 38 3B 15 ?? ?? ?? ?? 74 20 0B 15 ?? ?? ?? ?? 66 0F 6E CA 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 18 0F 1F 84 00 00 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 7B FF FF FF 0F 1F 00 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "_wputenv_helper"
		size = 697
		refs = "0025 __env_initialized 003d _errno 0048 _invalid_parameter_noinfo 005b wcschr 0083 wcsnlen 0090 wcslen 00a1 _calloc_crt 010e wcscpy_s 0144 __crtwsetenv 015a free 0166 _environ 0197 __imp_WideCharToMultiByte 023c strlen 0281 __crtsetenv"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 55 57 41 54 41 55 41 56 48 8B EC 48 83 EC 40 45 33 F6 48 8B F2 48 8B F9 44 39 35 ?? ?? ?? ?? 4C 89 75 48 75 08 83 C8 FF E9 6B 02 00 00 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB E1 48 85 D2 75 67 44 8D 6A 3D 41 8B D5 E8 ?? ?? ?? ?? 48 85 C0 74 28 48 8B C8 48 2B CF 48 83 E1 FE 48 81 F9 FE FF 00 00 7D C5 BB FF 7F 00 00 48 8D 48 02 8B D3 E8 ?? ?? ?? ?? 48 3B C3 73 B0 48 8B CF E8 ?? ?? ?? ?? BA 02 00 00 00 48 8D 48 01 48 8B D8 E8 ?? ?? ?? ?? 48 89 45 48 48 85 C0 74 81 4C 8B C7 48 8D 53 01 48 8B C8 EB 7B BB FF 7F 00 00 8B D3 E8 ?? ?? ?? ?? 8B D3 48 8B CE 4C 8B E0 E8 ?? ?? ?? ?? 4C 3B E3 0F 83 60 FF FF FF 48 3B C3 0F 83 57 FF FF FF 4A 8D 5C 20 02 BA 02 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 89 45 48 48 85 C0 0F 84 2B FF FF FF 4C 8B C7 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 48 8B 45 48 41 BD 3D 00 00 00 66 46 89 2C 60 48 8B 45 48 49 FF C4 49 2B DC 4C 8B C6 4A 8D 0C 60 48 8B D3 E8 ?? ?? ?? ?? 48 8D 4D 48 BA 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 17 48 8B 4D 48 48 85 C9 0F 84 D6 FE FF FF E8 ?? ?? ?? ?? E9 CC FE FF FF 4C 39 35 ?? ?? ?? ?? 0F 84 30 01 00 00 4C 89 74 24 38 4C 89 74 24 30 83 CB FF 4C 8B C7 33 D2 33 C9 44 8B CB 44 89 74 24 28 4C 89 75 40 4C 89 74 24 20 FF 15 ?? ?? ?? ?? 44 8B E0 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B C3 E9 EE 00 00 00 48 85 F6 74 2D 4C 89 74 24 38 4C 89 74 24 30 44 8B CB 4C 8B C6 33 D2 33 C9 44 89 74 24 28 4C 89 74 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 C1 45 8D 64 04 01 49 63 CC BA 01 00 00 00 E8 ?? ?? ?? ?? 48 89 45 40 48 85 C0 74 B1 4C 89 74 24 38 4C 89 74 24 30 44 8B CB 4C 8B C7 33 D2 33 C9 44 89 64 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 0E 48 8B 4D 40 E8 ?? ?? ?? ?? E9 70 FF FF FF 48 85 F6 74 43 48 8B 4D 40 E8 ?? ?? ?? ?? 48 8B 4D 40 4C 89 74 24 38 44 88 2C 08 48 FF C0 4C 89 74 24 30 44 2B E0 48 03 45 40 44 8B CB 4C 8B C6 33 D2 33 C9 44 89 64 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 AA 48 8D 4D 40 33 D2 E8 ?? ?? ?? ?? 85 C0 74 17 48 8B 4D 40 48 85 C9 0F 84 17 FF FF FF E8 ?? ?? ?? ?? E9 0D FF FF FF 33 C0 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 40 41 5E 41 5D 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_278_1_0 {
	meta:
		name = "_wputenv"
		size = 50
		refs = "000f _lock 001a _wputenv_helper 0026 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 D2 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_345_1_0 {
	meta:
		name = "_putenv"
		size = 50
		refs = "000f _lock 001a _putenv_helper 0026 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 D2 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_278_3_0 {
	meta:
		name = "_wputenv_s"
		size = 117
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 003e _lock 004a _wputenv_helper 005f _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B FA 48 8B F1 33 DB 8B C3 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 2D B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? 8B 18 B9 07 00 00 00 E8 ?? ?? ?? ?? EB CF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_345_3_0 {
	meta:
		name = "_putenv_s"
		size = 117
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 003e _lock 004a _putenv_helper 005f _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B FA 48 8B F1 33 DB 8B C3 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 2D B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? 8B 18 B9 07 00 00 00 E8 ?? ?? ?? ?? EB CF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__isnand"
		size = 37
	strings:
		$1 = { 41 B8 00 00 F0 7F 8B C2 41 23 C0 41 3B C0 75 12 F7 C2 FF FF 0F 00 75 04 85 C9 74 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "__Fill_FPIEEE_RECORD2"
		size = 242
		altNames = "__Fill_FPIEEE_RECORD"
	strings:
		$1 = { 48 8B 51 20 8B 41 10 4C 8B C1 33 02 41 BB FE FF FF FF 41 BA FD FF FF FF 83 E0 03 41 B9 FB FF FF FF 31 02 8B 41 14 48 8B 51 20 C1 E0 02 33 02 83 E0 1C 31 02 48 8B 49 20 41 8B 00 C1 E8 05 BA F7 FF FF FF F7 D0 33 41 08 83 E0 01 31 41 08 41 8B 00 49 8B 48 20 C1 E8 03 F7 D0 33 41 08 83 E0 02 31 41 08 41 8B 00 49 8B 48 20 D1 E8 F7 D0 33 41 08 83 E0 04 31 41 08 41 8B 00 49 8B 48 20 03 C0 F7 D0 33 41 08 83 E0 08 31 41 08 41 8B 00 49 8B 48 20 C1 E0 04 F7 D0 33 41 08 83 E0 10 31 41 08 49 8B 40 20 B9 EF FF FF FF 44 21 58 0C 49 8B 40 20 44 21 50 0C 49 8B 40 20 44 21 48 0C 49 8B 40 20 21 50 0C 49 8B 40 20 21 48 0C 49 8B 40 20 44 21 58 04 49 8B 40 20 44 21 50 04 49 8B 40 20 44 21 48 04 49 8B 40 20 21 50 04 49 8B 40 20 21 48 04 C3 }
	condition:
		$1
}

rule file_279_2_0 {
	meta:
		name = "fp64_is_qnan"
		size = 32
	strings:
		$1 = { 48 C1 E9 20 BA 00 00 F0 7F 8B C1 23 C2 3B C2 75 0C 0F BA E1 13 73 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_3_0 {
	meta:
		name = "fp64_is_snan"
		size = 50
	strings:
		$1 = { 41 B8 00 00 F0 7F 48 8B D1 48 C1 EA 20 8B C2 41 23 C0 41 3B C0 75 18 0F BA E2 13 72 12 F7 C2 FF FF 07 00 75 04 85 C9 74 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_4_0 {
	meta:
		name = "fp64_is_inf"
		size = 42
	strings:
		$1 = { 41 B8 00 00 F0 7F 48 8B D1 48 C1 EA 20 8B C2 41 23 C0 41 3B C0 75 10 F7 C2 FF FF 0F 00 75 08 85 C9 75 04 8D 41 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_5_0 {
	meta:
		name = "fp64_is_zero"
		size = 32
	strings:
		$1 = { 48 8B C1 48 C1 E8 20 A9 00 00 F0 7F 75 0F A9 FF FF 0F 00 75 08 85 C9 75 04 8D 41 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_6_0 {
	meta:
		name = "fp64_is_denormal"
		size = 34
	strings:
		$1 = { 48 8B C1 48 C1 E8 20 A9 00 00 F0 7F 75 11 A9 FF FF 0F 00 75 04 85 C9 74 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_279_7_0 {
	meta:
		name = "RoundDoubleToIntegral"
		size = 607
		refs = "006a fp64_is_inf 0091 fp64_is_denormal"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 48 89 50 10 57 41 54 41 55 48 83 EC 20 8B D9 41 BB FF 07 00 00 48 8B CA 48 C1 E9 20 45 33 D2 49 8B E8 8B C1 4C 8B CA C1 E8 14 41 23 C3 41 3B C3 75 0A 0F BA E1 13 0F 82 F4 01 00 00 8B 7C 24 48 41 BD FF FF 0F 00 85 C0 75 0D 41 85 CD 75 08 85 FF 0F 84 D9 01 00 00 48 8B CA E8 ?? ?? ?? ?? 85 C0 0F 85 C9 01 00 00 44 8B 44 24 4C 41 8B D0 C1 EA 14 41 23 D3 81 FA 33 04 00 00 0F 83 AF 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 E7 00 00 00 81 FA FF 03 00 00 0F 82 DB 00 00 00 44 8D 9A 01 FC FF FF 8D 48 34 41 8B C2 41 2B CB 41 8B F0 49 BC 00 00 00 00 00 00 10 00 49 23 F5 48 C1 E6 20 48 0B F7 49 0B F4 48 8B FE 48 D3 EF 48 8B D7 48 D3 E2 41 8D 4B 0C 48 D3 E6 48 D3 EE B9 33 00 00 00 48 85 F6 0F 95 C0 89 45 00 8D 41 CE 44 3B D9 74 06 41 2B CB 48 D3 E0 41 B9 00 00 00 80 85 DB 75 0D 48 3B F0 72 3C 75 21 40 F6 C7 01 EB 19 83 FB 01 75 07 45 85 C1 74 2A EB 0A 83 FB 02 75 23 45 85 C1 75 1E 48 85 F6 74 19 48 8D 14 42 48 B8 00 00 00 00 00 00 20 00 48 3B D0 75 06 41 FF C3 49 8B D4 41 8D 8B FF 03 00 00 48 8B C2 45 23 C1 C1 E1 14 48 C1 E8 20 89 54 24 48 41 23 C5 81 E1 00 00 F0 7F 0B C8 41 0B C8 89 4C 24 4C 48 8B 44 24 48 E9 C2 00 00 00 41 B9 00 00 00 80 85 DB 75 4E 45 85 C1 74 2C 81 FA FE 03 00 00 75 18 45 85 C5 75 04 85 FF 74 0F 49 BA 00 00 00 00 00 00 F0 BF E9 80 00 00 00 49 BA 00 00 00 00 00 00 00 80 EB 74 81 FA FE 03 00 00 75 6C 45 85 C5 75 04 85 FF 74 63 49 BA 00 00 00 00 00 00 F0 3F EB 57 45 23 C1 83 FB 01 75 15 41 F7 D8 49 BA 00 00 00 00 00 00 F0 BF 48 1B C0 4C 23 D0 EB 3A 83 FB 02 75 22 41 F7 D8 48 B9 00 00 00 00 00 00 10 40 49 BA 00 00 00 00 00 00 F0 3F 48 1B C0 48 23 C1 4C 03 D0 EB 13 41 F7 D8 49 BA 00 00 00 00 00 00 00 80 48 1B C9 4C 23 D1 C7 45 00 01 00 00 00 49 8B C2 EB 07 49 8B C1 44 89 55 00 48 8B 5C 24 40 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 20 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_279_8_0 {
	meta:
		name = "XMMI2_FP_Emulation"
		size = 6336
		refs = "001d __read_mxcsr 002c __write_mxcsr 0123 __int_maxsd 0136 __int_minsd 0143 __Fill_FPIEEE_RECORD2 01df __int_sqrtsd 036f __int_divsd 0382 __int_mulsd 038f __int_subsd 039c __int_addsd 045d __MIN_DOUBLE_NORMAL 050e __TWO_TO_768 0b1d __int_cmpsd 0beb __int_ucomisd 0bf8 __int_comisd 0de3 __int_cvtsd2ss 0e7a __int_cvtss2sd 125d __int_cvttsd2si 1264 __int64_cvttsd2si 127f __int_cvtsd2si 128c __int64_cvtsd2si 1399 __int_cvtsi2ss 14ea fp64_is_snan 1544 fp64_is_denormal 15cd RoundDoubleToIntegral 17e1 __int_cvttss2si 17ef __int_cvtss2si"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 38 33 FF 4C 8B E1 89 7D 58 E8 ?? ?? ?? ?? BE 80 1F 00 00 8B CE 89 45 48 E8 ?? ?? ?? ?? 49 8B 54 24 20 41 BD FF 0F 00 00 8B 0A 44 8B FF 89 7D 50 41 33 4C 24 10 83 E1 03 31 0A 49 8B 4C 24 20 41 8B 44 24 14 C1 E0 02 33 01 83 E0 1C 31 01 49 8B 4C 24 20 8B 01 C1 E8 05 41 23 C5 83 F8 5D 0F 87 DE 0C 00 00 0F 84 14 16 00 00 83 F8 58 0F 87 F4 0A 00 00 83 F8 57 0F 83 55 0A 00 00 83 F8 49 0F 82 FE 0A 00 00 83 F8 50 0F 86 10 02 00 00 83 F8 52 0F 86 E0 00 00 00 83 F8 56 0F 87 E3 0A 00 00 41 39 7C 24 0C 8D 46 40 0F 45 F0 8B CE E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 8B 03 49 8B 4B 10 49 8B 53 30 C1 E8 05 41 23 C5 83 F8 53 72 28 83 F8 54 76 15 83 F8 56 77 1E 41 81 23 1F 05 FE FF 41 81 0B 00 05 00 00 EB 0E 41 81 23 3F 05 FE FF 41 81 0B 20 05 00 00 49 8B 44 24 20 44 8B 00 41 C1 E8 05 45 23 C5 41 83 E8 28 74 18 41 FF C8 75 0A E8 ?? ?? ?? ?? E9 F5 09 00 00 48 8B 5D E8 E9 EF 09 00 00 E8 ?? ?? ?? ?? E9 E2 09 00 00 49 8B CC E8 ?? ?? ?? ?? 85 FF 74 05 45 09 74 24 04 85 F6 74 0E 49 8B 44 24 20 83 48 0C 10 45 09 6C 24 04 49 8B 44 24 20 44 09 68 60 49 8B 4C 24 20 8B 41 60 83 E0 E3 41 0B C6 89 41 60 49 8B 44 24 20 48 89 58 50 E9 2E 17 00 00 41 39 7C 24 0C 41 8B 4C 24 10 B8 C0 1F 00 00 0F 45 F0 85 C9 74 1E FF C9 74 16 FF C9 74 0C FF C9 75 12 81 CE 00 60 00 00 EB 0A 0F BA EE 0E EB 04 0F BA EE 0D 8B CE E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 8B 03 49 8B 4B 10 25 BF 00 FE FF 0D A0 00 00 00 41 89 03 E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 41 BD 01 00 00 00 8B F8 83 E7 3F 8B F7 41 23 F5 74 0A 45 84 2C 24 0F 84 BD 01 00 00 8B C7 41 BE 02 00 00 00 41 23 C6 74 05 45 09 74 24 04 85 C0 74 0A 45 84 34 24 0F 84 3C 09 00 00 83 E7 20 74 4F 41 F6 04 24 20 75 48 49 8B CC E8 ?? ?? ?? ?? 4D 8B 5C 24 20 45 09 6B 0C 41 83 4C 24 04 20 49 8B 44 24 20 44 09 68 04 49 8B 44 24 20 44 09 68 60 49 8B 4C 24 20 8B 41 60 83 E0 E3 41 0B C6 89 41 60 49 8B 44 24 20 48 89 58 50 E9 72 01 00 00 49 8B CC E8 ?? ?? ?? ?? 85 FF 74 0F 49 8B 44 24 20 44 09 68 0C 41 83 4C 24 04 20 85 F6 0F 84 C4 FE FF FF 49 8B 44 24 20 83 48 0C 10 45 89 6C 24 04 E9 B1 FE FF FF 48 8B 59 10 48 8B 79 30 48 89 5D 60 48 89 7D 58 83 F8 49 72 3F 83 F8 4A 76 31 83 F8 4C 76 21 83 F8 4E 76 11 83 F8 50 77 2B 81 21 9F 00 FE FF 0F BA 29 07 EB 1F 81 21 7F 00 FE FF 83 09 60 EB 14 81 21 5F 00 FE FF 83 09 40 EB 09 81 21 3F 00 FE FF 83 09 20 45 39 7C 24 08 B8 80 9F 00 00 0F 45 F0 45 39 7C 24 0C 74 03 83 CE 40 41 8B 4C 24 10 85 C9 74 1E FF C9 74 16 FF C9 74 0C FF C9 75 12 81 CE 00 60 00 00 EB 0A 0F BA EE 0E EB 04 0F BA EE 0D 8B CE E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 8B 03 C1 E8 05 41 23 C5 FF C8 74 39 FF C8 74 28 FF C8 74 17 FF C8 75 0D 48 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 2B 48 8B 75 E8 EB 2C 48 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 18 48 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 0B 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 89 45 E8 48 8B F0 E8 ?? ?? ?? ?? 41 BD 01 00 00 00 44 8B F8 41 83 E7 3F 45 84 2C 24 75 3E 45 84 FD 74 39 49 8B CC E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 83 4B 0C 10 49 8B 44 24 20 45 09 6C 24 04 83 48 04 10 49 8B 44 24 20 83 60 60 FE 8B 4D 48 E8 ?? ?? ?? ?? 41 8B C5 E9 9B 07 00 00 41 BE 02 00 00 00 45 84 34 24 75 1E 45 84 FE 74 19 49 8B CC E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 83 63 60 FE 45 09 74 24 04 EB C6 41 F6 04 24 04 75 29 41 F6 C7 04 74 23 49 8B CC E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 83 4B 0C 08 49 8B 44 24 20 41 83 4C 24 04 04 83 48 04 08 EB 8D 8B 4D EC 48 8B 05 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 44 8B 45 E8 41 8B D7 C1 EA 04 41 23 D5 81 E1 FF FF FF 7F 75 05 45 85 C0 74 0C 41 3B C9 72 24 75 14 44 3B C0 72 1D 41 3B C9 75 0A 44 3B C0 75 05 41 3B D5 74 0E 85 C9 75 0F 45 85 C0 75 0A 41 3B D5 75 05 41 8B C5 EB 03 8B 45 50 41 F6 04 24 10 0F 85 B9 02 00 00 85 C0 0F 84 B1 02 00 00 E8 ?? ?? ?? ?? 0F BA E0 0F 73 04 0F BA F0 0F 83 E0 C0 8B C8 E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 8B 03 C1 E8 05 25 FF 0F 00 00 FF C8 0F 84 6D 01 00 00 FF C8 0F 84 C3 00 00 00 FF C8 74 53 FF C8 0F 85 F9 01 00 00 48 8B 15 ?? ?? ?? ?? 48 8B CB BE 00 00 F0 7F E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 85 75 64 75 0D 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 0E 48 8B CF 48 8B D8 E8 ?? ?? ?? ?? 48 8B F8 48 8B D7 48 8B CB E8 ?? ?? ?? ?? E9 AB 01 00 00 48 8B 15 ?? ?? ?? ?? BE 00 00 F0 7F 85 75 64 75 1C 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 2F 85 75 5C 75 0D 48 8B CF E8 ?? ?? ?? ?? 48 8B C8 EB 0E 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B D8 48 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F8 48 8B D7 48 8B CB E8 ?? ?? ?? ?? E9 3F 01 00 00 8B 45 64 BE FF 07 00 00 41 BF FF FF 0F 80 C1 E8 14 23 C6 75 23 48 8B 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 18 48 C1 EB 20 05 00 06 00 00 41 23 DF C1 E0 14 0B D8 89 5D 64 48 8B 5D 60 8B 45 5C C1 E8 14 23 C6 75 20 48 8B 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? EB 18 05 00 06 00 00 48 C1 EF 20 C1 E0 14 41 23 FF 0B F8 89 7D 5C 48 8B 45 58 48 8B D0 48 8B CB E8 ?? ?? ?? ?? E9 9D 00 00 00 8B 45 64 BE FF 07 00 00 41 BF FF FF 0F 80 C1 E8 14 23 C6 75 23 48 8B 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 18 48 C1 EB 20 05 00 06 00 00 41 23 DF C1 E0 14 0B D8 89 5D 64 48 8B 5D 60 8B 45 5C C1 E8 14 23 C6 75 20 48 8B 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? EB 18 05 00 06 00 00 48 C1 EF 20 C1 E0 14 41 23 FF 0B F8 89 7D 5C 48 8B 45 58 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 49 8B CC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B D8 41 83 E3 3F 41 F6 C3 20 74 0F 49 8B 4C 24 20 44 09 69 0C 41 83 4C 24 04 20 49 8B 4C 24 20 44 09 71 0C 49 8B 44 24 20 41 83 4C 24 04 10 44 09 70 04 45 84 DE 74 05 45 09 74 24 04 49 8B 44 24 20 44 09 68 60 49 8B 4C 24 20 8B 41 60 83 E0 E3 41 0B C6 89 41 60 49 8B 44 24 20 48 89 70 50 E9 76 FC FF FF 41 F6 04 24 08 0F 85 62 02 00 00 41 F6 C7 08 0F 84 58 02 00 00 E8 ?? ?? ?? ?? 83 E0 C0 8B C8 E8 ?? ?? ?? ?? 4D 8B 5C 24 20 41 8B 03 C1 E8 05 25 FF 0F 00 00 FF C8 0F 84 3D 01 00 00 FF C8 0F 84 85 00 00 00 FF C8 74 50 FF C8 0F 85 D7 01 00 00 48 8B 15 ?? ?? ?? ?? BE 00 00 F0 7F 85 75 5C 75 0D 48 8B CF E8 ?? ?? ?? ?? 48 8B C8 EB 0E 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B D8 48 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? E9 8C 01 00 00 48 8B 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 E8 ?? ?? ?? ?? 48 8B CB 48 8B D0 E8 ?? ?? ?? ?? E9 5B 01 00 00 8B 45 5C BE FF 07 00 00 41 BF 00 00 10 00 C1 E8 14 23 C6 BE 00 00 F0 7F 89 45 50 8B 45 64 23 C6 BE 00 00 10 80 3D 00 00 10 60 72 23 48 8B 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 14 48 C1 EB 20 23 DE 41 0B DF 83 65 60 00 89 5D 64 48 8B 5D 60 81 7D 50 01 06 00 00 72 20 48 8B 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? EB 14 48 C1 EF 20 23 FE 41 0B FF 83 65 58 00 89 7D 5C 48 8B 45 58 48 8B D0 48 8B CB E8 ?? ?? ?? ?? E9 AB 00 00 00 8B 45 5C BE FF 07 00 00 41 BF 00 00 10 00 C1 E8 14 23 C6 BE 00 00 F0 7F 89 45 50 8B 45 64 23 C6 BE 00 00 10 80 3D 00 00 10 60 72 23 48 8B 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 EB 14 48 C1 EB 20 23 DE 41 0B DF 83