private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
		size = 131
		refs = "001f ___acrt_locale_changed_data 0027 ___acrt_initial_locale_pointers 003a ___acrt_getptd 0053 ___acrt_update_locale_info 005b ___acrt_update_multibyte_info"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B F9 8B 4D 08 C6 47 0C 00 85 C9 74 0A 8B 01 89 47 04 8B 41 04 EB 16 83 3D ?? ?? ?? ?? 00 75 12 A1 ?? ?? ?? ?? 89 47 04 A1 ?? ?? ?? ?? 89 47 08 EB 44 56 E8 ?? ?? ?? ?? 8D 57 04 89 07 52 8D 77 08 8B 48 4C 89 0A 8B 48 48 50 89 0E E8 ?? ?? ?? ?? 56 FF 37 E8 ?? ?? ?? ?? 8B 0F 83 C4 10 8B 81 50 03 00 00 5E A8 02 75 0D 83 C8 02 89 81 50 03 00 00 C6 47 0C 01 8B C7 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 16
	strings:
		$1 = { 80 79 0C 00 74 09 8B 01 83 A0 50 03 00 00 FD C3 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z"
		size = 169
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0066 __imp__WideCharToMultiByte@32 0089 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 4D EC 56 FF 75 1C E8 ?? ?? ?? ?? 8B 45 18 33 F6 85 C0 74 02 89 30 8B 45 F0 39 B0 A8 00 00 00 75 22 66 8B 4D 14 B8 FF 00 00 00 66 3B C8 77 46 8B 45 0C 88 08 8B 45 08 85 C0 74 4E C7 00 01 00 00 00 EB 46 8D 4D FC 89 75 FC 51 56 FF 75 10 8D 4D 14 FF 75 0C 6A 01 51 56 FF 70 08 FF 15 ?? ?? ?? ?? 85 C0 74 10 39 75 FC 75 0B 8B 4D 08 85 C9 74 18 89 01 EB 14 8B 45 08 85 C0 74 03 83 08 FF E8 ?? ?? ?? ?? 6A 2A 5E 89 30 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "_internal_wcsrtombs"
		size = 365
		refs = "0009 ___security_cookie 0027 __errno 0032 __invalid_parameter_noinfo 0050 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 006e ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 0110 _memcpy_s 0165 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 8B 4D 14 89 45 E0 89 4D E8 57 8B 7D 08 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 20 01 00 00 83 65 F0 00 8D 4D D0 53 8B 18 56 33 F6 89 5D EC 56 E8 ?? ?? ?? ?? 85 FF 75 67 8D 45 D4 50 FF 75 E8 0F B7 03 50 6A 05 8D 45 F4 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 F0 83 C4 18 85 C0 7E 33 8D 7D F4 80 7C 07 FF 00 74 31 03 F0 83 C3 02 8D 45 D4 50 FF 75 E8 0F B7 03 50 6A 05 8D 45 F4 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 F0 83 C4 18 85 C0 7F D0 83 CE FF E9 93 00 00 00 4E 03 F0 E9 8B 00 00 00 8B 4D 10 85 C9 74 7F 8B 45 D4 3B 48 04 73 08 8D 4D F4 89 4D E4 EB 05 8B CF 89 7D E4 8D 45 D4 50 FF 75 E8 0F B7 03 50 6A 05 51 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 5D F0 83 C4 18 85 DB 7E 43 3B 7D E4 74 16 8B 45 10 3B C3 72 3A 53 8D 4D F4 51 50 57 E8 ?? ?? ?? ?? 83 C4 10 03 FB 80 7F FF 00 74 15 8B 4D 10 03 F3 83 45 EC 02 2B CB 8B 5D EC 89 4D 10 75 94 EB 0E 8B 45 E0 4E 83 20 00 03 F3 EB 0B 83 CE FF 8B 5D EC 8B 45 E0 89 18 80 7D DC 00 74 0A 8B 4D D0 83 A1 50 03 00 00 FD 8B C6 5E 5B 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_6_0 {
	meta:
		name = "_memcpy_s"
		size = 129
		refs = "0019 __errno 0023 __invalid_parameter_noinfo 003c _memcpy 004e _memset"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 14 85 F6 75 04 33 C0 EB 6D 8B 45 08 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 53 57 8B 7D 10 85 FF 74 14 39 75 0C 72 0F 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 EB 36 FF 75 0C 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 75 09 E8 ?? ?? ?? ?? 6A 16 EB 0C 39 75 0C 73 13 E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 03 6A 16 58 5F 5E 5D C3 }
	condition:
		$1
}

rule file_0_7_0 {
	meta:
		name = "_wcrtomb"
		size = 49
		refs = "0023 _wcrtomb_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF FF 75 10 8B 45 08 FF 75 0C F7 D8 1B C0 83 E0 05 50 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_8_0 {
	meta:
		name = "_wcrtomb_s"
		size = 121
		refs = "0009 ___security_cookie 0026 __errno 0030 __invalid_parameter_noinfo 0056 ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 0071 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 8B 4D 18 56 8B 75 08 85 C0 75 18 39 45 10 74 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 32 83 4D F0 FF 6A 00 51 FF 75 14 85 C0 75 07 6A 05 8D 45 F4 EB 03 FF 75 10 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 18 8B C8 85 F6 74 05 8B 45 F0 89 06 8B C1 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_10_0 {
	meta:
		name = "_wcsrtombs_s"
		size = 151
		refs = "0027 __errno 0031 __invalid_parameter_noinfo 0054 _internal_wcsrtombs"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 08 56 57 85 DB 74 03 83 0B FF 8B 75 0C 8B 7D 10 85 F6 75 06 85 FF 74 1C EB 04 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 59 C6 06 00 83 7D 14 00 74 E4 8B 45 18 3B C7 76 02 8B C7 FF 75 1C 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 10 85 F6 74 03 C6 06 00 E8 ?? ?? ?? ?? 8B 00 EB 22 40 85 F6 74 15 3B C7 76 0C C6 06 00 E8 ?? ?? ?? ?? 6A 22 EB A8 C6 44 30 FF 00 85 DB 74 02 89 03 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_0_11_0 {
	meta:
		name = "_wctob"
		size = 91
		refs = "0009 ___security_cookie 0033 ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 0053 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC B8 FF FF 00 00 66 39 45 08 74 2D 83 4D F0 FF 8D 45 F4 6A 00 6A 00 FF 75 08 6A 05 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 0C 83 7D F0 01 75 06 0F BE 45 F4 EB 03 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_222_0_4 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_682_0_4 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_405_0_3 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_272_0_2 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_202_0_3 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_1_4 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_682_1_4 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_1_2 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_1_4 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_1_3 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_1_4 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_1_2 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "__CIsin_default"
		size = 167
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 007f __indefinite 00a1 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 49 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FE 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FE EB CD A9 FF FF 0F 00 75 31 83 7C 24 08 00 75 2A DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_acoshl"
		size = 171
		refs = "000c __ldtest 0044 __fperrraise 004a __LNan_C 0064 __real@4000000000000000 006a __LEps_C 0085 __CIsqrt 0092 _log1pl 009d __CIlog 00a3 __real@3fe62e42fefa39ef"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 01 74 0D 83 E8 01 75 13 DD 45 08 E9 83 00 00 00 B8 00 80 00 00 66 85 45 0E EB EB D9 E8 DD 45 08 D8 D1 DF E0 F6 C4 05 7A 14 DD D8 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 56 DD E1 DF E0 F6 C4 44 7A 08 DD D8 DD D8 D9 EE EB 45 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 23 D9 C0 D8 E2 DD 55 F8 D9 C9 DE C2 DE C9 E8 ?? ?? ?? ?? DC 45 F8 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 EB 0D DD D9 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "_acosh"
		size = 171
		refs = "000c __dtest 0044 __fperrraise 004a __Nan_C 0064 __real@4000000000000000 006a __Eps_C 0085 __CIsqrt 0092 _log1p 009d __CIlog 00a3 __real@3fe62e42fefa39ef"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 01 74 0D 83 E8 01 75 13 DD 45 08 E9 83 00 00 00 B8 00 80 00 00 66 85 45 0E EB EB D9 E8 DD 45 08 D8 D1 DF E0 F6 C4 05 7A 14 DD D8 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 56 DD E1 DF E0 F6 C4 44 7A 08 DD D8 DD D8 D9 EE EB 45 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 23 D9 C0 D8 E2 DD 55 F8 D9 C9 DE C2 DE C9 E8 ?? ?? ?? ?? DC 45 F8 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 EB 0D DD D9 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_bp8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 B4 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "_bp32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 B4 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_2_0 {
	meta:
		name = "_si0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A0 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_3_0 {
	meta:
		name = "_si8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A0 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_4_0 {
	meta:
		name = "_si32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 A0 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_5_0 {
	meta:
		name = "_di0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 9C 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_6_0 {
	meta:
		name = "_di8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 9C 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_7_0 {
	meta:
		name = "_di32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 9C 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_9_0 {
	meta:
		name = "_ax0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 B0 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_10_0 {
	meta:
		name = "_ax8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 B0 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_11_0 {
	meta:
		name = "_ax32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 B0 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_12_0 {
	meta:
		name = "_cx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 AC 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_13_0 {
	meta:
		name = "_cx8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 AC 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_14_0 {
	meta:
		name = "_cx32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 AC 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_15_0 {
	meta:
		name = "_dx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A8 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_16_0 {
	meta:
		name = "_dx8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A8 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_17_0 {
	meta:
		name = "_dx32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 A8 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_18_0 {
	meta:
		name = "_bx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A4 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_19_0 {
	meta:
		name = "_bx8"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A4 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_3_20_0 {
	meta:
		name = "_bx32"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 04 8B 88 A4 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_21_0 {
	meta:
		name = "_sib0"
		size = 332
		refs = "0033 $LN32 00b0 $LN33 010c $LN8 0110 $LN9 0114 $LN10 0118 $LN11 011c $LN12 0120 $LN13 0124 $LN14 0128 $LN15 012c $LN20 0130 $LN21 0134 $LN22 0138 $LN23 013c $LN24 0140 $LN25 0144 $LN26 0148 $LN27"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 53 8B 5D 10 56 57 33 FF 0F B6 33 47 8B CE C1 E9 06 D3 E7 8B CE C1 E9 03 83 E1 07 83 F9 04 74 4F 83 E1 07 83 F9 07 77 47 FF 24 8D ?? ?? ?? ?? 8B 90 B0 00 00 00 EB 3A 8B 90 AC 00 00 00 EB 32 8B 90 A8 00 00 00 EB 2A 8B 90 A4 00 00 00 EB 22 8B 90 C4 00 00 00 EB 1A 8B 90 B4 00 00 00 EB 12 8B 90 A0 00 00 00 EB 0A 8B 90 9C 00 00 00 EB 02 33 D2 83 E6 07 83 FE 05 75 0F 8B 45 08 0F AF D7 56 03 53 01 89 10 58 EB 77 83 FE 04 75 10 0F AF D7 03 90 C4 00 00 00 8B 45 08 89 10 EB 5F 83 E6 07 83 FE 07 77 4C FF 24 B5 ?? ?? ?? ?? 8B 80 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 80 AC 00 00 00 EB F1 8B 80 A8 00 00 00 EB E9 8B 80 A4 00 00 00 EB E1 8B 80 C4 00 00 00 EB D9 8B 80 B4 00 00 00 EB D1 8B 80 A0 00 00 00 EB C9 8B 80 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF D7 01 11 33 C0 40 5F 5E 5B 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_22_0 {
	meta:
		name = "_sib8"
		size = 324
		refs = "0033 $LN31 009f $LN32 0104 $LN8 0108 $LN9 010c $LN10 0110 $LN11 0114 $LN12 0118 $LN13 011c $LN14 0120 $LN15 0124 $LN19 0128 $LN20 012c $LN21 0130 $LN22 0134 $LN23 0138 $LN24 013c $LN25 0140 $LN26"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 7D 10 33 F6 6A 07 46 5B 0F B6 07 8B D0 8B C8 C1 E9 06 C1 EA 03 D3 E6 23 D3 8B 4D 0C 83 FA 04 74 4D 23 D3 3B D3 77 47 FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 EB 3A 8B 91 AC 00 00 00 EB 32 8B 91 A8 00 00 00 EB 2A 8B 91 A4 00 00 00 EB 22 8B 91 C4 00 00 00 EB 1A 8B 91 B4 00 00 00 EB 12 8B 91 A0 00 00 00 EB 0A 8B 91 9C 00 00 00 EB 02 33 D2 23 C3 83 F8 04 75 16 0F B6 47 01 0F AF D6 03 D0 8B 45 08 03 91 C4 00 00 00 89 10 EB 63 23 C3 3B C3 77 4C FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 81 AC 00 00 00 EB F1 8B 81 A8 00 00 00 EB E9 8B 81 A4 00 00 00 EB E1 8B 81 C4 00 00 00 EB D9 8B 81 B4 00 00 00 EB D1 8B 81 A0 00 00 00 EB C9 8B 81 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F B6 47 01 0F AF D6 03 D0 01 11 6A 02 58 5F 5E 5B 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_23_0 {
	meta:
		name = "_sib32"
		size = 320
		refs = "0033 $LN31 009f $LN32 0100 $LN8 0104 $LN9 0108 $LN10 010c $LN11 0110 $LN12 0114 $LN13 0118 $LN14 011c $LN15 0120 $LN19 0124 $LN20 0128 $LN21 012c $LN22 0130 $LN23 0134 $LN24 0138 $LN25 013c $LN26"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 53 8B 5D 10 56 57 33 FF 0F B6 33 47 8B CE C1 E9 06 D3 E7 8B CE C1 E9 03 83 E1 07 83 F9 04 74 4F 83 E1 07 83 F9 07 77 47 FF 24 8D ?? ?? ?? ?? 8B 90 B0 00 00 00 EB 3A 8B 90 AC 00 00 00 EB 32 8B 90 A8 00 00 00 EB 2A 8B 90 A4 00 00 00 EB 22 8B 90 C4 00 00 00 EB 1A 8B 90 B4 00 00 00 EB 12 8B 90 A0 00 00 00 EB 0A 8B 90 9C 00 00 00 EB 02 33 D2 83 E6 07 83 FE 04 75 13 0F AF D7 03 90 C4 00 00 00 8B 45 08 03 53 01 89 10 EB 62 83 E6 07 83 FE 07 77 4C FF 24 B5 ?? ?? ?? ?? 8B 80 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 80 AC 00 00 00 EB F1 8B 80 A8 00 00 00 EB E9 8B 80 A4 00 00 00 EB E1 8B 80 C4 00 00 00 EB D9 8B 80 B4 00 00 00 EB D1 8B 80 A0 00 00 00 EB C9 8B 80 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF D7 03 53 01 01 11 6A 05 58 5F 5E 5B 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_24_0 {
	meta:
		name = "_d32"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 04 8B 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_3_25_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 468
		refs = "00d0 $LN61 00d7 $LN71 00f5 $LN62 00fc $LN72 010e $LN63 0115 $LN73 0136 $LN64 013d $LN74 0194 $LN36 0198 $LN35 01b4 $LN49 01b8 $LN48"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 8B 4A 20 8B 41 60 A8 01 0F 84 7B 01 00 00 83 E0 1E 3C 0E 0F 85 70 01 00 00 8B 45 08 53 56 57 83 F8 58 0F 87 11 01 00 00 6A 07 83 CF FF 33 F6 5B 83 F8 57 73 44 83 F8 39 0F 82 48 01 00 00 83 F8 3A 76 08 83 F8 3C E9 F1 00 00 00 8B 41 50 2B C6 0F 84 8D 00 00 00 83 E8 01 74 78 83 E8 01 74 5E 83 E8 01 75 14 83 7A 18 02 76 0B 83 7A 18 06 76 6D 39 5A 18 75 03 89 71 50 8B 4A 20 8B 41 50 2B C6 0F 84 9D 00 00 00 83 E8 01 0F 84 81 00 00 00 83 E8 01 74 63 83 E8 01 0F 85 E8 00 00 00 83 7A 18 02 76 0F 83 7A 18 06 76 72 39 5A 18 0F 85 D3 00 00 00 89 71 50 89 71 54 E9 C8 00 00 00 8B 42 18 3B C3 77 B4 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7A 18 03 76 9D 39 5A 18 77 9B 89 79 50 EB 96 8B 42 18 3B C3 77 8F 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 42 18 3B C3 0F 87 83 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7A 18 03 76 9C 39 5A 18 77 6A 89 79 50 89 79 54 EB 62 8B 42 18 3B C3 77 5B 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 F8 5A 77 48 8B 41 50 83 E8 00 74 32 83 E8 01 74 24 83 E8 01 74 12 83 E8 01 75 31 8B 42 1C 25 6F F7 FF FF 83 C8 45 EB 21 8B 42 1C 25 2B F7 FF FF 83 C8 01 EB 14 81 62 1C 2A F7 FF FF EB 0E 8B 42 1C 25 6A F7 FF FF 83 C8 40 89 42 1C 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_3_26_0 {
	meta:
		name = "_DppxEmulationWrapper"
		size = 437
		refs = "0069 _LoopDppxSimdValue"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 1C 53 56 57 8B 30 33 DB 8B 7D 0C 33 C0 C1 EE 1E 46 89 75 F8 83 7F 28 6D 0F 95 C0 40 89 45 F4 33 C0 89 45 FC 83 7F 28 48 74 16 83 7F 28 6D 75 1E 33 DB 85 C0 0F 94 C3 8D 1C 9D 49 00 00 00 EB 0E 33 DB 85 C0 0F 94 C3 8D 1C 9D 2B 00 00 00 53 50 56 FF 75 18 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 20 8B D1 89 45 F0 8B 45 FC 83 EA 00 74 37 83 EA 01 0F 85 C1 00 00 00 85 C0 0F 85 B9 00 00 00 8B 97 B0 00 00 00 8B B7 B4 00 00 00 8B 87 B8 00 00 00 8B 8F BC 00 00 00 89 57 50 89 77 54 89 47 58 89 4F 5C EB 34 8B D0 83 EA 00 74 47 83 EA 01 0F 85 83 00 00 00 8B B7 B8 00 00 00 8B 97 BC 00 00 00 8B 8F B0 00 00 00 8B 87 B4 00 00 00 89 77 50 89 57 54 89 4F 58 89 47 5C 89 87 80 00 00 00 89 8F 84 00 00 00 89 97 88 00 00 00 89 B7 8C 00 00 00 EB 3C 8B B7 B0 00 00 00 8B 8F B4 00 00 00 8B 97 B8 00 00 00 8B 87 BC 00 00 00 89 77 50 89 4F 54 89 57 58 89 47 5C 89 8F 80 00 00 00 89 B7 84 00 00 00 89 87 88 00 00 00 89 97 8C 00 00 00 8B 4D 08 8B 45 FC 8B 75 F8 40 89 45 FC 3B 45 F4 0F 86 D7 FE FF FF 33 D2 2B CA 74 2C 83 E9 01 75 49 8B CA 85 F6 74 43 81 C7 B0 00 00 00 8B 45 10 8B 40 18 D3 E8 A8 01 75 05 89 17 89 57 04 41 83 C7 08 3B CE 72 E7 EB 22 8B CA 85 F6 74 1C 81 C7 B0 00 00 00 8B 45 10 8B 40 18 D3 E8 A8 01 75 02 89 17 41 83 C7 04 3B CE 72 EA 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_27_0 {
	meta:
		name = "_LoadOperand"
		size = 548
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 14 8B 45 0C 89 02 83 F8 1F 75 06 83 62 20 FE 5D C3 83 F8 15 74 3E 83 F8 14 74 39 83 F8 17 74 34 83 F8 1B 74 2F 80 7D 08 00 74 40 6A 0D 59 83 F8 12 75 02 89 0A 83 F8 13 75 06 C7 02 19 00 00 00 83 F8 0E 75 02 89 0A 83 F8 0C 75 1F C7 02 0B 00 00 00 EB 17 80 7D 08 00 74 0B 83 F8 14 75 06 C7 02 08 00 00 00 8B 45 1C 89 42 04 53 56 8B 75 18 8D 5A 10 57 33 C0 8B FB 81 C6 CC 00 00 00 AB AB AB AB 8B 42 20 8B 0A 83 C8 01 89 42 20 83 F9 13 0F 87 EE 00 00 00 0F 84 E0 00 00 00 83 E9 08 74 5A 83 E9 03 74 42 83 E9 01 74 35 83 E9 01 74 2B 83 E9 01 74 11 83 E9 04 0F 85 5A 01 00 00 83 E0 E1 E9 FB 00 00 00 83 E0 E1 89 42 20 8B 4E 10 8B 01 89 03 8B 41 04 E9 3A 01 00 00 83 E0 E1 EB 0E 83 E0 EB 83 C8 0A EB E1 83 E0 EB 83 C8 0A 89 42 20 8B 46 10 8B 00 E9 BC 00 00 00 83 E0 EB 83 C8 0A 89 42 20 8B 45 10 83 E8 00 74 65 83 E8 01 74 55 83 E8 01 74 45 83 E8 01 74 35 48 83 E8 01 74 24 83 E8 01 74 14 83 E8 01 0F 85 E9 00 00 00 8B 45 18 8B 80 9C 00 00 00 EB 7D 8B 45 18 8B 80 A0 00 00 00 EB 72 8B 45 18 8B 80 B4 00 00 00 EB 67 8B 45 18 8B 80 A4 00 00 00 EB 5C 8B 45 18 8B 80 A8 00 00 00 EB 51 8B 45 18 8B 80 AC 00 00 00 EB 46 8B 45 18 8B 80 B0 00 00 00 EB 3B 83 E0 E3 83 C8 02 EB 3D 83 E9 14 74 72 83 E9 01 74 4C 6A 02 5F 2B CF 74 3E 2B CF 74 30 83 E9 01 74 1D 83 E9 01 75 75 83 E0 EB 83 C8 0A 89 42 20 8B 45 10 83 C0 0A 03 C0 8B 04 C6 89 03 EB 5D 83 E0 EB 83 C8 0A 89 42 20 8B 76 10 EB 2A 83 E0 E3 0B C7 E9 F6 FE FF FF 83 E0 E3 0B C7 EB 03 83 E0 E1 8B 75 10 89 42 20 8B 45 18 05 CC 00 00 00 8D 76 0A C1 E6 04 03 F0 8B FB A5 A5 A5 A5 EB 1D 8B 4D 10 83 E0 EB 83 C8 0A 83 C1 02 03 C9 89 42 20 8B 04 CE 89 03 8B 44 CE 04 89 43 04 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_3_28_0 {
	meta:
		name = "_LoopDppxSimdValue"
		size = 640
		refs = "0009 ___security_cookie 0196 __XMMI_FP_Emulation 019e __XMMI2_FP_Emulation 01f5 ___guard_check_icall_fptr 0278 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 10 33 C9 56 83 C8 FF 89 4D F0 57 8B 7D 0C 89 45 EC 39 4D 1C 0F 86 40 02 00 00 8B 75 14 8D 97 B0 00 00 00 8D 47 08 89 55 F4 89 45 F8 83 7D 20 00 75 3C 8B 43 18 83 C1 04 D3 E8 A8 01 75 30 8B 45 08 33 C9 2B C1 74 0C 83 E8 01 75 10 89 0A 89 4A 04 EB 09 8B 45 F8 89 88 A8 00 00 00 83 8F C0 00 00 00 01 8B 43 1C 89 47 30 E9 CF 01 00 00 83 63 04 00 83 66 04 E0 83 66 08 E0 83 66 0C E0 8B 43 10 33 06 8B 4D 24 83 E0 03 31 06 81 E1 FF 0F 00 00 8B 43 14 8B 16 83 E0 07 C1 E1 03 81 E2 03 00 FE FF 0B C8 8B 46 20 C1 E1 02 0B CA 8B 55 F4 89 0E 33 47 60 83 E0 01 31 46 20 8B 47 60 33 46 20 83 E0 1E 31 46 20 8B 45 08 83 E8 00 74 13 83 E8 01 75 17 8B 42 A0 89 46 10 8B 42 A4 89 46 14 EB 09 8B 45 F8 8B 40 48 89 46 10 8B 87 90 00 00 00 83 E0 01 74 1D 8B 4E 40 83 E1 FE 0B C8 89 4E 40 8B 87 90 00 00 00 33 C1 83 E0 1E 33 C1 89 46 40 EB 04 83 66 40 FE 8B 45 08 8B 4D F8 83 E8 00 74 13 83 E8 01 75 14 8B 42 D0 89 46 30 8B 42 D4 89 46 34 EB 06 8B 41 78 89 46 30 8B 45 08 83 66 60 FE 83 E8 00 74 12 83 E8 01 75 16 8B 02 89 46 50 8B 42 04 89 46 54 EB 09 8B 81 A8 00 00 00 89 46 50 8B 87 C0 00 00 00 33 46 60 83 E0 1E 31 46 60 83 7D 08 01 89 73 20 74 0E 83 7D 08 02 74 08 53 E8 ?? ?? ?? ?? EB 06 53 E8 ?? ?? ?? ?? 8B 55 F8 59 89 02 83 3A 01 8B 43 04 89 42 10 75 55 F6 43 04 20 74 04 83 4F 04 20 F6 43 04 10 74 04 83 4F 04 10 F6 43 04 08 74 04 83 4F 04 08 F6 43 04 04 74 04 83 4F 04 04 F6 43 04 02 74 04 83 4F 04 02 F6 43 04 01 74 04 83 4F 04 01 8B 4D 18 56 FF 15 ?? ?? ?? ?? FF 55 18 89 45 EC 59 83 F8 FF 75 6A 8B 55 F8 8B 8F C0 00 00 00 33 4E 60 83 E1 01 31 8F C0 00 00 00 F6 87 C0 00 00 00 01 8B 4B 1C 89 4F 30 74 26 8B 45 08 83 E8 00 74 15 8B 55 F4 83 E8 01 75 19 8B 46 50 89 02 8B 46 54 89 42 04 EB 0C 8B 46 50 89 82 A8 00 00 00 8B 55 F4 8B 4D F0 83 C2 08 83 45 F8 04 41 89 4D F0 89 55 F4 3B 4D 1C 0F 82 D5 FD FF FF 8B 45 EC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_29_0 {
	meta:
		name = "_SetPniOperation"
		size = 122
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 E8 43 74 49 83 E8 01 74 50 83 E8 01 74 56 83 E8 23 74 24 83 E8 01 74 14 83 E8 01 74 04 32 C0 5D C3 8B 45 0C C7 00 4B 00 00 00 EB 41 8B 45 0C C7 00 49 00 00 00 EB 36 8B 45 0C 33 C9 39 4D 10 0F 94 C1 8D 0C 4D 49 00 00 00 89 08 EB 20 83 7D 10 00 74 11 83 7D 10 02 74 0B 8B 45 0C C7 00 2B 00 00 00 EB 09 8B 45 0C C7 00 2D 00 00 00 B0 01 5D C3 }
	condition:
		$1
}

rule file_3_30_0 {
	meta:
		name = "_UpdateResult"
		size = 316
		refs = "0028 $LN24 002f $LN28 0108 $LN13 010c $LN4 0110 $LN8 0114 $LN7 0118 $LN6 011c $LN12 0120 $LN11 0124 $LN2"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 56 57 8B 7D 0C 8B 02 8B 4A 04 83 C0 F8 8D 9F 6C 01 00 00 83 F8 13 0F 87 DD 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B BF DC 00 00 00 8D 72 10 A5 A5 A5 A5 E9 BD 00 00 00 8B 8F DC 00 00 00 8B 42 10 89 01 8B 42 14 89 41 04 E9 A7 00 00 00 8B 8F DC 00 00 00 8B 42 10 89 01 E9 97 00 00 00 03 C9 8D 3C CB EB C7 8B 42 10 03 C9 89 84 CF EC 00 00 00 8B 42 14 89 84 CF F0 00 00 00 EB 78 83 E9 00 74 61 83 E9 01 74 51 83 E9 01 74 41 83 E9 01 74 31 49 83 E9 01 74 20 83 E9 01 74 10 83 E9 01 75 4B 8B 42 10 89 87 9C 00 00 00 EB 40 8B 42 10 89 87 A0 00 00 00 EB 35 8B 42 10 89 87 B4 00 00 00 EB 2A 8B 42 10 89 87 A4 00 00 00 EB 1F 8B 42 10 89 87 A8 00 00 00 EB 14 8B 42 10 89 87 AC 00 00 00 EB 09 8B 42 10 89 87 B0 00 00 00 8B 45 10 89 87 C0 00 00 00 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 07 02 03 02 03 07 07 07 04 04 05 06 07 06 07 03 04 06 }
	condition:
		$1
}

rule file_3_31_0 {
	meta:
		name = "__fpieee_flt_simd"
		size = 4641
		refs = "001a __sehtable$__fpieee_flt_simd 001f __except_handler4 0034 ___security_cookie 00c5 ___guard_check_icall_fptr 03ce _InstInfoTableEX 03d8 _InstInfoTableDX 03f3 _InstInfoTableCX 03fa _InstInfoTable7X 0401 _InstInfoTable5X 0459 _InstInfoTable4X 0460 _InstInfoTable0X 0467 _InstInfoTable2X 0562 _InstInfoTableX 069e ___acrt_can_use_xstate_apis 06ab ___acrt_GetEnabledXStateFeatures@0 06d5 ___acrt_GetXStateFeaturesMask@8 06f1 ___acrt_LocateXStateFeature@12 077c _modrm32 08d2 _LoadOperand 0af2 _SetPniOperation 0b54 $LN252 0b5b $LN307 0ca6 $LN253 0cad $LN308 0dcc $LN254 0dd3 $LN309 0e1c __XMMI_FP_Emulation 0e46 __XMMI2_FP_Emulation 0efd _AdjustExceptionResult 0fdd _DppxEmulationWrapper 0fff _UpdateResult 11d0 @__security_check_cookie@4 11dc $LN166 11e0 $LN168 11e4 $LN167 11f4 $LN183 11f8 $LN185 11fc $LN184 120c $LN189 1210 $LN186 1214 $LN187"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 51 53 81 EC A8 02 00 00 A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 DC 56 57 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 53 0C 8B 7B 10 89 BD 8C FD FF FF 83 A5 AC FD FF FF 00 83 C8 FF 89 85 A8 FD FF FF 32 C9 88 8D FB FD FF FF 88 8D 0D FE FF FF 32 C0 89 85 E4 FD FF FF 88 85 F9 FD FF FF 33 C0 8B C8 89 8D 94 FD FF FF 89 85 E8 FD FF FF 8B F0 89 B5 FC FD FF FF 89 85 C0 FD FF FF 89 85 A0 FD FF FF 89 85 F0 FD FF FF 89 85 DC FD FF FF 8B 02 39 48 14 74 13 FF 70 14 8B CF FF 15 ?? ?? ?? ?? FF D7 59 E9 EC 10 00 00 8B 7A 04 89 BD EC FD FF FF 8B 07 BA 20 00 01 00 23 C2 3B C2 0F 85 D0 10 00 00 33 C0 89 85 00 FE FF FF 88 85 0F FE FF FF 89 45 FC B2 01 88 95 FA FD FF FF 88 85 07 FE FF FF 88 85 0B FE FF FF 88 85 0C FE FF FF 8B BF B8 00 00 00 89 BD F4 FD FF FF 84 D2 0F 84 C5 01 00 00 8A 07 88 85 FB FD FF FF 47 89 BD F4 FD FF FF 0F B6 C0 83 F8 67 7F 49 74 37 83 F8 26 74 32 83 F8 2E 74 2D 83 F8 36 74 28 83 F8 3E 74 23 83 F8 63 0F 8E 82 01 00 00 83 F8 65 7E 15 83 F8 66 0F 85 74 01 00 00 C7 85 00 FE FF FF 01 00 00 00 EB 3B B0 01 88 85 0F FE FF FF 88 85 0E FE FF FF EB 98 2D C4 00 00 00 0F 84 A4 00 00 00 83 E8 01 74 2F 83 E8 2B 74 DB 48 83 E8 01 74 1B 83 E8 01 0F 85 34 01 00 00 C6 85 07 FE FF FF 01 FF 85 FC FD FF FF E9 62 FF FF FF C6 85 07 FE FF FF 01 EB A5 33 D2 42 88 95 0C FE FF FF 8A 0F 47 89 BD F4 FD FF FF 8A C1 24 03 3A C2 75 06 89 95 00 FE FF FF 3C 02 75 06 88 95 07 FE FF FF 3C 03 75 0C 88 95 07 FE FF FF 89 95 00 FE FF FF 0F B6 C9 8B C1 C1 E8 02 23 C2 89 85 E4 FD FF FF 88 85 F9 FD FF FF F7 D1 C1 F9 03 83 E1 0F 89 8D 94 FD FF FF C6 85 0D FE FF FF 0F FF 85 FC FD FF FF E9 A9 00 00 00 C6 85 0B FE FF FF 01 8A 17 47 89 BD F4 FD FF FF 8A 0F 47 89 BD F4 FD FF FF 8A C1 24 03 3C 01 75 0A C7 85 00 FE FF FF 01 00 00 00 3C 02 75 07 C6 85 07 FE FF FF 01 3C 03 75 11 C6 85 07 FE FF FF 01 C7 85 00 FE FF FF 01 00 00 00 0F B6 C9 8B C1 C1 E8 02 83 E0 01 89 85 E4 FD FF FF 88 85 F9 FD FF FF F7 D1 C1 F9 03 83 E1 0F 89 8D 94 FD FF FF 0F B6 C2 83 E0 0F 83 E8 01 74 20 83 E8 01 74 12 83 E8 01 0F 85 F2 0E 00 00 C6 85 0D FE FF FF 3A EB 10 C6 85 0D FE FF FF 38 EB 07 C6 85 0D FE FF FF 0F 83 85 FC FD FF FF 02 32 D2 88 95 FA FD FF FF E9 33 FE FF FF C7 45 FC FE FF FF FF 80 BD 0F FE FF FF 00 0F 85 B8 0E 00 00 C7 45 FC 01 00 00 00 89 BD A4 FD FF FF 8B 07 89 85 B8 FD FF FF 8B D0 83 E2 0F 89 95 90 FD FF FF C1 E8 04 83 E0 0F 89 85 88 FD FF FF 80 BD 0C FE FF FF 00 75 3D 80 BD 0B FE FF FF 00 75 34 8B 8D B8 FD FF FF C1 E9 0B 83 E1 07 89 8D B8 FD FF FF 89 8D 84 FD FF FF 80 BD FB FD FF FF 0F 74 41 B0 01 88 85 0F FE FF FF 88 85 0E FE FF FF E9 5C 04 00 00 80 BD 0D FE FF FF 0F 74 19 6A 03 58 89 85 88 FD FF FF 0F B6 95 0D FE FF FF 83 E2 0F 89 95 90 FD FF FF 89 8D B8 FD FF FF 89 8D 84 FD FF FF 48 83 E8 01 0F 84 B9 00 00 00 83 E8 01 74 55 48 83 E8 01 74 48 48 83 E8 01 74 3B 83 E8 05 74 2F 83 E8 01 74 0F 83 E8 01 75 95 B9 ?? ?? ?? ?? E9 94 00 00 00 B9 ?? ?? ?? ?? 80 BD 07 FE FF FF 00 0F 84 82 00 00 00 83 A5 00 FE FF FF 00 EB 79 B9 ?? ?? ?? ?? EB 72 B9 ?? ?? ?? ?? EB DC B9 ?? ?? ?? ?? EB 64 83 FA 0A 0F 85 52 FF FF FF 33 F6 46 8A 85 0B FE FF FF 0A 85 0C FE FF FF 75 0D 47 89 BD F4 FD FF FF FF 85 FC FD FF FF 89 BD A4 FD FF FF 8B 07 8B D0 83 E2 0F 89 95 90 FD FF FF C1 E8 04 83 E0 0F 89 85 88 FD FF FF 74 10 83 F8 04 0F 85 0A FF FF FF B9 ?? ?? ?? ?? EB 0C B9 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? 8B 07 25 00 C0 00 00 3D 00 C0 00 00 0F 95 C0 88 85 E3 FD FF FF 0F B6 C0 C1 E0 04 0B C2 83 F8 20 0F 87 D1 FE FF FF 83 FE 01 0F 85 81 00 00 00 8D 0C 81 89 8D E8 FD FF FF 89 8D 9C FD FF FF 8B 01 BA FF 0F 00 00 23 C2 83 F8 6B 74 26 83 F8 6C 74 21 83 F8 6D 74 1C 83 F8 46 74 0E 83 F8 47 74 09 83 F8 48 0F 85 8E FE FF FF 83 A5 00 FE FF FF 00 EB 0A C7 85 00 FE FF FF 01 00 00 00 83 F8 6B 74 26 83 F8 46 74 21 83 F8 6D 74 1C 83 F8 48 74 17 83 F8 6C 74 09 83 F8 47 0F 85 59 FE FF FF C6 85 07 FE FF FF 01 EB 26 C6 85 07 FE FF FF 00 EB 1D 8B 95 00 FE FF FF 8D 04 42 8D 0C 81 89 8D E8 FD FF FF 89 8D 9C FD FF FF BA FF 0F 00 00 8B 09 85 CA 0F 84 20 FE FF FF 8B C1 25 00 F0 01 00 3D 00 E0 01 00 75 4B C1 E9 11 83 E1 1F 80 BD 07 FE FF FF 00 74 15 8D 0C 8D ?? ?? ?? ?? 89 8D E8 FD FF FF 89 8D 9C FD FF FF EB 13 8D 04 8D ?? ?? ?? ?? 89 85 E8 FD FF FF 89 85 9C FD FF FF 32 C0 88 85 07 FE FF FF C7 85 00 FE FF FF 02 00 00 00 EB 06 8A 85 07 FE FF FF 8B 8D E8 FD FF FF 8B 09 23 CA 83 F9 43 74 0A 83 F9 44 74 05 83 F9 45 75 08 32 C0 88 85 07 FE FF FF 83 F9 68 74 0A 83 F9 69 74 05 83 F9 6A 75 0A C7 85 00 FE FF FF 01 00 00 00 85 F6 75 0D 0F B6 C0 03 C1 89 85 38 FE FF FF EB 06 89 8D 38 FE FF FF 80 BD 0C FE FF FF 00 75 09 80 BD 0B FE FF FF 00 74 57 83 F9 51 77 20 74 3C 83 F9 33 74 37 83 F9 3A 76 46 83 F9 3C 76 2D 83 F9 40 74 28 83 F9 42 74 23 83 F9 46 EB 1C 83 F9 59 72 2D 83 F9 5F 76 14 83 F9 61 74 0F 83 F9 62 76 1E 83 F9 67 76 05 83 F9 6B 75 14 8B 07 C1 E8 0B 83 E0 07 89 85 B8 FD FF FF 89 85 84 FD FF FF 8B B5 FC FD FF FF 83 C6 03 89 B5 FC FD FF FF 33 C9 89 8D F0 FD FF FF 89 8D 5C FD FF FF 8B 85 E4 FD FF FF 8B 8D EC FD FF FF 84 C0 0F 84 9B 00 00 00 8B 01 BA 40 00 01 00 23 C2 3B C2 0F 85 8A 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 0A 0B 00 00 E8 ?? ?? ?? ?? 89 85 48 FD FF FF 89 95 4C FD FF FF 83 E0 04 83 C8 00 0F 84 ED 0A 00 00 8D 85 48 FD FF FF 50 FF B5 EC FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 D3 0A 00 00 8D 85 44 FD FF FF 50 6A 01 FF B5 EC FD FF FF E8 ?? ?? ?? ?? 89 85 DC FD FF FF 89 85 58 FD FF FF 6A 00 6A 02 FF B5 EC FD FF FF E8 ?? ?? ?? ?? 89 85 F0 FD FF FF 89 85 5C FD FF FF 6A 02 58 8B 8D EC FD FF FF EB 15 8D 81 6C 01 00 00 89 85 DC FD FF FF 89 85 58 FD FF FF 33 C0 40 89 85 54 FD FF FF 89 85 A0 FD FF FF 80 BD E3 FD FF FF 00 74 46 89 BD F4 FD FF FF 47 89 BD F4 FD FF FF 8A 07 88 85 FB FD FF FF 47 89 BD F4 FD FF FF 0F B6 F0 57 51 8D 85 AC FD FF FF 50 8B 34 B5 ?? ?? ?? ?? 8B CE FF 15 ?? ?? ?? ?? FF D6 83 C4 0C 8B C8 8B B5 FC FD FF FF EB 06 8B 8D C0 FD FF FF 03 F1 89 B5 FC FD FF FF 8B 85 E8 FD FF FF 8B 00 25 00 00 C0 01 3D 00 00 40 00 75 18 03 F9 89 BD F4 FD FF FF 0F B6 07 89 85 3C FE FF FF 46 89 B5 FC FD FF FF C7 45 FC FE FF FF FF 33 C9 89 8D 98 FD FF FF 8B 85 A0 FD FF FF 85 C0 0F 8E CF 08 00 00 6A 08 58 89 85 E4 FD FF FF 8B BD EC FD FF FF 85 C9 0F 84 9B 00 00 00 8B 95 F0 FD FF FF 89 95 BC FD FF FF 8B BD DC FD FF FF 8D 4F 08 2B D7 89 95 B4 FD FF FF 8D B5 50 FF FF FF 2B F7 8D BD 50 FF FF FF 2B BD F0 FD FF FF 89 85 C0 FD FF FF 8B 41 F8 8B 95 BC FD FF FF 89 04 17 8B 41 FC 89 44 17 04 8B 01 89 04 0E 8B 41 04 89 44 0E 04 8B C2 8B 00 89 41 F8 8B C2 8B 40 04 89 41 FC 8B 95 B4 FD FF FF 8B 04 0A 89 01 8B 44 0A 04 89 41 04 83 85 BC FD FF FF 10 8D 49 10 83 AD C0 FD FF FF 01 75 AD 8B 85 AC FD FF FF 83 C0 10 8B BD EC FD FF FF EB 06 8B 85 AC FD FF FF 89 87 DC 00 00 00 8B B5 B8 FD FF FF 56 57 8D 85 50 FE FF FF 50 56 8B 85 E8 FD FF FF 8B 00 C1 E8 0C 83 E0 1F 50 FF B5 07 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 8B 85 E8 FD FF FF 8B 08 8B C1 25 00 F0 01 00 C1 E9 11 83 E1 1F 3D 00 F0 01 00 8B 85 A4 FD FF FF 8B 00 75 28 C1 E8 08 83 E0 07 50 57 8D 95 50 FE FF FF 52 50 51 FF B5 07 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 83 A5 A0 FE FF FF FE EB 1F C1 E8 08 83 E0 07 50 57 8D 95 80 FE FF FF 52 50 51 FF B5 07 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 8B 85 A4 FD FF FF 8B 00 C1 E8 0B 83 E0 07 50 57 8D 85 B0 FE FF FF 50 56 8B B5 E8 FD FF FF 8B 06 C1 E8 19 83 E0 1F 50 FF B5 07 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 80 BD 0F FE FF FF 00 0F 85 35 08 00 00 0F B7 87 CC 00 00 00 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0D 3B C1 75 1F 83 A5 74 FD FF FF 00 EB 16 C7 85 74 FD FF FF 01 00 00 00 EB 0A C7 85 74 FD FF FF 02 00 00 00 8B 87 E4 00 00 00 8B C8 C1 E9 0D 83 E1 03 83 E9 00 74 33 83 E9 01 74 22 83 E9 01 74 11 83 E9 01 75 2B C7 85 70 FD FF FF 03 00 00 00 EB 1F C7 85 70 FD FF FF 02 00 00 00 EB 13 C7 85 70 FD FF FF 01 00 00 00 EB 07 83 A5 70 FD FF FF 00 8B C8 C1 E9 07 83 E1 3F 89 8D 60 FD FF FF 8B C8 C1 E9 0F 83 E1 01 89 8D 68 FD FF FF 8B C8 C1 E9 06 83 E1 01 89 8D 6C FD FF FF 8B 8F C0 00 00 00 89 8D 7C FD FF FF 8B 8D 3C FE FF FF 89 8D 78 FD FF FF 83 E0 3F 89 85 10 FE FF FF 83 A5 14 FE FF FF 00 8B 06 C1 E8 1E 40 89 85 B4 FD FF FF 80 BD 07 FE FF FF 00 74 09 33 C0 40 89 85 B4 FD FF FF 8B BD 38 FE FF FF 83 FF 48 0F 84 2E 05 00 00 83 FF 6D 0F 84 25 05 00 00 33 F6 85 C0 0F 84 4B 05 00 00 8B 8D 40 FF FF FF 89 8D C0 FD FF FF 83 A5 64 FD FF FF 00 6A E0 59 21 8D E4 FE FF FF 21 8D E8 FE FF FF 21 8D EC FE FF FF 8B 95 74 FD FF FF 83 E2 07 C1 E2 02 8B 85 E0 FE FF FF 23 C1 0B D0 8B 85 70 FD FF FF 83 E0 03 0B D0 56 8D 85 B0 FD FF FF 50 57 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 8B 85 B0 FD FF FF 75 02 8B C7 C1 E0 05 33 C2 25 E0 FF 01 00 33 D0 89 95 E0 FE FF FF 8B 95 70 FE FF FF 83 E2 1F 8B 8D 00 FF FF FF 83 E1 E0 0B CA 89 8D 00 FF FF FF 8B 85 00 FE FF FF 83 E8 00 0F 84 BF 00 00 00 83 E8 01 74 64 8D 47 A1 83 F8 08 0F 87 0B 01 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF 83 A5 F4 FE FF FF 00 E9 E4 00 00 00 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF E9 D2 00 00 00 8B 84 F5 60 FE FF FF 89 85 F0 FE FF FF 8B 84 F5 64 FE FF FF 89 85 F4 FE FF FF E9 B3 00 00 00 8B 84 F5 60 FE FF FF 89 85 F0 FE FF FF 8B 84 F5 64 FE FF FF 89 85 F4 FE FF FF 83 FF 69 74 09 83 FF 6A 0F 85 8B 00 00 00 83 FE 01 0F 85 82 00 00 00 8B 85 90 FE FF FF 89 85 F0 FE FF FF 8B 85 94 FE FF FF 89 85 F4 FE FF FF 8B C1 33 85 A0 FE FF FF 83 E0 1F EB 55 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF 83 FF 44 74 05 83 FF 45 75 46 8B C6 83 E8 01 74 20 83 E8 01 74 13 83 E8 01 75 35 8B 85 98 FE FF FF 89 85 F0 FE FF FF EB BD 8B 85 90 FE FF FF EB F0 8B 85 68 FE FF FF 89 85 F0 FE FF FF 8B C1 33 85 70 FE FF FF 83 E0 1E 33 C8 89 8D 00 FF FF FF 8B 8D 20 FF FF FF F6 85 A0 FE FF FF 01 74 0F 8B C1 33 85 A0 FE FF FF 83 E0 1F 33 C8 EB 03 83 E1 FE 89 8D 20 FF FF FF 8B 85 00 FE FF FF 83 E8 00 0F 84 AC 00 00 00 83 E8 01 74 58 8D 47 A1 83 F8 08 0F 87 03 01 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 84 B5 90 FE FF FF 83 A5 14 FF FF FF 00 E9 DC 00 00 00 8B 84 B5 90 FE FF FF E9 D0 00 00 00 8B 84 F5 90 FE FF FF 89 85 10 FF FF FF 8B 84 F5 94 FE FF FF 89 85 14 FF FF FF E9 B7 00 00 00 8B 84 F5 90 FE FF FF 89 85 10 FF FF FF 8B 84 F5 94 FE FF FF 89 85 14 FF FF FF 83 FF 69 74 09 83 FF 6A 0F 85 8F 00 00 00 85 F6 0F 85 87 00 00 00 8B 85 68 FE FF FF 89 85 10 FF FF FF 8B 85 6C FE FF FF 89 85 14 FF FF FF 83 E1 E0 0B CA EB 41 8B 84 B5 90 FE FF FF 89 85 10 FF FF FF 83 FF 44 74 05 83 FF 45 75 51 8B C6 83 E8 00 74 33 83 E8 01 74 26 83 E8 01 75 40 8B 85 94 FE FF FF 89 85 10 FF FF FF 8B C1 33 85 A0 FE FF FF 83 E0 1F 33 C8 89 8D 20 FF FF FF EB 1F 8B 85 6C FE FF FF EB 06 8B 85 64 FE FF FF 83 E1 E0 0B CA 89 8D 20 FF FF FF 89 85 10 FF FF FF 8B 8D C0 FD FF FF 83 E1 FE 8B 95 00 FE FF FF 8B C2 83 E8 00 74 22 83 E8 01 74 61 83 C7 A1 83 FF 08 77 22 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 A5 34 FF FF FF 00 8B 84 B5 C0 FE FF FF 89 85 30 FF FF FF 8B 85 D0 FE FF FF 33 C1 83 E0 1E 33 C8 89 8D 40 FF FF FF 8D 85 E0 FE FF FF 89 85 80 FD FF FF 83 FA 01 74 2F 83 FA 02 74 2A 8D 85 60 FD FF FF 50 E8 ?? ?? ?? ?? EB 28 8B 84 F5 C0 FE FF FF 89 85 30 FF FF FF 8B 84 F5 C4 FE FF FF 89 85 34 FF FF FF EB AD 8D 85 60 FD FF FF 50 E8 ?? ?? ?? ?? 89 84 B5 18 FE FF FF 59 8B 8D 64 FD FF FF 89 8C B5 28 FE FF FF 83 BC B5 18 FE FF FF 01 0F 85 98 00 00 00 8B 85 14 FE FF FF F6 C1 20 74 09 83 C8 20 89 85 14 FE FF FF F6 C1 10 74 09 83 C8 10 89 85 14 FE FF FF F6 C1 08 74 09 83 C8 08 89 85 14 FE FF FF F6 C1 04 74 09 83 C8 04 89 85 14 FE FF FF F6 C1 02 74 09 83 C8 02 89 85 14 FE FF FF F6 C1 01 74 09 83 C8 01 89 85 14 FE FF FF 8D 85 E0 FE FF FF 50 8B BD 8C FD FF FF 8B CF FF 15 ?? ?? ?? ?? FF D7 59 89 85 A8 FD FF FF 83 F8 FF 0F 85 3B 01 00 00 8D 85 60 FD FF FF 50 8B BD 38 FE FF FF 57 E8 ?? ?? ?? ?? 59 59 EB 06 8B BD 38 FE FF FF 8B 85 D0 FE FF FF 8B 8D 40 FF FF FF 89 8D C0 FD FF FF 33 C1 83 E0 01 8B 8D D0 FE FF FF 33 C8 89 8D D0 FE FF FF 8B 85 7C FD FF FF 89 85 40 FE FF FF F6 C1 01 74 6A 8B 85 00 FE FF FF 83 E8 00 74 4C 83 E8 01 74 14 83 FF 5F 72 55 83 FF 60 76 26 83 FF 65 76 38 83 FF 67 77 46 8B 85 30 FF FF FF 89 84 F5 C0 FE FF FF 8B 85 34 FF FF FF 89 84 F5 C4 FE FF FF EB 24 8B 85 30 FF FF FF 89 84 F5 C0 FE FF FF 83 A4 F5 C4 FE FF FF 00 EB 0D 8B 85 30 FF FF FF 89 84 B5 C0 FE FF FF 8B BD 38 FE FF FF 46 3B B5 B4 FD FF FF 0F 82 F3 FA FF FF EB 30 56 FF B5 8C FD FF FF 8D 85 E0 FE FF FF 50 8D 85 60 FD FF FF 50 8D 85 10 FE FF FF 50 FF B5 00 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 89 85 A8 FD FF FF FF B5 40 FE FF FF 8B BD EC FD FF FF 57 8D 85 B0 FE FF FF 50 E8 ?? }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "__strnicmp"
		size = 109
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 0053 ___ascii_strnicmp 0063 __strnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_666_4_0 {
	meta:
		name = "__strncoll"
		size = 109
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 0053 _strncmp 0063 __strncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_246_4_0 {
	meta:
		name = "__wcsncoll"
		size = 109
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 0053 _wcsncmp 0063 __wcsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "__strnicmp_l"
		size = 183
		refs = "001c ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 003b __errno 0046 __invalid_parameter_noinfo 005c ___ascii_strnicmp 0073 __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 00 0F 84 9F 00 00 00 53 56 57 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D 08 BE FF FF FF 7F 85 FF 74 0E 8B 5D 0C 85 DB 74 07 8B 4D 10 3B CE 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 4E 8B 45 F4 83 B8 A8 00 00 00 00 75 0F 51 53 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 33 2B FB 0F B6 04 1F 8D 4D F4 51 50 E8 ?? ?? ?? ?? 8D 4D F4 8B F0 0F B6 03 51 50 E8 ?? ?? ?? ?? 83 C4 10 43 83 6D 10 01 74 08 85 F6 74 04 3B F0 74 D1 2B F0 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__wrmdir"
		size = 40
		refs = "000a __imp__RemoveDirectoryW@4 0014 __imp__GetLastError@0 001a ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_538_0_0 {
	meta:
		name = "__wremove"
		size = 40
		refs = "000a __imp__DeleteFileW@4 0014 __imp__GetLastError@0 001a ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__Cmulcc"
		size = 145
		refs = "0017 _creal 0028 _cimag 0079 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 1C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 1C DD 5D F8 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 8D 45 E0 D9 C0 DD 45 F0 DC C9 D9 C3 DD 45 E8 DC C9 D9 CB DE C1 DD 5C 24 08 D9 CA DE C9 D9 CA DE C9 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__LCmulcc"
		size = 145
		refs = "0017 _creall 0028 _cimagl 0079 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 1C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 1C DD 5D F8 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 8D 45 E0 D9 C0 DD 45 F0 DC C9 D9 C3 DD 45 E8 DC C9 D9 CB DE C1 DD 5C 24 08 D9 CA DE C9 D9 CA DE C9 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__Cmulcr"
		size = 88
		refs = "0017 _cimag 002e _creal 0040 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? DC 4D 1C 8D 75 0C 51 51 8B FC DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? DC 4D 1C 8D 45 F0 83 C4 08 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_305_1_0 {
	meta:
		name = "__LCmulcr"
		size = 88
		refs = "0017 _cimagl 002e _creall 0040 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? DC 4D 1C 8D 75 0C 51 51 8B FC DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? DC 4D 1C 8D 45 F0 83 C4 08 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_cpow"
		size = 271
		refs = "0017 _cimag 003a _creal 009c __CIpow 00aa __Cbuild 00c3 _clog 00e3 __Cmulcc 00f7 _cexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? D9 EE 83 C4 10 DA E9 DF E0 F6 C4 44 0F 8A 85 00 00 00 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? D9 EE 83 C4 10 DE D9 DF E0 F6 C4 41 7A 66 83 EC 10 8D 75 1C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? D9 EE 83 C4 10 DD E1 DF E0 DD D9 F6 C4 44 7A 43 83 EC 18 8D 75 0C 8B FC DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 1C DD 5D F8 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C9 E8 ?? ?? ?? ?? 51 51 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? EB 4B DD D8 83 EC 10 8D 75 0C 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 F0 83 EC 10 A5 A5 A5 A5 8B FC 8D 75 1C 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 14 8B F0 8B FC 8D 45 D0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_memmove_s"
		size = 78
		refs = "0014 __errno 001e __invalid_parameter_noinfo 0042 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 56 85 C0 74 3C 83 7D 08 00 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 25 83 7D 10 00 74 E7 39 45 0C 73 09 E8 ?? ?? ?? ?? 6A 22 EB E0 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__CIexp_pentium4"
		size = 704
		refs = "0026 cv 002e Shifter 00ab ___acrt_exp_tbl_addr 00cf mmask 00db bias 0146 emask 0205 ___libm_error_support 0239 XMAX 024c XMIN 0278 INF 027f ZERO 02a8 ONE_val"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 28 02 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 19 F2 0F 59 C2 83 EC 10 F2 0F 58 C2 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 12 66 0F C5 C8 03 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 73 27 83 F9 00 74 29 EB 5A 81 F9 00 00 00 80 72 18 81 F9 2B 23 86 C0 72 4A 77 15 8B 54 24 04 81 FA EF 39 FA FE 72 3C EB 07 BA 0E 00 00 00 EB 05 BA 0F 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 3D 00 00 F0 7F 73 31 8B 44 24 08 3D 00 00 00 80 73 13 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0E 00 00 00 EB 9C 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0F 00 00 00 EB 89 8B 54 24 04 3D 00 00 F0 7F 77 1E 83 FA 00 75 19 8B 44 24 08 3D 00 00 F0 7F 75 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 BA EA 03 00 00 E9 56 FF FF FF 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 73 85 66 0F 12 44 24 04 F2 0F 58 05 ?? ?? ?? ?? 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 8D 49 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "_atan2l"
		size = 17
		refs = "000d __CIatan2"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 08 DD 45 10 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_433_3_0 {
	meta:
		name = "_fmodl"
		size = 17
		refs = "000d __CIfmod"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 08 DD 45 10 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_305_3_0 {
	meta:
		name = "_powl"
		size = 17
		refs = "000d __CIpow"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 08 DD 45 10 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "_cargl"
		size = 62
		refs = "0016 _cimagl 0027 _creall 0034 __CIatan2"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 08 DD 5D F8 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C9 E8 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "_carg"
		size = 62
		refs = "0016 _cimag 0027 _creal 0034 __CIatan2"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 08 DD 5D F8 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C9 E8 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z"
		size = 16
		altNames = "??0?$__crt_scoped_stack_ptr@D@@QAE@U?$__crt_scoped_stack_ptr_tag@D@@@Z ??0?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QAE@U?$__crt_scoped_stack_ptr_tag@U_INPUT_RECORD@@@@@Z ??0?$__crt_scoped_stack_ptr_tag@D@@QAE@QAD@Z ??0?$__crt_scoped_stack_ptr_tag@U_INPUT_RECORD@@@@QAE@QAU_INPUT_RECORD@@@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z ??0?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAE@QAX@Z ??0?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@QAX@Z ??0?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAE@QAUHINSTANCE__@@@Z ??0?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAE@QA_W@Z ??0?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QAE@QAUprocess_handle_pair@?A0xe43b7539@@@Z ??0?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QAE@QAU_iobuf@@@Z ??0?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@QBD@Z ??0?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@QB_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@QAE@Z ??0?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAE@QAG@Z ??0?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAE@QAJ@Z ??0?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAE@QAP6AXXZ@Z ??0?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@QAPAD@Z ??0?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@QAPAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@QAPA_W@Z ??0?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAE@QAU__acrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAE@QAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAE@QAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_lc_time_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_locale_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAE@QAU__crt_locale_pointers@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_lowio_handle_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_multibyte_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAE@QAUlconv@@@Z ??0?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAE@QAUprocess_handle_pair@?A0xe43b7539@@@Z ??0?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAE@QAUtm@@@Z ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@QA_W@Z ??0?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@QA_W@Z ??0?$stream_output_adapter@D@__crt_stdio_output@@QAE@QAU_iobuf@@@Z ??0?$stream_output_adapter@_W@__crt_stdio_output@@QAE@QAU_iobuf@@@Z ??0?$string_output_adapter@D@__crt_stdio_output@@QAE@QAU?$string_output_adapter_context@D@1@@Z ??0?$string_output_adapter@_W@__crt_stdio_output@@QAE@QAU?$string_output_adapter_context@_W@1@@Z ??0__crt_stdio_stream@@QAE@QAU__crt_stdio_stream_data@@@Z ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 01 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_10_6_0 {
	meta:
		name = "?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z"
		size = 680
		refs = "0009 ___security_cookie 0037 ___strncnt 00ae __imp__GetCPInfo@8 0131 __imp__MultiByteToWideChar@24 0168 __alloca_probe_16 0189 __malloc_base 0274 ___acrt_CompareStringEx@36 0281 __freea_crt 02a0 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 18 89 45 D8 8B 45 0C 89 45 D4 8B 45 1C 89 45 DC 57 8B 7D 14 89 7D E0 85 F6 7E 22 56 57 E8 ?? ?? ?? ?? 59 8B F0 8B 45 DC 59 8B 5D 20 85 DB 7E 19 53 50 E8 ?? ?? ?? ?? 59 59 8B D8 EB 11 83 FE FF 7D E7 33 C0 E9 32 02 00 00 83 FB FF 7C F4 8B 45 24 85 C0 75 0B 8B 45 D8 8B 00 8B 40 08 89 45 24 85 F6 74 08 85 DB 0F 85 9D 00 00 00 3B F3 75 08 6A 02 58 E9 03 02 00 00 83 FB 01 7E 08 33 C0 40 E9 F6 01 00 00 83 FE 01 7E 04 6A 03 EB E4 8D 4D E8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 A5 85 F6 7E 2F 6A 02 58 39 45 E8 72 E1 80 7D EE 00 8D 4D EE 74 D8 8A 51 01 84 D2 74 D1 8A 1F 3A 19 72 08 3A DA 0F 86 B4 01 00 00 03 C8 80 39 00 75 E4 EB BA 85 DB 7E 35 6A 02 58 39 45 E8 72 A1 80 7D EE 00 8D 4D EE 74 98 8B 75 DC 8A 51 01 84 D2 74 8E 8A 1E 3A 19 72 08 3A DA 0F 86 7E 01 00 00 03 C8 80 39 00 75 E4 E9 74 FF FF FF 33 FF 57 57 56 FF 75 E0 6A 09 FF 75 24 FF 15 ?? ?? ?? ?? 89 45 D8 85 C0 0F 84 1B FF FF FF 8D 14 00 8D 4A 08 3B D1 1B C0 85 C1 74 59 8D 4A 08 3B D1 1B C0 23 C1 8D 4A 08 3D 00 04 00 00 77 20 3B D1 1B C0 23 C1 E8 ?? ?? ?? ?? 8B C4 89 45 E4 85 C0 0F 84 0F 01 00 00 C7 00 CC CC 00 00 EB 1E 3B D1 1B C0 23 C1 50 E8 ?? ?? ?? ?? 89 45 E4 59 85 C0 0F 84 EF 00 00 00 C7 00 DD DD 00 00 83 C0 08 89 45 E4 EB 05 8B C7 89 7D E4 85 C0 0F 84 D4 00 00 00 FF 75 D8 50 56 FF 75 E0 8B 75 24 6A 01 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B8 00 00 00 57 57 53 FF 75 DC 6A 09 56 FF 15 ?? ?? ?? ?? 89 45 E0 85 C0 0F 84 9E 00 00 00 8D 14 00 8D 4A 08 3B D1 1B C0 85 C1 74 4A 8D 4A 08 3B D1 1B C0 23 C1 8D 4A 08 3D 00 04 00 00 77 19 3B D1 1B C0 23 C1 E8 ?? ?? ?? ?? 8B F4 85 F6 74 60 C7 06 CC CC 00 00 EB 19 3B D1 1B C0 23 C1 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 45 C7 06 DD DD 00 00 83 C6 08 EB 02 8B F7 85 F6 74 34 FF 75 E0 56 53 FF 75 DC 6A 01 FF 75 24 FF 15 ?? ?? ?? ?? 85 C0 74 1D 8B 5D E4 57 57 57 FF 75 E0 56 FF 75 D8 53 FF 75 10 FF 75 D4 E8 ?? ?? ?? ?? 8B F8 EB 03 8B 5D E4 56 E8 ?? ?? ?? ?? 59 EB 03 8B 5D E4 53 E8 ?? ?? ?? ?? 59 8B C7 8D 65 C8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_8_0 {
	meta:
		name = "__MallocaComputeSize"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8D 48 08 3B C1 1B C0 23 C1 5D C3 }
	condition:
		$1
}

rule file_10_9_0 {
	meta:
		name = "__MarkAllocaS"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 08 8B 4D 0C 89 08 83 C0 08 5D C3 }
	condition:
		$1
}

rule file_10_10_0 {
	meta:
		name = "___acrt_CompareStringA"
		size = 72
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002d ?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 45 F4 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_12_0 {
	meta:
		name = "__freea_crt"
		size = 32
		refs = "0019 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "??$common_getpath@D@@YAPADQBDQADI@Z"
		size = 167
		refs = "000d __errno"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 85 C0 75 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 5D C3 8B 55 10 85 D2 74 03 C6 00 00 83 FA 01 76 E2 8B 4D 08 53 6A 3B 5B EB 01 41 38 19 74 FB 56 8D 72 FF 57 8B F9 03 F0 EB 33 3A D3 74 49 80 FA 22 75 22 41 8A 11 84 D2 74 3E 80 FA 22 74 0E 88 10 40 41 3B C6 74 1E 8A 11 84 D2 75 ED 80 39 00 74 26 41 EB 08 88 10 40 41 3B C6 74 08 8A 11 84 D2 75 C7 EB 13 C6 00 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 12 41 38 19 74 FB C6 00 00 8B C1 2B C7 F7 D8 1B C0 23 C1 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "??$common_getpath@_W@@YAPA_WQB_WQA_WI@Z"
		size = 224
		refs = "000f __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 A2 00 00 00 8B 55 10 85 D2 74 05 33 C9 66 89 08 83 FA 01 76 DD 8B 4D 08 53 56 6A 02 5B 6A 3B 5E 89 75 F8 EB 02 03 CB 66 39 31 74 F9 4A 57 8B F9 8D 34 50 0F B7 11 66 85 D2 74 51 C7 45 FC 22 00 00 00 66 3B 55 F8 74 75 03 CB 66 3B 55 FC 75 2B 0F B7 11 66 85 D2 74 34 66 3B 55 FC 74 13 66 89 10 03 CB 03 C3 3B C6 74 41 0F B7 11 66 85 D2 75 E7 66 83 39 00 74 15 03 CB EB 09 66 89 10 03 C3 3B C6 74 26 0F B7 11 66 85 D2 75 B6 6A 3B 5A 66 39 11 74 2C 33 D2 66 89 10 8B C1 2B C7 F7 D8 1B C0 23 C1 5F 5E 5B 8B E5 5D C3 33 C9 66 89 08 E8 ?? ?? ?? ?? 8B 4D FC 89 08 33 C0 EB E6 6A 3B 5A 03 CB EB CB }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "??$?R_W@__crt_internal_free_policy@@QBEXQB_W@Z"
		size = 18
		refs = "0009 __free_base"
		altNames = "??$?RD@__crt_internal_free_policy@@QBEXQBD@Z ??$?RE@__crt_internal_free_policy@@QBEXQBE@Z ??$?RG@__crt_internal_free_policy@@QBEXQBG@Z ??$?RJ@__crt_internal_free_policy@@QBEXQBJ@Z ??$?RP6AXXZ@__crt_internal_free_policy@@QBEXQBQ6AXXZ@Z ??$?RPAD@__crt_internal_free_policy@@QBEXQBQAD@Z ??$?RPAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBQAU__crt_stdio_stream_data@@@Z ??$?RPA_W@__crt_internal_free_policy@@QBEXQBQA_W@Z ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__acrt_ptd@@@Z ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QBEXQBU__acrt_thread_parameter@@@Z ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lc_time_data@@@Z ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_data@@@Z ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_pointers@@@Z ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lowio_handle_data@@@Z ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QBEXQBU__crt_multibyte_data@@@Z ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBU__crt_stdio_stream_data@@@Z ??$?RUlconv@@@__crt_internal_free_policy@@QBEXQBUlconv@@@Z ??$?RUprocess_handle_pair@?A0xe43b7539@@@__crt_internal_free_policy@@QBEXQBUprocess_handle_pair@?A0xe43b7539@@@Z ??$?RUtm@@@__crt_internal_free_policy@@QBEXQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QBEXQBD@Z"
		size = 18
		refs = "0009 _free"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_400_3_4 {
	meta:
		name = "??$?R_W@__crt_public_free_policy@@QBEXQB_W@Z"
		size = 18
		refs = "0009 _free"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@XZ"
		size = 18
		refs = "0008 __free_base"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QAE@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QAE@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_117_10_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@XZ"
		size = 18
		refs = "0008 _free"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_117_11_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@XZ"
		size = 18
		refs = "0008 _free"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_117_19_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
		size = 18
		refs = "0008 _free"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_400_71_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEXXZ"
		size = 18
		refs = "0008 _free"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_13_6_0 {
	meta:
		name = "__mkdir"
		size = 77
		refs = "000f __wmkdir 0023 ___acrt_copy_path_to_wide_string 0041 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0A 6A 00 E8 ?? ?? ?? ?? 59 EB 33 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0B FF 75 FC E8 ?? ?? ?? ?? 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_733_6_0 {
	meta:
		name = "__rmdir"
		size = 77
		refs = "000f __wrmdir 0023 ___acrt_copy_path_to_wide_string 0041 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0A 6A 00 E8 ?? ?? ?? ?? 59 EB 33 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0B FF 75 FC E8 ?? ?? ?? ?? 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_7_0 {
	meta:
		name = "_remove"
		size = 77
		refs = "000f __wremove 0023 ___acrt_copy_path_to_wide_string 0041 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0A 6A 00 E8 ?? ?? ?? ?? 59 EB 33 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0B FF 75 FC E8 ?? ?? ?? ?? 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_casinf"
		size = 96
		refs = "000c _crealf 001b _cimagf 0028 __FCbuild 002f _casinhf"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 52 50 89 45 08 89 55 0C E8 ?? ?? ?? ?? 83 C4 14 D9 E0 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_catanf"
		size = 96
		refs = "000c _crealf 001b _cimagf 0028 __FCbuild 002f _catanhf"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 52 50 89 45 08 89 55 0C E8 ?? ?? ?? ?? 83 C4 14 D9 E0 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "_csinf"
		size = 96
		refs = "000c _crealf 001b _cimagf 0028 __FCbuild 002f _csinhf"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 52 50 89 45 08 89 55 0C E8 ?? ?? ?? ?? 83 C4 14 D9 E0 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "_ctanf"
		size = 96
		refs = "000c _crealf 001b _cimagf 0028 __FCbuild 002f _ctanhf"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 52 50 89 45 08 89 55 0C E8 ?? ?? ?? ?? 83 C4 14 D9 E0 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "?__acrt_stdio_reset_buffer@@YAXV__crt_stdio_stream@@@Z"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 48 04 89 08 8B 45 08 83 60 08 00 5D C3 }
	condition:
		$1
}

rule file_15_6_0 {
	meta:
		name = "?has_all_of@__crt_stdio_stream@@QBE_NJ@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8B 01 8B 40 0C 23 45 08 2B 45 08 F7 D8 1B C0 40 5D C2 04 00 }
	condition:
		$1
}

rule file_15_8_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QBE_NJ@Z"
		size = 39
	strings:
		$1 = { 8B FF 55 8B EC 8B 11 56 8B 75 08 83 C2 0C 8B 02 8B C8 0B CE F0 0F B1 0A 75 F6 23 C6 F7 D8 5E 1B C0 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_15_9_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QBE_NJ@Z"
		size = 42
	strings:
		$1 = { 8B FF 55 8B EC 8B 11 56 8B 75 08 83 C2 0C F7 D6 8B 02 8B C8 23 CE F0 0F B1 0A 75 F6 23 45 08 F7 D8 5E 1B C0 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_15_11_0 {
	meta:
		name = "_rewind"
		size = 206
		refs = "0003 __sehtable$_rewind 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 002e __SEH_epilog4 0035 __fileno 003d __lock_file 004a ___acrt_stdio_flush_nolock 007a ___pioinfo 0081 ___badioinfo 00a1 __lseek 00c8 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 89 75 E4 33 C0 85 F6 0F 95 C0 85 C0 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 56 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 59 33 DB 89 5D FC 56 E8 ?? ?? ?? ?? 59 8B 46 04 89 06 89 5E 08 83 C6 0C 6A E7 58 F0 21 06 83 FF FF 74 1B 83 FF FE 74 16 8B CF C1 F9 06 8B C7 83 E0 3F 6B D0 30 03 14 8D ?? ?? ?? ?? EB 05 BA ?? ?? ?? ?? 0F B6 42 28 24 FD 88 42 28 8B 06 C1 E8 02 A8 01 74 06 6A FC 58 F0 21 06 53 53 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 06 6A 10 58 F0 09 06 C7 45 FC FE FF FF FF E8 05 00 00 00 E9 69 FF FF FF FF 75 E4 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "_strncpy"
		size = 292
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 92 00 00 00 56 53 8B D9 8B 74 24 14 F7 C6 03 00 00 00 8B 7C 24 10 75 0B C1 E9 02 0F 85 85 00 00 00 EB 27 8A 06 83 C6 01 88 07 83 C7 01 83 E9 01 74 2B 84 C0 74 2F F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 61 83 E3 03 74 13 8A 06 83 C6 01 88 07 83 C7 01 84 C0 74 37 83 EB 01 75 ED 8B 44 24 10 5B 5E 5F C3 F7 C7 03 00 00 00 74 16 88 07 83 C7 01 83 E9 01 0F 84 98 00 00 00 F7 C7 03 00 00 00 75 EA 8B D9 C1 E9 02 75 74 88 07 83 C7 01 83 EB 01 75 F6 5B 5E 8B 44 24 08 5F C3 89 17 83 C7 04 83 E9 01 74 9F BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 2C 84 F6 74 1E F7 C2 00 00 FF 00 74 0C F7 C2 00 00 00 FF 75 C4 89 17 EB 18 81 E2 FF FF 00 00 89 17 EB 0E 81 E2 FF 00 00 00 89 17 EB 04 33 D2 89 17 83 C7 04 33 C0 83 E9 01 74 0C 33 C0 89 07 83 C7 04 83 E9 01 75 F6 83 E3 03 0F 85 77 FF FF FF 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "___dcrt_lowio_initialize_console_input"
		size = 31
		refs = "000f ??_C@_1O@PNMIMBDD@?$AAC?$AAO?$AAN?$AAI?$AAN?$AA$?$AA?$AA@ 0015 __imp__CreateFileW@28 001a ___dcrt_lowio_console_input_handle"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 C0 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "___dcrt_terminate_console_input"
		size = 23
		refs = "0001 ___dcrt_lowio_console_input_handle 0012 __imp__CloseHandle@4"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 0C 83 F8 FE 74 07 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "___dcrt_terminate_console_output"
		size = 23
		refs = "0001 ___dcrt_lowio_console_output_handle 0012 __imp__CloseHandle@4"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 0C 83 F8 FE 74 07 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_18_5_0 {
	meta:
		name = "_rename"
		size = 196
		refs = "000b ___acrt_AreFileApisANSI@0 0023 __imp__MultiByteToWideChar@24 0032 __imp__GetLastError@0 0038 ___acrt_errno_map_os_error 005b __malloc_base 009e __wrename 00b6 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 E8 ?? ?? ?? ?? F7 D8 1B DB 33 C0 50 50 83 CF FF 43 57 FF 75 08 50 53 FF 15 ?? ?? ?? ?? 8B F0 89 75 FC 85 F6 75 0E FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 7C 33 C0 50 50 57 FF 75 0C 50 53 FF 15 ?? ?? ?? ?? 89 45 F8 85 C0 74 DB 03 C6 03 C0 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 4E 8B 45 FC 50 56 57 FF 75 08 8D 0C 46 6A 00 53 89 4D FC FF 15 ?? ?? ?? ?? 85 C0 74 25 FF 75 F8 FF 75 FC 57 FF 75 0C 6A 00 53 FF 15 ?? ?? ?? ?? 85 C0 74 0E FF 75 FC 56 E8 ?? ?? ?? ?? 59 8B F8 EB 0C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 56 E8 ?? ?? ?? ?? 59 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_fdimf"
		size = 86
		refs = "000c __fdtest"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 56 50 E8 ?? ?? ?? ?? 59 6A 02 5E 66 3B C6 75 05 D9 45 08 EB 33 8D 45 0C 50 E8 ?? ?? ?? ?? 59 66 3B C6 75 05 D9 45 0C EB 1F D9 45 08 D9 45 0C D8 D1 DF E0 F6 C4 01 75 08 DD D9 DD D8 D9 EE EB 08 DE E9 D9 5D FC D9 45 FC 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__getdiskfree"
		size = 196
		refs = "0009 ___security_cookie 001d __errno 0028 __invalid_parameter_noinfo 008e __imp__GetDiskFreeSpaceW@20 0098 __imp__GetLastError@0 00a7 ___acrt_errno_from_os_error 00bc @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 8B 55 08 85 C9 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 57 58 E9 82 00 00 00 83 FA 1A 77 E3 56 57 33 C0 8D 7D EC AB 8D 75 EC 6A 5F AB AB AB 8B F9 58 6A 3A A5 A5 A5 A5 66 89 45 F4 8B F2 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 F7 DE 66 89 45 FA 8D 45 F4 1B F6 23 F0 85 D2 74 07 8D 42 40 66 89 45 F4 51 8D 41 04 50 8D 41 0C 50 8D 41 08 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 1C FF 15 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 89 06 8B C7 59 EB 02 33 C0 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "??$?B$$A6GXPAXK0@Z@__crt_fast_encoded_nullptr_t@@QBEP6GXPAXK0@ZXZ"
		size = 24
		refs = "0001 ___security_cookie"
		altNames = "??$?B$$A6AHI@Z@__crt_fast_encoded_nullptr_t@@QBEP6AHI@ZXZ ??$?B$$A6AXH@Z@__crt_fast_encoded_nullptr_t@@QBEP6AXH@ZXZ ??$?B$$A6AXXZ@__crt_fast_encoded_nullptr_t@@QBEP6AXXZXZ ??$?B$$A6GHPA_WKJ@Z@__crt_fast_encoded_nullptr_t@@QBEP6GHPA_WKJ@ZXZ ??$?BP6AXXZ@__crt_fast_encoded_nullptr_t@@QBEPAP6AXXZXZ ??$?BX@__crt_fast_encoded_nullptr_t@@QBEPAXXZ"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 E0 1F 6A 20 59 2B C8 33 C0 D3 C8 33 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6GXPAXK0@Z@@YAP6GXPAXK0@ZQ6GX0K0@Z@Z"
		size = 22
		refs = "0006 ___security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AHI@Z@@YAP6AHI@ZQ6AHI@Z@Z ??$__crt_fast_decode_pointer@P6AHPAU_exception@@@Z@@YAP6AHPAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_decode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_decode_pointer@P6AXPB_W00II@Z@@YAP6AXPB_W00II@ZQ6AX000II@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@P6GHPA_WKJ@Z@@YAP6GHPA_WKJ@ZQ6GH0KJ@Z@Z ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_decode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC A1 ?? ?? ?? ?? 8B C8 33 45 08 83 E1 1F D3 C8 5D C3 }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6GXPAXK0@Z@@YAP6GXPAXK0@ZQ6GX0K0@Z@Z"
		size = 31
		refs = "0006 ___security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AHI@Z@@YAP6AHI@ZQ6AHI@Z@Z ??$__crt_fast_encode_pointer@P6AHPAU_exception@@@Z@@YAP6AHPAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_encode_pointer@P6AHXZ@@YAP6AHXZQ6AHXZ@Z ??$__crt_fast_encode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_encode_pointer@P6AXPB_W00II@Z@@YAP6AXPB_W00II@ZQ6AX000II@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@P6GHPA_WKJ@Z@@YAP6GHPA_WKJ@ZQ6GH0KJ@Z@Z ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_encode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC A1 ?? ?? ?? ?? 83 E0 1F 6A 20 59 2B C8 8B 45 08 D3 C8 33 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "??$__crt_get_proc_address@P6GXI@Z@@YAP6GXI@ZQAUHINSTANCE__@@QBD@Z"
		size = 19
		refs = "000d __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "__beep"
		size = 19
		refs = "000d __imp__Beep@8"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_21_11_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__FreeLibrary@4"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E 00 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 26 00 5E C3 }
	condition:
		$1
}

rule file_174_5_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E 00 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 26 00 5E C3 }
	condition:
		$1
}

rule file_174_11_0 {
	meta:
		name = "?close@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAEXXZ"
		size = 23
		refs = "000e __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E 00 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 26 00 5E C3 }
	condition:
		$1
}

rule file_21_19_0 {
	meta:
		name = "?atexit_exception_filter@@YAHK@Z"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 81 7D 08 63 73 6D E0 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_21_21_0 {
	meta:
		name = "?close@__crt_hmodule_traits@@SA_NPAUHINSTANCE__@@@Z"
		size = 22
		refs = "000a __imp__FreeLibrary@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_119_59_0 {
	meta:
		name = "?close@__crt_findfile_traits@@SA_NPAX@Z"
		size = 22
		refs = "000a __imp__FindClose@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_553_69_4 {
	meta:
		name = "?close@__crt_handle_traits@@SA_NPAX@Z"
		size = 22
		refs = "000a __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_21_22_0 {
	meta:
		name = "?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
		size = 86
		refs = "000f ?is_managed_app@@YA_NXZ 001b ?try_cor_exit_process@@YAXI@Z 003d ??$__acrt_lock_and_call@V<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@@@YAXW4__acrt_lock_id@@$$QAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@@Z 0051 ?exit_or_terminate_process@@YAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 00 75 12 E8 ?? ?? ?? ?? 84 C0 74 09 FF 75 08 E8 ?? ?? ?? ?? 59 8D 45 0C C6 45 FF 00 89 45 F0 8D 45 10 89 45 F4 8D 45 FF 89 45 F8 8D 45 F0 50 6A 02 E8 ?? ?? ?? ?? 83 7D 10 00 59 59 74 04 8B E5 5D C3 FF 75 08 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_21_23_0 {
	meta:
		name = "?exit_or_terminate_process@@YAXI@Z"
		size = 66
		refs = "0006 ___acrt_get_process_end_policy 0024 __imp__GetCurrentProcess@0 002b __imp__TerminateProcess@8 0033 ?try_cor_exit_process@@YAXI@Z 003d __imp__ExitProcess@4"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 F8 01 74 20 64 A1 30 00 00 00 8B 40 68 C1 E8 08 A8 01 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 FF 75 08 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_21_27_0 {
	meta:
		name = "?is_managed_app@@YA_NXZ"
		size = 68
		refs = "0004 __imp__GetModuleHandleW@4"
	strings:
		$1 = { 6A 00 FF 15 ?? ?? ?? ?? 8B C8 85 C9 75 03 32 C0 C3 B8 4D 5A 00 00 66 39 01 75 F3 8B 41 3C 03 C1 81 38 50 45 00 00 75 E6 B9 0B 01 00 00 66 39 48 18 75 DB 83 78 74 0E 76 D5 83 B8 E8 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_21_28_0 {
	meta:
		name = "?should_call_terminate_process@@YA_NXZ"
		size = 30
		refs = "0001 ___acrt_get_process_end_policy"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 F8 01 75 03 32 C0 C3 64 A1 30 00 00 00 8B 40 68 C1 E8 08 F6 D0 24 01 C3 }
	condition:
		$1
}

rule file_21_29_0 {
	meta:
		name = "?try_cor_exit_process@@YAXI@Z"
		size = 106
		refs = "0008 ___security_cookie 001a ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0022 __imp__GetModuleHandleExW@12 002c ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0035 __imp__GetProcAddress@8 0046 ___guard_check_icall_fptr 0058 __imp__FreeLibrary@4 0062 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 65 F8 00 8D 45 F8 50 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 23 56 68 ?? ?? ?? ?? FF 75 F8 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 0D FF 75 08 8B CE FF 15 ?? ?? ?? ?? FF D6 5E 83 7D F8 00 74 09 FF 75 F8 FF 15 ?? ?? ?? ?? 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_30_0 {
	meta:
		name = "__Exit"
		size = 22
		refs = "000d ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
		altNames = "__exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_21_36_0 {
	meta:
		name = "__register_thread_local_exe_atexit_callback"
		size = 56
		refs = "0006 ___security_cookie 001e ?thread_local_exit_callback_func@@3P6GXPAXK0@ZA 0024 _terminate 002c ??$__crt_fast_encode_pointer@P6GXPAXK0@Z@@YAP6GXPAXK0@ZQ6GX0K0@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC A1 ?? ?? ?? ?? 83 E0 1F 6A 20 59 2B C8 33 C0 D3 C8 33 05 ?? ?? ?? ?? 39 05 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_21_37_0 {
	meta:
		name = "_exit"
		size = 22
		refs = "000d ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_21_38_0 {
	meta:
		name = "_quick_exit"
		size = 22
		refs = "000d ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_wcscspn"
		size = 80
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 08 33 D2 53 56 57 8B C1 66 39 11 74 30 8B 7D 0C 0F B7 1F 8B F7 66 85 DB 74 1B 0F B7 10 89 55 FC 8B D3 66 39 55 FC 74 15 83 C6 02 0F B7 16 66 85 D2 75 EF 33 D2 83 C0 02 66 39 10 75 D6 5F 2B C1 5E D1 F8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "??$assemble_floating_point_ind@M@__crt_strtox@@YAXAAM@Z"
		size = 16
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 C7 00 00 00 C0 FF 5D C3 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "??$assemble_floating_point_ind@N@__crt_strtox@@YAXAAN@Z"
		size = 47
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 81 49 04 00 00 00 80 8B 01 81 49 04 00 00 F0 7F 89 01 8B 41 04 25 00 00 F8 FF 0D 00 00 08 00 83 21 00 89 41 04 5D C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAAM@Z"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 81 C9 00 00 80 7F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z"
		size = 63
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 56 8B 75 0C 0F 95 C0 99 C1 E0 1F 33 D2 8B 4E 04 0B 16 81 E1 FF FF FF 7F 0B C1 89 46 04 8B C2 81 4E 04 00 00 F0 7F 89 06 83 26 00 81 66 04 00 00 F0 FF 5E 5D C3 }
	condition:
		$1
}

rule file_23_5_0 {
	meta:
		name = "??$assemble_floating_point_qnan@M@__crt_strtox@@YAX_NAAM@Z"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 81 C9 FF FF FF 7F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_6_0 {
	meta:
		name = "??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAAN@Z"
		size = 63
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 56 8B 75 0C 0F 95 C0 99 C1 E0 1F 33 D2 8B 4E 04 0B 16 81 E1 FF FF FF 7F 0B C1 89 46 04 8B C2 81 4E 04 00 00 F0 7F 89 06 83 0E FF 81 4E 04 FF FF 0F 00 5E 5D C3 }
	condition:
		$1
}

rule file_23_7_0 {
	meta:
		name = "??$assemble_floating_point_snan@M@__crt_strtox@@YAX_NAAM@Z"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 81 C9 01 00 80 7F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_8_0 {
	meta:
		name = "??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAAN@Z"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 56 8B 75 0C 0F 95 C0 99 C1 E0 1F 33 D2 8B 4E 04 0B 16 81 E1 FF FF FF 7F 0B C1 89 46 04 8B C2 81 4E 04 00 00 F0 7F 8B C8 81 66 04 00 00 F0 FF 83 E1 01 83 C9 01 89 0E 5E 5D C3 }
	condition:
		$1
}

rule file_23_9_0 {
	meta:
		name = "??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAM@Z"
		size = 48
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 0F B6 45 08 C1 E0 1F 8D 49 7F C1 E1 17 81 E1 00 00 80 7F 0B C8 8B 45 10 25 FF FF 7F 00 0B C8 8B 45 18 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_23_10_0 {
	meta:
		name = "??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAN@Z"
		size = 95
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 08 99 56 8B 75 18 33 D2 C1 E0 1F 8B 4E 04 09 16 81 E1 FF FF FF 7F 0B C1 89 46 04 8B 45 0C 8B 4E 04 05 FF 03 00 00 25 FF 07 00 00 81 E1 FF FF 0F 80 99 C1 E0 14 33 D2 0B 16 0B C1 89 46 04 8B CA 33 45 14 33 4D 10 25 FF FF 0F 00 31 46 04 89 16 31 0E 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_23_11_0 {
	meta:
		name = "??$assemble_floating_point_zero@M@__crt_strtox@@YAX_NAAM@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_12_0 {
	meta:
		name = "??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z"
		size = 63
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 56 8B 75 0C 0F 95 C0 99 C1 E0 1F 33 D2 8B 4E 04 0B 16 81 E1 FF FF FF 7F 0B C1 89 46 04 8B C2 81 66 04 FF FF 0F 80 89 06 83 26 00 81 66 04 00 00 F0 FF 5E 5D C3 }
	condition:
		$1
}

rule file_23_13_0 {
	meta:
		name = "??$common_cscanf@D@@YAH_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 111
		refs = "000c ___security_cookie 001f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0042 ??0?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAE@ABV?$console_input_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z 004a ?process@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAEHXZ 0067 @__security_check_cookie@4"
		altNames = "___conio_common_vcscanf"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC FF 75 14 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? FF 75 18 83 65 88 00 8D 85 7C FF FF FF 50 FF 75 10 8D 45 88 FF 75 0C 8D 4D 8C FF 75 08 50 E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 80 7D 84 00 74 0D 8B 8D 78 FF FF FF 83 A1 50 03 00 00 FD 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_14_0 {
	meta:
		name = "??$common_cscanf@_W@@YAH_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 98
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0030 ??0?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAE@ABV?$console_input_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z 0038 ?process@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAEHXZ 0042 __free_base"
		altNames = "___conio_common_vcwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 6C 56 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? FF 75 18 83 65 FC 00 8D 45 F0 50 FF 75 10 8D 45 FC FF 75 0C 8D 4D 94 FF 75 08 50 E8 ?? ?? ?? ?? 8D 4D 94 E8 ?? ?? ?? ?? FF 75 D8 8B F0 E8 ?? ?? ?? ?? 83 65 D8 00 80 7D F8 00 59 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_15_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z"
		size = 35
		refs = "0019 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 89 45 F8 8D 45 F8 50 FF 75 08 C6 45 FC 00 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_17_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z"
		size = 35
		refs = "0019 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 89 45 F8 8D 45 F8 50 FF 75 08 C6 45 FC 00 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_16_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z"
		size = 35
		refs = "0019 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 89 45 F8 8D 45 F8 50 FF 75 08 C6 45 FC 01 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_18_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z"
		size = 35
		refs = "0019 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 89 45 F8 8D 45 F8 50 FF 75 08 C6 45 FC 01 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_25_0 {
	meta:
		name = "??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 A8 04 74 04 B0 01 5D C3 A8 01 74 2B 83 E0 02 74 11 81 7D 10 00 00 00 80 72 08 77 E8 83 7D 0C 00 77 E2 85 C0 75 11 81 7D 10 FF FF FF 7F 72 08 77 D3 83 7D 0C FF 77 CD 32 C0 5D C3 }
	condition:
		$1
}

rule file_23_26_0 {
	meta:
		name = "??$istspace@ABE@?$__crt_char_traits@D@@SAHABE@Z"
		size = 20
		refs = "000d _isspace"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B6 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_23_27_0 {
	meta:
		name = "??$istspace@AB_W@?$__crt_char_traits@_W@@SAHAB_W@Z"
		size = 23
		refs = "000f _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_23_28_0 {
	meta:
		name = "??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_23_29_0 {
	meta:
		name = "??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_729_39_0 {
	meta:
		name = "??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_729_40_2 {
	meta:
		name = "??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_729_41_2 {
	meta:
		name = "??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAV?$string_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$string_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_729_42_2 {
	meta:
		name = "??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAV?$string_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
		size = 30
		refs = "0015 ??0?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$string_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 8B 4D 08 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_23_30_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_31_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_32_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_33_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_43_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_44_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_45_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_46_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_47_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_48_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_49_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_50_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 123
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 0073 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 2C 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 24 5E 85 D2 74 0A 8B 4D 1C 0B 4D 20 75 02 88 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_34_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 1127
		refs = "0010 ?validate@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0030 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 005a __ischartype_l 00dc ?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 024f ??R<lambda_dfcc39eeb01418904072ef28aad1c215>@@QBE_NXZ 0447 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0459 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 8B 75 0C 8B CE 57 E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 41 04 00 00 8B 46 10 8B CE 89 45 E8 8B 46 14 53 89 45 EC E8 ?? ?? ?? ?? 8B 5D 08 8D 4D F9 89 4D E0 8D 4D E8 89 75 DC 89 4D E4 EB 07 8B CE E8 ?? ?? ?? ?? 53 88 45 F9 0F B6 C0 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E3 8A 4D F9 8B 55 10 80 F9 2D 0F 94 C0 88 82 08 03 00 00 80 F9 2D 74 05 80 F9 2B 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 49 0F 84 B7 03 00 00 80 F9 69 0F 84 AE 03 00 00 80 F9 4E 0F 84 93 03 00 00 80 F9 6E 0F 84 8A 03 00 00 33 DB 88 5D FF 80 F9 30 75 43 8B 46 14 8B CE 8B 7E 10 89 45 F0 E8 ?? ?? ?? ?? 88 45 F4 3C 78 74 13 3C 58 74 0F FF 75 F4 8B CE E8 ?? ?? ?? ?? 8A 4D F9 EB 19 8B CE C6 45 FF 01 E8 ?? ?? ?? ?? 8A C8 89 7D E8 8B 45 F0 88 4D F9 89 45 EC 8B 55 10 89 5D F4 88 5D FE 8D 7A 08 80 F9 30 75 18 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8B 55 10 33 DB 38 5D FF 0F 94 C3 4B 83 E3 06 83 C3 09 89 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 25 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 FF 45 F4 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A4 8B 45 08 6A 00 5B 8B 00 8B 80 88 00 00 00 8B 00 3A 08 0F 85 98 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 8D 42 08 3B F8 75 24 80 F9 30 75 1F 8B 5D F4 C6 45 FE 01 8B CE 4B E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EE 8B 55 10 89 5D F4 8B 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 22 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A7 33 DB 80 7D FE 00 75 24 8D 4D DC E8 ?? ?? ?? ?? 84 C0 0F 84 BB 01 00 00 33 C0 38 45 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 F1 01 00 00 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 E8 8B 46 14 89 45 EC E8 ?? ?? ?? ?? 88 45 F9 8A CB 3C 45 74 11 3C 50 74 08 3C 65 74 09 3C 70 75 0C 8A 4D FF EB 07 80 7D FF 00 0F 94 C1 84 C9 0F 84 0D 01 00 00 8B CE E8 ?? ?? ?? ?? 8A C8 80 F9 2D 88 4D F9 0F 94 45 FD 80 F9 2B 74 05 80 F9 2D 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 88 5D FE 80 F9 30 75 15 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 24 6B DB 0A C6 45 FE 01 03 D8 81 FB 50 14 00 00 7F 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB A9 BB 51 14 00 00 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB BA 80 7D FD 00 74 02 F7 DB 8A 45 FE 84 C0 75 16 8D 4D DC E8 ?? ?? ?? ?? 84 C0 74 5E 8B CE E8 ?? ?? ?? ?? 88 45 F9 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 75 10 8D 56 08 3B FA 74 60 80 7F FF 00 75 05 4F 3B FA 75 F5 3B FA 74 51 81 FB 50 14 00 00 7F 25 81 FB B0 EB FF FF 7C 2D 8A 4D FF 33 C0 84 C9 0F 94 C0 48 83 E0 03 40 0F AF 45 F4 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 22 6A 07 EB 1E 81 FB B0 EB FF FF 7D 04 6A 08 EB 12 2B FA 89 1E 33 C0 89 7E 04 84 C9 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? EB 10 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? 83 C4 10 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_51_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 1127
		refs = "0010 ?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0030 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 005a __ischartype_l 00dc ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 024f ??R<lambda_c7c3f778895f47e7f4eff38a8fef279a>@@QBE_NXZ 0447 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0459 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 8B 75 0C 8B CE 57 E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 41 04 00 00 8B 46 10 8B CE 89 45 E8 8B 46 14 53 89 45 EC E8 ?? ?? ?? ?? 8B 5D 08 8D 4D F9 89 4D E0 8D 4D E8 89 75 DC 89 4D E4 EB 07 8B CE E8 ?? ?? ?? ?? 53 88 45 F9 0F B6 C0 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E3 8A 4D F9 8B 55 10 80 F9 2D 0F 94 C0 88 82 08 03 00 00 80 F9 2D 74 05 80 F9 2B 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 49 0F 84 B7 03 00 00 80 F9 69 0F 84 AE 03 00 00 80 F9 4E 0F 84 93 03 00 00 80 F9 6E 0F 84 8A 03 00 00 33 DB 88 5D FF 80 F9 30 75 43 8B 46 14 8B CE 8B 7E 10 89 45 F0 E8 ?? ?? ?? ?? 88 45 F4 3C 78 74 13 3C 58 74 0F FF 75 F4 8B CE E8 ?? ?? ?? ?? 8A 4D F9 EB 19 8B CE C6 45 FF 01 E8 ?? ?? ?? ?? 8A C8 89 7D E8 8B 45 F0 88 4D F9 89 45 EC 8B 55 10 89 5D F4 88 5D FE 8D 7A 08 80 F9 30 75 18 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8B 55 10 33 DB 38 5D FF 0F 94 C3 4B 83 E3 06 83 C3 09 89 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 25 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 FF 45 F4 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A4 8B 45 08 6A 00 5B 8B 00 8B 80 88 00 00 00 8B 00 3A 08 0F 85 98 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 8D 42 08 3B F8 75 24 80 F9 30 75 1F 8B 5D F4 C6 45 FE 01 8B CE 4B E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EE 8B 55 10 89 5D F4 8B 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 22 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A7 33 DB 80 7D FE 00 75 24 8D 4D DC E8 ?? ?? ?? ?? 84 C0 0F 84 BB 01 00 00 33 C0 38 45 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 F1 01 00 00 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 E8 8B 46 14 89 45 EC E8 ?? ?? ?? ?? 88 45 F9 8A CB 3C 45 74 11 3C 50 74 08 3C 65 74 09 3C 70 75 0C 8A 4D FF EB 07 80 7D FF 00 0F 94 C1 84 C9 0F 84 0D 01 00 00 8B CE E8 ?? ?? ?? ?? 8A C8 80 F9 2D 88 4D F9 0F 94 45 FD 80 F9 2B 74 05 80 F9 2D 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 88 5D FE 80 F9 30 75 15 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 24 6B DB 0A C6 45 FE 01 03 D8 81 FB 50 14 00 00 7F 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB A9 BB 51 14 00 00 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB BA 80 7D FD 00 74 02 F7 DB 8A 45 FE 84 C0 75 16 8D 4D DC E8 ?? ?? ?? ?? 84 C0 74 5E 8B CE E8 ?? ?? ?? ?? 88 45 F9 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 75 10 8D 56 08 3B FA 74 60 80 7F FF 00 75 05 4F 3B FA 75 F5 3B FA 74 51 81 FB 50 14 00 00 7F 25 81 FB B0 EB FF FF 7C 2D 8A 4D FF 33 C0 84 C9 0F 94 C0 48 83 E0 03 40 0F AF 45 F4 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 22 6A 07 EB 1E 81 FB B0 EB FF FF 7D 04 6A 08 EB 12 2B FA 89 1E 33 C0 89 7E 04 84 C9 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? EB 10 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? 83 C4 10 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_53_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 1127
		refs = "0010 ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0030 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 005a __ischartype_l 00dc ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 024f ??R<lambda_f765c90ab33e8386abf09c0f079d37e9>@@QBE_NXZ 0447 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0459 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 8B 75 0C 8B CE 57 E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 41 04 00 00 8B 46 10 8B CE 89 45 E8 8B 46 14 53 89 45 EC E8 ?? ?? ?? ?? 8B 5D 08 8D 4D F9 89 4D E0 8D 4D E8 89 75 DC 89 4D E4 EB 07 8B CE E8 ?? ?? ?? ?? 53 88 45 F9 0F B6 C0 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E3 8A 4D F9 8B 55 10 80 F9 2D 0F 94 C0 88 82 08 03 00 00 80 F9 2D 74 05 80 F9 2B 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 49 0F 84 B7 03 00 00 80 F9 69 0F 84 AE 03 00 00 80 F9 4E 0F 84 93 03 00 00 80 F9 6E 0F 84 8A 03 00 00 33 DB 88 5D FF 80 F9 30 75 43 8B 46 14 8B CE 8B 7E 10 89 45 F0 E8 ?? ?? ?? ?? 88 45 F4 3C 78 74 13 3C 58 74 0F FF 75 F4 8B CE E8 ?? ?? ?? ?? 8A 4D F9 EB 19 8B CE C6 45 FF 01 E8 ?? ?? ?? ?? 8A C8 89 7D E8 8B 45 F0 88 4D F9 89 45 EC 8B 55 10 89 5D F4 88 5D FE 8D 7A 08 80 F9 30 75 18 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8B 55 10 33 DB 38 5D FF 0F 94 C3 4B 83 E3 06 83 C3 09 89 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 25 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 FF 45 F4 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A4 8B 45 08 6A 00 5B 8B 00 8B 80 88 00 00 00 8B 00 3A 08 0F 85 98 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 8D 42 08 3B F8 75 24 80 F9 30 75 1F 8B 5D F4 C6 45 FE 01 8B CE 4B E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EE 8B 55 10 89 5D F4 8B 5D F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C3 77 22 8D 8A 08 03 00 00 C6 45 FE 01 3B F9 74 03 88 07 47 8B CE E8 ?? ?? ?? ?? 8B 55 10 8A C8 88 4D F9 EB A7 33 DB 80 7D FE 00 75 24 8D 4D DC E8 ?? ?? ?? ?? 84 C0 0F 84 BB 01 00 00 33 C0 38 45 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 F1 01 00 00 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 E8 8B 46 14 89 45 EC E8 ?? ?? ?? ?? 88 45 F9 8A CB 3C 45 74 11 3C 50 74 08 3C 65 74 09 3C 70 75 0C 8A 4D FF EB 07 80 7D FF 00 0F 94 C1 84 C9 0F 84 0D 01 00 00 8B CE E8 ?? ?? ?? ?? 8A C8 80 F9 2D 88 4D F9 0F 94 45 FD 80 F9 2B 74 05 80 F9 2D 75 0C 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 88 5D FE 80 F9 30 75 15 C6 45 FE 01 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 80 F9 30 74 EF 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 24 6B DB 0A C6 45 FE 01 03 D8 81 FB 50 14 00 00 7F 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB A9 BB 51 14 00 00 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 0E 8B CE E8 ?? ?? ?? ?? 8A C8 88 4D F9 EB BA 80 7D FD 00 74 02 F7 DB 8A 45 FE 84 C0 75 16 8D 4D DC E8 ?? ?? ?? ?? 84 C0 74 5E 8B CE E8 ?? ?? ?? ?? 88 45 F9 FF 75 F9 8B CE E8 ?? ?? ?? ?? 8B 75 10 8D 56 08 3B FA 74 60 80 7F FF 00 75 05 4F 3B FA 75 F5 3B FA 74 51 81 FB 50 14 00 00 7F 25 81 FB B0 EB FF FF 7C 2D 8A 4D FF 33 C0 84 C9 0F 94 C0 48 83 E0 03 40 0F AF 45 F4 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 22 6A 07 EB 1E 81 FB B0 EB FF FF 7D 04 6A 08 EB 12 2B FA 89 1E 33 C0 89 7E 04 84 C9 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? EB 10 FF 75 EC 8D 45 F9 FF 75 E8 56 50 E8 ?? ?? ?? ?? 83 C4 10 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_35_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 3655
		refs = "0013 ?validate@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0032 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0065 _iswctype 0103 ?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0835 ??R<lambda_98f31d9ba9b79953c6b659ba96648114>@@QBE_NXZ 0e27 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0e39 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 00 00 00 53 57 8B 7D 0C 8B CF E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 1E 0E 00 00 8B 47 10 8B CF 89 45 D8 8B 47 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 8D 45 F8 89 85 38 FF FF FF 8D 45 D8 89 BD 34 FF FF FF 89 85 3C FF FF FF EB 0B 8B CF E8 ?? ?? ?? ?? 66 89 45 F8 6A 08 FF 75 F8 E8 ?? ?? ?? ?? 59 59 85 C0 75 E5 66 8B 55 F8 56 8B 75 10 6A 2D 59 81 C6 08 03 00 00 66 3B D1 6A 2B 0F 94 C0 89 75 E4 88 06 58 66 3B D1 74 05 66 3B D0 75 0E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 83 FA 49 0F 84 7D 0D 00 00 66 83 FA 69 0F 84 73 0D 00 00 66 83 FA 4E 0F 84 57 0D 00 00 66 83 FA 6E 0F 84 4D 0D 00 00 33 C0 6A 30 59 89 45 EC 8A F8 88 7D FF 66 3B D1 75 53 8B 77 10 8B 5D 0C 8B CB 8B 7F 14 E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 19 83 F8 58 74 14 8B FB 50 8B CF E8 ?? ?? ?? ?? 66 8B 55 F8 33 C0 8A F8 EB 1F 8B CB C6 45 FF 01 E8 ?? ?? ?? ?? 66 8B D0 89 7D DC 8B FB 66 89 55 F8 8A 7D FF 33 C0 89 75 D8 8B 75 E4 8B 4D 10 8A D8 6A 30 89 45 E0 83 C1 08 58 89 4D E8 66 3B D0 75 1D 50 B3 01 5E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 3B D6 74 ED 8B 75 E4 6A 30 58 33 C9 C7 85 44 FF FF FF 3A 00 00 00 84 FF C7 45 D4 10 FF 00 00 C7 45 D0 60 06 00 00 0F 94 C1 C7 45 CC 6A 06 00 00 49 C7 45 C8 F0 06 00 00 83 E1 06 C7 45 C4 FA 06 00 00 83 C1 09 C7 45 C0 66 09 00 00 89 8D 40 FF FF FF C7 45 BC 70 09 00 00 C7 45 B8 E6 09 00 00 C7 45 B4 F0 09 00 00 C7 45 B0 66 0A 00 00 C7 45 AC 70 0A 00 00 C7 45 A8 E6 0A 00 00 C7 45 A4 F0 0A 00 00 C7 45 A0 66 0B 00 00 C7 45 9C 70 0B 00 00 C7 45 98 66 0C 00 00 C7 45 94 70 0C 00 00 C7 45 90 E6 0C 00 00 C7 45 8C F0 0C 00 00 C7 45 88 66 0D 00 00 C7 45 84 70 0D 00 00 C7 45 80 50 0E 00 00 C7 85 7C FF FF FF 5A 0E 00 00 C7 85 78 FF FF FF D0 0E 00 00 C7 85 74 FF FF FF DA 0E 00 00 C7 85 70 FF FF FF 20 0F 00 00 C7 85 6C FF FF FF 2A 0F 00 00 C7 85 68 FF FF FF 40 10 00 00 C7 85 64 FF FF FF 4A 10 00 00 C7 85 60 FF FF FF E0 17 00 00 C7 85 5C FF FF FF EA 17 00 00 C7 85 58 FF FF FF 10 18 00 00 C7 85 54 FF FF FF 1A 18 00 00 C7 85 50 FF FF FF 1A FF 00 00 C7 85 4C FF FF FF 41 00 00 00 C7 85 48 FF FF FF 5A 00 00 00 C7 45 F4 61 00 00 00 C7 45 F0 19 00 00 00 66 3B D0 0F 82 12 02 00 00 66 3B 95 44 FF FF FF 73 0B 0F B7 C2 83 E8 30 E9 F9 01 00 00 66 3B 55 D4 0F 83 D9 01 00 00 66 3B 55 D0 0F 82 EA 01 00 00 66 3B 55 CC 73 0D 0F B7 C2 2D 60 06 00 00 E9 D2 01 00 00 66 3B 55 C8 0F 82 CD 01 00 00 66 3B 55 C4 73 0D 0F B7 C2 2D F0 06 00 00 E9 B5 01 00 00 66 3B 55 C0 0F 82 B0 01 00 00 66 3B 55 BC 73 0D 0F B7 C2 2D 66 09 00 00 E9 98 01 00 00 66 3B 55 B8 0F 82 93 01 00 00 66 3B 55 B4 73 0D 0F B7 C2 2D E6 09 00 00 E9 7B 01 00 00 66 3B 55 B0 0F 82 76 01 00 00 66 3B 55 AC 73 0D 0F B7 C2 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 55 A8 0F 82 59 01 00 00 66 3B 55 A4 73 0D 0F B7 C2 2D E6 0A 00 00 E9 41 01 00 00 66 3B 55 A0 0F 82 3C 01 00 00 66 3B 55 9C 73 0D 0F B7 C2 2D 66 0B 00 00 E9 24 01 00 00 66 3B 55 98 0F 82 1F 01 00 00 66 3B 55 94 73 0D 0F B7 C2 2D 66 0C 00 00 E9 07 01 00 00 66 3B 55 90 0F 82 02 01 00 00 66 3B 55 8C 73 0D 0F B7 C2 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 55 88 0F 82 E5 00 00 00 66 3B 55 84 73 0D 0F B7 C2 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 55 80 0F 82 C8 00 00 00 66 3B 95 7C FF FF FF 73 0D 0F B7 C2 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 95 78 FF FF FF 0F 82 A5 00 00 00 66 3B 95 74 FF FF FF 73 0D 0F B7 C2 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 95 70 FF FF FF 0F 82 82 00 00 00 66 3B 95 6C FF FF FF 73 0A 0F B7 C2 2D 20 0F 00 00 EB 6A 66 3B 95 68 FF FF FF 72 66 66 3B 95 64 FF FF FF 73 0A 0F B7 C2 2D 40 10 00 00 EB 4E 66 3B 95 60 FF FF FF 72 4A 66 3B 95 5C FF FF FF 73 0A 0F B7 C2 2D E0 17 00 00 EB 32 66 3B 95 58 FF FF FF 72 2E 66 3B 95 54 FF FF FF 73 25 0F B7 C2 2D 10 18 00 00 EB 16 66 3B 95 50 FF FF FF 73 0A 0F B7 C2 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 95 4C FF FF FF 77 09 66 3B 95 48 FF FF FF 76 0D 66 8B C2 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C2 66 2B 45 F4 66 3B 45 F0 0F B7 C2 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C1 77 2E 8B 4D E8 B3 01 3B CE 74 06 88 01 41 89 4D E8 FF 45 E0 8B CF E8 ?? ?? ?? ?? 8B 8D 40 FF FF FF 66 8B D0 6A 30 66 89 55 F8 58 E9 79 FD FF FF 8B 45 08 8B 00 8B 80 88 00 00 00 8B 00 0F BE 08 0F B7 C2 3B C1 0F 85 D0 02 00 00 8B CF E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 8B 45 10 8B 75 E4 83 C0 08 6A 30 3B D0 66 89 4D F8 58 75 2A 66 3B C8 75 25 8B 75 E0 B3 01 8B CF 4E E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 E9 8B 55 E8 89 75 E0 8B 75 E4 8B BD 40 FF FF FF 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C7 77 26 B3 01 3B D6 74 06 88 02 42 89 55 E8 8B 4D 0C E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 6A 30 66 89 4D F8 58 E9 81 FD FF FF 84 DB 75 26 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 0F 84 B8 05 00 00 33 C0 84 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 EC 05 00 00 FF 75 F8 8B 75 0C 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 D8 8B 46 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 33 DB 0F B7 C0 8A CB 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0B 8A 4D FF EB 06 38 5D FF 0F 94 C1 BF 50 14 00 00 84 C9 0F 84 FC 04 00 00 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 2D 58 66 3B C8 66 89 4D F8 6A 2B 5A 0F 94 C7 66 3B CA 74 05 66 3B C8 75 0E 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 6A 30 33 D2 58 8A DA 66 3B C8 75 1D B3 01 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 EA 33 D2 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 0A 73 2E 6B D2 0A B3 01 03 D0 89 55 EC 3B D7 7F 19 8B CE E8 ?? ?? ?? ?? 8B 55 EC 66 8B C8 6A 30 66 89 4D F8 58 E9 7F FD FF FF C7 45 EC 51 14 00 00 6A 30 5A 66 3B CA 0F 82 92 01 00 00 66 3B 8D 44 FF FF FF 73 0A 0F B7 C1 2B C2 E9 7A 01 00 00 8B 55 D4 66 3B CA 0F 83 5E 01 00 00 8B 55 D0 66 3B CA 0F 82 67 01 00 00 66 3B 4D CC 72 D8 8B 55 C8 66 3B CA 0F 82 55 01 00 00 66 3B 4D C4 72 C6 8B 55 C0 66 3B CA 0F 82 43 01 00 00 66 3B 4D BC 72 B4 8B 55 B8 66 3B CA 0F 82 31 01 00 00 66 3B 4D B4 72 A2 8B 55 B0 66 3B CA 0F 82 1F 01 00 00 66 3B 4D AC 72 90 8B 55 A8 66 3B CA 0F 82 0D 01 00 00 66 3B 4D A4 0F 82 7A FF FF FF 8B 55 A0 66 3B CA 0F 82 F7 00 00 00 66 3B 4D 9C 0F 82 64 FF FF FF 8B 55 98 66 3B CA 0F 82 E1 00 00 00 66 3B 4D 94 0F 82 4E FF FF FF 8B 55 90 66 3B CA 0F 82 CB 00 00 00 66 3B 4D 8C 0F 82 38 FF FF FF 8B 55 88 66 3B CA 0F 82 B5 00 00 00 66 3B 4D 84 0F 82 22 FF FF FF 8B 55 80 66 3B CA 0F 82 9F 00 00 00 66 3B 8D 7C FF FF FF 0F 82 09 FF FF FF 8B 95 78 FF FF FF 66 3B CA 0F 82 83 00 00 00 66 3B 8D 74 FF FF FF 0F 82 ED FE FF FF 8B 95 70 FF FF FF 66 3B CA 72 6B 66 3B 8D 6C FF FF FF 0F 82 D5 FE FF FF 8B 95 68 FF FF FF 66 3B CA 72 53 66 3B 8D 64 FF FF FF 0F 82 BD FE FF FF 8B 95 60 FF FF FF 66 3B CA 72 3B 66 3B 8D 5C FF FF FF 0F 82 A5 FE FF FF 8B 95 58 FF FF FF 66 3B CA 72 23 66 3B 8D 54 FF FF FF 73 1A E9 8C FE FF FF 66 3B 8D 50 FF FF FF 0F 82 7F FE FF FF 83 C8 FF 83 F8 FF 75 24 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 2A 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 76 1E 83 C8 FF 83 F8 0A 73 2D 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 E9 26 FE FF FF 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB CE 84 FF 74 03 F7 5D EC 84 DB 75 1A 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 74 60 8B CE E8 ?? ?? ?? ?? 66 89 45 F8 8B 5D EC FF 75 F8 8B CE E8 ?? ?? ?? ?? 8B 75 10 8B 4D E8 8D 56 08 3B CA 74 58 80 79 FF 00 75 05 49 3B CA 75 F5 3B CA 74 49 3B DF 7F 24 BF B0 EB FF FF 3B DF 7C 27 33 C0 38 45 FF 0F 94 C0 48 83 E0 03 40 0F AF 45 E0 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 1F 6A 07 EB 1B 3B DF 7D 04 6A 08 EB 13 33 C0 89 1E 2B CA 38 45 FF 89 4E 04 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? EB 10 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_52_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 3655
		refs = "0013 ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0032 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0065 _iswctype 0103 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0835 ??R<lambda_cbb29514201643ebc3996c8b1c7ae90c>@@QBE_NXZ 0e27 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0e39 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 00 00 00 53 57 8B 7D 0C 8B CF E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 1E 0E 00 00 8B 47 10 8B CF 89 45 D8 8B 47 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 8D 45 F8 89 85 38 FF FF FF 8D 45 D8 89 BD 34 FF FF FF 89 85 3C FF FF FF EB 0B 8B CF E8 ?? ?? ?? ?? 66 89 45 F8 6A 08 FF 75 F8 E8 ?? ?? ?? ?? 59 59 85 C0 75 E5 66 8B 55 F8 56 8B 75 10 6A 2D 59 81 C6 08 03 00 00 66 3B D1 6A 2B 0F 94 C0 89 75 E4 88 06 58 66 3B D1 74 05 66 3B D0 75 0E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 83 FA 49 0F 84 7D 0D 00 00 66 83 FA 69 0F 84 73 0D 00 00 66 83 FA 4E 0F 84 57 0D 00 00 66 83 FA 6E 0F 84 4D 0D 00 00 33 C0 6A 30 59 89 45 EC 8A F8 88 7D FF 66 3B D1 75 53 8B 77 10 8B 5D 0C 8B CB 8B 7F 14 E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 19 83 F8 58 74 14 8B FB 50 8B CF E8 ?? ?? ?? ?? 66 8B 55 F8 33 C0 8A F8 EB 1F 8B CB C6 45 FF 01 E8 ?? ?? ?? ?? 66 8B D0 89 7D DC 8B FB 66 89 55 F8 8A 7D FF 33 C0 89 75 D8 8B 75 E4 8B 4D 10 8A D8 6A 30 89 45 E0 83 C1 08 58 89 4D E8 66 3B D0 75 1D 50 B3 01 5E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 3B D6 74 ED 8B 75 E4 6A 30 58 33 C9 C7 85 44 FF FF FF 3A 00 00 00 84 FF C7 45 D4 10 FF 00 00 C7 45 D0 60 06 00 00 0F 94 C1 C7 45 CC 6A 06 00 00 49 C7 45 C8 F0 06 00 00 83 E1 06 C7 45 C4 FA 06 00 00 83 C1 09 C7 45 C0 66 09 00 00 89 8D 40 FF FF FF C7 45 BC 70 09 00 00 C7 45 B8 E6 09 00 00 C7 45 B4 F0 09 00 00 C7 45 B0 66 0A 00 00 C7 45 AC 70 0A 00 00 C7 45 A8 E6 0A 00 00 C7 45 A4 F0 0A 00 00 C7 45 A0 66 0B 00 00 C7 45 9C 70 0B 00 00 C7 45 98 66 0C 00 00 C7 45 94 70 0C 00 00 C7 45 90 E6 0C 00 00 C7 45 8C F0 0C 00 00 C7 45 88 66 0D 00 00 C7 45 84 70 0D 00 00 C7 45 80 50 0E 00 00 C7 85 7C FF FF FF 5A 0E 00 00 C7 85 78 FF FF FF D0 0E 00 00 C7 85 74 FF FF FF DA 0E 00 00 C7 85 70 FF FF FF 20 0F 00 00 C7 85 6C FF FF FF 2A 0F 00 00 C7 85 68 FF FF FF 40 10 00 00 C7 85 64 FF FF FF 4A 10 00 00 C7 85 60 FF FF FF E0 17 00 00 C7 85 5C FF FF FF EA 17 00 00 C7 85 58 FF FF FF 10 18 00 00 C7 85 54 FF FF FF 1A 18 00 00 C7 85 50 FF FF FF 1A FF 00 00 C7 85 4C FF FF FF 41 00 00 00 C7 85 48 FF FF FF 5A 00 00 00 C7 45 F4 61 00 00 00 C7 45 F0 19 00 00 00 66 3B D0 0F 82 12 02 00 00 66 3B 95 44 FF FF FF 73 0B 0F B7 C2 83 E8 30 E9 F9 01 00 00 66 3B 55 D4 0F 83 D9 01 00 00 66 3B 55 D0 0F 82 EA 01 00 00 66 3B 55 CC 73 0D 0F B7 C2 2D 60 06 00 00 E9 D2 01 00 00 66 3B 55 C8 0F 82 CD 01 00 00 66 3B 55 C4 73 0D 0F B7 C2 2D F0 06 00 00 E9 B5 01 00 00 66 3B 55 C0 0F 82 B0 01 00 00 66 3B 55 BC 73 0D 0F B7 C2 2D 66 09 00 00 E9 98 01 00 00 66 3B 55 B8 0F 82 93 01 00 00 66 3B 55 B4 73 0D 0F B7 C2 2D E6 09 00 00 E9 7B 01 00 00 66 3B 55 B0 0F 82 76 01 00 00 66 3B 55 AC 73 0D 0F B7 C2 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 55 A8 0F 82 59 01 00 00 66 3B 55 A4 73 0D 0F B7 C2 2D E6 0A 00 00 E9 41 01 00 00 66 3B 55 A0 0F 82 3C 01 00 00 66 3B 55 9C 73 0D 0F B7 C2 2D 66 0B 00 00 E9 24 01 00 00 66 3B 55 98 0F 82 1F 01 00 00 66 3B 55 94 73 0D 0F B7 C2 2D 66 0C 00 00 E9 07 01 00 00 66 3B 55 90 0F 82 02 01 00 00 66 3B 55 8C 73 0D 0F B7 C2 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 55 88 0F 82 E5 00 00 00 66 3B 55 84 73 0D 0F B7 C2 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 55 80 0F 82 C8 00 00 00 66 3B 95 7C FF FF FF 73 0D 0F B7 C2 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 95 78 FF FF FF 0F 82 A5 00 00 00 66 3B 95 74 FF FF FF 73 0D 0F B7 C2 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 95 70 FF FF FF 0F 82 82 00 00 00 66 3B 95 6C FF FF FF 73 0A 0F B7 C2 2D 20 0F 00 00 EB 6A 66 3B 95 68 FF FF FF 72 66 66 3B 95 64 FF FF FF 73 0A 0F B7 C2 2D 40 10 00 00 EB 4E 66 3B 95 60 FF FF FF 72 4A 66 3B 95 5C FF FF FF 73 0A 0F B7 C2 2D E0 17 00 00 EB 32 66 3B 95 58 FF FF FF 72 2E 66 3B 95 54 FF FF FF 73 25 0F B7 C2 2D 10 18 00 00 EB 16 66 3B 95 50 FF FF FF 73 0A 0F B7 C2 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 95 4C FF FF FF 77 09 66 3B 95 48 FF FF FF 76 0D 66 8B C2 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C2 66 2B 45 F4 66 3B 45 F0 0F B7 C2 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C1 77 2E 8B 4D E8 B3 01 3B CE 74 06 88 01 41 89 4D E8 FF 45 E0 8B CF E8 ?? ?? ?? ?? 8B 8D 40 FF FF FF 66 8B D0 6A 30 66 89 55 F8 58 E9 79 FD FF FF 8B 45 08 8B 00 8B 80 88 00 00 00 8B 00 0F BE 08 0F B7 C2 3B C1 0F 85 D0 02 00 00 8B CF E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 8B 45 10 8B 75 E4 83 C0 08 6A 30 3B D0 66 89 4D F8 58 75 2A 66 3B C8 75 25 8B 75 E0 B3 01 8B CF 4E E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 E9 8B 55 E8 89 75 E0 8B 75 E4 8B BD 40 FF FF FF 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C7 77 26 B3 01 3B D6 74 06 88 02 42 89 55 E8 8B 4D 0C E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 6A 30 66 89 4D F8 58 E9 81 FD FF FF 84 DB 75 26 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 0F 84 B8 05 00 00 33 C0 84 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 EC 05 00 00 FF 75 F8 8B 75 0C 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 D8 8B 46 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 33 DB 0F B7 C0 8A CB 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0B 8A 4D FF EB 06 38 5D FF 0F 94 C1 BF 50 14 00 00 84 C9 0F 84 FC 04 00 00 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 2D 58 66 3B C8 66 89 4D F8 6A 2B 5A 0F 94 C7 66 3B CA 74 05 66 3B C8 75 0E 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 6A 30 33 D2 58 8A DA 66 3B C8 75 1D B3 01 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 EA 33 D2 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 0A 73 2E 6B D2 0A B3 01 03 D0 89 55 EC 3B D7 7F 19 8B CE E8 ?? ?? ?? ?? 8B 55 EC 66 8B C8 6A 30 66 89 4D F8 58 E9 7F FD FF FF C7 45 EC 51 14 00 00 6A 30 5A 66 3B CA 0F 82 92 01 00 00 66 3B 8D 44 FF FF FF 73 0A 0F B7 C1 2B C2 E9 7A 01 00 00 8B 55 D4 66 3B CA 0F 83 5E 01 00 00 8B 55 D0 66 3B CA 0F 82 67 01 00 00 66 3B 4D CC 72 D8 8B 55 C8 66 3B CA 0F 82 55 01 00 00 66 3B 4D C4 72 C6 8B 55 C0 66 3B CA 0F 82 43 01 00 00 66 3B 4D BC 72 B4 8B 55 B8 66 3B CA 0F 82 31 01 00 00 66 3B 4D B4 72 A2 8B 55 B0 66 3B CA 0F 82 1F 01 00 00 66 3B 4D AC 72 90 8B 55 A8 66 3B CA 0F 82 0D 01 00 00 66 3B 4D A4 0F 82 7A FF FF FF 8B 55 A0 66 3B CA 0F 82 F7 00 00 00 66 3B 4D 9C 0F 82 64 FF FF FF 8B 55 98 66 3B CA 0F 82 E1 00 00 00 66 3B 4D 94 0F 82 4E FF FF FF 8B 55 90 66 3B CA 0F 82 CB 00 00 00 66 3B 4D 8C 0F 82 38 FF FF FF 8B 55 88 66 3B CA 0F 82 B5 00 00 00 66 3B 4D 84 0F 82 22 FF FF FF 8B 55 80 66 3B CA 0F 82 9F 00 00 00 66 3B 8D 7C FF FF FF 0F 82 09 FF FF FF 8B 95 78 FF FF FF 66 3B CA 0F 82 83 00 00 00 66 3B 8D 74 FF FF FF 0F 82 ED FE FF FF 8B 95 70 FF FF FF 66 3B CA 72 6B 66 3B 8D 6C FF FF FF 0F 82 D5 FE FF FF 8B 95 68 FF FF FF 66 3B CA 72 53 66 3B 8D 64 FF FF FF 0F 82 BD FE FF FF 8B 95 60 FF FF FF 66 3B CA 72 3B 66 3B 8D 5C FF FF FF 0F 82 A5 FE FF FF 8B 95 58 FF FF FF 66 3B CA 72 23 66 3B 8D 54 FF FF FF 73 1A E9 8C FE FF FF 66 3B 8D 50 FF FF FF 0F 82 7F FE FF FF 83 C8 FF 83 F8 FF 75 24 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 2A 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 76 1E 83 C8 FF 83 F8 0A 73 2D 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 E9 26 FE FF FF 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB CE 84 FF 74 03 F7 5D EC 84 DB 75 1A 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 74 60 8B CE E8 ?? ?? ?? ?? 66 89 45 F8 8B 5D EC FF 75 F8 8B CE E8 ?? ?? ?? ?? 8B 75 10 8B 4D E8 8D 56 08 3B CA 74 58 80 79 FF 00 75 05 49 3B CA 75 F5 3B CA 74 49 3B DF 7F 24 BF B0 EB FF FF 3B DF 7C 27 33 C0 38 45 FF 0F 94 C0 48 83 E0 03 40 0F AF 45 E0 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 1F 6A 07 EB 1B 3B DF 7D 04 6A 08 EB 13 33 C0 89 1E 2B CA 38 45 FF 89 4E 04 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? EB 10 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_54_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 3655
		refs = "0013 ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0032 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0065 _iswctype 0103 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0835 ??R<lambda_fd76cae15b6f790020ebaa7b78a868c2>@@QBE_NXZ 0e27 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0e39 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 00 00 00 53 57 8B 7D 0C 8B CF E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 1E 0E 00 00 8B 47 10 8B CF 89 45 D8 8B 47 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 8D 45 F8 89 85 38 FF FF FF 8D 45 D8 89 BD 34 FF FF FF 89 85 3C FF FF FF EB 0B 8B CF E8 ?? ?? ?? ?? 66 89 45 F8 6A 08 FF 75 F8 E8 ?? ?? ?? ?? 59 59 85 C0 75 E5 66 8B 55 F8 56 8B 75 10 6A 2D 59 81 C6 08 03 00 00 66 3B D1 6A 2B 0F 94 C0 89 75 E4 88 06 58 66 3B D1 74 05 66 3B D0 75 0E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 83 FA 49 0F 84 7D 0D 00 00 66 83 FA 69 0F 84 73 0D 00 00 66 83 FA 4E 0F 84 57 0D 00 00 66 83 FA 6E 0F 84 4D 0D 00 00 33 C0 6A 30 59 89 45 EC 8A F8 88 7D FF 66 3B D1 75 53 8B 77 10 8B 5D 0C 8B CB 8B 7F 14 E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 19 83 F8 58 74 14 8B FB 50 8B CF E8 ?? ?? ?? ?? 66 8B 55 F8 33 C0 8A F8 EB 1F 8B CB C6 45 FF 01 E8 ?? ?? ?? ?? 66 8B D0 89 7D DC 8B FB 66 89 55 F8 8A 7D FF 33 C0 89 75 D8 8B 75 E4 8B 4D 10 8A D8 6A 30 89 45 E0 83 C1 08 58 89 4D E8 66 3B D0 75 1D 50 B3 01 5E 8B CF E8 ?? ?? ?? ?? 66 8B D0 66 89 55 F8 66 3B D6 74 ED 8B 75 E4 6A 30 58 33 C9 C7 85 44 FF FF FF 3A 00 00 00 84 FF C7 45 D4 10 FF 00 00 C7 45 D0 60 06 00 00 0F 94 C1 C7 45 CC 6A 06 00 00 49 C7 45 C8 F0 06 00 00 83 E1 06 C7 45 C4 FA 06 00 00 83 C1 09 C7 45 C0 66 09 00 00 89 8D 40 FF FF FF C7 45 BC 70 09 00 00 C7 45 B8 E6 09 00 00 C7 45 B4 F0 09 00 00 C7 45 B0 66 0A 00 00 C7 45 AC 70 0A 00 00 C7 45 A8 E6 0A 00 00 C7 45 A4 F0 0A 00 00 C7 45 A0 66 0B 00 00 C7 45 9C 70 0B 00 00 C7 45 98 66 0C 00 00 C7 45 94 70 0C 00 00 C7 45 90 E6 0C 00 00 C7 45 8C F0 0C 00 00 C7 45 88 66 0D 00 00 C7 45 84 70 0D 00 00 C7 45 80 50 0E 00 00 C7 85 7C FF FF FF 5A 0E 00 00 C7 85 78 FF FF FF D0 0E 00 00 C7 85 74 FF FF FF DA 0E 00 00 C7 85 70 FF FF FF 20 0F 00 00 C7 85 6C FF FF FF 2A 0F 00 00 C7 85 68 FF FF FF 40 10 00 00 C7 85 64 FF FF FF 4A 10 00 00 C7 85 60 FF FF FF E0 17 00 00 C7 85 5C FF FF FF EA 17 00 00 C7 85 58 FF FF FF 10 18 00 00 C7 85 54 FF FF FF 1A 18 00 00 C7 85 50 FF FF FF 1A FF 00 00 C7 85 4C FF FF FF 41 00 00 00 C7 85 48 FF FF FF 5A 00 00 00 C7 45 F4 61 00 00 00 C7 45 F0 19 00 00 00 66 3B D0 0F 82 12 02 00 00 66 3B 95 44 FF FF FF 73 0B 0F B7 C2 83 E8 30 E9 F9 01 00 00 66 3B 55 D4 0F 83 D9 01 00 00 66 3B 55 D0 0F 82 EA 01 00 00 66 3B 55 CC 73 0D 0F B7 C2 2D 60 06 00 00 E9 D2 01 00 00 66 3B 55 C8 0F 82 CD 01 00 00 66 3B 55 C4 73 0D 0F B7 C2 2D F0 06 00 00 E9 B5 01 00 00 66 3B 55 C0 0F 82 B0 01 00 00 66 3B 55 BC 73 0D 0F B7 C2 2D 66 09 00 00 E9 98 01 00 00 66 3B 55 B8 0F 82 93 01 00 00 66 3B 55 B4 73 0D 0F B7 C2 2D E6 09 00 00 E9 7B 01 00 00 66 3B 55 B0 0F 82 76 01 00 00 66 3B 55 AC 73 0D 0F B7 C2 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 55 A8 0F 82 59 01 00 00 66 3B 55 A4 73 0D 0F B7 C2 2D E6 0A 00 00 E9 41 01 00 00 66 3B 55 A0 0F 82 3C 01 00 00 66 3B 55 9C 73 0D 0F B7 C2 2D 66 0B 00 00 E9 24 01 00 00 66 3B 55 98 0F 82 1F 01 00 00 66 3B 55 94 73 0D 0F B7 C2 2D 66 0C 00 00 E9 07 01 00 00 66 3B 55 90 0F 82 02 01 00 00 66 3B 55 8C 73 0D 0F B7 C2 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 55 88 0F 82 E5 00 00 00 66 3B 55 84 73 0D 0F B7 C2 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 55 80 0F 82 C8 00 00 00 66 3B 95 7C FF FF FF 73 0D 0F B7 C2 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 95 78 FF FF FF 0F 82 A5 00 00 00 66 3B 95 74 FF FF FF 73 0D 0F B7 C2 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 95 70 FF FF FF 0F 82 82 00 00 00 66 3B 95 6C FF FF FF 73 0A 0F B7 C2 2D 20 0F 00 00 EB 6A 66 3B 95 68 FF FF FF 72 66 66 3B 95 64 FF FF FF 73 0A 0F B7 C2 2D 40 10 00 00 EB 4E 66 3B 95 60 FF FF FF 72 4A 66 3B 95 5C FF FF FF 73 0A 0F B7 C2 2D E0 17 00 00 EB 32 66 3B 95 58 FF FF FF 72 2E 66 3B 95 54 FF FF FF 73 25 0F B7 C2 2D 10 18 00 00 EB 16 66 3B 95 50 FF FF FF 73 0A 0F B7 C2 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 95 4C FF FF FF 77 09 66 3B 95 48 FF FF FF 76 0D 66 8B C2 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C2 66 2B 45 F4 66 3B 45 F0 0F B7 C2 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C1 77 2E 8B 4D E8 B3 01 3B CE 74 06 88 01 41 89 4D E8 FF 45 E0 8B CF E8 ?? ?? ?? ?? 8B 8D 40 FF FF FF 66 8B D0 6A 30 66 89 55 F8 58 E9 79 FD FF FF 8B 45 08 8B 00 8B 80 88 00 00 00 8B 00 0F BE 08 0F B7 C2 3B C1 0F 85 D0 02 00 00 8B CF E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 8B 45 10 8B 75 E4 83 C0 08 6A 30 3B D0 66 89 4D F8 58 75 2A 66 3B C8 75 25 8B 75 E0 B3 01 8B CF 4E E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 E9 8B 55 E8 89 75 E0 8B 75 E4 8B BD 40 FF FF FF 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C7 77 26 B3 01 3B D6 74 06 88 02 42 89 55 E8 8B 4D 0C E8 ?? ?? ?? ?? 8B 55 E8 66 8B C8 6A 30 66 89 4D F8 58 E9 81 FD FF FF 84 DB 75 26 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 0F 84 B8 05 00 00 33 C0 84 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 EC 05 00 00 FF 75 F8 8B 75 0C 8B CE E8 ?? ?? ?? ?? 8B 46 10 8B CE 89 45 D8 8B 46 14 89 45 DC E8 ?? ?? ?? ?? 66 89 45 F8 33 DB 0F B7 C0 8A CB 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0B 8A 4D FF EB 06 38 5D FF 0F 94 C1 BF 50 14 00 00 84 C9 0F 84 FC 04 00 00 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 2D 58 66 3B C8 66 89 4D F8 6A 2B 5A 0F 94 C7 66 3B CA 74 05 66 3B C8 75 0E 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 6A 30 33 D2 58 8A DA 66 3B C8 75 1D B3 01 8B CE E8 ?? ?? ?? ?? 66 8B C8 6A 30 58 66 89 4D F8 66 3B C8 74 EA 33 D2 66 3B C8 0F 82 12 02 00 00 66 3B 8D 44 FF FF FF 73 0B 0F B7 C1 83 E8 30 E9 F9 01 00 00 66 3B 4D D4 0F 83 D9 01 00 00 66 3B 4D D0 0F 82 EA 01 00 00 66 3B 4D CC 73 0D 0F B7 C1 2D 60 06 00 00 E9 D2 01 00 00 66 3B 4D C8 0F 82 CD 01 00 00 66 3B 4D C4 73 0D 0F B7 C1 2D F0 06 00 00 E9 B5 01 00 00 66 3B 4D C0 0F 82 B0 01 00 00 66 3B 4D BC 73 0D 0F B7 C1 2D 66 09 00 00 E9 98 01 00 00 66 3B 4D B8 0F 82 93 01 00 00 66 3B 4D B4 73 0D 0F B7 C1 2D E6 09 00 00 E9 7B 01 00 00 66 3B 4D B0 0F 82 76 01 00 00 66 3B 4D AC 73 0D 0F B7 C1 2D 66 0A 00 00 E9 5E 01 00 00 66 3B 4D A8 0F 82 59 01 00 00 66 3B 4D A4 73 0D 0F B7 C1 2D E6 0A 00 00 E9 41 01 00 00 66 3B 4D A0 0F 82 3C 01 00 00 66 3B 4D 9C 73 0D 0F B7 C1 2D 66 0B 00 00 E9 24 01 00 00 66 3B 4D 98 0F 82 1F 01 00 00 66 3B 4D 94 73 0D 0F B7 C1 2D 66 0C 00 00 E9 07 01 00 00 66 3B 4D 90 0F 82 02 01 00 00 66 3B 4D 8C 73 0D 0F B7 C1 2D E6 0C 00 00 E9 EA 00 00 00 66 3B 4D 88 0F 82 E5 00 00 00 66 3B 4D 84 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CD 00 00 00 66 3B 4D 80 0F 82 C8 00 00 00 66 3B 8D 7C FF FF FF 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AD 00 00 00 66 3B 8D 78 FF FF FF 0F 82 A5 00 00 00 66 3B 8D 74 FF FF FF 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8A 00 00 00 66 3B 8D 70 FF FF FF 0F 82 82 00 00 00 66 3B 8D 6C FF FF FF 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6A 66 3B 8D 68 FF FF FF 72 66 66 3B 8D 64 FF FF FF 73 0A 0F B7 C1 2D 40 10 00 00 EB 4E 66 3B 8D 60 FF FF FF 72 4A 66 3B 8D 5C FF FF FF 73 0A 0F B7 C1 2D E0 17 00 00 EB 32 66 3B 8D 58 FF FF FF 72 2E 66 3B 8D 54 FF FF FF 73 25 0F B7 C1 2D 10 18 00 00 EB 16 66 3B 8D 50 FF FF FF 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 3A 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 0A 73 2E 6B D2 0A B3 01 03 D0 89 55 EC 3B D7 7F 19 8B CE E8 ?? ?? ?? ?? 8B 55 EC 66 8B C8 6A 30 66 89 4D F8 58 E9 7F FD FF FF C7 45 EC 51 14 00 00 6A 30 5A 66 3B CA 0F 82 92 01 00 00 66 3B 8D 44 FF FF FF 73 0A 0F B7 C1 2B C2 E9 7A 01 00 00 8B 55 D4 66 3B CA 0F 83 5E 01 00 00 8B 55 D0 66 3B CA 0F 82 67 01 00 00 66 3B 4D CC 72 D8 8B 55 C8 66 3B CA 0F 82 55 01 00 00 66 3B 4D C4 72 C6 8B 55 C0 66 3B CA 0F 82 43 01 00 00 66 3B 4D BC 72 B4 8B 55 B8 66 3B CA 0F 82 31 01 00 00 66 3B 4D B4 72 A2 8B 55 B0 66 3B CA 0F 82 1F 01 00 00 66 3B 4D AC 72 90 8B 55 A8 66 3B CA 0F 82 0D 01 00 00 66 3B 4D A4 0F 82 7A FF FF FF 8B 55 A0 66 3B CA 0F 82 F7 00 00 00 66 3B 4D 9C 0F 82 64 FF FF FF 8B 55 98 66 3B CA 0F 82 E1 00 00 00 66 3B 4D 94 0F 82 4E FF FF FF 8B 55 90 66 3B CA 0F 82 CB 00 00 00 66 3B 4D 8C 0F 82 38 FF FF FF 8B 55 88 66 3B CA 0F 82 B5 00 00 00 66 3B 4D 84 0F 82 22 FF FF FF 8B 55 80 66 3B CA 0F 82 9F 00 00 00 66 3B 8D 7C FF FF FF 0F 82 09 FF FF FF 8B 95 78 FF FF FF 66 3B CA 0F 82 83 00 00 00 66 3B 8D 74 FF FF FF 0F 82 ED FE FF FF 8B 95 70 FF FF FF 66 3B CA 72 6B 66 3B 8D 6C FF FF FF 0F 82 D5 FE FF FF 8B 95 68 FF FF FF 66 3B CA 72 53 66 3B 8D 64 FF FF FF 0F 82 BD FE FF FF 8B 95 60 FF FF FF 66 3B CA 72 3B 66 3B 8D 5C FF FF FF 0F 82 A5 FE FF FF 8B 95 58 FF FF FF 66 3B CA 72 23 66 3B 8D 54 FF FF FF 73 1A E9 8C FE FF FF 66 3B 8D 50 FF FF FF 0F 82 7F FE FF FF 83 C8 FF 83 F8 FF 75 24 66 39 8D 4C FF FF FF 77 09 66 3B 8D 48 FF FF FF 76 2A 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 76 1E 83 C8 FF 83 F8 0A 73 2D 8B CE E8 ?? ?? ?? ?? 66 8B C8 66 89 4D F8 E9 26 FE FF FF 8B 55 F4 66 8B C1 66 2B C2 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB CE 84 FF 74 03 F7 5D EC 84 DB 75 1A 8D 8D 34 FF FF FF E8 ?? ?? ?? ?? 84 C0 74 60 8B CE E8 ?? ?? ?? ?? 66 89 45 F8 8B 5D EC FF 75 F8 8B CE E8 ?? ?? ?? ?? 8B 75 10 8B 4D E8 8D 56 08 3B CA 74 58 80 79 FF 00 75 05 49 3B CA 75 F5 3B CA 74 49 3B DF 7F 24 BF B0 EB FF FF 3B DF 7C 27 33 C0 38 45 FF 0F 94 C0 48 83 E0 03 40 0F AF 45 E0 03 D8 81 FB 50 14 00 00 7E 08 6A 09 EB 1F 6A 07 EB 1B 3B DF 7D 04 6A 08 EB 13 33 C0 89 1E 2B CA 38 45 FF 89 4E 04 0F 95 C0 EB 2A 6A 02 58 EB 25 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? EB 10 FF 75 DC 8D 45 F8 FF 75 D8 57 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_36_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 193
		refs = "0028 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0030 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0039 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0051 ?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 006e ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0076 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00a1 ??R<lambda_2a4fdd323818dc2cff2f25dd401c4574>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 8A 0B 3A 88 ?? ?? ?? ?? 74 08 3A 88 ?? ?? ?? ?? 75 67 8B CF E8 ?? ?? ?? ?? 8A C8 8B 45 FC 40 88 0B 89 45 FC 83 F8 03 75 D7 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 03 8A 03 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 2D 8B CF E8 ?? ?? ?? ?? 46 88 03 83 FE 05 75 DF 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_729_55_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 193
		refs = "0028 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0030 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0039 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0051 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 006e ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0076 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00a1 ??R<lambda_0b87716a0b73cdfba1cd37fcaaa20711>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 8A 0B 3A 88 ?? ?? ?? ?? 74 08 3A 88 ?? ?? ?? ?? 75 67 8B CF E8 ?? ?? ?? ?? 8A C8 8B 45 FC 40 88 0B 89 45 FC 83 F8 03 75 D7 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 03 8A 03 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 2D 8B CF E8 ?? ?? ?? ?? 46 88 03 83 FE 05 75 DF 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_729_56_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 193
		refs = "0028 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0030 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0039 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0051 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 006e ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0076 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00a1 ??R<lambda_644f8ab42ed3fd1d660977a2364b3a7d>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 8A 0B 3A 88 ?? ?? ?? ?? 74 08 3A 88 ?? ?? ?? ?? 75 67 8B CF E8 ?? ?? ?? ?? 8A C8 8B 45 FC 40 88 0B 89 45 FC 83 F8 03 75 D7 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 03 8A 03 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 2D 8B CF E8 ?? ?? ?? ?? 46 88 03 83 FE 05 75 DF 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_23_37_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 207
		refs = "002a ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0033 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0058 ?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0078 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0081 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 00af ??R<lambda_8ab1cb5bdccd73fa737a005aefa23fc8>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 0F B7 0B 66 3B 88 ?? ?? ?? ?? 74 09 66 3B 88 ?? ?? ?? ?? 75 72 8B CF E8 ?? ?? ?? ?? 66 8B C8 8B 45 FC 83 C0 02 66 89 0B 89 45 FC 83 F8 06 75 D0 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 03 0F B7 03 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 30 8B CF E8 ?? ?? ?? ?? 83 C6 02 66 89 03 83 FE 0A 75 D9 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_729_57_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 207
		refs = "002a ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0033 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0058 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0078 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0081 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 00af ??R<lambda_5f3f4d49f9676d963a9a63518de6904a>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 0F B7 0B 66 3B 88 ?? ?? ?? ?? 74 09 66 3B 88 ?? ?? ?? ?? 75 72 8B CF E8 ?? ?? ?? ?? 66 8B C8 8B 45 FC 83 C0 02 66 89 0B 89 45 FC 83 F8 06 75 D0 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 03 0F B7 03 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 30 8B CF E8 ?? ?? ?? ?? 83 C6 02 66 89 03 83 FE 0A 75 D9 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_729_58_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 207
		refs = "002a ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0033 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0058 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0078 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0081 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 00af ??R<lambda_e5165159ec566db3a71156c9b71536ca>@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 8D 45 10 56 33 F6 89 45 F8 57 8B 7D 0C 8B C6 89 7D F0 89 5D F4 89 75 FC 0F B7 0B 66 3B 88 ?? ?? ?? ?? 74 09 66 3B 88 ?? ?? ?? ?? 75 72 8B CF E8 ?? ?? ?? ?? 66 8B C8 8B 45 FC 83 C0 02 66 89 0B 89 45 FC 83 F8 06 75 D0 51 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 03 0F B7 03 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 30 8B CF E8 ?? ?? ?? ?? 83 C6 02 66 89 03 83 FE 0A 75 D9 50 8B CF E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 EB EC 8D 4D F0 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8D 04 8D 03 00 00 00 EB D5 }
	condition:
		$1
}

rule file_23_38_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 274
		refs = "0023 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 002b ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0034 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0044 ?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 0065 ??R<lambda_2ae569978801c347efc54b41596a5e71>@@QBE_NXZ 0096 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z 00a7 ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F4 89 75 F8 89 45 FC 8A 06 3A 83 ?? ?? ?? ?? 74 08 3A 83 ?? ?? ?? ?? 75 4A 8B CF E8 ?? ?? ?? ?? 43 88 06 83 FB 03 75 DF 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 06 3C 28 74 29 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 90 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 6A 07 E9 80 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 88 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 04 6A 05 EB 0F 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 12 6A 06 0F B6 16 8B CF 5B 52 E8 ?? ?? ?? ?? 8B C3 EB 48 80 3E 29 74 40 8A 06 84 C0 74 31 0F BE C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 6F FF FF FF 8B CF E8 ?? ?? ?? ?? 88 06 3C 29 75 C9 80 3E 29 0F 85 59 FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_59_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 274
		refs = "0023 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 002b ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0034 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0044 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 0065 ??R<lambda_e41f1170c8800e4a6fed1afad60fab6f>@@QBE_NXZ 0096 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 00a7 ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F4 89 75 F8 89 45 FC 8A 06 3A 83 ?? ?? ?? ?? 74 08 3A 83 ?? ?? ?? ?? 75 4A 8B CF E8 ?? ?? ?? ?? 43 88 06 83 FB 03 75 DF 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 06 3C 28 74 29 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 90 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 6A 07 E9 80 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 88 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 04 6A 05 EB 0F 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 12 6A 06 0F B6 16 8B CF 5B 52 E8 ?? ?? ?? ?? 8B C3 EB 48 80 3E 29 74 40 8A 06 84 C0 74 31 0F BE C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 6F FF FF FF 8B CF E8 ?? ?? ?? ?? 88 06 3C 29 75 C9 80 3E 29 0F 85 59 FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_60_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 274
		refs = "0023 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 002b ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0034 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 0044 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 0065 ??R<lambda_f1fa4c266c18b246f3ed9c36247dab4f>@@QBE_NXZ 0096 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 00a7 ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F4 89 75 F8 89 45 FC 8A 06 3A 83 ?? ?? ?? ?? 74 08 3A 83 ?? ?? ?? ?? 75 4A 8B CF E8 ?? ?? ?? ?? 43 88 06 83 FB 03 75 DF 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 88 06 3C 28 74 29 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 90 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 6A 07 E9 80 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 88 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 04 6A 05 EB 0F 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 12 6A 06 0F B6 16 8B CF 5B 52 E8 ?? ?? ?? ?? 8B C3 EB 48 80 3E 29 74 40 8A 06 84 C0 74 31 0F BE C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 6F FF FF FF 8B CF E8 ?? ?? ?? ?? 88 06 3C 29 75 C9 80 3E 29 0F 85 59 FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_39_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 300
		refs = "002c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0035 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003e ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0051 ?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0075 ??R<lambda_136dcf69874064575ae1b89ff2a94cd1>@@QBE_NXZ 00a7 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z 00bd ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F0 89 75 F4 89 45 F8 C7 45 FC 06 00 00 00 0F B7 06 66 3B 83 ?? ?? ?? ?? 74 09 66 3B 83 ?? ?? ?? ?? 75 50 8B CF E8 ?? ?? ?? ?? 83 C3 02 66 89 06 83 FB 06 75 D9 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 06 66 83 F8 28 74 29 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 9A 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 E9 8A 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 66 89 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 09 C7 45 FC 05 00 00 00 EB 0D 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 10 0F B7 16 8B CF 52 E8 ?? ?? ?? ?? 8B 45 FC EB 4E 6A 29 5B 66 39 1E 74 43 0F B7 06 66 85 C0 74 32 8B C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 67 FF FF FF 8B CF E8 ?? ?? ?? ?? 66 89 06 66 3B C3 75 C6 66 39 1E 0F 85 4F FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_61_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 300
		refs = "002c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0035 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003e ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0051 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0075 ??R<lambda_46698efe93618fff5274d84d009d2be1>@@QBE_NXZ 00a7 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 00bd ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F0 89 75 F4 89 45 F8 C7 45 FC 06 00 00 00 0F B7 06 66 3B 83 ?? ?? ?? ?? 74 09 66 3B 83 ?? ?? ?? ?? 75 50 8B CF E8 ?? ?? ?? ?? 83 C3 02 66 89 06 83 FB 06 75 D9 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 06 66 83 F8 28 74 29 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 9A 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 E9 8A 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 66 89 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 09 C7 45 FC 05 00 00 00 EB 0D 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 10 0F B7 16 8B CF 52 E8 ?? ?? ?? ?? 8B 45 FC EB 4E 6A 29 5B 66 39 1E 74 43 0F B7 06 66 85 C0 74 32 8B C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 67 FF FF FF 8B CF E8 ?? ?? ?? ?? 66 89 06 66 3B C3 75 C6 66 39 1E 0F 85 4F FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_62_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 300
		refs = "002c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0035 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003e ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0051 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 0075 ??R<lambda_448605b25275ab87d3c5d4aa7a38a0aa>@@QBE_NXZ 00a7 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 00bd ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 DB 89 7D F0 89 75 F4 89 45 F8 C7 45 FC 06 00 00 00 0F B7 06 66 3B 83 ?? ?? ?? ?? 74 09 66 3B 83 ?? ?? ?? ?? 75 50 8B CF E8 ?? ?? ?? ?? 83 C3 02 66 89 06 83 FB 06 75 D9 50 8B CF E8 ?? ?? ?? ?? 8B 47 10 8B CF 89 45 10 8B 47 14 89 45 14 E8 ?? ?? ?? ?? 66 89 06 66 83 F8 28 74 29 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 9A 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 6A 07 E9 8A 00 00 00 8B CF E8 ?? ?? ?? ?? 57 56 66 89 06 E8 ?? ?? ?? ?? 59 59 84 C0 74 09 C7 45 FC 05 00 00 00 EB 0D 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 10 0F B7 16 8B CF 52 E8 ?? ?? ?? ?? 8B 45 FC EB 4E 6A 29 5B 66 39 1E 74 43 0F B7 06 66 85 C0 74 32 8B C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 67 FF FF FF 8B CF E8 ?? ?? ?? ?? 66 89 06 66 3B C3 75 C6 66 39 1E 0F 85 4F FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_40_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 04 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_63_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 04 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_64_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 04 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_23_41_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 08 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_65_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 08 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_66_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 08 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_23_42_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 05 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_67_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 05 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_68_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 58
		refs = "0013 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 001b ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0025 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 8A 07 3A 86 ?? ?? ?? ?? 74 08 3A 86 ?? ?? ?? ?? 75 12 8B 4D 0C E8 ?? ?? ?? ?? 46 88 07 83 FE 05 75 DE B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_23_43_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 0A 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_69_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 0A 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_729_70_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0015 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0028 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 33 DB 57 8B 7D 08 8B F3 0F B7 07 66 3B 86 ?? ?? ?? ?? 74 09 66 3B 86 ?? ?? ?? ?? 75 15 8B 4D 0C E8 ?? ?? ?? ?? 83 C6 02 66 89 07 83 FE 0A 75 D8 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_23_44_0 {
	meta:
		name = "??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z"
		size = 272
		refs = "0014 $LN38 001f ??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z 002e ??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z 00e8 $LN4 00ec $LN5 00f0 $LN6 00f4 $LN7 00f8 $LN8 00fc $LN9 0100 $LN10 0104 $LN11 0108 $LN12 010c $LN13"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 09 0F 87 99 00 00 00 FF 24 85 ?? ?? ?? ?? FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? EB EF 8B 45 0C 33 C9 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 8B 45 10 89 08 33 C0 5D C3 8B 45 0C 33 C9 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 81 C9 00 00 80 7F EB DE 8B 45 0C 33 C9 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 81 C9 FF FF FF 7F EB C5 8B 45 0C 33 C9 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 81 C9 01 00 80 7F EB AC 8B 45 10 C7 00 00 00 C0 FF EB A6 8B 45 10 83 20 00 33 C0 40 5D C3 8B 45 0C 33 C9 6A 02 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 8B 45 10 89 08 58 5D C3 8B 45 0C 33 C9 6A 03 38 88 08 03 00 00 0F 95 C1 C1 E1 1F 81 C9 00 00 80 7F EB DD 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_45_0 {
	meta:
		name = "??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z"
		size = 260
		refs = "0014 $LN21 001f ??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z 002e ??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z 0043 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z 005c ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z 0071 ??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAAN@Z 0086 ??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAAN@Z 0090 ??$assemble_floating_point_ind@N@__crt_strtox@@YAXAAN@Z 00dc $LN4 00e0 $LN5 00e4 $LN6 00e8 $LN7 00ec $LN8 00f0 $LN9 00f4 $LN10 00f8 $LN11 00fc $LN12 0100 $LN13"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 09 0F 87 91 00 00 00 FF 24 85 ?? ?? ?? ?? FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? EB EF 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? 59 59 33 C0 5D C3 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? EB E5 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? EB D0 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? EB BB FF 75 10 E8 ?? ?? ?? ?? EB B2 FF 75 10 6A 00 E8 ?? ?? ?? ?? 59 59 33 C0 40 5D C3 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? 59 59 6A 02 58 5D C3 8B 45 0C FF 75 10 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? 59 59 6A 03 EB E4 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_46_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 691
		refs = "000e ?validate@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 004a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 008f __ischartype_l 0131 ?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 015b __aulldvrm 01ea __allmul 0225 ?restore_state@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0239 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 56 57 E8 ?? ?? ?? ?? 84 C0 74 21 8B 7D 2C 85 FF 74 25 83 FF 02 7C 05 83 FF 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B F0 E9 56 02 00 00 53 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 8D 4D 0C 89 45 F8 8B F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 CB 51 EB 14 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 C3 50 88 5D FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DD 38 45 30 0F 95 C0 89 45 F4 80 FB 2D 75 08 83 C8 02 89 45 F4 EB 05 80 FB 2B 75 0D 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 88 5D FC 83 C9 FF 89 4D F0 85 FF 74 05 83 FF 10 75 7B 8A C3 2C 30 3C 09 77 08 0F BE C3 83 C0 D0 EB 22 8A C3 2C 61 3C 19 77 08 0F BE C3 83 C0 A9 EB 12 8A C3 2C 41 3C 19 77 08 0F BE C3 83 C0 C9 EB 02 8B C1 85 C0 74 09 85 FF 75 41 6A 0A 5F EB 3C 8D 4D 0C E8 ?? ?? ?? ?? 88 45 E8 3C 78 74 18 3C 58 74 14 85 FF 75 03 6A 08 5F FF 75 E8 8D 4D 0C E8 ?? ?? ?? ?? EB 12 85 FF 75 03 6A 10 5F 8D 4D 0C E8 ?? ?? ?? ?? 88 45 FC 83 C9 FF 53 8B C7 99 52 50 51 51 89 45 D8 89 55 DC E8 ?? ?? ?? ?? 89 5D E4 5B 8B 5D F4 89 4D E0 8A 4D FC 89 45 EC 89 55 E8 8A C1 2C 30 3C 09 77 08 0F BE D1 83 C2 D0 EB 23 8A C1 2C 61 3C 19 77 08 0F BE D1 83 C2 A9 EB 13 8A C1 2C 41 3C 19 77 08 0F BE D1 83 C2 C9 EB 03 83 CA FF 89 55 F4 83 FA FF 74 5E 3B D7 73 5A 8B 4D F8 83 CB 08 3B 75 E8 72 25 8B 45 EC 77 04 3B C8 72 1C 3B C8 75 13 3B 75 E8 75 0E 33 C0 3B 45 E4 72 0C 77 05 3B 55 E0 76 05 83 CB 04 EB 18 56 51 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 45 F4 8B F2 89 45 F8 83 D6 00 8D 4D 0C E8 ?? ?? ?? ?? 8A C8 88 4D FC E9 67 FF FF FF FF 75 FC 8D 4D 0C E8 ?? ?? ?? ?? F6 C3 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 F0 8B F0 EB 40 8B 7D F8 56 57 53 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 75 09 83 C8 FF 8B F8 8B F0 EB 26 F6 C3 02 74 0B 83 65 F0 00 BE 00 00 00 80 EB 05 BE FF FF FF 7F 8B 55 F0 EB 0E F6 C3 02 74 07 F7 DF 83 D6 00 F7 DE 8B D7 80 7D CC 00 5B 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 7D 24 85 FF 74 0A 8B 4D 1C 0B 4D 20 75 02 88 07 8B C2 8B D6 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_73_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 691
		refs = "000e ?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 004a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 008f __ischartype_l 0131 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 015b __aulldvrm 01ea __allmul 0225 ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0239 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 56 57 E8 ?? ?? ?? ?? 84 C0 74 21 8B 7D 2C 85 FF 74 25 83 FF 02 7C 05 83 FF 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B F0 E9 56 02 00 00 53 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 8D 4D 0C 89 45 F8 8B F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 CB 51 EB 14 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 C3 50 88 5D FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DD 38 45 30 0F 95 C0 89 45 F4 80 FB 2D 75 08 83 C8 02 89 45 F4 EB 05 80 FB 2B 75 0D 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 88 5D FC 83 C9 FF 89 4D F0 85 FF 74 05 83 FF 10 75 7B 8A C3 2C 30 3C 09 77 08 0F BE C3 83 C0 D0 EB 22 8A C3 2C 61 3C 19 77 08 0F BE C3 83 C0 A9 EB 12 8A C3 2C 41 3C 19 77 08 0F BE C3 83 C0 C9 EB 02 8B C1 85 C0 74 09 85 FF 75 41 6A 0A 5F EB 3C 8D 4D 0C E8 ?? ?? ?? ?? 88 45 E8 3C 78 74 18 3C 58 74 14 85 FF 75 03 6A 08 5F FF 75 E8 8D 4D 0C E8 ?? ?? ?? ?? EB 12 85 FF 75 03 6A 10 5F 8D 4D 0C E8 ?? ?? ?? ?? 88 45 FC 83 C9 FF 53 8B C7 99 52 50 51 51 89 45 D8 89 55 DC E8 ?? ?? ?? ?? 89 5D E4 5B 8B 5D F4 89 4D E0 8A 4D FC 89 45 EC 89 55 E8 8A C1 2C 30 3C 09 77 08 0F BE D1 83 C2 D0 EB 23 8A C1 2C 61 3C 19 77 08 0F BE D1 83 C2 A9 EB 13 8A C1 2C 41 3C 19 77 08 0F BE D1 83 C2 C9 EB 03 83 CA FF 89 55 F4 83 FA FF 74 5E 3B D7 73 5A 8B 4D F8 83 CB 08 3B 75 E8 72 25 8B 45 EC 77 04 3B C8 72 1C 3B C8 75 13 3B 75 E8 75 0E 33 C0 3B 45 E4 72 0C 77 05 3B 55 E0 76 05 83 CB 04 EB 18 56 51 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 45 F4 8B F2 89 45 F8 83 D6 00 8D 4D 0C E8 ?? ?? ?? ?? 8A C8 88 4D FC E9 67 FF FF FF FF 75 FC 8D 4D 0C E8 ?? ?? ?? ?? F6 C3 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 F0 8B F0 EB 40 8B 7D F8 56 57 53 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 75 09 83 C8 FF 8B F8 8B F0 EB 26 F6 C3 02 74 0B 83 65 F0 00 BE 00 00 00 80 EB 05 BE FF FF FF 7F 8B 55 F0 EB 0E F6 C3 02 74 07 F7 DF 83 D6 00 F7 DE 8B D7 80 7D CC 00 5B 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 7D 24 85 FF 74 0A 8B 4D 1C 0B 4D 20 75 02 88 07 8B C2 8B D6 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_75_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 691
		refs = "000e ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 004a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ 008f __ischartype_l 0131 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z 015b __aulldvrm 01ea __allmul 0225 ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0239 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 56 57 E8 ?? ?? ?? ?? 84 C0 74 21 8B 7D 2C 85 FF 74 25 83 FF 02 7C 05 83 FF 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B F0 E9 56 02 00 00 53 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 8D 4D 0C 89 45 F8 8B F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 CB 51 EB 14 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 8D 45 C4 50 6A 08 0F B6 C3 50 88 5D FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DD 38 45 30 0F 95 C0 89 45 F4 80 FB 2D 75 08 83 C8 02 89 45 F4 EB 05 80 FB 2B 75 0D 8D 4D 0C E8 ?? ?? ?? ?? 8A D8 88 5D FC 83 C9 FF 89 4D F0 85 FF 74 05 83 FF 10 75 7B 8A C3 2C 30 3C 09 77 08 0F BE C3 83 C0 D0 EB 22 8A C3 2C 61 3C 19 77 08 0F BE C3 83 C0 A9 EB 12 8A C3 2C 41 3C 19 77 08 0F BE C3 83 C0 C9 EB 02 8B C1 85 C0 74 09 85 FF 75 41 6A 0A 5F EB 3C 8D 4D 0C E8 ?? ?? ?? ?? 88 45 E8 3C 78 74 18 3C 58 74 14 85 FF 75 03 6A 08 5F FF 75 E8 8D 4D 0C E8 ?? ?? ?? ?? EB 12 85 FF 75 03 6A 10 5F 8D 4D 0C E8 ?? ?? ?? ?? 88 45 FC 83 C9 FF 53 8B C7 99 52 50 51 51 89 45 D8 89 55 DC E8 ?? ?? ?? ?? 89 5D E4 5B 8B 5D F4 89 4D E0 8A 4D FC 89 45 EC 89 55 E8 8A C1 2C 30 3C 09 77 08 0F BE D1 83 C2 D0 EB 23 8A C1 2C 61 3C 19 77 08 0F BE D1 83 C2 A9 EB 13 8A C1 2C 41 3C 19 77 08 0F BE D1 83 C2 C9 EB 03 83 CA FF 89 55 F4 83 FA FF 74 5E 3B D7 73 5A 8B 4D F8 83 CB 08 3B 75 E8 72 25 8B 45 EC 77 04 3B C8 72 1C 3B C8 75 13 3B 75 E8 75 0E 33 C0 3B 45 E4 72 0C 77 05 3B 55 E0 76 05 83 CB 04 EB 18 56 51 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 45 F4 8B F2 89 45 F8 83 D6 00 8D 4D 0C E8 ?? ?? ?? ?? 8A C8 88 4D FC E9 67 FF FF FF FF 75 FC 8D 4D 0C E8 ?? ?? ?? ?? F6 C3 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 F0 8B F0 EB 40 8B 7D F8 56 57 53 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 75 09 83 C8 FF 8B F8 8B F0 EB 26 F6 C3 02 74 0B 83 65 F0 00 BE 00 00 00 80 EB 05 BE FF FF FF 7F 8B 55 F0 EB 0E F6 C3 02 74 07 F7 DF 83 D6 00 F7 DE 8B D7 80 7D CC 00 5B 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 7D 24 85 FF 74 0A 8B 4D 1C 0B 4D 20 75 02 88 07 8B C2 8B D6 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_47_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 1537
		refs = "000e ?validate@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 0049 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0070 _iswctype 02ce ?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 02fa __aulldvrm 052d __allmul 056f ?restore_state@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0586 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 53 56 E8 ?? ?? ?? ?? 84 C0 74 21 8B 5D 2C 85 DB 74 25 83 FB 02 7C 05 83 FB 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B D8 E9 A4 05 00 00 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 89 45 F8 89 45 F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 E7 33 C0 38 45 30 0F 95 C0 89 45 FC 66 83 FE 2D 75 08 83 C8 02 89 45 FC EB 06 66 83 FE 2B 75 0B 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 57 6A 30 59 83 CF FF C7 45 E8 3A 00 00 00 89 7D EC B8 10 FF 00 00 6A 19 5A 85 DB 74 09 83 FB 10 0F 85 1F 02 00 00 66 3B F1 0F 82 9A 01 00 00 66 3B 75 E8 73 0A 0F B7 C6 2B C1 E9 86 01 00 00 66 3B F0 0F 83 67 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 73 01 00 00 8D 41 0A 66 3B F0 72 D7 B9 F0 06 00 00 66 3B F1 0F 82 5D 01 00 00 8D 41 0A 66 3B F0 72 C1 B9 66 09 00 00 66 3B F1 0F 82 47 01 00 00 8D 41 0A 66 3B F0 72 AB 8D 48 76 66 3B F1 0F 82 33 01 00 00 8D 41 0A 66 3B F0 72 97 8D 48 76 66 3B F1 0F 82 1F 01 00 00 8D 41 0A 66 3B F0 72 83 8D 48 76 66 3B F1 0F 82 0B 01 00 00 8D 41 0A 66 3B F0 0F 82 6B FF FF FF 8D 48 76 66 3B F1 0F 82 F3 00 00 00 8D 41 0A 66 3B F0 0F 82 53 FF FF FF B9 66 0C 00 00 66 3B F1 0F 82 D9 00 00 00 8D 41 0A 66 3B F0 0F 82 39 FF FF FF 8D 48 76 66 3B F1 0F 82 C1 00 00 00 8D 41 0A 66 3B F0 0F 82 21 FF FF FF 8D 48 76 66 3B F1 0F 82 A9 00 00 00 8D 41 0A 66 3B F0 0F 82 09 FF FF FF B9 50 0E 00 00 66 3B F1 0F 82 8F 00 00 00 8D 41 0A 66 3B F0 0F 82 EF FE FF FF 8D 48 76 66 3B F1 72 7B 8D 41 0A 66 3B F0 0F 82 DB FE FF FF 83 C1 50 66 3B F1 72 67 83 C0 50 66 3B F0 0F 82 C7 FE FF FF B9 40 10 00 00 66 3B F1 72 51 8D 41 0A 66 3B F0 0F 82 B1 FE FF FF B9 E0 17 00 00 66 3B F1 72 3B 8D 41 0A 66 3B F0 0F 82 9B FE FF FF 83 C1 30 66 3B F1 72 27 83 C0 30 66 3B F0 73 1F E9 86 FE FF FF B8 1A FF 00 00 66 3B F0 73 0A 0F B7 C6 2D 10 FF 00 00 EB 02 8B C7 3B C7 75 2D 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 08 8D 46 9F 66 3B C2 77 13 8D 46 9F 66 3B C2 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB 02 8B C7 85 C0 74 0C 85 DB 75 47 6A 0A 5B 89 5D 2C EB 3F 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 1A 83 F8 58 74 15 85 DB 75 06 6A 08 5B 89 5D 2C 50 8D 4D 0C E8 ?? ?? ?? ?? EB 15 85 DB 75 06 6A 10 5B 89 5D 2C 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 8B C3 99 53 8B CA 89 45 D8 51 50 57 57 89 4D DC E8 ?? ?? ?? ?? 89 5D E4 5B 89 45 E8 8B C2 89 4D E0 89 45 F4 6A 30 59 66 3B F1 0F 82 8E 01 00 00 6A 3A 5A 66 3B F2 0F 82 74 01 00 00 B9 10 FF 00 00 66 3B F1 0F 83 5C 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 66 01 00 00 8D 51 0A 66 3B F2 0F 82 4C 01 00 00 B9 F0 06 00 00 66 3B F1 0F 82 4C 01 00 00 8D 51 0A 66 3B F2 0F 82 32 01 00 00 B9 66 09 00 00 66 3B F1 0F 82 32 01 00 00 8D 51 0A 66 3B F2 0F 82 18 01 00 00 8D 4A 76 66 3B F1 0F 82 1A 01 00 00 8D 51 0A 66 3B F2 0F 82 00 01 00 00 8D 4A 76 66 3B F1 0F 82 02 01 00 00 8D 51 0A 66 3B F2 0F 82 E8 00 00 00 8D 4A 76 66 3B F1 0F 82 EA 00 00 00 8D 51 0A 66 3B F2 0F 82 D0 00 00 00 8D 4A 76 66 3B F1 0F 82 D2 00 00 00 8D 51 0A 66 3B F2 0F 82 B8 00 00 00 B9 66 0C 00 00 66 3B F1 0F 82 B8 00 00 00 8D 51 0A 66 3B F2 0F 82 9E 00 00 00 8D 4A 76 66 3B F1 0F 82 A0 00 00 00 8D 51 0A 66 3B F2 0F 82 86 00 00 00 8D 4A 76 66 3B F1 0F 82 88 00 00 00 8D 51 0A 66 3B F2 72 72 B9 50 0E 00 00 66 3B F1 72 76 8D 51 0A 66 3B F2 72 60 8D 4A 76 66 3B F1 72 66 8D 51 0A 66 3B F2 72 50 83 C1 50 66 3B F1 72 56 83 C2 50 66 3B F2 72 40 B9 40 10 00 00 66 3B F1 72 44 8D 51 0A 66 3B F2 72 2E B9 E0 17 00 00 66 3B F1 72 32 8D 51 0A 66 3B F2 72 1C 83 C1 30 66 3B F1 72 22 83 C2 30 66 3B F2 73 1A EB 0A BA 1A FF 00 00 66 3B F2 73 05 0F B7 FE 2B F9 83 C9 FF 3B F9 75 3D 0B F9 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 0D 6A 19 8D 46 9F 59 66 3B C1 77 16 EB 03 6A 19 59 8D 46 9F 0F B7 FE 66 3B C1 77 03 83 EF 20 83 C7 C9 8B 45 F4 83 C9 FF 3B F9 74 72 3B 7D 2C 73 6D 8B 4D FC 8B 5D F0 83 C9 08 89 4D FC 3B D8 72 2B 8B 45 F8 8B 55 E8 77 04 3B C2 72 1F 3B C2 75 13 3B 5D F4 75 0E 33 C0 3B 45 E4 72 0F 77 05 3B 7D E0 76 08 83 C9 04 89 4D FC EB 1C 53 FF 75 F8 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 C7 8B DA 89 45 F8 83 D3 00 89 5D F0 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 83 CF FF 8B 45 F4 E9 B9 FD FF FF 56 8D 4D 0C E8 ?? ?? ?? ?? 8B 45 FC 5F A8 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 EC 8B D8 EB 44 8B 5D F0 8B 75 F8 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 34 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 FC A8 01 75 09 83 C8 FF 8B F0 8B D8 EB 26 A8 02 74 0B 83 65 EC 00 BB 00 00 00 80 EB 05 BB FF FF FF 7F 8B 55 EC EB 0F F6 45 FC 02 74 07 F7 DE 83 D3 00 F7 DB 8B D6 80 7D CC 00 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 75 24 85 F6 74 0A 8B 4D 1C 0B 4D 20 75 02 88 06 8B C2 8B D3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_74_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 1537
		refs = "000e ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 0049 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0070 _iswctype 02ce ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 02fa __aulldvrm 052d __allmul 056f ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0586 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 53 56 E8 ?? ?? ?? ?? 84 C0 74 21 8B 5D 2C 85 DB 74 25 83 FB 02 7C 05 83 FB 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B D8 E9 A4 05 00 00 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 89 45 F8 89 45 F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 E7 33 C0 38 45 30 0F 95 C0 89 45 FC 66 83 FE 2D 75 08 83 C8 02 89 45 FC EB 06 66 83 FE 2B 75 0B 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 57 6A 30 59 83 CF FF C7 45 E8 3A 00 00 00 89 7D EC B8 10 FF 00 00 6A 19 5A 85 DB 74 09 83 FB 10 0F 85 1F 02 00 00 66 3B F1 0F 82 9A 01 00 00 66 3B 75 E8 73 0A 0F B7 C6 2B C1 E9 86 01 00 00 66 3B F0 0F 83 67 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 73 01 00 00 8D 41 0A 66 3B F0 72 D7 B9 F0 06 00 00 66 3B F1 0F 82 5D 01 00 00 8D 41 0A 66 3B F0 72 C1 B9 66 09 00 00 66 3B F1 0F 82 47 01 00 00 8D 41 0A 66 3B F0 72 AB 8D 48 76 66 3B F1 0F 82 33 01 00 00 8D 41 0A 66 3B F0 72 97 8D 48 76 66 3B F1 0F 82 1F 01 00 00 8D 41 0A 66 3B F0 72 83 8D 48 76 66 3B F1 0F 82 0B 01 00 00 8D 41 0A 66 3B F0 0F 82 6B FF FF FF 8D 48 76 66 3B F1 0F 82 F3 00 00 00 8D 41 0A 66 3B F0 0F 82 53 FF FF FF B9 66 0C 00 00 66 3B F1 0F 82 D9 00 00 00 8D 41 0A 66 3B F0 0F 82 39 FF FF FF 8D 48 76 66 3B F1 0F 82 C1 00 00 00 8D 41 0A 66 3B F0 0F 82 21 FF FF FF 8D 48 76 66 3B F1 0F 82 A9 00 00 00 8D 41 0A 66 3B F0 0F 82 09 FF FF FF B9 50 0E 00 00 66 3B F1 0F 82 8F 00 00 00 8D 41 0A 66 3B F0 0F 82 EF FE FF FF 8D 48 76 66 3B F1 72 7B 8D 41 0A 66 3B F0 0F 82 DB FE FF FF 83 C1 50 66 3B F1 72 67 83 C0 50 66 3B F0 0F 82 C7 FE FF FF B9 40 10 00 00 66 3B F1 72 51 8D 41 0A 66 3B F0 0F 82 B1 FE FF FF B9 E0 17 00 00 66 3B F1 72 3B 8D 41 0A 66 3B F0 0F 82 9B FE FF FF 83 C1 30 66 3B F1 72 27 83 C0 30 66 3B F0 73 1F E9 86 FE FF FF B8 1A FF 00 00 66 3B F0 73 0A 0F B7 C6 2D 10 FF 00 00 EB 02 8B C7 3B C7 75 2D 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 08 8D 46 9F 66 3B C2 77 13 8D 46 9F 66 3B C2 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB 02 8B C7 85 C0 74 0C 85 DB 75 47 6A 0A 5B 89 5D 2C EB 3F 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 1A 83 F8 58 74 15 85 DB 75 06 6A 08 5B 89 5D 2C 50 8D 4D 0C E8 ?? ?? ?? ?? EB 15 85 DB 75 06 6A 10 5B 89 5D 2C 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 8B C3 99 53 8B CA 89 45 D8 51 50 57 57 89 4D DC E8 ?? ?? ?? ?? 89 5D E4 5B 89 45 E8 8B C2 89 4D E0 89 45 F4 6A 30 59 66 3B F1 0F 82 8E 01 00 00 6A 3A 5A 66 3B F2 0F 82 74 01 00 00 B9 10 FF 00 00 66 3B F1 0F 83 5C 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 66 01 00 00 8D 51 0A 66 3B F2 0F 82 4C 01 00 00 B9 F0 06 00 00 66 3B F1 0F 82 4C 01 00 00 8D 51 0A 66 3B F2 0F 82 32 01 00 00 B9 66 09 00 00 66 3B F1 0F 82 32 01 00 00 8D 51 0A 66 3B F2 0F 82 18 01 00 00 8D 4A 76 66 3B F1 0F 82 1A 01 00 00 8D 51 0A 66 3B F2 0F 82 00 01 00 00 8D 4A 76 66 3B F1 0F 82 02 01 00 00 8D 51 0A 66 3B F2 0F 82 E8 00 00 00 8D 4A 76 66 3B F1 0F 82 EA 00 00 00 8D 51 0A 66 3B F2 0F 82 D0 00 00 00 8D 4A 76 66 3B F1 0F 82 D2 00 00 00 8D 51 0A 66 3B F2 0F 82 B8 00 00 00 B9 66 0C 00 00 66 3B F1 0F 82 B8 00 00 00 8D 51 0A 66 3B F2 0F 82 9E 00 00 00 8D 4A 76 66 3B F1 0F 82 A0 00 00 00 8D 51 0A 66 3B F2 0F 82 86 00 00 00 8D 4A 76 66 3B F1 0F 82 88 00 00 00 8D 51 0A 66 3B F2 72 72 B9 50 0E 00 00 66 3B F1 72 76 8D 51 0A 66 3B F2 72 60 8D 4A 76 66 3B F1 72 66 8D 51 0A 66 3B F2 72 50 83 C1 50 66 3B F1 72 56 83 C2 50 66 3B F2 72 40 B9 40 10 00 00 66 3B F1 72 44 8D 51 0A 66 3B F2 72 2E B9 E0 17 00 00 66 3B F1 72 32 8D 51 0A 66 3B F2 72 1C 83 C1 30 66 3B F1 72 22 83 C2 30 66 3B F2 73 1A EB 0A BA 1A FF 00 00 66 3B F2 73 05 0F B7 FE 2B F9 83 C9 FF 3B F9 75 3D 0B F9 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 0D 6A 19 8D 46 9F 59 66 3B C1 77 16 EB 03 6A 19 59 8D 46 9F 0F B7 FE 66 3B C1 77 03 83 EF 20 83 C7 C9 8B 45 F4 83 C9 FF 3B F9 74 72 3B 7D 2C 73 6D 8B 4D FC 8B 5D F0 83 C9 08 89 4D FC 3B D8 72 2B 8B 45 F8 8B 55 E8 77 04 3B C2 72 1F 3B C2 75 13 3B 5D F4 75 0E 33 C0 3B 45 E4 72 0F 77 05 3B 7D E0 76 08 83 C9 04 89 4D FC EB 1C 53 FF 75 F8 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 C7 8B DA 89 45 F8 83 D3 00 89 5D F0 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 83 CF FF 8B 45 F4 E9 B9 FD FF FF 56 8D 4D 0C E8 ?? ?? ?? ?? 8B 45 FC 5F A8 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 EC 8B D8 EB 44 8B 5D F0 8B 75 F8 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 34 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 FC A8 01 75 09 83 C8 FF 8B F0 8B D8 EB 26 A8 02 74 0B 83 65 EC 00 BB 00 00 00 80 EB 05 BB FF FF FF 7F 8B 55 EC EB 0F F6 45 FC 02 74 07 F7 DE 83 D3 00 F7 DB 8B D6 80 7D CC 00 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 75 24 85 F6 74 0A 8B 4D 1C 0B 4D 20 75 02 88 06 8B C2 8B D3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_76_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 1537
		refs = "000e ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 0049 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0065 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ 0070 _iswctype 02ce ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z 02fa __aulldvrm 052d __allmul 056f ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z 0586 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 53 56 E8 ?? ?? ?? ?? 84 C0 74 21 8B 5D 2C 85 DB 74 25 83 FB 02 7C 05 83 FB 24 7E 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B D0 8B D8 E9 A4 05 00 00 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 89 45 F8 89 45 F0 8B 45 1C 89 45 D0 8B 45 20 89 45 D4 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 E7 33 C0 38 45 30 0F 95 C0 89 45 FC 66 83 FE 2D 75 08 83 C8 02 89 45 FC EB 06 66 83 FE 2B 75 0B 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 57 6A 30 59 83 CF FF C7 45 E8 3A 00 00 00 89 7D EC B8 10 FF 00 00 6A 19 5A 85 DB 74 09 83 FB 10 0F 85 1F 02 00 00 66 3B F1 0F 82 9A 01 00 00 66 3B 75 E8 73 0A 0F B7 C6 2B C1 E9 86 01 00 00 66 3B F0 0F 83 67 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 73 01 00 00 8D 41 0A 66 3B F0 72 D7 B9 F0 06 00 00 66 3B F1 0F 82 5D 01 00 00 8D 41 0A 66 3B F0 72 C1 B9 66 09 00 00 66 3B F1 0F 82 47 01 00 00 8D 41 0A 66 3B F0 72 AB 8D 48 76 66 3B F1 0F 82 33 01 00 00 8D 41 0A 66 3B F0 72 97 8D 48 76 66 3B F1 0F 82 1F 01 00 00 8D 41 0A 66 3B F0 72 83 8D 48 76 66 3B F1 0F 82 0B 01 00 00 8D 41 0A 66 3B F0 0F 82 6B FF FF FF 8D 48 76 66 3B F1 0F 82 F3 00 00 00 8D 41 0A 66 3B F0 0F 82 53 FF FF FF B9 66 0C 00 00 66 3B F1 0F 82 D9 00 00 00 8D 41 0A 66 3B F0 0F 82 39 FF FF FF 8D 48 76 66 3B F1 0F 82 C1 00 00 00 8D 41 0A 66 3B F0 0F 82 21 FF FF FF 8D 48 76 66 3B F1 0F 82 A9 00 00 00 8D 41 0A 66 3B F0 0F 82 09 FF FF FF B9 50 0E 00 00 66 3B F1 0F 82 8F 00 00 00 8D 41 0A 66 3B F0 0F 82 EF FE FF FF 8D 48 76 66 3B F1 72 7B 8D 41 0A 66 3B F0 0F 82 DB FE FF FF 83 C1 50 66 3B F1 72 67 83 C0 50 66 3B F0 0F 82 C7 FE FF FF B9 40 10 00 00 66 3B F1 72 51 8D 41 0A 66 3B F0 0F 82 B1 FE FF FF B9 E0 17 00 00 66 3B F1 72 3B 8D 41 0A 66 3B F0 0F 82 9B FE FF FF 83 C1 30 66 3B F1 72 27 83 C0 30 66 3B F0 73 1F E9 86 FE FF FF B8 1A FF 00 00 66 3B F0 73 0A 0F B7 C6 2D 10 FF 00 00 EB 02 8B C7 3B C7 75 2D 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 08 8D 46 9F 66 3B C2 77 13 8D 46 9F 66 3B C2 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB 02 8B C7 85 C0 74 0C 85 DB 75 47 6A 0A 5B 89 5D 2C EB 3F 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 C0 83 F8 78 74 1A 83 F8 58 74 15 85 DB 75 06 6A 08 5B 89 5D 2C 50 8D 4D 0C E8 ?? ?? ?? ?? EB 15 85 DB 75 06 6A 10 5B 89 5D 2C 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 8B C3 99 53 8B CA 89 45 D8 51 50 57 57 89 4D DC E8 ?? ?? ?? ?? 89 5D E4 5B 89 45 E8 8B C2 89 4D E0 89 45 F4 6A 30 59 66 3B F1 0F 82 8E 01 00 00 6A 3A 5A 66 3B F2 0F 82 74 01 00 00 B9 10 FF 00 00 66 3B F1 0F 83 5C 01 00 00 B9 60 06 00 00 66 3B F1 0F 82 66 01 00 00 8D 51 0A 66 3B F2 0F 82 4C 01 00 00 B9 F0 06 00 00 66 3B F1 0F 82 4C 01 00 00 8D 51 0A 66 3B F2 0F 82 32 01 00 00 B9 66 09 00 00 66 3B F1 0F 82 32 01 00 00 8D 51 0A 66 3B F2 0F 82 18 01 00 00 8D 4A 76 66 3B F1 0F 82 1A 01 00 00 8D 51 0A 66 3B F2 0F 82 00 01 00 00 8D 4A 76 66 3B F1 0F 82 02 01 00 00 8D 51 0A 66 3B F2 0F 82 E8 00 00 00 8D 4A 76 66 3B F1 0F 82 EA 00 00 00 8D 51 0A 66 3B F2 0F 82 D0 00 00 00 8D 4A 76 66 3B F1 0F 82 D2 00 00 00 8D 51 0A 66 3B F2 0F 82 B8 00 00 00 B9 66 0C 00 00 66 3B F1 0F 82 B8 00 00 00 8D 51 0A 66 3B F2 0F 82 9E 00 00 00 8D 4A 76 66 3B F1 0F 82 A0 00 00 00 8D 51 0A 66 3B F2 0F 82 86 00 00 00 8D 4A 76 66 3B F1 0F 82 88 00 00 00 8D 51 0A 66 3B F2 72 72 B9 50 0E 00 00 66 3B F1 72 76 8D 51 0A 66 3B F2 72 60 8D 4A 76 66 3B F1 72 66 8D 51 0A 66 3B F2 72 50 83 C1 50 66 3B F1 72 56 83 C2 50 66 3B F2 72 40 B9 40 10 00 00 66 3B F1 72 44 8D 51 0A 66 3B F2 72 2E B9 E0 17 00 00 66 3B F1 72 32 8D 51 0A 66 3B F2 72 1C 83 C1 30 66 3B F1 72 22 83 C2 30 66 3B F2 73 1A EB 0A BA 1A FF 00 00 66 3B F2 73 05 0F B7 FE 2B F9 83 C9 FF 3B F9 75 3D 0B F9 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 0D 6A 19 8D 46 9F 59 66 3B C1 77 16 EB 03 6A 19 59 8D 46 9F 0F B7 FE 66 3B C1 77 03 83 EF 20 83 C7 C9 8B 45 F4 83 C9 FF 3B F9 74 72 3B 7D 2C 73 6D 8B 4D FC 8B 5D F0 83 C9 08 89 4D FC 3B D8 72 2B 8B 45 F8 8B 55 E8 77 04 3B C2 72 1F 3B C2 75 13 3B 5D F4 75 0E 33 C0 3B 45 E4 72 0F 77 05 3B 7D E0 76 08 83 C9 04 89 4D FC EB 1C 53 FF 75 F8 FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 03 C7 8B DA 89 45 F8 83 D3 00 89 5D F0 8D 4D 0C E8 ?? ?? ?? ?? 0F B7 F0 83 CF FF 8B 45 F4 E9 B9 FD FF FF 56 8D 4D 0C E8 ?? ?? ?? ?? 8B 45 FC 5F A8 08 75 17 FF 75 D4 8D 4D 0C FF 75 D0 E8 ?? ?? ?? ?? 33 C0 89 45 EC 8B D8 EB 44 8B 5D F0 8B 75 F8 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 34 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 FC A8 01 75 09 83 C8 FF 8B F0 8B D8 EB 26 A8 02 74 0B 83 65 EC 00 BB 00 00 00 80 EB 05 BB FF FF FF 7F 8B 55 EC EB 0F F6 45 FC 02 74 07 F7 DE 83 D3 00 F7 DB 8B D6 80 7D CC 00 74 0A 8B 45 C0 83 A0 50 03 00 00 FD 33 C0 8B 75 24 85 F6 74 0A 8B 4D 1C 0B 4D 20 75 02 88 06 8B C2 8B D3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_48_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0029 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 2A 8B 5D 08 8B 75 0C 2B DE 8B 45 14 8A 00 3A 04 33 74 04 3A 06 75 1B 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 46 88 01 3B 7D 10 75 DE B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_729_77_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0029 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 2A 8B 5D 08 8B 75 0C 2B DE 8B 45 14 8A 00 3A 04 33 74 04 3A 06 75 1B 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 46 88 01 3B 7D 10 75 DE B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_729_78_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0029 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 2A 8B 5D 08 8B 75 0C 2B DE 8B 45 14 8A 00 3A 04 33 74 04 3A 06 75 1B 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 46 88 01 3B 7D 10 75 DE B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_23_49_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 74
		refs = "002c ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 30 8B 5D 08 8B 75 0C 2B DE 8B 45 14 0F B7 00 66 3B 04 33 74 05 66 3B 06 75 1E 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 83 C6 02 66 89 01 3B 7D 10 75 D8 B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_729_79_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 74
		refs = "002c ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 30 8B 5D 08 8B 75 0C 2B DE 8B 45 14 0F B7 00 66 3B 04 33 74 05 66 3B 06 75 1E 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 83 C6 02 66 89 01 3B 7D 10 75 D8 B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_729_80_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 74
		refs = "002c ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 30 8B 5D 08 8B 75 0C 2B DE 8B 45 14 0F B7 00 66 3B 04 33 74 05 66 3B 06 75 1E 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 14 47 83 C6 02 66 89 01 3B 7D 10 75 D8 B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_23_50_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAM@Z 005b ??$write_floating_point@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 EE 8D 45 F8 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC D9 5D F8 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 26 00 74 04 B0 01 EB 0F 8D 45 F8 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_81_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAM@Z 005b ??$write_floating_point@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 EE 8D 45 F8 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC D9 5D F8 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 26 00 74 04 B0 01 EB 0F 8D 45 F8 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_51_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z 005b ??$write_floating_point@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 EE 8D 45 F8 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC D9 5D F8 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 28 00 74 04 B0 01 EB 0F 8D 45 F8 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_83_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z 005b ??$write_floating_point@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 EE 8D 45 F8 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC D9 5D F8 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 28 00 74 04 B0 01 EB 0F 8D 45 F8 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_52_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAN@Z 005b ??$write_floating_point@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 D9 EE 8D 45 F0 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC DD 5D F0 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 26 00 74 04 B0 01 EB 0F 8D 45 F0 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_85_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAN@Z 005b ??$write_floating_point@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 D9 EE 8D 45 F0 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC DD 5D F0 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 26 00 74 04 B0 01 EB 0F 8D 45 F0 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_53_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z 005b ??$write_floating_point@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 D9 EE 8D 45 F0 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC DD 5D F0 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 28 00 74 04 B0 01 EB 0F 8D 45 F0 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_729_87_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 104
		refs = "002d ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0038 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z 005b ??$write_floating_point@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 D9 EE 8D 45 F0 56 50 83 EC 20 C6 45 FF 00 8B F1 8D 45 FF 8B CC DD 5D F0 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 28 80 7D FF 00 74 1C 83 F8 01 74 17 80 7E 28 00 74 04 B0 01 EB 0F 8D 45 F0 8B CE 50 E8 ?? ?? ?? ?? EB 02 32 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_54_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
		size = 370
		refs = "0023 __errno 002e __invalid_parameter_noinfo 005f __getche_nolock 00d1 ?is_character_allowed_in_string@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@H@Z 011f __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 26 75 3A 83 46 64 04 8B 4E 64 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 30 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 64 8B 78 FC EB 03 83 CF FF 85 FF 75 26 8B 06 83 E0 04 0B C7 74 10 E8 ?? ?? ?? ?? 83 F8 FF 74 03 FF 46 08 C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B7 83 7D 08 00 8B 46 28 89 45 F0 8B 46 2C 89 45 EC 89 5D E8 89 7D F4 74 0B 83 FF FF 74 06 8D 47 FF 89 45 F4 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D FC 89 55 F8 74 0A 3B 55 F0 75 05 3B 4D EC 74 70 E8 ?? ?? ?? ?? 89 45 E4 83 F8 FF 74 03 FF 46 08 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 74 39 80 7E 26 00 75 17 8B 4D F4 85 C9 74 1E 8B 55 E8 8B 45 E4 88 02 42 49 89 55 E8 89 4D F4 8B 55 F8 8B 4D FC 83 C2 01 83 D1 00 EB 9E 83 FF FF 0F 84 61 FF FF FF E9 59 FF FF FF 8B 45 E4 83 F8 FF 74 0A FF 4E 08 50 E8 ?? ?? ?? ?? 59 8B 55 F8 8B 4D FC 8B C2 0B C1 0F 84 FE FE FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 E0 FE FF FF 80 7E 26 00 75 0F 83 7D 08 00 74 06 8B 45 E8 C6 00 00 FF 46 68 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_55_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
		size = 363
		refs = "0023 __errno 002e __invalid_parameter_noinfo 0062 ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ 00ca ?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z 00ee ?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAI_W@Z 0119 ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 28 75 3A 83 46 4C 04 8B 4E 4C 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 29 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 4C 8B 78 FC EB 03 83 CF FF 85 FF 75 21 8B 06 83 E0 04 0B C7 74 0B 8D 4E 08 E8 ?? ?? ?? ?? C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BC 83 7D 08 00 8B 46 30 89 45 F0 8B 46 34 89 45 EC 89 5D E4 89 7D F4 74 0B 83 FF FF 74 06 8D 47 FF 89 45 F4 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D FC 89 55 F8 74 0A 3B 55 F0 75 05 3B 4D EC 74 6E 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 8B CE 50 FF 75 08 89 45 E8 E8 ?? ?? ?? ?? 84 C0 74 40 80 7E 28 00 75 1E 83 7D F4 00 74 26 FF 75 E8 8D 45 F4 8B CE 50 8D 45 E4 50 57 53 E8 ?? ?? ?? ?? 84 C0 74 27 8B 55 F8 8B 4D FC 83 C2 01 83 D1 00 EB 99 83 FF FF 0F 84 5C FF FF FF E9 54 FF FF FF FF 75 E8 8D 4E 08 E8 ?? ?? ?? ?? 8B 55 F8 8B 4D FC 8B C2 0B C1 0F 84 05 FF FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 E7 FE FF FF 80 7E 28 00 75 0F 83 7D 08 00 74 06 8B 45 E4 C6 00 00 FF 46 50 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_729_91_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
		size = 363
		refs = "0023 __errno 002e __invalid_parameter_noinfo 0062 ?get@?$stream_input_adapter@_W@__crt_stdio_input@@QAEGXZ 00ca ?is_character_allowed_in_string@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z 00ee ?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAI_W@Z 0119 ?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 28 75 3A 83 46 4C 04 8B 4E 4C 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 29 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 4C 8B 78 FC EB 03 83 CF FF 85 FF 75 21 8B 06 83 E0 04 0B C7 74 0B 8D 4E 08 E8 ?? ?? ?? ?? C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BC 83 7D 08 00 8B 46 30 89 45 F0 8B 46 34 89 45 EC 89 5D E4 89 7D F4 74 0B 83 FF FF 74 06 8D 47 FF 89 45 F4 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D FC 89 55 F8 74 0A 3B 55 F0 75 05 3B 4D EC 74 6E 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 8B CE 50 FF 75 08 89 45 E8 E8 ?? ?? ?? ?? 84 C0 74 40 80 7E 28 00 75 1E 83 7D F4 00 74 26 FF 75 E8 8D 45 F4 8B CE 50 8D 45 E4 50 57 53 E8 ?? ?? ?? ?? 84 C0 74 27 8B 55 F8 8B 4D FC 83 C2 01 83 D1 00 EB 99 83 FF FF 0F 84 5C FF FF FF E9 54 FF FF FF FF 75 E8 8D 4E 08 E8 ?? ?? ?? ?? 8B 55 F8 8B 4D FC 8B C2 0B C1 0F 84 05 FF FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 E7 FE FF FF 80 7E 28 00 75 0F 83 7D 08 00 74 06 8B 45 E4 C6 00 00 FF 46 50 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_56_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z"
		size = 382
		refs = "0023 __errno 002e __invalid_parameter_noinfo 005f __getche_nolock 00d3 ?is_character_allowed_in_string@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@H@Z 00f8 ?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQA_WIAAPA_WAAID@Z 0129 __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 26 75 3A 83 46 64 04 8B 4E 64 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 3C 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 64 8B 78 FC EB 03 83 CF FF 85 FF 75 28 8B 06 83 E0 04 0B C7 74 12 E8 ?? ?? ?? ?? 83 F8 FF 74 03 FF 46 08 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B5 83 7D 08 00 8B 46 28 89 45 F0 8B 46 2C 89 45 EC 89 5D E4 89 7D F4 74 0B 83 FF FF 74 06 8D 47 FF 89 45 F4 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D FC 89 55 F8 74 0A 3B 55 F0 75 05 3B 4D EC 74 78 E8 ?? ?? ?? ?? 89 45 E8 83 F8 FF 74 03 FF 46 08 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 74 41 80 7E 26 00 75 1F 83 7D F4 00 74 27 8B 45 E8 8B CE 50 8D 45 F4 50 8D 45 E4 50 57 53 E8 ?? ?? ?? ?? 84 C0 74 2E 8B 55 F8 8B 4D FC 83 C2 01 83 D1 00 EB 96 83 FF FF 0F 84 59 FF FF FF E9 4F FF FF FF 8B 45 E8 83 F8 FF 74 0A FF 4E 08 50 E8 ?? ?? ?? ?? 59 8B 4D FC 8B 55 F8 8B C2 0B C1 0F 84 F4 FE FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 D6 FE FF FF 80 7E 26 00 75 11 83 7D 08 00 74 08 8B 45 E4 33 C9 66 89 08 FF 46 68 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_57_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z"
		size = 364
		refs = "0023 __errno 002e __invalid_parameter_noinfo 0062 ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ 00cc ?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z 0118 ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 28 75 3A 83 46 4C 04 8B 4E 4C 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 2A 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 4C 8B 78 FC EB 03 83 CF FF 85 FF 75 23 8B 06 83 E0 04 0B C7 74 0D 8D 4E 08 E8 ?? ?? ?? ?? 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BA 83 7D 08 00 8B 46 30 89 45 F0 8B 46 34 89 45 EC 89 5D E8 89 7D FC 74 0B 83 FF FF 74 06 8D 47 FF 89 45 FC 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D F8 89 55 F4 74 0A 3B 55 F0 75 05 3B 4D EC 74 6B 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 8B CE 50 FF 75 08 89 45 E4 E8 ?? ?? ?? ?? 84 C0 74 3C 80 7E 28 00 75 1A 8B 45 FC 85 C0 74 21 8B 4D E8 8B 55 E4 66 89 11 83 C1 02 48 89 4D E8 89 45 FC 8B 55 F4 8B 4D F8 83 C2 01 83 D1 00 EB 9D 83 FF FF 0F 84 60 FF FF FF E9 56 FF FF FF 8B 55 E4 8D 4E 08 52 E8 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B C2 0B C1 0F 84 06 FF FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 E8 FE FF FF 80 7E 28 00 75 11 83 7D 08 00 74 08 8B 45 E8 33 C9 66 89 08 FF 46 50 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_729_95_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z"
		size = 364
		refs = "0023 __errno 002e __invalid_parameter_noinfo 0062 ?get@?$stream_input_adapter@_W@__crt_stdio_input@@QAEGXZ 00cc ?is_character_allowed_in_string@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z 0118 ?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B F1 33 DB 57 38 5E 28 75 3A 83 46 4C 04 8B 4E 4C 8B 59 FC 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 2A 01 00 00 8B 06 83 E0 01 83 C8 00 74 0B 8D 41 04 89 46 4C 8B 78 FC EB 03 83 CF FF 85 FF 75 23 8B 06 83 E0 04 0B C7 74 0D 8D 4E 08 E8 ?? ?? ?? ?? 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BA 83 7D 08 00 8B 46 30 89 45 F0 8B 46 34 89 45 EC 89 5D E8 89 7D FC 74 0B 83 FF FF 74 06 8D 47 FF 89 45 FC 33 D2 33 C9 8B 45 F0 0B 45 EC 89 4D F8 89 55 F4 74 0A 3B 55 F0 75 05 3B 4D EC 74 6B 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 8B CE 50 FF 75 08 89 45 E4 E8 ?? ?? ?? ?? 84 C0 74 3C 80 7E 28 00 75 1A 8B 45 FC 85 C0 74 21 8B 4D E8 8B 55 E4 66 89 11 83 C1 02 48 89 4D E8 89 45 FC 8B 55 F4 8B 4D F8 83 C2 01 83 D1 00 EB 9D 83 FF FF 0F 84 60 FF FF FF E9 56 FF FF FF 8B 55 E4 8D 4E 08 52 E8 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B C2 0B C1 0F 84 06 FF FF FF 83 7D 08 00 75 18 3B 55 F0 75 05 3B 4D EC 74 0E 8B 06 83 E0 04 83 C8 00 0F 84 E8 FE FF FF 80 7E 28 00 75 11 83 7D 08 00 74 08 8B 45 E8 33 C9 66 89 08 FF 46 50 B0 01 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_58_0 {
	meta:
		name = "??$reset_buffer@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z"
		size = 19
		altNames = "??$reset_buffer@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z ??$reset_buffer@D@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z ??$reset_buffer@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z ??$reset_buffer@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z ??$reset_buffer@D@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQADI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C FF 74 06 8B 45 08 C6 00 00 5D C3 }
	condition:
		$1
}

rule file_23_60_0 {
	meta:
		name = "??$reset_buffer@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z"
		size = 21
		altNames = "??$reset_buffer@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z ??$reset_buffer@_W@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQA_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C FF 74 08 8B 45 08 33 C9 66 89 08 5D C3 }
	condition:
		$1
}

rule file_23_62_0 {
	meta:
		name = "??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z"
		size = 51
		refs = "000b __getche_nolock 0022 __ischartype_l"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 17 FF 75 0C FF 06 0F B6 CB 6A 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DD 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_23_63_0 {
	meta:
		name = "??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z"
		size = 47
		refs = "000a ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ 001f _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 4D 08 E8 ?? ?? ?? ?? 0F B7 F0 B8 FF FF 00 00 66 3B F0 74 0E 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 DD 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_729_106_0 {
	meta:
		name = "??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$stream_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z"
		size = 47
		refs = "000a ?get@?$stream_input_adapter@_W@__crt_stdio_input@@QAEGXZ 001f _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 4D 08 E8 ?? ?? ?? ?? 0F B7 F0 B8 FF FF 00 00 66 3B F0 74 0E 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 DD 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_729_108_0 {
	meta:
		name = "??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$string_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z"
		size = 47
		refs = "000a ?get@?$string_input_adapter@_W@__crt_stdio_input@@QAEGXZ 001f _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 4D 08 E8 ?? ?? ?? ?? 0F B7 F0 B8 FF FF 00 00 66 3B F0 74 0E 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 DD 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_23_64_0 {
	meta:
		name = "??$tcstoull@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SA_KAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstoull"
		altNames = "??$tcstoull@ABQA_W$$TH@?$__crt_char_traits@_W@@SA_KABQA_W$$QA$$T$$QAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_679_2_4 {
	meta:
		name = "??$lseek_nolock@ABHABJH@?$__crt_integer_traits@J@@SAJABHABJ$$QAH@Z"
		size = 30
		refs = "0015 __lseek_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_679_4_3 {
	meta:
		name = "??$lseek_nolock@ABHHH@?$__crt_integer_traits@J@@SAJABH$$QAH1@Z"
		size = 30
		refs = "0015 __lseek_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_718_12_3 {
	meta:
		name = "??$tasctime_s@ABQADABIPAUtm@@@?$__crt_char_traits@D@@SAHABQADABI$$QAPAUtm@@@Z"
		size = 30
		refs = "0015 _asctime_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_718_13_2 {
	meta:
		name = "??$tasctime_s@ABQA_WABIPAUtm@@@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPAUtm@@@Z"
		size = 30
		refs = "0015 __wasctime_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_15_3 {
	meta:
		name = "??$tcscat_s@AAPADABIPAD@?$__crt_char_traits@D@@SAHAAPADABI$$QAPAD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_5_4 {
	meta:
		name = "??$tcscat_s@AAPADHABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHABQBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_17_0 {
	meta:
		name = "??$tcscat_s@AAPA_WABIPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI$$QAPA_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_7_0 {
	meta:
		name = "??$tcscat_s@AAPA_WHABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_19_3 {
	meta:
		name = "??$tcscat_s@ABQADABIAAPAD@?$__crt_char_traits@D@@SAHABQADABIAAPAD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_20_3 {
	meta:
		name = "??$tcscat_s@ABQADABIABQBD@?$__crt_char_traits@D@@SAHABQADABIABQBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_21_3 {
	meta:
		name = "??$tcscat_s@ABQADABIPBD@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_22_4 {
	meta:
		name = "??$tcscat_s@ABQA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAPA_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_23_4 {
	meta:
		name = "??$tcscat_s@ABQA_WABIABQB_W@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_24_4 {
	meta:
		name = "??$tcscat_s@ABQA_WABIPB_W@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_20_3 {
	meta:
		name = "??$tcscat_s@PADABIAAPBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_22_0 {
	meta:
		name = "??$tcscat_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_24_2 {
	meta:
		name = "??$tcscat_s@PADHABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHABQBD@Z"
		size = 30
		refs = "0015 _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_23_4 {
	meta:
		name = "??$tcscat_s@PA_WABIAAPB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_25_0 {
	meta:
		name = "??$tcscat_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_28_0 {
	meta:
		name = "??$tcscat_s@PA_WHABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_18_0 {
	meta:
		name = "??$tcscpy_s@AAPADAAIABQBD@?$__crt_char_traits@D@@SAHAAPADAAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_187_18_2 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAPAD@?$__crt_char_traits@D@@SAHAAPADABI0@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_333_16_4 {
	meta:
		name = "??$tcscpy_s@AAPADABIABQAD@?$__crt_char_traits@D@@SAHAAPADABIABQAD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_378_14_2 {
	meta:
		name = "??$tcscpy_s@AAPADABIABQBD@?$__crt_char_traits@D@@SAHAAPADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_8_2 {
	meta:
		name = "??$tcscpy_s@AAPADIABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_21_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WAAIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WAAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_187_19_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI0@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_333_17_3 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIABQA_W@?$__crt_char_traits@_W@@SAHAAPA_WABIABQA_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_378_15_3 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_9_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_10_3 {
	meta:
		name = "??$tcscpy_s@ABQADABIAAPAD@?$__crt_char_traits@D@@SAHABQADABIAAPAD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_333_18_3 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQAD@?$__crt_char_traits@D@@SAHABQADABI0@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_378_16_4 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQBD@?$__crt_char_traits@D@@SAHABQADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_27_2 {
	meta:
		name = "??$tcscpy_s@ABQADABIPBD@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_11_3 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAPA_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_333_19_2 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQA_W@?$__crt_char_traits@_W@@SAHABQA_WABI0@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_615_13_3 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQB_W@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_681_28_2 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIPB_W@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_588_22_4 {
	meta:
		name = "??$tcscpy_s@PADABIAAPAD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPAD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_21_2 {
	meta:
		name = "??$tcscpy_s@PADABIAAPBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_676_16_0 {
	meta:
		name = "??$tcscpy_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_676_17_0 {
	meta:
		name = "??$tcscpy_s@PADIABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_588_23_4 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPA_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPA_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_23_2 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_30_4 {
	meta:
		name = "??$tcscpy_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_676_19_3 {
	meta:
		name = "??$tcscpy_s@PA_WIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_615_14_3 {
	meta:
		name = "??$tcserror_s@PADIABH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABH@Z"
		size = 30
		refs = "0015 _strerror_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_615_15_0 {
	meta:
		name = "??$tcserror_s@PA_WIABH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABH@Z"
		size = 30
		refs = "0015 __wcserror_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_378_22_4 {
	meta:
		name = "??$tcsnicoll@AAPADABQBDABI@?$__crt_char_traits@D@@SAHAAPADABQBDABI@Z"
		size = 30
		refs = "0015 __strnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_378_23_4 {
	meta:
		name = "??$tcsnicoll@AAPA_WABQB_WABI@?$__crt_char_traits@_W@@SAHAAPA_WABQB_WABI@Z"
		size = 30
		refs = "0015 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_187_26_0 {
	meta:
		name = "??$tcsnicoll@ABQBDAAPADABI@?$__crt_char_traits@D@@SAHABQBDAAPADABI@Z"
		size = 30
		refs = "0015 __strnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_187_27_0 {
	meta:
		name = "??$tcsnicoll@ABQB_WAAPA_WABI@?$__crt_char_traits@_W@@SAHABQB_WAAPA_WABI@Z"
		size = 30
		refs = "0015 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_273_128_0 {
	meta:
		name = "??$tcstol@AAPBDPAPADH@?$__crt_char_traits@D@@SAJAAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_248_238_0 {
	meta:
		name = "??$tcstol@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SAJAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_273_130_3 {
	meta:
		name = "??$tcstol@PBDPAPADH@?$__crt_char_traits@D@@SAJ$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_248_240_3 {
	meta:
		name = "??$tcstol@PB_WPAPA_WH@?$__crt_char_traits@_W@@SAJ$$QAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_333_26_4 {
	meta:
		name = "??$tcstoull@ABQAD$$TH@?$__crt_char_traits@D@@SA_KABQAD$$QA$$T$$QAH@Z"
		size = 30
		refs = "0015 _strtoull"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_23_65_0 {
	meta:
		name = "??$tcstoull@PBDPAPADH@?$__crt_char_traits@D@@SA_K$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtoull"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_18_4 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TABQBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TABQBD@Z"
		size = 30
		refs = "0015 __dupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_19_4 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TABQB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TABQB_W@Z"
		size = 30
		refs = "0015 __wdupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_20_3 {
	meta:
		name = "??$tfullpath@ABQADABQBDABI@?$__crt_char_traits@D@@SAPADABQADABQBDABI@Z"
		size = 30
		refs = "0015 __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_21_2 {
	meta:
		name = "??$tfullpath@ABQA_WABQB_WABI@?$__crt_char_traits@_W@@SAPA_WABQA_WABQB_WABI@Z"
		size = 30
		refs = "0015 __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_22_2 {
	meta:
		name = "??$tgetpath@AAPADAAPADH@?$__crt_char_traits@D@@SAPADAAPAD0$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_22_2 {
	meta:
		name = "??$tgetpath@AAPADAAPADI@?$__crt_char_traits@D@@SAPADAAPAD0$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_23_4 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_23_2 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_43_3 {
	meta:
		name = "??$tgetpath@AAPBDPADH@?$__crt_char_traits@D@@SAPADAAPBD$$QAPAD$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_44_3 {
	meta:
		name = "??$tgetpath@AAPB_WPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPB_W$$QAPA_W$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_24_2 {
	meta:
		name = "??$tgetpath@ABQADAAPADI@?$__crt_char_traits@D@@SAPADABQADAAPAD$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_723_25_3 {
	meta:
		name = "??$tgetpath@ABQA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WABQA_WAAPA_W$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_23_66_0 {
	meta:
		name = "??$ungettch_nolock@ABG@?$__crt_char_traits@_W@@SAGABG@Z"
		size = 20
		refs = "000d __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_273_107_0 {
	meta:
		name = "??$puttch_nolock@AB_W@?$__crt_char_traits@_W@@SAGAB_W@Z"
		size = 20
		refs = "000d __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_23_67_0 {
	meta:
		name = "??$ungettch_nolock@ABH@?$__crt_char_traits@D@@SAHABH@Z"
		size = 18
		refs = "000b __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_237_3_0 {
	meta:
		name = "??$getc_nolock@PAU_iobuf@@@?$__crt_char_traits@D@@SAH$$QAPAU_iobuf@@@Z"
		size = 18
		refs = "000b __getc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_729_35_3 {
	meta:
		name = "??$getc_nolock@PAU_iobuf@@@?$__crt_char_traits@_W@@SAG$$QAPAU_iobuf@@@Z"
		size = 18
		refs = "000b __getwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_718_10_3 {
	meta:
		name = "??$tasctime@PAUtm@@@?$__crt_char_traits@D@@SAPAD$$QAPAUtm@@@Z"
		size = 18
		refs = "000b _asctime"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_718_11_3 {
	meta:
		name = "??$tasctime@PAUtm@@@?$__crt_char_traits@_W@@SAPA_W$$QAPAUtm@@@Z"
		size = 18
		refs = "000b __wasctime"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_719_10_2 {
	meta:
		name = "??$time@PAJ@?$__crt_integer_traits@J@@SAJ$$QAPAJ@Z"
		size = 18
		refs = "000b __time32"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_719_11_0 {
	meta:
		name = "??$time@PA_J@?$__crt_integer_traits@_J@@SA_J$$QAPA_J@Z"
		size = 18
		refs = "000b __time64"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_23_68_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
		size = 55
		refs = "0014 __errno 001f __invalid_parameter_noinfo"
		altNames = "??$write_floating_point@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 64 04 8B 41 64 8B 50 FC 85 D2 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0C 8B 45 08 FF 41 68 8B 00 89 02 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_23_69_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
		size = 55
		refs = "0014 __errno 001f __invalid_parameter_noinfo"
		altNames = "??$write_floating_point@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 4C 04 8B 41 4C 8B 50 FC 85 D2 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0C 8B 45 08 FF 41 50 8B 00 89 02 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_23_70_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
		size = 61
		refs = "0014 __errno 001f __invalid_parameter_noinfo"
		altNames = "??$write_floating_point@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 64 04 8B 41 64 8B 50 FC 85 D2 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 12 FF 41 68 8B 4D 08 8B 01 89 02 8B 41 04 89 42 04 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_23_71_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
		size = 61
		refs = "0014 __errno 001f __invalid_parameter_noinfo"
		altNames = "??$write_floating_point@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NABN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 4C 04 8B 41 4C 8B 50 FC 85 D2 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 12 FF 41 50 8B 4D 08 8B 01 89 02 8B 41 04 89 42 04 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_23_81_0 {
	meta:
		name = "??0?$format_string_parser@D@__crt_stdio_input@@QAE@_KQBE@Z"
		size = 74
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B D1 53 33 DB 57 89 02 8D 7A 2C 8B 45 0C 89 42 04 8B 45 10 6A 08 89 42 08 33 C0 59 89 5A 0C F3 AB 5F 89 5A 10 8B C2 66 89 5A 14 88 5A 16 89 5A 18 89 5A 1C 89 5A 20 88 5A 24 89 5A 28 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_23_82_0 {
	meta:
		name = "??0?$format_string_parser@_W@__crt_stdio_input@@QAE@_KQB_W@Z"
		size = 62
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 33 D2 89 01 8B 45 0C 89 41 04 8B 45 10 89 41 08 33 C0 89 51 0C 89 51 34 89 41 14 8B C1 89 51 10 88 51 18 89 51 20 89 51 24 89 51 28 88 51 2C 89 51 30 5D C2 0C 00 }
	condition:
		$1
}

rule file_23_83_0 {
	meta:
		name = "??0?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
		size = 49
		altNames = "??0?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$string_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@QAV?$string_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 61 10 00 83 61 14 00 89 01 8B 45 0C 89 41 08 8B 45 10 89 41 0C 8B 45 14 89 41 18 85 C0 74 03 C6 00 01 8B C1 5D C2 10 00 }
	condition:
		$1
}

rule file_23_85_0 {
	meta:
		name = "??0?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAE@ABV?$console_input_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 69
		refs = "0025 ??0?$format_string_parser@D@__crt_stdio_input@@QAE@_KQBE@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 10 8B 45 08 56 8B 75 0C 57 FF 75 14 8B F9 52 56 89 37 8D 4F 10 89 57 04 8B 00 89 47 08 E8 ?? ?? ?? ?? 8B 45 18 83 67 68 00 83 67 6C 00 89 47 60 8B 45 1C 89 47 64 8B C7 5F 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_23_86_0 {
	meta:
		name = "??0?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAE@ABV?$console_input_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 69
		refs = "0025 ??0?$format_string_parser@_W@__crt_stdio_input@@QAE@_KQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 10 8B 45 08 56 8B 75 0C 57 FF 75 14 8B F9 52 56 89 37 8D 4F 10 89 57 04 8B 00 89 47 08 E8 ?? ?? ?? ?? 8B 45 18 83 67 50 00 83 67 54 00 89 47 48 8B 45 1C 89 47 4C 8B C7 5F 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_23_87_0 {
	meta:
		name = "??0?$scanset_buffer@E@__crt_stdio_input@@QAE@XZ"
		size = 18
		altNames = "??0?$scanset_storage@$00@__crt_stdio_input@@QAE@XZ"
	strings:
		$1 = { 8B FF 57 8B D1 33 C0 6A 08 59 8B FA F3 AB 8B C2 5F C3 }
	condition:
		$1
}

rule file_23_92_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QAE@ABU01@@Z"
		size = 49
		refs = "0023 _memcpy_s"
		altNames = "??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 8B F1 8B 02 89 06 8B 02 C1 E0 02 50 8D 42 04 50 8D 46 04 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_94_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QAE@QAM@Z"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 01 8B C1 C6 41 04 00 5D C2 04 00 }
	condition:
		$1
}

rule file_23_95_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QAE@QAN@Z"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 01 8B C1 C6 41 04 01 5D C2 04 00 }
	condition:
		$1
}

rule file_23_97_0 {
	meta:
		name = "??1?$format_string_parser@_W@__crt_stdio_input@@QAE@XZ"
		size = 20
		refs = "0009 __free_base"
	strings:
		$1 = { 8B FF 56 8B F1 FF 76 34 E8 ?? ?? ?? ?? 83 66 34 00 59 5E C3 }
	condition:
		$1
}

rule file_23_98_0 {
	meta:
		name = "??1?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@XZ"
		size = 18
		altNames = "??1?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@XZ ??1?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@XZ ??1?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE@XZ"
	strings:
		$1 = { 8B 51 18 85 D2 74 0A 8B 41 10 0B 41 14 75 02 88 02 C3 }
	condition:
		$1
}

rule file_23_100_0 {
	meta:
		name = "??1?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAE@XZ"
		size = 20
		refs = "0009 __free_base"
		altNames = "??1?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAE@XZ"
	strings:
		$1 = { 8B FF 56 8B F1 FF 76 44 E8 ?? ?? ?? ?? 83 66 44 00 59 5E C3 }
	condition:
		$1
}

rule file_23_104_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z"
		size = 36
		refs = "000b __free_base"
		altNames = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 FF 36 E8 ?? ?? ?? ?? 8B 55 08 83 26 00 59 8B 02 89 06 8B C6 83 22 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_107_0 {
	meta:
		name = "??M__crt_strtox@@YA_NABUbig_integer@0@0@Z"
		size = 96
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 08 57 8B 7D 0C 8B 0B 8B 07 3B C8 76 06 5F 32 C0 5B 5D C3 73 06 5F B0 01 5B 5D C3 49 56 83 F9 FF 74 1A 8D 57 04 8B F3 8D 14 8A 2B F7 8B 04 16 3B 02 75 10 49 83 EA 04 83 F9 FF 75 F0 5E 5F 32 C0 5B 5D C3 83 F9 FF 74 F4 8B 44 8B 04 3B 44 8F 04 5E 5F 0F 96 C0 5B 5D C3 }
	condition:
		$1
}

rule file_23_115_0 {
	meta:
		name = "?accumulate_decimal_digits_into_big_integer@__crt_strtox@@YAXQBE0AAUbig_integer@1@@Z"
		size = 1570
		refs = "000c ___security_cookie 00b8 _memcpy_s 0175 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 01a0 _memset 01bb ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 01ca _memcpy 04f7 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 061a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A4 05 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 10 33 C9 56 57 8B 7D 08 33 F6 89 9D 50 FC FF FF 89 B5 3C FC FF FF 3B 7D 0C 0F 84 DA 05 00 00 83 F9 09 0F 85 E6 00 00 00 8B 03 89 85 58 FC FF FF 85 C0 74 73 8B B5 58 FC FF FF 8D 43 04 33 C9 89 85 54 FC FF FF 33 FF 8B D8 8B 04 BB BA 00 CA 9A 3B F7 E2 03 C1 89 04 BB 83 D2 00 47 8B CA 3B FE 75 E7 8B 9D 50 FC FF FF 8B B5 3C FC FF FF 8B 7D 08 85 C9 74 32 8B 03 83 F8 73 73 08 89 4C 83 04 FF 03 EB 23 33 C0 50 89 85 5C FC FF FF 89 03 8D 85 60 FC FF FF 50 8D 43 04 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 F6 74 5F 83 A5 54 FC FF FF 00 83 3B 00 74 1C 8B BD 54 FC FF FF 8D 53 04 33 C0 01 32 8D 52 04 13 C0 47 8B F0 3B 3B 75 F0 8B 7D 08 85 F6 74 33 8B 03 83 F8 73 73 08 89 74 83 04 FF 03 EB 24 83 A5 5C FC FF FF 00 8D 85 60 FC FF FF 83 23 00 6A 00 50 8D 43 04 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 33 F6 33 C9 0F B6 07 6B F6 0A 03 F0 41 47 89 B5 3C FC FF FF 89 7D 08 3B 7D 0C 0F 85 F5 FE FF FF 85 C9 0F 84 C7 04 00 00 8B C1 33 D2 6A 0A 59 F7 F1 89 85 54 FC FF FF 8B CA 89 8D 34 FC FF FF 85 C0 0F 84 83 03 00 00 83 F8 26 76 03 6A 26 58 0F B6 0C 85 ?? ?? ?? ?? 0F B6 34 85 ?? ?? ?? ?? 8B F9 89 85 40 FC FF FF C1 E7 02 57 8D 04 31 89 85 5C FC FF FF 8D 85 60 FC FF FF 6A 00 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 02 50 8B 85 40 FC FF FF 0F B7 04 85 ?? ?? ?? ?? 8D 04 85 ?? ?? ?? ?? 50 8D 85 60 FC FF FF 03 C7 50 E8 ?? ?? ?? ?? 8B 85 5C FC FF FF 83 C4 18 83 F8 01 0F 87 98 00 00 00 8B 8D 60 FC FF FF 85 C9 75 0F 33 C0 89 85 2C FE FF FF 89 03 E9 B2 02 00 00 83 F9 01 0F 84 C2 02 00 00 8B 03 89 85 58 FC FF FF 85 C0 0F 84 B2 02 00 00 8D 53 04 33 F6 89 95 4C FC FF FF 33 FF 8B D8 8B C1 F7 24 BA 03 C6 83 D2 00 8B F2 8B 95 4C FC FF FF 89 04 BA 47 3B FB 75 E6 8B 9D 50 FC FF FF 85 F6 0F 84 7B 02 00 00 8B 03 83 F8 73 73 0B 89 74 83 04 FF 03 E9 69 02 00 00 33 C0 50 89 85 5C FC FF FF 89 03 8D 85 60 FC FF FF 50 68 CC 01 00 00 52 E9 FF 02 00 00 8B 13 89 95 44 FC FF FF 83 FA 01 0F 87 B1 00 00 00 8D 73 04 8B 3E 89 03 C1 E0 02 50 8D 85 60 FC FF FF 50 68 CC 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 10 85 FF 75 1D 33 C0 50 89 85 5C FC FF FF 89 03 8D 85 60 FC FF FF 50 68 CC 01 00 00 56 E9 F2 01 00 00 83 FF 01 0F 84 F1 01 00 00 8B 03 89 85 58 FC FF FF 85 C0 0F 84 E1 01 00 00 33 C9 33 DB 8B C7 F7 24 9E 03 C1 89 04 9E 83 D2 00 43 8B CA 3B 9D 58 FC FF FF 75 E8 8B 9D 50 FC FF FF 85 C9 0F 84 B7 01 00 00 8B 03 83 F8 73 73 09 89 4C 83 04 E9 37 FF FF FF 33 C0 50 89 85 5C FC FF FF 89 03 8D 85 60 FC FF FF 50 68 CC 01 00 00 56 E9 3D 02 00 00 3B C2 8D B5 60 FC FF FF 0F 92 C1 84 C9 75 1D 8D 73 04 8D BD 60 FC FF FF 89 BD 30 FC FF FF 84 C9 74 0F 8B D0 89 85 58 FC FF FF EB 0B 8D 7B 04 EB E7 89 95 58 FC FF FF 84 C9 75 06 89 85 44 FC FF FF 33 C9 33 FF 89 8D 2C FE FF FF 85 D2 0F 84 17 01 00 00 8D 85 30 FE FF FF 2B F0 89 B5 38 FC FF FF 8D 04 BE 8B 84 05 30 FE FF FF 89 85 2C FC FF FF 85 C0 75 1D 3B F9 0F 85 E4 00 00 00 21 84 BD 30 FE FF FF 8D 4F 01 89 8D 2C FE FF FF E9 CF 00 00 00 33 C0 33 D2 8B F7 89 95 4C FC FF FF 89 85 48 FC FF FF 39 85 44 FC FF FF 0F 84 9C 00 00 00 83 FE 73 74 5F 3B F1 75 17 83 A4 B5 30 FE FF FF 00 40 03 C7 89 85 2C FE FF FF 8B 85 48 FC FF FF 8B 8D 30 FC FF FF 8B 04 81 F7 A5 2C FC FF FF 03 85 4C FC FF FF 83 D2 00 01 84 B5 30 FE FF FF 8B 85 48 FC FF FF 8B 8D 2C FE FF FF 83 D2 00 40 89 95 4C FC FF FF 46 89 85 48 FC FF FF 3B 85 44 FC FF FF 75 9C 85 D2 74 34 83 FE 73 0F 84 01 01 00 00 3B F1 75 11 83 A4 B5 30 FE FF FF 00 8D 46 01 89 85 2C FE FF FF 8B C2 33 D2 01 84 B5 30 FE FF FF 8B 8D 2C FE FF FF 13 D2 46 EB C8 83 FE 73 0F 84 CD 00 00 00 8B B5 38 FC FF FF 8B 95 58 FC FF FF 47 3B FA 0F 85 F7 FE FF FF 8B C1 89 0B C1 E0 02 50 8D 85 30 FE FF FF 50 68 CC 01 00 00 8D 43 04 50 E8 ?? ?? ?? ?? 83 C4 10 B0 01 84 C0 0F 84 B8 00 00 00 8B 85 54 FC FF FF 2B 85 40 FC FF FF 89 85 54 FC FF FF 0F 85 83 FC FF FF 8B 8D 34 FC FF FF 85 C9 0F 84 C3 00 00 00 8B 34 8D ?? ?? ?? ?? 85 F6 0F 84 91 00 00 00 83 FE 01 0F 84 AB 00 00 00 8B 03 89 85 38 FC FF FF 85 C0 0F 84 9B 00 00 00 8D 43 04 33 C9 89 85 34 FC FF FF 33 FF 8B D8 8B C6 F7 24 BB 03 C1 89 04 BB 83 D2 00 47 8B CA 3B BD 38 FC FF FF 75 E8 8B 9D 50 FC FF FF 85 C9 74 6A 8B 03 83 F8 73 73 40 89 4C 83 04 FF 03 EB 5B 33 C0 50 89 85 5C FA FF FF 89 03 8D 85 60 FA FF FF 50 68 CC 01 00 00 8D 43 04 50 E8 ?? ?? ?? ?? 83 C4 10 32 C0 E9 40 FF FF FF 83 A5 5C FA FF FF 00 83 23 00 6A 00 EB 0B 33 C0 50 89 03 89 85 5C FA FF FF 8D 85 60 FA FF FF 50 8D 43 04 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 8B 95 3C FC FF FF 85 D2 74 50 33 FF 39 3B 74 13 8D 73 04 33 C0 01 16 8D 76 04 13 C0 47 8B D0 3B 3B 75 F0 85 D2 74 33 8B 03 83 F8 73 73 08 89 54 83 04 FF 03 EB 24 83 A5 5C FA FF FF 00 8D 85 60 FA FF FF 83 23 00 6A 00 50 8D 43 04 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_116_0 {
	meta:
		name = "?add@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 125
		refs = "006f _memcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D0 01 00 00 57 8B 7D 0C 85 FF 74 32 8B 55 08 53 33 DB 39 1A 74 16 56 8D 72 04 33 C0 8D 76 04 01 7E FC 13 C0 43 8B F8 3B 1A 75 EF 5E 5B 85 FF 74 0D 8B 02 83 F8 73 73 0D 89 7C 82 04 FF 02 B0 01 5F 8B E5 5D C3 6A 00 8D 85 34 FE FF FF C7 85 30 FE FF FF 00 00 00 00 50 8D 42 04 C7 02 00 00 00 00 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_117_0 {
	meta:
		name = "?add_carry@__crt_strtox@@YAIAAIII@Z"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 33 C0 8B 0A 03 4D 0C 13 C0 03 4D 10 89 0A 83 D0 00 5D C3 }
	condition:
		$1
}

rule file_23_118_0 {
	meta:
		name = "?add_multiply_carry@__crt_strtox@@YAIAAIIII@Z"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C F7 65 10 8B 4D 08 03 01 83 D2 00 03 45 14 89 01 83 D2 00 8B C2 5D C3 }
	condition:
		$1
}

rule file_23_119_0 {
	meta:
		name = "?advance@?$format_string_parser@D@__crt_stdio_input@@QAE_NXZ"
		size = 288
		refs = "0042 _isspace 009d ?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ 00ac ?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ 00b3 ?scan_optional_wide_modifier@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ 00ba ?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ 00d0 ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA 0119 ?scan_optional_literal_character_trail_bytes_tchar@?$format_string_parser@D@__crt_stdio_input@@AAE_ND@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 DB 39 5E 0C 74 07 32 C0 E9 09 01 00 00 8B 46 08 89 5E 10 66 89 5E 14 88 5E 16 89 5E 18 89 5E 1C 89 5E 20 88 5E 24 89 5E 28 38 18 75 09 C7 46 10 01 00 00 00 EB D0 0F B6 00 50 E8 ?? ?? ?? ?? 59 85 C0 74 24 C7 46 10 02 00 00 00 EB 03 FF 46 08 8B 46 08 0F B6 00 50 E8 ?? ?? ?? ?? 59 85 C0 75 EC B0 01 E9 AE 00 00 00 8B 4E 08 80 39 25 0F 85 80 00 00 00 8D 41 01 80 38 25 74 78 C7 46 10 04 00 00 00 89 46 08 80 38 2A 75 08 40 C6 46 16 01 89 46 08 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 64 FF FF FF 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 47 FF FF FF 6B 4E 28 0C 8B 46 20 38 9C 01 ?? ?? ?? ?? 75 92 89 5E 10 66 89 5E 14 88 5E 16 89 5E 18 89 5E 1C 89 5E 20 88 5E 24 89 5E 28 C7 46 0C 16 00 00 00 E9 12 FF FF FF C7 46 10 03 00 00 00 8A 01 88 46 14 33 C0 80 39 25 53 0F 94 C0 41 03 C1 8B CE 89 46 08 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule file_23_120_0 {
	meta:
		name = "?advance@?$format_string_parser@_W@__crt_stdio_input@@QAE_NXZ"
		size = 258
		refs = "0042 _iswctype 0092 ?scan_optional_assignment_suppressor@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ 0099 ?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ 00a8 ?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ 00af ?scan_optional_wide_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ 00b6 ?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ 00cc ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA 00d8 ?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAEXH@Z"
	strings:
		$1 = { 8B FF 56 8B F1 33 C9 39 4E 0C 74 04 32 C0 5E C3 33 C0 89 4E 10 89 46 14 8B 46 08 88 4E 18 89 4E 20 89 4E 24 89 4E 28 88 4E 2C 89 4E 30 66 39 08 75 09 C7 46 10 01 00 00 00 EB D1 0F B7 00 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 26 C7 46 10 02 00 00 00 EB 04 83 46 08 02 8B 46 08 6A 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 E8 E9 8C 00 00 00 8B 4E 08 6A 25 5A 66 39 11 75 64 8D 41 02 66 39 10 74 5C 8B CE C7 46 10 04 00 00 00 89 46 08 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 67 FF FF FF 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 4A FF FF FF 6B 4E 30 0C 8B 46 28 80 BC 01 ?? ?? ?? ?? 00 75 2B 6A 16 8B CE E8 ?? ?? ?? ?? E9 2B FF FF FF C7 46 10 03 00 00 00 66 8B 01 66 89 46 14 33 C0 66 39 11 0F 94 C0 40 8D 04 41 89 46 08 B0 01 5E C3 }
	condition:
		$1
}

rule file_23_121_0 {
	meta:
		name = "?as_double@floating_point_value@__crt_strtox@@QBEAANXZ"
		size = 37
		refs = "0011 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0016 ??_C@_1FM@FELNCOBF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 001b ??_C@_1BG@GEMHBGAF@?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 0020 __invoke_watson"
	strings:
		$1 = { 80 79 04 00 74 03 8B 01 C3 6A 00 68 9F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_23_122_0 {
	meta:
		name = "?as_float@floating_point_value@__crt_strtox@@QBEAAMXZ"
		size = 37
		refs = "0011 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0016 ??_C@_1FK@JOJELFFO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 001b ??_C@_1BI@BANMPGJI@?$AA?$CB?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 0020 __invoke_watson"
	strings:
		$1 = { 80 79 04 00 75 03 8B 01 C3 6A 00 68 A5 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_23_123_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z"
		size = 58
		refs = "000f ?as_double@floating_point_value@__crt_strtox@@QBEAANXZ 0018 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z 0021 ?as_float@floating_point_value@__crt_strtox@@QBEAAMXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 80 79 04 00 74 12 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 E8 ?? ?? ?? ?? 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 81 C9 00 00 80 7F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_124_0 {
	meta:
		name = "?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
		size = 840
		refs = "0080 ?assemble_floating_point_infinity@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z 00d9 __allshl 0143 _fegetround 017f __aullshr 0199 ?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QBE_KXZ 01c5 ?assemble_floating_point_zero@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z 02b8 ?normal_mantissa_mask@floating_point_value@__crt_strtox@@QBE_KXZ 031b ?as_double@floating_point_value@__crt_strtox@@QBEAANXZ 0327 ??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAN@Z 032e ?as_float@floating_point_value@__crt_strtox@@QBEAAMXZ 033a ??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 8B 75 0C 33 DB 57 8B 7D 08 3B F3 77 16 83 FF FF 77 11 0F BD C7 89 5D DC 74 05 8D 48 01 EB 14 8B CB EB 10 0F BD C6 89 5D DC 8D 48 01 75 02 8B CB 83 C1 20 8B 45 1C 33 D2 8A 40 04 84 C0 88 45 FF 0F 94 C2 33 C0 4A 83 E2 1D 83 C2 18 2B D1 8B 4D 10 2B CA 89 55 F4 38 45 FF 89 4D F8 0F 94 C0 48 25 80 03 00 00 83 C0 7F 89 45 F0 3B C8 7E 15 FF 75 1C FF 75 14 E8 ?? ?? ?? ?? 59 59 6A 03 58 E9 B3 02 00 00 33 C0 38 45 FF 0F 94 C0 48 25 80 FC FF FF 83 C0 82 3B C8 0F 8D 33 01 00 00 8B 45 F0 48 03 C1 8B 4D F0 03 C2 F7 D9 89 45 EC 89 4D F8 85 C0 0F 89 10 01 00 00 F7 D8 89 45 F0 83 F8 40 0F 83 EE 00 00 00 8D 48 FF 33 D2 33 C0 40 E8 ?? ?? ?? ?? 8B 4D F0 89 45 E8 83 C0 FF 89 55 E4 83 D2 FF 89 45 E0 33 C0 89 55 DC 40 33 D2 E8 ?? ?? ?? ?? 23 C7 C6 45 FD 01 23 D6 0B C2 75 03 88 5D FD 8B 45 E8 8B 4D E4 23 C7 23 CE 0B C1 B1 01 75 02 8A CB 88 4D FF 38 5D 18 74 10 8B 45 E0 8B 55 DC 23 C7 23 D6 0B C2 8A C3 74 02 B0 01 88 45 FE 84 C9 75 04 84 C0 74 35 E8 ?? ?? ?? ?? 85 C0 74 1B 3D 00 01 00 00 74 0F 3D 00 02 00 00 75 1E 38 5D 14 0F 94 C3 EB 16 8A 5D 14 EB 11 38 5D FF 74 0C 38 5D FE 75 05 38 5D FD 74 02 B3 01 8B 4D F0 8B C7 8B D6 E8 ?? ?? ?? ?? 8B F8 8B F2 0F B6 C3 99 03 F8 8B C7 13 F2 0B C6 74 29 8B 4D 1C E8 ?? ?? ?? ?? 3B F2 0F 82 5B 01 00 00 77 08 3B F8 0F 86 51 01 00 00 8B 5D 10 2B 5D EC 2B 5D F4 4B E9 45 01 00 00 FF 75 1C FF 75 14 E8 ?? ?? ?? ?? 59 59 6A 02 E9 B6 FE FF FF 8B 4D EC E9 19 01 00 00 85 D2 0F 89 0C 01 00 00 F7 DA 89 55 F4 83 FA 40 72 09 8B FB 8B F3 E9 BF 00 00 00 33 C0 8D 4A FF 40 33 D2 E8 ?? ?? ?? ?? 8B 4D F4 89 45 DC 83 C0 FF 89 55 E0 83 D2 FF 89 45 E4 33 C0 89 55 E8 40 33 D2 E8 ?? ?? ?? ?? 23 C7 C6 45 FF 01 23 D6 0B C2 75 03 88 5D FF 8B 45 DC 8B 4D E0 23 C7 23 CE 0B C1 B1 01 75 02 8A CB 88 4D FD 38 5D 18 74 10 8B 45 E4 8B 55 E8 23 C7 23 D6 0B C2 8A C3 74 02 B0 01 88 45 FE 84 C9 75 04 84 C0 74 35 E8 ?? ?? ?? ?? 85 C0 74 1B 3D 00 01 00 00 74 0F 3D 00 02 00 00 75 1E 38 5D 14 0F 94 C3 EB 16 8A 5D 14 EB 11 38 5D FD 74 0C 38 5D FE 75 05 38 5D FF 74 02 B3 01 8B 4D F4 8B C7 8B D6 E8 ?? ?? ?? ?? 8B F8 8B F2 0F B6 C3 99 03 F8 13 F2 8B 4D 1C E8 ?? ?? ?? ?? 3B F2 72 40 77 04 3B F8 76 3A 8B 4D 1C 33 C0 8B 5D F8 0F AC F7 01 D1 EE 43 38 41 04 0F 94 C0 48 25 80 03 00 00 83 C0 7F 3B D8 7E 1B 51 E9 8E FD FF FF 7E 10 8B 4D F4 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F2 8B F8 8B 5D F8 8B 4D 1C E8 ?? ?? ?? ?? 23 F8 23 F2 8B 45 1C 8B C8 80 78 04 00 74 13 E8 ?? ?? ?? ?? 50 56 57 53 FF 75 14 E8 ?? ?? ?? ?? EB 11 E8 ?? ?? ?? ?? 50 56 57 53 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_125_0 {
	meta:
		name = "?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@ABUbig_integer@1@I_N1ABVfloating_point_value@1@@Z"
		size = 398
		refs = "00f7 __allshl 012a __aullshr 0180 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 33 D2 53 8B 5D 18 56 57 8B 7D 0C 38 53 04 0F 94 C2 4A 83 E2 1D 83 C2 17 83 FF 40 77 39 8B 4D 08 83 39 00 76 05 8B 71 04 EB 02 33 F6 83 39 01 76 05 8B 49 08 EB 02 33 C9 80 7D 14 00 53 0F 94 C0 0F B6 C0 50 FF 75 10 33 C0 03 C6 52 83 D1 00 51 50 E9 21 01 00 00 8B C7 C1 EF 05 83 E0 1F 89 45 E4 8D 77 FE 85 C0 75 51 8B CE C1 E1 05 03 CA 8B 55 08 8B 14 BA 8B 7D 08 03 44 B7 04 89 45 EC 83 D2 00 80 7D 14 00 89 55 F4 0F 94 C2 88 55 F0 85 F6 74 19 83 C7 04 83 3F 00 8D 7F 04 0F 94 C0 22 D0 83 EE 01 75 F0 8B 45 EC 88 55 F0 53 FF 75 F0 FF 75 10 51 FF 75 F4 EB 97 33 DB 89 75 FC C1 65 FC 05 8B C8 01 45 FC 43 01 55 FC 89 5D F8 D3 65 F8 FF 4D F8 6A 40 59 2B C8 8B 45 08 89 4D E8 83 C1 E0 8B 54 B0 04 8B 04 B8 89 55 EC 33 D2 E8 ?? ?? ?? ?? 8B 4D E8 89 45 F4 8B 45 08 89 55 F0 33 D2 8B 44 B8 04 8B 7D F8 23 C7 E8 ?? ?? ?? ?? 01 45 F4 8B C7 8B 4D E4 F7 D0 11 55 F0 33 D2 23 45 EC E8 ?? ?? ?? ?? 8B 4D F4 03 C8 8B 45 F0 89 4D F4 13 C2 80 7D 14 00 89 45 F0 75 05 85 7D EC 74 02 32 DB 88 5D F8 85 F6 74 1F 8B 4D 08 83 C1 04 83 39 00 8D 49 04 0F 94 C0 22 D8 88 5D F8 83 EE 01 75 ED 8B 4D F4 8B 45 F0 FF 75 18 FF 75 F8 FF 75 10 FF 75 FC 50 51 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_126_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z"
		size = 52
		refs = "000f ?as_double@floating_point_value@__crt_strtox@@QBEAANXZ 0018 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z 0021 ?as_float@floating_point_value@__crt_strtox@@QBEAAMXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 80 79 04 00 74 12 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 E8 ?? ?? ?? ?? 33 C9 38 4D 08 0F 95 C1 C1 E1 1F 89 08 5D C3 }
	condition:
		$1
}

rule file_23_127_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAIABUbig_integer@1@@Z"
		size = 65
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 85 C9 75 06 33 C0 8B E5 5D C3 8B 04 88 0F BD C0 C7 45 FC 00 00 00 00 74 0F 8D 50 01 8D 41 FF C1 E0 05 03 C2 8B E5 5D C3 8D 41 FF 33 D2 C1 E0 05 03 C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_128_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAII@Z"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 51 0F BD 45 08 C7 45 FC 00 00 00 00 74 05 40 8B E5 5D C3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_129_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAI_K@Z"
		size = 71
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 85 C0 75 1B 8B 4D 08 83 F9 FF 77 13 89 45 FC 0F BD C1 74 05 40 8B E5 5D C3 33 C0 8B E5 5D C3 0F BD C0 C7 45 FC 00 00 00 00 74 08 40 83 C0 20 8B E5 5D C3 33 C0 B8 20 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_132_0 {
	meta:
		name = "?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
		size = 7619
		refs = "000c ___security_cookie 0135 _memcpy_s 0241 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 026c _memset 0287 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 0296 _memcpy 05bf ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 0c16 ?assemble_floating_point_infinity@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z 1821 ?assemble_floating_point_zero@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z 18c6 __allshl 1c6c ?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z 1cfa __aullshr 1d7c ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z 1dab ?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@ABUbig_integer@1@I_N1ABVfloating_point_value@1@@Z 1dbb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 2C 0B 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 33 C0 53 56 57 38 41 04 8B 7D 08 0F 94 C0 89 BD AC F6 FF FF 48 89 8D A8 F6 FF FF 83 E0 1D 8B 1F 83 C0 19 89 85 B0 F6 FF FF 85 DB 79 02 33 DB 8B 47 04 8B CB 3B D8 72 02 8B C8 83 C0 08 8D 57 08 03 C7 03 D1 89 85 C4 F6 FF FF 2B D9 2B C2 89 9D CC F6 FF FF 83 C7 08 89 85 E0 F6 FF FF 33 C0 89 95 D8 F6 FF FF 33 F6 89 85 E8 F6 FF FF 33 C9 89 85 2C FE FF FF 89 B5 E4 F6 FF FF 89 BD DC F6 FF FF 3B FA 75 0D 8B D8 E9 6B 06 00 00 8B 85 E8 F6 FF FF 83 F9 09 0F 85 37 01 00 00 85 C0 0F 84 93 00 00 00 8B 9D E8 F6 FF FF 33 C9 33 F6 BF 00 CA 9A 3B 8B 84 B5 30 FE FF FF F7 E7 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 8B BD DC F6 FF FF 8B 85 2C FE FF FF 85 C9 74 4C 83 F8 73 73 16 89 8C 85 30 FE FF FF 8B 85 2C FE FF FF 40 89 85 2C FE FF FF EB 31 83 A5 BC F8 FF FF 00 8D 85 C0 F8 FF FF 83 A5 2C FE FF FF 00 6A 00 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 85 2C FE FF FF 83 C4 10 8B B5 E4 F6 FF FF 89 85 E8 F6 FF FF 85 F6 0F 84 82 00 00 00 33 D2 85 C0 74 1E 33 C0 01 B4 95 30 FE FF FF 13 C0 42 8B F0 8B 85 2C FE FF FF 89 85 E8 F6 FF FF 3B D0 75 E2 85 F6 74 5A 83 F8 73 73 1C 89 B4 85 30 FE FF FF 8B 9D 2C FE FF FF 43 89 9D E8 F6 FF FF 89 9D 2C FE FF FF EB 3F 83 A5 BC F8 FF FF 00 8D 85 C0 F8 FF FF 83 A5 2C FE FF FF 00 6A 00 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 9D 2C FE FF FF 83 C4 10 89 9D E8 F6 FF FF EB 06 8B 9D E8 F6 FF FF 8B 95 D8 F6 FF FF 33 F6 33 C9 EB 06 8B 9D E8 F6 FF FF 0F B6 07 6B F6 0A 03 F0 41 47 89 B5 E4 F6 FF FF 89 BD DC F6 FF FF 3B FA 0F 85 96 FE FF FF 85 C9 0F 84 F3 04 00 00 8B C1 33 D2 6A 0A 59 F7 F1 89 85 C8 F6 FF FF 8B CA 89 8D B8 F6 FF FF 85 C0 0F 84 7F 03 00 00 83 F8 26 76 03 6A 26 58 0F B6 0C 85 ?? ?? ?? ?? 0F B6 34 85 ?? ?? ?? ?? 8B F9 89 85 D0 F6 FF FF C1 E7 02 57 8D 04 31 89 85 BC F8 FF FF 8D 85 C0 F8 FF FF 6A 00 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 02 50 8B 85 D0 F6 FF FF 0F B7 04 85 ?? ?? ?? ?? 8D 04 85 ?? ?? ?? ?? 50 8D 85 C0 F8 FF FF 03 C7 50 E8 ?? ?? ?? ?? 8B 85 BC F8 FF FF 33 C9 41 83 C4 18 3B C1 0F 87 B3 00 00 00 8B B5 C0 F8 FF FF 85 F6 75 1A 33 C0 89 85 EC F6 FF FF 89 85 2C FE FF FF 50 8D 85 F0 F6 FF FF E9 9D 02 00 00 3B F1 75 07 8A C1 E9 B5 02 00 00 85 DB 74 F5 33 C9 33 FF 8B C6 F7 A4 BD 30 FE FF FF 03 C1 89 84 BD 30 FE FF FF 83 D2 00 47 8B CA 3B FB 75 E4 85 C9 74 4F 8B 85 2C FE FF FF 83 F8 73 73 16 89 8C 85 30 FE FF FF 8B 9D 2C FE FF FF 43 89 9D 2C FE FF FF EB 34 33 DB 8D 85 C0 F8 FF FF 89 9D BC F8 FF FF 53 50 8D 85 30 FE FF FF 89 9D 2C FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8A C3 E9 2F 02 00 00 8B 9D 2C FE FF FF B0 01 E9 2B 02 00 00 3B D9 0F 87 8E 00 00 00 8B BD 30 FE FF FF BB CC 01 00 00 89 85 2C FE FF FF C1 E0 02 50 8D 85 C0 F8 FF FF 50 8D 85 30 FE FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 33 C0 85 FF 75 1A 50 89 85 BC F8 FF FF 89 85 2C FE FF FF 8D 85 C0 F8 FF FF 50 53 E9 C0 01 00 00 8B 9D 2C FE FF FF 40 89 9D E8 F6 FF FF 3B F8 0F 84 C8 01 00 00 85 DB 0F 84 C0 01 00 00 33 C9 33 F6 8B C7 F7 A4 B5 30 FE FF FF 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 E9 0A FF FF FF 3B C3 8D B5 C0 F8 FF FF 0F 92 C1 84 C9 75 20 8D B5 30 FE FF FF 8D 95 C0 F8 FF FF 89 95 DC F6 FF FF 84 C9 74 12 8B D0 89 95 E8 F6 FF FF EB 10 8D 95 30 FE FF FF EB E4 8B D3 89 9D E8 F6 FF FF 84 C9 75 02 8B D8 33 C9 33 FF 89 8D 5C FC FF FF 85 D2 0F 84 0F 01 00 00 8D 85 60 FC FF FF 2B F0 89 B5 B4 F6 FF FF 8D 04 BE 8B 84 05 60 FC FF FF 89 85 A4 F6 FF FF 85 C0 75 1D 3B F9 0F 85 DC 00 00 00 21 84 BD 60 FC FF FF 8D 4F 01 89 8D 5C FC FF FF E9 C7 00 00 00 33 D2 33 C0 89 95 D4 F6 FF FF 8B F7 89 85 BC F6 FF FF 85 DB 0F 84 98 00 00 00 83 FE 73 74 5B 3B F1 75 17 83 A4 B5 60 FC FF FF 00 40 03 C7 89 85 5C FC FF FF 8B 85 BC F6 FF FF 8B 8D DC F6 FF FF 8B 04 81 F7 A5 A4 F6 FF FF 03 85 D4 F6 FF FF 83 D2 00 01 84 B5 60 FC FF FF 8B 85 BC F6 FF FF 8B 8D 5C FC FF FF 83 D2 00 40 89 95 D4 F6 FF FF 46 89 85 BC F6 FF FF 3B C3 75 A0 85 D2 74 34 83 FE 73 0F 84 EC 00 00 00 3B F1 75 11 83 A4 B5 60 FC FF FF 00 8D 46 01 89 85 5C FC FF FF 8B C2 33 D2 01 84 B5 60 FC FF FF 8B 8D 5C FC FF FF 13 D2 46 EB C8 83 FE 73 0F 84 B8 00 00 00 8B 95 E8 F6 FF FF 8B B5 B4 F6 FF FF 47 3B FA 0F 85 FF FE FF FF 8B C1 89 8D 2C FE FF FF C1 E0 02 50 8D 85 60 FC FF FF 50 68 CC 01 00 00 8D 85 30 FE FF FF 50 E8 ?? ?? ?? ?? B0 01 8B 9D 2C FE FF FF 83 C4 10 89 9D E8 F6 FF FF 84 C0 74 31 8B 85 C8 F6 FF FF 2B 85 D0 F6 FF FF 89 85 C8 F6 FF FF 0F 85 87 FC FF FF 8B 8D B8 F6 FF FF 85 C9 0F 84 B7 00 00 00 8B 3C 8D ?? ?? ?? ?? 85 FF 75 4C 83 A5 BC F8 FF FF 00 8D 85 C0 F8 FF FF 83 A5 2C FE FF FF 00 6A 00 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 85 2C FE FF FF 83 C4 10 89 85 E8 F6 FF FF EB 79 33 DB 8D 85 F0 F6 FF FF 89 9D EC F6 FF FF E9 21 FD FF FF 8B 85 E8 F6 FF FF 83 FF 01 74 5B 85 C0 74 57 33 C9 8B D8 33 F6 8B C7 F7 A4 B5 30 FE FF FF 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 8B 85 2C FE FF FF 85 C9 74 AA 83 F8 73 0F 83 70 FF FF FF 89 8C 85 30 FE FF FF 8B 85 2C FE FF FF 40 89 85 E8 F6 FF FF 89 85 2C FE FF FF EB 06 8B 85 E8 F6 FF FF 8B 95 E4 F6 FF FF 85 D2 0F 84 82 00 00 00 33 C9 85 C0 74 1E 8B C2 33 D2 01 84 8D 30 FE FF FF 8B 85 2C FE FF FF 13 D2 89 85 E8 F6 FF FF 41 3B C8 75 E2 85 D2 74 5A 83 F8 73 73 1C 89 94 85 30 FE FF FF 8B 9D 2C FE FF FF 43 89 9D E8 F6 FF FF 89 9D 2C FE FF FF EB 3F 83 A5 BC F8 FF FF 00 8D 85 C0 F8 FF FF 83 A5 2C FE FF FF 00 6A 00 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 9D 2C FE FF FF 83 C4 10 89 9D E8 F6 FF FF EB 06 8B 9D E8 F6 FF FF 8B 85 CC F6 FF FF 85 C0 0F 84 13 04 00 00 6A 0A 33 D2 59 F7 F1 89 85 D4 F6 FF FF 8B CA 89 8D B8 F6 FF FF 85 C0 0F 84 AD 03 00 00 83 F8 26 76 03 6A 26 58 0F B6 0C 85 ?? ?? ?? ?? 0F B6 34 85 ?? ?? ?? ?? 8B F9 89 85 BC F6 FF FF C1 E7 02 57 8D 04 31 89 85 BC F8 FF FF 8D 85 C0 F8 FF FF 6A 00 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 02 50 8B 85 BC F6 FF FF 0F B7 04 85 ?? ?? ?? ?? 8D 04 85 ?? ?? ?? ?? 50 8D 85 C0 F8 FF FF 03 C7 50 E8 ?? ?? ?? ?? 8B 85 BC F8 FF FF 33 C9 41 83 C4 18 3B C1 0F 87 94 00 00 00 8B BD C0 F8 FF FF 85 FF 75 43 33 C0 50 89 85 EC F6 FF FF 89 85 2C FE FF FF 8D 85 F0 F6 FF FF 50 68 CC 01 00 00 8D 85 30 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 8B 9D 2C FE FF FF B0 01 89 9D E8 F6 FF FF 8B 9D E8 F6 FF FF E9 C1 02 00 00 3B F9 75 04 8A C1 EB ED 85 DB 74 F8 33 C9 33 F6 8B C7 F7 A4 B5 30 FE FF FF 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 E9 A7 00 00 00 89 8C 85 30 FE FF FF 8B 9D 2C FE FF FF 43 89 9D 2C FE FF FF EB A6 3B D9 0F 87 D7 00 00 00 8B BD 30 FE FF FF BB CC 01 00 00 89 85 2C FE FF FF C1 E0 02 50 8D 85 C0 F8 FF FF 50 8D 85 30 FE FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 33 C0 85 FF 75 1A 50 89 85 BC F8 FF FF 89 85 2C FE FF FF 8D 85 C0 F8 FF FF 50 53 E9 3D FF FF FF 8B 9D 2C FE FF FF 40 89 9D E8 F6 FF FF 3B F8 0F 84 45 FF FF FF 85 DB 0F 84 3D FF FF FF 33 C9 33 F6 8B C7 F7 A4 B5 30 FE FF FF 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 85 C9 0F 84 07 FF FF FF 8B 85 2C FE FF FF 83 F8 73 0F 82 42 FF FF FF 33 DB 8D 85 C0 F8 FF FF 53 50 8D 85 30 FE FF FF 89 9D BC F8 FF FF 68 CC 01 00 00 50 89 9D 2C FE FF FF E8 ?? ?? ?? ?? 8A C3 83 C4 10 8B 9D 2C FE FF FF E9 C9 FE FF FF 3B C3 8D 95 C0 F8 FF FF 0F 92 C1 84 C9 75 06 8D 95 30 FE FF FF 89 95 E4 F6 FF FF 8D 95 30 FE FF FF 84 C9 75 06 8D 95 C0 F8 FF FF 89 95 C8 F6 FF FF 84 C9 74 0A 8B F8 89 BD DC F6 FF FF EB 08 8B FB 89 9D DC F6 FF FF 84 C9 75 02 8B D8 33 D2 33 F6 89 95 5C FC FF FF 85 FF 0F 84 07 01 00 00 8B 85 E4 F6 FF FF 8D 8D 60 FC FF FF 2B C1 89 85 E4 F6 FF FF 8D 04 B0 8B 84 05 60 FC FF FF 89 85 CC F6 FF FF 85 C0 75 1D 3B F2 0F 85 C8 00 00 00 21 84 B5 60 FC FF FF 8D 56 01 89 95 5C FC FF FF E9 B3 00 00 00 33 C0 33 FF 89 85 D0 F6 FF FF 8B CE 85 DB 0F 84 90 00 00 00 83 F9 73 74 53 3B CA 75 17 83 A4 8D 60 FC FF FF 00 40 03 C6 89 85 5C FC FF FF 8B 85 D0 F6 FF FF 8B 95 C8 F6 FF FF 8B 04 82 F7 A5 CC F6 FF FF 03 C7 83 D2 00 01 84 8D 60 FC FF FF 8B 85 D0 F6 FF FF 83 D2 00 40 41 89 85 D0 F6 FF FF 8B FA 8B 95 5C FC FF FF 3B C3 75 A8 85 FF 74 34 83 F9 73 0F 84 FC 00 00 00 3B CA 75 11 83 A4 8D 60 FC FF FF 00 8D 41 01 89 85 5C FC FF FF 8B C7 33 FF 01 84 8D 60 FC FF FF 8B 95 5C FC FF FF 13 FF 41 EB C8 83 F9 73 0F 84 C8 00 00 00 8B BD DC F6 FF FF 8B 85 E4 F6 FF FF 46 3B F7 0F 85 0D FF FF FF 8B C2 89 95 2C FE FF FF C1 E0 02 50 8D 85 60 FC FF FF 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 B0 01 8B 9D 2C FE FF FF 89 9D E8 F6 FF FF 84 C0 0F 84 A7 00 00 00 8B 85 D4 F6 FF FF 2B 85 BC F6 FF FF 89 85 D4 F6 FF FF 0F 85 59 FC FF FF 8B 8D B8 F6 FF FF 85 C9 74 45 8B 3C 8D ?? ?? ?? ?? 85 FF 0F 85 88 00 00 00 33 C0 50 89 85 BC F8 FF FF 89 85 2C FE FF FF 8D 85 C0 F8 FF FF 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 8B 9D 2C FE FF FF 89 9D E8 F6 FF FF 85 DB 0F 85 EC 00 00 00 33 C9 E9 05 01 00 00 33 C0 50 89 85 EC F6 FF FF 89 85 2C FE FF FF 8D 85 F0 F6 FF FF 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 32 C0 E9 45 FF FF FF 83 A5 BC F8 FF FF 00 83 A5 2C FE FF FF 00 6A 00 EB 64 83 FF 01 74 A9 85 DB 74 AD 33 C9 33 F6 8B C7 F7 A4 B5 30 FE FF FF 03 C1 89 84 B5 30 FE FF FF 83 D2 00 46 8B CA 3B F3 75 E4 85 C9 0F 84 71 FF FF FF 8B 85 2C FE FF FF 83 F8 73 73 19 89 8C 85 30 FE FF FF 8B 9D 2C FE FF FF 43 89 9D 2C FE FF FF E9 53 FF FF FF 33 C0 89 85 BC F8 FF FF 89 85 2C FE FF FF 50 8D 85 C0 F8 FF FF 50 8D 85 30 FE FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 85 AC F6 FF FF 83 C4 10 FF B5 A8 F6 FF FF 0F B6 80 08 03 00 00 50 E8 ?? ?? ?? ?? 59 59 6A 03 58 E9 8E 11 00 00 8B 84 9D 2C FE FF FF 83 A5 CC F6 FF FF 00 0F BD C0 74 03 40 EB 02 33 C0 8D 4B FF C1 E1 05 03 C8 8B 85 E0 F6 FF FF 89 8D BC F6 FF FF 3B 8D B0 F6 FF FF 0F 83 29 11 00 00 85 C0 0F 84 21 11 00 00 8B BD D8 F6 FF FF 33 DB 33 F6 89 9D E4 F6 FF FF 33 C9 89 9D 8C FA FF FF 89 B5 DC F6 FF FF 3B BD C4 F6 FF FF 0F 84 3D 06 00 00 83 F9 09 0F 85 04 01 00 00 85 DB 0F 84 86 00 00 00 33 C9 BE 00 CA 9A 3B 33 FF 8B 84 BD 90 FA FF FF F7 E6 03 C1 89 84 BD 90 FA FF FF 83 D2 00 47 8B CA 3B FB 75 E4 8B B5 DC F6 FF FF 85 C9 74 4B 8B 85 8C FA FF FF 83 F8 73 73 16 89 8C 85 90 FA FF FF 8B 9D 8C FA FF FF 43 89 9D 8C FA FF FF EB 30 33 C0 50 89 85 BC F8 FF FF 89 85 8C FA FF FF 8D 85 C0 F8 FF FF 50 8D 85 90 FA FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 8B 9D 8C FA FF FF 8B BD D8 F6 FF FF 85 F6 74 6E 33 C9 85 DB 74 18 8B C6 33 F6 01 84 8D 90 FA FF FF 8B 9D 8C FA FF FF 13 F6 41 3B CB 75 E8 85 F6 74 4C 83 FB 73 73 16 89 B4 9D 90 FA FF FF 8B 9D 8C FA FF FF 43 89 9D 8C FA FF FF EB 31 83 A5 BC F8 FF FF 00 8D 85 C0 F8 FF FF 83 A5 8C FA FF FF 00 6A 00 50 8D 85 90 FA FF FF 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 8B 9D 8C FA FF FF 83 C4 10 33 F6 33 C9 0F B6 07 6B F6 0A 03 F0 41 47 89 B5 DC F6 FF FF 89 BD D8 F6 FF FF 3B BD C4 F6 FF FF 0F 85 D1 FE FF FF 89 9D E4 F6 FF FF 85 C9 0F 84 FA 04 00 00 8B C1 33 D2 6A 0A 59 F7 F1 89 85 C8 F6 FF FF 8B CA 89 8D B4 F6 FF FF 85 C0 0F 84 6D 03 00 00 83 F8 26 76 03 6A 26 58 0F B6 0C 85 ?? ?? ?? ?? 0F B6 34 85 ?? ?? ?? ?? 8B F9 89 85 D4 F6 FF FF C1 E7 02 57 8D 04 31 89 85 BC F8 FF FF 8D 85 C0 F8 FF FF 6A 00 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 02 50 8B 85 D4 F6 FF FF 0F B7 04 85 ?? ?? ?? ?? 8D 04 85 ?? ?? ?? ?? 50 8D 85 C0 F8 FF FF 03 C7 50 E8 ?? ?? ?? ?? 8B 85 BC F8 FF FF 33 C9 41 83 C4 18 3B C1 0F 87 B3 00 00 00 8B BD C0 F8 FF FF 85 FF 75 1A 33 C0 89 85 EC F6 FF FF 89 85 8C FA FF FF 50 8D 85 F0 F6 FF FF E9 87 02 00 00 3B F9 75 07 8A C1 E9 9F 02 00 00 85 DB 74 F5 33 C9 33 F6 8B C7 F7 A4 B5 90 FA FF FF 03 C1 89 84 B5 90 FA FF FF 83 D2 00 46 8B CA 3B F3 75 E4 85 C9 74 4F 8B 85 8C FA FF FF 83 F8 73 73 16 89 8C 85 90 FA FF FF 8B 9D 8C FA FF FF 43 89 9D 8C FA FF FF EB 34 33 DB 8D 85 C0 F8 FF FF 53 50 8D 85 90 FA FF FF 89 9D BC F8 FF FF 68 CC 01 00 00 50 89 9D 8C FA FF FF E8 ?? ?? ?? ?? 8A C3 E9 19 02 00 00 8B 9D 8C FA FF FF B0 01 E9 15 02 00 00 3B D9 0F 87 8E 00 00 00 8B BD 90 FA FF FF BB CC 01 00 00 89 85 8C FA FF FF C1 E0 02 50 8D 85 C0 F8 FF FF 50 8D 85 90 FA FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 33 C0 85 FF 75 1A 50 89 85 BC F8 FF FF 89 85 8C FA FF FF 8D 85 C0 F8 FF FF 50 53 E9 AA 01 00 00 8B 9D 8C FA FF FF 40 89 9D E4 F6 FF FF 3B F8 0F 84 B2 01 00 00 85 DB 0F 84 AA 01 00 00 33 C9 33 F6 8B C7 F7 A4 B5 90 FA FF FF 03 C1 89 84 B5 90 FA FF FF 83 D2 00 46 8B CA 3B F3 75 E4 E9 0A FF FF FF 3B C3 8D BD C0 F8 FF FF 0F 92 C1 84 C9 75 79 8D BD 90 FA FF FF 8D 95 C0 F8 FF FF 89 95 C4 F6 FF FF 89 85 D8 F6 FF FF 84 C9 75 08 89 9D D8 F6 FF FF 8B D8 33 D2 33 F6 89 95 5C FC FF FF 39 95 D8 F6 FF FF 0F 84 07 01 00 00 8D 85 60 FC FF FF 2B F8 89 BD B8 }
	condition:
		$1
}

rule file_23_133_0 {
	meta:
		name = "?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
		size = 172
		refs = "0041 ?normal_mantissa_mask@floating_point_value@__crt_strtox@@QBE_KXZ 009e ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 33 C9 8B 55 08 53 56 33 DB 57 33 FF 8D 72 08 38 48 04 8B 02 0F 94 C1 48 49 83 E1 1D 83 C1 18 03 C1 8D 4A 08 89 45 F8 8B 42 04 03 C8 89 4D FC 3B F1 74 35 8B 4D 0C E8 ?? ?? ?? ?? 3B DA 77 23 72 04 3B F8 77 1D 0F B6 06 8B 4D FC 0F A4 FB 04 99 C1 E7 04 03 F8 13 DA 83 6D F8 04 46 3B F1 75 D3 EB 03 8B 4D FC 8B 55 08 B0 01 EB 0D 84 C0 74 10 8A 06 46 84 C0 74 F1 32 C0 88 45 FC 3B F1 75 EC FF 75 0C 0F B6 82 08 03 00 00 FF 75 FC 50 FF 75 F8 53 57 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_134_0 {
	meta:
		name = "?count_sequential_high_zeroes@__crt_strtox@@YAII@Z"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 0F BD 4D 08 74 09 B8 1F 00 00 00 2B C1 5D C3 B8 20 00 00 00 5D C3 }
	condition:
		$1
}

rule file_23_136_0 {
	meta:
		name = "?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ"
		size = 58
		refs = "0016 __calloc_base 0026 ??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 002e __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B F1 83 3E 00 75 25 6A 01 68 00 20 00 00 E8 ?? ?? ?? ?? 59 59 89 45 FC 8B CE 8D 45 FC 50 E8 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 8B 06 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_137_0 {
	meta:
		name = "?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QBE_KXZ"
		size = 23
	strings:
		$1 = { 80 79 04 00 74 09 83 C8 FF BA FF FF 0F 00 C3 B8 FF FF 7F 00 33 D2 C3 }
	condition:
		$1
}

rule file_23_138_0 {
	meta:
		name = "?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z"
		size = 1198
		refs = "006a _memcpy_s 00fb __aulldvrm 028d __allshl 0303 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 1C 02 00 00 53 8B 5D 08 8B 03 85 C0 75 07 33 D2 5B 8B E5 5D C3 57 8B 7D 0C 8B 0F 85 C9 75 0A 5F 33 C0 33 D2 5B 8B E5 5D C3 56 8D 70 FF 8D 41 FF 89 75 F8 85 C0 0F 85 2F 01 00 00 8B 4F 04 89 4D D8 83 F9 01 75 2F 8B 73 04 8D 4B 04 50 89 85 E4 FD FF FF 89 03 8D 85 E8 FD FF FF 50 68 CC 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 8B C6 33 D2 5E 5F 5B 8B E5 5D C3 85 F6 75 49 8B 73 04 8D 85 E8 FD FF FF 6A 00 50 8D 7B 04 C7 85 E4 FD FF FF 00 00 00 00 68 CC 01 00 00 57 C7 03 00 00 00 00 E8 ?? ?? ?? ?? 33 D2 8B C6 F7 75 D8 83 C4 10 33 C9 3B CA 89 17 1B C9 5E F7 D9 33 D2 5F 89 0B 5B 8B E5 5D C3 33 FF C7 45 F4 00 00 00 00 C7 45 FC 00 00 00 00 89 7D E8 83 FE FF 74 46 8B 45 F8 46 40 89 45 E0 8D 34 B3 8D 64 24 00 53 6A 00 51 33 C0 0B 06 57 50 E8 ?? ?? ?? ?? 89 5D E8 5B 89 55 C0 8D 76 FC 33 D2 8B F9 8B 4D F4 03 D0 89 55 F4 83 D1 00 83 6D E0 01 89 4D FC 8B 4D D8 75 CC 8B 5D 08 6A 00 8D 85 E8 FD FF FF C7 85 E4 FD FF FF 00 00 00 00 50 8D 73 04 C7 03 00 00 00 00 68 CC 01 00 00 56 E8 ?? ?? ?? ?? 8B 45 E8 83 C4 10 8B 55 FC 33 C9 3B C8 89 3E 89 43 08 8B 45 F4 1B C9 F7 D9 5E 41 5F 89 0B 5B 8B E5 5D C3 3B C6 77 47 8B D6 8D 48 01 2B D0 89 4D C8 8B CE 3B F2 7C 32 8B C1 46 2B C2 8D 34 B3 8D 3C 87 83 C7 04 8B 07 3B 06 75 0D 49 83 EF 04 83 EE 04 3B CA 7D EF EB 11 8B 75 0C 8B C1 2B C2 8B 44 86 04 3B 44 8B 04 73 01 42 85 D2 75 0B 5E 5F 33 C0 33 D2 5B 8B E5 5D C3 8B 7D C8 8B 45 0C 8B 34 B8 8B 44 B8 FC 89 45 E4 0F BD C6 89 75 CC 74 09 B9 1F 00 00 00 2B C8 EB 05 B9 20 00 00 00 B8 20 00 00 00 89 4D DC 2B C1 89 45 D0 85 C9 74 29 8B 45 E4 8B 4D D0 D3 E8 8B 4D DC D3 65 E4 D3 E6 0B F0 89 75 CC 83 FF 02 76 0F 8B 75 0C 8B 4D D0 8B 44 BE F8 D3 E8 09 45 E4 33 F6 C7 45 B8 00 00 00 00 83 C2 FF 89 55 E0 0F 88 2E 02 00 00 8D 4B 04 8D 0C 91 89 4D E8 8D 04 3A 8D 4B FC 89 45 F4 8D 0C 81 89 4D B4 3B 45 F8 77 05 8B 41 08 EB 02 33 C0 83 7D DC 00 8B 51 04 8B 09 89 45 C4 C7 45 D8 00 00 00 00 89 45 FC 89 4D EC 76 49 8B F9 8B C2 8B 4D D0 33 F6 8B 55 FC D3 EF 8B 4D DC E8 ?? ?? ?? ?? 8B 4D DC 0B F2 0B F8 8B C6 8B 75 EC 8B D7 D3 E6 83 7D F4 03 89 45 FC 89 75 EC 72 17 8B 45 C8 03 45 E0 8B 4D D0 8B 44 83 F8 D3 E8 0B F0 8B 45 FC 89 75 EC 53 6A 00 FF 75 CC 50 52 E8 ?? ?? ?? ?? 89 5D D8 5B 8B D8 33 F6 8B C2 89 5D FC 89 45 F0 8B F9 89 5D BC 89 45 C0 89 75 D8 85 C0 75 05 83 FB FF 76 2A 6A 00 FF 75 CC 83 C3 01 83 D0 FF 50 53 E8 ?? ?? ?? ?? 03 F8 13 F2 83 CB FF 33 C0 89 75 D8 89 5D FC 89 5D BC 89 45 F0 89 45 C0 85 F6 77 56 72 0B 83 FF FF 77 4F 8D 9B 00 00 00 00 50 53 33 C9 8B F7 0B 4D EC 6A 00 FF 75 E4 89 4D FC E8 ?? ?? ?? ?? 3B D6 72 29 77 05 3B 45 FC 76 22 8B 45 F0 83 C3 FF 89 5D BC 83 D0 FF 03 7D CC 89 45 F0 83 55 D8 00 89 45 C0 75 0A 83 FF FF 76 BF EB 03 8B 45 F0 89 5D FC 85 C0 75 08 85 DB 0F 84 AE 00 00 00 8B 4D C8 33 FF 33 F6 85 C9 74 56 8B 45 0C 8B 5D E8 83 C0 04 89 45 EC 89 4D F8 90 8B 00 89 45 D8 8B 45 C0 F7 65 D8 8B C8 8B 45 BC F7 65 D8 03 D1 03 F8 8B 03 8B CF 13 F2 8B FE 33 F6 3B C1 73 05 83 C7 01 13 F6 2B C1 89 03 83 C3 04 8B 45 EC 83 C0 04 83 6D F8 01 89 45 EC 75 C0 8B 5D FC 8B 4D C8 33 C0 3B C6 77 40 72 05 39 7D C4 73 39 85 C9 74 2E 8B 75 0C 8B F9 8B 55 E8 83 C6 04 8B D8 8B 0A 8D 76 04 33 C0 8D 52 04 03 4E FC 13 C0 03 CB 89 4A FC 83 D0 00 8B D8 83 EF 01 75 E2 8B 5D FC 83 C3 FF 83 55 F0 FF 8B 45 F4 48 89 45 F8 8B 75 B8 33 C0 8B 55 E0 03 C3 8B 4D B4 8B F8 8B 45 F4 83 D6 00 83 6D E8 04 4A 8B 5D 08 83 E9 04 48 89 7D B8 89 55 E0 89 4D B4 89 45 F4 85 D2 0F 89 EC FD FF FF EB 02 33 FF 8B 55 F8 42 8B C2 3B 03 73 18 8D 48 01 8D 0C 8B 8D 64 24 00 C7 01 00 00 00 00 8D 49 04 40 3B 03 72 F2 89 13 85 D2 74 0F 8B 0B 83 3C 8B 00 75 07 83 C1 FF 89 0B 75 F1 8B D6 8B C7 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_141_0 {
	meta:
		name = "?exponent_bias@floating_point_value@__crt_strtox@@QBEHXZ"
		size = 18
		altNames = "?maximum_binary_exponent@floating_point_value@__crt_strtox@@QBEHXZ"
	strings:
		$1 = { 33 C0 38 41 04 0F 94 C0 48 25 80 03 00 00 83 C0 7F C3 }
	condition:
		$1
}

rule file_23_143_0 {
	meta:
		name = "?get@?$console_input_adapter@D@__crt_stdio_input@@QAEHXZ"
		size = 19
		refs = "0006 __getche_nolock"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 83 F8 FF 74 02 FF 06 5E C3 }
	condition:
		$1
}

rule file_23_144_0 {
	meta:
		name = "?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ"
		size = 27
		refs = "0006 __getwche_nolock"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 74 02 FF 06 5E C3 }
	condition:
		$1
}

rule file_23_145_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEDXZ"
		size = 53
		refs = "0024 __getche_nolock"
	strings:
		$1 = { 83 41 10 01 8B 51 08 8B C2 83 51 14 00 56 8B 71 0C 0B C6 74 0C 39 71 14 72 07 77 15 39 51 10 77 10 8B 31 E8 ?? ?? ?? ?? 83 F8 FF 74 04 FF 06 5E C3 32 C0 5E C3 }
	condition:
		$1
}

rule file_23_146_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
		size = 57
		refs = "0024 ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ"
	strings:
		$1 = { 83 41 10 01 8B 51 08 8B C2 83 51 14 00 56 8B 71 0C 0B C6 74 0C 39 71 14 72 07 77 19 39 51 10 77 14 8B 09 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 02 33 C0 5E C3 }
	condition:
		$1
}

rule file_729_232_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
		size = 57
		refs = "0024 ?get@?$stream_input_adapter@_W@__crt_stdio_input@@QAEGXZ"
	strings:
		$1 = { 83 41 10 01 8B 51 08 8B C2 83 51 14 00 56 8B 71 0C 0B C6 74 0C 39 71 14 72 07 77 19 39 51 10 77 14 8B 09 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 02 33 C0 5E C3 }
	condition:
		$1
}

rule file_729_234_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_WXZ"
		size = 57
		refs = "0024 ?get@?$string_input_adapter@_W@__crt_stdio_input@@QAEGXZ"
	strings:
		$1 = { 83 41 10 01 8B 51 08 8B C2 83 51 14 00 56 8B 71 0C 0B C6 74 0C 39 71 14 72 07 77 19 39 51 10 77 14 8B 09 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 02 33 C0 5E C3 }
	condition:
		$1
}

rule file_23_147_0 {
	meta:
		name = "?invert@?$scanset_buffer@E@__crt_stdio_input@@QAEXXZ"
		size = 30
	strings:
		$1 = { 8D 51 20 8B C2 56 33 F6 2B C1 3B D1 1B D2 F7 D2 23 D0 74 08 F6 11 41 46 3B F2 75 F8 5E C3 }
	condition:
		$1
}

rule file_23_148_0 {
	meta:
		name = "?invert@?$scanset_buffer@_W@__crt_stdio_input@@QAEXXZ"
		size = 40
		refs = "0004 ?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 33 F6 8D 90 00 20 00 00 8B CA 2B C8 3B D0 1B D2 F7 D2 23 D1 74 08 F6 10 40 46 3B F2 75 F8 5E C3 }
	condition:
		$1
}

rule file_23_149_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@H@Z"
		size = 70
		refs = "0028 ?test@?$scanset_buffer@E@__crt_stdio_input@@QBE_NE@Z"
		altNames = "?is_character_allowed_in_string@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 83 FA FF 75 04 32 C0 EB 31 8B 45 08 83 E8 00 74 27 83 E8 01 74 12 83 E8 07 75 EA 52 83 C1 3C E8 ?? ?? ?? ?? 84 C0 EB 0B 8D 42 F7 83 F8 04 76 D5 83 FA 20 0F 95 C0 EB 02 B0 01 5D C2 08 00 }
	condition:
		$1
}

rule file_23_150_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z"
		size = 77
		refs = "002d ?test@?$scanset_buffer@_W@__crt_stdio_input@@QBE_N_W@Z"
		altNames = "?is_character_allowed_in_string@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NW4conversion_mode@2@G@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C B8 FF FF 00 00 66 3B D0 75 04 32 C0 EB 33 8B 45 08 83 E8 00 74 29 83 E8 01 74 12 83 E8 07 75 EA 52 83 C1 44 E8 ?? ?? ?? ?? 84 C0 EB 0D 8D 42 F7 66 83 F8 04 76 D4 66 83 FA 20 0F 95 C0 EB 02 B0 01 5D C2 08 00 }
	condition:
		$1
}

rule file_23_151_0 {
	meta:
		name = "?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 41 D0 83 F8 09 77 04 B0 01 5D C3 8D 41 9F 83 F8 19 76 F4 8D 41 BF 83 F8 19 76 EC 83 F9 5F 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_23_153_0 {
	meta:
		name = "?is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@1@W4length_modifier@1@@Z"
		size = 26
		refs = "0011 ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 8B FF 55 8B EC 6B 55 08 0C 33 C0 8B 4D 0C 38 84 0A ?? ?? ?? ?? 0F 95 C0 5D C3 }
	condition:
		$1
}

rule file_23_154_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_NDQAU__crt_locale_pointers@@@Z"
		size = 31
		refs = "0010 __ischartype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 0F B6 45 08 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_23_155_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_N_WPAU__crt_locale_pointers@@@Z"
		size = 25
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 FF 75 08 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 F7 D8 5D C3 }
	condition:
		$1
}

rule file_23_161_0 {
	meta:
		name = "?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ"
		size = 65
		refs = "0027 ?to_floating_point_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z 0031 ?to_integer_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
	strings:
		$1 = { 8B 41 28 85 C0 78 19 83 F8 01 7E 2B 83 F8 06 7E 1C 83 F8 07 74 0D 83 F8 08 74 1C 83 F8 09 74 0D 33 C0 C3 FF 71 20 E8 ?? ?? ?? ?? EB 08 FF 71 20 E8 ?? ?? ?? ?? 59 C3 33 C0 38 41 24 0F 95 C0 40 C3 }
	condition:
		$1
}

rule file_23_162_0 {
	meta:
		name = "?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ"
		size = 65
		refs = "0027 ?to_floating_point_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z 0031 ?to_integer_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
	strings:
		$1 = { 8B 41 30 85 C0 78 19 83 F8 01 7E 2B 83 F8 06 7E 1C 83 F8 07 74 0D 83 F8 08 74 1C 83 F8 09 74 0D 33 C0 C3 FF 71 28 E8 ?? ?? ?? ?? EB 08 FF 71 28 E8 ?? ?? ?? ?? 59 C3 33 C0 38 41 2C 0F 95 C0 40 C3 }
	condition:
		$1
}

rule file_23_166_0 {
	meta:
		name = "?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 33 D2 8B 4D 0C 89 48 04 8B 4D 10 85 C9 89 48 08 0F 95 C2 42 89 10 5D C3 }
	condition:
		$1
}

rule file_23_167_0 {
	meta:
		name = "?mantissa_bits@floating_point_value@__crt_strtox@@QBEHXZ"
		size = 16
	strings:
		$1 = { 33 C0 38 41 04 0F 94 C0 48 83 E0 1D 83 C0 18 C3 }
	condition:
		$1
}

rule file_23_170_0 {
	meta:
		name = "?minimum_binary_exponent@floating_point_value@__crt_strtox@@QBEHXZ"
		size = 18
	strings:
		$1 = { 33 C0 38 41 04 0F 94 C0 48 25 80 FC FF FF 83 C0 82 C3 }
	condition:
		$1
}

rule file_23_174_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@ABU21@@Z"
		size = 953
		refs = "000c ___security_cookie 00b6 @__security_check_cookie@4 00de _memcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C0 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 53 8B 5D 08 56 8B 11 89 9D 20 FE FF FF 57 83 FA 01 0F 87 C9 00 00 00 8B 79 04 85 FF 75 1E 57 8D 85 30 FE FF FF 89 BD 2C FE FF FF 50 68 CC 01 00 00 8D 43 04 89 3B 50 E9 05 03 00 00 83 FF 01 0F 84 04 03 00 00 8B 03 85 C0 0F 84 FA 02 00 00 8D 53 04 33 F6 89 95 28 FE FF FF 33 C9 8B D8 8B C7 F7 24 8A 03 C6 83 D2 00 8B F2 8B 95 28 FE FF FF 89 04 8A 41 3B CB 75 E6 8B 9D 20 FE FF FF 85 F6 0F 84 C3 02 00 00 8B 03 83 F8 73 73 19 89 74 83 04 B0 01 FF 03 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 6A 00 8D 85 30 FE FF FF C7 85 2C FE FF FF 00 00 00 00 50 68 CC 01 00 00 52 C7 03 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 33 89 B5 1C FE FF FF 83 FE 01 0F 87 E8 00 00 00 8B 7B 04 8D 73 04 89 13 8B 01 C1 E0 02 50 8D 41 04 89 BD 24 FE FF FF 50 68 CC 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 10 85 FF 75 1B 57 8D 85 30 FE FF FF 89 BD 2C FE FF FF 50 68 CC 01 00 00 89 3B 56 E9 0B 02 00 00 83 FF 01 0F 84 0A 02 00 00 8B 03 89 85 28 FE FF FF 85 C0 0F 84 FA 01 00 00 8B 9D 24 FE FF FF 33 FF 33 C9 8B C3 F7 24 8E 03 C7 89 04 8E 83 D2 00 41 8B FA 3B 8D 28 FE FF FF 75 E8 8B 9D 20 FE FF FF 85 FF 0F 84 CA 01 00 00 8B 03 83 F8 73 73 19 89 7C 83 04 B0 01 FF 03 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 6A 00 8D 85 30 FE FF FF C7 85 2C FE FF FF 00 00 00 00 50 68 CC 01 00 00 56 C7 03 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 3B D6 0F 92 C0 84 C0 8D 43 04 89 85 18 FE FF FF 74 0D 89 85 28 FE FF FF 8D 79 04 8B C2 EB 13 8B F8 89 95 1C FE FF FF 8D 41 04 89 85 28 FE FF FF 8B C6 33 D2 89 85 24 FE FF FF 33 DB 89 95 2C FE FF FF 85 C0 0F 84 FC 00 00 00 8D 85 30 FE FF FF 2B F8 89 BD 10 FE FF FF 8D A4 24 00 00 00 00 8D 04 9F 8B 84 05 30 FE FF FF 89 85 14 FE FF FF 85 C0 75 1D 3B DA 0F 85 BE 00 00 00 8D 53 01 89 84 9D 30 FE FF FF 89 95 2C FE FF FF E9 A9 00 00 00 33 F6 33 FF 8B CB 39 B5 1C FE FF FF 0F 84 8C 00 00 00 83 F9 73 74 4A 3B CA 75 16 8D 43 01 C7 84 8D 30 FE FF FF 00 00 00 00 03 C7 89 85 2C FE FF FF 8B 85 28 FE FF FF 8B 04 B8 F7 A5 14 FE FF FF 03 C6 83 D2 00 01 84 8D 30 FE FF FF 83 D2 00 47 41 8B F2 8B 95 2C FE FF FF 3B BD 1C FE FF FF 75 B1 85 F6 74 39 83 F9 73 0F 84 85 00 00 00 3B CA 75 14 8D 41 01 C7 84 8D 30 FE FF FF 00 00 00 00 89 85 2C FE FF FF 8B C6 33 F6 01 84 8D 30 FE FF FF 8B 95 2C FE FF FF 13 F6 41 85 F6 75 C7 83 F9 73 74 50 8B BD 10 FE FF FF 43 3B 9D 24 FE FF FF 0F 85 19 FF FF FF 8B 85 20 FE FF FF 89 10 8D 04 95 00 00 00 00 50 8D 85 30 FE FF FF 50 68 CC 01 00 00 FF B5 18 FE FF FF E8 ?? ?? ?? ?? 83 C4 10 5F 5E B0 01 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 85 20 FE FF FF 6A 00 C7 85 40 FC FF FF 00 00 00 00 C7 00 00 00 00 00 8D 85 44 FC FF FF 50 68 CC 01 00 00 FF B5 18 FE FF FF E8 ?? ?? ?? ?? 8B 4D FC 83 C4 10 33 CD 32 C0 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_175_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 196
		refs = "0030 _memcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D8 01 00 00 57 8B 7D 0C 85 FF 75 2B 8B 45 08 8D 8D 2C FE FF FF 57 51 68 CC 01 00 00 89 38 83 C0 04 50 89 BD 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 10 B0 01 5F 8B E5 5D C3 83 FF 01 74 F4 8B 4D 08 8B 01 85 C0 74 EB 53 8D 51 04 33 DB 56 89 55 F8 33 F6 8B C8 8D 9B 00 00 00 00 8B C7 F7 24 B2 03 C3 83 D2 00 8B DA 8B 55 F8 89 04 B2 46 3B F1 75 E9 8B 4D 08 85 DB 74 0D 8B 01 83 F8 73 73 0F 89 5C 81 04 FF 01 5E 5B B0 01 5F 8B E5 5D C3 6A 00 8D 85 2C FE FF FF C7 85 28 FE FF FF 00 00 00 00 50 68 CC 01 00 00 52 C7 01 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5E 5B 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_176_0 {
	meta:
		name = "?multiply_64_32@__crt_strtox@@YA_K_KI@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C F7 65 10 8B C8 8B 45 08 F7 65 10 03 D1 5D C3 }
	condition:
		$1
}

rule file_23_177_0 {
	meta:
		name = "?multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 1426
		refs = "000c ___security_cookie 0062 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0089 _memset 00a0 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 00af _memcpy 00f4 _memcpy_s 03eb __errno 043e __invalid_parameter_noinfo 0475 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 04a9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C8 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC B8 CD CC CC CC F7 65 0C 53 8B CA C1 E9 03 56 8B C1 89 8D 48 FC FF FF 89 85 3C FC FF FF 57 8B 7D 08 89 BD 58 FC FF FF 85 C0 0F 84 22 04 00 00 83 F8 26 76 0D BB 26 00 00 00 89 9D 40 FC FF FF EB 08 8B D8 89 85 40 FC FF FF 0F B6 0C 9D ?? ?? ?? ?? 0F B6 34 9D ?? ?? ?? ?? 8D 3C 8D 00 00 00 00 8D 04 31 57 89 85 2C FE FF FF 8D 85 30 FE FF FF 6A 00 50 E8 ?? ?? ?? ?? 8D 04 B5 00 00 00 00 50 0F B7 04 9D ?? ?? ?? ?? 8D 04 85 ?? ?? ?? ?? 50 8D 85 30 FE FF FF 03 C7 50 E8 ?? ?? ?? ?? 8B 8D 2C FE FF FF 83 C4 18 83 F9 01 0F 87 DC 00 00 00 8B BD 30 FE FF FF 85 FF 75 31 89 BD 5C FC FF FF 8D 85 60 FC FF FF 8B BD 58 FC FF FF 6A 00 50 68 CC 01 00 00 8D 47 04 C7 07 00 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 E9 42 03 00 00 83 FF 01 75 0B 8B BD 58 FC FF FF E9 32 03 00 00 8B 85 58 FC FF FF 8B 18 85 DB 75 07 8B F8 E9 1F 03 00 00 33 F6 8D 50 04 33 C9 8D 9B 00 00 00 00 8B C7 8B BD 30 FE FF FF F7 24 8A 03 C6 83 D2 00 8B F2 8B 95 58 FC FF FF 83 C2 04 89 04 8A 41 3B CB 75 DD 8B BD 58 FC FF FF 85 F6 0F 84 E1 02 00 00 8B 07 83 F8 73 73 0B 89 74 87 04 FF 07 E9 CF 02 00 00 6A 00 8D 85 30 FE FF FF C7 85 2C FE FF FF 00 00 00 00 50 68 CC 01 00 00 52 C7 07 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 32 C0 E9 A3 02 00 00 8B BD 58 FC FF FF 8B 17 8D 77 04 89 95 50 FC FF FF 83 FA 01 0F 87 CF 00 00 00 8B 1E 8D 04 8D 00 00 00 00 50 8D 85 30 FE FF FF 89 0F 50 68 CC 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 10 85 DB 75 23 53 8D 85 30 FE FF FF 89 9D 2C FE FF FF 50 68 CC 01 00 00 56 89 1F E8 ?? ?? ?? ?? 83 C4 10 E9 3F 02 00 00 83 FB 01 0F 84 36 02 00 00 8B 07 89 85 54 FC FF FF 85 C0 0F 84 26 02 00 00 33 FF 33 C9 8B C3 F7 24 8E 03 C7 89 04 8E 83 D2 00 41 8B FA 3B 8D 54 FC FF FF 75 E8 85 FF 0F 84 C5 FE FF FF 8B 85 58 FC FF FF 8B 08 83 F9 73 73 0D 89 7C 88 04 8B F8 FF 07 E9 E8 01 00 00 8B F8 C7 85 2C FE FF FF 00 00 00 00 6A 00 8D 85 30 FE FF FF 50 68 CC 01 00 00 56 C7 07 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 32 C0 E9 BA 01 00 00 3B CA 0F 92 C0 84 C0 74 10 89 B5 44 FC FF FF 8B C1 8D B5 30 FE FF FF EB 14 8D 85 30 FE FF FF 89 8D 50 FC FF FF 89 85 44 FC FF FF 8B C2 33 D2 89 85 54 FC FF FF 33 DB 89 95 5C FC FF FF 85 C0 0F 84 0B 01 00 00 8D 85 60 FC FF FF 2B F0 89 B5 4C FC FF FF 8D 49 00 8D 04 9E 8B 84 05 60 FC FF FF 89 85 38 FC FF FF 85 C0 75 1D 3B DA 0F 85 CB 00 00 00 8D 53 01 89 84 9D 60 FC FF FF 89 95 5C FC FF FF E9 B6 00 00 00 33 F6 33 FF 8B CB 39 B5 50 FC FF FF 0F 84 99 00 00 00 83 F9 73 74 51 3B CA 75 16 8D 43 01 C7 84 8D 60 FC FF FF 00 00 00 00 03 C7 89 85 5C FC FF FF 8B 85 44 FC FF FF 8B 04 B8 F7 A5 38 FC FF FF 03 C6 83 D2 00 03 84 8D 60 FC FF FF 89 84 8D 60 FC FF FF 83 D2 00 47 41 8B F2 8B 95 5C FC FF FF 3B BD 50 FC FF FF 75 AA 85 F6 74 3F 8D 49 00 83 F9 73 74 72 3B CA 75 14 8D 41 01 C7 84 8D 60 FC FF FF 00 00 00 00 89 85 5C FC FF FF 8B C6 33 F6 03 84 8D 60 FC FF FF 89 84 8D 60 FC FF FF 8B 95 5C FC FF FF 13 F6 41 85 F6 75 C4 83 F9 73 74 36 8B B5 4C FC FF FF 43 3B 9D 54 FC FF FF 0F 85 0C FF FF FF 8B BD 58 FC FF FF 89 17 C1 E2 02 85 D2 74 5F 8D 47 04 85 C0 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 46 8B BD 58 FC FF FF 32 C0 C7 07 00 00 00 00 EB 3D 81 FA CC 01 00 00 77 13 52 8D 8D 60 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 0C EB 20 68 CC 01 00 00 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? B0 01 84 C0 74 69 8B 85 3C FC FF FF 2B 85 40 FC FF FF 89 85 3C FC FF FF 0F 85 E4 FB FF FF 8B 8D 48 FC FF FF 8D 04 89 8B 4D 0C 03 C0 2B C8 74 2C 8B 1C 8D ?? ?? ?? ?? 85 DB 75 71 53 8D 85 30 FE FF FF 89 9D 2C FE FF FF 50 8D 47 04 89 1F 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 5F 5E B0 01 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 6A 00 8D 85 30 FE FF FF C7 85 2C FE FF FF 00 00 00 00 50 8D 47 04 C7 07 00 00 00 00 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 83 FB 01 74 AB 8B 07 89 85 48 FC FF FF 85 C0 74 9F 8D 57 04 33 F6 89 95 4C FC FF FF 33 C9 8B F8 8B FF 8B C3 F7 24 8A 03 C6 83 D2 00 8B F2 8B 95 4C FC FF FF 89 04 8A 41 3B CF 75 E6 8B BD 58 FC FF FF 85 F6 0F 84 66 FF FF FF 8B 07 83 F8 73 73 19 89 74 87 04 B0 01 FF 07 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 6A 00 8D 85 30 FE FF FF C7 85 2C FE FF FF 00 00 00 00 50 68 CC 01 00 00 52 C7 07 00 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 10 33 CD 32 C0 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_178_0 {
	meta:
		name = "?multiply_core@__crt_strtox@@YAIQAIII@Z"
		size = 62
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 0C 33 F6 33 C9 85 FF 74 26 8B 55 08 53 8B 5D 10 8D A4 24 00 00 00 00 8B C3 F7 24 8A 03 C6 83 D2 00 8B F2 8B 55 08 89 04 8A 41 3B CF 75 E9 5B 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_23_179_0 {
	meta:
		name = "?normal_mantissa_mask@floating_point_value@__crt_strtox@@QBE_KXZ"
		size = 23
	strings:
		$1 = { 80 79 04 00 74 09 83 C8 FF BA FF FF 1F 00 C3 B8 FF FF FF 00 33 D2 C3 }
	condition:
		$1
}

rule file_23_180_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAID@Z"
		size = 58
	strings:
		$1 = { 8B FF 55 8B EC 8A 4D 08 8D 41 D0 3C 09 77 08 0F BE C1 83 E8 30 5D C3 8D 41 9F 3C 19 77 08 0F BE C1 83 E8 57 5D C3 8D 41 BF 3C 19 77 08 0F BE C1 83 E8 37 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_23_181_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAI_W@Z"
		size = 484
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A 30 5A 66 3B CA 0F 82 9F 01 00 00 66 83 F9 3A 73 0A 0F B7 C1 2B C2 E9 8A 01 00 00 BA 10 FF 00 00 66 3B CA 0F 83 6B 01 00 00 BA 60 06 00 00 66 3B CA 0F 82 73 01 00 00 8D 42 0A 66 3B C8 72 D2 BA F0 06 00 00 66 3B CA 0F 82 5D 01 00 00 8D 42 0A 66 3B C8 72 BC BA 66 09 00 00 66 3B CA 0F 82 47 01 00 00 8D 42 0A 66 3B C8 72 A6 8D 50 76 66 3B CA 0F 82 33 01 00 00 8D 42 0A 66 3B C8 72 92 8D 50 76 66 3B CA 0F 82 1F 01 00 00 8D 42 0A 66 3B C8 0F 82 7A FF FF FF 8D 50 76 66 3B CA 0F 82 07 01 00 00 8D 42 0A 66 3B C8 0F 82 62 FF FF FF 8D 50 76 66 3B CA 0F 82 EF 00 00 00 8D 42 0A 66 3B C8 0F 82 4A FF FF FF BA 66 0C 00 00 66 3B CA 0F 82 D5 00 00 00 8D 42 0A 66 3B C8 0F 82 30 FF FF FF 8D 50 76 66 3B CA 0F 82 BD 00 00 00 8D 42 0A 66 3B C8 0F 82 18 FF FF FF 8D 50 76 66 3B CA 0F 82 A5 00 00 00 8D 42 0A 66 3B C8 0F 82 00 FF FF FF BA 50 0E 00 00 66 3B CA 0F 82 8B 00 00 00 8D 42 0A 66 3B C8 0F 82 E6 FE FF FF 8D 50 76 66 3B CA 72 77 8D 42 0A 66 3B C8 0F 82 D2 FE FF FF 83 C2 50 66 3B CA 72 63 83 C0 50 66 3B C8 0F 82 BE FE FF FF BA 40 10 00 00 66 3B CA 72 4D 8D 42 0A 66 3B C8 0F 82 A8 FE FF FF BA E0 17 00 00 66 3B CA 72 37 8D 42 0A 66 3B C8 0F 82 92 FE FF FF 83 C2 30 66 3B CA 72 23 83 C0 30 66 3B C8 73 1B E9 7D FE FF FF B8 1A FF 00 00 66 3B C8 0F 82 6F FE FF FF 83 C8 FF 83 F8 FF 75 2F 6A 41 58 6A 19 5A 66 3B C1 77 06 66 83 F9 5A 76 08 8D 41 9F 66 3B C2 77 13 8D 41 9F 66 3B C2 0F B7 C1 77 03 83 E8 20 83 C0 C9 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_23_182_0 {
	meta:
		name = "?process@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAEHXZ"
		size = 123
		refs = "000c ?validate@?$format_string_parser@D@__crt_stdio_input@@QBE_NXZ 001c ?process_state@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0027 ?advance@?$format_string_parser@D@__crt_stdio_input@@QAE_NXZ 0039 __getche_nolock 0054 __ungetch_nolock 006b __errno 0072 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 7E 10 8B CF E8 ?? ?? ?? ?? 84 C0 75 10 83 C8 FF EB 5F 8B CE E8 ?? ?? ?? ?? 84 C0 74 0B 8B CF E8 ?? ?? ?? ?? 84 C0 75 EA 83 7E 6C 00 8B 7E 68 75 21 E8 ?? ?? ?? ?? 83 F8 FF 74 05 FF 46 08 EB 03 83 CF FF 83 F8 FF 74 0A FF 4E 08 50 E8 ?? ?? ?? ?? 59 8B 06 83 E0 01 83 C8 00 74 13 8B 76 1C 85 F6 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_23_183_0 {
	meta:
		name = "?process@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAEHXZ"
		size = 125
		refs = "000c ?validate@?$format_string_parser@_W@__crt_stdio_input@@QBE_NXZ 001c ?process_state@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0027 ?advance@?$format_string_parser@_W@__crt_stdio_input@@QAE_NXZ 003d ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ 0056 ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z 006d __errno 0074 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 7E 10 8B CF E8 ?? ?? ?? ?? 84 C0 75 10 83 C8 FF EB 61 8B CE E8 ?? ?? ?? ?? 84 C0 74 0B 8B CF E8 ?? ?? ?? ?? 84 C0 75 EA 83 7E 54 00 8B 7E 50 75 23 53 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 03 83 CF FF 50 8D 4E 08 E8 ?? ?? ?? ?? 5B 8B 06 83 E0 01 83 C8 00 74 13 8B 76 1C 85 F6 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_23_184_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 22
		refs = "0011 ?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 80 79 26 00 74 03 B0 01 C3 6A 00 6A 00 FF 71 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_23_185_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 22
		refs = "0011 ?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 80 79 28 00 74 03 B0 01 C3 6A 00 6A 00 FF 71 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_23_186_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 116
		refs = "000b $LN22 0012 ?process_string_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z 0024 ?process_integer_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z 0040 ?process_floating_point_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0045 ?process_character_count_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 004c $LN4 0050 $LN5 0054 $LN7 0058 $LN8 005c $LN9 0060 $LN10 0064 $LN11 0068 $LN12 006c $LN6 0070 $LN13"
	strings:
		$1 = { 8B 41 38 83 F8 09 77 41 FF 24 85 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? C3 6A 01 EB F6 6A 08 EB F2 6A 01 6A 00 E8 ?? ?? ?? ?? C3 6A 01 6A 0A EB F4 6A 00 6A 08 EB EE 6A 00 EB F2 6A 00 6A 10 EB E4 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_286_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 116
		refs = "000b $LN22 0012 ?process_string_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z 0024 ?process_integer_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z 0040 ?process_floating_point_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0045 ?process_character_count_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 004c $LN4 0050 $LN5 0054 $LN7 0058 $LN8 005c $LN9 0060 $LN10 0064 $LN11 0068 $LN12 006c $LN6 0070 $LN13"
	strings:
		$1 = { 8B 41 38 83 F8 09 77 41 FF 24 85 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? C3 6A 01 EB F6 6A 08 EB F2 6A 01 6A 00 E8 ?? ?? ?? ?? C3 6A 01 6A 0A EB F4 6A 00 6A 08 EB EE 6A 00 EB F2 6A 00 6A 10 EB E4 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_187_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 116
		refs = "000b $LN22 0012 ?process_string_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z 0024 ?process_integer_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z 0040 ?process_floating_point_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0045 ?process_character_count_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 004c $LN4 0050 $LN5 0054 $LN7 0058 $LN8 005c $LN9 0060 $LN10 0064 $LN11 0068 $LN12 006c $LN6 0070 $LN13"
	strings:
		$1 = { 8B 41 40 83 F8 09 77 41 FF 24 85 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? C3 6A 01 EB F6 6A 08 EB F2 6A 01 6A 00 E8 ?? ?? ?? ?? C3 6A 01 6A 0A EB F4 6A 00 6A 08 EB EE 6A 00 EB F2 6A 00 6A 10 EB E4 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_287_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 116
		refs = "000b $LN22 0012 ?process_string_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z 0024 ?process_integer_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z 0040 ?process_floating_point_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0045 ?process_character_count_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 004c $LN4 0050 $LN5 0054 $LN7 0058 $LN8 005c $LN9 0060 $LN10 0064 $LN11 0068 $LN12 006c $LN6 0070 $LN13"
	strings:
		$1 = { 8B 41 40 83 F8 09 77 41 FF 24 85 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? C3 6A 01 EB F6 6A 08 EB F2 6A 01 6A 00 E8 ?? ?? ?? ?? C3 6A 01 6A 0A EB F4 6A 00 6A 08 EB EE 6A 00 EB F2 6A 00 6A 10 EB E4 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_288_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 116
		refs = "000b $LN22 0012 ?process_string_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z 0024 ?process_integer_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z 0040 ?process_floating_point_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0045 ?process_character_count_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 004c $LN4 0050 $LN5 0054 $LN7 0058 $LN8 005c $LN9 0060 $LN10 0064 $LN11 0068 $LN12 006c $LN6 0070 $LN13"
	strings:
		$1 = { 8B 41 40 83 F8 09 77 41 FF 24 85 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? C3 6A 01 EB F6 6A 08 EB F2 6A 01 6A 00 E8 ?? ?? ?? ?? C3 6A 01 6A 0A EB F4 6A 00 6A 08 EB EE 6A 00 EB F2 6A 00 6A 10 EB E4 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_188_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 48
		refs = "0006 ?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 000e ?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ 0024 ??$process_floating_point_specifier_t@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ??$process_floating_point_specifier_t@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 F8 04 74 11 83 F8 08 74 04 32 C0 5E C3 8B CE 5E E9 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_290_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 48
		refs = "0006 ?process_whitespace@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 000e ?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ 0024 ??$process_floating_point_specifier_t@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ??$process_floating_point_specifier_t@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 F8 04 74 11 83 F8 08 74 04 32 C0 5E C3 8B CE 5E E9 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_189_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 48
		refs = "0006 ?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 000e ?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ 0024 ??$process_floating_point_specifier_t@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ??$process_floating_point_specifier_t@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 F8 04 74 11 83 F8 08 74 04 32 C0 5E C3 8B CE 5E E9 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_292_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 48
		refs = "0006 ?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 000e ?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ 0024 ??$process_floating_point_specifier_t@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ??$process_floating_point_specifier_t@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 F8 04 74 11 83 F8 08 74 04 32 C0 5E C3 8B CE 5E E9 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_190_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z"
		size = 102
		refs = "000b ?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002e ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0039 ??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@H_N@Z 005b ?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? FF 75 0C 8D 45 FF C6 45 FF 00 FF 75 08 83 EC 20 8B CC 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 2C 80 7D FF 00 75 04 32 C0 EB 15 80 7E 26 00 74 04 B0 01 EB 0B 6A 01 52 50 8B CE E8 ?? ?? ?? ?? 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_729_294_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z"
		size = 102
		refs = "000b ?process_whitespace@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002e ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0039 ??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@H_N@Z 005b ?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? FF 75 0C 8D 45 FF C6 45 FF 00 FF 75 08 83 EC 20 8B CC 50 FF 76 2C 8D 46 08 FF 76 28 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 60 E8 ?? ?? ?? ?? 83 C4 2C 80 7D FF 00 75 04 32 C0 EB 15 80 7E 26 00 74 04 B0 01 EB 0B 6A 01 52 50 8B CE E8 ?? ?? ?? ?? 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_191_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z"
		size = 102
		refs = "000b ?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002e ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0039 ??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z 005b ?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? FF 75 0C 8D 45 FF C6 45 FF 00 FF 75 08 83 EC 20 8B CC 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 2C 80 7D FF 00 75 04 32 C0 EB 15 80 7E 28 00 74 04 B0 01 EB 0B 6A 01 52 50 8B CE E8 ?? ?? ?? ?? 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_729_296_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NI_N@Z"
		size = 102
		refs = "000b ?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002e ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0039 ??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z 005b ?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? FF 75 0C 8D 45 FF C6 45 FF 00 FF 75 08 83 EC 20 8B CC 50 FF 76 34 8D 46 08 FF 76 30 50 51 E8 ?? ?? ?? ?? 83 C4 14 FF 76 48 E8 ?? ?? ?? ?? 83 C4 2C 80 7D FF 00 75 04 32 C0 EB 15 80 7E 28 00 74 04 B0 01 EB 0B 6A 01 52 50 8B CE E8 ?? ?? ?? ?? 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_23_192_0 {
	meta:
		name = "?process_literal_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 49
		refs = "0006 __getche_nolock 001f __ungetch_nolock 002b ?process_literal_character_tchar@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_ND@Z"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 83 F8 FF 74 15 FF 46 08 0F B6 4E 24 50 3B C1 74 0D FF 4E 08 E8 ?? ?? ?? ?? 59 32 C0 5E C3 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_23_193_0 {
	meta:
		name = "?process_literal_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 53
		refs = "000a ?get@?$console_input_adapter@_W@__crt_stdio_input@@QAEGXZ 002a ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 04 32 C0 EB 13 66 3B 46 24 74 0B 50 8D 4E 08 E8 ?? ?? ?? ?? EB EB B0 01 5F 5E C3 }
	condition:
		$1
}

rule file_729_300_0 {
	meta:
		name = "?process_literal_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 53
		refs = "000a ?get@?$stream_input_adapter@_W@__crt_stdio_input@@QAEGXZ 002a ?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 4E 08 E8 ?? ?? ?? ?? 0F B7 C0 B9 FF FF 00 00 66 3B C1 75 04 32 C0 EB 13 66 3B 46 24 74 0B 50 8D 4E 08 E8 ?? ?? ?? ?? EB EB B0 01 5F 5E C3 }
	condition:
		$1
}

rule file_23_194_0 {
	meta:
		name = "?process_literal_character_tchar@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_ND@Z"
		size = 97
		refs = "000a ___pctype_func 0020 __getche_nolock 003e __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F1 E8 ?? ?? ?? ?? 8A 5D 08 B9 00 80 00 00 0F B6 D3 66 85 0C 50 74 3A E8 ?? ?? ?? ?? 83 F8 FF 74 03 FF 46 08 0F B6 4E 25 3B C1 74 25 83 F8 FF 74 0A FF 4E 08 50 E8 ?? ?? ?? ?? 59 0F BE C3 83 F8 FF 74 0A FF 4E 08 50 E8 ?? ?? ?? ?? 59 32 C0 EB 02 B0 01 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_23_196_0 {
	meta:
		name = "?process_state@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 54
		refs = "001d ?process_conversion_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ?process_literal_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0032 ?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 20 48 83 E8 01 74 22 83 E8 01 74 17 83 E8 01 74 04 32 C0 5E C3 E8 ?? ?? ?? ?? 84 C0 74 F5 FF 46 6C 5E C3 5E E9 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_306_0 {
	meta:
		name = "?process_state@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 54
		refs = "001d ?process_conversion_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ?process_literal_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0032 ?process_whitespace@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 20 48 83 E8 01 74 22 83 E8 01 74 17 83 E8 01 74 04 32 C0 5E C3 E8 ?? ?? ?? ?? 84 C0 74 F5 FF 46 6C 5E C3 5E E9 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_197_0 {
	meta:
		name = "?process_state@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 54
		refs = "001d ?process_conversion_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ?process_literal_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0032 ?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 20 48 83 E8 01 74 22 83 E8 01 74 17 83 E8 01 74 04 32 C0 5E C3 E8 ?? ?? ?? ?? 84 C0 74 F5 FF 46 54 5E C3 5E E9 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_729_308_0 {
	meta:
		name = "?process_state@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 54
		refs = "001d ?process_conversion_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 002c ?process_literal_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0032 ?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 20 48 83 E8 01 74 22 83 E8 01 74 17 83 E8 01 74 04 32 C0 5E C3 E8 ?? ?? ?? ?? 84 C0 74 F5 FF 46 54 5E C3 5E E9 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_198_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z"
		size = 72
		refs = "000f ?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0017 ?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ 0031 ??$process_string_specifier_tchar@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z 003f ??$process_string_specifier_tchar@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 01 56 8B F1 75 05 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 E8 01 74 17 83 E8 01 74 04 32 C0 EB 1A 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? EB 0C 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_729_310_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z"
		size = 72
		refs = "000f ?process_whitespace@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0017 ?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ 0031 ??$process_string_specifier_tchar@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z 003f ??$process_string_specifier_tchar@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 01 56 8B F1 75 05 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 E8 01 74 17 83 E8 01 74 04 32 C0 EB 1A 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? EB 0C 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_199_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z"
		size = 72
		refs = "000f ?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0017 ?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ 0031 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z 003f ??$process_string_specifier_tchar@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 01 56 8B F1 75 05 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 E8 01 74 17 83 E8 01 74 04 32 C0 EB 1A 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? EB 0C 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_729_312_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@2@@Z"
		size = 72
		refs = "000f ?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ 0017 ?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ 0031 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@_W@Z 003f ??$process_string_specifier_tchar@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 01 56 8B F1 75 05 E8 ?? ?? ?? ?? 8D 4E 10 E8 ?? ?? ?? ?? 83 E8 01 74 17 83 E8 01 74 04 32 C0 EB 1A 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? EB 0C 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_200_0 {
	meta:
		name = "?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 35
		refs = "000b ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z 001a __ungetch_nolock"
	strings:
		$1 = { 8B FF 56 FF 71 60 8D 71 08 56 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 09 FF 0E 50 E8 ?? ?? ?? ?? 59 B0 01 5E C3 }
	condition:
		$1
}

rule file_23_201_0 {
	meta:
		name = "?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 32
		refs = "000b ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0018 ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 56 FF 71 48 8D 71 08 56 E8 ?? ?? ?? ?? 59 59 0F B7 C0 8B CE 50 E8 ?? ?? ?? ?? B0 01 5E C3 }
	condition:
		$1
}

rule file_729_316_0 {
	meta:
		name = "?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NXZ"
		size = 32
		refs = "000b ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$stream_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0018 ?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 56 FF 71 48 8D 71 08 56 E8 ?? ?? ?? ?? 59 59 0F B7 C0 8B CE 50 E8 ?? ?? ?? ?? B0 01 5E C3 }
	condition:
		$1
}

rule file_23_203_0 {
	meta:
		name = "?reset@?$scanset_buffer@E@__crt_stdio_input@@QAEXXZ"
		size = 18
	strings:
		$1 = { 8B FF 57 8B F9 85 FF 74 07 6A 08 59 33 C0 F3 AB 5F C3 }
	condition:
		$1
}

rule file_23_204_0 {
	meta:
		name = "?reset@?$scanset_buffer@_W@__crt_stdio_input@@QAEXXZ"
		size = 26
		refs = "0001 ?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ 0012 _memset"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 10 68 00 20 00 00 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_23_205_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ"
		size = 28
	strings:
		$1 = { 33 C0 89 41 10 66 89 41 14 88 41 16 89 41 18 89 41 1C 89 41 20 88 41 24 89 41 28 C3 }
	condition:
		$1
}

rule file_23_206_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ"
		size = 29
	strings:
		$1 = { 33 D2 33 C0 89 51 10 89 41 14 88 51 18 89 51 20 89 51 24 89 51 28 88 51 2C 89 51 30 C3 }
	condition:
		$1
}

rule file_23_207_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@D@__crt_stdio_input@@AAEXH@Z"
		size = 42
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 89 41 10 66 89 41 14 88 41 16 89 41 18 89 41 1C 89 41 20 88 41 24 89 41 28 8B 45 08 89 41 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_23_208_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAEXH@Z"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 33 D2 33 C0 89 41 14 8B 45 08 89 51 10 88 51 18 89 51 20 89 51 24 89 51 28 88 51 2C 89 51 30 89 41 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_23_209_0 {
	meta:
		name = "?restore_state@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z"
		size = 37
		altNames = "?restore_state@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAE_N_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3B 41 10 75 0C 8B 45 0C 3B 41 14 75 04 B0 01 EB 08 8B 41 18 C6 00 00 32 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_23_211_0 {
	meta:
		name = "?right_shift_with_rounding@__crt_strtox@@YA_K_N_KI0@Z"
		size = 228
		refs = "0020 __allshl 008b _fegetround 00cd __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 33 C0 33 D2 53 8B 5D 14 83 FB 40 0F 83 C6 00 00 00 56 57 8D 4B FF 40 E8 ?? ?? ?? ?? 8B F8 89 55 F8 8B F7 8B CB 83 C6 FF 83 D2 FF 33 C0 89 55 F4 40 33 D2 E8 ?? ?? ?? ?? 23 45 0C 23 55 10 0B C2 C6 45 FD 01 6A 00 5B 75 03 88 5D FD 8B 45 F8 B1 01 23 7D 0C 23 45 10 0B F8 75 02 8A CB 80 7D 18 00 88 4D FF 74 0F 8B 45 F4 23 45 10 23 75 0C 0B F0 8A C3 74 02 B0 01 88 45 FE 84 C9 75 04 84 C0 74 39 E8 ?? ?? ?? ?? 85 C0 74 1C 3D 00 01 00 00 74 10 3D 00 02 00 00 75 22 80 7D 08 00 0F 94 C3 EB 19 8A 5D 08 EB 14 80 7D FF 00 74 0E 80 7D FE 00 75 06 80 7D FD 00 74 02 B3 01 8B 45 0C 8B 55 10 8B 4D 14 E8 ?? ?? ?? ?? 8B C8 8B F2 0F B6 C3 99 03 C1 5F 13 D6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_214_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ"
		size = 363
		refs = "0091 ?set_wide_for_c_s_or_scanset@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ 00b3 ?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ"
	strings:
		$1 = { 8B FF 53 56 8B F1 8B 4E 08 0F B6 01 83 F8 64 0F 8F B4 00 00 00 0F 84 9C 00 00 00 83 F8 53 7F 38 0F 84 2F 01 00 00 83 F8 41 0F 84 CB 00 00 00 83 F8 43 74 45 83 F8 44 0F 8E E6 00 00 00 83 F8 47 0F 8E B4 00 00 00 83 F8 49 0F 85 D4 00 00 00 C7 46 28 02 00 00 00 EB 66 83 E8 58 0F 84 A9 00 00 00 83 E8 03 74 37 83 E8 06 0F 84 8B 00 00 00 48 83 E8 01 0F 85 AA 00 00 00 8B 46 18 0B 46 1C 6A 00 5B 75 0A C7 46 18 01 00 00 00 89 5E 1C 8B CE E8 ?? ?? ?? ?? 89 5E 28 E9 C6 00 00 00 8B CE E8 ?? ?? ?? ?? FF 46 08 8B CE C7 46 28 08 00 00 00 5E 5B E9 ?? ?? ?? ?? C7 46 28 03 00 00 00 8D 41 01 89 46 08 E9 9D 00 00 00 83 F8 70 7F 45 74 33 83 F8 67 7E 25 83 F8 69 0F 84 71 FF FF FF 83 F8 6E 74 0E 83 F8 6F 75 3B C7 46 28 04 00 00 00 EB CD C7 46 28 09 00 00 00 EB C4 C7 46 28 07 00 00 00 EB BB C7 46 20 09 00 00 00 C7 46 28 06 00 00 00 EB AB 83 E8 73 74 3D 48 83 E8 01 74 2B 83 E8 03 74 E7 33 DB C7 46 0C 16 00 00 00 89 5E 10 32 C0 66 89 5E 14 88 5E 16 89 5E 18 89 5E 1C 89 5E 20 88 5E 24 89 5E 28 EB 1F C7 46 28 05 00 00 00 E9 69 FF FF FF 8B CE E8 ?? ?? ?? ?? C7 46 28 01 00 00 00 FF 46 08 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_23_215_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ"
		size = 332
		refs = "008d ?set_wide_for_c_s_or_scanset@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ 00b0 ?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ 0125 ?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAEXH@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 4E 08 0F B7 01 83 F8 64 0F 8F B2 00 00 00 0F 84 9A 00 00 00 83 F8 53 7F 38 0F 84 11 01 00 00 83 F8 41 0F 84 C9 00 00 00 83 F8 43 74 45 83 F8 44 0F 8E E4 00 00 00 83 F8 47 0F 8E B2 00 00 00 83 F8 49 0F 85 D2 00 00 00 C7 46 30 02 00 00 00 EB 64 83 E8 58 0F 84 A7 00 00 00 83 E8 03 74 35 83 E8 06 0F 84 89 00 00 00 48 83 E8 01 0F 85 A8 00 00 00 8B 46 20 0B 46 24 75 0A 21 46 24 C7 46 20 01 00 00 00 8B CE E8 ?? ?? ?? ?? 83 66 30 00 E9 AA 00 00 00 8B CE E8 ?? ?? ?? ?? 83 46 08 02 8B CE C7 46 30 08 00 00 00 5E E9 ?? ?? ?? ?? C7 46 30 03 00 00 00 8D 41 02 89 46 08 E9 82 00 00 00 83 F8 70 7F 45 74 33 83 F8 67 7E 25 83 F8 69 0F 84 73 FF FF FF 83 F8 6E 74 0E 83 F8 6F 75 3B C7 46 30 04 00 00 00 EB CD C7 46 30 09 00 00 00 EB C4 C7 46 30 07 00 00 00 EB BB C7 46 28 09 00 00 00 C7 46 30 06 00 00 00 EB AB 83 E8 73 74 21 48 83 E8 01 74 12 83 E8 03 74 E7 6A 16 8B CE E8 ?? ?? ?? ?? 32 C0 5E C3 C7 46 30 05 00 00 00 EB 85 8B CE E8 ?? ?? ?? ?? C7 46 30 01 00 00 00 83 46 08 02 B0 01 5E C3 }
	condition:
		$1
}

rule file_23_216_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ"
		size = 17
	strings:
		$1 = { 8B 41 08 80 38 2A 75 08 40 C6 41 16 01 89 41 08 C3 }
	condition:
		$1
}

rule file_23_217_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ"
		size = 20
	strings:
		$1 = { 8B 41 08 66 83 38 2A 75 0A 83 C0 02 C6 41 18 01 89 41 08 C3 }
	condition:
		$1
}

rule file_23_218_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ"
		size = 159
		refs = "0055 _strtoull"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B F1 8B 56 08 8A 0A 8D 41 D0 3C 09 77 08 0F BE C1 83 C0 D0 EB 21 8D 41 9F 3C 19 77 08 0F BE C1 83 C0 A9 EB 12 8D 41 BF 3C 19 77 08 0F BE C1 83 C0 C9 EB 03 83 C8 FF 83 F8 09 76 04 B0 01 EB 53 53 6A 0A 8D 45 FC 33 DB 50 52 89 5D FC E8 ?? ?? ?? ?? 8B C8 83 C4 0C 0B CA 74 15 8B 4D FC 3B 4E 08 74 0D 89 46 18 B0 01 89 56 1C 89 4E 08 EB 22 89 5E 10 32 C0 66 89 5E 14 88 5E 16 89 5E 18 89 5E 1C 89 5E 20 88 5E 24 89 5E 28 C7 46 0C 16 00 00 00 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_219_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ"
		size = 556
		refs = "01fb _wcstoull 0220 ?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAEXH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B F1 57 6A 30 5F 8B 4E 08 0F B7 11 66 3B D7 0F 82 9D 01 00 00 83 FA 3A 73 09 8B C2 2B C7 E9 8A 01 00 00 BF 10 FF 00 00 66 3B D7 0F 83 6B 01 00 00 BF 60 06 00 00 66 3B D7 0F 82 73 01 00 00 8D 47 0A 66 3B D0 72 D3 BF F0 06 00 00 66 3B D7 0F 82 5D 01 00 00 8D 47 0A 66 3B D0 72 BD BF 66 09 00 00 66 3B D7 0F 82 47 01 00 00 8D 47 0A 66 3B D0 72 A7 8D 78 76 66 3B D7 0F 82 33 01 00 00 8D 47 0A 66 3B D0 72 93 8D 78 76 66 3B D7 0F 82 1F 01 00 00 8D 47 0A 66 3B D0 0F 82 7B FF FF FF 8D 78 76 66 3B D7 0F 82 07 01 00 00 8D 47 0A 66 3B D0 0F 82 63 FF FF FF 8D 78 76 66 3B D7 0F 82 EF 00 00 00 8D 47 0A 66 3B D0 0F 82 4B FF FF FF BF 66 0C 00 00 66 3B D7 0F 82 D5 00 00 00 8D 47 0A 66 3B D0 0F 82 31 FF FF FF 8D 78 76 66 3B D7 0F 82 BD 00 00 00 8D 47 0A 66 3B D0 0F 82 19 FF FF FF 8D 78 76 66 3B D7 0F 82 A5 00 00 00 8D 47 0A 66 3B D0 0F 82 01 FF FF FF BF 50 0E 00 00 66 3B D7 0F 82 8B 00 00 00 8D 47 0A 66 3B D0 0F 82 E7 FE FF FF 8D 78 76 66 3B D7 72 77 8D 47 0A 66 3B D0 0F 82 D3 FE FF FF 83 C7 50 66 3B D7 72 63 83 C0 50 66 3B D0 0F 82 BF FE FF FF BF 40 10 00 00 66 3B D7 72 4D 8D 47 0A 66 3B D0 0F 82 A9 FE FF FF BF E0 17 00 00 66 3B D7 72 37 8D 47 0A 66 3B D0 0F 82 93 FE FF FF 83 C7 30 66 3B D7 72 23 83 C0 30 66 3B D0 73 1B E9 7E FE FF FF B8 1A FF 00 00 66 3B D0 0F 82 70 FE FF FF 83 C8 FF 83 F8 FF 75 2D 6A 41 58 6A 19 5F 66 3B C2 77 05 83 FA 5A 76 08 8D 42 9F 66 3B C7 77 12 8D 42 9F 66 3B C7 8D 42 E0 76 02 8B C2 83 C0 C9 EB 03 83 C8 FF 83 F8 09 76 04 B0 01 EB 37 83 65 FC 00 8D 45 FC 6A 0A 50 51 E8 ?? ?? ?? ?? 8B C8 83 C4 0C 0B CA 74 13 8B 4D FC 3B 4E 08 74 0B 89 46 20 89 56 24 89 4E 08 EB D0 6A 16 8B CE E8 ?? ?? ?? ?? 32 C0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_220_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ"
		size = 288
	strings:
		$1 = { 8B 41 08 56 0F B6 10 83 FA 6A 0F 8F C4 00 00 00 0F 84 B1 00 00 00 83 FA 49 74 50 83 FA 4C 74 3E 83 FA 54 74 2C 83 FA 68 0F 85 F0 00 00 00 8D 50 01 80 3A 68 75 0F 83 C0 02 C7 41 20 01 00 00 00 89 41 08 5E C3 C7 41 20 02 00 00 00 E9 CA 00 00 00 40 C7 41 20 0B 00 00 00 89 41 08 5E C3 40 C7 41 20 08 00 00 00 89 41 08 5E C3 8D 70 01 8A 16 80 FA 33 75 15 80 78 02 32 75 0F 83 C0 03 89 41 08 C7 41 20 09 00 00 00 5E C3 80 FA 36 75 15 80 78 02 34 75 0F 83 C0 03 C7 41 20 0A 00 00 00 89 41 08 5E C3 80 FA 64 74 19 80 FA 69 74 14 80 FA 6F 74 0F 80 FA 75 74 0A 80 FA 78 74 05 80 FA 58 75 5C 89 71 08 EB BA 40 C7 41 20 05 00 00 00 89 41 08 5E C3 83 FA 6C 74 24 83 FA 74 74 12 83 FA 7A 75 3B 40 C7 41 20 06 00 00 00 89 41 08 5E C3 40 C7 41 20 07 00 00 00 89 41 08 5E C3 8D 50 01 80 3A 6C 75 0F 83 C0 02 C7 41 20 04 00 00 00 89 41 08 5E C3 C7 41 20 03 00 00 00 89 51 08 5E C3 }
	condition:
		$1
}

rule file_23_221_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ"
		size = 305
	strings:
		$1 = { 8B 41 08 56 0F B7 10 83 FA 6A 0F 8F CF 00 00 00 0F 84 BA 00 00 00 83 FA 49 74 56 83 FA 4C 74 42 83 FA 54 74 2E 6A 68 5E 3B D6 0F 85 FF 00 00 00 8D 50 02 66 39 32 75 0F 83 C0 04 C7 41 28 01 00 00 00 89 41 08 5E C3 C7 41 28 02 00 00 00 E9 D9 00 00 00 83 C0 02 C7 41 28 0B 00 00 00 89 41 08 5E C3 83 C0 02 C7 41 28 08 00 00 00 89 41 08 5E C3 8D 70 02 0F B7 16 83 FA 33 75 16 66 83 78 04 32 75 0F 83 C0 06 89 41 08 C7 41 28 09 00 00 00 5E C3 83 FA 36 75 16 66 83 78 04 34 75 0F 83 C0 06 C7 41 28 0A 00 00 00 89 41 08 5E C3 83 FA 64 74 19 83 FA 69 74 14 83 FA 6F 74 0F 83 FA 75 74 0A 83 FA 78 74 05 83 FA 58 75 64 89 71 08 EB B9 83 C0 02 C7 41 28 05 00 00 00 89 41 08 5E C3 6A 6C 5E 3B D6 74 28 83 FA 74 74 14 83 FA 7A 75 3F 83 C0 02 C7 41 28 06 00 00 00 89 41 08 5E C3 83 C0 02 C7 41 28 07 00 00 00 89 41 08 5E C3 8D 50 02 66 39 32 75 0F 83 C0 04 C7 41 28 04 00 00 00 89 41 08 5E C3 C7 41 28 03 00 00 00 89 51 08 5E C3 }
	condition:
		$1
}

rule file_23_222_0 {
	meta:
		name = "?scan_optional_literal_character_trail_bytes_tchar@?$format_string_parser@D@__crt_stdio_input@@AAE_ND@Z"
		size = 85
		refs = "0006 ___pctype_func"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 0F B6 56 14 B9 00 80 00 00 66 85 0C 50 74 36 8B 46 08 8A 08 84 C9 75 26 33 C0 C7 46 0C 2A 00 00 00 89 46 10 66 89 46 14 88 46 16 89 46 18 89 46 1C 89 46 20 88 46 24 89 46 28 32 C0 EB 09 40 88 4E 15 89 46 08 B0 01 5E C2 04 00 }
	condition:
		$1
}

rule file_23_224_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ"
		size = 30
	strings:
		$1 = { 8B 51 08 8A 02 3C 77 75 08 8D 42 01 89 41 08 EB 08 3C 43 74 04 3C 53 75 04 C6 41 24 01 C3 }
	condition:
		$1
}

rule file_23_225_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ"
		size = 42
		refs = "001c ?should_default_to_wide@?$format_string_parser@_W@__crt_stdio_input@@AAE_N_W@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 08 0F B7 08 83 F9 77 75 08 83 C0 02 89 46 08 EB 0C 51 8B CE E8 ?? ?? ?? ?? 84 C0 74 04 C6 46 2C 01 5E C3 }
	condition:
		$1
}

rule file_23_226_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AAE_NXZ"
		size = 267
		refs = "00b0 ?set@?$scanset_buffer@E@__crt_stdio_input@@QAEXE@Z 00fd ?invert@?$scanset_buffer@E@__crt_stdio_input@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 33 C0 89 75 F0 8D 56 2C 89 55 F4 85 D2 75 27 C7 46 0C 0C 00 00 00 89 46 28 88 46 24 89 46 20 89 46 1C 89 46 18 88 46 16 66 89 46 14 89 46 10 32 C0 E9 C5 00 00 00 57 6A 08 59 8B FA F3 AB 8B 46 08 80 38 5E 0F 94 C1 88 4D FF 84 C9 74 04 40 89 46 08 8B 46 08 80 38 5D 75 08 40 89 46 08 80 4E 37 20 8B 7E 08 80 3F 5D 74 6A 53 8B 46 08 8A 08 84 C9 74 5C 80 F9 2D 75 3E 3B C7 74 3A 80 78 01 5D 74 34 8A 58 FF 8A 78 01 3A DF 76 06 8A C3 8A DF 8A F8 FE C7 88 5D FB 3A DF 74 29 8B 75 F4 FF 75 FB 8B CE E8 ?? ?? ?? ?? FE C3 88 5D FB 3A DF 75 ED 8B 75 F0 EB 0B 0F B6 00 8B CA 50 E8 ?? ?? ?? ?? 8D 56 2C FF 46 08 8B 46 08 80 38 5D 75 9B 8A 4D FF 5B 8B 46 08 5F 80 38 00 75 0E 33 C0 C7 46 0C 16 00 00 00 E9 2B FF FF FF 84 C9 74 07 8B CA E8 ?? ?? ?? ?? FF 46 08 B0 01 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_227_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AAE_NXZ"
		size = 274
		refs = "0015 ?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ 0022 ?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAEXH@Z 0031 ?reset@?$scanset_buffer@_W@__crt_stdio_input@@QAEXXZ 0061 ?set@?$scanset_buffer@_W@__crt_stdio_input@@QAEX_W@Z 0101 ?invert@?$scanset_buffer@_W@__crt_stdio_input@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 57 89 75 F0 8D 7E 34 8B CF E8 ?? ?? ?? ?? 85 C0 75 10 6A 0C 8B CE E8 ?? ?? ?? ?? 32 C0 E9 DF 00 00 00 53 8B CF E8 ?? ?? ?? ?? 8B 46 08 66 83 38 5E 0F 94 C3 88 5D FF 84 DB 74 06 83 C0 02 89 46 08 8B 46 08 6A 5D 59 66 39 08 75 11 83 C0 02 51 8B CF 89 46 08 E8 ?? ?? ?? ?? 6A 5D 59 8B 56 08 89 55 F8 66 39 0A 74 71 8B 46 08 0F B7 08 66 85 C9 74 63 83 F9 2D 75 41 3B C2 74 3D 6A 5D 59 66 39 48 02 74 34 0F B7 48 FE 0F B7 58 02 66 3B CB 76 06 8B C1 8B CB 8B D8 43 0F B7 C1 89 45 F4 66 3B CB 74 23 8B F0 56 8B CF E8 ?? ?? ?? ?? 46 66 3B F3 75 F2 8B 75 F0 EB 0B 0F B7 00 8B CF 50 E8 ?? ?? ?? ?? 8B 55 F8 83 46 08 02 8B 46 08 6A 5D 59 66 39 08 75 92 8A 5D FF 8B 46 08 66 83 38 00 75 0D 6A 16 8B CE E8 ?? ?? ?? ?? 32 C0 EB 11 84 DB 74 07 8B CF E8 ?? ?? ?? ?? 83 46 08 02 B0 01 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_230_0 {
	meta:
		name = "?secure_buffers@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ"
		size = 17
		altNames = "?secure_buffers@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ ?secure_buffers@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ ?secure_buffers@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ ?secure_buffers@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ ?secure_buffers@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABE_NXZ"
	strings:
		$1 = { 8B 01 33 C9 41 23 C1 83 C8 00 75 02 33 C9 8A C1 C3 }
	condition:
		$1
}

rule file_23_232_0 {
	meta:
		name = "?set@?$scanset_buffer@E@__crt_stdio_input@@QAEXE@Z"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 56 0F B6 75 08 8B D6 C1 EA 03 0F B6 04 0A 81 E6 07 00 00 80 79 05 4E 83 CE F8 46 0F AB F0 88 04 0A 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_233_0 {
	meta:
		name = "?set@?$scanset_buffer@_W@__crt_stdio_input@@QAEX_W@Z"
		size = 48
		refs = "000b ?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 0F B7 75 08 E8 ?? ?? ?? ?? 8B CE C1 E9 03 03 C8 0F B6 01 81 E6 07 00 00 80 79 05 4E 83 CE F8 46 0F AB F0 88 01 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_234_0 {
	meta:
		name = "?set_wide_for_c_s_or_scanset@?$format_string_parser@D@__crt_stdio_input@@AAEXXZ"
		size = 32
	strings:
		$1 = { 8B 41 20 83 F8 02 75 04 C6 41 24 00 83 F8 03 74 0A 83 F8 04 74 05 83 F8 08 75 04 C6 41 24 01 C3 }
	condition:
		$1
}

rule file_23_235_0 {
	meta:
		name = "?set_wide_for_c_s_or_scanset@?$format_string_parser@_W@__crt_stdio_input@@AAEXXZ"
		size = 32
	strings:
		$1 = { 8B 41 28 83 F8 02 75 04 C6 41 2C 00 83 F8 03 74 0A 83 F8 04 74 05 83 F8 08 75 04 C6 41 2C 01 C3 }
	condition:
		$1
}

rule file_23_236_0 {
	meta:
		name = "?shift_left@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 347
		refs = "0031 __allshl 014b _memcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC EC 01 00 00 53 8B 5D 0C 33 D2 56 8B C3 BE 20 00 00 00 C1 E8 05 83 E3 1F 8B CE 89 45 F0 2B CB 89 5D 0C 57 8D 46 E1 89 4D E8 E8 ?? ?? ?? ?? 8B 7D 08 48 89 45 E4 F7 D0 89 45 EC C7 45 F8 00 00 00 00 8B 17 8B 0C 97 0F BD C1 74 03 40 EB 02 33 C0 2B F0 8B 45 F0 3B DE 0F 97 C1 03 D0 83 FA 73 88 4D FF 89 55 F8 0F 97 C3 83 FA 73 75 08 84 C9 74 04 B1 01 EB 02 32 C9 84 DB 0F 85 A2 00 00 00 84 C9 0F 85 9A 00 00 00 83 FA 72 72 08 BA 72 00 00 00 89 55 F8 8B DA 83 FA FF 74 64 8B F2 8D 4F 04 2B F0 8D 0C 91 89 4D F4 8D 3C B7 83 C7 04 3B D8 72 47 8B 45 08 8B 08 3B F1 73 04 8B 17 EB 02 33 D2 8D 46 FF 3B C1 73 05 8B 47 FC EB 02 33 C0 23 45 EC 4B 8B 4D E8 4E 23 55 E4 83 EF 04 D3 E8 8B 4D 0C D3 E2 8B 4D F4 0B C2 89 01 83 E9 04 8B 45 F0 89 4D F4 83 FB FF 75 B5 8B 55 F8 8B 7D 08 85 C0 74 09 83 C7 04 8B C8 33 C0 F3 AB 80 7D FF 00 74 01 42 8B 45 08 5F 5E 5B 89 10 B0 01 8B E5 5D C3 6A 00 8D 85 18 FE FF FF C7 85 14 FE FF FF 00 00 00 00 50 8D 47 04 C7 07 00 00 00 00 68 CC 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 32 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_237_0 {
	meta:
		name = "?should_default_to_wide@?$format_string_parser@D@__crt_stdio_input@@AAE_NE@Z"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 8A 45 08 3C 43 74 08 3C 53 74 04 33 C0 EB 03 33 C0 40 5D C2 04 00 }
	condition:
		$1
}

rule file_23_238_0 {
	meta:
		name = "?should_default_to_wide@?$format_string_parser@_W@__crt_stdio_input@@AAE_N_W@Z"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 66 83 7D 08 43 74 21 66 83 7D 08 53 74 1A 83 79 28 0B 75 04 B0 01 EB 12 8B 01 33 C9 83 E0 02 0B C1 74 01 41 8A C1 EB 02 32 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_23_239_0 {
	meta:
		name = "?should_round_up@__crt_strtox@@YA_N_N000@Z"
		size = 85
		refs = "0019 _fegetround"
	strings:
		$1 = { 8B FF 55 8B EC 53 8A 7D 10 8A 5D 14 84 FF 75 08 84 DB 75 04 32 C0 EB 3A E8 ?? ?? ?? ?? 85 C0 74 1D 3D 00 01 00 00 74 11 3D 00 02 00 00 75 E5 33 C0 38 45 08 0F 94 C0 EB 19 8A 45 08 EB 14 84 FF 74 0E 84 DB 75 05 38 5D 0C 74 05 33 C0 40 EB 02 33 C0 5B 5D C3 }
	condition:
		$1
}

rule file_23_244_0 {
	meta:
		name = "?test@?$scanset_buffer@E@__crt_stdio_input@@QBE_NE@Z"
		size = 49
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 55 08 56 8B F1 8B CA 81 E1 07 00 00 80 79 05 49 83 C9 F8 41 33 C0 C1 EA 03 40 D3 E0 6A 00 84 04 32 58 0F 95 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_245_0 {
	meta:
		name = "?test@?$scanset_buffer@_W@__crt_stdio_input@@QBE_N_W@Z"
		size = 56
		refs = "000c ?data@?$scanset_storage@$01@__crt_stdio_input@@QBEPAEXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 0F B7 7D 08 E8 ?? ?? ?? ?? 8B F7 C1 EE 03 81 E7 07 00 00 80 79 05 4F 83 CF F8 47 33 D2 8B CF 42 6A 00 D3 E2 84 14 30 58 5F 0F 95 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_246_0 {
	meta:
		name = "?to_floating_point_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 12 83 F8 03 74 09 83 F8 08 74 04 33 C0 5D C3 6A 08 EB 02 6A 04 58 5D C3 }
	condition:
		$1
}

rule file_23_247_0 {
	meta:
		name = "?to_integer_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
		size = 88
		refs = "0010 $LN18 002c $LN4 0030 $LN5 0034 $LN6 003c $LN8 004c $LN14"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 0A 77 19 FF 24 85 ?? ?? ?? ?? 6A 04 58 5D C3 33 C0 40 5D C3 6A 02 EB F4 6A 08 EB F0 33 C0 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_248_0 {
	meta:
		name = "?unget@?$console_input_adapter@D@__crt_stdio_input@@QAEXH@Z"
		size = 26
		refs = "0011 __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 FF 74 0B FF 75 08 FF 09 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_23_249_0 {
	meta:
		name = "?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
		size = 31
		refs = "0016 __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 66 39 45 08 74 0B FF 75 08 FF 09 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_23_250_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAEXD@Z"
		size = 73
		refs = "003f __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 10 FF 8B 51 0C 83 51 14 FF 56 8B 71 08 8B C6 0B C2 74 0C 39 51 14 77 25 72 05 39 71 10 77 1E 8A 45 08 84 C0 74 17 3C FF 74 13 0F BE D0 8B 01 83 FA FF 74 09 FF 08 52 E8 ?? ?? ?? ?? 59 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_251_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z"
		size = 69
		refs = "003c ?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 10 FF 8B 51 08 8B C2 83 51 14 FF 56 8B 71 0C 0B C6 74 0C 39 71 14 77 21 72 05 39 51 10 77 1A 8B 45 08 66 85 C0 74 12 BA FF FF 00 00 66 3B C2 74 08 8B 09 50 E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_729_372_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z"
		size = 69
		refs = "003c ?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 10 FF 8B 51 08 8B C2 83 51 14 FF 56 8B 71 0C 0B C6 74 0C 39 71 14 77 21 72 05 39 51 10 77 1A 8B 45 08 66 85 C0 74 12 BA FF FF 00 00 66 3B C2 74 08 8B 09 50 E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_729_374_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAEX_W@Z"
		size = 69
		refs = "003c ?unget@?$string_input_adapter@_W@__crt_stdio_input@@QAEXG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 10 FF 8B 51 08 8B C2 83 51 14 FF 56 8B 71 0C 0B C6 74 0C 39 71 14 77 21 72 05 39 51 10 77 1A 8B 45 08 66 85 C0 74 12 BA FF FF 00 00 66 3B C2 74 08 8B 09 50 E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_254_0 {
	meta:
		name = "?validate@?$format_string_parser@D@__crt_stdio_input@@QBE_NXZ"
		size = 28
		refs = "0007 __errno 0012 __invalid_parameter_noinfo"
		altNames = "?validate@?$format_string_parser@_W@__crt_stdio_input@@QBE_NXZ"
	strings:
		$1 = { 83 79 08 00 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_23_256_0 {
	meta:
		name = "?validate@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ"
		size = 33
		refs = "0006 __errno 0011 __invalid_parameter_noinfo"
		altNames = "?validate@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ ?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBE_NXZ"
	strings:
		$1 = { 83 39 00 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 C3 83 79 18 00 74 E7 B0 01 C3 }
	condition:
		$1
}

rule file_23_258_0 {
	meta:
		name = "?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
		size = 417
	strings:
		$1 = { 8B FF 55 8B EC 66 8B 45 08 6A 30 59 66 3B C1 0F 82 87 01 00 00 66 83 F8 3A 73 07 0F B7 C0 2B C1 5D C3 BA 10 FF 00 00 66 3B C2 0F 83 5E 01 00 00 BA 60 06 00 00 66 3B C2 0F 82 5E 01 00 00 8D 4A 0A 66 3B C1 73 07 0F B7 C0 2B C2 5D C3 BA F0 06 00 00 66 3B C2 0F 82 41 01 00 00 8D 4A 0A 66 3B C1 72 E3 BA 66 09 00 00 66 3B C2 0F 82 2B 01 00 00 8D 4A 0A 66 3B C1 72 CD 8D 51 76 66 3B C2 0F 82 17 01 00 00 8D 4A 0A 66 3B C1 72 B9 8D 51 76 66 3B C2 0F 82 03 01 00 00 8D 4A 0A 66 3B C1 72 A5 8D 51 76 66 3B C2 0F 82 EF 00 00 00 8D 4A 0A 66 3B C1 72 91 8D 51 76 66 3B C2 0F 82 DB 00 00 00 8D 4A 0A 66 3B C1 0F 82 79 FF FF FF BA 66 0C 00 00 66 3B C2 0F 82 C1 00 00 00 8D 4A 0A 66 3B C1 0F 82 5F FF FF FF 8D 51 76 66 3B C2 0F 82 A9 00 00 00 8D 4A 0A 66 3B C1 0F 82 47 FF FF FF 8D 51 76 66 3B C2 0F 82 91 00 00 00 8D 4A 0A 66 3B C1 0F 82 2F FF FF FF BA 50 0E 00 00 66 3B C2 72 7B 8D 4A 0A 66 3B C1 0F 82 19 FF FF FF 8D 51 76 66 3B C2 72 67 8D 4A 0A 66 3B C1 0F 82 05 FF FF FF 83 C2 50 66 3B C2 72 53 83 C1 50 66 3B C1 0F 82 F1 FE FF FF BA 40 10 00 00 66 3B C2 72 3D 8D 4A 0A 66 3B C1 0F 82 DB FE FF FF BA E0 17 00 00 66 3B C2 72 27 8D 4A 0A 66 3B C1 0F 82 C5 FE FF FF 83 C2 30 66 3B C2 72 13 83 C1 30 EB 05 B9 1A FF 00 00 66 3B C1 0F 82 AA FE FF FF 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_23_261_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAID@Z"
		size = 28
		altNames = "?write_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAID@Z ?write_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAID@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 10 8A 45 18 8B 0A 88 01 8B 45 14 FF 02 FF 08 B0 01 5D C2 14 00 }
	condition:
		$1
}

rule file_23_262_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQA_WIAAPA_WAAID@Z"
		size = 118
		refs = "0016 ___pctype_func 0029 __getche_nolock 0051 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8A 5D 18 56 8B F1 88 5D FC C6 45 FD 00 E8 ?? ?? ?? ?? 0F B6 D3 B9 00 80 00 00 66 85 0C 50 74 10 E8 ?? ?? ?? ?? 83 F8 FF 74 03 FF 46 08 88 45 FD 6A 3F 58 66 89 45 F8 8B 46 60 50 8B 00 FF 70 04 8D 45 FC 50 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 55 10 83 C4 10 66 0F BE CB 8B 02 5E 5B 66 89 08 8B 45 14 83 02 02 FF 08 B0 01 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_23_263_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAI_W@Z"
		size = 136
		refs = "0023 _wctomb_s 0083 __invoke_watson"
		altNames = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAI_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQADIAAPADAAI_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 33 DB 8D 45 FC 83 7D 0C FF 57 FF 75 18 89 5D FC 75 2C 8B 75 10 6A 05 FF 36 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0C 83 F8 16 74 4A 83 F8 22 75 3A EB 43 8B 45 14 8B 4D FC 01 0E 29 08 EB 2C 8B 75 14 8B 7D 10 FF 36 FF 37 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 75 09 8B 45 08 88 18 32 C0 EB 0D 8B 45 FC 85 C0 7E 04 01 07 29 06 B0 01 5F 5E 5B 8B E5 5D C2 14 00 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_23_264_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQA_WIAAPA_WAAI_W@Z"
		size = 31
		altNames = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQA_WIAAPA_WAAI_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_NQA_WIAAPA_WAAI_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 10 66 8B 45 18 8B 0A 66 89 01 8B 45 14 83 02 02 FF 08 B0 01 5D C2 14 00 }
	condition:
		$1
}

rule file_23_265_0 {
	meta:
		name = "?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
		size = 119
		refs = "0015 __errno 0020 __invalid_parameter_noinfo 0035 ?length@?$format_string_parser@D@__crt_stdio_input@@QBEIXZ"
		altNames = "?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 64 04 8B 41 64 56 8B 70 FC 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 4A 80 7D 10 00 74 03 FF 41 68 83 C1 10 E8 ?? ?? ?? ?? 83 E8 01 74 2D 83 E8 01 74 1F 48 83 E8 01 74 12 83 E8 04 75 D6 8B 45 08 89 06 8B 45 0C 89 46 04 EB 15 8B 45 08 89 06 EB 0E 66 8B 45 08 66 89 06 EB 05 8A 45 08 88 06 B0 01 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_23_266_0 {
	meta:
		name = "?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
		size = 119
		refs = "0015 __errno 0020 __invalid_parameter_noinfo 0035 ?length@?$format_string_parser@_W@__crt_stdio_input@@QBEIXZ"
		altNames = "?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAE_N_K_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 4C 04 8B 41 4C 56 8B 70 FC 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 4A 80 7D 10 00 74 03 FF 41 50 83 C1 10 E8 ?? ?? ?? ?? 83 E8 01 74 2D 83 E8 01 74 1F 48 83 E8 01 74 12 83 E8 04 75 D6 8B 45 08 89 06 8B 45 0C 89 46 04 EB 15 8B 45 08 89 06 EB 0E 66 8B 45 08 66 89 06 EB 05 8A 45 08 88 06 B0 01 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_23_271_0 {
	meta:
		name = "__chvalidchk_l"
		size = 42
		refs = "001a ___pctype_func"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 85 C0 74 0D 8B 00 8B 08 8B 45 08 0F B7 04 41 EB 0C E8 ?? ?? ?? ?? 8B 4D 08 0F B7 04 48 23 45 0C 5D C3 }
	condition:
		$1
}

rule file_23_272_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 45
		refs = "0028 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 0A 3B 45 0C 74 07 3B 45 10 74 02 5D C3 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_23_273_0 {
	meta:
		name = "__ischartype_l"
		size = 51
		refs = "001c __isctype_l 002a __chvalidchk_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 85 C9 74 16 8B 01 83 78 04 01 7E 0E 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? EB 0C 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_fputws"
		size = 152
		refs = "0003 __sehtable$_fputws 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0045 __lock_file 005c __fputwc_nolock 0085 __SEH_epilog4 0092 __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 55 33 C0 8B 5D 0C 85 DB 0F 95 C0 85 C0 74 DD 83 CF FF 89 7D E4 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 89 75 E0 0F B7 06 66 85 C0 74 18 53 50 E8 ?? ?? ?? ?? 59 59 B9 FF FF 00 00 66 3B C1 74 0A 83 C6 02 EB DD 33 FF 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 5D 0C 8B 7D E4 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_wcsncpy"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 57 8B 7D 08 85 C9 74 2D 8B 55 0C 2B D7 0F B7 04 3A 66 89 07 83 C7 02 66 85 C0 74 05 83 E9 01 75 EC 85 C9 74 10 83 E9 01 74 0B 33 C0 D1 E9 F3 AB 13 C9 66 F3 AB 8B 45 08 5F 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "_nearbyint"
		size = 38
		refs = "000a __dtest 001e __drint"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? DD 45 08 98 59 83 F8 02 76 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "_nearbyintl"
		size = 38
		refs = "000a __ldtest 001e __ldrint"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? DD 45 08 98 59 83 F8 02 76 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_roundl"
		size = 81
		refs = "000c __ld_int 003e __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 6A 01 50 E8 ?? ?? ?? ?? 98 59 59 85 C0 7E 05 83 F8 02 7E 30 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 74 1E DD 45 08 B8 00 80 00 00 66 85 45 0E 74 08 DC 25 ?? ?? ?? ?? 5D C3 DC 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "_round"
		size = 81
		refs = "000c __d_int 003e __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 6A 01 50 E8 ?? ?? ?? ?? 98 59 59 85 C0 7E 05 83 F8 02 7E 30 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 74 1E DD 45 08 B8 00 80 00 00 66 85 45 0E 74 08 DC 25 ?? ?? ?? ?? 5D C3 DC 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_29_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 26
		refs = "0011 __mbsnbcat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_412_13_4 {
	meta:
		name = "__aligned_realloc_base"
		size = 26
		refs = "0011 __aligned_offset_realloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_548_0_0 {
	meta:
		name = "__mbscat_s"
		size = 26
		refs = "0011 __mbscat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_239_0_4 {
	meta:
		name = "__mbscpy_s"
		size = 26
		refs = "0011 __mbscpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_394_4_2 {
	meta:
		name = "__mbsnbcmp"
		size = 26
		refs = "0011 __mbsnbcmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_115_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 26
		refs = "0011 __mbsnbcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_308_4_3 {
	meta:
		name = "__mbsnbcpy"
		size = 26
		refs = "0011 __mbsnbcpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_567_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 26
		refs = "0011 __mbsnbicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_368_4_2 {
	meta:
		name = "__mbsnbicoll"
		size = 26
		refs = "0011 __mbsnbicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_93_4_4 {
	meta:
		name = "__mbsnbset"
		size = 26
		refs = "0011 __mbsnbset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_570_4_3 {
	meta:
		name = "__mbsncat"
		size = 26
		refs = "0011 __mbsncat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_584_4_3 {
	meta:
		name = "__mbsncmp"
		size = 26
		refs = "0011 __mbsncmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_136_4_3 {
	meta:
		name = "__mbsncoll"
		size = 26
		refs = "0011 __mbsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_242_4_4 {
	meta:
		name = "__mbsncpy"
		size = 26
		refs = "0011 __mbsncpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_690_4_4 {
	meta:
		name = "__mbsnicmp"
		size = 26
		refs = "0011 __mbsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_194_4_4 {
	meta:
		name = "__mbsnicoll"
		size = 26
		refs = "0011 __mbsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_94_4_3 {
	meta:
		name = "__mbsnset"
		size = 26
		refs = "0011 __mbsnset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_56_0_3 {
	meta:
		name = "__mbsset_s"
		size = 26
		refs = "0011 __mbsset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_87_4_3 {
	meta:
		name = "__mbstok_s"
		size = 26
		refs = "0011 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_79_0 {
	meta:
		name = "__spawnv"
		size = 26
		refs = "0011 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_52_4 {
	meta:
		name = "__spawnvp"
		size = 26
		refs = "0011 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_83_0 {
	meta:
		name = "__wspawnv"
		size = 26
		refs = "0011 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_56_0 {
	meta:
		name = "__wspawnvp"
		size = 26
		refs = "0011 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_525_5_2 {
	meta:
		name = "_mbtowc"
		size = 26
		refs = "0011 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_127_5_2 {
	meta:
		name = "_strxfrm"
		size = 26
		refs = "0011 __strxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_399_8_3 {
	meta:
		name = "_wcstombs"
		size = 26
		refs = "0011 ?_wcstombs_l_helper@@YAIPADPB_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_376_5_3 {
	meta:
		name = "_wcsxfrm"
		size = 26
		refs = "0011 __wcsxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_29_5_0 {
	meta:
		name = "__mbsnbcat_l"
		size = 292
		refs = "0021 __errno 002c __invalid_parameter_noinfo 005d ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 006e _strncat 0099 __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 8B 5D 10 85 DB 75 08 8B 45 08 E9 07 01 00 00 56 8B 75 08 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 E7 00 00 00 57 8B 7D 0C 85 FF 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 C7 00 00 00 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F0 83 78 08 00 75 12 53 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E9 8F 00 00 00 8B D6 89 55 F8 8A 06 46 84 C0 75 F9 4E 3B F2 74 1C 8D 45 EC 50 8B C6 2B C2 48 50 52 E8 ?? ?? ?? ?? 8B 55 F8 83 C4 0C 83 F8 01 75 01 4E 0F B6 0F 4B 8B 45 F0 F6 44 01 19 04 8A 07 88 06 74 18 46 85 DB 74 1F 8A 47 01 4B 88 06 83 C7 02 46 84 C0 75 0B 88 46 FE EB 10 46 47 84 C0 74 0A 85 DB 75 CC EB 04 C6 46 FF 00 3B F2 74 1E 8D 45 EC 50 8B C6 2B C2 48 50 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 06 C6 46 FF 00 EB 03 C6 06 00 8B 4D F8 80 7D F4 00 74 0A 8B 45 E8 83 A0 50 03 00 00 FD 8B C1 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "??$__crt_time_is_leap_year@H@@YA_NH@Z"
		size = 65
		altNames = "??$__crt_time_is_leap_year@J@@YA_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B C1 25 03 00 00 80 79 05 48 83 C8 FC 40 75 12 56 6A 64 8B C1 5E 99 F7 FE 5E 85 D2 74 04 B0 01 5D C3 8D 81 6C 07 00 00 B9 90 01 00 00 99 F7 F9 F7 DA 1A D2 8D 42 01 5D C3 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "??$common_asctime@D@@YAPADQBUtm@@@Z"
		size = 86
		refs = "0008 ___acrt_getptd_noexit 0022 __calloc_base 002a __free_base 0038 ?static_buffer@?1???$common_asctime@D@@YAPADQBUtm@@@Z@4PADA 0043 ??$common_asctime_s@D@@YAHQADIQBUtm@@@Z"
		altNames = "_asctime"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 85 C0 74 27 8D 78 30 85 FF 74 20 8B 37 85 F6 75 1F 6A 01 6A 1A E8 ?? ?? ?? ?? 56 89 07 E8 ?? ?? ?? ?? 8B 37 83 C4 0C 85 F6 75 05 BE ?? ?? ?? ?? FF 75 08 6A 1A 56 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 5F 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "??$common_asctime@_W@@YAPA_WQBUtm@@@Z"
		size = 86
		refs = "0008 ___acrt_getptd_noexit 0022 __calloc_base 002a __free_base 0038 ?static_buffer@?1???$common_asctime@_W@@YAPA_WQBUtm@@@Z@4PA_WA 0043 ??$common_asctime_s@_W@@YAHQA_WIQBUtm@@@Z"
		altNames = "__wasctime"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 85 C0 74 27 8D 78 34 85 FF 74 20 8B 37 85 F6 75 1F 6A 02 6A 1A E8 ?? ?? ?? ?? 56 89 07 E8 ?? ?? ?? ?? 8B 37 83 C4 0C 85 F6 75 05 BE ?? ?? ?? ?? FF 75 08 6A 1A 56 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 5F 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "??$common_asctime_s@D@@YAHQADIQBUtm@@@Z"
		size = 422
		refs = "00aa ?__crt_time_is_day_valid@@YA_NHHH@Z 00c2 ___dnames 00f1 ___mnames 011e ??$common_asctime_s_write_value@D@@YAPADPADH_N@Z 018f __errno 0199 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 08 57 85 F6 0F 84 7A 01 00 00 83 7D 0C 00 0F 86 70 01 00 00 83 7D 0C 1A C6 06 00 0F 82 63 01 00 00 8B 7D 10 85 FF 0F 84 58 01 00 00 83 7F 14 00 0F 8C 4E 01 00 00 8B 47 10 85 C0 0F 88 43 01 00 00 83 F8 0B 0F 8F 3A 01 00 00 83 7F 08 00 0F 8C 30 01 00 00 83 7F 08 17 0F 8F 26 01 00 00 83 7F 04 00 0F 8C 1C 01 00 00 83 7F 04 3B 0F 8F 12 01 00 00 83 3F 00 0F 8C 09 01 00 00 83 3F 3C 0F 8F 00 01 00 00 8B 5F 18 85 DB 0F 88 F5 00 00 00 83 FB 06 0F 8F EC 00 00 00 FF 77 0C 50 FF 77 14 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 0F 84 D5 00 00 00 83 65 FC 00 6B D3 03 81 C2 ?? ?? ?? ?? 8D 42 03 8B C8 2B CA 3B C2 1B DB F7 D3 23 D9 74 0E 8B 4D FC 8A 04 11 88 06 46 41 3B CB 75 F5 C6 06 20 33 DB 6B 57 10 03 46 81 C2 ?? ?? ?? ?? 8D 4A 03 8B C1 2B C2 3B CA 1B C9 F7 D1 23 C8 74 0B 8A 02 88 06 46 42 43 3B D9 75 F5 6A 00 C6 06 20 8D 46 01 FF 77 0C 50 E8 ?? ?? ?? ?? 6A 01 C6 00 20 40 FF 77 08 50 E8 ?? ?? ?? ?? 6A 01 C6 00 3A 40 FF 77 04 50 E8 ?? ?? ?? ?? 6A 01 C6 00 3A 40 FF 37 50 E8 ?? ?? ?? ?? 8B C8 BE 6C 07 00 00 6A 64 5B 6A 01 C6 01 20 8B 47 14 03 C6 99 F7 FB 50 8D 41 01 50 E8 ?? ?? ?? ?? 8B C8 8B 47 14 03 C6 99 F7 FB 6A 01 52 51 E8 ?? ?? ?? ?? 83 C4 48 66 C7 00 0A 00 33 C0 EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_6_0 {
	meta:
		name = "??$common_asctime_s@_W@@YAHQA_WIQBUtm@@@Z"
		size = 449
		refs = "00aa ?__crt_time_is_day_valid@@YA_NHHH@Z 00c0 ___dnames 00f6 ___mnames 012b ??$common_asctime_s_write_value@_W@@YAPA_WPA_WH_N@Z 01ac __errno 01b6 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 57 85 F6 0F 84 98 01 00 00 83 7D 0C 00 0F 86 8E 01 00 00 33 C0 83 7D 0C 1A 66 89 06 0F 82 7F 01 00 00 8B 7D 10 85 FF 0F 84 74 01 00 00 39 47 14 0F 8C 6B 01 00 00 8B 47 10 85 C0 0F 88 60 01 00 00 83 F8 0B 0F 8F 57 01 00 00 83 7F 08 00 0F 8C 4D 01 00 00 83 7F 08 17 0F 8F 43 01 00 00 83 7F 04 00 0F 8C 39 01 00 00 83 7F 04 3B 0F 8F 2F 01 00 00 83 3F 00 0F 8C 26 01 00 00 83 3F 3C 0F 8F 1D 01 00 00 8B 5F 18 85 DB 0F 88 12 01 00 00 83 FB 06 0F 8F 09 01 00 00 FF 77 0C 50 FF 77 14 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 0F 84 F2 00 00 00 6B D3 03 33 DB 81 C2 ?? ?? ?? ?? 8D 4A 03 8B C1 2B C2 3B CA 1B C9 F7 D1 23 C8 74 10 66 0F BE 02 66 89 06 83 C6 02 42 43 3B D9 75 F0 6A 20 58 66 89 06 33 DB 6B 57 10 03 83 C6 02 81 C2 ?? ?? ?? ?? 8D 4A 03 8B C1 2B C2 3B CA 1B C9 F7 D1 23 C8 74 10 66 0F BE 02 66 89 06 83 C6 02 42 43 3B D9 75 F0 6A 20 5B 6A 00 66 89 1E 8D 46 02 FF 77 0C 50 E8 ?? ?? ?? ?? 6A 01 66 89 18 83 C0 02 FF 77 08 50 E8 ?? ?? ?? ?? 6A 3A 5E 6A 01 66 89 30 83 C0 02 FF 77 04 50 E8 ?? ?? ?? ?? 6A 01 66 89 30 83 C0 02 FF 37 50 E8 ?? ?? ?? ?? 8B C8 BE 6C 07 00 00 6A 64 66 89 19 8B 47 14 03 C6 5B 99 F7 FB 6A 01 50 8D 41 02 50 E8 ?? ?? ?? ?? 8B C8 8B 47 14 03 C6 99 F7 FB 6A 01 52 51 E8 ?? ?? ?? ?? 83 C4 48 6A 0A 59 66 89 08 33 C9 66 89 48 02 33 C0 EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_30_7_0 {
	meta:
		name = "??$common_asctime_s_write_value@D@@YAPADPADH_N@Z"
		size = 59
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 0A 5E 39 75 0C 7D 0E 80 7D 10 00 75 08 8B 4D 08 C6 01 20 EB 0D 8B 45 0C 99 F7 FE 8B 4D 08 04 30 88 01 8B 45 0C 41 99 F7 FE 8D 41 01 80 C2 30 88 11 5E 5D C3 }
	condition:
		$1
}

rule file_30_8_0 {
	meta:
		name = "??$common_asctime_s_write_value@_W@@YAPA_WPA_WH_N@Z"
		size = 61
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 0A 5E 39 75 0C 7D 0B 80 7D 10 00 75 05 6A 20 58 EB 09 8B 45 0C 99 F7 FE 83 C0 30 8B 4D 08 66 89 01 83 C1 02 8B 45 0C 99 F7 FE 8D 41 02 83 C2 30 66 89 11 5E 5D C3 }
	condition:
		$1
}

rule file_30_13_0 {
	meta:
		name = "?__crt_get_2digit_year@@YAHH@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 05 6C 07 00 00 6A 64 99 59 F7 F9 8B C2 5D C3 }
	condition:
		$1
}

rule file_30_14_0 {
	meta:
		name = "?__crt_get_century@@YAHH@Z"
		size = 21
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 05 6C 07 00 00 6A 64 99 59 F7 F9 5D C3 }
	condition:
		$1
}

rule file_30_15_0 {
	meta:
		name = "?__crt_time_is_day_valid@@YA_NHHH@Z"
		size = 71
		refs = "0016 __days 002a ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 7F 04 32 C0 5D C3 57 8B 7D 0C 8B 04 BD ?? ?? ?? ?? 2B 04 BD ?? ?? ?? ?? 39 45 10 7E 18 FF 75 08 E8 ?? ?? ?? ?? 59 84 C0 74 0F 83 FF 01 75 0A 83 7D 10 1D 7F 04 B0 01 EB 02 32 C0 5F 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 29
		refs = "0014 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_412_15_0 {
	meta:
		name = "__aligned_recalloc_base"
		size = 29
		refs = "0014 __aligned_offset_recalloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 29
		refs = "0014 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_695_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 29
		refs = "0014 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_511_0_4 {
	meta:
		name = "__mbsnbcpy_s"
		size = 29
		refs = "0014 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_227_0_4 {
	meta:
		name = "__mbsncat_s"
		size = 29
		refs = "0014 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_727_0_2 {
	meta:
		name = "__mbsncpy_s"
		size = 29
		refs = "0014 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_546_0_2 {
	meta:
		name = "__mbsnset_s"
		size = 29
		refs = "0014 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_734_25_4 {
	meta:
		name = "__ultoa_s"
		size = 29
		refs = "0014 ??$common_xtox_s@KD@@YAHKQADII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_734_27_3 {
	meta:
		name = "__ultow_s"
		size = 29
		refs = "0014 ??$common_xtox_s@K_W@@YAHKQA_WII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_91_7_2 {
	meta:
		name = "_wctomb_s"
		size = 29
		refs = "0014 __wctomb_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_fesetexceptflag"
		size = 78
		refs = "0012 __getfpstatusword 001c ___acrt_fenv_get_fp_status_word_from_exception_mask 0031 __setfpstatusword 003a _fetestexcept"
	strings:
		$1 = { 8B FF 55 8B EC F6 45 0C 1F 75 04 33 C0 5D C3 56 57 E8 ?? ?? ?? ?? FF 75 0C 8B F0 E8 ?? ?? ?? ?? 8B 4D 08 8B F8 F7 D7 23 FE 8B 09 23 C8 0B F9 57 E8 ?? ?? ?? ?? 83 E7 1F 57 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 3B C7 0F 95 C1 5F 8B C1 5E 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 333
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 ___acrt_cosf_sinf_ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 0138 _cos"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 10 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 19 F3 0F 5A C0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 5C C8 F2 0F 5A C1 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 1D 83 EC 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 83 C4 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_412_3_2 {
	meta:
		name = "__aligned_malloc_base"
		size = 23
		refs = "000e __aligned_offset_malloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_115_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e ??$common_atodbl_l@ND@@YAHQANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_118_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e ??$common_atodbl_l@MD@@YAHQAMQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_349_56_3 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_237_13_2 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e ??$common_gets@_W@@YAPA_WQA_WI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_4_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_599_4_4 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_259_4_0 {
	meta:
		name = "__mbbtype"
		size = 23
		refs = "000e __mbbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_132_4_3 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_108_4_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_563_4_2 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_423_4_4 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_343_4_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_477_4_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_708_4_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_43_6_4 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_586_4_3 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_560_4_3 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_518_0_3 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_142_4_3 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_95_4_2 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_328_4_2 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_728_4_3 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_482_4_3 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_356_4_2 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_181_4_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_713_7_2 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_36_6_2 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_151_15_3 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_503_15_2 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_215_15_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_669_14_4 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_237_15_3 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e ??$common_gets@D@@YAPADQADI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_629_5_4 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_125_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_126_2 {
	meta:
		name = "_strtof"
		size = 23
		refs = "000e ??$common_strtod_l@MD@@YAMQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_127_3 {
	meta:
		name = "_strtold"
		size = 23
		refs = "000e ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_128_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_129_0 {
	meta:
		name = "_wcstof"
		size = 23
		refs = "000e ??$common_strtod_l@M_W@@YAMQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_130_0 {
	meta:
		name = "_wcstold"
		size = 23
		refs = "000e ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "__mbsbtype_l"
		size = 151
		refs = "0011 __errno 001c __invalid_parameter_noinfo 002e ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0059 __mbbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 57 8B 7D 08 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6D 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 33 F6 39 70 08 74 40 8B 5D 0C 83 CE FF 8B D6 85 DB 75 04 38 1F 74 30 8A 07 84 C0 74 1A 8D 4D F4 51 52 50 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 47 8B C3 4B 85 C0 75 DA EB 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B D6 80 7D FC 00 5E 5B 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__dpow"
		size = 1780
		refs = "000c ___security_cookie 0036 __dunscale 0047 __d_int 0085 __real@3fe0000000000000 009e __real@bfe0000000000000 00e8 __fperrraise 00ee __Nan_C 0140 __real@4000000000000000 014b __real@3fe6a09e667f3bcd 0170 __real@4050000000000000 0177 __ftol2_sse 0198 __real@3f90000000000000 01b0 _lnbias 01dd __dlogpoly 0237 __real@3fe62e42fefa39ef 0256 __real@c0e0000000000000 0276 __real@c02e000000000000 0287 __real@402e000000000000 029c __real@c044000000000000 02a9 __real@4044000000000000 032d __real@40e0000000000000 034f __dxp_setw 037b __dxp_addx 03aa _log2e 03c0 __dxp_mulh 0457 __dxp_addh 0531 __dxp_getw 056b __dexp 058c __Inf_C 05fe @__security_check_cookie@4 064b __Zero_C"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 8D 45 08 53 8B 5D 18 56 57 50 8D 85 58 FF FF FF 89 9D 28 FF FF FF 50 DD 9D 40 FF FF FF E8 ?? ?? ?? ?? 0F B7 F8 8D 85 40 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 0F B7 F0 85 DB 74 05 33 C0 66 89 03 D9 EE DD 45 10 66 85 F6 75 09 DD E1 DF E0 F6 C4 44 7B 42 DD 45 08 33 DB 66 8B 8D 58 FF FF FF 43 66 85 FF 0F 89 39 05 00 00 DD 05 ?? ?? ?? ?? 66 3B CB 75 2C DD E1 DF E0 F6 C4 44 7B 14 66 3B F3 75 1E DD 05 ?? ?? ?? ?? DD EA DF E0 F6 C4 44 7A 0F DD DB DD D8 DD D9 DD D8 D9 E8 E9 3B 05 00 00 33 C0 66 3B C7 0F 8E F5 04 00 00 66 3B C6 0F 8C EC 04 00 00 B8 00 80 00 00 DD DA 66 85 45 0E 74 1D 66 85 F6 79 18 DD DA DD D9 53 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 E9 FD 04 00 00 D8 D2 DF E0 DD DA F6 C4 41 75 09 83 A5 34 FF FF FF 00 EB 30 DD D8 8D 85 40 FF FF FF 6A FF D9 E0 50 DD 5D 08 E8 ?? ?? ?? ?? DD 45 08 DD 05 ?? ?? ?? ?? 59 59 66 8B 8D 58 FF FF FF 0F B7 C0 89 85 34 FF FF FF D9 E8 DD 05 ?? ?? ?? ?? 66 3B CB 75 1F DD 05 ?? ?? ?? ?? D8 DC DF E0 F6 C4 41 75 10 DD DA 33 F6 DD 95 48 FF FF FF D9 CA DE C9 EB 3F DD D9 DD D8 D9 C9 DC 0D ?? ?? ?? ?? D8 C1 E8 ?? ?? ?? ?? 8D 70 E0 89 B5 4C FF FF FF DB 85 4C FF FF FF DD 9D 2C FF FF FF DD 85 2C FF FF FF DC 0D ?? ?? ?? ?? DE C1 DD 95 48 FF FF FF DD 45 08 D9 C0 C1 E6 05 D8 E2 81 C6 ?? ?? ?? ?? D9 CA 89 B5 30 FF FF FF DE C1 51 51 D9 C1 DE F1 DD 95 38 FF FF FF D9 C0 DE C9 DD 95 20 FF FF FF D9 C9 DD 5D 08 DD 1C 24 E8 ?? ?? ?? ?? DC 8D 20 FF FF FF DD 45 08 DC E9 0F BF 85 58 FF FF FF D9 E8 D9 C0 DC A5 48 FF FF FF 89 85 4C FF FF FF 59 59 DC 0D ?? ?? ?? ?? DE C3 DD 85 38 FF FF FF DE CB D9 CA DD 95 20 FF FF FF DE C1 DB 85 4C FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DC 06 D9 C1 DD 05 ?? ?? ?? ?? DC F9 D9 C9 D8 C2 DD 95 40 FF FF FF DD 45 10 DC C9 D9 C9 DD 95 50 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 11 DD D9 33 DB DD DB DD DB DD D8 DD D9 E9 07 03 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 98 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 85 00 00 00 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 7A DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 6B D9 EE D8 DA DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 04 DE EA EB 02 DE C2 D9 C9 E8 ?? ?? ?? ?? DC CB D9 CB 89 85 4C FF FF FF DD 95 50 FF FF FF DD 46 10 DC 46 08 D8 CC DE CA DE C1 D9 C9 DE CA DB 85 4C FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DE EA D9 C9 DC 0D ?? ?? ?? ?? DE C1 DD 9D 50 FF FF FF E9 31 02 00 00 DD D9 EB 02 DD D8 DD DB DD DB DD D8 DD D9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 84 3F 02 00 00 51 51 DD D8 8D 45 DC DD 45 08 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? DD 85 20 FF FF FF 8D 85 10 FF FF FF 59 59 DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 6A 02 8D 85 10 FF FF FF 50 8D 45 DC 57 50 E8 ?? ?? ?? ?? DD 45 DC 83 C4 20 D9 EE DD E1 DF E0 F6 C4 44 8D 45 BC 7A 13 51 51 DD D9 DD 1C 24 57 50 E8 ?? ?? ?? ?? 83 C4 10 EB 79 6A 08 59 BE ?? ?? ?? ?? 8D 7D BC F3 A5 51 51 DD D8 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? 83 C4 10 DD 44 DD DC D9 EE DA E9 DF E0 F6 C4 44 7B 43 6A 08 59 DD 44 DD DC 8D BD 7C FF FF FF BE ?? ?? ?? ?? 8D 85 7C FF FF FF F3 A5 51 51 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? 57 8D 85 7C FF FF FF 50 8D 45 BC 57 50 E8 ?? ?? ?? ?? 83 C4 20 43 3B DF 7C AE 8B B5 30 FF FF FF 6A 03 56 8D 45 BC 57 50 E8 ?? ?? ?? ?? 0F BF 85 58 FF FF FF 83 C4 08 89 85 30 FF FF FF 8D 45 BC DB 85 30 FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DD 1C 24 57 50 E8 ?? ?? ?? ?? DD 45 10 8D 45 DC 59 59 DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? DD 45 DC 8D 45 9C 6A 08 59 83 C4 08 8D 75 BC 8D 7D 9C F3 A5 DD 1C 24 6A 04 5B 53 50 E8 ?? ?? ?? ?? DD 45 E4 83 C4 10 D9 EE DD E1 DF E0 F6 C4 44 7B 3B 6A 08 59 8D 75 BC DD D8 8D BD 5C FF FF FF F3 A5 51 51 DD 1C 24 8D 85 5C FF FF FF 53 50 E8 ?? ?? ?? ?? 53 8D 85 5C FF FF FF 50 8D 45 9C 53 50 E8 ?? ?? ?? ?? D9 EE 83 C4 20 EB 02 DD D9 DD 45 9C DD 55 08 DD E1 DF E0 F6 C4 44 7B 1A DD 45 A4 DD E2 DF E0 DD DA F6 C4 44 7B 10 DD 45 AC DE C2 DE C1 DD 5D 08 EB 08 DD D9 EB 02 DD D8 DD D8 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? DD 45 08 8D 45 9C D9 E0 DD 1C 24 53 50 E8 ?? ?? ?? ?? 8D 45 9C 53 50 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 C4 18 DD 9D 50 FF FF FF DD 45 08 E8 ?? ?? ?? ?? D9 E8 8B 8D 28 FF FF FF 85 C9 74 05 66 89 01 33 C0 50 51 51 8D 85 50 FF FF FF DD 1C 24 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 0F B7 D8 0F BF C3 83 E8 00 74 11 83 E8 01 75 24 DD D8 DD 05 ?? ?? ?? ?? 6A 08 EB 06 DD D8 D9 EE 6A 10 DD 9D 50 FF FF FF E8 ?? ?? ?? ?? DD 85 50 FF FF FF 59 66 83 BD 34 FF FF FF 00 74 3F D9 E0 EB 3B DD D8 6A 02 58 66 3B F8 75 06 DD DA DD D8 EB 2B DD D8 66 3B F0 75 04 DD D9 EB 20 DD D8 66 3B FB 75 7C BF 00 80 00 00 66 85 7D 0E 75 1F 66 85 7D 16 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 66 85 7D 16 75 21 DD D8 66 85 F6 75 DC 8D 85 40 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 C7 E9 BC 00 00 00 66 85 F6 75 C3 8D 85 40 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 0B DD 05 ?? ?? ?? ?? E9 62 FF FF FF D9 EE EB 9D 66 3B F3 75 23 B8 00 80 00 00 66 85 45 16 75 0A 66 85 C9 7E 88 E9 7B FF FF FF 66 85 C9 0F 8F 7A FF FF FF E9 6D FF FF FF BF 00 80 00 00 66 85 7D 16 75 28 66 85 F6 0F 85 61 FF FF FF 8D 85 40 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 A9 66 85 7D 0E 74 A3 EB 96 6A 04 DD D8 E8 ?? ?? ?? ?? 59 66 85 F6 0F 85 29 FF FF FF 8D 85 40 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 0F 89 10 FF FF FF 66 85 7D 0E 0F 84 06 FF FF FF DD 05 ?? ?? ?? ?? E9 C2 FE FF FF }
	condition:
		$1
}

rule file_639_0_0 {
	meta:
		name = "__ldpow"
		size = 1780
		refs = "000c ___security_cookie 0036 __ldunscale 0047 __ld_int 0085 __real@3fe0000000000000 009e __real@bfe0000000000000 00e8 __fperrraise 00ee __LNan_C 0140 __real@4000000000000000 014b __real@3fe6a09e667f3bcd 0170 __real@4050000000000000 0177 __ftol2_sse 0198 __real@3f90000000000000 01b0 _lnbias 01dd __ldlogpoly 0237 __real@3fe62e42fefa39ef 0256 __real@c0e0000000000000 0276 __real@c02e000000000000 0287 __real@402e000000000000 029c __real@c044000000000000 02a9 __real@4044000000000000 032d __real@40e0000000000000 034f __ldxp_setw 037b __ldxp_addx 03aa _log2e 03c0 __ldxp_mulh 0457 __ldxp_addh 0531 __ldxp_getw 056b __ldexp 058c __LInf_C 05fe @__security_check_cookie@4 064b __LZero_C"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 8D 45 08 53 8B 5D 18 56 57 50 8D 85 58 FF FF FF 89 9D 28 FF FF FF 50 DD 9D 40 FF FF FF E8 ?? ?? ?? ?? 0F B7 F8 8D 85 40 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 0F B7 F0 85 DB 74 05 33 C0 66 89 03 D9 EE DD 45 10 66 85 F6 75 09 DD E1 DF E0 F6 C4 44 7B 42 DD 45 08 33 DB 66 8B 8D 58 FF FF FF 43 66 85 FF 0F 89 39 05 00 00 DD 05 ?? ?? ?? ?? 66 3B CB 75 2C DD E1 DF E0 F6 C4 44 7B 14 66 3B F3 75 1E DD 05 ?? ?? ?? ?? DD EA DF E0 F6 C4 44 7A 0F DD DB DD D8 DD D9 DD D8 D9 E8 E9 3B 05 00 00 33 C0 66 3B C7 0F 8E F5 04 00 00 66 3B C6 0F 8C EC 04 00 00 B8 00 80 00 00 DD DA 66 85 45 0E 74 1D 66 85 F6 79 18 DD DA DD D9 53 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 E9 FD 04 00 00 D8 D2 DF E0 DD DA F6 C4 41 75 09 83 A5 34 FF FF FF 00 EB 30 DD D8 8D 85 40 FF FF FF 6A FF D9 E0 50 DD 5D 08 E8 ?? ?? ?? ?? DD 45 08 DD 05 ?? ?? ?? ?? 59 59 66 8B 8D 58 FF FF FF 0F B7 C0 89 85 34 FF FF FF D9 E8 DD 05 ?? ?? ?? ?? 66 3B CB 75 1F DD 05 ?? ?? ?? ?? D8 DC DF E0 F6 C4 41 75 10 DD DA 33 F6 DD 95 48 FF FF FF D9 CA DE C9 EB 3F DD D9 DD D8 D9 C9 DC 0D ?? ?? ?? ?? D8 C1 E8 ?? ?? ?? ?? 8D 70 E0 89 B5 4C FF FF FF DB 85 4C FF FF FF DD 9D 2C FF FF FF DD 85 2C FF FF FF DC 0D ?? ?? ?? ?? DE C1 DD 95 48 FF FF FF DD 45 08 D9 C0 C1 E6 05 D8 E2 81 C6 ?? ?? ?? ?? D9 CA 89 B5 30 FF FF FF DE C1 51 51 D9 C1 DE F1 DD 95 38 FF FF FF D9 C0 DE C9 DD 95 20 FF FF FF D9 C9 DD 5D 08 DD 1C 24 E8 ?? ?? ?? ?? DC 8D 20 FF FF FF DD 45 08 DC E9 0F BF 85 58 FF FF FF D9 E8 D9 C0 DC A5 48 FF FF FF 89 85 4C FF FF FF 59 59 DC 0D ?? ?? ?? ?? DE C3 DD 85 38 FF FF FF DE CB D9 CA DD 95 20 FF FF FF DE C1 DB 85 4C FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DC 06 D9 C1 DD 05 ?? ?? ?? ?? DC F9 D9 C9 D8 C2 DD 95 40 FF FF FF DD 45 10 DC C9 D9 C9 DD 95 50 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 11 DD D9 33 DB DD DB DD DB DD D8 DD D9 E9 07 03 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 98 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 85 00 00 00 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 7A DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 6B D9 EE D8 DA DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 04 DE EA EB 02 DE C2 D9 C9 E8 ?? ?? ?? ?? DC CB D9 CB 89 85 4C FF FF FF DD 95 50 FF FF FF DD 46 10 DC 46 08 D8 CC DE CA DE C1 D9 C9 DE CA DB 85 4C FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DE EA D9 C9 DC 0D ?? ?? ?? ?? DE C1 DD 9D 50 FF FF FF E9 31 02 00 00 DD D9 EB 02 DD D8 DD DB DD DB DD D8 DD D9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 84 3F 02 00 00 51 51 DD D8 8D 45 DC DD 45 08 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? DD 85 20 FF FF FF 8D 85 10 FF FF FF 59 59 DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 6A 02 8D 85 10 FF FF FF 50 8D 45 DC 57 50 E8 ?? ?? ?? ?? DD 45 DC 83 C4 20 D9 EE DD E1 DF E0 F6 C4 44 8D 45 BC 7A 13 51 51 DD D9 DD 1C 24 57 50 E8 ?? ?? ?? ?? 83 C4 10 EB 79 6A 08 59 BE ?? ?? ?? ?? 8D 7D BC F3 A5 51 51 DD D8 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? 83 C4 10 DD 44 DD DC D9 EE DA E9 DF E0 F6 C4 44 7B 43 6A 08 59 DD 44 DD DC 8D BD 7C FF FF FF BE ?? ?? ?? ?? 8D 85 7C FF FF FF F3 A5 51 51 DD 1C 24 6A 04 5F 57 50 E8 ?? ?? ?? ?? 57 8D 85 7C FF FF FF 50 8D 45 BC 57 50 E8 ?? ?? ?? ?? 83 C4 20 43 3B DF 7C AE 8B B5 30 FF FF FF 6A 03 56 8D 45 BC 57 50 E8 ?? ?? ?? ?? 0F BF 85 58 FF FF FF 83 C4 08 89 85 30 FF FF FF 8D 45 BC DB 85 30 FF FF FF DD 9D 38 FF FF FF DD 85 38 FF FF FF DD 1C 24 57 50 E8 ?? ?? ?? ?? DD 45 10 8D 45 DC 59 59 DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? DD 45 DC 8D 45 9C 6A 08 59 83 C4 08 8D 75 BC 8D 7D 9C F3 A5 DD 1C 24 6A 04 5B 53 50 E8 ?? ?? ?? ?? DD 45 E4 83 C4 10 D9 EE DD E1 DF E0 F6 C4 44 7B 3B 6A 08 59 8D 75 BC DD D8 8D BD 5C FF FF FF F3 A5 51 51 DD 1C 24 8D 85 5C FF FF FF 53 50 E8 ?? ?? ?? ?? 53 8D 85 5C FF FF FF 50 8D 45 9C 53 50 E8 ?? ?? ?? ?? D9 EE 83 C4 20 EB 02 DD D9 DD 45 9C DD 55 08 DD E1 DF E0 F6 C4 44 7B 1A DD 45 A4 DD E2 DF E0 DD DA F6 C4 44 7B 10 DD 45 AC DE C2 DE C1 DD 5D 08 EB 08 DD D9 EB 02 DD D8 DD D8 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? DD 45 08 8D 45 9C D9 E0 DD 1C 24 53 50 E8 ?? ?? ?? ?? 8D 45 9C 53 50 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 C4 18 DD 9D 50 FF FF FF DD 45 08 E8 ?? ?? ?? ?? D9 E8 8B 8D 28 FF FF FF 85 C9 74 05 66 89 01 33 C0 50 51 51 8D 85 50 FF FF FF DD 1C 24 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 0F B7 D8 0F BF C3 83 E8 00 74 11 83 E8 01 75 24 DD D8 DD 05 ?? ?? ?? ?? 6A 08 EB 06 DD D8 D9 EE 6A 10 DD 9D 50 FF FF FF E8 ?? ?? ?? ?? DD 85 50 FF FF FF 59 66 83 BD 34 FF FF FF 00 74 3F D9 E0 EB 3B DD D8 6A 02 58 66 3B F8 75 06 DD DA DD D8 EB 2B DD D8 66 3B F0 75 04 DD D9 EB 20 DD D8 66 3B FB 75 7C BF 00 80 00 00 66 85 7D 0E 75 1F 66 85 7D 16 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 66 85 7D 16 75 21 DD D8 66 85 F6 75 DC 8D 85 40 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 C7 E9 BC 00 00 00 66 85 F6 75 C3 8D 85 40 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 0B DD 05 ?? ?? ?? ?? E9 62 FF FF FF D9 EE EB 9D 66 3B F3 75 23 B8 00 80 00 00 66 85 45 16 75 0A 66 85 C9 7E 88 E9 7B FF FF FF 66 85 C9 0F 8F 7A FF FF FF E9 6D FF FF FF BF 00 80 00 00 66 85 7D 16 75 28 66 85 F6 0F 85 61 FF FF FF 8D 85 40 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 A9 66 85 7D 0E 74 A3 EB 96 6A 04 DD D8 E8 ?? ?? ?? ?? 59 66 85 F6 0F 85 29 FF FF FF 8D 85 40 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 0F 89 10 FF FF FF 66 85 7D 0E 0F 84 06 FF FF FF DD 05 ?? ?? ?? ?? E9 C2 FE FF FF }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "__dtgamma"
		size = 372
		refs = "0013 __real@404b000000000000 0025 _stirling 0032 __real@bfe0000000000000 0046 __real@3fe0000000000000 008d __real@3ff0000000000000 009f __real@3ff8000000000000 00b9 __real@4004000000000000 00cf __real@4000000000000000 012d __dunscale 013c _s 0148 __dpoly 0158 _c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 56 8B 75 08 DD 06 DD 55 F0 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 12 FF 75 0C DD D8 56 E8 ?? ?? ?? ?? 59 59 E9 3F 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3D D9 C0 DD 55 F8 DD 05 ?? ?? ?? ?? D8 D2 DF E0 D9 E8 F6 C4 05 7A 08 DD DA EB 1A D9 C9 D9 CA DC C3 D9 CA D8 CB DD 55 F8 D9 C9 D8 D3 DF E0 F6 C4 05 7A E8 DD D9 DD D8 DE E9 E9 A6 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 12 DD 05 ?? ?? ?? ?? D8 C1 DE C9 DD 5D F8 E9 88 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 0B DD 55 F8 DC 25 ?? ?? ?? ?? EB 1C DD 05 ?? ?? ?? ?? D8 D1 DF E0 F6 C4 41 75 1A DD D8 D9 E8 DD 5D F8 DC 25 ?? ?? ?? ?? 8B 45 0C 33 C9 DD 55 F0 66 89 08 EB 56 D9 E8 D9 C0 DD 55 F8 D9 CA D8 D3 DF E0 F6 C4 05 7B 0E DD DA DD D9 DD D8 EB 22 D9 CA D9 CB D9 CA D9 CB D8 E1 DC FA D9 CA DD 55 F8 D9 CB D8 D2 DF E0 F6 C4 05 7B E4 DD DB DD DA DD D9 DC 25 ?? ?? ?? ?? DD 5D F0 8D 45 F8 50 FF 75 0C E8 ?? ?? ?? ?? DD 45 F0 59 59 DD 45 F8 6A 07 68 ?? ?? ?? ?? 51 DD 1E 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 06 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DC 4D F0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_639_1_0 {
	meta:
		name = "__ldtgamma"
		size = 372
		refs = "0013 __real@404b000000000000 0025 _stirling 0032 __real@bfe0000000000000 0046 __real@3fe0000000000000 008d __real@3ff0000000000000 009f __real@3ff8000000000000 00b9 __real@4004000000000000 00cf __real@4000000000000000 012d __ldunscale 013c _s 0148 __ldpoly 0158 _c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 56 8B 75 08 DD 06 DD 55 F0 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 12 FF 75 0C DD D8 56 E8 ?? ?? ?? ?? 59 59 E9 3F 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3D D9 C0 DD 55 F8 DD 05 ?? ?? ?? ?? D8 D2 DF E0 D9 E8 F6 C4 05 7A 08 DD DA EB 1A D9 C9 D9 CA DC C3 D9 CA D8 CB DD 55 F8 D9 C9 D8 D3 DF E0 F6 C4 05 7A E8 DD D9 DD D8 DE E9 E9 A6 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 12 DD 05 ?? ?? ?? ?? D8 C1 DE C9 DD 5D F8 E9 88 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 0B DD 55 F8 DC 25 ?? ?? ?? ?? EB 1C DD 05 ?? ?? ?? ?? D8 D1 DF E0 F6 C4 41 75 1A DD D8 D9 E8 DD 5D F8 DC 25 ?? ?? ?? ?? 8B 45 0C 33 C9 DD 55 F0 66 89 08 EB 56 D9 E8 D9 C0 DD 55 F8 D9 CA D8 D3 DF E0 F6 C4 05 7B 0E DD DA DD D9 DD D8 EB 22 D9 CA D9 CB D9 CA D9 CB D8 E1 DC FA D9 CA DD 55 F8 D9 CB D8 D2 DF E0 F6 C4 05 7B E4 DD DB DD DA DD D9 DC 25 ?? ?? ?? ?? DD 5D F0 8D 45 F8 50 FF 75 0C E8 ?? ?? ?? ?? DD 45 F0 59 59 DD 45 F8 6A 07 68 ?? ?? ?? ?? 51 DD 1E 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 06 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DC 4D F0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "_stirling"
		size = 148
		refs = "001b __real@3fe0000000000000 0029 __dpow 003f _approx0 0045 __real@3f86e2e6d3354adf 0052 __dpoly 0080 __CIexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 8B 75 0C 57 8B 7D 08 56 83 EC 10 DD 07 DD 55 F8 DD 05 ?? ?? ?? ?? D8 E9 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 D9 E8 83 C4 14 DC 75 F8 66 F7 1E 6A 01 FF 35 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 51 51 DD 55 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 0D FF 35 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DD 5D E8 DD 45 F8 D9 E0 E8 ?? ?? ?? ?? DC 4D E0 DC 7D E8 DD 1F D9 EE 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_639_3_0 {
	meta:
		name = "_stirling"
		size = 148
		refs = "001b __real@3fe0000000000000 0029 __ldpow 003f _approx0 0045 __real@3f86e2e6d3354adf 0052 __ldpoly 0080 __CIexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 8B 75 0C 57 8B 7D 08 56 83 EC 10 DD 07 DD 55 F8 DD 05 ?? ?? ?? ?? D8 E9 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 D9 E8 83 C4 14 DC 75 F8 66 F7 1E 6A 01 FF 35 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 51 51 DD 55 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 0D FF 35 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DD 5D E8 DD 45 F8 D9 E0 E8 ?? ?? ?? ?? DC 4D E0 DC 7D E8 DD 1F D9 EE 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "_tgamma"
		size = 487
		refs = "0017 __d_int 004d __fperrraise 0053 __Nan_C 0072 __Inf_C 009c __real@c065c00000000000 00bb __dgamma_big 00f7 __real@bff0000000000000 010c __real@400921fb54442d18 0117 __dsin 013c __dtgamma 0157 __dscale 017b __real@4065c00000000000 0198 __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C DD 45 08 8D 45 EC 56 33 F6 56 50 DD 5D EC E8 ?? ?? ?? ?? DD 45 08 D9 EE 98 59 59 2B C6 74 35 DD D8 83 E8 01 74 0F 83 E8 01 75 67 DD D8 DD 45 08 E9 A5 01 00 00 B8 00 80 00 00 DD D8 66 85 45 0E 74 EB 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 85 01 00 00 DD E1 DF E0 F6 C4 44 7A 28 DD D8 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? B8 00 80 00 00 59 66 85 45 0E 0F 84 5C 01 00 00 D9 E0 E9 55 01 00 00 D8 D9 DF E0 F6 C4 41 75 04 DD D8 EB B0 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 10 6A 10 DD D8 E8 ?? ?? ?? ?? D9 EE E9 28 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 D8 D9 DF E0 F6 C4 41 0F 85 AB 00 00 00 DD 55 F4 D9 C0 8D 45 F4 D9 E0 D9 E8 DE E9 6A FF 50 DD 5D E4 DC 65 EC DD 5D EC E8 ?? ?? ?? ?? DD 45 08 DC 65 F4 59 59 DC 1D ?? ?? ?? ?? DF E0 DD 45 EC F6 C4 05 7A 05 D9 E0 DD 55 EC DC 0D ?? ?? ?? ?? 56 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 8D 45 FC DC C9 D9 E0 D9 E8 50 8D 45 E4 DE E9 50 DE C9 D9 E0 DC 3D ?? ?? ?? ?? DD 5D F4 E8 ?? ?? ?? ?? D9 E8 DE C1 0F BF 45 FC 50 8D 45 F4 50 DC 7D F4 DC 4D E4 DD 5D F4 E8 ?? ?? ?? ?? 98 83 C4 1C 2B C6 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 F4 EB 69 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 4E 8D 45 FC 50 8D 45 08 50 E8 ?? ?? ?? ?? DD 55 EC DC 05 ?? ?? ?? ?? 0F BF 45 FC F7 D8 50 8D 45 08 DC 75 08 50 DD 5D 08 E8 ?? ?? ?? ?? 98 83 C4 10 2B C6 74 0D 83 E8 01 0F 85 72 FE FF FF 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 E9 61 FE FF FF 6A 08 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_639_4_0 {
	meta:
		name = "_tgammal"
		size = 487
		refs = "0017 __ld_int 004d __fperrraise 0053 __LNan_C 0072 __LInf_C 009c __real@c065c00000000000 00bb __ldgamma_big 00f7 __real@bff0000000000000 010c __real@400921fb54442d18 0117 __ldsin 013c __ldtgamma 0157 __ldscale 017b __real@4065c00000000000 0198 __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C DD 45 08 8D 45 EC 56 33 F6 56 50 DD 5D EC E8 ?? ?? ?? ?? DD 45 08 D9 EE 98 59 59 2B C6 74 35 DD D8 83 E8 01 74 0F 83 E8 01 75 67 DD D8 DD 45 08 E9 A5 01 00 00 B8 00 80 00 00 DD D8 66 85 45 0E 74 EB 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 85 01 00 00 DD E1 DF E0 F6 C4 44 7A 28 DD D8 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? B8 00 80 00 00 59 66 85 45 0E 0F 84 5C 01 00 00 D9 E0 E9 55 01 00 00 D8 D9 DF E0 F6 C4 41 75 04 DD D8 EB B0 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 10 6A 10 DD D8 E8 ?? ?? ?? ?? D9 EE E9 28 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 D8 D9 DF E0 F6 C4 41 0F 85 AB 00 00 00 DD 55 F4 D9 C0 8D 45 F4 D9 E0 D9 E8 DE E9 6A FF 50 DD 5D E4 DC 65 EC DD 5D EC E8 ?? ?? ?? ?? DD 45 08 DC 65 F4 59 59 DC 1D ?? ?? ?? ?? DF E0 DD 45 EC F6 C4 05 7A 05 D9 E0 DD 55 EC DC 0D ?? ?? ?? ?? 56 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 8D 45 FC DC C9 D9 E0 D9 E8 50 8D 45 E4 DE E9 50 DE C9 D9 E0 DC 3D ?? ?? ?? ?? DD 5D F4 E8 ?? ?? ?? ?? D9 E8 DE C1 0F BF 45 FC 50 8D 45 F4 50 DC 7D F4 DC 4D E4 DD 5D F4 E8 ?? ?? ?? ?? 98 83 C4 1C 2B C6 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 F4 EB 69 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 4E 8D 45 FC 50 8D 45 08 50 E8 ?? ?? ?? ?? DD 55 EC DC 05 ?? ?? ?? ?? 0F BF 45 FC F7 D8 50 8D 45 08 DC 75 08 50 DD 5D 08 E8 ?? ?? ?? ?? 98 83 C4 10 2B C6 74 0D 83 E8 01 0F 85 72 FE FF FF 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 E9 61 FE FF FF 6A 08 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "__mbsupr"
		size = 37
		refs = "0013 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "__mbslwr"
		size = 37
		refs = "0013 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "__mbsupr_l"
		size = 38
		refs = "0014 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "__mbslwr_l"
		size = 38
		refs = "0014 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "__mbsupr_s_l"
		size = 254
		refs = "0028 __errno 0032 __invalid_parameter_noinfo 0040 _strnlen 0057 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0096 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 56 8B 75 08 57 8B 7D 0C 85 F6 74 0F 85 FF 74 0F 85 F6 75 21 33 C0 E9 BE 00 00 00 85 FF 74 F1 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 A4 00 00 00 57 56 E8 ?? ?? ?? ?? 59 59 3B C7 72 05 C6 06 00 EB D8 53 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 80 3E 00 8B DE 8B FE 74 68 8B 45 F0 8A 0B 0F B6 D1 89 55 F8 8A 54 02 19 F6 C2 04 74 3C 6A 01 FF 70 04 8D 4D FC 6A 02 51 6A 02 53 68 00 02 00 00 FF B0 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 46 8B 4D FC 88 0F 47 43 83 F8 01 8B 45 F0 7E 16 88 2F EB 11 F6 C2 20 74 0A 8B 4D F8 8A 8C 01 19 01 00 00 88 0F 47 43 80 3B 00 75 9B 33 C0 88 07 80 7D F4 00 5B 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 5F 5E 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 06 00 E8 ?? ?? ?? ?? 8B 00 EB D2 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "_lrintf"
		size = 125
		refs = "000b __fdtest 0024 _nearbyintf 0042 __fperrraise 004c __real@c1e0000000000000 0059 __real@4f000000 0067 __ftol2_sse"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 62 7E 05 83 F8 02 7E 53 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC D9 C0 D9 45 08 DA E9 DF E0 59 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? D9 45 FC 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0C DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_4_0 {
	meta:
		name = "__mbsncat_s_l"
		size = 521
		refs = "003c __errno 0046 __invalid_parameter_noinfo 005a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0070 _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 14 53 56 8B 75 08 33 DB 89 5D F8 57 85 C0 75 0B 85 F6 75 0B 39 5D 0C 75 18 EB 27 85 F6 74 12 39 5D 0C 76 0D 8B 7D 10 85 C0 74 1E 85 FF 75 1A 88 1E E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E8 39 58 08 75 18 8B 45 14 50 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 72 01 00 00 8B 45 0C 8B CE 8B D0 38 19 74 06 41 83 EA 01 75 F6 85 D2 75 0E 88 1E E8 ?? ?? ?? ?? 6A 16 E9 35 01 00 00 3B D0 73 40 8D 41 FF 89 45 F0 89 45 F4 3B C6 72 1F 8B 5D E8 8B F8 0F B6 07 F6 44 18 19 04 74 05 4F 3B FE 73 F1 8B 45 F0 33 DB 89 7D F4 8B 7D 10 2B 45 F4 A8 01 74 0D 8B 4D F0 42 C7 45 F8 01 00 00 00 88 19 8B 45 14 83 F8 FF 75 6D 2B CF 8A 07 88 04 39 47 84 C0 74 05 83 EA 01 75 F1 8B 7D 14 85 D2 0F 85 D7 00 00 00 83 FF FF 0F 85 BB 00 00 00 39 55 F8 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 7D 0C 83 FF 01 0F 86 96 00 00 00 8D 57 FE 03 D6 8B CA 3B D6 72 15 8B 7D E8 0F B6 01 F6 44 38 19 04 74 05 49 3B CE 73 F1 8B 7D 0C 8B C2 2B C1 A8 01 74 6E 88 1A EB 6E 85 C0 74 54 8B 75 E8 0F B6 07 F6 44 30 19 04 8B 75 08 74 20 80 7F 01 00 74 35 83 FA 02 76 2C 8A 07 88 01 8A 47 01 83 C7 02 88 41 01 83 C1 02 83 EA 02 EB 0F 8A 07 88 01 41 47 84 C0 74 1A 83 EA 01 74 15 83 6D 14 01 75 BB EB 0D 8B D3 EB 09 88 19 C7 45 F8 01 00 00 00 8B 7D 14 85 FF 0F 85 44 FF FF FF 88 19 E9 3D FF FF FF 88 5C 3E FF 6A 50 5B EB 23 88 1E E8 ?? ?? ?? ?? 6A 22 5B 89 18 E8 ?? ?? ?? ?? EB 10 83 7D F8 00 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D EC 00 0F 84 50 FE FF FF 8B 4D E0 83 A1 50 03 00 00 FD E9 41 FE FF FF }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_logbf"
		size = 96
		refs = "0010 __fdunscale 0046 __FInf_C 004f __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 30 83 E8 01 74 23 83 E8 01 74 19 66 8B 45 FC 66 48 66 89 45 FC 98 89 45 F8 DB 45 F8 D9 5D F8 D9 45 F8 EB 1D D9 45 08 EB 18 D9 05 ?? ?? ?? ?? EB 10 6A 04 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 59 D9 E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_41_10_0 {
	meta:
		name = "___acrt_locale_free_monetary"
		size = 254
		refs = "0016 ___acrt_lconv_c 001e __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 0F 84 EA 00 00 00 8B 46 0C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 10 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 14 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 18 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 1C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 20 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 24 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 38 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 3C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 40 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 44 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 48 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 4C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 5E 5D C3 }
	condition:
		$1
}

rule file_41_11_0 {
	meta:
		name = "___acrt_locale_initialize_monetary"
		size = 956
		refs = "002f ___acrt_lconv_c 003d __calloc_base 0049 __free_base 00d0 ___acrt_GetLocaleInfoA 02be ___acrt_locale_free_monetary"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 8B 5D 08 33 C9 56 57 89 4D F4 89 5D E8 89 4D EC 39 8B AC 00 00 00 75 17 39 8B B0 00 00 00 75 0F 8B F9 89 4D F8 BE ?? ?? ?? ?? E9 37 03 00 00 6A 50 6A 01 E8 ?? ?? ?? ?? 8B F0 6A 00 89 75 FC E8 ?? ?? ?? ?? 83 C4 0C 85 F6 75 08 33 C0 40 E9 59 03 00 00 6A 04 6A 01 E8 ?? ?? ?? ?? 8B F8 6A 00 89 7D F8 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 75 09 56 E8 ?? ?? ?? ?? 59 EB D3 83 BB AC 00 00 00 00 0F 84 86 02 00 00 6A 04 6A 01 E8 ?? ?? ?? ?? 8B F8 6A 00 89 7D F4 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 75 12 56 E8 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 59 EB C2 8B BB AC 00 00 00 8D 46 0C 50 6A 15 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 8B 4D FC 8B F0 83 C1 10 8D 45 E8 51 6A 14 57 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 14 50 6A 16 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 18 50 6A 17 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 1C 89 45 F0 50 6A 18 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 20 50 6A 50 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 24 50 6A 51 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 28 50 6A 1A 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 29 50 6A 19 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 2A 50 6A 54 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 2B 50 6A 55 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 2C 50 6A 56 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 2D 50 6A 57 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 2E 50 6A 52 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 2F 50 6A 53 57 8D 45 E8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 38 50 6A 15 57 6A 02 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 3C 50 6A 14 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 40 50 6A 16 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 44 50 6A 17 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 48 50 6A 50 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 4C 50 6A 51 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 14 0B C6 74 29 8B 5D FC 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 10 E9 72 FD FF FF 8B 55 F0 8B 12 EB 0F 8A 02 3C 30 7C 10 3C 39 7F 0C 2C 30 88 02 42 80 3A 00 75 EC EB 22 3C 3B 75 F4 8B F2 8A 46 01 88 06 8D 76 01 80 3E 00 75 F3 EB E4 8B 7D FC BE ?? ?? ?? ?? 6A 14 59 F3 A5 8B 83 88 00 00 00 33 C9 8B 75 FC 41 8B 7D F4 8B 00 89 06 8B 83 88 00 00 00 8B 40 04 89 46 04 8B 83 88 00 00 00 8B 40 08 89 46 08 8B 83 88 00 00 00 8B 40 30 89 46 30 8B 83 88 00 00 00 8B 40 34 89 46 34 8B 45 F8 89 08 85 FF 74 02 89 0F 8B 83 84 00 00 00 85 C0 74 03 F0 FF 08 8B 4B 7C 85 C9 74 1E 83 C8 FF F0 0F C1 01 75 15 FF B3 88 00 00 00 E8 ?? ?? ?? ?? FF 73 7C E8 ?? ?? ?? ?? 59 59 8B 45 F8 89 43 7C 33 C0 89 BB 84 00 00 00 89 B3 88 00 00 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_12_0 {
	meta:
		name = "_fix_grouping"
		size = 58
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 80 3A 00 74 16 56 8A 02 3C 30 7C 11 3C 39 7F 0D 2C 30 88 02 42 80 3A 00 75 EC 5E 5D C3 3C 3B 75 F3 8B F2 8A 46 01 88 06 8D 76 01 80 3E 00 75 F3 EB E3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_creall"
		size = 49
		refs = "0009 ___security_cookie 0029 @__security_check_cookie@4"
		altNames = "_creal"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 4D FC 8D 75 08 33 CD 8D 7D EC A5 A5 A5 A5 DD 45 EC 5F 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "__mbslwr_s_l"
		size = 254
		refs = "0028 __errno 0032 __invalid_parameter_noinfo 0040 _strnlen 0057 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0096 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 56 8B 75 08 57 8B 7D 0C 85 F6 74 0F 85 FF 74 0F 85 F6 75 21 33 C0 E9 BE 00 00 00 85 FF 74 F1 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 A4 00 00 00 57 56 E8 ?? ?? ?? ?? 59 59 3B C7 72 05 C6 06 00 EB D8 53 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 80 3E 00 8B DE 8B FE 74 68 8B 45 F0 8A 0B 0F B6 D1 89 55 F8 8A 54 02 19 F6 C2 04 74 3C 6A 01 FF 70 04 8D 4D FC 6A 02 51 6A 02 53 68 00 01 00 00 FF B0 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 46 8B 4D FC 88 0F 47 43 83 F8 01 8B 45 F0 7E 16 88 2F EB 11 F6 C2 10 74 0A 8B 4D F8 8A 8C 01 19 01 00 00 88 0F 47 43 80 3B 00 75 9B 33 C0 88 07 80 7D F4 00 5B 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 5F 5E 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 06 00 E8 ?? ?? ?? ?? 8B 00 EB D2 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_fegetexceptflag"
		size = 49
		refs = "0017 __getfpstatusword 001f ___acrt_fenv_get_fp_status_word_from_exception_mask"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B 7D 0C 83 E7 1F 75 07 8B 45 08 21 38 EB 17 56 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 59 8B 4D 08 23 C6 5E 89 01 33 C0 5F 5D C3 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
		size = 671
		refs = "0009 ___security_cookie 0029 __errno 0034 __invalid_parameter_noinfo 006b __spawnve 008d _strchr 00cb __dupenv_s 00f6 __calloc_base 0134 _strrchr 015d _strcat_s 01db ___doserrno 0244 ___acrt_getpath 025b __free_base 028a @__security_check_cookie@4 029a __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 56 8B 75 10 89 75 DC 57 8B 7D 14 89 7D E0 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 41 02 00 00 80 3B 00 74 E3 85 F6 74 DF 8B 06 85 C0 74 D9 80 38 00 74 D4 E8 ?? ?? ?? ?? 57 56 53 8B 08 FF 75 08 83 20 00 89 45 D8 89 4D D4 E8 ?? ?? ?? ?? 8B F8 83 CE FF 83 C4 10 3B FE 0F 85 EF 01 00 00 E8 ?? ?? ?? ?? 83 38 02 75 22 6A 5C 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 14 6A 2F 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 80 7B 01 3A 75 07 8B FE E9 BC 01 00 00 33 C9 C7 45 F4 50 41 54 48 8D 45 F4 88 4D F8 50 51 8D 45 E8 89 4D E8 50 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 0C 85 C0 74 0A 83 F8 16 75 09 E9 AF 01 00 00 85 C9 75 07 8B FE E9 75 01 00 00 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 0F 84 50 01 00 00 68 03 01 00 00 56 FF 75 E8 E9 2F 01 00 00 80 3E 00 0F 84 39 01 00 00 8B CE 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 8D 7E FF 6A 5C 56 03 F9 E8 ?? ?? ?? ?? 59 59 3B F8 74 2E 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 20 8D 45 EC 66 C7 45 EC 5C 00 50 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 26 01 00 00 8B D6 8D 4A 01 8A 02 42 84 C0 75 F9 2B D1 8B CB 8D 79 01 8A 01 41 84 C0 75 F9 2B CF 8D 04 11 B9 04 01 00 00 3B C1 0F 83 BE 00 00 00 53 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 E7 00 00 00 E8 ?? ?? ?? ?? FF 75 E0 FF 75 DC 83 20 00 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 89 00 00 00 E8 ?? ?? ?? ?? 83 38 02 74 60 E8 ?? ?? ?? ?? 83 38 15 74 56 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 15 8D 7E 01 6A 2F 57 E8 ?? ?? ?? ?? C6 45 F3 01 59 59 3B C7 74 04 C6 45 F3 00 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 15 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 59 59 3B C7 75 04 B0 01 EB 02 32 C0 80 7D F3 00 75 04 84 C0 74 1C 68 03 01 00 00 56 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 85 C0 0F 85 BE FE FF FF 83 CF FF 56 E8 ?? ?? ?? ?? 59 8B 4D E8 51 E8 ?? ?? ?? ?? 83 65 E8 00 59 8B 45 D8 83 38 00 75 09 8B 4D D4 85 C9 74 02 89 08 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
		size = 745
		refs = "0009 ___security_cookie 0029 __errno 0034 __invalid_parameter_noinfo 0071 __wspawnve 0095 _wcschr 00ec __wdupenv_s 0117 __calloc_base 015e _wcsrchr 018e _wcscat_s 021c ___doserrno 028c ___acrt_wgetpath 02a3 __free_base 02d4 @__security_check_cookie@4 02e4 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 56 8B 75 10 89 75 D4 57 8B 7D 14 89 7D D8 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 8B 02 00 00 33 C9 89 4D DC 66 39 0B 74 DE 85 F6 74 DA 8B 06 85 C0 74 D4 66 39 08 74 CF E8 ?? ?? ?? ?? 57 56 53 8B 08 FF 75 08 89 4D CC 33 C9 89 45 D0 89 08 E8 ?? ?? ?? ?? 8B F8 83 CE FF 83 C4 10 3B FE 0F 85 32 02 00 00 E8 ?? ?? ?? ?? 83 38 02 75 25 6A 5C 58 50 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 15 6A 2F 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 07 66 83 7B 02 3A 75 07 8B FE E9 FC 01 00 00 6A 50 58 6A 41 66 89 45 F0 33 C9 58 6A 54 66 89 45 F2 58 66 89 45 F4 6A 48 58 66 89 45 F6 33 C0 66 89 45 F8 8D 45 F0 50 51 8D 45 E8 89 4D E8 50 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 0C 85 C0 74 0A 83 F8 16 75 09 E9 D8 01 00 00 85 C9 75 07 8B FE E9 9C 01 00 00 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 0F 84 77 01 00 00 68 03 01 00 00 56 FF 75 E8 E9 56 01 00 00 33 FF 66 39 3E 0F 84 5E 01 00 00 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B C7 75 F5 2B CA 6A 5C D1 F9 58 49 50 56 8D 3C 4E E8 ?? ?? ?? ?? 59 59 3B F8 74 35 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 27 6A 5C 58 66 89 45 E4 33 C0 66 89 45 E6 8D 45 E4 50 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 3F 01 00 00 8B D6 33 FF 8D 4A 02 66 8B 02 83 C2 02 66 3B C7 75 F5 2B D1 8B CB D1 FA 8D 79 02 66 8B 01 83 C1 02 66 3B 45 DC 75 F4 2B CF D1 F9 8D 04 11 B9 04 01 00 00 3B C1 0F 83 C6 00 00 00 53 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 F1 00 00 00 E8 ?? ?? ?? ?? FF 75 D8 33 C9 FF 75 D4 89 08 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 90 00 00 00 E8 ?? ?? ?? ?? 83 38 02 74 67 E8 ?? ?? ?? ?? 83 38 15 74 5D 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 17 8D 7E 02 6A 2F 57 E8 ?? ?? ?? ?? 59 59 3B C7 75 06 C6 45 EF 01 EB 05 33 C0 88 45 EF 6A 5C 58 50 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 17 6A 5C 58 50 8D 7E 02 57 E8 ?? ?? ?? ?? 59 59 3B C7 75 04 B0 01 EB 02 33 C0 80 7D EF 00 75 04 84 C0 74 1C 68 03 01 00 00 56 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 85 C0 0F 85 97 FE FF FF 83 CF FF 56 E8 ?? ?? ?? ?? 59 8B 4D E8 51 E8 ?? ?? ?? ?? 33 C0 59 89 45 E8 8B 45 D0 33 C9 39 08 75 09 8B 4D CC 85 C9 74 02 89 08 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "??$tcscat_s@AAPADHAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY01$$CBD@Z"
		size = 28
		refs = "0013 _strcat_s"
		altNames = "??$tcscat_s@AAPADABIAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY01$$CBD@Z ??$tcscat_s@AAPADABIAAY02$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY02$$CBD@Z ??$tcscat_s@ABQADABIAAY02$$CBD@?$__crt_char_traits@D@@SAHABQADABIAAY02$$CBD@Z ??$tcscat_s@PADABIAAY01$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY01$$CBD@Z ??$tcscat_s@PADABIAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY04$$CBD@Z ??$tcscat_s@PADHAAY01$$CBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHAAY01$$CBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_16_3 {
	meta:
		name = "??$tcscat_s@AAPA_WABIAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_615_9_3 {
	meta:
		name = "??$tcscat_s@AAPA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY02$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_6_4 {
	meta:
		name = "??$tcscat_s@AAPA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_615_11_3 {
	meta:
		name = "??$tcscat_s@ABQA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAY02$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_24_0 {
	meta:
		name = "??$tcscat_s@PA_WABIAAY01$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_25_4 {
	meta:
		name = "??$tcscat_s@PA_WABIAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY04$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_27_4 {
	meta:
		name = "??$tcscat_s@PA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_19_2 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAY0L@$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY0L@$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_19_4 {
	meta:
		name = "??$tcscpy_s@AAPADHAAY04$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY04$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_22_0 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY0L@$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_20_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WHAAY04$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY04$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_22_2 {
	meta:
		name = "??$tcscpy_s@PADABIAAY02$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY02$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_281_24_0 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY02$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_32_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY03$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY03$$CBD@Z"
		size = 28
		refs = "0013 __dupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_37_3 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY04$$CBD@Z"
		size = 28
		refs = "0013 __dupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_38_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY07$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY07$$CBD@Z"
		size = 28
		refs = "0013 __dupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_34_4 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY0L@$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY0L@$$CBD@Z"
		size = 28
		refs = "0013 __dupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_400_33_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY03$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY03$$CB_W@Z"
		size = 28
		refs = "0013 __wdupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_21_3 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY04$$CB_W@Z"
		size = 28
		refs = "0013 __wdupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_40_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY07$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY07$$CB_W@Z"
		size = 28
		refs = "0013 __wdupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_35_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY0L@$$CB_W@Z"
		size = 28
		refs = "0013 __wdupenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "??$tcschr@AAPADD@?$__crt_char_traits@D@@SAPADAAPAD$$QAD@Z"
		size = 26
		refs = "0012 _strchr"
		altNames = "??$tcschr@ABQADD@?$__crt_char_traits@D@@SAPADABQAD$$QAD@Z ??$tcschr@PADD@?$__crt_char_traits@D@@SAPAD$$QAPAD$$QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 08 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_18_0 {
	meta:
		name = "??$tcsrchr@AAPADD@?$__crt_char_traits@D@@SAPADAAPAD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 08 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_333_24_0 {
	meta:
		name = "??$tcsrchr@ABQADD@?$__crt_char_traits@D@@SAPADABQAD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 08 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_9_0 {
	meta:
		name = "??$tcschr@AAPA_WD@?$__crt_char_traits@_W@@SAPA_WAAPA_W$$QAD@Z"
		size = 30
		refs = "0016 _wcschr"
		altNames = "??$tcschr@ABQA_WD@?$__crt_char_traits@_W@@SAPA_WABQA_W$$QAD@Z ??$tcschr@PA_WD@?$__crt_char_traits@_W@@SAPA_W$$QAPA_W$$QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C8 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_19_0 {
	meta:
		name = "??$tcsrchr@AAPA_WD@?$__crt_char_traits@_W@@SAPA_WAAPA_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C8 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_333_25_0 {
	meta:
		name = "??$tcsrchr@ABQA_WD@?$__crt_char_traits@_W@@SAPA_WABQA_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C8 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_10_0 {
	meta:
		name = "??$tcschr@ABQBDD@?$__crt_char_traits@D@@SAPBDABQBD$$QAD@Z"
		size = 26
		refs = "0012 _strchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_281_29_0 {
	meta:
		name = "??$tcsrchr@AAPBDD@?$__crt_char_traits@D@@SAPBDAAPBD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_281_31_0 {
	meta:
		name = "??$tcsrchr@ABQBDD@?$__crt_char_traits@D@@SAPBDABQBD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_11_0 {
	meta:
		name = "??$tcschr@ABQB_WD@?$__crt_char_traits@_W@@SAPB_WABQB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcschr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_281_30_0 {
	meta:
		name = "??$tcsrchr@AAPB_WD@?$__crt_char_traits@_W@@SAPB_WAAPB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_281_32_0 {
	meta:
		name = "??$tcsrchr@ABQB_WD@?$__crt_char_traits@_W@@SAPB_WABQB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_45_14_0 {
	meta:
		name = "??$tcslen@AAPAD@?$__crt_char_traits@D@@SAIAAPAD@Z"
		size = 24
		altNames = "??$tcslen@AAPBD@?$__crt_char_traits@D@@SAIAAPBD@Z ??$tcslen@ABQAD@?$__crt_char_traits@D@@SAIABQAD@Z ??$tcslen@ABQBD@?$__crt_char_traits@D@@SAIABQBD@Z ??$tcslen@PAD@?$__crt_char_traits@D@@SAI$$QAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8D 50 01 8A 08 40 84 C9 75 F9 2B C2 5D C3 }
	condition:
		$1
}

rule file_45_15_0 {
	meta:
		name = "??$tcslen@AAPA_W@?$__crt_char_traits@_W@@SAIAAPA_W@Z"
		size = 30
		altNames = "??$tcslen@AAPB_W@?$__crt_char_traits@_W@@SAIAAPB_W@Z ??$tcslen@ABQA_W@?$__crt_char_traits@_W@@SAIABQA_W@Z ??$tcslen@ABQB_W@?$__crt_char_traits@_W@@SAIABQB_W@Z ??$tcslen@PA_W@?$__crt_char_traits@_W@@SAI$$QAPA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8D 50 02 66 8B 08 83 C0 02 66 85 C9 75 F5 2B C2 D1 F8 5D C3 }
	condition:
		$1
}

rule file_45_24_0 {
	meta:
		name = "??$tspawnve@ABHAAPADABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHAAPADABQBQBD2@Z"
		size = 35
		refs = "001a __spawnve"
		altNames = "??$tspawnve@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z ??$tspawnve@ABHABQBDABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQBQBD2@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_285_4_0 {
	meta:
		name = "??$capture_argv@PAPADABQBDPAPADH@?$__crt_char_traits@D@@SAPAPAD$$QAPAPADABQBD0$$QAH@Z"
		size = 35
		refs = "001a ___acrt_capture_narrow_argv"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_277_5_3 {
	meta:
		name = "??$capture_argv@PAPADABQB_WPAPA_WH@?$__crt_char_traits@_W@@SAPAPA_W$$QAPAPADABQB_W$$QAPAPA_W$$QAH@Z"
		size = 35
		refs = "001a ___acrt_capture_wide_argv"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_15_0 {
	meta:
		name = "??$itot_s@ABIPADIH@?$__crt_char_traits@D@@SAHABI$$QAPAD$$QAI$$QAH@Z"
		size = 35
		refs = "001a __itoa_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_16_4 {
	meta:
		name = "??$itot_s@ABIPA_WIH@?$__crt_char_traits@_W@@SAHABI$$QAPA_W$$QAI$$QAH@Z"
		size = 35
		refs = "001a __itow_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_157_3_4 {
	meta:
		name = "??$open_file@ABQBDABQBDABHPAU_iobuf@@@?$__crt_char_traits@D@@SAPAU_iobuf@@ABQBD0ABH$$QAPAU1@@Z"
		size = 35
		refs = "001a __openfile"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_182_5_4 {
	meta:
		name = "??$open_file@ABQB_WABQB_WABHPAU_iobuf@@@?$__crt_char_traits@_W@@SAPAU_iobuf@@ABQB_W0ABH$$QAPAU1@@Z"
		size = 35
		refs = "001a __wopenfile"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_11_2 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQBDABQBQBDPAPADPAPAD@?$__crt_char_traits@D@@SAHABQBQBD0$$QAPAPAD1@Z"
		size = 35
		refs = "001a ___acrt_pack_narrow_command_line_and_environment"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_12_2 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQB_WABQBQB_WPAPA_WPAPA_W@?$__crt_char_traits@_W@@SAHABQBQB_W0$$QAPAPA_W1@Z"
		size = 35
		refs = "001a ___acrt_pack_wide_command_line_and_environment"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_615_20_4 {
	meta:
		name = "??$tcsncat_s@AAPADABIABQBDI@?$__crt_char_traits@D@@SAHAAPADABIABQBD$$QAI@Z"
		size = 35
		refs = "001a _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_615_21_2 {
	meta:
		name = "??$tcsncat_s@AAPA_WABIABQB_WI@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W$$QAI@Z"
		size = 35
		refs = "001a _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_35_4 {
	meta:
		name = "??$tcsncat_s@ABQADABIAAPBDI@?$__crt_char_traits@D@@SAHABQADABIAAPBD$$QAI@Z"
		size = 35
		refs = "001a _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_36_3 {
	meta:
		name = "??$tcsncat_s@ABQADABIABQBDABI@?$__crt_char_traits@D@@SAHABQADABIABQBD1@Z"
		size = 35
		refs = "001a _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_37_3 {
	meta:
		name = "??$tcsncat_s@ABQADABIPBDI@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD$$QAI@Z"
		size = 35
		refs = "001a _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_38_3 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIAAPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABIAAPB_W$$QAI@Z"
		size = 35
		refs = "001a _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_39_3 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W1@Z"
		size = 35
		refs = "001a _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_681_40_3 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W$$QAI@Z"
		size = 35
		refs = "001a _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_21_2 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPADABI@?$__crt_char_traits@D@@SAHAAPAD$$QAI0ABI@Z"
		size = 35
		refs = "001a _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_716_12_4 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPBDABI@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBDABI@Z"
		size = 35
		refs = "001a _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_716_13_2 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPBDH@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBD$$QAH@Z"
		size = 35
		refs = "001a _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_22_3 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPA_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAI0ABI@Z"
		size = 35
		refs = "001a _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_716_14_2 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_WABI@Z"
		size = 35
		refs = "001a _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_716_15_0 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_W$$QAH@Z"
		size = 35
		refs = "001a _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_23_3 {
	meta:
		name = "??$tcsncpy_s@PADABIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD1@Z"
		size = 35
		refs = "001a _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_24_3 {
	meta:
		name = "??$tcsncpy_s@PADIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBDABI@Z"
		size = 35
		refs = "001a _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_25_3 {
	meta:
		name = "??$tcsncpy_s@PA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W1@Z"
		size = 35
		refs = "001a _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_119_26_3 {
	meta:
		name = "??$tcsncpy_s@PA_WIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_WABI@Z"
		size = 35
		refs = "001a _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_25_3 {
	meta:
		name = "??$tspawnve@ABHAAPA_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHAAPA_WABQBQB_W2@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_285_9_3 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_27_0 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQBQB_W2@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_277_8_4 {
	meta:
		name = "??$tspawnvpe@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z"
		size = 35
		refs = "001a __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_277_9_2 {
	meta:
		name = "??$tspawnvpe@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 35
		refs = "001a __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_400_34_2 {
	meta:
		name = "??$ultot_s@AAIABQADABIH@?$__crt_char_traits@D@@SAHAAIABQADABI$$QAH@Z"
		size = 35
		refs = "001a __ultoa_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_400_35_2 {
	meta:
		name = "??$ultot_s@AAIABQA_WABIH@?$__crt_char_traits@_W@@SAHAAIABQA_WABI$$QAH@Z"
		size = 35
		refs = "001a __ultow_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_30_0 {
	meta:
		name = "??0__crt_errno_guard@@QAE@QAH@Z"
		size = 24
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 89 11 8B 02 89 41 04 8B C1 83 22 00 5D C2 04 00 }
	condition:
		$1
}

rule file_45_33_0 {
	meta:
		name = "??1__crt_errno_guard@@QAE@XZ"
		size = 17
	strings:
		$1 = { 8B 11 83 3A 00 75 09 8B 41 04 85 C0 74 02 89 02 C3 }
	condition:
		$1
}

rule file_45_48_0 {
	meta:
		name = "__execvp"
		size = 25
		refs = "0010 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_76_0 {
	meta:
		name = "__execv"
		size = 25
		refs = "0010 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_81_0 {
	meta:
		name = "__wexecv"
		size = 25
		refs = "0010 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_54_0 {
	meta:
		name = "__wexecvp"
		size = 25
		refs = "0010 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_49_0 {
	meta:
		name = "__execvpe"
		size = 26
		refs = "0011 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_77_0 {
	meta:
		name = "__execve"
		size = 26
		refs = "0011 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_281_82_0 {
	meta:
		name = "__wexecve"
		size = 26
		refs = "0011 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_55_0 {
	meta:
		name = "__wexecvpe"
		size = 26
		refs = "0011 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_50_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 34
		refs = "001d __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 5D C3 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_atanh"
		size = 152
		refs = "000b __dtest 0045 __fperrraise 004b __Nan_C 0068 __Inf_C 0085 _log1p 008b __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 33 F6 59 2B C6 74 7B 48 83 E8 01 74 75 D9 EE DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 D9 E8 D8 D1 DF E0 F6 C4 05 7A 14 DD D9 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 43 DD E1 DF E0 F6 C4 44 7A 1A DD D9 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 85 F6 74 24 D9 E0 EB 20 D9 C1 DC C0 D9 C9 DE E2 51 51 DE F1 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 59 EB DA DD 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "_atanhl"
		size = 152
		refs = "000b __ldtest 0045 __fperrraise 004b __LNan_C 0068 __LInf_C 0085 _log1pl 008b __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 33 F6 59 2B C6 74 7B 48 83 E8 01 74 75 D9 EE DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 D9 E8 D8 D1 DF E0 F6 C4 05 7A 14 DD D9 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 43 DD E1 DF E0 F6 C4 44 7A 1A DD D9 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 85 F6 74 24 D9 E0 EB 20 D9 C1 DC C0 D9 C9 DE E2 51 51 DE F1 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 59 EB DA DD 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "___libm_sse2_expf"
		size = 343
		refs = "0015 _log2e 0044 _c1 0060 _Tl 007f _Tm 0094 _Th 0137 _INF 0140 _ZERO 0152 _ONE"
	strings:
		$1 = { F3 0F 10 C8 F3 0F 10 E0 B8 3B AA B8 46 66 0F 6E F8 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C1 0F 5A C9 81 E1 FF FF FF 7F 81 E9 00 00 80 31 81 F9 00 00 00 12 0F 83 92 00 00 00 F3 0F 59 C7 F3 0F 2D C0 66 0F 12 35 ?? ?? ?? ?? 66 0F 6E D0 8B C8 C1 E0 03 8B D1 F2 0F 59 D9 D1 F9 83 E0 78 F2 0F 59 B0 ?? ?? ?? ?? 66 0F 12 80 ?? ?? ?? ?? 81 E1 F8 00 00 00 8B C2 C1 FA 06 F3 0F E6 D2 66 0F 12 B9 ?? ?? ?? ?? C1 F8 0E 81 E2 F8 00 00 00 66 0F 6E E8 F2 0F 59 BA ?? ?? ?? ?? F2 0F 5C DA 66 0F 73 F5 34 66 0F 7E E1 8B C1 81 E1 FF FF FF 7F F2 0F 59 F3 81 F9 4F AC AE 42 77 4F 66 0F FE FD F2 0F 58 C6 F2 0F 59 C7 66 0F 5A C0 C3 81 C1 00 00 80 31 81 F9 00 00 80 31 76 76 81 F9 00 00 80 7F 73 40 66 0F 7E E2 81 FA 00 00 00 80 73 0E BA FF FF 7F 7F 66 0F 6E C2 F3 0F 59 C0 C3 BA 00 00 80 00 66 0F 6E C2 F3 0F 59 C0 C3 3D 18 72 B1 42 72 AA 66 0F FE FD F2 0F 58 F0 F2 0F 59 F7 F2 0F 5A C6 C3 81 F9 00 00 80 7F 75 1D 66 0F 7E E0 3D 00 00 80 7F 75 09 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C4 F3 0F 58 C0 C3 F3 0F 10 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "??$common_ftime_s@JU__timeb32@@@@YAHQAU__timeb32@@@Z"
		size = 330
		refs = "000c ___security_cookie 001e __errno 0028 __invalid_parameter_noinfo 0035 @__security_check_cookie@4 0040 ___tzset 0054 __get_timezone 0079 ___acrt_GetSystemTimePreciseAsFileTime@4 0092 __aulldiv 009e ?elapsed_minutes_cache@@3JA 00ad __imp__GetTimeZoneInformation@4 00e5 ?dstflag_cache@@3HA 0112 __aullrem 0145 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 75 20 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 53 57 E8 ?? ?? ?? ?? 8D 85 4C FF FF FF 33 DB 50 89 9D 4C FF FF FF E8 ?? ?? ?? ?? 59 85 C0 0F 85 DE 00 00 00 8B 85 4C FF FF FF 6A 3C 99 59 F7 F9 66 89 46 06 8D 85 44 FF FF FF 50 E8 ?? ?? ?? ?? 8B BD 48 FF FF FF 53 8B 9D 44 FF FF FF 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 89 85 40 FF FF FF 3B 05 ?? ?? ?? ?? 74 4C 8D 85 50 FF FF FF 50 FF 15 ?? ?? ?? ?? 83 C9 FF 3B C1 74 19 83 F8 02 75 12 66 83 7D EA 00 74 0B 83 7D F8 00 74 05 33 C9 41 EB 02 33 C9 8B 85 40 FF FF FF 8B BD 48 FF FF FF 8B 9D 44 FF FF FF 89 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 06 8B 0D ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 4E 08 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 66 89 46 04 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 E8 ?? ?? ?? ?? 5F 89 06 33 C0 5B E9 EF FE FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "??$common_ftime_s@_JU__timeb64@@@@YAHQAU__timeb64@@@Z"
		size = 334
		refs = "000c ___security_cookie 001e __errno 0028 __invalid_parameter_noinfo 0035 @__security_check_cookie@4 0040 ___tzset 0054 __get_timezone 0079 ___acrt_GetSystemTimePreciseAsFileTime@4 0092 __aulldiv 009e ?elapsed_minutes_cache@@3JA 00ad __imp__GetTimeZoneInformation@4 00e5 ?dstflag_cache@@3HA 0112 __aullrem 0149 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 75 20 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 53 57 E8 ?? ?? ?? ?? 8D 85 4C FF FF FF 33 DB 50 89 9D 4C FF FF FF E8 ?? ?? ?? ?? 59 85 C0 0F 85 E2 00 00 00 8B 85 4C FF FF FF 6A 3C 99 59 F7 F9 66 89 46 0A 8D 85 44 FF FF FF 50 E8 ?? ?? ?? ?? 8B BD 48 FF FF FF 53 8B 9D 44 FF FF FF 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 89 85 40 FF FF FF 3B 05 ?? ?? ?? ?? 74 4C 8D 85 50 FF FF FF 50 FF 15 ?? ?? ?? ?? 83 C9 FF 3B C1 74 19 83 F8 02 75 12 66 83 7D EA 00 74 0B 83 7D F8 00 74 05 33 C9 41 EB 02 33 C9 8B 85 40 FF FF FF 8B BD 48 FF FF FF 8B 9D 44 FF FF FF 89 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 06 8B 0D ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 4E 0C E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 66 89 46 08 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 E8 ?? ?? ?? ?? 99 5F 89 06 33 C0 89 56 04 5B E9 EB FE FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_feclearexcept"
		size = 75
		refs = "0014 __getfpstatusword 0024 ___acrt_fenv_get_fp_status_word_from_exception_mask 002e __setfpstatusword 0037 _fetestexcept"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 83 E6 1F 75 04 33 C0 EB 36 57 E8 ?? ?? ?? ?? 8B F8 85 FE 75 04 33 C0 EB 25 56 E8 ?? ?? ?? ?? F7 D0 23 F8 57 E8 ?? ?? ?? ?? 83 E7 1F 57 E8 ?? ?? ?? ?? 33 C9 83 C4 0C 3B C7 0F 95 C1 8B C1 5F 5E 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__fsqrt"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 D9 FA DD 5D F8 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_strtok"
		size = 30
		refs = "0006 ___acrt_getptd 0015 ___acrt_strtok_s_novalidation"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 C0 1C 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "___dcrt_multibyte_check_type"
		size = 105
		refs = "003e ___acrt_GetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B 75 0C 8B 56 04 83 7A 08 00 75 04 33 C0 EB 4C 8B 4D 08 8B C1 8B 52 04 83 65 F8 00 6A 01 C1 E8 08 52 88 45 FC 8D 45 F8 50 6A 02 8D 45 FC 88 4D FD 50 6A 01 56 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 CB 66 83 7D FA 00 75 C4 8B 45 F8 23 45 10 66 85 C0 0F 95 C1 33 C0 3A 4D 14 0F 94 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_5_0 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000b __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_128_15_0 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000b __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000b __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_453_5_2 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000b __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_342_5_0 {
	meta:
		name = "__ismbcblank"
		size = 19
		refs = "000b __ismbcblank_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_732_8_0 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000b __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_613_5_4 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000b __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_554_4_3 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000b __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_554_6_3 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000b __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_574_4_3 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000b __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_574_6_2 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000b __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_574_8_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000b __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_614_4_2 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000b __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_558_5_3 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000b __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_342_7_0 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000b __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_686_8_3 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000b __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_554_8_2 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000b __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_200_5_4 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000b __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_638_4_4 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000b __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_658_4_2 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000b __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_658_6_2 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000b __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_169_0_3 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000b __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_291_0_3 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000b __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_392_4_3 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000b __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_638_6_0 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000b __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_413_4_4 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000b __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_566_4_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000b __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_244_4_3 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000b __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_593_4_4 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000b __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_533_11_4 {
	meta:
		name = "__mkgmtime32"
		size = 19
		refs = "000b ??$common_mktime@J@@YAJQAUtm@@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_533_12_4 {
	meta:
		name = "__mkgmtime64"
		size = 19
		refs = "000b ??$common_mktime@_J@@YA_JQAUtm@@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_49_2 {
	meta:
		name = "__putenv"
		size = 19
		refs = "000b ??$common_putenv@D@@YAHQBD0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_51_2 {
	meta:
		name = "__wputenv"
		size = 19
		refs = "000b ??$common_putenv@_W@@YAHQB_W0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_75_122_3 {
	meta:
		name = "__wtof"
		size = 19
		refs = "000b ??$common_atof_l@_W@@YANQB_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_75_124_0 {
	meta:
		name = "_atof"
		size = 19
		refs = "000b ??$common_atof_l@D@@YANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_21_3 {
	meta:
		name = "_isleadbyte"
		size = 19
		refs = "000b __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_144_5_3 {
	meta:
		name = "_towlower"
		size = 19
		refs = "000b __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_270_5_3 {
	meta:
		name = "_towupper"
		size = 19
		refs = "000b __towupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_6_0 {
	meta:
		name = "__ismbcprint_l"
		size = 104
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 004d ___dcrt_multibyte_check_type"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 3D FF 00 00 00 77 26 0F B6 C8 BA 57 01 00 00 8B 45 F4 8B 00 66 85 14 48 75 0E 8B 45 F8 F6 44 01 19 03 75 04 33 C0 EB 16 33 C0 40 EB 11 6A 00 6A 20 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__ceil_pentium4"
		size = 221
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00bc _NegZero 00c5 _Zero"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 74 4C 3D FF 0B 00 00 7C 7D 66 0F F3 CA 3D 32 0C 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA EC 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 06 3D FF 03 00 00 7C 25 3D 32 04 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 58 C8 66 0F D6 4C 24 04 DD 44 24 04 C3 DD 05 ?? ?? ?? ?? C3 66 0F C2 1D ?? ?? ?? ?? 06 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "_wmemmove"
		size = 27
		refs = "0012 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "_wmemcpy"
		size = 27
		refs = "0012 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "_wmemmove_s"
		size = 80
		refs = "0014 __errno 001e __invalid_parameter_noinfo 0044 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 56 85 C0 74 3E 83 7D 08 00 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 27 83 7D 10 00 74 E7 39 45 0C 73 09 E8 ?? ?? ?? ?? 6A 22 EB E0 03 C0 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "_rand_s"
		size = 72
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0028 ___acrt_RtlGenRandom@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 83 20 00 6A 04 50 E8 ?? ?? ?? ?? 84 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "_fesetround"
		size = 60
		refs = "0018 __getfpcontrolword 0026 __setfpcontrolword 002c _fegetround"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 25 00 03 00 00 3B 45 08 74 05 33 C0 40 5D C3 E8 ?? ?? ?? ?? 25 FF FC FF FF 0B 45 08 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C9 3B 45 08 0F 95 C1 8B C1 5D C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_lldiv"
		size = 50
		refs = "0016 __alldvrm"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 53 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B FB 5B 8B 75 08 89 7E 0C 89 06 8B C6 5F 89 56 04 89 4E 08 5E 5B 5D C3 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "?shortsort_s@@YAXPAD0IP6AHPAXPBX2@ZQAX@Z"
		size = 153
		refs = "0007 ___security_cookie 003a ___guard_check_icall_fptr 0091 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 53 8B 5D 0C 3B D9 76 6F 8B 45 10 56 57 8D 14 01 8B F2 8B F9 3B F3 77 2B EB 03 8D 49 00 8B 4D 14 57 56 FF 75 18 FF 15 ?? ?? ?? ?? FF 55 14 83 C4 0C 85 C0 7E 02 8B FE 8B 45 10 03 F0 3B F3 76 DD 8B 4D 08 8B F0 8B D3 3B FB 74 21 85 C0 74 1D 2B FB 8A 02 8D 52 01 8A 4C 17 FF 88 44 17 FF 88 4A FF 83 EE 01 75 EB 8B 45 10 8B 4D 08 2B D8 8D 14 01 3B D9 77 9B 5F 5E 8B 4D FC 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_2_0 {
	meta:
		name = "?swap@@YAXPAD0I@Z"
		size = 57
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 57 8B 7D 08 3B F8 74 26 56 8B 75 10 85 F6 74 1D 2B F8 8D 9B 00 00 00 00 8A 08 8D 40 01 8A 54 07 FF 88 4C 07 FF 88 50 FF 83 EE 01 75 EB 5E 5F 5D C3 }
	condition:
		$1
}

rule file_63_3_0 {
	meta:
		name = "_qsort_s"
		size = 990
		refs = "000c ___security_cookie 0048 __errno 0053 __invalid_parameter_noinfo 0060 @__security_check_cookie@4 00b0 ?shortsort_s@@YAXPAD0IP6AHPAXPBX2@ZQAX@Z 00d6 ___guard_check_icall_fptr 00ec ?swap@@YAXPAD0I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 18 8B 55 0C 53 8B 5D 08 89 9D FC FE FF FF 89 8D F8 FE FF FF 56 8B 75 14 89 B5 00 FF FF FF 57 8B 7D 10 89 BD 08 FF FF FF 85 DB 75 25 85 D2 74 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 85 FF 74 DB 85 F6 74 D7 C7 85 F4 FE FF FF 00 00 00 00 83 FA 02 72 D8 4A 0F AF D7 03 D3 89 95 04 FF FF FF EB 03 8D 49 00 8B C2 33 D2 2B C3 F7 F7 8D 58 01 83 FB 08 77 1C 51 56 57 FF B5 04 FF FF FF FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 14 E9 F1 02 00 00 8B 85 FC FE FF FF D1 EB 0F AF DF 03 D8 53 50 51 8B CE 89 9D E8 FE FF FF FF 15 ?? ?? ?? ?? FF D6 83 C4 0C 85 C0 7E 10 57 53 FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 04 FF FF FF 8B CE FF B5 FC FE FF FF FF B5 F8 FE FF FF FF 15 ?? ?? ?? ?? FF D6 83 C4 0C 85 C0 7E 15 57 FF B5 04 FF FF FF FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 04 FF FF FF 8B CE 53 FF B5 F8 FE FF FF FF 15 ?? ?? ?? ?? FF D6 83 C4 0C 85 C0 7E 10 57 FF B5 04 FF FF FF 53 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 04 FF FF FF 8B F8 8B B5 FC FE FF FF 8B 95 08 FF FF FF 89 85 EC FE FF FF 3B DE 76 46 EB 07 8D A4 24 00 00 00 00 03 F2 89 B5 F0 FE FF FF 3B F3 73 2B 8B 8D 00 FF FF FF 53 56 FF B5 F8 FE FF FF FF 15 ?? ?? ?? ?? FF 95 00 FF FF FF 8B 95 08 FF FF FF 83 C4 0C 85 C0 7E CD 3B DE 77 43 8B 85 04 FF FF FF 8B BD 00 FF FF FF 03 F2 3B F0 77 25 53 56 FF B5 F8 FE FF FF 8B CF FF 15 ?? ?? ?? ?? FF D7 8B 95 08 FF FF FF 83 C4 0C 85 C0 8B 85 04 FF FF FF 7E D5 8B BD EC FE FF FF 89 B5 F0 FE FF FF 8B B5 00 FF FF FF 8B 95 08 FF FF FF 2B FA 3B FB 76 1F 53 57 FF B5 F8 FE FF FF 8B CE FF 15 ?? ?? ?? ?? FF D6 83 C4 0C 85 C0 7F DB 8B 95 08 FF FF FF 8B B5 F0 FE FF FF 89 BD EC FE FF FF 3B FE 72 5E 89 95 E0 FE FF FF 89 BD E4 FE FF FF 3B F7 74 33 8B DE 8B D7 8B B5 E0 FE FF FF 2B DF 8A 02 8D 52 01 8A 4C 13 FF 88 44 13 FF 88 4A FF 83 EE 01 75 EB 8B B5 F0 FE FF FF 8B 9D E8 FE FF FF 8B 95 08 FF FF FF 8B 85 04 FF FF FF 3B DF 0F 85 E7 FE FF FF 8B DE 89 9D E8 FE FF FF E9 DA FE FF FF 03 FA 3B DF 73 32 90 2B FA 3B FB 76 2B 8B 8D 00 FF FF FF 53 57 FF B5 F8 FE FF FF FF 15 ?? ?? ?? ?? FF 95 00 FF FF FF 8B 95 08 FF FF FF 83 C4 0C 85 C0 74 D3 3B DF 72 3E 8B B5 00 FF FF FF EB 07 8D A4 24 00 00 00 00 2B FA 3B BD FC FE FF FF 76 1F 53 57 FF B5 F8 FE FF FF 8B CE FF 15 ?? ?? ?? ?? FF D6 8B 95 08 FF FF FF 83 C4 0C 85 C0 74 D7 8B B5 F0 FE FF FF 8B 95 04 FF FF FF 8B C7 8B 9D FC FE FF FF 8B CA 2B CE 2B C3 3B C1 7C 3F 3B DF 73 18 8B 85 F4 FE FF FF 89 5C 85 84 89 BC 85 0C FF FF FF 40 89 85 F4 FE FF FF 8B BD 08 FF FF FF 3B F2 73 52 8B 8D F8 FE FF FF 8B DE 8B B5 00 FF FF FF 89 9D FC FE FF FF E9 2A FD FF FF 3B F2 73 18 8B 85 F4 FE FF FF 89 74 85 84 89 94 85 0C FF FF FF 40 89 85 F4 FE FF FF 8B B5 00 FF FF FF 3B DF 73 1B 8B 8D F8 FE FF FF 8B D7 8B BD 08 FF FF FF E9 E6 FC FF FF 8B B5 00 FF FF FF EB 06 8B BD 08 FF FF FF 8B 85 F4 FE FF FF 83 E8 01 89 85 F4 FE FF FF 0F 88 95 FC FF FF 8B 5C 85 84 8B 94 85 0C FF FF FF 8B 8D F8 FE FF FF 89 9D FC FE FF FF E9 A7 FC FF FF }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "___libm_error_support"
		size = 536
		refs = "0009 ___security_cookie 0014 __pmatherr_set 001f __pmatherr 0025 __imp__DecodePointer@4 002e ___acrt_invoke_user_matherr 0070 ??_C@_05HGHHAHAP@log10?$AA@ 009b ___guard_check_icall_fptr 00ab __errno 00cc ??_C@_03MGHMBJCF@log?$AA@ 00eb ??_C@_03KHJOGHMM@exp?$AA@ 010a ??_C@_03JGHBODFD@pow?$AA@ 0192 ??_C@_04FIHNOPOL@asin?$AA@ 019e ??_C@_04PDIFKINK@acos?$AA@ 01aa ??_C@_04EIAKFFMI@sqrt?$AA@ 0210 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? 00 56 57 74 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 EB 05 BF ?? ?? ?? ?? 8B 45 14 83 F8 1A 0F 8F 21 01 00 00 0F 84 0F 01 00 00 83 F8 0E 0F 8F A7 00 00 00 0F 84 8E 00 00 00 6A 02 59 2B C1 74 78 83 E8 01 74 6A 83 E8 05 74 56 83 E8 01 0F 85 9B 01 00 00 C7 45 E0 ?? ?? ?? ?? 8B 45 08 8B CF 8B 75 10 C7 45 DC 01 00 00 00 DD 00 8B 45 0C DD 5D E4 DD 00 8D 45 DC DD 5D EC DD 06 50 DD 5D F4 FF 15 ?? ?? ?? ?? FF D7 59 85 C0 0F 85 59 01 00 00 E8 ?? ?? ?? ?? C7 00 21 00 00 00 E9 49 01 00 00 89 4D DC C7 45 E0 ?? ?? ?? ?? E9 04 01 00 00 C7 45 E0 ?? ?? ?? ?? EB A2 89 4D DC C7 45 E0 ?? ?? ?? ?? E9 EC 00 00 00 C7 45 DC 03 00 00 00 C7 45 E0 ?? ?? ?? ?? E9 D9 00 00 00 83 E8 0F 74 51 83 E8 09 74 43 83 E8 01 0F 85 01 01 00 00 C7 45 E0 ?? ?? ?? ?? 8B 45 08 8B CF 8B 75 10 C7 45 DC 04 00 00 00 DD 00 8B 45 0C DD 5D E4 DD 00 8D 45 DC DD 5D EC DD 06 50 DD 5D F4 FF 15 ?? ?? ?? ?? FF D7 59 E9 C2 00 00 00 C7 45 DC 03 00 00 00 EB 7C C7 45 E0 ?? ?? ?? ?? EB BB D9 E8 8B 45 10 DD 18 E9 A9 00 00 00 83 E8 1B 74 5B 83 E8 01 74 4A 83 E8 15 74 39 83 E8 09 74 28 83 E8 03 74 17 2D AB 03 00 00 74 09 83 E8 01 0F 85 80 00 00 00 8B 45 08 DD 00 EB C6 C7 45 E0 ?? ?? ?? ?? E9 D9 FE FF FF C7 45 E0 ?? ?? ?? ?? E9 CD FE FF FF C7 45 E0 ?? ?? ?? ?? E9 C1 FE FF FF C7 45 E0 ?? ?? ?? ?? E9 B5 FE FF FF C7 45 DC 02 00 00 00 C7 45 E0 ?? ?? ?? ?? 8B 45 08 8B CF 8B 75 10 DD 00 8B 45 0C DD 5D E4 DD 00 8D 45 DC DD 5D EC DD 06 50 DD 5D F4 FF 15 ?? ?? ?? ?? FF D7 59 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 DD 45 F4 DD 1E 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "___libm_setusermatherr"
		size = 46
		refs = "000d __pmatherr_set 0019 __imp__EncodePointer@4 001e __pmatherr"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 09 83 25 ?? ?? ?? ?? 00 5D C3 FF 75 08 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "__memicmp"
		size = 98
		refs = "0007 ___acrt_locale_changed_data 001c __errno 0027 __invalid_parameter_noinfo 0044 ___ascii_memicmp 0059 __memicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 3F 83 7D 08 00 8B 45 10 75 1B 85 C0 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 83 7D 0C 00 75 04 85 C0 75 DF 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "__memicmp_l"
		size = 176
		refs = "0017 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0032 __errno 003d __invalid_parameter_noinfo 0057 ___ascii_memicmp 0076 __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 4D EC 53 8B 5D 0C 56 57 FF 75 14 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 8B 7D 10 85 C9 75 04 85 FF 75 08 85 DB 75 1B 85 FF 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BE FF FF FF 7F EB 4F 8B 45 F0 39 B0 A8 00 00 00 75 0F 57 53 51 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 35 8B C6 85 FF 74 2D 4F 3B F0 75 28 0F B6 01 8D 4D F0 51 50 E8 ?? ?? ?? ?? FF 45 08 8D 4D F0 8B F0 0F B6 03 51 50 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 10 43 EB CF 2B F0 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_15_0 {
	meta:
		name = "____lc_codepage_func"
		size = 39
		refs = "0007 ___acrt_getptd 0017 ___acrt_update_locale_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 48 4C 89 4D FC 8D 4D FC 51 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 8B 40 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_16_0 {
	meta:
		name = "____lc_collate_cp_func"
		size = 39
		refs = "0007 ___acrt_getptd 0017 ___acrt_update_locale_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 48 4C 89 4D FC 8D 4D FC 51 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 8B 40 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_17_0 {
	meta:
		name = "____lc_locale_name_func"
		size = 41
		refs = "0007 ___acrt_getptd 0017 ___acrt_update_locale_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 48 4C 89 4D FC 8D 4D FC 51 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 05 A0 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_18_0 {
	meta:
		name = "____mb_cur_max_func"
		size = 39
		refs = "0007 ___acrt_getptd 0017 ___acrt_update_locale_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 48 4C 89 4D FC 8D 4D FC 51 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 8B 40 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_19_0 {
	meta:
		name = "____mb_cur_max_l_func"
		size = 25
		refs = "000e ____mb_cur_max_func"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 06 5D E9 ?? ?? ?? ?? 8B 00 8B 40 04 5D C3 }
	condition:
		$1
}

rule file_66_20_0 {
	meta:
		name = "___acrt_locale_initialize_ctype"
		size = 926
		refs = "0009 ___security_cookie 0054 ___acrt_GetLocaleInfoA 0068 __calloc_base 0071 __free_base 0109 __imp__GetCPInfo@8 014c ___acrt_LCMapStringA 01da ___acrt_GetStringTypeA 036e ___newctype 0378 ___newclmap 0382 ___newcumap 0396 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 89 75 CC 89 5D E4 8B 8E A8 00 00 00 89 5D E0 89 5D DC 89 5D D0 89 75 B8 89 5D BC 85 C9 0F 84 14 03 00 00 8D 46 08 89 5D D8 39 18 75 1C 50 68 04 10 00 00 51 8D 45 B8 53 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 BB 02 00 00 6A 04 6A 01 E8 ?? ?? ?? ?? 53 89 45 D8 E8 ?? ?? ?? ?? 6A 02 BF 80 01 00 00 57 E8 ?? ?? ?? ?? 53 89 45 E4 E8 ?? ?? ?? ?? 6A 01 57 E8 ?? ?? ?? ?? 53 89 45 E0 E8 ?? ?? ?? ?? 6A 01 57 E8 ?? ?? ?? ?? 53 89 45 DC E8 ?? ?? ?? ?? 6A 01 68 01 01 00 00 E8 ?? ?? ?? ?? 8B F8 53 89 7D D0 E8 ?? ?? ?? ?? 83 C4 3C 39 5D D8 0F 84 4E 02 00 00 39 5D E4 0F 84 45 02 00 00 85 FF 0F 84 3D 02 00 00 39 5D E0 0F 84 34 02 00 00 39 5D DC 0F 84 2B 02 00 00 8B C3 88 04 38 40 3D 00 01 00 00 7C F5 8D 45 E8 50 FF 76 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 09 02 00 00 8B 45 E8 83 F8 05 0F 87 FD 01 00 00 53 FF 76 08 0F B7 C0 8D 4F 01 89 45 D4 BA FF 00 00 00 8B 45 E0 52 05 81 00 00 00 50 52 51 68 00 01 00 00 FF B6 A8 00 00 00 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 C3 01 00 00 8B 45 DC B9 FF 00 00 00 53 FF 76 08 05 81 00 00 00 51 50 51 8D 47 01 50 68 00 02 00 00 FF B6 A8 00 00 00 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 8F 01 00 00 83 7D D4 01 7E 2B 38 5D EE 74 26 8D 4D EF 8A 01 84 C0 74 1D 0F B6 51 FF 0F B6 C0 EB 08 C6 04 3A 20 42 0F B6 01 3B D0 7E F4 83 C1 02 38 59 FF 75 DD 8B 45 E4 53 FF 76 08 05 00 01 00 00 50 68 00 01 00 00 57 6A 01 53 89 45 C8 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 84 35 01 00 00 8B 55 E4 33 C9 8D 82 FE 00 00 00 66 89 08 8B 4D E0 89 45 E4 8B 45 DC 88 59 7F 83 E9 80 83 7D D4 01 88 58 7F 89 4D C4 88 19 8D 88 80 00 00 00 89 4D C0 88 19 7E 40 38 5D EE 74 3B 8D 4D EF 8A 01 84 C0 74 2F 0F B6 71 FF 0F B6 C0 3B F0 7F 1C 8D BA 00 01 00 00 8D 3C 77 B8 00 80 00 00 46 66 89 07 8D 7F 02 0F B6 01 3B F0 7E ED 83 C1 02 38 59 FF 75 CB 8B 45 DC 6A 3F 59 8D B2 00 02 00 00 8B FA F3 A5 8B 55 E0 6A 1F 59 66 A5 8D B2 00 01 00 00 8B FA F3 A5 6A 1F 59 66 A5 A4 8D B0 00 01 00 00 8B F8 F3 A5 66 A5 A4 8B 75 CC 8B 8E 8C 00 00 00 85 C9 74 49 83 C8 FF F0 0F C1 01 75 40 8B 86 90 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 94 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 98 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 8C 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 45 D8 C7 00 01 00 00 00 89 86 8C 00 00 00 8B 45 C8 89 06 8B 45 E4 89 86 90 00 00 00 8B 45 C4 89 86 94 00 00 00 8B 45 C0 89 86 98 00 00 00 8B 45 D4 89 46 04 EB 26 FF 75 D8 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 DC E8 ?? ?? ?? ?? 33 DB 83 C4 10 43 FF 75 D0 E8 ?? ?? ?? ?? 59 8B C3 EB 3C 8B 86 8C 00 00 00 85 C0 74 03 F0 FF 08 89 9E 8C 00 00 00 33 C0 89 9E 90 00 00 00 C7 06 ?? ?? ?? ?? C7 86 94 00 00 00 ?? ?? ?? ?? C7 86 98 00 00 00 ?? ?? ?? ?? C7 46 04 01 00 00 00 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__strrev"
		size = 53
	strings:
		$1 = { 55 8B EC 57 56 8B 7D 08 8B D7 8B F7 33 C0 83 C9 FF F2 AE 83 F9 FE 74 17 83 EF 02 3B F7 73 10 8A 26 8A 07 88 06 88 27 83 C6 01 83 EF 01 EB EC 8B C2 5E 5F C9 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__cgetws"
		size = 94
		refs = "000f ___doserrno 0017 __errno 0022 __invalid_parameter_noinfo 0041 __cgetws_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 57 8B 7D 08 85 FF 75 1C E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 2F 0F B7 07 66 85 C0 74 DC 83 65 FC 00 8D 4D FC 56 51 50 8D 77 04 56 E8 ?? ?? ?? ?? 66 8B 4D FC 83 C4 0C F7 D8 66 89 4F 02 1B C0 F7 D0 23 C6 5E 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "__cgetws_s"
		size = 420
		refs = "0003 __sehtable$__cgetws_s 0008 __SEH_prolog4 001b ___doserrno 0023 __errno 002d __invalid_parameter_noinfo 0057 ___acrt_lock 007a ___console_wchar_buffer_used 0082 ___console_wchar_buffer 00b6 ___dcrt_lowio_console_input_handle 00c0 ___dcrt_lowio_initialize_console_input 00d0 __imp__GetLastError@0 00d6 ___acrt_errno_map_os_error 00f1 __imp__GetConsoleMode@8 00ff __imp__SetConsoleMode@8 0114 __imp__ReadConsoleW@20 0193 __SEH_epilog4 019e ___acrt_unlock"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 1E E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 5A 01 00 00 33 C0 3B 45 0C 1B C0 F7 D8 74 D7 33 C0 66 89 06 8B 5D 10 85 DB 0F 95 C0 85 C0 74 C6 6A 09 E8 ?? ?? ?? ?? 59 33 FF 89 7D E0 89 7D FC 89 75 D8 8B 4D 0C 83 E9 01 89 4D E4 89 3B 0F 84 0C 01 00 00 39 3D ?? ?? ?? ?? 74 2D 66 A1 ?? ?? ?? ?? 66 89 06 83 C6 02 89 75 D8 49 89 4D E4 FF 03 0F B7 05 ?? ?? ?? ?? F7 D8 1B C0 23 C8 89 4D E4 33 C0 66 A3 ?? ?? ?? ?? 85 C9 0F 84 CF 00 00 00 A1 ?? ?? ?? ?? 83 F8 FE 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 38 89 7D E0 E9 9A 00 00 00 8D 4D D4 51 50 FF 15 ?? ?? ?? ?? 6A 07 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 57 8D 45 DC 50 FF 75 E4 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 B2 8B 4D DC 6A 0D 58 83 F9 02 72 15 66 39 44 4E FC 75 0E 8D 41 FE 01 03 33 C0 66 89 44 4E FC EB 39 3B 4D E4 75 16 66 39 44 4E FE 75 0F 33 C0 66 89 44 4E FE 8B 45 DC 48 01 03 EB 1E 83 F9 01 75 11 66 83 3E 0A 75 0B 33 C0 66 89 06 8B 03 89 03 EB 08 01 0B 33 C0 66 89 04 4E FF 75 D4 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E0 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_70_2_0 {
	meta:
		name = "__CIacos_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 004a ___fastflag 0051 __fast_exit 005c _NAME_ 0061 __math_exit 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "___acrt_errno_from_os_error"
		size = 67
		refs = "000d ?errtable@@3QBUerrentry@?A0x31fdb9ec@@B"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 33 C0 3B 0C C5 ?? ?? ?? ?? 74 27 40 83 F8 2C 72 F1 8D 41 ED 83 F8 11 77 05 6A 0D 58 5D C3 8D 81 44 FF FF FF 6A 0E 59 3B C8 1B C0 23 C1 83 C0 08 5D C3 8B 04 C5 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "___acrt_errno_map_os_error"
		size = 35
		refs = "0007 ___doserrno 0012 ___acrt_errno_from_os_error 001a __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 4D 08 51 89 08 E8 ?? ?? ?? ?? 59 8B F0 E8 ?? ?? ?? ?? 89 30 5E 5D C3 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "___doserrno"
		size = 19
		refs = "0001 ___acrt_getptd_noexit 000a ?doserrno_no_memory@@3KA"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 06 B8 ?? ?? ?? ?? C3 83 C0 14 C3 }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "__errno"
		size = 19
		refs = "0001 ___acrt_getptd_noexit 000a ?errno_no_memory@@3HA"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 06 B8 ?? ?? ?? ?? C3 83 C0 10 C3 }
	condition:
		$1
}

rule file_71_4_0 {
	meta:
		name = "__get_doserrno"
		size = 37
		refs = "000e __invalid_parameter_noinfo 0018 ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 0A E8 ?? ?? ?? ?? 6A 16 58 EB 0B E8 ?? ?? ?? ?? 8B 00 89 06 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_71_5_0 {
	meta:
		name = "__get_errno"
		size = 37
		refs = "000e __invalid_parameter_noinfo 0018 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 0A E8 ?? ?? ?? ?? 6A 16 58 EB 0B E8 ?? ?? ?? ?? 8B 00 89 06 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_71_6_0 {
	meta:
		name = "__set_doserrno"
		size = 33
		refs = "0006 ___acrt_getptd_noexit 0014 ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 85 C0 75 05 6A 0C 58 5D C3 E8 ?? ?? ?? ?? 8B 4D 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_71_7_0 {
	meta:
		name = "__set_errno"
		size = 33
		refs = "0006 ___acrt_getptd_noexit 0014 __errno"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 85 C0 75 05 6A 0C 58 5D C3 E8 ?? ?? ?? ?? 8B 4D 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__trandisp1"
		size = 103
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 9B 8A 8D 61 FF FF FF D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "__trandisp2"
		size = 397
		refs = "0029 XAMtoTagTab 00de One 0152 __indefinite 016f __piby4 017f Three"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 D9 C9 8A 8D 61 FF FF FF D9 E5 9B DD BD 60 FF FF FF D9 C9 8A AD 61 FF FF FF D0 E5 D0 FD D0 C5 8A C5 24 0F D7 8A E0 D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 D0 E4 D0 E4 0A C4 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 E8 CE 00 00 00 D9 C9 DD D8 C3 E8 C4 00 00 00 EB F6 DD D8 DD D8 D9 EE C3 DD D8 DD D8 D9 EE 84 ED 74 02 D9 E0 C3 DD D8 DD D8 D9 E8 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 08 C6 85 70 FF FF FF 00 C3 C6 85 70 FF FF FF 00 DC 05 ?? ?? ?? ?? C3 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 00 EB 07 C6 85 70 FF FF FF 00 DE C1 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 20 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 00 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DD D8 DD D8 DB 2D ?? ?? ?? ?? 80 BD 70 FF FF FF 00 7F 07 C6 85 70 FF FF FF 01 0A C9 C3 DD D8 DD D8 DB 2D ?? ?? ?? ?? 0A ED 74 02 D9 E0 0A C9 74 08 DD 05 ?? ?? ?? ?? DE C9 C3 0A C9 74 02 D9 E0 C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "??$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z"
		size = 562
		refs = "001f __commode 00cd ?__acrt_stdio_parse_mode_D@@YA_NAAU__acrt_stdio_stream_mode@@@Z 00e2 ?__acrt_stdio_parse_mode_plus@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 011b ?__acrt_stdio_parse_mode_t@@YA_NAAU__acrt_stdio_stream_mode@@@Z 0127 ?__acrt_stdio_parse_mode_n@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 0133 ?__acrt_stdio_parse_mode_c@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 013b ?__acrt_stdio_parse_mode_b@@YA_NAAU__acrt_stdio_stream_mode@@@Z 0143 ?__acrt_stdio_parse_mode_T@@YA_NAAU__acrt_stdio_stream_mode@@@Z 0189 ?ccs@?1???$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z@4QBDB 018f _strncmp 01b4 ?utf8_encoding@?1???$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z@4QBDB 01ba __strnicmp 01d3 ?utf16_encoding@?1???$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z@4QBDB 01f2 ?unicode_encoding@?1???$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z@4QBDB 021a __errno 0225 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 53 8B 5D 08 56 57 8D 7D F0 AB 8D 75 F0 AB AB 8B FB A5 A5 A5 A1 ?? ?? ?? ?? 8B 75 0C 89 43 04 EB 01 46 80 3E 20 74 FA 8A 06 33 C9 3C 61 74 1F 3C 72 74 10 3C 77 0F 85 D4 01 00 00 C7 03 01 03 00 00 EB 11 89 0B C7 43 04 01 00 00 00 EB 0D C7 03 09 01 00 00 C7 43 04 02 00 00 00 8A D1 88 4D FD 8A E9 88 4D FC 46 88 55 FE 88 6D FF B1 01 8A 06 84 C0 0F 84 E1 00 00 00 0F BE C0 83 F8 53 7F 72 74 5D 83 E8 20 0F 84 B8 00 00 00 83 E8 0B 74 42 83 E8 01 74 34 83 E8 18 74 27 83 E8 0A 74 15 83 E8 04 0F 85 67 01 00 00 8A 6D FF 84 D2 75 1F 83 0B 10 EB 35 81 0B 80 00 00 00 B1 01 E9 82 00 00 00 53 E8 ?? ?? ?? ?? EB 74 B5 01 88 6D FF 32 C9 EB 74 8D 45 FC 50 53 E8 ?? ?? ?? ?? 59 EB 5E 8A 6D FF 84 D2 75 E8 83 0B 20 B2 01 88 55 FE 8A CA EB 54 83 E8 54 74 40 83 E8 0E 74 33 83 E8 01 74 22 83 E8 0B 74 11 83 E8 06 0F 85 00 01 00 00 53 E8 ?? ?? ?? ?? EB 26 8D 45 FD 50 53 E8 ?? ?? ?? ?? EB B9 8D 45 FD 50 53 E8 ?? ?? ?? ?? EB AD 53 E8 ?? ?? ?? ?? EB 06 53 E8 ?? ?? ?? ?? 8A 55 FE 59 8A C8 8A 6D FF 33 C0 84 C9 0F 95 C0 03 F0 84 C9 0F 85 17 FF FF FF EB 03 8A 6D FF 84 ED 74 01 46 80 3E 20 74 FA 84 ED 75 12 80 3E 00 0F 85 9C 00 00 00 C6 43 08 01 E9 A3 00 00 00 6A 03 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 7F 6A 20 83 C6 03 58 EB 01 46 38 06 74 FB 80 3E 3D 75 6D 46 38 06 74 FB 6A 05 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 05 81 0B 00 00 04 00 EB 3F 6A 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 08 81 0B 00 00 02 00 EB 20 6A 07 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 16 83 C6 07 81 0B 00 00 01 00 EB 01 46 80 3E 20 74 FA E9 5B FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "??$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z"
		size = 580
		refs = "0024 __commode 00d1 ?__acrt_stdio_parse_mode_D@@YA_NAAU__acrt_stdio_stream_mode@@@Z 00e6 ?__acrt_stdio_parse_mode_plus@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 011e ?__acrt_stdio_parse_mode_t@@YA_NAAU__acrt_stdio_stream_mode@@@Z 012a ?__acrt_stdio_parse_mode_n@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 0136 ?__acrt_stdio_parse_mode_c@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z 013e ?__acrt_stdio_parse_mode_b@@YA_NAAU__acrt_stdio_stream_mode@@@Z 0146 ?__acrt_stdio_parse_mode_T@@YA_NAAU__acrt_stdio_stream_mode@@@Z 0191 ?ccs@?1???$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z@4QB_WB 0197 _wcsncmp 01c4 ?utf8_encoding@?1???$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z@4QB_WB 01ca __wcsnicmp 01e3 ?utf16_encoding@?1???$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z@4QB_WB 0202 ?unicode_encoding@?1???$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z@4QB_WB 022c __errno 0237 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 53 8B 5D 08 56 57 8D 7D F0 AB 8D 75 F0 6A 02 59 6A 20 AB AB 8B FB A5 A5 A5 A1 ?? ?? ?? ?? 8B 75 0C 89 43 04 5F EB 02 03 F1 66 39 3E 74 F9 0F B7 06 33 D2 83 F8 61 74 21 83 F8 72 74 11 83 F8 77 0F 85 DB 01 00 00 C7 03 01 03 00 00 EB 11 89 13 C7 43 04 01 00 00 00 EB 09 C7 03 09 01 00 00 89 4B 04 03 F1 88 55 FD 32 ED 88 55 FC 88 55 FE B1 01 88 6D FF 0F B7 06 66 85 C0 0F 84 DD 00 00 00 83 F8 53 7F 70 74 5C 2B C7 0F 84 B7 00 00 00 83 E8 0B 74 42 83 E8 01 74 34 83 E8 18 74 27 83 E8 0A 74 15 83 E8 04 0F 85 75 01 00 00 8A 6D FF 84 D2 75 1F 83 0B 10 EB 34 81 0B 80 00 00 00 B1 01 E9 81 00 00 00 53 E8 ?? ?? ?? ?? EB 73 B5 01 88 6D FF 32 C9 EB 73 8D 45 FC 50 53 E8 ?? ?? ?? ?? 59 EB 5D 8A 6D FF 84 D2 75 E8 09 3B B2 01 88 55 FE 8A CA EB 54 83 E8 54 74 40 83 E8 0E 74 33 83 E8 01 74 22 83 E8 0B 74 11 83 E8 06 0F 85 0F 01 00 00 53 E8 ?? ?? ?? ?? EB 26 8D 45 FD 50 53 E8 ?? ?? ?? ?? EB BA 8D 45 FD 50 53 E8 ?? ?? ?? ?? EB AE 53 E8 ?? ?? ?? ?? EB 06 53 E8 ?? ?? ?? ?? 8A 55 FE 59 8A C8 8A 6D FF 33 C0 84 C9 0F 95 C0 8D 34 46 84 C9 0F 85 19 FF FF FF EB 03 8A 6D FF 84 ED 74 03 83 C6 02 66 39 3E 74 F8 84 ED 75 14 33 C0 66 39 06 0F 85 A6 00 00 00 C6 43 08 01 E9 AD 00 00 00 6A 03 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 85 00 00 00 83 C6 06 EB 03 83 C6 02 66 39 3E 74 F8 66 83 3E 3D 75 72 83 C6 02 66 39 3E 74 F8 6A 05 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 0A 81 0B 00 00 04 00 EB 41 6A 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 10 81 0B 00 00 02 00 EB 22 6A 07 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 18 83 C6 0E 81 0B 00 00 01 00 EB 03 83 C6 02 66 39 3E 74 F8 E9 4F FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "??$common_fdopen@D@@YAPAU_iobuf@@HQBD@Z"
		size = 248
		refs = "0003 __sehtable$??$common_fdopen@D@@YAPAU_iobuf@@HQBD@Z 0008 __SEH_prolog4 0019 __errno 004a __nhandle 0064 ___pioinfo 007a ??$__acrt_stdio_parse_mode@D@@YA?AU__acrt_stdio_stream_mode@@QBD@Z 0093 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 00b2 __cflush 00da __unlock_file 00ec __invalid_parameter_noinfo 00f3 __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 0C 0F 95 C0 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 C3 00 00 00 8B 5D 08 83 FB FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 B0 00 00 00 85 DB 0F 88 98 00 00 00 3B 1D ?? ?? ?? ?? 0F 83 8C 00 00 00 8B D3 C1 FA 06 8B C3 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 0F B6 44 08 28 83 E0 01 74 6E FF 75 0C 8D 45 CC 50 E8 ?? ?? ?? ?? 59 59 8B F0 8D 7D D8 A5 A5 A5 80 7D E0 00 74 62 8D 45 E4 50 E8 ?? ?? ?? ?? 59 8B 45 E4 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB 44 83 65 FC 00 FF 05 ?? ?? ?? ?? 8B 4D DC 83 C0 0C F0 09 08 8B 45 E4 89 58 10 C7 45 FC FE FF FF FF E8 05 00 00 00 8B 45 E4 EB 1C FF 75 E4 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_73_3_0 {
	meta:
		name = "??$common_fdopen@_W@@YAPAU_iobuf@@HQB_W@Z"
		size = 248
		refs = "0003 __sehtable$??$common_fdopen@_W@@YAPAU_iobuf@@HQB_W@Z 0008 __SEH_prolog4 0019 __errno 004a __nhandle 0064 ___pioinfo 007a ??$__acrt_stdio_parse_mode@_W@@YA?AU__acrt_stdio_stream_mode@@QB_W@Z 0093 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 00b2 __cflush 00da __unlock_file 00ec __invalid_parameter_noinfo 00f3 __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 0C 0F 95 C0 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 C3 00 00 00 8B 5D 08 83 FB FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 B0 00 00 00 85 DB 0F 88 98 00 00 00 3B 1D ?? ?? ?? ?? 0F 83 8C 00 00 00 8B D3 C1 FA 06 8B C3 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 0F B6 44 08 28 83 E0 01 74 6E FF 75 0C 8D 45 CC 50 E8 ?? ?? ?? ?? 59 59 8B F0 8D 7D D8 A5 A5 A5 80 7D E0 00 74 62 8D 45 E4 50 E8 ?? ?? ?? ?? 59 8B 45 E4 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB 44 83 65 FC 00 FF 05 ?? ?? ?? ?? 8B 4D DC 83 C0 0C F0 09 08 8B 45 E4 89 58 10 C7 45 FC FE FF FF FF E8 05 00 00 00 8B 45 E4 EB 1C FF 75 E4 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_73_4_0 {
	meta:
		name = "??$tcsncmp@AAPBDAAY02$$CBDI@?$__crt_char_traits@D@@SAHAAPBDAAY02$$CBD$$QAI@Z"
		size = 28
		refs = "0013 _strncmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_5_0 {
	meta:
		name = "??$tcsncmp@AAPB_WAAY02$$CB_WI@?$__crt_char_traits@_W@@SAHAAPB_WAAY02$$CB_W$$QAI@Z"
		size = 28
		refs = "0013 _wcsncmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_6_0 {
	meta:
		name = "??$tcsnicmp@AAPBDAAY04$$CBDI@?$__crt_char_traits@D@@SAHAAPBDAAY04$$CBD$$QAI@Z"
		size = 28
		refs = "0013 __strnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_390_7_4 {
	meta:
		name = "??$tcsnicmp@AAPBDAAY06$$CBDI@?$__crt_char_traits@D@@SAHAAPBDAAY06$$CBD$$QAI@Z"
		size = 28
		refs = "0013 __strnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_390_8_0 {
	meta:
		name = "??$tcsnicmp@AAPBDAAY07$$CBDI@?$__crt_char_traits@D@@SAHAAPBDAAY07$$CBD$$QAI@Z"
		size = 28
		refs = "0013 __strnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_390_9_0 {
	meta:
		name = "??$tcsnicmp@AAPB_WAAY04$$CB_WI@?$__crt_char_traits@_W@@SAHAAPB_WAAY04$$CB_W$$QAI@Z"
		size = 28
		refs = "0013 __wcsnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_390_10_3 {
	meta:
		name = "??$tcsnicmp@AAPB_WAAY06$$CB_WI@?$__crt_char_traits@_W@@SAHAAPB_WAAY06$$CB_W$$QAI@Z"
		size = 28
		refs = "0013 __wcsnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_11_4 {
	meta:
		name = "??$tcsnicmp@AAPB_WAAY07$$CB_WI@?$__crt_char_traits@_W@@SAHAAPB_WAAY07$$CB_W$$QAI@Z"
		size = 28
		refs = "0013 __wcsnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_32_0 {
	meta:
		name = "??$tcsnicmp@ABQBDAAY0L@$$CBDI@?$__crt_char_traits@D@@SAHABQBDAAY0L@$$CBD$$QAI@Z"
		size = 28
		refs = "0013 __strnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_348_33_3 {
	meta:
		name = "??$tcsnicmp@ABQB_WAAY0L@$$CB_WI@?$__crt_char_traits@_W@@SAHABQB_WAAY0L@$$CB_W$$QAI@Z"
		size = 28
		refs = "0013 __wcsnicmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_13_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_D@@YA_NAAU__acrt_stdio_stream_mode@@@Z"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B 01 A8 40 74 04 32 C0 5D C3 83 C8 40 89 01 B0 01 5D C3 }
	condition:
		$1
}

rule file_73_14_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_N@@YA_NAAU__acrt_stdio_stream_mode@@@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 81 08 80 00 00 00 B0 01 5D C3 }
	condition:
		$1
}

rule file_73_15_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_R@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 80 38 00 74 04 32 C0 5D C3 8B 4D 08 C6 00 01 B0 01 83 09 10 5D C3 }
	condition:
		$1
}

rule file_73_16_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_S@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z"
		size = 30
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 80 38 00 74 04 32 C0 5D C3 8B 4D 08 C6 00 01 B0 01 83 09 20 5D C3 }
	condition:
		$1
}

rule file_73_17_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_T@@YA_NAAU__acrt_stdio_stream_mode@@@Z"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 BA 00 10 00 00 8B 01 85 C2 74 04 32 C0 5D C3 0B C2 89 01 B0 01 5D C3 }
	condition:
		$1
}

rule file_73_18_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_b@@YA_NAAU__acrt_stdio_stream_mode@@@Z"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B 01 A9 00 C0 00 00 74 04 32 C0 5D C3 0D 00 80 00 00 89 01 B0 01 5D C3 }
	condition:
		$1
}

rule file_73_19_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_c@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 80 38 00 74 04 32 C0 5D C3 8B 4D 08 C6 00 01 B0 01 81 49 04 00 08 00 00 5D C3 }
	condition:
		$1
}

rule file_73_20_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_n@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 80 38 00 74 04 32 C0 5D C3 8B 4D 08 C6 00 01 B0 01 81 61 04 FF F7 FF FF 5D C3 }
	condition:
		$1
}

rule file_73_21_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_plus@@YA_NAAU__acrt_stdio_stream_mode@@AA_N@Z"
		size = 53
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 80 38 00 74 04 32 C0 5D C3 8B 55 08 C6 00 01 8B 02 A8 02 75 F0 8B 4A 04 83 E0 FE 83 C8 02 83 E1 FC 83 C9 04 89 02 89 4A 04 B0 01 5D C3 }
	condition:
		$1
}

rule file_73_22_0 {
	meta:
		name = "?__acrt_stdio_parse_mode_t@@YA_NAAU__acrt_stdio_stream_mode@@@Z"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B 01 A9 00 C0 00 00 74 04 32 C0 5D C3 0D 00 40 00 00 89 01 B0 01 5D C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "___dcrt_lowio_initialize_console_output"
		size = 31
		refs = "000f ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 0015 __imp__CreateFileW@28 001a ___dcrt_lowio_console_output_handle"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 40 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_75_12_0 {
	meta:
		name = "??$common_atodbl_l@MD@@YAHQAMQBDQAU__crt_locale_pointers@@@Z"
		size = 122
		refs = "0010 __errno 001b __invalid_parameter_noinfo 002b ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 003e ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 004a ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAM@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 08 00 56 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 51 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? FF 75 08 33 F6 51 51 8B C4 56 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 48 83 E8 01 74 09 83 E8 01 75 07 6A 03 EB 02 6A 04 5E 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_13_0 {
	meta:
		name = "??$common_atodbl_l@ND@@YAHQANQBDQAU__crt_locale_pointers@@@Z"
		size = 122
		refs = "0010 __errno 001b __invalid_parameter_noinfo 002b ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 003e ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 004a ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 08 00 56 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 51 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? FF 75 08 33 F6 51 51 8B C4 56 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 48 83 E8 01 74 09 83 E8 01 75 07 6A 03 EB 02 6A 04 5E 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_14_0 {
	meta:
		name = "??$common_atof_l@D@@YANQBDQAU__crt_locale_pointers@@@Z"
		size = 107
		refs = "000f __errno 001a __invalid_parameter_noinfo 0029 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0041 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 004d ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 7D 08 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? D9 EE EB 45 FF 75 0C 8D 4D E4 E8 ?? ?? ?? ?? D9 EE 8D 45 F4 50 51 51 8B C4 6A 00 FF 75 08 DD 5D F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 E8 50 E8 ?? ?? ?? ?? DD 45 F4 83 C4 10 80 7D F0 00 74 0A 8B 45 E4 83 A0 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_15_0 {
	meta:
		name = "??$common_atof_l@_W@@YANQB_WQAU__crt_locale_pointers@@@Z"
		size = 107
		refs = "000f __errno 001a __invalid_parameter_noinfo 0029 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0041 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 004d ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QAN@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 7D 08 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? D9 EE EB 45 FF 75 0C 8D 4D E4 E8 ?? ?? ?? ?? D9 EE 8D 45 F4 50 51 51 8B C4 6A 00 FF 75 08 DD 5D F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 E8 50 E8 ?? ?? ?? ?? DD 45 F4 83 C4 10 80 7D F0 00 74 0A 8B 45 E4 83 A0 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_20_0 {
	meta:
		name = "??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z"
		size = 27
		altNames = "??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 10 8B 55 0C 89 10 89 48 04 85 C9 74 02 89 11 5D C3 }
	condition:
		$1
}

rule file_75_22_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAM@Z"
		size = 118
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 006e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 14 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 5E 85 D2 74 05 8B 4D 0C 89 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_455_23_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAN@Z"
		size = 118
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 006e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 14 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 5E 85 D2 74 05 8B 4D 0C 89 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_349_5_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAU_LDBL12@@@Z"
		size = 118
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAU_LDBL12@@@Z 006e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 14 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 5E 85 D2 74 05 8B 4D 0C 89 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_455_24_4 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QAM@Z"
		size = 118
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@_W@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 006e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 14 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 5E 85 D2 74 05 8B 4D 0C 89 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_455_25_4 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QAN@Z"
		size = 118
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 0046 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@_W@0@AAUfloating_point_string@0@@Z 0054 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 006e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 10 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 14 85 F6 74 04 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 40 EB 22 8D 8D F0 FC FF FF 51 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 56 8D 8D F0 FC FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 5E 85 D2 74 05 8B 4D 0C 89 0A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_25_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z"
		size = 989
		refs = "000f ?validate@?$c_string_character_source@D@__crt_strtox@@QBE_NXZ 0042 __ischartype_l 00bf ?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z 03c2 ??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z 03cf ??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 56 8B 75 0C 8B CE E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 B9 03 00 00 53 8B 5D 08 57 8B 3E 89 7D F0 8A 0F 8D 47 01 EB 05 8B 06 8A 08 40 53 89 06 0F B6 C1 6A 08 50 88 4D FB E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E3 8A 4D FB 8B 5D 10 80 F9 2D 0F 94 C0 8D 93 08 03 00 00 89 55 EC 88 02 80 F9 2D 74 05 80 F9 2B 75 0A 8B 06 8A 08 40 88 4D FB 89 06 80 F9 49 0F 84 47 03 00 00 80 F9 69 0F 84 3E 03 00 00 80 F9 4E 0F 84 28 03 00 00 80 F9 6E 0F 84 1F 03 00 00 C6 45 FF 00 80 F9 30 75 36 8B 16 8A 02 8D 7A 01 88 45 E8 89 3E 3C 78 74 13 3C 58 74 0F FF 75 E8 8B CE E8 ?? ?? ?? ?? 8A 4D FB EB 13 8A 0F 8D 47 01 8B FA C6 45 FF 01 88 4D FB 89 06 89 7D F0 83 65 F4 00 8D 43 08 32 ED 89 45 E8 8B D8 80 F9 30 75 11 FE C5 8B 06 8A 08 40 88 4D FB 89 06 80 F9 30 74 F1 8B 7D F4 33 D2 38 55 FF 0F 94 C2 4A 83 E2 06 83 C2 09 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C2 77 17 B5 01 3B 5D EC 74 03 88 03 43 8B 06 47 8A 08 40 88 4D FB 89 06 EB B2 8B 45 08 89 7D F4 8B 7D F0 8B 00 8B 80 88 00 00 00 8B 00 3A 08 75 73 8B 06 8A 08 40 88 4D FB 89 06 3B 5D E8 75 17 80 F9 30 75 12 B5 01 8A 08 FF 4D F4 40 88 4D FB 89 06 80 F9 30 74 F0 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 3B C2 77 16 B5 01 3B 5D EC 74 03 88 03 43 8B 06 8A 08 40 88 4D FB 89 06 EB B3 FF 75 FB 84 ED 8B CE 75 1B E8 ?? ?? ?? ?? 33 C0 89 3E 38 45 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 C9 01 00 00 E8 ?? ?? ?? ?? 8B 0E 89 4D EC 8A 01 8D 51 01 32 C9 88 45 FB 89 55 F0 89 16 3C 45 74 11 3C 50 74 08 3C 65 74 09 3C 70 75 0C 8A 4D FF EB 07 80 7D FF 00 0F 94 C1 33 FF 84 C9 0F 84 FD 00 00 00 8A 0A 8D 42 01 80 F9 2D 88 4D FB 89 06 0F 94 C5 80 F9 2B 74 05 80 F9 2D 75 08 8A 08 40 88 4D FB 89 06 32 D2 80 F9 30 75 11 FE C2 8B 06 8A 08 40 88 4D FB 89 06 80 F9 30 74 F1 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 20 6B FF 0A B2 01 03 F8 81 FF 50 14 00 00 7F 0C 8B 06 8A 08 40 88 4D FB 89 06 EB AD BF 51 14 00 00 8A C1 2C 30 3C 09 77 08 0F BE C1 83 E8 30 EB 23 8A C1 2C 61 3C 19 77 08 0F BE C1 83 E8 57 EB 13 8A C1 2C 41 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 0C 8B 06 8A 08 40 88 4D FB 89 06 EB BC 84 ED 74 02 F7 DF 84 D2 75 1D FF 75 FB 8B CE E8 ?? ?? ?? ?? 8B 45 EC 89 06 C6 45 FB 00 8A 00 88 45 FB 8B 45 F0 89 06 FF 75 FB 8B CE E8 ?? ?? ?? ?? 8B 55 E8 3B DA 74 5C 80 7B FF 00 75 05 4B 3B DA 75 F5 3B DA 74 4D 81 FF 50 14 00 00 7F 26 BE B0 EB FF FF 3B FE 7C 25 8A 4D FF 33 C0 84 C9 0F 94 C0 48 83 E0 03 40 0F AF 45 F4 03 F8 81 FF 50 14 00 00 7E 04 6A 09 EB 1D 3B FE 7D 04 6A 08 EB 15 8B 45 10 2B DA 89 38 89 58 04 33 C0 84 C9 0F 95 C0 EB 20 6A 02 58 EB 1B 57 8D 45 FB 56 50 E8 ?? ?? ?? ?? EB 0B 57 8D 45 FB 56 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_26_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@_W@0@AAUfloating_point_string@0@@Z"
		size = 3629
		refs = "000f ?validate@?$c_string_character_source@_W@__crt_strtox@@QBE_NXZ 0045 _iswctype 00dc ?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z 0e12 ??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$c_string_character_source@_W@0@PB_W@Z 0e1f ??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$c_string_character_source@_W@0@PB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 8B 5D 0C 8B CB E8 ?? ?? ?? ?? 84 C0 75 08 6A 07 58 E9 09 0E 00 00 57 8B 3B 89 7D DC 66 8B 07 66 89 45 F8 8D 47 02 EB 0C 8B 0B 66 8B 01 66 89 45 F8 8D 41 02 6A 08 FF 75 F8 89 03 E8 ?? ?? ?? ?? 59 59 85 C0 75 E2 66 8B 55 F8 56 8B 75 10 6A 2D 59 81 C6 08 03 00 00 89 4D D0 66 3B D1 89 75 E4 6A 2B 0F 94 C0 88 06 58 89 45 D4 66 3B D1 74 05 66 3B D0 75 0E 8B 03 66 8B 10 83 C0 02 66 89 55 F8 89 03 66 83 FA 49 0F 84 82 0D 00 00 66 83 FA 69 0F 84 78 0D 00 00 66 83 FA 4E 0F 84 61 0D 00 00 66 83 FA 6E 0F 84 57 0D 00 00 6A 30 33 C0 59 89 45 EC 88 45 FF 66 3B D1 75 3C 8B 0B 0F B7 01 8D 71 02 89 33 83 F8 78 74 13 83 F8 58 74 0E 50 8B CB E8 ?? ?? ?? ?? 66 8B 55 F8 EB 15 66 8B 16 8D 46 02 8B F9 C6 45 FF 01 66 89 55 F8 89 03 89 7D DC 8B 75 E4 33 C0 8B 4D 10 6A 30 89 45 E0 83 C1 08 88 45 FE 58 89 4D E8 66 3B D0 75 1F 50 C6 45 FE 01 5E 8B 03 66 8B 10 83 C0 02 66 89 55 F8 89 03 66 3B D6 74 ED 8B 75 E4 6A 30 58 8B 7D E8 33 C9 38 4D FF C7 45 F4 61 00 00 00 0F 94 C1 C7 45 F0 19 00 00 00 49 83 E1 06 83 C1 09 89 4D D8 66 3B D0 0F 82 55 02 00 00 6A 3A 58 66 3B D0 73 0B 0F B7 C2 83 E8 30 E9 3D 02 00 00 B8 10 FF 00 00 66 3B D0 0F 83 18 02 00 00 B8 60 06 00 00 66 3B D0 0F 82 26 02 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 60 06 00 00 E9 0C 02 00 00 B8 F0 06 00 00 66 3B D0 0F 82 03 02 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D F0 06 00 00 E9 E9 01 00 00 B8 66 09 00 00 66 3B D0 0F 82 E0 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 66 09 00 00 E9 C6 01 00 00 B8 E6 09 00 00 66 3B D0 0F 82 BD 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D E6 09 00 00 E9 A3 01 00 00 B8 66 0A 00 00 66 3B D0 0F 82 9A 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 66 0A 00 00 E9 80 01 00 00 B8 E6 0A 00 00 66 3B D0 0F 82 77 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D E6 0A 00 00 E9 5D 01 00 00 B8 66 0B 00 00 66 3B D0 0F 82 54 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 66 0B 00 00 E9 3A 01 00 00 B8 66 0C 00 00 66 3B D0 0F 82 31 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 66 0C 00 00 E9 17 01 00 00 B8 E6 0C 00 00 66 3B D0 0F 82 0E 01 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D E6 0C 00 00 E9 F4 00 00 00 B8 66 0D 00 00 66 3B D0 0F 82 EB 00 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 66 0D 00 00 E9 D1 00 00 00 B8 50 0E 00 00 66 3B D0 0F 82 C8 00 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D 50 0E 00 00 E9 AE 00 00 00 B8 D0 0E 00 00 66 3B D0 0F 82 A5 00 00 00 83 C0 0A 66 3B D0 73 0D 0F B7 C2 2D D0 0E 00 00 E9 8B 00 00 00 B8 20 0F 00 00 66 3B D0 0F 82 82 00 00 00 83 C0 0A 66 3B D0 73 0A 0F B7 C2 2D 20 0F 00 00 EB 6B B8 40 10 00 00 66 3B D0 72 66 83 C0 0A 66 3B D0 73 0A 0F B7 C2 2D 40 10 00 00 EB 4F B8 E0 17 00 00 66 3B D0 72 4A 83 C0 0A 66 3B D0 73 0A 0F B7 C2 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B D0 72 2E 83 C0 0A 66 3B D0 73 26 0F B7 C2 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 3B D0 73 0A 0F B7 C2 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 38 6A 41 58 66 3B C2 77 08 6A 5A 58 66 3B D0 76 0D 66 8B C2 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C2 66 2B 45 F4 66 3B 45 F0 0F B7 C2 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C1 77 24 C6 45 FE 01 3B FE 74 03 88 07 47 8B 03 FF 45 E0 6A 30 66 8B 10 83 C0 02 89 03 66 89 55 F8 58 E9 42 FD FF FF 8B 45 08 89 7D E8 8B 7D DC 8B 00 8B 80 88 00 00 00 8B 00 0F BE 08 0F B7 C2 3B C1 0F 85 0A 03 00 00 8B 03 8B 55 10 8B 75 E4 83 C2 08 66 8B 08 83 C0 02 66 89 4D F8 89 03 39 55 E8 75 27 6A 30 5A 66 3B CA 75 1F 8B 75 E0 C6 45 FE 01 66 8B 08 4E 83 C0 02 66 89 4D F8 89 03 66 3B CA 74 EE 89 75 E0 8B 75 E4 8B 55 D8 8B 7D E8 6A 30 58 66 3B C8 0F 82 55 02 00 00 6A 3A 58 66 3B C8 73 0B 0F B7 C1 83 E8 30 E9 3D 02 00 00 B8 10 FF 00 00 66 3B C8 0F 83 18 02 00 00 B8 60 06 00 00 66 3B C8 0F 82 26 02 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 60 06 00 00 E9 0C 02 00 00 B8 F0 06 00 00 66 3B C8 0F 82 03 02 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D F0 06 00 00 E9 E9 01 00 00 B8 66 09 00 00 66 3B C8 0F 82 E0 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 09 00 00 E9 C6 01 00 00 B8 E6 09 00 00 66 3B C8 0F 82 BD 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 09 00 00 E9 A3 01 00 00 B8 66 0A 00 00 66 3B C8 0F 82 9A 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0A 00 00 E9 80 01 00 00 B8 E6 0A 00 00 66 3B C8 0F 82 77 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0A 00 00 E9 5D 01 00 00 B8 66 0B 00 00 66 3B C8 0F 82 54 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0B 00 00 E9 3A 01 00 00 B8 66 0C 00 00 66 3B C8 0F 82 31 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0C 00 00 E9 17 01 00 00 B8 E6 0C 00 00 66 3B C8 0F 82 0E 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0C 00 00 E9 F4 00 00 00 B8 66 0D 00 00 66 3B C8 0F 82 EB 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0D 00 00 E9 D1 00 00 00 B8 50 0E 00 00 66 3B C8 0F 82 C8 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AE 00 00 00 B8 D0 0E 00 00 66 3B C8 0F 82 A5 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8B 00 00 00 B8 20 0F 00 00 66 3B C8 0F 82 82 00 00 00 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6B B8 40 10 00 00 66 3B C8 72 66 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 40 10 00 00 EB 4F B8 E0 17 00 00 66 3B C8 72 4A 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B C8 72 2E 83 C0 0A 66 3B C8 73 26 0F B7 C1 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 3B C8 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 38 6A 41 58 66 3B C1 77 08 6A 5A 58 66 3B C8 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 3B C2 77 1E C6 45 FE 01 3B FE 74 03 88 07 47 8B 03 66 8B 08 83 C0 02 66 89 4D F8 89 03 E9 45 FD FF FF 89 7D E8 8B 7D DC FF 75 F8 8B CB E8 ?? ?? ?? ?? 80 7D FE 00 75 16 33 C0 89 3B 38 45 FF 0F 94 C0 48 83 E0 FB 83 C0 07 E9 BE 06 00 00 8B 33 32 C9 89 75 D8 66 8B 06 8D 7E 02 66 89 45 F8 0F B7 C0 89 3B 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0C 8A 4D FF EB 07 80 7D FF 00 0F 94 C1 84 C9 0F 84 EE 05 00 00 66 8B 0F 8D 47 02 6A 2D 5A 66 3B CA 66 89 4D F8 89 03 0F 94 C6 66 3B 4D D4 74 06 66 3B 4D D0 75 0C 66 8B 08 83 C0 02 66 89 4D F8 89 03 6A 30 58 32 D2 66 3B C8 75 1D 50 FE C2 5F 8B 03 66 8B 08 83 C0 02 66 89 4D F8 89 03 66 3B CF 74 ED 6A 30 58 66 3B C8 0F 82 55 02 00 00 6A 3A 58 66 3B C8 73 0B 0F B7 C1 83 E8 30 E9 3D 02 00 00 B8 10 FF 00 00 66 3B C8 0F 83 18 02 00 00 B8 60 06 00 00 66 3B C8 0F 82 26 02 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 60 06 00 00 E9 0C 02 00 00 B8 F0 06 00 00 66 3B C8 0F 82 03 02 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D F0 06 00 00 E9 E9 01 00 00 B8 66 09 00 00 66 3B C8 0F 82 E0 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 09 00 00 E9 C6 01 00 00 B8 E6 09 00 00 66 3B C8 0F 82 BD 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 09 00 00 E9 A3 01 00 00 B8 66 0A 00 00 66 3B C8 0F 82 9A 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0A 00 00 E9 80 01 00 00 B8 E6 0A 00 00 66 3B C8 0F 82 77 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0A 00 00 E9 5D 01 00 00 B8 66 0B 00 00 66 3B C8 0F 82 54 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0B 00 00 E9 3A 01 00 00 B8 66 0C 00 00 66 3B C8 0F 82 31 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0C 00 00 E9 17 01 00 00 B8 E6 0C 00 00 66 3B C8 0F 82 0E 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0C 00 00 E9 F4 00 00 00 B8 66 0D 00 00 66 3B C8 0F 82 EB 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0D 00 00 E9 D1 00 00 00 B8 50 0E 00 00 66 3B C8 0F 82 C8 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 50 0E 00 00 E9 AE 00 00 00 B8 D0 0E 00 00 66 3B C8 0F 82 A5 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D D0 0E 00 00 E9 8B 00 00 00 B8 20 0F 00 00 66 3B C8 0F 82 82 00 00 00 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 20 0F 00 00 EB 6B B8 40 10 00 00 66 3B C8 72 66 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 40 10 00 00 EB 4F B8 E0 17 00 00 66 3B C8 72 4A 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B C8 72 2E 83 C0 0A 66 3B C8 73 26 0F B7 C1 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 3B C8 73 0A 0F B7 C1 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 38 6A 41 58 66 3B C1 77 08 6A 5A 58 66 3B C8 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 0A 73 2D 6B 7D EC 0A B2 01 03 F8 89 7D EC 81 FF 50 14 00 00 7F 13 8B 03 66 8B 08 83 C0 02 66 89 4D F8 89 03 E9 3C FD FF FF C7 45 EC 51 14 00 00 6A 30 5F BE 10 FF 00 00 66 3B CF 0F 82 48 02 00 00 6A 3A 58 66 3B C8 73 0A 0F B7 C1 2B C7 E9 31 02 00 00 66 3B CE 0F 83 14 02 00 00 B8 60 06 00 00 66 3B C8 0F 82 1F 02 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 60 06 00 00 E9 05 02 00 00 B8 F0 06 00 00 66 3B C8 0F 82 FC 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D F0 06 00 00 E9 E2 01 00 00 B8 66 09 00 00 66 3B C8 0F 82 D9 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 09 00 00 E9 BF 01 00 00 B8 E6 09 00 00 66 3B C8 0F 82 B6 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 09 00 00 E9 9C 01 00 00 B8 66 0A 00 00 66 3B C8 0F 82 93 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0A 00 00 E9 79 01 00 00 B8 E6 0A 00 00 66 3B C8 0F 82 70 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0A 00 00 E9 56 01 00 00 B8 66 0B 00 00 66 3B C8 0F 82 4D 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0B 00 00 E9 33 01 00 00 B8 66 0C 00 00 66 3B C8 0F 82 2A 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0C 00 00 E9 10 01 00 00 B8 E6 0C 00 00 66 3B C8 0F 82 07 01 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D E6 0C 00 00 E9 ED 00 00 00 B8 66 0D 00 00 66 3B C8 0F 82 E4 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 66 0D 00 00 E9 CA 00 00 00 B8 50 0E 00 00 66 3B C8 0F 82 C1 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D 50 0E 00 00 E9 A7 00 00 00 B8 D0 0E 00 00 66 3B C8 0F 82 9E 00 00 00 83 C0 0A 66 3B C8 73 0D 0F B7 C1 2D D0 0E 00 00 E9 84 00 00 00 B8 20 0F 00 00 66 3B C8 72 7F 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 20 0F 00 00 EB 68 B8 40 10 00 00 66 3B C8 72 63 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D 40 10 00 00 EB 4C B8 E0 17 00 00 66 3B C8 72 47 83 C0 0A 66 3B C8 73 0A 0F B7 C1 2D E0 17 00 00 EB 30 B8 10 18 00 00 66 3B C8 72 2B 83 C0 0A 66 3B C8 73 23 0F B7 C1 2D 10 18 00 00 EB 14 B8 1A FF 00 00 66 3B C8 73 07 0F B7 C1 2B C6 EB 03 83 C8 FF 83 F8 FF 75 38 6A 41 58 66 3B C1 77 08 6A 5A 58 66 3B C8 76 0D 66 8B C1 66 2B 45 F4 66 3B 45 F0 77 18 66 8B C1 66 2B 45 F4 66 3B 45 F0 0F B7 C1 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 0A 73 13 8B 03 66 8B 08 83 C0 02 66 89 4D F8 89 03 E9 5F FD FF FF 8B 75 D8 8D 7E 02 84 F6 74 03 F7 5D EC 84 D2 75 1B FF 75 F8 8B CB E8 ?? ?? ?? ?? 33 C0 89 33 66 89 45 F8 66 8B 06 66 89 45 F8 89 3B FF 75 F8 8B CB E8 ?? ?? ?? ?? 8B 75 10 8B 55 E8 8D 5E 08 3B D3 74 5B 80 7A FF 00 75 05 4A 3B D3 75 F5 3B D3 74 4C 8B 4D EC 81 F9 50 14 00 00 7F 24 BF B0 EB FF FF 3B CF 7C 23 33 C0 38 45 FF 0F 94 C0 48 83 E0 03 40 0F AF 45 E0 03 C8 81 F9 50 14 00 00 7E 04 6A 09 EB 1B 3B CF 7D 04 6A 08 EB 13 33 C0 89 0E 2B D3 38 45 FF 89 56 04 0F 95 C0 EB 20 6A 02 58 EB 1B 57 8D 45 F8 53 50 E8 ?? ?? ?? ?? EB 0B 57 8D 45 F8 53 50 E8 ?? ?? ?? ?? 83 C4 0C 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_27_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
		size = 154
		refs = "0018 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0020 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0038 ?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z 004e ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0056 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 0C 33 C9 57 8B 7D 08 6A 03 5B 8A 07 3A 81 ?? ?? ?? ?? 74 08 3A 81 ?? ?? ?? ?? 75 56 8B 06 8A 10 40 41 89 06 88 17 3B CB 75 E0 52 8B CE E8 ?? ?? ?? ?? 8B 06 89 45 FC 8A 08 40 89 06 88 0F 33 C9 8A 07 3A 81 ?? ?? ?? ?? 74 08 3A 81 ?? ?? ?? ?? 75 29 8B 06 8A 10 40 41 89 06 88 17 83 F9 05 75 DF 52 8B CE E8 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 8B 45 10 6A 07 5B 89 45 FC 0F B6 0F 51 8B CE E8 ?? ?? ?? ?? 8B 45 FC C6 07 00 89 06 EB D9 }
	condition:
		$1
}

rule file_75_28_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$c_string_character_source@_W@0@PB_W@Z"
		size = 183
		refs = "0019 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB 0022 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB 0041 ?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z 005b ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB 0064 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 0C 33 DB 57 8B 7D 08 8B CB 0F B7 07 66 3B 81 ?? ?? ?? ?? 74 09 66 3B 81 ?? ?? ?? ?? 75 69 8B 06 83 C1 02 0F B7 10 83 C0 02 89 06 66 89 17 83 F9 06 75 D6 52 8B CE E8 ?? ?? ?? ?? 8B 06 89 45 FC 0F B7 08 83 C0 02 89 06 66 89 0F 0F B7 07 66 3B 83 ?? ?? ?? ?? 74 09 66 3B 83 ?? ?? ?? ?? 75 31 8B 06 83 C3 02 0F B7 08 83 C0 02 89 06 66 89 0F 83 FB 0A 75 D6 51 8B CE E8 ?? ?? ?? ?? 6A 03 58 5F 5E 5B 8B E5 5D C3 8B 45 10 6A 07 89 45 FC EB 02 6A 03 0F B7 0F 5B 51 8B CE E8 ?? ?? ?? ?? 33 C0 66 89 07 8B 45 FC 89 06 8B C3 EB D3 }
	condition:
		$1
}

rule file_75_29_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
		size = 283
		refs = "0022 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 002a ?lowercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0043 ?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z 005c ??R<lambda_32aa245da1b5b882fa96db788295c8b2>@@QBE_NXZ 008f ??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z 00a0 ??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 C9 89 7D F4 89 75 F8 89 45 FC 8A 06 3A 81 ?? ?? ?? ?? 74 08 3A 81 ?? ?? ?? ?? 75 42 8B 07 8A 10 40 41 89 07 88 16 83 F9 03 75 DF 52 8B CF E8 ?? ?? ?? ?? 8B 07 89 45 10 8A 08 40 89 07 88 0E 80 F9 28 74 2A 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 A3 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 6A 07 58 E9 93 00 00 00 8B 07 53 57 56 8A 08 40 89 07 88 0E E8 ?? ?? ?? ?? 59 59 84 C0 74 04 6A 05 EB 0F 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 12 6A 06 0F B6 16 8B CF 5B 52 E8 ?? ?? ?? ?? 8B C3 EB 58 80 3E 29 74 50 8A 06 84 C0 74 2E 0F BE C8 8D 41 D0 83 F8 09 76 15 8D 41 9F 83 F8 19 76 0D 8D 41 BF 83 F8 19 76 05 83 F9 5F 75 13 8B 07 8A 08 40 89 07 88 0E 80 F9 29 75 CC 80 3E 29 74 17 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 EB 03 6A 04 58 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_30_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$c_string_character_source@_W@0@PB_W@Z"
		size = 292
		refs = "0028 ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB 0031 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$c_string_character_source@_W@1@PB_W@Z@4QB_WB 004f ?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z 006c ??R<lambda_e128a58a467199df1f46ac2193393add>@@QBE_NXZ 00a1 ??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@0@@Z 00b3 ??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 08 8D 45 10 57 8B 7D 0C 33 C9 6A 06 89 7D F4 89 75 F8 89 45 FC 5B 0F B7 06 66 3B 81 ?? ?? ?? ?? 74 09 66 3B 81 ?? ?? ?? ?? 75 4B 8B 07 83 C1 02 0F B7 10 83 C0 02 89 07 66 89 16 3B CB 75 D7 52 8B CF E8 ?? ?? ?? ?? 8B 07 89 45 10 0F B7 08 83 C0 02 89 07 66 89 0E 83 F9 28 74 29 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 E0 FD 83 C0 07 E9 9B 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 6A 07 E9 8B 00 00 00 8B 07 57 56 0F B7 08 83 C0 02 89 07 66 89 0E E8 ?? ?? ?? ?? 59 59 84 C0 74 05 6A 05 5B EB 0D 57 56 E8 ?? ?? ?? ?? 59 59 84 C0 74 0F 0F B7 16 8B CF 52 E8 ?? ?? ?? ?? 8B C3 EB 51 6A 29 5A 66 39 16 74 46 0F B7 06 66 85 C0 74 35 8B C8 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 69 FF FF FF 8B 07 0F B7 08 83 C0 02 89 07 66 89 0E 66 3B CA 75 C3 66 39 16 0F 85 4E FF FF FF 6A 04 58 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_31_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z"
		size = 60
		refs = "0016 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 57 8B 7D 0C 8B D3 8A 06 3A 82 ?? ?? ?? ?? 74 08 3A 82 ?? ?? ?? ?? 75 11 8B 07 8A 08 40 42 89 07 88 0E 83 FA 04 75 DF B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_75_32_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@0@@Z"
		size = 69
		refs = "0018 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@1@@Z@4QB_WB 0021 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@1@@Z@4QB_WB"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 57 8B 7D 0C 8B D3 0F B7 06 66 3B 82 ?? ?? ?? ?? 74 09 66 3B 82 ?? ?? ?? ?? 75 17 8B 07 83 C2 02 0F B7 08 83 C0 02 89 07 66 89 0E 83 FA 08 75 D6 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_75_33_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z"
		size = 60
		refs = "0016 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB 001e ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 57 8B 7D 0C 8B D3 8A 06 3A 82 ?? ?? ?? ?? 74 08 3A 82 ?? ?? ?? ?? 75 11 8B 07 8A 08 40 42 89 07 88 0E 83 FA 05 75 DF B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_75_34_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@0@@Z"
		size = 69
		refs = "0018 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@1@@Z@4QB_WB 0021 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$c_string_character_source@_W@1@@Z@4QB_WB"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 57 8B 7D 0C 8B D3 0F B7 06 66 3B 82 ?? ?? ?? ?? 74 09 66 3B 82 ?? ?? ?? ?? 75 17 8B 07 83 C2 02 0F B7 08 83 C0 02 89 07 66 89 0E 83 FA 0A 75 D6 B3 01 5F 5E 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_75_37_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$c_string_character_source@D@0@@Z"
		size = 73
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 2F 8B 75 08 8B 55 0C 2B F2 8B 5D 14 8A 03 3A 04 16 74 04 3A 02 75 20 8B 45 18 8B 5D 18 8B 00 8A 08 40 89 03 47 8B 5D 14 42 88 0B 3B 7D 10 75 DC B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_75_38_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$c_string_character_source@_W@0@@Z"
		size = 82
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF 39 7D 10 74 38 8B 75 08 8B 55 0C 2B F2 8B 5D 14 0F B7 03 66 3B 04 16 74 05 66 3B 02 75 26 8B 45 18 83 C2 02 8B 5D 18 8B 00 0F B7 08 83 C0 02 89 03 47 8B 5D 14 66 89 0B 3B 7D 10 75 D3 B0 01 5F 5E 5B 5D C3 32 C0 EB F7 }
	condition:
		$1
}

rule file_75_45_0 {
	meta:
		name = "??0?$c_string_character_source@D@__crt_strtox@@QAE@QBDQAPBD@Z"
		size = 28
		altNames = "??0?$c_string_character_source@_W@__crt_strtox@@QAE@QB_WQAPB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 55 08 89 11 89 41 04 85 C0 74 02 89 10 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_75_101_0 {
	meta:
		name = "?restore_state@?$c_string_character_source@D@__crt_strtox@@QAE_NQBD@Z"
		size = 16
		altNames = "?restore_state@?$c_string_character_source@_W@__crt_strtox@@QAE_NQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 01 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_75_108_0 {
	meta:
		name = "?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z"
		size = 40
		refs = "0015 __errno 0020 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC FF 09 8A 45 08 8B 09 84 C0 74 14 38 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_75_109_0 {
	meta:
		name = "?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z"
		size = 44
		refs = "0019 __errno 0024 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 01 FE 66 8B 45 08 8B 09 66 85 C0 74 15 66 39 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_75_110_0 {
	meta:
		name = "?validate@?$c_string_character_source@D@__crt_strtox@@QBE_NXZ"
		size = 27
		refs = "0006 __errno 0011 __invalid_parameter_noinfo"
		altNames = "?validate@?$c_string_character_source@_W@__crt_strtox@@QBE_NXZ ?validate@?$stream_input_adapter@_W@__crt_stdio_input@@QBE_NXZ ?validate@?$stream_output_adapter@_W@__crt_stdio_output@@QBE_NXZ ?validate@?$string_output_adapter@D@__crt_stdio_output@@QBE_NXZ ?validate@?$string_output_adapter@_W@__crt_stdio_output@@QBE_NXZ"
	strings:
		$1 = { 83 39 00 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 ___acrt_sincos_ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "_cexp"
		size = 473
		refs = "0017 _creal 0028 _cimag 0034 __dtest 00d2 __Zero_C 00e3 __CIcos 00f5 __CIsin 010a __fperrraise 0116 __Nan_C 015b __Cbuild 01ac __dexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 E0 50 DD 5D E8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C8 6A 02 58 66 3B F0 75 11 DD 45 E0 DD 55 F0 66 85 C9 0F 85 27 01 00 00 EB 25 66 3B C8 75 30 66 83 FE 01 75 22 D9 EE DD 45 E0 D8 D1 DF E0 F6 C4 05 7A 07 DD D8 E9 02 01 00 00 DD D9 DD 55 F0 DD 45 E8 E9 FA 00 00 00 DD 45 E8 E9 ED 00 00 00 33 D2 42 66 3B F2 0F 85 CF 00 00 00 D9 EE DD 45 E0 D8 D1 DF E0 F6 C4 05 7A 4D DD D8 66 3B CA 75 24 D9 C0 DD 55 F0 D9 C9 DC 55 E8 DF E0 F6 C4 41 0F 85 BC 00 00 00 DD D8 DD 05 ?? ?? ?? ?? D9 E0 E9 AD 00 00 00 DD D8 DD 45 E8 E8 ?? ?? ?? ?? D9 EE DE C9 DD 55 D8 DD 5D F0 DD 45 E8 E8 ?? ?? ?? ?? D9 EE DE C9 EB 45 DD D9 66 3B CA 75 17 52 DD D8 E8 ?? ?? ?? ?? DD 45 E0 DD 55 F0 DD 05 ?? ?? ?? ?? 59 EB 6D 66 85 C9 0F 84 5F FF FF FF DD D8 DD 45 E8 E8 ?? ?? ?? ?? DC 4D E0 DD 55 D8 DD 5D F0 DD 45 E8 E8 ?? ?? ?? ?? DC 4D E0 DD 55 F8 DD 45 D8 D9 C9 83 EC 10 8D 45 D0 DD 5C 24 08 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 66 3B CA 75 17 52 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 55 F0 D9 C0 DD 55 F8 EB BD DD 45 E0 DD 55 F0 DD 5D F8 DD 45 E8 6A 00 E8 ?? ?? ?? ?? 51 51 8D 45 F0 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 E8 83 C4 10 6A 00 E8 ?? ?? ?? ?? 51 51 8D 45 F8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 F0 83 C4 10 DD 45 F8 E9 73 FF FF FF }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "_cexpl"
		size = 473
		refs = "0017 _creall 0028 _cimagl 0034 __ldtest 00d2 __LZero_C 00e3 __CIcos 00f5 __CIsin 010a __fperrraise 0116 __LNan_C 015b __LCbuild 01ac __ldexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 E0 50 DD 5D E8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C8 6A 02 58 66 3B F0 75 11 DD 45 E0 DD 55 F0 66 85 C9 0F 85 27 01 00 00 EB 25 66 3B C8 75 30 66 83 FE 01 75 22 D9 EE DD 45 E0 D8 D1 DF E0 F6 C4 05 7A 07 DD D8 E9 02 01 00 00 DD D9 DD 55 F0 DD 45 E8 E9 FA 00 00 00 DD 45 E8 E9 ED 00 00 00 33 D2 42 66 3B F2 0F 85 CF 00 00 00 D9 EE DD 45 E0 D8 D1 DF E0 F6 C4 05 7A 4D DD D8 66 3B CA 75 24 D9 C0 DD 55 F0 D9 C9 DC 55 E8 DF E0 F6 C4 41 0F 85 BC 00 00 00 DD D8 DD 05 ?? ?? ?? ?? D9 E0 E9 AD 00 00 00 DD D8 DD 45 E8 E8 ?? ?? ?? ?? D9 EE DE C9 DD 55 D8 DD 5D F0 DD 45 E8 E8 ?? ?? ?? ?? D9 EE DE C9 EB 45 DD D9 66 3B CA 75 17 52 DD D8 E8 ?? ?? ?? ?? DD 45 E0 DD 55 F0 DD 05 ?? ?? ?? ?? 59 EB 6D 66 85 C9 0F 84 5F FF FF FF DD D8 DD 45 E8 E8 ?? ?? ?? ?? DC 4D E0 DD 55 D8 DD 5D F0 DD 45 E8 E8 ?? ?? ?? ?? DC 4D E0 DD 55 F8 DD 45 D8 D9 C9 83 EC 10 8D 45 D0 DD 5C 24 08 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 66 3B CA 75 17 52 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 55 F0 D9 C0 DD 55 F8 EB BD DD 45 E0 DD 55 F0 DD 5D F8 DD 45 E8 6A 00 E8 ?? ?? ?? ?? 51 51 8D 45 F0 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 E8 83 C4 10 6A 00 E8 ?? ?? ?? ?? 51 51 8D 45 F8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 F0 83 C4 10 DD 45 F8 E9 73 FF FF FF }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_scalblnl"
		size = 68
		refs = "0010 __ldtest 0022 __ldscale 003a __fperrraise"
		altNames = "_scalbnl"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 74 34 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 25 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "_scalbln"
		size = 68
		refs = "0010 __dtest 0022 __dscale 003a __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 74 34 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 25 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "_scalbn"
		size = 68
		refs = "0010 __dtest 0022 __dscale 003a __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 74 34 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 25 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__cputs"
		size = 135
		refs = "0003 __sehtable$__cputs 0008 __SEH_prolog4 001b ___doserrno 0023 __errno 002e __invalid_parameter_noinfo 003a ___acrt_lock 0055 __putch_nolock 0073 __SEH_epilog4 0081 ___acrt_unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 08 85 FF 0F 95 C0 85 C0 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 3B 6A 09 E8 ?? ?? ?? ?? 59 33 F6 89 75 E4 89 75 FC 89 7D E0 8A 07 84 C0 74 14 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 19 0B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 47 EB CC 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_clog10"
		size = 79
		refs = "001b _clog 0021 __real@3fdbcb7b1526e50e 0037 __Cmulcr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8D 45 F0 56 57 83 EC 10 8D 75 0C 8B FC 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B F0 51 8B FC 8D 45 E0 DD 5C 24 10 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 1C 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "_clog10l"
		size = 79
		refs = "001b _clogl 0021 __real@3fdbcb7b1526e50e 0037 __LCmulcr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8D 45 F0 56 57 83 EC 10 8D 75 0C 8B FC 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B F0 51 8B FC 8D 45 E0 DD 5C 24 10 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 1C 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_14_0 {
	meta:
		name = "_call_wsetlocale"
		size = 157
		refs = "0012 __wsetlocale 002d _mbstowcs_s 0048 __calloc_base 0085 __free_base 0098 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 0C 00 75 0E 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 74 56 57 68 FF FF FF 7F FF 75 0C 33 FF 8D 45 FC 57 57 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0A 83 F8 16 74 55 83 F8 22 74 50 6A 02 FF 75 FC E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 2F 6A FF FF 75 0C FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0C 83 F8 16 74 23 83 F8 22 75 0F EB 1C 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F8 56 E8 ?? ?? ?? ?? 59 8B C7 5F 5E 8B E5 5D C3 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_81_15_0 {
	meta:
		name = "_setlocale"
		size = 41
		refs = "0008 ___acrt_eagerly_load_locale_apis 001f ??$__acrt_lock_and_call@V<lambda_082c17da81b0962e08c0587ee0fac50c>@@@@YAPADW4__acrt_lock_id@@$$QAV<lambda_082c17da81b0962e08c0587ee0fac50c>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 E8 ?? ?? ?? ?? 8D 45 08 89 45 F8 8D 45 0C 89 45 FC 8D 45 F8 50 6A 04 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__ldclass"
		size = 17
		refs = "000a __ldtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__dclass"
		size = 17
		refs = "000a __dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__fdclass"
		size = 17
		refs = "000a __fdtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "__ldpcomp"
		size = 86
		refs = "000b __ldtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 59 6A 02 5E 66 3B C6 74 39 8D 45 10 50 E8 ?? ?? ?? ?? 59 66 3B C6 74 2A DD 45 10 DD 45 08 D8 D1 DF E0 F6 C4 05 7A 09 DD D9 33 C0 DD D8 40 EB 14 DE D9 DF E0 F6 C4 41 75 05 6A 04 58 EB 06 8B C6 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_297_1_0 {
	meta:
		name = "__dpcomp"
		size = 86
		refs = "000b __dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 59 6A 02 5E 66 3B C6 74 39 8D 45 10 50 E8 ?? ?? ?? ?? 59 66 3B C6 74 2A DD 45 10 DD 45 08 D8 D1 DF E0 F6 C4 05 7A 09 DD D9 33 C0 DD D8 40 EB 14 DE D9 DF E0 F6 C4 41 75 05 6A 04 58 EB 06 8B C6 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_84_2_0 {
	meta:
		name = "__ldsign"
		size = 16
		altNames = "__dsign"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 0E 25 00 80 00 00 5D C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "??$common_tcscat_s@D@@YAHQADIQBD@Z"
		size = 105
		refs = "0020 __errno 002a __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 85 F6 74 11 8B 4D 0C 85 C9 74 0A 8B 7D 10 85 FF 75 18 C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5D C3 8B D6 80 3A 00 74 06 42 83 E9 01 75 F5 85 C9 74 D7 2B FA 8A 04 17 88 02 42 84 C0 74 05 83 E9 01 75 F1 85 C9 75 0B 88 0E E8 ?? ?? ?? ?? 6A 22 EB C1 33 C0 EB C7 }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "_strcat_s"
		size = 105
		refs = "0020 __errno 002a __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 85 F6 74 11 8B 4D 0C 85 C9 74 0A 8B 7D 10 85 FF 75 18 C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 5F 8B C6 5E 5D C3 8B D6 80 3A 00 74 06 42 83 E9 01 75 F5 85 C9 74 D7 2B FA 8A 04 17 88 02 42 84 C0 74 05 83 E9 01 75 F1 85 C9 75 0B 88 0E E8 ?? ?? ?? ?? 6A 22 EB C1 33 F6 EB C5 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "_ctanh"
		size = 360
		refs = "0017 _creal 0028 _cimag 0034 __dtest 0061 __Zero_C 0079 __real@bff0000000000000 00cb __Nan_C 00d5 __CItan 00e0 __CIsinh 00ff __Inf_C 013c __CIsqrt 0150 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 F0 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 33 D2 0F B7 C0 42 83 C4 18 66 3B F2 75 3D D9 EE B8 00 80 00 00 66 85 45 FE 74 0A DD 05 ?? ?? ?? ?? D9 E0 EB 02 D9 C0 D9 C9 DC 5D F0 DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 E8 83 EC 10 D9 C9 DD 5C 24 08 E9 B9 00 00 00 6A 02 59 66 3B C1 75 0F DD 45 F8 83 EC 10 DD 54 24 08 E9 A2 00 00 00 66 3B F1 75 19 DD 45 F8 D9 EE DD E9 DF E0 DD 45 F0 F6 C4 44 7B C5 DD D9 D9 C0 D9 C9 EB BD 66 3B C2 75 08 DD 05 ?? ?? ?? ?? EB C9 DD 45 F8 E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 E8 ?? ?? ?? ?? DD 45 E8 D9 C0 D8 C9 D9 E8 DC C1 D9 C9 D8 CB DD 55 E8 D8 CB D8 C1 DD 55 E0 DD 05 ?? ?? ?? ?? DD E9 DF E0 F6 C4 44 7A 20 DD D8 D9 EE D8 D3 DF E0 DD DB F6 C4 41 75 08 DD D8 DD 05 ?? ?? ?? ?? D9 C9 DE CA E9 55 FF FF FF DE FA D9 C9 51 51 DD 1C 24 D9 C9 DC C8 DE C1 E8 ?? ?? ?? ?? DC 4D E8 51 51 DC 75 E0 8D 45 D8 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "_ctanhl"
		size = 360
		refs = "0017 _creall 0028 _cimagl 0034 __ldtest 0061 __LZero_C 0079 __real@bff0000000000000 00cb __LNan_C 00d5 __CItan 00e0 __CIsinh 00ff __LInf_C 013c __CIsqrt 0150 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 F0 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 33 D2 0F B7 C0 42 83 C4 18 66 3B F2 75 3D D9 EE B8 00 80 00 00 66 85 45 FE 74 0A DD 05 ?? ?? ?? ?? D9 E0 EB 02 D9 C0 D9 C9 DC 5D F0 DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 E8 83 EC 10 D9 C9 DD 5C 24 08 E9 B9 00 00 00 6A 02 59 66 3B C1 75 0F DD 45 F8 83 EC 10 DD 54 24 08 E9 A2 00 00 00 66 3B F1 75 19 DD 45 F8 D9 EE DD E9 DF E0 DD 45 F0 F6 C4 44 7B C5 DD D9 D9 C0 D9 C9 EB BD 66 3B C2 75 08 DD 05 ?? ?? ?? ?? EB C9 DD 45 F8 E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 E8 ?? ?? ?? ?? DD 45 E8 D9 C0 D8 C9 D9 E8 DC C1 D9 C9 D8 CB DD 55 E8 D8 CB D8 C1 DD 55 E0 DD 05 ?? ?? ?? ?? DD E9 DF E0 F6 C4 44 7A 20 DD D8 D9 EE D8 D3 DF E0 DD DB F6 C4 41 75 08 DD D8 DD 05 ?? ?? ?? ?? D9 C9 DE CA E9 55 FF FF FF DE FA D9 C9 51 51 DD 1C 24 D9 C9 DC C8 DE C1 E8 ?? ?? ?? ?? DC 4D E8 51 51 DC 75 E0 8D 45 D8 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_87_5_0 {
	meta:
		name = "__mbstok_s_l"
		size = 415
		refs = "0011 __errno 001c __invalid_parameter_noinfo 005a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 006c _strtok_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 57 8B 7D 10 85 FF 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 73 01 00 00 83 7D 0C 00 74 E3 53 56 8B 75 08 33 DB 85 F6 75 1B 39 1F 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 45 01 00 00 FF 75 14 8D 4D E0 E8 ?? ?? ?? ?? 8B 55 E8 39 5A 08 75 14 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 E9 0C 01 00 00 85 F6 75 02 8B 37 8A 0E 84 C9 74 76 8B 45 0C 8B F8 38 18 74 40 8A 2F 0F B6 C5 F6 44 10 19 04 74 1A 8D 47 01 89 45 F8 8A 00 84 C0 74 19 3A E9 75 05 3A 46 01 74 1F 8B 7D F8 EB 04 3A E9 74 16 47 38 1F 75 D1 EB 0F 47 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 55 E8 38 1F 74 26 0F B6 06 F6 44 10 19 04 74 05 46 38 1E 74 09 46 8A 0E 84 C9 75 9D EB 0E E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 55 E8 8B 7D 10 89 75 F0 38 1E 74 78 8B 45 0C 8A 08 88 4D FE 8B C8 8B C3 38 45 FE 74 3B 0F B6 01 F6 44 10 19 04 74 1C 8D 41 01 89 45 F4 8A 20 84 E4 74 22 8A 01 3A 06 75 05 3A 66 01 74 12 8B 4D F4 EB 06 8A 01 3A 06 74 0D 41 38 19 75 CF EB 06 33 C0 40 EB 03 41 8B C3 38 19 75 1E 0F B6 06 F6 44 10 19 04 74 06 38 5E 01 74 0B 46 46 38 1E 74 13 8B 45 0C EB 9E 88 1E EB 0A 88 1E 46 85 C0 74 03 88 1E 46 8B 55 F0 89 37 3B D6 74 02 8B DA 80 7D EC 00 74 0A 8B 4D E0 83 A1 50 03 00 00 FD 8B C3 5E 5B 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2848
		refs = "0023 SIGMASK 002b ONEMASK 005c ___acrt_pow_rcp_t1 0070 ___acrt_pow_log2_t1 00ab HALFSIG 00d7 ___acrt_pow_rcp_t2 00eb ___acrt_pow_log2_t2 011d LHN 0133 ___acrt_pow_rcp_t3 0145 ___acrt_pow_log2_t3 022e ___acrt_pow_clv 0289 Shifter 02ad ___acrt_pow_exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 0781 INF 0812 ___libm_error_support 0a4b EMIN 0a78 NEG_BIG 0a80 POS_BIG"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 B2 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E AF 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 F4 03 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 72 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 5E 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 67 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 1F 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 03 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 5D 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 16 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 7E E0 83 F8 00 75 20 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 E9 00 00 00 81 FA 00 00 F0 BF 75 03 D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 59 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 30 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 1B 72 05 83 F9 00 77 14 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 D9 E8 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 65 FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 54 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 21 F7 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 2D FF FF FF E9 4B FF FF FF 90 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_truncf"
		size = 23
		refs = "000c __fd_int"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_90_6_0 {
	meta:
		name = "__access"
		size = 24
		refs = "000c __access_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? F7 D8 59 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "__waccess"
		size = 24
		refs = "000c __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? F7 D8 59 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_90_7_0 {
	meta:
		name = "__access_s"
		size = 85
		refs = "0012 __waccess_s 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_553_14_0 {
	meta:
		name = "??$common_stat@U_stat32@@@@YAHQBDQAU_stat32@@@Z"
		size = 85
		refs = "0012 ??$common_stat@U_stat32@@@@YAHQB_WQAU_stat32@@@Z 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_553_16_0 {
	meta:
		name = "??$common_stat@U_stat32i64@@@@YAHQBDQAU_stat32i64@@@Z"
		size = 85
		refs = "0012 ??$common_stat@U_stat32i64@@@@YAHQB_WQAU_stat32i64@@@Z 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_553_18_0 {
	meta:
		name = "??$common_stat@U_stat64@@@@YAHQBDQAU_stat64@@@Z"
		size = 85
		refs = "0012 ??$common_stat@U_stat64@@@@YAHQB_WQAU_stat64@@@Z 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_553_20_4 {
	meta:
		name = "??$common_stat@U_stat64i32@@@@YAHQBDQAU_stat64i32@@@Z"
		size = 85
		refs = "0012 ??$common_stat@U_stat64i32@@@@YAHQB_WQAU_stat64i32@@@Z 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_386_6_3 {
	meta:
		name = "__chmod"
		size = 85
		refs = "0012 __wchmod 0027 ___acrt_copy_path_to_wide_string 0049 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 0E FF 75 0C 6A 00 E8 ?? ?? ?? ?? 59 59 EB 37 83 65 FC 00 8D 45 FC 56 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 CE FF EB 0F FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 59 8B F0 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "__wctomb_l"
		size = 83
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002c __wctomb_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 F0 50 8B 45 F0 FF 75 0C FF 70 04 8D 45 FC FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_5_0 {
	meta:
		name = "__wctomb_s_l"
		size = 289
		refs = "003a __errno 0044 __invalid_parameter_noinfo 0051 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 007c _memset 00d5 __imp__WideCharToMultiByte@32 00f1 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 8B 5D 0C 57 8B 7D 10 85 DB 75 12 85 FF 74 0E 8B 45 08 85 C0 74 03 83 20 00 33 C0 EB 7A 8B 45 08 85 C0 74 03 83 08 FF 56 81 FF FF FF FF 7F 76 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 53 FF 75 18 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 33 F6 39 B0 A8 00 00 00 75 5D 66 8B 45 14 B9 FF 00 00 00 66 3B C1 76 36 85 DB 74 0F 85 FF 74 0B 57 56 53 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 6A 2A 5E 89 30 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C6 5E 5F 5B 8B E5 5D C3 85 DB 74 06 85 FF 74 5F 88 03 8B 45 08 85 C0 74 D6 C7 00 01 00 00 00 EB CE 8D 4D FC 89 75 FC 51 56 57 53 6A 01 8D 4D 14 51 56 FF 70 08 FF 15 ?? ?? ?? ?? 8B C8 85 C9 74 10 39 75 FC 75 9F 8B 45 08 85 C0 74 A2 89 08 EB 9E FF 15 ?? ?? ?? ?? 83 F8 7A 75 89 85 DB 74 0F 85 FF 74 0B 57 56 53 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? E9 6C FF FF FF }
	condition:
		$1
}

rule file_91_6_0 {
	meta:
		name = "_wctomb"
		size = 52
		refs = "0010 ____mb_cur_max_func 001d __wctomb_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 6A 00 FF 75 0C E8 ?? ?? ?? ?? 50 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_12_0 {
	meta:
		name = "?compute_iso_week@@YAHHHH@Z"
		size = 78
		refs = "0013 ?compute_iso_week_internal@@YAHHHH@Z 0021 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 FF 75 10 8B 7D 0C 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 27 4E 56 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 2B 7D 10 81 C1 6D 01 00 00 83 C7 07 51 57 56 E8 ?? ?? ?? ?? 83 C4 10 EB 05 7F 03 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_92_13_0 {
	meta:
		name = "?compute_iso_week_internal@@YAHHHH@Z"
		size = 149
		refs = "0024 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 0C 57 6A 07 59 8D 46 06 99 F7 F9 8B 45 10 2B C2 03 C1 99 F7 F9 FF 75 08 8B D8 E8 ?? ?? ?? ?? 2B 75 10 59 0F B6 C8 6A 07 8D 86 73 01 00 00 8B 7D 10 99 2B F9 5E F7 FE 8D 81 6D 01 00 00 8B F2 03 C6 6A 07 99 59 F7 F9 81 FF 6C 01 00 00 7C 05 83 FA 02 74 1A 81 FF 6B 01 00 00 7C 05 83 FA 03 74 0D 81 FF 6A 01 00 00 7C 0A 83 FA 04 75 05 83 C8 FF EB 14 83 FE 02 74 0C 83 FE 03 74 07 8B C3 83 FE 04 75 03 8D 43 01 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_92_14_0 {
	meta:
		name = "?compute_iso_year@@YAHHHH@Z"
		size = 43
		refs = "0011 ?compute_iso_week_internal@@YAHHHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 10 8B 75 08 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 05 8D 46 FF EB 07 8B C6 7F 03 8D 46 01 5E 5D C3 }
	condition:
		$1
}

rule file_92_15_0 {
	meta:
		name = "?compute_week_of_year@@YAHHHH@Z"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 2B 45 08 6A 07 59 03 C1 99 F7 F9 8B 45 10 2B C2 03 C1 99 F7 F9 5D C3 }
	condition:
		$1
}

rule file_92_17_0 {
	meta:
		name = "?expand_time@@YA_NPAU__crt_locale_pointers@@_WPBUtm@@PAPA_WPAIPBU__crt_lc_time_data@@_N@Z"
		size = 2812
		refs = "008a ?store_number@@YAXHHQAPA_WQAI_W@Z 00fc ?compute_iso_year@@YAHHHH@Z 017d ___lc_time_c 01a4 ?expand_time@@YA_NPAU__crt_locale_pointers@@_WPBUtm@@PAPA_WPAIPBU__crt_lc_time_data@@_N@Z 01b0 __errno 01c2 ??_C@_13HOIJIPNN@?$AA?5?$AA?$AA@ 01c7 ?store_string@@YAXPB_WQAPA_WQAI@Z 027a ?store_winword@@YA_NQAU__crt_locale_pointers@@HQBUtm@@QAPA_WQAIQBU__crt_lc_time_data@@@Z 030b __invalid_parameter_noinfo 034c ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 03c0 ??_C@_13KDLDGPGJ@?$AA?7?$AA?$AA@ 03ff ??_C@_13EBCNDICG@?$AA?3?$AA?$AA@ 04dc ___tzset 04ea __get_timezone 0507 __get_dstbias 0535 ??_C@_13KJIIAINM@?$AA?$CL?$AA?$AA@ 0540 ??_C@_13IMODFHAA@?$AA?9?$AA?$AA@ 06ca ??_C@_13EJFHHPOP@?$AA?$CF?$AA?$AA@ 06fc ??_C@_13CGOKJPIL@?$AA?1?$AA?$AA@ 089a $LN193 09ff ?compute_iso_week@@YAHHHH@Z 0a6b ___tzname 0a92 __mbstowcs_s_l 0ad8 __invoke_watson 0adc $LN63 0ae0 $LN66 0ae4 $LN69 0ae8 $LN75 0aec $LN83 0af4 $LN86 0af8 $LN90"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 55 0C 53 0F B7 C2 56 57 83 F8 5A 0F 8E C6 05 00 00 83 F8 6E 0F 8F 33 03 00 00 0F 84 1D 03 00 00 83 F8 65 0F 8E E3 00 00 00 83 E8 67 0F 84 91 00 00 00 83 E8 01 75 07 6A 62 5A 52 58 EB D3 48 83 E8 01 74 4A 83 E8 03 0F 85 BA 02 00 00 8B 45 10 8B 48 10 85 C9 0F 88 9C 02 00 00 83 F9 0B 0F 8F 93 02 00 00 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 FF 75 14 6A 02 8D 41 01 50 E8 ?? ?? ?? ?? 83 C4 14 E9 33 0A 00 00 8B 45 10 8B 48 1C 85 C9 0F 88 5B 02 00 00 81 F9 6D 01 00 00 0F 8F 4F 02 00 00 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 FF 75 14 6A 03 EB BA 8B 45 10 81 78 14 94 F8 FF FF 0F 8C 24 02 00 00 81 78 14 A3 1F 00 00 0F 8F 17 02 00 00 6A 30 FF 75 18 FF 75 14 6A 02 FF 70 1C FF 70 18 FF 70 14 E8 ?? ?? ?? ?? 83 C4 0C 05 6C 07 00 00 6A 64 99 59 F7 F9 52 E9 75 FF FF FF 0F 84 FC 01 00 00 83 E8 61 0F 84 BB 01 00 00 83 E8 01 0F 84 86 01 00 00 83 E8 01 74 44 83 E8 01 0F 85 D5 01 00 00 8B 45 10 83 78 0C 01 0F 8C B8 01 00 00 83 78 0C 1F 0F 8F AE 01 00 00 80 7D 20 00 0F 95 C1 FE C9 80 E1 30 66 0F BE C9 0F B7 C9 51 FF 75 18 FF 75 14 6A 02 FF 70 0C E9 14 FF FF FF 8B 5D 1C 8B 4D 20 81 FB ?? ?? ?? ?? 0F 85 DD 00 00 00 84 C9 0F 85 D5 00 00 00 8B 7D 18 33 F6 56 53 8B 5D 14 57 53 FF 75 10 6A 61 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 50 01 00 00 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 FF 75 1C 57 53 FF 75 10 6A 62 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 74 CA 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 FF 75 1C 57 53 FF 75 10 6A 65 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 74 A4 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 FF 75 1C 57 53 FF 75 10 6A 54 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 7A FF FF FF 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 FF 75 1C 57 53 FF 75 10 6A 59 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 85 6A 08 00 00 E9 4B FF FF FF 53 FF 75 18 33 C0 84 C9 FF 75 14 0F 95 C0 FF 75 10 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 84 C0 0F 84 26 FF FF FF FF 75 18 FF 75 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 FF 75 18 FF 75 14 FF 75 10 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 24 EB A5 8B 45 10 8B 48 10 85 C9 78 43 83 F9 0B 7F 3E FF 75 18 8B 45 1C FF 75 14 FF B4 88 EC 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C E9 EB 07 00 00 8B 45 10 8B 48 18 85 C9 78 17 83 F9 06 7F 12 FF 75 18 8B 45 1C FF 75 14 FF B4 88 B4 00 00 00 EB D2 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 B5 07 00 00 8B 45 10 8B 48 0C 83 F9 01 7C DE 83 F9 1F 7F D9 80 7D 20 00 0F 95 C0 FE C8 24 20 66 98 0F B7 C0 50 FF 75 18 FF 75 14 6A 02 51 E9 44 FD FF FF FF 75 18 FF 75 14 68 ?? ?? ?? ?? E9 7C FF FF FF 83 F8 77 0F 8F 62 01 00 00 74 1A 83 E8 70 0F 84 1E 01 00 00 48 83 E8 01 74 5A 48 83 E8 01 74 44 83 E8 01 75 95 8B 45 10 8B 48 18 85 C9 0F 88 77 FF FF FF 83 F9 06 0F 8F 6E FF FF FF 85 C9 75 09 66 83 FA 75 75 03 6A 07 59 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 FF 75 14 6A 01 EB 86 FF 75 18 FF 75 14 68 ?? ?? ?? ?? E9 08 FF FF FF 8B 75 1C FF 75 20 56 81 FE ?? ?? ?? ?? 0F 85 90 00 00 00 8B 7D 18 8B 5D 14 57 53 FF 75 10 6A 49 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 0F 84 B3 FD FF FF 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 20 56 57 53 FF 75 10 6A 4D FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 89 FD FF FF 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 20 56 57 53 FF 75 10 6A 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 5F FD FF FF 57 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 20 56 57 53 FF 75 10 6A 70 E9 E0 FD FF FF FF 75 18 FF 75 14 FF 75 10 6A 58 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C E9 D0 FD FF FF 8B 45 10 8B 40 08 85 C0 0F 88 6A FE FF FF 83 F8 17 0F 8F 61 FE FF FF 83 F8 0B 8B 45 1C 7F 08 8B 80 4C 01 00 00 EB 06 8B 80 50 01 00 00 FF 75 18 FF 75 14 50 E9 11 FE FF FF 83 E8 78 0F 84 F1 00 00 00 83 E8 01 0F 84 A6 00 00 00 83 E8 01 0F 85 34 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC 33 F6 50 89 75 FC E8 ?? ?? ?? ?? 59 85 C0 0F 85 08 FE FF FF 8B 45 10 39 70 20 74 20 8D 45 F8 89 75 F8 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 EB FD FF FF 8B 4D FC 03 4D F8 89 4D FC EB 03 8B 4D FC 8B C1 99 33 C2 2B C2 99 6A 3C 5E F7 FE 99 F7 FE 85 C9 B9 ?? ?? ?? ?? 8B FA 8B F0 78 05 B9 ?? ?? ?? ?? FF 75 18 FF 75 14 51 E8 ?? ?? ?? ?? 6A 30 FF 75 18 FF 75 14 6A 02 56 E8 ?? ?? ?? ?? 6A 30 FF 75 18 FF 75 14 6A 02 57 E8 ?? ?? ?? ?? 83 C4 34 E9 51 05 00 00 8B 45 10 8B 48 14 81 F9 94 F8 FF FF 0F 8C 75 FD FF FF 81 F9 A3 1F 00 00 0F 8F 69 FD FF FF 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 8D 81 6C 07 00 00 FF 75 14 6A 02 E9 4E FB FF FF FF 75 1C 33 C0 FF 75 18 38 45 20 FF 75 14 0F 95 C0 FF 75 10 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 E9 78 FC FF FF 0F 84 7B 04 00 00 83 F8 4D 0F 8F 9B 02 00 00 0F 84 7F 02 00 00 83 F8 44 0F 8F 43 01 00 00 0F 84 D0 00 00 00 83 E8 25 0F 84 B7 00 00 00 83 E8 1C 0F 84 82 00 00 00 83 E8 01 74 51 83 E8 01 0F 85 EC FC FF FF 8B 45 10 8B 48 14 81 F9 94 F8 FF FF 0F 8C CA FC FF FF 81 F9 A3 1F 00 00 0F 8F BE FC FF FF 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 8D 81 6C 07 00 00 FF 75 14 99 6A 02 6A 64 59 F7 F9 E9 1D FA FF FF 8B 45 10 8B 48 10 85 C9 0F 88 86 FC FF FF 83 F9 0B 0F 8F 7D FC FF FF FF 75 18 8B 45 1C FF 75 14 FF B4 88 1C 01 00 00 E9 3A FC FF FF 8B 45 10 8B 48 18 85 C9 0F 88 5A FC FF FF 83 F9 06 0F 8F 51 FC FF FF FF 75 18 8B 45 1C FF 75 14 FF B4 88 D0 00 00 00 E9 0E FC FF FF FF 75 18 FF 75 14 68 ?? ?? ?? ?? E9 FE FB FF FF FF 75 20 8B 75 18 FF 75 1C 8B 7D 14 56 57 FF 75 10 6A 6D FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 0F 84 B6 FA FF FF 56 57 BB ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 64 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 89 FA FF FF 56 57 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 79 E9 0C FB FF FF 83 E8 46 0F 84 BD 00 00 00 83 E8 01 74 76 83 E8 01 74 4A 83 E8 01 0F 85 B3 FB FF FF 8B 45 10 8B 40 08 85 C0 0F 88 95 FB FF FF 83 F8 17 0F 8F 8C FB FF FF 6A 0C 99 59 F7 F9 85 D2 75 02 8B D1 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 FF 75 14 6A 02 E9 71 F9 FF FF 8B 45 10 8B 48 08 85 C9 0F 88 54 FB FF FF 83 F9 17 0F 8F 4B FB FF FF 80 7D 20 00 0F 95 C0 FE C8 24 30 E9 6D FB FF FF 8B 45 10 81 78 14 94 F8 FF FF 0F 8C 2B FB FF FF 81 78 14 A3 1F 00 00 0F 8F 1E FB FF FF 6A 30 FF 75 18 FF 75 14 6A 04 FF 70 1C FF 70 18 FF 70 14 E8 ?? ?? ?? ?? 83 C4 0C 05 6C 07 00 00 E9 82 F8 FF FF FF 75 20 8B 75 18 FF 75 1C 8B 7D 14 56 57 FF 75 10 6A 59 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 0F 84 83 F9 FF FF 56 57 BB ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 6D FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 56 F9 FF FF 56 57 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 64 E9 D9 F9 FF FF 8B 45 10 8B 48 04 85 C9 0F 88 7E FA FF FF 83 F9 3B E9 25 FF FF FF 6A 07 83 E8 52 5F 3B C7 0F 87 78 FA FF FF FF 24 85 ?? ?? ?? ?? FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 6A 48 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 0F 84 ED F8 FF FF FF 75 18 FF 75 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 6A 4D E9 64 F9 FF FF 8B 45 10 8B 08 85 C9 0F 88 0A FA FF FF 83 F9 3C E9 B1 FE FF FF FF 75 20 8B 75 18 FF 75 1C 8B 7D 14 56 57 FF 75 10 6A 48 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 0F 84 8C F8 FF FF 56 57 BB ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 4D FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 84 C0 0F 84 5F F8 FF FF 56 57 53 E8 ?? ?? ?? ?? FF 75 20 FF 75 1C 56 57 FF 75 10 6A 53 E9 E2 F8 FF FF 8B 45 10 8B 48 18 85 C9 0F 88 87 F9 FF FF 83 F9 06 0F 8F 7E F9 FF FF 66 83 FA 57 75 0A 85 C9 75 05 6A 06 59 EB 01 49 8B 40 1C 85 C0 0F 88 63 F9 FF FF 3D 6D 01 00 00 0F 8F 58 F9 FF FF 33 F6 3B C1 7C 0A 99 F7 FF 8B F0 3B D1 7C 01 46 80 7D 20 00 0F 95 C1 FE C9 80 E1 30 66 0F BE C1 0F B7 C0 50 FF 75 18 FF 75 14 6A 02 56 E9 B0 F6 FF FF 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 8B 45 10 FF 75 14 6A 02 FF 70 1C FF 70 18 FF 70 14 E8 ?? ?? ?? ?? 83 C4 0C E9 7D F6 FF FF FF 75 1C FF 75 18 FF 75 14 FF 75 10 6A 02 E9 B1 FB FF FF 8B 45 10 8B 48 14 81 F9 94 F8 FF FF 0F 8C CF F8 FF FF 81 F9 A3 1F 00 00 0F 8F C3 F8 FF FF 80 7D 20 00 0F 95 C0 FE C8 24 30 66 98 0F B7 C0 50 FF 75 18 8D 81 6C 07 00 00 FF 75 14 6A 04 E9 28 F6 FF FF E8 ?? ?? ?? ?? 33 F6 89 75 F8 E8 ?? ?? ?? ?? 8B 4D 10 33 D2 FF 75 08 8B 7D 18 8B 5D 14 39 71 20 6A FF 0F 95 C2 8B 04 90 50 FF 37 8D 45 F8 FF 33 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0A 83 F8 16 74 30 83 F8 22 74 2B 83 F8 50 75 0A 8B 07 03 C0 01 03 89 37 EB 13 8B 4D F8 33 C0 40 2B C1 01 07 8D 04 4D FE FF FF FF 01 03 B0 01 5F 5E 5B 8B E5 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_21_0 {
	meta:
		name = "?store_number@@YAXHHQAPA_WQAI_W@Z"
		size = 162
		refs = "0019 ?store_number_without_lead_zeroes@@YAXHQAPA_WQAI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 66 83 7D 18 00 75 13 FF 75 14 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 7C 8B 45 0C 56 8B 75 14 3B 06 73 6D 53 33 DB 48 57 8B 7D 10 8D 48 01 89 4D F4 85 C9 74 50 8B 4D 08 03 C0 66 8B 75 18 89 45 FC 89 4D F8 85 C9 74 16 8B C1 6A 0A 99 59 F7 F9 8B 07 8B 4D FC 83 C2 30 66 89 14 01 EB 06 8B 0F 66 89 34 08 8B 45 F8 99 6A 0A 59 F7 F9 43 8B C8 8B 45 FC 83 E8 02 89 4D F8 83 6D F4 01 89 45 FC 75 C2 8B 75 14 8D 04 1B 01 07 29 1E 5F 5B EB 03 83 26 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_22_0 {
	meta:
		name = "?store_number_without_lead_zeroes@@YAXHQAPA_WQAI@Z"
		size = 103
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 10 57 8B 7D 0C 8B 06 8B 0F 83 F8 01 76 44 53 8B 5D 08 8B C3 6A 0A 99 5B F7 FB 8B D8 8D 42 30 66 89 01 83 C1 02 FF 0E 85 DB 7E 05 83 3E 01 77 E2 8B 17 8D 71 FE 89 0F 5B EB 12 66 8B 02 0F B7 0E 66 89 06 83 EE 02 66 89 0A 83 C2 02 3B D6 72 EA EB 09 03 C0 2B C8 89 0F 83 26 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_92_23_0 {
	meta:
		name = "?store_string@@YAXPB_WQAPA_WQAI@Z"
		size = 49
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 83 39 00 74 22 8B 55 08 56 8B 75 0C 57 0F B7 3A 66 85 FF 74 10 8B 06 83 C2 02 66 89 38 83 06 02 83 29 01 75 E8 5F 5E 5D C3 }
	condition:
		$1
}

rule file_92_24_0 {
	meta:
		name = "?store_winword@@YA_NQAU__crt_locale_pointers@@HQBUtm@@QAPA_WQAIQBU__crt_lc_time_data@@@Z"
		size = 1135
		refs = "0009 ___security_cookie 00be ___acrt_GetTimeFormatEx@24 00d3 ___acrt_GetDateFormatEx@28 0109 __alloca_probe_16 012d __malloc_base 01b3 __freea_crt 01c6 @__security_check_cookie@4 0234 ??_C@_1M@PBPMMENC@?$AAa?$AAm?$AA?1?$AAp?$AAm?$AA?$AA@ 023a __wcsicmp 0298 ??_C@_17BLFJJHMM@?$AAa?$AA?1?$AAp?$AA?$AA@ 043e ?expand_time@@YA_NPAU__crt_locale_pointers@@_WPBUtm@@PAPA_WPAIPBU__crt_lc_time_data@@_N@Z 045e __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 55 10 89 45 D0 8B 45 14 53 8B 5D 1C 89 45 D8 8B 45 0C 89 55 D4 89 5D DC 56 8B 75 18 89 75 E4 57 83 E8 00 74 15 83 E8 01 74 08 8B BB 5C 01 00 00 EB 0E 8B BB 58 01 00 00 EB 06 8B BB 54 01 00 00 83 BB AC 00 00 00 01 0F 84 E9 03 00 00 83 7D 0C 02 B8 6C 07 00 00 0F 94 C1 66 03 42 14 66 89 45 EC 66 8B 42 10 66 40 88 4D E3 66 89 45 EE 66 8B 42 0C 66 89 45 F2 66 8B 42 08 66 89 45 F4 66 8B 42 04 66 89 45 F6 66 8B 02 66 89 45 F8 33 C0 66 89 45 FA 8D 45 EC 84 C9 74 14 33 C9 51 51 57 50 51 FF B3 60 01 00 00 E8 ?? ?? ?? ?? EB 13 33 C9 51 51 51 57 50 51 FF B3 60 01 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 6B 03 00 00 8D 14 1B 8D 4A 08 3B D1 1B C0 85 C1 74 58 8D 4A 08 3B D1 1B C0 23 C1 8D 4A 08 3D 00 04 00 00 77 23 3B D1 1B C0 23 C1 E8 ?? ?? ?? ?? 8B F4 89 75 E8 85 F6 0F 84 B4 00 00 00 C7 06 CC CC 00 00 83 C6 08 EB 24 3B D1 1B C0 23 C1 50 E8 ?? ?? ?? ?? 8B F0 89 75 E8 59 85 F6 0F 84 8F 00 00 00 C7 06 DD DD 00 00 EB D9 33 F6 89 75 E8 85 F6 74 7E 80 7D E3 00 8D 45 EC 74 16 53 56 57 50 8B 45 DC 6A 00 FF B0 60 01 00 00 E8 ?? ?? ?? ?? EB 16 6A 00 53 56 57 50 8B 45 DC 6A 00 FF B0 60 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B FE 4A 85 D2 7E 23 8B 5D E4 8B 75 D8 83 3B 00 76 15 8B 0E 66 8B 07 83 C7 02 66 89 01 83 06 02 FF 0B 4A 85 D2 7F E6 8B 75 E8 56 E8 ?? ?? ?? ?? 59 B0 01 8D 65 C4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 6A 00 E8 ?? ?? ?? ?? 8B 75 E4 59 E9 6E 02 00 00 83 3E 00 74 D5 C6 45 E4 00 33 C9 89 7D E8 8B DF 0F B7 C2 83 C3 02 41 66 39 03 74 F7 0F B7 C2 89 5D E8 8B 5D DC 83 F8 64 0F 8F 2F 01 00 00 0F 84 F8 00 00 00 83 F8 27 0F 84 9A 00 00 00 83 F8 41 74 13 83 F8 48 74 58 83 F8 4D 74 22 83 F8 61 0F 85 E2 01 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 53 8D 4F 0A 89 4D E8 EB 62 83 E9 01 74 21 83 E9 01 74 20 83 E9 01 74 10 83 E9 01 0F 85 B1 01 00 00 6A 42 E9 C2 01 00 00 6A 62 E9 BB 01 00 00 C6 45 E4 01 6A 6D E9 B0 01 00 00 83 E9 01 74 0A 83 E9 01 74 09 E9 89 01 00 00 C6 45 E4 01 6A 48 E9 96 01 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 8D 47 06 89 45 E8 6A 70 E9 78 01 00 00 8B C1 25 01 00 00 80 79 05 48 83 C8 FE 40 8D 3C 4F 0F 84 80 01 00 00 0F B7 0F 66 85 C9 0F 84 E0 FE FF FF 8B 55 D8 83 3E 00 0F 84 68 01 00 00 6A 27 58 83 C7 02 66 3B C8 0F 84 59 01 00 00 8B 02 66 89 08 83 02 02 FF 0E 0F B7 0F 66 85 C9 75 D6 E9 42 01 00 00 83 E9 01 74 21 83 E9 01 74 20 83 E9 01 74 10 83 E9 01 0F 85 F3 00 00 00 6A 41 E9 04 01 00 00 6A 61 E9 FD 00 00 00 C6 45 E4 01 6A 64 E9 F2 00 00 00 83 E8 68 0F 84 C7 00 00 00 83 E8 05 0F 84 AA 00 00 00 83 E8 06 0F 84 8D 00 00 00 83 E8 01 74 27 83 E8 05 0F 85 B1 00 00 00 49 83 E9 01 74 11 49 83 E9 01 0F 85 A1 00 00 00 6A 59 E9 B2 00 00 00 6A 79 E9 AB 00 00 00 8B 45 D4 83 78 08 0B 7F 08 8B 93 4C 01 00 00 EB 06 8B 93 50 01 00 00 83 F9 01 75 1A 83 3E 00 76 15 8B 7D D8 66 8B 02 8B 0F 66 89 01 83 07 02 FF 0E E9 91 00 00 00 0F B7 0A 66 85 C9 0F 84 85 00 00 00 8B 5D D8 83 3E 00 76 7D 8B 03 83 C2 02 66 89 08 83 03 02 FF 0E 0F B7 0A 66 85 C9 75 E6 EB 66 83 E9 01 74 07 83 E9 01 74 06 EB 26 C6 45 E4 01 6A 53 EB 36 83 E9 01 74 07 83 E9 01 74 06 EB 12 C6 45 E4 01 6A 4D EB 22 83 E9 01 74 17 83 E9 01 74 16 8B 4D D8 83 C7 02 8B 01 66 89 10 83 01 02 FF 0E EB 25 C6 45 E4 01 6A 49 58 FF 75 E4 53 56 FF 75 D8 FF 75 D4 50 FF 75 D0 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 74 14 8B 7D E8 0F B7 17 66 85 D2 0F 85 86 FD FF FF E9 5B FD FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 32 C0 E9 4B FD FF FF }
	condition:
		$1
}

rule file_92_27_0 {
	meta:
		name = "__W_Getdays"
		size = 353
		refs = "0015 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0077 __malloc_base 00ad _wcscpy_s 0136 __free_base 015c __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 57 33 DB 8D 4D E4 53 89 5D FC E8 ?? ?? ?? ?? 8B 45 E8 6A 07 5F 8B 80 9C 00 00 00 05 D0 00 00 00 89 45 F8 8B F0 8B 56 E4 8D 4A 02 66 8B 02 83 C2 02 66 3B 45 FC 75 F4 2B D1 8B 0E D1 FA 8D 41 02 89 45 F4 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 2B 4D F4 83 C3 02 D1 F9 83 C6 04 8D 04 11 03 D8 83 EF 01 75 C1 8D 04 5D 02 00 00 00 50 E8 ?? ?? ?? ?? 8B F8 33 C0 59 85 FF 75 07 8B F8 E9 A9 00 00 00 6A 3A 89 45 F4 8B F7 8B 45 F8 59 66 89 0E 83 C6 02 FF 70 E4 8B CE 8B C3 2B CF D1 F9 2B C1 40 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 98 00 00 00 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 2B CA D1 F9 6A 3A 58 8D 34 4E 66 89 06 83 C6 02 8B 45 F8 8B CE 2B CF D1 F9 FF 30 8B C3 2B C1 40 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 59 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 8B 45 F8 2B CA D1 F9 83 C0 04 6A 3A 89 45 F8 8D 34 4E 8B 4D F4 41 89 4D F4 83 F9 07 59 0F 82 67 FF FF FF 33 C0 66 89 06 50 E8 ?? ?? ?? ?? 80 7D F0 00 59 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C7 5F 5E 5B 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_92_28_0 {
	meta:
		name = "__W_Getmonths"
		size = 353
		refs = "0015 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0077 __malloc_base 00ad _wcscpy_s 0136 __free_base 015c __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 57 33 DB 8D 4D E4 53 89 5D FC E8 ?? ?? ?? ?? 8B 45 E8 6A 0C 5F 8B 80 9C 00 00 00 05 1C 01 00 00 89 45 F8 8B F0 8B 56 D0 8D 4A 02 66 8B 02 83 C2 02 66 3B 45 FC 75 F4 2B D1 8B 0E D1 FA 8D 41 02 89 45 F4 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 2B 4D F4 83 C3 02 D1 F9 83 C6 04 8D 04 11 03 D8 83 EF 01 75 C1 8D 04 5D 02 00 00 00 50 E8 ?? ?? ?? ?? 8B F8 33 C0 59 85 FF 75 07 8B F8 E9 A9 00 00 00 6A 3A 89 45 F4 8B F7 8B 45 F8 59 66 89 0E 83 C6 02 FF 70 D0 8B CE 8B C3 2B CF D1 F9 2B C1 40 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 98 00 00 00 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 2B CA D1 F9 6A 3A 58 8D 34 4E 66 89 06 83 C6 02 8B 45 F8 8B CE 2B CF D1 F9 FF 30 8B C3 2B C1 40 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 59 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 8B 45 F8 2B CA D1 F9 83 C0 04 6A 3A 89 45 F8 8D 34 4E 8B 4D F4 41 89 4D F4 83 F9 0C 59 0F 82 67 FF FF FF 33 C0 66 89 06 50 E8 ?? ?? ?? ?? 80 7D F0 00 59 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C7 5F 5E 5B 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_92_29_0 {
	meta:
		name = "__W_Gettnames"
		size = 1790
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 003b __malloc_base 004f _memset 008a _strcpy_s 0353 _wcscpy_s 06f9 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 56 57 33 F6 8D 4D D8 56 E8 ?? ?? ?? ?? 8B 45 DC 8B D6 89 75 F0 BF 64 01 00 00 89 55 F8 53 8B 88 9C 00 00 00 8B C6 89 4D FC 89 45 F4 83 FA 01 75 2B 57 E8 ?? ?? ?? ?? 89 45 F4 59 85 C0 0F 84 8F 06 00 00 57 56 50 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 0C 8B 4D FC 89 7D F0 BF 64 01 00 00 8B D6 89 45 EC 29 4D EC 8B D9 89 55 E8 83 7D F8 01 75 25 8D 0C 38 8B 45 EC 89 0C 18 FF 33 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 5A 06 00 00 8B 55 E8 8B 0B 8D 41 01 89 45 E8 8A 01 41 84 C0 75 F9 2B 4D E8 47 8B 45 F4 03 F9 42 83 C3 04 89 55 E8 83 FA 07 72 B1 8B 5D FC 8B D6 89 55 E8 83 C3 1C 83 7D F8 01 75 27 8B 45 EC 8B 4D F4 03 CF 89 0C 03 FF 33 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 FE 05 00 00 8B 55 E8 8B 0B 8D 41 01 89 45 E8 8A 01 41 84 C0 75 F9 2B 4D E8 47 03 F9 83 C3 04 42 89 55 E8 83 FA 07 72 B2 8B 5D FC 8B D6 89 55 E8 83 C3 38 83 7D F8 01 75 27 8B 45 EC 8B 4D F4 03 CF 89 0C 03 FF 33 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 A5 05 00 00 8B 55 E8 8B 0B 8D 41 01 89 45 E8 8A 01 41 84 C0 75 F9 2B 4D E8 47 03 F9 83 C3 04 42 89 55 E8 83 FA 0C 72 B2 8B 5D FC 8B D6 89 55 E8 83 C3 68 83 7D F8 01 75 27 8B 45 EC 8B 4D F4 03 CF 89 0C 03 FF 33 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 4C 05 00 00 8B 55 E8 8B 0B 8D 41 01 89 45 E8 8A 01 41 84 C0 75 F9 2B 4D E8 47 03 F9 83 C3 04 42 89 55 E8 83 FA 0C 72 B2 8B 5D FC 8B D6 89 55 E8 81 C3 98 00 00 00 83 7D F8 01 75 27 8B 45 EC 8B 4D F4 03 CF 89 0C 03 FF 33 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 F0 04 00 00 8B 55 E8 8B 0B 8D 41 01 89 45 E8 8A 01 41 84 C0 75 F9 2B 4D E8 47 03 F9 83 C3 04 42 89 55 E8 83 FA 02 72 B2 83 7D F8 01 8B 5D F4 75 29 8B 45 FC 8D 0C 3B 89 8B A0 00 00 00 FF B0 A0 00 00 00 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 9A 04 00 00 8B 45 FC 8B 88 A0 00 00 00 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 47 03 F9 83 7D F8 01 75 29 8B 45 FC 8D 0C 3B 89 8B A4 00 00 00 FF B0 A4 00 00 00 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 53 04 00 00 8B 45 FC 8B 88 A4 00 00 00 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 47 03 F9 83 7D F8 01 75 29 8B 45 FC 8D 0C 3B 89 8B A8 00 00 00 FF B0 A8 00 00 00 8B 45 F0 2B C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 0C 04 00 00 8B 45 FC 8B 88 A8 00 00 00 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 8B 55 F8 8D 59 01 8B 4D F4 03 DF 83 FA 01 75 15 8B 45 FC 8B 80 AC 00 00 00 89 81 AC 00 00 00 89 B1 B0 00 00 00 8B 7D FC 89 75 E8 81 C7 B4 00 00 00 EB 01 43 F6 C3 01 75 FA 83 FA 01 75 28 8B C3 D1 E8 8D 0C 41 8B 45 EC 89 0C 07 8B 45 F0 FF 37 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 91 03 00 00 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 8B 45 E8 2B CA 8B 55 F8 83 C7 04 D1 F9 8D 1C 4B 8B 4D F4 83 C3 02 40 89 45 E8 83 F8 07 72 9F 8B 7D FC 89 75 E8 81 C7 D0 00 00 00 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2B 8B 4D F4 8B C3 D1 E8 8D 0C 41 8B 45 EC 89 0C 07 8B 45 F0 FF 37 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 1D 03 00 00 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 8B 45 E8 2B CA D1 F9 83 C7 04 8D 1C 4B 83 C3 02 40 89 45 E8 83 F8 07 72 A1 8B 7D FC 89 75 E8 81 C7 EC 00 00 00 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2B 8B 4D F4 8B C3 D1 E8 8D 0C 41 8B 45 EC 89 0C 07 8B 45 F0 FF 37 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 AF 02 00 00 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 8B 45 E8 2B CA D1 F9 83 C7 04 8D 1C 4B 83 C3 02 40 89 45 E8 83 F8 0C 72 A1 8B 7D FC 89 75 E8 81 C7 1C 01 00 00 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2B 8B 4D F4 8B C3 D1 E8 8D 0C 41 8B 45 EC 89 0C 07 8B 45 F0 FF 37 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 41 02 00 00 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 8B 45 E8 2B CA D1 F9 83 C7 04 8D 1C 4B 83 C3 02 40 89 45 E8 83 F8 0C 72 A1 8B 7D FC 89 75 E8 81 C7 4C 01 00 00 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2B 8B 4D F4 8B C3 D1 E8 8D 0C 41 8B 45 EC 89 0C 07 8B 45 F0 FF 37 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 D3 01 00 00 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 8B 45 E8 2B CA D1 F9 83 C7 04 8D 1C 4B 83 C3 02 40 89 45 E8 83 F8 02 72 A1 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 8B 7D F4 75 2F 8B C3 D1 E8 8D 0C 47 8B 45 FC 89 8F 54 01 00 00 FF B0 54 01 00 00 8B 45 F0 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 6A 01 00 00 8B 45 FC 8B 88 54 01 00 00 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 2B CA D1 F9 8D 1C 4B 83 C3 02 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2F 8B C3 D1 E8 8D 0C 47 8B 45 FC 89 8F 58 01 00 00 FF B0 58 01 00 00 8B 45 F0 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 0C 01 00 00 8B 45 FC 8B 88 58 01 00 00 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 2B CA D1 F9 8D 1C 4B 83 C3 02 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2F 8B C3 D1 E8 8D 0C 47 8B 45 FC 89 8F 5C 01 00 00 FF B0 5C 01 00 00 8B 45 F0 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 AE 00 00 00 8B 45 FC 8B 88 5C 01 00 00 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 2B CA D1 F9 8D 1C 4B 83 C3 02 EB 01 43 F6 C3 01 75 FA 83 7D F8 01 75 2B 8B C3 D1 E8 8D 0C 47 8B 45 FC 89 8F 60 01 00 00 FF B0 60 01 00 00 8B 45 F0 2B C3 D1 E8 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 54 8B 45 FC 8B 88 60 01 00 00 8D 51 02 66 8B 01 83 C1 02 66 3B C6 75 F5 2B CA 8B 55 F8 D1 F9 42 89 55 F8 8D 79 01 8D 3C 7B 83 FA 02 7D 0B 8B 45 F4 8B 4D FC E9 5D F9 FF FF 8B 75 F4 80 7D E4 00 5B 74 0A 8B 4D D8 83 A1 50 03 00 00 FD 5F 8B C6 5E 8B E5 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_92_30_0 {
	meta:
		name = "__Wcsftime"
		size = 32
		refs = "0017 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_700_19_0 {
	meta:
		name = "__Strftime"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_734_21_0 {
	meta:
		name = "__ui64toa_s"
		size = 32
		refs = "0017 ??$common_xtox_s@_KD@@YAH_KQADII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_734_23_4 {
	meta:
		name = "__ui64tow_s"
		size = 32
		refs = "0017 ??$common_xtox_s@_K_W@@YAH_KQA_WII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_457_8_0 {
	meta:
		name = "_mbstowcs_s"
		size = 32
		refs = "0017 __mbstowcs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_399_9_4 {
	meta:
		name = "_wcstombs_s"
		size = 32
		refs = "0017 __wcstombs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_92_31_0 {
	meta:
		name = "__Wcsftime_l"
		size = 385
		refs = "0011 __errno 001c __invalid_parameter_noinfo 0058 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0104 ?expand_time@@YA_NPAU__crt_locale_pointers@@_WPBUtm@@PAPA_WPAIPBU__crt_lc_time_data@@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 57 8B 7D 08 85 FF 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 55 01 00 00 83 7D 0C 00 74 E3 56 8B 75 10 33 C0 66 89 07 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 2A 01 00 00 FF 75 1C 8D 4D DC E8 ?? ?? ?? ?? 8B 55 18 85 D2 75 0C 8B 45 E0 8B 90 9C 00 00 00 89 55 18 8B 45 0C 8B CF 53 33 DB 89 4D F4 89 45 F8 85 C0 0F 86 B7 00 00 00 0F B7 3E 89 7D F0 0F B7 FF 85 FF 8B 7D 08 0F 84 8A 00 00 00 8B 7D F0 66 83 FF 25 8B 7D 08 74 1B 8B 45 F0 83 C6 02 66 89 01 8B 4D F4 8B 45 F8 83 C1 02 48 89 4D F4 89 45 F8 EB 58 39 5D 14 0F 84 8F 00 00 00 83 C6 02 88 5D EC 66 83 3E 23 75 07 C6 45 EC 01 83 C6 02 0F B7 06 83 F8 45 74 05 83 F8 4F 75 03 83 C6 02 FF 75 EC 8D 45 F8 52 50 8D 45 F4 50 FF 75 14 0F B7 06 50 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 84 C0 8B 45 F8 74 22 8B 4D F4 83 C6 02 8B 55 18 85 C0 0F 85 62 FF FF FF 85 C0 74 15 8B 5D 0C 33 C0 66 89 01 2B 5D F8 EB 34 85 C0 74 04 B1 01 EB 02 8A CB 33 D2 66 89 17 84 C9 75 11 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D E8 00 74 0A 8B 4D DC 83 A1 50 03 00 00 FD 8B C3 5B 5E 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_36_0 {
	meta:
		name = "__wcsftime_l"
		size = 32
		refs = "0017 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_700_23_0 {
	meta:
		name = "__strftime_l"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_92_37_0 {
	meta:
		name = "_wcsftime"
		size = 31
		refs = "0016 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_700_24_0 {
	meta:
		name = "_strftime"
		size = 31
		refs = "0016 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_93_5_0 {
	meta:
		name = "__mbsnbset_l"
		size = 197
		refs = "0018 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002e __strnset 0045 __errno 0050 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 8B 75 08 8D 4D EC 57 FF 75 14 89 75 FC E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 13 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 73 8B 7D 10 85 F6 75 16 85 FF 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 56 8B 4D 0C 8B D1 C1 EA 08 84 D2 74 43 84 C9 75 2C E8 ?? ?? ?? ?? B2 20 8A CA C7 00 16 00 00 00 EB 1B 38 1E 74 2E 8D 47 FF 83 EF 02 85 C0 74 13 38 5E 01 74 0E 88 16 88 4E 01 83 C6 02 85 FF 75 E1 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 0E 46 85 FF 75 F4 8B 5D FC 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_5_0 {
	meta:
		name = "__mbsnset_l"
		size = 322
		refs = "001d ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002d __errno 0038 __invalid_parameter_noinfo 004f __strnset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B 75 08 8D 4D E4 57 FF 75 14 33 FF 89 75 F4 89 7D FC E8 ?? ?? ?? ?? 8B 5D 10 85 F6 75 19 85 DB 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 E8 00 00 00 8B 4D EC 39 79 08 75 14 53 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E9 CC 00 00 00 8B 45 0C 8B D0 C1 EA 08 89 45 F8 84 D2 74 7F 84 C0 75 13 E8 ?? ?? ?? ?? B2 20 88 55 F8 C7 00 16 00 00 00 8B 4D EC 85 DB 0F 84 9B 00 00 00 8A 06 4B 84 C0 0F 84 83 00 00 00 39 7D FC 75 12 0F B6 C0 F6 44 08 19 04 74 08 33 C0 40 89 45 FC EB 05 8B C7 89 7D FC 88 16 46 8A 0E 84 C9 74 23 85 C0 75 14 0F B6 C1 8B 4D EC C7 45 FC 01 00 00 00 F6 44 08 19 04 75 03 89 7D FC 8B 45 F8 88 06 46 EB 04 C6 46 FF 20 8B 4D EC 85 DB 75 A2 EB 2E 85 DB 74 37 8A 06 4B 84 C0 74 23 39 7D FC 75 11 0F B6 C0 C7 45 FC 01 00 00 00 F6 44 08 19 04 75 03 89 7D FC 8B 45 0C 88 06 46 85 DB 75 D6 39 7D FC 74 08 80 3E 00 74 03 C6 06 20 8B 7D F4 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "__mbspbrk_l"
		size = 209
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0027 _strpbrk 0043 __errno 004e __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 57 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 5D F4 33 F6 39 73 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 E9 84 00 00 00 8B 4D 08 85 C9 74 07 8B 7D 0C 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 64 80 39 00 74 56 8A 07 8B D7 84 C0 74 31 8B 75 F4 8A 1A 0F B6 C3 F6 44 30 19 04 74 15 3A 19 75 08 8A 42 01 3A 41 01 74 13 80 7A 01 00 74 0D 42 EB 04 3A 19 74 06 42 80 3A 00 75 D5 8B 5D F4 80 3A 00 75 18 0F B6 01 F6 44 18 19 04 74 06 41 80 39 00 74 08 8A 07 41 80 39 00 75 AC 0F B6 31 F7 DE 1B F6 23 F1 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "__stricoll"
		size = 38
		refs = "0007 ___acrt_locale_changed_data 0010 __stricmp 001d __stricoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "__stricoll_l"
		size = 149
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0023 __errno 002e __invalid_parameter_noinfo 0044 __stricmp 0060 ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 56 FF 75 10 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 07 8B 45 0C 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 42 8B 55 F4 8B B2 A4 00 00 00 85 F6 75 0B 50 51 E8 ?? ?? ?? ?? 59 59 EB 34 FF 72 10 6A FF 50 6A FF 51 68 01 10 00 00 8D 45 F4 56 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7D FC 00 5E 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "_fmaxl"
		size = 93
		refs = "000b __ldtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 59 6A 02 5E 66 3B C6 75 05 DD 45 10 EB 3D 8D 45 10 50 E8 ?? ?? ?? ?? 59 66 3B C6 75 05 DD 45 08 EB 29 DD 45 10 DD 45 08 D8 D1 DF E0 F6 C4 05 7B 18 DD E1 DF E0 F6 C4 44 7A 0B B8 00 80 00 00 66 85 45 0E 75 04 DD D9 EB 02 DD D8 5E 5D C3 }
	condition:
		$1
}

rule file_691_0_0 {
	meta:
		name = "_fmax"
		size = 93
		refs = "000b __dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 59 6A 02 5E 66 3B C6 75 05 DD 45 10 EB 3D 8D 45 10 50 E8 ?? ?? ?? ?? 59 66 3B C6 75 05 DD 45 08 EB 29 DD 45 10 DD 45 08 D8 D1 DF E0 F6 C4 05 7B 18 DD E1 DF E0 F6 C4 44 7A 0B B8 00 80 00 00 66 85 45 0E 75 04 DD D9 EB 02 DD D8 5E 5D C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "_nextafter"
		size = 31
		refs = "0016 _nexttoward"
		altNames = "_nextafterl"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_504_8_0 {
	meta:
		name = "__nextafter"
		size = 31
		refs = "0016 _nextafter"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_1_0 {
	meta:
		name = "_hypotl"
		size = 31
		refs = "0016 __hypot"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 202
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 8B 4A 20 8B 42 10 33 01 83 E0 03 31 01 8B 4A 20 8B 42 14 C1 E0 02 33 01 83 E0 1C 31 01 8B 4A 20 8B 02 C1 E8 05 F7 D0 33 41 08 83 E0 01 31 41 08 8B 4A 20 8B 02 C1 E8 03 F7 D0 33 41 08 83 E0 02 31 41 08 8B 4A 20 8B 02 D1 E8 F7 D0 33 41 08 83 E0 04 31 41 08 8B 4A 20 8B 02 03 C0 F7 D0 33 41 08 83 E0 08 31 41 08 8B 02 8B 4A 20 C1 E0 04 F7 D0 33 41 08 83 E0 10 31 41 08 8B 42 20 83 60 0C FE 8B 42 20 83 60 0C FD 8B 42 20 83 60 0C FB 8B 42 20 83 60 0C F7 8B 42 20 83 60 0C EF 8B 42 20 83 60 04 FE 8B 42 20 83 60 04 FD 8B 42 20 83 60 04 FB 8B 42 20 83 60 04 F7 8B 42 20 83 60 04 EF 5D C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "_RoundDoubleToIntegral"
		size = 659
		refs = "0014 _fp64_is_qnan 0067 _fp64_is_denormal 00a6 __aullshr 00b0 __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 10 83 EC 18 53 8B 5D 0C 56 57 52 53 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 62 02 00 00 8B CA B8 FF 07 00 00 C1 E9 14 BE FF FF 0F 00 23 C8 75 0C 85 D6 75 08 85 DB 0F 84 43 02 00 00 3B C8 75 0C 85 D6 75 08 85 DB 0F 84 33 02 00 00 81 F9 33 04 00 00 72 0B 8B 4D 14 83 21 00 E9 26 02 00 00 52 53 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 8B 01 00 00 81 F9 FF 03 00 00 0F 82 7F 01 00 00 8B DA 8D 81 01 FC FF FF 23 DE 89 45 F0 6A 34 5E 33 FF 2B F0 0B 7D 0C 81 CB 00 00 10 00 8B C7 8B D3 8B CE E8 ?? ?? ?? ?? 8B CE 89 45 E8 E8 ?? ?? ?? ?? 8B 75 F0 89 45 FC 8B C7 89 55 F8 8B D3 8D 4E 0C E8 ?? ?? ?? ?? 8D 4E 0C E8 ?? ?? ?? ?? 8B F8 8B C2 8B CF 89 45 F4 0B C8 74 0B 8B 4D 14 C7 01 01 00 00 00 EB 06 8B 45 14 83 20 00 6A 33 59 8B DE 3B D9 75 0A 33 C9 41 33 C0 89 45 EC EB 13 33 C0 2B CB 40 33 D2 E8 ?? ?? ?? ?? 8B C8 89 55 EC 8B C2 8B D1 BE 00 00 00 80 0F A4 D0 01 03 D2 83 7D 08 00 0F 85 98 00 00 00 8B 5D F4 3B 5D EC 8B 5D F0 77 2E 72 04 3B F9 73 2A 8B 45 F8 8B 4D 10 8D 93 FF 03 00 00 25 FF FF 0F 00 C1 E2 14 23 CE 81 E2 00 00 F0 7F 0B D0 8B 45 FC 0B D1 E9 27 01 00 00 3B F9 75 39 8B 4D F4 3B 4D EC 75 31 F6 45 E8 01 75 08 8B 45 FC 89 45 FC EB BE 03 55 FC 89 55 FC 13 45 F8 85 D2 75 B4 8B 4D 10 3D 00 00 20 00 75 AD 83 65 FC 00 B8 00 00 10 00 43 EB A1 03 55 FC 89 55 FC 13 45 F8 85 D2 75 91 3D 00 00 20 00 75 8A 21 55 FC B8 00 00 10 00 43 E9 7C FF FF FF 83 7D 08 01 8B 4D 10 75 1C 85 CE 74 22 0B 7D F4 74 1D 03 55 FC 89 55 FC 13 45 F8 85 D2 0F 85 5C FF FF FF EB A6 83 7D 08 02 75 04 85 CE 74 DE 8B 45 FC 89 45 FC 8B 45 F8 E9 42 FF FF FF 8B 45 08 33 FF 47 85 C0 75 41 BE 00 00 00 80 85 D6 74 1D 81 F9 FE 03 00 00 75 57 F7 C2 FF FF 0F 00 75 04 85 DB 74 4B 33 C0 BE 00 00 F0 BF EB 4A 81 F9 FE 03 00 00 75 3E F7 C2 FF FF 0F 00 75 04 85 DB 74 32 BE 00 00 F0 3F EB 27 3B C7 75 08 33 C0 85 D2 79 23 EB D2 BE 00 00 00 80 83 F8 02 75 0D 33 C0 85 D6 75 13 BE 00 00 F0 3F EB 0C 85 D6 74 04 33 C0 EB 04 33 C0 33 F6 8B 4D 14 8B D6 89 39 EB 08 8B 45 14 83 20 00 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_2_0 {
	meta:
		name = "__XMMI2_FP_Emulation"
		size = 7416
		refs = "001e ___security_cookie 0035 __clearfp 0083 $LN378 008a $LN476 00bf _isdenormald 0113 $LN477 0183 __control87 0235 __statusfp 0255 _Fill_FPIEEE_RECORD 0280 _isnand 0352 _MIN_DOUBLE_NORMALA 0361 _MAX_DOUBLE_NORMALA 0370 _POSINFDEA 037f _NEGINFDEA 038e _TWO_TO_1536A 039d _TWO_TO_M1536A 066c _ZERODA 0684 _NZERODA 0878 $LN379 087f $LN478 088a _issnand 09aa $LN380 09b1 $LN479 09e7 $LN381 09ee $LN480 0dd6 _isdenormalf 12d9 _MIN_SINGLE_NORMALA 1306 _MAX_SINGLE_NORMALA 1539 __real@80000000 19f9 _fp64_is_qnan 1add _fp64_is_denormal 1b6a _RoundDoubleToIntegral 1c49 @__security_check_cookie@4 1c54 $LN52 1c58 $LN324 1c5c $LN296 1c60 $LN119 1c64 $LN160 1c68 $LN218 1c6c $LN238 1c70 $LN251 1c74 $LN189 1c78 $LN198 1c7c $LN341 1c80 $LN359 1ca8 $LN56 1cb0 $LN57 1cb8 $LN58 1cc0 $LN59 1cc8 $LN123 1ccc $LN128 1cd8 $LN158 1cdc $LN157"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 08 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 33 FF 89 7D 9C DB E3 0F AE 5D EC E8 ?? ?? ?? ?? 8B 73 08 89 7D B4 89 7D C8 8B 4E 20 8B 01 33 46 10 83 E0 03 31 01 8B 4E 20 8B 46 14 C1 E0 02 33 01 83 E0 1C 31 01 8B 56 20 8B 0A 8B C1 C1 E8 05 25 FF 0F 00 00 89 45 D4 83 C0 B7 89 45 A0 83 F8 23 0F 87 BB 1B 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 72 30 8B 42 10 89 75 E0 89 75 C0 8B 72 34 89 75 F0 89 75 C4 8B 73 08 89 45 A8 89 45 B8 8B 42 14 89 45 D8 89 45 BC 39 7E 0C 74 4E 50 FF 75 A8 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 16 8B 45 D8 25 00 00 00 80 89 45 D8 89 45 BC 8B C7 89 45 A8 89 45 B8 FF 75 F0 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 16 8B 45 F0 25 00 00 00 80 89 45 F0 89 45 C4 8B C7 89 45 E0 89 45 C0 8B 45 A0 83 F8 07 77 36 FF 24 85 ?? ?? ?? ?? 81 E1 3F 00 FE FF 83 C9 20 EB 22 81 E1 5F 00 FE FF 83 C9 40 EB 17 81 E1 7F 00 FE FF 83 C9 60 EB 0C 81 E1 9F 00 FE FF 81 C9 80 00 00 00 89 0A 8B 46 10 BA 00 01 00 00 2B C7 74 24 83 E8 01 74 1D 83 E8 01 74 11 83 E8 01 75 07 BF 00 03 00 00 EB 0E 8B 7D F0 EB 09 BF 00 02 00 00 EB 02 8B FA 68 1F 03 0B 00 81 CF 1F 00 09 00 57 E8 ?? ?? ?? ?? 8B 46 20 59 59 8B 00 C1 E8 05 25 FF 0F 00 00 83 E8 01 74 79 83 E8 01 74 52 83 E8 01 74 2B 83 E8 01 0F 85 86 00 00 00 DB E2 DD 45 B8 DD 45 C0 DE F9 DD 9D 68 FF FF FF DB E2 DD 45 B8 DD 45 C0 DE F9 DB BD 74 FF FF FF EB 64 DB E2 DD 45 B8 DD 45 C0 DE C9 DD 9D 68 FF FF FF DB E2 DD 45 B8 DD 45 C0 DE C9 DB BD 74 FF FF FF EB 42 DB E2 DD 45 B8 DD 45 C0 DE E9 DD 9D 68 FF FF FF DB E2 DD 45 B8 DD 45 C0 DE E9 DB BD 74 FF FF FF EB 20 DB E2 DD 45 B8 DD 45 C0 DE C1 DD 9D 68 FF FF FF DB E2 DD 45 B8 DD 45 C0 DE C1 DB BD 74 FF FF FF E8 ?? ?? ?? ?? 89 45 D4 A8 08 74 08 25 FF FF F7 FF 89 45 D4 33 D2 42 84 16 75 29 A8 10 74 25 56 E8 ?? ?? ?? ?? 59 8B 4E 20 83 49 0C 10 8B 4E 20 83 4E 04 01 83 49 04 10 0F AE 55 EC 33 C0 40 E9 C9 19 00 00 8B 7D D8 57 FF 75 A8 E8 ?? ?? ?? ?? 89 45 A0 59 59 85 C0 0F 85 D1 04 00 00 FF 75 F0 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 BC 04 00 00 F6 06 02 BF 00 00 08 00 8B 45 D4 75 15 85 C7 74 11 56 E8 ?? ?? ?? ?? 83 4E 04 02 59 0F AE 55 EC EB A8 F6 06 04 75 23 A8 08 74 1F 56 E8 ?? ?? ?? ?? 8B 46 20 59 83 48 0C 08 8B 46 20 83 4E 04 04 83 48 04 08 0F AE 55 EC EB 80 DD 85 68 FF FF FF DD 5D 90 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 74 3E 8B 46 20 09 50 60 8B 46 20 DD 45 90 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 56 04 0F AE 55 EC E9 F7 18 00 00 85 7D D4 74 04 83 4E 04 02 BE ?? ?? ?? ?? 8D BD 24 FF FF FF A5 A5 66 A5 BE ?? ?? ?? ?? 8D BD 18 FF FF FF A5 A5 66 A5 BE ?? ?? ?? ?? 8D BD 00 FF FF FF A5 A5 66 A5 BE ?? ?? ?? ?? 8D BD 0C FF FF FF A5 A5 66 A5 BE ?? ?? ?? ?? 8D BD 34 FF FF FF A5 A5 66 A5 BE ?? ?? ?? ?? 8D BD 54 FF FF FF A5 A5 66 A5 DB AD 74 FF FF FF DB AD 24 FF FF FF D9 E0 DE D9 9B DD 7D 8C D9 EE DB AD 74 FF FF FF DE D9 9B DD 7D 88 DB AD 74 FF FF FF D9 EE DE D9 9B DD 7D 84 DB AD 24 FF FF FF DB AD 74 FF FF FF DE D9 9B DD 7D 80 66 8B 45 8C BE 00 45 00 00 66 23 C6 B9 00 01 00 00 66 3B C1 75 0C 66 8B 45 88 66 23 C6 66 3B C1 74 18 66 8B 45 84 66 23 C6 66 3B C1 75 13 66 8B 45 80 66 23 C6 66 3B C1 75 07 8B FA 89 7D B4 EB 03 8B 7D B4 DB AD 74 FF FF FF DB AD 0C FF FF FF DE D9 9B DD 7D 8C DB AD 18 FF FF FF D9 E0 DB AD 74 FF FF FF DE D9 9B DD 7D 88 DB AD 74 FF FF FF DB AD 18 FF FF FF DE D9 9B DD 7D 84 DB AD 00 FF FF FF DB AD 74 FF FF FF DE D9 9B DD 7D 80 66 8B 45 8C 66 23 C6 66 3B C1 75 0C 66 8B 45 88 66 23 C6 66 3B C1 74 18 66 8B 45 84 66 23 C6 66 3B C1 75 13 66 8B 45 80 66 23 C6 66 3B C1 75 07 8B C2 89 45 C8 EB 03 8B 45 C8 8B 73 08 F6 06 10 75 60 85 FF 74 5C DB AD 74 FF FF FF DB AD 34 FF FF FF DE C9 DD 9D 68 FF FF FF 56 E8 ?? ?? ?? ?? 8B 46 20 59 33 C9 41 83 48 0C 02 8B 46 20 83 4E 04 10 83 48 04 02 8B 46 20 09 48 60 8B 46 20 DD 85 68 FF FF FF DD 58 50 84 4D D4 74 0A 8B 46 20 09 48 0C 83 4E 04 20 0F AE 55 EC 8B C1 E9 24 17 00 00 F6 06 08 75 5B 85 C0 74 57 DB AD 74 FF FF FF DB AD 54 FF FF FF DE C9 DD 9D 68 FF FF FF 56 E8 ?? ?? ?? ?? 8B 46 20 59 33 C9 41 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 46 20 09 48 60 8B 46 20 DD 85 68 FF FF FF DD 58 50 84 4D D4 74 0A 8B 46 20 09 48 0C 83 4E 04 20 0F AE 55 EC EB 99 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 E8 01 74 36 83 E8 01 74 24 83 E8 01 74 12 83 E8 01 75 32 DD 45 B8 DD 45 C0 DE F9 DD 5D 90 EB 25 DD 45 B8 DD 45 C0 DE C9 DD 5D 90 EB 18 DD 45 B8 DD 45 C0 DE E9 DD 5D 90 EB 0B DD 45 B8 DD 45 C0 DE C1 DD 5D 90 E8 ?? ?? ?? ?? 33 C9 89 45 F0 41 84 C1 74 0A 85 FF 74 06 83 C8 02 89 45 F0 33 FF F6 06 20 0F 85 A8 00 00 00 84 C1 75 14 8B 55 B4 39 7E 08 0F 84 9B 00 00 00 85 D2 0F 84 93 00 00 00 56 E8 ?? ?? ?? ?? 8B 46 20 8B 55 B4 59 33 C9 41 09 48 0C 8B 46 20 83 4E 04 20 09 48 04 8B 46 20 09 48 60 85 D2 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 83 7D C8 00 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 74 36 85 D2 74 32 D9 EE DD 45 90 D8 D1 DF E0 F6 C4 41 75 0F DD D8 DD D8 DD 05 ?? ?? ?? ?? DD 55 90 EB 18 D8 D1 DF E0 DD D9 F6 C4 05 7A 0D DD D8 DD 05 ?? ?? ?? ?? EB E6 DD 45 90 8B 46 20 DD 58 50 0F AE 55 EC E9 7A FE FF FF 8B 55 B4 8B 46 20 09 48 60 F6 45 F0 02 8B 46 20 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD F6 45 F0 04 8B 46 20 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 8B 46 20 84 4D F0 74 09 09 48 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 45 85 D2 74 41 D9 EE DD 45 90 D8 D1 DF E0 F6 C4 41 75 0C DD D9 DD D8 DD 05 ?? ?? ?? ?? EB 0F DE D9 DF E0 F6 C4 05 7A 09 DD 05 ?? ?? ?? ?? DD 5D 90 8B 46 20 09 48 0C 8B 46 20 83 4E 04 20 83 48 0C 02 83 4E 04 10 F6 45 F0 08 8B 46 20 DD 45 90 DD 58 50 8B 46 20 74 0A 83 48 0C 08 83 4E 04 04 EB 04 83 60 0C F7 8B 46 20 83 60 0C EF 0F AE 55 EC E9 DD 14 00 00 8B 46 20 09 50 60 83 7D A0 00 74 25 FF 75 F0 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 74 14 8B 45 A8 81 CF 00 00 08 00 89 45 C0 89 7D C4 DD 45 C0 EB 06 DD 85 68 FF FF FF 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 D4 10 8B 46 20 74 09 83 48 0C 10 09 56 04 EB 04 83 60 0C EF 0F AE 55 EC E9 65 14 00 00 8B 42 10 89 45 E0 89 45 B8 8B 42 14 89 45 D4 89 45 BC 8B 42 30 89 45 F0 89 45 C0 8B 42 34 89 45 B4 89 45 C4 39 7E 0C 74 50 FF 75 D4 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 16 8B 45 D4 25 00 00 00 80 89 45 D4 89 45 BC 8B C7 89 45 E0 89 45 B8 FF 75 B4 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 16 8B 45 B4 25 00 00 00 80 89 45 B4 89 45 C4 8B C7 89 45 F0 89 45 C0 8B 46 18 81 E1 FF 00 FE FF 83 E0 07 81 C9 E0 00 00 00 89 0A 8B D0 89 45 D8 83 FA 07 0F 87 E4 00 00 00 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? FF 75 D4 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 17 FF 75 B4 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 89 7D C8 EB 06 33 C0 40 89 45 C8 E8 ?? ?? ?? ?? 8B 55 D8 A8 10 0F 84 9F 00 00 00 33 C0 40 89 45 C8 E9 97 00 00 00 FF 75 D4 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 75 E4 FF 75 B4 FF 75 F0 E8 ?? ?? ?? ?? 59 59 85 C0 75 D3 89 7D C8 FF 75 D4 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 2D 01 00 00 FF 75 B4 FF 75 F0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 18 01 00 00 FF 75 D4 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 B4 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 4F 83 4E 04 02 F6 06 02 75 46 56 E8 ?? ?? ?? ?? 59 0F AE 55 EC E9 17 F9 FF FF 8B 45 A0 E9 64 FF FF FF 8B 45 C8 85 C0 74 8A F6 06 01 75 85 56 E8 ?? ?? ?? ?? 8B 46 20 59 83 48 0C 10 8B 46 20 83 4E 04 01 83 48 04 10 0F AE 55 EC E9 E1 F8 FF FF DD 45 C0 DD 45 B8 D8 D1 DF E0 F6 C4 05 7A 17 DD D9 DD D8 83 FA 07 77 51 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D8 D1 DF E0 F6 C4 41 75 18 DD D9 DD D8 83 FA 03 76 2B 83 FA 07 77 2C 83 4D C0 FF 83 4D C4 FF EB 22 DA E9 DF E0 F6 C4 44 7A 19 83 FA 07 77 14 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 7D C0 89 7D C4 8B 46 20 DD 45 C0 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 83 60 0C EF 0F AE 55 EC E9 0B 12 00 00 83 FA 02 76 0A 83 FA 06 76 4B 83 FA 07 75 06 89 7D C0 89 7D C4 8B 46 20 DD 45 C0 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 45 C8 85 C0 8B 46 20 74 14 83 48 0C 10 83 4E 04 01 EB 0E 83 4D C0 FF 83 4D C4 FF EB B6 83 60 0C EF 0F AE 55 EC E9 9F 11 00 00 8B 42 10 8B 4A 14 89 45 E0 89 45 B8 8B 42 30 8B 52 34 89 4D F0 89 4D BC 89 45 C8 89 45 C0 89 55 D8 89 55 C4 39 7E 0C 74 4B 51 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 B9 00 00 00 80 85 C0 74 13 8B 45 F0 23 C1 89 45 F0 89 45 BC 8B C7 89 45 E0 89 45 B8 52 FF 75 C8 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 10 23 D1 8B C7 89 55 D8 89 55 C4 89 45 C8 89 45 C0 8B 4D F0 8B 45 D4 83 E8 59 74 3D 83 E8 01 75 33 51 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 52 FF 75 C8 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 04 33 FF EB 03 33 FF 47 E8 ?? ?? ?? ?? 8B 55 D8 A8 10 EB 21 8B 7D A0 EB 21 51 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 75 0F 52 FF 75 C8 E8 ?? ?? ?? ?? 59 59 85 C0 74 03 33 FF 47 8B 4E 20 8B 01 25 FF 00 FE FF 0D E0 00 00 00 89 01 85 FF 74 27 F6 06 01 75 22 56 E8 ?? ?? ?? ?? 8B 46 20 59 83 48 0C 10 8B 46 20 83 4E 04 01 83 48 04 10 0F AE 55 EC E9 BA F6 FF FF FF 75 F0 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 C7 00 00 00 52 FF 75 C8 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 B4 00 00 00 FF 75 F0 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 10 52 FF 75 C8 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 19 83 4E 04 02 F6 06 02 75 10 56 E8 ?? ?? ?? ?? 59 0F AE 55 EC E9 57 F6 FF FF DD 45 C0 DD 45 B8 D8 D1 DF E0 F6 C4 41 75 0D 81 66 1C 2A F7 FF FF DD D9 DD D8 EB 31 D8 D1 DF E0 F6 C4 05 7A 11 8B 46 1C DD D9 25 2B F7 FF FF DD D8 83 C8 01 EB 14 DA E9 DF E0 F6 C4 44 7A 0E 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 83 60 0C EF 0F AE 55 EC E9 AD 0F 00 00 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 85 FF 74 0A 83 48 0C 10 83 4E 04 01 EB 04 83 60 0C EF 0F AE 55 EC E9 65 0F 00 00 8B 42 10 89 45 A0 8B 46 10 2B C7 74 27 83 E8 01 74 1D 83 E8 01 74 11 83 E8 01 75 07 BF 00 03 00 00 EB 11 8B 7D F0 EB 0C BF 00 02 00 00 EB 05 BF 00 01 00 00 68 1F 03 0B 00 81 CF 1F 00 0A 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 A0 D9 5D A4 E8 ?? ?? ?? ?? 33 C9 8B D0 41 F6 06 20 75 49 84 D1 74 45 56 E8 ?? ?? ?? ?? 59 8B 4E 20 BA 00 01 00 00 8B 01 25 1F 01 FE FF 0B C2 89 01 33 C9 8B 46 20 41 09 48 0C 8B 46 20 83 4E 04 20 09 48 04 8B 46 20 09 48 60 8B 46 20 D9 45 A4 D9 58 50 0F AE 55 EC E9 95 F7 FF FF 8B 46 20 09 48 60 8B 46 20 D9 45 A4 D9 58 50 8B 46 20 84 D1 74 09 09 48 0C 83 4E 04 20 EB 04 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 83 60 0C EF 0F AE 55 EC E9 76 0E 00 00 8B 52 10 89 55 F0 39 7E 0C 74 16 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 81 E2 00 00 00 80 89 55 F0 8B 45 D4 BA 00 01 00 00 83 E8 64 74 0F 83 E8 01 75 1B 81 E1 1F 01 FE FF 0B CA EB 0C 81 E1 5F 05 FE FF 81 C9 40 05 00 00 8B 46 20 89 08 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 05 83 F8 2A EB 14 8B 46 10 2B C7 74 22 83 E8 01 74 1F 83 E8 01 74 11 83 E8 01 75 07 BA 00 03 00 00 EB 0E 8B 55 F0 EB 09 BA 00 02 00 00 EB 02 8B D7 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 F0 DB 9D 4C FF FF FF E8 ?? ?? ?? ?? 33 D2 89 45 D8 42 84 16 75 26 A8 10 74 22 56 E8 ?? ?? ?? ?? 8B 46 20 59 83 48 0C 10 8B 46 20 83 4E 04 01 83 48 04 10 0F AE 55 EC E9 C4 F3 FF FF 8B 4E 20 8B 85 4C FF FF FF 89 41 50 F6 06 20 8B 4D D8 75 2D 84 CA 74 29 56 E8 ?? ?? ?? ?? 8B 46 20 59 33 C9 41 09 48 0C 8B 46 20 83 4E 04 20 09 48 04 8B 46 20 09 48 60 0F AE 55 EC E9 29 F6 FF FF 8B 46 20 09 50 60 8B 46 20 84 CA 74 09 09 50 0C 83 4E 04 20 EB 04 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 F6 C1 10 74 09 83 48 0C 10 09 56 04 EB 04 83 60 0C EF 0F AE 55 EC E9 05 0D 00 00 8B 42 10 8B 52 14 89 45 B8 89 55 BC 39 7E 0C 74 1A 52 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C 81 E2 00 00 00 80 89 7D B8 89 55 BC 8B 45 D4 BA 00 01 00 00 83 F8 5B 72 21 83 F8 5C 76 0F 83 F8 5E 76 2E 83 F8 66 74 29 83 F8 67 75 0D 81 E1 1F 01 FE FF 0B CA 8B 46 20 89 08 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 13 83 F8 2A EB 22 81 E1 5F 05 FE FF 81 C9 40 05 00 00 EB D6 8B 46 10 2B C7 74 22 83 E8 01 74 1F 83 E8 01 74 11 83 E8 01 75 07 BA 00 03 00 00 EB 0E 8B 55 F0 EB 09 BA 00 02 00 00 EB 02 8B D7 81 CA 1F 00 09 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 B8 DB 9D 4C FF FF }
	condition:
		$1
}

rule file_100_3_0 {
	meta:
		name = "_fp64_is_denormal"
		size = 38
		altNames = "_isdenormald"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C 00 00 F0 7F 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_4_0 {
	meta:
		name = "_fp64_is_inf"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C B9 00 00 F0 7F 23 C1 3B C1 75 14 F7 45 0C FF FF 0F 00 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_5_0 {
	meta:
		name = "_fp64_is_qnan"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C B9 00 00 F0 7F 23 C1 3B C1 75 0E F7 45 0C 00 00 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_6_0 {
	meta:
		name = "_fp64_is_snan"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C B9 00 00 F0 7F 23 C1 3B C1 75 1D F7 45 0C 00 00 08 00 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_7_0 {
	meta:
		name = "_fp64_is_zero"
		size = 29
		altNames = "_iszerod"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C FF FF FF 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_9_0 {
	meta:
		name = "_isdenormalf"
		size = 32
		altNames = "_fp32_is_denormal"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 08 00 00 80 7F 75 0E F7 45 08 FF FF 7F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_10_0 {
	meta:
		name = "_isinfd"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_11_0 {
	meta:
		name = "_isnand"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C B9 00 00 F0 7F 23 C1 3B C1 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_12_0 {
	meta:
		name = "_issnand"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 25 00 00 F8 7F 3D 00 00 F0 7F 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_100_14_0 {
	meta:
		name = "_quietd"
		size = 52
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 51 51 8B 43 08 89 45 F8 8B 43 0C 0D 00 00 08 00 89 45 FC DD 45 F8 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_pow"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __pow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 87 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 5A E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_101_2_0 {
	meta:
		name = "__CIpow_default"
		size = 526
		refs = "001e __fload_withFB 0032 __load_CW 0072 __twoToTOS 007f ___fastflag 0086 __fast_exit 008c POW_name 0096 __check_range_exit 00b3 __startTwoArgErrorHandling 0135 __powhlp 0193 __infinity 01d8 __indefinite 01f6 __half"
	strings:
		$1 = { 83 EC 14 D9 C9 DD 1C 24 DD 54 24 08 8B 44 24 0C E8 0D 00 00 00 83 C4 14 C3 8D 54 24 0C E8 ?? ?? ?? ?? 8B C8 50 9B D9 3C 24 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 81 E1 00 00 F0 7F 8D 54 24 08 81 F9 00 00 F0 7F 0F 84 9C 00 00 00 E8 ?? ?? ?? ?? 0F 84 8D 00 00 00 A9 00 00 F0 7F 0F 84 F5 00 00 00 8A 4C 24 0F 80 E1 80 0F 85 52 01 00 00 D9 F1 E8 ?? ?? ?? ?? 80 F9 01 75 02 D9 E0 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E9 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E8 ?? ?? ?? ?? 5A C3 8D 54 24 08 E8 ?? ?? ?? ?? D9 E8 DF E9 7A 05 74 0E 41 EB 31 D9 C9 D9 E5 9B DF E0 9B 9E 75 08 DD D8 DD D8 D9 E8 5A C3 DE C1 5A C3 33 C9 EB 16 33 C9 25 FF FF 0F 00 0B 44 24 10 75 C4 8D 54 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 8B D0 25 00 00 F0 7F 81 E2 FF FF 0F 00 3D 00 00 F0 7F 75 06 0B 54 24 08 75 B1 85 C9 75 C0 83 EC 74 8B CC 51 83 EC 10 DD 1C 24 DD 5C 24 08 9B DD 71 08 E8 ?? ?? ?? ?? 83 C4 10 59 DD 61 08 DD 01 83 C4 74 85 C0 0F 84 ?? ?? ?? ?? B8 01 00 00 00 E9 43 FF FF FF 8B 44 24 0C 25 FF FF 0F 00 0B 44 24 08 0F 85 F8 FE FF FF DD D8 8B 44 24 14 25 FF FF FF 7F 0B 44 24 10 74 3D E8 66 00 00 00 8A 6C 24 0F C0 ED 07 F7 44 24 17 80 00 00 00 74 16 DB 2D ?? ?? ?? ?? 84 CD 74 02 D9 E0 B8 02 00 00 00 E9 F3 FE FF FF D9 EE 84 CD 0F 84 ?? ?? ?? ?? D9 E0 E9 ?? ?? ?? ?? DD D8 D9 E8 E9 ?? ?? ?? ?? D9 C1 E8 1E 00 00 00 D9 E0 84 C9 0F 85 9D FE FF FF DD D8 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 E9 B4 FE FF FF D9 C0 D9 FC D8 D9 B1 00 9B DF E0 9E 75 17 DC 0D ?? ?? ?? ?? FE C1 D9 C0 D9 FC DE D9 9B DF E0 9E 75 02 FE C1 C3 DD D8 C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "_scalblnf"
		size = 68
		refs = "0010 __fdtest 0022 __fdscale 003a __fperrraise"
		altNames = "_scalbnf"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 74 34 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 25 FF 75 0C 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 D9 45 08 5D C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "___libm_sse2_cos"
		size = 417
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 ___acrt_cos_sin_ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 0161 _ONE 0188 _cos 019c _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 1F 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 28 C1 C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_cbrtl"
		size = 263
		refs = "0011 __ldunscale 0068 __ldscale 008a __real@3fcf3482be8bc16a 0092 __real@3feea8826aa8eb46 009a __real@3fb43419e30014f9 00a2 __real@3fd1e54b48d3ae68 00ac __real@3ff8000000000000 00b2 __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 F8 02 77 08 DD 45 08 E9 DE 00 00 00 53 56 66 8B 75 FC 33 DB 0F BF CE 8B C1 C7 45 F8 03 00 00 00 99 F7 7D F8 57 6B C0 03 8B FB 3B C1 74 2B 4F 66 46 0F BF CE 8B C1 99 F7 7D F8 6B C0 03 3B C1 75 ED 66 89 75 FC 85 FF 79 10 8D 45 08 57 50 E8 ?? ?? ?? ?? 66 8B 75 FC 59 59 DD 45 08 B8 00 80 00 00 66 85 45 0E 74 08 33 DB D9 E0 DD 55 08 43 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 DC 05 ?? ?? ?? ?? DE F9 D9 C1 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DC CB D9 C3 D8 F3 D9 C3 D8 CC DE C1 D9 C2 DE F1 DE C3 DC CA D9 CB D8 F2 D9 C2 D8 CB DE C1 DE F9 DE C1 DE C9 DD 55 F0 85 DB 74 07 D9 E0 DD 5D F0 EB 02 DD D8 0F BF C6 99 F7 7D F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? DD 45 F0 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "_cbrt"
		size = 263
		refs = "0011 __dunscale 0068 __dscale 008a __real@3fcf3482be8bc16a 0092 __real@3feea8826aa8eb46 009a __real@3fb43419e30014f9 00a2 __real@3fd1e54b48d3ae68 00ac __real@3ff8000000000000 00b2 __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 F8 02 77 08 DD 45 08 E9 DE 00 00 00 53 56 66 8B 75 FC 33 DB 0F BF CE 8B C1 C7 45 F8 03 00 00 00 99 F7 7D F8 57 6B C0 03 8B FB 3B C1 74 2B 4F 66 46 0F BF CE 8B C1 99 F7 7D F8 6B C0 03 3B C1 75 ED 66 89 75 FC 85 FF 79 10 8D 45 08 57 50 E8 ?? ?? ?? ?? 66 8B 75 FC 59 59 DD 45 08 B8 00 80 00 00 66 85 45 0E 74 08 33 DB D9 E0 DD 55 08 43 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 DC 05 ?? ?? ?? ?? DE F9 D9 C1 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DC CB D9 C3 D8 F3 D9 C3 D8 CC DE C1 D9 C2 DE F1 DE C3 DC CA D9 CB D8 F2 D9 C2 D8 CB DE C1 DE F9 DE C1 DE C9 DD 55 F0 85 DB 74 07 D9 E0 DD 5D F0 EB 02 DD D8 0F BF C6 99 F7 7D F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? DD 45 F0 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__set_abort_behavior"
		size = 33
		refs = "0009 ___abort_behavior"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C A1 ?? ?? ?? ?? F7 D2 8B 4D 08 23 D0 23 4D 0C 0B D1 89 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "_abort"
		size = 67
		refs = "0001 ___acrt_get_sigabrt_handler 000c _raise 0013 ___abort_behavior 001d _IsProcessorFeaturePresent@4 0034 ___acrt_call_reportfault 003e __exit"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 08 6A 16 E8 ?? ?? ?? ?? 59 F6 05 ?? ?? ?? ?? 02 74 21 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 6A 07 59 CD 29 6A 01 68 15 00 00 40 6A 03 E8 ?? ?? ?? ?? 83 C4 0C 6A 03 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__LSinh"
		size = 315
		refs = "000b __ldtest 004e __LRteps_C 005d __real@3fe193ea7aad030b 0070 __real@3f0c0fa13ffd4adc 0078 __real@3f74be86cc52783b 0080 __real@3fc2b3653e628272 008e __real@3f24d74f3de964a2 0096 __real@3f950f80b7969f66 009e __real@3ff0000000000000 00ab __LXbig_C 00c4 __ldexp 00ca __real@3fd0000000000000 011b __fperrraise 0121 __LNan_C"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 10 50 E8 ?? ?? ?? ?? 59 59 33 C9 0F B7 C0 66 3B CE 0F 8E CA 00 00 00 66 3B C8 0F 8E C1 00 00 00 D9 EE 33 F6 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 74 49 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3F D9 C0 D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 D8 CB DE C9 DE C2 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? DE F9 DC 4D 10 EB 43 DC 1D ?? ?? ?? ?? DF E0 6A FF 51 51 F6 C4 05 8D 45 08 7A 1D D9 E8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 45 08 DC F9 DE E1 DC 4D 10 EB 0F DD 45 10 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 08 83 C4 10 66 85 F6 74 47 D9 E0 EB 43 6A 02 59 66 3B F1 75 05 DD 45 08 EB 36 66 3B C1 75 05 DD 45 10 EB 2C 33 C9 41 66 3B F1 75 14 66 85 C0 75 19 51 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 10 66 85 F6 75 05 66 3B C1 EB E5 DD 45 08 DC 4D 10 5E 5D C3 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "__Sinh"
		size = 315
		refs = "000b __dtest 004e __Rteps_C 005d __real@3fe193ea7aad030b 0070 __real@3f0c0fa13ffd4adc 0078 __real@3f74be86cc52783b 0080 __real@3fc2b3653e628272 008e __real@3f24d74f3de964a2 0096 __real@3f950f80b7969f66 009e __real@3ff0000000000000 00ab __Xbig_C 00c4 __dexp 00ca __real@3fd0000000000000 011b __fperrraise 0121 __Nan_C"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 10 50 E8 ?? ?? ?? ?? 59 59 33 C9 0F B7 C0 66 3B CE 0F 8E CA 00 00 00 66 3B C8 0F 8E C1 00 00 00 D9 EE 33 F6 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 74 49 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3F D9 C0 D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 D8 CB DE C9 DE C2 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? DE F9 DC 4D 10 EB 43 DC 1D ?? ?? ?? ?? DF E0 6A FF 51 51 F6 C4 05 8D 45 08 7A 1D D9 E8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 45 08 DC F9 DE E1 DC 4D 10 EB 0F DD 45 10 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 08 83 C4 10 66 85 F6 74 47 D9 E0 EB 43 6A 02 59 66 3B F1 75 05 DD 45 08 EB 36 66 3B C1 75 05 DD 45 10 EB 2C 33 C9 41 66 3B F1 75 14 66 85 C0 75 19 51 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 10 66 85 F6 75 05 66 3B C1 EB E5 DD 45 08 DC 4D 10 5E 5D C3 }
	condition:
		$1
}

rule file_106_2_0 {
	meta:
		name = "_csinhl"
		size = 342
		refs = "0017 _creall 0028 _cimagl 0034 __ldtest 0066 __LNan_C 0088 __fperrraise 00d1 __CIsin 00dc __CIcos 00e2 __LInf_C 0119 __LCosh 0130 __LSinh 013e __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 F0 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 6A 02 59 66 3B F1 75 2C 83 EC 10 66 85 C0 8D 45 D0 75 12 DD 45 F8 DD 5C 24 08 DD 05 ?? ?? ?? ?? E9 CA 00 00 00 DD 05 ?? ?? ?? ?? DD 54 24 08 E9 BB 00 00 00 33 FF 47 66 3B C7 75 38 57 E8 ?? ?? ?? ?? 59 66 85 F6 74 1A 66 3B F7 74 15 DD 05 ?? ?? ?? ?? 83 EC 10 DD 54 24 08 8D 45 D0 E9 8D 00 00 00 DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 F0 EB E6 66 3B C1 74 CA DD 45 F8 66 3B F7 75 2A 66 85 C0 74 E2 E8 ?? ?? ?? ?? DD 5D E8 DD 45 F8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 EC 10 DC 4D E8 DD 5C 24 08 DC 4D F0 EB AF E8 ?? ?? ?? ?? DD 5D E8 DD 45 F8 E8 ?? ?? ?? ?? DD 5D D8 DD 45 E8 83 EC 10 DD 5C 24 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 5C 24 08 DD 45 D8 DD 1C 24 DD 45 F0 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 36
		refs = "0007 ___sys_nerr 001a ___sys_errlist"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 3B 30 72 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E 5D C3 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "_perror"
		size = 156
		refs = "0003 __sehtable$_perror 0008 __SEH_prolog4 000f ___acrt_lowio_lock_fh 0037 __write_nolock 003e ??_C@_02LMMGGCAJ@?3?5?$AA@ 004d __errno 0054 __get_sys_err_msg 0073 ??_C@_01EEMJAFIK@?6?$AA@ 008e __SEH_epilog4 0096 ___acrt_lowio_unlock_fh"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 55 08 85 D2 74 2D 80 3A 00 74 28 8B CA 8D 79 01 8A 01 41 84 C0 75 F9 2B CF 51 52 6A 02 E8 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 59 8B D0 8D 7A 01 8A 0A 42 84 C9 75 F9 2B D7 52 50 6A 02 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_108_5_0 {
	meta:
		name = "__mbscmp_l"
		size = 248
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 __errno 0030 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 4D EC 53 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 07 8B 75 0C 85 F6 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF 7F E9 A1 00 00 00 8B 7D F4 33 D2 39 57 08 75 29 8A 01 3A 06 75 1C 84 C0 0F 84 89 00 00 00 8A 41 01 3A 46 01 75 0C 83 C1 02 83 C6 02 84 C0 75 E0 EB 75 1B D2 83 CA 01 EB 6E 0F B6 19 41 8B C3 F6 44 38 19 04 74 17 8A 01 84 C0 75 04 8B DA EB 0D C1 E3 08 0F B6 C0 66 0B D8 41 0F B7 DB 0F B6 06 46 89 45 FC 0F B6 C0 F6 44 38 19 04 74 24 8A 06 84 C0 75 04 8B C2 EB 1D 8B 7D FC C1 E7 08 0F B6 C0 66 0B F8 46 8B C7 89 7D FC 8B 7D F4 0F B7 C0 EB 03 8B 45 FC 66 3B C3 75 07 66 85 DB 75 9A EB 06 1B D2 83 E2 02 4A 80 7D F8 00 5F 5E 5B 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__swab"
		size = 109
		refs = "000d __errno 0019 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 85 D2 75 11 E8 ?? ?? ?? ?? C7 00 16 00 00 00 5D E9 ?? ?? ?? ?? 56 8B 75 0C 85 F6 75 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 5E EB E4 57 8B 7D 10 85 FF 79 0E E8 ?? ?? ?? ?? 5F C7 00 16 00 00 00 EB E7 83 FF 01 7E 1B 83 C7 FE D1 EF 47 8A 42 01 8A 0A 8D 52 02 88 06 8D 76 02 88 4E FF 83 EF 01 75 EB 5F 5E 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "___acrt_wcstok_s_novalidation"
		size = 169
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 85 C0 75 05 8B 45 10 8B 00 0F B7 08 33 D2 53 56 57 8B 7D 0C 66 85 C9 74 30 0F B7 1F 8B D7 66 85 DB 74 12 8B F3 66 3B F1 74 0B 83 C2 02 0F B7 32 66 85 F6 75 F0 33 C9 66 39 0A 74 0B 83 C0 02 0F B7 08 66 85 C9 75 D5 33 D2 8B F0 66 39 10 74 3C 0F B7 1F 8B CF 66 85 DB 74 1B 0F B7 10 89 55 FC 8B D3 66 3B 55 FC 74 0B 83 C1 02 0F B7 11 66 85 D2 75 EF 33 D2 66 39 11 75 0A 83 C0 02 66 39 10 75 D1 EB 08 33 C9 66 89 08 83 C0 02 8B 4D 10 5F 89 01 2B C6 F7 D8 1B C0 23 C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "_wcstok_s"
		size = 66
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0039 ___acrt_wcstok_s_novalidation"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 83 7D 0C 00 74 E6 83 7D 08 00 75 05 83 38 00 74 DB 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_555_1_0 {
	meta:
		name = "_strtok_s"
		size = 66
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0039 ___acrt_strtok_s_novalidation"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 83 7D 0C 00 74 E6 83 7D 08 00 75 05 83 38 00 74 DB 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_111_7_0 {
	meta:
		name = "___acrt_initialize_stdio"
		size = 200
		refs = "0001 __nstream 0023 __calloc_base 002a ___piob 002f __free_base 006e __iob 007e ___acrt_InitializeCriticalSectionEx@12 009a ___pioinfo"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 6A 03 5E 85 C0 75 07 B8 00 02 00 00 EB 06 3B C6 7D 07 8B C6 A3 ?? ?? ?? ?? 6A 04 50 E8 ?? ?? ?? ?? 6A 00 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 00 75 2B 6A 04 56 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 00 75 05 83 C8 FF 5E C3 57 33 FF BE ?? ?? ?? ?? 6A 00 68 A0 0F 00 00 8D 46 20 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B D7 C1 FA 06 89 34 B8 8B C7 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 8B 44 08 18 83 F8 FF 74 09 83 F8 FE 74 04 85 C0 75 07 C7 46 10 FE FF FF FF 83 C6 38 47 81 FE ?? ?? ?? ?? 75 AF 5F 33 C0 5E C3 }
	condition:
		$1
}

rule file_111_8_0 {
	meta:
		name = "___acrt_iob_func"
		size = 16
		refs = "000a __iob"
	strings:
		$1 = { 8B FF 55 8B EC 6B 45 08 38 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_111_9_0 {
	meta:
		name = "___acrt_uninitialize_stdio"
		size = 76
		refs = "0004 __flushall 0009 __fcloseall 0010 ___piob 0018 ___acrt_stdio_free_buffer_nolock 002b __imp__DeleteCriticalSection@4 003e __free_base"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 A1 ?? ?? ?? ?? FF 34 06 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 8B 04 06 83 C0 20 50 FF 15 ?? ?? ?? ?? 83 C6 04 83 FE 0C 75 D8 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 59 5E C3 }
	condition:
		$1
}

rule file_111_10_0 {
	meta:
		name = "__get_stream_buffer_pointers"
		size = 70
		refs = "000d __errno 0018 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 8B 55 0C 85 D2 74 05 8D 41 04 89 02 8B 45 10 85 C0 74 02 89 08 8B 55 14 85 D2 74 05 8D 41 08 89 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_111_11_0 {
	meta:
		name = "__lock_file"
		size = 20
		refs = "000e __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C0 20 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_111_12_0 {
	meta:
		name = "__unlock_file"
		size = 20
		refs = "000e __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C0 20 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "__mblen_l"
		size = 179
		refs = "0030 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 003d __isleadbyte_l 006c __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 57 8B 7D 08 85 FF 0F 84 96 00 00 00 80 3F 00 0F 84 8D 00 00 00 8B 75 0C 85 F6 0F 84 82 00 00 00 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F4 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 8B 45 F4 59 74 32 83 78 04 01 7E 44 81 FE FF FF FF 7F 77 3C 3B 70 04 7C 37 6A 00 6A 00 FF 70 04 57 6A 09 FF 70 08 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 45 F4 8B 70 04 EB 1B 6A 00 6A 00 33 F6 46 56 57 6A 09 FF 70 08 FF 15 ?? ?? ?? ?? 85 C0 75 03 83 CE FF 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C6 EB 02 33 C0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_5_0 {
	meta:
		name = "_mblen"
		size = 39
		refs = "0007 ___acrt_locale_changed_data 000f ___acrt_initial_locale_pointers 001e __mblen_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 07 68 ?? ?? ?? ?? EB 02 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__cintrindisp2"
		size = 68
		refs = "0016 ___acrt_has_user_matherr 0022 __trandisp2"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 9B 50 51 52 E8 ?? ?? ?? ?? 3C 00 5A 59 58 75 14 E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 03 E8 9D 00 00 00 5B C9 C3 D9 C9 DD 95 7A FF FF FF D9 C9 DD 55 82 EB DD }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "__cintrindisp1"
		size = 67
		refs = "0015 ___acrt_has_user_matherr 0021 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 50 51 52 E8 ?? ?? ?? ?? 3C 00 5A 59 58 75 1B E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 01 80 A5 38 FD FF FF FD E8 53 00 00 00 5B C9 C3 DD 95 7A FF FF FF EB DD }
	condition:
		$1
}

rule file_113_2_0 {
	meta:
		name = "__ctrandisp2"
		size = 399
		refs = "0035 __trandisp2 004a ___fastflag 00df IeeeAdjU 00ef DblMin 00fb _zero 010d IeeeAdjO 011d DblMax 0129 _infinity 017e __87except"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 AD 01 00 00 83 C4 08 FF 75 14 FF 75 10 E8 9F 01 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 8D 38 FD FF FF 02 E8 ?? ?? ?? ?? E8 03 00 00 00 5B C9 C3 80 A5 38 FD FF FF FE 83 3D ?? ?? ?? ?? 00 75 4F DD 95 30 FD FF FF 8A 85 70 FF FF FF 0A C0 74 1A 3C FF 74 5B 3C FE 74 3F 0A C0 74 33 0F BE C0 89 85 72 FF FF FF E9 B2 00 00 00 66 8B 85 5C FF FF FF 66 83 E0 20 75 18 9B DF E0 66 83 E0 20 74 0F C7 85 72 FF FF FF 08 00 00 00 E9 8D 00 00 00 D9 AD 5C FF FF FF 9B C3 66 8B 85 36 FD FF FF 66 25 F0 7F 66 0B C0 74 1B 66 3D F0 7F 74 43 EB BB 66 8B 85 36 FD FF FF 66 25 F0 7F 66 3D F0 7F 74 30 EB A8 C7 85 72 FF FF FF 04 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 73 34 DC 0D ?? ?? ?? ?? EB 2C C7 85 72 FF FF FF 03 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 76 06 DC 0D ?? ?? ?? ?? 56 57 8B 9D 6C FF FF FF 43 89 9D 76 FF FF FF F6 85 38 FD FF FF 01 75 1A FC 8D 75 08 8D BD 7A FF FF FF A5 A5 80 7B 0C 01 74 08 8D 75 10 8D 7D 82 A5 A5 DD 5D 8A 8D 85 72 FF FF FF 8D 9D 5C FF FF FF 53 50 8B 9D 6C FF FF FF 8A 43 0E 0F BE C0 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E DD 45 8A E9 11 FF FF FF }
	condition:
		$1
}

rule file_113_3_0 {
	meta:
		name = "__ctrandisp1"
		size = 51
		refs = "0027 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 1E 00 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 A5 38 FD FF FF FD E8 ?? ?? ?? ?? E8 82 FE FF FF 5B C9 C3 }
	condition:
		$1
}

rule file_113_4_0 {
	meta:
		name = "__fload"
		size = 60
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 66 8B 45 0E 66 8B D8 66 25 F0 7F 66 3D F0 7F 75 1E 66 81 CB FF 7F 66 89 5D FE 8B 45 0C 8B 5D 08 0F A4 D8 0B 89 45 FA 89 5D F6 DB 6D F6 EB 03 DD 45 08 5B C9 C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "?GetTableIndexFromLcid@@YAHK@Z"
		size = 55
		refs = "001b ?LcidToLocaleNameTable@?A0x881e4c05@@3QBULcidToLocaleName@1@B"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 C9 BE E3 00 00 00 8D 04 0E 99 2B C2 8B 55 08 D1 F8 2B 14 C5 ?? ?? ?? ?? 74 13 85 D2 79 05 8D 70 FF EB 03 8D 48 01 3B CE 7E DC 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "?GetTableIndexFromLocaleName@@YAHPB_W@Z"
		size = 188
		refs = "0032 ?LocaleNameToIndexTable@?A0x881e4c05@@3QBULocaleNameIndex@1@B"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 57 33 FF BB E3 00 00 00 89 7D F4 89 5D F8 8D 04 3B C7 45 FC 55 00 00 00 99 2B C2 8B C8 D1 F9 6A 41 5F 89 4D F0 8B 34 CD ?? ?? ?? ?? 8B 4D 08 6A 5A 2B CE 5B 0F B7 04 31 66 3B C7 72 0D 66 3B C3 77 08 83 C0 20 0F B7 D0 EB 02 8B D0 0F B7 06 66 3B C7 72 0B 66 3B C3 77 06 83 C0 20 0F B7 C0 83 C6 02 83 6D FC 01 74 0A 66 85 D2 74 05 66 3B D0 74 C2 8B 4D F0 8B 7D F4 8B 5D F8 0F B7 C0 0F B7 D2 2B D0 74 1F 85 D2 79 08 8D 59 FF 89 5D F8 EB 06 8D 79 01 89 7D F4 3B FB 0F 8E 6F FF FF FF 83 C8 FF EB 07 8B 04 CD ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_2_0 {
	meta:
		name = "?__wcsnicmp_ascii@@YAHPB_W0I@Z"
		size = 117
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 10 33 C0 85 F6 74 60 8B 4D 0C 53 57 8B 7D 08 6A 41 5B 6A 5A 5A 2B F9 89 55 FC EB 03 6A 5A 5A 0F B7 04 0F 66 3B C3 72 0D 66 3B C2 77 08 83 C0 20 0F B7 D0 EB 02 8B D0 0F B7 01 66 3B C3 72 0C 66 3B 45 FC 77 06 83 C0 20 0F B7 C0 83 C1 02 83 EE 01 74 0A 66 85 D2 74 05 66 3B D0 74 BF 0F B7 C8 0F B7 C2 5F 2B C1 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_3_0 {
	meta:
		name = "___acrt_DownlevelLCIDToLocaleName"
		size = 170
		refs = "0048 ?LcidToLocaleNameTable@?A0x881e4c05@@3QBULcidToLocaleName@1@B 0070 _wcsnlen 0086 _wcscpy_s 00a5 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 53 56 57 85 C9 0F 84 83 00 00 00 81 F9 00 04 00 00 74 7B 81 F9 00 08 00 00 74 73 83 7D 0C 00 8B 75 10 75 04 85 F6 7F 66 85 F6 78 62 33 FF BB E3 00 00 00 8D 04 3B 99 2B C2 8B D1 D1 F8 2B 14 C5 ?? ?? ?? ?? 74 13 85 D2 79 05 8D 58 FF EB 03 8D 78 01 3B FB 7E DD 83 C8 FF 85 C0 78 31 8B 1C C5 ?? ?? ?? ?? 6A 55 53 E8 ?? ?? ?? ?? 8B F8 59 59 85 F6 7E 15 3B FE 7D 16 53 56 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0C 8D 47 01 EB 02 33 C0 5F 5E 5B 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_114_4_0 {
	meta:
		name = "___acrt_DownlevelLocaleNameToLCID"
		size = 44
		refs = "000f ?GetTableIndexFromLocaleName@@YAHPB_W@Z 0022 ?LcidToLocaleNameTable@?A0x881e4c05@@3QBULcidToLocaleName@1@B"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 1D FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 78 10 3D E4 00 00 00 73 09 8B 04 C5 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_115_5_0 {
	meta:
		name = "__mbsnbcoll_l"
		size = 209
		refs = "001e __errno 0029 __invalid_parameter_noinfo 0060 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0078 __strncoll_l 009e ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 57 8B 7D 10 85 FF 75 07 33 C0 E9 B5 00 00 00 83 7D 08 00 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 95 00 00 00 83 7D 0C 00 74 E0 56 BE FF FF FF 7F 3B FE 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 70 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 83 78 08 00 75 16 FF 75 14 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F0 EB 36 FF 70 04 57 FF 75 0C 57 FF 75 08 68 00 10 00 00 FF B0 1C 02 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 70 FE 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C6 5E 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "_cbrtf"
		size = 263
		refs = "0011 __fdunscale 0068 __fdscale 008d __real@3fcf3482c0000000 0095 __real@3feea88260000000 009f __real@3fb43419e0000000 00a7 __real@3fd1e54b40000000 00b4 __real@3fe0000000000000 00c7 __real@3ff8000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 F8 02 77 08 D9 45 08 E9 DE 00 00 00 53 56 66 8B 75 FC 33 DB 0F BF CE 8B C1 C7 45 F4 03 00 00 00 99 F7 7D F4 57 6B C0 03 8B FB 3B C1 74 2B 4F 66 46 0F BF CE 8B C1 99 F7 7D F4 6B C0 03 3B C1 75 ED 66 89 75 FC 85 FF 79 10 8D 45 08 57 50 E8 ?? ?? ?? ?? 66 8B 75 FC 59 59 B8 00 80 00 00 66 85 45 0A 74 0B D9 45 08 33 DB D9 E0 43 D9 5D 08 D9 45 08 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 DE C9 DC 05 ?? ?? ?? ?? D9 C1 DC 05 ?? ?? ?? ?? DE F9 D9 5D F8 D9 C0 DD 05 ?? ?? ?? ?? DC C9 D9 45 F8 D9 C0 DE FB D9 C0 D9 CC DC 0D ?? ?? ?? ?? D9 CC DC C8 DE C3 D9 CB DE F2 D9 C9 DE C2 DE C9 D9 5D F8 85 DB 74 08 D9 45 F8 D9 E0 D9 5D F8 0F BF C6 99 F7 7D F4 50 8D 45 F8 50 E8 ?? ?? ?? ?? D9 45 F8 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_2_0 {
	meta:
		name = "??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
		size = 193
		refs = "000f __errno 001a __invalid_parameter_noinfo 002f ?is_valid_drive@@YAHI@Z 0039 ___doserrno 0051 __getdrive 009c ??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z 00b4 ??$common_getdcwd_dynamic_buffer@D@@YAPADQADIHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 10 85 F6 79 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 97 00 00 00 53 8B 5D 08 85 DB 74 23 53 E8 ?? ?? ?? ?? 59 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB 39 E8 ?? ?? ?? ?? 8B D8 85 DB 74 12 80 C3 40 66 C7 45 FD 3A 2E 88 5D FC C6 45 FF 00 EB 06 66 C7 45 FC 2E 00 8B 45 0C 85 C0 74 2B 85 F6 7F 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 29 56 50 C6 00 00 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C EB 16 FF 75 1C 8D 45 FC FF 75 18 FF 75 14 56 50 E8 ?? ?? ?? ?? 83 C4 14 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_3_0 {
	meta:
		name = "??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
		size = 237
		refs = "0009 ___security_cookie 001f __errno 002a __invalid_parameter_noinfo 003f ?is_valid_drive@@YAHI@Z 0049 ___doserrno 0061 __getdrive 00bd ??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z 00d5 ??$common_getdcwd_dynamic_buffer@_W@@YAPA_WQA_WIHQBDH@Z 00e5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 57 8B 7D 10 85 FF 79 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 A8 00 00 00 56 8B 75 08 85 F6 74 23 56 E8 ?? ?? ?? ?? 59 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB 48 E8 ?? ?? ?? ?? 8B F0 85 F6 74 1D 8D 46 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 2E 58 66 89 45 F8 33 C0 66 89 45 FA EB 0D 6A 2E 58 66 89 45 F4 33 C0 66 89 45 F6 85 DB 74 2D 85 FF 7F 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 2B 33 C0 57 66 89 03 8D 45 F4 53 50 E8 ?? ?? ?? ?? 83 C4 0C EB 16 FF 75 1C 8D 45 F4 FF 75 18 FF 75 14 57 50 E8 ?? ?? ?? ?? 83 C4 14 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_4_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@D@@YAPADQADIHQBDH@Z"
		size = 129
		refs = "0010 __imp__GetFullPathNameA@16 001a __imp__GetLastError@0 0020 ___acrt_errno_map_os_error 0038 _calloc 0045 ___doserrno 0050 __errno 0062 ??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z 0075 _free"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 57 57 57 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 EB 55 53 8B 5D 0C 56 3B D8 77 02 8B D8 6A 01 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 17 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B CE 8B F7 8B F9 56 E8 ?? ?? ?? ?? 59 5E 8B C7 5B 5F 5D C3 }
	condition:
		$1
}

rule file_117_5_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@_W@@YAPA_WQA_WIHQBDH@Z"
		size = 129
		refs = "0010 __imp__GetFullPathNameW@16 001a __imp__GetLastError@0 0020 ___acrt_errno_map_os_error 0038 _calloc 0045 ___doserrno 0050 __errno 0062 ??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z 0075 _free"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 57 57 57 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 EB 55 53 8B 5D 0C 56 3B D8 77 02 8B D8 6A 02 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 17 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B CE 8B F7 8B F9 56 E8 ?? ?? ?? ?? 59 5E 8B C7 5B 5F 5D C3 }
	condition:
		$1
}

rule file_117_6_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z"
		size = 90
		refs = "000c __errno 0017 __invalid_parameter_noinfo 002c __imp__GetFullPathNameA@16 0048 __imp__GetLastError@0 004e ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 77 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 6A 00 FF 75 0C FF 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 3B 45 10 72 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB D9 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB C6 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_117_7_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z"
		size = 90
		refs = "000c __errno 0017 __invalid_parameter_noinfo 002c __imp__GetFullPathNameW@16 0048 __imp__GetLastError@0 004e ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 77 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 6A 00 FF 75 0C FF 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 3B 45 10 72 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB D9 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB C6 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_117_16_0 {
	meta:
		name = "?get_full_path_name@@YAIQADQBDI@Z"
		size = 24
		refs = "0012 __imp__GetFullPathNameA@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_117_17_0 {
	meta:
		name = "?get_full_path_name@@YAIQA_WQB_WI@Z"
		size = 24
		refs = "0012 __imp__GetFullPathNameW@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_117_18_0 {
	meta:
		name = "?is_valid_drive@@YAHI@Z"
		size = 126
		refs = "0009 ___security_cookie 001b ___doserrno 0026 __errno 0031 __invalid_parameter_noinfo 0061 __imp__GetDriveTypeW@4 0076 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 1A 76 1D E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? EB 37 85 C0 75 05 33 C0 40 EB 30 83 C0 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 83 F8 01 75 CD 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_21_0 {
	meta:
		name = "__getcwd"
		size = 28
		refs = "0013 ??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 50 6A 01 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_117_23_0 {
	meta:
		name = "__wgetcwd"
		size = 28
		refs = "0013 ??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 50 6A 01 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_117_22_0 {
	meta:
		name = "__getdcwd"
		size = 30
		refs = "0015 ??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_378_26_0 {
	meta:
		name = "__dupenv_s"
		size = 30
		refs = "0015 ??$common_dupenv_s@D@@YAHQAPADQAIQBDH2H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_378_28_0 {
	meta:
		name = "__wdupenv_s"
		size = 30
		refs = "0015 ??$common_dupenv_s@_W@@YAHQAPA_WQAIQB_WHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_117_24_0 {
	meta:
		name = "__wgetdcwd"
		size = 30
		refs = "0015 ??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "___initialize_lconv_for_unsigned_char"
		size = 46
		refs = "0004 ___acrt_lconv_c"
	strings:
		$1 = { 83 C8 FF A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_119_7_0 {
	meta:
		name = "??$common_expand_argv_wildcards@D@@YAHQAPADQAPAPAD@Z"
		size = 480
		refs = "0011 __errno 001b __invalid_parameter_noinfo 004e _strpbrk 0061 ??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z 0072 ??$expand_argument_wildcards@D@@YAHQAD0AAV?$argument_list@D@?A0x5f5c8891@@@Z 00e7 ___acrt_allocate_buffer_for_argv 0155 _strncpy_s 0189 __free_base 01db __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 EC 28 56 85 C0 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 AA 01 00 00 8B 75 08 53 33 DB 57 89 18 8B FB 8B CB 89 7D D8 89 4D DC 89 5D E0 39 1E 74 4F 8D 45 FC 66 C7 45 FC 2A 3F 50 FF 36 88 5D FE E8 ?? ?? ?? ?? 59 59 85 C0 75 12 8D 45 D8 50 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 10 EB 0F 8D 4D D8 51 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 85 C0 75 7F 83 C6 04 39 1E 75 B7 8B 7D D8 8B 4D DC 8B C1 89 5D F8 2B C7 89 7D FC 8B D0 83 C0 03 C1 FA 02 42 C1 E8 02 3B CF 89 55 F4 1B F6 F7 D6 23 F0 74 30 8B C7 8B D3 8B 08 8D 41 01 89 45 F0 8A 01 41 84 C0 75 F9 8B 45 F8 2B 4D F0 40 03 C1 89 45 F8 8B 45 FC 83 C0 04 42 89 45 FC 3B D6 75 D7 8B 55 F4 6A 01 FF 75 F8 52 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 16 83 CE FF 89 75 F8 E9 88 00 00 00 8B 7D D8 8B 75 F8 E9 84 00 00 00 8B 45 F4 89 7D FC 8D 04 86 8B C8 89 45 E8 8B C7 89 4D F4 3B 7D DC 74 5B 8B D6 2B D7 89 55 E4 8B 00 8B D0 89 45 EC 8D 42 01 89 45 F0 8A 02 42 84 C0 75 F9 2B 55 F0 8D 42 01 50 FF 75 EC 89 45 F0 8B 45 E8 2B C1 03 45 F8 50 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 75 8B 45 FC 8B 55 E4 8B 4D F4 89 0C 02 83 C0 04 03 4D F0 89 4D F4 89 45 FC 3B 45 DC 75 AC 8B 45 0C 89 5D F8 89 30 8B F3 53 E8 ?? ?? ?? ?? 59 8B 45 DC 2B C7 89 7D E8 83 C0 03 C1 E8 02 39 7D DC 1B C9 F7 D1 23 C8 89 4D E4 74 1B 8B 75 E8 8B F9 FF 36 E8 ?? ?? ?? ?? 43 8D 76 04 59 3B DF 75 F0 8B 7D D8 8B 75 F8 57 E8 ?? ?? ?? ?? 59 5F 5B 8B C6 5E 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_119_8_0 {
	meta:
		name = "??$common_expand_argv_wildcards@_W@@YAHQAPA_WQAPAPA_W@Z"
		size = 541
		refs = "0009 ___security_cookie 0021 __errno 002b __invalid_parameter_noinfo 0066 _wcspbrk 0079 ??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z 008a ??$expand_argument_wildcards@_W@@YAHQA_W0AAV?$argument_list@_W@?A0x5f5c8891@@@Z 0109 ___acrt_allocate_buffer_for_argv 0181 _wcsncpy_s 01bc __free_base 020a @__security_check_cookie@4 0218 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 89 45 E0 56 8B 75 08 85 C0 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 CD 01 00 00 53 57 33 FF 89 38 8B DF 8B CF 89 5D D4 89 4D D8 89 7D DC 39 3E 74 5E 6A 2A 58 66 89 45 F4 6A 3F 58 66 89 45 F6 33 C0 66 89 45 F8 8D 45 F4 50 FF 36 E8 ?? ?? ?? ?? 59 59 85 C0 75 12 8D 45 D4 50 57 57 FF 36 E8 ?? ?? ?? ?? 83 C4 10 EB 0F 8D 4D D4 51 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 85 C0 0F 85 85 00 00 00 83 C6 04 39 3E 75 A8 8B 5D D4 8B 4D D8 8B C1 89 7D F0 2B C3 89 5D EC 8B D0 83 C0 03 C1 FA 02 42 C1 E8 02 3B CB 89 55 E8 1B F6 F7 D6 23 F0 74 36 8B C3 8B D7 8B 08 8D 41 02 89 45 E4 66 8B 01 83 C1 02 66 3B C7 75 F5 2B 4D E4 8B 45 F0 40 D1 F9 03 C1 89 45 F0 8B 45 EC 83 C0 04 42 89 45 EC 3B D6 75 D1 8B 55 E8 6A 02 FF 75 F0 52 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 16 83 CE FF 89 75 F0 E9 99 00 00 00 8B 5D D4 8B 75 F0 E9 95 00 00 00 8B 45 E8 89 5D EC 8D 04 86 8B D0 89 45 CC 8B C3 89 55 E8 3B 5D D8 74 6C 8B CE 2B CB 89 4D F4 8B 00 8B C8 89 45 D0 8D 41 02 89 45 E4 66 8B 01 83 C1 02 66 3B C7 75 F5 2B 4D E4 D1 F9 8D 41 01 8B CA 2B 4D CC 50 FF 75 D0 89 45 E4 8B 45 F0 D1 F9 2B C1 50 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 82 00 00 00 8B 45 EC 8B 4D F4 8B 55 E8 89 14 01 83 C0 04 8B 4D E4 89 45 EC 8D 14 4A 89 55 E8 3B 45 D8 75 9B 8B 45 E0 89 7D F0 89 30 8B F7 57 E8 ?? ?? ?? ?? 59 8B 45 D8 2B C3 89 5D F4 83 C0 03 C1 E8 02 39 5D D8 1B C9 F7 D1 23 C8 89 4D E0 74 1B 8B 75 F4 8B D9 FF 36 E8 ?? ?? ?? ?? 47 8D 76 04 59 3B FB 75 F0 8B 5D D4 8B 75 F0 53 E8 ?? ?? ?? ?? 59 5F 5B 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_119_9_0 {
	meta:
		name = "??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z"
		size = 180
		refs = "0036 __calloc_base 0049 _strncpy_s 0073 ?expand_if_necessary@?$argument_list@D@?A0x5f5c8891@@AAEHXZ 0082 __free_base 00af __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 08 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 83 C8 FF 57 8B 7D 10 41 2B C7 89 4D FC 3B C8 76 05 6A 0C 58 EB 77 53 56 8D 5F 01 03 D9 6A 01 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 FF 74 12 57 FF 75 0C 53 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 53 FF 75 FC 2B DF 8D 04 3E FF 75 08 53 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 3A 8B 5D 14 8B CB E8 ?? ?? ?? ?? 33 FF 89 45 FC 85 C0 74 0C 56 E8 ?? ?? ?? ?? 8B 75 FC 59 EB 0B 8B 43 04 89 30 8B F7 83 43 04 04 57 E8 ?? ?? ?? ?? 59 8B C6 5E 5B 5F 8B E5 5D C3 33 FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_119_10_0 {
	meta:
		name = "??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z"
		size = 183
		refs = "003e __calloc_base 0051 _wcsncpy_s 007b ?expand_if_necessary@?$argument_list@_W@?A0x5f5c8891@@AAEHXZ 0087 __free_base 00b2 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 08 53 57 33 DB 8D 51 02 66 8B 01 83 C1 02 66 3B C3 75 F5 8B 7D 10 2B CA D1 F9 83 C8 FF 41 2B C7 89 4D FC 3B C8 76 05 6A 0C 58 EB 70 56 8D 5F 01 03 D9 6A 02 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 FF 74 12 57 FF 75 0C 53 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 4E FF 75 FC 2B DF 8D 04 7E FF 75 08 53 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 35 8B 7D 14 8B CF E8 ?? ?? ?? ?? 8B D8 85 DB 74 09 56 E8 ?? ?? ?? ?? 59 EB 0B 8B 47 04 89 30 83 47 04 04 33 DB 6A 00 E8 ?? ?? ?? ?? 59 8B C3 5E 5F 5B 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_119_11_0 {
	meta:
		name = "??$expand_argument_wildcards@D@@YAHQAD0AAV?$argument_list@D@?A0x5f5c8891@@@Z"
		size = 388
		refs = "000c ___security_cookie 003a __mbsdec 005b ??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z 009c _memset 00b1 __imp__FindFirstFileExA@24 00d8 __imp__FindClose@4 00e7 @__security_check_cookie@4 0143 __imp__FindNextFileA@8 016a ?<lambda_invoker_cdecl>@<lambda_86056e3c024bff449830248dc1621ed2>@@CAHPBX0@Z 0178 _qsort"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 50 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 53 8B 5D 08 56 8B 75 10 57 89 B5 B8 FE FF FF EB 19 8A 01 3C 2F 74 17 3C 5C 74 13 3C 3A 74 0F 51 53 E8 ?? ?? ?? ?? 59 59 8B C8 3B CB 75 E3 8A 11 80 FA 3A 75 17 8D 43 01 3B C8 74 10 56 33 FF 57 57 53 E8 ?? ?? ?? ?? 83 C4 10 EB 7A 33 FF 80 FA 2F 74 0E 80 FA 5C 74 09 80 FA 3A 74 04 8B C7 EB 03 33 C0 40 0F B6 C0 2B CB 41 F7 D8 68 40 01 00 00 1B C0 23 C1 89 85 B4 FE FF FF 8D 85 BC FE FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 85 BC FE FF FF 57 57 57 50 57 53 FF 15 ?? ?? ?? ?? 8B F0 8B 85 B8 FE FF FF 83 FE FF 75 2D 50 57 57 53 E8 ?? ?? ?? ?? 83 C4 10 8B F8 83 FE FF 74 07 56 FF 15 ?? ?? ?? ?? 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8B 48 04 2B 08 C1 F9 02 89 8D B0 FE FF FF 80 BD E8 FE FF FF 2E 75 18 8A 8D E9 FE FF FF 84 C9 74 29 80 F9 2E 75 09 80 BD EA FE FF FF 00 74 1B 50 FF B5 B4 FE FF FF 8D 85 E8 FE FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 95 8D 85 BC FE FF FF 50 56 FF 15 ?? ?? ?? ?? 85 C0 8B 85 B8 FE FF FF 75 AC 8B 10 8B 40 04 8B 8D B0 FE FF FF 2B C2 C1 F8 02 3B C8 0F 84 67 FF FF FF 68 ?? ?? ?? ?? 2B C1 6A 04 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 10 E9 4C FF FF FF }
	condition:
		$1
}

rule file_119_12_0 {
	meta:
		name = "??$expand_argument_wildcards@_W@@YAHQA_W0AAV?$argument_list@_W@?A0x5f5c8891@@@Z"
		size = 395
		refs = "000c ___security_cookie 0036 ??R<lambda_d734a73e0f649ebd9d9b0eca0b8ca86a>@@QBE_N_W@Z 0061 ??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z 009a _memset 00af __imp__FindFirstFileExW@24 00d6 __imp__FindClose@4 00e5 @__security_check_cookie@4 0147 __imp__FindNextFileW@8 0171 ?<lambda_invoker_cdecl>@<lambda_601ce2808d07e6dd980fd6da59ab4158>@@CAHPBX0@Z 017f _qsort"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 64 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 0C 8B 4D 10 53 8B 5D 08 89 8D A4 FD FF FF 56 57 3B D3 74 20 0F B7 02 8D 8D AB FD FF FF 50 E8 ?? ?? ?? ?? 84 C0 75 07 83 EA 02 3B D3 75 E6 8B 8D A4 FD FF FF 0F B7 32 83 FE 3A 75 17 8D 43 02 3B D0 74 10 51 33 FF 57 57 53 E8 ?? ?? ?? ?? 83 C4 10 EB 72 56 8D 8D AB FD FF FF E8 ?? ?? ?? ?? 2B D3 0F B6 C0 D1 FA 42 F7 D8 68 50 02 00 00 1B C0 33 FF 23 C2 89 85 A0 FD FF FF 8D 85 AC FD FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 85 AC FD FF FF 57 57 57 50 57 53 FF 15 ?? ?? ?? ?? 8B F0 8B 85 A4 FD FF FF 83 FE FF 75 2D 50 57 57 53 E8 ?? ?? ?? ?? 83 C4 10 8B F8 83 FE FF 74 07 56 FF 15 ?? ?? ?? ?? 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8B 48 04 2B 08 C1 F9 02 6A 2E 89 8D 9C FD FF FF 59 66 39 8D D8 FD FF FF 75 1B 66 39 BD DA FD FF FF 74 2D 66 39 8D DA FD FF FF 75 09 66 39 BD DC FD FF FF 74 1B 50 FF B5 A0 FD FF FF 8D 85 D8 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 8F 8D 85 AC FD FF FF 50 56 FF 15 ?? ?? ?? ?? 6A 2E 85 C0 8B 85 A4 FD FF FF 59 75 A6 8B 10 8B 40 04 8B 8D 9C FD FF FF 2B C2 C1 F8 02 3B C8 0F 84 5E FF FF FF 68 ?? ?? ?? ?? 2B C1 6A 04 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 10 E9 43 FF FF FF }
	condition:
		$1
}

rule file_119_13_0 {
	meta:
		name = "??$find_first_file_ex@ABQADW4_FINDEX_INFO_LEVELS@@PAU_WIN32_FIND_DATAA@@W4_FINDEX_SEARCH_OPS@@$$TH@?$__crt_char_traits@D@@SAPAXABQAD$$QAW4_FINDEX_INFO_LEVELS@@$$QAPAU_WIN32_FIND_DATAA@@$$QAW4_FINDEX_SEARCH_OPS@@$$QA$$T$$QAH@Z"
		size = 43
		refs = "0025 __imp__FindFirstFileExA@24"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C FF 30 8B 45 18 FF 30 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_119_14_0 {
	meta:
		name = "??$find_first_file_ex@ABQA_WW4_FINDEX_INFO_LEVELS@@PAU_WIN32_FIND_DATAW@@W4_FINDEX_SEARCH_OPS@@$$TH@?$__crt_char_traits@_W@@SAPAXABQA_W$$QAW4_FINDEX_INFO_LEVELS@@$$QAPAU_WIN32_FIND_DATAW@@$$QAW4_FINDEX_SEARCH_OPS@@$$QA$$T$$QAH@Z"
		size = 43
		refs = "0025 __imp__FindFirstFileExW@24"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C FF 30 8B 45 18 FF 30 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_119_15_0 {
	meta:
		name = "??$find_next_file@PAXPAU_WIN32_FIND_DATAA@@@?$__crt_char_traits@D@@SAH$$QAPAX$$QAPAU_WIN32_FIND_DATAA@@@Z"
		size = 23
		refs = "0011 __imp__FindNextFileA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_119_16_0 {
	meta:
		name = "??$find_next_file@PAXPAU_WIN32_FIND_DATAW@@@?$__crt_char_traits@_W@@SAH$$QAPAX$$QAPAU_WIN32_FIND_DATAW@@@Z"
		size = 23
		refs = "0011 __imp__FindNextFileW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_601_4_4 {
	meta:
		name = "??$get_current_directory@AAKAAPAD@?$__crt_char_traits@D@@SAKAAKAAPAD@Z"
		size = 23
		refs = "0011 __imp__GetCurrentDirectoryA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_601_5_4 {
	meta:
		name = "??$get_current_directory@AAKAAPA_W@?$__crt_char_traits@_W@@SAKAAKAAPA_W@Z"
		size = 23
		refs = "0011 __imp__GetCurrentDirectoryW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_333_9_2 {
	meta:
		name = "??$get_temp_path@KABQA_W@?$__crt_char_traits@_W@@SAK$$QAKABQA_W@Z"
		size = 23
		refs = "0011 __imp__GetTempPathW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_187_14_3 {
	meta:
		name = "??$set_environment_variable@ABQADQAD@?$__crt_char_traits@D@@SAHABQAD$$QBQAD@Z"
		size = 23
		refs = "0011 __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_187_15_2 {
	meta:
		name = "??$set_environment_variable@ABQA_WQA_W@?$__crt_char_traits@_W@@SAHABQA_W$$QBQA_W@Z"
		size = 23
		refs = "0011 __imp__SetEnvironmentVariableW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_119_27_0 {
	meta:
		name = "??$tcspbrk@AAPADAAY02$$CBD@?$__crt_char_traits@D@@SAPADAAPADAAY02$$CBD@Z"
		size = 22
		refs = "000e _strpbrk"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_119_28_0 {
	meta:
		name = "??$tcspbrk@AAPA_WAAY02$$CB_W@?$__crt_char_traits@_W@@SAPA_WAAPA_WAAY02$$CB_W@Z"
		size = 22
		refs = "000e _wcspbrk"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_119_37_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__FindClose@4"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E FF 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 0E FF 5E C3 }
	condition:
		$1
}

rule file_359_1_2 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E FF 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 0E FF 5E C3 }
	condition:
		$1
}

rule file_359_2_4 {
	meta:
		name = "?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAEXXZ"
		size = 23
		refs = "000e __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E FF 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 0E FF 5E C3 }
	condition:
		$1
}

rule file_119_43_0 {
	meta:
		name = "??1?$argument_list@D@?A0x5f5c8891@@QAE@XZ"
		size = 37
		refs = "000d __free_base"
		altNames = "??1?$argument_list@_W@?A0x5f5c8891@@QAE@XZ"
	strings:
		$1 = { 8B FF 56 57 8B F9 8B 37 EB 0B FF 36 E8 ?? ?? ?? ?? 59 83 C6 04 3B 77 04 75 F0 FF 37 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_119_54_0 {
	meta:
		name = "?append@?$argument_list@D@?A0x5f5c8891@@QAEHQAD@Z"
		size = 53
		refs = "000a ?expand_if_necessary@?$argument_list@D@?A0x5f5c8891@@AAEHXZ 0018 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F1 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0D FF 75 08 E8 ?? ?? ?? ?? 59 8B C7 EB 0E 8B 4E 04 8B 45 08 89 01 83 46 04 04 33 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_119_55_0 {
	meta:
		name = "?append@?$argument_list@_W@?A0x5f5c8891@@QAEHQA_W@Z"
		size = 53
		refs = "000a ?expand_if_necessary@?$argument_list@_W@?A0x5f5c8891@@AAEHXZ 0018 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F1 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0D FF 75 08 E8 ?? ?? ?? ?? 59 8B C7 EB 0E 8B 4E 04 8B 45 08 89 01 83 46 04 04 33 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_119_67_0 {
	meta:
		name = "?expand_if_necessary@?$argument_list@D@?A0x5f5c8891@@AAEHXZ"
		size = 135
		refs = "001c __calloc_base 0025 __free_base 0059 __recalloc_base"
		altNames = "?expand_if_necessary@?$argument_list@_W@?A0x5f5c8891@@AAEHXZ"
	strings:
		$1 = { 8B FF 56 8B F1 57 8B 7E 08 39 7E 04 74 04 33 C0 EB 72 83 3E 00 75 2B 6A 04 6A 04 E8 ?? ?? ?? ?? 6A 00 89 06 E8 ?? ?? ?? ?? 8B 06 83 C4 0C 85 C0 75 05 6A 0C 58 EB 4D 89 46 04 83 C0 10 89 46 08 EB CC 2B 3E C1 FF 02 81 FF FF FF FF 7F 77 E3 53 6A 04 8D 1C 3F 53 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 05 6A 0C 5E EB 10 89 06 8D 0C B8 8D 04 98 89 4E 04 89 46 08 33 F6 6A 00 E8 ?? ?? ?? ?? 59 8B C6 5B 5F 5E C3 }
	condition:
		$1
}

rule file_120_6_0 {
	meta:
		name = "__ismbcalnum_l"
		size = 107
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0050 ___dcrt_multibyte_check_type"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 3D FF 00 00 00 77 26 0F B6 C8 BA 07 01 00 00 8B 45 F4 8B 00 66 85 14 48 75 0E 8B 45 F8 F6 44 01 19 01 75 04 33 C0 EB 19 33 C0 40 EB 14 6A 01 68 07 01 00 00 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_121_2_0 {
	meta:
		name = "??$common_strerror@D@@YAPADH@Z"
		size = 124
		refs = "0007 ___acrt_getptd_noexit 0012 ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@ 002b __calloc_base 0034 __free_base 0050 __get_sys_err_msg 0061 _strncpy_s 0077 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 07 B8 ?? ?? ?? ?? EB 31 53 57 8B 7E 40 33 DB 85 FF 75 29 6A 01 68 86 00 00 00 E8 ?? ?? ?? ?? 53 89 46 40 E8 ?? ?? ?? ?? 8B 7E 40 83 C4 0C 85 FF 75 0A B8 ?? ?? ?? ?? 5F 5B 5E 5D C3 FF 75 08 E8 ?? ?? ?? ?? 68 85 00 00 00 50 68 86 00 00 00 57 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 46 40 EB D6 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_121_3_0 {
	meta:
		name = "??$common_strerror@_W@@YAPA_WH@Z"
		size = 125
		refs = "0007 ___acrt_getptd_noexit 0012 ??_C@_1IA@JENHHBGD@?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAC?$AAR?$AAT?$AA?3?$AA?5?$AAN?$AAo?$AAt?$AA?5?$AAe?$AAn?$AAo?$AAu?$AAg?$AAh?$AA?5?$AAm?$AAe?$AAm?$AAo?$AAr@ 002b __calloc_base 0034 __free_base 0050 __get_sys_err_msg 0062 _mbstowcs_s 0078 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 07 B8 ?? ?? ?? ?? EB 31 53 57 8B 7E 44 33 DB 85 FF 75 29 6A 02 68 86 00 00 00 E8 ?? ?? ?? ?? 53 89 46 44 E8 ?? ?? ?? ?? 8B 7E 44 83 C4 0C 85 FF 75 0A B8 ?? ?? ?? ?? 5F 5B 5E 5D C3 FF 75 08 E8 ?? ?? ?? ?? 68 85 00 00 00 50 68 86 00 00 00 57 53 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 05 8B 46 44 EB D5 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_121_4_0 {
	meta:
		name = "??$common_strerror_s@D@@YAHQADIH@Z"
		size = 103
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0029 __get_sys_err_msg 0037 _strncpy_s 0062 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 56 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 38 83 7D 0C 00 76 E7 FF 75 10 E8 ?? ?? ?? ?? 6A FF 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B C8 83 C4 14 85 C9 74 0A 83 F9 16 74 11 83 F9 22 74 0C 8D 41 B0 F7 D8 1B C0 23 C1 5E 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_121_5_0 {
	meta:
		name = "??$common_strerror_s@_W@@YAHQA_WIH@Z"
		size = 104
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0029 __get_sys_err_msg 003a _mbstowcs_s 0063 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 56 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 3B 83 7D 0C 00 76 E7 FF 75 10 E8 ?? ?? ?? ?? 6A FF 50 FF 75 0C 33 F6 FF 75 08 56 E8 ?? ?? ?? ?? 8B C8 83 C4 18 85 C9 74 0A 83 F9 16 74 11 83 F9 22 74 0C 8D 41 B0 F7 D8 1B C0 23 C1 5E 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_121_10_0 {
	meta:
		name = "?copy_string_into_buffer@@YAHQBDQADII@Z"
		size = 27
		refs = "0012 _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 08 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_121_11_0 {
	meta:
		name = "?copy_string_into_buffer@@YAHQBDQA_WII@Z"
		size = 29
		refs = "0014 _mbstowcs_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 08 FF 75 10 FF 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_121_24_0 {
	meta:
		name = "__wcserror_s"
		size = 102
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0027 __get_sys_err_msg 0038 _mbstowcs_s 0061 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 56 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 39 83 7D 0C 00 76 E9 FF 75 10 E8 ?? ?? ?? ?? 6A FF 50 FF 75 0C 33 F6 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0A 83 F8 16 74 13 83 F8 22 74 0E 8D 70 B0 F7 DE 1B F6 23 F0 8B C6 5E 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_121_26_0 {
	meta:
		name = "_strerror_s"
		size = 101
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0027 __get_sys_err_msg 0035 _strncpy_s 0060 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 56 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 36 83 7D 0C 00 76 E9 FF 75 10 E8 ?? ?? ?? ?? 6A FF 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0A 83 F8 16 74 13 83 F8 22 74 0E 8D 70 B0 F7 DE 1B F6 23 F0 8B C6 5E 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_122_12_0 {
	meta:
		name = "?ctrlevent_capture@@YGHK@Z"
		size = 174
		refs = "0003 __sehtable$?ctrlevent_capture@@YGHK@Z 0008 __SEH_prolog4_GS 0017 ___acrt_lock 0021 ___security_cookie 0035 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0044 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 008c ___acrt_unlock 009c ___guard_check_icall_fptr 00a7 __SEH_epilog4_GS"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E0 89 75 DC 6A 03 E8 ?? ?? ?? ?? 59 89 75 FC 8B 15 ?? ?? ?? ?? 8B C2 8B F2 83 E0 1F 8B C8 83 7D 08 00 75 0F BB ?? ?? ?? ?? 33 35 ?? ?? ?? ?? 6A 02 EB 0D BB ?? ?? ?? ?? 33 35 ?? ?? ?? ?? 6A 15 D3 CE 89 75 E0 5F 89 7D DC 85 F6 74 12 83 FE 01 74 0D 6A 20 59 2B C8 33 C0 D3 C8 33 C2 89 03 C7 45 FC FE FF FF FF E8 0E 00 00 00 85 F6 75 13 33 C0 EB 23 8B 75 E0 8B 7D DC 6A 03 E8 ?? ?? ?? ?? 59 C3 83 FE 01 74 0C 57 8B CE FF 15 ?? ?? ?? ?? FF D6 59 33 C0 40 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_122_14_0 {
	meta:
		name = "?get_global_action_nolock@@YAPAP6AXH@ZH@Z"
		size = 66
		refs = "0027 ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 002e ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0035 ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 003c ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 48 83 E8 01 74 2D 83 E8 04 74 13 83 E8 09 74 1C 83 E8 06 74 10 83 E8 01 74 04 33 C0 5D C3 B8 ?? ?? ?? ?? 5D C3 B8 ?? ?? ?? ?? 5D C3 B8 ?? ?? ?? ?? 5D C3 B8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_122_15_0 {
	meta:
		name = "?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QAEXQ6AXH@Z@Z"
		size = 49
		altNames = "?initialize@?$dual_state_global@H@__crt_state_management@@QAEXH@Z ?initialize@?$dual_state_global@J@__crt_state_management@@QAEXJ@Z ?initialize@?$dual_state_global@P6AHI@Z@__crt_state_management@@QAEXQ6AHI@Z@Z ?initialize@?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@QAEXQ6AHPAU_exception@@@Z@Z ?initialize@?$dual_state_global@PAPAD@__crt_state_management@@QAEXQAPAD@Z ?initialize@?$dual_state_global@PAPA_W@__crt_state_management@@QAEXQAPA_W@Z ?initialize@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEXQAU__crt_locale_data@@@Z ?initialize@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAEXQAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8D 41 04 8B D0 2B D1 83 C2 03 56 33 F6 C1 EA 02 3B C1 1B C0 F7 D0 23 C2 74 0D 8B 55 08 46 89 11 8D 49 04 3B F0 75 F6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_16_0 {
	meta:
		name = "?siglookup@@YAPAU__crt_signal_action_t@@HQAU1@@Z"
		size = 40
		refs = "0007 ___acrt_signal_action_table_count"
	strings:
		$1 = { 8B FF 55 8B EC 6B 0D ?? ?? ?? ?? 0C 8B 45 0C 03 C8 3B C1 74 0F 8B 55 08 39 50 04 74 09 83 C0 0C 3B C1 75 F4 33 C0 5D C3 }
	condition:
		$1
}

rule file_122_17_0 {
	meta:
		name = "?signal_failed@@YAP6AXH@ZH@Z"
		size = 49
		refs = "0022 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 01 74 1F 83 F8 03 74 1A 83 F8 0D 74 15 83 F8 0F 7E 05 83 F8 11 7E 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_122_19_0 {
	meta:
		name = "___acrt_get_sigabrt_handler"
		size = 23
		refs = "000d ??$__acrt_lock_and_call@V<lambda_44731a7d0e6d81c3e6aa82d741081786>@@@@YAP6AXH@ZW4__acrt_lock_id@@$$QAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 FF 50 6A 03 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_122_20_0 {
	meta:
		name = "___acrt_initialize_signal_handlers"
		size = 59
		refs = "0009 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 000e ?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QAEXQ6AXH@Z@Z 0016 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0023 ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0030 ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_122_23_0 {
	meta:
		name = "_raise"
		size = 520
		refs = "0003 __sehtable$_raise 0008 __SEH_prolog4_GS 0051 ?get_global_action_nolock@@YAPAP6AXH@ZH@Z 005b ___acrt_getptd_noexit 0074 ?siglookup@@YAPAU__crt_signal_action_t@@HQAU1@@Z 0086 __errno 0091 __invalid_parameter_noinfo 00ad ___acrt_lock 00ca ___security_cookie 0104 ___acrt_unlock 010c __exit 012d ___fpecode 0147 ___acrt_signal_action_first_fpe_index 0150 ___acrt_signal_action_fpe_count 019a ___acrt_getptd 01a7 ___guard_check_icall_fptr 0203 __SEH_epilog4_GS"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D D4 21 5D C8 B1 01 88 4D E3 8B 75 08 6A 08 5F 3B F7 7F 18 74 35 8D 46 FF 83 E8 01 74 22 48 83 E8 01 74 27 48 83 E8 01 75 4C EB 14 83 FE 0B 74 1A 83 FE 0F 74 0A 83 FE 14 7E 3B 83 FE 16 7F 36 56 E8 ?? ?? ?? ?? 83 C4 04 EB 45 E8 ?? ?? ?? ?? 8B D8 89 5D D4 85 DB 75 08 83 C8 FF E9 92 01 00 00 FF 33 56 E8 ?? ?? ?? ?? 59 59 33 C9 85 C0 0F 95 C1 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB D1 83 C0 08 32 C9 88 4D E3 89 45 D8 83 65 CC 00 84 C9 74 0B 6A 03 E8 ?? ?? ?? ?? 59 8A 4D E3 83 65 DC 00 C6 45 E2 00 83 65 FC 00 8B 45 D8 84 C9 74 14 8B 15 ?? ?? ?? ?? 8B CA 83 E1 1F 33 10 D3 CA 8A 4D E3 EB 02 8B 10 8B C2 89 45 DC 33 D2 83 F8 01 0F 94 C2 89 55 D0 88 55 E2 84 D2 0F 85 8A 00 00 00 85 C0 75 13 84 C9 74 08 6A 03 E8 ?? ?? ?? ?? 59 6A 03 E8 ?? ?? ?? ?? 3B F7 74 0A 83 FE 0B 74 05 83 FE 04 75 23 8B 43 04 89 45 CC 83 63 04 00 3B F7 75 3B E8 ?? ?? ?? ?? 8B 00 89 45 C8 E8 ?? ?? ?? ?? C7 00 8C 00 00 00 3B F7 75 22 6B 05 ?? ?? ?? ?? 0C 03 03 6B 0D ?? ?? ?? ?? 0C 03 C8 89 45 C4 3B C1 74 25 83 60 08 00 83 C0 0C EB F0 A1 ?? ?? ?? ?? 83 E0 1F 6A 20 59 2B C8 33 C0 D3 C8 33 05 ?? ?? ?? ?? 8B 4D D8 89 01 C7 45 FC FE FF FF FF E8 31 00 00 00 80 7D D0 00 75 6B 3B F7 75 36 E8 ?? ?? ?? ?? FF 70 08 57 8B 4D DC FF 15 ?? ?? ?? ?? FF 55 DC 59 EB 2B 6A 08 5F 8B 75 08 8B 5D D4 8A 45 E2 89 45 D0 80 7D E3 00 74 08 6A 03 E8 ?? ?? ?? ?? 59 C3 56 8B 4D DC FF 15 ?? ?? ?? ?? FF 55 DC 59 3B F7 74 0A 83 FE 0B 74 05 83 FE 04 75 15 8B 45 CC 89 43 04 3B F7 75 0B E8 ?? ?? ?? ?? 8B 4D C8 89 48 08 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_122_24_0 {
	meta:
		name = "_signal"
		size = 434
		refs = "0003 __sehtable$_signal 0008 __SEH_prolog4 0067 ___acrt_getptd_noexit 0073 ___acrt_exception_action_table 007b ___acrt_signal_action_table_size 0080 __malloc_base 0098 _memcpy 00a7 ?siglookup@@YAPAU__crt_signal_action_t@@HQAU1@@Z 00c0 ___acrt_signal_action_table_count 00f7 ___acrt_lock 010b ?console_ctrl_handler_installed@@3_NA 0115 ?ctrlevent_capture@@YGHK@Z 011b __imp__SetConsoleCtrlHandler@8 012d ___doserrno 0135 __imp__GetLastError@0 0145 ?get_global_action_nolock@@YAPAP6AXH@ZH@Z 0155 ___security_cookie 016f ??$__crt_fast_encode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z 019d ___acrt_unlock 01a7 ?signal_failed@@YAP6AXH@ZH@Z 01ad __SEH_epilog4"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 0C 83 FB 04 0F 84 8B 01 00 00 83 FB 03 0F 84 82 01 00 00 8B 7D 08 83 FF 02 0F 84 BA 00 00 00 83 FF 15 0F 84 B1 00 00 00 83 FF 16 0F 84 A8 00 00 00 83 FF 06 0F 84 9F 00 00 00 83 FF 0F 0F 84 96 00 00 00 83 FF 08 74 10 83 FF 04 74 0B 83 FF 0B 74 06 57 E9 40 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 74 EF 81 3E ?? ?? ?? ?? 75 26 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 06 85 C0 74 D5 FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 06 89 45 DC 50 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 AF 8D 50 08 8B 0A 89 4D D8 83 FB 02 74 22 6B 35 ?? ?? ?? ?? 0C 03 75 DC 3B C6 74 14 39 7A FC 75 0C 89 1A 83 C2 0C 8D 4A F8 3B CE 75 EF 8B 4D D8 8B C1 E9 C5 00 00 00 33 DB 88 5D E7 8B F3 89 75 D8 89 75 E0 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 83 FF 02 74 05 83 FF 15 75 3A 80 3D ?? ?? ?? ?? 00 75 31 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 09 C6 05 ?? ?? ?? ?? 01 EB 17 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 89 06 B3 01 88 5D E7 8B 75 D8 57 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 85 C0 74 26 8B 35 ?? ?? ?? ?? 8B CE 83 E1 1F 33 30 D3 CE 89 75 E0 8B 45 0C 83 F8 02 74 0C 50 E8 ?? ?? ?? ?? 59 8B 4D D8 89 01 C7 45 FC FE FF FF FF E8 15 00 00 00 84 DB 0F 85 D3 FE FF FF 8B C6 EB 1B 8B 7D 08 8A 5D E7 8B 75 E0 6A 03 E8 ?? ?? ?? ?? 59 C3 FF 75 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_123_22_0 {
	meta:
		name = "??0__crt_scoped_get_last_error_reset@@QAE@XZ"
		size = 17
		refs = "0007 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 56 8B F1 FF 15 ?? ?? ?? ?? 89 06 8B C6 5E C3 }
	condition:
		$1
}

rule file_123_38_0 {
	meta:
		name = "?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z"
		size = 121
		refs = "0017 ___acrt_exception_action_table 002b ___acrt_initial_multibyte_data 0057 ??$__acrt_lock_and_call@V<lambda_da44e0f8b0f19ba52fefafb335991732>@@@@YAXW4__acrt_lock_id@@$$QAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@@Z 006e ??$__acrt_lock_and_call@V<lambda_46720907175c18b6c9d2717bc0d2d362>@@@@YAXW4__acrt_lock_id@@$$QAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 08 33 C9 41 6A 43 89 48 18 8B 45 08 C7 00 ?? ?? ?? ?? 8B 45 08 89 88 50 03 00 00 8B 45 08 59 C7 40 48 ?? ?? ?? ?? 8B 45 08 66 89 48 6C 8B 45 08 66 89 88 72 01 00 00 8B 45 08 83 A0 4C 03 00 00 00 8D 45 08 89 45 FC 8D 45 FC 50 6A 05 E8 ?? ?? ?? ?? 8D 45 08 89 45 F8 8D 45 0C 89 45 FC 8D 45 F8 50 6A 04 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_39_0 {
	meta:
		name = "?construct_ptd_array@@YAXQAU__acrt_ptd@@@Z"
		size = 22
		refs = "0006 ___acrt_current_locale_data 000e ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_7_0 {
	meta:
		name = "__iswalnum_l"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_8_0 {
	meta:
		name = "__iswalpha_l"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_14_2 {
	meta:
		name = "__iswgraph_l"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_16_4 {
	meta:
		name = "__iswprint_l"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_20_3 {
	meta:
		name = "__iswxdigit_l"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_22_3 {
	meta:
		name = "_iswalnum"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_23_3 {
	meta:
		name = "_iswalpha"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_28_3 {
	meta:
		name = "_iswgraph"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_30_4 {
	meta:
		name = "_iswprint"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_295_34_4 {
	meta:
		name = "_iswxdigit"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_123_41_0 {
	meta:
		name = "?destroy_fls@@YGXPAX@Z"
		size = 33
		refs = "000f ?destroy_ptd@@YAXQAU__acrt_ptd@@@Z 0017 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 12 FF 75 08 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_123_42_0 {
	meta:
		name = "?destroy_ptd@@YAXQAU__acrt_ptd@@@Z"
		size = 169
		refs = "000d ___acrt_exception_action_table 0015 __free_base 008d ??$__acrt_lock_and_call@V<lambda_5ce1d447e08cb34b2473517608e21441>@@@@YAXW4__acrt_lock_id@@$$QAV<lambda_5ce1d447e08cb34b2473517608e21441>@@@Z 009e ??$__acrt_lock_and_call@V<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@@@YAXW4__acrt_lock_id@@$$QAV<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 81 F9 ?? ?? ?? ?? 74 0A 51 E8 ?? ?? ?? ?? 8B 45 08 59 FF 70 3C E8 ?? ?? ?? ?? 8B 45 08 FF 70 30 E8 ?? ?? ?? ?? 8B 45 08 FF 70 34 E8 ?? ?? ?? ?? 8B 45 08 FF 70 38 E8 ?? ?? ?? ?? 8B 45 08 FF 70 28 E8 ?? ?? ?? ?? 8B 45 08 FF 70 2C E8 ?? ?? ?? ?? 8B 45 08 FF 70 40 E8 ?? ?? ?? ?? 8B 45 08 FF 70 44 E8 ?? ?? ?? ?? 8B 45 08 FF B0 60 03 00 00 E8 ?? ?? ?? ?? 8D 45 08 89 45 FC 8D 45 FC 50 6A 05 E8 ?? ?? ?? ?? 8D 45 08 89 45 FC 8D 45 FC 50 6A 04 E8 ?? ?? ?? ?? 83 C4 34 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_47_0 {
	meta:
		name = "?internal_get_ptd_head@@YAPAU__acrt_ptd@@XZ"
		size = 133
		refs = "0001 ?__acrt_flsindex@@3KA 000c ___acrt_FlsGetValue@4 0029 ___acrt_FlsSetValue@8 003c __calloc_base 0069 ___acrt_current_locale_data 006f ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z 007b __free_base"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 1B 50 E8 ?? ?? ?? ?? 8B C8 85 C9 74 0A 8D 41 01 F7 D8 1B C0 23 C1 C3 A1 ?? ?? ?? ?? 6A FF 50 E8 ?? ?? ?? ?? 85 C0 75 01 C3 56 57 68 64 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 10 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 10 33 FF 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 11 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 8B FE 33 F6 59 56 E8 ?? ?? ?? ?? 59 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_123_48_0 {
	meta:
		name = "?internal_getptd_noexit@@YAPAU__acrt_ptd@@XZ"
		size = 172
		refs = "0007 __imp__GetLastError@0 0010 ?__acrt_flsindex@@3KA 001b ___acrt_FlsGetValue@4 0035 ___acrt_FlsSetValue@8 0045 __calloc_base 005f __free_base 0086 ___acrt_current_locale_data 008c ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z 00a2 __imp__SetLastError@4"
	strings:
		$1 = { 8B FF 53 56 57 FF 15 ?? ?? ?? ?? 8B F0 33 DB A1 ?? ?? ?? ?? 83 F8 FF 74 18 50 E8 ?? ?? ?? ?? 8B F8 85 FF 74 07 83 FF FF 74 73 EB 6D A1 ?? ?? ?? ?? 6A FF 50 E8 ?? ?? ?? ?? 85 C0 74 60 68 64 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 15 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 EB 37 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 EB D9 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 75 02 8B FB 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule file_123_51_0 {
	meta:
		name = "?replace_current_thread_locale_nolock@@YAXQAU__acrt_ptd@@QAU__crt_locale_data@@@Z"
		size = 75
		refs = "0013 ___acrt_release_locale_ref 001d ___acrt_current_locale_data 0024 ___acrt_initial_locale_data 0032 ___acrt_free_locale 0044 ___acrt_add_locale_ref"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 83 7E 4C 00 74 28 FF 76 4C E8 ?? ?? ?? ?? 8B 46 4C 59 3B 05 ?? ?? ?? ?? 74 14 3D ?? ?? ?? ?? 74 0D 83 78 0C 00 75 07 50 E8 ?? ?? ?? ?? 59 8B 45 0C 89 46 4C 5E 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_123_52_0 {
	meta:
		name = "?try_get_ptd_head@@YAPAU__acrt_ptd@@XZ"
		size = 20
		refs = "0001 ?__acrt_flsindex@@3KA 000f ___acrt_FlsGetValue@4"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 75 03 33 C0 C3 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_123_54_0 {
	meta:
		name = "___acrt_freeptd"
		size = 44
		refs = "0001 ?__acrt_flsindex@@3KA 000d ___acrt_FlsGetValue@4 0020 ___acrt_FlsSetValue@8 0026 ?destroy_fls@@YGXPAX@Z"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 21 56 50 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 6A 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_123_55_0 {
	meta:
		name = "___acrt_getptd"
		size = 180
		refs = "0006 __imp__GetLastError@0 000d ?__acrt_flsindex@@3KA 0018 ___acrt_FlsGetValue@4 0032 ___acrt_FlsSetValue@8 0042 __calloc_base 005c __free_base 0083 ___acrt_current_locale_data 0089 ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z 009e __imp__SetLastError@4 00af _abort"
	strings:
		$1 = { 8B FF 56 57 FF 15 ?? ?? ?? ?? 8B F0 A1 ?? ?? ?? ?? 83 F8 FF 74 18 50 E8 ?? ?? ?? ?? 8B F8 85 FF 74 07 83 FF FF 75 70 EB 7E A1 ?? ?? ?? ?? 6A FF 50 E8 ?? ?? ?? ?? 85 C0 74 6D 68 64 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 15 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 EB 44 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 EB D9 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 74 0C 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5E C3 56 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_123_56_0 {
	meta:
		name = "___acrt_getptd_head"
		size = 154
		refs = "0001 ?__acrt_flsindex@@3KA 000d ___acrt_FlsGetValue@4 0027 ___acrt_FlsSetValue@8 0037 __calloc_base 0051 __free_base 0078 ___acrt_current_locale_data 007e ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z 0095 _abort"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 83 F8 FF 74 18 50 E8 ?? ?? ?? ?? 8B F0 85 F6 74 07 83 FE FF 75 70 EB 76 A1 ?? ?? ?? ?? 6A FF 50 E8 ?? ?? ?? ?? 85 C0 74 65 68 64 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 15 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 EB 3C 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 EB D9 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 74 04 8B C6 5E C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_123_57_0 {
	meta:
		name = "___acrt_getptd_noexit"
		size = 179
		refs = "0007 __imp__GetLastError@0 0010 ?__acrt_flsindex@@3KA 001b ___acrt_FlsGetValue@4 002d __imp__SetLastError@4 0042 ___acrt_FlsSetValue@8 0052 __calloc_base 006c __free_base 0093 ___acrt_current_locale_data 0099 ?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z"
	strings:
		$1 = { 8B FF 53 56 57 FF 15 ?? ?? ?? ?? 8B F0 33 DB A1 ?? ?? ?? ?? 83 F8 FF 74 25 50 E8 ?? ?? ?? ?? 8B F8 85 FF 74 14 83 FF FF 75 7C 56 FF 15 ?? ?? ?? ?? 8B FB 8B C7 5F 5E 5B C3 A1 ?? ?? ?? ?? 6A FF 50 E8 ?? ?? ?? ?? 85 C0 74 E0 68 64 03 00 00 6A 01 E8 ?? ?? ?? ?? 59 59 8B F8 85 FF 75 15 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 EB B7 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 EB D9 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 74 80 56 FF 15 ?? ?? ?? ?? EB 80 }
	condition:
		$1
}

rule file_123_58_0 {
	meta:
		name = "___acrt_initialize_ptd"
		size = 44
		refs = "0001 ?destroy_fls@@YGXPAX@Z 0006 ___acrt_FlsAlloc@4 000b ?__acrt_flsindex@@3KA 0018 ___acrt_getptd_noexit 0022 ___acrt_uninitialize_ptd"
	strings:
		$1 = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 75 03 32 C0 C3 E8 ?? ?? ?? ?? 85 C0 75 09 50 E8 ?? ?? ?? ?? 59 EB EB B0 01 C3 }
	condition:
		$1
}

rule file_123_59_0 {
	meta:
		name = "___acrt_uninitialize_ptd"
		size = 26
		refs = "0001 ?__acrt_flsindex@@3KA 000c ___acrt_FlsFree@4"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 0D 50 E8 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF B0 01 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_remquof"
		size = 471
		refs = "0010 __fdtest 009b __fdunscale 00e2 __real@3fe0000000000000 011d __fdscale 01c5 __fperrraise 01cb __FNan_C"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 45 08 53 56 57 50 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 0C 50 E8 ?? ?? ?? ?? 59 59 8B 4D 10 33 DB 0F B7 C0 85 C9 74 02 89 19 33 C9 66 3B CE 0F 8E 64 01 00 00 66 3B C8 0F 8E 5B 01 00 00 D9 EE 33 FF D9 45 0C 47 D8 D1 DF E0 F6 C4 05 7A 0C D9 E0 8B F7 D9 5D 0C D9 45 0C EB 02 8B F3 D9 45 08 D8 D2 89 75 F0 DF E0 DD DA F6 C4 05 7A 16 8B C7 89 7D EC D9 C9 2B C6 D9 E0 0F B7 C0 D9 5D 08 89 45 F0 EB 05 DD D9 89 5D EC 8D 45 F4 50 8D 45 F8 50 D9 5D F4 E8 ?? ?? ?? ?? D9 45 08 59 D9 5D F4 59 EB 02 DD D8 8D 45 F4 50 8D 45 FC 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 74 0C 0F BF 75 FC 0F BF 45 F8 2B F0 79 46 D9 45 08 D9 EE D8 D1 DF E0 F6 C4 05 0F 8A 97 00 00 00 D9 45 0C DD 05 ?? ?? ?? ?? D8 C9 D9 5D F4 D9 45 F4 D8 D3 DF E0 F6 C4 05 7A 69 D8 D2 DF E0 DD DA F6 C4 41 75 60 DD D9 DE E9 43 D9 5D 08 D9 45 08 EB 67 DD D8 D9 45 0C 8D 45 F4 56 50 D9 5D F4 E8 ?? ?? ?? ?? D9 45 F4 D9 45 08 D8 D1 DF E0 59 59 F6 C4 01 74 09 83 EE 01 DD D9 79 D6 EB 15 DE E1 D9 5D 08 D9 45 08 83 FE 20 73 08 8B C7 8B CE D3 E0 03 D8 D9 55 F4 85 F6 0F 89 4E FF FF FF E9 6E FF FF FF DD DA D9 C2 DD EA DF E0 DD D9 F6 C4 44 7A 05 F6 C3 01 75 90 DD D8 8B 45 10 85 C0 74 11 81 E3 FF FF FF 7F 66 83 7D F0 00 74 02 F7 DB 89 18 66 83 7D EC 00 74 02 D9 E0 D9 5D EC D9 45 EC EB 31 6A 02 59 66 3B F1 75 05 D9 45 08 EB 24 66 3B C1 75 05 D9 45 0C EB 1A 33 FF 47 66 3B F7 74 05 66 85 C0 75 E4 57 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_4_0 {
	meta:
		name = "__get_fmode"
		size = 44
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0022 __fmode"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_667_12_0 {
	meta:
		name = "__get_daylight"
		size = 44
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0022 ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_667_13_0 {
	meta:
		name = "__get_dstbias"
		size = 44
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0022 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_667_14_0 {
	meta:
		name = "__get_timezone"
		size = 44
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0022 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_125_5_0 {
	meta:
		name = "__set_fmode"
		size = 61
		refs = "001e __errno 0029 __invalid_parameter_noinfo 0033 __fmode"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3D 00 40 00 00 74 23 3D 00 80 00 00 74 1C 3D 00 00 01 00 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 B9 ?? ?? ?? ?? 87 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_125_6_0 {
	meta:
		name = "__setmode"
		size = 270
		refs = "0003 __sehtable$__setmode 0008 __SEH_prolog4 0038 __errno 0069 __nhandle 0089 ___pioinfo 0099 ___acrt_lowio_lock_fh 00cc __setmode_nolock 00ef ___acrt_lowio_unlock_fh 0101 __invalid_parameter_noinfo 0109 __SEH_epilog4"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 0C 81 FF 00 40 00 00 74 30 81 FF 00 80 00 00 74 28 81 FF 00 00 01 00 74 20 81 FF 00 00 04 00 74 18 81 FF 00 00 02 00 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B9 00 00 00 8B 75 08 83 FE FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 A6 00 00 00 85 F6 0F 88 8E 00 00 00 3B 35 ?? ?? ?? ?? 0F 83 82 00 00 00 8B CE C1 F9 06 89 4D E0 8B C6 83 E0 3F 6B D0 30 89 55 DC 8B 04 8D ?? ?? ?? ?? 0F B6 44 10 28 83 E0 01 74 5E 56 E8 ?? ?? ?? ?? 59 83 CB FF 89 5D E4 83 65 FC 00 8B 45 E0 8B 04 85 ?? ?? ?? ?? 8B 4D DC F6 44 08 28 01 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 0E 57 56 E8 ?? ?? ?? ?? 59 59 8B D8 89 5D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C3 EB 21 8B 75 08 8B 5D E4 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_125_7_0 {
	meta:
		name = "__setmode_nolock"
		size = 209
		refs = "001a ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 53 56 57 8B F8 83 E0 3F C1 FF 06 6B D0 30 8B 34 BD ?? ?? ?? ?? 8A 44 16 28 8A 5C 16 29 0F B6 C8 81 E1 80 00 00 00 89 4D FC 8B 4D 0C 81 F9 00 40 00 00 74 50 81 F9 00 80 00 00 74 40 81 F9 00 00 01 00 74 24 81 F9 00 00 02 00 74 1C 81 F9 00 00 04 00 75 42 0C 80 88 44 16 28 8B 04 BD ?? ?? ?? ?? C6 44 10 29 01 EB 2E 0C 80 88 44 16 28 8B 04 BD ?? ?? ?? ?? C6 44 10 29 02 EB 1A 24 7F 88 44 16 28 EB 12 0C 80 88 44 16 28 8B 0C BD ?? ?? ?? ?? C6 44 11 29 00 83 7D FC 00 75 07 B8 00 80 00 00 EB 1E 84 DB 75 07 B8 00 40 00 00 EB 13 33 C0 80 FB 01 0F 95 C0 48 25 00 00 03 00 05 00 00 01 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_4_0 {
	meta:
		name = "__strxfrm_l"
		size = 288
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0035 __errno 0040 __invalid_parameter_noinfo 006a _strncpy 009c ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 4D EC 53 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 5D 10 BE FF FF FF 7F 3B DE 77 12 8B 7D 08 85 FF 75 04 85 DB 75 07 8B 45 0C 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 BE 00 00 00 85 FF 74 07 85 DB 74 03 C6 07 00 8B 4D F0 8B 91 A4 00 00 00 85 D2 75 24 39 51 10 75 1F 53 50 57 E8 ?? ?? ?? ?? 8B 75 0C 83 C4 0C 8D 4E 01 8A 06 46 84 C0 75 F9 2B F1 E9 82 00 00 00 6A 01 FF 71 10 6A 00 6A 00 6A FF 50 68 00 04 00 00 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 FC 85 C0 74 4C 3B C3 76 1E 85 FF 74 15 85 DB 74 11 C6 07 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 FC 8D 70 FF EB 3B 8B 45 F0 6A 01 FF 70 10 53 57 6A FF FF 75 0C 68 00 04 00 00 FF B0 A4 00 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 04 8B 75 FC 4E 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_128_3_0 {
	meta:
		name = "?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
		size = 89
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 75 0C 8B 45 F8 8A 4D 14 84 4C 30 19 75 1B 33 D2 39 55 10 74 0E 8B 45 F4 8B 00 0F B7 04 70 23 45 10 EB 02 8B C2 85 C0 74 03 33 D2 42 80 7D FC 00 5E 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_128_5_0 {
	meta:
		name = "__ismbbalnum"
		size = 27
		refs = "0012 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 68 07 01 00 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_6_0 {
	meta:
		name = "__ismbbalnum_l"
		size = 28
		refs = "0013 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 68 07 01 00 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_7_0 {
	meta:
		name = "__ismbbalpha"
		size = 27
		refs = "0012 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 68 03 01 00 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_8_0 {
	meta:
		name = "__ismbbalpha_l"
		size = 28
		refs = "0013 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 68 03 01 00 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_9_0 {
	meta:
		name = "__ismbbblank"
		size = 35
		refs = "001a ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 09 75 05 6A 40 58 5D C3 6A 02 6A 40 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_10_0 {
	meta:
		name = "__ismbbblank_l"
		size = 36
		refs = "001b ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 09 75 05 6A 40 58 5D C3 6A 02 6A 40 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_11_0 {
	meta:
		name = "__ismbbgraph"
		size = 27
		refs = "0012 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 68 17 01 00 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_12_0 {
	meta:
		name = "__ismbbgraph_l"
		size = 28
		refs = "0013 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 68 17 01 00 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_13_0 {
	meta:
		name = "__ismbbkalnum"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_14_0 {
	meta:
		name = "__ismbbkalnum_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_16_0 {
	meta:
		name = "__ismbbkana_l"
		size = 81
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002e ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 85 C0 74 1F 81 78 04 A4 03 00 00 75 16 6A 03 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 8B C8 EB 02 33 C9 80 7D FC 00 74 0A 8B 45 F0 83 A0 50 03 00 00 FD 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_128_17_0 {
	meta:
		name = "__ismbbkprint"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 6A 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_18_0 {
	meta:
		name = "__ismbbkprint_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_19_0 {
	meta:
		name = "__ismbbkpunct"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 6A 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_20_0 {
	meta:
		name = "__ismbbkpunct_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_21_0 {
	meta:
		name = "__ismbblead"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 04 6A 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_22_0 {
	meta:
		name = "__ismbblead_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 04 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_23_0 {
	meta:
		name = "__ismbbprint"
		size = 27
		refs = "0012 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 68 57 01 00 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_24_0 {
	meta:
		name = "__ismbbprint_l"
		size = 28
		refs = "0013 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 68 57 01 00 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_25_0 {
	meta:
		name = "__ismbbpunct"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 6A 10 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_26_0 {
	meta:
		name = "__ismbbpunct_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 6A 10 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_27_0 {
	meta:
		name = "__ismbbtrail"
		size = 24
		refs = "000f ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 6A 00 FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_128_28_0 {
	meta:
		name = "__ismbbtrail_l"
		size = 25
		refs = "0010 ?x_ismbbtype_l@@YAHPAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 6A 00 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_ccosl"
		size = 104
		refs = "0017 _creall 002b _cimagl 003c __LCbuild 0050 _ccoshl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "_ccos"
		size = 104
		refs = "0017 _creal 002b _cimag 003c __Cbuild 0050 _ccosh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "_cimagl"
		size = 49
		refs = "0009 ___security_cookie 0029 @__security_check_cookie@4"
		altNames = "_cimag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 4D FC 8D 75 08 33 CD 8D 7D EC A5 A5 A5 A5 DD 45 F4 5F 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_131_5_0 {
	meta:
		name = "__fcloseall"
		size = 160
		refs = "0003 __sehtable$__fcloseall 0008 __SEH_prolog4 0013 ___acrt_lock 0024 __nstream 002b ___piob 0049 _fclose 0064 __imp__DeleteCriticalSection@4 0071 __free_base 0092 __SEH_epilog4 009a ___acrt_unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 6A 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 03 5E 89 75 E0 3B 35 ?? ?? ?? ?? 74 58 A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 49 8B 40 0C C1 E8 0D A8 01 74 16 A1 ?? ?? ?? ?? FF 34 B0 E8 ?? ?? ?? ?? 59 83 F8 FF 74 03 FF 45 E4 A1 ?? ?? ?? ?? 8B 04 B0 83 C0 20 50 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? FF 34 B0 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? 83 24 B0 00 46 EB 9D C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_132_5_0 {
	meta:
		name = "__mbschr_l"
		size = 162
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 001d __errno 0028 __invalid_parameter_noinfo 003f _strchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 55 08 85 D2 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 F6 EB 5A 8B 7D F8 33 F6 39 77 08 75 3E FF 75 0C 52 E8 ?? ?? ?? ?? 59 59 8B F0 EB 41 0F B6 C1 F6 44 38 19 04 74 1C 42 8A 02 84 C0 74 30 0F B7 C9 C1 E1 08 0F B6 C0 0B C8 39 4D 0C 75 0D 8D 72 FF EB 1B 0F B7 C1 39 45 0C 74 09 42 0F B6 0A 66 85 C9 75 C9 0F B7 C1 39 45 0C 75 02 8B F2 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "_catanl"
		size = 165
		refs = "0017 _creall 002b _cimagl 003c __LCbuild 0050 _catanhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_casin"
		size = 165
		refs = "0017 _creal 002b _cimag 003c __Cbuild 0050 _casinh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_715_0_4 {
	meta:
		name = "_casinl"
		size = 165
		refs = "0017 _creall 002b _cimagl 003c __LCbuild 0050 _casinhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_catan"
		size = 165
		refs = "0017 _creal 002b _cimag 003c __Cbuild 0050 _catanh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_284_0_3 {
	meta:
		name = "_csin"
		size = 165
		refs = "0017 _creal 002b _cimag 003c __Cbuild 0050 _csinh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_292_0_3 {
	meta:
		name = "_csinl"
		size = 165
		refs = "0017 _creall 002b _cimagl 003c __LCbuild 0050 _csinhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_471_0_2 {
	meta:
		name = "_ctan"
		size = 165
		refs = "0017 _creal 002b _cimag 003c __Cbuild 0050 _ctanh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_381_0_2 {
	meta:
		name = "_ctanl"
		size = 165
		refs = "0017 _creall 002b _cimagl 003c __LCbuild 0050 _ctanhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 0C A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 08 8D 45 F0 D9 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 E0 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D 0C 83 C4 04 A5 A5 A5 A5 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 8B FC 8D 75 0C D9 E0 DD 5C 24 10 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 8D 45 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "_wcscpy"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 55 0C 56 8B F0 2B F2 0F B7 0A 66 89 0C 16 8D 52 02 66 85 C9 75 F1 5E 5D C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "??$common_tcsnset_s@_W@@YAHQA_WI_WI@Z"
		size = 126
		refs = "006b __errno 0075 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 8B 75 14 85 F6 75 0D 85 C9 75 0D 39 4D 0C 75 51 33 C0 EB 5E 85 C9 74 49 8B 55 0C 85 D2 74 42 53 33 DB 8B C1 66 39 19 74 1B 57 66 8B 7D 10 85 F6 74 11 83 EA 01 74 0C 66 89 38 83 C0 02 4E 66 39 18 75 EB 5F 85 F6 75 0F EB 08 83 EA 01 74 08 83 C0 02 66 39 18 75 F3 33 C0 5B 85 D2 75 14 66 89 01 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_136_5_0 {
	meta:
		name = "__mbsncoll_l"
		size = 239
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0031 __errno 003c __invalid_parameter_noinfo 0077 __strncoll_l 008a __mbsnbcnt_l 00bb ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 53 57 FF 75 14 E8 ?? ?? ?? ?? 8B 5D 10 85 DB 75 07 33 FF E9 B4 00 00 00 8B 4D 08 85 C9 74 06 83 7D 0C 00 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BF FF FF FF 7F E9 8D 00 00 00 BF FF FF FF 7F 3B DF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 72 8B 45 F8 83 78 08 00 75 14 FF 75 14 53 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 10 8B F8 EB 55 56 8D 45 F4 50 53 51 E8 ?? ?? ?? ?? 8B F0 8D 45 F4 50 53 FF 75 0C E8 ?? ?? ?? ?? 8B 4D F8 FF 71 04 50 FF 75 0C 8D 45 F4 56 FF 75 08 68 00 10 00 00 FF B1 1C 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 38 5E 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 78 FE 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C7 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHQBDQAU_finddata32_t@@@Z"
		size = 159
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 0046 ___acrt_copy_path_to_wide_string 005e ??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z 0074 ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 0088 __free_base 0097 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 24 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 57 8B 7D 0C 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5B 83 A5 DC FD FF FF 00 8D 8D DC FD FF FF 56 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 2E 8D 85 E0 FD FF FF 50 FF B5 DC FD FF FF E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 74 13 8D 85 E0 FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 75 03 83 CE FF FF B5 DC FD FF FF E8 ?? ?? ?? ?? 59 8B C6 5E 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_2_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHQBDQAU_finddata32i64_t@@@Z"
		size = 159
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 0046 ___acrt_copy_path_to_wide_string 005e ??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z 0074 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0088 __free_base 0097 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 28 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 57 8B 7D 0C 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5B 83 A5 D8 FD FF FF 00 8D 8D D8 FD FF FF 56 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 2E 8D 85 DC FD FF FF 50 FF B5 D8 FD FF FF E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 74 13 8D 85 DC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 75 03 83 CE FF FF B5 D8 FD FF FF E8 ?? ?? ?? ?? 59 8B C6 5E 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_3_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHQBDQAU__finddata64_t@@@Z"
		size = 159
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 0046 ___acrt_copy_path_to_wide_string 005e ??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z 0074 ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 0088 __free_base 0097 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 38 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 57 8B 7D 0C 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5B 83 A5 C8 FD FF FF 00 8D 8D C8 FD FF FF 56 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 2E 8D 85 CC FD FF FF 50 FF B5 C8 FD FF FF E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 74 13 8D 85 CC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 75 03 83 CE FF FF B5 C8 FD FF FF E8 ?? ?? ?? ?? 59 8B C6 5E 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_4_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHQBDQAU_finddata64i32_t@@@Z"
		size = 159
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 0046 ___acrt_copy_path_to_wide_string 005e ??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z 0074 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0088 __free_base 0097 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 38 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 57 8B 7D 0C 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5B 83 A5 C8 FD FF FF 00 8D 8D C8 FD FF FF 56 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 2E 8D 85 CC FD FF FF 50 FF B5 C8 FD FF FF E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 74 13 8D 85 CC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 75 03 83 CE FF FF B5 C8 FD FF FF E8 ?? ?? ?? ?? 59 8B C6 5E 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_5_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z"
		size = 288
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 004b __imp__FindFirstFileExW@24 0058 __imp__GetLastError@0 0089 @__security_check_cookie@4 00c4 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 0103 _wcscpy_s 011b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 8D 8D AC FD FF FF 53 53 53 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 51 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 36 83 F8 08 74 24 83 F8 12 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DF E8 ?? ?? ?? ?? 89 30 EB D6 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 8D 46 14 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 6B FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_6_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z"
		size = 301
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 004b __imp__FindFirstFileExW@24 0058 __imp__GetLastError@0 0089 @__security_check_cookie@4 00c4 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 0110 _wcscpy_s 0128 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 8D 8D AC FD FF FF 53 53 53 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 51 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 36 83 F8 08 74 24 83 F8 12 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DF E8 ?? ?? ?? ?? 89 30 EB D6 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 03 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 8D 46 18 13 CB 68 04 01 00 00 50 89 4E 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 5E FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_7_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z"
		size = 310
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 004b __imp__FindFirstFileExW@24 0058 __imp__GetLastError@0 0089 @__security_check_cookie@4 00c4 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 0119 _wcscpy_s 0131 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 8D 8D AC FD FF FF 53 53 53 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 51 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 36 83 F8 08 74 24 83 F8 12 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DF E8 ?? ?? ?? ?? 89 30 EB D6 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 18 33 C0 03 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 8D 46 28 89 56 1C 13 CB 68 04 01 00 00 50 89 4E 24 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 55 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_8_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z"
		size = 297
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 004b __imp__FindFirstFileExW@24 0058 __imp__GetLastError@0 0089 @__security_check_cookie@4 00c4 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 010c _wcscpy_s 0124 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 8D 8D AC FD FF FF 53 53 53 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 51 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 36 83 F8 08 74 24 83 F8 12 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DF E8 ?? ?? ?? ?? 89 30 EB D6 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 8D 46 24 89 56 1C 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 62 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_9_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHHQAU_finddata32_t@@@Z"
		size = 92
		refs = "000c ___security_cookie 0025 ??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z 0040 ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 0054 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 0C 8D 85 E0 FD FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 05 83 C8 FF EB 15 8D 85 E0 FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 E8 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_10_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHHQAU_finddata32i64_t@@@Z"
		size = 92
		refs = "000c ___security_cookie 0025 ??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z 0040 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0054 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 24 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 0C 8D 85 DC FD FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 05 83 C8 FF EB 15 8D 85 DC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 E8 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_11_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHHQAU__finddata64_t@@@Z"
		size = 92
		refs = "000c ___security_cookie 0025 ??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z 0040 ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 0054 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 0C 8D 85 CC FD FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 05 83 C8 FF EB 15 8D 85 CC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 E8 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_12_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHHQAU_finddata64i32_t@@@Z"
		size = 92
		refs = "000c ___security_cookie 0025 ??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z 0040 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0054 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 0C 8D 85 CC FD FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 05 83 C8 FF EB 15 8D 85 CC FD FF FF 57 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 E8 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_13_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z"
		size = 276
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 003a @__security_check_cookie@4 0055 __imp__FindNextFileW@8 005f __imp__GetLastError@0 00b9 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 00f8 _wcscpy_s 010f __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 C0 75 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 83 F8 FF 74 D9 85 F6 74 D5 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB AA E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 9D E8 ?? ?? ?? ?? 89 30 EB 94 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 8D 46 14 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 2C FF FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_14_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z"
		size = 314
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 005d __imp__FindNextFileW@8 0067 __imp__GetLastError@0 0096 @__security_check_cookie@4 00d1 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 0120 _wcscpy_s 0135 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5A 57 83 CF FF 3B C7 74 04 85 F6 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 39 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 8B C7 5F 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 03 85 CC FD FF FF 6A 00 5F 89 46 10 13 CF 8D 85 D8 FD FF FF 89 4E 14 50 8D 46 18 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 5F FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_15_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z"
		size = 323
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 005d __imp__FindNextFileW@8 0067 __imp__GetLastError@0 0096 @__security_check_cookie@4 00d1 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 0129 _wcscpy_s 013e __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5A 57 83 CF FF 3B C7 74 04 85 F6 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 39 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 8B C7 5F 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 18 33 C0 03 85 CC FD FF FF 6A 00 5F 89 46 20 13 CF 8D 85 D8 FD FF FF 89 56 1C 50 8D 46 28 89 4E 24 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 56 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_16_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z"
		size = 285
		refs = "000c ___security_cookie 0021 __errno 002c __invalid_parameter_noinfo 003a @__security_check_cookie@4 0055 __imp__FindNextFileW@8 005f __imp__GetLastError@0 00b9 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 0101 _wcscpy_s 0118 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 C0 75 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 83 F8 FF 74 D9 85 F6 74 D5 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB AA E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 9D E8 ?? ?? ?? ?? 89 30 EB 94 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 8D 46 24 89 56 1C 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 23 FF FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_18_0 {
	meta:
		name = "??$convert_file_size_to_integer@_J@@YA_JKK@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 33 C0 03 45 0C 83 D2 00 5D C3 }
	condition:
		$1
}

rule file_137_19_0 {
	meta:
		name = "??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z"
		size = 126
		refs = "0009 ___security_cookie 002c __imp__FileTimeToSystemTime@8 0040 __imp__SystemTimeToTzSpecificLocalTime@12 0069 ___loctotime32_t 0076 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 38 00 75 0B 83 78 04 00 75 05 83 C8 FF EB 4B 8D 4D DC 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 EC 8D 45 EC 50 8D 45 DC 50 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 D8 0F B7 45 F8 6A FF 50 0F B7 45 F6 50 0F B7 45 F4 50 0F B7 45 F2 50 0F B7 45 EE 50 0F B7 45 EC 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_20_0 {
	meta:
		name = "??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z"
		size = 128
		refs = "0009 ___security_cookie 002e __imp__FileTimeToSystemTime@8 0042 __imp__SystemTimeToTzSpecificLocalTime@12 006b ___loctotime64_t 0078 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 38 00 75 0D 83 78 04 00 75 07 83 C8 FF 0B D0 EB 4B 8D 4D DC 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 EA 8D 45 EC 50 8D 45 DC 50 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 D6 0F B7 45 F8 6A FF 50 0F B7 45 F6 50 0F B7 45 F4 50 0F B7 45 F2 50 0F B7 45 EE 50 0F B7 45 EC 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_21_0 {
	meta:
		name = "??$convert_system_time_to_time_t@J@@YAJABU_SYSTEMTIME@@@Z"
		size = 49
		refs = "0028 ___loctotime32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A FF 0F B7 41 0C 50 0F B7 41 0A 50 0F B7 41 08 50 0F B7 41 06 50 0F B7 41 02 50 0F B7 01 50 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_137_22_0 {
	meta:
		name = "??$convert_system_time_to_time_t@_J@@YA_JABU_SYSTEMTIME@@@Z"
		size = 49
		refs = "0028 ___loctotime64_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A FF 0F B7 41 0C 50 0F B7 41 0A 50 0F B7 41 08 50 0F B7 41 06 50 0F B7 41 02 50 0F B7 01 50 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_137_23_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z"
		size = 124
		refs = "0019 ___acrt_copy_to_char 003c _strcpy_s 004b __free_base 0077 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 08 8D 45 FC 50 33 DB 89 5D FC 8D 47 14 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 08 32 C0 5F 5B 8B E5 5D C3 56 FF 75 FC 8B 75 0C 68 04 01 00 00 8D 46 14 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2A FF 75 FC E8 ?? ?? ?? ?? 8B 07 89 06 8B 47 04 89 46 04 8B 47 08 89 46 08 8B 47 0C 89 46 0C 8B 47 10 59 89 46 10 B0 01 5E EB B4 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_24_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z"
		size = 130
		refs = "0019 ___acrt_copy_to_char 003c _strcpy_s 004b __free_base 007d __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 08 8D 45 FC 50 33 DB 89 5D FC 8D 47 18 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 08 32 C0 5F 5B 8B E5 5D C3 56 FF 75 FC 8B 75 0C 68 04 01 00 00 8D 46 18 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 30 FF 75 FC E8 ?? ?? ?? ?? 8B 07 89 06 8B 47 04 89 46 04 8B 47 08 89 46 08 8B 47 0C 89 46 0C 8B 47 10 89 46 10 8B 47 14 59 89 46 14 B0 01 5E EB AE 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_25_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z"
		size = 148
		refs = "0019 ___acrt_copy_to_char 003c _strcpy_s 004b __free_base 008f __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 08 8D 45 FC 50 33 DB 89 5D FC 8D 47 28 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 08 32 C0 5F 5B 8B E5 5D C3 56 FF 75 FC 8B 75 0C 68 04 01 00 00 8D 46 28 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 42 FF 75 FC E8 ?? ?? ?? ?? 8B 07 89 06 8B 47 08 89 46 08 8B 47 0C 89 46 0C 8B 47 10 89 46 10 8B 47 14 89 46 14 8B 47 18 89 46 18 8B 47 1C 89 46 1C 8B 47 20 89 46 20 8B 47 24 59 89 46 24 B0 01 5E EB 9C 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_26_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z"
		size = 142
		refs = "0019 ___acrt_copy_to_char 003c _strcpy_s 004b __free_base 0089 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 08 8D 45 FC 50 33 DB 89 5D FC 8D 47 24 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 08 32 C0 5F 5B 8B E5 5D C3 56 FF 75 FC 8B 75 0C 68 04 01 00 00 8D 46 24 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 3C FF 75 FC E8 ?? ?? ?? ?? 8B 07 89 06 8B 47 08 89 46 08 8B 47 0C 89 46 0C 8B 47 10 89 46 10 8B 47 14 89 46 14 8B 47 18 89 46 18 8B 47 1C 89 46 1C 8B 47 20 59 89 46 20 B0 01 5E EB A2 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_137_32_0 {
	meta:
		name = "__findclose"
		size = 38
		refs = "000a __imp__FindClose@4 0013 __errno"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_137_37_0 {
	meta:
		name = "__findnext32"
		size = 93
		refs = "000c ___security_cookie 0026 ??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z 003e ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 8D 85 E0 FD FF FF 56 57 50 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 CE FF 59 59 3B FE 74 15 8D 85 E0 FD FF FF 53 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 02 8B F7 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_38_0 {
	meta:
		name = "__findnext32i64"
		size = 93
		refs = "000c ___security_cookie 0026 ??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z 003e ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 24 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 8D 85 DC FD FF FF 56 57 50 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 CE FF 59 59 3B FE 74 15 8D 85 DC FD FF FF 53 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 02 8B F7 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_39_0 {
	meta:
		name = "__findnext64"
		size = 93
		refs = "000c ___security_cookie 0026 ??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z 003e ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 8D 85 CC FD FF FF 56 57 50 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 CE FF 59 59 3B FE 74 15 8D 85 CC FD FF FF 53 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 02 8B F7 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_40_0 {
	meta:
		name = "__findnext64i32"
		size = 93
		refs = "000c ___security_cookie 0026 ??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z 003e ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 8D 85 CC FD FF FF 56 57 50 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 CE FF 59 59 3B FE 74 15 8D 85 CC FD FF FF 53 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 02 8B F7 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "??$common_tcscpy_s@D@@YAHQADIQBD@Z"
		size = 90
		refs = "001f __errno 0029 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 85 D2 74 11 8B 4D 0C 85 C9 74 0A 8B 75 10 85 F6 75 17 C6 02 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 57 8B FA 2B F2 8A 04 3E 88 07 47 84 C0 74 05 83 E9 01 75 F1 5F 85 C9 75 0B 88 0A E8 ?? ?? ?? ?? 6A 22 EB CF 33 C0 EB D5 }
	condition:
		$1
}

rule file_138_1_0 {
	meta:
		name = "_strcpy_s"
		size = 90
		refs = "001f __errno 0029 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 85 D2 74 11 8B 4D 0C 85 C9 74 0A 8B 75 10 85 F6 75 17 C6 02 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 57 8B FA 2B F2 8A 04 3E 88 07 47 84 C0 74 05 83 E9 01 75 F1 5F 85 C9 75 0B 88 0A E8 ?? ?? ?? ?? 6A 22 EB CF 33 F6 EB D3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "___libm_sse2_tanf"
		size = 406
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER_16 0047 _SHIFTER 007a _PP_1 0086 _P_1 0092 _PP_2 009e _P_2 00a8 _Ctable 00e4 _ONE 015b _ONE_P230 0181 _tan"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D FF 46 0F 87 3A 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 3D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 F8 F3 0F 5A C0 F2 0F 10 25 ?? ?? ?? ?? F3 0F 58 E1 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 0F 10 2D ?? ?? ?? ?? 66 0F 57 EF F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D7 F2 0F 10 35 ?? ?? ?? ?? 66 0F 57 F7 F2 0F 10 1D ?? ?? ?? ?? 66 0F 57 DF 8D 05 ?? ?? ?? ?? C1 E2 03 03 C2 C1 E2 03 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 1D 83 EC 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 83 C4 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "??0__acrt_stdio_temporary_buffering_guard@@QAE@QAU_iobuf@@@Z"
		size = 30
		refs = "000f ___acrt_stdio_begin_temporary_buffering_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 50 89 06 E8 ?? ?? ?? ?? 88 46 04 8B C6 59 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_140_16_0 {
	meta:
		name = "_puts"
		size = 223
		refs = "000f __errno 001a __invalid_parameter_noinfo 002a ___acrt_iob_func 003f __fileno 0046 ___badioinfo 0063 ___pioinfo 00d4 ??$__acrt_lock_stream_and_call@V<lambda_3126a0d026c48c72336a1719c85146ae>@@@@YAHQAU_iobuf@@$$QAV<lambda_3126a0d026c48c72336a1719c85146ae>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 08 00 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B5 00 00 00 56 6A 01 E8 ?? ?? ?? ?? 59 89 45 FC 8B 48 0C C1 E9 0C F6 C1 01 75 6B 50 E8 ?? ?? ?? ?? 8B D0 BE ?? ?? ?? ?? 59 83 FA FF 74 19 83 FA FE 74 14 83 E0 3F 8B CA 6B C0 30 C1 F9 06 03 04 8D ?? ?? ?? ?? EB 02 8B C6 80 78 29 00 75 22 83 FA FF 74 17 83 FA FE 74 12 8B C2 83 E2 3F 6B F2 30 C1 F8 06 03 34 85 ?? ?? ?? ?? F6 46 2D 01 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 32 8B 4D 08 8D 51 01 8A 01 41 84 C0 75 F9 8D 45 FC 2B CA 89 45 EC 8D 45 08 89 45 F0 8D 45 F8 89 45 F4 8D 45 EC 50 FF 75 FC 89 4D F8 E8 ?? ?? ?? ?? 59 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_1_0 {
	meta:
		name = "__floor_pentium4"
		size = 189
		refs = "000a _Bns 0023 _S 0083 _One 009d _NegZero 00ae _NegOne"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 75 22 3D FF 03 00 00 7C 59 66 0F F3 CA 3D 32 04 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F 2E C0 7A E7 66 0F C2 C1 01 3D FF 0B 00 00 7C 21 3D 32 0C 00 00 7F D4 66 0F 54 05 ?? ?? ?? ?? F2 0F 5C C8 66 0F D6 4C 24 04 DD 44 24 04 C3 D9 EE C3 66 0F C2 1D ?? ?? ?? ?? 01 66 0F 56 1D ?? ?? ?? ?? 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_142_5_0 {
	meta:
		name = "__mbsnlen_l"
		size = 126
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D F8 33 C9 39 4B 08 75 11 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B C8 EB 38 56 57 8B 7D 0C 8B D1 85 FF 74 29 8B 75 08 8A 06 84 C0 74 1C 0F B6 C0 F6 44 18 19 04 74 0B 42 3B D7 73 11 46 80 3E 00 74 07 41 46 42 3B D7 72 DE 3B D7 72 02 8B CF 5F 5E 80 7D FC 00 5B 74 0A 8B 45 F0 83 A0 50 03 00 00 FD 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__resetstkoflw"
		size = 209
		refs = "0009 ___security_cookie 0019 __alloca_probe 002b __imp__VirtualQuery@12 0043 __imp__GetSystemInfo@4 0054 ___acrt_SetThreadStackGuarantee@4 0099 __imp__VirtualAlloc@16 00ae __imp__VirtualProtect@16 00c9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 6A 04 58 E8 ?? ?? ?? ?? 8B C4 8D 4D D0 6A 1C 51 50 89 45 F4 FF 15 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 8B 45 D4 89 45 F0 8D 45 AC 50 FF 15 ?? ?? ?? ?? 8B 5D B0 8D 45 F8 33 F6 50 89 75 F8 E8 ?? ?? ?? ?? 85 C0 74 08 39 75 F8 76 03 8B 75 F8 4E 8D 43 FF 03 F3 F7 D0 23 F0 74 02 03 F3 8D 04 1B 3B F0 73 02 8B F0 8B 45 F0 8D 7B FF F7 D7 03 C3 23 7D F4 2B FE 3B F8 72 2D 6A 04 68 00 10 00 00 56 57 FF 15 ?? ?? ?? ?? 85 C0 74 1A 8D 45 EC 50 68 04 01 00 00 56 57 FF 15 ?? ?? ?? ?? 85 C0 74 05 33 C0 40 EB 02 33 C0 8D 65 A0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "__towlower_l"
		size = 201
		refs = "001e ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0061 _iswctype 009a ___acrt_LCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 83 EC 18 66 39 45 08 0F 84 AE 00 00 00 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 8B 80 A8 00 00 00 85 C0 75 21 8B 4D 08 8D 41 BF 66 83 F8 19 77 0D 66 83 C1 20 0F B7 C1 89 45 F8 66 8B C8 0F B7 C1 89 45 F8 EB 1F BA 00 01 00 00 6A 01 66 39 55 08 73 30 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 8B 45 08 0F B7 C0 EB 11 8B 45 EC 0F B7 4D 08 8B 80 94 00 00 00 0F B6 04 08 0F B7 C0 89 45 F8 EB 1C 8D 4D FC 51 6A 01 8D 4D 08 51 52 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 0C 66 8B 45 08 0F B7 C0 89 45 F8 EB 04 66 8B 45 FC 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_10_0 {
	meta:
		name = "__ungetc_nolock"
		size = 239
		refs = "0018 __fileno 001f ___badioinfo 003c ___pioinfo 006d __errno 0078 __invalid_parameter_noinfo 00a5 ___acrt_stdio_allocate_buffer_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 0C 57 8D 56 0C 8B 02 C1 E8 0C A8 01 75 6E 56 E8 ?? ?? ?? ?? 8B D0 BF ?? ?? ?? ?? 59 83 FA FF 74 19 83 FA FE 74 14 83 E0 3F 8B CA 6B C0 30 C1 F9 06 03 04 8D ?? ?? ?? ?? EB 02 8B C7 80 78 29 00 75 22 83 FA FF 74 17 83 FA FE 74 12 8B C2 83 E2 3F 6B FA 30 C1 F8 06 03 3C 85 ?? ?? ?? ?? F6 47 2D 01 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6A 8D 56 0C 53 8B 5D 08 83 FB FF 74 44 8B 02 8B 0A A8 01 75 08 83 E1 06 80 F9 06 75 34 83 7E 04 00 75 0A 56 E8 ?? ?? ?? ?? 59 8D 56 0C 8B 06 3B 46 04 75 09 83 7E 08 00 75 17 40 89 06 8B 02 C1 E8 0C FF 0E A8 01 8B 06 74 0C 38 18 74 0A 40 89 06 83 C8 FF EB 14 88 18 FF 46 08 6A F7 58 F0 21 02 33 C0 40 F0 09 02 0F B6 C3 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_146_11_0 {
	meta:
		name = "_ungetc"
		size = 112
		refs = "0003 __sehtable$_ungetc 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0035 __lock_file 0043 __ungetc_nolock 005d __SEH_epilog4 006a __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 0C 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 2D 83 4D E4 FF 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 75 0C 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "_cabsf"
		size = 44
		refs = "000c _cimagf 001b _crealf 0024 _hypotf"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "_hypotf"
		size = 29
		refs = "0015 __hypotf"
	strings:
		$1 = { 8B FF 55 8B EC D9 45 0C 51 51 D9 5C 24 04 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_148_7_0 {
	meta:
		name = "__getch"
		size = 70
		refs = "0003 __sehtable$__getch 0008 __SEH_prolog4 000f ___acrt_lock 001d __getch_nolock 0035 __SEH_epilog4 0040 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 83 65 E4 00 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_148_9_0 {
	meta:
		name = "__getche"
		size = 70
		refs = "0003 __sehtable$__getche 0008 __SEH_prolog4 000f ___acrt_lock 001d __getche_nolock 0035 __SEH_epilog4 0040 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 83 65 E4 00 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_148_12_0 {
	meta:
		name = "__kbhit"
		size = 70
		refs = "0003 __sehtable$__kbhit 0008 __SEH_prolog4 000f ___acrt_lock 001d __kbhit_nolock 0035 __SEH_epilog4 0040 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 83 65 E4 00 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_148_8_0 {
	meta:
		name = "__getch_nolock"
		size = 212
		refs = "0003 __sehtable$__getch_nolock 0008 __SEH_prolog4_GS 000d ?chbuf@@3HA 0028 ___dcrt_lowio_console_input_handle 0032 ___dcrt_lowio_initialize_console_input 004a __imp__GetConsoleMode@8 0054 __imp__SetConsoleMode@8 006b __imp__ReadConsoleInputA@16 0096 __getextendedkeycode 00be __SEH_epilog4_GS"
	strings:
		$1 = { 6A 30 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 CE FF 3B C6 74 0E 0F B6 C0 89 35 ?? ?? ?? ?? E9 97 00 00 00 8B 3D ?? ?? ?? ?? 83 FF FE 75 0B E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 3B FE 74 7B 89 7D C4 8D 45 C0 50 57 FF 15 ?? ?? ?? ?? 33 DB 53 57 FF 15 ?? ?? ?? ?? 89 5D CC 89 5D FC 43 8D 45 C8 50 53 8D 45 D0 50 57 FF 15 ?? ?? ?? ?? 85 C0 74 39 83 7D C8 00 74 33 66 39 5D D0 75 E0 83 7D D4 00 74 DA 8A 45 DE 84 C0 74 05 0F B6 F0 EB 1B 8D 45 D4 50 E8 ?? ?? ?? ?? 59 85 C0 74 C0 0F B6 48 01 89 0D ?? ?? ?? ?? 0F B6 30 89 75 CC C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 7D C4 8B 75 CC FF 75 C0 57 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_148_10_0 {
	meta:
		name = "__getche_nolock"
		size = 58
		refs = "0001 ?chbuf@@3HA 001a __getch_nolock 002a __putch_nolock"
	strings:
		$1 = { A1 ?? ?? ?? ?? 57 83 CF FF 3B C7 74 0B 89 3D ?? ?? ?? ?? 0F B6 C0 5F C3 56 E8 ?? ?? ?? ?? 8B F0 3B F7 75 04 8B C7 EB 0F 56 E8 ?? ?? ?? ?? 3B C7 8B C7 59 74 02 8B C6 5E 5F C3 }
	condition:
		$1
}

rule file_148_11_0 {
	meta:
		name = "__getextendedkeycode"
		size = 179
		refs = "001e ?EnhancedKeys@@3QBUEnhKeyVals@?A0x85a4bdeb@@B 006e ?NormalKeys@@3QBUNormKeyVals@?A0x85a4bdeb@@B"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 8B 42 0C A9 00 01 00 00 74 50 0F B7 72 08 33 C9 8B D1 66 39 B2 ?? ?? ?? ?? 74 0B 83 C2 0A 41 83 FA 78 72 EE EB 7F A8 03 74 0A 6B C1 0A 05 ?? ?? ?? ?? EB 73 A8 0C 74 0A 6B C1 0A 05 ?? ?? ?? ?? EB 65 A8 10 74 0A 6B C1 0A 05 ?? ?? ?? ?? EB 57 6B C1 0A 05 ?? ?? ?? ?? EB 4D A8 03 74 0D 0F B7 42 08 8D 04 C5 ?? ?? ?? ?? EB 29 A8 0C 74 0D 0F B7 42 08 8D 04 C5 ?? ?? ?? ?? EB 18 A8 10 0F B7 42 08 74 09 8D 04 C5 ?? ?? ?? ?? EB 07 8D 04 C5 ?? ?? ?? ?? 8A 08 84 C9 74 05 80 F9 E0 75 06 80 78 01 00 75 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_148_13_0 {
	meta:
		name = "__kbhit_nolock"
		size = 317
		refs = "0009 ___security_cookie 0014 ?chbuf@@3HA 0028 ___dcrt_lowio_console_input_handle 0032 ___dcrt_lowio_initialize_console_input 004f __imp__GetNumberOfConsoleInputEvents@8 008b __alloca_probe_16 00a9 __malloc_base 00cd __imp__PeekConsoleInputA@16 00fe __getextendedkeycode 0121 __freea_crt 0135 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 53 56 57 74 08 33 C0 40 E9 03 01 00 00 8B 3D ?? ?? ?? ?? 83 FF FE 75 0B E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 FF FF 75 07 33 C0 E9 E1 00 00 00 8D 45 F8 50 57 FF 15 ?? ?? ?? ?? 85 C0 74 EA 8B 5D F8 85 DB 74 E3 6B D3 14 8D 4A 08 3B D1 1B C0 33 F6 89 75 F0 85 C1 74 4F 8D 4A 08 3B D1 1B C0 23 C1 8D 4A 08 3D 00 04 00 00 77 1D 3B D1 1B C0 23 C1 E8 ?? ?? ?? ?? 8B F4 85 F6 0F 84 81 00 00 00 C7 06 CC CC 00 00 EB 19 3B D1 1B C0 23 C1 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 09 C7 06 DD DD 00 00 83 C6 08 8B 5D F8 85 F6 74 56 8D 45 F4 50 53 56 57 FF 15 ?? ?? ?? ?? 85 C0 74 45 8B 7D F4 85 FF 74 3E 3B 7D F8 77 39 85 FF 74 3A 33 C0 8D 5E 04 40 66 39 43 FC 75 17 83 3B 00 74 12 80 7B 0A 00 75 20 53 E8 ?? ?? ?? ?? 59 85 C0 75 0E 40 4F 83 C3 14 89 7D F4 85 FF 75 D8 EB 0A 33 C0 40 EB 02 33 C0 89 45 F0 56 E8 ?? ?? ?? ?? 8B 45 F0 59 8D 65 E4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_14_0 {
	meta:
		name = "__ungetch"
		size = 74
		refs = "0003 __sehtable$__ungetch 0008 __SEH_prolog4 000f ___acrt_lock 0020 __ungetch_nolock 0039 __SEH_epilog4 0044 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 83 65 E4 00 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_148_15_0 {
	meta:
		name = "__ungetch_nolock"
		size = 37
		refs = "000f ?chbuf@@3HA"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 FF 74 13 83 3D ?? ?? ?? ?? FF 75 0A 0F B6 C0 A3 ?? ?? ?? ?? 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_strncmp"
		size = 120
	strings:
		$1 = { 53 56 8B 4C 24 0C 8B 54 24 10 8B 5C 24 14 F7 C3 FF FF FF FF 74 50 2B CA F7 C2 03 00 00 00 74 17 0F B6 04 0A 3A 02 75 48 85 C0 74 3A 42 83 EB 01 76 34 F6 C2 03 75 E9 8D 04 0A 25 FF 0F 00 00 3D FC 0F 00 00 77 DA 8B 04 0A 3B 02 75 D3 83 EB 04 76 14 8D B0 FF FE FE FE 83 C2 04 F7 D0 23 C6 A9 80 80 80 80 74 D1 33 C0 5E 5B C3 EB 03 CC CC CC 1B C0 83 C8 01 5E 5B C3 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "??$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z"
		size = 53
		refs = "0007 ?state_cache@?1???$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z@4JA 001a ___acrt_AppPolicyGetThreadInitializationTypeInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 85 C0 75 22 8B 45 08 89 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 BA ?? ?? ?? ?? 83 7D FC 01 0F 94 C0 40 8B C8 87 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "??$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z"
		size = 53
		refs = "0007 ?state_cache@?1???$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z@4JA 001a ___acrt_AppPolicyGetShowDeveloperDiagnosticInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 85 C0 75 22 8B 45 08 89 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 BA ?? ?? ?? ?? 83 7D FC 01 0F 94 C0 40 8B C8 87 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "??$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z"
		size = 77
		refs = "0007 ?state_cache@?1???$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z@4JA 001a ___acrt_AppPolicyGetWindowingModelInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 85 C0 75 3A 8B 45 08 89 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 E8 01 74 17 83 E8 01 74 0D 83 E8 01 74 04 6A 04 EB 0B 6A 03 EB 07 33 C0 40 EB 03 6A 02 58 8B C8 BA ?? ?? ?? ?? 87 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "??$get_win_policy@Uprocess_end_policy_properties@?1??__acrt_get_process_end_policy@@YA?AW4process_end_policy@@XZ@@@YA?AW4process_end_policy@@W4AppPolicyProcessTerminationMethod@@@Z"
		size = 34
		refs = "0011 ___acrt_AppPolicyGetProcessTerminationMethodInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 83 7D FC 01 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_10_0 {
	meta:
		name = "?appmodel_policy_to_policy_type@begin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@SA?AW43@J@Z"
		size = 17
		altNames = "?appmodel_policy_to_policy_type@developer_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@SA?AW43@J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 08 01 0F 94 C0 40 5D C3 }
	condition:
		$1
}

rule file_150_12_0 {
	meta:
		name = "?appmodel_policy_to_policy_type@process_end_policy_properties@?1??__acrt_get_process_end_policy@@YA?AW4process_end_policy@@XZ@SA?AW43@W4AppPolicyProcessTerminationMethod@@@Z"
		size = 16
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 08 01 0F 95 C0 5D C3 }
	condition:
		$1
}

rule file_150_13_0 {
	meta:
		name = "?appmodel_policy_to_policy_type@windowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@SA?AW43@J@Z"
		size = 41
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 E8 01 74 17 83 E8 01 74 0D 83 E8 01 74 04 6A 04 EB 0B 6A 03 EB 07 33 C0 40 5D C3 6A 02 58 5D C3 }
	condition:
		$1
}

rule file_150_14_0 {
	meta:
		name = "___acrt_get_begin_thread_init_policy"
		size = 50
		refs = "0007 ?state_cache@?1???$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z@4JA 0017 ___acrt_AppPolicyGetThreadInitializationTypeInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 85 C0 75 1F 21 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 BA ?? ?? ?? ?? 83 7D FC 01 0F 94 C0 40 8B C8 87 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_15_0 {
	meta:
		name = "___acrt_get_developer_information_policy"
		size = 50
		refs = "0007 ?state_cache@?1???$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z@4JA 0017 ___acrt_AppPolicyGetShowDeveloperDiagnosticInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 85 C0 75 1F 21 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 BA ?? ?? ?? ?? 83 7D FC 01 0F 94 C0 40 8B C8 87 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_16_0 {
	meta:
		name = "___acrt_get_process_end_policy"
		size = 32
		refs = "000f ___acrt_AppPolicyGetProcessTerminationMethodInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 50 E8 ?? ?? ?? ?? 33 C0 83 7D FC 01 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_17_0 {
	meta:
		name = "___acrt_get_windowing_model_policy"
		size = 78
		refs = "0009 ?state_cache@?1???$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z@4JA 001c ___acrt_AppPolicyGetWindowingModelInternal@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 35 ?? ?? ?? ?? 85 F6 75 36 6A 02 5E 8D 45 FC 89 75 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 E8 01 74 16 83 E8 01 74 0E 83 E8 01 74 04 6A 04 EB 02 6A 03 5E EB 03 33 F6 46 8B CE B8 ?? ?? ?? ?? 87 08 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_7_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
		size = 380
		refs = "0007 ___security_cookie 001b __errno 0025 __invalid_parameter_noinfo 0033 _strnlen 0066 ___acrt_LCMapStringA 00d7 __alloca_probe_16 00f1 __malloc_base 014a _strcpy_s 0161 __freea_crt 0174 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 57 85 F6 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 38 01 00 00 FF 75 0C 56 E8 ?? ?? ?? ?? 59 59 3B 45 0C 72 05 C6 06 00 EB D7 8B 45 10 8B 08 8B 91 A8 00 00 00 85 D2 74 47 6A 01 FF 71 08 33 DB 53 53 6A FF 56 68 00 01 00 00 52 50 E8 ?? ?? ?? ?? 8B F8 83 C4 24 85 FF 75 32 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 DE 00 00 00 8A 06 3C 41 7C 08 3C 5A 7F 04 04 20 88 06 46 80 3E 00 75 EC 33 C0 E9 C3 00 00 00 39 7D 0C 73 0E 88 1E E8 ?? ?? ?? ?? 6A 22 E9 69 FF FF FF 8D 4F 08 3B F9 1B C0 85 C1 74 42 3B F9 1B C0 23 C1 3D 00 04 00 00 77 19 3B F9 1B C0 23 C1 E8 ?? ?? ?? ?? 8B DC 85 DB 74 28 C7 03 CC CC 00 00 EB 19 3B F9 1B C0 23 C1 50 E8 ?? ?? ?? ?? 8B D8 59 85 DB 74 0D C7 03 DD DD 00 00 83 C3 08 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 30 EB 42 8B 4D 10 6A 01 8B 01 FF 70 08 57 53 6A FF 56 68 00 01 00 00 FF B0 A8 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 11 53 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0A E8 ?? ?? ?? ?? 6A 2A 5E 89 30 53 E8 ?? ?? ?? ?? 59 8B C6 8D 65 F0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_13_0 {
	meta:
		name = "__strlwr"
		size = 93
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 0051 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 3B 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 80 38 00 8B C8 74 2B 8A 11 80 FA 41 7C 0A 80 FA 5A 7F 05 80 C2 20 88 11 41 80 39 00 75 E9 5D C3 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_151_14_0 {
	meta:
		name = "__strlwr_l"
		size = 26
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_503_14_0 {
	meta:
		name = "__strupr_l"
		size = 26
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_215_14_0 {
	meta:
		name = "__wcslwr_l"
		size = 26
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_669_13_0 {
	meta:
		name = "__wcsupr_l"
		size = 26
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_151_16_0 {
	meta:
		name = "__strlwr_s_l"
		size = 57
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 001e ?_strlwr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F4 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_503_16_0 {
	meta:
		name = "__strupr_s_l"
		size = 57
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 001e ?_strupr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F4 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_16_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 57
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 001e ?_wcslwr_s_l_stat@@YAHPA_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F4 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_669_15_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 57
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 001e ?_wcsupr_s_l_stat@@YAHQA_WIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F4 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__telli64"
		size = 24
		refs = "000f __lseeki64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_conjf"
		size = 50
		refs = "000e _crealf 001c _cimagf"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C D9 5D F8 FF 75 08 E8 ?? ?? ?? ?? 8B 45 F8 D9 E0 D9 5D FC 8B 55 FC 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_fgetpos"
		size = 91
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0041 __ftelli64"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 1B FF 75 08 E8 ?? ?? ?? ?? 59 8B C8 89 06 23 CA 89 56 04 83 C8 FF 3B C8 74 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__FCosh"
		size = 227
		refs = "000c __fdtest 0047 __FXbig_C 0061 __fdexp 006f __real@3fd0000000000000 00b9 __FInf_C 00ce __fperrraise 00d4 __FNan_C"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 56 50 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 0C 50 E8 ?? ?? ?? ?? 59 59 33 C9 0F B7 C0 66 3B CE 7E 69 66 3B C8 7E 64 D9 EE D9 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 08 D9 E0 D9 5D 08 D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 6A FF 51 F6 C4 41 8D 45 08 75 26 D9 E8 D9 1C 24 50 E8 ?? ?? ?? ?? D9 45 08 83 C4 0C D9 C0 DC 3D ?? ?? ?? ?? DE C1 D8 4D 0C D9 5D FC D9 45 FC EB 5E D9 45 0C D9 1C 24 50 E8 ?? ?? ?? ?? 83 C4 0C EB 08 6A 02 59 66 3B F1 75 05 D9 45 08 EB 40 66 3B C1 74 38 33 C9 41 66 3B F1 75 30 66 85 C0 74 1C D9 EE D8 5D 0C DF E0 D9 05 ?? ?? ?? ?? F6 C4 41 75 02 D9 E0 D9 5D FC D9 45 FC EB 12 51 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 59 EB 03 D9 45 0C 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_156_1_0 {
	meta:
		name = "_ccoshf"
		size = 413
		refs = "0010 _crealf 001e _cimagf 002a __fdtest 0058 __FNan_C 0060 __FCbuild 0082 __fperrraise 009c __FZero_C 00cc __FInf_C 0118 __CIsin 0123 __CIcos 0172 __FSinh 0188 __FCosh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C D9 5D F8 FF 75 08 E8 ?? ?? ?? ?? 8D 45 F8 50 D9 5D FC E8 ?? ?? ?? ?? 0F B7 F0 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 6A 02 59 66 3B F1 75 2F 51 51 66 85 C0 75 1C D9 45 FC D9 5C 24 04 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 59 59 E9 2D 01 00 00 D9 05 ?? ?? ?? ?? D9 54 24 04 EB E5 57 33 FF 47 66 3B C7 75 5E 57 E8 ?? ?? ?? ?? 59 66 85 F6 75 2D D9 EE D8 55 FC DF E0 F6 C4 41 75 0A DD D8 D9 05 ?? ?? ?? ?? D9 E0 D9 5D F4 D9 45 F4 51 51 D9 5C 24 04 D9 05 ?? ?? ?? ?? E9 D4 00 00 00 51 51 D9 05 ?? ?? ?? ?? 66 3B F7 75 0F D9 5C 24 04 D9 05 ?? ?? ?? ?? E9 B8 00 00 00 D9 54 24 04 E9 AF 00 00 00 66 3B C1 75 0C 51 51 66 85 F6 75 D1 D9 45 F8 EB BB 66 3B F7 75 58 66 85 C0 75 1B D9 EE D8 5D F8 DF E0 D9 45 FC F6 C4 41 75 02 D9 E0 D9 5D F4 D9 45 F4 51 51 EB B2 D9 45 FC E8 ?? ?? ?? ?? D9 5D F4 D9 45 FC E8 ?? ?? ?? ?? D9 5D F0 D9 05 ?? ?? ?? ?? D9 C0 D8 4D F4 51 51 D9 5D F4 D9 45 F4 D9 5C 24 04 D8 4D F0 D9 5D F0 D9 45 F0 EB 41 D9 45 FC E8 ?? ?? ?? ?? D9 5D F0 D9 45 FC E8 ?? ?? ?? ?? D9 5D F4 D9 45 F0 51 51 D9 5C 24 04 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? D9 5C 24 04 D9 45 F4 D9 1C 24 D9 45 F8 51 D9 1C 24 E8 ?? ?? ?? ?? 59 D9 1C 24 E8 ?? ?? ?? ?? 59 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_156_2_0 {
	meta:
		name = "_cosf"
		size = 24
		refs = "000a __CIcos"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "_expf"
		size = 24
		refs = "000a __CIexp"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_622_2_3 {
	meta:
		name = "_logf"
		size = 24
		refs = "000a __CIlog"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_369_2_4 {
	meta:
		name = "_sinf"
		size = 24
		refs = "000a __CIsin"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_650_1_3 {
	meta:
		name = "_sinhf"
		size = 24
		refs = "000a __CIsinh"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_475_2_2 {
	meta:
		name = "_sqrtf"
		size = 24
		refs = "000a __CIsqrt"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_650_3_2 {
	meta:
		name = "_tanf"
		size = 24
		refs = "000a __CItan"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_1_0 {
	meta:
		name = "??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
		size = 274
		refs = "0003 __sehtable$??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z 0008 __SEH_prolog4 001b __errno 0025 __invalid_parameter_noinfo 007b __lock_file 0094 __fclose_nolock 00ce __openfile 0103 __SEH_epilog4 010c __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 D2 00 00 00 33 DB 89 1E 8B 7D 0C 85 FF 75 11 E8 ?? ?? ?? ?? 6A 09 59 89 08 8B C1 E9 B6 00 00 00 33 C0 39 45 10 0F 95 C0 85 C0 74 C2 33 C0 39 45 14 0F 95 C0 85 C0 74 B6 38 1F 75 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB B5 89 5D E4 FF 75 14 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 14 8B 40 0C C1 E8 0D A8 01 74 09 FF 75 14 E8 ?? ?? ?? ?? 59 8B 45 14 89 18 8B 45 14 89 58 04 8B 45 14 89 58 08 33 C9 8B 45 14 83 C0 0C F0 21 08 B9 00 20 00 00 8B 45 14 83 C0 0C F0 09 08 FF 75 14 FF 75 18 FF 75 10 57 E8 ?? ?? ?? ?? 83 C4 10 89 06 85 C0 75 18 B9 FF DF FF FF 8B 45 14 83 C0 0C F0 21 08 E8 ?? ?? ?? ?? 8B 00 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 14 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
		size = 275
		refs = "0003 __sehtable$??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z 0008 __SEH_prolog4 001b __errno 0025 __invalid_parameter_noinfo 007c __lock_file 0095 __fclose_nolock 00cf __wopenfile 0104 __SEH_epilog4 010d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 D3 00 00 00 33 DB 89 1E 8B 7D 0C 85 FF 75 11 E8 ?? ?? ?? ?? 6A 09 59 89 08 8B C1 E9 B7 00 00 00 33 C0 39 45 10 0F 95 C0 85 C0 74 C2 33 C0 39 45 14 0F 95 C0 85 C0 74 B6 66 39 1F 75 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB B4 89 5D E4 FF 75 14 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 14 8B 40 0C C1 E8 0D A8 01 74 09 FF 75 14 E8 ?? ?? ?? ?? 59 8B 45 14 89 18 8B 45 14 89 58 04 8B 45 14 89 58 08 33 C9 8B 45 14 83 C0 0C F0 21 08 B9 00 20 00 00 8B 45 14 83 C0 0C F0 09 08 FF 75 14 FF 75 18 FF 75 10 57 E8 ?? ?? ?? ?? 83 C4 10 89 06 85 C0 75 18 B9 FF DF FF FF 8B 45 14 83 C0 0C F0 21 08 E8 ?? ?? ?? ?? 8B 00 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 14 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_157_14_0 {
	meta:
		name = "__wfreopen"
		size = 40
		refs = "001a ??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 FF 75 10 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_16_0 {
	meta:
		name = "_freopen"
		size = 40
		refs = "001a ??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 FF 75 10 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_15_0 {
	meta:
		name = "__wfreopen_s"
		size = 32
		refs = "0017 ??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_157_17_0 {
	meta:
		name = "_freopen_s"
		size = 32
		refs = "0017 ??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "___libm_sse2_asinf"
		size = 957
		refs = "0008 _ONEMASK 0013 _TMASK 005e ___acrt_acosf_asinf_t_table 0066 ___acrt_asinf_tbl_addr 0088 _cv 0107 _ABSVALMASK_S 010e _HALFMASK2 015d _PI_BY_2 0265 _HALFMASK 0377 _SIGNMASK"
	strings:
		$1 = { 66 0F 7E C0 F3 0F 10 1D ?? ?? ?? ?? 0F 57 FF F3 0F 10 15 ?? ?? ?? ?? B9 D7 B3 5D 3F BA FF FF FF 7F 23 D0 2B CA 81 EA 00 00 80 3D 0B CA 83 F9 00 0F 8C 9B 00 00 00 F3 0F 10 C8 F3 0F 59 C0 B9 01 00 00 00 66 0F C4 F9 01 F3 0F 5C D8 F3 0F 51 DB C1 EA 10 81 E2 FE 01 00 00 F3 0F 10 2C 55 ?? ?? ?? ?? 0F 10 24 95 ?? ?? ?? ?? 0F 54 D1 0F 56 D7 F3 0F 10 F1 F3 0F 10 C1 F3 0F 58 CA F3 0F 59 F5 F3 0F 5C C2 F3 0F 10 3D ?? ?? ?? ?? F3 0F 59 C1 F3 0F 10 EE F3 0F 59 D3 F3 0F 58 EA F3 0F 5E C5 F3 0F 5C F2 25 00 00 00 80 66 0F 6E D8 F3 0F 59 FE F3 0F 59 F6 F3 0F 59 FE 0F 57 E3 F3 0F 58 FC 66 0F 70 E4 55 0F 57 E3 F3 0F 58 C7 F3 0F 58 C4 C3 B9 FF FF FE 01 2B CA 0B CA 83 F9 00 0F 8C F5 00 00 00 F3 0F 10 C8 F3 0F 59 C0 B9 00 00 01 00 66 0F 6E E9 F3 0F 5C D8 F3 0F 10 F9 F3 0F 51 DB 66 0F D7 C1 0F 54 0D ?? ?? ?? ?? 0F 54 3D ?? ?? ?? ?? F3 0F 10 C1 F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 F7 F3 0F 5C CF F3 0F 59 FF F3 0F 58 C6 F3 0F 5C E7 F3 0F 59 C1 0F 54 D3 66 0F C5 D3 01 0F 56 D5 81 EA 80 3D 00 00 81 E2 FE FF 00 00 F3 0F 59 1C 55 ?? ?? ?? ?? F3 0F 59 F2 0F 28 3D ?? ?? ?? ?? F3 0F 59 CA F3 0F 59 D2 F3 0F 5C F3 F3 0F 58 F1 F3 0F 5C E2 F3 0F 58 DB F3 0F 5C E0 F3 0F 58 DE F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E E3 0F 10 14 95 ?? ?? ?? ?? F3 0F 59 EE F3 0F 59 F6 83 E0 08 C1 E0 0C F3 0F 59 EE 0F 5C FA F3 0F 58 EF 66 0F EF C0 66 0F C4 C0 01 F3 0F 10 CC 66 0F 70 DF 55 F3 0F 5C E3 F3 0F 58 DC F3 0F 5C CB F3 0F 5C E9 F3 0F 5C EC 0F 56 C5 C3 83 FA 00 7D 60 81 C2 00 00 00 06 83 FA 00 0F 8C B2 01 00 00 F3 0F 10 C8 F3 0F 59 C0 F3 0F 10 D1 F3 0F 59 0D ?? ?? ?? ?? F3 0F 10 E2 F3 0F 59 15 ?? ?? ?? ?? F3 0F 10 EC F3 0F 59 25 ?? ?? ?? ?? F3 0F 10 D8 F3 0F 59 C0 F3 0F 59 CB F3 0F 59 D8 F3 0F 59 C2 F3 0F 59 E3 F3 0F 58 C1 F3 0F 58 C4 F3 0F 58 C5 C3 81 FA 00 00 00 02 0F 8D FE 00 00 00 F3 0F 10 C8 F3 0F 59 C0 F3 0F 5C D8 F3 0F 10 F9 F3 0F 51 DB 66 0F C5 C7 01 0F 54 3D ?? ?? ?? ?? 66 0F 70 EB 00 0F 54 1D ?? ?? ?? ?? F3 0F 10 C7 F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 F7 F3 0F 5C CF F3 0F 59 FF F3 0F 58 C0 F3 0F 59 C1 F3 0F 5C E7 F3 0F 10 F3 F3 0F 59 DB F3 0F 10 D5 F3 0F 59 C9 F3 0F 5C E0 F3 0F 5C F5 F3 0F 58 ED F3 0F 5C E3 F3 0F 59 15 ?? ?? ?? ?? 66 0F 70 DD 55 F3 0F 5C E1 F3 0F 58 EE 66 0F 70 FB 55 F3 0F 58 DB F3 0F 59 EE F3 0F 58 E5 66 0F 70 F7 00 66 0F 70 CF 00 F3 0F 5E E3 F3 0F 59 3D ?? ?? ?? ?? F3 0F 59 F6 F3 0F 59 D6 F3 0F 59 F6 25 00 80 00 00 0F 28 05 ?? ?? ?? ?? F3 0F 59 FE F3 0F 58 D7 0F 57 DB 66 0F 70 F0 55 F3 0F 10 E9 66 0F C4 D8 01 F3 0F 5C CE F3 0F 5C C2 F3 0F 58 F1 F3 0F 5C C4 F3 0F 5C EE F3 0F 5C C5 F3 0F 5C C1 66 0F 56 C3 C3 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 80 3F 3B C2 74 19 81 FA 00 00 80 7F 77 34 BA 00 00 80 7F 66 0F 6E CA 0F 57 C0 F3 0F 59 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 0F 54 C1 F3 0F 58 D3 0F 56 C2 C3 0F 57 FF F3 0F 58 C7 C3 81 C2 00 00 80 57 66 0F 6E CA 81 FA 00 00 80 20 73 08 F3 0F 10 D0 F3 0F 59 D0 F3 0F 58 C8 C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_conj"
		size = 70
		refs = "0017 _creal 0028 _cimag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B 45 08 8D 75 F0 8B F8 D9 E0 DD 5D F8 83 C4 10 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "_conjl"
		size = 70
		refs = "0017 _creall 0028 _cimagl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B 45 08 8D 75 F0 8B F8 D9 E0 DD 5D F8 83 C4 10 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_160_1_0 {
	meta:
		name = "__pipe"
		size = 655
		refs = "0003 __sehtable$__pipe 0008 __SEH_prolog4 001b ___doserrno 0023 __errno 002e __invalid_parameter_noinfo 0036 __SEH_epilog4 00b0 __imp__CreatePipe@16 00ba __imp__GetLastError@0 00c0 ___acrt_errno_map_os_error 00c8 __alloc_osfhnd 00ec __imp__CloseHandle@4 0111 ___pioinfo 016e ___acrt_lowio_unlock_fh 01c2 __get_fmode 0255 ___acrt_lowio_set_os_handle 028a __invoke_watson"
	strings:
		$1 = { 6A 28 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 4D 08 85 C9 0F 95 C0 85 C0 75 21 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 83 CF FF 89 79 04 89 39 8B 55 10 8B C2 25 7F 3F FF FF F7 D8 1B C0 83 C0 01 75 1C E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 EB C3 8B C2 BE 00 C0 00 00 23 C6 33 C9 3B C6 0F 95 C1 85 C9 74 D0 C7 45 C8 0C 00 00 00 33 DB 89 5D CC 8B C2 C1 E8 07 F7 D0 83 E0 01 89 45 D0 FF 75 0C 8D 45 C8 50 8D 45 E0 50 8D 45 E4 50 FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB A7 E8 ?? ?? ?? ?? 8B F0 89 75 DC 3B F7 75 29 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 89 18 FF 75 E4 FF 15 ?? ?? ?? ?? FF 75 E0 FF 15 ?? ?? ?? ?? E9 70 FF FF FF 89 5D FC 8B D6 C1 FA 06 8B C6 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? C6 44 08 28 89 8B 04 95 ?? ?? ?? ?? 88 5C 08 29 8B 04 95 ?? ?? ?? ?? 80 64 08 2D FE C7 45 FC FE FF FF FF E8 2F 00 00 00 E8 ?? ?? ?? ?? 89 45 D8 3B C7 75 2B 8B C6 C1 F8 06 83 E6 3F 6B CE 30 8B 04 85 ?? ?? ?? ?? 88 5C 08 28 E9 71 FF FF FF 33 DB 83 CF FF 8B 75 DC 56 E8 ?? ?? ?? ?? 59 C3 C7 45 FC 01 00 00 00 8B 7D D8 8B D7 C1 FA 06 8B C7 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? C6 44 01 28 89 8B 04 95 ?? ?? ?? ?? 88 5C 01 29 8B 04 95 ?? ?? ?? ?? 80 64 01 2D FE C7 45 FC FE FF FF FF E8 C2 00 00 00 89 5D D4 8D 45 D4 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 B5 00 00 00 B8 00 80 00 00 8B 5D 10 85 D8 75 0D F7 C3 00 40 00 00 75 37 39 45 D4 75 32 8B D6 C1 FA 06 8B C6 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 80 64 08 28 7F 8B D7 C1 FA 06 8B C7 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 80 64 08 28 7F 84 DB 79 32 8B D6 C1 FA 06 8B C6 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 80 4C 08 28 10 8B D7 C1 FA 06 8B C7 83 E0 3F 6B C8 30 8B 04 95 ?? ?? ?? ?? 80 4C 08 28 10 FF 75 E4 56 E8 ?? ?? ?? ?? FF 75 E0 57 E8 ?? ?? ?? ?? 83 C4 10 8B 45 08 89 30 89 78 04 33 C0 E9 C1 FD FF FF 33 DB 8B 75 DC 8B 7D D8 57 E8 ?? ?? ?? ?? 59 C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_161_2_0 {
	meta:
		name = "__CIcos_default"
		size = 167
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 007f __indefinite 00a1 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 49 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD A9 FF FF 0F 00 75 31 83 7C 24 08 00 75 2A DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__initterm"
		size = 92
		refs = "0008 ___security_cookie 003c ___guard_check_icall_fptr 0054 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 56 8B 75 08 2B C6 83 C0 03 57 33 FF C1 E8 02 39 75 0C 1B DB F7 D3 23 D8 74 1C 8B 06 89 45 F8 85 C0 74 0B 8B C8 FF 15 ?? ?? ?? ?? FF 55 F8 83 C6 04 47 3B FB 75 E4 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "__initterm_e"
		size = 69
		refs = "0007 ___security_cookie 0021 ___guard_check_icall_fptr 003d @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 EB 17 8B 3E 85 FF 74 0E 8B CF FF 15 ?? ?? ?? ?? FF D7 85 C0 75 0A 83 C6 04 3B 75 0C 75 E4 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "??$common_tcsset_s@_W@@YAHQA_WI_W@Z"
		size = 82
		refs = "003b __errno 0045 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 85 C9 74 2D 8B 45 0C 85 C0 74 26 57 33 FF 8B D1 66 39 39 74 14 66 8B 75 10 83 E8 01 74 0B 66 89 32 83 C2 02 66 39 3A 75 F0 5F 85 C0 75 17 66 89 01 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 33 C0 EB F9 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__wcsset_s"
		size = 78
		refs = "003b __errno 0045 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 85 C9 74 2D 8B 45 0C 85 C0 74 26 33 F6 8B D1 66 39 31 74 16 57 66 8B 7D 10 83 E8 01 74 0B 66 89 3A 83 C2 02 66 39 32 75 F0 5F 85 C0 75 12 66 89 01 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "_wcscat"
		size = 49
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 33 C9 8B D0 66 39 08 74 08 83 C2 02 66 39 0A 75 F8 56 8B 75 0C 2B D6 0F B7 0E 66 89 0C 32 8D 76 02 66 85 C9 75 F1 5E 5D C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "_strncat"
		size = 309
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 B7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 11 8A 07 83 C7 01 84 C0 74 39 F7 C7 03 00 00 00 75 EF 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 21 84 E4 74 18 A9 00 00 FF 00 74 0C A9 00 00 00 FF 75 CF 83 EF 01 EB 0D 83 EF 02 EB 08 83 EF 03 EB 03 83 EF 04 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 5C EB 22 8A 16 83 C6 01 84 D2 74 3D 88 17 83 C7 01 83 E9 01 74 29 F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 38 8B CB 83 E1 03 74 13 8A 16 83 C6 01 88 17 83 C7 01 84 D2 74 07 83 E9 01 75 ED 88 0F 5B 5E 8B 44 24 08 5F C3 88 17 8B 44 24 10 5B 5E 5F C3 89 17 83 C7 04 83 E9 01 74 C8 BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 CE 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C4 89 17 8B 44 24 10 5B 5E 5F C3 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 66 89 17 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__87except"
		size = 267
		refs = "001e ___security_cookie 0072 __handle_exc 00bd __raise_exc 00d1 __ctrlfp 00dd ___acrt_has_user_matherr 00e7 ___acrt_invoke_user_matherr 00f3 __set_errno_from_matherr 0100 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 56 8B 73 0C 57 0F B7 08 89 8D 7C FF FF FF 8B 06 83 E8 01 74 29 83 E8 01 74 20 83 E8 01 74 17 83 E8 01 74 0E 83 E8 01 74 15 83 E8 03 75 72 6A 10 EB 0E 6A 12 EB 0A 6A 11 EB 06 6A 04 EB 02 6A 08 5F 51 8D 46 18 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 47 8B 4B 08 83 F9 10 74 10 83 F9 16 74 0B 83 F9 1D 74 06 83 65 C0 FE EB 12 8B 45 C0 DD 46 10 83 E0 E3 83 C8 03 DD 5D B0 89 45 C0 8D 46 18 50 8D 46 08 50 51 57 8D 85 7C FF FF FF 50 8D 45 80 50 E8 ?? ?? ?? ?? 83 C4 18 8B 8D 7C FF FF FF 68 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 3E 08 59 59 74 14 E8 ?? ?? ?? ?? 84 C0 74 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 08 FF 36 E8 ?? ?? ?? ?? 59 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_168_5_0 {
	meta:
		name = "___acrt_locale_free_numeric"
		size = 105
		refs = "0011 ___acrt_lconv_c 0019 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 74 59 8B 06 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 04 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 08 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 30 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 34 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 5E 5D C3 }
	condition:
		$1
}

rule file_168_6_0 {
	meta:
		name = "___acrt_locale_initialize_numeric"
		size = 540
		refs = "002c ___acrt_lconv_c 003f __calloc_base 0063 __malloc_base 0070 __free_base 00ca ___acrt_GetLocaleInfoA 013b ___acrt_locale_free_numeric"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 8B 5D 08 33 C0 56 57 89 5D E8 89 45 EC 39 83 B0 00 00 00 75 17 39 83 AC 00 00 00 75 0F 8B F8 89 45 F8 BE ?? ?? ?? ?? E9 56 01 00 00 33 F6 46 6A 50 56 89 75 F4 E8 ?? ?? ?? ?? 89 45 FC 59 59 85 C0 75 07 8B C6 E9 7E 01 00 00 8B B3 88 00 00 00 8B F8 6A 14 59 F3 A5 6A 04 E8 ?? ?? ?? ?? 8B F0 33 FF 57 89 75 F8 E8 ?? ?? ?? ?? 59 59 85 F6 75 11 FF 75 FC E8 ?? ?? ?? ?? 33 C0 59 40 E9 46 01 00 00 89 3E 39 BB B0 00 00 00 0F 84 54 01 00 00 6A 04 E8 ?? ?? ?? ?? 8B F0 57 89 75 F0 E8 ?? ?? ?? ?? 59 59 85 F6 0F 84 8F 00 00 00 FF 75 FC 89 3E 8D 45 E8 8B BB B0 00 00 00 6A 0E 57 6A 01 50 E8 ?? ?? ?? ?? 8B 4D FC 8B F0 83 C1 04 8D 45 E8 51 6A 0F 57 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 08 50 6A 10 57 89 45 F4 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8B 45 FC 83 C0 30 50 6A 0E 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8B 45 FC 83 C0 34 50 6A 0F 57 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 14 0B C6 74 25 FF 75 FC E8 ?? ?? ?? ?? 83 4D F4 FF 59 FF 75 FC E8 ?? ?? ?? ?? 8B 4D F8 51 E8 ?? ?? ?? ?? 8B 45 F4 59 59 EB 75 8B 55 F4 8B 12 EB 0F 8A 02 3C 30 7C 6F 3C 39 7F 6B 2C 30 88 02 42 80 3A 00 75 EC 8B 7D F0 8B 75 FC 8B 4D F8 33 C0 40 89 01 85 FF 74 02 89 07 8B 83 80 00 00 00 85 C0 74 03 F0 FF 08 8B 4B 7C 85 C9 74 1E 83 C8 FF F0 0F C1 01 75 15 FF 73 7C E8 ?? ?? ?? ?? FF B3 88 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 45 F8 89 43 7C 33 C0 89 BB 80 00 00 00 89 B3 88 00 00 00 5F 5E 5B 8B E5 5D C3 3C 3B 75 95 8B F2 8A 46 01 88 06 8D 76 01 80 3E 00 75 F3 EB 85 8B 75 FC A1 ?? ?? ?? ?? 89 06 A1 ?? ?? ?? ?? 89 46 04 A1 ?? ?? ?? ?? 89 46 08 A1 ?? ?? ?? ?? 89 46 30 A1 ?? ?? ?? ?? 89 46 34 E9 61 FF FF FF }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "__mbctohira_l"
		size = 59
		refs = "000e __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 0C 8B 75 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 1E 81 FE 93 83 00 00 77 16 81 FE 7F 83 00 00 73 08 81 EE A1 00 00 00 EB 06 81 EE A2 00 00 00 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__FCmulcc"
		size = 133
		refs = "000f _crealf 001d _cimagf 007b __FCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C D9 5D F0 FF 75 08 E8 ?? ?? ?? ?? FF 75 14 D9 5D F8 FF 75 10 E8 ?? ?? ?? ?? FF 75 14 D9 5D FC FF 75 10 E8 ?? ?? ?? ?? D9 5D F4 D9 45 FC 83 C4 18 D9 C0 D9 45 F8 D9 C0 DE CA D9 45 F4 D9 C0 D9 45 F0 D9 C0 DE CA D9 CC DE C1 D9 5D F0 D9 45 F0 D9 5C 24 04 D9 CB DE CA DE CA DE E1 D9 5D F0 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "__FCmulcr"
		size = 69
		refs = "000d _cimagf 0027 _crealf 003b __FCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D8 4D 10 83 C4 04 D9 5D FC D9 45 FC D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D8 4D 10 83 C4 04 D9 5D FC D9 45 FC D9 1C 24 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_2_0 {
	meta:
		name = "_cpowf"
		size = 189
		refs = "000e _cimagf 0026 _crealf 002c __real@0000000000000000 0079 __CIpow 008f __FCbuild 009e _clogf 00ab __FCmulcc 00b2 _cexpf"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D9 EE DA E9 DF E0 59 59 F6 C4 44 7A 78 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? DC 1D ?? ?? ?? ?? DF E0 59 59 F6 C4 01 75 5E FF 75 14 FF 75 10 E8 ?? ?? ?? ?? D9 EE DA E9 DF E0 59 59 F6 C4 44 7A 46 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 14 D9 5D FC D9 45 FC FF 75 10 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C9 E8 ?? ?? ?? ?? D9 5D FC D9 EE 51 51 D9 5C 24 04 D9 45 FC D9 1C 24 E8 ?? ?? ?? ?? 59 59 EB 22 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 52 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 83 C4 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_3_0 {
	meta:
		name = "_powf"
		size = 27
		refs = "000d __CIpow"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 D9 45 0C E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_269_0_3 {
	meta:
		name = "_atan2f"
		size = 27
		refs = "000d __CIatan2"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 D9 45 0C E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_404_3_3 {
	meta:
		name = "_fmodf"
		size = 27
		refs = "000d __CIfmod"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 D9 45 0C E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_4_0 {
	meta:
		name = "___acrt_add_locale_ref"
		size = 125
		refs = "0047 ___acrt_wide_c_locale_string 0075 ___acrt_locale_add_lc_time_reference"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F0 FF 40 0C 8B 48 7C 85 C9 74 03 F0 FF 01 8B 88 84 00 00 00 85 C9 74 03 F0 FF 01 8B 88 80 00 00 00 85 C9 74 03 F0 FF 01 8B 88 8C 00 00 00 85 C9 74 03 F0 FF 01 56 6A 06 8D 48 28 5E 81 79 F8 ?? ?? ?? ?? 74 09 8B 11 85 D2 74 03 F0 FF 02 83 79 F4 00 74 0A 8B 51 FC 85 D2 74 03 F0 FF 02 83 C1 10 83 EE 01 75 D6 FF B0 9C 00 00 00 E8 ?? ?? ?? ?? 59 5E 5D C3 }
	condition:
		$1
}

rule file_171_5_0 {
	meta:
		name = "___acrt_free_locale"
		size = 330
		refs = "0017 ___acrt_lconv_c 003a __free_base 0045 ___acrt_locale_free_monetary 0067 ___acrt_locale_free_numeric 00d8 ___acrt_locale_free_lc_time_if_unreferenced 00ef ___acrt_wide_c_locale_string"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 08 57 8B 86 88 00 00 00 85 C0 74 6C 3D ?? ?? ?? ?? 74 65 8B 46 7C 85 C0 74 5E 83 38 00 75 59 8B 86 84 00 00 00 85 C0 74 18 83 38 00 75 13 50 E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 80 00 00 00 85 C0 74 18 83 38 00 75 13 50 E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? 59 59 FF 76 7C E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 8C 00 00 00 85 C0 74 45 83 38 00 75 40 8B 86 90 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 94 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 98 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 8C 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF B6 9C 00 00 00 E8 ?? ?? ?? ?? 59 6A 06 58 8D 9E A0 00 00 00 89 45 FC 8D 7E 28 81 7F F8 ?? ?? ?? ?? 74 1D 8B 07 85 C0 74 14 83 38 00 75 0F 50 E8 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 59 59 8B 45 FC 83 7F F4 00 74 16 8B 47 FC 85 C0 74 0C 83 38 00 75 07 50 E8 ?? ?? ?? ?? 59 8B 45 FC 83 C3 04 83 C7 10 83 E8 01 89 45 FC 75 B0 56 E8 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_6_0 {
	meta:
		name = "___acrt_locale_add_lc_time_reference"
		size = 41
		refs = "000e ___lc_time_c"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 74 16 81 F9 ?? ?? ?? ?? 74 0E 33 C0 40 F0 0F C1 81 B0 00 00 00 40 5D C3 B8 FF FF FF 7F 5D C3 }
	condition:
		$1
}

rule file_171_7_0 {
	meta:
		name = "___acrt_locale_free_lc_time_if_unreferenced"
		size = 48
		refs = "000f ___lc_time_c 0021 ___acrt_locale_free_time 0027 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 74 20 81 FE ?? ?? ?? ?? 74 18 8B 86 B0 00 00 00 85 C0 75 0E 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_171_8_0 {
	meta:
		name = "___acrt_locale_release_lc_time_reference"
		size = 41
		refs = "000e ___lc_time_c"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 74 16 81 F9 ?? ?? ?? ?? 74 0E 83 C8 FF F0 0F C1 81 B0 00 00 00 48 5D C3 B8 FF FF FF 7F 5D C3 }
	condition:
		$1
}

rule file_171_9_0 {
	meta:
		name = "___acrt_release_locale_ref"
		size = 129
		refs = "004b ___acrt_wide_c_locale_string 0079 ___acrt_locale_release_lc_time_reference"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 73 F0 FF 48 0C 8B 48 7C 85 C9 74 03 F0 FF 09 8B 88 84 00 00 00 85 C9 74 03 F0 FF 09 8B 88 80 00 00 00 85 C9 74 03 F0 FF 09 8B 88 8C 00 00 00 85 C9 74 03 F0 FF 09 56 6A 06 8D 48 28 5E 81 79 F8 ?? ?? ?? ?? 74 09 8B 11 85 D2 74 03 F0 FF 0A 83 79 F4 00 74 0A 8B 51 FC 85 D2 74 03 F0 FF 0A 83 C1 10 83 EE 01 75 D6 FF B0 9C 00 00 00 E8 ?? ?? ?? ?? 59 5E 5D C3 }
	condition:
		$1
}

rule file_171_10_0 {
	meta:
		name = "___acrt_update_thread_locale_data"
		size = 119
		refs = "0003 __sehtable$___acrt_update_thread_locale_data 0008 __SEH_prolog4 0011 ___acrt_getptd 0019 ___globallocalestatus 002f ___acrt_lock 003a ___acrt_current_locale_data 0043 __updatetlocinfoEx_nolock 005f _abort 0069 ___acrt_unlock 0072 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 E8 ?? ?? ?? ?? 8B F8 8B 0D ?? ?? ?? ?? 85 8F 50 03 00 00 74 07 8B 77 4C 85 F6 75 43 6A 04 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 35 ?? ?? ?? ?? 8D 47 4C 50 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 85 F6 75 11 E8 ?? ?? ?? ?? 8B 75 E4 6A 04 E8 ?? ?? ?? ?? 59 C3 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_171_11_0 {
	meta:
		name = "__updatetlocinfoEx_nolock"
		size = 80
		refs = "0023 ___acrt_add_locale_ref 002e ___acrt_release_locale_ref 003b ___acrt_initial_locale_data 0043 ___acrt_free_locale"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 0C 57 85 F6 74 3C 8B 45 08 85 C0 74 35 8B 38 3B FE 75 04 8B C6 EB 2D 56 89 30 E8 ?? ?? ?? ?? 59 85 FF 74 EF 57 E8 ?? ?? ?? ?? 83 7F 0C 00 59 75 E2 81 FF ?? ?? ?? ?? 74 DA 57 E8 ?? ?? ?? ?? 59 EB D1 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "___acrt_initialize_heap"
		size = 17
		refs = "0002 __imp__GetProcessHeap@0 0009 ___acrt_heap"
	strings:
		$1 = { FF 15 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 95 C0 C3 }
	condition:
		$1
}

rule file_173_9_0 {
	meta:
		name = "__fclose_nolock"
		size = 118
		refs = "000e __errno 0019 __invalid_parameter_noinfo 0032 ___acrt_stdio_flush_nolock 003a ___acrt_stdio_free_buffer_nolock 0040 __fileno 0046 __close 0060 __free_base 006b ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 51 8B 46 0C 57 83 CF FF C1 E8 0D A8 01 74 39 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 79 05 83 CF FF EB 13 83 7E 1C 00 74 0D FF 76 1C E8 ?? ?? ?? ?? 83 66 1C 00 59 56 E8 ?? ?? ?? ?? 59 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_173_10_0 {
	meta:
		name = "_fclose"
		size = 128
		refs = "0003 __sehtable$_fclose 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 003e ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 004a __lock_file 0055 __fclose_nolock 006e __SEH_epilog4 007a __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 89 75 E0 33 C0 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 3B 8B 46 0C C1 E8 0C 56 A8 01 74 08 E8 ?? ?? ?? ?? 59 EB E8 83 65 E4 00 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_174_12_0 {
	meta:
		name = "?close@environment_strings_traits@?A0x1bf47908@@SA_NPA_W@Z"
		size = 18
		refs = "000a __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? B0 01 5D C3 }
	condition:
		$1
}

rule file_174_15_0 {
	meta:
		name = "?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z"
		size = 55
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 57 33 FF 66 39 3A 74 21 56 8B CA 8D 71 02 66 8B 01 83 C1 02 66 3B C7 75 F5 2B CE D1 F9 8D 14 4A 83 C2 02 66 39 3A 75 E1 5E 8D 42 02 5F 5D C3 }
	condition:
		$1
}

rule file_174_25_0 {
	meta:
		name = "___dcrt_get_narrow_environment_from_os"
		size = 131
		refs = "000b __imp__GetEnvironmentStringsW@0 0019 ?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z 002e __imp__WideCharToMultiByte@32 003b __malloc_base 0066 __free_base 0076 __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 FF 15 ?? ?? ?? ?? 8B F0 33 FF 85 F6 74 56 56 E8 ?? ?? ?? ?? 59 57 57 57 8B D8 57 2B DE D1 FB 53 56 57 57 FF 15 ?? ?? ?? ?? 89 45 FC 85 C0 74 34 50 E8 ?? ?? ?? ?? 8B F8 59 85 FF 74 1C 33 C0 50 50 FF 75 FC 57 53 56 50 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 8B DF 33 FF EB 02 33 DB 57 E8 ?? ?? ?? ?? 59 EB 02 8B DF 85 F6 74 07 56 FF 15 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_174_26_0 {
	meta:
		name = "___dcrt_get_wide_environment_from_os"
		size = 80
		refs = "0006 __imp__GetEnvironmentStringsW@0 0017 ?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z 0024 __malloc_base 0034 _memcpy 003e __free_base 0046 __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 56 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 04 33 FF EB 37 53 56 E8 ?? ?? ?? ?? 2B C6 D1 F8 8D 1C 00 53 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 0B 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 59 56 FF 15 ?? ?? ?? ?? 5B 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "_casinh"
		size = 765
		refs = "0017 _creal 0028 _cimag 0034 __dtest 00b3 __real@bfe921fb54442d18 00be __real@3fe921fb54442d18 00d4 __Zero_C 0103 __real@bff921fb54442d18 010e __real@3ff921fb54442d18 012e __Cbuild 0142 _csqrt 01e9 __real@5fcffb3abd82527b 0253 _asinh 0277 __CIlog 02b0 __Cmulcc 02cd __CIatan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 E8 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 6A 02 59 66 3B F1 75 2B 66 3B C1 74 1B 66 85 C0 74 16 66 83 F8 01 75 0B DD 45 F8 DD 45 E8 E9 69 02 00 00 DD 45 E8 EB 19 DD 45 E8 DD 45 F8 E9 59 02 00 00 66 3B C1 75 10 66 83 FE 01 74 EA DD 45 F8 D9 C0 E9 44 02 00 00 33 C9 41 66 3B F1 75 4C DD 45 E8 66 3B C1 75 25 DD 5D F0 D9 EE DC 5D F8 DF E0 F6 C4 41 75 0B DD 05 ?? ?? ?? ?? E9 15 02 00 00 DD 05 ?? ?? ?? ?? E9 0A 02 00 00 B8 00 80 00 00 66 85 45 FE 74 0D DD 05 ?? ?? ?? ?? D9 E0 E9 F7 01 00 00 D9 EE E9 F0 01 00 00 66 3B C1 75 2C DD 45 F8 DD 5D F0 D9 EE DD 45 F0 D8 D1 DF E0 DD D9 F6 C4 05 7A 0B DD 05 ?? ?? ?? ?? E9 CA 01 00 00 DD 05 ?? ?? ?? ?? E9 BF 01 00 00 DD 45 E8 8D 45 B8 83 EC 10 DD 5C 24 08 D9 E8 DC 65 F8 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 C8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 E8 8D 7D A8 8B F0 83 C4 04 D9 E0 8D 45 C8 DD 5C 24 08 DD 45 F8 D9 E8 A5 DE C1 A5 DD 1C 24 50 A5 A5 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 D8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 E8 8D 7D B8 8B F0 83 C4 14 DD 55 F0 D9 EE DA E9 A5 DF E0 A5 A5 A5 F6 C4 44 0F 8B F0 00 00 00 83 EC 10 8D 75 A8 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 A8 DD 5D E0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 B8 DD 5D D0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 B8 DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 10 DD 45 E0 D8 D1 DF E0 F6 C4 41 75 0D DD D9 DD 55 E0 DC 7D F0 DC 4D D0 EB 42 DD 45 D0 D8 D2 DF E0 F6 C4 41 75 09 DD DA D9 C1 DD 5D E0 EB 14 D9 C0 D9 E0 DD 55 E0 D8 D3 DF E0 DD DB F6 C4 41 75 0D DD D8 D9 CA DE F1 DE C9 DC 6D F0 EB 10 DD DA D9 EE DD 5D E0 DD 45 F0 DE CA DE CA DE E1 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F0 DD 45 E0 83 C4 08 D9 EE DD E1 DF E0 F6 C4 44 7B 22 D8 DA DF E0 DD D9 F6 C4 41 7A 0D E8 ?? ?? ?? ?? DC 45 F0 DD 5D F0 EB 10 E8 ?? ?? ?? ?? DC 6D F0 EB F1 DD DA DD D8 DD D8 83 EC 10 8D 75 B8 8B FC 8D 45 A8 83 EC 10 A5 A5 A5 A5 8B FC 8D 75 A8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 83 C4 14 8B F0 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C9 E8 ?? ?? ?? ?? DD 45 F0 D9 C9 83 EC 10 8D 45 A8 DD 5C 24 08 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_4_0 {
	meta:
		name = "__wcsicoll"
		size = 149
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 008c __wcsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 75 8B 55 08 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 8B 4D 0C 85 C9 74 E2 53 56 57 6A 41 5F 6A 5A 2B D1 5B 0F B7 04 0A 66 3B C7 72 0D 66 3B C3 77 08 83 C0 20 0F B7 F0 EB 02 8B F0 0F B7 01 66 3B C7 72 0B 66 3B C3 77 06 83 C0 20 0F B7 C0 83 C1 02 66 85 F6 74 05 66 3B F0 74 C8 0F B7 C8 5F 0F B7 C6 5E 2B C1 5B 5D C3 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_425_4_0 {
	meta:
		name = "__wcsicmp"
		size = 149
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 008c __wcsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 75 8B 55 08 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 8B 4D 0C 85 C9 74 E2 53 56 57 6A 41 5F 6A 5A 2B D1 5B 0F B7 04 0A 66 3B C7 72 0D 66 3B C3 77 08 83 C0 20 0F B7 F0 EB 02 8B F0 0F B7 01 66 3B C7 72 0B 66 3B C3 77 06 83 C0 20 0F B7 C0 83 C1 02 66 85 F6 74 05 66 3B F0 74 C8 0F B7 C8 5F 0F B7 C6 5E 2B C1 5B 5D C3 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_176_5_0 {
	meta:
		name = "__wcsicoll_l"
		size = 214
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0022 __errno 002d __invalid_parameter_noinfo 00a0 ___acrt_CompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 10 E8 ?? ?? ?? ?? 8B 55 08 85 D2 74 07 8B 4D 0C 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 80 00 00 00 8B 45 F4 8B 80 A4 00 00 00 85 C0 75 50 53 56 57 6A 41 5F 6A 5A 2B D1 5B 0F B7 04 0A 66 3B C7 72 0D 66 3B C3 77 08 83 C0 20 0F B7 F0 EB 02 8B F0 0F B7 01 66 3B C7 72 0B 66 3B C3 77 06 83 C0 20 0F B7 C0 83 C1 02 66 85 F6 74 05 66 3B F0 74 C8 5F 0F B7 D6 0F B7 C0 5E 2B D0 5B EB 2D 6A FF 51 6A FF 52 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 BA FF FF FF 7F EB 03 8D 50 FE 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__byteswap_uint64"
		size = 150
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 0C 33 D2 57 8B 7D 08 8B C6 8B CF 8B DF 0F A4 C8 10 81 E3 00 FF 00 00 C1 E1 10 03 D9 6A 00 13 D0 8B C7 0F A4 DA 10 25 00 00 FF 00 C1 E3 10 03 D8 8B C7 59 13 D1 25 00 00 00 FF 0F A4 DA 10 6A 00 C1 E3 10 03 D8 8B C6 13 D1 C1 E8 08 0F A4 DA 08 25 00 FF 00 00 C1 E3 08 03 D8 8B C6 13 D1 8B CF 0F AC C1 08 58 81 E1 00 00 00 FF 03 D9 8B CE 13 D0 0F AC CF 18 81 E7 00 00 FF 00 03 DF 5F 13 D0 C1 EE 18 03 DE 5E 13 D0 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "__byteswap_ulong"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 8B C2 56 BE 00 FF 00 00 8B CA 23 C6 C1 E1 10 03 C1 8B CA C1 E9 08 23 CE C1 E0 08 03 C1 C1 EA 18 03 C2 5E 5D C3 }
	condition:
		$1
}

rule file_177_2_0 {
	meta:
		name = "__byteswap_ushort"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B C1 C1 E0 08 66 C1 E9 08 66 03 C1 5D C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "??$common_difftime@J@@YANJJ@Z"
		size = 54
		refs = "0026 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 0C 00 7C 18 8B 45 08 85 C0 78 11 2B 45 0C 89 45 FC DB 45 FC DD 5D F8 DD 45 F8 EB 0D E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "??$common_difftime@_J@@YAN_J0@Z"
		size = 77
		refs = "003d __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 14 00 7C 2F 7F 06 83 7D 10 00 72 27 8B 45 0C 85 C0 7C 20 8B 4D 08 7F 04 85 C9 72 17 2B 4D 10 89 4D F8 1B 45 14 89 45 FC DF 6D F8 DD 5D F8 DD 45 F8 EB 0D E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_2_0 {
	meta:
		name = "__difftime32"
		size = 47
		refs = "001f __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 0C 00 7C 12 8B 45 08 85 C0 78 0B 2B 45 0C 89 45 FC DB 45 FC EB 0D E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_3_0 {
	meta:
		name = "__difftime64"
		size = 71
		refs = "0037 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 14 00 7C 29 7F 06 83 7D 10 00 72 21 8B 45 0C 85 C0 7C 1A 8B 4D 08 7F 04 85 C9 72 11 2B 4D 10 89 4D F8 1B 45 14 89 45 FC DF 6D F8 EB 0D E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "??$common_tox_l@$1?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_upper@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
		size = 330
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 ?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z 008d __isleadbyte_l 00ab __errno 00e8 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8D 4D E4 53 FF 75 10 E8 ?? ?? ?? ?? 8B 5D 08 81 FB 00 01 00 00 73 4B 8D 45 E8 50 53 E8 ?? ?? ?? ?? 59 59 84 C0 74 24 80 7D F0 00 8B 45 E8 8B 80 98 00 00 00 0F B6 0C 18 74 0A 8B 45 E4 83 A0 50 03 00 00 FD 8B C1 E9 F2 00 00 00 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C3 E9 DB 00 00 00 33 C0 66 89 45 FC 88 45 FE 8B 45 E8 83 78 04 01 7E 2E 8B C3 8D 4D E8 C1 F8 08 89 45 F4 51 0F B6 C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 13 8B 45 F4 88 45 FC 33 C0 6A 02 88 5D FD 88 45 FE 59 EB 16 E8 ?? ?? ?? ?? 33 C9 C7 00 2A 00 00 00 33 C0 88 5D FC 41 88 45 FD 66 89 45 F8 8D 55 F8 88 45 FA 8B 45 E8 6A 01 FF 70 08 6A 03 52 51 8D 4D FC 51 FF 75 0C FF B0 A8 00 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 18 38 45 F0 0F 84 67 FF FF FF 8B 45 E4 83 A0 50 03 00 00 FD E9 58 FF FF FF 83 F8 01 75 16 80 7D F0 00 0F B6 45 F8 74 2B 8B 4D E4 83 A1 50 03 00 00 FD EB 1F 0F B6 55 F8 0F B6 45 F9 C1 E2 08 0B D0 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C2 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_1_0 {
	meta:
		name = "??$common_tox_l@$1?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_lower@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
		size = 330
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 ?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z 008d __isleadbyte_l 00ab __errno 00e8 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8D 4D E4 53 FF 75 10 E8 ?? ?? ?? ?? 8B 5D 08 81 FB 00 01 00 00 73 4B 8D 45 E8 50 53 E8 ?? ?? ?? ?? 59 59 84 C0 74 24 80 7D F0 00 8B 45 E8 8B 80 94 00 00 00 0F B6 0C 18 74 0A 8B 45 E4 83 A0 50 03 00 00 FD 8B C1 E9 F2 00 00 00 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C3 E9 DB 00 00 00 33 C0 66 89 45 FC 88 45 FE 8B 45 E8 83 78 04 01 7E 2E 8B C3 8D 4D E8 C1 F8 08 89 45 F4 51 0F B6 C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 13 8B 45 F4 88 45 FC 33 C0 6A 02 88 5D FD 88 45 FE 59 EB 16 E8 ?? ?? ?? ?? 33 C9 C7 00 2A 00 00 00 33 C0 88 5D FC 41 88 45 FD 66 89 45 F8 8D 55 F8 88 45 FA 8B 45 E8 6A 01 FF 70 08 6A 03 52 51 8D 4D FC 51 FF 75 0C FF B0 A8 00 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 18 38 45 F0 0F 84 67 FF FF FF 8B 45 E4 83 A0 50 03 00 00 FD E9 58 FF FF FF 83 F8 01 75 16 80 7D F0 00 0F B6 45 F8 74 2B 8B 4D E4 83 A1 50 03 00 00 FD EB 1F 0F B6 55 F8 0F B6 45 F9 C1 E2 08 0B D0 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C2 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_5_0 {
	meta:
		name = "?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z"
		size = 29
		refs = "000e __ischartype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_179_6_0 {
	meta:
		name = "?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z"
		size = 29
		refs = "000e __ischartype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_179_7_0 {
	meta:
		name = "?internal_map_lower@@YAHHQAU__crt_locale_pointers@@@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 00 8B 88 94 00 00 00 8B 45 08 0F B6 04 01 5D C3 }
	condition:
		$1
}

rule file_179_8_0 {
	meta:
		name = "?internal_map_upper@@YAHHQAU__crt_locale_pointers@@@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 00 8B 88 98 00 00 00 8B 45 08 0F B6 04 01 5D C3 }
	condition:
		$1
}

rule file_179_14_0 {
	meta:
		name = "__tolower_l"
		size = 26
		refs = "0011 ??$common_tox_l@$1?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_lower@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 00 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_179_16_0 {
	meta:
		name = "__toupper_l"
		size = 26
		refs = "0011 ??$common_tox_l@$1?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_upper@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 00 02 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_179_17_0 {
	meta:
		name = "_tolower"
		size = 48
		refs = "0007 ___acrt_locale_changed_data 0014 __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 74 10 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B C8 EB 0E 8B 4D 08 8D 41 BF 83 F8 19 77 03 83 C1 20 8B C1 5D C3 }
	condition:
		$1
}

rule file_179_18_0 {
	meta:
		name = "_toupper"
		size = 48
		refs = "0007 ___acrt_locale_changed_data 0014 __toupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 74 10 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B C8 EB 0E 8B 4D 08 8D 41 9F 83 F8 19 77 03 83 C1 E0 8B C1 5D C3 }
	condition:
		$1
}

rule file_181_5_0 {
	meta:
		name = "__mbsstr_l"
		size = 240
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0027 _strstr 0050 __errno 005b __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F0 33 F6 39 70 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 E9 A3 00 00 00 8B 5D 0C 85 DB 74 14 80 3B 00 75 08 8B 75 08 E9 8F 00 00 00 8B 4D 08 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 76 8B F9 8D 57 01 8A 07 47 84 C0 75 F9 2B FA 8B D3 8D 42 01 89 45 F8 8A 02 42 84 C0 75 F9 2B 55 F8 2B FA 03 F9 38 01 74 4E 8B D1 2B D3 3B CF 77 46 8B C3 8A 19 88 5D FE 84 DB 74 12 8A 18 84 DB 74 33 38 1C 02 75 07 40 80 3C 02 00 75 EE 80 38 00 74 22 8B 5D F0 41 0F B6 45 FE 42 8A 44 18 19 8B 5D 0C 24 04 74 07 80 39 00 74 0B 41 42 80 39 00 75 BA EB 02 8B F1 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "??$common_fopen_s@D@@YAHQAPAU_iobuf@@QBD1@Z"
		size = 71
		refs = "000e __errno 0018 __invalid_parameter_noinfo 002c ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "??$common_fopen_s@_W@@YAHQAPAU_iobuf@@QB_W1@Z"
		size = 71
		refs = "000e __errno 0018 __invalid_parameter_noinfo 002c ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
		size = 193
		refs = "0003 __sehtable$??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 005e ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 0087 __openfile 00a2 __SEH_epilog4 00b2 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 00bb __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 73 33 C0 8B 7D 0C 85 FF 0F 95 C0 85 C0 74 DE 33 C0 38 07 0F 95 C0 85 C0 74 D3 80 3E 00 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D1 8D 45 E4 50 E8 ?? ?? ?? ?? 59 83 7D E4 00 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB B4 83 65 E0 00 83 65 FC 00 FF 75 E4 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 10 8B F0 89 75 E0 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E0 85 F6 75 09 FF 75 E4 E8 ?? ?? ?? ?? 59 FF 75 E4 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_182_3_0 {
	meta:
		name = "??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
		size = 193
		refs = "0003 __sehtable$??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0061 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 0087 __wopenfile 00a2 __SEH_epilog4 00b2 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 00bb __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 73 33 C0 8B 7D 0C 85 FF 0F 95 C0 85 C0 74 DE 33 C0 33 DB 66 39 1F 0F 95 C0 85 C0 74 D0 66 39 1E 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB CE 8D 45 E4 50 E8 ?? ?? ?? ?? 59 39 5D E4 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB B2 89 5D E0 89 5D FC FF 75 E4 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 10 8B F0 89 75 E0 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E0 85 F6 75 09 FF 75 E4 E8 ?? ?? ?? ?? 59 FF 75 E4 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_182_10_0 {
	meta:
		name = "__wfopen"
		size = 23
		refs = "000e ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_182_13_0 {
	meta:
		name = "_fopen"
		size = 23
		refs = "000e ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_182_11_0 {
	meta:
		name = "__wfopen_s"
		size = 71
		refs = "000e __errno 0018 __invalid_parameter_noinfo 002a ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 75 09 E8 ?? ?? ?? ?? 8B 30 EB 02 33 F6 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_182_14_0 {
	meta:
		name = "_fopen_s"
		size = 71
		refs = "000e __errno 0018 __invalid_parameter_noinfo 002a ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 75 09 E8 ?? ?? ?? ?? 8B 30 EB 02 33 F6 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_183_2_0 {
	meta:
		name = "??$common_system@D@@YAHQBD@Z"
		size = 256
		refs = "0009 ___security_cookie 001e ?comspec_name@?1???$common_system@D@@YAHQBD@Z@4QBDB 0028 __dupenv_s 004e __access_s 0066 ?slash_c@?1???$common_system@D@@YAHQBD@Z@4QBDB 0075 __errno 008c __spawnve 00c5 ?cmd_exe@?1???$common_system@D@@YAHQBD@Z@4QBDB 00d0 __spawnvpe 00dd __free_base 00ed @__security_check_cookie@4 00fb __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 8D 45 E8 33 F6 68 ?? ?? ?? ?? 56 50 89 75 E8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 B9 00 00 00 85 FF 75 1D 39 75 E8 0F 84 90 00 00 00 56 FF 75 E8 E8 ?? ?? ?? ?? 8B F0 F7 DE 59 1B F6 59 46 EB 7C 8B 45 E8 89 45 EC C7 45 F0 ?? ?? ?? ?? 89 7D F4 89 75 F8 85 C0 74 4C E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 56 89 30 8D 45 EC 50 FF 75 EC 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E8 ?? ?? ?? ?? 83 FB FF 74 06 89 38 8B F3 EB 34 83 38 02 74 0F E8 ?? ?? ?? ?? 83 38 0D 74 05 83 CE FF EB 20 E8 ?? ?? ?? ?? 89 38 56 8D 45 EC B9 ?? ?? ?? ?? 50 51 56 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 FF 75 E8 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_183_3_0 {
	meta:
		name = "??$common_system@_W@@YAHQB_W@Z"
		size = 256
		refs = "0009 ___security_cookie 001e ?comspec_name@?1???$common_system@_W@@YAHQB_W@Z@4QB_WB 0028 __wdupenv_s 004e __waccess_s 0066 ?slash_c@?1???$common_system@_W@@YAHQB_W@Z@4QB_WB 0075 __errno 008c __wspawnve 00c5 ?cmd_exe@?1???$common_system@_W@@YAHQB_W@Z@4QB_WB 00d0 __wspawnvpe 00dd __free_base 00ed @__security_check_cookie@4 00fb __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 8D 45 E8 33 F6 68 ?? ?? ?? ?? 56 50 89 75 E8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 B9 00 00 00 85 FF 75 1D 39 75 E8 0F 84 90 00 00 00 56 FF 75 E8 E8 ?? ?? ?? ?? 8B F0 F7 DE 59 1B F6 59 46 EB 7C 8B 45 E8 89 45 EC C7 45 F0 ?? ?? ?? ?? 89 7D F4 89 75 F8 85 C0 74 4C E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 56 89 30 8D 45 EC 50 FF 75 EC 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E8 ?? ?? ?? ?? 83 FB FF 74 06 89 38 8B F3 EB 34 83 38 02 74 0F E8 ?? ?? ?? ?? 83 38 0D 74 05 83 CE FF EB 20 E8 ?? ?? ?? ?? 89 38 56 8D 45 EC B9 ?? ?? ?? ?? 50 51 56 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 FF 75 E8 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_183_4_0 {
	meta:
		name = "??$taccess_s@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z"
		size = 24
		refs = "0010 __access_s"
		altNames = "??$taccess_s@AAPADH@?$__crt_char_traits@D@@SAHAAPAD$$QAH@Z ??$taccess_s@AAPBDH@?$__crt_char_traits@D@@SAHAAPBD$$QAH@Z ??$taccess_s@ABQADH@?$__crt_char_traits@D@@SAHABQAD$$QAH@Z ??$taccess_s@ABQBDH@?$__crt_char_traits@D@@SAHABQBD$$QAH@Z ??$taccess_s@PBDH@?$__crt_char_traits@D@@SAH$$QAPBD$$QAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_333_8_3 {
	meta:
		name = "??$get_temp_path@KABQAD@?$__crt_char_traits@D@@SAK$$QAKABQAD@Z"
		size = 24
		refs = "0010 ___acrt_GetTempPathA"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_224_4_0 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@ABQBJ@?$__crt_integer_traits@J@@SAHABQAUtm@@ABQBJ@Z"
		size = 24
		refs = "0010 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_224_5_4 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@ABQB_J@?$__crt_integer_traits@_J@@SAHABQAUtm@@ABQB_J@Z"
		size = 24
		refs = "0010 __gmtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_224_6_0 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@PAJ@?$__crt_integer_traits@J@@SAHABQAUtm@@$$QAPAJ@Z"
		size = 24
		refs = "0010 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_224_7_4 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@PA_J@?$__crt_integer_traits@_J@@SAHABQAUtm@@$$QAPA_J@Z"
		size = 24
		refs = "0010 __gmtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_533_6_3 {
	meta:
		name = "??$gmtime_s@PAUtm@@PAJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@$$QAPAJ@Z"
		size = 24
		refs = "0010 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_533_7_3 {
	meta:
		name = "??$gmtime_s@PAUtm@@PA_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@$$QAPA_J@Z"
		size = 24
		refs = "0010 __gmtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_718_8_2 {
	meta:
		name = "??$localtime_s@PAUtm@@ABQBJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@ABQBJ@Z"
		size = 24
		refs = "0010 __localtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_718_9_2 {
	meta:
		name = "??$localtime_s@PAUtm@@ABQB_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@ABQB_J@Z"
		size = 24
		refs = "0010 __localtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_719_8_0 {
	meta:
		name = "??$localtime_s@PAUtm@@PAJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@$$QAPAJ@Z"
		size = 24
		refs = "0010 __localtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_533_9_2 {
	meta:
		name = "??$localtime_s@PAUtm@@PA_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@$$QAPA_J@Z"
		size = 24
		refs = "0010 __localtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_588_20_0 {
	meta:
		name = "??$set_variable_in_environment_nolock@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z"
		size = 24
		refs = "0010 ___dcrt_set_variable_in_narrow_environment_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_11_4 {
	meta:
		name = "??$set_variable_in_environment_nolock@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 24
		refs = "0010 ___dcrt_set_variable_in_wide_environment_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_723_5_3 {
	meta:
		name = "??$taccess_s@AAPA_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_281_14_0 {
	meta:
		name = "??$taccess_s@AAPB_WH@?$__crt_char_traits@_W@@SAHAAPB_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_333_15_3 {
	meta:
		name = "??$taccess_s@ABQA_WH@?$__crt_char_traits@_W@@SAHABQA_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_400_17_4 {
	meta:
		name = "??$taccess_s@ABQB_WH@?$__crt_char_traits@_W@@SAHABQB_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_183_5_3 {
	meta:
		name = "??$taccess_s@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_400_19_3 {
	meta:
		name = "??$taccess_s@PB_WH@?$__crt_char_traits@_W@@SAH$$QAPB_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_347_8_0 {
	meta:
		name = "??$tcsnlen@ABQADABI@?$__crt_char_traits@D@@SAIABQADABI@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_347_9_4 {
	meta:
		name = "??$tcsnlen@ABQA_WABI@?$__crt_char_traits@_W@@SAIABQA_WABI@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_729_109_4 {
	meta:
		name = "??$tcsnlen@ABQBDABI@?$__crt_char_traits@D@@SAIABQBDABI@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_22_4 {
	meta:
		name = "??$tcsnlen@ABQBDH@?$__crt_char_traits@D@@SAIABQBD$$QAH@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_729_110_3 {
	meta:
		name = "??$tcsnlen@ABQB_WABI@?$__crt_char_traits@_W@@SAIABQB_WABI@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_378_25_4 {
	meta:
		name = "??$tcsnlen@ABQB_WH@?$__crt_char_traits@_W@@SAIABQB_W$$QAH@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_24_3 {
	meta:
		name = "??$tcsnlen@PBDH@?$__crt_char_traits@D@@SAI$$QAPBD$$QAH@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_676_25_2 {
	meta:
		name = "??$tcsnlen@PB_WH@?$__crt_char_traits@_W@@SAI$$QAPB_W$$QAH@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_479_41_0 {
	meta:
		name = "??$tfdopen@AAHABQBD@?$__crt_char_traits@D@@SAPAU_iobuf@@AAHABQBD@Z"
		size = 24
		refs = "0010 __fdopen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_479_42_4 {
	meta:
		name = "??$tfdopen@AAHABQB_W@?$__crt_char_traits@_W@@SAPAU_iobuf@@AAHABQB_W@Z"
		size = 24
		refs = "0010 __wfdopen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_709_8_0 {
	meta:
		name = "??$tgetcwd@ABQADH@?$__crt_char_traits@D@@SAPADABQAD$$QAH@Z"
		size = 24
		refs = "0010 __getcwd"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_709_9_4 {
	meta:
		name = "??$tgetcwd@ABQA_WH@?$__crt_char_traits@_W@@SAPA_WABQA_W$$QAH@Z"
		size = 24
		refs = "0010 __wgetcwd"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_729_114_3 {
	meta:
		name = "??$ungettc_nolock@ABHPAU_iobuf@@@?$__crt_char_traits@D@@SAHABH$$QAPAU_iobuf@@@Z"
		size = 24
		refs = "0010 __ungetc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_183_8_0 {
	meta:
		name = "??$tspawnve@HAAPBDAAY03PBD$$T@?$__crt_char_traits@D@@SAH$$QAHAAPBDAAY03PBD$$QA$$T@Z"
		size = 33
		refs = "0018 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_183_9_0 {
	meta:
		name = "??$tspawnve@HAAPB_WAAY03PB_W$$T@?$__crt_char_traits@_W@@SAH$$QAHAAPB_WAAY03PB_W$$QA$$T@Z"
		size = 33
		refs = "0018 __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_183_10_0 {
	meta:
		name = "??$tspawnvpe@HAAPBDAAY03PBD$$T@?$__crt_char_traits@D@@SAH$$QAHAAPBDAAY03PBD$$QA$$T@Z"
		size = 33
		refs = "0018 __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_183_11_0 {
	meta:
		name = "??$tspawnvpe@HAAPB_WAAY03PB_W$$T@?$__crt_char_traits@_W@@SAH$$QAHAAPB_WAAY03PB_W$$QA$$T@Z"
		size = 33
		refs = "0018 __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_fetestexcept"
		size = 34
		refs = "0012 _fegetexceptflag"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 08 83 65 FC 00 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 83 E0 1F 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 A8 04 74 04 B0 01 5D C3 A8 01 74 1B 83 E0 02 74 09 81 7D 0C 00 00 00 80 77 EA 85 C0 75 09 81 7D 0C FF FF FF 7F 77 DD 32 C0 5D C3 }
	condition:
		$1
}

rule file_186_4_0 {
	meta:
		name = "??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		size = 552
		refs = "000e ?validate@?$c_string_character_source@D@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 0055 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 007d __ischartype_l 011c ?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z 01d3 ??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8D 4D 0C 53 57 E8 ?? ?? ?? ?? 84 C0 74 21 8B 7D 14 85 FF 74 30 83 FF 02 7C 05 83 FF 24 7E 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 DB 8B 55 10 85 D2 74 05 8B 4D 0C 89 0A 5F 8B C3 5B 8B E5 5D C3 56 FF 75 08 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 0C 33 F6 89 75 F4 89 45 E8 EB 03 8B 45 0C 8A 18 40 89 45 0C 8D 45 DC 50 0F B6 C3 6A 08 50 88 5D FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DE 38 45 18 0F 95 C0 89 45 F8 80 FB 2D 75 08 83 C8 02 89 45 F8 EB 05 80 FB 2B 75 0E 8B 75 0C 8A 1E 46 88 5D FC 89 75 0C EB 03 8B 75 0C 85 FF 74 05 83 FF 10 75 78 8A C3 2C 30 3C 09 77 08 0F BE C3 83 C0 D0 EB 23 8A C3 2C 61 3C 19 77 08 0F BE C3 83 C0 A9 EB 13 8A C3 2C 41 3C 19 77 08 0F BE C3 83 C0 C9 EB 03 83 C8 FF 85 C0 74 09 85 FF 75 3D 6A 0A 5F EB 38 8A 06 46 88 45 F0 89 75 0C 3C 78 74 1B 3C 58 74 17 85 FF 75 03 6A 08 5F FF 75 F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 75 0C EB 10 85 FF 75 03 6A 10 5F 8A 1E 46 88 5D FC 89 75 0C 33 D2 83 C8 FF F7 F7 89 55 EC 8B 55 F8 89 45 F0 8D 4B D0 80 F9 09 77 08 0F BE CB 83 C1 D0 EB 23 8A C3 2C 61 3C 19 77 08 0F BE CB 83 C1 A9 EB 13 8A C3 2C 41 3C 19 77 08 0F BE CB 83 C1 C9 EB 03 83 C9 FF 83 F9 FF 74 30 3B CF 73 2C 8B 45 F4 83 CA 08 8B 5D F0 3B C3 72 0C 75 05 3B 4D EC 76 05 83 CA 04 EB 08 0F AF C7 03 C1 89 45 F4 8A 1E 46 88 5D FC 89 75 0C EB 98 FF 75 FC 8D 4D 0C 89 55 F8 E8 ?? ?? ?? ?? 8B 5D F8 F6 C3 08 75 0A 8B 45 E8 33 DB 89 45 0C EB 41 8B 75 F4 56 53 E8 ?? ?? ?? ?? 59 59 84 C0 74 28 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 75 05 83 CE FF EB 1A F6 C3 02 74 07 BB 00 00 00 80 EB 10 BB FF FF FF 7F EB 09 F6 C3 02 74 02 F7 DE 8B DE 80 7D E4 00 5E 0F 84 20 FE FF FF 8B 45 D8 83 A0 50 03 00 00 FD E9 11 FE FF FF }
	condition:
		$1
}

rule file_186_5_0 {
	meta:
		name = "??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
		size = 1765
		refs = "000e ?validate@?$c_string_character_source@_W@__crt_strtox@@QBE_NXZ 002a __errno 0035 __invalid_parameter_noinfo 0057 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0077 _iswctype 0388 ?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z 0690 ??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8D 4D 0C 53 57 E8 ?? ?? ?? ?? 84 C0 74 23 8B 45 14 6A 02 5F 85 C0 74 2F 3B C7 7C 05 83 F8 24 7E 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 DB 8B 55 10 85 D2 74 05 8B 4D 0C 89 0A 5F 8B C3 5B 8B E5 5D C3 56 FF 75 08 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 0C 33 F6 89 75 F8 89 45 F4 EB 03 8B 45 0C 0F B7 30 03 C7 6A 08 56 89 45 0C E8 ?? ?? ?? ?? 59 59 85 C0 75 E7 33 DB 38 5D 18 0F 95 C3 66 83 FE 2D 75 04 0B DF EB 06 66 83 FE 2B 75 0E 8B 7D 0C 0F B7 37 83 C7 02 89 7D 0C EB 03 8B 7D 0C 8B 4D 14 C7 45 FC 19 00 00 00 6A 30 58 6A 10 5A 85 C9 74 08 3B CA 0F 85 DB 02 00 00 66 3B F0 0F 82 55 02 00 00 6A 3A 58 66 3B F0 73 0B 0F B7 C6 83 E8 30 E9 3D 02 00 00 B8 10 FF 00 00 66 3B F0 0F 83 18 02 00 00 B8 60 06 00 00 66 3B F0 0F 82 26 02 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 60 06 00 00 E9 0C 02 00 00 B8 F0 06 00 00 66 3B F0 0F 82 03 02 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D F0 06 00 00 E9 E9 01 00 00 B8 66 09 00 00 66 3B F0 0F 82 E0 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 09 00 00 E9 C6 01 00 00 B8 E6 09 00 00 66 3B F0 0F 82 BD 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 09 00 00 E9 A3 01 00 00 B8 66 0A 00 00 66 3B F0 0F 82 9A 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0A 00 00 E9 80 01 00 00 B8 E6 0A 00 00 66 3B F0 0F 82 77 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 0A 00 00 E9 5D 01 00 00 B8 66 0B 00 00 66 3B F0 0F 82 54 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0B 00 00 E9 3A 01 00 00 B8 66 0C 00 00 66 3B F0 0F 82 31 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0C 00 00 E9 17 01 00 00 B8 E6 0C 00 00 66 3B F0 0F 82 0E 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 0C 00 00 E9 F4 00 00 00 B8 66 0D 00 00 66 3B F0 0F 82 EB 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0D 00 00 E9 D1 00 00 00 B8 50 0E 00 00 66 3B F0 0F 82 C8 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 50 0E 00 00 E9 AE 00 00 00 B8 D0 0E 00 00 66 3B F0 0F 82 A5 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D D0 0E 00 00 E9 8B 00 00 00 B8 20 0F 00 00 66 3B F0 0F 82 82 00 00 00 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D 20 0F 00 00 EB 6B B8 40 10 00 00 66 3B F0 72 66 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D 40 10 00 00 EB 4F B8 E0 17 00 00 66 3B F0 72 4A 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B F0 72 2E 83 C0 0A 66 3B F0 73 26 0F B7 C6 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 3B F0 73 0A 0F B7 C6 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 30 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 09 8D 46 9F 66 3B 45 FC 77 14 8D 46 9F 66 3B 45 FC 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 85 C0 74 0D 85 C9 75 45 C7 45 14 0A 00 00 00 EB 3C 0F B7 07 83 C7 02 89 7D 0C 83 F8 78 74 1E 83 F8 58 74 19 85 C9 75 07 C7 45 14 08 00 00 00 50 8D 4D 0C E8 ?? ?? ?? ?? 8B 7D 0C EB 10 85 C9 75 03 89 55 14 0F B7 37 83 C7 02 89 7D 0C 83 C8 FF 33 D2 F7 75 14 8B C8 6A 30 58 66 3B F0 0F 82 55 02 00 00 6A 3A 58 66 3B F0 73 0B 0F B7 C6 83 E8 30 E9 3D 02 00 00 B8 10 FF 00 00 66 3B F0 0F 83 18 02 00 00 B8 60 06 00 00 66 3B F0 0F 82 26 02 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 60 06 00 00 E9 0C 02 00 00 B8 F0 06 00 00 66 3B F0 0F 82 03 02 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D F0 06 00 00 E9 E9 01 00 00 B8 66 09 00 00 66 3B F0 0F 82 E0 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 09 00 00 E9 C6 01 00 00 B8 E6 09 00 00 66 3B F0 0F 82 BD 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 09 00 00 E9 A3 01 00 00 B8 66 0A 00 00 66 3B F0 0F 82 9A 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0A 00 00 E9 80 01 00 00 B8 E6 0A 00 00 66 3B F0 0F 82 77 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 0A 00 00 E9 5D 01 00 00 B8 66 0B 00 00 66 3B F0 0F 82 54 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0B 00 00 E9 3A 01 00 00 B8 66 0C 00 00 66 3B F0 0F 82 31 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0C 00 00 E9 17 01 00 00 B8 E6 0C 00 00 66 3B F0 0F 82 0E 01 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D E6 0C 00 00 E9 F4 00 00 00 B8 66 0D 00 00 66 3B F0 0F 82 EB 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 66 0D 00 00 E9 D1 00 00 00 B8 50 0E 00 00 66 3B F0 0F 82 C8 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D 50 0E 00 00 E9 AE 00 00 00 B8 D0 0E 00 00 66 3B F0 0F 82 A5 00 00 00 83 C0 0A 66 3B F0 73 0D 0F B7 C6 2D D0 0E 00 00 E9 8B 00 00 00 B8 20 0F 00 00 66 3B F0 0F 82 82 00 00 00 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D 20 0F 00 00 EB 6B B8 40 10 00 00 66 3B F0 72 66 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D 40 10 00 00 EB 4F B8 E0 17 00 00 66 3B F0 72 4A 83 C0 0A 66 3B F0 73 0A 0F B7 C6 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B F0 72 2E 83 C0 0A 66 3B F0 73 26 0F B7 C6 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 3B F0 73 0A 0F B7 C6 2D 10 FF 00 00 EB 03 83 C8 FF 83 F8 FF 75 30 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 09 8D 46 9F 66 3B 45 FC 77 14 8D 46 9F 66 3B 45 FC 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB 03 83 C8 FF 83 F8 FF 74 31 3B 45 14 73 2C 8B 75 F8 83 CB 08 3B F1 72 0B 75 04 3B C2 76 05 83 CB 04 EB 09 0F AF 75 14 03 F0 89 75 F8 0F B7 37 83 C7 02 89 7D 0C E9 39 FD FF FF 56 8D 4D 0C E8 ?? ?? ?? ?? F6 C3 08 75 0A 8B 45 F4 33 DB 89 45 0C EB 41 8B 75 F8 56 53 E8 ?? ?? ?? ?? 59 59 84 C0 74 28 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 75 05 83 CE FF EB 1A F6 C3 02 74 07 BB 00 00 00 80 EB 10 BB FF FF FF 7F EB 09 F6 C3 02 74 02 F7 DE 8B DE 80 7D F0 00 5E 0F 84 65 F9 FF FF 8B 45 E4 83 A0 50 03 00 00 FD E9 56 F9 FF FF }
	condition:
		$1
}

rule file_186_6_0 {
	meta:
		name = "??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		size = 680
		refs = "000e ?validate@?$c_string_character_source@D@__crt_strtox@@QBE_NXZ 0028 __errno 0033 __invalid_parameter_noinfo 005b ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0088 __ischartype_l 013a ?unget@?$c_string_character_source@D@__crt_strtox@@QAEXD@Z 016e __aulldvrm 0203 __allmul 0244 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 4D 0C 56 57 E8 ?? ?? ?? ?? 84 C0 74 21 8B 45 14 85 C0 74 36 83 F8 02 7C 05 83 F8 24 7E 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B F8 8B F0 8B 45 10 85 C0 74 05 8B 4D 0C 89 08 8B C7 8B D6 5F 5E 8B E5 5D C3 53 FF 75 08 8D 4D C0 E8 ?? ?? ?? ?? 33 C0 89 45 F0 8B F0 8B 45 0C 89 45 D0 EB 03 8B 45 0C 8A 18 40 89 45 0C 8D 45 C4 50 0F B6 C3 6A 08 50 88 5D F4 88 5D FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 DB 38 45 18 0F 95 C0 89 45 F8 80 FB 2D 75 08 83 C8 02 89 45 F8 EB 05 80 FB 2B 75 11 8B 7D 0C 8A 1F 47 88 5D FF 88 5D F4 89 7D 0C EB 03 8B 7D 0C 8B 4D 14 6A 10 5A 85 C9 74 08 3B CA 0F 85 87 00 00 00 8A C3 2C 30 3C 09 77 08 0F BE C3 83 C0 D0 EB 23 8A C3 2C 61 3C 19 77 08 0F BE C3 83 C0 A9 EB 13 8A C3 2C 41 3C 19 77 08 0F BE C3 83 C0 C9 EB 03 83 C8 FF 85 C0 74 0C 85 C9 75 4C 6A 0A 58 89 45 14 EB 46 8A 07 47 88 45 E4 89 7D 0C 3C 78 74 22 3C 58 74 1E 85 C9 75 07 C7 45 14 08 00 00 00 FF 75 E4 8D 4D 0C E8 ?? ?? ?? ?? 8B 7D 0C 8B 45 14 EB 17 85 C9 75 03 89 55 14 8A 07 47 88 45 FF 88 45 F4 89 7D 0C EB E6 8B C1 99 53 8B CA 89 45 D4 51 50 6A FF 6A FF 89 4D D8 E8 ?? ?? ?? ?? 89 5D E0 5B 89 4D DC 33 DB 8A 4D FF 89 45 E8 89 55 E4 8A C1 2C 30 3C 09 77 08 0F BE D1 83 C2 D0 EB 23 8A C1 2C 61 3C 19 77 08 0F BE D1 83 C2 A9 EB 13 8A C1 2C 41 3C 19 77 08 0F BE D1 83 C2 C9 EB 03 83 CA FF 89 55 EC 83 FA FF 74 60 3B 55 14 73 5B 8B 4D F8 8B 45 F0 83 C9 08 89 4D F8 3B 75 E4 72 25 77 05 3B 45 E8 72 1E 3B 45 E8 75 11 3B 75 E4 75 0C 3B 5D E0 72 0F 77 05 3B 55 DC 76 08 83 C9 04 89 4D F8 EB 17 56 50 FF 75 D8 FF 75 D4 E8 ?? ?? ?? ?? 03 45 EC 8B F2 89 45 F0 13 F3 8A 0F 47 88 4D F4 89 7D 0C E9 65 FF FF FF FF 75 F4 8D 4D 0C E8 ?? ?? ?? ?? 8B 45 F8 A8 08 75 0C 8B 45 D0 89 45 0C 33 C0 8B F0 EB 41 8B 7D F0 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 F8 A8 01 75 08 83 CF FF 83 CE FF EB 25 A8 02 74 09 33 C0 BE 00 00 00 80 EB 08 83 C8 FF BE FF FF FF 7F 8B F8 EB 0C F6 45 F8 02 74 06 F7 DF 13 F3 F7 DE 80 7D CC 00 5B 0F 84 A4 FD FF FF 8B 45 C0 83 A0 50 03 00 00 FD E9 95 FD FF FF }
	condition:
		$1
}

rule file_186_7_0 {
	meta:
		name = "??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
		size = 1527
		refs = "000f ?validate@?$c_string_character_source@_W@__crt_strtox@@QBE_NXZ 002b __errno 0036 __invalid_parameter_noinfo 005e ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0081 _iswctype 02d8 ?unget@?$c_string_character_source@_W@__crt_strtox@@QAEX_W@Z 0303 __aulldvrm 0549 __allmul 0593 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8D 4D 0C 53 56 57 E8 ?? ?? ?? ?? 84 C0 74 23 8B 5D 14 6A 02 5F 85 DB 74 36 3B DF 7C 05 83 FB 24 7E 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B F8 8B D8 8B 75 10 85 F6 74 05 8B 4D 0C 89 0E 8B C7 8B D3 5F 5E 5B 8B E5 5D C3 FF 75 08 8D 4D C8 E8 ?? ?? ?? ?? 33 C0 89 45 F8 89 45 F4 8B 45 0C 89 45 D8 EB 03 8B 45 0C 0F B7 30 03 C7 6A 08 56 89 45 0C E8 ?? ?? ?? ?? 59 59 85 C0 75 E7 33 C0 38 45 18 0F 95 C0 89 45 FC 66 83 FE 2D 75 07 0B C7 89 45 FC EB 06 66 83 FE 2B 75 0D 8B 4D 0C 0F B7 31 03 CF 89 4D 0C EB 03 8B 4D 0C 6A 30 5A 85 DB 74 09 83 FB 10 0F 85 27 02 00 00 66 3B F2 0F 82 A1 01 00 00 6A 3A 58 66 3B F0 73 0A 0F B7 C6 2B C2 E9 8A 01 00 00 BA 10 FF 00 00 66 3B F2 0F 83 6B 01 00 00 BA 60 06 00 00 66 3B F2 0F 82 73 01 00 00 8D 42 0A 66 3B F0 72 D2 BA F0 06 00 00 66 3B F2 0F 82 5D 01 00 00 8D 42 0A 66 3B F0 72 BC BA 66 09 00 00 66 3B F2 0F 82 47 01 00 00 8D 42 0A 66 3B F0 72 A6 8D 50 76 66 3B F2 0F 82 33 01 00 00 8D 42 0A 66 3B F0 72 92 8D 50 76 66 3B F2 0F 82 1F 01 00 00 8D 42 0A 66 3B F0 0F 82 7A FF FF FF 8D 50 76 66 3B F2 0F 82 07 01 00 00 8D 42 0A 66 3B F0 0F 82 62 FF FF FF 8D 50 76 66 3B F2 0F 82 EF 00 00 00 8D 42 0A 66 3B F0 0F 82 4A FF FF FF BA 66 0C 00 00 66 3B F2 0F 82 D5 00 00 00 8D 42 0A 66 3B F0 0F 82 30 FF FF FF 8D 50 76 66 3B F2 0F 82 BD 00 00 00 8D 42 0A 66 3B F0 0F 82 18 FF FF FF 8D 50 76 66 3B F2 0F 82 A5 00 00 00 8D 42 0A 66 3B F0 0F 82 00 FF FF FF BA 50 0E 00 00 66 3B F2 0F 82 8B 00 00 00 8D 42 0A 66 3B F0 0F 82 E6 FE FF FF 8D 50 76 66 3B F2 72 77 8D 42 0A 66 3B F0 0F 82 D2 FE FF FF 83 C2 50 66 3B F2 72 63 83 C0 50 66 3B F0 0F 82 BE FE FF FF BA 40 10 00 00 66 3B F2 72 4D 8D 42 0A 66 3B F0 0F 82 A8 FE FF FF BA E0 17 00 00 66 3B F2 72 37 8D 42 0A 66 3B F0 0F 82 92 FE FF FF 83 C2 30 66 3B F2 72 23 83 C0 30 66 3B F0 73 1B E9 7D FE FF FF B8 1A FF 00 00 66 3B F0 0F 82 6F FE FF FF 83 C8 FF 83 F8 FF 75 1E 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 1E 6A 19 8D 46 9F 5A 66 3B C2 76 16 83 C8 FF 85 C0 74 22 85 DB 75 57 6A 0A 5B 89 5D 14 EB 4F 6A 19 5A 8D 46 9F 66 3B C2 0F B7 C6 77 03 83 E8 20 83 C0 C9 EB DA 0F B7 01 03 CF 89 4D 0C 83 F8 78 74 1A 83 F8 58 74 15 85 DB 75 06 6A 08 5B 89 5D 14 50 8D 4D 0C E8 ?? ?? ?? ?? EB 12 85 DB 75 06 6A 10 5B 89 5D 14 0F B7 31 03 CF 89 4D 0C 8B C3 99 53 8B CA 89 45 DC 51 50 6A FF 6A FF 89 4D E0 E8 ?? ?? ?? ?? 89 5D E8 5B 89 4D E4 33 DB 8B CA 89 45 F0 89 4D EC 6A 30 58 66 3B F0 0F 82 A1 01 00 00 6A 3A 5A 66 3B F2 73 0A 0F B7 FE 2B F8 E9 8A 01 00 00 B8 10 FF 00 00 66 3B F0 0F 83 6B 01 00 00 B8 60 06 00 00 66 3B F0 0F 82 73 01 00 00 8D 50 0A 66 3B F2 72 D2 B8 F0 06 00 00 66 3B F0 0F 82 5D 01 00 00 8D 50 0A 66 3B F2 72 BC B8 66 09 00 00 66 3B F0 0F 82 47 01 00 00 8D 50 0A 66 3B F2 72 A6 8D 42 76 66 3B F0 0F 82 33 01 00 00 8D 50 0A 66 3B F2 72 92 8D 42 76 66 3B F0 0F 82 1F 01 00 00 8D 50 0A 66 3B F2 0F 82 7A FF FF FF 8D 42 76 66 3B F0 0F 82 07 01 00 00 8D 50 0A 66 3B F2 0F 82 62 FF FF FF 8D 42 76 66 3B F0 0F 82 EF 00 00 00 8D 50 0A 66 3B F2 0F 82 4A FF FF FF B8 66 0C 00 00 66 3B F0 0F 82 D5 00 00 00 8D 50 0A 66 3B F2 0F 82 30 FF FF FF 8D 42 76 66 3B F0 0F 82 BD 00 00 00 8D 50 0A 66 3B F2 0F 82 18 FF FF FF 8D 42 76 66 3B F0 0F 82 A5 00 00 00 8D 50 0A 66 3B F2 0F 82 00 FF FF FF B8 50 0E 00 00 66 3B F0 0F 82 8B 00 00 00 8D 50 0A 66 3B F2 0F 82 E6 FE FF FF 8D 42 76 66 3B F0 72 77 8D 50 0A 66 3B F2 0F 82 D2 FE FF FF 83 C0 50 66 3B F0 72 63 83 C2 50 66 3B F2 0F 82 BE FE FF FF B8 40 10 00 00 66 3B F0 72 4D 8D 50 0A 66 3B F2 0F 82 A8 FE FF FF B8 E0 17 00 00 66 3B F0 72 37 8D 50 0A 66 3B F2 0F 82 92 FE FF FF 83 C0 30 66 3B F0 72 23 83 C2 30 66 3B F2 73 1B E9 7D FE FF FF BA 1A FF 00 00 66 3B F2 0F 82 6F FE FF FF 83 CF FF 83 FF FF 75 1E 6A 41 58 66 3B C6 77 08 6A 5A 58 66 3B F0 76 55 6A 19 8D 46 9F 5A 66 3B C2 76 4D 83 CF FF 83 FF FF 0F 84 83 00 00 00 3B 7D 14 73 7E 8B 55 FC 8B 45 F4 83 CA 08 3B C1 89 55 FC 8B 4D F8 72 3C 8B 75 F0 77 04 3B CE 72 33 3B CE 75 11 3B 45 EC 75 0C 3B 5D E8 72 25 77 05 3B 7D E4 76 1E 83 CA 04 89 55 FC EB 31 6A 19 5A 8D 46 9F 0F B7 FE 66 3B C2 77 03 83 EF 20 83 C7 C9 EB A3 50 51 FF 75 E0 FF 75 DC E8 ?? ?? ?? ?? 8B C8 8B C2 03 CF 89 4D F8 13 C3 89 45 F4 8B 45 0C 8B 4D EC 0F B7 30 83 C0 02 89 45 0C E9 A9 FD FF FF 56 8D 4D 0C E8 ?? ?? ?? ?? 8B 45 FC A8 08 75 0A 8B 45 D8 89 45 0C 33 C0 EB 44 8B 5D F4 8B 7D F8 53 57 50 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 74 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 FC A8 01 75 08 83 CF FF 83 CB FF EB 26 A8 02 74 09 33 C0 BB 00 00 00 80 EB 08 83 C8 FF BB FF FF FF 7F 8B F8 EB 0D F6 45 FC 02 74 07 F7 DF 83 D3 00 F7 DB 80 7D D4 00 0F 84 58 FA FF FF 8B 45 C8 83 A0 50 03 00 00 FD E9 49 FA FF FF }
	condition:
		$1
}

rule file_186_8_0 {
	meta:
		name = "??$parse_integer_from_string@JD$$T@__crt_strtox@@YAJQBD$$THQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0022 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_8_0 {
	meta:
		name = "??$parse_integer_from_string@JDPAPAD@__crt_strtox@@YAJQBDQAPADHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_9_0 {
	meta:
		name = "??$parse_integer_from_string@J_W$$T@__crt_strtox@@YAJQB_W$$THQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0022 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_9_4 {
	meta:
		name = "??$parse_integer_from_string@J_WPAPA_W@__crt_strtox@@YAJQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_10_0 {
	meta:
		name = "??$parse_integer_from_string@_JD$$T@__crt_strtox@@YA_JQBD$$THQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_12_3 {
	meta:
		name = "??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_11_0 {
	meta:
		name = "??$parse_integer_from_string@_J_W$$T@__crt_strtox@@YA_JQB_W$$THQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_13_4 {
	meta:
		name = "??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_47_2 {
	meta:
		name = "__strtoi64_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_48_3 {
	meta:
		name = "__strtoimax_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_49_0 {
	meta:
		name = "__strtol_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_50_3 {
	meta:
		name = "__strtoll_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_57_3 {
	meta:
		name = "__wcstoi64_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_58_4 {
	meta:
		name = "__wcstoimax_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_59_2 {
	meta:
		name = "__wcstol_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_60_2 {
	meta:
		name = "__wcstoll_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_40_0 {
	meta:
		name = "__atoi64"
		size = 42
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 001f ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "_atoll"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_47_0 {
	meta:
		name = "__wtoi"
		size = 42
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 001f ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_48_0 {
	meta:
		name = "__wtoi64"
		size = 42
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 001f ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_51_2 {
	meta:
		name = "__wtol"
		size = 42
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 001f ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_53_3 {
	meta:
		name = "__wtoll"
		size = 42
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 001f ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_55_0 {
	meta:
		name = "_atoi"
		size = 42
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 001f ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_56_3 {
	meta:
		name = "_atol"
		size = 42
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 001f ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_41_0 {
	meta:
		name = "__atoi64_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0020 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "__atoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_42_0 {
	meta:
		name = "__atoi_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0020 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_43_0 {
	meta:
		name = "__atol_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0020 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_49_2 {
	meta:
		name = "__wtoi64_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0020 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_50_3 {
	meta:
		name = "__wtoi_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0020 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_52_0 {
	meta:
		name = "__wtol_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0020 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_54_3 {
	meta:
		name = "__wtoll_l"
		size = 43
		refs = "0015 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z 0020 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 6A 0A 51 51 8B C4 6A 00 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_4_0 {
	meta:
		name = "??$common_set_variable_in_environment_nolock@D@@YAHQADH@Z"
		size = 583
		refs = "0011 __errno 002b _strchr 004d ??$ensure_current_environment_is_not_initial_environment_nolock@D@@YAXXZ 0055 __environ_table 0062 __wenviron_table 0069 ___dcrt_get_or_create_narrow_environment_nolock 008d __calloc_base 0098 __free_base 00ee ??$find_in_environment_nolock@D@@YAHQBDI@Z 012a __recalloc_base 01d6 _strcpy_s 01ff __imp__SetEnvironmentVariableA@8 0242 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B 75 08 85 F6 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 14 02 00 00 53 57 6A 3D 56 8B FE E8 ?? ?? ?? ?? 89 45 F0 59 59 85 C0 0F 84 E2 01 00 00 3B C6 0F 84 DA 01 00 00 80 78 01 00 0F 94 45 FF E8 ?? ?? ?? ?? 33 DB 39 1D ?? ?? ?? ?? 75 7B 39 5D 0C 74 1C 39 1D ?? ?? ?? ?? 74 14 E8 ?? ?? ?? ?? 85 C0 0F 84 A9 01 00 00 E8 ?? ?? ?? ?? EB 5A 38 5D FF 74 07 33 DB E9 A4 01 00 00 6A 04 6A 01 E8 ?? ?? ?? ?? 53 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 39 1D ?? ?? ?? ?? 0F 84 7E 01 00 00 39 1D ?? ?? ?? ?? 75 23 6A 04 6A 01 E8 ?? ?? ?? ?? 53 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 39 1D ?? ?? ?? ?? 0F 84 53 01 00 00 A1 ?? ?? ?? ?? 89 45 F8 85 C0 0F 84 43 01 00 00 8B 45 F0 2B C6 50 56 E8 ?? ?? ?? ?? 89 45 F4 59 59 8B 4D F8 85 C0 78 4F 39 19 74 4B FF 34 81 E8 ?? ?? ?? ?? 59 8B 4D F4 38 5D FF 74 30 8B 55 F8 EB 08 8B 44 8A 04 89 04 8A 41 39 1C 8A 75 F3 6A 04 51 52 E8 ?? ?? ?? ?? 53 89 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 10 85 C0 74 62 EB 5B 8B 45 F8 8B FB 89 34 88 EB 56 38 5D FF 0F 85 D6 00 00 00 F7 D8 89 45 F4 8D 50 02 3B D0 0F 82 C3 00 00 00 81 FA FF FF FF 3F 0F 83 B7 00 00 00 6A 04 52 51 E8 ?? ?? ?? ?? 53 89 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 10 85 C0 0F 84 97 00 00 00 8B 4D F4 8B FB 89 34 88 89 5C 88 04 A3 ?? ?? ?? ?? 39 5D 0C 0F 84 80 00 00 00 8D 4E 01 8A 06 46 84 C0 75 F9 2B F1 6A 01 8D 46 02 50 89 45 F4 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 47 FF 75 08 FF 75 F4 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 5B 8B 4D F0 8B C6 2B 45 08 41 03 C8 0F B6 45 FF F7 D8 1B C0 F7 D0 88 59 FF 23 C1 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 0E E8 ?? ?? ?? ?? 83 CB FF C7 00 2A 00 00 00 56 E8 ?? ?? ?? ?? 59 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 CB FF 57 E8 ?? ?? ?? ?? 59 5F 8B C3 5B 5E 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_187_5_0 {
	meta:
		name = "??$common_set_variable_in_environment_nolock@_W@@YAHQA_WH@Z"
		size = 584
		refs = "0011 __errno 002b _wcschr 004f ??$ensure_current_environment_is_not_initial_environment_nolock@_W@@YAXXZ 0055 __wenviron_table 0062 __environ_table 0070 ___dcrt_get_or_create_wide_environment_nolock 0095 __calloc_base 00a0 __free_base 00f1 ??$find_in_environment_nolock@_W@@YAHQB_WI@Z 012f __recalloc_base 01d8 _wcscpy_s 0200 __imp__SetEnvironmentVariableW@8 0243 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 8B 5D 08 85 DB 75 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 15 02 00 00 56 57 6A 3D 53 8B FB E8 ?? ?? ?? ?? 89 45 F4 59 59 85 C0 0F 84 E3 01 00 00 3B C3 0F 84 DB 01 00 00 33 DB 66 39 58 02 0F 94 45 FF E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 0F 85 81 00 00 00 A1 ?? ?? ?? ?? 39 5D 0C 74 18 85 C0 74 14 E8 ?? ?? ?? ?? 85 C0 0F 84 A3 01 00 00 E8 ?? ?? ?? ?? EB 51 38 5D FF 0F 85 A1 01 00 00 85 C0 75 2D 6A 04 6A 01 E8 ?? ?? ?? ?? 53 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 39 1D ?? ?? ?? ?? 0F 84 77 01 00 00 8B 35 ?? ?? ?? ?? 85 F6 75 25 6A 04 6A 01 E8 ?? ?? ?? ?? 53 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 35 ?? ?? ?? ?? 85 F6 0F 84 48 01 00 00 8B 4D F4 8B C7 2B C8 D1 F9 51 50 89 4D F4 E8 ?? ?? ?? ?? 89 45 F8 59 59 85 C0 78 48 39 1E 74 44 FF 34 86 E8 ?? ?? ?? ?? 59 8B 4D F8 38 5D FF 75 12 8B 45 08 8B FB 89 04 8E EB 7F 8B 44 8E 04 89 04 8E 41 39 1C 8E 75 F3 6A 04 51 56 E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 8B C7 85 F6 74 58 EB 50 38 5D FF 0F 85 DE 00 00 00 F7 D8 89 45 F8 8D 48 02 3B C8 0F 82 CB 00 00 00 81 F9 FF FF FF 3F 0F 83 BF 00 00 00 6A 04 51 56 E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 F6 0F 84 A3 00 00 00 8B 4D F8 8B FB 8B 45 08 89 04 8E 89 5C 8E 04 89 35 ?? ?? ?? ?? 39 5D 0C 0F 84 88 00 00 00 8B C8 8D 51 02 66 8B 01 83 C1 02 66 3B C3 75 F5 2B CA D1 F9 6A 02 8D 41 02 50 89 45 F8 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 47 8B 45 08 50 FF 75 F8 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 5A 8B 45 F4 40 8D 0C 46 33 C0 66 89 41 FE 0F B6 45 FF F7 D8 1B C0 F7 D0 23 C1 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 0E E8 ?? ?? ?? ?? 83 CB FF C7 00 2A 00 00 00 56 E8 ?? ?? ?? ?? 59 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 CB FF 57 E8 ?? ?? ?? ?? 59 5F 8B C3 5E 5B 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_187_6_0 {
	meta:
		name = "??$copy_environment@D@@YAPAPADQAPAD@Z"
		size = 177
		refs = "002e __calloc_base 0066 __free_base 007c _strcpy_s 00a0 _abort 00ac __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 57 8B 7D 08 85 FF 75 07 33 C0 E9 85 00 00 00 33 C9 8B C7 39 0F 74 09 8D 40 04 41 83 38 00 75 F7 56 8D 41 01 6A 04 50 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 65 83 3F 00 74 50 53 8B DE 2B DF 8B 0F 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 6A 01 8D 41 01 50 89 45 FC E8 ?? ?? ?? ?? 6A 00 89 04 3B E8 ?? ?? ?? ?? 83 C4 0C 83 3C 3B 00 74 2C FF 37 FF 75 FC FF 34 3B E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1D 83 C7 04 39 07 75 B6 5B 6A 00 E8 ?? ?? ?? ?? 59 8B C6 5E 5F 8B E5 5D C3 E8 ?? ?? ?? ?? 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_187_7_0 {
	meta:
		name = "??$copy_environment@_W@@YAPAPA_WQAPA_W@Z"
		size = 190
		refs = "0034 __calloc_base 0072 __free_base 0088 _wcscpy_s 00ad _abort 00b9 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 57 8B 7D 08 85 FF 75 07 33 C0 E9 91 00 00 00 53 33 DB 8B C7 8B CB 89 5D FC 56 39 1F 74 08 8D 40 04 41 39 18 75 F8 8D 41 01 6A 04 50 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 6C 39 1F 74 58 8B DE 2B DF 8B 0F 8D 51 02 66 8B 01 83 C1 02 66 3B 45 FC 75 F4 2B CA D1 F9 6A 02 8D 41 01 50 89 45 F8 E8 ?? ?? ?? ?? 89 04 3B 33 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 3C 3B 00 74 2D FF 37 FF 75 F8 FF 34 3B E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1E 83 C7 04 39 07 75 AE 33 DB 53 E8 ?? ?? ?? ?? 59 8B C6 5E 5B 5F 8B E5 5D C3 E8 ?? ?? ?? ?? 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_187_8_0 {
	meta:
		name = "??$ensure_current_environment_is_not_initial_environment_nolock@D@@YAXXZ"
		size = 26
		refs = "0001 __environ_table 0007 ___dcrt_initial_narrow_environment 000f ??$copy_environment@D@@YAPAPADQAPAD@Z"
	strings:
		$1 = { A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 0C 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_187_9_0 {
	meta:
		name = "??$ensure_current_environment_is_not_initial_environment_nolock@_W@@YAXXZ"
		size = 26
		refs = "0001 __wenviron_table 0007 ___dcrt_initial_wide_environment 000f ??$copy_environment@_W@@YAPAPA_WQAPA_W@Z"
	strings:
		$1 = { A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 0C 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_187_10_0 {
	meta:
		name = "??$find_in_environment_nolock@D@@YAHQBDI@Z"
		size = 84
		refs = "000a __environ_table 001f __strnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 3D ?? ?? ?? ?? 8B F7 83 3F 00 74 2A 8B 5D 0C 53 FF 36 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 06 8A 04 03 3C 3D 74 1A 84 C0 74 16 83 C6 04 83 3E 00 75 D9 2B F7 C1 FE 02 F7 DE 5F 8B C6 5E 5B 5D C3 2B F7 C1 FE 02 EB F2 }
	condition:
		$1
}

rule file_187_11_0 {
	meta:
		name = "??$find_in_environment_nolock@_W@@YAHQB_WI@Z"
		size = 87
		refs = "000a __wenviron_table 001f __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 3D ?? ?? ?? ?? 8B F7 83 3F 00 74 2D 8B 5D 0C 53 FF 36 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 10 8B 06 0F B7 04 58 83 F8 3D 74 1B 66 85 C0 74 16 83 C6 04 83 3E 00 75 D6 2B F7 C1 FE 02 F7 DE 5F 8B C6 5E 5B 5D C3 2B F7 C1 FE 02 EB F2 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__cabs"
		size = 33
		refs = "0018 __hypothlp"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 6A 11 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "__hypot"
		size = 33
		refs = "0018 __hypothlp"
		altNames = "_hypot"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 6A 18 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_188_2_0 {
	meta:
		name = "__hypothlp"
		size = 644
		refs = "0017 __ctrlfp 00b8 __CIsqrt 00c2 __decomp 00ea __get_exp 010c __set_exp 01e1 __d_inf 0240 __except2 0276 __handle_qnan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 53 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 66 8B 55 0E BF F0 7F 00 00 59 59 0F B7 CA 8B D8 23 CF 66 3B CF 66 8B 4D 16 0F 84 79 01 00 00 0F B7 C1 23 C7 66 3B C7 0F 84 6B 01 00 00 D9 EE DD 45 08 D8 D1 DF E0 F6 C4 05 7A 02 D9 E0 DD 45 10 D8 D2 DF E0 F6 C4 05 7A 02 D9 E0 D8 D1 DF E0 F6 C4 41 75 04 D9 C0 EB 02 D9 C1 DD 55 F8 DD E3 DF E0 DD DB F6 C4 44 7A 16 DD D9 56 DD D8 53 DD D8 E8 ?? ?? ?? ?? D9 EE 59 59 E9 E4 01 00 00 D9 C9 8D 45 F0 D8 F2 50 DD 55 E0 D9 C9 DE F2 D9 C9 DD 55 E8 D9 C1 DE CA D9 C0 DE C9 DE C1 E8 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 F4 DD 5D D8 DD 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D D8 83 C4 04 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? 03 45 F4 03 45 F0 DD 45 F8 59 59 3D 00 04 00 00 7E 32 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 E8 DD 5C 24 08 DD 45 E0 DD 1C 24 FF 75 18 6A 11 E9 0D 01 00 00 3D 03 FC FF FF 7D 32 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 E8 DD 5C 24 08 DD 45 E0 DD 1C 24 FF 75 18 6A 12 E9 D4 00 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 55 D8 F6 C3 20 74 13 56 53 DD D8 E8 ?? ?? ?? ?? DD 45 D8 59 59 E9 E9 00 00 00 53 83 EC 18 DD 5C 24 10 DD 45 E8 DD 5C 24 08 DD 45 E0 DD 1C 24 FF 75 18 6A 10 E9 8C 00 00 00 8B 45 0C 8B 75 08 25 FF FF FF 7F 3D 00 00 F0 7F 75 04 85 F6 74 16 8B 45 14 25 FF FF FF 7F 3D 00 00 F0 7F 8B 45 10 75 0F 85 C0 75 0B DD 05 ?? ?? ?? ?? E9 93 00 00 00 C7 45 FC F8 7F 00 00 66 23 55 FC 66 3B D7 75 0D F7 45 0C FF FF 07 00 75 1C 85 F6 75 18 8B 75 FC 66 23 CE 66 3B CF 75 37 F7 45 14 FF FF 07 00 75 04 85 C0 74 2A DD 45 08 D9 C0 DD 45 10 53 DC C1 83 EC 18 D9 C9 DD 5C 24 10 DD 5C 24 08 DD 1C 24 FF 75 18 6A 08 E8 ?? ?? ?? ?? 83 C4 24 EB 34 66 3B D6 74 17 66 3B CE 74 12 68 FF FF 00 00 53 E8 ?? ?? ?? ?? 59 59 E9 7A FF FF FF DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_initialize_global_variables"
		size = 18
		refs = "0001 ___acrt_initial_locale_data 0006 ___acrt_current_locale_data 000b ?initialize@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEXQAU__crt_locale_data@@@Z"
	strings:
		$1 = { 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? B0 01 C3 }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "_initialize_c"
		size = 26
		refs = "0001 ___acrt_atexit_table 0006 __initialize_onexit_table 000d ___acrt_at_quick_exit_table"
	strings:
		$1 = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 B0 01 C3 }
	condition:
		$1
}

rule file_189_7_0 {
	meta:
		name = "_initialize_pointers"
		size = 61
		refs = "0001 ___security_cookie 001a ___acrt_initialize_invalid_parameter_handler 0020 ___acrt_initialize_new_handler 0026 ___acrt_initialize_signal_handlers 002c ___acrt_initialize_user_matherr 0032 ___acrt_initialize_thread_local_exit_callback"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 6A 20 83 E0 1F 33 F6 59 2B C8 D3 CE 33 35 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 B0 01 5E C3 }
	condition:
		$1
}

rule file_189_9_0 {
	meta:
		name = "_uninitialize_allocated_memory"
		size = 100
		refs = "0008 ___acrt_current_multibyte_data 0010 ??R<lambda_af42a3ee9806e9a7305d451646e05244>@@QBEXAAPAU__crt_multibyte_data@@@Z 0016 ___acrt_stdout_buffer 001b __free_base 0021 ___acrt_stderr_buffer 0034 ___argv 0045 ___wargv"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 68 ?? ?? ?? ?? 8D 4D FF E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 33 F6 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 89 35 ?? ?? ?? ?? B0 01 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_189_22_0 {
	meta:
		name = "___acrt_uninitialize_critical"
		size = 18
		refs = "0009 ___acrt_uninitialize_ptd"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 B0 01 5D C3 }
	condition:
		$1
}

rule file_479_70_0 {
	meta:
		name = "?close@stream_traits@?A0xe43b7539@@SA_NPAU_iobuf@@@Z"
		size = 18
		refs = "0009 _fclose"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 B0 01 5D C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__getsystime"
		size = 140
		refs = "0009 ___security_cookie 001b __errno 0026 __invalid_parameter_noinfo 0034 __imp__GetLocalTime@4 0074 __mktime32 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 4F 8D 45 EC 50 FF 15 ?? ?? ?? ?? 0F B7 45 F8 83 4E 20 FF 89 06 0F B7 45 F6 89 46 04 0F B7 45 F4 89 46 08 0F B7 45 F2 89 46 0C 0F B7 45 EE 48 89 46 10 0F B7 45 EC 2D 6C 07 00 00 89 46 14 0F B7 45 F0 56 89 46 18 E8 ?? ?? ?? ?? 0F B7 45 FA 59 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_1_0 {
	meta:
		name = "__setsystime"
		size = 139
		refs = "0009 ___security_cookie 0021 __mktime32 006a __imp__SetLocalTime@4 0074 __imp__GetLastError@0 0083 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 75 05 6A 57 58 EB 5D 56 E8 ?? ?? ?? ?? B8 6C 07 00 00 66 03 46 14 66 89 45 EC 66 8B 46 10 66 40 66 89 45 EE 66 8B 46 0C 66 89 45 F2 66 8B 46 08 66 89 45 F4 66 8B 46 04 66 89 45 F6 66 8B 06 66 89 45 F8 66 8B 45 0C 66 89 45 FA 8D 45 EC 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_191_5_0 {
	meta:
		name = "__set_new_mode"
		size = 47
		refs = "0012 __errno 001d __invalid_parameter_noinfo 0027 ?__acrt_global_new_mode@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 1A 83 F8 01 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 B9 ?? ?? ?? ?? 87 01 5D C3 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__d_inttype"
		size = 106
		refs = "0010 __fpclass 0023 __frnd 0039 __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 A8 90 75 4A DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 DD E1 DF E0 59 59 DD D9 F6 C4 44 7A 2B DC 0D ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F8 DA E9 DF E0 59 59 F6 C4 44 7A 05 6A 02 58 EB 09 33 C0 40 EB 04 DD D8 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "__powhlp"
		size = 299
		refs = "0030 __d_inf 00dd __d_inttype 0118 __d_mzero"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 08 B9 00 00 F0 7F D9 E1 B8 00 00 F0 FF 39 4D 14 75 3B 83 7D 10 00 75 75 D9 E8 D8 D1 DF E0 F6 C4 05 7A 0F DD D9 DD D8 DD 05 ?? ?? ?? ?? E9 E9 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 0F 85 DA 00 00 00 DD D8 D9 EE E9 D1 00 00 00 39 45 14 75 3B 83 7D 10 00 75 35 D9 E8 D8 D1 DF E0 F6 C4 05 7A 0B DD D9 DD D8 D9 EE E9 AD 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 0F 85 9E 00 00 00 DD D8 DD 05 ?? ?? ?? ?? E9 91 00 00 00 DD D8 39 4D 0C 75 2E 83 7D 08 00 0F 85 82 00 00 00 D9 EE DD 45 10 D8 D1 DF E0 F6 C4 41 0F 84 73 FF FF FF D8 D9 DF E0 F6 C4 05 8B 45 18 7B 62 DD D8 D9 E8 EB 5C 39 45 0C 75 59 83 7D 08 00 75 53 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 EE DD 45 10 59 59 D8 D1 8B C8 DF E0 F6 C4 41 75 13 DD D9 DD D8 DD 05 ?? ?? ?? ?? 83 F9 01 75 20 D9 E0 EB 1C D8 D9 DF E0 F6 C4 05 7A 0F 83 F9 01 75 0E DD D8 DD 05 ?? ?? ?? ?? EB 04 DD D8 D9 E8 8B 45 18 DD 18 33 C0 5D C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "__CIcos_pentium4"
		size = 428
		refs = "0039 PI32INV 0045 SHIFTER 0055 P_1 0061 P_2 007e SC_4 0084 ___acrt_cos_sin_ctable 0099 P_3 00be SC_2 0103 SC_3 010f SC_1 018e ONE 01a5 __cos_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 42 01 00 00 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C8 66 0F 12 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA 66 0F 12 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 66 0F 12 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB 66 0F 12 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 F2 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 66 0F 12 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE 83 EC 10 F2 0F 58 E1 66 0F 13 64 24 04 DD 44 24 04 83 C4 10 C3 7F 2B 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 83 EC 10 66 0F 12 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 13 4C 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 8D 49 00 }
	condition:
		$1
}

rule file_194_5_0 {
	meta:
		name = "__mbsnicoll_l"
		size = 239
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0031 __errno 003c __invalid_parameter_noinfo 0077 __strnicoll_l 008a __mbsnbcnt_l 00bb ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 53 57 FF 75 14 E8 ?? ?? ?? ?? 8B 5D 10 85 DB 75 07 33 FF E9 B4 00 00 00 8B 4D 08 85 C9 74 06 83 7D 0C 00 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BF FF FF FF 7F E9 8D 00 00 00 BF FF FF FF 7F 3B DF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 72 8B 45 F8 83 78 08 00 75 14 FF 75 14 53 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 10 8B F8 EB 55 56 8D 45 F4 50 53 51 E8 ?? ?? ?? ?? 8B F0 8D 45 F4 50 53 FF 75 0C E8 ?? ?? ?? ?? 8B 4D F8 FF 71 04 50 FF 75 0C 8D 45 F4 56 FF 75 08 68 01 10 00 00 FF B1 1C 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 38 5E 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 78 FE 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C7 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "_expm1l"
		size = 207
		refs = "000a __ldtest 0030 __real@bfe62e42fefa39ef 003d __real@3fd9f323ecbf984c 004c __real@3ec5ca73dff66ede 0054 __real@3f1da2e7e515ea71 005c __real@3f51de97c5b063b2 0064 __real@3f9c8391e0c43166 006c __real@3fa41a22f5c5081f 0074 __real@3fed9093fe30efd3 007e __real@3ef26c937b07e563 0084 __real@3f43d31708605728 008c __real@3f83945deb77150f 0094 __real@3fb5d013b98b14b0 009c __real@3fdb0d4f9f784ed1 00ab __CIexp 00b1 __real@3ff0000000000000 00c4 __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 B1 00 00 00 83 E8 01 0F 84 95 00 00 00 83 E8 01 0F 84 9F 00 00 00 DD 45 08 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 6F DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 60 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? DC C1 D9 C2 DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? D8 CB DC 25 ?? ?? ?? ?? D8 CB DC 05 ?? ?? ?? ?? D8 CB DC 25 ?? ?? ?? ?? D8 CB DE C1 DE F9 DE C9 5D C3 E8 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 5D C3 B8 00 80 00 00 66 85 45 0E 74 08 DD 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "_expm1"
		size = 207
		refs = "000a __dtest 0030 __real@bfe62e42fefa39ef 003d __real@3fd9f323ecbf984c 004c __real@3ec5ca73dff66ede 0054 __real@3f1da2e7e515ea71 005c __real@3f51de97c5b063b2 0064 __real@3f9c8391e0c43166 006c __real@3fa41a22f5c5081f 0074 __real@3fed9093fe30efd3 007e __real@3ef26c937b07e563 0084 __real@3f43d31708605728 008c __real@3f83945deb77150f 0094 __real@3fb5d013b98b14b0 009c __real@3fdb0d4f9f784ed1 00ab __CIexp 00b1 __real@3ff0000000000000 00c4 __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 B1 00 00 00 83 E8 01 0F 84 95 00 00 00 83 E8 01 0F 84 9F 00 00 00 DD 45 08 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 6F DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 60 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? DC C1 D9 C2 DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? D8 CB DC 25 ?? ?? ?? ?? D8 CB DC 05 ?? ?? ?? ?? D8 CB DC 25 ?? ?? ?? ?? D8 CB DE C1 DE F9 DE C9 5D C3 E8 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 5D C3 B8 00 80 00 00 66 85 45 0E 74 08 DD 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "_lrint"
		size = 124
		refs = "000c __dtest 0026 _nearbyint 0041 __fperrraise 004b __real@c1e0000000000000 0058 __real@41dfffffffc00000 0066 __ftol2_sse"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0C DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "_lrintl"
		size = 124
		refs = "000c __ldtest 0026 _nearbyintl 0041 __fperrraise 004b __real@c1e0000000000000 0058 __real@41dfffffffc00000 0066 __ftol2_sse"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0C DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "__mbstok_l"
		size = 33
		refs = "0009 ___acrt_getptd 0018 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "__CIacos_pentium4"
		size = 1364
		refs = "0022 ABSVALMASK 002a ONEMASK 0036 TMASK 0094 ___acrt_acos_asin_t_table 00a1 ___acrt_acos_asin_tbl_addr 00cd cv 0113 PI_BY_2 01dc NEG_PI 0299 cv2 033f ONE_BY_2 0386 HALFMASK 04bf ___libm_error_support 04f4 PI"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 D6 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 F8 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E FE 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 C1 83 EC 10 66 0F 57 E2 F2 0F 59 EB 66 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 C6 F2 0F 59 C3 F2 0F 5C EC 66 0F 70 E4 EE F2 0F 58 C5 F2 0F 5C C7 F2 0F 5C C4 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D BB 03 00 00 83 F8 41 0F 83 2D 01 00 00 66 0F 73 D7 26 66 0F 73 F7 26 66 0F D7 C0 66 0F 55 E0 F2 0F 5C CF F2 0F 10 F7 F2 0F 59 FF F2 0F 58 C6 66 0F 56 EC F2 0F 5C DF F2 0F 59 C1 F2 0F 10 E3 F2 0F 5C D8 F2 0F 51 DB 25 80 00 00 00 C1 E8 07 F7 D8 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 66 0F 6E D8 66 0F 70 DB 00 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 66 0F 54 1D ?? ?? ?? ?? F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 58 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 F2 0F 59 C6 F2 0F 59 CE 83 EC 10 F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB F2 0F 58 C5 25 00 80 00 00 66 0F C4 F0 03 F2 0F 10 EC 66 0F 70 DB EE F2 0F 58 E3 F2 0F 5C DC F2 0F 58 EB F2 0F 58 C5 F2 0F 58 C4 66 0F 57 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 BB 3B 00 00 3D 00 38 00 00 0F 83 90 00 00 00 66 0F 14 C0 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 C0 66 0F 28 2D ?? ?? ?? ?? 83 EC 10 66 0F 59 C8 66 0F 59 F0 66 0F 59 C0 F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E0 F2 0F 59 CB 66 0F 58 F4 66 0F 70 C5 EE 66 0F 59 CE 66 0F 70 F5 EE F2 0F 5C C7 66 0F 70 D1 EE F2 0F 5C E9 F2 0F 5C F0 F2 0F 5C EA F2 0F 5C FE F2 0F 5C EF F2 0F 58 C5 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D FC 3B 00 00 83 F8 04 0F 83 F4 00 00 00 66 0F 57 F6 66 0F 54 3D ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 FC 66 0F 28 15 ?? ?? ?? ?? F2 0F 5C E7 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 FC 44 F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 12 0D ?? ?? ?? ?? 66 0F 59 DF F2 0F C2 C6 01 F2 0F 59 FD 66 0F 58 D3 66 0F 70 C0 44 F2 0F 59 D7 66 0F 54 05 ?? ?? ?? ?? 66 0F 59 D5 66 0F 54 CC 66 0F 70 DC 44 F2 0F 5C E1 F2 0F 58 DB F2 0F 59 C9 F2 0F 5C DC F2 0F 5C E9 F2 0F 59 E3 66 0F 70 DB EE F2 0F 5C EC F2 0F 5E EB 83 EC 10 66 0F 58 DB 66 0F 59 D3 66 0F 70 E2 EE F2 0F 58 D0 25 00 80 00 00 66 0F C4 F0 03 66 0F 70 C0 EE F2 0F 58 D4 F2 0F 58 D5 F2 0F 58 D3 F2 0F 58 C2 66 0F 57 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 FC FE 03 00 3D 00 FF 03 00 0F 82 EA 00 00 00 66 0F 7E F9 66 0F 73 D7 20 66 0F 7E FA 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 0F 84 85 00 00 00 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 0F 8D BF 00 00 00 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 BA 3A 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F C5 D7 01 C1 EA 0F F7 DA 66 0F 6E FA 66 0F 70 FF 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 66 0F 54 D7 66 0F 54 C7 F2 0F 58 C2 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 58 C2 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 57 F6 F2 0F 58 C6 BA F0 03 00 00 E9 4A FF FF FF }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "_lround"
		size = 93
		refs = "000a __dtest 0024 _round 002d __real@c1e0000000000000 003c __real@41dfffffffc00000 004b __ftol2_sse 0054 __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 45 7E 05 83 F8 02 7E 36 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 08 DC 15 ?? ?? ?? ?? DF E0 59 59 F6 C4 01 75 15 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 06 5D E9 ?? ?? ?? ?? DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 5D C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "_lroundl"
		size = 93
		refs = "000a __ldtest 0024 _roundl 002d __real@c1e0000000000000 003c __real@41dfffffffc00000 004b __ftol2_sse 0054 __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 45 7E 05 83 F8 02 7E 36 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 08 DC 15 ?? ?? ?? ?? DF E0 59 59 F6 C4 01 75 15 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 06 5D E9 ?? ?? ?? ?? DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 5D C3 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "__ismbcupper_l"
		size = 83
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0038 ___dcrt_multibyte_check_type"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 0C E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 77 10 8B 45 F8 0F B6 44 08 19 C1 E8 04 83 E0 01 EB 11 6A 01 6A 01 8D 45 F4 50 51 E8 ?? ?? ?? ?? 83 C4 10 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "__CItan_default"
		size = 171
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003e ___fastflag 0045 __fast_exit 0050 _NAME_ 0055 __math_exit 005b __pi_by_2_to_61 0083 __indefinite 00a5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4D 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 F2 9B DF E0 9E 7A 1F DD D8 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 F2 DD D8 EB CB A9 FF FF 0F 00 75 31 83 7C 24 08 00 75 2A DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 712
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_204_3_0 {
	meta:
		name = "??$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z"
		size = 310
		refs = "0023 __errno 002d __invalid_parameter_noinfo 003a ___acrt_initialize_multibyte 0044 ?program_name@?1???$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z@4PADA 004e __imp__GetModuleFileNameA@12 0053 __acmdln 0059 __pgmptr 0080 ??$parse_command_line@D@@YAXPADPAPAD0PAI2@Z 008d ___acrt_allocate_buffer_for_argv 00cb ___argc 00d4 ___argv 00e5 ___acrt_expand_narrow_argv_wildcards 011e __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 85 DB 75 07 33 C0 E9 1A 01 00 00 56 83 FB 02 74 1B 83 FB 01 74 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 F8 00 00 00 57 E8 ?? ?? ?? ?? 68 04 01 00 00 BE ?? ?? ?? ?? 33 FF 56 57 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 45 F0 85 C0 74 05 80 38 00 75 05 8B C6 89 75 F0 8D 4D F4 89 7D FC 51 8D 4D FC 89 7D F4 51 57 57 50 E8 ?? ?? ?? ?? 6A 01 FF 75 F4 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C4 20 85 F6 75 0C E8 ?? ?? ?? ?? 6A 0C 5F 89 38 EB 32 8D 45 F4 50 8D 45 FC 50 8B 45 FC 8D 04 86 50 56 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 14 83 FB 01 75 16 8B 45 FC 48 A3 ?? ?? ?? ?? 8B C6 8B F7 A3 ?? ?? ?? ?? 8B DF EB 4A 8D 45 F8 89 7D F8 50 56 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 74 05 8B 45 F8 EB 26 8B 55 F8 8B CF 8B C2 39 3A 74 08 8D 40 04 41 39 38 75 F8 8B C7 89 0D ?? ?? ?? ?? 89 45 F8 8B DF 89 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 7D F8 56 E8 ?? ?? ?? ?? 59 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_4_0 {
	meta:
		name = "??$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z"
		size = 305
		refs = "0023 __errno 002d __invalid_parameter_noinfo 003f ?program_name@?1???$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z@4PA_WA 0049 __imp__GetModuleFileNameW@12 004e __wcmdln 0054 __wpgmptr 007b ??$parse_command_line@_W@@YAXPA_WPAPA_W0PAI2@Z 0088 ___acrt_allocate_buffer_for_argv 00c6 ___argc 00cf ___wargv 00e0 ___acrt_expand_wide_argv_wildcards 0119 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 85 DB 75 07 33 C0 E9 15 01 00 00 56 83 FB 02 74 1B 83 FB 01 74 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 F3 00 00 00 57 68 04 01 00 00 BE ?? ?? ?? ?? 33 FF 56 57 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 45 F0 85 C0 74 05 66 39 38 75 05 8B C6 89 75 F0 8D 4D F4 89 7D FC 51 8D 4D FC 89 7D F4 51 57 57 50 E8 ?? ?? ?? ?? 6A 02 FF 75 F4 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C4 20 85 F6 75 0C E8 ?? ?? ?? ?? 6A 0C 5F 89 38 EB 32 8D 45 F4 50 8D 45 FC 50 8B 45 FC 8D 04 86 50 56 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 14 83 FB 01 75 16 8B 45 FC 48 A3 ?? ?? ?? ?? 8B C6 8B F7 A3 ?? ?? ?? ?? 8B DF EB 4A 8D 45 F8 89 7D F8 50 56 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 74 05 8B 45 F8 EB 26 8B 55 F8 8B CF 8B C2 39 3A 74 08 8D 40 04 41 39 38 75 F8 8B C7 89 0D ?? ?? ?? ?? 89 45 F8 8B DF 89 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 7D F8 56 E8 ?? ?? ?? ?? 59 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_5_0 {
	meta:
		name = "??$get_module_file_name@$$TAAY0BAF@DH@?$__crt_char_traits@D@@SAK$$QA$$TAAY0BAF@D$$QAH@Z"
		size = 26
		refs = "0014 __imp__GetModuleFileNameA@12"
		altNames = "??$get_module_file_name@AAPAUHINSTANCE__@@AAY0BAF@DK@?$__crt_char_traits@D@@SAKAAPAUHINSTANCE__@@AAY0BAF@D$$QAK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_204_6_0 {
	meta:
		name = "??$get_module_file_name@$$TAAY0BAF@_WH@?$__crt_char_traits@_W@@SAK$$QA$$TAAY0BAF@_W$$QAH@Z"
		size = 26
		refs = "0014 __imp__GetModuleFileNameW@12"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_681_14_0 {
	meta:
		name = "??$get_module_file_name@AAPAUHINSTANCE__@@AAY0BAF@_WK@?$__crt_char_traits@_W@@SAKAAPAUHINSTANCE__@@AAY0BAF@_W$$QAK@Z"
		size = 26
		refs = "0014 __imp__GetModuleFileNameW@12"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 08 FF 75 0C FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_204_7_0 {
	meta:
		name = "??$parse_command_line@D@@YAXPADPAPAD0PAI2@Z"
		size = 373
		refs = "005a __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 14 53 8B 5D 18 56 8B 75 08 57 83 23 00 8B 7D 10 C7 00 01 00 00 00 8B 45 0C 85 C0 74 08 89 38 83 C0 04 89 45 0C 32 C9 88 4D FF 80 3E 22 75 0D 84 C9 B0 22 0F 94 C1 46 88 4D FF EB 35 FF 03 85 FF 74 05 8A 06 88 07 47 8A 06 46 88 45 FE 0F BE C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 0C FF 03 85 FF 74 05 8A 06 88 07 47 46 8A 45 FE 84 C0 74 19 8A 4D FF 84 C9 75 B5 3C 20 74 04 3C 09 75 AD 85 FF 74 07 C6 47 FF 00 EB 01 4E C6 45 FF 00 80 3E 00 0F 84 C2 00 00 00 8A 06 3C 20 74 04 3C 09 75 03 46 EB F3 80 3E 00 0F 84 AC 00 00 00 8B 4D 0C 85 C9 74 08 89 39 83 C1 04 89 4D 0C 8B 45 14 FF 00 33 D2 42 33 C0 EB 02 46 40 80 3E 5C 74 F9 80 3E 22 75 31 A8 01 75 1E 8A 4D FF 84 C9 74 0F 8D 4E 01 80 39 22 75 04 8B F1 EB 0B 8A 4D FF 33 D2 84 C9 0F 94 45 FF D1 E8 EB 0B 48 85 FF 74 04 C6 07 5C 47 FF 03 85 C0 75 F1 8A 06 84 C0 74 3B 80 7D FF 00 75 08 3C 20 74 31 3C 09 74 2D 85 D2 74 23 85 FF 74 03 88 07 47 0F BE 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 0C 46 FF 03 85 FF 74 05 8A 06 88 07 47 FF 03 46 E9 77 FF FF FF 85 FF 74 04 C6 07 00 47 FF 03 E9 35 FF FF FF 8B 4D 0C 5F 5E 5B 85 C9 74 03 83 21 00 8B 45 14 FF 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_8_0 {
	meta:
		name = "??$parse_command_line@_W@@YAXPA_WPAPA_W0PAI2@Z"
		size = 390
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 83 EC 10 8B 4D 08 8B 55 10 53 56 8B 75 0C 33 DB 57 8B 7D 18 89 1F C7 00 01 00 00 00 85 F6 74 08 89 16 83 C6 04 89 75 0C C7 45 F8 20 00 00 00 C7 45 F4 09 00 00 00 6A 22 58 66 39 01 75 0A 84 DB 0F 94 C3 83 C1 02 EB 1A FF 07 85 D2 74 09 66 8B 01 66 89 02 83 C2 02 0F B7 01 83 C1 02 66 85 C0 74 1F 84 DB 75 D0 66 3B 45 F8 74 09 66 3B 45 F4 6A 22 58 75 C4 85 D2 74 0B 33 C0 66 89 42 FE EB 03 83 E9 02 8B 5D 14 33 C0 88 45 FF 66 39 01 0F 84 DA 00 00 00 0F B7 01 66 3B 45 F8 74 06 66 3B 45 F4 75 05 83 C1 02 EB EC 33 C0 66 39 01 0F 84 BB 00 00 00 85 F6 74 08 89 16 83 C6 04 89 75 0C FF 03 33 DB 6A 5C 5E C7 45 F0 01 00 00 00 8B C3 EB 04 83 C1 02 40 66 39 31 74 F7 6A 22 5E 66 39 31 6A 5C 5E 75 38 A8 01 75 20 38 5D FF 74 11 6A 22 5E 66 39 71 02 6A 5C 5E 75 05 83 C1 02 EB 0A 38 5D FF 89 5D F0 0F 94 45 FF 8B 7D 18 D1 E8 EB 0D 48 85 D2 74 06 66 89 32 83 C2 02 FF 07 85 C0 75 EF 0F B7 01 66 85 C0 74 2A 38 5D FF 75 0C 66 3B 45 F8 74 1F 66 3B 45 F4 74 19 39 5D F0 74 0C 85 D2 74 06 66 89 02 83 C2 02 FF 07 83 C1 02 E9 73 FF FF FF 8B 75 0C 8B 5D 14 85 D2 74 08 33 C0 66 89 02 83 C2 02 FF 07 33 C0 E9 1D FF FF FF 85 F6 74 02 89 06 FF 03 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_9_0 {
	meta:
		name = "??$set_program_name@PAD@?$__crt_char_traits@D@@SAX$$QAPAD@Z"
		size = 17
		refs = "000b __pgmptr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_204_10_0 {
	meta:
		name = "??$set_program_name@PA_W@?$__crt_char_traits@_W@@SAX$$QAPA_W@Z"
		size = 17
		refs = "000b __wpgmptr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_204_42_0 {
	meta:
		name = "?should_copy_another_character@@YA_ND@Z"
		size = 24
		refs = "000b __ismbblead"
		altNames = "?is_lead_byte@@YA_ND@Z"
	strings:
		$1 = { 8B FF 55 8B EC 0F BE 45 08 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_204_44_0 {
	meta:
		name = "___acrt_allocate_buffer_for_argv"
		size = 85
		refs = "003f __calloc_base 0048 __free_base"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 81 FE FF FF FF 3F 72 04 33 C0 EB 3D 57 83 CF FF 8B 4D 0C 33 D2 8B C7 F7 75 10 3B C8 73 0D 0F AF 4D 10 C1 E6 02 2B FE 3B F9 77 04 33 C0 EB 19 8D 04 31 6A 01 50 E8 ?? ?? ?? ?? 6A 00 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5F 5E 5D C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__LHypot"
		size = 423
		refs = "0014 __ldunscale 0103 __ldscale 0145 __real@3ff0000000000000 014a __CIsqrt 0164 __real@4000000000000000 017c __real@3ff6a09e667f3bcd 0185 __real@3eec713e5d623e2b 018e __real@4003504816f0068e 019c __LInf_C"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 45 08 53 56 57 50 8D 45 F8 50 E8 ?? ?? ?? ?? 0F B7 F8 8D 45 10 50 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 75 18 33 C9 41 0F B7 C0 83 C4 10 83 26 00 66 3B F9 0F 84 5A 01 00 00 66 3B C1 0F 84 51 01 00 00 6A 02 5B 66 3B FB 75 08 DD 45 08 E9 47 01 00 00 66 3B C3 75 08 DD 45 10 E9 3A 01 00 00 D9 EE DD 45 08 D8 D1 DF E0 F6 C4 05 7A 05 D9 E0 DD 55 08 DD 45 10 D8 D2 DF E0 F6 C4 05 7A 05 D9 E0 DD 55 10 DD E2 DF E0 F6 C4 44 7A 15 DD D8 DD E9 DF E0 F6 C4 44 0F 8B FE 00 00 00 66 8B 4D F8 EB 3B 66 8B 4D F8 D9 CA DD E9 DF E0 F6 C4 44 7B 11 66 3B 4D FC 7C 0B 75 22 D8 D1 DF E0 F6 C4 05 7A 19 D9 C9 66 8B C1 66 8B 4D FC DD 5D 08 66 89 4D F8 DD 5D 10 66 89 45 FC EB 04 DD D8 DD D8 0F BF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 03 C0 89 06 75 02 89 1E 2B 0E 8D 45 08 51 50 E8 ?? ?? ?? ?? 0F BF 45 FC 2B 06 50 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 08 83 C4 10 D9 C0 DD 45 10 DC E9 D9 C9 DD E2 DF E0 F6 C4 44 7B 65 D8 D1 DF E0 F6 C4 41 75 21 DD D8 DE F9 DD 55 F0 D9 C0 DE C9 DC 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 45 F0 DC 7D 10 DC 45 08 EB 47 DD DA DE F9 DD 55 E8 D9 C0 DD 05 ?? ?? ?? ?? DC C1 D9 C9 DE CA D9 C9 DD 55 F0 DE C1 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DC 7D F0 DC 05 ?? ?? ?? ?? DC 45 E8 DC 05 ?? ?? ?? ?? EB BD DD D9 DD D9 EB 06 DD 05 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__Hypot"
		size = 423
		refs = "0014 __dunscale 0103 __dscale 0145 __real@3ff0000000000000 014a __CIsqrt 0164 __real@4000000000000000 017c __real@3ff6a09e667f3bcd 0185 __real@3eec713e5d623e2b 018e __real@4003504816f0068e 019c __Inf_C"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 45 08 53 56 57 50 8D 45 F8 50 E8 ?? ?? ?? ?? 0F B7 F8 8D 45 10 50 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 75 18 33 C9 41 0F B7 C0 83 C4 10 83 26 00 66 3B F9 0F 84 5A 01 00 00 66 3B C1 0F 84 51 01 00 00 6A 02 5B 66 3B FB 75 08 DD 45 08 E9 47 01 00 00 66 3B C3 75 08 DD 45 10 E9 3A 01 00 00 D9 EE DD 45 08 D8 D1 DF E0 F6 C4 05 7A 05 D9 E0 DD 55 08 DD 45 10 D8 D2 DF E0 F6 C4 05 7A 05 D9 E0 DD 55 10 DD E2 DF E0 F6 C4 44 7A 15 DD D8 DD E9 DF E0 F6 C4 44 0F 8B FE 00 00 00 66 8B 4D F8 EB 3B 66 8B 4D F8 D9 CA DD E9 DF E0 F6 C4 44 7B 11 66 3B 4D FC 7C 0B 75 22 D8 D1 DF E0 F6 C4 05 7A 19 D9 C9 66 8B C1 66 8B 4D FC DD 5D 08 66 89 4D F8 DD 5D 10 66 89 45 FC EB 04 DD D8 DD D8 0F BF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 03 C0 89 06 75 02 89 1E 2B 0E 8D 45 08 51 50 E8 ?? ?? ?? ?? 0F BF 45 FC 2B 06 50 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 08 83 C4 10 D9 C0 DD 45 10 DC E9 D9 C9 DD E2 DF E0 F6 C4 44 7B 65 D8 D1 DF E0 F6 C4 41 75 21 DD D8 DE F9 DD 55 F0 D9 C0 DE C9 DC 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 45 F0 DC 7D 10 DC 45 08 EB 47 DD DA DE F9 DD 55 E8 D9 C0 DD 05 ?? ?? ?? ?? DC C1 D9 C9 DE CA D9 C9 DD 55 F0 DE C1 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DC 7D F0 DC 05 ?? ?? ?? ?? DC 45 E8 DC 05 ?? ?? ?? ?? EB BD DD D9 DD D9 EB 06 DD 05 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "_csqrtl"
		size = 470
		refs = "0017 _creall 0028 _cimagl 0034 __ldtest 0076 __LHypot 00aa _ldexp 00b6 __real@4000000000000000 00bb __CIsqrt 0184 __LInf_C 01a3 __LZero_C 01be __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D EC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 F4 50 DD 5D F4 E8 ?? ?? ?? ?? 33 FF 0F B7 F0 47 83 C4 14 66 3B F7 75 08 DD 45 F4 E9 5B 01 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 59 66 3B C7 0F 84 E9 00 00 00 DD 45 F4 8D 45 FC 50 83 EC 10 DD 5C 24 08 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? 8B 75 FC 83 C4 14 DD 55 E4 85 F6 75 11 DD 45 F4 D8 C9 83 EC 10 DD 5C 24 08 E9 1E 01 00 00 DD D8 8B C6 DD 45 EC F7 D8 50 51 D9 E1 51 DD 1C 24 E8 ?? ?? ?? ?? DC 45 E4 83 C4 0C DC 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 99 2B C2 D1 F8 48 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 EC 83 C4 0C D9 EE D8 D1 DF E0 DD D9 F6 C4 41 7A 0F DD D8 D9 C0 DC 0D ?? ?? ?? ?? DC 7D F4 EB 98 B8 00 80 00 00 83 EC 10 66 85 45 FA 74 1A DD D8 D9 C0 D9 E0 DD 5C 24 08 DC 0D ?? ?? ?? ?? DC 7D F4 D9 E0 E9 9A 00 00 00 DD 45 F4 DD E1 DF E0 F6 C4 44 8D 45 DC 7A 0D DD D8 D9 C9 DD 5C 24 08 E9 81 00 00 00 DD D9 D9 C9 DD 54 24 08 DC 0D ?? ?? ?? ?? DE F9 EB 6F D9 EE 66 83 FE 02 75 21 DD 45 EC D8 D1 DF E0 DD D9 F6 C4 05 7A 0C 83 EC 10 DD 5C 24 08 DD 45 F4 EB 4A DD D8 8D 75 0C EB 54 DC 55 EC DF E0 F6 C4 41 B8 00 80 00 00 75 17 DD 05 ?? ?? ?? ?? 66 85 45 FA 0F 84 FA FE FF FF D9 E0 E9 F3 FE FF FF 66 85 45 FA 74 0A DD D8 DD 05 ?? ?? ?? ?? D9 E0 83 EC 10 DD 5C 24 08 DD 05 ?? ?? ?? ?? 8D 45 DC DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 14 8B F0 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_206_2_0 {
	meta:
		name = "_ldexpl"
		size = 26
		refs = "0011 _ldexp"
		altNames = "__scalb"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_crealf"
		size = 41
		refs = "0009 ___security_cookie 0021 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D FC 8B 45 08 33 CD 89 45 F4 D9 45 F4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_209_16_0 {
	meta:
		name = "?set_buffer@@YAHV__crt_stdio_stream@@QADIH@Z"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 14 83 C0 0C F0 09 08 8B 4D 08 8B 45 10 89 41 18 8B 45 08 8B 4D 0C 89 08 8B 45 08 89 48 04 8B 45 08 83 60 08 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_209_20_0 {
	meta:
		name = "_setvbuf"
		size = 118
		refs = "0013 __errno 001e __invalid_parameter_noinfo 006c ??$__acrt_lock_stream_and_call@V<lambda_ca71763b3c0644891230e4f79ea54fa6>@@@@YAHQAU_iobuf@@$$QAV<lambda_ca71763b3c0644891230e4f79ea54fa6>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 4D 08 89 4D FC 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4B 8B 45 10 83 F8 04 74 09 85 C0 74 0E 83 F8 40 75 DA 85 C0 74 05 83 F8 40 75 0D 8B 45 14 83 C0 FE 3D FD FF FF 7F 77 C4 8D 45 14 89 45 EC 8D 45 FC 89 45 F0 8D 45 10 89 45 F4 8D 45 0C 89 45 F8 8D 45 EC 50 51 E8 ?? ?? ?? ?? 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_4_0 {
	meta:
		name = "__mbsnbset_s_l"
		size = 529
		refs = "004a ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 005f __strnset_s 01c7 __errno 01d1 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 56 33 DB 57 8B 7D 14 89 5D F8 89 5D FC 85 FF 75 15 39 5D 08 75 19 39 5D 0C 0F 85 D1 01 00 00 33 C0 E9 DB 01 00 00 39 5D 08 0F 84 C1 01 00 00 8B 75 0C 85 F6 0F 84 B6 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 55 E8 39 5A 08 75 17 57 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 7A 01 00 00 8B 45 10 8B 7D 08 8B CF C1 E8 08 89 45 F4 84 C0 0F 84 B6 00 00 00 38 5D 10 0F 84 BA 00 00 00 0F B6 C0 F6 44 10 19 04 0F 84 AC 00 00 00 8B 55 14 F6 C2 01 74 08 4A C7 45 F8 01 00 00 00 D1 EA 38 1F 0F 84 D5 00 00 00 85 D2 0F 84 D1 00 00 00 83 EE 01 0F 84 C4 00 00 00 8D 41 01 80 38 00 89 45 F0 74 5D 83 7D FC 00 74 04 8B C3 EB 11 8B 7D E8 0F B6 01 0F B6 44 38 19 8B 7D 08 83 E0 04 8B 5D F4 88 19 8B 4D F0 89 45 FC 6A 00 5B 83 EE 01 0F 84 87 00 00 00 85 C0 74 05 89 5D FC EB 14 8B 7D E8 0F B6 01 0F B6 44 38 19 8B 7D 08 83 E0 04 89 45 FC 8B 45 10 88 01 41 4A 80 39 00 75 89 EB 5C 88 19 46 C7 45 F8 01 00 00 00 EB 50 8B 45 10 0F B6 C0 F6 44 10 19 04 74 07 88 1F E9 90 00 00 00 8B 55 14 38 1F 74 35 8B 7D E8 8B 45 10 85 D2 74 28 83 EE 01 74 23 39 5D FC 74 05 89 5D FC EB 11 0F B6 01 0F B6 44 38 19 83 E0 04 89 45 FC 8B 45 10 88 01 41 4A 38 19 75 D4 8B 7D 08 85 D2 75 33 83 7D FC 00 74 28 80 39 00 74 28 83 EE 01 74 1E 80 79 01 00 C7 45 F8 01 00 00 00 75 05 88 19 46 EB 0C C6 01 20 41 EB 06 83 EE 01 74 06 41 80 39 00 75 F5 85 F6 75 13 88 1F E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? EB 10 83 7D F8 00 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D EC 00 74 1B 8B 4D E0 83 A1 50 03 00 00 FD EB 0F E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__heapmin"
		size = 22
		refs = "0004 ___acrt_heap 000a __imp__HeapCompact@8"
	strings:
		$1 = { 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 48 C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "___libm_sse2_log10f"
		size = 377
		refs = "0004 _dword_mask 000c _SIGMASK 0018 _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_Tbl 00cc _L102 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F 6F F8 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "__mbsnbcpy_s_l"
		size = 424
		refs = "003e __errno 0048 __invalid_parameter_noinfo 005c ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0073 _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 14 85 FF 75 0D 85 F6 75 0D 39 75 0C 75 20 33 C0 EB 2D 85 F6 74 18 83 7D 0C 00 76 12 85 FF 75 05 C6 06 00 EB E9 83 7D 10 00 75 1A C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 8B E5 5D C3 53 FF 75 18 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 17 57 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 0F 01 00 00 8B 45 0C 8B CE 8B 55 10 89 45 FC 83 FF FF 75 17 8A 02 88 01 41 42 84 C0 8B 45 FC 74 2B 83 E8 01 89 45 FC 75 EB EB 21 8A 02 88 01 41 42 84 C0 8B 45 FC 74 0D 83 E8 01 89 45 FC 74 05 83 EF 01 75 E6 85 FF 75 03 88 19 41 85 C0 0F 85 87 00 00 00 38 1A 74 05 83 FF 01 75 29 8D 51 FF 8B CA 3B D6 72 14 8B 5D F4 0F B6 01 F6 44 18 19 04 74 05 49 3B CE 73 F1 33 DB 8B C2 2B C1 A8 01 0F 85 81 00 00 00 83 FF FF 75 3D 8B 7D 0C 83 FF 01 76 2C 8D 57 FE 03 D6 8B CA 3B D6 72 15 8B 7D F4 0F B6 01 F6 44 38 19 04 74 05 49 3B CE 73 F1 8B 7D 0C 8B C2 2B C1 A8 01 74 04 88 1A EB 04 88 5C 3E FF 6A 50 5B EB 4B 88 1E E8 ?? ?? ?? ?? 6A 22 5B 89 18 E8 ?? ?? ?? ?? EB 38 8B C1 2B C6 83 F8 02 7C 2F 8D 51 FE 8B CA 3B D6 72 12 8B 7D F4 0F B6 01 F6 44 38 19 04 74 05 49 3B CE 73 F1 8B C2 2B C1 A8 01 74 0C 88 1A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C3 5B E9 A6 FE FF FF }
	condition:
		$1
}

rule file_214_10_0 {
	meta:
		name = "??$parse_integer_from_string@KDPAPAD@__crt_strtox@@YAKQBDQAPADHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "__strtoul_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_11_0 {
	meta:
		name = "??$parse_integer_from_string@K_WPAPA_W@__crt_strtox@@YAKQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_14_0 {
	meta:
		name = "??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_15_2 {
	meta:
		name = "??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_52_4 {
	meta:
		name = "__strtoui64_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_54_3 {
	meta:
		name = "__strtoull_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_55_3 {
	meta:
		name = "__strtoumax_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0022 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_62_3 {
	meta:
		name = "__wcstoui64_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_63_3 {
	meta:
		name = "__wcstoul_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_64_4 {
	meta:
		name = "__wcstoull_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_65_4 {
	meta:
		name = "__wcstoumax_l"
		size = 45
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0022 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_46_0 {
	meta:
		name = "__strtoi64"
		size = 44
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0021 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "_strtoimax _strtoll"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_56_0 {
	meta:
		name = "__wcstoi64"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_67_0 {
	meta:
		name = "_strtol"
		size = 44
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0021 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_72_2 {
	meta:
		name = "_wcstoimax"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_73_2 {
	meta:
		name = "_wcstol"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_74_2 {
	meta:
		name = "_wcstoll"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_51_0 {
	meta:
		name = "__strtoui64"
		size = 44
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0021 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "_strtoull _strtoumax"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_61_0 {
	meta:
		name = "__wcstoui64"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_69_0 {
	meta:
		name = "_strtoul"
		size = 44
		refs = "0017 ??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z 0021 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_75_2 {
	meta:
		name = "_wcstoul"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_76_2 {
	meta:
		name = "_wcstoull"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_77_2 {
	meta:
		name = "_wcstoumax"
		size = 44
		refs = "0017 ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z 0021 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 FF 75 10 51 51 8B C4 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_7_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPA_WIPAU__crt_locale_pointers@@@Z"
		size = 393
		refs = "0008 ___security_cookie 001b __errno 0025 __invalid_parameter_noinfo 0035 _wcsnlen 0064 ___acrt_LCMapStringW 00e9 __alloca_probe_16 0103 __malloc_base 0158 _wcscpy_s 016f __freea_crt 0181 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 08 85 FF 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 46 01 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 59 59 3B 45 0C 72 07 33 C0 66 89 07 EB D3 8B 45 10 33 F6 8B 00 8B 80 A8 00 00 00 85 C0 74 47 56 56 6A FF 57 68 00 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 85 C0 75 39 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 ED 00 00 00 0F B7 07 83 F8 41 72 0B 83 F8 5A 77 06 83 C0 20 66 89 07 83 C7 02 66 39 37 75 E5 33 C0 E9 CB 00 00 00 39 45 0C 73 11 33 C0 66 89 07 E8 ?? ?? ?? ?? 6A 22 E9 60 FF FF FF 8D 14 00 8D 4A 08 3B D1 1B C0 85 C1 74 48 8D 4A 08 3B D1 1B C0 23 C1 8D 4A 08 3D 00 04 00 00 77 19 3B D1 1B C0 23 C1 E8 ?? ?? ?? ?? 8B F4 85 F6 74 28 C7 06 CC CC 00 00 EB 19 3B D1 1B C0 23 C1 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 0D C7 06 DD DD 00 00 83 C6 08 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 38 EB 3E FF 75 F8 8B 45 10 56 6A FF 57 8B 00 68 00 01 00 00 FF B0 A8 00 00 00 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 11 56 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 EB 0A E8 ?? ?? ?? ?? 6A 2A 5F 89 38 56 E8 ?? ?? ?? ?? 59 8B C7 8D 65 F0 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_13_0 {
	meta:
		name = "__wcslwr"
		size = 106
		refs = "0007 ___acrt_locale_changed_data 0016 __errno 0021 __invalid_parameter_noinfo 005e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 48 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 57 33 FF 8B D0 66 39 38 74 20 56 0F B7 0A 6A 41 5E 66 3B F1 77 0B 83 F9 5A 77 06 83 C1 20 66 89 0A 83 C2 02 66 39 3A 75 E2 5E 5F 5D C3 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__controlfp_s"
		size = 95
		refs = "0027 __control87 0030 __errno 003a __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 8B 45 0C 81 E1 FF FF F7 FF 23 C1 56 8B 75 08 A9 E0 FC F0 FC 74 24 85 F6 74 0D 6A 00 6A 00 E8 ?? ?? ?? ?? 59 59 89 06 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 1A 51 FF 75 0C 85 F6 74 09 E8 ?? ?? ?? ?? 89 06 EB 05 E8 ?? ?? ?? ?? 59 59 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_217_4_0 {
	meta:
		name = "__wcsnicoll"
		size = 208
		refs = "0008 ___acrt_locale_changed_data 001d __errno 0028 __invalid_parameter_noinfo 00c3 __wcsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 56 57 0F 85 A2 00 00 00 8B 55 08 85 D2 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 94 00 00 00 8B 4D 0C 85 C9 74 DF 8B 7D 10 BE FF FF FF 7F 3B FE 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 6D 53 6A 41 5B 6A 5A 5E 2B D1 89 75 FC EB 03 6A 5A 5E 0F B7 04 0A 66 3B C3 72 0D 66 3B C6 77 08 83 C0 20 0F B7 F0 EB 02 8B F0 0F B7 01 66 3B C3 72 0C 66 3B 45 FC 77 06 83 C0 20 0F B7 C0 83 C1 02 83 EF 01 74 0A 66 85 F6 74 05 66 3B F0 74 BF 0F B7 C8 0F B7 C6 2B C1 5B EB 13 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_217_5_0 {
	meta:
		name = "__wcsnicoll_l"
		size = 301
		refs = "001e __errno 0029 __invalid_parameter_noinfo 007f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 00f9 ___acrt_CompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 10 85 DB 75 07 33 C0 E9 11 01 00 00 83 7D 08 00 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 F1 00 00 00 57 8B 7D 0C 85 FF 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 CE 00 00 00 56 BE FF FF FF 7F 3B DE 76 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 AC 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 8B 80 A4 00 00 00 85 C0 75 5C 8B 45 08 2B C7 6A 41 89 45 08 5E 0F B7 04 38 6A 5A 5A 66 3B C6 72 0D 66 3B C2 77 08 83 C0 20 0F B7 C8 EB 02 8B C8 0F B7 07 66 3B C6 72 0D 66 3B C2 77 08 83 C0 20 0F B7 D0 EB 02 8B D0 83 C7 02 83 EB 01 74 0D 66 85 C9 74 08 8B 45 08 66 3B CA 74 B9 0F B7 C2 0F B7 F1 2B F0 EB 28 53 57 53 FF 75 08 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 70 FE 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C6 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_218_6_0 {
	meta:
		name = "__wperror"
		size = 156
		refs = "0026 _wcstombs_s 0047 __calloc_base 0075 _perror 007c __free_base 0097 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 08 33 DB 85 FF 74 73 66 39 1F 74 6E 68 FF FF FF 7F 57 53 8D 45 FC 89 5D FC 53 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0A 83 F8 16 74 5B 83 F8 22 74 56 39 5D FC 74 4B 56 6A 01 FF 75 FC E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 27 6A FF 57 FF 75 FC 56 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0C 83 F8 16 74 25 83 F8 22 75 09 EB 1E 56 E8 ?? ?? ?? ?? 59 56 E8 ?? ?? ?? ?? 59 5E EB 07 53 E8 ?? ?? ?? ?? 59 5F 5B 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "__libm_sse2_tan_precise"
		size = 624
		refs = "0050 PI32INV 0060 SHIFTER 006c P_1 0078 QQ_2 0086 P_2 00a5 P_3 00c0 ONE 00c9 ___acrt_tan_ctable 00d1 MASK_35 0223 TWO_POW_M55 022b TWO_POW_55 024d __tan_default"
	strings:
		$1 = { 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 13 02 00 00 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 C7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 12 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 66 0F 12 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 66 0F 12 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 66 0F 12 3D ?? ?? ?? ?? F2 0F 59 E6 66 0F 12 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 C3 7F 33 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 28 C3 C3 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 5C C0 C3 8B FF 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "_localeconv"
		size = 42
		refs = "0007 ___acrt_getptd 0017 ___acrt_update_locale_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 48 4C 89 4D FC 8D 4D FC 51 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 8B 80 88 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "_nexttoward"
		size = 347
		refs = "000d __dtest 002b __ldtest 00fa __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8D 45 08 57 50 E8 ?? ?? ?? ?? 59 6A 02 0F B7 F0 BB F0 7F 00 00 5F 66 3B F7 0F 84 1F 01 00 00 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 10 59 66 3B C7 0F 84 06 01 00 00 DD 45 08 DD E1 DF E0 F6 C4 44 0F 8B F4 00 00 00 33 C9 41 66 3B F1 75 24 66 8B 45 0E B9 EF FF 00 00 66 23 C1 C7 45 0A FF FF FF FF 8D 4B FF DD D8 66 0B C1 DD D8 B9 FF FF 00 00 EB 17 66 85 F6 75 1F DE D9 DF E0 F6 C4 05 7A 04 33 C0 EB 05 B8 00 80 00 00 66 89 45 0E 66 89 4D 08 E9 A9 00 00 00 D8 D1 DF E0 D9 EE F6 C4 05 7A 09 D8 D1 DF E0 F6 C4 05 7B 16 D9 CA D8 D9 DF E0 F6 C4 05 7A 46 DE D9 DF E0 F6 C4 05 7A 41 EB 06 DD D9 DD D9 DD D8 66 83 45 08 01 75 72 66 83 45 0A 01 75 6B 66 83 45 0C 01 75 64 66 8B 45 0E 66 40 66 89 45 0E 0F B7 C0 25 FF 7F FF FF 3B C3 75 4E 6A 08 E8 ?? ?? ?? ?? 59 EB 44 DD D8 DD D8 66 8B 45 08 B9 FF FF 00 00 66 03 C1 66 89 45 08 66 3B C1 75 2B 66 8B 45 0A 66 03 C1 66 89 45 0A 66 3B C1 75 1B 66 8B 45 0C 66 03 C1 66 89 45 0C 66 3B C1 75 0B 66 01 4D 0E EB 05 DD D8 DD 5D 08 66 85 5D 0E 5F 5E 5B 75 08 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "_nexttowardl"
		size = 347
		refs = "000d __ldtest 00fa __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8D 45 08 57 50 E8 ?? ?? ?? ?? 59 6A 02 0F B7 F0 BB F0 7F 00 00 5F 66 3B F7 0F 84 1F 01 00 00 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 10 59 66 3B C7 0F 84 06 01 00 00 DD 45 08 DD E1 DF E0 F6 C4 44 0F 8B F4 00 00 00 33 C9 41 66 3B F1 75 24 66 8B 45 0E B9 EF FF 00 00 66 23 C1 C7 45 0A FF FF FF FF 8D 4B FF DD D8 66 0B C1 DD D8 B9 FF FF 00 00 EB 17 66 85 F6 75 1F DE D9 DF E0 F6 C4 05 7A 04 33 C0 EB 05 B8 00 80 00 00 66 89 45 0E 66 89 4D 08 E9 A9 00 00 00 D8 D1 DF E0 D9 EE F6 C4 05 7A 09 D8 D1 DF E0 F6 C4 05 7B 16 D9 CA D8 D9 DF E0 F6 C4 05 7A 46 DE D9 DF E0 F6 C4 05 7A 41 EB 06 DD D9 DD D9 DD D8 66 83 45 08 01 75 72 66 83 45 0A 01 75 6B 66 83 45 0C 01 75 64 66 8B 45 0E 66 40 66 89 45 0E 0F B7 C0 25 FF 7F FF FF 3B C3 75 4E 6A 08 E8 ?? ?? ?? ?? 59 EB 44 DD D8 DD D8 66 8B 45 08 B9 FF FF 00 00 66 03 C1 66 89 45 08 66 3B C1 75 2B 66 8B 45 0A 66 03 C1 66 89 45 0A 66 3B C1 75 1B 66 8B 45 0C 66 03 C1 66 89 45 0C 66 3B C1 75 0B 66 01 4D 0E EB 05 DD D8 DD 5D 08 66 85 5D 0E 5F 5E 5B 75 08 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_222_2_0 {
	meta:
		name = "__CIasin_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 0048 ___fastflag 004f __fast_exit 005a _NAME_ 005f __math_exit 0080 __piby2 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2B D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 3A 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 29 81 E1 00 00 00 80 DD D8 DB 2D ?? ?? ?? ?? 74 C0 D9 E0 EB BC E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "??$__crt_time_elapsed_leap_years@H@@YAHH@Z"
		size = 58
		altNames = "??$__crt_time_elapsed_leap_years@J@@YAJJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 BE 90 01 00 00 57 8D 48 FF 05 2B 01 00 00 99 F7 FE 6A 64 8B F0 8B C1 99 5F F7 FF 5F 2B F0 8B C1 99 83 E2 03 03 C2 C1 F8 02 83 C0 EF 03 C6 5E 5D C3 }
	condition:
		$1
}

rule file_223_3_0 {
	meta:
		name = "??$common_gmtime@J@@YAPAUtm@@QBJ@Z"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_gmtime_s@J@@YAHQAUtm@@QBJ@Z"
		altNames = "__gmtime32"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_223_4_0 {
	meta:
		name = "??$common_gmtime@_J@@YAPAUtm@@QB_J@Z"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "??$common_localtime@J@@YAPAUtm@@QBJ@Z"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "??$common_localtime@_J@@YAPAUtm@@QB_J@Z"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_223_16_0 {
	meta:
		name = "__gmtime64"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_224_11_3 {
	meta:
		name = "__localtime32"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_224_13_2 {
	meta:
		name = "__localtime64"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_223_5_0 {
	meta:
		name = "??$common_gmtime_s@J@@YAHQAUtm@@QBJ@Z"
		size = 282
		refs = "0010 __errno 001a __invalid_parameter_noinfo 0084 ?compute_year@@YAHAAJAA_N@Z 00aa __lpdays 00b1 __days"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B 75 08 85 F6 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 F0 00 00 00 53 8B 5D 0C 83 C8 FF 57 8B FE 6A 09 59 F3 AB 85 DB 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 27 8B 03 89 45 F8 3D 40 57 FF FF 7C 11 6A 07 99 59 3B D1 7C 1A 7F 07 3D CF E1 58 93 76 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 8B C6 E9 9C 00 00 00 8D 45 FF C6 45 FF 00 50 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 7D F8 89 46 14 8B C7 59 59 99 B9 80 51 01 00 F7 F9 89 46 1C 69 C0 80 AE FE FF 03 F8 80 7D FF 00 B8 ?? ?? ?? ?? 75 05 B8 ?? ?? ?? ?? 8B 56 1C 33 C9 41 39 50 04 7D 06 41 39 14 88 7C FA 49 89 4E 10 6A 07 2B 14 88 B9 80 51 01 00 89 56 0C 8B 03 99 F7 F9 59 83 C0 04 83 66 20 00 99 F7 F9 8B C7 B9 10 0E 00 00 89 56 18 99 F7 F9 6A 3C 89 46 08 69 C0 F0 F1 FF FF 59 03 F8 8B C7 99 F7 F9 89 46 04 6B C0 3C 2B F8 33 C0 89 3E 5F 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_223_6_0 {
	meta:
		name = "??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
		size = 333
		refs = "0011 __errno 001b __invalid_parameter_noinfo 0091 ?compute_year@@YAHAA_JAA_N@Z 00aa __alldiv 00b9 __lpdays 00ce __days"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 08 85 F6 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 22 01 00 00 57 6A 09 83 C8 FF 8B FE 59 F3 AB 8B 7D 0C 85 FF 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 33 8B 4F 04 8B 07 89 45 F4 89 4D F8 83 F9 FF 7F 09 7C 17 3D 40 57 FF FF 72 10 6A 07 5A 3B CA 7C 1A 7F 07 3D CF E1 58 93 76 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 8B C6 E9 C4 00 00 00 53 8D 45 FF C6 45 FF 00 50 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 5D F4 59 59 6A 00 89 46 14 B8 80 51 01 00 50 FF 75 F8 53 E8 ?? ?? ?? ?? 89 46 1C B9 80 51 01 00 F7 E9 B9 ?? ?? ?? ?? 2B D8 8B 45 F8 1B C2 80 7D FF 00 89 45 F8 75 05 B9 ?? ?? ?? ?? 8B 56 1C 33 C0 40 39 51 04 7D 06 40 39 14 81 7C FA 48 89 46 10 6A 00 2B 14 81 B8 80 51 01 00 50 89 56 0C FF 77 04 FF 37 E8 ?? ?? ?? ?? 6A 07 83 C0 04 8B 7D F8 59 99 F7 F9 6A 00 B8 10 0E 00 00 89 56 18 50 57 53 E8 ?? ?? ?? ?? B9 10 0E 00 00 89 46 08 F7 E9 6A 00 2B D8 6A 3C 1B FA 57 53 E8 ?? ?? ?? ?? 83 66 20 00 89 46 04 6B C0 3C 2B D8 33 C0 89 1E 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_223_9_0 {
	meta:
		name = "?compute_year@@YAHAAJAA_N@Z"
		size = 99
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 B9 80 1F 86 07 8B 37 8B C6 99 F7 F9 69 C8 80 1F 86 07 8D 14 85 46 00 00 00 2B F1 B9 80 33 E1 01 8B C6 89 37 3B C1 7C 2B 05 80 CC 1E FE 42 89 07 3B C1 7C 1F 05 80 CC 1E FE 42 89 07 3D 00 85 E2 01 7C 0A 42 05 00 7B 1D FE 89 07 EB 06 8B 4D 0C C6 01 01 5F 8B C2 5E 5D C3 }
	condition:
		$1
}

rule file_223_10_0 {
	meta:
		name = "?compute_year@@YAHAA_JAA_N@Z"
		size = 164
		refs = "001c __alldiv 003b ??$__crt_time_elapsed_leap_years@H@@YAHH@Z 0070 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
