#![warn(clippy::cast_abs_to_unsigned)]
#![allow(unused)]

fn main() {
    let x: i32 = -42;
    let y: u32 = x.abs() as u32;
    //~^ cast_abs_to_unsigned
    println!("The absolute value of {x} is {y}");

    let a: i32 = -3;
    let _: usize = a.abs() as usize;
    //~^ cast_abs_to_unsigned
    let _: usize = a.abs() as _;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as usize;
    //~^ cast_abs_to_unsigned

    let a: i64 = -3;
    let _ = a.abs() as usize;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u8;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u16;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u32;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u64;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u128;
    //~^ cast_abs_to_unsigned

    let a: isize = -3;
    let _ = a.abs() as usize;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u8;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u16;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u32;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u64;
    //~^ cast_abs_to_unsigned
    let _ = a.abs() as u128;
    //~^ cast_abs_to_unsigned

    let _ = (x as i64 - y as i64).abs() as u32;
    //~^ cast_abs_to_unsigned
}

#[clippy::msrv = "1.50"]
fn msrv_1_50() {
    let x: i32 = 10;
    assert_eq!(10u32, x.abs() as u32);
}

#[clippy::msrv = "1.51"]
fn msrv_1_51() {
    let x: i32 = 10;
    assert_eq!(10u32, x.abs() as u32);
    //~^ cast_abs_to_unsigned
}
