/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.encodepassword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.encodepassword.EncodePasswordCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;

public class EncodePasswordCommand
extends OptionParsingCommand {
    private static final Map<String, Supplier<PasswordEncoder>> ENCODERS;

    public EncodePasswordCommand() {
        super("encodepassword", "Encode a password for use with Spring Security", (OptionHandler)new EncodePasswordOptionHandler());
    }

    public String getUsageHelp() {
        return "[options] <password to encode>";
    }

    public Collection<HelpExample> getExamples() {
        ArrayList<HelpExample> examples = new ArrayList<HelpExample>();
        examples.add(new HelpExample("To encode a password with the default (bcrypt) encoder", "spring encodepassword mypassword"));
        examples.add(new HelpExample("To encode a password with pbkdf2", "spring encodepassword -a pbkdf2 mypassword"));
        return examples;
    }

    static {
        LinkedHashMap<String, Supplier<PasswordEncoder>> encoders = new LinkedHashMap<String, Supplier<PasswordEncoder>>();
        encoders.put("default", PasswordEncoderFactories::createDelegatingPasswordEncoder);
        encoders.put("bcrypt", BCryptPasswordEncoder::new);
        encoders.put("pbkdf2", Pbkdf2PasswordEncoder::defaultsForSpringSecurity_v5_8);
        ENCODERS = Collections.unmodifiableMap(encoders);
    }
}

